package com.fr.scheduler.cluster;

/**
 * 集群工具类.
 *
 * @author Cloud.Liu
 * created on 2020-09-09
 */
public class FineQuartzClusterUtils {

    private static final FineQuartzClusterUtils INSTANCE = new FineQuartzClusterUtils();
    private String currentNodeId;
    private ClusterMode mode;
    private FineSchedulerClusterProvider provider = FineSchedulerClusterProvider.DEFAULT;

    private FineQuartzClusterUtils() {

    }

    /**
     * 获取集群工具类单例.
     *
     * @return 集群工具类
     * @IncludeIntoJavadoc
     */
    public static FineQuartzClusterUtils getInstance() {
        return INSTANCE;
    }

    /**
     * 获取当前节点ID.
     *
     * @return ID
     * @IncludeIntoJavadoc
     */
    public String getCurrentNodeId() {
        return currentNodeId;
    }

    /**
     * 设置当前节点ID.
     *
     * @param nodeId ID
     */
    public void setCurrentNodeId(String nodeId) {
        this.currentNodeId = nodeId;
    }

    /**
     * 获取集群模式.
     *
     * @return 集群模式
     * @IncludeIntoJavadoc
     */
    public ClusterMode getMode() {
        return mode;
    }

    /**
     * 设置集群模式.
     *
     * @param mode 集群模式
     */
    public void setMode(ClusterMode mode) {
        this.mode = mode;
    }

    /**
     * 是否是集群模式.
     *
     * @return 是否是集群模式
     */
    public boolean isCluster() {
        return mode == ClusterMode.CLUSTER;
    }

    public FineSchedulerClusterProvider getClusterProvider() {
        return provider;
    }

    public void setClusterProvider(FineSchedulerClusterProvider provider) {
        this.provider = provider;
    }

    /**
     * 重置.
     *
     * <p>
     * 关闭节点.
     * </p>
     *
     * @IncludeIntoJavadoc
     */
    public void reset() {
        currentNodeId = null;
        mode = null;
        provider = FineSchedulerClusterProvider.DEFAULT;
    }
}
