//package com.fr.scheduler.cluster;
//
//import com.fr.scheduler.cluster.FineSchedulerClusterConstants;
//import com.fr.scheduler.cluster.FineSchedulerClusterProvider;
//import com.fr.stable.StringUtils;
//import org.jetbrains.annotations.NotNull;
//import redis.clients.jedis.Jedis;
//import redis.clients.jedis.JedisPubSub;
//
//import java.util.concurrent.TimeUnit;
//import java.util.concurrent.locks.Condition;
//import java.util.concurrent.locks.Lock;
//
///**
// * 基于Redis的{@link FineSchedulerClusterProvider}典型实现.
// *
// * @author Cloud.Liu
// * created on 2020-10-20
// */
//public class ClusterImpl implements FineSchedulerClusterProvider {
//
//    /**
//     * 订阅频道前缀.
//     */
//    private static final String CHANNEL = "/FineSchedulerCluster/";
//
//    /**
//     * 分割{@link FineSchedulerClusterProvider#notify(String, long)}实际发送Message中的nodeId和time.
//     */
//    private static final String MESSAGE_SEPARATOR = FineSchedulerClusterConstants.SEPARATOR_NODE_ID;
//
//    /**
//     * 用来存放所有nodeId的Redis集合.
//     */
//    private static final String ALL_NODE_SET_KEY = "FineSchedulerAllNodes";
//
//    /**
//     * 获取Jedis客户端.
//     *
//     * @return Jedis客户端.
//     */
//    public static Jedis getJedis() {
//        // 这里返回Redis的Jedis客户端
//        return null;
//    }
//
//    private JedisPubSub sub;
//
//    /**
//     * {@inheritDoc}
//     */
//    @Override
//    public void register(String nodeId) {
//        // 订阅频道
//        sub = new JedisPubSub() {
//            @Override
//            public void onMessage(String channel, String message) {
//                String[] param = message.split(MESSAGE_SEPARATOR);
//                if (StringUtils.equals(nodeId, param[0])) {
//                    // 如果通知针对本节点，则调用notifySelf()
//                    notifySelf(Long.parseLong(param[1]));
//                }
//            }
//        };
//        new Thread(() -> {getJedis().subscribe(sub, CHANNEL);}).start();
//        // 添加本节点至所有节点SET中
//        getJedis().sadd(ALL_NODE_SET_KEY, nodeId);
//    }
//
//    /**
//     * {@inheritDoc}
//     */
//    @Override
//    public void unregister(String nodeId) {
//        // 取消订阅频道
//        if (sub != null) {
//            sub.unsubscribe();
//        }
//        // 从所有节点SET中移除本节点
//        getJedis().srem(ALL_NODE_SET_KEY, nodeId);
//    }
//
//    /**
//     * {@inheritDoc}
//     */
//    @Override
//    public void notify(String nodeId, long time) {
//        // 推送消息
//        getJedis().publish(CHANNEL, nodeId + MESSAGE_SEPARATOR + String.valueOf(time));
//    }
//
//    /**
//     * {@inheritDoc}
//     */
//    @Override
//    public Lock getLock(String name) {
//        return new Lock() {
//
//            JedisLock lock;
//
//            @Override
//            public void lock() {
//            }
//
//            @Override
//            public void lockInterruptibly() throws InterruptedException {
//            }
//
//            @Override
//            public boolean tryLock() {
//                lock = new JedisLock(getJedis(), name, 0);
//                try {
//                    return lock.acquire();
//                } catch (InterruptedException e) {
//                    e.printStackTrace();
//                    return false;
//                }
//            }
//
//            @Override
//            public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
//                return false;
//            }
//
//            @Override
//            public void unlock() {
//                lock.release();
//            }
//
//            @NotNull
//            @Override
//            public Condition newCondition() {
//                return null;
//            }
//        };
//    }
//
//    /**
//     * {@inheritDoc}
//     */
//    @Override
//    public String[] allNodeIds() {
//        return getJedis().smembers(ALL_NODE_SET_KEY).toArray(new String[0]);
//    }
//}
