package com.fr.scheduler.bean;

import com.fr.third.v2.org.quartz.ScheduleBuilder;
import com.fr.third.v2.org.quartz.Trigger;
import org.jetbrains.annotations.NotNull;

import java.util.Date;

/**
 * 触发器的公共Bean接口.
 *
 * <p>
 * 不要直接实现此接口，使用{@link FineSimpleTriggerProvider}或{@link FineCronTriggerProvider}.
 * </p>
 *
 * @author Cloud.Liu
 * created on 2020-10-20
 * @see FineSimpleTriggerProvider
 * @see FineCronTriggerProvider
 */
public interface FineTriggerProvider<T extends Trigger> {

    /**
     * 获取触发器名称.
     *
     * @return 触发器名称
     * @IncludeIntoJavadoc
     */
    @NotNull
    String getName();

    /**
     * 获取触发器组名.
     *
     * @return 触发器组名
     * @IncludeIntoJavadoc
     */
    @NotNull
    String getGroup();

    /**
     * 获取触发器开始时间.
     *
     * <p>
     * 使用{@code new Date()}代表立即触发.
     * </p>
     *
     * @return 触发器开始时间
     * @IncludeIntoJavadoc
     */
    @NotNull
    Date getStartTime();

    /**
     * 获取触发器结束时间.
     *
     * <p>
     * 使用{@code null}代表永不结束.
     * </p>
     *
     * @return 触发器结束时间
     * @IncludeIntoJavadoc
     */
    Date getStopTime();

    /**
     * 创建本{@link FineTriggerProvider}对应的ScheduleBuilder.
     *
     * @return ScheduleBuilder
     */
    ScheduleBuilder<T> createSchedule();
}