package com.fr.scheduler.bean;

import com.fr.scheduler.enums.SimpleMisfireInstType;
import com.fr.third.v2.org.quartz.ScheduleBuilder;
import com.fr.third.v2.org.quartz.SimpleScheduleBuilder;
import com.fr.third.v2.org.quartz.SimpleTrigger;
import org.jetbrains.annotations.NotNull;

/**
 * 简单重复触发器的Bean接口.
 *
 * <p>
 * Bean实现此接口，可直接使用{@link com.fr.scheduler.tool.FineTriggerBuilder#fromFineTriggerProvider(FineTriggerProvider)}生成{@link com.fr.scheduler.tool.FineScheduler}使用的Trigger.
 * </p>
 *
 * @author Cloud.Liu
 * created on 2020-10-21
 * @see com.fr.scheduler.tool.FineTriggerBuilder#fromFineTriggerProvider(FineTriggerProvider)
 */
public interface FineSimpleTriggerProvider extends FineTriggerProvider<SimpleTrigger> {

    /**
     * 获取任务触发间隔.
     *
     * <p>
     * 单位为秒.
     * </p>
     *
     * @return 触发间隔
     * @IncludeIntoJavadoc
     */
    int getInterval();

    /**
     * 获取任务重复次数.
     *
     * <p>
     * 必须大于等于-1.<br>
     * 使用-1表示无限重复，使用0表示不重复（只执行一次）.
     * </p>
     *
     * @return 重复次数
     * @IncludeIntoJavadoc
     */
    int getRepeatCount();

    /**
     * 获取Misfire策略.
     *
     * <p>
     * 默认使用{@link SimpleMisfireInstType#DEFAULT}.
     * </p>
     *
     * @return Misfire策略
     * @see SimpleMisfireInstType
     * @IncludeIntoJavadoc
     */
    @NotNull
    default SimpleMisfireInstType getMisfireInstruction() {
        return SimpleMisfireInstType.DEFAULT;
    };

    /**
     * {@inheritDoc}
     */
    default ScheduleBuilder<SimpleTrigger> createSchedule() {
        SimpleScheduleBuilder builder =  SimpleScheduleBuilder.simpleSchedule()
                .withIntervalInSeconds(getInterval())
                .withRepeatCount(getRepeatCount());
        getMisfireInstruction().modifySimpleScheduleBuilder(builder);
        return builder;
    }
}
