package com.fr.scheduler.bean;

import com.fr.scheduler.job.FineJob;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

/**
 * JobDetail的Bean接口.
 *
 * <p>
 * Bean实现此接口，可直接使用{@link com.fr.scheduler.tool.FineJobBuilder#fromFineJobProvider(FineJobProvider)}生成{@link com.fr.scheduler.tool.FineScheduler}使用的JobDetail.
 * </p>
 *
 * @author Cloud.Liu
 * created on 2020-10-20
 * @see com.fr.scheduler.tool.FineJobBuilder#fromFineJobProvider(FineJobProvider)
 * @IncludeIntoJavadoc
 */
public interface FineJobProvider {

    /**
     * 获取任务名称.
     *
     * <p>
     * 不可为{@code null}或空.
     * </p>
     *
     * @return 任务名称
     */
    @NotNull
    String getName();

    /**
     * 获取任务组名.
     *
     * <p>
     * 不可为{@code null}或空.
     * </p>
     *
     * @return 任务组名
     */
    @NotNull
    String getGroup();

    /**
     * 获取任务描述.
     *
     * @return 任务描述
     */
    String getDescription();

    /**
     * 获取任务类.
     *
     * @return 任务类
     */
    @NotNull
    Class<? extends FineJob> getJobClass();

    /**
     * 获取任务携带数据.
     *
     * <p>
     * 任务执行时可在{@code JobExecutionContext}中获取.
     * </p>
     *
     * @return 携带数据
     */
    @NotNull
    Map<String, Object> getJobDataMap();

    /**
     * 获取任务创建者.
     *
     * @return 创建者
     */
    String getCreator();
}
