package com.fr.scheduler.bean;

import com.fr.scheduler.enums.CronMisfireInstType;
import com.fr.third.v2.org.quartz.CronScheduleBuilder;
import com.fr.third.v2.org.quartz.CronTrigger;
import com.fr.third.v2.org.quartz.ScheduleBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.TimeZone;

/**
 * Cron表达式触发器的Bean接口.
 *
 * <p>
 * Bean实现此接口，可直接使用{@link com.fr.scheduler.tool.FineTriggerBuilder#fromFineTriggerProvider(FineTriggerProvider)}生成{@link com.fr.scheduler.tool.FineScheduler}使用的Trigger.
 * </p>
 *
 * @author Cloud.Liu
 * created on 2020-10-21
 * @see com.fr.scheduler.tool.FineTriggerBuilder#fromFineTriggerProvider(FineTriggerProvider)
 */
public interface FineCronTriggerProvider extends FineTriggerProvider<CronTrigger> {

    /**
     * 获取Cron表达式.
     *
     * @return Cron表达式
     * @IncludeIntoJavadoc
     */
    @NotNull
    String getCronExpression();

    /**
     * 获取时区.
     *
     * <p>
     * 默认为服务器时区.
     * </p>
     *
     * @return 时区
     * @IncludeIntoJavadoc
     */
    @Nullable
    default TimeZone getTimeZone() {
        return null;
    };

    /**
     * 获取Misfire策略.
     *
     * <p>
     * 默认使用{@link CronMisfireInstType#DEFAULT}.
     * </p>
     *
     * @return Misfire策略
     * @see CronMisfireInstType
     * @IncludeIntoJavadoc
     */
    @NotNull
    default CronMisfireInstType getMisfireInstruction() {
        return CronMisfireInstType.DEFAULT;
    };

    /**
     * {@inheritDoc}
     */
    @NotNull
    default ScheduleBuilder<CronTrigger> createSchedule() {
        CronScheduleBuilder builder = CronScheduleBuilder.cronSchedule(getCronExpression()).inTimeZone(getTimeZone());
        getMisfireInstruction().modifyCronScheduleBuilder(builder);
        return builder;
    }
}
