package com.fr.config;

/**
 * 每周每天枚举.
 *
 * <p>
 * {@code Java}和{@code JavaScript}都默认周日为每周的第一天，但{@code Java}从1开始，{@code JavaScript}从0开始.
 * </p>
 *
 * @author fanruan
 * created on 2020-09-01
 */
public enum DayOfWeek {

    /**
     * 周日.
     */
    SUNDAY(),
    /**
     * 周一.
     */
    MONDAY(),
    /**
     * 周二.
     */
    TUESDAY(),
    /**
     * 周三.
     */
    WEDNESDAY(),
    /**
     * 周四.
     */
    THURSDAY(),
    /**
     * 周五.
     */
    FRIDAY(),
    /**
     * 周六.
     */
    SATURDAY();

    private static final DayOfWeek[] ENUMS = DayOfWeek.values();

    /**
     * 获取{@code Java}中的日期.
     *
     * <p>
     * 周日为1；周一为2，以此类推.
     * </p>
     *
     * @return {@code Java}中的日期
     */
    public int getCalendarDay() {
        return ordinal() + 1;
    }

    /**
     * 获取用于配置存储的日期.
     *
     * <p>
     * 周日为0，周一为1，以此类推.
     * </p>
     *
     * @return 用于配置存储的日期
     */
    public int getConf() {
        return ordinal();
    }

    /**
     * 将配置存储的{@code Integer}转为星期几.
     *
     * <p>
     * 周日为0，周一为1，以此类推.
     * </p>
     *
     * @param dayConf 配置存储的{@code Integer}
     * @return 枚举
     */
    public static DayOfWeek of(int dayConf) {
        if (dayConf < 0 || dayConf > 6) {
            return SUNDAY;
        }
        return ENUMS[dayConf];
    }

    /**
     * 获取字符串表示.
     *
     * @return 字符串表示
     */
    @Override
    public String toString() {
        return String.valueOf(ordinal());
    }
}
