package com.fr.common.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 标记类/方法是临时解决方案，在指定日期后会被删除.
 *
 * @author richie
 * created on 2019-05-20
 * @IncludeIntoJavadoc
 */
@Retention(RetentionPolicy.CLASS)
@Target({
        ElementType.ANNOTATION_TYPE,
        ElementType.CONSTRUCTOR,
        ElementType.FIELD,
        ElementType.METHOD,
        ElementType.TYPE
})
@Documented
public @interface Negative {

    /**
     * 修改该问题的最后日期
     * @return 日期，形如2010-05-29
     */
    String until();
}
