package com.fr.common.annotations;

/**
 * 标记一个类/方法仅供测试使用，在{@code review}时可以忽略.
 *
 * @author richie
 * created on 2019-05-14
 * @IncludeIntoJavadoc
 */
@Inside(String.class)
public @interface Inside {
    /**
     * 被Test的类数组，可以只写一个.
     *
     * @return 被测试类数组
     */
    @Inside(value = {Inside.class, String.class}, function = "value")
    Class[] value() default {Inside.class};

    /**
     * 测试的方法名称.
     *
     * @return 方法名称
     */
    @Inside(value = Inside.class, function = "function")
    String[] function() default "";
}
