package com.fr.common.annotations;

import com.fr.common.annotations.constant.CompatibleType;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 标记类/方法/字段修改时必须考虑兼容性.
 *
 * @author richie
 * created on 2019-05-14
 * @IncludeIntoJavadoc
 */
@Retention(RetentionPolicy.CLASS)
@Target({
        ElementType.FIELD,
        ElementType.METHOD,
        ElementType.TYPE
})
@Documented
public @interface Compatible {

    /**
     * 表示什么类型的兼容 默认空
     *
     * @return 兼容类型
     */
    CompatibleType type() default CompatibleType.NONE;

}
