export type TEMP = {
    blueprintIndexInResourceHeader: number;
    externalSceneTypeIndicesInResourceHeader: any[];
    propertyOverrides: any[];
    rootEntityIndex: number;
    subEntities?: any[] | undefined;
    entityTemplates?: any[] | undefined;
    subType: number;
};
export type TBLU = {
    externalSceneTypeIndicesInResourceHeader: any[];
    inputPinForwardings: any[];
    outputPinForwardings: any[];
    overrideDeletes: any[];
    pinConnectionOverrideDeletes?: any[] | undefined;
    pinConnectionOverrides?: any[] | undefined;
    pinConnections: any[];
    rootEntityIndex: number;
    subEntities?: any[] | undefined;
    entityTemplates?: any[] | undefined;
    subType: number;
};
export type HashMeta = {
    hash_offset: number;
    hash_reference_data: any[];
    hash_reference_table_dummy: number;
    hash_reference_table_size: number;
    hash_resource_type: string;
    hash_size: number;
    hash_size_final: number;
    hash_size_in_memory: number;
    hash_size_in_video_memory: number;
    hash_value: string;
};
export type Entity = {
    tempHash: string;
    tbluHash: string;
    rootEntity: string;
    entities: {
        [x: string]: SubEntity;
    };
    externalScenes: string[];
    propertyOverrides: object[];
    overrideDeletes: object[];
    pinConnectionOverrides: object[];
    pinConnectionOverrideDeletes: object[];
    subType: number;
    quickEntityVersion: number;
};
export type SubEntity = {
    type?: string | undefined;
    parent: object;
    name: string;
    template: string;
    templateFlag?: string | undefined;
    blueprint: string;
    editorOnly: boolean;
    platformSpecificPropertyValues: object[];
    entitySubsets: array[] | string[] | object[];
    properties: {
        [x: string]: {
            type: string;
            value: any;
        };
    };
    propertyValues?: object[] | undefined;
    postInitProperties: {
        [x: string]: {
            type: string;
            value: any;
        };
    };
    postInitPropertyValues?: object[] | undefined;
    propertyAliases: object[];
    events?: {
        onEvent: string;
        shouldTrigger: string;
        onEntity: string;
        value?: object | undefined;
    }[] | undefined;
    inputCopying?: {
        whenTriggered: string;
        alsoTrigger: string;
        onEntity: string;
        value?: object | undefined;
    }[] | undefined;
    outputCopying?: {
        onEvent: string;
        propagateEvent: string;
        onEntity: string;
        value?: object | undefined;
    }[] | undefined;
    exposedEntities: object;
    exposedInterfaces: object;
};
export function convert(automateGame?: boolean, automateTempPath?: boolean, automateTempMetaPath?: boolean, automateTbluPath?: boolean, automateTbluMetaPath?: boolean, automateQNPath?: boolean): Promise<void>;
export function generate(automateGame?: boolean, automateQNPath?: boolean, automateTempPath?: boolean, automateTempMetaPath?: boolean, automateTbluPath?: boolean, automateTbluMetaPath?: boolean): Promise<{
    tempRebuildPath: any;
    tempMetaRebuildPath: any;
    tbluRebuildPath: any;
    tbluMetaRebuildPath: any;
} | undefined>;
export function createPatchJSON(automateQN1Path?: boolean, automateQN2Path?: boolean, automateOutputPath?: boolean): Promise<void>;
export function applyPatchJSON(automateQNPath?: boolean, automatePatchPath?: boolean, automateOutputPath?: boolean): Promise<void>;
