import type { Config } from "./types";
import RPKGInstance from "./rpkg";
import arg from "arg";
declare const _default: {
    FrameworkVersion: string;
    rpkgInstance: RPKGInstance;
    config: Config;
    logger: {
        verbose: (text: string, mod?: string) => Promise<void>;
        debug: (text: string, mod?: string) => Promise<void>;
        info: (text: string, mod?: string) => Promise<void>;
        warn: (text: string, mod?: string) => Promise<void>;
        error: (text: string, exitAfter?: boolean, mod?: string) => Promise<void>;
    };
    isDevBuild: boolean;
    args: arg.Result<{
        "--useConsoleLogging": BooleanConstructor;
        "--pauseAfterLogging": BooleanConstructor;
        "--doNotPause": BooleanConstructor;
        "--logLevel": [StringConstructor];
    }>;
    cleanExit: () => Promise<never>;
};
export default _default;
