export declare const FrameworkVersion: string;
export declare const rpkgInstance: import("./rpkg").default;
export declare const config: import("./types").Config;
export declare const logger: {
    verbose: (text: string, mod?: string) => Promise<void>;
    debug: (text: string, mod?: string) => Promise<void>;
    info: (text: string, mod?: string) => Promise<void>;
    warn: (text: string, mod?: string) => Promise<void>;
    error: (text: string, exitAfter?: boolean, mod?: string) => Promise<void>;
};
export declare const isDevBuild: boolean;
export declare const args: import("arg").Result<{
    "--useConsoleLogging": BooleanConstructor;
    "--pauseAfterLogging": BooleanConstructor;
    "--doNotPause": BooleanConstructor;
    "--logLevel": [StringConstructor];
}>;
export declare const cleanExit: () => Promise<never>;
declare const _default: {
    FrameworkVersion: string;
    rpkgInstance: import("./rpkg").default;
    config: import("./types").Config;
    logger: {
        verbose: (text: string, mod?: string) => Promise<void>;
        debug: (text: string, mod?: string) => Promise<void>;
        info: (text: string, mod?: string) => Promise<void>;
        warn: (text: string, mod?: string) => Promise<void>;
        error: (text: string, exitAfter?: boolean, mod?: string) => Promise<void>;
    };
    isDevBuild: boolean;
    args: import("arg").Result<{
        "--useConsoleLogging": BooleanConstructor;
        "--pauseAfterLogging": BooleanConstructor;
        "--doNotPause": BooleanConstructor;
        "--logLevel": [StringConstructor];
    }>;
    cleanExit: () => Promise<never>;
};
export default _default;
