/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.storage.AbstractBasicMap;
import org.jetbrains.kotlin.incremental.storage.StringToLongMapExternalizer;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/incremental/InlineFunctionsMap;", "Lorg/jetbrains/kotlin/incremental/storage/AbstractBasicMap;", "Ljava/io/File;", "", "", "", "storageFile", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "process", "", "srcFile", "newMap", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "dumpValue", "value", "kotlin-build-common"})
final class InlineFunctionsMap
extends AbstractBasicMap<File, Map<String, ? extends Long>> {
    public InlineFunctionsMap(@NotNull File storageFile, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        super(storageFile, icContext.getFileDescriptorForSourceFiles(), StringToLongMapExternalizer.INSTANCE, icContext);
    }

    public final synchronized void process(@NotNull File srcFile, @NotNull Map<String, Long> newMap2, @NotNull ChangesCollector changesCollector) {
        Map oldMap2;
        Intrinsics.checkNotNullParameter((Object)srcFile, (String)"srcFile");
        Intrinsics.checkNotNullParameter(newMap2, (String)"newMap");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Map map = (Map)this.get(srcFile);
        if (map == null) {
            map = oldMap2 = MapsKt.emptyMap();
        }
        if (!newMap2.isEmpty()) {
            this.set(srcFile, newMap2);
        } else {
            this.remove(srcFile);
        }
        for (String fn : SetsKt.plus(oldMap2.keySet(), (Iterable)newMap2.keySet())) {
            String[] stringArray = new String[]{"."};
            List fqNameSegments = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)StringsKt.removePrefix((String)fn, (CharSequence)"<get>"), (CharSequence)"<set>"), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            FqName fqName = FqName.Companion.fromSegments(fqNameSegments);
            FqName fqName2 = fqName.parent();
            String string2 = fqName.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            changesCollector.collectMemberIfValueWasChanged(fqName2, string2, oldMap2.get(fn), newMap2.get(fn));
        }
    }

    @Override
    @NotNull
    public String dumpValue(@NotNull Map<String, Long> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return IncrementalJvmCacheKt.dumpMap(value2, InlineFunctionsMap::dumpValue$lambda$0);
    }

    private static final String dumpValue$lambda$0(long it) {
        String string2 = Long.toHexString(it);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHexString(...)");
        return string2;
    }
}

