/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.ILineId;
import org.jetbrains.kotlin.cli.common.repl.IReplStageHistory;
import org.jetbrains.kotlin.cli.common.repl.ReplHistoryRecord;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B\u0011\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/cli/common/repl/BasicReplStageHistory;", "T", "Lorg/jetbrains/kotlin/cli/common/repl/IReplStageHistory;", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/cli/common/repl/ReplHistoryRecord;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "<init>", "(Ljava/util/concurrent/locks/ReentrantReadWriteLock;)V", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "currentLineNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCurrentLineNumber", "()Ljava/util/concurrent/atomic/AtomicInteger;", "currentGeneration", "getCurrentGeneration", "push", "", "id", "Lorg/jetbrains/kotlin/cli/common/repl/ILineId;", "item", "(Lorg/jetbrains/kotlin/cli/common/repl/ILineId;Ljava/lang/Object;)V", "pop", "reset", "", "resetTo", "tryResetTo", "", "cli-common"})
@SourceDebugExtension(value={"SMAP\nBasicReplState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicReplState.kt\norg/jetbrains/kotlin/cli/common/repl/BasicReplStageHistory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1#2:94\n1557#3:95\n1628#3,3:96\n360#3,7:99\n*S KotlinDebug\n*F\n+ 1 BasicReplState.kt\norg/jetbrains/kotlin/cli/common/repl/BasicReplStageHistory\n*L\n52#1:95\n52#1:96,3\n67#1:99,7\n*E\n"})
public class BasicReplStageHistory<T>
extends ArrayList<ReplHistoryRecord<? extends T>>
implements IReplStageHistory<T> {
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final AtomicInteger currentLineNumber;
    @NotNull
    private final AtomicInteger currentGeneration;

    public BasicReplStageHistory(@NotNull ReentrantReadWriteLock lock2) {
        Intrinsics.checkNotNullParameter((Object)lock2, (String)"lock");
        this.lock = lock2;
        this.currentLineNumber = new AtomicInteger(0);
        this.currentGeneration = new AtomicInteger(1);
    }

    public /* synthetic */ BasicReplStageHistory(ReentrantReadWriteLock reentrantReadWriteLock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            reentrantReadWriteLock = new ReentrantReadWriteLock();
        }
        this(reentrantReadWriteLock);
    }

    @Override
    @NotNull
    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    @NotNull
    public final AtomicInteger getCurrentLineNumber() {
        return this.currentLineNumber;
    }

    @NotNull
    public final AtomicInteger getCurrentGeneration() {
        return this.currentGeneration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(@NotNull ILineId id, T item) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.add(new ReplHistoryRecord<T>(id, item));
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ReplHistoryRecord<T> pop() {
        ReplHistoryRecord replHistoryRecord;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            replHistoryRecord = this.isEmpty() ? null : (ReplHistoryRecord)this.remove(CollectionsKt.getLastIndex((List)this));
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return replHistoryRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<ILineId> reset() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ReplHistoryRecord replHistoryRecord = (ReplHistoryRecord)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getId());
            }
            List removed = (List)destination$iv$iv;
            this.clear();
            this.currentGeneration.incrementAndGet();
            this.currentLineNumber.set(0);
            Iterable iterable2 = removed;
            return iterable2;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Iterable<ILineId> resetTo(@NotNull ILineId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            List<ILineId> list = this.tryResetTo(id);
            if (list == null) {
                throw new NoSuchElementException("Cannot reset to non-existent line " + id.getNo());
            }
            Iterable iterable = list;
            return iterable;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final List<ILineId> tryResetTo(@NotNull ILineId id) {
        List list;
        int idx;
        block6: {
            int n;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            List $this$indexOfFirst$iv = this;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                ReplHistoryRecord it = (ReplHistoryRecord)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getId(), (Object)id)) {
                    n = index$iv;
                    break block6;
                }
                ++index$iv;
            }
            n = idx = -1;
        }
        if (idx < 0) {
            return null;
        }
        if (idx < CollectionsKt.getLastIndex((List)this)) {
            void var3_2;
            List removed = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)this), (int)(idx + 1)), BasicReplStageHistory::tryResetTo$lambda$6));
            this.removeRange(idx + 1, this.size());
            this.currentGeneration.incrementAndGet();
            ILineId iLineId = (ILineId)CollectionsKt.lastOrNull((List)removed);
            if (iLineId != null) {
                int it = iLineId.getNo();
                boolean bl = false;
                this.currentLineNumber.set(it);
            }
            list = var3_2;
        } else {
            this.currentGeneration.incrementAndGet();
            this.currentLineNumber.set(id.getNo() + 1);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final ILineId tryResetTo$lambda$6(ReplHistoryRecord it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getId();
    }

    public BasicReplStageHistory() {
        this(null, 1, null);
    }
}

