/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiled.light.classes;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002R3\u0010\u0004\u001a'\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/ClsJavaStubByVirtualFileCache;", "", "<init>", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/ClsJavaStubByVirtualFileCache$CachedJavaStub;", "get", "Lcom/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl;", "classFile", "createStub", "Lcom/intellij/psi/impl/java/stubs/PsiJavaFileStub;", "file", "CachedJavaStub", "Companion", "light-classes-for-decompiled"})
public final class ClsJavaStubByVirtualFileCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<VirtualFile, CachedJavaStub> cache;
    @NotNull
    private static final Logger LOG;

    public ClsJavaStubByVirtualFileCache() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakKeySoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakKeySoftValueMap(...)");
        this.cache = concurrentMap;
    }

    @Nullable
    public final PsiJavaFileStubImpl get(@NotNull VirtualFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        CachedJavaStub cached = (CachedJavaStub)this.cache.get(classFile);
        long fileModificationStamp = classFile.getModificationStamp();
        if (cached != null && cached.getModificationStamp() == fileModificationStamp) {
            return cached.getJavaFileStub();
        }
        PsiJavaFileStubImpl psiJavaFileStubImpl = (PsiJavaFileStubImpl)this.createStub(classFile);
        if (psiJavaFileStubImpl == null) {
            return null;
        }
        PsiJavaFileStubImpl stub = psiJavaFileStubImpl;
        ((Map)this.cache).put(classFile, new CachedJavaStub(fileModificationStamp, stub));
        return stub;
    }

    private final PsiJavaFileStub createStub(VirtualFile file2) {
        if (!Intrinsics.areEqual((Object)file2.getExtension(), (Object)JavaClassFileType.INSTANCE.getDefaultExtension()) && file2.getFileType() != JavaClassFileType.INSTANCE) {
            return null;
        }
        try {
            return ClsFileImpl.buildFileStub((VirtualFile)file2, (byte[])file2.contentsToByteArray(false));
        }
        catch (ClsFormatException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to build java cls class for ");
            String string2 = file2.getCanonicalPath();
            Intrinsics.checkNotNull((Object)string2);
            LOG.warn(stringBuilder.append(string2).toString(), (Throwable)e);
        }
        catch (IOException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to build java cls class for ");
            String string3 = file2.getCanonicalPath();
            Intrinsics.checkNotNull((Object)string3);
            LOG.warn(stringBuilder.append(string3).toString(), (Throwable)e);
        }
        return null;
    }

    static {
        Logger logger = Logger.getInstance(ClsJavaStubByVirtualFileCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/ClsJavaStubByVirtualFileCache$CachedJavaStub;", "", "modificationStamp", "", "javaFileStub", "Lcom/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl;", "<init>", "(JLcom/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl;)V", "getModificationStamp", "()J", "getJavaFileStub", "()Lcom/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl;", "light-classes-for-decompiled"})
    private static final class CachedJavaStub {
        private final long modificationStamp;
        @NotNull
        private final PsiJavaFileStubImpl javaFileStub;

        public CachedJavaStub(long modificationStamp, @NotNull PsiJavaFileStubImpl javaFileStub) {
            Intrinsics.checkNotNullParameter((Object)javaFileStub, (String)"javaFileStub");
            this.modificationStamp = modificationStamp;
            this.javaFileStub = javaFileStub;
        }

        public final long getModificationStamp() {
            return this.modificationStamp;
        }

        @NotNull
        public final PsiJavaFileStubImpl getJavaFileStub() {
            return this.javaFileStub;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/ClsJavaStubByVirtualFileCache$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/ClsJavaStubByVirtualFileCache;", "project", "Lcom/intellij/openapi/project/Project;", "light-classes-for-decompiled"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClsJavaStubByVirtualFileCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ClsJavaStubByVirtualFileCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ClsJavaStubByVirtualFileCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

