/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.trace;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.workspace.storage.ConnectionId;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.ExternalEntityMapping;
import com.intellij.platform.workspace.storage.ExternalMappingKey;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.impl.ImmutableEntityStorageImpl;
import com.intellij.platform.workspace.storage.impl.UtilsKt;
import com.intellij.platform.workspace.storage.trace.ReadTrace;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlIndex;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 52\u00020\u0001:\u00015B%\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0016J \u0010\u0012\u001a\u00020\u0013\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0016J>\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00150\r\"\b\b\u0000\u0010\u000e*\u00020\u0016\"\b\b\u0001\u0010\u0015*\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00182\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0011H\u0016J'\u0010\u0019\u001a\u0004\u0018\u0001H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0018H\u0016\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u001b\u001a\u00020\u001c\"\b\b\u0000\u0010\u000e*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0018H\u0096\u0002J\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u001e\"\u0004\b\u0000\u0010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\"\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u001c0\u0005H\u0016J\u001a\u0010'\u001a\u0004\u0018\u00010\u000f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000fH\u0016J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000fH\u0016J\u001a\u0010,\u001a\u0004\u0018\u00010\u000f2\u0006\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020\u000fH\u0016J1\u0010.\u001a\u0002H\u001f\"\b\b\u0000\u0010\u001f*\u00020\u000f2\n\u0010/\u001a\u000600j\u0002`12\f\u00102\u001a\b\u0012\u0004\u0012\u0002H\u001f03H\u0016\u00a2\u0006\u0002\u00104R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00066"}, d2={"Lcom/intellij/platform/workspace/storage/trace/ReadTracker;", "Lcom/intellij/platform/workspace/storage/impl/ImmutableEntityStorageImpl;", "snapshot", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "onRead", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/trace/ReadTrace;", "", "<init>", "(Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;Lkotlin/jvm/functions/Function1;)V", "getOnRead$intellij_platform_workspace_storage", "()Lkotlin/jvm/functions/Function1;", "entities", "Lkotlin/sequences/Sequence;", "E", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entityClass", "Ljava/lang/Class;", "entityCount", "", "referrers", "R", "Lcom/intellij/platform/workspace/storage/WorkspaceEntityWithSymbolicId;", "id", "Lcom/intellij/platform/workspace/storage/SymbolicEntityId;", "resolve", "(Lcom/intellij/platform/workspace/storage/SymbolicEntityId;)Lcom/intellij/platform/workspace/storage/WorkspaceEntityWithSymbolicId;", "contains", "", "getExternalMapping", "Lcom/intellij/platform/workspace/storage/ExternalEntityMapping;", "T", "identifier", "Lcom/intellij/platform/workspace/storage/ExternalMappingKey;", "getVirtualFileUrlIndex", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlIndex;", "entitiesBySource", "sourceFilter", "Lcom/intellij/platform/workspace/storage/EntitySource;", "getOneChild", "connectionId", "Lcom/intellij/platform/workspace/storage/ConnectionId;", "parent", "getManyChildren", "getParent", "child", "initializeEntity", "entityId", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "newInstance", "Lkotlin/Function0;", "(JLkotlin/jvm/functions/Function0;)Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "Companion", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\ntracing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 tracing.kt\ncom/intellij/platform/workspace/storage/trace/ReadTracker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,325:1\n68#2,4:326\n68#2,4:330\n68#2,4:334\n68#2,4:338\n68#2,4:342\n68#2,4:346\n68#2,4:350\n68#2,4:354\n68#2,4:358\n14#2:362\n*S KotlinDebug\n*F\n+ 1 tracing.kt\ncom/intellij/platform/workspace/storage/trace/ReadTracker\n*L\n46#1:326,4\n53#1:330,4\n61#1:334,4\n68#1:338,4\n75#1:342,4\n82#1:346,4\n97#1:350,4\n104#1:354,4\n111#1:358,4\n123#1:362\n*E\n"})
public final class ReadTracker
extends ImmutableEntityStorageImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<ReadTrace, Unit> onRead;
    @NotNull
    private static final Logger log;

    private ReadTracker(ImmutableEntityStorage snapshot, Function1<? super ReadTrace, Unit> onRead) {
        Intrinsics.checkNotNull((Object)snapshot, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.ImmutableEntityStorageImpl");
        super(((ImmutableEntityStorageImpl)snapshot).getEntitiesByType$intellij_platform_workspace_storage(), ((ImmutableEntityStorageImpl)snapshot).getRefs$intellij_platform_workspace_storage(), ((ImmutableEntityStorageImpl)snapshot).getIndexes$intellij_platform_workspace_storage(), ((ImmutableEntityStorageImpl)snapshot).getSnapshotCache$intellij_platform_workspace_storage());
        this.onRead = onRead;
        if (!(!(snapshot instanceof ReadTracker))) {
            boolean bl = false;
            String string = "Recursive read tracker is not supported";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Function1<ReadTrace, Unit> getOnRead$intellij_platform_workspace_storage() {
        return this.onRead;
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntity> Sequence<E> entities(@NotNull Class<E> entityClass) {
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        ReadTrace.EntitiesOfType trace = new ReadTrace.EntitiesOfType(entityClass);
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Read trace of `entities` function: " + trace);
        }
        this.onRead.invoke((Object)trace);
        return super.entities(entityClass);
    }

    @Override
    public <E extends WorkspaceEntity> int entityCount(@NotNull Class<E> entityClass) {
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        ReadTrace.EntitiesOfType trace = new ReadTrace.EntitiesOfType(entityClass);
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Read trace of `entitiesAmount` function: " + trace);
        }
        this.onRead.invoke((Object)trace);
        return super.entityCount(entityClass);
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntityWithSymbolicId, R extends WorkspaceEntity> Sequence<R> referrers(@NotNull SymbolicEntityId<? extends E> id, @NotNull Class<R> entityClass) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        ReadTrace.HasSymbolicLinkTo trace = new ReadTrace.HasSymbolicLinkTo(id, entityClass);
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Read trace of `referrers` function: " + trace);
        }
        this.onRead.invoke((Object)trace);
        return super.referrers(id, entityClass);
    }

    @Override
    @Nullable
    public <E extends WorkspaceEntityWithSymbolicId> E resolve(@NotNull SymbolicEntityId<? extends E> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        ReadTrace.Resolve trace = new ReadTrace.Resolve(id);
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Read trace of `resolve` function: " + trace);
        }
        this.onRead.invoke((Object)trace);
        return super.resolve(id);
    }

    @Override
    public <E extends WorkspaceEntityWithSymbolicId> boolean contains(@NotNull SymbolicEntityId<? extends E> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        ReadTrace.Resolve trace = new ReadTrace.Resolve(id);
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Read trace of `contains` function: " + trace);
        }
        this.onRead.invoke((Object)trace);
        return super.contains(id);
    }

    @Override
    @NotNull
    public <T> ExternalEntityMapping<T> getExternalMapping(@NotNull ExternalMappingKey<T> identifier) {
        Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
        ReadTrace.ExternalMappingAccess trace = new ReadTrace.ExternalMappingAccess(identifier);
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Read trace of `getExternalMapping` function: " + trace);
        }
        this.onRead.invoke((Object)trace);
        return super.getExternalMapping(identifier);
    }

    @Override
    @NotNull
    public VirtualFileUrlIndex getVirtualFileUrlIndex() {
        String string = "The VirtualFileUrlIndex is not supported for read tracing at the moment";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public Sequence<WorkspaceEntity> entitiesBySource(@NotNull Function1<? super EntitySource, Boolean> sourceFilter) {
        Intrinsics.checkNotNullParameter(sourceFilter, (String)"sourceFilter");
        String string = "The entitiesBySource is not supported for read tracing at the moment";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @Nullable
    public WorkspaceEntity getOneChild(@NotNull ConnectionId connectionId, @NotNull WorkspaceEntity parent) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ReadTrace.SomeFieldAccess trace = new ReadTrace.SomeFieldAccess(UtilsKt.asBase(parent).getId());
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Read trace of `getOneChild` function: " + trace);
        }
        this.onRead.invoke((Object)trace);
        return super.getOneChild(connectionId, parent);
    }

    @Override
    @NotNull
    public Sequence<WorkspaceEntity> getManyChildren(@NotNull ConnectionId connectionId, @NotNull WorkspaceEntity parent) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ReadTrace.SomeFieldAccess trace = new ReadTrace.SomeFieldAccess(UtilsKt.asBase(parent).getId());
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Read trace of `getManyChildren` function: " + trace);
        }
        this.onRead.invoke((Object)trace);
        return super.getManyChildren(connectionId, parent);
    }

    @Override
    @Nullable
    public WorkspaceEntity getParent(@NotNull ConnectionId connectionId, @NotNull WorkspaceEntity child) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        ReadTrace.SomeFieldAccess trace = new ReadTrace.SomeFieldAccess(UtilsKt.asBase(child).getId());
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Read trace of `getParent` function: " + trace);
        }
        this.onRead.invoke((Object)trace);
        return super.getParent(connectionId, child);
    }

    @Override
    @NotNull
    public <T extends WorkspaceEntity> T initializeEntity(long entityId, @NotNull Function0<? extends T> newInstance) {
        Intrinsics.checkNotNullParameter(newInstance, (String)"newInstance");
        WorkspaceEntity instance = (WorkspaceEntity)newInstance.invoke();
        UtilsKt.asBase(instance).setOnRead$intellij_platform_workspace_storage(this.onRead);
        return (T)instance;
    }

    public /* synthetic */ ReadTracker(ImmutableEntityStorage snapshot, Function1 onRead, DefaultConstructorMarker $constructor_marker) {
        this(snapshot, (Function1<? super ReadTrace, Unit>)onRead);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ReadTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\fJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/workspace/storage/trace/ReadTracker$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "trace", "", "Lcom/intellij/platform/workspace/storage/trace/ReadTrace;", "snapshot", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "action", "Lkotlin/Function1;", "", "tracedSnapshot", "Lcom/intellij/platform/workspace/storage/trace/ReadTracker;", "addTo", "Lit/unimi/dsi/fastutil/longs/LongArrayList;", "intellij.platform.workspace.storage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<ReadTrace> trace(@NotNull ImmutableEntityStorage snapshot, @NotNull Function1<? super ImmutableEntityStorage, Unit> action2) {
            HashSet hashSet;
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            HashSet traces = hashSet = new HashSet();
            boolean bl = false;
            ReadTracker traced = new ReadTracker(snapshot, arg_0 -> Companion.trace$lambda$1$lambda$0(traces, arg_0), null);
            action2.invoke((Object)traced);
            return hashSet;
        }

        @NotNull
        public final ReadTracker tracedSnapshot(@NotNull ImmutableEntityStorage snapshot, @NotNull LongArrayList addTo) {
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            Intrinsics.checkNotNullParameter((Object)addTo, (String)"addTo");
            return new ReadTracker(snapshot, arg_0 -> Companion.tracedSnapshot$lambda$2(addTo, arg_0), null);
        }

        private static final Unit trace$lambda$1$lambda$0(HashSet $traces, ReadTrace it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $traces.add(it);
            return Unit.INSTANCE;
        }

        private static final Unit tracedSnapshot$lambda$2(LongArrayList $addTo, ReadTrace it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $addTo.add(it.getHash());
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

