/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.CeProcessCanceledException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.DebugAttachDetectorArgs;
import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class Cancellation {
    private static final ThreadLocal<Boolean> isInNonCancelableSection = new ThreadLocal();
    private static final ThreadLocal<DebugNonCancellableState> debugIsInNonCancelableSection = new ThreadLocal();

    private Cancellation() {
    }

    @VisibleForTesting
    @Nullable
    public static Job currentJob() {
        return (Job)ThreadContext.currentThreadContext().get((CoroutineContext.Key)Job.Key);
    }

    public static void checkCancelled() {
        if (Cancellation.isInNonCancelableSection()) {
            return;
        }
        Cancellation.ensureActive();
    }

    @ApiStatus.Internal
    public static void ensureActive() {
        ThreadContext.warnAccidentalCancellation();
        Job currentJob = Cancellation.currentJob();
        if (currentJob != null) {
            try {
                JobKt.ensureActive(currentJob);
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (CancellationException e) {
                throw new CeProcessCanceledException(e);
            }
        }
    }

    public static boolean isInNonCancelableSection() {
        if (Cancellation.isInNonCancelableSectionInternal()) {
            return true;
        }
        if (!DebugNonCancellableState.isDebugEnabled) {
            return false;
        }
        DebugNonCancellableState state = debugIsInNonCancelableSection.get();
        return state != null && state.inNonCancelableSection;
    }

    private static boolean isInNonCancelableSectionInternal() {
        return isInNonCancelableSection.get() != null;
    }

    public static <T, E extends Exception> T computeInNonCancelableSection(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            Cancellation.$$$reportNull$$$0(0);
        }
        if (Cancellation.isInNonCancelableSectionInternal()) {
            return computable.compute();
        }
        try {
            isInNonCancelableSection.set(Boolean.TRUE);
            T t = computable.compute();
            return t;
        }
        finally {
            isInNonCancelableSection.remove();
        }
    }

    public static void executeInNonCancelableSection(@NotNull Runnable runnable) {
        if (runnable == null) {
            Cancellation.$$$reportNull$$$0(1);
        }
        Cancellation.computeInNonCancelableSection(() -> {
            runnable.run();
            return null;
        });
    }

    @NotNull
    public static AccessToken withNonCancelableSection() {
        if (Cancellation.isInNonCancelableSectionInternal()) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                Cancellation.$$$reportNull$$$0(2);
            }
            return accessToken;
        }
        isInNonCancelableSection.set(Boolean.TRUE);
        return new AccessToken(){

            @Override
            public void finish() {
                isInNonCancelableSection.remove();
            }
        };
    }

    @Deprecated
    @ApiStatus.Internal
    public static <T> T forceNonCancellableSectionInClassInitializer(@NotNull Supplier<T> computable) {
        if (computable == null) {
            Cancellation.$$$reportNull$$$0(3);
        }
        return (T)Cancellation.computeInNonCancelableSection(computable::get);
    }

    @NotNull
    private static DebugNonCancellableState initThreadNonCancellableState() {
        DebugNonCancellableState state = debugIsInNonCancelableSection.get();
        if (state != null) {
            DebugNonCancellableState debugNonCancellableState = state;
            if (debugNonCancellableState == null) {
                Cancellation.$$$reportNull$$$0(4);
            }
            return debugNonCancellableState;
        }
        state = new DebugNonCancellableState();
        debugIsInNonCancelableSection.set(state);
        DebugNonCancellableState debugNonCancellableState = state;
        if (debugNonCancellableState == null) {
            Cancellation.$$$reportNull$$$0(5);
        }
        return debugNonCancellableState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/Cancellation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/Cancellation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withNonCancelableSection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "initThreadNonCancellableState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeInNonCancelableSection";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executeInNonCancelableSection";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forceNonCancellableSectionInClassInitializer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DebugNonCancellableState {
        private static final boolean isDebugEnabled = DebugAttachDetectorArgs.isDebugEnabled();
        private volatile boolean inNonCancelableSection = false;

        private DebugNonCancellableState() {
        }
    }
}

