/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class EditorTextFieldRendererDocument
extends UserDataHolderBase
implements DocumentEx {
    private final RangeMarkerTree<RangeMarkerEx> myRangeMarkers = new RangeMarkerTree(this);
    private char[] myChars = ArrayUtilRt.EMPTY_CHAR_ARRAY;
    private String myString = "";
    private LineSet myLineSet = LineSet.createLineSet(this.myString);

    @Override
    public void setModificationStamp(long modificationStamp) {
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        if (chars == null) {
            EditorTextFieldRendererDocument.$$$reportNull$$$0(0);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setText(@NotNull CharSequence text) {
        if (text == null) {
            EditorTextFieldRendererDocument.$$$reportNull$$$0(1);
        }
        String s = StringUtil.convertLineSeparators(text.toString());
        this.myChars = new char[s.length()];
        s.getChars(0, s.length(), this.myChars, 0);
        this.myString = new String(this.myChars);
        this.myLineSet = LineSet.createLineSet(this.myString);
    }

    @Override
    public int getLineSeparatorLength(int line) {
        int separatorLength = this.myLineSet.getSeparatorLength(line);
        assert (separatorLength >= 0);
        return separatorLength;
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        LineIterator lineIterator = this.myLineSet.createIterator();
        if (lineIterator == null) {
            EditorTextFieldRendererDocument.$$$reportNull$$$0(2);
        }
        return lineIterator;
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            EditorTextFieldRendererDocument.$$$reportNull$$$0(3);
        }
        return this.myRangeMarkers.removeInterval(rangeMarker);
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (rangeMarker == null) {
            EditorTextFieldRendererDocument.$$$reportNull$$$0(4);
        }
        this.myRangeMarkers.addInterval(rangeMarker, start, end, greedyToLeft, greedyToRight, false, layer);
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> processor) {
        if (processor == null) {
            EditorTextFieldRendererDocument.$$$reportNull$$$0(5);
        }
        return this.myRangeMarkers.processAll(processor);
    }

    @Override
    public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<? super RangeMarker> processor) {
        if (processor == null) {
            EditorTextFieldRendererDocument.$$$reportNull$$$0(6);
        }
        return this.myRangeMarkers.processOverlappingWith(start, end, processor);
    }

    @Override
    @NotNull
    public CharSequence getImmutableCharSequence() {
        String string = this.myString;
        if (string == null) {
            EditorTextFieldRendererDocument.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public char @NotNull [] getChars() {
        if (this.myChars == null) {
            EditorTextFieldRendererDocument.$$$reportNull$$$0(8);
        }
        return this.myChars;
    }

    @Override
    public int getLineCount() {
        return this.myLineSet.findLineIndex(this.myChars.length) + 1;
    }

    @Override
    public int getLineNumber(int offset) {
        return this.myLineSet.findLineIndex(offset);
    }

    @Override
    public int getLineStartOffset(int line) {
        return this.myChars.length == 0 ? 0 : this.myLineSet.getLineStart(line);
    }

    @Override
    public int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result2 = this.myLineSet.getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result2 >= 0);
        return result2;
    }

    @Override
    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            EditorTextFieldRendererDocument.$$$reportNull$$$0(9);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void deleteString(int startOffset, int endOffset) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            EditorTextFieldRendererDocument.$$$reportNull$$$0(10);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }

    @Override
    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String toString() {
        return "EditorTextFieldRendererDocument{myLength = " + this.myChars.length + "; myRangeMarkers = " + this.myRangeMarkers.size() + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorTextFieldRendererDocument";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorTextFieldRendererDocument";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineIterator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmutableCharSequence";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeRangeMarker";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerRangeMarker";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processRangeMarkers";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processRangeMarkersOverlappingWith";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "insertString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

