/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.ActionsXmlDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.DomExtensions;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010#\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 B2\u00020\u0001:\u0001BB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J&\u0010 \u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170#H\u0002J\u0018\u0010$\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u001aH\u0002J\u0018\u0010&\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J6\u0010(\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u001a2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00170#2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00170#H\u0002J\u001f\u0010,\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010.J \u0010/\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u0017H\u0002J\u0018\u00101\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u001aH\u0002JO\u00102\u001a\u0004\u0018\u00010\u00052\b\u00103\u001a\u0004\u0018\u00010\u00172\u0006\u00104\u001a\u00020\u00172\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170#2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u00172\u0006\u00106\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u00107J6\u00108\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u001a2\u0006\u00109\u001a\u00020\u00172\b\b\u0002\u0010:\u001a\u00020\u00052\b\b\u0002\u0010;\u001a\u00020\u0005H\u0002J4\u0010<\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u00172\n\b\u0002\u0010@\u001a\u0004\u0018\u00010AH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/android/tools/lint/checks/ActionsXmlDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "<init>", "()V", "foundProblem", "", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "visitDocument", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "filterIncident", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "isMissingFromManifest", "actionResourceName", "", "createIncident", "actions", "Lorg/w3c/dom/Element;", "checkActions", "checkAction", "action", "templateRequiresParameters", "fulfillment", "checkParameter", "parameter", "parameterNames", "", "checkEntitySetReference", "entitySetReference", "checkFulfillment", "hasEntitySetReference", "checkParameterMapping", "parameterMapping", "intentParams", "urlParameters", "checkParent", "element", "(Lcom/android/tools/lint/detector/api/XmlContext;Lorg/w3c/dom/Element;)Ljava/lang/Boolean;", "wrongParent", "expected", "nestingNotAllowed", "checkNotAlreadyPresent", "name", "nameAttribute", "parentTag", "nameTag", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Lcom/android/tools/lint/detector/api/XmlContext;Lorg/w3c/dom/Element;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "checkRequiredAttribute", "attribute", "allowBlank", "allowReference", "report", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nActionsXmlDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionsXmlDetector.kt\ncom/android/tools/lint/checks/ActionsXmlDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,689:1\n1863#2,2:690\n*S KotlinDebug\n*F\n+ 1 ActionsXmlDetector.kt\ncom/android/tools/lint/checks/ActionsXmlDetector\n*L\n159#1:690,2\n*E\n"})
public final class ActionsXmlDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean foundProblem;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String KEY_ID = "id";
    @NotNull
    private static final String TAG_ACTIONS = "actions";
    @NotNull
    private static final String TAG_ACTION = "action";
    @NotNull
    private static final String TAG_ACTION_DISPLAY = "action-display";
    @NotNull
    private static final String TAG_PARAMETER = "parameter";
    @NotNull
    private static final String TAG_FULFILLMENT = "fulfillment";
    @NotNull
    private static final String TAG_PARAMETER_MAPPING = "parameter-mapping";
    @NotNull
    private static final String TAG_ENTITY_SET_REFERENCE = "entity-set-reference";
    @NotNull
    private static final String ATTR_URL_TEMPLATE = "urlTemplate";
    @NotNull
    private static final String ATTR_URL_FILTER = "urlFilter";
    @NotNull
    private static final String ATTR_URL_PARAMETER = "urlParameter";
    @NotNull
    private static final String ATTR_INTENT_PARAMETER = "intentParameter";
    @NotNull
    private static final String ATTR_INTENT_NAME = "intentName";
    @NotNull
    private static final String ATTR_RESOURCE = "resource";
    @NotNull
    private static final String VAR_URL = "url";

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.XML;
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Element documentElement;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.foundProblem = false;
        Element element = documentElement = document.getDocumentElement();
        if (element == null) {
            return;
        }
        Element root = element;
        if (!Intrinsics.areEqual((Object)TAG_ACTIONS, (Object)root.getTagName())) {
            if (Intrinsics.areEqual((Object)TAG_ACTION, (Object)root.getTagName())) {
                this.wrongParent(context, root, TAG_ACTIONS);
            }
            return;
        }
        this.checkActions(context, documentElement);
        if (context.isGlobalAnalysis()) {
            if (context.getProject().isLibrary()) {
                return;
            }
            Context context2 = (Context)context;
            String string = context.file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (this.isMissingFromManifest(context2, Lint.getBaseName((String)string))) {
                String string2 = context.file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                Incident incident = this.createIncident(root, context, Lint.getBaseName((String)string2));
                context.report(incident);
            }
        } else {
            if (this.foundProblem) {
                return;
            }
            String string = context.file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Incident incident = this.createIncident(root, context, Lint.getBaseName((String)string));
            LintMap lintMap = this.map();
            String string3 = context.file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            context.report(incident, lintMap.put(KEY_ID, Lint.getBaseName((String)string3)));
        }
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        if (context.getMainProject().isLibrary()) {
            return false;
        }
        String string = map.getString(KEY_ID, null);
        if (string == null) {
            return false;
        }
        String actionResourceName = string;
        return this.isMissingFromManifest(context, actionResourceName);
    }

    private final boolean isMissingFromManifest(Context context, String actionResourceName) {
        Project mainProject = context.getMainProject();
        Document document = mainProject.getMergedManifest();
        if (document == null) {
            return false;
        }
        Document mergedManifest = document;
        Element element = mergedManifest.getDocumentElement();
        if (element == null) {
            return false;
        }
        Element root = element;
        Element element2 = DomExtensions.subtag((Element)root, (String)"application");
        if (element2 == null) {
            return false;
        }
        Element application = element2;
        if (application.getFirstChild() == null) {
            return false;
        }
        Element metadata = DomExtensions.subtag((Element)application, (String)"meta-data");
        while (metadata != null) {
            String resource;
            ResourceUrl url;
            String name = metadata.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
            if (Intrinsics.areEqual((Object)name, (Object)"com.google.android.actions") && (url = ResourceUrl.parse((String)(resource = metadata.getAttributeNS("http://schemas.android.com/apk/res/android", ATTR_RESOURCE)))) != null && Intrinsics.areEqual((Object)url.name, (Object)actionResourceName)) {
                return false;
            }
            metadata = DomExtensions.next((Element)metadata, (String)"meta-data");
        }
        return true;
    }

    private final Incident createIncident(Element actions, XmlContext context, String actionResourceName) {
        return new Incident(ISSUE, (Object)actions, context.getElementLocation(actions), "This action resource should be registered in the manifest under the `<application>` tag as `<meta-data android:name=\"com.google.android.actions\" android:resource=\"@xml/" + actionResourceName + "\" />`");
    }

    private final void checkActions(XmlContext context, Element actions) {
        Iterator iterator = DomExtensions.iterator((Element)actions);
        while (iterator.hasNext()) {
            Element action = (Element)iterator.next();
            Boolean bl = this.checkParent(context, action);
            if (bl == null) {
                return;
            }
            bl.booleanValue();
            String tag = action.getTagName();
            if (!Intrinsics.areEqual((Object)tag, (Object)TAG_ACTION)) continue;
            this.checkAction(context, action);
        }
        Attr localeNode = actions.getAttributeNode("supportedLocales");
        if (localeNode != null) {
            String locales = localeNode.getValue();
            int index2 = 0;
            Intrinsics.checkNotNull((Object)locales);
            String[] stringArray = new String[]{","};
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)locales, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String locale = (String)element$iv;
                boolean bl = false;
                String bcp = "b+" + StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)locale)).toString(), (String)"-", (String)"+", (boolean)false, (int)4, null);
                if (LocaleQualifier.getQualifier((String)bcp) == null) {
                    ActionsXmlDetector $this$checkActions_u24lambda_u241_u24lambda_u240 = this;
                    boolean bl2 = false;
                    Location loc = context.getValueLocation(localeNode);
                    Position position = loc.getStart();
                    if (position == null) {
                        return;
                    }
                    Position start = position;
                    start = (Position)new DefaultPosition(start.getLine(), start.getColumn() + index2, start.getOffset() + index2);
                    DefaultPosition end = new DefaultPosition(((DefaultPosition)start).getLine(), ((DefaultPosition)start).getColumn() + locale.length(), ((DefaultPosition)start).getOffset() + locale.length());
                    Location location = Location.Companion.create(context.file, start, (Position)end);
                    String message2 = "Invalid BCP-47 locale qualifier `" + locale + "`";
                    ActionsXmlDetector.report$default($this$checkActions_u24lambda_u241_u24lambda_u240, context, actions, location, message2, null, 16, null);
                    return;
                }
                index2 += locale.length() + 1;
            }
        }
    }

    private final void checkAction(XmlContext context, Element action) {
        Boolean bl = this.checkParent(context, action);
        if (bl == null) {
            return;
        }
        bl.booleanValue();
        if (ActionsXmlDetector.checkRequiredAttribute$default(this, context, action, ATTR_INTENT_NAME, false, false, 24, null) == null) {
            return;
        }
        boolean atLeastOneFulfillment = false;
        boolean atLeastOneEntitySetReference = false;
        Set parameterNames = null;
        boolean foundNonRequiredTemplate = false;
        Iterator iterator = DomExtensions.iterator((Element)action);
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            String tag = child.getTagName();
            if (Intrinsics.areEqual((Object)tag, (Object)TAG_ACTION)) {
                this.nestingNotAllowed(context, child);
                return;
            }
            Boolean bl2 = this.checkParent(context, child);
            if (bl2 == null) {
                return;
            }
            bl2.booleanValue();
            String string = tag;
            if (Intrinsics.areEqual((Object)string, (Object)TAG_PARAMETER)) {
                boolean hasEntitySetReference;
                if (parameterNames == null) {
                    parameterNames = new LinkedHashSet();
                }
                if (!(hasEntitySetReference = this.checkParameter(context, child, parameterNames))) continue;
                atLeastOneEntitySetReference = true;
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)TAG_FULFILLMENT)) continue;
            this.checkFulfillment(context, child);
            atLeastOneFulfillment = true;
            if (this.templateRequiresParameters(child)) continue;
            foundNonRequiredTemplate = true;
        }
        if (!atLeastOneFulfillment) {
            if (!atLeastOneEntitySetReference) {
                ActionsXmlDetector.report$default(this, context, action, context.getElementLocation(action), "`<action>` must declare a `<fulfillment>` or a `<parameter>` with an `<entity-set-reference>`", null, 16, null);
            }
        } else if (!foundNonRequiredTemplate) {
            ActionsXmlDetector.report$default(this, context, action, context.getElementLocation(action), "At least one <fulfillment> `urlTemplate` must not be required", null, 16, null);
        }
    }

    private final boolean templateRequiresParameters(Element fulfillment) {
        Iterator iterator = DomExtensions.iterator((Element)fulfillment);
        while (iterator.hasNext()) {
            String required;
            Element child = (Element)iterator.next();
            if (!Intrinsics.areEqual((Object)child.getTagName(), (Object)TAG_PARAMETER_MAPPING) || !Intrinsics.areEqual((Object)(required = child.getAttribute("required")), (Object)"true")) continue;
            return true;
        }
        return false;
    }

    private final boolean checkParameter(XmlContext context, Element parameter, Set<String> parameterNames) {
        Boolean bl = this.checkParent(context, parameter);
        if (bl == null) {
            return false;
        }
        bl.booleanValue();
        if (ActionsXmlDetector.checkRequiredAttribute$default(this, context, parameter, "name", false, false, 24, null) == null) {
            return false;
        }
        String string = ActionsXmlDetector.checkRequiredAttribute$default(this, context, parameter, "name", false, false, 24, null);
        if (string == null) {
            return false;
        }
        String name = string;
        this.checkNotAlreadyPresent(name, "name", parameterNames, context, parameter, TAG_ACTION, TAG_PARAMETER);
        boolean hasEntitySetReference = false;
        Iterator iterator = DomExtensions.iterator((Element)parameter);
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            String tag = child.getTagName();
            if (Intrinsics.areEqual((Object)tag, (Object)TAG_PARAMETER)) {
                this.nestingNotAllowed(context, child);
                return false;
            }
            Boolean bl2 = this.checkParent(context, child);
            if (bl2 == null) {
                return false;
            }
            bl2.booleanValue();
            if (!Intrinsics.areEqual((Object)tag, (Object)TAG_ENTITY_SET_REFERENCE)) continue;
            this.checkEntitySetReference(context, child);
            hasEntitySetReference = true;
        }
        return hasEntitySetReference;
    }

    private final void checkEntitySetReference(XmlContext context, Element entitySetReference) {
        if (ActionsXmlDetector.checkRequiredAttribute$default(this, context, entitySetReference, ATTR_URL_FILTER, false, false, 24, null) == null) {
            return;
        }
    }

    private final void checkFulfillment(XmlContext context, Element fulfillment) {
        Boolean bl = this.checkParent(context, fulfillment);
        if (bl == null) {
            return;
        }
        bl.booleanValue();
        String string = ActionsXmlDetector.checkRequiredAttribute$default(this, context, fulfillment, ATTR_URL_TEMPLATE, false, false, 8, null);
        if (string == null) {
            return;
        }
        String urlTemplate = string;
        Set<String> templateParameters = Companion.getUriTemplateParameters(urlTemplate);
        Set intentParameterNames = new LinkedHashSet();
        Set urlParameters = new LinkedHashSet();
        Iterator iterator = DomExtensions.iterator((Element)fulfillment);
        while (iterator.hasNext()) {
            String parameter;
            Element child = (Element)iterator.next();
            String tag = child.getTagName();
            if (Intrinsics.areEqual((Object)tag, (Object)TAG_FULFILLMENT)) {
                this.nestingNotAllowed(context, child);
                return;
            }
            Boolean bl2 = this.checkParent(context, child);
            if (bl2 == null) {
                return;
            }
            bl2.booleanValue();
            if (!Intrinsics.areEqual((Object)tag, (Object)TAG_PARAMETER_MAPPING) || (parameter = this.checkParameterMapping(context, child, intentParameterNames, urlParameters)) == null || templateParameters.contains(parameter) || StringsKt.startsWith$default((String)parameter, (String)"@", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)parameter, (Object)VAR_URL)) continue;
            ActionsXmlDetector.report$default(this, context, child, context.getElementLocation(child), "The parameter `" + parameter + "` is not present in the `urlTemplate`", null, 16, null);
        }
        if (templateParameters.contains(VAR_URL) && !urlParameters.contains(VAR_URL)) {
            Node node = fulfillment.getParentNode();
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            if (this.hasEntitySetReference((Element)node)) {
                urlParameters.add(VAR_URL);
            }
        }
        Sets.SetView missing = Sets.difference(templateParameters, (Set)urlParameters);
        Intrinsics.checkNotNull((Object)missing);
        if (!((Collection)missing).isEmpty()) {
            Attr attr = fulfillment.getAttributeNode(ATTR_URL_TEMPLATE);
            Intrinsics.checkNotNullExpressionValue((Object)attr, (String)"getAttributeNode(...)");
            Location attributeLocation = context.getValueLocation(attr);
            String message2 = missing.size() == 1 ? "The parameter " + CollectionsKt.first((Iterable)((Iterable)missing)) + " is not defined as a `<parameter-mapping>` element below" : "The parameters " + CollectionsKt.joinToString$default((Iterable)((Iterable)missing), (CharSequence)" and ", null, null, (int)0, null, (Function1)checkFulfillment.message.1.INSTANCE, (int)30, null) + " are not defined as `<parameter-mapping>` elements below";
            ActionsXmlDetector.report$default(this, context, fulfillment, attributeLocation, message2, null, 16, null);
        }
    }

    private final boolean hasEntitySetReference(Element action) {
        boolean bl = Intrinsics.areEqual((Object)action.getTagName(), (Object)TAG_ACTION);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Iterator iterator = DomExtensions.iterator((Element)action);
        while (iterator.hasNext()) {
            Element parameter = (Element)iterator.next();
            if (!Intrinsics.areEqual((Object)parameter.getTagName(), (Object)TAG_PARAMETER) || DomExtensions.subtag((Element)parameter, (String)TAG_ENTITY_SET_REFERENCE) == null) continue;
            return true;
        }
        return false;
    }

    private final String checkParameterMapping(XmlContext context, Element parameterMapping, Set<String> intentParams, Set<String> urlParameters) {
        String string = ActionsXmlDetector.checkRequiredAttribute$default(this, context, parameterMapping, ATTR_INTENT_PARAMETER, false, false, 8, null);
        if (string == null) {
            return null;
        }
        String intentParameter = string;
        Boolean bl = this.checkParent(context, parameterMapping);
        if (bl == null) {
            return null;
        }
        bl.booleanValue();
        String string2 = ActionsXmlDetector.checkRequiredAttribute$default(this, context, parameterMapping, ATTR_URL_PARAMETER, false, false, 8, null);
        if (string2 == null) {
            return null;
        }
        String urlParameter = string2;
        urlParameters.add(urlParameter);
        Boolean bl2 = this.checkNotAlreadyPresent(intentParameter, ATTR_INTENT_PARAMETER, intentParams, context, parameterMapping, TAG_FULFILLMENT, TAG_PARAMETER_MAPPING);
        if (bl2 == null) {
            return null;
        }
        bl2.booleanValue();
        return urlParameter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Boolean checkParent(XmlContext context, Element element) {
        String string;
        String tag = element.getTagName();
        String string2 = tag;
        if (string2 == null) return true;
        int n = -1;
        switch (string2.hashCode()) {
            case -1485118421: {
                if (string2.equals(TAG_ACTION_DISPLAY)) {
                    n = 1;
                }
                break;
            }
            case -1409837258: {
                if (string2.equals(TAG_ENTITY_SET_REFERENCE)) {
                    n = 2;
                }
                break;
            }
            case 1170863786: {
                if (string2.equals(TAG_PARAMETER_MAPPING)) {
                    n = 3;
                }
                break;
            }
            case 1954460585: {
                if (string2.equals(TAG_PARAMETER)) {
                    n = 4;
                }
                break;
            }
            case -1422950858: {
                if (string2.equals(TAG_ACTION)) {
                    n = 5;
                }
                break;
            }
            case 1512395230: {
                if (string2.equals(TAG_FULFILLMENT)) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 5: {
                string = TAG_ACTIONS;
                break;
            }
            case 1: {
                string = TAG_ACTION;
                break;
            }
            case 4: {
                string = TAG_ACTION;
                break;
            }
            case 3: {
                string = TAG_FULFILLMENT;
                break;
            }
            case 2: {
                string = TAG_PARAMETER;
                break;
            }
            default: {
                return true;
            }
        }
        String expectedParent = string;
        Object object = element.getParentNode();
        if (object == null || (object = object.getNodeName()) == null) {
            return true;
        }
        Object actualParent = object;
        if (!Intrinsics.areEqual((Object)expectedParent, (Object)actualParent)) {
            this.wrongParent(context, element, expectedParent);
            return null;
        }
        if (!Intrinsics.areEqual((Object)tag, (Object)actualParent)) return true;
        this.nestingNotAllowed(context, element);
        return null;
    }

    private final void wrongParent(XmlContext context, Element element, String expected) {
        ActionsXmlDetector.report$default(this, context, element, context.getNameLocation((Node)element), "`<" + element.getTagName() + ">` must be inside `<" + expected + ">`", null, 16, null);
    }

    private final void nestingNotAllowed(XmlContext context, Element element) {
        ActionsXmlDetector.report$default(this, context, element, context.getNameLocation((Node)element), "Nesting `<" + element.getTagName() + ">` is not allowed", null, 16, null);
    }

    private final Boolean checkNotAlreadyPresent(String name, String nameAttribute, Set<String> parameterNames, XmlContext context, Element parameter, String parentTag, String nameTag) {
        boolean duplicate;
        if (name == null) {
            return true;
        }
        boolean bl = duplicate = !parameterNames.add(name);
        if (duplicate) {
            Attr attr = parameter.getAttributeNode(nameAttribute);
            Intrinsics.checkNotNullExpressionValue((Object)attr, (String)"getAttributeNode(...)");
            Location location = context.getLocation((Node)attr);
            Element prev = XmlUtils.getPreviousTagByName((Node)parameter, (String)parameter.getTagName());
            while (prev != null) {
                Attr attr2;
                Attr attr3 = attr2 = prev.getAttributeNode(nameAttribute);
                if (Intrinsics.areEqual((Object)(attr3 != null ? attr3.getValue() : null), (Object)name)) {
                    location.setSecondary(context.getLocation((Node)attr2));
                    break;
                }
                prev = XmlUtils.getPreviousTagByName((Node)prev, (String)parameter.getTagName());
            }
            ActionsXmlDetector.report$default(this, context, parameter, location, "`<" + parentTag + ">` contains two `<" + nameTag + ">` elements with the same " + nameAttribute + ", `" + name + "`", null, 16, null);
            return null;
        }
        return true;
    }

    private final String checkRequiredAttribute(XmlContext context, Element element, String attribute, boolean allowBlank, boolean allowReference) {
        String value = element.getAttribute(attribute);
        if (value != null && (allowBlank || !StringsKt.isBlank((CharSequence)value))) {
            if (!allowReference && StringsKt.startsWith$default((String)value, (String)"@", (boolean)false, (int)2, null)) {
                Attr attr = element.getAttributeNode(attribute);
                Intrinsics.checkNotNullExpressionValue((Object)attr, (String)"getAttributeNode(...)");
                ActionsXmlDetector.report$default(this, context, element, context.getLocation((Node)attr), "`" + attribute + "` must be a value, not a reference", null, 16, null);
            }
            return value;
        }
        LintFix fix = LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)LintFix.Companion.create().set(), null, (String)attribute, null, null, (int)12, null).build();
        this.report(context, element, context.getElementLocation(element), "Missing required attribute `" + attribute + "`", fix);
        return null;
    }

    static /* synthetic */ String checkRequiredAttribute$default(ActionsXmlDetector actionsXmlDetector, XmlContext xmlContext, Element element, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return actionsXmlDetector.checkRequiredAttribute(xmlContext, element, string, bl, bl2);
    }

    private final void report(XmlContext context, Element element, Location location, String message2, LintFix fix) {
        this.foundProblem = true;
        context.report(new Incident(ISSUE, (Object)element, location, message2, fix));
    }

    static /* synthetic */ void report$default(ActionsXmlDetector actionsXmlDetector, XmlContext xmlContext, Element element, Location location, String string, LintFix lintFix, int n, Object object) {
        if ((n & 0x10) != 0) {
            lintFix = null;
        }
        actionsXmlDetector.report(xmlContext, element, location, string, lintFix);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.FATAL;
        Implementation implementation = new Implementation(ActionsXmlDetector.class, Scope.RESOURCE_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"ValidActionsXml", (String)"Invalid Action Descriptor", (String)"Ensures that an actions XML file is properly formed", (Implementation)implementation, null, (Category)category, (int)5, (Severity)severity, (boolean)false, null, null, null, (int)3600, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0007J.\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/lint/checks/ActionsXmlDetector$Companion;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_ID", "", "TAG_ACTIONS", "TAG_ACTION", "TAG_ACTION_DISPLAY", "TAG_PARAMETER", "TAG_FULFILLMENT", "TAG_PARAMETER_MAPPING", "TAG_ENTITY_SET_REFERENCE", "ATTR_URL_TEMPLATE", "ATTR_URL_FILTER", "ATTR_URL_PARAMETER", "ATTR_INTENT_PARAMETER", "ATTR_INTENT_NAME", "ATTR_RESOURCE", "VAR_URL", "getUriTemplateParameters", "", "urlTemplate", "addVariables", "", "variables", "", "s", "from", "", "to", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final Set<String> getUriTemplateParameters(@NotNull String urlTemplate) {
            Intrinsics.checkNotNullParameter((Object)urlTemplate, (String)ActionsXmlDetector.ATTR_URL_TEMPLATE);
            int length = urlTemplate.length();
            Set variables = new LinkedHashSet();
            for (int begin = 0; begin < length; ++begin) {
                int end;
                char c = urlTemplate.charAt(begin);
                if (c != '{' || (end = StringsKt.indexOf$default((CharSequence)urlTemplate, (char)'}', (int)(begin + 1), (boolean)false, (int)4, null)) == -1) continue;
                this.addVariables(variables, urlTemplate, begin, end + 1);
            }
            return variables;
        }

        private final void addVariables(Set<String> variables, String s, int from, int to) {
            boolean bl;
            if (from > to - 2) {
                return;
            }
            char operator = s.charAt(from + 1);
            switch (operator) {
                case '#': 
                case '+': {
                    bl = true;
                    break;
                }
                case '&': 
                case '.': 
                case '/': 
                case ';': 
                case '?': {
                    bl = true;
                    break;
                }
                case '!': 
                case ',': 
                case '=': 
                case '@': 
                case '|': {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            boolean hasOperator = bl;
            int offset = from + (hasOperator ? 2 : 1);
            while (offset < to) {
                int beginVarSpec;
                int endVarSpec;
                int variableEnd = -1;
                block10: for (endVarSpec = beginVarSpec = offset; endVarSpec < to; ++endVarSpec) {
                    char c = s.charAt(endVarSpec);
                    switch (c) {
                        case ',': 
                        case '}': {
                            if (variableEnd != -1) break block10;
                            variableEnd = endVarSpec;
                            break block10;
                        }
                        case '*': 
                        case ':': {
                            variableEnd = endVarSpec;
                        }
                        default: {
                            continue block10;
                        }
                    }
                }
                if (variableEnd > beginVarSpec) {
                    String variable;
                    Intrinsics.checkNotNullExpressionValue((Object)s.substring(beginVarSpec, variableEnd), (String)"substring(...)");
                    variables.add(variable);
                }
                offset = endVarSpec + 1;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

