/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceSetType;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.XmlUtils;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0000J\b\u0010\u0017\u001a\u00020\tH\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\u0013\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!J\u0014\u0010\"\u001a\u00020\u00142\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\rJ\"\u0010$\u001a\u00020\u00142\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\rJ\"\u0010'\u001a\u00020\u00142\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\rJ\"\u0010*\u001a\u00020\u00142\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\rJ\"\u0010+\u001a\u00020\u00142\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\rJ\u0016\u0010,\u001a\u00020\u00142\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0002J\u0016\u0010-\u001a\u00020\u00142\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\rJ\u001c\u0010/\u001a\u00020\u00142\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u00101\u001a\u00020\tJ\u000e\u00102\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u0007J\u0016\u00104\u001a\u00020\u00142\u000e\u00105\u001a\n\u0012\u0004\u0012\u000207\u0018\u000106J\u0010\u0010:\u001a\u00020\u00142\b\u00108\u001a\u0004\u0018\u000109J\b\u0010;\u001a\u000209H\u0016J\n\u0010<\u001a\u0004\u0018\u00010\u0010H\u0016J\u001c\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u0010B\u001a\u00020\u00142\u0006\u0010C\u001a\u00020DH\u0016J\u001a\u0010E\u001a\u00020\u00142\b\u0010F\u001a\u0004\u0018\u00010\u00052\b\u0010G\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/android/tools/lint/ManualProject;", "Lcom/android/tools/lint/detector/api/Project;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "dir", "Ljava/io/File;", "name", "", "library", "", "android", "partialResultsDir", "testFiles", "", "generatedFiles", "variant", "Lcom/android/tools/lint/model/LintModelVariant;", "<init>", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/lang/String;ZZLjava/io/File;Ljava/util/List;Ljava/util/List;Lcom/android/tools/lint/model/LintModelVariant;)V", "initialize", "", "addDirectDependency", "project", "isAndroidProject", "isGradleProject", "toString", "equals", "other", "", "hashCode", "", "setJavaLanguageLevel", "level", "Lcom/intellij/pom/java/LanguageLevel;", "setManifests", "manifests", "setResources", "resourceRoots", "resources", "setSources", "sourceRoots", "sources", "setTestSources", "setGeneratedSources", "addFilteredFiles", "setProguardFiles", "files", "setClasspath", "allClasses", "useForAnalysis", "setCompileSdkVersion", "buildApi", "setDesugaring", "desugaring", "", "Lcom/android/tools/lint/detector/api/Desugaring;", "resourceVisibility", "Lcom/android/ide/common/repository/ResourceVisibilityLookup;", "setResourceVisibility", "getResourceVisibility", "getBuildVariant", "getUastSourceList", "Lcom/android/tools/lint/client/api/UastParser$UastSourceList;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "main", "readManifest", "document", "Lorg/w3c/dom/Document;", "initializeSdkLevelInfo", "mergedManifest", "manifest", "lint-cli"})
@SourceDebugExtension(value={"SMAP\nProjectInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectInitializer.kt\ncom/android/tools/lint/ManualProject\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1328:1\n1#2:1329\n*E\n"})
final class ManualProject
extends Project {
    private final boolean android;
    @NotNull
    private final List<File> testFiles;
    @NotNull
    private final List<File> generatedFiles;
    @Nullable
    private final LintModelVariant variant;
    @Nullable
    private ResourceVisibilityLookup resourceVisibility;

    public ManualProject(@NotNull LintClient client, @NotNull File dir, @NotNull String name, boolean library, boolean android, @Nullable File partialResultsDir, @NotNull List<? extends File> testFiles, @NotNull List<? extends File> generatedFiles, @Nullable LintModelVariant variant) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
        Intrinsics.checkNotNullParameter(generatedFiles, (String)"generatedFiles");
        super(client, dir, dir, partialResultsDir);
        this.android = android;
        this.testFiles = testFiles;
        this.generatedFiles = generatedFiles;
        this.variant = variant;
        this.setName(name);
        this.directLibraries = new ArrayList();
        this.library = library;
        this.buildSdk = 35;
        this.mergeManifests = true;
    }

    public /* synthetic */ ManualProject(LintClient lintClient, File file, String string, boolean bl, boolean bl2, File file2, List list2, List list3, LintModelVariant lintModelVariant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            lintModelVariant = null;
        }
        this(lintClient, file, string, bl, bl2, file2, list2, list3, lintModelVariant);
    }

    protected void initialize() {
    }

    public final void addDirectDependency(@NotNull ManualProject project) {
        Intrinsics.checkNotNullParameter((Object)((Object)project), (String)"project");
        this.directLibraries.add(project);
    }

    public boolean isAndroidProject() {
        return this.android;
    }

    public boolean isGradleProject() {
        return false;
    }

    @NotNull
    public String toString() {
        return "Project [name=" + this.name + "]";
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ManualProject && Intrinsics.areEqual((Object)this.name, (Object)((ManualProject)((Object)other)).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public final void setJavaLanguageLevel(@NotNull LanguageLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.javaLanguageLevel = level;
    }

    public final void setManifests(@NotNull List<? extends File> manifests) {
        Intrinsics.checkNotNullParameter(manifests, (String)"manifests");
        this.manifestFiles = manifests;
        this.addFilteredFiles(manifests);
    }

    public final void setResources(@NotNull List<? extends File> resourceRoots, @NotNull List<? extends File> resources) {
        Intrinsics.checkNotNullParameter(resourceRoots, (String)"resourceRoots");
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        this.resourceFolders = resourceRoots;
        this.addFilteredFiles(resources);
    }

    public final void setSources(@NotNull List<? extends File> sourceRoots2, @NotNull List<? extends File> sources) {
        Intrinsics.checkNotNullParameter(sourceRoots2, (String)"sourceRoots");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        this.javaSourceFolders = sourceRoots2;
        this.addFilteredFiles(sources);
    }

    public final void setTestSources(@NotNull List<? extends File> sourceRoots2, @NotNull List<? extends File> sources) {
        Intrinsics.checkNotNullParameter(sourceRoots2, (String)"sourceRoots");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        this.testSourceFolders = sourceRoots2;
        this.addFilteredFiles(sources);
    }

    public final void setGeneratedSources(@NotNull List<? extends File> sourceRoots2, @NotNull List<? extends File> sources) {
        Intrinsics.checkNotNullParameter(sourceRoots2, (String)"sourceRoots");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        this.generatedSourceFolders = sourceRoots2;
        this.addFilteredFiles(sources);
    }

    private final void addFilteredFiles(List<? extends File> sources) {
        if (!((Collection)sources).isEmpty()) {
            if (this.files == null) {
                this.files = new ArrayList();
            }
            this.files.addAll((Collection)sources);
        }
    }

    public final void setProguardFiles(@Nullable List<? extends File> files) {
        this.proguardFiles = files;
    }

    public final void setClasspath(@NotNull List<? extends File> allClasses, boolean useForAnalysis) {
        Intrinsics.checkNotNullParameter(allClasses, (String)"allClasses");
        if (useForAnalysis) {
            this.javaClassFolders = allClasses;
        } else {
            this.javaLibraries = allClasses;
        }
    }

    public final void setCompileSdkVersion(@NotNull String buildApi) {
        Intrinsics.checkNotNullParameter((Object)buildApi, (String)"buildApi");
        if (((CharSequence)buildApi).length() > 0) {
            this.buildTargetHash = Character.isDigit(buildApi.charAt(0)) ? "android-" + buildApi : buildApi;
            AndroidVersion version = AndroidTargetHash.getPlatformVersion((String)buildApi);
            if (version != null) {
                this.buildSdk = version.getFeatureLevel();
            } else {
                Object[] objectArray = new Object[]{buildApi};
                this.client.log(Severity.WARNING, null, "Unexpected build target format: %1$s", objectArray);
            }
        }
    }

    public final void setDesugaring(@Nullable Set<? extends Desugaring> desugaring) {
        this.desugaring = desugaring;
    }

    public final void setResourceVisibility(@Nullable ResourceVisibilityLookup resourceVisibility) {
        this.resourceVisibility = resourceVisibility;
    }

    @NotNull
    public ResourceVisibilityLookup getResourceVisibility() {
        ResourceVisibilityLookup resourceVisibilityLookup = this.resourceVisibility;
        if (resourceVisibilityLookup == null) {
            ResourceVisibilityLookup resourceVisibilityLookup2 = super.getResourceVisibility();
            resourceVisibilityLookup = resourceVisibilityLookup2;
            Intrinsics.checkNotNullExpressionValue((Object)resourceVisibilityLookup2, (String)"getResourceVisibility(...)");
        }
        return resourceVisibilityLookup;
    }

    @Nullable
    public LintModelVariant getBuildVariant() {
        return this.variant;
    }

    @Nullable
    public UastParser.UastSourceList getUastSourceList(@NotNull LintDriver driver, @Nullable Project main) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        List list2 = this.files;
        if (list2 == null) {
            return null;
        }
        List files = list2;
        int initialCapacity = files.size();
        ArrayList<JavaContext> contexts = new ArrayList<JavaContext>(initialCapacity);
        ArrayList<JavaContext> testContexts = new ArrayList<JavaContext>(initialCapacity);
        ArrayList<JavaContext> generatedContexts = new ArrayList<JavaContext>(initialCapacity);
        ArrayList<JavaContext> gradleKtsContexts = new ArrayList<JavaContext>(2);
        Set testSet = CollectionsKt.toSet((Iterable)this.testFiles);
        Set generatedSet = CollectionsKt.toSet((Iterable)this.generatedFiles);
        for (File file : files) {
            boolean bl;
            String path = file.getPath();
            Intrinsics.checkNotNull((Object)path);
            if (!StringsKt.endsWith$default((String)path, (String)".java", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)path, (String)".kt", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)path, (String)".kts", (boolean)false, (int)2, null)) continue;
            Project project = this;
            Intrinsics.checkNotNull((Object)file);
            JavaContext context = new JavaContext(driver, project, main, file);
            if (StringsKt.endsWith$default((String)path, (String)".kts", (boolean)false, (int)2, null)) {
                bl = gradleKtsContexts.add(context);
                continue;
            }
            if (testSet.contains(file)) {
                context.setSourceSetType(SourceSetType.UNIT_TESTS);
                context.setTestSource(true);
                if (generatedSet.contains(file)) {
                    context.setGeneratedSource(true);
                }
                bl = testContexts.add(context);
                continue;
            }
            if (generatedSet.contains(file)) {
                context.setSourceSetType(SourceSetType.MAIN);
                context.setGeneratedSource(true);
                bl = generatedContexts.add(context);
                continue;
            }
            context.setSourceSetType(SourceSetType.MAIN);
            bl = contexts.add(context);
        }
        return new UastParser.UastSourceList(this.client.getUastParser((Project)this), (List)contexts, (List)testContexts, CollectionsKt.emptyList(), (List)generatedContexts, (List)gradleKtsContexts);
    }

    public void readManifest(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
    }

    public final void initializeSdkLevelInfo(@Nullable File mergedManifest, @Nullable File manifest) {
        block3: {
            Document it;
            Document initFrom;
            if (this.dom != null) {
                this.client.log(Severity.WARNING, (Throwable)new IllegalStateException("Tried to initialize project SDK level info more than once"), null, new Object[0]);
                return;
            }
            File file = mergedManifest;
            Document mergedManifestDoc = file != null ? ManualProject.initializeSdkLevelInfo$parseSilently(file) : null;
            File file2 = manifest;
            Document manifestDoc = file2 != null ? ManualProject.initializeSdkLevelInfo$parseSilently(file2) : null;
            Document document = mergedManifestDoc;
            if (document == null) {
                document = manifestDoc;
            }
            Document document2 = initFrom = document;
            if (document2 != null) {
                it = document2;
                boolean bl = false;
                super.readManifest(it);
            }
            Document document3 = manifestDoc;
            if (document3 == null) break block3;
            it = document3;
            boolean bl = false;
            this.dom = it;
        }
    }

    private static final Document initializeSdkLevelInfo$parseSilently(File $this$initializeSdkLevelInfo_u24parseSilently) {
        return XmlUtils.parseDocumentSilently((String)FilesKt.readText$default((File)$this$initializeSdkLevelInfo_u24parseSilently, null, (int)1, null), (boolean)true);
    }
}

