/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer.builder;

import com.android.tools.smali.dexlib2.iface.reference.CallSiteReference;
import com.android.tools.smali.dexlib2.writer.CallSiteSection;
import com.android.tools.smali.dexlib2.writer.builder.BaseBuilderPool;
import com.android.tools.smali.dexlib2.writer.builder.BuilderCallSiteReference;
import com.android.tools.smali.dexlib2.writer.builder.BuilderEncodedArrayPool;
import com.android.tools.smali.dexlib2.writer.builder.BuilderEncodedValues;
import com.android.tools.smali.dexlib2.writer.builder.BuilderMapEntryCollection;
import com.android.tools.smali.dexlib2.writer.builder.DexBuilder;
import com.android.tools.smali.dexlib2.writer.util.CallSiteUtil;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public class BuilderCallSitePool
extends BaseBuilderPool
implements CallSiteSection<BuilderCallSiteReference, BuilderEncodedValues.BuilderArrayEncodedValue> {
    @Nonnull
    private final ConcurrentMap<CallSiteReference, BuilderCallSiteReference> internedItems = Maps.newConcurrentMap();

    public BuilderCallSitePool(@Nonnull DexBuilder dexBuilder) {
        super(dexBuilder);
    }

    @Nonnull
    public BuilderCallSiteReference internCallSite(@Nonnull CallSiteReference callSiteReference) {
        BuilderCallSiteReference internedCallSite = (BuilderCallSiteReference)this.internedItems.get(callSiteReference);
        if (internedCallSite != null) {
            return internedCallSite;
        }
        BuilderEncodedValues.BuilderArrayEncodedValue encodedCallSite = ((BuilderEncodedArrayPool)this.dexBuilder.encodedArraySection).internArrayEncodedValue(CallSiteUtil.getEncodedCallSite(callSiteReference));
        internedCallSite = new BuilderCallSiteReference(callSiteReference.getName(), encodedCallSite);
        BuilderCallSiteReference existing = this.internedItems.putIfAbsent(internedCallSite, internedCallSite);
        return existing == null ? internedCallSite : existing;
    }

    @Override
    public BuilderEncodedValues.BuilderArrayEncodedValue getEncodedCallSite(BuilderCallSiteReference callSiteReference) {
        return callSiteReference.encodedCallSite;
    }

    @Override
    public int getItemIndex(@Nonnull BuilderCallSiteReference builderCallSite) {
        return builderCallSite.index;
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends BuilderCallSiteReference, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderCallSiteReference>(this.internedItems.values()){

            @Override
            protected int getValue(@Nonnull BuilderCallSiteReference builderCallSiteReference) {
                return builderCallSiteReference.index;
            }

            @Override
            protected int setValue(@Nonnull BuilderCallSiteReference builderCallSiteReference, int value) {
                int prev = builderCallSiteReference.index;
                builderCallSiteReference.index = value;
                return prev;
            }
        };
    }

    @Override
    public int getItemCount() {
        return this.internedItems.size();
    }
}

