/*
 * $Header: /cvshome/build/org.osgi.service.metatype2/src/org/osgi/service/metatype2/ActionDefinition.java,v 1.4 2005/05/13 20:33:55 hargrave Exp $
 * 
 * Copyright (c) OSGi Alliance (2005). All Rights Reserved.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html.
 */

package org.osgi.service.metatype2;

/**
 * An interface to describe an action.
 *
 * <p>An <tt>ActionDefinition</tt> object defines a description of an action.
 * An action is very similar to an attribute, it only adds the definition of the
 * input arguments if any.
 *
 * @version $Revision: 1.4 $
 */
public interface ActionDefinition extends ExtendedAttributeDefinition {
	
	/**
	 * The <code>VOID(13)</code> type. 
	 * 
	 * The action may have VOID type meaning that it does not 
	 * have output results.
	 */
	public static final int VOID = 13;
	
  /**
	 * Returns the definitions of the input arguments of this action
	 * 
	 * @return The definitions of the input arguments or null if there is no input arguments.
	 */
    ExtendedAttributeDefinition[] getInputArgumentDefinitions();
}


