/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator.bsdiff;

import com.google.archivepatcher.generator.bsdiff.RandomAccessObject;
import com.google.archivepatcher.generator.bsdiff.RandomAccessObjectFactory;
import com.google.archivepatcher.generator.bsdiff.SuffixSorter;
import java.io.IOException;

public final class DivSuffixSorter
implements SuffixSorter {
    private static final int ALPHABET_SIZE = 256;
    private static final int BUCKET_A_SIZE = 256;
    private static final int BUCKET_B_SIZE = 65536;
    private static final int SS_INSERTIONSORT_THRESHOLD = 8;
    private static final int SS_BLOCKSIZE = 1024;
    private static final int SS_MISORT_STACKSIZE = 16;
    private static final int SS_SMERGE_STACKSIZE = 32;
    private static final int TR_STACKSIZE = 64;
    private static final int TR_INSERTIONSORT_THRESHOLD = 8;
    private static final int[] SQQ_TABLE = new int[]{0, 16, 22, 27, 32, 35, 39, 42, 45, 48, 50, 53, 55, 57, 59, 61, 64, 65, 67, 69, 71, 73, 75, 76, 78, 80, 81, 83, 84, 86, 87, 89, 90, 91, 93, 94, 96, 97, 98, 99, 101, 102, 103, 104, 106, 107, 108, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 128, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 144, 145, 146, 147, 148, 149, 150, 150, 151, 152, 153, 154, 155, 155, 156, 157, 158, 159, 160, 160, 161, 162, 163, 163, 164, 165, 166, 167, 167, 168, 169, 170, 170, 171, 172, 173, 173, 174, 175, 176, 176, 177, 178, 178, 179, 180, 181, 181, 182, 183, 183, 184, 185, 185, 186, 187, 187, 188, 189, 189, 190, 191, 192, 192, 193, 193, 194, 195, 195, 196, 197, 197, 198, 199, 199, 200, 201, 201, 202, 203, 203, 204, 204, 205, 206, 206, 207, 208, 208, 209, 209, 210, 211, 211, 212, 212, 213, 214, 214, 215, 215, 216, 217, 217, 218, 218, 219, 219, 220, 221, 221, 222, 222, 223, 224, 224, 225, 225, 226, 226, 227, 227, 228, 229, 229, 230, 230, 231, 231, 232, 232, 233, 234, 234, 235, 235, 236, 236, 237, 237, 238, 238, 239, 240, 240, 241, 241, 242, 242, 243, 243, 244, 244, 245, 245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 251, 251, 252, 252, 253, 253, 254, 254, 255};
    private static final int[] LG_TABLE = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private final RandomAccessObjectFactory randomAccessObjectFactory;
    private RandomAccessObject suffixArray;
    private RandomAccessObject input;

    public DivSuffixSorter(RandomAccessObjectFactory randomAccessObjectFactory) {
        this.randomAccessObjectFactory = randomAccessObjectFactory;
    }

    @Override
    public RandomAccessObject suffixSort(RandomAccessObject input) throws IOException, InterruptedException {
        if (4L * (input.length() + 1L) >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Input too large (" + input.length() + " bytes)");
        }
        int length = (int)input.length();
        RandomAccessObject suffixArray = this.randomAccessObjectFactory.create((length + 1) * 4);
        suffixArray.seek(0L);
        suffixArray.writeInt(length);
        this.suffixArray = suffixArray;
        if (length == 0) {
            return suffixArray;
        }
        if (length == 1) {
            this.writeSuffixArray(0L, 0);
            return suffixArray;
        }
        this.input = input;
        int[] bucketA = new int[256];
        int[] bucketB = new int[65536];
        int m = this.sortTypeBstar(bucketA, bucketB, length);
        this.constructSuffixArray(bucketA, bucketB, length, m);
        return suffixArray;
    }

    private final void constructSuffixArray(int[] bucketA, int[] bucketB, int n, int m) throws IOException {
        int c0;
        int s;
        int j;
        int c2;
        int k;
        int i;
        if (0 < m) {
            for (int c1 = 254; 0 <= c1; --c1) {
                i = bucketB[c1 * 256 + (c1 + 1)];
                k = 0;
                c2 = -1;
                for (j = bucketA[c1 + 1] - 1; i <= j; --j) {
                    s = this.readSuffixArray(j);
                    if (0 < s) {
                        this.writeSuffixArray(j, ~s);
                        c0 = this.readInput(--s);
                        if (0 < s && this.readInput(s - 1) > c0) {
                            s ^= 0xFFFFFFFF;
                        }
                        if (c0 != c2) {
                            if (0 <= c2) {
                                bucketB[c1 * 256 + c2] = k;
                            }
                            c2 = c0;
                            k = bucketB[c1 * 256 + c2];
                        }
                        this.writeSuffixArray(k--, s);
                        continue;
                    }
                    this.writeSuffixArray(j, ~s);
                }
            }
        }
        c2 = this.readInput(n - 1);
        k = bucketA[c2];
        this.writeSuffixArray(k++, this.readInput(n - 2) < c2 ? ~(n - 1) : n - 1);
        j = n;
        for (i = 0; i < j; ++i) {
            s = this.readSuffixArray(i);
            if (0 < s) {
                c0 = this.readInput(--s);
                if (s == 0 || this.readInput(s - 1) < c0) {
                    s ^= 0xFFFFFFFF;
                }
                if (c0 != c2) {
                    bucketA[c2] = k;
                    c2 = c0;
                    k = bucketA[c2];
                }
                this.writeSuffixArray(k++, s);
                continue;
            }
            this.writeSuffixArray(i, ~s);
        }
    }

    private final int sortTypeBstar(int[] bucketA, int[] bucketB, int n) throws IOException, InterruptedException {
        int t;
        int c1 = 0;
        int i = n - 1;
        int m = n;
        int c0 = this.readInput(n - 1);
        while (0 <= i) {
            do {
                c1 = c0;
                bucketA[c1] = bucketA[c1] + 1;
            } while (0 <= --i && (c0 = this.readInput(i)) >= c1);
            if (0 > i) continue;
            int n2 = c0 * 256 + c1;
            bucketB[n2] = bucketB[n2] + 1;
            this.writeSuffixArray(--m, i);
            --i;
            c1 = c0;
            while (0 <= i && (c0 = this.readInput(i)) <= c1) {
                int n3 = c1 * 256 + c0;
                bucketB[n3] = bucketB[n3] + 1;
                --i;
                c1 = c0;
            }
        }
        m = n - m;
        i = 0;
        int j = 0;
        for (c0 = 0; c0 < 256; ++c0) {
            t = i + bucketA[c0];
            bucketA[c0] = i + j;
            i = t + bucketB[c0 * 256 + c0];
            for (c1 = c0 + 1; c1 < 256; ++c1) {
                bucketB[c0 * 256 + c1] = j += bucketB[c0 * 256 + c1];
                i += bucketB[c1 * 256 + c0];
            }
        }
        if (0 < m) {
            int PAb = n - m;
            int ISAb = m;
            for (i = m - 2; 0 <= i; --i) {
                t = this.readSuffixArray(PAb + i);
                c0 = this.readInput(t);
                c1 = this.readInput(t + 1);
                int n4 = c0 * 256 + c1;
                int n5 = bucketB[n4] - 1;
                bucketB[n4] = n5;
                this.writeSuffixArray(n5, i);
            }
            t = this.readSuffixArray(PAb + m - 1);
            c0 = this.readInput(t);
            c1 = this.readInput(t + 1);
            int n6 = c0 * 256 + c1;
            int n7 = bucketB[n6] - 1;
            bucketB[n6] = n7;
            this.writeSuffixArray(n7, m - 1);
            int buf = m;
            int bufsize = n - 2 * m;
            c0 = 254;
            j = m;
            while (0 < j) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                for (c1 = 255; c0 < c1; --c1) {
                    i = bucketB[c0 * 256 + c1];
                    if (1 < j - i) {
                        this.ssSort(PAb, i, j, buf, bufsize, 2, n, this.readSuffixArray(i) == m - 1);
                    }
                    j = i;
                }
                --c0;
            }
            for (i = m - 1; 0 <= i; --i) {
                if (0 <= this.readSuffixArray(i)) {
                    j = i;
                    do {
                        this.writeSuffixArray(ISAb + this.readSuffixArray(i), i);
                    } while (0 <= --i && 0 <= this.readSuffixArray(i));
                    this.writeSuffixArray(i + 1, i - j);
                    if (i <= 0) break;
                }
                j = i;
                do {
                    this.writeSuffixArray(ISAb + this.writeSuffixArray(i, ~this.readSuffixArray(i)), j);
                } while (this.readSuffixArray(--i) < 0);
                this.writeSuffixArray(ISAb + this.readSuffixArray(i), j);
            }
            this.trSort(ISAb, m, 1);
            i = n - 1;
            j = m;
            c0 = this.readInput(n - 1);
            while (0 <= i) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                --i;
                c1 = c0;
                while (0 <= i && (c0 = this.readInput(i)) >= c1) {
                    --i;
                    c1 = c0;
                }
                if (0 > i) continue;
                t = i--;
                c1 = c0;
                while (0 <= i && (c0 = this.readInput(i)) <= c1) {
                    --i;
                    c1 = c0;
                }
                this.writeSuffixArray(this.readSuffixArray(ISAb + --j), t == 0 || 1 < t - i ? t : ~t);
            }
            bucketB[65535] = n;
            int k = m - 1;
            for (c0 = 254; 0 <= c0; --c0) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                i = bucketA[c0 + 1] - 1;
                for (c1 = 255; c0 < c1; --c1) {
                    t = i - bucketB[c1 * 256 + c0];
                    bucketB[c1 * 256 + c0] = i;
                    i = t;
                    j = bucketB[c0 * 256 + c1];
                    while (j <= k) {
                        this.writeSuffixArray(i, this.readSuffixArray(k));
                        --i;
                        --k;
                    }
                }
                bucketB[c0 * 256 + (c0 + 1)] = i - bucketB[c0 * 256 + c0] + 1;
                bucketB[c0 * 256 + c0] = i;
            }
        }
        return m;
    }

    private final void ssSort(int PA, int first, int last, int buf, int bufsize, int depth, int n, boolean lastsuffix) throws IOException {
        int k;
        int middle;
        int limit;
        if (lastsuffix) {
            ++first;
        }
        if (bufsize < 1024 && bufsize < last - first && bufsize < (limit = DivSuffixSorter.ssIsqrt(last - first))) {
            if (1024 < limit) {
                limit = 1024;
            }
            buf = middle = last - limit;
            bufsize = limit;
        } else {
            middle = last;
            limit = 0;
        }
        int a = first;
        int i = 0;
        while (1024 < middle - a) {
            this.ssMintroSort(PA, a, a + 1024, depth);
            int curbufsize = last - (a + 1024);
            int curbuf = a + 1024;
            if (curbufsize <= bufsize) {
                curbufsize = bufsize;
                curbuf = buf;
            }
            int b = a;
            k = 1024;
            int j = i;
            while ((j & 1) != 0) {
                this.ssSwapMerge(PA, b - k, b, b + k, curbuf, curbufsize, depth);
                b -= k;
                k <<= 1;
                j >>= 1;
            }
            a += 1024;
            ++i;
        }
        this.ssMintroSort(PA, a, middle, depth);
        k = 1024;
        while (i != 0) {
            if (i & true) {
                this.ssSwapMerge(PA, a - k, a, middle, buf, bufsize, depth);
                a -= k;
            }
            k <<= 1;
            i >>= 1;
        }
        if (limit != 0) {
            this.ssMintroSort(PA, middle, last, depth);
            this.ssInplaceMerge(PA, first, middle, last, depth);
        }
        if (lastsuffix) {
            int p1 = this.readSuffixArray(PA + this.readSuffixArray(first - 1));
            int p11 = n - 2;
            i = this.readSuffixArray(first - 1);
            for (a = first; a < last && (this.readSuffixArray(a) < 0 || 0 < this.ssCompare(p1, p11, PA + this.readSuffixArray(a), depth)); ++a) {
                this.writeSuffixArray(a - 1, this.readSuffixArray(a));
            }
            this.writeSuffixArray(a - 1, i);
        }
    }

    private final int ssCompare(int pa, int pb, int p2, int depth) throws IOException {
        int U2;
        int U1 = depth + pa;
        int U1n = pb + 2;
        int U2n = this.readSuffixArray(p2 + 1) + 2;
        for (U2 = depth + this.readSuffixArray(p2); U1 < U1n && U2 < U2n && this.readInput(U1) == this.readInput(U2); ++U1, ++U2) {
        }
        return U1 < U1n ? (U2 < U2n ? this.readInput(U1) - this.readInput(U2) : 1) : (U2 < U2n ? -1 : 0);
    }

    private final int ssCompare(int p1, int p2, int depth) throws IOException {
        int U2;
        int U1 = depth + this.readSuffixArray(p1);
        int U1n = this.readSuffixArray(p1 + 1) + 2;
        int U2n = this.readSuffixArray(p2 + 1) + 2;
        for (U2 = depth + this.readSuffixArray(p2); U1 < U1n && U2 < U2n && this.readInput(U1) == this.readInput(U2); ++U1, ++U2) {
        }
        return U1 < U1n ? (U2 < U2n ? this.readInput(U1) - this.readInput(U2) : 1) : (U2 < U2n ? -1 : 0);
    }

    private final void ssInplaceMerge(int PA, int first, int middle, int last, int depth) throws IOException {
        do {
            int p;
            boolean x;
            if (this.readSuffixArray(last - 1) < 0) {
                x = true;
                p = PA + ~this.readSuffixArray(last - 1);
            } else {
                x = false;
                p = PA + this.readSuffixArray(last - 1);
            }
            int a = first;
            int len = middle - first;
            int half = len >> 1;
            int r = -1;
            while (0 < len) {
                int b = a + half;
                int q = this.ssCompare(PA + (0 <= this.readSuffixArray(b) ? this.readSuffixArray(b) : ~this.readSuffixArray(b)), p, depth);
                if (q < 0) {
                    a = b + 1;
                    half -= len & 1 ^ 1;
                } else {
                    r = q;
                }
                len = half;
                half >>= 1;
            }
            if (a < middle) {
                if (r == 0) {
                    this.writeSuffixArray(a, ~this.readSuffixArray(a));
                }
                this.ssRotate(a, middle, last);
                last -= middle - a;
                middle = a;
                if (first == middle) break;
            }
            --last;
            if (!x) continue;
            while (this.readSuffixArray(--last) < 0) {
            }
        } while (middle != last);
    }

    private final void ssRotate(int first, int middle, int last) throws IOException {
        int l = middle - first;
        int r = last - middle;
        block0: while (0 < l && 0 < r) {
            int t;
            int b;
            int a;
            if (l == r) {
                this.ssBlockSwap(first, middle, l);
                break;
            }
            if (l < r) {
                a = last - 1;
                b = middle - 1;
                t = this.readSuffixArray(a);
                while (true) {
                    this.writeSuffixArray(a--, this.readSuffixArray(b));
                    this.writeSuffixArray(b--, this.readSuffixArray(a));
                    if (b >= first) continue;
                    this.writeSuffixArray(a, t);
                    last = a--;
                    if ((r -= l + 1) <= l) continue block0;
                    b = middle - 1;
                    t = this.readSuffixArray(a);
                }
            }
            a = first;
            b = middle;
            t = this.readSuffixArray(a);
            while (true) {
                this.writeSuffixArray(a++, this.readSuffixArray(b));
                this.writeSuffixArray(b++, this.readSuffixArray(a));
                if (last > b) continue;
                this.writeSuffixArray(a, t);
                first = a + 1;
                if ((l -= r + 1) <= r) continue block0;
                b = middle;
                t = this.readSuffixArray(++a);
            }
        }
    }

    private final void ssBlockSwap(int a, int b, int n) throws IOException {
        while (0 < n) {
            int t = this.readSuffixArray(a);
            this.writeSuffixArray(a, this.readSuffixArray(b));
            this.writeSuffixArray(b, t);
            --n;
            ++a;
            ++b;
        }
    }

    private static final int getIDX(int a) {
        return 0 <= a ? a : ~a;
    }

    private static final int min(int a, int b) {
        return a < b ? a : b;
    }

    private final void ssSwapMerge(int PA, int first, int middle, int last, int buf, int bufsize, int depth) throws IOException {
        int STACK_SIZE = 32;
        StackElement[] stack = new StackElement[32];
        int check = 0;
        int ssize = 0;
        while (true) {
            StackElement se;
            if (last - middle <= bufsize) {
                if (first < middle && middle < last) {
                    this.ssMergeBackward(PA, first, middle, last, buf, depth);
                }
                if (check & true || (check & 2) != 0 && this.ssCompare(PA + DivSuffixSorter.getIDX(this.readSuffixArray(first - 1)), PA + this.readSuffixArray(first), depth) == 0) {
                    this.writeSuffixArray(first, ~this.readSuffixArray(first));
                }
                if ((check & 4) != 0 && this.ssCompare(PA + DivSuffixSorter.getIDX(this.readSuffixArray(last - 1)), PA + this.readSuffixArray(last), depth) == 0) {
                    this.writeSuffixArray(last, ~this.readSuffixArray(last));
                }
                if (ssize > 0) {
                    se = stack[--ssize];
                    first = se.a;
                    middle = se.b;
                    last = se.c;
                    check = se.d;
                    continue;
                }
                return;
            }
            if (middle - first <= bufsize) {
                if (first < middle) {
                    this.ssMergeForward(PA, first, middle, last, buf, depth);
                }
                if ((check & 1) != 0 || (check & 2) != 0 && this.ssCompare(PA + DivSuffixSorter.getIDX(this.readSuffixArray(first - 1)), PA + this.readSuffixArray(first), depth) == 0) {
                    this.writeSuffixArray(first, ~this.readSuffixArray(first));
                }
                if ((check & 4) != 0 && this.ssCompare(PA + DivSuffixSorter.getIDX(this.readSuffixArray(last - 1)), PA + this.readSuffixArray(last), depth) == 0) {
                    this.writeSuffixArray(last, ~this.readSuffixArray(last));
                }
                if (ssize > 0) {
                    se = stack[--ssize];
                    first = se.a;
                    middle = se.b;
                    last = se.c;
                    check = se.d;
                    continue;
                }
                return;
            }
            int m = 0;
            int len = DivSuffixSorter.min(middle - first, last - middle);
            int half = len >> 1;
            while (0 < len) {
                if (this.ssCompare(PA + DivSuffixSorter.getIDX(this.readSuffixArray(middle + m + half)), PA + DivSuffixSorter.getIDX(this.readSuffixArray(middle - m - half - 1)), depth) < 0) {
                    m += half + 1;
                    half -= len & 1 ^ 1;
                }
                len = half;
                half >>= 1;
            }
            if (0 < m) {
                int r;
                int lm = middle - m;
                int rm = middle + m;
                this.ssBlockSwap(lm, middle, m);
                int l = r = middle;
                int next = 0;
                if (rm < last) {
                    if (this.readSuffixArray(rm) < 0) {
                        this.writeSuffixArray(rm, ~this.readSuffixArray(rm));
                        if (first < lm) {
                            while (this.readSuffixArray(--l) < 0) {
                            }
                            next |= 4;
                        }
                        next |= 1;
                    } else if (first < lm) {
                        while (this.readSuffixArray(r) < 0) {
                            ++r;
                        }
                        next |= 2;
                    }
                }
                if (l - first <= last - r) {
                    stack[ssize++] = new StackElement(r, rm, last, next & 3 | check & 4);
                    middle = lm;
                    last = l;
                    check = check & 3 | next & 4;
                    continue;
                }
                if ((next & 2) != 0 && r == middle) {
                    next ^= 6;
                }
                stack[ssize++] = new StackElement(first, lm, l, check & 3 | next & 4);
                first = r;
                middle = rm;
                check = next & 3 | check & 4;
                continue;
            }
            if (this.ssCompare(PA + DivSuffixSorter.getIDX(this.readSuffixArray(middle - 1)), PA + this.readSuffixArray(middle), depth) == 0) {
                this.writeSuffixArray(middle, ~this.readSuffixArray(middle));
            }
            if ((check & 1) != 0 || (check & 2) != 0 && this.ssCompare(PA + DivSuffixSorter.getIDX(this.readSuffixArray(first - 1)), PA + this.readSuffixArray(first), depth) == 0) {
                this.writeSuffixArray(first, ~this.readSuffixArray(first));
            }
            if ((check & 4) != 0 && this.ssCompare(PA + DivSuffixSorter.getIDX(this.readSuffixArray(last - 1)), PA + this.readSuffixArray(last), depth) == 0) {
                this.writeSuffixArray(last, ~this.readSuffixArray(last));
            }
            if (ssize <= 0) break;
            se = stack[--ssize];
            first = se.a;
            middle = se.b;
            last = se.c;
            check = se.d;
        }
    }

    private final void ssMergeForward(int PA, int first, int middle, int last, int buf, int depth) throws IOException {
        int bufend = buf + (middle - first) - 1;
        this.ssBlockSwap(buf, first, middle - first);
        int a = first;
        int t = this.readSuffixArray(a);
        int b = buf;
        int c = middle;
        while (true) {
            int r;
            if ((r = this.ssCompare(PA + this.readSuffixArray(b), PA + this.readSuffixArray(c), depth)) < 0) {
                do {
                    this.writeSuffixArray(a++, this.readSuffixArray(b));
                    if (bufend <= b) {
                        this.writeSuffixArray(bufend, t);
                        return;
                    }
                    this.writeSuffixArray(b++, this.readSuffixArray(a));
                } while (this.readSuffixArray(b) < 0);
                continue;
            }
            if (r > 0) {
                do {
                    this.writeSuffixArray(a++, this.readSuffixArray(c));
                    this.writeSuffixArray(c++, this.readSuffixArray(a));
                    if (last > c) continue;
                    while (b < bufend) {
                        this.writeSuffixArray(a++, this.readSuffixArray(b));
                        this.writeSuffixArray(b++, this.readSuffixArray(a));
                    }
                    this.writeSuffixArray(a, this.readSuffixArray(b));
                    this.writeSuffixArray(b, t);
                    return;
                } while (this.readSuffixArray(c) < 0);
                continue;
            }
            this.writeSuffixArray(c, ~this.readSuffixArray(c));
            do {
                this.writeSuffixArray(a++, this.readSuffixArray(b));
                if (bufend <= b) {
                    this.writeSuffixArray(bufend, t);
                    return;
                }
                this.writeSuffixArray(b++, this.readSuffixArray(a));
            } while (this.readSuffixArray(b) < 0);
            do {
                this.writeSuffixArray(a++, this.readSuffixArray(c));
                this.writeSuffixArray(c++, this.readSuffixArray(a));
                if (last > c) continue;
                while (b < bufend) {
                    this.writeSuffixArray(a++, this.readSuffixArray(b));
                    this.writeSuffixArray(b++, this.readSuffixArray(a));
                }
                this.writeSuffixArray(a, this.readSuffixArray(b));
                this.writeSuffixArray(b, t);
                return;
            } while (this.readSuffixArray(c) < 0);
        }
    }

    private final void ssMergeBackward(int PA, int first, int middle, int last, int buf, int depth) throws IOException {
        int p2;
        int p1;
        int bufend = buf + (last - middle) - 1;
        this.ssBlockSwap(buf, middle, last - middle);
        int x = 0;
        if (this.readSuffixArray(bufend) < 0) {
            p1 = PA + ~this.readSuffixArray(bufend);
            x |= 1;
        } else {
            p1 = PA + this.readSuffixArray(bufend);
        }
        if (this.readSuffixArray(middle - 1) < 0) {
            p2 = PA + ~this.readSuffixArray(middle - 1);
            x |= 2;
        } else {
            p2 = PA + this.readSuffixArray(middle - 1);
        }
        int a = last - 1;
        int t = this.readSuffixArray(a);
        int b = bufend;
        int c = middle - 1;
        while (true) {
            int r;
            if (0 < (r = this.ssCompare(p1, p2, depth))) {
                if ((x & 1) != 0) {
                    do {
                        this.writeSuffixArray(a--, this.readSuffixArray(b));
                        this.writeSuffixArray(b--, this.readSuffixArray(a));
                    } while (this.readSuffixArray(b) < 0);
                    x ^= 1;
                }
                this.writeSuffixArray(a--, this.readSuffixArray(b));
                if (b <= buf) {
                    this.writeSuffixArray(buf, t);
                    break;
                }
                this.writeSuffixArray(b--, this.readSuffixArray(a));
                if (this.readSuffixArray(b) < 0) {
                    p1 = PA + ~this.readSuffixArray(b);
                    x |= 1;
                    continue;
                }
                p1 = PA + this.readSuffixArray(b);
                continue;
            }
            if (r < 0) {
                if ((x & 2) != 0) {
                    do {
                        this.writeSuffixArray(a--, this.readSuffixArray(c));
                        this.writeSuffixArray(c--, this.readSuffixArray(a));
                    } while (this.readSuffixArray(c) < 0);
                    x ^= 2;
                }
                this.writeSuffixArray(a--, this.readSuffixArray(c));
                this.writeSuffixArray(c--, this.readSuffixArray(a));
                if (c < first) {
                    while (buf < b) {
                        this.writeSuffixArray(a--, this.readSuffixArray(b));
                        this.writeSuffixArray(b--, this.readSuffixArray(a));
                    }
                    this.writeSuffixArray(a, this.readSuffixArray(b));
                    this.writeSuffixArray(b, t);
                    break;
                }
                if (this.readSuffixArray(c) < 0) {
                    p2 = PA + ~this.readSuffixArray(c);
                    x |= 2;
                    continue;
                }
                p2 = PA + this.readSuffixArray(c);
                continue;
            }
            if ((x & 1) != 0) {
                do {
                    this.writeSuffixArray(a--, this.readSuffixArray(b));
                    this.writeSuffixArray(b--, this.readSuffixArray(a));
                } while (this.readSuffixArray(b) < 0);
                x ^= 1;
            }
            this.writeSuffixArray(a--, ~this.readSuffixArray(b));
            if (b <= buf) {
                this.writeSuffixArray(buf, t);
                break;
            }
            this.writeSuffixArray(b--, this.readSuffixArray(a));
            if ((x & 2) != 0) {
                do {
                    this.writeSuffixArray(a--, this.readSuffixArray(c));
                    this.writeSuffixArray(c--, this.readSuffixArray(a));
                } while (this.readSuffixArray(c) < 0);
                x ^= 2;
            }
            this.writeSuffixArray(a--, this.readSuffixArray(c));
            this.writeSuffixArray(c--, this.readSuffixArray(a));
            if (c < first) {
                while (buf < b) {
                    this.writeSuffixArray(a--, this.readSuffixArray(b));
                    this.writeSuffixArray(b--, this.readSuffixArray(a));
                }
                this.writeSuffixArray(a, this.readSuffixArray(b));
                this.writeSuffixArray(b, t);
                break;
            }
            if (this.readSuffixArray(b) < 0) {
                p1 = PA + ~this.readSuffixArray(b);
                x |= 1;
            } else {
                p1 = PA + this.readSuffixArray(b);
            }
            if (this.readSuffixArray(c) < 0) {
                p2 = PA + ~this.readSuffixArray(c);
                x |= 2;
                continue;
            }
            p2 = PA + this.readSuffixArray(c);
        }
    }

    private final void ssInsertionSort(int PA, int first, int last, int depth) throws IOException {
        for (int i = last - 2; first <= i; --i) {
            int r;
            int t = this.readSuffixArray(i);
            int j = i + 1;
            while (0 < (r = this.ssCompare(PA + t, PA + this.readSuffixArray(j), depth))) {
                do {
                    this.writeSuffixArray(j - 1, this.readSuffixArray(j));
                } while (++j < last && this.readSuffixArray(j) < 0);
                if (last > j) continue;
            }
            if (r == 0) {
                this.writeSuffixArray(j, ~this.readSuffixArray(j));
            }
            this.writeSuffixArray(j - 1, t);
        }
    }

    private static final int ssIsqrt(int x) {
        int y;
        int e;
        if (x >= 0x100000) {
            return 1024;
        }
        int n = (x & 0xFFFF0000) != 0 ? ((x & 0xFF000000) != 0 ? 24 + LG_TABLE[x >> 24 & 0xFF] : 16 + LG_TABLE[x >> 16 & 0xFF]) : (e = (x & 0xFF00) != 0 ? 8 + LG_TABLE[x >> 8 & 0xFF] : LG_TABLE[x >> 0 & 0xFF]);
        if (e >= 16) {
            y = SQQ_TABLE[x >> e - 6 - (e & 1)] << (e >> 1) - 7;
            if (e >= 24) {
                y = y + 1 + x / y >> 1;
            }
            y = y + 1 + x / y >> 1;
        } else if (e >= 8) {
            y = (SQQ_TABLE[x >> e - 6 - (e & 1)] >> 7 - (e >> 1)) + 1;
        } else {
            return SQQ_TABLE[x] >> 4;
        }
        return x < y * y ? y - 1 : y;
    }

    private final void ssMintroSort(int PA, int first, int last, int depth) throws IOException {
        int STACK_SIZE = 16;
        StackElement[] stack = new StackElement[16];
        int x = 0;
        int ssize = 0;
        int limit = DivSuffixSorter.ssIlg(last - first);
        while (true) {
            int a;
            int v;
            if (last - first <= 8) {
                if (1 < last - first) {
                    this.ssInsertionSort(PA, first, last, depth);
                }
                if (ssize > 0) {
                    StackElement se = stack[--ssize];
                    first = se.a;
                    last = se.b;
                    depth = se.c;
                    limit = se.d;
                    continue;
                }
                return;
            }
            int Td = depth;
            if (limit-- == 0) {
                this.ssHeapSort(Td, PA, first, last - first);
            }
            if (limit < 0) {
                v = this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(first)));
                for (a = first + 1; a < last; ++a) {
                    x = this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(a)));
                    if (x == v) continue;
                    if (1 < a - first) break;
                    v = x;
                    first = a;
                }
                if (this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(first)) - 1) < v) {
                    first = this.ssPartition(PA, first, a, depth);
                }
                if (a - first <= last - a) {
                    if (1 < a - first) {
                        stack[ssize++] = new StackElement(a, last, depth, -1);
                        last = a;
                        ++depth;
                        limit = DivSuffixSorter.ssIlg(a - first);
                        continue;
                    }
                    first = a;
                    limit = -1;
                    continue;
                }
                if (1 < last - a) {
                    stack[ssize++] = new StackElement(first, a, depth + 1, DivSuffixSorter.ssIlg(a - first));
                    first = a;
                    limit = -1;
                    continue;
                }
                last = a;
                ++depth;
                limit = DivSuffixSorter.ssIlg(a - first);
                continue;
            }
            a = this.ssPivot(Td, PA, first, last);
            v = this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(a)));
            this.swapInSA(first, a);
            int b = first;
            while (++b < last && (x = this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(b)))) == v) {
            }
            a = b;
            if (a < last && x < v) {
                while (++b < last && (x = this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(b)))) <= v) {
                    if (x != v) continue;
                    this.swapInSA(b, a);
                    ++a;
                }
            }
            int c = last;
            while (b < --c && (x = this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(c)))) == v) {
            }
            int d = c;
            if (b < d && x > v) {
                while (b < --c && (x = this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(c)))) >= v) {
                    if (x != v) continue;
                    this.swapInSA(c, d);
                    --d;
                }
            }
            while (b < c) {
                this.swapInSA(b, c);
                while (++b < c && (x = this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(b)))) <= v) {
                    if (x != v) continue;
                    this.swapInSA(b, a);
                    ++a;
                }
                while (b < --c && (x = this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(c)))) >= v) {
                    if (x != v) continue;
                    this.swapInSA(c, d);
                    --d;
                }
            }
            if (a <= d) {
                c = b - 1;
                int s = a - first;
                int t = b - a;
                if (s > t) {
                    s = t;
                }
                int e = first;
                int f = b - s;
                while (0 < s) {
                    this.swapInSA(e, f);
                    --s;
                    ++e;
                    ++f;
                }
                s = d - c;
                t = last - d - 1;
                if (s > t) {
                    s = t;
                }
                e = b;
                f = last - s;
                while (0 < s) {
                    this.swapInSA(e, f);
                    --s;
                    ++e;
                    ++f;
                }
                a = first + (b - a);
                c = last - (d - c);
                int n = b = v <= this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(a)) - 1) ? a : this.ssPartition(PA, a, c, depth);
                if (a - first <= last - c) {
                    if (last - c <= c - b) {
                        stack[ssize++] = new StackElement(b, c, depth + 1, DivSuffixSorter.ssIlg(c - b));
                        stack[ssize++] = new StackElement(c, last, depth, limit);
                        last = a;
                        continue;
                    }
                    if (a - first <= c - b) {
                        stack[ssize++] = new StackElement(c, last, depth, limit);
                        stack[ssize++] = new StackElement(b, c, depth + 1, DivSuffixSorter.ssIlg(c - b));
                        last = a;
                        continue;
                    }
                    stack[ssize++] = new StackElement(c, last, depth, limit);
                    stack[ssize++] = new StackElement(first, a, depth, limit);
                    first = b;
                    last = c;
                    ++depth;
                    limit = DivSuffixSorter.ssIlg(c - b);
                    continue;
                }
                if (a - first <= c - b) {
                    stack[ssize++] = new StackElement(b, c, depth + 1, DivSuffixSorter.ssIlg(c - b));
                    stack[ssize++] = new StackElement(first, a, depth, limit);
                    first = c;
                    continue;
                }
                if (last - c <= c - b) {
                    stack[ssize++] = new StackElement(first, a, depth, limit);
                    stack[ssize++] = new StackElement(b, c, depth + 1, DivSuffixSorter.ssIlg(c - b));
                    first = c;
                    continue;
                }
                stack[ssize++] = new StackElement(first, a, depth, limit);
                stack[ssize++] = new StackElement(c, last, depth, limit);
                first = b;
                last = c;
                ++depth;
                limit = DivSuffixSorter.ssIlg(c - b);
                continue;
            }
            ++limit;
            if (this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(first)) - 1) < v) {
                first = this.ssPartition(PA, first, last, depth);
                limit = DivSuffixSorter.ssIlg(last - first);
            }
            ++depth;
        }
    }

    private final int ssPivot(int Td, int PA, int first, int last) throws IOException {
        int t = last - first;
        int middle = first + t / 2;
        if (t <= 512) {
            if (t <= 32) {
                return this.ssMedian3(Td, PA, first, middle, last - 1);
            }
            return this.ssMedian5(Td, PA, first, first + (t >>= 2), middle, last - 1 - t, last - 1);
        }
        first = this.ssMedian3(Td, PA, first, first + (t >>= 3), first + (t << 1));
        middle = this.ssMedian3(Td, PA, middle - t, middle, middle + t);
        last = this.ssMedian3(Td, PA, last - 1 - (t << 1), last - 1 - t, last - 1);
        return this.ssMedian3(Td, PA, first, middle, last);
    }

    private final int ssMedian5(int Td, int PA, int v1, int v2, int v3, int v4, int v5) throws IOException {
        int t;
        if (this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v2))) > this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v3)))) {
            t = v2;
            v2 = v3;
            v3 = t;
        }
        if (this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v4))) > this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v5)))) {
            t = v4;
            v4 = v5;
            v5 = t;
        }
        if (this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v2))) > this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v4)))) {
            t = v2;
            v2 = v4;
            v4 = t;
            t = v3;
            v3 = v5;
            v5 = t;
        }
        if (this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v1))) > this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v3)))) {
            t = v1;
            v1 = v3;
            v3 = t;
        }
        if (this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v1))) > this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v4)))) {
            t = v1;
            v1 = v4;
            v4 = t;
            t = v3;
            v3 = v5;
            v5 = t;
        }
        if (this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v3))) > this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v4)))) {
            return v4;
        }
        return v3;
    }

    private final int ssMedian3(int Td, int PA, int v1, int v2, int v3) throws IOException {
        if (this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v1))) > this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v2)))) {
            int t = v1;
            v1 = v2;
            v2 = t;
        }
        if (this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v2))) > this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v3)))) {
            if (this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v1))) > this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(v3)))) {
                return v1;
            }
            return v3;
        }
        return v2;
    }

    private final int ssPartition(int PA, int first, int last, int depth) throws IOException {
        int a = first - 1;
        int b = last;
        while (true) {
            if (++a < b && this.readSuffixArray(PA + this.readSuffixArray(a)) + depth >= this.readSuffixArray(PA + this.readSuffixArray(a) + 1) + 1) {
                this.writeSuffixArray(a, ~this.readSuffixArray(a));
                continue;
            }
            while (a < --b && this.readSuffixArray(PA + this.readSuffixArray(b)) + depth < this.readSuffixArray(PA + this.readSuffixArray(b) + 1) + 1) {
            }
            if (b <= a) break;
            int t = ~this.readSuffixArray(b);
            this.writeSuffixArray(b, this.readSuffixArray(a));
            this.writeSuffixArray(a, t);
        }
        if (first < a) {
            this.writeSuffixArray(first, ~this.readSuffixArray(first));
        }
        return a;
    }

    private final void ssHeapSort(int Td, int PA, int sa, int size) throws IOException {
        int i;
        int m = size;
        if (size % 2 == 0 && this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(sa + --m / 2))) < this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(sa + m)))) {
            this.swapInSA(sa + m, sa + m / 2);
        }
        for (i = m / 2 - 1; 0 <= i; --i) {
            this.ssFixDown(Td, PA, sa, i, m);
        }
        if (size % 2 == 0) {
            this.swapInSA(sa, sa + m);
            this.ssFixDown(Td, PA, sa, 0, m);
        }
        for (i = m - 1; 0 < i; --i) {
            int t = this.readSuffixArray(sa);
            this.writeSuffixArray(sa, this.readSuffixArray(sa + i));
            this.ssFixDown(Td, PA, sa, 0, i);
            this.writeSuffixArray(sa + i, t);
        }
    }

    private final void ssFixDown(int Td, int PA, int sa, int i, int size) throws IOException {
        int j;
        int v = this.readSuffixArray(sa + i);
        int c = this.readInput(Td + this.readSuffixArray(PA + v));
        while ((j = 2 * i + 1) < size) {
            int e;
            int k;
            int d;
            if ((d = this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(sa + (k = j++))))) < (e = this.readInput(Td + this.readSuffixArray(PA + this.readSuffixArray(sa + j))))) {
                k = j;
                d = e;
            }
            if (d <= c) break;
            this.writeSuffixArray(sa + i, this.readSuffixArray(sa + k));
            i = k;
        }
        this.writeSuffixArray(i + sa, v);
    }

    private static final int ssIlg(int n) {
        return (n & 0xFF00) != 0 ? 8 + LG_TABLE[n >> 8 & 0xFF] : LG_TABLE[n >> 0 & 0xFF];
    }

    private final void swapInSA(int a, int b) throws IOException {
        int tmp = this.readSuffixArray(a);
        this.writeSuffixArray(a, this.readSuffixArray(b));
        this.writeSuffixArray(b, tmp);
    }

    private final void trSort(int ISA, int n, int depth) throws IOException, InterruptedException {
        TRBudget budget = new TRBudget(DivSuffixSorter.trIlg(n) * 2 / 3, n);
        int ISAd = ISA + depth;
        while (-n < this.readSuffixArray(0L)) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            int first = 0;
            int skip = 0;
            int unsorted = 0;
            do {
                int last;
                int t;
                if ((t = this.readSuffixArray(first)) < 0) {
                    first -= t;
                    skip += t;
                    continue;
                }
                if (skip != 0) {
                    this.writeSuffixArray(first + skip, skip);
                    skip = 0;
                }
                if (1 < (last = this.readSuffixArray(ISA + t) + 1) - first) {
                    budget.count = 0;
                    this.trIntroSort(ISA, ISAd, first, last, budget);
                    if (budget.count != 0) {
                        unsorted += budget.count;
                    } else {
                        skip = first - last;
                    }
                } else if (last - first == 1) {
                    skip = -1;
                }
                first = last;
            } while (first < n);
            if (skip != 0) {
                this.writeSuffixArray(first + skip, skip);
            }
            if (unsorted == 0) break;
            ISAd += ISAd - ISA;
        }
    }

    private final TRPartitionResult trPartition(int ISAd, int first, int middle, int last, int v) throws IOException {
        int x = 0;
        int b = middle - 1;
        while (++b < last && (x = this.readSuffixArray(ISAd + this.readSuffixArray(b))) == v) {
        }
        int a = b;
        if (a < last && x < v) {
            while (++b < last && (x = this.readSuffixArray(ISAd + this.readSuffixArray(b))) <= v) {
                if (x != v) continue;
                this.swapInSA(a, b);
                ++a;
            }
        }
        int c = last;
        while (b < --c && (x = this.readSuffixArray(ISAd + this.readSuffixArray(c))) == v) {
        }
        int d = c;
        if (b < d && x > v) {
            while (b < --c && (x = this.readSuffixArray(ISAd + this.readSuffixArray(c))) >= v) {
                if (x != v) continue;
                this.swapInSA(c, d);
                --d;
            }
        }
        while (b < c) {
            this.swapInSA(c, b);
            while (++b < c && (x = this.readSuffixArray(ISAd + this.readSuffixArray(b))) <= v) {
                if (x != v) continue;
                this.swapInSA(a, b);
                ++a;
            }
            while (b < --c && (x = this.readSuffixArray(ISAd + this.readSuffixArray(c))) >= v) {
                if (x != v) continue;
                this.swapInSA(c, d);
                --d;
            }
        }
        if (a <= d) {
            c = b - 1;
            int s = a - first;
            int t = b - a;
            if (s > t) {
                s = t;
            }
            int e = first;
            int f = b - s;
            while (0 < s) {
                this.swapInSA(e, f);
                --s;
                ++e;
                ++f;
            }
            s = d - c;
            t = last - d - 1;
            if (s > t) {
                s = t;
            }
            e = b;
            f = last - s;
            while (0 < s) {
                this.swapInSA(e, f);
                --s;
                ++e;
                ++f;
            }
            first += b - a;
            last -= d - c;
        }
        return new TRPartitionResult(first, last);
    }

    private final void trIntroSort(int ISA, int ISAd, int first, int last, TRBudget budget) throws IOException {
        int STACK_SIZE = 64;
        StackElement[] stack = new StackElement[64];
        int a = 0;
        int b = 0;
        int x = 0;
        int incr = ISAd - ISA;
        int trlink = -1;
        int ssize = 0;
        int limit = DivSuffixSorter.trIlg(last - first);
        while (true) {
            int next;
            StackElement se;
            int c;
            int v;
            TRPartitionResult res;
            if (limit < 0) {
                StackElement se2;
                if (limit == -1) {
                    res = this.trPartition(ISAd - incr, first, first, last, last - 1);
                    a = res.a;
                    b = res.b;
                    if (a < last) {
                        v = a - 1;
                        for (c = first; c < a; ++c) {
                            this.writeSuffixArray(ISA + this.readSuffixArray(c), v);
                        }
                    }
                    if (b < last) {
                        v = b - 1;
                        for (c = a; c < b; ++c) {
                            this.writeSuffixArray(ISA + this.readSuffixArray(c), v);
                        }
                    }
                    if (1 < b - a) {
                        stack[ssize++] = new StackElement(0, a, b, 0, 0);
                        stack[ssize++] = new StackElement(ISAd - incr, first, last, -2, trlink);
                        trlink = ssize - 2;
                    }
                    if (a - first <= last - b) {
                        if (1 < a - first) {
                            stack[ssize++] = new StackElement(ISAd, b, last, DivSuffixSorter.trIlg(last - b), trlink);
                            last = a;
                            limit = DivSuffixSorter.trIlg(a - first);
                            continue;
                        }
                        if (1 < last - b) {
                            first = b;
                            limit = DivSuffixSorter.trIlg(last - b);
                            continue;
                        }
                        if (ssize > 0) {
                            se = stack[--ssize];
                            ISAd = se.a;
                            first = se.b;
                            last = se.c;
                            limit = se.d;
                            trlink = se.e;
                            continue;
                        }
                        return;
                    }
                    if (1 < last - b) {
                        stack[ssize++] = new StackElement(ISAd, first, a, DivSuffixSorter.trIlg(a - first), trlink);
                        first = b;
                        limit = DivSuffixSorter.trIlg(last - b);
                        continue;
                    }
                    if (1 < a - first) {
                        last = a;
                        limit = DivSuffixSorter.trIlg(a - first);
                        continue;
                    }
                    if (ssize > 0) {
                        se = stack[--ssize];
                        ISAd = se.a;
                        first = se.b;
                        last = se.c;
                        limit = se.d;
                        trlink = se.e;
                        continue;
                    }
                    return;
                }
                if (limit == -2) {
                    se2 = stack[--ssize];
                    a = se2.b;
                    b = se2.c;
                    if (stack[ssize].d == 0) {
                        this.trCopy(ISA, first, a, b, last, ISAd - ISA);
                    } else {
                        if (0 <= trlink) {
                            stack[trlink].d = -1;
                        }
                        this.trPartialCopy(ISA, first, a, b, last, ISAd - ISA);
                    }
                    if (ssize > 0) {
                        se2 = stack[--ssize];
                        ISAd = se2.a;
                        first = se2.b;
                        last = se2.c;
                        limit = se2.d;
                        trlink = se2.e;
                        continue;
                    }
                    return;
                }
                if (0 <= this.readSuffixArray(first)) {
                    a = first;
                    do {
                        this.writeSuffixArray(ISA + this.readSuffixArray(a), a);
                    } while (++a < last && 0 <= this.readSuffixArray(a));
                    first = a;
                }
                if (first < last) {
                    a = first;
                    do {
                        this.writeSuffixArray(a, ~this.readSuffixArray(a));
                    } while (this.readSuffixArray(++a) < 0);
                    int n = next = this.readSuffixArray(ISA + this.readSuffixArray(a)) != this.readSuffixArray(ISAd + this.readSuffixArray(a)) ? DivSuffixSorter.trIlg(a - first + 1) : -1;
                    if (++a < last) {
                        v = a - 1;
                        for (b = first; b < a; ++b) {
                            this.writeSuffixArray(ISA + this.readSuffixArray(b), v);
                        }
                    }
                    if (budget.check(a - first) != 0) {
                        if (a - first <= last - a) {
                            stack[ssize++] = new StackElement(ISAd, a, last, -3, trlink);
                            ISAd += incr;
                            last = a;
                            limit = next;
                            continue;
                        }
                        if (1 < last - a) {
                            stack[ssize++] = new StackElement(ISAd + incr, first, a, next, trlink);
                            first = a;
                            limit = -3;
                            continue;
                        }
                        ISAd += incr;
                        last = a;
                        limit = next;
                        continue;
                    }
                    if (0 <= trlink) {
                        stack[trlink].d = -1;
                    }
                    if (1 < last - a) {
                        first = a;
                        limit = -3;
                        continue;
                    }
                    if (ssize > 0) {
                        se2 = stack[--ssize];
                        ISAd = se2.a;
                        first = se2.b;
                        last = se2.c;
                        limit = se2.d;
                        trlink = se2.e;
                        continue;
                    }
                    return;
                }
                if (ssize > 0) {
                    se2 = stack[--ssize];
                    ISAd = se2.a;
                    first = se2.b;
                    last = se2.c;
                    limit = se2.d;
                    trlink = se2.e;
                    continue;
                }
                return;
            }
            if (last - first <= 8) {
                this.trInsertionSort(ISAd, first, last);
                limit = -3;
                continue;
            }
            if (limit-- == 0) {
                this.trHeapSort(ISAd, first, last - first);
                a = last - 1;
                while (first < a) {
                    x = this.readSuffixArray(ISAd + this.readSuffixArray(a));
                    for (b = a - 1; first <= b && this.readSuffixArray(ISAd + this.readSuffixArray(b)) == x; --b) {
                        this.writeSuffixArray(b, ~this.readSuffixArray(b));
                    }
                    a = b;
                }
                limit = -3;
                continue;
            }
            a = this.trPivot(ISAd, first, last);
            this.swapInSA(first, a);
            v = this.readSuffixArray(ISAd + this.readSuffixArray(first));
            res = this.trPartition(ISAd, first, first + 1, last, v);
            a = res.a;
            b = res.b;
            if (last - first != b - a) {
                next = this.readSuffixArray(ISA + this.readSuffixArray(a)) != v ? DivSuffixSorter.trIlg(b - a) : -1;
                v = a - 1;
                for (c = first; c < a; ++c) {
                    this.writeSuffixArray(ISA + this.readSuffixArray(c), v);
                }
                if (b < last) {
                    v = b - 1;
                    for (c = a; c < b; ++c) {
                        this.writeSuffixArray(ISA + this.readSuffixArray(c), v);
                    }
                }
                if (1 < b - a && budget.check(b - a) != 0) {
                    if (a - first <= last - b) {
                        if (last - b <= b - a) {
                            if (1 < a - first) {
                                stack[ssize++] = new StackElement(ISAd + incr, a, b, next, trlink);
                                stack[ssize++] = new StackElement(ISAd, b, last, limit, trlink);
                                last = a;
                                continue;
                            }
                            if (1 < last - b) {
                                stack[ssize++] = new StackElement(ISAd + incr, a, b, next, trlink);
                                first = b;
                                continue;
                            }
                            ISAd += incr;
                            first = a;
                            last = b;
                            limit = next;
                            continue;
                        }
                        if (a - first <= b - a) {
                            if (1 < a - first) {
                                stack[ssize++] = new StackElement(ISAd, b, last, limit, trlink);
                                stack[ssize++] = new StackElement(ISAd + incr, a, b, next, trlink);
                                last = a;
                                continue;
                            }
                            stack[ssize++] = new StackElement(ISAd, b, last, limit, trlink);
                            ISAd += incr;
                            first = a;
                            last = b;
                            limit = next;
                            continue;
                        }
                        stack[ssize++] = new StackElement(ISAd, b, last, limit, trlink);
                        stack[ssize++] = new StackElement(ISAd, first, a, limit, trlink);
                        ISAd += incr;
                        first = a;
                        last = b;
                        limit = next;
                        continue;
                    }
                    if (a - first <= b - a) {
                        if (1 < last - b) {
                            stack[ssize++] = new StackElement(ISAd + incr, a, b, next, trlink);
                            stack[ssize++] = new StackElement(ISAd, first, a, limit, trlink);
                            first = b;
                            continue;
                        }
                        if (1 < a - first) {
                            stack[ssize++] = new StackElement(ISAd + incr, a, b, next, trlink);
                            last = a;
                            continue;
                        }
                        ISAd += incr;
                        first = a;
                        last = b;
                        limit = next;
                        continue;
                    }
                    if (last - b <= b - a) {
                        if (1 < last - b) {
                            stack[ssize++] = new StackElement(ISAd, first, a, limit, trlink);
                            stack[ssize++] = new StackElement(ISAd + incr, a, b, next, trlink);
                            first = b;
                            continue;
                        }
                        stack[ssize++] = new StackElement(ISAd, first, a, limit, trlink);
                        ISAd += incr;
                        first = a;
                        last = b;
                        limit = next;
                        continue;
                    }
                    stack[ssize++] = new StackElement(ISAd, first, a, limit, trlink);
                    stack[ssize++] = new StackElement(ISAd, b, last, limit, trlink);
                    ISAd += incr;
                    first = a;
                    last = b;
                    limit = next;
                    continue;
                }
                if (1 < b - a && 0 <= trlink) {
                    stack[trlink].d = -1;
                }
                if (a - first <= last - b) {
                    if (1 < a - first) {
                        stack[ssize++] = new StackElement(ISAd, b, last, limit, trlink);
                        last = a;
                        continue;
                    }
                    if (1 < last - b) {
                        first = b;
                        continue;
                    }
                    if (ssize > 0) {
                        se = stack[--ssize];
                        ISAd = se.a;
                        first = se.b;
                        last = se.c;
                        limit = se.d;
                        trlink = se.e;
                        continue;
                    }
                    return;
                }
                if (1 < last - b) {
                    stack[ssize++] = new StackElement(ISAd, first, a, limit, trlink);
                    first = b;
                    continue;
                }
                if (1 < a - first) {
                    last = a;
                    continue;
                }
                if (ssize > 0) {
                    se = stack[--ssize];
                    ISAd = se.a;
                    first = se.b;
                    last = se.c;
                    limit = se.d;
                    trlink = se.e;
                    continue;
                }
                return;
            }
            if (budget.check(last - first) != 0) {
                limit = DivSuffixSorter.trIlg(last - first);
                ISAd += incr;
                continue;
            }
            if (0 <= trlink) {
                stack[trlink].d = -1;
            }
            if (ssize <= 0) break;
            se = stack[--ssize];
            ISAd = se.a;
            first = se.b;
            last = se.c;
            limit = se.d;
            trlink = se.e;
        }
    }

    private final int trPivot(int ISAd, int first, int last) throws IOException {
        int t = last - first;
        int middle = first + t / 2;
        if (t <= 512) {
            if (t <= 32) {
                return this.trMedian3(ISAd, first, middle, last - 1);
            }
            return this.trMedian5(ISAd, first, first + (t >>= 2), middle, last - 1 - t, last - 1);
        }
        first = this.trMedian3(ISAd, first, first + (t >>= 3), first + (t << 1));
        middle = this.trMedian3(ISAd, middle - t, middle, middle + t);
        last = this.trMedian3(ISAd, last - 1 - (t << 1), last - 1 - t, last - 1);
        return this.trMedian3(ISAd, first, middle, last);
    }

    private final int trMedian5(int ISAd, int v1, int v2, int v3, int v4, int v5) throws IOException {
        int t;
        if (this.readSuffixArray(ISAd + this.readSuffixArray(v2)) > this.readSuffixArray(ISAd + this.readSuffixArray(v3))) {
            t = v2;
            v2 = v3;
            v3 = t;
        }
        if (this.readSuffixArray(ISAd + this.readSuffixArray(v4)) > this.readSuffixArray(ISAd + this.readSuffixArray(v5))) {
            t = v4;
            v4 = v5;
            v5 = t;
        }
        if (this.readSuffixArray(ISAd + this.readSuffixArray(v2)) > this.readSuffixArray(ISAd + this.readSuffixArray(v4))) {
            t = v2;
            v2 = v4;
            v4 = t;
            t = v3;
            v3 = v5;
            v5 = t;
        }
        if (this.readSuffixArray(ISAd + this.readSuffixArray(v1)) > this.readSuffixArray(ISAd + this.readSuffixArray(v3))) {
            t = v1;
            v1 = v3;
            v3 = t;
        }
        if (this.readSuffixArray(ISAd + this.readSuffixArray(v1)) > this.readSuffixArray(ISAd + this.readSuffixArray(v4))) {
            t = v1;
            v1 = v4;
            v4 = t;
            t = v3;
            v3 = v5;
            v5 = t;
        }
        if (this.readSuffixArray(ISAd + this.readSuffixArray(v3)) > this.readSuffixArray(ISAd + this.readSuffixArray(v4))) {
            return v4;
        }
        return v3;
    }

    private final int trMedian3(int ISAd, int v1, int v2, int v3) throws IOException {
        if (this.readSuffixArray(ISAd + this.readSuffixArray(v1)) > this.readSuffixArray(ISAd + this.readSuffixArray(v2))) {
            int t = v1;
            v1 = v2;
            v2 = t;
        }
        if (this.readSuffixArray(ISAd + this.readSuffixArray(v2)) > this.readSuffixArray(ISAd + this.readSuffixArray(v3))) {
            if (this.readSuffixArray(ISAd + this.readSuffixArray(v1)) > this.readSuffixArray(ISAd + this.readSuffixArray(v3))) {
                return v1;
            }
            return v3;
        }
        return v2;
    }

    private final void trHeapSort(int ISAd, int sa, int size) throws IOException {
        int i;
        int m = size;
        if (size % 2 == 0 && this.readSuffixArray(ISAd + this.readSuffixArray(sa + --m / 2)) < this.readSuffixArray(ISAd + this.readSuffixArray(sa + m))) {
            this.swapInSA(sa + m, sa + m / 2);
        }
        for (i = m / 2 - 1; 0 <= i; --i) {
            this.trFixDown(ISAd, sa, i, m);
        }
        if (size % 2 == 0) {
            this.swapInSA(sa, sa + m);
            this.trFixDown(ISAd, sa, 0, m);
        }
        for (i = m - 1; 0 < i; --i) {
            int t = this.readSuffixArray(sa);
            this.writeSuffixArray(sa, this.readSuffixArray(sa + i));
            this.trFixDown(ISAd, sa, 0, i);
            this.writeSuffixArray(sa + i, t);
        }
    }

    private final void trFixDown(int ISAd, int sa, int i, int size) throws IOException {
        int j;
        int v = this.readSuffixArray(sa + i);
        int c = this.readSuffixArray(ISAd + v);
        while ((j = 2 * i + 1) < size) {
            int e;
            int k;
            int d;
            if ((d = this.readSuffixArray(ISAd + this.readSuffixArray(sa + (k = j++)))) < (e = this.readSuffixArray(ISAd + this.readSuffixArray(sa + j)))) {
                k = j;
                d = e;
            }
            if (d <= c) break;
            this.writeSuffixArray(sa + i, this.readSuffixArray(sa + k));
            i = k;
        }
        this.writeSuffixArray(sa + i, v);
    }

    private final void trInsertionSort(int ISAd, int first, int last) throws IOException {
        for (int a = first + 1; a < last; ++a) {
            int r;
            int t = this.readSuffixArray(a);
            int b = a - 1;
            while (0 > (r = this.readSuffixArray(ISAd + t) - this.readSuffixArray(ISAd + this.readSuffixArray(b)))) {
                do {
                    this.writeSuffixArray(b + 1, this.readSuffixArray(b));
                } while (first <= --b && this.readSuffixArray(b) < 0);
                if (b >= first) continue;
            }
            if (r == 0) {
                this.writeSuffixArray(b, ~this.readSuffixArray(b));
            }
            this.writeSuffixArray(b + 1, t);
        }
    }

    private final void trPartialCopy(int ISA, int first, int a, int b, int last, int depth) throws IOException {
        int e;
        int rank;
        int s;
        int c;
        int newrank = -1;
        int v = b - 1;
        int lastrank = -1;
        int d = a - 1;
        for (c = first; c <= d; ++c) {
            s = this.readSuffixArray(c) - depth;
            if (0 > s || this.readSuffixArray(ISA + s) != v) continue;
            this.writeSuffixArray(++d, s);
            rank = this.readSuffixArray(ISA + s + depth);
            if (lastrank != rank) {
                lastrank = rank;
                newrank = d;
            }
            this.writeSuffixArray(ISA + s, newrank);
        }
        lastrank = -1;
        for (e = d; first <= e; --e) {
            rank = this.readSuffixArray(ISA + this.readSuffixArray(e));
            if (lastrank != rank) {
                lastrank = rank;
                newrank = e;
            }
            if (newrank == rank) continue;
            this.writeSuffixArray(ISA + this.readSuffixArray(e), newrank);
        }
        lastrank = -1;
        c = last - 1;
        e = d + 1;
        d = b;
        while (e < d) {
            s = this.readSuffixArray(c) - depth;
            if (0 <= s && this.readSuffixArray(ISA + s) == v) {
                this.writeSuffixArray(--d, s);
                rank = this.readSuffixArray(ISA + s + depth);
                if (lastrank != rank) {
                    lastrank = rank;
                    newrank = d;
                }
                this.writeSuffixArray(ISA + s, newrank);
            }
            --c;
        }
    }

    private final void trCopy(int ISA, int first, int a, int b, int last, int depth) throws IOException {
        int s;
        int c;
        int v = b - 1;
        int d = a - 1;
        for (c = first; c <= d; ++c) {
            s = this.readSuffixArray(c) - depth;
            if (0 > s || this.readSuffixArray(ISA + s) != v) continue;
            this.writeSuffixArray(++d, s);
            this.writeSuffixArray(ISA + s, d);
        }
        c = last - 1;
        int e = d + 1;
        d = b;
        while (e < d) {
            s = this.readSuffixArray(c) - depth;
            if (0 <= s && this.readSuffixArray(ISA + s) == v) {
                this.writeSuffixArray(--d, s);
                this.writeSuffixArray(ISA + s, d);
            }
            --c;
        }
    }

    private static final int trIlg(int n) {
        return (n & 0xFFFF0000) != 0 ? ((n & 0xFF000000) != 0 ? 24 + LG_TABLE[n >> 24 & 0xFF] : 16 + LG_TABLE[n >> 16 & 0xFF]) : ((n & 0xFF00) != 0 ? 8 + LG_TABLE[n >> 8 & 0xFF] : LG_TABLE[n >> 0 & 0xFF]);
    }

    private int readInput(long pos) throws IOException {
        this.input.seek(pos);
        return this.input.readUnsignedByte();
    }

    private int readSuffixArray(long pos) throws IOException {
        this.suffixArray.seekToIntAligned(pos + 1L);
        return this.suffixArray.readInt();
    }

    private int writeSuffixArray(long pos, int write) throws IOException {
        this.suffixArray.seekToIntAligned(pos + 1L);
        this.suffixArray.writeInt(write);
        return write;
    }

    private static final class TRPartitionResult {
        final int a;
        final int b;

        public TRPartitionResult(int a, int b) {
            this.a = a;
            this.b = b;
        }
    }

    private static final class TRBudget {
        int chance;
        int remain;
        int incval;
        int count;

        private TRBudget(int chance, int incval) {
            this.chance = chance;
            this.remain = incval;
            this.incval = incval;
        }

        private int check(int size) {
            if (size <= this.remain) {
                this.remain -= size;
                return 1;
            }
            if (this.chance == 0) {
                this.count += size;
                return 0;
            }
            this.remain += this.incval - size;
            --this.chance;
            return 1;
        }
    }

    private static final class StackElement {
        final int a;
        final int b;
        final int c;
        final int e;
        int d;

        StackElement(int a, int b, int c, int d, int e) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        StackElement(int a, int b, int c, int d) {
            this(a, b, c, d, 0);
        }
    }
}

