/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.xml;

import com.android.ide.common.xml.ManifestData;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.StreamException;
import com.android.resources.Keyboard;
import com.android.resources.Navigation;
import com.android.resources.TouchScreen;
import com.android.utils.XmlUtils;
import com.android.xml.AndroidManifest;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AndroidManifestParser {
    private static final int LEVEL_TOP = 0;
    private static final int LEVEL_INSIDE_MANIFEST = 1;
    private static final int LEVEL_INSIDE_APPLICATION = 2;
    private static final int LEVEL_INSIDE_APP_COMPONENT = 3;
    private static final int LEVEL_INSIDE_INTENT_FILTER = 4;
    private static final String ACTION_MAIN = "android.intent.action.MAIN";
    private static final String CATEGORY_LAUNCHER = "android.intent.category.LAUNCHER";
    private static final SAXParserFactory sParserFactory = SAXParserFactory.newInstance();

    public static ManifestData parse(IAbstractFile manifestFile, boolean gatherData, ManifestErrorHandler errorHandler) throws IOException, SAXException {
        if (manifestFile != null) {
            SAXParser parser;
            try {
                parser = XmlUtils.createSaxParser((SAXParserFactory)sParserFactory);
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new RuntimeException(e);
            }
            ManifestData data = null;
            if (gatherData) {
                data = new ManifestData();
            }
            ManifestHandler manifestHandler = new ManifestHandler(manifestFile, data, errorHandler);
            try (InputStream is = manifestFile.getContents();){
                parser.parse(new InputSource(is), (DefaultHandler)manifestHandler);
            }
            catch (StreamException e) {
                throw new IOException(e);
            }
            return data;
        }
        return null;
    }

    public static ManifestData parse(IAbstractFile manifestFile) throws IOException, SAXException {
        return AndroidManifestParser.parse(manifestFile, true, null);
    }

    public static ManifestData parse(IAbstractFolder projectFolder) throws IOException, SAXException {
        IAbstractFile manifestFile = AndroidManifest.getManifest((IAbstractFolder)projectFolder);
        if (manifestFile == null) {
            throw new FileNotFoundException();
        }
        return AndroidManifestParser.parse(manifestFile, true, null);
    }

    public static ManifestData parse(InputStream manifestFileStream) throws ParserConfigurationException, SAXException, IOException {
        if (manifestFileStream != null) {
            SAXParser parser = XmlUtils.createSaxParser((SAXParserFactory)sParserFactory);
            ManifestData data = new ManifestData();
            ManifestHandler manifestHandler = new ManifestHandler(null, data, null);
            parser.parse(new InputSource(manifestFileStream), (DefaultHandler)manifestHandler);
            return data;
        }
        return null;
    }

    static {
        XmlUtils.configureSaxFactory((SAXParserFactory)sParserFactory, (boolean)true, (boolean)false);
    }

    private static class ManifestHandler
    extends DefaultHandler {
        private final ManifestData mManifestData;
        private final ManifestErrorHandler mErrorHandler;
        private int mCurrentLevel = 0;
        private int mValidLevel = 0;
        private ManifestData.Activity mCurrentActivity = null;
        private Locator mLocator;

        ManifestHandler(IAbstractFile manifestFile, ManifestData manifestData, ManifestErrorHandler errorHandler) {
            this.mManifestData = manifestData;
            this.mErrorHandler = errorHandler;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.mLocator = locator;
            super.setDocumentLocator(locator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            try {
                if (this.mManifestData == null) {
                    return;
                }
                if (this.mValidLevel == this.mCurrentLevel) {
                    switch (this.mValidLevel) {
                        case 0: {
                            if (!"manifest".equals(localName)) break;
                            this.mManifestData.mPackage = this.getAttributeValue(attributes, "package", false);
                            String tmp = this.getAttributeValue(attributes, "versionCode", true);
                            if (tmp != null) {
                                try {
                                    this.mManifestData.mVersionCode = Integer.valueOf(tmp);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            ++this.mValidLevel;
                            break;
                        }
                        case 1: {
                            Boolean b;
                            if ("application".equals(localName)) {
                                this.processApplicationNode(attributes);
                                ++this.mValidLevel;
                                break;
                            }
                            if ("uses-sdk".equals(localName)) {
                                this.mManifestData.setMinSdkVersionString(this.getAttributeValue(attributes, "minSdkVersion", true));
                                this.mManifestData.setTargetSdkVersionString(this.getAttributeValue(attributes, "targetSdkVersion", true));
                                break;
                            }
                            if ("instrumentation".equals(localName)) {
                                this.processInstrumentationNode(attributes);
                                break;
                            }
                            if ("supports-screens".equals(localName)) {
                                this.processSupportsScreensNode(attributes);
                                break;
                            }
                            if ("uses-configuration".equals(localName)) {
                                this.processUsesConfiguration(attributes);
                                break;
                            }
                            if (!"uses-feature".equals(localName)) break;
                            ManifestData.UsesFeature feature = new ManifestData.UsesFeature();
                            String value = this.getAttributeValue(attributes, "name", true);
                            if (value != null) {
                                feature.mName = value;
                            }
                            if ((value = this.getAttributeValue(attributes, "required", true)) != null && (b = Boolean.valueOf(value)) != null) {
                                feature.mRequired = b;
                            }
                            if ((value = this.getAttributeValue(attributes, "glEsVersion", true)) != null) {
                                try {
                                    int version;
                                    feature.mGlEsVersion = version = Integer.decode(value).intValue();
                                }
                                catch (NumberFormatException version) {
                                    // empty catch block
                                }
                            }
                            this.mManifestData.mFeatures.add(feature);
                            break;
                        }
                        case 2: {
                            Boolean b;
                            String value;
                            if ("activity".equals(localName) || "activity-alias".equals(localName)) {
                                this.processActivityNode(attributes);
                                ++this.mValidLevel;
                                break;
                            }
                            if ("service".equals(localName)) {
                                this.processNode(attributes, "android.app.Service", localName);
                                ++this.mValidLevel;
                                break;
                            }
                            if ("receiver".equals(localName)) {
                                this.processNode(attributes, "android.content.BroadcastReceiver", localName);
                                ++this.mValidLevel;
                                break;
                            }
                            if ("provider".equals(localName)) {
                                this.processNode(attributes, "android.content.ContentProvider", localName);
                                ++this.mValidLevel;
                                break;
                            }
                            if (!"uses-library".equals(localName) || (value = this.getAttributeValue(attributes, "name", true)) == null) break;
                            ManifestData.UsesLibrary library = new ManifestData.UsesLibrary();
                            library.mName = value;
                            value = this.getAttributeValue(attributes, "required", true);
                            if (value != null && (b = Boolean.valueOf(value)) != null) {
                                library.mRequired = b;
                            }
                            this.mManifestData.mLibraries.add(library);
                            break;
                        }
                        case 3: {
                            if (this.mCurrentActivity == null || !"intent-filter".equals(localName)) break;
                            this.mCurrentActivity.resetIntentFilter();
                            ++this.mValidLevel;
                            break;
                        }
                        case 4: {
                            String category;
                            if (this.mCurrentActivity == null) break;
                            if ("action".equals(localName)) {
                                String action = this.getAttributeValue(attributes, "name", true);
                                if (action == null) break;
                                this.mCurrentActivity.setHasAction(true);
                                this.mCurrentActivity.setHasMainAction(AndroidManifestParser.ACTION_MAIN.equals(action));
                                break;
                            }
                            if (!"category".equals(localName) || !AndroidManifestParser.CATEGORY_LAUNCHER.equals(category = this.getAttributeValue(attributes, "name", true))) break;
                            this.mCurrentActivity.setHasLauncherCategory(true);
                        }
                    }
                }
                ++this.mCurrentLevel;
            }
            finally {
                super.startElement(uri, localName, name, attributes);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            try {
                if (this.mManifestData == null) {
                    return;
                }
                if (this.mValidLevel == this.mCurrentLevel) {
                    --this.mValidLevel;
                }
                --this.mCurrentLevel;
                if (this.mValidLevel != this.mCurrentLevel) return;
                switch (this.mValidLevel) {
                    case 2: {
                        this.mCurrentActivity = null;
                        return;
                    }
                    case 3: {
                        if (this.mManifestData.mLauncherActivity != null) return;
                        if (this.mCurrentActivity == null) return;
                        if (!this.mCurrentActivity.isHomeActivity()) return;
                        if (!this.mCurrentActivity.isExported()) return;
                        this.mManifestData.mLauncherActivity = this.mCurrentActivity;
                        return;
                    }
                }
                return;
            }
            finally {
                super.endElement(uri, localName, name);
            }
        }

        @Override
        public void error(SAXParseException e) {
            if (this.mErrorHandler != null) {
                this.mErrorHandler.handleError(e, e.getLineNumber());
            }
        }

        @Override
        public void fatalError(SAXParseException e) {
            if (this.mErrorHandler != null) {
                this.mErrorHandler.handleError(e, e.getLineNumber());
            }
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            if (this.mErrorHandler != null) {
                this.mErrorHandler.warning(e);
            }
        }

        private void processApplicationNode(Attributes attributes) {
            String value = this.getAttributeValue(attributes, "process", true);
            if (value != null) {
                this.mManifestData.addProcessName(value);
                this.mManifestData.mDefaultProcess = value;
            }
            if ((value = this.getAttributeValue(attributes, "debuggable", true)) != null) {
                this.mManifestData.mDebuggable = Boolean.parseBoolean(value);
            }
            if ((value = this.getAttributeValue(attributes, "name", true)) != null) {
                this.mManifestData.mKeepClasses.add(new ManifestData.KeepClass(AndroidManifest.combinePackageAndClassName((String)this.mManifestData.mPackage, (String)value), null, "application"));
            }
            if ((value = this.getAttributeValue(attributes, "backupAgent", true)) != null) {
                this.mManifestData.mKeepClasses.add(new ManifestData.KeepClass(AndroidManifest.combinePackageAndClassName((String)this.mManifestData.mPackage, (String)value), null, "backupAgent"));
            }
        }

        private void processActivityNode(Attributes attributes) {
            String activityName = this.getAttributeValue(attributes, "name", true);
            if (activityName != null) {
                activityName = AndroidManifest.combinePackageAndClassName((String)this.mManifestData.mPackage, (String)activityName);
                String exportedStr = this.getAttributeValue(attributes, "exported", true);
                boolean exported = exportedStr == null || exportedStr.toLowerCase(Locale.US).equals("true");
                this.mCurrentActivity = new ManifestData.Activity(activityName, exported);
                this.mManifestData.mActivities.add(this.mCurrentActivity);
                if (this.mErrorHandler != null) {
                    this.mErrorHandler.checkClass(this.mLocator, activityName, "android.app.Activity", true);
                }
            } else {
                this.mCurrentActivity = null;
            }
            String processName = this.getAttributeValue(attributes, "process", true);
            if (processName != null) {
                this.mManifestData.addProcessName(processName);
            }
            if (processName == null || processName.isEmpty()) {
                processName = this.mManifestData.getDefaultProcess();
            }
            if (activityName != null) {
                this.mManifestData.mKeepClasses.add(new ManifestData.KeepClass(activityName, processName, "activity"));
            }
        }

        private void processNode(Attributes attributes, String superClassName, String localName) {
            String processName;
            String serviceName = this.getAttributeValue(attributes, "name", true);
            if (serviceName != null) {
                serviceName = AndroidManifest.combinePackageAndClassName((String)this.mManifestData.mPackage, (String)serviceName);
                if (this.mErrorHandler != null) {
                    this.mErrorHandler.checkClass(this.mLocator, serviceName, superClassName, false);
                }
            }
            if ((processName = this.getAttributeValue(attributes, "process", true)) != null) {
                this.mManifestData.addProcessName(processName);
            }
            if (processName == null || processName.isEmpty()) {
                processName = this.mManifestData.getDefaultProcess();
            }
            if (serviceName != null) {
                this.mManifestData.mKeepClasses.add(new ManifestData.KeepClass(serviceName, processName, localName));
            }
        }

        private void processInstrumentationNode(Attributes attributes) {
            String instrumentationName = this.getAttributeValue(attributes, "name", true);
            if (instrumentationName != null) {
                String instrClassName = AndroidManifest.combinePackageAndClassName((String)this.mManifestData.mPackage, (String)instrumentationName);
                String targetPackage = this.getAttributeValue(attributes, "targetPackage", true);
                this.mManifestData.mInstrumentations.add(new ManifestData.Instrumentation(instrClassName, targetPackage));
                this.mManifestData.mKeepClasses.add(new ManifestData.KeepClass(instrClassName, null, "instrumentation"));
                if (this.mErrorHandler != null) {
                    this.mErrorHandler.checkClass(this.mLocator, instrClassName, "android.app.Instrumentation", true);
                }
            }
        }

        private void processSupportsScreensNode(Attributes attributes) {
            this.mManifestData.mSupportsScreensFromManifest = new ManifestData.SupportsScreens();
            this.mManifestData.mSupportsScreensFromManifest.setResizeable(this.getAttributeBooleanValue(attributes, "resizeable", true));
            this.mManifestData.mSupportsScreensFromManifest.setAnyDensity(this.getAttributeBooleanValue(attributes, "anyDensity", true));
            this.mManifestData.mSupportsScreensFromManifest.setSmallScreens(this.getAttributeBooleanValue(attributes, "smallScreens", true));
            this.mManifestData.mSupportsScreensFromManifest.setNormalScreens(this.getAttributeBooleanValue(attributes, "normalScreens", true));
            this.mManifestData.mSupportsScreensFromManifest.setLargeScreens(this.getAttributeBooleanValue(attributes, "largeScreens", true));
        }

        private void processUsesConfiguration(Attributes attributes) {
            this.mManifestData.mUsesConfiguration = new ManifestData.UsesConfiguration();
            this.mManifestData.mUsesConfiguration.mReqFiveWayNav = this.getAttributeBooleanValue(attributes, "reqFiveWayNav", true);
            this.mManifestData.mUsesConfiguration.mReqNavigation = Navigation.getEnum((String)this.getAttributeValue(attributes, "reqNavigation", true));
            this.mManifestData.mUsesConfiguration.mReqHardKeyboard = this.getAttributeBooleanValue(attributes, "reqHardKeyboard", true);
            this.mManifestData.mUsesConfiguration.mReqKeyboardType = Keyboard.getEnum((String)this.getAttributeValue(attributes, "reqKeyboardType", true));
            this.mManifestData.mUsesConfiguration.mReqTouchScreen = TouchScreen.getEnum((String)this.getAttributeValue(attributes, "reqTouchScreen", true));
        }

        private String getAttributeValue(Attributes attributes, String attributeName, boolean hasNamespace) {
            int count = attributes.getLength();
            for (int i = 0; i < count; ++i) {
                if (!attributeName.equals(attributes.getLocalName(i)) || (!hasNamespace || !"http://schemas.android.com/apk/res/android".equals(attributes.getURI(i))) && (hasNamespace || !attributes.getURI(i).isEmpty())) continue;
                return attributes.getValue(i);
            }
            return null;
        }

        private Boolean getAttributeBooleanValue(Attributes attributes, String attributeName, boolean hasNamespace) {
            int count = attributes.getLength();
            for (int i = 0; i < count; ++i) {
                if (!attributeName.equals(attributes.getLocalName(i)) || (!hasNamespace || !"http://schemas.android.com/apk/res/android".equals(attributes.getURI(i))) && (hasNamespace || !attributes.getURI(i).isEmpty())) continue;
                String attr = attributes.getValue(i);
                if (attr != null) {
                    return Boolean.valueOf(attr);
                }
                return null;
            }
            return null;
        }
    }

    public static interface ManifestErrorHandler
    extends ErrorHandler {
        public void handleError(Exception var1, int var2);

        public void checkClass(Locator var1, String var2, String var3, boolean var4);
    }
}

