/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.analyzer;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.tools.analyzer.IUAnalyzer;

public class LicenseAnalyzer
extends IUAnalyzer {
    public void analyzeIU(IInstallableUnit iu) {
        if (Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.type.group")).booleanValue()) {
            Collection licenses = iu.getLicenses();
            if (iu.getLicenses() == null || licenses.size() == 0) {
                this.error(iu, "[ERROR] " + iu.getId() + " has no license");
                return;
            }
            if (((ILicense)licenses.iterator().next()).getBody().length() == 0) {
                this.error(iu, "[ERROR] " + iu.getId() + " has no license");
                return;
            }
            Iterator iterator = licenses.iterator();
            while (iterator.hasNext()) {
                String licenseProperty;
                ILicense license = (ILicense)iterator.next();
                if (!license.getBody().startsWith("%") || iu.getProperty("df_LT." + (licenseProperty = license.getBody().substring(1))) != null) continue;
                this.error(iu, "[ERROR] " + iu.getId() + " has no license");
            }
        }
    }

    public void preAnalysis(IMetadataRepository repository) {
    }
}

