/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.ISourceProviderListener;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.services.EvaluationReference;
import org.eclipse.ui.services.IEvaluationReference;
import org.eclipse.ui.services.IEvaluationService;

public final class EvaluationService
implements IEvaluationService {
    public static final String DEFAULT_VAR = "org.eclipse.ui.internal.services.EvaluationService.default_var";
    private static final String RE_EVAL = "org.eclipse.ui.internal.services.EvaluationService.evaluate";
    private boolean evaluate = false;
    private ExpressionContext legacyContext;
    private IEclipseContext context;
    private IEclipseContext ratContext;
    private int notifying = 0;
    private ListenerList serviceListeners = new ListenerList(1);
    ArrayList<ISourceProvider> sourceProviders = new ArrayList();
    LinkedList<EvaluationReference> refs = new LinkedList();
    private ISourceProviderListener contextUpdater;
    private HashSet<String> ratVariables = new HashSet();
    private RunAndTrack ratUpdater = new RunAndTrack(){

        public boolean changed(IEclipseContext context) {
            String[] vars;
            context.get(EvaluationService.RE_EVAL);
            String[] stringArray = vars = EvaluationService.this.ratVariables.toArray(new String[EvaluationService.this.ratVariables.size()]);
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                Object value = context.getActive(var);
                if (value == null) {
                    EvaluationService.this.ratContext.remove(var);
                } else {
                    EvaluationService.this.ratContext.set(var, value);
                }
                ++n2;
            }
            return true;
        }
    };
    private HashSet<String> variableFilter = new HashSet();

    public EvaluationService(IEclipseContext c) {
        this.context = c;
        this.ratContext = this.context.getParent().createChild(this.getClass().getName());
        this.legacyContext = new ExpressionContext(this.context);
        ExpressionContext.defaultVariableConverter = new ContextFunction(){

            public Object compute(IEclipseContext context) {
                Object defaultVariable = context.getLocal(EvaluationService.DEFAULT_VAR);
                if (defaultVariable != null && defaultVariable != IEvaluationContext.UNDEFINED_VARIABLE) {
                    return defaultVariable;
                }
                defaultVariable = context.getActive("org.eclipse.ui.selection");
                if (defaultVariable instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)defaultVariable;
                    return selection.toList();
                }
                if (defaultVariable instanceof ISelection && !((ISelection)defaultVariable).isEmpty()) {
                    return Collections.singleton(defaultVariable);
                }
                return null;
            }
        };
        this.contextUpdater = new ISourceProviderListener(){

            public void sourceChanged(int sourcePriority, String sourceName, Object sourceValue) {
                EvaluationService.this.changeVariable(sourceName, sourceValue);
            }

            public void sourceChanged(int sourcePriority, Map sourceValuesByName) {
                for (Map.Entry entry : sourceValuesByName.entrySet()) {
                    EvaluationService.this.changeVariable((String)entry.getKey(), entry.getValue());
                }
            }
        };
        this.variableFilter.addAll(Arrays.asList("activeWorkbenchWindow", "activeWorkbenchWindowShell", "activeEditorId", "activeEditorInput", "showInInput", "showInSelection", "activePart", "activePartId", "activeSite", "activeContexts", "selection"));
        this.context.runAndTrack(this.ratUpdater);
    }

    private void contextEvaluate() {
        this.evaluate = !this.evaluate;
        this.context.set(RE_EVAL, (Object)this.evaluate);
    }

    protected final void changeVariable(String name, Object value) {
        if (name == null || this.variableFilter.contains(name)) {
            return;
        }
        if (value == null) {
            this.legacyContext.removeVariable(name);
        } else {
            this.legacyContext.addVariable(name, value);
        }
    }

    public void addSourceProvider(ISourceProvider provider) {
        this.sourceProviders.add(provider);
        provider.addSourceProviderListener(this.contextUpdater);
        Map currentState = provider.getCurrentState();
        for (Map.Entry entry : currentState.entrySet()) {
            String variableName = (String)entry.getKey();
            Object variableValue = entry.getValue();
            if (variableName == null || "activeWorkbenchWindowShell".equals(variableName)) continue;
            this.changeVariable(variableName, variableValue);
        }
        this.contextEvaluate();
    }

    public void removeSourceProvider(ISourceProvider provider) {
        provider.removeSourceProviderListener(this.contextUpdater);
        this.sourceProviders.remove(provider);
        Map currentState = provider.getCurrentState();
        for (Map.Entry entry : currentState.entrySet()) {
            String variableName = (String)entry.getKey();
            this.changeVariable(variableName, null);
        }
        this.contextEvaluate();
    }

    public void dispose() {
        for (EvaluationReference ref : this.refs) {
            this.invalidate(ref, false);
        }
        this.refs.clear();
        this.serviceListeners.clear();
    }

    public void addServiceListener(IPropertyChangeListener listener) {
        this.serviceListeners.add((Object)listener);
    }

    public void removeServiceListener(IPropertyChangeListener listener) {
        this.serviceListeners.remove((Object)listener);
    }

    public IEvaluationReference addEvaluationListener(Expression expression, IPropertyChangeListener listener, String property) {
        EvaluationReference ref = new EvaluationReference(this.ratContext, expression, listener, property);
        this.addEvaluationReference(ref);
        return ref;
    }

    public void addEvaluationReference(IEvaluationReference ref) {
        EvaluationReference eref = (EvaluationReference)ref;
        this.refs.add(eref);
        boolean changed = false;
        if (eref.getExpression() != null) {
            ExpressionInfo info = new ExpressionInfo();
            eref.getExpression().collectExpressionInfo(info);
            String[] stringArray = info.getAccessedVariableNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String varName = stringArray[n2];
                if (this.ratVariables.add(varName)) {
                    changed = true;
                }
                ++n2;
            }
            if (info.hasDefaultVariableAccess() && this.ratVariables.add("org.eclipse.ui.selection")) {
                changed = true;
            }
        }
        if (changed) {
            this.contextEvaluate();
        }
        eref.participating = true;
        this.ratContext.runAndTrack((RunAndTrack)eref);
    }

    private void invalidate(IEvaluationReference ref, boolean remove) {
        if (remove) {
            this.refs.remove(ref);
        }
        EvaluationReference eref = (EvaluationReference)ref;
        eref.participating = false;
        eref.evaluate();
        eref.hasRun = false;
        this.contextEvaluate();
    }

    public void removeEvaluationListener(IEvaluationReference ref) {
        this.invalidate(ref, true);
    }

    public IEvaluationContext getCurrentState() {
        return this.legacyContext;
    }

    public void requestEvaluation(String propertyName) {
        String pokeVar = String.valueOf(propertyName) + ".evaluationServiceLink";
        this.context.remove(pokeVar);
        this.context.set(pokeVar, (Object)"link");
        String[] sourceNames = new String[]{propertyName};
        this.startSourceChange(sourceNames);
        block0: for (EvaluationReference ref : this.refs) {
            String[] names;
            Expression expr = ref.getExpression();
            if (expr == null) continue;
            ExpressionInfo info = expr.computeExpressionInfo();
            String[] stringArray = names = info.getAccessedPropertyNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (propertyName.equals(name)) {
                    ref.evaluate();
                    continue block0;
                }
                ++n2;
            }
        }
        this.endSourceChange(sourceNames);
    }

    private void startSourceChange(String[] sourceNames) {
        ++this.notifying;
        if (this.notifying == 1) {
            this.fireServiceChange("org.eclipse.ui.services.notifying", Boolean.FALSE, Boolean.TRUE);
        }
    }

    private void endSourceChange(String[] sourceNames) {
        if (this.notifying == 1) {
            this.fireServiceChange("org.eclipse.ui.services.notifying", Boolean.TRUE, Boolean.FALSE);
        }
        --this.notifying;
    }

    private void fireServiceChange(final String property, final Object oldValue, final Object newValue) {
        Object[] listeners = this.serviceListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    WorkbenchPlugin.log(exception);
                }

                public void run() throws Exception {
                    listener.propertyChange(new PropertyChangeEvent((Object)EvaluationService.this, property, oldValue, newValue));
                }
            });
            ++i;
        }
    }
}

