/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state.transforms;

import com.android.ide.eclipse.gltrace.FileUtils;
import com.android.ide.eclipse.gltrace.GLEnum;
import com.android.ide.eclipse.gltrace.state.GLStringProperty;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.transforms.IGLPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.IStateTransform;
import com.google.common.io.Files;
import com.google.common.primitives.UnsignedBytes;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;

public class TexImageTransform
implements IStateTransform {
    private static final String PNG_IMAGE_FORMAT = "PNG";
    private static final String TEXTURE_FILE_PREFIX = "tex";
    private static final String TEXTURE_FILE_SUFFIX = ".png";
    private final IGLPropertyAccessor mAccessor;
    private final File mTextureDataFile;
    private final int mxOffset;
    private final int myOffset;
    private final int mWidth;
    private final int mHeight;
    private String mOldValue;
    private String mNewValue;
    private GLEnum mFormat;
    private GLEnum mType;

    public TexImageTransform(IGLPropertyAccessor accessor, File textureData, GLEnum format, GLEnum type, int xOffset, int yOffset, int width, int height) {
        this.mAccessor = accessor;
        this.mTextureDataFile = textureData;
        this.mFormat = format;
        this.mType = type;
        this.mxOffset = xOffset;
        this.myOffset = yOffset;
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public void apply(IGLProperty currentState) {
        assert (this.mOldValue == null) : "Transform cannot be applied multiple times";
        IGLProperty property = this.mAccessor.getProperty(currentState);
        if (!(property instanceof GLStringProperty)) {
            return;
        }
        GLStringProperty prop = (GLStringProperty)property;
        this.mOldValue = prop.getStringValue();
        if (this.mNewValue == null) {
            try {
                this.mNewValue = this.mOldValue == null ? this.createTexture(this.mTextureDataFile, this.mWidth, this.mHeight) : this.updateTextureData(this.mOldValue, this.mTextureDataFile, this.mxOffset, this.myOffset, this.mWidth, this.mHeight);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (RuntimeException e) {
                throw e;
            }
        }
        prop.setValue(this.mNewValue);
    }

    @Override
    public void revert(IGLProperty state) {
        if (this.mOldValue != null) {
            IGLProperty property = this.mAccessor.getProperty(state);
            property.setValue(this.mOldValue);
            this.mOldValue = null;
        }
    }

    @Override
    public IGLProperty getChangedProperty(IGLProperty state) {
        return this.mAccessor.getProperty(state);
    }

    private String createTexture(File textureDataFile, int width, int height) throws IOException {
        File f = FileUtils.createTempFile(TEXTURE_FILE_PREFIX, TEXTURE_FILE_SUFFIX);
        BufferedImage img = new BufferedImage(width, height, 6);
        if (textureDataFile != null) {
            byte[] initialData = Files.toByteArray((File)textureDataFile);
            img.getRaster().setDataElements(0, 0, width, height, this.formatSourceData(initialData, width, height));
        }
        ImageIO.write((RenderedImage)img, PNG_IMAGE_FORMAT, f);
        return f.getAbsolutePath();
    }

    private String updateTextureData(String currentImagePath, File textureDataFile, int xOffset, int yOffset, int width, int height) throws IOException {
        assert (currentImagePath != null) : "Attempt to update a null texture";
        if (textureDataFile == null) {
            return currentImagePath;
        }
        File f = FileUtils.createTempFile(TEXTURE_FILE_PREFIX, TEXTURE_FILE_SUFFIX);
        BufferedImage image = null;
        image = ImageIO.read(new File(currentImagePath));
        byte[] subImageData = Files.toByteArray((File)textureDataFile);
        image.getRaster().setDataElements(xOffset, yOffset, width, height, this.formatSourceData(subImageData, width, height));
        ImageIO.write((RenderedImage)image, PNG_IMAGE_FORMAT, f);
        return f.getAbsolutePath();
    }

    private byte[] formatSourceData(byte[] subImageData, int width, int height) {
        if (this.mType != GLEnum.GL_UNSIGNED_BYTE) {
            subImageData = this.unpackData(subImageData, this.mType);
        }
        switch (this.mFormat) {
            case GL_RGBA: {
                return subImageData;
            }
            case GL_RGB: {
                return this.addAlphaChannel(subImageData, width, height);
            }
            case GL_RED: 
            case GL_GREEN: 
            case GL_BLUE: {
                if (this.mType != GLEnum.GL_FLOAT) {
                    throw new RuntimeException();
                }
            }
            case GL_ALPHA: {
                return this.addRGBChannels(subImageData, width, height);
            }
            case GL_LUMINANCE: {
                return this.createRGBAFromLuminance(subImageData, width, height);
            }
            case GL_LUMINANCE_ALPHA: {
                return this.createRGBAFromLuminanceAlpha(subImageData, width, height);
            }
        }
        throw new RuntimeException();
    }

    private byte[] unpackData(byte[] data, GLEnum type) {
        switch (type) {
            case GL_UNSIGNED_BYTE: {
                return data;
            }
            case GL_UNSIGNED_SHORT_4_4_4_4: {
                return this.convertShortToUnsigned(data, 61440, 12, 3840, 8, 240, 4, 15, 0, true);
            }
            case GL_UNSIGNED_SHORT_5_6_5: {
                return this.convertShortToUnsigned(data, 63488, 11, 2016, 5, 31, 0, 0, 0, false);
            }
            case GL_UNSIGNED_SHORT_5_5_5_1: {
                return this.convertShortToUnsigned(data, 63488, 11, 1984, 6, 62, 1, 1, 0, true);
            }
            case GL_FLOAT: {
                return this.convertFloatToUnsigned(data);
            }
        }
        return data;
    }

    private byte[] convertFloatToUnsigned(byte[] data) {
        byte[] unsignedData = new byte[data.length];
        ByteBuffer floatBuffer = ByteBuffer.wrap(data);
        int i = 0;
        while (i < data.length / 4) {
            byte alpha;
            float v = floatBuffer.getFloat(i);
            unsignedData[i * 4 + 3] = alpha = (byte)(v * 255.0f);
            ++i;
        }
        return unsignedData;
    }

    private byte[] convertShortToUnsigned(byte[] shortData, int rmask, int rshift, int gmask, int gshift, int bmask, int bshift, int amask, int ashift, boolean includeAlpha) {
        int numChannels = includeAlpha ? 4 : 3;
        byte[] unsignedData = new byte[shortData.length / 2 * numChannels];
        int i = 0;
        while (i < shortData.length / 2) {
            int hi = UnsignedBytes.toInt((byte)shortData[i * 2 + 0]);
            int lo = UnsignedBytes.toInt((byte)shortData[i * 2 + 1]);
            int x = hi << 8 | lo;
            int r = (x & rmask) >>> rshift;
            int g = (x & gmask) >>> gshift;
            int b = (x & bmask) >>> bshift;
            int a = (x & amask) >>> ashift;
            unsignedData[i * numChannels + 0] = UnsignedBytes.checkedCast((long)r);
            unsignedData[i * numChannels + 1] = UnsignedBytes.checkedCast((long)g);
            unsignedData[i * numChannels + 2] = UnsignedBytes.checkedCast((long)b);
            if (includeAlpha) {
                unsignedData[i * numChannels + 3] = UnsignedBytes.checkedCast((long)a);
            }
            ++i;
        }
        return unsignedData;
    }

    private byte[] addAlphaChannel(byte[] sourceData, int width, int height) {
        assert (sourceData.length == 3 * width * height);
        byte[] data = new byte[4 * width * height];
        int src = 0;
        int dst = 0;
        while (src < sourceData.length) {
            data[dst + 0] = sourceData[src + 0];
            data[dst + 1] = sourceData[src + 1];
            data[dst + 2] = sourceData[src + 2];
            data[dst + 3] = 1;
            src += 3;
            dst += 4;
        }
        return data;
    }

    private byte[] addRGBChannels(byte[] sourceData, int width, int height) {
        assert (sourceData.length == width * height);
        byte[] data = new byte[4 * width * height];
        int src = 0;
        int dst = 0;
        while (src < sourceData.length) {
            data[dst + 2] = 0;
            data[dst + 1] = 0;
            data[dst + 0] = 0;
            data[dst + 3] = sourceData[src];
            ++src;
            dst += 4;
        }
        return data;
    }

    private byte[] createRGBAFromLuminance(byte[] sourceData, int width, int height) {
        assert (sourceData.length == width * height);
        byte[] data = new byte[4 * width * height];
        int src = 0;
        int dst = 0;
        while (src < sourceData.length) {
            int l = sourceData[src] * 3;
            if (l > 255) {
                l = 255;
            }
            byte by = (byte)l;
            data[dst + 2] = by;
            data[dst + 1] = by;
            data[dst + 0] = by;
            data[dst + 3] = 1;
            ++src;
            dst += 4;
        }
        return data;
    }

    private byte[] createRGBAFromLuminanceAlpha(byte[] sourceData, int width, int height) {
        assert (sourceData.length == 2 * width * height);
        byte[] data = new byte[4 * width * height];
        int src = 0;
        int dst = 0;
        while (src < sourceData.length) {
            int l = sourceData[src] * 3;
            if (l > 255) {
                l = 255;
            }
            byte by = (byte)l;
            data[dst + 2] = by;
            data[dst + 1] = by;
            data[dst + 0] = by;
            data[dst + 3] = sourceData[src + 1];
            src += 2;
            dst += 4;
        }
        return data;
    }
}

