/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class GlTracePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.android.ide.eclipse.gldebugger";
    private static GlTracePlugin plugin;
    private MessageConsole mConsole;
    private MessageConsoleStream mConsoleStream;
    private static Runnable sShowConsoleRunnable;

    static {
        sShowConsoleRunnable = new Runnable(){

            @Override
            public void run() {
                GlTracePlugin.showConsoleView();
            }
        };
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.mConsole = new MessageConsole("OpenGL Trace View", null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.mConsole});
        this.mConsoleStream = this.mConsole.newMessageStream();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static GlTracePlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return GlTracePlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void logMessage(String message) {
        this.mConsoleStream.println(message);
        Display.getDefault().asyncExec(sShowConsoleRunnable);
    }

    private static void showConsoleView() {
        IWorkbenchPage page;
        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (w != null && (page = w.getActivePage()) != null) {
            try {
                page.showView("org.eclipse.ui.console.ConsoleView", null, 2);
            }
            catch (PartInitException partInitException) {}
        }
    }
}

