/**********************************************************************
*                 SEGGER Software GmbH                               *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2019  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product. This file may
only be used in accordance with the following terms:

The  software has  been licensed by SEGGER Software GmbH to Realtek 
Semiconductor Corp. at the address: Realtek Semiconductor Corp., 
Hsinchu Science Park, Innovation Rd. II 2, 300 Hsinchu city, Taiwan for 
the purposes  of  creating  libraries  for its Cortex-M series of 
Microcontroller Units designed, branded, marketed and manufactured by 
Realtek Semiconductor Corp. under the terms and conditions of an End 
User License Agreement supplied with the libraries.

Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Software GmbH
Licensed to:              Realtek Semiconductor Corp., Hsinchu Science Park, Innovation Rd. II 2, 300 Hsinchu city, Taiwan
Licensed SEGGER software: emWin
License number:           GUI-00784
License model:            emWin Buyout Agreement, signed May 15th, 2019
Licensed platform:        Cortex-M series of Microcontroller Units designed, branded, marketed and manufactured by LICENSEE
----------------------------------------------------------------------
File        : WIDGET_Knob.c
Purpose     : Shows how to create a radial menu with motion support
Requirements: WindowManager - (x)
              MemoryDevices - (x)
              AntiAliasing  - (x)
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
----------------------------------------------------------------------
*/

#include "DIALOG.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define ID_WIN_0            (GUI_ID_USER + 0x00)

#if (GUI_USE_ARGB)
  #define AMP_COLOR_GRAY     0xFF4D4B4C
  #define AMP_COLOR_GREEN    0xFF00E800
  #define AMP_COLOR_YELLOW   0xFFFFD646
#else
  #define AMP_COLOR_GRAY     0x004C4B4D
  #define AMP_COLOR_GREEN    0x0000E800
  #define AMP_COLOR_YELLOW   0x0046D6FF
#endif
#define START_POS_CURSOR_X   150
#define START_POS_CURSOR_Y   130
#define MOTION_LINEAR        0
#define MOTION_ROUND         1
#define UNPRESSED            0
#define PRESSED              1 

#ifdef WIN32
  #define TIME_PER_FRAME 10
#else
  #define TIME_PER_FRAME 40
#endif

//
// Recommended memory to run the sample with adequate performance
//
#define RECOMMENDED_MEMORY (1024L * 350)

/*********************************************************************
*
*       Types
*
**********************************************************************
*/

typedef struct ANIMATION ANIMATION;
typedef struct ANIMATION_ITEM ANIMATION_ITEM;

typedef struct {
  U8 MotionRound;
  U8 Pressed;
  I32 (* pfAnimType) (ANIMATION * pAnim, ANIMATION_ITEM * pItem, GUI_TIMER_TIME tCurrent);
  int ExecTime;
  int x;
  int y;
  int AngleS;
  int AngleE;
  int r;
} ANIM;

struct ANIMATION_ITEM {
  int  (* pfAnim)  (int Pos, ANIM * pAnim);
  I32  (* pfTiming)(ANIMATION * pAnim, ANIMATION_ITEM * pItem, GUI_TIMER_TIME tCurrent);
  GUI_TIMER_TIME ts;
  GUI_TIMER_TIME te;
  void * pVoid;
  int IsRunning;
  ANIMATION_ITEM * pNext;
};

struct ANIMATION {
  GUI_TIMER_TIME Period;
  GUI_TIMER_TIME t0;
  ANIMATION_ITEM * pFirst;
};


/*********************************************************************
*
*       Static data
*
**********************************************************************
*/

/*********************************************************************
*
*       Backgound + All unchanged 480x272
*/
static GUI_CONST_STORAGE GUI_COLOR _ColorsBackground_480x272[] = {
#if (GUI_USE_ARGB)
  0xFFCBCCD1, 0xFF4C4A4B, 0xFFBBBBC1, 0xFFB3B3BA,
  0xFFDAD9DD, 0xFFD4D4D8, 0xFFDCDBE0, 0xFFD1D1D5,
  0xFFE4E3E8, 0xFFC3C4C9, 0xFFE1E1E4, 0xFFABABB3,
  0xFFE0DDE3, 0xFFFEFEFE, 0xFFC1C2C5, 0xFFA3A3AB,
  0xFFC6C8CD, 0xFF9B9BA3, 0xFFC9C9CD, 0xFFD8D5DB,
  0xFFCED0D4, 0xFFB9BABC, 0xFF9B9A9C, 0xFF93939B,
  0xFF8C8A8B, 0xFF6B6A6B, 0xFF838283, 0xFF747373,
  0xFF949293, 0xFF7C7A7B, 0xFF636263, 0xFFE9E9EB,
  0xFF383637, 0xFF5B5A5B, 0xFF6B6D78, 0xFFA2A2A4,
  0xFF70737D, 0xFF8A8B94, 0xFFABAAAB, 0xFFBEC0C4,
  0xFF636571, 0xFF81838C, 0xFF424142, 0xFF797B84,
  0xFFB3B2B3, 0xFF686A75, 0xFF7D8089, 0xFF545354,
  0xFF020102, 0xFF6D707B, 0xFFF3F3F3, 0xFFB6B8BD,
  0xFF2A282A, 0xFFA7A7B0, 0xFF868891, 0xFFA7A8B0,
  0xFF737580, 0xFFAFAFB8, 0xFF757882, 0xFF7B7E88,
  0xFFD6D8DB, 0xFFA09EA5, 0xFF838690, 0xFF98969C,
  0xFF656873, 0xFFA09D9E, 0xFF60626D, 0xFFE8E5EA,
  0xFF2121A0, 0xFF5858B8, 0xFF8E9099, 0xFF888586,
  0xFF989596, 0xFF5C5E6A, 0xFF171617, 0xFF9696A0,
  0xFF898688, 0xFFB0AEB4, 0xFF8C8E98, 0xFFB8B6BC,
  0xFF908D8E, 0xFFB7B7C0, 0xFFD0CDD3, 0xFF696668,
  0xFF716E71, 0xFF605D5E, 0xFF817E80, 0xFF807D7E,
  0xFF706D6E, 0xFF595658, 0xFF312E31, 0xFF787576,
  0xFF686566, 0xFF797678, 0xFF918E90, 0xFF595A65,
  0xFF9698A0, 0xFFAEB0B5, 0xFF514E51, 0xFF302D2E,
  0xFF1C232A, 0xFF494648, 0xFF5E606C, 0xFF615E60,
  0xFF908F99, 0xFF504D4E, 0xFF423D42, 0xFF585556,
  0xFFA7A8AD, 0xFF484546, 0xFFC9C5C5, 0xFFE7E8E9,
  0xFF403D3E, 0xFF8D9096, 0xFFC0BDBE, 0xFFC9C6C9,
  0xFFA9A6AA, 0xFFA8A4A5, 0xFF9897A0, 0xFF282A32,
  0xFFB8B5B6, 0xFF9EA0A6, 0xFF191C23, 0xFFB1ADAD,
  0xFFB7B8C0, 0xFF241B24, 0xFFC1BEC0, 0xFFF1F1F9,
  0xFF3B3942, 0xFF9EA0A8, 0xFF96989E, 0xFFD5D5ED,
  0xFF140D14, 0xFF4B4952, 0xFF9595D2, 0xFF565864,
  0xFF545662, 0xFF85888F, 0xFFEAE4E4, 0xFF1E2730,
  0xFF140A0A, 0xFF9E9EA8, 0xFFB0AFB8, 0xFFE3D9D8,
  0xFF545359, 0xFF4A4AB2, 0xFFF1EDED, 0xFF0C0B13,
  0xFF221A19, 0xFF3C3CAC, 0xFF6666BE, 0xFFD2CACC,
  0xFFD9D4D5, 0xFF2A3138, 0xFFFBF5F9, 0xFF43424A,
  0xFF7474C4, 0xFFABABDB, 0xFF94908F, 0xFF888790,
  0xFFA09FA8, 0xFFC7C7E7, 0xFFBCB8B6, 0xFF61555D,
  0xFFA4A09E, 0xFFE6E2DE, 0xFFECE9E4, 0xFFE3E3F3,
  0xFFF6F3EC, 0xFFFBF8F5, 0xFF0E1216, 0xFF9B9897,
  0xFFA2959B, 0xFFF4EDF1, 0xFF4B5155, 0xFF6A5E69,
  0xFFA9A5B0, 0xFFB2A6AC, 0xFFD6D2CD, 0xFFFDF4F4,
  0xFF525460, 0xFF5A5461, 0xFF635C6A, 0xFF67686F,
  0xFF6D6672, 0xFF726266, 0xFF7C7680, 0xFF80767C,
  0xFF827A88, 0xFF918691, 0xFFB2A4A5, 0xFFF2E5E3,
  0xFFF1E6EA, 0xFF28211F, 0xFF2E302F, 0xFF43494D,
  0xFF57504D, 0xFF6A5B5B, 0xFF695E63, 0xFF70646A,
  0xFF7A696B, 0xFF76787E, 0xFF837582, 0xFF897E86,
  0xFF897F89, 0xFF918785, 0xFF908389, 0xFF998B8D,
  0xFF9D8E95, 0xFFA29192, 0xFFA89C9C, 0xFFAA9EA4,
  0xFFACA8A7, 0xFFBAA9AE, 0xFFBAADB4, 0xFF8282CA,
  0xFFB9B9E1, 0xFFC2B7B6, 0xFFC0BBB7, 0xFFCABCBB,
  0xFFC6C0BD, 0xFFDADAD7, 0xFFFFEEEE, 0xFF15110E,
  0xFF220710, 0xFF361B24, 0xFF41282E, 0xFF432831,
  0xFF533841, 0xFF5C5855, 0xFF5F6066, 0xFF625454,
  0xFF6B5059, 0xFF705B62, 0xFF68655E, 0xFF6A6967,
  0xFF806971, 0xFF807674, 0xFF89817F, 0xFF8C8887,
  0xFF9EA09F, 0xFFA18F8F, 0xFFA89199, 0xFFA197A0,
  0xFFB099A1, 0xFFAEB0B8, 0xFFBCA5AD, 0xFFB4B0AF,
  0xFFB8B7C0, 0xFFC3A8B1, 0xFFC1B6BA, 0xFFCABEC0,
  0xFFCCC8C7, 0xFFDFE0E4, 0xFFF8E6E6, 0xFFFBE0E9
#else
  0xD1CCCB, 0x4B4A4C, 0xC1BBBB, 0xBAB3B3,
  0xDDD9DA, 0xD8D4D4, 0xE0DBDC, 0xD5D1D1,
  0xE8E3E4, 0xC9C4C3, 0xE4E1E1, 0xB3ABAB,
  0xE3DDE0, 0xFEFEFE, 0xC5C2C1, 0xABA3A3,
  0xCDC8C6, 0xA39B9B, 0xCDC9C9, 0xDBD5D8,
  0xD4D0CE, 0xBCBAB9, 0x9C9A9B, 0x9B9393,
  0x8B8A8C, 0x6B6A6B, 0x838283, 0x737374,
  0x939294, 0x7B7A7C, 0x636263, 0xEBE9E9,
  0x373638, 0x5B5A5B, 0x786D6B, 0xA4A2A2,
  0x7D7370, 0x948B8A, 0xABAAAB, 0xC4C0BE,
  0x716563, 0x8C8381, 0x424142, 0x847B79,
  0xB3B2B3, 0x756A68, 0x89807D, 0x545354,
  0x020102, 0x7B706D, 0xF3F3F3, 0xBDB8B6,
  0x2A282A, 0xB0A7A7, 0x918886, 0xB0A8A7,
  0x807573, 0xB8AFAF, 0x827875, 0x887E7B,
  0xDBD8D6, 0xA59EA0, 0x908683, 0x9C9698,
  0x736865, 0x9E9DA0, 0x6D6260, 0xEAE5E8,
  0xA02121, 0xB85858, 0x99908E, 0x868588,
  0x969598, 0x6A5E5C, 0x171617, 0xA09696,
  0x888689, 0xB4AEB0, 0x988E8C, 0xBCB6B8,
  0x8E8D90, 0xC0B7B7, 0xD3CDD0, 0x686669,
  0x716E71, 0x5E5D60, 0x807E81, 0x7E7D80,
  0x6E6D70, 0x585659, 0x312E31, 0x767578,
  0x666568, 0x787679, 0x908E91, 0x655A59,
  0xA09896, 0xB5B0AE, 0x514E51, 0x2E2D30,
  0x2A231C, 0x484649, 0x6C605E, 0x605E61,
  0x998F90, 0x4E4D50, 0x423D42, 0x565558,
  0xADA8A7, 0x464548, 0xC5C5C9, 0xE9E8E7,
  0x3E3D40, 0x96908D, 0xBEBDC0, 0xC9C6C9,
  0xAAA6A9, 0xA5A4A8, 0xA09798, 0x322A28,
  0xB6B5B8, 0xA6A09E, 0x231C19, 0xADADB1,
  0xC0B8B7, 0x241B24, 0xC0BEC1, 0xF9F1F1,
  0x42393B, 0xA8A09E, 0x9E9896, 0xEDD5D5,
  0x140D14, 0x52494B, 0xD29595, 0x645856,
  0x625654, 0x8F8885, 0xE4E4EA, 0x30271E,
  0x0A0A14, 0xA89E9E, 0xB8AFB0, 0xD8D9E3,
  0x595354, 0xB24A4A, 0xEDEDF1, 0x130B0C,
  0x191A22, 0xAC3C3C, 0xBE6666, 0xCCCAD2,
  0xD5D4D9, 0x38312A, 0xF9F5FB, 0x4A4243,
  0xC47474, 0xDBABAB, 0x8F9094, 0x908788,
  0xA89FA0, 0xE7C7C7, 0xB6B8BC, 0x5D5561,
  0x9EA0A4, 0xDEE2E6, 0xE4E9EC, 0xF3E3E3,
  0xECF3F6, 0xF5F8FB, 0x16120E, 0x97989B,
  0x9B95A2, 0xF1EDF4, 0x55514B, 0x695E6A,
  0xB0A5A9, 0xACA6B2, 0xCDD2D6, 0xF4F4FD,
  0x605452, 0x61545A, 0x6A5C63, 0x6F6867,
  0x72666D, 0x666272, 0x80767C, 0x7C7680,
  0x887A82, 0x918691, 0xA5A4B2, 0xE3E5F2,
  0xEAE6F1, 0x1F2128, 0x2F302E, 0x4D4943,
  0x4D5057, 0x5B5B6A, 0x635E69, 0x6A6470,
  0x6B697A, 0x7E7876, 0x827583, 0x867E89,
  0x897F89, 0x858791, 0x898390, 0x8D8B99,
  0x958E9D, 0x9291A2, 0x9C9CA8, 0xA49EAA,
  0xA7A8AC, 0xAEA9BA, 0xB4ADBA, 0xCA8282,
  0xE1B9B9, 0xB6B7C2, 0xB7BBC0, 0xBBBCCA,
  0xBDC0C6, 0xD7DADA, 0xEEEEFF, 0x0E1115,
  0x100722, 0x241B36, 0x2E2841, 0x312843,
  0x413853, 0x55585C, 0x66605F, 0x545462,
  0x59506B, 0x625B70, 0x5E6568, 0x67696A,
  0x716980, 0x747680, 0x7F8189, 0x87888C,
  0x9FA09E, 0x8F8FA1, 0x9991A8, 0xA097A1,
  0xA199B0, 0xB8B0AE, 0xADA5BC, 0xAFB0B4,
  0xC0B7B8, 0xB1A8C3, 0xBAB6C1, 0xC0BECA,
  0xC7C8CC, 0xE4E0DF, 0xE6E6F8, 0xE9E0FB
#endif
};

static GUI_CONST_STORAGE GUI_LOGPALETTE _PalBackground_480x272 = {
  256,  // Number of entries
  0,    // No transparency
  &_ColorsBackground_480x272[0]
};

static GUI_CONST_STORAGE unsigned char _acBackground_480x272[] = {
  0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x51, 0x51, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x00, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 
        0x52, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x7C, 0x33, 0x33, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x39, 0x61, 0x61, 0x61, 0x0B, 0x61, 0x61, 0x0B, 0x37, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 
        0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x8D, 0x11, 0x11, 0x76, 0x60, 0x60, 0x60, 0x4B, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x17, 0x68, 0x68, 0x17, 0x17, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x68, 0x17, 0x17, 0x17, 0x17, 0x68, 0x68, 0x46, 0x68, 
        0x68, 0x68, 0x46, 0x68, 0x46, 0x71, 0x68, 0x68, 0x71, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x3A, 0x3A, 0x38, 0x24, 0x24, 0x24, 0x24, 0x31, 
        0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 
        0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x2D, 0x2D, 0x22, 0x22, 0x2D, 0x2D, 
        0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x51, 0x7C, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x14, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x12, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 
        0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x7C, 0x15, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x39, 0x61, 0x61, 
        0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x6C, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0x79, 0x79, 0x79, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x60, 0x4B, 0x4B, 0x3F, 0x17, 0x17, 0x17, 0x68, 0x46, 0x46, 0x4E, 0x4E, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x89, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 
        0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 
        0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 
        0x42, 0x42, 0x42, 0x66, 0x66, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x87, 0x87, 0x87, 0x87, 0x87, 0x87, 0x87,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x51, 0x51, 0x51, 0x51, 0x7C, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 
        0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x39, 0x39, 0x39, 0x61, 0x61, 
        0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x11, 0x11, 0x76, 0x60, 0x60, 0x4B, 0x3F, 0x17, 0x17, 0x68, 0x68, 0x46, 0x46, 0x46, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x36, 0x89, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 
        0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 
        0x42, 0x42, 0x66, 0x42, 0x42, 0x66, 0x66, 0x66, 0x66, 0x66, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F,
  0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x51, 0x51, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x60, 0x60, 0x4B, 0x3F, 0x17, 0x17, 0x17, 0x68, 0x46, 0x46, 
        0x4E, 0x4E, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 
        0x22, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 
        0x40, 0x2D, 0x2D, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x51, 0x51, 0x51, 0x51, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 
        0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x14, 0x14, 0x00, 0x14, 0x14, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x7C, 0x7C, 0x15, 0x15, 0x15, 0x15, 0x15, 0x33, 0xF8, 0x33, 0x4F, 0x4F, 0x33, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x8E, 0x8E, 0x39, 0x39, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x79, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 
        0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x82, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x68, 0x46, 0x46, 0x4E, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 
        0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x3A, 0x3A, 0x3A, 0x38, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 
        0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x28, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 
        0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x51, 0x33, 0x33, 0x4F, 0x33, 0x4F, 0x4F, 0x03, 0x03, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0x79, 0x3D, 0x11, 0x11, 0x76, 0x76, 0x60, 0x4B, 0x3F, 0x17, 0x68, 
        0x68, 0x46, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 
        0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 
        0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x42, 0x66, 0x66, 0x66, 0x66, 0x49, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x42,
  0x03, 0x33, 0x33, 0x33, 0x33, 0x51, 0x51, 0x51, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x7C, 0xF8, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x39, 0x39, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x11, 0x11, 0x76, 0x76, 0x76, 0x82, 0x3F, 0x17, 0x17, 0x68, 0x46, 0x46, 0x71, 0x4E, 0x25, 0x25, 
        0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x24, 0x24, 0x24, 
        0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x24, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 
        0x22, 0x22, 0x22, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x42, 0x66, 0x66, 0x66, 0x49, 0x49, 0x49, 0x49, 0x49, 0x5F, 0x5F, 0x5F,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0xF8, 0x51, 0xF8, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x7C, 0xF8, 0xF8, 0x33, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x8E, 0x8E, 0x61, 0x8E, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0x79, 0x79, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x60, 0x60, 0x4B, 0x3F, 
        0x17, 0x17, 0x17, 0x17, 0x17, 0x68, 0x46, 0x46, 0x46, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x2B, 
        0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x24, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 
        0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 
        0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x28, 0x28, 0x40, 0x40, 0x40, 0x40, 0x40,
  0x02, 0x02, 0x02, 0x02, 0x15, 0x7C, 0x7C, 0x15, 0x7C, 0x51, 0x7C, 0x7C, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x01, 0x01, 0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x01, 0x14, 0x14, 0x14, 0x01, 0x07, 0x07, 0x07, 0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x01, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x13, 
        0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x01, 0x10, 0x10, 0x09, 0x01, 0x09, 0x09, 0x09, 0x01, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x01, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x01, 0x0E, 0x0E, 0x01, 0x01, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x7C, 0x15, 0xF8, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x8E, 0x39, 0x39, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x11, 0x76, 0x76, 0x60, 0x82, 
        0x3F, 0x3F, 0x01, 0x17, 0x17, 0x68, 0x46, 0x4E, 0x71, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 
        0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 
        0x42, 0x42, 0x42, 0x42, 0x42, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x49, 0x66, 0x66, 0x66, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49,
  0x03, 0x03, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x51, 0x51, 0x51, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 
        0x27, 0x01, 0x27, 0x27, 0x27, 0x01, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x01, 0x14, 0x14, 0x14, 0x01, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x07, 0x07, 0x05, 0x07, 0x07, 0x05, 0x01, 0x05, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x01, 0x01, 0x12, 0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x01, 0x10, 0x10, 0x09, 
        0x09, 0x09, 0x01, 0x09, 0x09, 0x09, 0x01, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x15, 0x15, 0x15, 0x33, 0x4F, 0x33, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x39, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x6C, 0x37, 0x37, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x11, 
        0x11, 0x76, 0x01, 0x76, 0x4B, 0x3F, 0x3F, 0x17, 0x17, 0x68, 0x68, 0x46, 0x46, 0x4E, 0x4E, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 
        0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 
        0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x51, 0x51, 0x15, 0x15, 0x7C, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x27, 0x01, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x01, 0x01, 0x01, 0x0E, 0x09, 0x09, 0x01, 0x01, 0x09, 0x09, 0x10, 0x01, 0x10, 0x01, 0x01, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x12, 
        0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x00, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x01, 0x07, 0x07, 0x07, 0x01, 0x07, 0x07, 0x01, 0x01, 0x07, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x05, 0x01, 0x01, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x10, 0x01, 0x01, 0x09, 0x09, 0x09, 0x09, 0x01, 0x01, 0x09, 0x01, 0x09, 0x09, 0x01, 
        0x01, 0x09, 0x01, 0x09, 0x09, 0x0E, 0x01, 0x27, 0x27, 0x27, 0x27, 0x01, 0x01, 0x01, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x7C, 0x15, 
        0x33, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x39, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0x79, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x4B, 0x82, 
        0x3F, 0x3F, 0x01, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x01, 0x01, 0x01, 0x17, 0x17, 0x01, 0x17, 0x17, 0x68, 0x01, 0x68, 0x17, 0x68, 0x68, 0x68, 0x68, 0x68, 0x46, 0x68, 0x46, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x3E, 0x29, 0x29, 0x29, 
        0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x28, 
        0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 
        0x2D, 0x2D, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49,
  0x0B, 0x61, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x01, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x01, 0x27, 0x27, 0x0E, 0x01, 0x0E, 0x0E, 0x0E, 0x01, 0x01, 0x0E, 0x0E, 0x01, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x05, 0x01, 0x05, 0x05, 0x05, 0x01, 0x05, 0x05, 0x05, 0x01, 0x05, 0x01, 0x01, 0x05, 0x05, 0x01, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x10, 0x10, 0x01, 0x10, 0x10, 0x09, 0x01, 0x09, 0x09, 0x01, 0x01, 0x09, 0x01, 0x0E, 
        0x0E, 0x01, 0x01, 0x0E, 0x0E, 0x27, 0x01, 0x27, 0x27, 0x27, 0x01, 0x27, 0x27, 0x27, 0x01, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x7C, 0x15, 0x7C, 0x15, 0x7C, 0x51, 0x51, 0xF8, 0xF8, 
        0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x39, 0x39, 0x39, 0x61, 0x61, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 
        0x11, 0x11, 0x01, 0x76, 0x76, 0x76, 0x60, 0x60, 0x01, 0x4B, 0x4B, 0x4B, 0x01, 0x3F, 0x01, 0x3F, 0x17, 0x17, 0x01, 0x17, 0x17, 0x68, 0x68, 0x46, 0x46, 0x46, 0x46, 0x4E, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 
        0x29, 0x2E, 0x3B, 0x3B, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x24, 0x24, 0x24, 0x24, 
        0x24, 0x24, 0x24, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x28, 0x28, 
        0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
  0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x51, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x01, 0x09, 0x09, 0x01, 0x01, 0x09, 0x09, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x0E, 0x0E, 0x01, 0x0E, 0x0E, 0x0E, 0x01, 0x0E, 0x0E, 0x0E, 0x01, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x05, 0x05, 0x05, 0x01, 0x05, 0x05, 0x05, 0x01, 0x05, 0x05, 0x05, 0x01, 0x05, 0x05, 0x05, 0x01, 0x05, 0x01, 0x05, 0x05, 0x05, 0x01, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x12, 0x01, 0x10, 0x10, 0x10, 0x01, 0x10, 0x10, 0x09, 0x01, 0x09, 0x01, 0x09, 
        0x0E, 0x0E, 0x01, 0x0E, 0x27, 0x27, 0x01, 0x27, 0x27, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x02, 0x15, 0x15, 0x15, 0xF8, 0x4F, 0x4F, 
        0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x39, 0x8E, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x11, 0x3D, 
        0x3D, 0x3D, 0x01, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x01, 0x3D, 0x3D, 0x3D, 0x01, 0x3D, 0x01, 0x11, 0x01, 0x11, 0x01, 0x11, 0x76, 0x76, 0x76, 0x76, 0x60, 0x60, 0x4B, 0x3F, 0x17, 0x17, 0x68, 0x68, 0x46, 0x46, 0x4E, 0x4E, 0x25, 0x25, 0x36, 0x3E, 0x3E, 
        0x29, 0x29, 0x29, 0x2E, 0x3B, 0x3B, 0x2B, 0x2B, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 
        0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 
        0x40, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x51, 0x51, 0x51, 0x51, 0x7C, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x27, 0x01, 0x27, 0x27, 0x27, 0x01, 0x27, 0x01, 0x27, 0x27, 0x27, 0x01, 0x27, 0x27, 0x0E, 0x01, 0x0E, 0x0E, 0x27, 0x01, 0x0E, 0x09, 0x09, 0x01, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x01, 0x14, 0x14, 0x14, 0x01, 0x14, 0x14, 0x14, 0x01, 0x14, 0x14, 0x14, 0x14, 0x01, 0x01, 0x01, 0x01, 0x14, 0x01, 0x14, 0x14, 0x14, 0x01, 0x14, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 
        0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x07, 0x07, 0x07, 0x14, 0x01, 0x14, 0x14, 0x14, 0x01, 0x14, 0x14, 0x14, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 
        0x00, 0x00, 0x01, 0x00, 0x12, 0x12, 0x01, 0x10, 0x10, 0x10, 0x01, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x4F, 0x4F, 0x33, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x8E, 0x39, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x6C, 0x6C, 0x37, 0x37, 0x37, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x35, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0xA0, 0xA0, 0x01, 0xA0, 0x3D, 0x3D, 0x3D, 0x11, 0x01, 0x76, 0x76, 0x4B, 0x01, 0x3F, 0x01, 0x17, 0x01, 0x68, 0x01, 0x46, 0x46, 0x4E, 0x4E, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 
        0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 
        0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31,
  0x33, 0x33, 0x33, 0x51, 0x51, 0x51, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x02, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x0E, 0x01, 0x01, 0x01, 0x0E, 0x0E, 0x01, 0x09, 0x09, 0x09, 0x01, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x01, 0x14, 0x01, 0x14, 0x14, 0x07, 0x01, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x05, 0x05, 0x05, 0x01, 0x05, 0x05, 0x01, 0x01, 0x01, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x07, 0x07, 0x01, 
        0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x12, 0x12, 0x10, 0x01, 0x01, 0x01, 0x09, 0x09, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x33, 0xF8, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x4F, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x39, 0x39, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x6C, 0x6C, 0x35, 0x35, 0x0F, 0x6C, 0x35, 0x0F, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0xA0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3D, 0x11, 0x01, 0x01, 0x01, 0x76, 0x76, 0x4B, 0x01, 0x3F, 0x01, 0x17, 0x17, 0x68, 0x68, 0x46, 0x46, 0x46, 0x4E, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3A, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x31, 0x31, 0x22, 0x22, 0x22, 0x2D, 0x2D, 
        0x2D, 0x2D, 0x40, 0x40, 0x28, 0x28, 0x28, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 
        0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
  0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x51, 0x15, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 
        0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x01, 0x01, 0x01, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 
        0x7C, 0xF8, 0x33, 0x33, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x39, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x0F, 0x0F, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x76, 0x4B, 0x3F, 0x3F, 0x17, 0x68, 0x68, 0x46, 0x71, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 
        0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 
        0x42, 0x28, 0x28, 0x28, 0x42, 0x42, 0x66, 0x66, 0x66, 0x66, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F,
  0x33, 0x33, 0x4F, 0x4F, 0x33, 0x51, 0xF8, 0xF8, 0x51, 0x51, 0x51, 0x7C, 0x7C, 0x15, 0x02, 0x02, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 0x7C, 0x7C, 0x15, 0x7C, 0x7C, 0xF8, 0x51, 0x15, 0x51, 0x51, 0x51, 0x51, 0x51, 0x7C, 0x7C, 0x51, 0x51, 0x7C, 
        0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x05, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 
        0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x33, 0x33, 0x4F, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x39, 0x39, 0x39, 0x39, 0x61, 0x61, 0x39, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x11, 0x11, 0x76, 0x76, 0x76, 0x4B, 0x3F, 0x17, 0x17, 0x68, 0x46, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 
        0x2E, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 
        0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 
        0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x42,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0xF8, 0xF8, 0x15, 0x7C, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x10, 0x10, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x07, 0x07, 0x14, 0x14, 0x14, 
        0x14, 0x07, 0x07, 0x14, 0x07, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0xF8, 0xF8, 
        0x33, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x39, 0x39, 0x61, 0x61, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 
        0xA0, 0xA0, 0x3D, 0x3D, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 
        0x17, 0x68, 0x68, 0x46, 0x46, 0x46, 0x46, 0x71, 0x4E, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 
        0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 
        0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x66,
  0x37, 0x37, 0x37, 0x0B, 0x0B, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0xF8, 0x51, 0x7C, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x14, 0x14, 0x07, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x3C, 0x05, 0x13, 0x13, 0x3C, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 
        0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x10, 0x10, 0x09, 0x09, 0x09, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x7C, 0x33, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x39, 0x61, 0x61, 0x0B, 0x0B, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 
        0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x76, 0x60, 0x60, 0x4B, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x68, 0x46, 0x46, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
        0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 
        0x24, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 
        0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x42, 0x66, 0x66, 0x66, 0x66, 0x49,
  0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x51, 0x51, 0x51, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x7C, 0x7C, 0x51, 0x33, 0x33, 0x33, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x39, 0x39, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x35, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 
        0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x79, 0x79, 0x3D, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x60, 0x76, 0x82, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x68, 0x68, 0x46, 0x46, 0x71, 0x4E, 0x4E, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x24, 
        0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x31, 0x24, 0x24, 0x31, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 
        0x2D, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
  0x61, 0x61, 0x39, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x15, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x09, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x14, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x07, 0x07, 0x07, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x7C, 0x15, 0x7C, 0x7C, 0x7C, 0xF8, 0x4F, 0x4F, 0x33, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x61, 0x8E, 0x8E, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x6C, 0x6C, 0x35, 0x35, 0x35, 
        0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x81, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x76, 0x60, 0x4B, 0x4B, 0x3F, 0x17, 0x68, 
        0x46, 0x46, 0x4E, 0x25, 0x25, 0x25, 0x36, 0x36, 0x3E, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 
        0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x51, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x0E, 0x0E, 0x0E, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x3C, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 
        0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x35, 
        0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0x81, 0x81, 0x8D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x60, 0x82, 0x3F, 0x17, 0x68, 0x68, 0x46, 0x71, 0x4E, 0x25, 0x25, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 
        0x2E, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x31, 
        0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x31, 0x31, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x22, 
        0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
  0x8E, 0x8E, 0x8E, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x33, 0xF8, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x10, 0x10, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 
        0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 
        0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x51, 0xF8, 0x4F, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x35, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0x8D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x60, 0x60, 0x4B, 0x4B, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x68, 0x68, 0x68, 0x46, 0x46, 0x46, 0x71, 0x4E, 0x4E, 0x4E, 0x25, 0x25, 0x25, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x3A, 0x3A, 0x38, 0x38, 0x24, 0x24, 0x24, 
        0x24, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 
        0x31, 0x31, 0x31, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x66,
  0x33, 0x33, 0x33, 0x33, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x7C, 0x7C, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x51, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x3F, 0x54, 0x54, 0x54, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x16, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x12, 0x12, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x03, 0x23, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x1C, 0x23, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x07, 0x07, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8E, 0x3D, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 
        0x5B, 0x5B, 0x5B, 0x50, 0x11, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x15, 0x15, 0x15, 0x15, 0xF8, 0x15, 0x15, 0x15, 0x33, 0x33, 0x15, 0x15, 0x15, 0x33, 0x4F, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 
        0x39, 0x61, 0x61, 0x0B, 0x82, 0x9F, 0x19, 0x19, 0x19, 0x19, 0x19, 0x53, 0x53, 0x53, 0x53, 0x53, 0xC9, 0x1A, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x4B, 0x76, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 
        0x68, 0x68, 0x68, 0x46, 0x46, 0x46, 0x46, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x2B, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 
        0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42,
  0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x51, 0x51, 0x51, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x4D, 0x4C, 0x54, 0x2F, 0x5C, 0x5D, 0x18, 0x16, 0xD4, 0xA2, 0x6E, 0x6E, 0x7E, 0x78, 0x26, 0x41, 0x18, 0x1B, 0x55, 0x1E, 0x1A, 0x6C, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x07, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x5E, 0x5B, 0x2F, 0x5C, 0x5D, 0x18, 0x16, 0xD4, 0xA2, 0x6E, 0x6E, 0x7E, 0x78, 0x26, 0x41, 0x18, 0x1B, 0x55, 0x5C, 0x18, 0x03, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 
        0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x13, 0x3C, 0x05, 0x3C, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x27, 0x1C, 0x5D, 0x2F, 0x5C, 0x5D, 0x18, 0x16, 0xD4, 0xA2, 0x6E, 0x6E, 0x7E, 
        0x78, 0x26, 0x41, 0x18, 0x1B, 0x55, 0x5C, 0x4C, 0x4D, 0x00, 0x12, 0x12, 0x00, 0x12, 0x00, 0x12, 0x12, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x33, 0x33, 0x15, 0x15, 0x15, 0x33, 0x33, 0x33, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0xA0, 0x1A, 0x19, 0x2F, 0x5C, 0x5D, 0x18, 0x16, 0xD4, 0xA2, 0x6E, 0x6E, 0x7E, 0x78, 0x26, 0x41, 0x18, 0x1B, 0x55, 0x21, 0x54, 0x25, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x4B, 0x4B, 0x3F, 0x3F, 0x17, 0x68, 0x68, 0x46, 0x71, 0x4E, 0x4E, 0x25, 0x25, 
        0x25, 0x25, 0x36, 0x36, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x3B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 
        0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x51, 0x51, 0x7C, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x0F, 0x1E, 0x59, 0x19, 0x1D, 0x50, 0x48, 0x41, 0x75, 0x26, 0x2C, 0xA2, 0x7E, 0x73, 0x73, 0x6E, 0x7E, 0x7E, 0xDA, 0xA2, 0x78, 0x23, 0x18, 0xEB, 0x55, 0x4C, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x03, 0x5C, 0x59, 0x19, 0x1D, 0x50, 0x48, 0x41, 0x75, 0x26, 0x2C, 0xA2, 0x7E, 0x73, 0x73, 0x6E, 0x7E, 0x7E, 0xDA, 0xA2, 0x78, 0x23, 0x18, 0xEB, 0x67, 0x1C, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x05, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x07, 0x03, 0x5C, 0x59, 0x19, 0x1D, 0x50, 0x48, 0x41, 0x75, 0x26, 0x2C, 0xA2, 0x7E, 0x73, 0x73, 
        0x6E, 0x7E, 0x7E, 0xDA, 0xA2, 0x78, 0x23, 0x18, 0xEB, 0x67, 0x5E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x33, 0x4F, 0x03, 0x03, 0x03, 0x8E, 0x39, 0x61, 0x0B, 0x0B, 0x37, 0x37, 0x17, 0x55, 
        0x59, 0x19, 0x1D, 0x50, 0x48, 0x41, 0x75, 0x26, 0x2C, 0xA2, 0x7E, 0x73, 0x73, 0x6E, 0x7E, 0x7E, 0xDA, 0xA2, 0x78, 0x23, 0x18, 0xEB, 0x59, 0x5B, 0x60, 0x60, 0x76, 0x60, 0x4B, 0x82, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x68, 0x68, 0x68, 0x68, 0x68, 
        0x46, 0x68, 0x68, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x4E, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x3E, 0x3E, 0x29, 0x29, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x38, 0x24, 
        0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
  0x61, 0x61, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x15, 0x15, 0xF8, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x4C, 0x21, 
        0x21, 0x5C, 0x54, 0x5D, 0x56, 0x4C, 0x50, 0x48, 0x41, 0x75, 0x26, 0x2C, 0x15, 0x0E, 0x73, 0x73, 0x0E, 0x7E, 0x72, 0x15, 0xA2, 0x78, 0x2C, 0x7B, 0x41, 0x56, 0x59, 0x1A, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5E, 0x55, 0x21, 0x5C, 0x54, 0x5D, 0x56, 0x4C, 0x50, 0x48, 0x41, 0x75, 0x26, 0x2C, 0x15, 0x0E, 0x73, 0x73, 0x0E, 0x7E, 0x72, 0x15, 0xA2, 0x78, 0x2C, 0x7B, 0x41, 0x56, 0x59, 0x18, 
        0x09, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x13, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x3C, 0x3C, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x1C, 0x55, 0x21, 0x5C, 0x54, 0x5D, 0x56, 0x4C, 0x50, 0x48, 0x41, 0x75, 0x26, 0x2C, 0x15, 0x0E, 0x73, 
        0x73, 0x0E, 0x7E, 0x72, 0x15, 0xA2, 0x78, 0x2C, 0x7B, 0x41, 0x56, 0x59, 0x4C, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x61, 0x56, 0x21, 0x21, 0x5C, 
        0x54, 0x5D, 0x56, 0x4C, 0x50, 0x48, 0x41, 0x75, 0x26, 0x2C, 0x15, 0x0E, 0x73, 0x73, 0x0E, 0x7E, 0x72, 0x15, 0xA2, 0x78, 0x2C, 0x7B, 0x41, 0x56, 0x59, 0x54, 0x25, 0x60, 0x4B, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x68, 0x68, 0x68, 0x46, 
        0x46, 0x4E, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 
        0x2E, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x3A, 0x3A, 0x38, 0x38, 0x24, 0x24, 0x24, 0x31, 0x31, 0x22, 0x22, 0x2D, 0x2D, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x66, 
        0x66, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x66, 0x66, 0x49,
  0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0xF8, 0x15, 0x15, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x1E, 0x55, 0x55, 
        0x55, 0x1E, 0x19, 0x1B, 0x1D, 0x47, 0x1C, 0x23, 0x26, 0x78, 0x7E, 0x73, 0x52, 0x05, 0x0C, 0x08, 0x6F, 0x6F, 0xFD, 0x05, 0x0E, 0x15, 0x78, 0xF7, 0xF7, 0x26, 0x23, 0x1A, 0x5C, 0x18, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x03, 0x5C, 0x55, 0x55, 0x55, 0x1E, 0x19, 0x1B, 0x1D, 0x47, 0x1C, 0x23, 0x26, 0x78, 0x7E, 0x73, 0x52, 0x05, 0x0C, 0x08, 0x6F, 0x6F, 0xFD, 0x05, 0x0E, 0x15, 0x78, 0xF7, 0xF7, 0x26, 0x23, 0x1A, 
        0x53, 0x1C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x04, 0x04, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x04, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x03, 0x5C, 0x55, 0x55, 0x55, 0x1E, 0x19, 0x1B, 0x1D, 0x47, 0x1C, 0x23, 0x26, 0x78, 0x7E, 0x73, 0x52, 0x05, 0x0C, 
        0x08, 0x6F, 0x6F, 0xFD, 0x05, 0x0E, 0x15, 0x78, 0xF7, 0xF7, 0x26, 0x23, 0x1A, 0x5C, 0x5E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x23, 0x1E, 0x55, 0x55, 0x55, 0x1E, 
        0x19, 0x1B, 0x1D, 0x47, 0x1C, 0x23, 0x26, 0x78, 0x7E, 0x73, 0x52, 0x05, 0x0C, 0x08, 0x6F, 0x6F, 0xFD, 0x05, 0x0E, 0x15, 0x78, 0xF7, 0xF7, 0x26, 0x23, 0x1A, 0x1E, 0xC9, 0xA0, 0xA0, 0x3D, 0x11, 0x11, 0x76, 0x76, 0x76, 0x4B, 0x3F, 0x17, 0x17, 0x68, 
        0x46, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 
        0x3A, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x2D, 0x2D, 0x2D, 
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x51, 0x51, 0x51, 0x33, 0x51, 0x51, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x02, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x56, 0x21, 0x19, 0x58, 0x53, 
        0x1E, 0x55, 0x19, 0x57, 0x5E, 0x41, 0x75, 0x26, 0x2C, 0x15, 0x7E, 0x73, 0x52, 0x05, 0x06, 0x08, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0x92, 0x07, 0x15, 0xF7, 0x7B, 0x26, 0x74, 0x41, 0x1D, 0x5C, 0x61, 0x0E, 0x0E, 0x0E, 0x09, 0x0E, 0x0E, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x18, 0x21, 0x19, 0x58, 0x53, 0x1E, 0x55, 0x19, 0x57, 0x5E, 0x41, 0x75, 0x26, 0x2C, 0x15, 0x7E, 0x73, 0x52, 0x05, 0x06, 0x08, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0x92, 0x07, 0x15, 0xF7, 0x7B, 0x26, 0x74, 
        0x41, 0x1D, 0x19, 0x0E, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x05, 0x05, 
        0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x18, 0x21, 0x19, 0x58, 0x53, 0x1E, 0x55, 0x19, 0x57, 0x5E, 0x41, 0x75, 0x26, 0x2C, 0x15, 0x7E, 0x73, 0x52, 0x05, 0x06, 
        0x08, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0x92, 0x07, 0x15, 0xF7, 0x7B, 0x26, 0x74, 0x41, 0x1D, 0x53, 0x02, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x51, 0x15, 0x33, 0x33, 0x15, 0xF8, 0x57, 0x21, 0x19, 0x58, 0x53, 0x1E, 0x55, 
        0x19, 0x57, 0x5E, 0x41, 0x75, 0x26, 0x2C, 0x15, 0x7E, 0x73, 0x52, 0x05, 0x06, 0x08, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0x92, 0x07, 0x15, 0xF7, 0x7B, 0x26, 0x74, 0x41, 0x1D, 0x67, 0x17, 0xA0, 0x3D, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 
        0x76, 0x60, 0x4B, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x68, 0x71, 0x4E, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x3A, 0x38, 
        0x38, 0x24, 0x24, 0x31, 0x31, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x28,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0xF8, 0x7C, 0x02, 0x0F, 0x55, 0x58, 0x56, 0x57, 0x5B, 0x58, 
        0xEB, 0x1B, 0x47, 0x50, 0x48, 0x16, 0x23, 0x26, 0x2C, 0x15, 0x7E, 0x73, 0x52, 0x05, 0x06, 0x08, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x6F, 0x00, 0x15, 0x7B, 0x26, 0x26, 0x23, 0x1C, 0x67, 0x18, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x12, 0x12, 
        0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x03, 0x67, 0x58, 0x56, 0x57, 0x5B, 0x58, 0xEB, 0x1B, 0x47, 0x50, 0x48, 0x16, 0x23, 0x26, 0x2C, 0x15, 0x7E, 0x73, 0x52, 0x05, 0x06, 0x08, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x6F, 0x00, 0x15, 0x7B, 0x26, 
        0x26, 0x23, 0x1C, 0x67, 0x1C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x05, 0x3C, 0x05, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x3C, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x02, 0x67, 0x58, 0x56, 0x57, 0x5B, 0x58, 0xEB, 0x1B, 0x47, 0x50, 0x48, 0x16, 0x23, 0x26, 0x2C, 0x15, 0x7E, 0x73, 0x52, 0x05, 0x06, 
        0x08, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x6F, 0x00, 0x15, 0x7B, 0x26, 0x26, 0x23, 0x1C, 0x67, 0x50, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 
        0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x3D, 0x21, 0x58, 0x56, 0x57, 0x5B, 0x58, 0xEB, 0x1B, 
        0x47, 0x50, 0x48, 0x16, 0x23, 0x26, 0x2C, 0x15, 0x7E, 0x73, 0x52, 0x05, 0x06, 0x08, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x6F, 0x00, 0x15, 0x7B, 0x26, 0x26, 0x23, 0x1C, 0x67, 0xC9, 0xA0, 0xA0, 0xA0, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 
        0x82, 0x3F, 0x17, 0x17, 0x68, 0x68, 0x46, 0x46, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 
        0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x24, 
        0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
  0x61, 0x39, 0x39, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0xF8, 0x51, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x17, 0x6B, 0x47, 0x48, 0x50, 0x47, 0x1D, 0x1B, 
        0x5B, 0x57, 0x1A, 0x18, 0x1C, 0x16, 0x23, 0x26, 0x2C, 0x78, 0x7E, 0x73, 0x52, 0x05, 0x0C, 0x6F, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0xA9, 0x92, 0x0A, 0x04, 0x07, 0x0E, 0xF7, 0x26, 0x74, 0x23, 0x16, 0x5B, 0x5B, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x10, 
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x6B, 0x47, 0x48, 0x50, 0x47, 0x1D, 0x1B, 0x5B, 0x57, 0x1A, 0x18, 0x1C, 0x16, 0x23, 0x26, 0x2C, 0x78, 0x7E, 0x73, 0x52, 0x05, 0x0C, 0x6F, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0xA9, 0x92, 0x0A, 0x04, 0x07, 0x0E, 0xF7, 
        0x26, 0x74, 0x23, 0x16, 0x5B, 0x5D, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x04, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x26, 0x6B, 0x47, 0x48, 0x50, 0x47, 0x1D, 0x1B, 0x5B, 0x57, 0x1A, 0x18, 0x1C, 0x16, 0x23, 0x26, 0x2C, 0x78, 0x7E, 0x73, 0x52, 0x05, 0x0C, 
        0x6F, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0xA9, 0x92, 0x0A, 0x04, 0x07, 0x0E, 0xF7, 0x26, 0x74, 0x23, 0x16, 0x5B, 0x5B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 
        0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x17, 0x6B, 0x47, 0x48, 0x50, 0x47, 0x1D, 0x1B, 0x5B, 0x57, 
        0x1A, 0x18, 0x1C, 0x16, 0x23, 0x26, 0x2C, 0x78, 0x7E, 0x73, 0x52, 0x05, 0x0C, 0x6F, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0xA9, 0x92, 0x0A, 0x04, 0x07, 0x0E, 0xF7, 0x26, 0x74, 0x23, 0x16, 0x5B, 0x53, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 
        0x82, 0x4B, 0x4B, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x17, 0x46, 0x46, 0x46, 0x46, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x36, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 
        0x38, 0x24, 0x38, 0x38, 0x38, 0x38, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x2B, 
        0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40,
  0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x51, 0x51, 0x51, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x47, 0x67, 0x41, 0x23, 0x41, 0x1C, 0x5D, 0x53, 0x58, 
        0x1B, 0x1D, 0x1A, 0x4C, 0x5E, 0xAB, 0x41, 0x74, 0x7B, 0x78, 0x72, 0x73, 0x52, 0x98, 0x0C, 0x6F, 0x92, 0xA9, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x52, 0x6E, 0x72, 0xF7, 0x26, 0x74, 0x75, 0xF0, 0x1A, 0x5B, 0x03, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x14, 0x1C, 0x67, 0x41, 0x23, 0x41, 0x1C, 0x5D, 0x53, 0x58, 0x1B, 0x1D, 0x1A, 0x4C, 0x5E, 0xAB, 0x41, 0x74, 0x7B, 0x78, 0x72, 0x73, 0x52, 0x98, 0x0C, 0x6F, 0x92, 0xA9, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x52, 0x6E, 0x72, 
        0xF7, 0x26, 0x74, 0x75, 0xF0, 0x1A, 0x1D, 0x09, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 
        0x3C, 0x05, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x48, 0x67, 0x41, 0x23, 0x41, 0x1C, 0x5D, 0x53, 0x58, 0x1B, 0x1D, 0x1A, 0x4C, 0x5E, 0xAB, 0x41, 0x74, 0x7B, 0x78, 0x72, 0x73, 0x52, 0x98, 0x0C, 
        0x6F, 0x92, 0xA9, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x52, 0x6E, 0x72, 0xF7, 0x26, 0x74, 0x75, 0xF0, 0x1A, 0x5D, 0x02, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x0E, 
        0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x33, 0x4F, 0x1A, 0x67, 0x41, 0x23, 0x41, 0x1C, 0x5D, 0x53, 0x58, 0x1B, 0x1D, 
        0x1A, 0x4C, 0x5E, 0xAB, 0x41, 0x74, 0x7B, 0x78, 0x72, 0x73, 0x52, 0x98, 0x0C, 0x6F, 0x92, 0xA9, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x52, 0x6E, 0x72, 0xF7, 0x26, 0x74, 0x75, 0xF0, 0x1A, 0x53, 0x71, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 
        0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x68, 0x46, 0x46, 0x4E, 0x4E, 0x25, 0x25, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x2B, 0x3A, 
        0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3A, 
        0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x28,
  0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x51, 0x51, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x54, 0x19, 0x2C, 0x2C, 0x26, 0x41, 0x19, 0x21, 0x5C, 0xEB, 
        0x54, 0x5B, 0x1D, 0x47, 0x50, 0x48, 0x41, 0x75, 0x7B, 0x78, 0x72, 0x6E, 0x52, 0x98, 0xFD, 0x1F, 0x32, 0x9A, 0x0D, 0x0D, 0xA9, 0x92, 0x08, 0x04, 0x07, 0x73, 0x7E, 0x78, 0xF7, 0x26, 0x26, 0x26, 0x74, 0x23, 0x18, 0x67, 0x03, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x14, 0x5D, 0x19, 0x2C, 0x2C, 0x26, 0x41, 0x19, 0x21, 0x5C, 0xEB, 0x54, 0x5B, 0x1D, 0x47, 0x50, 0x48, 0x41, 0x75, 0x7B, 0x78, 0x72, 0x6E, 0x52, 0x98, 0xFD, 0x1F, 0x32, 0x9A, 0x0D, 0x0D, 0xA9, 0x92, 0x08, 0x04, 0x07, 0x73, 0x7E, 0x78, 
        0xF7, 0x26, 0x26, 0x26, 0x74, 0x23, 0x18, 0x1E, 0x09, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x05, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x5D, 0x19, 0x2C, 0x2C, 0x26, 0x41, 0x19, 0x21, 0x5C, 0xEB, 0x54, 0x5B, 0x1D, 0x47, 0x50, 0x48, 0x41, 0x75, 0x7B, 0x78, 0x72, 0x6E, 0x52, 0x98, 0xFD, 
        0x1F, 0x32, 0x9A, 0x0D, 0x0D, 0xA9, 0x92, 0x08, 0x04, 0x07, 0x73, 0x7E, 0x78, 0xF7, 0x26, 0x26, 0x26, 0x74, 0x23, 0x18, 0x1E, 0x27, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 
        0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0xF8, 0x4F, 0x54, 0x19, 0x2C, 0x2C, 0x26, 0x41, 0x19, 0x21, 0x5C, 0xEB, 0x54, 0x5B, 
        0x1D, 0x47, 0x50, 0x48, 0x41, 0x75, 0x7B, 0x78, 0x72, 0x6E, 0x52, 0x98, 0xFD, 0x1F, 0x32, 0x9A, 0x0D, 0x0D, 0xA9, 0x92, 0x08, 0x04, 0x07, 0x73, 0x7E, 0x78, 0xF7, 0x26, 0x26, 0x26, 0x74, 0x23, 0x18, 0x21, 0x71, 0x76, 0x76, 0x60, 0x4B, 0x4B, 0x4B, 
        0x4B, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x68, 0x68, 0x46, 0x46, 0x46, 0x71, 0x71, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x3B, 0x3B, 0x3B, 0x2B, 0x3A, 0x3A, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 
        0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22,
  0x33, 0x33, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x03, 0x8E, 0x03, 0x03, 0x1A, 0x19, 0x7E, 0x0E, 0x72, 0x41, 0x21, 0x2F, 0x59, 0x55, 0x5C, 
        0x19, 0x1B, 0x1D, 0x1A, 0x18, 0x1C, 0x16, 0x23, 0x7B, 0x78, 0x72, 0x6E, 0x52, 0x98, 0xFD, 0x1F, 0x32, 0x9A, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x00, 0x0E, 0x15, 0x2C, 0x26, 0x23, 0x41, 0x75, 0x26, 0x75, 0x23, 0x18, 0x53, 0x09, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x1C, 0x19, 0x7E, 0x0E, 0x72, 0x41, 0x21, 0x2F, 0x59, 0x55, 0x5C, 0x19, 0x1B, 0x1D, 0x1A, 0x18, 0x1C, 0x16, 0x23, 0x7B, 0x78, 0x72, 0x6E, 0x52, 0x98, 0xFD, 0x1F, 0x32, 0x9A, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x00, 0x0E, 0x15, 0x2C, 
        0x26, 0x23, 0x41, 0x75, 0x26, 0x75, 0x23, 0x18, 0x19, 0x3C, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x04, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 
        0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x48, 0x19, 0x7E, 0x0E, 0x72, 0x41, 0x21, 0x2F, 0x59, 0x55, 0x5C, 0x19, 0x1B, 0x1D, 0x1A, 0x18, 0x1C, 0x16, 0x23, 0x7B, 0x78, 0x72, 0x6E, 0x52, 0x98, 0xFD, 
        0x1F, 0x32, 0x9A, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x00, 0x0E, 0x15, 0x2C, 0x26, 0x23, 0x41, 0x75, 0x26, 0x75, 0x23, 0x18, 0x19, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x4C, 0x19, 0x7E, 0x0E, 0x72, 0x41, 0x21, 0x2F, 0x59, 0x55, 0x5C, 0x19, 0x1B, 
        0x1D, 0x1A, 0x18, 0x1C, 0x16, 0x23, 0x7B, 0x78, 0x72, 0x6E, 0x52, 0x98, 0xFD, 0x1F, 0x32, 0x9A, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x00, 0x0E, 0x15, 0x2C, 0x26, 0x23, 0x41, 0x75, 0x26, 0x75, 0x23, 0x18, 0x67, 0x4B, 0x4B, 0x3F, 0x17, 0x17, 0x17, 
        0x68, 0x46, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x89, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 
        0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 
        0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38,
  0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x61, 0x61, 0x39, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x71, 0x5C, 0x00, 0x07, 0x00, 0xF0, 0x01, 0x65, 0x62, 0x2F, 0x21, 0x1E, 
        0x53, 0x58, 0x5B, 0x57, 0x47, 0x50, 0x48, 0x23, 0x26, 0x2C, 0x15, 0x6E, 0x00, 0x98, 0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x6F, 0x06, 0x07, 0x73, 0x72, 0x78, 0x26, 0x23, 0x16, 0x1C, 0x50, 0x23, 0x74, 0x75, 0x23, 0x4C, 0x5B, 0x09, 0x09, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x14, 0x07, 0x07, 0x07, 
        0x07, 0x23, 0x5C, 0x00, 0x07, 0x00, 0xF0, 0x01, 0x65, 0x62, 0x2F, 0x21, 0x1E, 0x53, 0x58, 0x5B, 0x57, 0x47, 0x50, 0x48, 0x23, 0x26, 0x2C, 0x15, 0x6E, 0x00, 0x98, 0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x6F, 0x06, 0x07, 0x73, 0x72, 0x78, 0x26, 
        0x23, 0x16, 0x1C, 0x50, 0x23, 0x74, 0x75, 0x23, 0x4C, 0x5D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x74, 0x5C, 0x00, 0x07, 0x00, 0xF0, 0x01, 0x65, 0x62, 0x2F, 0x21, 0x1E, 0x53, 0x58, 0x5B, 0x57, 0x47, 0x50, 0x48, 0x23, 0x26, 0x2C, 0x15, 0x6E, 0x00, 0x98, 0x0A, 
        0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x6F, 0x06, 0x07, 0x73, 0x72, 0x78, 0x26, 0x23, 0x16, 0x1C, 0x50, 0x23, 0x74, 0x75, 0x23, 0x4C, 0x5B, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 
        0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x17, 0x5C, 0x00, 0x07, 0x00, 0xF0, 0x01, 0x65, 0x62, 0x2F, 0x21, 0x1E, 0x53, 0x58, 
        0x5B, 0x57, 0x47, 0x50, 0x48, 0x23, 0x26, 0x2C, 0x15, 0x6E, 0x00, 0x98, 0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x6F, 0x06, 0x07, 0x73, 0x72, 0x78, 0x26, 0x23, 0x16, 0x1C, 0x50, 0x23, 0x74, 0x75, 0x23, 0x4C, 0x19, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 
        0x3D, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x60, 0x60, 0x76, 0x4B, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x68, 0x68, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x36, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 
        0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x51, 0x15, 0x15, 0x15, 0x15, 0x15, 0x7C, 0x02, 0x02, 0x0F, 0x59, 0x07, 0x0A, 0x04, 0x26, 0x2A, 0x2A, 0x2A, 0x65, 0x62, 0x6B, 0x55, 
        0x1E, 0x19, 0x1B, 0x1D, 0x1A, 0x18, 0x48, 0x41, 0x74, 0x2C, 0x15, 0x0E, 0x00, 0x98, 0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x9A, 0x92, 0x0A, 0x98, 0x00, 0x0E, 0x15, 0x7B, 0x75, 0x41, 0x48, 0x50, 0x4C, 0x56, 0x41, 0x26, 0x75, 0x23, 0x57, 0x1A, 0x09, 0x09, 
        0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x2C, 0x59, 0x07, 0x0A, 0x04, 0x26, 0x2A, 0x2A, 0x2A, 0x65, 0x62, 0x6B, 0x55, 0x1E, 0x19, 0x1B, 0x1D, 0x1A, 0x18, 0x48, 0x41, 0x74, 0x2C, 0x15, 0x0E, 0x00, 0x98, 0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x9A, 0x92, 0x0A, 0x98, 0x00, 0x0E, 0x15, 0x7B, 0x75, 
        0x41, 0x48, 0x50, 0x4C, 0x56, 0x41, 0x26, 0x75, 0x23, 0x57, 0x18, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x15, 0x59, 0x07, 0x0A, 0x04, 0x26, 0x2A, 0x2A, 0x2A, 0x65, 0x62, 0x6B, 0x55, 0x1E, 0x19, 0x1B, 0x1D, 0x1A, 0x18, 0x48, 0x41, 0x74, 0x2C, 0x15, 0x0E, 0x00, 0x98, 0x0A, 
        0x1F, 0x32, 0x0D, 0x0D, 0x9A, 0x92, 0x0A, 0x98, 0x00, 0x0E, 0x15, 0x7B, 0x75, 0x41, 0x48, 0x50, 0x4C, 0x56, 0x41, 0x26, 0x75, 0x23, 0x57, 0x18, 0x07, 0x07, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 
        0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x27, 0x6C, 0x59, 0x07, 0x0A, 0x04, 0x26, 0x2A, 0x2A, 0x2A, 0x65, 0x62, 0x6B, 0x55, 0x1E, 0x19, 
        0x1B, 0x1D, 0x1A, 0x18, 0x48, 0x41, 0x74, 0x2C, 0x15, 0x0E, 0x00, 0x98, 0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x9A, 0x92, 0x0A, 0x98, 0x00, 0x0E, 0x15, 0x7B, 0x75, 0x41, 0x48, 0x50, 0x4C, 0x56, 0x41, 0x26, 0x75, 0x23, 0x57, 0x5D, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x60, 0x76, 0x4B, 0x4B, 0x3F, 0x17, 0x17, 0x17, 0x68, 0x2A, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 
        0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 
        0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x77, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x42, 0x42,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0xF8, 0xF8, 0xF8, 0x55, 0x0E, 0x32, 0x1F, 0x72, 0x20, 0x20, 0x70, 0x70, 0x6D, 0x01, 0x2F, 0x59, 
        0x55, 0x5C, 0x58, 0x5B, 0x56, 0x47, 0x1C, 0x16, 0x75, 0x7B, 0x15, 0x0E, 0x00, 0xDD, 0x0A, 0x1F, 0xA9, 0x0D, 0x0D, 0x32, 0x1F, 0x06, 0x07, 0x73, 0x15, 0x2C, 0x74, 0xF0, 0x48, 0x50, 0x47, 0x56, 0x5D, 0x5B, 0x41, 0x26, 0x75, 0xF0, 0x19, 0x0B, 0x09, 
        0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 
        0x67, 0x0E, 0x32, 0x1F, 0x72, 0x20, 0x20, 0x70, 0x70, 0x6D, 0x01, 0x2F, 0x59, 0x55, 0x5C, 0x58, 0x5B, 0x56, 0x47, 0x1C, 0x16, 0x75, 0x7B, 0x15, 0x0E, 0x00, 0xDD, 0x0A, 0x1F, 0xA9, 0x0D, 0x0D, 0x32, 0x1F, 0x06, 0x07, 0x73, 0x15, 0x2C, 0x74, 0xF0, 
        0x48, 0x50, 0x47, 0x56, 0x5D, 0x5B, 0x41, 0x26, 0x75, 0xF0, 0x19, 0x15, 0x13, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x67, 0x0E, 0x32, 0x1F, 0x72, 0x20, 0x20, 0x70, 0x70, 0x6D, 0x01, 0x2F, 0x59, 0x55, 0x5C, 0x58, 0x5B, 0x56, 0x47, 0x1C, 0x16, 0x75, 0x7B, 0x15, 0x0E, 0x00, 0xDD, 0x0A, 
        0x1F, 0xA9, 0x0D, 0x0D, 0x32, 0x1F, 0x06, 0x07, 0x73, 0x15, 0x2C, 0x74, 0xF0, 0x48, 0x50, 0x47, 0x56, 0x5D, 0x5B, 0x41, 0x26, 0x75, 0xF0, 0x19, 0x2C, 0x00, 0x00, 0x52, 0x14, 0x00, 0x14, 0x14, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x55, 0x0E, 0x32, 0x1F, 0x72, 0x20, 0x20, 0x70, 0x70, 0x6D, 0x01, 0x2F, 0x59, 0x55, 0x5C, 
        0x58, 0x5B, 0x56, 0x47, 0x1C, 0x16, 0x75, 0x7B, 0x15, 0x0E, 0x00, 0xDD, 0x0A, 0x1F, 0xA9, 0x0D, 0x0D, 0x32, 0x1F, 0x06, 0x07, 0x73, 0x15, 0x2C, 0x74, 0xF0, 0x48, 0x50, 0x47, 0x56, 0x5D, 0x5B, 0x41, 0x26, 0x75, 0xF0, 0x19, 0x17, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x76, 0x60, 0x4B, 0x2A, 0x30, 0xDF, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0xDF, 0x30, 0x5A, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x61, 0x61, 0x61, 0x39, 0x61, 0x61, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x39, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x03, 0x4F, 0x57, 0xAB, 0x0D, 0x9A, 0x0C, 0x2A, 0x63, 0x63, 0x20, 0x20, 0x2A, 0x6D, 0x69, 0x2F, 
        0x21, 0x1E, 0x19, 0x1B, 0x1D, 0x1A, 0x50, 0xAB, 0x23, 0x7B, 0x78, 0x0E, 0x00, 0xDD, 0x0A, 0x92, 0xA9, 0x0D, 0x0D, 0x92, 0x0A, 0xDD, 0x12, 0x0E, 0x78, 0x26, 0x23, 0xAB, 0x50, 0x4C, 0x56, 0x5B, 0x1B, 0x19, 0x58, 0x75, 0x26, 0x75, 0x16, 0x5C, 0x10, 
        0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x18, 
        0xAB, 0x0D, 0x9A, 0x0C, 0x2A, 0x63, 0x63, 0x20, 0x20, 0x2A, 0x6D, 0x69, 0x2F, 0x21, 0x1E, 0x19, 0x1B, 0x1D, 0x1A, 0x50, 0xAB, 0x23, 0x7B, 0x78, 0x0E, 0x00, 0xDD, 0x0A, 0x92, 0xA9, 0x0D, 0x0D, 0x92, 0x0A, 0xDD, 0x12, 0x0E, 0x78, 0x26, 0x23, 0xAB, 
        0x50, 0x4C, 0x56, 0x5B, 0x1B, 0x19, 0x58, 0x75, 0x26, 0x75, 0x16, 0x5C, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x04, 0x04, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x04, 0x3C, 0x04, 0x04, 0x3C, 0x3C, 0x13, 0x3C, 0x3C, 0x04, 0x13, 0x3C, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x50, 0xAB, 0x0D, 0x9A, 0x0C, 0x2A, 0x63, 0x63, 0x20, 0x20, 0x2A, 0x6D, 0x69, 0x2F, 0x21, 0x1E, 0x19, 0x1B, 0x1D, 0x1A, 0x50, 0xAB, 0x23, 0x7B, 0x78, 0x0E, 0x00, 0xDD, 0x0A, 
        0x92, 0xA9, 0x0D, 0x0D, 0x92, 0x0A, 0xDD, 0x12, 0x0E, 0x78, 0x26, 0x23, 0xAB, 0x50, 0x4C, 0x56, 0x5B, 0x1B, 0x19, 0x58, 0x75, 0x26, 0x75, 0x16, 0x5C, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x56, 0xAB, 0x0D, 0x9A, 0x0C, 0x2A, 0x63, 0x63, 0x20, 0x20, 0x2A, 0x6D, 0x69, 0x2F, 0x21, 0x1E, 
        0x19, 0x1B, 0x1D, 0x1A, 0x50, 0xAB, 0x23, 0x7B, 0x78, 0x0E, 0x00, 0xDD, 0x0A, 0x92, 0xA9, 0x0D, 0x0D, 0x92, 0x0A, 0xDD, 0x12, 0x0E, 0x78, 0x26, 0x23, 0xAB, 0x50, 0x4C, 0x56, 0x5B, 0x1B, 0x19, 0x58, 0x75, 0x26, 0x75, 0x16, 0x1E, 0xA0, 0xA0, 0xA0, 
        0xA0, 0xA0, 0x8D, 0x3D, 0x3D, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x3F, 0x3F, 0x17, 0x17, 0x68, 0x46, 0x71, 0x4E, 0x4E, 0x30, 0xDF, 0x92, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x92, 0xDF, 0x30, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x61, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x79, 0x1E, 0x0A, 0x0D, 0x0D, 0xEB, 0x5A, 0x5A, 0x63, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x69, 
        0x2F, 0x55, 0x5C, 0x58, 0x5B, 0x56, 0x4C, 0x1C, 0xF0, 0x26, 0x78, 0x7E, 0x00, 0xDD, 0x08, 0x92, 0x0D, 0x0D, 0xA9, 0x1F, 0x06, 0x07, 0x6E, 0x15, 0x7B, 0x23, 0xAB, 0x5E, 0x4C, 0x56, 0x5D, 0x54, 0x19, 0x5C, 0x55, 0x54, 0x26, 0x26, 0x75, 0x18, 0x47, 
        0x12, 0x12, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x15, 0x1E, 
        0x0A, 0x0D, 0x0D, 0xEB, 0x5A, 0x5A, 0x63, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x69, 0x2F, 0x55, 0x5C, 0x58, 0x5B, 0x56, 0x4C, 0x1C, 0xF0, 0x26, 0x78, 0x7E, 0x00, 0xDD, 0x08, 0x92, 0x0D, 0x0D, 0xA9, 0x1F, 0x06, 0x07, 0x6E, 0x15, 0x7B, 0x23, 0xAB, 0x5E, 
        0x4C, 0x56, 0x5D, 0x54, 0x19, 0x5C, 0x55, 0x54, 0x26, 0x26, 0x75, 0x18, 0x18, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x15, 0x1E, 0x0A, 0x0D, 0x0D, 0xEB, 0x5A, 0x5A, 0x63, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x69, 0x2F, 0x55, 0x5C, 0x58, 0x5B, 0x56, 0x4C, 0x1C, 0xF0, 0x26, 0x78, 0x7E, 0x00, 0xDD, 0x08, 
        0x92, 0x0D, 0x0D, 0xA9, 0x1F, 0x06, 0x07, 0x6E, 0x15, 0x7B, 0x23, 0xAB, 0x5E, 0x4C, 0x56, 0x5D, 0x54, 0x19, 0x5C, 0x55, 0x54, 0x26, 0x26, 0x75, 0x18, 0x18, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x0B, 0x1E, 0x0A, 0x0D, 0x0D, 0xEB, 0x5A, 0x5A, 0x63, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x69, 0x2F, 0x55, 
        0x5C, 0x58, 0x5B, 0x56, 0x4C, 0x1C, 0xF0, 0x26, 0x78, 0x7E, 0x00, 0xDD, 0x08, 0x92, 0x0D, 0x0D, 0xA9, 0x1F, 0x06, 0x07, 0x6E, 0x15, 0x7B, 0x23, 0xAB, 0x5E, 0x4C, 0x56, 0x5D, 0x54, 0x19, 0x5C, 0x55, 0x54, 0x26, 0x26, 0x75, 0x18, 0x1B, 0xA0, 0xA0, 
        0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x4B, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x68, 0x30, 0x2A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42,
  0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x67, 0x74, 0x06, 0x92, 0x26, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x20, 0x70, 0x2A, 0x65, 
        0x69, 0x59, 0x55, 0x53, 0x1B, 0x1D, 0x47, 0x5E, 0x16, 0x74, 0x78, 0x7E, 0x00, 0xDD, 0x08, 0x32, 0x0D, 0x0D, 0x32, 0x6F, 0xDD, 0x12, 0x72, 0x2C, 0x74, 0x16, 0x1C, 0x4C, 0x56, 0x5D, 0x54, 0x53, 0x1E, 0x21, 0x59, 0x59, 0x18, 0x26, 0x26, 0x75, 0xEB, 
        0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x5C, 0x74, 
        0x06, 0x92, 0x26, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x69, 0x59, 0x55, 0x53, 0x1B, 0x1D, 0x47, 0x5E, 0x16, 0x74, 0x78, 0x7E, 0x00, 0xDD, 0x08, 0x32, 0x0D, 0x0D, 0x32, 0x6F, 0xDD, 0x12, 0x72, 0x2C, 0x74, 0x16, 0x1C, 0x4C, 
        0x56, 0x5D, 0x54, 0x53, 0x1E, 0x21, 0x59, 0x59, 0x18, 0x26, 0x26, 0x75, 0xEB, 0x27, 0x05, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x13, 0x13, 0x13, 
        0x13, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x53, 0x74, 0x06, 0x92, 0x26, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x69, 0x59, 0x55, 0x53, 0x1B, 0x1D, 0x47, 0x5E, 0x16, 0x74, 0x78, 0x7E, 0x00, 0xDD, 0x08, 
        0x32, 0x0D, 0x0D, 0x32, 0x6F, 0xDD, 0x12, 0x72, 0x2C, 0x74, 0x16, 0x1C, 0x4C, 0x56, 0x5D, 0x54, 0x53, 0x1E, 0x21, 0x59, 0x59, 0x18, 0x26, 0x26, 0x75, 0xEB, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x1E, 0x74, 0x06, 0x92, 0x26, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x69, 0x59, 
        0x55, 0x53, 0x1B, 0x1D, 0x47, 0x5E, 0x16, 0x74, 0x78, 0x7E, 0x00, 0xDD, 0x08, 0x32, 0x0D, 0x0D, 0x32, 0x6F, 0xDD, 0x12, 0x72, 0x2C, 0x74, 0x16, 0x1C, 0x4C, 0x56, 0x5D, 0x54, 0x53, 0x1E, 0x21, 0x59, 0x59, 0x18, 0x26, 0x26, 0x75, 0xEB, 0x11, 0x0F, 
        0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0x79, 0x79, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x76, 0x60, 0x60, 0x4B, 0x3F, 0x17, 0x17, 0x30, 0x2A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x1A, 0x19, 0x72, 0x00, 0x00, 0x69, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x20, 0x70, 0x2A, 
        0x65, 0x62, 0x59, 0x1E, 0x19, 0x5B, 0x56, 0x18, 0xAB, 0x75, 0x2C, 0x72, 0x00, 0xDD, 0x6F, 0x32, 0x0D, 0x0D, 0x92, 0x0C, 0x52, 0x0E, 0x78, 0x26, 0x41, 0x1C, 0x4C, 0x56, 0x5B, 0x58, 0x53, 0x1E, 0x21, 0x59, 0x59, 0x21, 0x1E, 0x23, 0x7B, 0x26, 0x16, 
        0x5C, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x1C, 0x19, 0x72, 
        0x00, 0x00, 0x69, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x62, 0x59, 0x1E, 0x19, 0x5B, 0x56, 0x18, 0xAB, 0x75, 0x2C, 0x72, 0x00, 0xDD, 0x6F, 0x32, 0x0D, 0x0D, 0x92, 0x0C, 0x52, 0x0E, 0x78, 0x26, 0x41, 0x1C, 0x4C, 0x56, 
        0x5B, 0x58, 0x53, 0x1E, 0x21, 0x59, 0x59, 0x21, 0x1E, 0x23, 0x7B, 0x26, 0x16, 0x53, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 0x13, 0x13, 0x3C, 0x13, 0x13, 
        0x04, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x3F, 0x19, 0x72, 0x00, 0x00, 0x69, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x62, 0x59, 0x1E, 0x19, 0x5B, 0x56, 0x18, 0xAB, 0x75, 0x2C, 0x72, 0x00, 0xDD, 0x6F, 
        0x32, 0x0D, 0x0D, 0x92, 0x0C, 0x52, 0x0E, 0x78, 0x26, 0x41, 0x1C, 0x4C, 0x56, 0x5B, 0x58, 0x53, 0x1E, 0x21, 0x59, 0x59, 0x21, 0x1E, 0x23, 0x7B, 0x26, 0x16, 0x53, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x07, 0x07, 
        0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x4C, 0x19, 0x72, 0x00, 0x00, 0x69, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x62, 
        0x59, 0x1E, 0x19, 0x5B, 0x56, 0x18, 0xAB, 0x75, 0x2C, 0x72, 0x00, 0xDD, 0x6F, 0x32, 0x0D, 0x0D, 0x92, 0x0C, 0x52, 0x0E, 0x78, 0x26, 0x41, 0x1C, 0x4C, 0x56, 0x5B, 0x58, 0x53, 0x1E, 0x21, 0x59, 0x59, 0x21, 0x1E, 0x23, 0x7B, 0x26, 0x16, 0x67, 0x35, 
        0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x60, 0x30, 0x2A, 0x0D, 0x0D, 0xD8, 0x86, 0x83, 0x0D, 0x0D, 0x0D, 0x0D, 0x83, 0x86, 0x83, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x51, 0x51, 0x7C, 0x02, 0x02, 0x02, 0x21, 0x18, 0x7B, 0x72, 0x1D, 0x01, 0x65, 0x6D, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x63, 0x5A, 0x70, 
        0x2A, 0x65, 0x2F, 0x21, 0x5C, 0x54, 0x1D, 0x4C, 0x48, 0x23, 0xF7, 0x72, 0x12, 0xDD, 0x6F, 0x32, 0x0D, 0xA9, 0x6F, 0xDD, 0x12, 0x15, 0x7B, 0xF0, 0x1C, 0x18, 0x56, 0x5B, 0x58, 0x53, 0x67, 0x59, 0x59, 0x21, 0x55, 0x67, 0x67, 0x56, 0xF7, 0x7B, 0x74, 
        0x54, 0x0B, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x18, 0x7B, 
        0x72, 0x1D, 0x01, 0x65, 0x6D, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x63, 0x5A, 0x70, 0x2A, 0x65, 0x2F, 0x21, 0x5C, 0x54, 0x1D, 0x4C, 0x48, 0x23, 0xF7, 0x72, 0x12, 0xDD, 0x6F, 0x32, 0x0D, 0xA9, 0x6F, 0xDD, 0x12, 0x15, 0x7B, 0xF0, 0x1C, 0x18, 0x56, 0x5B, 
        0x58, 0x53, 0x67, 0x59, 0x59, 0x21, 0x55, 0x67, 0x67, 0x56, 0xF7, 0x7B, 0x74, 0x54, 0x02, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x04, 0x13, 0x3C, 0x3C, 0x55, 0x18, 0x7B, 0x72, 0x1D, 0x01, 0x65, 0x6D, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x63, 0x5A, 0x70, 0x2A, 0x65, 0x2F, 0x21, 0x5C, 0x54, 0x1D, 0x4C, 0x48, 0x23, 0xF7, 0x72, 0x12, 0xDD, 0x6F, 
        0x32, 0x0D, 0xA9, 0x6F, 0xDD, 0x12, 0x15, 0x7B, 0xF0, 0x1C, 0x18, 0x56, 0x5B, 0x58, 0x53, 0x67, 0x59, 0x59, 0x21, 0x55, 0x67, 0x67, 0x56, 0xF7, 0x7B, 0x74, 0x54, 0x33, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x18, 0x7B, 0x72, 0x1D, 0x01, 0x65, 0x6D, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x63, 0x5A, 0x70, 0x2A, 0x65, 
        0x2F, 0x21, 0x5C, 0x54, 0x1D, 0x4C, 0x48, 0x23, 0xF7, 0x72, 0x12, 0xDD, 0x6F, 0x32, 0x0D, 0xA9, 0x6F, 0xDD, 0x12, 0x15, 0x7B, 0xF0, 0x1C, 0x18, 0x56, 0x5B, 0x58, 0x53, 0x67, 0x59, 0x59, 0x21, 0x55, 0x67, 0x67, 0x56, 0xF7, 0x7B, 0x74, 0x54, 0x71, 
        0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x30, 0x2A, 0x0D, 0x0D, 0x44, 0x44, 0x91, 0x7F, 0x0D, 0x0D, 0x0D, 0x45, 0x44, 0x44, 0xA7, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x42, 0x42, 0x66, 0x66, 0x66, 0x66, 0x49, 0x49, 0x49, 0x49,
  0x61, 0x61, 0x61, 0x39, 0x39, 0x61, 0x39, 0x39, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x3D, 0x67, 0x18, 0x41, 0x41, 0x2F, 0x2F, 0x01, 0x01, 0x65, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x5A, 
        0x20, 0x2A, 0x01, 0x2F, 0x55, 0x19, 0x5B, 0x1A, 0x50, 0x41, 0x7B, 0x15, 0x12, 0x04, 0x1F, 0xA9, 0x0D, 0x32, 0x0A, 0x52, 0x0E, 0x2C, 0x23, 0x48, 0x18, 0x56, 0x5B, 0x58, 0x1E, 0x21, 0x6B, 0x59, 0x21, 0x67, 0x1E, 0x5C, 0x53, 0x53, 0x74, 0x7B, 0x26, 
        0x16, 0x47, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x67, 0x18, 0x41, 
        0x41, 0x2F, 0x2F, 0x01, 0x01, 0x65, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x5A, 0x20, 0x2A, 0x01, 0x2F, 0x55, 0x19, 0x5B, 0x1A, 0x50, 0x41, 0x7B, 0x15, 0x12, 0x04, 0x1F, 0xA9, 0x0D, 0x32, 0x0A, 0x52, 0x0E, 0x2C, 0x23, 0x48, 0x18, 0x56, 0x5B, 0x58, 
        0x1E, 0x21, 0x6B, 0x59, 0x21, 0x67, 0x1E, 0x5C, 0x53, 0x53, 0x74, 0x7B, 0x26, 0x16, 0x18, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x7E, 0x67, 0x18, 0x41, 0x41, 0x2F, 0x2F, 0x01, 0x01, 0x65, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x5A, 0x20, 0x2A, 0x01, 0x2F, 0x55, 0x19, 0x5B, 0x1A, 0x50, 0x41, 0x7B, 0x15, 0x12, 0x04, 0x1F, 
        0xA9, 0x0D, 0x32, 0x0A, 0x52, 0x0E, 0x2C, 0x23, 0x48, 0x18, 0x56, 0x5B, 0x58, 0x1E, 0x21, 0x6B, 0x59, 0x21, 0x67, 0x1E, 0x5C, 0x53, 0x53, 0x74, 0x7B, 0x26, 0x16, 0x4C, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 
        0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x52, 0x8E, 0x67, 0x18, 0x41, 0x41, 0x2F, 0x2F, 0x01, 0x01, 0x65, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x5A, 0x20, 0x2A, 
        0x01, 0x2F, 0x55, 0x19, 0x5B, 0x1A, 0x50, 0x41, 0x7B, 0x15, 0x12, 0x04, 0x1F, 0xA9, 0x0D, 0x32, 0x0A, 0x52, 0x0E, 0x2C, 0x23, 0x48, 0x18, 0x56, 0x5B, 0x58, 0x1E, 0x21, 0x6B, 0x59, 0x21, 0x67, 0x1E, 0x5C, 0x53, 0x53, 0x74, 0x7B, 0x26, 0x16, 0x5B, 
        0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x11, 0x11, 0x76, 0x76, 0x76, 0x4B, 0x3F, 0x3F, 0x17, 0x68, 0x68, 0x30, 0x2A, 0x0D, 0x0D, 0x96, 0x44, 0x44, 0x9C, 0x0D, 0x0D, 0x0D, 0xD7, 0x44, 0x44, 0x91, 0x7F, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x67, 0x5C, 0x1D, 0x18, 0x54, 0x21, 0x59, 0x2F, 0x2F, 0x69, 0x01, 0x6D, 0x2A, 0x70, 0x20, 0x5A, 0x63, 
        0x5A, 0x70, 0x2A, 0x69, 0x59, 0x1E, 0x58, 0x1D, 0x18, 0x16, 0x26, 0x15, 0x12, 0x04, 0x1F, 0x0D, 0x0D, 0x1F, 0xDD, 0x73, 0x78, 0x75, 0xAB, 0x18, 0x56, 0x1B, 0x19, 0x1E, 0x21, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x5C, 0xEB, 0x19, 0x58, 0x4C, 0x2C, 0x7B, 
        0x7B, 0x53, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x00, 0x5C, 0x5C, 0x1D, 0x18, 
        0x54, 0x21, 0x59, 0x2F, 0x2F, 0x69, 0x01, 0x6D, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x5A, 0x70, 0x2A, 0x69, 0x59, 0x1E, 0x58, 0x1D, 0x18, 0x16, 0x26, 0x15, 0x12, 0x04, 0x1F, 0x0D, 0x0D, 0x1F, 0xDD, 0x73, 0x78, 0x75, 0xAB, 0x18, 0x56, 0x1B, 0x19, 0x1E, 
        0x21, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x5C, 0xEB, 0x19, 0x58, 0x4C, 0x2C, 0x7B, 0x7B, 0x53, 0x0E, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x53, 0x5C, 0x1D, 0x18, 0x54, 0x21, 0x59, 0x2F, 0x2F, 0x69, 0x01, 0x6D, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x5A, 0x70, 0x2A, 0x69, 0x59, 0x1E, 0x58, 0x1D, 0x18, 0x16, 0x26, 0x15, 0x12, 0x04, 0x1F, 
        0x0D, 0x0D, 0x1F, 0xDD, 0x73, 0x78, 0x75, 0xAB, 0x18, 0x56, 0x1B, 0x19, 0x1E, 0x21, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x5C, 0xEB, 0x19, 0x58, 0x4C, 0x2C, 0x7B, 0x7B, 0x53, 0x0E, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5C, 0x5C, 0x1D, 0x18, 0x54, 0x21, 0x59, 0x2F, 0x2F, 0x69, 0x01, 0x6D, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x5A, 0x70, 
        0x2A, 0x69, 0x59, 0x1E, 0x58, 0x1D, 0x18, 0x16, 0x26, 0x15, 0x12, 0x04, 0x1F, 0x0D, 0x0D, 0x1F, 0xDD, 0x73, 0x78, 0x75, 0xAB, 0x18, 0x56, 0x1B, 0x19, 0x1E, 0x21, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x5C, 0xEB, 0x19, 0x58, 0x4C, 0x2C, 0x7B, 0x7B, 0x53, 
        0x11, 0x37, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x11, 0x11, 0x76, 0x76, 0x60, 0x30, 0x2A, 0x0D, 0x0D, 0x7F, 0x95, 0x44, 0x44, 0x9D, 0x0D, 0x0D, 0x0D, 0x91, 0x44, 0x44, 0x9C, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x31, 0x31, 0x31, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x6C, 0x6B, 0x59, 0x19, 0x5D, 0x1E, 0x67, 0x55, 0x21, 0x59, 0x2F, 0x62, 0x69, 0x65, 0x2A, 0x70, 0x20, 0x5A, 
        0x63, 0x5A, 0x20, 0x2A, 0x69, 0x21, 0x53, 0x1B, 0x1A, 0x48, 0x75, 0x15, 0x12, 0x04, 0x92, 0x0D, 0x9A, 0x08, 0x52, 0x72, 0x26, 0x16, 0x18, 0x56, 0x1B, 0x19, 0x67, 0x59, 0x59, 0x55, 0x67, 0x1E, 0x53, 0x53, 0x19, 0x58, 0x54, 0x54, 0x5B, 0x2C, 0x2C, 
        0x7B, 0x50, 0x5E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x6B, 0x59, 0x19, 0x5D, 
        0x1E, 0x67, 0x55, 0x21, 0x59, 0x2F, 0x62, 0x69, 0x65, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x5A, 0x20, 0x2A, 0x69, 0x21, 0x53, 0x1B, 0x1A, 0x48, 0x75, 0x15, 0x12, 0x04, 0x92, 0x0D, 0x9A, 0x08, 0x52, 0x72, 0x26, 0x16, 0x18, 0x56, 0x1B, 0x19, 0x67, 0x59, 
        0x59, 0x55, 0x67, 0x1E, 0x53, 0x53, 0x19, 0x58, 0x54, 0x54, 0x5B, 0x2C, 0x2C, 0x7B, 0x50, 0x48, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x73, 0x6B, 0x59, 0x19, 0x5D, 0x1E, 0x67, 0x55, 0x21, 0x59, 0x2F, 0x62, 0x69, 0x65, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x5A, 0x20, 0x2A, 0x69, 0x21, 0x53, 0x1B, 0x1A, 0x48, 0x75, 0x15, 0x12, 0x04, 0x92, 
        0x0D, 0x9A, 0x08, 0x52, 0x72, 0x26, 0x16, 0x18, 0x56, 0x1B, 0x19, 0x67, 0x59, 0x59, 0x55, 0x67, 0x1E, 0x53, 0x53, 0x19, 0x58, 0x54, 0x54, 0x5B, 0x2C, 0x2C, 0x7B, 0x50, 0x1C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x6B, 0x59, 0x19, 0x5D, 0x1E, 0x67, 0x55, 0x21, 0x59, 0x2F, 0x62, 0x69, 0x65, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x5A, 
        0x20, 0x2A, 0x69, 0x21, 0x53, 0x1B, 0x1A, 0x48, 0x75, 0x15, 0x12, 0x04, 0x92, 0x0D, 0x9A, 0x08, 0x52, 0x72, 0x26, 0x16, 0x18, 0x56, 0x1B, 0x19, 0x67, 0x59, 0x59, 0x55, 0x67, 0x1E, 0x53, 0x53, 0x19, 0x58, 0x54, 0x54, 0x5B, 0x2C, 0x2C, 0x7B, 0x50, 
        0x57, 0x6C, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x76, 0x30, 0x2A, 0x0D, 0x0D, 0x0D, 0x83, 0x44, 0x44, 0x44, 0x83, 0x0D, 0x0D, 0x7F, 0x44, 0x44, 0x44, 0x9D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22,
  0x4F, 0x33, 0x33, 0xF8, 0xF8, 0x33, 0x15, 0x15, 0xF8, 0x7C, 0x7C, 0x7C, 0x15, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x4C, 0x6B, 0x65, 0x21, 0x53, 0xEB, 0x53, 0x1E, 0x67, 0x55, 0x21, 0x59, 0x2F, 0x69, 0x01, 0x65, 0x2A, 0x70, 
        0x20, 0x63, 0x5A, 0x20, 0x6D, 0x62, 0x55, 0x58, 0x57, 0x50, 0x41, 0x2C, 0x73, 0x04, 0x92, 0x0D, 0x32, 0x04, 0x0E, 0xF7, 0x41, 0x50, 0x56, 0x1B, 0x53, 0x55, 0x59, 0x21, 0x55, 0x1E, 0x5C, 0xEB, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5D, 0x41, 0x78, 
        0x2C, 0xD4, 0x53, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5E, 0x6B, 0x65, 0x21, 0x53, 
        0xEB, 0x53, 0x1E, 0x67, 0x55, 0x21, 0x59, 0x2F, 0x69, 0x01, 0x65, 0x2A, 0x70, 0x20, 0x63, 0x5A, 0x20, 0x6D, 0x62, 0x55, 0x58, 0x57, 0x50, 0x41, 0x2C, 0x73, 0x04, 0x92, 0x0D, 0x32, 0x04, 0x0E, 0xF7, 0x41, 0x50, 0x56, 0x1B, 0x53, 0x55, 0x59, 0x21, 
        0x55, 0x1E, 0x5C, 0xEB, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5D, 0x41, 0x78, 0x2C, 0xD4, 0x19, 0x3C, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 
        0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x3F, 0x6B, 0x65, 0x21, 0x53, 0xEB, 0x53, 0x1E, 0x67, 0x55, 0x21, 0x59, 0x2F, 0x69, 0x01, 0x65, 0x2A, 0x70, 0x20, 0x63, 0x5A, 0x20, 0x6D, 0x62, 0x55, 0x58, 0x57, 0x50, 0x41, 0x2C, 0x73, 0x04, 0x92, 
        0x0D, 0x32, 0x04, 0x0E, 0xF7, 0x41, 0x50, 0x56, 0x1B, 0x53, 0x55, 0x59, 0x21, 0x55, 0x1E, 0x5C, 0xEB, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5D, 0x41, 0x78, 0x2C, 0xD4, 0x19, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5E, 0x6B, 0x65, 0x21, 0x53, 0xEB, 0x53, 0x1E, 0x67, 0x55, 0x21, 0x59, 0x2F, 0x69, 0x01, 0x65, 0x2A, 0x70, 0x20, 0x63, 
        0x5A, 0x20, 0x6D, 0x62, 0x55, 0x58, 0x57, 0x50, 0x41, 0x2C, 0x73, 0x04, 0x92, 0x0D, 0x32, 0x04, 0x0E, 0xF7, 0x41, 0x50, 0x56, 0x1B, 0x53, 0x55, 0x59, 0x21, 0x55, 0x1E, 0x5C, 0xEB, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5D, 0x41, 0x78, 0x2C, 0xD4, 
        0x1E, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x30, 0x2A, 0x0D, 0x0D, 0x0D, 0x0D, 0x86, 0x44, 0x44, 0x91, 0x7F, 0x0D, 0x0D, 0xA1, 0x44, 0x44, 0x44, 0x83, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31,
  0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x15, 0x15, 0x15, 0x15, 0x15, 0xF8, 0x15, 0x51, 0x54, 0x20, 0x20, 0x65, 0x19, 0x58, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x67, 0x21, 0x59, 0x2F, 0x62, 0x01, 0x6D, 
        0x70, 0x20, 0x63, 0x5A, 0x70, 0x65, 0x2F, 0x1E, 0x1B, 0x47, 0x16, 0x2C, 0x73, 0x06, 0x32, 0x0D, 0x6F, 0x52, 0x78, 0x23, 0x50, 0x1A, 0x1B, 0x5C, 0x21, 0x59, 0x21, 0x1E, 0x5C, 0xEB, 0x19, 0x58, 0x54, 0x1B, 0x5B, 0x5B, 0x5D, 0x1D, 0x1D, 0x18, 0xDA, 
        0x78, 0x2C, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5B, 0x20, 0x20, 0x65, 0x19, 
        0x58, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x67, 0x21, 0x59, 0x2F, 0x62, 0x01, 0x6D, 0x70, 0x20, 0x63, 0x5A, 0x70, 0x65, 0x2F, 0x1E, 0x1B, 0x47, 0x16, 0x2C, 0x73, 0x06, 0x32, 0x0D, 0x6F, 0x52, 0x78, 0x23, 0x50, 0x1A, 0x1B, 0x5C, 0x21, 0x59, 0x21, 0x1E, 
        0x5C, 0xEB, 0x19, 0x58, 0x54, 0x1B, 0x5B, 0x5B, 0x5D, 0x1D, 0x1D, 0x18, 0xDA, 0x78, 0x2C, 0x19, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x13, 0x3C, 0x13, 0x05, 0x3C, 0x3C, 0x13, 0x13, 
        0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x1D, 0x20, 0x20, 0x65, 0x19, 0x58, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x67, 0x21, 0x59, 0x2F, 0x62, 0x01, 0x6D, 0x70, 0x20, 0x63, 0x5A, 0x70, 0x65, 0x2F, 0x1E, 0x1B, 0x47, 0x16, 0x2C, 0x73, 0x06, 0x32, 
        0x0D, 0x6F, 0x52, 0x78, 0x23, 0x50, 0x1A, 0x1B, 0x5C, 0x21, 0x59, 0x21, 0x1E, 0x5C, 0xEB, 0x19, 0x58, 0x54, 0x1B, 0x5B, 0x5B, 0x5D, 0x1D, 0x1D, 0x18, 0xDA, 0x78, 0x2C, 0x19, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5B, 0x20, 0x20, 0x65, 0x19, 0x58, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x67, 0x21, 0x59, 0x2F, 0x62, 0x01, 0x6D, 0x70, 0x20, 
        0x63, 0x5A, 0x70, 0x65, 0x2F, 0x1E, 0x1B, 0x47, 0x16, 0x2C, 0x73, 0x06, 0x32, 0x0D, 0x6F, 0x52, 0x78, 0x23, 0x50, 0x1A, 0x1B, 0x5C, 0x21, 0x59, 0x21, 0x1E, 0x5C, 0xEB, 0x19, 0x58, 0x54, 0x1B, 0x5B, 0x5B, 0x5D, 0x1D, 0x1D, 0x18, 0xDA, 0x78, 0x2C, 
        0x19, 0x8E, 0x8E, 0x8E, 0x39, 0x8E, 0x39, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x30, 0x2A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x96, 0x44, 0x44, 0x9C, 0x0D, 0x0D, 0x0D, 0x86, 0x44, 0x44, 0x95, 0x7F, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x51, 0x51, 0x15, 0x62, 0x4A, 0x34, 0x70, 0x5B, 0x5B, 0x1B, 0x1B, 0x58, 0x58, 0x19, 0x53, 0x5C, 0x67, 0x55, 0x59, 0x2F, 0x69, 
        0x65, 0x2A, 0x20, 0x5A, 0x63, 0x70, 0x65, 0x59, 0xEB, 0x57, 0x1C, 0x7B, 0x6E, 0x0C, 0xA9, 0xA9, 0xDD, 0x7E, 0x74, 0x1C, 0x56, 0x54, 0x1E, 0x21, 0x21, 0x55, 0x1E, 0xEB, 0x19, 0x58, 0x1B, 0x1B, 0x5B, 0x5D, 0x1D, 0x1D, 0x57, 0x56, 0x56, 0x1A, 0xA2, 
        0xDA, 0x78, 0x18, 0x23, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x62, 0x4A, 0x34, 0x70, 0x5B, 
        0x5B, 0x1B, 0x1B, 0x58, 0x58, 0x19, 0x53, 0x5C, 0x67, 0x55, 0x59, 0x2F, 0x69, 0x65, 0x2A, 0x20, 0x5A, 0x63, 0x70, 0x65, 0x59, 0xEB, 0x57, 0x1C, 0x7B, 0x6E, 0x0C, 0xA9, 0xA9, 0xDD, 0x7E, 0x74, 0x1C, 0x56, 0x54, 0x1E, 0x21, 0x21, 0x55, 0x1E, 0xEB, 
        0x19, 0x58, 0x1B, 0x1B, 0x5B, 0x5D, 0x1D, 0x1D, 0x57, 0x56, 0x56, 0x1A, 0xA2, 0xDA, 0x78, 0x18, 0x74, 0x13, 0x13, 0x3C, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x4A, 0x34, 0x70, 0x5B, 0x5B, 0x1B, 0x1B, 0x58, 0x58, 0x19, 0x53, 0x5C, 0x67, 0x55, 0x59, 0x2F, 0x69, 0x65, 0x2A, 0x20, 0x5A, 0x63, 0x70, 0x65, 0x59, 0xEB, 0x57, 0x1C, 0x7B, 0x6E, 0x0C, 0xA9, 
        0xA9, 0xDD, 0x7E, 0x74, 0x1C, 0x56, 0x54, 0x1E, 0x21, 0x21, 0x55, 0x1E, 0xEB, 0x19, 0x58, 0x1B, 0x1B, 0x5B, 0x5D, 0x1D, 0x1D, 0x57, 0x56, 0x56, 0x1A, 0xA2, 0xDA, 0x78, 0x18, 0x74, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x4A, 0x34, 0x70, 0x5B, 0x5B, 0x1B, 0x1B, 0x58, 0x58, 0x19, 0x53, 0x5C, 0x67, 0x55, 0x59, 0x2F, 0x69, 0x65, 0x2A, 
        0x20, 0x5A, 0x63, 0x70, 0x65, 0x59, 0xEB, 0x57, 0x1C, 0x7B, 0x6E, 0x0C, 0xA9, 0xA9, 0xDD, 0x7E, 0x74, 0x1C, 0x56, 0x54, 0x1E, 0x21, 0x21, 0x55, 0x1E, 0xEB, 0x19, 0x58, 0x1B, 0x1B, 0x5B, 0x5D, 0x1D, 0x1D, 0x57, 0x56, 0x56, 0x1A, 0xA2, 0xDA, 0x78, 
        0x18, 0x25, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x37, 0x6C, 0x35, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x30, 0x2A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x7F, 0x95, 0x44, 0x44, 0x9D, 0x0D, 0x0D, 0x0D, 0x96, 0x44, 0x44, 0x96, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
  0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x51, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0F, 0x62, 0x30, 0x4A, 0x6D, 0x1D, 0x1D, 0x1D, 0x5D, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0x5C, 0x1E, 0x55, 0x59, 
        0x2F, 0x69, 0x6D, 0x70, 0x20, 0x5A, 0x20, 0x01, 0x55, 0x1B, 0x18, 0x74, 0x0E, 0x0A, 0x9A, 0x92, 0x12, 0x7B, 0x48, 0x56, 0x58, 0x55, 0x21, 0x55, 0x1E, 0xEB, 0x58, 0x54, 0x1B, 0x5B, 0x5D, 0x1D, 0x1D, 0x57, 0x56, 0x1A, 0x1A, 0x1A, 0x47, 0x47, 0x7B, 
        0x72, 0x15, 0x23, 0x1A, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x03, 0x62, 0x30, 0x4A, 0x6D, 0x1D, 
        0x1D, 0x1D, 0x5D, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0x5C, 0x1E, 0x55, 0x59, 0x2F, 0x69, 0x6D, 0x70, 0x20, 0x5A, 0x20, 0x01, 0x55, 0x1B, 0x18, 0x74, 0x0E, 0x0A, 0x9A, 0x92, 0x12, 0x7B, 0x48, 0x56, 0x58, 0x55, 0x21, 0x55, 0x1E, 0xEB, 0x58, 0x54, 
        0x1B, 0x5B, 0x5D, 0x1D, 0x1D, 0x57, 0x56, 0x1A, 0x1A, 0x1A, 0x47, 0x47, 0x7B, 0x72, 0x15, 0x23, 0x18, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x04, 0x3C, 
        0x3C, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x15, 0x62, 0x30, 0x4A, 0x6D, 0x1D, 0x1D, 0x1D, 0x5D, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0x5C, 0x1E, 0x55, 0x59, 0x2F, 0x69, 0x6D, 0x70, 0x20, 0x5A, 0x20, 0x01, 0x55, 0x1B, 0x18, 0x74, 0x0E, 0x0A, 0x9A, 
        0x92, 0x12, 0x7B, 0x48, 0x56, 0x58, 0x55, 0x21, 0x55, 0x1E, 0xEB, 0x58, 0x54, 0x1B, 0x5B, 0x5D, 0x1D, 0x1D, 0x57, 0x56, 0x1A, 0x1A, 0x1A, 0x47, 0x47, 0x7B, 0x72, 0x15, 0x23, 0x18, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x03, 0x62, 0x30, 0x4A, 0x6D, 0x1D, 0x1D, 0x1D, 0x5D, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0x5C, 0x1E, 0x55, 0x59, 0x2F, 0x69, 
        0x6D, 0x70, 0x20, 0x5A, 0x20, 0x01, 0x55, 0x1B, 0x18, 0x74, 0x0E, 0x0A, 0x9A, 0x92, 0x12, 0x7B, 0x48, 0x56, 0x58, 0x55, 0x21, 0x55, 0x1E, 0xEB, 0x58, 0x54, 0x1B, 0x5B, 0x5D, 0x1D, 0x1D, 0x57, 0x56, 0x1A, 0x1A, 0x1A, 0x47, 0x47, 0x7B, 0x72, 0x15, 
        0x23, 0x57, 0x33, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x61, 0x61, 0x61, 0x0B, 0x37, 0x37, 0x37, 0x35, 0x30, 0x2A, 0x0D, 0x0D, 0x86, 0x0D, 0x0D, 0x0D, 0x83, 0x44, 0x44, 0x44, 0x83, 0x0D, 0x0D, 0x7F, 0x95, 0x44, 0x44, 0x86, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x33, 0x15, 0x17, 0x6D, 0x30, 0x30, 0x62, 0x1A, 0x56, 0x56, 0x57, 0x57, 0x1D, 0x5D, 0x5B, 0x5B, 0x1B, 0x54, 0x58, 0x53, 0x1E, 
        0x55, 0x59, 0x2F, 0x01, 0x2A, 0x20, 0x5A, 0x20, 0x01, 0x5C, 0x56, 0xF0, 0x7E, 0x08, 0x0D, 0xFD, 0x15, 0xAB, 0x56, 0x19, 0x21, 0x21, 0x1E, 0x53, 0x19, 0x54, 0x1B, 0x5B, 0x1D, 0x1D, 0x57, 0x56, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x4C, 0x18, 0x18, 0x75, 
        0x7E, 0x72, 0x78, 0x5B, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3D, 0x6D, 0x30, 0x30, 0x62, 0x1A, 
        0x56, 0x56, 0x57, 0x57, 0x1D, 0x5D, 0x5B, 0x5B, 0x1B, 0x54, 0x58, 0x53, 0x1E, 0x55, 0x59, 0x2F, 0x01, 0x2A, 0x20, 0x5A, 0x20, 0x01, 0x5C, 0x56, 0xF0, 0x7E, 0x08, 0x0D, 0xFD, 0x15, 0xAB, 0x56, 0x19, 0x21, 0x21, 0x1E, 0x53, 0x19, 0x54, 0x1B, 0x5B, 
        0x1D, 0x1D, 0x57, 0x56, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x4C, 0x18, 0x18, 0x75, 0x7E, 0x72, 0x78, 0x1D, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x26, 0x6D, 0x30, 0x30, 0x62, 0x1A, 0x56, 0x56, 0x57, 0x57, 0x1D, 0x5D, 0x5B, 0x5B, 0x1B, 0x54, 0x58, 0x53, 0x1E, 0x55, 0x59, 0x2F, 0x01, 0x2A, 0x20, 0x5A, 0x20, 0x01, 0x5C, 0x56, 0xF0, 0x7E, 0x08, 0x0D, 
        0xFD, 0x15, 0xAB, 0x56, 0x19, 0x21, 0x21, 0x1E, 0x53, 0x19, 0x54, 0x1B, 0x5B, 0x1D, 0x1D, 0x57, 0x56, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x4C, 0x18, 0x18, 0x75, 0x7E, 0x72, 0x78, 0x1D, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x23, 0x6D, 0x30, 0x30, 0x62, 0x1A, 0x56, 0x56, 0x57, 0x57, 0x1D, 0x5D, 0x5B, 0x5B, 0x1B, 0x54, 0x58, 0x53, 0x1E, 0x55, 0x59, 
        0x2F, 0x01, 0x2A, 0x20, 0x5A, 0x20, 0x01, 0x5C, 0x56, 0xF0, 0x7E, 0x08, 0x0D, 0xFD, 0x15, 0xAB, 0x56, 0x19, 0x21, 0x21, 0x1E, 0x53, 0x19, 0x54, 0x1B, 0x5B, 0x1D, 0x1D, 0x57, 0x56, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x4C, 0x18, 0x18, 0x75, 0x7E, 0x72, 
        0x78, 0x54, 0x8E, 0x8E, 0x8E, 0x8E, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x30, 0x2A, 0x0D, 0x0D, 0x44, 0xA1, 0x0D, 0x0D, 0x0D, 0x86, 0x44, 0x44, 0x91, 0x7F, 0x0D, 0x0D, 0x83, 0x44, 0x44, 0x44, 0xA1, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38,
  0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x39, 0x03, 0x03, 0x58, 0x63, 0x30, 0x30, 0x53, 0x4C, 0x4C, 0x47, 0x47, 0x47, 0x1A, 0x56, 0x56, 0x1D, 0x1D, 0x5D, 0x5B, 0x1B, 0x58, 
        0x19, 0x5C, 0x67, 0x59, 0x62, 0x65, 0x70, 0x5A, 0x20, 0x2F, 0x58, 0x1C, 0x72, 0x6F, 0x32, 0x73, 0xF0, 0x56, 0x5C, 0x21, 0x55, 0x5C, 0x58, 0x54, 0x1B, 0x5D, 0x1D, 0x57, 0x56, 0x1A, 0x47, 0x47, 0x4C, 0x4C, 0x18, 0x18, 0x18, 0x50, 0x50, 0x50, 0x41, 
        0x6E, 0x7E, 0x7E, 0x1E, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5B, 0x63, 0x30, 0x30, 0x53, 0x4C, 
        0x4C, 0x47, 0x47, 0x47, 0x1A, 0x56, 0x56, 0x1D, 0x1D, 0x5D, 0x5B, 0x1B, 0x58, 0x19, 0x5C, 0x67, 0x59, 0x62, 0x65, 0x70, 0x5A, 0x20, 0x2F, 0x58, 0x1C, 0x72, 0x6F, 0x32, 0x73, 0xF0, 0x56, 0x5C, 0x21, 0x55, 0x5C, 0x58, 0x54, 0x1B, 0x5D, 0x1D, 0x57, 
        0x56, 0x1A, 0x47, 0x47, 0x4C, 0x4C, 0x18, 0x18, 0x18, 0x50, 0x50, 0x50, 0x41, 0x6E, 0x7E, 0x7E, 0x1E, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x5D, 0x63, 0x30, 0x30, 0x53, 0x4C, 0x4C, 0x47, 0x47, 0x47, 0x1A, 0x56, 0x56, 0x1D, 0x1D, 0x5D, 0x5B, 0x1B, 0x58, 0x19, 0x5C, 0x67, 0x59, 0x62, 0x65, 0x70, 0x5A, 0x20, 0x2F, 0x58, 0x1C, 0x72, 0x6F, 0x32, 
        0x73, 0xF0, 0x56, 0x5C, 0x21, 0x55, 0x5C, 0x58, 0x54, 0x1B, 0x5D, 0x1D, 0x57, 0x56, 0x1A, 0x47, 0x47, 0x4C, 0x4C, 0x18, 0x18, 0x18, 0x50, 0x50, 0x50, 0x41, 0x6E, 0x7E, 0x7E, 0x1E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x5D, 0x63, 0x30, 0x30, 0x53, 0x4C, 0x4C, 0x47, 0x47, 0x47, 0x1A, 0x56, 0x56, 0x1D, 0x1D, 0x5D, 0x5B, 0x1B, 0x58, 0x19, 0x5C, 
        0x67, 0x59, 0x62, 0x65, 0x70, 0x5A, 0x20, 0x2F, 0x58, 0x1C, 0x72, 0x6F, 0x32, 0x73, 0xF0, 0x56, 0x5C, 0x21, 0x55, 0x5C, 0x58, 0x54, 0x1B, 0x5D, 0x1D, 0x57, 0x56, 0x1A, 0x47, 0x47, 0x4C, 0x4C, 0x18, 0x18, 0x18, 0x50, 0x50, 0x50, 0x41, 0x6E, 0x7E, 
        0x7E, 0x1E, 0x37, 0x37, 0x37, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x30, 0x2A, 0x0D, 0x0D, 0x44, 0x44, 0x7F, 0x0D, 0x0D, 0x0D, 0x96, 0x44, 0x44, 0x9C, 0x0D, 0x0D, 0x0D, 0x9D, 0x44, 0x44, 0x44, 
        0x7F, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x03, 0x33, 0x33, 0x33, 0x58, 0x7D, 0x30, 0x30, 0x57, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x57, 0x1D, 
        0x5B, 0x1B, 0x54, 0x19, 0x1E, 0x21, 0x62, 0x2A, 0x5A, 0x20, 0x59, 0x1A, 0x78, 0x92, 0x0A, 0x26, 0x57, 0x1E, 0x55, 0x5C, 0x58, 0x1B, 0x5D, 0x1D, 0x56, 0x1A, 0x47, 0x47, 0x4C, 0x4C, 0x18, 0x18, 0x50, 0x50, 0x50, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x41, 
        0x73, 0x0E, 0x7E, 0x1B, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x5B, 0x7D, 0x30, 0x30, 0x57, 0x50, 
        0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x57, 0x1D, 0x5B, 0x1B, 0x54, 0x19, 0x1E, 0x21, 0x62, 0x2A, 0x5A, 0x20, 0x59, 0x1A, 0x78, 0x92, 0x0A, 0x26, 0x57, 0x1E, 0x55, 0x5C, 0x58, 0x1B, 0x5D, 0x1D, 0x56, 0x1A, 0x47, 0x47, 
        0x4C, 0x4C, 0x18, 0x18, 0x50, 0x50, 0x50, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x41, 0x73, 0x0E, 0x7E, 0x1B, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1D, 0x7D, 0x30, 0x30, 0x57, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x57, 0x1D, 0x5B, 0x1B, 0x54, 0x19, 0x1E, 0x21, 0x62, 0x2A, 0x5A, 0x20, 0x59, 0x1A, 0x78, 0x92, 0x0A, 
        0x26, 0x57, 0x1E, 0x55, 0x5C, 0x58, 0x1B, 0x5D, 0x1D, 0x56, 0x1A, 0x47, 0x47, 0x4C, 0x4C, 0x18, 0x18, 0x50, 0x50, 0x50, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x41, 0x73, 0x0E, 0x7E, 0x1B, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x5D, 0x7D, 0x30, 0x30, 0x57, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x57, 0x1D, 0x5B, 0x1B, 
        0x54, 0x19, 0x1E, 0x21, 0x62, 0x2A, 0x5A, 0x20, 0x59, 0x1A, 0x78, 0x92, 0x0A, 0x26, 0x57, 0x1E, 0x55, 0x5C, 0x58, 0x1B, 0x5D, 0x1D, 0x56, 0x1A, 0x47, 0x47, 0x4C, 0x4C, 0x18, 0x18, 0x50, 0x50, 0x50, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x41, 0x73, 0x0E, 
        0x7E, 0x1B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x61, 0x61, 0x8E, 0x61, 0x0B, 0x0B, 0x37, 0x37, 0x6C, 0x0F, 0x30, 0x2A, 0x0D, 0x0D, 0x44, 0x44, 0x45, 0x0D, 0x0D, 0x0D, 0x7F, 0x95, 0x44, 0x44, 0x9D, 0x0D, 0x0D, 0x0D, 0x9C, 0x44, 0x44, 
        0x95, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 
        0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0xA7, 0x0D, 0x0D, 0x2A, 0x30, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x24, 0x24,
  0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x51, 0xF8, 0x7C, 0x54, 0x7A, 0xDF, 0x93, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 
        0x1A, 0x56, 0x57, 0x1D, 0x5B, 0x58, 0x53, 0x55, 0x69, 0x70, 0x70, 0x53, 0x26, 0x92, 0x7E, 0x56, 0x1E, 0x1E, 0x58, 0x5B, 0x57, 0x1A, 0x47, 0x47, 0x18, 0x18, 0x50, 0x50, 0x50, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x16, 
        0xFC, 0x73, 0x0E, 0x1A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x07, 0x14, 0x14, 0x5D, 0x7A, 0xDF, 0x93, 0x1C, 0x1C, 
        0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 0x1A, 0x56, 0x57, 0x1D, 0x5B, 0x58, 0x53, 0x55, 0x69, 0x70, 0x70, 0x53, 0x26, 0x92, 0x7E, 0x56, 0x1E, 0x1E, 0x58, 0x5B, 0x57, 0x1A, 0x47, 0x47, 0x18, 0x18, 0x50, 0x50, 
        0x50, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x16, 0xFC, 0x73, 0x0E, 0x1A, 0x04, 0x04, 0x04, 0x3C, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x1D, 0x7A, 0xDF, 0x93, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 0x1A, 0x56, 0x57, 0x1D, 0x5B, 0x58, 0x53, 0x55, 0x69, 0x70, 0x70, 0x53, 0x26, 0x92, 0x7E, 
        0x56, 0x1E, 0x1E, 0x58, 0x5B, 0x57, 0x1A, 0x47, 0x47, 0x18, 0x18, 0x50, 0x50, 0x50, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x16, 0xFC, 0x73, 0x0E, 0x1A, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x5D, 0x7A, 0xDF, 0x93, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 0x1A, 0x56, 
        0x57, 0x1D, 0x5B, 0x58, 0x53, 0x55, 0x69, 0x70, 0x70, 0x53, 0x26, 0x92, 0x7E, 0x56, 0x1E, 0x1E, 0x58, 0x5B, 0x57, 0x1A, 0x47, 0x47, 0x18, 0x18, 0x50, 0x50, 0x50, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x16, 0xFC, 0x73, 
        0x0E, 0x1A, 0x27, 0x27, 0x02, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x33, 0x33, 0x33, 0x03, 0x03, 0x30, 0x2A, 0x0D, 0x0D, 0x44, 0x44, 0x44, 0x86, 0x0D, 0x0D, 0x0D, 0x83, 0x44, 0x44, 0x44, 0x83, 0x0D, 0x0D, 0x7F, 0x91, 0x44, 
        0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 
        0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x86, 0x0D, 0x0D, 0x2A, 0x30, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x01, 0x34, 0x4A, 0x94, 0xAB, 0x16, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x5E, 
        0x5E, 0x50, 0x50, 0x18, 0x47, 0x1A, 0x56, 0x5D, 0x54, 0x67, 0x65, 0x2A, 0x1C, 0x0C, 0x1A, 0x5C, 0x54, 0x57, 0x1A, 0x47, 0x18, 0x50, 0x5E, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0x48, 0x48, 0xAB, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0x16, 
        0x72, 0xFC, 0xFC, 0x50, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x34, 0x4A, 0x94, 0xAB, 0x16, 
        0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x50, 0x18, 0x47, 0x1A, 0x56, 0x5D, 0x54, 0x67, 0x65, 0x2A, 0x1C, 0x0C, 0x1A, 0x5C, 0x54, 0x57, 0x1A, 0x47, 0x18, 0x50, 0x5E, 0x1C, 0x1C, 0x48, 0x48, 0x48, 
        0x48, 0x48, 0xAB, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0x16, 0x72, 0xFC, 0xFC, 0x50, 0x26, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x13, 0x3C, 0x3C, 0x13, 0x3C, 0x13, 0x01, 0x34, 0x4A, 0x94, 0xAB, 0x16, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x50, 0x18, 0x47, 0x1A, 0x56, 0x5D, 0x54, 0x67, 0x65, 0x2A, 0x1C, 0x0C, 0x1A, 
        0x5C, 0x54, 0x57, 0x1A, 0x47, 0x18, 0x50, 0x5E, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0x48, 0x48, 0xAB, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0x16, 0x72, 0xFC, 0xFC, 0x50, 0x6C, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x34, 0x4A, 0x94, 0xAB, 0x16, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 
        0x50, 0x18, 0x47, 0x1A, 0x56, 0x5D, 0x54, 0x67, 0x65, 0x2A, 0x1C, 0x0C, 0x1A, 0x5C, 0x54, 0x57, 0x1A, 0x47, 0x18, 0x50, 0x5E, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0x48, 0x48, 0xAB, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0x16, 0x72, 0xFC, 
        0xFC, 0x50, 0x71, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x30, 0x2A, 0x0D, 0x0D, 0x44, 0x44, 0x44, 0x44, 0xA1, 0x0D, 0x0D, 0x0D, 0x86, 0x44, 0x44, 0x91, 0x7F, 0x0D, 0x0D, 0x83, 0x45, 
        0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 
        0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0xA7, 0x0D, 0x0D, 0x2A, 0x30, 0x38, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x33, 0x33, 0x51, 0x51, 0x51, 0x15, 0x02, 0x02, 0x01, 0x63, 0xC1, 0x34, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0xAB, 0xAB, 0x48, 0x48, 0x1C, 0x5E, 0x50, 0x47, 0x58, 0x19, 0xF0, 0x1D, 0x18, 0x1C, 0x48, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0xA4, 0x41, 
        0xA2, 0xDC, 0x73, 0x1C, 0x16, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x63, 0xC1, 0x34, 0x41, 0x41, 
        0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0x48, 0x48, 0x1C, 0x5E, 0x50, 0x47, 0x58, 0x19, 0xF0, 0x1D, 0x18, 0x1C, 0x48, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x41, 0x41, 0x41, 0x41, 0x41, 
        0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0xA4, 0x41, 0xA2, 0xDC, 0x73, 0x1C, 0x74, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x3C, 0x13, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x3C, 0x13, 0x3C, 0x3C, 0x13, 0x13, 
        0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x01, 0x63, 0xC1, 0x34, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0x48, 0x48, 0x1C, 0x5E, 0x50, 0x47, 0x58, 0x19, 0xF0, 0x1D, 
        0x18, 0x1C, 0x48, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0xA4, 0x41, 0xA2, 0xDC, 0x73, 0x1C, 0x26, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x01, 0x63, 0xC1, 0x34, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0xAB, 0xAB, 0x48, 0x48, 0x1C, 0x5E, 0x50, 0x47, 0x58, 0x19, 0xF0, 0x1D, 0x18, 0x1C, 0x48, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0xA4, 0x41, 0xA2, 0xDC, 
        0x73, 0x1C, 0x1C, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x39, 0x39, 0x61, 0x61, 0x0B, 0x0B, 0x30, 0x2A, 0x0D, 0x0D, 0x44, 0x44, 0x44, 0x44, 0x44, 0x7F, 0x0D, 0x0D, 0x0D, 0x96, 0x44, 0x44, 0x86, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A,
  0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x51, 0x7C, 0x02, 0x02, 0x02, 0x01, 0x5A, 0x34, 0x63, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 
        0x41, 0x41, 0x41, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0x48, 0x5E, 0x4C, 0x1D, 0x23, 0x19, 0x58, 0x1A, 0x18, 0x5E, 0x1C, 0x48, 0x48, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x16, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 
        0xF7, 0xDA, 0x0E, 0x48, 0x23, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x5A, 0x34, 0x63, 0x41, 0x41, 
        0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0x48, 0x5E, 0x4C, 0x1D, 0x23, 0x19, 0x58, 0x1A, 0x18, 0x5E, 0x1C, 0x48, 0x48, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x16, 0x41, 
        0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0xF7, 0xDA, 0x0E, 0x48, 0x74, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x3C, 0x3C, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x5A, 0x34, 0x63, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0x48, 0x5E, 0x4C, 0x1D, 0x23, 0x19, 0x58, 
        0x1A, 0x18, 0x5E, 0x1C, 0x48, 0x48, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x16, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0xF7, 0xDA, 0x0E, 0x48, 0x26, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 
        0x04, 0x04, 0x13, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x05, 0x05, 0x3C, 0x01, 0x5A, 0x34, 0x63, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 
        0x41, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0x48, 0x5E, 0x4C, 0x1D, 0x23, 0x19, 0x58, 0x1A, 0x18, 0x5E, 0x1C, 0x48, 0x48, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x16, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0xF7, 0xDA, 
        0x0E, 0x48, 0x1C, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x8E, 0x39, 0x61, 0x61, 0x30, 0x2A, 0x0D, 0x0D, 0x44, 0x44, 0x44, 0x44, 0x44, 0x7F, 0x0D, 0x0D, 0x0D, 0x96, 0x44, 0x44, 0x86, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x01, 0x70, 0x5A, 0x5A, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0xAB, 0xAB, 0x48, 0x48, 0x48, 
        0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x18, 0x47, 0x1A, 0x1D, 0x54, 0x5C, 0x1A, 0xFD, 0x1C, 0x2A, 0x65, 0x67, 0x54, 0x5D, 0x56, 0x1A, 0x47, 0x18, 0x18, 0x50, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
        0x7B, 0xF7, 0xDA, 0x5E, 0x23, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x01, 0x70, 0x5A, 0x5A, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0xAB, 0xAB, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x18, 0x47, 0x1A, 0x1D, 0x54, 0x5C, 0x1A, 0xFD, 0x1C, 0x2A, 0x65, 0x67, 0x54, 0x5D, 0x56, 0x1A, 0x47, 0x18, 0x18, 0x50, 0x5E, 0x5E, 0x1C, 
        0x1C, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x7B, 0xF7, 0xDA, 0x5E, 0x26, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x01, 0x70, 0x5A, 0x5A, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0xAB, 0xAB, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x18, 0x47, 0x1A, 0x1D, 0x54, 0x5C, 0x1A, 0xFD, 0x1C, 0x2A, 
        0x65, 0x67, 0x54, 0x5D, 0x56, 0x1A, 0x47, 0x18, 0x18, 0x50, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x7B, 0xF7, 0xDA, 0x5E, 0x74, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x70, 0x5A, 0x5A, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0xAB, 0xAB, 0x48, 0x48, 0x48, 0x1C, 0x1C, 
        0x5E, 0x5E, 0x50, 0x18, 0x47, 0x1A, 0x1D, 0x54, 0x5C, 0x1A, 0xFD, 0x1C, 0x2A, 0x65, 0x67, 0x54, 0x5D, 0x56, 0x1A, 0x47, 0x18, 0x18, 0x50, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x7B, 0xF7, 
        0xDA, 0x5E, 0x17, 0x15, 0x15, 0x15, 0x33, 0x33, 0x33, 0x33, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x30, 0x2A, 0x0D, 0x0D, 0x44, 0x44, 0x44, 0x44, 0xA1, 0x0D, 0x0D, 0x0D, 0x86, 0x44, 0x44, 0x91, 0x7F, 0x0D, 0x0D, 0x83, 0x45, 
        0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 
        0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0xA7, 0x0D, 0x0D, 0x2A, 0x30, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2B, 0x2B, 0x2B,
  0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x39, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x67, 0x2A, 0x70, 0x20, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x50, 
        0x18, 0x18, 0x47, 0x47, 0x1A, 0x57, 0x5B, 0x54, 0x1E, 0x67, 0x56, 0x7E, 0x92, 0x26, 0x53, 0x70, 0x70, 0x69, 0x21, 0x53, 0x58, 0x5B, 0x1D, 0x57, 0x56, 0x1A, 0x47, 0x4C, 0x18, 0x18, 0x18, 0x50, 0x50, 0x50, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 
        0x75, 0x7B, 0x2C, 0x4C, 0x03, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x5C, 0x2A, 0x70, 0x20, 0x48, 0x48, 
        0x48, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x50, 0x18, 0x18, 0x47, 0x47, 0x1A, 0x57, 0x5B, 0x54, 0x1E, 0x67, 0x56, 0x7E, 0x92, 0x26, 0x53, 0x70, 0x70, 0x69, 0x21, 0x53, 0x58, 0x5B, 0x1D, 0x57, 0x56, 0x1A, 0x47, 0x4C, 
        0x18, 0x18, 0x18, 0x50, 0x50, 0x50, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x75, 0x7B, 0x2C, 0x4C, 0x0E, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x53, 0x2A, 0x70, 0x20, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x50, 0x18, 0x18, 0x47, 0x47, 0x1A, 0x57, 0x5B, 0x54, 0x1E, 0x67, 0x56, 0x7E, 0x92, 0x26, 0x53, 
        0x70, 0x70, 0x69, 0x21, 0x53, 0x58, 0x5B, 0x1D, 0x57, 0x56, 0x1A, 0x47, 0x4C, 0x18, 0x18, 0x18, 0x50, 0x50, 0x50, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x75, 0x7B, 0x2C, 0x4C, 0x12, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x5C, 0x2A, 0x70, 0x20, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x50, 0x18, 0x18, 
        0x47, 0x47, 0x1A, 0x57, 0x5B, 0x54, 0x1E, 0x67, 0x56, 0x7E, 0x92, 0x26, 0x53, 0x70, 0x70, 0x69, 0x21, 0x53, 0x58, 0x5B, 0x1D, 0x57, 0x56, 0x1A, 0x47, 0x4C, 0x18, 0x18, 0x18, 0x50, 0x50, 0x50, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x75, 0x7B, 
        0x2C, 0x4C, 0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x33, 0x33, 0x4F, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x30, 0x2A, 0x0D, 0x0D, 0x44, 0x44, 0x44, 0x86, 0x0D, 0x0D, 0x0D, 0x83, 0x44, 0x44, 0x44, 0x83, 0x0D, 0x0D, 0x7F, 0x91, 0x44, 
        0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 
        0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x86, 0x0D, 0x0D, 0x2A, 0x30, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x38,
  0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x51, 0xF8, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x1B, 0x69, 0x6D, 0x70, 0x4C, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 0x47, 
        0x1A, 0x56, 0x1D, 0x5D, 0x1B, 0x58, 0x5C, 0x55, 0x1E, 0x57, 0x7B, 0x0A, 0x1F, 0x78, 0x1A, 0x21, 0x20, 0x5A, 0x2A, 0x62, 0x21, 0x1E, 0x19, 0x54, 0x1B, 0x5B, 0x1D, 0x57, 0x56, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x4C, 0x18, 0x18, 0x18, 0x50, 0x50, 0x9E, 
        0x41, 0x75, 0x7B, 0x1D, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x5D, 0x69, 0x6D, 0x70, 0x4C, 0x1C, 
        0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 0x47, 0x1A, 0x56, 0x1D, 0x5D, 0x1B, 0x58, 0x5C, 0x55, 0x1E, 0x57, 0x7B, 0x0A, 0x1F, 0x78, 0x1A, 0x21, 0x20, 0x5A, 0x2A, 0x62, 0x21, 0x1E, 0x19, 0x54, 0x1B, 0x5B, 0x1D, 0x57, 
        0x56, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x4C, 0x18, 0x18, 0x18, 0x50, 0x50, 0x9E, 0x41, 0x75, 0x7B, 0x1D, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x13, 0x05, 0x13, 
        0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x1D, 0x69, 0x6D, 0x70, 0x4C, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 0x47, 0x1A, 0x56, 0x1D, 0x5D, 0x1B, 0x58, 0x5C, 0x55, 0x1E, 0x57, 0x7B, 0x0A, 0x1F, 0x78, 0x1A, 
        0x21, 0x20, 0x5A, 0x2A, 0x62, 0x21, 0x1E, 0x19, 0x54, 0x1B, 0x5B, 0x1D, 0x57, 0x56, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x4C, 0x18, 0x18, 0x18, 0x50, 0x50, 0x9E, 0x41, 0x75, 0x7B, 0x1D, 0x06, 0x06, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x5D, 0x69, 0x6D, 0x70, 0x4C, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 0x47, 0x1A, 0x56, 
        0x1D, 0x5D, 0x1B, 0x58, 0x5C, 0x55, 0x1E, 0x57, 0x7B, 0x0A, 0x1F, 0x78, 0x1A, 0x21, 0x20, 0x5A, 0x2A, 0x62, 0x21, 0x1E, 0x19, 0x54, 0x1B, 0x5B, 0x1D, 0x57, 0x56, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x4C, 0x18, 0x18, 0x18, 0x50, 0x50, 0x9E, 0x41, 0x75, 
        0x7B, 0x1D, 0x15, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x30, 0x2A, 0x0D, 0x0D, 0x44, 0x44, 0x45, 0x0D, 0x0D, 0x0D, 0x7F, 0x95, 0x44, 0x44, 0x9D, 0x0D, 0x0D, 0x0D, 0x9C, 0x44, 0x44, 
        0x95, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 
        0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0xA7, 0x0D, 0x0D, 0x2A, 0x30, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x7C, 0x7C, 0x7C, 0x51, 0x51, 0x51, 0x51, 0x33, 0x33, 0x51, 0x54, 0x55, 0x01, 0x6D, 0x1D, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x4C, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x1D, 
        0x5D, 0x5B, 0x54, 0x58, 0x5C, 0x55, 0x21, 0x5C, 0x56, 0xF0, 0x73, 0x32, 0x6F, 0x72, 0x1C, 0x58, 0x2F, 0x20, 0x5A, 0x70, 0x65, 0x62, 0x59, 0x67, 0x5C, 0x19, 0x58, 0x1B, 0x5B, 0x5D, 0x1D, 0x1D, 0x56, 0x56, 0x1A, 0x47, 0x47, 0x47, 0x4C, 0xEF, 0x18, 
        0xAB, 0x41, 0x26, 0x19, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x5D, 0x55, 0x01, 0x6D, 0x1D, 0x50, 
        0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x4C, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x1D, 0x5D, 0x5B, 0x54, 0x58, 0x5C, 0x55, 0x21, 0x5C, 0x56, 0xF0, 0x73, 0x32, 0x6F, 0x72, 0x1C, 0x58, 0x2F, 0x20, 0x5A, 0x70, 0x65, 0x62, 0x59, 0x67, 0x5C, 0x19, 0x58, 0x1B, 
        0x5B, 0x5D, 0x1D, 0x1D, 0x56, 0x56, 0x1A, 0x47, 0x47, 0x47, 0x4C, 0xEF, 0x18, 0xAB, 0x41, 0x26, 0x19, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1D, 0x55, 0x01, 0x6D, 0x1D, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x4C, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x1D, 0x5D, 0x5B, 0x54, 0x58, 0x5C, 0x55, 0x21, 0x5C, 0x56, 0xF0, 0x73, 0x32, 0x6F, 0x72, 0x1C, 
        0x58, 0x2F, 0x20, 0x5A, 0x70, 0x65, 0x62, 0x59, 0x67, 0x5C, 0x19, 0x58, 0x1B, 0x5B, 0x5D, 0x1D, 0x1D, 0x56, 0x56, 0x1A, 0x47, 0x47, 0x47, 0x4C, 0xEF, 0x18, 0xAB, 0x41, 0x26, 0x19, 0x04, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x3C, 0x04, 0x13, 0x13, 0x13, 0x13, 0x1D, 0x55, 0x01, 0x6D, 0x1D, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x4C, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x1D, 0x5D, 0x5B, 
        0x54, 0x58, 0x5C, 0x55, 0x21, 0x5C, 0x56, 0xF0, 0x73, 0x32, 0x6F, 0x72, 0x1C, 0x58, 0x2F, 0x20, 0x5A, 0x70, 0x65, 0x62, 0x59, 0x67, 0x5C, 0x19, 0x58, 0x1B, 0x5B, 0x5D, 0x1D, 0x1D, 0x56, 0x56, 0x1A, 0x47, 0x47, 0x47, 0x4C, 0xEF, 0x18, 0xAB, 0x41, 
        0x26, 0x19, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x33, 0x33, 0x33, 0x4F, 0x30, 0x2A, 0x0D, 0x0D, 0x44, 0x44, 0x7F, 0x0D, 0x0D, 0x0D, 0x96, 0x44, 0x44, 0x9C, 0x0D, 0x0D, 0x0D, 0x9D, 0x44, 0x44, 0x44, 
        0x7F, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B,
  0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x4F, 0x4F, 0x33, 0x47, 0x53, 0x2F, 0x69, 0x58, 0x4C, 0x18, 0x4C, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x57, 0x1D, 0x1D, 0x5B, 0x5B, 
        0x54, 0x58, 0x53, 0x1E, 0x21, 0x21, 0x19, 0x56, 0x16, 0x15, 0x0C, 0x0D, 0x08, 0x7E, 0x41, 0x56, 0x1E, 0x01, 0x20, 0x5A, 0x20, 0x2A, 0x01, 0x2F, 0x59, 0x55, 0x1E, 0x53, 0x58, 0x54, 0x1B, 0x5B, 0x5B, 0x5D, 0x1D, 0x57, 0x57, 0x56, 0x56, 0x1A, 0x47, 
        0x9E, 0x48, 0x75, 0x58, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x1C, 0x53, 0x2F, 0x69, 0x58, 0x4C, 
        0x18, 0x4C, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x57, 0x1D, 0x1D, 0x5B, 0x5B, 0x54, 0x58, 0x53, 0x1E, 0x21, 0x21, 0x19, 0x56, 0x16, 0x15, 0x0C, 0x0D, 0x08, 0x7E, 0x41, 0x56, 0x1E, 0x01, 0x20, 0x5A, 0x20, 0x2A, 0x01, 0x2F, 0x59, 0x55, 0x1E, 0x53, 
        0x58, 0x54, 0x1B, 0x5B, 0x5B, 0x5D, 0x1D, 0x57, 0x57, 0x56, 0x56, 0x1A, 0x47, 0x9E, 0x48, 0x75, 0x1B, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x3F, 0x53, 0x2F, 0x69, 0x58, 0x4C, 0x18, 0x4C, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x57, 0x1D, 0x1D, 0x5B, 0x5B, 0x54, 0x58, 0x53, 0x1E, 0x21, 0x21, 0x19, 0x56, 0x16, 0x15, 0x0C, 0x0D, 0x08, 0x7E, 0x41, 
        0x56, 0x1E, 0x01, 0x20, 0x5A, 0x20, 0x2A, 0x01, 0x2F, 0x59, 0x55, 0x1E, 0x53, 0x58, 0x54, 0x1B, 0x5B, 0x5B, 0x5D, 0x1D, 0x57, 0x57, 0x56, 0x56, 0x1A, 0x47, 0x9E, 0x48, 0x75, 0x1B, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x17, 0x53, 0x2F, 0x69, 0x58, 0x4C, 0x18, 0x4C, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x57, 0x1D, 0x1D, 0x5B, 0x5B, 0x54, 0x58, 
        0x53, 0x1E, 0x21, 0x21, 0x19, 0x56, 0x16, 0x15, 0x0C, 0x0D, 0x08, 0x7E, 0x41, 0x56, 0x1E, 0x01, 0x20, 0x5A, 0x20, 0x2A, 0x01, 0x2F, 0x59, 0x55, 0x1E, 0x53, 0x58, 0x54, 0x1B, 0x5B, 0x5B, 0x5D, 0x1D, 0x57, 0x57, 0x56, 0x56, 0x1A, 0x47, 0x9E, 0x48, 
        0x75, 0x19, 0x27, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x33, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x39, 0x30, 0x2A, 0x0D, 0x0D, 0x44, 0xA1, 0x0D, 0x0D, 0x0D, 0x86, 0x44, 0x44, 0x91, 0x7F, 0x0D, 0x0D, 0x83, 0x44, 0x44, 0x44, 0xA1, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x24, 0x24,
  0x39, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0xF8, 0x15, 0x17, 0x1E, 0x55, 0x2F, 0x67, 0x47, 0x47, 0x1A, 0x1A, 0x1A, 0x1A, 0x57, 0x1D, 0x1D, 0x5D, 0x1B, 0x1B, 0x54, 0x58, 
        0xEB, 0x1E, 0x55, 0x21, 0x55, 0x58, 0x56, 0x48, 0x7B, 0x12, 0x92, 0x9A, 0x0A, 0x0E, 0x75, 0x18, 0x1B, 0x21, 0x01, 0x20, 0x63, 0x20, 0x70, 0x6D, 0x69, 0x2F, 0x59, 0x55, 0x1E, 0x5C, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5D, 0x5D, 0x1D, 0x57, 0x56, 
        0x4C, 0x50, 0x41, 0x1B, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x23, 0x1E, 0x55, 0x2F, 0x67, 0x47, 
        0x47, 0x1A, 0x1A, 0x1A, 0x1A, 0x57, 0x1D, 0x1D, 0x5D, 0x1B, 0x1B, 0x54, 0x58, 0xEB, 0x1E, 0x55, 0x21, 0x55, 0x58, 0x56, 0x48, 0x7B, 0x12, 0x92, 0x9A, 0x0A, 0x0E, 0x75, 0x18, 0x1B, 0x21, 0x01, 0x20, 0x63, 0x20, 0x70, 0x6D, 0x69, 0x2F, 0x59, 0x55, 
        0x1E, 0x5C, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5D, 0x5D, 0x1D, 0x57, 0x56, 0x4C, 0x50, 0x41, 0x1D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x0C, 0x0C, 0x26, 0x1E, 0x55, 0x2F, 0x67, 0x47, 0x47, 0x1A, 0x1A, 0x1A, 0x1A, 0x57, 0x1D, 0x1D, 0x5D, 0x1B, 0x1B, 0x54, 0x58, 0xEB, 0x1E, 0x55, 0x21, 0x55, 0x58, 0x56, 0x48, 0x7B, 0x12, 0x92, 0x9A, 0x0A, 0x0E, 0x75, 
        0x18, 0x1B, 0x21, 0x01, 0x20, 0x63, 0x20, 0x70, 0x6D, 0x69, 0x2F, 0x59, 0x55, 0x1E, 0x5C, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5D, 0x5D, 0x1D, 0x57, 0x56, 0x4C, 0x50, 0x41, 0x57, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x74, 0x1E, 0x55, 0x2F, 0x67, 0x47, 0x47, 0x1A, 0x1A, 0x1A, 0x1A, 0x57, 0x1D, 0x1D, 0x5D, 0x1B, 0x1B, 0x54, 0x58, 0xEB, 0x1E, 
        0x55, 0x21, 0x55, 0x58, 0x56, 0x48, 0x7B, 0x12, 0x92, 0x9A, 0x0A, 0x0E, 0x75, 0x18, 0x1B, 0x21, 0x01, 0x20, 0x63, 0x20, 0x70, 0x6D, 0x69, 0x2F, 0x59, 0x55, 0x1E, 0x5C, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5D, 0x5D, 0x1D, 0x57, 0x56, 0x4C, 0x50, 
        0x41, 0x1B, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x4F, 0x33, 0x03, 0x30, 0x2A, 0x0D, 0x0D, 0x86, 0x0D, 0x0D, 0x0D, 0x83, 0x44, 0x44, 0x44, 0x83, 0x0D, 0x0D, 0x7F, 0x95, 0x44, 0x44, 0x86, 0x0D, 
        0x0D, 0x92, 0x7B, 0x56, 0x56, 0x7B, 0x0D, 0x0D, 0x0D, 0x0C, 0x72, 0x72, 0x72, 0x72, 0x72, 0x52, 0x0D, 0x0D, 0x0D, 0x0C, 0xF0, 0x56, 0x50, 0x52, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0C, 0x50, 0x56, 0x50, 0x52, 0x0D, 0x0D, 0x0D, 0x92, 0x72, 0x72, 0x72, 
        0x72, 0x72, 0x72, 0x0D, 0x0D, 0x72, 0x72, 0x72, 0x72, 0x72, 0x52, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x21, 0x5C, 0x21, 0x21, 0x56, 0x56, 0x56, 0x57, 0x57, 0x1D, 0x5D, 0x5B, 0x1B, 0x1B, 0x58, 0x19, 0x53, 0x1E, 
        0x55, 0x21, 0x21, 0x1E, 0x54, 0x1A, 0x1C, 0x74, 0x7E, 0xDD, 0xA9, 0xA9, 0xFD, 0x6E, 0x7B, 0x1C, 0x57, 0x53, 0x59, 0x65, 0x70, 0x63, 0x5A, 0x20, 0x2A, 0x65, 0x69, 0x2F, 0x21, 0x55, 0x67, 0x1E, 0x53, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5B, 0x1D, 
        0x56, 0x18, 0x1C, 0x16, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x5C, 0x21, 0x21, 0x56, 
        0x56, 0x56, 0x57, 0x57, 0x1D, 0x5D, 0x5B, 0x1B, 0x1B, 0x58, 0x19, 0x53, 0x1E, 0x55, 0x21, 0x21, 0x1E, 0x54, 0x1A, 0x1C, 0x74, 0x7E, 0xDD, 0xA9, 0xA9, 0xFD, 0x6E, 0x7B, 0x1C, 0x57, 0x53, 0x59, 0x65, 0x70, 0x63, 0x5A, 0x20, 0x2A, 0x65, 0x69, 0x2F, 
        0x21, 0x55, 0x67, 0x1E, 0x53, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5B, 0x1D, 0x56, 0x18, 0x1C, 0x26, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 
        0x0A, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x08, 0x21, 0x5C, 0x21, 0x21, 0x56, 0x56, 0x56, 0x57, 0x57, 0x1D, 0x5D, 0x5B, 0x1B, 0x1B, 0x58, 0x19, 0x53, 0x1E, 0x55, 0x21, 0x21, 0x1E, 0x54, 0x1A, 0x1C, 0x74, 0x7E, 0xDD, 0xA9, 0xA9, 0xFD, 0x6E, 0x7B, 
        0x1C, 0x57, 0x53, 0x59, 0x65, 0x70, 0x63, 0x5A, 0x20, 0x2A, 0x65, 0x69, 0x2F, 0x21, 0x55, 0x67, 0x1E, 0x53, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5B, 0x1D, 0x56, 0x18, 0x1C, 0x0B, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x21, 0x5C, 0x21, 0x21, 0x56, 0x56, 0x56, 0x57, 0x57, 0x1D, 0x5D, 0x5B, 0x1B, 0x1B, 0x58, 0x19, 0x53, 0x1E, 0x55, 0x21, 
        0x21, 0x1E, 0x54, 0x1A, 0x1C, 0x74, 0x7E, 0xDD, 0xA9, 0xA9, 0xFD, 0x6E, 0x7B, 0x1C, 0x57, 0x53, 0x59, 0x65, 0x70, 0x63, 0x5A, 0x20, 0x2A, 0x65, 0x69, 0x2F, 0x21, 0x55, 0x67, 0x1E, 0x53, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5B, 0x1D, 0x56, 0x18, 
        0x1C, 0x3F, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x15, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x30, 0x2A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x7F, 0x95, 0x44, 0x44, 0x9D, 0x0D, 0x0D, 0x0D, 0x96, 0x44, 0x44, 0x96, 0x0D, 0x0D, 
        0x52, 0xDF, 0x30, 0x30, 0x30, 0x30, 0x7D, 0x0C, 0x0D, 0x2A, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x0C, 0x0D, 0x54, 0x30, 0x30, 0x30, 0x30, 0x30, 0x2A, 0x92, 0x0D, 0x0D, 0x54, 0x30, 0x30, 0x30, 0x30, 0x30, 0x62, 0x0D, 0x0D, 0x62, 0x30, 0x30, 0x30, 
        0x30, 0x30, 0x30, 0x72, 0x72, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x2A, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E,
  0x33, 0x4F, 0x33, 0xF8, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x1E, 0x19, 0x53, 0x21, 0x5B, 0x1D, 0x1D, 0x5D, 0x5B, 0x5B, 0x1B, 0x54, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x21, 
        0x59, 0x21, 0x5C, 0x1B, 0x56, 0x50, 0x23, 0x78, 0x52, 0x6F, 0x0D, 0x32, 0x06, 0x73, 0x2C, 0x16, 0x47, 0x1B, 0x1E, 0x2F, 0x6D, 0x70, 0x5A, 0x63, 0x20, 0x70, 0x6D, 0x01, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x53, 0xEB, 0x19, 0x58, 0x58, 0x54, 0x1B, 
        0x1D, 0x1A, 0x1D, 0x03, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5C, 0x19, 0x53, 0x21, 0x5B, 
        0x1D, 0x1D, 0x5D, 0x5B, 0x5B, 0x1B, 0x54, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x21, 0x59, 0x21, 0x5C, 0x1B, 0x56, 0x50, 0x23, 0x78, 0x52, 0x6F, 0x0D, 0x32, 0x06, 0x73, 0x2C, 0x16, 0x47, 0x1B, 0x1E, 0x2F, 0x6D, 0x70, 0x5A, 0x63, 0x20, 0x70, 0x6D, 0x01, 
        0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x53, 0xEB, 0x19, 0x58, 0x58, 0x54, 0x1B, 0x1D, 0x1A, 0x1D, 0x09, 0x04, 0x04, 0x13, 0x04, 0x04, 0x13, 0x13, 0x13, 0x04, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x53, 0x19, 0x53, 0x21, 0x5B, 0x1D, 0x1D, 0x5D, 0x5B, 0x5B, 0x1B, 0x54, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x21, 0x59, 0x21, 0x5C, 0x1B, 0x56, 0x50, 0x23, 0x78, 0x52, 0x6F, 0x0D, 0x32, 0x06, 0x73, 0x2C, 
        0x16, 0x47, 0x1B, 0x1E, 0x2F, 0x6D, 0x70, 0x5A, 0x63, 0x20, 0x70, 0x6D, 0x01, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x53, 0xEB, 0x19, 0x58, 0x58, 0x54, 0x1B, 0x1D, 0x1A, 0x1D, 0x73, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x53, 0x19, 0x53, 0x21, 0x5B, 0x1D, 0x1D, 0x5D, 0x5B, 0x5B, 0x1B, 0x54, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x21, 0x59, 0x21, 
        0x5C, 0x1B, 0x56, 0x50, 0x23, 0x78, 0x52, 0x6F, 0x0D, 0x32, 0x06, 0x73, 0x2C, 0x16, 0x47, 0x1B, 0x1E, 0x2F, 0x6D, 0x70, 0x5A, 0x63, 0x20, 0x70, 0x6D, 0x01, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x53, 0xEB, 0x19, 0x58, 0x58, 0x54, 0x1B, 0x1D, 0x1A, 
        0x1D, 0x61, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x33, 0x30, 0x2A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x96, 0x44, 0x44, 0x9C, 0x0D, 0x0D, 0x0D, 0x86, 0x44, 0x44, 0x95, 0x7F, 0x0D, 0x0D, 
        0x56, 0x30, 0x62, 0x0C, 0x52, 0xC2, 0x30, 0x50, 0x0D, 0x2A, 0x30, 0x50, 0x72, 0x72, 0x72, 0x72, 0x0D, 0xF0, 0x30, 0x30, 0x56, 0x72, 0xF0, 0xDF, 0x30, 0xF0, 0x0D, 0x56, 0x30, 0x30, 0x50, 0x72, 0x50, 0xDF, 0x30, 0x72, 0x0D, 0x2A, 0x30, 0x67, 0x72, 
        0x72, 0x72, 0x72, 0x0D, 0x72, 0x30, 0xC2, 0x72, 0x72, 0x56, 0x30, 0x30, 0x72, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E,
  0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0xF8, 0xF8, 0xF8, 0x15, 0x15, 0x15, 0x33, 0x57, 0x1B, 0x58, 0x53, 0x19, 0x5B, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x55, 0x21, 0x59, 
        0x55, 0x53, 0x1B, 0x1A, 0x50, 0xF0, 0x2C, 0x0E, 0xDD, 0x32, 0x0D, 0x32, 0x06, 0x73, 0x2C, 0x23, 0x50, 0x57, 0x58, 0x55, 0x62, 0x6D, 0x70, 0x5A, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x01, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x53, 0x19, 0x53, 0x19, 
        0x5B, 0x50, 0x19, 0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x4C, 0x1B, 0x58, 0x53, 0x19, 
        0x5B, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x55, 0x21, 0x59, 0x55, 0x53, 0x1B, 0x1A, 0x50, 0xF0, 0x2C, 0x0E, 0xDD, 0x32, 0x0D, 0x32, 0x06, 0x73, 0x2C, 0x23, 0x50, 0x57, 0x58, 0x55, 0x62, 0x6D, 0x70, 0x5A, 0x63, 0x20, 0x70, 0x2A, 
        0x65, 0x01, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x53, 0x19, 0x53, 0x19, 0x5B, 0x50, 0x58, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x5E, 0x1B, 0x58, 0x53, 0x19, 0x5B, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x55, 0x21, 0x59, 0x55, 0x53, 0x1B, 0x1A, 0x50, 0xF0, 0x2C, 0x0E, 0xDD, 0x32, 0x0D, 0x32, 0x06, 0x73, 0x2C, 
        0x23, 0x50, 0x57, 0x58, 0x55, 0x62, 0x6D, 0x70, 0x5A, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x01, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x53, 0x19, 0x53, 0x19, 0x5B, 0x50, 0x58, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x18, 0x1B, 0x58, 0x53, 0x19, 0x5B, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x55, 0x21, 0x59, 0x55, 0x53, 
        0x1B, 0x1A, 0x50, 0xF0, 0x2C, 0x0E, 0xDD, 0x32, 0x0D, 0x32, 0x06, 0x73, 0x2C, 0x23, 0x50, 0x57, 0x58, 0x55, 0x62, 0x6D, 0x70, 0x5A, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x01, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x53, 0x19, 0x53, 0x19, 0x5B, 0x50, 
        0x19, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x02, 0x30, 0x2A, 0x0D, 0x0D, 0x0D, 0x0D, 0x86, 0x44, 0x44, 0x91, 0x7F, 0x0D, 0x0D, 0xA1, 0x44, 0x44, 0x44, 0x83, 0x0D, 0x0D, 0x0D, 
        0x56, 0x30, 0x7D, 0x50, 0x52, 0x92, 0x72, 0x92, 0x0D, 0x2A, 0x30, 0x50, 0x72, 0x72, 0x72, 0x0C, 0x0D, 0x2A, 0x30, 0x67, 0x0D, 0x0D, 0x0D, 0x0C, 0x50, 0x92, 0x0D, 0x7D, 0x30, 0x56, 0x0D, 0x0D, 0x0D, 0x52, 0x50, 0x0D, 0x0D, 0x2A, 0x30, 0x67, 0x72, 
        0x72, 0x72, 0x0C, 0x0D, 0x72, 0x30, 0x2A, 0x0D, 0x0D, 0x92, 0x7D, 0x30, 0x72, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x25, 0x25, 0x36, 0x36, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29,
  0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x33, 0x33, 0x51, 0x51, 0x33, 0x33, 0x33, 0x4F, 0x4F, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x3D, 0x5C, 0x5D, 0x54, 0xEB, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0xEB, 0x5C, 0x1E, 0x67, 0x55, 0x59, 0x59, 0x67, 
        0x19, 0x1B, 0x1A, 0x50, 0x16, 0x26, 0x72, 0x52, 0x08, 0x9A, 0x0D, 0x92, 0x04, 0x12, 0x78, 0x75, 0x1C, 0x1A, 0x5B, 0x53, 0x21, 0x69, 0x2A, 0x20, 0x5A, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x65, 0x69, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x67, 0x1E, 
        0x19, 0x1C, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x05, 0x13, 0x05, 0x05, 0x13, 0x13, 0x05, 0x3C, 0x3C, 0x05, 0x13, 0x15, 0x5C, 0x5D, 0x54, 0xEB, 
        0x1B, 0x1B, 0x54, 0x58, 0x19, 0xEB, 0x5C, 0x1E, 0x67, 0x55, 0x59, 0x59, 0x67, 0x19, 0x1B, 0x1A, 0x50, 0x16, 0x26, 0x72, 0x52, 0x08, 0x9A, 0x0D, 0x92, 0x04, 0x12, 0x78, 0x75, 0x1C, 0x1A, 0x5B, 0x53, 0x21, 0x69, 0x2A, 0x20, 0x5A, 0x63, 0x5A, 0x20, 
        0x70, 0x2A, 0x65, 0x69, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x67, 0x1E, 0x19, 0x1C, 0x50, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x06, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x7E, 0x5C, 0x5D, 0x54, 0xEB, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0xEB, 0x5C, 0x1E, 0x67, 0x55, 0x59, 0x59, 0x67, 0x19, 0x1B, 0x1A, 0x50, 0x16, 0x26, 0x72, 0x52, 0x08, 0x9A, 0x0D, 0x92, 0x04, 0x12, 0x78, 
        0x75, 0x1C, 0x1A, 0x5B, 0x53, 0x21, 0x69, 0x2A, 0x20, 0x5A, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x65, 0x69, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x67, 0x1E, 0x19, 0x1C, 0x5E, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x02, 0x5C, 0x5D, 0x54, 0xEB, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0xEB, 0x5C, 0x1E, 0x67, 0x55, 0x59, 0x59, 0x67, 0x19, 0x1B, 
        0x1A, 0x50, 0x16, 0x26, 0x72, 0x52, 0x08, 0x9A, 0x0D, 0x92, 0x04, 0x12, 0x78, 0x75, 0x1C, 0x1A, 0x5B, 0x53, 0x21, 0x69, 0x2A, 0x20, 0x5A, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x65, 0x69, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x67, 0x1E, 0x19, 0x1C, 
        0x1A, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x15, 0x15, 0x33, 0x4F, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x30, 0x2A, 0x0D, 0x0D, 0x0D, 0x83, 0x44, 0x44, 0x44, 0x83, 0x0D, 0x0D, 0x7F, 0x44, 0x44, 0x44, 0x9D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x52, 0x7D, 0x30, 0x30, 0x30, 0x30, 0x62, 0x52, 0x0D, 0x2A, 0x30, 0x30, 0x30, 0x30, 0x30, 0x2A, 0x0D, 0xDF, 0x30, 0x7B, 0x0D, 0x0C, 0x62, 0x2A, 0x2A, 0x50, 0x0D, 0x30, 0x30, 0x72, 0x0D, 0x52, 0x62, 0x2A, 0x2A, 0x50, 0x0D, 0x2A, 0x30, 0x30, 0x30, 
        0x30, 0x30, 0x7D, 0x0D, 0x72, 0x30, 0xDF, 0x2A, 0x2A, 0x30, 0x30, 0x2A, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x3B,
  0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x4F, 0x4F, 0x33, 0x51, 0x51, 0x51, 0x33, 0x33, 0x7C, 0x7C, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x55, 0x1D, 0x5D, 0x58, 0x58, 0x58, 0x19, 0xEB, 0x53, 0x1E, 0x1E, 0x55, 0x21, 0x59, 0x21, 0x1E, 0x19, 
        0x1B, 0x56, 0x18, 0xAB, 0x75, 0x78, 0x73, 0xDD, 0x1F, 0x0D, 0x0D, 0x1F, 0x04, 0x12, 0x15, 0x26, 0x16, 0x4C, 0x1D, 0x58, 0x1E, 0x59, 0x01, 0x2A, 0x70, 0x5A, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x6D, 0x65, 0x69, 0x2F, 0x2F, 0x59, 0x21, 0x55, 0x55, 0x55, 
        0x19, 0x1D, 0x4D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x67, 0x1D, 0x5D, 0x58, 
        0x58, 0x58, 0x19, 0xEB, 0x53, 0x1E, 0x1E, 0x55, 0x21, 0x59, 0x21, 0x1E, 0x19, 0x1B, 0x56, 0x18, 0xAB, 0x75, 0x78, 0x73, 0xDD, 0x1F, 0x0D, 0x0D, 0x1F, 0x04, 0x12, 0x15, 0x26, 0x16, 0x4C, 0x1D, 0x58, 0x1E, 0x59, 0x01, 0x2A, 0x70, 0x5A, 0x63, 0x5A, 
        0x20, 0x70, 0x2A, 0x6D, 0x65, 0x69, 0x2F, 0x2F, 0x59, 0x21, 0x55, 0x55, 0x55, 0x19, 0x1D, 0x02, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x0C, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x1D, 0x5D, 0x58, 0x58, 0x58, 0x19, 0xEB, 0x53, 0x1E, 0x1E, 0x55, 0x21, 0x59, 0x21, 0x1E, 0x19, 0x1B, 0x56, 0x18, 0xAB, 0x75, 0x78, 0x73, 0xDD, 0x1F, 0x0D, 0x0D, 0x1F, 0x04, 0x12, 0x15, 
        0x26, 0x16, 0x4C, 0x1D, 0x58, 0x1E, 0x59, 0x01, 0x2A, 0x70, 0x5A, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x6D, 0x65, 0x69, 0x2F, 0x2F, 0x59, 0x21, 0x55, 0x55, 0x55, 0x19, 0x1D, 0x0E, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1E, 0x1D, 0x5D, 0x58, 0x58, 0x58, 0x19, 0xEB, 0x53, 0x1E, 0x1E, 0x55, 0x21, 0x59, 0x21, 0x1E, 0x19, 0x1B, 0x56, 
        0x18, 0xAB, 0x75, 0x78, 0x73, 0xDD, 0x1F, 0x0D, 0x0D, 0x1F, 0x04, 0x12, 0x15, 0x26, 0x16, 0x4C, 0x1D, 0x58, 0x1E, 0x59, 0x01, 0x2A, 0x70, 0x5A, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x6D, 0x65, 0x69, 0x2F, 0x2F, 0x59, 0x21, 0x55, 0x55, 0x55, 0x19, 0x1D, 
        0x6C, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x27, 0x27, 0x27, 0x30, 0x2A, 0x0D, 0x0D, 0x7F, 0x95, 0x44, 0x44, 0x9D, 0x0D, 0x0D, 0x0D, 0x91, 0x44, 0x44, 0x9C, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x72, 0x56, 0x62, 0x30, 0x30, 0x7D, 0x0D, 0x2A, 0x30, 0x50, 0x72, 0x72, 0x72, 0x0C, 0x0D, 0x7D, 0x30, 0x50, 0x0D, 0x52, 0x7D, 0x30, 0x30, 0x2A, 0x0D, 0x30, 0x30, 0x7B, 0x0D, 0x72, 0xDF, 0x30, 0x30, 0x2A, 0x0D, 0x2A, 0x30, 0x67, 0x72, 
        0x72, 0x72, 0x52, 0x0D, 0x72, 0x30, 0xDF, 0x2A, 0x2A, 0xDF, 0x30, 0xC2, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B,
  0x61, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x47, 0x5B, 0x56, 0x5D, 0x54, 0xEB, 0x53, 0x5C, 0x1E, 0x67, 0x21, 0x59, 0x59, 0x21, 0x1E, 0x58, 0x5B, 
        0x56, 0x18, 0x48, 0x23, 0x2C, 0x7E, 0x07, 0x0A, 0x32, 0x0D, 0xA9, 0x1F, 0xDD, 0x12, 0x15, 0x7B, 0x41, 0x50, 0x1A, 0x5B, 0xEB, 0x55, 0x2F, 0x01, 0x2A, 0x20, 0x5A, 0x63, 0x5A, 0x20, 0x20, 0x70, 0x2A, 0x65, 0x01, 0x69, 0x2F, 0x6B, 0xEB, 0x53, 0x55, 
        0x1A, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x1C, 0x5B, 0x56, 0x5D, 
        0x54, 0xEB, 0x53, 0x5C, 0x1E, 0x67, 0x21, 0x59, 0x59, 0x21, 0x1E, 0x58, 0x5B, 0x56, 0x18, 0x48, 0x23, 0x2C, 0x7E, 0x07, 0x0A, 0x32, 0x0D, 0xA9, 0x1F, 0xDD, 0x12, 0x15, 0x7B, 0x41, 0x50, 0x1A, 0x5B, 0xEB, 0x55, 0x2F, 0x01, 0x2A, 0x20, 0x5A, 0x63, 
        0x5A, 0x20, 0x20, 0x70, 0x2A, 0x65, 0x01, 0x69, 0x2F, 0x6B, 0xEB, 0x53, 0x55, 0x1A, 0x58, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0C, 0x0A, 0x16, 0x5B, 0x56, 0x5D, 0x54, 0xEB, 0x53, 0x5C, 0x1E, 0x67, 0x21, 0x59, 0x59, 0x21, 0x1E, 0x58, 0x5B, 0x56, 0x18, 0x48, 0x23, 0x2C, 0x7E, 0x07, 0x0A, 0x32, 0x0D, 0xA9, 0x1F, 0xDD, 0x12, 0x15, 
        0x7B, 0x41, 0x50, 0x1A, 0x5B, 0xEB, 0x55, 0x2F, 0x01, 0x2A, 0x20, 0x5A, 0x63, 0x5A, 0x20, 0x20, 0x70, 0x2A, 0x65, 0x01, 0x69, 0x2F, 0x6B, 0xEB, 0x53, 0x55, 0x1A, 0x54, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x06, 
        0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x04, 0x04, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x48, 0x5B, 0x56, 0x5D, 0x54, 0xEB, 0x53, 0x5C, 0x1E, 0x67, 0x21, 0x59, 0x59, 0x21, 0x1E, 0x58, 0x5B, 0x56, 0x18, 
        0x48, 0x23, 0x2C, 0x7E, 0x07, 0x0A, 0x32, 0x0D, 0xA9, 0x1F, 0xDD, 0x12, 0x15, 0x7B, 0x41, 0x50, 0x1A, 0x5B, 0xEB, 0x55, 0x2F, 0x01, 0x2A, 0x20, 0x5A, 0x63, 0x5A, 0x20, 0x20, 0x70, 0x2A, 0x65, 0x01, 0x69, 0x2F, 0x6B, 0xEB, 0x53, 0x55, 0x1A, 0x19, 
        0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x30, 0x2A, 0x0D, 0x0D, 0x96, 0x44, 0x44, 0x9C, 0x0D, 0x0D, 0x0D, 0xD7, 0x44, 0x44, 0x91, 0x7F, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x50, 0x30, 0xF0, 0x0D, 0x0D, 0x7B, 0x30, 0x30, 0x0D, 0x2A, 0x30, 0x72, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x67, 0x30, 0x7D, 0x92, 0x0D, 0x0D, 0x56, 0x30, 0x2A, 0x0D, 0x62, 0x30, 0xC2, 0x92, 0x0D, 0x0D, 0x67, 0x30, 0x2A, 0x0D, 0x2A, 0x30, 0x56, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x72, 0x30, 0x2A, 0x0D, 0x0D, 0x72, 0x30, 0x30, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x25, 0x25, 0x36, 0x9F, 0x36, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x59, 0x1A, 0x56, 0x5D, 0x19, 0x1E, 0x1E, 0x55, 0x21, 0x59, 0x59, 0x67, 0x53, 0x58, 0x5B, 0x56, 
        0x18, 0x48, 0xF0, 0x7B, 0x15, 0x12, 0xDD, 0x6F, 0xA9, 0x0D, 0x32, 0x6F, 0xDD, 0x00, 0x72, 0xF7, 0x23, 0x1C, 0x4C, 0x1D, 0x54, 0x5C, 0x21, 0x2F, 0x65, 0x2A, 0x70, 0x5A, 0x63, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x6D, 0x65, 0x01, 0x67, 0x5B, 0x58, 0x19, 
        0x4C, 0x3D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x05, 0x07, 0x07, 0x59, 0x1A, 0x56, 
        0x5D, 0x19, 0x1E, 0x1E, 0x55, 0x21, 0x59, 0x59, 0x67, 0x53, 0x58, 0x5B, 0x56, 0x18, 0x48, 0xF0, 0x7B, 0x15, 0x12, 0xDD, 0x6F, 0xA9, 0x0D, 0x32, 0x6F, 0xDD, 0x00, 0x72, 0xF7, 0x23, 0x1C, 0x4C, 0x1D, 0x54, 0x5C, 0x21, 0x2F, 0x65, 0x2A, 0x70, 0x5A, 
        0x63, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x6D, 0x65, 0x01, 0x67, 0x5B, 0x58, 0x19, 0x4C, 0x74, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x59, 0x1A, 0x56, 0x5D, 0x19, 0x1E, 0x1E, 0x55, 0x21, 0x59, 0x59, 0x67, 0x53, 0x58, 0x5B, 0x56, 0x18, 0x48, 0xF0, 0x7B, 0x15, 0x12, 0xDD, 0x6F, 0xA9, 0x0D, 0x32, 0x6F, 0xDD, 0x00, 0x72, 
        0xF7, 0x23, 0x1C, 0x4C, 0x1D, 0x54, 0x5C, 0x21, 0x2F, 0x65, 0x2A, 0x70, 0x5A, 0x63, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x6D, 0x65, 0x01, 0x67, 0x5B, 0x58, 0x19, 0x4C, 0x4D, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xFD, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x59, 0x1A, 0x56, 0x5D, 0x19, 0x1E, 0x1E, 0x55, 0x21, 0x59, 0x59, 0x67, 0x53, 0x58, 0x5B, 0x56, 0x18, 0x48, 
        0xF0, 0x7B, 0x15, 0x12, 0xDD, 0x6F, 0xA9, 0x0D, 0x32, 0x6F, 0xDD, 0x00, 0x72, 0xF7, 0x23, 0x1C, 0x4C, 0x1D, 0x54, 0x5C, 0x21, 0x2F, 0x65, 0x2A, 0x70, 0x5A, 0x63, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x6D, 0x65, 0x01, 0x67, 0x5B, 0x58, 0x19, 0x4C, 0x11, 
        0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x30, 0x2A, 0x0D, 0x0D, 0x44, 0x44, 0x91, 0x7F, 0x0D, 0x0D, 0x0D, 0x45, 0x44, 0x44, 0xA7, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0xF0, 0x30, 0x30, 0x2A, 0x67, 0x7D, 0x30, 0x62, 0x0D, 0x2A, 0x30, 0x30, 0x30, 0x30, 0x30, 0xDF, 0x72, 0x0C, 0xDF, 0x30, 0xDF, 0x2A, 0xC2, 0x30, 0x30, 0x2A, 0x0D, 0x52, 0xDF, 0x30, 0xDF, 0x2A, 0x7D, 0x30, 0x30, 0x2A, 0x0D, 0x2A, 0x30, 0x30, 0x30, 
        0x30, 0x30, 0x30, 0xF0, 0x72, 0x30, 0x2A, 0x0D, 0x0D, 0x0D, 0x30, 0x30, 0x52, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x25, 0x25, 0x36, 0x36, 0x36, 0x89, 0x3E, 0x3E, 0x3E, 0x29,
  0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x7C, 0x7C, 0x56, 0x1D, 0x4C, 0x1A, 0x5B, 0x55, 0x21, 0x21, 0x59, 0x21, 0x1E, 0x53, 0x58, 0x5B, 0x56, 0x4C, 
        0x1C, 0x41, 0x26, 0x78, 0x0E, 0x07, 0x0C, 0x92, 0x0D, 0x0D, 0x32, 0x6F, 0xDD, 0x00, 0x72, 0x2C, 0x75, 0xAB, 0x18, 0x56, 0x5B, 0x19, 0x67, 0x59, 0x62, 0x65, 0x2A, 0x70, 0x20, 0x63, 0x63, 0x5A, 0x20, 0x70, 0x70, 0x2A, 0x65, 0x56, 0x57, 0x1B, 0x18, 
        0x19, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x52, 0x52, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x18, 0x1D, 0x4C, 
        0x1A, 0x5B, 0x55, 0x21, 0x21, 0x59, 0x21, 0x1E, 0x53, 0x58, 0x5B, 0x56, 0x4C, 0x1C, 0x41, 0x26, 0x78, 0x0E, 0x07, 0x0C, 0x92, 0x0D, 0x0D, 0x32, 0x6F, 0xDD, 0x00, 0x72, 0x2C, 0x75, 0xAB, 0x18, 0x56, 0x5B, 0x19, 0x67, 0x59, 0x62, 0x65, 0x2A, 0x70, 
        0x20, 0x63, 0x63, 0x5A, 0x20, 0x70, 0x70, 0x2A, 0x65, 0x56, 0x57, 0x1B, 0x18, 0x19, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x06, 0x06, 
        0x04, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x5E, 0x1D, 0x4C, 0x1A, 0x5B, 0x55, 0x21, 0x21, 0x59, 0x21, 0x1E, 0x53, 0x58, 0x5B, 0x56, 0x4C, 0x1C, 0x41, 0x26, 0x78, 0x0E, 0x07, 0x0C, 0x92, 0x0D, 0x0D, 0x32, 0x6F, 0xDD, 0x00, 0x72, 
        0x2C, 0x75, 0xAB, 0x18, 0x56, 0x5B, 0x19, 0x67, 0x59, 0x62, 0x65, 0x2A, 0x70, 0x20, 0x63, 0x63, 0x5A, 0x20, 0x70, 0x70, 0x2A, 0x65, 0x56, 0x57, 0x1B, 0x18, 0x58, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x50, 0x1D, 0x4C, 0x1A, 0x5B, 0x55, 0x21, 0x21, 0x59, 0x21, 0x1E, 0x53, 0x58, 0x5B, 0x56, 0x4C, 0x1C, 0x41, 
        0x26, 0x78, 0x0E, 0x07, 0x0C, 0x92, 0x0D, 0x0D, 0x32, 0x6F, 0xDD, 0x00, 0x72, 0x2C, 0x75, 0xAB, 0x18, 0x56, 0x5B, 0x19, 0x67, 0x59, 0x62, 0x65, 0x2A, 0x70, 0x20, 0x63, 0x63, 0x5A, 0x20, 0x70, 0x70, 0x2A, 0x65, 0x56, 0x57, 0x1B, 0x18, 0x19, 0x00, 
        0x00, 0x12, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x30, 0x2A, 0x0D, 0x0D, 0xD8, 0x86, 0x83, 0x0D, 0x0D, 0x0D, 0x0D, 0x83, 0x86, 0x83, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0xF0, 0xC2, 0x30, 0x30, 0x7D, 0x67, 0x92, 0x0D, 0x56, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x52, 0x0D, 0x0C, 0x67, 0xDF, 0x30, 0xDF, 0x56, 0x62, 0x62, 0x0D, 0x0D, 0x52, 0x62, 0xDF, 0x30, 0x7D, 0x56, 0x2A, 0x62, 0x0D, 0xF0, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x7B, 0x52, 0x2A, 0x56, 0x0D, 0x0D, 0x0D, 0x62, 0x7D, 0x0C, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36,
  0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0xF8, 0x15, 0x02, 0x02, 0x02, 0x4D, 0x1E, 0x50, 0x4C, 0x56, 0x58, 0x59, 0x59, 0x55, 0x1E, 0x19, 0x54, 0x5D, 0x56, 0x4C, 0x5E, 
        0x16, 0x75, 0x2C, 0x72, 0x12, 0xDD, 0x6F, 0x32, 0x0D, 0x0D, 0x32, 0x08, 0xDD, 0x00, 0x7E, 0x2C, 0x74, 0x16, 0x5E, 0x47, 0x1D, 0x54, 0x53, 0x55, 0x59, 0x69, 0x65, 0x2A, 0x70, 0x20, 0x63, 0x34, 0x5A, 0x20, 0x20, 0x70, 0x1B, 0x50, 0x47, 0x56, 0x4C, 
        0xF0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x27, 0x53, 0x50, 
        0x4C, 0x56, 0x58, 0x59, 0x59, 0x55, 0x1E, 0x19, 0x54, 0x5D, 0x56, 0x4C, 0x5E, 0x16, 0x75, 0x2C, 0x72, 0x12, 0xDD, 0x6F, 0x32, 0x0D, 0x0D, 0x32, 0x08, 0xDD, 0x00, 0x7E, 0x2C, 0x74, 0x16, 0x5E, 0x47, 0x1D, 0x54, 0x53, 0x55, 0x59, 0x69, 0x65, 0x2A, 
        0x70, 0x20, 0x63, 0x34, 0x5A, 0x20, 0x20, 0x70, 0x1B, 0x50, 0x47, 0x56, 0x4C, 0x26, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 
        0x06, 0x06, 0x0C, 0x0C, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x06, 0x12, 0x53, 0x50, 0x4C, 0x56, 0x58, 0x59, 0x59, 0x55, 0x1E, 0x19, 0x54, 0x5D, 0x56, 0x4C, 0x5E, 0x16, 0x75, 0x2C, 0x72, 0x12, 0xDD, 0x6F, 0x32, 0x0D, 0x0D, 0x32, 0x08, 0xDD, 0x00, 0x7E, 
        0x2C, 0x74, 0x16, 0x5E, 0x47, 0x1D, 0x54, 0x53, 0x55, 0x59, 0x69, 0x65, 0x2A, 0x70, 0x20, 0x63, 0x34, 0x5A, 0x20, 0x20, 0x70, 0x1B, 0x50, 0x47, 0x56, 0x4C, 0x0B, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x09, 0x53, 0x50, 0x4C, 0x56, 0x58, 0x59, 0x59, 0x55, 0x1E, 0x19, 0x54, 0x5D, 0x56, 0x4C, 0x5E, 0x16, 0x75, 
        0x2C, 0x72, 0x12, 0xDD, 0x6F, 0x32, 0x0D, 0x0D, 0x32, 0x08, 0xDD, 0x00, 0x7E, 0x2C, 0x74, 0x16, 0x5E, 0x47, 0x1D, 0x54, 0x53, 0x55, 0x59, 0x69, 0x65, 0x2A, 0x70, 0x20, 0x63, 0x34, 0x5A, 0x20, 0x20, 0x70, 0x1B, 0x50, 0x47, 0x56, 0x4C, 0x11, 0x12, 
        0x12, 0x10, 0x12, 0x12, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x30, 0x2A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x4F, 0x33, 0x51, 0xF8, 0xF8, 0x7C, 0x7C, 0xF8, 0x7C, 0x7C, 0x7C, 0x7C, 0x51, 0x7C, 0x02, 0x02, 0x4C, 0x5B, 0x1C, 0x18, 0x56, 0x1E, 0x55, 0x5C, 0x19, 0x54, 0x5D, 0x56, 0x4C, 0x5E, 0xAB, 
        0x23, 0x7B, 0x15, 0x6E, 0x07, 0x06, 0x1F, 0x9A, 0x0D, 0x9A, 0x92, 0x08, 0xDD, 0x00, 0x7E, 0x78, 0x26, 0xF0, 0x1C, 0x4C, 0x56, 0x5B, 0x58, 0x5C, 0x55, 0x2F, 0x69, 0x65, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x5A, 0x5A, 0x2F, 0x16, 0x48, 0x50, 0x16, 0x58, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x14, 0x14, 0x1C, 0x5B, 
        0x1C, 0x18, 0x56, 0x1E, 0x55, 0x5C, 0x19, 0x54, 0x5D, 0x56, 0x4C, 0x5E, 0xAB, 0x23, 0x7B, 0x15, 0x6E, 0x07, 0x06, 0x1F, 0x9A, 0x0D, 0x9A, 0x92, 0x08, 0xDD, 0x00, 0x7E, 0x78, 0x26, 0xF0, 0x1C, 0x4C, 0x56, 0x5B, 0x58, 0x5C, 0x55, 0x2F, 0x69, 0x65, 
        0x2A, 0x70, 0x20, 0x5A, 0x63, 0x5A, 0x5A, 0x2F, 0x16, 0x48, 0x50, 0x16, 0x58, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x3F, 0x5B, 0x1C, 0x18, 0x56, 0x1E, 0x55, 0x5C, 0x19, 0x54, 0x5D, 0x56, 0x4C, 0x5E, 0xAB, 0x23, 0x7B, 0x15, 0x6E, 0x07, 0x06, 0x1F, 0x9A, 0x0D, 0x9A, 0x92, 0x08, 0xDD, 0x00, 0x7E, 
        0x78, 0x26, 0xF0, 0x1C, 0x4C, 0x56, 0x5B, 0x58, 0x5C, 0x55, 0x2F, 0x69, 0x65, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x5A, 0x5A, 0x2F, 0x16, 0x48, 0x50, 0x16, 0x54, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x16, 0x5B, 0x1C, 0x18, 0x56, 0x1E, 0x55, 0x5C, 0x19, 0x54, 0x5D, 0x56, 0x4C, 0x5E, 0xAB, 0x23, 0x7B, 
        0x15, 0x6E, 0x07, 0x06, 0x1F, 0x9A, 0x0D, 0x9A, 0x92, 0x08, 0xDD, 0x00, 0x7E, 0x78, 0x26, 0xF0, 0x1C, 0x4C, 0x56, 0x5B, 0x58, 0x5C, 0x55, 0x2F, 0x69, 0x65, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x5A, 0x5A, 0x2F, 0x16, 0x48, 0x50, 0x16, 0x58, 0x12, 0x12, 
        0x00, 0x00, 0x12, 0x12, 0x12, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0x2A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x30, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x25,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x1E, 0x50, 0x1C, 0x18, 0x56, 0xEB, 0x19, 0x1B, 0x5D, 0x56, 0x47, 0x50, 0xAB, 0x23, 
        0x26, 0x78, 0x7E, 0x12, 0xDD, 0x0A, 0x32, 0x0D, 0x0D, 0xA9, 0x92, 0x0A, 0xDD, 0x00, 0x0E, 0x78, 0x7B, 0x23, 0xAB, 0x50, 0x1A, 0x1D, 0x1B, 0x19, 0x1E, 0x21, 0x2F, 0x69, 0x6D, 0x2A, 0x20, 0x20, 0x63, 0x63, 0x70, 0x41, 0x75, 0x16, 0x41, 0x5B, 0x15, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x19, 
        0x50, 0x1C, 0x18, 0x56, 0xEB, 0x19, 0x1B, 0x5D, 0x56, 0x47, 0x50, 0xAB, 0x23, 0x26, 0x78, 0x7E, 0x12, 0xDD, 0x0A, 0x32, 0x0D, 0x0D, 0xA9, 0x92, 0x0A, 0xDD, 0x00, 0x0E, 0x78, 0x7B, 0x23, 0xAB, 0x50, 0x1A, 0x1D, 0x1B, 0x19, 0x1E, 0x21, 0x2F, 0x69, 
        0x6D, 0x2A, 0x20, 0x20, 0x63, 0x63, 0x70, 0x41, 0x75, 0x16, 0x41, 0x5B, 0x73, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x19, 0x50, 0x1C, 0x18, 0x56, 0xEB, 0x19, 0x1B, 0x5D, 0x56, 0x47, 0x50, 0xAB, 0x23, 0x26, 0x78, 0x7E, 0x12, 0xDD, 0x0A, 0x32, 0x0D, 0x0D, 0xA9, 0x92, 0x0A, 0xDD, 0x00, 0x0E, 
        0x78, 0x7B, 0x23, 0xAB, 0x50, 0x1A, 0x1D, 0x1B, 0x19, 0x1E, 0x21, 0x2F, 0x69, 0x6D, 0x2A, 0x20, 0x20, 0x63, 0x63, 0x70, 0x41, 0x75, 0x16, 0x41, 0x5B, 0x12, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x19, 0x50, 0x1C, 0x18, 0x56, 0xEB, 0x19, 0x1B, 0x5D, 0x56, 0x47, 0x50, 0xAB, 0x23, 0x26, 0x78, 
        0x7E, 0x12, 0xDD, 0x0A, 0x32, 0x0D, 0x0D, 0xA9, 0x92, 0x0A, 0xDD, 0x00, 0x0E, 0x78, 0x7B, 0x23, 0xAB, 0x50, 0x1A, 0x1D, 0x1B, 0x19, 0x1E, 0x21, 0x2F, 0x69, 0x6D, 0x2A, 0x20, 0x20, 0x63, 0x63, 0x70, 0x41, 0x75, 0x16, 0x41, 0x5B, 0x02, 0x14, 0x14, 
        0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x93, 0xDF, 0x92, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x92, 0xDF, 0x93, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36,
  0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x33, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x33, 0xF8, 0x7C, 0x7C, 0x7C, 0x15, 0x02, 0x37, 0x55, 0x48, 0x1C, 0x18, 0x56, 0x1B, 0x1D, 0x56, 0x47, 0x50, 0x48, 0xF0, 0x74, 
        0x2C, 0x15, 0x73, 0x07, 0x06, 0x1F, 0x32, 0x0D, 0x0D, 0xA9, 0x1F, 0x0A, 0xDD, 0x00, 0x0E, 0x15, 0x7B, 0x75, 0x16, 0x1C, 0x47, 0x56, 0x5B, 0x58, 0x53, 0x55, 0x59, 0x2F, 0x01, 0x2A, 0x2A, 0x70, 0x20, 0x20, 0x41, 0x78, 0x7B, 0x75, 0x1C, 0x5E, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x52, 0x52, 0x02, 
        0x55, 0x48, 0x1C, 0x18, 0x56, 0x1B, 0x1D, 0x56, 0x47, 0x50, 0x48, 0xF0, 0x74, 0x2C, 0x15, 0x73, 0x07, 0x06, 0x1F, 0x32, 0x0D, 0x0D, 0xA9, 0x1F, 0x0A, 0xDD, 0x00, 0x0E, 0x15, 0x7B, 0x75, 0x16, 0x1C, 0x47, 0x56, 0x5B, 0x58, 0x53, 0x55, 0x59, 0x2F, 
        0x01, 0x2A, 0x2A, 0x70, 0x20, 0x20, 0x41, 0x78, 0x7B, 0x75, 0x1C, 0x48, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x12, 0x55, 0x48, 0x1C, 0x18, 0x56, 0x1B, 0x1D, 0x56, 0x47, 0x50, 0x48, 0xF0, 0x74, 0x2C, 0x15, 0x73, 0x07, 0x06, 0x1F, 0x32, 0x0D, 0x0D, 0xA9, 0x1F, 0x0A, 0xDD, 0x00, 0x0E, 
        0x15, 0x7B, 0x75, 0x16, 0x1C, 0x47, 0x56, 0x5B, 0x58, 0x53, 0x55, 0x59, 0x2F, 0x01, 0x2A, 0x2A, 0x70, 0x20, 0x20, 0x41, 0x78, 0x7B, 0x75, 0x1C, 0x16, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x52, 0x55, 0x48, 0x1C, 0x18, 0x56, 0x1B, 0x1D, 0x56, 0x47, 0x50, 0x48, 0xF0, 0x74, 0x2C, 0x15, 
        0x73, 0x07, 0x06, 0x1F, 0x32, 0x0D, 0x0D, 0xA9, 0x1F, 0x0A, 0xDD, 0x00, 0x0E, 0x15, 0x7B, 0x75, 0x16, 0x1C, 0x47, 0x56, 0x5B, 0x58, 0x53, 0x55, 0x59, 0x2F, 0x01, 0x2A, 0x2A, 0x70, 0x20, 0x20, 0x41, 0x78, 0x7B, 0x75, 0x1C, 0x1C, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x59, 0x30, 0xDF, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0xDF, 0x30, 0x80, 0x36, 0x36, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x3B, 0x3B,
  0x33, 0xF8, 0x15, 0x7C, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x4C, 0x5B, 0x16, 0x1C, 0x18, 0x1A, 0x56, 0x47, 0x50, 0x48, 0x41, 0x75, 0x7B, 
        0x15, 0x0E, 0x00, 0xDD, 0x0A, 0x92, 0x9A, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x00, 0x0E, 0x15, 0x2C, 0x74, 0x41, 0x48, 0x18, 0x1A, 0x1D, 0x1B, 0x19, 0x1E, 0x55, 0x6B, 0x62, 0x01, 0x2A, 0x70, 0x2A, 0x23, 0x6E, 0x72, 0x2C, 0x75, 0x19, 0x12, 0x12, 
        0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x1C, 0x5B, 0x16, 0x1C, 0x18, 0x1A, 0x56, 0x47, 0x50, 0x48, 0x41, 0x75, 0x7B, 0x15, 0x0E, 0x00, 0xDD, 0x0A, 0x92, 0x9A, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x00, 0x0E, 0x15, 0x2C, 0x74, 0x41, 0x48, 0x18, 0x1A, 0x1D, 0x1B, 0x19, 0x1E, 0x55, 0x6B, 
        0x62, 0x01, 0x2A, 0x70, 0x2A, 0x23, 0x6E, 0x72, 0x2C, 0x75, 0x54, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x16, 0x5B, 0x16, 0x1C, 0x18, 0x1A, 0x56, 0x47, 0x50, 0x48, 0x41, 0x75, 0x7B, 0x15, 0x0E, 0x00, 0xDD, 0x0A, 0x92, 0x9A, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x00, 0x0E, 
        0x15, 0x2C, 0x74, 0x41, 0x48, 0x18, 0x1A, 0x1D, 0x1B, 0x19, 0x1E, 0x55, 0x6B, 0x62, 0x01, 0x2A, 0x70, 0x2A, 0x23, 0x6E, 0x72, 0x2C, 0x75, 0x54, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x3F, 0x5B, 0x16, 0x1C, 0x18, 0x1A, 0x56, 0x47, 0x50, 0x48, 0x41, 0x75, 0x7B, 0x15, 0x0E, 
        0x00, 0xDD, 0x0A, 0x92, 0x9A, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x00, 0x0E, 0x15, 0x2C, 0x74, 0x41, 0x48, 0x18, 0x1A, 0x1D, 0x1B, 0x19, 0x1E, 0x55, 0x6B, 0x62, 0x01, 0x2A, 0x70, 0x2A, 0x23, 0x6E, 0x72, 0x2C, 0x75, 0x58, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x59, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 
        0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 
        0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x80, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29,
  0x61, 0x61, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x51, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x54, 0x1A, 0x16, 0x48, 0x18, 0x47, 0x18, 0x48, 0x16, 0x23, 0x26, 0x78, 
        0x72, 0x73, 0x07, 0x06, 0x6F, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x00, 0x6E, 0x15, 0x2C, 0x26, 0xF0, 0x48, 0x50, 0x47, 0x57, 0x5B, 0x58, 0x53, 0x67, 0x21, 0x2F, 0x69, 0x65, 0x01, 0x2C, 0x05, 0x12, 0x6E, 0x2C, 0x58, 0x02, 0x14, 0x14, 
        0x14, 0x07, 0x07, 0x07, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x5D, 0x1A, 0x16, 0x48, 0x18, 0x47, 0x18, 0x48, 0x16, 0x23, 0x26, 0x78, 0x72, 0x73, 0x07, 0x06, 0x6F, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x00, 0x6E, 0x15, 0x2C, 0x26, 0xF0, 0x48, 0x50, 0x47, 0x57, 0x5B, 0x58, 0x53, 0x67, 0x21, 
        0x2F, 0x69, 0x65, 0x01, 0x2C, 0x05, 0x12, 0x6E, 0x2C, 0x58, 0x73, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x57, 0x1A, 0x16, 0x48, 0x18, 0x47, 0x18, 0x48, 0x16, 0x23, 0x26, 0x78, 0x72, 0x73, 0x07, 0x06, 0x6F, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x00, 0x6E, 
        0x15, 0x2C, 0x26, 0xF0, 0x48, 0x50, 0x47, 0x57, 0x5B, 0x58, 0x53, 0x67, 0x21, 0x2F, 0x69, 0x65, 0x01, 0x2C, 0x05, 0x12, 0x6E, 0x2C, 0x58, 0x00, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1D, 0x1A, 0x16, 0x48, 0x18, 0x47, 0x18, 0x48, 0x16, 0x23, 0x26, 0x78, 0x72, 0x73, 
        0x07, 0x06, 0x6F, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x00, 0x6E, 0x15, 0x2C, 0x26, 0xF0, 0x48, 0x50, 0x47, 0x57, 0x5B, 0x58, 0x53, 0x67, 0x21, 0x2F, 0x69, 0x65, 0x01, 0x2C, 0x05, 0x12, 0x6E, 0x2C, 0x58, 0x02, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x15, 0x33, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x0F, 0x0F, 0x35, 0x35, 0x0F, 0x0F, 0x35, 0x35, 0x0F, 0x35, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x8D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x60, 0x60, 0x60,
  0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x1B, 0x4C, 0x41, 0x48, 0x18, 0x47, 0x48, 0x23, 0x26, 0x2C, 0x15, 
        0x6E, 0x00, 0x98, 0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x9A, 0x32, 0x1F, 0xFD, 0x98, 0x52, 0x6E, 0x72, 0x2C, 0x26, 0x23, 0x16, 0x1C, 0x18, 0x1A, 0x1D, 0x1B, 0x19, 0x5C, 0x55, 0x6B, 0x2F, 0x1E, 0x12, 0x08, 0x06, 0x05, 0x72, 0x5B, 0x03, 0x10, 0x10, 0x10, 
        0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x5D, 0x4C, 0x41, 0x48, 0x18, 0x47, 0x48, 0x23, 0x26, 0x2C, 0x15, 0x6E, 0x00, 0x98, 0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x9A, 0x32, 0x1F, 0xFD, 0x98, 0x52, 0x6E, 0x72, 0x2C, 0x26, 0x23, 0x16, 0x1C, 0x18, 0x1A, 0x1D, 0x1B, 0x19, 0x5C, 0x55, 
        0x6B, 0x2F, 0x1E, 0x12, 0x08, 0x06, 0x05, 0x72, 0x5D, 0x73, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x56, 0x4C, 0x41, 0x48, 0x18, 0x47, 0x48, 0x23, 0x26, 0x2C, 0x15, 0x6E, 0x00, 0x98, 0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x9A, 0x32, 0x1F, 0xFD, 0x98, 0x52, 0x6E, 
        0x72, 0x2C, 0x26, 0x23, 0x16, 0x1C, 0x18, 0x1A, 0x1D, 0x1B, 0x19, 0x5C, 0x55, 0x6B, 0x2F, 0x1E, 0x12, 0x08, 0x06, 0x05, 0x72, 0x5D, 0x00, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xFD, 0x0A, 0x0A, 0xFD, 0xFD, 0xFD, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0C, 0x56, 0x4C, 0x41, 0x48, 0x18, 0x47, 0x48, 0x23, 0x26, 0x2C, 0x15, 0x6E, 0x00, 
        0x98, 0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x9A, 0x32, 0x1F, 0xFD, 0x98, 0x52, 0x6E, 0x72, 0x2C, 0x26, 0x23, 0x16, 0x1C, 0x18, 0x1A, 0x1D, 0x1B, 0x19, 0x5C, 0x55, 0x6B, 0x2F, 0x1E, 0x12, 0x08, 0x06, 0x05, 0x72, 0x5D, 0x0E, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x33, 0x33, 0x33, 
        0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x03, 0x33, 0x33, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x39, 0x61, 0x61, 0x0B, 0x0B, 0x37, 
        0x37, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x60, 0x60, 0x4B, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x17, 0x68, 0x68, 0x68,
  0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0xF5, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0xF8, 0x51, 0x7C, 0x37, 0x67, 0x18, 0x16, 0x1C, 0x18, 0x47, 0x16, 0x2C, 0x78, 0x7E, 
        0x73, 0x07, 0x06, 0x08, 0x92, 0x9A, 0x0D, 0x0D, 0x9A, 0x92, 0x6F, 0xFD, 0x98, 0x52, 0x6E, 0x72, 0x78, 0x7B, 0x75, 0x16, 0x1C, 0x18, 0x47, 0x57, 0x5B, 0x54, 0xEB, 0x1E, 0x21, 0x47, 0x1F, 0x32, 0x1F, 0x0A, 0x6E, 0x58, 0x16, 0x09, 0x09, 0x09, 0x09, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x10, 0x1E, 0x18, 0x16, 0x1C, 0x18, 0x47, 0x16, 0x2C, 0x78, 0x7E, 0x73, 0x07, 0x06, 0x08, 0x92, 0x9A, 0x0D, 0x0D, 0x9A, 0x92, 0x6F, 0xFD, 0x98, 0x52, 0x6E, 0x72, 0x78, 0x7B, 0x75, 0x16, 0x1C, 0x18, 0x47, 0x57, 0x5B, 0x54, 0xEB, 0x1E, 
        0x21, 0x47, 0x1F, 0x32, 0x1F, 0x0A, 0x6E, 0x58, 0x75, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x12, 0x1E, 0x18, 0x16, 0x1C, 0x18, 0x47, 0x16, 0x2C, 0x78, 0x7E, 0x73, 0x07, 0x06, 0x08, 0x92, 0x9A, 0x0D, 0x0D, 0x9A, 0x92, 0x6F, 0xFD, 0x98, 0x52, 0x6E, 
        0x72, 0x78, 0x7B, 0x75, 0x16, 0x1C, 0x18, 0x47, 0x57, 0x5B, 0x54, 0xEB, 0x1E, 0x21, 0x47, 0x1F, 0x32, 0x1F, 0x0A, 0x6E, 0x58, 0x4D, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x73, 0x1E, 0x18, 0x16, 0x1C, 0x18, 0x47, 0x16, 0x2C, 0x78, 0x7E, 0x73, 0x07, 
        0x06, 0x08, 0x92, 0x9A, 0x0D, 0x0D, 0x9A, 0x92, 0x6F, 0xFD, 0x98, 0x52, 0x6E, 0x72, 0x78, 0x7B, 0x75, 0x16, 0x1C, 0x18, 0x47, 0x57, 0x5B, 0x54, 0xEB, 0x1E, 0x21, 0x47, 0x1F, 0x32, 0x1F, 0x0A, 0x6E, 0x58, 0x26, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 
        0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x33, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x39, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 
        0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x4B, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x68, 0x68, 0x68, 0x46, 0x71, 0x4E, 0x4E, 0x4E, 0x4E,
  0x6C, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x39, 0x8E, 0xA0, 0x1E, 0x4C, 0x16, 0x1C, 0x18, 0x1A, 0x48, 0x15, 0x6E, 
        0x52, 0x05, 0x0C, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0xA9, 0x92, 0x6F, 0x0C, 0x98, 0x52, 0x73, 0x72, 0x78, 0x7B, 0x74, 0x41, 0x48, 0x50, 0x4C, 0x56, 0x1D, 0x1B, 0x19, 0x58, 0xF7, 0x0D, 0x0D, 0x0D, 0x32, 0x73, 0x5B, 0xF0, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x73, 0x19, 0x4C, 0x16, 0x1C, 0x18, 0x1A, 0x48, 0x15, 0x6E, 0x52, 0x05, 0x0C, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0xA9, 0x92, 0x6F, 0x0C, 0x98, 0x52, 0x73, 0x72, 0x78, 0x7B, 0x74, 0x41, 0x48, 0x50, 0x4C, 0x56, 0x1D, 0x1B, 0x19, 0x58, 
        0xF7, 0x0D, 0x0D, 0x0D, 0x32, 0x73, 0x5D, 0x74, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 
        0x0A, 0x0C, 0x0A, 0x0A, 0x0C, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x12, 0x19, 0x4C, 0x16, 0x1C, 0x18, 0x1A, 0x48, 0x15, 0x6E, 0x52, 0x05, 0x0C, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0xA9, 0x92, 0x6F, 0x0C, 0x98, 0x52, 0x73, 
        0x72, 0x78, 0x7B, 0x74, 0x41, 0x48, 0x50, 0x4C, 0x56, 0x1D, 0x1B, 0x19, 0x58, 0xF7, 0x0D, 0x0D, 0x0D, 0x32, 0x73, 0x5D, 0x0B, 0x0C, 0x0C, 0x0C, 0x0A, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x12, 0x19, 0x4C, 0x16, 0x1C, 0x18, 0x1A, 0x48, 0x15, 0x6E, 0x52, 0x05, 
        0x0C, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0xA9, 0x92, 0x6F, 0x0C, 0x98, 0x52, 0x73, 0x72, 0x78, 0x7B, 0x74, 0x41, 0x48, 0x50, 0x4C, 0x56, 0x1D, 0x1B, 0x19, 0x58, 0xF7, 0x0D, 0x0D, 0x0D, 0x32, 0x73, 0x5D, 0x26, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x14, 0x52, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x33, 0x4F, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x39, 0x8E, 0x61, 0x61, 0x0B, 0x37, 0x37, 0x37, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 
        0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0x8D, 0x3D, 0x3D, 0x11, 0x11, 0x76, 0x76, 0x76, 0x4B, 0x4B, 0x3F, 0x17, 0x17, 0x17, 0x46, 0x46, 0x46, 0x46, 0x46, 0x4E, 0x71, 0x4E, 0x4E,
  0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x1B, 0x57, 0x16, 0x48, 0x18, 0x1A, 0x47, 0x7B, 
        0x07, 0x04, 0x0A, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x08, 0x0C, 0x05, 0x52, 0x73, 0x7E, 0x78, 0x2C, 0x26, 0x23, 0xAB, 0x1C, 0x18, 0x1A, 0x57, 0x5B, 0x18, 0x7E, 0x0C, 0x92, 0xA9, 0x9A, 0x15, 0x19, 0x4F, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x5D, 0x57, 0x16, 0x48, 0x18, 0x1A, 0x47, 0x7B, 0x07, 0x04, 0x0A, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x08, 0x0C, 0x05, 0x52, 0x73, 0x7E, 0x78, 0x2C, 0x26, 0x23, 0xAB, 0x1C, 0x18, 0x1A, 0x57, 0x5B, 0x18, 0x7E, 
        0x0C, 0x92, 0xA9, 0x9A, 0x15, 0x58, 0x12, 0xFD, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1D, 0x57, 0x16, 0x48, 0x18, 0x1A, 0x47, 0x7B, 0x07, 0x04, 0x0A, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x08, 0x0C, 0x05, 0x52, 0x73, 
        0x7E, 0x78, 0x2C, 0x26, 0x23, 0xAB, 0x1C, 0x18, 0x1A, 0x57, 0x5B, 0x18, 0x7E, 0x0C, 0x92, 0xA9, 0x9A, 0x15, 0x58, 0x12, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1D, 0x57, 0x16, 0x48, 0x18, 0x1A, 0x47, 0x7B, 0x07, 0x04, 
        0x0A, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x08, 0x0C, 0x05, 0x52, 0x73, 0x7E, 0x78, 0x2C, 0x26, 0x23, 0xAB, 0x1C, 0x18, 0x1A, 0x57, 0x5B, 0x18, 0x7E, 0x0C, 0x92, 0xA9, 0x9A, 0x15, 0x58, 0x0E, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x33, 0x4F, 0x4F, 0x03, 0x03, 0xF5, 0x61, 0x61, 0x0B, 0x0B, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0x3D, 0x3D, 
        0x11, 0x11, 0x11, 0x76, 0x76, 0x60, 0x4B, 0x4B, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x61, 0x61, 0x61, 0x61, 0x8E, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0xF8, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x1A, 0x19, 0x48, 0x1C, 0x18, 0x1A, 0x1D, 
        0x47, 0x78, 0x08, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x08, 0x06, 0x05, 0x52, 0x73, 0x7E, 0x15, 0x2C, 0x26, 0x23, 0x16, 0x48, 0x50, 0x47, 0x1A, 0x1C, 0x7B, 0x15, 0x00, 0x06, 0x0A, 0x16, 0x19, 0x03, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 
        0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x50, 0x19, 0x48, 0x1C, 0x18, 0x1A, 0x1D, 0x47, 0x78, 0x08, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x08, 0x06, 0x05, 0x52, 0x73, 0x7E, 0x15, 0x2C, 0x26, 0x23, 0x16, 0x48, 0x50, 0x47, 0x1A, 0x1C, 0x7B, 0x15, 
        0x00, 0x06, 0x0A, 0x16, 0x58, 0x09, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x1C, 0x19, 0x48, 0x1C, 0x18, 0x1A, 0x1D, 0x47, 0x78, 0x08, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x08, 0x06, 0x05, 0x52, 0x73, 
        0x7E, 0x15, 0x2C, 0x26, 0x23, 0x16, 0x48, 0x50, 0x47, 0x1A, 0x1C, 0x7B, 0x15, 0x00, 0x06, 0x0A, 0x16, 0x54, 0x14, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 
        0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x5E, 0x19, 0x48, 0x1C, 0x18, 0x1A, 0x1D, 0x47, 0x78, 
        0x08, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x08, 0x06, 0x05, 0x52, 0x73, 0x7E, 0x15, 0x2C, 0x26, 0x23, 0x16, 0x48, 0x50, 0x47, 0x1A, 0x1C, 0x7B, 0x15, 0x00, 0x06, 0x0A, 0x16, 0x58, 0x09, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x15, 0x7C, 0x33, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x8E, 0x61, 0x61, 0x61, 0x0B, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 
        0xA0, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x60, 0x4B, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x17, 0x68, 0x46, 0x46, 0x46, 0x46, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25,
  0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x7C, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x6C, 0x1E, 0x4C, 0x1C, 0x18, 0x1A, 
        0x1D, 0x1B, 0x5B, 0x23, 0x04, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x08, 0x06, 0x05, 0x52, 0x73, 0x0E, 0x15, 0x2C, 0x26, 0x75, 0x41, 0x47, 0x54, 0x58, 0x1D, 0x18, 0x41, 0x7B, 0x15, 0x78, 0x5B, 0x18, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x14, 0x14, 0x14, 0x00, 0x00, 0x52, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x04, 
        0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x7E, 0x53, 0x4C, 0x1C, 0x18, 0x1A, 0x1D, 0x1B, 0x5B, 0x23, 0x04, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x08, 0x06, 0x05, 0x52, 0x73, 0x0E, 0x15, 0x2C, 0x26, 0x75, 0x41, 0x47, 0x54, 0x58, 0x1D, 0x18, 0x41, 0x7B, 
        0x15, 0x78, 0x5B, 0x3F, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x09, 0x53, 0x4C, 0x1C, 0x18, 0x1A, 0x1D, 0x1B, 0x5B, 0x23, 0x04, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x08, 0x06, 0x05, 0x52, 0x73, 
        0x0E, 0x15, 0x2C, 0x26, 0x75, 0x41, 0x47, 0x54, 0x58, 0x1D, 0x18, 0x41, 0x7B, 0x15, 0x78, 0x5B, 0x16, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0E, 0x53, 0x4C, 0x1C, 0x18, 0x1A, 0x1D, 0x1B, 
        0x5B, 0x23, 0x04, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x08, 0x06, 0x05, 0x52, 0x73, 0x0E, 0x15, 0x2C, 0x26, 0x75, 0x41, 0x47, 0x54, 0x58, 0x1D, 0x18, 0x41, 0x7B, 0x15, 0x78, 0x5B, 0x48, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x52, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x15, 0x33, 0x4F, 0x03, 0x03, 0x03, 0x8E, 0x39, 0x61, 0x61, 0x0B, 0x37, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0x8D, 0x3D, 
        0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x60, 0x4B, 0x3F, 0x4B, 0x3F, 0x17, 0x17,
  0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x1A, 0xEB, 0x5E, 0x50, 
        0x1A, 0x1D, 0x1B, 0x19, 0x67, 0xEB, 0x5E, 0x26, 0x6E, 0x98, 0x0A, 0x06, 0x98, 0x52, 0x73, 0x72, 0x75, 0x1A, 0x1E, 0x6D, 0x5A, 0x20, 0x01, 0x21, 0x19, 0x1D, 0x18, 0x75, 0x18, 0x19, 0x03, 0x09, 0x09, 0x10, 0x10, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x10, 0x12, 0x00, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x13, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x04, 0x04, 0x18, 0xEB, 0x5E, 0x50, 0x1A, 0x1D, 0x1B, 0x19, 0x67, 0xEB, 0x5E, 0x26, 0x6E, 0x98, 0x0A, 0x06, 0x98, 0x52, 0x73, 0x72, 0x75, 0x1A, 0x1E, 0x6D, 0x5A, 0x20, 0x01, 0x21, 0x19, 0x1D, 0x18, 0x75, 
        0x18, 0x58, 0x09, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x5E, 0xEB, 0x5E, 0x50, 0x1A, 0x1D, 0x1B, 0x19, 0x67, 0xEB, 0x5E, 0x26, 0x6E, 0x98, 0x0A, 0x06, 0x98, 0x52, 0x73, 
        0x72, 0x75, 0x1A, 0x1E, 0x6D, 0x5A, 0x20, 0x01, 0x21, 0x19, 0x1D, 0x18, 0x75, 0x18, 0x54, 0x07, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x6F, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1C, 0xEB, 0x5E, 0x50, 0x1A, 0x1D, 
        0x1B, 0x19, 0x67, 0xEB, 0x5E, 0x26, 0x6E, 0x98, 0x0A, 0x06, 0x98, 0x52, 0x73, 0x72, 0x75, 0x1A, 0x1E, 0x6D, 0x5A, 0x20, 0x01, 0x21, 0x19, 0x1D, 0x18, 0x75, 0x18, 0x58, 0x73, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 
        0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x33, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x39, 0x39, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x6C, 0x35, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0x8D, 0x3D, 0x3D, 0x11, 0x11, 0x76, 0x76, 0x76, 0x4B, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x68, 0x68, 0x46, 0x46,
  0x33, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x33, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x8E, 0x1E, 0x54, 
        0x5E, 0x4C, 0x1D, 0x1B, 0x19, 0x1E, 0x21, 0x2F, 0x65, 0x2A, 0x20, 0x70, 0x20, 0xC2, 0xC1, 0xDF, 0x30, 0x30, 0x30, 0x93, 0x4A, 0x34, 0x20, 0x65, 0x55, 0x18, 0x18, 0x19, 0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0E, 0x53, 0x54, 0x5E, 0x4C, 0x1D, 0x1B, 0x19, 0x1E, 0x21, 0x2F, 0x65, 0x2A, 0x20, 0x70, 0x20, 0xC2, 0xC1, 0xDF, 0x30, 0x30, 0x30, 0x93, 0x4A, 0x34, 0x20, 0x65, 0x55, 0x18, 0x18, 0x58, 
        0x4D, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x12, 0x19, 0x54, 0x5E, 0x4C, 0x1D, 0x1B, 0x19, 0x1E, 0x21, 0x2F, 0x65, 0x2A, 0x20, 0x70, 0x20, 0xC2, 0xC1, 
        0xDF, 0x30, 0x30, 0x30, 0x93, 0x4A, 0x34, 0x20, 0x65, 0x55, 0x18, 0x18, 0x58, 0x4D, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x14, 0x19, 0x54, 0x5E, 0x4C, 
        0x1D, 0x1B, 0x19, 0x1E, 0x21, 0x2F, 0x65, 0x2A, 0x20, 0x70, 0x20, 0xC2, 0xC1, 0xDF, 0x30, 0x30, 0x30, 0x93, 0x4A, 0x34, 0x20, 0x65, 0x55, 0x18, 0x18, 0x19, 0x74, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x52, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x33, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x39, 0x8E, 0x61, 0x61, 0x61, 
        0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0x3D, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x3F, 0x3F, 0x17,
  0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0xF8, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x0B, 
        0x1A, 0x53, 0x47, 0x4C, 0x5B, 0x19, 0x1E, 0x21, 0x2F, 0x65, 0x2A, 0x20, 0x5A, 0x34, 0xC1, 0x4A, 0x93, 0x30, 0x30, 0x30, 0x93, 0x94, 0x59, 0x1A, 0x1D, 0x19, 0x16, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 
        0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x02, 0x50, 0x53, 0x47, 0x4C, 0x5B, 0x19, 0x1E, 0x21, 0x2F, 0x65, 0x2A, 0x20, 0x5A, 0x34, 0xC1, 0x4A, 0x93, 0x30, 0x30, 0x30, 0x93, 0x94, 0x59, 0x1A, 0x1D, 0x54, 0x26, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x04, 0x04, 0x06, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x06, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0E, 0x5E, 0x53, 0x47, 0x4C, 0x5B, 0x19, 0x1E, 0x21, 0x2F, 0x65, 0x2A, 0x20, 0x5A, 0x34, 0xC1, 
        0x4A, 0x93, 0x30, 0x30, 0x30, 0x93, 0x94, 0x59, 0x1A, 0x1D, 0x54, 0x4D, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x09, 0x1C, 0x53, 
        0x47, 0x4C, 0x5B, 0x19, 0x1E, 0x21, 0x2F, 0x65, 0x2A, 0x20, 0x5A, 0x34, 0xC1, 0x4A, 0x93, 0x30, 0x30, 0x30, 0x93, 0x94, 0x59, 0x1A, 0x1D, 0x54, 0x26, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x3C, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x07, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x33, 0x4F, 0x4F, 0x03, 0x03, 0x03, 
        0x8E, 0x39, 0x39, 0x61, 0x0B, 0x37, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0x81, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D,
  0x0B, 0x61, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0xF8, 0xF8, 0xF8, 0x7C, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 
        0x09, 0x03, 0x50, 0x53, 0x19, 0x56, 0x47, 0x1D, 0xEB, 0x2F, 0x01, 0x2A, 0x20, 0x5A, 0x34, 0x7A, 0x94, 0x34, 0x2A, 0x55, 0x1D, 0x5D, 0x19, 0x47, 0x4D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x1C, 0x19, 0x19, 0x56, 0x47, 0x1D, 0xEB, 0x2F, 0x01, 0x2A, 0x20, 0x5A, 0x34, 0x7A, 0x94, 0x34, 0x2A, 0x55, 0x1D, 0x5D, 0x58, 0x50, 0x15, 0x04, 0x04, 0x13, 
        0x13, 0x04, 0x13, 0x13, 0x13, 0x04, 0x04, 0x13, 0x04, 0x04, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x12, 0x16, 0x19, 0x19, 0x56, 0x47, 0x1D, 0xEB, 0x2F, 0x01, 0x2A, 0x20, 0x5A, 0x34, 
        0x7A, 0x94, 0x34, 0x2A, 0x55, 0x1D, 0x5D, 0x58, 0x1C, 0x09, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x43, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x43, 0x6F, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 
        0x43, 0x43, 0x6F, 0x6F, 0x43, 0x43, 0x43, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x6F, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x52, 
        0x16, 0x19, 0x19, 0x56, 0x47, 0x1D, 0xEB, 0x2F, 0x01, 0x2A, 0x20, 0x5A, 0x34, 0x7A, 0x94, 0x34, 0x2A, 0x55, 0x1D, 0x5D, 0x58, 0x5E, 0x7E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x13, 0x13, 
        0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x61, 0x8E, 0x61, 0x8E, 0x8E, 
        0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x11, 0x76, 0x76, 0x76, 0x76,
  0x61, 0x61, 0x61, 0x8E, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x4F, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x02, 0x02, 0x27, 0x27, 0x27, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x17, 0x56, 0x1B, 0x1E, 0x1B, 0x57, 0x47, 0x4C, 0x18, 0x47, 0x1A, 0x1D, 0x19, 0x19, 0x54, 0x3F, 0x4D, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x13, 0x13, 0x74, 0x50, 0x1D, 0x1E, 0x1B, 0x57, 0x47, 0x4C, 0x18, 0x47, 0x1A, 0x1D, 0x19, 0x1B, 0x1D, 0x26, 0x73, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x08, 0x08, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x6F, 0x43, 0x43, 0x43, 0x08, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x4D, 0x1C, 0x56, 0x1E, 0x1B, 0x57, 0x47, 0x4C, 0x18, 0x47, 
        0x1A, 0x1D, 0x19, 0x1B, 0x57, 0x4D, 0x52, 0x08, 0x0A, 0x0A, 0x08, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x4D, 0x5E, 0x57, 0x1E, 0x1B, 0x57, 0x47, 0x4C, 0x18, 0x47, 0x1A, 0x1D, 0x19, 0x1B, 0x57, 0x4D, 0x00, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 
        0x04, 0x3C, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x33, 0x33, 0x4F, 0x33, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x39, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 
        0x37, 0x35, 0x35, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D,
  0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0xF5, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x33, 0xF8, 0x15, 0x7C, 0x7C, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 
        0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x0A, 0x0A, 
        0x08, 0x08, 0x08, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x33, 0x4F, 0x4F, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 
        0x39, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x11, 0x11, 0x76, 0x76, 0x76, 0x4B, 0x4B, 0x3F, 0x17,
  0x7C, 0x15, 0x15, 0x15, 0xF8, 0x51, 0x7C, 0x7C, 0xF8, 0x33, 0x33, 0x51, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0xF8, 0x51, 0x15, 0x33, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x07, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x13, 
        0x13, 0x3C, 0x3C, 0x13, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x6F, 0x6F, 0x6F, 0x6F, 
        0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x6F, 0x6F, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x43, 0x43, 0x43, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x07, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x09, 0x09, 0x09, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x33, 0x4F, 0x33, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x61, 0x61, 0x61, 0x0B, 0x0B, 
        0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76,
  0x8E, 0x8E, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xFD, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 
        0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x33, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x6C, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0,
  0x6C, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0xF8, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x52, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x3C, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x43, 0x43, 0x1F, 0x43, 0x43, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x43, 
        0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x14, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x15, 0xF8, 0x4F, 0x4F, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x8E, 0x8E, 0x61, 0x8E, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x6C, 0x6C, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0,
  0x0F, 0x0F, 0x35, 0x35, 0x6C, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x0A, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 
        0x43, 0x08, 0x08, 0x08, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x52, 0x52, 0x14, 0x52, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x33, 0x4F, 0x03, 0x03, 0x8E, 0x61, 0x61, 0x0B, 0x0B, 0x37, 0x6C, 0x6C, 0x0F, 0x0F, 0xA0, 0xA0, 0x79, 0x8D, 0x3D, 0x11, 0x11, 0x11,
  0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x02, 0x02, 0x02, 
        0x27, 0x27, 0x02, 0x02, 0x27, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x04, 
        0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x6F, 
        0x6F, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 
        0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x15, 0x15, 0x15, 0x15, 0x7C, 0x33, 0x33, 0x33, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x39, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x35, 0x0F,
  0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x7C, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x3C, 0x13, 0x13, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0xFD, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x13, 0x05, 0x13, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x3C, 0x13, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 
        0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x15, 0x15, 0x15, 0x15, 0x33, 0x33, 0x33, 0x33, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x61, 0x61, 0x61, 0x39, 0x39, 0x61, 0x61, 0x61,
  0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x15, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x3C, 0x04, 0x04, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x6F, 
        0x6F, 0x6F, 0x6F, 0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x6F, 0x6F, 0x6F, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x14, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 
        0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x33, 0x4F, 0x4F, 
        0x03, 0x03, 0x8E, 0x8E, 0x61, 0x61, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0x81, 0x81, 0x81, 0xA0, 0x79, 0x79, 0x79, 0x79, 0x79, 0x3D,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x04, 0x13, 0x04, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x43, 0x6F, 
        0x43, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x43, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x43, 0x1F, 0x1F, 0x6F, 0x43, 0x43, 0x6F, 0x43, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 
        0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 
        0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x14, 0x52, 0x14, 0x14, 0x14, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x15, 0x4F, 
        0x03, 0x03, 0x8E, 0x39, 0x61, 0x0B, 0x37, 0x35, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x60, 0x60, 0x4B, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17,
  0x8E, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0xF8, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 
        0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x52, 0x52, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x06, 0x0C, 0x06, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x43, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x06, 
        0x06, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 
        0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 
        0x15, 0x15, 0x33, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x39, 0x39, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x35, 0x6C, 0x0F, 0x0F, 0x0F, 0x0F,
  0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x14, 0x14, 0x52, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x3C, 0x05, 0x05, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x05, 0x3C, 0x05, 0x05, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x6F, 0x43, 0x08, 0x43, 0x43, 0x08, 0x08, 0x43, 0x43, 0x08, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 
        0x04, 0x04, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x27, 
        0x27, 0x02, 0x02, 0x02, 0x15, 0x4F, 0x4F, 0x03, 0x03, 0x8E, 0x61, 0x0B, 0x37, 0x37, 0x37, 0x0F, 0x0F, 0xA0, 0xA0, 0x81, 0x79, 0x3D, 0x11, 0x11, 0x76, 0x76, 0x60, 0x60,
  0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x52, 0x14, 0x00, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x52, 0x52, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x6F, 0x6F, 
        0x6F, 0x1F, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x6F, 0x6F, 0x43, 0x43, 0x43, 0x6F, 0x6F, 0x43, 0x6F, 0x08, 0x08, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x15, 0x33, 0x33, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x39, 0x39, 0x39, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B,
  0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x1F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 
        0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x6F, 0x6F, 0x08, 0x08, 0x08, 0x08, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x07, 0x07, 0x07, 0x14, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x33, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x39, 0x61, 0x61, 0x0B, 0x0B, 0x37, 0x37, 0x0F, 0x0F, 0x0F, 0x0F,
  0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0xF8, 0x15, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 
        0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x52, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x43, 0x43, 0x08, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x1F, 0x6F, 0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x08, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x07, 0x07, 0x07, 0x14, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 
        0x15, 0x15, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x39, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37,
  0x61, 0x61, 0x61, 0x8E, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x08, 0x08, 0x43, 0x6F, 0x6F, 0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 
        0x1F, 0x1F, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 
        0x33, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x0F,
  0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0xF8, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x07, 0x07, 0x05, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x08, 0x08, 0x08, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0A, 0x0A, 0x0A, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 
        0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x02, 0x02, 0x7C, 0x51, 0x4F, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x61, 0x61, 0x0B, 0x37, 0x37, 0x6C,
  0x15, 0x15, 0x15, 0xF8, 0x33, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x61, 0x61, 0x61, 0x8E, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0xF8, 0x7C, 0x15, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 
        0x07, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x08, 0x08, 0x08, 0x43, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x6F, 0x43, 0x6F, 0x43, 
        0x6F, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 
        0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 
        0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15,
  0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 
        0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x08, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x43, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 
        0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 
        0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 
        0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 0x05, 0x13, 0x13, 0x05, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x08, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 
        0x3C, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 
        0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x7C, 0xF8, 0x33, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x61, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
  0x8E, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x14, 0x14, 0x52, 0x52, 
        0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x06, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
  0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 
        0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x0A, 
        0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x0A, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x43, 0x43, 0x08, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x08, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 
        0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x33, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x61, 0x8E,
  0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x02, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x52, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x0C, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 
        0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 
        0x14, 0x52, 0x14, 0x14, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0xF8, 0xF8, 0x33, 0x4F, 0x4F,
  0x35, 0x35, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x33, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x14, 0x14, 0x14, 0x14, 0x52, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x05, 0x05, 0x05, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x13, 
        0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 
        0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x43, 0x6F, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x6F, 0x1F, 0x1F, 0x6F, 0x1F, 0x1F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 
        0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0A, 0x0A, 0x0C, 0x0A, 0x0A, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xFD, 0xFD, 0x0C, 0xFD, 0xFD, 0xFD, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 
        0x04, 0x3C, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x15, 0x15, 0x33, 0x33, 0x33, 0x4F, 0x4F, 0x03, 0x03, 0x03,
  0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x03, 0x03, 0x8E, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 
        0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 
        0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x43, 0x43, 0x43, 0x6F, 0x43, 0x43, 0x6F, 0x43, 0x6F, 0x6F, 0x1F, 0x6F, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x6F, 0x6F, 0x01, 0x6F, 0x6F, 0x6F, 0x01, 0x1F, 0x1F, 
        0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x01, 0x01, 0x1F, 0x1F, 0x43, 0x6F, 0x6F, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 
        0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x07, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 
        0x10, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x15, 0x33, 0x33, 0x33, 0x33, 0x15,
  0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x1F, 0x1F, 0x1F, 0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 
        0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x6F, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x01, 0x08, 0x08, 0x08, 0x01, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x01, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x04, 0x04, 0x04, 0x13, 
        0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x52, 0x52, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 
        0x09, 0x09, 0x0E, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x15, 0x33, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x39, 0x39, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x61, 0x61, 0x0B,
  0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x6C, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x39, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0xF8, 
        0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x14, 0x52, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0A, 0x0A, 0x0A, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 
        0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x1F, 0x1F, 0x6F, 0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x6F, 0x6F, 0x6F, 0x6F, 0x08, 0x43, 0x43, 0x01, 0x08, 0x08, 0x08, 0x01, 0x08, 0x08, 
        0x01, 0x01, 0x01, 0x08, 0x0A, 0x0A, 0x0A, 0x01, 0x0A, 0x0A, 0x0A, 0x01, 0x0A, 0x0A, 0x0A, 0x01, 0x0C, 0x01, 0x01, 0x0C, 0x01, 0x0C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x7C, 0x7C, 0x51, 0x33, 0x33, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E,
  0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 
        0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0C, 0x0A, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x43, 0x43, 0x6F, 0x6F, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x01, 0x08, 0x08, 0x08, 0x01, 0x08, 0x01, 
        0x08, 0x08, 0x08, 0x01, 0x08, 0x08, 0x08, 0x01, 0x08, 0x08, 0x08, 0x01, 0x08, 0x08, 0x08, 0x01, 0x08, 0x01, 0x08, 0x01, 0x43, 0x01, 0x43, 0x01, 0x43, 0x08, 0x08, 0x01, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0xF8, 0xF8, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x0E, 0x0E, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x52, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x01, 0x08, 0x08, 0x08, 0x01, 0x08, 0x01, 
        0x08, 0x08, 0x08, 0x01, 0x08, 0x08, 0x08, 0x01, 0x08, 0x08, 0x08, 0x01, 0x08, 0x08, 0x08, 0x01, 0x43, 0x01, 0x08, 0x08, 0x08, 0x01, 0x08, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x6C, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x4F, 0xF8, 
        0x7C, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x10, 
        0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x05, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x43, 0x08, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x01, 0x0A, 0x01, 0x08, 0x0A, 0x01, 
        0x08, 0x08, 0x08, 0x01, 0x0A, 0x08, 0x08, 0x01, 0x08, 0x08, 0x08, 0x01, 0x08, 0x08, 0x01, 0x01, 0x08, 0x01, 0x08, 0x08, 0x08, 0x01, 0x08, 0x01, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x05, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x14, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 
        0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x33, 0x33, 0x33, 0x4F,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x39, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 
        0x61, 0x39, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 
        0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x08, 0x08, 0x6F, 0x43, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x43, 0x1F, 0x6F, 0x6F, 0x6F, 0x01, 0x08, 0x43, 0x08, 0x08, 
        0x01, 0x01, 0x01, 0x08, 0x08, 0x08, 0x01, 0x01, 0x01, 0x08, 0x08, 0x08, 0x01, 0x01, 0x08, 0x01, 0x08, 0x01, 0x08, 0x08, 0x08, 0x01, 0x08, 0x08, 0x01, 0x01, 0x01, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 
        0x14, 0x14, 0x14, 0x52, 0x52, 0x52, 0x07, 0x07, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x06, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x08, 0x6F, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x43, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0C, 0x0A, 0x0C, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 
        0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
  0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x61, 
        0x61, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x39, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x07, 0x14, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x08, 0x43, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x6F, 0x43, 0x43, 
        0x43, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x0A, 0x0A, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x08, 0x43, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27,
  0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x6C, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x39, 0x8E, 0x39, 0x8E, 0x8E, 0x61, 0x39, 0x8E, 0x8E, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 
        0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x08, 0x08, 0x43, 0x43, 0x08, 0x43, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x13, 
        0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x07, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x07, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02,
  0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x33, 0x4F, 0x4F, 0x33, 0xF8, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x3C, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x04, 0x04, 0x3C, 
        0x13, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x52, 0x00, 0x00, 0x14, 0x14, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x23, 0x21, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x55, 0x74, 0x1F, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x0A, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x08, 0x43, 0x43, 0x43, 0x43, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xFD, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
  0x0F, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x10, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x14, 0x52, 0x14, 0x14, 0x52, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x3F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 
        0x43, 0x43, 0x43, 0x6F, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x6F, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x6F, 0x6F, 0x08, 0x08, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02,
  0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x52, 0x52, 0x52, 0x52, 0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x14, 0x14, 0x14, 0x14, 0x52, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 
        0x13, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x4D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2C, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x08, 0x08, 0x08, 0x43, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x43, 
        0x43, 0x43, 0x43, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x6F, 0x43, 0x6F, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27,
  0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x05, 0x3C, 0x3C, 0x3C, 0x05, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x05, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x3C, 0x13, 0x3C, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x04, 0x04, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x04, 0x04, 0x06, 0x47, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4C, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x6F, 
        0x6F, 0x43, 0x6F, 0x6F, 0x1F, 0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x6F, 0x6F, 0x6F, 0x1F, 0x6F, 0x6F, 
        0x6F, 0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x61, 0x61, 0x0B, 0x61, 0x61, 0x0B, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x52, 0x52, 0x00, 
        0x52, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x43, 0x08, 0x43, 0x43, 0x43, 0x43, 0x43, 0x6F, 0x6F, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0xFD, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 
        0x04, 0x04, 0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
  0x76, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x6C, 0x6C, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 
        0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x07, 0x07, 0x07, 0x07, 0x52, 0x14, 0x14, 0x52, 0x14, 0x52, 0x52, 
        0x52, 0x52, 0x00, 0x00, 0x14, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x6F, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x05, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x14, 0x52, 0x14, 0x14, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x8D, 0x8D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 
        0x61, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x14, 0x14, 0x52, 0x52, 0x14, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1F, 0x1F, 0x1F, 0x1F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x08, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x08, 0x43, 0x08, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0C, 0x0C, 0xFD, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x00, 0x00, 0x14, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x8E, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0A, 0x0A, 0x0C, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x08, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 
        0x43, 0x73, 0x2C, 0x4D, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x16, 0x4D, 0x4D, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
  0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x61, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x52, 0x52, 0x52, 
        0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x1F, 0x1F, 0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x6F, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x09, 0x4D, 0x57, 0x19, 
        0x6B, 0x5C, 0x1B, 0x56, 0x18, 0x48, 0xA4, 0x7B, 0x78, 0x72, 0x6E, 0x73, 0x0E, 0x72, 0x78, 0x7B, 0x75, 0x16, 0x5E, 0x1A, 0x5B, 0x53, 0x53, 0x57, 0x16, 0x4D, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 
        0x4F, 0x33, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x3C, 0x3C, 0x05, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x04, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 
        0x3C, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x13, 0x13, 0x05, 0x13, 0x13, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x6F, 0x6F, 0x43, 0x43, 0x1F, 
        0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x6F, 0x6F, 0x6F, 0x6F, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x52, 0x4D, 0x57, 0x69, 0x67, 0x58, 0x1D, 0x9E, 
        0x41, 0xD4, 0x26, 0x7B, 0x2C, 0x78, 0xA2, 0x7E, 0x7E, 0x6E, 0xFC, 0xFC, 0xFC, 0x6E, 0x6E, 0x6E, 0x6E, 0x7E, 0x7E, 0x72, 0xDA, 0xA2, 0x2C, 0x41, 0x18, 0x1D, 0x5C, 0x58, 0x41, 0x09, 0x43, 0x43, 0x43, 0x08, 0x43, 0x08, 0x43, 0x43, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xA0, 0x81, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x6C, 0x6C, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x03, 0x4F, 
        0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x12, 0x12, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x07, 0x05, 0x05, 0x07, 0x07, 0x07, 0x05, 0x05, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x04, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6F, 0x1F, 0x1F, 0x1F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 
        0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x6F, 0x6F, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x14, 0x16, 0x19, 0x59, 0x5C, 0x1B, 0x1A, 0x1C, 0x48, 0xAB, 0x41, 
        0xA4, 0x75, 0xD4, 0x26, 0x7B, 0x78, 0x78, 0x72, 0x72, 0x7E, 0x6E, 0xFC, 0xFC, 0xFC, 0x73, 0x6E, 0x0E, 0x7E, 0x7E, 0x7E, 0x72, 0x72, 0x72, 0x78, 0x78, 0x78, 0x78, 0x41, 0x4C, 0x1B, 0x58, 0x1C, 0x09, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x6C, 0x6C, 0x35, 0x35, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 
        0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x13, 0x13, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x08, 0x08, 0x43, 0x43, 0x43, 0x6F, 0x43, 0x08, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x6F, 0x43, 0x08, 0x08, 0x4D, 0x57, 0x6B, 0x67, 0x58, 0x1D, 0x1A, 0x18, 0x5E, 0x1C, 0x1C, 0x48, 0x41, 
        0xA4, 0x75, 0x75, 0xD4, 0x26, 0x7B, 0xF7, 0x78, 0xA2, 0xDA, 0x7E, 0x6E, 0x6E, 0x73, 0x6E, 0x6E, 0x6E, 0x6E, 0x0E, 0x7E, 0x72, 0xDA, 0xA2, 0x15, 0x15, 0x78, 0x2C, 0xF7, 0x7B, 0x7B, 0x74, 0x50, 0x5B, 0x1B, 0x16, 0x12, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x13, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x11, 0x76, 0x11, 0x11, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x79, 0x79, 0x81, 0x81, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x13, 0x13, 0x13, 0x3C, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x08, 0x6F, 0x6F, 0x43, 0x43, 0x6F, 0xF0, 0x67, 0x21, 0x67, 0x19, 0x5B, 0x5D, 0x1D, 0x57, 0x1A, 0x47, 0x18, 0x50, 0x1C, 0x48, 
        0xAB, 0x41, 0xA4, 0x75, 0x26, 0x7B, 0xF7, 0x2C, 0x78, 0xA2, 0x72, 0x7E, 0x0E, 0x73, 0x73, 0x73, 0x6E, 0x0E, 0x7E, 0x7E, 0x72, 0x72, 0x72, 0x15, 0x15, 0x15, 0x15, 0x78, 0x2C, 0xF7, 0xF7, 0x26, 0x26, 0x41, 0x47, 0x19, 0x5E, 0x00, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12,
  0x76, 0x76, 0x11, 0x11, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 
        0x33, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x52, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 
        0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x07, 0x48, 0x62, 0x59, 0x55, 0x19, 0x58, 0x58, 0x1B, 0x5B, 0x1D, 0x56, 0x1A, 0x47, 0x4C, 0x18, 0x50, 0x1C, 
        0xAB, 0x16, 0x41, 0x23, 0x75, 0xD4, 0x74, 0x2C, 0x78, 0x15, 0x72, 0x7E, 0x0E, 0x73, 0x12, 0x73, 0x73, 0x73, 0x6E, 0x0E, 0x0E, 0x7E, 0x72, 0x7E, 0x72, 0xA2, 0x78, 0x78, 0x2C, 0x2C, 0x2C, 0x2C, 0x7B, 0x26, 0x74, 0x74, 0x50, 0x5B, 0x58, 0x09, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x06, 0x04, 0x04, 0x04, 
        0x04, 0x3C, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x0E,
  0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x39, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x15, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x6F, 0x6F, 0x43, 0x1C, 0x62, 0x59, 0x59, 0x21, 0x1E, 0x53, 0x53, 0x19, 0x1B, 0x1B, 0x5B, 0x1D, 0x57, 0x56, 0x1A, 0x4C, 0x18, 0x1C, 
        0x48, 0x41, 0x74, 0xF7, 0x78, 0x72, 0x0E, 0x73, 0x12, 0x00, 0x07, 0x05, 0x98, 0x06, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x04, 0x07, 0x12, 0x0E, 0x7E, 0x72, 0x15, 0xA2, 0xA2, 0x78, 0x2C, 0xF7, 0xF7, 0xF7, 0xF7, 0x7B, 0x26, 0x74, 0x74, 0x1C, 0x5B, 0x54, 
        0x00, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 
        0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27,
  0x81, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 
        0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x16, 0x67, 0x21, 0x55, 0x1E, 0x55, 0x55, 0x55, 0x55, 0x1E, 0x5C, 0x5C, 0x54, 0x1B, 0x5B, 0x1D, 0x1A, 0x50, 0x48, 0x41, 0x26, 
        0x7B, 0x2C, 0x78, 0x15, 0x72, 0x7E, 0x0E, 0x73, 0x12, 0x00, 0x07, 0x05, 0x98, 0x04, 0xFD, 0x0A, 0x08, 0x1F, 0x92, 0x32, 0x32, 0xA9, 0x9A, 0x92, 0x0A, 0x07, 0x0E, 0x72, 0x15, 0x15, 0x78, 0xF7, 0xF7, 0xF7, 0xF7, 0x7B, 0x74, 0x75, 0x74, 0x74, 0x1C, 
        0x1B, 0x1C, 0x00, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52,
  0x6C, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x8E, 
        0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 
        0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 
        0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x05, 0x05, 0x05, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x09, 0x19, 0x21, 0x67, 0x19, 0x58, 0x5C, 0x5C, 0x1E, 0x55, 0x55, 0x1E, 0x53, 0x19, 0xEB, 0x5B, 0x1A, 0x50, 0xAB, 0x23, 0x74, 0x74, 0x26, 
        0x26, 0xF7, 0x2C, 0x78, 0x15, 0x72, 0x0E, 0x73, 0x12, 0x00, 0x07, 0x05, 0xDD, 0x04, 0x0C, 0x6F, 0x6F, 0x1F, 0x1F, 0x92, 0x32, 0x9A, 0x0D, 0x0D, 0x0D, 0x0D, 0x9A, 0x1F, 0xDD, 0x0E, 0x2C, 0x15, 0x2C, 0x7B, 0x7B, 0x7B, 0x7B, 0x26, 0x26, 0x26, 0x75, 
        0x23, 0x18, 0x1D, 0x41, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x35, 0x37, 0x35, 0x37, 0x37, 0x35, 0x35, 0x35, 0x0F, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x37, 0x37, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0xF5, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x52, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x07, 0x52, 0x52, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x14, 0x14, 0x14, 0x52, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x1C, 0x59, 0xEB, 0x1B, 0x5D, 0x1B, 0x19, 0x19, 0x5C, 0x1E, 0x67, 0x55, 0x21, 0x5C, 0x54, 0x47, 0x50, 0x48, 0xAB, 0x16, 0x41, 0x23, 0x23, 0x26, 
        0x7B, 0x2C, 0x78, 0x78, 0x15, 0x7E, 0x0E, 0x73, 0x73, 0x12, 0x52, 0x05, 0xDD, 0x04, 0x06, 0x0A, 0x08, 0x1F, 0x92, 0x32, 0x32, 0x9A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x9A, 0x92, 0x8A, 0x0E, 0x15, 0x2C, 0xF7, 0xF7, 0xF7, 0x7B, 0x26, 0x26, 0x26, 
        0x74, 0x23, 0x41, 0x1A, 0x5D, 0x07, 0x43, 0x6F, 0x6F, 0x43, 0x1F, 0x1F, 0x1F, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x05, 0x05, 0x13, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x11, 0x3D, 0x3D, 0x79, 0x79, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x61, 0x61, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x02, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x52, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x43, 0x08, 0x14, 0x67, 0x5C, 0x5B, 0x1A, 0x1A, 0x5D, 0x1B, 0x1B, 0x58, 0xEB, 0x1E, 0x1E, 0x53, 0x1B, 0x56, 0x4C, 0x50, 0x50, 0x1C, 0x48, 0x16, 0x41, 0x23, 0x75, 0x26, 
        0x26, 0xF7, 0x2C, 0x78, 0x15, 0x72, 0x0E, 0x6E, 0x73, 0x00, 0x07, 0x05, 0xDD, 0x04, 0xFD, 0x0A, 0x6F, 0x1F, 0x92, 0x32, 0x32, 0x9A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA9, 0x32, 0x92, 0x92, 0xFD, 0x12, 0x15, 0x2C, 0x7B, 0x7B, 0x7B, 0x26, 0x74, 
        0x74, 0x74, 0x75, 0x23, 0x1C, 0x54, 0x4D, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 
        0x0C, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x06, 0x06, 0x0C, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x13, 0x13, 
        0x13, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x14, 0x14, 0x52, 0x00, 0x00,
  0x76, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 
        0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x05, 
        0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x04, 0x06, 0x06, 
        0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x16, 0x59, 0x1B, 0x50, 0x18, 0x1A, 0x56, 0x57, 0x5D, 0x5B, 0x1B, 0x54, 0x58, 0x54, 0x5B, 0x57, 0x1A, 0x4C, 0x18, 0x50, 0x1C, 0x48, 0xAB, 0x41, 0x23, 0x75, 0x74, 
        0x26, 0xF7, 0x2C, 0x78, 0x15, 0x72, 0x0E, 0x6E, 0x73, 0x00, 0x07, 0x05, 0xDD, 0x04, 0xFD, 0x0A, 0x6F, 0x1F, 0x92, 0x32, 0x32, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x9A, 0xA9, 0x32, 0x92, 0x1F, 0x08, 0x06, 0x05, 0x73, 0x72, 0x2C, 0x26, 0x7B, 0x26, 
        0x26, 0x26, 0x75, 0x23, 0x23, 0x23, 0x1A, 0x47, 0x12, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x0E, 0x09, 0x09, 0x09, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 
        0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x07, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x57, 0x5C, 0x56, 0x1C, 0x50, 0x18, 0x18, 0x4C, 0x56, 0x57, 0x56, 0x1B, 0x1B, 0x5B, 0x1D, 0x57, 0x1A, 0x47, 0x47, 0x18, 0x50, 0x5E, 0x1C, 0xAB, 0x16, 0x41, 0x23, 0x74, 
        0x26, 0x7B, 0x2C, 0x78, 0x15, 0x72, 0x7E, 0x6E, 0x73, 0x00, 0x07, 0x05, 0xDD, 0x06, 0xFD, 0x08, 0x6F, 0x1F, 0x92, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x92, 0x1F, 0x08, 0x0A, 0xFD, 0x04, 0x05, 0x12, 0x7E, 0x78, 0x7B, 0x26, 
        0x26, 0x26, 0x74, 0x23, 0x23, 0x23, 0xF0, 0x50, 0x5D, 0x12, 0x06, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
  0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x79, 0x79, 0x79, 0x79, 0x79, 0x81, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0xF5, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x7C, 
        0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x7C, 0x15, 0x15, 0x7C, 0x15, 0x15, 0x7C, 0x7C, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x3C, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x43, 
        0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x14, 0x67, 0x54, 0x1C, 0x16, 0xAB, 0xAB, 0x1C, 0x18, 0x18, 0x18, 0x56, 0x1B, 0x54, 0x54, 0x1B, 0x5B, 0x1D, 0x57, 0x1A, 0x1A, 0x4C, 0x18, 0x50, 0x1C, 0x48, 0x16, 0x41, 0x23, 0x74, 
        0x26, 0x7B, 0x2C, 0x78, 0x15, 0x72, 0x7E, 0x6E, 0x73, 0x00, 0x07, 0x05, 0xDD, 0x06, 0x0A, 0x08, 0x6F, 0x92, 0x32, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA9, 0x32, 0x92, 0x1F, 0x0A, 0x0C, 0xDD, 0x05, 0x07, 0x52, 0x12, 0x73, 0x78, 0xF7, 
        0x26, 0x26, 0x26, 0x74, 0x75, 0x75, 0x23, 0xF0, 0x48, 0x5D, 0x4D, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x06, 0x06, 0x0C, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x07, 0x14, 0x14, 0x07, 0x07, 0x14, 0x07,
  0x17, 0x17, 0x3F, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x82, 0x82, 0x60, 0x60, 0x76, 0x76, 0x76, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 
        0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x43, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x7E, 0x1E, 0x57, 0xF0, 0x23, 0x23, 0x16, 0x48, 0x48, 0x1C, 0x18, 0x1D, 0x58, 0x53, 0x58, 0x54, 0x1B, 0x5B, 0x5D, 0x57, 0x56, 0x1A, 0x47, 0x18, 0x50, 0x1C, 0x48, 0x16, 0x41, 0x23, 0x75, 
        0x26, 0x7B, 0x2C, 0x78, 0x15, 0x72, 0x7E, 0x6E, 0x73, 0x00, 0x07, 0x05, 0xDD, 0x06, 0x0A, 0x08, 0x6F, 0x92, 0x32, 0x32, 0x9A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA9, 0x32, 0x1F, 0x6F, 0x0A, 0x0C, 0xDD, 0x05, 0x07, 0x00, 0x12, 0x6E, 0x7E, 0xA2, 
        0xF7, 0x7B, 0x26, 0x26, 0x74, 0x75, 0x23, 0x23, 0x23, 0xF0, 0x57, 0x16, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x3C, 0x13, 0x13, 0x3C, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x3D, 0x79, 0x79, 0x81, 0x81, 0x81, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x15, 0x7C, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 
        0x15, 0x15, 0x15, 0x15, 0x15, 0x33, 0x4F, 0x4F, 0x33, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x15, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x52, 0x52, 0x14, 0x14, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x52, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x43, 0x43, 0x43, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x26, 0x59, 0x18, 0x7B, 0x26, 0x74, 0x23, 0x23, 0x41, 0xAB, 0x18, 0x5B, 0x5C, 0x1E, 0xEB, 0x19, 0x58, 0x1B, 0x5B, 0x5D, 0x1D, 0x56, 0x1A, 0x47, 0x4C, 0x50, 0x5E, 0x48, 0xAB, 0x41, 0x23, 0x75, 
        0x74, 0x26, 0xF7, 0x2C, 0x78, 0x15, 0x72, 0x6E, 0x73, 0x00, 0x07, 0x05, 0xDD, 0x06, 0x0A, 0x6F, 0x1F, 0x92, 0x32, 0x32, 0x9A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x92, 0x1F, 0x08, 0x0A, 0x06, 0xDD, 0x05, 0x52, 0x12, 0x6E, 0x7E, 0x72, 0x15, 
        0x78, 0xF7, 0x7B, 0x26, 0x26, 0x74, 0x74, 0x75, 0x23, 0xF0, 0x23, 0x47, 0x47, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x8E, 0x8E, 0x8E, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x4F, 0x4F, 0x33, 0x33, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x52, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x04, 0x04, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0B, 0x55, 0x1C, 0x78, 0x2C, 0xF7, 0x7B, 0x75, 0x23, 0x23, 0x50, 0x53, 0x59, 0x1E, 0x19, 0x1E, 0x53, 0x19, 0x54, 0x1B, 0x5B, 0x5D, 0x1D, 0x57, 0x1A, 0x47, 0x18, 0x50, 0x1C, 0x48, 0x16, 0x41, 0x23, 
        0x74, 0x26, 0xF7, 0x2C, 0x78, 0x15, 0x72, 0x0E, 0x73, 0x00, 0x07, 0x05, 0xDD, 0x06, 0x0A, 0x6F, 0x1F, 0x92, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x32, 0x32, 0x92, 0x6F, 0x0A, 0x06, 0xDD, 0x07, 0x00, 0x12, 0x73, 0x0E, 0x7E, 0xA2, 0x78, 
        0x2C, 0x7B, 0x26, 0x26, 0x26, 0x26, 0x26, 0x75, 0x23, 0x75, 0x23, 0xF0, 0x18, 0x4C, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x52,
  0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x01, 0x01, 0x01, 0x0B, 0x61, 0x01, 0x61, 0x61, 0x61, 0x01, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x01, 0x01, 0x01, 0x8E, 
        0x8E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x8E, 0x01, 0x01, 0x01, 0x61, 0x61, 0x8E, 0x01, 0x01, 0x01, 0x01, 0x8E, 0x8E, 0x01, 0x03, 0x03, 0x03, 0x01, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x01, 0x01, 0x01, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x08, 
        0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x4D, 0x1E, 0x16, 0x7E, 0x72, 0x78, 0x2C, 0x2C, 0x26, 0x26, 0x56, 0x55, 0x59, 0x21, 0x59, 0x55, 0xEB, 0x53, 0x19, 0x58, 0x54, 0x1B, 0x5B, 0x1D, 0x57, 0x1A, 0x47, 0x18, 0x50, 0x1C, 0x48, 0x16, 0x41, 0x23, 
        0x74, 0x26, 0x7B, 0x2C, 0x78, 0x15, 0x72, 0x0E, 0x73, 0x00, 0x07, 0x05, 0xDD, 0x06, 0x0A, 0x6F, 0x1F, 0x92, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x92, 0x1F, 0x6F, 0x0A, 0x04, 0xDD, 0x07, 0x52, 0x12, 0x6E, 0x7E, 0x72, 0x78, 0x78, 
        0x2C, 0x26, 0x74, 0x74, 0x26, 0x26, 0x26, 0x26, 0x26, 0x75, 0x23, 0x23, 0x75, 0x18, 0x18, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 
        0x04, 0x04, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14,
  0x76, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x01, 0x37, 0x37, 0x37, 0x01, 0x0B, 0x01, 0x0B, 0x0B, 0x61, 0x01, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x01, 0x8E, 0x01, 0x03, 0x03, 0x03, 0x01, 
        0x4F, 0x4F, 0x33, 0x01, 0x02, 0x02, 0x02, 0x01, 0x02, 0x02, 0x01, 0x02, 0x02, 0x01, 0x27, 0x27, 0x27, 0x01, 0x27, 0x01, 0x27, 0x27, 0x27, 0x01, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x01, 0x27, 0x01, 0x27, 0x27, 0x27, 0x01, 0x27, 0x01, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x01, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x4D, 0x1E, 0x75, 0x73, 0x0E, 0x0E, 0x78, 0x15, 0x2C, 0x2C, 0x58, 0x21, 0x62, 0x6B, 0x21, 0x59, 0x21, 0x1E, 0x5C, 0x53, 0x19, 0x58, 0x54, 0x5B, 0x5D, 0x1D, 0x56, 0x1A, 0x4C, 0x50, 0x5E, 0x1C, 0xAB, 0x41, 0x23, 
        0x75, 0x26, 0x7B, 0x2C, 0x78, 0x15, 0x7E, 0x0E, 0x73, 0x12, 0x07, 0x05, 0xDD, 0x06, 0x0A, 0x6F, 0x1F, 0x92, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA9, 0x32, 0x92, 0x1F, 0x08, 0xFD, 0xDD, 0x05, 0x52, 0x12, 0x73, 0x0E, 0x72, 0x15, 0x78, 0x2C, 
        0x26, 0x74, 0x23, 0x23, 0xF0, 0x41, 0x26, 0x26, 0x26, 0x74, 0x23, 0x75, 0x74, 0x16, 0x50, 0x4C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x04, 0x04, 0x3C, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x6C, 0x6C, 0x35, 0x6C, 0x6C, 0x6C, 0x6C, 0x37, 0x37, 0x01, 0x35, 0x37, 0x37, 0x01, 0x37, 0x01, 0x01, 0x35, 0x35, 0x01, 0x35, 0x35, 0x35, 0x35, 0x01, 0x37, 0x37, 0x01, 0x37, 0x37, 0x0B, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x01, 0x8E, 0x61, 0x8E, 0x01, 0x8E, 0x03, 0x03, 0x01, 0x03, 0x01, 0x03, 0x03, 0x03, 0x01, 0x03, 0x01, 0x4F, 0x4F, 0x4F, 0x01, 0x4F, 0x33, 0xF8, 0xF8, 0x01, 0x7C, 0x7C, 0x01, 0x7C, 0x7C, 0x02, 0x01, 0x02, 0x01, 0x02, 0x02, 0x02, 
        0x27, 0x27, 0x01, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x3C, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x3C, 0x3C, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0C, 0x0C, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x08, 0x08, 0x08, 0x08, 0x4D, 0x1E, 0x75, 0x00, 0x73, 0x73, 0x7E, 0x6E, 0x72, 0x2C, 0x1E, 0x2F, 0x69, 0x69, 0x2F, 0x59, 0x21, 0x55, 0x67, 0x1E, 0x5C, 0xEB, 0x58, 0x54, 0x1B, 0x5D, 0x1D, 0x56, 0x1A, 0x47, 0x18, 0x50, 0x1C, 0xAB, 0x16, 0x23, 
        0x75, 0x26, 0x7B, 0x2C, 0x78, 0x15, 0x72, 0x0E, 0x73, 0x12, 0x07, 0x05, 0xDD, 0x06, 0x0A, 0x6F, 0x1F, 0x92, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA9, 0x32, 0x92, 0x6F, 0x0A, 0x06, 0x98, 0x05, 0x00, 0x73, 0x6E, 0x7E, 0x15, 0x78, 0x2C, 0xF7, 
        0x26, 0x75, 0x23, 0xF0, 0x16, 0x16, 0xAB, 0x26, 0x26, 0x74, 0x75, 0x74, 0x41, 0x75, 0x23, 0x50, 0x4C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x04, 0x04, 0x04, 0x04, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0x81, 0x81, 0xA0, 0xA0, 0x01, 0x0F, 0x0F, 0x0F, 0x01, 0x0F, 0x01, 0x0F, 0x01, 0x0F, 0x01, 0x35, 0x35, 0x35, 0x01, 0x37, 0x37, 0x37, 0x37, 0x01, 0x01, 0x01, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x01, 0x0B, 0x61, 0x61, 0x01, 0x61, 0x61, 0x61, 0x01, 0x8E, 0x01, 0x01, 0x01, 0x01, 0x03, 0x03, 0x03, 0x01, 0x4F, 0x01, 0x15, 0x02, 0x02, 0x02, 0x01, 0x27, 0x27, 0x27, 0x01, 0x0E, 0x0E, 0x0E, 0x01, 0x09, 0x01, 0x01, 0x01, 0x01, 
        0x09, 0x09, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x09, 0x21, 0x74, 0x98, 0x05, 0x00, 0x12, 0x00, 0x7E, 0x78, 0x59, 0x65, 0x6D, 0x01, 0x69, 0x62, 0x2F, 0x59, 0x21, 0x21, 0x67, 0x1E, 0x53, 0x19, 0x58, 0x1B, 0x5B, 0x5D, 0x57, 0x56, 0x47, 0x4C, 0x50, 0x5E, 0x48, 0x16, 0xF0, 
        0x23, 0x74, 0x7B, 0x2C, 0x78, 0x15, 0x72, 0x0E, 0x73, 0x12, 0x07, 0x05, 0xDD, 0x06, 0x0A, 0x6F, 0x1F, 0x92, 0x32, 0x9A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x1F, 0x6F, 0xFD, 0x04, 0x05, 0x07, 0x12, 0x73, 0x0E, 0x72, 0x78, 0x2C, 0xF7, 0x26, 
        0x74, 0x23, 0xF0, 0x16, 0x48, 0x1C, 0x1C, 0x1C, 0x75, 0x74, 0x7B, 0x23, 0x75, 0x75, 0x41, 0x23, 0x18, 0x48, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x13, 0x04, 0x04, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x52,
  0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x01, 0xA0, 0xA0, 0xA0, 0x01, 0xA0, 0x01, 0xA0, 0x0F, 0x01, 0x01, 0x0F, 0x0F, 0x01, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x01, 
        0x61, 0x61, 0x8E, 0x01, 0x8E, 0x8E, 0x03, 0x01, 0x03, 0x03, 0x4F, 0x01, 0x33, 0x01, 0x15, 0x15, 0x02, 0x01, 0x02, 0x02, 0x02, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x02, 0x02, 0x02, 0x01, 0x02, 0x01, 0x15, 0x15, 0x15, 
        0x15, 0x15, 0x01, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x52, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x0A, 0x0A, 0xFD, 0xFD, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x00, 0x5C, 0x23, 0x0C, 0xDD, 0x05, 0x05, 0x52, 0x12, 0x15, 0x69, 0x2A, 0x6D, 0x6D, 0x01, 0x62, 0x69, 0x62, 0x6B, 0x59, 0x59, 0x55, 0x1E, 0x5C, 0xEB, 0x19, 0x54, 0x5B, 0x5D, 0x1D, 0x56, 0x1A, 0x47, 0x18, 0x50, 0x48, 0xAB, 0x41, 
        0x23, 0x74, 0x26, 0xF7, 0x2C, 0x15, 0x72, 0x0E, 0x6E, 0x12, 0x52, 0x05, 0xDD, 0x0C, 0x0A, 0x6F, 0x92, 0x32, 0x32, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x92, 0x1F, 0x0A, 0x06, 0xDD, 0x07, 0x52, 0x73, 0x0E, 0x7E, 0x15, 0x78, 0x2C, 0x26, 0x26, 
        0x23, 0xF0, 0x16, 0xAB, 0x1C, 0x5E, 0x5E, 0x47, 0x18, 0x26, 0x75, 0x7B, 0x75, 0x23, 0x23, 0xF0, 0x75, 0x4C, 0x4D, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x01, 0xA0, 0xA0, 0xA0, 0x01, 0xA0, 0x01, 0xA0, 0x0F, 0x0F, 0x01, 0x0F, 0x01, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x01, 0x35, 0x37, 0x37, 0x01, 
        0x37, 0x37, 0x37, 0x01, 0x37, 0x37, 0x37, 0x01, 0x0B, 0x0B, 0x01, 0x0B, 0x0B, 0x01, 0x0B, 0x0B, 0x0B, 0x01, 0x0B, 0x0B, 0x61, 0x01, 0x61, 0x61, 0x61, 0x01, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x01, 0x33, 0x15, 0x02, 0x01, 0x02, 0x01, 0x27, 0x27, 0x27, 
        0x27, 0x0E, 0x01, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x07, 0x07, 0x05, 0x05, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 
        0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x67, 0xAB, 0x1F, 0x0A, 0x06, 0x05, 0xDD, 0x05, 0x15, 0x62, 0x70, 0x70, 0x2A, 0x6D, 0x6D, 0x65, 0x01, 0x69, 0x2F, 0x6B, 0x59, 0x55, 0x67, 0x1E, 0x53, 0x19, 0x58, 0x1B, 0x5B, 0x5D, 0x57, 0x56, 0x47, 0x4C, 0x50, 0x1C, 0x48, 0x41, 
        0xF0, 0x75, 0x26, 0x7B, 0x2C, 0x15, 0x72, 0x0E, 0x6E, 0x12, 0x52, 0x05, 0xDD, 0x0C, 0x0A, 0x1F, 0x92, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA9, 0x32, 0x1F, 0x6F, 0x0A, 0x04, 0x98, 0x07, 0x12, 0x73, 0x0E, 0x72, 0x78, 0x2C, 0x7B, 0x74, 0x75, 
        0x23, 0x41, 0xAB, 0x48, 0x5E, 0x50, 0x18, 0x47, 0x47, 0x47, 0x74, 0x74, 0x26, 0x75, 0x74, 0x23, 0xF0, 0x75, 0x56, 0x7E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x3C, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x01, 0x01, 0x01, 0x0F, 0x0F, 0x01, 0x35, 0x35, 0x37, 0x01, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x01, 0x01, 0x01, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x01, 0x0B, 0x37, 0x37, 0x01, 0x01, 0x01, 0x0B, 0x0B, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x61, 0x61, 0x8E, 0x03, 0x01, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x27, 0x0E, 0x01, 0x0E, 0x09, 0x09, 
        0x09, 0x09, 0x01, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 
        0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x04, 0x04, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x57, 0x18, 0x6F, 0x6F, 0x6F, 0x0A, 0x6F, 0xDD, 0x12, 0x62, 0x5A, 0x70, 0x70, 0x2A, 0x2A, 0x2A, 0x6D, 0x01, 0x69, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x67, 0x1E, 0x53, 0x19, 0x54, 0x1B, 0x5B, 0x1D, 0x56, 0x1A, 0x4C, 0x18, 0x1C, 0x48, 0x16, 
        0xF0, 0x75, 0x26, 0x7B, 0x2C, 0x15, 0x72, 0x0E, 0x6E, 0x12, 0x52, 0x05, 0xDD, 0x0C, 0x0A, 0x1F, 0x92, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x92, 0x1F, 0x08, 0x06, 0xDD, 0x07, 0x00, 0x12, 0x0E, 0x72, 0x15, 0x78, 0x7B, 0x26, 0x75, 0x23, 
        0x41, 0xAB, 0x48, 0x1C, 0x50, 0x18, 0x1A, 0x18, 0x57, 0x57, 0x1A, 0x23, 0x26, 0x26, 0x74, 0x75, 0xF0, 0xF0, 0x23, 0x1A, 0x12, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 
        0x3C, 0x13, 0x13, 0x13, 0x05, 0x3C, 0x13, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C,
  0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x52, 0x00, 0x00, 
        0x52, 0x52, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x3C, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x3F, 0x5B, 0x0C, 0x32, 0x1F, 0x1F, 0x6F, 0x0C, 0x07, 0x62, 0x20, 0x20, 0x5A, 0x2A, 0x70, 0x2A, 0x2A, 0x6D, 0x01, 0x01, 0x69, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x5C, 0xEB, 0x58, 0x54, 0x5B, 0x5D, 0x57, 0x1A, 0x47, 0x18, 0x5E, 0x1C, 0xAB, 
        0x41, 0x23, 0x26, 0x7B, 0x2C, 0x78, 0x15, 0x7E, 0x6E, 0x12, 0x52, 0x05, 0xDD, 0xFD, 0x08, 0x1F, 0x92, 0x32, 0x9A, 0x0D, 0x0D, 0x0D, 0x0D, 0xA9, 0x32, 0x92, 0x6F, 0x0A, 0x04, 0x05, 0x52, 0x12, 0x6E, 0x7E, 0x15, 0x78, 0x2C, 0x26, 0x74, 0x23, 0xF0, 
        0x16, 0x48, 0x1C, 0x50, 0x4C, 0x47, 0x1A, 0x1D, 0x56, 0x5B, 0x1B, 0x1A, 0x23, 0x74, 0x26, 0x74, 0x75, 0x23, 0x23, 0x41, 0x1A, 0x43, 0x6F, 0x6F, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 
        0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x6C, 0x6C, 0x6C, 0x6C, 0x35, 0x6C, 0x6C, 0x6C, 0x6C, 
        0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x15, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x27, 
        0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 
        0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x52, 0x07, 0x07, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x14, 0x07, 0x07, 0x07, 0x14, 0x07, 0x07, 0x07, 0x07, 
        0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x13, 0x3C, 0x05, 0x13, 0x13, 0x13, 0x13, 
        0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xFD, 0xFD, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 
        0x00, 0x67, 0x73, 0x9A, 0xA9, 0x32, 0x92, 0x1F, 0x6F, 0x21, 0x63, 0xC2, 0x5A, 0x20, 0x20, 0x20, 0x70, 0x70, 0x2A, 0x6D, 0x65, 0x01, 0x62, 0x2F, 0x2F, 0x59, 0x21, 0x67, 0x1E, 0x53, 0x19, 0x58, 0x1B, 0x5B, 0x1D, 0x56, 0x1A, 0x4C, 0x50, 0x1C, 0xAB, 
        0x16, 0x23, 0x74, 0x26, 0x2C, 0x78, 0x15, 0x7E, 0x6E, 0x12, 0x52, 0x05, 0xDD, 0xFD, 0x08, 0x1F, 0x92, 0x32, 0x9A, 0x0D, 0x0D, 0x0D, 0x0D, 0x32, 0x32, 0x1F, 0x08, 0x0C, 0xDD, 0x07, 0x00, 0x73, 0x0E, 0x72, 0x78, 0x2C, 0x7B, 0x74, 0x23, 0xF0, 0xF0, 
        0xAB, 0x1C, 0x50, 0x18, 0x47, 0x1A, 0x56, 0x1D, 0x5B, 0x5B, 0x1B, 0x54, 0x1A, 0x74, 0x26, 0x74, 0x74, 0x74, 0x23, 0xF0, 0x1C, 0x3D, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07,
  0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x6C, 0x35, 0x6C, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 
        0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x61, 0x8E, 0x8E, 0x8E, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x61, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x00, 0x14, 0x52, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x07, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6F, 0x1F, 0x1F, 0x1F, 0x1F, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x67, 0x7B, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x32, 0x1B, 0x20, 0x34, 0x63, 0x63, 0x20, 0x5A, 0x20, 0x20, 0x70, 0x70, 0x2A, 0x6D, 0x65, 0x69, 0x62, 0x2F, 0x6B, 0x21, 0x55, 0x67, 0x5C, 0xEB, 0x19, 0x54, 0x5B, 0x1D, 0x57, 0x1A, 0x47, 0x18, 0x5E, 0x48, 
        0x16, 0x23, 0x74, 0x26, 0x2C, 0x78, 0x15, 0x7E, 0x6E, 0x12, 0x52, 0x05, 0xDD, 0xFD, 0x08, 0x1F, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x92, 0x6F, 0x0A, 0x04, 0x05, 0x52, 0x12, 0x6E, 0x7E, 0x15, 0x2C, 0x7B, 0x26, 0x75, 0x23, 0x16, 0x48, 
        0x1C, 0x50, 0x18, 0x47, 0x1A, 0x56, 0x1D, 0x5B, 0x1B, 0x1B, 0x58, 0xEB, 0x58, 0x1D, 0x7B, 0x74, 0x74, 0x7B, 0x41, 0x74, 0x23, 0x47, 0x0E, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x3C, 0x3C, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x04, 0x3C, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x05, 0x3C, 0x3C, 0x3C, 0x3C, 0x05,
  0x3D, 0x79, 0x81, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0xF8, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x15, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x03, 0x33, 0x33, 0x4F, 0x33, 0xF8, 0x15, 0x15, 0x15, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 
        0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x00, 0x52, 0x52, 0x14, 0x14, 0x52, 
        0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x52, 0x52, 0x52, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x43, 0x6F, 0x6F, 0x43, 0x6F, 0x6F, 0x6F, 0x43, 0x6F, 0x6F, 0x6F, 0x6F, 0x43, 0x43, 0x43, 0x6F, 0x43, 0x43, 0x43, 0x6F, 0x43, 0x1C, 
        0x47, 0xA9, 0x0D, 0x0D, 0x0D, 0x9A, 0x0D, 0x23, 0x20, 0xC1, 0x63, 0x63, 0x34, 0x5A, 0x5A, 0x20, 0x20, 0x20, 0x70, 0x2A, 0x2A, 0x6D, 0x01, 0x69, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x53, 0x19, 0x58, 0x1B, 0x5D, 0x1D, 0x56, 0x1A, 0x18, 0x50, 0x48, 
        0x16, 0xF0, 0x75, 0x26, 0xF7, 0x78, 0x15, 0x7E, 0x0E, 0x12, 0x52, 0x05, 0xDD, 0x0A, 0x08, 0x1F, 0x32, 0x32, 0x0D, 0x0D, 0x0D, 0x0D, 0xA9, 0x32, 0x1F, 0x08, 0x0C, 0xDD, 0x07, 0x00, 0x73, 0x0E, 0x72, 0x78, 0x2C, 0x26, 0x74, 0x23, 0x41, 0xAB, 0x48, 
        0x5E, 0x18, 0x4C, 0x1A, 0x56, 0x57, 0x5D, 0x1B, 0x54, 0x54, 0x19, 0x5C, 0x1E, 0xEB, 0x18, 0x2C, 0x26, 0x74, 0x26, 0x75, 0x23, 0x23, 0x1A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x3C, 0x3C, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x25, 0x4E, 0x71, 0x46, 0x46, 0x68, 0x17, 0x17, 0x3F, 0x4B, 0x76, 0x76, 0x76, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x6C, 0x6C, 0x6C, 0x6C, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x35, 0x35, 0x35, 0x0F, 0x0F, 0x35, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x8E, 0x61, 0x61, 0x61, 0x03, 
        0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x12, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x52, 0x00, 0x14, 0x52, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x52, 0x52, 0x52, 0x52, 0x14, 0x07, 0x07, 0x05, 0x05, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x7E, 0x67, 
        0x73, 0x9A, 0x9A, 0x0D, 0x0D, 0x32, 0xDD, 0x70, 0x5A, 0x63, 0x20, 0x63, 0x34, 0x5A, 0x63, 0x63, 0x20, 0x20, 0x70, 0x70, 0x2A, 0x2A, 0x65, 0x01, 0x69, 0x62, 0x2F, 0x59, 0x21, 0x67, 0x1E, 0x53, 0x19, 0x54, 0x5B, 0x5D, 0x57, 0x1A, 0x4C, 0x18, 0x1C, 
        0x48, 0x41, 0x23, 0x74, 0x7B, 0x2C, 0x78, 0x72, 0x0E, 0x12, 0x52, 0x05, 0xDD, 0x0A, 0x6F, 0x92, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x1F, 0x0A, 0x04, 0x05, 0x52, 0x73, 0x0E, 0x72, 0x15, 0x2C, 0x7B, 0x74, 0x23, 0x41, 0xAB, 0x1C, 0x5E, 
        0x18, 0x4C, 0x1A, 0x56, 0x1D, 0x5D, 0x1B, 0x54, 0x58, 0x19, 0xEB, 0x1E, 0x55, 0x21, 0x1E, 0x41, 0x26, 0x26, 0x26, 0x26, 0x23, 0x23, 0xAB, 0x3F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14,
  0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 0x60, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x79, 0x79, 
        0x81, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x6C, 0x6C, 0x6C, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x4F, 0x33, 0x15, 0x15, 0x15, 
        0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 
        0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x52, 0x52, 0x00, 0x00, 0x14, 0x00, 0x52, 0x52, 0x00, 0x14, 0x14, 
        0x14, 0x52, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x53, 0x16, 
        0x08, 0x1F, 0x0D, 0x32, 0x0D, 0x0D, 0x6B, 0x20, 0x70, 0x5A, 0x63, 0x34, 0x63, 0x5A, 0x63, 0x5A, 0x5A, 0x20, 0x20, 0x70, 0x70, 0x2A, 0x2A, 0x6D, 0x01, 0x69, 0x62, 0x2F, 0x59, 0x55, 0x1E, 0x5C, 0x19, 0x58, 0x1B, 0x5B, 0x1D, 0x56, 0x47, 0x18, 0x5E, 
        0x48, 0x16, 0x23, 0x74, 0x7B, 0x2C, 0x78, 0x72, 0x0E, 0x12, 0x52, 0x05, 0x04, 0x0A, 0x6F, 0x92, 0x32, 0x9A, 0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x1F, 0x6F, 0x0C, 0xDD, 0x07, 0x12, 0x6E, 0x7E, 0x15, 0x78, 0x7B, 0x26, 0x23, 0xF0, 0xAB, 0x48, 0x5E, 0x50, 
        0x4C, 0x1A, 0x56, 0x1D, 0x5D, 0x1B, 0x54, 0x58, 0x19, 0x5C, 0x1E, 0x1E, 0x55, 0x21, 0x2F, 0x19, 0x74, 0x26, 0x7B, 0x74, 0x7B, 0x23, 0x75, 0x47, 0x12, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07,
  0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 
        0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 
        0x4F, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 
        0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x13, 0x13, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x16, 0x54, 0x52, 
        0x0C, 0x08, 0x92, 0xA9, 0x0D, 0x1C, 0x2A, 0x20, 0x20, 0x20, 0x5A, 0x5A, 0x5A, 0x63, 0x34, 0x5A, 0x63, 0x5A, 0x20, 0x20, 0x70, 0x70, 0x2A, 0x2A, 0x65, 0x01, 0x69, 0x2F, 0x6B, 0x21, 0x55, 0x1E, 0x53, 0x19, 0x54, 0x5B, 0x5D, 0x56, 0x1A, 0x4C, 0x50, 
        0x1C, 0x16, 0xF0, 0x75, 0x26, 0x2C, 0x78, 0x72, 0x0E, 0x12, 0x52, 0x05, 0x04, 0x0A, 0x6F, 0x92, 0x32, 0x9A, 0x0D, 0x0D, 0x0D, 0xA9, 0x32, 0x1F, 0x08, 0x06, 0x05, 0x52, 0x73, 0x0E, 0x72, 0x78, 0x2C, 0x26, 0x75, 0x23, 0x16, 0x48, 0x1C, 0x18, 0x4C, 
        0x1A, 0x56, 0x1D, 0x5D, 0x1B, 0x54, 0x19, 0xEB, 0x5C, 0x67, 0x55, 0x55, 0x21, 0x21, 0x59, 0x2F, 0x1A, 0x2C, 0x74, 0x7B, 0x26, 0x74, 0x23, 0x75, 0x1A, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x76, 0x76, 0x76, 0x76, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x35, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 
        0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 
        0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x1E, 0x16, 0x52, 
        0x05, 0x06, 0x08, 0x92, 0x52, 0x2A, 0x70, 0x2A, 0x70, 0x70, 0x70, 0x20, 0x5A, 0x5A, 0x34, 0x34, 0x63, 0x63, 0x5A, 0x5A, 0x20, 0x70, 0x70, 0x2A, 0x6D, 0x65, 0x01, 0x69, 0x2F, 0x59, 0x21, 0x55, 0x5C, 0x53, 0x58, 0x1B, 0x5B, 0x1D, 0x1A, 0x47, 0x50, 
        0x5E, 0xAB, 0x41, 0x23, 0x26, 0x2C, 0x78, 0x72, 0x0E, 0x73, 0x52, 0x05, 0x04, 0x0A, 0x6F, 0x92, 0x32, 0x9A, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x6F, 0x0A, 0xDD, 0x07, 0x12, 0x6E, 0x72, 0x15, 0x2C, 0x7B, 0x74, 0x23, 0x41, 0x48, 0x1C, 0x50, 0x47, 0x1A, 
        0x56, 0x1D, 0x5B, 0x1B, 0x58, 0x58, 0x5C, 0x5C, 0x1E, 0x55, 0x21, 0x59, 0x59, 0x2F, 0x21, 0x59, 0x21, 0x41, 0x7B, 0xF7, 0x74, 0x26, 0x74, 0x74, 0x5E, 0x09, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 
        0x13, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07,
  0x25, 0x25, 0x25, 0x4E, 0x68, 0x46, 0x68, 0x17, 0x3F, 0x3F, 0x4B, 0x60, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x0F, 0x0F, 0x6C, 0x6C, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 
        0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x52, 0x00, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0A, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x5E, 0x1B, 0x15, 0x6E, 
        0x07, 0x07, 0x04, 0x0A, 0x53, 0x65, 0x70, 0x2A, 0x20, 0x70, 0x20, 0x5A, 0x5A, 0x20, 0x20, 0x63, 0x63, 0x63, 0x63, 0x5A, 0x5A, 0x20, 0x70, 0x70, 0x2A, 0x2A, 0x65, 0x01, 0x69, 0x2F, 0x59, 0x21, 0x67, 0x5C, 0x19, 0x58, 0x1B, 0x5D, 0x56, 0x1A, 0x18, 
        0x50, 0x48, 0x41, 0x23, 0x26, 0xF7, 0x78, 0x15, 0x0E, 0x73, 0x52, 0x05, 0x04, 0x0A, 0x1F, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x06, 0x05, 0x00, 0x73, 0x7E, 0x15, 0x2C, 0x7B, 0x26, 0x23, 0x16, 0xAB, 0x1C, 0x50, 0x4C, 0x1A, 0x56, 
        0x1D, 0x5B, 0x1B, 0x58, 0x19, 0x53, 0x1E, 0x1E, 0x55, 0x21, 0x21, 0x59, 0x6B, 0x59, 0x21, 0x59, 0x55, 0x19, 0xF7, 0x75, 0x2C, 0x26, 0x26, 0x74, 0x7B, 0x1A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x4E, 0x4E, 0x4E, 0x46, 0x46, 0x46, 0x68, 0x68, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x4B, 0x60, 0x76, 0x76, 0x76, 0x11, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x02, 0x02, 0x27, 
        0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x52, 0x2F, 0x1C, 0x78, 0x72, 
        0x0E, 0x07, 0xDD, 0x16, 0x2A, 0x2A, 0x65, 0x2A, 0x2A, 0x2A, 0x70, 0x70, 0x20, 0x5A, 0x20, 0x5A, 0x63, 0x63, 0x63, 0x63, 0x5A, 0x20, 0x20, 0x20, 0x70, 0x2A, 0x6D, 0x65, 0x01, 0x62, 0x2F, 0x59, 0x55, 0x1E, 0x53, 0x58, 0x54, 0x5B, 0x1D, 0x56, 0x4C, 
        0x50, 0x1C, 0x16, 0x23, 0x74, 0x7B, 0x2C, 0x15, 0x7E, 0x73, 0x52, 0x05, 0x04, 0x08, 0x1F, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x6F, 0xFD, 0xDD, 0x07, 0x12, 0x6E, 0x72, 0x78, 0x2C, 0x26, 0x75, 0xF0, 0xAB, 0x1C, 0x50, 0x4C, 0x47, 0x56, 0x1D, 
        0x5B, 0x1B, 0x58, 0x19, 0x53, 0x1E, 0x1E, 0x21, 0x59, 0x6B, 0x6B, 0x6B, 0x59, 0x21, 0x21, 0x1E, 0x1E, 0x67, 0x18, 0x7B, 0x26, 0x7B, 0x26, 0x26, 0x26, 0xAB, 0x41, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 
        0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x3C, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x46, 0x68, 0x46, 0x71, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x71, 0x4E, 0x71, 0x4E, 0x71, 0x46, 0x46, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 
        0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0xF8, 0xF8, 0xF8, 0x51, 0x51, 0x7C, 0x15, 0x7C, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x3C, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x5E, 0x58, 0x74, 0x26, 0x78, 
        0x7E, 0x0E, 0x72, 0x59, 0x65, 0x65, 0x69, 0x2A, 0x2A, 0x2A, 0x70, 0x70, 0x70, 0x20, 0x20, 0x20, 0x5A, 0x5A, 0x63, 0x63, 0x63, 0x63, 0x5A, 0x20, 0x70, 0x70, 0x2A, 0x6D, 0x65, 0x01, 0x62, 0x2F, 0x21, 0x55, 0x1E, 0x19, 0x58, 0x1B, 0x1D, 0x56, 0x47, 
        0x18, 0x1C, 0xAB, 0xF0, 0x75, 0x7B, 0x2C, 0x15, 0x0E, 0x73, 0x52, 0x98, 0x06, 0x0A, 0x1F, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x6F, 0x06, 0x05, 0x52, 0x73, 0x7E, 0x15, 0x2C, 0x26, 0x75, 0xF0, 0x16, 0x1C, 0x50, 0x18, 0x1A, 0x56, 0x1D, 0x5B, 
        0x1B, 0x58, 0x19, 0x53, 0x1E, 0x1E, 0x21, 0x59, 0x6B, 0x6B, 0x59, 0x21, 0x55, 0x55, 0x55, 0x55, 0x1E, 0x55, 0x53, 0x26, 0x7B, 0x2C, 0x7B, 0x26, 0x74, 0x26, 0x4C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x46, 0x46, 0x46, 0x46, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x4B, 0x4B, 0x60, 0x60, 0x60, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 
        0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x33, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x14, 0x14, 0x52, 0x52, 0x14, 0x07, 0x07, 0x07, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x05, 
        0x3C, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x2F, 0x1A, 0x16, 0x74, 0x7B, 
        0x2C, 0x0E, 0x1A, 0x2F, 0x69, 0x62, 0x65, 0x65, 0x65, 0x6D, 0x2A, 0x2A, 0x70, 0x70, 0x70, 0x20, 0x20, 0x5A, 0x5A, 0x63, 0x63, 0x63, 0x5A, 0x5A, 0x20, 0x20, 0x70, 0x2A, 0x6D, 0x01, 0x69, 0x2F, 0x59, 0x21, 0x1E, 0x53, 0x19, 0x1B, 0x5D, 0x57, 0x1A, 
        0x4C, 0x5E, 0x48, 0x41, 0x23, 0x26, 0x2C, 0x15, 0x0E, 0x73, 0x52, 0x98, 0x06, 0x08, 0x92, 0x32, 0x9A, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x08, 0xDD, 0x07, 0x12, 0x0E, 0x15, 0x2C, 0x7B, 0x75, 0xF0, 0x16, 0x1C, 0x50, 0x18, 0x1A, 0x56, 0x1D, 0x5B, 0x1B, 
        0x58, 0x19, 0x5C, 0x1E, 0x55, 0x21, 0x59, 0x59, 0x6B, 0x59, 0x21, 0x21, 0x55, 0x55, 0x67, 0x1E, 0x1E, 0x55, 0x19, 0x1A, 0x2C, 0x7B, 0x26, 0x7B, 0x74, 0x74, 0x16, 0x0B, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x0C, 0x0C, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x6C, 0x6C, 0x6C, 0x6C, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x05, 0x07, 0x05, 0x07, 0x07, 0x07, 0x07, 0x05, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x3F, 0x1E, 0x50, 0x5E, 0x23, 0x23, 
        0x26, 0x26, 0x2F, 0x62, 0x2F, 0x2F, 0x6D, 0x69, 0x01, 0x65, 0x6D, 0x2A, 0x2A, 0x2A, 0x70, 0x70, 0x20, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x63, 0x63, 0x20, 0x20, 0x20, 0x70, 0x2A, 0x6D, 0x01, 0x69, 0x2F, 0x59, 0x55, 0x1E, 0x53, 0x58, 0x5B, 0x5D, 0x56, 
        0x47, 0x50, 0x1C, 0x16, 0x23, 0x26, 0xF7, 0x78, 0x7E, 0x73, 0x00, 0x98, 0x06, 0x08, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0x9A, 0x92, 0x6F, 0xFD, 0x05, 0x00, 0x73, 0x7E, 0x78, 0xF7, 0x26, 0x23, 0x16, 0x48, 0x5E, 0x18, 0x47, 0x56, 0x1D, 0x5B, 0x54, 0x58, 
        0xEB, 0x1E, 0x67, 0x21, 0x59, 0x6B, 0x59, 0x59, 0x21, 0x21, 0x55, 0x55, 0x67, 0x67, 0x1E, 0x5C, 0x5C, 0x5C, 0x53, 0xEB, 0x74, 0x2C, 0x26, 0x2C, 0x26, 0x26, 0x26, 0x18, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 
        0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x15, 0x7C, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x15, 0x15, 0x15, 0x15, 0x15, 0x33, 0x4F, 0x4F, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x14, 0x07, 0x07, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x55, 0x19, 0x47, 0x18, 0x48, 0x16, 
        0x74, 0x1D, 0x2F, 0x2F, 0x62, 0x2F, 0x01, 0x62, 0x69, 0x01, 0x65, 0x65, 0x6D, 0x2A, 0x2A, 0x70, 0x70, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x63, 0x5A, 0x5A, 0x20, 0x20, 0x70, 0x2A, 0x65, 0x01, 0x62, 0x2F, 0x21, 0x55, 0x5C, 0x19, 0x1B, 0x5B, 0x57, 
        0x1A, 0x18, 0x1C, 0xAB, 0xF0, 0x26, 0x7B, 0x78, 0x7E, 0x73, 0x00, 0xDD, 0x0C, 0x6F, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x06, 0x07, 0x12, 0x0E, 0x15, 0x2C, 0x26, 0x75, 0x41, 0x48, 0x1C, 0x18, 0x47, 0x56, 0x1D, 0x5B, 0x1B, 0x58, 0xEB, 
        0x1E, 0x55, 0x21, 0x59, 0x6B, 0x2F, 0x21, 0x21, 0x21, 0x55, 0x1E, 0x1E, 0x1E, 0x1E, 0x53, 0x1E, 0xEB, 0x19, 0x1E, 0x19, 0x18, 0x78, 0x7B, 0xF7, 0x7B, 0x7B, 0x26, 0xAB, 0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x0C, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x82, 0x3F, 0x60, 0x76, 0x60, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x79, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x6C, 0x6C, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 
        0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 
        0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x14, 0x52, 0x14, 0x14, 0x52, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x05, 0x05, 0x05, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x14, 
        0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x26, 0x21, 0x58, 0x1D, 0x1A, 0x4C, 0x48, 
        0x1C, 0x21, 0x55, 0x21, 0x2F, 0x2F, 0x2F, 0x62, 0x62, 0x62, 0x69, 0x01, 0x65, 0x65, 0x6D, 0x2A, 0x2A, 0x70, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x63, 0x63, 0x5A, 0x20, 0x20, 0x70, 0x2A, 0x6D, 0x69, 0x62, 0x6B, 0x21, 0x67, 0x53, 0x58, 0x1B, 0x1D, 
        0x56, 0x4C, 0x5E, 0x48, 0xF0, 0x74, 0x7B, 0x78, 0x72, 0x73, 0x00, 0xDD, 0x0C, 0x6F, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0xFD, 0xDD, 0x00, 0x6E, 0x72, 0x78, 0x26, 0x75, 0xF0, 0x48, 0x5E, 0x18, 0x47, 0x56, 0x1D, 0x1B, 0x58, 0x19, 0x53, 0x1E, 
        0x55, 0x21, 0x59, 0x59, 0x59, 0x59, 0x55, 0x55, 0x55, 0x67, 0x1E, 0x1E, 0x5C, 0x5C, 0x53, 0x5C, 0xEB, 0x58, 0x53, 0x54, 0x1B, 0x26, 0x2C, 0x7B, 0x7B, 0x26, 0x7B, 0xF7, 0x5E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x04, 0x04, 0x3C, 0x3C, 0x04,
  0x4B, 0x4B, 0x60, 0x60, 0x60, 0x60, 0x76, 0x11, 0x11, 0x11, 0x11, 0x3D, 0xA0, 0x79, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 
        0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0xF8, 0x33, 0x33, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x14, 0x14, 0x14, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x52, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1D, 0x21, 0x53, 0x54, 0x57, 0x56, 0x50, 
        0x5B, 0x55, 0x21, 0x21, 0x55, 0x59, 0x59, 0x2F, 0x2F, 0x2F, 0x62, 0x69, 0x01, 0x01, 0x65, 0x65, 0x2A, 0x2A, 0x70, 0x70, 0x20, 0x20, 0x5A, 0x5A, 0x63, 0x63, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x2A, 0x65, 0x01, 0x2F, 0x59, 0x55, 0x1E, 0x19, 0x58, 0x5B, 
        0x1D, 0x47, 0x50, 0x1C, 0x41, 0x75, 0x7B, 0x78, 0x72, 0x73, 0x00, 0xDD, 0x0C, 0x6F, 0x92, 0xA9, 0x0D, 0x0D, 0x9A, 0x92, 0x08, 0x04, 0x07, 0x73, 0x7E, 0x78, 0xF7, 0x75, 0xF0, 0xAB, 0x5E, 0x18, 0x47, 0x56, 0x5D, 0x1B, 0x58, 0x19, 0x5C, 0x1E, 0x55, 
        0x21, 0x59, 0x59, 0x59, 0x21, 0x21, 0x55, 0x67, 0x1E, 0x1E, 0x1E, 0x1E, 0x5C, 0x53, 0x53, 0x58, 0xEB, 0x19, 0x1B, 0x19, 0x54, 0x5E, 0x15, 0x2C, 0x2C, 0x26, 0x7B, 0x26, 0x50, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x3C, 0x13, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05,
  0x4B, 0x76, 0x60, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x35, 0x35, 0x35, 0x35, 0x35, 
        0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 
        0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 
        0x52, 0x52, 0x14, 0x14, 0x52, 0x52, 0x52, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x12, 0x2F, 0x2F, 0x1E, 0x19, 0x1B, 0x5D, 0x1A, 
        0x1E, 0x1E, 0x21, 0x55, 0x67, 0x21, 0x21, 0x59, 0x6B, 0x2F, 0x2F, 0x62, 0x69, 0x69, 0x01, 0x01, 0x65, 0x6D, 0x2A, 0x2A, 0x70, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x63, 0x5A, 0x20, 0x20, 0x70, 0x2A, 0x65, 0x69, 0x2F, 0x59, 0x55, 0x5C, 0x19, 0x1B, 
        0x5D, 0x1A, 0x4C, 0x5E, 0x16, 0x23, 0x26, 0x78, 0x72, 0x6E, 0x00, 0xDD, 0xFD, 0x6F, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x05, 0x12, 0x0E, 0x15, 0x2C, 0x26, 0xF0, 0xAB, 0x1C, 0x18, 0x47, 0x1A, 0x1D, 0x1B, 0x58, 0x19, 0x1E, 0x1E, 0x21, 0x21, 
        0x59, 0x59, 0x21, 0x21, 0x55, 0x55, 0x1E, 0x1E, 0x5C, 0x5C, 0x5C, 0x53, 0xEB, 0x19, 0x19, 0x54, 0x58, 0x58, 0x1B, 0x19, 0x5B, 0x1D, 0x2C, 0x78, 0x2C, 0x2C, 0xF7, 0x26, 0x74, 0x41, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05,
  0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x52, 0x52, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x16, 0x62, 0x69, 0x21, 0x1E, 0x53, 0x1B, 0x1B, 
        0x5C, 0x1E, 0x5C, 0x1E, 0x55, 0x55, 0x55, 0x21, 0x21, 0x59, 0x59, 0x2F, 0x2F, 0x2F, 0x69, 0x69, 0x01, 0x65, 0x6D, 0x2A, 0x2A, 0x70, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x34, 0x63, 0x5A, 0x20, 0x20, 0x2A, 0x2A, 0x01, 0x62, 0x6B, 0x21, 0x1E, 0x53, 0x54, 
        0x5B, 0x57, 0x47, 0x50, 0xAB, 0x23, 0x74, 0x2C, 0x72, 0x6E, 0x00, 0xDD, 0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x6F, 0x06, 0x07, 0x73, 0x72, 0x78, 0x26, 0x23, 0x16, 0x1C, 0x50, 0x47, 0x56, 0x1D, 0x1B, 0x58, 0xEB, 0x1E, 0x55, 0x21, 0x6B, 0x6B, 
        0x59, 0x21, 0x55, 0x67, 0x1E, 0x1E, 0x1E, 0x5C, 0x53, 0xEB, 0x19, 0x19, 0x19, 0x58, 0x58, 0x58, 0x1B, 0x1B, 0x58, 0x1B, 0x5D, 0x1B, 0x75, 0x78, 0x2C, 0x78, 0x7B, 0x7B, 0xF7, 0x18, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x76, 0x76, 0x76, 0x76, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x76, 0x60, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x10, 
        0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x00, 0x14, 0x14, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x14, 0x14, 0x52, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x07, 0x07, 0x05, 0x05, 
        0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x53, 0x2A, 0x65, 0x2F, 0x2F, 0x5C, 0x53, 0x58, 
        0x53, 0x53, 0x5C, 0x5C, 0x1E, 0x1E, 0x67, 0x55, 0x55, 0x55, 0x21, 0x59, 0x59, 0x2F, 0x2F, 0x2F, 0x69, 0x69, 0x01, 0x65, 0x6D, 0x2A, 0x2A, 0x70, 0x20, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x5A, 0x20, 0x70, 0x70, 0x6D, 0x01, 0x62, 0x6B, 0x55, 0x1E, 0x19, 
        0x1B, 0x1D, 0x1A, 0x50, 0x1C, 0x16, 0x74, 0x7B, 0x15, 0x0E, 0x00, 0x98, 0xFD, 0x1F, 0x32, 0x0D, 0x0D, 0x9A, 0x92, 0x0A, 0xDD, 0x12, 0x0E, 0x78, 0x7B, 0x75, 0x41, 0x48, 0x50, 0x47, 0x1A, 0x5D, 0x1B, 0x58, 0x53, 0x1E, 0x55, 0x21, 0x6B, 0x59, 0x21, 
        0x21, 0x55, 0x67, 0x1E, 0x1E, 0x5C, 0x53, 0x53, 0x19, 0x19, 0x19, 0x58, 0x58, 0x54, 0x1B, 0x1B, 0x1B, 0x1B, 0x5B, 0x5B, 0x5B, 0x5D, 0x4C, 0x15, 0x78, 0x78, 0x78, 0x7B, 0x2C, 0x1C, 0x12, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x4B, 0x4B, 0x4B, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x17, 0x17, 0x3F, 0x3F, 0x82, 0x60, 
        0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x6C, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0xF8, 0x15, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 
        0x12, 0x12, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x07, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x3C, 0x3C, 0x3C, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x09, 0x62, 0x20, 0x70, 0x01, 0x69, 0x55, 0x67, 0x19, 
        0x19, 0x19, 0xEB, 0x53, 0x5C, 0x5C, 0x1E, 0x67, 0x67, 0x67, 0x55, 0x21, 0x21, 0x59, 0x6B, 0x2F, 0x2F, 0x62, 0x69, 0x01, 0x01, 0x65, 0x2A, 0x2A, 0x70, 0x70, 0x20, 0x20, 0x63, 0x63, 0x63, 0x63, 0x20, 0x20, 0x2A, 0x6D, 0x01, 0x62, 0x21, 0x1E, 0x5C, 
        0x58, 0x5B, 0x57, 0x4C, 0x50, 0xAB, 0x23, 0x7B, 0x15, 0x0E, 0x00, 0xDD, 0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x32, 0x1F, 0x06, 0x07, 0x6E, 0x15, 0x2C, 0x26, 0x41, 0x48, 0x50, 0x47, 0x57, 0x1D, 0x1B, 0x58, 0x5C, 0x1E, 0x55, 0x21, 0x59, 0x59, 0x21, 0x21, 
        0x55, 0x67, 0x1E, 0x1E, 0x5C, 0x53, 0xEB, 0x19, 0x19, 0x58, 0x58, 0x54, 0x54, 0x1B, 0x1B, 0x1B, 0x1B, 0x5B, 0x5B, 0x5D, 0x5D, 0x5D, 0x1A, 0xF7, 0xA2, 0x78, 0x78, 0xF7, 0x2C, 0x7B, 0x23, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 
        0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x61, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 
        0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0xF8, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x3C, 0x13, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x74, 0x6D, 0x5A, 0x20, 0x2A, 0x65, 0x2F, 0x1E, 0x58, 
        0x58, 0x58, 0x19, 0x19, 0x19, 0xEB, 0x53, 0x5C, 0x5C, 0x1E, 0x1E, 0x67, 0x55, 0x55, 0x21, 0x59, 0x59, 0x2F, 0x2F, 0x62, 0x69, 0x01, 0x65, 0x65, 0x2A, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x5A, 0x20, 0x20, 0x2A, 0x6D, 0x01, 0x2F, 0x21, 0x67, 
        0xEB, 0x54, 0x1D, 0x47, 0x50, 0x48, 0x23, 0x7B, 0x78, 0x0E, 0x12, 0xDD, 0x0A, 0x92, 0x9A, 0x0D, 0x0D, 0x32, 0x0A, 0xDD, 0x00, 0x7E, 0x78, 0x26, 0x23, 0x48, 0x50, 0x4C, 0x56, 0x5D, 0x1B, 0x58, 0x5C, 0x55, 0x21, 0x59, 0x59, 0x21, 0x21, 0x55, 0x67, 
        0x1E, 0x1E, 0x5C, 0x53, 0xEB, 0x19, 0x58, 0x58, 0x58, 0x54, 0x1B, 0x1B, 0x1B, 0x5B, 0x1B, 0x5B, 0x5B, 0x5D, 0x5D, 0x1D, 0x1D, 0x1D, 0x57, 0x23, 0xDA, 0xA2, 0xA2, 0x2C, 0x78, 0x2C, 0xAB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x13, 0x13, 0x13,
  0x68, 0x68, 0x17, 0x17, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x4B, 0x4B, 0x4B, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x79, 0xA0, 0x3D, 0xA0, 
        0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x81, 0x81, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 
        0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 
        0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x14, 0x00, 0x52, 0x52, 0x52, 0x00, 0x00, 0x14, 0x14, 0x52, 0x14, 0x14, 
        0x14, 0x52, 0x52, 0x52, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x57, 0x63, 0x34, 0xC2, 0x20, 0x70, 0x65, 0x19, 0x1B, 
        0x54, 0x54, 0x58, 0x58, 0x58, 0x19, 0x19, 0xEB, 0xEB, 0x53, 0x5C, 0x1E, 0x1E, 0x67, 0x55, 0x55, 0x21, 0x59, 0x59, 0x2F, 0x2F, 0x62, 0x69, 0x01, 0x65, 0x6D, 0x2A, 0x70, 0x70, 0x20, 0x5A, 0x63, 0x63, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x69, 0x2F, 0x21, 
        0x1E, 0x58, 0x5B, 0x56, 0x4C, 0x1C, 0x41, 0x26, 0x78, 0x0E, 0x12, 0xDD, 0x0A, 0x92, 0x0D, 0x0D, 0x9A, 0x1F, 0x04, 0x07, 0x6E, 0x78, 0x7B, 0x23, 0xAB, 0x50, 0x4C, 0x1A, 0x1D, 0x54, 0x19, 0x1E, 0x55, 0x21, 0x59, 0x59, 0x21, 0x55, 0x67, 0x1E, 0x1E, 
        0x5C, 0x53, 0xEB, 0x19, 0x58, 0x58, 0x58, 0x54, 0x1B, 0x1B, 0x1B, 0x1B, 0x5B, 0x5D, 0x5D, 0x5D, 0x5D, 0x1D, 0x1D, 0x1D, 0x1D, 0x57, 0x1D, 0x1C, 0x72, 0x72, 0xA2, 0x78, 0x78, 0x2C, 0x1C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x04,
  0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x71, 0x4E, 0x46, 0x46, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x4B, 0x4B, 0x76, 0x76, 
        0x76, 0x76, 0x76, 0x11, 0x11, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 
        0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x69, 0x94, 0x7A, 0x34, 0x63, 0x20, 0x2A, 0x1B, 0x5B, 
        0x1B, 0x1B, 0x1B, 0x54, 0x54, 0x58, 0x58, 0x58, 0x19, 0x19, 0xEB, 0x53, 0x5C, 0x5C, 0x1E, 0x1E, 0x55, 0x55, 0x21, 0x59, 0x59, 0x2F, 0x2F, 0x62, 0x69, 0x01, 0x6D, 0x2A, 0x2A, 0x70, 0x20, 0x20, 0x63, 0x63, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x69, 0x6B, 
        0x55, 0x5C, 0x54, 0x1D, 0x1A, 0x50, 0x16, 0x26, 0x78, 0x7E, 0x12, 0xDD, 0x08, 0x92, 0x0D, 0x0D, 0x32, 0x08, 0x05, 0x73, 0x72, 0xF7, 0x75, 0x16, 0x5E, 0x47, 0x56, 0x5D, 0x54, 0x53, 0x1E, 0x21, 0x21, 0x59, 0x21, 0x21, 0x55, 0x67, 0x1E, 0x5C, 0x53, 
        0xEB, 0x19, 0x19, 0x58, 0x58, 0x54, 0x1B, 0x1B, 0x1B, 0x1B, 0x5B, 0x5B, 0x5D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x57, 0x57, 0x56, 0x56, 0x57, 0x18, 0x78, 0x72, 0xDA, 0xA2, 0x78, 0x2C, 0x26, 0x7B, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C,
  0x46, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x82, 0x4B, 0x4B, 0x76, 0x60, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 
        0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x4F, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 
        0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 
        0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x52, 0x14, 0x52, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x13, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x7E, 0x01, 0xDF, 0x4A, 0xC1, 0x34, 0x63, 0x01, 0x1D, 0x5B, 
        0x5B, 0x5B, 0x5B, 0x5B, 0x1B, 0x1B, 0x54, 0x54, 0x54, 0x58, 0x58, 0x19, 0x19, 0xEB, 0x53, 0x5C, 0x1E, 0x1E, 0x67, 0x55, 0x21, 0x59, 0x59, 0x2F, 0x2F, 0x69, 0x01, 0x65, 0x6D, 0x2A, 0x70, 0x70, 0x20, 0x5A, 0x63, 0x63, 0x5A, 0x70, 0x2A, 0x65, 0x62, 
        0x59, 0x67, 0x19, 0x5B, 0x56, 0x18, 0xAB, 0x75, 0x2C, 0x72, 0x12, 0xDD, 0x6F, 0x32, 0x0D, 0x0D, 0x32, 0x06, 0x52, 0x0E, 0x78, 0x74, 0x41, 0x1C, 0x18, 0x56, 0x5D, 0x54, 0x53, 0x55, 0x21, 0x59, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x5C, 0x53, 0x19, 0x19, 
        0x58, 0x58, 0x54, 0x54, 0x1B, 0x1B, 0x1B, 0x5B, 0x5B, 0x5D, 0x5D, 0x1D, 0x1D, 0x1D, 0x57, 0x57, 0x57, 0x56, 0x56, 0x56, 0x56, 0x56, 0x1A, 0x47, 0x7B, 0x72, 0x72, 0xDA, 0xA2, 0x78, 0x15, 0x16, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0A, 0x0A, 0x0C, 0x0A, 0x0A, 0x0C, 0x0A, 0x0C, 0x0C, 0x0A, 0x0C, 0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x0A, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0xFD, 0xFD, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C,
  0x46, 0x46, 0x46, 0x68, 0x68, 0x46, 0x46, 0x46, 0x46, 0x68, 0x46, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x4B, 0x4B, 0x60, 0x60, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x02, 0x02, 0x02, 0x27, 0x27, 
        0x27, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x26, 0x20, 0x30, 0x93, 0x4A, 0x94, 0x34, 0x67, 0x1D, 0x1D, 
        0x1D, 0x1D, 0x5D, 0x5D, 0x5D, 0x5B, 0x5B, 0x1B, 0x1B, 0x1B, 0x54, 0x54, 0x58, 0x58, 0x19, 0x19, 0xEB, 0x53, 0x5C, 0x1E, 0x67, 0x55, 0x21, 0x21, 0x59, 0x2F, 0x2F, 0x69, 0x01, 0x65, 0x2A, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x63, 0x5A, 0x20, 0x2A, 0x01, 
        0x2F, 0x21, 0x5C, 0x54, 0x1D, 0x4C, 0x48, 0x23, 0x7B, 0x72, 0x12, 0x04, 0x6F, 0x32, 0x0D, 0xA9, 0x1F, 0xDD, 0x73, 0x15, 0x7B, 0xF0, 0x48, 0x4C, 0x1A, 0x5B, 0x58, 0x5C, 0x55, 0x21, 0x21, 0x21, 0x21, 0x55, 0x1E, 0x5C, 0x53, 0xEB, 0x19, 0x58, 0x58, 
        0x54, 0x1B, 0x1B, 0x1B, 0x5B, 0x5B, 0x5D, 0x5D, 0x1D, 0x1D, 0x1D, 0x57, 0x57, 0x56, 0x56, 0x56, 0x56, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x47, 0x47, 0x41, 0x72, 0x72, 0x72, 0xA2, 0x15, 0x78, 0x16, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x11, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x8D, 
        0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x39, 0x39, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x10, 0x10, 
        0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 
        0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1D, 0x94, 0x30, 0x93, 0x93, 0xDF, 0x7D, 0x58, 0x5D, 0x56, 
        0x57, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x5D, 0x5B, 0x5B, 0x5B, 0x1B, 0x1B, 0x1B, 0x54, 0x58, 0x58, 0x58, 0x19, 0xEB, 0x53, 0x5C, 0x1E, 0x67, 0x55, 0x21, 0x59, 0x59, 0x2F, 0x2F, 0x69, 0x01, 0x65, 0x2A, 0x70, 0x20, 0x20, 0x63, 0x63, 0x5A, 0x20, 0x2A, 
        0x01, 0x2F, 0x55, 0x19, 0x5B, 0x1A, 0x5E, 0x41, 0x26, 0x15, 0x12, 0x04, 0x6F, 0x32, 0x0D, 0x32, 0x08, 0x07, 0x7E, 0x2C, 0x23, 0x48, 0x18, 0x56, 0x5B, 0x58, 0x1E, 0x55, 0x59, 0x59, 0x21, 0x55, 0x67, 0x1E, 0x53, 0x19, 0x19, 0x58, 0x54, 0x54, 0x1B, 
        0x1B, 0x1B, 0x5B, 0x5D, 0x5D, 0x1D, 0x1D, 0x1D, 0x57, 0x57, 0x57, 0x56, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x47, 0x1A, 0xAB, 0x72, 0x7E, 0x72, 0xA2, 0x72, 0x78, 0x48, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x60, 0x60, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 
        0x0B, 0x0B, 0x61, 0x61, 0x8E, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x53, 0xDF, 0x30, 0x30, 0x30, 0x93, 0x94, 0x56, 0x47, 0x56, 
        0x56, 0x56, 0x57, 0x57, 0x57, 0x1D, 0x1D, 0x1D, 0x1D, 0x5D, 0x5B, 0x5B, 0x5B, 0x5B, 0x1B, 0x1B, 0x54, 0x54, 0x58, 0x19, 0x19, 0xEB, 0x5C, 0x5C, 0x67, 0x67, 0x55, 0x21, 0x59, 0x2F, 0x62, 0x69, 0x65, 0x6D, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x63, 0x20, 
        0x2A, 0x01, 0x6B, 0x1E, 0x58, 0x1D, 0x4C, 0x48, 0x26, 0x78, 0x73, 0x06, 0x1F, 0x0D, 0x0D, 0x92, 0xDD, 0x6E, 0x78, 0x23, 0x48, 0x18, 0x56, 0x5B, 0x19, 0x67, 0x21, 0x21, 0x21, 0x55, 0x1E, 0x1E, 0x5C, 0x53, 0x19, 0x58, 0x58, 0x54, 0x1B, 0x5B, 0x5B, 
        0x5D, 0x5D, 0x1D, 0x1D, 0x1D, 0x57, 0x56, 0x56, 0x56, 0x56, 0x1A, 0x1A, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x47, 0x50, 0x50, 0xDA, 0x7E, 0x7E, 0x72, 0x72, 0x15, 0x74, 0x12, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x13, 0x3C, 0x3C, 0x13, 0x3C, 0x3C, 0x13, 0x13,
  0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 
        0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0x79, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x03, 0x03, 
        0x03, 0x4F, 0x33, 0x7C, 0x02, 0x02, 0x02, 0x27, 0x27, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x52, 0x52, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x13, 0x13, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x05, 0x05, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x69, 0x30, 0x30, 0x30, 0x30, 0x30, 0x34, 0x1A, 0x47, 0x1A, 
        0x1A, 0x1A, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x57, 0x1D, 0x1D, 0x1D, 0x5D, 0x5D, 0x5B, 0x5B, 0x5B, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0x19, 0x53, 0x5C, 0x1E, 0x67, 0x55, 0x21, 0x59, 0x6B, 0x69, 0x01, 0x65, 0x2A, 0x70, 0x20, 0x5A, 0x5A, 0x5A, 
        0x20, 0x2A, 0x69, 0x21, 0x5C, 0x5B, 0x47, 0x1C, 0x74, 0x78, 0x73, 0x04, 0x92, 0x0D, 0xA9, 0x6F, 0x07, 0x15, 0x26, 0x16, 0x50, 0x1A, 0x1B, 0x53, 0x1E, 0x21, 0x21, 0x21, 0x55, 0x1E, 0x5C, 0xEB, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5B, 0x5D, 0x5D, 
        0x1D, 0x1D, 0x57, 0x57, 0x56, 0x56, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x18, 0x18, 0x18, 0x4C, 0x50, 0x50, 0x78, 0x7E, 0x7E, 0x72, 0x72, 0x15, 0x15, 0x4D, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x76, 0x11, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x46, 0x46, 0x46, 0x46, 0x68, 0x68, 0x68, 
        0x46, 0x68, 0x68, 0x17, 0x17, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x03, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x33, 0x03, 0x33, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x4F, 0x33, 0x15, 0x33, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 
        0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x14, 0x52, 0x14, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x52, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x04, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x72, 0x01, 0x30, 0x30, 0x30, 0x30, 0x30, 0x20, 0x4C, 0x4C, 0x47, 
        0x47, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x56, 0x56, 0x57, 0x57, 0x1D, 0x1D, 0x5D, 0x1D, 0x5D, 0x5B, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x58, 0x19, 0xEB, 0x53, 0x1E, 0x67, 0x55, 0x55, 0x59, 0x2F, 0x69, 0x01, 0x6D, 0x2A, 0x20, 0x20, 0x63, 
        0x5A, 0x20, 0x2A, 0x62, 0x55, 0x58, 0x1D, 0x50, 0x23, 0x78, 0x12, 0x04, 0x32, 0x0D, 0x32, 0xDD, 0x0E, 0x7B, 0x41, 0x50, 0x56, 0x1B, 0x5C, 0x21, 0x21, 0x21, 0x55, 0x67, 0x1E, 0x53, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5D, 0x5D, 0x1D, 0x1D, 0x1D, 
        0x57, 0x56, 0x56, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x50, 0x50, 0x18, 0x50, 0x50, 0xF7, 0x7E, 0x6E, 0x7E, 0x72, 0x15, 0x0E, 0x41, 0x08, 0x08, 0x0A, 0x0A, 0x0C, 0x0A, 0x0A, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
  0x46, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x4B, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x6C, 0x6C, 
        0x35, 0x35, 0x35, 0x35, 0x37, 0x37, 0x6C, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x4F, 0xF8, 0x15, 
        0x15, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x14, 0x14, 0x52, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0B, 0x2A, 0x93, 0x30, 0x30, 0x30, 0x30, 0x69, 0x18, 0x4C, 0x18, 
        0x4C, 0x4C, 0x4C, 0x4C, 0x47, 0x47, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x1A, 0x56, 0x56, 0x56, 0x57, 0x57, 0x1D, 0x1D, 0x1D, 0x5D, 0x5B, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x55, 0x21, 0x59, 0x2F, 0x62, 0x01, 0x2A, 0x70, 0x20, 
        0x5A, 0x5A, 0x20, 0x65, 0x2F, 0x1E, 0x54, 0x47, 0xAB, 0x2C, 0x73, 0x04, 0x32, 0x0D, 0x6F, 0x12, 0x78, 0x23, 0x5E, 0x56, 0x54, 0x1E, 0x21, 0x21, 0x21, 0x1E, 0x5C, 0x53, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5D, 0x1D, 0x1D, 0x57, 0x57, 0x56, 0x56, 
        0x1A, 0x1A, 0x1A, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x5E, 0x50, 0x26, 0x6E, 0x6E, 0x7E, 0x72, 0x72, 0x7E, 0x48, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x71, 0x71, 0x46, 0x46, 0x46, 0x46, 0x68, 0x68, 0x17, 0x3F, 0x3F, 0x3F, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 
        0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x61, 0x61, 0x39, 0x39, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x4F, 0x4F, 
        0x33, 0x33, 0xF8, 0x33, 0x4F, 0x33, 0x33, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 
        0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x04, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x74, 0x20, 0x93, 0x30, 0x30, 0x30, 0x30, 0x1E, 0x50, 0x18, 0x50, 
        0x18, 0x18, 0x18, 0x18, 0x4C, 0x4C, 0x4C, 0x4C, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x1A, 0x56, 0x56, 0x56, 0x56, 0x57, 0x1D, 0x1D, 0x5D, 0x5B, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0x53, 0x5C, 0x67, 0x55, 0x21, 0x2F, 0x69, 0x01, 0x2A, 
        0x20, 0x5A, 0x5A, 0x20, 0x6D, 0x59, 0x53, 0x57, 0x5E, 0x7B, 0x0E, 0x04, 0x9A, 0xA9, 0x04, 0x72, 0x26, 0x5E, 0x57, 0x19, 0x1E, 0x21, 0x21, 0x67, 0x1E, 0xEB, 0x19, 0x58, 0x54, 0x1B, 0x5B, 0x5D, 0x1D, 0x1D, 0x57, 0x56, 0x56, 0x1A, 0x1A, 0x1A, 0x47, 
        0x47, 0x47, 0x47, 0x4C, 0x4C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x5E, 0x5E, 0x5E, 0x5E, 0x1C, 0x5E, 0x5E, 0x1C, 0x75, 0x6E, 0x73, 0x6E, 0x7E, 0x72, 0x7E, 0xF0, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C,
  0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x46, 0x68, 0x17, 0x17, 0x17, 0x3F, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 
        0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x61, 0x8E, 0x8E, 0x61, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x52, 0x14, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x05, 0x07, 0x07, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x52, 0x52, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x00, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1D, 0x63, 0x93, 0x93, 0x30, 0x30, 0x30, 0x5B, 0x5E, 0x50, 0x5E, 
        0x50, 0x50, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x18, 0x18, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 0x47, 0x47, 0x1A, 0x1A, 0x1A, 0x1A, 0x56, 0x56, 0x57, 0x1D, 0x1D, 0x5D, 0x5D, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0xEB, 0x5C, 0x1E, 0x55, 0x59, 0x2F, 0x01, 
        0x6D, 0x70, 0x5A, 0x5A, 0x20, 0x65, 0x55, 0x1B, 0x47, 0x74, 0x0E, 0x0A, 0x0D, 0x92, 0x12, 0x7B, 0x48, 0x1D, 0x19, 0x55, 0x21, 0x55, 0x67, 0x53, 0x19, 0x54, 0x1B, 0x1B, 0x5D, 0x1D, 0x1D, 0x57, 0x56, 0x1A, 0x1A, 0x1A, 0x1A, 0x47, 0x47, 0x4C, 0x4C, 
        0x18, 0x18, 0x18, 0x18, 0x18, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x5E, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0xA4, 0x6E, 0xFC, 0x6E, 0x0E, 0x7E, 0x7E, 0x1C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x89, 0x36, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x46, 0x46, 0x68, 0x17, 0x17, 0x17, 0x3F, 0x4B, 0x4B, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 
        0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x6C, 0x37, 
        0x37, 0x37, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x7C, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x13, 0x13, 0x04, 0x1D, 0x34, 0xDF, 0xDF, 0x30, 0x93, 0x30, 0x4C, 0x48, 0x1C, 0x1C, 
        0x1C, 0x1C, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x4C, 0x4C, 0x4C, 0x47, 0x47, 0x1A, 0x1A, 0x1A, 0x56, 0x56, 0x57, 0x57, 0x1D, 0x5D, 0x5D, 0x5B, 0x1B, 0x58, 0x19, 0x53, 0x1E, 0x67, 0x59, 
        0x2F, 0x01, 0x2A, 0x20, 0x5A, 0x20, 0x01, 0x1E, 0x5D, 0xF0, 0x7E, 0x6F, 0x0D, 0x04, 0x78, 0x48, 0x57, 0x53, 0x67, 0x55, 0x1E, 0x53, 0x19, 0x54, 0x1B, 0x5D, 0x1D, 0x57, 0x56, 0x1A, 0x1A, 0x1A, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x18, 0x18, 0x18, 0x50, 
        0x50, 0x50, 0x50, 0x50, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0xAB, 0x41, 0x6E, 0xFC, 0x73, 0x6E, 0x0E, 0x7E, 0xF0, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x04, 0x04, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x71, 0x4E, 0x46, 0x68, 0x46, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x3F, 0x4B, 0x4B, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 
        0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x39, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0xF8, 0x15, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x15, 0x15, 0x33, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x01, 0x01, 0x01, 0x4F, 0x4F, 
        0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0xF8, 0xF8, 0x15, 0x01, 0x15, 0x15, 0x02, 0x02, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x01, 0x01, 0x01, 0x10, 
        0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x07, 0x07, 0x07, 0x05, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x1D, 0x34, 0x4A, 0x4A, 0x93, 0x93, 0x93, 0x48, 0x16, 0xAB, 0x1C, 
        0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x5E, 0x5E, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x4C, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x57, 0x57, 0x1D, 0x1D, 0x5B, 0x1B, 0x58, 0x19, 0x5C, 
        0x67, 0x59, 0x62, 0x65, 0x20, 0x5A, 0x20, 0x2F, 0x19, 0x1C, 0x15, 0x08, 0x32, 0x12, 0x23, 0x56, 0x19, 0x21, 0x55, 0x5C, 0x58, 0x1B, 0x1B, 0x5D, 0x1D, 0x56, 0x1A, 0x1A, 0x4C, 0x4C, 0x47, 0x4C, 0x18, 0x18, 0x50, 0x50, 0x50, 0x50, 0x5E, 0x50, 0x50, 
        0x5E, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0xAB, 0xAB, 0xAB, 0xAB, 0x48, 0x16, 0x16, 0x6E, 0xFC, 0xFC, 0xFC, 0x6E, 0x0E, 0x26, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06,
  0x3B, 0x3B, 0x2E, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x25, 0x25, 0x4E, 0x46, 0x68, 0x68, 0x68, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 
        0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 
        0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x03, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x01, 0x03, 0x03, 0x03, 0x01, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x4F, 0x33, 0x33, 0x15, 0x01, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x14, 0x07, 
        0x07, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x12, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x3C, 0x1D, 0x63, 0x94, 0x94, 0x4A, 0xDF, 0x7D, 0x48, 0xAB, 0x16, 0x48, 
        0xAB, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x5E, 0x50, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 0x47, 0x1A, 0x56, 0x56, 0x1D, 0x1D, 0x5D, 0x1B, 
        0x54, 0x19, 0x67, 0x59, 0x69, 0x2A, 0x20, 0x70, 0x21, 0x56, 0x78, 0x92, 0xFD, 0x7B, 0x57, 0x55, 0x67, 0x53, 0x58, 0x1B, 0x5D, 0x57, 0x56, 0x1A, 0x1A, 0x47, 0x4C, 0x4C, 0x18, 0x50, 0x50, 0x50, 0x50, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 
        0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x16, 0x16, 0xAB, 0xAB, 0xAB, 0x41, 0xDA, 0x6E, 0xFC, 0xFC, 0xFC, 0x73, 0x2C, 0x0A, 0x08, 0x0A, 0x0A, 0x08, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x29, 0x29, 0x3E, 0x3E, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x46, 0x46, 0x68, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x4B, 0x3F, 0x3F, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x76, 0x11, 0x11, 
        0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x79, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x01, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x01, 0x4F, 0x4F, 0x33, 0x01, 0x15, 0x02, 0x01, 0x01, 0x02, 0x02, 0x27, 0x01, 0x01, 0x01, 0x0E, 0x09, 0x09, 0x09, 0x01, 0x01, 0x01, 0x10, 0x10, 0x01, 0x10, 0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x01, 0x10, 0x10, 
        0x10, 0x01, 0x10, 0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x00, 0x14, 0x52, 0x14, 0x14, 0x00, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x14, 0x14, 0x52, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xFD, 0x0A, 0x0A, 0x01, 0x63, 0x7A, 0x94, 0x4A, 0x4A, 0x34, 0xAB, 0x16, 0x16, 0xAB, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x5E, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 0x1A, 0x56, 
        0x56, 0x57, 0x5B, 0x58, 0x53, 0x21, 0x69, 0x70, 0x70, 0x19, 0x26, 0x6F, 0x6E, 0x1A, 0x55, 0x53, 0x19, 0x1B, 0x1D, 0x1A, 0x47, 0x47, 0x4C, 0x18, 0x50, 0x50, 0x5E, 0x5E, 0x1C, 0x1C, 0x48, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0x48, 0x48, 0xAB, 0x48, 0x48, 
        0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0x41, 0xA2, 0xDC, 0x6E, 0x6E, 0xFC, 0x73, 0x15, 0x26, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x71, 0x71, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x3F, 
        0x3F, 0x76, 0x76, 0x76, 0x11, 0x11, 0x25, 0x29, 0x53, 0x53, 0x53, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x56, 0x25, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x01, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x01, 0x09, 0x09, 0x10, 0x01, 0x10, 0x12, 0x12, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x12, 0x10, 0x01, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x01, 0x27, 0x27, 
        0x27, 0x01, 0x01, 0x27, 0x27, 0x01, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x01, 0xC2, 0x34, 0xC1, 0x7D, 0x4A, 0x63, 0x16, 0x41, 0x16, 0x41, 
        0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x50, 
        0x50, 0x18, 0x47, 0x1A, 0x56, 0x1D, 0x1B, 0x1E, 0x01, 0x70, 0x48, 0x06, 0x47, 0x1E, 0x1B, 0x1D, 0x56, 0x47, 0x18, 0x50, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0x48, 0x48, 0xAB, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x78, 0x72, 0xDC, 0x6E, 0xFC, 0x73, 0x0E, 0x26, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x25, 0x25, 0x4E, 0x4E, 0x46, 0x46, 0x68, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x4B, 0x4B, 0x76, 0x60, 0x76, 0x76, 0x76, 0x60, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 
        0x0F, 0x0F, 0x76, 0x1D, 0x19, 0x2F, 0x5C, 0x5D, 0x18, 0x16, 0xD4, 0xA2, 0x6E, 0x6E, 0x7E, 0x78, 0x26, 0x41, 0x18, 0x1B, 0x55, 0x55, 0xC9, 0x82, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 
        0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x6C, 0x6C, 0x6C, 0x35, 0x35, 0x6C, 0x37, 0x37, 0x01, 0x0B, 0x0B, 0x01, 0x01, 0x61, 
        0x01, 0x8E, 0x03, 0x03, 0x01, 0x4F, 0x4F, 0xF8, 0x01, 0x15, 0x02, 0x02, 0x02, 0x01, 0x02, 0x02, 0x27, 0x27, 0x27, 0x01, 0x01, 0x01, 0x01, 0x27, 0x01, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x01, 0x27, 0x27, 
        0x27, 0x01, 0x27, 0x27, 0x27, 0x01, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x01, 0x5A, 0x34, 0x34, 0xC1, 0x94, 0x20, 0x41, 0x23, 0x41, 0x23, 
        0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x16, 0x16, 0x16, 
        0x16, 0xAB, 0x48, 0x48, 0xAB, 0x48, 0x1C, 0x50, 0x56, 0x54, 0xEB, 0x23, 0x1D, 0x4C, 0x5E, 0x1C, 0x48, 0x16, 0x16, 0x16, 0x16, 0x41, 0x41, 0x16, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 
        0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x23, 0x23, 0xA4, 0xA4, 0xA4, 0x41, 0x2C, 0xA2, 0x72, 0xDC, 0x73, 0x6E, 0x6E, 0x26, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x46, 0x46, 0x68, 0x17, 0x17, 0x3F, 0x3F, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 
        0x71, 0x21, 0x59, 0x19, 0x1D, 0x50, 0x48, 0x41, 0x75, 0x26, 0x2C, 0xA2, 0x7E, 0x73, 0x73, 0x6E, 0x7E, 0x7E, 0xDA, 0xA2, 0x78, 0x23, 0x18, 0xEB, 0x59, 0x1B, 0x60, 0x76, 0x76, 0x76, 0x76, 0x76, 0x60, 0x60, 0x76, 0x76, 0x60, 0x76, 0x76, 0x76, 0x76, 
        0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x6C, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x01, 0x8E, 0x03, 0x03, 0x01, 0x03, 
        0x01, 0x4F, 0x4F, 0x01, 0x01, 0x33, 0x15, 0x15, 0x01, 0x15, 0x02, 0x02, 0x02, 0x01, 0x02, 0x02, 0x01, 0x02, 0x01, 0x02, 0x02, 0x02, 0x01, 0x02, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x01, 0x27, 0x0E, 
        0x0E, 0x01, 0x09, 0x09, 0x09, 0x01, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x07, 0x07, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x20, 0x63, 0x34, 0x34, 0x7D, 0x20, 0x41, 0x23, 0x41, 0x23, 
        0x23, 0x23, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x16, 0x41, 
        0x41, 0x16, 0x16, 0x16, 0x16, 0x48, 0x1C, 0x5E, 0x4C, 0x1D, 0x23, 0x53, 0x54, 0x57, 0x50, 0x5E, 0x1C, 0x48, 0x48, 0x48, 0xAB, 0x16, 0x16, 0x16, 0x16, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 
        0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0xA4, 0xA4, 0xA4, 0x41, 0xF7, 0x78, 0xDA, 0x72, 0x6E, 0x6E, 0x73, 0x26, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x36, 0x36, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x46, 0x46, 0x17, 0x17, 0x17, 0x3F, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x5D, 0x59, 
        0x21, 0x5C, 0x54, 0x5D, 0x56, 0x4C, 0x50, 0x48, 0x41, 0x75, 0x26, 0x2C, 0x15, 0x0E, 0x73, 0x73, 0x0E, 0x7E, 0x72, 0x15, 0xA2, 0x78, 0x2C, 0x7B, 0x41, 0x56, 0x59, 0x54, 0x68, 0x3D, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x37, 0x37, 0x37, 
        0x0B, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x4F, 0x4F, 0x33, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x01, 0x01, 0x01, 0x01, 0x03, 
        0x03, 0x01, 0x01, 0x8E, 0x01, 0x8E, 0x8E, 0x01, 0x01, 0x01, 0x61, 0x8E, 0x8E, 0x61, 0x01, 0x01, 0x03, 0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x03, 0x01, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x27, 
        0x0E, 0x01, 0x0E, 0x0E, 0x09, 0x01, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x52, 0x52, 0x52, 0x00, 0x00, 0x00, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x13, 0x13, 0x13, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x20, 0x5A, 0x63, 0x63, 0xC1, 0x20, 0x41, 0x41, 0x16, 0x41, 
        0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0x48, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 
        0x1C, 0x5E, 0x50, 0x18, 0x47, 0x56, 0x1D, 0x1B, 0x5C, 0x47, 0x06, 0x48, 0x70, 0x65, 0x67, 0x58, 0x5B, 0x56, 0x1A, 0x47, 0x18, 0x50, 0x50, 0x50, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0x48, 0xAB, 0xAB, 0xAB, 0xAB, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x16, 0x7B, 0xF7, 0xA2, 0xA2, 0x7E, 0x7E, 0x0E, 0x26, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x06, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x05, 0x05,
  0x46, 0x46, 0x46, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x3F, 0x17, 0x17, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x68, 0x17, 0x68, 0x68, 0x68, 0x68, 0x68, 0x29, 0x21, 0x55, 0x55, 
        0x55, 0x1E, 0x19, 0x1B, 0x1D, 0x47, 0x1C, 0x23, 0x26, 0x78, 0x7E, 0x73, 0x52, 0x05, 0x0C, 0x08, 0x6F, 0x6F, 0xFD, 0x05, 0x0E, 0x15, 0x78, 0xF7, 0xF7, 0x26, 0x23, 0x1A, 0x1E, 0x5D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 
        0x37, 0x37, 0x37, 0x0B, 0x61, 0x61, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x15, 0x7C, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x02, 0x15, 0x15, 0x02, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 
        0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 
        0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x70, 0x20, 0x5A, 0x5A, 0x34, 0x20, 0x41, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x48, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x50, 0x18, 0x4C, 
        0x47, 0x47, 0x56, 0x1D, 0x1B, 0x19, 0x53, 0x67, 0x1A, 0x73, 0x6F, 0x26, 0x19, 0x20, 0x70, 0x69, 0x21, 0x53, 0x58, 0x5B, 0x57, 0x56, 0x56, 0x1A, 0x47, 0x4C, 0x18, 0x18, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 
        0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0xAB, 0xAB, 0x7B, 0xF7, 0xF7, 0x78, 0xDA, 0x72, 0x72, 0x26, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x3C, 0x13, 0x04, 0x13, 
        0x3C, 0x04, 0x3C, 0x3C, 0x04, 0x3C, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x13,
  0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x53, 0x21, 0x19, 0x58, 0x53, 
        0x1E, 0x55, 0x19, 0x57, 0x5E, 0x41, 0x75, 0x26, 0x2C, 0x15, 0x7E, 0x73, 0x52, 0x05, 0x06, 0x08, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0x92, 0x07, 0x15, 0xF7, 0x7B, 0x26, 0x74, 0x41, 0x1D, 0x67, 0x76, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 
        0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 
        0x4F, 0x33, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x0E, 0x09, 0x09, 0x09, 0x0E, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 
        0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x5C, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x20, 0x41, 0xAB, 0x16, 0xAB, 
        0x16, 0x16, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x50, 0x50, 0x18, 0x18, 0x4C, 0x47, 0x47, 0x1A, 0x56, 0x56, 
        0x1D, 0x5D, 0x1B, 0x58, 0x53, 0x67, 0x55, 0x57, 0x7B, 0x0A, 0x92, 0x78, 0x57, 0x59, 0x20, 0x20, 0x2A, 0x62, 0x21, 0x1E, 0x19, 0x54, 0x1B, 0x5D, 0x1D, 0x57, 0x56, 0x56, 0x1A, 0x47, 0x47, 0x4C, 0x4C, 0x18, 0x18, 0x50, 0x50, 0x50, 0x50, 0x5E, 0x5E, 
        0x5E, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0xAB, 0xAB, 0xAB, 0x48, 0x48, 0xD4, 0x7B, 0xF7, 0xF7, 0xA2, 0xDA, 0x78, 0x73, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x2B, 0x2B, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x36, 0x36, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x2E, 0x59, 0x58, 0x56, 0x57, 0x5B, 0x58, 
        0xEB, 0x1B, 0x47, 0x50, 0x48, 0x16, 0x23, 0x26, 0x2C, 0x15, 0x7E, 0x73, 0x52, 0x05, 0x06, 0x08, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x6F, 0x00, 0x15, 0x7B, 0x26, 0x26, 0x23, 0x1C, 0x67, 0xC9, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x35, 0x6C, 0x6C, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 
        0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x6C, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 0x10, 
        0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x3C, 0x13, 0x1D, 0x6D, 0x70, 0x20, 0x20, 0x5A, 0x20, 0x1C, 0x16, 0xAB, 0xAB, 
        0xAB, 0xAB, 0xAB, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x50, 0x5E, 0x50, 0x50, 0x50, 0x50, 0x18, 0x18, 0x4C, 0x47, 0x4C, 0x4C, 0x1A, 0x1A, 0x56, 0x1D, 0x5D, 0x5B, 
        0x1B, 0x19, 0x1E, 0x21, 0x21, 0x19, 0x1A, 0x23, 0x12, 0xA9, 0x6F, 0x15, 0x1C, 0x19, 0x2F, 0x20, 0x5A, 0x70, 0x65, 0x62, 0x59, 0x55, 0x5C, 0x19, 0x58, 0x1B, 0x5B, 0x1D, 0x1D, 0x57, 0x57, 0x56, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0x18, 0x18, 
        0x18, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x5E, 0x5E, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0x48, 0x48, 0x1C, 0xAB, 0x75, 0xD4, 0xD4, 0xF7, 0x2C, 0x78, 0xF7, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x3C,
  0x29, 0x29, 0x29, 0x2E, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0xC9, 0x6B, 0x47, 0x48, 0x50, 0x47, 0x1D, 0x1B, 
        0x5B, 0x57, 0x1A, 0x18, 0x1C, 0x16, 0x23, 0x26, 0x2C, 0x78, 0x7E, 0x73, 0x52, 0x05, 0x0C, 0x6F, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0xA9, 0x92, 0x0A, 0x04, 0x07, 0x0E, 0xF7, 0x26, 0x74, 0x23, 0x16, 0x5B, 0x19, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x5D, 0x65, 0x2A, 0x70, 0x70, 0x20, 0x20, 0x50, 0xAB, 0x48, 0x48, 
        0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x4C, 0x47, 0x47, 0x1A, 0x1A, 0x1A, 0x1A, 0x56, 0x57, 0x1D, 0x5D, 0x1B, 0x54, 0x58, 
        0x53, 0x1E, 0x55, 0x55, 0x53, 0x57, 0x48, 0x15, 0x06, 0x0D, 0x08, 0x72, 0xF0, 0x1D, 0x5C, 0x01, 0x70, 0x5A, 0x20, 0x2A, 0x01, 0x2F, 0x59, 0x67, 0x1E, 0x53, 0x19, 0x58, 0x1B, 0x5B, 0x5D, 0x5D, 0x1D, 0x57, 0x57, 0x56, 0x56, 0x1A, 0x1A, 0x1A, 0x47, 
        0x47, 0x4C, 0x4C, 0x4C, 0x4C, 0x18, 0x18, 0x18, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x9E, 0x48, 0xA4, 0x75, 0xD4, 0x7B, 0xF7, 0x78, 0x74, 0x06, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x54, 0x67, 0x41, 0x23, 0x41, 0x1C, 0x5D, 0x53, 0x58, 
        0x1B, 0x1D, 0x1A, 0x4C, 0x5E, 0xAB, 0x41, 0x74, 0x7B, 0x78, 0x72, 0x73, 0x52, 0x98, 0x0C, 0x6F, 0x92, 0xA9, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x52, 0x6E, 0x72, 0xF7, 0x26, 0x74, 0x75, 0xF0, 0x1A, 0x53, 0x68, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 
        0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x61, 0x8E, 
        0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5B, 0x69, 0x65, 0x6D, 0x2A, 0x20, 0x20, 0x1A, 0x48, 0x1C, 0x1C, 
        0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x5E, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x18, 0x4C, 0x4C, 0x47, 0x47, 0x1A, 0x1A, 0x1A, 0x56, 0x56, 0x57, 0x1D, 0x1D, 0x5D, 0x1B, 0x1B, 0x54, 0x19, 0x53, 0x67, 
        0x55, 0x21, 0x55, 0x19, 0x57, 0x48, 0x2C, 0x00, 0x92, 0x0D, 0xFD, 0x0E, 0x26, 0x47, 0x1B, 0x55, 0x65, 0x20, 0x5A, 0x5A, 0x70, 0x6D, 0x01, 0x2F, 0x59, 0x55, 0x1E, 0x5C, 0xEB, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5D, 0x5D, 0x1D, 0x1D, 0x57, 0x56, 0x56, 
        0x1A, 0x1A, 0x1A, 0x1A, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x1C, 0x41, 0xA4, 0x75, 0xD4, 0x7B, 0x2C, 0x41, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x05, 0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x9F, 0x36, 0x36, 0x3E, 0x89, 0x89, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0xE6, 0x19, 0x2C, 0x2C, 0x26, 0x41, 0x19, 0x21, 0x5C, 0xEB, 
        0x54, 0x5B, 0x1D, 0x47, 0x50, 0x48, 0x41, 0x75, 0x7B, 0x78, 0x72, 0x6E, 0x52, 0x98, 0xFD, 0x1F, 0x32, 0x9A, 0x0D, 0x0D, 0xA9, 0x92, 0x08, 0x04, 0x07, 0x73, 0x7E, 0x78, 0xF7, 0x26, 0x26, 0x26, 0x74, 0x23, 0x18, 0x21, 0x17, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 
        0x33, 0xF8, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x1C, 0x6B, 0x01, 0x65, 0x2A, 0x70, 0x70, 0x5B, 0x1C, 0x5E, 0x5E, 
        0x1C, 0x5E, 0x5E, 0x5E, 0x5E, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x4C, 0x4C, 0x4C, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x1A, 0x56, 0x56, 0x57, 0x1D, 0x1D, 0x5D, 0x5B, 0x1B, 0x54, 0x58, 0x19, 0xEB, 0x1E, 0x67, 0x21, 
        0x21, 0x1E, 0x58, 0x56, 0x1C, 0x26, 0x7E, 0xDD, 0xA9, 0xA9, 0x04, 0x6E, 0x7B, 0x50, 0x1D, 0xEB, 0x59, 0x6D, 0x20, 0x63, 0x5A, 0x20, 0x2A, 0x01, 0x69, 0x2F, 0x21, 0x55, 0x67, 0x5C, 0x53, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5B, 0x5D, 0x1D, 0x1D, 
        0x57, 0x56, 0x56, 0x56, 0x56, 0x1A, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x4C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x50, 0x50, 0x9E, 0xAB, 0x41, 0xA4, 0x75, 0xD4, 0xF7, 0x41, 0x04, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 
        0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x04, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x04, 0x04, 0x04, 0x13, 
        0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x36, 0x25, 0x25, 0x25, 0x25, 0x54, 0x19, 0x7E, 0x0E, 0x72, 0x41, 0x21, 0x2F, 0x59, 0x55, 0x5C, 
        0x19, 0x1B, 0x1D, 0x1A, 0x18, 0x1C, 0x16, 0x23, 0x7B, 0x78, 0x72, 0x6E, 0x52, 0x98, 0xFD, 0x1F, 0x32, 0x9A, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x00, 0x0E, 0x15, 0x2C, 0x26, 0x23, 0x41, 0x75, 0x26, 0x75, 0x23, 0x18, 0x67, 0x0F, 0x0F, 0x35, 0x35, 
        0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 
        0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x75, 0x21, 0x62, 0x01, 0x65, 0x2A, 0x2A, 0x19, 0x5E, 0x50, 0x50, 
        0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x18, 0x18, 0x4C, 0x4C, 0x4C, 0x4C, 0x47, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x56, 0x57, 0x57, 0x1D, 0x1D, 0x5D, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x21, 0x21, 0x21, 
        0x5C, 0x54, 0x56, 0x5E, 0x23, 0x78, 0x12, 0x6F, 0x0D, 0xA9, 0x04, 0x73, 0x2C, 0xAB, 0x47, 0x54, 0x1E, 0x2F, 0x6D, 0x20, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x01, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x5C, 0x53, 0x19, 0x58, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 
        0x5B, 0x5D, 0x1D, 0x1D, 0x1D, 0x57, 0x57, 0x56, 0x56, 0x56, 0x1A, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x4C, 0xEF, 0xEF, 0x18, 0x50, 0xAB, 0xAB, 0x41, 0xA4, 0x75, 0xF7, 0x41, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x04, 0x04, 0x3C, 0x3C, 0x3C, 0x13, 0x3C, 0x04, 0x3C, 0x04, 0x04, 0x3C, 0x3C, 0x3C, 0x3C, 0x04, 0x04, 0x04, 
        0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x04, 0x04, 0x3C, 0x3C, 0x04, 0x04, 0x3C, 0x04, 0x3C, 0x3C, 0x04, 0x3C, 0x3C, 0x04, 0x04,
  0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0xC9, 0x5C, 0x00, 0x07, 0x00, 0xF0, 0x01, 0x65, 0x62, 0x2F, 0x21, 0x1E, 
        0x53, 0x58, 0x5B, 0x57, 0x47, 0x50, 0x48, 0x23, 0x26, 0x2C, 0x15, 0x6E, 0x00, 0x98, 0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x6F, 0x06, 0x07, 0x73, 0x72, 0x78, 0x26, 0x23, 0x16, 0x1C, 0x50, 0x23, 0x74, 0x75, 0x23, 0x4C, 0x19, 0xA0, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x6C, 0x35, 0x6C, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x8E, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x09, 0x10, 0x10, 0x09, 0x10, 0x10, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x52, 0x52, 0x52, 0x52, 0x52, 0x14, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x14, 0x14, 0x52, 0x52, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x23, 0x55, 0x2F, 0x62, 0x01, 0x65, 0x65, 0x55, 0x50, 0x50, 0x50, 
        0x50, 0x50, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x4C, 0x4C, 0x4C, 0x47, 0x47, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x1A, 0x56, 0x56, 0x56, 0x57, 0x1D, 0x1D, 0x1D, 0x5D, 0x5B, 0x1B, 0x1B, 0x58, 0x58, 0x19, 0x53, 0x1E, 0x67, 0x55, 0x21, 0x21, 0x21, 0x5C, 
        0x1B, 0x1A, 0x50, 0xF0, 0x7B, 0x0E, 0xDD, 0x32, 0x0D, 0x32, 0xDD, 0x73, 0x2C, 0x23, 0x5E, 0x1D, 0x58, 0x55, 0x62, 0x2A, 0x20, 0x5A, 0x63, 0x20, 0x20, 0x2A, 0x6D, 0x01, 0x69, 0x2F, 0x59, 0x55, 0x55, 0x67, 0x1E, 0x53, 0xEB, 0x19, 0x58, 0x58, 0x54, 
        0x1B, 0x1B, 0x5B, 0x5B, 0x5D, 0x1D, 0x5D, 0x1D, 0x1D, 0x57, 0x57, 0x56, 0x56, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x47, 0x47, 0xEF, 0xEF, 0x50, 0x1C, 0x48, 0xAB, 0x41, 0xA4, 0x2C, 0x48, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x04, 0x04, 0x04, 0x3C, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x2B, 0x59, 0x07, 0x0A, 0x04, 0x26, 0x2A, 0x2A, 0x2A, 0x65, 0x62, 0x6B, 0x55, 
        0x1E, 0x19, 0x1B, 0x1D, 0x1A, 0x18, 0x48, 0x41, 0x74, 0x2C, 0x15, 0x0E, 0x00, 0x98, 0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x9A, 0x92, 0x0A, 0x98, 0x00, 0x0E, 0x15, 0x7B, 0x75, 0x41, 0x48, 0x50, 0x4C, 0x56, 0x41, 0x26, 0x75, 0x23, 0x57, 0x58, 0x3F, 0x3F, 
        0x3F, 0x3F, 0x4B, 0x60, 0x60, 0x60, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 
        0x0B, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x8E, 0x03, 0x03, 0x2C, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0xF8, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x55, 0x21, 0x6B, 0x62, 0x69, 0x01, 0x2F, 0x18, 0x18, 0x18, 
        0x18, 0x18, 0x18, 0x4C, 0x4C, 0x4C, 0x47, 0x47, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x56, 0x56, 0x57, 0x57, 0x1D, 0x1D, 0x5D, 0x5D, 0x5D, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0xEB, 0x5C, 0x1E, 0x55, 0x21, 0x21, 0x21, 0x1E, 0x53, 0x1B, 
        0x1A, 0x50, 0x16, 0x26, 0x72, 0x07, 0x08, 0x9A, 0x0D, 0x92, 0xDD, 0x73, 0x78, 0x74, 0x1C, 0x47, 0x5B, 0x5C, 0x59, 0x69, 0x2A, 0x20, 0x5A, 0x5A, 0x5A, 0x20, 0x70, 0x2A, 0x65, 0x01, 0x69, 0x6B, 0x59, 0x21, 0x55, 0x67, 0x1E, 0x5C, 0x53, 0x19, 0x19, 
        0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5D, 0x5D, 0x1D, 0x1D, 0x1D, 0x57, 0x57, 0x56, 0x56, 0x56, 0x56, 0x1A, 0x1A, 0x1A, 0x1A, 0x47, 0x47, 0xEF, 0x9E, 0x1C, 0x48, 0xAB, 0x41, 0x2C, 0x4D, 0x13, 0x13, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x3C, 
        0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x04, 0x04,
  0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x29, 0x59, 0x0E, 0x32, 0x1F, 0x72, 0x20, 0x20, 0x70, 0x70, 0x6D, 0x01, 0x2F, 0x59, 
        0x55, 0x5C, 0x58, 0x5B, 0x56, 0x47, 0x1C, 0x16, 0x75, 0x7B, 0x15, 0x0E, 0x00, 0xDD, 0x0A, 0x1F, 0xA9, 0x0D, 0x0D, 0x32, 0x1F, 0x06, 0x07, 0x73, 0x15, 0x2C, 0x74, 0xF0, 0x48, 0x50, 0x47, 0x56, 0x5D, 0x5B, 0x41, 0x26, 0x75, 0xF0, 0x19, 0x17, 0x35, 
        0x6C, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x39, 0x39, 0x39, 0x39, 0x61, 0x61, 0x61, 0x4D, 0x4D, 0x0B, 0x6C, 0x76, 0x1C, 0x11, 0x37, 0x61, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x4F, 0x4F, 0x4F, 0x33, 0xF8, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x1E, 0x55, 0x21, 0x2F, 0x62, 0x01, 0x69, 0x4C, 0x4C, 0x4C, 
        0x4C, 0x4C, 0x4C, 0x47, 0x47, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x1A, 0x1A, 0x56, 0x56, 0x56, 0x56, 0x57, 0x1D, 0x1D, 0x1D, 0x5D, 0x5D, 0x5B, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0xEB, 0x5C, 0x1E, 0x1E, 0x55, 0x21, 0x21, 0x21, 0x67, 0x19, 0x5B, 0x57, 
        0x18, 0xAB, 0x75, 0x78, 0x73, 0xDD, 0x1F, 0x0D, 0x0D, 0x1F, 0x06, 0x12, 0x15, 0x26, 0x48, 0x4C, 0x1D, 0x58, 0x1E, 0x2F, 0x01, 0x2A, 0x20, 0x63, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x6D, 0x65, 0x69, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x67, 0x67, 0x5C, 0x5C, 
        0xEB, 0x19, 0x19, 0x58, 0x54, 0x54, 0x1B, 0x1B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5D, 0x1D, 0x1D, 0x1D, 0x1D, 0x57, 0x57, 0x56, 0x56, 0x56, 0x56, 0x1A, 0x1A, 0x47, 0x50, 0x9E, 0x1C, 0xAB, 0x41, 0x26, 0x02, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x3C, 0x13, 0x13, 
        0x3C, 0x13, 0x13, 0x3C, 0x05, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x05, 0x13, 0x13, 0x13, 0x13,
  0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x5C, 0xAB, 0x0D, 0x9A, 0x0C, 0x2A, 0x63, 0x63, 0x20, 0x20, 0x2A, 0x6D, 0x69, 0x2F, 
        0x21, 0x1E, 0x19, 0x1B, 0x1D, 0x1A, 0x50, 0xAB, 0x23, 0x7B, 0x78, 0x0E, 0x00, 0xDD, 0x0A, 0x92, 0xA9, 0x0D, 0x0D, 0x92, 0x0A, 0xDD, 0x12, 0x0E, 0x78, 0x26, 0x23, 0xAB, 0x50, 0x4C, 0x56, 0x5B, 0x1B, 0x19, 0x58, 0x75, 0x26, 0x75, 0x16, 0x1E, 0x37, 
        0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x61, 
        0x61, 0x61, 0x61, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x0F, 0x18, 0x1B, 0x54, 0x57, 0x54, 0xBB, 0x41, 0x0B, 0x61, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5B, 0x21, 0x21, 0x67, 0x2F, 0x2F, 0x01, 0x1D, 0x47, 0x47, 
        0x47, 0x47, 0x47, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x56, 0x56, 0x57, 0x57, 0x1D, 0x1D, 0x5D, 0x5D, 0x5B, 0x5B, 0x1B, 0x1B, 0x1B, 0x54, 0x54, 0x58, 0x19, 0x19, 0x53, 0x1E, 0x67, 0x55, 0x21, 0x21, 0x59, 0x21, 0x5C, 0x58, 0x5B, 0x56, 0x18, 
        0x1C, 0x23, 0x2C, 0x7E, 0x52, 0x0A, 0x92, 0x0D, 0x32, 0x6F, 0x04, 0x12, 0x15, 0x26, 0x41, 0x50, 0x1A, 0x5B, 0x19, 0x55, 0x2F, 0x01, 0x2A, 0x70, 0x20, 0x63, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x65, 0x01, 0x69, 0x2F, 0x2F, 0x59, 0x59, 0x21, 0x55, 0x67, 
        0x1E, 0x5C, 0x53, 0xEB, 0x19, 0x58, 0x58, 0x58, 0x54, 0x1B, 0x1B, 0x1B, 0x5B, 0x5B, 0x5B, 0x5D, 0x5D, 0x1D, 0x1D, 0x1D, 0x1D, 0x57, 0x1D, 0x56, 0x56, 0x1A, 0x4C, 0x18, 0x5E, 0x5E, 0xAB, 0x74, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 
        0x13, 0x13, 0x13, 0x13, 0x05, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06,
  0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x24, 0x1E, 0x0A, 0x0D, 0x0D, 0xEB, 0x5A, 0x5A, 0x63, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x69, 
        0x2F, 0x55, 0x5C, 0x58, 0x5B, 0x56, 0x4C, 0x1C, 0xF0, 0x26, 0x78, 0x7E, 0x00, 0xDD, 0x08, 0x92, 0x0D, 0x0D, 0xA9, 0x1F, 0x06, 0x07, 0x6E, 0x15, 0x7B, 0x23, 0xAB, 0x5E, 0x4C, 0x56, 0x5D, 0x54, 0x19, 0x5C, 0x55, 0x54, 0x26, 0x26, 0x75, 0x18, 0x54, 
        0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 
        0x61, 0x61, 0x39, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4D, 0x3D, 0x1D, 0x57, 0xF3, 0xD0, 0xED, 0xBB, 0x4C, 0x57, 0x18, 0x0B, 0x03, 0x03, 0x4F, 0x33, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x7C, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x52, 0x14, 0x14, 0x14, 0x1C, 0x1E, 0x67, 0x67, 0x2F, 0x2F, 0x62, 0x58, 0x1A, 0x47, 
        0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x56, 0x56, 0x57, 0x1D, 0x1D, 0x1D, 0x5D, 0x5D, 0x5B, 0x5B, 0x1B, 0x1B, 0x1B, 0x54, 0x58, 0x58, 0x19, 0xEB, 0x53, 0x5C, 0x1E, 0x55, 0x21, 0x21, 0x59, 0x21, 0x55, 0x1E, 0x58, 0x5B, 0x56, 0x4C, 0x48, 
        0x41, 0x7B, 0x15, 0x73, 0xDD, 0x1F, 0xA9, 0x0D, 0x32, 0x6F, 0xDD, 0x12, 0x15, 0x7B, 0x23, 0x1C, 0x47, 0x1D, 0x54, 0x1E, 0x21, 0x62, 0x65, 0x70, 0x20, 0x5A, 0x63, 0x5A, 0x5A, 0x20, 0x70, 0x2A, 0x2A, 0x65, 0x01, 0x69, 0x2F, 0x2F, 0x59, 0x59, 0x21, 
        0x55, 0x67, 0x1E, 0x1E, 0x5C, 0x53, 0x19, 0x19, 0x58, 0x58, 0x54, 0x54, 0x1B, 0x1B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5D, 0x5D, 0x5D, 0x1D, 0x57, 0x57, 0x57, 0x56, 0x47, 0x4C, 0x50, 0x5E, 0x16, 0xF0, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 
        0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 
        0x3C, 0x3C, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x04, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x05,
  0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x59, 0x74, 0x06, 0x92, 0x26, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x20, 0x70, 0x2A, 0x65, 
        0x69, 0x59, 0x55, 0x53, 0x1B, 0x1D, 0x47, 0x5E, 0x16, 0x74, 0x78, 0x7E, 0x00, 0xDD, 0x08, 0x32, 0x0D, 0x0D, 0x32, 0x6F, 0xDD, 0x12, 0x72, 0x2C, 0x74, 0x16, 0x1C, 0x4C, 0x56, 0x5D, 0x54, 0x53, 0x1E, 0x21, 0x59, 0x59, 0x18, 0x26, 0x26, 0x75, 0xEB, 
        0x17, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x6C, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x6C, 0x3F, 0x5D, 0x5B, 0xCF, 0xF3, 0xCE, 0xC7, 0xBB, 0x5B, 0x1B, 0xAC, 0x50, 0x1B, 0x3F, 0x0B, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 
        0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x23, 0x5C, 0x53, 0x67, 0x21, 0x6B, 0x59, 0x67, 0x56, 0x1A, 
        0x1A, 0x1A, 0x1A, 0x56, 0x56, 0x56, 0x57, 0x57, 0x57, 0x1D, 0x1D, 0x5D, 0x5D, 0x5B, 0x5B, 0x1B, 0x1B, 0x1B, 0x54, 0x54, 0x58, 0x19, 0x19, 0x53, 0x53, 0x5C, 0x1E, 0x1E, 0x55, 0x21, 0x59, 0x59, 0x21, 0x1E, 0x53, 0x58, 0x5D, 0x56, 0x4C, 0x1C, 0x41, 
        0x26, 0x78, 0x0E, 0x52, 0x0C, 0x92, 0x0D, 0x0D, 0x32, 0x6F, 0xDD, 0x12, 0x72, 0x2C, 0x75, 0xAB, 0x18, 0x56, 0x5B, 0x19, 0x67, 0x59, 0x69, 0x6D, 0x2A, 0x20, 0x20, 0x63, 0x63, 0x5A, 0x20, 0x70, 0x70, 0x2A, 0x6D, 0x65, 0x01, 0x69, 0x2F, 0x2F, 0x59, 
        0x21, 0x55, 0x55, 0x67, 0x1E, 0x1E, 0x5C, 0x53, 0xEB, 0x19, 0x19, 0x58, 0x58, 0x54, 0x54, 0x1B, 0x1B, 0x1B, 0x1B, 0x5B, 0x5B, 0x5B, 0x1D, 0x5B, 0x5D, 0x56, 0x56, 0x1A, 0x18, 0x50, 0x23, 0x16, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x04, 0x04, 
        0x04, 0x04, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x04, 0x04, 0x3C, 0x3C, 0x3C, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x05, 0x05,
  0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x54, 0x19, 0x72, 0x00, 0x00, 0x69, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x20, 0x70, 0x2A, 
        0x65, 0x62, 0x59, 0x1E, 0x19, 0x5B, 0x56, 0x18, 0xAB, 0x75, 0x2C, 0x72, 0x00, 0xDD, 0x6F, 0x32, 0x0D, 0x0D, 0x92, 0x0C, 0x52, 0x0E, 0x78, 0x26, 0x41, 0x1C, 0x4C, 0x56, 0x5B, 0x58, 0x53, 0x1E, 0x21, 0x59, 0x59, 0x21, 0x1E, 0x23, 0x7B, 0x26, 0x16, 
        0x55, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x35, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x35, 0x11, 0xBA, 0x5D, 0xAC, 0xBA, 0x85, 0x65, 0x4A, 0x7D, 0x20, 0x63, 0x5A, 0x6A, 0xBA, 0x5E, 0x57, 0x1A, 0x0F, 0x0B, 0x61, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 
        0x33, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x67, 0xEB, 0x5C, 0x1E, 0x55, 0x21, 0x59, 0x1D, 0x1A, 
        0x56, 0x56, 0x57, 0x57, 0x57, 0x1D, 0x1D, 0x1D, 0x1D, 0x5D, 0x5B, 0x5B, 0x1B, 0x1B, 0x1B, 0x1B, 0x54, 0x58, 0x58, 0x19, 0x19, 0xEB, 0x5C, 0x5C, 0x1E, 0x67, 0x55, 0x21, 0x21, 0x59, 0x21, 0x21, 0x1E, 0x19, 0x54, 0x5D, 0x1A, 0x4C, 0x5E, 0x16, 0x75, 
        0xF7, 0x72, 0x12, 0x05, 0x08, 0x32, 0x0D, 0x0D, 0x32, 0x08, 0xDD, 0x12, 0x7E, 0x2C, 0x26, 0x16, 0x50, 0x1A, 0x1D, 0x58, 0x5C, 0x55, 0x6B, 0x69, 0x65, 0x2A, 0x20, 0x5A, 0x63, 0x63, 0x5A, 0x20, 0x20, 0x70, 0x2A, 0x2A, 0x6D, 0x01, 0x69, 0x62, 0x2F, 
        0x6B, 0x59, 0x21, 0x21, 0x55, 0x67, 0x67, 0x1E, 0x1E, 0x5C, 0x53, 0xEB, 0x19, 0x58, 0x58, 0x58, 0x58, 0x54, 0x54, 0x1B, 0x1B, 0x1B, 0x5B, 0x54, 0x5B, 0x1D, 0x1D, 0x1A, 0x47, 0x4C, 0x7B, 0x26, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x2F, 0x18, 0x7B, 0x72, 0x1D, 0x01, 0x65, 0x6D, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x63, 0x5A, 0x70, 
        0x2A, 0x65, 0x2F, 0x21, 0x5C, 0x54, 0x1D, 0x4C, 0x48, 0x23, 0xF7, 0x72, 0x12, 0xDD, 0x6F, 0x32, 0x0D, 0xA9, 0x6F, 0xDD, 0x12, 0x15, 0x7B, 0xF0, 0x1C, 0x18, 0x56, 0x5B, 0x58, 0x53, 0x67, 0x59, 0x59, 0x21, 0x55, 0x67, 0x67, 0x56, 0xF7, 0x7B, 0x74, 
        0x54, 0x68, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 
        0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x11, 0x3D, 0x11, 0x68, 0xBA, 0xB8, 0xCB, 0xC6, 0x94, 0x94, 0x34, 0x5A, 0x9B, 0x9B, 0x6A, 0x80, 0x34, 0x8C, 0x6A, 0x59, 0x69, 0xCB, 0x58, 0x50, 0x0F, 0x6C, 0x35, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 
        0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x53, 0x53, 0x19, 0x5C, 0x1E, 0x21, 0x21, 0x5B, 0x56, 
        0x57, 0x1D, 0x1D, 0x1D, 0x1D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5B, 0x1B, 0x1B, 0x1B, 0x1B, 0x54, 0x58, 0x58, 0x19, 0x19, 0xEB, 0x53, 0x5C, 0x1E, 0x1E, 0x67, 0x55, 0x21, 0x59, 0x59, 0x21, 0x55, 0x1E, 0x19, 0x1B, 0x5D, 0x56, 0x4C, 0x50, 0x48, 0x23, 0x7B, 
        0x15, 0x73, 0x07, 0x06, 0x1F, 0x9A, 0x0D, 0x0D, 0x92, 0x08, 0xDD, 0x12, 0x7E, 0x78, 0x26, 0x41, 0x1C, 0x4C, 0x56, 0x5B, 0x58, 0x5C, 0x55, 0x2F, 0x69, 0x65, 0x2A, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x5A, 0x20, 0x70, 0x70, 0x2A, 0x6D, 0x65, 0x01, 0x69, 
        0x62, 0x2F, 0x2F, 0x59, 0x59, 0x21, 0x55, 0x55, 0x67, 0x1E, 0x1E, 0x5C, 0x53, 0xEB, 0x19, 0x19, 0x19, 0x58, 0x58, 0x58, 0x54, 0x54, 0x1B, 0x58, 0x5B, 0x5B, 0x5D, 0x56, 0x56, 0x47, 0x74, 0x0E, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x04, 0x04, 0x04, 0x13, 0x04, 0x04, 0x04, 0x13, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x3A, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0xC9, 0x67, 0x18, 0x41, 0x41, 0x2F, 0x2F, 0x01, 0x01, 0x65, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x5A, 
        0x20, 0x2A, 0x01, 0x2F, 0x55, 0x19, 0x5B, 0x1A, 0x50, 0x41, 0x7B, 0x15, 0x12, 0x04, 0x1F, 0xA9, 0x0D, 0x32, 0x0A, 0x52, 0x0E, 0x2C, 0x23, 0x48, 0x18, 0x56, 0x5B, 0x58, 0x1E, 0x21, 0x6B, 0x59, 0x21, 0x67, 0x1E, 0x5C, 0x53, 0x53, 0x74, 0x7B, 0x26, 
        0x16, 0x1B, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0xA0, 0xA0, 
        0xA0, 0xA0, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x0B, 0x37, 0xA0, 0xCC, 0x5B, 0x9F, 0x53, 0x77, 0x85, 0xB8, 0x1B, 0x24, 0xB7, 0xBC, 0xB5, 0x24, 0x24, 0xBC, 0x2B, 0xB7, 0x5A, 0x7D, 0x6B, 0x56, 0xBA, 0x56, 0x23, 0x8E, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 
        0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x1C, 0xEB, 0x58, 0x19, 0x53, 0x55, 0x55, 0x58, 0x1D, 
        0x1D, 0x1D, 0x5D, 0x5D, 0x5D, 0x5B, 0x5B, 0x5B, 0x1B, 0x1B, 0x1B, 0x54, 0x54, 0x58, 0x58, 0x19, 0x19, 0x53, 0x53, 0x5C, 0x1E, 0x1E, 0x67, 0x55, 0x21, 0x21, 0x59, 0x59, 0x21, 0x55, 0x5C, 0x58, 0x1B, 0x5D, 0x56, 0x47, 0x50, 0x48, 0xF0, 0x26, 0x78, 
        0x7E, 0x00, 0x98, 0x0A, 0x32, 0x0D, 0x0D, 0x9A, 0x92, 0x0A, 0xDD, 0x12, 0x0E, 0x78, 0x7B, 0x23, 0x48, 0x18, 0x1A, 0x1D, 0x54, 0xEB, 0x1E, 0x21, 0x2F, 0x01, 0x6D, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x63, 0x5A, 0x20, 0x20, 0x70, 0x2A, 0x2A, 0x65, 0x01, 
        0x69, 0x69, 0x62, 0x2F, 0x2F, 0x59, 0x59, 0x21, 0x21, 0x55, 0x67, 0x1E, 0x1E, 0x5C, 0x5C, 0x53, 0xEB, 0x19, 0x19, 0x19, 0x58, 0x58, 0x58, 0x58, 0x1B, 0x54, 0x5B, 0x57, 0x1D, 0x18, 0xF0, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x3C, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x05, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x07, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C,
  0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x90, 0x5C, 0x1D, 0x18, 0x54, 0x21, 0x59, 0x2F, 0x2F, 0x69, 0x01, 0x6D, 0x2A, 0x70, 0x20, 0x5A, 0x63, 
        0x5A, 0x70, 0x2A, 0x69, 0x59, 0x1E, 0x58, 0x1D, 0x18, 0x16, 0x26, 0x15, 0x12, 0x04, 0x1F, 0x0D, 0x0D, 0x1F, 0xDD, 0x73, 0x78, 0x75, 0xAB, 0x18, 0x56, 0x1B, 0x19, 0x1E, 0x21, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x5C, 0xEB, 0x19, 0x58, 0x4C, 0x2C, 0x7B, 
        0x7B, 0x53, 0x9F, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 
        0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0x3D, 0x1A, 0xB8, 0xBC, 0xBC, 0x59, 0x67, 0x54, 0xAF, 0x6A, 0x80, 0x34, 0x77, 0x77, 0x4A, 0x34, 0x34, 0x9B, 0x9B, 0x5F, 0x2B, 0xA3, 0x6A, 0x6A, 0xA3, 0xBB, 0x1B, 0x4C, 0x6C, 0x4D, 0x8E, 0x03, 0x03, 0x03, 
        0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8E, 0x53, 0x5B, 0x58, 0x19, 0x5C, 0x1E, 0x5C, 0x5B, 
        0x5D, 0x5D, 0x5B, 0x5B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x54, 0x58, 0x58, 0x58, 0x19, 0x19, 0xEB, 0x53, 0x5C, 0x1E, 0x1E, 0x67, 0x55, 0x21, 0x21, 0x59, 0x59, 0x21, 0x55, 0x1E, 0x5C, 0x58, 0x1B, 0x1D, 0x1A, 0x47, 0x50, 0xAB, 0xF0, 0x26, 0x2C, 0x15, 
        0x6E, 0x07, 0x04, 0x6F, 0x32, 0x0D, 0x0D, 0xA9, 0x1F, 0x0A, 0xDD, 0x00, 0x0E, 0x15, 0x7B, 0x23, 0xAB, 0x50, 0x4C, 0x57, 0x5B, 0x58, 0x5C, 0x67, 0x59, 0x62, 0x01, 0x65, 0x2A, 0x20, 0x20, 0x63, 0x63, 0x63, 0x63, 0x20, 0x20, 0x70, 0x70, 0x2A, 0x6D, 
        0x65, 0x01, 0x69, 0x69, 0x62, 0x2F, 0x2F, 0x6B, 0x59, 0x21, 0x21, 0x55, 0x55, 0x67, 0x1E, 0x1E, 0x5C, 0x5C, 0x53, 0xEB, 0x19, 0x19, 0x19, 0xEB, 0x58, 0x58, 0x5B, 0x5B, 0x1D, 0x41, 0x23, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x3C, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07,
  0x3B, 0x3B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x6B, 0x59, 0x19, 0x5D, 0x1E, 0x67, 0x55, 0x21, 0x59, 0x2F, 0x62, 0x69, 0x65, 0x2A, 0x70, 0x20, 0x5A, 
        0x63, 0x5A, 0x20, 0x2A, 0x69, 0x21, 0x53, 0x1B, 0x1A, 0x48, 0x75, 0x15, 0x12, 0x04, 0x92, 0x0D, 0x9A, 0x08, 0x52, 0x72, 0x26, 0x16, 0x18, 0x56, 0x1B, 0x19, 0x67, 0x59, 0x59, 0x55, 0x67, 0x1E, 0x53, 0x53, 0x19, 0x58, 0x54, 0x54, 0x5B, 0x2C, 0x2C, 
        0x7B, 0x50, 0x1B, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x4B, 0x4B, 0x3F, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x6C, 0x0F, 0x0F, 0x25, 0xB8, 0xBC, 0x3F, 0xBC, 0x9B, 0xAF, 0x67, 0x20, 0x5A, 0x34, 0x7A, 0x7A, 0x4A, 0x4A, 0x7D, 0x34, 0x93, 0x7A, 0x7A, 0x64, 0x5A, 0x85, 0xB7, 0x62, 0x6A, 0x21, 0x5B, 0x5B, 0x1D, 0xF0, 0x61, 0x61, 0x03, 0x03, 
        0x03, 0x4F, 0x33, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x53, 0x5B, 0x1B, 0x58, 0x58, 0x5C, 0x1E, 0x1B, 
        0x5B, 0x5B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x54, 0x54, 0x58, 0x58, 0x19, 0x19, 0xEB, 0x53, 0x5C, 0x5C, 0x1E, 0x1E, 0x55, 0x55, 0x21, 0x59, 0x6B, 0x6B, 0x21, 0x55, 0x1E, 0x53, 0x58, 0x1B, 0x5D, 0x1A, 0x47, 0x18, 0x1C, 0x41, 0x75, 0x7B, 0x78, 0x0E, 
        0x12, 0x98, 0x0A, 0x92, 0x9A, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0xDD, 0x00, 0x0E, 0x15, 0x7B, 0x74, 0x41, 0x1C, 0x50, 0x1A, 0x1D, 0x1B, 0x19, 0x5C, 0x55, 0x2F, 0x69, 0x01, 0x2A, 0x70, 0x70, 0x20, 0x5A, 0x63, 0x63, 0x5A, 0x20, 0x20, 0x20, 0x70, 0x2A, 
        0x2A, 0x6D, 0x65, 0x01, 0x01, 0x69, 0x2F, 0x2F, 0x6B, 0x59, 0x59, 0x21, 0x21, 0x55, 0x67, 0x67, 0x1E, 0x1E, 0x5C, 0x5C, 0x53, 0xEB, 0x53, 0x1E, 0xEB, 0x19, 0x1B, 0x1B, 0x1D, 0x23, 0x02, 0x13, 0x13, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x13, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0xB7, 0x6B, 0x65, 0x21, 0x53, 0xEB, 0x53, 0x1E, 0x67, 0x55, 0x21, 0x59, 0x2F, 0x69, 0x01, 0x65, 0x2A, 0x70, 
        0x20, 0x63, 0x5A, 0x20, 0x6D, 0x62, 0x55, 0x58, 0x57, 0x50, 0x41, 0x2C, 0x73, 0x04, 0x92, 0x0D, 0x32, 0x04, 0x0E, 0xF7, 0x41, 0x50, 0x56, 0x1B, 0x53, 0x55, 0x59, 0x21, 0x55, 0x1E, 0x5C, 0xEB, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5D, 0x41, 0x78, 
        0x2C, 0xD4, 0x55, 0x4B, 0x4B, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 
        0x0F, 0x0F, 0xA0, 0x11, 0x50, 0xC6, 0x1B, 0xBD, 0x62, 0x80, 0x31, 0x90, 0x5A, 0x80, 0x7D, 0x4A, 0x7A, 0x5A, 0x90, 0x85, 0xB5, 0x85, 0xB5, 0x90, 0x9B, 0x34, 0x64, 0x7A, 0x7A, 0x7D, 0x6A, 0xB8, 0x80, 0x80, 0x6B, 0x54, 0x5C, 0xBB, 0x3D, 0x6C, 0x0B, 
        0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x18, 0x58, 0x5D, 0x54, 0x54, 0x58, 0x5C, 0xEB, 
        0x5B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0x19, 0x19, 0x19, 0x53, 0x53, 0x5C, 0x1E, 0x1E, 0x1E, 0x67, 0x55, 0x21, 0x59, 0x6B, 0x6B, 0x21, 0x55, 0x1E, 0x19, 0x58, 0x1B, 0x1D, 0x56, 0x47, 0x18, 0x1C, 0x16, 0x23, 0x7B, 0x78, 0x72, 0x73, 
        0x07, 0x06, 0x6F, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x52, 0x6E, 0x15, 0x2C, 0x74, 0x41, 0x48, 0x50, 0x47, 0x56, 0x5D, 0x58, 0x53, 0x1E, 0x21, 0x2F, 0x69, 0x01, 0x2A, 0x2A, 0x20, 0x20, 0x5A, 0x63, 0x34, 0x63, 0x5A, 0x20, 0x20, 0x70, 
        0x70, 0x2A, 0x2A, 0x6D, 0x65, 0x01, 0x69, 0x69, 0x62, 0x2F, 0x2F, 0x6B, 0x59, 0x59, 0x59, 0x55, 0x67, 0x21, 0x5C, 0x67, 0x1E, 0x53, 0x55, 0x1E, 0x5C, 0xEB, 0x19, 0x54, 0x56, 0x41, 0x06, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C,
  0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x55, 0x20, 0x20, 0x65, 0x19, 0x58, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x67, 0x21, 0x59, 0x2F, 0x62, 0x01, 0x6D, 
        0x70, 0x20, 0x63, 0x5A, 0x70, 0x65, 0x2F, 0x1E, 0x1B, 0x47, 0x16, 0x2C, 0x73, 0x06, 0x32, 0x0D, 0x6F, 0x52, 0x78, 0x23, 0x50, 0x1A, 0x1B, 0x5C, 0x21, 0x59, 0x21, 0x1E, 0x5C, 0xEB, 0x19, 0x58, 0x54, 0x1B, 0x5B, 0x5B, 0x5D, 0x1D, 0x1D, 0x18, 0xDA, 
        0x78, 0x2C, 0x19, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x37, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 
        0x35, 0x0F, 0x18, 0xAF, 0x54, 0xBD, 0xBD, 0x85, 0x62, 0xBC, 0x65, 0x5A, 0x20, 0x30, 0x77, 0x2F, 0x55, 0x62, 0x5A, 0x34, 0x7A, 0x7A, 0x34, 0x77, 0x9B, 0x21, 0x67, 0x80, 0x77, 0xAA, 0x64, 0x99, 0x20, 0x85, 0x6A, 0x6A, 0x58, 0x47, 0x54, 0x18, 0x23, 
        0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x03, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x09, 0x10, 0x0B, 0x19, 0x1D, 0x5D, 0x5B, 0x54, 0x19, 0xEB, 
        0x1B, 0x1B, 0x1B, 0x54, 0x58, 0x58, 0x58, 0x19, 0x19, 0x19, 0xEB, 0x53, 0x5C, 0x1E, 0x1E, 0x1E, 0x55, 0x55, 0x21, 0x21, 0x59, 0x59, 0x59, 0x21, 0x1E, 0x5C, 0x19, 0x58, 0x1B, 0x1D, 0x1A, 0x47, 0x50, 0x1C, 0x16, 0x23, 0x26, 0x2C, 0x15, 0x0E, 0x12, 
        0x05, 0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0xFD, 0x98, 0x52, 0x6E, 0x15, 0x78, 0x26, 0x23, 0xAB, 0x5E, 0x4C, 0x56, 0x1D, 0x54, 0x19, 0x5C, 0x55, 0x59, 0x2F, 0x69, 0x65, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x63, 0x5A, 0x20, 0x20, 
        0x70, 0x70, 0x2A, 0x2A, 0x6D, 0x65, 0x01, 0x01, 0x69, 0x62, 0x2F, 0x2F, 0x6B, 0x59, 0x59, 0x21, 0x21, 0x21, 0x67, 0x67, 0x55, 0x1E, 0x55, 0x55, 0x55, 0x1E, 0x19, 0x53, 0x48, 0x23, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x13, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x62, 0x4A, 0x34, 0x70, 0x5B, 0x5B, 0x1B, 0x1B, 0x58, 0x58, 0x19, 0x53, 0x5C, 0x67, 0x55, 0x59, 0x2F, 0x69, 
        0x65, 0x2A, 0x20, 0x5A, 0x63, 0x70, 0x65, 0x59, 0xEB, 0x57, 0x1C, 0x7B, 0x6E, 0x0C, 0xA9, 0xA9, 0xDD, 0x7E, 0x74, 0x1C, 0x56, 0x54, 0x1E, 0x21, 0x21, 0x55, 0x1E, 0xEB, 0x19, 0x58, 0x1B, 0x1B, 0x5B, 0x5D, 0x1D, 0x1D, 0x57, 0x56, 0x56, 0x1A, 0xA2, 
        0xDA, 0x78, 0x18, 0x2B, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 
        0x74, 0x54, 0xC8, 0xD0, 0xB1, 0xCA, 0x7D, 0x80, 0x5D, 0x5A, 0x20, 0x93, 0x84, 0x85, 0x53, 0x5A, 0x4A, 0x4A, 0x34, 0x9B, 0x5F, 0x67, 0x62, 0x80, 0x7D, 0x30, 0x4A, 0x85, 0x90, 0x20, 0x99, 0x7A, 0x64, 0xC3, 0x2B, 0x5A, 0x30, 0xE5, 0xD3, 0xED, 0x5D, 
        0x41, 0x0B, 0x0B, 0x61, 0x61, 0x8E, 0x39, 0x39, 0x39, 0x03, 0x03, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x27, 0x27, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x00, 0x12, 0x12, 0x00, 0x00, 0x54, 0x1D, 0x57, 0x5D, 0x1B, 0x54, 0xEB, 
        0x58, 0x58, 0x54, 0x58, 0x19, 0x19, 0xEB, 0x19, 0xEB, 0x53, 0x5C, 0x1E, 0x1E, 0x1E, 0x67, 0x67, 0x21, 0x21, 0x59, 0x59, 0x59, 0x21, 0x55, 0x67, 0x5C, 0x19, 0x54, 0x1B, 0x1D, 0x56, 0x47, 0x18, 0x1C, 0xAB, 0xF0, 0x74, 0x7B, 0x78, 0x0E, 0x73, 0x07, 
        0x04, 0x08, 0x92, 0x9A, 0x0D, 0x0D, 0xA9, 0x92, 0x1F, 0x0C, 0x98, 0x52, 0x6E, 0x72, 0x78, 0x7B, 0x23, 0x16, 0x1C, 0x18, 0x1A, 0x57, 0x5B, 0x58, 0x19, 0x1E, 0x55, 0x59, 0x2F, 0x01, 0x65, 0x2A, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x63, 0x63, 0x5A, 0x5A, 
        0x20, 0x20, 0x70, 0x70, 0x2A, 0x2A, 0x6D, 0x65, 0x01, 0x01, 0x69, 0x62, 0x2F, 0x2F, 0x2F, 0x59, 0x2F, 0x21, 0x21, 0x55, 0x59, 0x1E, 0x55, 0x21, 0x21, 0x67, 0x53, 0x53, 0x23, 0x0E, 0x07, 0x07, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x07, 0x07, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C,
  0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x24, 0x62, 0x30, 0x4A, 0x6D, 0x1D, 0x1D, 0x1D, 0x5D, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0x5C, 0x1E, 0x55, 0x59, 
        0x2F, 0x69, 0x6D, 0x70, 0x20, 0x5A, 0x20, 0x01, 0x55, 0x1B, 0x18, 0x74, 0x0E, 0x0A, 0x9A, 0x92, 0x12, 0x7B, 0x48, 0x56, 0x58, 0x55, 0x21, 0x55, 0x1E, 0xEB, 0x58, 0x54, 0x1B, 0x5B, 0x5D, 0x1D, 0x1D, 0x57, 0x56, 0x1A, 0x1A, 0x1A, 0x47, 0x47, 0x7B, 
        0x72, 0x15, 0x23, 0x58, 0x17, 0x17, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x0B, 0x0B, 
        0xEF, 0xB9, 0xD5, 0xA3, 0xB5, 0x7D, 0x6A, 0xCC, 0x20, 0x34, 0xDF, 0x20, 0x53, 0x85, 0x7A, 0x34, 0x5D, 0x16, 0x74, 0x16, 0x47, 0x50, 0x47, 0x16, 0x0B, 0x17, 0x2F, 0x93, 0x7A, 0xB4, 0x85, 0x77, 0x77, 0xAA, 0x85, 0x11, 0x80, 0x30, 0x62, 0x50, 0xEE, 
        0x5B, 0x11, 0x61, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 
        0x09, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x12, 0x12, 0x00, 0x12, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x50, 0x1B, 0x56, 0x1D, 0x5B, 0x5B, 0x58, 
        0x58, 0x58, 0x58, 0x19, 0x19, 0xEB, 0x53, 0x53, 0x5C, 0x1E, 0x1E, 0x1E, 0x67, 0x55, 0x55, 0x55, 0x59, 0x59, 0x59, 0x59, 0x21, 0x55, 0x1E, 0x53, 0x19, 0x58, 0x1B, 0x1D, 0x56, 0x47, 0x18, 0x5E, 0xAB, 0x41, 0x75, 0x7B, 0x78, 0x72, 0x6E, 0x00, 0xDD, 
        0xFD, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x6F, 0x0C, 0x05, 0x52, 0x73, 0x72, 0x78, 0x7B, 0x75, 0x41, 0x48, 0x50, 0x4C, 0x56, 0x5D, 0x1B, 0x58, 0x53, 0x67, 0x21, 0x6B, 0x62, 0x01, 0x6D, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x63, 0x63, 
        0x5A, 0x20, 0x20, 0x70, 0x70, 0x2A, 0x2A, 0x2A, 0x6D, 0x65, 0x01, 0x69, 0x69, 0x62, 0x2F, 0x2F, 0x2F, 0x59, 0x6B, 0x59, 0x21, 0x5C, 0x1E, 0x67, 0x21, 0x67, 0x55, 0x57, 0x41, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 
        0x3C, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x05, 0x13, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x2B, 0xB7, 0x6D, 0x30, 0x30, 0x62, 0x1A, 0x56, 0x56, 0x57, 0x57, 0x1D, 0x5D, 0x5B, 0x5B, 0x1B, 0x54, 0x58, 0x53, 0x1E, 
        0x55, 0x59, 0x2F, 0x01, 0x2A, 0x20, 0x5A, 0x20, 0x01, 0x5C, 0x56, 0xF0, 0x7E, 0x08, 0x0D, 0xFD, 0x15, 0xAB, 0x56, 0x19, 0x21, 0x21, 0x1E, 0x53, 0x19, 0x54, 0x1B, 0x5B, 0x1D, 0x1D, 0x57, 0x56, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x4C, 0x18, 0x18, 0x75, 
        0x7E, 0x72, 0x78, 0x53, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 
        0x5B, 0xBE, 0xC8, 0xBB, 0x34, 0x80, 0xCC, 0x5A, 0x5A, 0x30, 0x01, 0xEB, 0x4A, 0x30, 0xCC, 0x03, 0x19, 0x7D, 0x93, 0x30, 0x30, 0x93, 0x93, 0x93, 0x30, 0x01, 0x3D, 0x0F, 0x85, 0x30, 0x80, 0x85, 0x8B, 0x77, 0x93, 0x24, 0x4D, 0x59, 0x30, 0xC1, 0xE7, 
        0xBE, 0x47, 0x39, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x02, 0x5C, 0x47, 0x1A, 0x57, 0x1D, 0x5B, 
        0x58, 0x58, 0x19, 0xEB, 0xEB, 0xEB, 0x53, 0x5C, 0x1E, 0x1E, 0x1E, 0x67, 0x55, 0x21, 0x21, 0x21, 0x6B, 0x59, 0x59, 0x21, 0x55, 0x1E, 0xEB, 0x58, 0x1B, 0x5B, 0x1D, 0x1A, 0x47, 0x18, 0x1C, 0x48, 0xF0, 0x23, 0x26, 0x2C, 0x15, 0x0E, 0x12, 0x07, 0x06, 
        0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x6F, 0x06, 0x05, 0x52, 0x73, 0x72, 0x78, 0xF7, 0x74, 0x23, 0x16, 0x5E, 0x18, 0x1A, 0x57, 0x5B, 0x54, 0x19, 0x1E, 0x55, 0x21, 0x2F, 0x62, 0x01, 0x65, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x5A, 0x63, 0x63, 
        0x63, 0x5A, 0x20, 0x20, 0x70, 0x70, 0x2A, 0x2A, 0x2A, 0x6D, 0x65, 0x65, 0x01, 0x69, 0x69, 0x69, 0x2F, 0x2F, 0x2F, 0x6B, 0x1E, 0x19, 0x5C, 0x5C, 0x21, 0x55, 0x59, 0x41, 0x23, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x3C, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x3C, 0x3C, 0x3C, 0x13, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x52, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x3B, 0x21, 0x63, 0x30, 0x30, 0x53, 0x4C, 0x4C, 0x47, 0x47, 0x47, 0x1A, 0x56, 0x56, 0x1D, 0x1D, 0x5D, 0x5B, 0x1B, 0x58, 
        0x19, 0x5C, 0x67, 0x59, 0x62, 0x65, 0x70, 0x5A, 0x20, 0x2F, 0x58, 0x1C, 0x72, 0x6F, 0x32, 0x73, 0xF0, 0x56, 0x5C, 0x21, 0x55, 0x5C, 0x58, 0x54, 0x1B, 0x5D, 0x1D, 0x57, 0x56, 0x1A, 0x47, 0x47, 0x4C, 0x4C, 0x18, 0x18, 0x18, 0x50, 0x50, 0x50, 0x41, 
        0x6E, 0x7E, 0x7E, 0x1E, 0x17, 0x17, 0x17, 0x3F, 0x4B, 0x4B, 0x76, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x6C, 
        0x4C, 0xAC, 0xB5, 0xB6, 0x8B, 0x5F, 0x85, 0x20, 0x30, 0x21, 0x54, 0x8C, 0x01, 0xDB, 0x5B, 0xDF, 0x30, 0x6D, 0x57, 0xFA, 0x97, 0x8A, 0x52, 0x72, 0x5B, 0x34, 0x30, 0x70, 0x0F, 0x24, 0x93, 0x34, 0x62, 0xC2, 0x4A, 0x4A, 0x1A, 0x25, 0x63, 0x34, 0x34, 
        0xC6, 0x7B, 0x0B, 0x39, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x15, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x47, 0x57, 0x47, 0x56, 0x1D, 0x5D, 
        0x1B, 0x58, 0xEB, 0x5C, 0x5C, 0x5C, 0x1E, 0x1E, 0x1E, 0x1E, 0x55, 0x55, 0x21, 0x21, 0x59, 0x6B, 0x59, 0x21, 0x21, 0x67, 0x1E, 0xEB, 0x58, 0x54, 0x5B, 0x1D, 0x56, 0x47, 0x18, 0x5E, 0x48, 0x16, 0x23, 0x26, 0x2C, 0x78, 0x72, 0x73, 0x52, 0x05, 0xFD, 
        0x6F, 0x92, 0x9A, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x6F, 0x06, 0x05, 0x52, 0x73, 0x72, 0x15, 0xF7, 0x26, 0x23, 0x41, 0x1C, 0x50, 0x4C, 0x56, 0x5D, 0x1B, 0x58, 0x53, 0x1E, 0x55, 0x59, 0x2F, 0x69, 0x01, 0x6D, 0x2A, 0x70, 0x20, 0x20, 0x20, 0x63, 0x63, 
        0x63, 0x63, 0x5A, 0x20, 0x20, 0x20, 0x70, 0x70, 0x2A, 0x2A, 0x2A, 0x6D, 0x65, 0x65, 0x69, 0x01, 0x2F, 0x69, 0x2F, 0x59, 0x19, 0x58, 0x19, 0xEB, 0x55, 0x21, 0x19, 0xF0, 0x00, 0x00, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x38, 0x38, 0x38, 0x3A, 0x3A, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x67, 0x7D, 0x30, 0x30, 0x57, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x57, 0x1D, 
        0x5B, 0x1B, 0x54, 0x19, 0x1E, 0x21, 0x62, 0x2A, 0x5A, 0x20, 0x59, 0x1A, 0x78, 0x92, 0x0A, 0x26, 0x57, 0x1E, 0x55, 0x5C, 0x58, 0x1B, 0x5D, 0x1D, 0x56, 0x1A, 0x47, 0x47, 0x4C, 0x4C, 0x18, 0x18, 0x50, 0x50, 0x50, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x41, 
        0x73, 0x0E, 0x7E, 0x1B, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x46, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0xA0, 
        0x18, 0xAF, 0xB8, 0x93, 0xB5, 0x28, 0x80, 0x30, 0x20, 0x4C, 0x30, 0xC7, 0xFB, 0xC1, 0x94, 0x6D, 0xFC, 0x0D, 0x0C, 0x75, 0x48, 0x54, 0x47, 0xD4, 0xA5, 0x0D, 0xA4, 0x34, 0x7A, 0x53, 0x3D, 0x93, 0x7A, 0x1E, 0xC2, 0xAA, 0x34, 0x74, 0xB8, 0x7D, 0x6A, 
        0x70, 0x48, 0x6C, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x15, 0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x14, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x02, 0x54, 0x18, 0x1A, 0x56, 0x1D, 
        0x5D, 0x1B, 0x19, 0x5C, 0x1E, 0x1E, 0x1E, 0x67, 0x55, 0x55, 0x21, 0x21, 0x59, 0x59, 0x59, 0x59, 0x21, 0x55, 0x1E, 0x5C, 0x19, 0x58, 0x1B, 0x1B, 0x1D, 0x56, 0x47, 0x18, 0x50, 0x48, 0x16, 0xF0, 0x74, 0x7B, 0x78, 0x15, 0x0E, 0x12, 0x07, 0xDD, 0x08, 
        0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x1F, 0x6F, 0x06, 0x05, 0x52, 0x73, 0x7E, 0x15, 0x2C, 0x26, 0x75, 0x41, 0x48, 0x50, 0x18, 0x1A, 0x57, 0x5D, 0x54, 0x19, 0x53, 0x67, 0x21, 0x59, 0x2F, 0x69, 0x01, 0x6D, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x5A, 
        0x63, 0x63, 0x63, 0x5A, 0x5A, 0x20, 0x20, 0x20, 0x70, 0x70, 0x2A, 0x2A, 0x6D, 0x6D, 0x65, 0x65, 0x69, 0x01, 0x2F, 0x5C, 0x1B, 0x1B, 0x58, 0x19, 0x5C, 0x5C, 0x1C, 0x74, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x21, 0x7A, 0xDF, 0x93, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 
        0x1A, 0x56, 0x57, 0x1D, 0x5B, 0x58, 0x53, 0x55, 0x69, 0x70, 0x70, 0x53, 0x26, 0x92, 0x7E, 0x56, 0x1E, 0x1E, 0x58, 0x5B, 0x57, 0x1A, 0x47, 0x47, 0x18, 0x18, 0x50, 0x50, 0x50, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x16, 
        0xFC, 0x73, 0x0E, 0x1A, 0x3D, 0x3D, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x76, 
        0x56, 0x5B, 0xB5, 0x80, 0x5F, 0x20, 0x7D, 0x34, 0x48, 0x30, 0x6B, 0x98, 0x94, 0x94, 0xAB, 0x0D, 0xFC, 0x62, 0x4A, 0x30, 0x30, 0x84, 0x30, 0x4A, 0x7D, 0x5C, 0xAD, 0x92, 0x62, 0x30, 0x19, 0x73, 0x93, 0x34, 0x1E, 0x7A, 0x4A, 0xC3, 0x76, 0x5A, 0x63, 
        0x6D, 0x18, 0x6C, 0x0B, 0x61, 0x61, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 
        0x4F, 0x33, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x19, 0x57, 0x4C, 0x4C, 0x56, 
        0x57, 0x5D, 0x58, 0x53, 0x1E, 0x67, 0x67, 0x1E, 0x55, 0x21, 0x59, 0x6B, 0x6B, 0x59, 0x59, 0x21, 0x1E, 0x1E, 0x53, 0x19, 0x58, 0x1B, 0x5B, 0x1D, 0x1A, 0x1A, 0x18, 0x50, 0x1C, 0x16, 0x23, 0x75, 0x26, 0x2C, 0x15, 0x0E, 0x73, 0x52, 0xDD, 0x06, 0x6F, 
        0x92, 0x32, 0x0D, 0x0D, 0x0D, 0xA9, 0x32, 0x1F, 0x08, 0x04, 0x05, 0x52, 0x73, 0x7E, 0x15, 0x2C, 0x7B, 0x75, 0x41, 0x48, 0x5E, 0x18, 0x47, 0x56, 0x1D, 0x1B, 0x58, 0xEB, 0x1E, 0x55, 0x21, 0x2F, 0x62, 0x01, 0x65, 0x6D, 0x2A, 0x70, 0x70, 0x20, 0x5A, 
        0x63, 0x63, 0x63, 0x63, 0x5A, 0x5A, 0x20, 0x20, 0x20, 0x70, 0x70, 0x2A, 0x2A, 0x2A, 0x6D, 0x65, 0x65, 0x69, 0x2F, 0x1B, 0x1D, 0x5B, 0x1B, 0xEB, 0x58, 0x54, 0x41, 0x27, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x01, 0x34, 0x4A, 0x94, 0xAB, 0x16, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x5E, 
        0x5E, 0x50, 0x50, 0x18, 0x47, 0x1A, 0x56, 0x5D, 0x54, 0x67, 0x65, 0x2A, 0x1C, 0x0C, 0x1A, 0x5C, 0x54, 0x57, 0x1A, 0x47, 0x18, 0x50, 0x5E, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0x48, 0x48, 0xAB, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0x16, 
        0x72, 0xFC, 0xFC, 0x50, 0xC9, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x3F, 
        0x5D, 0x5B, 0x7D, 0xB6, 0xB8, 0x80, 0x30, 0x56, 0x34, 0x20, 0xA5, 0x63, 0xDF, 0x7B, 0x0D, 0x58, 0x30, 0x8C, 0x4A, 0x34, 0x77, 0x63, 0x63, 0x7D, 0x84, 0x8C, 0x8C, 0x26, 0x0D, 0x5B, 0x30, 0x1E, 0x23, 0x30, 0x59, 0x62, 0x7A, 0x64, 0x68, 0xB5, 0x7D, 
        0x01, 0x4C, 0xA0, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x61, 0x1B, 0x50, 0x47, 0x47, 
        0x1A, 0x1D, 0x5D, 0x58, 0x55, 0x21, 0x67, 0x21, 0x21, 0x21, 0x6B, 0x59, 0x21, 0x21, 0x55, 0x1E, 0x1E, 0x53, 0x19, 0x58, 0x1B, 0x5D, 0x1D, 0x56, 0x47, 0x4C, 0x50, 0x1C, 0xAB, 0xF0, 0x75, 0x26, 0x2C, 0x78, 0x72, 0x6E, 0x12, 0x07, 0x04, 0x0A, 0x6F, 
        0x32, 0x0D, 0x0D, 0x0D, 0x0D, 0x32, 0x32, 0x1F, 0x08, 0x04, 0x05, 0x52, 0x73, 0x7E, 0x15, 0x2C, 0x7B, 0x74, 0x23, 0x16, 0x1C, 0x50, 0x4C, 0x56, 0x57, 0x5B, 0x54, 0x19, 0x53, 0x1E, 0x55, 0x59, 0x2F, 0x62, 0x01, 0x65, 0x6D, 0x2A, 0x70, 0x20, 0x20, 
        0x20, 0x5A, 0x63, 0x63, 0x63, 0x63, 0x5A, 0x20, 0x20, 0x20, 0x70, 0x70, 0x70, 0x2A, 0x6D, 0x6D, 0x6D, 0x65, 0x58, 0x47, 0x5B, 0x5D, 0x5B, 0x58, 0x54, 0xAB, 0x75, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3C, 0x3C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x01, 0x63, 0xC1, 0x34, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0xAB, 0xAB, 0x48, 0x48, 0x1C, 0x5E, 0x50, 0x47, 0x58, 0x19, 0xF0, 0x1D, 0x18, 0x1C, 0x48, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0xA4, 0x41, 
        0xA2, 0xDC, 0x73, 0x1C, 0xC9, 0x68, 0x68, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x82, 0x82, 0x3F, 0x76, 0x82, 0x3F, 0x3F, 0x76, 0x76, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x3F, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x3F, 
        0x56, 0x54, 0x77, 0x90, 0x85, 0x93, 0x20, 0xC6, 0x8C, 0x6E, 0xB9, 0x8C, 0x1C, 0x9A, 0x01, 0x30, 0x5A, 0x64, 0x77, 0x64, 0x7A, 0x34, 0x7A, 0x8B, 0x7D, 0x5A, 0xAA, 0x30, 0x56, 0x9A, 0x57, 0x30, 0xD4, 0x53, 0x30, 0x58, 0x5A, 0x30, 0xB7, 0x24, 0x34, 
        0x2F, 0x1C, 0x0F, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x15, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x19, 0x47, 0x18, 0x18, 
        0x4C, 0x56, 0x57, 0x5B, 0x5C, 0x21, 0x21, 0x59, 0x59, 0x6B, 0x6B, 0x59, 0x21, 0x55, 0x1E, 0x5C, 0x53, 0x19, 0x58, 0x1B, 0x5B, 0x1D, 0x56, 0x1A, 0x4C, 0x18, 0x1C, 0x48, 0x16, 0x23, 0x74, 0x7B, 0x2C, 0x15, 0x7E, 0x73, 0x00, 0x05, 0x06, 0x0A, 0x1F, 
        0x32, 0x0D, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x1F, 0x0A, 0x04, 0x05, 0x52, 0x73, 0x0E, 0x15, 0x78, 0xF7, 0x26, 0x23, 0x16, 0x48, 0x50, 0x18, 0x1A, 0x56, 0x5D, 0x1B, 0x58, 0x19, 0x1E, 0x67, 0x21, 0x59, 0x2F, 0x69, 0x01, 0x65, 0x2A, 0x2A, 0x70, 0x70, 
        0x20, 0x5A, 0x5A, 0x63, 0x63, 0x63, 0x5A, 0x5A, 0x5A, 0x5A, 0x20, 0x70, 0x2A, 0x70, 0x2A, 0x2A, 0x65, 0x62, 0x50, 0x56, 0x4C, 0x1D, 0x1D, 0x1B, 0x57, 0x41, 0x02, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x07, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14,
  0x2D, 0x2D, 0x2D, 0x22, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x01, 0x5A, 0x34, 0x63, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 
        0x41, 0x41, 0x41, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0x48, 0x5E, 0x4C, 0x1D, 0x23, 0x19, 0x58, 0x1A, 0x18, 0x5E, 0x1C, 0x48, 0x48, 0xAB, 0xAB, 0x16, 0x16, 0x16, 0x16, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 
        0xF7, 0xDA, 0x0E, 0x48, 0x1A, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x60, 0x60, 0x82, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x68, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x82, 0x3F, 
        0xBA, 0xB6, 0x77, 0xB5, 0x80, 0x7A, 0x55, 0x63, 0xC4, 0xFB, 0x8C, 0xE7, 0xA9, 0x58, 0x30, 0x34, 0x34, 0x7A, 0x77, 0x7A, 0x64, 0x20, 0x7A, 0x64, 0x5A, 0x4A, 0x7A, 0x34, 0x30, 0xF7, 0x0D, 0x20, 0x20, 0x78, 0x93, 0x62, 0x90, 0xAA, 0x9B, 0xB8, 0x59, 
        0xC6, 0x5E, 0x0B, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x39, 0x39, 0x39, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x8E, 0x39, 0x8E, 0x61, 0x8E, 
        0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x4F, 0x54, 0x1C, 0x50, 
        0x18, 0x1A, 0x56, 0x57, 0x54, 0x55, 0x59, 0x59, 0x6B, 0x6B, 0x21, 0x21, 0x55, 0x1E, 0x5C, 0x19, 0x19, 0x58, 0x1B, 0x5B, 0x1D, 0x56, 0x1A, 0x4C, 0x50, 0x5E, 0x48, 0x16, 0x23, 0x74, 0x7B, 0x2C, 0x15, 0x72, 0x6E, 0x12, 0x07, 0xDD, 0x0A, 0x6F, 0x92, 
        0x32, 0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x92, 0x6F, 0x0A, 0x04, 0x05, 0x52, 0x73, 0x0E, 0x72, 0x78, 0x2C, 0x26, 0x23, 0x41, 0xAB, 0x5E, 0x18, 0x47, 0x1A, 0x1D, 0x5B, 0x1B, 0x58, 0x53, 0x1E, 0x55, 0x21, 0x59, 0x2F, 0x69, 0x01, 0x65, 0x6D, 0x2A, 0x70, 
        0x70, 0x20, 0x5A, 0x5A, 0x63, 0x63, 0x63, 0x63, 0x5A, 0x5A, 0x20, 0x20, 0x70, 0x20, 0x70, 0x2A, 0x6D, 0x56, 0x18, 0x50, 0x1A, 0x1A, 0x56, 0x5D, 0x23, 0x74, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x14, 0x07, 0x07, 0x07, 0x14, 0x07, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x52, 0x52, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07,
  0x31, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x01, 0x70, 0x5A, 0x5A, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xAB, 0xAB, 0xAB, 0xAB, 0x48, 0x48, 0x48, 
        0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x18, 0x47, 0x1A, 0x1D, 0x54, 0x5C, 0x1A, 0xFD, 0x1C, 0x2A, 0x65, 0x67, 0x54, 0x5D, 0x56, 0x1A, 0x47, 0x18, 0x18, 0x50, 0x5E, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 0x48, 0x48, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
        0x7B, 0xF7, 0xDA, 0x5E, 0xC9, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x4B, 0x4B, 0x82, 0x4B, 0x76, 0x4B, 0x4B, 0x76, 0x76, 0x76, 0x82, 0x17, 
        0xBC, 0x9B, 0x9B, 0x42, 0x34, 0x4A, 0x1A, 0x30, 0xD9, 0xC5, 0x8C, 0xFE, 0xFD, 0x30, 0x8B, 0x7A, 0x77, 0x64, 0x8B, 0x8B, 0x64, 0x7A, 0x7A, 0x7A, 0x8B, 0x8B, 0x77, 0x64, 0xDF, 0x5A, 0x92, 0x97, 0x30, 0xD1, 0xC7, 0x84, 0x21, 0x7A, 0x8B, 0x49, 0x9B, 
        0x85, 0xCC, 0x0F, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4C, 0x1A, 0x5E, 
        0x50, 0x18, 0x47, 0x1A, 0x1D, 0xEB, 0x59, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x5C, 0xEB, 0x58, 0x54, 0x1B, 0x5D, 0x1D, 0x56, 0x1A, 0x4C, 0x18, 0x5E, 0x48, 0x16, 0x23, 0x75, 0x26, 0x2C, 0x78, 0x72, 0x0E, 0x12, 0x52, 0x05, 0x06, 0x08, 0x1F, 0x32, 
        0x9A, 0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x92, 0x6F, 0x0A, 0x04, 0x05, 0x52, 0x12, 0x0E, 0x72, 0x78, 0x2C, 0x26, 0x75, 0xF0, 0x16, 0x1C, 0x50, 0x4C, 0x47, 0x56, 0x1D, 0x5B, 0x54, 0x19, 0x53, 0x1E, 0x55, 0x21, 0x6B, 0x2F, 0x69, 0x01, 0x65, 0x2A, 0x2A, 
        0x70, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0x34, 0x63, 0x20, 0x5A, 0x5A, 0x20, 0x20, 0x70, 0x20, 0x19, 0xAB, 0x50, 0x5E, 0x4C, 0x47, 0x57, 0x18, 0x23, 0x00, 0x14, 0x14, 0x00, 0x14, 0x14, 0x14, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x07, 0x05, 0x07, 0x07, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x24, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x3B, 0x90, 0x2A, 0x70, 0x20, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x1C, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x50, 
        0x18, 0x18, 0x47, 0x47, 0x1A, 0x57, 0x5B, 0x54, 0x1E, 0x67, 0x56, 0x7E, 0x92, 0x26, 0x53, 0x70, 0x70, 0x69, 0x21, 0x53, 0x58, 0x5B, 0x1D, 0x57, 0x56, 0x1A, 0x47, 0x4C, 0x18, 0x18, 0x18, 0x50, 0x50, 0x50, 0x5E, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x48, 
        0x75, 0x7B, 0x2C, 0x4C, 0x29, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x68, 0x46, 0x46, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 
        0xBC, 0x6A, 0xBC, 0x85, 0x4A, 0x20, 0x5C, 0xC1, 0x98, 0x8C, 0xC8, 0x0D, 0x55, 0x93, 0x99, 0x64, 0x64, 0x64, 0x64, 0x8B, 0x64, 0x8B, 0x77, 0x99, 0xAA, 0x77, 0x64, 0x64, 0xC1, 0x30, 0xCF, 0xB3, 0xE4, 0x65, 0xBD, 0x84, 0x2F, 0x99, 0x80, 0x99, 0x90, 
        0xB0, 0xBC, 0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x33, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x03, 0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x33, 0x5B, 0x5E, 
        0x1C, 0x5E, 0x18, 0x47, 0x1A, 0x5B, 0x1E, 0x2F, 0x21, 0x55, 0x1E, 0x5C, 0x53, 0xEB, 0x58, 0x54, 0x1B, 0x5D, 0x1D, 0x56, 0x1A, 0x4C, 0x50, 0x5E, 0x48, 0xAB, 0xF0, 0x23, 0x26, 0x7B, 0x78, 0x15, 0x7E, 0x6E, 0x00, 0x07, 0xDD, 0xFD, 0x6F, 0x92, 0x32, 
        0x9A, 0x0D, 0x0D, 0x0D, 0xA9, 0x32, 0x92, 0x6F, 0x0A, 0x04, 0x05, 0x52, 0x12, 0x0E, 0x72, 0x78, 0x2C, 0x7B, 0x74, 0x23, 0x16, 0x48, 0x5E, 0x18, 0x47, 0x56, 0x1D, 0x5B, 0x1B, 0x58, 0xEB, 0x5C, 0x1E, 0x55, 0x59, 0x2F, 0x62, 0x69, 0x01, 0x6D, 0x2A, 
        0x2A, 0x70, 0x70, 0x20, 0x20, 0x5A, 0x5A, 0x63, 0x63, 0x63, 0x63, 0x5A, 0x20, 0x20, 0x20, 0x62, 0x48, 0xAB, 0xAB, 0x50, 0x1C, 0x4C, 0x47, 0x74, 0x7B, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x07, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x21, 0x69, 0x6D, 0x70, 0x4C, 0x1C, 0x1C, 0x1C, 0x5E, 0x5E, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x47, 0x47, 
        0x1A, 0x56, 0x1D, 0x5D, 0x1B, 0x58, 0x5C, 0x55, 0x1E, 0x57, 0x7B, 0x0A, 0x1F, 0x78, 0x1A, 0x21, 0x20, 0x5A, 0x2A, 0x62, 0x21, 0x1E, 0x19, 0x54, 0x1B, 0x5B, 0x1D, 0x57, 0x56, 0x1A, 0x1A, 0x47, 0x47, 0x47, 0x4C, 0x18, 0x18, 0x18, 0x50, 0x50, 0x9E, 
        0x41, 0x75, 0x7B, 0x1D, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x76, 
        0x56, 0x90, 0xBA, 0x6A, 0x84, 0x53, 0x70, 0xE7, 0xDB, 0x30, 0xDB, 0xFE, 0x4A, 0x7A, 0x7A, 0x64, 0x99, 0x7A, 0x64, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x64, 0x64, 0x64, 0x64, 0x7A, 0x5A, 0x2A, 0x0D, 0xD1, 0xE0, 0xCF, 0x7D, 0x2A, 0x80, 0x99, 0x77, 0xE6, 
        0xBD, 0x68, 0xB0, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x18, 0x57, 
        0xAB, 0x1C, 0x18, 0x4C, 0x47, 0x56, 0x1B, 0x1E, 0x67, 0x1E, 0x1E, 0x53, 0x19, 0x58, 0x54, 0x1B, 0x5D, 0x1D, 0x56, 0x1A, 0x4C, 0x18, 0x5E, 0x1C, 0xAB, 0x41, 0x23, 0x74, 0x7B, 0x2C, 0x15, 0x72, 0x0E, 0x73, 0x52, 0x05, 0x04, 0x0A, 0x1F, 0x92, 0xA9, 
        0x0D, 0x0D, 0x0D, 0x0D, 0xA9, 0x32, 0x92, 0x6F, 0x0A, 0xDD, 0x05, 0x52, 0x12, 0x0E, 0x72, 0x78, 0x2C, 0x7B, 0x74, 0x23, 0x41, 0x48, 0x1C, 0x18, 0x4C, 0x1A, 0x57, 0x5D, 0x5B, 0x54, 0x19, 0x53, 0x1E, 0x67, 0x21, 0x59, 0x2F, 0x62, 0x69, 0x01, 0x65, 
        0x2A, 0x2A, 0x70, 0x70, 0x20, 0x20, 0x5A, 0x5A, 0x63, 0x34, 0x63, 0x5A, 0x63, 0x63, 0x2A, 0x50, 0x23, 0x41, 0x48, 0x48, 0x5E, 0x18, 0x41, 0x16, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x14, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
  0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x21, 0x55, 0x01, 0x6D, 0x1D, 0x50, 0x50, 0x50, 0x18, 0x18, 0x18, 0x4C, 0x4C, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x1D, 
        0x5D, 0x5B, 0x54, 0x58, 0x5C, 0x55, 0x21, 0x5C, 0x56, 0xF0, 0x73, 0x32, 0x6F, 0x72, 0x1C, 0x58, 0x2F, 0x20, 0x5A, 0x70, 0x65, 0x62, 0x59, 0x67, 0x5C, 0x19, 0x58, 0x1B, 0x5B, 0x5D, 0x1D, 0x1D, 0x56, 0x56, 0x1A, 0x47, 0x47, 0x47, 0x4C, 0xEF, 0x18, 
        0xAB, 0x41, 0x26, 0x19, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x46, 0x68, 0x17, 0x17, 0x3F, 0x3F, 0x4B, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 
        0x5B, 0xBA, 0xB8, 0x80, 0x84, 0x19, 0x94, 0xD2, 0xCD, 0x30, 0xDE, 0xF1, 0x30, 0x20, 0x7A, 0x77, 0x8B, 0x64, 0x64, 0x64, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x64, 0x34, 0x94, 0x34, 0x8F, 0x8F, 0x94, 0xB9, 0x20, 0x80, 0x20, 0x64, 0x99, 0x88, 
        0x2F, 0xD3, 0xB0, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x39, 0x61, 0x8E, 0x61, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x61, 0x8E, 0x61, 0x61, 
        0x8E, 0x8E, 0x61, 0x8E, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x61, 0x61, 0x39, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x54, 
        0x18, 0x48, 0x50, 0x50, 0x18, 0x47, 0x1A, 0x1B, 0x5C, 0x5C, 0x53, 0x19, 0x58, 0x1B, 0x5B, 0x5D, 0x57, 0x56, 0x1A, 0x4C, 0x18, 0x5E, 0x48, 0xAB, 0x41, 0x23, 0x74, 0x26, 0x2C, 0x78, 0x72, 0x0E, 0x73, 0x00, 0x05, 0xDD, 0x0C, 0x08, 0x92, 0x32, 0x9A, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x32, 0x32, 0x92, 0x08, 0x0A, 0xDD, 0x05, 0x52, 0x12, 0x0E, 0x7E, 0x15, 0x78, 0x7B, 0x26, 0x75, 0xF0, 0xAB, 0x48, 0x50, 0x18, 0x47, 0x56, 0x1D, 0x5B, 0x1B, 0x58, 0x19, 0x53, 0x1E, 0x55, 0x21, 0x59, 0x2F, 0x62, 0x69, 0x01, 
        0x6D, 0x2A, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x20, 0x5A, 0x63, 0x5A, 0x63, 0x34, 0x20, 0x5D, 0x26, 0x74, 0x41, 0x16, 0x48, 0x48, 0x16, 0x23, 0x27, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x14, 0x14, 0x07, 0x14, 0x07, 0x07, 
        0x07, 0x14, 0x14, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14,
  0x38, 0x38, 0x38, 0x3A, 0x3A, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x42, 0x53, 0x2F, 0x69, 0x58, 0x4C, 0x18, 0x4C, 0x47, 0x47, 0x47, 0x1A, 0x1A, 0x56, 0x57, 0x1D, 0x1D, 0x5B, 0x5B, 
        0x54, 0x58, 0x53, 0x1E, 0x21, 0x21, 0x19, 0x56, 0x16, 0x15, 0x0C, 0x0D, 0x08, 0x7E, 0x41, 0x56, 0x1E, 0x01, 0x20, 0x5A, 0x20, 0x2A, 0x01, 0x2F, 0x59, 0x55, 0x1E, 0x53, 0x58, 0x54, 0x1B, 0x5B, 0x5B, 0x5D, 0x1D, 0x57, 0x57, 0x56, 0x56, 0x1A, 0x47, 
        0x9E, 0x48, 0x75, 0x1E, 0x25, 0x25, 0x4E, 0x4E, 0x46, 0x68, 0x68, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x4B, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x11, 0x76, 
        0xBA, 0x68, 0x90, 0x80, 0x84, 0x5C, 0xDF, 0xB1, 0xC4, 0xE1, 0xDE, 0xC5, 0x30, 0x99, 0x7A, 0x8B, 0x7A, 0x8B, 0x8B, 0x64, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x64, 0x5A, 0x94, 0xD5, 0x9A, 0xE2, 0xB9, 0x80, 0x20, 0x80, 0x80, 0x7A, 0x80, 
        0x1C, 0x1C, 0x0F, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 
        0x0B, 0x61, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x61, 
        0x54, 0x16, 0x48, 0x48, 0x50, 0x4C, 0x4C, 0x1A, 0x58, 0x19, 0x19, 0x58, 0x1B, 0x1B, 0x5D, 0x1D, 0x56, 0x1A, 0x47, 0x18, 0x50, 0x1C, 0xAB, 0x16, 0xF0, 0x23, 0x26, 0x7B, 0x2C, 0x15, 0x7E, 0x0E, 0x12, 0x52, 0x05, 0x04, 0x0A, 0x6F, 0x92, 0x32, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x92, 0x1F, 0x08, 0xFD, 0xDD, 0x05, 0x52, 0x12, 0x6E, 0x7E, 0x15, 0x78, 0xF7, 0x26, 0x75, 0x23, 0x16, 0x48, 0x5E, 0x18, 0x47, 0x1A, 0x57, 0x5D, 0x1B, 0x54, 0x19, 0xEB, 0x5C, 0x67, 0x55, 0x21, 0x6B, 0x2F, 0x62, 0x69, 
        0x65, 0x6D, 0x2A, 0x70, 0x70, 0x20, 0x20, 0x20, 0x63, 0x5A, 0x5A, 0xC1, 0x5A, 0x67, 0x78, 0x74, 0x75, 0x26, 0x16, 0x41, 0x16, 0x7B, 0x74, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x07, 
        0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x07, 0x07, 0x14,
  0x2D, 0x2D, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x38, 0x38, 0xB7, 0x1E, 0x55, 0x2F, 0x67, 0x47, 0x47, 0x1A, 0x1A, 0x1A, 0x1A, 0x57, 0x1D, 0x1D, 0x5D, 0x1B, 0x1B, 0x54, 0x58, 
        0xEB, 0x1E, 0x55, 0x21, 0x55, 0x58, 0x56, 0x48, 0x7B, 0x12, 0x92, 0x9A, 0x0A, 0x0E, 0x75, 0x18, 0x1B, 0x21, 0x01, 0x20, 0x63, 0x20, 0x70, 0x6D, 0x69, 0x2F, 0x59, 0x55, 0x1E, 0x5C, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5D, 0x5D, 0x1D, 0x57, 0x56, 
        0x4C, 0x50, 0x41, 0xE6, 0x4E, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x82, 0x82, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3F, 
        0xBA, 0x5D, 0xBA, 0x77, 0x84, 0x4C, 0x8C, 0xBE, 0xC4, 0x63, 0x0D, 0xC4, 0xAA, 0x7A, 0x8B, 0x64, 0x7A, 0x8B, 0x77, 0x64, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x64, 0x34, 0x30, 0xBE, 0x9A, 0xE1, 0xE9, 0x6D, 0x20, 0x9B, 0x8B, 0x64, 0x90, 
        0xFA, 0x5E, 0x35, 0x0B, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 
        0x61, 0x8E, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x3F, 0x1A, 0x16, 0x1C, 0x1C, 0x50, 0x18, 0x4C, 0x56, 0x1B, 0x58, 0x1B, 0x5D, 0x1D, 0x57, 0x56, 0x47, 0x47, 0x18, 0x50, 0x1C, 0x48, 0x16, 0xF0, 0x23, 0x74, 0x7B, 0x2C, 0x78, 0x72, 0x0E, 0x73, 0x00, 0x07, 0xDD, 0x0C, 0x08, 0x1F, 0x92, 0x32, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x92, 0x1F, 0x08, 0xFD, 0xDD, 0x05, 0x52, 0x12, 0x6E, 0x7E, 0x15, 0x78, 0x2C, 0x26, 0x74, 0x23, 0x16, 0xAB, 0x1C, 0x50, 0x4C, 0x1A, 0x56, 0x1D, 0x5B, 0x1B, 0x54, 0x58, 0x53, 0x1E, 0x67, 0x55, 0x59, 0x6B, 0x2F, 0x69, 
        0x65, 0x6D, 0x6D, 0x2A, 0x70, 0x70, 0x70, 0x20, 0x20, 0x20, 0x63, 0x63, 0x6B, 0x78, 0x78, 0x7B, 0x26, 0x26, 0x23, 0x41, 0xF7, 0x23, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x14, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x21, 0x5C, 0x21, 0x21, 0x56, 0x56, 0x56, 0x57, 0x57, 0x1D, 0x5D, 0x5B, 0x1B, 0x1B, 0x58, 0x19, 0x53, 0x1E, 
        0x55, 0x21, 0x21, 0x1E, 0x54, 0x1A, 0x1C, 0x74, 0x7E, 0xDD, 0xA9, 0xA9, 0xFD, 0x6E, 0x7B, 0x1C, 0x57, 0x53, 0x59, 0x65, 0x70, 0x63, 0x5A, 0x20, 0x2A, 0x65, 0x69, 0x2F, 0x21, 0x55, 0x67, 0x1E, 0x53, 0x19, 0x58, 0x54, 0x1B, 0x1B, 0x5B, 0x5B, 0x1D, 
        0x56, 0x18, 0x1C, 0xC9, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x3F, 
        0xBA, 0x54, 0x54, 0x80, 0x93, 0x56, 0xDF, 0xF7, 0xEA, 0x94, 0xA9, 0xE7, 0xAA, 0x77, 0x8B, 0x64, 0x8B, 0x64, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x64, 0x77, 0x8C, 0xD6, 0xDE, 0xE3, 0xEC, 0x01, 0x5A, 0x99, 0x80, 0x99, 0x11, 
        0x75, 0xB1, 0x35, 0x61, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x39, 0x39, 0x39, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x0E, 0x0E, 0x09, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x57, 0x50, 0x16, 0x48, 0x1C, 0x50, 0x18, 0x47, 0x56, 0x5B, 0x1B, 0x5D, 0x1D, 0x56, 0x1A, 0x47, 0x4C, 0x50, 0x5E, 0x48, 0x16, 0x41, 0x23, 0x74, 0x26, 0x2C, 0x78, 0x15, 0x7E, 0x6E, 0x12, 0x52, 0x05, 0x04, 0x0A, 0x6F, 0x1F, 0x32, 0xA9, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x9A, 0x32, 0x92, 0x1F, 0x08, 0xFD, 0xDD, 0x05, 0x52, 0x12, 0x6E, 0x7E, 0x15, 0x78, 0x2C, 0x7B, 0x74, 0x23, 0x41, 0xAB, 0x1C, 0x5E, 0x18, 0x47, 0x1A, 0x57, 0x5D, 0x5B, 0x54, 0x58, 0x19, 0x5C, 0x1E, 0x55, 0x21, 0x59, 0x2F, 0x2F, 
        0x62, 0x01, 0x6D, 0x2A, 0x2A, 0x2A, 0x70, 0x70, 0x20, 0x5A, 0x5A, 0x62, 0x78, 0x15, 0x15, 0x78, 0x2C, 0x26, 0x75, 0x26, 0x23, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x14, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x24, 0x2F, 0x19, 0x53, 0x21, 0x5B, 0x1D, 0x1D, 0x5D, 0x5B, 0x5B, 0x1B, 0x54, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x21, 
        0x59, 0x21, 0x5C, 0x1B, 0x56, 0x50, 0x23, 0x78, 0x52, 0x6F, 0x0D, 0x32, 0x06, 0x73, 0x2C, 0x16, 0x47, 0x1B, 0x1E, 0x2F, 0x6D, 0x70, 0x5A, 0x63, 0x20, 0x70, 0x6D, 0x01, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x53, 0xEB, 0x19, 0x58, 0x58, 0x54, 0x1B, 
        0x1D, 0x1A, 0x1D, 0x38, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x68, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x36, 
        0xB8, 0x90, 0xBA, 0x5A, 0x30, 0x53, 0x4A, 0x9E, 0xEE, 0x8C, 0x8F, 0xCF, 0x30, 0x80, 0x7A, 0x64, 0x77, 0x7A, 0x8B, 0x8B, 0x8B, 0x8B, 0x64, 0x8B, 0x64, 0x64, 0x64, 0x64, 0x64, 0xC3, 0x7D, 0x97, 0xFF, 0xE1, 0xF2, 0xE2, 0x80, 0xC3, 0x4A, 0x99, 0x5D, 
        0xD4, 0xF3, 0x3D, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 
        0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x61, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 
        0x10, 0x4F, 0x5B, 0xAB, 0x16, 0x48, 0x1C, 0x5E, 0x18, 0x4C, 0x56, 0x1D, 0x1D, 0x56, 0x1A, 0x47, 0x4C, 0x18, 0x5E, 0x48, 0xAB, 0x41, 0x23, 0x75, 0x26, 0x7B, 0x78, 0x15, 0x72, 0x0E, 0x12, 0x00, 0x05, 0xDD, 0x06, 0x08, 0x1F, 0x92, 0x32, 0x9A, 0x0D, 
        0x0D, 0x0D, 0x0D, 0xA9, 0x32, 0x92, 0x1F, 0x0A, 0x0C, 0xDD, 0x05, 0x52, 0x12, 0x6E, 0x0E, 0x72, 0x15, 0x2C, 0x7B, 0x26, 0x75, 0xF0, 0x16, 0x48, 0x1C, 0x18, 0x4C, 0x1A, 0x56, 0x1D, 0x5B, 0x1B, 0x54, 0x19, 0x53, 0x1E, 0x67, 0x55, 0x21, 0x59, 0x2F, 
        0x62, 0x69, 0x01, 0x65, 0x6D, 0x70, 0x2A, 0x20, 0x70, 0x70, 0x65, 0x15, 0xFC, 0x0E, 0x72, 0x15, 0x78, 0x7B, 0x7B, 0x26, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x14, 0x07, 0x07, 0x14, 0x07, 0x07, 0x14, 0x14, 0x07, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x67, 0x1B, 0x58, 0x53, 0x19, 0x5B, 0x5B, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0x53, 0x5C, 0x1E, 0x55, 0x21, 0x59, 
        0x55, 0x53, 0x1B, 0x1A, 0x50, 0xF0, 0x2C, 0x0E, 0xDD, 0x32, 0x0D, 0x32, 0x06, 0x73, 0x2C, 0x23, 0x50, 0x57, 0x58, 0x55, 0x62, 0x6D, 0x70, 0x5A, 0x63, 0x20, 0x70, 0x2A, 0x65, 0x01, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x53, 0x19, 0x53, 0x19, 
        0x5B, 0x50, 0x1E, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x46, 0x46, 0x68, 0x68, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x4B, 0x17, 
        0xBD, 0x59, 0xF3, 0x59, 0x30, 0x53, 0xC1, 0xEB, 0xDA, 0x30, 0xD9, 0x8F, 0xAA, 0x64, 0x64, 0x7A, 0x8B, 0x64, 0x8B, 0x8B, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x7A, 0x77, 0x77, 0x63, 0x9A, 0xF9, 0xE0, 0xF4, 0x7D, 0x85, 0x85, 0x7A, 0xAE, 0x41, 
        0xF7, 0xD3, 0x3D, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x6C, 0x37, 0x37, 0x37, 
        0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x10, 0x10, 0x09, 0x09, 
        0x09, 0x09, 0x03, 0x5B, 0xF0, 0x16, 0x48, 0x48, 0x5E, 0x50, 0x4C, 0x1A, 0x56, 0x1A, 0x47, 0x4C, 0x50, 0x5E, 0x48, 0xAB, 0x16, 0xF0, 0x75, 0x26, 0x7B, 0x2C, 0x78, 0x72, 0x0E, 0x73, 0x00, 0x07, 0xDD, 0x04, 0x0A, 0x6F, 0x1F, 0x32, 0xA9, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0xA9, 0x32, 0x92, 0x1F, 0x0A, 0x0C, 0xDD, 0x05, 0x52, 0x12, 0x6E, 0x0E, 0x72, 0x15, 0x2C, 0x7B, 0x26, 0x75, 0xF0, 0x16, 0x48, 0x1C, 0x50, 0x4C, 0x47, 0x56, 0x57, 0x5D, 0x5B, 0x1B, 0x58, 0x19, 0x5C, 0x1E, 0x55, 0x21, 0x21, 0x62, 
        0x69, 0x2F, 0x69, 0x65, 0x6D, 0x2A, 0x2A, 0x70, 0x20, 0x2F, 0x7E, 0xFC, 0x97, 0x72, 0x7E, 0x72, 0x78, 0x78, 0x78, 0x74, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x24, 0x2D, 0x5C, 0x5D, 0x54, 0xEB, 0x1B, 0x1B, 0x54, 0x58, 0x19, 0xEB, 0x5C, 0x1E, 0x67, 0x55, 0x59, 0x59, 0x67, 
        0x19, 0x1B, 0x1A, 0x50, 0x16, 0x26, 0x72, 0x52, 0x08, 0x9A, 0x0D, 0x92, 0x04, 0x12, 0x78, 0x75, 0x1C, 0x1A, 0x5B, 0x53, 0x21, 0x69, 0x2A, 0x20, 0x5A, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x65, 0x69, 0x62, 0x2F, 0x59, 0x21, 0x55, 0x1E, 0x1E, 0x67, 0x1E, 
        0x19, 0x1C, 0x5C, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x68, 0x4E, 
        0xBC, 0xB8, 0x67, 0x67, 0x84, 0x20, 0xC4, 0x20, 0x97, 0x8C, 0xBB, 0xB3, 0xAE, 0x30, 0x20, 0x64, 0x64, 0x8B, 0x8B, 0x64, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x64, 0x64, 0x77, 0x30, 0x19, 0x0D, 0xE8, 0xE4, 0xF6, 0xE1, 0x62, 0xC3, 0x7A, 0xAE, 0x80, 
        0x6E, 0xB1, 0x76, 0x11, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x11, 0x56, 0x23, 0xAB, 0x48, 0x48, 0x50, 0x18, 0x4C, 0x47, 0x1A, 0x4C, 0x50, 0x1C, 0x48, 0xAB, 0x16, 0xF0, 0x23, 0x74, 0x7B, 0x2C, 0x78, 0x15, 0x7E, 0x0E, 0x73, 0x52, 0x07, 0xDD, 0x06, 0x08, 0x1F, 0x92, 0x32, 0x9A, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x9A, 0x32, 0x32, 0x1F, 0x6F, 0x0A, 0x0C, 0xDD, 0x05, 0x52, 0x12, 0x6E, 0x0E, 0x72, 0x15, 0x2C, 0x7B, 0x26, 0x74, 0x23, 0x41, 0xAB, 0x48, 0x50, 0x18, 0x47, 0x1A, 0x56, 0x1D, 0x5B, 0x1B, 0x54, 0x19, 0xEB, 0x5C, 0x67, 0x55, 0x55, 0x59, 
        0x2F, 0x2F, 0x69, 0x01, 0x01, 0x01, 0x2A, 0x2A, 0x59, 0x7E, 0x52, 0x98, 0x73, 0x73, 0x73, 0x7E, 0x15, 0x7E, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x2F, 0x1D, 0x5D, 0x58, 0x58, 0x58, 0x19, 0xEB, 0x53, 0x1E, 0x1E, 0x55, 0x21, 0x59, 0x21, 0x1E, 0x19, 
        0x1B, 0x56, 0x18, 0xAB, 0x75, 0x78, 0x73, 0xDD, 0x1F, 0x0D, 0x0D, 0x1F, 0x04, 0x12, 0x15, 0x26, 0x16, 0x4C, 0x1D, 0x58, 0x1E, 0x59, 0x01, 0x2A, 0x70, 0x5A, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x6D, 0x65, 0x69, 0x2F, 0x2F, 0x59, 0x21, 0x55, 0x55, 0x55, 
        0x19, 0x1D, 0x2E, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x4E, 0x46, 0x68, 0x46, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x3F, 0x4B, 0x4B, 0x60, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x11, 
        0x5D, 0xC6, 0x75, 0x90, 0x77, 0x7A, 0x54, 0x30, 0x97, 0xC6, 0x63, 0xB3, 0x73, 0x30, 0x7D, 0x34, 0x64, 0x99, 0x7A, 0x8B, 0x64, 0x7A, 0x8B, 0x64, 0x77, 0x64, 0x64, 0x99, 0x94, 0x30, 0x98, 0xC0, 0x4A, 0x3F, 0xBA, 0x64, 0x42, 0x9B, 0x4A, 0x1E, 0xBB, 
        0xC0, 0xAC, 0x11, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x5E, 0x47, 0xF0, 0xAB, 0x16, 0x1C, 0x50, 0x18, 0x4C, 0x1A, 0x4C, 0x5E, 0x1C, 0xAB, 0x16, 0xF0, 0x23, 0x75, 0x26, 0xF7, 0x78, 0x15, 0x72, 0x0E, 0x73, 0x12, 0x07, 0x05, 0x04, 0xFD, 0x6F, 0x1F, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x9A, 0x32, 0x92, 0x1F, 0x6F, 0x0A, 0x06, 0xDD, 0x05, 0x07, 0x12, 0x73, 0x0E, 0x72, 0x15, 0x2C, 0xF7, 0x26, 0x74, 0x23, 0xF0, 0x16, 0x48, 0x5E, 0x50, 0x4C, 0x47, 0x56, 0x57, 0x5D, 0x5B, 0x1B, 0x58, 0x19, 0x53, 0x1E, 0x67, 0x21, 0x55, 
        0x59, 0x62, 0x2F, 0x2F, 0x65, 0x2A, 0x01, 0x67, 0x07, 0x04, 0x98, 0x52, 0x07, 0x97, 0x12, 0x0E, 0x72, 0x41, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x2D, 0x22, 0x22, 0x22, 0x31, 0x31, 0xE6, 0x5B, 0x56, 0x5D, 0x54, 0xEB, 0x53, 0x5C, 0x1E, 0x67, 0x21, 0x59, 0x59, 0x21, 0x1E, 0x58, 0x5B, 
        0x56, 0x18, 0x48, 0x23, 0x2C, 0x7E, 0x07, 0x0A, 0x32, 0x0D, 0xA9, 0x1F, 0xDD, 0x12, 0x15, 0x7B, 0x41, 0x50, 0x1A, 0x5B, 0xEB, 0x55, 0x2F, 0x01, 0x2A, 0x20, 0x5A, 0x63, 0x5A, 0x20, 0x20, 0x70, 0x2A, 0x65, 0x01, 0x69, 0x2F, 0x6B, 0xEB, 0x53, 0x55, 
        0x1A, 0x67, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x17, 
        0x47, 0x69, 0x02, 0xBC, 0x20, 0x4A, 0x67, 0x5A, 0x21, 0xFB, 0x94, 0xCD, 0x9A, 0x53, 0x30, 0x77, 0x4A, 0x7A, 0x8B, 0x8B, 0x99, 0x7A, 0x7A, 0x64, 0x7A, 0x8B, 0x99, 0x7A, 0x30, 0xED, 0x0D, 0xBB, 0x7D, 0x97, 0x34, 0x9B, 0x22, 0xAA, 0x2A, 0x54, 0xFA, 
        0xAD, 0xAC, 0x76, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 
        0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x1D, 0x18, 0xF0, 0x41, 0xAB, 0x1C, 0x50, 0x18, 0x47, 0x4C, 0x18, 0x1C, 0xAB, 0xF0, 0x23, 0x75, 0x26, 0x7B, 0x2C, 0x78, 0x15, 0x7E, 0x6E, 0x12, 0x52, 0x05, 0xDD, 0x06, 0x0A, 0x6F, 0x92, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0xA9, 0x32, 0x92, 0x1F, 0x6F, 0x0A, 0x06, 0xDD, 0x05, 0x07, 0x12, 0x73, 0x0E, 0x72, 0x15, 0x78, 0x2C, 0x7B, 0x26, 0x23, 0xF0, 0x16, 0xAB, 0x1C, 0x50, 0x18, 0x47, 0x1A, 0x56, 0x1D, 0x5D, 0x1B, 0x54, 0x58, 0x19, 0x5C, 0x1E, 0x21, 0x55, 
        0x2F, 0x2F, 0x59, 0x2F, 0x01, 0x2F, 0x5B, 0x0A, 0x0C, 0x08, 0x0C, 0x98, 0x52, 0x52, 0x12, 0x6E, 0xF0, 0x4F, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x10, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x28, 0x28, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x59, 0x1A, 0x56, 0x5D, 0x19, 0x1E, 0x1E, 0x55, 0x21, 0x59, 0x59, 0x67, 0x53, 0x58, 0x5B, 0x56, 
        0x18, 0x48, 0xF0, 0x7B, 0x15, 0x12, 0xDD, 0x6F, 0xA9, 0x0D, 0x32, 0x6F, 0xDD, 0x00, 0x72, 0xF7, 0x23, 0x1C, 0x4C, 0x1D, 0x54, 0x5C, 0x21, 0x2F, 0x65, 0x2A, 0x70, 0x5A, 0x63, 0x63, 0x5A, 0x20, 0x70, 0x2A, 0x6D, 0x65, 0x01, 0x67, 0x5B, 0x58, 0x19, 
        0x4C, 0x22, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x71, 
        0x48, 0x20, 0xCF, 0xB1, 0x6A, 0x4A, 0x5A, 0x67, 0x8C, 0x72, 0xC4, 0x94, 0xDD, 0x9A, 0x94, 0x84, 0x34, 0x99, 0x7A, 0x64, 0x7A, 0x8B, 0x64, 0x77, 0x77, 0x77, 0x64, 0x93, 0x6D, 0x0D, 0xFB, 0x30, 0xB1, 0x3F, 0x4A, 0x38, 0x85, 0x64, 0xE6, 0x57, 0x8F, 
        0x92, 0xAC, 0x3F, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x8D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 
        0x61, 0x61, 0x39, 0x8E, 0x8E, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x03, 0x4F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x57, 0x18, 0x41, 0x41, 0x16, 0x1C, 0x50, 0x18, 0x47, 0x1A, 0x1C, 0xAB, 0x23, 0x74, 0x26, 0x7B, 0x2C, 0x78, 0x15, 0x72, 0x0E, 0x73, 0x12, 0x07, 0x05, 0x04, 0x0C, 0x0A, 0x1F, 0x92, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0xA9, 0x32, 0x92, 0x1F, 0x6F, 0x0A, 0x06, 0xDD, 0x05, 0x07, 0x12, 0x73, 0x0E, 0x72, 0x15, 0x78, 0x2C, 0x7B, 0x26, 0x75, 0x23, 0x41, 0xAB, 0x1C, 0x5E, 0x50, 0x4C, 0x1A, 0x56, 0x57, 0x1D, 0x5B, 0x1B, 0x58, 0x19, 0x53, 0x5C, 0x67, 0x67, 
        0x59, 0x59, 0x59, 0x01, 0x21, 0x50, 0x92, 0x6F, 0x92, 0x06, 0x0C, 0x0C, 0x98, 0xDD, 0x73, 0x75, 0x4F, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 
        0x12, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0x05, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
  0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x67, 0x1D, 0x4C, 0x1A, 0x5B, 0x55, 0x21, 0x21, 0x59, 0x21, 0x1E, 0x53, 0x58, 0x5B, 0x56, 0x4C, 
        0x1C, 0x41, 0x26, 0x78, 0x0E, 0x07, 0x0C, 0x92, 0x0D, 0x0D, 0x32, 0x6F, 0xDD, 0x00, 0x72, 0x2C, 0x75, 0xAB, 0x18, 0x56, 0x5B, 0x19, 0x67, 0x59, 0x62, 0x65, 0x2A, 0x70, 0x20, 0x63, 0x63, 0x5A, 0x20, 0x70, 0x70, 0x2A, 0x65, 0x56, 0x57, 0x1B, 0x18, 
        0x1E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x46, 0x46, 0x68, 0x68, 0x17, 0x17, 0x3F, 0x3F, 0x4B, 0x4B, 0x76, 0x17, 
        0x47, 0x63, 0xBD, 0x04, 0xB8, 0x34, 0x7D, 0x59, 0x70, 0x6A, 0x8F, 0xC1, 0x94, 0x6E, 0x1F, 0x34, 0x30, 0x4A, 0x64, 0x8B, 0x77, 0x4A, 0x99, 0x7A, 0x7A, 0x7A, 0x30, 0x85, 0x92, 0x8A, 0x34, 0xC7, 0x73, 0x7A, 0x9B, 0xB8, 0x34, 0x99, 0x55, 0x1D, 0x9A, 
        0xBF, 0xCE, 0x68, 0x17, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x56, 0x18, 0x23, 0x16, 0x48, 0x5E, 0x5E, 0x50, 0x47, 0x1A, 0x5E, 0x23, 0x26, 0x26, 0x7B, 0x78, 0x15, 0x7E, 0x7E, 0x0E, 0x12, 0x07, 0x05, 0x98, 0x04, 0x0A, 0x6F, 0x1F, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0xA9, 0x32, 0x92, 0x1F, 0x6F, 0x0A, 0x06, 0xDD, 0x05, 0x07, 0x00, 0x73, 0x0E, 0x72, 0x15, 0x78, 0x2C, 0x7B, 0x26, 0x74, 0x23, 0x41, 0x16, 0x48, 0x5E, 0x50, 0x4C, 0x47, 0x1A, 0x57, 0x1D, 0x5D, 0x5B, 0x54, 0x58, 0x19, 0x53, 0x1E, 0x55, 
        0x1E, 0x2F, 0x59, 0x1E, 0x15, 0x32, 0x92, 0x92, 0x1F, 0x08, 0x0A, 0x0A, 0xDD, 0x52, 0x75, 0x15, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x38, 0x55, 0x50, 0x4C, 0x56, 0x58, 0x59, 0x59, 0x55, 0x1E, 0x19, 0x54, 0x5D, 0x56, 0x4C, 0x5E, 
        0x16, 0x75, 0x2C, 0x72, 0x12, 0xDD, 0x6F, 0x32, 0x0D, 0x0D, 0x32, 0x08, 0xDD, 0x00, 0x7E, 0x2C, 0x74, 0x16, 0x5E, 0x47, 0x1D, 0x54, 0x53, 0x55, 0x59, 0x69, 0x65, 0x2A, 0x70, 0x20, 0x63, 0x34, 0x5A, 0x20, 0x20, 0x70, 0x1B, 0x50, 0x47, 0x56, 0x4C, 
        0xB7, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 
        0x4C, 0xC1, 0xE2, 0x43, 0x3D, 0x34, 0x7D, 0x34, 0xAF, 0x30, 0x56, 0x8A, 0x34, 0x84, 0x7B, 0x0D, 0x18, 0x84, 0x30, 0x30, 0x93, 0xAA, 0x30, 0x30, 0x8C, 0x34, 0x1D, 0x0D, 0x6E, 0x94, 0x70, 0x13, 0x34, 0x5A, 0x2B, 0xAE, 0x93, 0xE6, 0x21, 0xFC, 0xA9, 
        0xBF, 0xAC, 0x3F, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 
        0x61, 0x61, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x56, 0x50, 0x41, 0x41, 0xAB, 0x1C, 0x50, 0x50, 0x18, 0x1A, 0x47, 0xF0, 0x2C, 0x78, 0x78, 0x78, 0x0E, 0x0E, 0x73, 0x00, 0x07, 0x05, 0x04, 0x08, 0x0A, 0x6F, 0x1F, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0xA9, 0x32, 0x92, 0x1F, 0x6F, 0x0A, 0x06, 0xDD, 0x05, 0x07, 0x00, 0x73, 0x0E, 0x72, 0x15, 0x78, 0x2C, 0xF7, 0x26, 0x74, 0x23, 0x41, 0x16, 0x48, 0x1C, 0x50, 0x18, 0x47, 0x1A, 0x56, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x53, 0xEB, 0x1E, 
        0x21, 0x1E, 0x1B, 0x6F, 0x32, 0x0D, 0xA9, 0x32, 0x92, 0x1F, 0x6F, 0x0A, 0x07, 0x23, 0x4F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0xE6, 0x5B, 0x1C, 0x18, 0x56, 0x1E, 0x55, 0x5C, 0x19, 0x54, 0x5D, 0x56, 0x4C, 0x5E, 0xAB, 
        0x23, 0x7B, 0x15, 0x6E, 0x07, 0x06, 0x1F, 0x9A, 0x0D, 0x9A, 0x92, 0x08, 0xDD, 0x00, 0x7E, 0x78, 0x26, 0xF0, 0x1C, 0x4C, 0x56, 0x5B, 0x58, 0x5C, 0x55, 0x2F, 0x69, 0x65, 0x2A, 0x70, 0x20, 0x5A, 0x63, 0x5A, 0x5A, 0x2F, 0x16, 0x48, 0x50, 0x16, 0x55, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x29, 
        0xCB, 0xE7, 0xC1, 0xD6, 0x0C, 0x57, 0x6A, 0x93, 0x2F, 0xC6, 0x30, 0x55, 0xFC, 0x70, 0x94, 0x54, 0x08, 0xAD, 0x2C, 0x1E, 0x80, 0x2A, 0x20, 0x1B, 0xAB, 0xA5, 0xA9, 0xE5, 0x30, 0x21, 0x98, 0x9B, 0x5A, 0xB8, 0xB7, 0x4A, 0x80, 0x5B, 0x56, 0xA9, 0xA9, 
        0xBF, 0xD2, 0x16, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x39, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x57, 0x18, 0x23, 0xAB, 0xAB, 0x48, 0x5E, 0x18, 0x1A, 0x56, 0x4C, 0xAB, 0x26, 0x15, 0x0E, 0x7E, 0x73, 0x12, 0x12, 0x07, 0xDD, 0x04, 0xDD, 0x08, 0x1F, 0x92, 0x32, 0x9A, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x9A, 0x32, 0x32, 0x92, 0x1F, 0x6F, 0x0A, 0x06, 0xDD, 0x05, 0x07, 0x00, 0x73, 0x6E, 0x72, 0x15, 0x78, 0x2C, 0xF7, 0x26, 0x74, 0x75, 0x41, 0x41, 0xAB, 0x1C, 0x5E, 0x18, 0x4C, 0x47, 0x57, 0x57, 0x57, 0x1D, 0x1B, 0x58, 0x58, 0x58, 0x1E, 0x5C, 
        0x1E, 0x26, 0x9A, 0x0D, 0x0D, 0x9A, 0x0D, 0x32, 0x32, 0x32, 0x1F, 0x05, 0x23, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x59, 0x50, 0x1C, 0x18, 0x56, 0xEB, 0x19, 0x1B, 0x5D, 0x56, 0x47, 0x50, 0xAB, 0x23, 
        0x26, 0x78, 0x7E, 0x12, 0xDD, 0x0A, 0x32, 0x0D, 0x0D, 0xA9, 0x92, 0x0A, 0xDD, 0x00, 0x0E, 0x78, 0x7B, 0x23, 0xAB, 0x50, 0x1A, 0x1D, 0x1B, 0x19, 0x1E, 0x21, 0x2F, 0x69, 0x6D, 0x2A, 0x20, 0x20, 0x63, 0x63, 0x70, 0x41, 0x75, 0x16, 0x41, 0x5B, 0x2B, 
        0x3E, 0x36, 0x9F, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x25, 
        0x18, 0xBB, 0xC1, 0xA3, 0x8A, 0xFA, 0x90, 0x7D, 0x7D, 0x6A, 0x21, 0x7A, 0xA3, 0x8A, 0xCA, 0x84, 0x84, 0x54, 0x73, 0x9A, 0x9A, 0x9A, 0x0D, 0xA5, 0xB2, 0x1B, 0x30, 0x94, 0x3D, 0x27, 0x6A, 0x5A, 0xB6, 0xB5, 0x77, 0x7D, 0x25, 0x7D, 0xB2, 0xA9, 0xA5, 
        0x8F, 0xD2, 0x3F, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 
        0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x37, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x12, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x50, 0x47, 0x23, 0x16, 0x16, 0x5E, 0x50, 0x50, 0x4C, 0x56, 0x57, 0x50, 0x26, 0x72, 0x73, 0x6E, 0x12, 0x98, 0xDD, 0x05, 0x06, 0x1F, 0x6F, 0x1F, 0x32, 0x32, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x9A, 0x32, 0x32, 0x92, 0x6F, 0x08, 0x0A, 0x06, 0xDD, 0x05, 0x07, 0x00, 0x73, 0x6E, 0x7E, 0x72, 0x15, 0x78, 0x2C, 0x7B, 0x26, 0x75, 0x23, 0x41, 0xAB, 0x48, 0x1C, 0x50, 0x18, 0x47, 0x47, 0x56, 0x1D, 0x5D, 0x5D, 0x1B, 0x19, 0x5C, 0x19, 0x1A, 
        0x00, 0x0A, 0x9A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA9, 0x1F, 0xDD, 0xF0, 0x4F, 0x10, 0x12, 0x10, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
  0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x22, 0x55, 0x48, 0x1C, 0x18, 0x56, 0x1B, 0x1D, 0x56, 0x47, 0x50, 0x48, 0xF0, 0x74, 
        0x2C, 0x15, 0x73, 0x07, 0x06, 0x1F, 0x32, 0x0D, 0x0D, 0xA9, 0x1F, 0x0A, 0xDD, 0x00, 0x0E, 0x15, 0x7B, 0x75, 0x16, 0x1C, 0x47, 0x56, 0x5B, 0x58, 0x53, 0x55, 0x59, 0x2F, 0x01, 0x2A, 0x2A, 0x70, 0x20, 0x20, 0x41, 0x78, 0x7B, 0x75, 0x1C, 0xB7, 0x36, 
        0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x68, 0x46, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 
        0x17, 0x1C, 0x5D, 0x70, 0xF3, 0x8A, 0xBD, 0x85, 0x84, 0x7D, 0x01, 0x67, 0x84, 0x5A, 0xD6, 0x97, 0xCE, 0x34, 0x7D, 0x34, 0x34, 0x70, 0x70, 0x30, 0x8C, 0x20, 0xEE, 0x8F, 0x47, 0x34, 0x80, 0xA3, 0x54, 0x80, 0x84, 0x1B, 0x20, 0x23, 0x0D, 0xA6, 0x8F, 
        0x8F, 0xAC, 0x16, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 
        0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x16, 0x1A, 0x23, 0x16, 0xAB, 0x48, 0x50, 0x18, 0x18, 0x1A, 0x57, 0x47, 0xAB, 0x7E, 0x73, 0x52, 0x07, 0xDD, 0x0C, 0x0A, 0x0A, 0x1F, 0x92, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0xA9, 0x32, 0x92, 0x1F, 0x6F, 0x08, 0x0A, 0x06, 0xDD, 0x05, 0x07, 0x00, 0x73, 0x6E, 0x7E, 0x72, 0x15, 0x78, 0x2C, 0x7B, 0x26, 0x74, 0x23, 0x41, 0x16, 0x48, 0x1C, 0x50, 0x18, 0x4C, 0x47, 0x56, 0x1D, 0x5B, 0x1B, 0x1B, 0x5B, 0x1D, 0x41, 0x52, 
        0x06, 0x1F, 0x92, 0x32, 0x32, 0x0D, 0x0D, 0x0D, 0x92, 0x52, 0xF0, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x10, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10,
  0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x5F, 0x5B, 0x16, 0x1C, 0x18, 0x1A, 0x56, 0x47, 0x50, 0x48, 0x41, 0x75, 0x7B, 
        0x15, 0x0E, 0x00, 0xDD, 0x0A, 0x92, 0x9A, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x00, 0x0E, 0x15, 0x2C, 0x74, 0x41, 0x48, 0x18, 0x1A, 0x1D, 0x1B, 0x19, 0x1E, 0x55, 0x6B, 0x62, 0x01, 0x2A, 0x70, 0x2A, 0x23, 0x6E, 0x72, 0x2C, 0x75, 0x21, 0x38, 0x38, 
        0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x71, 0x46, 0x68, 0x17, 
        0x17, 0x17, 0x5E, 0x5D, 0xA3, 0x74, 0x98, 0x56, 0xAF, 0x7D, 0x7A, 0x85, 0xAF, 0x20, 0x93, 0x85, 0x3D, 0x73, 0x52, 0xB0, 0xBD, 0xBA, 0xCC, 0xF3, 0xFA, 0xFC, 0xCF, 0x20, 0x7A, 0x69, 0x53, 0xC6, 0x20, 0x84, 0x54, 0x6A, 0x54, 0x0D, 0xA6, 0xA8, 0xB2, 
        0xDC, 0xA4, 0x3F, 0x3F, 0x76, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x15, 
        0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0F, 0x1A, 0x16, 0x16, 0xAB, 0x1C, 0x50, 0x50, 0x18, 0x1A, 0x1D, 0x1D, 0x1A, 0x26, 0x00, 0x98, 0xDD, 0x0C, 0x08, 0x08, 0x1F, 0x92, 0x32, 0x9A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x32, 0x32, 0x92, 0x1F, 0x6F, 0x0A, 0xFD, 0x06, 0xDD, 0x05, 0x07, 0x00, 0x73, 0x6E, 0x7E, 0x72, 0x15, 0x78, 0x2C, 0x7B, 0x26, 0x74, 0x23, 0x41, 0x16, 0xAB, 0x1C, 0x5E, 0x18, 0x18, 0x56, 0x1A, 0x1A, 0x57, 0x5B, 0x1D, 0x1C, 0x26, 0x12, 0x00, 
        0x98, 0x06, 0x08, 0x92, 0x0D, 0x32, 0x0D, 0x1F, 0x72, 0x75, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 
        0x00, 0x12, 0x12, 0x00, 0x00, 0x12, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x40, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x59, 0x1A, 0x16, 0x48, 0x18, 0x47, 0x18, 0x48, 0x16, 0x23, 0x26, 0x78, 
        0x72, 0x73, 0x07, 0x06, 0x6F, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x0A, 0x98, 0x00, 0x6E, 0x15, 0x2C, 0x26, 0xF0, 0x48, 0x50, 0x47, 0x57, 0x5B, 0x58, 0x53, 0x67, 0x21, 0x2F, 0x69, 0x65, 0x01, 0x2C, 0x05, 0x12, 0x6E, 0x2C, 0x1E, 0x24, 0x3A, 0x3A, 
        0x2B, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x4E, 0x25, 0x4E, 0x71, 0x1A, 0x58, 0x73, 0xFA, 0x4C, 0x6A, 0x4A, 0x4A, 0x20, 0xCA, 0xB6, 0x7D, 0x7D, 0x5A, 0x62, 0xB6, 0xCB, 0xCC, 0xCB, 0xC7, 0x65, 0x63, 0x34, 0x6D, 0x5C, 0x19, 0x53, 0x94, 0x8C, 0xAF, 0x80, 0xAF, 0x9A, 0xAD, 0xA6, 0x6E, 0x75, 
        0x41, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 
        0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x33, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x2C, 0x57, 0x5E, 0x41, 0x16, 0x48, 0x50, 0x18, 0x4C, 0x1A, 0x57, 0x1D, 0x1B, 0x47, 0xF7, 0x05, 0xFD, 0x08, 0x92, 0x92, 0x32, 0x32, 0x9A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x9A, 0x32, 0x32, 0x92, 0x1F, 0x6F, 0x0A, 0xFD, 0x04, 0xDD, 0x05, 0x07, 0x00, 0x73, 0x6E, 0x0E, 0x72, 0x15, 0x78, 0x2C, 0xF7, 0x26, 0x74, 0x75, 0x23, 0x41, 0xAB, 0x48, 0x1C, 0x50, 0x18, 0x18, 0x1A, 0x57, 0x1A, 0x18, 0xAB, 0x26, 0x15, 0x72, 0x0E, 
        0x12, 0xDD, 0x04, 0x6F, 0x1F, 0x0D, 0x08, 0x7B, 0x74, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x12, 0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x21, 0x4C, 0x41, 0x48, 0x18, 0x47, 0x48, 0x23, 0x26, 0x2C, 0x15, 
        0x6E, 0x00, 0x98, 0x0A, 0x1F, 0x32, 0x0D, 0x0D, 0x9A, 0x32, 0x1F, 0xFD, 0x98, 0x52, 0x6E, 0x72, 0x2C, 0x26, 0x23, 0x16, 0x1C, 0x18, 0x1A, 0x1D, 0x1B, 0x19, 0x5C, 0x55, 0x6B, 0x2F, 0x1E, 0x12, 0x08, 0x06, 0x05, 0x72, 0x58, 0x31, 0x3A, 0x3A, 0x3A, 
        0x3A, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 
        0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x9F, 0xBA, 0x97, 0x52, 0xCC, 0x55, 0x5A, 0x84, 0x4A, 0x67, 0x5B, 0xB8, 0xB5, 0x7D, 0x80, 0x5A, 0x20, 0x5A, 0x63, 0x6A, 0xA3, 0xAF, 0xBB, 0x5C, 0x70, 0x30, 0x63, 0xD3, 0xA3, 0xED, 0xC0, 0x8A, 0x98, 0xA2, 0x75, 0x1C, 
        0x17, 0x17, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x61, 0x39, 0x39, 0x39, 0x39, 0x39, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x1C, 0x1A, 0x41, 0x48, 0x48, 0x1C, 0x18, 0x47, 0x4C, 0x57, 0x57, 0x1B, 0x19, 0x57, 0x26, 0x98, 0x1F, 0x92, 0x32, 0xA9, 0x9A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x9A, 0x32, 0x32, 0x92, 0x1F, 0x6F, 0x0A, 0xFD, 0x04, 0xDD, 0x05, 0x07, 0x00, 0x73, 0x6E, 0x0E, 0x72, 0x15, 0x78, 0x2C, 0xF7, 0x26, 0x26, 0x75, 0x23, 0x41, 0x16, 0x48, 0x1C, 0x50, 0x50, 0x18, 0x1A, 0x1A, 0x4C, 0x1C, 0x16, 0x75, 0x7B, 0x78, 0x15, 
        0x73, 0x12, 0x05, 0x06, 0x0A, 0x0E, 0x41, 0x8E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x24, 0x22, 0x6B, 0x18, 0x16, 0x1C, 0x18, 0x47, 0x16, 0x2C, 0x78, 0x7E, 
        0x73, 0x07, 0x06, 0x08, 0x92, 0x9A, 0x0D, 0x0D, 0x9A, 0x92, 0x6F, 0xFD, 0x98, 0x52, 0x6E, 0x72, 0x78, 0x7B, 0x75, 0x16, 0x1C, 0x18, 0x47, 0x57, 0x5B, 0x54, 0xEB, 0x1E, 0x21, 0x47, 0x1F, 0x32, 0x1F, 0x0A, 0x6E, 0x58, 0x2D, 0x3B, 0x3B, 0x3B, 0x2E, 
        0x3B, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x3E, 0x3E, 0x3E, 0x36, 0x89, 0x9F, 0x25, 0x9F, 0x0E, 0x06, 0x6E, 0xC6, 0x69, 0x7D, 0x93, 0x4A, 0x6A, 0xAF, 0x5B, 0xBA, 0xB8, 0xB8, 0x5D, 0x5B, 0x1B, 0xBB, 0x6B, 0x7D, 0x8C, 0x4A, 0x58, 0xD3, 0xAC, 0xB1, 0x8A, 0x0C, 0x6E, 0x23, 0x3F, 0x71, 0x17, 
        0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x4B, 0x76, 0x76, 0x60, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x0F, 
        0x0F, 0x35, 0x35, 0x37, 0x37, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x35, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x6C, 0x57, 0x1C, 0xAB, 0x1C, 0x5E, 0x50, 0x47, 0x47, 0x1A, 0x5D, 0x5B, 0x5B, 0x19, 0x54, 0x5E, 0x52, 0x6F, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x9A, 0x32, 0xAD, 0x92, 0x1F, 0x6F, 0x08, 0x0A, 0x06, 0xDD, 0x05, 0x07, 0x00, 0x12, 0x73, 0x0E, 0x7E, 0x15, 0x78, 0x78, 0x2C, 0x7B, 0x26, 0x75, 0x23, 0xF0, 0x16, 0xAB, 0x48, 0x50, 0x1A, 0x1B, 0x1B, 0x5D, 0x47, 0x5E, 0x1C, 0xAB, 0x23, 0x7B, 0x2C, 
        0x15, 0x6E, 0x00, 0x12, 0x74, 0x23, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x0E, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x40, 0x40, 0x40, 0x40, 0x2D, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x59, 0x4C, 0x16, 0x1C, 0x18, 0x1A, 0x48, 0x15, 0x6E, 
        0x52, 0x05, 0x0C, 0x1F, 0x32, 0x0D, 0x0D, 0x0D, 0xA9, 0x92, 0x6F, 0x0C, 0x98, 0x52, 0x73, 0x72, 0x78, 0x7B, 0x74, 0x41, 0x48, 0x50, 0x4C, 0x56, 0x1D, 0x1B, 0x19, 0x58, 0xF7, 0x0D, 0x0D, 0x0D, 0x32, 0x73, 0x58, 0xB7, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 
        0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 
        0x4E, 0x71, 0x68, 0x46, 0x68, 0x17, 0x17, 0x17, 0x17, 0x2C, 0xDD, 0xA5, 0x75, 0x21, 0x6B, 0x2A, 0x84, 0x93, 0x84, 0x7D, 0x63, 0x7D, 0x34, 0x7D, 0x4A, 0x4A, 0x7D, 0x20, 0xEA, 0xA4, 0x7B, 0x8F, 0xA5, 0x43, 0x52, 0x7B, 0x16, 0x11, 0x76, 0x76, 0x76, 
        0x60, 0x60, 0x76, 0x76, 0x4B, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 0x76, 0x3F, 0x76, 0x76, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 
        0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x18, 0x47, 0x16, 0x48, 0x50, 0x18, 0x56, 0x47, 0x56, 0x5D, 0x5D, 0x1B, 0x19, 0x54, 0x1E, 0x54, 0x16, 0x05, 0x0D, 0x0D, 0x0D, 0x9A, 0x0D, 
        0x0D, 0x9A, 0x32, 0x1F, 0x6F, 0x08, 0x0A, 0x04, 0xDD, 0x98, 0x05, 0x07, 0x00, 0x73, 0x6E, 0x6E, 0x7E, 0x15, 0x78, 0x78, 0x2C, 0x7B, 0x26, 0x23, 0x74, 0x75, 0x48, 0x57, 0x5C, 0x21, 0x59, 0x67, 0x19, 0x1B, 0x5D, 0x1A, 0x18, 0x48, 0xF0, 0x23, 0x26, 
        0x2C, 0x15, 0x15, 0x16, 0x4F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x09, 0x09, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x12, 0x12, 0x00, 0x12, 0x00, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12,
  0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x24, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x57, 0x16, 0x48, 0x18, 0x1A, 0x47, 0x7B, 
        0x07, 0x04, 0x0A, 0x92, 0x32, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x08, 0x0C, 0x05, 0x52, 0x73, 0x7E, 0x78, 0x2C, 0x26, 0x23, 0xAB, 0x1C, 0x18, 0x1A, 0x57, 0x5B, 0x18, 0x7E, 0x0C, 0x92, 0xA9, 0x9A, 0x15, 0x1E, 0x38, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x3B, 0x2E, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 
        0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x4E, 0x3F, 0x73, 0x06, 0x06, 0xCB, 0x5C, 0x54, 0x59, 0x62, 0x62, 0x80, 0x20, 0x5A, 0x5A, 0x65, 0x69, 0x55, 0x1C, 0xDA, 0xA6, 0xA8, 0x8A, 0x04, 0xF7, 0x16, 0x3F, 0x4B, 0x4B, 0x76, 0x76, 0x4B, 
        0x4B, 0x4B, 0x4B, 0x82, 0x4B, 0x4B, 0x3F, 0x3F, 0x4B, 0x82, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x60, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x60, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 
        0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x33, 0x33, 0x33, 0x33, 0x4F, 0x33, 0x4F, 0x4F, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x15, 0x15, 
        0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B, 0x1D, 0x50, 0x41, 0x1C, 0x18, 0x18, 0x47, 0x57, 0x1D, 0x1D, 0x1B, 0x58, 0x19, 0x53, 0x1E, 0x67, 0x53, 0x1A, 0x78, 0x06, 0x32, 
        0x32, 0x32, 0x92, 0x1F, 0x8A, 0x8A, 0x6F, 0x0A, 0x06, 0xDD, 0x05, 0x07, 0x52, 0x00, 0x12, 0x0E, 0x72, 0x15, 0x15, 0x15, 0x2C, 0x26, 0x23, 0x18, 0xEB, 0x6D, 0x20, 0x20, 0x2A, 0x01, 0x62, 0x59, 0x1E, 0xEB, 0x58, 0x1D, 0x47, 0x18, 0x50, 0x16, 0x26, 
        0x78, 0x41, 0x6C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x19, 0x48, 0x1C, 0x18, 0x1A, 0x1D, 
        0x47, 0x78, 0x08, 0x32, 0xA9, 0x0D, 0x0D, 0x0D, 0x32, 0x92, 0x08, 0x06, 0x05, 0x52, 0x73, 0x7E, 0x15, 0x2C, 0x26, 0x23, 0x16, 0x48, 0x50, 0x47, 0x1A, 0x1C, 0x7B, 0x15, 0x00, 0x06, 0x0A, 0x16, 0x21, 0x31, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 
        0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x89, 0x36, 0x36, 0x25, 
        0x25, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x2C, 0xDD, 0x92, 0xDD, 0xA2, 0x9E, 0x5B, 0x5D, 0x5C, 0x1D, 0x1D, 0x5D, 0xA4, 0x0E, 0x98, 0x9A, 0xA8, 0x92, 0xB2, 0xA2, 0xF3, 0x17, 0x17, 0x4B, 0x17, 0x3F, 0x4B, 0x3F, 0x3F, 
        0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x79, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x15, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x33, 0x15, 0x15, 0x23, 0x57, 0x1C, 0x48, 0x18, 0x4C, 0x47, 0x57, 0x5B, 0x5B, 0x5B, 0x58, 0xEB, 0x1E, 0x55, 0x21, 0x21, 0x59, 0x2F, 0x59, 
        0x19, 0x4C, 0x75, 0x72, 0x97, 0xDD, 0x06, 0x06, 0x04, 0xDD, 0x05, 0x07, 0x00, 0x73, 0x0E, 0x7E, 0x2C, 0x16, 0x56, 0x1E, 0x2A, 0xC1, 0xDF, 0x93, 0x4A, 0xC1, 0x63, 0xC2, 0x5A, 0x70, 0x01, 0x2F, 0x21, 0x1E, 0x19, 0x1B, 0x5B, 0x1A, 0x1C, 0x26, 0x41, 
        0x23, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x09, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00,
  0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x28, 0x21, 0x4C, 0x1C, 0x18, 0x1A, 
        0x1D, 0x1B, 0x5B, 0x23, 0x04, 0x0D, 0x0D, 0x0D, 0x32, 0x1F, 0x08, 0x06, 0x05, 0x52, 0x73, 0x0E, 0x15, 0x2C, 0x26, 0x75, 0x41, 0x47, 0x54, 0x58, 0x1D, 0x18, 0x41, 0x7B, 0x15, 0x78, 0x5B, 0xB7, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 
        0x3E, 0x89, 0x36, 0x36, 0x36, 0x36, 0x9F, 0x36, 0x36, 0x36, 0x9F, 0x36, 0x89, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x29, 0x29, 0x3E, 0x3E, 0x89, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x89, 0x3E, 0x89, 0x11, 0x0E, 0x0A, 0x92, 0xA9, 0x9A, 0x32, 0x8A, 0xAD, 0x0D, 0x9A, 0x9A, 0x0D, 0x32, 0x1F, 0xB2, 0x78, 0x48, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 
        0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 
        0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x18, 0x47, 0x50, 0x5E, 0x50, 0x47, 0x56, 0x1D, 0x1B, 0x5B, 0x1B, 0x58, 0x19, 0x1E, 0x59, 0x2F, 0x59, 0x2F, 
        0x69, 0x65, 0x2A, 0x70, 0x20, 0x20, 0x20, 0x2A, 0x6D, 0x6D, 0x6D, 0x2A, 0x20, 0xC2, 0x34, 0xDF, 0x93, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x93, 0xDF, 0x4A, 0xC1, 0x34, 0x5A, 0x20, 0x70, 0x01, 0x62, 0x2F, 0x21, 0xEB, 0x57, 0xF0, 0x23, 0x41, 0x4D, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x10, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x42, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x5F, 0xEB, 0x5E, 0x50, 
        0x1A, 0x1D, 0x1B, 0x19, 0x67, 0xEB, 0x5E, 0x26, 0x6E, 0x98, 0x0A, 0x06, 0x98, 0x52, 0x73, 0x72, 0x75, 0x1A, 0x1E, 0x6D, 0x5A, 0x20, 0x01, 0x21, 0x19, 0x1D, 0x18, 0x75, 0x18, 0x21, 0x22, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 
        0x3A, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x25, 0x4D, 0x07, 0x8A, 0x92, 0xA9, 0x0D, 0xA9, 0x0D, 0xB3, 0xA6, 0x92, 0x8F, 0x78, 0x16, 0x68, 0x9F, 0x36, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x68, 
        0x68, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x11, 0x3D, 
        0x3D, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0x58, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1B, 0x61, 0x39, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x16, 0x4C, 0x1C, 0x1C, 0x47, 0x1A, 0x56, 0x5B, 0x1B, 0x58, 0xEB, 0x53, 0x5C, 0x67, 0x55, 0x2F, 
        0x2F, 0x69, 0x01, 0x65, 0x2A, 0x70, 0x20, 0x5A, 0xC2, 0x63, 0x34, 0x34, 0x7D, 0x4A, 0x4A, 0x4A, 0xDF, 0x93, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x93, 0x4A, 0x94, 0x34, 0x5A, 0x20, 0x70, 0x65, 0x6B, 0x1B, 0x41, 0x23, 0x23, 0x61, 0x0E, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x10, 0x09, 0x10, 0x09, 0x09, 0x10, 0x10, 0x10,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x22, 0x90, 0x54, 
        0x5E, 0x4C, 0x1D, 0x1B, 0x19, 0x1E, 0x21, 0x2F, 0x65, 0x2A, 0x20, 0x70, 0x20, 0xC2, 0xC1, 0xDF, 0x30, 0x30, 0x30, 0x93, 0x4A, 0x34, 0x20, 0x65, 0x55, 0x18, 0x18, 0x67, 0x28, 0x38, 0x38, 0x24, 0x24, 0x38, 0x24, 0x24, 0x38, 0x24, 0x38, 0x38, 0x38, 
        0x38, 0x38, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x3E, 0x89, 0x3E, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x89, 0x3E, 0x9F, 0x3D, 0x00, 0xA5, 0xA6, 0xA8, 0xA8, 0xA5, 0x92, 0xA5, 0xFC, 0x41, 0x5E, 0x25, 0x9F, 0x36, 0x36, 0x25, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x68, 0x68, 0x68, 0x68, 0x17, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 
        0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x4B, 0x3F, 0x3F, 0x76, 0x76, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x56, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x71, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x0F, 0x18, 0x18, 0x1C, 0x1A, 0x5D, 0x5D, 0x5B, 0x58, 0x19, 0x19, 0x1E, 0x21, 0x21, 
        0x59, 0x62, 0x01, 0x65, 0x6D, 0x2A, 0x70, 0x70, 0x20, 0x5A, 0x63, 0x34, 0xC1, 0xC1, 0x7D, 0x4A, 0xDF, 0xDF, 0x93, 0x93, 0x30, 0x30, 0x30, 0x30, 0x30, 0x93, 0x4A, 0x4A, 0x7A, 0x34, 0x5A, 0x65, 0x1D, 0x23, 0x16, 0x16, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x40, 
        0x5F, 0x53, 0x47, 0x4C, 0x5B, 0x19, 0x1E, 0x21, 0x2F, 0x65, 0x2A, 0x20, 0x5A, 0x34, 0xC1, 0x4A, 0x93, 0x30, 0x30, 0x30, 0x93, 0x94, 0x59, 0x1A, 0x1D, 0x21, 0x42, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 
        0x38, 0x38, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x25, 0x4E, 0x25, 0x48, 0xFA, 0x98, 0xA6, 0xBF, 0x8A, 0xB2, 0x7B, 0x48, 0x48, 0x68, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 0x76, 
        0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x76, 0x11, 0x3D, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x5D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1A, 0x8E, 0x8E, 0xF5, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 
        0x33, 0x4F, 0x4F, 0x33, 0x4F, 0x33, 0x33, 0x33, 0xF8, 0x33, 0xF8, 0x33, 0x15, 0xF8, 0x4F, 0x33, 0xF8, 0xF8, 0x33, 0x15, 0x15, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x50, 0x4C, 0x5E, 0x1C, 0x56, 0x5B, 0x54, 0xEB, 0x1E, 0x5C, 0x55, 
        0x21, 0x59, 0x2F, 0x69, 0x65, 0x2A, 0x2A, 0x20, 0x20, 0x20, 0x5A, 0x63, 0x34, 0xC1, 0x7A, 0x94, 0x4A, 0xDF, 0x93, 0x93, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x93, 0x63, 0xEB, 0x1C, 0xF0, 0x41, 0x4D, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x27, 
        0x27, 0x27, 0x27, 0x02, 0x02, 0x27, 0x27, 0x27, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x27, 0x0E, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 
        0x40, 0x28, 0x5F, 0x90, 0x19, 0x56, 0x47, 0x1D, 0xEB, 0x2F, 0x01, 0x2A, 0x20, 0x5A, 0x34, 0x7A, 0x94, 0x34, 0x2A, 0x55, 0x1D, 0x5D, 0x1E, 0xE6, 0x22, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 
        0x24, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 
        0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x4C, 0x48, 0xF7, 0x78, 0xA4, 0x18, 0x4C, 0x89, 0x25, 0x25, 0x4E, 0x4E, 0x25, 0x25, 0x4E, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 
        0x4E, 0x4E, 0x4E, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x71, 0x71, 0x71, 0x46, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 
        0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x11, 0x1D, 0x2F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6B, 0x47, 0x39, 0x39, 0x61, 0x61, 0x61, 0x39, 0x61, 0x61, 0x39, 0x39, 0x39, 0x61, 0x8E, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x7C, 0x7C, 0x7C, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x37, 0x5E, 0x5E, 0x18, 0x1C, 0x18, 0x1B, 0x53, 0x1E, 
        0x67, 0x21, 0x6B, 0x62, 0x69, 0x65, 0x6D, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x34, 0xC1, 0x7D, 0x4A, 0x4A, 0x4A, 0xDF, 0x93, 0x30, 0x30, 0x30, 0x4A, 0x2A, 0x1B, 0xAB, 0x41, 0x16, 0x26, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 
        0x22, 0x31, 0x31, 0x24, 0x24, 0x28, 0x67, 0x21, 0x1E, 0x1B, 0x57, 0x47, 0x4C, 0x18, 0x47, 0x1A, 0x1D, 0x19, 0x67, 0x21, 0x28, 0x22, 0x24, 0x24, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 
        0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x3A, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x89, 0x36, 0x36, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 
        0x4E, 0x4E, 0x68, 0x68, 0x68, 0x68, 0x46, 0x68, 0x68, 0x68, 0x68, 0x46, 0x46, 0x46, 0x68, 0x71, 0x46, 0x4E, 0x71, 0x25, 0x18, 0x25, 0x9F, 0x25, 0x25, 0x25, 0x25, 0x25, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3E, 0x3E, 0x3E, 0x3E, 
        0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x68, 0x68, 0x46, 0x46, 0x46, 0x68, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x4B, 0x4B, 0x76, 0x76, 0x60, 0x76, 0x76, 0x76, 0x76, 
        0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x0B, 0x0B, 0x61, 0x61, 0x8E, 0x61, 0x61, 0x8E, 0x8E, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x15, 0x15, 0x33, 0x15, 0x33, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x4F, 0x03, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1C, 0x50, 0x1C, 0x5E, 0x5E, 
        0x1C, 0x1A, 0x54, 0x1E, 0x6B, 0x69, 0x01, 0x65, 0x2A, 0x70, 0x20, 0x20, 0x5A, 0x63, 0x63, 0xC1, 0x7D, 0xC1, 0x34, 0x20, 0x2F, 0x1B, 0x4C, 0x41, 0x16, 0x48, 0x23, 0x4D, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
  0x49, 0x66, 0x66, 0x66, 0x66, 0x42, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 
        0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 
        0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x89, 0x3E, 0x3E, 0x89, 
        0x89, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x46, 0x46, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x4B, 0x4B, 0x60, 0x60, 0x60, 
        0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x4B, 
        0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B, 
        0x16, 0x5E, 0x5E, 0x16, 0x1C, 0x48, 0xAB, 0x1C, 0x48, 0x1C, 0x1C, 0x48, 0x1C, 0x5E, 0x50, 0x48, 0xAB, 0x16, 0xF0, 0x16, 0x5E, 0x23, 0x0F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 
        0x27, 0x02, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x09, 0x09, 0x0E,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x2D, 
        0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 
        0x24, 0x38, 0x38, 0x38, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x9F, 0x36, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x68, 0x68, 0x68, 0x4E, 0x4E, 0x4E, 0x4E, 0x71, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 
        0x4E, 0x4E, 0x71, 0x71, 0x71, 0x4E, 0x71, 0x46, 0x46, 0x46, 0x46, 0x46, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x17, 0x3F, 0x3F, 0x3F, 
        0x3F, 0x76, 0x76, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 
        0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x4F, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 
        0x33, 0x33, 0x4F, 0x33, 0x33, 0x4F, 0x4F, 0x33, 0x4F, 0x33, 0x33, 0x4F, 0x4F, 0x33, 0x33, 0x03, 0x03, 0x33, 0x33, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x4F, 0x33, 0x33, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x0E, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
  0x42, 0x42, 0x42, 0x42, 0x66, 0x66, 0x42, 0x42, 0x42, 0x66, 0x66, 0x66, 0x66, 0x42, 0x42, 0x42, 0x66, 0x66, 0x66, 0x66, 0x66, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 
        0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x24, 0x24, 0x38, 0x38, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x3B, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x71, 0x71, 0x71, 0x71, 0x68, 0x68, 0x71, 0x68, 0x68, 0x68, 0x46, 0x68, 0x68, 0x46, 0x46, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x4B, 0x4B, 0x76, 0x76, 0x60, 0x76, 0x76, 
        0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x79, 0x79, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 
        0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x37, 0x37, 0x37, 0x35, 0x37, 0x35, 0x35, 0x6C, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 
        0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0xF8, 0xF8, 0xF8, 0x15, 0x15, 0x7C, 0x7C, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x10,
  0x49, 0x49, 0x49, 0x49, 0x66, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 
        0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x3A, 0x3A, 
        0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x71, 0x71, 0x46, 0x46, 0x46, 0x68, 0x68, 0x68, 
        0x17, 0x17, 0x17, 0x17, 0x3F, 0x4B, 0x4B, 0x76, 0x76, 0x60, 0x60, 0x60, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 
        0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 0x60, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x37, 0x37, 
        0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x8E, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x61, 0x39, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x8E, 0x8E, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x33, 
        0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x15, 0x7C, 0x7C, 0x7C, 0x15, 0x7C, 0x15, 0x7C, 0x7C, 0x15, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x0E, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
  0x28, 0x28, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x24, 0x24, 0x24, 
        0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 
        0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x46, 0x46, 0x68, 0x46, 0x46, 0x68, 0x68, 
        0x68, 0x17, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x4B, 0x4B, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 
        0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x60, 0x76, 0x76, 0x3F, 0x3F, 0x76, 0x76, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 
        0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x02, 0x02, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x27, 0x0E, 0x27, 0x0E, 0x0E, 0x0E, 0x0E,
  0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x42, 0x42, 0x42, 0x66, 0x66, 0x66, 0x66, 0x66, 0x42, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 
        0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x22, 0x22, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 
        0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 
        0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 
        0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 
        0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 
        0x02, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x02, 0x02, 0x15, 0x7C, 0x7C, 0x15, 0x15, 0x33, 0x33, 0x4F, 0x33, 0x33, 0x4F, 
        0x4F, 0x4F, 0x4F, 0x33, 0x4F, 0x4F, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0xF8, 0xF8, 0xF8, 0xF8, 0x51, 0x51, 0x51, 0x51, 0x51, 0x33, 0x33, 0xF8, 0xF8, 0xF8, 0x33, 0xF8, 0x33, 0x51, 0xF8, 0xF8, 0x51, 0x51, 
        0x15, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x27, 0x27, 0x0E, 0x0E, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x0E,
  0xB4, 0xB4, 0xB4, 0xB4, 0x88, 0x88, 0x87, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x49, 0x49, 0x66, 0x66, 0x42, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 
        0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 
        0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x46, 0x46, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x82, 
        0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 
        0x61, 0x61, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 
        0x33, 0x33, 0x4F, 0x33, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 
        0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 
        0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x4E, 0x4E, 
        0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 
        0x17, 0x68, 0x68, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x6C, 0x6C, 0x37, 0x37, 
        0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x35, 0x35, 0x35, 0x37, 0x37, 0x35, 0x37, 0x37, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x39, 0x8E, 0x8E, 0x8E, 
        0x8E, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 
        0xF8, 0xF8, 0x15, 0x15, 0xF8, 0x15, 0x15, 0x33, 0xF8, 0xF8, 0x33, 0x15, 0x7C, 0x33, 0x15, 0x15, 0x15, 0x7C, 0x7C, 0x7C, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x0E,
  0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x87, 0x87, 0x87, 0x87, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x49, 0x49, 0x49, 0x49, 0x49, 0x66, 0x66, 0x66, 0x42, 0x28, 0x28, 0x28, 0x28, 0x40, 0x2D, 
        0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 
        0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 
        0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x71, 0x46, 0x46, 0x46, 0x68, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x4B, 0x4B, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 
        0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x11, 0x11, 0x11, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 
        0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 
        0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x4F, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 
        0x02, 0x02, 0x02, 0x15, 0x51, 0xF8, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x33, 0x51, 0x51, 0x51, 0x7C, 0x51, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x49, 0x49, 0x49, 0x49, 0x49, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x42, 0x42, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 
        0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 
        0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 
        0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x9F, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x25, 
        0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x46, 0x46, 0x68, 0x46, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 
        0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x60, 0x60, 0x76, 
        0x60, 0x60, 0x76, 0x76, 0x60, 0x76, 0x76, 0x76, 0x60, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x8E, 0x39, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x8E, 0x39, 0x39, 0x39, 0x61, 0x39, 0x39, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x61, 0x61, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 
        0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x28, 0x28, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 
        0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 
        0x31, 0x31, 0x31, 0x24, 0x24, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 
        0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x4E, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x71, 0x68, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x71, 0x71, 0x71, 0x46, 0x68, 0x68, 0x68, 0x68, 0x17, 0x3F, 0x3F, 0x3F, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 
        0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x6C, 0x37, 0x37, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 
        0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x39, 0x8E, 0x8E, 0x39, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x7C, 0x7C, 0x15, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x66, 0x66, 0x66, 0x42, 0x42, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 
        0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 
        0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 
        0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x46, 0x46, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 
        0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0x8D, 0x8D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x79, 0x81, 0xA0, 0xA0, 0x81, 0xA0, 0x81, 0x81, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 
        0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x15, 0x15, 0x15, 0x15, 0x33, 0x33, 0x33, 0x33, 0x33, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0xF8, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x15, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x7C, 0x15, 0x15, 0x15, 0x15, 0x15, 0xF8, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 
        0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x4F, 0x4F, 0x4F, 0x4F, 0xF8, 0xF8, 0x15, 0x7C, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09,
  0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x42, 0x42, 0x66, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 
        0x28, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 
        0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 
        0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x4B, 0x76, 0x60, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x3F, 0x4B, 0x76, 0x76, 0x76, 0x4B, 0x4B, 0x76, 0x76, 
        0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x8E, 0x61, 0x39, 0x39, 0x39, 0x39, 
        0x8E, 0x39, 0x39, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x4F, 0x4F, 0x4F, 0xF8, 0x15, 0x33, 0x33, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x15, 0x7C, 0x7C, 0x7C, 0x33, 0x33, 0x51, 0x51, 0x51, 0x51, 0x51, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x27, 0x27, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x02, 0x02, 0x15, 0x7C, 0x7C, 0x7C, 
        0x15, 0x15, 0x15, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 
        0x22, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x2D, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x42, 0x42, 0x42, 0x42, 0x66, 0x66, 
        0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x3A, 0x2B, 0x3B, 0x3B, 0x3B, 
        0x3B, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x46, 0x68, 0x46, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0x79, 0xA0, 0xA0, 0xA0, 0xA0, 
        0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x39, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 
        0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x6C, 0x35, 0x35, 0x35, 0x35, 0x35, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 0x35, 0x0F, 
        0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x33, 0x4F, 0x33, 0x33, 0x7C, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x7C, 0x7C, 0x7C, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x7C, 0x7C, 0x15, 0x02, 0x02, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27,
  0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 
        0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 
        0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 
        0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x89, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x46, 0x46, 0x68, 0x68, 0x68, 0x46, 0x46, 0x68, 0x68, 0x68, 0x68, 
        0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x4B, 0x4B, 0x4B, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x35, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x35, 0x35, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x4F, 0x33, 0x33, 0xF8, 0xF8, 0x15, 0x15, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x51, 0x51, 0x51, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x51, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 0x7C, 0x7C, 0x02, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
  0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x42, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x22, 
        0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x2D, 0x22, 0x22, 0x22, 0x22, 
        0x22, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 
        0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x76, 
        0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0x3D, 0xA0, 0x8D, 0xA0, 0xA0, 
        0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x8E, 0x39, 0x39, 0x8E, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x4F, 0x33, 0x4F, 0xF8, 0xF8, 0x7C, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x7C, 0x15, 0x15, 0x15, 0x15, 0x51, 0x15, 0x51, 0x51, 0x51, 0x33, 
        0x33, 0x33, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x51, 0x51, 0xF8, 0xF8, 0x51, 0x51, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x7C, 0x7C,
  0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x87, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x66, 0x66, 0x66, 0x66, 0x42, 
        0x42, 0x42, 0x28, 0x28, 0x28, 0x40, 0x40, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x31, 0x24, 0x24, 0x24, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x31, 
        0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 
        0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 
        0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x71, 0x46, 0x46, 0x68, 0x46, 0x68, 0x17, 0x17, 0x17, 0x17, 
        0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x4B, 0x4B, 0x76, 0x76, 0x60, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x4B, 0x3F, 0x4B, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 
        0x17, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x4B, 0x4B, 0x4B, 0x60, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x8E, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x8E, 0x39, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 
        0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0xF8, 0xF8, 0x33, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x7C, 0x7C, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x02, 0x02, 0x15, 0x15, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x15, 0x7C, 0x51, 0x51, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x03, 0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x51, 0x7C, 0x7C, 0x7C, 0x15, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
  0x87, 0x87, 0x87, 0x87, 0x87, 0x87, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x66, 0x66, 0x66, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 
        0x28, 0x28, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 
        0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x38, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x36, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x71, 0x46, 0x46, 0x46, 0x46, 0x46, 0x68, 0x68, 0x68, 
        0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x82, 0x76, 0x76, 0x76, 0x76, 0x4B, 0x76, 0x76, 0x4B, 0x76, 0x76, 0x60, 0x60, 0x60, 0x60, 
        0x76, 0x60, 0x60, 0x76, 0x60, 0x60, 0x60, 0x4B, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x76, 0x11, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x37, 0x37, 0x0B, 0x0B, 0x37, 0x0B, 0x37, 
        0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x33, 0x51, 0x51, 0x33, 0x51, 0x51, 0x51, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x02, 0x02, 
        0x02, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x7C, 0x15, 0x7C, 0x7C, 0x02, 0x02, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x02, 0x27, 0x02, 0x02, 0x02, 0x02,
  0x49, 0x49, 0x49, 0x66, 0x66, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x28, 0x28, 0x42, 0x42, 0x28, 0x28, 0x28, 0x42, 0x42, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x22, 
        0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x31, 
        0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 
        0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x3E, 0x36, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x46, 0x46, 0x46, 0x68, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 
        0x3F, 0x76, 0x76, 0x76, 0x76, 0x60, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x4B, 0x4B, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x17, 0x17, 0x17, 0x3F, 0x3F, 
        0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x11, 0x3D, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x35, 0x35, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 
        0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x39, 0x39, 0x39, 0x39, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0x8E, 0x8E, 0x8E, 0x8E, 0x03, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x33, 0x51, 0x51, 0x7C, 0x15, 0x7C, 0x15, 0x15, 0x7C, 0x02, 0x02, 0x15, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x02, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x28, 0x28, 0x28, 0x40, 0x40, 0x40, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x40, 0x40, 0x40, 0x40, 0x40, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 
        0x28, 0x28, 0x28, 0x40, 0x40, 0x2D, 0x2D, 0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x31, 0x31, 0x31, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 
        0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 
        0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x3A, 0x3A, 0x3A, 0x2B, 0x2B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x2E, 0x2E, 0x2E, 0x29, 0x29, 0x29, 0x3E, 0x3E, 0x36, 0x36, 0x36, 0x36, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 
        0x4E, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x4E, 0x4E, 0x25, 0x25, 0x4E, 0x4E, 0x4E, 0x71, 0x71, 0x4E, 0x71, 0x71, 0x71, 0x71, 0x71, 0x71, 0x71, 0x46, 0x71, 0x71, 0x71, 0x68, 0x46, 0x46, 0x46, 0x46, 0x68, 0x68, 0x17, 0x17, 0x17, 0x3F, 
        0x3F, 0x76, 0x76, 0x76, 0x76, 0x76, 0x11, 0x11, 0x3D, 0x3D, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xA0, 0x0F, 0x0F, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x35, 0x6C, 0x37, 0x37, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x61, 0x61, 0x8E, 0x8E, 0x39, 0x8E, 0x8E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 
        0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x33, 0x33, 0x33, 0x51, 0x51, 0x7C, 0x7C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7C, 0x7C, 0x7C, 0x15, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x09, 0x09, 0x09, 0x09, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E
};

GUI_CONST_STORAGE GUI_BITMAP bmBackground_480x272 = {
  480, // xSize
  272, // ySize
  480, // BytesPerLine
  8, // BitsPerPixel
  _acBackground_480x272,  // Pointer to picture data (indices)
  &_PalBackground_480x272   // Pointer to palette
};

/*********************************************************************
*
*       Button 30x30 unpressed
*/
#if (GUI_USE_ARGB)
static GUI_CONST_STORAGE unsigned long _acknob_gray_trans_30x30[] = {
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00D3D3D3, 0x00D3D3D3, 0x00D3D3D3, 0x00D1D1D1, 0x00C0C0C0, 0x00ABABAB, 0x008F8E8E, 0x00858585, 0x007C7C7C, 0x2E8A8989, 0x76959394, 0xB2A5A2A3, 0xD7B3AFB0, 0xECC2BEBF, 0xEFC9C5C6, 0xDDC3BEBF, 0xBDBBB8B9, 0x85B6B5B5, 0x40B5B3B4, 0x01B6B4B5, 
        0x00BABABA, 0x00B9B9B9, 0x00B8B8B8, 0x00BFBFBF, 0x00C3C3C3, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00FFFFFF,
  0x00FFFFFF, 0x00D3D3D3, 0x00D3D3D3, 0x00D3D3D3, 0x00D1D1D1, 0x00C0C0C0, 0x00ABABAB, 0x008F8E8E, 0x357E7E7E, 0xA46A6A6A, 0xF6737272, 0xFF868485, 0xFF9D9A9C, 0xFFB2AFB0, 0xFFC3C2C2, 0xFFD1D0D1, 0xFFD7D6D7, 0xFFD2D0D1, 0xFFC0BEBF, 0xFEB2B0B1, 0xBBADABAC, 
        0x4EB4B3B4, 0x02B9B9B9, 0x00B9B9B9, 0x00BFBFBF, 0x00C3C3C3, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00FFFFFF,
  0x00FFFFFF, 0x00D3D3D3, 0x00D3D3D3, 0x00D3D3D3, 0x00D1D1D1, 0x00C0C0C0, 0x19A9A9A9, 0xA58D8C8D, 0xF7757474, 0xFF6B6A6B, 0xFF817F80, 0xFF989596, 0xFFABAAAB, 0xFFBBBCBC, 0xFFCDCDCD, 0xFFDCDCDC, 0xFFEEEEEE, 0xFFFDFDFD, 0xFFF9F9F9, 0xFFDEDDDE, 0xFFBEBEBE, 
        0xFFABAAAB, 0xBDABAAAB, 0x34B5B5B5, 0x00C0C0C0, 0x00C3C3C3, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00FFFFFF,
  0x00FFFFFF, 0x00D3D3D3, 0x00D3D3D3, 0x00D3D3D3, 0x00D0D0D0, 0x2FC1C1C1, 0xD3AFAFAF, 0xFF8C8A8B, 0xFF6E6C6D, 0xFF777576, 0xFF878586, 0xFF969495, 0xFFA8A7A7, 0xFFB8B8B8, 0xFFCBCBCB, 0xFFDCDCDC, 0xFFEFEFEF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFE7E7E7, 0xFFD1D1D1, 
        0xFFBBB9BA, 0xFFAAA9A9, 0xEDA7A7A7, 0x52B8B8B8, 0x00C5C5C5, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00FFFFFF,
  0x00FFFFFF, 0x00D5D5D5, 0x00D5D5D5, 0x00D4D4D4, 0x2FD5D5D5, 0xE0D2D2D2, 0xFF919191, 0xFF565555, 0xFF5C5A5B, 0xFF6C6A6B, 0xFF7E7C7D, 0xFF8F8C8D, 0xFFA3A3A3, 0xFFB5B5B5, 0xFFCACACA, 0xFFDCDCDC, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFF1F1F1, 0xFFDADADA, 0xFFC3C3C3, 
        0xFFB1B1B1, 0xFFA0A0A0, 0xFF9F9F9F, 0xF3A9A7A8, 0x57B9B9B9, 0x00C8C8C8, 0x00C6C6C6, 0x00C6C6C6, 0x00FFFFFF,
  0x00FFFFFF, 0x00E5E5E5, 0x00E5E5E5, 0x18E9E9E9, 0xD5F7F7F7, 0xFFA2A1A2, 0xFF373737, 0xFF444343, 0xFF565355, 0xFF646263, 0xFF767475, 0xFF888587, 0xFF9D9D9D, 0xFFB2B2B2, 0xFFC9C9C9, 0xFFDDDDDD, 0xFFF5F5F5, 0xFFFFFFFF, 0xFFE8E8E8, 0xFFD0D0D0, 0xFFB7B7B7, 
        0xFFA3A3A3, 0xFF919091, 0xFF817F80, 0xFF979596, 0xF5A9A9A9, 0x3BBDBDBD, 0x00C7C7C7, 0x00C5C5C5, 0x00FFFFFF,
  0x00FFFFFF, 0x00CBCBCB, 0x00CBCBCB, 0xA5F0F0F0, 0xFFDBDBDB, 0xFF3D3B3C, 0xFF2A2829, 0xFF3B393A, 0xFF494748, 0xFF585657, 0xFF6B696A, 0xFF7E7C7D, 0xFF959495, 0xFFAEAEAE, 0xFFC8C8C8, 0xFFDEDEDE, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFDBDBDB, 0xFFC1C1C1, 0xFFA7A7A7, 
        0xFF929292, 0xFF808080, 0xFF6C6C6C, 0xFF666666, 0xFF9A9A9A, 0xCEB1B1B1, 0x09C6C6C6, 0x00C8C8C8, 0x00FFFFFF,
  0x00FFFFFF, 0x00B4B4B4, 0x32B4B4B4, 0xF9CCCCCC, 0xFF706F6F, 0xFF353334, 0xFF343233, 0xFF302E2F, 0xFF3B393A, 0xFF4A4849, 0xFF5E5C5D, 0xFF747172, 0xFF8C8B8C, 0xFFA8A8A8, 0xFFC6C6C6, 0xFFE1E1E1, 0xFFFCFCFC, 0xFFF1F1F1, 0xFFCDCDCD, 0xFFB0B0B0, 0xFF959595, 
        0xFF808080, 0xFF6E6E6E, 0xFF5C5C5C, 0xFF545454, 0xFF727272, 0xFFABABAB, 0x66BFBFBF, 0x00CCCCCC, 0x00FFFFFF,
  0x00FFFFFF, 0x018D8D8D, 0xA78D8D8D, 0xFF868787, 0xFF4F4F4F, 0xFF4B494A, 0xFF434142, 0xFF363435, 0xFF302E2F, 0xFF3A3839, 0xFF4F4D4E, 0xFF666465, 0xFF818081, 0xFFA0A0A0, 0xFFC4C4C4, 0xFFE5E5E5, 0xFFFBFBFB, 0xFFE2E2E2, 0xFFBABABA, 0xFF9B9B9B, 0xFF7F7F7F, 
        0xFF6B6B6B, 0xFF5C5C5C, 0xFF5A5A5A, 0xFF616161, 0xFF656565, 0xFF979797, 0xD9B5B5B5, 0x11C7C7C7, 0x00FFFFFF,
  0x00FFFFFF, 0x2D666666, 0xF95A5A5A, 0xFF676666, 0xFF616060, 0xFF5B595A, 0xFF535152, 0xFF494748, 0xFF3C3A3B, 0xFF312F30, 0xFF383637, 0xFF535152, 0xFF727071, 0xFF959495, 0xFFC1C1C1, 0xFFE9E9E9, 0xFFF6F6F6, 0xFFCCCCCC, 0xFF9F9F9F, 0xFF7F7F7F, 0xFF636363, 
        0xFF585858, 0xFF5F5F5F, 0xFF686868, 0xFF6D6D6D, 0xFF6F6F6F, 0xFF888787, 0xFFB5B3B3, 0x63C2C1C2, 0x00FFFFFF,
  0x00FFFFFF, 0x77363636, 0xFF363636, 0xFF717071, 0xFF726F70, 0xFF6B696A, 0xFF646263, 0xFF5C5A5B, 0xFF525051, 0xFF434142, 0xFF333132, 0xFF3B393A, 0xFF5C5A5B, 0xFF868485, 0xFFBBBBBB, 0xFFEEEEEE, 0xFFE6E6E6, 0xFFADADAD, 0xFF7E7E7E, 0xFF616161, 0xFF5C5C5C, 
        0xFF656565, 0xFF6D6D6D, 0xFF747474, 0xFF787879, 0xFF7C7A7B, 0xFF868384, 0xFFB8B3B4, 0xA1C2BFC0, 0x00FFFFFF,
  0x00FFFFFF, 0xB50D0D0D, 0xFF2C2C2C, 0xFF848384, 0xFF817F80, 0xFF7C7A7B, 0xFF777576, 0xFF716F70, 0xFF696768, 0xFF5F5D5E, 0xFF504E4F, 0xFF3A3839, 0xFF383637, 0xFF686667, 0xFFB3B3B3, 0xFFF4F4F4, 0xFFC4C4C4, 0xFF7A7A7A, 0xFF5D5D5D, 0xFF616161, 0xFF707070, 
        0xFF787777, 0xFF7D7C7C, 0xFF828081, 0xFF858485, 0xFF888687, 0xFF8A8889, 0xFFB3B0B1, 0xC8C5C2C3, 0x00FFFFFF,
  0x00FFFFFF, 0xD9080808, 0xFF424242, 0xFF979596, 0xFF8E8C8D, 0xFF8B898A, 0xFF888687, 0xFF858384, 0xFF817F80, 0xFF7A7879, 0xFF716F70, 0xFF626061, 0xFF454344, 0xFF413F40, 0xFF9B9B9B, 0xFFE5E5E5, 0xFF858484, 0xFF616161, 0xFF707070, 0xFF7D7D7D, 0xFF838383, 
        0xFF888788, 0xFF8C8A8B, 0xFF8F8D8E, 0xFF919090, 0xFF939192, 0xFF929090, 0xFFB3AFB0, 0xE0C9C7C7, 0x00FFFFFF,
  0x00FFFFFF, 0xED1B1A1A, 0xFF605E5E, 0xFFA6A4A5, 0xFF9D9B9C, 0xFF9D9B9C, 0xFF9C9A9B, 0xFF9B999A, 0xFF999798, 0xFF989697, 0xFF969495, 0xFF928F90, 0xFF8A8889, 0xFF6F6D6E, 0xFF737373, 0xFF9D9C9C, 0xFF7F7D7E, 0xFF908E8F, 0xFF979596, 0xFF9A9899, 0xFF9B999A, 
        0xFF9D9B9C, 0xFF9D9B9C, 0xFF9E9C9D, 0xFF9E9C9D, 0xFF9E9C9D, 0xFF9D9B9C, 0xFFB2ADAC, 0xEECBC7C7, 0x00FFFFFF,
  0x00FFFFFF, 0xEF2C2B2C, 0xFF686667, 0xFFA7A5A6, 0xFF9E9C9D, 0xFF9E9C9D, 0xFF9E9C9D, 0xFF9D9B9C, 0xFF9C9A9B, 0xFF9B999A, 0xFF999798, 0xFF969495, 0xFF8F8D8E, 0xFF7E7D7E, 0xFF9D9D9D, 0xFF727173, 0xFF6F6C6D, 0xFF8B898A, 0xFF918F90, 0xFF969495, 0xFF989697, 
        0xFF9A9899, 0xFF9A9899, 0xFF9C9A9B, 0xFF9D9B9C, 0xFF9D9C9D, 0xFF9D9A9B, 0xFFA9A5A4, 0xEFC0BCBC, 0x00FFFFFF,
  0x00FFFFFF, 0xDE444344, 0xFF646263, 0xFF999798, 0xFF939192, 0xFF918F90, 0xFF8F8D8E, 0xFF8D8B8C, 0xFF898788, 0xFF848283, 0xFF7C7B7C, 0xFF707070, 0xFF616161, 0xFF858585, 0xFFE5E5E5, 0xFF9C9A9B, 0xFF413F40, 0xFF464445, 0xFF626061, 0xFF716F70, 0xFF7A7879, 
        0xFF817F80, 0xFF858384, 0xFF888687, 0xFF8B898A, 0xFF8D8B8D, 0xFF8F8D8D, 0xFF9B9796, 0xE4B2AEAE, 0x00FFFFFF,
  0x00FFFFFF, 0xBF646364, 0xFF5D5B5C, 0xFF8B898A, 0xFF888788, 0xFF868485, 0xFF828182, 0xFF7D7C7D, 0xFF787777, 0xFF716F70, 0xFF626161, 0xFF5C5D5D, 0xFF7A7B7B, 0xFFC5C5C5, 0xFFF4F4F4, 0xFFB3B3B3, 0xFF676566, 0xFF383637, 0xFF393738, 0xFF504E4F, 0xFF5F5D5E, 
        0xFF696768, 0xFF716F70, 0xFF777576, 0xFF7C7A7B, 0xFF7F7D7E, 0xFF828081, 0xFF8C8888, 0xCFA9A6A6, 0x00FFFFFF,
  0x00FFFFFF, 0x86858485, 0xFF5E5C5D, 0xFF7B7B7B, 0xFF7D7D7D, 0xFF797979, 0xFF737374, 0xFF6D6D6D, 0xFF656565, 0xFF5C5C5C, 0xFF616161, 0xFF7D7D7D, 0xFFADADAD, 0xFFE6E6E6, 0xFFEEEEEE, 0xFFBBBBBB, 0xFF868485, 0xFF5B595A, 0xFF3A3839, 0xFF343233, 0xFF444243, 
        0xFF525051, 0xFF5C5A5B, 0xFF646263, 0xFF6B696A, 0xFF716F70, 0xFF747273, 0xFF787677, 0xAAA5A4A5, 0x00FFFFFF,
  0x00FFFFFF, 0x3E9F9D9E, 0xFF706E6F, 0xFF707070, 0xFF737373, 0xFF6D6D6D, 0xFF686868, 0xFF5E5E5E, 0xFF585858, 0xFF646464, 0xFF7F7F7F, 0xFF9F9F9F, 0xFFCCCCCC, 0xFFF6F6F6, 0xFFEAEAEA, 0xFFC0C0C0, 0xFF969495, 0xFF727071, 0xFF535152, 0xFF393738, 0xFF312F30, 
        0xFF3D3B3C, 0xFF4A4849, 0xFF545253, 0xFF5B595A, 0xFF636162, 0xFF646263, 0xFF6A6869, 0x76B4B3B4, 0x00FFFFFF,
  0x00FFFFFF, 0x04B1AFB0, 0xBE8F8C8D, 0xFF706F6F, 0xFF676767, 0xFF616161, 0xFF5B5B5B, 0xFF5C5C5C, 0xFF6A6A6A, 0xFF7F7F7F, 0xFF9B9B9B, 0xFFBABABA, 0xFFE2E2E2, 0xFFFCFCFC, 0xFFE5E5E5, 0xFFC4C4C4, 0xFFA19FA0, 0xFF828081, 0xFF666465, 0xFF4F4D4E, 0xFF3A3839, 
        0xFF302E2F, 0xFF373536, 0xFF434142, 0xFF4B494A, 0xFF535152, 0xFF5F5D5E, 0xEA7A7879, 0x1DCFCDCE, 0x00FFFFFF,
  0x00FFFFFF, 0x00BEBDBD, 0x4BAFAFAF, 0xFF828081, 0xFF646263, 0xFF575656, 0xFF5D5D5D, 0xFF6E6E6E, 0xFF808080, 0xFF959595, 0xFFAFAFAF, 0xFFCDCDCD, 0xFFF1F1F1, 0xFFFCFCFC, 0xFFE1E1E1, 0xFFC6C6C6, 0xFFA7A7A7, 0xFF8C8C8C, 0xFF737172, 0xFF5E5C5D, 0xFF4A4849, 
        0xFF3B393A, 0xFF302E2F, 0xFF343233, 0xFF3A3839, 0xFF585657, 0xFF7B797A, 0x86B0AEAF, 0x00D6D4D5, 0x00FFFFFF,
  0x00FFFFFF, 0x00BFBFBF, 0x03BFBFC0, 0xC19F9E9E, 0xFF7B797A, 0xFF626262, 0xFF6E6E6E, 0xFF808080, 0xFF929292, 0xFFA6A6A6, 0xFFC0C0C0, 0xFFDBDBDB, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFDEDEDE, 0xFFC7C7C7, 0xFFADADAD, 0xFF959495, 0xFF7E7C7D, 0xFF6B696A, 0xFF585657, 
        0xFF494748, 0xFF3B393A, 0xFF2B292A, 0xFF3A3839, 0xFF8B898A, 0xE2A2A0A1, 0x17CFCDCE, 0x00D0CECF, 0x00FFFFFF,
  0x00FFFFFF, 0x00C0C0C0, 0x00C1C1C1, 0x31BABABA, 0xF19A9A9A, 0xFF808080, 0xFF807E7F, 0xFF919191, 0xFFA3A3A3, 0xFFB7B7B7, 0xFFD0D0D0, 0xFFE8E8E8, 0xFFFFFFFF, 0xFFF5F5F5, 0xFFDDDDDD, 0xFFC9C9C9, 0xFFB2B2B2, 0xFF9C9C9D, 0xFF878587, 0xFF767475, 0xFF646263, 
        0xFF555354, 0xFF434041, 0xFF383536, 0xFF908F8F, 0xFFB9B8B8, 0x5EC6C6C6, 0x00D4D3D4, 0x00D1D1D1, 0x00FFFFFF,
  0x00FFFFFF, 0x00C3C3C3, 0x00C3C3C3, 0x00C5C5C5, 0x52B9B9B9, 0xF3989797, 0xFF898788, 0xFF9C9C9C, 0xFFB4B4B4, 0xFFC5C5C5, 0xFFDBDBDB, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFF2F2F2, 0xFFDCDCDC, 0xFFCACACA, 0xFFB5B5B5, 0xFFA2A2A2, 0xFF8F8D8E, 0xFF7D7B7C, 0xFF6C6A6B, 
        0xFF585657, 0xFF5C5B5C, 0xFFB0AEAF, 0xFFDBD9DA, 0x7FCACACA, 0x00D3D3D3, 0x00D3D3D3, 0x00D3D3D3, 0x00FFFFFF,
  0x00FFFFFF, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C6C6C6, 0x56BABABA, 0xF3999999, 0xFF8B8B8B, 0xFFABABAB, 0xFFD3D3D3, 0xFFEBEBEB, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFEFEFEF, 0xFFDCDCDC, 0xFFCBCBCB, 0xFFB8B8B8, 0xFFA8A8A8, 0xFF989697, 0xFF878586, 0xFF747273, 
        0xFF848383, 0xFFDFDFDF, 0xFFFDFDFD, 0x7FD4D4D4, 0x00D1D1D1, 0x00D3D3D3, 0x00D3D3D3, 0x00D3D3D3, 0x00FFFFFF,
  0x00FFFFFF, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C3C3C3, 0x00C6C6C6, 0x3EBBBBBB, 0xCA9C9C9C, 0xFF828282, 0xFF989898, 0xFFC7C7C7, 0xFFEFEEEE, 0xFFFEFDFE, 0xFFF5F5F5, 0xFFE6E6E6, 0xFFD8D8D8, 0xFFC4C4C4, 0xFFAEADAE, 0xFF939192, 0xFF7D7B7C, 0xFF878586, 
        0xFFBABABA, 0xDDE1E1E1, 0x5FD5D5D5, 0x00CDCDCD, 0x00D1D1D1, 0x00D3D3D3, 0x00D3D3D3, 0x00D3D3D3, 0x00FFFFFF,
  0x00FFFFFF, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C3C3C3, 0x00C4C4C4, 0x00C2C2C2, 0x0ABFBFBF, 0x68B5B5B5, 0xD58F8F8F, 0xFF717070, 0xFF6C6A6B, 0xFF817F80, 0xFF8C8A8B, 0xFF898889, 0xFF797979, 0xFF555555, 0xFF2E2D2E, 0xFF232323, 0xFF464646, 0xE7878787, 
        0x86BDBDBD, 0x19CCCCCC, 0x00C9C9C9, 0x00CECECE, 0x00D1D1D1, 0x00D3D3D3, 0x00D3D3D3, 0x00D3D3D3, 0x00FFFFFF,
  0x00FFFFFF, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C3C3C3, 0x00C4C4C4, 0x00C1C1C1, 0x00BDBDBD, 0x00C8C8C8, 0x11C4C4C4, 0x63AFAEAF, 0x9E919090, 0xC6717071, 0xDF565556, 0xED3E3E3E, 0xEF2F2F2F, 0xE3262626, 0xCE303030, 0xA85E5E5E, 0x759E9E9E, 0x1EC7C7C7, 
        0x00D0D0D0, 0x00CECECE, 0x00CACACA, 0x00CECECE, 0x00D1D1D1, 0x00D3D3D3, 0x00D3D3D3, 0x00D3D3D3, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF
};

GUI_CONST_STORAGE GUI_BITMAP bmknob_gray_trans_30x30 = {
  30, // xSize
  30, // ySize
  120, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acknob_gray_trans_30x30,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMPM8888I
};
#else
static GUI_CONST_STORAGE unsigned long _acknob_gray_trans_30x30[] = {
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFD1D1D1, 0xFFC0C0C0, 0xFFABABAB, 0xFF8E8E8F, 0xFF858585, 0xFF7C7C7C, 0xD189898A, 0x89949395, 0x4DA3A2A5, 0x28B0AFB3, 0x13BFBEC2, 0x10C6C5C9, 0x22BFBEC3, 0x42B9B8BB, 0x7AB5B5B6, 0xBFB4B3B5, 0xFEB5B4B6, 
        0xFFBABABA, 0xFFB9B9B9, 0xFFB8B8B8, 0xFFBFBFBF, 0xFFC3C3C3, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFD1D1D1, 0xFFC0C0C0, 0xFFABABAB, 0xFF8E8E8F, 0xCA7E7E7E, 0x5B6A6A6A, 0x09727273, 0x00858486, 0x009C9A9D, 0x00B0AFB2, 0x00C2C2C3, 0x00D1D0D1, 0x00D7D6D7, 0x00D1D0D2, 0x00BFBEC0, 0x01B1B0B2, 0x44ACABAD, 
        0xB1B4B3B4, 0xFDB9B9B9, 0xFFB9B9B9, 0xFFBFBFBF, 0xFFC3C3C3, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFD1D1D1, 0xFFC0C0C0, 0xE6A9A9A9, 0x5A8D8C8D, 0x08747475, 0x006B6A6B, 0x00807F81, 0x00969598, 0x00ABAAAB, 0x00BCBCBB, 0x00CDCDCD, 0x00DCDCDC, 0x00EEEEEE, 0x00FDFDFD, 0x00F9F9F9, 0x00DEDDDE, 0x00BEBEBE, 
        0x00ABAAAB, 0x42ABAAAB, 0xCBB5B5B5, 0xFFC0C0C0, 0xFFC3C3C3, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFD0D0D0, 0xD0C1C1C1, 0x2CAFAFAF, 0x008B8A8C, 0x006D6C6E, 0x00767577, 0x00868587, 0x00959496, 0x00A7A7A8, 0x00B8B8B8, 0x00CBCBCB, 0x00DCDCDC, 0x00EFEFEF, 0x00FFFFFF, 0x00FAFAFA, 0x00E7E7E7, 0x00D1D1D1, 
        0x00BAB9BB, 0x00A9A9AA, 0x12A7A7A7, 0xADB8B8B8, 0xFFC5C5C5, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFD5D5D5, 0xFFD5D5D5, 0xFFD4D4D4, 0xD0D5D5D5, 0x1FD2D2D2, 0x00919191, 0x00555556, 0x005B5A5C, 0x006B6A6C, 0x007D7C7E, 0x008D8C8F, 0x00A3A3A3, 0x00B5B5B5, 0x00CACACA, 0x00DCDCDC, 0x00F2F2F2, 0x00FFFFFF, 0x00F1F1F1, 0x00DADADA, 0x00C3C3C3, 
        0x00B1B1B1, 0x00A0A0A0, 0x009F9F9F, 0x0CA8A7A9, 0xA8B9B9B9, 0xFFC8C8C8, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFE5E5E5, 0xFFE5E5E5, 0xE7E9E9E9, 0x2AF7F7F7, 0x00A2A1A2, 0x00373737, 0x00434344, 0x00555356, 0x00636264, 0x00757476, 0x00878588, 0x009D9D9D, 0x00B2B2B2, 0x00C9C9C9, 0x00DDDDDD, 0x00F5F5F5, 0x00FFFFFF, 0x00E8E8E8, 0x00D0D0D0, 0x00B7B7B7, 
        0x00A3A3A3, 0x00919091, 0x00807F81, 0x00969597, 0x0AA9A9A9, 0xC4BDBDBD, 0xFFC7C7C7, 0xFFC5C5C5, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFCBCBCB, 0xFFCBCBCB, 0x5AF0F0F0, 0x00DBDBDB, 0x003C3B3D, 0x0029282A, 0x003A393B, 0x00484749, 0x00575658, 0x006A696B, 0x007D7C7E, 0x00959495, 0x00AEAEAE, 0x00C8C8C8, 0x00DEDEDE, 0x00F9F9F9, 0x00FAFAFA, 0x00DBDBDB, 0x00C1C1C1, 0x00A7A7A7, 
        0x00929292, 0x00808080, 0x006C6C6C, 0x00666666, 0x009A9A9A, 0x31B1B1B1, 0xF6C6C6C6, 0xFFC8C8C8, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFB4B4B4, 0xCDB4B4B4, 0x06CCCCCC, 0x006F6F70, 0x00343335, 0x00333234, 0x002F2E30, 0x003A393B, 0x0049484A, 0x005D5C5E, 0x00727174, 0x008C8B8C, 0x00A8A8A8, 0x00C6C6C6, 0x00E1E1E1, 0x00FCFCFC, 0x00F1F1F1, 0x00CDCDCD, 0x00B0B0B0, 0x00959595, 
        0x00808080, 0x006E6E6E, 0x005C5C5C, 0x00545454, 0x00727272, 0x00ABABAB, 0x99BFBFBF, 0xFFCCCCCC, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFE8D8D8D, 0x588D8D8D, 0x00878786, 0x004F4F4F, 0x004A494B, 0x00424143, 0x00353436, 0x002F2E30, 0x0039383A, 0x004E4D4F, 0x00656466, 0x00818081, 0x00A0A0A0, 0x00C4C4C4, 0x00E5E5E5, 0x00FBFBFB, 0x00E2E2E2, 0x00BABABA, 0x009B9B9B, 0x007F7F7F, 
        0x006B6B6B, 0x005C5C5C, 0x005A5A5A, 0x00616161, 0x00656565, 0x00979797, 0x26B5B5B5, 0xEEC7C7C7, 0xFFFFFFFF,
  0xFFFFFFFF, 0xD2666666, 0x065A5A5A, 0x00666667, 0x00606061, 0x005A595B, 0x00525153, 0x00484749, 0x003B3A3C, 0x00302F31, 0x00373638, 0x00525153, 0x00717072, 0x00959495, 0x00C1C1C1, 0x00E9E9E9, 0x00F6F6F6, 0x00CCCCCC, 0x009F9F9F, 0x007F7F7F, 0x00636363, 
        0x00585858, 0x005F5F5F, 0x00686868, 0x006D6D6D, 0x006F6F6F, 0x00878788, 0x00B3B3B5, 0x9CC2C1C2, 0xFFFFFFFF,
  0xFFFFFFFF, 0x88363636, 0x00363636, 0x00717071, 0x00706F72, 0x006A696B, 0x00636264, 0x005B5A5C, 0x00515052, 0x00424143, 0x00323133, 0x003A393B, 0x005B5A5C, 0x00858486, 0x00BBBBBB, 0x00EEEEEE, 0x00E6E6E6, 0x00ADADAD, 0x007E7E7E, 0x00616161, 0x005C5C5C, 
        0x00656565, 0x006D6D6D, 0x00747474, 0x00797878, 0x007B7A7C, 0x00848386, 0x00B4B3B8, 0x5EC0BFC2, 0xFFFFFFFF,
  0xFFFFFFFF, 0x4A0D0D0D, 0x002C2C2C, 0x00848384, 0x00807F81, 0x007B7A7C, 0x00767577, 0x00706F71, 0x00686769, 0x005E5D5F, 0x004F4E50, 0x0039383A, 0x00373638, 0x00676668, 0x00B3B3B3, 0x00F4F4F4, 0x00C4C4C4, 0x007A7A7A, 0x005D5D5D, 0x00616161, 0x00707070, 
        0x00777778, 0x007C7C7D, 0x00818082, 0x00858485, 0x00878688, 0x0089888A, 0x00B1B0B3, 0x37C3C2C5, 0xFFFFFFFF,
  0xFFFFFFFF, 0x26080808, 0x00424242, 0x00969597, 0x008D8C8E, 0x008A898B, 0x00878688, 0x00848385, 0x00807F81, 0x0079787A, 0x00706F71, 0x00616062, 0x00444345, 0x00403F41, 0x009B9B9B, 0x00E5E5E5, 0x00848485, 0x00616161, 0x00707070, 0x007D7D7D, 0x00838383, 
        0x00888788, 0x008B8A8C, 0x008E8D8F, 0x00909091, 0x00929193, 0x00909092, 0x00B0AFB3, 0x1FC7C7C9, 0xFFFFFFFF,
  0xFFFFFFFF, 0x121A1A1B, 0x005E5E60, 0x00A5A4A6, 0x009C9B9D, 0x009C9B9D, 0x009B9A9C, 0x009A999B, 0x00989799, 0x00979698, 0x00959496, 0x00908F92, 0x0089888A, 0x006E6D6F, 0x00737373, 0x009C9C9D, 0x007E7D7F, 0x008F8E90, 0x00969597, 0x0099989A, 0x009A999B, 
        0x009C9B9D, 0x009C9B9D, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009C9B9D, 0x00ACADB2, 0x11C7C7CB, 0xFFFFFFFF,
  0xFFFFFFFF, 0x102C2B2C, 0x00676668, 0x00A6A5A7, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009C9B9D, 0x009B9A9C, 0x009A999B, 0x00989799, 0x00959496, 0x008E8D8F, 0x007E7D7E, 0x009D9D9D, 0x00737172, 0x006D6C6F, 0x008A898B, 0x00908F91, 0x00959496, 0x00979698, 
        0x0099989A, 0x0099989A, 0x009B9A9C, 0x009C9B9D, 0x009D9C9D, 0x009B9A9D, 0x00A4A5A9, 0x10BCBCC0, 0xFFFFFFFF,
  0xFFFFFFFF, 0x21444344, 0x00636264, 0x00989799, 0x00929193, 0x00908F91, 0x008E8D8F, 0x008C8B8D, 0x00888789, 0x00838284, 0x007C7B7C, 0x00707070, 0x00616161, 0x00858585, 0x00E5E5E5, 0x009B9A9C, 0x00403F41, 0x00454446, 0x00616062, 0x00706F71, 0x0079787A, 
        0x00807F81, 0x00848385, 0x00878688, 0x008A898B, 0x008D8B8D, 0x008D8D8F, 0x0096979B, 0x1BAEAEB2, 0xFFFFFFFF,
  0xFFFFFFFF, 0x40646364, 0x005C5B5D, 0x008A898B, 0x00888788, 0x00858486, 0x00828182, 0x007D7C7D, 0x00777778, 0x00706F71, 0x00616162, 0x005D5D5C, 0x007B7B7A, 0x00C5C5C5, 0x00F4F4F4, 0x00B3B3B3, 0x00666567, 0x00373638, 0x00383739, 0x004F4E50, 0x005E5D5F, 
        0x00686769, 0x00706F71, 0x00767577, 0x007B7A7C, 0x007E7D7F, 0x00818082, 0x0088888C, 0x30A6A6A9, 0xFFFFFFFF,
  0xFFFFFFFF, 0x79858485, 0x005D5C5E, 0x007B7B7B, 0x007D7D7D, 0x00797979, 0x00747373, 0x006D6D6D, 0x00656565, 0x005C5C5C, 0x00616161, 0x007D7D7D, 0x00ADADAD, 0x00E6E6E6, 0x00EEEEEE, 0x00BBBBBB, 0x00858486, 0x005A595B, 0x0039383A, 0x00333234, 0x00434244, 
        0x00515052, 0x005B5A5C, 0x00636264, 0x006A696B, 0x00706F71, 0x00737274, 0x00777678, 0x55A5A4A5, 0xFFFFFFFF,
  0xFFFFFFFF, 0xC19E9D9F, 0x006F6E70, 0x00707070, 0x00737373, 0x006D6D6D, 0x00686868, 0x005E5E5E, 0x00585858, 0x00646464, 0x007F7F7F, 0x009F9F9F, 0x00CCCCCC, 0x00F6F6F6, 0x00EAEAEA, 0x00C0C0C0, 0x00959496, 0x00717072, 0x00525153, 0x00383739, 0x00302F31, 
        0x003C3B3D, 0x0049484A, 0x00535254, 0x005A595B, 0x00626163, 0x00636264, 0x0069686A, 0x89B4B3B4, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFBB0AFB1, 0x418D8C8F, 0x006F6F70, 0x00676767, 0x00616161, 0x005B5B5B, 0x005C5C5C, 0x006A6A6A, 0x007F7F7F, 0x009B9B9B, 0x00BABABA, 0x00E2E2E2, 0x00FCFCFC, 0x00E5E5E5, 0x00C4C4C4, 0x00A09FA1, 0x00818082, 0x00656466, 0x004E4D4F, 0x0039383A, 
        0x002F2E30, 0x00363537, 0x00424143, 0x004A494B, 0x00525153, 0x005E5D5F, 0x1579787A, 0xE2CECDCF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFBDBDBE, 0xB4AFAFAF, 0x00818082, 0x00636264, 0x00565657, 0x005D5D5D, 0x006E6E6E, 0x00808080, 0x00959595, 0x00AFAFAF, 0x00CDCDCD, 0x00F1F1F1, 0x00FCFCFC, 0x00E1E1E1, 0x00C6C6C6, 0x00A7A7A7, 0x008C8C8C, 0x00727173, 0x005D5C5E, 0x0049484A, 
        0x003A393B, 0x002F2E30, 0x00333234, 0x0039383A, 0x00575658, 0x007A797B, 0x79AFAEB0, 0xFFD5D4D6, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFBFBFBF, 0xFCC0BFBF, 0x3E9E9E9F, 0x007A797B, 0x00626262, 0x006E6E6E, 0x00808080, 0x00929292, 0x00A6A6A6, 0x00C0C0C0, 0x00DBDBDB, 0x00FAFAFA, 0x00F9F9F9, 0x00DEDEDE, 0x00C7C7C7, 0x00ADADAD, 0x00959495, 0x007D7C7E, 0x006A696B, 0x00575658, 
        0x00484749, 0x003A393B, 0x002A292B, 0x0039383A, 0x008A898B, 0x1DA1A0A2, 0xE8CECDCF, 0xFFCFCED0, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFC0C0C0, 0xFFC1C1C1, 0xCEBABABA, 0x0E9A9A9A, 0x00808080, 0x007F7E80, 0x00919191, 0x00A3A3A3, 0x00B7B7B7, 0x00D0D0D0, 0x00E8E8E8, 0x00FFFFFF, 0x00F5F5F5, 0x00DDDDDD, 0x00C9C9C9, 0x00B2B2B2, 0x009D9C9C, 0x00878587, 0x00757476, 0x00636264, 
        0x00545355, 0x00414043, 0x00363538, 0x008F8F90, 0x00B8B8B9, 0xA1C6C6C6, 0xFFD4D3D4, 0xFFD1D1D1, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC5C5C5, 0xADB9B9B9, 0x0C979798, 0x00888789, 0x009C9C9C, 0x00B4B4B4, 0x00C5C5C5, 0x00DBDBDB, 0x00F2F2F2, 0x00FFFFFF, 0x00F2F2F2, 0x00DCDCDC, 0x00CACACA, 0x00B5B5B5, 0x00A2A2A2, 0x008E8D8F, 0x007C7B7D, 0x006B6A6C, 
        0x00575658, 0x005C5B5C, 0x00AFAEB0, 0x00DAD9DB, 0x80CACACA, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC6C6C6, 0xA9BABABA, 0x0C999999, 0x008B8B8B, 0x00ABABAB, 0x00D3D3D3, 0x00EBEBEB, 0x00FCFCFC, 0x00FFFFFF, 0x00EFEFEF, 0x00DCDCDC, 0x00CBCBCB, 0x00B8B8B8, 0x00A8A8A8, 0x00979698, 0x00868587, 0x00737274, 
        0x00838384, 0x00DFDFDF, 0x00FDFDFD, 0x80D4D4D4, 0xFFD1D1D1, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC3C3C3, 0xFFC6C6C6, 0xC1BBBBBB, 0x359C9C9C, 0x00828282, 0x00989898, 0x00C7C7C7, 0x00EEEEEF, 0x00FEFDFE, 0x00F5F5F5, 0x00E6E6E6, 0x00D8D8D8, 0x00C4C4C4, 0x00AEADAE, 0x00929193, 0x007C7B7D, 0x00868587, 
        0x00BABABA, 0x22E1E1E1, 0xA0D5D5D5, 0xFFCDCDCD, 0xFFD1D1D1, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC3C3C3, 0xFFC4C4C4, 0xFFC2C2C2, 0xF5BFBFBF, 0x97B5B5B5, 0x2A8F8F8F, 0x00707071, 0x006B6A6C, 0x00807F81, 0x008B8A8C, 0x00898889, 0x00797979, 0x00555555, 0x002E2D2E, 0x00232323, 0x00464646, 0x18878787, 
        0x79BDBDBD, 0xE6CCCCCC, 0xFFC9C9C9, 0xFFCECECE, 0xFFD1D1D1, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC3C3C3, 0xFFC4C4C4, 0xFFC1C1C1, 0xFFBDBDBD, 0xFFC8C8C8, 0xEEC4C4C4, 0x9CAFAEAF, 0x61909091, 0x39717071, 0x20565556, 0x123E3E3E, 0x102F2F2F, 0x1C262626, 0x31303030, 0x575E5E5E, 0x8A9E9E9E, 0xE1C7C7C7, 
        0xFFD0D0D0, 0xFFCECECE, 0xFFCACACA, 0xFFCECECE, 0xFFD1D1D1, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
};

GUI_CONST_STORAGE GUI_BITMAP bmknob_gray_trans_30x30 = {
  30, // xSize
  30, // ySize
  120, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acknob_gray_trans_30x30,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMP8888
};
#endif

/*********************************************************************
*
*       Button 30x30 pressed
*/
#if (GUI_USE_ARGB)
static GUI_CONST_STORAGE unsigned long _acknob_black_trans_30x30[] = {
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x002F2F2F, 0x002F2F2F, 0x002F2F2F, 0x002E2E2E, 0x00343434, 0x00383838, 0x00333333, 0x00393939, 0x00333333, 0x2D3A3A3A, 0x7A4D4E4D, 0xB14D504F, 0xD8474B4A, 0xEC3C403F, 0xEE383B3A, 0xDD3C403F, 0xBA404242, 0x85404141, 0x3A383A39, 0x01343635, 
        0x003A3A3A, 0x00373737, 0x00353535, 0x00343434, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x00FFFFFF,
  0x00FFFFFF, 0x002F2F2F, 0x002F2F2F, 0x002F2F2F, 0x002E2E2E, 0x00343434, 0x00373737, 0x02313131, 0x484D4C4C, 0xAE727172, 0xF5848585, 0xFF7A7D7B, 0xFF666968, 0xFF515453, 0xFF414342, 0xFF313332, 0xFF2E2F2F, 0xFF343635, 0xFF414342, 0xFC4E504F, 0xBD4A4C4B, 
        0x57424242, 0x0C363636, 0x00343434, 0x00343434, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x00FFFFFF,
  0x00FFFFFF, 0x002F2F2F, 0x002F2F2F, 0x002F2F2F, 0x002E2E2E, 0x00333333, 0x1B393939, 0xB55A5B5A, 0xFF888988, 0xFF9FA0A0, 0xFF898B8A, 0xFF696B6A, 0xFF575857, 0xFF464646, 0xFF363636, 0xFF252525, 0xFF161516, 0xFF040504, 0xFF070707, 0xFF262727, 0xFF484948, 
        0xFF575858, 0xC74F504F, 0x2B383838, 0x00333333, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x00FFFFFF,
  0x00FFFFFF, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x38363636, 0xCC4B4B4B, 0xFF6F7270, 0xFF8B8D8C, 0xFF8B8D8C, 0xFF797B7A, 0xFF696B6A, 0xFF5A5B5A, 0xFF484848, 0xFF373737, 0xFF242424, 0xFF131313, 0xFF010101, 0xFF030303, 0xFF161616, 0xFF2E2E2E, 
        0xFF494A49, 0xFF585958, 0xE5555555, 0x533E3E3E, 0x002B2B2B, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x00FFFFFF,
  0x00FFFFFF, 0x00353535, 0x00353535, 0x00363636, 0x36343434, 0xF22E2E2E, 0xFF525252, 0xFFA1A2A2, 0xFFA4A6A5, 0xFF939594, 0xFF838584, 0xFF707271, 0xFF5F605F, 0xFF4B4B4B, 0xFF383838, 0xFF242424, 0xFF101010, 0xFF000000, 0xFF0A0A0A, 0xFF232323, 0xFF383838, 
        0xFF4C4D4C, 0xFF5D5D5D, 0xFF5D5D5D, 0xF9555756, 0x4F3B3B3B, 0x002E2E2E, 0x002F2F2F, 0x002F2F2F, 0x00FFFFFF,
  0x00FFFFFF, 0x00363636, 0x00363636, 0x1B363636, 0xCE191919, 0xFF383838, 0xFFA8A8A8, 0xFFBFC0C0, 0xFFABADAC, 0xFF9B9D9C, 0xFF8B8D8C, 0xFF787A79, 0xFF646565, 0xFF4E4E4E, 0xFF3A3A3A, 0xFF232323, 0xFF0D0D0D, 0xFF000000, 0xFF131313, 0xFF2D2D2D, 0xFF444444, 
        0xFF5B5B5B, 0xFF6D6D6D, 0xFF797A7A, 0xFF646665, 0xEE565656, 0x3B3A3A3A, 0x00303030, 0x00313131, 0x00FFFFFF,
  0x00FFFFFF, 0x00313131, 0x04333333, 0xB71B1A1A, 0xFF0C0C0C, 0xFFADAFAE, 0xFFDBDCDB, 0xFFC5C7C6, 0xFFB6B8B7, 0xFFA7A9A8, 0xFF969897, 0xFF818482, 0xFF6C6E6D, 0xFF535353, 0xFF3C3C3C, 0xFF222222, 0xFF090909, 0xFF050505, 0xFF202020, 0xFF3C3C3C, 0xFF545454, 
        0xFF6B6B6B, 0xFF7D7D7D, 0xFF919191, 0xFF949494, 0xFF5F5F5F, 0xCE4D4D4D, 0x05313131, 0x00313131, 0x00FFFFFF,
  0x00FFFFFF, 0x00333333, 0x463A3A3A, 0xFF2C2C2C, 0xFF636464, 0xFFCACCCB, 0xFFCCCECD, 0xFFD0D2D1, 0xFFC4C6C5, 0xFFB4B6B5, 0xFFA2A4A3, 0xFF8C8E8D, 0xFF757775, 0xFF595A59, 0xFF3E3E3E, 0xFF202020, 0xFF060606, 0xFF0D0D0D, 0xFF2D2D2D, 0xFF4D4D4D, 0xFF656565, 
        0xFF7D7D7D, 0xFF8E8E8E, 0xFFA0A0A0, 0xFFABABAB, 0xFF868686, 0xFF535353, 0x643F3F3F, 0x00343434, 0x00FFFFFF,
  0x00FFFFFF, 0x002E2E2E, 0xB1575757, 0xFF6C6C6C, 0xFFA8A9A8, 0xFFB6B8B7, 0xFFBCBEBD, 0xFFC9CBCA, 0xFFD0D2D1, 0xFFC6C8C7, 0xFFB2B4B3, 0xFF9A9C9B, 0xFF818382, 0xFF626262, 0xFF414141, 0xFF1C1C1C, 0xFF040404, 0xFF1C1C1C, 0xFF404040, 0xFF636363, 0xFF7C7C7C, 
        0xFF949494, 0xFFA4A4A4, 0xFFA7A7A7, 0xFFA0A0A0, 0xFF9C9C9C, 0xFF686868, 0xE34B4A4A, 0x11343333, 0x00FFFFFF,
  0x00FFFFFF, 0x2B3D3D3D, 0xF6959595, 0xFF959595, 0xFFA1A2A1, 0xFFA5A7A6, 0xFFADAFAE, 0xFFB7B9B8, 0xFFC4C6C5, 0xFFCFD1D0, 0xFFC6C8C7, 0xFFACAEAD, 0xFF909191, 0xFF6C6D6C, 0xFF454545, 0xFF181818, 0xFF060606, 0xFF2F2F2F, 0xFF585858, 0xFF7C7C7C, 0xFF969696, 
        0xFFA5A5A5, 0xFFA3A3A3, 0xFF9B9B9B, 0xFF959595, 0xFF929393, 0xFF777777, 0xFF4C4D4D, 0x613A3A3A, 0x00FFFFFF,
  0x00FFFFFF, 0x7C737373, 0xFFD1D1D1, 0xFF919291, 0xFF8E9190, 0xFF959796, 0xFF9C9E9D, 0xFFA4A6A5, 0xFFAEB0AF, 0xFFBDBFBE, 0xFFCCCECD, 0xFFC7C9C8, 0xFFA7A9A8, 0xFF7C7E7D, 0xFF4C4D4C, 0xFF111111, 0xFF111111, 0xFF4E4E4E, 0xFF7B7B7B, 0xFF9E9E9E, 0xFFA6A6A6, 
        0xFF9C9C9C, 0xFF939393, 0xFF8E8D8D, 0xFF888888, 0xFF858786, 0xFF7A7D7C, 0xFF484C4B, 0xA43F4140, 0x00FFFFFF,
  0x00FFFFFF, 0xB2ABABAB, 0xFFE7E7E7, 0xFF808180, 0xFF808281, 0xFF858786, 0xFF8A8C8B, 0xFF909291, 0xFF989A99, 0xFFA4A6A5, 0xFFB3B5B4, 0xFFC8CAC9, 0xFFC4C6C5, 0xFF989A99, 0xFF575757, 0xFF0C0C0C, 0xFF2D2D2D, 0xFF7C7C7C, 0xFF9D9D9D, 0xFFA1A1A1, 0xFF959595, 
        0xFF8A8B8B, 0xFF848585, 0xFF808180, 0xFF7D7D7D, 0xFF7A7B7A, 0xFF767877, 0xFF4C504F, 0xC73C3E3D, 0x00FFFFFF,
  0x00FFFFFF, 0xDACACACA, 0xFFD7D7D7, 0xFF6F7070, 0xFF717472, 0xFF757776, 0xFF787A79, 0xFF7C7E7D, 0xFF808281, 0xFF878988, 0xFF909291, 0xFFA0A2A1, 0xFFBABCBB, 0xFFC6C8C7, 0xFF737373, 0xFF151515, 0xFF717171, 0xFFA2A2A2, 0xFF949494, 0xFF868686, 0xFF7E7E7E, 
        0xFF797A7A, 0xFF747775, 0xFF717372, 0xFF707171, 0xFF6E6F6E, 0xFF6E706F, 0xFF4C504F, 0xE1373938, 0x00FFFFFF,
  0x00FFFFFF, 0xEBC8C9C9, 0xFFBBBDBC, 0xFF606261, 0xFF636564, 0xFF656766, 0xFF666867, 0xFF676968, 0xFF696B6A, 0xFF6C6E6D, 0xFF6F7170, 0xFF747675, 0xFF7E807F, 0xFF9C9E9D, 0xFF8F8F8F, 0xFF575757, 0xFF868887, 0xFF797B7A, 0xFF6F7170, 0xFF6A6C6B, 0xFF686969, 
        0xFF676968, 0xFF656766, 0xFF646665, 0xFF646565, 0xFF626463, 0xFF646666, 0xFF4E5253, 0xED343737, 0x00FFFFFF,
  0x00FFFFFF, 0xEEB9B9B9, 0xFFACAEAD, 0xFF5D5F5E, 0xFF606261, 0xFF616362, 0xFF616362, 0xFF626463, 0xFF636564, 0xFF646665, 0xFF666867, 0xFF696A69, 0xFF6E706F, 0xFF818382, 0xFF707070, 0xFF909191, 0xFF959897, 0xFF747675, 0xFF6E706F, 0xFF6A6D6B, 0xFF686A69, 
        0xFF656766, 0xFF646665, 0xFF646665, 0xFF636564, 0xFF626463, 0xFF636565, 0xFF575B5D, 0xEE3F4343, 0x00FFFFFF,
  0x00FFFFFF, 0xDE9E9E9E, 0xFFA9ABAA, 0xFF686A69, 0xFF6A6C6B, 0xFF6D6F6E, 0xFF6E716F, 0xFF707271, 0xFF737674, 0xFF797B7A, 0xFF7F807F, 0xFF8B8B8B, 0xFF999999, 0xFF8A8A8A, 0xFF2F2F2F, 0xFF666766, 0xFFBEC0BF, 0xFFB6B8B7, 0xFF9B9D9C, 0xFF8C8E8D, 0xFF848685, 
        0xFF7D7F7E, 0xFF787A79, 0xFF767877, 0xFF727473, 0xFF707271, 0xFF6F7172, 0xFF636869, 0xE44C5050, 0x00FFFFFF,
  0x00FFFFFF, 0xBB7A7B7B, 0xFFA9ABAA, 0xFF767877, 0xFF767877, 0xFF797B7A, 0xFF7D7E7E, 0xFF828382, 0xFF868786, 0xFF8E8F8F, 0xFF9B9C9C, 0xFFA5A5A5, 0xFF8B8B8B, 0xFF434343, 0xFF0E0E0E, 0xFF4B4B4B, 0xFF939594, 0xFFC8CAC9, 0xFFC8CAC9, 0xFFB1B3B2, 0xFFA1A3A2, 
        0xFF969897, 0xFF8E908F, 0xFF898B8A, 0xFF848685, 0xFF808281, 0xFF7D7F7F, 0xFF747778, 0xCD575A5A, 0x00FFFFFF,
  0x00FFFFFF, 0x865A5B5A, 0xFFA1A3A2, 0xFF848584, 0xFF818181, 0xFF858585, 0xFF8A8A8A, 0xFF909090, 0xFF979797, 0xFFA2A2A2, 0xFFA2A2A2, 0xFF898989, 0xFF5D5D5D, 0xFF1E1E1E, 0xFF0C0C0C, 0xFF454545, 0xFF787A79, 0xFFA7A9A8, 0xFFC5C7C6, 0xFFCBCDCC, 0xFFBBBDBC, 
        0xFFACAEAD, 0xFFA2A4A3, 0xFF9A9C9B, 0xFF939594, 0xFF8E908F, 0xFF8A8C8B, 0xFF858786, 0xAA5C5D5C, 0x00FFFFFF,
  0x00FFFFFF, 0x38373837, 0xFE888A89, 0xFF929392, 0xFF8C8C8C, 0xFF919191, 0xFF979797, 0xFFA0A0A0, 0xFFA7A7A7, 0xFF9E9E9E, 0xFF868686, 0xFF636363, 0xFF3C3C3C, 0xFF090909, 0xFF101010, 0xFF3F3F3F, 0xFF676968, 0xFF8D8F8E, 0xFFABADAC, 0xFFC7C9C8, 0xFFCFD1D0, 
        0xFFC3C5C4, 0xFFB6B8B7, 0xFFACAEAD, 0xFFA4A6A5, 0xFF9EA09F, 0xFF9C9E9D, 0xFF969897, 0x704C4D4C, 0x00FFFFFF,
  0x00FFFFFF, 0x042C2E2D, 0xBF626463, 0xFF919291, 0xFF979797, 0xFF9C9C9C, 0xFFA3A3A3, 0xFFA6A6A6, 0xFF9B9B9B, 0xFF848484, 0xFF6B6B6B, 0xFF4A4A4A, 0xFF252525, 0xFF020202, 0xFF161515, 0xFF3C3C3C, 0xFF5C5E5D, 0xFF7F8180, 0xFF999B9A, 0xFFB2B4B3, 0xFFC6C8C7, 
        0xFFD0D2D1, 0xFFC7C9C8, 0xFFBBBDBC, 0xFFB2B4B3, 0xFFACAEAD, 0xFFA1A3A2, 0xEB8A8C8B, 0x1E323433, 0x00FFFFFF,
  0x00FFFFFF, 0x00303030, 0x55414242, 0xFF7A7B7A, 0xFF969796, 0xFFA9AAA9, 0xFFA5A4A5, 0xFF969595, 0xFF838383, 0xFF6D6D6D, 0xFF545454, 0xFF353535, 0xFF151515, 0xFF010101, 0xFF1A1A1A, 0xFF393939, 0xFF565656, 0xFF737474, 0xFF8A8C8B, 0xFFA2A4A3, 0xFFB4B6B5, 
        0xFFC5C7C6, 0xFFD0D2D1, 0xFFCCCECD, 0xFFC6C8C7, 0xFFA8AAA9, 0xFF858786, 0x7B515352, 0x002B2D2C, 0x00FFFFFF,
  0x00FFFFFF, 0x00313030, 0x0D303030, 0xCA575858, 0xFF808281, 0xFF9D9E9D, 0xFF949394, 0xFF828282, 0xFF717171, 0xFF5B5B5B, 0xFF434343, 0xFF262626, 0xFF0A0A0A, 0xFF040404, 0xFF1D1D1D, 0xFF383838, 0xFF515051, 0xFF6A6A6A, 0xFF7F8180, 0xFF959796, 0xFFA6A8A7, 
        0xFFB6B8B7, 0xFFC5C7C6, 0xFFD5D7D6, 0xFFC6C8C7, 0xFF757676, 0xDC5D5F5E, 0x112F3130, 0x002E302F, 0x00FFFFFF,
  0x00FFFFFF, 0x00303030, 0x002E2E2E, 0x29333333, 0xE85E5E5E, 0xFF7E7E7E, 0xFF818382, 0xFF717271, 0xFF606060, 0xFF4A4A4A, 0xFF343434, 0xFF191919, 0xFF040404, 0xFF090909, 0xFF1F1F1F, 0xFF363636, 0xFF4C4C4C, 0xFF626363, 0xFF767877, 0xFF8A8C8B, 0xFF9A9C9B, 
        0xFFAAACAB, 0xFFBDBFBE, 0xFFC8CAC9, 0xFF6F7170, 0xFF474747, 0x523B3C3C, 0x002E2F2F, 0x00303130, 0x00FFFFFF,
  0x00FFFFFF, 0x002E2E2E, 0x002E2E2E, 0x002C2C2C, 0x523B3B3B, 0xF8636464, 0xFF757776, 0xFF686868, 0xFF4F4F4F, 0xFF3C3C3C, 0xFF292929, 0xFF0F0F0F, 0xFF010101, 0xFF0D0D0D, 0xFF202020, 0xFF363636, 0xFF494949, 0xFF5D5E5D, 0xFF6F7170, 0xFF828483, 0xFF919392, 
        0xFFA8A9A9, 0xFFA3A5A4, 0xFF505251, 0xFD252625, 0x73373737, 0x00313031, 0x00313131, 0x00313131, 0x00FFFFFF,
  0x00FFFFFF, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x503A3B3B, 0xED616161, 0xFF787878, 0xFF5C5C5C, 0xFF2F2F2F, 0xFF171717, 0xFF040404, 0xFF000000, 0xFF101010, 0xFF222222, 0xFF343535, 0xFF464646, 0xFF575858, 0xFF676968, 0xFF797B7A, 0xFF8B8D8B, 
        0xFF7C7D7D, 0xFF212121, 0xFE020202, 0x732B2B2B, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00FFFFFF,
  0x00FFFFFF, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00323232, 0x3D3B3B3B, 0xC95B5B5B, 0xFF797979, 0xFF6B6B6B, 0xFF3F3F3F, 0xFF111212, 0xFF020302, 0xFF090909, 0xFF171717, 0xFF282727, 0xFF3A3A3A, 0xFF525252, 0xFF6A6B6B, 0xFF838483, 0xFF7C7D7C, 
        0xFF454646, 0xD71E1E1E, 0x552B2B2B, 0x00353535, 0x00303030, 0x00313131, 0x00313131, 0x00313131, 0x00FFFFFF,
  0x00FFFFFF, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00353535, 0x00353535, 0x07313131, 0x64474747, 0xDE6E6E6E, 0xFF8C8D8C, 0xFF959897, 0xFF838584, 0xFF747675, 0xFF767776, 0xFF878686, 0xFFA7A7A7, 0xFFD2D2D2, 0xFFDEDEDE, 0xFFBBBBBB, 0xE780807F, 
        0x7B474747, 0x13373737, 0x00383838, 0x00343434, 0x00303030, 0x00313131, 0x00313131, 0x00313131, 0x00FFFFFF,
  0x00FFFFFF, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00353535, 0x00363636, 0x00333333, 0x00393939, 0x14353535, 0x60464747, 0xA16B6C6B, 0xC5888989, 0xE0A9AAA9, 0xEDBEBFBE, 0xEED1D1D1, 0xE3DADADA, 0xCCD0D0D0, 0xA8AAAAAA, 0x70626262, 0x1F393939, 
        0x00393939, 0x00363636, 0x00363636, 0x00343434, 0x00303030, 0x00313131, 0x00313131, 0x00313131, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF
};

GUI_CONST_STORAGE GUI_BITMAP bmknob_black_trans_30x30 = {
  30, // xSize
  30, // ySize
  120, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acknob_black_trans_30x30,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMPM8888I
};
#else
static GUI_CONST_STORAGE unsigned long _acknob_black_trans_30x30[] = {
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF2F2F2F, 0xFF2F2F2F, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF343434, 0xFF383838, 0xFF333333, 0xFF393939, 0xFF333333, 0xD23A3A3A, 0x854D4E4D, 0x4E4F504D, 0x274A4B47, 0x133F403C, 0x113A3B38, 0x223F403C, 0x45424240, 0x7A414140, 0xC5393A38, 0xFE353634, 
        0xFF3A3A3A, 0xFF373737, 0xFF353535, 0xFF343434, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF2F2F2F, 0xFF2F2F2F, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF343434, 0xFF373737, 0xFD313131, 0xB74C4C4D, 0x51727172, 0x0A858584, 0x007B7D7A, 0x00686966, 0x00535451, 0x00424341, 0x00323331, 0x002F2F2E, 0x00353634, 0x00424341, 0x034F504E, 0x424B4C4A, 
        0xA8424242, 0xF3363636, 0xFF343434, 0xFF343434, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF2F2F2F, 0xFF2F2F2F, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF333333, 0xE4393939, 0x4A5A5B5A, 0x00888988, 0x00A0A09F, 0x008A8B89, 0x006A6B69, 0x00575857, 0x00464646, 0x00363636, 0x00252525, 0x00161516, 0x00040504, 0x00070707, 0x00272726, 0x00484948, 
        0x00585857, 0x384F504F, 0xD4383838, 0xFF333333, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xC7363636, 0x334B4B4B, 0x0070726F, 0x008C8D8B, 0x008C8D8B, 0x007A7B79, 0x006A6B69, 0x005A5B5A, 0x00484848, 0x00373737, 0x00242424, 0x00131313, 0x00010101, 0x00030303, 0x00161616, 0x002E2E2E, 
        0x00494A49, 0x00585958, 0x1A555555, 0xAC3E3E3E, 0xFF2B2B2B, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF353535, 0xFF353535, 0xFF363636, 0xC9343434, 0x0D2E2E2E, 0x00525252, 0x00A2A2A1, 0x00A5A6A4, 0x00949593, 0x00848583, 0x00717270, 0x005F605F, 0x004B4B4B, 0x00383838, 0x00242424, 0x00101010, 0x00000000, 0x000A0A0A, 0x00232323, 0x00383838, 
        0x004C4D4C, 0x005D5D5D, 0x005D5D5D, 0x06565755, 0xB03B3B3B, 0xFF2E2E2E, 0xFF2F2F2F, 0xFF2F2F2F, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF363636, 0xFF363636, 0xE4363636, 0x31191919, 0x00383838, 0x00A8A8A8, 0x00C0C0BF, 0x00ACADAB, 0x009C9D9B, 0x008C8D8B, 0x00797A78, 0x00656564, 0x004E4E4E, 0x003A3A3A, 0x00232323, 0x000D0D0D, 0x00000000, 0x00131313, 0x002D2D2D, 0x00444444, 
        0x005B5B5B, 0x006D6D6D, 0x007A7A79, 0x00656664, 0x11565656, 0xC43A3A3A, 0xFF303030, 0xFF313131, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF313131, 0xFB333333, 0x481A1A1B, 0x000C0C0C, 0x00AEAFAD, 0x00DBDCDB, 0x00C6C7C5, 0x00B7B8B6, 0x00A8A9A7, 0x00979896, 0x00828481, 0x006D6E6C, 0x00535353, 0x003C3C3C, 0x00222222, 0x00090909, 0x00050505, 0x00202020, 0x003C3C3C, 0x00545454, 
        0x006B6B6B, 0x007D7D7D, 0x00919191, 0x00949494, 0x005F5F5F, 0x314D4D4D, 0xFA313131, 0xFF313131, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF333333, 0xB93A3A3A, 0x002C2C2C, 0x00646463, 0x00CBCCCA, 0x00CDCECC, 0x00D1D2D0, 0x00C5C6C4, 0x00B5B6B4, 0x00A3A4A2, 0x008D8E8C, 0x00757775, 0x00595A59, 0x003E3E3E, 0x00202020, 0x00060606, 0x000D0D0D, 0x002D2D2D, 0x004D4D4D, 0x00656565, 
        0x007D7D7D, 0x008E8E8E, 0x00A0A0A0, 0x00ABABAB, 0x00868686, 0x00535353, 0x9B3F3F3F, 0xFF343434, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF2E2E2E, 0x4E575757, 0x006C6C6C, 0x00A8A9A8, 0x00B7B8B6, 0x00BDBEBC, 0x00CACBC9, 0x00D1D2D0, 0x00C7C8C6, 0x00B3B4B2, 0x009B9C9A, 0x00828381, 0x00626262, 0x00414141, 0x001C1C1C, 0x00040404, 0x001C1C1C, 0x00404040, 0x00636363, 0x007C7C7C, 
        0x00949494, 0x00A4A4A4, 0x00A7A7A7, 0x00A0A0A0, 0x009C9C9C, 0x00686868, 0x1C4A4A4B, 0xEE333334, 0xFFFFFFFF,
  0xFFFFFFFF, 0xD43D3D3D, 0x09959595, 0x00959595, 0x00A1A2A1, 0x00A6A7A5, 0x00AEAFAD, 0x00B8B9B7, 0x00C5C6C4, 0x00D0D1CF, 0x00C7C8C6, 0x00ADAEAC, 0x00919190, 0x006C6D6C, 0x00454545, 0x00181818, 0x00060606, 0x002F2F2F, 0x00585858, 0x007C7C7C, 0x00969696, 
        0x00A5A5A5, 0x00A3A3A3, 0x009B9B9B, 0x00959595, 0x00939392, 0x00777777, 0x004D4D4C, 0x9E3A3A3A, 0xFFFFFFFF,
  0xFFFFFFFF, 0x83737373, 0x00D1D1D1, 0x00919291, 0x0090918E, 0x00969795, 0x009D9E9C, 0x00A5A6A4, 0x00AFB0AE, 0x00BEBFBD, 0x00CDCECC, 0x00C8C9C7, 0x00A8A9A7, 0x007D7E7C, 0x004C4D4C, 0x00111111, 0x00111111, 0x004E4E4E, 0x007B7B7B, 0x009E9E9E, 0x00A6A6A6, 
        0x009C9C9C, 0x00939393, 0x008D8D8E, 0x00888888, 0x00868785, 0x007C7D7A, 0x004B4C48, 0x5B40413F, 0xFFFFFFFF,
  0xFFFFFFFF, 0x4DABABAB, 0x00E7E7E7, 0x00808180, 0x00818280, 0x00868785, 0x008B8C8A, 0x00919290, 0x00999A98, 0x00A5A6A4, 0x00B4B5B3, 0x00C9CAC8, 0x00C5C6C4, 0x00999A98, 0x00575757, 0x000C0C0C, 0x002D2D2D, 0x007C7C7C, 0x009D9D9D, 0x00A1A1A1, 0x00959595, 
        0x008B8B8A, 0x00858584, 0x00808180, 0x007D7D7D, 0x007A7B7A, 0x00777876, 0x004F504C, 0x383D3E3C, 0xFFFFFFFF,
  0xFFFFFFFF, 0x25CACACA, 0x00D7D7D7, 0x0070706F, 0x00727471, 0x00767775, 0x00797A78, 0x007D7E7C, 0x00818280, 0x00888987, 0x00919290, 0x00A1A2A0, 0x00BBBCBA, 0x00C7C8C6, 0x00737373, 0x00151515, 0x00717171, 0x00A2A2A2, 0x00949494, 0x00868686, 0x007E7E7E, 
        0x007A7A79, 0x00757774, 0x00727371, 0x00717170, 0x006E6F6E, 0x006F706E, 0x004F504C, 0x1E383937, 0xFFFFFFFF,
  0xFFFFFFFF, 0x14C9C9C8, 0x00BCBDBB, 0x00616260, 0x00646563, 0x00666765, 0x00676866, 0x00686967, 0x006A6B69, 0x006D6E6C, 0x0070716F, 0x00757674, 0x007F807E, 0x009D9E9C, 0x008F8F8F, 0x00575757, 0x00878886, 0x007A7B79, 0x0070716F, 0x006B6C6A, 0x00696968, 
        0x00686967, 0x00666765, 0x00656664, 0x00656564, 0x00636462, 0x00666664, 0x0053524E, 0x12373734, 0xFFFFFFFF,
  0xFFFFFFFF, 0x11B9B9B9, 0x00ADAEAC, 0x005E5F5D, 0x00616260, 0x00626361, 0x00626361, 0x00636462, 0x00646563, 0x00656664, 0x00676866, 0x00696A69, 0x006F706E, 0x00828381, 0x00707070, 0x00919190, 0x00979895, 0x00757674, 0x006F706E, 0x006B6D6A, 0x00696A68, 
        0x00666765, 0x00656664, 0x00656664, 0x00646563, 0x00636462, 0x00656563, 0x005D5B57, 0x1143433F, 0xFFFFFFFF,
  0xFFFFFFFF, 0x219E9E9E, 0x00AAABA9, 0x00696A68, 0x006B6C6A, 0x006E6F6D, 0x006F716E, 0x00717270, 0x00747673, 0x007A7B79, 0x007F807F, 0x008B8B8B, 0x00999999, 0x008A8A8A, 0x002F2F2F, 0x00666766, 0x00BFC0BE, 0x00B7B8B6, 0x009C9D9B, 0x008D8E8C, 0x00858684, 
        0x007E7F7D, 0x00797A78, 0x00777876, 0x00737472, 0x00717270, 0x0072716F, 0x00696863, 0x1B50504C, 0xFFFFFFFF,
  0xFFFFFFFF, 0x447B7B7A, 0x00AAABA9, 0x00777876, 0x00777876, 0x007A7B79, 0x007E7E7D, 0x00828382, 0x00868786, 0x008F8F8E, 0x009C9C9B, 0x00A5A5A5, 0x008B8B8B, 0x00434343, 0x000E0E0E, 0x004B4B4B, 0x00949593, 0x00C9CAC8, 0x00C9CAC8, 0x00B2B3B1, 0x00A2A3A1, 
        0x00979896, 0x008F908E, 0x008A8B89, 0x00858684, 0x00818280, 0x007F7F7D, 0x00787774, 0x325A5A57, 0xFFFFFFFF,
  0xFFFFFFFF, 0x795A5B5A, 0x00A2A3A1, 0x00848584, 0x00818181, 0x00858585, 0x008A8A8A, 0x00909090, 0x00979797, 0x00A2A2A2, 0x00A2A2A2, 0x00898989, 0x005D5D5D, 0x001E1E1E, 0x000C0C0C, 0x00454545, 0x00797A78, 0x00A8A9A7, 0x00C6C7C5, 0x00CCCDCB, 0x00BCBDBB, 
        0x00ADAEAC, 0x00A3A4A2, 0x009B9C9A, 0x00949593, 0x008F908E, 0x008B8C8A, 0x00868785, 0x555C5D5C, 0xFFFFFFFF,
  0xFFFFFFFF, 0xC7373837, 0x01898A88, 0x00929392, 0x008C8C8C, 0x00919191, 0x00979797, 0x00A0A0A0, 0x00A7A7A7, 0x009E9E9E, 0x00868686, 0x00636363, 0x003C3C3C, 0x00090909, 0x00101010, 0x003F3F3F, 0x00686967, 0x008E8F8D, 0x00ACADAB, 0x00C8C9C7, 0x00D0D1CF, 
        0x00C4C5C3, 0x00B7B8B6, 0x00ADAEAC, 0x00A5A6A4, 0x009FA09E, 0x009D9E9C, 0x00979896, 0x8F4C4D4C, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFB2D2E2C, 0x40636462, 0x00919291, 0x00979797, 0x009C9C9C, 0x00A3A3A3, 0x00A6A6A6, 0x009B9B9B, 0x00848484, 0x006B6B6B, 0x004A4A4A, 0x00252525, 0x00020202, 0x00151516, 0x003C3C3C, 0x005D5E5C, 0x0080817F, 0x009A9B99, 0x00B3B4B2, 0x00C7C8C6, 
        0x00D1D2D0, 0x00C8C9C7, 0x00BCBDBB, 0x00B3B4B2, 0x00ADAEAC, 0x00A2A3A1, 0x148B8C8A, 0xE1333432, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF303030, 0xAA424241, 0x007A7B7A, 0x00969796, 0x00A9AAA9, 0x00A5A4A5, 0x00959596, 0x00838383, 0x006D6D6D, 0x00545454, 0x00353535, 0x00151515, 0x00010101, 0x001A1A1A, 0x00393939, 0x00565656, 0x00747473, 0x008B8C8A, 0x00A3A4A2, 0x00B5B6B4, 
        0x00C6C7C5, 0x00D1D2D0, 0x00CDCECC, 0x00C7C8C6, 0x00A9AAA8, 0x00868785, 0x84525351, 0xFF2C2D2B, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF303031, 0xF2303030, 0x35585857, 0x00818280, 0x009D9E9D, 0x00949394, 0x00828282, 0x00717171, 0x005B5B5B, 0x00434343, 0x00262626, 0x000A0A0A, 0x00040404, 0x001D1D1D, 0x00383838, 0x00515051, 0x006A6A6A, 0x0080817F, 0x00969795, 0x00A7A8A6, 
        0x00B7B8B6, 0x00C6C7C5, 0x00D6D7D5, 0x00C7C8C6, 0x00767675, 0x235E5F5D, 0xEE30312F, 0xFF2F302E, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF303030, 0xFF2E2E2E, 0xD6333333, 0x175E5E5E, 0x007E7E7E, 0x00828381, 0x00717271, 0x00606060, 0x004A4A4A, 0x00343434, 0x00191919, 0x00040404, 0x00090909, 0x001F1F1F, 0x00363636, 0x004C4C4C, 0x00636362, 0x00777876, 0x008B8C8A, 0x009B9C9A, 
        0x00ABACAA, 0x00BEBFBD, 0x00C9CAC8, 0x0070716F, 0x00474747, 0xAD3C3C3B, 0xFF2F2F2E, 0xFF303130, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2C2C2C, 0xAD3B3B3B, 0x07646463, 0x00767775, 0x00686868, 0x004F4F4F, 0x003C3C3C, 0x00292929, 0x000F0F0F, 0x00010101, 0x000D0D0D, 0x00202020, 0x00363636, 0x00494949, 0x005D5E5D, 0x0070716F, 0x00838482, 0x00929391, 
        0x00A9A9A8, 0x00A4A5A3, 0x00515250, 0x02252625, 0x8C373737, 0xFF313031, 0xFF313131, 0xFF313131, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF292929, 0xAF3B3B3A, 0x12616161, 0x00787878, 0x005C5C5C, 0x002F2F2F, 0x00171717, 0x00040404, 0x00000000, 0x00101010, 0x00222222, 0x00353534, 0x00464646, 0x00585857, 0x00686967, 0x007A7B79, 0x008B8D8B, 
        0x007D7D7C, 0x00212121, 0x01020202, 0x8C2B2B2B, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF323232, 0xC23B3B3B, 0x365B5B5B, 0x00797979, 0x006B6B6B, 0x003F3F3F, 0x00121211, 0x00020302, 0x00090909, 0x00171717, 0x00272728, 0x003A3A3A, 0x00525252, 0x006B6B6A, 0x00838483, 0x007C7D7C, 
        0x00464645, 0x281E1E1E, 0xAA2B2B2B, 0xFF353535, 0xFF303030, 0xFF313131, 0xFF313131, 0xFF313131, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF353535, 0xFF353535, 0xF8313131, 0x9B474747, 0x216E6E6E, 0x008C8D8C, 0x00979895, 0x00848583, 0x00757674, 0x00767776, 0x00868687, 0x00A7A7A7, 0x00D2D2D2, 0x00DEDEDE, 0x00BBBBBB, 0x187F8080, 
        0x84474747, 0xEC373737, 0xFF383838, 0xFF343434, 0xFF303030, 0xFF313131, 0xFF313131, 0xFF313131, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF353535, 0xFF363636, 0xFF333333, 0xFF393939, 0xEB353535, 0x9F474746, 0x5E6B6C6B, 0x3A898988, 0x1FA9AAA9, 0x12BEBFBE, 0x11D1D1D1, 0x1CDADADA, 0x33D0D0D0, 0x57AAAAAA, 0x8F626262, 0xE0393939, 
        0xFF393939, 0xFF363636, 0xFF363636, 0xFF343434, 0xFF303030, 0xFF313131, 0xFF313131, 0xFF313131, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
};

GUI_CONST_STORAGE GUI_BITMAP bmknob_black_trans_30x30 = {
  30, // xSize
  30, // ySize
  120, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acknob_black_trans_30x30,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMP8888
};
#endif

/*********************************************************************
*
*       Button background 34x34 (only alpha channel)
*/
static GUI_CONST_STORAGE unsigned char _acknobbk_trans_34x34[] = {
  /* RLE: 012 Pixels @ 000,000 */ 12, 0xFF, 
  /* ABS: 002 Pixels @ 012,000 */ 0, 2, 0xAA, 0x77, 
  /* RLE: 007 Pixels @ 014,000 */ 7, 0x55, 
  /* ABS: 002 Pixels @ 021,000 */ 0, 2, 0xAA, 0xDD, 
  /* RLE: 020 Pixels @ 023,000 */ 20, 0xFF, 
  /* ABS: 003 Pixels @ 009,001 */ 0, 3, 0xDD, 0x77, 0x22, 
  /* RLE: 011 Pixels @ 012,001 */ 11, 0x00, 
  /* ABS: 002 Pixels @ 023,001 */ 0, 2, 0x55, 0xCC, 
  /* RLE: 017 Pixels @ 025,001 */ 17, 0xFF, 
  /* RLE: 001 Pixels @ 008,002 */ 1, 0x77, 
  /* RLE: 016 Pixels @ 009,002 */ 16, 0x00, 
  /* ABS: 002 Pixels @ 025,002 */ 0, 2, 0x33, 0xDD, 
  /* RLE: 013 Pixels @ 027,002 */ 13, 0xFF, 
  /* ABS: 002 Pixels @ 006,003 */ 0, 2, 0xCC, 0x22, 
  /* RLE: 019 Pixels @ 008,003 */ 19, 0x00, 
  /* RLE: 001 Pixels @ 027,003 */ 1, 0x88, 
  /* RLE: 011 Pixels @ 028,003 */ 11, 0xFF, 
  /* RLE: 001 Pixels @ 005,004 */ 1, 0xAA, 
  /* RLE: 022 Pixels @ 006,004 */ 22, 0x00, 
  /* RLE: 001 Pixels @ 028,004 */ 1, 0x55, 
  /* RLE: 009 Pixels @ 029,004 */ 9, 0xFF, 
  /* RLE: 001 Pixels @ 004,005 */ 1, 0xAA, 
  /* RLE: 024 Pixels @ 005,005 */ 24, 0x00, 
  /* RLE: 001 Pixels @ 029,005 */ 1, 0x55, 
  /* RLE: 007 Pixels @ 030,005 */ 7, 0xFF, 
  /* RLE: 001 Pixels @ 003,006 */ 1, 0xCC, 
  /* RLE: 026 Pixels @ 004,006 */ 26, 0x00, 
  /* RLE: 001 Pixels @ 030,006 */ 1, 0x77, 
  /* RLE: 006 Pixels @ 031,006 */ 6, 0xFF, 
  /* RLE: 001 Pixels @ 003,007 */ 1, 0x22, 
  /* RLE: 027 Pixels @ 004,007 */ 27, 0x00, 
  /* RLE: 001 Pixels @ 031,007 */ 1, 0xCC, 
  /* RLE: 004 Pixels @ 032,007 */ 4, 0xFF, 
  /* RLE: 001 Pixels @ 002,008 */ 1, 0x77, 
  /* RLE: 028 Pixels @ 003,008 */ 28, 0x00, 
  /* ABS: 005 Pixels @ 031,008 */ 0, 5, 0x22, 0xFF, 0xFF, 0xFF, 0xDD, 
  /* RLE: 030 Pixels @ 002,009 */ 30, 0x00, 
  /* ABS: 004 Pixels @ 032,009 */ 0, 4, 0x88, 0xFF, 0xFF, 0x77, 
  /* RLE: 030 Pixels @ 002,010 */ 30, 0x00, 
  /* ABS: 004 Pixels @ 032,010 */ 0, 4, 0x22, 0xFF, 0xFF, 0x22, 
  /* RLE: 031 Pixels @ 002,011 */ 31, 0x00, 
  /* ABS: 002 Pixels @ 033,011 */ 0, 2, 0xCC, 0xAA, 
  /* RLE: 032 Pixels @ 001,012 */ 32, 0x00, 
  /* ABS: 002 Pixels @ 033,012 */ 0, 2, 0x55, 0x77, 
  /* RLE: 032 Pixels @ 001,013 */ 32, 0x00, 
  /* ABS: 002 Pixels @ 033,013 */ 0, 2, 0x22, 0x55, 
  /* RLE: 033 Pixels @ 001,014 */ 33, 0x00, 
  /* RLE: 001 Pixels @ 000,015 */ 1, 0x22, 
  /* RLE: 135 Pixels @ 001,015 */ 135, 0x00, 
  /* RLE: 001 Pixels @ 000,019 */ 1, 0x55, 
  /* RLE: 033 Pixels @ 001,019 */ 33, 0x00, 
  /* RLE: 001 Pixels @ 000,020 */ 1, 0x55, 
  /* RLE: 033 Pixels @ 001,020 */ 33, 0x00, 
  /* RLE: 001 Pixels @ 000,021 */ 1, 0xAA, 
  /* RLE: 032 Pixels @ 001,021 */ 32, 0x00, 
  /* ABS: 002 Pixels @ 033,021 */ 0, 2, 0x55, 0xDD, 
  /* RLE: 032 Pixels @ 001,022 */ 32, 0x00, 
  /* ABS: 003 Pixels @ 033,022 */ 0, 3, 0x88, 0xFF, 0x55, 
  /* RLE: 031 Pixels @ 002,023 */ 31, 0x00, 
  /* ABS: 003 Pixels @ 033,023 */ 0, 3, 0xFF, 0xFF, 0xCC, 
  /* RLE: 030 Pixels @ 002,024 */ 30, 0x00, 
  /* ABS: 005 Pixels @ 032,024 */ 0, 5, 0x77, 0xFF, 0xFF, 0xFF, 0x33, 
  /* RLE: 029 Pixels @ 003,025 */ 29, 0x00, 
  /* ABS: 005 Pixels @ 032,025 */ 0, 5, 0xDD, 0xFF, 0xFF, 0xFF, 0xDD, 
  /* RLE: 028 Pixels @ 003,026 */ 28, 0x00, 
  /* RLE: 001 Pixels @ 031,026 */ 1, 0x88, 
  /* RLE: 005 Pixels @ 032,026 */ 5, 0xFF, 
  /* RLE: 001 Pixels @ 003,027 */ 1, 0x88, 
  /* RLE: 026 Pixels @ 004,027 */ 26, 0x00, 
  /* RLE: 001 Pixels @ 030,027 */ 1, 0x33, 
  /* RLE: 007 Pixels @ 031,027 */ 7, 0xFF, 
  /* RLE: 001 Pixels @ 004,028 */ 1, 0x55, 
  /* RLE: 024 Pixels @ 005,028 */ 24, 0x00, 
  /* ABS: 002 Pixels @ 029,028 */ 0, 2, 0x22, 0xDD, 
  /* RLE: 008 Pixels @ 031,028 */ 8, 0xFF, 
  /* RLE: 001 Pixels @ 005,029 */ 1, 0x55, 
  /* RLE: 022 Pixels @ 006,029 */ 22, 0x00, 
  /* ABS: 002 Pixels @ 028,029 */ 0, 2, 0x22, 0xDD, 
  /* RLE: 010 Pixels @ 030,029 */ 10, 0xFF, 
  /* RLE: 001 Pixels @ 006,030 */ 1, 0x77, 
  /* RLE: 020 Pixels @ 007,030 */ 20, 0x00, 
  /* ABS: 002 Pixels @ 027,030 */ 0, 2, 0x33, 0xDD, 
  /* RLE: 012 Pixels @ 029,030 */ 12, 0xFF, 
  /* ABS: 002 Pixels @ 007,031 */ 0, 2, 0xCC, 0x22, 
  /* RLE: 017 Pixels @ 009,031 */ 17, 0x00, 
  /* RLE: 001 Pixels @ 026,031 */ 1, 0x88, 
  /* RLE: 016 Pixels @ 027,031 */ 16, 0xFF, 
  /* ABS: 002 Pixels @ 009,032 */ 0, 2, 0x88, 0x22, 
  /* RLE: 013 Pixels @ 011,032 */ 13, 0x00, 
  /* ABS: 002 Pixels @ 024,032 */ 0, 2, 0x77, 0xDD, 
  /* RLE: 019 Pixels @ 026,032 */ 19, 0xFF, 
  /* ABS: 003 Pixels @ 011,033 */ 0, 3, 0xCC, 0x55, 0x22, 
  /* RLE: 007 Pixels @ 014,033 */ 7, 0x00, 
  /* ABS: 002 Pixels @ 021,033 */ 0, 2, 0x55, 0x88, 
  /* RLE: 011 Pixels @ 023,033 */ 11, 0xFF, 
  0
};  // 257 bytes for 1156 pixels

GUI_CONST_STORAGE GUI_BITMAP bmknobbk_trans_34x34 = {
  34, // xSize
  34, // ySize
  34, // BytesPerLine
  GUI_COMPRESS_RLE8, // BitsPerPixel
  (unsigned char *)_acknobbk_trans_34x34,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_RLEALPHA
};

/*********************************************************************
*
*       PowerLED 12x12 off (gray)
*/
#if (GUI_USE_ARGB)
static GUI_CONST_STORAGE unsigned long _acpower_gray_trans_12x12[] = {
  0x00000000, 0x00000000, 0x00000000, 0x22000000, 0x77000000, 0xAA000000, 0xBC000000, 0x88000000, 0x33000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x55000000, 0xDD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x88000000, 0x00000000, 0x00000000,
  0x00000000, 0x33000000, 0xFF000000, 0xFF000000, 0xE80F0E0F, 0xC7333132, 0xCF2C2A2B, 0xD8232223, 0xFF000000, 0xFF000000, 0x88000000, 0x00000000,
  0x00000000, 0xDD000000, 0xFF000000, 0xF4191819, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF333132, 0xFF000000, 0xFF000000, 0x33000000,
  0x33000000, 0xFF000000, 0xF00A090A, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xF0232223, 0xFF000000, 0x88000000,
  0x55000000, 0xFF000000, 0xF4191819, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF333132, 0xFF000000, 0xAA000000,
  0x6D000000, 0xFF000000, 0xFF141313, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF2B2A2B, 0xFF000000, 0xBC000000,
  0x55000000, 0xFF000000, 0xEF0F0E0F, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF282728, 0xFF000000, 0xAA000000,
  0x00000000, 0xFF000000, 0xFF000000, 0xFF333132, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF424041, 0xF00A090A, 0xFF000000, 0x55000000,
  0x00000000, 0x77000000, 0xFF000000, 0xFF000000, 0xED282728, 0xFF4D4B4C, 0xFF4D4B4C, 0xFF3D3B3C, 0xF00A090A, 0xFF000000, 0xCC000000, 0x00000000,
  0x00000000, 0x00000000, 0xAA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDD000000, 0x22000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x55000000, 0xCC000000, 0xFF000000, 0xFF000000, 0xDD000000, 0x88000000, 0x00000000, 0x00000000, 0x00000000
};

GUI_CONST_STORAGE GUI_BITMAP bmpower_gray_trans_12x12 = {
  12, // xSize
  12, // ySize
  48, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acpower_gray_trans_12x12,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMPM8888I
};
#else
static GUI_CONST_STORAGE unsigned long _acpower_gray_trans_12x12[] = {
  0xFF000000, 0xFF000000, 0xFF000000, 0xDD000000, 0x88000000, 0x55000000, 0x43000000, 0x77000000, 0xCC000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xAA000000, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x77000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xCC000000, 0x00000000, 0x00000000, 0x170F0E0F, 0x38323133, 0x302B2A2C, 0x27232223, 0x00000000, 0x00000000, 0x77000000, 0xFF000000,
  0xFF000000, 0x22000000, 0x00000000, 0x0B191819, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x00323133, 0x00000000, 0x00000000, 0xCC000000,
  0xCC000000, 0x00000000, 0x0F0A090A, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x0F232223, 0x00000000, 0x77000000,
  0xAA000000, 0x00000000, 0x0B191819, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x00323133, 0x00000000, 0x55000000,
  0x92000000, 0x00000000, 0x00131314, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x002B2A2B, 0x00000000, 0x43000000,
  0xAA000000, 0x00000000, 0x100F0E0F, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x00282728, 0x00000000, 0x55000000,
  0xFF000000, 0x00000000, 0x00000000, 0x00323133, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x004C4B4D, 0x00414042, 0x0F0A090A, 0x00000000, 0xAA000000,
  0xFF000000, 0x88000000, 0x00000000, 0x00000000, 0x12282728, 0x004C4B4D, 0x004C4B4D, 0x003C3B3D, 0x0F0A090A, 0x00000000, 0x33000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0x55000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22000000, 0xDD000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xAA000000, 0x33000000, 0x00000000, 0x00000000, 0x22000000, 0x77000000, 0xFF000000, 0xFF000000, 0xFF000000
};

GUI_CONST_STORAGE GUI_BITMAP bmpower_gray_trans_12x12 = {
  12, // xSize
  12, // ySize
  48, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acpower_gray_trans_12x12,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMP8888
};
#endif

/*********************************************************************
*
*       PowerLED 12x12 standby (red)
*/
#if (GUI_USE_ARGB)
static GUI_CONST_STORAGE unsigned long _acpower_red_trans_12x12[] = {
  0x00000000, 0x00000000, 0x00000000, 0x22000000, 0x77000000, 0xAA000000, 0xBC000000, 0x88000000, 0x33000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x55000000, 0xDD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x88000000, 0x00000000, 0x00000000,
  0x00000000, 0x33000000, 0xFF000000, 0xFF000000, 0xE8320000, 0xC7A90000, 0xCF910000, 0xD8760000, 0xFF000000, 0xFF000000, 0x88000000, 0x00000000,
  0x00000000, 0xDD000000, 0xFF000000, 0xF4540000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFA90000, 0xFF000000, 0xFF000000, 0x33000000,
  0x33000000, 0xFF000000, 0xF0210000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xF0760000, 0xFF000000, 0x88000000,
  0x55000000, 0xFF000000, 0xF4540000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFA90000, 0xFF000000, 0xAA000000,
  0x6D000000, 0xFF000000, 0xFF430000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFF920000, 0xFF000000, 0xBC000000,
  0x55000000, 0xFF000000, 0xEF320000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFF870000, 0xFF000000, 0xAA000000,
  0x00000000, 0xFF000000, 0xFF000000, 0xFFA90000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFDC0000, 0xF0210000, 0xFF000000, 0x55000000,
  0x00000000, 0x77000000, 0xFF000000, 0xFF000000, 0xED870000, 0xFFFF0000, 0xFFFF0000, 0xFFCB0000, 0xF0210000, 0xFF000000, 0xCC000000, 0x00000000,
  0x00000000, 0x00000000, 0xAA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDD000000, 0x22000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x55000000, 0xCC000000, 0xFF000000, 0xFF000000, 0xDD000000, 0x88000000, 0x00000000, 0x00000000, 0x00000000
};

GUI_CONST_STORAGE GUI_BITMAP bmpower_red_trans_12x12 = {
  12, // xSize
  12, // ySize
  48, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acpower_red_trans_12x12,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMPM8888I
};
#else
static GUI_CONST_STORAGE unsigned long _acpower_red_trans_12x12[] = {
  0xFF000000, 0xFF000000, 0xFF000000, 0xDD000000, 0x88000000, 0x55000000, 0x43000000, 0x77000000, 0xCC000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xAA000000, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x77000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xCC000000, 0x00000000, 0x00000000, 0x17000032, 0x380000A9, 0x30000091, 0x27000076, 0x00000000, 0x00000000, 0x77000000, 0xFF000000,
  0xFF000000, 0x22000000, 0x00000000, 0x0B000054, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000A9, 0x00000000, 0x00000000, 0xCC000000,
  0xCC000000, 0x00000000, 0x0F000021, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x0F000076, 0x00000000, 0x77000000,
  0xAA000000, 0x00000000, 0x0B000054, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000A9, 0x00000000, 0x55000000,
  0x92000000, 0x00000000, 0x00000043, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x00000092, 0x00000000, 0x43000000,
  0xAA000000, 0x00000000, 0x10000032, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x00000087, 0x00000000, 0x55000000,
  0xFF000000, 0x00000000, 0x00000000, 0x000000A9, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000DC, 0x0F000021, 0x00000000, 0xAA000000,
  0xFF000000, 0x88000000, 0x00000000, 0x00000000, 0x12000087, 0x000000FF, 0x000000FF, 0x000000CB, 0x0F000021, 0x00000000, 0x33000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0x55000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22000000, 0xDD000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xAA000000, 0x33000000, 0x00000000, 0x00000000, 0x22000000, 0x77000000, 0xFF000000, 0xFF000000, 0xFF000000
};

GUI_CONST_STORAGE GUI_BITMAP bmpower_red_trans_12x12 = {
  12, // xSize
  12, // ySize
  48, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acpower_red_trans_12x12,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMP8888
};
#endif

/*********************************************************************
*
*       PowerLED 12x12 on (green)
*/
#if (GUI_USE_ARGB)
static GUI_CONST_STORAGE unsigned long _acpower_green_trans_12x12[] = {
  0x00000000, 0x00000000, 0x00000000, 0x22000000, 0x77000000, 0xAA000000, 0xBC000000, 0x88000000, 0x33000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x55000000, 0xDD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x88000000, 0x00000000, 0x00000000,
  0x00000000, 0x33000000, 0xFF000000, 0xFF000000, 0xE8003200, 0xC700A900, 0xCF009100, 0xD8007600, 0xFF000000, 0xFF000000, 0x88000000, 0x00000000,
  0x00000000, 0xDD000000, 0xFF000000, 0xF4005400, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00A900, 0xFF000000, 0xFF000000, 0x33000000,
  0x33000000, 0xFF000000, 0xF0002100, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xF0007600, 0xFF000000, 0x88000000,
  0x55000000, 0xFF000000, 0xF4005400, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00A900, 0xFF000000, 0xAA000000,
  0x6D000000, 0xFF000000, 0xFF004300, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF009200, 0xFF000000, 0xBC000000,
  0x55000000, 0xFF000000, 0xEF003200, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF008700, 0xFF000000, 0xAA000000,
  0x00000000, 0xFF000000, 0xFF000000, 0xFF00A900, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00FF00, 0xFF00DC00, 0xF0002100, 0xFF000000, 0x55000000,
  0x00000000, 0x77000000, 0xFF000000, 0xFF000000, 0xED008700, 0xFF00FF00, 0xFF00FF00, 0xFF00CB00, 0xF0002100, 0xFF000000, 0xCC000000, 0x00000000,
  0x00000000, 0x00000000, 0xAA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDD000000, 0x22000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x55000000, 0xCC000000, 0xFF000000, 0xFF000000, 0xDD000000, 0x88000000, 0x00000000, 0x00000000, 0x00000000
};

GUI_CONST_STORAGE GUI_BITMAP bmpower_green_trans_12x12 = {
  12, // xSize
  12, // ySize
  48, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acpower_green_trans_12x12,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMPM8888I
};
#else
static GUI_CONST_STORAGE unsigned long _acpower_green_trans_12x12[] = {
  0xFF000000, 0xFF000000, 0xFF000000, 0xDD000000, 0x88000000, 0x55000000, 0x43000000, 0x77000000, 0xCC000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xAA000000, 0x22000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x77000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xCC000000, 0x00000000, 0x00000000, 0x17003200, 0x3800A900, 0x30009100, 0x27007600, 0x00000000, 0x00000000, 0x77000000, 0xFF000000,
  0xFF000000, 0x22000000, 0x00000000, 0x0B005400, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000A900, 0x00000000, 0x00000000, 0xCC000000,
  0xCC000000, 0x00000000, 0x0F002100, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0F007600, 0x00000000, 0x77000000,
  0xAA000000, 0x00000000, 0x0B005400, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000A900, 0x00000000, 0x55000000,
  0x92000000, 0x00000000, 0x00004300, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x00009200, 0x00000000, 0x43000000,
  0xAA000000, 0x00000000, 0x10003200, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x00008700, 0x00000000, 0x55000000,
  0xFF000000, 0x00000000, 0x00000000, 0x0000A900, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000FF00, 0x0000DC00, 0x0F002100, 0x00000000, 0xAA000000,
  0xFF000000, 0x88000000, 0x00000000, 0x00000000, 0x12008700, 0x0000FF00, 0x0000FF00, 0x0000CB00, 0x0F002100, 0x00000000, 0x33000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0x55000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22000000, 0xDD000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xAA000000, 0x33000000, 0x00000000, 0x00000000, 0x22000000, 0x77000000, 0xFF000000, 0xFF000000, 0xFF000000
};

GUI_CONST_STORAGE GUI_BITMAP bmpower_green_trans_12x12 = {
  12, // xSize
  12, // ySize
  48, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acpower_green_trans_12x12,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMP8888
};
#endif

/*********************************************************************
*
*       Volume bar 37x7 (green)
*/
#if (GUI_USE_ARGB)
static GUI_CONST_STORAGE unsigned long _acvolume_green_37x7[] = {
  0x6680FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 
        0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0x6680FF80,
  0xEE80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 
        0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xFF80FF80, 0xEE80FF80,
  0xFF4CF44C, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 
        0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF4CF44C, 0xFF80FF80, 0xFF80FF80,
  0xFF08E808, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 
        0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF08E808, 0xFF80FF80, 0xFF80FF80,
  0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 
        0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF80FF80, 0xFF80FF80,
  0xFE08E808, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 
        0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF08E808, 0xFF80FF80, 0xEE80FF80,
  0xA44CF44C, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 
        0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF00E800, 0xFF4CF44C, 0xFF80FF80, 0x6680FF80
};

GUI_CONST_STORAGE GUI_BITMAP bmvolume_green_37x7 = {
  37, // xSize
  7, // ySize
  148, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acvolume_green_37x7,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMPM8888I
};;
#else
static GUI_CONST_STORAGE unsigned long _acvolume_green_37x7[] = {
  0x9980FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 
        0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x9980FF80,
  0x1180FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 
        0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x0080FF80, 0x1180FF80,
  0x004CF44C, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 
        0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x004CF44C, 0x0080FF80, 0x0080FF80,
  0x0008E808, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 
        0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0008E808, 0x0080FF80, 0x0080FF80,
  0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 
        0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0080FF80, 0x0080FF80,
  0x0108E808, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 
        0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0008E808, 0x0080FF80, 0x1180FF80,
  0x5B4CF44C, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 
        0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x0000E800, 0x004CF44C, 0x0080FF80, 0x9980FF80
};

GUI_CONST_STORAGE GUI_BITMAP bmvolume_green_37x7 = {
  37, // xSize
  7, // ySize
  148, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acvolume_green_37x7,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMP8888
};
#endif

/*********************************************************************
*
*       Volume bar 37x7 (yellow)
*/
#if (GUI_USE_ARGB)
static GUI_CONST_STORAGE unsigned long _acvolume_yellow_37x7[] = {
  0x66FFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 
        0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0x66FFFF80,
  0xEEFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 
        0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xFFFFFF80, 0xEEFFFF80,
  0xFFFEED68, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 
        0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFEED68, 0xFFFFFF80, 0xFFFFFF80,
  0xFFFED749, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 
        0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFED749, 0xFFFFFF80, 0xFFFFFF80,
  0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 
        0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFFF80, 0xFFFFFF80,
  0xFEFED749, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 
        0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFED749, 0xFFFFFF80, 0xEEFFFF80,
  0xA4FEED68, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 
        0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFFD646, 0xFFFEED68, 0xFFFFFF80, 0x66FFFF80
};

GUI_CONST_STORAGE GUI_BITMAP bmvolume_yellow_37x7 = {
  37, // xSize
  7, // ySize
  148, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acvolume_yellow_37x7,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMPM8888I
};
#else
static GUI_CONST_STORAGE unsigned long _acvolume_yellow_37x7[] = {
  0x9980FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 
        0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x9980FFFF,
  0x1180FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 
        0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x0080FFFF, 0x1180FFFF,
  0x0068EDFE, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 
        0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0068EDFE, 0x0080FFFF, 0x0080FFFF,
  0x0049D7FE, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 
        0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0049D7FE, 0x0080FFFF, 0x0080FFFF,
  0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 
        0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0080FFFF, 0x0080FFFF,
  0x0149D7FE, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 
        0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0049D7FE, 0x0080FFFF, 0x1180FFFF,
  0x5B68EDFE, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 
        0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0046D6FF, 0x0068EDFE, 0x0080FFFF, 0x9980FFFF
};

GUI_CONST_STORAGE GUI_BITMAP bmvolume_yellow_37x7 = {
  37, // xSize
  7, // ySize
  148, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acvolume_yellow_37x7,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMP8888
};
#endif

/*********************************************************************
*
*       Volume bar 37x7 (red)
*/
#if (GUI_USE_ARGB)
static GUI_CONST_STORAGE unsigned long _acvolume_red_37x7[] = {
  0x66FF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 
        0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0x66FF8080,
  0xEEFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 
        0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xFFFF8080, 0xEEFF8080,
  0xFFFE4C4C, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 
        0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFE4C4C, 0xFFFF8080, 0xFFFF8080,
  0xFFFE0808, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 
        0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFE0808, 0xFFFF8080, 0xFFFF8080,
  0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 
        0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF8080, 0xFFFF8080,
  0xFEFE0808, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 
        0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFE0808, 0xFFFF8080, 0xEEFF8080,
  0xA4FE4C4C, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 
        0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFFE4C4C, 0xFFFF8080, 0x66FF8080
};

GUI_CONST_STORAGE GUI_BITMAP bmvolume_red_37x7 = {
  37, // xSize
  7, // ySize
  148, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acvolume_red_37x7,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMPM8888I
};
#else
static GUI_CONST_STORAGE unsigned long _acvolume_red_37x7[] = {
  0x998080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 
        0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x998080FF,
  0x118080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 
        0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x008080FF, 0x118080FF,
  0x004C4CFE, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 
        0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x004C4CFE, 0x008080FF, 0x008080FF,
  0x000808FE, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 
        0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000808FE, 0x008080FF, 0x008080FF,
  0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 
        0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x008080FF, 0x008080FF,
  0x010808FE, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 
        0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000808FE, 0x008080FF, 0x118080FF,
  0x5B4C4CFE, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 
        0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x004C4CFE, 0x008080FF, 0x998080FF
};

GUI_CONST_STORAGE GUI_BITMAP bmvolume_red_37x7 = {
  37, // xSize
  7, // ySize
  148, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acvolume_red_37x7,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMP8888
};
#endif

/*********************************************************************
*
*       Volume bar 37x7 (only alpha channel)
*/
static GUI_CONST_STORAGE unsigned char _acvolume_trans_37x7[] = {
  /* RLE: 001 Pixels @ 000,000 */ 1, 0x99, 
  /* RLE: 035 Pixels @ 001,000 */ 35, 0x00, 
  /* ABS: 002 Pixels @ 036,000 */ 0, 2, 0x99, 0x11, 
  /* RLE: 035 Pixels @ 001,001 */ 35, 0x00, 
  /* RLE: 001 Pixels @ 036,001 */ 1, 0x11, 
  /* RLE: 111 Pixels @ 000,002 */ 111, 0x00, 
  /* RLE: 001 Pixels @ 000,005 */ 1, 0x01, 
  /* RLE: 035 Pixels @ 001,005 */ 35, 0x00, 
  /* ABS: 002 Pixels @ 036,005 */ 0, 2, 0x11, 0x5B, 
  /* RLE: 035 Pixels @ 001,006 */ 35, 0x00, 
  /* RLE: 001 Pixels @ 036,006 */ 1, 0x99, 
  0
};  // 26 bytes for 259 pixels

GUI_CONST_STORAGE GUI_BITMAP bmvolume_trans_37x7 = {
  37, // xSize
  7, // ySize
  37, // BytesPerLine
  GUI_COMPRESS_RLE8, // BitsPerPixel
  (unsigned char *)_acvolume_trans_37x7,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_RLEALPHA
};

/*********************************************************************
*
*       Scale Points 4x4 (only alpha channel)
*/
static GUI_CONST_STORAGE unsigned char _acscale_trans_4x4[] = {
  /* ABS: 012 Pixels @ 000,000 */ 0, 16, 0xFF, 0xBE, 0xA2, 0xFF, 0xBE, 0x00, 0x00, 0x48, 0xA2, 0x00, 0x00, 0x37, 0xFF, 0x70, 0x70, 0xBE, 
  0
}; 
GUI_CONST_STORAGE GUI_BITMAP bmscale_trans_4x4 = {
  4, // xSize
  4, // ySize
  4, // BytesPerLine
  GUI_COMPRESS_RLE8, // BitsPerPixel
  (unsigned char *)_acscale_trans_4x4,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_RLEALPHA
};

/*********************************************************************
*
*       _aDialogCreate
*/
static const GUI_WIDGET_CREATE_INFO _aDialogCreate[] = {
  { WINDOW_CreateIndirect,  "", ID_WIN_0,        0,   0,   600, 450, WM_CF_SHOW, 0, 0 },
  { KNOB_CreateIndirect,    "", GUI_ID_KNOB0,    20,  185, 70,  70,  WM_CF_SHOW },       // Power
  { KNOB_CreateIndirect,    "", GUI_ID_KNOB1,    270, 120, 140, 140, WM_CF_SHOW },       // Volume
  { KNOB_CreateIndirect,    "", GUI_ID_KNOB2,    20,  20,  70,  70,  WM_CF_SHOW },       // Gain
  { KNOB_CreateIndirect,    "", GUI_ID_KNOB3,    115, 20,  70,  70,  WM_CF_SHOW },       // High
  { KNOB_CreateIndirect,    "", GUI_ID_KNOB4,    210, 20,  70,  70,  WM_CF_SHOW },       // Mid
  { KNOB_CreateIndirect,    "", GUI_ID_KNOB5,    305, 20,  70,  70,  WM_CF_SHOW },       // Low
  { BUTTON_CreateIndirect,  "", GUI_ID_BUTTON0,  415, 110,  30,  30, WM_CF_SHOW, 0, 1 }, // Automode
};

/*********************************************************************
*
*       _Linear
*/
static I32 _Linear(ANIMATION * pAnim, ANIMATION_ITEM * pItem, GUI_TIMER_TIME tCurrent) {
  I32 Result;

  if (tCurrent < pAnim->t0 + pItem->ts) {
    return -1;
  }
  if (tCurrent > pAnim->t0 + pItem->te) {
    if (pItem->IsRunning == 0) {
      return -1;
    }
    pItem->IsRunning = 0;
    return 1000;
  }
  pItem->IsRunning = 1;
  Result = ((tCurrent - pItem->ts - pAnim->t0) * 1000) / (pItem->te - pItem->ts);
  return Result;
}

/*********************************************************************
*
*       _Accel
*/
static I32 _Accel(ANIMATION * pAnim, ANIMATION_ITEM * pItem, GUI_TIMER_TIME tCurrent) {
  I32 Result;

  Result = _Linear(pAnim, pItem, tCurrent);
  if (Result > 0) {
    Result = (Result * Result) / 1000;
  }
  return Result;
}

/*********************************************************************
*
*       _AccelDecel
*/
static I32 _AccelDecel(ANIMATION * pAnim, ANIMATION_ITEM * pItem, GUI_TIMER_TIME tCurrent) {
  I32 Result;

  Result = _Linear(pAnim, pItem, tCurrent);
  if (Result > 0) {
    if (Result < 500) {
      Result = (Result * Result) / 500;
    } else {
      Result -= 500;
      Result = 500 - Result;
      Result = (Result * Result) / 500;
      Result = 500 - Result;
      Result += 500;
    }
  }
  return Result;
}

/*********************************************************************
*
*       Animation coordinates
*/
static ANIM _aAnim[] = {
  // Standby On
  {  MOTION_LINEAR, UNPRESSED, _AccelDecel,  1000,  75, 220               },
  {  MOTION_ROUND,  PRESSED,   _AccelDecel,  1500,  55, 220, 360, 315, 20 },
  // Wait
  {  MOTION_ROUND,  UNPRESSED, _AccelDecel,   500,  55, 220, 315, 315, 20 },
  // Power On
  {  MOTION_ROUND,  PRESSED,   _AccelDecel,  1500,  55, 220, 315, 270, 20 },
  // Volume up
  {  MOTION_LINEAR, UNPRESSED, _AccelDecel,  1000, 290, 190               },
  {  MOTION_ROUND,  PRESSED,   _AccelDecel, 10000, 340, 190, 180, 540, 50 },
  // Gain up
  {  MOTION_LINEAR, UNPRESSED, _AccelDecel,  1000,  75,  55               },
  {  MOTION_ROUND,  PRESSED,   _AccelDecel,  3000,  55,  55,   0, 270, 20 },
  // High up                    
  {  MOTION_LINEAR, UNPRESSED, _AccelDecel,  1000, 150,  75               },
  {  MOTION_ROUND,  PRESSED,   _AccelDecel,  2000, 150,  55,  90, 270, 20 },
  // Middle up                  
  {  MOTION_LINEAR, UNPRESSED, _AccelDecel,  1000, 245,  75               },
  {  MOTION_ROUND,  PRESSED,   _Accel,        800, 245,  55,  90, 270, 20 },
  // Wait                       
  {  MOTION_ROUND,  UNPRESSED, _AccelDecel,   500, 245,  55, 270, 270, 20 },
  // Low up                     
  {  MOTION_LINEAR, UNPRESSED, _AccelDecel,  1000, 320,  70               },
  {  MOTION_LINEAR, PRESSED,   _AccelDecel,  1000, 320,  30               },
  // Standby Off                
  {  MOTION_LINEAR, UNPRESSED, _AccelDecel,  1000,  75, 220               },
  {  MOTION_ROUND,  PRESSED,   _AccelDecel,  2000,  55, 220,   0,  45, 20 },
  // Wait                       
  {  MOTION_ROUND,  UNPRESSED, _AccelDecel,   500,  55, 220,  45,  45, 20 },
  // Standby On                 
  {  MOTION_ROUND,  PRESSED,   _AccelDecel,  2000,  55, 220,  45,   0, 20 },
  // Low down                   
  {  MOTION_LINEAR, UNPRESSED, _AccelDecel,  1000, 320,  30               },
  {  MOTION_LINEAR, PRESSED,   _AccelDecel,  1000, 320,  70               },
  // Middle down                
  {  MOTION_LINEAR, UNPRESSED, _AccelDecel,  1000, 245,  35               },
  {  MOTION_ROUND,  PRESSED,   _Accel,        800, 245,  55, 270,  90, 20 },
  // Wait                       
  {  MOTION_ROUND,  UNPRESSED, _AccelDecel,   500, 245,  55,  90,  90, 20 },
  // High down                  
  {  MOTION_LINEAR, UNPRESSED, _AccelDecel,  1000, 150,  35               },
  {  MOTION_ROUND,  PRESSED,   _AccelDecel,  2000, 150,  55, 270,  90, 20 },
  // Gain down                  
  {  MOTION_LINEAR, UNPRESSED, _AccelDecel,  1000,  55,  35               },
  {  MOTION_ROUND,  PRESSED,   _AccelDecel,  2000,  55,  55, 270,   0, 20 },
  // Volume down                
  {  MOTION_LINEAR, UNPRESSED, _AccelDecel,  1000, 290, 190               },
  {  MOTION_ROUND,  PRESSED,   _AccelDecel, 10000, 340, 190, 540, 180, 50 },
  // Standby Off                
  {  MOTION_LINEAR, UNPRESSED, _AccelDecel,  1000,  55, 200               },
  {  MOTION_ROUND,  PRESSED,   _AccelDecel,  2000,  55, 220, 270, 315, 20 },
  // Wait                       
  {  MOTION_ROUND,  UNPRESSED, _AccelDecel,   500,  55, 220, 315, 315, 20 },
  // Power Off                  
  {  MOTION_ROUND,  PRESSED,   _AccelDecel,  2000,  55, 220, 315, 360, 20 },
};

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*********************************************************************
*
*       _DrawKnob
*/
static void _DrawKnob(GUI_MEMDEV_Handle hMem, GUI_COLOR Color) {
  int xSizeMem, ySizeMem;

  xSizeMem = GUI_MEMDEV_GetXSize(hMem);
  ySizeMem = GUI_MEMDEV_GetYSize(hMem);
  GUI_AA_PreserveTrans(1);
  GUI_MEMDEV_Select(hMem);
  GUI_SetBkColor(GUI_TRANSPARENT);
  GUI_Clear();
  GUI_SetColor(Color);
  GUI_AA_FillCircle(xSizeMem / 2 + xSizeMem / 3, ySizeMem / 2, 3);
  GUI_MEMDEV_Select(0);
  GUI_AA_PreserveTrans(0);
}

/*********************************************************************
*
*       _DrawKnobBig
*/
static void _DrawKnobBig(GUI_MEMDEV_Handle hMem, GUI_COLOR Color) {
  int xSizeMem, ySizeMem;

  xSizeMem = GUI_MEMDEV_GetXSize(hMem);
  ySizeMem = GUI_MEMDEV_GetYSize(hMem);
  GUI_AA_PreserveTrans(1);
  GUI_MEMDEV_Select(hMem);
  GUI_SetBkColor(GUI_TRANSPARENT);
  GUI_Clear();
  GUI_SetPenSize(3);
  GUI_SetColor(Color);
  GUI_AA_DrawLine(xSizeMem / 2 + 10, ySizeMem / 2, xSizeMem / 2 + xSizeMem / 3, ySizeMem / 2);
  GUI_SetPenSize(1);
  GUI_MEMDEV_Select(0);
  GUI_AA_PreserveTrans(0);
}

/*********************************************************************
*
*       _GetScale
*/
static int _GetScale(KNOB_Handle hKnob) {
  I32 Value;

  Value = ((270 - KNOB_GetValue(hKnob) / 10) + 26) / 27;
  return Value;
}

/*********************************************************************
*
*       _DrawScale
*/
static void _DrawScale(KNOB_Handle hKnob, int PowerOn) {
  GUI_COLOR DarkerGreen;
  I32       CosHQ, SinHQ;
  I32       Angle, Value;
  int       xPos,  yPos;

#if (GUI_USE_ARGB)
  DarkerGreen = 0xFF00E800;
#else
  DarkerGreen = 0x00E800;
#endif
  Value = 270 - KNOB_GetValue(hKnob) / 10;
  xPos = WM_GetWindowOrgX(hKnob) + 70 / 2;
  yPos = WM_GetWindowOrgY(hKnob) + 70 / 2;
  for (Angle = 270; Angle >= 0; Angle -= 27) {
    if ((Angle < Value) && (PowerOn == 2) && (Angle < 118)) {
      GUI_SetColor(DarkerGreen);
    } else if((Angle < Value) && (PowerOn == 2) && (Angle < 218) && (Angle > 117)) {
      GUI_SetColor(GUI_YELLOW);
    } else if((Angle <= Value) && (PowerOn == 2) && (Angle > 217)) {
      GUI_SetColor(GUI_RED);
    } else {
      GUI_SetColor(AMP_COLOR_GRAY);
    }
    CosHQ = (GUI__CosHQ((Angle + 135) * 1000) * 1000) / 65536;
    SinHQ = (GUI__SinHQ((Angle + 135) * 1000) * 1000) / 65536;
    GUI_DrawBitmap(&bmscale_trans_4x4, xPos + 36 * CosHQ / 1000 - 2, yPos + 36 * SinHQ / 1000 - 2);
  }
}

/*********************************************************************
*
*       _AbsoluteValue
*/
static int _AbsoluteValue(int number) {
  return (number < 0) ? -number : number;
}

/*********************************************************************
*
*       _MoveCursor
*/

static int _MoveCursor(int Pos, ANIM * pAnim) {
  GUI_PID_STATE StateCurrent;
  GUI_PID_STATE State    = {0};
  static ANIM * pPreAnim = {0};
  static int    x        = START_POS_CURSOR_X;
  static int    y        = START_POS_CURSOR_Y;
  static int    xStart;
  static int    yStart;
  static int    Length;
  static int    Length2;
  static int    Angle;
  int           xPos, yPos;
  I8            Step;
  
  if(pPreAnim != pAnim) {
    pPreAnim = pAnim;
    xStart   = x;
    yStart   = y;
  }
  if (pAnim->MotionRound) {
    Length = _AbsoluteValue(pAnim->AngleS - pAnim->AngleE);
    Step   = (pAnim->AngleS < pAnim->AngleE) ? 1 : -1;
    Angle  = pAnim->AngleS + (Pos * Length / 1000) * Step;
    x      = pAnim->r * GUI__CosHQ((Angle) * 1000) / 65536 + pAnim->x;
    y      = pAnim->r * GUI__SinHQ((Angle) * 1000) / 65536 + pAnim->y;
  } else {
    Length  = _AbsoluteValue(xStart - pAnim->x);
    Length2 = _AbsoluteValue(yStart - pAnim->y);
    xPos    = pAnim->x;
    yPos    = pAnim->y;
    if (x < xPos) {
      x = xStart + (Pos * Length / 1000);
    } else if (x > xPos) {
      x = xStart - (Pos * Length / 1000);
    } else {
      x = xPos;
    }
    if (y < yPos) {
      y = yStart + (Pos * Length2 / 1000);
    } else if (y > yPos) {
      y = yStart - (Pos * Length2 / 1000);
    } else {
      y = yPos;
    }
  }
  GUI_PID_GetCurrentState(&StateCurrent);
  //
  // Do animation only if PID is outside 'Automode'-button
  //
  if ((StateCurrent.x < 415) || (StateCurrent.x > 445) || (StateCurrent.y < 110) || (StateCurrent.y > 140)) {
    State.x = x;
    State.y = y;
    State.Pressed = pAnim->Pressed;
    GUI_PID_StoreState(&State);
  }
  GUI_Exec();
  return 0;
}

/*********************************************************************
*
*       _DoAnimation
*/
static int _DoAnimation(WM_HWIN hDlg, ANIMATION * pAnim) {
  ANIMATION_ITEM * pItem;
  GUI_TIMER_TIME t1, ts, te, td;
  I32 Pos;
  int r;
  U8 ButtonPressed;
  WM_HWIN       hButton;

  pAnim->t0 = GUI_GetTime();
  t1 = pAnim->t0 + pAnim->Period;
  Pos = 0;
  do {
    ts = GUI_GetTime();
    pItem = pAnim->pFirst;
    while (pItem) {
      Pos = pItem->pfTiming(pAnim, pItem, ts);
      if (Pos > 0) {
        pItem->pfAnim(Pos, (ANIM *)pItem->pVoid);
      }
      pItem = pItem->pNext;
    }
    te = GUI_GetTime();
    td = te - ts;
    if (Pos > 0) {
      if (TIME_PER_FRAME > td) {
        GUI_X_Delay(TIME_PER_FRAME - td);
      } 
    } else {
      GUI_X_Delay(5);
    }
    hButton = WM_GetDialogItem(hDlg, GUI_ID_BUTTON0);
    BUTTON_GetUserData(hButton, &ButtonPressed, sizeof(ButtonPressed));
    r = ButtonPressed ? 0 : 1;
  } while ((te < t1) && (r == 0));
  return r;
}

/*********************************************************************
*
*       _ChangeMemdevColor
*/
static void _ChangeMemdevColor(GUI_MEMDEV_Handle hMem, GUI_COLOR Color) {
  int   NumItems;
  int   xSize, ySize;
  U32 * pData;
  U32   Data;
  
  pData = (U32 *)GUI_MEMDEV_GetDataPtr(hMem);
  xSize = GUI_MEMDEV_GetXSize(hMem);
  ySize = GUI_MEMDEV_GetYSize(hMem);
  NumItems = xSize * ySize;
  while (NumItems) {
    Data   = *pData;
    Data   = Data >> 24;
    Data   = (Data << 24) + (Color & 0xFFFFFF);
    *pData = Data;
    pData++;
    NumItems--;
  }
}

/*********************************************************************
*
*       _GetVolume
*/
static int _GetVolume(KNOB_Handle hKnob) {
  I32 Value;
  int ySize;
  
  ySize = 130;
  Value = ((7200 - KNOB_GetValue(hKnob)) * ySize + 64800) / 72000;
  return Value;
}

/*********************************************************************
*
*       _DrawVol
*/
static void _DrawVol(int x0, int y0, int ySize, KNOB_Handle hKnob, int PowerOn) {
  I32 Value;
  int i;
  
  Value = (7200 - KNOB_GetValue(hKnob)) * ySize / 7200;
  for (i = 0; i < ySize; i += 10) {
    if ((i < Value) && (PowerOn == 2) && (i < 44)) {
      GUI_DrawBitmap(&bmvolume_green_37x7, x0 + 2, ySize + y0 - 8 - i);
    } else if((i < Value) && (PowerOn == 2) && (i < 86) && (i > 43)) {
      GUI_DrawBitmap(&bmvolume_yellow_37x7, x0 + 2, ySize + y0 - 8 - i);
    } else if((i < Value) && (PowerOn == 2) && (i > 85)) {
      GUI_DrawBitmap(&bmvolume_red_37x7, x0 + 2, ySize + y0 - 8 - i);
    } else {
      GUI_SetColor(AMP_COLOR_GRAY);
      GUI_DrawBitmap(&bmvolume_trans_37x7, x0 + 2, ySize + y0 - 8 - i);
    } 
  }
}

/*********************************************************************
*
*       _cbButton
*/
static void _cbButton(WM_MESSAGE * pMsg) {
  WM_HWIN  hWin;

  hWin  = pMsg->hWin;
  switch (pMsg->MsgId) {
  case WM_PAINT:
    if (BUTTON_IsPressed(hWin)) {
      GUI_DrawBitmap(&bmknob_black_trans_30x30, 0, 0);
    } else {
      GUI_DrawBitmap(&bmknob_gray_trans_30x30, 0, 0);
    }
    break;
  default:
    BUTTON_Callback(pMsg);
  }
}

/*********************************************************************
*
*       _cbDialog
*/
static void _cbDialog(WM_MESSAGE * pMsg) {
  static GUI_MEMDEV_Handle   hMemKnobBig;
  static GUI_MEMDEV_Handle   hMemKnobSmall;
  static GUI_COLOR           ColorKnob        = GUI_BLACK;
  static WM_HTIMER           hTimer;
  ANIMATION_ITEM             AnimCursor       = {0};
  BUTTON_Handle              hButton;
  KNOB_Handle                hKnob;
  static U8                  Index;
  static U8                  aScaleChange[4]  = {0};
  static U8                  ButtonPressed    = 1;
  static U8                  VolumeChange     = 0;
  ANIMATION                  Anim;
  static U8                  PowerOn;
  GUI_RECT                   Rect;
  WM_HWIN                    hParent;
  WM_HWIN                    hWin;
  ANIM                     * pAnim;
  int                        NCode;
  int                        Id;
  int                        Scale;
  U8                         i;
  U8                         Value;

  hWin      = pMsg->hWin;
  pAnim     = &_aAnim[Index];
  switch (pMsg->MsgId) {
  case WM_TIMER:
    //
    // Start animation
    //
    if (ButtonPressed) {
      AnimCursor.ts         = 0;
      AnimCursor.te         = pAnim->ExecTime;
      AnimCursor.pfAnim     = _MoveCursor;
      AnimCursor.pVoid      = pAnim;
      AnimCursor.pfTiming   = pAnim->pfAnimType;
      Anim.pFirst           = &AnimCursor;
      Anim.Period           = pAnim->ExecTime;
      if (_DoAnimation(pMsg->hWin, &Anim) == 0) {
        WM_RestartTimer(hTimer, 1);
      }
      Index = (Index == (GUI_COUNTOF(_aAnim) - 1)) ? 0 : Index + 1;
    }
    break;
  case WM_INIT_DIALOG:
    //
    // Create and fill memory devices
    //
    hMemKnobBig   = GUI_MEMDEV_CreateFixed32(0, 0, 140, 20);
    _DrawKnobBig(hMemKnobBig, ColorKnob);
    hMemKnobSmall = GUI_MEMDEV_CreateFixed32(0, 0,  70, 20);
    _DrawKnob(hMemKnobSmall, ColorKnob);
    //
    // Init KNOB on/off
    //
    hKnob = WM_GetDialogItem(hWin, GUI_ID_KNOB0);
    KNOB_SetDevice(hKnob, hMemKnobSmall);
    KNOB_SetTickSize(hKnob, 450);
    KNOB_SetRange(hKnob, 0, 2);
    KNOB_SetOffset(hKnob, 450);
    KNOB_SetPeriod(hKnob,  10);
    //
    // Init KNOB volume
    //
    hKnob = WM_GetDialogItem(hWin, GUI_ID_KNOB1);
    KNOB_SetDevice(hKnob, hMemKnobBig);
    KNOB_SetRange(hKnob, -7200, 0);
    KNOB_SetOffset(hKnob, 1800);
    KNOB_SetPeriod(hKnob,  500);
    //
    // Init KNOB "Gain", "High", "Middle", "Low"
    //
    for (i = 0; i < 4; i++) {
      hKnob = WM_GetDialogItem(hWin, GUI_ID_KNOB2 + i);
      KNOB_SetDevice(hKnob, hMemKnobSmall);
      KNOB_SetRange(hKnob, -2700, 0);
      KNOB_SetOffset(hKnob, -1350);
      KNOB_SetPeriod(hKnob,   500);
    }
    //
    // Init 'Automode'-button
    //
    hButton = WM_GetDialogItem(hWin, GUI_ID_BUTTON0);
    WM_SetHasTrans(hButton);
    WM_SetCallback(hButton, _cbButton);
    BUTTON_SetUserData(hButton, &ButtonPressed, sizeof(ButtonPressed));
    //
    // Start animation at the beginning
    //
    if (!hTimer) {
      GUI_CURSOR_SetPosition(START_POS_CURSOR_X, START_POS_CURSOR_Y);
      GUI_CURSOR_Show();
      hTimer = WM_CreateTimer(hWin, 0, 1500, 0);
    }
    break;
  case WM_PAINT:
    //
    // Draw background
    //
    GUI_DrawBitmap(&bmBackground_480x272, 0, 0);
    //
    // Draw scale
    //
    for (i = 0; i <= 3; i++) {
      hKnob = WM_GetDialogItem(hWin, GUI_ID_KNOB2 + i);
      _DrawScale(hKnob, PowerOn);
    }
    //
    // Draw volume bar
    //
    hKnob = WM_GetDialogItem(hWin, GUI_ID_KNOB1);
    _DrawVol(225, 120,  130, hKnob, PowerOn);
    //
    // KNOB on/off
    //
    switch (PowerOn) {
    case 1:
      GUI_DrawBitmap(&bmpower_red_trans_12x12, 50, 160);
      break;
    case 2:
      GUI_DrawBitmap(&bmpower_green_trans_12x12, 50, 160);
      break;
    default:
      GUI_DrawBitmap(&bmpower_gray_trans_12x12, 50, 160);
      break;
    }
    //
    // Auto. button background
    //
    if (ButtonPressed) {
      GUI_SetColor(GUI_GREEN);
    } else {
      GUI_SetColor(AMP_COLOR_GRAY);
    }
    GUI_DrawBitmap(&bmknobbk_trans_34x34, 415 - 2, 110 - 2);
    break;
  case WM_NOTIFY_PARENT:
    Id    = WM_GetId(pMsg->hWinSrc);                  // Id of widget
    NCode = pMsg->Data.v;                             // Notification code
    switch (NCode) {
    case WM_NOTIFICATION_VALUE_CHANGED:               // Value has changed
      switch (Id) {
      case GUI_ID_KNOB0:                              // On, off, standby
        hKnob = WM_GetDialogItem(hWin, GUI_ID_KNOB0);
        Value = KNOB_GetValue(hKnob) / 450;
        if (PowerOn != Value) {
          PowerOn = Value;
          if (PowerOn == 1) {
            ColorKnob = GUI_GREEN;
          } else if (PowerOn == 2) {
            ColorKnob = GUI_GREEN;
          }else {
            ColorKnob = GUI_BLACK;
          }
          //
          // Change KNOB color
          //
          _ChangeMemdevColor(hMemKnobSmall, ColorKnob);
          _ChangeMemdevColor(hMemKnobBig, ColorKnob);
          WM_InvalidateWindow(hWin);
        }
        break;
      case GUI_ID_KNOB1:                              // Volume
        hKnob = WM_GetDialogItem(hWin, Id);
        Value = _GetVolume(hKnob);
        if (Value != VolumeChange) {
          WM_GetWindowRectEx(hKnob, &Rect);
          Rect.x0 = 225;
          Rect.y0 = 120;
          Rect.x1 = 266; 
          Rect.y1 = 251; 
          hParent = WM_GetParent(hKnob);
          WM_InvalidateRect(hParent, &Rect);
          VolumeChange = Value;
        }
        break;
      case GUI_ID_KNOB2:                              // Gain
      case GUI_ID_KNOB3:                              // High
      case GUI_ID_KNOB4:                              // Middle
      case GUI_ID_KNOB5:                              // Low 
        hKnob = WM_GetDialogItem(hWin, Id);
        Scale = _GetScale(hKnob);
        if (aScaleChange[Id - GUI_ID_KNOB2] != Scale) {
          aScaleChange[Id - GUI_ID_KNOB2] = Scale;
          WM_GetWindowRectEx(hKnob, &Rect);
          Rect.x0 -= 10;
          Rect.y0 -= 10;
          Rect.x1 += 10;
          Rect.y1 += 10;
          hParent  = WM_GetParent(hKnob);
          WM_InvalidateRect(hParent, &Rect);
        }
        break;
      }
      break;
    case WM_NOTIFICATION_RELEASED:
      switch (Id) {
      case GUI_ID_BUTTON0:
        hButton = WM_GetDialogItem(hWin, GUI_ID_BUTTON0);
        if (ButtonPressed) {
          //
          // Stop animation
          //
          ButtonPressed = 0;
          GUI_CURSOR_Hide();
        } else {
          ButtonPressed = 1;
          GUI_CURSOR_Show();
          for (i = 0; i <= 5; i++) {
            //
            // Set knobs to 0
            //
            hKnob = WM_GetDialogItem(hWin, GUI_ID_KNOB0 + i);
            KNOB_SetPos(hKnob, 0);
          }
          Index = 0;
          WM_InvalidateWindow(hWin);
          if (hTimer) {
            WM_RestartTimer(hTimer, 100);
          }
        }
        BUTTON_SetUserData(hButton, &ButtonPressed, sizeof(ButtonPressed));
        WM_GetWindowRectEx(hButton, &Rect);
        Rect.x0 -= 10;
        Rect.y0 -= 10;
        Rect.x1 += 10;
        Rect.y1 += 10;
        hParent  = WM_GetParent(hButton);
        WM_InvalidateRect(hParent, &Rect);
        break;
      }
      break;
  }
  default:
    WM_DefaultProc(pMsg);
    break;
  }
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/
void MainTask(void) { 
  //
  // Check if recommended memory for the sample is available
  //
  if (GUI_ALLOC_GetNumFreeBytes() < RECOMMENDED_MEMORY) {
    GUI_ErrorOut("Not enough memory available."); 
    return;
  }
  WM_SetCreateFlags(WM_CF_MEMDEV);
  while (1) {
    GUI_ExecDialogBox(_aDialogCreate, GUI_COUNTOF(_aDialogCreate), _cbDialog, WM_HBKWIN, 0, 0);
    GUI_Delay(100);
  }
}

/*************************** End of file ****************************/
