/**********************************************************************
*                 SEGGER Software GmbH                               *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2019  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product. This file may
only be used in accordance with the following terms:

The  software has  been licensed by SEGGER Software GmbH to Realtek 
Semiconductor Corp. at the address: Realtek Semiconductor Corp., 
Hsinchu Science Park, Innovation Rd. II 2, 300 Hsinchu city, Taiwan for 
the purposes  of  creating  libraries  for its Cortex-M series of 
Microcontroller Units designed, branded, marketed and manufactured by 
Realtek Semiconductor Corp. under the terms and conditions of an End 
User License Agreement supplied with the libraries.

Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Software GmbH
Licensed to:              Realtek Semiconductor Corp., Hsinchu Science Park, Innovation Rd. II 2, 300 Hsinchu city, Taiwan
Licensed SEGGER software: emWin
License number:           GUI-00784
License model:            emWin Buyout Agreement, signed May 15th, 2019
Licensed platform:        Cortex-M series of Microcontroller Units designed, branded, marketed and manufactured by LICENSEE
----------------------------------------------------------------------
File        : MEMDEV_BitmapSpeedometer.c
Purpose     : Shows how to use memory devices for rotation.
Requirements: WindowManager - ( )
              MemoryDevices - (x)
              AntiAliasing  - (x)
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
---------------------------END-OF-HEADER------------------------------
*/
#include <stdlib.h>

#include "GUI.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define COLOR_BACK0    GUI_MAKE_COLOR(0xFF3333)
#define COLOR_BACK1    GUI_MAKE_COLOR(0x550000)
#define COLOR_NEEDLE   GUI_MAKE_COLOR(0x2080FF)
#define R_CHECK  75
#define R_RING  110
#define R_KNOB   10
#define T_MAX       10000
#define T_ROLL       2000
#define MAG 6
#define T_MIN_FRAME  20

#if (GUI_USE_ARGB == 1)
  #define COLOR_CONV GUICC_M8888I
#else
  #define COLOR_CONV GUICC_8888
#endif

//
// Recommended memory to run the sample with adequate performance
//
#define RECOMMENDED_MEMORY (1024L * 1300)

/*********************************************************************
*
*       Static (const) data
*
**********************************************************************
*/
static const char _acText[] = "Speedometer\nDemo\n";

/*********************************************************************
*
*       GUI_FontRounded16 (needed to display "kmh" - "mph")
*/
GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0057[ 66] = { // Code 0057, LATIN CAPITAL LETTER W
  0x46, 0x00, 0x06, 0x70, 0x00, 0x64,
  0xDF, 0x20, 0x2F, 0xF3, 0x01, 0xFD,
  0xAF, 0x60, 0x6F, 0xF7, 0x05, 0xFA,
  0x6F, 0x90, 0x9E, 0xEA, 0x08, 0xF7,
  0x2F, 0xC0, 0xDB, 0xAE, 0x0B, 0xF3,
  0x0E, 0xF2, 0xF7, 0x7F, 0x2E, 0xE0,
  0x09, 0xF7, 0xF4, 0x3F, 0x7F, 0xA0,
  0x06, 0xFE, 0xF0, 0x0E, 0xEF, 0x60,
  0x02, 0xFF, 0xB0, 0x0B, 0xFF, 0x20,
  0x00, 0xCF, 0x70, 0x06, 0xFD, 0x00,
  0x00, 0x12, 0x00, 0x00, 0x21, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0065[ 32] = { // Code 0065, LATIN SMALL LETTER E
  0x02, 0xAE, 0xEB, 0x20,
  0x0D, 0xE7, 0x7E, 0xE1,
  0x6F, 0x82, 0x28, 0xF6,
  0x7F, 0xFF, 0xFF, 0xF6,
  0x7F, 0x70, 0x00, 0x30,
  0x2E, 0xE7, 0x6C, 0xF1,
  0x04, 0xDF, 0xFE, 0x70,
  0x00, 0x02, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0068[ 44] = { // Code 0068, LATIN SMALL LETTER H
  0x07, 0x30, 0x00, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x4F, 0xAA, 0xED, 0x50,
  0x4F, 0xFB, 0xAF, 0xF1,
  0x4F, 0xC0, 0x0C, 0xF3,
  0x4F, 0x90, 0x0B, 0xF4,
  0x4F, 0x90, 0x0B, 0xF4,
  0x4F, 0x90, 0x0B, 0xF4,
  0x3F, 0x90, 0x0A, 0xF2,
  0x02, 0x00, 0x00, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0069[ 22] = { // Code 0069, LATIN SMALL LETTER I
  0x07, 0x40,
  0x2F, 0xB0,
  0x04, 0x20,
  0x1E, 0x80,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x1F, 0xA0,
  0x01, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006B[ 44] = { // Code 006B, LATIN SMALL LETTER K
  0x07, 0x30, 0x00, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x4F, 0x90, 0x5E, 0x30,
  0x4F, 0x94, 0xFE, 0x20,
  0x4F, 0xCE, 0xE3, 0x00,
  0x4F, 0xFF, 0xE2, 0x00,
  0x4F, 0xD8, 0xFC, 0x00,
  0x4F, 0x90, 0xBF, 0x80,
  0x3F, 0x90, 0x2E, 0xB0,
  0x01, 0x00, 0x01, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006D[ 48] = { // Code 006D, LATIN SMALL LETTER M
  0x2E, 0x69, 0xED, 0x38, 0xEE, 0x70,
  0x4F, 0xEB, 0xBF, 0xED, 0xAF, 0xF3,
  0x4F, 0xC0, 0x0F, 0xF2, 0x0A, 0xF4,
  0x4F, 0x90, 0x0F, 0xF0, 0x09, 0xF4,
  0x4F, 0x90, 0x0F, 0xF0, 0x09, 0xF4,
  0x4F, 0x90, 0x0F, 0xF0, 0x09, 0xF4,
  0x3F, 0x90, 0x0D, 0xE0, 0x08, 0xF3,
  0x02, 0x00, 0x01, 0x10, 0x00, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006E[ 32] = { // Code 006E, LATIN SMALL LETTER N
  0x2E, 0x6A, 0xED, 0x50,
  0x4F, 0xFB, 0xAF, 0xF1,
  0x4F, 0xC0, 0x0C, 0xF3,
  0x4F, 0x90, 0x0B, 0xF4,
  0x4F, 0x90, 0x0B, 0xF4,
  0x4F, 0x90, 0x0B, 0xF4,
  0x3F, 0x90, 0x0A, 0xF2,
  0x02, 0x00, 0x00, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0070[ 40] = { // Code 0070, LATIN SMALL LETTER P
  0x2E, 0x7B, 0xFC, 0x30,
  0x4F, 0xFA, 0x9F, 0xE1,
  0x4F, 0xB0, 0x0A, 0xF5,
  0x4F, 0x80, 0x06, 0xF7,
  0x4F, 0xA0, 0x08, 0xF6,
  0x4F, 0xF7, 0x7E, 0xF2,
  0x4F, 0xBD, 0xFF, 0x50,
  0x4F, 0x90, 0x21, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x19, 0x40, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontRounded16_CharInfo[8] = {
   {  12,  11,   0,   3,  12, acGUI_FontRounded16_0057 } // Code 0057, LATIN CAPITAL LETTER W
  ,{   8,   8,   0,   6,   8, acGUI_FontRounded16_0065 } // Code 0065, LATIN SMALL LETTER E
  ,{   8,  11,   0,   3,   8, acGUI_FontRounded16_0068 } // Code 0068, LATIN SMALL LETTER H
  ,{   3,  11,   0,   3,   4, acGUI_FontRounded16_0069 } // Code 0069, LATIN SMALL LETTER I
  ,{   7,  11,   0,   3,   7, acGUI_FontRounded16_006B } // Code 006B, LATIN SMALL LETTER K
  ,{  12,   8,   0,   6,  12, acGUI_FontRounded16_006D } // Code 006D, LATIN SMALL LETTER M
  ,{   8,   8,   0,   6,   8, acGUI_FontRounded16_006E } // Code 006E, LATIN SMALL LETTER N
  ,{   8,  10,   0,   6,   8, acGUI_FontRounded16_0070 } // Code 0070, LATIN SMALL LETTER P
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded16_Prop6 = {
   0x0070                                   // First character
  ,0x0070                                   // Last character 
  ,&GUI_FontRounded16_CharInfo[  7]         // Address of first character
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded16_Prop5 = {
   0x006D                                   // First character
  ,0x006E                                   // Last character 
  ,&GUI_FontRounded16_CharInfo[  5]         // Address of first character
  ,&GUI_FontRounded16_Prop6                 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded16_Prop4 = {
   0x006B                                   // First character
  ,0x006B                                   // Last character 
  ,&GUI_FontRounded16_CharInfo[  4]         // Address of first character
  ,&GUI_FontRounded16_Prop5                 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded16_Prop3 = {
   0x0068                                   // First character
  ,0x0069                                   // Last character 
  ,&GUI_FontRounded16_CharInfo[  2]         // Address of first character
  ,&GUI_FontRounded16_Prop4                 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded16_Prop2 = {
   0x0065                                   // First character
  ,0x0065                                   // Last character 
  ,&GUI_FontRounded16_CharInfo[  1]         // Address of first character
  ,&GUI_FontRounded16_Prop3                 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded16_Prop1 = {
   0x0057                                   // First character
  ,0x0057                                   // Last character 
  ,&GUI_FontRounded16_CharInfo[  0]         // Address of first character
  ,&GUI_FontRounded16_Prop2                 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT GUI_FontRounded16 = {
   GUI_FONTTYPE_PROP_AA4_EXT // type of font   
  ,16 // height of font 
  ,16 // space of font y
  ,1  // magnification x
  ,1  // magnification y
  ,{&GUI_FontRounded16_Prop1}
  ,16 // Baseline
  ,8  // Height of lowercase characters
  ,11 // Height of capital characters
};

/*********************************************************************
*
*       GUI_FontDigit19 (needed for digital display)
*/
GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0030[133] = { // Code 0030, DIGIT ZERO
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x7C, 0xFF, 0xFB, 0x40, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0x9F, 0xFF, 0xED, 0xFF, 0xFF, 0x50,
  0x03, 0xFF, 0xFA, 0x00, 0x2D, 0xFF, 0xD0,
  0x08, 0xFF, 0xF1, 0x00, 0x05, 0xFF, 0xF3,
  0x0C, 0xFF, 0xB0, 0x00, 0x01, 0xFF, 0xF7,
  0x0E, 0xFF, 0x80, 0x00, 0x00, 0xDF, 0xFA,
  0x0F, 0xFF, 0x70, 0x00, 0x00, 0xBF, 0xFB,
  0x0F, 0xFF, 0x70, 0x00, 0x00, 0xBF, 0xFB,
  0x0F, 0xFF, 0x70, 0x00, 0x00, 0xBF, 0xFB,
  0x0E, 0xFF, 0x80, 0x00, 0x00, 0xDF, 0xF9,
  0x0C, 0xFF, 0xA0, 0x00, 0x00, 0xFF, 0xF7,
  0x08, 0xFF, 0xE0, 0x00, 0x03, 0xFF, 0xF4,
  0x03, 0xFF, 0xF7, 0x00, 0x0B, 0xFF, 0xE0,
  0x00, 0xBF, 0xFF, 0xB9, 0xCF, 0xFF, 0x60,
  0x00, 0x2E, 0xFF, 0xFF, 0xFF, 0xFA, 0x00,
  0x00, 0x01, 0xAF, 0xFF, 0xFE, 0x70, 0x00,
  0x00, 0x00, 0x01, 0x44, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0031[133] = { // Code 0031, DIGIT ONE
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x70,
  0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x4E, 0xFF, 0xB0,
  0x00, 0x00, 0x04, 0x8C, 0xFF, 0xFF, 0xB0,
  0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xB0,
  0x00, 0x00, 0x2E, 0xFF, 0xFF, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x22, 0x2D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x09, 0xFF, 0x70,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0032[126] = { // Code 0032, DIGIT TWO
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x8D, 0xFF, 0xFB, 0x50, 0x00,
  0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0x04, 0xFF, 0xFF, 0xED, 0xFF, 0xFF, 0xA0,
  0x0D, 0xFF, 0xE4, 0x00, 0x2D, 0xFF, 0xF2,
  0x1F, 0xFF, 0x70, 0x00, 0x05, 0xFF, 0xF6,
  0x1F, 0xFF, 0x10, 0x00, 0x04, 0xFF, 0xF5,
  0x06, 0xB6, 0x00, 0x00, 0x08, 0xFF, 0xF3,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0xFF, 0xC0,
  0x00, 0x00, 0x00, 0x2A, 0xFF, 0xFE, 0x30,
  0x00, 0x00, 0x06, 0xEF, 0xFF, 0xD3, 0x00,
  0x00, 0x02, 0xBF, 0xFF, 0xE7, 0x00, 0x00,
  0x00, 0x3E, 0xFF, 0xFA, 0x10, 0x00, 0x00,
  0x02, 0xEF, 0xFD, 0x40, 0x00, 0x00, 0x00,
  0x0B, 0xFF, 0xE1, 0x00, 0x00, 0x00, 0x00,
  0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7,
  0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD3
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0033[133] = { // Code 0033, DIGIT THREE
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xAE, 0xFF, 0xEA, 0x30, 0x00,
  0x00, 0x9F, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x07, 0xFF, 0xFF, 0xDE, 0xFF, 0xFF, 0x30,
  0x0C, 0xFF, 0xD2, 0x00, 0x5F, 0xFF, 0x70,
  0x0C, 0xFF, 0x30, 0x00, 0x0C, 0xFF, 0x90,
  0x03, 0x75, 0x00, 0x00, 0x0C, 0xFF, 0x80,
  0x00, 0x00, 0x00, 0x13, 0x8F, 0xFF, 0x20,
  0x00, 0x00, 0x06, 0xFF, 0xFF, 0xE5, 0x00,
  0x00, 0x00, 0x09, 0xFF, 0xFF, 0xFA, 0x10,
  0x00, 0x00, 0x01, 0x8B, 0xEF, 0xFF, 0x90,
  0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF1,
  0x03, 0x72, 0x00, 0x00, 0x08, 0xFF, 0xF2,
  0x2F, 0xFD, 0x00, 0x00, 0x09, 0xFF, 0xF2,
  0x3F, 0xFF, 0x80, 0x00, 0x2E, 0xFF, 0xD0,
  0x0D, 0xFF, 0xFC, 0x9A, 0xEF, 0xFF, 0x70,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xFA, 0x00,
  0x00, 0x2A, 0xFF, 0xFF, 0xFD, 0x60, 0x00,
  0x00, 0x00, 0x14, 0x44, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0034[133] = { // Code 0034, DIGIT FOUR
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xAF, 0xE3, 0x00,
  0x00, 0x00, 0x00, 0x08, 0xFF, 0xF7, 0x00,
  0x00, 0x00, 0x00, 0x5F, 0xFF, 0xF7, 0x00,
  0x00, 0x00, 0x02, 0xEF, 0xFF, 0xF7, 0x00,
  0x00, 0x00, 0x1C, 0xFD, 0xEF, 0xF7, 0x00,
  0x00, 0x00, 0xAF, 0xF3, 0xDF, 0xF7, 0x00,
  0x00, 0x07, 0xFF, 0x60, 0xDF, 0xF7, 0x00,
  0x00, 0x3F, 0xFA, 0x00, 0xDF, 0xF7, 0x00,
  0x01, 0xEF, 0xD1, 0x00, 0xDF, 0xF7, 0x00,
  0x0B, 0xFF, 0x30, 0x00, 0xDF, 0xF7, 0x00,
  0x7F, 0xFD, 0x99, 0x99, 0xEF, 0xFC, 0x95,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x4F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
  0x01, 0x22, 0x22, 0x22, 0xDF, 0xF8, 0x20,
  0x00, 0x00, 0x00, 0x00, 0xDF, 0xF7, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xDF, 0xF7, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xAF, 0xF5, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x30, 0x00,
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0035[126] = { // Code 0035, DIGIT FIVE
  0x00, 0x4B, 0xBB, 0xBB, 0xBB, 0xB9, 0x00,
  0x00, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0x40,
  0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x20,
  0x05, 0xFF, 0xA4, 0x44, 0x44, 0x42, 0x00,
  0x07, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0xFF, 0x40, 0x12, 0x10, 0x00, 0x00,
  0x0C, 0xFF, 0x7D, 0xFF, 0xFD, 0x60, 0x00,
  0x0E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x00,
  0x0E, 0xFF, 0xEA, 0x8B, 0xFF, 0xFF, 0x60,
  0x04, 0xB8, 0x10, 0x00, 0x3E, 0xFF, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0x09, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x06, 0xFF, 0xF2,
  0x07, 0xB4, 0x00, 0x00, 0x09, 0xFF, 0xF0,
  0x3F, 0xFE, 0x30, 0x00, 0x3F, 0xFF, 0xB0,
  0x2F, 0xFF, 0xF9, 0x69, 0xFF, 0xFF, 0x40,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0x5D, 0xFF, 0xFF, 0xFB, 0x40, 0x00,
  0x00, 0x00, 0x24, 0x44, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0036[133] = { // Code 0036, DIGIT SIX
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x4A, 0xEF, 0xFE, 0xA3, 0x00,
  0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0x40,
  0x00, 0x7F, 0xFF, 0xC8, 0x9F, 0xFF, 0xD0,
  0x01, 0xEF, 0xF9, 0x00, 0x05, 0xFF, 0xD0,
  0x06, 0xFF, 0xE0, 0x00, 0x00, 0x49, 0x30,
  0x0A, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00,
  0x0D, 0xFF, 0x73, 0xAD, 0xDC, 0x81, 0x00,
  0x0F, 0xFF, 0xDF, 0xFF, 0xFF, 0xFE, 0x30,
  0x0F, 0xFF, 0xFF, 0xC9, 0xCF, 0xFF, 0xE1,
  0x0F, 0xFF, 0xF6, 0x00, 0x07, 0xFF, 0xF7,
  0x0F, 0xFF, 0xC0, 0x00, 0x00, 0xDF, 0xFA,
  0x0E, 0xFF, 0x90, 0x00, 0x00, 0xBF, 0xFB,
  0x0B, 0xFF, 0xB0, 0x00, 0x00, 0xDF, 0xFA,
  0x06, 0xFF, 0xF4, 0x00, 0x04, 0xFF, 0xF7,
  0x00, 0xDF, 0xFE, 0x96, 0x9F, 0xFF, 0xE1,
  0x00, 0x3E, 0xFF, 0xFF, 0xFF, 0xFF, 0x40,
  0x00, 0x02, 0xAF, 0xFF, 0xFF, 0xB3, 0x00,
  0x00, 0x00, 0x01, 0x44, 0x41, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0037[126] = { // Code 0037, DIGIT SEVEN
  0x3B, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0x80,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2,
  0x03, 0x44, 0x44, 0x44, 0x4D, 0xFF, 0x70,
  0x00, 0x00, 0x00, 0x00, 0x9F, 0xF9, 0x00,
  0x00, 0x00, 0x00, 0x05, 0xFF, 0xC0, 0x00,
  0x00, 0x00, 0x00, 0x1E, 0xFF, 0x30, 0x00,
  0x00, 0x00, 0x00, 0xAF, 0xF9, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFF, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0xFF, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xFF, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0xFD, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xEF, 0xF9, 0x00, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x09, 0xFF, 0xF1, 0x00, 0x00, 0x00,
  0x00, 0x0B, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0x60, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x33, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0038[133] = { // Code 0038, DIGIT EIGHT
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x9D, 0xFF, 0xFC, 0x71, 0x00,
  0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xFD, 0x20,
  0x01, 0xEF, 0xFF, 0xA8, 0xBF, 0xFF, 0xB0,
  0x07, 0xFF, 0xF3, 0x00, 0x07, 0xFF, 0xF2,
  0x09, 0xFF, 0xC0, 0x00, 0x02, 0xFF, 0xF4,
  0x07, 0xFF, 0xE0, 0x00, 0x03, 0xFF, 0xF2,
  0x01, 0xEF, 0xF9, 0x32, 0x4D, 0xFF, 0xB0,
  0x00, 0x3E, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0x00, 0x6E, 0xFF, 0xFF, 0xFF, 0xFC, 0x30,
  0x05, 0xFF, 0xFC, 0x54, 0x7E, 0xFF, 0xE2,
  0x0D, 0xFF, 0xD1, 0x00, 0x03, 0xFF, 0xF8,
  0x0F, 0xFF, 0x80, 0x00, 0x00, 0xCF, 0xFB,
  0x0F, 0xFF, 0x80, 0x00, 0x00, 0xCF, 0xFB,
  0x0D, 0xFF, 0xD1, 0x00, 0x04, 0xFF, 0xF8,
  0x07, 0xFF, 0xFD, 0x86, 0x9F, 0xFF, 0xF3,
  0x00, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x00, 0x06, 0xDF, 0xFF, 0xFF, 0xB4, 0x00,
  0x00, 0x00, 0x02, 0x44, 0x31, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0039[133] = { // Code 0039, DIGIT NINE
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x9D, 0xFF, 0xEB, 0x40, 0x00,
  0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x03, 0xFF, 0xFF, 0xBA, 0xEF, 0xFF, 0x60,
  0x0A, 0xFF, 0xF3, 0x00, 0x0B, 0xFF, 0xE1,
  0x0E, 0xFF, 0x90, 0x00, 0x02, 0xFF, 0xF5,
  0x0F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xF8,
  0x0F, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0xFB,
  0x0D, 0xFF, 0xD1, 0x00, 0x07, 0xFF, 0xFB,
  0x07, 0xFF, 0xFD, 0x76, 0xAF, 0xFF, 0xFB,
  0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFA,
  0x00, 0x07, 0xDF, 0xFF, 0xD4, 0xBF, 0xF9,
  0x00, 0x00, 0x02, 0x21, 0x00, 0xDF, 0xF6,
  0x00, 0x25, 0x00, 0x00, 0x02, 0xFF, 0xF2,
  0x02, 0xEF, 0xA0, 0x00, 0x0B, 0xFF, 0xC0,
  0x03, 0xFF, 0xFB, 0x45, 0xBF, 0xFF, 0x40,
  0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0x18, 0xFF, 0xFF, 0xFC, 0x50, 0x00,
  0x00, 0x00, 0x13, 0x44, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontDigit19_CharInfo[10] = {
   {  14,  19,   0,   6,  15, acGUI_FontDigit19_0030 } // Code 0030, DIGIT ZERO
  ,{  13,  19,  -1,   6,  15, acGUI_FontDigit19_0031 } // Code 0031, DIGIT ONE
  ,{  14,  18,   0,   6,  15, acGUI_FontDigit19_0032 } // Code 0032, DIGIT TWO
  ,{  14,  19,   0,   6,  15, acGUI_FontDigit19_0033 } // Code 0033, DIGIT THREE
  ,{  14,  19,   0,   6,  15, acGUI_FontDigit19_0034 } // Code 0034, DIGIT FOUR
  ,{  14,  18,   0,   7,  15, acGUI_FontDigit19_0035 } // Code 0035, DIGIT FIVE
  ,{  14,  19,   0,   6,  15, acGUI_FontDigit19_0036 } // Code 0036, DIGIT SIX
  ,{  14,  18,   0,   7,  15, acGUI_FontDigit19_0037 } // Code 0037, DIGIT SEVEN
  ,{  14,  19,   0,   6,  15, acGUI_FontDigit19_0038 } // Code 0038, DIGIT EIGHT
  ,{  14,  19,   0,   6,  15, acGUI_FontDigit19_0039 } // Code 0039, DIGIT NINE
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontDigit19_Prop1 = {
   0x0030                                   // First character
  ,0x0039                                   // Last character 
  ,&GUI_FontDigit19_CharInfo[  0]           // Address of first character
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT GUI_FontDigit19 = {
   GUI_FONTTYPE_PROP_AA4_EXT // type of font   
  ,30 // height of font 
  ,30 // space of font y
  ,1  // magnification x
  ,1  // magnification y
  ,{&GUI_FontDigit19_Prop1}
  ,30 // Baseline
  ,14 // Height of lowercase characters
  ,19 // Height of capital characters
};

/*********************************************************************
*
*       GUI_FontDigit19 (needed for digital display)
*/
GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0020[  1] = { // Code 0020, SPACE
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0021[ 63] = { // Code 0021, EXCLAMATION MARK
  0x2A, 0xB7, 0x00,
  0xBF, 0xFF, 0x40,
  0xDF, 0xFF, 0x60,
  0xDF, 0xFF, 0x60,
  0xDF, 0xFF, 0x60,
  0xDF, 0xFF, 0x60,
  0xCF, 0xFF, 0x50,
  0xAF, 0xFF, 0x30,
  0x8F, 0xFF, 0x10,
  0x6F, 0xFE, 0x00,
  0x4F, 0xFC, 0x00,
  0x2F, 0xFA, 0x00,
  0x0F, 0xF8, 0x00,
  0x0B, 0xF4, 0x00,
  0x00, 0x00, 0x00,
  0x02, 0x30, 0x00,
  0x6F, 0xFC, 0x10,
  0xDF, 0xFF, 0x60,
  0xDF, 0xFF, 0x60,
  0x5F, 0xFB, 0x10,
  0x01, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0022[ 45] = { // Code 0022, QUOTATION MARK
  0x06, 0xB8, 0x00, 0x3B, 0xA1,
  0x1F, 0xFF, 0x50, 0xCF, 0xF8,
  0x2F, 0xFF, 0x60, 0xDF, 0xF9,
  0x2F, 0xFF, 0x60, 0xDF, 0xF9,
  0x2F, 0xFF, 0x60, 0xDF, 0xF9,
  0x2F, 0xFF, 0x60, 0xDF, 0xF9,
  0x2F, 0xFF, 0x60, 0xDF, 0xF9,
  0x0D, 0xFF, 0x30, 0xAF, 0xF6,
  0x01, 0x63, 0x00, 0x05, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0023[168] = { // Code 0023, NUMBER SIGN
  0x00, 0x00, 0x02, 0x20, 0x00, 0x12, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xF2, 0x03, 0xFF, 0x40, 0x00,
  0x00, 0x00, 0x8F, 0xF3, 0x07, 0xFF, 0x50, 0x00,
  0x00, 0x00, 0xAF, 0xF1, 0x08, 0xFF, 0x30, 0x00,
  0x00, 0x00, 0xCF, 0xE0, 0x0B, 0xFF, 0x10, 0x00,
  0x00, 0x00, 0xFF, 0xC0, 0x0C, 0xFE, 0x00, 0x00,
  0x03, 0x9A, 0xFF, 0xD9, 0x9F, 0xFE, 0x97, 0x00,
  0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0x00, 0x08, 0xFF, 0x30, 0x6F, 0xF5, 0x00, 0x00,
  0x00, 0x0A, 0xFF, 0x10, 0x8F, 0xF3, 0x00, 0x00,
  0x00, 0x0C, 0xFE, 0x00, 0xAF, 0xF1, 0x00, 0x00,
  0x3B, 0xBF, 0xFF, 0xBB, 0xEF, 0xFB, 0xA1, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x00,
  0x3B, 0xCF, 0xFD, 0xBC, 0xFF, 0xEB, 0xA1, 0x00,
  0x00, 0x6F, 0xF6, 0x03, 0xFF, 0x80, 0x00, 0x00,
  0x00, 0x8F, 0xF3, 0x06, 0xFF, 0x60, 0x00, 0x00,
  0x00, 0xAF, 0xF2, 0x08, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0xCF, 0xF0, 0x0A, 0xFF, 0x20, 0x00, 0x00,
  0x00, 0xCF, 0xB0, 0x0A, 0xFD, 0x00, 0x00, 0x00,
  0x00, 0x15, 0x10, 0x01, 0x52, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0024[192] = { // Code 0024, DOLLAR SIGN
  0x00, 0x00, 0x00, 0x03, 0xA0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x19, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x8D, 0xFF, 0xFF, 0xFC, 0x71, 0x00,
  0x00, 0x3E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x40,
  0x02, 0xEF, 0xFF, 0xBC, 0xFA, 0xCF, 0xFF, 0xF3,
  0x09, 0xFF, 0xE3, 0x07, 0xF2, 0x08, 0xFF, 0xF7,
  0x0D, 0xFF, 0x80, 0x07, 0xF2, 0x00, 0xAF, 0xF6,
  0x0D, 0xFF, 0x90, 0x07, 0xF2, 0x00, 0x17, 0x50,
  0x0C, 0xFF, 0xF5, 0x07, 0xF2, 0x00, 0x00, 0x00,
  0x07, 0xFF, 0xFF, 0xDC, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0xEA, 0x50, 0x00,
  0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x20,
  0x00, 0x00, 0x17, 0xBE, 0xFF, 0xFF, 0xFF, 0xD1,
  0x00, 0x00, 0x00, 0x07, 0xF7, 0xAF, 0xFF, 0xF7,
  0x02, 0x41, 0x00, 0x07, 0xF2, 0x03, 0xEF, 0xFB,
  0x2E, 0xFD, 0x00, 0x07, 0xF2, 0x00, 0x9F, 0xFD,
  0x5F, 0xFF, 0x50, 0x07, 0xF2, 0x00, 0x9F, 0xFC,
  0x2F, 0xFF, 0xC1, 0x07, 0xF2, 0x03, 0xFF, 0xF8,
  0x09, 0xFF, 0xFD, 0x8A, 0xF8, 0xAF, 0xFF, 0xE2,
  0x01, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
  0x00, 0x06, 0xCF, 0xFF, 0xFF, 0xFE, 0xA2, 0x00,
  0x00, 0x00, 0x02, 0x4A, 0xF6, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x07, 0xF2, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0xD1, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0025[252] = { // Code 0025, PERCENT SIGN
  0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x04, 0xD5, 0x00, 0x00, 0x00,
  0x02, 0xBF, 0xFF, 0xD5, 0x00, 0x00, 0x00, 0x0D, 0xF7, 0x00, 0x00, 0x00,
  0x1E, 0xFF, 0xEF, 0xFF, 0x50, 0x00, 0x00, 0x6F, 0xE1, 0x00, 0x00, 0x00,
  0x7F, 0xF9, 0x04, 0xFF, 0xC0, 0x00, 0x00, 0xEF, 0x70, 0x00, 0x00, 0x00,
  0xBF, 0xF3, 0x00, 0xDF, 0xF1, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xF1, 0x00, 0xBF, 0xF3, 0x00, 0x1E, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xF1, 0x00, 0xBF, 0xF3, 0x00, 0x7F, 0xD0, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0xF3, 0x00, 0xDF, 0xF1, 0x01, 0xFF, 0x50, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFA, 0x05, 0xFF, 0xC0, 0x08, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1D, 0xFF, 0xFF, 0xFF, 0x40, 0x2F, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0xAF, 0xFF, 0xC4, 0x00, 0x9F, 0xB0, 0x02, 0xAE, 0xFD, 0x81, 0x00,
  0x00, 0x00, 0x21, 0x00, 0x03, 0xFF, 0x30, 0x3E, 0xFF, 0xFF, 0xFB, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0xFA, 0x00, 0xBF, 0xF8, 0x2C, 0xFF, 0x60,
  0x00, 0x00, 0x00, 0x00, 0x3F, 0xF3, 0x01, 0xFF, 0xE0, 0x04, 0xFF, 0xA0,
  0x00, 0x00, 0x00, 0x00, 0xBF, 0x90, 0x03, 0xFF, 0xB0, 0x01, 0xFF, 0xD0,
  0x00, 0x00, 0x00, 0x04, 0xFF, 0x20, 0x03, 0xFF, 0xB0, 0x00, 0xFF, 0xD0,
  0x00, 0x00, 0x00, 0x0C, 0xF8, 0x00, 0x01, 0xFF, 0xC0, 0x03, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x5F, 0xE1, 0x00, 0x00, 0xDF, 0xF3, 0x07, 0xFF, 0x80,
  0x00, 0x00, 0x00, 0xDF, 0x70, 0x00, 0x00, 0x6F, 0xFE, 0xCF, 0xFE, 0x20,
  0x00, 0x00, 0x05, 0xFE, 0x10, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xD3, 0x00,
  0x00, 0x00, 0x06, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x14, 0x63, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0026[189] = { // Code 0026, AMPERSAND
  0x00, 0x00, 0x03, 0x79, 0x97, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xAF, 0xFF, 0xFF, 0xFB, 0x10, 0x00, 0x00,
  0x00, 0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x2F, 0xFF, 0xC3, 0x39, 0xFF, 0xF4, 0x00, 0x00,
  0x00, 0x6F, 0xFF, 0x30, 0x00, 0xEF, 0xF7, 0x00, 0x00,
  0x00, 0x6F, 0xFF, 0x30, 0x00, 0xEF, 0xF7, 0x00, 0x00,
  0x00, 0x3F, 0xFF, 0xB0, 0x07, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x0B, 0xFF, 0xFA, 0x9F, 0xFF, 0xD0, 0x00, 0x00,
  0x00, 0x02, 0xEF, 0xFF, 0xFF, 0xFE, 0x30, 0x00, 0x00,
  0x00, 0x07, 0xEF, 0xFF, 0xFF, 0xB2, 0x00, 0x00, 0x00,
  0x01, 0xBF, 0xFF, 0xFF, 0xFF, 0xA0, 0x00, 0x69, 0x40,
  0x0A, 0xFF, 0xFF, 0xAE, 0xFF, 0xF8, 0x04, 0xFF, 0xF1,
  0x4F, 0xFF, 0xE4, 0x05, 0xFF, 0xFF, 0x6C, 0xFF, 0xE0,
  0x9F, 0xFF, 0x60, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x80,
  0xBF, 0xFF, 0x20, 0x00, 0x09, 0xFF, 0xFF, 0xFD, 0x10,
  0xBF, 0xFF, 0x40, 0x00, 0x00, 0xDF, 0xFF, 0xF5, 0x00,
  0x9F, 0xFF, 0xC1, 0x00, 0x1A, 0xFF, 0xFF, 0xFD, 0x10,
  0x3F, 0xFF, 0xFE, 0xBC, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x4E, 0xFF, 0xF1,
  0x00, 0x5D, 0xFF, 0xFF, 0xFD, 0x70, 0x03, 0xEF, 0xA0,
  0x00, 0x00, 0x35, 0x64, 0x20, 0x00, 0x00, 0x12, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0027[ 18] = { // Code 0027, APOSTROPHE
  0x19, 0xB5,
  0x6F, 0xFE,
  0x7F, 0xFF,
  0x7F, 0xFF,
  0x7F, 0xFF,
  0x7F, 0xFF,
  0x7F, 0xFF,
  0x4F, 0xFC,
  0x03, 0x51
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0028[104] = { // Code 0028, LEFT PARENTHESIS
  0x00, 0x00, 0x6D, 0x90,
  0x00, 0x01, 0xEF, 0xF0,
  0x00, 0x08, 0xFF, 0xB0,
  0x00, 0x1E, 0xFF, 0x70,
  0x00, 0x6F, 0xFF, 0x10,
  0x00, 0xCF, 0xFB, 0x00,
  0x02, 0xFF, 0xF7, 0x00,
  0x06, 0xFF, 0xF3, 0x00,
  0x0A, 0xFF, 0xF0, 0x00,
  0x0D, 0xFF, 0xC0, 0x00,
  0x1F, 0xFF, 0xB0, 0x00,
  0x2F, 0xFF, 0x90, 0x00,
  0x2F, 0xFF, 0x90, 0x00,
  0x2F, 0xFF, 0x90, 0x00,
  0x2F, 0xFF, 0xA0, 0x00,
  0x0F, 0xFF, 0xB0, 0x00,
  0x0C, 0xFF, 0xE0, 0x00,
  0x08, 0xFF, 0xF2, 0x00,
  0x04, 0xFF, 0xF5, 0x00,
  0x00, 0xEF, 0xF9, 0x00,
  0x00, 0x9F, 0xFD, 0x00,
  0x00, 0x3F, 0xFF, 0x30,
  0x00, 0x0C, 0xFF, 0x90,
  0x00, 0x05, 0xFF, 0xE0,
  0x00, 0x00, 0xCF, 0xE0,
  0x00, 0x00, 0x16, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0029[104] = { // Code 0029, RIGHT PARENTHESIS
  0x9D, 0x60, 0x00, 0x00,
  0xFF, 0xE1, 0x00, 0x00,
  0xBF, 0xF8, 0x00, 0x00,
  0x7F, 0xFE, 0x00, 0x00,
  0x2F, 0xFF, 0x60, 0x00,
  0x0B, 0xFF, 0xC0, 0x00,
  0x07, 0xFF, 0xF2, 0x00,
  0x04, 0xFF, 0xF6, 0x00,
  0x00, 0xFF, 0xFA, 0x00,
  0x00, 0xCF, 0xFD, 0x00,
  0x00, 0xBF, 0xFF, 0x10,
  0x00, 0x9F, 0xFF, 0x20,
  0x00, 0x9F, 0xFF, 0x20,
  0x00, 0x9F, 0xFF, 0x20,
  0x00, 0xAF, 0xFF, 0x20,
  0x00, 0xBF, 0xFF, 0x00,
  0x00, 0xEF, 0xFC, 0x00,
  0x02, 0xFF, 0xF8, 0x00,
  0x05, 0xFF, 0xF4, 0x00,
  0x09, 0xFF, 0xE0, 0x00,
  0x0E, 0xFF, 0x90, 0x00,
  0x3F, 0xFF, 0x30, 0x00,
  0x9F, 0xFB, 0x00, 0x00,
  0xEF, 0xF5, 0x00, 0x00,
  0xEF, 0xC0, 0x00, 0x00,
  0x36, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_002A[ 60] = { // Code 002A, ASTERISK
  0x00, 0x00, 0x7B, 0x20, 0x00, 0x00,
  0x00, 0x00, 0xDF, 0x60, 0x00, 0x00,
  0x01, 0x00, 0xDF, 0x60, 0x01, 0x00,
  0x8F, 0xB6, 0xEF, 0x88, 0xEE, 0x20,
  0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30,
  0x04, 0x9D, 0xFF, 0xFB, 0x62, 0x00,
  0x00, 0x1D, 0xFF, 0xF7, 0x00, 0x00,
  0x00, 0xBF, 0xE9, 0xFF, 0x40, 0x00,
  0x05, 0xFF, 0x60, 0xCF, 0xC0, 0x00,
  0x02, 0xC9, 0x00, 0x3D, 0x80, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_002B[128] = { // Code 002B, PLUS SIGN
  0x00, 0x00, 0x00, 0x02, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0xF6, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00, 0x00,
  0x02, 0x44, 0x44, 0x9F, 0xFC, 0x44, 0x44, 0x30,
  0x4F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0x2C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD4,
  0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFA, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2D, 0xE4, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_002C[ 27] = { // Code 002C, COMMA
  0x00, 0x23, 0x00,
  0x07, 0xFF, 0xB0,
  0x0F, 0xFF, 0xF6,
  0x0F, 0xFF, 0xF9,
  0x07, 0xFF, 0xF9,
  0x00, 0x05, 0xF8,
  0x00, 0x2D, 0xF3,
  0x08, 0xFF, 0x80,
  0x0C, 0xC5, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_002D[ 25] = { // Code 002D, HYPHEN-MINUS
  0x03, 0x56, 0x66, 0x53, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0x90,
  0xDF, 0xFF, 0xFF, 0xFF, 0xD0,
  0xAF, 0xFF, 0xFF, 0xFF, 0xA0,
  0x04, 0x66, 0x66, 0x64, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_002E[ 18] = { // Code 002E, FULL STOP
  0x00, 0x23, 0x00,
  0x07, 0xFF, 0xB0,
  0x0F, 0xFF, 0xF4,
  0x0F, 0xFF, 0xF4,
  0x06, 0xFF, 0xA0,
  0x00, 0x12, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_002F[105] = { // Code 002F, SOLIDUS
  0x00, 0x00, 0x00, 0x09, 0xD5,
  0x00, 0x00, 0x00, 0x3F, 0xFB,
  0x00, 0x00, 0x00, 0x9F, 0xF8,
  0x00, 0x00, 0x00, 0xEF, 0xF2,
  0x00, 0x00, 0x05, 0xFF, 0xB0,
  0x00, 0x00, 0x0B, 0xFF, 0x60,
  0x00, 0x00, 0x2F, 0xFE, 0x10,
  0x00, 0x00, 0x7F, 0xF9, 0x00,
  0x00, 0x00, 0xDF, 0xF3, 0x00,
  0x00, 0x04, 0xFF, 0xD0, 0x00,
  0x00, 0x0A, 0xFF, 0x70, 0x00,
  0x00, 0x1F, 0xFF, 0x20, 0x00,
  0x00, 0x6F, 0xFB, 0x00, 0x00,
  0x00, 0xCF, 0xF5, 0x00, 0x00,
  0x02, 0xFF, 0xE0, 0x00, 0x00,
  0x08, 0xFF, 0x90, 0x00, 0x00,
  0x0E, 0xFF, 0x30, 0x00, 0x00,
  0x4F, 0xFC, 0x00, 0x00, 0x00,
  0xAF, 0xF7, 0x00, 0x00, 0x00,
  0xAF, 0xE1, 0x00, 0x00, 0x00,
  0x17, 0x30, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0030[168] = { // Code 0030, DIGIT ZERO
  0x00, 0x00, 0x00, 0x23, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x03, 0xBF, 0xFF, 0xFD, 0x70, 0x00, 0x00,
  0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xFC, 0x10, 0x00,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00,
  0x0C, 0xFF, 0xFA, 0x31, 0x5E, 0xFF, 0xF5, 0x00,
  0x3F, 0xFF, 0xD0, 0x00, 0x06, 0xFF, 0xFB, 0x00,
  0x8F, 0xFF, 0x70, 0x00, 0x00, 0xEF, 0xFF, 0x10,
  0xBF, 0xFF, 0x40, 0x00, 0x00, 0xBF, 0xFF, 0x40,
  0xDF, 0xFF, 0x20, 0x00, 0x00, 0x9F, 0xFF, 0x60,
  0xEF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0xDF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0xCF, 0xFF, 0x10, 0x00, 0x00, 0x8F, 0xFF, 0x50,
  0xAF, 0xFF, 0x30, 0x00, 0x00, 0xAF, 0xFF, 0x30,
  0x7F, 0xFF, 0x60, 0x00, 0x00, 0xDF, 0xFF, 0x10,
  0x3F, 0xFF, 0xB0, 0x00, 0x04, 0xFF, 0xFB, 0x00,
  0x0C, 0xFF, 0xF8, 0x00, 0x3D, 0xFF, 0xF5, 0x00,
  0x04, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xB0, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFD, 0x10, 0x00,
  0x00, 0x04, 0xDF, 0xFF, 0xFF, 0x91, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x56, 0x31, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0031[105] = { // Code 0031, DIGIT ONE
  0x00, 0x00, 0x00, 0x01, 0x20,
  0x00, 0x00, 0x00, 0x4F, 0xF7,
  0x00, 0x00, 0x00, 0xDF, 0xFB,
  0x00, 0x00, 0x08, 0xFF, 0xFB,
  0x00, 0x37, 0xBF, 0xFF, 0xFB,
  0x1D, 0xFF, 0xFF, 0xFF, 0xFB,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFB,
  0x09, 0xBB, 0xBD, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x05, 0xFF, 0xFA,
  0x00, 0x00, 0x01, 0xEF, 0xF5,
  0x00, 0x00, 0x00, 0x15, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0032[160] = { // Code 0032, DIGIT TWO
  0x00, 0x00, 0x00, 0x13, 0x32, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x6C, 0xFF, 0xFF, 0xD8, 0x10, 0x00,
  0x00, 0x1C, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x00,
  0x01, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x30,
  0x08, 0xFF, 0xFE, 0x61, 0x15, 0xEF, 0xFF, 0xB0,
  0x0E, 0xFF, 0xF4, 0x00, 0x00, 0x5F, 0xFF, 0xF0,
  0x0F, 0xFF, 0xC0, 0x00, 0x00, 0x1F, 0xFF, 0xF0,
  0x0D, 0xFF, 0x60, 0x00, 0x00, 0x2F, 0xFF, 0xF0,
  0x01, 0x55, 0x00, 0x00, 0x00, 0x8F, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0x40,
  0x00, 0x00, 0x00, 0x03, 0xCF, 0xFF, 0xF9, 0x00,
  0x00, 0x00, 0x01, 0x8F, 0xFF, 0xFF, 0x70, 0x00,
  0x00, 0x00, 0x3D, 0xFF, 0xFF, 0xB3, 0x00, 0x00,
  0x00, 0x06, 0xFF, 0xFF, 0xD5, 0x00, 0x00, 0x00,
  0x00, 0x7F, 0xFF, 0xF8, 0x10, 0x00, 0x00, 0x00,
  0x04, 0xFF, 0xFE, 0x40, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0xFF, 0xFA, 0x66, 0x66, 0x66, 0x66, 0x20,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2,
  0x07, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0033[168] = { // Code 0033, DIGIT THREE
  0x00, 0x00, 0x00, 0x13, 0x31, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x8D, 0xFF, 0xFF, 0xD7, 0x00, 0x00,
  0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x09, 0xFF, 0xFD, 0x41, 0x29, 0xFF, 0xFE, 0x00,
  0x0B, 0xFF, 0xE2, 0x00, 0x00, 0xBF, 0xFF, 0x30,
  0x06, 0xFF, 0x50, 0x00, 0x00, 0x9F, 0xFF, 0x30,
  0x00, 0x11, 0x00, 0x00, 0x00, 0xCF, 0xFE, 0x00,
  0x00, 0x00, 0x00, 0x15, 0x7C, 0xFF, 0xF7, 0x00,
  0x00, 0x00, 0x00, 0xDF, 0xFF, 0xFF, 0x70, 0x00,
  0x00, 0x00, 0x00, 0xEF, 0xFF, 0xFF, 0xE5, 0x00,
  0x00, 0x00, 0x00, 0x4A, 0xCF, 0xFF, 0xFF, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x02, 0xDF, 0xFF, 0x90,
  0x00, 0x31, 0x00, 0x00, 0x00, 0x6F, 0xFF, 0xB0,
  0x0B, 0xFE, 0x30, 0x00, 0x00, 0x6F, 0xFF, 0xB0,
  0x2F, 0xFF, 0xB0, 0x00, 0x00, 0x9F, 0xFF, 0xA0,
  0x1F, 0xFF, 0xF8, 0x00, 0x06, 0xFF, 0xFF, 0x50,
  0x09, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFC, 0x00,
  0x01, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD1, 0x00,
  0x00, 0x07, 0xDF, 0xFF, 0xFF, 0xD7, 0x10, 0x00,
  0x00, 0x00, 0x03, 0x46, 0x42, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0034[168] = { // Code 0034, DIGIT FOUR
  0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0xFF, 0x90, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x8F, 0xFF, 0xE0, 0x00,
  0x00, 0x00, 0x00, 0x05, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x2E, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x01, 0xDF, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x0A, 0xFF, 0x7D, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x7F, 0xFB, 0x0D, 0xFF, 0xF0, 0x00,
  0x00, 0x04, 0xFF, 0xD1, 0x0D, 0xFF, 0xF0, 0x00,
  0x00, 0x2E, 0xFF, 0x30, 0x0D, 0xFF, 0xF0, 0x00,
  0x00, 0xCF, 0xF7, 0x00, 0x0D, 0xFF, 0xF0, 0x00,
  0x09, 0xFF, 0xB0, 0x00, 0x0D, 0xFF, 0xF0, 0x00,
  0x4F, 0xFF, 0x76, 0x66, 0x6E, 0xFF, 0xF6, 0x51,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
  0x08, 0xBB, 0xBB, 0xBB, 0xBF, 0xFF, 0xFB, 0xA3,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x08, 0xFF, 0xB0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0035[160] = { // Code 0035, DIGIT FIVE
  0x00, 0x2B, 0xDD, 0xDD, 0xDD, 0xDD, 0xC4, 0x00,
  0x00, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x00, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0x01, 0xFF, 0xFB, 0x99, 0x99, 0x99, 0x72, 0x00,
  0x03, 0xFF, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x06, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0xFF, 0xB0, 0x58, 0x97, 0x40, 0x00, 0x00,
  0x0B, 0xFF, 0xCE, 0xFF, 0xFF, 0xFD, 0x40, 0x00,
  0x0D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x00,
  0x0C, 0xFF, 0xFC, 0x87, 0xBF, 0xFF, 0xFE, 0x10,
  0x03, 0xBB, 0x50, 0x00, 0x03, 0xEF, 0xFF, 0x60,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xA0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x52, 0x00, 0x00, 0x00, 0x5F, 0xFF, 0xA0,
  0x0C, 0xFE, 0x30, 0x00, 0x00, 0xBF, 0xFF, 0x70,
  0x2F, 0xFF, 0xE3, 0x00, 0x08, 0xFF, 0xFF, 0x30,
  0x0D, 0xFF, 0xFF, 0xCB, 0xEF, 0xFF, 0xF9, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0, 0x00,
  0x00, 0x29, 0xFF, 0xFF, 0xFF, 0xC5, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x56, 0x41, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0036[168] = { // Code 0036, DIGIT SIX
  0x00, 0x00, 0x00, 0x13, 0x31, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x7D, 0xFF, 0xFF, 0xD6, 0x00, 0x00,
  0x00, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00,
  0x01, 0xDF, 0xFF, 0xEB, 0xCF, 0xFF, 0xF6, 0x00,
  0x08, 0xFF, 0xF9, 0x00, 0x06, 0xFF, 0xF8, 0x00,
  0x1F, 0xFF, 0xC0, 0x00, 0x00, 0x6F, 0xD2, 0x00,
  0x5F, 0xFF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xFF, 0x20, 0x14, 0x43, 0x00, 0x00, 0x00,
  0xBF, 0xFF, 0x2A, 0xFF, 0xFF, 0xE8, 0x10, 0x00,
  0xDF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xC1, 0x00,
  0xEF, 0xFF, 0xFF, 0xB9, 0xBF, 0xFF, 0xFA, 0x00,
  0xFF, 0xFF, 0xE3, 0x00, 0x05, 0xFF, 0xFF, 0x20,
  0xEF, 0xFF, 0x70, 0x00, 0x00, 0xAF, 0xFF, 0x50,
  0xCF, 0xFF, 0x40, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0xAF, 0xFF, 0x40, 0x00, 0x00, 0x8F, 0xFF, 0x60,
  0x6F, 0xFF, 0x80, 0x00, 0x00, 0xBF, 0xFF, 0x40,
  0x1E, 0xFF, 0xF4, 0x00, 0x07, 0xFF, 0xFE, 0x00,
  0x07, 0xFF, 0xFF, 0xDB, 0xDF, 0xFF, 0xF7, 0x00,
  0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x90, 0x00,
  0x00, 0x05, 0xDF, 0xFF, 0xFF, 0xD5, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x46, 0x42, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0037[160] = { // Code 0037, DIGIT SEVEN
  0x3C, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDC, 0x40,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x17, 0x99, 0x99, 0x99, 0x99, 0xCF, 0xFF, 0x40,
  0x00, 0x00, 0x00, 0x00, 0x03, 0xEF, 0xF7, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0x90, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xBF, 0xFD, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0xFF, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1E, 0xFF, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xEF, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0xF5, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0E, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0xFF, 0xA0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xAF, 0xFF, 0x50, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xFF, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xFD, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xEF, 0xF3, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x25, 0x30, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0038[168] = { // Code 0038, DIGIT EIGHT
  0x00, 0x00, 0x01, 0x33, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x07, 0xCF, 0xFF, 0xFE, 0xA3, 0x00, 0x00,
  0x01, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70, 0x00,
  0x0B, 0xFF, 0xFF, 0xCB, 0xEF, 0xFF, 0xF4, 0x00,
  0x3F, 0xFF, 0xE3, 0x00, 0x08, 0xFF, 0xFB, 0x00,
  0x6F, 0xFF, 0x70, 0x00, 0x00, 0xEF, 0xFD, 0x00,
  0x5F, 0xFF, 0x60, 0x00, 0x00, 0xDF, 0xFD, 0x00,
  0x2F, 0xFF, 0xB0, 0x00, 0x03, 0xFF, 0xFA, 0x00,
  0x09, 0xFF, 0xFB, 0x66, 0x8E, 0xFF, 0xE2, 0x00,
  0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0xFD, 0x30, 0x00,
  0x03, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0x91, 0x00,
  0x3E, 0xFF, 0xFB, 0x54, 0x7E, 0xFF, 0xFA, 0x00,
  0xAF, 0xFF, 0xA0, 0x00, 0x02, 0xEF, 0xFF, 0x20,
  0xDF, 0xFF, 0x20, 0x00, 0x00, 0x9F, 0xFF, 0x60,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0xDF, 0xFF, 0x30, 0x00, 0x00, 0xAF, 0xFF, 0x50,
  0x9F, 0xFF, 0xD2, 0x00, 0x07, 0xFF, 0xFF, 0x20,
  0x2E, 0xFF, 0xFF, 0xCB, 0xEF, 0xFF, 0xF9, 0x00,
  0x04, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00,
  0x00, 0x29, 0xEF, 0xFF, 0xFF, 0xD6, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x56, 0x42, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0039[168] = { // Code 0039, DIGIT NINE
  0x00, 0x00, 0x01, 0x33, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x07, 0xDF, 0xFF, 0xFD, 0x70, 0x00, 0x00,
  0x01, 0xCF, 0xFF, 0xFF, 0xFF, 0xFC, 0x10, 0x00,
  0x0C, 0xFF, 0xFF, 0xED, 0xFF, 0xFF, 0xC0, 0x00,
  0x5F, 0xFF, 0xE4, 0x00, 0x2C, 0xFF, 0xF7, 0x00,
  0xBF, 0xFF, 0x50, 0x00, 0x02, 0xFF, 0xFD, 0x00,
  0xDF, 0xFF, 0x10, 0x00, 0x00, 0xCF, 0xFF, 0x20,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0xBF, 0xFF, 0x50,
  0xDF, 0xFF, 0x20, 0x00, 0x00, 0xEF, 0xFF, 0x60,
  0xAF, 0xFF, 0xA0, 0x00, 0x07, 0xFF, 0xFF, 0x70,
  0x3F, 0xFF, 0xFC, 0x87, 0xBF, 0xFF, 0xFF, 0x70,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x00, 0x6E, 0xFF, 0xFF, 0xF9, 0x8F, 0xFF, 0x40,
  0x00, 0x00, 0x46, 0x75, 0x20, 0x8F, 0xFF, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xCF, 0xFE, 0x00,
  0x06, 0xDA, 0x10, 0x00, 0x03, 0xFF, 0xF9, 0x00,
  0x0F, 0xFF, 0xA1, 0x00, 0x2D, 0xFF, 0xF3, 0x00,
  0x0E, 0xFF, 0xFD, 0x9A, 0xEF, 0xFF, 0x90, 0x00,
  0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00, 0x00,
  0x00, 0x4C, 0xFF, 0xFF, 0xFD, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x24, 0x64, 0x20, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_003A[ 48] = { // Code 003A, COLON
  0x00, 0x11, 0x00,
  0x06, 0xFF, 0x90,
  0x0F, 0xFF, 0xF4,
  0x1F, 0xFF, 0xF4,
  0x08, 0xFF, 0xB0,
  0x00, 0x33, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x23, 0x00,
  0x07, 0xFF, 0xB0,
  0x0F, 0xFF, 0xF4,
  0x0F, 0xFF, 0xF4,
  0x06, 0xFF, 0xA0,
  0x00, 0x12, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_003B[ 57] = { // Code 003B, SEMICOLON
  0x00, 0x11, 0x00,
  0x06, 0xFF, 0x90,
  0x0F, 0xFF, 0xF4,
  0x1F, 0xFF, 0xF4,
  0x08, 0xFF, 0xB0,
  0x00, 0x33, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x23, 0x00,
  0x07, 0xFF, 0xB0,
  0x0F, 0xFF, 0xF6,
  0x0F, 0xFF, 0xF9,
  0x07, 0xFF, 0xF9,
  0x00, 0x05, 0xF8,
  0x00, 0x2D, 0xF3,
  0x08, 0xFF, 0x80,
  0x0C, 0xC5, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_003C[120] = { // Code 003C, LESS-THAN SIGN
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x81,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x4B, 0xFF, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x5C, 0xFF, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x7D, 0xFF, 0xFF, 0xFD, 0x70,
  0x00, 0x01, 0x7E, 0xFF, 0xFF, 0xFC, 0x50, 0x00,
  0x02, 0x9F, 0xFF, 0xFF, 0xFA, 0x30, 0x00, 0x00,
  0x2E, 0xFF, 0xFF, 0xE8, 0x20, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0xFE, 0x40, 0x00, 0x00, 0x00, 0x00,
  0x1C, 0xFF, 0xFF, 0xFC, 0x60, 0x00, 0x00, 0x00,
  0x00, 0x5B, 0xFF, 0xFF, 0xFE, 0x71, 0x00, 0x00,
  0x00, 0x00, 0x3A, 0xFF, 0xFF, 0xFF, 0x93, 0x00,
  0x00, 0x00, 0x00, 0x29, 0xFF, 0xFF, 0xFF, 0xB1,
  0x00, 0x00, 0x00, 0x00, 0x18, 0xEF, 0xFF, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0xDF, 0xF6,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_003D[ 88] = { // Code 003D, EQUALS SIGN
  0x04, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x50,
  0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA,
  0x19, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xA2,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00,
  0x3E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0x3E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6,
  0x01, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_003E[120] = { // Code 003E, GREATER-THAN SIGN
  0x07, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0xC5, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x4F, 0xFF, 0xFF, 0xD7, 0x10, 0x00, 0x00, 0x00,
  0x05, 0xCF, 0xFF, 0xFF, 0xE8, 0x10, 0x00, 0x00,
  0x00, 0x04, 0xAF, 0xFF, 0xFF, 0xF9, 0x20, 0x00,
  0x00, 0x00, 0x02, 0x8E, 0xFF, 0xFF, 0xFA, 0x30,
  0x00, 0x00, 0x00, 0x01, 0x7D, 0xFF, 0xFF, 0xF5,
  0x00, 0x00, 0x00, 0x00, 0x03, 0xDF, 0xFF, 0xF8,
  0x00, 0x00, 0x00, 0x04, 0xBF, 0xFF, 0xFF, 0xD2,
  0x00, 0x00, 0x06, 0xDF, 0xFF, 0xFF, 0xD6, 0x00,
  0x00, 0x28, 0xEF, 0xFF, 0xFF, 0xB5, 0x00, 0x00,
  0x09, 0xFF, 0xFF, 0xFF, 0xA3, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0xFF, 0x92, 0x00, 0x00, 0x00, 0x00,
  0x3F, 0xFE, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_003F[147] = { // Code 003F, QUESTION MARK
  0x00, 0x02, 0x8B, 0xBB, 0x95, 0x00, 0x00,
  0x00, 0x9F, 0xFF, 0xFF, 0xFF, 0xE4, 0x00,
  0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x40,
  0x6F, 0xFF, 0xE7, 0x46, 0xCF, 0xFF, 0xE0,
  0xBF, 0xFF, 0x40, 0x00, 0x1E, 0xFF, 0xF3,
  0xCF, 0xFB, 0x00, 0x00, 0x0B, 0xFF, 0xF6,
  0x4C, 0xB2, 0x00, 0x00, 0x1E, 0xFF, 0xF3,
  0x00, 0x00, 0x00, 0x00, 0xAF, 0xFF, 0xD0,
  0x00, 0x00, 0x00, 0x2C, 0xFF, 0xFF, 0x40,
  0x00, 0x00, 0x02, 0xEF, 0xFF, 0xE4, 0x00,
  0x00, 0x00, 0x1D, 0xFF, 0xFC, 0x20, 0x00,
  0x00, 0x00, 0x6F, 0xFF, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x1C, 0xF8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xFD, 0x10, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x4E, 0xFC, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x20, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0040[231] = { // Code 0040, COMMERCIAL AT
  0x00, 0x00, 0x00, 0x03, 0x8C, 0xDD, 0xDB, 0x72, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x04, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA2, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0xFF, 0xFB, 0x87, 0x9C, 0xFF, 0xFE, 0x30, 0x00,
  0x00, 0x08, 0xFF, 0xF8, 0x10, 0x00, 0x00, 0x29, 0xFF, 0xE2, 0x00,
  0x00, 0x6F, 0xFE, 0x40, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00,
  0x01, 0xEF, 0xF5, 0x00, 0x5B, 0xFD, 0x91, 0x6B, 0x3A, 0xFF, 0x40,
  0x07, 0xFF, 0xA0, 0x08, 0xFF, 0xFF, 0xFC, 0xEF, 0x82, 0xFF, 0x90,
  0x0C, 0xFF, 0x30, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0xCF, 0xB0,
  0x1F, 0xFE, 0x00, 0xDF, 0xF9, 0x10, 0x7F, 0xFF, 0x30, 0xAF, 0xB0,
  0x2F, 0xFB, 0x03, 0xFF, 0xB0, 0x00, 0x0E, 0xFF, 0x10, 0x9F, 0xB0,
  0x2F, 0xFB, 0x06, 0xFF, 0x70, 0x00, 0x0C, 0xFD, 0x00, 0xBF, 0x90,
  0x2F, 0xFC, 0x07, 0xFF, 0x70, 0x00, 0x0E, 0xFB, 0x00, 0xEF, 0x40,
  0x0E, 0xFE, 0x06, 0xFF, 0xC1, 0x00, 0x9F, 0xF8, 0x08, 0xFC, 0x00,
  0x0A, 0xFF, 0x42, 0xFF, 0xFE, 0xAD, 0xFF, 0xFC, 0xBF, 0xE3, 0x00,
  0x05, 0xFF, 0xC0, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x30, 0x00,
  0x00, 0xCF, 0xF7, 0x1A, 0xFF, 0xF9, 0x8F, 0xFE, 0x81, 0x00, 0x00,
  0x00, 0x2E, 0xFF, 0x80, 0x24, 0x10, 0x03, 0x30, 0x7A, 0x10, 0x00,
  0x00, 0x03, 0xEF, 0xFD, 0x73, 0x00, 0x02, 0x7D, 0xFF, 0x30, 0x00,
  0x00, 0x00, 0x2C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x5B, 0xFF, 0xFF, 0xFF, 0xE9, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x14, 0x67, 0x63, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0041[189] = { // Code 0041, LATIN CAPITAL LETTER A
  0x00, 0x00, 0x00, 0x19, 0xBB, 0xA2, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x8F, 0xFF, 0xFC, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xEF, 0xFF, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x05, 0xFF, 0xFF, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0xFF, 0xDB, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0x87, 0xFF, 0xFA, 0x00, 0x00,
  0x00, 0x00, 0xDF, 0xFF, 0x32, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x03, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0x60, 0x00,
  0x00, 0x09, 0xFF, 0xF8, 0x00, 0x7F, 0xFF, 0xB0, 0x00,
  0x00, 0x0E, 0xFF, 0xF3, 0x00, 0x2F, 0xFF, 0xF2, 0x00,
  0x00, 0x5F, 0xFF, 0xD0, 0x00, 0x0D, 0xFF, 0xF7, 0x00,
  0x00, 0xBF, 0xFF, 0xA4, 0x44, 0x4A, 0xFF, 0xFC, 0x00,
  0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x0D, 0xFF, 0xFE, 0xDD, 0xDD, 0xDD, 0xEF, 0xFF, 0xD0,
  0x4F, 0xFF, 0xF3, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF4,
  0x9F, 0xFF, 0xD0, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xF9,
  0xBF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x08, 0xFF, 0xFB,
  0x6F, 0xFE, 0x20, 0x00, 0x00, 0x00, 0x02, 0xEF, 0xF6,
  0x03, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0042[180] = { // Code 0042, LATIN CAPITAL LETTER B
  0x04, 0x67, 0x77, 0x77, 0x76, 0x53, 0x00, 0x00, 0x00,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD6, 0x00, 0x00,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x90, 0x00,
  0xFF, 0xFF, 0xDB, 0xBB, 0xCE, 0xFF, 0xFF, 0xF3, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x8F, 0xFF, 0xF8, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x0D, 0xFF, 0xF9, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x0C, 0xFF, 0xF8, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x3F, 0xFF, 0xF3, 0x00,
  0xFF, 0xFF, 0xB7, 0x77, 0x79, 0xFF, 0xFF, 0x70, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA1, 0x00,
  0xFF, 0xFF, 0xA6, 0x66, 0x67, 0xCF, 0xFF, 0xFA, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x09, 0xFF, 0xFF, 0x10,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x40,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x40,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x09, 0xFF, 0xFF, 0x30,
  0xFF, 0xFF, 0xA6, 0x66, 0x68, 0xCF, 0xFF, 0xFD, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5, 0x00,
  0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x60, 0x00,
  0x3C, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0x71, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0043[189] = { // Code 0043, LATIN CAPITAL LETTER C
  0x00, 0x00, 0x00, 0x5A, 0xCD, 0xDC, 0x94, 0x00, 0x00,
  0x00, 0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xFF, 0xD4, 0x00,
  0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x00, 0x7F, 0xFF, 0xFF, 0xDA, 0xBD, 0xFF, 0xFF, 0xF3,
  0x02, 0xFF, 0xFF, 0xE6, 0x00, 0x00, 0x7F, 0xFF, 0xFA,
  0x09, 0xFF, 0xFF, 0x40, 0x00, 0x00, 0x08, 0xFF, 0xFB,
  0x0F, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xF6,
  0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x02, 0x10,
  0x7F, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x6F, 0xFF, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x6C, 0xA2,
  0x0E, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFB,
  0x09, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x1D, 0xFF, 0xFB,
  0x02, 0xEF, 0xFF, 0xFB, 0x52, 0x25, 0xDF, 0xFF, 0xF6,
  0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
  0x00, 0x05, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0x00, 0x00, 0x29, 0xEF, 0xFF, 0xFF, 0xFD, 0x60, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x57, 0x75, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0044[180] = { // Code 0044, LATIN CAPITAL LETTER D
  0x04, 0x67, 0x77, 0x77, 0x65, 0x30, 0x00, 0x00, 0x00,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA3, 0x00, 0x00,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x00,
  0xFF, 0xFF, 0x82, 0x22, 0x24, 0xAF, 0xFF, 0xFE, 0x10,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0x80,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0xCF, 0xFF, 0xD0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF1,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF3,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x2F, 0xFF, 0xF4,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x2F, 0xFF, 0xF4,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF4,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x5F, 0xFF, 0xF2,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0xAF, 0xFF, 0xE0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xA0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x3D, 0xFF, 0xFF, 0x30,
  0xFF, 0xFF, 0xC9, 0x99, 0x9B, 0xFF, 0xFF, 0xF9, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00,
  0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00,
  0x3C, 0xFF, 0xFF, 0xFF, 0xFE, 0xB7, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0045[160] = { // Code 0045, LATIN CAPITAL LETTER E
  0x03, 0x67, 0x77, 0x77, 0x77, 0x77, 0x76, 0x30,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3,
  0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD1,
  0xDF, 0xFF, 0xA2, 0x22, 0x22, 0x22, 0x22, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0xD9, 0x99, 0x99, 0x99, 0x95, 0x00,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0xDF, 0xFF, 0xEB, 0xBB, 0xBB, 0xBB, 0xB6, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0xD9, 0x99, 0x99, 0x99, 0x98, 0x60,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7,
  0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9,
  0x2C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0046[168] = { // Code 0046, LATIN CAPITAL LETTER F
  0x03, 0x67, 0x77, 0x77, 0x77, 0x77, 0x74, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
  0xDF, 0xFF, 0xA2, 0x22, 0x22, 0x22, 0x20, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0xB6, 0x66, 0x66, 0x65, 0x20, 0x00,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0x00,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5, 0x00,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD1, 0x00,
  0xDF, 0xFF, 0xA2, 0x22, 0x22, 0x20, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x6F, 0xFE, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0047[210] = { // Code 0047, LATIN CAPITAL LETTER G
  0x00, 0x00, 0x00, 0x48, 0xBD, 0xDD, 0xB8, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x4D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x10, 0x00,
  0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD1, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xEB, 0xAC, 0xFF, 0xFF, 0xFA, 0x00,
  0x03, 0xFF, 0xFF, 0xE6, 0x00, 0x00, 0x1A, 0xFF, 0xFF, 0x10,
  0x0A, 0xFF, 0xFF, 0x40, 0x00, 0x00, 0x00, 0xCF, 0xFE, 0x00,
  0x1F, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x19, 0xA3, 0x00,
  0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0xD0, 0x00, 0x00, 0x04, 0x66, 0x66, 0x64, 0x10,
  0x7F, 0xFF, 0xD0, 0x00, 0x00, 0xAF, 0xFF, 0xFF, 0xFF, 0xD0,
  0x7F, 0xFF, 0xD0, 0x00, 0x00, 0xDF, 0xFF, 0xFF, 0xFF, 0xF2,
  0x6F, 0xFF, 0xF1, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xF2,
  0x3F, 0xFF, 0xF5, 0x00, 0x00, 0x01, 0x22, 0x3F, 0xFF, 0xF2,
  0x0E, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x00, 0x6F, 0xFF, 0xF2,
  0x09, 0xFF, 0xFF, 0x70, 0x00, 0x00, 0x02, 0xEF, 0xFF, 0xF2,
  0x02, 0xEF, 0xFF, 0xFA, 0x30, 0x01, 0x7E, 0xFF, 0xFF, 0xF2,
  0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2,
  0x00, 0x05, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE5, 0xFF, 0xF2,
  0x00, 0x00, 0x29, 0xEF, 0xFF, 0xFF, 0xFA, 0x20, 0xDF, 0xD0,
  0x00, 0x00, 0x00, 0x03, 0x67, 0x75, 0x20, 0x00, 0x15, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0048[189] = { // Code 0048, LATIN CAPITAL LETTER H
  0x2A, 0xB7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xBA, 0x20,
  0xCF, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x4F, 0xFF, 0xC0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x82, 0x22, 0x22, 0x22, 0x8F, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xC9, 0x99, 0x99, 0x99, 0xCF, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xEF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xE0,
  0x7F, 0xFE, 0x20, 0x00, 0x00, 0x00, 0x2E, 0xFF, 0x70,
  0x03, 0x51, 0x00, 0x00, 0x00, 0x00, 0x01, 0x53, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0049[ 63] = { // Code 0049, LATIN CAPITAL LETTER I
  0x2A, 0xB7, 0x00,
  0xCF, 0xFF, 0x40,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xEF, 0xFF, 0x70,
  0x7F, 0xFE, 0x20,
  0x03, 0x51, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_004A[147] = { // Code 004A, LATIN CAPITAL LETTER J
  0x00, 0x00, 0x00, 0x00, 0x02, 0xAB, 0x70,
  0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xF4,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x05, 0x97, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x3F, 0xFF, 0x50, 0x00, 0x0F, 0xFF, 0xF7,
  0x7F, 0xFF, 0x90, 0x00, 0x0F, 0xFF, 0xF7,
  0x7F, 0xFF, 0xA0, 0x00, 0x3F, 0xFF, 0xF5,
  0x5F, 0xFF, 0xF4, 0x01, 0xBF, 0xFF, 0xF1,
  0x0E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
  0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x10,
  0x00, 0x4C, 0xFF, 0xFF, 0xFF, 0xA1, 0x00,
  0x00, 0x00, 0x36, 0x76, 0x51, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_004B[189] = { // Code 004B, LATIN CAPITAL LETTER K
  0x2A, 0xB7, 0x00, 0x00, 0x00, 0x01, 0xAB, 0x60, 0x00,
  0xCF, 0xFF, 0x40, 0x00, 0x00, 0x1B, 0xFF, 0xF3, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0xBF, 0xFF, 0xF3, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x0A, 0xFF, 0xFF, 0x80, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x8F, 0xFF, 0xFA, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x07, 0xFF, 0xFF, 0xA0, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x6F, 0xFF, 0xFB, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x75, 0xFF, 0xFF, 0xB1, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xBE, 0xFF, 0xFF, 0x40, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xAE, 0xFF, 0xFF, 0x30, 0x00, 0x00,
  0xFF, 0xFF, 0xFA, 0x05, 0xFF, 0xFF, 0xC0, 0x00, 0x00,
  0xFF, 0xFF, 0xB0, 0x00, 0xAF, 0xFF, 0xF7, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x1E, 0xFF, 0xFF, 0x20, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x06, 0xFF, 0xFF, 0xC0, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0xBF, 0xFF, 0xF7, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x2E, 0xFF, 0xFE, 0x10,
  0xEF, 0xFF, 0x70, 0x00, 0x00, 0x06, 0xFF, 0xFF, 0x30,
  0x7F, 0xFE, 0x20, 0x00, 0x00, 0x00, 0xBF, 0xFD, 0x00,
  0x03, 0x51, 0x00, 0x00, 0x00, 0x00, 0x05, 0x40, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_004C[160] = { // Code 004C, LATIN CAPITAL LETTER L
  0x2A, 0xB7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xDB, 0xBB, 0xBB, 0xBB, 0xA3, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0x3C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_004D[210] = { // Code 004D, LATIN CAPITAL LETTER M
  0x3A, 0xBB, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x2A, 0xBB, 0xA3,
  0xDF, 0xFF, 0xFD, 0x00, 0x00, 0x00, 0x00, 0xCF, 0xFF, 0xFD,
  0xFF, 0xFF, 0xFF, 0x30, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x08, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF2, 0x00, 0x00, 0x2F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFD, 0xEF, 0xF7, 0x00, 0x00, 0x7F, 0xFD, 0xFF, 0xFF,
  0xFF, 0xFD, 0x9F, 0xFC, 0x00, 0x00, 0xBF, 0xF9, 0xFF, 0xFF,
  0xFF, 0xFD, 0x4F, 0xFF, 0x20, 0x01, 0xFF, 0xF4, 0xFF, 0xFF,
  0xFF, 0xFD, 0x0E, 0xFF, 0x60, 0x05, 0xFF, 0xE0, 0xFF, 0xFF,
  0xFF, 0xFD, 0x0A, 0xFF, 0xB0, 0x0A, 0xFF, 0x90, 0xFF, 0xFF,
  0xFF, 0xFD, 0x05, 0xFF, 0xF1, 0x0E, 0xFF, 0x50, 0xFF, 0xFF,
  0xFF, 0xFD, 0x01, 0xFF, 0xF5, 0x4F, 0xFE, 0x00, 0xFF, 0xFF,
  0xFF, 0xFD, 0x00, 0xAF, 0xFA, 0x8F, 0xFA, 0x00, 0xFF, 0xFF,
  0xFF, 0xFD, 0x00, 0x5F, 0xFE, 0xDF, 0xF5, 0x00, 0xFF, 0xFF,
  0xFF, 0xFD, 0x00, 0x1F, 0xFF, 0xFF, 0xF1, 0x00, 0xFF, 0xFF,
  0xFF, 0xFD, 0x00, 0x0B, 0xFF, 0xFF, 0xA0, 0x00, 0xFF, 0xFF,
  0xFF, 0xFD, 0x00, 0x06, 0xFF, 0xFF, 0x60, 0x00, 0xFF, 0xFF,
  0xFF, 0xFD, 0x00, 0x01, 0xFF, 0xFF, 0x10, 0x00, 0xEF, 0xFF,
  0xAF, 0xF8, 0x00, 0x00, 0xAF, 0xFA, 0x00, 0x00, 0x9F, 0xFA,
  0x05, 0x40, 0x00, 0x00, 0x04, 0x40, 0x00, 0x00, 0x04, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_004E[189] = { // Code 004E, LATIN CAPITAL LETTER N
  0x2A, 0xBB, 0x30, 0x00, 0x00, 0x00, 0x06, 0xBB, 0x30,
  0xCF, 0xFF, 0xE2, 0x00, 0x00, 0x00, 0x2F, 0xFF, 0xE0,
  0xFF, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0x40, 0x00, 0x00, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0x20, 0x00, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0xAF, 0xFF, 0xB0, 0x00, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x4B, 0xFF, 0xF6, 0x00, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x42, 0xFF, 0xFE, 0x10, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x40, 0x7F, 0xFF, 0x90, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x40, 0x0D, 0xFF, 0xF4, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x40, 0x03, 0xFF, 0xFD, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x40, 0x00, 0x9F, 0xFF, 0xBF, 0xFF, 0xF0,
  0xFF, 0xFF, 0x40, 0x00, 0x1D, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0x40, 0x00, 0x05, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0x40, 0x00, 0x00, 0xBF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0x40, 0x00, 0x00, 0x2E, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0x30, 0x00, 0x00, 0x06, 0xFF, 0xFF, 0xE0,
  0xAF, 0xFD, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xFF, 0x70,
  0x04, 0x51, 0x00, 0x00, 0x00, 0x00, 0x04, 0x63, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_004F[210] = { // Code 004F, LATIN CAPITAL LETTER O
  0x00, 0x00, 0x01, 0x6A, 0xCD, 0xDC, 0xA6, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x7E, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0x00,
  0x00, 0xBF, 0xFF, 0xFF, 0xDA, 0xAD, 0xFF, 0xFF, 0xFB, 0x00,
  0x07, 0xFF, 0xFF, 0xD3, 0x00, 0x00, 0x3C, 0xFF, 0xFF, 0x70,
  0x0E, 0xFF, 0xFD, 0x10, 0x00, 0x00, 0x01, 0xDF, 0xFF, 0xE1,
  0x4F, 0xFF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xFF, 0xF5,
  0x8F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x0E, 0xFF, 0xF9,
  0xBF, 0xFF, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xFF, 0xFB,
  0xBF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFF, 0xFD,
  0xBF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFF, 0xFD,
  0xBF, 0xFF, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xFF, 0xFB,
  0x9F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xF9,
  0x7F, 0xFF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xFF, 0xF6,
  0x2F, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x9F, 0xFF, 0xF1,
  0x0B, 0xFF, 0xFF, 0x50, 0x00, 0x00, 0x05, 0xFF, 0xFF, 0x90,
  0x03, 0xFF, 0xFF, 0xF9, 0x42, 0x24, 0xAF, 0xFF, 0xFE, 0x10,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x30, 0x00,
  0x00, 0x00, 0x2A, 0xFF, 0xFF, 0xFF, 0xFE, 0x71, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x67, 0x75, 0x30, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0050[189] = { // Code 0050, LATIN CAPITAL LETTER P
  0x04, 0x67, 0x77, 0x77, 0x76, 0x63, 0x00, 0x00, 0x00,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0x00, 0x00,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x02, 0x7F, 0xFF, 0xFC, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x08, 0xFF, 0xFF, 0x10,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0x20,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x06, 0xFF, 0xFF, 0x10,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x1D, 0xFF, 0xFE, 0x00,
  0xFF, 0xFF, 0xB7, 0x77, 0x7A, 0xEF, 0xFF, 0xF8, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD1, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x20, 0x00,
  0xFF, 0xFF, 0xED, 0xDD, 0xDD, 0xCA, 0x50, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFE, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0051[220] = { // Code 0051, LATIN CAPITAL LETTER Q
  0x00, 0x00, 0x01, 0x6A, 0xCD, 0xDC, 0xA6, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x7E, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0x00,
  0x00, 0xBF, 0xFF, 0xFF, 0xDA, 0xAD, 0xFF, 0xFF, 0xFB, 0x00,
  0x07, 0xFF, 0xFF, 0xD3, 0x00, 0x00, 0x3C, 0xFF, 0xFF, 0x70,
  0x0E, 0xFF, 0xFD, 0x10, 0x00, 0x00, 0x01, 0xDF, 0xFF, 0xE1,
  0x4F, 0xFF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xFF, 0xF5,
  0x8F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x0E, 0xFF, 0xF9,
  0xBF, 0xFF, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xFF, 0xFB,
  0xBF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFF, 0xFD,
  0xBF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFF, 0xFD,
  0xBF, 0xFF, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xFF, 0xFB,
  0x9F, 0xFF, 0xC0, 0x00, 0x00, 0x02, 0x00, 0x0C, 0xFF, 0xF9,
  0x7F, 0xFF, 0xF2, 0x00, 0x00, 0xAF, 0xB1, 0x2F, 0xFF, 0xF6,
  0x2F, 0xFF, 0xF8, 0x00, 0x00, 0xFF, 0xFC, 0xAF, 0xFF, 0xF1,
  0x0B, 0xFF, 0xFF, 0x50, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x90,
  0x03, 0xFF, 0xFF, 0xF9, 0x42, 0x2A, 0xFF, 0xFF, 0xFE, 0x20,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x30,
  0x00, 0x00, 0x2A, 0xFF, 0xFF, 0xFF, 0xFD, 0x8E, 0xFF, 0xE2,
  0x00, 0x00, 0x00, 0x03, 0x67, 0x75, 0x30, 0x02, 0xEF, 0xF1,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0052[189] = { // Code 0052, LATIN CAPITAL LETTER R
  0x04, 0x67, 0x77, 0x77, 0x77, 0x65, 0x30, 0x00, 0x00,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x50, 0x00,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x29, 0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0xEF, 0xFF, 0x90,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0xBF, 0xFF, 0x90,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0xDF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x08, 0xFF, 0xFE, 0x10,
  0xFF, 0xFF, 0xDB, 0xBB, 0xBC, 0xFF, 0xFF, 0xF5, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x30, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x00,
  0xFF, 0xFF, 0xB7, 0x77, 0x77, 0xCF, 0xFF, 0xFB, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x0B, 0xFF, 0xFE, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x05, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x02, 0xFF, 0xFF, 0x30,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x60,
  0xEF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0xEF, 0xFF, 0x90,
  0x7F, 0xFE, 0x20, 0x00, 0x00, 0x00, 0x6F, 0xFF, 0x40,
  0x03, 0x51, 0x00, 0x00, 0x00, 0x00, 0x02, 0x52, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0053[189] = { // Code 0053, LATIN CAPITAL LETTER S
  0x00, 0x01, 0x6A, 0xCD, 0xDC, 0x94, 0x00, 0x00, 0x00,
  0x00, 0x6E, 0xFF, 0xFF, 0xFF, 0xFF, 0xD5, 0x00, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70, 0x00,
  0x3F, 0xFF, 0xFE, 0x97, 0x8B, 0xFF, 0xFF, 0xF3, 0x00,
  0x9F, 0xFF, 0xD1, 0x00, 0x00, 0x3E, 0xFF, 0xF7, 0x00,
  0xBF, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xEF, 0xF4, 0x00,
  0xBF, 0xFF, 0xB0, 0x00, 0x00, 0x00, 0x26, 0x30, 0x00,
  0x9F, 0xFF, 0xFB, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x4F, 0xFF, 0xFF, 0xFF, 0xDA, 0x73, 0x00, 0x00, 0x00,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD6, 0x00, 0x00,
  0x00, 0x5D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0x00, 0x00, 0x37, 0xBF, 0xFF, 0xFF, 0xFF, 0xF9, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x47, 0xCF, 0xFF, 0xFF, 0x10,
  0x03, 0x30, 0x00, 0x00, 0x00, 0x08, 0xFF, 0xFF, 0x30,
  0x7F, 0xFA, 0x00, 0x00, 0x00, 0x02, 0xFF, 0xFF, 0x40,
  0xBF, 0xFF, 0x70, 0x00, 0x00, 0x05, 0xFF, 0xFF, 0x30,
  0xAF, 0xFF, 0xF8, 0x10, 0x00, 0x4E, 0xFF, 0xFE, 0x00,
  0x2E, 0xFF, 0xFF, 0xFC, 0xBE, 0xFF, 0xFF, 0xF6, 0x00,
  0x04, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x18, 0xEF, 0xFF, 0xFF, 0xFF, 0xB4, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x57, 0x76, 0x41, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0054[189] = { // Code 0054, LATIN CAPITAL LETTER T
  0x03, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x76, 0x30,
  0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0x4F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5,
  0x01, 0x44, 0x44, 0x7F, 0xFF, 0xF7, 0x44, 0x44, 0x20,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF3, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0B, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0055[189] = { // Code 0055, LATIN CAPITAL LETTER U
  0x2A, 0xB7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xBA, 0x20,
  0xCF, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x4F, 0xFF, 0xC0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xEF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xE0,
  0xCF, 0xFF, 0xA0, 0x00, 0x00, 0x00, 0xAF, 0xFF, 0xC0,
  0x9F, 0xFF, 0xF3, 0x00, 0x00, 0x02, 0xFF, 0xFF, 0x90,
  0x3F, 0xFF, 0xFE, 0x73, 0x23, 0x7E, 0xFF, 0xFF, 0x30,
  0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x00,
  0x01, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0x00, 0x06, 0xCF, 0xFF, 0xFF, 0xFF, 0xD6, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x56, 0x76, 0x52, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0056[189] = { // Code 0056, LATIN CAPITAL LETTER V
  0x1A, 0xB8, 0x00, 0x00, 0x00, 0x00, 0x02, 0xAB, 0x60,
  0xAF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xF2,
  0xBF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF3,
  0x7F, 0xFF, 0xF2, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xE0,
  0x2F, 0xFF, 0xF6, 0x00, 0x00, 0x00, 0xCF, 0xFF, 0x90,
  0x0B, 0xFF, 0xFB, 0x00, 0x00, 0x02, 0xFF, 0xFF, 0x30,
  0x06, 0xFF, 0xFF, 0x10, 0x00, 0x07, 0xFF, 0xFD, 0x00,
  0x01, 0xFF, 0xFF, 0x50, 0x00, 0x0B, 0xFF, 0xF8, 0x00,
  0x00, 0xAF, 0xFF, 0xA0, 0x00, 0x1F, 0xFF, 0xF2, 0x00,
  0x00, 0x5F, 0xFF, 0xE0, 0x00, 0x5F, 0xFF, 0xB0, 0x00,
  0x00, 0x0E, 0xFF, 0xF3, 0x00, 0xAF, 0xFF, 0x60, 0x00,
  0x00, 0x0A, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x04, 0xFF, 0xFD, 0x05, 0xFF, 0xFA, 0x00, 0x00,
  0x00, 0x00, 0xEF, 0xFF, 0x29, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0xFF, 0x7E, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xFF, 0xEF, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0xFF, 0xFF, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFD, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x02, 0xFF, 0xFF, 0xF7, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x9F, 0xFF, 0xD1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x64, 0x10, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0057[273] = { // Code 0057, LATIN CAPITAL LETTER W
  0x19, 0xB7, 0x00, 0x00, 0x00, 0x2A, 0xBA, 0x20, 0x00, 0x00, 0x07, 0xB9, 0x10,
  0x9F, 0xFF, 0x40, 0x00, 0x00, 0xBF, 0xFF, 0xB0, 0x00, 0x00, 0x3F, 0xFF, 0x90,
  0xBF, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xFF, 0xF1, 0x00, 0x00, 0x7F, 0xFF, 0xB0,
  0x8F, 0xFF, 0xB0, 0x00, 0x03, 0xFF, 0xFF, 0xF4, 0x00, 0x00, 0xAF, 0xFF, 0x80,
  0x4F, 0xFF, 0xE0, 0x00, 0x07, 0xFF, 0xFF, 0xF7, 0x00, 0x00, 0xDF, 0xFF, 0x40,
  0x1F, 0xFF, 0xF3, 0x00, 0x0A, 0xFF, 0xFF, 0xFB, 0x00, 0x01, 0xFF, 0xFF, 0x10,
  0x0B, 0xFF, 0xF5, 0x00, 0x0E, 0xFF, 0xDF, 0xFE, 0x00, 0x04, 0xFF, 0xFB, 0x00,
  0x07, 0xFF, 0xF8, 0x00, 0x2F, 0xFF, 0x6F, 0xFF, 0x30, 0x07, 0xFF, 0xF7, 0x00,
  0x04, 0xFF, 0xFB, 0x00, 0x6F, 0xFE, 0x0E, 0xFF, 0x70, 0x0B, 0xFF, 0xF4, 0x00,
  0x00, 0xFF, 0xFE, 0x00, 0x9F, 0xFA, 0x0A, 0xFF, 0xA0, 0x0E, 0xFF, 0xF0, 0x00,
  0x00, 0xBF, 0xFF, 0x30, 0xDF, 0xF7, 0x07, 0xFF, 0xD0, 0x2F, 0xFF, 0xB0, 0x00,
  0x00, 0x7F, 0xFF, 0x61, 0xFF, 0xF3, 0x03, 0xFF, 0xF2, 0x5F, 0xFF, 0x70, 0x00,
  0x00, 0x3F, 0xFF, 0x95, 0xFF, 0xE0, 0x00, 0xEF, 0xF5, 0x8F, 0xFF, 0x30, 0x00,
  0x00, 0x0E, 0xFF, 0xC8, 0xFF, 0xB0, 0x00, 0xBF, 0xF9, 0xBF, 0xFE, 0x00, 0x00,
  0x00, 0x0B, 0xFF, 0xFC, 0xFF, 0x70, 0x00, 0x7F, 0xFC, 0xEF, 0xFB, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0x30, 0x00, 0x3F, 0xFF, 0xFF, 0xF7, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x0E, 0xFF, 0xFF, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0xEF, 0xFF, 0xFB, 0x00, 0x00, 0x0B, 0xFF, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0xAF, 0xFF, 0xF7, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x3E, 0xFF, 0xE1, 0x00, 0x00, 0x01, 0xEF, 0xFE, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x55, 0x10, 0x00, 0x00, 0x00, 0x15, 0x52, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0058[168] = { // Code 0058, LATIN CAPITAL LETTER X
  0x03, 0xBB, 0x30, 0x00, 0x00, 0x01, 0xAB, 0x70,
  0x1E, 0xFF, 0xE1, 0x00, 0x00, 0x09, 0xFF, 0xF5,
  0x2F, 0xFF, 0xF9, 0x00, 0x00, 0x3F, 0xFF, 0xF7,
  0x0C, 0xFF, 0xFF, 0x30, 0x00, 0xCF, 0xFF, 0xE1,
  0x02, 0xFF, 0xFF, 0xB0, 0x07, 0xFF, 0xFF, 0x40,
  0x00, 0x7F, 0xFF, 0xF5, 0x2E, 0xFF, 0xF9, 0x00,
  0x00, 0x0C, 0xFF, 0xFD, 0xBF, 0xFF, 0xD1, 0x00,
  0x00, 0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0x40, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xF9, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xD1, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xD1, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xF9, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x40, 0x00,
  0x00, 0x0D, 0xFF, 0xFD, 0xDF, 0xFF, 0xD1, 0x00,
  0x00, 0x8F, 0xFF, 0xF4, 0x5F, 0xFF, 0xF8, 0x00,
  0x04, 0xFF, 0xFF, 0xA0, 0x0B, 0xFF, 0xFF, 0x30,
  0x1D, 0xFF, 0xFE, 0x10, 0x02, 0xFF, 0xFF, 0xD0,
  0x7F, 0xFF, 0xF6, 0x00, 0x00, 0x8F, 0xFF, 0xF7,
  0xAF, 0xFF, 0xB0, 0x00, 0x00, 0x1D, 0xFF, 0xF9,
  0x5F, 0xFE, 0x20, 0x00, 0x00, 0x05, 0xFF, 0xF4,
  0x02, 0x52, 0x00, 0x00, 0x00, 0x00, 0x25, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0059[189] = { // Code 0059, LATIN CAPITAL LETTER Y
  0x19, 0xB8, 0x00, 0x00, 0x00, 0x00, 0x2B, 0xB4, 0x00,
  0x9F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0xCF, 0xFF, 0x20,
  0xBF, 0xFF, 0xE1, 0x00, 0x00, 0x06, 0xFF, 0xFF, 0x30,
  0x4F, 0xFF, 0xF8, 0x00, 0x00, 0x0D, 0xFF, 0xFC, 0x00,
  0x0B, 0xFF, 0xFF, 0x20, 0x00, 0x7F, 0xFF, 0xF3, 0x00,
  0x02, 0xFF, 0xFF, 0xA0, 0x01, 0xEF, 0xFF, 0xA0, 0x00,
  0x00, 0x8F, 0xFF, 0xF3, 0x08, 0xFF, 0xFE, 0x10, 0x00,
  0x00, 0x0D, 0xFF, 0xFB, 0x1F, 0xFF, 0xF7, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0xFF, 0xCF, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x2F, 0xFF, 0xFF, 0xF9, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0xFF, 0xE1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xEF, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFE, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x51, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_005A[180] = { // Code 005A, LATIN CAPITAL LETTER Z
  0x00, 0x26, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x30,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7,
  0x02, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5,
  0x00, 0x14, 0x44, 0x44, 0x44, 0x4C, 0xFF, 0xFF, 0xA0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFC, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0xFF, 0xFF, 0xD1, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x3E, 0xFF, 0xFE, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x02, 0xEF, 0xFF, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0xFF, 0xF9, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x08, 0xFF, 0xFF, 0xB0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0xFF, 0xFD, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xFF, 0xFF, 0xE2, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2E, 0xFF, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x00,
  0x01, 0xDF, 0xFF, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0B, 0xFF, 0xFF, 0xFB, 0xBB, 0xBB, 0xBB, 0xBB, 0x71,
  0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9,
  0x07, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC2
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_005B[100] = { // Code 005B, LEFT SQUARE BRACKET
  0x04, 0x77, 0x77, 0x50,
  0x5F, 0xFF, 0xFF, 0xF5,
  0x9F, 0xFF, 0xFF, 0xF6,
  0x9F, 0xFE, 0x77, 0x50,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFF, 0xFF, 0xC2,
  0x8F, 0xFF, 0xFF, 0xF7,
  0x2C, 0xFF, 0xFF, 0xD3
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_005C[105] = { // Code 005C, REVERSE SOLIDUS
  0x5D, 0x90, 0x00, 0x00, 0x00,
  0xBF, 0xF3, 0x00, 0x00, 0x00,
  0x8F, 0xF9, 0x00, 0x00, 0x00,
  0x2F, 0xFE, 0x00, 0x00, 0x00,
  0x0B, 0xFF, 0x50, 0x00, 0x00,
  0x06, 0xFF, 0xB0, 0x00, 0x00,
  0x01, 0xEF, 0xF2, 0x00, 0x00,
  0x00, 0x9F, 0xF7, 0x00, 0x00,
  0x00, 0x3F, 0xFD, 0x00, 0x00,
  0x00, 0x0D, 0xFF, 0x40, 0x00,
  0x00, 0x07, 0xFF, 0xA0, 0x00,
  0x00, 0x02, 0xFF, 0xF1, 0x00,
  0x00, 0x00, 0xBF, 0xF6, 0x00,
  0x00, 0x00, 0x5F, 0xFC, 0x00,
  0x00, 0x00, 0x0E, 0xFF, 0x20,
  0x00, 0x00, 0x09, 0xFF, 0x80,
  0x00, 0x00, 0x03, 0xFF, 0xE0,
  0x00, 0x00, 0x00, 0xCF, 0xF4,
  0x00, 0x00, 0x00, 0x7F, 0xFA,
  0x00, 0x00, 0x00, 0x1E, 0xFA,
  0x00, 0x00, 0x00, 0x03, 0x71
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_005D[100] = { // Code 005D, RIGHT SQUARE BRACKET
  0x26, 0x77, 0x75, 0x10,
  0xDF, 0xFF, 0xFF, 0xD0,
  0xDF, 0xFF, 0xFF, 0xF2,
  0x27, 0x7A, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x8E, 0xFF, 0xFF, 0xF2,
  0xEF, 0xFF, 0xFF, 0xF1,
  0x8F, 0xFF, 0xFE, 0x70
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_005E[ 77] = { // Code 005E, CIRCUMFLEX ACCENT
  0x00, 0x00, 0x02, 0xBC, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0xFF, 0xE1, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0xFF, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0xDF, 0xFF, 0xFF, 0x20, 0x00,
  0x00, 0x07, 0xFF, 0xEC, 0xFF, 0x90, 0x00,
  0x00, 0x1E, 0xFF, 0x74, 0xFF, 0xF3, 0x00,
  0x00, 0x8F, 0xFE, 0x00, 0xBF, 0xFB, 0x00,
  0x02, 0xFF, 0xF6, 0x00, 0x3F, 0xFF, 0x40,
  0x09, 0xFF, 0xC0, 0x00, 0x09, 0xFF, 0xC0,
  0x1F, 0xFF, 0x40, 0x00, 0x02, 0xFF, 0xF4,
  0x1D, 0xF9, 0x00, 0x00, 0x00, 0x6F, 0xF3
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_005F[ 16] = { // Code 005F, LOW LINE
  0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3,
  0x36, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0060[ 18] = { // Code 0060, GRAVE ACCENT
  0x37, 0x30, 0x00,
  0xEF, 0xF7, 0x00,
  0xCF, 0xFF, 0xA1,
  0x1B, 0xFF, 0xFC,
  0x00, 0x6E, 0xFF,
  0x00, 0x02, 0x73
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0061[128] = { // Code 0061, LATIN SMALL LETTER A
  0x00, 0x00, 0x25, 0x77, 0x65, 0x10, 0x00, 0x00,
  0x00, 0x3B, 0xFF, 0xFF, 0xFF, 0xFB, 0x20, 0x00,
  0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0x00,
  0x0D, 0xFF, 0xFC, 0x87, 0xAF, 0xFF, 0xF7, 0x00,
  0x0E, 0xFF, 0x70, 0x00, 0x06, 0xFF, 0xF9, 0x00,
  0x03, 0x95, 0x00, 0x00, 0x05, 0xFF, 0xF9, 0x00,
  0x00, 0x00, 0x13, 0x56, 0x8E, 0xFF, 0xF9, 0x00,
  0x00, 0x7C, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x00,
  0x1C, 0xFF, 0xFF, 0xFF, 0xDB, 0xFF, 0xF9, 0x00,
  0x8F, 0xFF, 0xD7, 0x31, 0x04, 0xFF, 0xF9, 0x00,
  0xCF, 0xFF, 0x30, 0x00, 0x06, 0xFF, 0xF9, 0x00,
  0xDF, 0xFF, 0x20, 0x00, 0x1D, 0xFF, 0xFA, 0x00,
  0xBF, 0xFF, 0xC5, 0x46, 0xDF, 0xFF, 0xFC, 0x00,
  0x3F, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0x00,
  0x04, 0xDF, 0xFF, 0xFD, 0x50, 0x9F, 0xFC, 0x00,
  0x00, 0x03, 0x64, 0x20, 0x00, 0x04, 0x51, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0062[168] = { // Code 0062, LATIN SMALL LETTER B
  0x08, 0xB9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x26, 0x76, 0x20, 0x00, 0x00,
  0x7F, 0xFF, 0x78, 0xFF, 0xFF, 0xFA, 0x10, 0x00,
  0x7F, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00,
  0x7F, 0xFF, 0xFF, 0xB9, 0xCF, 0xFF, 0xF7, 0x00,
  0x7F, 0xFF, 0xF6, 0x00, 0x07, 0xFF, 0xFE, 0x00,
  0x7F, 0xFF, 0xB0, 0x00, 0x00, 0xDF, 0xFF, 0x40,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x8F, 0xFF, 0x70,
  0x7F, 0xFF, 0x50, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x50, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x9F, 0xFF, 0x60,
  0x7F, 0xFF, 0xB0, 0x00, 0x00, 0xEF, 0xFF, 0x30,
  0x7F, 0xFF, 0xF7, 0x00, 0x09, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xFF, 0xDB, 0xEF, 0xFF, 0xF6, 0x00,
  0x7F, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xA0, 0x00,
  0x3F, 0xFD, 0x08, 0xFF, 0xFF, 0xE7, 0x00, 0x00,
  0x03, 0x51, 0x00, 0x14, 0x63, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0063[112] = { // Code 0063, LATIN SMALL LETTER C
  0x00, 0x00, 0x01, 0x57, 0x75, 0x20, 0x00,
  0x00, 0x02, 0xAF, 0xFF, 0xFF, 0xFB, 0x30,
  0x00, 0x3E, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4,
  0x01, 0xDF, 0xFF, 0xEA, 0xAD, 0xFF, 0xFC,
  0x07, 0xFF, 0xFD, 0x20, 0x00, 0xBF, 0xFE,
  0x0D, 0xFF, 0xF4, 0x00, 0x00, 0x1B, 0xD6,
  0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00,
  0x2F, 0xFF, 0xB0, 0x00, 0x00, 0x00, 0x00,
  0x2F, 0xFF, 0xB0, 0x00, 0x00, 0x00, 0x00,
  0x2F, 0xFF, 0xD0, 0x00, 0x00, 0x02, 0x30,
  0x0E, 0xFF, 0xF3, 0x00, 0x00, 0x3E, 0xFB,
  0x09, 0xFF, 0xFD, 0x20, 0x02, 0xDF, 0xFE,
  0x02, 0xEF, 0xFF, 0xFC, 0xBF, 0xFF, 0xF9,
  0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xFF, 0xD1,
  0x00, 0x02, 0xAF, 0xFF, 0xFF, 0xE8, 0x10,
  0x00, 0x00, 0x01, 0x35, 0x53, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0064[147] = { // Code 0064, LATIN SMALL LETTER D
  0x00, 0x00, 0x00, 0x00, 0x00, 0x4B, 0xB3,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xEF, 0xFC,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x47, 0x74, 0x00, 0xFF, 0xFF,
  0x00, 0x4E, 0xFF, 0xFF, 0xD2, 0xFF, 0xFF,
  0x05, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF,
  0x1E, 0xFF, 0xFE, 0xAA, 0xEF, 0xFF, 0xFF,
  0x7F, 0xFF, 0xD2, 0x00, 0x1C, 0xFF, 0xFF,
  0xBF, 0xFF, 0x60, 0x00, 0x04, 0xFF, 0xFF,
  0xEF, 0xFF, 0x10, 0x00, 0x00, 0xEF, 0xFF,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0xCF, 0xFF,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0xCF, 0xFF,
  0xEF, 0xFF, 0x10, 0x00, 0x00, 0xEF, 0xFF,
  0xBF, 0xFF, 0x70, 0x00, 0x04, 0xFF, 0xFF,
  0x6F, 0xFF, 0xE3, 0x00, 0x2D, 0xFF, 0xFF,
  0x0D, 0xFF, 0xFF, 0xCC, 0xFF, 0xFF, 0xFF,
  0x03, 0xEF, 0xFF, 0xFF, 0xFE, 0xAF, 0xFE,
  0x00, 0x3B, 0xFF, 0xFF, 0xD3, 0x6F, 0xFB,
  0x00, 0x00, 0x25, 0x53, 0x00, 0x04, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0065[128] = { // Code 0065, LATIN SMALL LETTER E
  0x00, 0x00, 0x04, 0x67, 0x63, 0x00, 0x00, 0x00,
  0x00, 0x08, 0xEF, 0xFF, 0xFF, 0xD5, 0x00, 0x00,
  0x01, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0, 0x00,
  0x0B, 0xFF, 0xFC, 0x64, 0x7D, 0xFF, 0xF7, 0x00,
  0x4F, 0xFF, 0xB0, 0x00, 0x01, 0xDF, 0xFF, 0x10,
  0xAF, 0xFF, 0x30, 0x00, 0x00, 0x6F, 0xFF, 0x50,
  0xDF, 0xFF, 0x99, 0x99, 0x99, 0xBF, 0xFF, 0x70,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0xBB, 0xBB, 0xBB, 0xBB, 0xB9, 0x20,
  0xEF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0xFF, 0x50, 0x00, 0x00, 0x08, 0x91, 0x00,
  0x5F, 0xFF, 0xE4, 0x00, 0x02, 0xCF, 0xFA, 0x00,
  0x0B, 0xFF, 0xFF, 0xDB, 0xCF, 0xFF, 0xFA, 0x00,
  0x01, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x00,
  0x00, 0x06, 0xDF, 0xFF, 0xFF, 0xD7, 0x10, 0x00,
  0x00, 0x00, 0x02, 0x46, 0x42, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0066[105] = { // Code 0066, LATIN SMALL LETTER F
  0x00, 0x00, 0x3A, 0xDD, 0xA2,
  0x00, 0x05, 0xFF, 0xFF, 0xFA,
  0x00, 0x0E, 0xFF, 0xFF, 0xF9,
  0x00, 0x2F, 0xFF, 0xE4, 0x51,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x01, 0x5F, 0xFF, 0xC2, 0x10,
  0x7F, 0xFF, 0xFF, 0xFF, 0xF8,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFA,
  0x17, 0x9F, 0xFF, 0xD7, 0x71,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x3F, 0xFF, 0xB0, 0x00,
  0x00, 0x0D, 0xFF, 0x70, 0x00,
  0x00, 0x01, 0x53, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0067[147] = { // Code 0067, LATIN SMALL LETTER G
  0x00, 0x00, 0x47, 0x75, 0x00, 0x06, 0x71,
  0x00, 0x4D, 0xFF, 0xFF, 0xE3, 0x7F, 0xFB,
  0x04, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 0xFE,
  0x1E, 0xFF, 0xFE, 0xA9, 0xDF, 0xFF, 0xFF,
  0x7F, 0xFF, 0xD1, 0x00, 0x0B, 0xFF, 0xFF,
  0xBF, 0xFF, 0x40, 0x00, 0x02, 0xFF, 0xFF,
  0xEF, 0xFF, 0x00, 0x00, 0x00, 0xEF, 0xFF,
  0xFF, 0xFD, 0x00, 0x00, 0x00, 0xDF, 0xFF,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0xDF, 0xFF,
  0xEF, 0xFF, 0x30, 0x00, 0x01, 0xFF, 0xFF,
  0xAF, 0xFF, 0xA0, 0x00, 0x08, 0xFF, 0xFF,
  0x4F, 0xFF, 0xFB, 0x55, 0xAF, 0xFF, 0xFF,
  0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x9F, 0xFF, 0xFF, 0xF6, 0xDF, 0xFF,
  0x00, 0x02, 0x79, 0x97, 0x10, 0xDF, 0xFD,
  0x00, 0x20, 0x00, 0x00, 0x01, 0xFF, 0xFC,
  0x0A, 0xFD, 0x30, 0x00, 0x06, 0xFF, 0xF8,
  0x0F, 0xFF, 0xE7, 0x23, 0x7F, 0xFF, 0xF2,
  0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x01, 0xAF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0x03, 0x7A, 0xBB, 0xA6, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0068[147] = { // Code 0068, LATIN SMALL LETTER H
  0x08, 0xB9, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0x60, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x05, 0x77, 0x40, 0x00,
  0x7F, 0xFF, 0x75, 0xEF, 0xFF, 0xFD, 0x30,
  0x7F, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xE2,
  0x7F, 0xFF, 0xFF, 0xEB, 0xEF, 0xFF, 0xF9,
  0x7F, 0xFF, 0xF9, 0x00, 0x0A, 0xFF, 0xFD,
  0x7F, 0xFF, 0xC0, 0x00, 0x02, 0xFF, 0xFE,
  0x7F, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x6F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFE,
  0x3F, 0xFF, 0x30, 0x00, 0x00, 0xBF, 0xFA,
  0x02, 0x62, 0x00, 0x00, 0x00, 0x05, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0069[ 63] = { // Code 0069, LATIN SMALL LETTER I
  0x07, 0xDB, 0x20,
  0x3F, 0xFF, 0xA0,
  0x3F, 0xFF, 0xB0,
  0x0B, 0xFF, 0x40,
  0x00, 0x31, 0x00,
  0x03, 0x76, 0x00,
  0x1E, 0xFF, 0x70,
  0x3F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x3F, 0xFF, 0xB0,
  0x0D, 0xFF, 0x60,
  0x01, 0x54, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_006A[104] = { // Code 006A, LATIN SMALL LETTER J
  0x00, 0x07, 0xDB, 0x20,
  0x00, 0x3F, 0xFF, 0xA0,
  0x00, 0x3F, 0xFF, 0xB0,
  0x00, 0x0B, 0xFF, 0x40,
  0x00, 0x00, 0x31, 0x00,
  0x00, 0x03, 0x76, 0x00,
  0x00, 0x1E, 0xFF, 0x70,
  0x00, 0x3F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x17, 0xAF, 0xFF, 0xA0,
  0x6F, 0xFF, 0xFF, 0x60,
  0x5F, 0xFF, 0xFC, 0x00,
  0x06, 0x98, 0x50, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_006B[147] = { // Code 006B, LATIN SMALL LETTER K
  0x08, 0xB9, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0x60, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x03, 0x72, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x5F, 0xFE, 0x10,
  0x7F, 0xFF, 0x70, 0x03, 0xFF, 0xFF, 0x30,
  0x7F, 0xFF, 0x70, 0x2E, 0xFF, 0xFB, 0x00,
  0x7F, 0xFF, 0x72, 0xEF, 0xFF, 0xB1, 0x00,
  0x7F, 0xFF, 0x9D, 0xFF, 0xFB, 0x10, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xE1, 0x00, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xF6, 0x00, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0x30, 0x00,
  0x7F, 0xFF, 0xF8, 0xDF, 0xFF, 0xC0, 0x00,
  0x7F, 0xFF, 0x90, 0x3F, 0xFF, 0xF9, 0x00,
  0x7F, 0xFF, 0x70, 0x07, 0xFF, 0xFF, 0x50,
  0x7F, 0xFF, 0x70, 0x00, 0xBF, 0xFF, 0xE1,
  0x6F, 0xFF, 0x70, 0x00, 0x2E, 0xFF, 0xF3,
  0x3F, 0xFF, 0x30, 0x00, 0x05, 0xFF, 0xD0,
  0x02, 0x52, 0x00, 0x00, 0x00, 0x25, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_006C[ 63] = { // Code 006C, LATIN SMALL LETTER L
  0x06, 0xBA, 0x10,
  0x2F, 0xFF, 0x90,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x3F, 0xFF, 0xB0,
  0x0D, 0xFF, 0x60,
  0x01, 0x53, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_006D[192] = { // Code 006D, LATIN SMALL LETTER M
  0x03, 0x73, 0x00, 0x04, 0x77, 0x40, 0x00, 0x02, 0x67, 0x63, 0x00, 0x00,
  0x3F, 0xFE, 0x14, 0xDF, 0xFF, 0xFB, 0x10, 0x9F, 0xFF, 0xFF, 0xC1, 0x00,
  0x7F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x7F, 0xFF, 0xFF, 0xEB, 0xEF, 0xFF, 0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0x30,
  0x7F, 0xFF, 0xF8, 0x00, 0x1E, 0xFF, 0xFF, 0x70, 0x02, 0xEF, 0xFF, 0x60,
  0x7F, 0xFF, 0xC0, 0x00, 0x08, 0xFF, 0xFB, 0x00, 0x00, 0x9F, 0xFF, 0x70,
  0x7F, 0xFF, 0x80, 0x00, 0x07, 0xFF, 0xF7, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x70, 0x00, 0x07, 0xFF, 0xF7, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x70, 0x00, 0x07, 0xFF, 0xF7, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x70, 0x00, 0x07, 0xFF, 0xF7, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x70, 0x00, 0x07, 0xFF, 0xF7, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x70, 0x00, 0x07, 0xFF, 0xF7, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x70, 0x00, 0x07, 0xFF, 0xF7, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x6F, 0xFF, 0x70, 0x00, 0x07, 0xFF, 0xF7, 0x00, 0x00, 0x7F, 0xFF, 0x60,
  0x3F, 0xFF, 0x30, 0x00, 0x03, 0xFF, 0xF3, 0x00, 0x00, 0x3F, 0xFF, 0x30,
  0x02, 0x62, 0x00, 0x00, 0x00, 0x26, 0x20, 0x00, 0x00, 0x02, 0x62, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_006E[112] = { // Code 006E, LATIN SMALL LETTER N
  0x04, 0x73, 0x00, 0x05, 0x77, 0x40, 0x00,
  0x3F, 0xFE, 0x05, 0xEF, 0xFF, 0xFD, 0x30,
  0x7F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 0xE2,
  0x7F, 0xFF, 0xFF, 0xEB, 0xEF, 0xFF, 0xF9,
  0x7F, 0xFF, 0xF9, 0x00, 0x0A, 0xFF, 0xFD,
  0x7F, 0xFF, 0xC0, 0x00, 0x02, 0xFF, 0xFE,
  0x7F, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x6F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFE,
  0x3F, 0xFF, 0x30, 0x00, 0x00, 0xBF, 0xFA,
  0x02, 0x62, 0x00, 0x00, 0x00, 0x05, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_006F[128] = { // Code 006F, LATIN SMALL LETTER O
  0x00, 0x00, 0x15, 0x77, 0x63, 0x00, 0x00, 0x00,
  0x00, 0x19, 0xFF, 0xFF, 0xFF, 0xD5, 0x00, 0x00,
  0x02, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x0C, 0xFF, 0xFE, 0x87, 0xAF, 0xFF, 0xF5, 0x00,
  0x5F, 0xFF, 0xD1, 0x00, 0x06, 0xFF, 0xFD, 0x00,
  0xBF, 0xFF, 0x50, 0x00, 0x00, 0xCF, 0xFF, 0x30,
  0xEF, 0xFF, 0x10, 0x00, 0x00, 0x8F, 0xFF, 0x70,
  0xFF, 0xFD, 0x00, 0x00, 0x00, 0x6F, 0xFF, 0x70,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0x6F, 0xFF, 0x70,
  0xEF, 0xFF, 0x10, 0x00, 0x00, 0x8F, 0xFF, 0x70,
  0xBF, 0xFF, 0x60, 0x00, 0x00, 0xDF, 0xFF, 0x30,
  0x5F, 0xFF, 0xE2, 0x00, 0x08, 0xFF, 0xFD, 0x00,
  0x0C, 0xFF, 0xFF, 0xA9, 0xCF, 0xFF, 0xF6, 0x00,
  0x02, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x18, 0xEF, 0xFF, 0xFF, 0xC4, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x56, 0x42, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0070[168] = { // Code 0070, LATIN SMALL LETTER P
  0x04, 0x73, 0x00, 0x26, 0x75, 0x20, 0x00, 0x00,
  0x4F, 0xFE, 0x1A, 0xFF, 0xFF, 0xF9, 0x10, 0x00,
  0x7F, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00,
  0x7F, 0xFF, 0xFF, 0xB9, 0xCF, 0xFF, 0xF7, 0x00,
  0x7F, 0xFF, 0xF5, 0x00, 0x08, 0xFF, 0xFE, 0x00,
  0x7F, 0xFF, 0xB0, 0x00, 0x00, 0xDF, 0xFF, 0x40,
  0x7F, 0xFF, 0x60, 0x00, 0x00, 0x8F, 0xFF, 0x70,
  0x7F, 0xFF, 0x40, 0x00, 0x00, 0x6F, 0xFF, 0x70,
  0x7F, 0xFF, 0x50, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x9F, 0xFF, 0x70,
  0x7F, 0xFF, 0xC0, 0x00, 0x00, 0xDF, 0xFF, 0x30,
  0x7F, 0xFF, 0xF8, 0x00, 0x09, 0xFF, 0xFE, 0x00,
  0x7F, 0xFF, 0xFF, 0xDB, 0xDF, 0xFF, 0xF6, 0x00,
  0x7F, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xA0, 0x00,
  0x7F, 0xFF, 0x76, 0xEF, 0xFF, 0xF8, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x14, 0x64, 0x10, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x4F, 0xFF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x05, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0071[147] = { // Code 0071, LATIN SMALL LETTER Q
  0x00, 0x00, 0x47, 0x75, 0x00, 0x06, 0x71,
  0x00, 0x4D, 0xFF, 0xFF, 0xE4, 0x7F, 0xFB,
  0x04, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 0xFE,
  0x1E, 0xFF, 0xFF, 0xAA, 0xEF, 0xFF, 0xFF,
  0x7F, 0xFF, 0xE2, 0x00, 0x1C, 0xFF, 0xFF,
  0xBF, 0xFF, 0x60, 0x00, 0x03, 0xFF, 0xFF,
  0xEF, 0xFF, 0x10, 0x00, 0x00, 0xEF, 0xFF,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0xCF, 0xFF,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0xCF, 0xFF,
  0xEF, 0xFF, 0x10, 0x00, 0x00, 0xEF, 0xFF,
  0xBF, 0xFF, 0x60, 0x00, 0x05, 0xFF, 0xFF,
  0x6F, 0xFF, 0xE3, 0x00, 0x2D, 0xFF, 0xFF,
  0x0D, 0xFF, 0xFF, 0xCC, 0xFF, 0xFF, 0xFF,
  0x04, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF,
  0x00, 0x3C, 0xFF, 0xFF, 0xB1, 0xFF, 0xFF,
  0x00, 0x00, 0x35, 0x52, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFE,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0xFB,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x81
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0072[ 80] = { // Code 0072, LATIN SMALL LETTER R
  0x03, 0x73, 0x00, 0x37, 0x50,
  0x1E, 0xFF, 0x26, 0xFF, 0xF8,
  0x4F, 0xFF, 0x7F, 0xFF, 0xFC,
  0x4F, 0xFF, 0xDF, 0xFF, 0xF8,
  0x4F, 0xFF, 0xFE, 0x86, 0x50,
  0x4F, 0xFF, 0xF5, 0x00, 0x00,
  0x4F, 0xFF, 0xE0, 0x00, 0x00,
  0x4F, 0xFF, 0xB0, 0x00, 0x00,
  0x4F, 0xFF, 0xB0, 0x00, 0x00,
  0x4F, 0xFF, 0xB0, 0x00, 0x00,
  0x4F, 0xFF, 0xB0, 0x00, 0x00,
  0x4F, 0xFF, 0xB0, 0x00, 0x00,
  0x4F, 0xFF, 0xB0, 0x00, 0x00,
  0x3F, 0xFF, 0xB0, 0x00, 0x00,
  0x0D, 0xFF, 0x60, 0x00, 0x00,
  0x01, 0x54, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0073[112] = { // Code 0073, LATIN SMALL LETTER S
  0x00, 0x00, 0x35, 0x77, 0x52, 0x00, 0x00,
  0x00, 0x3C, 0xFF, 0xFF, 0xFF, 0xD5, 0x00,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x0C, 0xFF, 0xFC, 0x77, 0xAF, 0xFF, 0xD0,
  0x0F, 0xFF, 0xE0, 0x00, 0x05, 0xEF, 0x90,
  0x0F, 0xFF, 0xF7, 0x10, 0x00, 0x13, 0x00,
  0x0C, 0xFF, 0xFF, 0xFC, 0x95, 0x10, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xF8, 0x10,
  0x00, 0x29, 0xEF, 0xFF, 0xFF, 0xFF, 0xB0,
  0x00, 0x00, 0x03, 0x7B, 0xEF, 0xFF, 0xF5,
  0x07, 0xC7, 0x00, 0x00, 0x0A, 0xFF, 0xF7,
  0x0F, 0xFF, 0x90, 0x00, 0x07, 0xFF, 0xF7,
  0x0E, 0xFF, 0xFC, 0x76, 0x9F, 0xFF, 0xF2,
  0x04, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x00, 0x29, 0xEF, 0xFF, 0xFF, 0xC4, 0x00,
  0x00, 0x00, 0x03, 0x46, 0x41, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0074[100] = { // Code 0074, LATIN SMALL LETTER T
  0x00, 0x03, 0x74, 0x00, 0x00,
  0x00, 0x3F, 0xFF, 0x50, 0x00,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x01, 0x7F, 0xFF, 0x82, 0x10,
  0x7F, 0xFF, 0xFF, 0xFF, 0xF5,
  0x9F, 0xFF, 0xFF, 0xFF, 0xF7,
  0x17, 0xAF, 0xFF, 0xB7, 0x60,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x00, 0x6F, 0xFF, 0x80, 0x00,
  0x00, 0x5F, 0xFF, 0xFB, 0xA2,
  0x00, 0x2F, 0xFF, 0xFF, 0xF7,
  0x00, 0x06, 0xFF, 0xFF, 0xE3,
  0x00, 0x00, 0x14, 0x64, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0075[112] = { // Code 0075, LATIN SMALL LETTER U
  0x04, 0x74, 0x00, 0x00, 0x00, 0x17, 0x71,
  0x3F, 0xFF, 0x40, 0x00, 0x00, 0xCF, 0xFB,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFE,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x01, 0xFF, 0xFF,
  0x6F, 0xFF, 0xB0, 0x00, 0x06, 0xFF, 0xFF,
  0x5F, 0xFF, 0xF5, 0x00, 0x5E, 0xFF, 0xFF,
  0x1F, 0xFF, 0xFF, 0xEE, 0xFF, 0xFF, 0xFF,
  0x07, 0xFF, 0xFF, 0xFF, 0xFB, 0xAF, 0xFE,
  0x00, 0x7F, 0xFF, 0xFF, 0x80, 0x6F, 0xFA,
  0x00, 0x01, 0x46, 0x41, 0x00, 0x04, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0076[112] = { // Code 0076, LATIN SMALL LETTER V
  0x05, 0x61, 0x00, 0x00, 0x00, 0x37, 0x20,
  0x8F, 0xFC, 0x00, 0x00, 0x04, 0xFF, 0xE1,
  0xBF, 0xFF, 0x30, 0x00, 0x0A, 0xFF, 0xF4,
  0x9F, 0xFF, 0x70, 0x00, 0x0E, 0xFF, 0xF2,
  0x3F, 0xFF, 0xB0, 0x00, 0x4F, 0xFF, 0xB0,
  0x0D, 0xFF, 0xF1, 0x00, 0x8F, 0xFF, 0x60,
  0x08, 0xFF, 0xF5, 0x00, 0xDF, 0xFF, 0x10,
  0x02, 0xFF, 0xFA, 0x02, 0xFF, 0xFA, 0x00,
  0x00, 0xCF, 0xFE, 0x07, 0xFF, 0xF4, 0x00,
  0x00, 0x7F, 0xFF, 0x4B, 0xFF, 0xE0, 0x00,
  0x00, 0x1F, 0xFF, 0x9F, 0xFF, 0x90, 0x00,
  0x00, 0x0B, 0xFF, 0xFF, 0xFF, 0x30, 0x00,
  0x00, 0x05, 0xFF, 0xFF, 0xFD, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0xFF, 0xE2, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x65, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0077[176] = { // Code 0077, LATIN SMALL LETTER W
  0x04, 0x72, 0x00, 0x00, 0x05, 0x75, 0x00, 0x00, 0x02, 0x74, 0x00,
  0x6F, 0xFE, 0x00, 0x00, 0x6F, 0xFF, 0x70, 0x00, 0x0D, 0xFF, 0x60,
  0x9F, 0xFF, 0x30, 0x00, 0xCF, 0xFF, 0xD0, 0x00, 0x3F, 0xFF, 0x90,
  0x7F, 0xFF, 0x70, 0x01, 0xFF, 0xFF, 0xF2, 0x00, 0x7F, 0xFF, 0x70,
  0x2F, 0xFF, 0xB0, 0x04, 0xFF, 0xFF, 0xF5, 0x00, 0xAF, 0xFF, 0x30,
  0x0D, 0xFF, 0xE0, 0x07, 0xFF, 0xEF, 0xF9, 0x00, 0xEF, 0xFD, 0x00,
  0x08, 0xFF, 0xF3, 0x0A, 0xFF, 0x7F, 0xFC, 0x02, 0xFF, 0xF8, 0x00,
  0x03, 0xFF, 0xF7, 0x0D, 0xFE, 0x0E, 0xFF, 0x05, 0xFF, 0xF4, 0x00,
  0x00, 0xEF, 0xFA, 0x2F, 0xFB, 0x0B, 0xFF, 0x38, 0xFF, 0xE0, 0x00,
  0x00, 0x9F, 0xFE, 0x5F, 0xF7, 0x07, 0xFF, 0x7C, 0xFF, 0xA0, 0x00,
  0x00, 0x5F, 0xFF, 0xBF, 0xF3, 0x03, 0xFF, 0xBF, 0xFF, 0x50, 0x00,
  0x00, 0x1F, 0xFF, 0xFF, 0xE0, 0x00, 0xEF, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x0B, 0xFF, 0xFF, 0xB0, 0x00, 0xBF, 0xFF, 0xFB, 0x00, 0x00,
  0x00, 0x06, 0xFF, 0xFF, 0x70, 0x00, 0x7F, 0xFF, 0xF6, 0x00, 0x00,
  0x00, 0x01, 0xEF, 0xFE, 0x20, 0x00, 0x2E, 0xFF, 0xE1, 0x00, 0x00,
  0x00, 0x00, 0x15, 0x52, 0x00, 0x00, 0x02, 0x55, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0078[112] = { // Code 0078, LATIN SMALL LETTER X
  0x01, 0x75, 0x00, 0x00, 0x02, 0x73, 0x00,
  0x0D, 0xFF, 0x60, 0x00, 0x2E, 0xFF, 0x30,
  0x3F, 0xFF, 0xE1, 0x00, 0xBF, 0xFF, 0x50,
  0x0D, 0xFF, 0xFA, 0x05, 0xFF, 0xFE, 0x10,
  0x03, 0xFF, 0xFF, 0x4D, 0xFF, 0xF5, 0x00,
  0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0xA0, 0x00,
  0x00, 0x0D, 0xFF, 0xFF, 0xFE, 0x10, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xF9, 0x00, 0x00,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0x40, 0x00,
  0x00, 0xCF, 0xFF, 0xCF, 0xFF, 0xD1, 0x00,
  0x08, 0xFF, 0xFC, 0x0D, 0xFF, 0xF9, 0x00,
  0x3F, 0xFF, 0xF3, 0x03, 0xFF, 0xFF, 0x40,
  0x7F, 0xFF, 0x80, 0x00, 0x9F, 0xFF, 0x70,
  0x3F, 0xFD, 0x10, 0x00, 0x1D, 0xFF, 0x30,
  0x02, 0x51, 0x00, 0x00, 0x01, 0x52, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0079[147] = { // Code 0079, LATIN SMALL LETTER Y
  0x04, 0x72, 0x00, 0x00, 0x00, 0x57, 0x10,
  0x6F, 0xFE, 0x10, 0x00, 0x06, 0xFF, 0xD0,
  0x9F, 0xFF, 0x60, 0x00, 0x0C, 0xFF, 0xF2,
  0x7F, 0xFF, 0xA0, 0x00, 0x1F, 0xFF, 0xD0,
  0x2F, 0xFF, 0xE0, 0x00, 0x5F, 0xFF, 0x80,
  0x0B, 0xFF, 0xF3, 0x00, 0x9F, 0xFF, 0x30,
  0x06, 0xFF, 0xF7, 0x00, 0xDF, 0xFC, 0x00,
  0x01, 0xFF, 0xFC, 0x02, 0xFF, 0xF7, 0x00,
  0x00, 0xAF, 0xFF, 0x16, 0xFF, 0xF2, 0x00,
  0x00, 0x5F, 0xFF, 0x5A, 0xFF, 0xB0, 0x00,
  0x00, 0x1E, 0xFF, 0x9E, 0xFF, 0x70, 0x00,
  0x00, 0x0A, 0xFF, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x05, 0xFF, 0xFF, 0xFB, 0x00, 0x00,
  0x00, 0x00, 0xEF, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0xFF, 0xF1, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xFF, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0xFF, 0x50, 0x00, 0x00,
  0x02, 0xAD, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0x09, 0xFF, 0xFF, 0xF6, 0x00, 0x00, 0x00,
  0x07, 0xFF, 0xFF, 0xA0, 0x00, 0x00, 0x00,
  0x00, 0x69, 0x84, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_007A[120] = { // Code 007A, LATIN SMALL LETTER Z
  0x00, 0x12, 0x22, 0x22, 0x22, 0x22, 0x20, 0x00,
  0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x03, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xBF, 0xFF, 0xD1, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0xFF, 0xFD, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x9F, 0xFF, 0xE2, 0x00, 0x00,
  0x00, 0x00, 0x08, 0xFF, 0xFE, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0xFF, 0x50, 0x00, 0x00, 0x00,
  0x00, 0x4F, 0xFF, 0xF7, 0x00, 0x00, 0x00, 0x00,
  0x03, 0xEF, 0xFF, 0x92, 0x22, 0x22, 0x20, 0x00,
  0x1E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30,
  0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_007B[125] = { // Code 007B, LEFT CURLY BRACKET
  0x00, 0x00, 0x26, 0x77, 0x60,
  0x00, 0x06, 0xFF, 0xFF, 0xF6,
  0x00, 0x1F, 0xFF, 0xFF, 0xE3,
  0x00, 0x3F, 0xFF, 0x90, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x5F, 0xFF, 0x40, 0x00,
  0x48, 0xEF, 0xFD, 0x00, 0x00,
  0xEF, 0xFE, 0x92, 0x00, 0x00,
  0xAF, 0xFF, 0xF7, 0x00, 0x00,
  0x01, 0x9F, 0xFF, 0x20, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x50, 0x00,
  0x00, 0x3F, 0xFF, 0xD7, 0x71,
  0x00, 0x0C, 0xFF, 0xFF, 0xF6,
  0x00, 0x02, 0xAE, 0xFF, 0xE3
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_007C[ 42] = { // Code 007C, VERTICAL LINE
  0x2C, 0xC2,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x7F, 0xF7,
  0x06, 0x60
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_007D[125] = { // Code 007D, RIGHT CURLY BRACKET
  0x37, 0x76, 0x40, 0x00, 0x00,
  0xEF, 0xFF, 0xFD, 0x10, 0x00,
  0xAF, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x2E, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xD0, 0x00,
  0x00, 0x06, 0xFF, 0xFA, 0x70,
  0x00, 0x00, 0x6C, 0xFF, 0xF6,
  0x00, 0x02, 0xDF, 0xFF, 0xF3,
  0x00, 0x0A, 0xFF, 0xF3, 0x00,
  0x00, 0x0B, 0xFF, 0xC0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0D, 0xFF, 0xB0, 0x00,
  0x37, 0x9F, 0xFF, 0xA0, 0x00,
  0xEF, 0xFF, 0xFF, 0x50, 0x00,
  0xAF, 0xFF, 0xC6, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_007E[ 48] = { // Code 007E, TILDE
  0x00, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0xEF, 0xFE, 0x92, 0x00, 0x02, 0xDC, 0x00,
  0x4F, 0xFF, 0xFF, 0xFF, 0xB6, 0x7E, 0xFF, 0x10,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x00,
  0xDF, 0xE4, 0x26, 0xCF, 0xFF, 0xFF, 0xF4, 0x00,
  0x59, 0x10, 0x00, 0x03, 0x9D, 0xDA, 0x30, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontRounded33_CharInfo[95] = {
   {   1,   1,   0,  27,   8, acGUI_FontRounded33_0020 } // Code 0020, SPACE
  ,{   5,  21,   2,   7,   9, acGUI_FontRounded33_0021 } // Code 0021, EXCLAMATION MARK
  ,{  10,   9,   2,   7,  14, acGUI_FontRounded33_0022 } // Code 0022, QUOTATION MARK
  ,{  15,  21,   1,   7,  17, acGUI_FontRounded33_0023 } // Code 0023, NUMBER SIGN
  ,{  16,  24,   0,   6,  17, acGUI_FontRounded33_0024 } // Code 0024, DOLLAR SIGN
  ,{  23,  21,   2,   7,  27, acGUI_FontRounded33_0025 } // Code 0025, PERCENT SIGN
  ,{  18,  21,   1,   7,  19, acGUI_FontRounded33_0026 } // Code 0026, AMPERSAND
  ,{   4,   9,   2,   7,   9, acGUI_FontRounded33_0027 } // Code 0027, APOSTROPHE
  ,{   7,  26,   1,   7,   9, acGUI_FontRounded33_0028 } // Code 0028, LEFT PARENTHESIS
  ,{   7,  26,   1,   7,   9, acGUI_FontRounded33_0029 } // Code 0029, RIGHT PARENTHESIS
  ,{  11,  10,   1,   7,  13, acGUI_FontRounded33_002A } // Code 002A, ASTERISK
  ,{  16,  16,   0,  11,  16, acGUI_FontRounded33_002B } // Code 002B, PLUS SIGN
  ,{   6,   9,   1,  22,   8, acGUI_FontRounded33_002C } // Code 002C, COMMA
  ,{   9,   5,   1,  17,  11, acGUI_FontRounded33_002D } // Code 002D, HYPHEN-MINUS
  ,{   6,   6,   1,  22,   8, acGUI_FontRounded33_002E } // Code 002E, FULL STOP
  ,{  10,  21,   0,   7,  10, acGUI_FontRounded33_002F } // Code 002F, SOLIDUS
  ,{  15,  21,   1,   7,  17, acGUI_FontRounded33_0030 } // Code 0030, DIGIT ZERO
  ,{  10,  21,  -1,   7,  11, acGUI_FontRounded33_0031 } // Code 0031, DIGIT ONE
  ,{  16,  20,   0,   7,  16, acGUI_FontRounded33_0032 } // Code 0032, DIGIT TWO
  ,{  15,  21,   0,   7,  16, acGUI_FontRounded33_0033 } // Code 0033, DIGIT THREE
  ,{  16,  21,   0,   7,  16, acGUI_FontRounded33_0034 } // Code 0034, DIGIT FOUR
  ,{  15,  20,   0,   8,  16, acGUI_FontRounded33_0035 } // Code 0035, DIGIT FIVE
  ,{  15,  21,   1,   7,  17, acGUI_FontRounded33_0036 } // Code 0036, DIGIT SIX
  ,{  15,  20,   0,   8,  15, acGUI_FontRounded33_0037 } // Code 0037, DIGIT SEVEN
  ,{  15,  21,   1,   7,  17, acGUI_FontRounded33_0038 } // Code 0038, DIGIT EIGHT
  ,{  15,  21,   1,   7,  17, acGUI_FontRounded33_0039 } // Code 0039, DIGIT NINE
  ,{   6,  16,   1,  12,   8, acGUI_FontRounded33_003A } // Code 003A, COLON
  ,{   6,  19,   1,  12,   8, acGUI_FontRounded33_003B } // Code 003B, SEMICOLON
  ,{  16,  15,   0,  12,  16, acGUI_FontRounded33_003C } // Code 003C, LESS-THAN SIGN
  ,{  16,  11,   0,  14,  16, acGUI_FontRounded33_003D } // Code 003D, EQUALS SIGN
  ,{  16,  15,   0,  12,  16, acGUI_FontRounded33_003E } // Code 003E, GREATER-THAN SIGN
  ,{  14,  21,   1,   7,  15, acGUI_FontRounded33_003F } // Code 003F, QUESTION MARK
  ,{  21,  21,   0,   7,  22, acGUI_FontRounded33_0040 } // Code 0040, COMMERCIAL AT
  ,{  18,  21,   0,   7,  18, acGUI_FontRounded33_0041 } // Code 0041, LATIN CAPITAL LETTER A
  ,{  17,  20,   2,   7,  19, acGUI_FontRounded33_0042 } // Code 0042, LATIN CAPITAL LETTER B
  ,{  18,  21,   1,   7,  19, acGUI_FontRounded33_0043 } // Code 0043, LATIN CAPITAL LETTER C
  ,{  18,  20,   2,   7,  20, acGUI_FontRounded33_0044 } // Code 0044, LATIN CAPITAL LETTER D
  ,{  16,  20,   2,   7,  18, acGUI_FontRounded33_0045 } // Code 0045, LATIN CAPITAL LETTER E
  ,{  15,  21,   2,   7,  17, acGUI_FontRounded33_0046 } // Code 0046, LATIN CAPITAL LETTER F
  ,{  20,  21,   1,   7,  22, acGUI_FontRounded33_0047 } // Code 0047, LATIN CAPITAL LETTER G
  ,{  17,  21,   2,   7,  21, acGUI_FontRounded33_0048 } // Code 0048, LATIN CAPITAL LETTER H
  ,{   5,  21,   2,   7,   9, acGUI_FontRounded33_0049 } // Code 0049, LATIN CAPITAL LETTER I
  ,{  14,  21,   0,   7,  15, acGUI_FontRounded33_004A } // Code 004A, LATIN CAPITAL LETTER J
  ,{  17,  21,   2,   7,  18, acGUI_FontRounded33_004B } // Code 004B, LATIN CAPITAL LETTER K
  ,{  15,  20,   2,   7,  16, acGUI_FontRounded33_004C } // Code 004C, LATIN CAPITAL LETTER L
  ,{  20,  21,   2,   7,  24, acGUI_FontRounded33_004D } // Code 004D, LATIN CAPITAL LETTER M
  ,{  17,  21,   2,   7,  21, acGUI_FontRounded33_004E } // Code 004E, LATIN CAPITAL LETTER N
  ,{  20,  21,   1,   7,  22, acGUI_FontRounded33_004F } // Code 004F, LATIN CAPITAL LETTER O
  ,{  17,  21,   2,   7,  19, acGUI_FontRounded33_0050 } // Code 0050, LATIN CAPITAL LETTER P
  ,{  20,  22,   1,   7,  22, acGUI_FontRounded33_0051 } // Code 0051, LATIN CAPITAL LETTER Q
  ,{  17,  21,   2,   7,  20, acGUI_FontRounded33_0052 } // Code 0052, LATIN CAPITAL LETTER R
  ,{  17,  21,   1,   7,  18, acGUI_FontRounded33_0053 } // Code 0053, LATIN CAPITAL LETTER S
  ,{  18,  21,   0,   7,  18, acGUI_FontRounded33_0054 } // Code 0054, LATIN CAPITAL LETTER T
  ,{  17,  21,   2,   7,  21, acGUI_FontRounded33_0055 } // Code 0055, LATIN CAPITAL LETTER U
  ,{  18,  21,   0,   7,  17, acGUI_FontRounded33_0056 } // Code 0056, LATIN CAPITAL LETTER V
  ,{  25,  21,   0,   7,  25, acGUI_FontRounded33_0057 } // Code 0057, LATIN CAPITAL LETTER W
  ,{  16,  21,   0,   7,  16, acGUI_FontRounded33_0058 } // Code 0058, LATIN CAPITAL LETTER X
  ,{  17,  21,   0,   7,  17, acGUI_FontRounded33_0059 } // Code 0059, LATIN CAPITAL LETTER Y
  ,{  18,  20,   0,   7,  18, acGUI_FontRounded33_005A } // Code 005A, LATIN CAPITAL LETTER Z
  ,{   8,  25,   2,   7,  10, acGUI_FontRounded33_005B } // Code 005B, LEFT SQUARE BRACKET
  ,{  10,  21,   0,   7,  10, acGUI_FontRounded33_005C } // Code 005C, REVERSE SOLIDUS
  ,{   8,  25,   0,   7,  10, acGUI_FontRounded33_005D } // Code 005D, RIGHT SQUARE BRACKET
  ,{  14,  11,   1,   8,  16, acGUI_FontRounded33_005E } // Code 005E, CIRCUMFLEX ACCENT
  ,{  16,   2,  -1,  29,  13, acGUI_FontRounded33_005F } // Code 005F, LOW LINE
  ,{   6,   6,   0,   6,   8, acGUI_FontRounded33_0060 } // Code 0060, GRAVE ACCENT
  ,{  15,  16,   1,  12,  16, acGUI_FontRounded33_0061 } // Code 0061, LATIN SMALL LETTER A
  ,{  15,  21,   1,   7,  16, acGUI_FontRounded33_0062 } // Code 0062, LATIN SMALL LETTER B
  ,{  14,  16,   0,  12,  14, acGUI_FontRounded33_0063 } // Code 0063, LATIN SMALL LETTER C
  ,{  14,  21,   1,   7,  16, acGUI_FontRounded33_0064 } // Code 0064, LATIN SMALL LETTER D
  ,{  15,  16,   1,  12,  17, acGUI_FontRounded33_0065 } // Code 0065, LATIN SMALL LETTER E
  ,{  10,  21,   0,   7,  10, acGUI_FontRounded33_0066 } // Code 0066, LATIN SMALL LETTER F
  ,{  14,  21,   1,  12,  16, acGUI_FontRounded33_0067 } // Code 0067, LATIN SMALL LETTER G
  ,{  14,  21,   1,   7,  16, acGUI_FontRounded33_0068 } // Code 0068, LATIN SMALL LETTER H
  ,{   5,  21,   1,   7,   8, acGUI_FontRounded33_0069 } // Code 0069, LATIN SMALL LETTER I
  ,{   7,  26,  -1,   7,   8, acGUI_FontRounded33_006A } // Code 006A, LATIN SMALL LETTER J
  ,{  14,  21,   1,   7,  14, acGUI_FontRounded33_006B } // Code 006B, LATIN SMALL LETTER K
  ,{   5,  21,   1,   7,   8, acGUI_FontRounded33_006C } // Code 006C, LATIN SMALL LETTER L
  ,{  23,  16,   1,  12,  25, acGUI_FontRounded33_006D } // Code 006D, LATIN SMALL LETTER M
  ,{  14,  16,   1,  12,  16, acGUI_FontRounded33_006E } // Code 006E, LATIN SMALL LETTER N
  ,{  15,  16,   1,  12,  17, acGUI_FontRounded33_006F } // Code 006F, LATIN SMALL LETTER O
  ,{  15,  21,   1,  12,  16, acGUI_FontRounded33_0070 } // Code 0070, LATIN SMALL LETTER P
  ,{  14,  21,   1,  12,  16, acGUI_FontRounded33_0071 } // Code 0071, LATIN SMALL LETTER Q
  ,{  10,  16,   1,  12,  11, acGUI_FontRounded33_0072 } // Code 0072, LATIN SMALL LETTER R
  ,{  14,  16,   0,  12,  14, acGUI_FontRounded33_0073 } // Code 0073, LATIN SMALL LETTER S
  ,{  10,  20,   0,   8,  10, acGUI_FontRounded33_0074 } // Code 0074, LATIN SMALL LETTER T
  ,{  14,  16,   1,  12,  16, acGUI_FontRounded33_0075 } // Code 0075, LATIN SMALL LETTER U
  ,{  14,  16,   0,  12,  13, acGUI_FontRounded33_0076 } // Code 0076, LATIN SMALL LETTER V
  ,{  21,  16,   0,  12,  21, acGUI_FontRounded33_0077 } // Code 0077, LATIN SMALL LETTER W
  ,{  13,  16,   0,  12,  13, acGUI_FontRounded33_0078 } // Code 0078, LATIN SMALL LETTER X
  ,{  14,  21,   0,  12,  13, acGUI_FontRounded33_0079 } // Code 0079, LATIN SMALL LETTER Y
  ,{  15,  15,   0,  12,  15, acGUI_FontRounded33_007A } // Code 007A, LATIN SMALL LETTER Z
  ,{  10,  25,   0,   7,  10, acGUI_FontRounded33_007B } // Code 007B, LEFT CURLY BRACKET
  ,{   4,  21,   1,   7,   6, acGUI_FontRounded33_007C } // Code 007C, VERTICAL LINE
  ,{  10,  25,   0,   7,  10, acGUI_FontRounded33_007D } // Code 007D, RIGHT CURLY BRACKET
  ,{  15,   6,   1,  16,  16, acGUI_FontRounded33_007E } // Code 007E, TILDE
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded33_Prop1 = {
   0x0020                                   // First character
  ,0x007E                                   // Last character 
  ,&GUI_FontRounded33_CharInfo[  0]         // Address of first character
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT GUI_FontRounded33 = {
   GUI_FONTTYPE_PROP_AA4_EXT // type of font   
  ,33 // height of font 
  ,33 // space of font y
  ,1  // magnification x
  ,1  // magnification y
  ,{&GUI_FontRounded33_Prop1}
  ,33 // Baseline
  ,16 // Height of lowercase characters
  ,21 // Height of capital characters
};

/*********************************************************************
*
*       _SeggerLogo50x25
*/
static GUI_CONST_STORAGE GUI_COLOR ColorsSeggerLogo50x25[] = {
#if (GUI_USE_ARGB == 1)
     0xFF00FF00,0xFFFFFFFF,0xFF918F90,0xFF231F20
    ,0xFF2020A0,0xFF5858B8,0xFF5A5758,0xFFF1F1F9
    ,0xFFC7C7E7,0xFF312D2E,0xFF767374,0xFF2E2EA6
    ,0xFFD5D5ED,0xFF4A4AB2,0xFF9F9D9D,0xFFBAB9B9
    ,0xFFC8C7C7,0xFFD6D5D5,0xFF3F3B3C,0xFF6666BE
    ,0xFF8282CA,0xFFB9B9E1,0xFFE4E3E3,0xFFF1F1F1
    ,0xFF3C3CAC,0xFF838182,0xFFADABAB,0xFFABABDB
    ,0xFF4C494A,0xFF9D9DD5,0xFFE3E3F3,0xFF686566
    ,0xFF7474C4,0xFF9090D0
#else
     0x00FF00,0xFFFFFF,0x908F91,0x201F23
    ,0xA02020,0xB85858,0x58575A,0xF9F1F1
    ,0xE7C7C7,0x2E2D31,0x747376,0xA62E2E
    ,0xEDD5D5,0xB24A4A,0x9D9D9F,0xB9B9BA
    ,0xC7C7C8,0xD5D5D6,0x3C3B3F,0xBE6666
    ,0xCA8282,0xE1B9B9,0xE3E3E4,0xF1F1F1
    ,0xAC3C3C,0x828183,0xABABAD,0xDBABAB
    ,0x4A494C,0xD59D9D,0xF3E3E3,0x666568
    ,0xC47474,0xD09090
#endif
};

static GUI_CONST_STORAGE GUI_LOGPALETTE PalSeggerLogo50x25 = {
  34,	// number of entries
  1, 	// Has transparency
  &ColorsSeggerLogo50x25[0]
};

static GUI_CONST_STORAGE unsigned char acSeggerLogo50x25[] = {
  0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00,
  0x03, 0x09, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x09, 0x03,
  0x03, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x07, 0x21, 0x07, 0x01, 0x01, 0x15, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x04, 0x0D, 0x01, 0x01, 0x0D, 0x04, 0x08, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x01, 0x13, 0x04, 0x14, 0x01, 0x08, 0x04, 0x0B, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x01, 0x07, 0x18, 0x04, 0x15, 0x01, 0x1D, 0x04, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x01, 0x01, 0x0C, 0x04, 0x0B, 0x1E, 0x01, 0x13, 0x04, 0x14, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x0C, 0x0C, 0x01, 0x1D, 0x04, 0x0D, 0x01, 0x07, 0x18, 0x04, 0x1B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x0D, 0x07, 0x01, 0x13, 0x04, 0x14, 0x01, 0x0C, 0x0B, 0x0B, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x04, 0x20, 0x01, 0x07, 0x18, 0x04, 0x15, 0x01, 0x1B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x05, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x04, 0x04, 0x1B, 0x01, 0x0C, 0x0B, 0x0B, 0x1E, 0x01, 0x14, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x13, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x04, 0x04, 0x18, 0x01, 0x01, 0x20, 0x04, 0x21, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x04, 0x04, 0x1B, 0x01, 0x0C, 0x0B, 0x0B, 0x1E, 0x01, 0x14, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x13, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x04, 0x20, 0x01, 0x07, 0x18, 0x04, 0x15, 0x01, 0x1B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x05, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x0D, 0x07, 0x01, 0x13, 0x04, 0x14, 0x01, 0x0C, 0x0B, 0x0B, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x0C, 0x0C, 0x01, 0x1D, 0x04, 0x0D, 0x01, 0x07, 0x18, 0x04, 0x1B, 0x01, 0x1A, 0x02, 0x02, 0x16, 0x01, 0x0E, 0x02, 0x02, 0x0E, 0x17, 0x17, 0x1A, 0x02, 0x0E, 0x16, 0x01, 0x01, 0x1A, 0x02, 0x02, 0x16, 0x01, 0x10, 0x02, 0x02, 0x02, 0x10, 0x11, 
        0x02, 0x02, 0x02, 0x11, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x01, 0x01, 0x0C, 0x04, 0x0B, 0x1E, 0x01, 0x13, 0x04, 0x14, 0x01, 0x0E, 0x03, 0x19, 0x12, 0x1C, 0x10, 0x03, 0x1C, 0x06, 0x06, 0x16, 0x1C, 0x09, 0x19, 0x12, 0x09, 0x01, 0x19, 0x03, 0x0A, 0x12, 0x03, 0x16, 0x06, 0x09, 0x06, 0x06, 0x0E, 0x02, 
        0x03, 0x06, 0x1C, 0x03, 0x11, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x01, 0x07, 0x18, 0x04, 0x15, 0x01, 0x1D, 0x04, 0x0D, 0x01, 0x01, 0x0E, 0x03, 0x0A, 0x0E, 0x0F, 0x10, 0x03, 0x0A, 0x02, 0x02, 0x11, 0x03, 0x1A, 0x17, 0x0F, 0x02, 0x01, 0x03, 0x19, 0x01, 0x0F, 0x02, 0x17, 0x06, 0x12, 0x02, 0x02, 0x10, 0x02, 
        0x03, 0x10, 0x02, 0x03, 0x11, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x01, 0x13, 0x04, 0x14, 0x01, 0x08, 0x04, 0x0B, 0x07, 0x01, 0x01, 0x17, 0x0E, 0x0A, 0x09, 0x09, 0x1A, 0x03, 0x0A, 0x02, 0x02, 0x10, 0x03, 0x0F, 0x0F, 0x06, 0x03, 0x10, 0x03, 0x02, 0x11, 0x06, 0x03, 0x02, 0x06, 0x12, 0x02, 0x02, 0x11, 0x02, 
        0x03, 0x06, 0x12, 0x09, 0x17, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x04, 0x0D, 0x01, 0x01, 0x0D, 0x04, 0x08, 0x01, 0x01, 0x01, 0x02, 0x09, 0x1A, 0x0A, 0x03, 0x0E, 0x03, 0x0A, 0x02, 0x02, 0x11, 0x12, 0x12, 0x02, 0x1F, 0x03, 0x10, 0x06, 0x09, 0x02, 0x0A, 0x03, 0x02, 0x06, 0x12, 0x02, 0x02, 0x1A, 0x02, 
        0x03, 0x01, 0x0F, 0x03, 0x10, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x07, 0x21, 0x07, 0x01, 0x01, 0x15, 0x15, 0x01, 0x01, 0x01, 0x01, 0x17, 0x19, 0x06, 0x06, 0x0F, 0x01, 0x02, 0x02, 0x02, 0x02, 0x11, 0x16, 0x0A, 0x06, 0x0A, 0x0A, 0x11, 0x17, 0x19, 0x06, 0x1F, 0x0A, 0x0F, 0x0F, 0x02, 0x02, 0x02, 0x0E, 0x0F, 
        0x19, 0x01, 0x16, 0x1F, 0x16, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x09, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x09, 0x03,
  0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00
};

extern GUI_CONST_STORAGE GUI_BITMAP bmSeggerLogo50x25;

GUI_CONST_STORAGE GUI_BITMAP bmSeggerLogo50x25 = {
  50,                   // XSize
  25,                   // YSize
  50,                   // BytesPerLine
  8,                    // BitsPerPixel
  acSeggerLogo50x25,    // Pointer to picture data (indices)
  &PalSeggerLogo50x25   // Pointer to palette
};

/*********************************************************************
*
*       Needle with 32bpp and transparency
*/
static GUI_CONST_STORAGE unsigned long _acNeedle[] = {
#if (GUI_USE_ARGB == 1)
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xC8FF7F27, 0xDDFF7F27, 0xDCFF7F27, 0xDCFF7F27, 0xE6FF7F27, 0xE6FF7F27, 0xE6FF7F27, 0xE6FF7F27, 0xDCFF7F27, 0xDCFF7F27, 0xDCFF7F27, 
        0xDCFF7F27, 0xDCFF7F27, 0xDCFF7F27, 0xDEFF7F27, 0xD2FF7F27, 0xB8FF7F27, 0xB6FF7F27, 0xB7FF7F27, 0xB7FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xB7FF7F27, 0xB7FF7F27, 0xB7FF7F27, 
        0xB7FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA4FF7F27, 0xA5FF7F27, 0x7DFF7F27, 0x6CFF7F27, 0x6CFF7F27, 0x6CFF7F27, 
        0x6CFF7F27, 0x6CFF7F27, 0x6CFF7F27, 0x6CFF7F27, 0x6CFF7F27, 0x6CFF7F27, 0x6CFF7F27, 0x6CFF7F27, 0x6CFF7F27, 0x6CFF7F27, 0x6DFF7F27, 0x64FF7F27, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xF1FF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 
        0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 
        0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 
        0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0xFFFF7F27, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xCEFF7F27, 0xE3FF7F27, 0xE3FF7F27, 0xE3FF7F27, 0xE3FF7F27, 0xE3FF7F27, 0xE3FF7F27, 0xE3FF7F27, 0xE3FF7F27, 0xE3FF7F27, 0xE3FF7F27, 
        0xE3FF7F27, 0xE3FF7F27, 0xE3FF7F27, 0xE3FF7F27, 0xDCFF7F27, 0xBEFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 
        0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xBDFF7F27, 0xA4FF7F27, 0x98FF7F27, 0x99FF7F27, 0x99FF7F27, 
        0x99FF7F27, 0x99FF7F27, 0x99FF7F27, 0x99FF7F27, 0x99FF7F27, 0x99FF7F27, 0x99FF7F27, 0x99FF7F27, 0x99FF7F27, 0x99FF7F27, 0x99FF7F27, 0x8CFF7F27, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF
#else
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x37277FFF, 0x22277FFF, 0x23277FFF, 0x23277FFF, 0x19277FFF, 0x19277FFF, 0x19277FFF, 0x19277FFF, 0x23277FFF, 0x23277FFF, 0x23277FFF, 
        0x23277FFF, 0x23277FFF, 0x23277FFF, 0x21277FFF, 0x2D277FFF, 0x47277FFF, 0x49277FFF, 0x48277FFF, 0x48277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x48277FFF, 0x48277FFF, 0x48277FFF, 
        0x48277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5A277FFF, 0x82277FFF, 0x93277FFF, 0x93277FFF, 0x93277FFF, 
        0x93277FFF, 0x93277FFF, 0x93277FFF, 0x93277FFF, 0x93277FFF, 0x93277FFF, 0x93277FFF, 0x93277FFF, 0x93277FFF, 0x93277FFF, 0x92277FFF, 0x9B277FFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x0E277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 
        0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 
        0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 
        0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x31277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 
        0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x23277FFF, 0x41277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 
        0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x5B277FFF, 0x67277FFF, 0x66277FFF, 0x66277FFF, 
        0x66277FFF, 0x66277FFF, 0x66277FFF, 0x66277FFF, 0x66277FFF, 0x66277FFF, 0x66277FFF, 0x66277FFF, 0x66277FFF, 0x66277FFF, 0x66277FFF, 0x73277FFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
#endif
};

static GUI_CONST_STORAGE GUI_BITMAP _bmNeedle = {
  75, // xSize
  9, // ySize
  300, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acNeedle,  // Pointer to picture data
  NULL,  // Pointer to palette
#if (GUI_USE_ARGB == 1)
  GUI_DRAW_BMPM8888I
#else
  GUI_DRAW_BMP8888
#endif
};

/*********************************************************************
*
*       Speedometer with 32bpp and transparency
*/
static GUI_CONST_STORAGE unsigned long _acSpeedometerScale_BMP[] = {
#if (GUI_USE_ARGB == 1)
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x21CCCCCC, 0x54CCCCCC, 0x65CCCCCC, 0x87CCCCCC, 0xA9CCCCCC, 0xCBCCCCCC, 0xDCCCCCCC, 0xFFCCCCCC, 
        0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFECCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xDCCCCCCC, 
        0xDCCCCCCC, 0xA9CCCCCC, 0x98CCCCCC, 0x76CCCCCC, 0x54CCCCCC, 0x32CCCCCC, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10CCCCCC, 0x43CCCCCC, 0x76CCCCCC, 0xA9CCCCCC, 0xCBCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 
        0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFECCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 
        0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xDCCCCCCC, 0xA9CCCCCC, 0x76CCCCCC, 0x43CCCCCC, 0x10CCCCCC, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x21CBCBCB, 0x65CBCBCB, 0x98CBCBCB, 0xDCCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 
        0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFECBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 
        0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xDCCBCBCB, 0xA9CBCBCB, 0x65CBCBCB, 0x32CBCBCB, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10CACACA, 0x54CACACA, 
        0x98CACACA, 0xDCCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 
        0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFC8C8C8, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 
        0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xEDCACACA, 0xA9CACACA, 0x65CACACA, 0x10CACACA, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x21CACACA, 0x76CACACA, 0xBACACACA, 0xFFCACACA, 0xFFCACACA, 
        0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 
        0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFC8C8C8, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 
        0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 
        0xCBCACACA, 0x87CACACA, 0x32CACACA, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x21C9C9C9, 0x76C9C9C9, 0xCBC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 
        0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 
        0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC7C7C7, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 
        0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 
        0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xDCC9C9C9, 0x87C9C9C9, 0x32C9C9C9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10C8C8C8, 0x65C8C8C8, 0xCBC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 
        0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 
        0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 
        0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 
        0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xDCC8C8C8, 0x76C8C8C8, 0x10C8C8C8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33C7C7C7, 0xAAC7C7C7, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 
        0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFBDBDBD, 0xFFB2B2B2, 0xFFABABAB, 0xFF9C9C9C, 0xFF909090, 0xFF848484, 0xFF636363, 0xFF333333, 
        0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF636363, 
        0xFF767676, 0xFF909090, 0xFF9C9C9C, 0xFFA8A8A8, 0xFFB2B2B2, 0xFFBDBDBD, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 
        0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xAAC7C7C7, 0x55C7C7C7, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x66C6C6C6, 0xCCC6C6C6, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 
        0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFB6B6B6, 0xFFAAAAAA, 0xFF9E9E9E, 0xFF8F8F8F, 0xFF646464, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 
        0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 
        0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF4E4E4E, 0xFF848484, 0xFF9E9E9E, 0xFFAAAAAA, 0xFFB6B6B6, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 
        0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xDDC6C6C6, 0x77C6C6C6, 0x11C6C6C6, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x11C5C5C5, 0x88C5C5C5, 0xEEC5C5C5, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 
        0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFAFAFAF, 0xFFA6A6A6, 0xFF8F8F8F, 0xFF646464, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 
        0xFF343434, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF434343, 0xFF454545, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF434343, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF3F3F3F, 0xFF393939, 0xFF393939, 0xFF343434, 0xFF343434, 0xFF343434, 
        0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF4F4F4F, 0xFF848484, 0xFFA2A2A2, 0xFFB0B0B0, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 
        0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xEEC5C5C5, 0x99C5C5C5, 0x22C5C5C5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x22C5C5C5, 0x99C5C5C5, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFBCBCBC, 
        0xFFAAAAAA, 0xFF989898, 0xFF4F4F4F, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF3F3F3F, 0xFF4A4A4A, 0xFF4F4F4F, 0xFF525252, 0xFF565656, 0xFF585858, 0xFF5F5F5F, 
        0xFF5F5F5F, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5C5C5C, 0xFF5A5A5A, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF575757, 0xFF575757, 0xFF565656, 0xFF545454, 0xFF535353, 0xFF535353, 0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF484848, 
        0xFF474747, 0xFF454545, 0xFF414141, 0xFF3F3F3F, 0xFF3A3A3A, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF4F4F4F, 0xFF8F8F8F, 0xFFA7A7A7, 0xFFBCBCBC, 0xFFC6C6C6, 
        0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xAAC5C5C5, 0x33C5C5C5, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22C4C4C4, 0x99C4C4C4, 
        0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFBBBBBB, 0xFFA6A6A6, 0xFF848484, 0xFF353535, 
        0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF3A3A3A, 0xFF4A4A4A, 0xFF525252, 0xFF595959, 0xFF5D5D5D, 0xFF646464, 0xFF646464, 0xFF636363, 0xFF636363, 0xFF616161, 0xFF606060, 0xFF5F5F5F, 0xFF5F5F5F, 
        0xFF5F5F5F, 0xFF6B5050, 0xFF714949, 0xFF784242, 0xFF7F3B3B, 0xFF7E3A3A, 0xFF7E3A3A, 0xFF7D3939, 0xFF7D3939, 0xFF803434, 0xFF7C3838, 0xFF7C3838, 0xFF7A3737, 0xFF7A3737, 0xFF713B3B, 0xFF683F3F, 0xFF683F3F, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 
        0xFF4D4D4D, 0xFF4D4D4D, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF494949, 0xFF484848, 0xFF454545, 0xFF414141, 0xFF3D3D3D, 0xFF3A3A3A, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF767676, 
        0xFFA2A2A2, 0xFFB4B4B4, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xAAC4C4C4, 0x33C4C4C4, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x11C3C3C3, 0x88C3C3C3, 0xFFC4C4C4, 0xFFC4C4C4, 
        0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFBABABA, 0xFFA5A5A5, 0xFF848484, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 
        0xFF363636, 0xFF363636, 0xFF363636, 0xFF3C3C3C, 0xFF4E4E4E, 0xFF5A5A5A, 0xFF606060, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF696969, 0xFF676767, 0xFF666666, 0xFF646464, 0xFF715656, 0xFF854141, 0xFF923333, 0xFFA02626, 0xFFA71F1F, 0xFFBC0C0C, 0xFFC30606, 
        0xFFCC0000, 0xFFBC0C0C, 0xFFBC0C0C, 0xFFAD1818, 0xFFA51D1D, 0xFFA41D1D, 0xFFA41D1D, 0xFFA41C1C, 0xFFA41C1C, 0xFFA81818, 0xFFA31C1C, 0xFFA31C1C, 0xFFA31B1B, 0xFFA31B1B, 0xFFAA1515, 0xFFBA0A0A, 0xFFBA0A0A, 0xFFCC0000, 0xFFCC0000, 0xFFBA0A0A, 
        0xFFA91414, 0xFF981E1E, 0xFF872828, 0xFF753131, 0xFF633A3A, 0xFF484848, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF3F3F3F, 0xFF3D3D3D, 0xFF3A3A3A, 0xFF373737, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 
        0xFF363636, 0xFF363636, 0xFF767676, 0xFFA1A1A1, 0xFFB3B3B3, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 
        0xAAC3C3C3, 0x22C3C3C3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x77C2C2C2, 0xEEC2C2C2, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 
        0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFA8A8A8, 0xFF8E8E8E, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 
        0xFF484848, 0xFF585858, 0xFF636363, 0xFF6D6D6D, 0xFF6C6C6C, 0xFF6B6B6B, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF7C5353, 0xFF8E3D3D, 0xFFA22929, 0xFFB61414, 0xFFCC0000, 0xFFBD0D0D, 0xFFA82020, 0xFF992D2D, 0xFF8B3939, 0xFF833F3F, 0xFF754C4C, 0xFF655858, 
        0xFF5D5D5D, 0xFF5D5D5D, 0xFF5C5C5C, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF585858, 0xFF585858, 0xFF575757, 0xFF575757, 0xFF565656, 0xFF555555, 0xFF555555, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF515151, 0xFF505050, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF663D3D, 
        0xFF6E3838, 0xFF7F2E2E, 0xFF8F2323, 0xFFA01818, 0xFFB90909, 0xFFCC0000, 0xFFB90909, 0xFF9E1717, 0xFF822424, 0xFF673131, 0xFF444444, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF404040, 0xFF3D3D3D, 0xFF3A3A3A, 0xFF383838, 0xFF373737, 0xFF373737, 
        0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF838383, 0xFFA8A8A8, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 
        0xFFC3C3C3, 0xFFC3C3C3, 0x88C2C2C2, 0x11C2C2C2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x55C2C2C2, 0xDDC2C2C2, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 
        0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFB9B9B9, 0xFFA1A1A1, 0xFF666666, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF4F4F4F, 0xFF5F5F5F, 0xFF6B6B6B, 
        0xFF6F6F6F, 0xFF6F6F6F, 0xFF6E6E6E, 0xFF6D6D6D, 0xFF854E4E, 0xFF9E3131, 0xFFB11C1C, 0xFFCC0000, 0xFFB71414, 0xFFA22929, 0xFF8E3D3D, 0xFF7A5252, 0xFF646464, 0xFF636363, 0xFF626262, 0xFF616161, 0xFF616161, 0xFF606060, 0xFF606060, 0xFF5F5F5F, 
        0xFF5D5D5D, 0xFF5D5D5D, 0xFF5C5C5C, 0xFF5B5B5B, 0xFF5A5A5A, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF565656, 0xFF565656, 0xFF545454, 0xFF545454, 0xFF535353, 0xFF535353, 0xFF525252, 0xFF505050, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 
        0xFF4D4D4D, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF494949, 0xFF494949, 0xFF484848, 0xFF603737, 0xFF7B2929, 0xFF951B1B, 0xFFB00D0D, 0xFFCC0000, 0xFFAF0D0D, 0xFF8B1E1E, 0xFF652F2F, 0xFF493B3B, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF393939, 0xFF383838, 
        0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF515151, 0xFF9C9C9C, 0xFFB3B3B3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 
        0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xEEC2C2C2, 0x66C2C2C2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22C1C1C1, 0xBBC1C1C1, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 
        0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFACACAC, 0xFF8E8E8E, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF4A4A4A, 0xFF606060, 0xFF6C6C6C, 0xFF727272, 0xFF707070, 0xFF707070, 
        0xFF7A5F5F, 0xFF934242, 0xFFB11C1C, 0xFFCC0000, 0xFFB71515, 0xFF9D3131, 0xFF834D4D, 0xFF6F6161, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF656565, 0xFF646464, 0xFF626262, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF606060, 0xFF5F5F5F, 0xFF5F5F5F, 
        0xFF5D5D5D, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF585858, 0xFF575757, 0xFF575757, 0xFF565656, 0xFF555555, 0xFF555555, 0xFF545454, 0xFF535353, 0xFF525252, 0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4D4D4D, 0xFF4D4D4D, 
        0xFF4C4C4C, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF494949, 0xFF484848, 0xFF464646, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF673030, 0xFF812222, 0xFFA61111, 0xFFCC0000, 0xFFA51010, 0xFF7F2020, 0xFF593030, 0xFF3C3C3C, 0xFF3B3B3B, 
        0xFF3A3A3A, 0xFF373737, 0xFF383838, 0xFF363636, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF8E8E8E, 0xFFAAAAAA, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 
        0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xCCC1C1C1, 0x33C1C1C1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x88C0C0C0, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 
        0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFA9A9A9, 0xFF838383, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF3F3F3F, 0xFF5A5A5A, 0xFF676767, 0xFF727272, 0xFF707070, 0xFF707070, 0xFF7B6060, 0xFF9A3B3B, 0xFFB81616, 
        0xFFC40707, 0xFFA52B2B, 0xFF8B4747, 0xFF706262, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF696969, 0xFF676767, 0xFF676767, 0xFF666666, 0xFF646464, 0xFF646464, 0xFF636363, 0xFF616161, 0xFF616161, 0xFF606060, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 
        0xFF5D5D5D, 0xFF5C5C5C, 0xFF5B5B5B, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF595959, 0xFF575757, 0xFF575757, 0xFF565656, 0xFF555555, 0xFF555555, 0xFF545454, 0xFF545454, 0xFF535353, 0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4C4C4C, 
        0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF632D2D, 0xFF921818, 0xFFB80808, 0xFFB80707, 0xFF871B1B, 
        0xFF562E2E, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF353535, 0xFF353535, 0xFF373737, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF767676, 0xFFA6A6A6, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 
        0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0x99C0C0C0, 0x11C0C0C0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33C0C0C0, 0xDDC0C0C0, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 
        0xFFC1C1C1, 0xFFC1C1C1, 0xFFA9A9A9, 0xFF848484, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF4A4A4A, 0xFF606060, 0xFF727272, 0xFF707070, 0xFF707070, 0xFF756868, 0xFF9A3B3B, 0xFFB81616, 0xFFC50707, 0xFFA62C2C, 0xFF865050, 
        0xFF6D6D6D, 0xFF6C6C6C, 0xFF6B6B6B, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF696969, 0xFF686868, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF646464, 0xFF636363, 0xFF636363, 0xFF616161, 0xFF606060, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5E5E5E, 
        0xFF757575, 0xFFDADADA, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF636363, 0xFFB7B7B7, 0xFFD9D9D9, 0xFFA8A8A8, 0xFF5F5F5F, 0xFF555555, 0xFF555555, 0xFF585858, 0xFF9B9B9B, 0xFFD8D8D8, 0xFFC4C4C4, 0xFF909090, 0xFF545454, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 
        0xFF4B4B4B, 0xFF4B4B4B, 0xFF494949, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF414141, 0xFF404040, 0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF593030, 0xFF871B1B, 
        0xFFB70707, 0xFFB70707, 0xFF861A1A, 0xFF4C3131, 0xFF373737, 0xFF363636, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF666666, 0xFFA6A6A6, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 
        0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xEEC0C0C0, 0x55C0C0C0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x88BFBFBF, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 
        0xFFACACAC, 0xFF838383, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF525252, 0xFF656565, 0xFF6F6F6F, 0xFF6F6F6F, 0xFF707070, 0xFF8E4A4A, 0xFFAC2525, 0xFFC50707, 0xFFA62C2C, 0xFF865050, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 
        0xFF6D6D6D, 0xFF6D6D6D, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF686868, 0xFF686868, 0xFF676767, 0xFF666666, 0xFF646464, 0xFF646464, 0xFF636363, 0xFF626262, 0xFF616161, 0xFF606060, 0xFF606060, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF7A7A7A, 
        0xFFDADADA, 0xFFDADADA, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF9E9E9E, 0xFFD9D9D9, 0xFFD9D9D9, 0xFFD8D8D8, 0xFF9C9C9C, 0xFF555555, 0xFF545454, 0xFF9B9B9B, 0xFFD8D8D8, 0xFFD8D8D8, 0xFFD8D8D8, 0xFFD7D7D7, 0xFF8F8F8F, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 
        0xFF4B4B4B, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF464646, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF414141, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 
        0xFF393939, 0xFF562D2D, 0xFF861A1A, 0xFFC10303, 0xFFAD0A0A, 0xFF662323, 0xFF343434, 0xFF343434, 0xFF313131, 0xFF313131, 0xFF343434, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF656565, 0xFFA6A6A6, 0xFFC0C0C0, 0xFFC0C0C0, 
        0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xAABFBFBF, 0x11BFBFBF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33BEBEBE, 0xDDBEBEBE, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFB0B0B0, 0xFF8D8D8D, 
        0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF545454, 0xFF666666, 0xFF6D6D6D, 0xFF6E6E6E, 0xFF746767, 0xFF993A3A, 0xFFBE0E0E, 0xFFB81616, 0xFF8C4949, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 
        0xFF6C6C6C, 0xFF6B6B6B, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF696969, 0xFF686868, 0xFF676767, 0xFF666666, 0xFF646464, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF616161, 0xFF606060, 0xFF606060, 0xFF5F5F5F, 0xFFB9B9B9, 0xFFDBDBDB, 
        0xFFDADADA, 0xFFDADADA, 0xFF5B5B5B, 0xFF5A5A5A, 0xFFD9D9D9, 0xFFD9D9D9, 0xFF5B5B5B, 0xFFA8A8A8, 0xFFD8D8D8, 0xFF555555, 0xFF535353, 0xFFC5C5C5, 0xFFD8D8D8, 0xFF5D5D5D, 0xFF555555, 0xFFD7D7D7, 0xFFC3C3C3, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 
        0xFF4B4B4B, 0xFF4A4A4A, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF464646, 0xFF464646, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 
        0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF363636, 0xFF672323, 0xFF991111, 0xFFC10303, 0xFF841818, 0xFF462B2B, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF333333, 0xFF383838, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF838383, 0xFFABABAB, 
        0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xEEBEBEBE, 0x44BEBEBE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x77BEBEBE, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFB6B6B6, 0xFF9B9B9B, 0xFF3C3C3C, 0xFF3C3C3C, 
        0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF545454, 0xFF636363, 0xFF6B6B6B, 0xFF6C6C6C, 0xFF795E5E, 0xFFA52B2B, 0xFFC40707, 0xFFA52B2B, 0xFF7F5656, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6C6C6C, 0xFF6B6B6B, 0xFF6B6B6B, 
        0xFF6B6B6B, 0xFF6B6B6B, 0xFF6A6A6A, 0xFF6D6D6D, 0xFF696969, 0xFF686868, 0xFF676767, 0xFF646464, 0xFF646464, 0xFF646464, 0xFF636363, 0xFF626262, 0xFF626262, 0xFF616161, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF5F5F5F, 0xFF5D5D5D, 0xFF656565, 
        0xFFDADADA, 0xFFDADADA, 0xFF5B5B5B, 0xFF595959, 0xFFD9D9D9, 0xFFD9D9D9, 0xFF575757, 0xFFB5B5B5, 0xFFC5C5C5, 0xFF545454, 0xFF535353, 0xFFD8D8D8, 0xFFD8D8D8, 0xFF515151, 0xFF505050, 0xFFD7D7D7, 0xFFD7D7D7, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 
        0xFF4B4B4B, 0xFF494949, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF424242, 0xFF525252, 0xFF5B5B5B, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3B3B3B, 0xFF3B3B3B, 
        0xFF3A3A3A, 0xFF383838, 0xFF373737, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF472C2C, 0xFF841717, 0xFFC00303, 0xFF971010, 0xFF4F2727, 0xFF313131, 0xFF303030, 0xFF2C2C2C, 0xFF303030, 0xFF383838, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 
        0xFF8D8D8D, 0xFFB0B0B0, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0x99BEBEBE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x11BDBDBD, 0xAABDBDBD, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFA4A4A4, 0xFF676767, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 
        0xFF3D3D3D, 0xFF515151, 0xFF636363, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF7D5555, 0xFFAA2323, 0xFFC40707, 0xFF9D3131, 0xFF716363, 0xFF6B6B6B, 0xFF6C6C6C, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF6B6B6B, 
        0xFF6F6F6F, 0xFF878787, 0xFFA3A3A3, 0xFF9C9C9C, 0xFF7D7D7D, 0xFF666666, 0xFF676767, 0xFF656565, 0xFF646464, 0xFF646464, 0xFF626262, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF606060, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5D5D5D, 0xFF5D5D5D, 
        0xFFDADADA, 0xFFDADADA, 0xFF5A5A5A, 0xFF585858, 0xFF585858, 0xFF575757, 0xFF707070, 0xFFD8D8D8, 0xFF929292, 0xFF545454, 0xFF535353, 0xFFD8D8D8, 0xFFD8D8D8, 0xFF505050, 0xFF505050, 0xFFD7D7D7, 0xFFD7D7D7, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4B4B4B, 
        0xFF4B4B4B, 0xFF4A4A4A, 0xFF494949, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF545454, 0xFF636363, 0xFF737373, 0xFF9E9E9E, 0xFFB4B4B4, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3B3B3B, 0xFF3B3B3B, 
        0xFF393939, 0xFF383838, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF333333, 0xFF313131, 0xFF3B2D2D, 0xFF6E1D1D, 0xFFB60606, 0xFFA10C0C, 0xFF572121, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2A2A2A, 0xFF313131, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 
        0xFF3D3D3D, 0xFF545454, 0xFF9E9E9E, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xCCBDBDBD, 0x22BDBDBD, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x33BCBCBC, 0xDDBCBCBC, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFAEAEAE, 0xFF838383, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF4D4D4D, 
        0xFF606060, 0xFF686868, 0xFF696969, 0xFF7C5353, 0xFFAA2222, 0xFFBE0E0E, 0xFF973838, 0xFF706262, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF6C6C6C, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6C6C6C, 
        0xFFA3A3A3, 0xFFD7D7D7, 0xFFD8D8D8, 0xFFD8D8D8, 0xFFB9B9B9, 0xFF7C7C7C, 0xFF666666, 0xFF646464, 0xFF646464, 0xFF646464, 0xFF636363, 0xFF616161, 0xFF616161, 0xFF606060, 0xFF606060, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5E5E5E, 0xFF5D5D5D, 0xFF5B5B5B, 
        0xFFDADADA, 0xFFDADADA, 0xFF595959, 0xFF585858, 0xFF585858, 0xFF575757, 0xFFA8A8A8, 0xFFD8D8D8, 0xFF686868, 0xFF545454, 0xFF545454, 0xFFD8D8D8, 0xFFD8D8D8, 0xFF505050, 0xFF4F4F4F, 0xFFD7D7D7, 0xFFD6D6D6, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4B4B4B, 
        0xFF4B4B4B, 0xFF4A4A4A, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF595959, 0xFF949494, 0xFFCBCBCB, 0xFFD4D4D4, 0xFF777777, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF464646, 0xFF5E5E5E, 0xFF6E6E6E, 0xFF494949, 
        0xFF3A3A3A, 0xFF393939, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF621E1E, 0xFFB60606, 0xFFA00B0B, 0xFF562020, 0xFF2B2B2B, 0xFF292929, 0xFF2A2A2A, 0xFF323232, 0xFF3E3E3E, 
        0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF676767, 0xFFAAAAAA, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xEEBCBCBC, 0x55BCBCBC, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x77BCBCBC, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFF9E9E9E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF454545, 0xFF595959, 0xFF666666, 
        0xFF676767, 0xFF745858, 0xFFA22929, 0xFFC40606, 0xFF953636, 0xFF696969, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF6A6A6A, 0xFF767676, 0xFF6F6F6F, 0xFF696969, 0xFF696969, 0xFF7D7D7D, 
        0xFFC1C1C1, 0xFFBBBBBB, 0xFF828282, 0xFF868686, 0xFFD7D7D7, 0xFFA0A0A0, 0xFF646464, 0xFF646464, 0xFF646464, 0xFF646464, 0xFF626262, 0xFF616161, 0xFF616161, 0xFF606060, 0xFF606060, 0xFF5F5F5F, 0xFF5E5E5E, 0xFF5D5D5D, 0xFF5C5C5C, 0xFF5B5B5B, 
        0xFFDADADA, 0xFFDADADA, 0xFF595959, 0xFF585858, 0xFF575757, 0xFF707070, 0xFFD8D8D8, 0xFF929292, 0xFF545454, 0xFF545454, 0xFF535353, 0xFFD8D8D8, 0xFFD8D8D8, 0xFF505050, 0xFF4F4F4F, 0xFFD7D7D7, 0xFFD6D6D6, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4B4B4B, 
        0xFF4B4B4B, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF4B4B4B, 0xFFC1C1C1, 0xFFD4D4D4, 0xFF525252, 0xFF3E3E3E, 0xFF414141, 0xFF6C6C6C, 0xFFA5A5A5, 0xFFD3D3D3, 0xFFD2D2D2, 
        0xFF6A6A6A, 0xFF393939, 0xFF373737, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF343434, 0xFF323232, 0xFF313131, 0xFF303030, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF611D1D, 0xFFB50505, 0xFF950D0D, 0xFF492020, 0xFF292929, 0xFF292929, 0xFF2A2A2A, 
        0xFF373737, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF9A9A9A, 0xFFB4B4B4, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0x88BCBCBC, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x99BBBBBB, 
        0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFAEAEAE, 0xFF777777, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF535353, 0xFF646464, 0xFF646464, 0xFF646464, 
        0xFF9B2E2E, 0xFFC40606, 0xFF9C2F2F, 0xFF6D5F5F, 0xFF676767, 0xFF686868, 0xFF696969, 0xFF696969, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF696969, 0xFF6F6F6F, 0xFF8B8B8B, 0xFFB8B8B8, 0xFFB8B8B8, 0xFF989898, 0xFF7E7E7E, 0xFF686868, 0xFF797979, 
        0xFFCCCCCC, 0xFFB7B7B7, 0xFF686868, 0xFF6B6B6B, 0xFFDCDCDC, 0xFFDCDCDC, 0xFF6A6A6A, 0xFF646464, 0xFF636363, 0xFF636363, 0xFF626262, 0xFF616161, 0xFF616161, 0xFF606060, 0xFF5F5F5F, 0xFF5E5E5E, 0xFF5D5D5D, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 
        0xFFDADADA, 0xFFD9D9D9, 0xFF585858, 0xFF585858, 0xFF575757, 0xFFB6B6B6, 0xFFD8D8D8, 0xFF5F5F5F, 0xFF545454, 0xFF535353, 0xFF515151, 0xFFD8D8D8, 0xFFD8D8D8, 0xFF505050, 0xFF4F4F4F, 0xFFD7D7D7, 0xFFD6D6D6, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4B4B4B, 
        0xFF4B4B4B, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF5E5E5E, 0xFFD4D4D4, 0xFFA0A0A0, 0xFF3E3E3E, 0xFF404040, 0xFF5B5B5B, 0xFFC5C5C5, 0xFFB5B5B5, 0xFFCFCFCF, 0xFFD2D2D2, 
        0xFF575757, 0xFF393939, 0xFF3B3B3B, 0xFF535353, 0xFF535353, 0xFF343434, 0xFF343434, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF691818, 0xFFC00202, 0xFF890F0F, 0xFF312424, 0xFF272727, 
        0xFF252525, 0xFF2C2C2C, 0xFF3A3A3A, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF686868, 0xFFA9A9A9, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xBBBBBBBB, 0x11BBBBBB, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x11BABABA, 0xCCBABABA, 0xFFBBBBBB, 
        0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFF9D9D9D, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF4A4A4A, 0xFF5A5A5A, 0xFF636363, 0xFF636363, 0xFF864242, 0xFFBD0D0D, 
        0xFFA82121, 0xFF745858, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF686868, 0xFF696969, 0xFF6B6B6B, 0xFF696969, 0xFF696969, 0xFF828282, 0xFFC5C5C5, 0xFFDBDBDB, 0xFFC2C2C2, 0xFFD4D4D4, 0xFFB4B4B4, 0xFF676767, 0xFF676767, 
        0xFFC4C4C4, 0xFFDCDCDC, 0xFF757575, 0xFF666666, 0xFF9C9C9C, 0xFFDCDCDC, 0xFF848484, 0xFF636363, 0xFF636363, 0xFF626262, 0xFF616161, 0xFF606060, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 
        0xFFDADADA, 0xFFD9D9D9, 0xFF585858, 0xFF585858, 0xFF7C7C7C, 0xFFD8D8D8, 0xFF818181, 0xFF545454, 0xFF545454, 0xFF535353, 0xFF505050, 0xFFC4C4C4, 0xFFD8D8D8, 0xFF555555, 0xFF595959, 0xFFD7D7D7, 0xFFD6D6D6, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4B4B4B, 
        0xFF494949, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF868686, 0xFFD4D4D4, 0xFF6C6C6C, 0xFF3E3E3E, 0xFF5F5F5F, 0xFF9B9B9B, 0xFFA6A6A6, 0xFF888888, 0xFFD2D2D2, 0xFFB2B2B2, 
        0xFF393939, 0xFF383838, 0xFF808080, 0xFFA5A5A5, 0xFFC5C5C5, 0xFFADADAD, 0xFF626262, 0xFF3A3A3A, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2A2A2A, 0xFF332626, 0xFF7F1313, 0xFFC00202, 0xFF731414, 
        0xFF252525, 0xFF242424, 0xFF262626, 0xFF323232, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF999999, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xDDBABABA, 
        0x33BABABA, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33B9B9B9, 0xDDB9B9B9, 0xFFBABABA, 0xFFBABABA, 
        0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFB1B1B1, 0xFF8C8C8C, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF545454, 0xFF616161, 0xFF606060, 0xFF6E5353, 0xFFAE1919, 0xFFB61313, 0xFF7E4848, 
        0xFF646464, 0xFF646464, 0xFF646464, 0xFF666666, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF696969, 0xFF7F7F7F, 0xFFACACAC, 0xFF676767, 0xFF696969, 0xFFAAAAAA, 0xFFDBDBDB, 0xFF828282, 0xFF6B6B6B, 0xFFB3B3B3, 0xFFD8D8D8, 0xFF7C7C7C, 0xFF676767, 
        0xFF919191, 0xFFDCDCDC, 0xFF8F8F8F, 0xFF646464, 0xFF7A7A7A, 0xFFDCDCDC, 0xFFAFAFAF, 0xFF626262, 0xFF616161, 0xFF616161, 0xFF606060, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5C5C5C, 0xFF5B5B5B, 0xFF5A5A5A, 0xFF5A5A5A, 
        0xFFDADADA, 0xFFD9D9D9, 0xFF575757, 0xFF575757, 0xFFA8A8A8, 0xFFD8D8D8, 0xFFD8D8D8, 0xFFD8D8D8, 0xFFD8D8D8, 0xFF535353, 0xFF515151, 0xFF909090, 0xFFD7D7D7, 0xFFD7D7D7, 0xFFD7D7D7, 0xFFD7D7D7, 0xFF989898, 0xFF4D4D4D, 0xFF4B4B4B, 0xFF4B4B4B, 
        0xFF494949, 0xFF494949, 0xFF484848, 0xFF464646, 0xFF464646, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF474747, 0xFFD4D4D4, 0xFFD4D4D4, 0xFF4B4B4B, 0xFF5C5C5C, 0xFF9F9F9F, 0xFFBABABA, 0xFF656565, 0xFF868686, 0xFFD2D2D2, 0xFF717171, 
        0xFF373737, 0xFF585858, 0xFFBCBCBC, 0xFFB3B3B3, 0xFF9D9D9D, 0xFFCCCCCC, 0xFF9F9F9F, 0xFF464646, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF292929, 0xFF282828, 0xFF461E1E, 0xFF9E0909, 
        0xFFA90707, 0xFF441B1B, 0xFF222222, 0xFF212121, 0xFF272727, 0xFF3B3B3B, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF777777, 0xFFACACAC, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 
        0xEEB9B9B9, 0x44B9B9B9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x44B9B9B9, 0xEEB9B9B9, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 
        0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFA8A8A8, 0xFF696969, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF494949, 0xFF585858, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF913333, 0xFFC40606, 0xFF923333, 0xFF616161, 0xFF616161, 
        0xFF626262, 0xFF646464, 0xFF646464, 0xFF646464, 0xFF656565, 0xFF646464, 0xFF666666, 0xFF6C6C6C, 0xFFA4A4A4, 0xFFDCDCDC, 0xFF727272, 0xFF676767, 0xFF9B9B9B, 0xFFD8D8D8, 0xFF858585, 0xFF676767, 0xFF878787, 0xFFDCDCDC, 0xFF9B9B9B, 0xFF656565, 
        0xFF737373, 0xFFDCDCDC, 0xFFC3C3C3, 0xFF646464, 0xFF646464, 0xFFC8C8C8, 0xFFDBDBDB, 0xFF6F6F6F, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5B5B5B, 0xFF5A5A5A, 0xFF5A5A5A, 
        0xFFD9D9D9, 0xFFD9D9D9, 0xFF575757, 0xFF575757, 0xFFC5C5C5, 0xFFD8D8D8, 0xFFD8D8D8, 0xFFD8D8D8, 0xFFD8D8D8, 0xFF525252, 0xFF505050, 0xFF555555, 0xFF9A9A9A, 0xFFD7D7D7, 0xFFD7D7D7, 0xFF989898, 0xFF515151, 0xFF4D4D4D, 0xFF4B4B4B, 0xFF4B4B4B, 
        0xFF494949, 0xFF494949, 0xFF484848, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF676767, 0xFFD4D4D4, 0xFF8F8F8F, 0xFF525252, 0xFF9F9F9F, 0xFFC0C0C0, 0xFF737373, 0xFF3C3C3C, 0xFFBABABA, 0xFFD2D2D2, 0xFF4D4D4D, 
        0xFF373737, 0xFF858585, 0xFFD0D0D0, 0xFF686868, 0xFF3D3D3D, 0xFF727272, 0xFFB8B8B8, 0xFF656565, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2A2A2A, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF252525, 
        0xFF5C1818, 0xFFC00202, 0xFF7C0F0F, 0xFF222222, 0xFF1F1F1F, 0xFF202020, 0xFF313131, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF575757, 0xFFA2A2A2, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 
        0xFFBABABA, 0xFFBABABA, 0x55B9B9B9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x44B8B8B8, 0xFFB9B9B9, 0xFFB9B9B9, 0xFFB9B9B9, 0xFFB9B9B9, 0xFFB9B9B9, 
        0xFFB9B9B9, 0xFFB9B9B9, 0xFFB9B9B9, 0xFFB9B9B9, 0xFFB9B9B9, 0xFF9C9C9C, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF515151, 0xFF5E5E5E, 0xFF5F5F5F, 0xFF6D5252, 0xFFB51212, 0xFFAE1919, 0xFF6D5252, 0xFF616161, 0xFF616161, 0xFF616161, 
        0xFF616161, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF646464, 0xFF636363, 0xFF646464, 0xFF828282, 0xFFC3C3C3, 0xFFDCDCDC, 0xFF8B8B8B, 0xFF646464, 0xFF7D7D7D, 0xFFDCDCDC, 0xFFABABAB, 0xFF666666, 0xFF6C6C6C, 0xFFDCDCDC, 0xFFDCDCDC, 0xFF676767, 
        0xFF646464, 0xFFB3B3B3, 0xFFDCDCDC, 0xFF777777, 0xFF626262, 0xFF929292, 0xFFDBDBDB, 0xFF898989, 0xFF606060, 0xFF606060, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5C5C5C, 0xFF5B5B5B, 0xFF595959, 0xFF585858, 
        0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF565656, 0xFF555555, 0xFF545454, 0xFF545454, 0xFF535353, 0xFF535353, 0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4A4A4A, 0xFF494949, 
        0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF959595, 0xFFD4D4D4, 0xFF646464, 0xFF797979, 0xFFCDCDCD, 0xFFA3A3A3, 0xFF565656, 0xFF5B5B5B, 0xFFD2D2D2, 0xFF9D9D9D, 0xFF393939, 
        0xFF3F3F3F, 0xFFD1D1D1, 0xFFD1D1D1, 0xFF404040, 0xFF343434, 0xFF989898, 0xFFC6C6C6, 0xFF555555, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF272727, 0xFF272727, 0xFF252525, 
        0xFF252525, 0xFF2F2121, 0xFF870D0D, 0xFFB40404, 0xFF421919, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF282828, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF939393, 0xFFB9B9B9, 0xFFB9B9B9, 0xFFB9B9B9, 0xFFB9B9B9, 0xFFB9B9B9, 0xFFB9B9B9, 0xFFB9B9B9, 
        0xFFB9B9B9, 0xFFB9B9B9, 0xFFB9B9B9, 0x66B8B8B8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x66B7B7B7, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 
        0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFF8C8C8C, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF454545, 0xFF545454, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF893838, 0xFFC30606, 0xFF8A3838, 0xFF606060, 0xFF606060, 0xFF616161, 0xFF616161, 0xFF616161, 
        0xFF616161, 0xFF616161, 0xFF626262, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF757575, 0xFFA8A8A8, 0xFF9C9C9C, 0xFFDCDCDC, 0xFFBBBBBB, 0xFF646464, 0xFF656565, 0xFFD1D1D1, 0xFFDCDCDC, 0xFF6D6D6D, 0xFF646464, 0xFFA2A2A2, 0xFFDCDCDC, 0xFF808080, 
        0xFF636363, 0xFF858585, 0xFFD7D7D7, 0xFF999999, 0xFF666666, 0xFF8D8D8D, 0xFFD2D2D2, 0xFF969696, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5D5D5D, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF595959, 0xFF585858, 0xFF585858, 
        0xFF585858, 0xFF575757, 0xFF565656, 0xFF565656, 0xFF555555, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF525252, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF494949, 0xFF494949, 
        0xFF494949, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF4F4F4F, 0xFFD4D4D4, 0xFFCBCBCB, 0xFF424242, 0xFF9C9C9C, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFD3D3D3, 0xFFBABABA, 0xFFD2D2D2, 0xFF6C6C6C, 0xFF393939, 
        0xFF636363, 0xFFD2D2D2, 0xFF878787, 0xFF353535, 0xFF474747, 0xFFD2D2D2, 0xFFBEBEBE, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF272727, 0xFF262626, 0xFF252525, 
        0xFF242424, 0xFF242424, 0xFF232323, 0xFF4E1818, 0xFFBF0202, 0xFF7A0D0D, 0xFF1E1E1E, 0xFF1C1C1C, 0xFF212121, 0xFF383838, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF777777, 0xFFAFAFAF, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 
        0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0x88B7B7B7, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x66B7B7B7, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 
        0xFFB8B8B8, 0xFFB8B8B8, 0xFFAAAAAA, 0xFF696969, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF4A4A4A, 0xFF565656, 0xFF5B5B5B, 0xFF635555, 0xFFA51E1E, 0xFFB51212, 0xFF6B5050, 0xFF5E5E5E, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 
        0xFF606060, 0xFF606060, 0xFF616161, 0xFF636363, 0xFF626262, 0xFF616161, 0xFF616161, 0xFF636363, 0xFF686868, 0xFFBBBBBB, 0xFFDCDCDC, 0xFF747474, 0xFF646464, 0xFF959595, 0xFFDCDCDC, 0xFF898989, 0xFF646464, 0xFF7D7D7D, 0xFFDBDBDB, 0xFFA6A6A6, 
        0xFF616161, 0xFF6A6A6A, 0xFFBDBDBD, 0xFFDADADA, 0xFFCBCBCB, 0xFFDBDBDB, 0xFFBABABA, 0xFF707070, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5E5E5E, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5C5C5C, 0xFF5B5B5B, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF585858, 0xFF575757, 
        0xFF575757, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF545454, 0xFF535353, 0xFF535353, 0xFF525252, 0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF494949, 
        0xFF484848, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF5B5B5B, 0xFFB7B7B7, 0xFF828282, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF575757, 0xFF7D7D7D, 0xFFC5C5C5, 0xFFD3D3D3, 0xFFD2D2D2, 0xFFD2D2D2, 0xFF444444, 
        0xFF959595, 0xFFD1D1D1, 0xFF5A5A5A, 0xFF343434, 0xFF6C6C6C, 0xFFD2D2D2, 0xFF757575, 0xFF313131, 0xFF313131, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF252525, 0xFF252525, 
        0xFF242424, 0xFF242424, 0xFF222222, 0xFF1F1F1F, 0xFF2A1C1C, 0xFF910909, 0xFFA80505, 0xFF331818, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF2E2E2E, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF585858, 0xFFA6A6A6, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 
        0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0x99B7B7B7, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x66B6B6B6, 0xFFB7B7B7, 0xFFB7B7B7, 0xFFB7B7B7, 0xFFB7B7B7, 0xFFB7B7B7, 0xFFB7B7B7, 0xFFB7B7B7, 0xFFB7B7B7, 
        0xFFB7B7B7, 0xFFA5A5A5, 0xFF585858, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF4F4F4F, 0xFF585858, 0xFF585858, 0xFF6F4646, 0xFFBC0C0C, 0xFF962A2A, 0xFF5C5C5C, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 
        0xFF606060, 0xFF606060, 0xFF606060, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF626262, 0xFF636363, 0xFF898989, 0xFFDBDBDB, 0xFF939393, 0xFF636363, 0xFF767676, 0xFFDBDBDB, 0xFFB8B8B8, 0xFF626262, 0xFF676767, 0xFFD4D4D4, 0xFFD0D0D0, 
        0xFF6A6A6A, 0xFF616161, 0xFF7D7D7D, 0xFF9C9C9C, 0xFFC5C5C5, 0xFFACACAC, 0xFF7B7B7B, 0xFF626262, 0xFF5F5F5F, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5C5C5C, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF595959, 0xFF585858, 0xFF585858, 0xFF575757, 
        0xFF575757, 0xFF565656, 0xFF555555, 0xFF555555, 0xFF545454, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF525252, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF494949, 0xFF484848, 
        0xFF484848, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF444444, 0xFF434343, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF404040, 0xFF484848, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF656565, 0xFFD3D3D3, 0xFFB7B7B7, 0xFF969696, 0xFF484848, 
        0xFFCCCCCC, 0xFFC2C2C2, 0xFF363636, 0xFF353535, 0xFFAAAAAA, 0xFFD1D1D1, 0xFF4C4C4C, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF272727, 0xFF252525, 0xFF252525, 
        0xFF242424, 0xFF232323, 0xFF202020, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF621111, 0xFFBF0101, 0xFF551111, 0xFF1A1A1A, 0xFF191919, 0xFF262626, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFFA0A0A0, 0xFFB7B7B7, 0xFFB7B7B7, 0xFFB7B7B7, 
        0xFFB7B7B7, 0xFFB7B7B7, 0xFFB7B7B7, 0xFFB7B7B7, 0xFFB7B7B7, 0xFFB7B7B7, 0x99B6B6B6, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x66B5B5B5, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 
        0xFFA2A2A2, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF505050, 0xFF585858, 0xFF585858, 0xFF8D2E2E, 0xFFBB0B0B, 0xFF7F3B3B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5C5C5C, 0xFF5B5B5B, 0xFF5D5D5D, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 
        0xFF5F5F5F, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF6E6E6E, 0xFFDBDBDB, 0xFFCCCCCC, 0xFF616161, 0xFF626262, 0xFFB8B8B8, 0xFFD8D8D8, 0xFF7A7A7A, 0xFF858585, 0xFFC7C7C7, 0xFFAEAEAE, 
        0xFF6F6F6F, 0xFF606060, 0xFF616161, 0xFF696969, 0xFF6A6A6A, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5E5E5E, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF595959, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF575757, 
        0xFF565656, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF545454, 0xFF535353, 0xFF535353, 0xFF515151, 0xFF505050, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF494949, 0xFF494949, 0xFF494949, 
        0xFF474747, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF939393, 0xFFD2D2D2, 0xFF5E5E5E, 0xFF3C3C3C, 0xFF606060, 
        0xFFBCBCBC, 0xFF7C7C7C, 0xFF393939, 0xFF535353, 0xFFD1D1D1, 0xFFA7A7A7, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF282828, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF242424, 
        0xFF232323, 0xFF222222, 0xFF212121, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1C1C1C, 0xFF3E1616, 0xFFB30303, 0xFF840A0A, 0xFF191919, 0xFF161616, 0xFF1E1E1E, 0xFF3D3D3D, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF9D9D9D, 0xFFB6B6B6, 0xFFB6B6B6, 
        0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0x99B5B5B5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x66B5B5B5, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFF9D9D9D, 
        0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF525252, 0xFF575757, 0xFF585858, 0xFFA41C1C, 0xFFB41111, 0xFF674B4B, 0xFF585858, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5C5C5C, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5F5F5F, 
        0xFF5F5F5F, 0xFF606060, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF606060, 0xFF606060, 0xFF616161, 0xFF616161, 0xFF606060, 0xFF616161, 0xFFA9A9A9, 0xFFDBDBDB, 0xFF787878, 0xFF616161, 0xFF838383, 0xFFBCBCBC, 0xFFDADADA, 0xFFDBDBDB, 0xFFCBCBCB, 0xFF8A8A8A, 
        0xFF616161, 0xFF606060, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5E5E5E, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5B5B5B, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF595959, 0xFF585858, 0xFF585858, 0xFF575757, 0xFF575757, 0xFF575757, 
        0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF535353, 0xFF525252, 0xFF515151, 0xFF505050, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF494949, 0xFF494949, 0xFF484848, 
        0xFF464646, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF424242, 0xFF424242, 0xFF404040, 0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF484848, 0xFF696969, 0xFF3C3C3C, 0xFF383838, 0xFF565656, 
        0xFFADADAD, 0xFFABABAB, 0xFF6E6E6E, 0xFF888888, 0xFFD1D1D1, 0xFF696969, 0xFF313131, 0xFF313131, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF383838, 0xFF383838, 
        0xFF373737, 0xFF363636, 0xFF333333, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF261919, 0xFF900808, 0xFFA70404, 0xFF221414, 0xFF151515, 0xFF1B1B1B, 0xFF383838, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF979797, 0xFFB6B6B6, 
        0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0x99B5B5B5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x66B4B4B4, 0xFFB5B5B5, 0xFFB5B5B5, 0xFFB5B5B5, 0xFFB5B5B5, 0xFFB5B5B5, 0xFFB5B5B5, 0xFFB5B5B5, 0xFFB5B5B5, 0xFFB5B5B5, 0xFF9C9C9C, 0xFF464646, 
        0xFF464646, 0xFF464646, 0xFF484848, 0xFF515151, 0xFF565656, 0xFF5D4F4F, 0xFFB31111, 0xFFA41C1C, 0xFF575757, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5E5E5E, 
        0xFF5D5D5D, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF606060, 0xFF606060, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF7F7F7F, 0xFFDBDBDB, 0xFF9C9C9C, 0xFF606060, 0xFF666666, 0xFF7A7A7A, 0xFFA7A7A7, 0xFF9E9E9E, 0xFF7A7A7A, 0xFF5F5F5F, 
        0xFF5F5F5F, 0xFF5F5F5F, 0xFF5E5E5E, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF595959, 0xFF585858, 0xFF585858, 0xFF575757, 0xFF575757, 0xFF575757, 
        0xFF555555, 0xFF545454, 0xFF545454, 0xFF535353, 0xFF525252, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF474747, 
        0xFF464646, 0xFF464646, 0xFF464646, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF404040, 0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF393939, 0xFF373737, 0xFF424242, 
        0xFF878787, 0xFFD1D1D1, 0xFFD1D1D1, 0xFFC9C9C9, 0xFF9F9F9F, 0xFF424242, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2A2A2A, 0xFF292929, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF474747, 0xFFB3B3B3, 
        0xFF878787, 0xFF959595, 0xFFB9B9B9, 0xFF323232, 0xFF1E1E1E, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF770B0B, 0xFFB30202, 0xFF391010, 0xFF141414, 0xFF131313, 0xFF333333, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF919191, 
        0xFFB5B5B5, 0xFFB5B5B5, 0xFFB5B5B5, 0xFFB5B5B5, 0xFFB5B5B5, 0xFFB5B5B5, 0xFFB5B5B5, 0xFFB5B5B5, 0xFFB5B5B5, 0x88B4B4B4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x44B3B3B3, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFF959595, 0xFF474747, 0xFF474747, 
        0xFF474747, 0xFF494949, 0xFF505050, 0xFF535353, 0xFF6C4343, 0xFFC30505, 0xFF8C2D2D, 0xFF575757, 0xFF575757, 0xFF585858, 0xFF575757, 0xFF585858, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5C5C5C, 
        0xFF5D5D5D, 0xFF5D5D5D, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5F5F5F, 0xFF5E5E5E, 0xFF5D5D5D, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF656565, 0xFFDBDBDB, 0xFFDBDBDB, 0xFF646464, 0xFF606060, 0xFF616161, 0xFF636363, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5E5E5E, 
        0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF595959, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF575757, 0xFF565656, 0xFF555555, 
        0xFF555555, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 
        0xFF454545, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF363636, 0xFF363636, 
        0xFF363636, 0xFF555555, 0xFF757575, 0xFF6C6C6C, 0xFF4A4A4A, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF292929, 0xFF292929, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF252525, 0xFF292929, 0xFF646464, 
        0xFFCDCDCD, 0xFFCDCDCD, 0xFF565656, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1B1B1B, 0xFF181818, 0xFF181818, 0xFF510D0D, 0xFFBE0101, 0xFF440D0D, 0xFF121212, 0xFF111111, 0xFF303030, 0xFF474747, 0xFF474747, 0xFF474747, 
        0xFF8B8B8B, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0x66B3B3B3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33B3B3B3, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFF919191, 0xFF484848, 0xFF484848, 0xFF484848, 
        0xFF4A4A4A, 0xFF515151, 0xFF535353, 0xFF723C3C, 0xFFC30505, 0xFF7C3838, 0xFF555555, 0xFF565656, 0xFF565656, 0xFF575757, 0xFF575757, 0xFF585858, 0xFF6B6B6B, 0xFF656565, 0xFF595959, 0xFF5A5A5A, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 
        0xFF5C5C5C, 0xFF5B5B5B, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5F5F5F, 0xFF8F8F8F, 0xFF888888, 0xFF636363, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5E5E5E, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 
        0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5C5C5C, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF595959, 0xFF585858, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF565656, 0xFF555555, 0xFF545454, 
        0xFF545454, 0xFF535353, 0xFF535353, 0xFF525252, 0xFF515151, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF4E4E4E, 0xFFC3C3C3, 0xFFD7D7D7, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF494949, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 
        0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF404040, 0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF373737, 0xFF363636, 
        0xFF353535, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF323232, 0xFF313131, 0xFF303030, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF252525, 0xFF363636, 0xFFB0B0B0, 
        0xFFCDCDCD, 0xFF686868, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF363636, 0xFF3B3B3B, 0xFF1C1C1C, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF171717, 0xFF380F0F, 0xFFBE0101, 0xFF5B0A0A, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF484848, 0xFF484848, 
        0xFF484848, 0xFF828282, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0x55B3B3B3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33B2B2B2, 0xEEB2B2B2, 0xFFB3B3B3, 0xFFB3B3B3, 0xFFB3B3B3, 0xFFB3B3B3, 0xFFB3B3B3, 0xFFB3B3B3, 0xFFB3B3B3, 0xFFB3B3B3, 0xFF919191, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF4A4A4A, 
        0xFF505050, 0xFF505050, 0xFF7A3737, 0xFFBB0B0B, 0xFF6A4242, 0xFF555555, 0xFF545454, 0xFF555555, 0xFF555555, 0xFF565656, 0xFF5E5E5E, 0xFF979797, 0xFFAFAFAF, 0xFFAAAAAA, 0xFF828282, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 
        0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5C5C5C, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5F5F5F, 0xFF5E5E5E, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 
        0xFF5C5C5C, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF595959, 0xFF585858, 0xFF575757, 0xFF565656, 0xFF565656, 0xFFBDBDBD, 0xFFCECECE, 0xFF555555, 0xFF545454, 
        0xFF535353, 0xFF535353, 0xFF535353, 0xFF525252, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF4D4D4D, 0xFFC3C3C3, 0xFFD6D6D6, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 
        0xFF454545, 0xFF444444, 0xFFCACACA, 0xFFB6B6B6, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF363636, 0xFF363636, 0xFF363636, 
        0xFF353535, 0xFF343434, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF909090, 0xFFCDCDCD, 
        0xFF7B7B7B, 0xFF222222, 0xFF1F1F1F, 0xFF656565, 0xFF9A9A9A, 0xFF969696, 0xFF828282, 0xFF292929, 0xFF181818, 0xFF181818, 0xFF171717, 0xFF161616, 0xFF131313, 0xFF290E0E, 0xFFB20202, 0xFF740707, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF494949, 
        0xFF494949, 0xFF494949, 0xFF838383, 0xFFB3B3B3, 0xFFB3B3B3, 0xFFB3B3B3, 0xFFB3B3B3, 0xFFB3B3B3, 0xFFB3B3B3, 0xFFB3B3B3, 0xFFB3B3B3, 0xFFB3B3B3, 0x44B2B2B2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x11B1B1B1, 0xDDB1B1B1, 0xFFB2B2B2, 0xFFB2B2B2, 0xFFB2B2B2, 0xFFB2B2B2, 0xFFB2B2B2, 0xFFB2B2B2, 0xFFB2B2B2, 0xFFB2B2B2, 0xFF939393, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF4F4F4F, 
        0xFF505050, 0xFF812F2F, 0xFFC30505, 0xFF6A4242, 0xFF535353, 0xFF535353, 0xFF545454, 0xFF555555, 0xFF555555, 0xFF606060, 0xFFAAAAAA, 0xFFD4D4D4, 0xFFB9B9B9, 0xFFD4D4D4, 0xFFD1D1D1, 0xFF7F7F7F, 0xFF585858, 0xFF585858, 0xFF595959, 0xFF5A5A5A, 
        0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5C5C5C, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5D5D5D, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5B5B5B, 
        0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF595959, 0xFF585858, 0xFF585858, 0xFF575757, 0xFF565656, 0xFF555555, 0xFF555555, 0xFFACACAC, 0xFFD8D8D8, 0xFF656565, 0xFF535353, 
        0xFF535353, 0xFF535353, 0xFF535353, 0xFF525252, 0xFF505050, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4D4D4D, 0xFFC4C4C4, 0xFFD6D6D6, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF444444, 
        0xFF444444, 0xFF4E4E4E, 0xFFD4D4D4, 0xFFADADAD, 0xFF424242, 0xFF424242, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF363636, 0xFF363636, 0xFF363636, 
        0xFF343434, 0xFF343434, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF292929, 0xFF282828, 0xFF282828, 0xFF252525, 0xFF252525, 0xFF787878, 0xFFCDCDCD, 0xFF959595, 
        0xFF272727, 0xFF1F1F1F, 0xFF5C5C5C, 0xFFCDCDCD, 0xFFC6C6C6, 0xFFA5A5A5, 0xFFCCCCCC, 0xFF919191, 0xFF2F2F2F, 0xFF181818, 0xFF151515, 0xFF151515, 0xFF131313, 0xFF121212, 0xFF1D0F0F, 0xFFB20202, 0xFF800606, 0xFF111111, 0xFF111111, 0xFF292929, 
        0xFF494949, 0xFF494949, 0xFF494949, 0xFF8A8A8A, 0xFFB2B2B2, 0xFFB2B2B2, 0xFFB2B2B2, 0xFFB2B2B2, 0xFFB2B2B2, 0xFFB2B2B2, 0xFFB2B2B2, 0xFFB2B2B2, 0xEEB1B1B1, 0x33B1B1B1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xBBB0B0B0, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFF9A9A9A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4D4D4D, 0xFF4E4E4E, 
        0xFF812F2F, 0xFFBA0A0A, 0xFF614545, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF545454, 0xFF545454, 0xFF555555, 0xFF676767, 0xFFC1C1C1, 0xFFA8A8A8, 0xFF616161, 0xFF717171, 0xFFD9D9D9, 0xFFD9D9D9, 0xFF747474, 0xFF585858, 0xFF585858, 0xFF595959, 
        0xFF595959, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5B5B5B, 0xFF5C5C5C, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 
        0xFF5B5B5B, 0xFF5B5B5B, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF595959, 0xFF585858, 0xFF585858, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF565656, 0xFF555555, 0xFF555555, 0xFF656565, 0xFF5C5C5C, 0xFF545454, 0xFF535353, 
        0xFF525252, 0xFF515151, 0xFF505050, 0xFF505050, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFFC3C3C3, 0xFFD6D6D6, 0xFF4B4B4B, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF454545, 
        0xFF444444, 0xFF444444, 0xFF4C4C4C, 0xFF555555, 0xFF414141, 0xFF414141, 0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF393939, 0xFF373737, 0xFF363636, 0xFF363636, 0xFF353535, 
        0xFF343434, 0xFF343434, 0xFF333333, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF656565, 0xFFCDCDCD, 0xFFB7B7B7, 0xFF393939, 
        0xFF202020, 0xFF4D4D4D, 0xFFCDCDCD, 0xFFCDCDCD, 0xFF4D4D4D, 0xFF313131, 0xFF8B8B8B, 0xFFADADAD, 0xFF414141, 0xFF1B1B1B, 0xFF161616, 0xFF141414, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF1D0F0F, 0xFF990404, 0xFF800606, 0xFF111111, 0xFF111111, 
        0xFF292929, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF909090, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xDDB0B0B0, 0x11B0B0B0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x99B0B0B0, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFF9B9B9B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF7F2E2E, 
        0xFFBA0A0A, 0xFF574A4A, 0xFF505050, 0xFF515151, 0xFF505050, 0xFF525252, 0xFF535353, 0xFF545454, 0xFF555555, 0xFF717171, 0xFFBBBBBB, 0xFFB4B4B4, 0xFF5C5C5C, 0xFF565656, 0xFF7B7B7B, 0xFFD9D9D9, 0xFFD9D9D9, 0xFF686868, 0xFF585858, 0xFF585858, 
        0xFF585858, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF595959, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5A5A5A, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5A5A5A, 
        0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF737373, 0xFFA5A5A5, 0xFF7A7A7A, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF565656, 0xFF565656, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF535353, 0xFF525252, 
        0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFFC3C3C3, 0xFFD6D6D6, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF494949, 0xFF484848, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF444444, 
        0xFF444444, 0xFF444444, 0xFF424242, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF585858, 0xFF939393, 0xFF555555, 0xFF363636, 0xFF353535, 0xFF353535, 
        0xFF343434, 0xFF343434, 0xFF333333, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF282828, 0xFF262626, 0xFF565656, 0xFFCDCDCD, 0xFFCDCDCD, 0xFF454545, 0xFF222222, 
        0xFF3F3F3F, 0xFFCDCDCD, 0xFFCDCDCD, 0xFF8B8B8B, 0xFF3C3C3C, 0xFF202020, 0xFF8F8F8F, 0xFFABABAB, 0xFF494949, 0xFF161616, 0xFF151515, 0xFF131313, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF990404, 0xFF800606, 0xFF111111, 
        0xFF111111, 0xFF2A2A2A, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF949494, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xBBB0B0B0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x66AFAFAF, 0xFFB0B0B0, 0xFFB0B0B0, 0xFFB0B0B0, 0xFFB0B0B0, 0xFFB0B0B0, 0xFFB0B0B0, 0xFFB0B0B0, 0xFFB0B0B0, 0xFF9E9E9E, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4A4A4A, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF7F2E2E, 0xFFBA0A0A, 
        0xFF564848, 0xFF4E4E4E, 0xFF4F4F4F, 0xFF505050, 0xFF505050, 0xFF515151, 0xFF676767, 0xFF646464, 0xFF535353, 0xFF535353, 0xFF989898, 0xFFD5D5D5, 0xFF999999, 0xFF555555, 0xFF565656, 0xFF888888, 0xFFD8D8D8, 0xFFBCBCBC, 0xFF5F5F5F, 0xFF585858, 
        0xFF575757, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF595959, 0xFF585858, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 
        0xFF595959, 0xFF585858, 0xFF585858, 0xFF7A7A7A, 0xFFD9D9D9, 0xFFADADAD, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF565656, 0xFF565656, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF525252, 0xFF515151, 
        0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFFC3C3C3, 0xFFD6D6D6, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF444444, 0xFF444444, 
        0xFF444444, 0xFF444444, 0xFF424242, 0xFF414141, 0xFF404040, 0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF393939, 0xFF9E9E9E, 0xFFD1D1D1, 0xFF5F5F5F, 0xFF363636, 0xFF353535, 0xFF343434, 
        0xFF343434, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF292929, 0xFF292929, 0xFF272727, 0xFF373737, 0xFFCECECE, 0xFFCDCDCD, 0xFF565656, 0xFF232323, 0xFF313131, 
        0xFFA9A9A9, 0xFFCDCDCD, 0xFF9F9F9F, 0xFFAFAFAF, 0xFFC4C4C4, 0xFF505050, 0xFF323232, 0xFF696969, 0xFF171717, 0xFF151515, 0xFF282828, 0xFF2C2C2C, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF990404, 0xFF800606, 
        0xFF111111, 0xFF111111, 0xFF2A2A2A, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF9A9A9A, 0xFFB0B0B0, 0xFFB0B0B0, 0xFFB0B0B0, 0xFFB0B0B0, 0xFFB0B0B0, 0xFFB0B0B0, 0xFFB0B0B0, 0xFFB0B0B0, 0x88AFAFAF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x33AEAEAE, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFF9E9E9E, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4A4A4A, 0xFF494949, 0xFF4C4C4C, 0xFF7F2E2E, 0xFFBA0A0A, 0xFF554747, 
        0xFF4D4D4D, 0xFF4E4E4E, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF575757, 0xFF969696, 0xFFBABABA, 0xFFBBBBBB, 0xFF737373, 0xFF535353, 0xFF5B5B5B, 0xFFB8B8B8, 0xFFD8D8D8, 0xFF888888, 0xFF555555, 0xFF555555, 0xFF999999, 0xFFD8D8D8, 0xFF9F9F9F, 0xFF575757, 
        0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF595959, 0xFF585858, 0xFF585858, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF595959, 0xFF585858, 
        0xFF585858, 0xFF575757, 0xFF575757, 0xFF575757, 0xFFC7C7C7, 0xFFD9D9D9, 0xFF5F5F5F, 0xFF565656, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF545454, 0xFF535353, 0xFF535353, 0xFF505050, 0xFF505050, 0xFF505050, 
        0xFF505050, 0xFF505050, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4B4B4B, 0xFFC3C3C3, 0xFFD6D6D6, 0xFF494949, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 
        0xFF444444, 0xFF434343, 0xFF424242, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF424242, 0xFFC7C7C7, 0xFFBDBDBD, 0xFF363636, 0xFF363636, 0xFF343434, 0xFF343434, 
        0xFF343434, 0xFF333333, 0xFF313131, 0xFF313131, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF292929, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF4E4E4E, 0xFF636363, 0xFF232323, 0xFF222222, 0xFF868686, 
        0xFFCDCDCD, 0xFF7F7F7F, 0xFF2C2C2C, 0xFF626262, 0xFFC7C7C7, 0xFF7E7E7E, 0xFF2C2C2C, 0xFF161616, 0xFF151515, 0xFF464646, 0xFF8B8B8B, 0xFF8F8F8F, 0xFF737373, 0xFF1E1E1E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF990404, 
        0xFF800606, 0xFF111111, 0xFF111111, 0xFF323232, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF9B9B9B, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0x55AEAEAE, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x11AEAEAE, 0xDDAEAEAE, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFA8A8A8, 0xFF5E5E5E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4B4B4B, 0xFF484848, 0xFF4B4B4B, 0xFF763232, 0xFFC20505, 0xFF663D3D, 0xFF4D4D4D, 
        0xFF4D4D4D, 0xFF4D4D4D, 0xFF4F4F4F, 0xFF535353, 0xFF909090, 0xFFCFCFCF, 0xFFC2C2C2, 0xFFD7D7D7, 0xFFCFCFCF, 0xFF676767, 0xFF535353, 0xFF666666, 0xFFD8D8D8, 0xFFD8D8D8, 0xFF7A7A7A, 0xFF555555, 0xFF5E5E5E, 0xFFB9B9B9, 0xFFB5B5B5, 0xFF686868, 
        0xFF575757, 0xFF575757, 0xFF575757, 0xFF565656, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF595959, 0xFF585858, 0xFF585858, 0xFF575757, 0xFF575757, 
        0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF9B9B9B, 0xFFD8D8D8, 0xFF898989, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF545454, 0xFF545454, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF515151, 0xFF505050, 0xFF505050, 
        0xFF4F4F4F, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4B4B4B, 0xFFC3C3C3, 0xFFD6D6D6, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 
        0xFF424242, 0xFF424242, 0xFF424242, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF6B6B6B, 0xFFD2D2D2, 0xFF898989, 0xFF363636, 0xFF353535, 0xFF353535, 0xFF333333, 
        0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2A2A2A, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF222222, 0xFF424242, 0xFFA2A2A2, 
        0xFFA7A7A7, 0xFF313131, 0xFF1C1C1C, 0xFF5D5D5D, 0xFFC6C6C6, 0xFF9E9E9E, 0xFF282828, 0xFF171717, 0xFF3F3F3F, 0xFFBABABA, 0xFFC2C2C2, 0xFFAFAFAF, 0xFFC4C4C4, 0xFF858585, 0xFF272727, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D0F0F, 
        0xFFB20202, 0xFF740707, 0xFF111111, 0xFF111111, 0xFF383838, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFFA0A0A0, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xEEAEAEAE, 0x22AEAEAE, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0xAAADADAD, 0xFFAEAEAE, 0xFFAEAEAE, 0xFFAEAEAE, 0xFFAEAEAE, 0xFFAEAEAE, 0xFFAEAEAE, 0xFFAEAEAE, 0xFFAEAEAE, 0xFF797979, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4C4C4C, 0xFF474747, 0xFF494949, 0xFF6C3636, 0xFFBA0909, 0xFF653C3C, 0xFF4C4C4C, 0xFF4D4D4D, 
        0xFF4C4C4C, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF545454, 0xFF939393, 0xFFD7D7D7, 0xFF6B6B6B, 0xFF818181, 0xFFC9C9C9, 0xFF7D7D7D, 0xFF5B5B5B, 0xFF535353, 0xFF6F6F6F, 0xFFD8D8D8, 0xFFD8D8D8, 0xFF717171, 0xFF737373, 0xFFD3D3D3, 0xFFB0B0B0, 0xFF626262, 
        0xFF565656, 0xFF565656, 0xFF555555, 0xFF555555, 0xFF565656, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF585858, 0xFF585858, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 
        0xFF575757, 0xFF565656, 0xFF565656, 0xFF555555, 0xFF6F6F6F, 0xFFD8D8D8, 0xFFBDBDBD, 0xFF555555, 0xFF545454, 0xFF545454, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF525252, 0xFF515151, 0xFF505050, 0xFF4F4F4F, 0xFF4F4F4F, 
        0xFF4F4F4F, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4B4B4B, 0xFFC2C2C2, 0xFFD6D6D6, 0xFF484848, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 
        0xFF424242, 0xFF424242, 0xFF414141, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFFA9A9A9, 0xFFD1D1D1, 0xFF555555, 0xFF363636, 0xFF343434, 0xFF343434, 0xFF323232, 
        0xFF313131, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF292929, 0xFF282828, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF222222, 0xFF3A3A3A, 0xFF9C9C9C, 
        0xFFC7C7C7, 0xFF525252, 0xFF4E4E4E, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF474747, 0xFF191919, 0xFF313131, 0xFFB5B5B5, 0xFFCBCBCB, 0xFF5E5E5E, 0xFF303030, 0xFF818181, 0xFFA4A4A4, 0xFF404040, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF1D0F0F, 0xFFB20202, 0xFF5B0A0A, 0xFF111111, 0xFF131313, 0xFF3E3E3E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF5F5F5F, 0xFFA7A7A7, 0xFFAEAEAE, 0xFFAEAEAE, 0xFFAEAEAE, 0xFFAEAEAE, 0xFFAEAEAE, 0xFFAEAEAE, 0xFFAEAEAE, 0xCCADADAD, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x66ACACAC, 
        0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFF898989, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF484848, 0xFF484848, 0xFF623939, 0xFFC20404, 0xFF6B3535, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 
        0xFF4B4B4B, 0xFF4C4C4C, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF7E7E7E, 0xFFD5D5D5, 0xFFB9B9B9, 0xFF757575, 0xFFD3D3D3, 0xFFB2B2B2, 0xFF949494, 0xFF545454, 0xFF515151, 0xFF797979, 0xFFCBCBCB, 0xFFD4D4D4, 0xFFD5D5D5, 0xFFD8D8D8, 0xFF858585, 0xFF545454, 
        0xFF545454, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF565656, 0xFF575757, 0xFF565656, 0xFF575757, 0xFF575757, 0xFF5F5F5F, 0xFF6F6F6F, 0xFF555555, 0xFF565656, 0xFF575757, 0xFF575757, 0xFF565656, 0xFF565656, 
        0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFFC6C6C6, 0xFFD8D8D8, 0xFF646464, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF525252, 0xFF515151, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF4E4E4E, 
        0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4A4A4A, 0xFFC2C2C2, 0xFFD6D6D6, 0xFF484848, 0xFF464646, 0xFF454545, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 
        0xFF424242, 0xFF414141, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF393939, 0xFF393939, 0xFF4C4C4C, 0xFFD2D2D2, 0xFFBDBDBD, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF323232, 
        0xFF313131, 0xFF313131, 0xFF303030, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF4D4D4D, 0xFF404040, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF282828, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF222222, 0xFF222222, 0xFF202020, 0xFF666666, 
        0xFFCDCDCD, 0xFFC8C8C8, 0xFFCACACA, 0xFFCCCCCC, 0xFF585858, 0xFF181818, 0xFF1F1F1F, 0xFF939393, 0xFFCBCBCB, 0xFF6F6F6F, 0xFF131313, 0xFF131313, 0xFF707070, 0xFFA6A6A6, 0xFF4B4B4B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF290E0E, 0xFFBE0101, 0xFF420C0C, 0xFF111111, 0xFF1B1B1B, 0xFF464646, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF787878, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0x99ACACAC, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22ACACAC, 0xFFADADAD, 
        0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFF989898, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF484848, 0xFF464646, 0xFF4E4141, 0xFFB90909, 0xFF732F2F, 0xFF494949, 0xFF4A4A4A, 0xFF4B4B4B, 0xFF4B4B4B, 
        0xFF4B4B4B, 0xFF4B4B4B, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF898989, 0xFFADADAD, 0xFFD7D7D7, 0xFFD7D7D7, 0xFFC1C1C1, 0xFFD7D7D7, 0xFF949494, 0xFF505050, 0xFF505050, 0xFF787878, 0xFF939393, 0xFFA7A7A7, 0xFF7A7A7A, 0xFF545454, 0xFF545454, 
        0xFF545454, 0xFF555555, 0xFF545454, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF565656, 0xFF555555, 0xFF555555, 0xFF666666, 0xFFCECECE, 0xFFC6C6C6, 0xFF555555, 0xFF555555, 0xFF565656, 0xFF555555, 0xFF555555, 0xFF555555, 
        0xFF555555, 0xFF555555, 0xFF555555, 0xFF545454, 0xFF535353, 0xFF909090, 0xFFD8D8D8, 0xFF9A9A9A, 0xFF535353, 0xFF535353, 0xFF525252, 0xFF515151, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4D4D4D, 
        0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF494949, 0xFF494949, 0xFF5A5A5A, 0xFF636363, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF414141, 
        0xFF414141, 0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF393939, 0xFF393939, 0xFF8A8A8A, 0xFFD1D1D1, 0xFF7E7E7E, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF323232, 0xFF313131, 
        0xFF313131, 0xFF313131, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFFB9B9B9, 0xFFC3C3C3, 0xFF404040, 0xFF2A2A2A, 0xFF282828, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF1F1F1F, 0xFF1F1F1F, 
        0xFF595959, 0xFF8F8F8F, 0xFF858585, 0xFF606060, 0xFF1A1A1A, 0xFF191919, 0xFF787878, 0xFFCBCBCB, 0xFF878787, 0xFF131313, 0xFF131313, 0xFF585858, 0xFFCACACA, 0xFFA4A4A4, 0xFF262626, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF360D0D, 0xFFBE0101, 0xFF360D0D, 0xFF111111, 0xFF1D1D1D, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF8E8E8E, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0x44ACACAC, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xCCABABAB, 0xFFACACAC, 
        0xFFACACAC, 0xFFACACAC, 0xFFACACAC, 0xFFACACAC, 0xFFACACAC, 0xFFACACAC, 0xFF9E9E9E, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF484848, 0xFF444444, 0xFF444444, 0xFFB00D0D, 0xFF8C2020, 0xFF484848, 0xFF494949, 0xFF494949, 0xFF4A4A4A, 0xFF494949, 
        0xFF4B4B4B, 0xFF4B4B4B, 0xFF4C4C4C, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF505050, 0xFF757575, 0xFFC0C0C0, 0xFFACACAC, 0xFF5E5E5E, 0xFFBCBCBC, 0xFFD8D8D8, 0xFF838383, 0xFF505050, 0xFF505050, 0xFF545454, 0xFF5C5C5C, 0xFF535353, 0xFF535353, 0xFF535353, 
        0xFF535353, 0xFF535353, 0xFF545454, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF545454, 0xFF535353, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF555555, 0xFFB5B5B5, 0xFFC6C6C6, 0xFF656565, 0xFF545454, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 
        0xFF545454, 0xFF545454, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF646464, 0xFFD8D8D8, 0xFFC5C5C5, 0xFF515151, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4D4D4D, 
        0xFF4D4D4D, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF424242, 0xFF404040, 0xFF404040, 
        0xFF404040, 0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFFBDBDBD, 0xFFD1D1D1, 0xFF494949, 0xFF353535, 0xFF353535, 0xFF333333, 0xFF313131, 0xFF313131, 
        0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF414141, 0xFFB9B9B9, 0xFFA3A3A3, 0xFF2B2B2B, 0xFF292929, 0xFF272727, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF1F1F1F, 0xFF1E1E1E, 
        0xFF1D1D1D, 0xFF323232, 0xFF2A2A2A, 0xFF1B1B1B, 0xFF191919, 0xFF5C5C5C, 0xFFC3C3C3, 0xFFA9A9A9, 0xFF292929, 0xFF131313, 0xFF494949, 0xFFCBCBCB, 0xFFCCCCCC, 0xFF3B3B3B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFFB20202, 0xFF1D0F0F, 0xFF111111, 0xFF252525, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF9A9A9A, 0xFFACACAC, 0xFFACACAC, 0xFFACACAC, 0xFFACACAC, 0xFFACACAC, 0xFFACACAC, 0xFFACACAC, 0xEEABABAB, 
        0x11ABABAB, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x88AAAAAA, 0xFFABABAB, 0xFFABABAB, 
        0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFA4A4A4, 0xFF6E6E6E, 0xFF515151, 0xFF515151, 0xFF4B4B4B, 0xFF444444, 0xFF444444, 0xFF9E1616, 0xFF9E1717, 0xFF464646, 0xFF464646, 0xFF474747, 0xFF484848, 0xFF484848, 0xFF494949, 
        0xFF4A4A4A, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF4B4B4B, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF595959, 0xFFBCBCBC, 0xFFD7D7D7, 0xFF7C7C7C, 0xFF656565, 0xFFD7D7D7, 0xFFB5B5B5, 0xFF636363, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF515151, 0xFF535353, 
        0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF545454, 0xFF535353, 0xFF545454, 0xFF656565, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF535353, 
        0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF525252, 0xFF515151, 0xFFBBBBBB, 0xFFD8D8D8, 0xFF747474, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 
        0xFF4C4C4C, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF404040, 
        0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF393939, 0xFF606060, 0xFFD2D2D2, 0xFFB1B1B1, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF323232, 0xFF313131, 0xFF313131, 
        0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF404040, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF232323, 0xFF212121, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1E1E1E, 
        0xFF1E1E1E, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1A1A1A, 0xFF303030, 0xFF878787, 0xFFCACACA, 0xFF3C3C3C, 0xFF141414, 0xFF3A3A3A, 0xFFCBCBCB, 0xFFCCCCCC, 0xFF4A4A4A, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF740707, 0xFFA50303, 0xFF111111, 0xFF111111, 0xFF313131, 0xFF515151, 0xFF515151, 0xFF616161, 0xFFA0A0A0, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 
        0xAAAAAAAA, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33AAAAAA, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 
        0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFF898989, 0xFF525252, 0xFF525252, 0xFF4E4E4E, 0xFF424242, 0xFF434343, 0xFF792828, 0xFFB90909, 0xFF444444, 0xFF444444, 0xFF454545, 0xFF464646, 0xFF484848, 0xFF484848, 0xFF494949, 
        0xFF494949, 0xFF494949, 0xFF494949, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4C4C4C, 0xFF676767, 0xFFD6D6D6, 0xFFD6D6D6, 0xFF868686, 0xFFCECECE, 0xFFB0B0B0, 0xFF5F5F5F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF515151, 
        0xFF505050, 0xFF525252, 0xFF515151, 0xFF505050, 0xFF525252, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF545454, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 
        0xFF535353, 0xFF535353, 0xFF525252, 0xFF515151, 0xFF505050, 0xFF505050, 0xFF868686, 0xFFD8D8D8, 0xFF8E8E8E, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4C4C4C, 
        0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF494949, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF424242, 0xFF414141, 0xFF404040, 0xFF3E3E3E, 
        0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF393939, 0xFF383838, 0xFF747474, 0xFFD1D1D1, 0xFF737373, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF313131, 0xFF313131, 
        0xFF313131, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 
        0xFF1E1E1E, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF272727, 0xFF858585, 0xFFC0C0C0, 0xFF474747, 0xFF343434, 0xFFAEAEAE, 0xFFCBCBCB, 0xFF5C5C5C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D0505, 0xFF800606, 0xFF111111, 0xFF131313, 0xFF414141, 0xFF525252, 0xFF525252, 0xFF797979, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 
        0xFFABABAB, 0x55AAAAAA, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xCCA9A9A9, 0xFFAAAAAA, 0xFFAAAAAA, 0xFFAAAAAA, 
        0xFFAAAAAA, 0xFFAAAAAA, 0xFFAAAAAA, 0xFFAAAAAA, 0xFF969696, 0xFF525252, 0xFF525252, 0xFF525252, 0xFF444444, 0xFF424242, 0xFF5D3434, 0xFFC20404, 0xFF553A3A, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF464646, 0xFF484848, 0xFF474747, 0xFF484848, 
        0xFF484848, 0xFF484848, 0xFF494949, 0xFF4A4A4A, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4C4C4C, 0xFF4D4D4D, 0xFF737373, 0xFFBCBCBC, 0xFFCECECE, 0xFFCACACA, 0xFF858585, 0xFF4D4D4D, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF505050, 
        0xFF4F4F4F, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF525252, 0xFF515151, 0xFF525252, 0xFF525252, 0xFF515151, 0xFF525252, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF525252, 
        0xFF515151, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF595959, 0xFF585858, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4C4C4C, 
        0xFF4A4A4A, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF474747, 0xFF464646, 0xFF454545, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF424242, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF3E3E3E, 
        0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF393939, 0xFF383838, 0xFF363636, 0xFF363636, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF343434, 0xFF343434, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 
        0xFF303030, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 
        0xFF1E1E1E, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF191919, 0xFF181818, 0xFF5F5F5F, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFA7A7A7, 0xFFCBCBCB, 0xFF707070, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D0F0F, 0xFFB20202, 0xFF4F0B0B, 0xFF111111, 0xFF1B1B1B, 0xFF525252, 0xFF525252, 0xFF525252, 0xFF919191, 0xFFAAAAAA, 0xFFAAAAAA, 0xFFAAAAAA, 0xFFAAAAAA, 0xFFAAAAAA, 0xFFAAAAAA, 
        0xFFAAAAAA, 0xEEA9A9A9, 0x11A9A9A9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x77A8A8A8, 0xFFA9A9A9, 0xFFA9A9A9, 0xFFA9A9A9, 0xFFA9A9A9, 
        0xFFA9A9A9, 0xFFA9A9A9, 0xFFA9A9A9, 0xFF9F9F9F, 0xFF626262, 0xFF535353, 0xFF535353, 0xFF484848, 0xFF404040, 0xFF4A3D3D, 0xFFB80808, 0xFF702D2D, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF454545, 0xFF464646, 0xFF464646, 
        0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF494949, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF6A6A6A, 0xFF747474, 0xFF717171, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4E4E4E, 0xFF4F4F4F, 0xFF4F4F4F, 
        0xFF4F4F4F, 0xFF4F4F4F, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF525252, 0xFF515151, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF515151, 0xFF525252, 0xFF515151, 0xFF505050, 0xFF505050, 
        0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF4B4B4B, 
        0xFF4A4A4A, 0xFF494949, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 
        0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF303030, 
        0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 
        0xFF1C1C1C, 0xFF1B1B1B, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF161616, 0xFF5A5A5A, 0xFF999999, 0xFF8B8B8B, 0xFF727272, 0xFF141414, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF360D0D, 0xFFBE0101, 0xFF290E0E, 0xFF111111, 0xFF232323, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF9C9C9C, 0xFFA9A9A9, 0xFFA9A9A9, 0xFFA9A9A9, 0xFFA9A9A9, 0xFFA9A9A9, 
        0xFFA9A9A9, 0xFFA9A9A9, 0x99A8A8A8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22A7A7A7, 0xEEA7A7A7, 0xFFA8A8A8, 0xFFA8A8A8, 0xFFA8A8A8, 0xFFA8A8A8, 
        0xFFA8A8A8, 0xFFA8A8A8, 0xFFA8A8A8, 0xFF797979, 0xFF545454, 0xFF545454, 0xFF4D4D4D, 0xFF404040, 0xFF404040, 0xFF9D1515, 0xFF931919, 0xFF424242, 0xFF424242, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF464646, 0xFF464646, 
        0xFF464646, 0xFF464646, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF494949, 0xFF494949, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4C4C4C, 0xFF505050, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4F4F4F, 0xFF4E4E4E, 
        0xFF4E4E4E, 0xFF4D4D4D, 0xFF4E4E4E, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF505050, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 
        0xFF505050, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 
        0xFF4A4A4A, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 
        0xFF3E3E3E, 0xFF3E3E3E, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 
        0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF202020, 0xFF1E1E1E, 0xFF1C1C1C, 0xFF1C1C1C, 
        0xFF1B1B1B, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF151515, 0xFF131313, 0xFF313131, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF5B0A0A, 0xFFA50303, 0xFF111111, 0xFF111111, 0xFF373737, 0xFF545454, 0xFF545454, 0xFF6F6F6F, 0xFFA2A2A2, 0xFFA8A8A8, 0xFFA8A8A8, 0xFFA8A8A8, 0xFFA8A8A8, 
        0xFFA8A8A8, 0xFFA8A8A8, 0xFFA8A8A8, 0x33A7A7A7, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xAAA7A7A7, 0xFFA8A8A8, 0xFFA8A8A8, 0xFFA8A8A8, 0xFFA8A8A8, 0xFFA8A8A8, 
        0xFFA8A8A8, 0xFFA8A8A8, 0xFF959595, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF414141, 0xFF3F3F3F, 0xFF6D2929, 0xFFAF0C0C, 0xFF404040, 0xFF404040, 0xFF424242, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF464646, 0xFF464646, 
        0xFF464646, 0xFF464646, 0xFF474747, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF494949, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4B4B4B, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 
        0xFF4D4D4D, 0xFF7B7B7B, 0xFFB2B2B2, 0xFF4E4E4E, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF505050, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF505050, 0xFF505050, 0xFF4F4F4F, 0xFF4F4F4F, 
        0xFF4F4F4F, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF494949, 
        0xFF484848, 0xFF484848, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF424242, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 
        0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF393939, 0xFF373737, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 
        0xFF2D2D2D, 0xFF2C2C2C, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF222222, 0xFF222222, 0xFF202020, 0xFF1E1E1E, 0xFF9D9D9D, 0xFF565656, 0xFF1C1C1C, 
        0xFF1B1B1B, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF151515, 0xFF131313, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D0505, 0xFF740707, 0xFF111111, 0xFF141414, 0xFF4A4A4A, 0xFF555555, 0xFF555555, 0xFF909090, 0xFFA8A8A8, 0xFFA8A8A8, 0xFFA8A8A8, 0xFFA8A8A8, 
        0xFFA8A8A8, 0xFFA8A8A8, 0xFFA8A8A8, 0xCCA7A7A7, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x44A6A6A6, 0xFFA7A7A7, 0xFFA7A7A7, 0xFFA7A7A7, 0xFFA7A7A7, 0xFFA7A7A7, 0xFFA7A7A7, 
        0xFFA7A7A7, 0xFF9D9D9D, 0xFF636363, 0xFF555555, 0xFF555555, 0xFF454545, 0xFF3E3E3E, 0xFF503535, 0xFFC10404, 0xFF5A3131, 0xFF404040, 0xFF404040, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF434343, 0xFF444444, 0xFF444444, 0xFF454545, 0xFF454545, 
        0xFF454545, 0xFF464646, 0xFF464646, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 
        0xFF4D4D4D, 0xFFA9A9A9, 0xFFD6D6D6, 0xFFA8A8A8, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4E4E4E, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 
        0xFF4E4E4E, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF484848, 
        0xFF484848, 0xFF484848, 0xFF464646, 0xFF454545, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3C3C3C, 
        0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2E2E2E, 0xFF2E2E2E, 
        0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF232323, 0xFF212121, 0xFF202020, 0xFF1E1E1E, 0xFF929292, 0xFFCDCDCD, 0xFF919191, 0xFF1B1B1B, 
        0xFF1A1A1A, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF151515, 0xFF131313, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D0F0F, 0xFFBE0101, 0xFF360D0D, 0xFF111111, 0xFF222222, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF9A9A9A, 0xFFA7A7A7, 0xFFA7A7A7, 0xFFA7A7A7, 
        0xFFA7A7A7, 0xFFA7A7A7, 0xFFA7A7A7, 0xFFA7A7A7, 0x66A6A6A6, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xDDA5A5A5, 0xFFA6A6A6, 0xFFA6A6A6, 0xFFA6A6A6, 0xFFA6A6A6, 0xFFA6A6A6, 0xFFA6A6A6, 
        0xFFA6A6A6, 0xFF878787, 0xFF565656, 0xFF565656, 0xFF4E4E4E, 0xFF3C3C3C, 0xFF3D3D3D, 0xFFA51010, 0xFF7F2020, 0xFF3E3E3E, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF414141, 0xFF424242, 0xFF424242, 0xFF434343, 0xFF424242, 0xFF444444, 0xFF444444, 
        0xFF444444, 0xFF464646, 0xFF454545, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF474747, 0xFF484848, 0xFF484848, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF4C4C4C, 
        0xFF4C4C4C, 0xFF4D4D4D, 0xFFBABABA, 0xFFD6D6D6, 0xFF969696, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4E4E4E, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4D4D4D, 
        0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF494949, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 
        0xFF474747, 0xFF464646, 0xFF464646, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF414141, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 
        0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 
        0xFF2D2D2D, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF232323, 0xFF212121, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF7B7B7B, 0xFFCDCDCD, 0xFFA8A8A8, 0xFF1C1C1C, 0xFF1A1A1A, 
        0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF171717, 0xFF151515, 0xFF141414, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF484848, 0xFF484848, 0xFF262626, 0xFF151515, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF420C0C, 0xFFB20202, 0xFF111111, 0xFF111111, 0xFF383838, 0xFF565656, 0xFF565656, 0xFF6F6F6F, 0xFFA6A6A6, 0xFFA6A6A6, 0xFFA6A6A6, 
        0xFFA6A6A6, 0xFFA6A6A6, 0xFFA6A6A6, 0xFFA6A6A6, 0xEEA5A5A5, 0x11A5A5A5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x66A5A5A5, 0xFFA6A6A6, 0xFFA6A6A6, 0xFFA6A6A6, 0xFFA6A6A6, 0xFFA6A6A6, 0xFFA6A6A6, 0xFFA6A6A6, 
        0xFF979797, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF3D3D3D, 0xFF3B3B3B, 0xFF752323, 0xFFAE0C0C, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF404040, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF434343, 0xFF444444, 
        0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF454545, 0xFF464646, 0xFF484848, 0xFF474747, 0xFF484848, 0xFF484848, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 
        0xFF4B4B4B, 0xFF4C4C4C, 0xFF555555, 0xFFC3C3C3, 0xFFD6D6D6, 0xFF838383, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 
        0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 
        0xFF464646, 0xFF464646, 0xFF464646, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF414141, 0xFF414141, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3C3C3C, 
        0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF383838, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 
        0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF222222, 0xFF222222, 0xFF1F1F1F, 0xFF646464, 0xFFCDCDCD, 0xFFB4B4B4, 0xFF272727, 0xFF1C1C1C, 0xFF1B1B1B, 
        0xFF191919, 0xFF181818, 0xFF171717, 0xFF161616, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF363636, 0xFFB6B6B6, 0xFF7C7C7C, 0xFF505050, 0xFF313131, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF800606, 0xFF740707, 0xFF111111, 0xFF181818, 0xFF4C4C4C, 0xFF575757, 0xFF575757, 0xFF929292, 0xFFA6A6A6, 0xFFA6A6A6, 
        0xFFA6A6A6, 0xFFA6A6A6, 0xFFA6A6A6, 0xFFA6A6A6, 0xFFA6A6A6, 0x88A5A5A5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xDDA4A4A4, 0xFFA5A5A5, 0xFFA5A5A5, 0xFFA5A5A5, 0xFFA5A5A5, 0xFFA5A5A5, 0xFFA5A5A5, 0xFFA5A5A5, 
        0xFF707070, 0xFF575757, 0xFF575757, 0xFF454545, 0xFF3A3A3A, 0xFF4E3232, 0xFFC10303, 0xFF593030, 0xFF3D3D3D, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF404040, 0xFF414141, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF444444, 
        0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF474747, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF494949, 0xFF4A4A4A, 0xFF4B4B4B, 
        0xFF4B4B4B, 0xFF4A4A4A, 0xFF4B4B4B, 0xFF676767, 0xFFCCCCCC, 0xFFD6D6D6, 0xFF707070, 0xFF4C4C4C, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4D4D4D, 0xFF4D4D4D, 
        0xFF4C4C4C, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 
        0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF424242, 0xFF404040, 0xFF404040, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 
        0xFF3B3B3B, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF383838, 0xFF373737, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF333333, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 
        0xFF2D2D2D, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF272727, 0xFF272727, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF222222, 0xFF1F1F1F, 0xFF4D4D4D, 0xFFCDCDCD, 0xFFC0C0C0, 0xFF404040, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF191919, 
        0xFF181818, 0xFF181818, 0xFF151515, 0xFF151515, 0xFF141414, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF4E4E4E, 0xFFBABABA, 0xFFCCCCCC, 0xFFC0C0C0, 0xFF545454, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D0F0F, 0xFFBE0101, 0xFF360D0D, 0xFF111111, 0xFF282828, 0xFF575757, 0xFF575757, 0xFF656565, 0xFF9B9B9B, 0xFFA5A5A5, 
        0xFFA5A5A5, 0xFFA5A5A5, 0xFFA5A5A5, 0xFFA5A5A5, 0xFFA5A5A5, 0xFFA5A5A5, 0x22A4A4A4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x77A3A3A3, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFF919191, 
        0xFF585858, 0xFF585858, 0xFF525252, 0xFF393939, 0xFF3A3A3A, 0xFF9A1313, 0xFF871B1B, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3D3D3D, 0xFF3F3F3F, 0xFF454545, 0xFF424242, 0xFF3F3F3F, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF414141, 0xFF404040, 0xFF424242, 
        0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF454545, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF474747, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF494949, 
        0xFF494949, 0xFF494949, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF6F6F6F, 0xFFD6D6D6, 0xFFCCCCCC, 0xFF676767, 0xFF4D4D4D, 0xFF4C4C4C, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 
        0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF454545, 
        0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 
        0xFF3A3A3A, 0xFF393939, 0xFF373737, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 
        0xFF2C2C2C, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF414141, 0xFFC0C0C0, 0xFFCDCDCD, 0xFF4A4A4A, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF191919, 
        0xFF181818, 0xFF181818, 0xFF161616, 0xFF141414, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF353535, 
        0xFF818181, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF7F7F7F, 0xFF343434, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFFA50303, 0xFF111111, 0xFF111111, 0xFF454545, 0xFF585858, 0xFF585858, 0xFF878787, 0xFFA4A4A4, 
        0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xAAA3A3A3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x11A3A3A3, 0xEEA3A3A3, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFF9A9A9A, 0xFF656565, 
        0xFF595959, 0xFF595959, 0xFF404040, 0xFF393939, 0xFF5F2929, 0xFFB70707, 0xFF3A3A3A, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3C3C3C, 0xFF6D6D6D, 0xFF808080, 0xFF949494, 0xFF676767, 0xFF3E3E3E, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF404040, 0xFF404040, 0xFF414141, 
        0xFF424242, 0xFF424242, 0xFF424242, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF454545, 0xFF464646, 0xFF454545, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF474747, 0xFF474747, 0xFF474747, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 
        0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF828282, 0xFFD6D6D6, 0xFFC3C3C3, 0xFF545454, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF494949, 0xFF494949, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4A4A4A, 0xFF494949, 0xFF4A4A4A, 0xFF4B4B4B, 
        0xFF4B4B4B, 0xFF4B4B4B, 0xFF494949, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 
        0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF424242, 0xFF414141, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF393939, 
        0xFF393939, 0xFF393939, 0xFF373737, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 
        0xFF292929, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF2C2C2C, 0xFFB5B5B5, 0xFFCDCDCD, 0xFF636363, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 
        0xFF171717, 0xFF161616, 0xFF151515, 0xFF131313, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF232323, 0xFF676767, 0xFFCCCCCC, 
        0xFFCCCCCC, 0xFFA1A1A1, 0xFF454545, 0xFF111111, 0xFF111111, 0xFF1E1E1E, 0xFF222222, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF990404, 0xFF670909, 0xFF111111, 0xFF1F1F1F, 0xFF595959, 0xFF595959, 0xFF595959, 0xFF989898, 
        0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0x33A3A3A3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x88A2A2A2, 0xFFA3A3A3, 0xFFA3A3A3, 0xFFA3A3A3, 0xFFA3A3A3, 0xFFA3A3A3, 0xFFA3A3A3, 0xFFA3A3A3, 0xFF8B8B8B, 0xFF5A5A5A, 
        0xFF5A5A5A, 0xFF505050, 0xFF373737, 0xFF393939, 0xFFB70707, 0xFF692525, 0xFF393939, 0xFF3A3A3A, 0xFF3B3B3B, 0xFF616161, 0xFFB9B9B9, 0xFFC5C5C5, 0xFFCECECE, 0xFFD0D0D0, 0xFF9F9F9F, 0xFF5C5C5C, 0xFF3E3E3E, 0xFF3F3F3F, 0xFF404040, 0xFF404040, 
        0xFF414141, 0xFF424242, 0xFF424242, 0xFF434343, 0xFF424242, 0xFF444444, 0xFF434343, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF454545, 0xFF464646, 0xFF454545, 0xFF454545, 0xFF464646, 0xFF464646, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF464646, 
        0xFF484848, 0xFF494949, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF494949, 0xFF939393, 0xFFD6D6D6, 0xFFB0B0B0, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF484848, 0xFF4A4A4A, 
        0xFF494949, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 
        0xFF444444, 0xFF434343, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF393939, 0xFF393939, 0xFF393939, 
        0xFF393939, 0xFF393939, 0xFF373737, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF333333, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2A2A2A, 
        0xFF292929, 0xFF292929, 0xFF282828, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF222222, 0xFF222222, 0xFF202020, 0xFF9E9E9E, 0xFFCDCDCD, 0xFF7B7B7B, 0xFF1D1D1D, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 
        0xFF151515, 0xFF151515, 0xFF151515, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF535353, 0xFFC5C5C5, 0xFFCCCCCC, 0xFFCCCCCC, 
        0xFF575757, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF515151, 0xFFA5A5A5, 0xFF777777, 0xFF545454, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF360D0D, 0xFFBE0101, 0xFF1D0F0F, 0xFF111111, 0xFF363636, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF818181, 
        0xFFA3A3A3, 0xFFA3A3A3, 0xFFA3A3A3, 0xFFA3A3A3, 0xFFA3A3A3, 0xFFA3A3A3, 0xFFA3A3A3, 0xAAA2A2A2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x11A1A1A1, 0xEEA1A1A1, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFF969696, 0xFF5A5A5A, 0xFF5A5A5A, 
        0xFF5A5A5A, 0xFF3C3C3C, 0xFF363636, 0xFF732222, 0xFFA40F0F, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF3D3D3D, 0xFFABABAB, 0xFFD1D1D1, 0xFF656565, 0xFF5E5E5E, 0xFFA5A5A5, 0xFFD3D3D3, 0xFFD4D4D4, 0xFF878787, 0xFF4F4F4F, 0xFF404040, 0xFF404040, 
        0xFF404040, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF434343, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF464646, 0xFF454545, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 
        0xFF474747, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF474747, 0xFF484848, 0xFF9C9C9C, 0xFF646464, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF494949, 0xFF494949, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 
        0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF424242, 
        0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF383838, 
        0xFF373737, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 
        0xFF282828, 0xFF272727, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF232323, 0xFF212121, 0xFF202020, 0xFF1F1F1F, 0xFF414141, 0xFF868686, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF181818, 0xFF181818, 
        0xFF161616, 0xFF141414, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4E4E4E, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF6C6C6C, 0xFF262626, 
        0xFF111111, 0xFF111111, 0xFF313131, 0xFF5C5C5C, 0xFFB4B4B4, 0xFFCACACA, 0xFFCACACA, 0xFFC2C2C2, 0xFF2F2F2F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF740707, 0xFF800606, 0xFF111111, 0xFF181818, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 
        0xFF939393, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0x33A1A1A1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x88A1A1A1, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFF868686, 0xFF5B5B5B, 0xFF5B5B5B, 
        0xFF4A4A4A, 0xFF353535, 0xFF3F3232, 0xFFC10303, 0xFF542B2B, 0xFF373737, 0xFF383838, 0xFF383838, 0xFF4E4E4E, 0xFFA1A1A1, 0xFFB2B2B2, 0xFF494949, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF6A6A6A, 0xFFC7C7C7, 0xFFD4D4D4, 0xFFD4D4D4, 0xFF717171, 0xFF404040, 
        0xFF3F3F3F, 0xFF404040, 0xFF404040, 0xFF414141, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF747474, 0xFF9A9A9A, 0xFF444444, 0xFF444444, 0xFF454545, 0xFF464646, 0xFF464646, 0xFF464646, 
        0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF484848, 0xFF484848, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF484848, 
        0xFF484848, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF424242, 0xFF424242, 0xFF424242, 
        0xFF424242, 0xFF424242, 0xFF414141, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF363636, 0xFF363636, 
        0xFF363636, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 
        0xFF282828, 0xFF272727, 0xFF272727, 0xFF262626, 0xFF242424, 0xFF242424, 0xFF232323, 0xFF222222, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF151515, 
        0xFF151515, 0xFF151515, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF808080, 0xFF4F4F4F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF131313, 0xFF757575, 0xFF393939, 0xFF111111, 0xFF111111, 
        0xFF313131, 0xFF757575, 0xFF9E9E9E, 0xFF9B9B9B, 0xFF949494, 0xFF3E3E3E, 0xFF707070, 0xFFBABABA, 0xFF585858, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D0F0F, 0xFFBE0101, 0xFF360D0D, 0xFF111111, 0xFF313131, 0xFF5B5B5B, 0xFF5B5B5B, 
        0xFF717171, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xFFA2A2A2, 0xAAA1A1A1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xEEA0A0A0, 0xFFA1A1A1, 0xFFA1A1A1, 0xFFA1A1A1, 0xFFA1A1A1, 0xFFA1A1A1, 0xFFA1A1A1, 0xFF959595, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 
        0xFF393939, 0xFF343434, 0xFF841818, 0xFF8F1515, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF3D3D3D, 0xFF898989, 0xFFC3C3C3, 0xFFB6B6B6, 0xFF626262, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF464646, 0xFF7B7B7B, 0xFFD3D3D3, 0xFFB3B3B3, 0xFF5D5D5D, 
        0xFF3E3E3E, 0xFF3F3F3F, 0xFF404040, 0xFF404040, 0xFF414141, 0xFF404040, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF434343, 0xFFADADAD, 0xFFD5D5D5, 0xFF878787, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF454545, 
        0xFF444444, 0xFF444444, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF454545, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 
        0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF414141, 
        0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF373737, 0xFF363636, 
        0xFF363636, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF333333, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2C2C2C, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF292929, 
        0xFF282828, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF222222, 0xFF222222, 0xFF202020, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1A1A1A, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF151515, 
        0xFF151515, 0xFF141414, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF676767, 0xFFCCCCCC, 0xFFA5A5A5, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1A1A1A, 0xFF616161, 
        0xFFCCCCCC, 0xFFCCCCCC, 0xFFBEBEBE, 0xFFCCCCCC, 0xFF7C7C7C, 0xFF666666, 0xFFCCCCCC, 0xFFAFAFAF, 0xFF434343, 0xFF161616, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF5B0A0A, 0xFF8D0505, 0xFF111111, 0xFF141414, 0xFF515151, 0xFF5C5C5C, 
        0xFF5C5C5C, 0xFF939393, 0xFFA1A1A1, 0xFFA1A1A1, 0xFFA1A1A1, 0xFFA1A1A1, 0xFFA1A1A1, 0xFFA1A1A1, 0xFFA1A1A1, 0x22A0A0A0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x669F9F9F, 0xFFA0A0A0, 0xFFA0A0A0, 0xFFA0A0A0, 0xFFA0A0A0, 0xFFA0A0A0, 0xFFA0A0A0, 0xFFA0A0A0, 0xFF868686, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF464646, 
        0xFF313131, 0xFF472C2C, 0xFFC10303, 0xFF482D2D, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF383838, 0xFF4C4C4C, 0xFF898989, 0xFFD2D2D2, 0xFFD2D2D2, 0xFF979797, 0xFF565656, 0xFF3B3B3B, 0xFF414141, 0xFF757575, 0xFFC5C5C5, 0xFF737373, 
        0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF404040, 0xFF404040, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF434343, 0xFF999999, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 
        0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF444444, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF464646, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF454545, 
        0xFF464646, 0xFF464646, 0xFF454545, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF414141, 0xFF404040, 0xFF404040, 
        0xFF404040, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF383838, 0xFF363636, 0xFF353535, 
        0xFF353535, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF292929, 0xFF292929, 0xFF272727, 
        0xFF272727, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF222222, 0xFF202020, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF181818, 0xFF181818, 0xFF171717, 0xFF141414, 
        0xFF131313, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF747474, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1B1B1B, 0xFF555555, 0xFFAFAFAF, 
        0xFFCCCCCC, 0xFF5D5D5D, 0xFF2C2C2C, 0xFFC0C0C0, 0xFFCCCCCC, 0xFFA7A7A7, 0xFFBEBEBE, 0xFF575757, 0xFF151515, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFB20202, 0xFF420C0C, 0xFF111111, 0xFF2E2E2E, 0xFF5D5D5D, 
        0xFF5D5D5D, 0xFF717171, 0xFFA0A0A0, 0xFFA0A0A0, 0xFFA0A0A0, 0xFFA0A0A0, 0xFFA0A0A0, 0xFFA0A0A0, 0xFFA0A0A0, 0x999F9F9F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xDD9E9E9E, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF949494, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF373737, 
        0xFF313131, 0xFF8E1414, 0xFF841818, 0xFF343434, 0xFF353535, 0xFF353535, 0xFF3C3C3C, 0xFF454545, 0xFF424242, 0xFF393939, 0xFF393939, 0xFF5D5D5D, 0xFFACACAC, 0xFFD2D2D2, 0xFFD2D2D2, 0xFF7F7F7F, 0xFF4D4D4D, 0xFFA8A8A8, 0xFFD3D3D3, 0xFF636363, 
        0xFF3D3D3D, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF404040, 0xFF404040, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF424242, 0xFF434343, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF434343, 
        0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 
        0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 
        0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF383838, 0xFF373737, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF353535, 
        0xFF353535, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF282828, 0xFF262626, 
        0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF191919, 0xFF181818, 0xFF171717, 0xFF141414, 0xFF131313, 
        0xFF131313, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF202020, 0xFF797979, 0xFFCCCCCC, 
        0xFF414141, 0xFF3F3F3F, 0xFF929292, 0xFFBFBFBF, 0xFF7F7F7F, 0xFF444444, 0xFF2A2A2A, 0xFF111111, 0xFF111111, 0xFF1F1F1F, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFF990404, 0xFF111111, 0xFF141414, 0xFF525252, 
        0xFF5D5D5D, 0xFF5D5D5D, 0xFF919191, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xEE9E9E9E, 0x119E9E9E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x559E9E9E, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF868686, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF474747, 0xFF313131, 
        0xFF452A2A, 0xFFC00303, 0xFF3B2D2D, 0xFF323232, 0xFF343434, 0xFF353535, 0xFF767676, 0xFF8B8B8B, 0xFFACACAC, 0xFF565656, 0xFF373737, 0xFF363636, 0xFF383838, 0xFF6C6C6C, 0xFFD2D2D2, 0xFFCBCBCB, 0xFFD2D2D2, 0xFFC4C4C4, 0xFF9E9E9E, 0xFF3C3C3C, 
        0xFF3D3D3D, 0xFF3D3D3D, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF414141, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 
        0xFF444444, 0xFF434343, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 
        0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 
        0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF373737, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF353535, 
        0xFF343434, 0xFF343434, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF272727, 
        0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1B1B1B, 0xFF191919, 0xFF171717, 0xFF161616, 0xFF151515, 0xFF131313, 0xFF131313, 
        0xFF131313, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF616161, 0xFFC5C5C5, 
        0xFFA5A5A5, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF8F8F8F, 0xFF363636, 0xFF111111, 0xFF111111, 0xFF2B2B2B, 0xFF636363, 0xFF747474, 0xFF565656, 0xFF1F1F1F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFB20202, 0xFF420C0C, 0xFF111111, 0xFF2E2E2E, 
        0xFF5E5E5E, 0xFF5E5E5E, 0xFF7A7A7A, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0x779E9E9E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xAA9D9D9D, 0xFF9E9E9E, 0xFF9E9E9E, 0xFF9E9E9E, 0xFF9E9E9E, 0xFF9E9E9E, 0xFF9E9E9E, 0xFF969696, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF373737, 0xFF313131, 
        0xFF8D1313, 0xFF831616, 0xFF313131, 0xFF313131, 0xFF343434, 0xFF646464, 0xFFC8C8C8, 0xFFBDBDBD, 0xFFC5C5C5, 0xFF414141, 0xFF494949, 0xFF4F4F4F, 0xFF373737, 0xFF393939, 0xFF464646, 0xFF757575, 0xFF8C8C8C, 0xFF737373, 0xFF535353, 0xFF3B3B3B, 
        0xFF3B3B3B, 0xFF3B3B3B, 0xFF3D3D3D, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3F3F3F, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 
        0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF444444, 0xFF434343, 0xFF434343, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF424242, 0xFF434343, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF434343, 
        0xFF434343, 0xFF444444, 0xFF434343, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF414141, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 
        0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF373737, 0xFF363636, 0xFF363636, 0xFF343434, 0xFF343434, 0xFF343434, 
        0xFF343434, 0xFF343434, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF272727, 0xFF272727, 0xFF252525, 
        0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF222222, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1C1C1C, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF131313, 0xFF121212, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF212121, 0xFF919191, 
        0xFF949494, 0xFFA7A7A7, 0xFF4E4E4E, 0xFF111111, 0xFF111111, 0xFF171717, 0xFF5C5C5C, 0xFFCCCCCC, 0xFFC0C0C0, 0xFFC4C4C4, 0xFFB3B3B3, 0xFF676767, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFF990404, 0xFF111111, 0xFF141414, 
        0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF929292, 0xFF9E9E9E, 0xFF9E9E9E, 0xFF9E9E9E, 0xFF9E9E9E, 0xFF9E9E9E, 0xFF9E9E9E, 0xDD9D9D9D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x229C9C9C, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF8B8B8B, 0xFF606060, 0xFF606060, 0xFF4A4A4A, 0xFF313131, 0xFF3B2D2D, 
        0xFFC00303, 0xFF452A2A, 0xFF313131, 0xFF313131, 0xFF383838, 0xFFAAAAAA, 0xFFD2D2D2, 0xFF5D5D5D, 0xFF444444, 0xFF5B5B5B, 0xFF959595, 0xFFB7B7B7, 0xFF8E8E8E, 0xFF515151, 0xFF393939, 0xFF393939, 0xFF424242, 0xFF3C3C3C, 0xFF3A3A3A, 0xFF3A3A3A, 
        0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF414141, 0xFF414141, 0xFF414141, 
        0xFF404040, 0xFF404040, 0xFF404040, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF434343, 0xFF434343, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF434343, 0xFF424242, 0xFF424242, 0xFF414141, 
        0xFF414141, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF414141, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 
        0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF383838, 0xFF373737, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF343434, 
        0xFF333333, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 
        0xFF252525, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF161616, 0xFF151515, 0xFF141414, 0xFF131313, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF232323, 
        0xFF333333, 0xFF1C1C1C, 0xFF111111, 0xFF111111, 0xFF4A4A4A, 0xFFABABAB, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF646464, 0xFF3E3E3E, 0xFFCCCCCC, 0xFFB5B5B5, 0xFF2F2F2F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFB20202, 0xFF360D0D, 0xFF111111, 
        0xFF333333, 0xFF606060, 0xFF606060, 0xFF858585, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0x559C9C9C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x889C9C9C, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF6A6A6A, 0xFF606060, 0xFF606060, 0xFF393939, 0xFF2F2F2F, 0xFF821515, 
        0xFF8C1212, 0xFF303030, 0xFF303030, 0xFF313131, 0xFF444444, 0xFF929292, 0xFFB0B0B0, 0xFF494949, 0xFF373737, 0xFFAAAAAA, 0xFFCCCCCC, 0xFFBEBEBE, 0xFFD1D1D1, 0xFFD2D2D2, 0xFF747474, 0xFF3F3F3F, 0xFF393939, 0xFF393939, 0xFF3A3A3A, 0xFF3A3A3A, 
        0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF404040, 
        0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF414141, 0xFF424242, 0xFF414141, 0xFF414141, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF414141, 0xFF404040, 0xFF424242, 0xFF414141, 0xFF404040, 0xFF404040, 
        0xFF404040, 0xFF414141, 0xFF424242, 0xFF414141, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3B3B3B, 
        0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF393939, 0xFF373737, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF323232, 0xFF313131, 
        0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF252525, 0xFF252525, 
        0xFF242424, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF181818, 0xFF161616, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF131313, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF333333, 0xFF818181, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF797979, 0xFF313131, 0xFF111111, 0xFF181818, 0xFF707070, 0xFFA5A5A5, 0xFF444444, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF5B0A0A, 0xFF8D0505, 0xFF111111, 
        0xFF1D1D1D, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF959595, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF9D9D9D, 0xAA9C9C9C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xEE9B9B9B, 0xFF9C9C9C, 0xFF9C9C9C, 0xFF9C9C9C, 0xFF9C9C9C, 0xFF9C9C9C, 0xFF9C9C9C, 0xFF909090, 0xFF616161, 0xFF616161, 0xFF535353, 0xFF2C2C2C, 0xFF2D2D2D, 0xFFC00303, 
        0xFF4D2424, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF313131, 0xFF363636, 0xFF858585, 0xFFC7C7C7, 0xFFC4C4C4, 0xFF7C7C7C, 0xFF949494, 0xFF949494, 0xFF434343, 0xFF6E6E6E, 0xFFD1D1D1, 0xFFB9B9B9, 0xFF5E5E5E, 0xFF3A3A3A, 0xFF373737, 0xFF393939, 0xFF393939, 
        0xFF393939, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3C3C3C, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3F3F3F, 
        0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3F3F3F, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF424242, 0xFF414141, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 
        0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 
        0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF383838, 0xFF363636, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF313131, 0xFF313131, 
        0xFF313131, 0xFF313131, 0xFF313131, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF272727, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF242424, 0xFF242424, 
        0xFF242424, 0xFF222222, 0xFF222222, 0xFF202020, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF151515, 0xFF151515, 0xFF141414, 0xFF131313, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF242424, 0xFF7D7D7D, 0xFFBEBEBE, 0xFF9B9B9B, 0xFF414141, 0xFF111111, 0xFF111111, 0xFF262626, 0xFF6D6D6D, 0xFFC5C5C5, 0xFF8D8D8D, 0xFF2C2C2C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D0F0F, 0xFFBE0101, 0xFF290E0E, 
        0xFF111111, 0xFF393939, 0xFF616161, 0xFF616161, 0xFF8B8B8B, 0xFF9C9C9C, 0xFF9C9C9C, 0xFF9C9C9C, 0xFF9C9C9C, 0xFF9C9C9C, 0xFF9C9C9C, 0xFF9C9C9C, 0x119B9B9B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x549B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF7B7B7B, 0xFF626262, 0xFF626262, 0xFF3D3D3D, 0xFF2B2B2B, 0xFF611D1D, 0xFF960F0F, 
        0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF303030, 0xFF313131, 0xFF414141, 0xFF808080, 0xFFD1D1D1, 0xFFD1D1D1, 0xFFCDCDCD, 0xFF707070, 0xFF383838, 0xFF3C3C3C, 0xFF6E6E6E, 0xFFC4C4C4, 0xFF737373, 0xFF373737, 0xFF363636, 0xFF363636, 0xFF383838, 
        0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3C3C3C, 0xFF3D3D3D, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3E3E3E, 
        0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3F3F3F, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 
        0xFF3E3E3E, 0xFF3E3E3E, 0xFF404040, 0xFF404040, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 
        0xFF313131, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF282828, 0xFF272727, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF272727, 
        0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF232323, 
        0xFF222222, 0xFF212121, 0xFF202020, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1B1B1B, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF181818, 0xFF181818, 0xFF171717, 0xFF151515, 0xFF131313, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF393939, 0xFFA4A4A4, 0xFF898989, 0xFF161616, 0xFF111111, 0xFF111111, 0xFF575757, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFB8B8B8, 0xFF484848, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF740707, 0xFF740707, 
        0xFF111111, 0xFF252525, 0xFF626262, 0xFF626262, 0xFF6B6B6B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0x779A9A9A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xA99B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF929292, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF2C2C2C, 0xFF2B2B2B, 0xFFAB0808, 0xFF611D1D, 
        0xFF2D2D2D, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2F2F2F, 0xFF303030, 0xFF303030, 0xFF313131, 0xFF535353, 0xFF9A9A9A, 0xFFD1D1D1, 0xFFD1D1D1, 0xFF868686, 0xFF555555, 0xFFAEAEAE, 0xFFD2D2D2, 0xFF5B5B5B, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 
        0xFF373737, 0xFF363636, 0xFF393939, 0xFF393939, 0xFF3A3A3A, 0xFF4D4D4D, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 
        0xFF3E3E3E, 0xFF3D3D3D, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 
        0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF363636, 0xFF2F2F2F, 0xFF2C2C2C, 0xFF2B2B2B, 
        0xFF2D2D2D, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF282828, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF222222, 0xFF212121, 
        0xFF202020, 0xFF202020, 0xFF242424, 0xFF2B2B2B, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF232323, 0xFF222222, 
        0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF151515, 0xFF141414, 0xFF141414, 0xFF131313, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF2C2C2C, 0xFFBEBEBE, 0xFFCCCCCC, 0xFF393939, 0xFF484848, 0xFFA1A1A1, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF676767, 0xFF232323, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF290E0E, 0xFFBE0101, 
        0xFF111111, 0xFF111111, 0xFF4E4E4E, 0xFF636363, 0xFF636363, 0xFF8F8F8F, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xDD9A9A9A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x109A9A9A, 0xFF9A9A9A, 0xFF9A9A9A, 0xFF9A9A9A, 0xFF9A9A9A, 0xFF9A9A9A, 0xFF9A9A9A, 0xFF9A9A9A, 0xFF8A8A8A, 0xFF636363, 0xFF636363, 0xFF464646, 0xFF292929, 0xFF492020, 0xFFB50505, 0xFF2B2B2B, 
        0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF303030, 0xFF313131, 0xFF313131, 0xFF616161, 0xFFBCBCBC, 0xFFD1D1D1, 0xFFCDCDCD, 0xFFBFBFBF, 0xFF919191, 0xFF353535, 0xFF353535, 0xFF363636, 0xFF353535, 0xFF363636, 
        0xFF363636, 0xFF363636, 0xFF373737, 0xFF373737, 0xFF4C4C4C, 0xFFD2D2D2, 0xFF9F9F9F, 0xFF4D4D4D, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3C3C3C, 0xFF3D3D3D, 0xFF3D3D3D, 
        0xFF3D3D3D, 0xFF3D3D3D, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 
        0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF323232, 0xFF2C2C2C, 0xFF2F2F2F, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2D2D2D, 
        0xFF2D2D2D, 0xFF2C2C2C, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF282828, 0xFF282828, 0xFF292929, 0xFF282828, 0xFF282828, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF252525, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF222222, 
        0xFF222222, 0xFF212121, 0xFF212121, 0xFF202020, 0xFF212121, 0xFF252525, 0xFF2C2C2C, 0xFF2A2A2A, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF252525, 0xFF242424, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF222222, 
        0xFF202020, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF191919, 0xFF181818, 0xFF171717, 0xFF161616, 0xFF151515, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF8D8D8D, 0xFFCCCCCC, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF616161, 0xFFBCBCBC, 0xFFB1B1B1, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF818181, 0xFF353535, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D0505, 
        0xFF4F0B0B, 0xFF111111, 0xFF2C2C2C, 0xFF636363, 0xFF636363, 0xFF808080, 0xFF9A9A9A, 0xFF9A9A9A, 0xFF9A9A9A, 0xFF9A9A9A, 0xFF9A9A9A, 0xFF9A9A9A, 0xFF9A9A9A, 0x329A9A9A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x54999999, 0xFF999999, 0xFF999999, 0xFF999999, 0xFF999999, 0xFF999999, 0xFF999999, 0xFF999999, 0xFF6D6D6D, 0xFF646464, 0xFF646464, 0xFF343434, 0xFF292929, 0xFF8A1010, 0xFF741515, 0xFF2A2A2A, 
        0xFF2C2C2C, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2F2F2F, 0xFF313131, 0xFF313131, 0xFF393939, 0xFF6D6D6D, 0xFF8F8F8F, 0xFF696969, 0xFF494949, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF353535, 0xFF363636, 
        0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF555555, 0xFFBDBDBD, 0xFFD2D2D2, 0xFFD2D2D2, 0xFF8A8A8A, 0xFF434343, 0xFF393939, 0xFF393939, 0xFF3A3A3A, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3B3B3B, 0xFF3C3C3C, 0xFF3D3D3D, 
        0xFF3C3C3C, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 
        0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF2F2F2F, 0xFF2D2D2D, 0xFF303030, 0xFF2F2F2F, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 
        0xFF2A2A2A, 0xFF2A2A2A, 0xFF2D2D2D, 0xFF303030, 0xFF363636, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF292929, 0xFF272727, 0xFF242424, 0xFF222222, 
        0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF1E1E1E, 0xFF212121, 0xFF292929, 0xFF292929, 0xFF272727, 0xFF272727, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 
        0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF181818, 0xFF181818, 0xFF161616, 0xFF151515, 0xFF151515, 0xFF141414, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D1D1D, 0xFF747474, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFB2B2B2, 0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF1C1C1C, 0xFF686868, 0xFF7E7E7E, 0xFF8F8F8F, 0xFF464646, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 
        0xFFA50303, 0xFF111111, 0xFF191919, 0xFF646464, 0xFF646464, 0xFF646464, 0xFF929292, 0xFF999999, 0xFF999999, 0xFF999999, 0xFF999999, 0xFF999999, 0xFF999999, 0x87999999, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xA9999999, 0xFF999999, 0xFF999999, 0xFF999999, 0xFF999999, 0xFF999999, 0xFF999999, 0xFF8E8E8E, 0xFF656565, 0xFF656565, 0xFF555555, 0xFF282828, 0xFF282828, 0xFFC00202, 0xFF332626, 0xFF292929, 
        0xFF2C2C2C, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF3A3A3A, 0xFF343434, 0xFF313131, 0xFF323232, 0xFF343434, 0xFF333333, 0xFF343434, 0xFF343434, 
        0xFF343434, 0xFF353535, 0xFF353535, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF747474, 0xFFC6C6C6, 0xFFD2D2D2, 0xFFBDBDBD, 0xFF6B6B6B, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3B3B3B, 0xFF3B3B3B, 
        0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3C3C3C, 0xFF3D3D3D, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 
        0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF313131, 0xFF2F2F2F, 0xFF303030, 0xFF303030, 0xFF2F2F2F, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF303030, 
        0xFF363636, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 
        0xFF282828, 0xFF252525, 0xFF202020, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF1F1F1F, 0xFF1D1D1D, 0xFF202020, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF232323, 0xFF222222, 0xFF212121, 0xFF1F1F1F, 0xFF1F1F1F, 
        0xFF1F1F1F, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF171717, 0xFF141414, 0xFF141414, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F4F4F, 0xFFB2B2B2, 0xFFCCCCCC, 0xFFBEBEBE, 0xFF5B5B5B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF151515, 0xFF262626, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFFBE0101, 0xFF290E0E, 0xFF111111, 0xFF404040, 0xFF656565, 0xFF656565, 0xFF8B8B8B, 0xFF999999, 0xFF999999, 0xFF999999, 0xFF999999, 0xFF999999, 0xFF999999, 0xDC999999, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10989898, 0xFF989898, 0xFF989898, 0xFF989898, 0xFF989898, 0xFF989898, 0xFF989898, 0xFF989898, 0xFF848484, 0xFF666666, 0xFF666666, 0xFF3E3E3E, 0xFF262626, 0xFF5D1919, 0xFF940C0C, 0xFF292929, 0xFF292929, 
        0xFF292929, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2C2C2C, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2F2F2F, 0xFF2F2F2F, 0xFF2F2F2F, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF343434, 0xFF343434, 
        0xFF343434, 0xFF343434, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF363636, 0xFF363636, 0xFF414141, 0xFF898989, 0xFFD2D2D2, 0xFFD2D2D2, 0xFFB2B2B2, 0xFF575757, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF393939, 
        0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 
        0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF343434, 0xFF2E2E2E, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2C2C2C, 0xFF303030, 0xFF363636, 0xFF363636, 0xFF363636, 
        0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 
        0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF272727, 0xFF222222, 0xFF212121, 0xFF212121, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF212121, 0xFF252525, 0xFF242424, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF1F1F1F, 0xFF1E1E1E, 
        0xFF1E1E1E, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF171717, 0xFF161616, 0xFF151515, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF363636, 0xFFA5A5A5, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF747474, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF740707, 0xFF740707, 0xFF111111, 0xFF252525, 0xFF666666, 0xFF666666, 0xFF7B7B7B, 0xFF989898, 0xFF989898, 0xFF989898, 0xFF989898, 0xFF989898, 0xFF989898, 0xFF989898, 0x32989898, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x54979797, 0xFF979797, 0xFF979797, 0xFF979797, 0xFF979797, 0xFF979797, 0xFF979797, 0xFF979797, 0xFF6E6E6E, 0xFF666666, 0xFF666666, 0xFF2D2D2D, 0xFF252525, 0xFF940C0C, 0xFF5D1919, 0xFF272727, 0xFF272727, 
        0xFF282828, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF2B2B2B, 0xFF2C2C2C, 0xFF2C2C2C, 0xFF2C2C2C, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF303030, 0xFF2F2F2F, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF333333, 0xFF343434, 
        0xFF333333, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF353535, 0xFF353535, 0xFF363636, 0xFF353535, 0xFF353535, 0xFF555555, 0xFFA7A7A7, 0xFFD2D2D2, 0xFFD2D2D2, 0xFF9E9E9E, 0xFF414141, 0xFF373737, 0xFF383838, 0xFF393939, 0xFF393939, 0xFF393939, 
        0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF393939, 0xFF3B3B3B, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 
        0xFF3A3A3A, 0xFF393939, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF2F2F2F, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF313131, 0xFF303030, 0xFF2C2C2C, 0xFF333333, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF353535, 0xFF353535, 
        0xFF353535, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 
        0xFF2C2C2C, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF252525, 0xFF212121, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1C1C1C, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF202020, 0xFF1E1E1E, 0xFF1D1D1D, 
        0xFF1C1C1C, 0xFF1C1C1C, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF191919, 0xFF181818, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D8D8D, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF999999, 0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF151515, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF919191, 0xFF979797, 0xFF979797, 0xFF979797, 0xFF979797, 0xFF979797, 0xFF979797, 0x87979797, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xA9969696, 0xFF969696, 0xFF969696, 0xFF969696, 0xFF969696, 0xFF969696, 0xFF969696, 0xFF8B8B8B, 0xFF676767, 0xFF676767, 0xFF555555, 0xFF242424, 0xFF2F2222, 0xFFC00202, 0xFF2F2222, 0xFF262626, 0xFF272727, 
        0xFF282828, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2F2F2F, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 
        0xFF313131, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF343434, 0xFF343434, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF363636, 0xFF363636, 0xFF5F5F5F, 0xFFBCBCBC, 0xFFA7A7A7, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF393939, 0xFF383838, 0xFF373737, 
        0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF3A3A3A, 0xFF393939, 0xFF393939, 
        0xFF393939, 0xFF393939, 0xFF393939, 0xFF3A3A3A, 0xFF393939, 0xFF353535, 0xFF2F2F2F, 0xFF333333, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF2D2D2D, 0xFF323232, 0xFF363636, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF343434, 
        0xFF343434, 0xFF333333, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 
        0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF252525, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1B1B1B, 0xFF1F1F1F, 0xFF202020, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1C1C1C, 
        0xFF1C1C1C, 0xFF1C1C1C, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF161616, 0xFF141414, 0xFF131313, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF999999, 0xFFB2B2B2, 0xFF424242, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF3C3C3C, 0xFF676767, 0xFF676767, 0xFF898989, 0xFF969696, 0xFF969696, 0xFF969696, 0xFF969696, 0xFF969696, 0xFF969696, 0xCB969696, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xED969696, 0xFF969696, 0xFF969696, 0xFF969696, 0xFF969696, 0xFF969696, 0xFF969696, 0xFF848484, 0xFF686868, 0xFF686868, 0xFF3D3D3D, 0xFF232323, 0xFF5A1717, 0xFF930B0B, 0xFF252525, 0xFF252525, 0xFF272727, 
        0xFF272727, 0xFF272727, 0xFF292929, 0xFF292929, 0xFF2A2A2A, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF2B2B2B, 0xFF2C2C2C, 0xFF2C2C2C, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF313131, 0xFF313131, 0xFF313131, 
        0xFF313131, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF333333, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF353535, 0xFF494949, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 
        0xFF383838, 0xFF383838, 0xFF383838, 0xFF393939, 0xFF383838, 0xFF373737, 0xFF373737, 0xFF393939, 0xFF393939, 0xFF383838, 0xFF373737, 0xFF363636, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF383838, 0xFF373737, 0xFF383838, 0xFF393939, 0xFF393939, 
        0xFF393939, 0xFF383838, 0xFF383838, 0xFF393939, 0xFF323232, 0xFF303030, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF2E2E2E, 0xFF303030, 0xFF363636, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF333333, 
        0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2A2A2A, 
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF212121, 0xFF1E1E1E, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1D1D1D, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1C1C1C, 
        0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF171717, 0xFF161616, 0xFF151515, 0xFF131313, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF740707, 0xFF740707, 0xFF111111, 0xFF262626, 0xFF686868, 0xFF686868, 0xFF7B7B7B, 0xFF969696, 0xFF969696, 0xFF969696, 0xFF969696, 0xFF969696, 0xFF969696, 0xFF969696, 0x10969696, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x32959595, 0xFF959595, 0xFF959595, 0xFF959595, 0xFF959595, 0xFF959595, 0xFF959595, 0xFF959595, 0xFF6F6F6F, 0xFF686868, 0xFF686868, 0xFF2A2A2A, 0xFF222222, 0xFF920B0B, 0xFF5B1717, 0xFF252525, 0xFF252525, 0xFF252525, 
        0xFF252525, 0xFF272727, 0xFF282828, 0xFF282828, 0xFF282828, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF2B2B2B, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF303030, 0xFF2F2F2F, 0xFF303030, 
        0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF323232, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF353535, 0xFF353535, 0xFF363636, 0xFF363636, 0xFF363636, 
        0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF373737, 0xFF373737, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF373737, 0xFF383838, 0xFF373737, 0xFF363636, 0xFF363636, 0xFF373737, 0xFF383838, 0xFF373737, 
        0xFF363636, 0xFF363636, 0xFF363636, 0xFF2F2F2F, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF2D2D2D, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF323232, 0xFF313131, 0xFF313131, 
        0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF292929, 0xFF292929, 0xFF292929, 
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF272727, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF232323, 0xFF222222, 0xFF1D1D1D, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1A1A1A, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1B1B1B, 
        0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF151515, 0xFF686868, 0xFF686868, 0xFF686868, 0xFF909090, 0xFF959595, 0xFF959595, 0xFF959595, 0xFF959595, 0xFF959595, 0xFF959595, 0x65959595, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x87949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF8D8D8D, 0xFF696969, 0xFF696969, 0xFF5E5E5E, 0xFF1F1F1F, 0xFF2C1E1E, 0xFFBF0202, 0xFF2E2020, 0xFF242424, 0xFF242424, 0xFF252525, 
        0xFF252525, 0xFF252525, 0xFF262626, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2C2C2C, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 
        0xFF313131, 0xFF303030, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF333333, 0xFF333333, 0xFF333333, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF343434, 
        0xFF353535, 0xFF353535, 0xFF353535, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 
        0xFF353535, 0xFF353535, 0xFF2E2E2E, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF323232, 0xFF2E2E2E, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 
        0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF292929, 
        0xFF282828, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF222222, 0xFF202020, 0xFF1F1F1F, 0xFF1C1C1C, 0xFF1D1D1D, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF191919, 0xFF1C1C1C, 0xFF1C1C1C, 
        0xFF191919, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF161616, 0xFF141414, 0xFF141414, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF434343, 0xFF696969, 0xFF696969, 0xFF8A8A8A, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xA9949494, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xBA949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF878787, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF3F3F3F, 0xFF1F1F1F, 0xFF581515, 0xFF9E0909, 0xFF222222, 0xFF242424, 0xFF242424, 0xFF242424, 
        0xFF252525, 0xFF252525, 0xFF252525, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF282828, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 
        0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF303030, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF343434, 0xFF333333, 0xFF323232, 0xFF313131, 0xFF333333, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 
        0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF363636, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF363636, 0xFF363636, 0xFF353535, 0xFF353535, 0xFF363636, 0xFF353535, 0xFF353535, 
        0xFF353535, 0xFF2E2E2E, 0xFF353535, 0xFF353535, 0xFF363636, 0xFF303030, 0xFF313131, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 
        0xFF313131, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF282828, 0xFF272727, 0xFF272727, 
        0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF252525, 0xFF242424, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1B1B1B, 0xFF1B1B1B, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1C1C1C, 0xFF181818, 0xFF1A1A1A, 
        0xFF191919, 0xFF181818, 0xFF181818, 0xFF171717, 0xFF161616, 0xFF141414, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF800606, 0xFF670909, 0xFF111111, 0xFF2E2E2E, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF838383, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xFF949494, 0xED949494, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xFF939393, 0xFF939393, 0xFF939393, 0xFF939393, 0xFF939393, 0xFF939393, 0xFF939393, 0xFF7C7C7C, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF313131, 0xFF1F1F1F, 0xFF860C0C, 0xFF6F1111, 0xFF202020, 0xFF212121, 0xFF222222, 0xFF222222, 
        0xFF232323, 0xFF242424, 0xFF252525, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF272727, 0xFF272727, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2C2C2C, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 
        0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2F2F2F, 0xFF303030, 0xFF2F2F2F, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF323232, 0xFF343434, 0xFF333333, 0xFF323232, 
        0xFF323232, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF353535, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF353535, 0xFF353535, 0xFF343434, 
        0xFF2E2E2E, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF313131, 0xFF313131, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 
        0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 
        0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF202020, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1B1B1B, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1D1D1D, 0xFF181818, 
        0xFF191919, 0xFF181818, 0xFF181818, 0xFF151515, 0xFF141414, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1E1E1E, 0xFF363636, 0xFF3E3E3E, 0xFF1F1F1F, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF420C0C, 0xFF990404, 0xFF111111, 0xFF1F1F1F, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF717171, 0xFF939393, 0xFF939393, 0xFF939393, 0xFF939393, 0xFF939393, 0xFF939393, 0xFF939393, 0x32939393, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x43929292, 0xFF929292, 0xFF929292, 0xFF929292, 0xFF929292, 0xFF929292, 0xFF929292, 0xFF8D8D8D, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF212121, 0xFF1E1E1E, 0xFFB40303, 0xFF401717, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF202020, 0xFF222222, 
        0xFF222222, 0xFF232323, 0xFF232323, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF282828, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF4D4D4D, 
        0xFF4D4D4D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF303030, 0xFF303030, 0xFF303030, 0xFF313131, 0xFF303030, 0xFF303030, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF323232, 0xFF313131, 0xFF313131, 
        0xFF313131, 0xFF333333, 0xFF333333, 0xFF323232, 0xFF333333, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF333333, 0xFF343434, 0xFF333333, 0xFF333333, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF343434, 0xFF333333, 0xFF343434, 0xFF343434, 0xFF2E2E2E, 
        0xFF373737, 0xFF373737, 0xFF373737, 0xFF2E2E2E, 0xFF323232, 0xFF333333, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2E2E2E, 
        0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF262626, 0xFF252525, 
        0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF222222, 0xFF212121, 0xFF202020, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1A1A1A, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 
        0xFF171717, 0xFF171717, 0xFF161616, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF363636, 
        0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF131313, 0xFF202020, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF949494, 0xFFCCCCCC, 0xFFA0A0A0, 0xFF6A6A6A, 0xFF282828, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFFCC0000, 0xFF1D0F0F, 0xFF111111, 0xFF545454, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF8B8B8B, 0xFF929292, 0xFF929292, 0xFF929292, 0xFF929292, 0xFF929292, 0xFF929292, 0x65929292, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x76929292, 0xFF929292, 0xFF929292, 0xFF929292, 0xFF929292, 0xFF929292, 0xFF929292, 0xFF8A8A8A, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF505050, 0xFF1D1D1D, 0xFF341919, 0xFFBF0101, 0xFF1E1E1E, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF222222, 
        0xFF222222, 0xFF222222, 0xFF222222, 0xFF242424, 0xFF252525, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF262626, 0xFF272727, 0xFF272727, 0xFF282828, 0xFF292929, 0xFF282828, 0xFF292929, 0xFF292929, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF989898, 
        0xFFCFCFCF, 0xFF989898, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF313131, 0xFF303030, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 
        0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF323232, 0xFF333333, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF333333, 0xFF333333, 0xFF323232, 0xFF313131, 0xFF313131, 0xFF323232, 0xFF2F2F2F, 0xFF383838, 
        0xFF373737, 0xFF363636, 0xFF2F2F2F, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 
        0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF252525, 0xFF242424, 
        0xFF242424, 0xFF242424, 0xFF242424, 0xFF232323, 0xFF232323, 0xFF202020, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1E1E1E, 0xFF1C1C1C, 
        0xFF1B1B1B, 0xFF141414, 0xFF151515, 0xFF141414, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D8D8D, 0xFFCCCCCC, 
        0xFF8D8D8D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF636363, 0xFF949494, 0xFF6A6A6A, 0xFF494949, 0xFF363636, 0xFF1C1C1C, 0xFF111111, 0xFF686868, 0xFF868686, 0xFF9B9B9B, 0xFFBCBCBC, 0xFF464646, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF990404, 0xFF420C0C, 0xFF111111, 0xFF393939, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF878787, 0xFF929292, 0xFF929292, 0xFF929292, 0xFF929292, 0xFF929292, 0xFF929292, 0xA9929292, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0xBA919191, 0xFF919191, 0xFF919191, 0xFF919191, 0xFF919191, 0xFF919191, 0xFF919191, 0xFF868686, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF3A3A3A, 0xFF1C1C1C, 0xFF621010, 0xFF910909, 0xFF1D1D1D, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF212121, 
        0xFF222222, 0xFF222222, 0xFF222222, 0xFF232323, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF262626, 0xFF272727, 0xFF272727, 0xFF282828, 0xFF292929, 0xFF292929, 0xFF2A2A2A, 0xFF2B2B2B, 0xFF4B4B4B, 
        0xFF828282, 0xFF565656, 0xFF2C2C2C, 0xFF2C2C2C, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF303030, 0xFF313131, 0xFF303030, 0xFF303030, 0xFF313131, 0xFF313131, 
        0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2F2F2F, 0xFF333333, 0xFF383838, 
        0xFF373737, 0xFF323232, 0xFF2E2E2E, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 
        0xFF2C2C2C, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF242424, 
        0xFF242424, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF191919, 0xFF191919, 0xFF181818, 0xFF191919, 0xFF1D1D1D, 
        0xFF1D1D1D, 0xFF1A1A1A, 0xFF131313, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF424242, 0xFF808080, 
        0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF616161, 0xFFCCCCCC, 0xFFB8B8B8, 0xFFA1A1A1, 0xFF8C8C8C, 0xFF707070, 0xFF545454, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF6B6B6B, 0xFFB6B6B6, 0xFF545454, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF670909, 0xFF740707, 0xFF111111, 0xFF2C2C2C, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF808080, 0xFF919191, 0xFF919191, 0xFF919191, 0xFF919191, 0xFF919191, 0xFF919191, 0xDC919191, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0xED909090, 0xFF909090, 0xFF909090, 0xFF909090, 0xFF909090, 0xFF909090, 0xFF909090, 0xFF7F7F7F, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF2E2E2E, 0xFF1B1B1B, 0xFF840A0A, 0xFF621010, 0xFF1C1C1C, 0xFF1D1D1D, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1F1F1F, 
        0xFF1F1F1F, 0xFF202020, 0xFF222222, 0xFF222222, 0xFF232323, 0xFF242424, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF282828, 0xFF292929, 0xFF2B2B2B, 0xFF2A2A2A, 
        0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF2A2A2A, 0xFF2C2C2C, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2C2C2C, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF313131, 0xFF303030, 
        0xFF313131, 0xFF313131, 0xFF303030, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF2D2D2D, 0xFF383838, 0xFF383838, 
        0xFF353535, 0xFF2C2C2C, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2F2F2F, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2C2C2C, 0xFF2B2B2B, 
        0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF222222, 
        0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF161616, 0xFF1A1A1A, 
        0xFF1C1C1C, 0xFF1C1C1C, 0xFF181818, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4A4A4A, 0xFFCCCCCC, 0xFF898989, 0xFF535353, 0xFF6D6D6D, 0xFF939393, 0xFFB6B6B6, 0xFFB8B8B8, 0xFF9C9C9C, 0xFFA1A1A1, 0xFF7E7E7E, 0xFF333333, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF420C0C, 0xFFA50303, 0xFF111111, 0xFF202020, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF727272, 0xFF909090, 0xFF909090, 0xFF909090, 0xFF909090, 0xFF909090, 0xFF909090, 0xFF909090, 0x10909090, 0x00000000, 0x00000000,
  0x00000000, 0x21909090, 0xFF909090, 0xFF909090, 0xFF909090, 0xFF909090, 0xFF909090, 0xFF909090, 0xFF909090, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF1D1D1D, 0xFF1A1A1A, 0xFFB30303, 0xFF3E1515, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1E1E1E, 
        0xFF1F1F1F, 0xFF1F1F1F, 0xFF202020, 0xFF1F1F1F, 0xFF212121, 0xFF222222, 0xFF222222, 0xFF232323, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF292929, 0xFF282828, 
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 
        0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2F2F2F, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF313131, 0xFF313131, 0xFF313131, 0xFF303030, 0xFF2F2F2F, 0xFF303030, 0xFF303030, 0xFF2F2F2F, 0xFF2B2B2B, 0xFF373737, 0xFF383838, 0xFF3A3A3A, 
        0xFF2C2C2C, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2F2F2F, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 
        0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF222222, 
        0xFF222222, 0xFF212121, 0xFF202020, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF171717, 0xFF151515, 0xFF151515, 0xFF151515, 
        0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF343434, 0xFFCCCCCC, 0xFF898989, 0xFF111111, 0xFF222222, 0xFF373737, 0xFF4C4C4C, 0xFF747474, 0xFF848484, 0xFF686868, 0xFF3D3D3D, 0xFF151515, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFCC0000, 0xFF111111, 0xFF111111, 0xFF616161, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF8B8B8B, 0xFF909090, 0xFF909090, 0xFF909090, 0xFF909090, 0xFF909090, 0xFF909090, 0x43909090, 0x00000000, 0x00000000,
  0x00000000, 0x548F8F8F, 0xFF8F8F8F, 0xFF8F8F8F, 0xFF8F8F8F, 0xFF8F8F8F, 0xFF8F8F8F, 0xFF8F8F8F, 0xFF898989, 0xFF6F6F6F, 0xFF6F6F6F, 0xFF585858, 0xFF181818, 0xFF251818, 0xFFBF0101, 0xFF1A1A1A, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF232323, 0xFF505050, 
        0xFF515151, 0xFF404040, 0xFF2B2B2B, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF202020, 0xFF222222, 0xFF222222, 0xFF232323, 0xFF222222, 0xFF242424, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF262626, 0xFF272727, 0xFF272727, 
        0xFF282828, 0xFF292929, 0xFF282828, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2C2C2C, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 
        0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2F2F2F, 0xFF2F2F2F, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2C2C2C, 0xFF353535, 0xFF393939, 0xFF393939, 0xFF2D2D2D, 
        0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF232323, 0xFF212121, 
        0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF181818, 0xFF161616, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF141414, 
        0xFF161616, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1C1C1C, 0xFFCCCCCC, 0xFF969696, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF171717, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFA50303, 0xFF420C0C, 0xFF111111, 0xFF474747, 0xFF6F6F6F, 0xFF6F6F6F, 0xFF878787, 0xFF8F8F8F, 0xFF8F8F8F, 0xFF8F8F8F, 0xFF8F8F8F, 0xFF8F8F8F, 0xFF8F8F8F, 0x768F8F8F, 0x00000000, 0x00000000,
  0x00000000, 0x878E8E8E, 0xFF8E8E8E, 0xFF8E8E8E, 0xFF8E8E8E, 0xFF8E8E8E, 0xFF8E8E8E, 0xFF8E8E8E, 0xFF868686, 0xFF707070, 0xFF707070, 0xFF434343, 0xFF161616, 0xFF461010, 0xFF9B0606, 0xFF1A1A1A, 0xFF1B1B1B, 0xFF1B1B1B, 0xFF2E2E2E, 0xFF6A6A6A, 0xFFA5A5A5, 
        0xFFBEBEBE, 0xFFCDCDCD, 0xFFCDCDCD, 0xFFABABAB, 0xFF828282, 0xFF656565, 0xFF4F4F4F, 0xFF343434, 0xFF222222, 0xFF222222, 0xFF232323, 0xFF232323, 0xFF232323, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF272727, 
        0xFF262626, 0xFF272727, 0xFF272727, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF292929, 0xFF292929, 0xFF2A2A2A, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2C2C2C, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2D2D2D, 0xFF2D2D2D, 
        0xFF2C2C2C, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2E2E2E, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF393939, 0xFF393939, 0xFF323232, 0xFF2D2D2D, 
        0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 
        0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF212121, 
        0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF191919, 0xFF191919, 0xFF181818, 0xFF171717, 0xFF151515, 0xFF151515, 0xFF141414, 0xFF141414, 0xFF131313, 0xFF121212, 
        0xFF111111, 0xFF171717, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF191919, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF191919, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF3C3C3C, 0xFF464646, 0xFF292929, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF800606, 0xFF670909, 0xFF111111, 0xFF363636, 0xFF707070, 0xFF707070, 0xFF848484, 0xFF8E8E8E, 0xFF8E8E8E, 0xFF8E8E8E, 0xFF8E8E8E, 0xFF8E8E8E, 0xFF8E8E8E, 0xA98E8E8E, 0x00000000, 0x00000000,
  0x00000000, 0xA98D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF848484, 0xFF717171, 0xFF717171, 0xFF333333, 0xFF151515, 0xFF6A0B0B, 0xFF770B0B, 0xFF191919, 0xFF181818, 0xFF191919, 0xFF474747, 0xFFADADAD, 0xFF919191, 
        0xFF6C6C6C, 0xFF898989, 0xFFB6B6B6, 0xFFCDCDCD, 0xFFCDCDCD, 0xFFCDCDCD, 0xFFBDBDBD, 0xFF747474, 0xFF282828, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF242424, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 
        0xFF252525, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF282828, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF2A2A2A, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF2B2B2B, 0xFF2B2B2B, 
        0xFF2B2B2B, 0xFF2C2C2C, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2C2C2C, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2B2B2B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF2B2B2B, 0xFF2C2C2C, 
        0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF282828, 
        0xFF272727, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF202020, 
        0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF171717, 0xFF151515, 0xFF151515, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF101010, 0xFF212121, 0xFF212121, 0xFF212121, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF171717, 0xFF323232, 0xFF4D4D4D, 0xFF676767, 0xFF8A8A8A, 0xFFBEBEBE, 0xFFCCCCCC, 0xFFBFBFBF, 0xFFA9A9A9, 0xFF737373, 0xFF3A3A3A, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF5B0A0A, 0xFF8D0505, 0xFF111111, 0xFF292929, 0xFF717171, 0xFF717171, 0xFF7F7F7F, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xDC8D8D8D, 0x00000000, 0x00000000,
  0x00000000, 0xDC8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF7F7F7F, 0xFF717171, 0xFF717171, 0xFF2A2A2A, 0xFF151515, 0xFF8E0606, 0xFF510D0D, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF606060, 0xFFC7C7C7, 0xFF5E5E5E, 
        0xFF1F1F1F, 0xFF1B1B1B, 0xFF1C1C1C, 0xFF2F2F2F, 0xFF454545, 0xFF5E5E5E, 0xFF979797, 0xFFAFAFAF, 0xFF575757, 0xFF202020, 0xFF1F1F1F, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF232323, 0xFF222222, 0xFF232323, 0xFF242424, 0xFF252525, 0xFF252525, 
        0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF282828, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF2B2B2B, 
        0xFF2A2A2A, 0xFF292929, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2C2C2C, 0xFF2D2D2D, 0xFF323232, 0xFF3C3C3C, 0xFF3B3B3B, 0xFF2E2E2E, 0xFF2B2B2B, 0xFF2B2B2B, 
        0xFF2D2D2D, 0xFF2C2C2C, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF2A2A2A, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF262626, 
        0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF202020, 0xFF1F1F1F, 0xFF1E1E1E, 
        0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF181818, 0xFF171717, 0xFF161616, 0xFF151515, 0xFF151515, 0xFF141414, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF161616, 0xFF232323, 0xFF232323, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF141414, 0xFF4A4A4A, 0xFF989898, 0xFFC2C2C2, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFA0A0A0, 0xFF797979, 0xFF818181, 0xFFBCBCBC, 0xFF656565, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF1B1B1B, 0xFF717171, 0xFF717171, 0xFF757575, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF8D8D8D, 0x00000000, 0x00000000,
  0x00000000, 0xFF8C8C8C, 0xFF8C8C8C, 0xFF8C8C8C, 0xFF8C8C8C, 0xFF8C8C8C, 0xFF8C8C8C, 0xFF8C8C8C, 0xFF757575, 0xFF727272, 0xFF727272, 0xFF1D1D1D, 0xFF141414, 0xFFB20202, 0xFF380F0F, 0xFF171717, 0xFF181818, 0xFF181818, 0xFF606060, 0xFFB7B7B7, 0xFF808080, 
        0xFF4E4E4E, 0xFF353535, 0xFF1F1F1F, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF232323, 0xFF707070, 0xFFCDCDCD, 0xFF555555, 0xFF1E1E1E, 0xFF1F1F1F, 0xFF202020, 0xFF202020, 0xFF202020, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF232323, 0xFF232323, 0xFF242424, 
        0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF262626, 0xFF262626, 0xFF252525, 0xFF262626, 0xFF272727, 0xFF272727, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF2A2A2A, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF2B2B2B, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF2A2A2A, 0xFF2B2B2B, 0xFF2B2B2B, 
        0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF2B2B2B, 0xFF2A2A2A, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 
        0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF232323, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF202020, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 
        0xFF1E1E1E, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF171717, 0xFF151515, 0xFF141414, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF101010, 0xFF1F1F1F, 0xFF242424, 0xFF242424, 0xFF151515, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF333333, 0xFF959595, 0xFFAFAFAF, 0xFF656565, 0xFF494949, 0xFF333333, 0xFF1A1A1A, 0xFF111111, 0xFF141414, 0xFF3B3B3B, 0xFFC7C7C7, 0xFF838383, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFCC0000, 0xFF111111, 0xFF111111, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF888888, 0xFF8C8C8C, 0xFF8C8C8C, 0xFF8C8C8C, 0xFF8C8C8C, 0xFF8C8C8C, 0xFF8C8C8C, 0x328C8C8C, 0x00000000,
  0x328B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF878787, 0xFF737373, 0xFF737373, 0xFF737373, 0xFF111111, 0xFF121212, 0xFFCC0000, 0xFF141414, 0xFF151515, 0xFF161616, 0xFF151515, 0xFF2A2A2A, 0xFF818181, 0xFFB8B8B8, 
        0xFFCACACA, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF9A9A9A, 0xFF757575, 0xFF5D5D5D, 0xFF9C9C9C, 0xFFC0C0C0, 0xFF3F3F3F, 0xFF1D1D1D, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF212121, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF232323, 
        0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF262626, 0xFF252525, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF282828, 0xFF282828, 0xFF272727, 
        0xFF282828, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF2F2F2F, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF2D2D2D, 0xFF292929, 0xFF292929, 0xFF292929, 
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF282828, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 
        0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF202020, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 
        0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF191919, 0xFF181818, 0xFF171717, 0xFF151515, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF161616, 0xFF262626, 0xFF262626, 0xFF1E1E1E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF2C2C2C, 0xFFCCCCCC, 0xFF9B9B9B, 0xFF1C1C1C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1F1F1F, 0xFF373737, 0xFF555555, 0xFFC7C7C7, 0xFF777777, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF515151, 0xFF737373, 0xFF737373, 0xFF868686, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0x548B8B8B, 0x00000000,
  0x438B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF868686, 0xFF747474, 0xFF747474, 0xFF5B5B5B, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF131313, 0xFF151515, 0xFF151515, 0xFF171717, 0xFF363636, 0xFF525252, 
        0xFF707070, 0xFF959595, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFC0C0C0, 0xFFA9A9A9, 0xFF757575, 0xFF252525, 0xFF1C1C1C, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF212121, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 
        0xFF222222, 0xFF232323, 0xFF222222, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF232323, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF262626, 0xFF262626, 0xFF252525, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF272727, 0xFF272727, 
        0xFF272727, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF292929, 0xFF292929, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF282828, 0xFF292929, 0xFF272727, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3D3D3D, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF292929, 
        0xFF292929, 0xFF282828, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF282828, 0xFF282828, 0xFF282828, 0xFF272727, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF242424, 
        0xFF242424, 0xFF242424, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF202020, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 
        0xFF1C1C1C, 0xFF1B1B1B, 0xFF191919, 0xFF191919, 0xFF181818, 0xFF171717, 0xFF161616, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF131313, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF101010, 0xFF232323, 0xFF282828, 0xFF282828, 0xFF151515, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFC5C5C5, 0xFFCCCCCC, 0xFF525252, 0xFF5E5E5E, 0xFF7D7D7D, 0xFFA9A9A9, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFBFBFBF, 0xFF919191, 0xFF393939, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D0505, 0xFF4F0B0B, 0xFF111111, 0xFF434343, 0xFF747474, 0xFF747474, 0xFF858585, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF8B8B8B, 0x768B8B8B, 0x00000000,
  0x658A8A8A, 0xFF8A8A8A, 0xFF8A8A8A, 0xFF8A8A8A, 0xFF8A8A8A, 0xFF8A8A8A, 0xFF8A8A8A, 0xFF858585, 0xFF747474, 0xFF747474, 0xFF434343, 0xFF111111, 0xFF4F0B0B, 0xFF8D0505, 0xFF111111, 0xFF121212, 0xFF131313, 0xFF131313, 0xFF141414, 0xFF151515, 0xFF151515, 
        0xFF151515, 0xFF151515, 0xFF191919, 0xFF333333, 0xFF484848, 0xFF585858, 0xFF505050, 0xFF222222, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1D1D1D, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF202020, 0xFF1F1F1F, 
        0xFF1F1F1F, 0xFF222222, 0xFF222222, 0xFF232323, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF232323, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF272727, 0xFF262626, 
        0xFF252525, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF2A2A2A, 0xFF3B3B3B, 0xFF3D3D3D, 0xFF2D2D2D, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 
        0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF272727, 0xFF262626, 0xFF262626, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF232323, 
        0xFF232323, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF202020, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 
        0xFF1B1B1B, 0xFF1A1A1A, 0xFF171717, 0xFF161616, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF141414, 0xFF141414, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF181818, 0xFF292929, 0xFF292929, 0xFF1B1B1B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF626262, 0xFFA2A2A2, 0xFFC2C2C2, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFB3B3B3, 0xFF838383, 0xFF5E5E5E, 0xFF3C3C3C, 0xFF1A1A1A, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF740707, 0xFF670909, 0xFF111111, 0xFF373737, 0xFF747474, 0xFF747474, 0xFF828282, 0xFF8A8A8A, 0xFF8A8A8A, 0xFF8A8A8A, 0xFF8A8A8A, 0xFF8A8A8A, 0xFF8A8A8A, 0x988A8A8A, 0x00000000,
  0x87898989, 0xFF898989, 0xFF898989, 0xFF898989, 0xFF898989, 0xFF898989, 0xFF898989, 0xFF828282, 0xFF757575, 0xFF757575, 0xFF373737, 0xFF111111, 0xFF670909, 0xFF740707, 0xFF111111, 0xFF111111, 0xFF121212, 0xFF4F4F4F, 0xFF979797, 0xFF717171, 0xFF575757, 
        0xFF424242, 0xFF2A2A2A, 0xFF171717, 0xFF3B3B3B, 0xFF6B6B6B, 0xFF434343, 0xFF191919, 0xFF191919, 0xFF1B1B1B, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1D1D1D, 0xFFA8A8A8, 0xFF929292, 0xFF7B7B7B, 0xFF595959, 
        0xFF353535, 0xFF202020, 0xFF1F1F1F, 0xFF202020, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF242424, 0xFF232323, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF252525, 0xFF252525, 
        0xFF252525, 0xFF252525, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF272727, 0xFF272727, 0xFF262626, 0xFF272727, 0xFF272727, 0xFF262626, 0xFF383838, 0xFF3D3D3D, 0xFF3E3E3E, 0xFF292929, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF262626, 
        0xFF272727, 0xFF272727, 0xFF262626, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF232323, 0xFF232323, 0xFF222222, 0xFF222222, 
        0xFF222222, 0xFF222222, 0xFF212121, 0xFF202020, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 
        0xFF191919, 0xFF181818, 0xFF161616, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF141414, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF121212, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF2B2B2B, 0xFF101010, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 
        0xFF4F4F4F, 0xFF747474, 0xFF8D8D8D, 0xFFA5A5A5, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF161616, 0xFF484848, 0xFF616161, 0xFF515151, 0xFF3B3B3B, 0xFF242424, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF5B0A0A, 0xFF800606, 0xFF111111, 0xFF292929, 0xFF757575, 0xFF757575, 0xFF808080, 0xFF898989, 0xFF898989, 0xFF898989, 0xFF898989, 0xFF898989, 0xFF898989, 0xA9898989, 0x00000000,
  0xA9898989, 0xFF898989, 0xFF898989, 0xFF898989, 0xFF898989, 0xFF898989, 0xFF898989, 0xFF828282, 0xFF767676, 0xFF767676, 0xFF2E2E2E, 0xFF111111, 0xFF740707, 0xFF670909, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF676767, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 
        0xFFCBCBCB, 0xFFCBCBCB, 0xFFB9B9B9, 0xFFA6A6A6, 0xFFCBCBCB, 0xFF7F7F7F, 0xFF3B3B3B, 0xFF1F1F1F, 0xFF1A1A1A, 0xFF1B1B1B, 0xFF1B1B1B, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF272727, 0xFFB4B4B4, 0xFFCDCDCD, 0xFFCDCDCD, 0xFFCDCDCD, 
        0xFFCDCDCD, 0xFFC0C0C0, 0xFFA9A9A9, 0xFF868686, 0xFF656565, 0xFF424242, 0xFF212121, 0xFF212121, 0xFF1F1F1F, 0xFF212121, 0xFF222222, 0xFF232323, 0xFF242424, 0xFF232323, 0xFF232323, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF252525, 
        0xFF242424, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF262626, 0xFF3F3F3F, 0xFF3E3E3E, 0xFF393939, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF252525, 
        0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 
        0xFF202020, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF181818, 
        0xFF181818, 0xFF181818, 0xFF171717, 0xFF151515, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1F1F1F, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF171717, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF363636, 0xFF5B5B5B, 0xFF808080, 0xFF999999, 0xFFBEBEBE, 0xFFCCCCCC, 
        0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFB2B2B2, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF141414, 0xFF2F2F2F, 0xFF444444, 0xFF525252, 0xFF444444, 
        0xFF161616, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF420C0C, 0xFF990404, 0xFF111111, 0xFF252525, 0xFF767676, 0xFF767676, 0xFF7D7D7D, 0xFF898989, 0xFF898989, 0xFF898989, 0xFF898989, 0xFF898989, 0xFF898989, 0xDC898989, 0x00000000,
  0xBA888888, 0xFF888888, 0xFF888888, 0xFF888888, 0xFF888888, 0xFF888888, 0xFF888888, 0xFF808080, 0xFF777777, 0xFF777777, 0xFF2A2A2A, 0xFF111111, 0xFF8D0505, 0xFF4F0B0B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF898989, 0xFFCBCBCB, 0xFFB2B2B2, 0xFF8D8D8D, 
        0xFF858585, 0xFFA5A5A5, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFFCBCBCB, 0xFF4A4A4A, 0xFF181818, 0xFF191919, 0xFF191919, 0xFF191919, 0xFF1A1A1A, 0xFF1B1B1B, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF272727, 0xFF4A4A4A, 0xFF636363, 
        0xFF868686, 0xFFA9A9A9, 0xFFCDCDCD, 0xFFCDCDCD, 0xFFCDCDCD, 0xFFCDCDCD, 0xFF353535, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF202020, 0xFF212121, 0xFF202020, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF242424, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF242424, 
        0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF232323, 0xFF232323, 0xFF232323, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF252525, 0xFF2B2B2B, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF2B2B2B, 0xFF252525, 0xFF252525, 0xFF252525, 0xFF242424, 0xFF232323, 
        0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF242424, 0xFF242424, 0xFF242424, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF202020, 0xFF1F1F1F, 0xFF1F1F1F, 
        0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF191919, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF181818, 
        0xFF171717, 0xFF161616, 0xFF151515, 0xFF151515, 0xFF131313, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF181818, 0xFF2F2F2F, 0xFF2F2F2F, 0xFF202020, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFA5A5A5, 0xFF808080, 
        0xFF5B5B5B, 0xFF424242, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF151515, 0xFF333333, 0xFF515151, 0xFF707070, 0xFF979797, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFC7C7C7, 0xFFB8B8B8, 0xFF9E9E9E, 
        0xFF5F5F5F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF202020, 0xFF777777, 0xFF777777, 0xFF7B7B7B, 0xFF888888, 0xFF888888, 0xFF888888, 0xFF888888, 0xFF888888, 0xFF888888, 0xDC888888, 0x00000000,
  0xDC878787, 0xFF878787, 0xFF878787, 0xFF878787, 0xFF878787, 0xFF878787, 0xFF878787, 0xFF7A7A7A, 0xFF777777, 0xFF777777, 0xFF202020, 0xFF111111, 0xFFA50303, 0xFF360D0D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF383838, 0xFF848484, 0xFFB3B3B3, 0xFF7A7A7A, 
        0xFF414141, 0xFF1F1F1F, 0xFF1F1F1F, 0xFFA5A5A5, 0xFFCBCBCB, 0xFF727272, 0xFF878787, 0xFF333333, 0xFF161616, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF1A1A1A, 0xFF191919, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 
        0xFF1C1C1C, 0xFF1C1C1C, 0xFF1D1D1D, 0xFF353535, 0xFF585858, 0xFF7B7B7B, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF212121, 0xFF212121, 0xFF202020, 0xFF212121, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 
        0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF232323, 0xFF232323, 0xFF222222, 0xFF242424, 0xFF363636, 0xFF404040, 0xFF3F3F3F, 0xFF252525, 0xFF232323, 0xFF232323, 0xFF232323, 0xFF222222, 0xFF222222, 
        0xFF222222, 0xFF242424, 0xFF232323, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF232323, 0xFF232323, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF202020, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 
        0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF171717, 0xFF161616, 0xFF151515, 
        0xFF151515, 0xFF151515, 0xFF151515, 0xFF141414, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF121212, 0xFF303030, 0xFF303030, 0xFF303030, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF747474, 0xFF4F4F4F, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF313131, 0xFF898989, 0xFFBCBCBC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCACACA, 0xFF929292, 0xFF6D6D6D, 0xFF5A5A5A, 0xFFC4C4C4, 
        0xFFBCBCBC, 0xFF191919, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFCC0000, 0xFF111111, 0xFF111111, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF878787, 0xFF878787, 0xFF878787, 0xFF878787, 0xFF878787, 0xFF878787, 0xFF878787, 0x00000000,
  0xED878787, 0xFF878787, 0xFF878787, 0xFF878787, 0xFF878787, 0xFF878787, 0xFF878787, 0xFF7B7B7B, 0xFF787878, 0xFF787878, 0xFF1C1C1C, 0xFF111111, 0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF2C2C2C, 0xFF545454, 0xFF8E8E8E, 
        0xFFBBBBBB, 0xFF717171, 0xFF313131, 0xFFCACACA, 0xFFC5C5C5, 0xFF141414, 0xFF131313, 0xFF151515, 0xFF151515, 0xFF171717, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF191919, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1B1B1B, 0xFF1C1C1C, 0xFF1B1B1B, 
        0xFF1A1A1A, 0xFF1A1A1A, 0xFF1C1C1C, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF202020, 0xFF212121, 0xFF202020, 0xFF222222, 0xFF212121, 
        0xFF202020, 0xFF1F1F1F, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF414141, 0xFF404040, 0xFF3F3F3F, 0xFF212121, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 
        0xFF202020, 0xFF212121, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF202020, 0xFF1F1F1F, 0xFF202020, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF202020, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 
        0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF2B2B2B, 0xFF3A3A3A, 0xFF848484, 0xFF868686, 0xFF7F7F7F, 0xFF787878, 0xFF616161, 0xFF292929, 0xFF151515, 0xFF151515, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 
        0xFF131313, 0xFF141414, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF282828, 0xFF323232, 0xFF323232, 0xFF161616, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF797979, 0xFFC4C4C4, 0xFF646464, 0xFF434343, 0xFF2C2C2C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1C1C1C, 0xFF919191, 
        0xFFB8B8B8, 0xFF2F2F2F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFCC0000, 0xFF111111, 0xFF111111, 0xFF787878, 0xFF787878, 0xFF787878, 0xFF878787, 0xFF878787, 0xFF878787, 0xFF878787, 0xFF878787, 0xFF878787, 0xFF878787, 0x10878787,
  0xFF868686, 0xFF868686, 0xFF868686, 0xFF868686, 0xFF868686, 0xFF868686, 0xFF868686, 0xFF797979, 0xFF797979, 0xFF797979, 0xFF111111, 0xFF111111, 0xFFCC0000, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF202020, 0xFF444444, 
        0xFF7E7E7E, 0xFFBCBCBC, 0xFFB2B2B2, 0xFFCBCBCB, 0xFF909090, 0xFF131313, 0xFF131313, 0xFF141414, 0xFF141414, 0xFF141414, 0xFF171717, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF191919, 0xFF1A1A1A, 0xFF1A1A1A, 
        0xFF1A1A1A, 0xFF1A1A1A, 0xFF1B1B1B, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1F1F1F, 0xFF1F1F1F, 
        0xFF1F1F1F, 0xFF1F1F1F, 0xFF202020, 0xFF202020, 0xFF1F1F1F, 0xFF202020, 0xFF222222, 0xFF222222, 0xFF212121, 0xFF202020, 0xFF252525, 0xFF414141, 0xFF404040, 0xFF2F2F2F, 0xFF1F1F1F, 0xFF212121, 0xFF212121, 0xFF212121, 0xFF1F1F1F, 0xFF1F1F1F, 
        0xFF1F1F1F, 0xFF202020, 0xFF212121, 0xFF202020, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF202020, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 
        0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF272727, 0xFF4E4E4E, 0xFFA1A1A1, 0xFFA2A2A2, 0xFF9C9C9C, 0xFF969696, 0xFF909090, 0xFF898989, 0xFF838383, 0xFF7D7D7D, 0xFF646464, 0xFF2A2A2A, 0xFF131313, 0xFF131313, 0xFF121212, 0xFF111111, 
        0xFF111111, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1F1F1F, 0xFF343434, 0xFF343434, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF848484, 0xFFCCCCCC, 0xFF404040, 0xFF141414, 0xFF111111, 0xFF111111, 0xFF262626, 0xFF3E3E3E, 0xFF575757, 0xFFA4A4A4, 
        0xFF919191, 0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF5F5F5F, 0xFF797979, 0xFF797979, 0xFF828282, 0xFF868686, 0xFF868686, 0xFF868686, 0xFF868686, 0xFF868686, 0xFF868686, 0x32868686,
  0xFF858585, 0xFF858585, 0xFF858585, 0xFF858585, 0xFF858585, 0xFF858585, 0xFF858585, 0xFF797979, 0xFF797979, 0xFF797979, 0xFF111111, 0xFF111111, 0xFFCC0000, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF252525, 0xFF595959, 0xFFA4A4A4, 0xFFCCCCCC, 0xFF6B6B6B, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF141414, 0xFF151515, 0xFF161616, 0xFF151515, 0xFF171717, 0xFF161616, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF191919, 0xFF191919, 
        0xFF191919, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1B1B1B, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1D1D1D, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1D1D1D, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 
        0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF202020, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF272727, 0xFF404040, 0xFF404040, 0xFF292929, 0xFF1E1E1E, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 
        0xFF1E1E1E, 0xFF1E1E1E, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 
        0xFF191919, 0xFF191919, 0xFF181818, 0xFF323232, 0xFF909090, 0xFF959595, 0xFF9A9A9A, 0xFF9B9B9B, 0xFF979797, 0xFF929292, 0xFF8C8C8C, 0xFF868686, 0xFF808080, 0xFF797979, 0xFF737373, 0xFF6C6C6C, 0xFF393939, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF181818, 0xFF353535, 0xFF353535, 0xFF212121, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF606060, 0xFFBEBEBE, 0xFF7C7C7C, 0xFF696969, 0xFF898989, 0xFFBABABA, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFC4C4C4, 0xFFA0A0A0, 
        0xFF525252, 0xFF151515, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF5F5F5F, 0xFF797979, 0xFF797979, 0xFF828282, 0xFF858585, 0xFF858585, 0xFF858585, 0xFF858585, 0xFF858585, 0xFF858585, 0x32858585,
  0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF606060, 0xFF111111, 0xFF290E0E, 0xFFB20202, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF242424, 0xFF3C3C3C, 0xFF323232, 0xFF111111, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF141414, 0xFF131313, 0xFF141414, 0xFF151515, 0xFF171717, 0xFF171717, 0xFF161616, 0xFF161616, 0xFF181818, 
        0xFF181818, 0xFF1A1A1A, 0xFF191919, 0xFF191919, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1B1B1B, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1E1E1E, 
        0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF303030, 0xFF424242, 0xFF424242, 0xFF242424, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1F1F1F, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 
        0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 
        0xFF181818, 0xFF171717, 0xFF303030, 0xFF848484, 0xFF8A8A8A, 0xFF8F8F8F, 0xFF919191, 0xFF919191, 0xFF8F8F8F, 0xFF8B8B8B, 0xFF868686, 0xFF808080, 0xFF7A7A7A, 0xFF747474, 0xFF6C6C6C, 0xFF676767, 0xFF5C5C5C, 0xFF353535, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF151515, 0xFF373737, 0xFF373737, 0xFF2C2C2C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF3A3A3A, 0xFF797979, 0xFFB1B1B1, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFA2A2A2, 0xFF787878, 0xFF585858, 0xFF3C3C3C, 
        0xFF1F1F1F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF990404, 0xFF420C0C, 0xFF111111, 0xFF4D4D4D, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF818181, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0x54848484,
  0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF606060, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF121212, 0xFF131313, 0xFF131313, 0xFF141414, 0xFF141414, 0xFF131313, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF171717, 
        0xFF161616, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF191919, 0xFF191919, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1D1D1D, 
        0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1D1D1D, 0xFF373737, 0xFF444444, 0xFF444444, 0xFF212121, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1D1D1D, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 
        0xFF1D1D1D, 0xFF1D1D1D, 0xFF1E1E1E, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 
        0xFF161616, 0xFF232323, 0xFF787878, 0xFF7D7D7D, 0xFF828282, 0xFF868686, 0xFF888888, 0xFF888888, 0xFF878787, 0xFF838383, 0xFF7F7F7F, 0xFF797979, 0xFF747474, 0xFF6E6E6E, 0xFF676767, 0xFF606060, 0xFF565656, 0xFF565656, 0xFF272727, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF505050, 0xFF4B4B4B, 0xFF343434, 0xFF1C1C1C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D0505, 0xFF4F0B0B, 0xFF111111, 0xFF464646, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF818181, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0x54848484,
  0xFF838383, 0xFF838383, 0xFF838383, 0xFF838383, 0xFF838383, 0xFF838383, 0xFF838383, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF606060, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF131313, 0xFF131313, 0xFF141414, 0xFF141414, 0xFF141414, 0xFF151515, 
        0xFF151515, 0xFF171717, 0xFF171717, 0xFF171717, 0xFF181818, 0xFF171717, 0xFF171717, 0xFF181818, 0xFF181818, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1B1B1B, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1B1B1B, 
        0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF444444, 0xFF444444, 0xFF434343, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1D1D1D, 0xFF1C1C1C, 0xFF1C1C1C, 
        0xFF1B1B1B, 0xFF1B1B1B, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1B1B1B, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF181818, 
        0xFF161616, 0xFF414141, 0xFF717171, 0xFF757575, 0xFF797979, 0xFF7C7C7C, 0xFF7D7D7D, 0xFF7F7F7F, 0xFF7D7D7D, 0xFF7B7B7B, 0xFF777777, 0xFF727272, 0xFF6C6C6C, 0xFF676767, 0xFF616161, 0xFF595959, 0xFF525252, 0xFF525252, 0xFF474747, 0xFF121212, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF2E2E2E, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF151515, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D0505, 0xFF4F0B0B, 0xFF111111, 0xFF474747, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF808080, 0xFF838383, 0xFF838383, 0xFF838383, 0xFF838383, 0xFF838383, 0xFF838383, 0x54838383,
  0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF606060, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF121212, 0xFF111111, 0xFF121212, 0xFF131313, 0xFF141414, 0xFF151515, 
        0xFF141414, 0xFF141414, 0xFF151515, 0xFF141414, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF171717, 0xFF171717, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF191919, 0xFF1A1A1A, 0xFF191919, 0xFF191919, 0xFF181818, 0xFF191919, 0xFF1A1A1A, 0xFF1A1A1A, 
        0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1B1B1B, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF434343, 0xFF444444, 0xFF3D3D3D, 0xFF1C1C1C, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1C1C1C, 0xFF1B1B1B, 0xFF1A1A1A, 
        0xFF1A1A1A, 0xFF1A1A1A, 0xFF1B1B1B, 0xFF1B1B1B, 0xFF1B1B1B, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF191919, 0xFF1A1A1A, 0xFF191919, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF171717, 0xFF161616, 
        0xFF212121, 0xFF636363, 0xFF686868, 0xFF6D6D6D, 0xFF6F6F6F, 0xFF737373, 0xFF747474, 0xFF757575, 0xFF737373, 0xFF727272, 0xFF6E6E6E, 0xFF6A6A6A, 0xFF656565, 0xFF5F5F5F, 0xFF585858, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF242424, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF282828, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF181818, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D0505, 0xFF4F0B0B, 0xFF111111, 0xFF474747, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF7F7F7F, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0x54828282,
  0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF616161, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF121212, 0xFF111111, 0xFF111111, 
        0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF141414, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF161616, 0xFF181818, 0xFF171717, 0xFF171717, 0xFF181818, 0xFF171717, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF1A1A1A, 0xFF1A1A1A, 
        0xFF191919, 0xFF191919, 0xFF191919, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF191919, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF454545, 0xFF464646, 0xFF393939, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF191919, 0xFF1A1A1A, 0xFF1A1A1A, 
        0xFF1A1A1A, 0xFF191919, 0xFF191919, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF171717, 0xFF161616, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF171717, 0xFF161616, 0xFF151515, 0xFF151515, 0xFF151515, 
        0xFF2B2B2B, 0xFF5B5B5B, 0xFF5F5F5F, 0xFF636363, 0xFF676767, 0xFF696969, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF676767, 0xFF646464, 0xFF616161, 0xFF5C5C5C, 0xFF565656, 0xFF525252, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF353535, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF262626, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF1A1A1A, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D0505, 0xFF4F0B0B, 0xFF111111, 0xFF484848, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF7F7F7F, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0x54828282,
  0xFF818181, 0xFF818181, 0xFF818181, 0xFF818181, 0xFF818181, 0xFF818181, 0xFF818181, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF626262, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF121212, 0xFF131313, 0xFF131313, 0xFF121212, 0xFF121212, 0xFF141414, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF141414, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF171717, 0xFF181818, 0xFF171717, 0xFF181818, 0xFF181818, 
        0xFF181818, 0xFF181818, 0xFF181818, 0xFF191919, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF1A1A1A, 0xFF191919, 0xFF454545, 0xFF454545, 0xFF383838, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF191919, 0xFF181818, 
        0xFF181818, 0xFF181818, 0xFF181818, 0xFF1A1A1A, 0xFF191919, 0xFF181818, 0xFF181818, 0xFF171717, 0xFF161616, 0xFF151515, 0xFF151515, 0xFF171717, 0xFF171717, 0xFF171717, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF141414, 
        0xFF373737, 0xFF505050, 0xFF555555, 0xFF585858, 0xFF5C5C5C, 0xFF5E5E5E, 0xFF606060, 0xFF616161, 0xFF606060, 0xFF5D5D5D, 0xFF5A5A5A, 0xFF575757, 0xFF525252, 0xFF474747, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF272727, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF1B1B1B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D0505, 0xFF4F0B0B, 0xFF111111, 0xFF484848, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7F7F7F, 0xFF818181, 0xFF818181, 0xFF818181, 0xFF818181, 0xFF818181, 0xFF818181, 0x54818181,
  0xFF808080, 0xFF808080, 0xFF808080, 0xFF808080, 0xFF808080, 0xFF808080, 0xFF808080, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF666666, 0xFF111111, 0xFF360D0D, 0xFFB50101, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFB2B2B2, 0xFFB2B2B2, 0xFF292929, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF131313, 0xFF141414, 0xFF141414, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF141414, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF161616, 0xFF151515, 0xFF151515, 0xFF181818, 
        0xFF171717, 0xFF171717, 0xFF151515, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF181818, 0xFF171717, 0xFF444444, 0xFF444444, 0xFF393939, 0xFF181818, 0xFF181818, 0xFF171717, 0xFF161616, 0xFF151515, 0xFF181818, 0xFF181818, 
        0xFF181818, 0xFF171717, 0xFF161616, 0xFF171717, 0xFF171717, 0xFF161616, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF141414, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF141414, 0xFF131313, 0xFF131313, 0xFF131313, 
        0xFF424242, 0xFF424242, 0xFF454545, 0xFF4D4D4D, 0xFF505050, 0xFF535353, 0xFF545454, 0xFF555555, 0xFF545454, 0xFF525252, 0xFF4F4F4F, 0xFF4D4D4D, 0xFF494949, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 
        0xFF151515, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF282828, 0xFF414141, 0xFF414141, 0xFF1B1B1B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFFB2B2B2, 0xFFB2B2B2, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF950404, 0xFF560909, 0xFF111111, 0xFF4D4D4D, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7E7E7E, 0xFF808080, 0xFF808080, 0xFF808080, 0xFF808080, 0xFF808080, 0xFF808080, 0x5F808080,
  0xFF808080, 0xFF808080, 0xFF808080, 0xFF808080, 0xFF808080, 0xFF808080, 0xFF808080, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF636363, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF363636, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF121212, 0xFF121212, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF141414, 0xFF131313, 0xFF131313, 0xFF151515, 0xFF151515, 0xFF141414, 0xFF151515, 
        0xFF151515, 0xFF151515, 0xFF151515, 0xFF161616, 0xFF171717, 0xFF151515, 0xFF161616, 0xFF171717, 0xFF151515, 0xFF151515, 0xFF464646, 0xFF464646, 0xFF3C3C3C, 0xFF161616, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF161616, 0xFF161616, 
        0xFF151515, 0xFF141414, 0xFF141414, 0xFF141414, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF141414, 0xFF141414, 0xFF131313, 0xFF131313, 0xFF151515, 0xFF151515, 0xFF141414, 0xFF141414, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF121212, 
        0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF454545, 0xFF484848, 0xFF494949, 0xFF484848, 0xFF494949, 0xFF484848, 0xFF414141, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 
        0xFF161616, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF2B2B2B, 0xFF434343, 0xFF434343, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D0505, 0xFF4F0B0B, 0xFF111111, 0xFF484848, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7E7E7E, 0xFF808080, 0xFF808080, 0xFF808080, 0xFF808080, 0xFF808080, 0xFF808080, 0x54808080,
  0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF808080, 0xFF808080, 0xFF646464, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF141414, 
        0xFF151515, 0xFF141414, 0xFF141414, 0xFF131313, 0xFF141414, 0xFF131313, 0xFF131313, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF464646, 0xFF454545, 0xFF383838, 0xFF151515, 0xFF151515, 0xFF151515, 0xFF141414, 0xFF151515, 0xFF151515, 0xFF141414, 
        0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF141414, 0xFF141414, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 
        0xFF2E2E2E, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF444444, 0xFF444444, 0xFF1C1C1C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D0505, 0xFF4F0B0B, 0xFF111111, 0xFF494949, 0xFF808080, 0xFF808080, 0xFF7D7D7D, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 0x547F7F7F,
  0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF818181, 0xFF818181, 0xFF656565, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF131313, 0xFF131313, 0xFF121212, 
        0xFF131313, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF141414, 0xFF141414, 0xFF131313, 0xFF474747, 0xFF474747, 0xFF393939, 0xFF141414, 0xFF131313, 0xFF131313, 0xFF121212, 0xFF131313, 0xFF131313, 0xFF131313, 
        0xFF131313, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF121212, 0xFF131313, 0xFF131313, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF131313, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF222222, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF2B2B2B, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF2A2A2A, 0xFF464646, 0xFF464646, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D0505, 0xFF4F0B0B, 0xFF111111, 0xFF494949, 0xFF818181, 0xFF818181, 0xFF7D7D7D, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0x547E7E7E,
  0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF828282, 0xFF828282, 0xFF666666, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF121212, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF131313, 0xFF131313, 0xFF494949, 0xFF484848, 0xFF3A3A3A, 0xFF131313, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF131313, 0xFF131313, 0xFF121212, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF171717, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF323232, 0xFF1C1C1C, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF2F2F2F, 0xFF484848, 0xFF484848, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D0505, 0xFF4F0B0B, 0xFF111111, 0xFF4A4A4A, 0xFF828282, 0xFF828282, 0xFF7D7D7D, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0xFF7E7E7E, 0x547E7E7E,
  0xFF7D7D7D, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF828282, 0xFF828282, 0xFF666666, 0xFF111111, 0xFF290E0E, 0xFFB20202, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF252525, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF2E2E2E, 0xFF121212, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF3A3A3A, 0xFF494949, 0xFF494949, 0xFF181818, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF232323, 0xFF686868, 0xFF464646, 0xFF262626, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D0505, 0xFF4F0B0B, 0xFF111111, 0xFF4A4A4A, 0xFF828282, 0xFF828282, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF7D7D7D, 0x547D7D7D,
  0xFF7C7C7C, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF838383, 0xFF838383, 0xFF838383, 0xFF111111, 0xFF111111, 0xFFCC0000, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF3B3B3B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF191919, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF161616, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF2A2A2A, 0xFF191919, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF3E3E3E, 0xFFBCBCBC, 0xFF989898, 0xFF5A5A5A, 0xFF212121, 0xFF111111, 0xFF111111, 0xFF252525, 0xFF4F4F4F, 
        0xFF373737, 0xFF1C1C1C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF666666, 0xFF838383, 0xFF838383, 0xFF7B7B7B, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF7C7C7C, 0x327C7C7C,
  0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF111111, 0xFF111111, 0xFFCC0000, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF323232, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF1E1E1E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF1A1A1A, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF161616, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF434343, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF545454, 0xFFCCCCCC, 0xFFA5A5A5, 0xFFA1A1A1, 0xFF727272, 0xFF2C2C2C, 0xFF111111, 0xFF464646, 0xFFCCCCCC, 
        0xFFB1B1B1, 0xFF5E5E5E, 0xFF1C1C1C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF676767, 0xFF848484, 0xFF848484, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0x327B7B7B,
  0xED7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF808080, 0xFF858585, 0xFF858585, 0xFF1D1D1D, 0xFF111111, 0xFFB20202, 0xFF290E0E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF272727, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF242424, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF181818, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF222222, 0xFF1A1A1A, 0xFF0F0F0F, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1E1E1E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF333333, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF707070, 0xFFCCCCCC, 0xFF5A5A5A, 0xFF656565, 0xFFB2B2B2, 0xFF969696, 0xFF484848, 0xFF3D3D3D, 0xFF626262, 
        0xFFA4A4A4, 0xFFB2B2B2, 0xFF464646, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFCC0000, 0xFF111111, 0xFF111111, 0xFF747474, 0xFF858585, 0xFF858585, 0xFF7A7A7A, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0xFF7B7B7B, 0x217B7B7B,
  0xDC7A7A7A, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF7F7F7F, 0xFF858585, 0xFF858585, 0xFF232323, 0xFF111111, 0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF222222, 0xFF505050, 0xFF505050, 0xFF333333, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF131313, 0xFF1A1A1A, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF1E1E1E, 0xFF141414, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF282828, 0xFF505050, 0xFF505050, 0xFF282828, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF989898, 0xFFCCCCCC, 0xFF2C2C2C, 0xFF1C1C1C, 0xFF545454, 0xFFACACAC, 0xFF9E9E9E, 0xFF5E5E5E, 0xFF434343, 
        0xFF868686, 0xFFC7C7C7, 0xFF3E3E3E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFCC0000, 0xFF111111, 0xFF111111, 0xFF858585, 0xFF858585, 0xFF858585, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF7A7A7A, 0x00000000,
  0xBA797979, 0xFF797979, 0xFF797979, 0xFF797979, 0xFF797979, 0xFF797979, 0xFF797979, 0xFF7C7C7C, 0xFF868686, 0xFF868686, 0xFF2E2E2E, 0xFF111111, 0xFF8D0505, 0xFF4F0B0B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF1E1E1E, 0xFF363636, 0xFF4D4D4D, 0xFF4E4E4E, 0xFF191919, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF171717, 0xFF525252, 0xFF525252, 0xFF474747, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF0F0F0F, 0xFF121212, 0xFF151515, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF161616, 0xFF121212, 0xFF101010, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF3A3A3A, 0xFF525252, 0xFF525252, 0xFF1C1C1C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF313131, 0xFF464646, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF3C3C3C, 0xFF7C7C7C, 0xFFA5A5A5, 0xFFA1A1A1, 
        0xFFB1B1B1, 0xFF8A8A8A, 0xFF232323, 0xFF111111, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF1E1E1E, 0xFF868686, 0xFF868686, 0xFF808080, 0xFF797979, 0xFF797979, 0xFF797979, 0xFF797979, 0xFF797979, 0xFF797979, 0xED797979, 0x00000000,
  0xA9797979, 0xFF797979, 0xFF797979, 0xFF797979, 0xFF797979, 0xFF797979, 0xFF797979, 0xFF7C7C7C, 0xFF878787, 0xFF878787, 0xFF333333, 0xFF111111, 0xFF800606, 0xFF5B0A0A, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF252525, 0xFF414141, 0xFF5C5C5C, 
        0xFF7C7C7C, 0xFFA7A7A7, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFABABAB, 0xFF6C6C6C, 0xFF262626, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF4F4F4F, 0xFF747474, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF414141, 0xFF535353, 0xFF535353, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF131313, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF747474, 0xFF4F4F4F, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF141414, 0xFF2C2C2C, 0xFF4A4A4A, 0xFF666666, 
        0xFF5C5C5C, 0xFF232323, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF420C0C, 0xFF990404, 0xFF111111, 0xFF232323, 0xFF878787, 0xFF878787, 0xFF7F7F7F, 0xFF797979, 0xFF797979, 0xFF797979, 0xFF797979, 0xFF797979, 0xFF797979, 0xDC797979, 0x00000000,
  0x87787878, 0xFF787878, 0xFF787878, 0xFF787878, 0xFF787878, 0xFF787878, 0xFF787878, 0xFF7B7B7B, 0xFF888888, 0xFF888888, 0xFF3F3F3F, 0xFF111111, 0xFF670909, 0xFF740707, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF191919, 0xFF646464, 0xFFABABAB, 0xFFC7C7C7, 
        0xFFCCCCCC, 0xFFCCCCCC, 0xFFB4B4B4, 0xFF848484, 0xFF686868, 0xFF929292, 0xFFBABABA, 0xFF444444, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D1D1D, 0xFF424242, 0xFF5B5B5B, 
        0xFF808080, 0xFFA5A5A5, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF2E2E2E, 0xFF555555, 0xFF555555, 0xFF2A2A2A, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF212121, 0xFF555555, 0xFF555555, 0xFF373737, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFA5A5A5, 0xFF808080, 
        0xFF5B5B5B, 0xFF424242, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF3F3F3F, 0xFF707070, 0xFF474747, 0xFF242424, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFF8D0505, 0xFF111111, 0xFF2E2E2E, 0xFF888888, 0xFF888888, 0xFF7D7D7D, 0xFF787878, 0xFF787878, 0xFF787878, 0xFF787878, 0xFF787878, 0xFF787878, 0xA9787878, 0x00000000,
  0x76777777, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF797979, 0xFF888888, 0xFF888888, 0xFF4D4D4D, 0xFF111111, 0xFF4F0B0B, 0xFF8D0505, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF484848, 0xFFA2A2A2, 0xFF8E8E8E, 0xFF545454, 
        0xFF3C3C3C, 0xFF252525, 0xFF111111, 0xFF111111, 0xFF181818, 0xFF585858, 0xFFCCCCCC, 0xFF5D5D5D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D1D1D, 0xFFB2B2B2, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 
        0xFFCCCCCC, 0xFFBEBEBE, 0xFFA5A5A5, 0xFF808080, 0xFF5B5B5B, 0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF212121, 0xFF575757, 0xFF575757, 0xFF444444, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF333333, 0xFF575757, 0xFF575757, 0xFF272727, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF363636, 0xFF5B5B5B, 0xFF808080, 0xFFA5A5A5, 0xFFBEBEBE, 0xFFCCCCCC, 
        0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFB2B2B2, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF5C5C5C, 0xFFBCBCBC, 0xFF959595, 0xFF555555, 0xFF252525, 0xFF111111, 0xFF111111, 0xFF3D3D3D, 0xFF585858, 0xFF3C3C3C, 
        0xFF1E1E1E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF740707, 0xFF740707, 0xFF111111, 0xFF3F3F3F, 0xFF888888, 0xFF888888, 0xFF7A7A7A, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF777777, 0x98777777, 0x00000000,
  0x54777777, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF787878, 0xFF898989, 0xFF898989, 0xFF606060, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF484848, 0xFFBCBCBC, 0xFF686868, 0xFF191919, 
        0xFF111111, 0xFF111111, 0xFF141414, 0xFF2E2E2E, 0xFF464646, 0xFF777777, 0xFFB5B5B5, 0xFF5C5C5C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFA5A5A5, 0xFF8D8D8D, 0xFF747474, 0xFF4F4F4F, 
        0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4C4C4C, 0xFF585858, 0xFF585858, 0xFF1A1A1A, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF131313, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF171717, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 
        0xFF4F4F4F, 0xFF747474, 0xFF8D8D8D, 0xFFA5A5A5, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF7C7C7C, 0xFFCCCCCC, 0xFF919191, 0xFFA4A4A4, 0xFF666666, 0xFF252525, 0xFF111111, 0xFF686868, 0xFFCCCCCC, 0xFFA5A5A5, 
        0xFF515151, 0xFF191919, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D0505, 0xFF4F0B0B, 0xFF111111, 0xFF4E4E4E, 0xFF898989, 0xFF898989, 0xFF797979, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF777777, 0x76777777, 0x00000000,
  0x32767676, 0xFF767676, 0xFF767676, 0xFF767676, 0xFF767676, 0xFF767676, 0xFF767676, 0xFF757575, 0xFF8A8A8A, 0xFF8A8A8A, 0xFF787878, 0xFF111111, 0xFF111111, 0xFFCC0000, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF363636, 0xFFBEBEBE, 0xFF9C9C9C, 0xFF5C5C5C, 
        0xFF707070, 0xFF979797, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCACACA, 0xFFB5B5B5, 0xFF767676, 0xFF242424, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF303030, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF353535, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF282828, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF3F3F3F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFA7A7A7, 0xFFCCCCCC, 0xFF404040, 0xFF6A6A6A, 0xFFAEAEAE, 0xFF949494, 0xFF414141, 0xFF3C3C3C, 0xFF595959, 0xFFB1B1B1, 
        0xFFABABAB, 0xFF313131, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFA50303, 0xFF360D0D, 0xFF111111, 0xFF606060, 0xFF8A8A8A, 0xFF8A8A8A, 0xFF777777, 0xFF767676, 0xFF767676, 0xFF767676, 0xFF767676, 0xFF767676, 0xFF767676, 0x54767676, 0x00000000,
  0x00000000, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF848484, 0xFF8A8A8A, 0xFF8A8A8A, 0xFF1E1E1E, 0xFF111111, 0xFFB20202, 0xFF290E0E, 0xFF111111, 0xFF111111, 0xFF1B1B1B, 0xFF707070, 0xFFAEAEAE, 0xFFBEBEBE, 
        0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF939393, 0xFF6D6D6D, 0xFF4E4E4E, 0xFF2F2F2F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1B1B1B, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF171717, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF484848, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF222222, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1E1E1E, 0xFFCCCCCC, 0xFFB4B4B4, 0xFF111111, 0xFF1F1F1F, 0xFF5C5C5C, 0xFFCCCCCC, 0xFFA4A4A4, 0xFF5F5F5F, 0xFF4A4A4A, 0xFFBABABA, 
        0xFFC0C0C0, 0xFF1E1E1E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFCC0000, 0xFF111111, 0xFF111111, 0xFF787878, 0xFF8A8A8A, 0xFF8A8A8A, 0xFF767676, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF757575, 0x32757575, 0x00000000,
  0x00000000, 0xDC757575, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF7F7F7F, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF292929, 0xFF111111, 0xFF8D0505, 0xFF4F0B0B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF181818, 0xFF505050, 0xFF535353, 
        0xFF424242, 0xFF2C2C2C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF424242, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF2D2D2D, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF232323, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF525252, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF262626, 0xFF343434, 0xFF111111, 0xFF111111, 0xFF161616, 0xFF404040, 0xFF828282, 0xFFABABAB, 0xFFA4A4A4, 0xFFA4A4A4, 
        0xFF6C6C6C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF290E0E, 0xFFB20202, 0xFF111111, 0xFF1E1E1E, 0xFF8B8B8B, 0xFF8B8B8B, 0xFF858585, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF757575, 0x00000000, 0x00000000,
  0x00000000, 0xA9747474, 0xFF747474, 0xFF747474, 0xFF747474, 0xFF747474, 0xFF747474, 0xFF747474, 0xFF7A7A7A, 0xFF8C8C8C, 0xFF8C8C8C, 0xFF3A3A3A, 0xFF111111, 0xFF740707, 0xFF740707, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF464646, 0xFF969696, 0xFF4D4D4D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF232323, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF535353, 0xFF171717, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF494949, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF2E2E2E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF282828, 0xFF434343, 0xFF565656, 0xFF484848, 
        0xFF1E1E1E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFF8D0505, 0xFF111111, 0xFF2A2A2A, 0xFF8C8C8C, 0xFF8C8C8C, 0xFF7D7D7D, 0xFF747474, 0xFF747474, 0xFF747474, 0xFF747474, 0xFF747474, 0xFF747474, 0xDC747474, 0x00000000, 0x00000000,
  0x00000000, 0x87737373, 0xFF737373, 0xFF737373, 0xFF737373, 0xFF737373, 0xFF737373, 0xFF737373, 0xFF777777, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF4F4F4F, 0xFF111111, 0xFF4F0B0B, 0xFF990404, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF222222, 0xFF454545, 
        0xFF616161, 0xFF686868, 0xFF4E4E4E, 0xFF333333, 0xFF252525, 0xFF151515, 0xFF4B4B4B, 0xFFCCCCCC, 0xFF666666, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4B4B4B, 0xFF616161, 0xFF616161, 0xFF333333, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF272727, 0xFF616161, 0xFF616161, 0xFF545454, 0xFF131313, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF161616, 0xFF414141, 0xFF595959, 0xFF4F4F4F, 0xFF3C3C3C, 0xFF252525, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF740707, 0xFF670909, 0xFF111111, 0xFF3B3B3B, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF797979, 0xFF737373, 0xFF737373, 0xFF737373, 0xFF737373, 0xFF737373, 0xFF737373, 0xA9737373, 0x00000000, 0x00000000,
  0x00000000, 0x54727272, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF747474, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF6E6E6E, 0xFF111111, 0xFF290E0E, 0xFFBE0101, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1B1B1B, 0xFF525252, 0xFF9E9E9E, 
        0xFFA2A2A2, 0xFFA4A4A4, 0xFFBFBFBF, 0xFFA7A7A7, 0xFF6D6D6D, 0xFF4F4F4F, 0xFF545454, 0xFFCCCCCC, 0xFF898989, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF202020, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF1C1C1C, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF141414, 0xFF555555, 0xFF636363, 0xFF636363, 0xFF2B2B2B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF5F5F5F, 0xFF9B9B9B, 0xFFB6B6B6, 0xFFC5C5C5, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFB4B4B4, 0xFF848484, 0xFF5F5F5F, 0xFF404040, 0xFF1C1C1C, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF990404, 0xFF420C0C, 0xFF111111, 0xFF4F4F4F, 0xFF8D8D8D, 0xFF8D8D8D, 0xFF767676, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF727272, 0x87727272, 0x00000000, 0x00000000,
  0x00000000, 0x21727272, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF8E8E8E, 0xFF8E8E8E, 0xFF8E8E8E, 0xFF171717, 0xFF111111, 0xFFB20202, 0xFF290E0E, 0xFF111111, 0xFF111111, 0xFF2A2A2A, 0xFFA0A0A0, 0xFFABABAB, 
        0xFF444444, 0xFF353535, 0xFF4D4D4D, 0xFF7F7F7F, 0xFF949494, 0xFFAEAEAE, 0xFF949494, 0xFFCCCCCC, 0xFFBABABA, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF3F3F3F, 0xFF646464, 0xFF646464, 0xFF464646, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF353535, 0xFF646464, 0xFF646464, 0xFF4E4E4E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFB6B6B6, 0xFFCACACA, 0xFF505050, 0xFF5D5D5D, 0xFF7C7C7C, 0xFFA7A7A7, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFC0C0C0, 0xFF9B9B9B, 0xFF3E3E3E, 
        0xFF121212, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFBE0101, 0xFF1D0F0F, 0xFF111111, 0xFF6E6E6E, 0xFF8E8E8E, 0xFF8E8E8E, 0xFF747474, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF727272, 0x54727272, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0xED717171, 0xFF717171, 0xFF717171, 0xFF717171, 0xFF717171, 0xFF717171, 0xFF717171, 0xFF808080, 0xFF8F8F8F, 0xFF8F8F8F, 0xFF2A2A2A, 0xFF111111, 0xFF8D0505, 0xFF5B0A0A, 0xFF111111, 0xFF111111, 0xFF151515, 0xFFBFBFBF, 0xFFCACACA, 
        0xFF636363, 0xFF7E7E7E, 0xFF1B1B1B, 0xFF111111, 0xFF323232, 0xFF505050, 0xFF6B6B6B, 0xFF8F8F8F, 0xFFACACAC, 0xFF232323, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF181818, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF2D2D2D, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF242424, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF212121, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF262626, 0xFFCCCCCC, 0xFFA5A5A5, 0xFF1F1F1F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1E1E1E, 0xFF373737, 0xFF575757, 0xFFCCCCCC, 0xFF8A8A8A, 
        0xFF131313, 0xFF111111, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF1F1F1F, 0xFF8F8F8F, 0xFF8F8F8F, 0xFF878787, 0xFF717171, 0xFF717171, 0xFF717171, 0xFF717171, 0xFF717171, 0xFF717171, 0xFF717171, 0x21717171, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0xBA707070, 0xFF707070, 0xFF707070, 0xFF707070, 0xFF707070, 0xFF707070, 0xFF707070, 0xFF787878, 0xFF909090, 0xFF909090, 0xFF424242, 0xFF111111, 0xFF5B0A0A, 0xFF800606, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF666666, 0xFF989898, 
        0xFFBFBFBF, 0xFFCCCCCC, 0xFF313131, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF252525, 0xFF292929, 0xFF191919, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF313131, 0xFF686868, 0xFF686868, 0xFF686868, 
        0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF191919, 
        0xFF5A5A5A, 0xFF686868, 0xFF686868, 0xFF3C3C3C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF303030, 0xFF929292, 0xFFB4B4B4, 0xFF686868, 0xFF4A4A4A, 0xFF333333, 0xFF1B1B1B, 0xFF111111, 0xFF111111, 0xFF363636, 0xFFCACACA, 0xFF959595, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF5B0A0A, 0xFF800606, 0xFF111111, 0xFF303030, 0xFF909090, 0xFF909090, 0xFF7C7C7C, 0xFF707070, 0xFF707070, 0xFF707070, 0xFF707070, 0xFF707070, 0xFF707070, 0xED707070, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x87707070, 0xFF707070, 0xFF707070, 0xFF707070, 0xFF707070, 0xFF707070, 0xFF707070, 0xFF757575, 0xFF909090, 0xFF909090, 0xFF5A5A5A, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1C1C1C, 0xFF404040, 
        0xFF4A4A4A, 0xFF3A3A3A, 0xFF171717, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF494949, 0xFF696969, 0xFF696969, 
        0xFF515151, 0xFF141414, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF494949, 
        0xFF696969, 0xFF696969, 0xFF515151, 0xFF141414, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF141414, 0xFF4B4B4B, 0xFFA4A4A4, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFA1A1A1, 0xFF797979, 0xFF797979, 0xFFB4B4B4, 0xFF636363, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF990404, 0xFF4F0B0B, 0xFF111111, 0xFF494949, 0xFF909090, 0xFF909090, 0xFF787878, 0xFF707070, 0xFF707070, 0xFF707070, 0xFF707070, 0xFF707070, 0xFF707070, 0xA9707070, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x436F6F6F, 0xFF6F6F6F, 0xFF6F6F6F, 0xFF6F6F6F, 0xFF6F6F6F, 0xFF6F6F6F, 0xFF6F6F6F, 0xFF6F6F6F, 0xFF919191, 0xFF919191, 0xFF919191, 0xFF111111, 0xFF111111, 0xFFBE0101, 0xFF290E0E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF363636, 
        0xFF747474, 0xFF424242, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF191919, 0xFF5D5D5D, 0xFF6B6B6B, 
        0xFF6B6B6B, 0xFF434343, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF383838, 0xFF6B6B6B, 
        0xFF6B6B6B, 0xFF6B6B6B, 0xFF1E1E1E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF424242, 0xFF808080, 
        0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF171717, 0xFF343434, 0xFF4D4D4D, 0xFF666666, 0xFF898989, 0xFFBCBCBC, 0xFFCCCCCC, 0xFFBFBFBF, 0xFFA4A4A4, 0xFF6F6F6F, 0xFF383838, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFFBE0101, 0xFF1D0F0F, 0xFF111111, 0xFF707070, 0xFF919191, 0xFF919191, 0xFF737373, 0xFF6F6F6F, 0xFF6F6F6F, 0xFF6F6F6F, 0xFF6F6F6F, 0xFF6F6F6F, 0xFF6F6F6F, 0x766F6F6F, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x106E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF848484, 0xFF929292, 0xFF929292, 0xFF2B2B2B, 0xFF111111, 0xFF8D0505, 0xFF5B0A0A, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D8D8D, 
        0xFFCCCCCC, 0xFF8D8D8D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF232323, 0xFF6D6D6D, 
        0xFF6D6D6D, 0xFF6D6D6D, 0xFF3E3E3E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF333333, 0xFF6D6D6D, 0xFF6D6D6D, 
        0xFF6D6D6D, 0xFF2F2F2F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF808080, 0xFFCCCCCC, 
        0xFF8D8D8D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF282828, 0xFF3C3C3C, 0xFF434343, 0xFF2A2A2A, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF420C0C, 0xFFA50303, 0xFF111111, 0xFF1F1F1F, 0xFF929292, 0xFF929292, 0xFF929292, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0x326E6E6E, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xCB6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF777777, 0xFF939393, 0xFF939393, 0xFF4B4B4B, 0xFF111111, 0xFF4F0B0B, 0xFF8D0505, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF363636, 
        0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF2F2F2F, 
        0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF393939, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF2B2B2B, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 
        0xFF393939, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF363636, 
        0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF740707, 0xFF740707, 0xFF111111, 0xFF373737, 0xFF939393, 0xFF939393, 0xFF7D7D7D, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF6E6E6E, 0xED6E6E6E, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x876D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF727272, 0xFF939393, 0xFF939393, 0xFF727272, 0xFF111111, 0xFF1D0F0F, 0xFFBE0101, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF3A3A3A, 0xFF707070, 0xFF707070, 0xFF707070, 0xFF404040, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF353535, 0xFF707070, 0xFF707070, 0xFF707070, 0xFF464646, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFFA50303, 0xFF420C0C, 0xFF111111, 0xFF535353, 0xFF939393, 0xFF939393, 0xFF737373, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 0xFF6D6D6D, 0xBA6D6D6D, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x436C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF8A8A8A, 0xFF949494, 0xFF949494, 0xFF1F1F1F, 0xFF111111, 0xFF990404, 0xFF4F0B0B, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF3B3B3B, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF474747, 0xFF141414, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF3B3B3B, 0xFF727272, 0xFF727272, 0xFF727272, 0xFF474747, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF290E0E, 0xFFBE0101, 0xFF111111, 0xFF111111, 0xFF818181, 0xFF949494, 0xFF949494, 0xFF6E6E6E, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0x656C6C6C, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xED6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF797979, 0xFF959595, 0xFF959595, 0xFF3D3D3D, 0xFF111111, 0xFF5B0A0A, 0xFF8D0505, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF3B3B3B, 0xFF737373, 0xFF737373, 0xFF737373, 0xFF595959, 0xFF1F1F1F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF151515, 0xFF484848, 0xFF737373, 0xFF737373, 0xFF737373, 0xFF484848, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF670909, 0xFF800606, 0xFF111111, 0xFF323232, 0xFF959595, 0xFF959595, 0xFF858585, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0xFF6C6C6C, 0x216C6C6C, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xA96B6B6B, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF717171, 0xFF969696, 0xFF969696, 0xFF686868, 0xFF111111, 0xFF1D0F0F, 0xFFBE0101, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF363636, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF282828, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF242424, 0xFF656565, 0xFF757575, 0xFF757575, 0xFF757575, 0xFF424242, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFFA50303, 0xFF420C0C, 0xFF111111, 0xFF545454, 0xFF969696, 0xFF969696, 0xFF757575, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF6B6B6B, 0xFF6B6B6B, 0xDC6B6B6B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x656A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6B6B6B, 0xFF969696, 0xFF969696, 0xFF969696, 0xFF202020, 0xFF111111, 0xFF990404, 0xFF4F0B0B, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF444444, 0xFF1B1B1B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF151515, 0xFF373737, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF777777, 0xFF323232, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1E1E1E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF290E0E, 0xFFBE0101, 0xFF111111, 0xFF111111, 0xFF838383, 0xFF969696, 0xFF969696, 0xFF6F6F6F, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0xFF6A6A6A, 0x876A6A6A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10696969, 0xFF696969, 0xFF696969, 0xFF696969, 0xFF696969, 0xFF696969, 0xFF696969, 0xFF696969, 0xFF787878, 0xFF979797, 0xFF979797, 0xFF3E3E3E, 0xFF111111, 0xFF5B0A0A, 0xFF8D0505, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF424242, 0xFFB2B2B2, 0xFF999999, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF202020, 0xFF5D5D5D, 0xFF787878, 0xFF787878, 0xFF787878, 0xFF686868, 0xFF333333, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF5D5D5D, 0xFF787878, 0xFF787878, 0xFF787878, 0xFF686868, 0xFF242424, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF999999, 0xFFB2B2B2, 0xFF424242, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF525252, 0xFF9B9B9B, 0xFF404040, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF670909, 0xFF800606, 0xFF111111, 0xFF323232, 0xFF979797, 0xFF979797, 0xFF868686, 0xFF696969, 0xFF696969, 0xFF696969, 0xFF696969, 0xFF696969, 0xFF696969, 0xFF696969, 0x43696969, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xBA696969, 0xFF696969, 0xFF696969, 0xFF696969, 0xFF696969, 0xFF696969, 0xFF696969, 0xFF707070, 0xFF989898, 0xFF989898, 0xFF767676, 0xFF111111, 0xFF1D0F0F, 0xFFBE0101, 0xFF1D0F0F, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF363636, 0xFF999999, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF8D8D8D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF3E3E3E, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF5F5F5F, 0xFF2A2A2A, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF252525, 0xFF555555, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF7A7A7A, 0xFF4C4C4C, 0xFF151515, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D8D8D, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF999999, 0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF252525, 0xFFCCCCCC, 0xFFBEBEBE, 0xFF777777, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF565656, 0xFF989898, 0xFF989898, 0xFF747474, 0xFF696969, 0xFF696969, 0xFF696969, 0xFF696969, 0xFF696969, 0xFF696969, 0xED696969, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x65686868, 0xFF686868, 0xFF686868, 0xFF686868, 0xFF686868, 0xFF686868, 0xFF686868, 0xFF696969, 0xFF8D8D8D, 0xFF999999, 0xFF999999, 0xFF262626, 0xFF111111, 0xFF8D0505, 0xFF5B0A0A, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D1D1D, 0xFF747474, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFA5A5A5, 0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF252525, 0xFF5F5F5F, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF5F5F5F, 0xFF343434, 0xFF151515, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF2B2B2B, 0xFF5F5F5F, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF7C7C7C, 0xFF5F5F5F, 0xFF2B2B2B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF363636, 0xFFA5A5A5, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF747474, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF6A6A6A, 0xFFCCCCCC, 0xFFA1A1A1, 0xFFA7A7A7, 0xFF5F5F5F, 0xFF1C1C1C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF360D0D, 
        0xFFB20202, 0xFF111111, 0xFF181818, 0xFF999999, 0xFF999999, 0xFF999999, 0xFF6E6E6E, 0xFF686868, 0xFF686868, 0xFF686868, 0xFF686868, 0xFF686868, 0xFF686868, 0x98686868, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF787878, 0xFF999999, 0xFF999999, 0xFF4D4D4D, 0xFF111111, 0xFF420C0C, 0xFFA50303, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF5B5B5B, 0xFFBEBEBE, 0xFFCCCCCC, 0xFFB2B2B2, 0xFF4F4F4F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF2F2F2F, 0xFF6C6C6C, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF474747, 0xFF2B2B2B, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF262626, 0xFF404040, 0xFF6C6C6C, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF7D7D7D, 0xFF393939, 0xFF151515, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F4F4F, 0xFFB2B2B2, 0xFFCCCCCC, 0xFFBEBEBE, 0xFF5B5B5B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF343434, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF3F3F3F, 0xFF919191, 0xFF8D8D8D, 0xFF323232, 0xFF111111, 0xFF2E2E2E, 0xFF5F5F5F, 0xFF1C1C1C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF8D0505, 
        0xFF670909, 0xFF111111, 0xFF393939, 0xFF999999, 0xFF999999, 0xFF808080, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF676767, 0x43676767, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xBA676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF6D6D6D, 0xFF9A9A9A, 0xFF9A9A9A, 0xFF868686, 0xFF111111, 0xFF111111, 0xFFB20202, 0xFF360D0D, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF363636, 0xFFB2B2B2, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF747474, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF151515, 0xFF3A3A3A, 0xFF6E6E6E, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 
        0xFF4F4F4F, 0xFF353535, 0xFF212121, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF212121, 0xFF303030, 0xFF474747, 
        0xFF6E6E6E, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF7F7F7F, 0xFF414141, 0xFF1C1C1C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D1D1D, 0xFF747474, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFB2B2B2, 0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF171717, 0xFF5E5E5E, 0xFF555555, 0xFF141414, 0xFF3B3B3B, 0xFF9B9B9B, 0xFF818181, 0xFF2C2C2C, 0xFF757575, 0xFFCCCCCC, 0xFF949494, 0xFF343434, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D0F0F, 0xFFBE0101, 
        0xFF1D0F0F, 0xFF111111, 0xFF6B6B6B, 0xFF9A9A9A, 0xFF9A9A9A, 0xFF707070, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xFF676767, 0xDD666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x54666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF878787, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF3A3A3A, 0xFF111111, 0xFF670909, 0xFF8D0505, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFFCCCCCC, 0xFF8D8D8D, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF313131, 0xFF595959, 0xFF818181, 0xFF818181, 0xFF818181, 0xFF818181, 
        0xFF818181, 0xFF818181, 0xFF818181, 0xFF818181, 0xFF646464, 0xFF505050, 0xFF414141, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3E3E3E, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF414141, 0xFF484848, 0xFF646464, 0xFF818181, 0xFF818181, 0xFF818181, 0xFF818181, 
        0xFF818181, 0xFF818181, 0xFF818181, 0xFF818181, 0xFF646464, 0xFF363636, 0xFF151515, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF8D8D8D, 0xFFCCCCCC, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF161616, 0xFF111111, 0xFF111111, 0xFF202020, 0xFF6D6D6D, 0xFFACACAC, 0xFF4D4D4D, 0xFF2F2F2F, 0xFF7D7D7D, 0xFFB6B6B6, 0xFF4E4E4E, 0xFF151515, 0xFF111111, 0xFF111111, 0xFF670909, 0xFF800606, 
        0xFF111111, 0xFF262626, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF676767, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0x88656565, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xEE646464, 0xFF656565, 0xFF656565, 0xFF656565, 0xFF656565, 0xFF656565, 0xFF656565, 0xFF707070, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF6C6C6C, 0xFF111111, 0xFF1D0F0F, 0xFFBE0101, 
        0xFF290E0E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF222222, 0xFF3C3C3C, 0xFF656565, 0xFF828282, 
        0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 0xFF828282, 
        0xFF828282, 0xFF656565, 0xFF424242, 0xFF272727, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF6A6A6A, 0xFF707070, 0xFF292929, 0xFF121212, 0xFF353535, 0xFF848484, 0xFFA4A4A4, 0xFF5E5E5E, 0xFF6B6B6B, 0xFFC2C2C2, 0xFF686868, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFB20202, 0xFF360D0D, 
        0xFF111111, 0xFF575757, 0xFF9B9B9B, 0xFF9B9B9B, 0xFF747474, 0xFF656565, 0xFF656565, 0xFF656565, 0xFF656565, 0xFF656565, 0xFF656565, 0xFF656565, 0x22646464, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x99646464, 0xFF656565, 0xFF656565, 0xFF656565, 0xFF656565, 0xFF656565, 0xFF656565, 0xFF676767, 0xFF9C9C9C, 0xFF9C9C9C, 0xFF9C9C9C, 0xFF2D2D2D, 0xFF111111, 0xFF800606, 
        0xFF740707, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF151515, 0xFF4C4C4C, 0xFF414141, 0xFF313131, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1C1C1C, 
        0xFF323232, 0xFF434343, 0xFF666666, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF848484, 0xFF666666, 0xFF4A4A4A, 0xFF323232, 
        0xFF222222, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF373737, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF949494, 0xFF373737, 0xFF111111, 0xFF434343, 0xFFACACAC, 0xFFA5A5A5, 0xFFC0C0C0, 0xFFA7A7A7, 0xFF2E2E2E, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFF990404, 0xFF111111, 
        0xFF202020, 0xFF9C9C9C, 0xFF9C9C9C, 0xFF9C9C9C, 0xFF6B6B6B, 0xFF656565, 0xFF656565, 0xFF656565, 0xFF656565, 0xFF656565, 0xFF656565, 0xCC646464, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33636363, 0xFF646464, 0xFF646464, 0xFF646464, 0xFF646464, 0xFF646464, 0xFF646464, 0xFF646464, 0xFF747474, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF585858, 0xFF111111, 0xFF290E0E, 
        0xFFBE0101, 0xFF1D0F0F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF484848, 0xFFA7A7A7, 0xFFBABABA, 0xFFB5B5B5, 0xFF979797, 0xFF292929, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF222222, 0xFF2D2D2D, 0xFF323232, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF404040, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF373737, 0xFF2D2D2D, 0xFF222222, 0xFF161616, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF282828, 0xFF484848, 0xFF111111, 0xFF858585, 0xFFCCCCCC, 0xFF969696, 0xFFBCBCBC, 0xFF606060, 0xFF111111, 0xFF111111, 0xFF202020, 0xFF535353, 0xFF4D4D4D, 0xFF3C3C3C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFB20202, 0xFF420C0C, 0xFF111111, 
        0xFF474747, 0xFF9D9D9D, 0xFF9D9D9D, 0xFF818181, 0xFF646464, 0xFF646464, 0xFF646464, 0xFF646464, 0xFF646464, 0xFF646464, 0xFF646464, 0x55636363, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xCC626262, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF6A6A6A, 0xFF9E9E9E, 0xFF9E9E9E, 0xFF9E9E9E, 0xFF272727, 0xFF111111, 
        0xFF8D0505, 0xFF670909, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF373737, 0xFF858585, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF828282, 0xFF7C7C7C, 0xFFCCCCCC, 0xFF707070, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF707070, 0xFFCCCCCC, 0xFF9C9C9C, 0xFFCCCCCC, 0xFF9F9F9F, 0xFF262626, 0xFF757575, 0xFFB3B3B3, 0xFF595959, 0xFF1E1E1E, 0xFF111111, 0xFF111111, 0xFF141414, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFFB20202, 0xFF111111, 0xFF181818, 
        0xFF8A8A8A, 0xFF9E9E9E, 0xFF9E9E9E, 0xFF6C6C6C, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xEE626262, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x55626262, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF777777, 0xFF9E9E9E, 0xFF9E9E9E, 0xFF4F4F4F, 0xFF111111, 
        0xFF360D0D, 0xFFB20202, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF242424, 0xFF696969, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF9E9E9E, 0xFF434343, 0xFF141414, 0xFF2B2B2B, 0xFFBFBFBF, 0xFF9B9B9B, 0xFF2E2E2E, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF434343, 0xFF9F9F9F, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF858585, 0xFF252525, 0xFF3C3C3C, 0xFFA4A4A4, 0xFF8F8F8F, 0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF990404, 0xFF4F0B0B, 0xFF111111, 0xFF3A3A3A, 
        0xFF9E9E9E, 0xFF9E9E9E, 0xFF888888, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0x88626262, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xDD616161, 0xFF626262, 0xFF626262, 0xFF626262, 0xFF626262, 0xFF626262, 0xFF626262, 0xFF6A6A6A, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF9F9F9F, 0xFF202020, 
        0xFF111111, 0xFF8D0505, 0xFF5B0A0A, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF333333, 0xFF8D8D8D, 0xFFC2C2C2, 0xFFCCCCCC, 0xFF555555, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF575757, 0xFFCCCCCC, 0xFF737373, 0xFF181818, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF5A5A5A, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF585858, 0xFF424242, 0xFF999999, 0xFFA0A0A0, 0xFF3A3A3A, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF420C0C, 0xFFB20202, 0xFF111111, 0xFF111111, 0xFF7B7B7B, 
        0xFF9F9F9F, 0xFF9F9F9F, 0xFF6D6D6D, 0xFF626262, 0xFF626262, 0xFF626262, 0xFF626262, 0xFF626262, 0xFF626262, 0xFF626262, 0x22616161, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x88606060, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF7B7B7B, 0xFFA0A0A0, 0xFFA0A0A0, 0xFF505050, 
        0xFF111111, 0xFF360D0D, 0xFFBE0101, 0xFF1D0F0F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF434343, 0xFFBABABA, 0xFF747474, 0xFF262626, 0xFF111111, 0xFF111111, 0xFF434343, 0xFF9E9E9E, 0xFFCACACA, 0xFFB4B4B4, 0xFF4E4E4E, 0xFF141414, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF252525, 0xFF303030, 
        0xFF363636, 0xFF252525, 0xFF6A6A6A, 0xFF404040, 0xFF6A6A6A, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFB4B4B4, 0xFFAEAEAE, 0xFFBABABA, 0xFF616161, 0xFF1C1C1C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFB20202, 0xFF4F0B0B, 0xFF111111, 0xFF3B3B3B, 0xFFA0A0A0, 
        0xFFA0A0A0, 0xFF888888, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF616161, 0xAA606060, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x115F5F5F, 0xEE5F5F5F, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF696969, 0xFFA1A1A1, 0xFFA1A1A1, 0xFFA1A1A1, 
        0xFF202020, 0xFF111111, 0xFF800606, 0xFF740707, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF535353, 0xFFB2B2B2, 0xFF696969, 0xFF1D1D1D, 0xFF333333, 0xFF7D7D7D, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF858585, 0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1B1B1B, 0xFF7F7F7F, 0xFF969696, 
        0xFFA1A1A1, 0xFF787878, 0xFF333333, 0xFF111111, 0xFF111111, 0xFF373737, 0xFF858585, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF707070, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFFA50303, 0xFF111111, 0xFF111111, 0xFF7D7D7D, 0xFFA1A1A1, 
        0xFFA1A1A1, 0xFF6C6C6C, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF606060, 0x335F5F5F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x995F5F5F, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF7B7B7B, 0xFFA1A1A1, 0xFFA1A1A1, 
        0xFF5A5A5A, 0xFF111111, 0xFF290E0E, 0xFFBE0101, 0xFF290E0E, 0xFF111111, 0xFF111111, 0xFF292929, 0xFFBFBFBF, 0xFFCACACA, 0xFF7C7C7C, 0xFFCACACA, 0xFFCCCCCC, 0xFFA7A7A7, 0xFF484848, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF5F5F5F, 0xFFCCCCCC, 0xFF949494, 
        0xFFA9A9A9, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF646464, 0xFF202020, 0xFF111111, 0xFF111111, 0xFF484848, 0xFFA7A7A7, 0xFFCCCCCC, 0xFF2A2A2A, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFB20202, 0xFF420C0C, 0xFF111111, 0xFF494949, 0xFFA1A1A1, 0xFFA1A1A1, 
        0xFF898989, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF606060, 0xFF606060, 0xBB5F5F5F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x225E5E5E, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF686868, 0xFFA2A2A2, 0xFFA2A2A2, 
        0xFFA2A2A2, 0xFF282828, 0xFF111111, 0xFF740707, 0xFF800606, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF505050, 0xFF979797, 0xFFA7A7A7, 0xFFB4B4B4, 0xFF5A5A5A, 0xFF151515, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF282828, 0xFFA2A2A2, 0xFFCCCCCC, 0xFF373737, 
        0xFF191919, 0xFF5A5A5A, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFBCBCBC, 0xFF505050, 0xFF111111, 0xFF111111, 0xFF151515, 0xFF3A3A3A, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF670909, 0xFF8D0505, 0xFF111111, 0xFF181818, 0xFF8E8E8E, 0xFFA2A2A2, 0xFFA2A2A2, 
        0xFF6C6C6C, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0x445E5E5E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x995D5D5D, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF767676, 0xFFA3A3A3, 
        0xFFA3A3A3, 0xFF656565, 0xFF111111, 0xFF1D0F0F, 0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF111111, 0xFF121212, 0xFF292929, 0xFF464646, 0xFF262626, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF242424, 0xFF7E7E7E, 0xFFB3B3B3, 0xFF464646, 
        0xFF111111, 0xFF111111, 0xFF2A2A2A, 0xFF707070, 0xFFCCCCCC, 0xFFC0C0C0, 0xFF787878, 0xFF2C2C2C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF290E0E, 0xFFBE0101, 0xFF290E0E, 0xFF111111, 0xFF525252, 0xFFA3A3A3, 0xFFA3A3A3, 0xFF8A8A8A, 
        0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xBB5D5D5D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x225D5D5D, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF676767, 0xFFA4A4A4, 
        0xFFA4A4A4, 0xFFA4A4A4, 0xFF363636, 0xFF111111, 0xFF5B0A0A, 0xFFA50303, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF353535, 0xFF545454, 0xFF575757, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 
        0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 
        0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF575757, 0xFF545454, 0xFF353535, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF191919, 0xFF656565, 0xFFC5C5C5, 0xFFCCCCCC, 
        0xFF757575, 0xFF2E2E2E, 0xFF111111, 0xFF111111, 0xFF3E3E3E, 0xFF939393, 0xFFAFAFAF, 0xFF414141, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF800606, 0xFF740707, 0xFF111111, 0xFF282828, 0xFFA4A4A4, 0xFFA4A4A4, 0xFFA4A4A4, 0xFF696969, 
        0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0xFF5E5E5E, 0x445D5D5D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x995C5C5C, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF717171, 
        0xFFA4A4A4, 0xFFA4A4A4, 0xFF7F7F7F, 0xFF111111, 0xFF111111, 0xFFA50303, 0xFF5B0A0A, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF5E5E5E, 0xFF333333, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF333333, 0xFF5E5E5E, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4D4D4D, 0xFFB3B3B3, 
        0xFFCCCCCC, 0xFFCCCCCC, 0xFF5E5E5E, 0xFF1A1A1A, 0xFF191919, 0xFF5E5E5E, 0xFFBABABA, 0xFF5F5F5F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF420C0C, 0xFFB20202, 0xFF1D0F0F, 0xFF111111, 0xFF656565, 0xFFA4A4A4, 0xFFA4A4A4, 0xFF7B7B7B, 0xFF5D5D5D, 
        0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xBB5C5C5C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x115B5B5B, 0xEE5B5B5B, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5F5F5F, 
        0xFF959595, 0xFFA5A5A5, 0xFFA5A5A5, 0xFF4A4A4A, 0xFF111111, 0xFF360D0D, 0xFFBE0101, 0xFF290E0E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF5E5E5E, 0xFF0D0D0D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF0D0D0D, 0xFF5E5E5E, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1C1C1C, 
        0xFF5F5F5F, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFB1B1B1, 0xFF5A5A5A, 0xFFCCCCCC, 0xFFBFBFBF, 0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFB20202, 0xFF4F0B0B, 0xFF111111, 0xFF363636, 0xFFA5A5A5, 0xFFA5A5A5, 0xFFA5A5A5, 0xFF656565, 0xFF5C5C5C, 
        0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0x335B5B5B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x775B5B5B, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 
        0xFF6A6A6A, 0xFFA6A6A6, 0xFFA6A6A6, 0xFFA6A6A6, 0xFF212121, 0xFF111111, 0xFF740707, 0xFF8D0505, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF353535, 0xFF333333, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF333333, 0xFF353535, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF2E2E2E, 0xFF777777, 0xFFBABABA, 0xFFB1B1B1, 0xFF9B9B9B, 0xFF5A5A5A, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF740707, 0xFF8D0505, 0xFF111111, 0xFF191919, 0xFF808080, 0xFFA6A6A6, 0xFFA6A6A6, 0xFF6E6E6E, 0xFF5C5C5C, 0xFF5C5C5C, 
        0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0xFF5C5C5C, 0xAA5B5B5B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xDD5A5A5A, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 
        0xFF5B5B5B, 0xFF828282, 0xFFA7A7A7, 0xFFA7A7A7, 0xFF737373, 0xFF111111, 0xFF111111, 0xFFA50303, 0xFF4F0B0B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF545454, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF545454, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF393939, 0xFF545454, 0xFF373737, 0xFF1C1C1C, 0xFF111111, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF1D0F0F, 0xFF111111, 0xFF535353, 0xFFA7A7A7, 0xFFA7A7A7, 0xFF8B8B8B, 0xFF5E5E5E, 0xFF5B5B5B, 0xFF5B5B5B, 
        0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0x225A5A5A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x55595959, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 
        0xFF5A5A5A, 0xFF636363, 0xFFA7A7A7, 0xFFA7A7A7, 0xFFA7A7A7, 0xFF3D3D3D, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF290E0E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF575757, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF575757, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFB20202, 0xFF4F0B0B, 0xFF111111, 0xFF292929, 0xFFA7A7A7, 0xFFA7A7A7, 0xFFA7A7A7, 0xFF666666, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 
        0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0x88595959, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xBB595959, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 
        0xFF5A5A5A, 0xFF5A5A5A, 0xFF6E6E6E, 0xFFA8A8A8, 0xFFA8A8A8, 0xFF929292, 0xFF212121, 0xFF111111, 0xFF740707, 0xFF990404, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF740707, 0xFF8D0505, 0xFF111111, 0xFF111111, 0xFF828282, 0xFFA8A8A8, 0xFFA8A8A8, 0xFF757575, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 
        0xFF5A5A5A, 0xFF5A5A5A, 0xFF5A5A5A, 0xDD595959, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33585858, 0xFF595959, 0xFF595959, 0xFF595959, 0xFF595959, 0xFF595959, 
        0xFF595959, 0xFF595959, 0xFF595959, 0xFF8C8C8C, 0xFFA9A9A9, 0xFFA9A9A9, 0xFF757575, 0xFF111111, 0xFF111111, 0xFFA50303, 0xFF670909, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFFB20202, 0xFF1D0F0F, 0xFF111111, 0xFF555555, 0xFFA9A9A9, 0xFFA9A9A9, 0xFF979797, 0xFF5F5F5F, 0xFF595959, 0xFF595959, 0xFF595959, 0xFF595959, 
        0xFF595959, 0xFF595959, 0xFF595959, 0x55585858, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x88575757, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 
        0xFF585858, 0xFF585858, 0xFF585858, 0xFF616161, 0xFFAAAAAA, 0xFFAAAAAA, 0xFFAAAAAA, 0xFF454545, 0xFF111111, 0xFF290E0E, 0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF290E0E, 0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF373737, 0xFFAAAAAA, 0xFFAAAAAA, 0xFFAAAAAA, 0xFF666666, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 
        0xFF585858, 0xFF585858, 0xBB575757, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xDD565656, 0xFF575757, 0xFF575757, 0xFF575757, 
        0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF6D6D6D, 0xFFAAAAAA, 0xFFAAAAAA, 0xFFAAAAAA, 0xFF292929, 0xFF111111, 0xFF4F0B0B, 0xFFB20202, 0xFF1D0F0F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFFA50303, 0xFF670909, 0xFF111111, 0xFF212121, 0xFF949494, 0xFFAAAAAA, 0xFFAAAAAA, 0xFF747474, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 
        0xFF575757, 0xFF575757, 0x22565656, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x44565656, 0xFF575757, 0xFF575757, 0xFF575757, 
        0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF838383, 0xFFABABAB, 0xFFABABAB, 0xFF848484, 0xFF191919, 0xFF111111, 0xFF740707, 0xFF990404, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF740707, 0xFF8D0505, 0xFF111111, 0xFF111111, 0xFF767676, 0xFFABABAB, 0xFFABABAB, 0xFF8C8C8C, 0xFF5A5A5A, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 0xFF575757, 
        0xFF575757, 0x77565656, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x99555555, 0xFF565656, 0xFF565656, 
        0xFF565656, 0xFF565656, 0xFF565656, 0xFF565656, 0xFF565656, 0xFF5D5D5D, 0xFF9A9A9A, 0xFFACACAC, 0xFFACACAC, 0xFF606060, 0xFF111111, 0xFF111111, 0xFF990404, 0xFF740707, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFFB20202, 0xFF1D0F0F, 0xFF111111, 0xFF4D4D4D, 0xFFACACAC, 0xFFACACAC, 0xFFACACAC, 0xFF606060, 0xFF565656, 0xFF565656, 0xFF565656, 0xFF565656, 0xFF565656, 0xFF565656, 0xFF565656, 
        0xCC555555, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x11545454, 0xDD545454, 0xFF555555, 
        0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF646464, 0xFFACACAC, 0xFFACACAC, 0xFFACACAC, 0xFF464646, 0xFF111111, 0xFF1D0F0F, 0xFFB20202, 0xFF4F0B0B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF360D0D, 0xFFBE0101, 0xFF360D0D, 0xFF111111, 0xFF373737, 0xFFACACAC, 0xFFACACAC, 0xFFACACAC, 0xFF686868, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 
        0x22545454, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33545454, 0xFF555555, 
        0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF6B6B6B, 0xFFADADAD, 0xFFADADAD, 0xFFADADAD, 0xFF313131, 0xFF111111, 0xFF360D0D, 0xFFBE0101, 0xFF360D0D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF290E0E, 0xFFBE0101, 0xFF420C0C, 0xFF111111, 0xFF2A2A2A, 0xFF979797, 0xFFADADAD, 0xFFADADAD, 0xFF747474, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0x66545454, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x88535353, 
        0xFF545454, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF7B7B7B, 0xFFAEAEAE, 0xFFAEAEAE, 0xFF989898, 0xFF2A2A2A, 0xFF111111, 0xFF420C0C, 0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF1D0F0F, 0xFFB20202, 0xFF5B0A0A, 0xFF111111, 0xFF191919, 0xFF868686, 0xFFAEAEAE, 0xFFAEAEAE, 0xFF8E8E8E, 0xFF585858, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF545454, 0xFF545454, 0xAA535353, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0xCC525252, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF575757, 0xFF8E8E8E, 0xFFAFAFAF, 0xFFAFAFAF, 0xFF878787, 0xFF191919, 0xFF111111, 0xFF5B0A0A, 0xFFB20202, 0xFF1D0F0F, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF990404, 0xFF800606, 0xFF111111, 0xFF111111, 0xFF6C6C6C, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFF5F5F5F, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xDD525252, 0x11525252, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x22525252, 0xEE525252, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF5F5F5F, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFF797979, 0xFF111111, 0xFF111111, 0xFF670909, 0xFFB20202, 0xFF1D0F0F, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF990404, 0xFF8D0505, 0xFF111111, 0xFF111111, 0xFF616161, 0xFFAFAFAF, 0xFFAFAFAF, 0xFFAFAFAF, 0xFF626262, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0xFF535353, 0x33525252, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x55515151, 0xFF525252, 0xFF525252, 0xFF525252, 0xFF525252, 0xFF525252, 0xFF525252, 0xFF525252, 0xFF525252, 0xFF606060, 0xFFB0B0B0, 0xFFB0B0B0, 0xFFB0B0B0, 0xFF6D6D6D, 0xFF111111, 0xFF111111, 0xFF800606, 0xFF990404, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF800606, 
        0xFF990404, 0xFF111111, 0xFF111111, 0xFF585858, 0xFFB0B0B0, 0xFFB0B0B0, 0xFFB0B0B0, 0xFF676767, 0xFF525252, 0xFF525252, 0xFF525252, 0xFF525252, 0xFF525252, 0xFF525252, 0xFF525252, 0xFF525252, 0x77515151, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x88505050, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF636363, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFF585858, 0xFF111111, 0xFF111111, 0xFF800606, 0xFF990404, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF800606, 0xFF990404, 
        0xFF111111, 0xFF111111, 0xFF404040, 0xFFB1B1B1, 0xFFB1B1B1, 0xFFB1B1B1, 0xFF6D6D6D, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xAA505050, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0xBB505050, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF696969, 0xFFB2B2B2, 0xFFB2B2B2, 0xFFB2B2B2, 0xFF585858, 0xFF111111, 0xFF111111, 0xFF800606, 
        0xFF990404, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF800606, 0xFF990404, 0xFF111111, 
        0xFF111111, 0xFF404040, 0xFFB2B2B2, 0xFFB2B2B2, 0xFFB2B2B2, 0xFF737373, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xFF515151, 0xDD505050, 0x11505050, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x114F4F4F, 0xDD4F4F4F, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF6D6D6D, 0xFFB2B2B2, 0xFFB2B2B2, 0xFFB2B2B2, 0xFF585858, 0xFF111111, 0xFF111111, 
        0xFF800606, 0xFF990404, 0xFF1D0F0F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF800606, 0xFF990404, 0xFF111111, 0xFF111111, 
        0xFF404040, 0xFFB2B2B2, 0xFFB2B2B2, 0xFFB2B2B2, 0xFF7A7A7A, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xFF505050, 0xEE4F4F4F, 0x224F4F4F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x334E4E4E, 0xEE4E4E4E, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF727272, 0xFFB3B3B3, 0xFFB3B3B3, 0xFFB3B3B3, 0xFF595959, 0xFF111111, 
        0xFF111111, 0xFF800606, 0xFFB20202, 0xFF1D0F0F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF990404, 0xFF990404, 0xFF111111, 0xFF111111, 0xFF404040, 
        0xFFB3B3B3, 0xFFB3B3B3, 0xFFB3B3B3, 0xFF838383, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0xFF4F4F4F, 0x444E4E4E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x444D4D4D, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF797979, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFF595959, 
        0xFF111111, 0xFF111111, 0xFF740707, 0xFFB20202, 0xFF290E0E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D0F0F, 0xFF990404, 0xFF8D0505, 0xFF111111, 0xFF111111, 0xFF414141, 0xFFB4B4B4, 
        0xFFB4B4B4, 0xFFB4B4B4, 0xFF909090, 0xFF525252, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0x664D4D4D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x554D4D4D, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF7A7A7A, 0xFFB5B5B5, 0xFFB5B5B5, 0xFFB5B5B5, 
        0xFF5A5A5A, 0xFF111111, 0xFF111111, 0xFF5B0A0A, 0xFFBE0101, 0xFF360D0D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF666666, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D0F0F, 0xFFB20202, 0xFF800606, 0xFF111111, 0xFF111111, 0xFF414141, 0xFFB5B5B5, 0xFFB5B5B5, 
        0xFFB5B5B5, 0xFF919191, 0xFF525252, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0xFF4E4E4E, 0x884D4D4D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x664C4C4C, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF727272, 0xFFB5B5B5, 0xFFB5B5B5, 
        0xFFB5B5B5, 0xFF646464, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFFBE0101, 0xFF4F0B0B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF575757, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF575757, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF360D0D, 0xFFBE0101, 0xFF670909, 0xFF111111, 0xFF111111, 0xFF515151, 0xFFB5B5B5, 0xFFB5B5B5, 0xFFB5B5B5, 
        0xFF848484, 0xFF515151, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0xFF4D4D4D, 0x994C4C4C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x884B4B4B, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF6B6B6B, 0xFFB6B6B6, 
        0xFFB6B6B6, 0xFFB6B6B6, 0xFF707070, 0xFF1A1A1A, 0xFF111111, 0xFF360D0D, 0xFFBE0101, 0xFF670909, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF545454, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF545454, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFFBE0101, 0xFF4F0B0B, 0xFF111111, 0xFF111111, 0xFF646464, 0xFFB6B6B6, 0xFFB6B6B6, 0xFFB6B6B6, 0xFF797979, 
        0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xAA4B4B4B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x994B4B4B, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF6C6C6C, 
        0xFFB7B7B7, 0xFFB7B7B7, 0xFFB7B7B7, 0xFF8D8D8D, 0xFF232323, 0xFF111111, 0xFF1D0F0F, 0xFFA50303, 0xFF8D0505, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF353535, 0xFF333333, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF333333, 0xFF353535, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF740707, 0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF1A1A1A, 0xFF717171, 0xFFB7B7B7, 0xFFB7B7B7, 0xFFB7B7B7, 0xFF7A7A7A, 0xFF4C4C4C, 
        0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xFF4C4C4C, 0xBB4B4B4B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x994A4A4A, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 
        0xFF606060, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFA0A0A0, 0xFF333333, 0xFF111111, 0xFF111111, 0xFF8D0505, 0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF5E5E5E, 0xFF0D0D0D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF0D0D0D, 0xFF5E5E5E, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D0F0F, 0xFF990404, 0xFF990404, 0xFF1D0F0F, 0xFF111111, 0xFF2B2B2B, 0xFF8E8E8E, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFF6B6B6B, 0xFF4B4B4B, 0xFF4B4B4B, 
        0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xBB4A4A4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x99494949, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 
        0xFF4A4A4A, 0xFF5D5D5D, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFF424242, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFFBE0101, 0xFF4F0B0B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF5E5E5E, 0xFF333333, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF333333, 0xFF5E5E5E, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF420C0C, 0xFFBE0101, 0xFF740707, 0xFF111111, 0xFF111111, 0xFF333333, 0xFFA0A0A0, 0xFFB8B8B8, 0xFFB8B8B8, 0xFFB8B8B8, 0xFF626262, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 
        0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xBB494949, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x99494949, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 
        0xFF4A4A4A, 0xFF4A4A4A, 0xFF575757, 0xFFA2A2A2, 0xFFB9B9B9, 0xFFB9B9B9, 0xFFB9B9B9, 0xFF666666, 0xFF111111, 0xFF111111, 0xFF360D0D, 0xFFB20202, 0xFF8D0505, 0xFF1D0F0F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF353535, 0xFF545454, 0xFF575757, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 
        0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 
        0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF666666, 0xFF575757, 0xFF545454, 0xFF353535, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF740707, 0xFFBE0101, 0xFF420C0C, 0xFF111111, 0xFF111111, 0xFF525252, 0xFFB9B9B9, 0xFFB9B9B9, 0xFFB9B9B9, 0xFFB9B9B9, 0xFF5D5D5D, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 
        0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xFF4A4A4A, 0xBB494949, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x99484848, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 
        0xFF494949, 0xFF494949, 0xFF494949, 0xFF535353, 0xFF848484, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFF909090, 0xFF2B2B2B, 0xFF111111, 0xFF111111, 0xFF800606, 0xFFB20202, 0xFF360D0D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF290E0E, 0xFFA50303, 0xFF8D0505, 0xFF1D0F0F, 0xFF111111, 0xFF1A1A1A, 0xFF727272, 0xFFBABABA, 0xFFBABABA, 0xFFBABABA, 0xFF919191, 0xFF565656, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 
        0xFF494949, 0xFF494949, 0xFF494949, 0xFF494949, 0xBB484848, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x66474747, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 
        0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF717171, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFF3B3B3B, 0xFF111111, 0xFF111111, 0xFF420C0C, 0xFFB20202, 0xFF740707, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF670909, 0xFFBE0101, 0xFF5B0A0A, 0xFF111111, 0xFF111111, 0xFF343434, 0xFFA3A3A3, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFF797979, 0xFF4C4C4C, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 
        0xFF484848, 0xFF484848, 0xFF484848, 0x99474747, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x66474747, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 
        0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF5C5C5C, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFF676767, 0xFF1A1A1A, 0xFF111111, 0xFF1D0F0F, 0xFF800606, 0xFFB20202, 0xFF420C0C, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF360D0D, 0xFFA50303, 0xFF990404, 0xFF290E0E, 0xFF111111, 0xFF111111, 0xFF535353, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFFBBBBBB, 0xFF676767, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 
        0xFF484848, 0xFF484848, 0x88474747, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x44464646, 0xEE464646, 0xFF474747, 0xFF474747, 
        0xFF474747, 0xFF474747, 0xFF474747, 0xFF474747, 0xFF474747, 0xFF474747, 0xFF474747, 0xFF565656, 0xFF939393, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFF919191, 0xFF343434, 0xFF111111, 0xFF111111, 0xFF420C0C, 0xFFB20202, 0xFF8D0505, 0xFF290E0E, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF676767, 0xFF363636, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF676767, 0xFF363636, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D0F0F, 0xFF740707, 
        0xFFBE0101, 0xFF5B0A0A, 0xFF111111, 0xFF111111, 0xFF2C2C2C, 0xFF818181, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFBCBCBC, 0xFFA4A4A4, 0xFF595959, 0xFF474747, 0xFF474747, 0xFF474747, 0xFF474747, 0xFF474747, 0xFF474747, 0xFF474747, 0xFF474747, 0xFF474747, 
        0xFF474747, 0x66464646, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33454545, 0xDD454545, 0xFF464646, 
        0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF696969, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFF686868, 0xFF1A1A1A, 0xFF111111, 0xFF111111, 0xFF740707, 0xFFBE0101, 
        0xFF670909, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF424242, 0xFFCCCCCC, 0xFF808080, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF424242, 0xFFCCCCCC, 0xFF808080, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF5B0A0A, 0xFFBE0101, 0xFF800606, 
        0xFF1D0F0F, 0xFF111111, 0xFF111111, 0xFF545454, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFF797979, 0xFF4B4B4B, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xFF464646, 0xEE454545, 
        0x44454545, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x11444444, 0xBB444444, 
        0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF575757, 0xFFA4A4A4, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFA5A5A5, 0xFF434343, 0xFF111111, 0xFF111111, 0xFF290E0E, 
        0xFF8D0505, 0xFFB20202, 0xFF4F0B0B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF424242, 0xFFCCCCCC, 0xFF808080, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF424242, 0xFFCCCCCC, 0xFF808080, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF420C0C, 0xFFB20202, 0xFF990404, 0xFF360D0D, 0xFF111111, 
        0xFF111111, 0xFF343434, 0xFF929292, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFFBDBDBD, 0xFF5D5D5D, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xDD444444, 0x33444444, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x99444444, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF4A4A4A, 0xFF696969, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFF757575, 0xFF2C2C2C, 0xFF111111, 
        0xFF111111, 0xFF420C0C, 0xFF990404, 0xFFB20202, 0xFF420C0C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF424242, 0xFFCCCCCC, 0xFF808080, 0xFF111111, 
        0xFF4F4F4F, 0xFFBEBEBE, 0xFF363636, 0xFF292929, 0xFFBEBEBE, 0xFF5B5B5B, 0xFF808080, 0xFFBEBEBE, 0xFFB2B2B2, 0xFF363636, 0xFF747474, 0xFFBEBEBE, 0xFFBEBEBE, 0xFF676767, 0xFF111111, 0xFF424242, 0xFFCCCCCC, 0xFF8D8D8D, 0xFF8D8D8D, 0xFFBEBEBE, 
        0xFFB2B2B2, 0xFF4F4F4F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF360D0D, 0xFF990404, 0xFFB20202, 0xFF4F0B0B, 0xFF111111, 0xFF111111, 0xFF242424, 
        0xFF696969, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFF797979, 0xFF505050, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xFF454545, 0xBB444444, 0x11444444, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x55434343, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF565656, 0xFF939393, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFF5E5E5E, 
        0xFF1A1A1A, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFFB20202, 0xFF990404, 0xFF420C0C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF424242, 0xFFCCCCCC, 0xFF808080, 0xFF424242, 
        0xFFCCCCCC, 0xFFBEBEBE, 0xFF292929, 0xFF424242, 0xFFCCCCCC, 0xFFBEBEBE, 0xFF999999, 0xFF999999, 0xFFCCCCCC, 0xFFBEBEBE, 0xFFB2B2B2, 0xFF8D8D8D, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF363636, 0xFF424242, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF999999, 0xFF8D8D8D, 
        0xFFCCCCCC, 0xFFCCCCCC, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF360D0D, 0xFF8D0505, 0xFFB20202, 0xFF5B0A0A, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF555555, 0xFFBFBFBF, 
        0xFFBFBFBF, 0xFFBFBFBF, 0xFFBFBFBF, 0xFFA5A5A5, 0xFF5C5C5C, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0xFF444444, 0x88434343, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x33424242, 0xDD424242, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF636363, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 
        0xFFA7A7A7, 0xFF555555, 0xFF1A1A1A, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFFB20202, 0xFFB20202, 0xFF4F0B0B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF424242, 0xFFCCCCCC, 0xFFA5A5A5, 0xFFBEBEBE, 
        0xFFBEBEBE, 0xFF363636, 0xFF111111, 0xFF424242, 0xFFCCCCCC, 0xFFA5A5A5, 0xFF111111, 0xFF111111, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF292929, 0xFF111111, 0xFF8D8D8D, 0xFFCCCCCC, 0xFF424242, 0xFF424242, 0xFFCCCCCC, 0xFFA5A5A5, 0xFF111111, 0xFF111111, 
        0xFFA5A5A5, 0xFFCCCCCC, 0xFF363636, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF420C0C, 0xFF990404, 0xFFB20202, 0xFF5B0A0A, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF444444, 0xFF949494, 0xFFC0C0C0, 0xFFC0C0C0, 
        0xFFC0C0C0, 0xFFC0C0C0, 0xFF686868, 0xFF484848, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xEE424242, 0x44424242, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xAA424242, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF4E4E4E, 0xFF797979, 0xFFC0C0C0, 0xFFC0C0C0, 
        0xFFC0C0C0, 0xFFC0C0C0, 0xFF949494, 0xFF444444, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFF990404, 0xFFB20202, 0xFF670909, 0xFF1D0F0F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF424242, 0xFFCCCCCC, 0xFFCCCCCC, 0xFFCCCCCC, 
        0xFFBEBEBE, 0xFF292929, 0xFF111111, 0xFF424242, 0xFFCCCCCC, 0xFF808080, 0xFF111111, 0xFF111111, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF111111, 0xFF111111, 0xFF808080, 0xFFCCCCCC, 0xFF424242, 0xFF424242, 0xFFCCCCCC, 0xFF808080, 0xFF111111, 0xFF111111, 
        0xFF999999, 0xFFCCCCCC, 0xFF424242, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFFB20202, 0xFFB20202, 0xFF4F0B0B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF3D3D3D, 0xFF949494, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 0xFFC0C0C0, 
        0xFF848484, 0xFF535353, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xFF434343, 0xBB424242, 0x11424242, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x55414141, 0xEE414141, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF555555, 0xFF949494, 
        0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFF959595, 0xFF454545, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF360D0D, 0xFF8D0505, 0xFFBE0101, 0xFF800606, 0xFF360D0D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF424242, 0xFFCCCCCC, 0xFFB2B2B2, 0xFF747474, 
        0xFFCCCCCC, 0xFFA5A5A5, 0xFF111111, 0xFF424242, 0xFFCCCCCC, 0xFF808080, 0xFF111111, 0xFF111111, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF111111, 0xFF111111, 0xFF808080, 0xFFCCCCCC, 0xFF424242, 0xFF424242, 0xFFCCCCCC, 0xFF808080, 0xFF111111, 0xFF111111, 
        0xFF999999, 0xFFCCCCCC, 0xFF424242, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF290E0E, 0xFF740707, 0xFFBE0101, 0xFF8D0505, 0xFF420C0C, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF3D3D3D, 0xFF959595, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFFC1C1C1, 0xFF949494, 0xFF5B5B5B, 
        0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0xFF424242, 0x77414141, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22404040, 0xBB404040, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 
        0xFF5A5A5A, 0xFF949494, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFA9A9A9, 0xFF565656, 0xFF1A1A1A, 0xFF111111, 0xFF111111, 0xFF1D0F0F, 0xFF670909, 0xFFB20202, 0xFFA50303, 0xFF670909, 0xFF1D0F0F, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF424242, 0xFFCCCCCC, 0xFF808080, 0xFF111111, 
        0xFF999999, 0xFFCCCCCC, 0xFF747474, 0xFF424242, 0xFFCCCCCC, 0xFF808080, 0xFF111111, 0xFF111111, 0xFFCCCCCC, 0xFFCCCCCC, 0xFF111111, 0xFF111111, 0xFF808080, 0xFFCCCCCC, 0xFF424242, 0xFF424242, 0xFFCCCCCC, 0xFF808080, 0xFF111111, 0xFF111111, 
        0xFF999999, 0xFFCCCCCC, 0xFF424242, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF1D0F0F, 0xFF4F0B0B, 0xFF990404, 0xFFBE0101, 0xFF740707, 0xFF290E0E, 0xFF111111, 0xFF111111, 0xFF1A1A1A, 0xFF454545, 0xFF969696, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFC2C2C2, 0xFFA7A7A7, 0xFF5E5E5E, 0xFF414141, 0xFF414141, 
        0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xCC404040, 0x33404040, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x66404040, 0xEE404040, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 
        0xFF414141, 0xFF414141, 0xFF5B5B5B, 0xFF959595, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFF606060, 0xFF2D2D2D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF420C0C, 0xFF8D0505, 0xFFBE0101, 0xFF990404, 0xFF5B0A0A, 0xFF1D0F0F, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF363636, 0xFFCCCCCC, 0xFF808080, 0xFF111111, 
        0xFF292929, 0xFFBEBEBE, 0xFF999999, 0xFF363636, 0xFFCCCCCC, 0xFF808080, 0xFF111111, 0xFF111111, 0xFFB2B2B2, 0xFFBEBEBE, 0xFF111111, 0xFF111111, 0xFF747474, 0xFFCCCCCC, 0xFF363636, 0xFF363636, 0xFFCCCCCC, 0xFF808080, 0xFF111111, 0xFF111111, 
        0xFF8D8D8D, 0xFFCCCCCC, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D0F0F, 0xFF4F0B0B, 
        0xFF8D0505, 0xFFBE0101, 0xFF8D0505, 0xFF4F0B0B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF242424, 0xFF565656, 0xFFAAAAAA, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFA8A8A8, 0xFF646464, 0xFF464646, 0xFF414141, 0xFF414141, 0xFF414141, 
        0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0xFF414141, 0x88404040, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x223F3F3F, 0xAA3F3F3F, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 
        0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF5A5A5A, 0xFF959595, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFF868686, 0xFF3E3E3E, 0xFF1B1B1B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF4F0B0B, 0xFF8D0505, 0xFFBE0101, 
        0xFF990404, 0xFF670909, 0xFF360D0D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF1D1D1D, 0xFF1D1D1D, 0xFF111111, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D1D1D, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF292929, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF1D1D1D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF290E0E, 0xFF5B0A0A, 0xFF8D0505, 0xFFBE0101, 0xFF8D0505, 
        0xFF4F0B0B, 0xFF1D0F0F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF3E3E3E, 0xFF6B6B6B, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFC3C3C3, 0xFFA8A8A8, 0xFF636363, 0xFF454545, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 
        0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xFF404040, 0xCC3F3F3F, 0x333F3F3F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x443E3E3E, 0xDD3E3E3E, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 
        0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF565656, 0xFF858585, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFAAAAAA, 0xFF6C6C6C, 0xFF353535, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF4F0B0B, 0xFF800606, 0xFFB20202, 0xFFB20202, 0xFF800606, 0xFF4F0B0B, 0xFF290E0E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF1D0F0F, 0xFF4F0B0B, 0xFF800606, 0xFFB20202, 0xFFBE0101, 0xFF8D0505, 0xFF4F0B0B, 0xFF1D0F0F, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF2D2D2D, 0xFF575757, 0xFFAAAAAA, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFFC4C4C4, 0xFF959595, 0xFF595959, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 
        0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xEE3E3E3E, 0x663E3E3E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x773E3E3E, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 
        0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF4F4F4F, 0xFF6F6F6F, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFABABAB, 0xFF616161, 0xFF363636, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF360D0D, 0xFF5B0A0A, 0xFF8D0505, 0xFFBE0101, 0xFFB20202, 0xFF8D0505, 0xFF670909, 0xFF420C0C, 0xFF1D0F0F, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF360D0D, 0xFF5B0A0A, 0xFF800606, 0xFFB20202, 0xFFBE0101, 0xFF990404, 0xFF670909, 0xFF360D0D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF2E2E2E, 
        0xFF575757, 0xFF989898, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFFC5C5C5, 0xFF6F6F6F, 0xFF565656, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 
        0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0xFF3F3F3F, 0x993E3E3E, 0x113E3E3E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x223D3D3D, 0x993D3D3D, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 
        0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF444444, 0xFF5C5C5C, 0xFF979797, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFACACAC, 
        0xFF626262, 0xFF3E3E3E, 0xFF1B1B1B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF290E0E, 0xFF5B0A0A, 0xFF800606, 0xFFA50303, 0xFFCC0000, 0xFFB20202, 0xFF8D0505, 0xFF740707, 0xFF5B0A0A, 0xFF420C0C, 0xFF290E0E, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF290E0E, 0xFF360D0D, 0xFF4F0B0B, 0xFF740707, 0xFF8D0505, 0xFFB20202, 0xFFCC0000, 0xFFA50303, 0xFF800606, 0xFF5B0A0A, 0xFF360D0D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF363636, 0xFF626262, 0xFF999999, 0xFFC6C6C6, 
        0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFF969696, 0xFF616161, 0xFF4A4A4A, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 0xFF3E3E3E, 
        0xFF3E3E3E, 0xFF3E3E3E, 0xBB3D3D3D, 0x333D3D3D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x333C3C3C, 0xBB3C3C3C, 0xFF3D3D3D, 0xFF3D3D3D, 
        0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF4E4E4E, 0xFF666666, 0xFFAAAAAA, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 
        0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFF797979, 0xFF585858, 0xFF363636, 0xFF1B1B1B, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF290E0E, 0xFF4F0B0B, 0xFF670909, 0xFF800606, 0xFF990404, 0xFFB20202, 0xFFCC0000, 0xFFB20202, 
        0xFFB20202, 0xFF8D0505, 0xFF8D0505, 0xFF800606, 0xFF740707, 0xFF740707, 0xFF740707, 0xFF740707, 0xFF740707, 0xFF790606, 0xFF740707, 0xFF740707, 0xFF740707, 0xFF740707, 0xFF740707, 0xFF8D0505, 0xFF8D0505, 0xFFB20202, 0xFFB20202, 0xFFCC0000, 
        0xFFB20202, 0xFFA50303, 0xFF8D0505, 0xFF740707, 0xFF4F0B0B, 0xFF360D0D, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF2E2E2E, 0xFF4F4F4F, 0xFF797979, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 0xFFC6C6C6, 
        0xFFC6C6C6, 0xFFC6C6C6, 0xFFAAAAAA, 0xFF6E6E6E, 0xFF525252, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 
        0xCC3C3C3C, 0x443C3C3C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x443B3B3B, 0xBB3B3B3B, 
        0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF515151, 0xFF666666, 0xFFAAAAAA, 0xFFC7C7C7, 
        0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFF898989, 0xFF626262, 0xFF474747, 0xFF2E2E2E, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF290E0E, 
        0xFF360D0D, 0xFF4F0B0B, 0xFF4F0B0B, 0xFF5B0A0A, 0xFF740707, 0xFF740707, 0xFF740707, 0xFF740707, 0xFF740707, 0xFF790606, 0xFF740707, 0xFF740707, 0xFF740707, 0xFF740707, 0xFF670909, 0xFF4F0B0B, 0xFF4F0B0B, 0xFF360D0D, 0xFF290E0E, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF252525, 0xFF3E3E3E, 0xFF585858, 0xFF7A7A7A, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFAAAAAA, 
        0xFF6D6D6D, 0xFF545454, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xDD3B3B3B, 0x553B3B3B, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x443B3B3B, 0xBB3B3B3B, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF4E4E4E, 
        0xFF626262, 0xFF868686, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFF9A9A9A, 0xFF6E6E6E, 0xFF585858, 0xFF3E3E3E, 0xFF2E2E2E, 0xFF252525, 0xFF111111, 0xFF111111, 
        0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 0xFF111111, 
        0xFF1B1B1B, 0xFF2E2E2E, 0xFF3E3E3E, 0xFF585858, 0xFF6E6E6E, 0xFF8A8A8A, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFFC8C8C8, 0xFF989898, 0xFF606060, 0xFF515151, 0xFF3C3C3C, 
        0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xFF3C3C3C, 0xDD3B3B3B, 0x553B3B3B, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x333A3A3A, 0xAA3A3A3A, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 
        0xFF3B3B3B, 0xFF3B3B3B, 0xFF414141, 0xFF545454, 0xFF666666, 0xFF979797, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFF9B9B9B, 
        0xFF9B9B9B, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF636363, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF5D5D5D, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF585858, 0xFF6E6E6E, 0xFF6E6E6E, 0xFF8A8A8A, 0xFF9B9B9B, 0xFFC9C9C9, 
        0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFF969696, 0xFF666666, 0xFF575757, 0xFF484848, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 
        0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xFF3B3B3B, 0xBB3A3A3A, 0x443A3A3A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22393939, 0x88393939, 0xEE393939, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 
        0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF404040, 0xFF505050, 0xFF5A5A5A, 0xFF6D6D6D, 0xFF969696, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 
        0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 
        0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFFC9C9C9, 0xFF969696, 0xFF787878, 0xFF5F5F5F, 0xFF535353, 0xFF404040, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 
        0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xAA393939, 0x33393939, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x66393939, 0xCC393939, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 
        0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF404040, 0xFF4C4C4C, 0xFF535353, 0xFF5F5F5F, 0xFF6D6D6D, 0xFF868686, 0xFFADADAD, 0xFFCACACA, 0xFFCACACA, 
        0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 
        0xFFADADAD, 0xFF989898, 0xFF6D6D6D, 0xFF5F5F5F, 0xFF565656, 0xFF505050, 0xFF404040, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 
        0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xFF3A3A3A, 0xDD393939, 0x77393939, 0x11393939, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33383838, 0x88383838, 0xEE383838, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 
        0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF464646, 
        0xFF4D4D4D, 0xFF525252, 0xFF525252, 0xFF5A5A5A, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF656565, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF616161, 0xFF5A5A5A, 0xFF525252, 0xFF525252, 0xFF4B4B4B, 0xFF4D4D4D, 0xFF393939, 
        0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 
        0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xFF393939, 0xEE383838, 0xAA383838, 0x44383838, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x54383838, 0xA9383838, 0xED383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 
        0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 
        0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 
        0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 
        0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xA9383838, 0x54383838, 0x10383838, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x54383838, 0x98383838, 0xED383838, 0xFF383838, 0xFF383838, 
        0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 
        0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 
        0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 0xFF383838, 
        0xED383838, 0xA9383838, 0x54383838, 0x10383838, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x32373737, 0x87373737, 
        0xCB373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 
        0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 
        0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xFF373737, 0xDC373737, 0x87373737, 0x43373737, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x10363636, 0x43363636, 0x87363636, 0xCB363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 
        0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 
        0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xCB363636, 0x98363636, 0x54363636, 0x10363636, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x32363636, 0x65363636, 0x98363636, 0xCB363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 
        0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 
        0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xFF363636, 0xDC363636, 0xA9363636, 0x76363636, 0x43363636, 0x10363636, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x21353535, 0x54353535, 0x76353535, 0x98353535, 0xBA353535, 0xDC353535, 0xFF353535, 0xFF353535, 0xFF353535, 
        0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 0xFF353535, 
        0xFF353535, 0xDC353535, 0xBA353535, 0x98353535, 0x87353535, 0x54353535, 0x32353535, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x32343434, 
        0x32343434, 0x54343434, 0x54343434, 0x76343434, 0x87343434, 0x87343434, 0x87343434, 0x87343434, 0x87343434, 0x8E343434, 0x87343434, 0x87343434, 0x87343434, 0x87343434, 0x87343434, 0x54343434, 0x54343434, 0x43343434, 0x32343434, 0x10343434, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
#else
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDECCCCCC, 0xABCCCCCC, 0x9ACCCCCC, 0x78CCCCCC, 0x56CCCCCC, 0x34CCCCCC, 0x23CCCCCC, 0x00CCCCCC, 
        0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x01CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x23CCCCCC, 
        0x23CCCCCC, 0x56CCCCCC, 0x67CCCCCC, 0x89CCCCCC, 0xABCCCCCC, 0xCDCCCCCC, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEFCCCCCC, 0xBCCCCCCC, 0x89CCCCCC, 0x56CCCCCC, 0x34CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 
        0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x01CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 
        0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x23CCCCCC, 0x56CCCCCC, 0x89CCCCCC, 0xBCCCCCCC, 0xEFCCCCCC, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xDECBCBCB, 0x9ACBCBCB, 0x67CBCBCB, 0x23CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 
        0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x01CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 
        0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x23CBCBCB, 0x56CBCBCB, 0x9ACBCBCB, 0xCDCBCBCB, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEFCACACA, 0xABCACACA, 
        0x67CACACA, 0x23CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00C8C8C8, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x12CACACA, 0x56CACACA, 0x9ACACACA, 0xEFCACACA, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDECACACA, 0x89CACACA, 0x45CACACA, 0x00CACACA, 0x00CACACA, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00C8C8C8, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 
        0x34CACACA, 0x78CACACA, 0xCDCACACA, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDEC9C9C9, 0x89C9C9C9, 0x34C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 
        0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 
        0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C7C7C7, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 
        0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 
        0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x23C9C9C9, 0x78C9C9C9, 0xCDC9C9C9, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEFC8C8C8, 0x9AC8C8C8, 0x34C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 
        0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 
        0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 
        0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 
        0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x23C8C8C8, 0x89C8C8C8, 0xEFC8C8C8, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCCC7C7C7, 0x55C7C7C7, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 
        0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00BDBDBD, 0x00B2B2B2, 0x00ABABAB, 0x009C9C9C, 0x00909090, 0x00848484, 0x00636363, 0x00333333, 
        0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00636363, 
        0x00767676, 0x00909090, 0x009C9C9C, 0x00A8A8A8, 0x00B2B2B2, 0x00BDBDBD, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 
        0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x55C7C7C7, 0xAAC7C7C7, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99C6C6C6, 0x33C6C6C6, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 
        0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00B6B6B6, 0x00AAAAAA, 0x009E9E9E, 0x008F8F8F, 0x00646464, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 
        0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 
        0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x004E4E4E, 0x00848484, 0x009E9E9E, 0x00AAAAAA, 0x00B6B6B6, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 
        0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x22C6C6C6, 0x88C6C6C6, 0xEEC6C6C6, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xEEC5C5C5, 0x77C5C5C5, 0x11C5C5C5, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 
        0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00AFAFAF, 0x00A6A6A6, 0x008F8F8F, 0x00646464, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 
        0x00343434, 0x003C3C3C, 0x003C3C3C, 0x00434343, 0x00454545, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x003F3F3F, 0x00393939, 0x00393939, 0x00343434, 0x00343434, 0x00343434, 
        0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x004F4F4F, 0x00848484, 0x00A2A2A2, 0x00B0B0B0, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 
        0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x11C5C5C5, 0x66C5C5C5, 0xDDC5C5C5, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xDDC5C5C5, 0x66C5C5C5, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00BCBCBC, 
        0x00AAAAAA, 0x00989898, 0x004F4F4F, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x003F3F3F, 0x004A4A4A, 0x004F4F4F, 0x00525252, 0x00565656, 0x00585858, 0x005F5F5F, 
        0x005F5F5F, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005A5A5A, 0x00585858, 0x00585858, 0x00585858, 0x00575757, 0x00575757, 0x00565656, 0x00545454, 0x00535353, 0x00535353, 0x00505050, 0x00505050, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x00484848, 
        0x00474747, 0x00454545, 0x00414141, 0x003F3F3F, 0x003A3A3A, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x004F4F4F, 0x008F8F8F, 0x00A7A7A7, 0x00BCBCBC, 0x00C6C6C6, 
        0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x55C5C5C5, 0xCCC5C5C5, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDDC4C4C4, 0x66C4C4C4, 
        0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00BBBBBB, 0x00A6A6A6, 0x00848484, 0x00353535, 
        0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x003A3A3A, 0x004A4A4A, 0x00525252, 0x00595959, 0x005D5D5D, 0x00646464, 0x00646464, 0x00636363, 0x00636363, 0x00616161, 0x00606060, 0x005F5F5F, 0x005F5F5F, 
        0x005F5F5F, 0x0050506B, 0x00494971, 0x00424278, 0x003B3B7F, 0x003A3A7E, 0x003A3A7E, 0x0039397D, 0x0039397D, 0x00343480, 0x0038387C, 0x0038387C, 0x0037377A, 0x0037377A, 0x003B3B71, 0x003F3F68, 0x003F3F68, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 
        0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 0x00494949, 0x00484848, 0x00454545, 0x00414141, 0x003D3D3D, 0x003A3A3A, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00767676, 
        0x00A2A2A2, 0x00B4B4B4, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x55C4C4C4, 0xCCC4C4C4, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEEC3C3C3, 0x77C3C3C3, 0x00C4C4C4, 0x00C4C4C4, 
        0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00BABABA, 0x00A5A5A5, 0x00848484, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 
        0x00363636, 0x00363636, 0x00363636, 0x003C3C3C, 0x004E4E4E, 0x005A5A5A, 0x00606060, 0x006A6A6A, 0x006A6A6A, 0x00696969, 0x00676767, 0x00666666, 0x00646464, 0x00565671, 0x00414185, 0x00333392, 0x002626A0, 0x001F1FA7, 0x000C0CBC, 0x000606C3, 
        0x000000CC, 0x000C0CBC, 0x000C0CBC, 0x001818AD, 0x001D1DA5, 0x001D1DA4, 0x001D1DA4, 0x001C1CA4, 0x001C1CA4, 0x001818A8, 0x001C1CA3, 0x001C1CA3, 0x001B1BA3, 0x001B1BA3, 0x001515AA, 0x000A0ABA, 0x000A0ABA, 0x000000CC, 0x000000CC, 0x000A0ABA, 
        0x001414A9, 0x001E1E98, 0x00282887, 0x00313175, 0x003A3A63, 0x00484848, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00434343, 0x003F3F3F, 0x003D3D3D, 0x003A3A3A, 0x00373737, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 
        0x00363636, 0x00363636, 0x00767676, 0x00A1A1A1, 0x00B3B3B3, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 
        0x55C3C3C3, 0xDDC3C3C3, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x88C2C2C2, 0x11C2C2C2, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 
        0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00A8A8A8, 0x008E8E8E, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 
        0x00484848, 0x00585858, 0x00636363, 0x006D6D6D, 0x006C6C6C, 0x006B6B6B, 0x006A6A6A, 0x006A6A6A, 0x0053537C, 0x003D3D8E, 0x002929A2, 0x001414B6, 0x000000CC, 0x000D0DBD, 0x002020A8, 0x002D2D99, 0x0039398B, 0x003F3F83, 0x004C4C75, 0x00585865, 
        0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 0x005B5B5B, 0x00585858, 0x00585858, 0x00575757, 0x00575757, 0x00565656, 0x00555555, 0x00555555, 0x00535353, 0x00535353, 0x00535353, 0x00515151, 0x00505050, 0x004E4E4E, 0x004D4D4D, 0x003D3D66, 
        0x0038386E, 0x002E2E7F, 0x0023238F, 0x001818A0, 0x000909B9, 0x000000CC, 0x000909B9, 0x0017179E, 0x00242482, 0x00313167, 0x00444444, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x003D3D3D, 0x003A3A3A, 0x00383838, 0x00373737, 0x00373737, 
        0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00838383, 0x00A8A8A8, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 
        0x00C3C3C3, 0x00C3C3C3, 0x77C2C2C2, 0xEEC2C2C2, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAAC2C2C2, 0x22C2C2C2, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 
        0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00B9B9B9, 0x00A1A1A1, 0x00666666, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x004F4F4F, 0x005F5F5F, 0x006B6B6B, 
        0x006F6F6F, 0x006F6F6F, 0x006E6E6E, 0x006D6D6D, 0x004E4E85, 0x0031319E, 0x001C1CB1, 0x000000CC, 0x001414B7, 0x002929A2, 0x003D3D8E, 0x0052527A, 0x00646464, 0x00636363, 0x00626262, 0x00616161, 0x00616161, 0x00606060, 0x00606060, 0x005F5F5F, 
        0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 0x005A5A5A, 0x00585858, 0x00585858, 0x00585858, 0x00565656, 0x00565656, 0x00545454, 0x00545454, 0x00535353, 0x00535353, 0x00525252, 0x00505050, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 
        0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 0x00494949, 0x00494949, 0x00484848, 0x00373760, 0x0029297B, 0x001B1B95, 0x000D0DB0, 0x000000CC, 0x000D0DAF, 0x001E1E8B, 0x002F2F65, 0x003B3B49, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x00393939, 0x00383838, 
        0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00515151, 0x009C9C9C, 0x00B3B3B3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 
        0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x11C2C2C2, 0x99C2C2C2, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDDC1C1C1, 0x44C1C1C1, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 
        0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00ACACAC, 0x008E8E8E, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x004A4A4A, 0x00606060, 0x006C6C6C, 0x00727272, 0x00707070, 0x00707070, 
        0x005F5F7A, 0x00424293, 0x001C1CB1, 0x000000CC, 0x001515B7, 0x0031319D, 0x004D4D83, 0x0061616F, 0x00676767, 0x00676767, 0x00676767, 0x00656565, 0x00646464, 0x00626262, 0x00616161, 0x00616161, 0x00616161, 0x00606060, 0x005F5F5F, 0x005F5F5F, 
        0x005D5D5D, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x00585858, 0x00575757, 0x00575757, 0x00565656, 0x00555555, 0x00555555, 0x00545454, 0x00535353, 0x00525252, 0x00505050, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004D4D4D, 0x004D4D4D, 
        0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00303067, 0x00222281, 0x001111A6, 0x000000CC, 0x001010A5, 0x0020207F, 0x00303059, 0x003C3C3C, 0x003B3B3B, 
        0x003A3A3A, 0x00373737, 0x00383838, 0x00363636, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x008E8E8E, 0x00AAAAAA, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 
        0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x33C1C1C1, 0xCCC1C1C1, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x77C0C0C0, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 
        0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00A9A9A9, 0x00838383, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x003F3F3F, 0x005A5A5A, 0x00676767, 0x00727272, 0x00707070, 0x00707070, 0x0060607B, 0x003B3B9A, 0x001616B8, 
        0x000707C4, 0x002B2BA5, 0x0047478B, 0x00626270, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x00696969, 0x00676767, 0x00676767, 0x00666666, 0x00646464, 0x00646464, 0x00636363, 0x00616161, 0x00616161, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 
        0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00575757, 0x00575757, 0x00565656, 0x00555555, 0x00555555, 0x00545454, 0x00545454, 0x00535353, 0x00505050, 0x00505050, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004C4C4C, 
        0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00484848, 0x00474747, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00404040, 0x00404040, 0x003F3F3F, 0x002D2D63, 0x00181892, 0x000808B8, 0x000707B8, 0x001B1B87, 
        0x002E2E56, 0x003A3A3A, 0x00393939, 0x00393939, 0x00353535, 0x00353535, 0x00373737, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00767676, 0x00A6A6A6, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 
        0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x66C0C0C0, 0xEEC0C0C0, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCCC0C0C0, 0x22C0C0C0, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 
        0x00C1C1C1, 0x00C1C1C1, 0x00A9A9A9, 0x00848484, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x004A4A4A, 0x00606060, 0x00727272, 0x00707070, 0x00707070, 0x00686875, 0x003B3B9A, 0x001616B8, 0x000707C5, 0x002C2CA6, 0x00505086, 
        0x006D6D6D, 0x006C6C6C, 0x006B6B6B, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x00696969, 0x00686868, 0x00676767, 0x00676767, 0x00676767, 0x00646464, 0x00636363, 0x00636363, 0x00616161, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005E5E5E, 
        0x00757575, 0x00DADADA, 0x005A5A5A, 0x005A5A5A, 0x00636363, 0x00B7B7B7, 0x00D9D9D9, 0x00A8A8A8, 0x005F5F5F, 0x00555555, 0x00555555, 0x00585858, 0x009B9B9B, 0x00D8D8D8, 0x00C4C4C4, 0x00909090, 0x00545454, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 
        0x004B4B4B, 0x004B4B4B, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00414141, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x00303059, 0x001B1B87, 
        0x000707B7, 0x000707B7, 0x001A1A86, 0x0031314C, 0x00373737, 0x00363636, 0x00343434, 0x00343434, 0x00343434, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00666666, 0x00A6A6A6, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 
        0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x11C0C0C0, 0xAAC0C0C0, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x77BFBFBF, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 
        0x00ACACAC, 0x00838383, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00525252, 0x00656565, 0x006F6F6F, 0x006F6F6F, 0x00707070, 0x004A4A8E, 0x002525AC, 0x000707C5, 0x002C2CA6, 0x00505086, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 
        0x006D6D6D, 0x006D6D6D, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x00686868, 0x00686868, 0x00676767, 0x00666666, 0x00646464, 0x00646464, 0x00636363, 0x00626262, 0x00616161, 0x00606060, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x007A7A7A, 
        0x00DADADA, 0x00DADADA, 0x005A5A5A, 0x005A5A5A, 0x009E9E9E, 0x00D9D9D9, 0x00D9D9D9, 0x00D8D8D8, 0x009C9C9C, 0x00555555, 0x00545454, 0x009B9B9B, 0x00D8D8D8, 0x00D8D8D8, 0x00D8D8D8, 0x00D7D7D7, 0x008F8F8F, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 
        0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00484848, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00414141, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 
        0x00393939, 0x002D2D56, 0x001A1A86, 0x000303C1, 0x000A0AAD, 0x00232366, 0x00343434, 0x00343434, 0x00313131, 0x00313131, 0x00343434, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00656565, 0x00A6A6A6, 0x00C0C0C0, 0x00C0C0C0, 
        0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x55BFBFBF, 0xEEBFBFBF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCCBEBEBE, 0x22BEBEBE, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00B0B0B0, 0x008D8D8D, 
        0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00545454, 0x00666666, 0x006D6D6D, 0x006E6E6E, 0x00676774, 0x003A3A99, 0x000E0EBE, 0x001616B8, 0x0049498C, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 
        0x006C6C6C, 0x006B6B6B, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x00696969, 0x00686868, 0x00676767, 0x00666666, 0x00646464, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00616161, 0x00606060, 0x00606060, 0x005F5F5F, 0x00B9B9B9, 0x00DBDBDB, 
        0x00DADADA, 0x00DADADA, 0x005B5B5B, 0x005A5A5A, 0x00D9D9D9, 0x00D9D9D9, 0x005B5B5B, 0x00A8A8A8, 0x00D8D8D8, 0x00555555, 0x00535353, 0x00C5C5C5, 0x00D8D8D8, 0x005D5D5D, 0x00555555, 0x00D7D7D7, 0x00C3C3C3, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 
        0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00484848, 0x00464646, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00414141, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 
        0x003A3A3A, 0x00393939, 0x00393939, 0x00363636, 0x00232367, 0x00111199, 0x000303C1, 0x00181884, 0x002B2B46, 0x00313131, 0x00313131, 0x00303030, 0x00333333, 0x00383838, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00838383, 0x00ABABAB, 
        0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x11BEBEBE, 0xBBBEBEBE, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x88BEBEBE, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00B6B6B6, 0x009B9B9B, 0x003C3C3C, 0x003C3C3C, 
        0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x00545454, 0x00636363, 0x006B6B6B, 0x006C6C6C, 0x005E5E79, 0x002B2BA5, 0x000707C4, 0x002B2BA5, 0x0056567F, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006C6C6C, 0x006B6B6B, 0x006B6B6B, 
        0x006B6B6B, 0x006B6B6B, 0x006A6A6A, 0x006D6D6D, 0x00696969, 0x00686868, 0x00676767, 0x00646464, 0x00646464, 0x00646464, 0x00636363, 0x00626262, 0x00626262, 0x00616161, 0x00606060, 0x00606060, 0x00606060, 0x005F5F5F, 0x005D5D5D, 0x00656565, 
        0x00DADADA, 0x00DADADA, 0x005B5B5B, 0x00595959, 0x00D9D9D9, 0x00D9D9D9, 0x00575757, 0x00B5B5B5, 0x00C5C5C5, 0x00545454, 0x00535353, 0x00D8D8D8, 0x00D8D8D8, 0x00515151, 0x00505050, 0x00D7D7D7, 0x00D7D7D7, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 
        0x004B4B4B, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00525252, 0x005B5B5B, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003B3B3B, 0x003B3B3B, 
        0x003A3A3A, 0x00383838, 0x00373737, 0x00363636, 0x00363636, 0x00363636, 0x002C2C47, 0x00171784, 0x000303C0, 0x00101097, 0x0027274F, 0x00313131, 0x00303030, 0x002C2C2C, 0x00303030, 0x00383838, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 
        0x008D8D8D, 0x00B0B0B0, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x66BEBEBE, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xEEBDBDBD, 0x55BDBDBD, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00A4A4A4, 0x00676767, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 
        0x003D3D3D, 0x00515151, 0x00636363, 0x006A6A6A, 0x006A6A6A, 0x0055557D, 0x002323AA, 0x000707C4, 0x0031319D, 0x00636371, 0x006B6B6B, 0x006C6C6C, 0x006D6D6D, 0x006D6D6D, 0x006C6C6C, 0x006C6C6C, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 
        0x006F6F6F, 0x00878787, 0x00A3A3A3, 0x009C9C9C, 0x007D7D7D, 0x00666666, 0x00676767, 0x00656565, 0x00646464, 0x00646464, 0x00626262, 0x00616161, 0x00616161, 0x00616161, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005D5D5D, 0x005D5D5D, 
        0x00DADADA, 0x00DADADA, 0x005A5A5A, 0x00585858, 0x00585858, 0x00575757, 0x00707070, 0x00D8D8D8, 0x00929292, 0x00545454, 0x00535353, 0x00D8D8D8, 0x00D8D8D8, 0x00505050, 0x00505050, 0x00D7D7D7, 0x00D7D7D7, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 
        0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00545454, 0x00636363, 0x00737373, 0x009E9E9E, 0x00B4B4B4, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003B3B3B, 0x003B3B3B, 
        0x00393939, 0x00383838, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00333333, 0x00313131, 0x002D2D3B, 0x001D1D6E, 0x000606B6, 0x000C0CA1, 0x00212157, 0x002D2D2D, 0x002C2C2C, 0x002A2A2A, 0x00313131, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 
        0x003D3D3D, 0x00545454, 0x009E9E9E, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x33BDBDBD, 0xDDBDBDBD, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xCCBCBCBC, 0x22BCBCBC, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00AEAEAE, 0x00838383, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x004D4D4D, 
        0x00606060, 0x00686868, 0x00696969, 0x0053537C, 0x002222AA, 0x000E0EBE, 0x00383897, 0x00626270, 0x006A6A6A, 0x006A6A6A, 0x006B6B6B, 0x006B6B6B, 0x006C6C6C, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 0x006A6A6A, 0x006A6A6A, 0x006C6C6C, 
        0x00A3A3A3, 0x00D7D7D7, 0x00D8D8D8, 0x00D8D8D8, 0x00B9B9B9, 0x007C7C7C, 0x00666666, 0x00646464, 0x00646464, 0x00646464, 0x00636363, 0x00616161, 0x00616161, 0x00606060, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005B5B5B, 
        0x00DADADA, 0x00DADADA, 0x00595959, 0x00585858, 0x00585858, 0x00575757, 0x00A8A8A8, 0x00D8D8D8, 0x00686868, 0x00545454, 0x00545454, 0x00D8D8D8, 0x00D8D8D8, 0x00505050, 0x004F4F4F, 0x00D7D7D7, 0x00D6D6D6, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 
        0x004B4B4B, 0x004A4A4A, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00595959, 0x00949494, 0x00CBCBCB, 0x00D4D4D4, 0x00777777, 0x003E3E3E, 0x003D3D3D, 0x00464646, 0x005E5E5E, 0x006E6E6E, 0x00494949, 
        0x003A3A3A, 0x00393939, 0x00363636, 0x00363636, 0x00353535, 0x00353535, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00303030, 0x001E1E62, 0x000606B6, 0x000B0BA0, 0x00202056, 0x002B2B2B, 0x00292929, 0x002A2A2A, 0x00323232, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x00676767, 0x00AAAAAA, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x11BCBCBC, 0xAABCBCBC, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x88BCBCBC, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x009E9E9E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x00454545, 0x00595959, 0x00666666, 
        0x00676767, 0x00585874, 0x002929A2, 0x000606C4, 0x00363695, 0x00696969, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006B6B6B, 0x006B6B6B, 0x006A6A6A, 0x00767676, 0x006F6F6F, 0x00696969, 0x00696969, 0x007D7D7D, 
        0x00C1C1C1, 0x00BBBBBB, 0x00828282, 0x00868686, 0x00D7D7D7, 0x00A0A0A0, 0x00646464, 0x00646464, 0x00646464, 0x00646464, 0x00626262, 0x00616161, 0x00616161, 0x00606060, 0x00606060, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 
        0x00DADADA, 0x00DADADA, 0x00595959, 0x00585858, 0x00575757, 0x00707070, 0x00D8D8D8, 0x00929292, 0x00545454, 0x00545454, 0x00535353, 0x00D8D8D8, 0x00D8D8D8, 0x00505050, 0x004F4F4F, 0x00D7D7D7, 0x00D6D6D6, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 
        0x004B4B4B, 0x00494949, 0x00484848, 0x00484848, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00424242, 0x004B4B4B, 0x00C1C1C1, 0x00D4D4D4, 0x00525252, 0x003E3E3E, 0x00414141, 0x006C6C6C, 0x00A5A5A5, 0x00D3D3D3, 0x00D2D2D2, 
        0x006A6A6A, 0x00393939, 0x00373737, 0x00363636, 0x00363636, 0x00353535, 0x00343434, 0x00323232, 0x00313131, 0x00303030, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x001D1D61, 0x000505B5, 0x000D0D95, 0x00202049, 0x00292929, 0x00292929, 0x002A2A2A, 
        0x00373737, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x009A9A9A, 0x00B4B4B4, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x77BCBCBC, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x66BBBBBB, 
        0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00AEAEAE, 0x00777777, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x00535353, 0x00646464, 0x00646464, 0x00646464, 
        0x002E2E9B, 0x000606C4, 0x002F2F9C, 0x005F5F6D, 0x00676767, 0x00686868, 0x00696969, 0x00696969, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x00696969, 0x006F6F6F, 0x008B8B8B, 0x00B8B8B8, 0x00B8B8B8, 0x00989898, 0x007E7E7E, 0x00686868, 0x00797979, 
        0x00CCCCCC, 0x00B7B7B7, 0x00686868, 0x006B6B6B, 0x00DCDCDC, 0x00DCDCDC, 0x006A6A6A, 0x00646464, 0x00636363, 0x00636363, 0x00626262, 0x00616161, 0x00616161, 0x00606060, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 
        0x00DADADA, 0x00D9D9D9, 0x00585858, 0x00585858, 0x00575757, 0x00B6B6B6, 0x00D8D8D8, 0x005F5F5F, 0x00545454, 0x00535353, 0x00515151, 0x00D8D8D8, 0x00D8D8D8, 0x00505050, 0x004F4F4F, 0x00D7D7D7, 0x00D6D6D6, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 
        0x004B4B4B, 0x00494949, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00434343, 0x005E5E5E, 0x00D4D4D4, 0x00A0A0A0, 0x003E3E3E, 0x00404040, 0x005B5B5B, 0x00C5C5C5, 0x00B5B5B5, 0x00CFCFCF, 0x00D2D2D2, 
        0x00575757, 0x00393939, 0x003B3B3B, 0x00535353, 0x00535353, 0x00343434, 0x00343434, 0x00313131, 0x00313131, 0x00313131, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x00181869, 0x000202C0, 0x000F0F89, 0x00242431, 0x00272727, 
        0x00252525, 0x002C2C2C, 0x003A3A3A, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x00686868, 0x00A9A9A9, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x44BBBBBB, 0xEEBBBBBB, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEEBABABA, 0x33BABABA, 0x00BBBBBB, 
        0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x009D9D9D, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x004A4A4A, 0x005A5A5A, 0x00636363, 0x00636363, 0x00424286, 0x000D0DBD, 
        0x002121A8, 0x00585874, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x00686868, 0x00696969, 0x006B6B6B, 0x00696969, 0x00696969, 0x00828282, 0x00C5C5C5, 0x00DBDBDB, 0x00C2C2C2, 0x00D4D4D4, 0x00B4B4B4, 0x00676767, 0x00676767, 
        0x00C4C4C4, 0x00DCDCDC, 0x00757575, 0x00666666, 0x009C9C9C, 0x00DCDCDC, 0x00848484, 0x00636363, 0x00636363, 0x00626262, 0x00616161, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 
        0x00DADADA, 0x00D9D9D9, 0x00585858, 0x00585858, 0x007C7C7C, 0x00D8D8D8, 0x00818181, 0x00545454, 0x00545454, 0x00535353, 0x00505050, 0x00C4C4C4, 0x00D8D8D8, 0x00555555, 0x00595959, 0x00D7D7D7, 0x00D6D6D6, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 
        0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00868686, 0x00D4D4D4, 0x006C6C6C, 0x003E3E3E, 0x005F5F5F, 0x009B9B9B, 0x00A6A6A6, 0x00888888, 0x00D2D2D2, 0x00B2B2B2, 
        0x00393939, 0x00383838, 0x00808080, 0x00A5A5A5, 0x00C5C5C5, 0x00ADADAD, 0x00626262, 0x003A3A3A, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002A2A2A, 0x00262633, 0x0013137F, 0x000202C0, 0x00141473, 
        0x00252525, 0x00242424, 0x00262626, 0x00323232, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00999999, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x22BABABA, 
        0xCCBABABA, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCCB9B9B9, 0x22B9B9B9, 0x00BABABA, 0x00BABABA, 
        0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00B1B1B1, 0x008C8C8C, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00545454, 0x00616161, 0x00606060, 0x0053536E, 0x001919AE, 0x001313B6, 0x0048487E, 
        0x00646464, 0x00646464, 0x00646464, 0x00666666, 0x00676767, 0x00676767, 0x00676767, 0x00696969, 0x007F7F7F, 0x00ACACAC, 0x00676767, 0x00696969, 0x00AAAAAA, 0x00DBDBDB, 0x00828282, 0x006B6B6B, 0x00B3B3B3, 0x00D8D8D8, 0x007C7C7C, 0x00676767, 
        0x00919191, 0x00DCDCDC, 0x008F8F8F, 0x00646464, 0x007A7A7A, 0x00DCDCDC, 0x00AFAFAF, 0x00626262, 0x00616161, 0x00616161, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 
        0x00DADADA, 0x00D9D9D9, 0x00575757, 0x00575757, 0x00A8A8A8, 0x00D8D8D8, 0x00D8D8D8, 0x00D8D8D8, 0x00D8D8D8, 0x00535353, 0x00515151, 0x00909090, 0x00D7D7D7, 0x00D7D7D7, 0x00D7D7D7, 0x00D7D7D7, 0x00989898, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 
        0x00494949, 0x00494949, 0x00484848, 0x00464646, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00474747, 0x00D4D4D4, 0x00D4D4D4, 0x004B4B4B, 0x005C5C5C, 0x009F9F9F, 0x00BABABA, 0x00656565, 0x00868686, 0x00D2D2D2, 0x00717171, 
        0x00373737, 0x00585858, 0x00BCBCBC, 0x00B3B3B3, 0x009D9D9D, 0x00CCCCCC, 0x009F9F9F, 0x00464646, 0x00313131, 0x00313131, 0x00303030, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x00292929, 0x00282828, 0x001E1E46, 0x0009099E, 
        0x000707A9, 0x001B1B44, 0x00222222, 0x00212121, 0x00272727, 0x003B3B3B, 0x00414141, 0x00414141, 0x00414141, 0x00777777, 0x00ACACAC, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 
        0x11B9B9B9, 0xBBB9B9B9, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBBB9B9B9, 0x11B9B9B9, 0x00BABABA, 0x00BABABA, 0x00BABABA, 
        0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00A8A8A8, 0x00696969, 0x00414141, 0x00414141, 0x00414141, 0x00494949, 0x00585858, 0x005F5F5F, 0x005F5F5F, 0x00333391, 0x000606C4, 0x00333392, 0x00616161, 0x00616161, 
        0x00626262, 0x00646464, 0x00646464, 0x00646464, 0x00656565, 0x00646464, 0x00666666, 0x006C6C6C, 0x00A4A4A4, 0x00DCDCDC, 0x00727272, 0x00676767, 0x009B9B9B, 0x00D8D8D8, 0x00858585, 0x00676767, 0x00878787, 0x00DCDCDC, 0x009B9B9B, 0x00656565, 
        0x00737373, 0x00DCDCDC, 0x00C3C3C3, 0x00646464, 0x00646464, 0x00C8C8C8, 0x00DBDBDB, 0x006F6F6F, 0x00606060, 0x00606060, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 
        0x00D9D9D9, 0x00D9D9D9, 0x00575757, 0x00575757, 0x00C5C5C5, 0x00D8D8D8, 0x00D8D8D8, 0x00D8D8D8, 0x00D8D8D8, 0x00525252, 0x00505050, 0x00555555, 0x009A9A9A, 0x00D7D7D7, 0x00D7D7D7, 0x00989898, 0x00515151, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 
        0x00494949, 0x00494949, 0x00484848, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00676767, 0x00D4D4D4, 0x008F8F8F, 0x00525252, 0x009F9F9F, 0x00C0C0C0, 0x00737373, 0x003C3C3C, 0x00BABABA, 0x00D2D2D2, 0x004D4D4D, 
        0x00373737, 0x00858585, 0x00D0D0D0, 0x00686868, 0x003D3D3D, 0x00727272, 0x00B8B8B8, 0x00656565, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002A2A2A, 0x00282828, 0x00272727, 0x00272727, 0x00252525, 
        0x0018185C, 0x000202C0, 0x000F0F7C, 0x00222222, 0x001F1F1F, 0x00202020, 0x00313131, 0x00414141, 0x00414141, 0x00414141, 0x00575757, 0x00A2A2A2, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 
        0x00BABABA, 0x00BABABA, 0xAAB9B9B9, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBBB8B8B8, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 
        0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x009C9C9C, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00515151, 0x005E5E5E, 0x005F5F5F, 0x0052526D, 0x001212B5, 0x001919AE, 0x0052526D, 0x00616161, 0x00616161, 0x00616161, 
        0x00616161, 0x00636363, 0x00636363, 0x00636363, 0x00646464, 0x00636363, 0x00646464, 0x00828282, 0x00C3C3C3, 0x00DCDCDC, 0x008B8B8B, 0x00646464, 0x007D7D7D, 0x00DCDCDC, 0x00ABABAB, 0x00666666, 0x006C6C6C, 0x00DCDCDC, 0x00DCDCDC, 0x00676767, 
        0x00646464, 0x00B3B3B3, 0x00DCDCDC, 0x00777777, 0x00626262, 0x00929292, 0x00DBDBDB, 0x00898989, 0x00606060, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 0x00595959, 0x00585858, 
        0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00565656, 0x00555555, 0x00545454, 0x00545454, 0x00535353, 0x00535353, 0x00505050, 0x00505050, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004A4A4A, 0x00494949, 
        0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00959595, 0x00D4D4D4, 0x00646464, 0x00797979, 0x00CDCDCD, 0x00A3A3A3, 0x00565656, 0x005B5B5B, 0x00D2D2D2, 0x009D9D9D, 0x00393939, 
        0x003F3F3F, 0x00D1D1D1, 0x00D1D1D1, 0x00404040, 0x00343434, 0x00989898, 0x00C6C6C6, 0x00555555, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002A2A2A, 0x00292929, 0x00292929, 0x00272727, 0x00272727, 0x00252525, 
        0x00252525, 0x0021212F, 0x000D0D87, 0x000404B4, 0x00191942, 0x001F1F1F, 0x001E1E1E, 0x00282828, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00939393, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 
        0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x99B8B8B8, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99B7B7B7, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 
        0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x008C8C8C, 0x00434343, 0x00434343, 0x00434343, 0x00454545, 0x00545454, 0x005D5D5D, 0x005D5D5D, 0x00383889, 0x000606C3, 0x0038388A, 0x00606060, 0x00606060, 0x00616161, 0x00616161, 0x00616161, 
        0x00616161, 0x00616161, 0x00626262, 0x00636363, 0x00636363, 0x00636363, 0x00757575, 0x00A8A8A8, 0x009C9C9C, 0x00DCDCDC, 0x00BBBBBB, 0x00646464, 0x00656565, 0x00D1D1D1, 0x00DCDCDC, 0x006D6D6D, 0x00646464, 0x00A2A2A2, 0x00DCDCDC, 0x00808080, 
        0x00636363, 0x00858585, 0x00D7D7D7, 0x00999999, 0x00666666, 0x008D8D8D, 0x00D2D2D2, 0x00969696, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005D5D5D, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x00595959, 0x00585858, 0x00585858, 
        0x00585858, 0x00575757, 0x00565656, 0x00565656, 0x00555555, 0x00545454, 0x00545454, 0x00545454, 0x00525252, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x00494949, 0x00494949, 
        0x00494949, 0x00484848, 0x00474747, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x004F4F4F, 0x00D4D4D4, 0x00CBCBCB, 0x00424242, 0x009C9C9C, 0x00D3D3D3, 0x00D3D3D3, 0x00D3D3D3, 0x00BABABA, 0x00D2D2D2, 0x006C6C6C, 0x00393939, 
        0x00636363, 0x00D2D2D2, 0x00878787, 0x00353535, 0x00474747, 0x00D2D2D2, 0x00BEBEBE, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x00292929, 0x00292929, 0x00292929, 0x00272727, 0x00262626, 0x00252525, 
        0x00242424, 0x00242424, 0x00232323, 0x0018184E, 0x000202BF, 0x000D0D7A, 0x001E1E1E, 0x001C1C1C, 0x00212121, 0x00383838, 0x00434343, 0x00434343, 0x00434343, 0x00777777, 0x00AFAFAF, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 
        0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x77B7B7B7, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99B7B7B7, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 
        0x00B8B8B8, 0x00B8B8B8, 0x00AAAAAA, 0x00696969, 0x00444444, 0x00444444, 0x00444444, 0x004A4A4A, 0x00565656, 0x005B5B5B, 0x00555563, 0x001E1EA5, 0x001212B5, 0x0050506B, 0x005E5E5E, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 
        0x00606060, 0x00606060, 0x00616161, 0x00636363, 0x00626262, 0x00616161, 0x00616161, 0x00636363, 0x00686868, 0x00BBBBBB, 0x00DCDCDC, 0x00747474, 0x00646464, 0x00959595, 0x00DCDCDC, 0x00898989, 0x00646464, 0x007D7D7D, 0x00DBDBDB, 0x00A6A6A6, 
        0x00616161, 0x006A6A6A, 0x00BDBDBD, 0x00DADADA, 0x00CBCBCB, 0x00DBDBDB, 0x00BABABA, 0x00707070, 0x005F5F5F, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x00585858, 0x00575757, 
        0x00575757, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00545454, 0x00535353, 0x00535353, 0x00525252, 0x00505050, 0x00505050, 0x004F4F4F, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 
        0x00484848, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00424242, 0x005B5B5B, 0x00B7B7B7, 0x00828282, 0x003E3E3E, 0x003D3D3D, 0x00575757, 0x007D7D7D, 0x00C5C5C5, 0x00D3D3D3, 0x00D2D2D2, 0x00D2D2D2, 0x00444444, 
        0x00959595, 0x00D1D1D1, 0x005A5A5A, 0x00343434, 0x006C6C6C, 0x00D2D2D2, 0x00757575, 0x00313131, 0x00313131, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00252525, 0x00252525, 
        0x00242424, 0x00242424, 0x00222222, 0x001F1F1F, 0x001C1C2A, 0x00090991, 0x000505A8, 0x00181833, 0x001C1C1C, 0x001B1B1B, 0x002E2E2E, 0x00444444, 0x00444444, 0x00444444, 0x00585858, 0x00A6A6A6, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 
        0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x66B7B7B7, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99B6B6B6, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 
        0x00B7B7B7, 0x00A5A5A5, 0x00585858, 0x00444444, 0x00444444, 0x00444444, 0x004F4F4F, 0x00585858, 0x00585858, 0x0046466F, 0x000C0CBC, 0x002A2A96, 0x005C5C5C, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 
        0x00606060, 0x00606060, 0x00606060, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x00626262, 0x00636363, 0x00898989, 0x00DBDBDB, 0x00939393, 0x00636363, 0x00767676, 0x00DBDBDB, 0x00B8B8B8, 0x00626262, 0x00676767, 0x00D4D4D4, 0x00D0D0D0, 
        0x006A6A6A, 0x00616161, 0x007D7D7D, 0x009C9C9C, 0x00C5C5C5, 0x00ACACAC, 0x007B7B7B, 0x00626262, 0x005F5F5F, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 0x00585858, 0x00575757, 
        0x00575757, 0x00565656, 0x00555555, 0x00555555, 0x00545454, 0x00535353, 0x00535353, 0x00535353, 0x00525252, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 0x00494949, 0x00484848, 
        0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x00404040, 0x00484848, 0x003F3F3F, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x00656565, 0x00D3D3D3, 0x00B7B7B7, 0x00969696, 0x00484848, 
        0x00CCCCCC, 0x00C2C2C2, 0x00363636, 0x00353535, 0x00AAAAAA, 0x00D1D1D1, 0x004C4C4C, 0x00313131, 0x00313131, 0x002F2F2F, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00272727, 0x00252525, 0x00252525, 
        0x00242424, 0x00232323, 0x00202020, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x00111162, 0x000101BF, 0x00111155, 0x001A1A1A, 0x00191919, 0x00262626, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00A0A0A0, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 
        0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x66B6B6B6, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99B5B5B5, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 
        0x00A2A2A2, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00505050, 0x00585858, 0x00585858, 0x002E2E8D, 0x000B0BBB, 0x003B3B7F, 0x005B5B5B, 0x005B5B5B, 0x005C5C5C, 0x005B5B5B, 0x005D5D5D, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 
        0x005F5F5F, 0x00606060, 0x00606060, 0x00606060, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x006E6E6E, 0x00DBDBDB, 0x00CCCCCC, 0x00616161, 0x00626262, 0x00B8B8B8, 0x00D8D8D8, 0x007A7A7A, 0x00858585, 0x00C7C7C7, 0x00AEAEAE, 
        0x006F6F6F, 0x00606060, 0x00616161, 0x00696969, 0x006A6A6A, 0x005F5F5F, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x00595959, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00575757, 
        0x00565656, 0x00555555, 0x00555555, 0x00555555, 0x00545454, 0x00535353, 0x00535353, 0x00515151, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 0x00494949, 0x00494949, 0x00494949, 
        0x00474747, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x00939393, 0x00D2D2D2, 0x005E5E5E, 0x003C3C3C, 0x00606060, 
        0x00BCBCBC, 0x007C7C7C, 0x00393939, 0x00535353, 0x00D1D1D1, 0x00A7A7A7, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00282828, 0x00272727, 0x00262626, 0x00252525, 0x00242424, 
        0x00232323, 0x00222222, 0x00212121, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001C1C1C, 0x0016163E, 0x000303B3, 0x000A0A84, 0x00191919, 0x00161616, 0x001E1E1E, 0x003D3D3D, 0x00454545, 0x00454545, 0x00454545, 0x009D9D9D, 0x00B6B6B6, 0x00B6B6B6, 
        0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x66B5B5B5, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99B5B5B5, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x009D9D9D, 
        0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00525252, 0x00575757, 0x00585858, 0x001C1CA4, 0x001111B4, 0x004B4B67, 0x00585858, 0x005A5A5A, 0x005A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005C5C5C, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005F5F5F, 
        0x005F5F5F, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x00606060, 0x00606060, 0x00616161, 0x00616161, 0x00606060, 0x00616161, 0x00A9A9A9, 0x00DBDBDB, 0x00787878, 0x00616161, 0x00838383, 0x00BCBCBC, 0x00DADADA, 0x00DBDBDB, 0x00CBCBCB, 0x008A8A8A, 
        0x00616161, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 0x00585858, 0x00575757, 0x00575757, 0x00575757, 
        0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00535353, 0x00525252, 0x00515151, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 0x00494949, 0x00494949, 0x00484848, 
        0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 0x003B3B3B, 0x00484848, 0x00696969, 0x003C3C3C, 0x00383838, 0x00565656, 
        0x00ADADAD, 0x00ABABAB, 0x006E6E6E, 0x00888888, 0x00D1D1D1, 0x00696969, 0x00313131, 0x00313131, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00383838, 0x00383838, 
        0x00373737, 0x00363636, 0x00333333, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 0x00191926, 0x00080890, 0x000404A7, 0x00141422, 0x00151515, 0x001B1B1B, 0x00383838, 0x00464646, 0x00464646, 0x00464646, 0x00979797, 0x00B6B6B6, 
        0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x66B5B5B5, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99B4B4B4, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x009C9C9C, 0x00464646, 
        0x00464646, 0x00464646, 0x00484848, 0x00515151, 0x00565656, 0x004F4F5D, 0x001111B3, 0x001C1CA4, 0x00575757, 0x00585858, 0x00585858, 0x00585858, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005D5D5D, 0x005D5D5D, 0x005E5E5E, 
        0x005D5D5D, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00606060, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x007F7F7F, 0x00DBDBDB, 0x009C9C9C, 0x00606060, 0x00666666, 0x007A7A7A, 0x00A7A7A7, 0x009E9E9E, 0x007A7A7A, 0x005F5F5F, 
        0x005F5F5F, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005C5C5C, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 0x00585858, 0x00575757, 0x00575757, 0x00575757, 
        0x00555555, 0x00545454, 0x00545454, 0x00535353, 0x00525252, 0x00505050, 0x00505050, 0x00505050, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x00494949, 0x00484848, 0x00484848, 0x00474747, 
        0x00464646, 0x00464646, 0x00464646, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00424242, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00373737, 0x00424242, 
        0x00878787, 0x00D1D1D1, 0x00D1D1D1, 0x00C9C9C9, 0x009F9F9F, 0x00424242, 0x00313131, 0x00313131, 0x002F2F2F, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002A2A2A, 0x00292929, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00474747, 0x00B3B3B3, 
        0x00878787, 0x00959595, 0x00B9B9B9, 0x00323232, 0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x000B0B77, 0x000202B3, 0x00101039, 0x00141414, 0x00131313, 0x00333333, 0x00464646, 0x00464646, 0x00464646, 0x00919191, 
        0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x77B4B4B4, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBBB3B3B3, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00959595, 0x00474747, 0x00474747, 
        0x00474747, 0x00494949, 0x00505050, 0x00535353, 0x0043436C, 0x000505C3, 0x002D2D8C, 0x00575757, 0x00575757, 0x00585858, 0x00575757, 0x00585858, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005C5C5C, 
        0x005D5D5D, 0x005D5D5D, 0x005E5E5E, 0x005E5E5E, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00656565, 0x00DBDBDB, 0x00DBDBDB, 0x00646464, 0x00606060, 0x00616161, 0x00636363, 0x005F5F5F, 0x005F5F5F, 0x005E5E5E, 
        0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005C5C5C, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x00595959, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00575757, 0x00565656, 0x00555555, 
        0x00555555, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00505050, 0x00505050, 0x00505050, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 
        0x00454545, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x00363636, 0x00363636, 
        0x00363636, 0x00555555, 0x00757575, 0x006C6C6C, 0x004A4A4A, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x00292929, 0x00292929, 0x00272727, 0x00272727, 0x00272727, 0x00252525, 0x00292929, 0x00646464, 
        0x00CDCDCD, 0x00CDCDCD, 0x00565656, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001B1B1B, 0x00181818, 0x00181818, 0x000D0D51, 0x000101BE, 0x000D0D44, 0x00121212, 0x00111111, 0x00303030, 0x00474747, 0x00474747, 0x00474747, 
        0x008B8B8B, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x99B3B3B3, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCCB3B3B3, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00919191, 0x00484848, 0x00484848, 0x00484848, 
        0x004A4A4A, 0x00515151, 0x00535353, 0x003C3C72, 0x000505C3, 0x0038387C, 0x00555555, 0x00565656, 0x00565656, 0x00575757, 0x00575757, 0x00585858, 0x006B6B6B, 0x00656565, 0x00595959, 0x005A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 
        0x005C5C5C, 0x005B5B5B, 0x005C5C5C, 0x005C5C5C, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005F5F5F, 0x008F8F8F, 0x00888888, 0x00636363, 0x005F5F5F, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 
        0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 0x00575757, 0x00575757, 0x00575757, 0x00565656, 0x00555555, 0x00545454, 
        0x00545454, 0x00535353, 0x00535353, 0x00525252, 0x00515151, 0x00505050, 0x00505050, 0x00505050, 0x004E4E4E, 0x00C3C3C3, 0x00D7D7D7, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 
        0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x00373737, 0x00363636, 
        0x00353535, 0x00343434, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00303030, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00252525, 0x00363636, 0x00B0B0B0, 
        0x00CDCDCD, 0x00686868, 0x001F1F1F, 0x001F1F1F, 0x00363636, 0x003B3B3B, 0x001C1C1C, 0x001A1A1A, 0x00191919, 0x00181818, 0x00181818, 0x00171717, 0x000F0F38, 0x000101BE, 0x000A0A5B, 0x00111111, 0x00111111, 0x00292929, 0x00484848, 0x00484848, 
        0x00484848, 0x00828282, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0xAAB3B3B3, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCCB2B2B2, 0x11B2B2B2, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00919191, 0x00494949, 0x00494949, 0x00494949, 0x004A4A4A, 
        0x00505050, 0x00505050, 0x0037377A, 0x000B0BBB, 0x0042426A, 0x00555555, 0x00545454, 0x00555555, 0x00555555, 0x00565656, 0x005E5E5E, 0x00979797, 0x00AFAFAF, 0x00AAAAAA, 0x00828282, 0x005A5A5A, 0x005A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 
        0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005C5C5C, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 
        0x005C5C5C, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 0x00575757, 0x00565656, 0x00565656, 0x00BDBDBD, 0x00CECECE, 0x00555555, 0x00545454, 
        0x00535353, 0x00535353, 0x00535353, 0x00525252, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x004D4D4D, 0x00C3C3C3, 0x00D6D6D6, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 
        0x00454545, 0x00444444, 0x00CACACA, 0x00B6B6B6, 0x00424242, 0x00424242, 0x00424242, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00363636, 0x00363636, 0x00363636, 
        0x00353535, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002C2C2C, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00272727, 0x00262626, 0x00252525, 0x00909090, 0x00CDCDCD, 
        0x007B7B7B, 0x00222222, 0x001F1F1F, 0x00656565, 0x009A9A9A, 0x00969696, 0x00828282, 0x00292929, 0x00181818, 0x00181818, 0x00171717, 0x00161616, 0x00131313, 0x000E0E29, 0x000202B2, 0x00070774, 0x00111111, 0x00111111, 0x00292929, 0x00494949, 
        0x00494949, 0x00494949, 0x00838383, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0xBBB2B2B2, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEEB1B1B1, 0x22B1B1B1, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00939393, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x004F4F4F, 
        0x00505050, 0x002F2F81, 0x000505C3, 0x0042426A, 0x00535353, 0x00535353, 0x00545454, 0x00555555, 0x00555555, 0x00606060, 0x00AAAAAA, 0x00D4D4D4, 0x00B9B9B9, 0x00D4D4D4, 0x00D1D1D1, 0x007F7F7F, 0x00585858, 0x00585858, 0x00595959, 0x005A5A5A, 
        0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005C5C5C, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005C5C5C, 0x005D5D5D, 0x005C5C5C, 0x005C5C5C, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005C5C5C, 0x005B5B5B, 
        0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 0x00585858, 0x00575757, 0x00565656, 0x00555555, 0x00555555, 0x00ACACAC, 0x00D8D8D8, 0x00656565, 0x00535353, 
        0x00535353, 0x00535353, 0x00535353, 0x00525252, 0x00505050, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x00C4C4C4, 0x00D6D6D6, 0x004C4C4C, 0x004B4B4B, 0x004A4A4A, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00444444, 
        0x00444444, 0x004E4E4E, 0x00D4D4D4, 0x00ADADAD, 0x00424242, 0x00424242, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00363636, 0x00363636, 0x00363636, 
        0x00343434, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00282828, 0x00282828, 0x00252525, 0x00252525, 0x00787878, 0x00CDCDCD, 0x00959595, 
        0x00272727, 0x001F1F1F, 0x005C5C5C, 0x00CDCDCD, 0x00C6C6C6, 0x00A5A5A5, 0x00CCCCCC, 0x00919191, 0x002F2F2F, 0x00181818, 0x00151515, 0x00151515, 0x00131313, 0x00121212, 0x000F0F1D, 0x000202B2, 0x00060680, 0x00111111, 0x00111111, 0x00292929, 
        0x00494949, 0x00494949, 0x00494949, 0x008A8A8A, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x11B1B1B1, 0xCCB1B1B1, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x44B0B0B0, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x009A9A9A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004D4D4D, 0x004E4E4E, 
        0x002F2F81, 0x000A0ABA, 0x00454561, 0x00535353, 0x00535353, 0x00535353, 0x00545454, 0x00545454, 0x00555555, 0x00676767, 0x00C1C1C1, 0x00A8A8A8, 0x00616161, 0x00717171, 0x00D9D9D9, 0x00D9D9D9, 0x00747474, 0x00585858, 0x00585858, 0x00595959, 
        0x00595959, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005B5B5B, 0x005C5C5C, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 
        0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 0x00585858, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00565656, 0x00555555, 0x00555555, 0x00656565, 0x005C5C5C, 0x00545454, 0x00535353, 
        0x00525252, 0x00515151, 0x00505050, 0x00505050, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x00C3C3C3, 0x00D6D6D6, 0x004B4B4B, 0x00494949, 0x00494949, 0x00494949, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 
        0x00444444, 0x00444444, 0x004C4C4C, 0x00555555, 0x00414141, 0x00414141, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00373737, 0x00363636, 0x00363636, 0x00353535, 
        0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00656565, 0x00CDCDCD, 0x00B7B7B7, 0x00393939, 
        0x00202020, 0x004D4D4D, 0x00CDCDCD, 0x00CDCDCD, 0x004D4D4D, 0x00313131, 0x008B8B8B, 0x00ADADAD, 0x00414141, 0x001B1B1B, 0x00161616, 0x00141414, 0x00131313, 0x00111111, 0x00111111, 0x000F0F1D, 0x00040499, 0x00060680, 0x00111111, 0x00111111, 
        0x00292929, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x00909090, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x22B0B0B0, 0xEEB0B0B0, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x66B0B0B0, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x009B9B9B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004D4D4D, 0x004D4D4D, 0x002E2E7F, 
        0x000A0ABA, 0x004A4A57, 0x00505050, 0x00515151, 0x00505050, 0x00525252, 0x00535353, 0x00545454, 0x00555555, 0x00717171, 0x00BBBBBB, 0x00B4B4B4, 0x005C5C5C, 0x00565656, 0x007B7B7B, 0x00D9D9D9, 0x00D9D9D9, 0x00686868, 0x00585858, 0x00585858, 
        0x00585858, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 
        0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x00737373, 0x00A5A5A5, 0x007A7A7A, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00565656, 0x00565656, 0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x00535353, 0x00525252, 
        0x00505050, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x00C3C3C3, 0x00D6D6D6, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 
        0x00444444, 0x00444444, 0x00424242, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00585858, 0x00939393, 0x00555555, 0x00363636, 0x00353535, 0x00353535, 
        0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00282828, 0x00262626, 0x00565656, 0x00CDCDCD, 0x00CDCDCD, 0x00454545, 0x00222222, 
        0x003F3F3F, 0x00CDCDCD, 0x00CDCDCD, 0x008B8B8B, 0x003C3C3C, 0x00202020, 0x008F8F8F, 0x00ABABAB, 0x00494949, 0x00161616, 0x00151515, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00040499, 0x00060680, 0x00111111, 
        0x00111111, 0x002A2A2A, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x00949494, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x44B0B0B0, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x99AFAFAF, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x009E9E9E, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004A4A4A, 0x004D4D4D, 0x004D4D4D, 0x002E2E7F, 0x000A0ABA, 
        0x00484856, 0x004E4E4E, 0x004F4F4F, 0x00505050, 0x00505050, 0x00515151, 0x00676767, 0x00646464, 0x00535353, 0x00535353, 0x00989898, 0x00D5D5D5, 0x00999999, 0x00555555, 0x00565656, 0x00888888, 0x00D8D8D8, 0x00BCBCBC, 0x005F5F5F, 0x00585858, 
        0x00575757, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 
        0x00595959, 0x00585858, 0x00585858, 0x007A7A7A, 0x00D9D9D9, 0x00ADADAD, 0x00575757, 0x00575757, 0x00575757, 0x00565656, 0x00565656, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00535353, 0x00535353, 0x00535353, 0x00525252, 0x00515151, 
        0x00505050, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x00C3C3C3, 0x00D6D6D6, 0x00494949, 0x00494949, 0x00494949, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00444444, 0x00444444, 
        0x00444444, 0x00444444, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x009E9E9E, 0x00D1D1D1, 0x005F5F5F, 0x00363636, 0x00353535, 0x00343434, 
        0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00292929, 0x00272727, 0x00373737, 0x00CECECE, 0x00CDCDCD, 0x00565656, 0x00232323, 0x00313131, 
        0x00A9A9A9, 0x00CDCDCD, 0x009F9F9F, 0x00AFAFAF, 0x00C4C4C4, 0x00505050, 0x00323232, 0x00696969, 0x00171717, 0x00151515, 0x00282828, 0x002C2C2C, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00040499, 0x00060680, 
        0x00111111, 0x00111111, 0x002A2A2A, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x009A9A9A, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x77AFAFAF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xCCAEAEAE, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x009E9E9E, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004A4A4A, 0x00494949, 0x004C4C4C, 0x002E2E7F, 0x000A0ABA, 0x00474755, 
        0x004D4D4D, 0x004E4E4E, 0x004F4F4F, 0x004F4F4F, 0x00575757, 0x00969696, 0x00BABABA, 0x00BBBBBB, 0x00737373, 0x00535353, 0x005B5B5B, 0x00B8B8B8, 0x00D8D8D8, 0x00888888, 0x00555555, 0x00555555, 0x00999999, 0x00D8D8D8, 0x009F9F9F, 0x00575757, 
        0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00595959, 0x00585858, 0x00585858, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 
        0x00585858, 0x00575757, 0x00575757, 0x00575757, 0x00C7C7C7, 0x00D9D9D9, 0x005F5F5F, 0x00565656, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00545454, 0x00535353, 0x00535353, 0x00505050, 0x00505050, 0x00505050, 
        0x00505050, 0x00505050, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x00C3C3C3, 0x00D6D6D6, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 
        0x00444444, 0x00434343, 0x00424242, 0x00404040, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x00424242, 0x00C7C7C7, 0x00BDBDBD, 0x00363636, 0x00363636, 0x00343434, 0x00343434, 
        0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00272727, 0x00262626, 0x00252525, 0x004E4E4E, 0x00636363, 0x00232323, 0x00222222, 0x00868686, 
        0x00CDCDCD, 0x007F7F7F, 0x002C2C2C, 0x00626262, 0x00C7C7C7, 0x007E7E7E, 0x002C2C2C, 0x00161616, 0x00151515, 0x00464646, 0x008B8B8B, 0x008F8F8F, 0x00737373, 0x001E1E1E, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00040499, 
        0x00060680, 0x00111111, 0x00111111, 0x00323232, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x009B9B9B, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0xAAAEAEAE, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xEEAEAEAE, 0x22AEAEAE, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00A8A8A8, 0x005E5E5E, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x00484848, 0x004B4B4B, 0x00323276, 0x000505C2, 0x003D3D66, 0x004D4D4D, 
        0x004D4D4D, 0x004D4D4D, 0x004F4F4F, 0x00535353, 0x00909090, 0x00CFCFCF, 0x00C2C2C2, 0x00D7D7D7, 0x00CFCFCF, 0x00676767, 0x00535353, 0x00666666, 0x00D8D8D8, 0x00D8D8D8, 0x007A7A7A, 0x00555555, 0x005E5E5E, 0x00B9B9B9, 0x00B5B5B5, 0x00686868, 
        0x00575757, 0x00575757, 0x00575757, 0x00565656, 0x00575757, 0x00575757, 0x00575757, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00595959, 0x00585858, 0x00585858, 0x00575757, 0x00575757, 
        0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x009B9B9B, 0x00D8D8D8, 0x00898989, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00545454, 0x00545454, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00515151, 0x00505050, 0x00505050, 
        0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x00C3C3C3, 0x00D6D6D6, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 
        0x00424242, 0x00424242, 0x00424242, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x006B6B6B, 0x00D2D2D2, 0x00898989, 0x00363636, 0x00353535, 0x00353535, 0x00333333, 
        0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002A2A2A, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 0x00424242, 0x00A2A2A2, 
        0x00A7A7A7, 0x00313131, 0x001C1C1C, 0x005D5D5D, 0x00C6C6C6, 0x009E9E9E, 0x00282828, 0x00171717, 0x003F3F3F, 0x00BABABA, 0x00C2C2C2, 0x00AFAFAF, 0x00C4C4C4, 0x00858585, 0x00272727, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 
        0x000202B2, 0x00070774, 0x00111111, 0x00111111, 0x00383838, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x00A0A0A0, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x11AEAEAE, 0xDDAEAEAE, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x55ADADAD, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00797979, 0x004E4E4E, 0x004E4E4E, 0x004C4C4C, 0x00474747, 0x00494949, 0x0036366C, 0x000909BA, 0x003C3C65, 0x004C4C4C, 0x004D4D4D, 
        0x004C4C4C, 0x004D4D4D, 0x004D4D4D, 0x00545454, 0x00939393, 0x00D7D7D7, 0x006B6B6B, 0x00818181, 0x00C9C9C9, 0x007D7D7D, 0x005B5B5B, 0x00535353, 0x006F6F6F, 0x00D8D8D8, 0x00D8D8D8, 0x00717171, 0x00737373, 0x00D3D3D3, 0x00B0B0B0, 0x00626262, 
        0x00565656, 0x00565656, 0x00555555, 0x00555555, 0x00565656, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00585858, 0x00585858, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 
        0x00575757, 0x00565656, 0x00565656, 0x00555555, 0x006F6F6F, 0x00D8D8D8, 0x00BDBDBD, 0x00555555, 0x00545454, 0x00545454, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00525252, 0x00515151, 0x00505050, 0x004F4F4F, 0x004F4F4F, 
        0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x00C2C2C2, 0x00D6D6D6, 0x00484848, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 
        0x00424242, 0x00424242, 0x00414141, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00A9A9A9, 0x00D1D1D1, 0x00555555, 0x00363636, 0x00343434, 0x00343434, 0x00323232, 
        0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00282828, 0x00262626, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 0x003A3A3A, 0x009C9C9C, 
        0x00C7C7C7, 0x00525252, 0x004E4E4E, 0x00CCCCCC, 0x00CCCCCC, 0x00474747, 0x00191919, 0x00313131, 0x00B5B5B5, 0x00CBCBCB, 0x005E5E5E, 0x00303030, 0x00818181, 0x00A4A4A4, 0x00404040, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x000F0F1D, 0x000202B2, 0x000A0A5B, 0x00111111, 0x00131313, 0x003E3E3E, 0x004E4E4E, 0x004E4E4E, 0x005F5F5F, 0x00A7A7A7, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x33ADADAD, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99ACACAC, 
        0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00898989, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x00484848, 0x00484848, 0x00393962, 0x000404C2, 0x0035356B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 
        0x004B4B4B, 0x004C4C4C, 0x004D4D4D, 0x004D4D4D, 0x007E7E7E, 0x00D5D5D5, 0x00B9B9B9, 0x00757575, 0x00D3D3D3, 0x00B2B2B2, 0x00949494, 0x00545454, 0x00515151, 0x00797979, 0x00CBCBCB, 0x00D4D4D4, 0x00D5D5D5, 0x00D8D8D8, 0x00858585, 0x00545454, 
        0x00545454, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00565656, 0x00575757, 0x00565656, 0x00575757, 0x00575757, 0x005F5F5F, 0x006F6F6F, 0x00555555, 0x00565656, 0x00575757, 0x00575757, 0x00565656, 0x00565656, 
        0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00C6C6C6, 0x00D8D8D8, 0x00646464, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00525252, 0x00515151, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x004E4E4E, 
        0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00C2C2C2, 0x00D6D6D6, 0x00484848, 0x00464646, 0x00454545, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 
        0x00424242, 0x00414141, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00393939, 0x00393939, 0x004C4C4C, 0x00D2D2D2, 0x00BDBDBD, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00323232, 
        0x00313131, 0x00313131, 0x00303030, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x004D4D4D, 0x00404040, 0x002B2B2B, 0x002A2A2A, 0x00282828, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00222222, 0x00202020, 0x00666666, 
        0x00CDCDCD, 0x00C8C8C8, 0x00CACACA, 0x00CCCCCC, 0x00585858, 0x00181818, 0x001F1F1F, 0x00939393, 0x00CBCBCB, 0x006F6F6F, 0x00131313, 0x00131313, 0x00707070, 0x00A6A6A6, 0x004B4B4B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x000E0E29, 0x000101BE, 0x000C0C42, 0x00111111, 0x001B1B1B, 0x00464646, 0x004F4F4F, 0x004F4F4F, 0x00787878, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x66ACACAC, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDDACACAC, 0x00ADADAD, 
        0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00989898, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x00484848, 0x00464646, 0x0041414E, 0x000909B9, 0x002F2F73, 0x00494949, 0x004A4A4A, 0x004B4B4B, 0x004B4B4B, 
        0x004B4B4B, 0x004B4B4B, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x00898989, 0x00ADADAD, 0x00D7D7D7, 0x00D7D7D7, 0x00C1C1C1, 0x00D7D7D7, 0x00949494, 0x00505050, 0x00505050, 0x00787878, 0x00939393, 0x00A7A7A7, 0x007A7A7A, 0x00545454, 0x00545454, 
        0x00545454, 0x00555555, 0x00545454, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00565656, 0x00555555, 0x00555555, 0x00666666, 0x00CECECE, 0x00C6C6C6, 0x00555555, 0x00555555, 0x00565656, 0x00555555, 0x00555555, 0x00555555, 
        0x00555555, 0x00555555, 0x00555555, 0x00545454, 0x00535353, 0x00909090, 0x00D8D8D8, 0x009A9A9A, 0x00535353, 0x00535353, 0x00525252, 0x00515151, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 
        0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00494949, 0x005A5A5A, 0x00636363, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00414141, 
        0x00414141, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00393939, 0x00393939, 0x008A8A8A, 0x00D1D1D1, 0x007E7E7E, 0x00353535, 0x00353535, 0x00343434, 0x00323232, 0x00313131, 
        0x00313131, 0x00313131, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x00B9B9B9, 0x00C3C3C3, 0x00404040, 0x002A2A2A, 0x00282828, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00232323, 0x00222222, 0x00222222, 0x001F1F1F, 0x001F1F1F, 
        0x00595959, 0x008F8F8F, 0x00858585, 0x00606060, 0x001A1A1A, 0x00191919, 0x00787878, 0x00CBCBCB, 0x00878787, 0x00131313, 0x00131313, 0x00585858, 0x00CACACA, 0x00A4A4A4, 0x00262626, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x000D0D36, 0x000101BE, 0x000D0D36, 0x00111111, 0x001D1D1D, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x008E8E8E, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0xBBACACAC, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x33ABABAB, 0x00ACACAC, 
        0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x009E9E9E, 0x00505050, 0x00505050, 0x00505050, 0x00484848, 0x00444444, 0x00444444, 0x000D0DB0, 0x0020208C, 0x00484848, 0x00494949, 0x00494949, 0x004A4A4A, 0x00494949, 
        0x004B4B4B, 0x004B4B4B, 0x004C4C4C, 0x004D4D4D, 0x004D4D4D, 0x00505050, 0x00757575, 0x00C0C0C0, 0x00ACACAC, 0x005E5E5E, 0x00BCBCBC, 0x00D8D8D8, 0x00838383, 0x00505050, 0x00505050, 0x00545454, 0x005C5C5C, 0x00535353, 0x00535353, 0x00535353, 
        0x00535353, 0x00535353, 0x00545454, 0x00555555, 0x00555555, 0x00555555, 0x00545454, 0x00535353, 0x00545454, 0x00545454, 0x00545454, 0x00555555, 0x00B5B5B5, 0x00C6C6C6, 0x00656565, 0x00545454, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 
        0x00545454, 0x00545454, 0x00535353, 0x00535353, 0x00535353, 0x00646464, 0x00D8D8D8, 0x00C5C5C5, 0x00515151, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 
        0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004C4C4C, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00404040, 0x00404040, 
        0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00BDBDBD, 0x00D1D1D1, 0x00494949, 0x00353535, 0x00353535, 0x00333333, 0x00313131, 0x00313131, 
        0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x00414141, 0x00B9B9B9, 0x00A3A3A3, 0x002B2B2B, 0x00292929, 0x00272727, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00222222, 0x00212121, 0x001F1F1F, 0x001E1E1E, 
        0x001D1D1D, 0x00323232, 0x002A2A2A, 0x001B1B1B, 0x00191919, 0x005C5C5C, 0x00C3C3C3, 0x00A9A9A9, 0x00292929, 0x00131313, 0x00494949, 0x00CBCBCB, 0x00CCCCCC, 0x003B3B3B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x000202B2, 0x000F0F1D, 0x00111111, 0x00252525, 0x00505050, 0x00505050, 0x00505050, 0x009A9A9A, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x11ABABAB, 
        0xEEABABAB, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x77AAAAAA, 0x00ABABAB, 0x00ABABAB, 
        0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00A4A4A4, 0x006E6E6E, 0x00515151, 0x00515151, 0x004B4B4B, 0x00444444, 0x00444444, 0x0016169E, 0x0017179E, 0x00464646, 0x00464646, 0x00474747, 0x00484848, 0x00484848, 0x00494949, 
        0x004A4A4A, 0x004B4B4B, 0x004A4A4A, 0x004B4B4B, 0x004C4C4C, 0x004B4B4B, 0x00595959, 0x00BCBCBC, 0x00D7D7D7, 0x007C7C7C, 0x00656565, 0x00D7D7D7, 0x00B5B5B5, 0x00636363, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00515151, 0x00535353, 
        0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00545454, 0x00535353, 0x00545454, 0x00656565, 0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x00535353, 
        0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00525252, 0x00515151, 0x00BBBBBB, 0x00D8D8D8, 0x00747474, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 
        0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 
        0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00606060, 0x00D2D2D2, 0x00B1B1B1, 0x00343434, 0x00343434, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 
        0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x00404040, 0x00292929, 0x00282828, 0x00272727, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00232323, 0x00212121, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 
        0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 0x001A1A1A, 0x00303030, 0x00878787, 0x00CACACA, 0x003C3C3C, 0x00141414, 0x003A3A3A, 0x00CBCBCB, 0x00CCCCCC, 0x004A4A4A, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00070774, 0x000303A5, 0x00111111, 0x00111111, 0x00313131, 0x00515151, 0x00515151, 0x00616161, 0x00A0A0A0, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 
        0x55AAAAAA, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCCAAAAAA, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 
        0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00898989, 0x00525252, 0x00525252, 0x004E4E4E, 0x00424242, 0x00434343, 0x00282879, 0x000909B9, 0x00444444, 0x00444444, 0x00454545, 0x00464646, 0x00484848, 0x00484848, 0x00494949, 
        0x00494949, 0x00494949, 0x00494949, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004C4C4C, 0x00676767, 0x00D6D6D6, 0x00D6D6D6, 0x00868686, 0x00CECECE, 0x00B0B0B0, 0x005F5F5F, 0x004F4F4F, 0x004F4F4F, 0x00505050, 0x00505050, 0x00505050, 0x00515151, 
        0x00505050, 0x00525252, 0x00515151, 0x00505050, 0x00525252, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00545454, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 
        0x00535353, 0x00535353, 0x00525252, 0x00515151, 0x00505050, 0x00505050, 0x00868686, 0x00D8D8D8, 0x008E8E8E, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 
        0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00414141, 0x00404040, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00383838, 0x00747474, 0x00D1D1D1, 0x00737373, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 
        0x00313131, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00222222, 0x00222222, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 
        0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x00272727, 0x00858585, 0x00C0C0C0, 0x00474747, 0x00343434, 0x00AEAEAE, 0x00CBCBCB, 0x005C5C5C, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 0x00060680, 0x00111111, 0x00131313, 0x00414141, 0x00525252, 0x00525252, 0x00797979, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 
        0x00ABABAB, 0xAAAAAAAA, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x33A9A9A9, 0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 
        0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 0x00969696, 0x00525252, 0x00525252, 0x00525252, 0x00444444, 0x00424242, 0x0034345D, 0x000404C2, 0x003A3A55, 0x00444444, 0x00444444, 0x00444444, 0x00464646, 0x00484848, 0x00474747, 0x00484848, 
        0x00484848, 0x00484848, 0x00494949, 0x004A4A4A, 0x004B4B4B, 0x004B4B4B, 0x004C4C4C, 0x004D4D4D, 0x00737373, 0x00BCBCBC, 0x00CECECE, 0x00CACACA, 0x00858585, 0x004D4D4D, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x00505050, 
        0x004F4F4F, 0x00505050, 0x00505050, 0x00505050, 0x00515151, 0x00515151, 0x00515151, 0x00535353, 0x00535353, 0x00535353, 0x00525252, 0x00515151, 0x00525252, 0x00525252, 0x00515151, 0x00525252, 0x00535353, 0x00535353, 0x00535353, 0x00525252, 
        0x00515151, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00595959, 0x00585858, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 
        0x004A4A4A, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00474747, 0x00464646, 0x00454545, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00404040, 0x00404040, 0x00404040, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00383838, 0x00363636, 0x00363636, 0x003F3F3F, 0x003F3F3F, 0x00343434, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 
        0x00303030, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00272727, 0x00262626, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 0x00222222, 0x00212121, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 
        0x001E1E1E, 0x001C1C1C, 0x001B1B1B, 0x00191919, 0x00181818, 0x005F5F5F, 0x00CBCBCB, 0x00CBCBCB, 0x00A7A7A7, 0x00CBCBCB, 0x00707070, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x000202B2, 0x000B0B4F, 0x00111111, 0x001B1B1B, 0x00525252, 0x00525252, 0x00525252, 0x00919191, 0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 
        0x00AAAAAA, 0x11A9A9A9, 0xEEA9A9A9, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x88A8A8A8, 0x00A9A9A9, 0x00A9A9A9, 0x00A9A9A9, 0x00A9A9A9, 
        0x00A9A9A9, 0x00A9A9A9, 0x00A9A9A9, 0x009F9F9F, 0x00626262, 0x00535353, 0x00535353, 0x00484848, 0x00404040, 0x003D3D4A, 0x000808B8, 0x002D2D70, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00454545, 0x00464646, 0x00464646, 
        0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00494949, 0x004B4B4B, 0x004B4B4B, 0x004C4C4C, 0x004C4C4C, 0x006A6A6A, 0x00747474, 0x00717171, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004E4E4E, 0x004F4F4F, 0x004F4F4F, 
        0x004F4F4F, 0x004F4F4F, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00525252, 0x00515151, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00515151, 0x00525252, 0x00515151, 0x00505050, 0x00505050, 
        0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 
        0x004A4A4A, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00424242, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003C3C3C, 0x003B3B3B, 0x00393939, 0x00393939, 0x00393939, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00303030, 
        0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00212121, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 
        0x001C1C1C, 0x001B1B1B, 0x00191919, 0x00181818, 0x00181818, 0x00161616, 0x005A5A5A, 0x00999999, 0x008B8B8B, 0x00727272, 0x00141414, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000D0D36, 0x000101BE, 0x000E0E29, 0x00111111, 0x00232323, 0x00535353, 0x00535353, 0x00535353, 0x009C9C9C, 0x00A9A9A9, 0x00A9A9A9, 0x00A9A9A9, 0x00A9A9A9, 0x00A9A9A9, 
        0x00A9A9A9, 0x00A9A9A9, 0x66A8A8A8, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDDA7A7A7, 0x11A7A7A7, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 
        0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x00797979, 0x00545454, 0x00545454, 0x004D4D4D, 0x00404040, 0x00404040, 0x0015159D, 0x00191993, 0x00424242, 0x00424242, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00464646, 0x00464646, 
        0x00464646, 0x00464646, 0x00484848, 0x00484848, 0x00484848, 0x00494949, 0x00494949, 0x004B4B4B, 0x004B4B4B, 0x004C4C4C, 0x00505050, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004F4F4F, 0x004E4E4E, 
        0x004E4E4E, 0x004D4D4D, 0x004E4E4E, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 
        0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 
        0x004A4A4A, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 0x00363636, 0x00363636, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 
        0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002A2A2A, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 
        0x001B1B1B, 0x001A1A1A, 0x00191919, 0x00181818, 0x00181818, 0x00151515, 0x00131313, 0x00313131, 0x001F1F1F, 0x001E1E1E, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000A0A5B, 0x000303A5, 0x00111111, 0x00111111, 0x00373737, 0x00545454, 0x00545454, 0x006F6F6F, 0x00A2A2A2, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 
        0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0xCCA7A7A7, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x55A7A7A7, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 
        0x00A8A8A8, 0x00A8A8A8, 0x00959595, 0x00555555, 0x00555555, 0x00555555, 0x00414141, 0x003F3F3F, 0x0029296D, 0x000C0CAF, 0x00404040, 0x00404040, 0x00424242, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00464646, 0x00464646, 
        0x00464646, 0x00464646, 0x00474747, 0x00484848, 0x00484848, 0x00484848, 0x00494949, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004B4B4B, 0x004C4C4C, 0x004B4B4B, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 
        0x004D4D4D, 0x007B7B7B, 0x00B2B2B2, 0x004E4E4E, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x00505050, 0x00505050, 0x004F4F4F, 0x004F4F4F, 
        0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 
        0x00484848, 0x00484848, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00404040, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 
        0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00373737, 0x00363636, 0x00363636, 0x00353535, 0x00353535, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 
        0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00282828, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00222222, 0x00202020, 0x001E1E1E, 0x009D9D9D, 0x00565656, 0x001C1C1C, 
        0x001B1B1B, 0x001A1A1A, 0x00191919, 0x00181818, 0x00181818, 0x00151515, 0x00131313, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 0x00070774, 0x00111111, 0x00141414, 0x004A4A4A, 0x00555555, 0x00555555, 0x00909090, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 
        0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x33A7A7A7, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBBA6A6A6, 0x00A7A7A7, 0x00A7A7A7, 0x00A7A7A7, 0x00A7A7A7, 0x00A7A7A7, 0x00A7A7A7, 
        0x00A7A7A7, 0x009D9D9D, 0x00636363, 0x00555555, 0x00555555, 0x00454545, 0x003E3E3E, 0x00353550, 0x000404C1, 0x0031315A, 0x00404040, 0x00404040, 0x00424242, 0x00424242, 0x00424242, 0x00434343, 0x00444444, 0x00444444, 0x00454545, 0x00454545, 
        0x00454545, 0x00464646, 0x00464646, 0x00484848, 0x00484848, 0x00484848, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x004B4B4B, 0x004B4B4B, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 
        0x004D4D4D, 0x00A9A9A9, 0x00D6D6D6, 0x00A8A8A8, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004E4E4E, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 
        0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 
        0x00484848, 0x00484848, 0x00464646, 0x00454545, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 
        0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00353535, 0x00343434, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002E2E2E, 0x002E2E2E, 
        0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00282828, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00232323, 0x00212121, 0x00202020, 0x001E1E1E, 0x00929292, 0x00CDCDCD, 0x00919191, 0x001B1B1B, 
        0x001A1A1A, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00151515, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x000101BE, 0x000D0D36, 0x00111111, 0x00222222, 0x00555555, 0x00555555, 0x00555555, 0x009A9A9A, 0x00A7A7A7, 0x00A7A7A7, 0x00A7A7A7, 
        0x00A7A7A7, 0x00A7A7A7, 0x00A7A7A7, 0x00A7A7A7, 0x99A6A6A6, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x22A5A5A5, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 
        0x00A6A6A6, 0x00878787, 0x00565656, 0x00565656, 0x004E4E4E, 0x003C3C3C, 0x003D3D3D, 0x001010A5, 0x0020207F, 0x003E3E3E, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x00414141, 0x00424242, 0x00424242, 0x00434343, 0x00424242, 0x00444444, 0x00444444, 
        0x00444444, 0x00464646, 0x00454545, 0x00464646, 0x00464646, 0x00464646, 0x00474747, 0x00484848, 0x00484848, 0x00494949, 0x00494949, 0x00494949, 0x004A4A4A, 0x004A4A4A, 0x004B4B4B, 0x004B4B4B, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x004C4C4C, 
        0x004C4C4C, 0x004D4D4D, 0x00BABABA, 0x00D6D6D6, 0x00969696, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 
        0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 
        0x00474747, 0x00464646, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00414141, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 
        0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00363636, 0x00363636, 0x00353535, 0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 
        0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00252525, 0x00242424, 0x00242424, 0x00232323, 0x00212121, 0x001F1F1F, 0x001F1F1F, 0x007B7B7B, 0x00CDCDCD, 0x00A8A8A8, 0x001C1C1C, 0x001A1A1A, 
        0x001A1A1A, 0x00191919, 0x00181818, 0x00171717, 0x00151515, 0x00141414, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00484848, 0x00484848, 0x00262626, 0x00151515, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000C0C42, 0x000202B2, 0x00111111, 0x00111111, 0x00383838, 0x00565656, 0x00565656, 0x006F6F6F, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 
        0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x11A5A5A5, 0xEEA5A5A5, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99A5A5A5, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 
        0x00979797, 0x00575757, 0x00575757, 0x00575757, 0x003D3D3D, 0x003B3B3B, 0x00232375, 0x000C0CAE, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x00404040, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00434343, 0x00444444, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00454545, 0x00464646, 0x00484848, 0x00474747, 0x00484848, 0x00484848, 0x00494949, 0x00494949, 0x00494949, 0x004A4A4A, 0x004A4A4A, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 
        0x004B4B4B, 0x004C4C4C, 0x00555555, 0x00C3C3C3, 0x00D6D6D6, 0x00838383, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 
        0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 
        0x00464646, 0x00464646, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00414141, 0x00414141, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003C3C3C, 
        0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x00383838, 0x00363636, 0x00363636, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 
        0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00282828, 0x00272727, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 0x00222222, 0x001F1F1F, 0x00646464, 0x00CDCDCD, 0x00B4B4B4, 0x00272727, 0x001C1C1C, 0x001B1B1B, 
        0x00191919, 0x00181818, 0x00171717, 0x00161616, 0x00131313, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00363636, 0x00B6B6B6, 0x007C7C7C, 0x00505050, 0x00313131, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00060680, 0x00070774, 0x00111111, 0x00181818, 0x004C4C4C, 0x00575757, 0x00575757, 0x00929292, 0x00A6A6A6, 0x00A6A6A6, 
        0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x77A5A5A5, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x22A4A4A4, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 
        0x00707070, 0x00575757, 0x00575757, 0x00454545, 0x003A3A3A, 0x0032324E, 0x000303C1, 0x00303059, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x00404040, 0x00414141, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00444444, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00464646, 0x00464646, 0x00464646, 0x00474747, 0x00484848, 0x00484848, 0x00484848, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00494949, 0x004A4A4A, 0x004B4B4B, 
        0x004B4B4B, 0x004A4A4A, 0x004B4B4B, 0x00676767, 0x00CCCCCC, 0x00D6D6D6, 0x00707070, 0x004C4C4C, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004D4D4D, 0x004D4D4D, 
        0x004C4C4C, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 
        0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 
        0x003B3B3B, 0x00393939, 0x00393939, 0x00393939, 0x00383838, 0x00373737, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 
        0x002D2D2D, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00272727, 0x00272727, 0x00252525, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00222222, 0x001F1F1F, 0x004D4D4D, 0x00CDCDCD, 0x00C0C0C0, 0x00404040, 0x001C1C1C, 0x001C1C1C, 0x00191919, 
        0x00181818, 0x00181818, 0x00151515, 0x00151515, 0x00141414, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x004E4E4E, 0x00BABABA, 0x00CCCCCC, 0x00C0C0C0, 0x00545454, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x000101BE, 0x000D0D36, 0x00111111, 0x00282828, 0x00575757, 0x00575757, 0x00656565, 0x009B9B9B, 0x00A5A5A5, 
        0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0xDDA4A4A4, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x88A3A3A3, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00919191, 
        0x00585858, 0x00585858, 0x00525252, 0x00393939, 0x003A3A3A, 0x0013139A, 0x001B1B87, 0x003C3C3C, 0x003C3C3C, 0x003D3D3D, 0x003F3F3F, 0x00454545, 0x00424242, 0x003F3F3F, 0x00404040, 0x00404040, 0x00404040, 0x00414141, 0x00404040, 0x00424242, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00454545, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00474747, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00494949, 
        0x00494949, 0x00494949, 0x004B4B4B, 0x004B4B4B, 0x006F6F6F, 0x00D6D6D6, 0x00CCCCCC, 0x00676767, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 
        0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00454545, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 
        0x003A3A3A, 0x00393939, 0x00373737, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00343434, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 
        0x002C2C2C, 0x00292929, 0x00282828, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00232323, 0x00222222, 0x00222222, 0x00212121, 0x00414141, 0x00C0C0C0, 0x00CDCDCD, 0x004A4A4A, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x00191919, 
        0x00181818, 0x00181818, 0x00161616, 0x00141414, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00353535, 
        0x00818181, 0x00CCCCCC, 0x00CCCCCC, 0x007F7F7F, 0x00343434, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x000303A5, 0x00111111, 0x00111111, 0x00454545, 0x00585858, 0x00585858, 0x00878787, 0x00A4A4A4, 
        0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x55A3A3A3, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEEA3A3A3, 0x11A3A3A3, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x009A9A9A, 0x00656565, 
        0x00595959, 0x00595959, 0x00404040, 0x00393939, 0x0029295F, 0x000707B7, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x006D6D6D, 0x00808080, 0x00949494, 0x00676767, 0x003E3E3E, 0x003F3F3F, 0x003E3E3E, 0x00404040, 0x00404040, 0x00414141, 
        0x00424242, 0x00424242, 0x00424242, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00454545, 0x00464646, 0x00454545, 0x00464646, 0x00464646, 0x00464646, 0x00474747, 0x00474747, 0x00474747, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 
        0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00828282, 0x00D6D6D6, 0x00C3C3C3, 0x00545454, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00494949, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x004A4A4A, 0x004B4B4B, 
        0x004B4B4B, 0x004B4B4B, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x00393939, 
        0x00393939, 0x00393939, 0x00373737, 0x00363636, 0x00363636, 0x00363636, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 
        0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00222222, 0x00222222, 0x002C2C2C, 0x00B5B5B5, 0x00CDCDCD, 0x00636363, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00191919, 
        0x00171717, 0x00161616, 0x00151515, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00232323, 0x00676767, 0x00CCCCCC, 
        0x00CCCCCC, 0x00A1A1A1, 0x00454545, 0x00111111, 0x00111111, 0x001E1E1E, 0x00222222, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00040499, 0x00090967, 0x00111111, 0x001F1F1F, 0x00595959, 0x00595959, 0x00595959, 0x00989898, 
        0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0xCCA3A3A3, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x77A2A2A2, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x008B8B8B, 0x005A5A5A, 
        0x005A5A5A, 0x00505050, 0x00373737, 0x00393939, 0x000707B7, 0x00252569, 0x00393939, 0x003A3A3A, 0x003B3B3B, 0x00616161, 0x00B9B9B9, 0x00C5C5C5, 0x00CECECE, 0x00D0D0D0, 0x009F9F9F, 0x005C5C5C, 0x003E3E3E, 0x003F3F3F, 0x00404040, 0x00404040, 
        0x00414141, 0x00424242, 0x00424242, 0x00434343, 0x00424242, 0x00444444, 0x00434343, 0x00444444, 0x00444444, 0x00444444, 0x00454545, 0x00464646, 0x00454545, 0x00454545, 0x00464646, 0x00464646, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 
        0x00484848, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00494949, 0x00939393, 0x00D6D6D6, 0x00B0B0B0, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00484848, 0x004A4A4A, 
        0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 
        0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x00393939, 0x00393939, 0x00393939, 
        0x00393939, 0x00393939, 0x00373737, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002A2A2A, 
        0x00292929, 0x00292929, 0x00282828, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00222222, 0x00202020, 0x009E9E9E, 0x00CDCDCD, 0x007B7B7B, 0x001D1D1D, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 
        0x00151515, 0x00151515, 0x00151515, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00535353, 0x00C5C5C5, 0x00CCCCCC, 0x00CCCCCC, 
        0x00575757, 0x00111111, 0x00111111, 0x00111111, 0x00515151, 0x00A5A5A5, 0x00777777, 0x00545454, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000D0D36, 0x000101BE, 0x000F0F1D, 0x00111111, 0x00363636, 0x005A5A5A, 0x005A5A5A, 0x00818181, 
        0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x55A2A2A2, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEEA1A1A1, 0x11A1A1A1, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00969696, 0x005A5A5A, 0x005A5A5A, 
        0x005A5A5A, 0x003C3C3C, 0x00363636, 0x00222273, 0x000F0FA4, 0x00393939, 0x00393939, 0x00393939, 0x003D3D3D, 0x00ABABAB, 0x00D1D1D1, 0x00656565, 0x005E5E5E, 0x00A5A5A5, 0x00D3D3D3, 0x00D4D4D4, 0x00878787, 0x004F4F4F, 0x00404040, 0x00404040, 
        0x00404040, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00434343, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00464646, 0x00454545, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 
        0x00474747, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00474747, 0x00484848, 0x009C9C9C, 0x00646464, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 
        0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 
        0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x00383838, 
        0x00373737, 0x00363636, 0x00363636, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 
        0x00282828, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00232323, 0x00212121, 0x00202020, 0x001F1F1F, 0x00414141, 0x00868686, 0x001E1E1E, 0x001D1D1D, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00181818, 0x00181818, 
        0x00161616, 0x00141414, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x004E4E4E, 0x00CCCCCC, 0x00CCCCCC, 0x006C6C6C, 0x00262626, 
        0x00111111, 0x00111111, 0x00313131, 0x005C5C5C, 0x00B4B4B4, 0x00CACACA, 0x00CACACA, 0x00C2C2C2, 0x002F2F2F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00070774, 0x00060680, 0x00111111, 0x00181818, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 
        0x00939393, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0xCCA1A1A1, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x77A1A1A1, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00868686, 0x005B5B5B, 0x005B5B5B, 
        0x004A4A4A, 0x00353535, 0x0032323F, 0x000303C1, 0x002B2B54, 0x00373737, 0x00383838, 0x00383838, 0x004E4E4E, 0x00A1A1A1, 0x00B2B2B2, 0x00494949, 0x003B3B3B, 0x003B3B3B, 0x006A6A6A, 0x00C7C7C7, 0x00D4D4D4, 0x00D4D4D4, 0x00717171, 0x00404040, 
        0x003F3F3F, 0x00404040, 0x00404040, 0x00414141, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00444444, 0x00444444, 0x00444444, 0x00747474, 0x009A9A9A, 0x00444444, 0x00444444, 0x00454545, 0x00464646, 0x00464646, 0x00464646, 
        0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00474747, 0x00464646, 0x00464646, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00484848, 
        0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 
        0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x00363636, 0x00363636, 
        0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 
        0x00282828, 0x00272727, 0x00272727, 0x00262626, 0x00242424, 0x00242424, 0x00232323, 0x00222222, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x00191919, 0x00181818, 0x00151515, 
        0x00151515, 0x00151515, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00808080, 0x004F4F4F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00131313, 0x00757575, 0x00393939, 0x00111111, 0x00111111, 
        0x00313131, 0x00757575, 0x009E9E9E, 0x009B9B9B, 0x00949494, 0x003E3E3E, 0x00707070, 0x00BABABA, 0x00585858, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x000101BE, 0x000D0D36, 0x00111111, 0x00313131, 0x005B5B5B, 0x005B5B5B, 
        0x00717171, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x55A1A1A1, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x11A0A0A0, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0x00959595, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 
        0x00393939, 0x00343434, 0x00181884, 0x0015158F, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x003D3D3D, 0x00898989, 0x00C3C3C3, 0x00B6B6B6, 0x00626262, 0x003B3B3B, 0x003B3B3B, 0x00464646, 0x007B7B7B, 0x00D3D3D3, 0x00B3B3B3, 0x005D5D5D, 
        0x003E3E3E, 0x003F3F3F, 0x00404040, 0x00404040, 0x00414141, 0x00404040, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00434343, 0x00ADADAD, 0x00D5D5D5, 0x00878787, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00454545, 
        0x00444444, 0x00444444, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00454545, 0x00464646, 0x00464646, 0x00464646, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 
        0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 
        0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00373737, 0x00363636, 
        0x00363636, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 
        0x00282828, 0x00262626, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 0x00222222, 0x00202020, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001A1A1A, 0x00181818, 0x00181818, 0x00181818, 0x00151515, 
        0x00151515, 0x00141414, 0x00111111, 0x00111111, 0x00111111, 0x00676767, 0x00CCCCCC, 0x00A5A5A5, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001A1A1A, 0x00616161, 
        0x00CCCCCC, 0x00CCCCCC, 0x00BEBEBE, 0x00CCCCCC, 0x007C7C7C, 0x00666666, 0x00CCCCCC, 0x00AFAFAF, 0x00434343, 0x00161616, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000A0A5B, 0x0005058D, 0x00111111, 0x00141414, 0x00515151, 0x005C5C5C, 
        0x005C5C5C, 0x00939393, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0xDDA0A0A0, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x999F9F9F, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00868686, 0x005D5D5D, 0x005D5D5D, 0x00464646, 
        0x00313131, 0x002C2C47, 0x000303C1, 0x002D2D48, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00383838, 0x004C4C4C, 0x00898989, 0x00D2D2D2, 0x00D2D2D2, 0x00979797, 0x00565656, 0x003B3B3B, 0x00414141, 0x00757575, 0x00C5C5C5, 0x00737373, 
        0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x00404040, 0x00404040, 0x00414141, 0x00414141, 0x00414141, 0x00424242, 0x00424242, 0x00424242, 0x00434343, 0x00999999, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00454545, 0x00454545, 0x00454545, 0x00444444, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00454545, 
        0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00414141, 0x00404040, 0x00404040, 
        0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00383838, 0x00363636, 0x00353535, 
        0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00292929, 0x00272727, 
        0x00272727, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001A1A1A, 0x001A1A1A, 0x00181818, 0x00181818, 0x00171717, 0x00141414, 
        0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00747474, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001B1B1B, 0x00555555, 0x00AFAFAF, 
        0x00CCCCCC, 0x005D5D5D, 0x002C2C2C, 0x00C0C0C0, 0x00CCCCCC, 0x00A7A7A7, 0x00BEBEBE, 0x00575757, 0x00151515, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000C0C42, 0x00111111, 0x002E2E2E, 0x005D5D5D, 
        0x005D5D5D, 0x00717171, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x669F9F9F, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x229E9E9E, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x00949494, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x00373737, 
        0x00313131, 0x0014148E, 0x00181884, 0x00343434, 0x00353535, 0x00353535, 0x003C3C3C, 0x00454545, 0x00424242, 0x00393939, 0x00393939, 0x005D5D5D, 0x00ACACAC, 0x00D2D2D2, 0x00D2D2D2, 0x007F7F7F, 0x004D4D4D, 0x00A8A8A8, 0x00D3D3D3, 0x00636363, 
        0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x00404040, 0x00404040, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00424242, 0x00434343, 0x00444444, 0x00444444, 0x00434343, 0x00434343, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 
        0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00383838, 0x00373737, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 
        0x00353535, 0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x00292929, 0x00292929, 0x00282828, 0x00282828, 0x00262626, 
        0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00232323, 0x00222222, 0x00222222, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x00191919, 0x00181818, 0x00171717, 0x00141414, 0x00131313, 
        0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00202020, 0x00797979, 0x00CCCCCC, 
        0x00414141, 0x003F3F3F, 0x00929292, 0x00BFBFBF, 0x007F7F7F, 0x00444444, 0x002A2A2A, 0x00111111, 0x00111111, 0x001F1F1F, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x00040499, 0x00111111, 0x00141414, 0x00525252, 
        0x005D5D5D, 0x005D5D5D, 0x00919191, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x119E9E9E, 0xEE9E9E9E, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAA9E9E9E, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x00868686, 0x005E5E5E, 0x005E5E5E, 0x00474747, 0x00313131, 
        0x002A2A45, 0x000303C0, 0x002D2D3B, 0x00323232, 0x00343434, 0x00353535, 0x00767676, 0x008B8B8B, 0x00ACACAC, 0x00565656, 0x00373737, 0x00363636, 0x00383838, 0x006C6C6C, 0x00D2D2D2, 0x00CBCBCB, 0x00D2D2D2, 0x00C4C4C4, 0x009E9E9E, 0x003C3C3C, 
        0x003D3D3D, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 0x003F3F3F, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00414141, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 
        0x00444444, 0x00434343, 0x00444444, 0x00444444, 0x00434343, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 
        0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 0x00373737, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 
        0x00343434, 0x00343434, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00272727, 
        0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 0x00222222, 0x00212121, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001B1B1B, 0x00191919, 0x00171717, 0x00161616, 0x00151515, 0x00131313, 0x00131313, 
        0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00616161, 0x00C5C5C5, 
        0x00A5A5A5, 0x00CCCCCC, 0x00CCCCCC, 0x008F8F8F, 0x00363636, 0x00111111, 0x00111111, 0x002B2B2B, 0x00636363, 0x00747474, 0x00565656, 0x001F1F1F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000C0C42, 0x00111111, 0x002E2E2E, 
        0x005E5E5E, 0x005E5E5E, 0x007A7A7A, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x889E9E9E, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x559D9D9D, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x00969696, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00373737, 0x00313131, 
        0x0013138D, 0x00161683, 0x00313131, 0x00313131, 0x00343434, 0x00646464, 0x00C8C8C8, 0x00BDBDBD, 0x00C5C5C5, 0x00414141, 0x00494949, 0x004F4F4F, 0x00373737, 0x00393939, 0x00464646, 0x00757575, 0x008C8C8C, 0x00737373, 0x00535353, 0x003B3B3B, 
        0x003B3B3B, 0x003B3B3B, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 
        0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00444444, 0x00434343, 0x00434343, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00434343, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 
        0x00434343, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 
        0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00373737, 0x00363636, 0x00363636, 0x00343434, 0x00343434, 0x00343434, 
        0x00343434, 0x00343434, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00272727, 0x00272727, 0x00252525, 
        0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00222222, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001C1C1C, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00151515, 0x00151515, 0x00151515, 0x00131313, 0x00121212, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00212121, 0x00919191, 
        0x00949494, 0x00A7A7A7, 0x004E4E4E, 0x00111111, 0x00111111, 0x00171717, 0x005C5C5C, 0x00CCCCCC, 0x00C0C0C0, 0x00C4C4C4, 0x00B3B3B3, 0x00676767, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x00040499, 0x00111111, 0x00141414, 
        0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00929292, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x229D9D9D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDD9C9C9C, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x008B8B8B, 0x00606060, 0x00606060, 0x004A4A4A, 0x00313131, 0x002D2D3B, 
        0x000303C0, 0x002A2A45, 0x00313131, 0x00313131, 0x00383838, 0x00AAAAAA, 0x00D2D2D2, 0x005D5D5D, 0x00444444, 0x005B5B5B, 0x00959595, 0x00B7B7B7, 0x008E8E8E, 0x00515151, 0x00393939, 0x00393939, 0x00424242, 0x003C3C3C, 0x003A3A3A, 0x003A3A3A, 
        0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003D3D3D, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 0x003E3E3E, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00414141, 0x00414141, 0x00414141, 
        0x00404040, 0x00404040, 0x00404040, 0x00424242, 0x00424242, 0x00414141, 0x00424242, 0x00424242, 0x00424242, 0x00434343, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00434343, 0x00424242, 0x00424242, 0x00414141, 
        0x00414141, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 
        0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x00383838, 0x00373737, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 
        0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002E2E2E, 0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 
        0x00252525, 0x00232323, 0x00222222, 0x00222222, 0x00212121, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00161616, 0x00151515, 0x00141414, 0x00131313, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00232323, 
        0x00333333, 0x001C1C1C, 0x00111111, 0x00111111, 0x004A4A4A, 0x00ABABAB, 0x00CCCCCC, 0x00CCCCCC, 0x00646464, 0x003E3E3E, 0x00CCCCCC, 0x00B5B5B5, 0x002F2F2F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000D0D36, 0x00111111, 
        0x00333333, 0x00606060, 0x00606060, 0x00858585, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0xAA9C9C9C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x779C9C9C, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x006A6A6A, 0x00606060, 0x00606060, 0x00393939, 0x002F2F2F, 0x00151582, 
        0x0012128C, 0x00303030, 0x00303030, 0x00313131, 0x00444444, 0x00929292, 0x00B0B0B0, 0x00494949, 0x00373737, 0x00AAAAAA, 0x00CCCCCC, 0x00BEBEBE, 0x00D1D1D1, 0x00D2D2D2, 0x00747474, 0x003F3F3F, 0x00393939, 0x00393939, 0x003A3A3A, 0x003A3A3A, 
        0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003D3D3D, 0x003C3C3C, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 0x003E3E3E, 0x00404040, 
        0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00414141, 0x00424242, 0x00414141, 0x00414141, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 
        0x00404040, 0x00414141, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003C3C3C, 0x003B3B3B, 
        0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00373737, 0x00363636, 0x00363636, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00323232, 0x00313131, 
        0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00252525, 0x00252525, 
        0x00242424, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x001F1F1F, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00181818, 0x00161616, 0x00151515, 0x00151515, 0x00151515, 0x00131313, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00333333, 0x00818181, 0x00CCCCCC, 0x00CCCCCC, 0x00797979, 0x00313131, 0x00111111, 0x00181818, 0x00707070, 0x00A5A5A5, 0x00444444, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000A0A5B, 0x0005058D, 0x00111111, 
        0x001D1D1D, 0x00606060, 0x00606060, 0x00606060, 0x00959595, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x559C9C9C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x119B9B9B, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x00909090, 0x00616161, 0x00616161, 0x00535353, 0x002C2C2C, 0x002D2D2D, 0x000303C0, 
        0x0024244D, 0x002E2E2E, 0x002E2E2E, 0x00313131, 0x00363636, 0x00858585, 0x00C7C7C7, 0x00C4C4C4, 0x007C7C7C, 0x00949494, 0x00949494, 0x00434343, 0x006E6E6E, 0x00D1D1D1, 0x00B9B9B9, 0x005E5E5E, 0x003A3A3A, 0x00373737, 0x00393939, 0x00393939, 
        0x00393939, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003E3E3E, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 
        0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 
        0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 
        0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 0x00383838, 0x00363636, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 
        0x00313131, 0x00313131, 0x00313131, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00242424, 0x00242424, 
        0x00242424, 0x00222222, 0x00222222, 0x00202020, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x00191919, 0x00181818, 0x00181818, 0x00151515, 0x00151515, 0x00141414, 0x00131313, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00242424, 0x007D7D7D, 0x00BEBEBE, 0x009B9B9B, 0x00414141, 0x00111111, 0x00111111, 0x00262626, 0x006D6D6D, 0x00C5C5C5, 0x008D8D8D, 0x002C2C2C, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x000101BE, 0x000E0E29, 
        0x00111111, 0x00393939, 0x00616161, 0x00616161, 0x008B8B8B, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0xEE9B9B9B, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAB9B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x007B7B7B, 0x00626262, 0x00626262, 0x003D3D3D, 0x002B2B2B, 0x001D1D61, 0x000F0F96, 
        0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x00303030, 0x00313131, 0x00414141, 0x00808080, 0x00D1D1D1, 0x00D1D1D1, 0x00CDCDCD, 0x00707070, 0x00383838, 0x003C3C3C, 0x006E6E6E, 0x00C4C4C4, 0x00737373, 0x00373737, 0x00363636, 0x00363636, 0x00383838, 
        0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x00404040, 0x00404040, 0x003F3F3F, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003F3F3F, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 
        0x00313131, 0x002D2D2D, 0x002B2B2B, 0x002A2A2A, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00282828, 0x00282828, 0x00272727, 0x00262626, 0x00262626, 0x00262626, 0x00252525, 0x00252525, 0x00242424, 0x00252525, 0x00252525, 0x00272727, 
        0x00313131, 0x00303030, 0x002F2F2F, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00232323, 
        0x00222222, 0x00212121, 0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001B1B1B, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00181818, 0x00181818, 0x00171717, 0x00151515, 0x00131313, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00393939, 0x00A4A4A4, 0x00898989, 0x00161616, 0x00111111, 0x00111111, 0x00575757, 0x00CCCCCC, 0x00CCCCCC, 0x00B8B8B8, 0x00484848, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00070774, 0x00070774, 
        0x00111111, 0x00252525, 0x00626262, 0x00626262, 0x006B6B6B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x889A9A9A, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x569B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x00929292, 0x00636363, 0x00636363, 0x00636363, 0x002C2C2C, 0x002B2B2B, 0x000808AB, 0x001D1D61, 
        0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002F2F2F, 0x00303030, 0x00303030, 0x00313131, 0x00535353, 0x009A9A9A, 0x00D1D1D1, 0x00D1D1D1, 0x00868686, 0x00555555, 0x00AEAEAE, 0x00D2D2D2, 0x005B5B5B, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 
        0x00373737, 0x00363636, 0x00393939, 0x00393939, 0x003A3A3A, 0x004D4D4D, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 
        0x003E3E3E, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00363636, 0x002F2F2F, 0x002C2C2C, 0x002B2B2B, 
        0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002A2A2A, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00282828, 0x00262626, 0x00262626, 0x00262626, 0x00262626, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00212121, 
        0x00202020, 0x00202020, 0x00242424, 0x002B2B2B, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00252525, 0x00252525, 0x00242424, 0x00232323, 0x00222222, 
        0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00151515, 0x00141414, 0x00141414, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x002C2C2C, 0x00BEBEBE, 0x00CCCCCC, 0x00393939, 0x00484848, 0x00A1A1A1, 0x00CCCCCC, 0x00CCCCCC, 0x00676767, 0x00232323, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000E0E29, 0x000101BE, 
        0x00111111, 0x00111111, 0x004E4E4E, 0x00636363, 0x00636363, 0x008F8F8F, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x229A9A9A, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEF9A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x008A8A8A, 0x00636363, 0x00636363, 0x00464646, 0x00292929, 0x00202049, 0x000505B5, 0x002B2B2B, 
        0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x00303030, 0x00313131, 0x00313131, 0x00616161, 0x00BCBCBC, 0x00D1D1D1, 0x00CDCDCD, 0x00BFBFBF, 0x00919191, 0x00353535, 0x00353535, 0x00363636, 0x00353535, 0x00363636, 
        0x00363636, 0x00363636, 0x00373737, 0x00373737, 0x004C4C4C, 0x00D2D2D2, 0x009F9F9F, 0x004D4D4D, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x003D3D3D, 0x003D3D3D, 
        0x003D3D3D, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 
        0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00323232, 0x002C2C2C, 0x002F2F2F, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 
        0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x00282828, 0x00282828, 0x00292929, 0x00282828, 0x00282828, 0x00292929, 0x00282828, 0x00272727, 0x00252525, 0x00242424, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 
        0x00222222, 0x00212121, 0x00212121, 0x00202020, 0x00212121, 0x00252525, 0x002C2C2C, 0x002A2A2A, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00252525, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 
        0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x00191919, 0x00181818, 0x00171717, 0x00161616, 0x00151515, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x008D8D8D, 0x00CCCCCC, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00616161, 0x00BCBCBC, 0x00B1B1B1, 0x00CCCCCC, 0x00CCCCCC, 0x00818181, 0x00353535, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 
        0x000B0B4F, 0x00111111, 0x002C2C2C, 0x00636363, 0x00636363, 0x00808080, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0xCD9A9A9A, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAB999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x006D6D6D, 0x00646464, 0x00646464, 0x00343434, 0x00292929, 0x0010108A, 0x00151574, 0x002A2A2A, 
        0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002F2F2F, 0x00313131, 0x00313131, 0x00393939, 0x006D6D6D, 0x008F8F8F, 0x00696969, 0x00494949, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00363636, 
        0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00555555, 0x00BDBDBD, 0x00D2D2D2, 0x00D2D2D2, 0x008A8A8A, 0x00434343, 0x00393939, 0x00393939, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003B3B3B, 0x003C3C3C, 0x003D3D3D, 
        0x003C3C3C, 0x003C3C3C, 0x003B3B3B, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003C3C3C, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 
        0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x002F2F2F, 0x002D2D2D, 0x00303030, 0x002F2F2F, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 
        0x002A2A2A, 0x002A2A2A, 0x002D2D2D, 0x00303030, 0x00363636, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00292929, 0x00272727, 0x00242424, 0x00222222, 
        0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x001E1E1E, 0x00212121, 0x00292929, 0x00292929, 0x00272727, 0x00272727, 0x00252525, 0x00252525, 0x00252525, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 
        0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00181818, 0x00181818, 0x00161616, 0x00151515, 0x00151515, 0x00141414, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001D1D1D, 0x00747474, 0x00CCCCCC, 0x00CCCCCC, 0x00B2B2B2, 0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x001C1C1C, 0x00686868, 0x007E7E7E, 0x008F8F8F, 0x00464646, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 
        0x000303A5, 0x00111111, 0x00191919, 0x00646464, 0x00646464, 0x00646464, 0x00929292, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x78999999, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x56999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x008E8E8E, 0x00656565, 0x00656565, 0x00555555, 0x00282828, 0x00282828, 0x000202C0, 0x00262633, 0x00292929, 
        0x002C2C2C, 0x002D2D2D, 0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x003A3A3A, 0x00343434, 0x00313131, 0x00323232, 0x00343434, 0x00333333, 0x00343434, 0x00343434, 
        0x00343434, 0x00353535, 0x00353535, 0x00363636, 0x00363636, 0x00363636, 0x00747474, 0x00C6C6C6, 0x00D2D2D2, 0x00BDBDBD, 0x006B6B6B, 0x00393939, 0x00393939, 0x00393939, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 
        0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 
        0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x00313131, 0x002F2F2F, 0x00303030, 0x00303030, 0x002F2F2F, 0x002F2F2F, 0x002E2E2E, 0x002B2B2B, 0x002B2B2B, 0x00303030, 
        0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 
        0x00282828, 0x00252525, 0x00202020, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x001F1F1F, 0x001D1D1D, 0x00202020, 0x00272727, 0x00262626, 0x00252525, 0x00242424, 0x00242424, 0x00232323, 0x00222222, 0x00212121, 0x001F1F1F, 0x001F1F1F, 
        0x001F1F1F, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00181818, 0x00171717, 0x00141414, 0x00141414, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x004F4F4F, 0x00B2B2B2, 0x00CCCCCC, 0x00BEBEBE, 0x005B5B5B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00151515, 0x00262626, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x000101BE, 0x000E0E29, 0x00111111, 0x00404040, 0x00656565, 0x00656565, 0x008B8B8B, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x23999999, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEF989898, 0x00989898, 0x00989898, 0x00989898, 0x00989898, 0x00989898, 0x00989898, 0x00989898, 0x00848484, 0x00666666, 0x00666666, 0x003E3E3E, 0x00262626, 0x0019195D, 0x000C0C94, 0x00292929, 0x00292929, 
        0x00292929, 0x002B2B2B, 0x002A2A2A, 0x002B2B2B, 0x002B2B2B, 0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002F2F2F, 0x002F2F2F, 0x002F2F2F, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00343434, 0x00343434, 
        0x00343434, 0x00343434, 0x00353535, 0x00353535, 0x00353535, 0x00363636, 0x00363636, 0x00414141, 0x00898989, 0x00D2D2D2, 0x00D2D2D2, 0x00B2B2B2, 0x00575757, 0x00393939, 0x00393939, 0x00393939, 0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 
        0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 
        0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00343434, 0x002E2E2E, 0x00323232, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002C2C2C, 0x00303030, 0x00363636, 0x00363636, 0x00363636, 
        0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 
        0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00272727, 0x00222222, 0x00212121, 0x00212121, 0x001F1F1F, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x00212121, 0x00252525, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x001F1F1F, 0x001E1E1E, 
        0x001E1E1E, 0x001C1C1C, 0x001B1B1B, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00171717, 0x00161616, 0x00151515, 0x00131313, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00363636, 0x00A5A5A5, 0x00CCCCCC, 0x00CCCCCC, 0x00747474, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00070774, 0x00070774, 0x00111111, 0x00252525, 0x00666666, 0x00666666, 0x007B7B7B, 0x00989898, 0x00989898, 0x00989898, 0x00989898, 0x00989898, 0x00989898, 0x00989898, 0xCD989898, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAB979797, 0x00979797, 0x00979797, 0x00979797, 0x00979797, 0x00979797, 0x00979797, 0x00979797, 0x006E6E6E, 0x00666666, 0x00666666, 0x002D2D2D, 0x00252525, 0x000C0C94, 0x0019195D, 0x00272727, 0x00272727, 
        0x00282828, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002C2C2C, 0x002C2C2C, 0x002C2C2C, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x00303030, 0x002F2F2F, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00333333, 0x00343434, 
        0x00333333, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00353535, 0x00363636, 0x00353535, 0x00353535, 0x00555555, 0x00A7A7A7, 0x00D2D2D2, 0x00D2D2D2, 0x009E9E9E, 0x00414141, 0x00373737, 0x00383838, 0x00393939, 0x00393939, 0x00393939, 
        0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 
        0x003A3A3A, 0x00393939, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x002F2F2F, 0x00323232, 0x00323232, 0x00323232, 0x00313131, 0x00303030, 0x002C2C2C, 0x00333333, 0x00363636, 0x00363636, 0x00353535, 0x00353535, 0x00353535, 
        0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 
        0x002C2C2C, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00252525, 0x00212121, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001C1C1C, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x001E1E1E, 0x001D1D1D, 
        0x001C1C1C, 0x001C1C1C, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00191919, 0x00181818, 0x00151515, 0x00151515, 0x00151515, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x008D8D8D, 0x00CCCCCC, 0x00CCCCCC, 0x00999999, 0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x000D0D36, 0x000202B2, 0x00111111, 0x00151515, 0x00666666, 0x00666666, 0x00666666, 0x00919191, 0x00979797, 0x00979797, 0x00979797, 0x00979797, 0x00979797, 0x00979797, 0x78979797, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x56969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x008B8B8B, 0x00676767, 0x00676767, 0x00555555, 0x00242424, 0x0022222F, 0x000202C0, 0x0022222F, 0x00262626, 0x00272727, 
        0x00282828, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002F2F2F, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 
        0x00313131, 0x00343434, 0x00343434, 0x00333333, 0x00343434, 0x00343434, 0x00353535, 0x00353535, 0x00353535, 0x00363636, 0x00363636, 0x005F5F5F, 0x00BCBCBC, 0x00A7A7A7, 0x00363636, 0x00363636, 0x00363636, 0x00393939, 0x00383838, 0x00373737, 
        0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x003A3A3A, 0x00393939, 0x00393939, 
        0x00393939, 0x00393939, 0x00393939, 0x003A3A3A, 0x00393939, 0x00353535, 0x002F2F2F, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x002D2D2D, 0x00323232, 0x00363636, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 
        0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 
        0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00282828, 0x00272727, 0x00272727, 0x00272727, 0x00252525, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001B1B1B, 0x001F1F1F, 0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001C1C1C, 
        0x001C1C1C, 0x001C1C1C, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00181818, 0x00181818, 0x00161616, 0x00141414, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00999999, 0x00B2B2B2, 0x00424242, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x000202B2, 0x000D0D36, 0x00111111, 0x003C3C3C, 0x00676767, 0x00676767, 0x00898989, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x34969696, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x12969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00848484, 0x00686868, 0x00686868, 0x003D3D3D, 0x00232323, 0x0017175A, 0x000B0B93, 0x00252525, 0x00252525, 0x00272727, 
        0x00272727, 0x00272727, 0x00292929, 0x00292929, 0x002A2A2A, 0x002B2B2B, 0x002A2A2A, 0x002B2B2B, 0x002C2C2C, 0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002F2F2F, 0x002E2E2E, 0x00313131, 0x00313131, 0x00313131, 
        0x00313131, 0x00323232, 0x00313131, 0x00313131, 0x00333333, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00494949, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 
        0x00383838, 0x00383838, 0x00383838, 0x00393939, 0x00383838, 0x00373737, 0x00373737, 0x00393939, 0x00393939, 0x00383838, 0x00373737, 0x00363636, 0x00393939, 0x00393939, 0x00393939, 0x00383838, 0x00373737, 0x00383838, 0x00393939, 0x00393939, 
        0x00393939, 0x00383838, 0x00383838, 0x00393939, 0x00323232, 0x00303030, 0x00333333, 0x00333333, 0x00333333, 0x002E2E2E, 0x00303030, 0x00363636, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 
        0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 0x002A2A2A, 
        0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00212121, 0x001E1E1E, 0x001F1F1F, 0x001F1F1F, 0x001D1D1D, 0x001B1B1B, 0x001A1A1A, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001C1C1C, 
        0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00171717, 0x00161616, 0x00151515, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00070774, 0x00070774, 0x00111111, 0x00262626, 0x00686868, 0x00686868, 0x007B7B7B, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0xEF969696, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xCD959595, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x006F6F6F, 0x00686868, 0x00686868, 0x002A2A2A, 0x00222222, 0x000B0B92, 0x0017175B, 0x00252525, 0x00252525, 0x00252525, 
        0x00252525, 0x00272727, 0x00282828, 0x00282828, 0x00282828, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x00303030, 0x002F2F2F, 0x00303030, 
        0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00323232, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00353535, 0x00363636, 0x00363636, 0x00363636, 
        0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00373737, 0x00373737, 0x00363636, 0x00363636, 0x00363636, 0x00373737, 0x00383838, 0x00373737, 0x00363636, 0x00363636, 0x00373737, 0x00383838, 0x00373737, 
        0x00363636, 0x00363636, 0x00363636, 0x002F2F2F, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x002D2D2D, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 
        0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00272727, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00232323, 0x00222222, 0x001D1D1D, 0x001E1E1E, 0x001D1D1D, 0x001D1D1D, 0x001C1C1C, 0x001A1A1A, 0x001D1D1D, 0x001C1C1C, 0x001B1B1B, 
        0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00151515, 0x00151515, 0x00151515, 0x00151515, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x00151515, 0x00686868, 0x00686868, 0x00686868, 0x00909090, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x9A959595, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x78949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x008D8D8D, 0x00696969, 0x00696969, 0x005E5E5E, 0x001F1F1F, 0x001E1E2C, 0x000202BF, 0x0020202E, 0x00242424, 0x00242424, 0x00252525, 
        0x00252525, 0x00252525, 0x00262626, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002B2B2B, 0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 
        0x00313131, 0x00303030, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00333333, 0x00333333, 0x00333333, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 
        0x00353535, 0x00353535, 0x00353535, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 
        0x00353535, 0x00353535, 0x002E2E2E, 0x00353535, 0x00353535, 0x00353535, 0x00323232, 0x002E2E2E, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 
        0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 
        0x00282828, 0x00272727, 0x00272727, 0x00272727, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 0x00202020, 0x001F1F1F, 0x001C1C1C, 0x001D1D1D, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x00191919, 0x001C1C1C, 0x001C1C1C, 
        0x00191919, 0x00191919, 0x00181818, 0x00181818, 0x00181818, 0x00161616, 0x00141414, 0x00141414, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x000202B2, 0x000D0D36, 0x00111111, 0x00434343, 0x00696969, 0x00696969, 0x008A8A8A, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x56949494, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x45949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00878787, 0x006A6A6A, 0x006A6A6A, 0x003F3F3F, 0x001F1F1F, 0x00151558, 0x0009099E, 0x00222222, 0x00242424, 0x00242424, 0x00242424, 
        0x00252525, 0x00252525, 0x00252525, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00282828, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002B2B2B, 0x002C2C2C, 0x002B2B2B, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 
        0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x00303030, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00333333, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 
        0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00363636, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00363636, 0x00363636, 0x00353535, 0x00353535, 0x00363636, 0x00353535, 0x00353535, 
        0x00353535, 0x002E2E2E, 0x00353535, 0x00353535, 0x00363636, 0x00303030, 0x00313131, 0x00353535, 0x00343434, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 
        0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00282828, 0x00272727, 0x00272727, 
        0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00252525, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x001F1F1F, 0x001E1E1E, 0x001B1B1B, 0x001B1B1B, 0x001F1F1F, 0x001F1F1F, 0x001C1C1C, 0x00181818, 0x001A1A1A, 
        0x00191919, 0x00181818, 0x00181818, 0x00171717, 0x00161616, 0x00141414, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00060680, 0x00090967, 0x00111111, 0x002E2E2E, 0x006A6A6A, 0x006A6A6A, 0x00838383, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x12949494, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x00939393, 0x00939393, 0x00939393, 0x00939393, 0x00939393, 0x00939393, 0x00939393, 0x007C7C7C, 0x006B6B6B, 0x006B6B6B, 0x00313131, 0x001F1F1F, 0x000C0C86, 0x0011116F, 0x00202020, 0x00212121, 0x00222222, 0x00222222, 
        0x00232323, 0x00242424, 0x00252525, 0x00262626, 0x00262626, 0x00262626, 0x00272727, 0x00272727, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 
        0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002F2F2F, 0x00303030, 0x002F2F2F, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00323232, 0x00343434, 0x00333333, 0x00323232, 
        0x00323232, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00343434, 0x00343434, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00353535, 0x00343434, 
        0x002E2E2E, 0x00363636, 0x00363636, 0x00363636, 0x00313131, 0x00313131, 0x00343434, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 
        0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 
        0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001B1B1B, 0x001E1E1E, 0x001D1D1D, 0x001D1D1D, 0x00181818, 
        0x00191919, 0x00181818, 0x00181818, 0x00151515, 0x00141414, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001E1E1E, 0x00363636, 0x003E3E3E, 0x001F1F1F, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x000C0C42, 0x00040499, 0x00111111, 0x001F1F1F, 0x006B6B6B, 0x006B6B6B, 0x00717171, 0x00939393, 0x00939393, 0x00939393, 0x00939393, 0x00939393, 0x00939393, 0x00939393, 0xCD939393, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xBC929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x008D8D8D, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 0x00212121, 0x001E1E1E, 0x000303B4, 0x00171740, 0x001F1F1F, 0x001F1F1F, 0x00202020, 0x00222222, 
        0x00222222, 0x00232323, 0x00232323, 0x00242424, 0x00252525, 0x00252525, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00282828, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x004D4D4D, 
        0x004D4D4D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x00303030, 0x00303030, 0x00303030, 0x00313131, 0x00303030, 0x00303030, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00323232, 0x00313131, 0x00313131, 
        0x00313131, 0x00333333, 0x00333333, 0x00323232, 0x00333333, 0x00343434, 0x00343434, 0x00333333, 0x00333333, 0x00343434, 0x00333333, 0x00333333, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00343434, 0x00343434, 0x002E2E2E, 
        0x00373737, 0x00373737, 0x00373737, 0x002E2E2E, 0x00323232, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 
        0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00262626, 0x00252525, 
        0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00242424, 0x00222222, 0x00212121, 0x00202020, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001A1A1A, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 
        0x00171717, 0x00171717, 0x00161616, 0x00131313, 0x00131313, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00363636, 
        0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00131313, 0x00202020, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00949494, 0x00CCCCCC, 0x00A0A0A0, 0x006A6A6A, 0x00282828, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x000000CC, 0x000F0F1D, 0x00111111, 0x00545454, 0x006B6B6B, 0x006B6B6B, 0x008B8B8B, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x9A929292, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0x89929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x008A8A8A, 0x006C6C6C, 0x006C6C6C, 0x00505050, 0x001D1D1D, 0x00191934, 0x000101BF, 0x001E1E1E, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x00222222, 
        0x00222222, 0x00222222, 0x00222222, 0x00242424, 0x00252525, 0x00242424, 0x00252525, 0x00252525, 0x00262626, 0x00272727, 0x00272727, 0x00282828, 0x00292929, 0x00282828, 0x00292929, 0x00292929, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00989898, 
        0x00CFCFCF, 0x00989898, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x00313131, 0x00303030, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 
        0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00323232, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00333333, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00323232, 0x002F2F2F, 0x00383838, 
        0x00373737, 0x00363636, 0x002F2F2F, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 
        0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00252525, 0x00242424, 
        0x00242424, 0x00242424, 0x00242424, 0x00232323, 0x00232323, 0x00202020, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001B1B1B, 0x001A1A1A, 0x001E1E1E, 0x001C1C1C, 
        0x001B1B1B, 0x00141414, 0x00151515, 0x00141414, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x008D8D8D, 0x00CCCCCC, 
        0x008D8D8D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00636363, 0x00949494, 0x006A6A6A, 0x00494949, 0x00363636, 0x001C1C1C, 0x00111111, 0x00686868, 0x00868686, 0x009B9B9B, 0x00BCBCBC, 0x00464646, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00040499, 0x000C0C42, 0x00111111, 0x00393939, 0x006C6C6C, 0x006C6C6C, 0x00878787, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x56929292, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0x45919191, 0x00919191, 0x00919191, 0x00919191, 0x00919191, 0x00919191, 0x00919191, 0x00868686, 0x006D6D6D, 0x006D6D6D, 0x003A3A3A, 0x001C1C1C, 0x00101062, 0x00090991, 0x001D1D1D, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x00212121, 
        0x00222222, 0x00222222, 0x00222222, 0x00232323, 0x00242424, 0x00242424, 0x00242424, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00262626, 0x00272727, 0x00272727, 0x00282828, 0x00292929, 0x00292929, 0x002A2A2A, 0x002B2B2B, 0x004B4B4B, 
        0x00828282, 0x00565656, 0x002C2C2C, 0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x00303030, 0x00313131, 0x00303030, 0x00303030, 0x00313131, 0x00313131, 
        0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x00333333, 0x00383838, 
        0x00373737, 0x00323232, 0x002E2E2E, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 
        0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00242424, 
        0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x00191919, 0x00191919, 0x00181818, 0x00191919, 0x001D1D1D, 
        0x001D1D1D, 0x001A1A1A, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00424242, 0x00808080, 
        0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00616161, 0x00CCCCCC, 0x00B8B8B8, 0x00A1A1A1, 0x008C8C8C, 0x00707070, 0x00545454, 0x002E2E2E, 0x002E2E2E, 0x006B6B6B, 0x00B6B6B6, 0x00545454, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00090967, 0x00070774, 0x00111111, 0x002C2C2C, 0x006D6D6D, 0x006D6D6D, 0x00808080, 0x00919191, 0x00919191, 0x00919191, 0x00919191, 0x00919191, 0x00919191, 0x23919191, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0x12909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x007F7F7F, 0x006E6E6E, 0x006E6E6E, 0x002E2E2E, 0x001B1B1B, 0x000A0A84, 0x00101062, 0x001C1C1C, 0x001D1D1D, 0x001E1E1E, 0x001E1E1E, 0x001F1F1F, 
        0x001F1F1F, 0x00202020, 0x00222222, 0x00222222, 0x00232323, 0x00242424, 0x00242424, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00282828, 0x00292929, 0x002B2B2B, 0x002A2A2A, 
        0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x002A2A2A, 0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x00313131, 0x00303030, 
        0x00313131, 0x00313131, 0x00303030, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002D2D2D, 0x00383838, 0x00383838, 
        0x00353535, 0x002C2C2C, 0x00313131, 0x00303030, 0x002F2F2F, 0x002F2F2F, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 
        0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00282828, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 
        0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x00191919, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00161616, 0x001A1A1A, 
        0x001C1C1C, 0x001C1C1C, 0x00181818, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x004A4A4A, 0x00CCCCCC, 0x00898989, 0x00535353, 0x006D6D6D, 0x00939393, 0x00B6B6B6, 0x00B8B8B8, 0x009C9C9C, 0x00A1A1A1, 0x007E7E7E, 0x00333333, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x000C0C42, 0x000303A5, 0x00111111, 0x00202020, 0x006E6E6E, 0x006E6E6E, 0x00727272, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0xEF909090, 0xFF000000, 0xFF000000,
  0xFF000000, 0xDE909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x001D1D1D, 0x001A1A1A, 0x000303B3, 0x0015153E, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001E1E1E, 
        0x001F1F1F, 0x001F1F1F, 0x00202020, 0x001F1F1F, 0x00212121, 0x00222222, 0x00222222, 0x00232323, 0x00242424, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00272727, 0x00272727, 0x00272727, 0x00292929, 0x00282828, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 
        0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002F2F2F, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x00303030, 0x00303030, 0x002F2F2F, 0x002B2B2B, 0x00373737, 0x00383838, 0x003A3A3A, 
        0x002C2C2C, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002F2F2F, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 
        0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00282828, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 
        0x00222222, 0x00212121, 0x00202020, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00181818, 0x00181818, 0x00181818, 0x00171717, 0x00151515, 0x00151515, 0x00151515, 
        0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00343434, 0x00CCCCCC, 0x00898989, 0x00111111, 0x00222222, 0x00373737, 0x004C4C4C, 0x00747474, 0x00848484, 0x00686868, 0x003D3D3D, 0x00151515, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000000CC, 0x00111111, 0x00111111, 0x00616161, 0x006E6E6E, 0x006E6E6E, 0x008B8B8B, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0xBC909090, 0xFF000000, 0xFF000000,
  0xFF000000, 0xAB8F8F8F, 0x008F8F8F, 0x008F8F8F, 0x008F8F8F, 0x008F8F8F, 0x008F8F8F, 0x008F8F8F, 0x00898989, 0x006F6F6F, 0x006F6F6F, 0x00585858, 0x00181818, 0x00181825, 0x000101BF, 0x001A1A1A, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x00232323, 0x00505050, 
        0x00515151, 0x00404040, 0x002B2B2B, 0x001F1F1F, 0x001F1F1F, 0x00202020, 0x00222222, 0x00222222, 0x00232323, 0x00222222, 0x00242424, 0x00242424, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00262626, 0x00272727, 0x00272727, 
        0x00282828, 0x00292929, 0x00282828, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 
        0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002F2F2F, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002C2C2C, 0x00353535, 0x00393939, 0x00393939, 0x002D2D2D, 
        0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00232323, 0x00212121, 
        0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00181818, 0x00161616, 0x00151515, 0x00151515, 0x00151515, 0x00151515, 0x00141414, 
        0x00161616, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001C1C1C, 0x00CCCCCC, 0x00969696, 0x00111111, 0x00111111, 0x00111111, 0x00171717, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000303A5, 0x000C0C42, 0x00111111, 0x00474747, 0x006F6F6F, 0x006F6F6F, 0x00878787, 0x008F8F8F, 0x008F8F8F, 0x008F8F8F, 0x008F8F8F, 0x008F8F8F, 0x008F8F8F, 0x898F8F8F, 0xFF000000, 0xFF000000,
  0xFF000000, 0x788E8E8E, 0x008E8E8E, 0x008E8E8E, 0x008E8E8E, 0x008E8E8E, 0x008E8E8E, 0x008E8E8E, 0x00868686, 0x00707070, 0x00707070, 0x00434343, 0x00161616, 0x00101046, 0x0006069B, 0x001A1A1A, 0x001B1B1B, 0x001B1B1B, 0x002E2E2E, 0x006A6A6A, 0x00A5A5A5, 
        0x00BEBEBE, 0x00CDCDCD, 0x00CDCDCD, 0x00ABABAB, 0x00828282, 0x00656565, 0x004F4F4