#include "DIALOG.h"
#include "GUI.h"
#include "BUTTON.h"
#include "stdio.h"
#include "SWIPELIST.h"
#include "string.h"
#include "rtc_api.h"
#include "rtc_time.h"
#include "timer_api.h"
#include "ff.h"
#include "FreeRTOS.h"
#include "cJSON.h"
#include "atcmd_wifi.h"
#include "wifi_structures.h"
#include "wifi_conf.h"

#include  <stdarg.h>
#include  <stdio.h>
#include  <stdlib.h>
#include <time.h>
#include  <math.h>


/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
*                           www.segger.com                           *
**********************************************************************
*                                                                    *
* C-file generated by                                                *
*                                                                    *
*        Bitmap Converter (ST) for emWin V5.50.                      *
*        Compiled Aug  8 2019, 14:49:30                              *
*                                                                                         *
*        (c) 1998 - 2019 Segger Microcontroller GmbH & Co. KG        *
*                                                                    *
**********************************************************************
*/

#ifndef GUI_CONST_STORAGE
#define GUI_CONST_STORAGE const
#endif

#define RECOMMENDED_MEMORY 500000
/*
*********************************************************************************************************
* 图片位图数据
* Bitmap data of string. Note that they are chinese characters.
*********************************************************************************************************
*/

//主界面按钮下，单脱水
char const str0[]="\xe5\x8d\x95\xe8\x84\xb1\xe6\xb0\xb4";
char *pStr0=str0;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fontdantuoshui;

//主界面按钮下，漂洗+脱水
char const str1[]="\xe6\xbc\x82\xe6\xb4\x97+\xe8\x84\xb1\xe6\xb0\xb4";
char *pStr1=str1;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fontpiaoxituoshui;

//主界面按钮下，单烘干
char const str2[]="\xe5\x8d\x95\xe7\x83\x98\xe5\xb9\xb2";
char *pStr2=str2;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fontdanhonggan;

//主界面按钮下，速洗30'
char const str3[]="\xe9\x80\x9f\xe6\xb4\x97""30'";
char *pStr3=str3;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fontsuxi;

//主界面按钮下，筒自洁
char const str4[]="\xe7\xad\x92\xe8\x87\xaa\xe6\xb4\x81";
char *pStr4=str4;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fonttongzijie;

//漂洗脱水模式下，功能说明――――洗涤
char const str5[]="\xe6\xb4\x97\xe6\xb6\xa4";
char *pStr5=str5;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fontxidi;

//漂洗脱水模式下，功能说明――――漂洗
char const str6[]="\xe6\xbc\x82\xe6\xb4\x97";
char *pStr6=str6;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fontpiaoxi;

//漂洗脱水模式下，功能说明――――脱水
char const str7[]="\xe8\x84\xb1\xe6\xb0\xb4";
char *pStr7=str7;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fonttuoshui;

//漂洗脱水模式下，功能说明――――洗涤上方，30分
char const str8[]="30\xe5\x88\x86";
char *pStr8=str8;
extern GUI_CONST_STORAGE GUI_FONT GUI_Font30m;

//漂洗脱水模式下，功能说明――――漂洗上方，2次
char const str9[]="2\xe6\xac\xa1";
char *pStr9=str9;
extern GUI_CONST_STORAGE GUI_FONT GUI_Font2t;

//漂洗脱水模式下，功能说明――――脱水上方，6分
char const str10[]="6\xe5\x88\x86";
char *pStr10=str10;
extern GUI_CONST_STORAGE GUI_FONT GUI_Font6m;

//漂洗脱水模式显示（大字）
char const str11[]="\xe6\xbc\x82\xe6\xb4\x97+\xe8\x84\xb1\xe6\xb0\xb4";
char *pStr11=str11;
extern GUI_CONST_STORAGE GUI_FONT GUI_Font_piaoxituoshui;

//单脱水模式显示（大字）
char const str12[]="\xe5\x8d\x95\xe8\x84\xb1\xe6\xb0\xb4";
char *pStr12=str12;
extern GUI_CONST_STORAGE GUI_FONT GUI_Font_dantuoshui;

//单烘干模式显示（大字）
char const str13[]="\xe5\x8d\x95\xe7\x83\x98\xe5\xb9\xb2";
char *pStr13=str13;
extern GUI_CONST_STORAGE GUI_FONT GUI_Font_danhonggan;

//速洗模式显示（大字）和模式说明（小字11）
char const str14[]="\xe9\x80\x9f\xe6\xb4\x97";
char *pStr14=str14;
extern GUI_CONST_STORAGE GUI_FONT GUI_Font_suxi;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fontsuxi_small;

//筒自洁模式显示（大字）和模式说明（小字11）
char const str15[]="\xe7\xad\x92\xe8\x87\xaa\xe6\xb4\x81";
char *pStr15=str15;
extern GUI_CONST_STORAGE GUI_FONT GUI_Font_tongzijie;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fonttongzijie_small;

//单烘干模式下，功能说明――――烘干11
char const str16[]="\xe7\x83\x98\xe5\xb9\xb2";
char *pStr16=str16;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fonthonggan;

//单烘干模式下，功能说明――――48分
char const str17[]="48\xe5\x88\x86";
char *pStr17=str17;
extern GUI_CONST_STORAGE GUI_FONT GUI_Font48m;

//速洗模式下，功能说明――――30秒
char const str18[]="30\xe7\xa7\x92";
char *pStr18=str18;
extern GUI_CONST_STORAGE GUI_FONT GUI_Font30s;

//筒自洁模式下，功能说明――――12时
char const str19[]="12\xe6\x97\xb6";
char *pStr19=str19;
extern GUI_CONST_STORAGE GUI_FONT GUI_Font12h;

//左上角，下筒模式
char const str20[]="\xe4\xb8\x8b\xe7\xad\x92\xe6\xa8\xa1\xe5\xbc\x8f";
char *pStr20=str20;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fontxiatongmoshi;

//苏州市
char const str21[]="\xe8\x8b\x8f\xe5\xb7\x9e\xe5\xb8\x82";
char *pStr21=str21;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fontsuzhoushi;

//摄氏度
char const str22[]="\xe2\x84\x83";
char *pStr22=str22;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fontsheshidu;

//晴天
char const str23[]="\xe6\x99\xb4";
char *pStr23=str23;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fontqingtian;

//适宜洗衣
char const str24[]="\xe9\x80\x82\xe5\xae\x9c\xe6\xb4\x97\xe8\xa1\xa3";
char *pStr24=str24;
extern GUI_CONST_STORAGE GUI_FONT GUI_FontGoodWash;

//建议自然晾干
char const str25[]="\xe5\xbb\xba\xe8\xae\xae\xe8\x87\xaa\xe7\x84\xb6\xe6\x99\xbe\xe5\xb9\xb2";
char *pStr25=str25;
extern GUI_CONST_STORAGE GUI_FONT GUI_FontGoodWarm;

//小雨
char const str26[]="\xe5\xb0\x8f\xe9\x9b\xa8";
char *pStr26=str26;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fontxiaoyu;

//不适宜洗衣
char const str27[]="\xe4\xb8\x8d\xe9\x80\x82\xe5\xae\x9c\xe6\xb4\x97\xe8\xa1\xa3";
char *pStr27=str27;
extern GUI_CONST_STORAGE GUI_FONT GUI_FontBadWash;

//建议烘干模式
char const str28[]="\xe5\xbb\xba\xe8\xae\xae\xe7\x83\x98\xe5\xb9\xb2\xe6\xa8\xa1\xe5\xbc\x8f";
char *pStr28=str28;
extern GUI_CONST_STORAGE GUI_FONT GUI_FontMachineWarm;

//多云
char const str29[]="\xe5\xa4\x9a\xe4\xba\x91";
char *pStr29=str29;
extern GUI_CONST_STORAGE GUI_FONT GUI_Fontduoyun;


/*
*********************************************************************************************************
* 宏定义
* Macro definition
*********************************************************************************************************
*/
#define ID_WINDOW_0				(GUI_ID_USER + 0x00)
#define ID_BUTTON_0				(GUI_ID_USER + 0x01) //start
//#define ID_BUTTON_1			(GUI_ID_USER + 0x02)
#define ID_BUTTON_2				(GUI_ID_USER + 0x05) //wash
#define ID_BUTTON_3				(GUI_ID_USER + 0x06) //dry
#define ID_BUTTON_4				(GUI_ID_USER + 0x07) //warm
#define ID_BUTTON_5				(GUI_ID_USER + 0x08) //fast
#define ID_BUTTON_6				(GUI_ID_USER + 0x09) //clean
#define ID_BUTTON_7				(GUI_ID_USER + 0x24) //wifi
#define ID_BUTTON_8				(GUI_ID_USER + 0x25) //home
#define ID_BUTTON_9				(GUI_ID_USER + 0x27) //setting
#define ID_BUTTON_10			(GUI_ID_USER + 0x2A) //back
#define ID_BUTTON_11			(GUI_ID_USER + 0x2D) //ok
#define ID_BUTTON_12			(GUI_ID_USER + 0x2E)  // a
#define ID_BUTTON_13			(GUI_ID_USER + 0x2F)  // b
#define ID_BUTTON_14			(GUI_ID_USER + 0x30)  // c
#define ID_BUTTON_15			(GUI_ID_USER + 0x31)  // etc..
#define ID_BUTTON_16			(GUI_ID_USER + 0x32)
#define ID_BUTTON_17			(GUI_ID_USER + 0x33)
#define ID_BUTTON_18			(GUI_ID_USER + 0x34)
#define ID_BUTTON_19			(GUI_ID_USER + 0x35)
#define ID_BUTTON_20			(GUI_ID_USER + 0x36)
#define ID_BUTTON_21			(GUI_ID_USER + 0x37)
#define ID_BUTTON_22			(GUI_ID_USER + 0x38)
#define ID_BUTTON_23			(GUI_ID_USER + 0x39)
#define ID_BUTTON_24			(GUI_ID_USER + 0x3A)
#define ID_BUTTON_25			(GUI_ID_USER + 0x3B)
#define ID_BUTTON_26			(GUI_ID_USER + 0x3C)
#define ID_BUTTON_27			(GUI_ID_USER + 0x3D)
#define ID_BUTTON_28			(GUI_ID_USER + 0x3E)
#define ID_BUTTON_29			(GUI_ID_USER + 0x3F)
#define ID_BUTTON_30			(GUI_ID_USER + 0x40)
#define ID_BUTTON_31			(GUI_ID_USER + 0x41)
#define ID_BUTTON_32			(GUI_ID_USER + 0x42)
#define ID_BUTTON_33			(GUI_ID_USER + 0x43)
#define ID_BUTTON_34			(GUI_ID_USER + 0x44)
#define ID_BUTTON_35			(GUI_ID_USER + 0x45)
#define ID_BUTTON_36			(GUI_ID_USER + 0x46)
#define ID_BUTTON_37			(GUI_ID_USER + 0x47)  // z
#define ID_BUTTON_38			(GUI_ID_USER + 0x48)  // Backspace
#define ID_BUTTON_39			(GUI_ID_USER + 0x49)  // Clr
#define ID_BUTTON_40			(GUI_ID_USER + 0x4A)  // Space

#define ID_WINDOW_1				(GUI_ID_USER + 0x4C)
#define ID_EDIT_0				(GUI_ID_USER + 0x4B)

#define ID_TEXT_0				(GUI_ID_USER + 0x0A)
#define ID_TEXT_1				(GUI_ID_USER + 0x0B)
#define ID_TEXT_2				(GUI_ID_USER + 0x0C)
#define ID_TEXT_3				(GUI_ID_USER + 0x0D)
#define ID_TEXT_4				(GUI_ID_USER + 0x0E)
#define ID_TEXT_5				(GUI_ID_USER + 0x0F)
#define ID_TEXT_6				(GUI_ID_USER + 0x10)
#define ID_TEXT_7				(GUI_ID_USER + 0x11)
#define ID_TEXT_8				(GUI_ID_USER + 0x12)
#define ID_TEXT_9				(GUI_ID_USER + 0x13)
#define ID_TEXT_10				(GUI_ID_USER + 0x14)
#define ID_TEXT_11				(GUI_ID_USER + 0x15)
#define ID_TEXT_12				(GUI_ID_USER + 0x16)
#define ID_TEXT_13				(GUI_ID_USER + 0x17)
#define ID_TEXT_14				(GUI_ID_USER + 0x18)
#define ID_TEXT_15				(GUI_ID_USER + 0x19)
#define ID_TEXT_16				(GUI_ID_USER + 0x1A)
#define ID_TEXT_17				(GUI_ID_USER + 0x1B)
#define ID_TEXT_18				(GUI_ID_USER + 0x1C)
#define ID_TEXT_19				(GUI_ID_USER + 0x1D)
#define ID_TEXT_20				(GUI_ID_USER + 0x1E)
#define ID_TEXT_21				(GUI_ID_USER + 0x1F)
#define ID_TEXT_22				(GUI_ID_USER + 0x20)
#define ID_TEXT_23				(GUI_ID_USER + 0x21)
#define ID_TEXT_24				(GUI_ID_USER + 0x22)
#define ID_TEXT_25				(GUI_ID_USER + 0x23)
#define ID_TEXT_26				(GUI_ID_USER + 0x26)

//#define ID_LISTBOX_0			(GUI_ID_USER + 0x2B)
//#define ID_LISTVIEW_0			(GUI_ID_USER + 0x25)
//#define ID_LISTVIEW_1			(GUI_ID_USER + 0x28)
//#define ID_IMAGE_0			(GUI_ID_USER + 0x28)

#define ID_SWIPELIST_0			(GUI_ID_USER + 0x29)
#define ID_SWIPELIST_1			(GUI_ID_USER + 0x2C)

//子窗口用到的控件
#define ID_RADIO_0				(GUI_ID_USER + 0x4D)
#define ID_RADIO_1				(GUI_ID_USER + 0x4E)
#define ID_RADIO_2				(GUI_ID_USER + 0x4F)
#define ID_BUTTON_41			(GUI_ID_USER + 0x50) //close button
#define ID_WINDOW_2				(GUI_ID_USER + 0x51)
//#define ID_WINDOW_3			(GUI_ID_USER + 0x52)
//#define ID_WINDOW_4			(GUI_ID_USER + 0x53)

//天气界面
#define ID_BUTTON_45			(GUI_ID_USER + 0x5B) //ONLINE
#define ID_BUTTON_46			(GUI_ID_USER + 0x5C) //OFFLINE

#define ID_TEXT_27				(GUI_ID_USER + 0x52) //城市 city
#define ID_TEXT_28				(GUI_ID_USER + 0x53) //摄氏度 centigrade
#define ID_TEXT_29				(GUI_ID_USER + 0x54) //天气情况 weather
#define ID_TEXT_30				(GUI_ID_USER + 0x55) //洗衣指数 wash index
#define ID_TEXT_31				(GUI_ID_USER + 0x56) //烘干建议 dry advise
#define ID_TEXT_32				(GUI_ID_USER + 0x57) //温度数值 temperature
#define ID_BUTTON_42			(GUI_ID_USER + 0x58) //小雨 light rain
#define ID_BUTTON_43			(GUI_ID_USER + 0x59) //晴天 sunny
#define ID_BUTTON_44			(GUI_ID_USER + 0x5A) //多云 cloudy

//#define NUM_ITEMS				20

#define ID_TimerMin				0
#define ID_TimerSec				1

#define ID_TimerTime			2 //RTC_Time

#define NUM_SEPARATORS			2 // 设置界面中大的分界数
#define NUM_ITEMS				4 // 每个分界中选项数
#define NUM_ITEMS_2				20 // wifi列表选项数

#define COLOR_BUTTON_FRAME_0	GUI_LIGHTGRAY
#define COLOR_BUTTON_FRAME_1	GUI_WHITE
#define COLOR_BUTTON_BK_0		GUI_BLACK
#define COLOR_BUTTON_BK_1		GUI_BLACK


/*
*********************************************************************************************************
* 图文件声明
* Declaration of bitmap data of picture.
*********************************************************************************************************
*/
GUI_CONST_STORAGE GUI_BITMAP bmstart; //开始
GUI_CONST_STORAGE GUI_BITMAP bmwash; //漂洗
GUI_CONST_STORAGE GUI_BITMAP bmdry; //脱水
GUI_CONST_STORAGE GUI_BITMAP bmwarm; //烘干
GUI_CONST_STORAGE GUI_BITMAP bmfast; //速洗
GUI_CONST_STORAGE GUI_BITMAP bmclean; //筒自洁
GUI_CONST_STORAGE GUI_BITMAP bmWifi_1; //Wifi图标
GUI_CONST_STORAGE GUI_BITMAP bmHome; //Home键
GUI_CONST_STORAGE GUI_BITMAP bmsetting; //设置键
GUI_CONST_STORAGE GUI_BITMAP bmback; //返回键
GUI_CONST_STORAGE GUI_BITMAP bmok; //确认键
GUI_CONST_STORAGE GUI_BITMAP bmclose; //关闭小窗口按键
GUI_CONST_STORAGE GUI_BITMAP bmbm_bkb; //背景图
GUI_CONST_STORAGE GUI_BITMAP bmbms_rain; //小雨图标
GUI_CONST_STORAGE GUI_BITMAP bmbmsunny; //晴天图标
GUI_CONST_STORAGE GUI_BITMAP bmbmcloudy; //多云图标

GUI_BITMAP* pBmp[3] = {
	&bmstart,
	&bmbm_bkb,
	&bmclose,
};

GUI_BITMAP* sBmp[10] = {
	&bmwash,
	&bmdry,
	&bmwarm,
	&bmfast,
	&bmclean,
	&bmWifi_1,
	&bmHome,
	&bmsetting,
	&bmback,
	&bmok,
};

GUI_BITMAP* wBmp[3]= {
	&bmbms_rain,
	&bmbmsunny,
	&bmbmcloudy,
};

static const char * paItemText[2][4] = {
	{
		"Weather forecast",
		"Energy-saving",
		"Strong-washing",
		"Sterilization",
	},
	{
		"Distraction free",
		"Lock",
		"Appointment",
		"Music",
	},

};

static const char * paSeperatorText[] = {
	"Pattern",
	"function",

};

static const char * saItemText[20] = {
	"TP-LINK_C8 ",
	"802.1x ",
	"xiaomi_3c ",
	"360WiFi-3149C1 ",
	"TP-LINK_5DF6 ",
	"Tenda_W304R ",
	"ATS_425",
	"FAST",
	"RealEZ-2.4G ",
	"Tenda_21B",
	"B-LINK_test",
	"www",
	"REALMESH_MAC4c872003",
	"netgear",
	"RealKungFu",
};


/*
*********************************************************************************************************
* 键盘布局颜色
* Color data of virtual keyboard
*********************************************************************************************************
*/
typedef struct {
	GUI_COLOR aColorFrame[2];
	GUI_COLOR aColorBK[2];
} COLORS;

static COLORS _Colors = {
	{ COLOR_BUTTON_FRAME_0, COLOR_BUTTON_FRAME_1},
	{ COLOR_BUTTON_BK_0,    COLOR_BUTTON_BK_1   }
};

/*
*********************************************************************************************************
* 内存设备和主界面句柄声明
* Declaration of Memdev and handle of main screen.
*********************************************************************************************************
*/
GUI_MEMDEV_Handle hMem0;
WM_HWIN hWin;



/*
*********************************************************************************************************
* 各个子界面对话框
* Dialogs of each screen and component
*********************************************************************************************************
*/

//主界面
//Main screen (home page)
static const GUI_WIDGET_CREATE_INFO _aDialogCreate1[] =
{
	{ WINDOW_CreateIndirect, "Window", ID_WINDOW_0, 0, 0, 480, 272, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "wash", ID_BUTTON_2, 20, 134, 64, 64, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "dry", ID_BUTTON_3, 114, 134, 64, 64, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "warm", ID_BUTTON_4, 208, 134, 64, 64, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "fast", ID_BUTTON_5, 302, 134, 64, 64, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "clean", ID_BUTTON_6, 396, 134, 64, 64, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "wifi", ID_BUTTON_7, 400, 10, 32, 32, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "Home", ID_BUTTON_8, 280, 10, 48, 48, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "setting", ID_BUTTON_9, 340, 10, 48, 48, 0, 0x0, 0 },

	{ TEXT_CreateIndirect, "Text0", ID_TEXT_1,10, 205, 80, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text1", ID_TEXT_0,122, 205, 50, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text2", ID_TEXT_2,217, 205, 60, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text3", ID_TEXT_3,310, 205, 60, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text4", ID_TEXT_4,405, 205, 60, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "xiatong", ID_TEXT_22,10, 10, 80, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "time", ID_TEXT_26,435, 15, 45, 45, 0, 0x0, 0 },
};

//漂洗+脱水界面
//"wash" screen
static const GUI_WIDGET_CREATE_INFO _aDialogCreate3[] =
{
	{ WINDOW_CreateIndirect, "Window", ID_WINDOW_0, 0, 0, 480, 272, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "start", ID_BUTTON_0, 380, 145, 128, 128, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "Home", ID_BUTTON_8, 280, 10, 48, 48, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "wifi", ID_BUTTON_7, 400, 10, 32, 32, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "setting", ID_BUTTON_9, 340, 10, 48, 48, 0, 0x0, 0 },

	{ TEXT_CreateIndirect, "Text5", ID_TEXT_5,30, 220, 40, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text6", ID_TEXT_6,85, 220, 40, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text7", ID_TEXT_7,138, 220, 40, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text8", ID_TEXT_8,32, 190, 40, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text9", ID_TEXT_9,90, 190, 40, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text10", ID_TEXT_10,138, 190, 40, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text11", ID_TEXT_11,190, 100, 140, 60, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "xiatong", ID_TEXT_22,10, 10, 80, 30, 0, 0x0, 0 },

	{ TEXT_CreateIndirect, "36", ID_TEXT_23, 30,50,40,48, 0,0},
	{ TEXT_CreateIndirect, ":", ID_TEXT_24, 80,50,20,48, 0,0},
	{ TEXT_CreateIndirect, "00", ID_TEXT_25, 110,50,40,48, 0,0},

	{ TEXT_CreateIndirect, "time", ID_TEXT_26,435, 15, 45, 45, 0, 0x0, 0 },
};

//单脱水界面
//"dry" screen
static const GUI_WIDGET_CREATE_INFO _aDialogCreate4[] =
{
	{ WINDOW_CreateIndirect, "Window", ID_WINDOW_0, 0, 0, 480, 272, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "start", ID_BUTTON_0, 380, 145, 128, 128, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "Home", ID_BUTTON_8, 280, 10, 48, 48, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "wifi", ID_BUTTON_7, 400, 10, 32, 32, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "setting", ID_BUTTON_9, 340, 10, 48, 48, 0, 0x0, 0 },


	{ TEXT_CreateIndirect, "Text7", ID_TEXT_7,200, 220, 40, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text10", ID_TEXT_10,205, 190, 40, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text12", ID_TEXT_12,190, 100, 100, 60, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "xiatong", ID_TEXT_22,10, 10, 80, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "time", ID_TEXT_26,435, 15, 45, 45, 0, 0x0, 0 },

	{ TEXT_CreateIndirect, "06", ID_TEXT_23, 30,50,40,48, 0,0},
	{ TEXT_CreateIndirect, ":", ID_TEXT_24, 80,50,20,48, 0,0},
	{ TEXT_CreateIndirect, "00", ID_TEXT_25, 110,50,40,48, 0,0},
};

//单烘干界面
//"warm" screen
static const GUI_WIDGET_CREATE_INFO _aDialogCreate5[] =
{
	{ WINDOW_CreateIndirect, "Window", ID_WINDOW_0, 0, 0, 480, 272, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "start", ID_BUTTON_0, 380, 145, 128, 128, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "Home", ID_BUTTON_8, 280, 10, 48, 48, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "wifi", ID_BUTTON_7, 400, 10, 32, 32, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "setting", ID_BUTTON_9, 340, 10, 48, 48, 0, 0x0, 0 },

	{ TEXT_CreateIndirect, "Text16", ID_TEXT_16,200, 220, 40, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text19", ID_TEXT_19,202, 190, 40, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text13", ID_TEXT_13,190, 100,100, 60, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "xiatong", ID_TEXT_22,10, 10, 80, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "time", ID_TEXT_26,435, 15, 45, 45, 0, 0x0, 0 },

	{ TEXT_CreateIndirect, "48", ID_TEXT_23,30,50,40,48, 0,0},
	{ TEXT_CreateIndirect, ":", ID_TEXT_24, 80,50,20,48, 0,0},
	{ TEXT_CreateIndirect, "00", ID_TEXT_25, 110,50,40,48, 0,0},
};

//速洗界面
//"fast" screen
static const GUI_WIDGET_CREATE_INFO _aDialogCreate6[] =
{
	{ WINDOW_CreateIndirect, "Window", ID_WINDOW_0, 0, 0, 480, 272, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "start", ID_BUTTON_0, 380, 145, 128, 128, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "Home", ID_BUTTON_8, 280, 10, 48, 48, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "wifi", ID_BUTTON_7, 400, 10, 32, 32, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "setting", ID_BUTTON_9, 340, 10, 48, 48, 0, 0x0, 0 },

	{ TEXT_CreateIndirect, "Text17", ID_TEXT_17,200, 220, 40, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text20", ID_TEXT_20,202, 190, 40, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text14", ID_TEXT_14,190, 100, 100, 60, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "xiatong", ID_TEXT_22,10, 10, 80, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "time", ID_TEXT_26,435, 15, 45, 45, 0, 0x0, 0 },

	{ TEXT_CreateIndirect, "00", ID_TEXT_23, 30,50,40,48, 0,0},
	{ TEXT_CreateIndirect, ":", ID_TEXT_24, 80,50,20,48, 0,0},
	{ TEXT_CreateIndirect, "30", ID_TEXT_25, 110,50,40,48, 0,0},
};

//筒自洁界面
//"clean" screen
static const GUI_WIDGET_CREATE_INFO _aDialogCreate7[] =
{
	{ WINDOW_CreateIndirect, "Window", ID_WINDOW_0, 0, 0, 480, 272, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "start", ID_BUTTON_0, 380, 145, 128,128, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "Home", ID_BUTTON_8, 280, 10, 48, 48, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "wifi", ID_BUTTON_7, 400, 10, 32, 32, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "setting", ID_BUTTON_9, 340, 10, 48, 48, 0, 0x0, 0 },

	{ TEXT_CreateIndirect, "Text18", ID_TEXT_18,190, 220, 60, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text21", ID_TEXT_21,200, 190, 40, 30, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text15", ID_TEXT_15,190, 100, 100, 60, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "xiatong", ID_TEXT_22,10, 10, 80, 30, 0, 0x0, 0 },

	{ TEXT_CreateIndirect, "time", ID_TEXT_26,435, 15, 45, 45, 0, 0x0, 0 },
};

//设置界面
//"setting" screen
static const GUI_WIDGET_CREATE_INFO _aDialogCreate8[] =
{
	{ WINDOW_CreateIndirect, "Window", ID_WINDOW_0, 0, 0, 480, 272, 0, 0x0, 0 },
	{ SWIPELIST_CreateIndirect, "Swipelist0", ID_SWIPELIST_0, 10, 0, 240, 272, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "back", ID_BUTTON_10, 430, 5, 48, 48, 0, 0x0, 0 },
};

//设置界面中滑动列表控件(swipelist)的部分项(1-7)的设置子界面
//Child window of some items(1-7) of swipelist in "setting" screen
static const GUI_WIDGET_CREATE_INFO _aDialogCreate11[] = {
	{ WINDOW_CreateIndirect, "Window2", ID_WINDOW_2,  255,  70, 200, 200, 0, 0x0, 0 },
	{ RADIO_CreateIndirect, "Radio", ID_RADIO_0, 15, 15, 185, 185, 0, 0x2802, 0 },
	{ BUTTON_CreateIndirect, "Close",ID_BUTTON_41, 152,2,48,48,0,0x0,0},
};

//设置界面中滑动列表控件(swipelist)的第8项的设置子界面
//Child window of item 8 of swipelist in "setting" screen
static const GUI_WIDGET_CREATE_INFO _aDialogCreate12[] = {
	{ WINDOW_CreateIndirect, "Window2", ID_WINDOW_2,  255,  70, 200, 200, 0, 0x0, 0 },
	{ RADIO_CreateIndirect, "Radio", ID_RADIO_1, 15, 15, 185, 185, 0, 0x2804, 0 },
	{ BUTTON_CreateIndirect, "Close",ID_BUTTON_41, 152,2,48,48,0,0x0,0},
};

//设置界面中滑动列表控件(swipelist)的第9项的设置子界面
//Child window of item 9 of swipelist in "setting" screen
static const GUI_WIDGET_CREATE_INFO _aDialogCreate13[] = {
	{ WINDOW_CreateIndirect, "Window2", ID_WINDOW_2,  255,  70, 200, 200, 0, 0x0, 0 },
	{ RADIO_CreateIndirect, "Radio", ID_RADIO_2, 15, 15, 185, 185, 0, 0x2804, 0 },
	{ BUTTON_CreateIndirect, "Close", ID_BUTTON_41, 152,2,48,48,0,0x0,0},
};

//在线和离线天气选择界面
//"online or offline weather select" screen
static const GUI_WIDGET_CREATE_INFO _aDialogCreate17[] =
{
	{ WINDOW_CreateIndirect, "Window", ID_WINDOW_0, 0, 0, 480, 272, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "back", ID_BUTTON_10, 430, 5, 48, 48, 0, 0x0, 0 }, //back
	{ BUTTON_CreateIndirect, "ONLINE", ID_BUTTON_45, 140, 112, 80, 48, 0, 0x0, 0 }, //ONLINE
	{ BUTTON_CreateIndirect, "OFFLINE", ID_BUTTON_46, 260, 112, 80, 48, 0, 0x0, 0 }, //OFFLINE
};

//离线天气界面1
//"offline whether" screen1
static const GUI_WIDGET_CREATE_INFO _aDialogCreate14[] =
{
	{ WINDOW_CreateIndirect, "Window", ID_WINDOW_0, 0, 0, 480, 272, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "back", ID_BUTTON_10, 430, 5, 48, 48, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text27", ID_TEXT_27,320, 30, 132, 50, 0, 0x64, 0 }, //city
	{ TEXT_CreateIndirect, "10", ID_TEXT_32,320, 94, 50, 50, 0, 0x64, 0 }, //temperature
	{ TEXT_CreateIndirect, "Text28", ID_TEXT_28,360, 94, 90, 50, 0, 0x64, 0}, // centigrade
	{ TEXT_CreateIndirect, "Text29", ID_TEXT_29,320, 159, 159, 47, 0, 0x64, 0 }, //weather
	{ TEXT_CreateIndirect, "Text30", ID_TEXT_30, 30, 155, 180, 40, 0, 0x64, 0 }, //suitable for washing?
	{ TEXT_CreateIndirect, "Text31", ID_TEXT_31,30, 205, 183, 37, 0, 0x64, 0 }, //dry?
	{ BUTTON_CreateIndirect, "s_rain", ID_BUTTON_42, 30, 30, 112, 108, 0, 0x0, 0 }, //light rain
};

//离线天气界面2
//"offline whether" screen2
static const GUI_WIDGET_CREATE_INFO _aDialogCreate15[] =
{
	{ WINDOW_CreateIndirect, "Window", ID_WINDOW_0, 0, 0, 480, 272, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "back", ID_BUTTON_10, 430, 5, 48, 48, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text27", ID_TEXT_27,320, 30, 132, 50, 0, 0x64, 0 }, //city
	{ TEXT_CreateIndirect, "14", ID_TEXT_32,320, 94, 50, 50, 0, 0x64, 0 }, //temperature
	{ TEXT_CreateIndirect, "Text28", ID_TEXT_28,360, 94, 90, 50, 0, 0x64, 0}, // centigrade
	{ TEXT_CreateIndirect, "Text29", ID_TEXT_29,320, 159, 159, 47, 0, 0x64, 0 }, //weather
	{ TEXT_CreateIndirect, "Text30", ID_TEXT_30, 30, 155, 180, 40, 0, 0x64, 0 }, //suitable for washing?
	{ TEXT_CreateIndirect, "Text31", ID_TEXT_31,30, 205, 183, 37, 0, 0x64, 0 }, //dry?
	{ BUTTON_CreateIndirect, "sunny", ID_BUTTON_43, 30, 30, 102, 102, 0, 0x0, 0 }, //sunny
};

////离线天气界面3
//"offline whether" screen3
static const GUI_WIDGET_CREATE_INFO _aDialogCreate16[] =
{
	{ WINDOW_CreateIndirect, "Window", ID_WINDOW_0, 0, 0, 480, 272, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "back", ID_BUTTON_10, 430, 5, 48, 48, 0, 0x0, 0 },
	{ TEXT_CreateIndirect, "Text27", ID_TEXT_27,320, 30, 132, 50, 0, 0x64, 0 }, //city
	{ TEXT_CreateIndirect, "13", ID_TEXT_32,320, 94, 50, 50, 0, 0x64, 0 }, //temperature
	{ TEXT_CreateIndirect, "Text28", ID_TEXT_28,360, 94, 90, 50, 0, 0x64, 0}, // centigrade
	{ TEXT_CreateIndirect, "Text29", ID_TEXT_29,320, 159, 159, 47, 0, 0x64, 0 }, //weather
	{ TEXT_CreateIndirect, "Text30", ID_TEXT_30, 30, 155, 180, 40, 0, 0x64, 0 }, //suitable for washing?
	{ TEXT_CreateIndirect, "Text31", ID_TEXT_31,30, 205, 183, 37, 0, 0x64, 0 }, //dry?
	{ BUTTON_CreateIndirect, "cloudy", ID_BUTTON_44, 30, 30, 120, 88, 0, 0x0, 0 }, //cloudy
};

// wifi列表界面
// "wifi ssid list" screen
static const GUI_WIDGET_CREATE_INFO _aDialogCreate9[] =
{
	{ WINDOW_CreateIndirect, "Window", ID_WINDOW_0, 0, 0, 480, 272, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "back", ID_BUTTON_10, 430, 5, 48, 48, 0, 0x0, 0 },
	{ SWIPELIST_CreateIndirect, "Swipelist1", ID_SWIPELIST_1, 10, 0, 240, 272, 0, 0x0, 0 },
};

// 虚拟键盘界面
// virtual keyboard to type wifi password 
static const GUI_WIDGET_CREATE_INFO _aKeyboardDialogCreate[] = {
	{ WINDOW_CreateIndirect, "Window1", ID_WINDOW_1, 0, 0, (40+ 5) * 10 + 5, (40+ 5) * 3 + 5, 0, 0x0, 0 },

	// First row
	{ BUTTON_CreateIndirect, "q", ID_BUTTON_28, 5, 5, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "w", ID_BUTTON_34, 50, 5, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "e", ID_BUTTON_16,  95, 5, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "r", ID_BUTTON_29, 140, 5, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "t", ID_BUTTON_31, 185, 5, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "y", ID_BUTTON_36, 230, 5, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "u", ID_BUTTON_32, 275, 5, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "i", ID_BUTTON_20, 320, 5, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "o", ID_BUTTON_26, 365, 5, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "p", ID_BUTTON_27, 410, 5, 40, 40, 0, 0x0, 0 },

	// Second row
	{ BUTTON_CreateIndirect, "a", ID_BUTTON_12,  25, 50, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "s", ID_BUTTON_30, 70, 50, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "d", ID_BUTTON_15,  115, 50, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "f", ID_BUTTON_17,  160, 50, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "g", ID_BUTTON_18,  205, 50, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "h", ID_BUTTON_19,  250, 50, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "j", ID_BUTTON_21,  295, 50, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "k", ID_BUTTON_22, 340, 50, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "l", ID_BUTTON_23, 385, 50, 40, 40, 0, 0x0, 0 },

	// Third row
	{ BUTTON_CreateIndirect, "\' \'", ID_BUTTON_40, 5, 95, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "z",     ID_BUTTON_37, 50, 95, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "x",     ID_BUTTON_35, 95, 95, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "c",     ID_BUTTON_14,  140, 95, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "v",     ID_BUTTON_33, 185, 95, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "b",     ID_BUTTON_13,  230, 95, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "n",     ID_BUTTON_25, 275, 95, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "m",     ID_BUTTON_24, 320, 95, 40, 40, 0, 0x0, 0 },

	// Some special commands
	{ BUTTON_CreateIndirect, "<-",    ID_BUTTON_38, 360, 95, 40, 40, 0, 0x0, 0 },
	{ BUTTON_CreateIndirect, "Clr",   ID_BUTTON_39, 405, 95, 40, 40, 0, 0x0, 0 },
};

// wifi密码输入框
// Input box of wifi password
static const GUI_WIDGET_CREATE_INFO _aDialogCreate10[] = {
	{ WINDOW_CreateIndirect, "Window", ID_WINDOW_0,  0,  0, 480, 272, 0, 0x0, 0 },
	{ EDIT_CreateIndirect,   "Edit",   ID_EDIT_0,   73, 22, 334, 30, 0, 0x64, 0 },
	{ BUTTON_CreateIndirect, "cancel",  ID_BUTTON_10,5,10,48,48,0,0x0,0},
	{ BUTTON_CreateIndirect, "ok",  ID_BUTTON_11,427,10,48,48,0,0x0,0},
};




/*
*********************************************************************************************************
* 各个子界面对话框
* Dialogs of each screen and component
*********************************************************************************************************
*/

//button0 (开始键) callback函数
//callback function of button0 ("start" button).
static void _cbButton0(WM_MESSAGE*pMsg)
{
	WM_HWIN hWin;
	hWin=pMsg->hWin;
	switch(pMsg->MsgId)
	{
	case WM_PAINT:
		if(BUTTON_IsPressed(hWin))
		{
			GUI_SetBkColor(GUI_WHITE);
			GUI_SetAlpha(0xb0);
			GUI_DrawBitmap(pBmp[0],0,0);
			GUI_SetAlpha(0);

			GUI_Clear();
		}
		else
		{
			GUI_DrawBitmap(pBmp[0],0,0);
		}
		break;
	default:
		BUTTON_Callback(pMsg);
	}
}

//button2 (home键) callback函数
//callback function of button2 ("home" button)
static void _cbButton2(WM_MESSAGE*pMsg)
{
	WM_HWIN hWin;
	hWin=pMsg->hWin;
	switch(pMsg->MsgId)
	{
	case WM_PAINT:
		if(BUTTON_IsPressed(hWin))
		{
			GUI_SetBkColor(GUI_WHITE);
			//GUI_Clear();
			GUI_SetAlpha(0xb0);
			GUI_DrawBitmap(sBmp[0],0,0);
			GUI_SetAlpha(0);
		}
		else
		{
			GUI_DrawBitmap(sBmp[0],0,0);
		}
		break;
	default:
		BUTTON_Callback(pMsg);
	}
}

//button3 (干燥键) callback函数
//callback function of button3 ("dry" button)
static void _cbButton3(WM_MESSAGE*pMsg)
{
	WM_HWIN hWin;
	hWin=pMsg->hWin;
	switch(pMsg->MsgId)
	{
	case WM_PAINT:
		if(BUTTON_IsPressed(hWin))
		{
			GUI_SetBkColor(GUI_WHITE);
			//GUI_Clear();
			GUI_SetAlpha(0xb0);
			GUI_DrawBitmap(sBmp[1],0,0);
			GUI_SetAlpha(0);
		}
		else
		{
			GUI_DrawBitmap(sBmp[1],0,0);
		}
		break;
	default:
		BUTTON_Callback(pMsg);
	}
}

//button4 (烘干键) callback函数
//callback function of button4 ("warm" button)
static void _cbButton4(WM_MESSAGE*pMsg)
{
	WM_HWIN hWin;
	hWin=pMsg->hWin;
	switch(pMsg->MsgId)
	{
	case WM_PAINT:
		if(BUTTON_IsPressed(hWin))
		{
			GUI_SetBkColor(GUI_WHITE);
			//GUI_Clear();
			GUI_SetAlpha(0xb0);
			GUI_DrawBitmap(sBmp[2],0,0);
			GUI_SetAlpha(0);
		}
		else
		{
			GUI_DrawBitmap(sBmp[2],0,0);
		}
		break;
	default:
		BUTTON_Callback(pMsg);
	}
}

//button5 (速洗键) callback函数
//callback function of button5 ("fast" button)
static void _cbButton5(WM_MESSAGE*pMsg)
{
	WM_HWIN hWin;
	hWin=pMsg->hWin;
	switch(pMsg->MsgId)
	{
	case WM_PAINT:
		if(BUTTON_IsPressed(hWin))
		{
			GUI_SetBkColor(GUI_WHITE);
			//GUI_Clear();
			GUI_SetAlpha(0xb0);
			GUI_DrawBitmap(sBmp[3],0,0);
			GUI_SetAlpha(0);
		}
		else
		{
			GUI_DrawBitmap(sBmp[3],0,0);
		}
		break;
	default:
		BUTTON_Callback(pMsg);
	}
}

//button6 (筒自洁键) callback函数
//callback function of button6 ("clean" button)
static void _cbButton6(WM_MESSAGE*pMsg)
{
	WM_HWIN hWin;
	hWin=pMsg->hWin;
	switch(pMsg->MsgId)
	{
	case WM_PAINT:
		if(BUTTON_IsPressed(hWin))
		{
			GUI_SetBkColor(GUI_WHITE);
			//GUI_Clear();
			GUI_SetAlpha(0xb0);
			GUI_DrawBitmap(sBmp[4],0,0);
			GUI_SetAlpha(0);
		}
		else
		{
			GUI_DrawBitmap(sBmp[4],0,0);
		}
		break;
	default:
		BUTTON_Callback(pMsg);
	}
}

//button7 (wifi键) callback函数
//callback function of button7 ("wifi" button)
static void _cbButton7(WM_MESSAGE*pMsg)
{
	WM_HWIN hWin;
	hWin=pMsg->hWin;
	switch(pMsg->MsgId)
	{
	case WM_PAINT:
		if(BUTTON_IsPressed(hWin))
		{
			GUI_SetBkColor(GUI_WHITE);
			//GUI_Clear();
			GUI_SetAlpha(0xb0);
			GUI_DrawBitmap(sBmp[5],0,0);
			GUI_SetAlpha(0);
		}
		else
		{
			GUI_DrawBitmap(sBmp[5],0,0);
		}
		break;
	default:
		BUTTON_Callback(pMsg);
	}
}

//button8 (home键) callback函数
//callback function of button8 ("home" button)
static void _cbButton8(WM_MESSAGE*pMsg)
{
	WM_HWIN hWin;
	hWin=pMsg->hWin;
	switch(pMsg->MsgId)
	{
	case WM_PAINT:
		if(BUTTON_IsPressed(hWin))
		{
			GUI_SetBkColor(GUI_WHITE);

			GUI_SetAlpha(0xb0);
			GUI_DrawBitmap(sBmp[6],0,0);
			GUI_SetAlpha(0);

			GUI_Clear();

		}
		else
		{
			GUI_DrawBitmap(sBmp[6],0,0);
			// GUI_AA_FillCircle(370, 177, 32);
		}
		break;
	default:
		BUTTON_Callback(pMsg);
	}
}

//button9 (设置键) callback函数
//callback function of button9 ("setting" button)
static void _cbButton9(WM_MESSAGE*pMsg)
{
	WM_HWIN hWin;
	hWin=pMsg->hWin;
	switch(pMsg->MsgId)
	{
	case WM_PAINT:
		if(BUTTON_IsPressed(hWin))
		{
			GUI_SetBkColor(GUI_WHITE);
			//GUI_Clear();
			GUI_SetAlpha(0xb0);
			GUI_DrawBitmap(sBmp[7],0,0);
			GUI_SetAlpha(0);
		}
		else
		{
			GUI_DrawBitmap(sBmp[7],0,0);
		}
		break;
	default:
		BUTTON_Callback(pMsg);
	}
}

//button10 (返回键) callback函数
//callback function of button10 ("back" button)
static void _cbButton10(WM_MESSAGE*pMsg)
{
	WM_HWIN hWin;
	hWin=pMsg->hWin;
	switch(pMsg->MsgId)
	{
	case WM_PAINT:
		if(BUTTON_IsPressed(hWin))
		{
			GUI_SetBkColor(GUI_WHITE);
			//GUI_Clear();
			GUI_SetAlpha(0xb0);
			GUI_DrawBitmap(sBmp[8],0,0);
			GUI_SetAlpha(0);
		}
		else
		{
			GUI_DrawBitmap(sBmp[8],0,0);
		}
		break;
	default:
		BUTTON_Callback(pMsg);
	}
}

//button11 (ok键) callback函数. 仅用于输wifi密码界面
//callback function of button11 ("back" button). Only used in wifi password screen.
static void _cbButton11(WM_MESSAGE*pMsg)
{
	WM_HWIN hWin;
	hWin=pMsg->hWin;
	switch(pMsg->MsgId)
	{
	case WM_PAINT:
		if(BUTTON_IsPressed(hWin))
		{
			GUI_SetBkColor(GUI_WHITE);
			//GUI_Clear();
			GUI_SetAlpha(0xb0);
			GUI_DrawBitmap(sBmp[9],0,0);
			GUI_SetAlpha(0);
		}
		else
		{
			GUI_DrawBitmap(sBmp[9],0,0);
		}
		break;
	default:
		BUTTON_Callback(pMsg);
	}
}

//button41 (close键) callback函数. 用于setting界面中滑动控件中各个项的子界面中的关闭按钮。
//callback function of button41 ("back" button). Used in child window of each item in setting screen.
static void _cbButton41(WM_MESSAGE*pMsg)
{
	WM_HWIN hWin;
	hWin=pMsg->hWin;
	switch(pMsg->MsgId)
	{
	case WM_PAINT:
		if(BUTTON_IsPressed(hWin))
		{
			GUI_SetBkColor(GUI_WHITE);
			//GUI_Clear();
			GUI_SetAlpha(0xb0);
			GUI_DrawBitmap(pBmp[2],0,0);
			GUI_SetAlpha(0);
		}
		else
		{
			GUI_DrawBitmap(pBmp[2],0,0);
		}
		break;
	default:
		BUTTON_Callback(pMsg);
	}
}

//button42 (天气切换键) callback函数. 用于天气界面中3种天气的切换。
//callback function of button42 ("offline weather select" button). Use to switch weather screens from "light rain" to "sunny".
static void _cbButton42(WM_MESSAGE*pMsg)
{
	WM_HWIN hWin;
	hWin=pMsg->hWin;
	switch(pMsg->MsgId)
	{
	case WM_PAINT:
		if(BUTTON_IsPressed(hWin))
		{
			GUI_SetBkColor(GUI_WHITE);
			GUI_SetAlpha(0xb0);
			GUI_DrawBitmap(wBmp[0],0,0);
			GUI_SetAlpha(0);

		}
		else
		{
			GUI_DrawBitmap(wBmp[0],0,0);
		}
		break;
	default:
		BUTTON_Callback(pMsg);
	}
}

//button43 (天气切换键) callback函数. 用于天气界面中3种天气的切换。
//callback function of button43 ("offline weather select" button). Use to switch weather screens from "sunny" to "cloudy".
static void _cbButton43(WM_MESSAGE*pMsg)
{
	WM_HWIN hWin;
	hWin=pMsg->hWin;
	switch(pMsg->MsgId)
	{
	case WM_PAINT:
		if(BUTTON_IsPressed(hWin))
		{
			GUI_SetBkColor(GUI_WHITE);
			GUI_SetAlpha(0xb0);
			GUI_DrawBitmap(wBmp[1],0,0);
			GUI_SetAlpha(0);

		}
		else
		{
			GUI_DrawBitmap(wBmp[1],0,0);
		}
		break;
	default:
		BUTTON_Callback(pMsg);
	}
}



//button44 (天气切换键) callback函数. 用于天气界面中3种天气的切换。
//callback function of button44 ("offline weather select" button). Use to switch weather screens from "cloudy" to "light-rain".
static void _cbButton44(WM_MESSAGE*pMsg)
{
	WM_HWIN hWin;
	hWin=pMsg->hWin;
	switch(pMsg->MsgId)
	{
	case WM_PAINT:
		if(BUTTON_IsPressed(hWin))
		{
			GUI_SetBkColor(GUI_WHITE);
			GUI_SetAlpha(0xb0);
			GUI_DrawBitmap(wBmp[2],0,0);
			GUI_SetAlpha(0);

		}
		else
		{
			GUI_DrawBitmap(wBmp[2],0,0);
		}
		break;
	default:
		BUTTON_Callback(pMsg);
	}
}

static WM_HWIN _hKeyboard;

//button (键盘各个按键) callback函数. 用于输入密码
//callback function of button (button in virtual keyboard). Use to type character.
static void _cbButton(WM_MESSAGE * pMsg) {
	GUI_RECT Rect;
	int      State;
	char     acText[4];

	switch (pMsg->MsgId) {
	case WM_PAINT:
		//
		// Handle the look of the buttons
		//
		WM_GetClientRect(&Rect);
		State = BUTTON_IsPressed(pMsg->hWin);                                       // Get the state of the button and use it
		GUI_SetColor(
			_Colors.aColorBK[State]);                                      // as an index to choose a proper color (in this case the BK colors set are identical)
		GUI_FillRoundedRect(Rect.x0, Rect.y0, Rect.x1, Rect.y1, 3);                 // Fill a rounded rectangle with the color
		GUI_SetColor(_Colors.aColorFrame[State]);                                   // Choose a color for the button frame and the txt to be displayed
		GUI_DrawRoundedRect(Rect.x0, Rect.y0, Rect.x1, Rect.y1, 3);                 // Draw a rounded rectangle around the button
		GUI_DrawRoundedRect(Rect.x0 + 1, Rect.y0 + 1, Rect.x1 - 1, Rect.y1 - 1, 3); // And another one
		BUTTON_GetText(pMsg->hWin, acText, sizeof(acText));
		//GUI_SetColor(GUI_WHITE);
		GUI_SetFont(&GUI_Font20_1);                        // Get Button text
		GUI_SetTextMode(GUI_TM_TRANS);
		Rect.x0 += 2;
		GUI_DispStringInRect(acText, &Rect, GUI_TA_HCENTER | GUI_TA_VCENTER);       // Display the button text inside the button rectangle
		break;
	default:
		BUTTON_Callback(pMsg);
		break;
	}
}


//keyboard callback函数. 
//callback function of virtual keyboard.
static void _cbKeybord(WM_MESSAGE * pMsg) {
	GUI_RECT Rect;
	WM_HWIN  hItem;
	WM_HWIN  hParent;
	int      NCode;
	int      Id;
	int      i;
	char     c;
	char     acTextSrc[100 + 1];
	char     acTextDest[100 + 1];
	int      Len;

	switch (pMsg->MsgId) {
	case WM_INIT_DIALOG:
		//
		// Set a custom callback for each button
		for (i = 0; i <= ID_BUTTON_40 - ID_BUTTON_12; i++) {
			hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_12 + i);
			WM_SetCallback(hItem, _cbButton);
		}
		break;
	case WM_PAINT:
		//
		// Fill background with black and draw a frame around the keyboard window
		//
		GUI_SetBkColor(GUI_BLACK);
		GUI_Clear();
		WM_GetClientRect(&Rect);
		GUI_SetColor(COLOR_BUTTON_FRAME_0);
		// GUI_SetColor(GUI_LIGHTGRAY);
		GUI_DrawRoundedRect(0, 0, Rect.x1, Rect.y1 + 5, 5);
		break;
	case WM_NOTIFY_PARENT:
		//
		// The important part
		//
		Id    = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;
		switch(NCode) {
		case WM_NOTIFICATION_RELEASED:
			//
			// Get the parent window of the keyboard (it's the main dialog with the edit widget)
			//
			hParent = WM_GetParent(pMsg->hWin);
			//
			// With the handle of the parent window we can get the edit handle by its ID
			//
			hItem   = WM_GetDialogItem(hParent, ID_EDIT_0);
			//
			// Set Focus on the edit widget to make sure it gets the key input
			//
			WM_SetFocus(hItem);
			if (Id < ID_BUTTON_38) {
				//
				// With the ID of the pressed button calculate the character which should be displayed
				//
				c = 'a' + (Id - ID_BUTTON_12);
				//
				// Store key messages, important that we generate two since every key needs to be released, too
				//
				GUI_StoreKeyMsg(c, 1);
				GUI_StoreKeyMsg(c, 0);
			} else if (Id == ID_BUTTON_38) {  // Back button
				//
				// Get the text currently shown in the edit widget, manipulate it and write it back
				//
				EDIT_GetText(hItem, acTextSrc, sizeof(acTextSrc));  // Get
				Len = strlen(acTextSrc);
				if (Len > 0) {
					acTextSrc[Len - 1] = '\0';                        // Adapt
					EDIT_SetText(hItem, acTextSrc);                   // Write back
				}
			} else if (Id == ID_BUTTON_39) {                      // Clr button
				EDIT_SetText(hItem, "");                            // Simply set noting as text
			} else if (Id == ID_BUTTON_40) {                      // Space button
				c = ' ';                                            // Same as other characters
				GUI_StoreKeyMsg(c, 1);
				GUI_StoreKeyMsg(c, 0);
			}
			break;
		}
		break;
	default:
		WM_DefaultProc(pMsg);
		break;
	}
}



/*
*********************************************************************************************************
* 各个参数的回调函数
* Callback function of each diaglogs. 
*********************************************************************************************************
*/
static void _cbDialog1(WM_MESSAGE * pMsg);
static void _cbDialog3(WM_MESSAGE * pMsg);
static void _cbDialog4(WM_MESSAGE * pMsg);
static void _cbDialog5(WM_MESSAGE * pMsg);
static void _cbDialog6(WM_MESSAGE * pMsg);
static void _cbDialog7(WM_MESSAGE * pMsg);
static void _cbDialog8(WM_MESSAGE * pMsg);
static void _cbDialog9(WM_MESSAGE * pMsg);
static void _cbDialog10(WM_MESSAGE* pMsg);
static void _cbDialog14(WM_MESSAGE* pMsg);
static void _cbDialog15(WM_MESSAGE* pMsg);
static void _cbDialog16(WM_MESSAGE* pMsg);
static void _cbDialog17(WM_MESSAGE* pMsg);

static void _cbChildWin0(WM_MESSAGE* pMsg);
static void _cbChildWin1(WM_MESSAGE* pMsg);
static void _cbChildWin2(WM_MESSAGE* pMsg);


//主界面
//Main screen (home page)
static void _cbDialog1(WM_MESSAGE * pMsg)
{
	WM_HWIN hItem;
	int NCode;
	int Id;
	hItem = pMsg->hWin;

	switch (pMsg->MsgId)
	{
	case WM_PAINT:

		GUI_MEMDEV_WriteAt(hMem0,0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_2);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[0],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_3);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[1],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_4);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[2],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_5);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[3],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_6);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[4],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_7);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[5],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_8);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[6],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_9);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[7],0,0);
		break;

	case WM_INIT_DIALOG:

		WM_SetCreateFlags(WM_CF_MEMDEV);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_2);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton2);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_3);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton3);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_4);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton4);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_5);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton5);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_6);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton6);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_7);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton7);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_8);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton8);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_9);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton9);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_0);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontdantuoshui);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_1);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontpiaoxituoshui);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr1);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_2);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontdanhonggan);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr2);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_3);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontsuxi);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr3);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_4);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fonttongzijie);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr4);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_22);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontxiatongmoshi);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr20);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_26);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font13B_1);
		TEXT_SetText(hItem, "20:15");

		break;

	case WM_NOTIFY_PARENT:
		Id = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;
		switch(Id)
		{
		case ID_BUTTON_2:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				//WM_DeleteWindow(hItem);
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate3, GUI_COUNTOF(_aDialogCreate3), _cbDialog3, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_3:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate4, GUI_COUNTOF(_aDialogCreate4), _cbDialog4, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_4:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate5, GUI_COUNTOF(_aDialogCreate5), _cbDialog5, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_5:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate6, GUI_COUNTOF(_aDialogCreate6), _cbDialog6, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_6:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate7, GUI_COUNTOF(_aDialogCreate7), _cbDialog7, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_7:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate9, GUI_COUNTOF(_aDialogCreate9), _cbDialog9, WM_HBKWIN, 0, 0);


				break;
			}
			break;

		case ID_BUTTON_8:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate1, GUI_COUNTOF(_aDialogCreate1), _cbDialog1, WM_HBKWIN, 0, 0);
				break;
			}
			break;



		case ID_BUTTON_9:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate8, GUI_COUNTOF(_aDialogCreate8), _cbDialog8, WM_HBKWIN, 0, 0);
				break;
			}
			break;
		}
		break;

	default:
		WM_DefaultProc(pMsg);
		break;
	}
}



static int Count1 = 0;
static int Count2 = 0;
static int Count3 = 0;
static int Count4 = 0;
static int Count5 = 0;
static int Count6 = 0;
static int Count7 = 0;
//static int Count8 = 0;
static int IsPressed=0;

//漂洗+脱水界面
//"wash" screen
static void _cbDialog3(WM_MESSAGE * pMsg)
{
	WM_HWIN hItem;
	char buf[10];
	int NCode;
	int Id;
	hItem = pMsg->hWin;

	switch (pMsg->MsgId)
	{
	case WM_PAINT:

		GUI_MEMDEV_WriteAt(hMem0,0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_0);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,pBmp[0],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_7);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[5],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_8);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[6],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_9);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[7],0,0);

		break;

	case WM_INIT_DIALOG:

		WM_SetCreateFlags(WM_CF_MEMDEV);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_0);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton0);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_7);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton7);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_8);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton8);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_9);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton9);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_5);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontxidi);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr5);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_6);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontpiaoxi);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr6);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_7);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fonttuoshui);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr7);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_8);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font30m);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr8);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_9);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font2t);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr9);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_10);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font6m);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr10);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_11);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font_piaoxituoshui);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr11);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_22);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontxiatongmoshi);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr20);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_23);
		TEXT_SetTextColor(hItem,GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font32B_1);


		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_24);
		TEXT_SetTextColor(hItem,GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font32B_1);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_25);
		TEXT_SetTextColor(hItem,GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font32B_1);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_26);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font13B_1);
		TEXT_SetText(hItem, "20:15");

		break;

	case WM_TIMER:
		if(WM_GetTimerId(pMsg->Data.v) == ID_TimerMin)
		{
			Count1++;
			if(Count1<=36) {
				sprintf(buf, "%02d", 36-Count1);
				TEXT_SetText(WM_GetDialogItem(pMsg->hWin,ID_TEXT_23), (const char *)buf);
				//TEXT_SetText(hItem, (const char *)buf);
				WM_RestartTimer(pMsg->Data.v, 60000);
			}
			else
			{
				sprintf(buf, "%02d", 0);
				TEXT_SetText(WM_GetDialogItem(pMsg->hWin,ID_TEXT_23), (const char *)buf);
				//TEXT_SetText(hItem, (const char *)buf);
				WM_DeleteTimer(pMsg->Data.v);
			}
		}
		else if(WM_GetTimerId(pMsg->Data.v) == ID_TimerSec)
		{
			Count2++;
			if(Count2<=60) {
				sprintf(buf, "%02d", 60-Count2);
				TEXT_SetText(WM_GetDialogItem(pMsg->hWin, ID_TEXT_25), (const char*)buf);
				//TEXT_SetText(hItem, (const char *)buf);
				WM_RestartTimer(pMsg->Data.v, 1000);
			}
			else if(Count1<=36) {
				//Count2=0;
				sprintf(buf, "%02d", 60*Count1-Count2);
				TEXT_SetText(WM_GetDialogItem(pMsg->hWin, ID_TEXT_25), (const char*)buf);
				//TEXT_SetText(hItem, (const char *)buf);
				WM_RestartTimer(pMsg->Data.v, 1000);
			}
			else {
				sprintf(buf, "%02d", 0);
				TEXT_SetText(WM_GetDialogItem(pMsg->hWin,ID_TEXT_25), (const char *)buf);
				//TEXT_SetText(hItem, (const char *)buf);
				WM_DeleteTimer(pMsg->Data.v);
			}
		}
		break;

	case WM_NOTIFY_PARENT:
		Id = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;
		switch(Id)
		{
		case ID_BUTTON_0:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:

				IsPressed++;
				break;
			case WM_NOTIFICATION_RELEASED:
				//  WM_SendMessageNoPara(hWin, WM_TIMER);
				if(IsPressed==1) {
					WM_CreateTimer(hItem,
								   ID_TimerMin,
								   1000,
								   0);
					WM_CreateTimer(hItem,
								   ID_TimerSec,
								   1000,
								   0);
				}

				break;
			}
			break;

		case ID_BUTTON_7:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate9, GUI_COUNTOF(_aDialogCreate9), _cbDialog9, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_8:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:

				// WM_DeleteWindow(hItem);
				Count1=0;
				Count2=0;
				IsPressed=0;
				GUI_EndDialog(hItem, 0);
				GUI_CreateDialogBox(_aDialogCreate1, GUI_COUNTOF(_aDialogCreate1), _cbDialog1, WM_HBKWIN, 0, 0);
				//      WM_DeleteTimer(pMsg->hWin);
				break;
			}
			break;

		case ID_BUTTON_9:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:

				// WM_DeleteWindow(hItem);
				Count1=0;
				Count2=0;
				IsPressed=0;
				GUI_EndDialog(hItem, 0);
				GUI_CreateDialogBox(_aDialogCreate8, GUI_COUNTOF(_aDialogCreate8), _cbDialog8, WM_HBKWIN, 0, 0);
				//      WM_DeleteTimer(pMsg->hWin);
				break;
			}

			break;
		}
		break;
	default:
		WM_DefaultProc(pMsg);
		break;
	}
}

//单脱水界面
//"dry" screen
static void _cbDialog4(WM_MESSAGE * pMsg)
{
	WM_HWIN hItem;
	char buf[10];
	int NCode;
	int Id;
	hItem = pMsg->hWin;

	switch (pMsg->MsgId)
	{
	case WM_PAINT:

		GUI_MEMDEV_WriteAt(hMem0,0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_0);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,pBmp[0],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_7);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[5],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_8);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[6],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_9);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[7],0,0);

		break;

	case WM_INIT_DIALOG:

		WM_EnableMemdev(hItem);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_0);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton0);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_7);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton7);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_8);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton8);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_9);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton9);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_7);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fonttuoshui);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr7);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_10);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font6m);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr10);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_12);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font_dantuoshui);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr12);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_22);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontxiatongmoshi);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr20);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_23);
		TEXT_SetTextColor(hItem,GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font32B_1);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_24);
		TEXT_SetTextColor(hItem,GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font32B_1);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_25);
		TEXT_SetTextColor(hItem,GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font32B_1);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_26);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font13B_1);
		TEXT_SetText(hItem, "20:15");

		break;

	case WM_TIMER:
		if(WM_GetTimerId(pMsg->Data.v) == ID_TimerMin)
		{
			Count3++;
			if(Count3<=6) {
				sprintf(buf, "%02d", 6-Count3);
				TEXT_SetText(WM_GetDialogItem(pMsg->hWin,ID_TEXT_23), (const char *)buf);
				//TEXT_SetText(hItem, (const char *)buf);
				WM_RestartTimer(pMsg->Data.v, 60000);

			}
			else
			{
				sprintf(buf, "%02d", 0);
				TEXT_SetText(WM_GetDialogItem(pMsg->hWin,ID_TEXT_23), (const char *)buf);
				//TEXT_SetText(hItem, (const char *)buf);
				WM_DeleteTimer(pMsg->Data.v);
			}

		}
		else if(WM_GetTimerId(pMsg->Data.v) == ID_TimerSec)
		{
			Count4++;
			if(Count4<=60) {
				sprintf(buf, "%02d", 60-Count4);
				TEXT_SetText(WM_GetDialogItem(pMsg->hWin, ID_TEXT_25), (const char*)buf);
				//TEXT_SetText(hItem, (const char *)buf);
				WM_RestartTimer(pMsg->Data.v, 1000);

			}
			else if(Count3<=6) {
				//Count4=0;
				sprintf(buf, "%02d", 60*Count3-Count4);
				TEXT_SetText(WM_GetDialogItem(pMsg->hWin, ID_TEXT_25), (const char*)buf);
				//TEXT_SetText(hItem, (const char *)buf);
				WM_RestartTimer(pMsg->Data.v, 1000);
			}
			else {
				sprintf(buf, "%02d", 0);
				TEXT_SetText(WM_GetDialogItem(pMsg->hWin,ID_TEXT_25), (const char *)buf);
				//TEXT_SetText(hItem, (const char *)buf);
				WM_DeleteTimer(pMsg->Data.v);
			}
		}
		break;

	case WM_NOTIFY_PARENT:
		Id = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;
		switch(Id)
		{
		case ID_BUTTON_0:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				IsPressed++;
				break;
			case WM_NOTIFICATION_RELEASED:
				if(IsPressed==1) {
					WM_CreateTimer(hItem,
								   ID_TimerMin,
								   1000,
								   0);

					WM_CreateTimer(hItem,
								   ID_TimerSec,
								   1000,
								   0);
				}
				break;
			}
			break;

		case ID_BUTTON_7:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate9, GUI_COUNTOF(_aDialogCreate9), _cbDialog9, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_8:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				Count3=0;
				Count4=0;
				IsPressed=0;
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate1, GUI_COUNTOF(_aDialogCreate1), _cbDialog1, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_9:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				Count3=0;
				Count4=0;
				IsPressed=0;
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate8, GUI_COUNTOF(_aDialogCreate8), _cbDialog8, WM_HBKWIN, 0, 0);
				break;
			}
			break;
		}
		break;

	default:
		WM_DefaultProc(pMsg);
		break;
	}
}

//单烘干界面
//"warm" screen
static void _cbDialog5(WM_MESSAGE * pMsg)
{
	WM_HWIN hItem;
	char buf[10];
	int NCode;
	int Id;
	hItem = pMsg->hWin;

	switch (pMsg->MsgId)
	{
	case WM_PAINT:
		GUI_MEMDEV_WriteAt(hMem0,0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_0);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,pBmp[0],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_7);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[5],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_8);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[6],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_9);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[7],0,0);

		break;

	case WM_INIT_DIALOG:

		WM_EnableMemdev(hItem);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_0);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton0);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_7);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton7);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_8);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton8);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_9);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton9);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_16);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fonthonggan);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr16);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_19);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font48m);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr17);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_13);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font_danhonggan);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr13);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_22);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontxiatongmoshi);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr20);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_23);
		TEXT_SetTextColor(hItem,GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font32B_1);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_24);
		TEXT_SetTextColor(hItem,GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font32B_1);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_25);
		TEXT_SetTextColor(hItem,GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font32B_1);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_26);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font13B_1);
		TEXT_SetText(hItem, "20:15");
		break;

	case WM_TIMER:
		if(WM_GetTimerId(pMsg->Data.v) == ID_TimerMin)
		{
			Count5++;
			if(Count5<=48) {
				sprintf(buf, "%02d", 48-Count5);
				TEXT_SetText(WM_GetDialogItem(pMsg->hWin,ID_TEXT_23), (const char *)buf);
				//TEXT_SetText(hItem, (const char *)buf);
				WM_RestartTimer(pMsg->Data.v, 60000);
			}
			else
			{
				sprintf(buf, "%02d", 0);
				TEXT_SetText(WM_GetDialogItem(pMsg->hWin,ID_TEXT_23), (const char *)buf);
				//TEXT_SetText(hItem, (const char *)buf);
				WM_DeleteTimer(pMsg->Data.v);
			}
		}
		else if(WM_GetTimerId(pMsg->Data.v) == ID_TimerSec)
		{
			Count6++;
			if(Count6<=60) {
				sprintf(buf, "%02d", 60-Count6);
				TEXT_SetText(WM_GetDialogItem(pMsg->hWin, ID_TEXT_25), (const char*)buf);
				//TEXT_SetText(hItem, (const char *)buf);
				WM_RestartTimer(pMsg->Data.v, 1000);
			}
			else if(Count5<=48) {
				//Count6=0;
				sprintf(buf, "%02d", 60*Count5-Count6);
				TEXT_SetText(WM_GetDialogItem(pMsg->hWin, ID_TEXT_25), (const char*)buf);
				//TEXT_SetText(hItem, (const char *)buf);
				WM_RestartTimer(pMsg->Data.v, 1000);
			}
			else {
				sprintf(buf, "%02d", 0);
				TEXT_SetText(WM_GetDialogItem(pMsg->hWin,ID_TEXT_25), (const char *)buf);
				//TEXT_SetText(hItem, (const char *)buf);
				WM_DeleteTimer(pMsg->Data.v);
			}
		}
		break;

	case WM_NOTIFY_PARENT:
		Id = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;
		switch(Id)
		{
		case ID_BUTTON_0:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				IsPressed++;
				break;
			case WM_NOTIFICATION_RELEASED:
				if(IsPressed==1) {
					WM_CreateTimer(hItem,
								   ID_TimerMin,
								   1000,
								   0);

					WM_CreateTimer(hItem,
								   ID_TimerSec,
								   1000,
								   0);
				}
				break;
			}
			break;

		case ID_BUTTON_7:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate9, GUI_COUNTOF(_aDialogCreate9), _cbDialog9, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_8:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				Count5=0;
				Count6=0;
				IsPressed=0;
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate1, GUI_COUNTOF(_aDialogCreate1), _cbDialog1, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_9:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				Count5=0;
				Count6=0;
				IsPressed=0;
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate8, GUI_COUNTOF(_aDialogCreate8), _cbDialog8, WM_HBKWIN, 0, 0);
				break;
			}
			break;
		}
		break;

	default:
		WM_DefaultProc(pMsg);
		break;
	}
}

//速洗界面
//"fast" screen
static void _cbDialog6(WM_MESSAGE * pMsg)
{
	WM_HWIN hItem;
	char buf[10];
	int NCode;
	int Id;
	hItem = pMsg->hWin;

	switch (pMsg->MsgId)
	{
	case WM_PAINT:

		GUI_MEMDEV_WriteAt(hMem0,0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_0);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,pBmp[0],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_7);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[5],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_8);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[6],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_9);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[7],0,0);

		break;

	case WM_INIT_DIALOG:
		WM_EnableMemdev(hItem);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_0);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton0);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_7);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton7);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_8);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton8);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_9);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton9);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_17);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontsuxi_small);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr14);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_20);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font30s);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr18);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_14);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font_suxi);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr14);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_22);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontxiatongmoshi);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr20);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_23);
		TEXT_SetTextColor(hItem,GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font32B_1);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_24);
		TEXT_SetTextColor(hItem,GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font32B_1);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_25);
		TEXT_SetTextColor(hItem,GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font32B_1);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_26);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font13B_1);
		TEXT_SetText(hItem, "20:15");
		break;

	case WM_TIMER:
		Count7++;
		if(Count7<30) {
			sprintf(buf, "%02d", 30-Count7);
			TEXT_SetText(WM_GetDialogItem(pMsg->hWin, ID_TEXT_25), (const char*)buf);
			WM_RestartTimer(pMsg->Data.v, 1000);
		}
		else {
			sprintf(buf, "%02d",0);
			TEXT_SetText(WM_GetDialogItem(pMsg->hWin,ID_TEXT_25), (const char *)buf);
			WM_DeleteTimer(pMsg->Data.v);
		}
		break;

	case WM_NOTIFY_PARENT:
		Id = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;
		switch(Id)
		{

		case ID_BUTTON_0:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				IsPressed++;
				break;
			case WM_NOTIFICATION_RELEASED:
				//Count7=0;
				if(IsPressed==1) {
					WM_CreateTimer(hItem,
								   ID_TimerMin,
								   1000,
								   0);
				}
				break;
			}
			break;

		case ID_BUTTON_7:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate9, GUI_COUNTOF(_aDialogCreate9), _cbDialog9, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_8:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				Count7=0;
				IsPressed=0;
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate1, GUI_COUNTOF(_aDialogCreate1), _cbDialog1, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_9:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				Count7=0;
				IsPressed=0;
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate8, GUI_COUNTOF(_aDialogCreate8), _cbDialog8, WM_HBKWIN, 0, 0);
				break;
			}
			break;
		}
		break;

	default:
		WM_DefaultProc(pMsg);
		break;
	}
}


//筒自洁界面
//"clean" screen
static void _cbDialog7(WM_MESSAGE * pMsg)
{
	WM_HWIN hItem;
	int NCode;
	int Id;
	hItem = pMsg->hWin;

	switch (pMsg->MsgId)
	{
	case WM_PAINT:
		GUI_MEMDEV_WriteAt(hMem0, 0, 0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_0);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,pBmp[0],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_7);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[5],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_8);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[6],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_9);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[7],0,0);

		break;

	case WM_INIT_DIALOG:
		WM_EnableMemdev(hItem);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_0);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton0);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_8);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton8);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_9);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton9);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_7);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton7);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_18);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fonttongzijie_small);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr15);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_21);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font12h);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr19);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_15);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font_tongzijie);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr15);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_22);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontxiatongmoshi);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr20);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_26);
		//TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font13B_1);

	case WM_NOTIFY_PARENT:
		Id = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;
		switch(Id)
		{
		case ID_BUTTON_0:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				break;
			}
			break;

		case ID_BUTTON_8:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate1, GUI_COUNTOF(_aDialogCreate1), _cbDialog1, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_9:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate8, GUI_COUNTOF(_aDialogCreate8), _cbDialog8, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_7:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate9, GUI_COUNTOF(_aDialogCreate9), _cbDialog9, WM_HBKWIN, 0, 0);
				break;
			}
			break;
		}
		break;

	default:
		WM_DefaultProc(pMsg);
		break;
	}
}


static int IsNull=0;

//设置界面中滑动列表控件(swipelist)的部分项(1-7)的设置子界面
//Child window of some items(1-7) of swipelist in "setting" screen
static void _cbChildWin0(WM_MESSAGE * pMsg) {
//GUI_COLOR Color;
	WM_HWIN hItem;
	int     NCode;
	int     Id;
	switch (pMsg->MsgId) 
	{
	case WM_INIT_DIALOG:
		hItem=pMsg->hWin;

		hItem = WM_GetDialogItem(pMsg->hWin, ID_RADIO_0);
		//RADIO_CreateEx(15,15,185,185,hItem,WM_CF_SHOW,0,ID_WINDOW_2,2,40);
		RADIO_SetFont(hItem, GUI_FONT_20_ASCII);
		RADIO_SetTextColor(hItem,GUI_WHITE);
		RADIO_SetText(hItem, "OFF", 0);
		RADIO_SetText(hItem, "ON", 1);

		hItem = WM_GetDialogItem(pMsg->hWin,ID_BUTTON_41);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton41);

		break;

	case WM_PAINT:
		//WM_GetUserData(pMsg->hWin, GUI_GRAY, 4);
		GUI_SetBkColor(GUI_LIGHTBLUE);
		GUI_Clear();

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_41);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,pBmp[2],0,0);
		break;

	case WM_NOTIFY_PARENT:
		Id = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;
		switch(Id) {

		case ID_BUTTON_41:
			switch(NCode) {
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				//WM_DeleteWindow(pMsg->hWin);
				IsNull=0;
				GUI_EndDialog(pMsg->hWin,0 );
				break;
			}

		case ID_RADIO_0:
			switch(NCode) {
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				break;
			case WM_NOTIFICATION_VALUE_CHANGED:
				break;
			}
		}
		break;
	default:
		WM_DefaultProc(pMsg);
		break;
	}
}

//设置界面中滑动列表控件(swipelist)的第8项的设置子界面
//Child window of item 8 of swipelist in "setting" screen
static void _cbChildWin1(WM_MESSAGE * pMsg)
{
	WM_HWIN hItem;
	int     NCode;
	int     Id;
	switch (pMsg->MsgId) 
	{
	case WM_INIT_DIALOG:

		hItem=pMsg->hWin;
		hItem = WM_GetDialogItem(pMsg->hWin, ID_RADIO_1);
		//RADIO_CreateEx(15,15,185,185,hItem,WM_CF_SHOW,0,ID_WINDOW_2,2,40);

		RADIO_SetTextColor(hItem,GUI_WHITE);
		RADIO_SetText(hItem, "15 min", 0);
		RADIO_SetText(hItem, "30 min", 1);
		RADIO_SetText(hItem, "1 hour", 2);
		RADIO_SetText(hItem, "1.5 hour", 3);
		RADIO_SetFont(hItem, GUI_FONT_20_ASCII);

		hItem = WM_GetDialogItem(pMsg->hWin,ID_BUTTON_41);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton41);

		break;

	case WM_PAINT:
		//WM_GetUserData(pMsg->hWin, GUI_GRAY, 4);
		GUI_SetBkColor(GUI_LIGHTBLUE);
		GUI_Clear();

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_41);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,pBmp[2],0,0);
		break;

	case WM_NOTIFY_PARENT:
		Id = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;
		switch(Id) {

		case ID_BUTTON_41:
			switch(NCode) {
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				//WM_DeleteWindow(pMsg->hWin);
				IsNull=0;
				GUI_EndDialog(pMsg->hWin,0 );
				break;
			}

		case ID_RADIO_0:
			switch(NCode) {
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				break;
			case WM_NOTIFICATION_VALUE_CHANGED:
				break;
			}
		}
		break;
	default:
		WM_DefaultProc(pMsg);
		break;
	}
}

//设置界面中滑动列表控件(swipelist)的第9项的设置子界面
//Child window of item 9 of swipelist in "setting" screen
static void _cbChildWin2(WM_MESSAGE * pMsg) {
//GUI_COLOR Color;
	WM_HWIN hItem;
	int     NCode;
	int     Id;
	switch (pMsg->MsgId) {
	case WM_INIT_DIALOG:

		hItem=pMsg->hWin;
		hItem = WM_GetDialogItem(pMsg->hWin, ID_RADIO_2);
		//RADIO_CreateEx(15,15,185,185,hItem,WM_CF_SHOW,0,ID_WINDOW_2,2,40);

		RADIO_SetTextColor(hItem,GUI_WHITE);
		RADIO_SetText(hItem, "Spring", 0);
		RADIO_SetText(hItem, "Summer", 1);
		RADIO_SetText(hItem, "Fall", 2);
		RADIO_SetText(hItem, "Winter", 3);
		RADIO_SetFont(hItem, GUI_FONT_20_ASCII);
		hItem = WM_GetDialogItem(pMsg->hWin,ID_BUTTON_41);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton41);

		break;

	case WM_PAINT:
		//WM_GetUserData(pMsg->hWin, GUI_GRAY, 4);
		GUI_SetBkColor(GUI_LIGHTBLUE);
		GUI_Clear();

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_41);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,pBmp[2],0,0);
		break;

	case WM_NOTIFY_PARENT:
		Id = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;
		switch(Id) {

		case ID_BUTTON_41:
			switch(NCode) {
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				//WM_DeleteWindow(pMsg->hWin);
				IsNull=0;
				GUI_EndDialog(pMsg->hWin,0 );
				break;
			}

		case ID_RADIO_0:
			switch(NCode) {
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				break;
			case WM_NOTIFICATION_VALUE_CHANGED:
				break;
			}
		}
		break;
	default:
		WM_DefaultProc(pMsg);
		break;
	}
}



//设置界面中滑动列表控件(swipelist)的部分项(1-7)的设置子界面
//Child window of some items(1-7) of swipelist in "setting" screen
WM_HWIN CreateChild0(void);
WM_HWIN CreateChild0(void) {
	WM_HWIN hWin;
	hWin = GUI_CreateDialogBox(_aDialogCreate11, GUI_COUNTOF(_aDialogCreate11), _cbChildWin0, WM_HBKWIN, 0, 0);
	return hWin;
}

//设置界面中滑动列表控件(swipelist)的第8项的设置子界面
//Child window of item 8 of swipelist in "setting" screen
WM_HWIN CreateChild1(void);
WM_HWIN CreateChild1(void) {
	WM_HWIN hWin;
	hWin = GUI_CreateDialogBox(_aDialogCreate12, GUI_COUNTOF(_aDialogCreate12), _cbChildWin1, WM_HBKWIN, 0, 0);
	return hWin;
}

//设置界面中滑动列表控件(swipelist)的第9项的设置子界面
//Child window of item 9 of swipelist in "setting" screen
WM_HWIN CreateChild2(void);
WM_HWIN CreateChild2(void) {
	WM_HWIN hWin;
	hWin = GUI_CreateDialogBox(_aDialogCreate13, GUI_COUNTOF(_aDialogCreate13), _cbChildWin2, WM_HBKWIN, 0, 0);
	return hWin;
}



//设置界面
//"setting" screen
static void _cbDialog8(WM_MESSAGE * pMsg) {
	WM_HWIN  hItem;
	WM_HWIN  hSwipelist;
	WM_HWIN  hChildwin0;
	WM_HWIN  hRadio;
	//WM_HWIN  hWin0;
	int NCode;
	int Id;
	int i;
	int j;
	static int ItemIndex=0;

	switch (pMsg->MsgId) 
	{
	case WM_INIT_DIALOG:

		WM_EnableMemdev(hItem);
		WM_MOTION_Enable(1);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_10);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton10);

		hSwipelist = WM_GetDialogItem(pMsg->hWin, ID_SWIPELIST_0);
		// WM_SetCallback(hItem, _cbSwipe);
		WM_MOTION_SetMoveable(hSwipelist, WM_CF_MOTION_Y, 1);
		SWIPELIST_SetDefaultBkColor(SWIPELIST_CI_BK_ITEM_SEL, GUI_DARKRED);
		SWIPELIST_SetFont(hSwipelist,SWIPELIST_FI_ITEM_HEADER,&GUI_Font16B_1);

		for (j = 0; j < NUM_SEPARATORS; j++) {
			SWIPELIST_AddSepItem(hSwipelist, paSeperatorText[j], 50);
			for (i = 0; i < NUM_ITEMS; i++) {
				SWIPELIST_AddItem(hSwipelist, paItemText[j][i], 45);
			}
		}

		break;

	case WM_PAINT:
		GUI_SetBkColor(GUI_LIGHTGRAY);
		GUI_Clear();

		hSwipelist = WM_GetDialogItem(pMsg->hWin, ID_SWIPELIST_0);
		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_10);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,pBmp[8],0,0);

		break;

	case WM_NOTIFY_PARENT:
		Id = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;

		switch(Id) {
		case ID_SWIPELIST_0: // Notifications sent by &#39;Swipelist&#39;
			switch(NCode) {
			case WM_NOTIFICATION_CLICKED:
				break;

			case WM_NOTIFICATION_RELEASED:
				hItem = WM_GetDialogItem(pMsg->hWin, ID_SWIPELIST_0);
				ItemIndex = SWIPELIST_GetReleasedItem(hItem);
				//  WM_InvalidateRect(pMsg->hWin, &TRect);
				switch(ItemIndex) {

				case 1:
					GUI_EndDialog(pMsg->hWin, 0);
					GUI_CreateDialogBox(_aDialogCreate17, GUI_COUNTOF(_aDialogCreate17), _cbDialog17, WM_HBKWIN, 0, 0);
					break;

				case 2:
				case 3:
				case 4:
				case 6:
				case 7:
					if(IsNull==0) {
						CreateChild0();
						IsNull++;
					}
					break;

				case 8:
					if(IsNull==0) {
						CreateChild1();
						IsNull++;
					}
					// WM_CreateWindowAsChild( 255, 70,200, 200, pMsg->hWin, WM_CF_SHOW, _cbChildWin1, 0);
					break;

				case 9:
					if(IsNull==0) {
						CreateChild2();
						IsNull++;
					}
					// WM_CreateWindowAsChild( 255, 70,200, 200, pMsg->hWin, WM_CF_SHOW, _cbChildWin2, 0);
					break;
				}

				break;
			}
			break;

		case ID_BUTTON_10:
			switch(NCode) {
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate1, GUI_COUNTOF(_aDialogCreate1), _cbDialog1, WM_HBKWIN, 0, 0);
				break;
			}
			break;
		}
		break;
	default:
		WM_DefaultProc(pMsg);
		break;
	}
}


// wifi列表界面
// "wifi ssid list" screen
static void _cbDialog9(WM_MESSAGE * pMsg)
{
	WM_HWIN hSwipelist;
	WM_HWIN hItem;
	static int ItemIndex=0;

	char Buffer[20];
	int NCode;
	int Id;
	int i;
	hItem = pMsg->hWin;

	switch (pMsg->MsgId)
	{
	case WM_INIT_DIALOG:
		WM_EnableMemdev(hItem);
		WM_MOTION_Enable(1);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_10);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton10);

		hSwipelist = WM_GetDialogItem(pMsg->hWin, ID_SWIPELIST_1);
		//WM_SetCallback(hItem, _cbSwipe);
		WM_MOTION_SetMoveable(hSwipelist, WM_CF_MOTION_Y, 1);
		SWIPELIST_SetDefaultBkColor(SWIPELIST_CI_BK_ITEM_SEL, GUI_DARKRED);

		for (i = 0; i < NUM_ITEMS_2; i++) {
			SWIPELIST_AddItem(hSwipelist, saItemText[i], 35);
			//SWIPELIST_AddItem(hSwipelist,Buffer[i],35);
		}

		break;

	case WM_NOTIFY_PARENT:
		Id = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;
		switch(Id)
		{

		case ID_BUTTON_10:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate1, GUI_COUNTOF(_aDialogCreate1), _cbDialog1, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_SWIPELIST_1: // Notifications sent by &#39;Swipelist&#39;
			switch(NCode) {

			case WM_NOTIFICATION_CLICKED:
				break;

			case WM_NOTIFICATION_RELEASED:
				hItem = WM_GetDialogItem(pMsg->hWin, ID_SWIPELIST_1);
				ItemIndex = SWIPELIST_GetReleasedItem(hItem);
				switch(ItemIndex) {
				case 0:
				case 1:
				case 2:
				case 3:
				case 4:
				case 5:
				case 6:
				case 7:
				case 8:
				case 9:
				case 10:
				case 11:
				case 12:
				case 13:
				case 14:
					GUI_CreateDialogBox(_aDialogCreate10, GUI_COUNTOF(_aDialogCreate10), _cbDialog10, WM_HBKWIN, 0, 0);
					break;

				case 15:
				case 16:
				case 17:
				case 18:
				case 19:
					break;

				}
				break;
			}
			break;
		}
		break;

	case WM_PAINT:
		GUI_SetBkColor(GUI_LIGHTGRAY);
		GUI_Clear();

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_10);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,pBmp[8],0,0);

		break;

	default:
		WM_DefaultProc(pMsg);
		break;
	}
}



// 虚拟键盘界面
// virtual keyboard to type wifi password 
WM_HWIN CreateKeyboard(void);
WM_HWIN CreateKeyboard(void) {
	static WM_HWIN hWin;
	int xSize, ySize;
	int xPos,  yPos;

	GUI_Init();
	//
	// Create te main dialog containing an edit widget and a keyboard dialog
	//
	hWin       = GUI_CreateDialogBox(_aDialogCreate10, GUI_COUNTOF(_aDialogCreate10), _cbDialog10, WM_HBKWIN, 0, 0);
	//
	// Get some properties and calculate the x and y position for the keaboard
	//
	xSize      = WM_GetWindowSizeX(hWin);
	ySize      = WM_GetWindowSizeY(hWin);
	xPos       = (xSize - ((40 + 5) * 10 + 5)) / 2;
	yPos       = ySize  - ((40 + 5) *  3 + 5);
	//
	// Create the keyboard dialog as a child of the main dialog, but hide it for the beginning
	//
	_hKeyboard = GUI_CreateDialogBox(_aKeyboardDialogCreate, GUI_COUNTOF(_aKeyboardDialogCreate), _cbKeybord, hWin, xPos, yPos);
	WM_HideWindow(_hKeyboard);  // It's hidden
	return hWin;

}

// wifi密码输入框
// Input box of wifi password
static void _cbDialog10(WM_MESSAGE * pMsg) {
	WM_HWIN hItem;
	int     NCode;
	int     Id;

	static WM_HWIN hWin;
	int xSize, ySize;
	int xPos,  yPos;
	hItem = pMsg->hWin;

	switch (pMsg->MsgId) {
	case WM_INIT_DIALOG:

		hItem = WM_GetDialogItem(pMsg->hWin, ID_EDIT_0);
		EDIT_SetText(hItem, "");
		EDIT_SetFont(hItem,&GUI_Font16B_1);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_10);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton10);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_11);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton11);
		break;

	case WM_NOTIFY_PARENT:
		Id    = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;
		switch(Id) {
		case ID_EDIT_0: // Notifications sent by 'Edit'
			switch(NCode) {
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				CreateKeyboard();
				WM_ShowWindow(_hKeyboard);
				break;
			}
			break;

		case ID_BUTTON_10:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate9, GUI_COUNTOF(_aDialogCreate9), _cbDialog9, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_11:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate1, GUI_COUNTOF(_aDialogCreate1), _cbDialog1, WM_HBKWIN, 0, 0);
				break;
			}
			break;
		}
		break;

	case WM_PAINT:
		GUI_SetBkColor(GUI_LIGHTGRAY);
		GUI_Clear();
		
		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_10);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[8],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_11);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[9],0,0);

		break;

	default:
		WM_DefaultProc(pMsg);
		break;
	}
}

//在线和离线天气选择界面
//"online or offline weather select" screen
static void _cbDialog17(WM_MESSAGE * pMsg)
{
	WM_HWIN hItem;
	int NCode;
	int Id;
	int i;
	hItem = pMsg->hWin;

	switch (pMsg->MsgId)
	{
	case WM_PAINT:
		GUI_MEMDEV_WriteAt(hMem0,0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_10);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[8],0,0);

		break;

	case WM_INIT_DIALOG:
		WM_EnableMemdev(hItem);
		WM_MOTION_Enable(1);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_10);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton10);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_45);
		WM_SetHasTrans(hItem);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_46);
		WM_SetHasTrans(hItem);

		break;

	case WM_NOTIFY_PARENT:
		Id = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;
		switch(Id)
		{
		case ID_BUTTON_10:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate1, GUI_COUNTOF(_aDialogCreate1), _cbDialog1, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_45:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				break;
			}
			break;

		case ID_BUTTON_46:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate14, GUI_COUNTOF(_aDialogCreate14), _cbDialog14, WM_HBKWIN, 0, 0);
				break;
			}
			break;
		}
		break;
	default:
		WM_DefaultProc(pMsg);
		break;
	}
}


//离线天气界面1
//"offline whether" screen1
static void _cbDialog14(WM_MESSAGE * pMsg)
{
	WM_HWIN hItem;
	int NCode;
	int Id;
	int i;
	hItem = pMsg->hWin;

	switch (pMsg->MsgId)
	{
	case WM_PAINT:
		//GUI_MEMDEV_WriteAt(hMem0,0,0);
		GUI_SetBkColor(GUI_LIGHTGRAY);
		GUI_Clear();

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_10);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[8],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_42);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,wBmp[0],0,0);

		break;

	case WM_INIT_DIALOG:

		WM_EnableMemdev(hItem);
		WM_MOTION_Enable(1);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_10);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton10);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_42);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton42);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_27);//地点：苏州
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontsuzhoushi);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr21);


		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_32);//温度
		TEXT_SetTextColor(hItem,GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font32B_1);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_28);//摄氏度
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontsheshidu);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr22);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_29);//小雨
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontxiaoyu);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr26);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_30);//不适宜洗衣
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_FontBadWash);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr27);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_31);//建议烘干模式
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_FontMachineWarm);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr28);

		break;

	case WM_NOTIFY_PARENT:
		Id = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;
		switch(Id)
		{
		case ID_BUTTON_10:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate1, GUI_COUNTOF(_aDialogCreate1), _cbDialog1, WM_HBKWIN, 0, 0);
				break;
			}
			break;

		case ID_BUTTON_42:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate15, GUI_COUNTOF(_aDialogCreate15), _cbDialog15, WM_HBKWIN, 0, 0);
				break;
			}
			break;
		}
		break;
	default:
		WM_DefaultProc(pMsg);
		break;
	}
}

//离线天气界面2
//"offline whether" screen2
static void _cbDialog15(WM_MESSAGE * pMsg)
{
	WM_HWIN hItem;
	int NCode;
	int Id;
	int i;
	hItem = pMsg->hWin;

	switch (pMsg->MsgId)
	{
	case WM_PAINT:
		//GUI_MEMDEV_WriteAt(hMem0,0,0);
		GUI_SetBkColor(GUI_WHITE);
		GUI_Clear();

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_10);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[8],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_43);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,wBmp[1],0,0);

		break;

	case WM_INIT_DIALOG:

		WM_EnableMemdev(hItem);
		WM_MOTION_Enable(1);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_10);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton10);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_43);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton43);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_27);//地点：苏州
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontsuzhoushi);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr21);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_32);//温度
		TEXT_SetTextColor(hItem,GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font32B_1);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_28);//摄氏度
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontsheshidu);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr22);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_29);//小雨
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontqingtian);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr23);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_30);//不适宜洗衣
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_FontGoodWash);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr24);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_31);//建议烘干模式
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_FontGoodWarm);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr25);

		break;

	case WM_NOTIFY_PARENT:
		Id = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;
		switch(Id)
		{
		case ID_BUTTON_10:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate1, GUI_COUNTOF(_aDialogCreate1), _cbDialog1, WM_HBKWIN, 0, 0);
				break;
			}
			break;
		case ID_BUTTON_43:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate16, GUI_COUNTOF(_aDialogCreate16), _cbDialog16, WM_HBKWIN, 0, 0);
				break;
			}
			break;
		}
		break;
	default:
		WM_DefaultProc(pMsg);
		break;
	}
}

//离线天气界面3
//"offline whether" screen3
static void _cbDialog16(WM_MESSAGE * pMsg)
{
	WM_HWIN hItem;
	int NCode;
	int Id;
	int i;
	hItem = pMsg->hWin;

	switch (pMsg->MsgId)
	{
	case WM_PAINT:
		//GUI_MEMDEV_WriteAt(hMem0,0,0);
		GUI_SetBkColor(GUI_LIGHTGRAY);
		GUI_Clear();

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_10);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,sBmp[8],0,0);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_44);
		BUTTON_SetBitmapEx(hItem,BUTTON_BI_UNPRESSED,wBmp[2],0,0);

		break;

	case WM_INIT_DIALOG:

		WM_EnableMemdev(hItem);
		WM_MOTION_Enable(1);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_10);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton10);

		hItem=WM_GetDialogItem(pMsg->hWin,ID_BUTTON_44);
		WM_SetHasTrans(hItem);
		WM_SetCallback(hItem,_cbButton44);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_27);//地点：苏州
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontsuzhoushi);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr21);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_32);//温度
		TEXT_SetTextColor(hItem,GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Font32B_1);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_28);//摄氏度
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontsheshidu);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr22);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_29);//多云
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_Fontduoyun);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr29);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_30);//适宜洗衣
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_FontBadWash);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr24);

		hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_31);//建议烘干模式
		TEXT_SetTextColor(hItem, GUI_BLACK);
		TEXT_SetFont(hItem, &GUI_FontMachineWarm);
		GUI_UC_SetEncodeUTF8();
		TEXT_SetText(hItem, pStr28);

		break;

	case WM_NOTIFY_PARENT:
		Id = WM_GetId(pMsg->hWinSrc);
		NCode = pMsg->Data.v;
		switch(Id)
		{
		case ID_BUTTON_10:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate1, GUI_COUNTOF(_aDialogCreate1), _cbDialog1, WM_HBKWIN, 0, 0);
				break;
			}
			break;
		case ID_BUTTON_44:
			switch(NCode)
			{
			case WM_NOTIFICATION_CLICKED:
				break;
			case WM_NOTIFICATION_RELEASED:
				GUI_EndDialog(pMsg->hWin, 0);
				GUI_CreateDialogBox(_aDialogCreate14, GUI_COUNTOF(_aDialogCreate14), _cbDialog14, WM_HBKWIN, 0, 0);
				break;
			}
			break;
		}
		break;
	default:
		WM_DefaultProc(pMsg);
		break;
	}
}


/*GUI main task*/
void MainTask(void)
{
	// Check if recommended memory for the sample is available
	if (GUI_ALLOC_GetNumFreeBytes() < RECOMMENDED_MEMORY) {
		GUI_ErrorOut("Not enough memory available."); 
		return;
	}
	
	WM_MOTION_Enable(1);
	hMem0 = GUI_MEMDEV_Create(0, 0, 479, 271);
	GUI_MEMDEV_Select(hMem0);
	GUI_DrawBitmap(pBmp[1], 0, 0);
	GUI_MEMDEV_Select(0);

	//Create main screen
	hWin = GUI_CreateDialogBox(_aDialogCreate1, GUI_COUNTOF(_aDialogCreate1), _cbDialog1, WM_HBKWIN, 0, 0);

	while(1)
	{
		GUI_Delay(20);
	}
}

