/**********************************************************************
*                 SEGGER Software GmbH                               *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2019  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product. This file may
only be used in accordance with the following terms:

The  software has  been licensed by SEGGER Software GmbH to Realtek 
Semiconductor Corp. at the address: Realtek Semiconductor Corp., 
Hsinchu Science Park, Innovation Rd. II 2, 300 Hsinchu city, Taiwan for 
the purposes  of  creating  libraries  for its Cortex-M series of 
Microcontroller Units designed, branded, marketed and manufactured by 
Realtek Semiconductor Corp. under the terms and conditions of an End 
User License Agreement supplied with the libraries.

Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Software GmbH
Licensed to:              Realtek Semiconductor Corp., Hsinchu Science Park, Innovation Rd. II 2, 300 Hsinchu city, Taiwan
Licensed SEGGER software: emWin
License number:           GUI-00784
License model:            emWin Buyout Agreement, signed May 15th, 2019
Licensed platform:        Cortex-M series of Microcontroller Units designed, branded, marketed and manufactured by LICENSEE
----------------------------------------------------------------------
File        : ALPHA_DrawBitmapHWAlpha.c
Purpose     : Shows how to use GUI_DrawBitmapHWAlpha() and custom
              color conversion.
Requirements: WindowManager - ( )
              MemoryDevices - ( )
              AntiAliasing  - ( )
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
----------------------------------------------------------------------
*/

#include <stdlib.h>
#include "GUI.h"

//
// Recommended memory to run the sample with adequate performance
//
#define RECOMMENDED_MEMORY (1024L * 5)

/*********************************************************************
*
*       Static Data
*
**********************************************************************
*/
static GUI_CONST_STORAGE unsigned long _acJoerg[] = {
#if (GUI_USE_ARGB == 1)
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 
        0x01FFFFFF, 0x01FFFFFF, 0x03AAAAAA, 0x03AAAA55, 0x03AAAAAA, 0x03AAAA55, 0x03AAAAAA, 0x03AAAA55, 0x03AAAA55, 0x03AAAA55, 0x03AAAA55, 0x03AA5555, 0x03AAAA55, 0x03AAAAAA, 0x03AAAAAA, 0x03AAAAAA, 0x02FFFF7F, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 
        0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x03AAAAAA, 0x03AAAAAA, 0x03AAAAAA, 0x03AAAAAA, 0x03AAAAAA, 
        0x03AAAAAA, 0x05999999, 0x05999999, 0x05999999, 0x05999966, 0x05999999, 0x05999999, 0x067F7F7F, 0x067F7F7F, 0x05999966, 0x067F7F7F, 0x067F7F7F, 0x05999999, 0x05999999, 0x05999966, 0x05999966, 0x05999966, 0x05999966, 0x03AAAAAA, 0x03AAAAAA, 
        0x03AAAAAA, 0x03AAAAAA, 0x03AAAAAA, 0x027F7F7F, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x027F7F7F, 0x03AAAAAA, 0x03AAAAAA, 0x03AAAAAA, 0x05999999, 0x05999999, 0x05999999, 0x05999999, 0x067F7F7F, 0x0791916D, 
        0x0791916D, 0x0791916D, 0x07919191, 0x07919191, 0x087F5F5F, 0x087F7F5F, 0x087F7F5F, 0x087F7F7F, 0x087F7F7F, 0x085F5F5F, 0x087F7F5F, 0x087F7F5F, 0x076D6D6D, 0x087F7F5F, 0x087F5F5F, 0x076D6D6D, 0x076D6D6D, 0x076D6D6D, 0x067F7F7F, 0x06AAAA7F, 
        0x05999999, 0x05999999, 0x05999999, 0x05999999, 0x03AAAAAA, 0x03AAAAAA, 0x03AAAAAA, 0x03AAAAAA, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x01FFFFFF, 0x01FFFFFF, 0x03AAAAAA, 0x03AAAAAA, 0x03AAAAAA, 0x05999966, 0x05999966, 0x067F7F7F, 0x067F7F7F, 0x07916D6D, 0x0791916D, 0x07919191, 0x089F9F7F, 0x087F7F7F, 0x09717171, 
        0x09717154, 0x0A7F6666, 0x0A7F6666, 0x0A7F6666, 0x0A4C4C33, 0x0B5C5C45, 0x0B735C5C, 0x0A997F7F, 0x0B735C5C, 0x0A4C4C33, 0x0B5C4545, 0x0B5C5C45, 0x0B5C5C45, 0x0B5C4545, 0x0A664C4C, 0x0A4C4C33, 0x0A664C4C, 0x0A664C4C, 0x09717154, 0x09717154, 
        0x087F7F7F, 0x087F7F7F, 0x07919191, 0x0791916D, 0x0791916D, 0x05999999, 0x05999999, 0x05999966, 0x047F7F7F, 0x03AAAAAA, 0x03AAAAAA, 0x027F7F7F, 0x01FFFFFF, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x01FFFFFF, 0x01FFFFFF, 0x03AAAAAA, 0x03AAAAAA, 0x03AAAAAA, 0x05999966, 0x05999999, 0x06AA7F7F, 0x0791916D, 0x087F5F5F, 0x085F5F5F, 0x09545438, 0x0A664C4C, 0x0A66664C, 0x0A66664C, 0x0B735C5C, 0x0C6A5555, 0x0B5C5C45, 
        0x0C553F3F, 0x0D4E4E3A, 0x0C6A5555, 0x0D624E3A, 0x0D4E3A27, 0x0E483636, 0x0E5B4836, 0x0E6D5B5B, 0x0E5B4836, 0x0D3A3A27, 0x0E483624, 0x0E483636, 0x0D4E4E3A, 0x0E483636, 0x0D4E3A3A, 0x0D4E3A27, 0x0C553F3F, 0x0C553F3F, 0x0C55553F, 0x0C55553F, 
        0x0B735C45, 0x0B73735C, 0x0A7F7F66, 0x0A7F7F66, 0x09717171, 0x09717171, 0x087F7F7F, 0x089F7F7F, 0x0791916D, 0x05999999, 0x05999999, 0x05999966, 0x03AAAAAA, 0x03AAAAAA, 0x027F7F7F, 0x01FFFFFF, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 
        0x01FFFFFF, 0x027F7F7F, 0x03AAAAAA, 0x03AAAAAA, 0x05999966, 0x06AA7F7F, 0x0791916D, 0x087F7F7F, 0x087F7F7F, 0x098D8D71, 0x09717171, 0x0B5C5C45, 0x0B5C4545, 0x0B452E2E, 0x0C553F2A, 0x0C553F3F, 0x0D4E3A3A, 0x0E5B4836, 0x0E5B4836, 0x0F554433, 
        0x0F443333, 0x0F443322, 0x104F3F2F, 0x103F2F2F, 0x103F2F1F, 0x103F2F1F, 0x114B3C2D, 0x115A4B3C, 0x115A4B3C, 0x113C2D1E, 0x113C3C2D, 0x114B3C2D, 0x104F3F2F, 0x103F3F2F, 0x104F3F2F, 0x104F3F2F, 0x0F444433, 0x0F444433, 0x0F554433, 0x0F554433, 
        0x0E5B5B48, 0x0E6D5B5B, 0x0D62624E, 0x0C6A6A55, 0x0C6A6A55, 0x0B73735C, 0x0B8B7373, 0x0A997F7F, 0x098D8D71, 0x098D8D8D, 0x089F9F7F, 0x07919191, 0x05999999, 0x05999999, 0x05999999, 0x03AAAAAA, 0x03AAAAAA, 0x01FFFFFF, 0x01FFFFFF, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x01FFFFFF, 0x03AAAAAA, 
        0x03AAAAAA, 0x05999966, 0x05999999, 0x0791916D, 0x0791916D, 0x087F7F7F, 0x09717154, 0x0A7F7F66, 0x0B73735C, 0x0B73735C, 0x0D62624E, 0x0D4E4E3A, 0x0E483636, 0x0E483636, 0x0F443322, 0x103F2F2F, 0x114B2D2D, 0x114B2D2D, 0x1246382A, 0x1246382A, 
        0x1238382A, 0x13353528, 0x13353528, 0x143F3326, 0x143F2626, 0x143F3326, 0x143F3326, 0x144C3333, 0x144C3F33, 0x143F3326, 0x143F3326, 0x143F3326, 0x143F3326, 0x143F3326, 0x13433528, 0x13433528, 0x13433528, 0x1246382A, 0x1246382A, 0x114B3C2D, 
        0x114B4B3C, 0x115A4B4B, 0x104F4F3F, 0x0F554433, 0x0F555544, 0x0E6D6D5B, 0x0E7F6D5B, 0x0D897562, 0x0C7F7F6A, 0x0B8B8B73, 0x0B8B8B73, 0x098D8D71, 0x098D8D71, 0x089F7F7F, 0x07919191, 0x05999999, 0x05999999, 0x047F7F7F, 0x03AAAAAA, 0x027F7F7F, 
        0x01FFFFFF, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x01FFFFFF, 0x03AAAAAA, 0x03AAAAAA, 0x05999999, 
        0x06AA7F7F, 0x0791916D, 0x089F7F7F, 0x098D8D71, 0x0A7F7F66, 0x0B5C5C45, 0x0B5C5C45, 0x0C55553F, 0x0E5B4848, 0x0E5B4848, 0x0F554444, 0x104F3F2F, 0x114B3C2D, 0x114B3C2D, 0x13432828, 0x13433528, 0x13432828, 0x143F3326, 0x153C3024, 0x153C3024, 
        0x16392E22, 0x16392E22, 0x16392E22, 0x17372C21, 0x17372C21, 0x17372C21, 0x17372C21, 0x18352A1F, 0x183F352A, 0x18352A1F, 0x1835351F, 0x183F351F, 0x17422C21, 0x1742372C, 0x17422C21, 0x17422C21, 0x16452E22, 0x16452E22, 0x15483024, 0x15483030, 
        0x15483030, 0x144C3F33, 0x13433535, 0x1246382A, 0x12544638, 0x11695A4B, 0x106F5F4F, 0x107F6F5F, 0x0F666655, 0x0E6D5B48, 0x0D62624E, 0x0C6A6A55, 0x0B8B7373, 0x0A99997F, 0x0A997F7F, 0x098D8D8D, 0x07919191, 0x07919191, 0x05999999, 0x05999999, 
        0x03AAAAAA, 0x03AAAAAA, 0x01FFFFFF, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x027F7F7F, 0x03AAAAAA, 0x047F7F7F, 0x05999999, 0x067F7F7F, 0x07919191, 
        0x087F7F7F, 0x09717154, 0x0B8B7373, 0x0C7F7F7F, 0x0C7F7F6A, 0x0E5B5B48, 0x0F665544, 0x0F554433, 0x114B3C2D, 0x114B3C2D, 0x13503535, 0x13433528, 0x143F3326, 0x153C3024, 0x153C3024, 0x17422C21, 0x17372C21, 0x18352A1F, 0x183F2A1F, 0x193D281E, 
        0x1933281E, 0x1933281E, 0x1A3A2727, 0x1A3A2727, 0x1B382525, 0x1B2F2525, 0x1B2F251C, 0x1B2F251C, 0x1B382F1C, 0x1B2F2F1C, 0x1B382F25, 0x1B382F25, 0x1B38251C, 0x1B422F25, 0x1A3A271D, 0x1A3A271D, 0x1A3A3127, 0x193D3328, 0x193D3328, 0x193D3328, 
        0x183F2A2A, 0x1742372C, 0x1742372C, 0x1645392E, 0x15483C30, 0x14594C3F, 0x14594C3F, 0x135D5043, 0x1246382A, 0x115A4B3C, 0x104F3F2F, 0x0E5B4836, 0x0E6D6D5B, 0x0D757575, 0x0C7F7F6A, 0x0B8B8B73, 0x0A997F7F, 0x098D8D71, 0x089F7F7F, 0x07919191, 
        0x05999999, 0x05999999, 0x03AAAAAA, 0x03AAAAAA, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x01FFFFFF, 0x03AAAAAA, 0x047F7F7F, 0x05999999, 0x067F7F7F, 0x087F7F7F, 0x098D8D71, 0x0A7F7F7F, 
        0x0B8B735C, 0x0C55553F, 0x0D624E3A, 0x0E7F6D5B, 0x107F7F6F, 0x106F5F4F, 0x115A4B3C, 0x12544638, 0x144C3F33, 0x15483030, 0x1645392E, 0x17422C2C, 0x183F2A2A, 0x183F2A1F, 0x193D2828, 0x1A3A3127, 0x1B38251C, 0x1B38251C, 0x1C362D24, 0x1C362D24, 
        0x1D34231A, 0x1D34231A, 0x1E332A22, 0x1E3B2A22, 0x1E332A22, 0x1F312020, 0x1F312020, 0x1F292018, 0x1F292018, 0x1F292918, 0x1F312920, 0x1F312918, 0x1F312920, 0x1E332A22, 0x1E3B2222, 0x1E3B2222, 0x1E332222, 0x1D342B23, 0x1D342B23, 0x1C362D24, 
        0x1C3F241B, 0x1B38251C, 0x1A3A3127, 0x193D3328, 0x183F352A, 0x184A3F35, 0x1742372C, 0x1651392E, 0x15483024, 0x144C3326, 0x13503528, 0x12544638, 0x115A5A4B, 0x104F4F3F, 0x0F555544, 0x0E7F7F6D, 0x0D897575, 0x0B8B8B73, 0x0B8B8B73, 0x098D8D8D, 
        0x089F9F7F, 0x07919191, 0x05999999, 0x05999999, 0x03AAAAAA, 0x027F7F7F, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x03AAAAAA, 0x03AAAAAA, 0x05999999, 0x06AA7F7F, 0x07919191, 0x098D8D71, 0x0A7F7F66, 0x0B73735C, 0x0C6A6A55, 
        0x0D756262, 0x0F666655, 0x104F3F2F, 0x1246382A, 0x135D5043, 0x14594C3F, 0x15544830, 0x16514539, 0x174D4237, 0x183F3535, 0x193D3328, 0x1A3A3127, 0x1B382F25, 0x1C3F2D24, 0x1D3D2B23, 0x1E3B2A22, 0x1E3B2A22, 0x1F312018, 0x202F2717, 0x2037271F, 
        0x212E1E17, 0x212E1E17, 0x2234251E, 0x22342525, 0x22342525, 0x222D1E1E, 0x232B1D1D, 0x232B1D15, 0x23241D15, 0x23242415, 0x232B2B1D, 0x23322B1D, 0x2332241D, 0x2234251E, 0x2234251E, 0x2234251E, 0x212E2617, 0x212E261E, 0x202F271F, 0x2037271F, 
        0x1F392018, 0x1F392018, 0x1E3B2A22, 0x1D3D2B23, 0x1C362D24, 0x1B382F1C, 0x1A3A3127, 0x1A443127, 0x183F2A1F, 0x17422C21, 0x16452E22, 0x1645392E, 0x15483C30, 0x13433528, 0x114B3C2D, 0x115A5A4B, 0x0F665555, 0x0E7F6D6D, 0x0D897575, 0x0C7F7F7F, 
        0x0B8B8B73, 0x098D8D71, 0x089F7F7F, 0x07919191, 0x05999999, 0x047F7F7F, 0x03AAAAAA, 0x027F7F7F, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x027F7F7F, 0x03AAAAAA, 0x05999999, 0x067F7F7F, 0x07919191, 0x098D8D71, 0x0A997F7F, 0x0B8B8B73, 0x0C7F6A55, 0x0E5B4836, 0x0F554433, 
        0x104F3F2F, 0x12544638, 0x13504335, 0x15483C24, 0x16452E22, 0x1742372C, 0x184A3F2A, 0x19473D33, 0x1A443A31, 0x1B42382F, 0x1D3D342B, 0x1E3B2A22, 0x1F392920, 0x1F392920, 0x2037271F, 0x2136261E, 0x2234251E, 0x2234251E, 0x2332241D, 0x2431231C, 
        0x242A1C15, 0x25291B14, 0x2530221B, 0x262E2121, 0x262E211A, 0x262E1A1A, 0x27271A1A, 0x27271A13, 0x27271A13, 0x2727271A, 0x272D271A, 0x272D271A, 0x272D201A, 0x262E211A, 0x262E211A, 0x262E211A, 0x25302214, 0x2529221B, 0x24312A1C, 0x24382A1C, 
        0x2332241D, 0x2234251E, 0x213D2E1E, 0x213D2E1E, 0x2037271F, 0x1F312918, 0x1E332A22, 0x1D3D2B23, 0x1C36241B, 0x1B38251C, 0x193D281E, 0x183F351F, 0x17372C21, 0x16392E22, 0x15483C30, 0x143F3F33, 0x12544638, 0x115A5A4B, 0x106F5F5F, 0x0E6D6D5B, 
        0x0D757575, 0x0C947F7F, 0x0B8B8B73, 0x098D8D8D, 0x07919191, 0x07919191, 0x05999999, 0x047F7F7F, 0x03AAAAAA, 0x027F7F7F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x01FFFFFF, 0x03AAAAAA, 0x047F7F7F, 0x05999999, 0x07919191, 0x089F9F7F, 0x0A997F7F, 0x0B8B8B8B, 0x0D897562, 0x0E7F6D5B, 0x0F776655, 0x115A4B3C, 0x12544638, 
        0x144C3326, 0x153C3024, 0x16453922, 0x183F352A, 0x193D3328, 0x1A3A311D, 0x1C3F2D24, 0x1D46342B, 0x1E44332A, 0x1F413129, 0x203F2F27, 0x213D2E26, 0x2234251E, 0x2332241D, 0x2431231C, 0x2530291B, 0x262E211A, 0x262E211A, 0x27342720, 0x2832261F, 
        0x292B1F18, 0x292B1812, 0x2A2A1E18, 0x2A302418, 0x2A301E18, 0x2B291D17, 0x2B291711, 0x2B231711, 0x2B231D17, 0x2B292317, 0x2B292317, 0x2B292317, 0x2B2F1D17, 0x2A302418, 0x2A302418, 0x2A2A1E18, 0x29251F12, 0x292B1F18, 0x2832261F, 0x28322619, 
        0x2734271A, 0x2635281A, 0x2537291B, 0x25372922, 0x24312A1C, 0x222D2516, 0x22342D1E, 0x21362E1E, 0x20371F17, 0x1F392018, 0x1D34231A, 0x1C362D1B, 0x1B382F1C, 0x1A3A3127, 0x183F352A, 0x1742372C, 0x16513939, 0x14594C3F, 0x135D5050, 0x12545446, 
        0x106F6F5F, 0x0F887777, 0x0D898975, 0x0C7F7F6A, 0x0A997F7F, 0x098D8D8D, 0x089F7F7F, 0x067F7F7F, 0x05999999, 0x047F7F7F, 0x027F7F7F, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x027F7F7F, 0x047F7F7F, 0x05999999, 0x067F7F7F, 0x089F7F7F, 0x098D8D8D, 0x0B8B8B8B, 0x0C94947F, 0x0E917F7F, 0x0F777766, 0x106F5F4F, 0x12635446, 0x14594C33, 0x15543C30, 
        0x1645392E, 0x183F352A, 0x1A443127, 0x1B382F25, 0x1C3F2D24, 0x1E3B3322, 0x1F392920, 0x203F2F27, 0x223C342D, 0x2341322B, 0x243F312A, 0x25372922, 0x2635281A, 0x272D201A, 0x28322619, 0x29312518, 0x2A302418, 0x2B2F2317, 0x2B2F2317, 0x2C34221C, 
        0x2D2D1C16, 0x2D2D1C10, 0x2E261B10, 0x2E2C2116, 0x2E2C2116, 0x2F2B2015, 0x2F251B10, 0x2F251B15, 0x2F251B15, 0x2F25201B, 0x2F25201B, 0x2F2B201B, 0x2F301B15, 0x2F30201B, 0x2E2C211B, 0x2E262116, 0x2E211B10, 0x2D2D2116, 0x2D322721, 0x2C2E2217, 
        0x2B2F2317, 0x2A302418, 0x2A302A18, 0x29312B1F, 0x28322619, 0x262E281A, 0x2530291B, 0x2530291B, 0x2332241D, 0x2234251E, 0x21362617, 0x20372717, 0x1F312918, 0x1D342B23, 0x1B382F25, 0x1B422F2F, 0x19473D33, 0x174D4237, 0x16514539, 0x15614848, 
        0x135D5D50, 0x12717163, 0x106F5F4F, 0x0F776666, 0x0D898975, 0x0C947F7F, 0x0A997F7F, 0x098D8D71, 0x07919191, 0x067F7F7F, 0x047F7F7F, 0x03AAAA55, 0x027F7F7F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x03AAAAAA, 0x047F7F7F, 0x05999999, 0x07919191, 0x098D8D71, 0x0A99997F, 0x0C94947F, 0x0D9C8989, 0x0F887766, 0x11786969, 0x12716354, 0x1466594C, 0x1554483C, 0x1651452E, 0x184A352A, 
        0x1A443127, 0x1B42382F, 0x1D46342B, 0x1F393120, 0x20372F1F, 0x223C2D1E, 0x233A2B1D, 0x24382A23, 0x25372922, 0x263C2E28, 0x28392C26, 0x2931251F, 0x2A302418, 0x2B291D17, 0x2C2E2217, 0x2D32211C, 0x2E372621, 0x2F36251B, 0x302F1F1A, 0x312E1F1A, 
        0x31291A14, 0x31291A14, 0x3228190F, 0x332D1E14, 0x332D1E14, 0x332D1E14, 0x33281E14, 0x34221813, 0x34221D18, 0x34271D18, 0x34271D18, 0x332D1E19, 0x33321E19, 0x332D1E19, 0x332D1E19, 0x3223190F, 0x32231E14, 0x312E291F, 0x3134291F, 0x302F1F15, 
        0x2F2B2015, 0x2E2C2116, 0x2E2C2616, 0x2D322D1C, 0x2C2E281C, 0x2B2F291D, 0x2A302A1E, 0x29312B18, 0x272D201A, 0x262E211A, 0x2530221B, 0x2332241D, 0x22342D1E, 0x21362E26, 0x1F393129, 0x1E44332A, 0x1C48362D, 0x1B4B382F, 0x19473D33, 0x18544A3F, 
        0x16514539, 0x144C3F33, 0x12544638, 0x11877869, 0x108F8F7F, 0x0E91917F, 0x0C94947F, 0x0B8B8B8B, 0x098D8D8D, 0x089F7F7F, 0x067F7F7F, 0x05999966, 0x047F7F7F, 0x027F7F7F, 0x01FFFF00, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x027F7F7F, 0x03AAAAAA, 0x05999999, 0x06AAAA7F, 0x089F9F7F, 0x098D8D8D, 0x0BA2A28B, 0x0C94947F, 0x0E91917F, 0x108F7F7F, 0x12716354, 0x136B5D50, 0x1561543C, 0x174D4237, 0x184A3F2A, 0x1A443A27, 0x1C3F3624, 
        0x1D3D2B23, 0x1F413129, 0x21453626, 0x2243342D, 0x243F3123, 0x2537291B, 0x27342720, 0x2839261F, 0x2931251F, 0x2B3B2923, 0x2C392822, 0x2D382721, 0x2E31261B, 0x2F2B2015, 0x312E1F1A, 0x32332319, 0x3332281E, 0x3337281E, 0x34312218, 0x352B2118, 
        0x352B1C13, 0x362A1C12, 0x3625170E, 0x37291B12, 0x38281B12, 0x38281B12, 0x38241B12, 0x38241B12, 0x38241B16, 0x38241B16, 0x38241F1B, 0x382D1B16, 0x38321B16, 0x38281F12, 0x37251B12, 0x37201B12, 0x36252117, 0x362F251C, 0x35302118, 0x342C1D13, 
        0x342C1D13, 0x332D2314, 0x32332319, 0x312E291A, 0x302A251A, 0x2F2B2B1B, 0x2E2C2C1B, 0x2C282217, 0x2B292317, 0x2A2A2418, 0x2931251F, 0x27342D20, 0x263C2E21, 0x253E3022, 0x233A2B24, 0x223C2525, 0x203F271F, 0x1E44332A, 0x1D46342B, 0x1B42382F, 
        0x19473D33, 0x18544A3F, 0x167F7F68, 0x148C8C7F, 0x128D7F71, 0x11878778, 0x0F998888, 0x0D898989, 0x0C947F7F, 0x0A997F7F, 0x098D8D71, 0x0791916D, 0x067F7F7F, 0x047F7F7F, 0x03AAAA55, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x01FFFFFF, 0x027F7F7F, 0x04BFBF7F, 0x05999999, 0x07B69191, 0x089F9F9F, 0x0AB29999, 0x0CAA9494, 0x0EA39191, 0x0FAA9999, 0x11969687, 0x13867878, 0x14726659, 0x165C5145, 0x18543F35, 0x1A4E3A31, 0x1B423825, 0x1D3D3423, 0x1F413120, 
        0x21362E26, 0x223C2D25, 0x2341322B, 0x26433528, 0x273A2D20, 0x2937251F, 0x2B352917, 0x2B352317, 0x2D32211C, 0x2F36251B, 0x30352A1F, 0x3139291F, 0x32382823, 0x332D1E19, 0x352B1C18, 0x362F211C, 0x3732251B, 0x3732251B, 0x392C1F1A, 0x392C1F16, 
        0x3A2B1E15, 0x3B261E11, 0x3B221911, 0x3B261915, 0x3C2A1919, 0x3C2A1D15, 0x3D251D10, 0x3D21190C, 0x3D251D10, 0x3D251D14, 0x3D211D14, 0x3D292119, 0x3C2E1915, 0x3C2A1911, 0x3C261D15, 0x3B261E15, 0x3B2B2219, 0x3A2B231A, 0x3A271E1A, 0x39231F16, 
        0x38241F16, 0x37292517, 0x362A251C, 0x352B261C, 0x342C2218, 0x332D2319, 0x322D2314, 0x31291F1A, 0x2F30251B, 0x2E312C21, 0x2C342822, 0x2B352923, 0x29372B25, 0x28392C26, 0x27342020, 0x2537221B, 0x233A241D, 0x223C2D25, 0x2037271F, 0x1E443322, 
        0x1C513F36, 0x1B675E4B, 0x197A665B, 0x176E6358, 0x156D6154, 0x14727266, 0x128D7F71, 0x108F8F7F, 0x0E91917F, 0x0D898975, 0x0B8B8B73, 0x098D8D71, 0x089F7F7F, 0x067F7F7F, 0x05999966, 0x03AAAA55, 0x027F7F7F, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x01FFFFFF, 0x03AAAAAA, 0x04BFBF7F, 0x06AAAAAA, 0x07B6B691, 0x09A9A98D, 0x0BA2A2A2, 0x0CAAAAAA, 0x0EA3A3A3, 0x109F9F8F, 0x129B9B8D, 0x147F7F72, 0x16735C5C, 0x17584D42, 0x19513D33, 0x1B4B382F, 0x1D46342B, 0x1F413120, 0x213D2E1E, 0x23322424, 
        0x2431231C, 0x26352821, 0x28392C26, 0x2A3C3024, 0x2B3B291D, 0x2D38271C, 0x2F36251B, 0x30352515, 0x32331E14, 0x33372319, 0x3435271D, 0x3633211C, 0x37372520, 0x3836241F, 0x39311F1A, 0x3A301E1A, 0x3B2F2219, 0x3C2E2219, 0x3D322119, 0x3E2D2018, 
        0x3F282014, 0x3F281C14, 0x40231B13, 0x40271B17, 0x412B171F, 0x412B1F1B, 0x412B1B13, 0x41231B0B, 0x42221E0F, 0x42221E13, 0x41231F13, 0x412B1F17, 0x412B1713, 0x4127170F, 0x412B1F17, 0x402B1F1B, 0x3F2C201C, 0x3F28201C, 0x3E242018, 0x3E201C18, 
        0x3C222219, 0x3C26221D, 0x3B262219, 0x3928231A, 0x39282316, 0x37292017, 0x362F2517, 0x3530211C, 0x34352722, 0x32382823, 0x31342924, 0x2F362525, 0x2E372626, 0x2C342222, 0x2A301E1E, 0x2931251F, 0x272D271A, 0x2537291B, 0x23322B1D, 0x21453626, 
        0x2057473F, 0x1E665544, 0x1C513F36, 0x1A4E3A31, 0x186A5454, 0x17796E63, 0x15918579, 0x13939386, 0x11969687, 0x0F999988, 0x0D9C8989, 0x0C94947F, 0x0A99997F, 0x089F7F7F, 0x07919191, 0x05999999, 0x047F7F7F, 0x027F7F7F, 0x01FFFFFF, 0x01FFFFFF,
  0x01FFFFFF, 0x03AAAAAA, 0x05999999, 0x06AAAA7F, 0x089F9F9F, 0x09A9A98D, 0x0BA2A28B, 0x0D9C9C89, 0x0FAA9999, 0x11A59696, 0x129B9B8D, 0x15919185, 0x17796E63, 0x19665147, 0x1B4B4238, 0x1D46342B, 0x1E44332A, 0x203F2F1F, 0x22342D1E, 0x2431231C, 0x262E281A, 
        0x282C1F1F, 0x2A301E1E, 0x2C34281C, 0x2D382721, 0x2E37261B, 0x3035251A, 0x33322319, 0x33322314, 0x362F2112, 0x37322517, 0x393A281F, 0x3A301E1A, 0x3B33221E, 0x3C3B2A26, 0x3E352420, 0x3F2C1814, 0x3F2C1C14, 0x412F1F17, 0x412F231B, 0x432D2216, 
        0x43261A13, 0x44251E16, 0x45242116, 0x45281916, 0x452C191D, 0x462F201D, 0x46281D12, 0x4620190A, 0x46241D0E, 0x46241D12, 0x46201D15, 0x462B2019, 0x46281912, 0x4624150E, 0x452C1D16, 0x452C2119, 0x4429211A, 0x4429211A, 0x43261E16, 0x42221B17, 
        0x41271F1B, 0x4027231B, 0x3F28241C, 0x3E292018, 0x3D292119, 0x3C2A2219, 0x3B2F2619, 0x3935281F, 0x37372925, 0x36332521, 0x34312722, 0x33322823, 0x3233231E, 0x2F2B201B, 0x2E2C211B, 0x2C2E221C, 0x2B292317, 0x28322619, 0x2635281A, 0x253E3029, 
        0x23504132, 0x214D3D2E, 0x20472F27, 0x1E553B33, 0x1C76645B, 0x1A89756B, 0x188A7F74, 0x1696968B, 0x1499998C, 0x129B9B8D, 0x109F8F8F, 0x0EA39191, 0x0C949494, 0x0A99997F, 0x09A98D8D, 0x07919191, 0x05999999, 0x047F7F7F, 0x027F7F7F, 0x027F7F7F,
  0x03AAAAAA, 0x05999999, 0x06AAAA7F, 0x089F9F9F, 0x0A999999, 0x0C949494, 0x0EA39191, 0x109F8F8F, 0x128D8D7F, 0x14998C8C, 0x168B7F7F, 0x18746A6A, 0x1A62584E, 0x1B544238, 0x1D4F3D34, 0x1F413129, 0x213D2E26, 0x24382A23, 0x262E281A, 0x282C2619, 0x2A2A1E18, 
        0x2C281717, 0x2E261B16, 0x302A1F15, 0x312E1F1A, 0x3337231E, 0x35342118, 0x372E1B12, 0x38321F12, 0x3A342315, 0x3C2E1D15, 0x3D36251D, 0x3E392920, 0x4033231B, 0x413A2723, 0x4236261E, 0x43291613, 0x442D1E16, 0x462B2015, 0x462F2015, 0x472B2015, 
        0x48261C11, 0x49261F14, 0x49261F14, 0x4A251B18, 0x4A291B1B, 0x4B2C1E17, 0x4B281E11, 0x4B221B0D, 0x4B251E11, 0x4B251E14, 0x4B221E14, 0x4B281B17, 0x4B251714, 0x4A291814, 0x4A2C1E1B, 0x4A2C1E18, 0x49291F14, 0x482A1F18, 0x472B2015, 0x46282019, 
        0x4628201D, 0x45242119, 0x4425211A, 0x422A221B, 0x412B2317, 0x402B2317, 0x3F302818, 0x3E31241C, 0x3C332622, 0x3B332622, 0x3931231F, 0x372E201B, 0x352B211C, 0x342C1D18, 0x32281E19, 0x302A1F1A, 0x2E2C2116, 0x2C2E2217, 0x2A302418, 0x283F3226, 
        0x263C2E21, 0x25372922, 0x23413224, 0x214D3D36, 0x1E66554C, 0x1D726960, 0x1B847A71, 0x18948A7F, 0x17909084, 0x15919185, 0x129B9B8D, 0x11969687, 0x0F999988, 0x0D9C9C89, 0x0BA2A28B, 0x098D8D8D, 0x07919191, 0x06AA7F7F, 0x047F7F7F, 0x047F7F7F,
  0x05999999, 0x07B6B691, 0x09A9A9A9, 0x0A999999, 0x0CAAAAAA, 0x0EA3A3A3, 0x10AF9F9F, 0x12A99B9B, 0x14A59999, 0x1696968B, 0x188A7F74, 0x1B5E544B, 0x1D4F3D34, 0x1F524139, 0x214D3D2E, 0x2341322B, 0x253E3022, 0x272D271A, 0x292B2518, 0x2C222217, 0x2E262116, 
        0x30251A15, 0x32281914, 0x342C1D13, 0x36251C12, 0x37322517, 0x39312316, 0x3B2B1911, 0x3D2D2114, 0x3D322119, 0x402B1B13, 0x4132231B, 0x43403129, 0x4430211A, 0x4636241D, 0x47352319, 0x482E1C15, 0x49291B14, 0x4A291B14, 0x4B2C1B14, 0x4C2B1E17, 
        0x4D2B2117, 0x4D271D13, 0x4E231D13, 0x4F291C16, 0x4F2D1C19, 0x4F291C16, 0x50291C13, 0x50261C0C, 0x50221C13, 0x50221C16, 0x50221C16, 0x50261919, 0x50261916, 0x4F291C19, 0x4F291C19, 0x4E2A2016, 0x4E2D231A, 0x4D2E2117, 0x4C2E2117, 0x4C2E211A, 
        0x4B281E1E, 0x4A2C221B, 0x49291F1B, 0x472B2019, 0x462B2419, 0x452C2416, 0x4430251A, 0x422E221B, 0x4132231F, 0x3F302420, 0x3D2D211D, 0x3C2A1D19, 0x3A271E1A, 0x38281F1B, 0x362A1C17, 0x352B211C, 0x322D1E19, 0x31291F1A, 0x2F2B201B, 0x2C34281C, 
        0x2B35291D, 0x2832261F, 0x263C3528, 0x244D3F31, 0x2261524B, 0x206F5F57, 0x1E7F776E, 0x1C91887F, 0x19998E84, 0x179B9B84, 0x159D9185, 0x13939393, 0x11969687, 0x0F999988, 0x0D9C9C89, 0x0BA2A28B, 0x098D8D8D, 0x089F9F7F, 0x06AAAA7F, 0x06AAAA7F,
  0x07B6B6B6, 0x09A9A9A9, 0x0BA2A2A2, 0x0CAAAAAA, 0x0FAAAAAA, 0x11A5A5A5, 0x13AEA1A1, 0x15A9A9A9, 0x17B1A6A6, 0x19A39999, 0x1B978D84, 0x1D8C837B, 0x207F776F, 0x227F7069, 0x245C4646, 0x2643352E, 0x29373125, 0x2B292317, 0x2D272116, 0x2F252015, 0x31241F14, 
        0x34221813, 0x3625170E, 0x3725170D, 0x3A271A0D, 0x3B332219, 0x3D322519, 0x3F302014, 0x412F1F17, 0x43311E1A, 0x442D1E16, 0x462F1D19, 0x473D2B23, 0x49301F18, 0x4A332218, 0x4C322117, 0x4D312117, 0x4E2D1D16, 0x4F261913, 0x50291913, 0x512B1F15, 
        0x522B1F15, 0x52281B12, 0x53241B12, 0x54271B18, 0x542A1B18, 0x542A1E15, 0x55271B0F, 0x55271E0F, 0x55272115, 0x5527211B, 0x55241E1B, 0x55241E1B, 0x55241B18, 0x54271E18, 0x542A1E1B, 0x532E1E18, 0x532E2118, 0x522E1F15, 0x512F1F15, 0x502F2219, 
        0x4F2D201C, 0x4E2D201D, 0x4D2E211D, 0x4C2B211A, 0x4B2C221B, 0x4A2C2218, 0x472B2315, 0x472E2319, 0x44301E1A, 0x442D1E1A, 0x422A1B1B, 0x402B1B17, 0x3E291C18, 0x3C261D19, 0x3B262219, 0x392C1F1A, 0x372E201B, 0x342C1D18, 0x32281E19, 0x302F1F1A, 
        0x2E2C2116, 0x2C2E2217, 0x2A302A1E, 0x2846392C, 0x2559443E, 0x23655750, 0x2183736C, 0x1F93837B, 0x1D958C83, 0x1A9C9C89, 0x1894948A, 0x16A29696, 0x1499998C, 0x129B9B8D, 0x109F8F8F, 0x0E919191, 0x0C949494, 0x0A999999, 0x089F9F7F, 0x089F9F7F,
  0x09A9A9A9, 0x0BA2A2A2, 0x0DB0B0B0, 0x0FAAAAAA, 0x11B4A5A5, 0x13AEA1A1, 0x15B6A9A9, 0x18A9A99F, 0x1AB0A6A6, 0x1CACA39A, 0x1E999088, 0x21837B6C, 0x235E5748, 0x25524444, 0x28463932, 0x29372B25, 0x2C2E2822, 0x2F25201B, 0x31241F1A, 0x33231E14, 0x35261C13, 
        0x37201712, 0x3A23150D, 0x3B22150C, 0x3E24140C, 0x402F1F17, 0x42322217, 0x43312213, 0x452F2116, 0x472E201C, 0x492D1F1B, 0x4A2C1B18, 0x4C35241E, 0x4D312117, 0x4F302016, 0x502F1F13, 0x52342218, 0x522E1F18, 0x54271B12, 0x54271B12, 0x552A1E15, 
        0x56291D14, 0x57261D14, 0x58251C14, 0x58281C17, 0x592A1C16, 0x5A271C13, 0x59281C11, 0x5A271F10, 0x5A271F13, 0x5A2A211C, 0x5A271F1F, 0x5A241F1F, 0x5A241C19, 0x59251C19, 0x592A1F19, 0x582E1F1A, 0x582E1F14, 0x572B1D11, 0x562F2011, 0x5533211B, 
        0x542D1E1B, 0x532E1E1B, 0x522E1F1B, 0x502C1F19, 0x502C1F16, 0x4E271D13, 0x4D242110, 0x4B2C1E17, 0x4A301B18, 0x472B1915, 0x46281915, 0x44291A16, 0x43261E16, 0x41231F17, 0x3E242018, 0x3D29211D, 0x3B2F1E1E, 0x382D1F1B, 0x362A211C, 0x34271D18, 
        0x31241F14, 0x30251F15, 0x2E2C261B, 0x2B413529, 0x284C3932, 0x265D4943, 0x2471635C, 0x227F7869, 0x208F877F, 0x1D959583, 0x1B979784, 0x1999998E, 0x179B9090, 0x1499998C, 0x129B9B8D, 0x109F9F8F, 0x0EA39191, 0x0C949494, 0x0A999999, 0x0A999999,
  0x0BB9B9B9, 0x0DB0B0B0, 0x0FAAAAAA, 0x11B4B4B4, 0x13AEAEAE, 0x16ADA2AD, 0x18B4A9A9, 0x1AB0A6A6, 0x1CACA3A3, 0x1FACA49C, 0x228E877F, 0x236D5E50, 0x2650433C, 0x29372B2B, 0x2B2F2923, 0x2D2D211C, 0x302F251F, 0x32231E19, 0x34271D18, 0x37251712, 0x39281A16, 
        0x3B221911, 0x3E241810, 0x4027170F, 0x4226170B, 0x432D1E13, 0x45332116, 0x48311F11, 0x4A332218, 0x4B2F1E1B, 0x4D311D1A, 0x4F302019, 0x51322219, 0x52312218, 0x54332418, 0x552D1E0F, 0x562F2014, 0x572E1D17, 0x592D1F16, 0x592A1C14, 0x5B2A1E13, 
        0x5C2C2116, 0x5C292116, 0x5D292015, 0x5D2B2018, 0x5E2E2018, 0x5F2A2015, 0x5F2D2215, 0x5E2B2315, 0x5F282218, 0x5F28221D, 0x5F252020, 0x5F252020, 0x5F251D1D, 0x5E28201D, 0x5E2B201B, 0x5D2B2018, 0x5D2B1E13, 0x5C291B0D, 0x5B2F2110, 0x5A352119, 
        0x582E1A1A, 0x582B1A17, 0x562C1D1A, 0x552D1E18, 0x542A1E15, 0x53241B12, 0x51221C0F, 0x50291C13, 0x4D2E1717, 0x4C2B1714, 0x4A291814, 0x49291B18, 0x47271C19, 0x45241D16, 0x4326221A, 0x40271F1B, 0x3F2C201C, 0x3D2D211D, 0x3A2B1E1A, 0x38281B16, 
        0x36252112, 0x33231E14, 0x3124241A, 0x2F3B3020, 0x2C3F3428, 0x29503E37, 0x285F5246, 0x25756759, 0x237B7465, 0x208F8777, 0x1E999988, 0x1C9A9A91, 0x1999998E, 0x179B9B90, 0x159D9191, 0x129B9B8D, 0x109F9F8F, 0x0EA3A391, 0x0C949494, 0x0C949494,
  0x0DB0B0B0, 0x0FAAAAAA, 0x11B4B4B4, 0x13AEAEAE, 0x16ADADAD, 0x19ADA3A3, 0x1BA9A9A9, 0x1DAFA7A7, 0x2097978F, 0x227F7F78, 0x25605944, 0x273A2D20, 0x2A362A24, 0x2C342822, 0x2F362525, 0x31291F1A, 0x34271D18, 0x36252117, 0x38281B16, 0x3B261511, 0x3D251914, 
        0x3F241814, 0x42221713, 0x44251A12, 0x46241912, 0x482E1F15, 0x4A33251B, 0x4C32241A, 0x4D34241D, 0x50321F1C, 0x52311F1B, 0x5436241E, 0x5536211B, 0x5734231A, 0x5836251A, 0x5A321F13, 0x5B2C1E13, 0x5D292018, 0x5D2B261B, 0x5F2A2218, 0x60271F15, 
        0x6129221A, 0x612C241A, 0x62292117, 0x632E211C, 0x6333211C, 0x6430211C, 0x6333231C, 0x6433231C, 0x6430231C, 0x642D231C, 0x642B211E, 0x642D1E1E, 0x64301C1C, 0x63301C1C, 0x63301C19, 0x622E1C14, 0x612C1A12, 0x612C1C0F, 0x602F2215, 0x5F35221A, 
        0x5E2E1B1B, 0x5D2E1B1B, 0x5B2F1E1C, 0x5B2A1C19, 0x59281C14, 0x57231A11, 0x56201A0E, 0x54271B15, 0x532E1B1B, 0x512B1919, 0x4F291916, 0x4D2B1D17, 0x4B281B17, 0x49261B14, 0x47272015, 0x442D1E1A, 0x43311E1E, 0x412F1F1F, 0x3E2D1C18, 0x3C2A1D19, 
        0x3A271A15, 0x37251B17, 0x35262118, 0x3233231E, 0x303A251F, 0x2D493832, 0x2B5E4D41, 0x29695D50, 0x266B6457, 0x247F786A, 0x21929283, 0x1F93938B, 0x1C9A9A91, 0x1A9C9389, 0x179B9B90, 0x159D9D91, 0x129B9B8D, 0x109F9F8F, 0x0E919191, 0x0E919191,
  0x0FBBBBBB, 0x11B4B4B4, 0x14B2B2B2, 0x16B9B9B9, 0x19ADADAD, 0x1BA9A9B3, 0x1EAAAAAA, 0x209F9797, 0x23655E5E, 0x25373022, 0x28322619, 0x2A362A1E, 0x2D382721, 0x303A2525, 0x32332323, 0x34271D18, 0x37251B12, 0x39231A11, 0x3C261911, 0x3F28180C, 0x4127170F, 
        0x43261613, 0x46241512, 0x48261C15, 0x4A291B18, 0x4D2E241A, 0x4F33291C, 0x5032291C, 0x533A2A21, 0x55392421, 0x56382320, 0x58392522, 0x5A38211F, 0x5B38211C, 0x5D36231B, 0x5F352018, 0x602D1F17, 0x612C271C, 0x6330291E, 0x632E261C, 0x652D251B, 
        0x662F251E, 0x662F251B, 0x6731251D, 0x68382722, 0x683A2424, 0x693A2424, 0x683A2724, 0x69372621, 0x69372621, 0x6935261F, 0x6932261D, 0x6935211D, 0x693A1D1F, 0x69371D1A, 0x68351A16, 0x68331D16, 0x67311B13, 0x66321E14, 0x65342316, 0x64332119, 
        0x63301919, 0x62341C1C, 0x60321F1F, 0x5F281A18, 0x5E251B18, 0x5C241816, 0x5B211916, 0x59281C19, 0x572E1D1A, 0x562C1A1A, 0x532A1B18, 0x522E1B18, 0x502C1F19, 0x4D2B1D13, 0x4B2C1E14, 0x492D1B18, 0x462F1D1D, 0x452F1D1D, 0x422A1B1B, 0x402B1B1B, 
        0x3E291814, 0x3B261915, 0x392C1A1A, 0x362A1C1C, 0x33372323, 0x313E2E2E, 0x2E4D423C, 0x2C5C5145, 0x29695D50, 0x27756F5B, 0x24867F71, 0x219A9283, 0x1FA49C93, 0x1CA39A91, 0x1A9C9C93, 0x179B9B90, 0x159D9D91, 0x13A1A193, 0x109F9F8F, 0x109F9F8F,
  0x12B8B8B8, 0x14B2BFB2, 0x16B9B9B9, 0x19B7B7B7, 0x1BB3B3B3, 0x1EB2B2B2, 0x20AFAFAF, 0x23989191, 0x26645757, 0x29443731, 0x2B413529, 0x2D3E2D21, 0x30351F1A, 0x33321E1E, 0x352B211C, 0x38241F1B, 0x3B222215, 0x3D211D10, 0x3F20180C, 0x4322160B, 0x4524160E, 
        0x48261511, 0x4A291814, 0x4C2E1E17, 0x4F33231C, 0x5138281F, 0x53372A1B, 0x55392D1E, 0x57402E26, 0x593E2522, 0x5B3A2121, 0x5D3C2320, 0x5E3B231D, 0x603C251D, 0x623B211A, 0x64381E14, 0x65372019, 0x663C2520, 0x673B2520, 0x693A241D, 0x693C261F, 
        0x6A39241C, 0x6C382119, 0x6C3D2521, 0x6D412C27, 0x6E3C2929, 0x6E3C2927, 0x6E3C2B27, 0x6E392B24, 0x6F392D24, 0x6F392B22, 0x6E372B20, 0x6E392922, 0x6E392422, 0x6E321E1B, 0x6D331E17, 0x6D332017, 0x6C331E15, 0x6B362117, 0x6A372418, 0x69351F18, 
        0x67331D1D, 0x67332020, 0x662F1E1E, 0x642B1C19, 0x63291C17, 0x61271C17, 0x60271F1A, 0x5E2B201B, 0x5C2F1E1B, 0x5A301F1C, 0x582E1F1C, 0x5632231D, 0x5433211B, 0x522E1F18, 0x4F2D1C13, 0x4E2D1A13, 0x4B2F1B1B, 0x49301F1B, 0x462B1919, 0x44291A16, 
        0x41271717, 0x3F241814, 0x3C261915, 0x3A2B1E1A, 0x37322525, 0x35392626, 0x3242332D, 0x2F4B4130, 0x2C5C5145, 0x2A615B48, 0x276F685B, 0x25898275, 0x229D968E, 0x1F9C938B, 0x1D9E9E8C, 0x1A9C9C93, 0x189F948A, 0x159D9D91, 0x13A1A193, 0x13A1A193,
  0x14B2BFBF, 0x16B9B9B9, 0x19B7B7B7, 0x1CB6B6B6, 0x1EB2BBBB, 0x21B1A9B1, 0x24A9A9A9, 0x268C7F7F, 0x29564444, 0x2C45342E, 0x2F413025, 0x313E291F, 0x34312218, 0x3729201B, 0x39231F16, 0x3C221D15, 0x3F202018, 0x41231F13, 0x43221A0F, 0x4723190E, 0x49291811, 
        0x4B2C1711, 0x4E301D16, 0x5138251C, 0x53402A21, 0x55453024, 0x583F2E1F, 0x593E2A1C, 0x5C452C24, 0x5E462523, 0x60422722, 0x62462921, 0x63452921, 0x65462A23, 0x67452920, 0x6842271D, 0x6A43281F, 0x6B472A23, 0x6D452720, 0x6E452720, 0x6F462B24, 
        0x6F462B24, 0x71432821, 0x71452A24, 0x7247312C, 0x72402E2C, 0x73402E29, 0x733D2E29, 0x733D2E27, 0x743F3229, 0x743D3227, 0x743B3023, 0x73392C23, 0x73392925, 0x73372723, 0x7235251F, 0x7136241D, 0x713A261D, 0x703D281F, 0x6F3B261B, 0x6E39221B, 
        0x6D3C2222, 0x6C3D2523, 0x6B392323, 0x69372421, 0x67312220, 0x662F231E, 0x642D211C, 0x6333231E, 0x6134221F, 0x5F352220, 0x5D392320, 0x5B382721, 0x5939251C, 0x5635231A, 0x54331E15, 0x52311B18, 0x50321C1C, 0x4D311D1A, 0x4A2C1B18, 0x482A1815, 
        0x45241612, 0x4322160F, 0x40231713, 0x3E291818, 0x3B2B1E1E, 0x382D1F1F, 0x3534261C, 0x32382D23, 0x303A2F25, 0x2D493E2D, 0x2B6A6A58, 0x278F897C, 0x259E9790, 0x229D968E, 0x2097978F, 0x1D9E9E8C, 0x1A9C9C89, 0x189F948A, 0x159D9D91, 0x159D9D91,
  0x16B9C5C5, 0x19B7B7B7, 0x1BB3BCBC, 0x1EBBBBBB, 0x21B9B1B9, 0x24B8B1B1, 0x27A9A3A3, 0x2A796767, 0x2C4B3939, 0x2F412B25, 0x323D231E, 0x35342118, 0x382D1F16, 0x3A271E1A, 0x3D211914, 0x401B1B13, 0x431A1A0F, 0x451D190E, 0x48261C11, 0x4B281B0D, 0x4D2E1A10, 
        0x50321C13, 0x523A2518, 0x55452D21, 0x57493126, 0x594A3025, 0x5C4A3124, 0x5E492E20, 0x604A2A22, 0x624B2C27, 0x644C2B26, 0x66502F28, 0x68503129, 0x694F3026, 0x6C4D2C23, 0x6D4F2E22, 0x6E503229, 0x704D312B, 0x724B2E2A, 0x734B2E27, 0x744C322B, 
        0x744E362D, 0x764B362D, 0x774A352C, 0x774A3733, 0x78483532, 0x7848352E, 0x7845352E, 0x7943342E, 0x7945382E, 0x7943362C, 0x78413528, 0x793F322A, 0x783F302C, 0x783F322C, 0x783D2E28, 0x773B2820, 0x763E2B22, 0x75412B22, 0x74412920, 0x73422721, 
        0x72492C2C, 0x714C312F, 0x70462F2D, 0x6E402E27, 0x6D3C2925, 0x6B362821, 0x6932261F, 0x67362522, 0x65392520, 0x633B2621, 0x613E2724, 0x5F3D2822, 0x5D3C291E, 0x5B382419, 0x58361F17, 0x5638231A, 0x5436211B, 0x51321C19, 0x4F2D1916, 0x4C281A14, 
        0x49261811, 0x4620150E, 0x4421160F, 0x41231B17, 0x3E29201C, 0x3C2A221D, 0x3931231F, 0x362F2A21, 0x33322D1E, 0x303A2F1F, 0x2E3C3726, 0x2B585341, 0x288C857F, 0x259E9790, 0x229D968E, 0x209F978F, 0x1D9E9E8C, 0x1A9C9C93, 0x189F9F8A, 0x189F9F8A,
  0x19B7C1C1, 0x1CB6B6B6, 0x1EBBBBBB, 0x21B9B9C1, 0x24BFB8B8, 0x26B5AEB5, 0x299B9595, 0x2C5C5151, 0x2F3B2B2B, 0x323D2D23, 0x3539261C, 0x38361F12, 0x3B2F1E15, 0x3E241C18, 0x411F1B13, 0x431E1A13, 0x4620190E, 0x4922180D, 0x4C24170D, 0x4E2A1610, 0x51351C12, 
        0x543C241B, 0x57492E23, 0x59503328, 0x5C533429, 0x5E543328, 0x61563729, 0x63543323, 0x65502D23, 0x67562E2C, 0x6959302B, 0x6B5A342D, 0x6D5F3A30, 0x6E5E3930, 0x705A3428, 0x72593528, 0x745B3B32, 0x75583C34, 0x76543A31, 0x78523930, 0x79513A32, 
        0x7A533E36, 0x7B504035, 0x7B504033, 0x7C56413B, 0x7D533D39, 0x7D4F3935, 0x7E4E3A34, 0x7E4C3A32, 0x7E4C3C32, 0x7E4A3A2E, 0x7E4A3A2C, 0x7E4A3A30, 0x7E483636, 0x7D4B3935, 0x7D493530, 0x7C432F26, 0x7B48332B, 0x7B4A312B, 0x79493027, 0x78523730, 
        0x775C3E3B, 0x765C403E, 0x74533836, 0x7348322E, 0x71432F28, 0x703D2B24, 0x6D3A2922, 0x6C3F2A25, 0x6A3E2824, 0x683F2924, 0x66412A25, 0x643F2B23, 0x623E291F, 0x5F3D251A, 0x5D3C261B, 0x5B402721, 0x583C221F, 0x55361E1B, 0x532E1B15, 0x4F261610, 
        0x4D21170D, 0x4A1E180D, 0x481F180E, 0x44211A12, 0x42261E1B, 0x3F28201C, 0x3C2A221D, 0x3A2B231A, 0x372E2917, 0x343A311D, 0x31433929, 0x2E584D42, 0x2B827C70, 0x289F988C, 0x259E9789, 0x229D9D8E, 0x2097978F, 0x1D9E9E8C, 0x1A9C9C93, 0x1A9C9C93,
  0x1BBCC6C6, 0x1EBBC3C3, 0x21B9B9C1, 0x24BFBFBF, 0x27BDBDBD, 0x2AB0B0B0, 0x2D7C7676, 0x304A453F, 0x33322828, 0x3633251C, 0x382D1F12, 0x3B2F1E11, 0x3E2D1C14, 0x41271B17, 0x44211612, 0x47231911, 0x4A221811, 0x4D241710, 0x5029160C, 0x53371B15, 0x5641261D, 
        0x584E3125, 0x5B54382F, 0x5D57392E, 0x6057372A, 0x6359352B, 0x655F392A, 0x685F3829, 0x6A60372D, 0x6C653B36, 0x6D663C37, 0x6F694039, 0x726F473E, 0x746D483D, 0x756C4538, 0x776B4437, 0x786C453D, 0x7A66423C, 0x7B613E37, 0x7D5D3F37, 0x7E5E4038, 
        0x7F5E443C, 0x805D4539, 0x815E4A3F, 0x81644C44, 0x82604240, 0x82583C38, 0x83573C36, 0x83574036, 0x83553E34, 0x83533E30, 0x83574136, 0x8359403C, 0x83573C3E, 0x82583E3E, 0x82583E3A, 0x81523933, 0x81563F37, 0x80573D35, 0x7E583E36, 0x7E60463E, 
        0x7C644543, 0x7B634642, 0x7A573C36, 0x774F352F, 0x76452D26, 0x753C2922, 0x73402C25, 0x71432D28, 0x6F442B26, 0x6C442A25, 0x6B422A23, 0x69412921, 0x66432A1E, 0x6442281E, 0x62462C21, 0x5F483028, 0x5C452926, 0x5A3B211C, 0x572E1D14, 0x5427180F, 
        0x511F190C, 0x4E1D1609, 0x4C1E1A0D, 0x491F1B11, 0x46201D19, 0x4226221B, 0x4027231B, 0x3D292519, 0x3A302B1E, 0x373C3220, 0x34493F2C, 0x31534839, 0x2E74695E, 0x2B9A9488, 0x289F988C, 0x259E9E90, 0x229D9D8E, 0x1F9C9C8B, 0x1D9E9E8C, 0x1D9E9E8C,
  0x1EBBC3C3, 0x21B9C1C1, 0x24BFB8BF, 0x26C2C2C2, 0x2ABCBCBC, 0x2DA4A4A4, 0x2F5C5C5C, 0x32383833, 0x362F2F25, 0x392C231A, 0x3C2A2211, 0x3F2C2010, 0x422A1B13, 0x45241616, 0x48231511, 0x4B251411, 0x4E231610, 0x512B1912, 0x54391E18, 0x57462623, 0x5A52302A, 
        0x5D57392E, 0x5F5B3D32, 0x625D3B31, 0x655F392D, 0x67653D31, 0x6A673E32, 0x6C6A3F31, 0x6E6E4239, 0x716E453F, 0x736E463D, 0x75734941, 0x77774F46, 0x79774F45, 0x7A795144, 0x7C785245, 0x7E7B4E48, 0x7F764848, 0x81724241, 0x82714644, 0x83724945, 
        0x846F4B47, 0x856E4C46, 0x8572544C, 0x87725652, 0x876D4D4B, 0x88664845, 0x88644743, 0x8863473F, 0x8960443B, 0x8960463B, 0x8960483D, 0x88634541, 0x88634347, 0x88664547, 0x87634545, 0x86624642, 0x86604640, 0x855F463F, 0x84624B43, 0x83644741, 
        0x8160423F, 0x805B3D39, 0x7E563A34, 0x7D533730, 0x7B482F27, 0x7A443025, 0x7845322A, 0x76472F29, 0x74482D29, 0x724B2E2A, 0x6F4B3029, 0x6D4A3029, 0x6B4C3428, 0x684B3327, 0x66503428, 0x6352382E, 0x6151372F, 0x5E49302B, 0x5B3A271E, 0x582B1C11, 
        0x55241E0F, 0x531E180C, 0x4F1C1909, 0x4D1D1A10, 0x4A1E1E18, 0x46202019, 0x4326221A, 0x412F271B, 0x3D322D1D, 0x3A39301E, 0x383F3624, 0x34493F31, 0x305A4F45, 0x2E797469, 0x2B948E88, 0x289F988C, 0x259E9790, 0x229D9D8E, 0x1F9C9C93, 0x1F9C9C93,
  0x21B9B9C1, 0x23BDC4C4, 0x27B6B6BD, 0x2ABCBCBC, 0x2CB3B3B3, 0x308F8A8A, 0x33413737, 0x36382F2A, 0x393A2C23, 0x3C37261D, 0x3F302018, 0x432D1E16, 0x452C1916, 0x49261818, 0x4C211717, 0x4F231916, 0x52251B12, 0x5530241B, 0x58422B25, 0x5B51352C, 0x5D5A3934, 
        0x615B3934, 0x635F3B33, 0x66643E37, 0x69684137, 0x6B6D4539, 0x6E714739, 0x7172483A, 0x7375483D, 0x7575493E, 0x77754840, 0x79794B45, 0x7B7E5048, 0x7D805349, 0x7F84584A, 0x81835846, 0x8385574B, 0x84855251, 0x867F4F4C, 0x87815450, 0x88815652, 
        0x897E514E, 0x8A7D524F, 0x8B835B57, 0x8C845E5B, 0x8D7F5858, 0x8D7E5854, 0x8D78544F, 0x8E724E49, 0x8E6E4C45, 0x8E6D4B42, 0x8E6D4B42, 0x8D6F4944, 0x8D714848, 0x8D734D4D, 0x8C704E4A, 0x8B6D4C47, 0x8B684943, 0x8A6A4D45, 0x896B5148, 0x87694941, 
        0x8666423A, 0x85613D37, 0x835D3A34, 0x815A3933, 0x8053332D, 0x7E523630, 0x7D513530, 0x7B50332D, 0x7954342E, 0x7656362F, 0x74573630, 0x72593931, 0x705A3B2F, 0x6D583A2C, 0x6A5B3C30, 0x685D3D35, 0x655D3937, 0x62583B34, 0x5F4B3228, 0x5D3C291B, 
        0x592A1F11, 0x57231A0B, 0x531E1B0F, 0x501C1913, 0x4D211D1A, 0x4A221B18, 0x47272019, 0x4429251A, 0x412F271F, 0x3E352D20, 0x3B3C2F26, 0x3745372E, 0x344E3F35, 0x3162584E, 0x2E8A8479, 0x2BA09A94, 0x2898988C, 0x259E9790, 0x229D9D8E, 0x229D9D8E,
  0x23BDBDC4, 0x26BBBBC2, 0x29BABAC0, 0x2DBABABA, 0x30BFB9BF, 0x3373736E, 0x36423333, 0x393E2C28, 0x3C3F2A22, 0x403B231B, 0x43351E1A, 0x462F2019, 0x492D1B1B, 0x4C2B1E21, 0x4F231C1C, 0x521F1F18, 0x55242418, 0x59363022, 0x5C4D3A2F, 0x5F553A30, 0x62603E39, 
        0x65673F3F, 0x6869423F, 0x6B6D4540, 0x6D6D453E, 0x706C4438, 0x73724B3D, 0x75795041, 0x777C5142, 0x7A7F4F42, 0x7C7F4D45, 0x7E83504A, 0x8085514D, 0x8287564A, 0x84895647, 0x868A5742, 0x888A594A, 0x898B5D57, 0x8A8A5A56, 0x8C8C5E59, 0x8D8A5D58, 
        0x8E865752, 0x8F895A55, 0x908D5F5C, 0x918F625E, 0x928C615F, 0x928B615D, 0x93865D59, 0x93835854, 0x93805851, 0x937A5148, 0x937A5348, 0x937C534C, 0x92805350, 0x92845A55, 0x91835B55, 0x907D564F, 0x907A544D, 0x8F77554A, 0x8E725247, 0x8C704A43, 
        0x8B734941, 0x8A70473E, 0x89683F37, 0x86643C37, 0x8565403B, 0x83664140, 0x81643F3F, 0x7F643E3A, 0x7D663F39, 0x7B674039, 0x79663F38, 0x7669423A, 0x74694338, 0x72684235, 0x6F6B4436, 0x6C6C443D, 0x696A3E3C, 0x67623D38, 0x63593B2E, 0x614B3424, 
        0x5E362515, 0x5B271C0E, 0x57231D14, 0x54211B15, 0x51221919, 0x4E231A1A, 0x4A251E1B, 0x482E1F1C, 0x44302521, 0x41362723, 0x3E392D29, 0x3A41302B, 0x374A3C37, 0x3462534E, 0x317C726D, 0x2E9B958A, 0x2B9A9A8E, 0x289F9892, 0x249B9B94, 0x249B9B94,
  0x25C0C0C7, 0x28BFBFC5, 0x2CB9B9BF, 0x2FBDB8BD, 0x328E8989, 0x36382F2A, 0x393A2C28, 0x3C44332A, 0x3F3C2820, 0x4339261E, 0x46322019, 0x49301F1B, 0x4D2E1D1D, 0x5029191F, 0x53241B18, 0x5720201A, 0x5A2D271F, 0x5D44362B, 0x60543F35, 0x635C3D35, 0x66664139, 
        0x696A433E, 0x6C6E4644, 0x6F704942, 0x72714B40, 0x75754E43, 0x77774F42, 0x7A7B5544, 0x7C815445, 0x7E855448, 0x8187544C, 0x8387554D, 0x85895450, 0x8789524B, 0x898B5548, 0x8B8B5645, 0x8D885249, 0x8E895755, 0x8F8C5A57, 0x918C5957, 0x928C5C58, 
        0x948D5B57, 0x958F5E5C, 0x95915F5E, 0x96936260, 0x97936666, 0x97926463, 0x97926461, 0x98916560, 0x978D635C, 0x98875D53, 0x98835B51, 0x98875A53, 0x97895A55, 0x978D5F5A, 0x968E645D, 0x958C645E, 0x9588635A, 0x94845E57, 0x937E5B51, 0x927F5850, 
        0x907F544D, 0x8F795048, 0x8D764D46, 0x8C764E48, 0x8A77524D, 0x88795450, 0x86795551, 0x84774F4B, 0x82774C48, 0x80794D49, 0x7D784D47, 0x7B754C44, 0x79774D43, 0x76764B40, 0x73754B40, 0x71754841, 0x6E714242, 0x6B6D423D, 0x68643F35, 0x65583C2D, 
        0x62432E21, 0x5E301D12, 0x5B271910, 0x58221714, 0x55241815, 0x52221815, 0x4F261C16, 0x4B2C221B, 0x482E231F, 0x452F241D, 0x41362B23, 0x3E41352D, 0x3B453333, 0x37534540, 0x34756662, 0x319C968C, 0x2E9B9B90, 0x2B9A9A8E, 0x279C9C8F, 0x279C9C8F,
  0x28B8BFBF, 0x2BC3C3C3, 0x2FBDBDBD, 0x32A39E9E, 0x35393030, 0x38362828, 0x3C3F2E2A, 0x403B2B23, 0x4339291E, 0x4636241D, 0x49302218, 0x4D31211D, 0x502C1C1C, 0x542A1B1E, 0x57261A17, 0x5A2D211C, 0x5E3B3028, 0x614E3C31, 0x64593F33, 0x67603D33, 0x6A69433C, 
        0x6D6B433E, 0x706F4841, 0x73704842, 0x76764F45, 0x79795447, 0x7C7B5243, 0x7E7D5244, 0x80835547, 0x83895349, 0x868C5951, 0x888A564E, 0x898D554F, 0x8B8B524B, 0x8E8D544B, 0x90925A4D, 0x918F5750, 0x938F5B58, 0x958F5A57, 0x968E5A56, 0x97905C59, 
        0x99905B56, 0x99925C59, 0x9A94615E, 0x9B93605F, 0x9C946161, 0x9C946160, 0x9C956360, 0x9D986764, 0x9D95645D, 0x9D8E5F57, 0x9D8E6157, 0x9D91625A, 0x9D93615D, 0x9C956560, 0x9C956863, 0x9B936862, 0x9A916761, 0x998E6A61, 0x988D6960, 0x978D685E, 
        0x958A6158, 0x94865E56, 0x9289615A, 0x91886059, 0x8F8A655E, 0x8D8A645F, 0x8B89645D, 0x89875E5B, 0x87855654, 0x84835451, 0x82835650, 0x8083574F, 0x7D82554B, 0x7A815347, 0x787D4C41, 0x757B4945, 0x72764545, 0x6F72423D, 0x6C6C4238, 0x69633E35, 
        0x6657392D, 0x6241271F, 0x5F301812, 0x5C261610, 0x58221411, 0x55241812, 0x52251815, 0x4F291C16, 0x4B282217, 0x482A2318, 0x452C241D, 0x413A2F27, 0x3E3D2D29, 0x3A4A3D34, 0x37615753, 0x34979389, 0x309F998F, 0x2D9E9893, 0x2A9D9D91, 0x2A9D9D91,
  0x2BB7B7BD, 0x2EC1BCC1, 0x32BCBCBC, 0x35959090, 0x384D3F3F, 0x3B403333, 0x3F403030, 0x4335291E, 0x463A2B20, 0x49302618, 0x4D2E241A, 0x512F2219, 0x542D1E1E, 0x572B1A1D, 0x5B2A1C19, 0x5E382825, 0x61493731, 0x65553C34, 0x685F3F35, 0x6B684239, 0x6E6E473E, 
        0x716E453F, 0x756E453C, 0x78744C43, 0x7B785246, 0x7D7C5347, 0x807B5145, 0x83805347, 0x8686574C, 0x878D584E, 0x8A8F5C52, 0x8D8E584F, 0x8E8F574E, 0x918C544D, 0x93915851, 0x95945A55, 0x96935B55, 0x98945F5A, 0x99935C57, 0x9B915B58, 0x9C945C58, 
        0x9D935D59, 0x9F94605B, 0x9F98635E, 0xA098625F, 0xA196615E, 0xA1945E5D, 0xA298645F, 0xA29B6A64, 0xA298675F, 0xA2936259, 0xA2936459, 0xA296665E, 0xA197635D, 0xA197655E, 0xA1976860, 0xA0976A62, 0x9F986C64, 0x9E976F63, 0x9C946D61, 0x9B936A60, 
        0x9A91675E, 0x99906660, 0x97926963, 0x95916861, 0x94906860, 0x9290685F, 0x908F665C, 0x8E8F625D, 0x8B8E5D5B, 0x89895955, 0x878B5C56, 0x848C5E58, 0x818B5A52, 0x7F88584E, 0x7C855449, 0x79844F4B, 0x767F4B49, 0x73774642, 0x7071463B, 0x6D6B4337, 
        0x6A674339, 0x6655322A, 0x633B1917, 0x602D1512, 0x5C241613, 0x59221411, 0x55241812, 0x52251B15, 0x4F231C13, 0x4B282217, 0x482A2618, 0x44342921, 0x413A2B27, 0x3D42362D, 0x3A3D3027, 0x375C534A, 0x3387877D, 0x309F998F, 0x2C9C9C90, 0x2C9C9C90,
  0x2EBCBCBC, 0x31C0C0C0, 0x34C4C4C4, 0x389F9A9A, 0x3B493C3C, 0x3E413131, 0x42392E2A, 0x46362B20, 0x4930261B, 0x4D2B2417, 0x51282215, 0x542A2118, 0x582B1C1A, 0x5B2A1C1C, 0x5F2D1D1D, 0x623E2E29, 0x65533934, 0x69593C32, 0x6C654238, 0x6F70463D, 0x73754B40, 
        0x76724B3E, 0x79734B41, 0x7C785247, 0x7F7E544A, 0x827D5248, 0x857E5246, 0x8781584B, 0x8987594E, 0x8C8D5B50, 0x8F8E594E, 0x918D594D, 0x93915B4F, 0x95915A50, 0x98925B55, 0x99955C59, 0x9B965F5B, 0x9D96625D, 0x9E95605B, 0xA0955F5C, 0xA197615E, 
        0xA39A6562, 0xA39C6865, 0xA49B6763, 0xA59B6762, 0xA69A6661, 0xA69A6660, 0xA79C6A64, 0xA79E6D64, 0xA79C6B61, 0xA798675C, 0xA796675B, 0xA699685D, 0xA699635B, 0xA697635B, 0xA699685E, 0xA5986A61, 0xA4996E63, 0xA3976E62, 0xA2956C5F, 0xA1926B60, 
        0x9F936960, 0x9E92675E, 0x9C94685E, 0x9A966B63, 0x9894695F, 0x9793695E, 0x9493675C, 0x9292615A, 0x9092615F, 0x8E90605D, 0x8B905F59, 0x8991625B, 0x86906057, 0x838B5B51, 0x808B594F, 0x7D88554F, 0x7A834F4D, 0x77794842, 0x7476483D, 0x7172483A, 
        0x6E6C453C, 0x6A603C34, 0x6747221D, 0x64301614, 0x60271715, 0x5D231310, 0x59251914, 0x56261D14, 0x52251F12, 0x4E272013, 0x4B2C2517, 0x47322B20, 0x44382D29, 0x4043372F, 0x3D4B3E36, 0x3A4F4A3D, 0x366C6759, 0x339B9B91, 0x2F9D9D92, 0x2F9D9D92,
  0x30B9BFBF, 0x33BEBEBE, 0x37C2C2BD, 0x3A76726D, 0x3E413535, 0x42412E32, 0x45372828, 0x4930261F, 0x4D2B2717, 0x50262216, 0x54242112, 0x58281F17, 0x5B2A1E1C, 0x5F302020, 0x62392724, 0x664B342F, 0x69593C35, 0x6D613C35, 0x706C443D, 0x73754B40, 0x77754D40, 
        0x7A754D3E, 0x7D7A5145, 0x807D5549, 0x837E5347, 0x8681574A, 0x8982574A, 0x8C86594E, 0x8F895A50, 0x918A5B50, 0x948B5B4D, 0x968D5D4E, 0x98916053, 0x9A925F54, 0x9C925C58, 0x9E956260, 0xA0976460, 0xA196635D, 0xA394605C, 0xA595645C, 0xA697645E, 
        0xA798675F, 0xA9996760, 0xA9976460, 0xAA97645D, 0xAB9A655D, 0xAB9A665F, 0xAC99675E, 0xAC9B6960, 0xAC9C6D61, 0xAC9B6D60, 0xAC986A5A, 0xAC98695B, 0xAC98665A, 0xAB97665A, 0xAB99695D, 0xA9996D60, 0xA9976D60, 0xA8976F60, 0xA7966E5F, 0xA6946B5E, 
        0xA4946961, 0xA395685F, 0xA194665D, 0x9F96695E, 0x9D96675D, 0x9B98685B, 0x9997665B, 0x9795665C, 0x95946661, 0x9293665F, 0x9092665D, 0x8D93665B, 0x8A91635A, 0x888E6156, 0x858B5D52, 0x82895852, 0x7F84524E, 0x7C784943, 0x7874483D, 0x7573493C, 
        0x726D4539, 0x6E654039, 0x6B532F2A, 0x67381D18, 0x64281614, 0x6025150F, 0x5D291B13, 0x59281F14, 0x56262011, 0x52252212, 0x4F262616, 0x4B2F281E, 0x47392E27, 0x44473C38, 0x4063574F, 0x3C837F72, 0x39938A81, 0x359E9990, 0x31A19C91, 0x31A19C91,
  0x33B9BEBE, 0x36BCC1BC, 0x3AAFB3AF, 0x3E41413D, 0x413E3632, 0x453E2C2C, 0x49342622, 0x4C2E281E, 0x50292919, 0x542A2718, 0x572B291A, 0x5B2F241C, 0x5F2D201D, 0x62342724, 0x663E2D2A, 0x694D3530, 0x6D5D3C37, 0x7169413A, 0x74714841, 0x77774A42, 0x7A774B3E, 
        0x7E754C3C, 0x817A5041, 0x847F5447, 0x877D5245, 0x8A805649, 0x8D83584D, 0x90865A4F, 0x93885B51, 0x958A5E50, 0x98885B4B, 0x9A8D5F4D, 0x9D936454, 0x9F916054, 0xA191605A, 0xA3956362, 0xA4966461, 0xA695645D, 0xA895655C, 0xAA97665E, 0xAB96655D, 
        0xAC96665E, 0xAD986861, 0xAE97675E, 0xAF98665E, 0xAF9B685F, 0xB09B6960, 0xB09A695F, 0xB19B6C5F, 0xB19C6E60, 0xB19B705F, 0xB19A6D5C, 0xB19A6A5C, 0xB198675A, 0xB0976759, 0xAF986B5C, 0xAF986E5F, 0xAD976E5E, 0xAD977161, 0xAC987363, 0xAA966D61, 
        0xA9966A61, 0xA793655C, 0xA694665D, 0xA497695E, 0xA298675B, 0xA0986559, 0x9E9A675A, 0x9C97685E, 0x99956A63, 0x97936861, 0x9492685E, 0x9292685C, 0x8F906559, 0x8C8F6257, 0x898B5E51, 0x86865B51, 0x83855751, 0x807F5149, 0x7C764B3F, 0x79734B3C, 
        0x766E473C, 0x72684239, 0x6F5B3932, 0x6B452826, 0x672C1816, 0x6423140C, 0x60271A12, 0x5D231B10, 0x59251F11, 0x55242112, 0x52282815, 0x4E302D20, 0x4A373029, 0x463D362F, 0x43534C44, 0x3F817971, 0x3C9D948C, 0x389F9A91, 0x35A39990, 0x35A39990,
  0x35B6BBBB, 0x39BBC4C0, 0x3DABAFAB, 0x405B5B53, 0x443F3834, 0x483F2E2A, 0x4C32241E, 0x4F30261C, 0x53312A1E, 0x57312B1D, 0x5B352C1E, 0x5E33281D, 0x6234241C, 0x663C2A25, 0x69432D29, 0x6D513530, 0x71603F38, 0x746D4641, 0x78744A41, 0x7B754A40, 0x7F764A3E, 
        0x82774E40, 0x857A5242, 0x887F5445, 0x8C7F5346, 0x8F815548, 0x9284574A, 0x9587584C, 0x97895A52, 0x9A8A5A54, 0x9D8B5A51, 0x9F8E6053, 0xA1926356, 0xA3926358, 0xA691635A, 0xA892635C, 0xA9946660, 0xAB976962, 0xAD986962, 0xAE976760, 0xB095635A, 
        0xB198645C, 0xB29B685F, 0xB39C675D, 0xB49B6661, 0xB59A6662, 0xB5986760, 0xB59A6B62, 0xB69B7164, 0xB69C7263, 0xB69C7260, 0xB69B6E5C, 0xB69B6D5C, 0xB59A695B, 0xB5986959, 0xB4996B5B, 0xB4996D5D, 0xB3996D5C, 0xB2996F5F, 0xB19B7161, 0xAF9B6E62, 
        0xAD9B6862, 0xAC99645D, 0xAA9A6760, 0xA89B6B60, 0xA798675B, 0xA5986759, 0xA2986959, 0xA097685D, 0x9E956863, 0x9B986C67, 0x99936861, 0x9692645D, 0x9393665D, 0x9091645C, 0x8D8C5F56, 0x8A8B5D56, 0x878B5E54, 0x8485584D, 0x807D5343, 0x7D764D3D, 
        0x7A724D3E, 0x766C473A, 0x73633B37, 0x6F502D2B, 0x6B361A1C, 0x6829110E, 0x64281611, 0x60251A12, 0x5D261B13, 0x59251F14, 0x552D241B, 0x51352B22, 0x4D3B2E27, 0x4A3D372C, 0x4650453D, 0x427F776F, 0x3E938F87, 0x3B9F9B8E, 0x379D988F, 0x379D988F,
  0x38BABFBF, 0x3BB9BEBE, 0x3FB1B5B5, 0x435F5F5B, 0x47352B27, 0x4B3D2C2C, 0x4F392926, 0x52372822, 0x56382C20, 0x5A3B2D21, 0x5E36251B, 0x6137271A, 0x6539281E, 0x69412924, 0x6D482E27, 0x71553831, 0x7464433D, 0x78704A43, 0x7C704941, 0x7F74463E, 0x8376493E, 
        0x86774D42, 0x897C5346, 0x8D7F5246, 0x90815448, 0x93815648, 0x96865849, 0x98885A49, 0x9C8C5B53, 0x9E8D585A, 0xA18E5A58, 0xA38F5D58, 0xA691635A, 0xA895695F, 0xA9966A5D, 0xAC956A5A, 0xAE966C5E, 0xB0976C63, 0xB19A6D64, 0xB3996A61, 0xB499665E, 
        0xB69C675F, 0xB79F695F, 0xB8A0685D, 0xB89E6763, 0xB99C6866, 0xBA9A6C68, 0xBA9C7068, 0xBB997266, 0xBB9C7467, 0xBB9F7464, 0xBB9C7060, 0xBA9D6D5D, 0xBA9E6C5D, 0xBA9E6C5D, 0xB99D6C5D, 0xB89D6E5F, 0xB79D6F5E, 0xB69C6E5D, 0xB59E7162, 0xB4A26F66, 
        0xB2A36966, 0xB19E6660, 0xAF9C665F, 0xAD9B685F, 0xAB97655A, 0xA997675B, 0xA7936758, 0xA4976960, 0xA2966762, 0xA09A6A67, 0x9C976865, 0x9A94645F, 0x97936661, 0x94936760, 0x9191635C, 0x8E8F625B, 0x8B8B5F54, 0x8884594C, 0x847F5443, 0x817A503F, 
        0x7D764D3D, 0x7A70493C, 0x76674038, 0x7358302E, 0x6F442024, 0x6B341517, 0x672C1816, 0x64281916, 0x60271A15, 0x5C291816, 0x58311F1C, 0x54362721, 0x513B2F28, 0x4C3F3228, 0x493E3426, 0x45585142, 0x417D796D, 0x3E98988B, 0x3A9E9990, 0x3A9E9990,
  0x3ABCC1C1, 0x3EB8BDBD, 0x42B9B9B9, 0x464C4C48, 0x4A332C25, 0x4E41302D, 0x5241312B, 0x553F3027, 0x593C2D22, 0x5D36291E, 0x6134241A, 0x65372A1B, 0x693C2B21, 0x6D412C25, 0x714A2F2A, 0x74573832, 0x7865453D, 0x7C6E4943, 0x7F704640, 0x8374473E, 0x87764B3F, 
        0x8A774F42, 0x8D7E5246, 0x90815648, 0x94825749, 0x97835748, 0x9A855746, 0x9D885A48, 0x9F8C5B53, 0xA38F5C5C, 0xA58F5C59, 0xA88F5D59, 0xAA93645B, 0xAD956B5F, 0xAF966B5C, 0xB1976D5D, 0xB3966D60, 0xB5956A62, 0xB5986B62, 0xB896675F, 0xB89A6860, 
        0xBA9D6A62, 0xBC9D695F, 0xBD9F6B61, 0xBDA06C67, 0xBE9E6B6B, 0xBE9E6F6B, 0xBF9B7167, 0xBF976E63, 0xBF9B7566, 0xBFA07769, 0xBF9E7363, 0xBF9C6E5F, 0xBF9E6B5E, 0xBE9F6D60, 0xBE9E6F60, 0xBD9F7061, 0xBC9D7061, 0xBB9C6E60, 0xBA9E7164, 0xB8A16F67, 
        0xB79F6B66, 0xB59E6963, 0xB49D6962, 0xB29D6B62, 0xB09A675F, 0xAE9A695E, 0xAB97665A, 0xA9996960, 0xA6996964, 0xA4996964, 0xA1976861, 0x9E94655E, 0x9C92655C, 0x9894675F, 0x9593665E, 0x928E615A, 0x8F8C6055, 0x8C885B4E, 0x88815647, 0x857C5240, 
        0x81784E3F, 0x7E714C3E, 0x7A6A423A, 0x765F3836, 0x734B2727, 0x6F391B1B, 0x6B2F1A17, 0x672C1B16, 0x63291C14, 0x5F2A1D18, 0x5B2F1E19, 0x5731231D, 0x54392D24, 0x4F3D3026, 0x4C46382E, 0x48463F31, 0x435F5B4C, 0x3F918D81, 0x3CA19D90, 0x3CA19D90,
  0x3CBFC3C3, 0x41BCC0C0, 0x45ADB1AD, 0x49494545, 0x4D382E2B, 0x5141352F, 0x5542332D, 0x593E332A, 0x5D3C2B23, 0x603A2A1F, 0x643A2B21, 0x683D2E22, 0x6C3F2C23, 0x70442F2B, 0x744C342D, 0x785B3D37, 0x7C66473F, 0x7F704A44, 0x83724941, 0x8772473E, 0x8A754B40, 
        0x8E775044, 0x917E5447, 0x94815648, 0x98835849, 0x9B815546, 0x9E855848, 0xA1895D4B, 0xA48B5B52, 0xA7905C5B, 0xAA915E5A, 0xAC92615A, 0xAF926459, 0xB195695C, 0xB2966B5B, 0xB5956B5B, 0xB7986F61, 0xB89A6E66, 0xBB9B6E64, 0xBC986A61, 0xBE9A6960, 
        0xBF9C6B62, 0xC09E6C63, 0xC1A37068, 0xC2A5716E, 0xC2A26F6E, 0xC39F716D, 0xC49E756D, 0xC49C7368, 0xC49D7568, 0xC49F776A, 0xC49F7368, 0xC4A17368, 0xC39F6F65, 0xC39E6E62, 0xC29F7166, 0xC2A17368, 0xC1A17569, 0xBFA07569, 0xBEA07569, 0xBD9F7168, 
        0xBC9F6E6A, 0xBAA06E6A, 0xB8A06E68, 0xB6A16E67, 0xB49D6B62, 0xB29E6B62, 0xB09B665D, 0xAD9B6B62, 0xAA9C6D67, 0xA8986963, 0xA5966761, 0xA3976A62, 0xA092655D, 0x9D91645C, 0x9A92665E, 0x9690625A, 0x938D5F54, 0x908A5D4F, 0x8C84594A, 0x89805344, 
        0x857C5442, 0x81785042, 0x7E714840, 0x7A623C38, 0x764D2B2B, 0x723E211F, 0x6E35201B, 0x6A301F18, 0x662D2019, 0x622E211A, 0x5E30231B, 0x5B35271E, 0x573A2B26, 0x53372A1E, 0x4F403629, 0x4B4A4033, 0x47686052, 0x438C8C7D, 0x3F9D9D91, 0x3F9D9D91,
  0x3FB9BDBD, 0x43B6BABA, 0x478F938F, 0x4B33332F, 0x4F403633, 0x5340312E, 0x5842312E, 0x5C3A2C26, 0x6035271F, 0x643D3026, 0x68423529, 0x6C3F3325, 0x70412F26, 0x744A3430, 0x78543935, 0x7B5F4039, 0x7F684840, 0x83704B43, 0x87744B43, 0x8A73473E, 0x8E764C40, 
        0x92795145, 0x957C5246, 0x997F5447, 0x9C805647, 0x9F805444, 0xA2855748, 0xA5895C4B, 0xA88C5C53, 0xAA905D5A, 0xAE905D59, 0xB094645D, 0xB395675C, 0xB5956A5C, 0xB8966D5C, 0xBA986E5D, 0xBC986D5E, 0xBD976B60, 0xBF9B6F66, 0xC1996C61, 0xC297685F, 
        0xC39A6B62, 0xC59E7067, 0xC6A2716B, 0xC6A77771, 0xC7A67471, 0xC8A27671, 0xC8A27972, 0xC8A17B71, 0xC99D766C, 0xC8A0766B, 0xC9A2776E, 0xC8A67871, 0xC8A3746D, 0xC7A3746B, 0xC7A5786F, 0xC6A3786F, 0xC5A57A71, 0xC4A67C72, 0xC3A2786F, 0xC1A57871, 
        0xC0A37471, 0xBEA47470, 0xBCA3716D, 0xBBA16F68, 0xB99D6A64, 0xB69E6A63, 0xB49B655D, 0xB29D6B62, 0xAF9B6C65, 0xAC986961, 0xAA966760, 0xA7986A62, 0xA493665D, 0xA191655A, 0x9E90635B, 0x9A92645C, 0x97906157, 0x938C5D51, 0x9086584C, 0x8C815746, 
        0x897E5546, 0x857C5448, 0x81764E46, 0x7D6A433F, 0x79543230, 0x76402420, 0x7239251C, 0x6E35241E, 0x6A32241A, 0x6632251B, 0x6234271C, 0x5E36251D, 0x5A382D24, 0x55392D24, 0x513E3225, 0x4D484234, 0x49686557, 0x45938F81, 0x41A09C91, 0x41A09C91,
  0x42B9BDBD, 0x46AEB2B2, 0x4A6E6E6E, 0x4E30302D, 0x523A342E, 0x563E2F2C, 0x5A3E302A, 0x5E382B23, 0x633B2B23, 0x67423329, 0x6B42342A, 0x6F403226, 0x73463229, 0x774D3733, 0x7B563E37, 0x7F5C4038, 0x83684740, 0x87704B43, 0x8A734B44, 0x8E764B42, 0x92784C42, 
        0x95775044, 0x99794F42, 0x9C805447, 0xA082574A, 0xA3835749, 0xA6855847, 0xA98A5B4B, 0xAC8F6055, 0xAF925F5B, 0xB293615B, 0xB594645C, 0xB7976B5E, 0xB9986D5E, 0xBC986E5D, 0xBE9A705D, 0xC09A7160, 0xC2976C5F, 0xC39C7165, 0xC5996C60, 0xC6996C62, 
        0xC89E7269, 0xC9A27770, 0xCAA57871, 0xCBA87B75, 0xCCAA7A76, 0xCCA77B76, 0xCCA37A73, 0xCDA67F78, 0xCDA37D74, 0xCDA37A73, 0xCDA67D75, 0xCDA77A74, 0xCCA77A74, 0xCCA87B75, 0xCBA87E78, 0xCAAA7F78, 0xC9A88078, 0xC8A67D76, 0xC7A67D75, 0xC6A77C77, 
        0xC4A77676, 0xC3A77776, 0xC0A77674, 0xBFA4736E, 0xBDA06F68, 0xBBA06E67, 0xB89D6861, 0xB69E6E66, 0xB39C6D64, 0xB19A6A61, 0xAE97675E, 0xAB976960, 0xA892655A, 0xA5906457, 0xA18C5E55, 0x9E92635B, 0x9B905F56, 0x978D5E52, 0x9487574B, 0x90825646, 
        0x8C815748, 0x897E554A, 0x8578504A, 0x816E4842, 0x7D593935, 0x79432521, 0x7538241C, 0x7136261B, 0x6D332519, 0x6935291D, 0x6537281E, 0x6137271F, 0x5C3C2F26, 0x5842362B, 0x543C3324, 0x50494232, 0x4C5A5346, 0x488A8274, 0x449D9D8E, 0x449D9D8E,
  0x44BBBFBF, 0x48B8BBB8, 0x4D707070, 0x5141413B, 0x55332D27, 0x593E302D, 0x5D392926, 0x61372722, 0x6641322A, 0x6943352B, 0x6E403227, 0x72423528, 0x764B382F, 0x7A533C38, 0x7E563E38, 0x825C4038, 0x8666443C, 0x8A6C4540, 0x8E724942, 0x92764A40, 0x95774C40, 
        0x99754E42, 0x9D774D40, 0xA0805447, 0xA482584A, 0xA77F5545, 0xAA825443, 0xAD885B49, 0xB08E5F53, 0xB395635D, 0xB694635C, 0xB9926257, 0xBB966B5D, 0xBE986D5C, 0xC0976D5B, 0xC299705B, 0xC49D7362, 0xC69A6F61, 0xC89C7164, 0xC99A6E63, 0xCBA0746A, 
        0xCCA1766E, 0xCDA37970, 0xCEA87F78, 0xCFAC817C, 0xD0AC7D7A, 0xD0A87C78, 0xD1A27871, 0xD1A8827B, 0xD1A57E78, 0xD1A9807B, 0xD1A97D7A, 0xD1AA807C, 0xD1AC817E, 0xD0AD8380, 0xCFAC827E, 0xCFAA827E, 0xCEAA837F, 0xCDA9837E, 0xCBA77F79, 0xCAA87B7A, 
        0xC8AA7677, 0xC7AA7878, 0xC5AA7977, 0xC3A77773, 0xC1A67570, 0xBFA4736E, 0xBC9D6E67, 0xBA9E7066, 0xB79A6C62, 0xB595675D, 0xB195665C, 0xAF96695E, 0xAC94665B, 0xA9916458, 0xA58C5D51, 0xA2906157, 0x9E905E56, 0x9B8D5D52, 0x9788594B, 0x94845648, 
        0x90825648, 0x8C7F534A, 0x88794E48, 0x846F4945, 0x805F3D39, 0x7C472D24, 0x783B261D, 0x7434251A, 0x7034281D, 0x6C3B2F23, 0x683A2C22, 0x6435261C, 0x5F382A22, 0x5B46382F, 0x57433A2B, 0x52443A2E, 0x4F676053, 0x4B958E84, 0x4698988A, 0x4698988A,
  0x46B9BDBD, 0x4BB0B4B0, 0x4F737773, 0x53373731, 0x57372E2B, 0x5C3C2C29, 0x60372722, 0x643A2B23, 0x693E3026, 0x6D3E3027, 0x713F3126, 0x75433427, 0x794B3A32, 0x7E523E38, 0x82563E38, 0x865F423C, 0x8A674540, 0x8D6D4840, 0x91714942, 0x95754B40, 0x99754A3F, 
        0x9D764D42, 0xA07A5142, 0xA47D5245, 0xA77F5547, 0xAA825748, 0xAE845747, 0xB18B5F4D, 0xB48F5F54, 0xB7905E57, 0xBA925F57, 0xBD926358, 0xBF94675A, 0xC2966B5A, 0xC4966E59, 0xC699705A, 0xC89E7664, 0xCA9D7364, 0xCCA17669, 0xCD9F776A, 0xCFA67C72, 
        0xD0A37A70, 0xD1A47B73, 0xD2A9817B, 0xD3AA807B, 0xD4AB7C7A, 0xD5A77A77, 0xD5A47B74, 0xD5AB8680, 0xD5A47C78, 0xD5AB8280, 0xD5A77C7A, 0xD5AB807E, 0xD5AE8582, 0xD4AF8682, 0xD4AE8682, 0xD3AF8784, 0xD2AF8887, 0xD1B28C89, 0xCFAD8783, 0xCDB08383, 
        0xCDB07C7F, 0xCBAC787A, 0xC9AD7E7E, 0xC7AB7D7A, 0xC4A77875, 0xC2A67974, 0xC09D7169, 0xBE9F7368, 0xBB9F7267, 0xB99A6D62, 0xB6986A5D, 0xB3966A5D, 0xB0926659, 0xAC926658, 0xA98B5E51, 0xA68F5E57, 0xA2925E57, 0x9E8F5E53, 0x9B8B5B4E, 0x97845749, 
        0x93815648, 0x907F544A, 0x8C795048, 0x88704A47, 0x8462413B, 0x804B3129, 0x7B3E2B21, 0x77392A1D, 0x7337291C, 0x6F392B1D, 0x6A3E3024, 0x663C2F25, 0x6236271F, 0x5E3E3328, 0x5A43382D, 0x55483F33, 0x51615B4E, 0x4D989487, 0x49A4A496, 0x49A4A496,
  0x48B8BBBB, 0x4DACAFAF, 0x527F7F7C, 0x562C2923, 0x5A38302A, 0x5E382B23, 0x63382B21, 0x673D2E25, 0x6B3B2D23, 0x703D2D26, 0x73403027, 0x7843352C, 0x7D4D3930, 0x80533D35, 0x84583F36, 0x8962463B, 0x8D684B40, 0x916E4D3F, 0x95724C3F, 0x99744E3F, 0x9C754C3F, 
        0xA0784D42, 0xA47D5244, 0xA77C5042, 0xAB805141, 0xAE815443, 0xB2845743, 0xB5895B46, 0xB88F5F51, 0xBB905C54, 0xBE8E594F, 0xC0956457, 0xC3966658, 0xC6986A5A, 0xC79A6C5D, 0xCA9D7162, 0xCBA2746A, 0xCDA3746D, 0xD0A57A71, 0xD1A87C75, 0xD3A97E76, 
        0xD4A98078, 0xD5A88179, 0xD6A78178, 0xD7A9807A, 0xD8AB7B78, 0xD9A87976, 0xD9A97F79, 0xD9B08884, 0xDAA87F7A, 0xDAAB817E, 0xDAA17470, 0xD9A97F7A, 0xD9AE8683, 0xD8AD8581, 0xD8AE8682, 0xD7B28B87, 0xD6B08885, 0xD5B08A85, 0xD4AF8885, 0xD2AF8583, 
        0xD0AD7C7E, 0xCFA87877, 0xCDA97D78, 0xCBA87D78, 0xC9A77C76, 0xC7A57C75, 0xC49E736E, 0xC19F746D, 0xBF9E7269, 0xBC996C62, 0xB996695F, 0xB697695D, 0xB3926356, 0xB0916356, 0xAD8B5C4D, 0xA9906155, 0xA6916055, 0xA2906156, 0x9E8C5E50, 0x9B835849, 
        0x97815748, 0x9381594C, 0x8F7C5548, 0x8B714B41, 0x87653F3A, 0x8353342C, 0x7F442E22, 0x7A3E2D21, 0x763A2D20, 0x72392C1F, 0x6E3E3024, 0x6946372D, 0x643D2B26, 0x61372C24, 0x5C3C3729, 0x583F392E, 0x53656255, 0x509F9B92, 0x4B9C998E, 0x4B9C998E,
  0x4BB7BBBB, 0x50B8B8B8, 0x547F7C79, 0x582E2822, 0x5D362E26, 0x61372C1F, 0x66392A20, 0x6A3C2D24, 0x6E3C2E27, 0x723E2E28, 0x77402F2A, 0x7B46352F, 0x7F4E3A32, 0x84563D32, 0x885B4138, 0x8C62463A, 0x90664A3A, 0x946C4D3A, 0x986F4E3C, 0x9C724E3A, 0xA0744C3C, 
        0xA47A4D42, 0xA77C4F44, 0xAB7E5043, 0xAF815242, 0xB2845543, 0xB5865841, 0xB9875A41, 0xBC8D5B4B, 0xBF946157, 0xC2925D52, 0xC4986557, 0xC6996858, 0xC99C6B5D, 0xCC9C6B60, 0xCE9E6F66, 0xD0A47370, 0xD2A97575, 0xD4AB7A78, 0xD5AB7C79, 0xD7A97D78, 
        0xD8AB8078, 0xD9A98178, 0xDAA78176, 0xDBAB847C, 0xDCA97976, 0xDDAA7C77, 0xDDAC7F7C, 0xDDAF8580, 0xDEAB7F7B, 0xDEA9807B, 0xDEA0756E, 0xDDA9807B, 0xDDAF8883, 0xDCAD8781, 0xDCAC8680, 0xDBAE8781, 0xDAAA837D, 0xD8AE8781, 0xD8AE8781, 0xD6AD8482, 
        0xD5A87C7B, 0xD3A57A76, 0xD1A77D76, 0xCFA67C73, 0xCDA67E77, 0xCBA27B75, 0xC89E7472, 0xC69E7470, 0xC39C716A, 0xC0976A63, 0xBD976960, 0xBA986A5E, 0xB794665A, 0xB4926557, 0xB08E5F50, 0xAD916356, 0xA9906155, 0xA68E5E52, 0xA2885C4E, 0x9E825648, 
        0x9A805746, 0x96815B4A, 0x927B5543, 0x8E744B40, 0x8A6A403C, 0x865D3931, 0x824C322B, 0x7D3F2A22, 0x793F2E23, 0x753E3127, 0x703D2D26, 0x6C422F2A, 0x683F2E2C, 0x633D332B, 0x5F454338, 0x5B484838, 0x56676758, 0x51999990, 0x4E9F9F92, 0x4E9F9F92,
  0x4EB6B9B6, 0x52B3B6B3, 0x5664615E, 0x5B2C241E, 0x5F382D25, 0x6433281E, 0x6833271D, 0x6D3A2C22, 0x713C2F26, 0x753C2D24, 0x7A3E2D27, 0x7E44342E, 0x834F3A32, 0x87583E34, 0x8B60433A, 0x8F63453A, 0x93664639, 0x986C4B3C, 0x9B74503E, 0x9F734C39, 0xA3754A3C, 
        0xA7794C41, 0xAB7A4B41, 0xAE7D5041, 0xB2825443, 0xB5855643, 0xB9875944, 0xBC875942, 0xBF8B5949, 0xC2925E55, 0xC5915C51, 0xC7986657, 0xCA9A6B5A, 0xCD9D6B5E, 0xCF9D6C61, 0xD1A27168, 0xD4A5746F, 0xD6A77573, 0xD8A87874, 0xD9A77873, 0xDBA57971, 
        0xDCA67D74, 0xDDA77F76, 0xDEA68075, 0xDFA87E76, 0xE0A87C77, 0xE0AB817D, 0xE1B08783, 0xE1B18985, 0xE1AA837C, 0xE1A9817B, 0xE1A8817C, 0xE1AB847E, 0xE1AE8680, 0xE0AC8680, 0xDFAC847E, 0xDFA9817C, 0xDDAB837D, 0xDDAB837C, 0xDBAA817C, 0xDAAA807E, 
        0xD8A87B7B, 0xD7A67A77, 0xD5A67B74, 0xD3A57B72, 0xD1A47B72, 0xCEA17772, 0xCCA07674, 0xC89E736F, 0xC79C6F6A, 0xC4996B62, 0xC196695F, 0xBD96685D, 0xBB956A5C, 0xB7936557, 0xB4916453, 0xB0926457, 0xAD916156, 0xA98B5D51, 0xA5875A4D, 0xA1815648, 
        0x9D7F5747, 0x997E5747, 0x95795544, 0x91754D44, 0x8D683F3B, 0x895D3932, 0x8552372F, 0x80412D23, 0x7C3F2F24, 0x7742332A, 0x733D2E27, 0x6F3D2B26, 0x6A453432, 0x6641342F, 0x6149463C, 0x5D4F4F41, 0x5978786C, 0x549A9A91, 0x509F9F95, 0x509F9F95,
  0x50B5B8B8, 0x54B2B5B2, 0x596C6966, 0x5D29201E, 0x62362C27, 0x66342A20, 0x6B31261E, 0x6F3B2B24, 0x743D3027, 0x783B2C24, 0x7D3D2A24, 0x8144332B, 0x85523B33, 0x8A5D3E35, 0x8E624237, 0x92664339, 0x96694739, 0x9B6F493B, 0x9F734C3C, 0xA3734C3B, 0xA7764C3C, 
        0xAA784B3F, 0xAE774A3E, 0xB27D5041, 0xB6825443, 0xB9835643, 0xBC875744, 0xC0875844, 0xC38B584A, 0xC68F5A51, 0xC98F5B4F, 0xCC986758, 0xCE986858, 0xD09A6B5C, 0xD39C6E62, 0xD59E6F66, 0xD7A1726C, 0xD9A3726F, 0xDBA2716E, 0xDDA4766F, 0xDEA47972, 
        0xE0A47C72, 0xE1A67E73, 0xE2A37C71, 0xE3A57C74, 0xE4AA817C, 0xE4AC847E, 0xE5B08A84, 0xE5AE8982, 0xE5AC877F, 0xE5A7827C, 0xE5A8857D, 0xE5AD8881, 0xE4AD8680, 0xE4AA847E, 0xE3AB837D, 0xE3AC847E, 0xE2AA817C, 0xE0A9807A, 0xDEA87F79, 0xDEA77C78, 
        0xDCA97B79, 0xDAA77A76, 0xD8A67B72, 0xD6A77E73, 0xD4A2786E, 0xD1A1766F, 0xD09E7571, 0xCD9D726E, 0xCA9D716B, 0xC79A6E66, 0xC4986A61, 0xC195655B, 0xBE94685C, 0xBB8E6052, 0xB7906152, 0xB48E5F53, 0xB0905F54, 0xAC8C5D52, 0xA8875A4E, 0xA5815649, 
        0xA17E5547, 0x9D7B5547, 0x99795442, 0x94744D44, 0x906A433D, 0x8C5B3A32, 0x88523830, 0x8347342C, 0x7F403026, 0x7A423229, 0x763E2F29, 0x72392823, 0x6D3E2E2C, 0x68423531, 0x644C473D, 0x5F78786B, 0x5A8A8A7F, 0x56A2A296, 0x52A1A194, 0x52A1A194,
  0x52B6BABA, 0x56B7BAB7, 0x5B6D6A64, 0x5F221A15, 0x643A302B, 0x69352621, 0x6D352720, 0x723C2E28, 0x763E3126, 0x7B3C2B21, 0x7F3A2A1E, 0x84453428, 0x88543D32, 0x8C5E3F32, 0x91623F34, 0x95664236, 0x996D493B, 0x9E70483B, 0xA171483A, 0xA6744A3B, 0xAA764C3D, 
        0xAE774B3D, 0xB17A4C3D, 0xB57C4E40, 0xB8805242, 0xBC825342, 0xC0845543, 0xC3875846, 0xC68B594C, 0xC98F5D53, 0xCC926153, 0xCF966758, 0xD1976757, 0xD4986A5B, 0xD79B6E63, 0xD99C6F65, 0xDB9E7069, 0xDCA1716C, 0xDF9F706A, 0xE0A2766E, 0xE2A67D74, 
        0xE3A57D73, 0xE5A47E71, 0xE5A67F72, 0xE7A37B71, 0xE7A87F7A, 0xE8A47C75, 0xE8A57E76, 0xE9A7827B, 0xE9AA8780, 0xE9A7837C, 0xE9A6847C, 0xE8AD8982, 0xE8AE8882, 0xE8AB847F, 0xE7AB847D, 0xE6AA827D, 0xE5A77E78, 0xE4A67D77, 0xE3A97F7A, 0xE1A87B77, 
        0xDFA97B78, 0xDEA87C76, 0xDCA3776E, 0xDAA3796F, 0xD7A1766C, 0xD59F746C, 0xD39E726E, 0xD09D716C, 0xCE9C716B, 0xCB996E66, 0xC8976960, 0xC594655A, 0xC196695D, 0xBE906354, 0xBB8E6050, 0xB78C5D50, 0xB38C5C53, 0xAF8B5C54, 0xAC885B4F, 0xA782564A, 
        0xA47C5345, 0xA0785244, 0x9B775243, 0x97754E46, 0x936E4A45, 0x8F5E3E37, 0x8A52392F, 0x864D3A31, 0x82423127, 0x7D412E26, 0x7941302A, 0x73402C27, 0x6F3B2926, 0x6B3D312D, 0x6639342A, 0x6294948C, 0x5D9E9E96, 0x59A0A097, 0x549D9D91, 0x549D9D91,
  0x54B5B5B5, 0x59BCBFBC, 0x5D54524C, 0x6229241F, 0x66342A25, 0x6B312621, 0x6F362926, 0x743D2D29, 0x793C2E25, 0x7D3B2A20, 0x823A2B1F, 0x86483929, 0x8B564031, 0x8F5C3E30, 0x945E3D30, 0x98654435, 0x9C6B493A, 0xA06F493C, 0xA571493D, 0xA9754C3F, 0xAD774D3F, 
        0xB17B5240, 0xB57C5141, 0xB87E5042, 0xBC815243, 0xC0845445, 0xC3855848, 0xC6885A4B, 0xCA8A5A4F, 0xCD8D5B51, 0xD08D5D50, 0xD2926353, 0xD5956756, 0xD8976958, 0xDA976B5F, 0xDC9A6C62, 0xDE9C6F66, 0xE09F736A, 0xE29D7169, 0xE49C7268, 0xE5A47B70, 
        0xE7A27B6E, 0xE8A27C6D, 0xE9A68072, 0xEAA77F74, 0xEAA9807A, 0xEBA77E78, 0xEBA57D75, 0xECAB847E, 0xECAB8780, 0xECAA857E, 0xECAB8881, 0xECAD8982, 0xECB08983, 0xEBAD8781, 0xEAAB847F, 0xEAAB847E, 0xE8A8807B, 0xE7A87F79, 0xE6A87F7A, 0xE5A97E7A, 
        0xE3AA7B76, 0xE1AA7C76, 0xDFA5776D, 0xDDA5796F, 0xDBA2776D, 0xD8A1746C, 0xD6A0746F, 0xD49E736D, 0xD19E726C, 0xCE9D7169, 0xCB986B62, 0xC897695F, 0xC5966B5F, 0xC1926455, 0xBE8C5C4D, 0xBA8B5B50, 0xB68C5B54, 0xB38C5C55, 0xAF895C54, 0xAB865A51, 
        0xA77F564A, 0xA3785144, 0x9E775043, 0x9A734D45, 0x966E4A44, 0x91604039, 0x8D523930, 0x894E3730, 0x8447342A, 0x7F422E28, 0x7B422D27, 0x763E2624, 0x723E2A28, 0x6D3C302C, 0x694B463C, 0x6397978F, 0x5FA0A096, 0x5B9F9F94, 0x569F9F94, 0x569F9F94,
  0x56B7BDBA, 0x5AAFB2AF, 0x5F3A3835, 0x6438302B, 0x68312722, 0x6D302522, 0x72372A25, 0x763A2B26, 0x7B372921, 0x80392B1F, 0x843D2E20, 0x89483728, 0x8E543E2E, 0x92583C2B, 0x965B3E2C, 0x9B644636, 0x9F69493B, 0xA36D4C3C, 0xA8745043, 0xAC765145, 0xAF784F41, 
        0xB47D5340, 0xB77E5241, 0xBB7E5041, 0xBF815243, 0xC3845447, 0xC686574A, 0xC989594C, 0xCC8A5A4E, 0xD08B5B50, 0xD28E5E51, 0xD6916252, 0xD8946754, 0xDB956858, 0xDD976A5D, 0xDF986C60, 0xE1986C62, 0xE39B7167, 0xE59C7167, 0xE79C7166, 0xE99E7669, 
        0xEA9E7769, 0xEBA27A6A, 0xECA57F6F, 0xEDA77E73, 0xEEA77B76, 0xEFA97E79, 0xEFAA817C, 0xEFAB837E, 0xF0AA827D, 0xF0A9837D, 0xEFAB8780, 0xEFAB857F, 0xEFAD8781, 0xEEAE8681, 0xEEAD8580, 0xECAC847F, 0xECAA817B, 0xEAA67D76, 0xE9A77F78, 0xE8AB7F7B, 
        0xE6AA7A76, 0xE4A97B73, 0xE2A5766D, 0xE0A77A6E, 0xDEA1746A, 0xDC9C6F66, 0xDA9D706A, 0xD79F736D, 0xD49D706A, 0xD19A6F66, 0xCE9A6D64, 0xCB996E62, 0xC7976B5E, 0xC4916455, 0xC18A5C4B, 0xBD8A5B4F, 0xB98B5B54, 0xB68E5F56, 0xB28C5F57, 0xAE875B53, 
        0xAA82584E, 0xA57B5448, 0xA1795347, 0x9D734F45, 0x99684742, 0x9460413A, 0x90543C31, 0x8B4B362D, 0x8749362B, 0x82422F27, 0x7D412A24, 0x793F2A25, 0x74483432, 0x703D342D, 0x6B79776D, 0x66A2A298, 0x61A2A297, 0x5D9E9E96, 0x58A19E96, 0x58A19E96,
  0x58B0B3B3, 0x5DB2B2AF, 0x6153514E, 0x66342D28, 0x6B362A28, 0x6F322422, 0x74322523, 0x79362A23, 0x7D392A22, 0x823C2F21, 0x873E2F1F, 0x8B453626, 0x904F3C2A, 0x95533B29, 0x995B4230, 0x9D624837, 0xA2694C3B, 0xA66E4E40, 0xAA755448, 0xAF745247, 0xB3774F41, 
        0xB77E533F, 0xBA7F5340, 0xBE805341, 0xC2815244, 0xC6835447, 0xC986564A, 0xCC895B4D, 0xCF8A594E, 0xD28D5D52, 0xD58F6153, 0xD9926353, 0xDB956958, 0xDE976B5B, 0xE0996E61, 0xE2996D63, 0xE59A7065, 0xE69B7368, 0xE89B7368, 0xEA9D7569, 0xECA37C6F, 
        0xEDA47F70, 0xEEA68070, 0xF0A7806F, 0xF0A97D73, 0xF1A97975, 0xF1A97B77, 0xF2A87975, 0xF2A67975, 0xF3A87D78, 0xF3A97F7A, 0xF3AA807C, 0xF2AC847E, 0xF1AC857F, 0xF1AB827E, 0xF1A9817A, 0xF0A9807A, 0xEFA9807A, 0xEEA97F79, 0xECA77E77, 0xEAA97D78, 
        0xE9A87874, 0xE8AA7A72, 0xE6A3756A, 0xE3A6786C, 0xE1A4766B, 0xDFA1746B, 0xDDA1746D, 0xDA9E726D, 0xD79B6E69, 0xD4986A62, 0xD1996C62, 0xCE97695F, 0xCA97695D, 0xC7956759, 0xC4906153, 0xC08B5C51, 0xBC8B5953, 0xB9895954, 0xB58A5D58, 0xB0885D56, 
        0xAC82584F, 0xA87B5449, 0xA47A5348, 0xA0755149, 0x9B67463F, 0x975C3F37, 0x92513B30, 0x8E47322A, 0x8948342A, 0x84453028, 0x80412923, 0x7B422B27, 0x76422F2D, 0x72473C35, 0x6D928E87, 0x68A1A197, 0x63A1A197, 0x5FA0A096, 0x5AA1A195, 0x5AA1A195,
  0x5AB2B5B5, 0x5EB0B0B0, 0x62504846, 0x673D312E, 0x6D352522, 0x71312421, 0x76312420, 0x7B332921, 0x80372D23, 0x843B3224, 0x893D3023, 0x8E443527, 0x924C3929, 0x9653392A, 0x9B5F4332, 0x9F664936, 0xA46C4D3A, 0xA9724F3F, 0xAD755042, 0xB1775042, 0xB5794F43, 
        0xB97E5244, 0xBD805445, 0xC0825747, 0xC5845648, 0xC887584A, 0xCC8A5C4E, 0xCF8C5D4E, 0xD38D5A50, 0xD58F5B54, 0xD9915F55, 0xDB936357, 0xDE976C5D, 0xE1986C5D, 0xE39B7063, 0xE59C6F62, 0xE79E7266, 0xE99C7264, 0xEB9C7063, 0xED9D7064, 0xEEA17569, 
        0xF0A4796E, 0xF1A3796D, 0xF2A3776C, 0xF3A67971, 0xF4AC7E7A, 0xF5AD7E7B, 0xF5AC7D7A, 0xF5AB7B7A, 0xF5AB7C7B, 0xF6AD807F, 0xF6AD7F7F, 0xF5AC8380, 0xF5AA857E, 0xF4AA837C, 0xF3A77F79, 0xF2A57E76, 0xF2A98179, 0xF1A98279, 0xEFA88077, 0xEEA97E77, 
        0xECA87874, 0xEAA97A74, 0xE9A17169, 0xE6A17269, 0xE4A27369, 0xE2A2746B, 0xDFA0726A, 0xDD9C6F68, 0xDA9B6F6A, 0xD79C706A, 0xD4996D66, 0xD194675C, 0xCE93675C, 0xCA956B5E, 0xC7936759, 0xC38D6055, 0xBF8A5951, 0xBB895950, 0xB78B5E53, 0xB3896052, 
        0xAF855C4E, 0xAB7D5447, 0xA6774F43, 0xA2745045, 0x9E67483D, 0x99593D33, 0x95523A2E, 0x90462F25, 0x8B432F24, 0x87433029, 0x81412B27, 0x7D3D2824, 0x783D2C28, 0x73564D46, 0x6F9E9B94, 0x6AA0A097, 0x65A1A197, 0x619F9F97, 0x5CA0A095, 0x5CA0A095,
  0x5BB6B3B6, 0x60B4AEAE, 0x657B716E, 0x6A34211F, 0x6F362422, 0x73352521, 0x7832241F, 0x7D302820, 0x82342F23, 0x87383225, 0x8B3E3326, 0x9046362A, 0x954E382C, 0x99573B30, 0x9E624335, 0xA2694836, 0xA7704C36, 0xAA764F3A, 0xAF79513E, 0xB47A4E3F, 0xB87D5043, 
        0xBC7E5248, 0xC0805448, 0xC4825547, 0xC7835548, 0xCA89594C, 0xCF8A5D4E, 0xD28C5D4D, 0xD58E5B52, 0xD8935C57, 0xDB935F58, 0xDE94645B, 0xE1976A5E, 0xE3976B5F, 0xE69A6C60, 0xE89E7063, 0xEA9E7062, 0xECA07262, 0xEEA07163, 0xF0A07064, 0xF1A17267, 
        0xF3A5776E, 0xF4A87A72, 0xF5A77870, 0xF6A77973, 0xF7AC7C79, 0xF8AA7C78, 0xF8A97A78, 0xF8AB7C7C, 0xF8AB7C7E, 0xF8AD7F81, 0xF8AE8084, 0xF8AC8281, 0xF8A9847F, 0xF7AA857F, 0xF7A9827B, 0xF5A88279, 0xF5AA857B, 0xF3AA857A, 0xF2AA8377, 0xF1A97C77, 
        0xEFA77876, 0xEDA97976, 0xEBA2716D, 0xE9A4746F, 0xE7A67770, 0xE4A4756D, 0xE2A2746B, 0xDF9F726B, 0xDD9C6F6C, 0xDA9C706B, 0xD7996E67, 0xD4976C63, 0xD0976C61, 0xCC976E62, 0xC992695D, 0xC58F6356, 0xC28C5E51, 0xBD8A5D4F, 0xBA8B624F, 0xB68C634E, 
        0xB188604C, 0xAD7F5846, 0xA97B5243, 0xA4755242, 0xA067493A, 0x9C593D30, 0x9752372B, 0x92493024, 0x8E402A20, 0x883F2C25, 0x843F2E26, 0x7F3A2A26, 0x7B352523, 0x755D544E, 0x719D9D96, 0x6CA2A299, 0x679EA096, 0x639FA195, 0x5E9FA297, 0x5E9FA297,
  0x5DB4B4B4, 0x62BBB8B6, 0x67827B76, 0x6C2C1E17, 0x703B2B26, 0x75362422, 0x7A342521, 0x7F342A20, 0x83362E22, 0x89393225, 0x8D3F3225, 0x9245372B, 0x964F392D, 0x9B583B32, 0xA0604236, 0xA5674635, 0xA86E4936, 0xAE77513D, 0xB27D5543, 0xB67C5141, 0xBA7C5044, 
        0xBE7F5349, 0xC281554A, 0xC6805447, 0xCA835649, 0xCE885B4D, 0xD18B5C4E, 0xD48B5D4C, 0xD88E5C52, 0xDB935D59, 0xDE94625B, 0xE195665D, 0xE492665B, 0xE6976C60, 0xE9996B5E, 0xEBA07266, 0xED9D6D5F, 0xEFA07163, 0xF1A07063, 0xF2A07165, 0xF4A17166, 
        0xF5A6786F, 0xF7A97C75, 0xF7A97C75, 0xF8A77A74, 0xF9A87C77, 0xFAAA7E7A, 0xFAAA7E7B, 0xFBAA7E7D, 0xFBAB8080, 0xFAAD8182, 0xFBAD8284, 0xFBAB8282, 0xFAAB837F, 0xFAAB847E, 0xF9AA837D, 0xF8A9827A, 0xF7AA847B, 0xF6AA867C, 0xF4AB857A, 0xF3A97E78, 
        0xF2A97A78, 0xF0A87976, 0xEEA67773, 0xECA77772, 0xEAA57670, 0xE7A5766F, 0xE5A3746A, 0xE29F726A, 0xDF9D706C, 0xDC9B6F69, 0xD99A6F66, 0xD6986E63, 0xD3976E63, 0xCF986E63, 0xCC926A5D, 0xC78F6357, 0xC48C5E51, 0xC08A5D4F, 0xBC89614C, 0xB88A614D, 
        0xB4875E4A, 0xB07D5443, 0xAB7A5141, 0xA6744F40, 0xA267483A, 0x9E5B3D31, 0x99513529, 0x94483024, 0x903F2A1F, 0x8B3A2820, 0x863A2B24, 0x813D2D29, 0x7D2E1E1C, 0x78726A65, 0x73A19F98, 0x6EA1A198, 0x699F9F96, 0x64A0A396, 0x60A1A197, 0x60A1A197,
  0x5FB3B3B3, 0x64B7B5B2, 0x69807974, 0x6D372C22, 0x7235231F, 0x77372622, 0x7B352721, 0x81332B21, 0x86372F24, 0x8A3A3124, 0x8F3E3127, 0x9446372B, 0x994F3830, 0x9E583D35, 0xA264453A, 0xA76A4A39, 0xAB724E3B, 0xB0775240, 0xB47D5443, 0xB97E5244, 0xBD7F5347, 
        0xC081554B, 0xC5845A4E, 0xC983584B, 0xCD835849, 0xD0875B4C, 0xD3885B4B, 0xD78B5E4D, 0xDA8D5C52, 0xDE905E57, 0xE092645C, 0xE394685C, 0xE693685D, 0xE9966A5E, 0xEB9B6D61, 0xED9D6C60, 0xEF9D6D60, 0xF1A07164, 0xF3A07165, 0xF5A27268, 0xF69F7067, 
        0xF8A4766E, 0xF9AA7C75, 0xFAA97B73, 0xFBA67B74, 0xFCA78079, 0xFCAA837D, 0xFDA9817B, 0xFDA87F7C, 0xFDAB8280, 0xFDAB8381, 0xFDAA8280, 0xFDA97F7E, 0xFDA87E79, 0xFCA87F7A, 0xFBA9817C, 0xFBA88179, 0xFAAA8279, 0xF8AA847A, 0xF7AC847A, 0xF6A97F79, 
        0xF4AB7F7C, 0xF2A87A76, 0xF0A87C76, 0xEEA57771, 0xECA57770, 0xEAA2746C, 0xE7A07168, 0xE59D7168, 0xE29B7069, 0xDF9B6F67, 0xDC9A6F65, 0xD9986D63, 0xD5956B5F, 0xD293695B, 0xCE91685B, 0xCB8F6457, 0xC68F6155, 0xC38D6253, 0xBF8B624E, 0xBB89614C, 
        0xB68A624E, 0xB2835B4A, 0xAE7C5444, 0xA9734F40, 0xA4694739, 0xA05D3C31, 0x9B4E3227, 0x97442B1F, 0x913B261C, 0x8D37251E, 0x88392B23, 0x833E2E28, 0x7E2E1E1A, 0x7A77706A, 0x75A4A49C, 0x709E9E95, 0x6B9FA195, 0x66A2A298, 0x61A2A297, 0x61A2A297,
  0x60B6B6B4, 0x65B0ADA8, 0x6A7A736E, 0x6F3B3029, 0x73372521, 0x79382323, 0x7E382822, 0x83362A22, 0x88362E21, 0x8C3A3124, 0x913F3126, 0x9647362A, 0x9B523931, 0xA05C3F39, 0xA467473E, 0xA96F4F40, 0xAD755342, 0xB2795241, 0xB67E5444, 0xBB7F5246, 0xBE81574C, 
        0xC3835B50, 0xC7855C50, 0xCB845A4C, 0xCF84584C, 0xD285594B, 0xD6875B4C, 0xD98B5F4E, 0xDD8D5E53, 0xE08E5E58, 0xE391645A, 0xE691675B, 0xE8956A5F, 0xEB96695D, 0xED9C6F62, 0xF09C6C5F, 0xF19E6D61, 0xF4A17166, 0xF5A27269, 0xF7A17169, 0xF9A2736A, 
        0xFAA77971, 0xFBA77A73, 0xFCA97B75, 0xFDA87E78, 0xFEA7817A, 0xFFA9837C, 0xFFA7827B, 0xFFA7817A, 0xFFAB8580, 0xFFAB8580, 0xFFA9827D, 0xFFAA807D, 0xFFAA7E7A, 0xFEAA7E79, 0xFEAB827E, 0xFDAB827C, 0xFCAB857C, 0xFBAB877D, 0xF9AB847A, 0xF8A87F79, 
        0xF6A97E7B, 0xF5A87C77, 0xF3A67A75, 0xF1A37771, 0xEEA37670, 0xEC9F7269, 0xEA9D7167, 0xE79E7268, 0xE49B7068, 0xE1996D65, 0xDE976C62, 0xDB976E63, 0xD8976B60, 0xD393695C, 0xD1936B5B, 0xCC93695C, 0xC9926459, 0xC593685A, 0xC18F6854, 0xBD88614C, 
        0xB9875F4B, 0xB3845C4B, 0xB07A5343, 0xAB744E40, 0xA76A473B, 0xA25F3E35, 0x9D523328, 0x9844291F, 0x943A251B, 0x8F35271E, 0x8A372C22, 0x853B2B26, 0x802B1B17, 0x7B6F6763, 0x76A8A69F, 0x71A2A299, 0x6CA0A297, 0x68A1A197, 0x63A1A497, 0x63A1A497,
  0x62B0B0B0, 0x66B1B1AF, 0x6B8A8582, 0x714E4841, 0x7534221E, 0x7A3A2323, 0x7F3A2A24, 0x84372A22, 0x89372C21, 0x8E3B2E23, 0x93413227, 0x98473329, 0x9C4F352F, 0xA15E403D, 0xA666473E, 0xAB6E4D40, 0xAF765442, 0xB47A5443, 0xB87E5547, 0xBD805449, 0xC081574C, 
        0xC5815A4F, 0xC8815A4D, 0xCD855D4F, 0xD1875D50, 0xD4865B4C, 0xD8875C4D, 0xDC8A604F, 0xDF8C5F54, 0xE28F6159, 0xE58F655B, 0xE88F685B, 0xEB92695C, 0xED966C5F, 0xEF9C6F62, 0xF29F6E62, 0xF49F6F64, 0xF6A17169, 0xF8A17168, 0xF9A17169, 0xFBA2746C, 
        0xFCA77973, 0xFDA67773, 0xFEAA7C78, 0xFFAA7F7B, 0xFFA7817A, 0xFFA7817A, 0xFFA9837C, 0xFFA78179, 0xFFA9837A, 0xFFA88279, 0xFFA78178, 0xFFAA7F7B, 0xFFAC7C7A, 0xFFAC7F7B, 0xFFAD827D, 0xFEAB817B, 0xFEAB847C, 0xFDAD887F, 0xFBAC887E, 0xFAAB827C, 
        0xF8A77C78, 0xF7A77D78, 0xF5A67B76, 0xF3A47973, 0xF1A2776F, 0xEE9E7268, 0xECA0756A, 0xE99F7369, 0xE69D7168, 0xE39A6D64, 0xE0976A60, 0xDD976D61, 0xDA966B5F, 0xD6946C5C, 0xD2926958, 0xCF93695C, 0xCA94685D, 0xC7916658, 0xC3906654, 0xBF8E6651, 
        0xBB89614E, 0xB6855D4D, 0xB27D5546, 0xAD775043, 0xA96D483D, 0xA3633F36, 0x9F54362B, 0x9A462C21, 0x9639271C, 0x9132261C, 0x8C362D24, 0x87382B25, 0x822D1F1B, 0x7D7A746E, 0x78A5A39C, 0x73A1A198, 0x6E9FA196, 0x699FA298, 0x64A3A399, 0x64A3A399,
  0x63AEAEAE, 0x68B0ADAD, 0x6DA7A3A3, 0x72504747, 0x77372424, 0x7C3D2624, 0x813B2723, 0x86392922, 0x8B382B22, 0x903D2F25, 0x95443329, 0x9A48342A, 0x9E503630, 0xA3624441, 0xA8694942, 0xAD6C4C40, 0xB1785646, 0xB67E5647, 0xBA80574B, 0xBF82564D, 0xC380584E, 
        0xC780594E, 0xCB805A4D, 0xCF865E51, 0xD2886052, 0xD7855D4C, 0xD9875D4D, 0xDE885E4D, 0xE18C6154, 0xE48F655C, 0xE791685D, 0xEA916A5D, 0xED90675A, 0xEF966D60, 0xF29D6F63, 0xF49E6C60, 0xF6A27168, 0xF8A3746C, 0xFAA3746C, 0xFBA2736C, 0xFDA4756E, 
        0xFEA77873, 0xFFAB7C79, 0xFFAB7C79, 0xFFAB7F7C, 0xFFA9807C, 0xFFA9817B, 0xFFAC847E, 0xFFA98179, 0xFFA67D73, 0xFFA67E73, 0xFFA67F73, 0xFFA97C77, 0xFFAC7A79, 0xFFAB7A76, 0xFFAD807B, 0xFFAE857F, 0xFFAD857D, 0xFFAC857C, 0xFDA78176, 0xFCA8817A, 
        0xFAA97F7B, 0xF9A77E77, 0xF7A87F79, 0xF5A77D76, 0xF3A57B72, 0xF0A37970, 0xEEA2796E, 0xEB9F756A, 0xE99E736A, 0xE69B6F65, 0xE2996E63, 0xDF986E60, 0xDC966C5D, 0xD8946A59, 0xD5916956, 0xD1936A5A, 0xCD966B5F, 0xC9906658, 0xC58F6553, 0xC18F6853, 
        0xBD8A634F, 0xB8855F4D, 0xB47E5849, 0xAF7B5448, 0xAA734C42, 0xA6634035, 0xA155352C, 0x9C462D22, 0x9739261C, 0x9232261D, 0x8D342D24, 0x883B3029, 0x84261915, 0x7F7E7872, 0x79A3A199, 0x74A4A49B, 0x6FA0A297, 0x6AA0A397, 0x66A2A598, 0x66A2A598,
  0x64B2B2B5, 0x69B0B0B3, 0x6EAFADAF, 0x73564F53, 0x783B2A2A, 0x7E402826, 0x823A2723, 0x87382921, 0x8C3C2D24, 0x913D2D23, 0x96443127, 0x9B4D372D, 0xA0573E39, 0xA5624543, 0xAA6F4F48, 0xAE735347, 0xB3755344, 0xB77D5646, 0xBC80564A, 0xC081554D, 0xC582594E, 
        0xC9805A4F, 0xCD805A4E, 0xD1835D4F, 0xD5876153, 0xD88A6152, 0xDC8A6252, 0xE08E6555, 0xE38E6457, 0xE68D645B, 0xE98E685D, 0xEB916A5D, 0xEE936C5F, 0xF1966C5E, 0xF39A6D60, 0xF69D6B5E, 0xF8A16F66, 0xFAA3736B, 0xFBA1726B, 0xFDA5766F, 0xFFA57670, 
        0xFFA67572, 0xFFAC7D7A, 0xFFA97A78, 0xFFAB7E7C, 0xFFAA807D, 0xFFA87D79, 0xFFAB817B, 0xFFAC827B, 0xFFA77D74, 0xFFA77E72, 0xFFA87F73, 0xFFA87973, 0xFFAC7978, 0xFFAA7875, 0xFFAC7E7A, 0xFFAF847F, 0xFFAD847C, 0xFFAD877E, 0xFFAD897E, 0xFEAC867F, 
        0xFCAA807D, 0xFBA8807A, 0xF9AA817B, 0xF7A98079, 0xF4A67D74, 0xF2A47A70, 0xF0A37A6F, 0xEDA1776D, 0xEA9D7269, 0xE79E7368, 0xE49C7367, 0xE19A7264, 0xDE976E5D, 0xDA936B58, 0xD7936C58, 0xD2946B5B, 0xCF96695E, 0xCB936A5C, 0xC7916A57, 0xC38C6550, 
        0xBE8B6450, 0xBA876150, 0xB5805B4B, 0xB180574A, 0xAC764F45, 0xA7674239, 0xA254352B, 0x9D442B20, 0x9938271C, 0x9431251D, 0x8F332E23, 0x89352A23, 0x85261615, 0x809B9591, 0x7BA7A59F, 0x769FA299, 0x70A1A398, 0x6CA0A299, 0x67A3A599, 0x67A3A599,
  0x65B0B0B2, 0x6BADADB0, 0x70A5A1A3, 0x756E6868, 0x793A2A2A, 0x7F3E2A28, 0x843B2824, 0x893F2A25, 0x8E3C2A23, 0x933C2B20, 0x98413224, 0x9D4A3B2D, 0xA15A4238, 0xA6684640, 0xAB725047, 0xB0765348, 0xB4775345, 0xB97B5447, 0xBE805549, 0xC281564A, 0xC681584E, 
        0xCB7F5A4C, 0xCF825C4D, 0xD3825E4C, 0xD7825C4A, 0xD9835B47, 0xDE865F4B, 0xE189644D, 0xE488604F, 0xE88B6358, 0xEB8E6559, 0xED90665A, 0xF0946A5E, 0xF3956C5F, 0xF5976B5C, 0xF79C6E60, 0xF99B6B61, 0xFB9D6F67, 0xFD9E6F69, 0xFFA1736C, 0xFFA47570, 
        0xFFA3736F, 0xFFA87774, 0xFFA77774, 0xFFAA7B7A, 0xFFAB7E7E, 0xFFA87B7A, 0xFFAC807C, 0xFFAC807B, 0xFFAC8079, 0xFFAC8077, 0xFFAA7E73, 0xFFA67570, 0xFFA97776, 0xFFAC7B79, 0xFFAC7D7A, 0xFFAC807A, 0xFFAE857E, 0xFFAD867D, 0xFFAB8579, 0xFFAB837B, 
        0xFEAB817D, 0xFCAA817C, 0xFAAA827C, 0xF8A8817A, 0xF6A37B73, 0xF49E766D, 0xF1A07970, 0xEFA17971, 0xEC9C716A, 0xE99E736B, 0xE69F756C, 0xE29C7469, 0xE0986F63, 0xDC956C5D, 0xD8956D5E, 0xD5956C5E, 0xD1976A5B, 0xCD966A5A, 0xC8936957, 0xC38D6450, 
        0xC08B6350, 0xBC896252, 0xB7845D4C, 0xB27F574A, 0xAD775045, 0xA869453A, 0xA455342B, 0x9F442B20, 0x9A3B291C, 0x9535291D, 0x90362E23, 0x8B352A22, 0x86261813, 0x81A19B95, 0x7CA8A49D, 0x77A2A097, 0x72A2A297, 0x6DA3A397, 0x67A5A599, 0x67A5A599,
  0x67ACACAC, 0x6CACACAC, 0x70ACAAA7, 0x767F7874, 0x7B392D2B, 0x803B2B29, 0x853B2A24, 0x8A422C26, 0x8F412A21, 0x94412C20, 0x99453627, 0x9E4B4330, 0xA35D4636, 0xA8714B40, 0xAC764F47, 0xB27A5448, 0xB67E554A, 0xBB7E5449, 0xBF81564A, 0xC382574A, 0xC8815749, 
        0xCC7F5747, 0xD0815B4A, 0xD4815C4A, 0xD87E5743, 0xDC7C5640, 0xE07E5842, 0xE3835E46, 0xE687604E, 0xE98C6458, 0xEC8D6357, 0xEF8C6056, 0xF28F6459, 0xF4976F62, 0xF7966D5F, 0xF99A7163, 0xFB986D61, 0xFD9A6E68, 0xFF9F746D, 0xFFA27671, 0xFFA67974, 
        0xFFA47671, 0xFFA77773, 0xFFA97975, 0xFFA87978, 0xFFA97A7C, 0xFFA77879, 0xFFAB7E7D, 0xFFAA7E7A, 0xFFAE837E, 0xFFAE837B, 0xFFAB7F76, 0xFFA97A75, 0xFFAB7A7A, 0xFFAC7D7B, 0xFFAD807C, 0xFFAD817B, 0xFFAD847C, 0xFFAA8076, 0xFFAA8176, 0xFFAB8279, 
        0xFFAC817C, 0xFEA87E78, 0xFCA67D77, 0xFAA67E77, 0xF8A27C75, 0xF5A07B73, 0xF39D7870, 0xF19E7772, 0xED9D736F, 0xEA9C726E, 0xE89E7570, 0xE59B716A, 0xE1986E65, 0xDE986F64, 0xDA996E63, 0xD6996D60, 0xD2996C5E, 0xCD986B5D, 0xCA936758, 0xC6906555, 
        0xC18D6351, 0xBD875D4D, 0xB8845B4B, 0xB480574A, 0xAF785247, 0xAA6F4C40, 0xA5593A2F, 0xA1452C1F, 0x9B3B291A, 0x97352A1C, 0x91362D21, 0x8D32291E, 0x88251814, 0x83A29D99, 0x7DA9A59F, 0x78A5A19A, 0x73A7A39A, 0x6EA6A498, 0x69A4A498, 0x69A4A498,
  0x68ABABAB, 0x6CAEAEAC, 0x72B0B0AB, 0x7784807E, 0x7C39312D, 0x813B2F2B, 0x863A2924, 0x8B402B24, 0x90412A21, 0x95422C20, 0x9A483427, 0x9F534431, 0xA4664B3E, 0xA9754F45, 0xAE795349, 0xB37B5549, 0xB77E564B, 0xBB7E554A, 0xC0805549, 0xC5815649, 0xC97E5549, 
        0xCD7E564A, 0xD2805A4C, 0xD67F5849, 0xD97C5545, 0xDD7F5948, 0xE17E5A47, 0xE3805B47, 0xE8845E51, 0xEA845C56, 0xEE835952, 0xF181564F, 0xF3825850, 0xF6886056, 0xF88E685C, 0xFA916C5F, 0xFC966E63, 0xFE956962, 0xFF9B7069, 0xFFA37972, 0xFFA27770, 
        0xFFA1756F, 0xFFA57873, 0xFFA67873, 0xFFA47675, 0xFFA6787A, 0xFFA6797A, 0xFFA77B7A, 0xFFA97E7A, 0xFFAB8079, 0xFFAA7F76, 0xFFA77C72, 0xFFA87A74, 0xFFA87876, 0xFFA77875, 0xFFA97B77, 0xFFAA7E78, 0xFFAB8179, 0xFFA77D73, 0xFFA98277, 0xFFAA7F78, 
        0xFFAB7F7A, 0xFFA97E79, 0xFDA77C77, 0xFBA47C76, 0xF9A27C74, 0xF79E7971, 0xF49E7970, 0xF29C756F, 0xEF9A716E, 0xEC9E7672, 0xE99C746F, 0xE6987069, 0xE2946A62, 0xDF90665C, 0xDB946A5F, 0xD7976C5F, 0xD4986E60, 0xCF996E61, 0xCB93695A, 0xC78F6555, 
        0xC3896151, 0xBE875F4F, 0xBA825949, 0xB57C5446, 0xB1785348, 0xAC735145, 0xA65B3D32, 0xA2452B1F, 0x9D382619, 0x9835291A, 0x93352C20, 0x8E2C2219, 0x89443934, 0x84ABA5A2, 0x7EA5A19B, 0x79A8A39B, 0x74A6A299, 0x6FA2A097, 0x6AA3A097, 0x6AA3A097,
  0x69A9A9A6, 0x6EAAADA8, 0x72ADADA9, 0x78989892, 0x7D47433D, 0x823A312B, 0x873C2D25, 0x8C3D2D24, 0x913F2A1F, 0x96442C20, 0x9C4C3527, 0xA15B4535, 0xA56E5145, 0xAA7B544B, 0xAF7B544C, 0xB47C544A, 0xB87D554A, 0xBD7C5549, 0xC27D5548, 0xC67D5446, 0xCA7A5046, 
        0xCF785148, 0xD3785148, 0xD67A5549, 0xDB7F5B50, 0xDF7F5B4E, 0xE27B5748, 0xE57A5545, 0xE9775047, 0xEC764D4B, 0xEF734A47, 0xF2744B48, 0xF4764F49, 0xF778514A, 0xF97E5A52, 0xFC805C53, 0xFE88635A, 0xFF875D55, 0xFF8A5F57, 0xFF936A62, 0xFF976D67, 
        0xFF976C66, 0xFF9C706B, 0xFFA07470, 0xFFA17473, 0xFFA37677, 0xFFA77B7B, 0xFFA47877, 0xFFA97E7A, 0xFFA87E77, 0xFFA67C72, 0xFFA57B70, 0xFFA67A72, 0xFFA87A76, 0xFFA87C77, 0xFFA87D77, 0xFFA87F77, 0xFFA98178, 0xFFA88076, 0xFFAA8379, 0xFFA97E78, 
        0xFFAB7F7C, 0xFFA97E7B, 0xFFA57B77, 0xFDA27A74, 0xFB9D7771, 0xF899736C, 0xF699766F, 0xF396716C, 0xF0946E6A, 0xEE946E69, 0xEB916C66, 0xE7916A64, 0xE4896158, 0xE0845A4F, 0xDD865F53, 0xD98F665C, 0xD5956E63, 0xD0987065, 0xCD966E61, 0xC88F685B, 
        0xC38B6254, 0xC0896151, 0xBB835B4C, 0xB67E5547, 0xB17A5448, 0xAD745346, 0xA85D3F34, 0xA3472E22, 0x9E3B291C, 0x99382B1D, 0x94383022, 0x8F251C13, 0x896D6460, 0x85ABA8A4, 0x80A59F99, 0x7AA7A59C, 0x75A7A49C, 0x70A5A59C, 0x6BA6A69A, 0x6BA6A69A,
  0x69A9A9A6, 0x6FA7A9A2, 0x73ACACA7, 0x78AFAFA9, 0x7E524E46, 0x833C3028, 0x883D3025, 0x8D3D2D22, 0x92422E22, 0x98493224, 0x9D513728, 0xA2614638, 0xA7755347, 0xAB7D544D, 0xB07E564F, 0xB57F564D, 0xBA7F574B, 0xBE7C5448, 0xC3785144, 0xC7795342, 0xCC744D42, 
        0xD06F4741, 0xD4724B44, 0xD8745046, 0xDC775249, 0xE0724C41, 0xE36C473A, 0xE7704A3D, 0xEA6E4640, 0xED6C4243, 0xF06C4344, 0xF36C4544, 0xF66B4541, 0xF864403B, 0xFB624039, 0xFD62423A, 0xFF6A453D, 0xFF6F453C, 0xFF71463D, 0xFF7A5048, 0xFF855B54, 
        0xFF835952, 0xFF875C56, 0xFF916660, 0xFF9A6F6D, 0xFFA07474, 0xFFA57B7A, 0xFF9F7371, 0xFFA37974, 0xFFA27870, 0xFFA0766B, 0xFFA0776B, 0xFF9F746A, 0xFFA57973, 0xFFA77D76, 0xFFA67D74, 0xFFA77F76, 0xFFA57E75, 0xFFA57E76, 0xFFA68077, 0xFFA77F79, 
        0xFFA8807C, 0xFFA17874, 0xFF996F6B, 0xFE956D67, 0xFC906A63, 0xF989645C, 0xF7815D55, 0xF4835D57, 0xF2825B57, 0xEF79514D, 0xEB7E5752, 0xE9835D56, 0xE57E564D, 0xE17B5449, 0xDE7D574C, 0xDA845C53, 0xD68C635B, 0xD28E685F, 0xCE8F695E, 0xC98E685D, 
        0xC58A6356, 0xC1855D4F, 0xBC845B4C, 0xB781584C, 0xB27C574B, 0xAE745447, 0xA8604236, 0xA44A3125, 0x9F3C2B1C, 0x9A392E21, 0x953A3123, 0x90231C11, 0x8A75706C, 0x85A9A6A2, 0x81A5A39D, 0x7BA5A39D, 0x76A6A49D, 0x71A4A49D, 0x6CA5A59B, 0x6CA5A59B,
  0x6AAAAAA5, 0x6FABAEA9, 0x74B1B1AD, 0x7ABAB5B3, 0x7F746A64, 0x844D3F37, 0x893D3027, 0x8E403025, 0x93412E20, 0x98493524, 0x9D4D3323, 0xA2624836, 0xA7765347, 0xAC7D524B, 0xB17E544D, 0xB67F564E, 0xBB7D5549, 0xBF7B5549, 0xC47C5748, 0xC8765140, 0xCC70493E, 
        0xD16B453E, 0xD56B463D, 0xD969433A, 0xDD623C32, 0xE15E392C, 0xE45F3A2C, 0xE7684435, 0xEB6A453E, 0xEE683E41, 0xF164393C, 0xF45E3637, 0xF7593432, 0xF955312D, 0xFB502E27, 0xFD52332B, 0xFF543128, 0xFF5B342B, 0xFF60382F, 0xFF6A423B, 0xFF785149, 
        0xFF785049, 0xFF7B534C, 0xFF835B55, 0xFF946B69, 0xFF996E6D, 0xFFA17977, 0xFF9D7471, 0xFF9F7670, 0xFF9C736A, 0xFF997064, 0xFF9D7569, 0xFF9A7064, 0xFF9F746A, 0xFF9F756B, 0xFF9F766C, 0xFFA0796F, 0xFF9F7870, 0xFF9F7A72, 0xFF936B62, 0xFF916861, 
        0xFF885E59, 0xFF835953, 0xFF815852, 0xFF78514A, 0xFD714C44, 0xFB6A473D, 0xF86A483E, 0xF5704A44, 0xF2704844, 0xF06C433E, 0xED704943, 0xEA7B554E, 0xE67A534B, 0xE3734C42, 0xDF754F44, 0xDB79544B, 0xD77D5650, 0xD3815C56, 0xCF876259, 0xCA8A645A, 
        0xC6876255, 0xC2845E4F, 0xBD815B4C, 0xB880594B, 0xB47E5A4D, 0xAF78574B, 0xAA64463C, 0xA5503529, 0xA0423122, 0x9B3C2F24, 0x96393123, 0x91262116, 0x8C7F7976, 0x86ABA9A5, 0x81A39F9B, 0x7CA4A19D, 0x76A6A69F, 0x72A2A59C, 0x6DA3A39C, 0x6DA3A39C,
  0x6AACACA8, 0x70AAA7A3, 0x75AFABA4, 0x7A8C817B, 0x7F62504A, 0x844F3732, 0x8A45332A, 0x8F453527, 0x94413020, 0x99473522, 0x9E4A311E, 0xA3634A38, 0xA8785649, 0xAD7F534C, 0xB280554E, 0xB77F574D, 0xBB7E574C, 0xC07A5448, 0xC5795345, 0xC9714B3B, 0xCD6B463A, 
        0xD268443B, 0xD6664339, 0xDA634235, 0xDE624031, 0xE1634231, 0xE5664433, 0xE9684737, 0xEC6D463F, 0xEF683C3E, 0xF2613537, 0xF55B3130, 0xF857312E, 0xFA55302A, 0xFD502F27, 0xFF513228, 0xFF523128, 0xFF57352B, 0xFF5A382F, 0xFF644039, 0xFF6E4A43, 
        0xFF6F4A43, 0xFF78534C, 0xFF7B5550, 0xFF89615E, 0xFF8B5F5D, 0xFF956D6A, 0xFF9B7470, 0xFF9B746D, 0xFF956E63, 0xFF8F6659, 0xFF977062, 0xFF997264, 0xFF966D60, 0xFF956C5F, 0xFF976F63, 0xFF997268, 0xFF9A746C, 0xFF946E65, 0xFF7F554C, 0xFF6F453D, 
        0xFF663E38, 0xFF68413A, 0xFF654139, 0xFF5A382E, 0xFE58392F, 0xFB58392E, 0xF95B4035, 0xF7614038, 0xF4643F3A, 0xF0643E39, 0xEE664039, 0xEA68443C, 0xE76C483F, 0xE36E4B3F, 0xE06B463B, 0xDB704B44, 0xD8724D4B, 0xD476524E, 0xCF7D5852, 0xCB7F5B52, 
        0xC7825C51, 0xC2835B4E, 0xBD80594B, 0xB97F594C, 0xB47E584D, 0xAF7B594E, 0xAB664A3E, 0xA54E3528, 0xA0412F21, 0x9C3D3223, 0x963B3427, 0x912B241C, 0x8C888483, 0x87A9A7A3, 0x82A6A4A0, 0x7DA5A39F, 0x77A4A4A0, 0x72A5A59E, 0x6DA5A59E, 0x6DA5A59E,
  0x6BA8A6A1, 0x70B1AEAA, 0x7580756E, 0x7B402D27, 0x80492F29, 0x85482B26, 0x8A493128, 0x8F453325, 0x94433322, 0x99473622, 0x9F4B3621, 0xA366513C, 0xA97C5A4C, 0xAE81564E, 0xB381564F, 0xB781574D, 0xBC7E574B, 0xC1785145, 0xC570493A, 0xC96B4534, 0xCE664232, 
        0xD2624132, 0xD6634233, 0xDA664635, 0xDE6B4C3A, 0xE271543F, 0xE5745642, 0xE9735641, 0xEC7B564D, 0xF07A4E50, 0xF3754A49, 0xF6744C4A, 0xF86F4945, 0xFB67443D, 0xFD614239, 0xFF5E4036, 0xFF5C3F34, 0xFF5C3E34, 0xFF5C3E34, 0xFF634239, 0xFF69483F, 
        0xFF6D4B43, 0xFF7C5A53, 0xFF7D5A54, 0xFF835D59, 0xFF875B59, 0xFF916865, 0xFF99736F, 0xFF9A756D, 0xFF926A5F, 0xFF875D4F, 0xFF946E5F, 0xFF9C7769, 0xFF976F61, 0xFF966E61, 0xFF987165, 0xFF977166, 0xFF967067, 0xFF896259, 0xFF7D544D, 0xFF6C453D, 
        0xFF64423A, 0xFF5F3F36, 0xFF58392F, 0xFF55392E, 0xFE553C30, 0xFC543C2F, 0xFA543E30, 0xF7583A32, 0xF45F3C36, 0xF1613D37, 0xEE634039, 0xEB634039, 0xE867453D, 0xE469483E, 0xE069473B, 0xDC6E4B46, 0xD86E4B4A, 0xD474504E, 0xD078524F, 0xCC79524B, 
        0xC77D574C, 0xC37C5548, 0xBE7F5849, 0xB9805A4E, 0xB57B564A, 0xB07A5A4D, 0xAB684A40, 0xA64E3529, 0xA1453424, 0x9C3F3225, 0x973A3224, 0x923C352E, 0x8DA09C9A, 0x88A8A4A2, 0x82A4A4A0, 0x7DA3A39F, 0x78A3A59F, 0x73A5A59F, 0x6EA6A69F, 0x6EA6A69F,
  0x6BADADA6, 0x71A8A69B, 0x76655649, 0x7B6B544A, 0x8067473F, 0x85542F28, 0x8B4C2F24, 0x90462F23, 0x95493627, 0x9A483424, 0x9F4C3928, 0xA4675244, 0xA97B5B52, 0xAE805751, 0xB37F5650, 0xB87E564E, 0xBC7C564C, 0xC1785145, 0xC570483C, 0xCA694233, 0xCE664336, 
        0xD366483A, 0xD7674A3C, 0xDB6D4D3F, 0xDF735343, 0xE37B5949, 0xE67D5C4B, 0xEA80604E, 0xED8A6259, 0xF08E6160, 0xF4865D59, 0xF6835D58, 0xF985625C, 0xFC816158, 0xFE7A5A50, 0xFF75544A, 0xFF714E46, 0xFF6C4741, 0xFF66433B, 0xFF68463D, 0xFF6A4A40, 
        0xFF6D4C42, 0xFF7D5B52, 0xFF815E55, 0xFF845B56, 0xFF8C5E5D, 0xFF956A67, 0xFF9C7470, 0xFF9E7770, 0xFF946C62, 0xFF895F53, 0xFF956E62, 0xFF9F796D, 0xFF9D7369, 0xFF9B7268, 0xFF9B726A, 0xFF99726A, 0xFF926C64, 0xFF88625B, 0xFF835D57, 0xFF79534C, 
        0xFF6E4942, 0xFF68433C, 0xFF643F37, 0xFF67443A, 0xFF66463B, 0xFC5F4035, 0xFA64473C, 0xF86D4D44, 0xF5745049, 0xF278564D, 0xEF795950, 0xEC78574E, 0xE873534A, 0xE4715147, 0xE1735347, 0xDD705045, 0xD96C4840, 0xD5724D46, 0xD1755049, 0xCC765247, 
        0xC8765347, 0xC3785748, 0xBF7D5B4B, 0xBA835E52, 0xB57B5548, 0xB07B594A, 0xAC6C4B41, 0xA74D2F24, 0xA2492F25, 0x9D45332A, 0x9744372D, 0x92615550, 0x8DACA5A3, 0x88ACA8A4, 0x83AAA6A1, 0x7EA7A39D, 0x78A7A59F, 0x73A7A59C, 0x6EA6A69D, 0x6EA6A69D,
  0x6CAEAEA2, 0x71A2998D, 0x76634F3E, 0x7B674A39, 0x816E4C3F, 0x86603A31, 0x8B523124, 0x904D3125, 0x954B3327, 0x9A483327, 0x9F50392E, 0xA46A554B, 0xAA7B5B57, 0xAE7D5751, 0xB37C564F, 0xB87C5550, 0xBD7B554D, 0xC1795349, 0xC6744E43, 0xCA71493C, 0xCF6C483F, 
        0xD3684A42, 0xD76A4C43, 0xDB705046, 0xDF76544A, 0xE3805E52, 0xE7805C50, 0xEA815C4E, 0xEE8E655D, 0xF1916362, 0xF4926C69, 0xF78E6A64, 0xF991726B, 0xFC8C6D65, 0xFE8E6F67, 0xFF7E5851, 0xFF7E5451, 0xFF7A4F4C, 0xFF734B47, 0xFF6C4841, 0xFF68473D, 
        0xFF6A483D, 0xFF765148, 0xFF815B52, 0xFF855A54, 0xFF8B5D5A, 0xFF936762, 0xFF9B716C, 0xFFA27B76, 0xFFA07972, 0xFF997067, 0xFF9B7469, 0xFFA57D75, 0xFFA67A75, 0xFFA1756F, 0xFF9D736D, 0xFF99716B, 0xFF8D6560, 0xFF89635E, 0xFF84605A, 0xFF7C544F, 
        0xFF774D49, 0xFF794E4A, 0xFF774D48, 0xFF79514A, 0xFF7C574E, 0xFD815E55, 0xFB86665C, 0xF88C6B63, 0xF58F6963, 0xF28F6B65, 0xEF906C65, 0xEC906D66, 0xE88C6A63, 0xE589685F, 0xE1846258, 0xDD7B584B, 0xD9754F42, 0xD5714C3D, 0xD1714F40, 0xCD725142, 
        0xC86F503F, 0xC4735746, 0xBF775A4A, 0xBA805F50, 0xB67F594B, 0xB17D594C, 0xAC704E42, 0xA74F2C22, 0xA250302A, 0x9D4C352D, 0x9847322D, 0x9373605D, 0x8E90807B, 0x88978A82, 0x83ACA19B, 0x7EABA19B, 0x79AAA39B, 0x74A8A299, 0x6EA8A69A, 0x6EA8A69A,
  0x6CB1ACA5, 0x719D9289, 0x76674D40, 0x7B593527, 0x8160372D, 0x86734A42, 0x8B542F22, 0x90533528, 0x954B3327, 0x9B493427, 0xA04F392C, 0xA56D574D, 0xAA7E6058, 0xAF7E5954, 0xB37E5852, 0xB87E5852, 0xBD7B544C, 0xC2785148, 0xC6785045, 0xCB754D42, 0xCF6F493F, 
        0xD36E4A43, 0xD7724F47, 0xDC77564E, 0xDF75544B, 0xE3765549, 0xE77F5E52, 0xEA7B5B4C, 0xEE7D544E, 0xF1885C5F, 0xF4845D5E, 0xF77A5756, 0xFA5C3936, 0xFC5E3D3A, 0xFE684743, 0xFF65403E, 0xFF693F3D, 0xFF6F4542, 0xFF744E49, 0xFF6F4C45, 0xFF68453D, 
        0xFF654239, 0xFF694239, 0xFF734B42, 0xFF7D544D, 0xFF875D57, 0xFF906760, 0xFF99726B, 0xFFA27B74, 0xFFA57D75, 0xFFA27870, 0xFFA2786F, 0xFFA87E77, 0xFFA97E79, 0xFFA57B75, 0xFFA07872, 0xFF9A746E, 0xFF8E6862, 0xFF87625D, 0xFF835F5A, 0xFF805954, 
        0xFF815955, 0xFF835B56, 0xFF855F5A, 0xFF83605A, 0xFF8C6D65, 0xFD937870, 0xFB927870, 0xF8957571, 0xF59A7272, 0xF3977070, 0xEF956C6B, 0xEC926866, 0xE9906763, 0xE5936A65, 0xE1916762, 0xDE845D54, 0xD9785447, 0xD5755043, 0xD17B594B, 0xCD7A5B4C, 
        0xC9715142, 0xC4735546, 0xBF755747, 0xBB7D5D4E, 0xB67F5C4E, 0xB17B5C4D, 0xAC6C4C41, 0xA74C2D22, 0xA2462B22, 0x9D4F3830, 0x98423028, 0x934D332C, 0x8E50302A, 0x88573932, 0x838D7872, 0x7EADA19D, 0x79ACA39B, 0x74AAA49B, 0x6EA8A69A, 0x6EA8A69A,
  0x6CB5B1A9, 0x71998980, 0x765F4036, 0x7B61372D, 0x816A3B33, 0x867B4F48, 0x8B603A2F, 0x90533125, 0x9552382A, 0x9B4D3629, 0x9F50382B, 0xA56D564D, 0xAA7F615A, 0xAF815C57, 0xB4805A54, 0xB8815B54, 0xBD7D584F, 0xC27B5349, 0xC6785145, 0xCB754E41, 0xCF724B3F, 
        0xD3744B46, 0xD879514C, 0xDC754F49, 0xE06F4B43, 0xE367453B, 0xE7553528, 0xEB472718, 0xEE401A15, 0xF13D1519, 0xF4321012, 0xF7250808, 0xFA503737, 0xFC1E0706, 0xFF341B1A, 0xFF4F3635, 0xFF543130, 0xFF59302D, 0xFF603A35, 0xFF67433C, 0xFF6A463F, 
        0xFF6A463F, 0xFF663F37, 0xFF694037, 0xFF734A42, 0xFF7F574F, 0xFF8B645C, 0xFF977169, 0xFFA27B73, 0xFFA77F76, 0xFFA77C74, 0xFFA97D75, 0xFFAB7F79, 0xFFA87D78, 0xFFA57C75, 0xFF9F7771, 0xFF9A746E, 0xFF8F6A64, 0xFF84605B, 0xFF825F59, 0xFF815C57, 
        0xFF845D59, 0xFF815B57, 0xFF825F5A, 0xFF785751, 0xFF745750, 0xFD715951, 0xFB755E56, 0xF8816260, 0xF68C6469, 0xF3936F71, 0xEF987273, 0xEC966D6D, 0xE9936967, 0xE5956C6A, 0xE1916663, 0xDE865F57, 0xDA7D5A4D, 0xD5785447, 0xD17A594A, 0xCD7E5F50, 
        0xC97A5D4E, 0xC47E6253, 0xBF7A5D4D, 0xBB7E5F51, 0xB6826356, 0xB17E6154, 0xAC6C5144, 0xA74C3326, 0xA2432D20, 0x9D4C372B, 0x974B352D, 0x9263423C, 0x8D855D5A, 0x89825D59, 0x8372514D, 0x7EA99791, 0x79AEA39D, 0x74A8A29B, 0x6FA7A49B, 0x6FA7A49B,
  0x6CB8B1AC, 0x71968780, 0x7667453C, 0x7C64372F, 0x81724139, 0x857F5248, 0x8B6D4338, 0x905C362A, 0x95533629, 0x9B53392C, 0xA0543A2E, 0xA471594F, 0xAA7E6057, 0xAF815B54, 0xB47E5A51, 0xB8805950, 0xBD815C51, 0xC27F5A4D, 0xC6785142, 0xCB76513F, 0xCF784D44, 
        0xD3764B46, 0xD8734A45, 0xDC684039, 0xE05E3830, 0xE34F2F24, 0xE7432519, 0xEB402417, 0xEE48302A, 0xF12B1317, 0xF4342223, 0xF7322726, 0xFAA4A09F, 0xFC3D3633, 0xFE27201D, 0xFF463E3C, 0xFF6B5654, 0xFF5F3D3A, 0xFF63403C, 0xFF603B36, 0xFF5E3832, 
        0xFF643D37, 0xFF623933, 0xFF653C35, 0xFF6C433A, 0xFF764E44, 0xFF845E53, 0xFF956F65, 0xFFA27B72, 0xFFA67D74, 0xFFA57B71, 0xFFA87C73, 0xFFAB7F78, 0xFFA9807A, 0xFFA47B74, 0xFF9B736D, 0xFF936D67, 0xFF89645E, 0xFF825F59, 0xFF7F5D57, 0xFF7C5752, 
        0xFF744B47, 0xFF68403B, 0xFF5F3B36, 0xFF5A3C36, 0xFF412822, 0xFD321D17, 0xFB1E0D07, 0xF82C1513, 0xF62F0F13, 0xF34A2B2D, 0xF05F3F40, 0xEC70514F, 0xE9805F5D, 0xE58B6A67, 0xE18E6B66, 0xDE86645B, 0xD97F5C4F, 0xD57E5A4D, 0xD1826255, 0xCD836558, 
        0xC9806355, 0xC4836858, 0xBF7F6355, 0xBB7F6152, 0xB6826255, 0xB17D6156, 0xAC694F44, 0xA7483224, 0xA2463325, 0x9D4A3328, 0x98604941, 0x9383605B, 0x8E8D5D5B, 0x89855755, 0x837E5751, 0x7EA9938D, 0x78B2A59F, 0x74A8A29B, 0x6FA7A49B, 0x6FA7A49B,
  0x6CB8B3AE, 0x7194827B, 0x7667453E, 0x7B673933, 0x81744139, 0x86835148, 0x8B6F4136, 0x90664133, 0x955A3A2C, 0x9B53392A, 0xA0573E31, 0xA471594D, 0xAA7C5E55, 0xAF825C55, 0xB3825C53, 0xB8815C51, 0xBD835F53, 0xC2846052, 0xC6815D4C, 0xCA7A5444, 0xCF795147, 
        0xD3764B48, 0xD7673D37, 0xDB5C312C, 0xDF502A23, 0xE3401F15, 0xE75D4038, 0xEA826C64, 0xEE4F3A37, 0xF12F2122, 0xF4322A29, 0xF71C1A18, 0xF9373834, 0xFC2C2F2B, 0xFE272925, 0xFF6D6E6B, 0xFF8D827F, 0xFF6A4E4B, 0xFF62423F, 0xFF6C4946, 0xFF6C4642, 
        0xFF673F3A, 0xFF663E39, 0xFF633B35, 0xFF653C33, 0xFF72483D, 0xFF825A4E, 0xFF956E62, 0xFFA0796E, 0xFFA47B70, 0xFFA57B71, 0xFFA77C71, 0xFFA87D75, 0xFFA67E77, 0xFFA07870, 0xFF936A63, 0xFF89625A, 0xFF835E58, 0xFF77534D, 0xFF75544C, 0xFF704A44, 
        0xFF6A413D, 0xFF653E3A, 0xFF644440, 0xFF49312D, 0xFE2F1D18, 0xFD312520, 0xFB4A423D, 0xF8726B6B, 0xF52B2225, 0xF31B0F12, 0xEF2F2120, 0xEC3D2A27, 0xE9412A26, 0xE55F4741, 0xE17A6159, 0xDD7F6158, 0xD9815E53, 0xD57C594C, 0xD17E5D50, 0xCD836456, 
        0xC885695B, 0xC4876D5E, 0xBF866A5B, 0xBB836458, 0xB685625B, 0xB180635A, 0xAC6A5247, 0xA7483326, 0xA2432D1F, 0x9D5C4438, 0x98856C64, 0x9396706B, 0x8E8B5450, 0x8877433D, 0x83835B55, 0x7DA78E88, 0x79B0A39B, 0x74AAA49B, 0x6EA8A69D, 0x6EA8A69D,
  0x6BB9B4B2, 0x71998984, 0x76674942, 0x7B673C37, 0x8077433B, 0x85855248, 0x8A703E31, 0x90643C2E, 0x95613F2F, 0x9A55392A, 0x9F5E4334, 0xA471594B, 0xA97C6054, 0xAE846056, 0xB3856055, 0xB8835F52, 0xBD835F50, 0xC1825F4F, 0xC6805C4C, 0xCA7A5442, 0xCE744D41, 
        0xD3704842, 0xD7643933, 0xDB522721, 0xDF461E19, 0xE35B3933, 0xE76B4E48, 0xEA8A726E, 0xED745E5D, 0xF0361F21, 0xF42D1E1E, 0xF72B201E, 0xF9362F2C, 0xFC332E2A, 0xFE423E3A, 0xFF918D8B, 0xFFA19694, 0xFF8F7B78, 0xFF896F6D, 0xFF5E3B39, 0xFF734D4B, 
        0xFF805A57, 0xFF805B57, 0xFF643D38, 0xFF633930, 0xFF714237, 0xFF83574B, 0xFF946C60, 0xFF9C7569, 0xFFA0786C, 0xFFA57D71, 0xFFA57D70, 0xFFA57C72, 0xFFA27A72, 0xFF9D756D, 0xFF8A6059, 0xFF805850, 0xFF7A544C, 0xFF76514B, 0xFF7B5C54, 0xFF734F49, 
        0xFF6F4743, 0xFF684541, 0xFF7C6360, 0xFF523E3B, 0xFF2F221E, 0xFC342E2A, 0xFA393935, 0xF8545758, 0xF536393E, 0xF2252528, 0xEF595555, 0xEB827B78, 0xE8574944, 0xE5331D17, 0xE14D362E, 0xDD6F5147, 0xD9805D50, 0xD57E5B4F, 0xD1805F52, 0xCD85685A, 
        0xC8876B5D, 0xC48F7568, 0xBF8B7162, 0xBA86655B, 0xB687605D, 0xB1806159, 0xAC6C5147, 0xA74C3326, 0xA2482D20, 0x9D73574D, 0x988D6E69, 0x938D605B, 0x8D8A544D, 0x88885750, 0x838B665F, 0x7EA78F87, 0x79B0A39B, 0x73ACA39A, 0x6EAAA49D, 0x6EAAA49D,
  0x6BB7B4AD, 0x719F9490, 0x7670544D, 0x7B673E39, 0x8075413B, 0x85854E44, 0x8A754437, 0x90683C2F, 0x94674435, 0x9A573B2A, 0x9E624839, 0xA46F594A, 0xA97C5E52, 0xAE835E54, 0xB3855F55, 0xB8846154, 0xBC876355, 0xC1856353, 0xC5825E4D, 0xCA7B5545, 0xCE765142, 
        0xD26C443C, 0xD75F3731, 0xDB633C36, 0xDF704C47, 0xE26C4846, 0xE66E4B49, 0xE9765756, 0xED79595C, 0xF05D393E, 0xF34A292C, 0xF6371C1D, 0xF9473130, 0xFB4E3A39, 0xFD7F6D6D, 0xFF958384, 0xFF7D6A68, 0xFF776460, 0xFF8B7573, 0xFF674543, 0xFF6B4342, 
        0xFF754C4B, 0xFF906E6B, 0xFF6C4641, 0xFF643830, 0xFF744236, 0xFF85574B, 0xFF94695D, 0xFF9A7265, 0xFF9D7669, 0xFFA27D6F, 0xFFA37F70, 0xFFA47E73, 0xFFA17871, 0xFF9E7870, 0xFF875E56, 0xFF7E564E, 0xFF825E56, 0xFF9A7E79, 0xFF7E6058, 0xFF6E4943, 
        0xFF76514D, 0xFF8D726E, 0xFF998683, 0xFF7A6B68, 0xFF312824, 0xFC343431, 0xFA1F2522, 0xF7242B2E, 0xF5353A41, 0xF22F3035, 0xEE777477, 0xEB968D8E, 0xE871625F, 0xE44C3531, 0xE1472925, 0xDD57342B, 0xD9755042, 0xD4856356, 0xD0866659, 0xCC87695B, 
        0xC88A6E60, 0xC3917769, 0xBE8C7163, 0xBA87645B, 0xB58A605F, 0xB0815F59, 0xAB6C4E46, 0xA64E3026, 0xA153372C, 0x9C886961, 0x97936E69, 0x9290645D, 0x8D8A584F, 0x8886574E, 0x838F6E64, 0x7DAF9992, 0x78B4A59C, 0x73AEA39C, 0x6DACA7A0, 0x6DACA7A0,
  0x6BB0ADAB, 0x70AA9E9A, 0x75755D56, 0x7A643E38, 0x7F764640, 0x8585524C, 0x8A7B4942, 0x8F6A4035, 0x94674437, 0x99573A2B, 0x9E634A3B, 0xA3755D4F, 0xA87B5F51, 0xAD825F53, 0xB2835F54, 0xB7846154, 0xBC856256, 0xC0856154, 0xC5825E4E, 0xC9754E40, 0xCE6D4437, 
        0xD270473B, 0xD6754D43, 0xDA765047, 0xDE78534E, 0xE27B5552, 0xE577514F, 0xE9775153, 0xEC764E51, 0xEF7D5559, 0xF37E5A5C, 0xF57F5E5F, 0xF87E5E5E, 0xFB907575, 0xFD886A6B, 0xFF896A6B, 0xFF7F5D5E, 0xFF755052, 0xFF734B4D, 0xFF7D5253, 0xFF875C5D, 
        0xFF825857, 0xFF865D5A, 0xFF724842, 0xFF6A3E35, 0xFF73443A, 0xFF85594F, 0xFF93695F, 0xFF986F64, 0xFF9C7368, 0xFFA1796E, 0xFFA57D71, 0xFFA67E73, 0xFFA1786E, 0xFF9F776E, 0xFF8A5F56, 0xFF865C55, 0xFF906C66, 0xFF94746E, 0xFF76524B, 0xFF7D5553, 
        0xFF82565B, 0xFF906B6F, 0xFF95787A, 0xFF9B8788, 0xFD615151, 0xFC332828, 0xF92B2423, 0xF7322D31, 0xF43C363E, 0xF06B6267, 0xEE9B9092, 0xEA887577, 0xE76F5354, 0xE46B4B4B, 0xE0674442, 0xDC603932, 0xD870473F, 0xD4815D56, 0xD084645B, 0xCC87695F, 
        0xC78F7368, 0xC391766A, 0xBE8B7064, 0xB989655B, 0xB58C635F, 0xB0815F59, 0xAB6F5047, 0xA554352B, 0xA1604237, 0x9C8C6E63, 0x97937368, 0x91966A62, 0x8C915C55, 0x8787544D, 0x82946D67, 0x7DAF9690, 0x78B2A39A, 0x72ADA59C, 0x6DACA7A0, 0x6DACA7A0,
  0x6AB4B1AC, 0x70B5AEA7, 0x75755F58, 0x7964433C, 0x7E7B4E4A, 0x8483514D, 0x897E4E46, 0x8F734840, 0x946C463C, 0x995E3F31, 0x9E654A3D, 0xA2775F51, 0xA77B5F52, 0xAD815F52, 0xB2826154, 0xB6856356, 0xBB866458, 0xBF825D52, 0xC47E574A, 0xC8744C40, 0xCD795042, 
        0xD17C5445, 0xD57E5649, 0xD9805850, 0xDD815A55, 0xE1835B58, 0xE5845B5B, 0xE882595B, 0xEB825A5B, 0xEF825B5B, 0xF2866060, 0xF5876161, 0xF7845E5E, 0xFA906D6D, 0xFC8B6767, 0xFE896464, 0xFF895B60, 0xFF8A555D, 0xFF845055, 0xFF885659, 0xFF88595A, 
        0xFF815251, 0xFF825552, 0xFF734540, 0xFF6B3F37, 0xFF754A42, 0xFF825851, 0xFF8F665E, 0xFF976D65, 0xFF9B6F68, 0xFFA37670, 0xFFA67871, 0xFFA4786E, 0xFFA3796E, 0xFF9C7165, 0xFF93675D, 0xFF8D605A, 0xFF9C7570, 0xFF97716D, 0xFF8F6966, 0xFF8C5E62, 
        0xFF814B55, 0xFF7F4D56, 0xFF7D5259, 0xFF8D6D70, 0xFD84696B, 0xFB6B5352, 0xF96F5A58, 0xF65E4B4F, 0xF36F5C62, 0xF08B787D, 0xED81686D, 0xE9785A5D, 0xE7815F61, 0xE3815B5C, 0xDF774E4D, 0xDB714743, 0xD7764F4A, 0xD376504B, 0xCF7E5953, 0xCA88675F, 
        0xC68E7068, 0xC291746A, 0xBD8B7064, 0xB989685D, 0xB48B665D, 0xAF7F5C55, 0xAA725149, 0xA5543229, 0xA06A4A3E, 0x9B93796A, 0x969C7F70, 0x919B7065, 0x8C955C59, 0x86814844, 0x82966B69, 0x7CB49995, 0x77B1A09A, 0x72B0A59E, 0x6DAAA79E, 0x6DAAA79E,
  0x69B0B0AB, 0x6FB9B2AE, 0x747F6D64, 0x7964453F, 0x7E7D524E, 0x84854F4D, 0x887F4C47, 0x8D75443F, 0x93673C33, 0x98653F35, 0x9D6C4C40, 0xA2785C50, 0xA77F5F53, 0xAC805E51, 0xB1836154, 0xB6856256, 0xBA89655A, 0xBE815B50, 0xC37B5448, 0xC87C5549, 0xCC845C50, 
        0xD07D5446, 0xD47C5245, 0xD87E5349, 0xDC7F564F, 0xE0855C58, 0xE4875F5E, 0xE7895F60, 0xEB896161, 0xEE8C6766, 0xF18C6765, 0xF48C6865, 0xF68E6968, 0xF993716F, 0xFB967372, 0xFD916D6C, 0xFF8B6062, 0xFF88575C, 0xFF825154, 0xFF865757, 0xFF875958, 
        0xFF7B4D4B, 0xFF774B47, 0xFF70423D, 0xFF70443D, 0xFF7D5049, 0xFF82554E, 0xFF8C6159, 0xFF976C64, 0xFF9A6B65, 0xFFA2746D, 0xFFA5766E, 0xFF9D6D62, 0xFFA27668, 0xFF9A6D60, 0xFF976B60, 0xFF885A52, 0xFF8F6561, 0xFF946C6B, 0xFF8E6767, 0xFF8E6466, 
        0xFF8B5B60, 0xFF86575C, 0xFF84595C, 0xFE876364, 0xFC8D6E6E, 0xFA8F7371, 0xF79E8684, 0xF585696C, 0xF28B7177, 0xF084666C, 0xEC816166, 0xE9876668, 0xE6856060, 0xE2866060, 0xDE865E5C, 0xDA835B57, 0xD6856059, 0xD27B544C, 0xCE7B544B, 0xCA88675A, 
        0xC58F7063, 0xC1927566, 0xBD8C7061, 0xB88A6A5C, 0xB3886359, 0xAE7F5B54, 0xA9735149, 0xA4523026, 0x9F7B5B50, 0x9B9A7C6F, 0x959D7E6F, 0x909B6F64, 0x8B965D59, 0x867B423E, 0x80936965, 0x7CB69D99, 0x77AFA09A, 0x71ADA49D, 0x6CA9A59E, 0x6CA9A59E,
  0x69AEABA6, 0x6EB8B1AD, 0x739C8F86, 0x78674A43, 0x7E7F5450, 0x8285504A, 0x887D4843, 0x8D6F3B34, 0x925F2B22, 0x975F342A, 0x9C704A3F, 0xA17E5E52, 0xA6826155, 0xAB836054, 0xB0815F53, 0xB4845F54, 0xB9866156, 0xBE815B50, 0xC2815A4E, 0xC7835C51, 0xCB896155, 
        0xCF83584B, 0xD380554A, 0xD77F5349, 0xDB7D5147, 0xDF80554F, 0xE3815652, 0xE6805452, 0xEA805653, 0xED88605D, 0xEF8C6462, 0xF38B6461, 0xF58F6864, 0xF88B6260, 0xFA8C6461, 0xFC8C6562, 0xFE8C6362, 0xFF8B6060, 0xFF885B5B, 0xFF865957, 0xFF825654, 
        0xFF754945, 0xFF734843, 0xFF714540, 0xFF774A44, 0xFF7F4F49, 0xFF845450, 0xFF8F615B, 0xFF986A63, 0xFF9A6A65, 0xFFA0706A, 0xFFA5766E, 0xFFA07265, 0xFFA37867, 0xFFA07466, 0xFF976B5E, 0xFF8E6159, 0xFF895C59, 0xFF916769, 0xFF8E6468, 0xFF8C6163, 
        0xFF895D5D, 0xFF865959, 0xFF895F5F, 0xFD8E6766, 0xFB926D6B, 0xF9926F6D, 0xF7987674, 0xF4825B5C, 0xF18B656B, 0xEE8E676D, 0xEB936F73, 0xE8967273, 0xE5916D6C, 0xE18D6765, 0xDD8E6865, 0xD98B655E, 0xD58B675B, 0xD18B655A, 0xCD886456, 0xC98B685A, 
        0xC5917060, 0xC0927463, 0xBB8D6F5D, 0xB7896858, 0xB2845F55, 0xAD7F5953, 0xA8745049, 0xA3603B33, 0x9F967870, 0x9A9E7D73, 0x959F7C6F, 0x8F9C7065, 0x89945D59, 0x8587544E, 0x809B7973, 0x7BB8A59F, 0x75B1A49C, 0x70AEA79E, 0x6BABA89F, 0x6BABA89F,
  0x68ADADA9, 0x6DB3AEA7, 0x72ADA299, 0x77624A40, 0x7C7F5852, 0x8285524A, 0x877D473F, 0x8B6F352F, 0x9160261D, 0x965D281E, 0x9B72493C, 0xA0836457, 0xA5816154, 0xA9846155, 0xAE846054, 0xB3825D53, 0xB8856055, 0xBD835C53, 0xC1855C51, 0xC5865B52, 0xCA895E54, 
        0xCE865C4E, 0xD2885E53, 0xD6865B50, 0xD97F5349, 0xDE7F534A, 0xE17F524B, 0xE47E514C, 0xE880534F, 0xEB835754, 0xEF825553, 0xF1855956, 0xF4885C5A, 0xF7865A57, 0xF9875B59, 0xFB8D6260, 0xFD916966, 0xFF8F6662, 0xFF885D5A, 0xFF7F524F, 0xFF7A4C49, 
        0xFF764A46, 0xFF774B47, 0xFF764945, 0xFF7B4A46, 0xFF824E4A, 0xFF895653, 0xFF92605C, 0xFF976661, 0xFF9C6B66, 0xFFA2736D, 0xFFA4746D, 0xFFA5776B, 0xFFA17464, 0xFF9E7063, 0xFF95675B, 0xFF92635C, 0xFF865654, 0xFF87595B, 0xFF8A5E63, 0xFF916869, 
        0xFF8D6562, 0xFF89605C, 0xFE8B615E, 0xFC906763, 0xFA966D6B, 0xF89C7473, 0xF5A17977, 0xF39D7474, 0xF0A37A7E, 0xEDA0787B, 0xEA9F787A, 0xE7987270, 0xE3936C69, 0xDF936D68, 0xDC8F6964, 0xD88D655D, 0xD48D675B, 0xD0926C60, 0xCC937061, 0xC8926F5F, 
        0xC3906D5C, 0xBF93735F, 0xBA8F705A, 0xB58D6A5B, 0xB1876057, 0xAC7C554E, 0xA776524C, 0xA376514A, 0x9DA5867F, 0x98A38379, 0x939F7A6C, 0x8E9B6B62, 0x898D5551, 0x84946862, 0x7FA68882, 0x7AB5A59C, 0x74AFA49B, 0x70AAA59C, 0x6BA8A49D, 0x6BA8A49D,
  0x67AFB1AA, 0x6CB1AEA7, 0x71B6AFA8, 0x77665348, 0x7B846159, 0x808B5B55, 0x867F4C44, 0x8A70352F, 0x90632621, 0x95642F27, 0x99774C40, 0x9F846456, 0xA37F5D51, 0xA9856055, 0xAD845F53, 0xB2845E52, 0xB7886257, 0xBB885F54, 0xC0845950, 0xC4875C51, 0xC98B6256, 
        0xCD8D6356, 0xD1895F52, 0xD584564D, 0xD884564D, 0xDD875A52, 0xE0865A53, 0xE4885D56, 0xE78A5D58, 0xEA875855, 0xED845653, 0xF0865954, 0xF28B5E5B, 0xF58E605D, 0xF88B5D5A, 0xFA926863, 0xFC976F69, 0xFE8D655C, 0xFF835851, 0xFF80524D, 0xFF80514D, 
        0xFF80504E, 0xFF7E4E4C, 0xFF7C4C49, 0xFF7F4A48, 0xFF89524F, 0xFF8E5856, 0xFF925D5A, 0xFF97645F, 0xFFA06E6A, 0xFFA4746E, 0xFFA06F67, 0xFFA7796F, 0xFFA5766C, 0xFFA17369, 0xFF996B62, 0xFF92635D, 0xFF8B5B59, 0xFF885A59, 0xFF885C5D, 0xFF926B69, 
        0xFF916D68, 0xFE916D69, 0xFD926B67, 0xFB926966, 0xF9916864, 0xF6936564, 0xF4956968, 0xF1976B6A, 0xEE9C706F, 0xEC9D7371, 0xE99C7271, 0xE59A726D, 0xE2946C68, 0xDE936A65, 0xDA926963, 0xD791675E, 0xD3936C60, 0xCF987367, 0xCB946F61, 0xC6906C5D, 
        0xC2906C5B, 0xBE906D5B, 0xB98F6E5A, 0xB58A6756, 0xB0856057, 0xAA7F5852, 0xA67A544E, 0xA16D433F, 0x9C8A635C, 0x979D786E, 0x91A67E71, 0x8DA5766F, 0x8897635D, 0x839B746E, 0x7EB19B95, 0x79B4A59D, 0x74ADA69B, 0x6FABA79E, 0x6AAAA89E, 0x6AAAA89E,
  0x66AFB1AC, 0x6BADADA6, 0x70BAB3AC, 0x75705D54, 0x7A79594F, 0x7F865C50, 0x847B493F, 0x8A6C3128, 0x8F5E231A, 0x93723E33, 0x98764C3F, 0x9E846556, 0xA2805F51, 0xA7856156, 0xAC835E52, 0xB1855F53, 0xB5896056, 0xB9875E54, 0xBF865D52, 0xC3895E55, 0xC78E6259, 
        0xCB8A5F55, 0xCF895D52, 0xD38A5D51, 0xD78B5F54, 0xDB8D6158, 0xDF8E6257, 0xE290645B, 0xE593675F, 0xE88F625B, 0xEC90625C, 0xEE92635E, 0xF191635E, 0xF392645E, 0xF690605B, 0xF88F5F5A, 0xFA8F625A, 0xFC885C51, 0xFE855850, 0xFF875953, 0xFF885754, 
        0xFF84504F, 0xFF7F4948, 0xFF804849, 0xFF844A4B, 0xFF8A4F4E, 0xFF8D5453, 0xFF8E5653, 0xFF945D59, 0xFF9E6B67, 0xFF9E6B65, 0xFF99655E, 0xFFA6756F, 0xFFA67670, 0xFFA1716B, 0xFF96655F, 0xFF91605A, 0xFF8E5F5A, 0xFF8D5F5A, 0xFF895D58, 0xFF906965, 
        0xFF92706C, 0xFD977572, 0xFB987572, 0xF995716F, 0xF797706E, 0xF598706E, 0xF2966C6B, 0xF0916460, 0xED92675F, 0xEA976E67, 0xE7976E68, 0xE4956C66, 0xE0946B64, 0xDD956A65, 0xD9946B64, 0xD5936961, 0xD1976F64, 0xCD987068, 0xC9946D61, 0xC5916B5C, 
        0xC1977464, 0xBC906D5B, 0xB8926F5D, 0xB28A6455, 0xAE876159, 0xA9855E58, 0xA5825D59, 0x9F734843, 0x9A885E57, 0x969E756C, 0x91A97E75, 0x8CA97972, 0x879A6763, 0x82A07D75, 0x7DB7A39D, 0x78ADA39A, 0x72ABA79C, 0x6DACAA9E, 0x69A9A69D, 0x69A9A69D,
  0x65B0B0AB, 0x6AAFAFA5, 0x6FB9B4AB, 0x7485746B, 0x79715649, 0x7E835A4C, 0x8378473C, 0x886A3429, 0x8D63291E, 0x92805145, 0x96714939, 0x9B836755, 0xA1846556, 0xA5855F54, 0xAB815C51, 0xAF855E52, 0xB48A6157, 0xB8875D54, 0xBD875C54, 0xC18D6359, 0xC690655D, 
        0xCA90635A, 0xCD8F6158, 0xD1916457, 0xD68F6156, 0xD9916358, 0xDD906458, 0xE08F6257, 0xE4906258, 0xE790605A, 0xEA92635C, 0xED956761, 0xEF91625B, 0xF293635D, 0xF4906059, 0xF78D5B54, 0xF98C5D54, 0xFA8D5F54, 0xFC8F6058, 0xFE8E5D57, 0xFF8D5956, 
        0xFF864E4E, 0xFF7E4344, 0xFF84484C, 0xFF894D4F, 0xFF8C4F4F, 0xFF8E5252, 0xFF8F5453, 0xFF955E5A, 0xFF9E6B67, 0xFFA26F6A, 0xFFA16E67, 0xFFAA7976, 0xFFAC7D7C, 0xFFA77675, 0xFF996764, 0xFF93615C, 0xFF8F6057, 0xFF8E6258, 0xFF8C6156, 0xFF8E6862, 
        0xFD8D6A68, 0xFB957372, 0xFA997775, 0xF7977473, 0xF5977373, 0xF3997575, 0xF1997475, 0xEE96716B, 0xEB957064, 0xE8977267, 0xE5997268, 0xE2987168, 0xDF9B736B, 0xDB9D756D, 0xD89C726B, 0xD4996F68, 0xD099706A, 0xCC9B706A, 0xC79A736A, 0xC3986F65, 
        0xBF977165, 0xBB957064, 0xB590695B, 0xB18D6459, 0xAD845C53, 0xA8845D59, 0xA38D6663, 0x9E7D5350, 0x9A8A5F59, 0x949E716A, 0x90AD8178, 0x8BA8766F, 0x859E6C67, 0x81B79791, 0x7CB8A89F, 0x77ADA49C, 0x72A9A79C, 0x6DA7A59C, 0x67AAA79E, 0x67AAA79E,
  0x64AFAFAA, 0x69B0AEA6, 0x6EB6AFAA, 0x73897B72, 0x77644D42, 0x7D7E5D53, 0x8174483F, 0x876B362B, 0x8C673124, 0x91885B4D, 0x95744B38, 0x9A826350, 0x9F88685B, 0xA387625A, 0xA9845E55, 0xAE845D56, 0xB289615A, 0xB7885E57, 0xBA895E56, 0xC08A6058, 0xC38D6158, 
        0xC88E5F56, 0xCC8E5F55, 0xD08F6056, 0xD4926258, 0xD7936459, 0xDA94645A, 0xDE916257, 0xE2905F5A, 0xE58E5B59, 0xE88F5C5A, 0xEB92615C, 0xEE915E59, 0xF093605A, 0xF2946059, 0xF5936158, 0xF796675A, 0xF9936457, 0xFB916055, 0xFC8E5D53, 0xFE8A5751, 
        0xFF86504D, 0xFF814949, 0xFF854E4F, 0xFF895250, 0xFF8B514D, 0xFF8F5752, 0xFF925954, 0xFF955F58, 0xFF9B6761, 0xFFA3706A, 0xFFA5736D, 0xFFAB7B77, 0xFFAD7E7D, 0xFFA77675, 0xFF996662, 0xFF915F58, 0xFF8E5D53, 0xFF8C5E52, 0xFE8F6457, 0xFD946A60, 
        0xFB926861, 0xFA956E69, 0xF899736D, 0xF69B7773, 0xF4997773, 0xF1987773, 0xEF997874, 0xEC9C7B75, 0xE99A766F, 0xE69B756E, 0xE39C766E, 0xE09D776E, 0xDD9C756D, 0xD99A726A, 0xD59A7269, 0xD19C736C, 0xCE986F6B, 0xCA99726B, 0xC6976F67, 0xC2966E66, 
        0xBD966C61, 0xB9987065, 0xB5906458, 0xB08A6056, 0xAB815951, 0xA7845B56, 0xA197716B, 0x9D885955, 0x988F5F5A, 0x93A07069, 0x8EB3847D, 0x89A1716B, 0x84986E68, 0x7FBAA29A, 0x7AB1A79C, 0x75A9A79C, 0x70A7AA9E, 0x6BA8A89F, 0x66AAA7A0, 0x66AAA7A0,
  0x62B3B3AB, 0x67B1AFAA, 0x6CB8B3AC, 0x71948B82, 0x76634D45, 0x7B7E5F59, 0x80754B45, 0x856C3B2F, 0x8A612A19, 0x8F855745, 0x947B503D, 0x99846151, 0x9E87655A, 0xA287625E, 0xA785615B, 0xAC86605A, 0xB0875F59, 0xB5855D56, 0xB9875E56, 0xBE8B6158, 0xC28D6257, 
        0xC593645A, 0xC9926359, 0xCE926259, 0xD297665F, 0xD695655C, 0xD9935F57, 0xDD96625A, 0xE0976462, 0xE3935E61, 0xE6925B5E, 0xE9945D5E, 0xEC935C5A, 0xEE96615A, 0xF198655D, 0xF397635A, 0xF598685A, 0xF7966756, 0xF9936356, 0xFA916055, 0xFC8A584F, 
        0xFD83514B, 0xFE814F4C, 0xFF82504F, 0xFF86534E, 0xFF844E45, 0xFF8C574E, 0xFF925E55, 0xFF98655C, 0xFF9E6B64, 0xFFA27069, 0xFFA5736D, 0xFFAA7A75, 0xFFA87975, 0xFFA2716D, 0xFF97655F, 0xFF915D55, 0xFE8F5E54, 0xFE8E5F53, 0xFC94675A, 0xFB9A6C5F, 
        0xF99B6B5F, 0xF8976A5E, 0xF6986B60, 0xF4986F65, 0xF298726A, 0xEF99776F, 0xED997770, 0xEAA27E78, 0xE79F7775, 0xE59D7571, 0xE1A17A75, 0xDEA07974, 0xDBA07871, 0xD79E766D, 0xD49A7369, 0xD09A736C, 0xCC9C746C, 0xC8A07971, 0xC4986F66, 0xC0966D63, 
        0xBC986D62, 0xB79A6F64, 0xB395695D, 0xAE896056, 0xA9825B54, 0xA58A625C, 0xA0A37D77, 0x9B905F58, 0x96925B58, 0x92A06A66, 0x8CB27F7B, 0x88956661, 0x839F7E78, 0x7EB9A9A1, 0x79ACA89D, 0x74A6A89D, 0x6FA4ABA0, 0x6AA8AAA3, 0x65A8A8A3, 0x65A8A8A3,
  0x61AFAFA7, 0x66AFACA7, 0x6BB7B2AB, 0x709E9891, 0x755D433A, 0x797B5A51, 0x7E7F544A, 0x84754134, 0x88642B1D, 0x8D6D3627, 0x92825549, 0x97845C52, 0x9B89655D, 0xA087625D, 0xA585615A, 0xAA87605A, 0xAE876059, 0xB2865E55, 0xB7886157, 0xBC896257, 0xC08A5F54, 
        0xC3916158, 0xC893645B, 0xCC92625A, 0xD094645C, 0xD397665D, 0xD795635A, 0xDA956259, 0xDE986360, 0xE1986064, 0xE4985E61, 0xE7976061, 0xE9986261, 0xEC9A6761, 0xEE9C6C62, 0xF19A6C62, 0xF3996B5E, 0xF5966659, 0xF7946458, 0xF8916157, 0xFA8B5A51, 
        0xFB875650, 0xFC865452, 0xFD82514F, 0xFE84524D, 0xFE824D45, 0xFF89544D, 0xFF8F5B54, 0xFF96635C, 0xFF9D6B65, 0xFFA16F6A, 0xFFA67570, 0xFFA97976, 0xFFA47370, 0xFF9E6C69, 0xFF976660, 0xFE905E56, 0xFD8E5D54, 0xFC926359, 0xFA95685C, 0xF997695D, 
        0xF79B6C61, 0xF69A6D62, 0xF4996B62, 0xF2996B63, 0xEF956761, 0xED996E67, 0xEB986E67, 0xE89F7471, 0xE59F7471, 0xE29F7370, 0xDF9F746F, 0xDC9E736D, 0xD9A0756F, 0xD59F746C, 0xD29D7068, 0xCE9E716C, 0xCAA0716D, 0xC6A1746E, 0xC2976A63, 0xBE976961, 
        0xB996695F, 0xB5976A5F, 0xB195695C, 0xAC895E55, 0xA8805951, 0xA38F6862, 0x9E9D7870, 0x9992615B, 0x9596635E, 0x90A16B66, 0x8BB17E7A, 0x868A5953, 0x81AD9189, 0x7CBAAAA4, 0x77ABA69C, 0x72A9ABA0, 0x6DA5ACA0, 0x68A6ABA4, 0x63A9A9A4, 0x63A9A9A4,
  0x5FAEAEA8, 0x64AFADA8, 0x69B5B0AB, 0x6EA8A19A, 0x7361483D, 0x78785043, 0x7C815447, 0x82855044, 0x877A3F34, 0x8C64261B, 0x90713C33, 0x95835752, 0x9A8C6763, 0x9E88655E, 0xA386605A, 0xA8835D57, 0xAC855D55, 0xB1855F54, 0xB5896256, 0xBA8B6257, 0xBE8C5F54, 
        0xC292635A, 0xC694675D, 0xCA95665D, 0xCE94635B, 0xD196625B, 0xD597655B, 0xD8956159, 0xDB9A6260, 0xDF9E6265, 0xE19F6466, 0xE5A06A6A, 0xE79F6A67, 0xEA9C6A65, 0xEC9D6F65, 0xEE9C6F64, 0xF19A6E62, 0xF297675D, 0xF494645B, 0xF6926158, 0xF88C5B54, 
        0xF9895853, 0xFA865551, 0xFB814F4D, 0xFC83504C, 0xFD824F47, 0xFD8B5852, 0xFE8D5A54, 0xFE93605B, 0xFF9D6C67, 0xFFA06E6A, 0xFEA1706C, 0xFEA37370, 0xFEA17170, 0xFD9E6D6B, 0xFD976662, 0xFC905D57, 0xFB8C5A51, 0xFA93645B, 0xF8966B60, 0xF7976A5F, 
        0xF59A6D63, 0xF39C6D64, 0xF1A0716A, 0xEFA2736C, 0xED9E6C67, 0xEB9F6D69, 0xE99C6966, 0xE69C6A67, 0xE39D6B6A, 0xE09E6D6B, 0xDD9E6D69, 0xDA9C6B67, 0xD79F6E69, 0xD39F6F68, 0xD09F7067, 0xCCA67471, 0xC8A6716F, 0xC4A6726F, 0xBFA06E6A, 0xBC9D7069, 
        0xB8976A61, 0xB3956A5F, 0xAF92685B, 0xAA886155, 0xA6835E55, 0xA09A756F, 0x9C976E68, 0x978D5E57, 0x9394605B, 0x8EA16D67, 0x89AE807A, 0x8487544D, 0x7FB69E9A, 0x7AB5A9A0, 0x75ABA79C, 0x71A6AB9F, 0x6CA7ACA0, 0x67A7AAA0, 0x62ABA9A3, 0x62ABA9A3,
  0x5DAFAFA9, 0x63AEAEA7, 0x68B2ADA9, 0x6CB3ACA5, 0x716C5145, 0x76784D40, 0x7B825244, 0x808B574B, 0x85874E44, 0x8A753A31, 0x8E5D221A, 0x9381534F, 0x988D6762, 0x9D88665D, 0xA186615A, 0xA6835D55, 0xAA845D54, 0xAF835E52, 0xB3886053, 0xB7895F54, 0xBC8B5E53, 
        0xC0916157, 0xC4926259, 0xC7936259, 0xCB926058, 0xCF946158, 0xD3946058, 0xD6946159, 0xD99C6461, 0xDCA16465, 0xDFA46A6A, 0xE2A56E6D, 0xE5A3706A, 0xE79F6F67, 0xEA9B6D63, 0xEC9A6E62, 0xEE9A6D63, 0xF09A6C64, 0xF297665F, 0xF492625B, 0xF58F5E58, 
        0xF6885753, 0xF784534F, 0xF97E4B47, 0xFA83504B, 0xFB85524A, 0xFB8C5A54, 0xFC8E5B55, 0xFC905D58, 0xFC95635E, 0xFC9E6D69, 0xFCA2726F, 0xFCA37472, 0xFB9F6E6E, 0xFB9E6D6D, 0xFA966361, 0xF9905D59, 0xF88C5A53, 0xF794645B, 0xF69A6E64, 0xF49A6D64, 
        0xF39C6D66, 0xF19E6F69, 0xEFA2716C, 0xEDA6746F, 0xEBA36E67, 0xE8A16966, 0xE6A06664, 0xE3A16968, 0xE1A06B6A, 0xDE9F6A67, 0xDAA16E69, 0xD7A4706B, 0xD4A26E67, 0xD0A26F67, 0xCDA4726A, 0xC9A6706D, 0xC6A76E6F, 0xC2A66F6E, 0xBEA06C68, 0xB9A07069, 
        0xB59A6E64, 0xB1956D60, 0xAD916B5E, 0xA8876256, 0xA3835C54, 0x9FA3817B, 0x9A8D635C, 0x9587574E, 0x918F5C57, 0x8C9A6762, 0x87A77872, 0x82875650, 0x7DBBA7A3, 0x79B4A89F, 0x74AAA89F, 0x6FA7A9A0, 0x6AA5ACA0, 0x65A6ABA1, 0x60A9A9A1, 0x60A9A9A1,
  0x5CAEAEA8, 0x61AFACA5, 0x66B4AFA7, 0x6BB7B0AB, 0x6F775D52, 0x74784E43, 0x7984584B, 0x7E8F5C52, 0x838B574B, 0x88824A41, 0x8C6D362D, 0x917E524B, 0x968D6962, 0x9A88645C, 0x9F866058, 0xA4835E53, 0xA7845E52, 0xAC855E52, 0xB1876052, 0xB5896052, 0xB98A5E52, 
        0xBD8E5D54, 0xC18E5F55, 0xC5906057, 0xC9936259, 0xCC98675F, 0xD098655D, 0xD3996860, 0xD7A16B66, 0xDAA26866, 0xDDA66D6A, 0xDFA7706C, 0xE2A36D68, 0xE59F6D67, 0xE79F6F66, 0xE99C6F65, 0xEC9C6E67, 0xEE9C6E69, 0xEF976764, 0xF194625E, 0xF390605C, 
        0xF4885653, 0xF5804E49, 0xF6794641, 0xF782504B, 0xF884524C, 0xF9885751, 0xF98A5854, 0xF9915F5B, 0xFA956460, 0xFA9C6C69, 0xFAA1716E, 0xF9A37272, 0xF99D6A6B, 0xF89C6A6B, 0xF894615F, 0xF793615D, 0xF58F5D58, 0xF4906059, 0xF3986C63, 0xF29D6F69, 
        0xF0A1716D, 0xEEA2716D, 0xEDA4736F, 0xEBA97672, 0xE8A8736F, 0xE6A66F6A, 0xE3A86E6A, 0xE1A7716D, 0xDEA46F6D, 0xDBA06A66, 0xD89F6763, 0xD5A16C65, 0xD2A06B64, 0xCEA26E67, 0xCBA6736A, 0xC7A56E6A, 0xC3A76F6F, 0xBFA66F6E, 0xBBA06C6A, 0xB69F706A, 
        0xB3996E64, 0xAF926C5E, 0xAA906A5B, 0xA6866054, 0xA187605A, 0x9D9B7671, 0x987B4E46, 0x93805146, 0x8F91615C, 0x8A9A6A63, 0x859A6A61, 0x80936963, 0x7CBEAAA6, 0x77AFA29C, 0x72ABA99E, 0x6DA7ACA0, 0x68A6ABA1, 0x64A5AA9E, 0x5FABA8A0, 0x5FABA8A0,
  0x5AAFAFA9, 0x5FAEABA3, 0x63B1ACA7, 0x69B5AEA6, 0x6E85716A, 0x72734E45, 0x77865E53, 0x7C93685C, 0x818D5C50, 0x858B5B4E, 0x8A7B4D40, 0x8F7C5347, 0x938C675D, 0x9888655B, 0x9D835D52, 0xA1835D52, 0xA6855E51, 0xAA876152, 0xAE896153, 0xB3896353, 0xB78C5F53, 
        0xBB8C5B51, 0xBF8C5D52, 0xC2926259, 0xC594625A, 0xC997665D, 0xCD99685F, 0xD1996860, 0xD4A06D66, 0xD7A56D69, 0xDAA56F6A, 0xDDA56F69, 0xE0A36D67, 0xE2A16C67, 0xE4A26F68, 0xE7A16F68, 0xE9A1706D, 0xEB9E7070, 0xED9B6B6B, 0xEE996867, 0xF092615E, 
        0xF183504C, 0xF3784540, 0xF476423D, 0xF482504B, 0xF582504A, 0xF6885753, 0xF68D5B58, 0xF792605E, 0xF7966562, 0xF79B6D6A, 0xF69E706E, 0xF7A17171, 0xF69D6B6D, 0xF6996768, 0xF5976465, 0xF492605F, 0xF38E5C59, 0xF28E5E58, 0xF0986C64, 0xEFA2736F, 
        0xEDA47271, 0xECA3726F, 0xEAA57370, 0xE8A87773, 0xE6A97670, 0xE3AB7671, 0xE0AA7771, 0xDEA87570, 0xDBA5726F, 0xD99F6B65, 0xD69D6861, 0xD29F6B64, 0xCF9E6962, 0xCBA26F66, 0xC8A6746A, 0xC4A5726D, 0xC1A57070, 0xBDA06F6B, 0xB99C6C66, 0xB59B6D66, 
        0xB0987064, 0xAC956F61, 0xA88F695A, 0xA38A655A, 0x9F88615B, 0x9B7F554E, 0x96845851, 0x918D6259, 0x8C91645C, 0x889D726A, 0x838F5F55, 0x7E9F7B75, 0x7AB7A5A3, 0x75AFA7A0, 0x6FABABA2, 0x6BA6AB9F, 0x66A5ACA0, 0x62A6A99E, 0x5DACA99E, 0x5DACA99E,
  0x59AEAEA8, 0x5DAFACA7, 0x62B0ABA6, 0x67B1AAA3, 0x6BA1918A, 0x70714F48, 0x7588635D, 0x7A8E6257, 0x7F8E6050, 0x83875949, 0x887B503D, 0x8C78513F, 0x918C695B, 0x9688645A, 0x9A845E54, 0x9F835E51, 0xA2855F51, 0xA7855F50, 0xAC886051, 0xB0886152, 0xB48B5E53, 
        0xB88F5D54, 0xBC906156, 0xC0926359, 0xC394625B, 0xC69A6A62, 0xCAA06E67, 0xCE9C6B63, 0xD19F6C64, 0xD4A46E67, 0xD7A57069, 0xDAA26D66, 0xDCA6706A, 0xDFA6706A, 0xE2A46E69, 0xE4A6716B, 0xE6A57371, 0xE89E6F70, 0xEA9A6A6A, 0xEC926261, 0xED85514F, 
        0xEF7A4542, 0xF0784440, 0xF177433F, 0xF283504C, 0xF37F4E49, 0xF3885753, 0xF48D5D59, 0xF491605D, 0xF4956562, 0xF49C6D6B, 0xF49E706D, 0xF49F6F70, 0xF49F6D6F, 0xF3996668, 0xF2986566, 0xF18F5C5B, 0xF0905D5A, 0xEE8E5D57, 0xEE94655F, 0xECA0706D, 
        0xEBA57373, 0xE9A67573, 0xE7A97974, 0xE5AA7B75, 0xE3AA7A73, 0xE1AA7C74, 0xDEAB7C74, 0xDBAB7C75, 0xD9A97A75, 0xD5A7776F, 0xD2A6756F, 0xD0A77770, 0xCCA27167, 0xC9A17066, 0xC5A57569, 0xC2A67570, 0xBEA0716D, 0xBA9A6C65, 0xB6986B64, 0xB29A7068, 
        0xAE9A7469, 0xAA997266, 0xA5906B5C, 0xA1876156, 0x9C875E58, 0x988F6762, 0x949C766F, 0x8FA07A71, 0x8A93675D, 0x86997066, 0x818F6256, 0x7CB89B95, 0x77B8A9A4, 0x72B0A7A0, 0x6DAAAAA0, 0x69A4AB9F, 0x64A5ADA0, 0x60A6A99C, 0x5BAAAA9C, 0x5BAAAA9C,
  0x57ACACA4, 0x5BAAAAA2, 0x60ACA9A1, 0x65ADABA3, 0x69AEA49D, 0x6E735A4E, 0x73826356, 0x77865E51, 0x7C8D6254, 0x81825444, 0x85764A3D, 0x8A774F42, 0x8F8E6A60, 0x93886258, 0x98855F53, 0x9C845C51, 0xA0875F52, 0xA5845C4E, 0xA9876051, 0xAD886252, 0xB18D6357, 
        0xB590635B, 0xB991645A, 0xBD93645C, 0xC096655D, 0xC39A6A62, 0xC79D6B63, 0xCB9D6B64, 0xCE9F6D64, 0xD1A26F66, 0xD4A37069, 0xD7A26E69, 0xDAA5716E, 0xDCA5716F, 0xDFA67270, 0xE1AA7677, 0xE3A87576, 0xE59C6A6A, 0xE6956363, 0xE8885352, 0xEA78403E, 
        0xEB7A4440, 0xED7C4944, 0xEE7C4945, 0xEF81504D, 0xEF814D4B, 0xF0865450, 0xF08C5C55, 0xF1905F59, 0xF1966762, 0xF19C6E6B, 0xF19D6F6D, 0xF1A17173, 0xF0A47174, 0xF09F6A6D, 0xEF986264, 0xEE8F5857, 0xED915F5C, 0xEC8E5D58, 0xEB8B5A53, 0xE9996A64, 
        0xE8A47571, 0xE6A97C77, 0xE4AA7E78, 0xE2AA7D77, 0xE0AA7D76, 0xDEA97C74, 0xDBAB7C75, 0xD8AD7D76, 0xD6AB7974, 0xD2A97772, 0xCFA97873, 0xCDAB7A74, 0xC9A6736D, 0xC6A3706A, 0xC2A5736C, 0xBFA77773, 0xBAA1736E, 0xB79D6B66, 0xB39F6D69, 0xAFA0726C, 
        0xABA0746C, 0xA79B7067, 0xA3926A5F, 0x9E8C635B, 0x9A885F59, 0x969A716C, 0x91A47C78, 0x8CB28C88, 0x88956A63, 0x83976E64, 0x7F946C60, 0x79BDA5A1, 0x75B1A4A0, 0x71AFABA4, 0x6CA9A9A0, 0x67A5ACA0, 0x62A3AB9E, 0x5EA5AA9D, 0x59ABA89D, 0x59ABA89D,
  0x55ABABA2, 0x59ABABA3, 0x5EAAAAA2, 0x63ACACA4, 0x67B1AFA5, 0x6C8D7D6E, 0x71795E4E, 0x75845F4E, 0x7A875B4D, 0x7F805046, 0x8376453E, 0x88734843, 0x8C8D6760, 0x91885E57, 0x94896056, 0x99865B51, 0x9E886055, 0xA1865B4F, 0xA6896052, 0xAA8A6152, 0xAE8A6357, 
        0xB28D655C, 0xB6946962, 0xBA93665E, 0xBE94655D, 0xC09A6961, 0xC59D6C64, 0xC89E6B64, 0xCBA06E66, 0xCEA26F69, 0xD1A5736F, 0xD4A5736F, 0xD7A57371, 0xD9A67375, 0xDCA47174, 0xDDA47173, 0xE0A16E6F, 0xE196605E, 0xE48C5755, 0xE5773E3B, 0xE77A423F, 
        0xE8824F4C, 0xE983534F, 0xEB81544E, 0xEB83534F, 0xEC844E4D, 0xED85514D, 0xED8C5A52, 0xEE926258, 0xED996B63, 0xEE9C6E69, 0xEEA27574, 0xEEAC7D7E, 0xEDA77175, 0xEDA26D70, 0xEC996163, 0xEB8E5756, 0xEA8F5D58, 0xE98D5C56, 0xE886564E, 0xE694675E, 
        0xE4A37770, 0xE2AB817A, 0xE1AE847D, 0xDFAF847D, 0xDDAE837C, 0xDAAC7E77, 0xD8AD7E78, 0xD5AE7F7A, 0xD2AD7B77, 0xCFAD7C78, 0xCCAD7B78, 0xCAAC7A76, 0xC6AA7571, 0xC3AA7773, 0xBFA87571, 0xBCA87874, 0xB8A4726E, 0xB49F6966, 0xB0A16A69, 0xACA76F6F, 
        0xA8A36F6C, 0xA49C6F69, 0xA092675D, 0x9C8A6058, 0x97885F5A, 0x93AD8683, 0x8FB28987, 0x8AB48D8B, 0x85966965, 0x81936E66, 0x7C9D7F76, 0x78BAA9A5, 0x73B0A5A3, 0x6EAFAAA4, 0x69A9ABA4, 0x65A6ADA3, 0x60A9AEA4, 0x5BAAADA2, 0x57ACACA1, 0x57ACACA1,
  0x53A8A8A2, 0x57ACACA4, 0x5CABABA3, 0x61AAAAA2, 0x65ADA8A1, 0x6AA09488, 0x6E6E5545, 0x73805C4D, 0x7885594C, 0x7C814F47, 0x817A463F, 0x85744240, 0x898D6460, 0x8E886057, 0x92876157, 0x97865F54, 0x9A8A6357, 0x9F865E50, 0xA3896254, 0xA7876152, 0xAB8A6056, 
        0xAF8C625B, 0xB3936960, 0xB7946861, 0xBA986961, 0xBE9B6C64, 0xC19F7068, 0xC49F6E65, 0xC8A06D66, 0xCBA2706E, 0xCEA77673, 0xD1A77672, 0xD3A57472, 0xD6A67472, 0xD8A2706D, 0xDA9C6763, 0xDD97605F, 0xDF8C5453, 0xE0854D4B, 0xE16B2F2D, 0xE3814D49, 
        0xE4885653, 0xE6895B56, 0xE7875A54, 0xE8885755, 0xE9895352, 0xE9895350, 0xEA8C5A53, 0xEA906157, 0xEB996D64, 0xEB9E7570, 0xEAA8817F, 0xEAB3888A, 0xEAA87377, 0xE9A57073, 0xE89B6667, 0xE8905C5B, 0xE78D5B56, 0xE58E5D56, 0xE4895952, 0xE3916058, 
        0xE19E6D67, 0xE0A47672, 0xDEA87975, 0xDBAF837D, 0xD9AF847F, 0xD7AD817B, 0xD5AB7F79, 0xD2AE807A, 0xCEAF7F79, 0xCCAF7E78, 0xC9AB7A73, 0xC6AB7A73, 0xC3AA7771, 0xBFAC7B75, 0xBCA87570, 0xB9A97773, 0xB4A6726F, 0xB1A26967, 0xADA36B69, 0xA9A5706D, 
        0xA59E6D68, 0xA19A7068, 0x9D916A61, 0x99865C54, 0x94896059, 0x90B28F8B, 0x8CB28C8A, 0x87AC817F, 0x8399706C, 0x7E855C56, 0x7AB39A94, 0x75B6A7A2, 0x71AFA4A4, 0x6CACA7A2, 0x67A7AAA3, 0x63A7ACA1, 0x5EA8ADA2, 0x5AA9ACA1, 0x55ABABA2, 0x55ABABA2,
  0x51A9A9A0, 0x55ABA8A2, 0x5AA9A9A1, 0x5EAAAAA2, 0x63ACA99F, 0x67AFA79E, 0x6C786054, 0x707C5A4D, 0x75805447, 0x79825147, 0x7E7F4844, 0x827B4242, 0x87906563, 0x8B89645B, 0x90886156, 0x93866056, 0x98886456, 0x9C856051, 0xA0886254, 0xA4866050, 0xA88C6559, 
        0xAC91645E, 0xB091665D, 0xB3966B64, 0xB79A6F66, 0xBB9C6F67, 0xBE9E7067, 0xC19E7165, 0xC59F706B, 0xC7A37171, 0xCAA77676, 0xCDA87775, 0xD0A57671, 0xD3A2706A, 0xD59B6962, 0xD7956158, 0xD98F5853, 0xDA8C5352, 0xDD804846, 0xDF6F3632, 0xE085504D, 
        0xE28C5B58, 0xE38D605B, 0xE4885D57, 0xE58B5958, 0xE5905758, 0xE68D5A55, 0xE6916059, 0xE7976A60, 0xE79C7269, 0xE79F7A73, 0xE7B3928F, 0xE7C6A3A3, 0xE6B38487, 0xE6A67376, 0xE59B6869, 0xE4956260, 0xE3905F5A, 0xE192635C, 0xE191625B, 0xDF96635E, 
        0xDE996460, 0xDC9D6966, 0xDAA2716E, 0xD7A97B78, 0xD6B18782, 0xD4B28A86, 0xD1AD847E, 0xCEAD817B, 0xCCB2847D, 0xC9AF7F77, 0xC6AB7A71, 0xC3AB7B73, 0xC0AA7971, 0xBCAC7C75, 0xB9A9776E, 0xB5AC7874, 0xB2AA7572, 0xAEA66E6E, 0xAAA5706D, 0xA6A2726E, 
        0xA29B7169, 0x9E956F65, 0x9A8D695E, 0x9689645A, 0x928B5F5A, 0x8DAB837F, 0x89A97E7C, 0x84A57B79, 0x8099716D, 0x7C8B6A62, 0x77BEADA4, 0x73B3A7A1, 0x6EADA6A4, 0x6AAAA5A0, 0x65A8ABA3, 0x61A7ACA2, 0x5CA8ABA3, 0x57A9ACA4, 0x53ABABA2, 0x53ABABA2,
  0x4FAAA7A1, 0x52AAA7A1, 0x58AAA79E, 0x5CABA8A0, 0x60ACA6A1, 0x65ADA69C, 0x69857165, 0x6E755A4C, 0x727C5647, 0x77805348, 0x7B7E4A44, 0x7F7E4644, 0x84946A64, 0x888A645B, 0x8D876358, 0x91866055, 0x95886357, 0x99866154, 0x9D886254, 0xA1876152, 0xA58C645A, 
        0xA8906660, 0xAC946960, 0xB0976C64, 0xB49B7268, 0xB79B7066, 0xBB9C7066, 0xBE9E7368, 0xC1A1726D, 0xC4A37272, 0xC7A57574, 0xCAA67673, 0xCCA67671, 0xCF9F6E66, 0xD199675C, 0xD3935E52, 0xD6915A54, 0xD78E5654, 0xD97E4542, 0xDA703633, 0xDC844F4D, 
        0xDE8E5E5A, 0xDF90655F, 0xE08C615B, 0xE18D5C5A, 0xE1905B5B, 0xE2905C59, 0xE392635B, 0xE3996E64, 0xE3A17A71, 0xE3A8847E, 0xE3AC8A87, 0xE3BB9797, 0xE3B4898A, 0xE2A47577, 0xE1A17171, 0xE1986764, 0xE092625D, 0xDE956760, 0xDD966861, 0xDC976560, 
        0xDA975F5C, 0xD998625E, 0xD79C6A65, 0xD5A0736E, 0xD2A97D79, 0xD0B08883, 0xCEAD8781, 0xCBAD837D, 0xC8B58781, 0xC5B2827B, 0xC2AC7C75, 0xC0AE7D76, 0xBCAE7D76, 0xB8AD7D75, 0xB6AA7871, 0xB2AD7975, 0xAEAA7674, 0xABA97572, 0xA7A47370, 0xA39F756E, 
        0x9F9B746B, 0x9B906C62, 0x9788665A, 0x93865F56, 0x8F895E59, 0x8AA37975, 0x869B6E6E, 0x829C7371, 0x7D8C6863, 0x789A817A, 0x75B6A7A0, 0x70B3AAA5, 0x6CAEA9A5, 0x67AAAAA5, 0x63A9A9A4, 0x5EAAADA5, 0x5AA9ACA4, 0x55A8ABA2, 0x51A9A9A3, 0x51A9A9A3,
  0x4CAAA7A0, 0x51A9A6A0, 0x55A8A59F, 0x5AA9A6A1, 0x5EA5A29D, 0x62B3ABA6, 0x67A5998F, 0x6B796155, 0x70714F41, 0x73825C4F, 0x787A4C43, 0x7D703B37, 0x818F6862, 0x85876157, 0x8A845F54, 0x8E845E54, 0x92876155, 0x96896456, 0x9A876354, 0x9D886252, 0xA18C655A, 
        0xA590675F, 0xA991675E, 0xAD976C65, 0xB09B7167, 0xB4986F64, 0xB79A6F64, 0xBA9E7469, 0xBD9F736B, 0xC0A1716D, 0xC3A1716B, 0xC69E706A, 0xC9A07169, 0xCB9B6B61, 0xCD98685D, 0xD0915D51, 0xD2935E58, 0xD48D5554, 0xD6824947, 0xD7713733, 0xD97F4947, 
        0xDA875753, 0xDB8E625D, 0xDC906761, 0xDD8F615F, 0xDE8C5C5B, 0xDF8D5E58, 0xDF956B60, 0xDF9E756B, 0xDFA47D74, 0xE0AA8680, 0xDFAB8684, 0xDFAD8585, 0xDFAE8384, 0xDEA37676, 0xDEA37675, 0xDD9B6D69, 0xDB976964, 0xDB976A64, 0xD9996C65, 0xD8996661, 
        0xD69B6563, 0xD59B6766, 0xD39A6866, 0xD09F6F6B, 0xCFA27471, 0xCDA87E7A, 0xCAB08884, 0xC7B38782, 0xC5B3837E, 0xC2B2837D, 0xBFB2817B, 0xBCAF7E79, 0xB9AF7F79, 0xB6AD7C75, 0xB2AA7670, 0xAEAC7974, 0xABAB7574, 0xA7A77673, 0xA4A47872, 0xA09B746D, 
        0x9C947066, 0x98926F64, 0x948E6C60, 0x90885F56, 0x8C8A5C57, 0x87A37A74, 0x839F7270, 0x7F98706E, 0x7A8E6C68, 0x76A48E8A, 0x72B4A9A5, 0x6EB1AAA8, 0x69ABA9A6, 0x65ABA8A6, 0x60ACACA6, 0x5CABA8A6, 0x57ACACA4, 0x53ABABA2, 0x4FAAAAA4, 0x4FAAAAA4,
  0x49ABA7A0, 0x4EA9A69F, 0x53A8A29C, 0x57A9A49E, 0x5BADA8A2, 0x5FABA39E, 0x64B5AAA3, 0x69A29389, 0x6D796151, 0x71705141, 0x76694236, 0x7A6C423A, 0x7E8B655E, 0x82876258, 0x86835F53, 0x8A845F54, 0x8E866255, 0x93866454, 0x97866352, 0x9A876452, 0x9E8D655A, 
        0xA2936761, 0xA6946961, 0xA9976F67, 0xAD987166, 0xB0956C61, 0xB4956C61, 0xB79B7366, 0xBA9E7469, 0xBD9F7169, 0xC09E7168, 0xC29D6F66, 0xC5996B62, 0xC794635A, 0xCA97675D, 0xCC94645A, 0xCE96625D, 0xD08D5554, 0xD2834C49, 0xD3743A37, 0xD5713735, 
        0xD6733B37, 0xD7713E38, 0xD874443D, 0xD97A4D48, 0xDA835953, 0xDB8A6159, 0xDB946A60, 0xDB9D7469, 0xDCA1776F, 0xDCA27874, 0xDCA17675, 0xDBA17676, 0xDBA87E7E, 0xDAA47979, 0xDA9E7271, 0xD9996A68, 0xD8996B66, 0xD69E726C, 0xD69E716B, 0xD3966461, 
        0xD3986664, 0xD19D6B6A, 0xCF9A6967, 0xCD9B6866, 0xCB9E6E6B, 0xC9A37573, 0xC6A87A7A, 0xC4B08280, 0xC1B2817E, 0xBEB38381, 0xBBB2827F, 0xB8AF7D7A, 0xB5AF7E7B, 0xB2AD7C79, 0xAEAA7774, 0xABAB7877, 0xA7A77673, 0xA4A2756F, 0xA0A07770, 0x9C99756B, 
        0x98926F65, 0x95916B63, 0x918C675C, 0x8D875D54, 0x898B5D55, 0x84A47975, 0x80A37775, 0x7C9B7674, 0x78876565, 0x73B3A3A1, 0x6FAEA7A2, 0x6BB0ADAB, 0x66ACACA7, 0x62A9A9A3, 0x5EAAAAA5, 0x59ABABA5, 0x54ACACA6, 0x51ACA9A6, 0x4CAAAAA4, 0x4CAAAAA4,
  0x48A9A69F, 0x4CAAA4A0, 0x50ABA59F, 0x54A9A6A0, 0x59ABA5A3, 0x5DACA7A4, 0x62AEA69E, 0x66B1AA9D, 0x6AACA394, 0x6E9F8C7F, 0x739C897B, 0x77AD958D, 0x7B927369, 0x7F88645A, 0x83815F53, 0x87856156, 0x8B856254, 0x8F876353, 0x93866453, 0x97886454, 0x9B8D655A, 
        0x9F93665E, 0xA2956A62, 0xA6956C64, 0xA9966F64, 0xAC956D61, 0xB0977064, 0xB39A7569, 0xB69E7467, 0xB99E7365, 0xBB9D7064, 0xBF9A6D61, 0xC19B6D63, 0xC498685E, 0xC6976760, 0xC7986861, 0xCA986461, 0xCC925A5A, 0xCE87514E, 0xCF7D4442, 0xD1733A36, 
        0xD269302C, 0xD35C2620, 0xD4551F19, 0xD5592923, 0xD6673D36, 0xD7795146, 0xD78C6559, 0xD79A7266, 0xD89E746C, 0xD89E706C, 0xD79F7070, 0xD7A17474, 0xD7A77E7E, 0xD6A57B7B, 0xD6956766, 0xD5885552, 0xD4804C48, 0xD3814E46, 0xD291625A, 0xD093655F, 
        0xCF996B68, 0xCD9D706E, 0xCB9E706E, 0xC9996766, 0xC7986563, 0xC5A57272, 0xC2AC7B7B, 0xC0AE7D7E, 0xBDB08081, 0xBAB07E80, 0xB7AD7B7D, 0xB5AC797B, 0xB1AC787B, 0xAEAC797A, 0xABAB787A, 0xA7A87876, 0xA4A57772, 0xA0A07770, 0x9C9C766E, 0x99957268, 
        0x95916F63, 0x918F695E, 0x8D8C6358, 0x89895D53, 0x858D5D57, 0x81A37A76, 0x7DA17674, 0x79956D6D, 0x75937575, 0x70BAACAA, 0x6CACA7A2, 0x68ADABA9, 0x64ADADAA, 0x5FABABA8, 0x5AACACA9, 0x57ACACA7, 0x52ADAAA7, 0x4EACA9A6, 0x4AACACA5, 0x4AACACA5,
  0x46ABA7A0, 0x4AACA19E, 0x4EA9A39C, 0x52ADA49E, 0x56ABA59F, 0x5AA9A49E, 0x5EAAA59D, 0x62ABA69C, 0x67AFAA9E, 0x6BB0ABA1, 0x70B1AA9E, 0x74B3ADA2, 0x78877267, 0x7C81605A, 0x807D5951, 0x84835E54, 0x88866157, 0x8C866255, 0x90866353, 0x94866354, 0x97896459, 
        0x9B90675F, 0x9E946B62, 0xA2956D62, 0xA6946C60, 0xA9946D61, 0xAC987164, 0xAF9B7465, 0xB29B7265, 0xB59C6E63, 0xB8996B5F, 0xBB95685D, 0xBD9A6D64, 0xC09A6E65, 0xC295675E, 0xC492645C, 0xC693635E, 0xC890605F, 0xCA885855, 0xCB7F4D4B, 0xCD7D4C49, 
        0xCE774843, 0xCF6C3D38, 0xD0653630, 0xD1623630, 0xD25E352C, 0xD2633A31, 0xD3785148, 0xD38D6961, 0xD3936F68, 0xD3947069, 0xD3946E69, 0xD39C7673, 0xD3A07C7A, 0xD297706E, 0xD27C4D49, 0xD16C3633, 0xD067302D, 0xCF763E3B, 0xCD885551, 0xCB946160, 
        0xCB996567, 0xC99D696B, 0xC7A06C6E, 0xC5A26E70, 0xC39E6969, 0xC1A37070, 0xBEA87575, 0xBCAA7679, 0xB9AF7B80, 0xB7AA787D, 0xB4A9777A, 0xB1AB7B7D, 0xAEA67677, 0xAAA67878, 0xA7A87B78, 0xA4A57774, 0xA0A57874, 0x9DA37974, 0x999C756D, 0x95947068, 
        0x91916C62, 0x8E90695E, 0x8A8D655A, 0x86885D51, 0x828D6056, 0x7E9F7971, 0x7A946E68, 0x76886561, 0x71AD9996, 0x6DB3A7A5, 0x69B0AEA9, 0x65ABA8A6, 0x61AAAAA7, 0x5CABABA8, 0x58AAAAA7, 0x53ABAEA8, 0x50A8ABA5, 0x4CA7AAA4, 0x48A9A9A6, 0x48A9A9A6,
  0x43ABA39B, 0x47ACA19A, 0x4BADA39C, 0x4FADA49D, 0x54A9A39A, 0x58A7A79C, 0x5CA6A69D, 0x60A6A69C, 0x64A8A89E, 0x68A4A49A, 0x6CA5A59B, 0x70A7A79E, 0x75887D75, 0x79846662, 0x7D825F5B, 0x8183605C, 0x8589635D, 0x89876259, 0x8C886457, 0x90886656, 0x94896757, 
        0x978B685C, 0x9B936D62, 0x9E956F62, 0xA2956D61, 0xA5967062, 0xA8987163, 0xAB9C7263, 0xAE9D7166, 0xB19B6D64, 0xB495665E, 0xB796665D, 0xB9966A61, 0xBB986C61, 0xBE92675B, 0xC08D6357, 0xC28D625A, 0xC4895D59, 0xC6865957, 0xC7825753, 0xC97E514E, 
        0xCA7A4F4B, 0xCB714843, 0xCC6C423C, 0xCD69403B, 0xCD633A34, 0xCE5E362E, 0xCF674139, 0xCF7D5B53, 0xCF86675F, 0xCF876962, 0xCF86675F, 0xCF8F716B, 0xCF8F6D67, 0xCE89635E, 0xCD825854, 0xCD845955, 0xCC7E504D, 0xCB835250, 0xC98D5B5A, 0xC89A686A, 
        0xC69E656B, 0xC5A1696E, 0xC3A16A6F, 0xC1A67175, 0xBEA26D6F, 0xBDA06D6D, 0xBAA57473, 0xB8A87678, 0xB5AC797E, 0xB3AB7B7E, 0xB0AB7E80, 0xADAB817F, 0xAAA57876, 0xA7A17672, 0xA3A37B75, 0xA0A27470, 0x9DA37373, 0x99A27572, 0x959B726D, 0x92977168, 
        0x8E906B62, 0x8A8D655A, 0x878D6356, 0x82896052, 0x7F886252, 0x7B907163, 0x778D6F64, 0x739F8B84, 0x6FBBB0AB, 0x6AB1ACA5, 0x66AFACA7, 0x62AEABA9, 0x5EADAAA8, 0x5AACACA6, 0x56A8ABA5, 0x51ACAFA9, 0x4DA8ACA5, 0x49ABAEA7, 0x45A9ADA6, 0x45A9ADA6,
  0x41A8A49C, 0x45A9A69A, 0x49ABA79D, 0x4DA8A59B, 0x51A6A399, 0x55A8A89F, 0x59A8A89D, 0x5DA7A79C, 0x61A7A79D, 0x65A6A69C, 0x69A6A69D, 0x6DAAAA9E, 0x7192847E, 0x75795D56, 0x797E6058, 0x7D86635D, 0x8187605A, 0x85876157, 0x89876255, 0x8C886455, 0x90886458, 
        0x9489655B, 0x97926B5F, 0x9A946E61, 0x9E956F60, 0xA1997165, 0xA49B7264, 0xA7997061, 0xAA9A6F63, 0xAD976962, 0xB092645C, 0xB395675F, 0xB5976B62, 0xB7966C62, 0xBA8F655B, 0xBC895E55, 0xBE8B5D58, 0xC0855554, 0xC1865755, 0xC3855857, 0xC4805350, 
        0xC5815551, 0xC77D534F, 0xC8764945, 0xC970423F, 0xC9693C38, 0xCA643732, 0xCA5B2E29, 0xCB653A35, 0xCB6E4641, 0xCB704C44, 0xCB78524C, 0xCA7F5A54, 0xCA7B544E, 0xC9815A55, 0xC97F5551, 0xC8815652, 0xC7835855, 0xC68A5E5C, 0xC58C605E, 0xC4986668, 
        0xC29D666A, 0xC1A16C70, 0xBF9F6B6E, 0xBDA47374, 0xBBA17070, 0xB99E6E6D, 0xB5A17170, 0xB4A47375, 0xB1A87678, 0xAEA9777A, 0xACAA7C7C, 0xA9A97E7C, 0xA5A47976, 0xA3A07871, 0x9FA07871, 0x9CA17370, 0x99A27270, 0x95A07572, 0x929A726B, 0x8E947066, 
        0x8A8F6C61, 0x878D675C, 0x838B6257, 0x7F80584A, 0x7B8A695F, 0x77AF978F, 0x73B7A39F, 0x6FBBAEA9, 0x6BB2A8A4, 0x67AFAAA7, 0x63A9A9A4, 0x5FB0AEAB, 0x5BADA8A5, 0x57ACA9A7, 0x53A8ABA5, 0x4FAAAAA4, 0x4BAAAAA6, 0x46AEAEA7, 0x43ABABA7, 0x43ABABA7,
  0x3EA4A498, 0x42A5A59E, 0x46A7A79C, 0x4AA5A59A, 0x4EA6A69C, 0x52A7A79E, 0x56A5A59C, 0x5AA6A69E, 0x5EA8A89D, 0x62A3A39C, 0x66A7A79D, 0x6AA8A89C, 0x6E9A918A, 0x72765D56, 0x767F635A, 0x7A896A62, 0x7D88615B, 0x81876058, 0x85856155, 0x89876453, 0x8C8A6559, 
        0x908A665A, 0x938F695D, 0x97926D5F, 0x9A946C61, 0x9D987164, 0xA09B7465, 0xA3986E5F, 0xA695695E, 0xA9946660, 0xAC94645D, 0xAE946760, 0xB1946961, 0xB293685F, 0xB58E635C, 0xB7885D54, 0xB9895B56, 0xBB895757, 0xBD885755, 0xBF875756, 0xC0855754, 
        0xC1875958, 0xC2855756, 0xC380514F, 0xC47F4F4C, 0xC57B4A49, 0xC6794846, 0xC66A3935, 0xC6663731, 0xC6633431, 0xC6633731, 0xC66C403A, 0xC6714642, 0xC6744845, 0xC5845B57, 0xC4825955, 0xC4825955, 0xC3875D5B, 0xC28D6663, 0xC18D6563, 0xBF966769, 
        0xBE9A6569, 0xBC9D696D, 0xBA9E6C6E, 0xB8A17273, 0xB69E706E, 0xB49D6F6C, 0xB29D6F6C, 0xB09F7070, 0xADA67578, 0xAAA67878, 0xA7A57978, 0xA5A67C78, 0xA1A57C76, 0x9FA17B71, 0x9BA07971, 0x98A17873, 0x95A27270, 0x92A07672, 0x8E9B746E, 0x8B946D64, 
        0x87906B61, 0x838D685D, 0x7F8C6458, 0x7C7B5447, 0x78967A74, 0x74C5B3AF, 0x70B7ACA7, 0x6CB3A9A7, 0x68ADA9A6, 0x64ADADAA, 0x60A9A9A6, 0x5CB1AEAB, 0x58B0AAA7, 0x53B2ABA8, 0x4FADADA7, 0x4CAAAEA7, 0x48A9A9A6, 0x44ACACA5, 0x40ABABA3, 0x40ABABA3,
  0x3CA5A59D, 0x3FA5A59D, 0x43A7A79B, 0x47A5A59A, 0x4BAAAA9F, 0x4FA7A79D, 0x53A5A59C, 0x57A7A79B, 0x5BA8A89C, 0x5FA6A69B, 0x63A4A49A, 0x66A7A79D, 0x6BA19A93, 0x6F77625B, 0x727F665D, 0x76886C63, 0x7A87645B, 0x7E876058, 0x81876256, 0x85876355, 0x89896459, 
        0x8C8A655B, 0x8F8E695C, 0x93916B5D, 0x96956E60, 0x999A7466, 0x9C9C7568, 0x9F98705E, 0xA295695C, 0xA593675D, 0xA791645C, 0xAA91665E, 0xAC8E635A, 0xAF8B6158, 0xB18B6159, 0xB3896056, 0xB5875B55, 0xB78C5A5A, 0xB88B5859, 0xBA8B5959, 0xBB8D5B5C, 
        0xBC8C5A5A, 0xBE8C5B5C, 0xBF8A5757, 0xC0865351, 0xC0875453, 0xC18D5B5B, 0xC18B5B5B, 0xC2885957, 0xC1845351, 0xC27F4F4E, 0xC2835351, 0xC2865A57, 0xC1895B59, 0xC18B605D, 0xBF8A5F5D, 0xBF875F5B, 0xBE8B6460, 0xBD8F6965, 0xBC8F6A66, 0xBA956969, 
        0xB999666A, 0xB79A686B, 0xB69B6B6E, 0xB3A07373, 0xB19C706E, 0xB09B716E, 0xAD9B716E, 0xAB9A6E6C, 0xA99C6F6D, 0xA69D726F, 0xA3A27875, 0xA1A47B74, 0x9DA57E76, 0x9BA27E74, 0x98A07B6F, 0x94A37A73, 0x91A17571, 0x8EA17774, 0x8A9C7770, 0x87947067, 
        0x83916C62, 0x80896759, 0x7C896254, 0x78745045, 0x74927C78, 0x70BCB1AC, 0x6DB1A7A3, 0x68ADABA6, 0x65ABADA8, 0x61ACACAA, 0x5DA9ACA9, 0x59AEAEAB, 0x55AEA8A5, 0x51ACA9A6, 0x4DACACA5, 0x49ABAEA7, 0x45ADADA9, 0x41ACACA8, 0x3DABABA7, 0x3DABABA7,
  0x39A5A59C, 0x3DA3A79A, 0x41A4A49C, 0x44A5A89D, 0x48A9A99F, 0x4CA7A79D, 0x50A8A89B, 0x54A6A69D, 0x58A7A79C, 0x5CA8A89D, 0x60A4A49C, 0x63A9A99F, 0x67AAA59E, 0x6B74635A, 0x6F7D675D, 0x72856862, 0x768A675F, 0x7A876459, 0x7E876254, 0x81876456, 0x85896759, 
        0x888E685F, 0x8B906B5F, 0x8F936C61, 0x92977163, 0x95997466, 0x989B7365, 0x9B966D5D, 0x9E94685D, 0xA1946863, 0xA3976B65, 0xA6956C64, 0xA8906860, 0xAA8D645B, 0xAC885E55, 0xAE875E56, 0xB08A5D59, 0xB28F5B5B, 0xB48B5657, 0xB58C5556, 0xB7905B5D, 
        0xB7935E5F, 0xB9925B5E, 0xBA8E5759, 0xBB8E5558, 0xBC945B5E, 0xBC9D6A6D, 0xBD9C6B6C, 0xBD976567, 0xBD976567, 0xBD946363, 0xBD946464, 0xBD976868, 0xBC986969, 0xBC956767, 0xBB956A68, 0xBA956968, 0xB98F6865, 0xB8936E6A, 0xB78F6B66, 0xB6936967, 
        0xB4966869, 0xB3956667, 0xB1976969, 0xAF986E6C, 0xAD9A716C, 0xAB9A746F, 0xA99A736D, 0xA79B726D, 0xA4996F6C, 0xA1996E69, 0x9FA07871, 0x9CA37D73, 0x99A47E74, 0x96A37F73, 0x939F7A6E, 0x90A17871, 0x8DA07573, 0x8AA07773, 0x869D7972, 0x83957268, 
        0x7F926E64, 0x7C8B685A, 0x78896556, 0x746F4E46, 0x71A49290, 0x6DBAAEAC, 0x69B0ABA6, 0x65ABABA6, 0x61AAACAA, 0x5EAAADAA, 0x5AACACA9, 0x55B1AEAB, 0x52B0AAA7, 0x4EACACA6, 0x4AACAFA8, 0x46ABAEAB, 0x43ABABA7, 0x3EACACA8, 0x3BACACA8, 0x3BACACA8,
  0x37A6A698, 0x3AA6A69E, 0x3EA4A49C, 0x41A4A89C, 0x46A3A79C, 0x49A7A79D, 0x4DA8A89E, 0x51A6A69D, 0x55A5A59C, 0x58A7A79E, 0x5CA6A69D, 0x60A9A99F, 0x64AFAAA3, 0x6875665F, 0x6B7B665C, 0x6F80645B, 0x7389655F, 0x76856158, 0x7A855E51, 0x7D886355, 0x81896658, 
        0x848E6A5E, 0x878E695E, 0x8B926B60, 0x8D997366, 0x909B7668, 0x949C7467, 0x97976E5E, 0x9A966B5F, 0x9C956965, 0x9E946A65, 0xA1916661, 0xA38F655F, 0xA6896058, 0xA8815951, 0xAA825852, 0xAC865754, 0xAD885052, 0xAF834B4C, 0xB184494C, 0xB284484B, 
        0xB38B4C50, 0xB48D5053, 0xB5905456, 0xB6985D62, 0xB7975A5E, 0xB89A6064, 0xB8996064, 0xB8975F61, 0xB89A6467, 0xB8996164, 0xB8976366, 0xB89E686B, 0xB8A06B6E, 0xB79F6C6F, 0xB69F6E70, 0xB69E7171, 0xB5906463, 0xB4956C6B, 0xB38F6964, 0xB1926967, 
        0xB0926767, 0xAE936667, 0xAD936868, 0xAB956E69, 0xA897716C, 0xA7997670, 0xA59A7570, 0xA29B7771, 0xA097706A, 0x9E926860, 0x9B9A726A, 0x989E796F, 0x959F7B70, 0x92A07B71, 0x8FA17E71, 0x8CA37972, 0x899F7571, 0x869F7772, 0x829C7971, 0x7F96746A, 
        0x7B906F63, 0x788B6A5D, 0x748C6959, 0x716C483F, 0x6DB1A09E, 0x69B5ABA9, 0x66AFACA7, 0x62A9ABA3, 0x5EADB0AA, 0x5AA9ACA6, 0x57ACACA9, 0x53AEABA5, 0x4FADAAA7, 0x4BADADAA, 0x47ACAFA8, 0x44A8B0A8, 0x40A7AFA7, 0x3CAAAAA5, 0x39A9A9A5, 0x39A9A9A5,
  0x34A6A69C, 0x37A6A69D, 0x3BA4A49B, 0x3FA5A599, 0x43A7A79B, 0x46A7A79C, 0x4AA5A59A, 0x4EA6A69C, 0x51A6A69D, 0x55A5A59C, 0x59A5A59A, 0x5DA7A79C, 0x60AEA9A4, 0x64877770, 0x68786258, 0x6B82665C, 0x6F896760, 0x7288645B, 0x76856154, 0x79886456, 0x7D8A6659, 
        0x808D675D, 0x838B665B, 0x86926C5F, 0x899A7568, 0x8C9C7669, 0x8F9E796A, 0x929C7464, 0x95986F64, 0x98946C67, 0x9A966C66, 0x9D906661, 0x9F885E58, 0xA1744840, 0xA370433C, 0xA5795048, 0xA7794542, 0xA9783A3C, 0xAB783A3D, 0xAC7A3C3F, 0xAD7C3A3D, 
        0xAF7E3B3F, 0xB0813D42, 0xB1854248, 0xB28A464B, 0xB2915055, 0xB39A5F63, 0xB3A1676D, 0xB3A0676B, 0xB49C6266, 0xB4996164, 0xB49B6466, 0xB3A0676B, 0xB3A3666B, 0xB3A1676D, 0xB2A16C6F, 0xB1A17071, 0xB09E7373, 0xAF956B69, 0xAE936A67, 0xAC8F6463, 
        0xAB936868, 0xAA936969, 0xA7946B6A, 0xA6956F6E, 0xA499746F, 0xA2997872, 0xA0987770, 0x9E9C7A72, 0x9B98746A, 0x98946F65, 0x969A756B, 0x949E7A6E, 0x90A17D71, 0x8EA28074, 0x8BA28073, 0x88A27B73, 0x85A07672, 0x829C756F, 0x7E99776F, 0x7B927367, 
        0x788E6E63, 0x748C6B5E, 0x708C6A5A, 0x6D724F45, 0x69BAA9A6, 0x66B4AAA5, 0x62B0AEA6, 0x5FABAEA3, 0x5BAAB0A5, 0x57ACAFA7, 0x53AEABA5, 0x50AEABA5, 0x4CAAAAA7, 0x48ADADA9, 0x44A8B0A8, 0x41A8B0A8, 0x3DABB3AB, 0x39A9B2A9, 0x36A9AEA5, 0x36A9AEA5,
  0x32A8A399, 0x34A6A69C, 0x38A8A39A, 0x3CAAA59D, 0x40A7A79B, 0x43A7A79B, 0x47A8A59A, 0x4AA8A89E, 0x4EA9A99F, 0x52A7A79E, 0x55A8A89C, 0x59A5A59A, 0x5DACA7A1, 0x60998984, 0x64755E59, 0x68846B62, 0x6B87665F, 0x6F846459, 0x72815F50, 0x75826352, 0x79866458, 
        0x7C8D6A5E, 0x7F8C685C, 0x82916960, 0x859A7669, 0x889D776A, 0x8BA17A6D, 0x8E9F776B, 0x919A7167, 0x93997269, 0x9699736B, 0x988C6258, 0x9A80544A, 0x9C633228, 0x9F562419, 0xA1633429, 0xA2672F28, 0xA4692928, 0xA66F3032, 0xA7733539, 0xA8692830, 
        0xAA67252D, 0xAB6E2F34, 0xAC74383B, 0xAC803C42, 0xAD823640, 0xAE833843, 0xAE94505A, 0xAFA3666F, 0xAFA56972, 0xAEA3666E, 0xAFA2666E, 0xAEA4666E, 0xAEA3616C, 0xADA16169, 0xADA0656B, 0xAC9C6469, 0xABA37172, 0xAA9A696A, 0xA99D7070, 0xA895696B, 
        0xA6976C6E, 0xA5936A6A, 0xA3956E6B, 0xA295716D, 0x9F967671, 0x9E977872, 0x9B967B74, 0x99987A74, 0x97987870, 0x9499766F, 0x919A7870, 0x8FA07E75, 0x8DA28178, 0x8AA38277, 0x879F7D70, 0x849E7B71, 0x819D7A70, 0x7D9B766E, 0x7A98756A, 0x77957168, 
        0x748C6B60, 0x708C6C61, 0x6D87685A, 0x697D6559, 0x66BBB1AC, 0x62B3ABA3, 0x5FAEABA3, 0x5BADADA5, 0x57A9ACA4, 0x53ABAEA5, 0x50ABABA5, 0x4CAEAEA7, 0x49ABAEAB, 0x45ADB1A9, 0x41ACB0A8, 0x3EA8ACA4, 0x3AABAFA6, 0x37ABAFA6, 0x33AAAFA5, 0x33AAAFA5,
  0x2FA8A29D, 0x32A8A399, 0x36A5A597, 0x39A9A59C, 0x3DA7A39A, 0x40A7A39B, 0x44A8A599, 0x47A8A59D, 0x4BADAA9F, 0x4FA7A49D, 0x52A7A79B, 0x56A5A59C, 0x59ABA5A0, 0x5DA79996, 0x6079645F, 0x64826860, 0x6785655D, 0x6B87685C, 0x6E816555, 0x71806753, 0x75886C5D, 
        0x7887675D, 0x7B886559, 0x7E8F6D60, 0x81977468, 0x839D786C, 0x86A17B70, 0x89A1786D, 0x8C9C7669, 0x8E9B7669, 0x919A7569, 0x93987064, 0x96936B5F, 0x98805547, 0x9A704033, 0x9C5C281B, 0x9D551B11, 0x9F591813, 0xA15A1A1A, 0xA25E1D25, 0xA44F0D18, 
        0xA5490A14, 0xA64E1316, 0xA6521A18, 0xA8621F24, 0xA86B1B28, 0xA9762B37, 0xA97E333F, 0xAA873F4B, 0xAA904955, 0xAA8D4651, 0xAA8D4652, 0xAA8E4554, 0xA9904654, 0xA8924B59, 0xA893515A, 0xA793535B, 0xA793585C, 0xA5986164, 0xA4996467, 0xA3956568, 
        0xA2996F72, 0xA0986F70, 0x9E987372, 0x9D916E6A, 0x9A8F706B, 0x99907570, 0x97907872, 0x94957A73, 0x929A7974, 0x90997A73, 0x8D9E7F78, 0x8BA2837C, 0x88A28279, 0x85A28178, 0x829E7F73, 0x7F9C7C70, 0x7D9B7C70, 0x799B796D, 0x76997467, 0x73946E65, 
        0x708A685D, 0x6C8B6C63, 0x697B5E54, 0x6696847D, 0x62B8B3AB, 0x5EB2ADA5, 0x5BADADA5, 0x58ADADA4, 0x54ACAFA6, 0x50AEB2A5, 0x4DAFAFA5, 0x49AEAEAB, 0x45ADB1AD, 0x42ADADA9, 0x3EACACA8, 0x3BACACA8, 0x37AFAFAB, 0x33AFAFAA, 0x31ABABA6, 0x31ABABA6,
  0x2CA7A29C, 0x30A49F99, 0x33A5A596, 0x36A9A59B, 0x3AA6A299, 0x3DA7A39A, 0x41A8A49C, 0x44A8A59D, 0x48A9A69F, 0x4BAAA69C, 0x4EA6A69C, 0x52A7A79B, 0x56A5A29C, 0x59ABA3A0, 0x5D80706A, 0x607C645F, 0x6380645C, 0x6785655B, 0x6A846456, 0x6D846451, 0x7189695C, 
        0x7489665B, 0x778B685C, 0x7A906C62, 0x7D947066, 0x80997569, 0x82A27B6F, 0x85A47C72, 0x87A78176, 0x8AA17D72, 0x8D977166, 0x8F956E63, 0x91916A5E, 0x938A5F53, 0x958A5F53, 0x977F5244, 0x9977453A, 0x9A703833, 0x9C682D2C, 0x9D6E3338, 0x9F6E333B, 
        0xA06D323A, 0xA16E3237, 0xA2692F30, 0xA267252A, 0xA3550C15, 0xA4560C15, 0xA4611A23, 0xA56D2831, 0xA5702B34, 0xA56E2932, 0xA4743039, 0xA478333E, 0xA477303A, 0xA478313C, 0xA3833F49, 0xA287484C, 0xA2804346, 0xA0874A4D, 0x9F86494C, 0x9E8F5B5E, 
        0x9D905F64, 0x9B966A6C, 0x9A8F6666, 0x97774D49, 0x967F5A55, 0x94866760, 0x928C7168, 0x9096786F, 0x8E98766E, 0x8B99786F, 0x88A08175, 0x86A58579, 0x84A28377, 0x81A18276, 0x7E9F7F71, 0x7B9B7A6B, 0x789F7D70, 0x759E7970, 0x72976F66, 0x6F946B62, 
        0x6C8F6A63, 0x6889665F, 0x6576554B, 0x61B4A59F, 0x5EB5ADA8, 0x5BB0ADA5, 0x57ACACA4, 0x54ACAFA3, 0x50ABAEA5, 0x4DACAFA5, 0x49AEAEA7, 0x46AEAEA7, 0x43ABABAB, 0x3FA9A9A9, 0x3BACACA8, 0x38ACACA8, 0x35A8ADA8, 0x31ABABA6, 0x2EABABA6, 0x2EABABA6,
  0x29A7A79B, 0x2DA4A498, 0x30A4A499, 0x34A6A697, 0x37A6A698, 0x3AABA69E, 0x3DABA79E, 0x41A8A49C, 0x45A6A69A, 0x48A6A69B, 0x4BA6A69C, 0x4FA7A79D, 0x52A7A7A1, 0x56ABA59F, 0x597D6F66, 0x5C7F6963, 0x60846A5F, 0x6289685D, 0x668C665A, 0x69896557, 0x6C886559, 
        0x70836156, 0x73866156, 0x758F6A61, 0x78946E63, 0x7B997367, 0x7E9F796F, 0x81A58074, 0x83A8837A, 0x85A27E72, 0x889B756A, 0x8A9A7368, 0x8C987267, 0x8E90675B, 0x908D6356, 0x9284584A, 0x94825449, 0x967C4A45, 0x97723C3A, 0x99774042, 0x9A783E43, 
        0x9B743B3F, 0x9C75393D, 0x9D74383A, 0x9D7B3D42, 0x9E78363E, 0x9F76343C, 0x9F6B2630, 0xA06C262F, 0xA06D2931, 0xA05D161F, 0xA0591119, 0x9F510C14, 0x9F4E0B11, 0x9F530E16, 0x9E5E1C21, 0x9D642225, 0x9D713033, 0x9B7B3E3F, 0x9A763839, 0x996D3135, 
        0x98693035, 0x96754042, 0x95703F3F, 0x935B2726, 0x916E423B, 0x8F79534C, 0x8D8A6A61, 0x8B9D7E73, 0x899C786F, 0x879C7A6E, 0x84A48375, 0x82A48579, 0x7FA48476, 0x7CA18372, 0x7A9E7F70, 0x779C796D, 0x74A27A71, 0x719F7970, 0x6E966C65, 0x6B936B63, 
        0x678F6A62, 0x6487665E, 0x6183665E, 0x5EBDB0AA, 0x5BB3AAA5, 0x57B2ACA7, 0x54AFAFA6, 0x51ACAFA6, 0x4DAFAFA8, 0x49AEB1A7, 0x46AEB2A7, 0x43AEAEAB, 0x3FADADA9, 0x3CAEAEAA, 0x38ACACAC, 0x35ADADA8, 0x31B0B0AB, 0x2EB1B1AB, 0x2BABB1A6, 0x2BABB1A6,
  0x27A9A39C, 0x2AA9A397, 0x2EA6A095, 0x31A6A696, 0x34A6A69C, 0x37ABA69D, 0x3BA8A49B, 0x3EA8A49C, 0x41A8A89C, 0x45A6A69A, 0x48A6A69B, 0x4BA6A69C, 0x4FA4A79A, 0x52A7A49E, 0x556F6357, 0x587C685F, 0x5C846660, 0x5F86635B, 0x628C625B, 0x658A6258, 0x688B645A, 
        0x6B7E554C, 0x6E7C5549, 0x718D695E, 0x74926D62, 0x779A756B, 0x7A9C776C, 0x7CA17F72, 0x7EA37F73, 0x819D786C, 0x839B766A, 0x85967065, 0x88956E63, 0x8A8F675C, 0x8B8B6256, 0x8D875B4F, 0x8F83594E, 0x9082544F, 0x927D4C49, 0x947F4B48, 0x957C4646, 
        0x967C4244, 0x977A3E41, 0x987D3F42, 0x9885444C, 0x9989444F, 0x9A914F59, 0x9A8A4550, 0x9B894450, 0x9B88414D, 0x9B833C48, 0x9B894450, 0x9A854650, 0x9A7F464D, 0x997C444A, 0x99773D40, 0x9873383C, 0x98733738, 0x966E2F31, 0x95723333, 0x94682B30, 
        0x92743940, 0x92824E50, 0x908F5F61, 0x8E906462, 0x8C936964, 0x8B8B6259, 0x898B665B, 0x8699756A, 0x849C776C, 0x82A07D71, 0x80A58377, 0x7DA7867A, 0x7AA58575, 0x78A18170, 0x759E806E, 0x739F7B70, 0x709E7A71, 0x6D9C746D, 0x6A976E67, 0x67916A65, 
        0x648C6863, 0x607C5C54, 0x5D9C837E, 0x5ABAAFAC, 0x57B2A9A9, 0x53B2AEA8, 0x50AEAEA8, 0x4DAFAFA8, 0x49AEB1AB, 0x46AEB2AB, 0x43AEAEA7, 0x3FADADA9, 0x3CAEAAAA, 0x39B2AEA9, 0x36AEA9A5, 0x32ADADA8, 0x2FADADA8, 0x2CADADA7, 0x28ABABA5, 0x28ABABA5,
  0x24A9A99B, 0x28A5A598, 0x2BA6A69A, 0x2EA6A69B, 0x31ABA69C, 0x34ABA69C, 0x37A6A69D, 0x3AABA69E, 0x3EACA8A0, 0x41A8A89C, 0x44A8A89D, 0x48A9A99F, 0x4BA6AA9C, 0x4EA6A69C, 0x52696053, 0x55756057, 0x58846862, 0x5B89645F, 0x5E8C645E, 0x618D665B, 0x648E665E, 
        0x67876056, 0x6A845D51, 0x6D8B665A, 0x70936C61, 0x72956F64, 0x75957063, 0x779E7C6D, 0x7AA58377, 0x7C9F7B6E, 0x7F9E786C, 0x81977066, 0x83977064, 0x8593695D, 0x878D6356, 0x898B6055, 0x8A885A50, 0x8C865953, 0x8D885852, 0x8E885550, 0x8F85504C, 
        0x91834D4B, 0x927F4547, 0x937E4146, 0x9486434D, 0x948D414F, 0x95914755, 0x95914653, 0x95964C5C, 0x95934958, 0x95964C5C, 0x959B5361, 0x9593555E, 0x95885258, 0x94895259, 0x94844D50, 0x937E4548, 0x92824A4C, 0x9282494A, 0x90844A4C, 0x8F895057, 
        0x8E8F5960, 0x8C98676D, 0x8B9D6F71, 0x899C6F6D, 0x889B706A, 0x86997268, 0x849E776E, 0x81A17A70, 0x80A37D75, 0x7DA78076, 0x7BA58075, 0x78A78578, 0x76A48374, 0x749D816F, 0x719D7E6E, 0x6E9D7C71, 0x6C9B766E, 0x6998716A, 0x6698706B, 0x6395716B, 
        0x608C6F67, 0x5D785D54, 0x59B7A8A3, 0x56B7ABA8, 0x53B5AEAB, 0x50B2AEAB, 0x4DAFAFA8, 0x49AEB1AB, 0x46AEB2AB, 0x43ABAEA7, 0x3FADADA9, 0x3CB2AEAA, 0x39B2A9A9, 0x36B3AEA9, 0x32B2ADA8, 0x30AFA9A9, 0x2CADADA7, 0x29ADADA7, 0x26A7AEA7, 0x26A7AEA7,
  0x22A5A59D, 0x25A5A597, 0x28A5A598, 0x2BA6A69A, 0x2EA6A69B, 0x31A6A69C, 0x34A6A69C, 0x38A8A39A, 0x3AABA69E, 0x3EA8A49C, 0x41A8A89C, 0x44A8A89D, 0x47A8A89D, 0x4BA39F92, 0x4D6D5F52, 0x516D574E, 0x5482675D, 0x5786635D, 0x5A8A635D, 0x5D8B655D, 0x608C645C, 
        0x638D665C, 0x658F675D, 0x688E645A, 0x6B8E685C, 0x6E8C6557, 0x70936F61, 0x72977364, 0x75A28275, 0x789C786C, 0x7A9A756A, 0x7C956C62, 0x7E976F62, 0x80936B5D, 0x828D6358, 0x838B6255, 0x85895954, 0x878B5A58, 0x888E5D57, 0x898D5D55, 0x8B8C5B54, 
        0x8C8A5751, 0x8D854F4F, 0x8D814B4F, 0x8E894B54, 0x8F893C4A, 0x908F4551, 0x90924A56, 0x90944D5A, 0x909B5663, 0x909B5663, 0x90944D5A, 0x8F93515C, 0x908F535C, 0x8F8E535A, 0x8F8C5157, 0x8E864C50, 0x8D8C5658, 0x8C8D595C, 0x8B926060, 0x8A9A6A6E, 
        0x899E6B73, 0x87A37276, 0x86A37375, 0x84A27371, 0x82A0736D, 0x81A1786E, 0x7FA27A6E, 0x7DA57A72, 0x7BAB827E, 0x78AB837F, 0x76A8817B, 0x74A48178, 0x72A07C71, 0x6F9B7B70, 0x6C9B7D6C, 0x6A99786C, 0x6796766F, 0x6496726B, 0x6195706B, 0x5E92716C, 
        0x5C795E55, 0x598F7D72, 0x56C0B4AE, 0x52B3AAA7, 0x4FB4AAAA, 0x4CB1AEAA, 0x49AEAEA7, 0x46AEAEAB, 0x43ABAEA7, 0x40ABAFA7, 0x3CAEAEAA, 0x38B1ACAC, 0x36B3A9A9, 0x33B4AAAA, 0x2FB2ADAD, 0x2CB3ADAD, 0x29ADADA7, 0x26AEAEA7, 0x23AEAEA7, 0x23AEAEA7,
  0x1FA4A49C, 0x22A5A59D, 0x25A5A597, 0x28A5A598, 0x2BA6A69A, 0x2EA6A69B, 0x31A6A69C, 0x34A6A69C, 0x38A8A39A, 0x3AA6A69E, 0x3DABAB9E, 0x41A8A89C, 0x44A8A59D, 0x47A8A196, 0x4A6A5C4F, 0x4D70594F, 0x507C5F59, 0x5387655F, 0x568B6761, 0x5989615B, 0x5C875E58, 
        0x5F8E655D, 0x628F685D, 0x648E665B, 0x678F675B, 0x69916A5B, 0x6C947163, 0x6E987567, 0x719D7B6E, 0x729E786D, 0x759C756A, 0x77956D62, 0x79976F62, 0x7B926B5F, 0x7D8E6657, 0x7F8C6256, 0x808D5D59, 0x81915C5C, 0x838D5B55, 0x858D5952, 0x85916157, 
        0x878D5C54, 0x878B5A58, 0x8987595B, 0x898B555D, 0x8A8A4750, 0x8A91505C, 0x8B90505B, 0x8B8C4B56, 0x8B92545D, 0x8B94565F, 0x8B94565F, 0x8B965660, 0x8A93525C, 0x8A91505A, 0x8994575E, 0x89925B5E, 0x88956164, 0x87966567, 0x86996A6A, 0x85A06E74, 
        0x84A26F77, 0x82A67579, 0x81A7767A, 0x7FA87878, 0x7EA77973, 0x7CA6786E, 0x7AA5776A, 0x78A57872, 0x76AA7F7F, 0x74AA8181, 0x71A8827E, 0x70A37F78, 0x6D9E7B72, 0x6B9D7B6F, 0x68977A6E, 0x6696786E, 0x6395766E, 0x6094716C, 0x5D91706A, 0x5A876B65, 
        0x57786057, 0x55B4A89F, 0x52B6ADA7, 0x4FB1AAA7, 0x4BB7ADAD, 0x48B4ADAD, 0x45B1ADAD, 0x42ADB1AD, 0x3FADB1AD, 0x3CAEAEAA, 0x39AEAEA9, 0x36AEA9A9, 0x33AFAAAA, 0x2FB8ADAD, 0x2DAFA9A9, 0x29B4ADAD, 0x27A9A9A9, 0x23AEAEAE, 0x20AFAFA7, 0x20AFAFA7,
  0x1DA7A79E, 0x1FA4A49C, 0x23A0A798, 0x25A5A597, 0x28A5A598, 0x2BABA69A, 0x2EA6A69B, 0x31A6A69C, 0x34A6A69C, 0x37A6A69D, 0x3AABABA2, 0x3DA7A79E, 0x40A7A79B, 0x43A79F98, 0x46695B4C, 0x49735A4C, 0x4C755A4D, 0x4F846356, 0x5285665D, 0x55815D57, 0x57866057, 
        0x5A8D685D, 0x5D8E685D, 0x608F6A5C, 0x628F685D, 0x658D695A, 0x678A6556, 0x6A927060, 0x6C977665, 0x6E987365, 0x70957366, 0x72936B5F, 0x74946D62, 0x7692695C, 0x78906356, 0x7A8E6053, 0x7B906159, 0x7D945F5B, 0x7E8F5C56, 0x7F906054, 0x81916258, 
        0x828D6056, 0x838D625D, 0x84895E5A, 0x848C5E5E, 0x84925C60, 0x858F595D, 0x868A5359, 0x868A575B, 0x86885357, 0x86885359, 0x868A575B, 0x8690595F, 0x85945B63, 0x85966167, 0x859A656A, 0x849C6C6E, 0x839D6E70, 0x829E7171, 0x81A17474, 0x80A37375, 
        0x7FA27074, 0x7DA57478, 0x7CA87B7B, 0x7AA77977, 0x79A57B73, 0x77A67C71, 0x75A47B6C, 0x73A57B72, 0x71A6807B, 0x6FA7807D, 0x6DA38079, 0x6BA17E77, 0x699D7B71, 0x669B7D73, 0x649B7A70, 0x6197786E, 0x5F96756D, 0x5C906E69, 0x598F6F6C, 0x56796158, 
        0x53968780, 0x51B9B2AC, 0x4DB2AFA8, 0x4BADAAA6, 0x48B1ADA9, 0x44B4B0AC, 0x42ADADA9, 0x3FADADA9, 0x3CAEB2AA, 0x39AEAEA9, 0x36AEAEA9, 0x32B2B2AD, 0x30AFA9A9, 0x2CB3ADAD, 0x29ADADA7, 0x27B0B0A9, 0x24B1B1A9, 0x21B1B1A9, 0x1EB2B2AA, 0x1EB2B2AA,
  0x1AA6A69C, 0x1DA7A79E, 0x209FA797, 0x22A5AC9D, 0x25A5AC9E, 0x28A5A59F, 0x2BA6A69A, 0x2EA6A69B, 0x30A9A99F, 0x34A6A69C, 0x37A2A698, 0x3AA6A699, 0x3DA7A79E, 0x3FA9A199, 0x426F6051, 0x45725849, 0x48715443, 0x4B7A5B4E, 0x4E826158, 0x5183645B, 0x5482635A, 
        0x568B675E, 0x598C695E, 0x5B8E6A5F, 0x5E8C695C, 0x618D6B5B, 0x638A6959, 0x658F6C5D, 0x67947462, 0x69967665, 0x6C947365, 0x6E916C5E, 0x70936A5D, 0x7192695C, 0x7391655A, 0x758D5D50, 0x76926156, 0x77936259, 0x79906058, 0x7A906257, 0x7B906356, 
        0x7C8F6458, 0x7D926A5D, 0x7E8B6256, 0x7F92645E, 0x7F946264, 0x7F905C5E, 0x80895757, 0x818B5A5A, 0x818B5C5C, 0x818D605E, 0x80936565, 0x81916466, 0x80956769, 0x80996B6D, 0x7F9C7070, 0x7E9F7373, 0x7E9F7373, 0x7DA37676, 0x7CA47874, 0x7BA37373, 
        0x7AA36E72, 0x78A77476, 0x77A97C79, 0x76A67B76, 0x74A67F76, 0x72A58176, 0x70A37F71, 0x6FA28074, 0x6DA5827B, 0x6BA48079, 0x689F7F75, 0x66A07F75, 0x639C7D73, 0x629C7C72, 0x5F9B7D73, 0x5D99756D, 0x5A957168, 0x578F6F69, 0x55876C63, 0x52856F69, 
        0x4FB7ADAA, 0x4DB2AFAC, 0x4AAFAFA8, 0x47AFAFAC, 0x44B0B0AC, 0x41B0B0AC, 0x3EB0ACA8, 0x3BB1B1AC, 0x38B1B1AC, 0x35B1B1AD, 0x32B2B2AD, 0x30AFAFA9, 0x2CB3ADAD, 0x29B4ADAD, 0x26B5AEAE, 0x24B1A9A9, 0x21A9A9A9, 0x1EB2B2AA, 0x1CACACA3, 0x1CACACA3,
  0x189FA994, 0x1AA6A69C, 0x1DA7A795, 0x209FA797, 0x23A0A798, 0x25ACAC9E, 0x28A5A598, 0x2BA6A69A, 0x2EA6A69B, 0x30A9A99F, 0x33AAAAA0, 0x36A9A9A0, 0x39B7B2A9, 0x3CAEA199, 0x3F6D584C, 0x426F5449, 0x45725142, 0x47765644, 0x4A7F6056, 0x4D816359, 0x4F805D56, 
        0x5285635D, 0x548B6A60, 0x5789695D, 0x5A8A685D, 0x5C8A695B, 0x5E8A695C, 0x618A6B5B, 0x63927161, 0x65977367, 0x67967165, 0x69916A5B, 0x6B8E665A, 0x6C946A5E, 0x6E93675A, 0x70885D4F, 0x71906057, 0x73916158, 0x74926459, 0x75916358, 0x76906356, 
        0x7791665C, 0x7892675D, 0x7990665A, 0x7A946660, 0x7A966462, 0x7B955F5D, 0x7B925D5B, 0x7B95615F, 0x7B92615F, 0x7C956662, 0x7B996B67, 0x7B9B6D6B, 0x7B9B6F6F, 0x7B9B6F71, 0x7A9E7272, 0x799F7373, 0x799F7371, 0x78A17472, 0x77A07371, 0x76A27474, 
        0x74A67678, 0x73A77979, 0x72A77A7A, 0x71A67E79, 0x6FA78279, 0x6DA58074, 0x6CA27F73, 0x6AA38175, 0x68A6847A, 0x66A27F75, 0x649E7A72, 0x629C7C72, 0x5F9B7B70, 0x5D9C7B73, 0x5B9A7B70, 0x5899736D, 0x56946D6A, 0x52886660, 0x5171544E, 0x4EB3A69F, 
        0x4BBBB4AD, 0x49AEAEA7, 0x46B2B2AE, 0x43ABAEA7, 0x40AFAFAB, 0x3DAFAFAB, 0x3BB1B1A8, 0x37AFAFAB, 0x35ADADA8, 0x32B2B2AD, 0x2FB2ADAD, 0x2CB3ADAD, 0x29B4ADAD, 0x26B5B5AE, 0x24B1B1A9, 0x21B1B1A9, 0x1EB2B2AA, 0x1BB3B3A9, 0x19ADADA3, 0x19ADADA3,
  0x15A9A99D, 0x189FA994, 0x1AA6A69C, 0x1DA7A79E, 0x1FA4A49C, 0x22A5A59D, 0x25A5A59E, 0x27A9A99C, 0x2AA9A99D, 0x2DA9A99E, 0x30AFA9A4, 0x33AFAAA0, 0x36A09B92, 0x3888766D, 0x3B745F52, 0x3E775A49, 0x41755646, 0x43755744, 0x4678574C, 0x497D5E53, 0x4B815F58, 
        0x4E825E5B, 0x5088655F, 0x538A6862, 0x558D6C63, 0x588A6A62, 0x5A8A685D, 0x5C87665B, 0x5E8C665C, 0x60946C62, 0x61926B5E, 0x6491685B, 0x6691695A, 0x6890665A, 0x69936A5E, 0x6B8A6355, 0x6C8F6359, 0x6D905F56, 0x6F94675B, 0x7095665D, 0x71906055, 
        0x7293665B, 0x73916358, 0x7494695E, 0x7595635D, 0x759A615D, 0x7699615A, 0x769B635F, 0x769D6965, 0x769B6761, 0x769B6963, 0x769D6E67, 0x769F706E, 0x769F7072, 0x759E6E70, 0x759E7070, 0x74A27474, 0x73A37775, 0x73A37775, 0x71A47975, 0x70A77A7A, 
        0x6FAB7D80, 0x6EA87C7C, 0x6DA57B76, 0x6CA57D78, 0x6AA37F78, 0x69A27D71, 0x67A38071, 0x65A38076, 0x63A18078, 0x619D7D73, 0x5F9B7B73, 0x5D9C7E75, 0x5B9C7E75, 0x599D8075, 0x56997C70, 0x5497766D, 0x528E6C69, 0x4F7A5A56, 0x4D98847D, 0x4ABDB2AF, 
        0x47B7B3AC, 0x44B0B4AC, 0x42ADB1A9, 0x3FB1B5AD, 0x3CB2B2AE, 0x3AAFAFAB, 0x37AFAFAB, 0x34B0B0AB, 0x31B0B0AB, 0x2FB2ADAD, 0x2CB3B3AD, 0x29ADADAD, 0x26B5AEAE, 0x24B1B1A9, 0x21B1B1A9, 0x1EB2B2AA, 0x1BB3B3A9, 0x19ADB7AD, 0x16ADADAD, 0x16ADADAD,
  0x13A1A1A1, 0x15A9A99D, 0x189F9F94, 0x1AA6A69C, 0x1DA7A79E, 0x1FA4A49C, 0x22A5A59D, 0x25A5A59E, 0x27A9A99C, 0x2AA9A9A3, 0x2D9E9E93, 0x2F7C776C, 0x324C4238, 0x35513930, 0x387A645B, 0x3A765C4A, 0x3C775544, 0x3F755444, 0x42735145, 0x45765851, 0x47816059, 
        0x4A826059, 0x4C82615A, 0x4F846360, 0x51876461, 0x5384655C, 0x5587695D, 0x578C6C60, 0x5A906860, 0x5B94675F, 0x5D91655D, 0x5F90655D, 0x6190685E, 0x638D6659, 0x64936B60, 0x66916B5F, 0x6791675B, 0x6895645A, 0x6A94645B, 0x6B93635A, 0x6C8F5E54, 
        0x6D906158, 0x6E916157, 0x6F94675D, 0x6F9B6760, 0x709C635F, 0x719B605C, 0x719D655E, 0x719F6760, 0x719D6760, 0x719D6760, 0x719D6760, 0x719F6C69, 0x71A27072, 0x70A16F71, 0x70A17173, 0x6FA47774, 0x6EA47873, 0x6DA37974, 0x6DA57B74, 0x6CA57D78, 
        0x6BA67B79, 0x69A47979, 0x68A47A75, 0x66A57F78, 0x65A37E76, 0x639F7D73, 0x62A18275, 0x609F7F74, 0x5E9F8277, 0x5D9E7E75, 0x5A9E7F76, 0x589E7F73, 0x569C7C70, 0x54977C70, 0x5297786F, 0x508F7268, 0x4D846663, 0x4B8B736C, 0x48C2B8B4, 0x46B2AEA7, 
        0x43AEAEA7, 0x41ACB0A8, 0x3EACB0AC, 0x3CAEAEAA, 0x39B2AEA9, 0x36AEAEA9, 0x33AFAFAA, 0x31B0B0AB, 0x2EB1B1AB, 0x2BB1B1AB, 0x29ADADA7, 0x26AEAEA7, 0x24B1A9A9, 0x21B1A9A9, 0x1EB2B2AA, 0x1CACACAC, 0x19ADADAD, 0x17A6B1A6, 0x14B2B2A5, 0x14B2B2A5,
  0x11A5A596, 0x13A1A1A1, 0x15A9A99D, 0x17A6A69B, 0x1AA6A69C, 0x1DA7A79E, 0x1FA4A49C, 0x21A9A9A2, 0x24B1B1A2, 0x279C968F, 0x2A79736D, 0x2C56513F, 0x2F514136, 0x31584339, 0x337D645A, 0x37785C4E, 0x39785447, 0x3C775544, 0x3E734E41, 0x4175524A, 0x437D5B57, 
        0x467F5E57, 0x487F635C, 0x4A82635C, 0x4C82645A, 0x4F80635A, 0x5183675B, 0x5387685C, 0x558D6960, 0x578F665D, 0x598F645B, 0x5A90655D, 0x5C90665E, 0x5E8F665E, 0x5F936860, 0x6190685E, 0x6294685D, 0x6397695F, 0x6594675D, 0x6693615A, 0x6794625B, 
        0x68936258, 0x6996635B, 0x6A97675D, 0x6A9C6760, 0x6B9F6361, 0x6B9F6663, 0x6BA16863, 0x6CA06763, 0x6CA06A65, 0x6CA06A65, 0x6CA06A67, 0x6CA26E6E, 0x6BA67274, 0x6BA47272, 0x6BA47272, 0x6AA37370, 0x69A27671, 0x69A27971, 0x67A57B74, 0x66A77D78, 
        0x66A57D78, 0x64A37A75, 0x63A17D76, 0x62A6827A, 0x60A17F74, 0x5FA08075, 0x5D9C7E73, 0x5B9C7E72, 0x5A9E7F74, 0x589E7F76, 0x569C7F76, 0x549D8276, 0x529B7C6F, 0x50987C6F, 0x4E927568, 0x4B81665F, 0x49816865, 0x47B7ACA8, 0x44B4B0A8, 0x42B1B1A9, 
        0x3FADB1A9, 0x3DAFB3AB, 0x3AAFB3AB, 0x38B1B1AC, 0x35B1B1AD, 0x32B2B2AD, 0x30AFAFA9, 0x2EB1B1AB, 0x2BB1B1AB, 0x28B2B2AB, 0x25B3B3AC, 0x23AEAEAE, 0x20B7AFAF, 0x1EB2B2AA, 0x1BB3B3B3, 0x19ADADAD, 0x17B1B1A6, 0x14B2B2B2, 0x12A9A9A9, 0x12A9A9A9,
  0x0EA3A3A3, 0x11A5A596, 0x13A1A193, 0x15A9A99D, 0x17A6A69B, 0x1AA6A69C, 0x1CA3A39A, 0x1FACA49C, 0x21A9A29A, 0x24867F78, 0x26645D50, 0x29504437, 0x2C564539, 0x2E5E423C, 0x317C6258, 0x33785A4B, 0x367A594B, 0x38765144, 0x3A724F41, 0x3D705347, 0x3F755850, 
        0x41795E52, 0x447F655A, 0x467F6557, 0x487F6354, 0x4A7B6352, 0x4C7F6453, 0x4E7F6554, 0x50856559, 0x528B6659, 0x548B635A, 0x568B645B, 0x588D655C, 0x5991665E, 0x5B91675F, 0x5C926660, 0x5E92665E, 0x5E97695E, 0x60976A62, 0x6195665E, 0x6294625B, 
        0x63926157, 0x64936059, 0x65945F58, 0x65975D5A, 0x669D6466, 0x66A06669, 0x66A06669, 0x66A06669, 0x66A06969, 0x679E6767, 0x67A06C6C, 0x67A56F71, 0x66A77373, 0x66A77373, 0x65A67371, 0x65A37371, 0x64A57A72, 0x63A77D76, 0x63A47D73, 0x62A67F75, 
        0x60A47F77, 0x5FA37B73, 0x5EA27F77, 0x5DA7837B, 0x5C9B796E, 0x5A9E7F76, 0x5899796D, 0x569F7F76, 0x559C7B72, 0x539C7D74, 0x51A08074, 0x4F9D8073, 0x4D947769, 0x4B957A6C, 0x49816557, 0x477A6059, 0x45B4A9A6, 0x43B6B2AE, 0x40AFAFAB, 0x3EACB4AC, 
        0x3CAEB2AA, 0x38B1B6AC, 0x37AFB4AB, 0x34B5B0AB, 0x32B2B2AD, 0x2FB2B2AD, 0x2CB3B3AD, 0x2AB0B0A9, 0x28ABABAB, 0x25B3ACAC, 0x22B4B4AC, 0x20AFAFAF, 0x1DAFAFAF, 0x1BB3B3A9, 0x19ADADAD, 0x16ADADAD, 0x14B2B2A5, 0x12A9A9A9, 0x0FAAAAAA, 0x0FAAAAAA,
  0x0CAAAA94, 0x0EA3A391, 0x109F9F9F, 0x12A9A99B, 0x15A9A99D, 0x17A6A69B, 0x19ADADA3, 0x1CA3A39A, 0x1E999088, 0x217B736C, 0x2350413A, 0x26645749, 0x2859463F, 0x2B5E413B, 0x2D7C6054, 0x2F7C5C51, 0x327F5B4C, 0x347A5344, 0x37735345, 0x396F5447, 0x3B745649, 
        0x3D755B4F, 0x407B5F4F, 0x427B6451, 0x447B6552, 0x467B6550, 0x477D644E, 0x4A7B674F, 0x4C826453, 0x4E856158, 0x50886559, 0x518A645B, 0x538D655C, 0x54946760, 0x56946761, 0x57956660, 0x5893655C, 0x5A956860, 0x5B9A6D62, 0x5C95665E, 0x5D915D54, 
        0x5E8F5951, 0x5F905850, 0x5F905853, 0x60915757, 0x619A5E63, 0x619D6368, 0x619A6366, 0x619D6668, 0x629C686A, 0x629C686A, 0x629C686D, 0x61A26B6E, 0x61A57070, 0x60A97474, 0x60A97774, 0x60A67774, 0x5FA87D75, 0x5FA88078, 0x5EA87F77, 0x5DA47E75, 
        0x5BA58078, 0x5AA47F76, 0x59A38078, 0x58A17F76, 0x569C7C73, 0x55997B72, 0x53997A71, 0x529E7F75, 0x509B7C72, 0x4F9A7D73, 0x4D9B7D73, 0x4B997D73, 0x4992766C, 0x478C6F60, 0x45816758, 0x42B1A29A, 0x41B4B0AC, 0x3EB0B0AC, 0x3BB1B5AC, 0x39AEB7AE, 
        0x38ACB1AC, 0x35B1B1AD, 0x33B4AFAA, 0x31B0B0AB, 0x2EB1B1AB, 0x2CB3ADAD, 0x29B4ADAD, 0x27B0B0A9, 0x24B1B1B1, 0x22B4ACAC, 0x1FB4B4AC, 0x1DB8AFAF, 0x1BB3A9A9, 0x18B4B4A9, 0x16ADADAD, 0x14B2B2A5, 0x11B4B4B4, 0x0FAAAAAA, 0x0DB0B0B0, 0x0DB0B0B0,
  0x0A999999, 0x0CAAAA94, 0x0EA3A391, 0x109F9F9F, 0x12A9A99B, 0x14A5A599, 0x17A6A69B, 0x1999998E, 0x1B978D84, 0x1E6E5D55, 0x204F4737, 0x2269615A, 0x25523E37, 0x26573C35, 0x297C6356, 0x2C795C51, 0x2E7F5E4D, 0x307A5A4A, 0x33785546, 0x35735643, 0x37735745, 
        0x39745947, 0x3C775D48, 0x3E77624E, 0x407B634F, 0x4277604D, 0x4379624C, 0x46786550, 0x477D644E, 0x49846157, 0x4A896359, 0x4D8B6359, 0x4E8C6158, 0x508F685F, 0x51936761, 0x52946660, 0x54946760, 0x55966966, 0x56966A64, 0x5792605A, 0x588D5953, 
        0x598C5850, 0x5A8A5752, 0x5B8C5951, 0x5B915C59, 0x5B9A6264, 0x5C9B6366, 0x5C9B6366, 0x5C9D696E, 0x5D9C686A, 0x5CA06C6E, 0x5C9B6669, 0x5C9D696C, 0x5CA36C6C, 0x5CA87477, 0x5BA87875, 0x5BA87878, 0x5AA97F79, 0x5AA97F76, 0x59A87D78, 0x58A17C76, 
        0x56A57F79, 0x56A57F79, 0x55A2817B, 0x539F8077, 0x529E7C75, 0x5095756C, 0x4F9A7A73, 0x4E997B75, 0x4C9A7B75, 0x4A9A7B71, 0x48987871, 0x46957B70, 0x448A7065, 0x4381665F, 0x4198857D, 0x3FC1B9B5, 0x3CB6B2AE, 0x3AAFAFAB, 0x38ACB1AC, 0x36AEB3AE, 
        0x34ABB0AB, 0x31B0B0AB, 0x2FB2B2AD, 0x2DAFAFA9, 0x2BB1ABAB, 0x28B2B2AB, 0x26AEAEAE, 0x24B1B1A9, 0x21B1B1A9, 0x1FACACAC, 0x1CB6B6AC, 0x1AB0B0B0, 0x18B4B4A9, 0x16ADADAD, 0x13AEAEAE, 0x11B4B4B4, 0x0FAAAAAA, 0x0DB0B0B0, 0x0BB9B9A2, 0x0BB9B9A2,
  0x089F9F9F, 0x0A999999, 0x0CAA9494, 0x0EA3A391, 0x109F9F9F, 0x12A99B9B, 0x14A5A599, 0x1696968B, 0x18948A7F, 0x1A584E44, 0x1D60574F, 0x1F7B736A, 0x214D3D36, 0x24543F31, 0x257C6759, 0x2879594C, 0x2B7C5E4D, 0x2D7C5A49, 0x2F775646, 0x31775843, 0x33735541, 
        0x36715942, 0x38715B44, 0x3A765C46, 0x3C775D48, 0x3E775E49, 0x3F75604C, 0x41796552, 0x437D624F, 0x45815F51, 0x46866253, 0x488A6354, 0x4A866052, 0x4B8B6258, 0x4C90675A, 0x4E92685E, 0x4F976A63, 0x50986868, 0x51966467, 0x528E5D5D, 0x538A5955, 
        0x548B5A57, 0x558D5D54, 0x568E5E58, 0x56966461, 0x56996467, 0x579B696C, 0x579E696C, 0x57A47275, 0x589E6A6D, 0x58A17073, 0x579B6669, 0x579E666C, 0x57A46C6F, 0x56A57073, 0x56A87979, 0x56A87C79, 0x55AB817B, 0x54A97F79, 0x53A8807A, 0x53A57D77, 
        0x52A47C7C, 0x51A37A7A, 0x4FA17A77, 0x4F9D7A77, 0x4D987773, 0x4C96716E, 0x4A9A7B78, 0x49997A73, 0x47967A72, 0x46957470, 0x44927069, 0x428E6F64, 0x408B7367, 0x3F715C54, 0x3DA39692, 0x3BB9B1B1, 0x39B7AEAE, 0x37AFAFAB, 0x34B0B0AB, 0x32B2B2AD, 
        0x2FB2B2AD, 0x2EB1B1AB, 0x2BB1B1AB, 0x29B4B4AD, 0x26B5B5AE, 0x25B3B3AC, 0x22B4B4AC, 0x20B7AFAF, 0x1EB2B2AA, 0x1CACACAC, 0x19B7B7AD, 0x17B1B1B1, 0x15B6B6A9, 0x13AEAEAE, 0x11B4B4B4, 0x0FBBAAAA, 0x0DB0B0B0, 0x0BB9B9B9, 0x09A9A9A9, 0x09A9A9A9,
  0x06AAAA7F, 0x089F9F9F, 0x0A999999, 0x0BA2A28B, 0x0D9C9C9C, 0x0F999999, 0x11A59696, 0x14998C8C, 0x168B7F73, 0x184A3F35, 0x1A756B6B, 0x1C766464, 0x1E3B2A22, 0x20573F37, 0x23836557, 0x2575594B, 0x277C5B47, 0x297C564A, 0x2B7C5847, 0x2D765A43, 0x306F543F, 
        0x31725343, 0x34755844, 0x36715946, 0x37735745, 0x39745947, 0x3B745A45, 0x3D79604B, 0x3F7D6050, 0x407F5B4F, 0x427F5C4D, 0x44836152, 0x45815F51, 0x46866253, 0x488A6358, 0x498B685A, 0x4A976E67, 0x4C966B67, 0x4C936464, 0x4E8C5B5B, 0x4E8C5B54, 
        0x4F90635D, 0x5092625C, 0x5190615B, 0x51996A67, 0x519D676A, 0x52976666, 0x52A16F6F, 0x52A77878, 0x53A27477, 0x53A57477, 0x52A16F6F, 0x529E696C, 0x52A16F72, 0x529E696C, 0x51A67777, 0x51A67A77, 0x50AB827C, 0x4FA47D77, 0x4EA67F78, 0x4EA67F7B, 
        0x4DA57D7A, 0x4CA07878, 0x4B9C7373, 0x4A97716E, 0x4894716D, 0x47967672, 0x46987874, 0x44967870, 0x4394756E, 0x4194756D, 0x408F6F67, 0x3E8B6A62, 0x3C7F6A5D, 0x3A725C53, 0x38A39691, 0x37B4AFAB, 0x35B6B1AD, 0x32B2B2AD, 0x31ABB0AB, 0x2FADB2AD, 
        0x2CB3B3AD, 0x29B4B4AD, 0x28B2B2AB, 0x26AEAEAE, 0x24B1B1A9, 0x21B1B1B1, 0x1FB4B4AC, 0x1DAFAFAF, 0x1BB3B3A9, 0x19ADADAD, 0x17B1B1A6, 0x15B6A9A9, 0x13AEAEAE, 0x10AFAFAF, 0x0EB6B6B6, 0x0CAAAAAA, 0x0AB2B2B2, 0x09A9A9A9, 0x07B6B6B6, 0x07B6B6B6,
  0x04BF7F7F, 0x06AAAA7F, 0x089F9F7F, 0x09A9A98D, 0x0BA2A28B, 0x0D9C9C89, 0x0F999988, 0x11969687, 0x13867878, 0x15544848, 0x1784796E, 0x19665B51, 0x1B38251C, 0x1D57463D, 0x1F83625A, 0x217B5C4D, 0x247F5446, 0x267F5749, 0x28795946, 0x2A795442, 0x2C735145, 
        0x2E745342, 0x30745445, 0x32755147, 0x33735546, 0x35735648, 0x37735345, 0x39745947, 0x3B785F52, 0x3C77594C, 0x3E775A4E, 0x3F7D5C50, 0x417D5A52, 0x427F6054, 0x43856257, 0x4584675C, 0x468D6962, 0x47936868, 0x48916663, 0x498B5E5A, 0x4A865952, 
        0x4A8D5C56, 0x4B8E665B, 0x4C90675D, 0x4C9A6E67, 0x4D9E7070, 0x4D9B6969, 0x4DA27070, 0x4DA27373, 0x4EA37575, 0x4EA37878, 0x4EA37575, 0x4DA27073, 0x4DA57377, 0x4DA57777, 0x4CA77878, 0x4CA77B7B, 0x4BAA817D, 0x4AA17B74, 0x4AA17B78, 0x49A07A76, 
        0x489F7874, 0x479A7672, 0x46957470, 0x4593726E, 0x448E6C69, 0x4394756E, 0x41917571, 0x408F776F, 0x3E8F736E, 0x3D8E706C, 0x3B8E6C63, 0x3A836457, 0x377D6157, 0x3684716C, 0x339B8C87, 0x33AFA5A5, 0x31B6ABAB, 0x2FB2ADAD, 0x2CB3B3AD, 0x2BB1B1AB, 
        0x29ADADAD, 0x27B0B0A9, 0x25B3B3AC, 0x23AEAEAE, 0x20AFAFAF, 0x1EB2B2B2, 0x1CACB6AC, 0x1AB0B0B0, 0x18A9B4A9, 0x16ADADAD, 0x14B2B2B2, 0x12B8B8A9, 0x10AFAFAF, 0x0EB6B6A3, 0x0CAAAAAA, 0x0AB2B2B2, 0x08BFBF9F, 0x07B6B6B6, 0x0599CC99, 0x0599CC99,
  0x027F7F7F, 0x04BF7F7F, 0x06AAAA7F, 0x07919191, 0x09A9A98D, 0x0BA2A28B, 0x0D9C9C89, 0x0EA39191, 0x107F6F6F, 0x12716354, 0x147F7272, 0x16513939, 0x18351F1F, 0x1A62443A, 0x1C7F6451, 0x1E7F5D4C, 0x207F5F4F, 0x227F5A4B, 0x247F5C46, 0x267F5749, 0x28795246, 
        0x2A794E42, 0x2C795145, 0x2E745342, 0x2F775141, 0x31725343, 0x33735041, 0x35735143, 0x3676594B, 0x3871564D, 0x3974594B, 0x3B785A52, 0x3C775950, 0x3E7B5E56, 0x3F816558, 0x4083675B, 0x4185655E, 0x428E6C64, 0x43906A66, 0x4487615A, 0x45845C58, 
        0x458C635C, 0x468D655E, 0x478C6459, 0x478F6460, 0x48986A6A, 0x489B6A6A, 0x4898666A, 0x49996C6C, 0x49A07373, 0x48A27878, 0x49A07676, 0x48A27474, 0x48A27174, 0x48A27878, 0x489F7478, 0x47A57D7A, 0x47A17D7A, 0x469C7874, 0x459E7D76, 0x44997870, 
        0x44926C69, 0x4398756E, 0x4292736C, 0x41917169, 0x3F8D7169, 0x3D8E756C, 0x3D89756C, 0x3B8E7870, 0x3A8C726D, 0x398A6F62, 0x37816557, 0x35816556, 0x347F665D, 0x327A605B, 0x309F8F8A, 0x2FB2A8A8, 0x2DAFA9A9, 0x2BB1B1AB, 0x29ADADA7, 0x27B0B0A9, 
        0x25ACB3AC, 0x23AEAEAE, 0x21B1B1A9, 0x1FACB4AC, 0x1DAFAFAF, 0x1BB3B3B3, 0x19ADB7AD, 0x17B1B1B1, 0x15A9B6A9, 0x13AEAEAE, 0x11B4B4B4, 0x0FBBBBAA, 0x0DB0B0B0, 0x0CAAAAAA, 0x0AB2B2B2, 0x08BFBFBF, 0x06AAAAAA, 0x0599CC99, 0x03AAAAAA, 0x03AAAAAA,
  0x01FFFFFF, 0x027F7F7F, 0x03AAAAAA, 0x05999999, 0x07919191, 0x089F9F9F, 0x0A999999, 0x0CAA9494, 0x0E7F6D6D, 0x107F6F6F, 0x11695A5A, 0x13352828, 0x153C2424, 0x17634D42, 0x197A5B51, 0x1B7A544B, 0x1D7B604F, 0x1F835A49, 0x217B5C45, 0x237B5748, 0x2478543F, 
        0x26785043, 0x28795246, 0x29755044, 0x2B704D41, 0x2C735145, 0x2F714B41, 0x316D4E43, 0x31725348, 0x3373554B, 0x3475584E, 0x36765E50, 0x38715B51, 0x39745D50, 0x3A7A6053, 0x3B7D635A, 0x3D7D645B, 0x3E876662, 0x3E8B6A66, 0x3F856058, 0x40835B53, 
        0x41855E52, 0x428A6058, 0x428E645C, 0x43946662, 0x439B6A6E, 0x439B6A6A, 0x44996C69, 0x44997070, 0x449D7474, 0x44997470, 0x44997474, 0x44A17878, 0x449D7074, 0x439F7575, 0x439F7575, 0x42A27B77, 0x429E7B77, 0x41987975, 0x409B7B73, 0x4097776F, 
        0x3F91716D, 0x3E987773, 0x3D92756C, 0x3C8C726A, 0x3B8A7067, 0x3A887269, 0x388D766D, 0x36887167, 0x35866E65, 0x34846B62, 0x3382645A, 0x31876D5D, 0x30846F64, 0x2E745E53, 0x2CA29690, 0x2BB1A6A6, 0x29A7A7A7, 0x27B0B6B0, 0x25B3B3AC, 0x23AEB6AE, 
        0x22ACB4AC, 0x20AFAFAF, 0x1EB2B2AA, 0x1CACACAC, 0x1AB0B0B0, 0x18B4B4A9, 0x16ADB9AD, 0x14B2B2B2, 0x12B8B8B8, 0x10AFAFAF, 0x0EB6B6B6, 0x0DB0B0B0, 0x0BB9B9A2, 0x09A9A9A9, 0x08BFBF9F, 0x06AAAAAA, 0x04BFBFBF, 0x03AAAAAA, 0x01FFFFFF, 0x01FFFFFF,
  0x00000000, 0x00000000, 0x027F7F7F, 0x03AAAAAA, 0x05999999, 0x06AAAAAA, 0x089F9F9F, 0x0A99997F, 0x0B735C5C, 0x0D897575, 0x0F443333, 0x113C2D2D, 0x12462A2A, 0x14664C3F, 0x16735C51, 0x187F544A, 0x1A7F5844, 0x1B7A544B, 0x1D7B5746, 0x1F7B5A49, 0x217B4D45, 
        0x23745048, 0x24785446, 0x26725043, 0x28724C3F, 0x296F5044, 0x2B6A4D41, 0x2D6B493E, 0x2E694D42, 0x2F714B46, 0x31724E48, 0x3275564C, 0x33785A50, 0x35735B51, 0x35735B51, 0x37785C53, 0x387A645B, 0x3981665D, 0x3A886960, 0x3B7D5F56, 0x3C7F5D55, 
        0x3C835D55, 0x3D896057, 0x3E8B665A, 0x3E936A66, 0x3E9C6A6E, 0x3F996969, 0x3F996D69, 0x3F99716D, 0x3F95716D, 0x3F95716D, 0x3F997571, 0x3F9D7975, 0x3F9D7575, 0x3F997575, 0x3E9C7773, 0x3E987373, 0x3D9A7975, 0x3D967570, 0x3C947772, 0x3B927870, 
        0x3A90766D, 0x3A8C7269, 0x39866F66, 0x378A6F65, 0x37866F65, 0x35866E65, 0x34847066, 0x33826E64, 0x31826D62, 0x307F6A5F, 0x2F82665C, 0x2D826B60, 0x2B887064, 0x2A5B423C, 0x299B8E88, 0x27A99C9C, 0x25A59E9E, 0x24A9A9A9, 0x22B4B4AC, 0x20AFAFAF, 
        0x1EB2B2AA, 0x1CACB6AC, 0x1AB0B0B0, 0x19ADADAD, 0x17B1B1A6, 0x15B6B6A9, 0x13AEAEAE, 0x11B4B4B4, 0x10AFAFAF, 0x0EB6B6B6, 0x0CAAAAAA, 0x0AB2B2B2, 0x09A9A9A9, 0x07B6B6B6, 0x06AAAAAA, 0x04BFBFBF, 0x03AAAAAA, 0x01FFFFFF, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x03AAAAAA, 0x04BF7F7F, 0x06AAAAAA, 0x07B69191, 0x09717171, 0x0A664C4C, 0x0C3F2A2A, 0x0E483636, 0x103F2F2F, 0x11694B4B, 0x13785050, 0x15795448, 0x17795842, 0x187F543F, 0x1A7F4E44, 0x1C7F5148, 0x1E77554C, 
        0x1F7B5249, 0x2173544D, 0x2270524B, 0x24715446, 0x266B4943, 0x27684E41, 0x286C4C3F, 0x2A674842, 0x2B704747, 0x2D6B4943, 0x2E6E4D48, 0x2F71514B, 0x30745A54, 0x327A5B56, 0x33735A50, 0x347A6258, 0x347A6258, 0x367F675E, 0x367F5E54, 0x3786655C, 
        0x38835F56, 0x38885F56, 0x398A665D, 0x39936662, 0x3A956969, 0x3A996969, 0x3A956969, 0x3A956D69, 0x3B926C6C, 0x3B92706C, 0x3B92706C, 0x3A997676, 0x3A997676, 0x3A957272, 0x39977474, 0x39977474, 0x38967671, 0x38967671, 0x378F736F, 0x378F736A, 
        0x36927671, 0x358B6E69, 0x3489706B, 0x33877369, 0x327F6B60, 0x317C685D, 0x307A6A5F, 0x2F7C6C61, 0x2D877165, 0x2C7F685C, 0x2B826A58, 0x2982695D, 0x287F6559, 0x26492E28, 0x25907C75, 0x23A7A098, 0x22A5A59D, 0x20A7A79F, 0x1EB2B2B2, 0x1DAFAFAF, 
        0x1BA9B3A9, 0x19ADB7AD, 0x17B1B1B1, 0x16ADADAD, 0x14B2B2B2, 0x12B8B8A9, 0x11B4A5A5, 0x0EB6B6B6, 0x0DB0B0B0, 0x0BB9B9B9, 0x0AB2B2B2, 0x08BFBFBF, 0x07B6B6B6, 0x05CCCC99, 0x04BFBFBF, 0x027F7F7F, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x027F7F7F, 0x04BFBFBF, 0x05999999, 0x076D6D48, 0x083F3F3F, 0x0A4C3333, 0x0B452E2E, 0x0D3A2727, 0x0F664444, 0x107F4F4F, 0x127F5446, 0x147F594C, 0x15855448, 0x1779584D, 0x197A5B47, 0x1A7F584E, 
        0x1C7F5B51, 0x1D7B574F, 0x1F735249, 0x2173544D, 0x21735445, 0x236D5041, 0x256E5244, 0x266B5043, 0x276F4E41, 0x296F4A44, 0x2A6D4842, 0x2B6A4D47, 0x2C735651, 0x2D766054, 0x2E6E584D, 0x2F77615C, 0x307A645A, 0x31776258, 0x327A6056, 0x3382645A, 
        0x3382645A, 0x34846258, 0x3586655B, 0x35906560, 0x35956969, 0x36976C67, 0x36976C67, 0x36976C67, 0x3697716C, 0x36926C67, 0x36926C67, 0x369B7671, 0x35997373, 0x35956E73, 0x35957373, 0x35957873, 0x34977A75, 0x3391736E, 0x3391786E, 0x32897570, 
        0x32847570, 0x31827268, 0x307F6F64, 0x2F826C61, 0x2E796958, 0x2D71655A, 0x2C79685C, 0x2B7C6A5E, 0x29826F63, 0x287F6C5F, 0x27896F61, 0x25896E60, 0x24785C4D, 0x2243251E, 0x217B6C64, 0x20A7979F, 0x1EAAA1A1, 0x1CA3A3A3, 0x1BB3A9B3, 0x19B7B7AD, 
        0x18A9B4A9, 0x16ADB9AD, 0x14B2B2B2, 0x13AEAEAE, 0x11B4B4B4, 0x0FBBAAAA, 0x0EB6B6B6, 0x0CBFAAAA, 0x0AB2B2B2, 0x09A9A9A9, 0x07B6B6B6, 0x06AAAAAA, 0x0599CC99, 0x03AAAAAA, 0x027F7F7F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x027F7F7F, 0x03AAAAAA, 0x05666633, 0x06552A2A, 0x083F1F1F, 0x09383838, 0x0A4C3333, 0x0C6A3F3F, 0x0D754E4E, 0x0F885555, 0x11875A4B, 0x127F6354, 0x13865D50, 0x15855454, 0x1784584D, 
        0x187F544A, 0x1A7F584E, 0x1B714B42, 0x1D7B5746, 0x1E775544, 0x206F4F3F, 0x216C4D3D, 0x2269523C, 0x24714D38, 0x256E4B37, 0x266B493C, 0x27684E41, 0x286C5246, 0x296F564A, 0x2A735B4E, 0x2B765E53, 0x2C736256, 0x2D716054, 0x2D766054, 0x2E7F6358, 
        0x2F82665C, 0x30846A5F, 0x308A645F, 0x308A645F, 0x31916862, 0x31916D68, 0x31916D68, 0x31916D68, 0x3293706B, 0x32937066, 0x328E6B60, 0x318C6868, 0x31916D6D, 0x31917272, 0x31916D6D, 0x30947474, 0x308F7474, 0x2F87716C, 0x2F8C7771, 0x2E84746E, 
        0x2D827165, 0x2D7C6B65, 0x2C6E6256, 0x2B706458, 0x2A73675B, 0x297C6F63, 0x287F7265, 0x277C6F61, 0x25897567, 0x248D7163, 0x238A6D5E, 0x228E7061, 0x207F5F57, 0x1F412920, 0x1E775D5D, 0x1CA39191, 0x1AB0A6A6, 0x19ADA3A3, 0x17B1B1B1, 0x16B9ADAD, 
        0x14B2B2B2, 0x13AEAEAE, 0x11B4B4B4, 0x10AFAFAF, 0x0EB6B6B6, 0x0DB0B0B0, 0x0BB9B9B9, 0x0AB2B2B2, 0x08BFBF9F, 0x07B6B6B6, 0x05CCCC99, 0x04BFBFBF, 0x03AAAAAA, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FFFFFF, 0x03555555, 0x043F3F3F, 0x05333333, 0x07482424, 0x083F3F3F, 0x09713838, 0x0B734545, 0x0C7F5555, 0x0E7F5B48, 0x0F885555, 0x11875A5A, 0x127F5454, 0x147F5959, 
        0x15795448, 0x167F5C51, 0x1874543F, 0x197A5B47, 0x1B7A5442, 0x1C6D513F, 0x1E6E4C3B, 0x1E6E4C3B, 0x206F4737, 0x216C4D3D, 0x22694B3C, 0x236D5041, 0x246A4D3F, 0x25675244, 0x26725750, 0x276F5B4E, 0x28725F52, 0x296F5D50, 0x29755D50, 0x2A7F675B, 
        0x2B7C6458, 0x2B826A5E, 0x2C856862, 0x2C8A6868, 0x2C8A6868, 0x2D8D6B65, 0x2D93716B, 0x2D93716B, 0x2D93716B, 0x2D93716B, 0x2D8D6B65, 0x2D8D6B65, 0x2D8D6B65, 0x2D8D6B6B, 0x2C8A6E6E, 0x2C907373, 0x2C856E6E, 0x2B88706A, 0x2B88706A, 0x2A856D67, 
        0x297C6963, 0x28795F59, 0x28725F52, 0x277C615B, 0x267F6B64, 0x25826E67, 0x247F6A63, 0x237B655E, 0x22877061, 0x20876F5F, 0x1F8B7362, 0x1E906E66, 0x1D72574F, 0x1C3F2424, 0x1A6B5858, 0x19998E8E, 0x17A6A6A6, 0x16ADA2A2, 0x14A5A5A5, 0x13BBAEAE, 
        0x11B4B4B4, 0x10AFAFAF, 0x0EB6B6B6, 0x0DB0B0B0, 0x0BB9B9B9, 0x0AB2B2B2, 0x09A9A9A9, 0x07B6B6B6, 0x06AAAAAA, 0x05CCCC99, 0x03AAAAAA, 0x027F7F7F, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x03555500, 0x05333333, 0x06552A2A, 0x076D4848, 0x087F5F3F, 0x0A7F4C4C, 0x0B8B5C45, 0x0D75624E, 0x0E7F5B48, 0x0F885555, 0x11875A5A, 
        0x127F5454, 0x147F594C, 0x15795448, 0x167F5C45, 0x1874543F, 0x1970513D, 0x1A6B4E44, 0x1B714B38, 0x1C6D483F, 0x1D694F3D, 0x1F624939, 0x20674737, 0x20674F3F, 0x22614B43, 0x22695243, 0x236D5748, 0x24715C4D, 0x256E5952, 0x25755952, 0x26785D57, 
        0x277C5B54, 0x277C615B, 0x28856559, 0x288C6565, 0x288C656C, 0x29886363, 0x298E6F69, 0x298E6F6F, 0x298E6F69, 0x29886963, 0x29886963, 0x29886963, 0x29886969, 0x28856C65, 0x28856C65, 0x2885726C, 0x277C6861, 0x27826F68, 0x267F6B64, 0x26786457, 
        0x25755952, 0x24785C54, 0x24785C54, 0x2383655E, 0x22876961, 0x21836C64, 0x20876F67, 0x1F8B7362, 0x1E886E66, 0x1D8C7260, 0x1C886D64, 0x1A896B62, 0x195B3D33, 0x184A2A2A, 0x17634D4D, 0x16968B8B, 0x14B2A5A5, 0x13BBAEAE, 0x12A9A9A9, 0x10AFAFAF, 
        0x0EB6B6B6, 0x0DB0B0B0, 0x0BB9B9B9, 0x0AB2B2B2, 0x09A9A9A9, 0x08BFBF9F, 0x07B6B691, 0x05CCCC99, 0x04BFBFBF, 0x03AAAAAA, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03555500, 0x043F3F3F, 0x05663333, 0x067F5555, 0x076D4848, 0x098D5454, 0x0A7F4C4C, 0x0B8B5C5C, 0x0D89624E, 0x0D89624E, 
        0x0F775544, 0x107F5F4F, 0x11785A4B, 0x13785043, 0x1472594C, 0x156D5448, 0x16685139, 0x186A4A3F, 0x1970473D, 0x1A6B4E44, 0x1B714B42, 0x1B674B38, 0x1D694F3D, 0x1E664C3B, 0x1F624939, 0x1F624941, 0x20674F3F, 0x216C4D45, 0x2173544D, 0x22785A52, 
        0x22785A52, 0x237B5E57, 0x24786354, 0x24866363, 0x24866A6A, 0x24866A6A, 0x25826767, 0x25826767, 0x25826767, 0x25826760, 0x257C6059, 0x257C6059, 0x257C6760, 0x247F6A63, 0x2478635C, 0x247F6A5C, 0x23745E50, 0x23745E57, 0x22705A4B, 0x22705A52, 
        0x217B5C54, 0x2183645C, 0x207F5F57, 0x1F836262, 0x1E906E66, 0x1D8C7269, 0x1C916D64, 0x1B8D7167, 0x1A896B62, 0x198E7066, 0x188A6A5F, 0x167F5C51, 0x16392217, 0x15483030, 0x135D4343, 0x129B8D8D, 0x11A5A596, 0x109F9F9F, 0x0FAA9999, 0x0DB0B0B0, 
        0x0BB9B9B9, 0x0AB2B2B2, 0x09A9A9A9, 0x08BFBF9F, 0x07B6B6B6, 0x06AAAAAA, 0x04BFBFBF, 0x03AAAAAA, 0x027F7F7F, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x027F0000, 0x03555555, 0x047F3F3F, 0x05666633, 0x067F5555, 0x087F5F3F, 0x098D5454, 0x0A7F664C, 0x0B8B5C5C, 
        0x0C7F5555, 0x0E7F5B48, 0x0E7F5B48, 0x107F4F4F, 0x11785A4B, 0x12715446, 0x13785D43, 0x156D4848, 0x15795448, 0x176E4242, 0x176E4D42, 0x186A4A3F, 0x1966513D, 0x1A6B4E3A, 0x1B674B38, 0x1C64483F, 0x1C6D513F, 0x1D694F3D, 0x1D694F46, 0x1E6E554C, 
        0x1F735A52, 0x1F735A49, 0x2077574F, 0x20775F57, 0x20775F5F, 0x20775F5F, 0x217B5C5C, 0x217B5C5C, 0x217B645C, 0x217B645C, 0x217B5C54, 0x21735C4D, 0x21735C4D, 0x206F574F, 0x206F5747, 0x206F574F, 0x20675747, 0x1F735A52, 0x1F6A5A49, 0x1E7F6655, 
        0x1D836060, 0x1D836960, 0x1C88645B, 0x1B8D6767, 0x1B8D7167, 0x198E7066, 0x19847066, 0x1894746A, 0x17906E63, 0x168B7368, 0x15916D61, 0x1472593F, 0x13350D0D, 0x114B2D1E, 0x104F3F3F, 0x0F998888, 0x0EA3A3A3, 0x0DB0B0B0, 0x0CAAAAAA, 0x0AB2B2B2, 
        0x09A9A9A9, 0x08BFBFBF, 0x07B6B6B6, 0x05CCCCCC, 0x0599CC99, 0x03AAAAAA, 0x027F7F7F, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x027F7F00, 0x03555555, 0x047F3F3F, 0x05996633, 0x067F5555, 0x087F5F5F, 0x098D5454, 
        0x0A7F4C4C, 0x0B735C45, 0x0C7F5555, 0x0D754E4E, 0x0E6D5B48, 0x0F775544, 0x106F5F4F, 0x11785A4B, 0x127F5454, 0x13785043, 0x14724C4C, 0x156D483C, 0x16684539, 0x17634D37, 0x186A4A35, 0x186A4A3F, 0x1966473D, 0x1A624E3A, 0x1A6B4E44, 0x1B674B42, 
        0x1B674B42, 0x1B674B42, 0x1C6D5148, 0x1C6D5148, 0x1D724F4F, 0x1D724F4F, 0x1D724F46, 0x1D724F46, 0x1D72574F, 0x1D72574F, 0x1D72574F, 0x1D725746, 0x1D725746, 0x1D694F46, 0x1C6D5148, 0x1C6D5B48, 0x1C6D5B48, 0x1B7A5E54, 0x1B7A5E54, 0x1A896B62, 
        0x1A896B62, 0x198E7066, 0x188A6A6A, 0x188A6A5F, 0x17906E63, 0x168B7368, 0x168B685C, 0x15916D61, 0x1393786B, 0x128D7163, 0x128D7163, 0x11694B3C, 0x0F331111, 0x0F332222, 0x0D4E3A3A, 0x0C947F7F, 0x0BA2A2A2, 0x0AB2B2B2, 0x09A9A9A9, 0x08BFBF9F, 
        0x07B6B6B6, 0x06AAAAAA, 0x0599CC99, 0x04BFBFBF, 0x027F7F7F, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x027F7F7F, 0x03AA5555, 0x047F3F3F, 0x05996666, 0x067F5555, 
        0x07914848, 0x087F5F5F, 0x098D5454, 0x0A7F664C, 0x0B735C45, 0x0C7F5555, 0x0D75624E, 0x0E6D5B48, 0x0F775555, 0x106F4F3F, 0x11784B4B, 0x11785A4B, 0x12715446, 0x136B5043, 0x14664C3F, 0x1561483C, 0x156D483C, 0x16685145, 0x16685145, 0x176E4D42, 
        0x186A4A3F, 0x186A4A3F, 0x1874544A, 0x19705147, 0x19705147, 0x19705147, 0x19705147, 0x19705147, 0x19705147, 0x19705147, 0x19705147, 0x19705147, 0x19705147, 0x19705147, 0x19705B51, 0x18745F54, 0x18745F54, 0x187F5F5F, 0x17846358, 0x17846E63, 
        0x168B7368, 0x168B7368, 0x1591796D, 0x14997272, 0x148C7266, 0x1393786B, 0x128D7163, 0x11967869, 0x108F6F6F, 0x0F997766, 0x0E916D5B, 0x0D623A27, 0x0D4E2713, 0x0B2E1717, 0x0B452E2E, 0x0A7F7F7F, 0x09A98D8D, 0x089F9F9F, 0x07B6B691, 0x06AAAAAA, 
        0x04BFBFBF, 0x04BFBFBF, 0x03AAAAAA, 0x01FFFFFF, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FF0000, 0x027F7F7F, 0x03AA5555, 0x03AA5555, 
        0x05996666, 0x05996666, 0x067F5555, 0x087F5F3F, 0x087F5F5F, 0x0A7F664C, 0x0B735C45, 0x0C7F5555, 0x0C7F5555, 0x0D754E4E, 0x0E6D4848, 0x0E6D4848, 0x0F775544, 0x106F4F3F, 0x11695A3C, 0x12635446, 0x12635446, 0x136B5043, 0x136B5043, 0x136B5043, 
        0x14664C3F, 0x14664C3F, 0x156D4848, 0x156D483C, 0x156D543C, 0x16685145, 0x16735145, 0x16735145, 0x16735145, 0x16735145, 0x16735C51, 0x16735C51, 0x16735C51, 0x15796154, 0x15796154, 0x15856154, 0x15856161, 0x148C7266, 0x148C7266, 0x13866B6B, 
        0x128D7163, 0x13866B6B, 0x128D7171, 0x11967878, 0x11877869, 0x0F997766, 0x0F887766, 0x0E917F6D, 0x0D9C7562, 0x0D897562, 0x0C7F5555, 0x0B5C2E2E, 0x0A4C1919, 0x09381C1C, 0x083F3F1F, 0x07916D6D, 0x06AAAAAA, 0x05999999, 0x04BFBFBF, 0x03AAAAAA, 
        0x027F7F7F, 0x01FFFFFF, 0x01FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FF0000, 0x027F7F7F, 
        0x03AA5555, 0x03AA5555, 0x047F3F3F, 0x05996666, 0x067F5555, 0x07916D48, 0x087F5F3F, 0x09715454, 0x0A7F4C4C, 0x0A7F4C4C, 0x0B735C45, 0x0C6A553F, 0x0C7F5555, 0x0D754E4E, 0x0E6D5B48, 0x0E7F5B48, 0x0F775544, 0x0F775544, 0x106F4F4F, 0x11694B4B, 
        0x11784B4B, 0x11785A4B, 0x11785A4B, 0x12715454, 0x12715446, 0x127F5446, 0x12715446, 0x13785D50, 0x13785D50, 0x13785D50, 0x127F6354, 0x13865D5D, 0x127F6354, 0x127F6363, 0x128D7163, 0x127F7163, 0x11967869, 0x11967878, 0x108F7F6F, 0x108F7F6F, 
        0x0F997777, 0x0F997777, 0x0E917F6D, 0x0E917F6D, 0x0E916D6D, 0x0D897562, 0x0C946A6A, 0x0C946A6A, 0x0B8B735C, 0x0A996666, 0x09715454, 0x085F3F3F, 0x07482424, 0x07242400, 0x06552A2A, 0x05996666, 0x03AAAAAA, 0x03AAAAAA, 0x027F7F7F, 0x01FFFFFF, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x01FF0000, 0x01FF0000, 0x027F7F7F, 0x03AA5555, 0x03AA5555, 0x05666666, 0x05996666, 0x067F5555, 0x07914848, 0x087F5F3F, 0x087F5F3F, 0x09715454, 0x0A7F664C, 0x0A7F664C, 0x0A7F664C, 0x0C7F5555, 0x0C7F5555, 0x0C7F5555, 0x0D754E4E, 0x0D75624E, 
        0x0D75624E, 0x0E7F5B5B, 0x0E7F5B5B, 0x0F776655, 0x0F775544, 0x0F886655, 0x0F886655, 0x0F886666, 0x0F887766, 0x0F887766, 0x0F997766, 0x0F887766, 0x0F887766, 0x0F887766, 0x0F887766, 0x0F887766, 0x0E917F6D, 0x0E917F6D, 0x0E917F6D, 0x0D9C8975, 
        0x0D9C7575, 0x0C947F7F, 0x0C947F6A, 0x0B8B735C, 0x0B8B735C, 0x0A996666, 0x0A996666, 0x098D7171, 0x089F7F5F, 0x07916D6D, 0x067F5555, 0x05663333, 0x05333333, 0x043F0000, 0x03555555, 0x03AA5555, 0x01FFFFFF, 0x01FFFFFF, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x01FF0000, 0x027F7F7F, 0x027F7F7F, 0x03AA5555, 0x03AA5555, 0x05996666, 0x05996666, 0x05996666, 0x067F5555, 0x067F5555, 0x07916D6D, 0x087F5F5F, 0x098D7154, 0x098D5454, 0x098D7171, 0x0A7F6666, 0x0B8B5C5C, 
        0x0B8B735C, 0x0B8B735C, 0x0B8B735C, 0x0C7F6A6A, 0x0B8B5C5C, 0x0C7F6A55, 0x0C946A55, 0x0C946A6A, 0x0C946A6A, 0x0C946A6A, 0x0C947F6A, 0x0C946A6A, 0x0C947F6A, 0x0C947F6A, 0x0C947F6A, 0x0C947F6A, 0x0BA28B73, 0x0B8B7373, 0x0B8B7373, 0x0A997F7F, 
        0x0A997F66, 0x0A997F66, 0x098D7171, 0x098D7171, 0x087F7F5F, 0x0791916D, 0x07916D6D, 0x05996666, 0x05996666, 0x05996666, 0x047F3F3F, 0x03555555, 0x03550000, 0x01000000, 0x01000000, 0x01FFFF00, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FF0000, 0x027F7F7F, 0x027F7F7F, 0x03AA5555, 0x047F7F3F, 0x047F7F3F, 0x05996666, 0x05996666, 0x05996666, 0x067F7F7F, 0x07916D6D, 0x07916D6D, 0x07916D6D, 0x07916D6D, 
        0x07916D6D, 0x089F7F7F, 0x098D7171, 0x098D7171, 0x098D7171, 0x098D7171, 0x098D7171, 0x098D7171, 0x0A996666, 0x0A997F66, 0x0A997F66, 0x09A98D71, 0x09A98D8D, 0x09A98D71, 0x098D7171, 0x089F7F7F, 0x089F7F7F, 0x089F7F7F, 0x087F7F7F, 0x087F7F7F, 
        0x07916D6D, 0x06AA7F7F, 0x06AA7F7F, 0x067F7F7F, 0x067F7F55, 0x05996666, 0x047F7F7F, 0x047F7F7F, 0x03AA5555, 0x027F7F7F, 0x027F0000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FF0000, 0x01FF0000, 0x027F7F7F, 0x027F7F7F, 0x03AA5555, 0x03AA5555, 0x047F7F7F, 0x047F7F7F, 0x05996666, 0x05996666, 0x05996666, 
        0x067F7F55, 0x067F7F7F, 0x067F7F7F, 0x06AA7F7F, 0x07916D6D, 0x06AA7F7F, 0x06AA7F7F, 0x06AA7F7F, 0x06AA7F7F, 0x06AA7F7F, 0x06AA7F7F, 0x06AA7F7F, 0x06AA7F7F, 0x06AA7F7F, 0x06AA7F7F, 0x067F7F7F, 0x067F7F7F, 0x067F7F7F, 0x05999999, 0x05996666, 
        0x05996666, 0x047F7F7F, 0x047F7F7F, 0x047F7F7F, 0x03AA5555, 0x03AA5555, 0x027F7F7F, 0x027F7F7F, 0x01FF0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FF0000, 0x01FF0000, 0x027F7F7F, 0x027F7F7F, 0x027F7F7F, 0x03AA5555, 0x03AA5555, 
        0x03AA5555, 0x047F7F7F, 0x047F7F7F, 0x047F7F7F, 0x047F7F7F, 0x047F7F7F, 0x047F7F7F, 0x04BFBF7F, 0x04BFBF7F, 0x04BFBF7F, 0x04BF7F7F, 0x047F7F7F, 0x047F7F7F, 0x047F7F7F, 0x047F7F7F, 0x047F7F7F, 0x047F7F7F, 0x03AA5555, 0x03AA5555, 0x03AA5555, 
        0x027F7F7F, 0x027F7F7F, 0x027F7F7F, 0x01FF0000, 0x01FF0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01FF0000, 
        0x01FF0000, 0x01FF0000, 0x01FF0000, 0x027F7F7F, 0x027F7F7F, 0x027F7F7F, 0x01FFFFFF, 0x027F7F7F, 0x027F7F7F, 0x027F7F7F, 0x027F7F7F, 0x027F7F7F, 0x027F7F7F, 0x027F7F7F, 0x027F7F7F, 0x027F7F7F, 0x01FF0000, 0x01FF0000, 0x01FF0000, 0x01FF0000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
#else
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 
        0xFEFFFFFF, 0xFEFFFFFF, 0xFCAAAAAA, 0xFC55AAAA, 0xFCAAAAAA, 0xFC55AAAA, 0xFCAAAAAA, 0xFC55AAAA, 0xFC55AAAA, 0xFC55AAAA, 0xFC55AAAA, 0xFC5555AA, 0xFC55AAAA, 0xFCAAAAAA, 0xFCAAAAAA, 0xFCAAAAAA, 0xFD7FFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 
        0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFCAAAAAA, 0xFCAAAAAA, 0xFCAAAAAA, 0xFCAAAAAA, 0xFCAAAAAA, 
        0xFCAAAAAA, 0xFA999999, 0xFA999999, 0xFA999999, 0xFA669999, 0xFA999999, 0xFA999999, 0xF97F7F7F, 0xF97F7F7F, 0xFA669999, 0xF97F7F7F, 0xF97F7F7F, 0xFA999999, 0xFA999999, 0xFA669999, 0xFA669999, 0xFA669999, 0xFA669999, 0xFCAAAAAA, 0xFCAAAAAA, 
        0xFCAAAAAA, 0xFCAAAAAA, 0xFCAAAAAA, 0xFD7F7F7F, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFD7F7F7F, 0xFCAAAAAA, 0xFCAAAAAA, 0xFCAAAAAA, 0xFA999999, 0xFA999999, 0xFA999999, 0xFA999999, 0xF97F7F7F, 0xF86D9191, 
        0xF86D9191, 0xF86D9191, 0xF8919191, 0xF8919191, 0xF75F5F7F, 0xF75F7F7F, 0xF75F7F7F, 0xF77F7F7F, 0xF77F7F7F, 0xF75F5F5F, 0xF75F7F7F, 0xF75F7F7F, 0xF86D6D6D, 0xF75F7F7F, 0xF75F5F7F, 0xF86D6D6D, 0xF86D6D6D, 0xF86D6D6D, 0xF97F7F7F, 0xF97FAAAA, 
        0xFA999999, 0xFA999999, 0xFA999999, 0xFA999999, 0xFCAAAAAA, 0xFCAAAAAA, 0xFCAAAAAA, 0xFCAAAAAA, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFEFFFFFF, 0xFEFFFFFF, 0xFCAAAAAA, 0xFCAAAAAA, 0xFCAAAAAA, 0xFA669999, 0xFA669999, 0xF97F7F7F, 0xF97F7F7F, 0xF86D6D91, 0xF86D9191, 0xF8919191, 0xF77F9F9F, 0xF77F7F7F, 0xF6717171, 
        0xF6547171, 0xF566667F, 0xF566667F, 0xF566667F, 0xF5334C4C, 0xF4455C5C, 0xF45C5C73, 0xF57F7F99, 0xF45C5C73, 0xF5334C4C, 0xF445455C, 0xF4455C5C, 0xF4455C5C, 0xF445455C, 0xF54C4C66, 0xF5334C4C, 0xF54C4C66, 0xF54C4C66, 0xF6547171, 0xF6547171, 
        0xF77F7F7F, 0xF77F7F7F, 0xF8919191, 0xF86D9191, 0xF86D9191, 0xFA999999, 0xFA999999, 0xFA669999, 0xFB7F7F7F, 0xFCAAAAAA, 0xFCAAAAAA, 0xFD7F7F7F, 0xFEFFFFFF, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFEFFFFFF, 0xFCAAAAAA, 0xFCAAAAAA, 0xFCAAAAAA, 0xFA669999, 0xFA999999, 0xF97F7FAA, 0xF86D9191, 0xF75F5F7F, 0xF75F5F5F, 0xF6385454, 0xF54C4C66, 0xF54C6666, 0xF54C6666, 0xF45C5C73, 0xF355556A, 0xF4455C5C, 
        0xF33F3F55, 0xF23A4E4E, 0xF355556A, 0xF23A4E62, 0xF2273A4E, 0xF1363648, 0xF136485B, 0xF15B5B6D, 0xF136485B, 0xF2273A3A, 0xF1243648, 0xF1363648, 0xF23A4E4E, 0xF1363648, 0xF23A3A4E, 0xF2273A4E, 0xF33F3F55, 0xF33F3F55, 0xF33F5555, 0xF33F5555, 
        0xF4455C73, 0xF45C7373, 0xF5667F7F, 0xF5667F7F, 0xF6717171, 0xF6717171, 0xF77F7F7F, 0xF77F7F9F, 0xF86D9191, 0xFA999999, 0xFA999999, 0xFA669999, 0xFCAAAAAA, 0xFCAAAAAA, 0xFD7F7F7F, 0xFEFFFFFF, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 
        0xFEFFFFFF, 0xFD7F7F7F, 0xFCAAAAAA, 0xFCAAAAAA, 0xFA669999, 0xF97F7FAA, 0xF86D9191, 0xF77F7F7F, 0xF77F7F7F, 0xF6718D8D, 0xF6717171, 0xF4455C5C, 0xF445455C, 0xF42E2E45, 0xF32A3F55, 0xF33F3F55, 0xF23A3A4E, 0xF136485B, 0xF136485B, 0xF0334455, 
        0xF0333344, 0xF0223344, 0xEF2F3F4F, 0xEF2F2F3F, 0xEF1F2F3F, 0xEF1F2F3F, 0xEE2D3C4B, 0xEE3C4B5A, 0xEE3C4B5A, 0xEE1E2D3C, 0xEE2D3C3C, 0xEE2D3C4B, 0xEF2F3F4F, 0xEF2F3F3F, 0xEF2F3F4F, 0xEF2F3F4F, 0xF0334444, 0xF0334444, 0xF0334455, 0xF0334455, 
        0xF1485B5B, 0xF15B5B6D, 0xF24E6262, 0xF3556A6A, 0xF3556A6A, 0xF45C7373, 0xF473738B, 0xF57F7F99, 0xF6718D8D, 0xF68D8D8D, 0xF77F9F9F, 0xF8919191, 0xFA999999, 0xFA999999, 0xFA999999, 0xFCAAAAAA, 0xFCAAAAAA, 0xFEFFFFFF, 0xFEFFFFFF, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFEFFFFFF, 0xFCAAAAAA, 
        0xFCAAAAAA, 0xFA669999, 0xFA999999, 0xF86D9191, 0xF86D9191, 0xF77F7F7F, 0xF6547171, 0xF5667F7F, 0xF45C7373, 0xF45C7373, 0xF24E6262, 0xF23A4E4E, 0xF1363648, 0xF1363648, 0xF0223344, 0xEF2F2F3F, 0xEE2D2D4B, 0xEE2D2D4B, 0xED2A3846, 0xED2A3846, 
        0xED2A3838, 0xEC283535, 0xEC283535, 0xEB26333F, 0xEB26263F, 0xEB26333F, 0xEB26333F, 0xEB33334C, 0xEB333F4C, 0xEB26333F, 0xEB26333F, 0xEB26333F, 0xEB26333F, 0xEB26333F, 0xEC283543, 0xEC283543, 0xEC283543, 0xED2A3846, 0xED2A3846, 0xEE2D3C4B, 
        0xEE3C4B4B, 0xEE4B4B5A, 0xEF3F4F4F, 0xF0334455, 0xF0445555, 0xF15B6D6D, 0xF15B6D7F, 0xF2627589, 0xF36A7F7F, 0xF4738B8B, 0xF4738B8B, 0xF6718D8D, 0xF6718D8D, 0xF77F7F9F, 0xF8919191, 0xFA999999, 0xFA999999, 0xFB7F7F7F, 0xFCAAAAAA, 0xFD7F7F7F, 
        0xFEFFFFFF, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFEFFFFFF, 0xFCAAAAAA, 0xFCAAAAAA, 0xFA999999, 
        0xF97F7FAA, 0xF86D9191, 0xF77F7F9F, 0xF6718D8D, 0xF5667F7F, 0xF4455C5C, 0xF4455C5C, 0xF33F5555, 0xF148485B, 0xF148485B, 0xF0444455, 0xEF2F3F4F, 0xEE2D3C4B, 0xEE2D3C4B, 0xEC282843, 0xEC283543, 0xEC282843, 0xEB26333F, 0xEA24303C, 0xEA24303C, 
        0xE9222E39, 0xE9222E39, 0xE9222E39, 0xE8212C37, 0xE8212C37, 0xE8212C37, 0xE8212C37, 0xE71F2A35, 0xE72A353F, 0xE71F2A35, 0xE71F3535, 0xE71F353F, 0xE8212C42, 0xE82C3742, 0xE8212C42, 0xE8212C42, 0xE9222E45, 0xE9222E45, 0xEA243048, 0xEA303048, 
        0xEA303048, 0xEB333F4C, 0xEC353543, 0xED2A3846, 0xED384654, 0xEE4B5A69, 0xEF4F5F6F, 0xEF5F6F7F, 0xF0556666, 0xF1485B6D, 0xF24E6262, 0xF3556A6A, 0xF473738B, 0xF57F9999, 0xF57F7F99, 0xF68D8D8D, 0xF8919191, 0xF8919191, 0xFA999999, 0xFA999999, 
        0xFCAAAAAA, 0xFCAAAAAA, 0xFEFFFFFF, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFD7F7F7F, 0xFCAAAAAA, 0xFB7F7F7F, 0xFA999999, 0xF97F7F7F, 0xF8919191, 
        0xF77F7F7F, 0xF6547171, 0xF473738B, 0xF37F7F7F, 0xF36A7F7F, 0xF1485B5B, 0xF0445566, 0xF0334455, 0xEE2D3C4B, 0xEE2D3C4B, 0xEC353550, 0xEC283543, 0xEB26333F, 0xEA24303C, 0xEA24303C, 0xE8212C42, 0xE8212C37, 0xE71F2A35, 0xE71F2A3F, 0xE61E283D, 
        0xE61E2833, 0xE61E2833, 0xE527273A, 0xE527273A, 0xE4252538, 0xE425252F, 0xE41C252F, 0xE41C252F, 0xE41C2F38, 0xE41C2F2F, 0xE4252F38, 0xE4252F38, 0xE41C2538, 0xE4252F42, 0xE51D273A, 0xE51D273A, 0xE527313A, 0xE628333D, 0xE628333D, 0xE628333D, 
        0xE72A2A3F, 0xE82C3742, 0xE82C3742, 0xE92E3945, 0xEA303C48, 0xEB3F4C59, 0xEB3F4C59, 0xEC43505D, 0xED2A3846, 0xEE3C4B5A, 0xEF2F3F4F, 0xF136485B, 0xF15B6D6D, 0xF2757575, 0xF36A7F7F, 0xF4738B8B, 0xF57F7F99, 0xF6718D8D, 0xF77F7F9F, 0xF8919191, 
        0xFA999999, 0xFA999999, 0xFCAAAAAA, 0xFCAAAAAA, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFEFFFFFF, 0xFCAAAAAA, 0xFB7F7F7F, 0xFA999999, 0xF97F7F7F, 0xF77F7F7F, 0xF6718D8D, 0xF57F7F7F, 
        0xF45C738B, 0xF33F5555, 0xF23A4E62, 0xF15B6D7F, 0xEF6F7F7F, 0xEF4F5F6F, 0xEE3C4B5A, 0xED384654, 0xEB333F4C, 0xEA303048, 0xE92E3945, 0xE82C2C42, 0xE72A2A3F, 0xE71F2A3F, 0xE628283D, 0xE527313A, 0xE41C2538, 0xE41C2538, 0xE3242D36, 0xE3242D36, 
        0xE21A2334, 0xE21A2334, 0xE1222A33, 0xE1222A3B, 0xE1222A33, 0xE0202031, 0xE0202031, 0xE0182029, 0xE0182029, 0xE0182929, 0xE0202931, 0xE0182931, 0xE0202931, 0xE1222A33, 0xE122223B, 0xE122223B, 0xE1222233, 0xE2232B34, 0xE2232B34, 0xE3242D36, 
        0xE31B243F, 0xE41C2538, 0xE527313A, 0xE628333D, 0xE72A353F, 0xE7353F4A, 0xE82C3742, 0xE92E3951, 0xEA243048, 0xEB26334C, 0xEC283550, 0xED384654, 0xEE4B5A5A, 0xEF3F4F4F, 0xF0445555, 0xF16D7F7F, 0xF2757589, 0xF4738B8B, 0xF4738B8B, 0xF68D8D8D, 
        0xF77F9F9F, 0xF8919191, 0xFA999999, 0xFA999999, 0xFCAAAAAA, 0xFD7F7F7F, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFCAAAAAA, 0xFCAAAAAA, 0xFA999999, 0xF97F7FAA, 0xF8919191, 0xF6718D8D, 0xF5667F7F, 0xF45C7373, 0xF3556A6A, 
        0xF2626275, 0xF0556666, 0xEF2F3F4F, 0xED2A3846, 0xEC43505D, 0xEB3F4C59, 0xEA304854, 0xE9394551, 0xE837424D, 0xE735353F, 0xE628333D, 0xE527313A, 0xE4252F38, 0xE3242D3F, 0xE2232B3D, 0xE1222A3B, 0xE1222A3B, 0xE0182031, 0xDF17272F, 0xDF1F2737, 
        0xDE171E2E, 0xDE171E2E, 0xDD1E2534, 0xDD252534, 0xDD252534, 0xDD1E1E2D, 0xDC1D1D2B, 0xDC151D2B, 0xDC151D24, 0xDC152424, 0xDC1D2B2B, 0xDC1D2B32, 0xDC1D2432, 0xDD1E2534, 0xDD1E2534, 0xDD1E2534, 0xDE17262E, 0xDE1E262E, 0xDF1F272F, 0xDF1F2737, 
        0xE0182039, 0xE0182039, 0xE1222A3B, 0xE2232B3D, 0xE3242D36, 0xE41C2F38, 0xE527313A, 0xE5273144, 0xE71F2A3F, 0xE8212C42, 0xE9222E45, 0xE92E3945, 0xEA303C48, 0xEC283543, 0xEE2D3C4B, 0xEE4B5A5A, 0xF0555566, 0xF16D6D7F, 0xF2757589, 0xF37F7F7F, 
        0xF4738B8B, 0xF6718D8D, 0xF77F7F9F, 0xF8919191, 0xFA999999, 0xFB7F7F7F, 0xFCAAAAAA, 0xFD7F7F7F, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFD7F7F7F, 0xFCAAAAAA, 0xFA999999, 0xF97F7F7F, 0xF8919191, 0xF6718D8D, 0xF57F7F99, 0xF4738B8B, 0xF3556A7F, 0xF136485B, 0xF0334455, 
        0xEF2F3F4F, 0xED384654, 0xEC354350, 0xEA243C48, 0xE9222E45, 0xE82C3742, 0xE72A3F4A, 0xE6333D47, 0xE5313A44, 0xE42F3842, 0xE22B343D, 0xE1222A3B, 0xE0202939, 0xE0202939, 0xDF1F2737, 0xDE1E2636, 0xDD1E2534, 0xDD1E2534, 0xDC1D2432, 0xDB1C2331, 
        0xDB151C2A, 0xDA141B29, 0xDA1B2230, 0xD921212E, 0xD91A212E, 0xD91A1A2E, 0xD81A1A27, 0xD8131A27, 0xD8131A27, 0xD81A2727, 0xD81A272D, 0xD81A272D, 0xD81A202D, 0xD91A212E, 0xD91A212E, 0xD91A212E, 0xDA142230, 0xDA1B2229, 0xDB1C2A31, 0xDB1C2A38, 
        0xDC1D2432, 0xDD1E2534, 0xDE1E2E3D, 0xDE1E2E3D, 0xDF1F2737, 0xE0182931, 0xE1222A33, 0xE2232B3D, 0xE31B2436, 0xE41C2538, 0xE61E283D, 0xE71F353F, 0xE8212C37, 0xE9222E39, 0xEA303C48, 0xEB333F3F, 0xED384654, 0xEE4B5A5A, 0xEF5F5F6F, 0xF15B6D6D, 
        0xF2757575, 0xF37F7F94, 0xF4738B8B, 0xF68D8D8D, 0xF8919191, 0xF8919191, 0xFA999999, 0xFB7F7F7F, 0xFCAAAAAA, 0xFD7F7F7F, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFEFFFFFF, 0xFCAAAAAA, 0xFB7F7F7F, 0xFA999999, 0xF8919191, 0xF77F9F9F, 0xF57F7F99, 0xF48B8B8B, 0xF2627589, 0xF15B6D7F, 0xF0556677, 0xEE3C4B5A, 0xED384654, 
        0xEB26334C, 0xEA24303C, 0xE9223945, 0xE72A353F, 0xE628333D, 0xE51D313A, 0xE3242D3F, 0xE22B3446, 0xE12A3344, 0xE0293141, 0xDF272F3F, 0xDE262E3D, 0xDD1E2534, 0xDC1D2432, 0xDB1C2331, 0xDA1B2930, 0xD91A212E, 0xD91A212E, 0xD8202734, 0xD71F2632, 
        0xD6181F2B, 0xD612182B, 0xD5181E2A, 0xD5182430, 0xD5181E30, 0xD4171D29, 0xD4111729, 0xD4111723, 0xD4171D23, 0xD4172329, 0xD4172329, 0xD4172329, 0xD4171D2F, 0xD5182430, 0xD5182430, 0xD5181E2A, 0xD6121F25, 0xD6181F2B, 0xD71F2632, 0xD7192632, 
        0xD81A2734, 0xD91A2835, 0xDA1B2937, 0xDA222937, 0xDB1C2A31, 0xDD16252D, 0xDD1E2D34, 0xDE1E2E36, 0xDF171F37, 0xE0182039, 0xE21A2334, 0xE31B2D36, 0xE41C2F38, 0xE527313A, 0xE72A353F, 0xE82C3742, 0xE9393951, 0xEB3F4C59, 0xEC50505D, 0xED465454, 
        0xEF5F6F6F, 0xF0777788, 0xF2758989, 0xF36A7F7F, 0xF57F7F99, 0xF68D8D8D, 0xF77F7F9F, 0xF97F7F7F, 0xFA999999, 0xFB7F7F7F, 0xFD7F7F7F, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFD7F7F7F, 0xFB7F7F7F, 0xFA999999, 0xF97F7F7F, 0xF77F7F9F, 0xF68D8D8D, 0xF48B8B8B, 0xF37F9494, 0xF17F7F91, 0xF0667777, 0xEF4F5F6F, 0xED465463, 0xEB334C59, 0xEA303C54, 
        0xE92E3945, 0xE72A353F, 0xE5273144, 0xE4252F38, 0xE3242D3F, 0xE122333B, 0xE0202939, 0xDF272F3F, 0xDD2D343C, 0xDC2B3241, 0xDB2A313F, 0xDA222937, 0xD91A2835, 0xD81A202D, 0xD7192632, 0xD6182531, 0xD5182430, 0xD417232F, 0xD417232F, 0xD31C2234, 
        0xD2161C2D, 0xD2101C2D, 0xD1101B26, 0xD116212C, 0xD116212C, 0xD015202B, 0xD0101B25, 0xD0151B25, 0xD0151B25, 0xD01B2025, 0xD01B2025, 0xD01B202B, 0xD0151B30, 0xD01B2030, 0xD11B212C, 0xD1162126, 0xD1101B21, 0xD216212D, 0xD2212732, 0xD317222E, 
        0xD417232F, 0xD5182430, 0xD5182A30, 0xD61F2B31, 0xD7192632, 0xD91A282E, 0xDA1B2930, 0xDA1B2930, 0xDC1D2432, 0xDD1E2534, 0xDE172636, 0xDF172737, 0xE0182931, 0xE2232B34, 0xE4252F38, 0xE42F2F42, 0xE6333D47, 0xE837424D, 0xE9394551, 0xEA484861, 
        0xEC505D5D, 0xED637171, 0xEF4F5F6F, 0xF0666677, 0xF2758989, 0xF37F7F94, 0xF57F7F99, 0xF6718D8D, 0xF8919191, 0xF97F7F7F, 0xFB7F7F7F, 0xFC55AAAA, 0xFD7F7F7F, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFCAAAAAA, 0xFB7F7F7F, 0xFA999999, 0xF8919191, 0xF6718D8D, 0xF57F9999, 0xF37F9494, 0xF289899C, 0xF0667788, 0xEE696978, 0xED546371, 0xEB4C5966, 0xEA3C4854, 0xE92E4551, 0xE72A354A, 
        0xE5273144, 0xE42F3842, 0xE22B3446, 0xE0203139, 0xDF1F2F37, 0xDD1E2D3C, 0xDC1D2B3A, 0xDB232A38, 0xDA222937, 0xD9282E3C, 0xD7262C39, 0xD61F2531, 0xD5182430, 0xD4171D29, 0xD317222E, 0xD21C2132, 0xD1212637, 0xD01B2536, 0xCF1A1F2F, 0xCE1A1F2E, 
        0xCE141A29, 0xCE141A29, 0xCD0F1928, 0xCC141E2D, 0xCC141E2D, 0xCC141E2D, 0xCC141E28, 0xCB131822, 0xCB181D22, 0xCB181D27, 0xCB181D27, 0xCC191E2D, 0xCC191E32, 0xCC191E2D, 0xCC191E2D, 0xCD0F1923, 0xCD141E23, 0xCE1F292E, 0xCE1F2934, 0xCF151F2F, 
        0xD015202B, 0xD116212C, 0xD116262C, 0xD21C2D32, 0xD31C282E, 0xD41D292F, 0xD51E2A30, 0xD6182B31, 0xD81A202D, 0xD91A212E, 0xDA1B2230, 0xDC1D2432, 0xDD1E2D34, 0xDE262E36, 0xE0293139, 0xE12A3344, 0xE32D3648, 0xE42F384B, 0xE6333D47, 0xE73F4A54, 
        0xE9394551, 0xEB333F4C, 0xED384654, 0xEE697887, 0xEF7F8F8F, 0xF17F9191, 0xF37F9494, 0xF48B8B8B, 0xF68D8D8D, 0xF77F7F9F, 0xF97F7F7F, 0xFA669999, 0xFB7F7F7F, 0xFD7F7F7F, 0xFE00FFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFD7F7F7F, 0xFCAAAAAA, 0xFA999999, 0xF97FAAAA, 0xF77F9F9F, 0xF68D8D8D, 0xF48BA2A2, 0xF37F9494, 0xF17F9191, 0xEF7F7F8F, 0xED546371, 0xEC505D6B, 0xEA3C5461, 0xE837424D, 0xE72A3F4A, 0xE5273A44, 0xE324363F, 
        0xE2232B3D, 0xE0293141, 0xDE263645, 0xDD2D3443, 0xDB23313F, 0xDA1B2937, 0xD8202734, 0xD71F2639, 0xD61F2531, 0xD423293B, 0xD3222839, 0xD2212738, 0xD11B2631, 0xD015202B, 0xCE1A1F2E, 0xCD192333, 0xCC1E2832, 0xCC1E2837, 0xCB182231, 0xCA18212B, 
        0xCA131C2B, 0xC9121C2A, 0xC90E1725, 0xC8121B29, 0xC7121B28, 0xC7121B28, 0xC7121B24, 0xC7121B24, 0xC7161B24, 0xC7161B24, 0xC71B1F24, 0xC7161B2D, 0xC7161B32, 0xC7121F28, 0xC8121B25, 0xC8121B20, 0xC9172125, 0xC91C252F, 0xCA182130, 0xCB131D2C, 
        0xCB131D2C, 0xCC14232D, 0xCD192333, 0xCE1A292E, 0xCF1A252A, 0xD01B2B2B, 0xD11B2C2C, 0xD3172228, 0xD4172329, 0xD518242A, 0xD61F2531, 0xD8202D34, 0xD9212E3C, 0xDA22303E, 0xDC242B3A, 0xDD25253C, 0xDF1F273F, 0xE12A3344, 0xE22B3446, 0xE42F3842, 
        0xE6333D47, 0xE73F4A54, 0xE9687F7F, 0xEB7F8C8C, 0xED717F8D, 0xEE788787, 0xF0888899, 0xF2898989, 0xF37F7F94, 0xF57F7F99, 0xF6718D8D, 0xF86D9191, 0xF97F7F7F, 0xFB7F7F7F, 0xFC55AAAA, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFD7F7F7F, 0xFB7FBFBF, 0xFA999999, 0xF89191B6, 0xF79F9F9F, 0xF59999B2, 0xF39494AA, 0xF19191A3, 0xF09999AA, 0xEE879696, 0xEC787886, 0xEB596672, 0xE945515C, 0xE7353F54, 0xE5313A4E, 0xE4253842, 0xE223343D, 0xE0203141, 
        0xDE262E36, 0xDD252D3C, 0xDC2B3241, 0xD9283543, 0xD8202D3A, 0xD61F2537, 0xD4172935, 0xD4172335, 0xD21C2132, 0xD01B2536, 0xCF1F2A35, 0xCE1F2939, 0xCD232838, 0xCC191E2D, 0xCA181C2B, 0xC91C212F, 0xC81B2532, 0xC81B2532, 0xC61A1F2C, 0xC6161F2C, 
        0xC5151E2B, 0xC4111E26, 0xC4111922, 0xC4151926, 0xC319192A, 0xC3151D2A, 0xC2101D25, 0xC20C1921, 0xC2101D25, 0xC2141D25, 0xC2141D21, 0xC2192129, 0xC315192E, 0xC311192A, 0xC3151D26, 0xC4151E26, 0xC419222B, 0xC51A232B, 0xC51A1E27, 0xC6161F23, 
        0xC7161F24, 0xC8172529, 0xC91C252A, 0xCA1C262B, 0xCB18222C, 0xCC19232D, 0xCD14232D, 0xCE1A1F29, 0xD01B2530, 0xD1212C31, 0xD3222834, 0xD4232935, 0xD6252B37, 0xD7262C39, 0xD8202034, 0xDA1B2237, 0xDC1D243A, 0xDD252D3C, 0xDF1F2737, 0xE1223344, 
        0xE3363F51, 0xE44B5E67, 0xE65B667A, 0xE858636E, 0xEA54616D, 0xEB667272, 0xED717F8D, 0xEF7F8F8F, 0xF17F9191, 0xF2758989, 0xF4738B8B, 0xF6718D8D, 0xF77F7F9F, 0xF97F7F7F, 0xFA669999, 0xFC55AAAA, 0xFD7F7F7F, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFEFFFFFF, 0xFCAAAAAA, 0xFB7FBFBF, 0xF9AAAAAA, 0xF891B6B6, 0xF68DA9A9, 0xF4A2A2A2, 0xF3AAAAAA, 0xF1A3A3A3, 0xEF8F9F9F, 0xED8D9B9B, 0xEB727F7F, 0xE95C5C73, 0xE8424D58, 0xE6333D51, 0xE42F384B, 0xE22B3446, 0xE0203141, 0xDE1E2E3D, 0xDC242432, 
        0xDB1C2331, 0xD9212835, 0xD7262C39, 0xD524303C, 0xD41D293B, 0xD21C2738, 0xD01B2536, 0xCF152535, 0xCD141E33, 0xCC192337, 0xCB1D2735, 0xC91C2133, 0xC8202537, 0xC71F2436, 0xC61A1F31, 0xC51A1E30, 0xC419222F, 0xC319222E, 0xC2192132, 0xC118202D, 
        0xC0142028, 0xC0141C28, 0xBF131B23, 0xBF171B27, 0xBE1F172B, 0xBE1B1F2B, 0xBE131B2B, 0xBE0B1B23, 0xBD0F1E22, 0xBD131E22, 0xBE131F23, 0xBE171F2B, 0xBE13172B, 0xBE0F1727, 0xBE171F2B, 0xBF1B1F2B, 0xC01C202C, 0xC01C2028, 0xC1182024, 0xC1181C20, 
        0xC3192222, 0xC31D2226, 0xC4192226, 0xC61A2328, 0xC6162328, 0xC8172029, 0xC917252F, 0xCA1C2130, 0xCB222735, 0xCD232838, 0xCE242934, 0xD0252536, 0xD1262637, 0xD3222234, 0xD51E1E30, 0xD61F2531, 0xD81A272D, 0xDA1B2937, 0xDC1D2B32, 0xDE263645, 
        0xDF3F4757, 0xE1445566, 0xE3363F51, 0xE5313A4E, 0xE754546A, 0xE8636E79, 0xEA798591, 0xEC869393, 0xEE879696, 0xF0889999, 0xF289899C, 0xF37F9494, 0xF57F9999, 0xF77F7F9F, 0xF8919191, 0xFA999999, 0xFB7F7F7F, 0xFD7F7F7F, 0xFEFFFFFF, 0xFEFFFFFF,
  0xFEFFFFFF, 0xFCAAAAAA, 0xFA999999, 0xF97FAAAA, 0xF79F9F9F, 0xF68DA9A9, 0xF48BA2A2, 0xF2899C9C, 0xF09999AA, 0xEE9696A5, 0xED8D9B9B, 0xEA859191, 0xE8636E79, 0xE6475166, 0xE438424B, 0xE22B3446, 0xE12A3344, 0xDF1F2F3F, 0xDD1E2D34, 0xDB1C2331, 0xD91A282E, 
        0xD71F1F2C, 0xD51E1E30, 0xD31C2834, 0xD2212738, 0xD11B2637, 0xCF1A2535, 0xCC192332, 0xCC142332, 0xC912212F, 0xC8172532, 0xC61F283A, 0xC51A1E30, 0xC41E2233, 0xC3262A3B, 0xC1202435, 0xC014182C, 0xC0141C2C, 0xBE171F2F, 0xBE1B232F, 0xBC16222D, 
        0xBC131A26, 0xBB161E25, 0xBA162124, 0xBA161928, 0xBA1D192C, 0xB91D202F, 0xB9121D28, 0xB90A1920, 0xB90E1D24, 0xB9121D24, 0xB9151D20, 0xB919202B, 0xB9121928, 0xB90E1524, 0xBA161D2C, 0xBA19212C, 0xBB1A2129, 0xBB1A2129, 0xBC161E26, 0xBD171B22, 
        0xBE1B1F27, 0xBF1B2327, 0xC01C2428, 0xC1182029, 0xC2192129, 0xC319222A, 0xC419262F, 0xC61F2835, 0xC8252937, 0xC9212533, 0xCB222731, 0xCC232832, 0xCD1E2333, 0xD01B202B, 0xD11B212C, 0xD31C222E, 0xD4172329, 0xD7192632, 0xD91A2835, 0xDA29303E, 
        0xDC324150, 0xDE2E3D4D, 0xDF272F47, 0xE1333B55, 0xE35B6476, 0xE56B7589, 0xE7747F8A, 0xE98B9696, 0xEB8C9999, 0xED8D9B9B, 0xEF8F8F9F, 0xF19191A3, 0xF3949494, 0xF57F9999, 0xF68D8DA9, 0xF8919191, 0xFA999999, 0xFB7F7F7F, 0xFD7F7F7F, 0xFD7F7F7F,
  0xFCAAAAAA, 0xFA999999, 0xF97FAAAA, 0xF79F9F9F, 0xF5999999, 0xF3949494, 0xF19191A3, 0xEF8F8F9F, 0xED7F8D8D, 0xEB8C8C99, 0xE97F7F8B, 0xE76A6A74, 0xE54E5862, 0xE4384254, 0xE2343D4F, 0xE0293141, 0xDE262E3D, 0xDB232A38, 0xD91A282E, 0xD719262C, 0xD5181E2A, 
        0xD3171728, 0xD1161B26, 0xCF151F2A, 0xCE1A1F2E, 0xCC1E2337, 0xCA182134, 0xC8121B2E, 0xC7121F32, 0xC5152334, 0xC3151D2E, 0xC21D2536, 0xC1202939, 0xBF1B2333, 0xBE23273A, 0xBD1E2636, 0xBC131629, 0xBB161E2D, 0xB915202B, 0xB915202F, 0xB815202B, 
        0xB7111C26, 0xB6141F26, 0xB6141F26, 0xB5181B25, 0xB51B1B29, 0xB4171E2C, 0xB4111E28, 0xB40D1B22, 0xB4111E25, 0xB4141E25, 0xB4141E22, 0xB4171B28, 0xB4141725, 0xB5141829, 0xB51B1E2C, 0xB5181E2C, 0xB6141F29, 0xB7181F2A, 0xB815202B, 0xB9192028, 
        0xB91D2028, 0xBA192124, 0xBB1A2125, 0xBD1B222A, 0xBE17232B, 0xBF17232B, 0xC0182830, 0xC11C2431, 0xC3222633, 0xC4222633, 0xC61F2331, 0xC81B202E, 0xCA1C212B, 0xCB181D2C, 0xCD191E28, 0xCF1A1F2A, 0xD116212C, 0xD317222E, 0xD5182430, 0xD726323F, 
        0xD9212E3C, 0xDA222937, 0xDC243241, 0xDE363D4D, 0xE14C5566, 0xE2606972, 0xE4717A84, 0xE77F8A94, 0xE8849090, 0xEA859191, 0xED8D9B9B, 0xEE879696, 0xF0889999, 0xF2899C9C, 0xF48BA2A2, 0xF68D8D8D, 0xF8919191, 0xF97F7FAA, 0xFB7F7F7F, 0xFB7F7F7F,
  0xFA999999, 0xF891B6B6, 0xF6A9A9A9, 0xF5999999, 0xF3AAAAAA, 0xF1A3A3A3, 0xEF9F9FAF, 0xED9B9BA9, 0xEB9999A5, 0xE98B9696, 0xE7747F8A, 0xE44B545E, 0xE2343D4F, 0xE0394152, 0xDE2E3D4D, 0xDC2B3241, 0xDA22303E, 0xD81A272D, 0xD618252B, 0xD3172222, 0xD1162126, 
        0xCF151A25, 0xCD141928, 0xCB131D2C, 0xC9121C25, 0xC8172532, 0xC6162331, 0xC411192B, 0xC214212D, 0xC2192132, 0xBF131B2B, 0xBE1B2332, 0xBC293140, 0xBB1A2130, 0xB91D2436, 0xB8192335, 0xB7151C2E, 0xB6141B29, 0xB5141B29, 0xB4141B2C, 0xB3171E2B, 
        0xB217212B, 0xB2131D27, 0xB1131D23, 0xB0161C29, 0xB0191C2D, 0xB0161C29, 0xAF131C29, 0xAF0C1C26, 0xAF131C22, 0xAF161C22, 0xAF161C22, 0xAF191926, 0xAF161926, 0xB0191C29, 0xB0191C29, 0xB116202A, 0xB11A232D, 0xB217212E, 0xB317212E, 0xB31A212E, 
        0xB41E1E28, 0xB51B222C, 0xB61B1F29, 0xB819202B, 0xB919242B, 0xBA16242C, 0xBB1A2530, 0xBD1B222E, 0xBE1F2332, 0xC0202430, 0xC21D212D, 0xC3191D2A, 0xC51A1E27, 0xC71B1F28, 0xC9171C2A, 0xCA1C212B, 0xCD191E2D, 0xCE1A1F29, 0xD01B202B, 0xD31C2834, 
        0xD41D2935, 0xD71F2632, 0xD928353C, 0xDB313F4D, 0xDD4B5261, 0xDF575F6F, 0xE16E777F, 0xE37F8891, 0xE6848E99, 0xE8849B9B, 0xEA85919D, 0xEC939393, 0xEE879696, 0xF0889999, 0xF2899C9C, 0xF48BA2A2, 0xF68D8D8D, 0xF77F9F9F, 0xF97FAAAA, 0xF97FAAAA,
  0xF8B6B6B6, 0xF6A9A9A9, 0xF4A2A2A2, 0xF3AAAAAA, 0xF0AAAAAA, 0xEEA5A5A5, 0xECA1A1AE, 0xEAA9A9A9, 0xE8A6A6B1, 0xE69999A3, 0xE4848D97, 0xE27B838C, 0xDF6F777F, 0xDD69707F, 0xDB46465C, 0xD92E3543, 0xD6253137, 0xD4172329, 0xD2162127, 0xD0152025, 0xCE141F24, 
        0xCB131822, 0xC90E1725, 0xC80D1725, 0xC50D1A27, 0xC4192233, 0xC2192532, 0xC0142030, 0xBE171F2F, 0xBC1A1E31, 0xBB161E2D, 0xB9191D2F, 0xB8232B3D, 0xB6181F30, 0xB5182233, 0xB3172132, 0xB2172131, 0xB1161D2D, 0xB0131926, 0xAF131929, 0xAE151F2B, 
        0xAD151F2B, 0xAD121B28, 0xAC121B24, 0xAB181B27, 0xAB181B2A, 0xAB151E2A, 0xAA0F1B27, 0xAA0F1E27, 0xAA152127, 0xAA1B2127, 0xAA1B1E24, 0xAA1B1E24, 0xAA181B24, 0xAB181E27, 0xAB1B1E2A, 0xAC181E2E, 0xAC18212E, 0xAD151F2E, 0xAE151F2F, 0xAF19222F, 
        0xB01C202D, 0xB11D202D, 0xB21D212E, 0xB31A212B, 0xB41B222C, 0xB518222C, 0xB815232B, 0xB819232E, 0xBB1A1E30, 0xBB1A1E2D, 0xBD1B1B2A, 0xBF171B2B, 0xC1181C29, 0xC3191D26, 0xC4192226, 0xC61A1F2C, 0xC81B202E, 0xCB181D2C, 0xCD191E28, 0xCF1A1F2F, 
        0xD116212C, 0xD317222E, 0xD51E2A30, 0xD72C3946, 0xDA3E4459, 0xDC505765, 0xDE6C7383, 0xE07B8393, 0xE2838C95, 0xE5899C9C, 0xE78A9494, 0xE99696A2, 0xEB8C9999, 0xED8D9B9B, 0xEF8F8F9F, 0xF1919191, 0xF3949494, 0xF5999999, 0xF77F9F9F, 0xF77F9F9F,
  0xF6A9A9A9, 0xF4A2A2A2, 0xF2B0B0B0, 0xF0AAAAAA, 0xEEA5A5B4, 0xECA1A1AE, 0xEAA9A9B6, 0xE79FA9A9, 0xE5A6A6B0, 0xE39AA3AC, 0xE1889099, 0xDE6C7B83, 0xDC48575E, 0xDA444452, 0xD7323946, 0xD6252B37, 0xD322282E, 0xD01B2025, 0xCE1A1F24, 0xCC141E23, 0xCA131C26, 
        0xC8121720, 0xC50D1523, 0xC40C1522, 0xC10C1424, 0xBF171F2F, 0xBD172232, 0xBC132231, 0xBA16212F, 0xB81C202E, 0xB61B1F2D, 0xB5181B2C, 0xB31E2435, 0xB2172131, 0xB0162030, 0xAF131F2F, 0xAD182234, 0xAD181F2E, 0xAB121B27, 0xAB121B27, 0xAA151E2A, 
        0xA9141D29, 0xA8141D26, 0xA7141C25, 0xA7171C28, 0xA6161C2A, 0xA5131C27, 0xA6111C28, 0xA5101F27, 0xA5131F27, 0xA51C212A, 0xA51F1F27, 0xA51F1F24, 0xA5191C24, 0xA6191C25, 0xA6191F2A, 0xA71A1F2E, 0xA7141F2E, 0xA8111D2B, 0xA911202F, 0xAA1B2133, 
        0xAB1B1E2D, 0xAC1B1E2E, 0xAD1B1F2E, 0xAF191F2C, 0xAF161F2C, 0xB1131D27, 0xB2102124, 0xB4171E2C, 0xB5181B30, 0xB815192B, 0xB9151928, 0xBB161A29, 0xBC161E26, 0xBE171F23, 0xC1182024, 0xC21D2129, 0xC41E1E2F, 0xC71B1F2D, 0xC91C212A, 0xCB181D27, 
        0xCE141F24, 0xCF151F25, 0xD11B262C, 0xD4293541, 0xD732394C, 0xD943495D, 0xDB5C6371, 0xDD69787F, 0xDF7F878F, 0xE2839595, 0xE4849797, 0xE68E9999, 0xE890909B, 0xEB8C9999, 0xED8D9B9B, 0xEF8F9F9F, 0xF19191A3, 0xF3949494, 0xF5999999, 0xF5999999,
  0xF4B9B9B9, 0xF2B0B0B0, 0xF0AAAAAA, 0xEEB4B4B4, 0xECAEAEAE, 0xE9ADA2AD, 0xE7A9A9B4, 0xE5A6A6B0, 0xE3A3A3AC, 0xE09CA4AC, 0xDD7F878E, 0xDC505E6D, 0xD93C4350, 0xD62B2B37, 0xD423292F, 0xD21C212D, 0xCF1F252F, 0xCD191E23, 0xCB181D27, 0xC8121725, 0xC6161A28, 
        0xC4111922, 0xC1101824, 0xBF0F1727, 0xBD0B1726, 0xBC131E2D, 0xBA162133, 0xB7111F31, 0xB5182233, 0xB41B1E2F, 0xB21A1D31, 0xB0192030, 0xAE192232, 0xAD182231, 0xAB182433, 0xAA0F1E2D, 0xA914202F, 0xA8171D2E, 0xA6161F2D, 0xA6141C2A, 0xA4131E2A, 
        0xA316212C, 0xA3162129, 0xA2152029, 0xA218202B, 0xA118202E, 0xA015202A, 0xA015222D, 0xA115232B, 0xA0182228, 0xA01D2228, 0xA0202025, 0xA0202025, 0xA01D1D25, 0xA11D2028, 0xA11B202B, 0xA218202B, 0xA2131E2B, 0xA30D1B29, 0xA410212F, 0xA5192135, 
        0xA71A1A2E, 0xA7171A2B, 0xA91A1D2C, 0xAA181E2D, 0xAB151E2A, 0xAC121B24, 0xAE0F1C22, 0xAF131C29, 0xB217172E, 0xB314172B, 0xB5141829, 0xB6181B29, 0xB8191C27, 0xBA161D24, 0xBC1A2226, 0xBF1B1F27, 0xC01C202C, 0xC21D212D, 0xC51A1E2B, 0xC7161B28, 
        0xC9122125, 0xCC141E23, 0xCE1A2424, 0xD020303B, 0xD328343F, 0xD6373E50, 0xD746525F, 0xDA596775, 0xDC65747B, 0xDF77878F, 0xE1889999, 0xE3919A9A, 0xE68E9999, 0xE8909B9B, 0xEA91919D, 0xED8D9B9B, 0xEF8F9F9F, 0xF191A3A3, 0xF3949494, 0xF3949494,
  0xF2B0B0B0, 0xF0AAAAAA, 0xEEB4B4B4, 0xECAEAEAE, 0xE9ADADAD, 0xE6A3A3AD, 0xE4A9A9A9, 0xE2A7A7AF, 0xDF8F9797, 0xDD787F7F, 0xDA445960, 0xD8202D3A, 0xD5242A36, 0xD3222834, 0xD0252536, 0xCE1A1F29, 0xCB181D27, 0xC9172125, 0xC7161B28, 0xC4111526, 0xC2141925, 
        0xC0141824, 0xBD131722, 0xBB121A25, 0xB9121924, 0xB7151F2E, 0xB51B2533, 0xB31A2432, 0xB21D2434, 0xAF1C1F32, 0xAD1B1F31, 0xAB1E2436, 0xAA1B2136, 0xA81A2334, 0xA71A2536, 0xA5131F32, 0xA4131E2C, 0xA2182029, 0xA21B262B, 0xA018222A, 0x9F151F27, 
        0x9E1A2229, 0x9E1A242C, 0x9D172129, 0x9C1C212E, 0x9C1C2133, 0x9B1C2130, 0x9C1C2333, 0x9B1C2333, 0x9B1C2330, 0x9B1C232D, 0x9B1E212B, 0x9B1E1E2D, 0x9B1C1C30, 0x9C1C1C30, 0x9C191C30, 0x9D141C2E, 0x9E121A2C, 0x9E0F1C2C, 0x9F15222F, 0xA01A2235, 
        0xA11B1B2E, 0xA21B1B2E, 0xA41C1E2F, 0xA4191C2A, 0xA6141C28, 0xA8111A23, 0xA90E1A20, 0xAB151B27, 0xAC1B1B2E, 0xAE19192B, 0xB0161929, 0xB2171D2B, 0xB4171B28, 0xB6141B26, 0xB8152027, 0xBB1A1E2D, 0xBC1E1E31, 0xBE1F1F2F, 0xC1181C2D, 0xC3191D2A, 
        0xC5151A27, 0xC8171B25, 0xCA182126, 0xCD1E2333, 0xCF1F253A, 0xD2323849, 0xD4414D5E, 0xD6505D69, 0xD957646B, 0xDB6A787F, 0xDE839292, 0xE08B9393, 0xE3919A9A, 0xE589939C, 0xE8909B9B, 0xEA919D9D, 0xED8D9B9B, 0xEF8F9F9F, 0xF1919191, 0xF1919191,
  0xF0BBBBBB, 0xEEB4B4B4, 0xEBB2B2B2, 0xE9B9B9B9, 0xE6ADADAD, 0xE4B3A9A9, 0xE1AAAAAA, 0xDF97979F, 0xDC5E5E65, 0xDA223037, 0xD7192632, 0xD51E2A36, 0xD2212738, 0xCF25253A, 0xCD232333, 0xCB181D27, 0xC8121B25, 0xC6111A23, 0xC3111926, 0xC00C1828, 0xBE0F1727, 
        0xBC131626, 0xB9121524, 0xB7151C26, 0xB5181B29, 0xB21A242E, 0xB01C2933, 0xAF1C2932, 0xAC212A3A, 0xAA212439, 0xA9202338, 0xA7222539, 0xA51F2138, 0xA41C2138, 0xA21B2336, 0xA0182035, 0x9F171F2D, 0x9E1C272C, 0x9C1E2930, 0x9C1C262E, 0x9A1B252D, 
        0x991E252F, 0x991B252F, 0x981D2531, 0x97222738, 0x9724243A, 0x9624243A, 0x9724273A, 0x96212637, 0x96212637, 0x961F2635, 0x961D2632, 0x961D2135, 0x961F1D3A, 0x961A1D37, 0x97161A35, 0x97161D33, 0x98131B31, 0x99141E32, 0x9A162334, 0x9B192133, 
        0x9C191930, 0x9D1C1C34, 0x9F1F1F32, 0xA0181A28, 0xA1181B25, 0xA3161824, 0xA4161921, 0xA6191C28, 0xA81A1D2E, 0xA91A1A2C, 0xAC181B2A, 0xAD181B2E, 0xAF191F2C, 0xB2131D2B, 0xB4141E2C, 0xB6181B2D, 0xB91D1D2F, 0xBA1D1D2F, 0xBD1B1B2A, 0xBF1B1B2B, 
        0xC1141829, 0xC4151926, 0xC61A1A2C, 0xC91C1C2A, 0xCC232337, 0xCE2E2E3E, 0xD13C424D, 0xD345515C, 0xD6505D69, 0xD85B6F75, 0xDB717F86, 0xDE83929A, 0xE0939CA4, 0xE3919AA3, 0xE5939C9C, 0xE8909B9B, 0xEA919D9D, 0xEC93A1A1, 0xEF8F9F9F, 0xEF8F9F9F,
  0xEDB8B8B8, 0xEBB2BFB2, 0xE9B9B9B9, 0xE6B7B7B7, 0xE4B3B3B3, 0xE1B2B2B2, 0xDFAFAFAF, 0xDC919198, 0xD9575764, 0xD6313744, 0xD4293541, 0xD2212D3E, 0xCF1A1F35, 0xCC1E1E32, 0xCA1C212B, 0xC71B1F24, 0xC4152222, 0xC2101D21, 0xC00C1820, 0xBC0B1622, 0xBA0E1624, 
        0xB7111526, 0xB5141829, 0xB3171E2E, 0xB01C2333, 0xAE1F2838, 0xAC1B2A37, 0xAA1E2D39, 0xA8262E40, 0xA622253E, 0xA421213A, 0xA220233C, 0xA11D233B, 0x9F1D253C, 0x9D1A213B, 0x9B141E38, 0x9A192037, 0x9920253C, 0x9820253B, 0x961D243A, 0x961F263C, 
        0x951C2439, 0x93192138, 0x9321253D, 0x92272C41, 0x9129293C, 0x9127293C, 0x91272B3C, 0x91242B39, 0x90242D39, 0x90222B39, 0x91202B37, 0x91222939, 0x91222439, 0x911B1E32, 0x92171E33, 0x92172033, 0x93151E33, 0x94172136, 0x95182437, 0x96181F35, 
        0x981D1D33, 0x98202033, 0x991E1E2F, 0x9B191C2B, 0x9C171C29, 0x9E171C27, 0x9F1A1F27, 0xA11B202B, 0xA31B1E2F, 0xA51C1F30, 0xA71C1F2E, 0xA91D2332, 0xAB1B2133, 0xAD181F2E, 0xB0131C2D, 0xB1131A2D, 0xB41B1B2F, 0xB61B1F30, 0xB919192B, 0xBB161A29, 
        0xBE171727, 0xC0141824, 0xC3151926, 0xC51A1E2B, 0xC8252532, 0xCA262639, 0xCD2D3342, 0xD030414B, 0xD345515C, 0xD5485B61, 0xD85B686F, 0xDA758289, 0xDD8E969D, 0xE08B939C, 0xE28C9E9E, 0xE5939C9C, 0xE78A949F, 0xEA919D9D, 0xEC93A1A1, 0xEC93A1A1,
  0xEBBFBFB2, 0xE9B9B9B9, 0xE6B7B7B7, 0xE3B6B6B6, 0xE1BBBBB2, 0xDEB1A9B1, 0xDBA9A9A9, 0xD97F7F8C, 0xD6444456, 0xD32E3445, 0xD0253041, 0xCE1F293E, 0xCB182231, 0xC81B2029, 0xC6161F23, 0xC3151D22, 0xC0182020, 0xBE131F23, 0xBC0F1A22, 0xB80E1923, 0xB6111829, 
        0xB411172C, 0xB1161D30, 0xAE1C2538, 0xAC212A40, 0xAA243045, 0xA71F2E3F, 0xA61C2A3E, 0xA3242C45, 0xA1232546, 0x9F222742, 0x9D212946, 0x9C212945, 0x9A232A46, 0x98202945, 0x971D2742, 0x951F2843, 0x94232A47, 0x92202745, 0x91202745, 0x90242B46, 
        0x90242B46, 0x8E212843, 0x8E242A45, 0x8D2C3147, 0x8D2C2E40, 0x8C292E40, 0x8C292E3D, 0x8C272E3D, 0x8B29323F, 0x8B27323D, 0x8B23303B, 0x8C232C39, 0x8C252939, 0x8C232737, 0x8D1F2535, 0x8E1D2436, 0x8E1D263A, 0x8F1F283D, 0x901B263B, 0x911B2239, 
        0x9222223C, 0x9323253D, 0x94232339, 0x96212437, 0x98202231, 0x991E232F, 0x9B1C212D, 0x9C1E2333, 0x9E1F2234, 0xA0202235, 0xA2202339, 0xA4212738, 0xA61C2539, 0xA91A2335, 0xAB151E33, 0xAD181B31, 0xAF1C1C32, 0xB21A1D31, 0xB5181B2C, 0xB715182A, 
        0xBA121624, 0xBC0F1622, 0xBF131723, 0xC1181829, 0xC41E1E2B, 0xC71F1F2D, 0xCA1C2634, 0xCD232D38, 0xCF252F3A, 0xD22D3E49, 0xD4586A6A, 0xD87C898F, 0xDA90979E, 0xDD8E969D, 0xDF8F9797, 0xE28C9E9E, 0xE5899C9C, 0xE78A949F, 0xEA919D9D, 0xEA919D9D,
  0xE9C5C5B9, 0xE6B7B7B7, 0xE4BCBCB3, 0xE1BBBBBB, 0xDEB9B1B9, 0xDBB1B1B8, 0xD8A3A3A9, 0xD5676779, 0xD339394B, 0xD0252B41, 0xCD1E233D, 0xCA182134, 0xC7161F2D, 0xC51A1E27, 0xC2141921, 0xBF131B1B, 0xBC0F1A1A, 0xBA0E191D, 0xB7111C26, 0xB40D1B28, 0xB2101A2E, 
        0xAF131C32, 0xAD18253A, 0xAA212D45, 0xA8263149, 0xA625304A, 0xA324314A, 0xA1202E49, 0x9F222A4A, 0x9D272C4B, 0x9B262B4C, 0x99282F50, 0x97293150, 0x9626304F, 0x93232C4D, 0x92222E4F, 0x91293250, 0x8F2B314D, 0x8D2A2E4B, 0x8C272E4B, 0x8B2B324C, 
        0x8B2D364E, 0x892D364B, 0x882C354A, 0x8833374A, 0x87323548, 0x872E3548, 0x872E3545, 0x862E3443, 0x862E3845, 0x862C3643, 0x87283541, 0x862A323F, 0x872C303F, 0x872C323F, 0x87282E3D, 0x8820283B, 0x89222B3E, 0x8A222B41, 0x8B202941, 0x8C212742, 
        0x8D2C2C49, 0x8E2F314C, 0x8F2D2F46, 0x91272E40, 0x9225293C, 0x94212836, 0x961F2632, 0x98222536, 0x9A202539, 0x9C21263B, 0x9E24273E, 0xA022283D, 0xA21E293C, 0xA4192438, 0xA7171F36, 0xA91A2338, 0xAB1B2136, 0xAE191C32, 0xB016192D, 0xB3141A28, 
        0xB6111826, 0xB90E1520, 0xBB0F1621, 0xBE171B23, 0xC11C2029, 0xC31D222A, 0xC61F2331, 0xC9212A2F, 0xCC1E2D32, 0xCF1F2F3A, 0xD126373C, 0xD4415358, 0xD77F858C, 0xDA90979E, 0xDD8E969D, 0xDF8F979F, 0xE28C9E9E, 0xE5939C9C, 0xE78A9F9F, 0xE78A9F9F,
  0xE6C1C1B7, 0xE3B6B6B6, 0xE1BBBBBB, 0xDEC1B9B9, 0xDBB8B8BF, 0xD9B5AEB5, 0xD695959B, 0xD351515C, 0xD02B2B3B, 0xCD232D3D, 0xCA1C2639, 0xC7121F36, 0xC4151E2F, 0xC1181C24, 0xBE131B1F, 0xBC131A1E, 0xB90E1920, 0xB60D1822, 0xB30D1724, 0xB110162A, 0xAE121C35, 
        0xAB1B243C, 0xA8232E49, 0xA6283350, 0xA3293453, 0xA1283354, 0x9E293756, 0x9C233354, 0x9A232D50, 0x982C2E56, 0x962B3059, 0x942D345A, 0x92303A5F, 0x9130395E, 0x8F28345A, 0x8D283559, 0x8B323B5B, 0x8A343C58, 0x89313A54, 0x87303952, 0x86323A51, 
        0x85363E53, 0x84354050, 0x84334050, 0x833B4156, 0x82393D53, 0x8235394F, 0x81343A4E, 0x81323A4C, 0x81323C4C, 0x812E3A4A, 0x812C3A4A, 0x81303A4A, 0x81363648, 0x8235394B, 0x82303549, 0x83262F43, 0x842B3348, 0x842B314A, 0x86273049, 0x87303752, 
        0x883B3E5C, 0x893E405C, 0x8B363853, 0x8C2E3248, 0x8E282F43, 0x8F242B3D, 0x9222293A, 0x93252A3F, 0x9524283E, 0x9724293F, 0x99252A41, 0x9B232B3F, 0x9D1F293E, 0xA01A253D, 0xA21B263C, 0xA4212740, 0xA71F223C, 0xAA1B1E36, 0xAC151B2E, 0xB0101626, 
        0xB20D1721, 0xB50D181E, 0xB70E181F, 0xBB121A21, 0xBD1B1E26, 0xC01C2028, 0xC31D222A, 0xC51A232B, 0xC817292E, 0xCB1D313A, 0xCE293943, 0xD1424D58, 0xD4707C82, 0xD78C989F, 0xDA89979E, 0xDD8E9D9D, 0xDF8F9797, 0xE28C9E9E, 0xE5939C9C, 0xE5939C9C,
  0xE4C6C6BC, 0xE1C3C3BB, 0xDEC1B9B9, 0xDBBFBFBF, 0xD8BDBDBD, 0xD5B0B0B0, 0xD276767C, 0xCF3F454A, 0xCC282832, 0xC91C2533, 0xC7121F2D, 0xC4111E2F, 0xC1141C2D, 0xBE171B27, 0xBB121621, 0xB8111923, 0xB5111822, 0xB2101724, 0xAF0C1629, 0xAC151B37, 0xA91D2641, 
        0xA725314E, 0xA42F3854, 0xA22E3957, 0x9F2A3757, 0x9C2B3559, 0x9A2A395F, 0x9729385F, 0x952D3760, 0x93363B65, 0x92373C66, 0x90394069, 0x8D3E476F, 0x8B3D486D, 0x8A38456C, 0x8837446B, 0x873D456C, 0x853C4266, 0x84373E61, 0x82373F5D, 0x8138405E, 
        0x803C445E, 0x7F39455D, 0x7E3F4A5E, 0x7E444C64, 0x7D404260, 0x7D383C58, 0x7C363C57, 0x7C364057, 0x7C343E55, 0x7C303E53, 0x7C364157, 0x7C3C4059, 0x7C3E3C57, 0x7D3E3E58, 0x7D3A3E58, 0x7E333952, 0x7E373F56, 0x7F353D57, 0x81363E58, 0x813E4660, 
        0x83434564, 0x84424663, 0x85363C57, 0x882F354F, 0x89262D45, 0x8A22293C, 0x8C252C40, 0x8E282D43, 0x90262B44, 0x93252A44, 0x94232A42, 0x96212941, 0x991E2A43, 0x9B1E2842, 0x9D212C46, 0xA0283048, 0xA3262945, 0xA51C213B, 0xA8141D2E, 0xAB0F1827, 
        0xAE0C191F, 0xB109161D, 0xB30D1A1E, 0xB6111B1F, 0xB9191D20, 0xBD1B2226, 0xBF1B2327, 0xC2192529, 0xC51E2B30, 0xC820323C, 0xCB2C3F49, 0xCE394853, 0xD15E6974, 0xD488949A, 0xD78C989F, 0xDA909E9E, 0xDD8E9D9D, 0xE08B9C9C, 0xE28C9E9E, 0xE28C9E9E,
  0xE1C3C3BB, 0xDEC1C1B9, 0xDBBFB8BF, 0xD9C2C2C2, 0xD5BCBCBC, 0xD2A4A4A4, 0xD05C5C5C, 0xCD333838, 0xC9252F2F, 0xC61A232C, 0xC311222A, 0xC010202C, 0xBD131B2A, 0xBA161624, 0xB7111523, 0xB4111425, 0xB1101623, 0xAE12192B, 0xAB181E39, 0xA8232646, 0xA52A3052, 
        0xA22E3957, 0xA0323D5B, 0x9D313B5D, 0x9A2D395F, 0x98313D65, 0x95323E67, 0x93313F6A, 0x9139426E, 0x8E3F456E, 0x8C3D466E, 0x8A414973, 0x88464F77, 0x86454F77, 0x85445179, 0x83455278, 0x81484E7B, 0x80484876, 0x7E414272, 0x7D444671, 0x7C454972, 
        0x7B474B6F, 0x7A464C6E, 0x7A4C5472, 0x78525672, 0x784B4D6D, 0x77454866, 0x77434764, 0x773F4763, 0x763B4460, 0x763B4660, 0x763D4860, 0x77414563, 0x77474363, 0x77474566, 0x78454563, 0x79424662, 0x79404660, 0x7A3F465F, 0x7B434B62, 0x7C414764, 
        0x7E3F4260, 0x7F393D5B, 0x81343A56, 0x82303753, 0x84272F48, 0x85253044, 0x872A3245, 0x89292F47, 0x8B292D48, 0x8D2A2E4B, 0x9029304B, 0x9229304A, 0x9428344C, 0x9727334B, 0x99283450, 0x9C2E3852, 0x9E2F3751, 0xA12B3049, 0xA41E273A, 0xA7111C2B, 
        0xAA0F1E24, 0xAC0C181E, 0xB009191C, 0xB2101A1D, 0xB5181E1E, 0xB9192020, 0xBC1A2226, 0xBE1B272F, 0xC21D2D32, 0xC51E3039, 0xC724363F, 0xCB313F49, 0xCF454F5A, 0xD1697479, 0xD4888E94, 0xD78C989F, 0xDA90979E, 0xDD8E9D9D, 0xE0939C9C, 0xE0939C9C,
  0xDEC1B9B9, 0xDCC4C4BD, 0xD8BDB6B6, 0xD5BCBCBC, 0xD3B3B3B3, 0xCF8A8A8F, 0xCC373741, 0xC92A2F38, 0xC6232C3A, 0xC31D2637, 0xC0182030, 0xBC161E2D, 0xBA16192C, 0xB6181826, 0xB3171721, 0xB0161923, 0xAD121B25, 0xAA1B2430, 0xA7252B42, 0xA42C3551, 0xA234395A, 
        0x9E34395B, 0x9C333B5F, 0x99373E64, 0x96374168, 0x9439456D, 0x91394771, 0x8E3A4872, 0x8C3D4875, 0x8A3E4975, 0x88404875, 0x86454B79, 0x8448507E, 0x82495380, 0x804A5884, 0x7E465883, 0x7C4B5785, 0x7B515285, 0x794C4F7F, 0x78505481, 0x77525681, 
        0x764E517E, 0x754F527D, 0x74575B83, 0x735B5E84, 0x7258587F, 0x7254587E, 0x724F5478, 0x71494E72, 0x71454C6E, 0x71424B6D, 0x71424B6D, 0x7244496F, 0x72484871, 0x724D4D73, 0x734A4E70, 0x74474C6D, 0x74434968, 0x75454D6A, 0x7648516B, 0x78414969, 
        0x793A4266, 0x7A373D61, 0x7C343A5D, 0x7E33395A, 0x7F2D3353, 0x81303652, 0x82303551, 0x842D3350, 0x862E3454, 0x892F3656, 0x8B303657, 0x8D313959, 0x8F2F3B5A, 0x922C3A58, 0x95303C5B, 0x97353D5D, 0x9A37395D, 0x9D343B58, 0xA028324B, 0xA21B293C, 
        0xA6111F2A, 0xA80B1A23, 0xAC0F1B1E, 0xAF13191C, 0xB21A1D21, 0xB5181B22, 0xB8192027, 0xBB1A2529, 0xBE1F272F, 0xC1202D35, 0xC4262F3C, 0xC82E3745, 0xCB353F4E, 0xCE4E5862, 0xD179848A, 0xD4949AA0, 0xD78C9898, 0xDA90979E, 0xDD8E9D9D, 0xDD8E9D9D,
  0xDCC4BDBD, 0xD9C2BBBB, 0xD6C0BABA, 0xD2BABABA, 0xCFBFB9BF, 0xCC6E7373, 0xC9333342, 0xC6282C3E, 0xC3222A3F, 0xBF1B233B, 0xBC1A1E35, 0xB919202F, 0xB61B1B2D, 0xB3211E2B, 0xB01C1C23, 0xAD181F1F, 0xAA182424, 0xA6223036, 0xA32F3A4D, 0xA0303A55, 0x9D393E60, 
        0x9A3F3F67, 0x973F4269, 0x9440456D, 0x923E456D, 0x8F38446C, 0x8C3D4B72, 0x8A415079, 0x8842517C, 0x85424F7F, 0x83454D7F, 0x814A5083, 0x7F4D5185, 0x7D4A5687, 0x7B475689, 0x7942578A, 0x774A598A, 0x76575D8B, 0x75565A8A, 0x73595E8C, 0x72585D8A, 
        0x71525786, 0x70555A89, 0x6F5C5F8D, 0x6E5E628F, 0x6D5F618C, 0x6D5D618B, 0x6C595D86, 0x6C545883, 0x6C515880, 0x6C48517A, 0x6C48537A, 0x6C4C537C, 0x6D505380, 0x6D555A84, 0x6E555B83, 0x6F4F567D, 0x6F4D547A, 0x704A5577, 0x71475272, 0x73434A70, 
        0x74414973, 0x753E4770, 0x76373F68, 0x79373C64, 0x7A3B4065, 0x7C404166, 0x7E3F3F64, 0x803A3E64, 0x82393F66, 0x84394067, 0x86383F66, 0x893A4269, 0x8B384369, 0x8D354268, 0x9036446B, 0x933D446C, 0x963C3E6A, 0x98383D62, 0x9C2E3B59, 0x9E24344B, 
        0xA1152536, 0xA40E1C27, 0xA8141D23, 0xAB151B21, 0xAE191922, 0xB11A1A23, 0xB51B1E25, 0xB71C1F2E, 0xBB212530, 0xBE232736, 0xC1292D39, 0xC52B3041, 0xC8373C4A, 0xCB4E5362, 0xCE6D727C, 0xD18A959B, 0xD48E9A9A, 0xD792989F, 0xDB949B9B, 0xDB949B9B,
  0xDAC7C0C0, 0xD7C5BFBF, 0xD3BFB9B9, 0xD0BDB8BD, 0xCD89898E, 0xC92A2F38, 0xC6282C3A, 0xC32A3344, 0xC020283C, 0xBC1E2639, 0xB9192032, 0xB61B1F30, 0xB21D1D2E, 0xAF1F1929, 0xAC181B24, 0xA81A2020, 0xA51F272D, 0xA22B3644, 0x9F353F54, 0x9C353D5C, 0x99394166, 
        0x963E436A, 0x9344466E, 0x90424970, 0x8D404B71, 0x8A434E75, 0x88424F77, 0x8544557B, 0x83455481, 0x81485485, 0x7E4C5487, 0x7C4D5587, 0x7A505489, 0x784B5289, 0x7648558B, 0x7445568B, 0x72495288, 0x71555789, 0x70575A8C, 0x6E57598C, 0x6D585C8C, 
        0x6B575B8D, 0x6A5C5E8F, 0x6A5E5F91, 0x69606293, 0x68666693, 0x68636492, 0x68616492, 0x67606591, 0x685C638D, 0x67535D87, 0x67515B83, 0x67535A87, 0x68555A89, 0x685A5F8D, 0x695D648E, 0x6A5E648C, 0x6A5A6388, 0x6B575E84, 0x6C515B7E, 0x6D50587F, 
        0x6F4D547F, 0x70485079, 0x72464D76, 0x73484E76, 0x754D5277, 0x77505479, 0x79515579, 0x7B4B4F77, 0x7D484C77, 0x7F494D79, 0x82474D78, 0x84444C75, 0x86434D77, 0x89404B76, 0x8C404B75, 0x8E414875, 0x91424271, 0x943D426D, 0x97353F64, 0x9A2D3C58, 
        0x9D212E43, 0xA1121D30, 0xA4101927, 0xA7141722, 0xAA151824, 0xAD151822, 0xB0161C26, 0xB41B222C, 0xB71F232E, 0xBA1D242F, 0xBE232B36, 0xC12D3541, 0xC4333345, 0xC8404553, 0xCB626675, 0xCE8C969C, 0xD1909B9B, 0xD48E9A9A, 0xD88F9C9C, 0xD88F9C9C,
  0xD7BFBFB8, 0xD4C3C3C3, 0xD0BDBDBD, 0xCD9E9EA3, 0xCA303039, 0xC7282836, 0xC32A2E3F, 0xBF232B3B, 0xBC1E2939, 0xB91D2436, 0xB6182230, 0xB21D2131, 0xAF1C1C2C, 0xAB1E1B2A, 0xA8171A26, 0xA51C212D, 0xA128303B, 0x9E313C4E, 0x9B333F59, 0x98333D60, 0x953C4369, 
        0x923E436B, 0x8F41486F, 0x8C424870, 0x89454F76, 0x86475479, 0x8343527B, 0x8144527D, 0x7F475583, 0x7C495389, 0x7951598C, 0x774E568A, 0x764F558D, 0x744B528B, 0x714B548D, 0x6F4D5A92, 0x6E50578F, 0x6C585B8F, 0x6A575A8F, 0x69565A8E, 0x68595C90, 
        0x66565B90, 0x66595C92, 0x655E6194, 0x645F6093, 0x63616194, 0x63606194, 0x63606395, 0x62646798, 0x625D6495, 0x62575F8E, 0x6257618E, 0x625A6291, 0x625D6193, 0x63606595, 0x63636895, 0x64626893, 0x65616791, 0x66616A8E, 0x6760698D, 0x685E688D, 
        0x6A58618A, 0x6B565E86, 0x6D5A6189, 0x6E596088, 0x705E658A, 0x725F648A, 0x745D6489, 0x765B5E87, 0x78545685, 0x7B515483, 0x7D505683, 0x7F4F5783, 0x824B5582, 0x85475381, 0x87414C7D, 0x8A45497B, 0x8D454576, 0x903D4272, 0x9338426C, 0x96353E63, 
        0x992D3957, 0x9D1F2741, 0xA0121830, 0xA3101626, 0xA7111422, 0xAA121824, 0xAD151825, 0xB0161C29, 0xB4172228, 0xB718232A, 0xBA1D242C, 0xBE272F3A, 0xC1292D3D, 0xC5343D4A, 0xC8535761, 0xCB899397, 0xCF8F999F, 0xD293989E, 0xD5919D9D, 0xD5919D9D,
  0xD4BDB7B7, 0xD1C1BCC1, 0xCDBCBCBC, 0xCA909095, 0xC73F3F4D, 0xC4333340, 0xC0303040, 0xBC1E2935, 0xB9202B3A, 0xB6182630, 0xB21A242E, 0xAE19222F, 0xAB1E1E2D, 0xA81D1A2B, 0xA4191C2A, 0xA1252838, 0x9E313749, 0x9A343C55, 0x97353F5F, 0x94394268, 0x913E476E, 
        0x8E3F456E, 0x8A3C456E, 0x87434C74, 0x84465278, 0x8247537C, 0x7F45517B, 0x7C475380, 0x794C5786, 0x784E588D, 0x75525C8F, 0x724F588E, 0x714E578F, 0x6E4D548C, 0x6C515891, 0x6A555A94, 0x69555B93, 0x675A5F94, 0x66575C93, 0x64585B91, 0x63585C94, 
        0x62595D93, 0x605B6094, 0x605E6398, 0x5F5F6298, 0x5E5E6196, 0x5E5D5E94, 0x5D5F6498, 0x5D646A9B, 0x5D5F6798, 0x5D596293, 0x5D596493, 0x5D5E6696, 0x5E5D6397, 0x5E5E6597, 0x5E606897, 0x5F626A97, 0x60646C98, 0x61636F97, 0x63616D94, 0x64606A93, 
        0x655E6791, 0x66606690, 0x68636992, 0x6A616891, 0x6B606890, 0x6D5F6890, 0x6F5C668F, 0x715D628F, 0x745B5D8E, 0x76555989, 0x78565C8B, 0x7B585E8C, 0x7E525A8B, 0x804E5888, 0x83495485, 0x864B4F84, 0x89494B7F, 0x8C424677, 0x8F3B4671, 0x9237436B, 
        0x95394367, 0x992A3255, 0x9C17193B, 0x9F12152D, 0xA3131624, 0xA6111422, 0xAA121824, 0xAD151B25, 0xB0131C23, 0xB4172228, 0xB718262A, 0xBB212934, 0xBE272B3A, 0xC22D3642, 0xC527303D, 0xC84A535C, 0xCC7D8787, 0xCF8F999F, 0xD3909C9C, 0xD3909C9C,
  0xD1BCBCBC, 0xCEC0C0C0, 0xCBC4C4C4, 0xC79A9A9F, 0xC43C3C49, 0xC1313141, 0xBD2A2E39, 0xB9202B36, 0xB61B2630, 0xB217242B, 0xAE152228, 0xAB18212A, 0xA71A1C2B, 0xA41C1C2A, 0xA01D1D2D, 0x9D292E3E, 0x9A343953, 0x96323C59, 0x93384265, 0x903D4670, 0x8C404B75, 
        0x893E4B72, 0x86414B73, 0x83475278, 0x804A547E, 0x7D48527D, 0x7A46527E, 0x784B5881, 0x764E5987, 0x73505B8D, 0x704E598E, 0x6E4D598D, 0x6C4F5B91, 0x6A505A91, 0x67555B92, 0x66595C95, 0x645B5F96, 0x625D6296, 0x615B6095, 0x5F5C5F95, 0x5E5E6197, 
        0x5C62659A, 0x5C65689C, 0x5B63679B, 0x5A62679B, 0x5961669A, 0x5960669A, 0x58646A9C, 0x58646D9E, 0x58616B9C, 0x585C6798, 0x585B6796, 0x595D6899, 0x595B6399, 0x595B6397, 0x595E6899, 0x5A616A98, 0x5B636E99, 0x5C626E97, 0x5D5F6C95, 0x5E606B92, 
        0x60606993, 0x615E6792, 0x635E6894, 0x65636B96, 0x675F6994, 0x685E6993, 0x6B5C6793, 0x6D5A6192, 0x6F5F6192, 0x715D6090, 0x74595F90, 0x765B6291, 0x79576090, 0x7C515B8B, 0x7F4F598B, 0x824F5588, 0x854D4F83, 0x88424879, 0x8B3D4876, 0x8E3A4872, 
        0x913C456C, 0x95343C60, 0x981D2247, 0x9B141630, 0x9F151727, 0xA2101323, 0xA6141925, 0xA9141D26, 0xAD121F25, 0xB1132027, 0xB417252C, 0xB8202B32, 0xBB292D38, 0xBF2F3743, 0xC2363E4B, 0xC53D4A4F, 0xC959676C, 0xCC919B9B, 0xD0929D9D, 0xD0929D9D,
  0xCFBFBFB9, 0xCCBEBEBE, 0xC8BDC2C2, 0xC56D7276, 0xC1353541, 0xBD322E41, 0xBA282837, 0xB61F2630, 0xB217272B, 0xAF162226, 0xAB122124, 0xA7171F28, 0xA41C1E2A, 0xA0202030, 0x9D242739, 0x992F344B, 0x96353C59, 0x92353C61, 0x8F3D446C, 0x8C404B75, 0x88404D75, 
        0x853E4D75, 0x8245517A, 0x7F49557D, 0x7C47537E, 0x794A5781, 0x764A5782, 0x734E5986, 0x70505A89, 0x6E505B8A, 0x6B4D5B8B, 0x694E5D8D, 0x67536091, 0x65545F92, 0x63585C92, 0x61606295, 0x5F606497, 0x5E5D6396, 0x5C5C6094, 0x5A5C6495, 0x595E6497, 
        0x585F6798, 0x56606799, 0x56606497, 0x555D6497, 0x545D659A, 0x545F669A, 0x535E6799, 0x5360699B, 0x53616D9C, 0x53606D9B, 0x535A6A98, 0x535B6998, 0x535A6698, 0x545A6697, 0x545D6999, 0x56606D99, 0x56606D97, 0x57606F97, 0x585F6E96, 0x595E6B94, 
        0x5B616994, 0x5C5F6895, 0x5E5D6694, 0x605E6996, 0x625D6796, 0x645B6898, 0x665B6697, 0x685C6695, 0x6A616694, 0x6D5F6693, 0x6F5D6692, 0x725B6693, 0x755A6391, 0x7756618E, 0x7A525D8B, 0x7D525889, 0x804E5284, 0x83434978, 0x873D4874, 0x8A3C4973, 
        0x8D39456D, 0x91394065, 0x942A2F53, 0x98181D38, 0x9B141628, 0x9F0F1525, 0xA2131B29, 0xA6141F28, 0xA9112026, 0xAD122225, 0xB0162626, 0xB41E282F, 0xB8272E39, 0xBB383C47, 0xBF4F5763, 0xC3727F83, 0xC6818A93, 0xCA90999E, 0xCE919CA1, 0xCE919CA1,
  0xCCBEBEB9, 0xC9BCC1BC, 0xC5AFB3AF, 0xC13D4141, 0xBE32363E, 0xBA2C2C3E, 0xB6222634, 0xB31E282E, 0xAF192929, 0xAB18272A, 0xA81A292B, 0xA41C242F, 0xA01D202D, 0x9D242734, 0x992A2D3E, 0x9630354D, 0x92373C5D, 0x8E3A4169, 0x8B414871, 0x88424A77, 0x853E4B77, 
        0x813C4C75, 0x7E41507A, 0x7B47547F, 0x7845527D, 0x75495680, 0x724D5883, 0x6F4F5A86, 0x6C515B88, 0x6A505E8A, 0x674B5B88, 0x654D5F8D, 0x62546493, 0x60546091, 0x5E5A6091, 0x5C626395, 0x5B616496, 0x595D6495, 0x575C6595, 0x555E6697, 0x545D6596, 
        0x535E6696, 0x52616898, 0x515E6797, 0x505E6698, 0x505F689B, 0x4F60699B, 0x4F5F699A, 0x4E5F6C9B, 0x4E606E9C, 0x4E5F709B, 0x4E5C6D9A, 0x4E5C6A9A, 0x4E5A6798, 0x4F596797, 0x505C6B98, 0x505F6E98, 0x525E6E97, 0x52617197, 0x53637398, 0x55616D96, 
        0x56616A96, 0x585C6593, 0x595D6694, 0x5B5E6997, 0x5D5B6798, 0x5F596598, 0x615A679A, 0x635E6897, 0x66636A95, 0x68616893, 0x6B5E6892, 0x6D5C6892, 0x70596590, 0x7357628F, 0x76515E8B, 0x79515B86, 0x7C515785, 0x7F49517F, 0x833F4B76, 0x863C4B73, 
        0x893C476E, 0x8D394268, 0x9032395B, 0x94262845, 0x9816182C, 0x9B0C1423, 0x9F121A27, 0xA2101B23, 0xA6111F25, 0xAA122124, 0xAD152828, 0xB1202D30, 0xB5293037, 0xB92F363D, 0xBC444C53, 0xC0717981, 0xC38C949D, 0xC7919A9F, 0xCA9099A3, 0xCA9099A3,
  0xCABBBBB6, 0xC6C0C4BB, 0xC2ABAFAB, 0xBF535B5B, 0xBB34383F, 0xB72A2E3F, 0xB31E2432, 0xB01C2630, 0xAC1E2A31, 0xA81D2B31, 0xA41E2C35, 0xA11D2833, 0x9D1C2434, 0x99252A3C, 0x96292D43, 0x92303551, 0x8E383F60, 0x8B41466D, 0x87414A74, 0x84404A75, 0x803E4A76, 
        0x7D404E77, 0x7A42527A, 0x7745547F, 0x7346537F, 0x70485581, 0x6D4A5784, 0x6A4C5887, 0x68525A89, 0x65545A8A, 0x62515A8B, 0x6053608E, 0x5E566392, 0x5C586392, 0x595A6391, 0x575C6392, 0x56606694, 0x54626997, 0x52626998, 0x51606797, 0x4F5A6395, 
        0x4E5C6498, 0x4D5F689B, 0x4C5D679C, 0x4B61669B, 0x4A62669A, 0x4A606798, 0x4A626B9A, 0x4964719B, 0x4963729C, 0x4960729C, 0x495C6E9B, 0x495C6D9B, 0x4A5B699A, 0x4A596998, 0x4B5B6B99, 0x4B5D6D99, 0x4C5C6D99, 0x4D5F6F99, 0x4E61719B, 0x50626E9B, 
        0x5262689B, 0x535D6499, 0x5560679A, 0x57606B9B, 0x585B6798, 0x5A596798, 0x5D596998, 0x5F5D6897, 0x61636895, 0x64676C98, 0x66616893, 0x695D6492, 0x6C5D6693, 0x6F5C6491, 0x72565F8C, 0x75565D8B, 0x78545E8B, 0x7B4D5885, 0x7F43537D, 0x823D4D76, 
        0x853E4D72, 0x893A476C, 0x8C373B63, 0x902B2D50, 0x941C1A36, 0x970E1129, 0x9B111628, 0x9F121A25, 0xA2131B26, 0xA6141F25, 0xAA1B242D, 0xAE222B35, 0xB2272E3B, 0xB52C373D, 0xB93D4550, 0xBD6F777F, 0xC1878F93, 0xC48E9B9F, 0xC88F989D, 0xC88F989D,
  0xC7BFBFBA, 0xC4BEBEB9, 0xC0B5B5B1, 0xBC5B5F5F, 0xB8272B35, 0xB42C2C3D, 0xB0262939, 0xAD222837, 0xA9202C38, 0xA5212D3B, 0xA11B2536, 0x9E1A2737, 0x9A1E2839, 0x96242941, 0x92272E48, 0x8E313855, 0x8B3D4364, 0x87434A70, 0x83414970, 0x803E4674, 0x7C3E4976, 
        0x79424D77, 0x7646537C, 0x7246527F, 0x6F485481, 0x6C485681, 0x69495886, 0x67495A88, 0x63535B8C, 0x615A588D, 0x5E585A8E, 0x5C585D8F, 0x595A6391, 0x575F6995, 0x565D6A96, 0x535A6A95, 0x515E6C96, 0x4F636C97, 0x4E646D9A, 0x4C616A99, 0x4B5E6699, 
        0x495F679C, 0x485F699F, 0x475D68A0, 0x4763679E, 0x4666689C, 0x45686C9A, 0x4568709C, 0x44667299, 0x4467749C, 0x4464749F, 0x4460709C, 0x455D6D9D, 0x455D6C9E, 0x455D6C9E, 0x465D6C9D, 0x475F6E9D, 0x485E6F9D, 0x495D6E9C, 0x4A62719E, 0x4B666FA2, 
        0x4D6669A3, 0x4E60669E, 0x505F669C, 0x525F689B, 0x545A6597, 0x565B6797, 0x58586793, 0x5B606997, 0x5D626796, 0x5F676A9A, 0x63656897, 0x655F6494, 0x68616693, 0x6B606793, 0x6E5C6391, 0x715B628F, 0x74545F8B, 0x774C5984, 0x7B43547F, 0x7E3F507A, 
        0x823D4D76, 0x853C4970, 0x89384067, 0x8C2E3058, 0x90242044, 0x94171534, 0x9816182C, 0x9B161928, 0x9F151A27, 0xA3161829, 0xA71C1F31, 0xAB212736, 0xAE282F3B, 0xB328323F, 0xB626343E, 0xBA425158, 0xBE6D797D, 0xC18B9898, 0xC590999E, 0xC590999E,
  0xC5C1C1BC, 0xC1BDBDB8, 0xBDB9B9B9, 0xB9484C4C, 0xB5252C33, 0xB12D3041, 0xAD2B3141, 0xAA27303F, 0xA6222D3C, 0xA21E2936, 0x9E1A2434, 0x9A1B2A37, 0x96212B3C, 0x92252C41, 0x8E2A2F4A, 0x8B323857, 0x873D4565, 0x8343496E, 0x80404670, 0x7C3E4774, 0x783F4B76, 
        0x75424F77, 0x7246527E, 0x6F485681, 0x6B495782, 0x68485783, 0x65465785, 0x62485A88, 0x60535B8C, 0x5C5C5C8F, 0x5A595C8F, 0x57595D8F, 0x555B6493, 0x525F6B95, 0x505C6B96, 0x4E5D6D97, 0x4C606D96, 0x4A626A95, 0x4A626B98, 0x475F6796, 0x4760689A, 
        0x45626A9D, 0x435F699D, 0x42616B9F, 0x42676CA0, 0x416B6B9E, 0x416B6F9E, 0x4067719B, 0x40636E97, 0x4066759B, 0x406977A0, 0x4063739E, 0x405F6E9C, 0x405E6B9E, 0x41606D9F, 0x41606F9E, 0x4261709F, 0x4361709D, 0x44606E9C, 0x4564719E, 0x47676FA1, 
        0x48666B9F, 0x4A63699E, 0x4B62699D, 0x4D626B9D, 0x4F5F679A, 0x515E699A, 0x545A6697, 0x56606999, 0x59646999, 0x5B646999, 0x5E616897, 0x615E6594, 0x635C6592, 0x675F6794, 0x6A5E6693, 0x6D5A618E, 0x7055608C, 0x734E5B88, 0x77475681, 0x7A40527C, 
        0x7E3F4E78, 0x813E4C71, 0x853A426A, 0x8936385F, 0x8C27274B, 0x901B1B39, 0x94171A2F, 0x98161B2C, 0x9C141C29, 0xA0181D2A, 0xA4191E2F, 0xA81D2331, 0xAB242D39, 0xB026303D, 0xB32E3846, 0xB7313F46, 0xBC4C5B5F, 0xC0818D91, 0xC3909DA1, 0xC3909DA1,
  0xC3C3C3BF, 0xBEC0C0BC, 0xBAADB1AD, 0xB6454549, 0xB22B2E38, 0xAE2F3541, 0xAA2D3342, 0xA62A333E, 0xA2232B3C, 0x9F1F2A3A, 0x9B212B3A, 0x97222E3D, 0x93232C3F, 0x8F2B2F44, 0x8B2D344C, 0x87373D5B, 0x833F4766, 0x80444A70, 0x7C414972, 0x783E4772, 0x75404B75, 
        0x71445077, 0x6E47547E, 0x6B485681, 0x67495883, 0x64465581, 0x61485885, 0x5E4B5D89, 0x5B525B8B, 0x585B5C90, 0x555A5E91, 0x535A6192, 0x50596492, 0x4E5C6995, 0x4D5B6B96, 0x4A5B6B95, 0x48616F98, 0x47666E9A, 0x44646E9B, 0x43616A98, 0x4160699A, 
        0x40626B9C, 0x3F636C9E, 0x3E6870A3, 0x3D6E71A5, 0x3D6E6FA2, 0x3C6D719F, 0x3B6D759E, 0x3B68739C, 0x3B68759D, 0x3B6A779F, 0x3B68739F, 0x3B6873A1, 0x3C656F9F, 0x3C626E9E, 0x3D66719F, 0x3D6873A1, 0x3E6975A1, 0x406975A0, 0x416975A0, 0x4268719F, 
        0x436A6E9F, 0x456A6EA0, 0x47686EA0, 0x49676EA1, 0x4B626B9D, 0x4D626B9E, 0x4F5D669B, 0x52626B9B, 0x55676D9C, 0x57636998, 0x5A616796, 0x5C626A97, 0x5F5D6592, 0x625C6491, 0x655E6692, 0x695A6290, 0x6C545F8D, 0x6F4F5D8A, 0x734A5984, 0x76445380, 
        0x7A42547C, 0x7E425078, 0x81404871, 0x85383C62, 0x892B2B4D, 0x8D1F213E, 0x911B2035, 0x95181F30, 0x9919202D, 0x9D1A212E, 0xA11B2330, 0xA41E2735, 0xA8262B3A, 0xAC1E2A37, 0xB0293640, 0xB433404A, 0xB8526068, 0xBC7D8C8C, 0xC0919D9D, 0xC0919D9D,
  0xC0BDBDB9, 0xBCBABAB6, 0xB88F938F, 0xB42F3333, 0xB0333640, 0xAC2E3140, 0xA72E3142, 0xA3262C3A, 0x9F1F2735, 0x9B26303D, 0x97293542, 0x9325333F, 0x8F262F41, 0x8B30344A, 0x87353954, 0x8439405F, 0x80404868, 0x7C434B70, 0x78434B74, 0x753E4773, 0x71404C76, 
        0x6D455179, 0x6A46527C, 0x6647547F, 0x63475680, 0x60445480, 0x5D485785, 0x5A4B5C89, 0x57535C8C, 0x555A5D90, 0x51595D90, 0x4F5D6494, 0x4C5C6795, 0x4A5C6A95, 0x475C6D96, 0x455D6E98, 0x435E6D98, 0x42606B97, 0x40666F9B, 0x3E616C99, 0x3D5F6897, 
        0x3C626B9A, 0x3A67709E, 0x396B71A2, 0x397177A7, 0x387174A6, 0x377176A2, 0x377279A2, 0x37717BA1, 0x366C769D, 0x376B76A0, 0x366E77A2, 0x377178A6, 0x376D74A3, 0x386B74A3, 0x386F78A5, 0x396F78A3, 0x3A717AA5, 0x3B727CA6, 0x3C6F78A2, 0x3E7178A5, 
        0x3F7174A3, 0x417074A4, 0x436D71A3, 0x44686FA1, 0x46646A9D, 0x49636A9E, 0x4B5D659B, 0x4D626B9D, 0x50656C9B, 0x53616998, 0x55606796, 0x58626A98, 0x5B5D6693, 0x5E5A6591, 0x615B6390, 0x655C6492, 0x68576190, 0x6C515D8C, 0x6F4C5886, 0x73465781, 
        0x7646557E, 0x7A48547C, 0x7E464E76, 0x823F436A, 0x86303254, 0x89202440, 0x8D1C2539, 0x911E2435, 0x951A2432, 0x991B2532, 0x9D1C2734, 0xA11D2536, 0xA5242D38, 0xAA242D39, 0xAE25323E, 0xB2344248, 0xB6576568, 0xBA818F93, 0xBE919CA0, 0xBE919CA0,
  0xBDBDBDB9, 0xB9B2B2AE, 0xB56E6E6E, 0xB12D3030, 0xAD2E343A, 0xA92C2F3E, 0xA52A303E, 0xA1232B38, 0x9C232B3B, 0x98293342, 0x942A3442, 0x90263240, 0x8C293246, 0x8833374D, 0x84373E56, 0x8038405C, 0x7C404768, 0x78434B70, 0x75444B73, 0x71424B76, 0x6D424C78, 
        0x6A445077, 0x66424F79, 0x63475480, 0x5F4A5782, 0x5C495783, 0x59475885, 0x564B5B8A, 0x5355608F, 0x505B5F92, 0x4D5B6193, 0x4A5C6494, 0x485E6B97, 0x465E6D98, 0x435D6E98, 0x415D709A, 0x3F60719A, 0x3D5F6C97, 0x3C65719C, 0x3A606C99, 0x39626C99, 
        0x3769729E, 0x367077A2, 0x357178A5, 0x34757BA8, 0x33767AAA, 0x33767BA7, 0x33737AA3, 0x32787FA6, 0x32747DA3, 0x32737AA3, 0x32757DA6, 0x32747AA7, 0x33747AA7, 0x33757BA8, 0x34787EA8, 0x35787FAA, 0x367880A8, 0x37767DA6, 0x38757DA6, 0x39777CA7, 
        0x3B7676A7, 0x3C7677A7, 0x3F7476A7, 0x406E73A4, 0x42686FA0, 0x44676EA0, 0x4761689D, 0x49666E9E, 0x4C646D9C, 0x4E616A9A, 0x515E6797, 0x54606997, 0x575A6592, 0x5A576490, 0x5E555E8C, 0x615B6392, 0x64565F90, 0x68525E8D, 0x6B4B5787, 0x6F465682, 
        0x73485781, 0x764A557E, 0x7A4A5078, 0x7E42486E, 0x82353959, 0x86212543, 0x8A1C2438, 0x8E1B2636, 0x92192533, 0x961D2935, 0x9A1E2837, 0x9E1F2737, 0xA3262F3C, 0xA72B3642, 0xAB24333C, 0xAF324249, 0xB346535A, 0xB774828A, 0xBB8E9D9D, 0xBB8E9D9D,
  0xBBBFBFBB, 0xB7B8BBB8, 0xB2707070, 0xAE3B4141, 0xAA272D33, 0xA62D303E, 0xA2262939, 0x9E222737, 0x992A3241, 0x962B3543, 0x91273240, 0x8D283542, 0x892F384B, 0x85383C53, 0x81383E56, 0x7D38405C, 0x793C4466, 0x7540456C, 0x71424972, 0x6D404A76, 0x6A404C77, 
        0x66424E75, 0x62404D77, 0x5F475480, 0x5B4A5882, 0x5845557F, 0x55435482, 0x52495B88, 0x4F535F8E, 0x4C5D6395, 0x495C6394, 0x46576292, 0x445D6B96, 0x415C6D98, 0x3F5B6D97, 0x3D5B7099, 0x3B62739D, 0x39616F9A, 0x3764719C, 0x36636E9A, 0x346A74A0, 
        0x336E76A1, 0x327079A3, 0x31787FA8, 0x307C81AC, 0x2F7A7DAC, 0x2F787CA8, 0x2E7178A2, 0x2E7B82A8, 0x2E787EA5, 0x2E7B80A9, 0x2E7A7DA9, 0x2E7C80AA, 0x2E7E81AC, 0x2F8083AD, 0x307E82AC, 0x307E82AA, 0x317F83AA, 0x327E83A9, 0x34797FA7, 0x357A7BA8, 
        0x377776AA, 0x387878AA, 0x3A7779AA, 0x3C7377A7, 0x3E7075A6, 0x406E73A4, 0x43676E9D, 0x4566709E, 0x48626C9A, 0x4A5D6795, 0x4E5C6695, 0x505E6996, 0x535B6694, 0x56586491, 0x5A515D8C, 0x5D576190, 0x61565E90, 0x64525D8D, 0x684B5988, 0x6B485684, 
        0x6F485682, 0x734A537F, 0x77484E79, 0x7B45496F, 0x7F393D5F, 0x83242D47, 0x871D263B, 0x8B1A2534, 0x8F1D2834, 0x93232F3B, 0x97222C3A, 0x9B1C2635, 0xA0222A38, 0xA42F3846, 0xA82B3A43, 0xAD2E3A44, 0xB0536067, 0xB4848E95, 0xB98A9898, 0xB98A9898,
  0xB9BDBDB9, 0xB4B0B4B0, 0xB0737773, 0xAC313737, 0xA82B2E37, 0xA3292C3C, 0x9F222737, 0x9B232B3A, 0x9626303E, 0x9227303E, 0x8E26313F, 0x8A273443, 0x86323A4B, 0x81383E52, 0x7D383E56, 0x793C425F, 0x75404567, 0x7240486D, 0x6E424971, 0x6A404B75, 0x663F4A75, 
        0x62424D76, 0x5F42517A, 0x5B45527D, 0x5847557F, 0x55485782, 0x51475784, 0x4E4D5F8B, 0x4B545F8F, 0x48575E90, 0x45575F92, 0x42586392, 0x405A6794, 0x3D5A6B96, 0x3B596E96, 0x395A7099, 0x3764769E, 0x3564739D, 0x336976A1, 0x326A779F, 0x30727CA6, 
        0x2F707AA3, 0x2E737BA4, 0x2D7B81A9, 0x2C7B80AA, 0x2B7A7CAB, 0x2A777AA7, 0x2A747BA4, 0x2A8086AB, 0x2A787CA4, 0x2A8082AB, 0x2A7A7CA7, 0x2A7E80AB, 0x2A8285AE, 0x2B8286AF, 0x2B8286AE, 0x2C8487AF, 0x2D8788AF, 0x2E898CB2, 0x308387AD, 0x328383B0, 
        0x327F7CB0, 0x347A78AC, 0x367E7EAD, 0x387A7DAB, 0x3B7578A7, 0x3D7479A6, 0x3F69719D, 0x4168739F, 0x4467729F, 0x46626D9A, 0x495D6A98, 0x4C5D6A96, 0x4F596692, 0x53586692, 0x56515E8B, 0x59575E8F, 0x5D575E92, 0x61535E8F, 0x644E5B8B, 0x68495784, 
        0x6C485681, 0x6F4A547F, 0x73485079, 0x77474A70, 0x7B3B4162, 0x7F29314B, 0x84212B3E, 0x881D2A39, 0x8C1C2937, 0x901D2B39, 0x9524303E, 0x99252F3C, 0x9D1F2736, 0xA128333E, 0xA52D3843, 0xAA333F48, 0xAE4E5B61, 0xB2879498, 0xB696A4A4, 0xB696A4A4,
  0xB7BBBBB8, 0xB2AFAFAC, 0xAD7C7F7F, 0xA923292C, 0xA52A3038, 0xA1232B38, 0x9C212B38, 0x98252E3D, 0x94232D3B, 0x8F262D3D, 0x8C273040, 0x872C3543, 0x8230394D, 0x7F353D53, 0x7B363F58, 0x763B4662, 0x72404B68, 0x6E3F4D6E, 0x6A3F4C72, 0x663F4E74, 0x633F4C75, 
        0x5F424D78, 0x5B44527D, 0x5842507C, 0x54415180, 0x51435481, 0x4D435784, 0x4A465B89, 0x47515F8F, 0x44545C90, 0x414F598E, 0x3F576495, 0x3C586696, 0x395A6A98, 0x385D6C9A, 0x3562719D, 0x346A74A2, 0x326D74A3, 0x2F717AA5, 0x2E757CA8, 0x2C767EA9, 
        0x2B7880A9, 0x2A7981A8, 0x297881A7, 0x287A80A9, 0x27787BAB, 0x267679A8, 0x26797FA9, 0x268488B0, 0x257A7FA8, 0x257E81AB, 0x257074A1, 0x267A7FA9, 0x268386AE, 0x278185AD, 0x278286AE, 0x28878BB2, 0x298588B0, 0x2A858AB0, 0x2B8588AF, 0x2D8385AF, 
        0x2F7E7CAD, 0x307778A8, 0x32787DA9, 0x34787DA8, 0x36767CA7, 0x38757CA5, 0x3B6E739E, 0x3E6D749F, 0x4069729E, 0x43626C99, 0x465F6996, 0x495D6997, 0x4C566392, 0x4F566391, 0x524D5C8B, 0x56556190, 0x59556091, 0x5D566190, 0x61505E8C, 0x64495883, 
        0x68485781, 0x6C4C5981, 0x7048557C, 0x74414B71, 0x783A3F65, 0x7C2C3453, 0x80222E44, 0x85212D3E, 0x89202D3A, 0x8D1F2C39, 0x9124303E, 0x962D3746, 0x9B262B3D, 0x9E242C37, 0xA329373C, 0xA72E393F, 0xAC556265, 0xAF929B9F, 0xB48E999C, 0xB48E999C,
  0xB4BBBBB7, 0xAFB8B8B8, 0xAB797C7F, 0xA722282E, 0xA2262E36, 0x9E1F2C37, 0x99202A39, 0x95242D3C, 0x91272E3C, 0x8D282E3E, 0x882A2F40, 0x842F3546, 0x80323A4E, 0x7B323D56, 0x7738415B, 0x733A4662, 0x6F3A4A66, 0x6B3A4D6C, 0x673C4E6F, 0x633A4E72, 0x5F3C4C74, 
        0x5B424D7A, 0x58444F7C, 0x5443507E, 0x50425281, 0x4D435584, 0x4A415886, 0x46415A87, 0x434B5B8D, 0x40576194, 0x3D525D92, 0x3B576598, 0x39586899, 0x365D6B9C, 0x33606B9C, 0x31666F9E, 0x2F7073A4, 0x2D7575A9, 0x2B787AAB, 0x2A797CAB, 0x28787DA9, 
        0x277880AB, 0x267881A9, 0x257681A7, 0x247C84AB, 0x237679A9, 0x22777CAA, 0x227C7FAC, 0x228085AF, 0x217B7FAB, 0x217B80A9, 0x216E75A0, 0x227B80A9, 0x228388AF, 0x238187AD, 0x238086AC, 0x248187AE, 0x257D83AA, 0x278187AE, 0x278187AE, 0x298284AD, 
        0x2A7B7CA8, 0x2C767AA5, 0x2E767DA7, 0x30737CA6, 0x32777EA6, 0x34757BA2, 0x3772749E, 0x3970749E, 0x3C6A719C, 0x3F636A97, 0x42606997, 0x455E6A98, 0x485A6694, 0x4B576592, 0x4F505F8E, 0x52566391, 0x56556190, 0x59525E8E, 0x5D4E5C88, 0x61485682, 
        0x65465780, 0x694A5B81, 0x6D43557B, 0x71404B74, 0x753C406A, 0x7931395D, 0x7D2B324C, 0x82222A3F, 0x86232E3F, 0x8A27313E, 0x8F262D3D, 0x932A2F42, 0x972C2E3F, 0x9C2B333D, 0xA0384345, 0xA4384848, 0xA9586767, 0xAE909999, 0xB1929F9F, 0xB1929F9F,
  0xB1B6B9B6, 0xADB3B6B3, 0xA95E6164, 0xA41E242C, 0xA0252D38, 0x9B1E2833, 0x971D2733, 0x92222C3A, 0x8E262F3C, 0x8A242D3C, 0x85272D3E, 0x812E3444, 0x7C323A4F, 0x78343E58, 0x743A4360, 0x703A4563, 0x6C394666, 0x673C4B6C, 0x643E5074, 0x60394C73, 0x5C3C4A75, 
        0x58414C79, 0x54414B7A, 0x5141507D, 0x4D435482, 0x4A435685, 0x46445987, 0x43425987, 0x4049598B, 0x3D555E92, 0x3A515C91, 0x38576698, 0x355A6B9A, 0x325E6B9D, 0x30616C9D, 0x2E6871A2, 0x2B6F74A5, 0x297375A7, 0x277478A8, 0x267378A7, 0x247179A5, 
        0x23747DA6, 0x22767FA7, 0x217580A6, 0x20767EA8, 0x1F777CA8, 0x1F7D81AB, 0x1E8387B0, 0x1E8589B1, 0x1E7C83AA, 0x1E7B81A9, 0x1E7C81A8, 0x1E7E84AB, 0x1E8086AE, 0x1F8086AC, 0x207E84AC, 0x207C81A9, 0x227D83AB, 0x227C83AB, 0x247C81AA, 0x257E80AA, 
        0x277B7BA8, 0x28777AA6, 0x2A747BA6, 0x2C727BA5, 0x2E727BA4, 0x317277A1, 0x337476A0, 0x376F739E, 0x386A6F9C, 0x3B626B99, 0x3E5F6996, 0x425D6896, 0x445C6A95, 0x48576593, 0x4B536491, 0x4F576492, 0x52566191, 0x56515D8B, 0x5A4D5A87, 0x5E485681, 
        0x6247577F, 0x6647577E, 0x6A445579, 0x6E444D75, 0x723B3F68, 0x7632395D, 0x7A2F3752, 0x7F232D41, 0x83242F3F, 0x882A3342, 0x8C272E3D, 0x90262B3D, 0x95323445, 0x992F3441, 0x9E3C4649, 0xA2414F4F, 0xA66C7878, 0xAB919A9A, 0xAF959F9F, 0xAF959F9F,
  0xAFB8B8B5, 0xABB2B5B2, 0xA666696C, 0xA21E2029, 0x9D272C36, 0x99202A34, 0x941E2631, 0x90242B3B, 0x8B27303D, 0x87242C3B, 0x82242A3D, 0x7E2B3344, 0x7A333B52, 0x75353E5D, 0x71374262, 0x6D394366, 0x69394769, 0x643B496F, 0x603C4C73, 0x5C3B4C73, 0x583C4C76, 
        0x553F4B78, 0x513E4A77, 0x4D41507D, 0x49435482, 0x46435683, 0x43445787, 0x3F445887, 0x3C4A588B, 0x39515A8F, 0x364F5B8F, 0x33586798, 0x31586898, 0x2F5C6B9A, 0x2C626E9C, 0x2A666F9E, 0x286C72A1, 0x266F72A3, 0x246E71A2, 0x226F76A4, 0x217279A4, 
        0x1F727CA4, 0x1E737EA6, 0x1D717CA3, 0x1C747CA5, 0x1B7C81AA, 0x1B7E84AC, 0x1A848AB0, 0x1A8289AE, 0x1A7F87AC, 0x1A7C82A7, 0x1A7D85A8, 0x1A8188AD, 0x1B8086AD, 0x1B7E84AA, 0x1C7D83AB, 0x1C7E84AC, 0x1D7C81AA, 0x1F7A80A9, 0x21797FA8, 0x21787CA7, 
        0x23797BA9, 0x25767AA7, 0x27727BA6, 0x29737EA7, 0x2B6E78A2, 0x2E6F76A1, 0x2F71759E, 0x326E729D, 0x356B719D, 0x38666E9A, 0x3B616A98, 0x3E5B6595, 0x415C6894, 0x4452608E, 0x48526190, 0x4B535F8E, 0x4F545F90, 0x53525D8C, 0x574E5A87, 0x5A495681, 
        0x5E47557E, 0x6247557B, 0x66425479, 0x6B444D74, 0x6F3D436A, 0x73323A5B, 0x77303852, 0x7C2C3447, 0x80263040, 0x85293242, 0x89292F3E, 0x8D232839, 0x922C2E3E, 0x97313542, 0x9B3D474C, 0xA06B7878, 0xA57F8A8A, 0xA996A2A2, 0xAD94A1A1, 0xAD94A1A1,
  0xADBABAB6, 0xA9B7BAB7, 0xA4646A6D, 0xA0151A22, 0x9B2B303A, 0x96212635, 0x92202735, 0x8D282E3C, 0x8926313E, 0x84212B3C, 0x801E2A3A, 0x7B283445, 0x77323D54, 0x73323F5E, 0x6E343F62, 0x6A364266, 0x663B496D, 0x613B4870, 0x5E3A4871, 0x593B4A74, 0x553D4C76, 
        0x513D4B77, 0x4E3D4C7A, 0x4A404E7C, 0x47425280, 0x43425382, 0x3F435584, 0x3C465887, 0x394C598B, 0x36535D8F, 0x33536192, 0x30586796, 0x2E576797, 0x2B5B6A98, 0x28636E9B, 0x26656F9C, 0x2469709E, 0x236C71A1, 0x206A709F, 0x1F6E76A2, 0x1D747DA6, 
        0x1C737DA5, 0x1A717EA4, 0x1A727FA6, 0x18717BA3, 0x187A7FA8, 0x17757CA4, 0x17767EA5, 0x167B82A7, 0x168087AA, 0x167C83A7, 0x167C84A6, 0x178289AD, 0x178288AE, 0x177F84AB, 0x187D84AB, 0x197D82AA, 0x1A787EA7, 0x1B777DA6, 0x1C7A7FA9, 0x1E777BA8, 
        0x20787BA9, 0x21767CA8, 0x236E77A3, 0x256F79A3, 0x286C76A1, 0x2A6C749F, 0x2C6E729E, 0x2F6C719D, 0x316B719C, 0x34666E99, 0x37606997, 0x3A5A6594, 0x3E5D6996, 0x41546390, 0x4450608E, 0x48505D8C, 0x4C535C8C, 0x50545C8B, 0x534F5B88, 0x584A5682, 
        0x5B45537C, 0x5F445278, 0x64435277, 0x68464E75, 0x6C454A6E, 0x70373E5E, 0x752F3952, 0x79313A4D, 0x7D273142, 0x82262E41, 0x862A3041, 0x8C272C40, 0x9026293B, 0x942D313D, 0x992A3439, 0x9D8C9494, 0xA2969E9E, 0xA697A0A0, 0xAB919D9D, 0xAB919D9D,
  0xABB5B5B5, 0xA6BCBFBC, 0xA24C5254, 0x9D1F2429, 0x99252A34, 0x94212631, 0x90262936, 0x8B292D3D, 0x86252E3C, 0x82202A3B, 0x7D1F2B3A, 0x79293948, 0x74314056, 0x70303E5C, 0x6B303D5E, 0x67354465, 0x633A496B, 0x5F3C496F, 0x5A3D4971, 0x563F4C75, 0x523F4D77, 
        0x4E40527B, 0x4A41517C, 0x4742507E, 0x43435281, 0x3F455484, 0x3C485885, 0x394B5A88, 0x354F5A8A, 0x32515B8D, 0x2F505D8D, 0x2D536392, 0x2A566795, 0x27586997, 0x255F6B97, 0x23626C9A, 0x21666F9C, 0x1F6A739F, 0x1D69719D, 0x1B68729C, 0x1A707BA4, 
        0x186E7BA2, 0x176D7CA2, 0x167280A6, 0x15747FA7, 0x157A80A9, 0x14787EA7, 0x14757DA5, 0x137E84AB, 0x138087AB, 0x137E85AA, 0x138188AB, 0x138289AD, 0x138389B0, 0x148187AD, 0x157F84AB, 0x157E84AB, 0x177B80A8, 0x18797FA8, 0x197A7FA8, 0x1A7A7EA9, 
        0x1C767BAA, 0x1E767CAA, 0x206D77A5, 0x226F79A5, 0x246D77A2, 0x276C74A1, 0x296F74A0, 0x2B6D739E, 0x2E6C729E, 0x3169719D, 0x34626B98, 0x375F6997, 0x3A5F6B96, 0x3E556492, 0x414D5C8C, 0x45505B8B, 0x49545B8C, 0x4C555C8C, 0x50545C89, 0x54515A86, 
        0x584A567F, 0x5C445178, 0x61435077, 0x65454D73, 0x69444A6E, 0x6E394060, 0x72303952, 0x7630374E, 0x7B2A3447, 0x80282E42, 0x84272D42, 0x8924263E, 0x8D282A3E, 0x922C303C, 0x963C464B, 0x9C8F9797, 0xA096A0A0, 0xA4949F9F, 0xA9949F9F, 0xA9949F9F,
  0xA9BABDB7, 0xA5AFB2AF, 0xA035383A, 0x9B2B3038, 0x97222731, 0x92222530, 0x8D252A37, 0x89262B3A, 0x84212937, 0x7F1F2B39, 0x7B202E3D, 0x76283748, 0x712E3E54, 0x6D2B3C58, 0x692C3E5B, 0x64364664, 0x603B4969, 0x5C3C4C6D, 0x57435074, 0x53455176, 0x50414F78, 
        0x4B40537D, 0x4841527E, 0x4441507E, 0x40435281, 0x3C475484, 0x394A5786, 0x364C5989, 0x334E5A8A, 0x2F505B8B, 0x2D515E8E, 0x29526291, 0x27546794, 0x24586895, 0x225D6A97, 0x20606C98, 0x1E626C98, 0x1C67719B, 0x1A67719C, 0x1866719C, 0x1669769E, 
        0x1569779E, 0x146A7AA2, 0x136F7FA5, 0x12737EA7, 0x11767BA7, 0x10797EA9, 0x107C81AA, 0x107E83AB, 0x0F7D82AA, 0x0F7D83A9, 0x108087AB, 0x107F85AB, 0x108187AD, 0x118186AE, 0x118085AD, 0x137F84AC, 0x137B81AA, 0x15767DA6, 0x16787FA7, 0x177B7FAB, 
        0x19767AAA, 0x1B737BA9, 0x1D6D76A5, 0x1F6E7AA7, 0x216A74A1, 0x23666F9C, 0x256A709D, 0x286D739F, 0x2B6A709D, 0x2E666F9A, 0x31646D9A, 0x34626E99, 0x385E6B97, 0x3B556491, 0x3E4B5C8A, 0x424F5B8A, 0x46545B8B, 0x49565F8E, 0x4D575F8C, 0x51535B87, 
        0x554E5882, 0x5A48547B, 0x5E475379, 0x62454F73, 0x66424768, 0x6B3A4160, 0x6F313C54, 0x742D364B, 0x782B3649, 0x7D272F42, 0x82242A41, 0x86252A3F, 0x8B323448, 0x8F2D343D, 0x946D7779, 0x9998A2A2, 0x9E97A2A2, 0xA2969E9E, 0xA7969EA1, 0xA7969EA1,
  0xA7B3B3B0, 0xA2AFB2B2, 0x9E4E5153, 0x99282D34, 0x94282A36, 0x90222432, 0x8B232532, 0x86232A36, 0x82222A39, 0x7D212F3C, 0x781F2F3E, 0x74263645, 0x6F2A3C4F, 0x6A293B53, 0x6630425B, 0x62374862, 0x5D3B4C69, 0x59404E6E, 0x55485475, 0x50475274, 0x4C414F77, 
        0x483F537E, 0x4540537F, 0x41415380, 0x3D445281, 0x39475483, 0x364A5686, 0x334D5B89, 0x304E598A, 0x2D525D8D, 0x2A53618F, 0x26536392, 0x24586995, 0x215B6B97, 0x1F616E99, 0x1D636D99, 0x1A65709A, 0x1968739B, 0x1768739B, 0x1569759D, 0x136F7CA3, 
        0x12707FA4, 0x117080A6, 0x0F6F80A7, 0x0F737DA9, 0x0E7579A9, 0x0E777BA9, 0x0D7579A8, 0x0D7579A6, 0x0C787DA8, 0x0C7A7FA9, 0x0C7C80AA, 0x0D7E84AC, 0x0E7F85AC, 0x0E7E82AB, 0x0E7A81A9, 0x0F7A80A9, 0x107A80A9, 0x11797FA9, 0x13777EA7, 0x15787DA9, 
        0x167478A8, 0x17727AAA, 0x196A75A3, 0x1C6C78A6, 0x1E6B76A4, 0x206B74A1, 0x226D74A1, 0x256D729E, 0x28696E9B, 0x2B626A98, 0x2E626C99, 0x315F6997, 0x355D6997, 0x38596795, 0x3B536190, 0x3F515C8B, 0x4353598B, 0x46545989, 0x4A585D8A, 0x4F565D88, 
        0x534F5882, 0x5749547B, 0x5B48537A, 0x5F495175, 0x643F4667, 0x68373F5C, 0x6D303B51, 0x712A3247, 0x762A3448, 0x7B283045, 0x7F232941, 0x84272B42, 0x892D2F42, 0x8D353C47, 0x92878E92, 0x9797A1A1, 0x9C97A1A1, 0xA096A0A0, 0xA595A1A1, 0xA595A1A1,
  0xA5B5B5B2, 0xA1B0B0B0, 0x9D464850, 0x982E313D, 0x92222535, 0x8E212431, 0x89202431, 0x84212933, 0x7F232D37, 0x7B24323B, 0x7623303D, 0x71273544, 0x6D29394C, 0x692A3953, 0x6432435F, 0x60364966, 0x5B3A4D6C, 0x563F4F72, 0x52425075, 0x4E425077, 0x4A434F79, 
        0x4644527E, 0x42455480, 0x3F475782, 0x3A485684, 0x374A5887, 0x334E5C8A, 0x304E5D8C, 0x2C505A8D, 0x2A545B8F, 0x26555F91, 0x24576393, 0x215D6C97, 0x1E5D6C98, 0x1C63709B, 0x1A626F9C, 0x1866729E, 0x1664729C, 0x1463709C, 0x1264709D, 0x116975A1, 
        0x0F6E79A4, 0x0E6D79A3, 0x0D6C77A3, 0x0C7179A6, 0x0B7A7EAC, 0x0A7B7EAD, 0x0A7A7DAC, 0x0A7A7BAB, 0x0A7B7CAB, 0x097F80AD, 0x097F7FAD, 0x0A8083AC, 0x0A7E85AA, 0x0B7C83AA, 0x0C797FA7, 0x0D767EA5, 0x0D7981A9, 0x0E7982A9, 0x107780A8, 0x11777EA9, 
        0x137478A8, 0x15747AA9, 0x166971A1, 0x196972A1, 0x1B6973A2, 0x1D6B74A2, 0x206A72A0, 0x22686F9C, 0x256A6F9B, 0x286A709C, 0x2B666D99, 0x2E5C6794, 0x315C6793, 0x355E6B95, 0x38596793, 0x3C55608D, 0x4051598A, 0x44505989, 0x48535E8B, 0x4C526089, 
        0x504E5C85, 0x5447547D, 0x59434F77, 0x5D455074, 0x613D4867, 0x66333D59, 0x6A2E3A52, 0x6F252F46, 0x74242F43, 0x78293043, 0x7E272B41, 0x8224283D, 0x87282C3D, 0x8C464D56, 0x90949B9E, 0x9597A0A0, 0x9A97A1A1, 0x9E979F9F, 0xA395A0A0, 0xA395A0A0,
  0xA4B6B3B6, 0x9FAEAEB4, 0x9A6E717B, 0x951F2134, 0x90222436, 0x8C212535, 0x871F2432, 0x82202830, 0x7D232F34, 0x78253238, 0x7426333E, 0x6F2A3646, 0x6A2C384E, 0x66303B57, 0x61354362, 0x5D364869, 0x58364C70, 0x553A4F76, 0x503E5179, 0x4B3F4E7A, 0x4743507D, 
        0x4348527E, 0x3F485480, 0x3B475582, 0x38485583, 0x354C5989, 0x304E5D8A, 0x2D4D5D8C, 0x2A525B8E, 0x27575C93, 0x24585F93, 0x215B6494, 0x1E5E6A97, 0x1C5F6B97, 0x19606C9A, 0x1763709E, 0x1562709E, 0x136272A0, 0x116371A0, 0x0F6470A0, 0x0E6772A1, 
        0x0C6E77A5, 0x0B727AA8, 0x0A7078A7, 0x097379A7, 0x08797CAC, 0x07787CAA, 0x07787AA9, 0x077C7CAB, 0x077E7CAB, 0x07817FAD, 0x078480AE, 0x078182AC, 0x077F84A9, 0x087F85AA, 0x087B82A9, 0x0A7982A8, 0x0A7B85AA, 0x0C7A85AA, 0x0D7783AA, 0x0E777CA9, 
        0x107678A7, 0x127679A9, 0x146D71A2, 0x166F74A4, 0x187077A6, 0x1B6D75A4, 0x1D6B74A2, 0x206B729F, 0x226C6F9C, 0x256B709C, 0x28676E99, 0x2B636C97, 0x2F616C97, 0x33626E97, 0x365D6992, 0x3A56638F, 0x3D515E8C, 0x424F5D8A, 0x454F628B, 0x494E638C, 
        0x4E4C6088, 0x5246587F, 0x5643527B, 0x5B425275, 0x5F3A4967, 0x63303D59, 0x682B3752, 0x6D243049, 0x71202A40, 0x77252C3F, 0x7B262E3F, 0x80262A3A, 0x84232535, 0x8A4E545D, 0x8E969D9D, 0x9399A2A2, 0x9896A09E, 0x9C95A19F, 0xA197A29F, 0xA197A29F,
  0xA2B4B4B4, 0x9DB6B8BB, 0x98767B82, 0x93171E2C, 0x8F262B3B, 0x8A222436, 0x85212534, 0x80202A34, 0x7C222E36, 0x76253239, 0x7225323F, 0x6D2B3745, 0x692D394F, 0x64323B58, 0x5F364260, 0x5A354667, 0x5736496E, 0x513D5177, 0x4D43557D, 0x4941517C, 0x4544507C, 
        0x4149537F, 0x3D4A5581, 0x39475480, 0x35495683, 0x314D5B88, 0x2E4E5C8B, 0x2B4C5D8B, 0x27525C8E, 0x24595D93, 0x215B6294, 0x1E5D6695, 0x1B5B6692, 0x19606C97, 0x165E6B99, 0x146672A0, 0x125F6D9D, 0x106371A0, 0x0E6370A0, 0x0D6571A0, 0x0B6671A1, 
        0x0A6F78A6, 0x08757CA9, 0x08757CA9, 0x07747AA7, 0x06777CA8, 0x057A7EAA, 0x057B7EAA, 0x047D7EAA, 0x048080AB, 0x058281AD, 0x048482AD, 0x048282AB, 0x057F83AB, 0x057E84AB, 0x067D83AA, 0x077A82A9, 0x087B84AA, 0x097C86AA, 0x0B7A85AB, 0x0C787EA9, 
        0x0D787AA9, 0x0F7679A8, 0x117377A6, 0x137277A7, 0x157076A5, 0x186F76A5, 0x1A6A74A3, 0x1D6A729F, 0x206C709D, 0x23696F9B, 0x26666F9A, 0x29636E98, 0x2C636E97, 0x30636E98, 0x335D6A92, 0x3857638F, 0x3B515E8C, 0x3F4F5D8A, 0x434C6189, 0x474D618A, 
        0x4B4A5E87, 0x4F43547D, 0x5441517A, 0x59404F74, 0x5D3A4867, 0x61313D5B, 0x66293551, 0x6B243048, 0x6F1F2A3F, 0x7420283A, 0x79242B3A, 0x7E292D3D, 0x821C1E2E, 0x87656A72, 0x8C989FA1, 0x9198A1A1, 0x96969F9F, 0x9B96A3A0, 0x9F97A1A1, 0x9F97A1A1,
  0xA0B3B3B3, 0x9BB2B5B7, 0x96747980, 0x92222C37, 0x8D1F2335, 0x88222637, 0x84212735, 0x7E212B33, 0x79242F37, 0x7524313A, 0x7027313E, 0x6B2B3746, 0x6630384F, 0x61353D58, 0x5D3A4564, 0x58394A6A, 0x543B4E72, 0x4F405277, 0x4B43547D, 0x4644527E, 0x4247537F, 
        0x3F4B5581, 0x3A4E5A84, 0x364B5883, 0x32495883, 0x2F4C5B87, 0x2C4B5B88, 0x284D5E8B, 0x25525C8D, 0x21575E90, 0x1F5C6492, 0x1C5C6894, 0x195D6893, 0x165E6A96, 0x14616D9B, 0x12606C9D, 0x10606D9D, 0x0E6471A0, 0x0C6571A0, 0x0A6872A2, 0x0967709F, 
        0x076E76A4, 0x06757CAA, 0x05737BA9, 0x04747BA6, 0x037980A7, 0x037D83AA, 0x027B81A9, 0x027C7FA8, 0x028082AB, 0x028183AB, 0x028082AA, 0x027E7FA9, 0x02797EA8, 0x037A7FA8, 0x047C81A9, 0x047981A8, 0x057982AA, 0x077A84AA, 0x087A84AC, 0x09797FA9, 
        0x0B7C7FAB, 0x0D767AA8, 0x0F767CA8, 0x117177A5, 0x137077A5, 0x156C74A2, 0x186871A0, 0x1A68719D, 0x1D69709B, 0x20676F9B, 0x23656F9A, 0x26636D98, 0x2A5F6B95, 0x2D5B6993, 0x315B6891, 0x3457648F, 0x3955618F, 0x3C53628D, 0x404E628B, 0x444C6189, 
        0x494E628A, 0x4D4A5B83, 0x5144547C, 0x56404F73, 0x5B394769, 0x5F313C5D, 0x6427324E, 0x681F2B44, 0x6E1C263B, 0x721E2537, 0x77232B39, 0x7C282E3E, 0x811A1E2E, 0x856A7077, 0x8A9CA4A4, 0x8F959E9E, 0x9495A19F, 0x9998A2A2, 0x9E97A2A2, 0x9E97A2A2,
  0x9FB4B6B6, 0x9AA8ADB0, 0x956E737A, 0x9029303B, 0x8C212537, 0x86232338, 0x81222838, 0x7C222A36, 0x77212E36, 0x7324313A, 0x6E26313F, 0x692A3647, 0x64313952, 0x5F393F5C, 0x5B3E4767, 0x56404F6F, 0x52425375, 0x4D415279, 0x4944547E, 0x4446527F, 0x414C5781, 
        0x3C505B83, 0x38505C85, 0x344C5A84, 0x304C5884, 0x2D4B5985, 0x294C5B87, 0x264E5F8B, 0x22535E8D, 0x1F585E8E, 0x1C5A6491, 0x195B6791, 0x175F6A95, 0x145D6996, 0x12626F9C, 0x0F5F6C9C, 0x0E616D9E, 0x0B6671A1, 0x0A6972A2, 0x086971A1, 0x066A73A2, 
        0x057179A7, 0x04737AA7, 0x03757BA9, 0x02787EA8, 0x017A81A7, 0x007C83A9, 0x007B82A7, 0x007A81A7, 0x008085AB, 0x008085AB, 0x007D82A9, 0x007D80AA, 0x007A7EAA, 0x01797EAA, 0x017E82AB, 0x027C82AB, 0x037C85AB, 0x047D87AB, 0x067A84AB, 0x07797FA8, 
        0x097B7EA9, 0x0A777CA8, 0x0C757AA6, 0x0E7177A3, 0x117076A3, 0x1369729F, 0x1567719D, 0x1868729E, 0x1B68709B, 0x1E656D99, 0x21626C97, 0x24636E97, 0x27606B97, 0x2C5C6993, 0x2E5B6B93, 0x335C6993, 0x36596492, 0x3A5A6893, 0x3E54688F, 0x424C6188, 
        0x464B5F87, 0x4C4B5C84, 0x4F43537A, 0x54404E74, 0x583B476A, 0x5D353E5F, 0x62283352, 0x671F2944, 0x6B1B253A, 0x701E2735, 0x75222C37, 0x7A262B3B, 0x7F171B2B, 0x8463676F, 0x899FA6A8, 0x8E99A2A2, 0x9397A2A0, 0x9797A1A1, 0x9C97A4A1, 0x9C97A4A1,
  0x9DB0B0B0, 0x99AFB1B1, 0x9482858A, 0x8E41484E, 0x8A1E2234, 0x8523233A, 0x80242A3A, 0x7B222A37, 0x76212C37, 0x71232E3B, 0x6C273241, 0x67293347, 0x632F354F, 0x5E3D405E, 0x593E4766, 0x54404D6E, 0x50425476, 0x4B43547A, 0x4747557E, 0x42495480, 0x3F4C5781, 
        0x3A4F5A81, 0x374D5A81, 0x324F5D85, 0x2E505D87, 0x2B4C5B86, 0x274D5C87, 0x234F608A, 0x20545F8C, 0x1D59618F, 0x1A5B658F, 0x175B688F, 0x145C6992, 0x125F6C96, 0x10626F9C, 0x0D626E9F, 0x0B646F9F, 0x096971A1, 0x076871A1, 0x066971A1, 0x046C74A2, 
        0x037379A7, 0x027377A6, 0x01787CAA, 0x007B7FAA, 0x007A81A7, 0x007A81A7, 0x007C83A9, 0x007981A7, 0x007A83A9, 0x007982A8, 0x007881A7, 0x007B7FAA, 0x007A7CAC, 0x007B7FAC, 0x007D82AD, 0x017B81AB, 0x017C84AB, 0x027F88AD, 0x047E88AC, 0x057C82AB, 
        0x07787CA7, 0x08787DA7, 0x0A767BA6, 0x0C7379A4, 0x0E6F77A2, 0x1168729E, 0x136A75A0, 0x1669739F, 0x1968719D, 0x1C646D9A, 0x1F606A97, 0x22616D97, 0x255F6B96, 0x295C6C94, 0x2D586992, 0x305C6993, 0x355D6894, 0x38586691, 0x3C546690, 0x4051668E, 
        0x444E6189, 0x494D5D85, 0x4D46557D, 0x52435077, 0x563D486D, 0x5C363F63, 0x602B3654, 0x65212C46, 0x691C2739, 0x6E1C2632, 0x73242D36, 0x78252B38, 0x7D1B1F2D, 0x826E747A, 0x879CA3A5, 0x8C98A1A1, 0x9196A19F, 0x9698A29F, 0x9B99A3A3, 0x9B99A3A3,
  0x9CAEAEAE, 0x97ADADB0, 0x92A3A3A7, 0x8D474750, 0x88242437, 0x8324263D, 0x7E23273B, 0x79222939, 0x74222B38, 0x6F252F3D, 0x6A293344, 0x652A3448, 0x61303650, 0x5C414462, 0x57424969, 0x52404C6C, 0x4E465678, 0x4947567E, 0x454B5780, 0x404D5682, 0x3C4E5880, 
        0x384E5980, 0x344D5A80, 0x30515E86, 0x2D526088, 0x284C5D85, 0x264D5D87, 0x214D5E88, 0x1E54618C, 0x1B5C658F, 0x185D6891, 0x155D6A91, 0x125A6790, 0x10606D96, 0x0D636F9D, 0x0B606C9E, 0x096871A2, 0x076C74A3, 0x056C74A3, 0x046C73A2, 0x026E75A4, 
        0x017378A7, 0x00797CAB, 0x00797CAB, 0x007C7FAB, 0x007C80A9, 0x007B81A9, 0x007E84AC, 0x007981A9, 0x00737DA6, 0x00737EA6, 0x00737FA6, 0x00777CA9, 0x00797AAC, 0x00767AAB, 0x007B80AD, 0x007F85AE, 0x007D85AD, 0x007C85AC, 0x027681A7, 0x037A81A8, 
        0x057B7FA9, 0x06777EA7, 0x08797FA8, 0x0A767DA7, 0x0C727BA5, 0x0F7079A3, 0x116E79A2, 0x146A759F, 0x166A739E, 0x19656F9B, 0x1D636E99, 0x20606E98, 0x235D6C96, 0x27596A94, 0x2A566991, 0x2E5A6A93, 0x325F6B96, 0x36586690, 0x3A53658F, 0x3E53688F, 
        0x424F638A, 0x474D5F85, 0x4B49587E, 0x5048547B, 0x55424C73, 0x59354063, 0x5E2C3555, 0x63222D46, 0x681C2639, 0x6D1D2632, 0x72242D34, 0x7729303B, 0x7B151926, 0x8072787E, 0x8699A1A3, 0x8B9BA4A4, 0x9097A2A0, 0x9597A3A0, 0x9998A5A2, 0x9998A5A2,
  0x9BB5B2B2, 0x96B3B0B0, 0x91AFADAF, 0x8C534F56, 0x872A2A3B, 0x81262840, 0x7D23273A, 0x78212938, 0x73242D3C, 0x6E232D3D, 0x69273144, 0x642D374D, 0x5F393E57, 0x5A434562, 0x55484F6F, 0x51475373, 0x4C445375, 0x4846567D, 0x434A5680, 0x3F4D5581, 0x3A4E5982, 
        0x364F5A80, 0x324E5A80, 0x2E4F5D83, 0x2A536187, 0x2752618A, 0x2352628A, 0x1F55658E, 0x1C57648E, 0x195B648D, 0x165D688E, 0x145D6A91, 0x115F6C93, 0x0E5E6C96, 0x0C606D9A, 0x095E6B9D, 0x07666FA1, 0x056B73A3, 0x046B72A1, 0x026F76A5, 0x007076A5, 
        0x007275A6, 0x007A7DAC, 0x00787AA9, 0x007C7EAB, 0x007D80AA, 0x00797DA8, 0x007B81AB, 0x007B82AC, 0x00747DA7, 0x00727EA7, 0x00737FA8, 0x007379A8, 0x007879AC, 0x007578AA, 0x007A7EAC, 0x007F84AF, 0x007C84AD, 0x007E87AD, 0x007E89AD, 0x017F86AC, 
        0x037D80AA, 0x047A80A8, 0x067B81AA, 0x087980A9, 0x0B747DA6, 0x0D707AA4, 0x0F6F7AA3, 0x126D77A1, 0x1569729D, 0x1868739E, 0x1B67739C, 0x1E64729A, 0x215D6E97, 0x25586B93, 0x28586C93, 0x2D5B6B94, 0x305E6996, 0x345C6A93, 0x38576A91, 0x3C50658C, 
        0x4150648B, 0x45506187, 0x4A4B5B80, 0x4E4A5780, 0x53454F76, 0x58394267, 0x5D2B3554, 0x62202B44, 0x661C2738, 0x6B1D2531, 0x70232E33, 0x76232A35, 0x7A151626, 0x7F91959B, 0x849FA5A7, 0x8999A29F, 0x8F98A3A1, 0x9399A2A0, 0x9899A5A3, 0x9899A5A3,
  0x9AB2B0B0, 0x94B0ADAD, 0x8FA3A1A5, 0x8A68686E, 0x862A2A3A, 0x80282A3E, 0x7B24283B, 0x76252A3F, 0x71232A3C, 0x6C202B3C, 0x67243241, 0x622D3B4A, 0x5E38425A, 0x59404668, 0x54475072, 0x4F485376, 0x4B455377, 0x4647547B, 0x41495580, 0x3D4A5681, 0x394E5881, 
        0x344C5A7F, 0x304D5C82, 0x2C4C5E82, 0x284A5C82, 0x26475B83, 0x214B5F86, 0x1E4D6489, 0x1B4F6088, 0x1758638B, 0x1459658E, 0x125A6690, 0x0F5E6A94, 0x0C5F6C95, 0x0A5C6B97, 0x08606E9C, 0x06616B9B, 0x04676F9D, 0x02696F9E, 0x006C73A1, 0x007075A4, 
        0x006F73A3, 0x007477A8, 0x007477A7, 0x007A7BAA, 0x007E7EAB, 0x007A7BA8, 0x007C80AC, 0x007B80AC, 0x007980AC, 0x007780AC, 0x00737EAA, 0x007075A6, 0x007677A9, 0x00797BAC, 0x007A7DAC, 0x007A80AC, 0x007E85AE, 0x007D86AD, 0x007985AB, 0x007B83AB, 
        0x017D81AB, 0x037C81AA, 0x057C82AA, 0x077A81A8, 0x09737BA3, 0x0B6D769E, 0x0E7079A0, 0x107179A1, 0x136A719C, 0x166B739E, 0x196C759F, 0x1D69749C, 0x1F636F98, 0x235D6C95, 0x275E6D95, 0x2A5E6C95, 0x2E5B6A97, 0x325A6A96, 0x37576993, 0x3C50648D, 
        0x3F50638B, 0x43526289, 0x484C5D84, 0x4D4A577F, 0x52455077, 0x573A4569, 0x5B2B3455, 0x60202B44, 0x651C293B, 0x6A1D2935, 0x6F232E36, 0x74222A35, 0x79131826, 0x7E959BA1, 0x839DA4A8, 0x8897A0A2, 0x8D97A2A2, 0x9297A3A3, 0x9899A5A5, 0x9899A5A5,
  0x98ACACAC, 0x93ACACAC, 0x8FA7AAAC, 0x8974787F, 0x842B2D39, 0x7F292B3B, 0x7A242A3B, 0x75262C42, 0x70212A41, 0x6B202C41, 0x66273645, 0x6130434B, 0x5C36465D, 0x57404B71, 0x53474F76, 0x4D48547A, 0x494A557E, 0x4449547E, 0x404A5681, 0x3C4A5782, 0x37495781, 
        0x3347577F, 0x2F4A5B81, 0x2B4A5C81, 0x2743577E, 0x2340567C, 0x1F42587E, 0x1C465E83, 0x194E6087, 0x1658648C, 0x1357638D, 0x1056608C, 0x0D59648F, 0x0B626F97, 0x085F6D96, 0x0663719A, 0x04616D98, 0x02686E9A, 0x006D749F, 0x007176A2, 0x007479A6, 
        0x007176A4, 0x007377A7, 0x007579A9, 0x007879A8, 0x007C7AA9, 0x007978A7, 0x007D7EAB, 0x007A7EAA, 0x007E83AE, 0x007B83AE, 0x00767FAB, 0x00757AA9, 0x007A7AAB, 0x007B7DAC, 0x007C80AD, 0x007B81AD, 0x007C84AD, 0x007680AA, 0x007681AA, 0x007982AB, 
        0x007C81AC, 0x01787EA8, 0x03777DA6, 0x05777EA6, 0x07757CA2, 0x0A737BA0, 0x0C70789D, 0x0E72779E, 0x126F739D, 0x156E729C, 0x1770759E, 0x1A6A719B, 0x1E656E98, 0x21646F98, 0x25636E99, 0x29606D99, 0x2D5E6C99, 0x325D6B98, 0x35586793, 0x39556590, 
        0x3E51638D, 0x424D5D87, 0x474B5B84, 0x4B4A5780, 0x50475278, 0x55404C6F, 0x5A2F3A59, 0x5E1F2C45, 0x641A293B, 0x681C2A35, 0x6E212D36, 0x721E2932, 0x77141825, 0x7C999DA2, 0x829FA5A9, 0x879AA1A5, 0x8C9AA3A7, 0x9198A4A6, 0x9698A4A4, 0x9698A4A4,
  0x97ABABAB, 0x93ACAEAE, 0x8DABB0B0, 0x887E8084, 0x832D3139, 0x7E2B2F3B, 0x7924293A, 0x74242B40, 0x6F212A41, 0x6A202C42, 0x65273448, 0x60314453, 0x5B3E4B66, 0x56454F75, 0x51495379, 0x4C49557B, 0x484B567E, 0x444A557E, 0x3F495580, 0x3A495681, 0x3649557E, 
        0x324A567E, 0x2D4C5A80, 0x2949587F, 0x2645557C, 0x2248597F, 0x1E475A7E, 0x1C475B80, 0x17515E84, 0x15565C84, 0x11525983, 0x0E4F5681, 0x0C505882, 0x09566088, 0x075C688E, 0x055F6C91, 0x03636E96, 0x01626995, 0x0069709B, 0x007279A3, 0x007077A2, 
        0x006F75A1, 0x007378A5, 0x007378A6, 0x007576A4, 0x007A78A6, 0x007A79A6, 0x007A7BA7, 0x007A7EA9, 0x007980AB, 0x00767FAA, 0x00727CA7, 0x00747AA8, 0x007678A8, 0x007578A7, 0x00777BA9, 0x00787EAA, 0x007981AB, 0x00737DA7, 0x007782A9, 0x00787FAA, 
        0x007A7FAB, 0x00797EA9, 0x02777CA7, 0x04767CA4, 0x06747CA2, 0x0871799E, 0x0B70799E, 0x0D6F759C, 0x106E719A, 0x1372769E, 0x166F749C, 0x19697098, 0x1D626A94, 0x205C6690, 0x245F6A94, 0x285F6C97, 0x2B606E98, 0x30616E99, 0x345A6993, 0x3855658F, 
        0x3C516189, 0x414F5F87, 0x45495982, 0x4A46547C, 0x4E485378, 0x53455173, 0x59323D5B, 0x5D1F2B45, 0x62192638, 0x671A2935, 0x6C202C35, 0x7119222C, 0x76343944, 0x7BA2A5AB, 0x819BA1A5, 0x869BA3A8, 0x8B99A2A6, 0x9097A0A2, 0x9597A0A3, 0x9597A0A3,
  0x96A6A9A9, 0x91A8ADAA, 0x8DA9ADAD, 0x87929898, 0x823D4347, 0x7D2B313A, 0x78252D3C, 0x73242D3D, 0x6E1F2A3F, 0x69202C44, 0x6327354C, 0x5E35455B, 0x5A45516E, 0x554B547B, 0x504C547B, 0x4B4A547C, 0x474A557D, 0x4249557C, 0x3D48557D, 0x3946547D, 0x3546507A, 
        0x30485178, 0x2C485178, 0x2949557A, 0x24505B7F, 0x204E5B7F, 0x1D48577B, 0x1A45557A, 0x16475077, 0x134B4D76, 0x10474A73, 0x0D484B74, 0x0B494F76, 0x084A5178, 0x06525A7E, 0x03535C80, 0x015A6388, 0x00555D87, 0x00575F8A, 0x00626A93, 0x00676D97, 
        0x00666C97, 0x006B709C, 0x007074A0, 0x007374A1, 0x007776A3, 0x007B7BA7, 0x007778A4, 0x007A7EA9, 0x00777EA8, 0x00727CA6, 0x00707BA5, 0x00727AA6, 0x00767AA8, 0x00777CA8, 0x00777DA8, 0x00777FA8, 0x007881A9, 0x007680A8, 0x007983AA, 0x00787EA9, 
        0x007C7FAB, 0x007B7EA9, 0x00777BA5, 0x02747AA2, 0x0471779D, 0x076C7399, 0x096F7699, 0x0C6C7196, 0x0F6A6E94, 0x11696E94, 0x14666C91, 0x18646A91, 0x1B586189, 0x1F4F5A84, 0x22535F86, 0x265C668F, 0x2A636E95, 0x2F657098, 0x32616E96, 0x375B688F, 
        0x3C54628B, 0x3F516189, 0x444C5B83, 0x4947557E, 0x4E48547A, 0x52465374, 0x57343F5D, 0x5C222E47, 0x611C293B, 0x661D2B38, 0x6B223038, 0x70131C25, 0x7660646D, 0x7AA4A8AB, 0x7F999FA5, 0x859CA5A7, 0x8A9CA4A7, 0x8F9CA5A5, 0x949AA6A6, 0x949AA6A6,
  0x96A6A9A9, 0x90A2A9A7, 0x8CA7ACAC, 0x87A9AFAF, 0x81464E52, 0x7C28303C, 0x7725303D, 0x72222D3D, 0x6D222E42, 0x67243249, 0x62283751, 0x5D384661, 0x58475375, 0x544D547D, 0x4F4F567E, 0x4A4D567F, 0x454B577F, 0x4148547C, 0x3C445178, 0x38425379, 0x33424D74, 
        0x2F41476F, 0x2B444B72, 0x27465074, 0x23495277, 0x1F414C72, 0x1C3A476C, 0x183D4A70, 0x1540466E, 0x1243426C, 0x0F44436C, 0x0C44456C, 0x0941456B, 0x073B4064, 0x04394062, 0x023A4262, 0x003D456A, 0x003C456F, 0x003D4671, 0x0048507A, 0x00545B85, 
        0x00525983, 0x00565C87, 0x00606691, 0x006D6F9A, 0x007474A0, 0x007A7BA5, 0x0071739F, 0x007479A3, 0x007078A2, 0x006B76A0, 0x006B77A0, 0x006A749F, 0x007379A5, 0x00767DA7, 0x00747DA6, 0x00767FA7, 0x00757EA5, 0x00767EA5, 0x007780A6, 0x00797FA7, 
        0x007C80A8, 0x007478A1, 0x006B6F99, 0x01676D95, 0x03636A90, 0x065C6489, 0x08555D81, 0x0B575D83, 0x0D575B82, 0x104D5179, 0x1452577E, 0x16565D83, 0x1A4D567E, 0x1E49547B, 0x214C577D, 0x25535C84, 0x295B638C, 0x2D5F688E, 0x315E698F, 0x365D688E, 
        0x3A56638A, 0x3E4F5D85, 0x434C5B84, 0x484C5881, 0x4D4B577C, 0x51475474, 0x57364260, 0x5B25314A, 0x601C2B3C, 0x65212E39, 0x6A23313A, 0x6F111C23, 0x756C7075, 0x7AA2A6A9, 0x7E9DA3A5, 0x849DA3A5, 0x899DA4A6, 0x8E9DA4A4, 0x939BA5A5, 0x939BA5A5,
  0x95A5AAAA, 0x90A9AEAB, 0x8BADB1B1, 0x85B3B5BA, 0x80646A74, 0x7B373F4D, 0x7627303D, 0x71253040, 0x6C202E41, 0x67243549, 0x6223334D, 0x5D364862, 0x58475376, 0x534B527D, 0x4E4D547E, 0x494E567F, 0x4449557D, 0x4049557B, 0x3B48577C, 0x37405176, 0x333E4970, 
        0x2E3E456B, 0x2A3D466B, 0x263A4369, 0x22323C62, 0x1E2C395E, 0x1B2C3A5F, 0x18354468, 0x143E456A, 0x11413E68, 0x0E3C3964, 0x0B37365E, 0x08323459, 0x062D3155, 0x04272E50, 0x022B3352, 0x00283154, 0x002B345B, 0x002F3860, 0x003B426A, 0x00495178, 
        0x00495078, 0x004C537B, 0x00555B83, 0x00696B94, 0x006D6E99, 0x007779A1, 0x0071749D, 0x0070769F, 0x006A739C, 0x00647099, 0x0069759D, 0x0064709A, 0x006A749F, 0x006B759F, 0x006C769F, 0x006F79A0, 0x0070789F, 0x00727A9F, 0x00626B93, 0x00616891, 
        0x00595E88, 0x00535983, 0x00525881, 0x004A5178, 0x02444C71, 0x043D476A, 0x073E486A, 0x0A444A70, 0x0D444870, 0x0F3E436C, 0x12434970, 0x154E557B, 0x194B537A, 0x1C424C73, 0x20444F75, 0x244B5479, 0x2850567D, 0x2C565C81, 0x30596287, 0x355A648A, 
        0x39556287, 0x3D4F5E84, 0x424C5B81, 0x474B5980, 0x4B4D5A7E, 0x504B5778, 0x553C4664, 0x5A293550, 0x5F223142, 0x64242F3C, 0x69233139, 0x6E162126, 0x7376797F, 0x79A5A9AB, 0x7E9B9FA3, 0x839DA1A4, 0x899FA6A6, 0x8D9CA5A2, 0x929CA3A3, 0x929CA3A3,
  0x95A8ACAC, 0x8FA3A7AA, 0x8AA4ABAF, 0x857B818C, 0x804A5062, 0x7B32374F, 0x752A3345, 0x70273545, 0x6B203041, 0x66223547, 0x611E314A, 0x5C384A63, 0x57495678, 0x524C537F, 0x4D4E5580, 0x484D577F, 0x444C577E, 0x3F48547A, 0x3A455379, 0x363B4B71, 0x323A466B, 
        0x2D3B4468, 0x29394366, 0x25354263, 0x21314062, 0x1E314263, 0x1A334466, 0x16374768, 0x133F466D, 0x103E3C68, 0x0D373561, 0x0A30315B, 0x072E3157, 0x052A3055, 0x02272F50, 0x00283251, 0x00283152, 0x002B3557, 0x002F385A, 0x00394064, 0x00434A6E, 
        0x00434A6F, 0x004C5378, 0x0050557B, 0x005E6189, 0x005D5F8B, 0x006A6D95, 0x0070749B, 0x006D749B, 0x00636E95, 0x0059668F, 0x00627097, 0x00647299, 0x00606D96, 0x005F6C95, 0x00636F97, 0x00687299, 0x006C749A, 0x00656E94, 0x004C557F, 0x003D456F, 
        0x00383E66, 0x003A4168, 0x00394165, 0x002E385A, 0x012F3958, 0x042E3958, 0x0635405B, 0x08384061, 0x0B3A3F64, 0x0F393E64, 0x11394066, 0x153C4468, 0x183F486C, 0x1C3F4B6E, 0x1F3B466B, 0x24444B70, 0x274B4D72, 0x2B4E5276, 0x3052587D, 0x34525B7F, 
        0x38515C82, 0x3D4E5B83, 0x424B5980, 0x464C597F, 0x4B4D587E, 0x504E597B, 0x543E4A66, 0x5A28354E, 0x5F212F41, 0x6323323D, 0x6927343B, 0x6E1C242B, 0x73838488, 0x78A3A7A9, 0x7DA0A4A6, 0x829FA3A5, 0x88A0A4A4, 0x8D9EA5A5, 0x929EA5A5, 0x929EA5A5,
  0x94A1A6A8, 0x8FAAAEB1, 0x8A6E7580, 0x84272D40, 0x7F292F49, 0x7A262B48, 0x75283149, 0x70253345, 0x6B223343, 0x66223647, 0x6021364B, 0x5C3C5166, 0x564C5A7C, 0x514E5681, 0x4C4F5681, 0x484D5781, 0x434B577E, 0x3E455178, 0x3A3A4970, 0x3634456B, 0x31324266, 
        0x2D324162, 0x29334263, 0x25354666, 0x213A4C6B, 0x1D3F5471, 0x1A425674, 0x16415673, 0x134D567B, 0x0F504E7A, 0x0C494A75, 0x094A4C74, 0x0745496F, 0x043D4467, 0x02394261, 0x0036405E, 0x00343F5C, 0x00343E5C, 0x00343E5C, 0x00394263, 0x003F4869, 
        0x00434B6D, 0x00535A7C, 0x00545A7D, 0x00595D83, 0x00595B87, 0x00656891, 0x006F7399, 0x006D759A, 0x005F6A92, 0x004F5D87, 0x005F6E94, 0x0069779C, 0x00616F97, 0x00616E96, 0x00657198, 0x00667197, 0x00677096, 0x00596289, 0x004D547D, 0x003D456C, 
        0x003A4264, 0x00363F5F, 0x002F3958, 0x002E3955, 0x01303C55, 0x032F3C54, 0x05303E54, 0x08323A58, 0x0B363C5F, 0x0E373D61, 0x11394063, 0x14394063, 0x173D4567, 0x1B3E4869, 0x1F3B4769, 0x23464B6E, 0x274A4B6E, 0x2B4E5074, 0x2F4F5278, 0x334B5279, 
        0x384C577D, 0x3C48557C, 0x4149587F, 0x464E5A80, 0x4A4A567B, 0x4F4D5A7A, 0x54404A68, 0x5929354E, 0x5E243445, 0x6325323F, 0x6824323A, 0x6D2E353C, 0x729A9CA0, 0x77A2A4A8, 0x7DA0A4A4, 0x829FA3A3, 0x879FA5A3, 0x8C9FA5A5, 0x919FA6A6, 0x919FA6A6,
  0x94A6ADAD, 0x8E9BA6A8, 0x89495665, 0x844A546B, 0x7F3F4767, 0x7A282F54, 0x74242F4C, 0x6F232F46, 0x6A273649, 0x65243448, 0x6028394C, 0x5B445267, 0x56525B7B, 0x51515780, 0x4C50567F, 0x474E567E, 0x434C567C, 0x3E455178, 0x3A3C4870, 0x35334269, 0x31364366, 
        0x2C3A4866, 0x283C4A67, 0x243F4D6D, 0x20435373, 0x1C49597B, 0x194B5C7D, 0x154E6080, 0x1259628A, 0x0F60618E, 0x0B595D86, 0x09585D83, 0x065C6285, 0x03586181, 0x01505A7A, 0x004A5475, 0x00464E71, 0x0041476C, 0x003B4366, 0x003D4668, 0x00404A6A, 
        0x00424C6D, 0x00525B7D, 0x00555E81, 0x00565B84, 0x005D5E8C, 0x00676A95, 0x0070749C, 0x0070779E, 0x00626C94, 0x00535F89, 0x00626E95, 0x006D799F, 0x0069739D, 0x0068729B, 0x006A729B, 0x006A7299, 0x00646C92, 0x005B6288, 0x00575D83, 0x004C5379, 
        0x0042496E, 0x003C4368, 0x00373F64, 0x003A4467, 0x003B4666, 0x0335405F, 0x053C4764, 0x07444D6D, 0x0A495074, 0x0D4D5678, 0x10505979, 0x134E5778, 0x174A5373, 0x1B475171, 0x1E475373, 0x22455070, 0x2640486C, 0x2A464D72, 0x2E495075, 0x33475276, 
        0x37475376, 0x3C485778, 0x404B5B7D, 0x45525E83, 0x4A48557B, 0x4F4A597B, 0x53414B6C, 0x58242F4D, 0x5D252F49, 0x622A3345, 0x682D3744, 0x6D505561, 0x72A3A5AC, 0x77A4A8AC, 0x7CA1A6AA, 0x819DA3A7, 0x879FA5A7, 0x8C9CA5A7, 0x919DA6A6, 0x919DA6A6,
  0x93A2AEAE, 0x8E8D99A2, 0x893E4F63, 0x84394A67, 0x7E3F4C6E, 0x79313A60, 0x74243152, 0x6F25314D, 0x6A27334B, 0x65273348, 0x602E3950, 0x5B4B556A, 0x55575B7B, 0x5151577D, 0x4C4F567C, 0x4750557C, 0x424D557B, 0x3E495379, 0x39434E74, 0x353C4971, 0x303F486C, 
        0x2C424A68, 0x28434C6A, 0x24465070, 0x204A5476, 0x1C525E80, 0x18505C80, 0x154E5C81, 0x115D658E, 0x0E626391, 0x0B696C92, 0x08646A8E, 0x066B7291, 0x03656D8C, 0x01676F8E, 0x0051587E, 0x0051547E, 0x004C4F7A, 0x00474B73, 0x0041486C, 0x003D4768, 
        0x003D486A, 0x00485176, 0x00525B81, 0x00545A85, 0x005A5D8B, 0x00626793, 0x006C719B, 0x00767BA2, 0x007279A0, 0x00677099, 0x0069749B, 0x00757DA5, 0x00757AA6, 0x006F75A1, 0x006D739D, 0x006B7199, 0x0060658D, 0x005E6389, 0x005A6084, 0x004F547C, 
        0x00494D77, 0x004A4E79, 0x00484D77, 0x004A5179, 0x004E577C, 0x02555E81, 0x045C6686, 0x07636B8C, 0x0A63698F, 0x0D656B8F, 0x10656C90, 0x13666D90, 0x17636A8C, 0x1A5F6889, 0x1E586284, 0x224B587B, 0x26424F75, 0x2A3D4C71, 0x2E404F71, 0x32425172, 
        0x373F506F, 0x3B465773, 0x404A5A77, 0x45505F80, 0x494B597F, 0x4E4C597D, 0x53424E70, 0x58222C4F, 0x5D2A3050, 0x622D354C, 0x672D3247, 0x6C5D6073, 0x717B8090, 0x77828A97, 0x7C9BA1AC, 0x819BA1AB, 0x869BA3AA, 0x8B99A2A8, 0x919AA6A8, 0x919AA6A8,
  0x93A5ACB1, 0x8E89929D, 0x89404D67, 0x84273559, 0x7E2D3760, 0x79424A73, 0x74222F54, 0x6F283553, 0x6A27334B, 0x64273449, 0x5F2C394F, 0x5A4D576D, 0x5558607E, 0x5054597E, 0x4C52587E, 0x4752587E, 0x424C547B, 0x3D485178, 0x39455078, 0x34424D75, 0x303F496F, 
        0x2C434A6E, 0x28474F72, 0x234E5677, 0x204B5475, 0x1C495576, 0x18525E7F, 0x154C5B7B, 0x114E547D, 0x0E5F5C88, 0x0B5E5D84, 0x0856577A, 0x0536395C, 0x033A3D5E, 0x01434768, 0x003E4065, 0x003D3F69, 0x0042456F, 0x00494E74, 0x00454C6F, 0x003D4568, 
        0x00394265, 0x00394269, 0x00424B73, 0x004D547D, 0x00575D87, 0x00606790, 0x006B7299, 0x00747BA2, 0x00757DA5, 0x007078A2, 0x006F78A2, 0x00777EA8, 0x00797EA9, 0x00757BA5, 0x007278A0, 0x006E749A, 0x0062688E, 0x005D6287, 0x005A5F83, 0x00545980, 
        0x00555981, 0x00565B83, 0x005A5F85, 0x005A6083, 0x00656D8C, 0x02707893, 0x04707892, 0x07717595, 0x0A72729A, 0x0C707097, 0x106B6C95, 0x13666892, 0x16636790, 0x1A656A93, 0x1E626791, 0x21545D84, 0x26475478, 0x2A435075, 0x2E4B597B, 0x324C5B7A, 
        0x36425171, 0x3B465573, 0x40475775, 0x444E5D7D, 0x494E5C7F, 0x4E4D5C7B, 0x53414C6C, 0x58222D4C, 0x5D222B46, 0x6230384F, 0x67283042, 0x6C2C334D, 0x712A3050, 0x77323957, 0x7C72788D, 0x819DA1AD, 0x869BA3AC, 0x8B9BA4AA, 0x919AA6A8, 0x919AA6A8,
  0x93A9B1B5, 0x8E808999, 0x8936405F, 0x842D3761, 0x7E333B6A, 0x79484F7B, 0x742F3A60, 0x6F253153, 0x6A2A3852, 0x6429364D, 0x602B3850, 0x5A4D566D, 0x555A617F, 0x50575C81, 0x4B545A80, 0x47545B81, 0x424F587D, 0x3D49537B, 0x39455178, 0x34414E75, 0x303F4B72, 
        0x2C464B74, 0x274C5179, 0x23494F75, 0x1F434B6F, 0x1C3B4567, 0x18283555, 0x14182747, 0x11151A40, 0x0E19153D, 0x0B121032, 0x08080825, 0x05373750, 0x0306071E, 0x001A1B34, 0x0035364F, 0x00303154, 0x002D3059, 0x00353A60, 0x003C4367, 0x003F466A, 
        0x003F466A, 0x00373F66, 0x00374069, 0x00424A73, 0x004F577F, 0x005C648B, 0x00697197, 0x00737BA2, 0x00767FA7, 0x00747CA7, 0x00757DA9, 0x00797FAB, 0x00787DA8, 0x00757CA5, 0x0071779F, 0x006E749A, 0x00646A8F, 0x005B6084, 0x00595F82, 0x00575C81, 
        0x00595D84, 0x00575B81, 0x005A5F82, 0x00515778, 0x00505774, 0x02515971, 0x04565E75, 0x07606281, 0x0969648C, 0x0C716F93, 0x10737298, 0x136D6D96, 0x16676993, 0x1A6A6C95, 0x1E636691, 0x21575F86, 0x254D5A7D, 0x2A475478, 0x2E4A597A, 0x32505F7E, 
        0x364E5D7A, 0x3B53627E, 0x404D5D7A, 0x44515F7E, 0x49566382, 0x4E54617E, 0x5344516C, 0x5826334C, 0x5D202D43, 0x622B374C, 0x682D354B, 0x6D3C4263, 0x725A5D85, 0x76595D82, 0x7C4D5172, 0x819197A9, 0x869DA3AE, 0x8B9BA2A8, 0x909BA4A7, 0x909BA4A7,
  0x93ACB1B8, 0x8E808796, 0x893C4567, 0x832F3764, 0x7E394172, 0x7A48527F, 0x7438436D, 0x6F2A365C, 0x6A293653, 0x642C3953, 0x5F2E3A54, 0x5B4F5971, 0x5557607E, 0x50545B81, 0x4B515A7E, 0x47505980, 0x42515C81, 0x3D4D5A7F, 0x39425178, 0x343F5176, 0x30444D78, 
        0x2C464B76, 0x27454A73, 0x23394068, 0x1F30385E, 0x1C242F4F, 0x18192543, 0x14172440, 0x112A3048, 0x0E17132B, 0x0B232234, 0x08262732, 0x059FA0A4, 0x0333363D, 0x011D2027, 0x003C3E46, 0x0054566B, 0x003A3D5F, 0x003C4063, 0x00363B60, 0x0032385E, 
        0x00373D64, 0x00333962, 0x00353C65, 0x003A436C, 0x00444E76, 0x00535E84, 0x00656F95, 0x00727BA2, 0x00747DA6, 0x00717BA5, 0x00737CA8, 0x00787FAB, 0x007A80A9, 0x00747BA4, 0x006D739B, 0x00676D93, 0x005E6489, 0x00595F82, 0x00575D7F, 0x0052577C, 
        0x00474B74, 0x003B4068, 0x00363B5F, 0x00363C5A, 0x00222841, 0x02171D32, 0x04070D1E, 0x0713152C, 0x09130F2F, 0x0C2D2B4A, 0x0F403F5F, 0x134F5170, 0x165D5F80, 0x1A676A8B, 0x1E666B8E, 0x215B6486, 0x264F5C7F, 0x2A4D5A7E, 0x2E556282, 0x32586583, 
        0x36556380, 0x3B586883, 0x4055637F, 0x4452617F, 0x49556282, 0x4E56617D, 0x53444F69, 0x58243248, 0x5D253346, 0x6228334A, 0x67414960, 0x6C5B6083, 0x715B5D8D, 0x76555785, 0x7C51577E, 0x818D93A9, 0x879FA5B2, 0x8B9BA2A8, 0x909BA4A7, 0x909BA4A7,
  0x93AEB3B8, 0x8E7B8294, 0x893E4567, 0x84333967, 0x7E394174, 0x79485183, 0x7436416F, 0x6F334166, 0x6A2C3A5A, 0x642A3953, 0x5F313E57, 0x5B4D5971, 0x55555E7C, 0x50555C82, 0x4C535C82, 0x47515C81, 0x42535F83, 0x3D526084, 0x394C5D81, 0x3544547A, 0x30475179, 
        0x2C484B76, 0x28373D67, 0x242C315C, 0x20232A50, 0x1C151F40, 0x1838405D, 0x15646C82, 0x11373A4F, 0x0E22212F, 0x0B292A32, 0x08181A1C, 0x06343837, 0x032B2F2C, 0x01252927, 0x006B6E6D, 0x007F828D, 0x004B4E6A, 0x003F4262, 0x0046496C, 0x0042466C, 
        0x003A3F67, 0x00393E66, 0x00353B63, 0x00333C65, 0x003D4872, 0x004E5A82, 0x00626E95, 0x006E79A0, 0x00707BA4, 0x00717BA5, 0x00717CA7, 0x00757DA8, 0x00777EA6, 0x007078A0, 0x00636A93, 0x005A6289, 0x00585E83, 0x004D5377, 0x004C5475, 0x00444A70, 
        0x003D416A, 0x003A3E65, 0x00404464, 0x002D3149, 0x01181D2F, 0x02202531, 0x043D424A, 0x076B6B72, 0x0A25222B, 0x0C120F1B, 0x1020212F, 0x13272A3D, 0x16262A41, 0x1A41475F, 0x1E59617A, 0x2258617F, 0x26535E81, 0x2A4C597C, 0x2E505D7E, 0x32566483, 
        0x375B6985, 0x3B5E6D87, 0x405B6A86, 0x44586483, 0x495B6285, 0x4E5A6380, 0x5347526A, 0x58263348, 0x5D1F2D43, 0x6238445C, 0x67646C85, 0x6C6B7096, 0x7150548B, 0x773D4377, 0x7C555B83, 0x82888EA7, 0x869BA3B0, 0x8B9BA4AA, 0x919DA6A8, 0x919DA6A8,
  0x94B2B4B9, 0x8E848999, 0x89424967, 0x84373C67, 0x7F3B4377, 0x7A485285, 0x75313E70, 0x6F2E3C64, 0x6A2F3F61, 0x652A3955, 0x6034435E, 0x5B4B5971, 0x5654607C, 0x51566084, 0x4C556085, 0x47525F83, 0x42505F83, 0x3E4F5F82, 0x394C5C80, 0x3542547A, 0x31414D74, 
        0x2C424870, 0x28333964, 0x24212752, 0x20191E46, 0x1C33395B, 0x18484E6B, 0x156E728A, 0x125D5E74, 0x0F211F36, 0x0B1E1E2D, 0x081E202B, 0x062C2F36, 0x032A2E33, 0x013A3E42, 0x008B8D91, 0x009496A1, 0x00787B8F, 0x006D6F89, 0x00393B5E, 0x004B4D73, 
        0x00575A80, 0x00575B80, 0x00383D64, 0x00303963, 0x00374271, 0x004B5783, 0x00606C94, 0x0069759C, 0x006C78A0, 0x00717DA5, 0x00707DA5, 0x00727CA5, 0x00727AA2, 0x006D759D, 0x0059608A, 0x00505880, 0x004C547A, 0x004B5176, 0x00545C7B, 0x00494F73, 
        0x0043476F, 0x00414568, 0x0060637C, 0x003B3E52, 0x001E222F, 0x032A2E34, 0x05353939, 0x07585754, 0x0A3E3936, 0x0D282525, 0x10555559, 0x14787B82, 0x17444957, 0x1A171D33, 0x1E2E364D, 0x2247516F, 0x26505D80, 0x2A4F5B7E, 0x2E525F80, 0x325A6885, 
        0x375D6B87, 0x3B68758F, 0x4062718B, 0x455B6586, 0x495D6087, 0x4E596180, 0x5347516C, 0x5826334C, 0x5D202D48, 0x624D5773, 0x67696E8D, 0x6C5B608D, 0x724D548A, 0x77505788, 0x7C5F668B, 0x81878FA7, 0x869BA3B0, 0x8C9AA3AC, 0x919DA4AA, 0x919DA4AA,
  0x94ADB4B7, 0x8E90949F, 0x894D5470, 0x84393E67, 0x7F3B4175, 0x7A444E85, 0x75374475, 0x6F2F3C68, 0x6B354467, 0x652A3B57, 0x61394862, 0x5B4A596F, 0x56525E7C, 0x51545E83, 0x4C555F85, 0x47546184, 0x43556387, 0x3E536385, 0x3A4D5E82, 0x3545557B, 0x31425176, 
        0x2D3C446C, 0x2831375F, 0x24363C63, 0x20474C70, 0x1D46486C, 0x19494B6E, 0x16565776, 0x125C5979, 0x0F3E395D, 0x0C2C294A, 0x091D1C37, 0x06303147, 0x04393A4E, 0x026D6D7F, 0x00848395, 0x00686A7D, 0x00606477, 0x0073758B, 0x00434567, 0x0042436B, 
        0x004B4C75, 0x006B6E90, 0x0041466C, 0x00303864, 0x00364274, 0x004B5785, 0x005D6994, 0x0065729A, 0x0069769D, 0x006F7DA2, 0x00707FA3, 0x00737EA4, 0x007178A1, 0x0070789E, 0x00565E87, 0x004E567E, 0x00565E82, 0x00797E9A, 0x0058607E, 0x0043496E, 
        0x004D5176, 0x006E728D, 0x00838699, 0x00686B7A, 0x00242831, 0x03313434, 0x0522251F, 0x082E2B24, 0x0A413A35, 0x0D35302F, 0x11777477, 0x148E8D96, 0x175F6271, 0x1B31354C, 0x1E252947, 0x222B3457, 0x26425075, 0x2B566385, 0x2F596686, 0x335B6987, 
        0x37606E8A, 0x3C697791, 0x4163718C, 0x455B6487, 0x4A5F608A, 0x4F595F81, 0x54464E6C, 0x5926304E, 0x5E2C3753, 0x63616988, 0x68696E93, 0x6D5D6490, 0x724F588A, 0x774E5786, 0x7C646E8F, 0x829299AF, 0x879CA5B4, 0x8C9CA3AE, 0x92A0A7AC, 0x92A0A7AC,
  0x94ABADB0, 0x8F9A9EAA, 0x8A565D75, 0x85383E64, 0x80404676, 0x7A4C5285, 0x7542497B, 0x7035406A, 0x6B374467, 0x662B3A57, 0x613B4A63, 0x5C4F5D75, 0x57515F7B, 0x52535F82, 0x4D545F83, 0x48546184, 0x43566285, 0x3F546185, 0x3A4E5E82, 0x36404E75, 0x3137446D, 
        0x2D3B4770, 0x29434D75, 0x25475076, 0x214E5378, 0x1D52557B, 0x1A4F5177, 0x16535177, 0x13514E76, 0x1059557D, 0x0C5C5A7E, 0x0A5F5E7F, 0x075E5E7E, 0x04757590, 0x026B6A88, 0x006B6A89, 0x005E5D7F, 0x00525075, 0x004D4B73, 0x0053527D, 0x005D5C87, 
        0x00575882, 0x005A5D86, 0x00424872, 0x00353E6A, 0x003A4473, 0x004F5985, 0x005F6993, 0x00646F98, 0x0068739C, 0x006E79A1, 0x00717DA5, 0x00737EA6, 0x006E78A1, 0x006E779F, 0x00565F8A, 0x00555C86, 0x00666C90, 0x006E7494, 0x004B5276, 0x0053557D, 
        0x005B5682, 0x006F6B90, 0x007A7895, 0x0088879B, 0x02515161, 0x03282833, 0x0623242B, 0x08312D32, 0x0B3E363C, 0x0F67626B, 0x1192909B, 0x15777588, 0x1854536F, 0x1B4B4B6B, 0x1F424467, 0x23323960, 0x273F4770, 0x2B565D81, 0x2F5B6484, 0x335F6987, 
        0x3868738F, 0x3C6A7691, 0x4164708B, 0x465B6589, 0x4A5F638C, 0x4F595F81, 0x5447506F, 0x5A2B3554, 0x5E374260, 0x63636E8C, 0x68687393, 0x6E626A96, 0x73555C91, 0x784D5487, 0x7D676D94, 0x829096AF, 0x879AA3B2, 0x8D9CA5AD, 0x92A0A7AC, 0x92A0A7AC,
  0x95ACB1B4, 0x8FA7AEB5, 0x8A585F75, 0x863C4364, 0x814A4E7B, 0x7B4D5183, 0x76464E7E, 0x70404873, 0x6B3C466C, 0x66313F5E, 0x613D4A65, 0x5D515F77, 0x58525F7B, 0x52525F81, 0x4D546182, 0x49566385, 0x44586486, 0x40525D82, 0x3B4A577E, 0x37404C74, 0x32425079, 
        0x2E45547C, 0x2A49567E, 0x26505880, 0x22555A81, 0x1E585B83, 0x1A5B5B84, 0x175B5982, 0x145B5A82, 0x105B5B82, 0x0D606086, 0x0A616187, 0x085E5E84, 0x056D6D90, 0x0367678B, 0x01646489, 0x00605B89, 0x005D558A, 0x00555084, 0x00595688, 0x005A5988, 
        0x00515281, 0x00525582, 0x00404573, 0x00373F6B, 0x00424A75, 0x00515882, 0x005E668F, 0x00656D97, 0x00686F9B, 0x007076A3, 0x007178A6, 0x006E78A4, 0x006E79A3, 0x0065719C, 0x005D6793, 0x005A608D, 0x0070759C, 0x006D7197, 0x0066698F, 0x00625E8C, 
        0x00554B81, 0x00564D7F, 0x0059527D, 0x00706D8D, 0x026B6984, 0x0452536B, 0x06585A6F, 0x094F4B5E, 0x0C625C6F, 0x0F7D788B, 0x126D6881, 0x165D5A78, 0x18615F81, 0x1C5C5B81, 0x204D4E77, 0x24434771, 0x284A4F76, 0x2C4B5076, 0x3053597E, 0x355F6788, 
        0x3968708E, 0x3D6A7491, 0x4264708B, 0x465D6889, 0x4B5D668B, 0x50555C7F, 0x55495172, 0x5A293254, 0x5F3E4A6A, 0x646A7993, 0x69707F9C, 0x6E65709B, 0x73595C95, 0x79444881, 0x7D696B96, 0x839599B4, 0x889AA0B1, 0x8D9EA5B0, 0x929EA7AA, 0x929EA7AA,
  0x96ABB0B0, 0x90AEB2B9, 0x8B646D7F, 0x863F4564, 0x814E527D, 0x7B4D4F85, 0x77474C7F, 0x723F4475, 0x6C333C67, 0x67353F65, 0x62404C6C, 0x5D505C78, 0x58535F7F, 0x53515E80, 0x4E546183, 0x49566285, 0x455A6589, 0x41505B81, 0x3C48547B, 0x3749557C, 0x33505C84, 
        0x2F46547D, 0x2B45527C, 0x2749537E, 0x234F567F, 0x1F585C85, 0x1B5E5F87, 0x18605F89, 0x14616189, 0x1166678C, 0x0E65678C, 0x0B65688C, 0x0968698E, 0x066F7193, 0x04727396, 0x026C6D91, 0x0062608B, 0x005C5788, 0x00545182, 0x00575786, 0x00585987, 
        0x004B4D7B, 0x00474B77, 0x003D4270, 0x003D4470, 0x0049507D, 0x004E5582, 0x0059618C, 0x00646C97, 0x00656B9A, 0x006D74A2, 0x006E76A5, 0x00626D9D, 0x006876A2, 0x00606D9A, 0x00606B97, 0x00525A88, 0x0061658F, 0x006B6C94, 0x0067678E, 0x0066648E, 
        0x00605B8B, 0x005C5786, 0x005C5984, 0x01646387, 0x036E6E8D, 0x0571738F, 0x0884869E, 0x0A6C6985, 0x0D77718B, 0x0F6C6684, 0x13666181, 0x16686687, 0x19606085, 0x1D606086, 0x215C5E86, 0x25575B83, 0x29596085, 0x2D4C547B, 0x314B547B, 0x355A6788, 
        0x3A63708F, 0x3E667592, 0x4261708C, 0x475C6A8A, 0x4C596388, 0x51545B7F, 0x56495173, 0x5B263052, 0x60505B7B, 0x646F7C9A, 0x6A6F7E9D, 0x6F646F9B, 0x74595D96, 0x793E427B, 0x7F656993, 0x83999DB6, 0x889AA0AF, 0x8E9DA4AD, 0x939EA5A9, 0x939EA5A9,
  0x96A6ABAE, 0x91ADB1B8, 0x8C868F9C, 0x87434A67, 0x8150547F, 0x7D4A5085, 0x7743487D, 0x72343B6F, 0x6D222B5F, 0x682A345F, 0x633F4A70, 0x5E525E7E, 0x59556182, 0x54546083, 0x4F535F81, 0x4B545F84, 0x46566186, 0x41505B81, 0x3D4E5A81, 0x38515C83, 0x34556189, 
        0x304B5883, 0x2C4A5580, 0x2849537F, 0x2447517D, 0x204F5580, 0x1C525681, 0x19525480, 0x15535680, 0x125D6088, 0x1062648C, 0x0C61648B, 0x0A64688F, 0x0760628B, 0x0561648C, 0x0362658C, 0x0162638C, 0x0060608B, 0x005B5B88, 0x00575986, 0x00545682, 
        0x00454975, 0x00434873, 0x00404571, 0x00444A77, 0x00494F7F, 0x00505484, 0x005B618F, 0x00636A98, 0x00656A9A, 0x006A70A0, 0x006E76A5, 0x006572A0, 0x006778A3, 0x006674A0, 0x005E6B97, 0x0059618E, 0x00595C89, 0x00696791, 0x0068648E, 0x0063618C, 
        0x005D5D89, 0x00595986, 0x005F5F89, 0x0266678E, 0x046B6D92, 0x066D6F92, 0x08747698, 0x0B5C5B82, 0x0E6B658B, 0x116D678E, 0x14736F93, 0x17737296, 0x1A6C6D91, 0x1E65678D, 0x2265688E, 0x265E658B, 0x2A5B678B, 0x2E5A658B, 0x32566488, 0x365A688B, 
        0x3A607091, 0x3F637492, 0x445D6F8D, 0x48586889, 0x4D555F84, 0x5253597F, 0x57495074, 0x5C333B60, 0x60707896, 0x65737D9E, 0x6A6F7C9F, 0x7065709C, 0x76595D94, 0x7A4E5487, 0x7F73799B, 0x849FA5B8, 0x8A9CA4B1, 0x8F9EA7AE, 0x949FA8AB, 0x949FA8AB,
  0x97A9ADAD, 0x92A7AEB3, 0x8D99A2AD, 0x88404A62, 0x8352587F, 0x7D4A5285, 0x783F477D, 0x742F356F, 0x6E1D2660, 0x691E285D, 0x643C4972, 0x5F576483, 0x5A546181, 0x56556184, 0x51546084, 0x4C535D82, 0x47556085, 0x42535C83, 0x3E515C85, 0x3A525B86, 0x35545E89, 
        0x314E5C86, 0x2D535E88, 0x29505B86, 0x2649537F, 0x214A537F, 0x1E4B527F, 0x1B4C517E, 0x174F5380, 0x14545783, 0x10535582, 0x0E565985, 0x0B5A5C88, 0x08575A86, 0x06595B87, 0x0460628D, 0x02666991, 0x0062668F, 0x005A5D88, 0x004F527F, 0x00494C7A, 
        0x00464A76, 0x00474B77, 0x00454976, 0x00464A7B, 0x004A4E82, 0x00535689, 0x005C6092, 0x00616697, 0x00666B9C, 0x006D73A2, 0x006D74A4, 0x006B77A5, 0x006474A1, 0x0063709E, 0x005B6795, 0x005C6392, 0x00545686, 0x005B5987, 0x00635E8A, 0x00696891, 
        0x0062658D, 0x005C6089, 0x015E618B, 0x03636790, 0x056B6D96, 0x0773749C, 0x0A7779A1, 0x0C74749D, 0x0F7E7AA3, 0x127B78A0, 0x157A789F, 0x18707298, 0x1C696C93, 0x20686D93, 0x2364698F, 0x275D658D, 0x2B5B678D, 0x2F606C92, 0x33617093, 0x375F6F92, 
        0x3C5C6D90, 0x405F7393, 0x455A708F, 0x4A5B6A8D, 0x4E576087, 0x534E557C, 0x584C5276, 0x5C4A5176, 0x627F86A5, 0x677983A3, 0x6C6C7A9F, 0x71626B9B, 0x7651558D, 0x7B626894, 0x808288A6, 0x859CA5B5, 0x8B9BA4AF, 0x8F9CA5AA, 0x949DA4A8, 0x949DA4A8,
  0x98AAB1AF, 0x93A7AEB1, 0x8EA8AFB6, 0x88485366, 0x84596184, 0x7F555B8B, 0x79444C7F, 0x752F3570, 0x6F212663, 0x6A272F64, 0x66404C77, 0x60566484, 0x5C515D7F, 0x56556085, 0x52535F84, 0x4D525E84, 0x48576288, 0x44545F88, 0x3F505984, 0x3B515C87, 0x3656628B, 
        0x3256638D, 0x2E525F89, 0x2A4D5684, 0x274D5684, 0x22525A87, 0x1F535A86, 0x1B565D88, 0x18585D8A, 0x15555887, 0x12535684, 0x0F545986, 0x0D5B5E8B, 0x0A5D608E, 0x075A5D8B, 0x05636892, 0x03696F97, 0x015C658D, 0x00515883, 0x004D5280, 0x004D5180, 
        0x004E5080, 0x004C4E7E, 0x00494C7C, 0x00484A7F, 0x004F5289, 0x0056588E, 0x005A5D92, 0x005F6497, 0x006A6EA0, 0x006E74A4, 0x00676FA0, 0x006F79A7, 0x006C76A5, 0x006973A1, 0x00626B99, 0x005D6392, 0x00595B8B, 0x00595A88, 0x005D5C88, 0x00696B92, 
        0x00686D91, 0x01696D91, 0x02676B92, 0x04666992, 0x06646891, 0x09646593, 0x0B686995, 0x0E6A6B97, 0x116F709C, 0x1371739D, 0x1671729C, 0x1A6D729A, 0x1D686C94, 0x21656A93, 0x25636992, 0x285E6791, 0x2C606C93, 0x30677398, 0x34616F94, 0x395D6C90, 
        0x3D5B6C90, 0x415B6D90, 0x465A6E8F, 0x4A56678A, 0x4F576085, 0x5552587F, 0x594E547A, 0x5E3F436D, 0x635C638A, 0x686E789D, 0x6E717EA6, 0x726F76A5, 0x775D6397, 0x7C6E749B, 0x81959BB1, 0x869DA5B4, 0x8B9BA6AD, 0x909EA7AB, 0x959EA8AA, 0x959EA8AA,
  0x99ACB1AF, 0x94A6ADAD, 0x8FACB3BA, 0x8A545D70, 0x854F5979, 0x80505C86, 0x7B3F497B, 0x7528316C, 0x701A235E, 0x6C333E72, 0x673F4C76, 0x61566584, 0x5D515F80, 0x58566185, 0x53525E83, 0x4E535F85, 0x4A566089, 0x46545E87, 0x40525D86, 0x3C555E89, 0x3859628E, 
        0x34555F8A, 0x30525D89, 0x2C515D8A, 0x28545F8B, 0x2458618D, 0x2057628E, 0x1D5B6490, 0x1A5F6793, 0x175B628F, 0x135C6290, 0x115E6392, 0x0E5E6391, 0x0C5E6492, 0x095B6090, 0x075A5F8F, 0x055A628F, 0x03515C88, 0x01505885, 0x00535987, 0x00545788, 
        0x004F5084, 0x0048497F, 0x00494880, 0x004B4A84, 0x004E4F8A, 0x0053548D, 0x0053568E, 0x00595D94, 0x00676B9E, 0x00656B9E, 0x005E6599, 0x006F75A6, 0x007076A6, 0x006B71A1, 0x005F6596, 0x005A6091, 0x005A5F8E, 0x005A5F8D, 0x00585D89, 0x00656990, 
        0x006C7092, 0x02727597, 0x04727598, 0x066F7195, 0x086E7097, 0x0A6E7098, 0x0D6B6C96, 0x0F606491, 0x125F6792, 0x15676E97, 0x18686E97, 0x1B666C95, 0x1F646B94, 0x22656A95, 0x26646B94, 0x2A616993, 0x2E646F97, 0x32687098, 0x36616D94, 0x3A5C6B91, 
        0x3E647497, 0x435B6D90, 0x475D6F92, 0x4D55648A, 0x51596187, 0x56585E85, 0x5A595D82, 0x60434873, 0x65575E88, 0x696C759E, 0x6E757EA9, 0x737279A9, 0x7863679A, 0x7D757DA0, 0x829DA3B7, 0x879AA3AD, 0x8D9CA7AB, 0x929EAAAC, 0x969DA6A9, 0x969DA6A9,
  0x9AABB0B0, 0x95A5AFAF, 0x90ABB4B9, 0x8B6B7485, 0x86495671, 0x814C5A83, 0x7C3C4778, 0x7729346A, 0x721E2963, 0x6D455180, 0x69394971, 0x64556783, 0x5E566584, 0x5A545F85, 0x54515C81, 0x50525E85, 0x4B57618A, 0x47545D87, 0x42545C87, 0x3E59638D, 0x395D6590, 
        0x355A6390, 0x3258618F, 0x2E576491, 0x2956618F, 0x26586391, 0x22586490, 0x1F57628F, 0x1B586290, 0x185A6090, 0x155C6392, 0x12616795, 0x105B6291, 0x0D5D6393, 0x0B596090, 0x08545B8D, 0x06545D8C, 0x05545F8D, 0x0358608F, 0x01575D8E, 0x0056598D, 
        0x004E4E86, 0x0044437E, 0x004C4884, 0x004F4D89, 0x004F4F8C, 0x0052528E, 0x0053548F, 0x005A5E95, 0x00676B9E, 0x006A6FA2, 0x00676EA1, 0x007679AA, 0x007C7DAC, 0x007576A7, 0x00646799, 0x005C6193, 0x0057608F, 0x0058628E, 0x0056618C, 0x0062688E, 
        0x02686A8D, 0x04727395, 0x05757799, 0x08737497, 0x0A737397, 0x0C757599, 0x0E757499, 0x116B7196, 0x14647095, 0x17677297, 0x1A687299, 0x1D687198, 0x206B739B, 0x246D759D, 0x276B729C, 0x2B686F99, 0x2F6A7099, 0x336A709B, 0x386A739A, 0x3C656F98, 
        0x40657197, 0x44647095, 0x4A5B6990, 0x4E59648D, 0x52535C84, 0x57595D84, 0x5C63668D, 0x6150537D, 0x65595F8A, 0x6B6A719E, 0x6F7881AD, 0x746F76A8, 0x7A676C9E, 0x7E9197B7, 0x839FA8B8, 0x889CA4AD, 0x8D9CA7A9, 0x929CA5A7, 0x989EA7AA, 0x989EA7AA,
  0x9BAAAFAF, 0x96A6AEB0, 0x91AAAFB6, 0x8C727B89, 0x88424D64, 0x82535D7E, 0x7E3F4874, 0x782B366B, 0x73243167, 0x6E4D5B88, 0x6A384B74, 0x65506382, 0x605B6888, 0x5C5A6287, 0x56555E84, 0x51565D84, 0x4D5A6189, 0x48575E88, 0x45565E89, 0x3F58608A, 0x3C58618D, 
        0x37565F8E, 0x33555F8E, 0x2F56608F, 0x2B586292, 0x28596493, 0x255A6494, 0x21576291, 0x1D5A5F90, 0x1A595B8E, 0x175A5C8F, 0x145C6192, 0x11595E91, 0x0F5A6093, 0x0D596094, 0x0A586193, 0x085A6796, 0x06576493, 0x04556091, 0x03535D8E, 0x0151578A, 
        0x004D5086, 0x00494981, 0x004F4E85, 0x00505289, 0x004D518B, 0x0052578F, 0x00545992, 0x00585F95, 0x0061679B, 0x006A70A3, 0x006D73A5, 0x00777BAB, 0x007D7EAD, 0x007576A7, 0x00626699, 0x00585F91, 0x00535D8E, 0x00525E8C, 0x0157648F, 0x02606A94, 
        0x04616892, 0x05696E95, 0x076D7399, 0x0973779B, 0x0B737799, 0x0E737798, 0x10747899, 0x13757B9C, 0x166F769A, 0x196E759B, 0x1C6E769C, 0x1F6E779D, 0x226D759C, 0x266A729A, 0x2A69729A, 0x2E6C739C, 0x316B6F98, 0x356B7299, 0x39676F97, 0x3D666E96, 
        0x42616C96, 0x46657098, 0x4A586490, 0x4F56608A, 0x54515981, 0x58565B84, 0x5E6B7197, 0x62555988, 0x675A5F8F, 0x6C6970A0, 0x717D84B3, 0x766B71A1, 0x7B686E98, 0x809AA2BA, 0x859CA7B1, 0x8A9CA7A9, 0x8F9EAAA7, 0x949FA8A8, 0x99A0A7AA, 0x99A0A7AA,
  0x9DABB3B3, 0x98AAAFB1, 0x93ACB3B8, 0x8E828B94, 0x89454D63, 0x84595F7E, 0x7F454B75, 0x7A2F3B6C, 0x75192A61, 0x70455785, 0x6B3D507B, 0x66516184, 0x615A6587, 0x5D5E6287, 0x585B6185, 0x535A6086, 0x4F595F87, 0x4A565D85, 0x46565E87, 0x4158618B, 0x3D57628D, 
        0x3A5A6493, 0x36596392, 0x31596292, 0x2D5F6697, 0x295C6595, 0x26575F93, 0x225A6296, 0x1F626497, 0x1C615E93, 0x195E5B92, 0x165E5D94, 0x135A5C93, 0x115A6196, 0x0E5D6598, 0x0C5A6397, 0x0A5A6898, 0x08566796, 0x06566393, 0x05556091, 0x034F588A, 
        0x024B5183, 0x014C4F81, 0x004F5082, 0x004E5386, 0x00454E84, 0x004E578C, 0x00555E92, 0x005C6598, 0x00646B9E, 0x006970A2, 0x006D73A5, 0x00757AAA, 0x007579A8, 0x006D71A2, 0x005F6597, 0x00555D91, 0x01545E8F, 0x01535F8E, 0x035A6794, 0x045F6C9A, 
        0x065F6B9B, 0x075E6A97, 0x09606B98, 0x0B656F98, 0x0D6A7298, 0x106F7799, 0x12707799, 0x15787EA2, 0x1875779F, 0x1A71759D, 0x1E757AA1, 0x217479A0, 0x247178A0, 0x286D769E, 0x2B69739A, 0x2F6C739A, 0x336C749C, 0x377179A0, 0x3B666F98, 0x3F636D96, 
        0x43626D98, 0x48646F9A, 0x4C5D6995, 0x51566089, 0x56545B82, 0x5A5C628A, 0x5F777DA3, 0x64585F90, 0x69585B92, 0x6D666AA0, 0x737B7FB2, 0x77616695, 0x7C787E9F, 0x81A1A9B9, 0x869DA8AC, 0x8B9DA8A6, 0x90A0ABA4, 0x95A3AAA8, 0x9AA3A8A8, 0x9AA3A8A8,
  0x9EA7AFAF, 0x99A7ACAF, 0x94ABB2B7, 0x8F91989E, 0x8A3A435D, 0x86515A7B, 0x814A547F, 0x7B344175, 0x771D2B64, 0x7227366D, 0x6D495582, 0x68525C84, 0x645D6589, 0x5F5D6287, 0x5A5A6185, 0x555A6087, 0x51596087, 0x4D555E86, 0x48576188, 0x43576289, 0x3F545F8A, 
        0x3C586191, 0x375B6493, 0x335A6292, 0x2F5C6494, 0x2C5D6697, 0x285A6395, 0x25596295, 0x21606398, 0x1E646098, 0x1B615E98, 0x18616097, 0x16616298, 0x1361679A, 0x11626C9C, 0x0E626C9A, 0x0C5E6B99, 0x0A596696, 0x08586494, 0x07576191, 0x05515A8B, 
        0x04505687, 0x03525486, 0x024F5182, 0x014D5284, 0x01454D82, 0x004D5489, 0x00545B8F, 0x005C6396, 0x00656B9D, 0x006A6FA1, 0x007075A6, 0x007679A9, 0x007073A4, 0x00696C9E, 0x00606697, 0x01565E90, 0x02545D8E, 0x03596392, 0x055C6895, 0x065D6997, 
        0x08616C9B, 0x09626D9A, 0x0B626B99, 0x0D636B99, 0x10616795, 0x12676E99, 0x14676E98, 0x1771749F, 0x1A71749F, 0x1D70739F, 0x206F749F, 0x236D739E, 0x266F75A0, 0x2A6C749F, 0x2D68709D, 0x316C719E, 0x356D71A0, 0x396E74A1, 0x3D636A97, 0x41616997, 
        0x465F6996, 0x4A5F6A97, 0x4E5C6995, 0x53555E89, 0x57515980, 0x5C62688F, 0x6170789D, 0x665B6192, 0x6A5E6396, 0x6F666BA1, 0x747A7EB1, 0x7953598A, 0x7E8991AD, 0x83A4AABA, 0x889CA6AB, 0x8DA0ABA9, 0x92A0ACA5, 0x97A4ABA6, 0x9CA4A9A9, 0x9CA4A9A9,
  0xA0A8AEAE, 0x9BA8ADAF, 0x96ABB0B5, 0x919AA1A8, 0x8C3D4861, 0x87435078, 0x83475481, 0x7D445085, 0x78343F7A, 0x731B2664, 0x6F333C71, 0x6A525783, 0x6563678C, 0x615E6588, 0x5C5A6086, 0x57575D83, 0x53555D85, 0x4E545F85, 0x4A566289, 0x4557628B, 0x41545F8C, 
        0x3D5A6392, 0x395D6794, 0x355D6695, 0x315B6394, 0x2E5B6296, 0x2A5B6597, 0x27596195, 0x2460629A, 0x2065629E, 0x1E66649F, 0x1A6A6AA0, 0x18676A9F, 0x15656A9C, 0x13656F9D, 0x11646F9C, 0x0E626E9A, 0x0D5D6797, 0x0B5B6494, 0x09586192, 0x07545B8C, 
        0x06535889, 0x05515586, 0x044D4F81, 0x034C5083, 0x02474F82, 0x0252588B, 0x01545A8D, 0x015B6093, 0x00676C9D, 0x006A6EA0, 0x016C70A1, 0x017073A3, 0x017071A1, 0x026B6D9E, 0x02626697, 0x03575D90, 0x04515A8C, 0x055B6493, 0x07606B96, 0x085F6A97, 
        0x0A636D9A, 0x0C646D9C, 0x0E6A71A0, 0x106C73A2, 0x12676C9E, 0x14696D9F, 0x1666699C, 0x19676A9C, 0x1C6A6B9D, 0x1F6B6D9E, 0x22696D9E, 0x25676B9C, 0x28696E9F, 0x2C686F9F, 0x2F67709F, 0x337174A6, 0x376F71A6, 0x3B6F72A6, 0x406A6EA0, 0x4369709D, 
        0x47616A97, 0x4C5F6A95, 0x505B6892, 0x55556188, 0x59555E83, 0x5F6F759A, 0x63686E97, 0x68575E8D, 0x6C5B6094, 0x71676DA1, 0x767A80AE, 0x7B4D5487, 0x809A9EB6, 0x85A0A9B5, 0x8A9CA7AB, 0x8E9FABA6, 0x93A0ACA7, 0x98A0AAA7, 0x9DA3A9AB, 0x9DA3A9AB,
  0xA2A9AFAF, 0x9CA7AEAE, 0x97A9ADB2, 0x93A5ACB3, 0x8E45516C, 0x89404D78, 0x84445282, 0x7F4B578B, 0x7A444E87, 0x75313A75, 0x711A225D, 0x6C4F5381, 0x6762678D, 0x625D6688, 0x5E5A6186, 0x59555D83, 0x55545D84, 0x50525E83, 0x4C536088, 0x48545F89, 0x43535E8B, 
        0x3F576191, 0x3B596292, 0x38596293, 0x34586092, 0x30586194, 0x2C586094, 0x29596194, 0x2661649C, 0x236564A1, 0x206A6AA4, 0x1D6D6EA5, 0x1A6A70A3, 0x18676F9F, 0x15636D9B, 0x13626E9A, 0x11636D9A, 0x0F646C9A, 0x0D5F6697, 0x0B5B6292, 0x0A585E8F, 
        0x09535788, 0x084F5384, 0x06474B7E, 0x054B5083, 0x044A5285, 0x04545A8C, 0x03555B8E, 0x03585D90, 0x035E6395, 0x03696D9E, 0x036F72A2, 0x037274A3, 0x046E6E9F, 0x046D6D9E, 0x05616396, 0x06595D90, 0x07535A8C, 0x085B6494, 0x09646E9A, 0x0B646D9A, 
        0x0C666D9C, 0x0E696F9E, 0x106C71A2, 0x126F74A6, 0x14676EA3, 0x176669A1, 0x196466A0, 0x1C6869A1, 0x1E6A6BA0, 0x21676A9F, 0x25696EA1, 0x286B70A4, 0x2B676EA2, 0x2F676FA2, 0x326A72A4, 0x366D70A6, 0x396F6EA7, 0x3D6E6FA6, 0x41686CA0, 0x466970A0, 
        0x4A646E9A, 0x4E606D95, 0x525E6B91, 0x57566287, 0x5C545C83, 0x607B81A3, 0x655C638D, 0x6A4E5787, 0x6E575C8F, 0x7362679A, 0x787278A7, 0x7D505687, 0x82A3A7BB, 0x869FA8B4, 0x8B9FA8AA, 0x90A0A9A7, 0x95A0ACA5, 0x9AA1ABA6, 0x9FA1A9A9, 0x9FA1A9A9,
  0xA3A8AEAE, 0x9EA5ACAF, 0x99A7AFB4, 0x94ABB0B7, 0x90525D77, 0x8B434E78, 0x864B5884, 0x81525C8F, 0x7C4B578B, 0x77414A82, 0x732D366D, 0x6E4B527E, 0x6962698D, 0x655C6488, 0x60586086, 0x5B535E83, 0x58525E84, 0x53525E85, 0x4E526087, 0x4A526089, 0x46525E8A, 
        0x42545D8E, 0x3E555F8E, 0x3A576090, 0x36596293, 0x335F6798, 0x2F5D6598, 0x2C606899, 0x28666BA1, 0x256668A2, 0x226A6DA6, 0x206C70A7, 0x1D686DA3, 0x1A676D9F, 0x18666F9F, 0x16656F9C, 0x13676E9C, 0x11696E9C, 0x10646797, 0x0E5E6294, 0x0C5C6090, 
        0x0B535688, 0x0A494E80, 0x09414679, 0x084B5082, 0x074C5284, 0x06515788, 0x0654588A, 0x065B5F91, 0x05606495, 0x05696C9C, 0x056E71A1, 0x067272A3, 0x066B6A9D, 0x076B6A9C, 0x075F6194, 0x085D6193, 0x0A585D8F, 0x0B596090, 0x0C636C98, 0x0D696F9D, 
        0x0F6D71A1, 0x116D71A2, 0x126F73A4, 0x147276A9, 0x176F73A8, 0x196A6FA6, 0x1C6A6EA8, 0x1E6D71A7, 0x216D6FA4, 0x24666AA0, 0x2763679F, 0x2A656CA1, 0x2D646BA0, 0x31676EA2, 0x346A73A6, 0x386A6EA5, 0x3C6F6FA7, 0x406E6FA6, 0x446A6CA0, 0x496A709F, 
        0x4C646E99, 0x505E6C92, 0x555B6A90, 0x59546086, 0x5E5A6087, 0x6271769B, 0x67464E7B, 0x6C465180, 0x705C6191, 0x75636A9A, 0x7A616A9A, 0x7F636993, 0x83A6AABE, 0x889CA2AF, 0x8D9EA9AB, 0x92A0ACA7, 0x97A1ABA6, 0x9B9EAAA5, 0xA0A0A8AB, 0xA0A0A8AB,
  0xA5A9AFAF, 0xA0A3ABAE, 0x9CA7ACB1, 0x96A6AEB5, 0x916A7185, 0x8D454E73, 0x88535E86, 0x835C6893, 0x7E505C8D, 0x7A4E5B8B, 0x75404D7B, 0x7047537C, 0x6C5D678C, 0x675B6588, 0x62525D83, 0x5E525D83, 0x59515E85, 0x55526187, 0x51536189, 0x4C536389, 0x48535F8C, 
        0x44515B8C, 0x40525D8C, 0x3D596292, 0x3A5A6294, 0x365D6697, 0x325F6899, 0x2E606899, 0x2B666DA0, 0x28696DA5, 0x256A6FA5, 0x22696FA5, 0x1F676DA3, 0x1D676CA1, 0x1B686FA2, 0x18686FA1, 0x166D70A1, 0x1470709E, 0x126B6B9B, 0x11676899, 0x0F5E6192, 
        0x0E4C5083, 0x0C404578, 0x0B3D4276, 0x0B4B5082, 0x0A4A5082, 0x09535788, 0x09585B8D, 0x085E6092, 0x08626596, 0x086A6D9B, 0x096E709E, 0x087171A1, 0x096D6B9D, 0x09686799, 0x0A656497, 0x0B5F6092, 0x0C595C8E, 0x0D585E8E, 0x0F646C98, 0x106F73A2, 
        0x127172A4, 0x136F72A3, 0x157073A5, 0x177377A8, 0x197076A9, 0x1C7176AB, 0x1F7177AA, 0x217075A8, 0x246F72A5, 0x26656B9F, 0x2961689D, 0x2D646B9F, 0x3062699E, 0x34666FA2, 0x376A74A6, 0x3B6D72A5, 0x3E7070A5, 0x426B6FA0, 0x46666C9C, 0x4A666D9B, 
        0x4F647098, 0x53616F95, 0x575A698F, 0x5C5A658A, 0x605B6188, 0x644E557F, 0x69515884, 0x6E59628D, 0x735C6491, 0x776A729D, 0x7C555F8F, 0x81757B9F, 0x85A3A5B7, 0x8AA0A7AF, 0x90A2ABAB, 0x949FABA6, 0x99A0ACA5, 0x9D9EA9A6, 0xA29EA9AC, 0xA29EA9AC,
  0xA6A8AEAE, 0xA2A7ACAF, 0x9DA6ABB0, 0x98A3AAB1, 0x948A91A1, 0x8F484F71, 0x8A5D6388, 0x8557628E, 0x8050608E, 0x7C495987, 0x773D507B, 0x733F5178, 0x6E5B698C, 0x695A6488, 0x65545E84, 0x60515E83, 0x5D515F85, 0x58505F85, 0x53516088, 0x4F526188, 0x4B535E8B, 
        0x47545D8F, 0x43566190, 0x3F596392, 0x3C5B6294, 0x39626A9A, 0x35676EA0, 0x31636B9C, 0x2E646C9F, 0x2B676EA4, 0x286970A5, 0x25666DA2, 0x236A70A6, 0x206A70A6, 0x1D696EA4, 0x1B6B71A6, 0x197173A5, 0x17706F9E, 0x156A6A9A, 0x13616292, 0x124F5185, 
        0x1042457A, 0x0F404478, 0x0E3F4377, 0x0D4C5083, 0x0C494E7F, 0x0C535788, 0x0B595D8D, 0x0B5D6091, 0x0B626595, 0x0B6B6D9C, 0x0B6D709E, 0x0B706F9F, 0x0B6F6D9F, 0x0C686699, 0x0D666598, 0x0E5B5C8F, 0x0F5A5D90, 0x11575D8E, 0x115F6594, 0x136D70A0, 
        0x147373A5, 0x167375A6, 0x187479A9, 0x1A757BAA, 0x1C737AAA, 0x1E747CAA, 0x21747CAB, 0x24757CAB, 0x26757AA9, 0x2A6F77A7, 0x2D6F75A6, 0x2F7077A7, 0x336771A2, 0x366670A1, 0x3A6975A5, 0x3D7075A6, 0x416D71A0, 0x45656C9A, 0x49646B98, 0x4D68709A, 
        0x5169749A, 0x55667299, 0x5A5C6B90, 0x5E566187, 0x63585E87, 0x6762678F, 0x6B6F769C, 0x70717AA0, 0x755D6793, 0x79667099, 0x7E56628F, 0x83959BB8, 0x88A4A9B8, 0x8DA0A7B0, 0x92A0AAAA, 0x969FABA4, 0x9BA0ADA5, 0x9F9CA9A6, 0xA49CAAAA, 0xA49CAAAA,
  0xA8A4ACAC, 0xA4A2AAAA, 0x9FA1A9AC, 0x9AA3ABAD, 0x969DA4AE, 0x914E5A73, 0x8C566382, 0x88515E86, 0x8354628D, 0x7E445482, 0x7A3D4A76, 0x75424F77, 0x70606A8E, 0x6C586288, 0x67535F85, 0x63515C84, 0x5F525F87, 0x5A4E5C84, 0x56516087, 0x52526288, 0x4E57638D, 
        0x4A5B6390, 0x465A6491, 0x425C6493, 0x3F5D6596, 0x3C626A9A, 0x38636B9D, 0x34646B9D, 0x31646D9F, 0x2E666FA2, 0x2B6970A3, 0x28696EA2, 0x256E71A5, 0x236F71A5, 0x207072A6, 0x1E7776AA, 0x1C7675A8, 0x1A6A6A9C, 0x19636395, 0x17525388, 0x153E4078, 
        0x1440447A, 0x1244497C, 0x1145497C, 0x104D5081, 0x104B4D81, 0x0F505486, 0x0F555C8C, 0x0E595F90, 0x0E626796, 0x0E6B6E9C, 0x0E6D6F9D, 0x0E7371A1, 0x0F7471A4, 0x0F6D6A9F, 0x10646298, 0x1157588F, 0x125C5F91, 0x13585D8E, 0x14535A8B, 0x16646A99, 
        0x177175A4, 0x19777CA9, 0x1B787EAA, 0x1D777DAA, 0x1F767DAA, 0x21747CA9, 0x24757CAB, 0x27767DAD, 0x297479AB, 0x2D7277A9, 0x307378A9, 0x32747AAB, 0x366D73A6, 0x396A70A3, 0x3D6C73A5, 0x407377A7, 0x456E73A1, 0x48666B9D, 0x4C696D9F, 0x506C72A0, 
        0x546C74A0, 0x5867709B, 0x5C5F6A92, 0x615B638C, 0x65595F88, 0x696C719A, 0x6E787CA4, 0x73888CB2, 0x77636A95, 0x7C646E97, 0x80606C94, 0x86A1A5BD, 0x8AA0A4B1, 0x8EA4ABAF, 0x93A0A9A9, 0x98A0ACA5, 0x9D9EABA3, 0xA19DAAA5, 0xA69DA8AB, 0xA69DA8AB,
  0xAAA2ABAB, 0xA6A3ABAB, 0xA1A2AAAA, 0x9CA4ACAC, 0x98A5AFB1, 0x936E7D8D, 0x8E4E5E79, 0x8A4E5F84, 0x854D5B87, 0x80465080, 0x7C3E4576, 0x77434873, 0x7360678D, 0x6E575E88, 0x6B566089, 0x66515B86, 0x61556088, 0x5E4F5B86, 0x59526089, 0x5552618A, 0x5157638A, 
        0x4D5C658D, 0x49626994, 0x455E6693, 0x415D6594, 0x3F61699A, 0x3A646C9D, 0x37646B9E, 0x34666EA0, 0x31696FA2, 0x2E6F73A5, 0x2B6F73A5, 0x287173A5, 0x267573A6, 0x237471A4, 0x227371A4, 0x1F6F6EA1, 0x1E5E6096, 0x1B55578C, 0x1A3B3E77, 0x183F427A, 
        0x174C4F82, 0x164F5383, 0x144E5481, 0x144F5383, 0x134D4E84, 0x124D5185, 0x12525A8C, 0x11586292, 0x12636B99, 0x11696E9C, 0x117475A2, 0x117E7DAC, 0x127571A7, 0x12706DA2, 0x13636199, 0x1456578E, 0x15585D8F, 0x16565C8D, 0x174E5686, 0x195E6794, 
        0x1B7077A3, 0x1D7A81AB, 0x1E7D84AE, 0x207D84AF, 0x227C83AE, 0x25777EAC, 0x27787EAD, 0x2A7A7FAE, 0x2D777BAD, 0x30787CAD, 0x33787BAD, 0x35767AAC, 0x397175AA, 0x3C7377AA, 0x407175A8, 0x437478A8, 0x476E72A4, 0x4B66699F, 0x4F696AA1, 0x536F6FA7, 
        0x576C6FA3, 0x5B696F9C, 0x5F5D6792, 0x6358608A, 0x685A5F88, 0x6C8386AD, 0x708789B2, 0x758B8DB4, 0x7A656996, 0x7E666E93, 0x83767F9D, 0x87A5A9BA, 0x8CA3A5B0, 0x91A4AAAF, 0x96A4ABA9, 0x9AA3ADA6, 0x9FA4AEA9, 0xA4A2ADAA, 0xA8A1ACAC, 0xA8A1ACAC,
  0xACA2A8A8, 0xA8A4ACAC, 0xA3A3ABAB, 0x9EA2AAAA, 0x9AA1A8AD, 0x958894A0, 0x9145556E, 0x8C4D5C80, 0x874C5985, 0x83474F81, 0x7E3F467A, 0x7A404274, 0x7660648D, 0x71576088, 0x6D576187, 0x68545F86, 0x6557638A, 0x60505E86, 0x5C546289, 0x58526187, 0x5456608A, 
        0x505B628C, 0x4C606993, 0x48616894, 0x45616998, 0x41646C9B, 0x3E68709F, 0x3B656E9F, 0x37666DA0, 0x346E70A2, 0x317376A7, 0x2E7276A7, 0x2C7274A5, 0x297274A6, 0x276D70A2, 0x2563679C, 0x225F6097, 0x2053548C, 0x1F4B4D85, 0x1E2D2F6B, 0x1C494D81, 
        0x1B535688, 0x19565B89, 0x18545A87, 0x17555788, 0x16525389, 0x16505389, 0x15535A8C, 0x15576190, 0x14646D99, 0x1470759E, 0x157F81A8, 0x158A88B3, 0x157773A8, 0x167370A5, 0x1767669B, 0x175B5C90, 0x18565B8D, 0x1A565D8E, 0x1B525989, 0x1C586091, 
        0x1E676D9E, 0x1F7276A4, 0x217579A8, 0x247D83AF, 0x267F84AF, 0x287B81AD, 0x2A797FAB, 0x2D7A80AE, 0x31797FAF, 0x33787EAF, 0x36737AAB, 0x39737AAB, 0x3C7177AA, 0x40757BAC, 0x437075A8, 0x467377A9, 0x4B6F72A6, 0x4E6769A2, 0x52696BA3, 0x566D70A5, 
        0x5A686D9E, 0x5E68709A, 0x62616A91, 0x66545C86, 0x6B596089, 0x6F8B8FB2, 0x738A8CB2, 0x787F81AC, 0x7C6C7099, 0x81565C85, 0x85949AB3, 0x8AA2A7B6, 0x8EA4A4AF, 0x93A2A7AC, 0x98A3AAA7, 0x9CA1ACA7, 0xA1A2ADA8, 0xA5A1ACA9, 0xAAA2ABAB, 0xAAA2ABAB,
  0xAEA0A9A9, 0xAAA2A8AB, 0xA5A1A9A9, 0xA1A2AAAA, 0x9C9FA9AC, 0x989EA7AF, 0x93546078, 0x8F4D5A7C, 0x8A475480, 0x86475182, 0x8144487F, 0x7D42427B, 0x78636590, 0x745B6489, 0x6F566188, 0x6C566086, 0x67566488, 0x63516085, 0x5F546288, 0x5B506086, 0x5759658C, 
        0x535E6491, 0x4F5D6691, 0x4C646B96, 0x48666F9A, 0x44676F9C, 0x4167709E, 0x3E65719E, 0x3A6B709F, 0x387171A3, 0x357676A7, 0x327577A8, 0x2F7176A5, 0x2C6A70A2, 0x2A62699B, 0x28586195, 0x2653588F, 0x2552538C, 0x22464880, 0x2032366F, 0x1F4D5085, 
        0x1D585B8C, 0x1C5B608D, 0x1B575D88, 0x1A58598B, 0x1A585790, 0x19555A8D, 0x19596091, 0x18606A97, 0x1869729C, 0x18737A9F, 0x188F92B3, 0x18A3A3C6, 0x198784B3, 0x197673A6, 0x1A69689B, 0x1B606295, 0x1C5A5F90, 0x1E5C6392, 0x1E5B6291, 0x205E6396, 
        0x21606499, 0x2366699D, 0x256E71A2, 0x28787BA9, 0x298287B1, 0x2B868AB2, 0x2E7E84AD, 0x317B81AD, 0x337D84B2, 0x36777FAF, 0x39717AAB, 0x3C737BAB, 0x3F7179AA, 0x43757CAC, 0x466E77A9, 0x4A7478AC, 0x4D7275AA, 0x516E6EA6, 0x556D70A5, 0x596E72A2, 
        0x5D69719B, 0x61656F95, 0x655E698D, 0x695A6489, 0x6D5A5F8B, 0x727F83AB, 0x767C7EA9, 0x7B797BA5, 0x7F6D7199, 0x83626A8B, 0x88A4ADBE, 0x8CA1A7B3, 0x91A4A6AD, 0x95A0A5AA, 0x9AA3ABA8, 0x9EA2ACA7, 0xA3A3ABA8, 0xA8A4ACA9, 0xACA2ABAB, 0xACA2ABAB,
  0xB0A1A7AA, 0xADA1A7AA, 0xA79EA7AA, 0xA3A0A8AB, 0x9FA1A6AC, 0x9A9CA6AD, 0x96657185, 0x914C5A75, 0x8D47567C, 0x88485380, 0x84444A7E, 0x8044467E, 0x7B646A94, 0x775B648A, 0x72586387, 0x6E556086, 0x6A576388, 0x66546186, 0x62546288, 0x5E526187, 0x5A5A648C, 
        0x57606690, 0x53606994, 0x4F646C97, 0x4B68729B, 0x4866709B, 0x4466709C, 0x4168739E, 0x3E6D72A1, 0x3B7272A3, 0x387475A5, 0x357376A6, 0x337176A6, 0x30666E9F, 0x2E5C6799, 0x2C525E93, 0x29545A91, 0x2854568E, 0x2642457E, 0x25333670, 0x234D4F84, 
        0x215A5E8E, 0x205F6590, 0x1F5B618C, 0x1E5A5C8D, 0x1E5B5B90, 0x1D595C90, 0x1C5B6392, 0x1C646E99, 0x1C717AA1, 0x1C7E84A8, 0x1C878AAC, 0x1C9797BB, 0x1C8A89B4, 0x1D7775A4, 0x1E7171A1, 0x1E646798, 0x1F5D6292, 0x21606795, 0x22616896, 0x23606597, 
        0x255C5F97, 0x265E6298, 0x28656A9C, 0x2A6E73A0, 0x2D797DA9, 0x2F8388B0, 0x318187AD, 0x347D83AD, 0x378187B5, 0x3A7B82B2, 0x3D757CAC, 0x3F767DAE, 0x43767DAE, 0x47757DAD, 0x497178AA, 0x4D7579AD, 0x517476AA, 0x547275A9, 0x587073A4, 0x5C6E759F, 
        0x606B749B, 0x64626C90, 0x685A6688, 0x6C565F86, 0x70595E89, 0x757579A3, 0x796E6E9B, 0x7D71739C, 0x8263688C, 0x877A819A, 0x8AA0A7B6, 0x8FA5AAB3, 0x93A5A9AE, 0x98A5AAAA, 0x9CA4A9A9, 0xA1A5ADAA, 0xA5A4ACA9, 0xAAA2ABA8, 0xAEA3A9A9, 0xAEA3A9A9,
  0xB3A0A7AA, 0xAEA0A6A9, 0xAA9FA5A8, 0xA5A1A6A9, 0xA19DA2A5, 0x9DA6ABB3, 0x988F99A5, 0x94556179, 0x8F414F71, 0x8C4F5C82, 0x87434C7A, 0x82373B70, 0x7E62688F, 0x7A576187, 0x75545F84, 0x71545E84, 0x6D556187, 0x69566489, 0x65546387, 0x62526288, 0x5E5A658C, 
        0x5A5F6790, 0x565E6791, 0x52656C97, 0x4F67719B, 0x4B646F98, 0x48646F9A, 0x4569749E, 0x426B739F, 0x3F6D71A1, 0x3C6B71A1, 0x396A709E, 0x366971A0, 0x34616B9B, 0x325D6898, 0x2F515D91, 0x2D585E93, 0x2B54558D, 0x29474982, 0x28333771, 0x2647497F, 
        0x25535787, 0x245D628E, 0x23616790, 0x225F618F, 0x215B5C8C, 0x20585E8D, 0x20606B95, 0x206B759E, 0x20747DA4, 0x1F8086AA, 0x208486AB, 0x208585AD, 0x208483AE, 0x217676A3, 0x217576A3, 0x22696D9B, 0x24646997, 0x24646A97, 0x26656C99, 0x27616699, 
        0x2963659B, 0x2A66679B, 0x2C66689A, 0x2F6B6F9F, 0x307174A2, 0x327A7EA8, 0x358488B0, 0x388287B3, 0x3A7E83B3, 0x3D7D83B2, 0x407B81B2, 0x43797EAF, 0x46797FAF, 0x49757CAD, 0x4D7076AA, 0x517479AC, 0x547475AB, 0x587376A7, 0x5B7278A4, 0x5F6D749B, 
        0x63667094, 0x67646F92, 0x6B606C8E, 0x6F565F88, 0x73575C8A, 0x78747AA3, 0x7C70729F, 0x806E7098, 0x85686C8E, 0x898A8EA4, 0x8DA5A9B4, 0x91A8AAB1, 0x96A6A9AB, 0x9AA6A8AB, 0x9FA6ACAC, 0xA3A6A8AB, 0xA8A4ACAC, 0xACA2ABAB, 0xB0A4AAAA, 0xB0A4AAAA,
  0xB6A0A7AB, 0xB19FA6A9, 0xAC9CA2A8, 0xA89EA4A9, 0xA4A2A8AD, 0xA09EA3AB, 0x9BA3AAB5, 0x968993A2, 0x92516179, 0x8E415170, 0x89364269, 0x853A426C, 0x815E658B, 0x7D586287, 0x79535F83, 0x75545F84, 0x71556286, 0x6C546486, 0x68526386, 0x65526487, 0x615A658D, 
        0x5D616793, 0x59616994, 0x56676F97, 0x52667198, 0x4F616C95, 0x4B616C95, 0x4866739B, 0x4569749E, 0x4269719F, 0x3F68719E, 0x3D666F9D, 0x3A626B99, 0x385A6394, 0x355D6797, 0x335A6494, 0x315D6296, 0x2F54558D, 0x2D494C83, 0x2C373A74, 0x2A353771, 
        0x29373B73, 0x28383E71, 0x273D4474, 0x26484D7A, 0x25535983, 0x2459618A, 0x24606A94, 0x2469749D, 0x236F77A1, 0x237478A2, 0x237576A1, 0x247676A1, 0x247E7EA8, 0x257979A4, 0x2571729E, 0x26686A99, 0x27666B99, 0x296C729E, 0x296B719E, 0x2C616496, 
        0x2C646698, 0x2E6A6B9D, 0x3067699A, 0x3266689B, 0x346B6E9E, 0x367375A3, 0x397A7AA8, 0x3B8082B0, 0x3E7E81B2, 0x418183B3, 0x447F82B2, 0x477A7DAF, 0x4A7B7EAF, 0x4D797CAD, 0x517477AA, 0x547778AB, 0x587376A7, 0x5B6F75A2, 0x5F7077A0, 0x636B7599, 
        0x67656F92, 0x6A636B91, 0x6E5C678C, 0x72545D87, 0x76555D8B, 0x7B7579A4, 0x7F7577A3, 0x8374769B, 0x87656587, 0x8CA1A3B3, 0x90A2A7AE, 0x94ABADB0, 0x99A7ACAC, 0x9DA3A9A9, 0xA1A5AAAA, 0xA6A5ABAB, 0xABA6ACAC, 0xAEA6A9AC, 0xB3A4AAAA, 0xB3A4AAAA,
  0xB79FA6A9, 0xB3A0A4AA, 0xAF9FA5AB, 0xABA0A6A9, 0xA6A3A5AB, 0xA2A4A7AC, 0x9D9EA6AE, 0x999DAAB1, 0x9594A3AC, 0x917F8C9F, 0x8C7B899C, 0x888D95AD, 0x84697392, 0x805A6488, 0x7C535F81, 0x78566185, 0x74546285, 0x70536387, 0x6C536486, 0x68546488, 0x645A658D, 
        0x605E6693, 0x5D626A95, 0x59646C95, 0x56646F96, 0x53616D95, 0x4F647097, 0x4C69759A, 0x4967749E, 0x4665739E, 0x4464709D, 0x40616D9A, 0x3E636D9B, 0x3B5E6898, 0x39606797, 0x38616898, 0x35616498, 0x335A5A92, 0x314E5187, 0x3042447D, 0x2E363A73, 
        0x2D2C3069, 0x2C20265C, 0x2B191F55, 0x2A232959, 0x29363D67, 0x28465179, 0x2859658C, 0x2866729A, 0x276C749E, 0x276C709E, 0x2870709F, 0x287474A1, 0x287E7EA7, 0x297B7BA5, 0x29666795, 0x2A525588, 0x2B484C80, 0x2C464E81, 0x2D5A6291, 0x2F5F6593, 
        0x30686B99, 0x326E709D, 0x346E709E, 0x36666799, 0x38636598, 0x3A7272A5, 0x3D7B7BAC, 0x3F7E7DAE, 0x428180B0, 0x45807EB0, 0x487D7BAD, 0x4A7B79AC, 0x4E7B78AC, 0x517A79AC, 0x547A78AB, 0x587678A8, 0x5B7277A5, 0x5F7077A0, 0x636E769C, 0x66687295, 
        0x6A636F91, 0x6E5E698F, 0x7258638C, 0x76535D89, 0x7A575D8D, 0x7E767AA3, 0x827476A1, 0x866D6D95, 0x8A757593, 0x8FAAACBA, 0x93A2A7AC, 0x97A9ABAD, 0x9BAAADAD, 0xA0A8ABAB, 0xA5A9ACAC, 0xA8A7ACAC, 0xADA7AAAD, 0xB1A6A9AC, 0xB5A5ACAC, 0xB5A5ACAC,
  0xB9A0A7AB, 0xB59EA1AC, 0xB19CA3A9, 0xAD9EA4AD, 0xA99FA5AB, 0xA59EA4A9, 0xA19DA5AA, 0x9D9CA6AB, 0x989EAAAF, 0x94A1ABB0, 0x8F9EAAB1, 0x8BA2ADB3, 0x87677287, 0x835A6081, 0x7F51597D, 0x7B545E83, 0x77576186, 0x73556286, 0x6F536386, 0x6B546386, 0x68596489, 
        0x645F6790, 0x61626B94, 0x5D626D95, 0x59606C94, 0x56616D94, 0x53647198, 0x5065749B, 0x4D65729B, 0x4A636E9C, 0x475F6B99, 0x445D6895, 0x42646D9A, 0x3F656E9A, 0x3D5E6795, 0x3B5C6492, 0x395E6393, 0x375F6090, 0x35555888, 0x344B4D7F, 0x32494C7D, 
        0x31434877, 0x30383D6C, 0x2F303665, 0x2E303662, 0x2D2C355E, 0x2D313A63, 0x2C485178, 0x2C61698D, 0x2C686F93, 0x2C697094, 0x2C696E94, 0x2C73769C, 0x2C7A7CA0, 0x2D6E7097, 0x2D494D7C, 0x2E33366C, 0x2F2D3067, 0x303B3E76, 0x32515588, 0x34606194, 
        0x34676599, 0x366B699D, 0x386E6CA0, 0x3A706EA2, 0x3C69699E, 0x3E7070A3, 0x417575A8, 0x437976AA, 0x46807BAF, 0x487D78AA, 0x4B7A77A9, 0x4E7D7BAB, 0x517776A6, 0x557878A6, 0x58787BA8, 0x5B7477A5, 0x5F7478A5, 0x627479A3, 0x666D759C, 0x6A687094, 
        0x6E626C91, 0x715E6990, 0x755A658D, 0x79515D88, 0x7D56608D, 0x8171799F, 0x85686E94, 0x89616588, 0x8E9699AD, 0x92A5A7B3, 0x96A9AEB0, 0x9AA6A8AB, 0x9EA7AAAA, 0xA3A8ABAB, 0xA7A7AAAA, 0xACA8AEAB, 0xAFA5ABA8, 0xB3A4AAA7, 0xB7A6A9A9, 0xB7A6A9A9,
  0xBC9BA3AB, 0xB89AA1AC, 0xB49CA3AD, 0xB09DA4AD, 0xAB9AA3A9, 0xA79CA7A7, 0xA39DA6A6, 0x9F9CA6A6, 0x9B9EA8A8, 0x979AA4A4, 0x939BA5A5, 0x8F9EA7A7, 0x8A757D88, 0x86626684, 0x825B5F82, 0x7E5C6083, 0x7A5D6389, 0x76596287, 0x73576488, 0x6F566688, 0x6B576789, 
        0x685C688B, 0x64626D93, 0x61626F95, 0x5D616D95, 0x5A627096, 0x57637198, 0x5463729C, 0x5166719D, 0x4E646D9B, 0x4B5E6695, 0x485D6696, 0x46616A96, 0x44616C98, 0x415B6792, 0x3F57638D, 0x3D5A628D, 0x3B595D89, 0x39575986, 0x38535782, 0x364E517E, 
        0x354B4F7A, 0x34434871, 0x333C426C, 0x323B4069, 0x32343A63, 0x312E365E, 0x30394167, 0x30535B7D, 0x305F6786, 0x30626987, 0x305F6786, 0x306B718F, 0x30676D8F, 0x315E6389, 0x32545882, 0x32555984, 0x334D507E, 0x34505283, 0x365A5B8D, 0x376A689A, 
        0x396B659E, 0x3A6E69A1, 0x3C6F6AA1, 0x3E7571A6, 0x416F6DA2, 0x426D6DA0, 0x457374A5, 0x477876A8, 0x4A7E79AC, 0x4C7E7BAB, 0x4F807EAB, 0x527F81AB, 0x557678A5, 0x587276A1, 0x5C757BA3, 0x5F7074A2, 0x627373A3, 0x667275A2, 0x6A6D729B, 0x6D687197, 
        0x71626B90, 0x755A658D, 0x7856638D, 0x7D526089, 0x80526288, 0x84637190, 0x88646F8D, 0x8C848B9F, 0x90ABB0BB, 0x95A5ACB1, 0x99A7ACAF, 0x9DA9ABAE, 0xA1A8AAAD, 0xA5A6ACAC, 0xA9A5ABA8, 0xAEA9AFAC, 0xB2A5ACA8, 0xB6A7AEAB, 0xBAA6ADA9, 0xBAA6ADA9,
  0xBE9CA4A8, 0xBA9AA6A9, 0xB69DA7AB, 0xB29BA5A8, 0xAE99A3A6, 0xAA9FA8A8, 0xA69DA8A8, 0xA29CA7A7, 0x9E9DA7A7, 0x9A9CA6A6, 0x969DA6A6, 0x929EAAAA, 0x8E7E8492, 0x8A565D79, 0x8658607E, 0x825D6386, 0x7E5A6087, 0x7A576187, 0x76556287, 0x73556488, 0x6F586488, 
        0x6B5B6589, 0x685F6B92, 0x65616E94, 0x61606F95, 0x5E657199, 0x5B64729B, 0x58617099, 0x55636F9A, 0x52626997, 0x4F5C6492, 0x4C5F6795, 0x4A626B97, 0x48626C96, 0x455B658F, 0x43555E89, 0x41585D8B, 0x3F545585, 0x3E555786, 0x3C575885, 0x3B505380, 
        0x3A515581, 0x384F537D, 0x37454976, 0x363F4270, 0x36383C69, 0x35323764, 0x35292E5B, 0x34353A65, 0x3441466E, 0x34444C70, 0x344C5278, 0x35545A7F, 0x354E547B, 0x36555A81, 0x3651557F, 0x37525681, 0x38555883, 0x395C5E8A, 0x3A5E608C, 0x3B686698, 
        0x3D6A669D, 0x3E706CA1, 0x406E6B9F, 0x427473A4, 0x447070A1, 0x466D6E9E, 0x4A7071A1, 0x4B7573A4, 0x4E7876A8, 0x517A77A9, 0x537C7CAA, 0x567C7EA9, 0x5A7679A4, 0x5C7178A0, 0x607178A0, 0x637073A1, 0x667072A2, 0x6A7275A0, 0x6D6B729A, 0x71667094, 
        0x75616C8F, 0x785C678D, 0x7C57628B, 0x804A5880, 0x845F698A, 0x888F97AF, 0x8C9FA3B7, 0x90A9AEBB, 0x94A4A8B2, 0x98A7AAAF, 0x9CA4A9A9, 0xA0ABAEB0, 0xA4A5A8AD, 0xA8A7A9AC, 0xACA5ABA8, 0xB0A4AAAA, 0xB4A6AAAA, 0xB9A7AEAE, 0xBCA7ABAB, 0xBCA7ABAB,
  0xC198A4A4, 0xBD9EA5A5, 0xB99CA7A7, 0xB59AA5A5, 0xB19CA6A6, 0xAD9EA7A7, 0xA99CA5A5, 0xA59EA6A6, 0xA19DA8A8, 0x9D9CA3A3, 0x999DA7A7, 0x959CA8A8, 0x918A919A, 0x8D565D76, 0x895A637F, 0x85626A89, 0x825B6188, 0x7E586087, 0x7A556185, 0x76536487, 0x7359658A, 
        0x6F5A668A, 0x6C5D698F, 0x685F6D92, 0x65616C94, 0x62647198, 0x5F65749B, 0x5C5F6E98, 0x595E6995, 0x56606694, 0x535D6494, 0x51606794, 0x4E616994, 0x4D5F6893, 0x4A5C638E, 0x48545D88, 0x46565B89, 0x44575789, 0x42555788, 0x40565787, 0x3F545785, 
        0x3E585987, 0x3D565785, 0x3C4F5180, 0x3B4C4F7F, 0x3A494A7B, 0x39464879, 0x3935396A, 0x39313766, 0x39313463, 0x39313763, 0x393A406C, 0x39424671, 0x39454874, 0x3A575B84, 0x3B555982, 0x3B555982, 0x3C5B5D87, 0x3D63668D, 0x3E63658D, 0x40696796, 
        0x4169659A, 0x436D699D, 0x456E6C9E, 0x477372A1, 0x496E709E, 0x4B6C6F9D, 0x4D6C6F9D, 0x4F70709F, 0x527875A6, 0x557878A6, 0x587879A5, 0x5A787CA6, 0x5E767CA5, 0x60717BA1, 0x647179A0, 0x677378A1, 0x6A7072A2, 0x6D7276A0, 0x716E749B, 0x74646D94, 
        0x78616B90, 0x7C5D688D, 0x8058648C, 0x8347547B, 0x87747A96, 0x8BAFB3C5, 0x8FA7ACB7, 0x93A7A9B3, 0x97A6A9AD, 0x9BAAADAD, 0x9FA6A9A9, 0xA3ABAEB1, 0xA7A7AAB0, 0xACA8ABB2, 0xB0A7ADAD, 0xB3A7AEAA, 0xB7A6A9A9, 0xBBA5ACAC, 0xBFA3ABAB, 0xBFA3ABAB,
  0xC39DA5A5, 0xC09DA5A5, 0xBC9BA7A7, 0xB89AA5A5, 0xB49FAAAA, 0xB09DA7A7, 0xAC9CA5A5, 0xA89BA7A7, 0xA49CA8A8, 0xA09BA6A6, 0x9C9AA4A4, 0x999DA7A7, 0x94939AA1, 0x905B6277, 0x8D5D667F, 0x89636C88, 0x855B6487, 0x81586087, 0x7E566287, 0x7A556387, 0x76596489, 
        0x735B658A, 0x705C698E, 0x6C5D6B91, 0x69606E95, 0x6666749A, 0x6368759C, 0x605E7098, 0x5D5C6995, 0x5A5D6793, 0x585C6491, 0x555E6691, 0x535A638E, 0x5058618B, 0x4E59618B, 0x4C566089, 0x4A555B87, 0x485A5A8C, 0x4759588B, 0x4559598B, 0x445C5B8D, 
        0x435A5A8C, 0x415C5B8C, 0x4057578A, 0x3F515386, 0x3F535487, 0x3E5B5B8D, 0x3E5B5B8B, 0x3D575988, 0x3E515384, 0x3D4E4F7F, 0x3D515383, 0x3D575A86, 0x3E595B89, 0x3E5D608B, 0x405D5F8A, 0x405B5F87, 0x4160648B, 0x4265698F, 0x43666A8F, 0x45696995, 
        0x466A6699, 0x486B689A, 0x496E6B9B, 0x4C7373A0, 0x4E6E709C, 0x4F6E719B, 0x526E719B, 0x546C6E9A, 0x566D6F9C, 0x596F729D, 0x5C7578A2, 0x5E747BA4, 0x62767EA5, 0x64747EA2, 0x676F7BA0, 0x6B737AA3, 0x6E7175A1, 0x717477A1, 0x7570779C, 0x78677094, 
        0x7C626C91, 0x7F596789, 0x83546289, 0x87455074, 0x8B787C92, 0x8FACB1BC, 0x92A3A7B1, 0x97A6ABAD, 0x9AA8ADAB, 0x9EAAACAC, 0xA2A9ACA9, 0xA6ABAEAE, 0xAAA5A8AE, 0xAEA6A9AC, 0xB2A5ACAC, 0xB6A7AEAB, 0xBAA9ADAD, 0xBEA8ACAC, 0xC2A7ABAB, 0xC2A7ABAB,
  0xC69CA5A5, 0xC29AA7A3, 0xBE9CA4A4, 0xBB9DA8A5, 0xB79FA9A9, 0xB39DA7A7, 0xAF9BA8A8, 0xAB9DA6A6, 0xA79CA7A7, 0xA39DA8A8, 0x9F9CA4A4, 0x9C9FA9A9, 0x989EA5AA, 0x945A6374, 0x905D677D, 0x8D626885, 0x895F678A, 0x85596487, 0x81546287, 0x7E566487, 0x7A596789, 
        0x775F688E, 0x745F6B90, 0x70616C93, 0x6D637197, 0x6A667499, 0x6765739B, 0x645D6D96, 0x615D6894, 0x5E636894, 0x5C656B97, 0x59646C95, 0x57606890, 0x555B648D, 0x53555E88, 0x51565E87, 0x4F595D8A, 0x4D5B5B8F, 0x4B57568B, 0x4A56558C, 0x485D5B90, 
        0x485F5E93, 0x465E5B92, 0x4559578E, 0x4458558E, 0x435E5B94, 0x436D6A9D, 0x426C6B9C, 0x42676597, 0x42676597, 0x42636394, 0x42646494, 0x42686897, 0x43696998, 0x43676795, 0x44686A95, 0x45686995, 0x4665688F, 0x476A6E93, 0x48666B8F, 0x49676993, 
        0x4B696896, 0x4C676695, 0x4E696997, 0x506C6E98, 0x526C719A, 0x546F749A, 0x566D739A, 0x586D729B, 0x5B6C6F99, 0x5E696E99, 0x607178A0, 0x63737DA3, 0x66747EA4, 0x69737FA3, 0x6C6E7A9F, 0x6F7178A1, 0x727375A0, 0x757377A0, 0x7972799D, 0x7C687295, 
        0x80646E92, 0x835A688B, 0x87566589, 0x8B464E6F, 0x8E9092A4, 0x92ACAEBA, 0x96A6ABB0, 0x9AA6ABAB, 0x9EAAACAA, 0xA1AAADAA, 0xA5A9ACAC, 0xAAABAEB1, 0xADA7AAB0, 0xB1A6ACAC, 0xB5A8AFAC, 0xB9ABAEAB, 0xBCA7ABAB, 0xC1A8ACAC, 0xC4A8ACAC, 0xC4A8ACAC,
  0xC898A6A6, 0xC59EA6A6, 0xC19CA4A4, 0xBE9CA8A4, 0xB99CA7A3, 0xB69DA7A7, 0xB29EA8A8, 0xAE9DA6A6, 0xAA9CA5A5, 0xA79EA7A7, 0xA39DA6A6, 0x9F9FA9A9, 0x9BA3AAAF, 0x975F6675, 0x945C667B, 0x905B6480, 0x8C5F6589, 0x89586185, 0x85515E85, 0x82556388, 0x7E586689, 
        0x7B5E6A8E, 0x785E698E, 0x74606B92, 0x72667399, 0x6F68769B, 0x6B67749C, 0x685E6E97, 0x655F6B96, 0x63656995, 0x61656A94, 0x5E616691, 0x5C5F658F, 0x59586089, 0x57515981, 0x55525882, 0x53545786, 0x52525088, 0x504C4B83, 0x4E4C4984, 0x4D4B4884, 
        0x4C504C8B, 0x4B53508D, 0x4A565490, 0x49625D98, 0x485E5A97, 0x4764609A, 0x47646099, 0x47615F97, 0x4767649A, 0x47646199, 0x47666397, 0x476B689E, 0x476E6BA0, 0x486F6C9F, 0x49706E9F, 0x4971719E, 0x4A636490, 0x4B6B6C95, 0x4C64698F, 0x4E676992, 
        0x4F676792, 0x51676693, 0x52686893, 0x54696E95, 0x576C7197, 0x58707699, 0x5A70759A, 0x5D71779B, 0x5F6A7097, 0x61606892, 0x646A729A, 0x676F799E, 0x6A707B9F, 0x6D717BA0, 0x70717EA1, 0x737279A3, 0x7671759F, 0x7972779F, 0x7D71799C, 0x806A7496, 
        0x84636F90, 0x875D6A8B, 0x8B59698C, 0x8E3F486C, 0x929EA0B1, 0x96A9ABB5, 0x99A7ACAF, 0x9DA3ABA9, 0xA1AAB0AD, 0xA5A6ACA9, 0xA8A9ACAC, 0xACA5ABAE, 0xB0A7AAAD, 0xB4AAADAD, 0xB8A8AFAC, 0xBBA8B0A8, 0xBFA7AFA7, 0xC3A5AAAA, 0xC6A5A9A9, 0xC6A5A9A9,
  0xCB9CA6A6, 0xC89DA6A6, 0xC49BA4A4, 0xC099A5A5, 0xBC9BA7A7, 0xB99CA7A7, 0xB59AA5A5, 0xB19CA6A6, 0xAE9DA6A6, 0xAA9CA5A5, 0xA69AA5A5, 0xA29CA7A7, 0x9FA4A9AE, 0x9B707787, 0x97586278, 0x945C6682, 0x90606789, 0x8D5B6488, 0x89546185, 0x86566488, 0x8259668A, 
        0x7F5D678D, 0x7C5B668B, 0x795F6C92, 0x7668759A, 0x7369769C, 0x706A799E, 0x6D64749C, 0x6A646F98, 0x67676C94, 0x65666C96, 0x62616690, 0x60585E88, 0x5E404874, 0x5C3C4370, 0x5A485079, 0x58424579, 0x563C3A78, 0x543D3A78, 0x533F3C7A, 0x523D3A7C, 
        0x503F3B7E, 0x4F423D81, 0x4E484285, 0x4D4B468A, 0x4D555091, 0x4C635F9A, 0x4C6D67A1, 0x4C6B67A0, 0x4B66629C, 0x4B646199, 0x4B66649B, 0x4C6B67A0, 0x4C6B66A3, 0x4C6D67A1, 0x4D6F6CA1, 0x4E7170A1, 0x4F73739E, 0x50696B95, 0x51676A93, 0x5363648F, 
        0x54686893, 0x55696993, 0x586A6B94, 0x596E6F95, 0x5B6F7499, 0x5D727899, 0x5F707798, 0x61727A9C, 0x646A7498, 0x67656F94, 0x696B759A, 0x6B6E7A9E, 0x6F717DA1, 0x717480A2, 0x747380A2, 0x77737BA2, 0x7A7276A0, 0x7D6F759C, 0x816F7799, 0x84677392, 
        0x87636E8E, 0x8B5E6B8C, 0x8F5A6A8C, 0x92454F72, 0x96A6A9BA, 0x99A5AAB4, 0x9DA6AEB0, 0xA0A3AEAB, 0xA4A5B0AA, 0xA8A7AFAC, 0xACA5ABAE, 0xAFA5ABAE, 0xB3A7AAAA, 0xB7A9ADAD, 0xBBA8B0A8, 0xBEA8B0A8, 0xC2ABB3AB, 0xC6A9B2A9, 0xC9A5AEA9, 0xC9A5AEA9,
  0xCD99A3A8, 0xCB9CA6A6, 0xC79AA3A8, 0xC39DA5AA, 0xBF9BA7A7, 0xBC9BA7A7, 0xB89AA5A8, 0xB59EA8A8, 0xB19FA9A9, 0xAD9EA7A7, 0xAA9CA8A8, 0xA69AA5A5, 0xA2A1A7AC, 0x9F848999, 0x9B595E75, 0x97626B84, 0x945F6687, 0x90596484, 0x8D505F81, 0x8A526382, 0x86586486, 
        0x835E6A8D, 0x805C688C, 0x7D606991, 0x7A69769A, 0x776A779D, 0x746D7AA1, 0x716B779F, 0x6E67719A, 0x6C697299, 0x696B7399, 0x6758628C, 0x654A5480, 0x63283263, 0x60192456, 0x5E293463, 0x5D282F67, 0x5B282969, 0x5932306F, 0x58393573, 0x57302869, 
        0x552D2567, 0x54342F6E, 0x533B3874, 0x53423C80, 0x52403682, 0x51433883, 0x515A5094, 0x506F66A3, 0x507269A5, 0x516E66A3, 0x506E66A2, 0x516E66A4, 0x516C61A3, 0x526961A1, 0x526B65A0, 0x5369649C, 0x547271A3, 0x556A699A, 0x5670709D, 0x576B6995, 
        0x596E6C97, 0x5A6A6A93, 0x5C6B6E95, 0x5D6D7195, 0x60717696, 0x61727897, 0x64747B96, 0x66747A98, 0x68707898, 0x6B6F7699, 0x6E70789A, 0x70757EA0, 0x727881A2, 0x757782A3, 0x78707D9F, 0x7B717B9E, 0x7E707A9D, 0x826E769B, 0x856A7598, 0x88687195, 
        0x8B606B8C, 0x8F616C8C, 0x925A6887, 0x9659657D, 0x99ACB1BB, 0x9DA3ABB3, 0xA0A3ABAE, 0xA4A5ADAD, 0xA8A4ACA9, 0xACA5AEAB, 0xAFA5ABAB, 0xB3A7AEAE, 0xB6ABAEAB, 0xBAA9B1AD, 0xBEA8B0AC, 0xC1A4ACA8, 0xC5A6AFAB, 0xC8A6AFAB, 0xCCA5AFAA, 0xCCA5AFAA,
  0xD09DA2A8, 0xCD99A3A8, 0xC997A5A5, 0xC69CA5A9, 0xC29AA3A7, 0xBF9BA3A7, 0xBB99A5A8, 0xB89DA5A8, 0xB49FAAAD, 0xB09DA4A7, 0xAD9BA7A7, 0xA99CA5A5, 0xA6A0A5AB, 0xA29699A7, 0x9F5F6479, 0x9B606882, 0x985D6585, 0x945C6887, 0x91556581, 0x8E536780, 0x8A5D6C88, 
        0x875D6787, 0x84596588, 0x81606D8F, 0x7E687497, 0x7C6C789D, 0x79707BA1, 0x766D78A1, 0x7369769C, 0x7169769B, 0x6E69759A, 0x6C647098, 0x695F6B93, 0x67475580, 0x65334070, 0x631B285C, 0x62111B55, 0x60131859, 0x5E1A1A5A, 0x5D251D5E, 0x5B180D4F, 
        0x5A140A49, 0x5916134E, 0x59181A52, 0x57241F62, 0x57281B6B, 0x56372B76, 0x563F337E, 0x554B3F87, 0x55554990, 0x5551468D, 0x5552468D, 0x5554458E, 0x56544690, 0x57594B92, 0x575A5193, 0x585B5393, 0x585C5893, 0x5A646198, 0x5B676499, 0x5C686595, 
        0x5D726F99, 0x5F706F98, 0x61727398, 0x626A6E91, 0x656B708F, 0x66707590, 0x68727890, 0x6B737A95, 0x6D74799A, 0x6F737A99, 0x72787F9E, 0x747C83A2, 0x777982A2, 0x7A7881A2, 0x7D737F9E, 0x80707C9C, 0x82707C9B, 0x866D799B, 0x89677499, 0x8C656E94, 
        0x8F5D688A, 0x93636C8B, 0x96545E7B, 0x997D8496, 0x9DABB3B8, 0xA1A5ADB2, 0xA4A5ADAD, 0xA7A4ADAD, 0xABA6AFAC, 0xAFA5B2AE, 0xB2A5AFAF, 0xB6ABAEAE, 0xBAADB1AD, 0xBDA9ADAD, 0xC1A8ACAC, 0xC4A8ACAC, 0xC8ABAFAF, 0xCCAAAFAF, 0xCEA6ABAB, 0xCEA6ABAB,
  0xD39CA2A7, 0xCF999FA4, 0xCC96A5A5, 0xC99BA5A9, 0xC599A2A6, 0xC29AA3A7, 0xBE9CA4A8, 0xBB9DA5A8, 0xB79FA6A9, 0xB49CA6AA, 0xB19CA6A6, 0xAD9BA7A7, 0xA99CA2A5, 0xA6A0A3AB, 0xA26A7080, 0x9F5F647C, 0x9C5C6480, 0x985B6585, 0x95566484, 0x92516484, 0x8E5C6989, 
        0x8B5B6689, 0x885C688B, 0x85626C90, 0x82667094, 0x7F697599, 0x7D6F7BA2, 0x7A727CA4, 0x787681A7, 0x75727DA1, 0x72667197, 0x70636E95, 0x6E5E6A91, 0x6C535F8A, 0x6A535F8A, 0x6844527F, 0x663A4577, 0x65333870, 0x632C2D68, 0x6238336E, 0x603B336E, 
        0x5F3A326D, 0x5E37326E, 0x5D302F69, 0x5D2A2567, 0x5C150C55, 0x5B150C56, 0x5B231A61, 0x5A31286D, 0x5A342B70, 0x5A32296E, 0x5B393074, 0x5B3E3378, 0x5B3A3077, 0x5B3C3178, 0x5C493F83, 0x5D4C4887, 0x5D464380, 0x5F4D4A87, 0x604C4986, 0x615E5B8F, 
        0x62645F90, 0x646C6A96, 0x6566668F, 0x68494D77, 0x69555A7F, 0x6B606786, 0x6D68718C, 0x6F6F7896, 0x716E7698, 0x746F7899, 0x777581A0, 0x797985A5, 0x7B7783A2, 0x7E7682A1, 0x81717F9F, 0x846B7A9B, 0x87707D9F, 0x8A70799E, 0x8D666F97, 0x90626B94, 
        0x93636A8F, 0x975F6689, 0x9A4B5576, 0x9E9FA5B4, 0xA1A8ADB5, 0xA4A5ADB0, 0xA8A4ACAC, 0xABA3AFAC, 0xAFA5AEAB, 0xB2A5AFAC, 0xB6A7AEAE, 0xB9A7AEAE, 0xBCABABAB, 0xC0A9A9A9, 0xC4A8ACAC, 0xC7A8ACAC, 0xCAA8ADA8, 0xCEA6ABAB, 0xD1A6ABAB, 0xD1A6ABAB,
  0xD69BA7A7, 0xD298A4A4, 0xCF99A4A4, 0xCB97A6A6, 0xC898A6A6, 0xC59EA6AB, 0xC29EA7AB, 0xBE9CA4A8, 0xBA9AA6A6, 0xB79BA6A6, 0xB49CA6A6, 0xB09DA7A7, 0xADA1A7A7, 0xA99FA5AB, 0xA6666F7D, 0xA363697F, 0x9F5F6A84, 0x9D5D6889, 0x995A668C, 0x96576589, 0x93596588, 
        0x8F566183, 0x8C566186, 0x8A616A8F, 0x87636E94, 0x84677399, 0x816F799F, 0x7E7480A5, 0x7C7A83A8, 0x7A727EA2, 0x776A759B, 0x7568739A, 0x73677298, 0x715B6790, 0x6F56638D, 0x6D4A5884, 0x6B495482, 0x69454A7C, 0x683A3C72, 0x66424077, 0x65433E78, 
        0x643F3B74, 0x633D3975, 0x623A3874, 0x62423D7B, 0x613E3678, 0x603C3476, 0x6030266B, 0x5F2F266C, 0x5F31296D, 0x5F1F165D, 0x5F191159, 0x60140C51, 0x60110B4E, 0x60160E53, 0x61211C5E, 0x62252264, 0x62333071, 0x643F3E7B, 0x65393876, 0x6635316D, 
        0x67353069, 0x69424075, 0x6A3F3F70, 0x6C26275B, 0x6E3B426E, 0x704C5379, 0x72616A8A, 0x74737E9D, 0x766F789C, 0x786E7A9C, 0x7B7583A4, 0x7D7985A4, 0x807684A4, 0x837283A1, 0x85707F9E, 0x886D799C, 0x8B717AA2, 0x8E70799F, 0x91656C96, 0x94636B93, 
        0x98626A8F, 0x9B5E6687, 0x9E5E6683, 0xA1AAB0BD, 0xA4A5AAB3, 0xA8A7ACB2, 0xABA6AFAF, 0xAEA6AFAC, 0xB2A8AFAF, 0xB6A7B1AE, 0xB9A7B2AE, 0xBCABAEAE, 0xC0A9ADAD, 0xC3AAAEAE, 0xC7ACACAC, 0xCAA8ADAD, 0xCEABB0B0, 0xD1ABB1B1, 0xD4A6B1AB, 0xD4A6B1AB,
  0xD89CA3A9, 0xD597A3A9, 0xD195A0A6, 0xCE96A6A6, 0xCB9CA6A6, 0xC89DA6AB, 0xC49BA4A8, 0xC19CA4A8, 0xBE9CA8A8, 0xBA9AA6A6, 0xB79BA6A6, 0xB49CA6A6, 0xB09AA7A4, 0xAD9EA4A7, 0xAA57636F, 0xA75F687C, 0xA3606684, 0xA05B6386, 0x9D5B628C, 0x9A58628A, 0x975A648B, 
        0x944C557E, 0x9149557C, 0x8E5E698D, 0x8B626D92, 0x886B759A, 0x856C779C, 0x83727FA1, 0x81737FA3, 0x7E6C789D, 0x7C6A769B, 0x7A657096, 0x77636E95, 0x755C678F, 0x7456628B, 0x724F5B87, 0x704E5983, 0x6F4F5482, 0x6D494C7D, 0x6B484B7F, 0x6A46467C, 
        0x6944427C, 0x68413E7A, 0x67423F7D, 0x674C4485, 0x664F4489, 0x65594F91, 0x6550458A, 0x64504489, 0x644D4188, 0x64483C83, 0x64504489, 0x65504685, 0x654D467F, 0x664A447C, 0x66403D77, 0x673C3873, 0x67383773, 0x69312F6E, 0x6A333372, 0x6B302B68, 
        0x6D403974, 0x6D504E82, 0x6F615F8F, 0x71626490, 0x73646993, 0x7459628B, 0x765B668B, 0x796A7599, 0x7B6C779C, 0x7D717DA0, 0x7F7783A5, 0x827A86A7, 0x857585A5, 0x877081A1, 0x8A6E809E, 0x8C707B9F, 0x8F717A9E, 0x926D749C, 0x95676E97, 0x98656A91, 
        0x9B63688C, 0x9F545C7C, 0xA27E839C, 0xA5ACAFBA, 0xA8A9A9B2, 0xACA8AEB2, 0xAFA8AEAE, 0xB2A8AFAF, 0xB6ABB1AE, 0xB9ABB2AE, 0xBCA7AEAE, 0xC0A9ADAD, 0xC3AAAAAE, 0xC6A9AEB2, 0xC9A5A9AE, 0xCDA8ADAD, 0xD0A8ADAD, 0xD3A7ADAD, 0xD7A5ABAB, 0xD7A5ABAB,
  0xDB9BA9A9, 0xD798A5A5, 0xD49AA6A6, 0xD19BA6A6, 0xCE9CA6AB, 0xCB9CA6AB, 0xC89DA6A6, 0xC59EA6AB, 0xC1A0A8AC, 0xBE9CA8A8, 0xBB9DA8A8, 0xB79FA9A9, 0xB49CAAA6, 0xB19CA6A6, 0xAD536069, 0xAA576075, 0xA7626884, 0xA45F6489, 0xA15E648C, 0x9E5B668D, 0x9B5E668E, 
        0x98566087, 0x95515D84, 0x925A668B, 0x8F616C93, 0x8D646F95, 0x8A637095, 0x886D7C9E, 0x857783A5, 0x836E7B9F, 0x806C789E, 0x7E667097, 0x7C647097, 0x7A5D6993, 0x7856638D, 0x7655608B, 0x75505A88, 0x73535986, 0x72525888, 0x71505588, 0x704C5085, 
        0x6E4B4D83, 0x6D47457F, 0x6C46417E, 0x6B4D4386, 0x6B4F418D, 0x6A554791, 0x6A534691, 0x6A5C4C96, 0x6A584993, 0x6A5C4C96, 0x6A61539B, 0x6A5E5593, 0x6A585288, 0x6B595289, 0x6B504D84, 0x6C48457E, 0x6D4C4A82, 0x6D4A4982, 0x6F4C4A84, 0x70575089, 
        0x7160598F, 0x736D6798, 0x74716F9D, 0x766D6F9C, 0x776A709B, 0x79687299, 0x7B6E779E, 0x7E707AA1, 0x7F757DA3, 0x827680A7, 0x847580A5, 0x877885A7, 0x897483A4, 0x8B6F819D, 0x8E6E7E9D, 0x91717C9D, 0x936E769B, 0x966A7198, 0x996B7098, 0x9C6B7195, 
        0x9F676F8C, 0xA2545D78, 0xA6A3A8B7, 0xA9A8ABB7, 0xACABAEB5, 0xAFABAEB2, 0xB2A8AFAF, 0xB6ABB1AE, 0xB9ABB2AE, 0xBCA7AEAB, 0xC0A9ADAD, 0xC3AAAEB2, 0xC6A9A9B2, 0xC9A9AEB3, 0xCDA8ADB2, 0xCFA9A9AF, 0xD3A7ADAD, 0xD6A7ADAD, 0xD9A7AEA7, 0xD9A7AEA7,
  0xDD9DA5A5, 0xDA97A5A5, 0xD798A5A5, 0xD49AA6A6, 0xD19BA6A6, 0xCE9CA6A6, 0xCB9CA6A6, 0xC79AA3A8, 0xC59EA6AB, 0xC19CA4A8, 0xBE9CA8A8, 0xBB9DA8A8, 0xB89DA8A8, 0xB4929FA3, 0xB2525F6D, 0xAE4E576D, 0xAB5D6782, 0xA85D6386, 0xA55D638A, 0xA25D658B, 0x9F5C648C, 
        0x9C5C668D, 0x9A5D678F, 0x975A648E, 0x945C688E, 0x9157658C, 0x8F616F93, 0x8D647397, 0x8A7582A2, 0x876C789C, 0x856A759A, 0x83626C95, 0x81626F97, 0x7F5D6B93, 0x7D58638D, 0x7C55628B, 0x7A545989, 0x78585A8B, 0x77575D8E, 0x76555D8D, 0x74545B8C, 
        0x7351578A, 0x724F4F85, 0x724F4B81, 0x71544B89, 0x704A3C89, 0x6F51458F, 0x6F564A92, 0x6F5A4D94, 0x6F63569B, 0x6F63569B, 0x6F5A4D94, 0x705C5193, 0x6F5C538F, 0x705A538E, 0x7057518C, 0x71504C86, 0x7258568C, 0x735C598D, 0x74606092, 0x756E6A9A, 
        0x76736B9E, 0x787672A3, 0x797573A3, 0x7B7173A2, 0x7D6D73A0, 0x7E6E78A1, 0x806E7AA2, 0x82727AA5, 0x847E82AB, 0x877F83AB, 0x897B81A8, 0x8B7881A4, 0x8D717CA0, 0x90707B9B, 0x936C7D9B, 0x956C7899, 0x986F7696, 0x9B6B7296, 0x9E6B7095, 0xA16C7192, 
        0xA3555E79, 0xA6727D8F, 0xA9AEB4C0, 0xADA7AAB3, 0xB0AAAAB4, 0xB3AAAEB1, 0xB6A7AEAE, 0xB9ABAEAE, 0xBCA7AEAB, 0xBFA7AFAB, 0xC3AAAEAE, 0xC7ACACB1, 0xC9A9A9B3, 0xCCAAAAB4, 0xD0ADADB2, 0xD3ADADB3, 0xD6A7ADAD, 0xD9A7AEAE, 0xDCA7AEAE, 0xDCA7AEAE,
  0xE09CA4A4, 0xDD9DA5A5, 0xDA97A5A5, 0xD798A5A5, 0xD49AA6A6, 0xD19BA6A6, 0xCE9CA6A6, 0xCB9CA6A6, 0xC79AA3A8, 0xC59EA6A6, 0xC29EABAB, 0xBE9CA8A8, 0xBB9DA5A8, 0xB896A1A8, 0xB54F5C6A, 0xB24F5970, 0xAF595F7C, 0xAC5F6587, 0xA961678B, 0xA65B6189, 0xA3585E87, 
        0xA05D658E, 0x9D5D688F, 0x9B5B668E, 0x985B678F, 0x965B6A91, 0x93637194, 0x91677598, 0x8E6E7B9D, 0x8D6D789E, 0x8A6A759C, 0x88626D95, 0x86626F97, 0x845F6B92, 0x8257668E, 0x8056628C, 0x7F595D8D, 0x7E5C5C91, 0x7C555B8D, 0x7A52598D, 0x7A576191, 
        0x78545C8D, 0x78585A8B, 0x765B5987, 0x765D558B, 0x7550478A, 0x755C5091, 0x745B5090, 0x74564B8C, 0x745D5492, 0x745F5694, 0x745F5694, 0x74605696, 0x755C5293, 0x755A5091, 0x765E5794, 0x765E5B92, 0x77646195, 0x78676596, 0x796A6A99, 0x7A746EA0, 
        0x7B776FA2, 0x7D7975A6, 0x7E7A76A7, 0x807878A8, 0x817379A7, 0x836E78A6, 0x856A77A5, 0x877278A5, 0x897F7FAA, 0x8B8181AA, 0x8E7E82A8, 0x8F787FA3, 0x92727B9E, 0x946F7B9D, 0x976E7A97, 0x996E7896, 0x9C6E7695, 0x9F6C7194, 0xA26A7091, 0xA5656B87, 
        0xA8576078, 0xAA9FA8B4, 0xADA7ADB6, 0xB0A7AAB1, 0xB4ADADB7, 0xB7ADADB4, 0xBAADADB1, 0xBDADB1AD, 0xC0ADB1AD, 0xC3AAAEAE, 0xC6A9AEAE, 0xC9A9A9AE, 0xCCAAAAAF, 0xD0ADADB8, 0xD2A9A9AF, 0xD6ADADB4, 0xD8A9A9A9, 0xDCAEAEAE, 0xDFA7AFAF, 0xDFA7AFAF,
  0xE29EA7A7, 0xE09CA4A4, 0xDC98A7A0, 0xDA97A5A5, 0xD798A5A5, 0xD49AA6AB, 0xD19BA6A6, 0xCE9CA6A6, 0xCB9CA6A6, 0xC89DA6A6, 0xC5A2ABAB, 0xC29EA7A7, 0xBF9BA7A7, 0xBC989FA7, 0xB94C5B69, 0xB64C5A73, 0xB34D5A75, 0xB0566384, 0xAD5D6685, 0xAA575D81, 0xA8576086, 
        0xA55D688D, 0xA25D688E, 0x9F5C6A8F, 0x9D5D688F, 0x9A5A698D, 0x9856658A, 0x95607092, 0x93657697, 0x91657398, 0x8F667395, 0x8D5F6B93, 0x8B626D94, 0x895C6992, 0x87566390, 0x8553608E, 0x84596190, 0x825B5F94, 0x81565C8F, 0x80546090, 0x7E586291, 
        0x7D56608D, 0x7C5D628D, 0x7B5A5E89, 0x7B5E5E8C, 0x7B605C92, 0x7A5D598F, 0x7959538A, 0x795B578A, 0x79575388, 0x79595388, 0x795B578A, 0x795F5990, 0x7A635B94, 0x7A676196, 0x7A6A659A, 0x7B6E6C9C, 0x7C706E9D, 0x7D71719E, 0x7E7474A1, 0x7F7573A3, 
        0x807470A2, 0x827874A5, 0x837B7BA8, 0x857779A7, 0x86737BA5, 0x88717CA6, 0x8A6C7BA4, 0x8C727BA5, 0x8E7B80A6, 0x907D80A7, 0x927980A3, 0x94777EA1, 0x96717B9D, 0x99737D9B, 0x9B707A9B, 0x9E6E7897, 0xA06D7596, 0xA3696E90, 0xA66C6F8F, 0xA9586179, 
        0xAC808796, 0xAEACB2B9, 0xB2A8AFB2, 0xB4A6AAAD, 0xB7A9ADB1, 0xBBACB0B4, 0xBDA9ADAD, 0xC0A9ADAD, 0xC3AAB2AE, 0xC6A9AEAE, 0xC9A9AEAE, 0xCDADB2B2, 0xCFA9A9AF, 0xD3ADADB3, 0xD6A7ADAD, 0xD8A9B0B0, 0xDBA9B1B1, 0xDEA9B1B1, 0xE1AAB2B2, 0xE1AAB2B2,
  0xE59CA6A6, 0xE29EA7A7, 0xDF97A79F, 0xDD9DACA5, 0xDA9EACA5, 0xD79FA5A5, 0xD49AA6A6, 0xD19BA6A6, 0xCF9FA9A9, 0xCB9CA6A6, 0xC898A6A2, 0xC599A6A6, 0xC29EA7A7, 0xC099A1A9, 0xBD51606F, 0xBA495872, 0xB7435471, 0xB44E5B7A, 0xB1586182, 0xAE5B6483, 0xAB5A6382, 
        0xA95E678B, 0xA65E698C, 0xA45F6A8E, 0xA15C698C, 0x9E5B6B8D, 0x9C59698A, 0x9A5D6C8F, 0x98627494, 0x96657696, 0x93657394, 0x915E6C91, 0x8F5D6A93, 0x8E5C6992, 0x8C5A6591, 0x8A505D8D, 0x89566192, 0x88596293, 0x86586090, 0x85576290, 0x84566390, 
        0x8358648F, 0x825D6A92, 0x8156628B, 0x805E6492, 0x80646294, 0x805E5C90, 0x7F575789, 0x7E5A5A8B, 0x7E5C5C8B, 0x7E5E608D, 0x7F656593, 0x7E666491, 0x7F696795, 0x7F6D6B99, 0x8070709C, 0x8173739F, 0x8173739F, 0x827676A3, 0x837478A4, 0x847373A3, 
        0x85726EA3, 0x877674A7, 0x88797CA9, 0x89767BA6, 0x8B767FA6, 0x8D7681A5, 0x8F717FA3, 0x907480A2, 0x927B82A5, 0x947980A4, 0x97757F9F, 0x99757FA0, 0x9C737D9C, 0x9D727C9C, 0xA0737D9B, 0xA26D7599, 0xA5687195, 0xA8696F8F, 0xAA636C87, 0xAD696F85, 
        0xB0AAADB7, 0xB2ACAFB2, 0xB5A8AFAF, 0xB8ACAFAF, 0xBBACB0B0, 0xBEACB0B0, 0xC1A8ACB0, 0xC4ACB1B1, 0xC7ACB1B1, 0xCAADB1B1, 0xCDADB2B2, 0xCFA9AFAF, 0xD3ADADB3, 0xD6ADADB4, 0xD9AEAEB5, 0xDBA9A9B1, 0xDEA9A9A9, 0xE1AAB2B2, 0xE3A3ACAC, 0xE3A3ACAC,
  0xE794A99F, 0xE59CA6A6, 0xE295A7A7, 0xDF97A79F, 0xDC98A7A0, 0xDA9EACAC, 0xD798A5A5, 0xD49AA6A6, 0xD19BA6A6, 0xCF9FA9A9, 0xCCA0AAAA, 0xC9A0A9A9, 0xC6A9B2B7, 0xC399A1AE, 0xC04C586D, 0xBD49546F, 0xBA425172, 0xB8445676, 0xB556607F, 0xB2596381, 0xB0565D80, 
        0xAD5D6385, 0xAB606A8B, 0xA85D6989, 0xA55D688A, 0xA35B698A, 0xA15C698A, 0x9E5B6B8A, 0x9C617192, 0x9A677397, 0x98657196, 0x965B6A91, 0x945A668E, 0x935E6A94, 0x915A6793, 0x8F4F5D88, 0x8E576090, 0x8C586191, 0x8B596492, 0x8A586391, 0x89566390, 
        0x885C6691, 0x875D6792, 0x865A6690, 0x85606694, 0x85626496, 0x845D5F95, 0x845B5D92, 0x845F6195, 0x845F6192, 0x83626695, 0x84676B99, 0x846B6D9B, 0x846F6F9B, 0x84716F9B, 0x8572729E, 0x8673739F, 0x8671739F, 0x877274A1, 0x887173A0, 0x897474A2, 
        0x8B7876A6, 0x8C7979A7, 0x8D7A7AA7, 0x8E797EA6, 0x907982A7, 0x927480A5, 0x93737FA2, 0x957581A3, 0x977A84A6, 0x99757FA2, 0x9B727A9E, 0x9D727C9C, 0xA0707B9B, 0xA2737B9C, 0xA4707B9A, 0xA76D7399, 0xA96A6D94, 0xAD606688, 0xAE4E5471, 0xB19FA6B3, 
        0xB4ADB4BB, 0xB6A7AEAE, 0xB9AEB2B2, 0xBCA7AEAB, 0xBFABAFAF, 0xC2ABAFAF, 0xC4A8B1B1, 0xC8ABAFAF, 0xCAA8ADAD, 0xCDADB2B2, 0xD0ADADB2, 0xD3ADADB3, 0xD6ADADB4, 0xD9AEB5B5, 0xDBA9B1B1, 0xDEA9B1B1, 0xE1AAB2B2, 0xE4A9B3B3, 0xE6A3ADAD, 0xE6A3ADAD,
  0xEA9DA9A9, 0xE794A99F, 0xE59CA6A6, 0xE29EA7A7, 0xE09CA4A4, 0xDD9DA5A5, 0xDA9EA5A5, 0xD89CA9A9, 0xD59DA9A9, 0xD29EA9A9, 0xCFA4A9AF, 0xCCA0AAAF, 0xC9929BA0, 0xC76D7688, 0xC4525F74, 0xC1495A77, 0xBE465675, 0xBC445775, 0xB94C5778, 0xB6535E7D, 0xB4585F81, 
        0xB15B5E82, 0xAF5F6588, 0xAC62688A, 0xAA636C8D, 0xA7626A8A, 0xA55D688A, 0xA35B6687, 0xA15C668C, 0x9F626C94, 0x9E5E6B92, 0x9B5B6891, 0x995A6991, 0x975A6690, 0x965E6A93, 0x9455638A, 0x9359638F, 0x92565F90, 0x905B6794, 0x8F5D6695, 0x8E556090, 
        0x8D5B6693, 0x8C586391, 0x8B5E6994, 0x8A5D6395, 0x8A5D619A, 0x895A6199, 0x895F639B, 0x8965699D, 0x8961679B, 0x8963699B, 0x89676E9D, 0x896E709F, 0x8972709F, 0x8A706E9E, 0x8A70709E, 0x8B7474A2, 0x8C7577A3, 0x8C7577A3, 0x8E7579A4, 0x8F7A7AA7, 
        0x90807DAB, 0x917C7CA8, 0x92767BA5, 0x93787DA5, 0x95787FA3, 0x96717DA2, 0x987180A3, 0x9A7680A3, 0x9C7880A1, 0x9E737D9D, 0xA0737B9B, 0xA2757E9C, 0xA4757E9C, 0xA675809D, 0xA9707C99, 0xAB6D7697, 0xAD696C8E, 0xB0565A7A, 0xB27D8498, 0xB5AFB2BD, 
        0xB8ACB3B7, 0xBBACB4B0, 0xBDA9B1AD, 0xC0ADB5B1, 0xC3AEB2B2, 0xC5ABAFAF, 0xC8ABAFAF, 0xCBABB0B0, 0xCEABB0B0, 0xD0ADADB2, 0xD3ADB3B3, 0xD6ADADAD, 0xD9AEAEB5, 0xDBA9B1B1, 0xDEA9B1B1, 0xE1AAB2B2, 0xE4A9B3B3, 0xE6ADB7AD, 0xE9ADADAD, 0xE9ADADAD,
  0xECA1A1A1, 0xEA9DA9A9, 0xE7949F9F, 0xE59CA6A6, 0xE29EA7A7, 0xE09CA4A4, 0xDD9DA5A5, 0xDA9EA5A5, 0xD89CA9A9, 0xD5A3A9A9, 0xD2939E9E, 0xD06C777C, 0xCD38424C, 0xCA303951, 0xC75B647A, 0xC54A5C76, 0xC3445577, 0xC0445475, 0xBD455173, 0xBA515876, 0xB8596081, 
        0xB5596082, 0xB35A6182, 0xB0606384, 0xAE616487, 0xAC5C6584, 0xAA5D6987, 0xA8606C8C, 0xA5606890, 0xA45F6794, 0xA25D6591, 0xA05D6590, 0x9E5E6890, 0x9C59668D, 0x9B606B93, 0x995F6B91, 0x985B6791, 0x975A6495, 0x955B6494, 0x945A6393, 0x93545E8F, 
        0x92586190, 0x91576191, 0x905D6794, 0x9060679B, 0x8F5F639C, 0x8E5C609B, 0x8E5E659D, 0x8E60679F, 0x8E60679D, 0x8E60679D, 0x8E60679D, 0x8E696C9F, 0x8E7270A2, 0x8F716FA1, 0x8F7371A1, 0x907477A4, 0x917378A4, 0x927479A3, 0x92747BA5, 0x93787DA5, 
        0x94797BA6, 0x967979A4, 0x97757AA4, 0x99787FA5, 0x9A767EA3, 0x9C737D9F, 0x9D7582A1, 0x9F747F9F, 0xA177829F, 0xA2757E9E, 0xA5767F9E, 0xA7737F9E, 0xA9707C9C, 0xAB707C97, 0xAD6F7897, 0xAF68728F, 0xB2636684, 0xB46C738B, 0xB7B4B8C2, 0xB9A7AEB2, 
        0xBCA7AEAE, 0xBEA8B0AC, 0xC1ACB0AC, 0xC3AAAEAE, 0xC6A9AEB2, 0xC9A9AEAE, 0xCCAAAFAF, 0xCEABB0B0, 0xD1ABB1B1, 0xD4ABB1B1, 0xD6A7ADAD, 0xD9A7AEAE, 0xDBA9A9B1, 0xDEA9A9B1, 0xE1AAB2B2, 0xE3ACACAC, 0xE6ADADAD, 0xE8A6B1A6, 0xEBA5B2B2, 0xEBA5B2B2,
  0xEE96A5A5, 0xECA1A1A1, 0xEA9DA9A9, 0xE89BA6A6, 0xE59CA6A6, 0xE29EA7A7, 0xE09CA4A4, 0xDEA2A9A9, 0xDBA2B1B1, 0xD88F969C, 0xD56D7379, 0xD33F5156, 0xD0364151, 0xCE394358, 0xCC5A647D, 0xC84E5C78, 0xC6475478, 0xC3445577, 0xC1414E73, 0xBE4A5275, 0xBC575B7D, 
        0xB9575E7F, 0xB75C637F, 0xB55C6382, 0xB35A6482, 0xB05A6380, 0xAE5B6783, 0xAC5C6887, 0xAA60698D, 0xA85D668F, 0xA65B648F, 0xA55D6590, 0xA35E6690, 0xA15E668F, 0xA0606893, 0x9E5E6890, 0x9D5D6894, 0x9C5F6997, 0x9A5D6794, 0x995A6193, 0x985B6294, 
        0x97586293, 0x965B6396, 0x955D6797, 0x9560679C, 0x9461639F, 0x9463669F, 0x946368A1, 0x936367A0, 0x93656AA0, 0x93656AA0, 0x93676AA0, 0x936E6EA2, 0x947472A6, 0x947272A4, 0x947272A4, 0x957073A3, 0x967176A2, 0x967179A2, 0x98747BA5, 0x99787DA7, 
        0x99787DA5, 0x9B757AA3, 0x9C767DA1, 0x9D7A82A6, 0x9F747FA1, 0xA07580A0, 0xA2737E9C, 0xA4727E9C, 0xA5747F9E, 0xA7767F9E, 0xA9767F9C, 0xAB76829D, 0xAD6F7C9B, 0xAF6F7C98, 0xB1687592, 0xB45F6681, 0xB6656881, 0xB8A8ACB7, 0xBBA8B0B4, 0xBDA9B1B1, 
        0xC0A9B1AD, 0xC2ABB3AF, 0xC5ABB3AF, 0xC7ACB1B1, 0xCAADB1B1, 0xCDADB2B2, 0xCFA9AFAF, 0xD1ABB1B1, 0xD4ABB1B1, 0xD7ABB2B2, 0xDAACB3B3, 0xDCAEAEAE, 0xDFAFAFB7, 0xE1AAB2B2, 0xE4B3B3B3, 0xE6ADADAD, 0xE8A6B1B1, 0xEBB2B2B2, 0xEDA9A9A9, 0xEDA9A9A9,
  0xF1A3A3A3, 0xEE96A5A5, 0xEC93A1A1, 0xEA9DA9A9, 0xE89BA6A6, 0xE59CA6A6, 0xE39AA3A3, 0xE09CA4AC, 0xDE9AA2A9, 0xDB787F86, 0xD9505D64, 0xD6374450, 0xD3394556, 0xD13C425E, 0xCE58627C, 0xCC4B5A78, 0xC94B597A, 0xC7445176, 0xC5414F72, 0xC2475370, 0xC0505875, 
        0xBE525E79, 0xBB5A657F, 0xB957657F, 0xB754637F, 0xB552637B, 0xB353647F, 0xB154657F, 0xAF596585, 0xAD59668B, 0xAB5A638B, 0xA95B648B, 0xA75C658D, 0xA65E6691, 0xA45F6791, 0xA3606692, 0xA15E6692, 0xA15E6997, 0x9F626A97, 0x9E5E6695, 0x9D5B6294, 
        0x9C576192, 0x9B596093, 0x9A585F94, 0x9A5A5D97, 0x9966649D, 0x996966A0, 0x996966A0, 0x996966A0, 0x996969A0, 0x9867679E, 0x986C6CA0, 0x98716FA5, 0x997373A7, 0x997373A7, 0x9A7173A6, 0x9A7173A3, 0x9B727AA5, 0x9C767DA7, 0x9C737DA4, 0x9D757FA6, 
        0x9F777FA4, 0xA0737BA3, 0xA1777FA2, 0xA27B83A7, 0xA36E799B, 0xA5767F9E, 0xA76D7999, 0xA9767F9F, 0xAA727B9C, 0xAC747D9C, 0xAE7480A0, 0xB073809D, 0xB2697794, 0xB46C7A95, 0xB6576581, 0xB859607A, 0xBAA6A9B4, 0xBCAEB2B6, 0xBFABAFAF, 0xC1ACB4AC, 
        0xC3AAB2AE, 0xC7ACB6B1, 0xC8ABB4AF, 0xCBABB0B5, 0xCDADB2B2, 0xD0ADB2B2, 0xD3ADB3B3, 0xD5A9B0B0, 0xD7ABABAB, 0xDAACACB3, 0xDDACB4B4, 0xDFAFAFAF, 0xE2AFAFAF, 0xE4A9B3B3, 0xE6ADADAD, 0xE9ADADAD, 0xEBA5B2B2, 0xEDA9A9A9, 0xF0AAAAAA, 0xF0AAAAAA,
  0xF394AAAA, 0xF191A3A3, 0xEF9F9F9F, 0xED9BA9A9, 0xEA9DA9A9, 0xE89BA6A6, 0xE6A3ADAD, 0xE39AA3A3, 0xE1889099, 0xDE6C737B, 0xDC3A4150, 0xD9495764, 0xD73F4659, 0xD43B415E, 0xD254607C, 0xD0515C7C, 0xCD4C5B7F, 0xCB44537A, 0xC8455373, 0xC647546F, 0xC4495674, 
        0xC24F5B75, 0xBF4F5F7B, 0xBD51647B, 0xBB52657B, 0xB950657B, 0xB84E647D, 0xB54F677B, 0xB3536482, 0xB1586185, 0xAF596588, 0xAE5B648A, 0xAC5C658D, 0xAB606794, 0xA9616794, 0xA8606695, 0xA75C6593, 0xA5606895, 0xA4626D9A, 0xA35E6695, 0xA2545D91, 
        0xA151598F, 0xA0505890, 0xA0535890, 0x9F575791, 0x9E635E9A, 0x9E68639D, 0x9E66639A, 0x9E68669D, 0x9D6A689C, 0x9D6A689C, 0x9D6D689C, 0x9E6E6BA2, 0x9E7070A5, 0x9F7474A9, 0x9F7477A9, 0x9F7477A6, 0xA0757DA8, 0xA07880A8, 0xA1777FA8, 0xA2757EA4, 
        0xA47880A5, 0xA5767FA4, 0xA67880A3, 0xA7767FA1, 0xA9737C9C, 0xAA727B99, 0xAC717A99, 0xAD757F9E, 0xAF727C9B, 0xB0737D9A, 0xB2737D9B, 0xB4737D99, 0xB66C7692, 0xB8606F8C, 0xBA586781, 0xBD9AA2B1, 0xBEACB0B4, 0xC1ACB0B0, 0xC4ACB5B1, 0xC6AEB7AE, 
        0xC7ACB1AC, 0xCAADB1B1, 0xCCAAAFB4, 0xCEABB0B0, 0xD1ABB1B1, 0xD3ADADB3, 0xD6ADADB4, 0xD8A9B0B0, 0xDBB1B1B1, 0xDDACACB4, 0xE0ACB4B4, 0xE2AFAFB8, 0xE4A9A9B3, 0xE7A9B4B4, 0xE9ADADAD, 0xEBA5B2B2, 0xEEB4B4B4, 0xF0AAAAAA, 0xF2B0B0B0, 0xF2B0B0B0,
  0xF5999999, 0xF394AAAA, 0xF191A3A3, 0xEF9F9F9F, 0xED9BA9A9, 0xEB99A5A5, 0xE89BA6A6, 0xE68E9999, 0xE4848D97, 0xE1555D6E, 0xDF37474F, 0xDD5A6169, 0xDA373E52, 0xD9353C57, 0xD656637C, 0xD3515C79, 0xD14D5E7F, 0xCF4A5A7A, 0xCC465578, 0xCA435673, 0xC8455773, 
        0xC6475974, 0xC3485D77, 0xC14E6277, 0xBF4F637B, 0xBD4D6077, 0xBC4C6279, 0xB9506578, 0xB84E647D, 0xB6576184, 0xB5596389, 0xB259638B, 0xB158618C, 0xAF5F688F, 0xAE616793, 0xAD606694, 0xAB606794, 0xAA666996, 0xA9646A96, 0xA85A6092, 0xA753598D, 
        0xA650588C, 0xA552578A, 0xA451598C, 0xA4595C91, 0xA464629A, 0xA366639B, 0xA366639B, 0xA36E699D, 0xA26A689C, 0xA36E6CA0, 0xA369669B, 0xA36C699D, 0xA36C6CA3, 0xA37774A8, 0xA47578A8, 0xA47878A8, 0xA5797FA9, 0xA5767FA9, 0xA6787DA8, 0xA7767CA1, 
        0xA9797FA5, 0xA9797FA5, 0xAA7B81A2, 0xAC77809F, 0xAD757C9E, 0xAF6C7595, 0xB0737A9A, 0xB1757B99, 0xB3757B9A, 0xB5717B9A, 0xB7717898, 0xB9707B95, 0xBB65708A, 0xBC5F6681, 0xBE7D8598, 0xC0B5B9C1, 0xC3AEB2B6, 0xC5ABAFAF, 0xC7ACB1AC, 0xC9AEB3AE, 
        0xCBABB0AB, 0xCEABB0B0, 0xD0ADB2B2, 0xD2A9AFAF, 0xD4ABABB1, 0xD7ABB2B2, 0xD9AEAEAE, 0xDBA9B1B1, 0xDEA9B1B1, 0xE0ACACAC, 0xE3ACB6B6, 0xE5B0B0B0, 0xE7A9B4B4, 0xE9ADADAD, 0xECAEAEAE, 0xEEB4B4B4, 0xF0AAAAAA, 0xF2B0B0B0, 0xF4A2B9B9, 0xF4A2B9B9,
  0xF79F9F9F, 0xF5999999, 0xF39494AA, 0xF191A3A3, 0xEF9F9F9F, 0xED9B9BA9, 0xEB99A5A5, 0xE98B9696, 0xE77F8A94, 0xE5444E58, 0xE24F5760, 0xE06A737B, 0xDE363D4D, 0xDB313F54, 0xDA59677C, 0xD74C5979, 0xD44D5E7C, 0xD2495A7C, 0xD0465677, 0xCE435877, 0xCC415573, 
        0xC9425971, 0xC7445B71, 0xC5465C76, 0xC3485D77, 0xC1495E77, 0xC04C6075, 0xBE526579, 0xBC4F627D, 0xBA515F81, 0xB9536286, 0xB754638A, 0xB5526086, 0xB458628B, 0xB35A6790, 0xB15E6892, 0xB0636A97, 0xAF686898, 0xAE676496, 0xAD5D5D8E, 0xAC55598A, 
        0xAB575A8B, 0xAA545D8D, 0xA9585E8E, 0xA9616496, 0xA9676499, 0xA86C699B, 0xA86C699E, 0xA87572A4, 0xA76D6A9E, 0xA77370A1, 0xA869669B, 0xA86C669E, 0xA86F6CA4, 0xA97370A5, 0xA97979A8, 0xA9797CA8, 0xAA7B81AB, 0xAB797FA9, 0xAC7A80A8, 0xAC777DA5, 
        0xAD7C7CA4, 0xAE7A7AA3, 0xB0777AA1, 0xB0777A9D, 0xB2737798, 0xB36E7196, 0xB5787B9A, 0xB6737A99, 0xB8727A96, 0xB9707495, 0xBB697092, 0xBD646F8E, 0xBF67738B, 0xC0545C71, 0xC29296A3, 0xC4B1B1B9, 0xC6AEAEB7, 0xC8ABAFAF, 0xCBABB0B0, 0xCDADB2B2, 
        0xD0ADB2B2, 0xD1ABB1B1, 0xD4ABB1B1, 0xD6ADB4B4, 0xD9AEB5B5, 0xDAACB3B3, 0xDDACB4B4, 0xDFAFAFB7, 0xE1AAB2B2, 0xE3ACACAC, 0xE6ADB7B7, 0xE8B1B1B1, 0xEAA9B6B6, 0xECAEAEAE, 0xEEB4B4B4, 0xF0AAAABB, 0xF2B0B0B0, 0xF4B9B9B9, 0xF6A9A9A9, 0xF6A9A9A9,
  0xF97FAAAA, 0xF79F9F9F, 0xF5999999, 0xF48BA2A2, 0xF29C9C9C, 0xF0999999, 0xEE9696A5, 0xEB8C8C99, 0xE9737F8B, 0xE7353F4A, 0xE56B6B75, 0xE3646476, 0xE1222A3B, 0xDF373F57, 0xDC576583, 0xDA4B5975, 0xD8475B7C, 0xD64A567C, 0xD447587C, 0xD2435A76, 0xCF3F546F, 
        0xCE435372, 0xCB445875, 0xC9465971, 0xC8455773, 0xC6475974, 0xC4455A74, 0xC24B6079, 0xC050607D, 0xBF4F5B7F, 0xBD4D5C7F, 0xBB526183, 0xBA515F81, 0xB9536286, 0xB758638A, 0xB65A688B, 0xB5676E97, 0xB3676B96, 0xB3646493, 0xB15B5B8C, 0xB1545B8C, 
        0xB05D6390, 0xAF5C6292, 0xAE5B6190, 0xAE676A99, 0xAE6A679D, 0xAD666697, 0xAD6F6FA1, 0xAD7878A7, 0xAC7774A2, 0xAC7774A5, 0xAD6F6FA1, 0xAD6C699E, 0xAD726FA1, 0xAD6C699E, 0xAE7777A6, 0xAE777AA6, 0xAF7C82AB, 0xB0777DA4, 0xB1787FA6, 0xB17B7FA6, 
        0xB27A7DA5, 0xB37878A0, 0xB473739C, 0xB56E7197, 0xB76D7194, 0xB8727696, 0xB9747898, 0xBB707896, 0xBC6E7594, 0xBE6D7594, 0xBF676F8F, 0xC1626A8B, 0xC35D6A7F, 0xC5535C72, 0xC79196A3, 0xC8ABAFB4, 0xCAADB1B6, 0xCDADB2B2, 0xCEABB0AB, 0xD0ADB2AD, 
        0xD3ADB3B3, 0xD6ADB4B4, 0xD7ABB2B2, 0xD9AEAEAE, 0xDBA9B1B1, 0xDEB1B1B1, 0xE0ACB4B4, 0xE2AFAFAF, 0xE4A9B3B3, 0xE6ADADAD, 0xE8A6B1B1, 0xEAA9A9B6, 0xECAEAEAE, 0xEFAFAFAF, 0xF1B6B6B6, 0xF3AAAAAA, 0xF5B2B2B2, 0xF6A9A9A9, 0xF8B6B6B6, 0xF8B6B6B6,
  0xFB7F7FBF, 0xF97FAAAA, 0xF77F9F9F, 0xF68DA9A9, 0xF48BA2A2, 0xF2899C9C, 0xF0889999, 0xEE879696, 0xEC787886, 0xEA484854, 0xE86E7984, 0xE6515B66, 0xE41C2538, 0xE23D4657, 0xE05A6283, 0xDE4D5C7B, 0xDB46547F, 0xD949577F, 0xD7465979, 0xD5425479, 0xD3455173, 
        0xD1425374, 0xCF455474, 0xCD475175, 0xCC465573, 0xCA485673, 0xC8455373, 0xC6475974, 0xC4525F78, 0xC34C5977, 0xC14E5A77, 0xC0505C7D, 0xBE525A7D, 0xBD54607F, 0xBC576285, 0xBA5C6784, 0xB962698D, 0xB8686893, 0xB7636691, 0xB65A5E8B, 0xB5525986, 
        0xB5565C8D, 0xB45B668E, 0xB35D6790, 0xB3676E9A, 0xB270709E, 0xB269699B, 0xB27070A2, 0xB27373A2, 0xB17575A3, 0xB17878A3, 0xB17575A3, 0xB27370A2, 0xB27773A5, 0xB27777A5, 0xB37878A7, 0xB37B7BA7, 0xB47D81AA, 0xB5747BA1, 0xB5787BA1, 0xB6767AA0, 
        0xB774789F, 0xB872769A, 0xB9707495, 0xBA6E7293, 0xBB696C8E, 0xBC6E7594, 0xBE717591, 0xBF6F778F, 0xC16E738F, 0xC26C708E, 0xC4636C8E, 0xC5576483, 0xC857617D, 0xC96C7184, 0xCC878C9B, 0xCCA5A5AF, 0xCEABABB6, 0xD0ADADB2, 0xD3ADB3B3, 0xD4ABB1B1, 
        0xD6ADADAD, 0xD8A9B0B0, 0xDAACB3B3, 0xDCAEAEAE, 0xDFAFAFAF, 0xE1B2B2B2, 0xE3ACB6AC, 0xE5B0B0B0, 0xE7A9B4A9, 0xE9ADADAD, 0xEBB2B2B2, 0xEDA9B8B8, 0xEFAFAFAF, 0xF1A3B6B6, 0xF3AAAAAA, 0xF5B2B2B2, 0xF79FBFBF, 0xF8B6B6B6, 0xFA99CC99, 0xFA99CC99,
  0xFD7F7F7F, 0xFB7F7FBF, 0xF97FAAAA, 0xF8919191, 0xF68DA9A9, 0xF48BA2A2, 0xF2899C9C, 0xF19191A3, 0xEF6F6F7F, 0xED546371, 0xEB72727F, 0xE9393951, 0xE71F1F35, 0xE53A4462, 0xE351647F, 0xE14C5D7F, 0xDF4F5F7F, 0xDD4B5A7F, 0xDB465C7F, 0xD949577F, 0xD7465279, 
        0xD5424E79, 0xD3455179, 0xD1425374, 0xD0415177, 0xCE435372, 0xCC415073, 0xCA435173, 0xC94B5976, 0xC74D5671, 0xC64B5974, 0xC4525A78, 0xC3505977, 0xC1565E7B, 0xC0586581, 0xBF5B6783, 0xBE5E6585, 0xBD646C8E, 0xBC666A90, 0xBB5A6187, 0xBA585C84, 
        0xBA5C638C, 0xB95E658D, 0xB859648C, 0xB860648F, 0xB76A6A98, 0xB76A6A9B, 0xB76A6698, 0xB66C6C99, 0xB67373A0, 0xB77878A2, 0xB67676A0, 0xB77474A2, 0xB77471A2, 0xB77878A2, 0xB778749F, 0xB87A7DA5, 0xB87A7DA1, 0xB974789C, 0xBA767D9E, 0xBB707899, 
        0xBB696C92, 0xBC6E7598, 0xBD6C7392, 0xBE697191, 0xC069718D, 0xC26C758E, 0xC26C7589, 0xC470788E, 0xC56D728C, 0xC6626F8A, 0xC8576581, 0xCA566581, 0xCB5D667F, 0xCD5B607A, 0xCF8A8F9F, 0xD0A8A8B2, 0xD2A9A9AF, 0xD4ABB1B1, 0xD6A7ADAD, 0xD8A9B0B0, 
        0xDAACB3AC, 0xDCAEAEAE, 0xDEA9B1B1, 0xE0ACB4AC, 0xE2AFAFAF, 0xE4B3B3B3, 0xE6ADB7AD, 0xE8B1B1B1, 0xEAA9B6A9, 0xECAEAEAE, 0xEEB4B4B4, 0xF0AABBBB, 0xF2B0B0B0, 0xF3AAAAAA, 0xF5B2B2B2, 0xF7BFBFBF, 0xF9AAAAAA, 0xFA99CC99, 0xFCAAAAAA, 0xFCAAAAAA,
  0xFEFFFFFF, 0xFD7F7F7F, 0xFCAAAAAA, 0xFA999999, 0xF8919191, 0xF79F9F9F, 0xF5999999, 0xF39494AA, 0xF16D6D7F, 0xEF6F6F7F, 0xEE5A5A69, 0xEC282835, 0xEA24243C, 0xE8424D63, 0xE6515B7A, 0xE44B547A, 0xE24F607B, 0xE0495A83, 0xDE455C7B, 0xDC48577B, 0xDB3F5478, 
        0xD9435078, 0xD7465279, 0xD6445075, 0xD4414D70, 0xD3455173, 0xD0414B71, 0xCE434E6D, 0xCE485372, 0xCC4B5573, 0xCB4E5875, 0xC9505E76, 0xC7515B71, 0xC6505D74, 0xC553607A, 0xC45A637D, 0xC25B647D, 0xC1626687, 0xC1666A8B, 0xC0586085, 0xBF535B83, 
        0xBE525E85, 0xBD58608A, 0xBD5C648E, 0xBC626694, 0xBC6E6A9B, 0xBC6A6A9B, 0xBB696C99, 0xBB707099, 0xBB74749D, 0xBB707499, 0xBB747499, 0xBB7878A1, 0xBB74709D, 0xBC75759F, 0xBC75759F, 0xBD777BA2, 0xBD777B9E, 0xBE757998, 0xBF737B9B, 0xBF6F7797, 
        0xC06D7191, 0xC1737798, 0xC26C7592, 0xC36A728C, 0xC467708A, 0xC5697288, 0xC76D768D, 0xC9677188, 0xCA656E86, 0xCB626B84, 0xCC5A6482, 0xCE5D6D87, 0xCF646F84, 0xD1535E74, 0xD39096A2, 0xD4A6A6B1, 0xD6A7A7A7, 0xD8B0B6B0, 0xDAACB3B3, 0xDCAEB6AE, 
        0xDDACB4AC, 0xDFAFAFAF, 0xE1AAB2B2, 0xE3ACACAC, 0xE5B0B0B0, 0xE7A9B4B4, 0xE9ADB9AD, 0xEBB2B2B2, 0xEDB8B8B8, 0xEFAFAFAF, 0xF1B6B6B6, 0xF2B0B0B0, 0xF4A2B9B9, 0xF6A9A9A9, 0xF79FBFBF, 0xF9AAAAAA, 0xFBBFBFBF, 0xFCAAAAAA, 0xFEFFFFFF, 0xFEFFFFFF,
  0xFF000000, 0xFF000000, 0xFD7F7F7F, 0xFCAAAAAA, 0xFA999999, 0xF9AAAAAA, 0xF79F9F9F, 0xF57F9999, 0xF45C5C73, 0xF2757589, 0xF0333344, 0xEE2D2D3C, 0xED2A2A46, 0xEB3F4C66, 0xE9515C73, 0xE74A547F, 0xE544587F, 0xE44B547A, 0xE246577B, 0xE0495A7B, 0xDE454D7B, 
        0xDC485074, 0xDB465478, 0xD9435072, 0xD73F4C72, 0xD644506F, 0xD4414D6A, 0xD23E496B, 0xD1424D69, 0xD0464B71, 0xCE484E72, 0xCD4C5675, 0xCC505A78, 0xCA515B73, 0xCA515B73, 0xC8535C78, 0xC75B647A, 0xC65D6681, 0xC5606988, 0xC4565F7D, 0xC3555D7F, 
        0xC3555D83, 0xC2576089, 0xC15A668B, 0xC1666A93, 0xC16E6A9C, 0xC0696999, 0xC0696D99, 0xC06D7199, 0xC06D7195, 0xC06D7195, 0xC0717599, 0xC075799D, 0xC075759D, 0xC0757599, 0xC173779C, 0xC1737398, 0xC275799A, 0xC2707596, 0xC3727794, 0xC4707892, 
        0xC56D7690, 0xC569728C, 0xC6666F86, 0xC8656F8A, 0xC8656F86, 0xCA656E86, 0xCB667084, 0xCC646E82, 0xCE626D82, 0xCF5F6A7F, 0xD05C6682, 0xD2606B82, 0xD4647088, 0xD53C425B, 0xD6888E9B, 0xD89C9CA9, 0xDA9E9EA5, 0xDBA9A9A9, 0xDDACB4B4, 0xDFAFAFAF, 
        0xE1AAB2B2, 0xE3ACB6AC, 0xE5B0B0B0, 0xE6ADADAD, 0xE8A6B1B1, 0xEAA9B6B6, 0xECAEAEAE, 0xEEB4B4B4, 0xEFAFAFAF, 0xF1B6B6B6, 0xF3AAAAAA, 0xF5B2B2B2, 0xF6A9A9A9, 0xF8B6B6B6, 0xF9AAAAAA, 0xFBBFBFBF, 0xFCAAAAAA, 0xFEFFFFFF, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFCAAAAAA, 0xFB7F7FBF, 0xF9AAAAAA, 0xF89191B6, 0xF6717171, 0xF54C4C66, 0xF32A2A3F, 0xF1363648, 0xEF2F2F3F, 0xEE4B4B69, 0xEC505078, 0xEA485479, 0xE8425879, 0xE73F547F, 0xE5444E7F, 0xE348517F, 0xE14C5577, 
        0xE049527B, 0xDE4D5473, 0xDD4B5270, 0xDB465471, 0xD943496B, 0xD8414E68, 0xD73F4C6C, 0xD5424867, 0xD4474770, 0xD243496B, 0xD1484D6E, 0xD04B5171, 0xCF545A74, 0xCD565B7A, 0xCC505A73, 0xCB58627A, 0xCB58627A, 0xC95E677F, 0xC9545E7F, 0xC85C6586, 
        0xC7565F83, 0xC7565F88, 0xC65D668A, 0xC6626693, 0xC5696995, 0xC5696999, 0xC5696995, 0xC5696D95, 0xC46C6C92, 0xC46C7092, 0xC46C7092, 0xC5767699, 0xC5767699, 0xC5727295, 0xC6747497, 0xC6747497, 0xC7717696, 0xC7717696, 0xC86F738F, 0xC86A738F, 
        0xC9717692, 0xCA696E8B, 0xCB6B7089, 0xCC697387, 0xCD606B7F, 0xCE5D687C, 0xCF5F6A7A, 0xD0616C7C, 0xD2657187, 0xD35C687F, 0xD4586A82, 0xD65D6982, 0xD759657F, 0xD9282E49, 0xDA757C90, 0xDC98A0A7, 0xDD9DA5A5, 0xDF9FA7A7, 0xE1B2B2B2, 0xE2AFAFAF, 
        0xE4A9B3A9, 0xE6ADB7AD, 0xE8B1B1B1, 0xE9ADADAD, 0xEBB2B2B2, 0xEDA9B8B8, 0xEEA5A5B4, 0xF1B6B6B6, 0xF2B0B0B0, 0xF4B9B9B9, 0xF5B2B2B2, 0xF7BFBFBF, 0xF8B6B6B6, 0xFA99CCCC, 0xFBBFBFBF, 0xFD7F7F7F, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFD7F7F7F, 0xFBBFBFBF, 0xFA999999, 0xF8486D6D, 0xF73F3F3F, 0xF533334C, 0xF42E2E45, 0xF227273A, 0xF0444466, 0xEF4F4F7F, 0xED46547F, 0xEB4C597F, 0xEA485485, 0xE84D5879, 0xE6475B7A, 0xE54E587F, 
        0xE3515B7F, 0xE24F577B, 0xE0495273, 0xDE4D5473, 0xDE455473, 0xDC41506D, 0xDA44526E, 0xD943506B, 0xD8414E6F, 0xD6444A6F, 0xD542486D, 0xD4474D6A, 0xD3515673, 0xD2546076, 0xD14D586E, 0xD05C6177, 0xCF5A647A, 0xCE586277, 0xCD56607A, 0xCC5A6482, 
        0xCC5A6482, 0xCB586284, 0xCA5B6586, 0xCA606590, 0xCA696995, 0xC9676C97, 0xC9676C97, 0xC9676C97, 0xC96C7197, 0xC9676C92, 0xC9676C92, 0xC971769B, 0xCA737399, 0xCA736E95, 0xCA737395, 0xCA737895, 0xCB757A97, 0xCC6E7391, 0xCC6E7891, 0xCD707589, 
        0xCD707584, 0xCE687282, 0xCF646F7F, 0xD0616C82, 0xD1586979, 0xD25A6571, 0xD35C6879, 0xD45E6A7C, 0xD6636F82, 0xD75F6C7F, 0xD8616F89, 0xDA606E89, 0xDB4D5C78, 0xDD1E2543, 0xDE646C7B, 0xDF9F97A7, 0xE1A1A1AA, 0xE3A3A3A3, 0xE4B3A9B3, 0xE6ADB7B7, 
        0xE7A9B4A9, 0xE9ADB9AD, 0xEBB2B2B2, 0xECAEAEAE, 0xEEB4B4B4, 0xF0AAAABB, 0xF1B6B6B6, 0xF3AAAABF, 0xF5B2B2B2, 0xF6A9A9A9, 0xF8B6B6B6, 0xF9AAAAAA, 0xFA99CC99, 0xFCAAAAAA, 0xFD7F7F7F, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFD7F7F7F, 0xFCAAAAAA, 0xFA336666, 0xF92A2A55, 0xF71F1F3F, 0xF6383838, 0xF533334C, 0xF33F3F6A, 0xF24E4E75, 0xF0555588, 0xEE4B5A87, 0xED54637F, 0xEC505D86, 0xEA545485, 0xE84D5884, 
        0xE74A547F, 0xE54E587F, 0xE4424B71, 0xE246577B, 0xE1445577, 0xDF3F4F6F, 0xDE3D4D6C, 0xDD3C5269, 0xDB384D71, 0xDA374B6E, 0xD93C496B, 0xD8414E68, 0xD746526C, 0xD64A566F, 0xD54E5B73, 0xD4535E76, 0xD3566273, 0xD2546071, 0xD2546076, 0xD158637F, 
        0xD05C6682, 0xCF5F6A84, 0xCF5F648A, 0xCF5F648A, 0xCE626891, 0xCE686D91, 0xCE686D91, 0xCE686D91, 0xCD6B7093, 0xCD667093, 0xCD606B8E, 0xCE68688C, 0xCE6D6D91, 0xCE727291, 0xCE6D6D91, 0xCF747494, 0xCF74748F, 0xD06C7187, 0xD071778C, 0xD16E7484, 
        0xD2657182, 0xD2656B7C, 0xD356626E, 0xD4586470, 0xD55B6773, 0xD6636F7C, 0xD765727F, 0xD8616F7C, 0xDA677589, 0xDB63718D, 0xDC5E6D8A, 0xDD61708E, 0xDF575F7F, 0xE0202941, 0xE15D5D77, 0xE39191A3, 0xE5A6A6B0, 0xE6A3A3AD, 0xE8B1B1B1, 0xE9ADADB9, 
        0xEBB2B2B2, 0xECAEAEAE, 0xEEB4B4B4, 0xEFAFAFAF, 0xF1B6B6B6, 0xF2B0B0B0, 0xF4B9B9B9, 0xF5B2B2B2, 0xF79FBFBF, 0xF8B6B6B6, 0xFA99CCCC, 0xFBBFBFBF, 0xFCAAAAAA, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEFFFFFF, 0xFC555555, 0xFB3F3F3F, 0xFA333333, 0xF8242448, 0xF73F3F3F, 0xF6383871, 0xF4454573, 0xF355557F, 0xF1485B7F, 0xF0555588, 0xEE5A5A87, 0xED54547F, 0xEB59597F, 
        0xEA485479, 0xE9515C7F, 0xE73F5474, 0xE6475B7A, 0xE442547A, 0xE33F516D, 0xE13B4C6E, 0xE13B4C6E, 0xDF37476F, 0xDE3D4D6C, 0xDD3C4B69, 0xDC41506D, 0xDB3F4D6A, 0xDA445267, 0xD9505772, 0xD84E5B6F, 0xD7525F72, 0xD6505D6F, 0xD6505D75, 0xD55B677F, 
        0xD458647C, 0xD45E6A82, 0xD3626885, 0xD368688A, 0xD368688A, 0xD2656B8D, 0xD26B7193, 0xD26B7193, 0xD26B7193, 0xD26B7193, 0xD2656B8D, 0xD2656B8D, 0xD2656B8D, 0xD26B6B8D, 0xD36E6E8A, 0xD3737390, 0xD36E6E85, 0xD46A7088, 0xD46A7088, 0xD5676D85, 
        0xD663697C, 0xD7595F79, 0xD7525F72, 0xD85B617C, 0xD9646B7F, 0xDA676E82, 0xDB636A7F, 0xDC5E657B, 0xDD617087, 0xDF5F6F87, 0xE062738B, 0xE1666E90, 0xE24F5772, 0xE324243F, 0xE558586B, 0xE68E8E99, 0xE8A6A6A6, 0xE9A2A2AD, 0xEBA5A5A5, 0xECAEAEBB, 
        0xEEB4B4B4, 0xEFAFAFAF, 0xF1B6B6B6, 0xF2B0B0B0, 0xF4B9B9B9, 0xF5B2B2B2, 0xF6A9A9A9, 0xF8B6B6B6, 0xF9AAAAAA, 0xFA99CCCC, 0xFCAAAAAA, 0xFD7F7F7F, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xFC005555, 0xFA333333, 0xF92A2A55, 0xF848486D, 0xF73F5F7F, 0xF54C4C7F, 0xF4455C8B, 0xF24E6275, 0xF1485B7F, 0xF0555588, 0xEE5A5A87, 
        0xED54547F, 0xEB4C597F, 0xEA485479, 0xE9455C7F, 0xE73F5474, 0xE63D5170, 0xE5444E6B, 0xE4384B71, 0xE33F486D, 0xE23D4F69, 0xE0394962, 0xDF374767, 0xDF3F4F67, 0xDD434B61, 0xDD435269, 0xDC48576D, 0xDB4D5C71, 0xDA52596E, 0xDA525975, 0xD9575D78, 
        0xD8545B7C, 0xD85B617C, 0xD7596585, 0xD765658C, 0xD76C658C, 0xD6636388, 0xD6696F8E, 0xD66F6F8E, 0xD6696F8E, 0xD6636988, 0xD6636988, 0xD6636988, 0xD6696988, 0xD7656C85, 0xD7656C85, 0xD76C7285, 0xD861687C, 0xD8686F82, 0xD9646B7F, 0xD9576478, 
        0xDA525975, 0xDB545C78, 0xDB545C78, 0xDC5E6583, 0xDD616987, 0xDE646C83, 0xDF676F87, 0xE062738B, 0xE1666E88, 0xE260728C, 0xE3646D88, 0xE5626B89, 0xE6333D5B, 0xE72A2A4A, 0xE84D4D63, 0xE98B8B96, 0xEBA5A5B2, 0xECAEAEBB, 0xEDA9A9A9, 0xEFAFAFAF, 
        0xF1B6B6B6, 0xF2B0B0B0, 0xF4B9B9B9, 0xF5B2B2B2, 0xF6A9A9A9, 0xF79FBFBF, 0xF891B6B6, 0xFA99CCCC, 0xFBBFBFBF, 0xFCAAAAAA, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC005555, 0xFB3F3F3F, 0xFA333366, 0xF955557F, 0xF848486D, 0xF654548D, 0xF54C4C7F, 0xF45C5C8B, 0xF24E6289, 0xF24E6289, 
        0xF0445577, 0xEF4F5F7F, 0xEE4B5A78, 0xEC435078, 0xEB4C5972, 0xEA48546D, 0xE9395168, 0xE73F4A6A, 0xE63D4770, 0xE5444E6B, 0xE4424B71, 0xE4384B67, 0xE23D4F69, 0xE13B4C66, 0xE0394962, 0xE0414962, 0xDF3F4F67, 0xDE454D6C, 0xDE4D5473, 0xDD525A78, 
        0xDD525A78, 0xDC575E7B, 0xDB546378, 0xDB636386, 0xDB6A6A86, 0xDB6A6A86, 0xDA676782, 0xDA676782, 0xDA676782, 0xDA606782, 0xDA59607C, 0xDA59607C, 0xDA60677C, 0xDB636A7F, 0xDB5C6378, 0xDB5C6A7F, 0xDC505E74, 0xDC575E74, 0xDD4B5A70, 0xDD525A70, 
        0xDE545C7B, 0xDE5C6483, 0xDF575F7F, 0xE0626283, 0xE1666E90, 0xE269728C, 0xE3646D91, 0xE467718D, 0xE5626B89, 0xE666708E, 0xE75F6A8A, 0xE9515C7F, 0xE9172239, 0xEA303048, 0xEC43435D, 0xED8D8D9B, 0xEE96A5A5, 0xEF9F9F9F, 0xF09999AA, 0xF2B0B0B0, 
        0xF4B9B9B9, 0xF5B2B2B2, 0xF6A9A9A9, 0xF79FBFBF, 0xF8B6B6B6, 0xF9AAAAAA, 0xFBBFBFBF, 0xFCAAAAAA, 0xFD7F7F7F, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD00007F, 0xFC555555, 0xFB3F3F7F, 0xFA336666, 0xF955557F, 0xF73F5F7F, 0xF654548D, 0xF54C667F, 0xF45C5C8B, 
        0xF355557F, 0xF1485B7F, 0xF1485B7F, 0xEF4F4F7F, 0xEE4B5A78, 0xED465471, 0xEC435D78, 0xEA48486D, 0xEA485479, 0xE842426E, 0xE8424D6E, 0xE73F4A6A, 0xE63D5166, 0xE53A4E6B, 0xE4384B67, 0xE33F4864, 0xE33F516D, 0xE23D4F69, 0xE2464F69, 0xE14C556E, 
        0xE0525A73, 0xE0495A73, 0xDF4F5777, 0xDF575F77, 0xDF5F5F77, 0xDF5F5F77, 0xDE5C5C7B, 0xDE5C5C7B, 0xDE5C647B, 0xDE5C647B, 0xDE545C7B, 0xDE4D5C73, 0xDE4D5C73, 0xDF4F576F, 0xDF47576F, 0xDF4F576F, 0xDF475767, 0xE0525A73, 0xE0495A6A, 0xE155667F, 
        0xE2606083, 0xE2606983, 0xE35B6488, 0xE467678D, 0xE467718D, 0xE666708E, 0xE6667084, 0xE76A7494, 0xE8636E90, 0xE968738B, 0xEA616D91, 0xEB3F5972, 0xEC0D0D35, 0xEE1E2D4B, 0xEF3F3F4F, 0xF0888899, 0xF1A3A3A3, 0xF2B0B0B0, 0xF3AAAAAA, 0xF5B2B2B2, 
        0xF6A9A9A9, 0xF7BFBFBF, 0xF8B6B6B6, 0xFACCCCCC, 0xFA99CC99, 0xFCAAAAAA, 0xFD7F7F7F, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD007F7F, 0xFC555555, 0xFB3F3F7F, 0xFA336699, 0xF955557F, 0xF75F5F7F, 0xF654548D, 
        0xF54C4C7F, 0xF4455C73, 0xF355557F, 0xF24E4E75, 0xF1485B6D, 0xF0445577, 0xEF4F5F6F, 0xEE4B5A78, 0xED54547F, 0xEC435078, 0xEB4C4C72, 0xEA3C486D, 0xE9394568, 0xE8374D63, 0xE7354A6A, 0xE73F4A6A, 0xE63D4766, 0xE53A4E62, 0xE5444E6B, 0xE4424B67, 
        0xE4424B67, 0xE4424B67, 0xE348516D, 0xE348516D, 0xE24F4F72, 0xE24F4F72, 0xE2464F72, 0xE2464F72, 0xE24F5772, 0xE24F5772, 0xE24F5772, 0xE2465772, 0xE2465772, 0xE2464F69, 0xE348516D, 0xE3485B6D, 0xE3485B6D, 0xE4545E7A, 0xE4545E7A, 0xE5626B89, 
        0xE5626B89, 0xE666708E, 0xE76A6A8A, 0xE75F6A8A, 0xE8636E90, 0xE968738B, 0xE95C688B, 0xEA616D91, 0xEC6B7893, 0xED63718D, 0xED63718D, 0xEE3C4B69, 0xF0111133, 0xF0222233, 0xF23A3A4E, 0xF37F7F94, 0xF4A2A2A2, 0xF5B2B2B2, 0xF6A9A9A9, 0xF79FBFBF, 
        0xF8B6B6B6, 0xF9AAAAAA, 0xFA99CC99, 0xFBBFBFBF, 0xFD7F7F7F, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD7F7F7F, 0xFC5555AA, 0xFB3F3F7F, 0xFA666699, 0xF955557F, 
        0xF8484891, 0xF75F5F7F, 0xF654548D, 0xF54C667F, 0xF4455C73, 0xF355557F, 0xF24E6275, 0xF1485B6D, 0xF0555577, 0xEF3F4F6F, 0xEE4B4B78, 0xEE4B5A78, 0xED465471, 0xEC43506B, 0xEB3F4C66, 0xEA3C4861, 0xEA3C486D, 0xE9455168, 0xE9455168, 0xE8424D6E, 
        0xE73F4A6A, 0xE73F4A6A, 0xE74A5474, 0xE6475170, 0xE6475170, 0xE6475170, 0xE6475170, 0xE6475170, 0xE6475170, 0xE6475170, 0xE6475170, 0xE6475170, 0xE6475170, 0xE6475170, 0xE6515B70, 0xE7545F74, 0xE7545F74, 0xE75F5F7F, 0xE8586384, 0xE8636E84, 
        0xE968738B, 0xE968738B, 0xEA6D7991, 0xEB727299, 0xEB66728C, 0xEC6B7893, 0xED63718D, 0xEE697896, 0xEF6F6F8F, 0xF0667799, 0xF15B6D91, 0xF2273A62, 0xF213274E, 0xF417172E, 0xF42E2E45, 0xF57F7F7F, 0xF68D8DA9, 0xF79F9F9F, 0xF891B6B6, 0xF9AAAAAA, 
        0xFBBFBFBF, 0xFBBFBFBF, 0xFCAAAAAA, 0xFEFFFFFF, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE0000FF, 0xFD7F7F7F, 0xFC5555AA, 0xFC5555AA, 
        0xFA666699, 0xFA666699, 0xF955557F, 0xF73F5F7F, 0xF75F5F7F, 0xF54C667F, 0xF4455C73, 0xF355557F, 0xF355557F, 0xF24E4E75, 0xF148486D, 0xF148486D, 0xF0445577, 0xEF3F4F6F, 0xEE3C5A69, 0xED465463, 0xED465463, 0xEC43506B, 0xEC43506B, 0xEC43506B, 
        0xEB3F4C66, 0xEB3F4C66, 0xEA48486D, 0xEA3C486D, 0xEA3C546D, 0xE9455168, 0xE9455173, 0xE9455173, 0xE9455173, 0xE9455173, 0xE9515C73, 0xE9515C73, 0xE9515C73, 0xEA546179, 0xEA546179, 0xEA546185, 0xEA616185, 0xEB66728C, 0xEB66728C, 0xEC6B6B86, 
        0xED63718D, 0xEC6B6B86, 0xED71718D, 0xEE787896, 0xEE697887, 0xF0667799, 0xF0667788, 0xF16D7F91, 0xF262759C, 0xF2627589, 0xF355557F, 0xF42E2E5C, 0xF519194C, 0xF61C1C38, 0xF71F3F3F, 0xF86D6D91, 0xF9AAAAAA, 0xFA999999, 0xFBBFBFBF, 0xFCAAAAAA, 
        0xFD7F7F7F, 0xFEFFFFFF, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE0000FF, 0xFD7F7F7F, 
        0xFC5555AA, 0xFC5555AA, 0xFB3F3F7F, 0xFA666699, 0xF955557F, 0xF8486D91, 0xF73F5F7F, 0xF6545471, 0xF54C4C7F, 0xF54C4C7F, 0xF4455C73, 0xF33F556A, 0xF355557F, 0xF24E4E75, 0xF1485B6D, 0xF1485B7F, 0xF0445577, 0xF0445577, 0xEF4F4F6F, 0xEE4B4B69, 
        0xEE4B4B78, 0xEE4B5A78, 0xEE4B5A78, 0xED545471, 0xED465471, 0xED46547F, 0xED465471, 0xEC505D78, 0xEC505D78, 0xEC505D78, 0xED54637F, 0xEC5D5D86, 0xED54637F, 0xED63637F, 0xED63718D, 0xED63717F, 0xEE697896, 0xEE787896, 0xEF6F7F8F, 0xEF6F7F8F, 
        0xF0777799, 0xF0777799, 0xF16D7F91, 0xF16D7F91, 0xF16D6D91, 0xF2627589, 0xF36A6A94, 0xF36A6A94, 0xF45C738B, 0xF5666699, 0xF6545471, 0xF73F3F5F, 0xF8242448, 0xF8002424, 0xF92A2A55, 0xFA666699, 0xFCAAAAAA, 0xFCAAAAAA, 0xFD7F7F7F, 0xFEFFFFFF, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFE0000FF, 0xFE0000FF, 0xFD7F7F7F, 0xFC5555AA, 0xFC5555AA, 0xFA666666, 0xFA666699, 0xF955557F, 0xF8484891, 0xF73F5F7F, 0xF73F5F7F, 0xF6545471, 0xF54C667F, 0xF54C667F, 0xF54C667F, 0xF355557F, 0xF355557F, 0xF355557F, 0xF24E4E75, 0xF24E6275, 
        0xF24E6275, 0xF15B5B7F, 0xF15B5B7F, 0xF0556677, 0xF0445577, 0xF0556688, 0xF0556688, 0xF0666688, 0xF0667788, 0xF0667788, 0xF0667799, 0xF0667788, 0xF0667788, 0xF0667788, 0xF0667788, 0xF0667788, 0xF16D7F91, 0xF16D7F91, 0xF16D7F91, 0xF275899C, 
        0xF275759C, 0xF37F7F94, 0xF36A7F94, 0xF45C738B, 0xF45C738B, 0xF5666699, 0xF5666699, 0xF671718D, 0xF75F7F9F, 0xF86D6D91, 0xF955557F, 0xFA333366, 0xFA333333, 0xFB00003F, 0xFC555555, 0xFC5555AA, 0xFEFFFFFF, 0xFEFFFFFF, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFE0000FF, 0xFD7F7F7F, 0xFD7F7F7F, 0xFC5555AA, 0xFC5555AA, 0xFA666699, 0xFA666699, 0xFA666699, 0xF955557F, 0xF955557F, 0xF86D6D91, 0xF75F5F7F, 0xF654718D, 0xF654548D, 0xF671718D, 0xF566667F, 0xF45C5C8B, 
        0xF45C738B, 0xF45C738B, 0xF45C738B, 0xF36A6A7F, 0xF45C5C8B, 0xF3556A7F, 0xF3556A94, 0xF36A6A94, 0xF36A6A94, 0xF36A6A94, 0xF36A7F94, 0xF36A6A94, 0xF36A7F94, 0xF36A7F94, 0xF36A7F94, 0xF36A7F94, 0xF4738BA2, 0xF473738B, 0xF473738B, 0xF57F7F99, 
        0xF5667F99, 0xF5667F99, 0xF671718D, 0xF671718D, 0xF75F7F7F, 0xF86D9191, 0xF86D6D91, 0xFA666699, 0xFA666699, 0xFA666699, 0xFB3F3F7F, 0xFC555555, 0xFC000055, 0xFE000000, 0xFE000000, 0xFE00FFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE0000FF, 0xFD7F7F7F, 0xFD7F7F7F, 0xFC5555AA, 0xFB3F7F7F, 0xFB3F7F7F, 0xFA666699, 0xFA666699, 0xFA666699, 0xF97F7F7F, 0xF86D6D91, 0xF86D6D91, 0xF86D6D91, 0xF86D6D91, 
        0xF86D6D91, 0xF77F7F9F, 0xF671718D, 0xF671718D, 0xF671718D, 0xF671718D, 0xF671718D, 0xF671718D, 0xF5666699, 0xF5667F99, 0xF5667F99, 0xF6718DA9, 0xF68D8DA9, 0xF6718DA9, 0xF671718D, 0xF77F7F9F, 0xF77F7F9F, 0xF77F7F9F, 0xF77F7F7F, 0xF77F7F7F, 
        0xF86D6D91, 0xF97F7FAA, 0xF97F7FAA, 0xF97F7F7F, 0xF9557F7F, 0xFA666699, 0xFB7F7F7F, 0xFB7F7F7F, 0xFC5555AA, 0xFD7F7F7F, 0xFD00007F, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE0000FF, 0xFE0000FF, 0xFD7F7F7F, 0xFD7F7F7F, 0xFC5555AA, 0xFC5555AA, 0xFB7F7F7F, 0xFB7F7F7F, 0xFA666699, 0xFA666699, 0xFA666699, 
        0xF9557F7F, 0xF97F7F7F, 0xF97F7F7F, 0xF97F7FAA, 0xF86D6D91, 0xF97F7FAA, 0xF97F7FAA, 0xF97F7FAA, 0xF97F7FAA, 0xF97F7FAA, 0xF97F7FAA, 0xF97F7FAA, 0xF97F7FAA, 0xF97F7FAA, 0xF97F7FAA, 0xF97F7F7F, 0xF97F7F7F, 0xF97F7F7F, 0xFA999999, 0xFA666699, 
        0xFA666699, 0xFB7F7F7F, 0xFB7F7F7F, 0xFB7F7F7F, 0xFC5555AA, 0xFC5555AA, 0xFD7F7F7F, 0xFD7F7F7F, 0xFE0000FF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE0000FF, 0xFE0000FF, 0xFD7F7F7F, 0xFD7F7F7F, 0xFD7F7F7F, 0xFC5555AA, 0xFC5555AA, 
        0xFC5555AA, 0xFB7F7F7F, 0xFB7F7F7F, 0xFB7F7F7F, 0xFB7F7F7F, 0xFB7F7F7F, 0xFB7F7F7F, 0xFB7FBFBF, 0xFB7FBFBF, 0xFB7FBFBF, 0xFB7F7FBF, 0xFB7F7F7F, 0xFB7F7F7F, 0xFB7F7F7F, 0xFB7F7F7F, 0xFB7F7F7F, 0xFB7F7F7F, 0xFC5555AA, 0xFC5555AA, 0xFC5555AA, 
        0xFD7F7F7F, 0xFD7F7F7F, 0xFD7F7F7F, 0xFE0000FF, 0xFE0000FF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE0000FF, 
        0xFE0000FF, 0xFE0000FF, 0xFE0000FF, 0xFD7F7F7F, 0xFD7F7F7F, 0xFD7F7F7F, 0xFEFFFFFF, 0xFD7F7F7F, 0xFD7F7F7F, 0xFD7F7F7F, 0xFD7F7F7F, 0xFD7F7F7F, 0xFD7F7F7F, 0xFD7F7F7F, 0xFD7F7F7F, 0xFD7F7F7F, 0xFE0000FF, 0xFE0000FF, 0xFE0000FF, 0xFE0000FF, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000
#endif
};

static GUI_CONST_STORAGE GUI_BITMAP _bmJoerg = {
  101, // XSize
  153, // YSize
  404, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acJoerg,  // Pointer to picture data
  NULL, // Pointer to palette
#if (GUI_USE_ARGB == 1)
  GUI_DRAW_BMPM8888I
#else
  GUI_DRAW_BMP8888
#endif
};

static const char _acMessageTop[] = 
  "Please use the viewer to show\n"
  "the composite view of the display.";

static const char _acMessageBottom[] = 
  "The viewer needs to be used in\n"
  "multi layer mode.";

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*********************************************************************
*
*       _DrawStripes
*
* Function description
*   Draws the background consisting of colored stripes
*/
static void _DrawStripes(int yOff) {
  int xSize;
  int ySize;
  int x;
  int Cnt;
  GUI_COLOR aColor[] = {
    GUI_RED, 
    GUI_GREEN, 
    GUI_BLUE, 
    GUI_MAKE_COLOR(0x4080c0), 
    GUI_WHITE, 
    GUI_BLACK, 
    GUI_YELLOW, 
    GUI_MAGENTA, 
    GUI_CYAN, 
    GUI_MAKE_COLOR(0xc04080)
  };

  Cnt   = 0;
  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  for (x = 0; x < xSize; x += 5) {
    GUI_SetColor(aColor[Cnt]);
    GUI_FillRect(x, yOff, x + 4, ySize - 1 - yOff);
    if (++Cnt == GUI_COUNTOF(aColor)) {
      Cnt = 0;
    }
  }
}

/*********************************************************************
*
*       _DrawImage
*
* Function description
*   Draws the image with alphavalues using GUI_DrawBitmapHWAlpha
*/
static void _DrawImage(void) {
  int xSize;
  int ySize;

  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  GUI_DrawBitmapHWAlpha(&_bmJoerg, (xSize - _bmJoerg.XSize) / 2, (ySize - _bmJoerg.YSize) / 2);
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/
void MainTask(void) {
  int ySize;
  int FontHeight;
  //
  // Check if recommended memory for the sample is available
  //
  if (GUI_ALLOC_GetNumFreeBytes() < RECOMMENDED_MEMORY) {
    GUI_ErrorOut("Not enough memory available."); 
    return;
  }
  //
  // Draw message
  //
  ySize = LCD_GetYSize();
  GUI_SetFont(&GUI_Font20B_ASCII);
  FontHeight = GUI_GetFontSizeY();
  GUI_DispStringHCenterAt(_acMessageTop, 160, 5);
  GUI_DispStringHCenterAt(_acMessageBottom, 160, ySize - FontHeight * 2 - 5);
  //
  // Draw stripes on layer 0
  //
  GUI_SelectLayer(0);
  _DrawStripes(50);
  //
  // Fill layer 1 with transparency and draw alpha image
  //
  GUI_SelectLayer(1);
  GUI_SetBkColor(GUI_TRANSPARENT);
  GUI_Clear();
  _DrawImage();
  while (1) {
    GUI_Delay(100);
  }
}

/*************************** End of file ****************************/
