
#include "lv_font.h"

/***********************************************************************************
 * Roboto-Regular.ttf 24 px Font in U+0020 ( ) .. U+007e (~)  range with 2 bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t roboto24_glyph_bitmap[] = 
{
  /*Unicode: U+0020 ( ) , Width: 7 */
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 


  /*Unicode: U+0021 (!) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x50,  //++ 
  0xe0,  //@% 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+0022 (") , Width: 4 */
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0xff,  //@@@@ 
  0xff,  //@@@@ 
  0xff,  //@@@@ 
  0xef,  //@%@@ 
  0xee,  //@%@% 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 


  /*Unicode: U+0023 (#) , Width: 12 */
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x70, 0x34,  //....+@...@+. 
  0x00, 0xb0, 0x70,  //....%@..+@.. 
  0x00, 0xb0, 0xb0,  //....%@..%@.. 
  0x00, 0xe0, 0xb0,  //....@%..%@.. 
  0x3f, 0xff, 0xff,  //.@@@@@@@@@@@ 
  0x16, 0xe6, 0xe5,  //.++%@%+%@%++ 
  0x02, 0xc1, 0xc0,  //...%@..+@... 
  0x02, 0xc1, 0xc0,  //...%@..+@... 
  0x03, 0x82, 0xc0,  //...@%..%@... 
  0x5b, 0x97, 0xd4,  //++%@%++@@++. 
  0xff, 0xff, 0xfc,  //@@@@@@@@@@@. 
  0x07, 0x03, 0x40,  //..+@...@+... 
  0x0b, 0x07, 0x00,  //..%@..+@.... 
  0x0e, 0x0b, 0x00,  //..@%..%@.... 
  0x0d, 0x0e, 0x00,  //..@+..@%.... 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 


  /*Unicode: U+0024 ($) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x01, 0xf8, 0x00,  //...+@@%... 
  0x0f, 0xff, 0x40,  //..@@@@@@+. 
  0x2e, 0x07, 0xd0,  //.%@%..+@@+ 
  0x3c, 0x01, 0xe0,  //.@@....+@% 
  0x3c, 0x00, 0xf0,  //.@@.....@@ 
  0x3c, 0x00, 0x00,  //.@@....... 
  0x1f, 0x40, 0x00,  //.+@@+..... 
  0x0b, 0xf8, 0x00,  //..%@@@%... 
  0x00, 0xbf, 0x80,  //....%@@@%. 
  0x00, 0x07, 0xd0,  //......+@@+ 
  0x00, 0x01, 0xf0,  //.......+@@ 
  0xf0, 0x00, 0xf0,  //@@......@@ 
  0xf0, 0x00, 0xe0,  //@@......@% 
  0x7d, 0x07, 0xd0,  //+@@+..+@@+ 
  0x1f, 0xff, 0x40,  //.+@@@@@@+. 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0025 (%) , Width: 14 */
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x2f, 0x80, 0x00, 0x00,  //.%@@%......... 
  0xba, 0xe0, 0x00, 0x00,  //%@%%@%........ 
  0xf0, 0xf0, 0x28, 0x00,  //@@..@@...%%... 
  0xf0, 0xf0, 0x30, 0x00,  //@@..@@...@.... 
  0xf0, 0xf0, 0xd0, 0x00,  //@@..@@..@+.... 
  0xba, 0xe2, 0xc0, 0x00,  //%@%%@%.%@..... 
  0x2f, 0x83, 0x00, 0x00,  //.%@@%..@...... 
  0x00, 0x0d, 0x00, 0x00,  //......@+...... 
  0x00, 0x28, 0x7f, 0x40,  //.....%%.+@@@+. 
  0x00, 0x31, 0xfb, 0xd0,  //.....@.+@@%@@+ 
  0x00, 0xd3, 0xc0, 0xf0,  //....@+.@@...@@ 
  0x02, 0x83, 0xc0, 0xf0,  //...%%..@@...@@ 
  0x03, 0x03, 0xc0, 0xf0,  //...@...@@...@@ 
  0x00, 0x01, 0xfb, 0xd0,  //.......+@@%@@+ 
  0x00, 0x00, 0x7f, 0x40,  //........+@@@+. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 


  /*Unicode: U+0026 (&) , Width: 12 */
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x02, 0xfd, 0x00,  //...%@@@+.... 
  0x1f, 0xaf, 0x40,  //.+@@%%@@+... 
  0x2d, 0x03, 0xc0,  //.%@+...@@... 
  0x3c, 0x03, 0xc0,  //.@@....@@... 
  0x2d, 0x0b, 0x40,  //.%@+..%@+... 
  0x0f, 0x7e, 0x00,  //..@@+@@%.... 
  0x07, 0xf4, 0x00,  //..+@@@+..... 
  0x0f, 0xf0, 0x00,  //..@@@@...... 
  0x3d, 0xb8, 0x3c,  //.@@+%@%..@@. 
  0xb4, 0x2e, 0x3c,  //%@+..%@%.@@. 
  0xf0, 0x0b, 0xb8,  //@@....%@%@%. 
  0xf0, 0x03, 0xf0,  //@@.....@@@.. 
  0xb8, 0x01, 0xf0,  //%@%....+@@.. 
  0x3f, 0xaf, 0xf8,  //.@@@%%@@@@%. 
  0x0b, 0xfe, 0x2d,  //..%@@@@%.%@+ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 


  /*Unicode: U+0027 (') , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+0028 (() , Width: 6 */
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x01, 0xc0,  //...+@. 
  0x03, 0x80,  //...@%. 
  0x0f, 0x00,  //..@@.. 
  0x1c, 0x00,  //.+@... 
  0x3c, 0x00,  //.@@... 
  0x74, 0x00,  //+@+... 
  0xb0, 0x00,  //%@.... 
  0xf0, 0x00,  //@@.... 
  0xf0, 0x00,  //@@.... 
  0xf0, 0x00,  //@@.... 
  0xf0, 0x00,  //@@.... 
  0xf0, 0x00,  //@@.... 
  0xf0, 0x00,  //@@.... 
  0xb0, 0x00,  //%@.... 
  0x74, 0x00,  //+@+... 
  0x38, 0x00,  //.@%... 
  0x2c, 0x00,  //.%@... 
  0x0e, 0x00,  //..@%.. 
  0x07, 0x40,  //..+@+. 
  0x01, 0xc0,  //...+@. 
  0x00, 0x40,  //....+. 


  /*Unicode: U+0029 ()) , Width: 6 */
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x70, 0x00,  //+@.... 
  0x2c, 0x00,  //.%@... 
  0x0e, 0x00,  //..@%.. 
  0x07, 0x40,  //..+@+. 
  0x03, 0xc0,  //...@@. 
  0x02, 0xc0,  //...%@. 
  0x01, 0xd0,  //...+@+ 
  0x00, 0xe0,  //....@% 
  0x00, 0xf0,  //....@@ 
  0x00, 0xf0,  //....@@ 
  0x00, 0xf0,  //....@@ 
  0x00, 0xf0,  //....@@ 
  0x00, 0xe0,  //....@% 
  0x01, 0xd0,  //...+@+ 
  0x02, 0xc0,  //...%@. 
  0x03, 0xc0,  //...@@. 
  0x03, 0x40,  //...@+. 
  0x0b, 0x00,  //..%@.. 
  0x1c, 0x00,  //.+@... 
  0x74, 0x00,  //+@+... 
  0x10, 0x00,  //.+.... 


  /*Unicode: U+002a (*) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x10, 0xf0, 0x40,  //.+..@@..+. 
  0x7f, 0xfb, 0xc0,  //+@@@@@%@@. 
  0x07, 0xfd, 0x00,  //..+@@@@+.. 
  0x03, 0xf8, 0x00,  //...@@@%... 
  0x0b, 0x1d, 0x00,  //..%@.+@+.. 
  0x0d, 0x0b, 0x00,  //..@+..%@.. 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+002b (+) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x00, 0xf0, 0x00,  //....@@.... 
  0xff, 0xff, 0xf0,  //@@@@@@@@@@ 
  0x55, 0xf5, 0x50,  //++++@@++++ 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+002c (,) , Width: 3 */
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x3c,  //.@@ 
  0x3c,  //.@@ 
  0x38,  //.@% 
  0xb4,  //%@+ 
  0xa0,  //%%. 
  0x00,  //... 
  0x00,  //... 


  /*Unicode: U+002d (-) , Width: 5 */
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x55, 0x40,  //+++++ 
  0xff, 0xc0,  //@@@@@ 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 


  /*Unicode: U+002e (.) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xf0,  //@@ 
  0xe0,  //@% 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+002f (/) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x0f,  //......@@ 
  0x00, 0x0d,  //......@+ 
  0x00, 0x2c,  //.....%@. 
  0x00, 0x38,  //.....@%. 
  0x00, 0x74,  //....+@+. 
  0x00, 0xb0,  //....%@.. 
  0x00, 0xe0,  //....@%.. 
  0x01, 0xc0,  //...+@... 
  0x03, 0x80,  //...@%... 
  0x07, 0x40,  //..+@+... 
  0x0b, 0x00,  //..%@.... 
  0x0e, 0x00,  //..@%.... 
  0x1c, 0x00,  //.+@..... 
  0x3c, 0x00,  //.@@..... 
  0x34, 0x00,  //.@+..... 
  0xb0, 0x00,  //%@...... 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0030 (0) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x0b, 0xf8, 0x00,  //..%@@@%.. 
  0x3e, 0xaf, 0x00,  //.@@%%%@@. 
  0x78, 0x0b, 0x40,  //+@%...%@+ 
  0xb0, 0x03, 0x80,  //%@.....@% 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xb0, 0x03, 0x80,  //%@.....@% 
  0x78, 0x0b, 0x40,  //+@%...%@+ 
  0x3f, 0xaf, 0x00,  //.@@@%%@@. 
  0x0b, 0xf8, 0x00,  //..%@@@%.. 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0031 (1) , Width: 6 */
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0xb0,  //....%@ 
  0x1f, 0xf0,  //.+@@@@ 
  0xfe, 0xf0,  //@@@%@@ 
  0x80, 0xf0,  //%...@@ 
  0x00, 0xf0,  //....@@ 
  0x00, 0xf0,  //....@@ 
  0x00, 0xf0,  //....@@ 
  0x00, 0xf0,  //....@@ 
  0x00, 0xf0,  //....@@ 
  0x00, 0xf0,  //....@@ 
  0x00, 0xf0,  //....@@ 
  0x00, 0xf0,  //....@@ 
  0x00, 0xf0,  //....@@ 
  0x00, 0xf0,  //....@@ 
  0x00, 0xf0,  //....@@ 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 


  /*Unicode: U+0032 (2) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x0b, 0xf8, 0x00,  //..%@@@%... 
  0x3f, 0xaf, 0x00,  //.@@@%%@@.. 
  0xb8, 0x07, 0x80,  //%@%...+@%. 
  0xf0, 0x03, 0xc0,  //@@.....@@. 
  0xa0, 0x03, 0xc0,  //%%.....@@. 
  0x00, 0x03, 0x80,  //.......@%. 
  0x00, 0x0b, 0x00,  //......%@.. 
  0x00, 0x2e, 0x00,  //.....%@%.. 
  0x00, 0x7c, 0x00,  //....+@@... 
  0x01, 0xf0, 0x00,  //...+@@.... 
  0x03, 0xc0, 0x00,  //...@@..... 
  0x0f, 0x40, 0x00,  //..@@+..... 
  0x3d, 0x00, 0x00,  //.@@+...... 
  0xfd, 0x55, 0x50,  //@@@+++++++ 
  0xff, 0xff, 0xf0,  //@@@@@@@@@@ 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0033 (3) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x0b, 0xf8, 0x00,  //..%@@@%.. 
  0x3e, 0xaf, 0x00,  //.@@%%%@@. 
  0xb4, 0x07, 0x80,  //%@+...+@% 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x07, 0x80,  //......+@% 
  0x01, 0xae, 0x00,  //...+%%@%. 
  0x03, 0xfd, 0x00,  //...@@@@+. 
  0x00, 0x0f, 0x40,  //......@@+ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xb4, 0x07, 0x80,  //%@+...+@% 
  0x3e, 0xaf, 0x00,  //.@@%%%@@. 
  0x0b, 0xf8, 0x00,  //..%@@@%.. 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0034 (4) , Width: 11 */
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x07, 0xc0,  //......+@@.. 
  0x00, 0x0f, 0xc0,  //......@@@.. 
  0x00, 0x3f, 0xc0,  //.....@@@@.. 
  0x00, 0x77, 0xc0,  //....+@+@@.. 
  0x00, 0xf3, 0xc0,  //....@@.@@.. 
  0x02, 0xc3, 0xc0,  //...%@..@@.. 
  0x07, 0x43, 0xc0,  //..+@+..@@.. 
  0x0f, 0x03, 0xc0,  //..@@...@@.. 
  0x2c, 0x03, 0xc0,  //.%@....@@.. 
  0x78, 0x03, 0xc0,  //+@%....@@.. 
  0xff, 0xff, 0xfc,  //@@@@@@@@@@@ 
  0x55, 0x57, 0xd4,  //+++++++@@++ 
  0x00, 0x03, 0xc0,  //.......@@.. 
  0x00, 0x03, 0xc0,  //.......@@.. 
  0x00, 0x03, 0xc0,  //.......@@.. 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 


  /*Unicode: U+0035 (5) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x0f, 0xff, 0xd0,  //..@@@@@@@+ 
  0x1e, 0x55, 0x40,  //.+@%+++++. 
  0x1d, 0x00, 0x00,  //.+@+...... 
  0x2c, 0x00, 0x00,  //.%@....... 
  0x2c, 0x00, 0x00,  //.%@....... 
  0x2c, 0x54, 0x00,  //.%@.+++... 
  0x3f, 0xff, 0x40,  //.@@@@@@@+. 
  0x2d, 0x07, 0xc0,  //.%@+..+@@. 
  0x00, 0x01, 0xe0,  //.......+@% 
  0x00, 0x00, 0xf0,  //........@@ 
  0x00, 0x00, 0xf0,  //........@@ 
  0x74, 0x00, 0xe0,  //+@+.....@% 
  0x3c, 0x02, 0xd0,  //.@@....%@+ 
  0x1f, 0xaf, 0xc0,  //.+@@%%@@@. 
  0x06, 0xfe, 0x00,  //..+%@@@%.. 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0036 (6) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0xbe, 0x00,  //....%@@%.. 
  0x07, 0xf9, 0x00,  //..+@@@%+.. 
  0x1f, 0x00, 0x00,  //.+@@...... 
  0x3c, 0x00, 0x00,  //.@@....... 
  0x74, 0x00, 0x00,  //+@+....... 
  0xb0, 0x54, 0x00,  //%@..+++... 
  0xfb, 0xff, 0x40,  //@@%@@@@@+. 
  0xfd, 0x07, 0xc0,  //@@@+..+@@. 
  0xf0, 0x01, 0xe0,  //@@.....+@% 
  0xf0, 0x00, 0xf0,  //@@......@@ 
  0xf0, 0x00, 0xf0,  //@@......@@ 
  0xb4, 0x00, 0xe0,  //%@+.....@% 
  0x3c, 0x03, 0xd0,  //.@@....@@+ 
  0x1f, 0xaf, 0x80,  //.+@@%%@@%. 
  0x06, 0xfd, 0x00,  //..+%@@@+.. 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0037 (7) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0xff, 0xff, 0xf0,  //@@@@@@@@@@ 
  0x55, 0x56, 0xf0,  //+++++++%@@ 
  0x00, 0x01, 0xd0,  //.......+@+ 
  0x00, 0x03, 0xc0,  //.......@@. 
  0x00, 0x07, 0x40,  //......+@+. 
  0x00, 0x0f, 0x00,  //......@@.. 
  0x00, 0x0e, 0x00,  //......@%.. 
  0x00, 0x2c, 0x00,  //.....%@... 
  0x00, 0x38, 0x00,  //.....@%... 
  0x00, 0xb4, 0x00,  //....%@+... 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x02, 0xd0, 0x00,  //...%@+.... 
  0x03, 0xc0, 0x00,  //...@@..... 
  0x07, 0x80, 0x00,  //..+@%..... 
  0x0f, 0x00, 0x00,  //..@@...... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0038 (8) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x0b, 0xf8, 0x00,  //..%@@@%... 
  0x3e, 0xaf, 0x00,  //.@@%%%@@.. 
  0xb4, 0x07, 0x80,  //%@+...+@%. 
  0xf0, 0x03, 0xc0,  //@@.....@@. 
  0xf0, 0x03, 0xc0,  //@@.....@@. 
  0xb8, 0x07, 0x80,  //%@%...+@%. 
  0x2e, 0xaf, 0x00,  //.%@%%%@@.. 
  0x1f, 0xfd, 0x00,  //.+@@@@@+.. 
  0x3d, 0x07, 0x80,  //.@@+..+@%. 
  0xb0, 0x01, 0xe0,  //%@.....+@% 
  0xf0, 0x00, 0xf0,  //@@......@@ 
  0xf0, 0x00, 0xf0,  //@@......@@ 
  0xb8, 0x02, 0xe0,  //%@%....%@% 
  0x3f, 0xaf, 0xc0,  //.@@@%%@@@. 
  0x0b, 0xfd, 0x00,  //..%@@@@+.. 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0039 (9) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x0b, 0xf4, 0x00,  //..%@@@+.. 
  0x3f, 0xbe, 0x00,  //.@@@%@@%. 
  0x78, 0x0f, 0x40,  //+@%...@@+ 
  0xf0, 0x07, 0x80,  //@@....+@% 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xb8, 0x0b, 0xc0,  //%@%...%@@ 
  0x3f, 0xbf, 0xc0,  //.@@@%@@@@ 
  0x0b, 0xe3, 0xc0,  //..%@@%.@@ 
  0x00, 0x03, 0x80,  //.......@% 
  0x00, 0x0b, 0x00,  //......%@. 
  0x00, 0x1e, 0x00,  //.....+@%. 
  0x06, 0xfc, 0x00,  //..+%@@@.. 
  0x0f, 0x90, 0x00,  //..@@%+... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+003a (:) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xe0,  //@% 
  0xf0,  //@@ 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xf0,  //@@ 
  0xe0,  //@% 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+003b (;) , Width: 3 */
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x3c,  //.@@ 
  0x3c,  //.@@ 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x14,  //.++ 
  0x3c,  //.@@ 
  0x3c,  //.@@ 
  0x38,  //.@% 
  0x70,  //+@. 
  0x10,  //.+. 
  0x00,  //... 
  0x00,  //... 


  /*Unicode: U+003c (<) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x02, 0x40,  //.......%+ 
  0x00, 0x2f, 0x40,  //.....%@@+ 
  0x06, 0xfd, 0x00,  //..+%@@@+. 
  0x7f, 0x80, 0x00,  //+@@@%.... 
  0xf8, 0x00, 0x00,  //@@%...... 
  0x7f, 0x40, 0x00,  //+@@@+.... 
  0x07, 0xf9, 0x00,  //..+@@@%+. 
  0x00, 0x6f, 0x40,  //....+%@@+ 
  0x00, 0x02, 0x40,  //.......%+ 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+003d (=) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x55, 0x55, 0x40,  //+++++++++ 
  0xff, 0xff, 0xc0,  //@@@@@@@@@ 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x55, 0x55, 0x40,  //+++++++++ 
  0xff, 0xff, 0xc0,  //@@@@@@@@@ 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+003e (>) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0xd0, 0x00, 0x00,  //@+....... 
  0xfd, 0x00, 0x00,  //@@@+..... 
  0x1f, 0xe0, 0x00,  //.+@@@%... 
  0x00, 0xbf, 0x40,  //....%@@@+ 
  0x00, 0x0b, 0xc0,  //......%@@ 
  0x00, 0xbf, 0x40,  //....%@@@+ 
  0x1f, 0xe4, 0x00,  //.+@@@%+.. 
  0xfe, 0x00, 0x00,  //@@@%..... 
  0xd0, 0x00, 0x00,  //@+....... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+003f (?) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x1b, 0xf4,  //.+%@@@+. 
  0x7e, 0xbd,  //+@@%%@@+ 
  0xf0, 0x0f,  //@@....@@ 
  0xa0, 0x0f,  //%%....@@ 
  0x00, 0x0f,  //......@@ 
  0x00, 0x1e,  //.....+@% 
  0x00, 0x3d,  //.....@@+ 
  0x00, 0xf8,  //....@@%. 
  0x01, 0xf0,  //...+@@.. 
  0x03, 0xc0,  //...@@... 
  0x03, 0xc0,  //...@@... 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x01, 0x40,  //...++... 
  0x03, 0x80,  //...@%... 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0040 (@) , Width: 17 */
  0x00, 0x00, 0x00, 0x00, 0x00,  //................. 
  0x00, 0x00, 0x00, 0x00, 0x00,  //................. 
  0x00, 0x00, 0x00, 0x00, 0x00,  //................. 
  0x00, 0x00, 0x00, 0x00, 0x00,  //................. 
  0x00, 0x1b, 0xfe, 0x00, 0x00,  //.....+%@@@@%..... 
  0x00, 0xfe, 0xab, 0xe0, 0x00,  //....@@@%%%%@@%... 
  0x07, 0xd0, 0x00, 0x7c, 0x00,  //..+@@+......+@@.. 
  0x0f, 0x00, 0x00, 0x0e, 0x00,  //..@@..........@%. 
  0x3d, 0x00, 0x54, 0x03, 0x00,  //.@@+....+++....@. 
  0x3c, 0x03, 0xff, 0x03, 0x40,  //.@@....@@@@@...@+ 
  0xb4, 0x0f, 0x47, 0x02, 0x80,  //%@+...@@+.+@...%% 
  0xf0, 0x1d, 0x07, 0x01, 0xc0,  //@@...+@+..+@...+@ 
  0xf0, 0x2c, 0x07, 0x00, 0xc0,  //@@...%@...+@....@ 
  0xf0, 0x38, 0x0b, 0x00, 0xc0,  //@@...@%...%@....@ 
  0xf0, 0x38, 0x0b, 0x01, 0xc0,  //@@...@%...%@...+@ 
  0xf0, 0x38, 0x0f, 0x02, 0xc0,  //@@...@%...@@...%@ 
  0xb0, 0x38, 0x1f, 0x03, 0x40,  //%@...@%..+@@...@+ 
  0x78, 0x2e, 0xbb, 0xaf, 0x00,  //+@%..%@%%@%@%%@@. 
  0x3c, 0x0b, 0xd2, 0xf8, 0x00,  //.@@...%@@+.%@@%.. 
  0x1e, 0x00, 0x00, 0x00, 0x00,  //.+@%............. 
  0x0f, 0x80, 0x00, 0x00, 0x00,  //..@@%............ 
  0x02, 0xfe, 0xab, 0x00, 0x00,  //...%@@@%%%%@..... 
  0x00, 0x2f, 0xf9, 0x00, 0x00,  //.....%@@@@%+..... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //................. 


  /*Unicode: U+0041 (A) , Width: 14 */
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x0f, 0x00, 0x00,  //......@@...... 
  0x00, 0x2f, 0x40, 0x00,  //.....%@@+..... 
  0x00, 0x3f, 0x80, 0x00,  //.....@@@%..... 
  0x00, 0x77, 0xc0, 0x00,  //....+@+@@..... 
  0x00, 0xb1, 0xd0, 0x00,  //....%@.+@+.... 
  0x00, 0xe0, 0xf0, 0x00,  //....@%..@@.... 
  0x01, 0xd0, 0xb0, 0x00,  //...+@+..%@.... 
  0x03, 0xc0, 0x78, 0x00,  //...@@...+@%... 
  0x03, 0x80, 0x3c, 0x00,  //...@%....@@... 
  0x0b, 0xaa, 0xbd, 0x00,  //..%@%%%%%@@+.. 
  0x0f, 0xff, 0xfe, 0x00,  //..@@@@@@@@@%.. 
  0x1e, 0x00, 0x0f, 0x00,  //.+@%......@@.. 
  0x3c, 0x00, 0x07, 0x40,  //.@@.......+@+. 
  0x3c, 0x00, 0x03, 0xc0,  //.@@........@@. 
  0xb4, 0x00, 0x03, 0xc0,  //%@+........@@. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 


  /*Unicode: U+0042 (B) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0xff, 0xfe, 0x00,  //@@@@@@@%.. 
  0xf5, 0x6f, 0xc0,  //@@+++%@@@. 
  0xf0, 0x01, 0xe0,  //@@.....+@% 
  0xf0, 0x00, 0xf0,  //@@......@@ 
  0xf0, 0x00, 0xf0,  //@@......@@ 
  0xf0, 0x02, 0xe0,  //@@.....%@% 
  0xf5, 0x6f, 0x80,  //@@+++%@@%. 
  0xff, 0xff, 0x40,  //@@@@@@@@+. 
  0xf0, 0x03, 0xd0,  //@@.....@@+ 
  0xf0, 0x00, 0xf0,  //@@......@@ 
  0xf0, 0x00, 0xf0,  //@@......@@ 
  0xf0, 0x00, 0xf0,  //@@......@@ 
  0xf0, 0x02, 0xe0,  //@@.....%@% 
  0xf5, 0x6f, 0xc0,  //@@+++%@@@. 
  0xff, 0xfe, 0x00,  //@@@@@@@%.. 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0043 (C) , Width: 12 */
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x01, 0xff, 0x40,  //...+@@@@+... 
  0x0f, 0xeb, 0xf0,  //..@@@%%@@@.. 
  0x3d, 0x00, 0xb8,  //.@@+....%@%. 
  0x78, 0x00, 0x3c,  //+@%......@@. 
  0xb0, 0x00, 0x2d,  //%@.......%@+ 
  0xf0, 0x00, 0x00,  //@@.......... 
  0xf0, 0x00, 0x00,  //@@.......... 
  0xf0, 0x00, 0x00,  //@@.......... 
  0xf0, 0x00, 0x00,  //@@.......... 
  0xf0, 0x00, 0x00,  //@@.......... 
  0xb0, 0x00, 0x2d,  //%@.......%@+ 
  0x78, 0x00, 0x3c,  //+@%......@@. 
  0x3d, 0x00, 0xb8,  //.@@+....%@%. 
  0x0f, 0xab, 0xf0,  //..@@%%%@@@.. 
  0x02, 0xff, 0x40,  //...%@@@@+... 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 


  /*Unicode: U+0044 (D) , Width: 11 */
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0xff, 0xf8, 0x00,  //@@@@@@%.... 
  0xf5, 0xaf, 0x80,  //@@++%%@@%.. 
  0xf0, 0x02, 0xd0,  //@@.....%@+. 
  0xf0, 0x00, 0xf0,  //@@......@@. 
  0xf0, 0x00, 0x74,  //@@......+@+ 
  0xf0, 0x00, 0x38,  //@@.......@% 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x38,  //@@.......@% 
  0xf0, 0x00, 0x74,  //@@......+@+ 
  0xf0, 0x00, 0xf0,  //@@......@@. 
  0xf0, 0x03, 0xd0,  //@@.....@@+. 
  0xf5, 0xaf, 0x80,  //@@++%%@@%.. 
  0xff, 0xf8, 0x00,  //@@@@@@%.... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 


  /*Unicode: U+0045 (E) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0xff, 0xff, 0xd0,  //@@@@@@@@@+ 
  0xf5, 0x55, 0x40,  //@@+++++++. 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xff, 0xff, 0x40,  //@@@@@@@@+. 
  0xf5, 0x55, 0x00,  //@@++++++.. 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf5, 0x55, 0x40,  //@@+++++++. 
  0xff, 0xff, 0xd0,  //@@@@@@@@@+ 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0046 (F) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0xff, 0xff, 0xd0,  //@@@@@@@@@+ 
  0xf5, 0x55, 0x40,  //@@+++++++. 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xff, 0xff, 0x00,  //@@@@@@@@.. 
  0xf5, 0x55, 0x00,  //@@++++++.. 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0047 (G) , Width: 12 */
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x01, 0xff, 0x80,  //...+@@@@%... 
  0x0f, 0xea, 0xf4,  //..@@@%%%@@+. 
  0x3d, 0x00, 0x3c,  //.@@+.....@@. 
  0x78, 0x00, 0x1e,  //+@%......+@% 
  0xb0, 0x00, 0x05,  //%@........++ 
  0xf0, 0x00, 0x00,  //@@.......... 
  0xf0, 0x00, 0x00,  //@@.......... 
  0xf0, 0x05, 0x55,  //@@....++++++ 
  0xf0, 0x0b, 0xff,  //@@....%@@@@@ 
  0xf0, 0x00, 0x0f,  //@@........@@ 
  0xb4, 0x00, 0x0f,  //%@+.......@@ 
  0x78, 0x00, 0x0f,  //+@%.......@@ 
  0x2e, 0x00, 0x0f,  //.%@%......@@ 
  0x0b, 0xea, 0xfd,  //..%@@%%%@@@+ 
  0x01, 0xbf, 0xe0,  //...+%@@@@%.. 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 


  /*Unicode: U+0048 (H) , Width: 11 */
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xff, 0xff, 0xfc,  //@@@@@@@@@@@ 
  0xf5, 0x55, 0x7c,  //@@+++++++@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 


  /*Unicode: U+0049 (I) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+004a (J) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xb4, 0x0b, 0x80,  //%@+...%@% 
  0x3e, 0xaf, 0x00,  //.@@%%%@@. 
  0x0b, 0xf8, 0x00,  //..%@@@%.. 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+004b (K) , Width: 12 */
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0xf0, 0x00, 0xf4,  //@@......@@+. 
  0xf0, 0x03, 0xe0,  //@@.....@@%.. 
  0xf0, 0x0b, 0x80,  //@@....%@%... 
  0xf0, 0x2f, 0x00,  //@@...%@@.... 
  0xf0, 0x7c, 0x00,  //@@..+@@..... 
  0xf1, 0xf0, 0x00,  //@@.+@@...... 
  0xf7, 0xd0, 0x00,  //@@+@@+...... 
  0xff, 0xe0, 0x00,  //@@@@@%...... 
  0xfd, 0xf4, 0x00,  //@@@+@@+..... 
  0xf4, 0x3c, 0x00,  //@@+..@@..... 
  0xf0, 0x1f, 0x00,  //@@...+@@.... 
  0xf0, 0x0b, 0x80,  //@@....%@%... 
  0xf0, 0x03, 0xd0,  //@@.....@@+.. 
  0xf0, 0x00, 0xf0,  //@@......@@.. 
  0xf0, 0x00, 0x7c,  //@@......+@@. 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 


  /*Unicode: U+004c (L) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xfa, 0xaa, 0x80,  //@@%%%%%%% 
  0xff, 0xff, 0xc0,  //@@@@@@@@@ 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+004d (M) , Width: 15 */
  0x00, 0x00, 0x00, 0x00,  //............... 
  0x00, 0x00, 0x00, 0x00,  //............... 
  0x00, 0x00, 0x00, 0x00,  //............... 
  0x00, 0x00, 0x00, 0x00,  //............... 
  0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@ 
  0xfc, 0x00, 0x01, 0xfc,  //@@@........+@@@ 
  0xfe, 0x00, 0x02, 0xfc,  //@@@%.......%@@@ 
  0xff, 0x00, 0x03, 0xbc,  //@@@@.......@%@@ 
  0xf7, 0x40, 0x07, 0x7c,  //@@+@+.....+@+@@ 
  0xf3, 0xc0, 0x0f, 0x3c,  //@@.@@.....@@.@@ 
  0xf2, 0xc0, 0x1e, 0x3c,  //@@.%@....+@%.@@ 
  0xf1, 0xe0, 0x2c, 0x3c,  //@@.+@%...%@..@@ 
  0xf0, 0xf0, 0x3c, 0x3c,  //@@..@@...@@..@@ 
  0xf0, 0x74, 0x74, 0x3c,  //@@..+@+.+@+..@@ 
  0xf0, 0x38, 0xf0, 0x3c,  //@@...@%.@@...@@ 
  0xf0, 0x2d, 0xe0, 0x3c,  //@@...%@+@%...@@ 
  0xf0, 0x1f, 0xc0, 0x3c,  //@@...+@@@....@@ 
  0xf0, 0x0f, 0xc0, 0x3c,  //@@....@@@....@@ 
  0xf0, 0x0b, 0x40, 0x3c,  //@@....%@+....@@ 
  0x00, 0x00, 0x00, 0x00,  //............... 
  0x00, 0x00, 0x00, 0x00,  //............... 
  0x00, 0x00, 0x00, 0x00,  //............... 
  0x00, 0x00, 0x00, 0x00,  //............... 
  0x00, 0x00, 0x00, 0x00,  //............... 


  /*Unicode: U+004e (N) , Width: 11 */
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xfc, 0x00, 0x3c,  //@@@......@@ 
  0xfd, 0x00, 0x3c,  //@@@+.....@@ 
  0xff, 0x00, 0x3c,  //@@@@.....@@ 
  0xf7, 0x80, 0x3c,  //@@+@%....@@ 
  0xf3, 0xd0, 0x3c,  //@@.@@+...@@ 
  0xf0, 0xf0, 0x3c,  //@@..@@...@@ 
  0xf0, 0xb8, 0x3c,  //@@..%@%..@@ 
  0xf0, 0x3c, 0x3c,  //@@...@@..@@ 
  0xf0, 0x1f, 0x3c,  //@@...+@@.@@ 
  0xf0, 0x0b, 0x7c,  //@@....%@+@@ 
  0xf0, 0x03, 0xfc,  //@@.....@@@@ 
  0xf0, 0x01, 0xfc,  //@@.....+@@@ 
  0xf0, 0x00, 0xfc,  //@@......@@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 


  /*Unicode: U+004f (O) , Width: 12 */
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x01, 0xff, 0x40,  //...+@@@@+... 
  0x0f, 0xeb, 0xf0,  //..@@@%%@@@.. 
  0x2d, 0x00, 0x78,  //.%@+....+@%. 
  0x78, 0x00, 0x2d,  //+@%......%@+ 
  0xb0, 0x00, 0x0e,  //%@........@% 
  0xf0, 0x00, 0x0f,  //@@........@@ 
  0xf0, 0x00, 0x0f,  //@@........@@ 
  0xf0, 0x00, 0x0f,  //@@........@@ 
  0xf0, 0x00, 0x0f,  //@@........@@ 
  0xf0, 0x00, 0x0f,  //@@........@@ 
  0xb0, 0x00, 0x0e,  //%@........@% 
  0x78, 0x00, 0x2d,  //+@%......%@+ 
  0x3d, 0x00, 0x78,  //.@@+....+@%. 
  0x0f, 0xeb, 0xf0,  //..@@@%%@@@.. 
  0x01, 0xff, 0x40,  //...+@@@@+... 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 


  /*Unicode: U+0050 (P) , Width: 11 */
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0xff, 0xfe, 0x40,  //@@@@@@@%+.. 
  0xf5, 0x6b, 0xe0,  //@@+++%%@@%. 
  0xf0, 0x00, 0xf4,  //@@......@@+ 
  0xf0, 0x00, 0x78,  //@@......+@% 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x78,  //@@......+@% 
  0xf0, 0x01, 0xf0,  //@@.....+@@. 
  0xff, 0xff, 0xc0,  //@@@@@@@@@.. 
  0xf5, 0x54, 0x00,  //@@+++++.... 
  0xf0, 0x00, 0x00,  //@@......... 
  0xf0, 0x00, 0x00,  //@@......... 
  0xf0, 0x00, 0x00,  //@@......... 
  0xf0, 0x00, 0x00,  //@@......... 
  0xf0, 0x00, 0x00,  //@@......... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 


  /*Unicode: U+0051 (Q) , Width: 12 */
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x01, 0xff, 0x40,  //...+@@@@+... 
  0x0f, 0xeb, 0xf0,  //..@@@%%@@@.. 
  0x2d, 0x00, 0x78,  //.%@+....+@%. 
  0x78, 0x00, 0x2d,  //+@%......%@+ 
  0xb0, 0x00, 0x0e,  //%@........@% 
  0xf0, 0x00, 0x0f,  //@@........@@ 
  0xf0, 0x00, 0x0f,  //@@........@@ 
  0xf0, 0x00, 0x0f,  //@@........@@ 
  0xf0, 0x00, 0x0f,  //@@........@@ 
  0xf0, 0x00, 0x0f,  //@@........@@ 
  0xb0, 0x00, 0x0e,  //%@........@% 
  0x78, 0x00, 0x2d,  //+@%......%@+ 
  0x2d, 0x00, 0x7c,  //.%@+....+@@. 
  0x0f, 0xeb, 0xf0,  //..@@@%%@@@.. 
  0x01, 0xff, 0xf0,  //...+@@@@@@.. 
  0x00, 0x00, 0xbd,  //........%@@+ 
  0x00, 0x00, 0x1e,  //.........+@% 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 


  /*Unicode: U+0052 (R) , Width: 11 */
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0xff, 0xfe, 0x00,  //@@@@@@@%... 
  0xf5, 0x6f, 0xc0,  //@@+++%@@@.. 
  0xf0, 0x02, 0xe0,  //@@.....%@%. 
  0xf0, 0x00, 0xf0,  //@@......@@. 
  0xf0, 0x00, 0xf0,  //@@......@@. 
  0xf0, 0x00, 0xf0,  //@@......@@. 
  0xf0, 0x02, 0xe0,  //@@.....%@%. 
  0xf5, 0x6f, 0xc0,  //@@+++%@@@.. 
  0xff, 0xfe, 0x00,  //@@@@@@@%... 
  0xf0, 0x1f, 0x00,  //@@...+@@... 
  0xf0, 0x0f, 0x40,  //@@....@@+.. 
  0xf0, 0x07, 0xc0,  //@@....+@@.. 
  0xf0, 0x02, 0xe0,  //@@.....%@%. 
  0xf0, 0x00, 0xf0,  //@@......@@. 
  0xf0, 0x00, 0xbc,  //@@......%@@ 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 


  /*Unicode: U+0053 (S) , Width: 11 */
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x07, 0xfe, 0x40,  //..+@@@@%+.. 
  0x2f, 0xab, 0xe0,  //.%@@%%%@@%. 
  0xb8, 0x00, 0xf4,  //%@%.....@@+ 
  0xf0, 0x00, 0x38,  //@@.......@% 
  0xf0, 0x00, 0x14,  //@@.......++ 
  0xbc, 0x00, 0x00,  //%@@........ 
  0x2f, 0xd0, 0x00,  //.%@@@+..... 
  0x07, 0xff, 0x40,  //..+@@@@@+.. 
  0x00, 0x1b, 0xe0,  //.....+%@@%. 
  0x00, 0x00, 0xf8,  //........@@% 
  0x50, 0x00, 0x3c,  //++.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0x78, 0x00, 0xb8,  //+@%.....%@% 
  0x2f, 0xab, 0xf0,  //.%@@%%%@@@. 
  0x06, 0xff, 0x40,  //..+%@@@@+.. 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 


  /*Unicode: U+0054 (T) , Width: 12 */
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0xff, 0xff, 0xff,  //@@@@@@@@@@@@ 
  0x55, 0x7d, 0x55,  //+++++@@+++++ 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 


  /*Unicode: U+0055 (U) , Width: 11 */
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x3c,  //@@.......@@ 
  0xf0, 0x00, 0x78,  //@@......+@% 
  0x7c, 0x00, 0xf4,  //+@@.....@@+ 
  0x2f, 0xab, 0xe0,  //.%@@%%%@@%. 
  0x06, 0xfe, 0x40,  //..+%@@@%+.. 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 


  /*Unicode: U+0056 (V) , Width: 14 */
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0xb8, 0x00, 0x03, 0xc0,  //%@%........@@. 
  0x3c, 0x00, 0x0b, 0x80,  //.@@.......%@%. 
  0x3d, 0x00, 0x0f, 0x00,  //.@@+......@@.. 
  0x1e, 0x00, 0x1f, 0x00,  //.+@%.....+@@.. 
  0x0f, 0x00, 0x2d, 0x00,  //..@@.....%@+.. 
  0x0b, 0x40, 0x3c, 0x00,  //..%@+....@@... 
  0x07, 0x80, 0x78, 0x00,  //..+@%...+@%... 
  0x03, 0xc0, 0xb4, 0x00,  //...@@...%@+... 
  0x02, 0xd0, 0xf0, 0x00,  //...%@+..@@.... 
  0x00, 0xe1, 0xe0, 0x00,  //....@%.+@%.... 
  0x00, 0xf2, 0xc0, 0x00,  //....@@.%@..... 
  0x00, 0x77, 0xc0, 0x00,  //....+@+@@..... 
  0x00, 0x3f, 0x40, 0x00,  //.....@@@+..... 
  0x00, 0x2f, 0x00, 0x00,  //.....%@@...... 
  0x00, 0x1e, 0x00, 0x00,  //.....+@%...... 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 


  /*Unicode: U+0057 (W) , Width: 19 */
  0x00, 0x00, 0x00, 0x00, 0x00,  //................... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //................... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //................... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //................... 
  0x78, 0x00, 0xb4, 0x00, 0xf0,  //+@%.....%@+.....@@. 
  0x3c, 0x00, 0xf8, 0x00, 0xf0,  //.@@.....@@%.....@@. 
  0x3c, 0x00, 0xfc, 0x01, 0xe0,  //.@@.....@@@....+@%. 
  0x2d, 0x01, 0xfc, 0x02, 0xd0,  //.%@+...+@@@....%@+. 
  0x1e, 0x02, 0xde, 0x03, 0xc0,  //.+@%...%@+@%...@@.. 
  0x0f, 0x03, 0xcf, 0x03, 0xc0,  //..@@...@@.@@...@@.. 
  0x0f, 0x03, 0x8b, 0x07, 0x80,  //..@@...@%.%@..+@%.. 
  0x0b, 0x4b, 0x07, 0x47, 0x40,  //..%@+.%@..+@+.+@+.. 
  0x07, 0x8f, 0x03, 0x8b, 0x00,  //..+@%.@@...@%.%@... 
  0x03, 0xce, 0x03, 0xcf, 0x00,  //...@@.@%...@@.@@... 
  0x03, 0xdd, 0x02, 0xde, 0x00,  //...@@+@+...%@+@%... 
  0x02, 0xec, 0x00, 0xed, 0x00,  //...%@%@.....@%@+... 
  0x01, 0xfc, 0x00, 0xfc, 0x00,  //...+@@@.....@@@.... 
  0x00, 0xf4, 0x00, 0xbc, 0x00,  //....@@+.....%@@.... 
  0x00, 0xf0, 0x00, 0x78, 0x00,  //....@@......+@%.... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //................... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //................... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //................... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //................... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //................... 


  /*Unicode: U+0058 (X) , Width: 13 */
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x3d, 0x00, 0x0f, 0x00,  //.@@+......@@. 
  0x1f, 0x00, 0x2e, 0x00,  //.+@@.....%@%. 
  0x0b, 0x80, 0x7c, 0x00,  //..%@%...+@@.. 
  0x03, 0xc0, 0xf4, 0x00,  //...@@...@@+.. 
  0x01, 0xf2, 0xe0, 0x00,  //...+@@.%@%... 
  0x00, 0xfb, 0xc0, 0x00,  //....@@%@@.... 
  0x00, 0x3f, 0x40, 0x00,  //.....@@@+.... 
  0x00, 0x2f, 0x00, 0x00,  //.....%@@..... 
  0x00, 0x7f, 0x40, 0x00,  //....+@@@+.... 
  0x00, 0xfb, 0xc0, 0x00,  //....@@%@@.... 
  0x02, 0xe2, 0xe0, 0x00,  //...%@%.%@%... 
  0x03, 0xc0, 0xf4, 0x00,  //...@@...@@+.. 
  0x0f, 0x40, 0x7c, 0x00,  //..@@+...+@@.. 
  0x1f, 0x00, 0x2e, 0x00,  //.+@@.....%@%. 
  0x3c, 0x00, 0x0f, 0x40,  //.@@.......@@+ 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 


  /*Unicode: U+0059 (Y) , Width: 12 */
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0xf4, 0x00, 0x1f,  //@@+......+@@ 
  0x7c, 0x00, 0x3c,  //+@@......@@. 
  0x3d, 0x00, 0x78,  //.@@+....+@%. 
  0x0f, 0x00, 0xf0,  //..@@....@@.. 
  0x0b, 0x42, 0xe0,  //..%@+..%@%.. 
  0x03, 0xc3, 0xc0,  //...@@..@@... 
  0x02, 0xdb, 0x40,  //...%@+%@+... 
  0x00, 0xff, 0x00,  //....@@@@.... 
  0x00, 0x7d, 0x00,  //....+@@+.... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x3c, 0x00,  //.....@@..... 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 


  /*Unicode: U+005a (Z) , Width: 11 */
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0xff, 0xff, 0xfc,  //@@@@@@@@@@@ 
  0x55, 0x55, 0xfc,  //++++++++@@@ 
  0x00, 0x00, 0xf0,  //........@@. 
  0x00, 0x03, 0xd0,  //.......@@+. 
  0x00, 0x0b, 0xc0,  //......%@@.. 
  0x00, 0x1f, 0x00,  //.....+@@... 
  0x00, 0x3d, 0x00,  //.....@@+... 
  0x00, 0xb8, 0x00,  //....%@%.... 
  0x01, 0xf0, 0x00,  //...+@@..... 
  0x03, 0xc0, 0x00,  //...@@...... 
  0x0f, 0x80, 0x00,  //..@@%...... 
  0x2f, 0x00, 0x00,  //.%@@....... 
  0x3c, 0x00, 0x00,  //.@@........ 
  0xfd, 0x55, 0x54,  //@@@++++++++ 
  0xff, 0xff, 0xfc,  //@@@@@@@@@@@ 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 


  /*Unicode: U+005b ([) , Width: 4 */
  0x00,  //.... 
  0x00,  //.... 
  0x55,  //++++ 
  0xff,  //@@@@ 
  0xf0,  //@@.. 
  0xf0,  //@@.. 
  0xf0,  //@@.. 
  0xf0,  //@@.. 
  0xf0,  //@@.. 
  0xf0,  //@@.. 
  0xf0,  //@@.. 
  0xf0,  //@@.. 
  0xf0,  //@@.. 
  0xf0,  //@@.. 
  0xf0,  //@@.. 
  0xf0,  //@@.. 
  0xf0,  //@@.. 
  0xf0,  //@@.. 
  0xf0,  //@@.. 
  0xf0,  //@@.. 
  0xf5,  //@@++ 
  0xff,  //@@@@ 
  0x00,  //.... 
  0x00,  //.... 


  /*Unicode: U+005c (\) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x74, 0x00, 0x00,  //+@+...... 
  0x3c, 0x00, 0x00,  //.@@...... 
  0x2c, 0x00, 0x00,  //.%@...... 
  0x0e, 0x00, 0x00,  //..@%..... 
  0x0f, 0x00, 0x00,  //..@@..... 
  0x07, 0x40, 0x00,  //..+@+.... 
  0x03, 0x80, 0x00,  //...@%.... 
  0x02, 0xc0, 0x00,  //...%@.... 
  0x01, 0xe0, 0x00,  //...+@%... 
  0x00, 0xf0, 0x00,  //....@@... 
  0x00, 0xb4, 0x00,  //....%@+.. 
  0x00, 0x38, 0x00,  //.....@%.. 
  0x00, 0x2c, 0x00,  //.....%@.. 
  0x00, 0x1d, 0x00,  //.....+@+. 
  0x00, 0x0f, 0x00,  //......@@. 
  0x00, 0x0b, 0x40,  //......%@+ 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+005d (]) , Width: 4 */
  0x00,  //.... 
  0x00,  //.... 
  0x55,  //++++ 
  0xff,  //@@@@ 
  0x0f,  //..@@ 
  0x0f,  //..@@ 
  0x0f,  //..@@ 
  0x0f,  //..@@ 
  0x0f,  //..@@ 
  0x0f,  //..@@ 
  0x0f,  //..@@ 
  0x0f,  //..@@ 
  0x0f,  //..@@ 
  0x0f,  //..@@ 
  0x0f,  //..@@ 
  0x0f,  //..@@ 
  0x0f,  //..@@ 
  0x0f,  //..@@ 
  0x0f,  //..@@ 
  0x0f,  //..@@ 
  0x5f,  //++@@ 
  0xff,  //@@@@ 
  0x00,  //.... 
  0x00,  //.... 


  /*Unicode: U+005e (^) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x01, 0xc0,  //...+@... 
  0x03, 0xe0,  //...@@%.. 
  0x07, 0xf0,  //..+@@@.. 
  0x0f, 0x38,  //..@@.@%. 
  0x0d, 0x2c,  //..@+.%@. 
  0x2c, 0x1d,  //.%@..+@+ 
  0x38, 0x0f,  //.@%...@@ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+005f (_) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x55, 0x55, 0x40,  //+++++++++ 
  0xff, 0xff, 0xc0,  //@@@@@@@@@ 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0060 (`) , Width: 5 */
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x3c, 0x00,  //.@@.. 
  0x0f, 0x00,  //..@@. 
  0x03, 0x80,  //...@% 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 


  /*Unicode: U+0061 (a) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x0b, 0xf8, 0x00,  //..%@@@%... 
  0x7e, 0xaf, 0x40,  //+@@%%%@@+. 
  0xf0, 0x07, 0x80,  //@@....+@%. 
  0x00, 0x03, 0xc0,  //.......@@. 
  0x0b, 0xff, 0xc0,  //..%@@@@@@. 
  0x3f, 0xa7, 0xc0,  //.@@@%%+@@. 
  0xf4, 0x03, 0xc0,  //@@+....@@. 
  0xf0, 0x03, 0xc0,  //@@.....@@. 
  0xf0, 0x0b, 0xc0,  //@@....%@@. 
  0x7e, 0xbf, 0xc0,  //+@@%%@@@@. 
  0x1f, 0xe3, 0xc0,  //.+@@@%.@@. 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0062 (b) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf3, 0xf8, 0x00,  //@@.@@@%.. 
  0xfe, 0xbf, 0x00,  //@@@%%@@@. 
  0xf4, 0x0b, 0x40,  //@@+...%@+ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf4, 0x0b, 0x40,  //@@+...%@+ 
  0xfe, 0xbf, 0x00,  //@@@%%@@@. 
  0xf3, 0xf8, 0x00,  //@@.@@@%.. 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0063 (c) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x07, 0xfd, 0x00,  //..+@@@@+.. 
  0x2f, 0xaf, 0x80,  //.%@@%%@@%. 
  0x7c, 0x03, 0xc0,  //+@@....@@. 
  0xb0, 0x01, 0xd0,  //%@.....+@+ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xb0, 0x00, 0x80,  //%@......%. 
  0x78, 0x03, 0xc0,  //+@%....@@. 
  0x2f, 0xaf, 0x80,  //.%@@%%@@%. 
  0x07, 0xfd, 0x00,  //..+@@@@+.. 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0064 (d) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x0b, 0xf7, 0xc0,  //..%@@@+@@ 
  0x3f, 0xaf, 0xc0,  //.@@@%%@@@ 
  0x78, 0x07, 0xc0,  //+@%...+@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0x78, 0x07, 0xc0,  //+@%...+@@ 
  0x3f, 0xaf, 0xc0,  //.@@@%%@@@ 
  0x0b, 0xf7, 0xc0,  //..%@@@+@@ 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0065 (e) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x07, 0xf8, 0x00,  //..+@@@%.. 
  0x2f, 0xaf, 0x00,  //.%@@%%@@. 
  0x78, 0x07, 0x80,  //+@%...+@% 
  0xb0, 0x03, 0xc0,  //%@.....@@ 
  0xf5, 0x57, 0xc0,  //@@+++++@@ 
  0xff, 0xff, 0xc0,  //@@@@@@@@@ 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0x7c, 0x02, 0x40,  //+@@....%+ 
  0x2f, 0xaf, 0x40,  //.%@@%%@@+ 
  0x07, 0xf9, 0x00,  //..+@@@%+. 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0066 (f) , Width: 7 */
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x50,  //....++. 
  0x03, 0xf4,  //...@@@+ 
  0x0b, 0x40,  //..%@+.. 
  0x0f, 0x00,  //..@@... 
  0x0f, 0x00,  //..@@... 
  0xff, 0xf0,  //@@@@@@. 
  0x5f, 0x50,  //++@@++. 
  0x0f, 0x00,  //..@@... 
  0x0f, 0x00,  //..@@... 
  0x0f, 0x00,  //..@@... 
  0x0f, 0x00,  //..@@... 
  0x0f, 0x00,  //..@@... 
  0x0f, 0x00,  //..@@... 
  0x0f, 0x00,  //..@@... 
  0x0f, 0x00,  //..@@... 
  0x0f, 0x00,  //..@@... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 


  /*Unicode: U+0067 (g) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x0b, 0xf7, 0xc0,  //..%@@@+@@ 
  0x3f, 0xaf, 0xc0,  //.@@@%%@@@ 
  0x78, 0x07, 0xc0,  //+@%...+@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0x78, 0x07, 0xc0,  //+@%...+@@ 
  0x3f, 0xaf, 0xc0,  //.@@@%%@@@ 
  0x0b, 0xf7, 0xc0,  //..%@@@+@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x20, 0x07, 0x80,  //.%....+@% 
  0x3e, 0xaf, 0x00,  //.@@%%%@@. 
  0x0b, 0xf8, 0x00,  //..%@@@%.. 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0068 (h) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf2, 0xfd, 0x00,  //@@.%@@@+. 
  0xff, 0xaf, 0x40,  //@@@@%%@@+ 
  0xf4, 0x07, 0x80,  //@@+...+@% 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0069 (i) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xe0,  //@% 
  0x50,  //++ 
  0x00,  //.. 
  0x00,  //.. 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+006a (j) , Width: 3 */
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x38,  //.@% 
  0x14,  //.++ 
  0x00,  //... 
  0x00,  //... 
  0x3c,  //.@@ 
  0x3c,  //.@@ 
  0x3c,  //.@@ 
  0x3c,  //.@@ 
  0x3c,  //.@@ 
  0x3c,  //.@@ 
  0x3c,  //.@@ 
  0x3c,  //.@@ 
  0x3c,  //.@@ 
  0x3c,  //.@@ 
  0x3c,  //.@@ 
  0x3c,  //.@@ 
  0x3c,  //.@@ 
  0xf8,  //@@% 
  0xe0,  //@%. 
  0x00,  //... 


  /*Unicode: U+006b (k) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x00, 0x00,  //@@........ 
  0xf0, 0x0f, 0x00,  //@@....@@.. 
  0xf0, 0x3d, 0x00,  //@@...@@+.. 
  0xf0, 0xf4, 0x00,  //@@..@@+... 
  0xf3, 0xd0, 0x00,  //@@.@@+.... 
  0xff, 0x80, 0x00,  //@@@@%..... 
  0xff, 0xc0, 0x00,  //@@@@@..... 
  0xf9, 0xf0, 0x00,  //@@%+@@.... 
  0xf0, 0xb8, 0x00,  //@@..%@%... 
  0xf0, 0x3d, 0x00,  //@@...@@+.. 
  0xf0, 0x0f, 0x00,  //@@....@@.. 
  0xf0, 0x07, 0xc0,  //@@....+@@. 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+006c (l) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+006d (m) , Width: 16 */
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0xf2, 0xfd, 0x0b, 0xf4,  //@@.%@@@+..%@@@+. 
  0xfe, 0xaf, 0xba, 0xbd,  //@@@%%%@@%@%%%@@+ 
  0xf4, 0x07, 0xd0, 0x1e,  //@@+...+@@+...+@% 
  0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@ 
  0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@ 
  0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@ 
  0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@ 
  0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@ 
  0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@ 
  0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@ 
  0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 


  /*Unicode: U+006e (n) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0xf2, 0xfd, 0x00,  //@@.%@@@+. 
  0xff, 0xaf, 0x40,  //@@@@%%@@+ 
  0xf4, 0x07, 0x80,  //@@+...+@% 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+006f (o) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x07, 0xfd, 0x00,  //..+@@@@+.. 
  0x2f, 0xaf, 0x80,  //.%@@%%@@%. 
  0x7c, 0x03, 0xd0,  //+@@....@@+ 
  0xb4, 0x01, 0xe0,  //%@+....+@% 
  0xf0, 0x00, 0xf0,  //@@......@@ 
  0xf0, 0x00, 0xf0,  //@@......@@ 
  0xf0, 0x00, 0xf0,  //@@......@@ 
  0xb4, 0x01, 0xe0,  //%@+....+@% 
  0x7c, 0x03, 0xd0,  //+@@....@@+ 
  0x2f, 0xaf, 0x80,  //.%@@%%@@%. 
  0x07, 0xfd, 0x00,  //..+@@@@+.. 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0070 (p) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0xf7, 0xf8, 0x00,  //@@+@@@%.. 
  0xfe, 0xbf, 0x00,  //@@@%%@@@. 
  0xf4, 0x0b, 0x40,  //@@+...%@+ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x0b, 0x40,  //@@....%@+ 
  0xfe, 0xbf, 0x00,  //@@@%%@@@. 
  0xf7, 0xf8, 0x00,  //@@+@@@%.. 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0xf0, 0x00, 0x00,  //@@....... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0071 (q) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x0b, 0xf7, 0xc0,  //..%@@@+@@ 
  0x3f, 0xaf, 0xc0,  //.@@@%%@@@ 
  0x78, 0x03, 0xc0,  //+@%....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0x78, 0x03, 0xc0,  //+@%....@@ 
  0x3f, 0xaf, 0xc0,  //.@@@%%@@@ 
  0x0b, 0xf7, 0xc0,  //..%@@@+@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x03, 0xc0,  //.......@@ 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0072 (r) , Width: 6 */
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0xf7, 0xd0,  //@@+@@+ 
  0xfe, 0x90,  //@@@%%+ 
  0xf4, 0x00,  //@@+... 
  0xf0, 0x00,  //@@.... 
  0xf0, 0x00,  //@@.... 
  0xf0, 0x00,  //@@.... 
  0xf0, 0x00,  //@@.... 
  0xf0, 0x00,  //@@.... 
  0xf0, 0x00,  //@@.... 
  0xf0, 0x00,  //@@.... 
  0xf0, 0x00,  //@@.... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 


  /*Unicode: U+0073 (s) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x0b, 0xf8, 0x00,  //..%@@@%.. 
  0x7e, 0xaf, 0x00,  //+@@%%%@@. 
  0xf0, 0x07, 0x80,  //@@....+@% 
  0xf0, 0x01, 0x40,  //@@.....++ 
  0x7e, 0x40, 0x00,  //+@@%+.... 
  0x0b, 0xfd, 0x00,  //..%@@@@+. 
  0x00, 0x1f, 0x40,  //.....+@@+ 
  0x50, 0x03, 0xc0,  //++.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0x3e, 0xaf, 0x40,  //.@@%%%@@+ 
  0x0b, 0xf8, 0x00,  //..%@@@%.. 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0074 (t) , Width: 6 */
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x05, 0x00,  //..++.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0xff, 0xf0,  //@@@@@@ 
  0x5f, 0x50,  //++@@++ 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0b, 0xa0,  //..%@%% 
  0x03, 0xf0,  //...@@@ 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 


  /*Unicode: U+0075 (u) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x03, 0xc0,  //@@.....@@ 
  0xf0, 0x07, 0xc0,  //@@....+@@ 
  0x7e, 0xbf, 0xc0,  //+@@%%@@@@ 
  0x1f, 0xe3, 0xc0,  //.+@@@%.@@ 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0076 (v) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x74, 0x01, 0xe0,  //+@+....+@% 
  0x3c, 0x02, 0xc0,  //.@@....%@. 
  0x2c, 0x03, 0xc0,  //.%@....@@. 
  0x1d, 0x07, 0x80,  //.+@+..+@%. 
  0x0f, 0x0b, 0x00,  //..@@..%@.. 
  0x0b, 0x0f, 0x00,  //..%@..@@.. 
  0x07, 0x5d, 0x00,  //..+@++@+.. 
  0x03, 0xec, 0x00,  //...@@%@... 
  0x02, 0xf8, 0x00,  //...%@@%... 
  0x00, 0xf4, 0x00,  //....@@+... 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0077 (w) , Width: 16 */
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x74, 0x03, 0xc0, 0x2c,  //+@+....@@....%@. 
  0x38, 0x07, 0xc0, 0x3c,  //.@%...+@@....@@. 
  0x3c, 0x0b, 0xd0, 0x38,  //.@@...%@@+...@%. 
  0x2d, 0x0e, 0xe0, 0x74,  //.%@+..@%@%..+@+. 
  0x0e, 0x1c, 0xb0, 0xb0,  //..@%.+@.%@..%@.. 
  0x0f, 0x2c, 0x74, 0xe0,  //..@@.%@.+@+.@%.. 
  0x0b, 0x38, 0x39, 0xd0,  //..%@.@%..@%+@+.. 
  0x07, 0xb4, 0x2e, 0xc0,  //..+@%@+..%@%@... 
  0x03, 0xf0, 0x1f, 0xc0,  //...@@@...+@@@... 
  0x03, 0xe0, 0x0f, 0x40,  //...@@%....@@+... 
  0x01, 0xd0, 0x0b, 0x00,  //...+@+....%@.... 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 
  0x00, 0x00, 0x00, 0x00,  //................ 


  /*Unicode: U+0078 (x) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x3c, 0x02, 0xd0,  //.@@....%@+ 
  0x1e, 0x07, 0xc0,  //.+@%..+@@. 
  0x0f, 0x0f, 0x00,  //..@@..@@.. 
  0x03, 0xed, 0x00,  //...@@%@+.. 
  0x01, 0xfc, 0x00,  //...+@@@... 
  0x00, 0xf4, 0x00,  //....@@+... 
  0x02, 0xfc, 0x00,  //...%@@@... 
  0x03, 0xde, 0x00,  //...@@+@%.. 
  0x0f, 0x0f, 0x40,  //..@@..@@+. 
  0x2e, 0x03, 0xc0,  //.%@%...@@. 
  0x3c, 0x02, 0xe0,  //.@@....%@% 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0079 (y) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x78, 0x01, 0xe0,  //+@%....+@% 
  0x3c, 0x02, 0xd0,  //.@@....%@+ 
  0x2d, 0x03, 0xc0,  //.%@+...@@. 
  0x1e, 0x07, 0x80,  //.+@%..+@%. 
  0x0f, 0x0b, 0x00,  //..@@..%@.. 
  0x0b, 0x4f, 0x00,  //..%@+.@@.. 
  0x03, 0x9d, 0x00,  //...@%+@+.. 
  0x03, 0xec, 0x00,  //...@@%@... 
  0x01, 0xf8, 0x00,  //...+@@%... 
  0x00, 0xf4, 0x00,  //....@@+... 
  0x00, 0xf0, 0x00,  //....@@.... 
  0x00, 0xe0, 0x00,  //....@%.... 
  0x02, 0xd0, 0x00,  //...%@+.... 
  0x2f, 0x80, 0x00,  //.%@@%..... 
  0x3e, 0x00, 0x00,  //.@@%...... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+007a (z) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0xff, 0xff, 0xc0,  //@@@@@@@@@ 
  0x55, 0x5f, 0xc0,  //++++++@@@ 
  0x00, 0x1f, 0x00,  //.....+@@. 
  0x00, 0x3c, 0x00,  //.....@@.. 
  0x00, 0xf4, 0x00,  //....@@+.. 
  0x02, 0xe0, 0x00,  //...%@%... 
  0x07, 0xc0, 0x00,  //..+@@.... 
  0x1f, 0x00, 0x00,  //.+@@..... 
  0x3d, 0x00, 0x00,  //.@@+..... 
  0xfd, 0x55, 0x40,  //@@@++++++ 
  0xff, 0xff, 0xc0,  //@@@@@@@@@ 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+007b ({) , Width: 6 */
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x10,  //.....+ 
  0x01, 0xf0,  //...+@@ 
  0x07, 0x80,  //..+@%. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x1e, 0x00,  //.+@%.. 
  0xbc, 0x00,  //%@@... 
  0xf8, 0x00,  //@@%... 
  0x2d, 0x00,  //.%@+.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0b, 0x40,  //..%@+. 
  0x03, 0xd0,  //...@@+ 
  0x00, 0xb0,  //....%@ 
  0x00, 0x00,  //...... 


  /*Unicode: U+007c (|) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0xf0,  //@@ 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+007d (}) , Width: 6 */
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x40, 0x00,  //+..... 
  0xf4, 0x00,  //@@+... 
  0x3c, 0x00,  //.@@... 
  0x1e, 0x00,  //.+@%.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0b, 0x00,  //..%@.. 
  0x03, 0xe0,  //...@@% 
  0x02, 0xf0,  //...%@@ 
  0x0b, 0x80,  //..%@%. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0f, 0x00,  //..@@.. 
  0x0e, 0x00,  //..@%.. 
  0x1d, 0x00,  //.+@+.. 
  0x7c, 0x00,  //+@@... 
  0xe0, 0x00,  //@%.... 
  0x00, 0x00,  //...... 


  /*Unicode: U+007e (~) , Width: 12 */
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x1f, 0xc0, 0x0e,  //.+@@@.....@% 
  0x7e, 0xf4, 0x1e,  //+@@%@@+..+@% 
  0xf0, 0x2e, 0xbc,  //@@...%@%%@@. 
  0xa0, 0x07, 0xf4,  //%%....+@@@+. 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 


};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t roboto24_glyph_dsc[] = 
{
  {.w_px = 7,	.glyph_index = 0},	/*Unicode: U+0020 ( )*/
  {.w_px = 2,	.glyph_index = 48},	/*Unicode: U+0021 (!)*/
  {.w_px = 4,	.glyph_index = 72},	/*Unicode: U+0022 (")*/
  {.w_px = 12,	.glyph_index = 96},	/*Unicode: U+0023 (#)*/
  {.w_px = 10,	.glyph_index = 168},	/*Unicode: U+0024 ($)*/
  {.w_px = 14,	.glyph_index = 240},	/*Unicode: U+0025 (%)*/
  {.w_px = 12,	.glyph_index = 336},	/*Unicode: U+0026 (&)*/
  {.w_px = 2,	.glyph_index = 408},	/*Unicode: U+0027 (')*/
  {.w_px = 6,	.glyph_index = 432},	/*Unicode: U+0028 (()*/
  {.w_px = 6,	.glyph_index = 480},	/*Unicode: U+0029 ())*/
  {.w_px = 10,	.glyph_index = 528},	/*Unicode: U+002a (*)*/
  {.w_px = 10,	.glyph_index = 600},	/*Unicode: U+002b (+)*/
  {.w_px = 3,	.glyph_index = 672},	/*Unicode: U+002c (,)*/
  {.w_px = 5,	.glyph_index = 696},	/*Unicode: U+002d (-)*/
  {.w_px = 2,	.glyph_index = 744},	/*Unicode: U+002e (.)*/
  {.w_px = 8,	.glyph_index = 768},	/*Unicode: U+002f (/)*/
  {.w_px = 9,	.glyph_index = 816},	/*Unicode: U+0030 (0)*/
  {.w_px = 6,	.glyph_index = 888},	/*Unicode: U+0031 (1)*/
  {.w_px = 10,	.glyph_index = 936},	/*Unicode: U+0032 (2)*/
  {.w_px = 9,	.glyph_index = 1008},	/*Unicode: U+0033 (3)*/
  {.w_px = 11,	.glyph_index = 1080},	/*Unicode: U+0034 (4)*/
  {.w_px = 10,	.glyph_index = 1152},	/*Unicode: U+0035 (5)*/
  {.w_px = 10,	.glyph_index = 1224},	/*Unicode: U+0036 (6)*/
  {.w_px = 10,	.glyph_index = 1296},	/*Unicode: U+0037 (7)*/
  {.w_px = 10,	.glyph_index = 1368},	/*Unicode: U+0038 (8)*/
  {.w_px = 9,	.glyph_index = 1440},	/*Unicode: U+0039 (9)*/
  {.w_px = 2,	.glyph_index = 1512},	/*Unicode: U+003a (:)*/
  {.w_px = 3,	.glyph_index = 1536},	/*Unicode: U+003b (;)*/
  {.w_px = 9,	.glyph_index = 1560},	/*Unicode: U+003c (<)*/
  {.w_px = 9,	.glyph_index = 1632},	/*Unicode: U+003d (=)*/
  {.w_px = 9,	.glyph_index = 1704},	/*Unicode: U+003e (>)*/
  {.w_px = 8,	.glyph_index = 1776},	/*Unicode: U+003f (?)*/
  {.w_px = 17,	.glyph_index = 1824},	/*Unicode: U+0040 (@)*/
  {.w_px = 14,	.glyph_index = 1944},	/*Unicode: U+0041 (A)*/
  {.w_px = 10,	.glyph_index = 2040},	/*Unicode: U+0042 (B)*/
  {.w_px = 12,	.glyph_index = 2112},	/*Unicode: U+0043 (C)*/
  {.w_px = 11,	.glyph_index = 2184},	/*Unicode: U+0044 (D)*/
  {.w_px = 10,	.glyph_index = 2256},	/*Unicode: U+0045 (E)*/
  {.w_px = 10,	.glyph_index = 2328},	/*Unicode: U+0046 (F)*/
  {.w_px = 12,	.glyph_index = 2400},	/*Unicode: U+0047 (G)*/
  {.w_px = 11,	.glyph_index = 2472},	/*Unicode: U+0048 (H)*/
  {.w_px = 2,	.glyph_index = 2544},	/*Unicode: U+0049 (I)*/
  {.w_px = 9,	.glyph_index = 2568},	/*Unicode: U+004a (J)*/
  {.w_px = 12,	.glyph_index = 2640},	/*Unicode: U+004b (K)*/
  {.w_px = 9,	.glyph_index = 2712},	/*Unicode: U+004c (L)*/
  {.w_px = 15,	.glyph_index = 2784},	/*Unicode: U+004d (M)*/
  {.w_px = 11,	.glyph_index = 2880},	/*Unicode: U+004e (N)*/
  {.w_px = 12,	.glyph_index = 2952},	/*Unicode: U+004f (O)*/
  {.w_px = 11,	.glyph_index = 3024},	/*Unicode: U+0050 (P)*/
  {.w_px = 12,	.glyph_index = 3096},	/*Unicode: U+0051 (Q)*/
  {.w_px = 11,	.glyph_index = 3168},	/*Unicode: U+0052 (R)*/
  {.w_px = 11,	.glyph_index = 3240},	/*Unicode: U+0053 (S)*/
  {.w_px = 12,	.glyph_index = 3312},	/*Unicode: U+0054 (T)*/
  {.w_px = 11,	.glyph_index = 3384},	/*Unicode: U+0055 (U)*/
  {.w_px = 14,	.glyph_index = 3456},	/*Unicode: U+0056 (V)*/
  {.w_px = 19,	.glyph_index = 3552},	/*Unicode: U+0057 (W)*/
  {.w_px = 13,	.glyph_index = 3672},	/*Unicode: U+0058 (X)*/
  {.w_px = 12,	.glyph_index = 3768},	/*Unicode: U+0059 (Y)*/
  {.w_px = 11,	.glyph_index = 3840},	/*Unicode: U+005a (Z)*/
  {.w_px = 4,	.glyph_index = 3912},	/*Unicode: U+005b ([)*/
  {.w_px = 9,	.glyph_index = 3936},	/*Unicode: U+005c (\)*/
  {.w_px = 4,	.glyph_index = 4008},	/*Unicode: U+005d (])*/
  {.w_px = 8,	.glyph_index = 4032},	/*Unicode: U+005e (^)*/
  {.w_px = 9,	.glyph_index = 4080},	/*Unicode: U+005f (_)*/
  {.w_px = 5,	.glyph_index = 4152},	/*Unicode: U+0060 (`)*/
  {.w_px = 10,	.glyph_index = 4200},	/*Unicode: U+0061 (a)*/
  {.w_px = 9,	.glyph_index = 4272},	/*Unicode: U+0062 (b)*/
  {.w_px = 10,	.glyph_index = 4344},	/*Unicode: U+0063 (c)*/
  {.w_px = 9,	.glyph_index = 4416},	/*Unicode: U+0064 (d)*/
  {.w_px = 9,	.glyph_index = 4488},	/*Unicode: U+0065 (e)*/
  {.w_px = 7,	.glyph_index = 4560},	/*Unicode: U+0066 (f)*/
  {.w_px = 9,	.glyph_index = 4608},	/*Unicode: U+0067 (g)*/
  {.w_px = 9,	.glyph_index = 4680},	/*Unicode: U+0068 (h)*/
  {.w_px = 2,	.glyph_index = 4752},	/*Unicode: U+0069 (i)*/
  {.w_px = 3,	.glyph_index = 4776},	/*Unicode: U+006a (j)*/
  {.w_px = 10,	.glyph_index = 4800},	/*Unicode: U+006b (k)*/
  {.w_px = 2,	.glyph_index = 4872},	/*Unicode: U+006c (l)*/
  {.w_px = 16,	.glyph_index = 4896},	/*Unicode: U+006d (m)*/
  {.w_px = 9,	.glyph_index = 4992},	/*Unicode: U+006e (n)*/
  {.w_px = 10,	.glyph_index = 5064},	/*Unicode: U+006f (o)*/
  {.w_px = 9,	.glyph_index = 5136},	/*Unicode: U+0070 (p)*/
  {.w_px = 9,	.glyph_index = 5208},	/*Unicode: U+0071 (q)*/
  {.w_px = 6,	.glyph_index = 5280},	/*Unicode: U+0072 (r)*/
  {.w_px = 9,	.glyph_index = 5328},	/*Unicode: U+0073 (s)*/
  {.w_px = 6,	.glyph_index = 5400},	/*Unicode: U+0074 (t)*/
  {.w_px = 9,	.glyph_index = 5448},	/*Unicode: U+0075 (u)*/
  {.w_px = 10,	.glyph_index = 5520},	/*Unicode: U+0076 (v)*/
  {.w_px = 16,	.glyph_index = 5592},	/*Unicode: U+0077 (w)*/
  {.w_px = 10,	.glyph_index = 5688},	/*Unicode: U+0078 (x)*/
  {.w_px = 10,	.glyph_index = 5760},	/*Unicode: U+0079 (y)*/
  {.w_px = 9,	.glyph_index = 5832},	/*Unicode: U+007a (z)*/
  {.w_px = 6,	.glyph_index = 5904},	/*Unicode: U+007b ({)*/
  {.w_px = 2,	.glyph_index = 5952},	/*Unicode: U+007c (|)*/
  {.w_px = 6,	.glyph_index = 5976},	/*Unicode: U+007d (})*/
  {.w_px = 12,	.glyph_index = 6024},	/*Unicode: U+007e (~)*/
};

lv_font_t roboto24 = 
{
    .unicode_first = 32,	/*First Unicode letter in this font*/
    .unicode_last = 126,	/*Last Unicode letter in this font*/
    .h_px = 24,				/*Font height in pixels*/
    .glyph_bitmap = roboto24_glyph_bitmap,	/*Bitmap of glyphs*/
    .glyph_dsc = roboto24_glyph_dsc,		/*Description of glyphs*/
    .glyph_cnt = 95,			/*Number of glyphs in the font*/
    .unicode_list = NULL,	/*Every character in the font from 'unicode_first' to 'unicode_last'*/
    .get_bitmap = lv_font_get_bitmap_continuous,	/*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,	/*Function pointer to get glyph's width*/
    .bpp = 2,				/*Bit per pixel*/
    .monospace = 0,				/*Fix width (0: if not used)*/
    .next_page = NULL,		/*Pointer to a font extension*/
};