
#include "lv_font.h"

/***********************************************************************************
 * Roboto-Regular.ttf 20 px Font in U+0020 ( ) .. U+007e (~)  range with 2 bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t roboto20_glyph_bitmap[] = 
{
  /*Unicode: U+0020 ( ) , Width: 6 */
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 


  /*Unicode: U+0021 (!) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0x00,  //.. 
  0x00,  //.. 
  0xd0,  //@+ 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+0022 (") , Width: 4 */
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0xee,  //@%@% 
  0xdd,  //@+@+ 
  0xdd,  //@+@+ 
  0xdd,  //@+@+ 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 


  /*Unicode: U+0023 (#) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x02, 0x83, 0x40,  //...%%..@+ 
  0x03, 0x43, 0x00,  //...@+..@. 
  0x03, 0x07, 0x00,  //...@..+@. 
  0xff, 0xff, 0xc0,  //@@@@@@@@@ 
  0x0e, 0x0e, 0x00,  //..@%..@%. 
  0x0d, 0x0c, 0x00,  //..@+..@.. 
  0x0c, 0x1c, 0x00,  //..@..+@.. 
  0xff, 0xff, 0xc0,  //@@@@@@@@@ 
  0x2c, 0x38, 0x00,  //.%@..@%.. 
  0x28, 0x34, 0x00,  //.%%..@+.. 
  0x34, 0x30, 0x00,  //.@+..@... 
  0x30, 0x70, 0x00,  //.@..+@... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0024 ($) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x02, 0xc0,  //...%@... 
  0x02, 0xc0,  //...%@... 
  0x1f, 0xf4,  //.+@@@@+. 
  0x38, 0x2c,  //.@%..%@. 
  0x70, 0x0d,  //+@....@+ 
  0x70, 0x04,  //+@....+. 
  0x3d, 0x00,  //.@@+.... 
  0x0b, 0xe0,  //..%@@%.. 
  0x00, 0xbc,  //....%@@. 
  0x00, 0x1d,  //.....+@+ 
  0xe0, 0x0d,  //@%....@+ 
  0xb0, 0x2d,  //%@...%@+ 
  0x3f, 0xf8,  //.@@@@@%. 
  0x02, 0xd0,  //...%@+.. 
  0x02, 0xc0,  //...%@... 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0025 (%) , Width: 11 */
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x3f, 0x00, 0x00,  //.@@@....... 
  0xf7, 0xc0, 0x00,  //@@+@@...... 
  0xe2, 0xc3, 0x00,  //@%.%@..@... 
  0xe2, 0xca, 0x00,  //@%.%@.%%... 
  0x7f, 0x4c, 0x00,  //+@@@+.@.... 
  0x00, 0x30, 0x00,  //.....@..... 
  0x00, 0x67, 0xe0,  //....+%+@@%. 
  0x00, 0xde, 0x78,  //....@+@%+@% 
  0x03, 0x1c, 0x2c,  //...@.+@..%@ 
  0x06, 0x1c, 0x2c,  //..+%.+@..%@ 
  0x04, 0x0e, 0x78,  //..+...@%+@% 
  0x00, 0x07, 0xe0,  //......+@@%. 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 


  /*Unicode: U+0026 (&) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x0b, 0xe0, 0x00,  //..%@@%.... 
  0x2d, 0x7c, 0x00,  //.%@++@@... 
  0x38, 0x2c, 0x00,  //.@%..%@... 
  0x3c, 0x38, 0x00,  //.@@..@%... 
  0x0f, 0xe0, 0x00,  //..@@@%.... 
  0x0f, 0x80, 0x00,  //..@@%..... 
  0x3e, 0xd2, 0xc0,  //.@@%@+.%@. 
  0xf0, 0xb2, 0xc0,  //@@..%@.%@. 
  0xe0, 0x3f, 0x80,  //@%...@@@%. 
  0xf0, 0x0f, 0x00,  //@@....@@.. 
  0x79, 0x6f, 0x40,  //+@%++%@@+. 
  0x1f, 0xf6, 0xd0,  //.+@@@@+%@+ 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0027 (') , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+0028 (() , Width: 5 */
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x03, 0x00,  //...@. 
  0x0d, 0x00,  //..@+. 
  0x2c, 0x00,  //.%@.. 
  0x34, 0x00,  //.@+.. 
  0x70, 0x00,  //+@... 
  0xa0, 0x00,  //%%... 
  0xe0, 0x00,  //@%... 
  0xe0, 0x00,  //@%... 
  0xe0, 0x00,  //@%... 
  0xe0, 0x00,  //@%... 
  0xe0, 0x00,  //@%... 
  0xb0, 0x00,  //%@... 
  0x30, 0x00,  //.@... 
  0x38, 0x00,  //.@%.. 
  0x0c, 0x00,  //..@.. 
  0x07, 0x00,  //..+@. 
  0x01, 0x00,  //...+. 
  0x00, 0x00,  //..... 


  /*Unicode: U+0029 ()) , Width: 5 */
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0xa0, 0x00,  //%%... 
  0x34, 0x00,  //.@+.. 
  0x1c, 0x00,  //.+@.. 
  0x0e, 0x00,  //..@%. 
  0x0b, 0x00,  //..%@. 
  0x07, 0x00,  //..+@. 
  0x03, 0x40,  //...@+ 
  0x03, 0x40,  //...@+ 
  0x03, 0x80,  //...@% 
  0x03, 0x40,  //...@+ 
  0x03, 0x40,  //...@+ 
  0x07, 0x00,  //..+@. 
  0x0b, 0x00,  //..%@. 
  0x0d, 0x00,  //..@+. 
  0x2c, 0x00,  //.%@.. 
  0x70, 0x00,  //+@... 
  0x40, 0x00,  //+.... 
  0x00, 0x00,  //..... 


  /*Unicode: U+002a (*) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x03, 0x80,  //...@%... 
  0x03, 0x80,  //...@%... 
  0xa7, 0x9c,  //%%+@%+@. 
  0x2f, 0xe4,  //.%@@@%+. 
  0x0f, 0xc0,  //..@@@... 
  0x2c, 0xb0,  //.%@.%@.. 
  0x14, 0x20,  //.++..%.. 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+002b (+) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x02, 0xc0,  //...%@... 
  0x02, 0xc0,  //...%@... 
  0x02, 0xc0,  //...%@... 
  0x02, 0xc0,  //...%@... 
  0xff, 0xff,  //@@@@@@@@ 
  0x02, 0xc0,  //...%@... 
  0x02, 0xc0,  //...%@... 
  0x02, 0xc0,  //...%@... 
  0x02, 0xc0,  //...%@... 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+002c (,) , Width: 3 */
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x38,  //.@% 
  0x34,  //.@+ 
  0x30,  //.@. 
  0xa0,  //%%. 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 


  /*Unicode: U+002d (-) , Width: 4 */
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0xff,  //@@@@ 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 


  /*Unicode: U+002e (.) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xd0,  //@+ 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+002f (/) , Width: 7 */
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x34,  //.....@+ 
  0x00, 0x70,  //....+@. 
  0x00, 0xe0,  //....@%. 
  0x00, 0xc0,  //....@.. 
  0x02, 0xc0,  //...%@.. 
  0x03, 0x40,  //...@+.. 
  0x07, 0x00,  //..+@... 
  0x0a, 0x00,  //..%%... 
  0x0c, 0x00,  //..@.... 
  0x1c, 0x00,  //.+@.... 
  0x34, 0x00,  //.@+.... 
  0x70, 0x00,  //+@..... 
  0xa0, 0x00,  //%%..... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 


  /*Unicode: U+0030 (0) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x1f, 0xe0,  //.+@@@%.. 
  0x39, 0x7c,  //.@%++@@. 
  0xb0, 0x1c,  //%@...+@. 
  0xe0, 0x0d,  //@%....@+ 
  0xe0, 0x0e,  //@%....@% 
  0xe0, 0x0e,  //@%....@% 
  0xe0, 0x0e,  //@%....@% 
  0xe0, 0x0d,  //@%....@+ 
  0xe0, 0x0d,  //@%....@+ 
  0xb0, 0x1c,  //%@...+@. 
  0x39, 0x78,  //.@%++@%. 
  0x1f, 0xe0,  //.+@@@%.. 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0031 (1) , Width: 5 */
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x06, 0x80,  //..+%% 
  0xbf, 0x80,  //%@@@% 
  0xd3, 0x80,  //@+.@% 
  0x03, 0x80,  //...@% 
  0x03, 0x80,  //...@% 
  0x03, 0x80,  //...@% 
  0x03, 0x80,  //...@% 
  0x03, 0x80,  //...@% 
  0x03, 0x80,  //...@% 
  0x03, 0x80,  //...@% 
  0x03, 0x80,  //...@% 
  0x03, 0x80,  //...@% 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 


  /*Unicode: U+0032 (2) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x1f, 0xe0,  //.+@@@%.. 
  0x79, 0x7c,  //+@%++@@. 
  0xf0, 0x0d,  //@@....@+ 
  0x90, 0x0d,  //%+....@+ 
  0x00, 0x1c,  //.....+@. 
  0x00, 0x38,  //.....@%. 
  0x00, 0xf0,  //....@@.. 
  0x02, 0xc0,  //...%@... 
  0x0b, 0x00,  //..%@.... 
  0x2d, 0x00,  //.%@+.... 
  0xb8, 0x00,  //%@%..... 
  0xff, 0xff,  //@@@@@@@@ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0033 (3) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x1f, 0xe0,  //.+@@@%.. 
  0x79, 0x7c,  //+@%++@@. 
  0xe0, 0x0d,  //@%....@+ 
  0x00, 0x0d,  //......@+ 
  0x00, 0x2c,  //.....%@. 
  0x0b, 0xf0,  //..%@@@.. 
  0x00, 0x7c,  //....+@@. 
  0x00, 0x0d,  //......@+ 
  0x40, 0x0e,  //+.....@% 
  0xe0, 0x0d,  //@%....@+ 
  0x79, 0x7c,  //+@%++@@. 
  0x1f, 0xe0,  //.+@@@%.. 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0034 (4) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x3c, 0x00,  //.....@@.. 
  0x00, 0xbc, 0x00,  //....%@@.. 
  0x00, 0xfc, 0x00,  //....@@@.. 
  0x03, 0xac, 0x00,  //...@%%@.. 
  0x0b, 0x2c, 0x00,  //..%@.%@.. 
  0x0d, 0x2c, 0x00,  //..@+.%@.. 
  0x38, 0x2c, 0x00,  //.@%..%@.. 
  0x70, 0x2c, 0x00,  //+@...%@.. 
  0xff, 0xff, 0xc0,  //@@@@@@@@@ 
  0x00, 0x2c, 0x00,  //.....%@.. 
  0x00, 0x2c, 0x00,  //.....%@.. 
  0x00, 0x2c, 0x00,  //.....%@.. 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0035 (5) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x3f, 0xfc,  //.@@@@@@. 
  0x34, 0x00,  //.@+..... 
  0x70, 0x00,  //+@...... 
  0x70, 0x00,  //+@...... 
  0xbf, 0xe0,  //%@@@@%.. 
  0x74, 0x7c,  //+@+.+@@. 
  0x00, 0x1d,  //.....+@+ 
  0x00, 0x0d,  //......@+ 
  0x40, 0x0d,  //+.....@+ 
  0xe0, 0x1d,  //@%...+@+ 
  0x79, 0x7c,  //+@%++@@. 
  0x1f, 0xe0,  //.+@@@%.. 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0036 (6) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x02, 0xf0,  //...%@@.. 
  0x1f, 0x40,  //.+@@+... 
  0x38, 0x00,  //.@%..... 
  0xb0, 0x00,  //%@...... 
  0xfb, 0xe0,  //@@%@@%.. 
  0xf9, 0x7c,  //@@%++@@. 
  0xe0, 0x1d,  //@%...+@+ 
  0xe0, 0x0d,  //@%....@+ 
  0xe0, 0x0d,  //@%....@+ 
  0xb0, 0x1d,  //%@...+@+ 
  0x3d, 0x78,  //.@@++@%. 
  0x0b, 0xe0,  //..%@@%.. 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0037 (7) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0xff, 0xff,  //@@@@@@@@ 
  0x00, 0x0e,  //......@% 
  0x00, 0x0d,  //......@+ 
  0x00, 0x2c,  //.....%@. 
  0x00, 0x34,  //.....@+. 
  0x00, 0xb0,  //....%@.. 
  0x00, 0xe0,  //....@%.. 
  0x01, 0xc0,  //...+@... 
  0x03, 0x80,  //...@%... 
  0x07, 0x00,  //..+@.... 
  0x0e, 0x00,  //..@%.... 
  0x1d, 0x00,  //.+@+.... 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0038 (8) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x0b, 0xe0,  //..%@@%.. 
  0x3d, 0x7c,  //.@@++@@. 
  0x70, 0x0d,  //+@....@+ 
  0x70, 0x0d,  //+@....@+ 
  0x38, 0x2c,  //.@%..%@. 
  0x1f, 0xf0,  //.+@@@@.. 
  0x39, 0x7c,  //.@%++@@. 
  0xf0, 0x1d,  //@@...+@+ 
  0xe0, 0x0d,  //@%....@+ 
  0xe0, 0x0d,  //@%....@+ 
  0x79, 0x7c,  //+@%++@@. 
  0x1f, 0xe0,  //.+@@@%.. 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0039 (9) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x1f, 0xe0,  //.+@@@%.. 
  0x39, 0x78,  //.@%++@%. 
  0xb0, 0x2c,  //%@...%@. 
  0xe0, 0x0d,  //@%....@+ 
  0xe0, 0x0e,  //@%....@% 
  0xf0, 0x0e,  //@@....@% 
  0x74, 0x3d,  //+@+..@@+ 
  0x2f, 0xdd,  //.%@@@+@+ 
  0x00, 0x0c,  //......@. 
  0x00, 0x28,  //.....%%. 
  0x05, 0xf0,  //..++@@.. 
  0x1f, 0x80,  //.+@@%... 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+003a (:) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xd0,  //@+ 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xd0,  //@+ 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+003b (;) , Width: 3 */
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x34,  //.@+ 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x10,  //.+. 
  0x38,  //.@% 
  0x34,  //.@+ 
  0x70,  //+@. 
  0x60,  //+%. 
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 


  /*Unicode: U+003c (<) , Width: 7 */
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x18,  //.....+% 
  0x01, 0xfc,  //...+@@@ 
  0x2f, 0x80,  //.%@@%.. 
  0xf4, 0x00,  //@@+.... 
  0xbe, 0x00,  //%@@%... 
  0x07, 0xf4,  //..+@@@+ 
  0x00, 0x6c,  //....+%@ 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 


  /*Unicode: U+003d (=) , Width: 7 */
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0xff, 0xfc,  //@@@@@@@ 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0xff, 0xfc,  //@@@@@@@ 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 


  /*Unicode: U+003e (>) , Width: 7 */
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0xd0, 0x00,  //@+..... 
  0xfd, 0x00,  //@@@+... 
  0x0b, 0xe0,  //..%@@%. 
  0x00, 0x7c,  //....+@@ 
  0x02, 0xf8,  //...%@@% 
  0x7f, 0x40,  //+@@@+.. 
  0xe4, 0x00,  //@%+.... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 


  /*Unicode: U+003f (?) , Width: 7 */
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x2f, 0xc0,  //.%@@@.. 
  0xb5, 0xb0,  //%@++%@. 
  0xe0, 0x34,  //@%...@+ 
  0x00, 0x34,  //.....@+ 
  0x00, 0x74,  //....+@+ 
  0x00, 0xf0,  //....@@. 
  0x03, 0xc0,  //...@@.. 
  0x07, 0x40,  //..+@+.. 
  0x07, 0x00,  //..+@... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x07, 0x00,  //..+@... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 


  /*Unicode: U+0040 (@) , Width: 14 */
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x7f, 0xe0, 0x00,  //....+@@@@%.... 
  0x07, 0xd5, 0x7d, 0x00,  //..+@@++++@@+.. 
  0x1e, 0x00, 0x0b, 0x00,  //.+@%......%@.. 
  0x38, 0x1f, 0x83, 0x80,  //.@%..+@@%..@%. 
  0x70, 0x75, 0xd1, 0xc0,  //+@..+@++@+.+@. 
  0xb0, 0xd0, 0xc0, 0xd0,  //%@..@+..@...@+ 
  0xe0, 0xc0, 0xc0, 0xd0,  //@%..@...@...@+ 
  0xe1, 0xc0, 0xc0, 0xe0,  //@%.+@...@...@% 
  0xe2, 0xc0, 0xc0, 0xd0,  //@%.%@...@...@+ 
  0xe1, 0xc1, 0xc1, 0xc0,  //@%.+@..+@..+@. 
  0xb0, 0xd7, 0xd7, 0x80,  //%@..@++@@++@%. 
  0x74, 0xbc, 0x7e, 0x00,  //+@+.%@@.+@@%.. 
  0x2c, 0x00, 0x00, 0x00,  //.%@........... 
  0x0f, 0x95, 0x80, 0x00,  //..@@%+++%..... 
  0x01, 0xbf, 0x80, 0x00,  //...+%@@@%..... 
  0x00, 0x00, 0x00, 0x00,  //.............. 
  0x00, 0x00, 0x00, 0x00,  //.............. 


  /*Unicode: U+0041 (A) , Width: 11 */
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x74, 0x00,  //....+@+.... 
  0x00, 0xbc, 0x00,  //....%@@.... 
  0x00, 0xec, 0x00,  //....@%@.... 
  0x01, 0xce, 0x00,  //...+@.@%... 
  0x03, 0x8b, 0x00,  //...@%.%@... 
  0x07, 0x43, 0x40,  //..+@+..@+.. 
  0x0b, 0x03, 0x80,  //..%@...@%.. 
  0x0e, 0x02, 0xc0,  //..@%...%@.. 
  0x1f, 0xff, 0xe0,  //.+@@@@@@@%. 
  0x3c, 0x00, 0xf0,  //.@@.....@@. 
  0x34, 0x00, 0x74,  //.@+.....+@+ 
  0xb0, 0x00, 0x38,  //%@.......@% 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 


  /*Unicode: U+0042 (B) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0xff, 0xf4,  //@@@@@@+. 
  0xe0, 0x6e,  //@%..+%@% 
  0xe0, 0x0b,  //@%....%@ 
  0xe0, 0x0b,  //@%....%@ 
  0xe0, 0x1e,  //@%...+@% 
  0xff, 0xf8,  //@@@@@@%. 
  0xe0, 0x6d,  //@%..+%@+ 
  0xe0, 0x0b,  //@%....%@ 
  0xe0, 0x0b,  //@%....%@ 
  0xe0, 0x0f,  //@%....@@ 
  0xe0, 0x6d,  //@%..+%@+ 
  0xff, 0xf4,  //@@@@@@+. 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0043 (C) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x07, 0xf8, 0x00,  //..+@@@%... 
  0x2e, 0x5b, 0x00,  //.%@%++%@.. 
  0x74, 0x03, 0xc0,  //+@+....@@. 
  0xb0, 0x01, 0xc0,  //%@.....+@. 
  0xe0, 0x00, 0x00,  //@%........ 
  0xe0, 0x00, 0x00,  //@%........ 
  0xe0, 0x00, 0x00,  //@%........ 
  0xe0, 0x00, 0x00,  //@%........ 
  0xb0, 0x01, 0xc0,  //%@.....+@. 
  0x74, 0x03, 0xc0,  //+@+....@@. 
  0x2d, 0x5b, 0x00,  //.%@+++%@.. 
  0x07, 0xf8, 0x00,  //..+@@@%... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0044 (D) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0xff, 0xe0, 0x00,  //@@@@@%... 
  0xe0, 0x7c, 0x00,  //@%..+@@.. 
  0xe0, 0x0e, 0x00,  //@%....@%. 
  0xe0, 0x07, 0x00,  //@%....+@. 
  0xe0, 0x03, 0x40,  //@%.....@+ 
  0xe0, 0x03, 0x80,  //@%.....@% 
  0xe0, 0x03, 0x80,  //@%.....@% 
  0xe0, 0x03, 0x40,  //@%.....@+ 
  0xe0, 0x07, 0x00,  //@%....+@. 
  0xe0, 0x0f, 0x00,  //@%....@@. 
  0xe1, 0x7c, 0x00,  //@%.++@@.. 
  0xff, 0xe0, 0x00,  //@@@@@%... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0045 (E) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0xff, 0xfe,  //@@@@@@@% 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xff, 0xfc,  //@@@@@@@. 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xff, 0xfe,  //@@@@@@@% 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0046 (F) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0xff, 0xfd,  //@@@@@@@+ 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xff, 0xf8,  //@@@@@@%. 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0047 (G) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x07, 0xfd, 0x00,  //..+@@@@+.. 
  0x2e, 0x5b, 0x80,  //.%@%++%@%. 
  0x74, 0x01, 0xc0,  //+@+....+@. 
  0xb0, 0x00, 0x80,  //%@......%. 
  0xe0, 0x00, 0x00,  //@%........ 
  0xe0, 0x00, 0x00,  //@%........ 
  0xe0, 0x3f, 0xe0,  //@%...@@@@% 
  0xe0, 0x00, 0xe0,  //@%......@% 
  0xb0, 0x00, 0xe0,  //%@......@% 
  0x74, 0x00, 0xe0,  //+@+.....@% 
  0x2e, 0x46, 0xd0,  //.%@%+.+%@+ 
  0x06, 0xfe, 0x00,  //..+%@@@%.. 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0048 (H) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0xe0, 0x02, 0xc0,  //@%.....%@ 
  0xe0, 0x02, 0xc0,  //@%.....%@ 
  0xe0, 0x02, 0xc0,  //@%.....%@ 
  0xe0, 0x02, 0xc0,  //@%.....%@ 
  0xe0, 0x02, 0xc0,  //@%.....%@ 
  0xff, 0xff, 0xc0,  //@@@@@@@@@ 
  0xe0, 0x02, 0xc0,  //@%.....%@ 
  0xe0, 0x02, 0xc0,  //@%.....%@ 
  0xe0, 0x02, 0xc0,  //@%.....%@ 
  0xe0, 0x02, 0xc0,  //@%.....%@ 
  0xe0, 0x02, 0xc0,  //@%.....%@ 
  0xe0, 0x02, 0xc0,  //@%.....%@ 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0049 (I) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+004a (J) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x0e,  //......@% 
  0x00, 0x0e,  //......@% 
  0x00, 0x0e,  //......@% 
  0x00, 0x0e,  //......@% 
  0x00, 0x0e,  //......@% 
  0x00, 0x0e,  //......@% 
  0x00, 0x0e,  //......@% 
  0x00, 0x0e,  //......@% 
  0x40, 0x0e,  //+.....@% 
  0xe0, 0x0d,  //@%....@+ 
  0x79, 0x7c,  //+@%++@@. 
  0x1f, 0xe0,  //.+@@@%.. 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+004b (K) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0xe0, 0x0b, 0x40,  //@%....%@+. 
  0xe0, 0x1d, 0x00,  //@%...+@+.. 
  0xe0, 0x78, 0x00,  //@%..+@%... 
  0xe1, 0xe0, 0x00,  //@%.+@%.... 
  0xe3, 0x80, 0x00,  //@%.@%..... 
  0xef, 0x40, 0x00,  //@%@@+..... 
  0xff, 0xc0, 0x00,  //@@@@@..... 
  0xf0, 0xe0, 0x00,  //@@..@%.... 
  0xe0, 0x78, 0x00,  //@%..+@%... 
  0xe0, 0x2d, 0x00,  //@%...%@+.. 
  0xe0, 0x0f, 0x00,  //@%....@@.. 
  0xe0, 0x03, 0xc0,  //@%.....@@. 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+004c (L) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe5, 0x54,  //@%+++++. 
  0xff, 0xfd,  //@@@@@@@+ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+004d (M) , Width: 12 */
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0xf4, 0x00, 0x1f,  //@@+......+@@ 
  0xf8, 0x00, 0x2f,  //@@%......%@@ 
  0xfc, 0x00, 0x3f,  //@@@......@@@ 
  0xed, 0x00, 0x7b,  //@%@+....+@%@ 
  0xeb, 0x00, 0xeb,  //@%%@....@%%@ 
  0xe3, 0x41, 0xcb,  //@%.@+..+@.%@ 
  0xe3, 0x82, 0xcb,  //@%.@%..%@.%@ 
  0xe1, 0xc3, 0x4b,  //@%.+@..@+.%@ 
  0xe0, 0xd7, 0x0b,  //@%..@++@..%@ 
  0xe0, 0xbe, 0x0b,  //@%..%@@%..%@ 
  0xe0, 0x3c, 0x0b,  //@%...@@...%@ 
  0xe0, 0x3c, 0x0b,  //@%...@@...%@ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00,  //............ 


  /*Unicode: U+004e (N) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0xf0, 0x02, 0xc0,  //@@.....%@ 
  0xf4, 0x02, 0xc0,  //@@+....%@ 
  0xfc, 0x02, 0xc0,  //@@@....%@ 
  0xef, 0x02, 0xc0,  //@%@@...%@ 
  0xe7, 0x42, 0xc0,  //@%+@+..%@ 
  0xe2, 0xc2, 0xc0,  //@%.%@..%@ 
  0xe0, 0xe2, 0xc0,  //@%..@%.%@ 
  0xe0, 0x76, 0xc0,  //@%..+@+%@ 
  0xe0, 0x3e, 0xc0,  //@%...@@%@ 
  0xe0, 0x0f, 0xc0,  //@%....@@@ 
  0xe0, 0x0b, 0xc0,  //@%....%@@ 
  0xe0, 0x03, 0xc0,  //@%.....@@ 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+004f (O) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x07, 0xf8, 0x00,  //..+@@@%... 
  0x2e, 0x5f, 0x00,  //.%@%++@@.. 
  0x74, 0x03, 0xc0,  //+@+....@@. 
  0xb0, 0x01, 0xc0,  //%@.....+@. 
  0xe0, 0x00, 0xd0,  //@%......@+ 
  0xe0, 0x00, 0xe0,  //@%......@% 
  0xe0, 0x00, 0xe0,  //@%......@% 
  0xe0, 0x00, 0xd0,  //@%......@+ 
  0xb0, 0x01, 0xc0,  //%@.....+@. 
  0x74, 0x03, 0xc0,  //+@+....@@. 
  0x2e, 0x5b, 0x00,  //.%@%++%@.. 
  0x07, 0xf8, 0x00,  //..+@@@%... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0050 (P) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0xff, 0xf8, 0x00,  //@@@@@@%.. 
  0xe0, 0x5f, 0x00,  //@%..++@@. 
  0xe0, 0x07, 0x40,  //@%....+@+ 
  0xe0, 0x03, 0x80,  //@%.....@% 
  0xe0, 0x03, 0x40,  //@%.....@+ 
  0xe0, 0x0f, 0x00,  //@%....@@. 
  0xff, 0xfc, 0x00,  //@@@@@@@.. 
  0xe0, 0x00, 0x00,  //@%....... 
  0xe0, 0x00, 0x00,  //@%....... 
  0xe0, 0x00, 0x00,  //@%....... 
  0xe0, 0x00, 0x00,  //@%....... 
  0xe0, 0x00, 0x00,  //@%....... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0051 (Q) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x07, 0xf8, 0x00,  //..+@@@%... 
  0x2e, 0x5f, 0x00,  //.%@%++@@.. 
  0x74, 0x03, 0xc0,  //+@+....@@. 
  0xb0, 0x01, 0xc0,  //%@.....+@. 
  0xe0, 0x00, 0xd0,  //@%......@+ 
  0xe0, 0x00, 0xe0,  //@%......@% 
  0xe0, 0x00, 0xe0,  //@%......@% 
  0xe0, 0x00, 0xd0,  //@%......@+ 
  0xb0, 0x01, 0xc0,  //%@.....+@. 
  0x74, 0x03, 0xc0,  //+@+....@@. 
  0x2e, 0x5b, 0x40,  //.%@%++%@+. 
  0x07, 0xff, 0x00,  //..+@@@@@.. 
  0x00, 0x03, 0xc0,  //.......@@. 
  0x00, 0x00, 0x80,  //........%. 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0052 (R) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0xff, 0xe4, 0x00,  //@@@@@%+.. 
  0xe0, 0x6d, 0x00,  //@%..+%@+. 
  0xe0, 0x0f, 0x00,  //@%....@@. 
  0xe0, 0x0b, 0x00,  //@%....%@. 
  0xe0, 0x0b, 0x00,  //@%....%@. 
  0xe0, 0x2d, 0x00,  //@%...%@+. 
  0xff, 0xf4, 0x00,  //@@@@@@+.. 
  0xe0, 0xb0, 0x00,  //@%..%@... 
  0xe0, 0x3c, 0x00,  //@%...@@.. 
  0xe0, 0x1d, 0x00,  //@%...+@+. 
  0xe0, 0x0f, 0x00,  //@%....@@. 
  0xe0, 0x07, 0x80,  //@%....+@% 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0053 (S) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x0b, 0xf8, 0x00,  //..%@@@%.. 
  0x3d, 0x5f, 0x00,  //.@@+++@@. 
  0x70, 0x07, 0x40,  //+@....+@+ 
  0x70, 0x02, 0x40,  //+@.....%+ 
  0x3c, 0x00, 0x00,  //.@@...... 
  0x1f, 0xd0, 0x00,  //.+@@@+... 
  0x01, 0xbd, 0x00,  //...+%@@+. 
  0x00, 0x0b, 0x00,  //......%@. 
  0x90, 0x03, 0x40,  //%+.....@+ 
  0xf0, 0x03, 0x40,  //@@.....@+ 
  0x3d, 0x5f, 0x00,  //.@@+++@@. 
  0x0b, 0xf8, 0x00,  //..%@@@%.. 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0054 (T) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0xff, 0xff, 0xc0,  //@@@@@@@@@ 
  0x00, 0xe0, 0x00,  //....@%... 
  0x00, 0xe0, 0x00,  //....@%... 
  0x00, 0xe0, 0x00,  //....@%... 
  0x00, 0xe0, 0x00,  //....@%... 
  0x00, 0xe0, 0x00,  //....@%... 
  0x00, 0xe0, 0x00,  //....@%... 
  0x00, 0xe0, 0x00,  //....@%... 
  0x00, 0xe0, 0x00,  //....@%... 
  0x00, 0xe0, 0x00,  //....@%... 
  0x00, 0xe0, 0x00,  //....@%... 
  0x00, 0xe0, 0x00,  //....@%... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0055 (U) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0xe0, 0x03, 0x80,  //@%.....@% 
  0xe0, 0x03, 0x80,  //@%.....@% 
  0xe0, 0x03, 0x80,  //@%.....@% 
  0xe0, 0x03, 0x80,  //@%.....@% 
  0xe0, 0x03, 0x80,  //@%.....@% 
  0xe0, 0x03, 0x80,  //@%.....@% 
  0xe0, 0x03, 0x80,  //@%.....@% 
  0xe0, 0x03, 0x80,  //@%.....@% 
  0xe0, 0x03, 0x40,  //@%.....@+ 
  0xf0, 0x07, 0x40,  //@@....+@+ 
  0x3d, 0x5e, 0x00,  //.@@+++@%. 
  0x0b, 0xf4, 0x00,  //..%@@@+.. 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0056 (V) , Width: 11 */
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0xb0, 0x00, 0x74,  //%@......+@+ 
  0x34, 0x00, 0xb0,  //.@+.....%@. 
  0x3c, 0x00, 0xe0,  //.@@.....@%. 
  0x1c, 0x01, 0xd0,  //.+@....+@+. 
  0x0e, 0x02, 0xc0,  //..@%...%@.. 
  0x0b, 0x03, 0x80,  //..%@...@%.. 
  0x07, 0x07, 0x00,  //..+@..+@... 
  0x03, 0x8f, 0x00,  //...@%.@@... 
  0x02, 0xcd, 0x00,  //...%@.@+... 
  0x00, 0xec, 0x00,  //....@%@.... 
  0x00, 0xf8, 0x00,  //....@@%.... 
  0x00, 0x74, 0x00,  //....+@+.... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 


  /*Unicode: U+0057 (W) , Width: 15 */
  0x00, 0x00, 0x00, 0x00,  //............... 
  0x00, 0x00, 0x00, 0x00,  //............... 
  0x00, 0x00, 0x00, 0x00,  //............... 
  0x70, 0x03, 0x40, 0x38,  //+@.....@+....@% 
  0x34, 0x07, 0x80, 0x34,  //.@+...+@%....@+ 
  0x38, 0x0b, 0xc0, 0x70,  //.@%...%@@...+@. 
  0x2c, 0x0d, 0xd0, 0xb0,  //.%@...@+@+..%@. 
  0x1c, 0x1c, 0xe0, 0xe0,  //.+@..+@.@%..@%. 
  0x0d, 0x2c, 0xb0, 0xd0,  //..@+.%@.%@..@+. 
  0x0e, 0x38, 0x31, 0xc0,  //..@%.@%..@.+@.. 
  0x0b, 0x30, 0x36, 0xc0,  //..%@.@...@+%@.. 
  0x07, 0x70, 0x2b, 0x80,  //..+@+@...%%@%.. 
  0x03, 0xe0, 0x1f, 0x40,  //...@@%...+@@+.. 
  0x03, 0xd0, 0x0f, 0x00,  //...@@+....@@... 
  0x02, 0xc0, 0x0f, 0x00,  //...%@.....@@... 
  0x00, 0x00, 0x00, 0x00,  //............... 
  0x00, 0x00, 0x00, 0x00,  //............... 
  0x00, 0x00, 0x00, 0x00,  //............... 
  0x00, 0x00, 0x00, 0x00,  //............... 
  0x00, 0x00, 0x00, 0x00,  //............... 


  /*Unicode: U+0058 (X) , Width: 11 */
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x38, 0x00, 0xf0,  //.@%.....@@. 
  0x1d, 0x02, 0xc0,  //.+@+...%@.. 
  0x0f, 0x07, 0x80,  //..@@..+@%.. 
  0x03, 0x8f, 0x00,  //...@%.@@... 
  0x02, 0xfc, 0x00,  //...%@@@.... 
  0x00, 0xf8, 0x00,  //....@@%.... 
  0x00, 0xf8, 0x00,  //....@@%.... 
  0x02, 0xed, 0x00,  //...%@%@+... 
  0x07, 0x8f, 0x00,  //..+@%.@@... 
  0x0f, 0x07, 0x80,  //..@@..+@%.. 
  0x2d, 0x02, 0xc0,  //.%@+...%@.. 
  0x38, 0x00, 0xf0,  //.@%.....@@. 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00,  //........... 


  /*Unicode: U+0059 (Y) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0xf0, 0x01, 0xd0,  //@@.....+@+ 
  0x74, 0x03, 0xc0,  //+@+....@@. 
  0x3c, 0x07, 0x40,  //.@@...+@+. 
  0x0d, 0x0e, 0x00,  //..@+..@%.. 
  0x0b, 0x1c, 0x00,  //..%@.+@... 
  0x03, 0xb8, 0x00,  //...@%@%... 
  0x02, 0xf0, 0x00,  //...%@@.... 
  0x00, 0xe0, 0x00,  //....@%.... 
  0x00, 0xe0, 0x00,  //....@%.... 
  0x00, 0xe0, 0x00,  //....@%.... 
  0x00, 0xe0, 0x00,  //....@%.... 
  0x00, 0xe0, 0x00,  //....@%.... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+005a (Z) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0xff, 0xff, 0xc0,  //@@@@@@@@@ 
  0x00, 0x07, 0x80,  //......+@% 
  0x00, 0x0f, 0x00,  //......@@. 
  0x00, 0x2d, 0x00,  //.....%@+. 
  0x00, 0x78, 0x00,  //....+@%.. 
  0x00, 0xf0, 0x00,  //....@@... 
  0x03, 0xc0, 0x00,  //...@@.... 
  0x0b, 0x40, 0x00,  //..%@+.... 
  0x1e, 0x00, 0x00,  //.+@%..... 
  0x3c, 0x00, 0x00,  //.@@...... 
  0xb4, 0x00, 0x00,  //%@+...... 
  0xff, 0xff, 0xc0,  //@@@@@@@@@ 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+005b ([) , Width: 4 */
  0x00,  //.... 
  0xfc,  //@@@. 
  0xe0,  //@%.. 
  0xe0,  //@%.. 
  0xe0,  //@%.. 
  0xe0,  //@%.. 
  0xe0,  //@%.. 
  0xe0,  //@%.. 
  0xe0,  //@%.. 
  0xe0,  //@%.. 
  0xe0,  //@%.. 
  0xe0,  //@%.. 
  0xe0,  //@%.. 
  0xe0,  //@%.. 
  0xe0,  //@%.. 
  0xe0,  //@%.. 
  0xfc,  //@@@. 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 


  /*Unicode: U+005c (\) , Width: 7 */
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x70, 0x00,  //+@..... 
  0x34, 0x00,  //.@+.... 
  0x2c, 0x00,  //.%@.... 
  0x1c, 0x00,  //.+@.... 
  0x0e, 0x00,  //..@%... 
  0x0b, 0x00,  //..%@... 
  0x03, 0x40,  //...@+.. 
  0x03, 0x80,  //...@%.. 
  0x01, 0xc0,  //...+@.. 
  0x00, 0xd0,  //....@+. 
  0x00, 0xb0,  //....%@. 
  0x00, 0x34,  //.....@+ 
  0x00, 0x38,  //.....@% 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 


  /*Unicode: U+005d (]) , Width: 4 */
  0x00,  //.... 
  0xbe,  //%@@% 
  0x0e,  //..@% 
  0x0e,  //..@% 
  0x0e,  //..@% 
  0x0e,  //..@% 
  0x0e,  //..@% 
  0x0e,  //..@% 
  0x0e,  //..@% 
  0x0e,  //..@% 
  0x0e,  //..@% 
  0x0e,  //..@% 
  0x0e,  //..@% 
  0x0e,  //..@% 
  0x0e,  //..@% 
  0x0e,  //..@% 
  0xbe,  //%@@% 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 


  /*Unicode: U+005e (^) , Width: 7 */
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x03, 0x40,  //...@+.. 
  0x0b, 0x80,  //..%@%.. 
  0x0e, 0xc0,  //..@%@.. 
  0x1c, 0xe0,  //.+@.@%. 
  0x38, 0x70,  //.@%.+@. 
  0x70, 0x34,  //+@...@+ 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 


  /*Unicode: U+005f (_) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0xff, 0xff,  //@@@@@@@@ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0060 (`) , Width: 4 */
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x38,  //.@%. 
  0x1d,  //.+@+ 
  0x05,  //..++ 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 
  0x00,  //.... 


  /*Unicode: U+0061 (a) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x2f, 0xe0,  //.%@@@%.. 
  0xb5, 0x78,  //%@+++@%. 
  0x00, 0x2c,  //.....%@. 
  0x1f, 0xfc,  //.+@@@@@. 
  0xb9, 0x2c,  //%@%+.%@. 
  0xe0, 0x2c,  //@%...%@. 
  0xe0, 0x2c,  //@%...%@. 
  0xb5, 0xbc,  //%@++%@@. 
  0x2f, 0x9c,  //.%@@%+@. 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0062 (b) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xeb, 0xe0,  //@%%@@%.. 
  0xf9, 0x78,  //@@%++@%. 
  0xe0, 0x1c,  //@%...+@. 
  0xe0, 0x0d,  //@%....@+ 
  0xe0, 0x0e,  //@%....@% 
  0xe0, 0x0d,  //@%....@+ 
  0xe0, 0x1c,  //@%...+@. 
  0xf9, 0x78,  //@@%++@%. 
  0xeb, 0xe0,  //@%%@@%.. 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0063 (c) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x0b, 0xe0,  //..%@@%.. 
  0x3d, 0x7c,  //.@@++@@. 
  0xb0, 0x0d,  //%@....@+ 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xb0, 0x0d,  //%@....@+ 
  0x3d, 0x7c,  //.@@++@@. 
  0x0b, 0xe0,  //..%@@%.. 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0064 (d) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x0e,  //......@% 
  0x00, 0x0e,  //......@% 
  0x00, 0x0e,  //......@% 
  0x1f, 0xde,  //.+@@@+@% 
  0x3d, 0x7e,  //.@@++@@% 
  0xb0, 0x0e,  //%@....@% 
  0xe0, 0x0e,  //@%....@% 
  0xe0, 0x0e,  //@%....@% 
  0xe0, 0x0e,  //@%....@% 
  0xb0, 0x0e,  //%@....@% 
  0x3d, 0x7e,  //.@@++@@% 
  0x1f, 0xde,  //.+@@@+@% 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0065 (e) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x0b, 0xe0,  //..%@@%.. 
  0x3d, 0x7c,  //.@@++@@. 
  0xb0, 0x1c,  //%@...+@. 
  0xe0, 0x0d,  //@%....@+ 
  0xff, 0xfe,  //@@@@@@@% 
  0xe0, 0x00,  //@%...... 
  0xb0, 0x00,  //%@...... 
  0x3d, 0x6c,  //.@@++%@. 
  0x0b, 0xf4,  //..%@@@+. 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0066 (f) , Width: 6 */
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x07, 0xd0,  //..+@@+ 
  0x0e, 0x00,  //..@%.. 
  0x1c, 0x00,  //.+@... 
  0x2c, 0x00,  //.%@... 
  0xff, 0xc0,  //@@@@@. 
  0x2c, 0x00,  //.%@... 
  0x2c, 0x00,  //.%@... 
  0x2c, 0x00,  //.%@... 
  0x2c, 0x00,  //.%@... 
  0x2c, 0x00,  //.%@... 
  0x2c, 0x00,  //.%@... 
  0x2c, 0x00,  //.%@... 
  0x2c, 0x00,  //.%@... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 


  /*Unicode: U+0067 (g) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x1f, 0xde,  //.+@@@+@% 
  0x3d, 0x7e,  //.@@++@@% 
  0xb0, 0x0e,  //%@....@% 
  0xe0, 0x0e,  //@%....@% 
  0xe0, 0x0e,  //@%....@% 
  0xe0, 0x0e,  //@%....@% 
  0xb0, 0x0e,  //%@....@% 
  0x39, 0x7e,  //.@%++@@% 
  0x1f, 0xde,  //.+@@@+@% 
  0x00, 0x0d,  //......@+ 
  0x75, 0x7c,  //+@+++@@. 
  0x1f, 0xe0,  //.+@@@%.. 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0068 (h) , Width: 7 */
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0xe0, 0x00,  //@%..... 
  0xe0, 0x00,  //@%..... 
  0xe0, 0x00,  //@%..... 
  0xeb, 0xe0,  //@%%@@%. 
  0xf9, 0x78,  //@@%++@% 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 


  /*Unicode: U+0069 (i) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xd0,  //@+ 
  0x00,  //.. 
  0x00,  //.. 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+006a (j) , Width: 3 */
  0x00,  //... 
  0x00,  //... 
  0x00,  //... 
  0x34,  //.@+ 
  0x00,  //... 
  0x00,  //... 
  0x38,  //.@% 
  0x38,  //.@% 
  0x38,  //.@% 
  0x38,  //.@% 
  0x38,  //.@% 
  0x38,  //.@% 
  0x38,  //.@% 
  0x38,  //.@% 
  0x38,  //.@% 
  0x38,  //.@% 
  0xb4,  //%@+ 
  0xe0,  //@%. 
  0x00,  //... 
  0x00,  //... 


  /*Unicode: U+006b (k) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x78,  //@%..+@%. 
  0xe1, 0xe0,  //@%.+@%.. 
  0xe3, 0x80,  //@%.@%... 
  0xef, 0x00,  //@%@@.... 
  0xff, 0x00,  //@@@@.... 
  0xf3, 0xc0,  //@@.@@... 
  0xe1, 0xe0,  //@%.+@%.. 
  0xe0, 0x74,  //@%..+@+. 
  0xe0, 0x2c,  //@%...%@. 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+006c (l) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+006d (m) , Width: 13 */
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0xeb, 0xe1, 0xfd, 0x00,  //@%%@@%.+@@@+. 
  0xf9, 0x7f, 0x5b, 0x00,  //@@%++@@@++%@. 
  0xe0, 0x2c, 0x03, 0x40,  //@%...%@....@+ 
  0xe0, 0x2c, 0x03, 0x40,  //@%...%@....@+ 
  0xe0, 0x2c, 0x03, 0x40,  //@%...%@....@+ 
  0xe0, 0x2c, 0x03, 0x40,  //@%...%@....@+ 
  0xe0, 0x2c, 0x03, 0x40,  //@%...%@....@+ 
  0xe0, 0x2c, 0x03, 0x40,  //@%...%@....@+ 
  0xe0, 0x2c, 0x03, 0x40,  //@%...%@....@+ 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 


  /*Unicode: U+006e (n) , Width: 7 */
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0xeb, 0xe0,  //@%%@@%. 
  0xf9, 0x78,  //@@%++@% 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 


  /*Unicode: U+006f (o) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x0b, 0xe0,  //..%@@%.. 
  0x3d, 0x7c,  //.@@++@@. 
  0xb0, 0x0e,  //%@....@% 
  0xe0, 0x0b,  //@%....%@ 
  0xe0, 0x0b,  //@%....%@ 
  0xe0, 0x0b,  //@%....%@ 
  0xb0, 0x0e,  //%@....@% 
  0x3d, 0x7c,  //.@@++@@. 
  0x0b, 0xe0,  //..%@@%.. 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0070 (p) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0xeb, 0xe0,  //@%%@@%.. 
  0xf9, 0x78,  //@@%++@%. 
  0xe0, 0x1c,  //@%...+@. 
  0xe0, 0x0d,  //@%....@+ 
  0xe0, 0x0e,  //@%....@% 
  0xe0, 0x0d,  //@%....@+ 
  0xe0, 0x1c,  //@%...+@. 
  0xf9, 0x78,  //@@%++@%. 
  0xeb, 0xe0,  //@%%@@%.. 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0xe0, 0x00,  //@%...... 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0071 (q) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x1f, 0xde,  //.+@@@+@% 
  0x3d, 0x7e,  //.@@++@@% 
  0xb0, 0x0e,  //%@....@% 
  0xe0, 0x0e,  //@%....@% 
  0xe0, 0x0e,  //@%....@% 
  0xe0, 0x0e,  //@%....@% 
  0xb0, 0x0e,  //%@....@% 
  0x3d, 0x7e,  //.@@++@@% 
  0x1f, 0xde,  //.+@@@+@% 
  0x00, 0x0e,  //......@% 
  0x00, 0x0e,  //......@% 
  0x00, 0x0e,  //......@% 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0072 (r) , Width: 5 */
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0xeb, 0x40,  //@%%@+ 
  0xf5, 0x00,  //@@++. 
  0xe0, 0x00,  //@%... 
  0xe0, 0x00,  //@%... 
  0xe0, 0x00,  //@%... 
  0xe0, 0x00,  //@%... 
  0xe0, 0x00,  //@%... 
  0xe0, 0x00,  //@%... 
  0xe0, 0x00,  //@%... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 
  0x00, 0x00,  //..... 


  /*Unicode: U+0073 (s) , Width: 7 */
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x1f, 0xe0,  //.+@@@%. 
  0x39, 0x78,  //.@%++@% 
  0x70, 0x18,  //+@...+% 
  0x79, 0x00,  //+@%+... 
  0x1b, 0xe0,  //.+%@@%. 
  0x00, 0x7c,  //....+@@ 
  0xe0, 0x2c,  //@%...%@ 
  0xb5, 0x78,  //%@+++@% 
  0x1f, 0xe0,  //.+@@@%. 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 


  /*Unicode: U+0074 (t) , Width: 6 */
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x2c, 0x00,  //.%@... 
  0x2c, 0x00,  //.%@... 
  0xff, 0xc0,  //@@@@@. 
  0x2c, 0x00,  //.%@... 
  0x2c, 0x00,  //.%@... 
  0x2c, 0x00,  //.%@... 
  0x2c, 0x00,  //.%@... 
  0x2c, 0x00,  //.%@... 
  0x2c, 0x00,  //.%@... 
  0x1d, 0x40,  //.+@++. 
  0x0b, 0xc0,  //..%@@. 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 


  /*Unicode: U+0075 (u) , Width: 7 */
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0xe0, 0x2c,  //@%...%@ 
  0xb5, 0xbc,  //%@++%@@ 
  0x2f, 0xac,  //.%@@%%@ 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 


  /*Unicode: U+0076 (v) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0xb0, 0x0e,  //%@....@% 
  0x34, 0x0d,  //.@+...@+ 
  0x38, 0x1c,  //.@%..+@. 
  0x1c, 0x38,  //.+@..@%. 
  0x0d, 0x34,  //..@+.@+. 
  0x0a, 0x70,  //..%%+@.. 
  0x07, 0xe0,  //..+@@%.. 
  0x03, 0xc0,  //...@@... 
  0x02, 0xc0,  //...%@... 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0077 (w) , Width: 13 */
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x70, 0x1c, 0x07, 0x00,  //+@...+@...+@. 
  0x34, 0x2d, 0x0b, 0x00,  //.@+..%@+..%@. 
  0x38, 0x3f, 0x0e, 0x00,  //.@%..@@@..@%. 
  0x2c, 0x77, 0x0d, 0x00,  //.%@.+@+@..@+. 
  0x1c, 0xa3, 0x5c, 0x00,  //.+@.%%.@++@.. 
  0x0d, 0xd2, 0xac, 0x00,  //..@+@+.%%%@.. 
  0x0f, 0xc1, 0xf4, 0x00,  //..@@@..+@@+.. 
  0x07, 0x80, 0xf0, 0x00,  //..+@%...@@... 
  0x03, 0x40, 0xb0, 0x00,  //...@+...%@... 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 
  0x00, 0x00, 0x00, 0x00,  //............. 


  /*Unicode: U+0078 (x) , Width: 8 */
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x34, 0x0e,  //.@+...@% 
  0x2c, 0x2c,  //.%@..%@. 
  0x0e, 0x74,  //..@%+@+. 
  0x07, 0xe0,  //..+@@%.. 
  0x03, 0xc0,  //...@@... 
  0x07, 0xe0,  //..+@@%.. 
  0x0e, 0x74,  //..@%+@+. 
  0x2c, 0x2c,  //.%@..%@. 
  0x74, 0x0e,  //+@+...@% 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 
  0x00, 0x00,  //........ 


  /*Unicode: U+0079 (y) , Width: 9 */
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 
  0x74, 0x0b, 0x00,  //+@+...%@. 
  0x38, 0x0e, 0x00,  //.@%...@%. 
  0x2c, 0x1c, 0x00,  //.%@..+@.. 
  0x0d, 0x2c, 0x00,  //..@+.%@.. 
  0x0e, 0x34, 0x00,  //..@%.@+.. 
  0x07, 0x70, 0x00,  //..+@+@... 
  0x03, 0xe0, 0x00,  //...@@%... 
  0x02, 0xd0, 0x00,  //...%@+... 
  0x01, 0xc0, 0x00,  //...+@.... 
  0x03, 0x80, 0x00,  //...@%.... 
  0x1b, 0x00, 0x00,  //.+%@..... 
  0x3d, 0x00, 0x00,  //.@@+..... 
  0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+007a (z) , Width: 7 */
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0xff, 0xfc,  //@@@@@@@ 
  0x00, 0x78,  //....+@% 
  0x00, 0xf0,  //....@@. 
  0x02, 0xc0,  //...%@.. 
  0x07, 0x40,  //..+@+.. 
  0x0e, 0x00,  //..@%... 
  0x3c, 0x00,  //.@@.... 
  0xb4, 0x00,  //%@+.... 
  0xff, 0xfc,  //@@@@@@@ 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 
  0x00, 0x00,  //....... 


  /*Unicode: U+007b ({) , Width: 6 */
  0x00, 0x00,  //...... 
  0x00, 0x40,  //....+. 
  0x03, 0xc0,  //...@@. 
  0x0b, 0x00,  //..%@.. 
  0x0e, 0x00,  //..@%.. 
  0x0e, 0x00,  //..@%.. 
  0x0e, 0x00,  //..@%.. 
  0x0d, 0x00,  //..@+.. 
  0x2c, 0x00,  //.%@... 
  0xf8, 0x00,  //@@%... 
  0x6c, 0x00,  //+%@... 
  0x0d, 0x00,  //..@+.. 
  0x0e, 0x00,  //..@%.. 
  0x0e, 0x00,  //..@%.. 
  0x0e, 0x00,  //..@%.. 
  0x0b, 0x00,  //..%@.. 
  0x03, 0x80,  //...@%. 
  0x00, 0x40,  //....+. 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 


  /*Unicode: U+007c (|) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0xe0,  //@% 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+007d (}) , Width: 6 */
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 
  0x74, 0x00,  //+@+... 
  0x1c, 0x00,  //.+@... 
  0x0d, 0x00,  //..@+.. 
  0x0e, 0x00,  //..@%.. 
  0x0e, 0x00,  //..@%.. 
  0x0e, 0x00,  //..@%.. 
  0x0b, 0x40,  //..%@+. 
  0x03, 0xd0,  //...@@+ 
  0x0b, 0x40,  //..%@+. 
  0x0e, 0x00,  //..@%.. 
  0x0e, 0x00,  //..@%.. 
  0x0e, 0x00,  //..@%.. 
  0x0d, 0x00,  //..@+.. 
  0x1c, 0x00,  //.+@... 
  0x78, 0x00,  //+@%... 
  0x40, 0x00,  //+..... 
  0x00, 0x00,  //...... 
  0x00, 0x00,  //...... 


  /*Unicode: U+007e (~) , Width: 10 */
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x2f, 0x40, 0xd0,  //.%@@+...@+ 
  0xb5, 0xe2, 0xc0,  //%@++@%.%@. 
  0xe0, 0x3f, 0x40,  //@%...@@@+. 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00,  //.......... 


};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t roboto20_glyph_dsc[] = 
{
  {.w_px = 6,	.glyph_index = 0},	/*Unicode: U+0020 ( )*/
  {.w_px = 2,	.glyph_index = 40},	/*Unicode: U+0021 (!)*/
  {.w_px = 4,	.glyph_index = 60},	/*Unicode: U+0022 (")*/
  {.w_px = 9,	.glyph_index = 80},	/*Unicode: U+0023 (#)*/
  {.w_px = 8,	.glyph_index = 140},	/*Unicode: U+0024 ($)*/
  {.w_px = 11,	.glyph_index = 180},	/*Unicode: U+0025 (%)*/
  {.w_px = 10,	.glyph_index = 240},	/*Unicode: U+0026 (&)*/
  {.w_px = 2,	.glyph_index = 300},	/*Unicode: U+0027 (')*/
  {.w_px = 5,	.glyph_index = 320},	/*Unicode: U+0028 (()*/
  {.w_px = 5,	.glyph_index = 360},	/*Unicode: U+0029 ())*/
  {.w_px = 8,	.glyph_index = 400},	/*Unicode: U+002a (*)*/
  {.w_px = 8,	.glyph_index = 440},	/*Unicode: U+002b (+)*/
  {.w_px = 3,	.glyph_index = 480},	/*Unicode: U+002c (,)*/
  {.w_px = 4,	.glyph_index = 500},	/*Unicode: U+002d (-)*/
  {.w_px = 2,	.glyph_index = 520},	/*Unicode: U+002e (.)*/
  {.w_px = 7,	.glyph_index = 540},	/*Unicode: U+002f (/)*/
  {.w_px = 8,	.glyph_index = 580},	/*Unicode: U+0030 (0)*/
  {.w_px = 5,	.glyph_index = 620},	/*Unicode: U+0031 (1)*/
  {.w_px = 8,	.glyph_index = 660},	/*Unicode: U+0032 (2)*/
  {.w_px = 8,	.glyph_index = 700},	/*Unicode: U+0033 (3)*/
  {.w_px = 9,	.glyph_index = 740},	/*Unicode: U+0034 (4)*/
  {.w_px = 8,	.glyph_index = 800},	/*Unicode: U+0035 (5)*/
  {.w_px = 8,	.glyph_index = 840},	/*Unicode: U+0036 (6)*/
  {.w_px = 8,	.glyph_index = 880},	/*Unicode: U+0037 (7)*/
  {.w_px = 8,	.glyph_index = 920},	/*Unicode: U+0038 (8)*/
  {.w_px = 8,	.glyph_index = 960},	/*Unicode: U+0039 (9)*/
  {.w_px = 2,	.glyph_index = 1000},	/*Unicode: U+003a (:)*/
  {.w_px = 3,	.glyph_index = 1020},	/*Unicode: U+003b (;)*/
  {.w_px = 7,	.glyph_index = 1040},	/*Unicode: U+003c (<)*/
  {.w_px = 7,	.glyph_index = 1080},	/*Unicode: U+003d (=)*/
  {.w_px = 7,	.glyph_index = 1120},	/*Unicode: U+003e (>)*/
  {.w_px = 7,	.glyph_index = 1160},	/*Unicode: U+003f (?)*/
  {.w_px = 14,	.glyph_index = 1200},	/*Unicode: U+0040 (@)*/
  {.w_px = 11,	.glyph_index = 1280},	/*Unicode: U+0041 (A)*/
  {.w_px = 8,	.glyph_index = 1340},	/*Unicode: U+0042 (B)*/
  {.w_px = 10,	.glyph_index = 1380},	/*Unicode: U+0043 (C)*/
  {.w_px = 9,	.glyph_index = 1440},	/*Unicode: U+0044 (D)*/
  {.w_px = 8,	.glyph_index = 1500},	/*Unicode: U+0045 (E)*/
  {.w_px = 8,	.glyph_index = 1540},	/*Unicode: U+0046 (F)*/
  {.w_px = 10,	.glyph_index = 1580},	/*Unicode: U+0047 (G)*/
  {.w_px = 9,	.glyph_index = 1640},	/*Unicode: U+0048 (H)*/
  {.w_px = 2,	.glyph_index = 1700},	/*Unicode: U+0049 (I)*/
  {.w_px = 8,	.glyph_index = 1720},	/*Unicode: U+004a (J)*/
  {.w_px = 10,	.glyph_index = 1760},	/*Unicode: U+004b (K)*/
  {.w_px = 8,	.glyph_index = 1820},	/*Unicode: U+004c (L)*/
  {.w_px = 12,	.glyph_index = 1860},	/*Unicode: U+004d (M)*/
  {.w_px = 9,	.glyph_index = 1920},	/*Unicode: U+004e (N)*/
  {.w_px = 10,	.glyph_index = 1980},	/*Unicode: U+004f (O)*/
  {.w_px = 9,	.glyph_index = 2040},	/*Unicode: U+0050 (P)*/
  {.w_px = 10,	.glyph_index = 2100},	/*Unicode: U+0051 (Q)*/
  {.w_px = 9,	.glyph_index = 2160},	/*Unicode: U+0052 (R)*/
  {.w_px = 9,	.glyph_index = 2220},	/*Unicode: U+0053 (S)*/
  {.w_px = 9,	.glyph_index = 2280},	/*Unicode: U+0054 (T)*/
  {.w_px = 9,	.glyph_index = 2340},	/*Unicode: U+0055 (U)*/
  {.w_px = 11,	.glyph_index = 2400},	/*Unicode: U+0056 (V)*/
  {.w_px = 15,	.glyph_index = 2460},	/*Unicode: U+0057 (W)*/
  {.w_px = 11,	.glyph_index = 2540},	/*Unicode: U+0058 (X)*/
  {.w_px = 10,	.glyph_index = 2600},	/*Unicode: U+0059 (Y)*/
  {.w_px = 9,	.glyph_index = 2660},	/*Unicode: U+005a (Z)*/
  {.w_px = 4,	.glyph_index = 2720},	/*Unicode: U+005b ([)*/
  {.w_px = 7,	.glyph_index = 2740},	/*Unicode: U+005c (\)*/
  {.w_px = 4,	.glyph_index = 2780},	/*Unicode: U+005d (])*/
  {.w_px = 7,	.glyph_index = 2800},	/*Unicode: U+005e (^)*/
  {.w_px = 8,	.glyph_index = 2840},	/*Unicode: U+005f (_)*/
  {.w_px = 4,	.glyph_index = 2880},	/*Unicode: U+0060 (`)*/
  {.w_px = 8,	.glyph_index = 2900},	/*Unicode: U+0061 (a)*/
  {.w_px = 8,	.glyph_index = 2940},	/*Unicode: U+0062 (b)*/
  {.w_px = 8,	.glyph_index = 2980},	/*Unicode: U+0063 (c)*/
  {.w_px = 8,	.glyph_index = 3020},	/*Unicode: U+0064 (d)*/
  {.w_px = 8,	.glyph_index = 3060},	/*Unicode: U+0065 (e)*/
  {.w_px = 6,	.glyph_index = 3100},	/*Unicode: U+0066 (f)*/
  {.w_px = 8,	.glyph_index = 3140},	/*Unicode: U+0067 (g)*/
  {.w_px = 7,	.glyph_index = 3180},	/*Unicode: U+0068 (h)*/
  {.w_px = 2,	.glyph_index = 3220},	/*Unicode: U+0069 (i)*/
  {.w_px = 3,	.glyph_index = 3240},	/*Unicode: U+006a (j)*/
  {.w_px = 8,	.glyph_index = 3260},	/*Unicode: U+006b (k)*/
  {.w_px = 2,	.glyph_index = 3300},	/*Unicode: U+006c (l)*/
  {.w_px = 13,	.glyph_index = 3320},	/*Unicode: U+006d (m)*/
  {.w_px = 7,	.glyph_index = 3400},	/*Unicode: U+006e (n)*/
  {.w_px = 8,	.glyph_index = 3440},	/*Unicode: U+006f (o)*/
  {.w_px = 8,	.glyph_index = 3480},	/*Unicode: U+0070 (p)*/
  {.w_px = 8,	.glyph_index = 3520},	/*Unicode: U+0071 (q)*/
  {.w_px = 5,	.glyph_index = 3560},	/*Unicode: U+0072 (r)*/
  {.w_px = 7,	.glyph_index = 3600},	/*Unicode: U+0073 (s)*/
  {.w_px = 6,	.glyph_index = 3640},	/*Unicode: U+0074 (t)*/
  {.w_px = 7,	.glyph_index = 3680},	/*Unicode: U+0075 (u)*/
  {.w_px = 8,	.glyph_index = 3720},	/*Unicode: U+0076 (v)*/
  {.w_px = 13,	.glyph_index = 3760},	/*Unicode: U+0077 (w)*/
  {.w_px = 8,	.glyph_index = 3840},	/*Unicode: U+0078 (x)*/
  {.w_px = 9,	.glyph_index = 3880},	/*Unicode: U+0079 (y)*/
  {.w_px = 7,	.glyph_index = 3940},	/*Unicode: U+007a (z)*/
  {.w_px = 6,	.glyph_index = 3980},	/*Unicode: U+007b ({)*/
  {.w_px = 2,	.glyph_index = 4020},	/*Unicode: U+007c (|)*/
  {.w_px = 6,	.glyph_index = 4040},	/*Unicode: U+007d (})*/
  {.w_px = 10,	.glyph_index = 4080},	/*Unicode: U+007e (~)*/
};

lv_font_t roboto20 = 
{
    .unicode_first = 32,	/*First Unicode letter in this font*/
    .unicode_last = 126,	/*Last Unicode letter in this font*/
    .h_px = 20,				/*Font height in pixels*/
    .glyph_bitmap = roboto20_glyph_bitmap,	/*Bitmap of glyphs*/
    .glyph_dsc = roboto20_glyph_dsc,		/*Description of glyphs*/
    .glyph_cnt = 95,			/*Number of glyphs in the font*/
    .unicode_list = NULL,	/*Every character in the font from 'unicode_first' to 'unicode_last'*/
    .get_bitmap = lv_font_get_bitmap_continuous,	/*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,	/*Function pointer to get glyph's width*/
    .bpp = 2,				/*Bit per pixel*/
    .monospace = 0,				/*Fix width (0: if not used)*/
    .next_page = NULL,		/*Pointer to a font extension*/
};