
#include "lv_font.h"

/***********************************************************************************
 * Roboto-Regular.ttf 16 px Font in U+0020 ( ) .. U+007e (~)  range with 4 bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t roboto16_glyph_bitmap[] = 
{
  /*Unicode: U+0020 ( ) , Width: 5 */
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 


  /*Unicode: U+0021 (!) , Width: 3 */
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x00, 0x00,  //... 
  0x0b, 0x30,  //.%. 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 


  /*Unicode: U+0022 (") , Width: 4 */
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x2f, 0x2f,  //.@.@ 
  0x2e, 0x2e,  //.@.@ 
  0x2c, 0x2c,  //.@.@ 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 


  /*Unicode: U+0023 (#) , Width: 8 */
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x0d, 0x04, 0x90,  //...@.+%. 
  0x00, 0x2c, 0x08, 0x50,  //...@.%+. 
  0x1f, 0xff, 0xff, 0xf8,  //.@@@@@@% 
  0x00, 0x85, 0x0e, 0x00,  //..%+.@.. 
  0x00, 0xc2, 0x2b, 0x00,  //..@..%.. 
  0x8e, 0xfe, 0xff, 0xe0,  //%@@@@@@. 
  0x01, 0xc0, 0x85, 0x00,  //..@.%+.. 
  0x04, 0x90, 0xb3, 0x00,  //.+%.%... 
  0x07, 0x70, 0xd0, 0x00,  //.++.@... 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 


  /*Unicode: U+0024 ($) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x02, 0xf0, 0x00,  //....@.. 
  0x00, 0x6b, 0xf8, 0x00,  //..+%@%. 
  0x0b, 0x93, 0x4d, 0x90,  //.%%.+@% 
  0x1f, 0x00, 0x04, 0xe0,  //.@...+@ 
  0x0f, 0x50, 0x00, 0x20,  //.@+.... 
  0x06, 0xfc, 0x60, 0x00,  //.+@@+.. 
  0x00, 0x17, 0xde, 0x30,  //...+@@. 
  0x00, 0x00, 0x08, 0xd0,  //.....%@ 
  0x1f, 0x10, 0x03, 0xf0,  //.@....@ 
  0x0b, 0xb3, 0x3c, 0xb0,  //.%%..@% 
  0x00, 0x7c, 0xfa, 0x10,  //..+@@%. 
  0x00, 0x02, 0xf0, 0x00,  //....@.. 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0025 (%) , Width: 9 */
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x07, 0xee, 0x50, 0x00, 0x00,  //.+@@+.... 
  0x1f, 0x24, 0xe0, 0x80, 0x00,  //.@.+@.%.. 
  0x1f, 0x25, 0xe4, 0x80, 0x00,  //.@.+@+%.. 
  0x07, 0xed, 0x5b, 0x00, 0x00,  //.+@@+%... 
  0x00, 0x00, 0x74, 0x00, 0x00,  //....++... 
  0x00, 0x02, 0xa5, 0xed, 0x50,  //....%+@@+ 
  0x00, 0x0a, 0x2f, 0x25, 0xe0,  //...%.@.+@ 
  0x00, 0x37, 0x0f, 0x25, 0xe0,  //...+.@.+@ 
  0x00, 0x00, 0x06, 0xee, 0x50,  //.....+@@+ 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0026 (&) , Width: 9 */
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x6e, 0xe4, 0x00, 0x00,  //..+@@+... 
  0x00, 0xf2, 0x5e, 0x00, 0x00,  //..@.+@... 
  0x01, 0xf1, 0x5d, 0x00, 0x00,  //..@.+@... 
  0x00, 0xba, 0xe4, 0x00, 0x00,  //..%%@+... 
  0x00, 0x9e, 0x60, 0x00, 0x00,  //..%@+.... 
  0x0b, 0x63, 0xe2, 0x4e, 0x00,  //.%+.@.+@. 
  0x1f, 0x00, 0x5e, 0xca, 0x00,  //.@..+@@%. 
  0x0e, 0x60, 0x1d, 0xf5, 0x00,  //.@+..@@+. 
  0x03, 0xcf, 0xe8, 0x8e, 0x20,  //..@@@%%@. 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0027 (') , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+0028 (() , Width: 5 */
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x02, 0x00,  //..... 
  0x00, 0x3d, 0x00,  //...@. 
  0x00, 0xd2, 0x00,  //..@.. 
  0x06, 0xa0, 0x00,  //.+%.. 
  0x0c, 0x40, 0x00,  //.@+.. 
  0x0f, 0x10, 0x00,  //.@... 
  0x1f, 0x00, 0x00,  //.@... 
  0x2f, 0x00, 0x00,  //.@... 
  0x1f, 0x10, 0x00,  //.@... 
  0x0e, 0x30, 0x00,  //.@... 
  0x0a, 0x80, 0x00,  //.%%.. 
  0x03, 0xd0, 0x00,  //..@.. 
  0x00, 0x97, 0x00,  //..%+. 
  0x00, 0x0a, 0x00,  //...%. 
  0x00, 0x00, 0x00,  //..... 


  /*Unicode: U+0029 ()) , Width: 4 */
  0x00, 0x00,  //.... 
  0x11, 0x00,  //.... 
  0x2d, 0x10,  //.@.. 
  0x05, 0xb0,  //.+%. 
  0x00, 0xd3,  //..@. 
  0x00, 0x89,  //..%% 
  0x00, 0x5d,  //..+@ 
  0x00, 0x3f,  //...@ 
  0x00, 0x2f,  //...@ 
  0x00, 0x4e,  //..+@ 
  0x00, 0x6b,  //..+% 
  0x00, 0xa7,  //..%+ 
  0x01, 0xe1,  //..@. 
  0x0a, 0x60,  //.%+. 
  0x38, 0x00,  //.%.. 
  0x00, 0x00,  //.... 


  /*Unicode: U+002a (*) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x2f, 0x00, 0x00,  //...@... 
  0x14, 0x2f, 0x04, 0x00,  //.+.@.+. 
  0x2b, 0xef, 0xea, 0x00,  //.%@@@%. 
  0x00, 0xcd, 0x80, 0x00,  //..@@%.. 
  0x07, 0xa1, 0xe3, 0x00,  //.+%.@.. 
  0x00, 0x00, 0x20, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+002b (+) , Width: 6 */
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x2f, 0x00,  //...@.. 
  0x00, 0x2f, 0x00,  //...@.. 
  0x00, 0x2f, 0x00,  //...@.. 
  0xee, 0xff, 0xee,  //@@@@@@ 
  0x00, 0x2f, 0x00,  //...@.. 
  0x00, 0x2f, 0x00,  //...@.. 
  0x00, 0x2f, 0x00,  //...@.. 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 


  /*Unicode: U+002c (,) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x2f,  //.@ 
  0x3e,  //.@ 
  0x97,  //%+ 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+002d (-) , Width: 4 */
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0xbf, 0xf4,  //%@@+ 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 


  /*Unicode: U+002e (.) , Width: 3 */
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x0c, 0x30,  //.@. 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 


  /*Unicode: U+002f (/) , Width: 5 */
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x03, 0xc0,  //....@ 
  0x00, 0x09, 0x60,  //...%+ 
  0x00, 0x0e, 0x00,  //...@. 
  0x00, 0x6a, 0x00,  //..+%. 
  0x00, 0xc3, 0x00,  //..@.. 
  0x02, 0xd0, 0x00,  //..@.. 
  0x08, 0x70, 0x00,  //.%+.. 
  0x0e, 0x10, 0x00,  //.@... 
  0x4b, 0x00, 0x00,  //+%... 
  0xb5, 0x00, 0x00,  //%+... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 


  /*Unicode: U+0030 (0) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x01, 0xae, 0xe9, 0x00,  //..%@@%. 
  0x0b, 0x90, 0x1c, 0x80,  //.%%..@% 
  0x0f, 0x10, 0x04, 0xd0,  //.@...+@ 
  0x2f, 0x00, 0x03, 0xf0,  //.@....@ 
  0x2f, 0x00, 0x02, 0xf0,  //.@....@ 
  0x2f, 0x00, 0x02, 0xf0,  //.@....@ 
  0x0f, 0x20, 0x04, 0xd0,  //.@...+@ 
  0x0b, 0xa0, 0x1c, 0x70,  //.%%..@+ 
  0x01, 0xae, 0xe9, 0x00,  //..%@@%. 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0031 (1) , Width: 4 */
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x02, 0x8e,  //..%@ 
  0x9d, 0xaf,  //%@%@ 
  0x10, 0x2f,  //...@ 
  0x00, 0x2f,  //...@ 
  0x00, 0x2f,  //...@ 
  0x00, 0x2f,  //...@ 
  0x00, 0x2f,  //...@ 
  0x00, 0x2f,  //...@ 
  0x00, 0x2f,  //...@ 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 


  /*Unicode: U+0032 (2) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x03, 0xcf, 0xc2, 0x00,  //..@@@.. 
  0x0d, 0x60, 0x8c, 0x00,  //.@+.%@. 
  0x1b, 0x00, 0x3f, 0x00,  //.%...@. 
  0x00, 0x00, 0x7b, 0x00,  //....+%. 
  0x00, 0x02, 0xe3, 0x00,  //....@.. 
  0x00, 0x1d, 0x70, 0x00,  //...@+.. 
  0x00, 0xb9, 0x00, 0x00,  //..%%... 
  0x09, 0xc0, 0x00, 0x00,  //.%@.... 
  0x2f, 0xff, 0xff, 0x60,  //.@@@@@+ 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0033 (3) , Width: 6 */
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x03, 0xcf, 0xc2,  //..@@@. 
  0x0e, 0x60, 0x7c,  //.@+.+@ 
  0x07, 0x00, 0x3f,  //.+...@ 
  0x00, 0x00, 0x8a,  //....%% 
  0x00, 0x6f, 0xe1,  //..+@@. 
  0x00, 0x00, 0x8b,  //....%% 
  0x06, 0x00, 0x3f,  //.+...@ 
  0x0e, 0x50, 0x8b,  //.@+.%% 
  0x04, 0xdf, 0xb2,  //.+@@%. 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 


  /*Unicode: U+0034 (4) , Width: 8 */
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x8f, 0x00,  //....%@.. 
  0x00, 0x02, 0xef, 0x00,  //....@@.. 
  0x00, 0x0c, 0x7f, 0x00,  //...@+@.. 
  0x00, 0x6a, 0x2f, 0x00,  //..+%.@.. 
  0x01, 0xe1, 0x2f, 0x00,  //..@..@.. 
  0x0a, 0x60, 0x2f, 0x00,  //.%+..@.. 
  0x2f, 0xee, 0xff, 0xe4,  //.@@@@@@+ 
  0x00, 0x00, 0x2f, 0x00,  //.....@.. 
  0x00, 0x00, 0x2f, 0x00,  //.....@.. 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 


  /*Unicode: U+0035 (5) , Width: 6 */
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x0f, 0xff, 0xfb,  //.@@@@% 
  0x2e, 0x00, 0x00,  //.@.... 
  0x4d, 0x00, 0x00,  //+@.... 
  0x6e, 0xde, 0xa1,  //+@@@%. 
  0x26, 0x01, 0xba,  //.+..%% 
  0x00, 0x00, 0x3e,  //.....@ 
  0x63, 0x00, 0x3e,  //+....@ 
  0x7c, 0x10, 0xba,  //+@..%% 
  0x08, 0xee, 0xa1,  //.%@@%. 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 


  /*Unicode: U+0036 (6) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x2a, 0xea, 0x00,  //...%@%. 
  0x02, 0xe7, 0x10, 0x00,  //..@+... 
  0x0b, 0x70, 0x00, 0x00,  //.%+.... 
  0x0f, 0x9d, 0xe9, 0x00,  //.@%@@%. 
  0x2f, 0x80, 0x1c, 0x90,  //.@%..@% 
  0x2f, 0x00, 0x04, 0xe0,  //.@...+@ 
  0x0f, 0x20, 0x03, 0xe0,  //.@....@ 
  0x09, 0xb1, 0x1b, 0x90,  //.%%..%% 
  0x00, 0x9e, 0xe9, 0x00,  //..%@@%. 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0037 (7) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@ 
  0x00, 0x00, 0x08, 0x90,  //.....%% 
  0x00, 0x00, 0x0e, 0x20,  //.....@. 
  0x00, 0x00, 0x7b, 0x00,  //....+%. 
  0x00, 0x00, 0xe3, 0x00,  //....@.. 
  0x00, 0x06, 0xc0, 0x00,  //...+@.. 
  0x00, 0x0d, 0x50, 0x00,  //...@+.. 
  0x00, 0x5d, 0x00, 0x00,  //..+@... 
  0x00, 0xd6, 0x00, 0x00,  //..@+... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0038 (8) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x02, 0xbe, 0xea, 0x10,  //..%@@%. 
  0x0e, 0x70, 0x0a, 0xb0,  //.@+..%% 
  0x1f, 0x00, 0x03, 0xe0,  //.@....@ 
  0x0c, 0x80, 0x0a, 0x90,  //.@%..%% 
  0x02, 0xef, 0xfc, 0x00,  //..@@@@. 
  0x0c, 0x80, 0x1a, 0x90,  //.@%..%% 
  0x1f, 0x00, 0x03, 0xe0,  //.@....@ 
  0x0e, 0x70, 0x09, 0xb0,  //.@+..%% 
  0x03, 0xbe, 0xea, 0x10,  //..%@@%. 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0039 (9) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x01, 0xbf, 0xd7, 0x00,  //..%@@+. 
  0x0c, 0x90, 0x2d, 0x60,  //.@%..@+ 
  0x1f, 0x10, 0x05, 0xc0,  //.@...+@ 
  0x1f, 0x10, 0x03, 0xf0,  //.@....@ 
  0x0c, 0x90, 0x1b, 0xf0,  //.@%..%@ 
  0x02, 0xbe, 0xd8, 0xd0,  //..%@@%@ 
  0x00, 0x00, 0x08, 0x90,  //.....%% 
  0x00, 0x01, 0x7e, 0x10,  //....+@. 
  0x00, 0xce, 0xa2, 0x00,  //..@@%.. 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+003a (:) , Width: 3 */
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x0d, 0x20,  //.@. 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x0d, 0x20,  //.@. 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 


  /*Unicode: U+003b (;) , Width: 3 */
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x2d, 0x00,  //.@. 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x2f, 0x00,  //.@. 
  0x4e, 0x00,  //+@. 
  0x97, 0x00,  //%+. 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 


  /*Unicode: U+003c (<) , Width: 5 */
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x03, 0xb0,  //....% 
  0x04, 0xce, 0x70,  //.+@@+ 
  0xcc, 0x50, 0x00,  //@@+.. 
  0x9e, 0x81, 0x00,  //%@%.. 
  0x01, 0x8f, 0xb0,  //..%@% 
  0x00, 0x01, 0x80,  //....% 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 


  /*Unicode: U+003d (=) , Width: 5 */
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0xee, 0xee, 0xe0,  //@@@@@ 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0xff, 0xff, 0xf0,  //@@@@@ 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 


  /*Unicode: U+003e (>) , Width: 6 */
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0xb4, 0x00, 0x00,  //%+.... 
  0x6c, 0xd7, 0x00,  //+@@+.. 
  0x00, 0x39, 0xe5,  //...%@+ 
  0x01, 0x7d, 0xc3,  //..+@@. 
  0xaf, 0xa3, 0x00,  //%@%... 
  0x81, 0x00, 0x00,  //%..... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 


  /*Unicode: U+003f (?) , Width: 6 */
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x04, 0xdf, 0xc2,  //.+@@@. 
  0x0f, 0x60, 0x7c,  //.@+.+@ 
  0x03, 0x00, 0x3e,  //.....@ 
  0x00, 0x00, 0x9a,  //....%% 
  0x00, 0x06, 0xe2,  //...+@. 
  0x00, 0x0f, 0x40,  //...@+. 
  0x00, 0x1b, 0x00,  //...%.. 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x09, 0x60,  //...%+. 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 


  /*Unicode: U+0040 (@) , Width: 11 */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........... 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........... 
  0x00, 0x03, 0xbe, 0xec, 0x60, 0x00,  //....%@@@+.. 
  0x00, 0x6d, 0x40, 0x03, 0xca, 0x00,  //..+@+...@%. 
  0x03, 0xe1, 0x00, 0x00, 0x0d, 0x40,  //..@......@+ 
  0x0a, 0x70, 0x3d, 0xe7, 0x07, 0xa0,  //.%+..@@+.+% 
  0x0f, 0x21, 0xe3, 0x1c, 0x04, 0xd0,  //.@..@..@.+@ 
  0x1f, 0x06, 0x90, 0x2a, 0x03, 0xf0,  //.@.+%..%..@ 
  0x2f, 0x09, 0x60, 0x48, 0x04, 0xe0,  //.@.%+.+%.+@ 
  0x0f, 0x18, 0x80, 0xa9, 0x0b, 0x90,  //.@.%%.%%.%% 
  0x0d, 0x52, 0xde, 0x4b, 0xfa, 0x10,  //.@+.@@+%@%. 
  0x07, 0xc0, 0x00, 0x00, 0x00, 0x00,  //.+@........ 
  0x00, 0xcb, 0x20, 0x13, 0x00, 0x00,  //..@%....... 
  0x00, 0x08, 0xdf, 0xd6, 0x00, 0x00,  //...%@@@+... 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........... 


  /*Unicode: U+0041 (A) , Width: 9 */
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x07, 0xe0, 0x00, 0x00,  //...+@.... 
  0x00, 0x0d, 0xc5, 0x00, 0x00,  //...@@+... 
  0x00, 0x4b, 0x4c, 0x00, 0x00,  //..+%+@... 
  0x00, 0xa5, 0x0d, 0x20, 0x00,  //..%+.@... 
  0x01, 0xd0, 0x06, 0x80, 0x00,  //..@..+%.. 
  0x07, 0xfe, 0xee, 0xe0, 0x00,  //.+@@@@@.. 
  0x0d, 0x31, 0x11, 0xb5, 0x00,  //.@....%+. 
  0x3d, 0x00, 0x00, 0x6b, 0x00,  //.@....+%. 
  0xa9, 0x00, 0x00, 0x1f, 0x10,  //%%.....@. 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0042 (B) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x2f, 0xff, 0xeb, 0x20,  //.@@@@%. 
  0x2f, 0x00, 0x09, 0xb0,  //.@...%% 
  0x2f, 0x00, 0x03, 0xf0,  //.@....@ 
  0x2f, 0x00, 0x0a, 0xa0,  //.@...%% 
  0x2f, 0xee, 0xfe, 0x20,  //.@@@@@. 
  0x2f, 0x00, 0x09, 0xb0,  //.@...%% 
  0x2f, 0x00, 0x03, 0xf0,  //.@....@ 
  0x2f, 0x00, 0x09, 0xb0,  //.@...%% 
  0x2f, 0xff, 0xea, 0x10,  //.@@@@%. 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0043 (C) , Width: 8 */
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x6d, 0xfd, 0x60,  //..+@@@+. 
  0x06, 0xd3, 0x02, 0xe5,  //.+@...@+ 
  0x0e, 0x40, 0x00, 0x7b,  //.@+...+% 
  0x1f, 0x10, 0x00, 0x00,  //.@...... 
  0x2f, 0x00, 0x00, 0x00,  //.@...... 
  0x1f, 0x00, 0x00, 0x00,  //.@...... 
  0x0e, 0x40, 0x00, 0x6a,  //.@+...+% 
  0x06, 0xd2, 0x02, 0xe5,  //.+@...@+ 
  0x00, 0x7d, 0xfd, 0x60,  //..+@@@+. 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 


  /*Unicode: U+0044 (D) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x2f, 0xff, 0xc3, 0x00,  //.@@@@.. 
  0x2f, 0x00, 0x5e, 0x30,  //.@..+@. 
  0x2f, 0x00, 0x08, 0xa0,  //.@...%% 
  0x2f, 0x00, 0x04, 0xe0,  //.@...+@ 
  0x2f, 0x00, 0x02, 0xf0,  //.@....@ 
  0x2f, 0x00, 0x04, 0xe0,  //.@...+@ 
  0x2f, 0x00, 0x08, 0xb0,  //.@...%% 
  0x2f, 0x00, 0x5f, 0x30,  //.@..+@. 
  0x2f, 0xff, 0xc4, 0x00,  //.@@@@+. 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0045 (E) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x2f, 0xff, 0xff, 0x80,  //.@@@@@% 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0xee, 0xee, 0x00,  //.@@@@@. 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0xff, 0xff, 0x90,  //.@@@@@% 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0046 (F) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x2f, 0xff, 0xff, 0x70,  //.@@@@@+ 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0xee, 0xed, 0x00,  //.@@@@@. 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0047 (G) , Width: 8 */
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x7d, 0xfe, 0x80,  //..+@@@%. 
  0x06, 0xd3, 0x01, 0xb9,  //.+@...%% 
  0x0e, 0x40, 0x00, 0x16,  //.@+....+ 
  0x1f, 0x10, 0x00, 0x00,  //.@...... 
  0x2f, 0x00, 0x5e, 0xff,  //.@..+@@@ 
  0x1f, 0x10, 0x00, 0x2f,  //.@.....@ 
  0x0e, 0x50, 0x00, 0x2f,  //.@+....@ 
  0x06, 0xe4, 0x00, 0x8e,  //.+@+..%@ 
  0x00, 0x5c, 0xfe, 0xb2,  //..+@@@%. 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 


  /*Unicode: U+0048 (H) , Width: 8 */
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x2f, 0x00, 0x00, 0x2f,  //.@.....@ 
  0x2f, 0x00, 0x00, 0x2f,  //.@.....@ 
  0x2f, 0x00, 0x00, 0x2f,  //.@.....@ 
  0x2f, 0x00, 0x00, 0x2f,  //.@.....@ 
  0x2f, 0xee, 0xee, 0xff,  //.@@@@@@@ 
  0x2f, 0x00, 0x00, 0x2f,  //.@.....@ 
  0x2f, 0x00, 0x00, 0x2f,  //.@.....@ 
  0x2f, 0x00, 0x00, 0x2f,  //.@.....@ 
  0x2f, 0x00, 0x00, 0x2f,  //.@.....@ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 


  /*Unicode: U+0049 (I) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+004a (J) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x02, 0xf0,  //......@ 
  0x00, 0x00, 0x02, 0xf0,  //......@ 
  0x00, 0x00, 0x02, 0xf0,  //......@ 
  0x00, 0x00, 0x02, 0xf0,  //......@ 
  0x00, 0x00, 0x02, 0xf0,  //......@ 
  0x00, 0x00, 0x02, 0xf0,  //......@ 
  0x18, 0x00, 0x03, 0xe0,  //.%....@ 
  0x0e, 0x70, 0x0a, 0xa0,  //.@+..%% 
  0x03, 0xbe, 0xe9, 0x10,  //..%@@%. 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+004b (K) , Width: 8 */
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x2f, 0x00, 0x05, 0xe2,  //.@...+@. 
  0x2f, 0x00, 0x4f, 0x30,  //.@..+@.. 
  0x2f, 0x03, 0xf4, 0x00,  //.@..@+.. 
  0x2f, 0x2e, 0x50, 0x00,  //.@.@+... 
  0x2f, 0xef, 0x50, 0x00,  //.@@@+... 
  0x2f, 0x75, 0xf2, 0x00,  //.@++@... 
  0x2f, 0x00, 0x8d, 0x00,  //.@..%@.. 
  0x2f, 0x00, 0x0c, 0xa0,  //.@...@%. 
  0x2f, 0x00, 0x01, 0xe7,  //.@....@+ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 


  /*Unicode: U+004c (L) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0xff, 0xff, 0x50,  //.@@@@@+ 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+004d (M) , Width: 10 */
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x2f, 0x90, 0x00, 0x00, 0xcf,  //.@%.....@@ 
  0x2f, 0xf1, 0x00, 0x03, 0xff,  //.@@.....@@ 
  0x2f, 0xb7, 0x00, 0x09, 0xaf,  //.@%+...%%@ 
  0x2f, 0x4d, 0x00, 0x0f, 0x4f,  //.@+@...@+@ 
  0x2f, 0x0d, 0x40, 0x6b, 0x2f,  //.@.@+.+%.@ 
  0x2f, 0x07, 0xa0, 0xd4, 0x2f,  //.@.+%.@+.@ 
  0x2f, 0x01, 0xf5, 0xd0, 0x2f,  //.@..@+@..@ 
  0x2f, 0x00, 0xaf, 0x70, 0x2f,  //.@..%@+..@ 
  0x2f, 0x00, 0x3f, 0x10, 0x2f,  //.@...@...@ 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+004e (N) , Width: 8 */
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x2f, 0x50, 0x00, 0x2f,  //.@+....@ 
  0x2f, 0xe1, 0x00, 0x2f,  //.@@....@ 
  0x2f, 0xbb, 0x00, 0x2f,  //.@%%...@ 
  0x2f, 0x1e, 0x60, 0x2f,  //.@.@+..@ 
  0x2f, 0x04, 0xf2, 0x2f,  //.@.+@..@ 
  0x2f, 0x00, 0x9c, 0x2f,  //.@..%@.@ 
  0x2f, 0x00, 0x0d, 0xaf,  //.@...@%@ 
  0x2f, 0x00, 0x03, 0xff,  //.@....@@ 
  0x2f, 0x00, 0x00, 0x8f,  //.@....%@ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 


  /*Unicode: U+004f (O) , Width: 8 */
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x6d, 0xfc, 0x40,  //..+@@@+. 
  0x06, 0xd3, 0x04, 0xe3,  //.+@..+@. 
  0x0e, 0x40, 0x00, 0x7b,  //.@+...+% 
  0x1f, 0x10, 0x00, 0x4e,  //.@....+@ 
  0x2f, 0x00, 0x00, 0x2f,  //.@.....@ 
  0x1f, 0x10, 0x00, 0x3e,  //.@.....@ 
  0x0e, 0x50, 0x00, 0x7b,  //.@+...+% 
  0x06, 0xd3, 0x04, 0xe3,  //.+@..+@. 
  0x00, 0x6d, 0xfc, 0x40,  //..+@@@+. 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 


  /*Unicode: U+0050 (P) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x2f, 0xff, 0xea, 0x10,  //.@@@@%. 
  0x2f, 0x00, 0x09, 0xb0,  //.@...%% 
  0x2f, 0x00, 0x03, 0xe0,  //.@....@ 
  0x2f, 0x00, 0x09, 0xb0,  //.@...%% 
  0x2f, 0xee, 0xea, 0x10,  //.@@@@%. 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0051 (Q) , Width: 8 */
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x6d, 0xfc, 0x40,  //..+@@@+. 
  0x06, 0xd3, 0x04, 0xe3,  //.+@..+@. 
  0x0e, 0x40, 0x00, 0x7b,  //.@+...+% 
  0x1f, 0x10, 0x00, 0x4e,  //.@....+@ 
  0x2f, 0x00, 0x00, 0x2f,  //.@.....@ 
  0x1f, 0x10, 0x00, 0x3e,  //.@.....@ 
  0x0e, 0x50, 0x00, 0x7b,  //.@+...+% 
  0x06, 0xd3, 0x04, 0xe4,  //.+@..+@+ 
  0x00, 0x6d, 0xff, 0xb0,  //..+@@@%. 
  0x00, 0x00, 0x01, 0xca,  //......@% 
  0x00, 0x00, 0x00, 0x02,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 


  /*Unicode: U+0052 (R) , Width: 8 */
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x2f, 0xff, 0xea, 0x10,  //.@@@@%.. 
  0x2f, 0x00, 0x09, 0xb0,  //.@...%%. 
  0x2f, 0x00, 0x03, 0xe0,  //.@....@. 
  0x2f, 0x00, 0x1a, 0xb0,  //.@...%%. 
  0x2f, 0xee, 0xfb, 0x10,  //.@@@@%.. 
  0x2f, 0x00, 0x9a, 0x00,  //.@..%%.. 
  0x2f, 0x00, 0x1f, 0x20,  //.@...@.. 
  0x2f, 0x00, 0x09, 0xa0,  //.@...%%. 
  0x2f, 0x00, 0x01, 0xf2,  //.@....@. 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 


  /*Unicode: U+0053 (S) , Width: 8 */
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x01, 0xae, 0xfd, 0x70,  //..%@@@+. 
  0x0d, 0x70, 0x02, 0xb9,  //.@+...%% 
  0x1f, 0x00, 0x00, 0x29,  //.@.....% 
  0x0b, 0xc4, 0x00, 0x00,  //.%@+.... 
  0x00, 0x5b, 0xfb, 0x50,  //..+%@%+. 
  0x00, 0x00, 0x05, 0xd8,  //.....+@% 
  0x1a, 0x00, 0x00, 0x3e,  //.%.....@ 
  0x0c, 0x91, 0x01, 0x9b,  //.@%...%% 
  0x00, 0x8d, 0xfe, 0x91,  //..%@@@%. 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 


  /*Unicode: U+0054 (T) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0xff, 0xff, 0xff, 0xf0,  //@@@@@@@ 
  0x00, 0x2f, 0x00, 0x00,  //...@... 
  0x00, 0x2f, 0x00, 0x00,  //...@... 
  0x00, 0x2f, 0x00, 0x00,  //...@... 
  0x00, 0x2f, 0x00, 0x00,  //...@... 
  0x00, 0x2f, 0x00, 0x00,  //...@... 
  0x00, 0x2f, 0x00, 0x00,  //...@... 
  0x00, 0x2f, 0x00, 0x00,  //...@... 
  0x00, 0x2f, 0x00, 0x00,  //...@... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0055 (U) , Width: 8 */
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x2f, 0x00, 0x00, 0x2f,  //.@.....@ 
  0x2f, 0x00, 0x00, 0x2f,  //.@.....@ 
  0x2f, 0x00, 0x00, 0x2f,  //.@.....@ 
  0x2f, 0x00, 0x00, 0x2f,  //.@.....@ 
  0x2f, 0x00, 0x00, 0x2f,  //.@.....@ 
  0x2f, 0x00, 0x00, 0x2f,  //.@.....@ 
  0x1f, 0x10, 0x00, 0x4e,  //.@....+@ 
  0x0b, 0xa1, 0x02, 0xc8,  //.%%...@% 
  0x01, 0x9e, 0xfd, 0x70,  //..%@@@+. 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 


  /*Unicode: U+0056 (V) , Width: 9 */
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0xaa, 0x00, 0x00, 0x6e, 0x00,  //%%....+@. 
  0x4f, 0x00, 0x00, 0xc8, 0x00,  //+@....@%. 
  0x0d, 0x60, 0x02, 0xf2, 0x00,  //.@+...@.. 
  0x07, 0xb0, 0x07, 0xc0, 0x00,  //.+%..+@.. 
  0x01, 0xf1, 0x0d, 0x60, 0x00,  //..@..@+.. 
  0x00, 0xb7, 0x3f, 0x00, 0x00,  //..%+.@... 
  0x00, 0x5c, 0x89, 0x00, 0x00,  //..+@%%... 
  0x00, 0x0e, 0xe3, 0x00, 0x00,  //...@@.... 
  0x00, 0x09, 0xd0, 0x00, 0x00,  //...%@.... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //......... 


  /*Unicode: U+0057 (W) , Width: 12 */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............ 
  0x7b, 0x00, 0x0d, 0x70, 0x01, 0xf1,  //+%...@+...@. 
  0x3f, 0x00, 0x1f, 0xc0, 0x05, 0xd0,  //.@...@@..+@. 
  0x0f, 0x30, 0x6b, 0xf1, 0x08, 0x90,  //.@..+%@..%%. 
  0x0b, 0x60, 0xb6, 0xb5, 0x0c, 0x60,  //.%+.%+%+.@+. 
  0x07, 0xa0, 0xf1, 0x6a, 0x0f, 0x20,  //.+%.@.+%.@.. 
  0x03, 0xe4, 0xc0, 0x1e, 0x4e, 0x00,  //..@+@..@+@.. 
  0x00, 0xfa, 0x70, 0x0d, 0xaa, 0x00,  //..@%+..@%%.. 
  0x00, 0xbf, 0x20, 0x08, 0xf6, 0x00,  //..%@...%@+.. 
  0x00, 0x7e, 0x00, 0x03, 0xf2, 0x00,  //..+@....@... 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............ 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............ 


  /*Unicode: U+0058 (X) , Width: 8 */
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x3f, 0x30, 0x01, 0xe6,  //.@....@+ 
  0x09, 0xc0, 0x0a, 0xb0,  //.%@..%%. 
  0x00, 0xe7, 0x4f, 0x20,  //..@++@.. 
  0x00, 0x4f, 0xe7, 0x00,  //..+@@+.. 
  0x00, 0x0c, 0xf0, 0x00,  //...@@... 
  0x00, 0x5f, 0xd7, 0x00,  //..+@@+.. 
  0x01, 0xe6, 0x4f, 0x20,  //..@++@.. 
  0x0a, 0xc0, 0x09, 0xc0,  //.%@..%@. 
  0x4f, 0x20, 0x00, 0xe7,  //+@....@+ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 


  /*Unicode: U+0059 (Y) , Width: 8 */
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0xf4, 0x00, 0x07, 0xd0,  //@+...+@. 
  0x8c, 0x00, 0x0e, 0x50,  //%@...@+. 
  0x0e, 0x50, 0x8c, 0x00,  //.@+.%@.. 
  0x06, 0xd1, 0xf3, 0x00,  //.+@.@... 
  0x00, 0xcd, 0xa0, 0x00,  //..@@%... 
  0x00, 0x4f, 0x10, 0x00,  //..+@.... 
  0x00, 0x2f, 0x00, 0x00,  //...@.... 
  0x00, 0x2f, 0x00, 0x00,  //...@.... 
  0x00, 0x2f, 0x00, 0x00,  //...@.... 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 


  /*Unicode: U+005a (Z) , Width: 8 */
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0xff, 0xff, 0xff, 0xf0,  //@@@@@@@. 
  0x00, 0x00, 0x1e, 0x70,  //.....@+. 
  0x00, 0x00, 0xbb, 0x00,  //....%%.. 
  0x00, 0x07, 0xe1, 0x00,  //...+@... 
  0x00, 0x4f, 0x30, 0x00,  //..+@.... 
  0x01, 0xe7, 0x00, 0x00,  //..@+.... 
  0x0c, 0xb0, 0x00, 0x00,  //.@%..... 
  0x8e, 0x10, 0x00, 0x00,  //%@...... 
  0xff, 0xff, 0xff, 0xf3,  //@@@@@@@. 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 
  0x00, 0x00, 0x00, 0x00,  //........ 


  /*Unicode: U+005b ([) , Width: 4 */
  0x00, 0x00,  //.... 
  0x2f, 0xe2,  //.@@. 
  0x2f, 0x00,  //.@.. 
  0x2f, 0x00,  //.@.. 
  0x2f, 0x00,  //.@.. 
  0x2f, 0x00,  //.@.. 
  0x2f, 0x00,  //.@.. 
  0x2f, 0x00,  //.@.. 
  0x2f, 0x00,  //.@.. 
  0x2f, 0x00,  //.@.. 
  0x2f, 0x00,  //.@.. 
  0x2f, 0x00,  //.@.. 
  0x2f, 0x00,  //.@.. 
  0x2f, 0xf3,  //.@@. 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 


  /*Unicode: U+005c (\) , Width: 6 */
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x89, 0x00, 0x00,  //%%.... 
  0x2e, 0x00, 0x00,  //.@.... 
  0x0c, 0x50, 0x00,  //.@+... 
  0x06, 0xb0, 0x00,  //.+%... 
  0x00, 0xf1, 0x00,  //..@... 
  0x00, 0xa7, 0x00,  //..%+.. 
  0x00, 0x3d, 0x00,  //...@.. 
  0x00, 0x0d, 0x40,  //...@+. 
  0x00, 0x07, 0xa0,  //...+%. 
  0x00, 0x01, 0xf1,  //....@. 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 


  /*Unicode: U+005d (]) , Width: 2 */
  0x00,  //.. 
  0xff,  //@@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0xff,  //@@ 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+005e (^) , Width: 5 */
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0xe5, 0x00,  //..@+. 
  0x05, 0xeb, 0x00,  //.+@%. 
  0x0c, 0x5e, 0x20,  //.@+@. 
  0x2e, 0x07, 0x90,  //.@.+% 
  0x34, 0x01, 0x70,  //.+..+ 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 


  /*Unicode: U+005f (_) , Width: 6 */
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0xef, 0xff, 0xfc,  //@@@@@@ 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 


  /*Unicode: U+0060 (`) , Width: 3 */
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x3f, 0x10,  //.@. 
  0x06, 0xb0,  //.+% 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 


  /*Unicode: U+0061 (a) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x02, 0xcf, 0xd3, 0x00,  //..@@@.. 
  0x0d, 0x70, 0x7d, 0x00,  //.@+.+@. 
  0x02, 0x00, 0x2f, 0x00,  //.....@. 
  0x04, 0xce, 0xff, 0x00,  //.+@@@@. 
  0x0f, 0x50, 0x2f, 0x00,  //.@+..@. 
  0x1f, 0x30, 0x7f, 0x00,  //.@..+@. 
  0x07, 0xee, 0x8f, 0x20,  //.+@@%@. 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0062 (b) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x7d, 0xe9, 0x00,  //.@+@@%. 
  0x2f, 0x70, 0x1c, 0x80,  //.@+..@% 
  0x2f, 0x00, 0x05, 0xd0,  //.@...+@ 
  0x2f, 0x00, 0x03, 0xf0,  //.@....@ 
  0x2f, 0x00, 0x05, 0xd0,  //.@...+@ 
  0x2f, 0x70, 0x1c, 0x80,  //.@+..@% 
  0x2f, 0x8e, 0xe9, 0x00,  //.@%@@%. 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0063 (c) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x9e, 0xe9, 0x00,  //..%@@%. 
  0x0a, 0xa0, 0x1b, 0x90,  //.%%..%% 
  0x0f, 0x20, 0x02, 0x50,  //.@....+ 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x0f, 0x10, 0x01, 0x30,  //.@..... 
  0x0a, 0xa0, 0x1b, 0x90,  //.%%..%% 
  0x00, 0x9e, 0xe9, 0x00,  //..%@@%. 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0064 (d) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x02, 0xf0,  //......@ 
  0x00, 0x00, 0x02, 0xf0,  //......@ 
  0x00, 0x00, 0x02, 0xf0,  //......@ 
  0x01, 0xae, 0xd9, 0xf0,  //..%@@%@ 
  0x0a, 0xb1, 0x19, 0xf0,  //.%%..%@ 
  0x0f, 0x20, 0x02, 0xf0,  //.@....@ 
  0x2f, 0x00, 0x02, 0xf0,  //.@....@ 
  0x0f, 0x20, 0x02, 0xf0,  //.@....@ 
  0x0a, 0xa0, 0x19, 0xf0,  //.%%..%@ 
  0x01, 0xae, 0xd8, 0xf0,  //..%@@%@ 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0065 (e) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x8e, 0xe9, 0x00,  //..%@@%. 
  0x09, 0xb1, 0x0b, 0x80,  //.%%..%% 
  0x0f, 0x20, 0x03, 0xd0,  //.@....@ 
  0x2f, 0xee, 0xef, 0xe0,  //.@@@@@@ 
  0x0f, 0x10, 0x00, 0x00,  //.@..... 
  0x0a, 0xa1, 0x05, 0x70,  //.%%..++ 
  0x00, 0x9e, 0xfc, 0x20,  //..%@@@. 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0066 (f) , Width: 5 */
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x5e, 0xc0,  //..+@@ 
  0x00, 0xf4, 0x00,  //..@+. 
  0x02, 0xf0, 0x00,  //..@.. 
  0x3f, 0xff, 0x60,  //.@@@+ 
  0x02, 0xf0, 0x00,  //..@.. 
  0x02, 0xf0, 0x00,  //..@.. 
  0x02, 0xf0, 0x00,  //..@.. 
  0x02, 0xf0, 0x00,  //..@.. 
  0x02, 0xf0, 0x00,  //..@.. 
  0x02, 0xf0, 0x00,  //..@.. 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 


  /*Unicode: U+0067 (g) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x01, 0xae, 0xd7, 0xf0,  //..%@@+@ 
  0x0a, 0xb0, 0x19, 0xf0,  //.%%..%@ 
  0x0f, 0x20, 0x02, 0xf0,  //.@....@ 
  0x2f, 0x00, 0x02, 0xf0,  //.@....@ 
  0x0f, 0x20, 0x02, 0xf0,  //.@....@ 
  0x0a, 0xb0, 0x19, 0xf0,  //.%%..%@ 
  0x01, 0xae, 0xd9, 0xf0,  //..%@@%@ 
  0x00, 0x00, 0x04, 0xe0,  //.....+@ 
  0x09, 0x60, 0x1c, 0x90,  //.%+..@% 
  0x02, 0xbf, 0xe9, 0x00,  //..%@@%. 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0068 (h) , Width: 6 */
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x2f, 0x00, 0x00,  //.@.... 
  0x2f, 0x00, 0x00,  //.@.... 
  0x2f, 0x00, 0x00,  //.@.... 
  0x2f, 0x7e, 0xe4,  //.@+@@+ 
  0x2f, 0x70, 0x7d,  //.@+.+@ 
  0x2f, 0x00, 0x2f,  //.@...@ 
  0x2f, 0x00, 0x2f,  //.@...@ 
  0x2f, 0x00, 0x2f,  //.@...@ 
  0x2f, 0x00, 0x2f,  //.@...@ 
  0x2f, 0x00, 0x2f,  //.@...@ 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 


  /*Unicode: U+0069 (i) , Width: 3 */
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x0c, 0x20,  //.@. 
  0x00, 0x00,  //... 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 


  /*Unicode: U+006a (j) , Width: 3 */
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x00, 0x00,  //... 
  0x1d, 0x00,  //.@. 
  0x00, 0x00,  //... 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x2f, 0x00,  //.@. 
  0x5e, 0x00,  //+@. 
  0xf6, 0x00,  //@+. 
  0x00, 0x00,  //... 


  /*Unicode: U+006b (k) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0xab, 0x00,  //.@..%%. 
  0x2f, 0x09, 0xc0, 0x00,  //.@.%@.. 
  0x2f, 0x8d, 0x10, 0x00,  //.@%@... 
  0x2f, 0xfe, 0x10, 0x00,  //.@@@... 
  0x2f, 0x2b, 0xa0, 0x00,  //.@.%%.. 
  0x2f, 0x01, 0xe6, 0x00,  //.@..@+. 
  0x2f, 0x00, 0x3f, 0x20,  //.@...@. 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+006c (l) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+006d (m) , Width: 10 */
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x2f, 0x8e, 0xe5, 0x9f, 0xd4,  //.@%@@+%@@+ 
  0x2f, 0x60, 0x7f, 0x60, 0x7d,  //.@+.+@+.+@ 
  0x2f, 0x00, 0x2f, 0x00, 0x2f,  //.@...@...@ 
  0x2f, 0x00, 0x2f, 0x00, 0x2f,  //.@...@...@ 
  0x2f, 0x00, 0x2f, 0x00, 0x2f,  //.@...@...@ 
  0x2f, 0x00, 0x2f, 0x00, 0x2f,  //.@...@...@ 
  0x2f, 0x00, 0x2f, 0x00, 0x2f,  //.@...@...@ 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+006e (n) , Width: 6 */
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x2f, 0x7e, 0xe4,  //.@+@@+ 
  0x2f, 0x70, 0x7d,  //.@+.+@ 
  0x2f, 0x00, 0x2f,  //.@...@ 
  0x2f, 0x00, 0x2f,  //.@...@ 
  0x2f, 0x00, 0x2f,  //.@...@ 
  0x2f, 0x00, 0x2f,  //.@...@ 
  0x2f, 0x00, 0x2f,  //.@...@ 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 


  /*Unicode: U+006f (o) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0xae, 0xe7, 0x00,  //..%@@+. 
  0x0a, 0xb0, 0x1d, 0x60,  //.%%..@+ 
  0x0f, 0x20, 0x05, 0xd0,  //.@...+@ 
  0x2f, 0x00, 0x03, 0xf0,  //.@....@ 
  0x0f, 0x20, 0x05, 0xd0,  //.@...+@ 
  0x0a, 0xa0, 0x1c, 0x70,  //.%%..@+ 
  0x00, 0x9e, 0xe8, 0x00,  //..%@@%. 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0070 (p) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x2f, 0x8e, 0xe9, 0x00,  //.@%@@%. 
  0x2f, 0x60, 0x2d, 0x80,  //.@+..@% 
  0x2f, 0x00, 0x05, 0xd0,  //.@...+@ 
  0x2f, 0x00, 0x03, 0xf0,  //.@....@ 
  0x2f, 0x00, 0x05, 0xd0,  //.@...+@ 
  0x2f, 0x60, 0x2d, 0x70,  //.@+..@+ 
  0x2f, 0x8e, 0xe9, 0x00,  //.@%@@%. 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x2f, 0x00, 0x00, 0x00,  //.@..... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0071 (q) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x01, 0xae, 0xd8, 0xf0,  //..%@@%@ 
  0x0a, 0xb1, 0x09, 0xf0,  //.%%..%@ 
  0x0f, 0x20, 0x02, 0xf0,  //.@....@ 
  0x2f, 0x00, 0x02, 0xf0,  //.@....@ 
  0x0f, 0x20, 0x02, 0xf0,  //.@....@ 
  0x0a, 0xb1, 0x09, 0xf0,  //.%%..%@ 
  0x01, 0xae, 0xd9, 0xf0,  //..%@@%@ 
  0x00, 0x00, 0x02, 0xf0,  //......@ 
  0x00, 0x00, 0x02, 0xf0,  //......@ 
  0x00, 0x00, 0x02, 0xf0,  //......@ 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0072 (r) , Width: 5 */
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x2f, 0xae, 0x20,  //.@%@. 
  0x2f, 0x50, 0x00,  //.@+.. 
  0x2f, 0x00, 0x00,  //.@... 
  0x2f, 0x00, 0x00,  //.@... 
  0x2f, 0x00, 0x00,  //.@... 
  0x2f, 0x00, 0x00,  //.@... 
  0x2f, 0x00, 0x00,  //.@... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 


  /*Unicode: U+0073 (s) , Width: 6 */
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x05, 0xdf, 0xc2,  //.+@@@. 
  0x1f, 0x30, 0x8d,  //.@..%@ 
  0x1f, 0x60, 0x01,  //.@+... 
  0x03, 0xbe, 0xb2,  //..%@%. 
  0x02, 0x00, 0x7d,  //....+@ 
  0x0e, 0x20, 0x6d,  //.@..+@ 
  0x04, 0xdf, 0xc3,  //.+@@@. 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 


  /*Unicode: U+0074 (t) , Width: 4 */
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x17, 0x00,  //.+.. 
  0x2f, 0x00,  //.@.. 
  0xff, 0xf4,  //@@@+ 
  0x2f, 0x00,  //.@.. 
  0x2f, 0x00,  //.@.. 
  0x2f, 0x00,  //.@.. 
  0x2f, 0x00,  //.@.. 
  0x2f, 0x20,  //.@.. 
  0x0a, 0xf4,  //.%@+ 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 
  0x00, 0x00,  //.... 


  /*Unicode: U+0075 (u) , Width: 6 */
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x2f, 0x00, 0x2f,  //.@...@ 
  0x2f, 0x00, 0x2f,  //.@...@ 
  0x2f, 0x00, 0x2f,  //.@...@ 
  0x2f, 0x00, 0x2f,  //.@...@ 
  0x2f, 0x00, 0x2f,  //.@...@ 
  0x0f, 0x40, 0x8f,  //.@+.%@ 
  0x06, 0xee, 0x9f,  //.+@@%@ 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 


  /*Unicode: U+0076 (v) , Width: 6 */
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x99, 0x00, 0x4e,  //%%..+@ 
  0x4e, 0x00, 0x98,  //+@..%% 
  0x0e, 0x30, 0xe2,  //.@..@. 
  0x08, 0x83, 0xd0,  //.%%.@. 
  0x03, 0xd9, 0x70,  //..@%+. 
  0x00, 0xdf, 0x10,  //..@@.. 
  0x00, 0x7c, 0x00,  //..+@.. 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 


  /*Unicode: U+0077 (w) , Width: 10 */
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x99, 0x00, 0xc7, 0x00, 0xd5,  //%%..@+..@+ 
  0x4d, 0x01, 0xfc, 0x01, 0xf0,  //+@..@@..@. 
  0x0f, 0x15, 0x9e, 0x15, 0xb0,  //.@.+%@.+%. 
  0x0b, 0x5a, 0x49, 0x69, 0x70,  //.%+%+%+%+. 
  0x07, 0xae, 0x04, 0xbd, 0x20,  //.+%@.+%@.. 
  0x02, 0xfa, 0x00, 0xee, 0x00,  //..@%..@@.. 
  0x00, 0xd5, 0x00, 0xa9, 0x00,  //..@+..%%.. 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 
  0x00, 0x00, 0x00, 0x00, 0x00,  //.......... 


  /*Unicode: U+0078 (x) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x5e, 0x00, 0x9c, 0x00,  //+@..%@. 
  0x0b, 0x82, 0xf2, 0x00,  //.%%.@.. 
  0x01, 0xed, 0x70, 0x00,  //..@@+.. 
  0x00, 0x9f, 0x00, 0x00,  //..%@... 
  0x02, 0xec, 0x80, 0x00,  //..@@%.. 
  0x0b, 0x82, 0xf2, 0x00,  //.%%.@.. 
  0x6e, 0x00, 0x8c, 0x00,  //+@..%@. 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


  /*Unicode: U+0079 (y) , Width: 6 */
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0xa9, 0x00, 0x6d,  //%%..+@ 
  0x5e, 0x00, 0xb7,  //+@..%+ 
  0x0f, 0x30, 0xf2,  //.@..@. 
  0x0a, 0x84, 0xd0,  //.%%+@. 
  0x04, 0xd9, 0x70,  //.+@%+. 
  0x00, 0xef, 0x20,  //..@@.. 
  0x00, 0x9c, 0x00,  //..%@.. 
  0x00, 0x97, 0x00,  //..%+.. 
  0x02, 0xe1, 0x00,  //..@... 
  0x6e, 0x60, 0x00,  //+@+... 
  0x00, 0x00, 0x00,  //...... 


  /*Unicode: U+007a (z) , Width: 6 */
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0xef, 0xff, 0xf7,  //@@@@@+ 
  0x00, 0x07, 0xe1,  //...+@. 
  0x00, 0x3f, 0x30,  //...@.. 
  0x01, 0xe7, 0x00,  //..@+.. 
  0x0b, 0xa0, 0x00,  //.%%... 
  0x8d, 0x00, 0x00,  //%@.... 
  0xff, 0xff, 0xfa,  //@@@@@% 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 
  0x00, 0x00, 0x00,  //...... 


  /*Unicode: U+007b ({) , Width: 5 */
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x07, 0x20,  //...+. 
  0x00, 0xb9, 0x00,  //..%%. 
  0x01, 0xf1, 0x00,  //..@.. 
  0x02, 0xf0, 0x00,  //..@.. 
  0x02, 0xf0, 0x00,  //..@.. 
  0x08, 0xc0, 0x00,  //.%@.. 
  0x8f, 0x40, 0x00,  //%@+.. 
  0x07, 0xc0, 0x00,  //.+@.. 
  0x02, 0xf0, 0x00,  //..@.. 
  0x02, 0xf0, 0x00,  //..@.. 
  0x01, 0xf1, 0x00,  //..@.. 
  0x00, 0xa9, 0x00,  //..%%. 
  0x00, 0x07, 0x20,  //...+. 
  0x00, 0x00, 0x00,  //..... 


  /*Unicode: U+007c (|) , Width: 2 */
  0x00,  //.. 
  0x00,  //.. 
  0x00,  //.. 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x2f,  //.@ 
  0x00,  //.. 
  0x00,  //.. 


  /*Unicode: U+007d (}) , Width: 5 */
  0x00, 0x00, 0x00,  //..... 
  0x00, 0x00, 0x00,  //..... 
  0x36, 0x00, 0x00,  //.+... 
  0x0b, 0x80, 0x00,  //.%%.. 
  0x04, 0xe0, 0x00,  //.+@.. 
  0x02, 0xf0, 0x00,  //..@.. 
  0x02, 0xf0, 0x00,  //..@.. 
  0x00, 0xe5, 0x00,  //..@+. 
  0x00, 0x6f, 0x50,  //..+@+ 
  0x00, 0xe5, 0x00,  //..@+. 
  0x02, 0xf0, 0x00,  //..@.. 
  0x02, 0xf0, 0x00,  //..@.. 
  0x03, 0xe0, 0x00,  //..@.. 
  0x0b, 0x80, 0x00,  //.%%.. 
  0x36, 0x00, 0x00,  //.+... 
  0x00, 0x00, 0x00,  //..... 


  /*Unicode: U+007e (~) , Width: 7 */
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x2d, 0xd3, 0x00, 0xe0,  //.@@...@ 
  0xc4, 0x3d, 0x35, 0xb0,  //@+.@.+% 
  0xb0, 0x03, 0xdc, 0x20,  //%...@@. 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 
  0x00, 0x00, 0x00, 0x00,  //....... 


};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t roboto16_glyph_dsc[] = 
{
  {.w_px = 5,	.glyph_index = 0},	/*Unicode: U+0020 ( )*/
  {.w_px = 3,	.glyph_index = 48},	/*Unicode: U+0021 (!)*/
  {.w_px = 4,	.glyph_index = 80},	/*Unicode: U+0022 (")*/
  {.w_px = 8,	.glyph_index = 112},	/*Unicode: U+0023 (#)*/
  {.w_px = 7,	.glyph_index = 176},	/*Unicode: U+0024 ($)*/
  {.w_px = 9,	.glyph_index = 240},	/*Unicode: U+0025 (%)*/
  {.w_px = 9,	.glyph_index = 320},	/*Unicode: U+0026 (&)*/
  {.w_px = 2,	.glyph_index = 400},	/*Unicode: U+0027 (')*/
  {.w_px = 5,	.glyph_index = 416},	/*Unicode: U+0028 (()*/
  {.w_px = 4,	.glyph_index = 464},	/*Unicode: U+0029 ())*/
  {.w_px = 7,	.glyph_index = 496},	/*Unicode: U+002a (*)*/
  {.w_px = 6,	.glyph_index = 560},	/*Unicode: U+002b (+)*/
  {.w_px = 2,	.glyph_index = 608},	/*Unicode: U+002c (,)*/
  {.w_px = 4,	.glyph_index = 624},	/*Unicode: U+002d (-)*/
  {.w_px = 3,	.glyph_index = 656},	/*Unicode: U+002e (.)*/
  {.w_px = 5,	.glyph_index = 688},	/*Unicode: U+002f (/)*/
  {.w_px = 7,	.glyph_index = 736},	/*Unicode: U+0030 (0)*/
  {.w_px = 4,	.glyph_index = 800},	/*Unicode: U+0031 (1)*/
  {.w_px = 7,	.glyph_index = 832},	/*Unicode: U+0032 (2)*/
  {.w_px = 6,	.glyph_index = 896},	/*Unicode: U+0033 (3)*/
  {.w_px = 8,	.glyph_index = 944},	/*Unicode: U+0034 (4)*/
  {.w_px = 6,	.glyph_index = 1008},	/*Unicode: U+0035 (5)*/
  {.w_px = 7,	.glyph_index = 1056},	/*Unicode: U+0036 (6)*/
  {.w_px = 7,	.glyph_index = 1120},	/*Unicode: U+0037 (7)*/
  {.w_px = 7,	.glyph_index = 1184},	/*Unicode: U+0038 (8)*/
  {.w_px = 7,	.glyph_index = 1248},	/*Unicode: U+0039 (9)*/
  {.w_px = 3,	.glyph_index = 1312},	/*Unicode: U+003a (:)*/
  {.w_px = 3,	.glyph_index = 1344},	/*Unicode: U+003b (;)*/
  {.w_px = 5,	.glyph_index = 1376},	/*Unicode: U+003c (<)*/
  {.w_px = 5,	.glyph_index = 1424},	/*Unicode: U+003d (=)*/
  {.w_px = 6,	.glyph_index = 1472},	/*Unicode: U+003e (>)*/
  {.w_px = 6,	.glyph_index = 1520},	/*Unicode: U+003f (?)*/
  {.w_px = 11,	.glyph_index = 1568},	/*Unicode: U+0040 (@)*/
  {.w_px = 9,	.glyph_index = 1664},	/*Unicode: U+0041 (A)*/
  {.w_px = 7,	.glyph_index = 1744},	/*Unicode: U+0042 (B)*/
  {.w_px = 8,	.glyph_index = 1808},	/*Unicode: U+0043 (C)*/
  {.w_px = 7,	.glyph_index = 1872},	/*Unicode: U+0044 (D)*/
  {.w_px = 7,	.glyph_index = 1936},	/*Unicode: U+0045 (E)*/
  {.w_px = 7,	.glyph_index = 2000},	/*Unicode: U+0046 (F)*/
  {.w_px = 8,	.glyph_index = 2064},	/*Unicode: U+0047 (G)*/
  {.w_px = 8,	.glyph_index = 2128},	/*Unicode: U+0048 (H)*/
  {.w_px = 2,	.glyph_index = 2192},	/*Unicode: U+0049 (I)*/
  {.w_px = 7,	.glyph_index = 2208},	/*Unicode: U+004a (J)*/
  {.w_px = 8,	.glyph_index = 2272},	/*Unicode: U+004b (K)*/
  {.w_px = 7,	.glyph_index = 2336},	/*Unicode: U+004c (L)*/
  {.w_px = 10,	.glyph_index = 2400},	/*Unicode: U+004d (M)*/
  {.w_px = 8,	.glyph_index = 2480},	/*Unicode: U+004e (N)*/
  {.w_px = 8,	.glyph_index = 2544},	/*Unicode: U+004f (O)*/
  {.w_px = 7,	.glyph_index = 2608},	/*Unicode: U+0050 (P)*/
  {.w_px = 8,	.glyph_index = 2672},	/*Unicode: U+0051 (Q)*/
  {.w_px = 8,	.glyph_index = 2736},	/*Unicode: U+0052 (R)*/
  {.w_px = 8,	.glyph_index = 2800},	/*Unicode: U+0053 (S)*/
  {.w_px = 7,	.glyph_index = 2864},	/*Unicode: U+0054 (T)*/
  {.w_px = 8,	.glyph_index = 2928},	/*Unicode: U+0055 (U)*/
  {.w_px = 9,	.glyph_index = 2992},	/*Unicode: U+0056 (V)*/
  {.w_px = 12,	.glyph_index = 3072},	/*Unicode: U+0057 (W)*/
  {.w_px = 8,	.glyph_index = 3168},	/*Unicode: U+0058 (X)*/
  {.w_px = 8,	.glyph_index = 3232},	/*Unicode: U+0059 (Y)*/
  {.w_px = 8,	.glyph_index = 3296},	/*Unicode: U+005a (Z)*/
  {.w_px = 4,	.glyph_index = 3360},	/*Unicode: U+005b ([)*/
  {.w_px = 6,	.glyph_index = 3392},	/*Unicode: U+005c (\)*/
  {.w_px = 2,	.glyph_index = 3440},	/*Unicode: U+005d (])*/
  {.w_px = 5,	.glyph_index = 3456},	/*Unicode: U+005e (^)*/
  {.w_px = 6,	.glyph_index = 3504},	/*Unicode: U+005f (_)*/
  {.w_px = 3,	.glyph_index = 3552},	/*Unicode: U+0060 (`)*/
  {.w_px = 7,	.glyph_index = 3584},	/*Unicode: U+0061 (a)*/
  {.w_px = 7,	.glyph_index = 3648},	/*Unicode: U+0062 (b)*/
  {.w_px = 7,	.glyph_index = 3712},	/*Unicode: U+0063 (c)*/
  {.w_px = 7,	.glyph_index = 3776},	/*Unicode: U+0064 (d)*/
  {.w_px = 7,	.glyph_index = 3840},	/*Unicode: U+0065 (e)*/
  {.w_px = 5,	.glyph_index = 3904},	/*Unicode: U+0066 (f)*/
  {.w_px = 7,	.glyph_index = 3952},	/*Unicode: U+0067 (g)*/
  {.w_px = 6,	.glyph_index = 4016},	/*Unicode: U+0068 (h)*/
  {.w_px = 3,	.glyph_index = 4064},	/*Unicode: U+0069 (i)*/
  {.w_px = 3,	.glyph_index = 4096},	/*Unicode: U+006a (j)*/
  {.w_px = 7,	.glyph_index = 4128},	/*Unicode: U+006b (k)*/
  {.w_px = 2,	.glyph_index = 4192},	/*Unicode: U+006c (l)*/
  {.w_px = 10,	.glyph_index = 4208},	/*Unicode: U+006d (m)*/
  {.w_px = 6,	.glyph_index = 4288},	/*Unicode: U+006e (n)*/
  {.w_px = 7,	.glyph_index = 4336},	/*Unicode: U+006f (o)*/
  {.w_px = 7,	.glyph_index = 4400},	/*Unicode: U+0070 (p)*/
  {.w_px = 7,	.glyph_index = 4464},	/*Unicode: U+0071 (q)*/
  {.w_px = 5,	.glyph_index = 4528},	/*Unicode: U+0072 (r)*/
  {.w_px = 6,	.glyph_index = 4576},	/*Unicode: U+0073 (s)*/
  {.w_px = 4,	.glyph_index = 4624},	/*Unicode: U+0074 (t)*/
  {.w_px = 6,	.glyph_index = 4656},	/*Unicode: U+0075 (u)*/
  {.w_px = 6,	.glyph_index = 4704},	/*Unicode: U+0076 (v)*/
  {.w_px = 10,	.glyph_index = 4752},	/*Unicode: U+0077 (w)*/
  {.w_px = 7,	.glyph_index = 4832},	/*Unicode: U+0078 (x)*/
  {.w_px = 6,	.glyph_index = 4896},	/*Unicode: U+0079 (y)*/
  {.w_px = 6,	.glyph_index = 4944},	/*Unicode: U+007a (z)*/
  {.w_px = 5,	.glyph_index = 4992},	/*Unicode: U+007b ({)*/
  {.w_px = 2,	.glyph_index = 5040},	/*Unicode: U+007c (|)*/
  {.w_px = 5,	.glyph_index = 5056},	/*Unicode: U+007d (})*/
  {.w_px = 7,	.glyph_index = 5104},	/*Unicode: U+007e (~)*/
};

lv_font_t roboto16 = 
{
    .unicode_first = 32,	/*First Unicode letter in this font*/
    .unicode_last = 126,	/*Last Unicode letter in this font*/
    .h_px = 16,				/*Font height in pixels*/
    .glyph_bitmap = roboto16_glyph_bitmap,	/*Bitmap of glyphs*/
    .glyph_dsc = roboto16_glyph_dsc,		/*Description of glyphs*/
    .glyph_cnt = 95,			/*Number of glyphs in the font*/
    .unicode_list = NULL,	/*Every character in the font from 'unicode_first' to 'unicode_last'*/
    .get_bitmap = lv_font_get_bitmap_continuous,	/*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,	/*Function pointer to get glyph's width*/
    .bpp = 4,				/*Bit per pixel*/
    .monospace = 0,				/*Fix width (0: if not used)*/
    .next_page = NULL,		/*Pointer to a font extension*/
};