
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_SYMBOL_40 != 0  /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * fontawesome-webfont.ttf 40 px Font in U+f000 () .. U+f2ee ()  range with 1 bpp
 * Sparse font with only these characters:     
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_symbol_40_glyph_bitmap[] = {
#if USE_LV_FONT_SYMBOL_40 == 1
    /*Unicode: U+f001 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x03, 0x80,  //.............................+%@%.
    0x00, 0x00, 0x00, 0x1f, 0xc0,  //..........................+%@@@@@%
    0x00, 0x00, 0x00, 0xff, 0xc0,  //.......................+@@@@@@@@@@
    0x00, 0x00, 0x0f, 0xff, 0xc0,  //...................+%@@@@@@@@@@@@@
    0x00, 0x00, 0x7f, 0xff, 0xc0,  //................+%@@@@@@@@@@@@@@@@
    0x00, 0x03, 0xff, 0xff, 0xc0,  //.............+%@@@@@@@@@@@@@@@@@@@
    0x00, 0x0f, 0xff, 0xff, 0xc0,  //...........+@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x1f, 0xff, 0xff, 0xc0,  //...........@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x1f, 0xff, 0xff, 0xc0,  //...........@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x1f, 0xff, 0xff, 0xc0,  //...........@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x1f, 0xff, 0xff, 0xc0,  //...........@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x1f, 0xff, 0xff, 0xc0,  //...........@@@@@@@@@@@@@@@@@@@%@@@
    0x00, 0x1f, 0xff, 0xf1, 0xc0,  //...........@@@@@@@@@@@@@@@@%+..@@@
    0x00, 0x1f, 0xff, 0x81, 0xc0,  //...........@@@@@@@@@@@@@%......@@@
    0x00, 0x1f, 0xf8, 0x01, 0xc0,  //...........@@@@@@@@@@+.........@@@
    0x00, 0x1f, 0xc0, 0x01, 0xc0,  //...........@@@@@@%+............@@@
    0x00, 0x1e, 0x00, 0x01, 0xc0,  //...........@@@%+...............@@@
    0x00, 0x1c, 0x00, 0x01, 0xc0,  //...........@@@.................@@@
    0x00, 0x1c, 0x00, 0x01, 0xc0,  //...........@@@.................@@@
    0x00, 0x1c, 0x00, 0x01, 0xc0,  //...........@@@.................@@@
    0x00, 0x1c, 0x00, 0x01, 0xc0,  //...........@@@.................@@@
    0x00, 0x1c, 0x00, 0x01, 0xc0,  //...........@@@.................@@@
    0x00, 0x1c, 0x00, 0x31, 0xc0,  //...........@@@..........++%%+..@@@
    0x00, 0x1c, 0x03, 0xff, 0xc0,  //...........@@@........%@@@@@@@@@@@
    0x00, 0x1c, 0x07, 0xff, 0xc0,  //...........@@@.......@@@@@@@@@@@@@
    0x00, 0x1c, 0x0f, 0xff, 0xc0,  //...........@@@......@@@@@@@@@@@@@@
    0x00, 0x1c, 0x0f, 0xff, 0xc0,  //...........@@@......@@@@@@@@@@@@@@
    0x00, 0x1c, 0x0f, 0xff, 0xc0,  //...........@@@......@@@@@@@@@@@@@%
    0x0f, 0xdc, 0x07, 0xff, 0x80,  //...+%@@@@%+@@@......+@@@@@@@@@@@@.
    0x3f, 0xfc, 0x03, 0xff, 0x00,  //.+@@@@@@@@@@@@.......+@@@@@@@@@%..
    0x7f, 0xfc, 0x00, 0x78, 0x00,  //+@@@@@@@@@@@@@..........+%%%%+....
    0xff, 0xfc, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@....................
    0xff, 0xfc, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@....................
    0xff, 0xfc, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@%....................
    0x7f, 0xf8, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@%.....................
    0x1f, 0xe0, 0x00, 0x00, 0x00,  //..+%@@@@@@%+......................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......++..........................


    /*Unicode: U+f008 () , Width: 42 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x3f, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0x7f, 0xff, 0xff, 0xff, 0xff, 0x80,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@+...+@@@+..................+@@@+...+@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@....................@@@.....@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@....................@@@.....@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@....................@@@.....@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@....................@@@.....@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@+...+@@@....................@@@+...+@@@
    0xff, 0xe0, 0x00, 0x01, 0xff, 0xc0,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xe0, 0x00, 0x01, 0xff, 0xc0,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xe0, 0x00, 0x01, 0xff, 0xc0,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@....................@@@.....@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@....................@@@.....@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@....................@@@.....@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@....................@@@.....@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@+..................+@@@....+@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@+..................+@@@....+@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@....................@@@.....@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@....................@@@.....@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@....................@@@.....@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xe0, 0x00, 0x01, 0xff, 0xc0,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xe0, 0x00, 0x01, 0xff, 0xc0,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xe0, 0x00, 0x01, 0xff, 0xc0,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@+...+@@@....................@@@+...+@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@....................@@@.....@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@....................@@@.....@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@....................@@@.....@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@.....@@@....................@@@.....@@@
    0xe0, 0xe0, 0x00, 0x01, 0xc1, 0xc0,  //@@@+...+@@@+..................+@@@+...+@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x7f, 0xff, 0xff, 0xff, 0xff, 0x80,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x3f, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..


    /*Unicode: U+f00b () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..++++++++......+++++++++++++++++++++..
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //%@@@@@@@@@%...%@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0xc1, 0xff, 0xff, 0xfc,  //.@@@@@@@@@+...+@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..++++++++......+++++++++++++++++++++..
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //%@@@@@@@@@%...%@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0xc1, 0xff, 0xff, 0xfc,  //.@@@@@@@@@+...+@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..++++++++......+++++++++++++++++++++..
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //%@@@@@@@@@%...%@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe3, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0xc1, 0xff, 0xff, 0xfc,  //.@@@@@@@@@+...+@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................


    /*Unicode: U+f00c () , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x0e, 0x00,  //............................@@%....
    0x00, 0x00, 0x00, 0x1f, 0x00,  //...........................@@@@@...
    0x00, 0x00, 0x00, 0x3f, 0x80,  //..........................@@@@@@@..
    0x00, 0x00, 0x00, 0x7f, 0xc0,  //.........................@@@@@@@@@.
    0x00, 0x00, 0x00, 0xff, 0xc0,  //........................@@@@@@@@@@+
    0x00, 0x00, 0x01, 0xff, 0xc0,  //.......................@@@@@@@@@@@.
    0x00, 0x00, 0x03, 0xff, 0xc0,  //......................@@@@@@@@@@@%.
    0x00, 0x00, 0x07, 0xff, 0x80,  //.....................@@@@@@@@@@@%..
    0x0e, 0x00, 0x0f, 0xff, 0x00,  //....@@@+............@@@@@@@@@@@%...
    0x1f, 0x00, 0x1f, 0xfe, 0x00,  //...@@@@@+..........@@@@@@@@@@@%....
    0x3f, 0x80, 0x3f, 0xfc, 0x00,  //..@@@@@@@+........@@@@@@@@@@@%.....
    0x7f, 0xc0, 0x7f, 0xf8, 0x00,  //.@@@@@@@@@+......@@@@@@@@@@@%......
    0x7f, 0xe0, 0xff, 0xf0, 0x00,  //+@@@@@@@@@@+....@@@@@@@@@@@%.......
    0x7f, 0xf1, 0xff, 0xe0, 0x00,  //.@@@@@@@@@@@+..@@@@@@@@@@@%........
    0x3f, 0xff, 0xff, 0xc0, 0x00,  //.+@@@@@@@@@@@+@@@@@@@@@@@%.........
    0x1f, 0xff, 0xff, 0x80, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@@%..........
    0x0f, 0xff, 0xff, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@@@%...........
    0x07, 0xff, 0xfe, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@@@%............
    0x03, 0xff, 0xfc, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@%.............
    0x01, 0xff, 0xf8, 0x00, 0x00,  //......+@@@@@@@@@@@@@%..............
    0x00, 0xff, 0xf0, 0x00, 0x00,  //.......+@@@@@@@@@@@%...............
    0x00, 0x7f, 0xe0, 0x00, 0x00,  //........+@@@@@@@@@%................
    0x00, 0x3f, 0xc0, 0x00, 0x00,  //.........+@@@@@@@%.................
    0x00, 0x3f, 0x80, 0x00, 0x00,  //..........+@@@@@%..................
    0x00, 0x1f, 0x00, 0x00, 0x00,  //...........%@@@%...................
    0x00, 0x04, 0x00, 0x00, 0x00,  //............+%+....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+f00d () , Width: 26 */
    0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00,  //..........................
    0x0c, 0x00, 0x0c, 0x00,  //....%@+............+@%....
    0x1e, 0x00, 0x1e, 0x00,  //...@@@@+..........+@@@@...
    0x3f, 0x00, 0x3f, 0x00,  //..@@@@@@+........+@@@@@@..
    0x7f, 0x80, 0x7f, 0x80,  //.@@@@@@@@+......+@@@@@@@@.
    0xff, 0xc0, 0xff, 0xc0,  //%@@@@@@@@@+....+@@@@@@@@@@
    0xff, 0xe1, 0xff, 0xc0,  //@@@@@@@@@@@+..+@@@@@@@@@@@
    0x7f, 0xf3, 0xff, 0x80,  //+@@@@@@@@@@@++@@@@@@@@@@@+
    0x3f, 0xff, 0xff, 0x80,  //.+@@@@@@@@@@@@@@@@@@@@@@%.
    0x1f, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@%..
    0x0f, 0xff, 0xfe, 0x00,  //...+@@@@@@@@@@@@@@@@@@%...
    0x07, 0xff, 0xfc, 0x00,  //....+@@@@@@@@@@@@@@@@%....
    0x03, 0xff, 0xf8, 0x00,  //.....+@@@@@@@@@@@@@@%.....
    0x01, 0xff, 0xf0, 0x00,  //......+@@@@@@@@@@@@%......
    0x01, 0xff, 0xe0, 0x00,  //......+@@@@@@@@@@@@+......
    0x03, 0xff, 0xf0, 0x00,  //.....+@@@@@@@@@@@@@@+.....
    0x07, 0xff, 0xf8, 0x00,  //....+@@@@@@@@@@@@@@@@+....
    0x0f, 0xff, 0xfc, 0x00,  //...+@@@@@@@@@@@@@@@@@@+...
    0x1f, 0xff, 0xfe, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@+..
    0x3f, 0xff, 0xff, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@+.
    0x7f, 0xfb, 0xff, 0x80,  //.@@@@@@@@@@@%+@@@@@@@@@@@+
    0xff, 0xf1, 0xff, 0xc0,  //@@@@@@@@@@@%..+@@@@@@@@@@@
    0xff, 0xe0, 0xff, 0xc0,  //%@@@@@@@@@%....+@@@@@@@@@@
    0x7f, 0xc0, 0x7f, 0x80,  //.@@@@@@@@%......+@@@@@@@@+
    0x3f, 0x80, 0x3f, 0x00,  //..@@@@@@%........+@@@@@@+.
    0x1f, 0x00, 0x1e, 0x00,  //...@@@@%..........+@@@@+..
    0x0c, 0x00, 0x0c, 0x00,  //....@@+............+@@+...
    0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00,  //..........................


    /*Unicode: U+f011 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //................++................
    0x00, 0x01, 0xe0, 0x00, 0x00,  //..............+@@@@...............
    0x00, 0x03, 0xe0, 0x00, 0x00,  //..............@@@@@+..............
    0x00, 0x03, 0xf0, 0x00, 0x00,  //..............@@@@@%..............
    0x00, 0x03, 0xf0, 0x00, 0x00,  //..............@@@@@%..............
    0x00, 0x03, 0xf0, 0x00, 0x00,  //..............@@@@@%..............
    0x00, 0x83, 0xf0, 0x40, 0x00,  //.......+%+....@@@@@%....+%........
    0x03, 0xe3, 0xf1, 0xf0, 0x00,  //......@@@@+...@@@@@%...@@@@%......
    0x07, 0xe3, 0xf1, 0xf8, 0x00,  //.....@@@@@@...@@@@@%..+@@@@@%.....
    0x0f, 0xe3, 0xf3, 0xfc, 0x00,  //....@@@@@@@...@@@@@%..+@@@@@@%....
    0x1f, 0xe3, 0xf1, 0xfc, 0x00,  //...@@@@@@@%...@@@@@%...@@@@@@@+...
    0x1f, 0xc3, 0xf0, 0xfe, 0x00,  //..+@@@@@@@....@@@@@%...+@@@@@@@...
    0x3f, 0x83, 0xf0, 0x7f, 0x00,  //..@@@@@@@.....@@@@@%....+@@@@@@%..
    0x7f, 0x03, 0xf0, 0x3f, 0x00,  //.%@@@@@@......@@@@@%.....+@@@@@@..
    0x7e, 0x03, 0xf0, 0x3f, 0x80,  //.@@@@@@+......@@@@@%......%@@@@@%.
    0x7e, 0x03, 0xf0, 0x1f, 0x80,  //+@@@@@%.......@@@@@%.......@@@@@@.
    0xfc, 0x03, 0xf0, 0x1f, 0x80,  //%@@@@@........@@@@@%.......%@@@@@.
    0xfc, 0x03, 0xf0, 0x0f, 0x80,  //%@@@@@........@@@@@%.......+@@@@@+
    0xfc, 0x03, 0xe0, 0x0f, 0x80,  //@@@@@%........%@@@@.........@@@@@+
    0xfc, 0x01, 0xc0, 0x0f, 0xc0,  //@@@@@%.........%@@+.........@@@@@%
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@@@%......................@@@@@%
    0xfc, 0x00, 0x00, 0x0f, 0x80,  //@@@@@%......................@@@@@+
    0xfc, 0x00, 0x00, 0x0f, 0x80,  //@@@@@@......................@@@@@+
    0xfc, 0x00, 0x00, 0x1f, 0x80,  //%@@@@@.....................%@@@@@.
    0x7c, 0x00, 0x00, 0x1f, 0x80,  //+@@@@@+....................@@@@@@.
    0x7e, 0x00, 0x00, 0x1f, 0x80,  //.@@@@@@...................+@@@@@%.
    0x7f, 0x00, 0x00, 0x3f, 0x00,  //.@@@@@@%..................@@@@@@+.
    0x3f, 0x00, 0x00, 0x7f, 0x00,  //.+@@@@@@+................%@@@@@@..
    0x3f, 0x80, 0x00, 0xfe, 0x00,  //..%@@@@@@+..............%@@@@@@+..
    0x1f, 0xe0, 0x01, 0xfe, 0x00,  //...@@@@@@@%............@@@@@@@%...
    0x0f, 0xf0, 0x07, 0xfc, 0x00,  //...+@@@@@@@@+........%@@@@@@@@....
    0x0f, 0xff, 0xff, 0xf8, 0x00,  //....%@@@@@@@@@@%%%%@@@@@@@@@@.....
    0x07, 0xff, 0xff, 0xf0, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@......
    0x01, 0xff, 0xff, 0xe0, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0xff, 0xff, 0x80, 0x00,  //........%@@@@@@@@@@@@@@@@+........
    0x00, 0x3f, 0xff, 0x00, 0x00,  //..........%@@@@@@@@@@@@%..........
    0x00, 0x07, 0xf8, 0x00, 0x00,  //............+%@@@@@@%+............
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f013 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.............+@@@@@%..............
    0x00, 0x07, 0xf0, 0x00, 0x00,  //.............%@@@@@@..............
    0x00, 0x07, 0xf0, 0x00, 0x00,  //.............@@@@@@@..............
    0x03, 0x07, 0xf0, 0x60, 0x00,  //......%@+....@@@@@@@....+@%.......
    0x07, 0xc7, 0xf1, 0xf0, 0x00,  //.....%@@@%..+@@@@@@@+..%@@@%......
    0x0f, 0xff, 0xff, 0xf8, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x1f, 0xff, 0xff, 0xfc, 0x00,  //...%@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x1f, 0xff, 0xff, 0xfc, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x0f, 0xff, 0xff, 0xf8, 0x00,  //...+@@@@@@@@@@@@@@@@@@@@@@@@@+....
    0x0f, 0xff, 0xff, 0xf8, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x07, 0xff, 0xff, 0xf0, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@......
    0x07, 0xfe, 0x3f, 0xf0, 0x00,  //.....@@@@@@@@@%+..%@@@@@@@@@......
    0x07, 0xf8, 0x0f, 0xf0, 0x00,  //.....@@@@@@@@.......@@@@@@@@+.....
    0x7f, 0xf0, 0x07, 0xfe, 0x00,  //+%%@@@@@@@@@.........@@@@@@@@@%+..
    0xff, 0xf0, 0x07, 0xff, 0x80,  //@@@@@@@@@@@%.........%@@@@@@@@@@@.
    0xff, 0xe0, 0x03, 0xff, 0x80,  //@@@@@@@@@@@+..........@@@@@@@@@@@.
    0xff, 0xe0, 0x03, 0xff, 0x80,  //@@@@@@@@@@@...........@@@@@@@@@@@.
    0xff, 0xe0, 0x03, 0xff, 0x80,  //@@@@@@@@@@@...........@@@@@@@@@@@.
    0xff, 0xe0, 0x03, 0xff, 0x80,  //@@@@@@@@@@@+..........@@@@@@@@@@@.
    0xff, 0xf0, 0x07, 0xff, 0x80,  //@@@@@@@@@@@%.........%@@@@@@@@@@@.
    0x3f, 0xf0, 0x07, 0xff, 0x00,  //.+%%@@@@@@@@.........@@@@@@@@@%%+.
    0x07, 0xf8, 0x0f, 0xf0, 0x00,  //.....@@@@@@@@.......@@@@@@@@+.....
    0x07, 0xfe, 0x3f, 0xf0, 0x00,  //.....@@@@@@@@@%+..%@@@@@@@@@......
    0x07, 0xff, 0xff, 0xf0, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@......
    0x07, 0xff, 0xff, 0xf8, 0x00,  //....+@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x0f, 0xff, 0xff, 0xf8, 0x00,  //...+@@@@@@@@@@@@@@@@@@@@@@@@@+....
    0x1f, 0xff, 0xff, 0xfc, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x1f, 0xff, 0xff, 0xfc, 0x00,  //...%@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x0f, 0xff, 0xff, 0xf8, 0x00,  //....%@@@@@@@@@@@@@@@@@%@@@@@@.....
    0x07, 0xc7, 0xf1, 0xf0, 0x00,  //.....%@@@%...@@@@@@@+..%@@@@......
    0x03, 0x07, 0xf0, 0x60, 0x00,  //......%@+....@@@@@@@....+@%.......
    0x00, 0x07, 0xf0, 0x00, 0x00,  //.............@@@@@@@..............
    0x00, 0x07, 0xf0, 0x00, 0x00,  //.............%@@@@@@..............
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.............+@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f014 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x1f, 0xf0, 0x00,  //..........+@@@@@@@@%...........
    0x00, 0x7f, 0xf8, 0x00,  //.........%@@@@@@@@@@@+.........
    0x00, 0x7f, 0xfc, 0x00,  //.........@@@@@@@@@@@@@.........
    0x00, 0xe0, 0x1c, 0x00,  //........%@@+.......@@@.........
    0x00, 0xe0, 0x0e, 0x00,  //........@@@........+@@%........
    0x00, 0xe0, 0x0e, 0x00,  //.......+@@%.........@@@........
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xfc,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x1c, 0x00, 0x00, 0x70,  //...@@%...................@@@...
    0x1c, 0x00, 0x00, 0x70,  //...@@%...................@@@...
    0x1c, 0x00, 0x00, 0x70,  //...@@%...................@@@...
    0x1c, 0x00, 0x00, 0x70,  //...@@%...................@@@...
    0x1c, 0xe3, 0x8c, 0x70,  //...@@%..+@@...@@%..+@@...@@@...
    0x1c, 0xe3, 0x8c, 0x70,  //...@@%..%@@...@@%..+@@+..@@@...
    0x1c, 0xe3, 0x8c, 0x70,  //...@@%..%@@...@@%..+@@+..@@@...
    0x1c, 0xe3, 0x8c, 0x70,  //...@@%..%@@...@@%..+@@+..@@@...
    0x1c, 0xe3, 0x8c, 0x70,  //...@@%..%@@...@@%..+@@+..@@@...
    0x1c, 0xe3, 0x8c, 0x70,  //...@@%..%@@...@@%..+@@+..@@@...
    0x1c, 0xe3, 0x8c, 0x70,  //...@@%..%@@...@@%..+@@+..@@@...
    0x1c, 0xe3, 0x8c, 0x70,  //...@@%..%@@...@@%..+@@+..@@@...
    0x1c, 0xe3, 0x8c, 0x70,  //...@@%..%@@...@@%..+@@+..@@@...
    0x1c, 0xe3, 0x8c, 0x70,  //...@@%..%@@...@@%..+@@+..@@@...
    0x1c, 0xe3, 0x8c, 0x70,  //...@@%..%@@...@@%..+@@+..@@@...
    0x1c, 0xe3, 0x8c, 0x70,  //...@@%..%@@...@@%..+@@+..@@@...
    0x1c, 0xe3, 0x8c, 0x70,  //...@@%..%@@...@@%..+@@+..@@@...
    0x1c, 0x63, 0x8c, 0x70,  //...@@%..+@@...@@%..+@@...@@@...
    0x1c, 0x00, 0x00, 0x70,  //...@@%...................@@@...
    0x1c, 0x00, 0x00, 0x70,  //...@@%...................@@@...
    0x1c, 0x00, 0x00, 0x70,  //...@@%...................@@@...
    0x1c, 0x00, 0x00, 0x70,  //...@@@..................+@@%...
    0x1f, 0xff, 0xff, 0xe0,  //...@@@@@@@@@@@@@@@@@@@@@@@@+...
    0x0f, 0xff, 0xff, 0xe0,  //....@@@@@@@@@@@@@@@@@@@@@@@....
    0x07, 0xff, 0xff, 0xc0,  //.....%@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f015 () , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0xe0, 0x7c, 0x00,  //................%@%.....+@@@@%.....
    0x00, 0x01, 0xf0, 0xfc, 0x00,  //...............@@@@@+...%@@@@@.....
    0x00, 0x03, 0xf8, 0xfc, 0x00,  //.............+@@@@@@@+..%@@@@@.....
    0x00, 0x07, 0xfe, 0xfc, 0x00,  //............+@@@@@@@@@%.%@@@@@.....
    0x00, 0x1f, 0xbf, 0xfc, 0x00,  //...........%@@@@%.%@@@@%%@@@@@.....
    0x00, 0x3f, 0x0f, 0xfc, 0x00,  //..........@@@@@%...+@@@@@@@@@@.....
    0x00, 0x7c, 0x67, 0xfc, 0x00,  //.........@@@@@+.+@%..@@@@@@@@@.....
    0x00, 0xf9, 0xf3, 0xfc, 0x00,  //.......+@@@@@..+@@@%..@@@@@@@@.....
    0x01, 0xf3, 0xf9, 0xfc, 0x00,  //......+@@@@@..%@@@@@@..%@@@@@@.....
    0x07, 0xe7, 0xfc, 0xfc, 0x00,  //.....%@@@@%..@@@@@@@@@..%@@@@@.....
    0x0f, 0xcf, 0xfe, 0x3e, 0x00,  //....@@@@@%..@@@@@@@@@@@+.+@@@@@....
    0x1f, 0x1f, 0xff, 0x9f, 0x00,  //...@@@@@+.+@@@@@@@@@@@@@%.+@@@@@...
    0x3e, 0x3f, 0xff, 0xcf, 0x80,  //.+@@@@@..+@@@@@@@@@@@@@@@%..@@@@@+.
    0x7c, 0xff, 0xff, 0xe7, 0xe0,  //+@@@@@..%@@@@@@@@@@@@@@@@@@..@@@@@+
    0xf9, 0xff, 0xff, 0xf3, 0xe0,  //@@@@%..@@@@@@@@@@@@@@@@@@@@@..%@@@@
    0x73, 0xff, 0xff, 0xf8, 0xc0,  //.@@%..@@@@@@@@@@@@@@@@@@@@@@@+.+@@.
    0x07, 0xff, 0xff, 0xfc, 0x00,  //..+..%@@@@@@@@@@@@@@@@@@@@@@@@..+..
    0x07, 0xff, 0xff, 0xfc, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x07, 0xff, 0xff, 0xfc, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x07, 0xff, 0xff, 0xfc, 0x00,  //.....%@@@@@@@@@%%%%%@@@@@@@@@@.....
    0x07, 0xfe, 0x0f, 0xfc, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x07, 0xfe, 0x0f, 0xfc, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x07, 0xfe, 0x0f, 0xfc, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x07, 0xfe, 0x0f, 0xfc, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x07, 0xfe, 0x0f, 0xfc, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x07, 0xfe, 0x0f, 0xfc, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x07, 0xfe, 0x0f, 0xfc, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x03, 0xfe, 0x0f, 0xfc, 0x00,  //.....+@@@@@@@@@.....%@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+f019 () , Width: 36 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...............++++++...............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@..............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x01, 0xff, 0xff, 0xf8, 0x00,  //.......%@@@@@@@@@@@@@@@@@@@@@.......
    0x01, 0xff, 0xff, 0xf8, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0xff, 0xff, 0xf8, 0x00,  //.......+@@@@@@@@@@@@@@@@@@@@%.......
    0x00, 0x7f, 0xff, 0xf0, 0x00,  //........+@@@@@@@@@@@@@@@@@@%........
    0x00, 0x3f, 0xff, 0xe0, 0x00,  //.........+@@@@@@@@@@@@@@@@%.........
    0x00, 0x1f, 0xff, 0xc0, 0x00,  //..........+@@@@@@@@@@@@@@%..........
    0x00, 0x0f, 0xff, 0x80, 0x00,  //...........+@@@@@@@@@@@@%...........
    0x00, 0x07, 0xff, 0x00, 0x00,  //............+@@@@@@@@@@%............
    0x00, 0x03, 0xfe, 0x00, 0x00,  //.............+@@@@@@@@%.............
    0x00, 0x01, 0xfc, 0x00, 0x00,  //..............+@@@@@@%..............
    0x00, 0x00, 0xf8, 0x00, 0x00,  //...............+@@@@%...............
    0x7f, 0xf8, 0x70, 0xff, 0xe0,  //.@@@@@@@@@@@%...+@@%...+@@@@@@@@@@@.
    0xff, 0xfc, 0x03, 0xff, 0xf0,  //@@@@@@@@@@@@@%........%@@@@@@@@@@@@@
    0xff, 0xfe, 0x07, 0xff, 0xf0,  //@@@@@@@@@@@@@@@......%@@@@@@@@@@@@@@
    0xff, 0xff, 0x0f, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@+..+@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@%@@@@%%@@@
    0xff, 0xff, 0xff, 0x8e, 0x70,  //@@@@@@@@@@@@@@@@@@@@@@@@@...@@@..@@@
    0xff, 0xff, 0xff, 0x8e, 0x70,  //@@@@@@@@@@@@@@@@@@@@@@@@@+.+@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0xff, 0xff, 0xff, 0xe0,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................


    /*Unicode: U+f01c () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x03, 0xff, 0xff, 0xe0, 0x00,  //......%@@@@@@@@@@@@@@@@@@@@.......
    0x03, 0xff, 0xff, 0xf0, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@@......
    0x07, 0xff, 0xff, 0xf0, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@......
    0x07, 0xff, 0xff, 0xf8, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x0f, 0x80, 0x00, 0xf8, 0x00,  //....%@@@@...............%@@@@.....
    0x0f, 0x00, 0x00, 0x7c, 0x00,  //....@@@@+................@@@@%....
    0x1f, 0x00, 0x00, 0x7c, 0x00,  //...%@@@@.................%@@@@....
    0x1f, 0x00, 0x00, 0x3c, 0x00,  //...@@@@%..................@@@@+...
    0x1e, 0x00, 0x00, 0x3e, 0x00,  //..+@@@@...................@@@@@...
    0x3e, 0x00, 0x00, 0x1e, 0x00,  //..@@@@@...................+@@@@...
    0x3c, 0x00, 0x00, 0x1f, 0x00,  //..@@@@+....................@@@@%..
    0x7c, 0x00, 0x00, 0x0f, 0x00,  //.%@@@@.....................+@@@@..
    0x78, 0x00, 0x00, 0x0f, 0x80,  //.@@@@+......................@@@@%.
    0x78, 0x00, 0x00, 0x0f, 0x80,  //+@@@@.......................%@@@@.
    0xf8, 0x00, 0x00, 0x07, 0x80,  //@@@@%........................@@@@.
    0xff, 0xe0, 0x01, 0xff, 0x80,  //@@@@%%%%%%%...........+%%%%%%@@@@+
    0xff, 0xf0, 0x03, 0xff, 0x80,  //@@@@@@@@@@@%..........@@@@@@@@@@@+
    0xff, 0xf0, 0x07, 0xff, 0x80,  //@@@@@@@@@@@@.........%@@@@@@@@@@@+
    0xff, 0xf8, 0x07, 0xff, 0x80,  //@@@@@@@@@@@@%........@@@@@@@@@@@@+
    0xff, 0xf8, 0x0f, 0xff, 0x80,  //@@@@@@@@@@@@@+++++++@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f021 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...............++++...............
    0x00, 0x1f, 0xfc, 0x00, 0x00,  //...........%@@@@@@@@@%+...........
    0x00, 0x7f, 0xff, 0x01, 0x80,  //.........%@@@@@@@@@@@@@@+......@@.
    0x01, 0xff, 0xff, 0xc3, 0xc0,  //.......%@@@@@@@@@@@@@@@@@@....@@@%
    0x03, 0xff, 0xff, 0xe7, 0xc0,  //......@@@@@@@@@@@@@@@@@@@@@+.@@@@%
    0x07, 0xff, 0xff, 0xff, 0xc0,  //.....@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x0f, 0xfc, 0x1f, 0xff, 0xc0,  //....@@@@@@@@@%+...+%@@@@@@@@@@@@@%
    0x1f, 0xf0, 0x03, 0xff, 0xc0,  //...%@@@@@@@%..........%@@@@@@@@@@%
    0x1f, 0xc0, 0x00, 0xff, 0xc0,  //..+@@@@@@@.............+@@@@@@@@@%
    0x3f, 0x80, 0x00, 0xff, 0xc0,  //..@@@@@@@...............@@@@@@@@@%
    0x3f, 0x00, 0x01, 0xff, 0xc0,  //.+@@@@@@...............@@@@@@@@@@%
    0x7e, 0x00, 0x03, 0xff, 0xc0,  //.@@@@@@+..............@@@@@@@@@@@%
    0x7e, 0x00, 0x07, 0xff, 0xc0,  //.@@@@@@..............@@@@@@@@@@@@%
    0xfc, 0x00, 0x07, 0xff, 0x80,  //%@@@@@+..............@@@@@@@@@@@@+
    0x78, 0x00, 0x03, 0xff, 0x00,  //.%%%%+................%%%%%%%%%%+.
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x7f, 0xf0, 0x00, 0x0f, 0x80,  //+@@@@@@@@@@@...............+@@@@%.
    0xff, 0xf0, 0x00, 0x1f, 0x80,  //@@@@@@@@@@@@+..............@@@@@@.
    0xff, 0xf0, 0x00, 0x1f, 0x00,  //@@@@@@@@@@@@..............+@@@@@+.
    0xff, 0xe0, 0x00, 0x3f, 0x00,  //@@@@@@@@@@@...............@@@@@@..
    0xff, 0xc0, 0x00, 0x7f, 0x00,  //@@@@@@@@@@...............%@@@@@%..
    0xff, 0x80, 0x00, 0xfe, 0x00,  //@@@@@@@@@+..............%@@@@@@...
    0xff, 0xe0, 0x01, 0xfe, 0x00,  //@@@@@@@@@@%............@@@@@@@%...
    0xff, 0xf0, 0x07, 0xfc, 0x00,  //@@@@@@@@@@@@+........%@@@@@@@@....
    0xff, 0xff, 0xff, 0xf8, 0x00,  //@@@@@@@@@@@@@@@%%%%@@@@@@@@@@.....
    0xff, 0xff, 0xff, 0xf0, 0x00,  //@@@@@%@@@@@@@@@@@@@@@@@@@@@@......
    0xf3, 0xff, 0xff, 0xe0, 0x00,  //@@@@..+@@@@@@@@@@@@@@@@@@@@.......
    0xe0, 0xff, 0xff, 0x80, 0x00,  //@@@.....@@@@@@@@@@@@@@@@@+........
    0x40, 0x3f, 0xff, 0x00, 0x00,  //.%.......+@@@@@@@@@@@@@%..........
    0x00, 0x07, 0xf8, 0x00, 0x00,  //............+%@@@@@@%+............
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f026 () , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x03, 0x00,  //..............@@+
    0x00, 0x07, 0x80,  //.............@@@%
    0x00, 0x0f, 0x80,  //............@@@@%
    0x00, 0x1f, 0x80,  //...........@@@@@%
    0x00, 0x3f, 0x80,  //..........@@@@@@%
    0x00, 0x7f, 0x80,  //.........@@@@@@@%
    0x00, 0xff, 0x80,  //........@@@@@@@@%
    0x01, 0xff, 0x80,  //.++++++@@@@@@@@@%
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0x7f, 0xff, 0x80,  //+%%%%%%@@@@@@@@@%
    0x00, 0xff, 0x80,  //........@@@@@@@@%
    0x00, 0x7f, 0x80,  //.........@@@@@@@%
    0x00, 0x3f, 0x80,  //..........@@@@@@%
    0x00, 0x1f, 0x80,  //...........@@@@@%
    0x00, 0x0f, 0x80,  //............@@@@%
    0x00, 0x07, 0x80,  //.............@@@%
    0x00, 0x03, 0x80,  //..............@@%
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f027 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x03, 0x00, 0x00,  //..............@@+........
    0x00, 0x07, 0x80, 0x00,  //.............@@@%........
    0x00, 0x0f, 0x80, 0x00,  //............@@@@%........
    0x00, 0x1f, 0x80, 0x00,  //...........@@@@@%........
    0x00, 0x3f, 0x80, 0x00,  //..........@@@@@@%........
    0x00, 0x7f, 0x80, 0x00,  //.........@@@@@@@%........
    0x00, 0xff, 0x80, 0x00,  //........@@@@@@@@%........
    0x01, 0xff, 0x80, 0x00,  //.++++++@@@@@@@@@%........
    0xff, 0xff, 0x8e, 0x00,  //@@@@@@@@@@@@@@@@%...@@%..
    0xff, 0xff, 0x8f, 0x00,  //@@@@@@@@@@@@@@@@%...@@@%.
    0xff, 0xff, 0x87, 0x00,  //@@@@@@@@@@@@@@@@%...+@@@+
    0xff, 0xff, 0x83, 0x80,  //@@@@@@@@@@@@@@@@%....+@@%
    0xff, 0xff, 0x83, 0x80,  //@@@@@@@@@@@@@@@@%.....@@@
    0xff, 0xff, 0x83, 0x80,  //@@@@@@@@@@@@@@@@%.....@@@
    0xff, 0xff, 0x83, 0x80,  //@@@@@@@@@@@@@@@@%....+@@@
    0xff, 0xff, 0x87, 0x00,  //@@@@@@@@@@@@@@@@%...+@@@+
    0xff, 0xff, 0x8f, 0x00,  //@@@@@@@@@@@@@@@@%...@@@%.
    0xff, 0xff, 0x8e, 0x00,  //@@@@@@@@@@@@@@@@%...@@%..
    0x7f, 0xff, 0x80, 0x00,  //+%%%%%%@@@@@@@@@%........
    0x00, 0xff, 0x80, 0x00,  //........@@@@@@@@%........
    0x00, 0x7f, 0x80, 0x00,  //.........@@@@@@@%........
    0x00, 0x3f, 0x80, 0x00,  //..........@@@@@@%........
    0x00, 0x1f, 0x80, 0x00,  //...........@@@@@%........
    0x00, 0x0f, 0x80, 0x00,  //............@@@@%........
    0x00, 0x07, 0x80, 0x00,  //.............@@@%........
    0x00, 0x03, 0x80, 0x00,  //..............@@%........
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f028 () , Width: 36 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0xe0, 0x00,  //........................%@%.........
    0x00, 0x00, 0x00, 0xf0, 0x00,  //........................@@@@+.......
    0x00, 0x01, 0x00, 0x7c, 0x00,  //..............+%........+@@@@%......
    0x00, 0x07, 0x80, 0x3e, 0x00,  //.............%@@%.........%@@@@.....
    0x00, 0x0f, 0x80, 0x0f, 0x00,  //............%@@@%...........@@@@....
    0x00, 0x1f, 0x83, 0x07, 0x80,  //...........+@@@@%.....%@+....@@@%...
    0x00, 0x3f, 0x83, 0xc3, 0x80,  //..........+@@@@@%.....@@@@....@@@+..
    0x00, 0x7f, 0x83, 0xe1, 0xc0,  //.........+@@@@@@%.....%@@@@+..+@@@..
    0x00, 0xff, 0x80, 0xf1, 0xc0,  //........+@@@@@@@%.......@@@@+..%@@+.
    0x01, 0xff, 0x80, 0x78, 0xe0,  //.......+@@@@@@@@%........%@@@...@@@.
    0xff, 0xff, 0x8c, 0x3c, 0xe0,  //%@@@@@@@@@@@@@@@%...%%....@@@%..%@@.
    0xff, 0xff, 0x8e, 0x1c, 0x60,  //@@@@@@@@@@@@@@@@%..+@@@....@@@..+@@+
    0xff, 0xff, 0x8f, 0x1c, 0x70,  //@@@@@@@@@@@@@@@@%...@@@@...%@@+..@@%
    0xff, 0xff, 0x87, 0x8e, 0x70,  //@@@@@@@@@@@@@@@@%....%@@%..+@@%..@@@
    0xff, 0xff, 0x83, 0x8e, 0x70,  //@@@@@@@@@@@@@@@@%.....@@@...@@@..@@@
    0xff, 0xff, 0x83, 0x8e, 0x70,  //@@@@@@@@@@@@@@@@%.....@@@...@@@..@@@
    0xff, 0xff, 0x83, 0x8e, 0x70,  //@@@@@@@@@@@@@@@@%.....@@@...@@@..@@@
    0xff, 0xff, 0x87, 0x8e, 0x70,  //@@@@@@@@@@@@@@@@%....@@@%..+@@%..@@@
    0xff, 0xff, 0x8f, 0x1c, 0x70,  //@@@@@@@@@@@@@@@@%...@@@@...%@@+..@@%
    0xff, 0xff, 0x8e, 0x1c, 0x60,  //@@@@@@@@@@@@@@@@%..+@@@....@@@..+@@+
    0xff, 0xff, 0x8c, 0x3c, 0xe0,  //%@@@@@@@@@@@@@@@%...%%....@@@%..@@@.
    0x00, 0xff, 0x80, 0x78, 0xe0,  //.......+@@@@@@@@%........%@@@...@@@.
    0x00, 0x7f, 0x80, 0xf1, 0xc0,  //........+@@@@@@@%......+@@@@...%@@+.
    0x00, 0x3f, 0x83, 0xe1, 0xc0,  //.........+@@@@@@%.....%@@@@+..+@@@..
    0x00, 0x1f, 0x83, 0xc3, 0x80,  //..........+@@@@@%.....@@@@....@@@+..
    0x00, 0x0f, 0x83, 0x07, 0x80,  //...........+@@@@%.....%@+....@@@%...
    0x00, 0x07, 0x80, 0x0f, 0x00,  //............+@@@%...........@@@@....
    0x00, 0x03, 0x80, 0x3e, 0x00,  //.............+@@%.........%@@@@.....
    0x00, 0x01, 0x00, 0x7c, 0x00,  //..............+%........+@@@@%......
    0x00, 0x00, 0x00, 0xf0, 0x00,  //........................@@@@+.......
    0x00, 0x00, 0x00, 0x60, 0x00,  //........................+@%.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................


    /*Unicode: U+f03e () , Width: 42 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x3f, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0x7f, 0xff, 0xff, 0xff, 0xff, 0x80,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xe0, 0x00, 0x00, 0x00, 0x01, 0xc0,  //@@@....................................@@@
    0xe0, 0x00, 0x00, 0x00, 0x01, 0xc0,  //@@@....................................@@@
    0xe0, 0x00, 0x00, 0x00, 0x01, 0xc0,  //@@@....................................@@@
    0xe0, 0xf0, 0x00, 0x00, 0x01, 0xc0,  //@@@....+@@@%...........................@@@
    0xe1, 0xf8, 0x00, 0x00, 0x01, 0xc0,  //@@@...+@@@@@@..........................@@@
    0xe3, 0xfc, 0x00, 0x00, 0x01, 0xc0,  //@@@...@@@@@@@%.........................@@@
    0xe3, 0xfc, 0x00, 0x00, 0x01, 0xc0,  //@@@..+@@@@@@@@.............+...........@@@
    0xe3, 0xfc, 0x00, 0x30, 0x01, 0xc0,  //@@@..+@@@@@@@@............@@+..........@@@
    0xe3, 0xfc, 0x00, 0x78, 0x01, 0xc0,  //@@@...@@@@@@@%...........@@@@+.........@@@
    0xe3, 0xf8, 0x00, 0xfc, 0x01, 0xc0,  //@@@...%@@@@@@...........@@@@@@+........@@@
    0xe1, 0xf0, 0x01, 0xfe, 0x01, 0xc0,  //@@@....%@@@@+..........@@@@@@@@+.......@@@
    0xe0, 0x00, 0x03, 0xff, 0x01, 0xc0,  //@@@...................@@@@@@@@@@+......@@@
    0xe0, 0x00, 0x07, 0xff, 0x81, 0xc0,  //@@@..................@@@@@@@@@@@@+.....@@@
    0xe0, 0x00, 0x0f, 0xff, 0xc1, 0xc0,  //@@@.................@@@@@@@@@@@@@@+....@@@
    0xe0, 0x08, 0x1f, 0xff, 0xe1, 0xc0,  //@@@.........%......@@@@@@@@@@@@@@@@+...@@@
    0xe0, 0x1c, 0x3f, 0xff, 0xf1, 0xc0,  //@@@........@@@....@@@@@@@@@@@@@@@@@@...@@@
    0xe0, 0x3e, 0x7f, 0xff, 0xf1, 0xc0,  //@@@.......@@@@@..@@@@@@@@@@@@@@@@@@@...@@@
    0xe0, 0x7f, 0xff, 0xff, 0xf1, 0xc0,  //@@@......@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xe0, 0xff, 0xff, 0xff, 0xf1, 0xc0,  //@@@.....@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xe1, 0xff, 0xff, 0xff, 0xf1, 0xc0,  //@@@....@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xe3, 0xff, 0xff, 0xff, 0xf1, 0xc0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xe3, 0xff, 0xff, 0xff, 0xf1, 0xc0,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xe3, 0xff, 0xff, 0xff, 0xf1, 0xc0,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xe3, 0xff, 0xff, 0xff, 0xf1, 0xc0,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xe3, 0xff, 0xff, 0xff, 0xf1, 0xc0,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xe0, 0x00, 0x00, 0x00, 0x01, 0xc0,  //@@@....................................@@@
    0xe0, 0x00, 0x00, 0x00, 0x01, 0xc0,  //@@@....................................@@@
    0xe0, 0x00, 0x00, 0x00, 0x01, 0xc0,  //@@@....................................@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x7f, 0xff, 0xff, 0xff, 0xff, 0x80,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x3f, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................


    /*Unicode: U+f040 () , Width: 33 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x01, 0xe0, 0x00,  //.......................%@@@......
    0x00, 0x00, 0x03, 0xf0, 0x00,  //......................%@@@@@.....
    0x00, 0x00, 0x07, 0xf8, 0x00,  //.....................%@@@@@@@....
    0x00, 0x00, 0x0f, 0xfc, 0x00,  //....................%@@@@@@@@@...
    0x00, 0x00, 0x0f, 0xfe, 0x00,  //....................@@@@@@@@@@@..
    0x00, 0x00, 0x07, 0xff, 0x00,  //.....................@@@@@@@@@@@.
    0x00, 0x00, 0x63, 0xff, 0x80,  //.................%@...@@@@@@@@@@%
    0x00, 0x00, 0xf1, 0xff, 0x80,  //................%@@@...@@@@@@@@@@
    0x00, 0x01, 0xf8, 0xff, 0x80,  //...............%@@@@@...@@@@@@@@@
    0x00, 0x03, 0xfc, 0x7f, 0x00,  //..............%@@@%@@@...@@@@@@@+
    0x00, 0x07, 0x9e, 0x3e, 0x00,  //.............%@@@+.@@@@...@@@@@+.
    0x00, 0x0f, 0x3f, 0x1c, 0x00,  //............%@@@+.@@@@@@...@@@+..
    0x00, 0x1e, 0x7f, 0x88, 0x00,  //...........%@@@+.@@@@@@@@...@+...
    0x00, 0x3c, 0xff, 0xc0, 0x00,  //..........%@@@+.@@@@@@@@@@.......
    0x00, 0x79, 0xff, 0xe0, 0x00,  //.........%@@@+.@@@@@@@@@@@@......
    0x00, 0xf3, 0xff, 0xc0, 0x00,  //........%@@@+.@@@@@@@@@@@@+......
    0x01, 0xe7, 0xff, 0x80, 0x00,  //.......%@@@+.@@@@@@@@@@@@+.......
    0x03, 0xcf, 0xff, 0x00, 0x00,  //......%@@@+.@@@@@@@@@@@@+........
    0x07, 0x9f, 0xfe, 0x00, 0x00,  //.....%@@@+.@@@@@@@@@@@@+.........
    0x0f, 0x3f, 0xfc, 0x00, 0x00,  //....%@@@+.@@@@@@@@@@@@+..........
    0x1e, 0x7f, 0xf8, 0x00, 0x00,  //...%@@@+.@@@@@@@@@@@@+...........
    0x3e, 0xff, 0xf0, 0x00, 0x00,  //..%@@@%.@@@@@@@@@@@@+............
    0x7f, 0xff, 0xe0, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@+.............
    0xf7, 0xff, 0xc0, 0x00, 0x00,  //%@@@+%@@@@@@@@@@@@+..............
    0xe3, 0xff, 0x80, 0x00, 0x00,  //@@@+..%@@@@@@@@@@+...............
    0xe1, 0xff, 0x00, 0x00, 0x00,  //@@@....%@@@@@@@@+................
    0xe0, 0xfe, 0x00, 0x00, 0x00,  //@@@.....%@@@@@@+.................
    0xf8, 0x7c, 0x00, 0x00, 0x00,  //@@@@@+...%@@@@+..................
    0xfc, 0x78, 0x00, 0x00, 0x00,  //@@@@@%...%@@@+...................
    0xfc, 0xf0, 0x00, 0x00, 0x00,  //@@@@@%..%@@@+....................
    0xff, 0xe0, 0x00, 0x00, 0x00,  //@@@@@@@@@@@+.....................
    0xff, 0xc0, 0x00, 0x00, 0x00,  //@@@@@@@@@@+......................
    0xff, 0x80, 0x00, 0x00, 0x00,  //@@@@@@@@@+.......................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................................


    /*Unicode: U+f048 () , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.++++..................
    0xf8, 0x00, 0x04,  //@@@@@+..............+@+
    0xfc, 0x00, 0x0c,  //@@@@@%.............+@@+
    0xfc, 0x00, 0x1c,  //@@@@@%............+@@@+
    0xfc, 0x00, 0x3c,  //@@@@@%...........+@@@@+
    0xfc, 0x00, 0x7c,  //@@@@@%..........+@@@@@+
    0xfc, 0x00, 0xfc,  //@@@@@%.........+@@@@@@+
    0xfc, 0x01, 0xfc,  //@@@@@%........+@@@@@@@+
    0xfc, 0x03, 0xfc,  //@@@@@%.......+@@@@@@@@+
    0xfc, 0x07, 0xfc,  //@@@@@%......+@@@@@@@@@+
    0xfc, 0x0f, 0xfc,  //@@@@@%.....+@@@@@@@@@@+
    0xfc, 0x1f, 0xfc,  //@@@@@%....+@@@@@@@@@@@+
    0xfc, 0x3f, 0xfc,  //@@@@@%...+@@@@@@@@@@@@+
    0xfc, 0x7f, 0xfc,  //@@@@@%..+@@@@@@@@@@@@@+
    0xfc, 0xff, 0xfc,  //@@@@@%.+@@@@@@@@@@@@@@+
    0xfd, 0xff, 0xfc,  //@@@@@%+@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xfc,  //@@@@@%@@@@@@@@@@@@@@@@+
    0xfd, 0xff, 0xfc,  //@@@@@%.@@@@@@@@@@@@@@@+
    0xfc, 0xff, 0xfc,  //@@@@@%..@@@@@@@@@@@@@@+
    0xfc, 0x7f, 0xfc,  //@@@@@%...@@@@@@@@@@@@@+
    0xfc, 0x3f, 0xfc,  //@@@@@%....@@@@@@@@@@@@+
    0xfc, 0x1f, 0xfc,  //@@@@@%.....@@@@@@@@@@@+
    0xfc, 0x0f, 0xfc,  //@@@@@%......@@@@@@@@@@+
    0xfc, 0x07, 0xfc,  //@@@@@%.......@@@@@@@@@+
    0xfc, 0x03, 0xfc,  //@@@@@%........@@@@@@@@+
    0xfc, 0x01, 0xfc,  //@@@@@%.........@@@@@@@+
    0xfc, 0x00, 0xfc,  //@@@@@%..........@@@@@@+
    0xfc, 0x00, 0x7c,  //@@@@@%...........@@@@@+
    0xfc, 0x00, 0x3c,  //@@@@@%............@@@@+
    0xfc, 0x00, 0x1c,  //@@@@@%.............@@@+
    0xfc, 0x00, 0x0c,  //@@@@@%..............@@+
    0xf8, 0x00, 0x04,  //%@@@@................@.
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f04b () , Width: 31 */
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0xc0, 0x00, 0x00, 0x00,  //%+.............................
    0xe0, 0x00, 0x00, 0x00,  //@@@+...........................
    0xf8, 0x00, 0x00, 0x00,  //@@@@@+.........................
    0xfe, 0x00, 0x00, 0x00,  //@@@@@@%........................
    0xff, 0x80, 0x00, 0x00,  //@@@@@@@@%......................
    0xff, 0xe0, 0x00, 0x00,  //@@@@@@@@@@%....................
    0xff, 0xf0, 0x00, 0x00,  //@@@@@@@@@@@@+..................
    0xff, 0xfc, 0x00, 0x00,  //@@@@@@@@@@@@@@+................
    0xff, 0xff, 0x00, 0x00,  //@@@@@@@@@@@@@@@%...............
    0xff, 0xff, 0xc0, 0x00,  //@@@@@@@@@@@@@@@@@%.............
    0xff, 0xff, 0xf0, 0x00,  //@@@@@@@@@@@@@@@@@@@+...........
    0xff, 0xff, 0xf8, 0x00,  //@@@@@@@@@@@@@@@@@@@@@+.........
    0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@+.......
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@%......
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@+.....
    0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@+.......
    0xff, 0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@@@@@@@@%.........
    0xff, 0xff, 0xf0, 0x00,  //@@@@@@@@@@@@@@@@@@@%...........
    0xff, 0xff, 0xc0, 0x00,  //@@@@@@@@@@@@@@@@@@.............
    0xff, 0xff, 0x00, 0x00,  //@@@@@@@@@@@@@@@@+..............
    0xff, 0xfc, 0x00, 0x00,  //@@@@@@@@@@@@@@+................
    0xff, 0xf8, 0x00, 0x00,  //@@@@@@@@@@@@%..................
    0xff, 0xe0, 0x00, 0x00,  //@@@@@@@@@@%....................
    0xff, 0x80, 0x00, 0x00,  //@@@@@@@@@......................
    0xfe, 0x00, 0x00, 0x00,  //@@@@@@@+.......................
    0xf8, 0x00, 0x00, 0x00,  //@@@@@+.........................
    0xf0, 0x00, 0x00, 0x00,  //@@@%...........................
    0xc0, 0x00, 0x00, 0x00,  //@%.............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f04c () , Width: 33 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.++++++++++++.......++++++++++++.
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xfc, 0x1f, 0xff, 0x80,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xf8, 0x1f, 0xff, 0x80,  //%@@@@@@@@@@@@+.....+@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................................


    /*Unicode: U+f04d () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.++++++++++++++++++++++++++++++++.
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f051 () , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //..................++++.
    0xc0, 0x00, 0x7c,  //%@...............@@@@@+
    0xe0, 0x00, 0x7e,  //%@@..............@@@@@%
    0xf0, 0x00, 0x7e,  //%@@@.............@@@@@%
    0xf8, 0x00, 0x7e,  //%@@@@............@@@@@%
    0xfc, 0x00, 0x7e,  //%@@@@@...........@@@@@%
    0xfe, 0x00, 0x7e,  //%@@@@@@..........@@@@@%
    0xff, 0x00, 0x7e,  //%@@@@@@@.........@@@@@%
    0xff, 0x80, 0x7e,  //%@@@@@@@@........@@@@@%
    0xff, 0xc0, 0x7e,  //%@@@@@@@@@.......@@@@@%
    0xff, 0xe0, 0x7e,  //%@@@@@@@@@@......@@@@@%
    0xff, 0xf0, 0x7e,  //%@@@@@@@@@@@.....@@@@@%
    0xff, 0xf8, 0x7e,  //%@@@@@@@@@@@@....@@@@@%
    0xff, 0xfc, 0x7e,  //%@@@@@@@@@@@@@...@@@@@%
    0xff, 0xfe, 0x7e,  //%@@@@@@@@@@@@@@..@@@@@%
    0xff, 0xff, 0x7e,  //%@@@@@@@@@@@@@@@.@@@@@%
    0xff, 0xff, 0xfe,  //%@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xfe,  //%@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0x7e,  //%@@@@@@@@@@@@@@@+@@@@@%
    0xff, 0xfe, 0x7e,  //%@@@@@@@@@@@@@@+.@@@@@%
    0xff, 0xfc, 0x7e,  //%@@@@@@@@@@@@@+..@@@@@%
    0xff, 0xf8, 0x7e,  //%@@@@@@@@@@@@+...@@@@@%
    0xff, 0xf0, 0x7e,  //%@@@@@@@@@@@+....@@@@@%
    0xff, 0xe0, 0x7e,  //%@@@@@@@@@@+.....@@@@@%
    0xff, 0xc0, 0x7e,  //%@@@@@@@@@+......@@@@@%
    0xff, 0x80, 0x7e,  //%@@@@@@@@+.......@@@@@%
    0xff, 0x00, 0x7e,  //%@@@@@@@+........@@@@@%
    0xfe, 0x00, 0x7e,  //%@@@@@@+.........@@@@@%
    0xfc, 0x00, 0x7e,  //%@@@@@+..........@@@@@%
    0xf8, 0x00, 0x7e,  //%@@@@+...........@@@@@%
    0xf0, 0x00, 0x7e,  //%@@@+............@@@@@%
    0xe0, 0x00, 0x7e,  //%@@+.............@@@@@%
    0xc0, 0x00, 0x7e,  //%@+..............@@@@@%
    0x80, 0x00, 0x7c,  //%+...............%@@@@.
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f052 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0xc0, 0x00, 0x00,  //...............+@%................
    0x00, 0x01, 0xe0, 0x00, 0x00,  //..............+@@@@...............
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.............+@@@@@@..............
    0x00, 0x07, 0xf8, 0x00, 0x00,  //............+@@@@@@@@.............
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //...........+@@@@@@@@@@............
    0x00, 0x1f, 0xfe, 0x00, 0x00,  //..........+@@@@@@@@@@@@...........
    0x00, 0x3f, 0xff, 0x00, 0x00,  //.........+@@@@@@@@@@@@@@..........
    0x00, 0x7f, 0xff, 0x80, 0x00,  //........+@@@@@@@@@@@@@@@@.........
    0x00, 0xff, 0xff, 0xc0, 0x00,  //.......+@@@@@@@@@@@@@@@@@@........
    0x01, 0xff, 0xff, 0xe0, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@.......
    0x03, 0xff, 0xff, 0xf0, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@@......
    0x07, 0xff, 0xff, 0xf8, 0x00,  //....+@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x0f, 0xff, 0xff, 0xfc, 0x00,  //...+@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x1f, 0xff, 0xff, 0xfe, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x3f, 0xff, 0xff, 0xff, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0x7f, 0xff, 0xff, 0xff, 0x80,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.+++++++++++++++++++++++++++++++..
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f053 () , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x60,  //.................@@....
    0x00, 0x00, 0xf0,  //................@@@@...
    0x00, 0x01, 0xf8,  //...............@@@@@@..
    0x00, 0x03, 0xfc,  //..............@@@@@@@@.
    0x00, 0x07, 0xfe,  //.............@@@@@@@@@%
    0x00, 0x0f, 0xfe,  //............@@@@@@@@@@%
    0x00, 0x1f, 0xfc,  //...........@@@@@@@@@@@.
    0x00, 0x3f, 0xf8,  //..........@@@@@@@@@@@..
    0x00, 0x7f, 0xf0,  //.........@@@@@@@@@@@...
    0x00, 0xff, 0xe0,  //........@@@@@@@@@@@....
    0x01, 0xff, 0xc0,  //.......@@@@@@@@@@@.....
    0x03, 0xff, 0x80,  //......@@@@@@@@@@@......
    0x07, 0xff, 0x00,  //.....@@@@@@@@@@@.......
    0x0f, 0xfe, 0x00,  //....@@@@@@@@@@@........
    0x1f, 0xfc, 0x00,  //...@@@@@@@@@@@.........
    0x3f, 0xf8, 0x00,  //..@@@@@@@@@@@..........
    0x7f, 0xf0, 0x00,  //.@@@@@@@@@@@...........
    0xff, 0xe0, 0x00,  //%@@@@@@@@@@............
    0x7f, 0xf0, 0x00,  //.@@@@@@@@@@@...........
    0x3f, 0xf8, 0x00,  //.+@@@@@@@@@@@..........
    0x1f, 0xfc, 0x00,  //..+@@@@@@@@@@@.........
    0x0f, 0xfe, 0x00,  //...+@@@@@@@@@@@........
    0x07, 0xff, 0x00,  //....+@@@@@@@@@@@.......
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@......
    0x01, 0xff, 0xc0,  //......+@@@@@@@@@@@.....
    0x00, 0xff, 0xe0,  //.......+@@@@@@@@@@@....
    0x00, 0x7f, 0xf0,  //........+@@@@@@@@@@@...
    0x00, 0x3f, 0xf8,  //.........+@@@@@@@@@@@..
    0x00, 0x1f, 0xfc,  //..........+@@@@@@@@@@@.
    0x00, 0x0f, 0xfe,  //...........+@@@@@@@@@@%
    0x00, 0x07, 0xfe,  //............+@@@@@@@@@@
    0x00, 0x03, 0xfc,  //.............+@@@@@@@@.
    0x00, 0x01, 0xf8,  //..............+@@@@@@..
    0x00, 0x00, 0xf0,  //...............+@@@@...
    0x00, 0x00, 0x60,  //................+@@....
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f054 () , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x0c, 0x00, 0x00,  //....@@.................
    0x1e, 0x00, 0x00,  //...@@@@................
    0x3f, 0x00, 0x00,  //..@@@@@@...............
    0x7f, 0x80, 0x00,  //.@@@@@@@@..............
    0xff, 0xc0, 0x00,  //@@@@@@@@@@.............
    0xff, 0xe0, 0x00,  //@@@@@@@@@@@............
    0x7f, 0xf0, 0x00,  //.@@@@@@@@@@@...........
    0x3f, 0xf8, 0x00,  //..@@@@@@@@@@@..........
    0x1f, 0xfc, 0x00,  //...@@@@@@@@@@@.........
    0x0f, 0xfe, 0x00,  //....@@@@@@@@@@@........
    0x07, 0xff, 0x00,  //.....@@@@@@@@@@@.......
    0x03, 0xff, 0x80,  //......@@@@@@@@@@@......
    0x01, 0xff, 0xc0,  //.......@@@@@@@@@@@.....
    0x00, 0xff, 0xe0,  //........@@@@@@@@@@@....
    0x00, 0x7f, 0xf0,  //.........@@@@@@@@@@@...
    0x00, 0x3f, 0xf8,  //..........@@@@@@@@@@@..
    0x00, 0x1f, 0xfc,  //...........@@@@@@@@@@@.
    0x00, 0x0f, 0xfc,  //...........+@@@@@@@@@@+
    0x00, 0x1f, 0xfc,  //...........@@@@@@@@@@@.
    0x00, 0x3f, 0xf8,  //..........@@@@@@@@@@@..
    0x00, 0x7f, 0xf0,  //.........@@@@@@@@@@@...
    0x00, 0xff, 0xe0,  //........@@@@@@@@@@@....
    0x01, 0xff, 0xc0,  //.......@@@@@@@@@@@.....
    0x03, 0xff, 0x80,  //......@@@@@@@@@@@......
    0x07, 0xff, 0x00,  //.....@@@@@@@@@@@.......
    0x0f, 0xfe, 0x00,  //....@@@@@@@@@@@........
    0x1f, 0xfc, 0x00,  //...@@@@@@@@@@@.........
    0x3f, 0xf8, 0x00,  //..@@@@@@@@@@@..........
    0x7f, 0xf0, 0x00,  //.@@@@@@@@@@@...........
    0xff, 0xe0, 0x00,  //@@@@@@@@@@@............
    0xff, 0xc0, 0x00,  //@@@@@@@@@@.............
    0x7f, 0x80, 0x00,  //.@@@@@@@@..............
    0x3f, 0x00, 0x00,  //..@@@@@@...............
    0x1e, 0x00, 0x00,  //...@@@@................
    0x0c, 0x00, 0x00,  //....@@.................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f067 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x07, 0xc0, 0x00,  //............+%%%%%+............
    0x00, 0x1f, 0xe0, 0x00,  //...........%@@@@@@@............
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xf0, 0x00,  //.++++++++++@@@@@@@@%+++++++++..
    0xff, 0xff, 0xff, 0xfc,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x7f, 0xff, 0xff, 0xfc,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x1f, 0xe0, 0x00,  //...........%@@@@@@@+...........
    0x00, 0x0f, 0xe0, 0x00,  //............@@@@@@%............
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f068 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //..+++++++++++++++++++++++++++..
    0xff, 0xff, 0xff, 0xfc,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x7f, 0xff, 0xff, 0xfc,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f071 () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x38, 0x00, 0x00,  //.................+@@@+.................
    0x00, 0x00, 0x7c, 0x00, 0x00,  //.................@@@@@.................
    0x00, 0x00, 0xfe, 0x00, 0x00,  //................%@@@@@%................
    0x00, 0x00, 0xfe, 0x00, 0x00,  //................@@@@@@@................
    0x00, 0x01, 0xff, 0x00, 0x00,  //...............%@@@@@@@%...............
    0x00, 0x01, 0xff, 0x00, 0x00,  //...............@@@@@@@@@...............
    0x00, 0x03, 0xff, 0x80, 0x00,  //..............@@@@@@@@@@@..............
    0x00, 0x03, 0xff, 0x80, 0x00,  //.............+@@@@@@@@@@@+.............
    0x00, 0x07, 0xff, 0xc0, 0x00,  //.............@@@@@@@@@@@@@.............
    0x00, 0x07, 0xff, 0xc0, 0x00,  //............+@@@@@@@@@@@@@+............
    0x00, 0x0f, 0xff, 0xe0, 0x00,  //............@@@@@@@@@@@@@@@............
    0x00, 0x1f, 0x83, 0xf0, 0x00,  //...........+@@@@%.....%@@@@+...........
    0x00, 0x1f, 0x01, 0xf0, 0x00,  //...........@@@@@+.....+@@@@@...........
    0x00, 0x3f, 0x01, 0xf8, 0x00,  //..........%@@@@@+.....+@@@@@%..........
    0x00, 0x3f, 0x01, 0xf8, 0x00,  //..........@@@@@@+.....+@@@@@@..........
    0x00, 0x7f, 0x83, 0xfc, 0x00,  //.........%@@@@@@+.....%@@@@@@%.........
    0x00, 0x7f, 0x83, 0xfc, 0x00,  //.........@@@@@@@%.....%@@@@@@@.........
    0x00, 0xff, 0x83, 0xfe, 0x00,  //........@@@@@@@@%.....%@@@@@@@@........
    0x00, 0xff, 0x83, 0xfe, 0x00,  //.......+@@@@@@@@%.....%@@@@@@@@+.......
    0x01, 0xff, 0x83, 0xff, 0x00,  //.......@@@@@@@@@%.....%@@@@@@@@@.......
    0x01, 0xff, 0x83, 0xff, 0x00,  //......+@@@@@@@@@%.....%@@@@@@@@@+......
    0x03, 0xff, 0x83, 0xff, 0x80,  //......@@@@@@@@@@@.....@@@@@@@@@@@......
    0x07, 0xff, 0xff, 0xff, 0xc0,  //.....%@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x07, 0xff, 0xff, 0xff, 0xc0,  //.....@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x0f, 0xff, 0xff, 0xff, 0xe0,  //....%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x0f, 0xff, 0x83, 0xff, 0xe0,  //....@@@@@@@@@@@@@.....@@@@@@@@@@@@@....
    0x1f, 0xff, 0x83, 0xff, 0xf0,  //...%@@@@@@@@@@@@%.....%@@@@@@@@@@@@%...
    0x1f, 0xff, 0x83, 0xff, 0xf0,  //...@@@@@@@@@@@@@%.....%@@@@@@@@@@@@@...
    0x3f, 0xff, 0x83, 0xff, 0xf8,  //..@@@@@@@@@@@@@@%.....%@@@@@@@@@@@@@@..
    0x3f, 0xff, 0x83, 0xff, 0xf8,  //.+@@@@@@@@@@@@@@%.....%@@@@@@@@@@@@@@+.
    0x7f, 0xff, 0xff, 0xff, 0xfc,  //.@@@@@@@@@@@@@@@@%%%%%@@@@@@@@@@@@@@@@.
    0x7f, 0xff, 0xff, 0xff, 0xfc,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xfe,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x7f, 0xff, 0xff, 0xff, 0xfc,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................


    /*Unicode: U+f074 () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x01, 0x00,  //...............................@.......
    0x00, 0x00, 0x00, 0x01, 0x80,  //..............................+@@......
    0x00, 0x00, 0x00, 0x01, 0xc0,  //..............................+@@@.....
    0x00, 0x00, 0x00, 0x01, 0xe0,  //..............................+@@@@....
    0x00, 0x00, 0x00, 0x01, 0xf0,  //..............................+@@@@@...
    0xff, 0x80, 0x03, 0xff, 0xf8,  //@@@@@@@@%+...........+@@@@@@@@@@@@@@@..
    0xff, 0xe0, 0x1f, 0xff, 0xfc,  //@@@@@@@@@@@+.......%@@@@@@@@@@@@@@@@@@.
    0xff, 0xf0, 0x3f, 0xff, 0xfe,  //@@@@@@@@@@@@+.....%@@@@@@@@@@@@@@@@@@@@
    0xff, 0xf8, 0x7f, 0xff, 0xfc,  //@@@@@@@@@@@@@+...%@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xfc, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@..%@@@@@@@@@@@@@@@@@@@@+.
    0x03, 0xfc, 0xff, 0x83, 0xf0,  //++++++%@@@@@@@.+@@@@@@@%++++++%@@@@@+..
    0x00, 0x7d, 0xfc, 0x01, 0xe0,  //........+@@@@+.@@@@@@@........+@@@@+...
    0x00, 0x39, 0xf8, 0x01, 0xc0,  //.........+@@@.+@@@@@@.........+@@@+....
    0x00, 0x3b, 0xf0, 0x01, 0x80,  //..........%@%.@@@@@@+.........+@@+.....
    0x00, 0x13, 0xf0, 0x01, 0x00,  //...........@.+@@@@@@..........+@+......
    0x00, 0x07, 0xe0, 0x00, 0x00,  //...........+.@@@@@@+...................
    0x00, 0x07, 0xe0, 0x00, 0x00,  //.............@@@@@@....................
    0x00, 0x0f, 0xc0, 0x00, 0x00,  //............%@@@@@+....................
    0x00, 0x0f, 0xc0, 0x00, 0x00,  //............@@@@@@.....................
    0x00, 0x1f, 0x80, 0x00, 0x00,  //...........%@@@@@+.....................
    0x00, 0x1f, 0x90, 0x01, 0x00,  //...........@@@@@@.+%..........+@+......
    0x00, 0x3f, 0xb0, 0x01, 0x80,  //..........%@@@@@%.@@+.........+@@+.....
    0x00, 0x3f, 0x38, 0x01, 0xc0,  //.........+@@@@@@.+@@@.........+@@@+....
    0x00, 0x7f, 0x7c, 0x01, 0xe0,  //........+@@@@@@%.@@@@@........+@@@@+...
    0x01, 0xfe, 0x7f, 0x03, 0xf0,  //.++++++%@@@@@@@.+@@@@@@%++++++%@@@@@+..
    0xff, 0xfc, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@+.%@@@@@@@@@@@@@@@@@@@@+.
    0xff, 0xf8, 0x7f, 0xff, 0xfc,  //@@@@@@@@@@@@@+...@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xf8, 0x3f, 0xff, 0xfe,  //@@@@@@@@@@@@%.....@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe0, 0x1f, 0xff, 0xfc,  //@@@@@@@@@@@+.......%@@@@@@@@@@@@@@@@@@.
    0xff, 0x80, 0x07, 0xff, 0xf8,  //@@@@@@@@@+...........%@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x01, 0xf0,  //..............................+@@@@@...
    0x00, 0x00, 0x00, 0x01, 0xe0,  //..............................+@@@@+...
    0x00, 0x00, 0x00, 0x01, 0xc0,  //..............................+@@@+....
    0x00, 0x00, 0x00, 0x01, 0x80,  //..............................+@@+.....
    0x00, 0x00, 0x00, 0x01, 0x00,  //..............................+@+......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................


    /*Unicode: U+f077 () , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0xe0, 0x00, 0x00,  //................+@+................
    0x00, 0x01, 0xf0, 0x00, 0x00,  //...............%@@@%...............
    0x00, 0x03, 0xf8, 0x00, 0x00,  //..............%@@@@@%..............
    0x00, 0x07, 0xfc, 0x00, 0x00,  //.............%@@@@@@@%.............
    0x00, 0x0f, 0xfe, 0x00, 0x00,  //............%@@@@@@@@@%............
    0x00, 0x1f, 0xff, 0x00, 0x00,  //...........%@@@@@@@@@@@%...........
    0x00, 0x3f, 0xff, 0x80, 0x00,  //..........%@@@@@@@@@@@@@%..........
    0x00, 0x7f, 0xff, 0xc0, 0x00,  //.........%@@@@@@@@@@@@@@@%.........
    0x00, 0xff, 0xff, 0xe0, 0x00,  //........%@@@@@@@@@@@@@@@@@%........
    0x01, 0xff, 0xff, 0xf0, 0x00,  //.......%@@@@@@@@@@@@@@@@@@@%.......
    0x03, 0xff, 0xff, 0xf8, 0x00,  //......%@@@@@@@@@@@@@@@@@@@@@%......
    0x07, 0xff, 0xbf, 0xfc, 0x00,  //.....%@@@@@@@@@@%.%@@@@@@@@@@%.....
    0x0f, 0xff, 0x1f, 0xfe, 0x00,  //....%@@@@@@@@@@%...%@@@@@@@@@@%....
    0x1f, 0xfe, 0x0f, 0xff, 0x00,  //...%@@@@@@@@@@%.....%@@@@@@@@@@%...
    0x3f, 0xfc, 0x07, 0xff, 0x80,  //..%@@@@@@@@@@%.......%@@@@@@@@@@%..
    0x7f, 0xf8, 0x03, 0xff, 0xc0,  //.%@@@@@@@@@@%.........%@@@@@@@@@@%.
    0xff, 0xf0, 0x01, 0xff, 0xe0,  //%@@@@@@@@@@%...........%@@@@@@@@@@%
    0xff, 0xe0, 0x00, 0xff, 0xe0,  //@@@@@@@@@@%.............%@@@@@@@@@@
    0xff, 0xc0, 0x00, 0x7f, 0xe0,  //%@@@@@@@@%...............%@@@@@@@@%
    0x7f, 0x80, 0x00, 0x3f, 0xc0,  //.%@@@@@@%.................%@@@@@@%.
    0x3f, 0x00, 0x00, 0x1f, 0x80,  //..%@@@@%...................%@@@@%..
    0x1e, 0x00, 0x00, 0x0f, 0x00,  //...%@@%.....................%@@%...
    0x00, 0x00, 0x00, 0x00, 0x00,  //....++.......................++....
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+f078 () , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x0c, 0x00, 0x00, 0x06, 0x00,  //....%%.......................%%....
    0x1e, 0x00, 0x00, 0x0f, 0x00,  //...@@@@.....................@@@@...
    0x3f, 0x00, 0x00, 0x1f, 0x80,  //..@@@@@@...................@@@@@@..
    0x7f, 0x80, 0x00, 0x3f, 0xc0,  //.@@@@@@@@.................@@@@@@@@.
    0xff, 0xc0, 0x00, 0x7f, 0xe0,  //@@@@@@@@@@...............@@@@@@@@@@
    0xff, 0xe0, 0x00, 0xff, 0xe0,  //@@@@@@@@@@@.............@@@@@@@@@@@
    0x7f, 0xf0, 0x01, 0xff, 0xc0,  //+@@@@@@@@@@@...........@@@@@@@@@@@+
    0x3f, 0xf8, 0x03, 0xff, 0x80,  //.+@@@@@@@@@@@.........@@@@@@@@@@@+.
    0x1f, 0xfc, 0x07, 0xff, 0x00,  //..+@@@@@@@@@@@.......@@@@@@@@@@@+..
    0x0f, 0xfe, 0x0f, 0xfe, 0x00,  //...+@@@@@@@@@@@.....@@@@@@@@@@@+...
    0x07, 0xff, 0x1f, 0xfc, 0x00,  //....+@@@@@@@@@@@...@@@@@@@@@@@+....
    0x03, 0xff, 0xbf, 0xf8, 0x00,  //.....+@@@@@@@@@@@.@@@@@@@@@@@+.....
    0x01, 0xff, 0xff, 0xf0, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@@+......
    0x00, 0xff, 0xff, 0xe0, 0x00,  //.......+@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x7f, 0xff, 0xc0, 0x00,  //........+@@@@@@@@@@@@@@@@@+........
    0x00, 0x3f, 0xff, 0x80, 0x00,  //.........+@@@@@@@@@@@@@@@+.........
    0x00, 0x1f, 0xff, 0x00, 0x00,  //..........+@@@@@@@@@@@@@+..........
    0x00, 0x0f, 0xfe, 0x00, 0x00,  //...........+@@@@@@@@@@@+...........
    0x00, 0x07, 0xfc, 0x00, 0x00,  //............+@@@@@@@@@+............
    0x00, 0x03, 0xf8, 0x00, 0x00,  //.............+@@@@@@@+.............
    0x00, 0x01, 0xf0, 0x00, 0x00,  //..............+@@@@@+..............
    0x00, 0x00, 0xe0, 0x00, 0x00,  //...............+@@@+...............
    0x00, 0x00, 0x40, 0x00, 0x00,  //.................%.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+f079 () , Width: 42 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x01, 0x83, 0xff, 0xff, 0xf0, 0x00,  //.......%@+....@@@@@@@@@@@@@@@@@@@@@@......
    0x03, 0xc3, 0xff, 0xff, 0xf0, 0x00,  //......%@@@+...%@@@@@@@@@@@@@@@@@@@@@......
    0x03, 0xe1, 0xff, 0xff, 0xf0, 0x00,  //.....+@@@@@....%@@@@@@@@@@@@@@@@@@@@......
    0x07, 0xf0, 0xff, 0xff, 0xf0, 0x00,  //.....@@@@@@@....@@@@@@@@@@@@@@@@@@@@......
    0x0f, 0xf8, 0x7f, 0xff, 0xf0, 0x00,  //....@@@@@@@@%....@@@@@@@@@@@@@@@@@@@......
    0x1f, 0xfc, 0x3f, 0xff, 0xf0, 0x00,  //...@@@@@@@@@@%....%%%%%%%%%%%%%@@@@@......
    0x3f, 0xfc, 0x00, 0x01, 0xf0, 0x00,  //..%@@@@@@@@@@@+...............+@@@@@......
    0x7f, 0xfe, 0x00, 0x01, 0xf0, 0x00,  //.%@@@@@@@@@@@@@+..............+@@@@@......
    0x7f, 0xff, 0x00, 0x01, 0xf0, 0x00,  //+@@@@@@@@@@@@@@@..............+@@@@@......
    0xff, 0xff, 0x80, 0x01, 0xf0, 0x00,  //@@@@@@@@@@@@@@@@%.............+@@@@@......
    0xff, 0xff, 0x00, 0x01, 0xf0, 0x00,  //%@@@@@@@@@@@@@@@+.............+@@@@@......
    0x03, 0xe0, 0x00, 0x01, 0xf0, 0x00,  //.....+@@@@@...................+@@@@@......
    0x03, 0xe0, 0x00, 0x01, 0xf0, 0x00,  //.....+@@@@@...................+@@@@@......
    0x03, 0xe0, 0x00, 0x03, 0xf0, 0x00,  //.....+@@@@@...................%@@@@@......
    0x03, 0xe0, 0x00, 0x7f, 0xff, 0x80,  //.....+@@@@@..............%@@@@@@@@@@@@@@@+
    0x03, 0xe0, 0x00, 0x7f, 0xff, 0xc0,  //.....+@@@@@..............@@@@@@@@@@@@@@@@%
    0x03, 0xe0, 0x00, 0x3f, 0xff, 0x80,  //.....+@@@@@..............+@@@@@@@@@@@@@@@.
    0x03, 0xe0, 0x00, 0x3f, 0xff, 0x00,  //.....+@@@@@...............%@@@@@@@@@@@@@+.
    0x03, 0xe0, 0x00, 0x1f, 0xfe, 0x00,  //.....+@@@@@................%@@@@@@@@@@@+..
    0x03, 0xff, 0xff, 0x0f, 0xfe, 0x00,  //.....+@@@@@%%%%%%%%%%%%%....@@@@@@@@@@%...
    0x03, 0xff, 0xff, 0x87, 0xfc, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@....@@@@@@@@%....
    0x03, 0xff, 0xff, 0xc3, 0xf8, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@%....@@@@@@@.....
    0x03, 0xff, 0xff, 0xe1, 0xf0, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@+...+@@@@@......
    0x03, 0xff, 0xff, 0xe1, 0xe0, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@+...%@@@+......
    0x03, 0xff, 0xff, 0xf0, 0xc0, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@%....%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................


    /*Unicode: U+f07b () , Width: 37 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x0f, 0xf8, 0x00, 0x00, 0x00,  //...+%%%%%%%%%+.......................
    0x3f, 0xfe, 0x00, 0x00, 0x00,  //.+@@@@@@@@@@@@@......................
    0x7f, 0xff, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@@@@.....................
    0xff, 0xff, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@@@@+....................
    0xff, 0xff, 0x80, 0x00, 0x00,  //@@@@@@@@@@@@@@@@%....................
    0xff, 0xff, 0x80, 0x00, 0x00,  //@@@@@@@@@@@@@@@@%....................
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x7f, 0xff, 0xff, 0xff, 0xf0,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x7f, 0xff, 0xff, 0xff, 0xe0,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0x1f, 0xff, 0xff, 0xff, 0x80,  //..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................


    /*Unicode: U+f093 () , Width: 36 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x60, 0x00, 0x00,  //.................@@+................
    0x00, 0x00, 0xf0, 0x00, 0x00,  //................@@@@+...............
    0x00, 0x01, 0xf8, 0x00, 0x00,  //...............@@@@@@+..............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x07, 0xfe, 0x00, 0x00,  //.............@@@@@@@@@@+............
    0x00, 0x0f, 0xff, 0x00, 0x00,  //............@@@@@@@@@@@@+...........
    0x00, 0x1f, 0xff, 0x80, 0x00,  //...........@@@@@@@@@@@@@@+..........
    0x00, 0x3f, 0xff, 0xc0, 0x00,  //..........@@@@@@@@@@@@@@@@+.........
    0x00, 0x7f, 0xff, 0xe0, 0x00,  //.........@@@@@@@@@@@@@@@@@@+........
    0x00, 0xff, 0xff, 0xf0, 0x00,  //........@@@@@@@@@@@@@@@@@@@@+.......
    0x01, 0xff, 0xff, 0xf8, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@.......
    0x01, 0xff, 0xff, 0xf8, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x03, 0xfc, 0x00, 0x00,  //........++++++@@@@@@@@++++++........
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x03, 0xfc, 0x00, 0x00,  //..............@@@@@@@@..............
    0x3f, 0xe0, 0x00, 0x7f, 0xc0,  //.+%%%%%%%%%+...++++++....%%%%%%%%%+.
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //%@@@@@@@@@@@............%@@@@@@@@@@%
    0xff, 0xf8, 0x01, 0xff, 0xf0,  //@@@@@@@@@@@@@..........%@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@%%%%%%%%@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xce, 0x70,  //@@@@@@@@@@@@@@@@@@@@@@@@@%.+@@@..@@@
    0xff, 0xff, 0xff, 0x8e, 0x70,  //@@@@@@@@@@@@@@@@@@@@@@@@@...@@@..@@@
    0xff, 0xff, 0xff, 0xce, 0x70,  //@@@@@@@@@@@@@@@@@@@@@@@@@%.+@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0xff, 0xff, 0xff, 0xe0,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................................


    /*Unicode: U+f095 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x06, 0x00, 0x00, 0x00,  //....+%%........................
    0x1f, 0x00, 0x00, 0x00,  //..+@@@@%.......................
    0x3f, 0x00, 0x00, 0x00,  //..@@@@@@+......................
    0x7f, 0x80, 0x00, 0x00,  //.@@@@@@@@......................
    0x7f, 0x80, 0x00, 0x00,  //+@@@@@@@@+.....................
    0xff, 0xc0, 0x00, 0x00,  //%@@@@@@@@@.....................
    0xff, 0xe0, 0x00, 0x00,  //@@@@@@@@@@%....................
    0xff, 0xe0, 0x00, 0x00,  //@@@@@@@@@@@....................
    0xff, 0xe0, 0x00, 0x00,  //@@@@@@@@@@%....................
    0xff, 0xc0, 0x00, 0x00,  //@@@@@@@@@%.....................
    0xff, 0x80, 0x00, 0x00,  //%@@@@@@@%......................
    0x7f, 0x00, 0x00, 0x00,  //.@@@@@@%.......................
    0x7e, 0x00, 0x00, 0x00,  //.@@@@@@+.......................
    0x3f, 0x00, 0x00, 0x00,  //.+@@@@@%.......................
    0x3f, 0x00, 0x00, 0x00,  //..@@@@@@+......................
    0x3f, 0x80, 0x00, 0x00,  //..%@@@@@@......................
    0x1f, 0xc0, 0x00, 0x00,  //...@@@@@@%.....................
    0x1f, 0xc0, 0x00, 0x00,  //...%@@@@@@+....................
    0x0f, 0xe0, 0x00, 0x00,  //....@@@@@@@+...................
    0x07, 0xf0, 0x00, 0x00,  //.....@@@@@@@+..................
    0x03, 0xf8, 0x03, 0x80,  //.....+@@@@@@@+........%@%......
    0x01, 0xfe, 0x07, 0xc0,  //......+@@@@@@@%......%@@@@+....
    0x00, 0xff, 0x0f, 0xf0,  //.......+@@@@@@@@+...%@@@@@@@+..
    0x00, 0x7f, 0xdf, 0xfc,  //........+@@@@@@@@%+%@@@@@@@@@%.
    0x00, 0x3f, 0xff, 0xfe,  //.........+@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x1f, 0xff, 0xfe,  //..........+@@@@@@@@@@@@@@@@@@@%
    0x00, 0x0f, 0xff, 0xfc,  //............@@@@@@@@@@@@@@@@@@+
    0x00, 0x07, 0xff, 0xfc,  //.............%@@@@@@@@@@@@@@@@.
    0x00, 0x01, 0xff, 0xf8,  //...............%@@@@@@@@@@@@@+.
    0x00, 0x00, 0x3f, 0xf0,  //.................+@@@@@@@@@@...
    0x00, 0x00, 0x0f, 0xc0,  //....................%@@@@%+....
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f0c4 () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x0f, 0xc0, 0x00, 0x00, 0x00,  //...+%@@@@%.............................
    0x3f, 0xf0, 0x00, 0x00, 0x00,  //..@@@@@@@@@%...........................
    0x7f, 0xf8, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@+.........................
    0x7f, 0xfe, 0x00, 0x00, 0x70,  //+@@@@%%%@@@@@@%..................@@@+..
    0xf0, 0x3e, 0x00, 0x01, 0xdc,  //@@@@......%@@@@+...............%@@+%@@.
    0xf0, 0x0f, 0x00, 0x07, 0x06,  //@@@+.......+@@@@.............%@@+....@%
    0xf0, 0x07, 0x00, 0x0e, 0x0c,  //@@@%........+@@@+..........+@@%.....%@+
    0xf0, 0x07, 0x80, 0x38, 0x18,  //%@@@.........@@@%.........@@%......@@..
    0x78, 0x07, 0x80, 0xe0, 0x30,  //+@@@@........@@@%.......%@@+.....+@@...
    0x7c, 0x07, 0x83, 0x80, 0xe0,  //.%@@@@+......@@@%.....%@@+......%@%....
    0x3f, 0x9f, 0x87, 0x01, 0x80,  //..@@@@@@%++%@@@@@+..+@@%.......@@+.....
    0x1f, 0xff, 0xfc, 0x03, 0x00,  //...%@@@@@@@@@@@@%@%@@%........@@.......
    0x07, 0xfe, 0x70, 0x06, 0x00,  //....+@@@@@@@@@@..%@@+.......+@@........
    0x01, 0xff, 0x60, 0x1c, 0x00,  //......+%@@@@%%@@+@+........%@%.........
    0x00, 0x01, 0xc8, 0x30, 0x00,  //...............@@@.+@+....@@+..........
    0x00, 0x00, 0xdc, 0x60, 0x00,  //................@@.@@@..+@@+...........
    0x00, 0x01, 0xc9, 0xf0, 0x00,  //..............+@@%.+@+.+@%%@+..........
    0x01, 0xff, 0x03, 0x9c, 0x00,  //......+@@@@@@%@%...+..%@%..%@%.........
    0x0f, 0xfe, 0x3e, 0x06, 0x00,  //....+@@@@@@@@@@..+@@@@@+....+@@........
    0x1f, 0xff, 0xfc, 0x03, 0x00,  //...@@@@@@@@@@@@@%@%@@@+.......@@+......
    0x3f, 0x9f, 0x87, 0x01, 0x80,  //..@@@@@@%++%@@@@@+..+@@%.......%@+.....
    0x7c, 0x07, 0x81, 0x80, 0xe0,  //.%@@@@+......@@@%.....+@@+......%@%....
    0x78, 0x07, 0x80, 0xe0, 0x30,  //+@@@@........@@@%.......%@@......+@@...
    0xf0, 0x07, 0x80, 0x38, 0x18,  //%@@@.........@@@%.........@@%......@@+.
    0xf0, 0x07, 0x00, 0x0e, 0x0c,  //@@@%........+@@@+..........+@@%.....%@+
    0xf0, 0x0f, 0x00, 0x07, 0x06,  //@@@%.......+@@@@.............%@@+....@%
    0xf0, 0x3e, 0x00, 0x01, 0xdc,  //@@@@......%@@@@+...............%@@+%@@.
    0xff, 0xfe, 0x00, 0x00, 0x70,  //%@@@@%%%@@@@@@%.................+@@@+..
    0x7f, 0xf8, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@+.........................
    0x3f, 0xf0, 0x00, 0x00, 0x00,  //..@@@@@@@@@%...........................
    0x0f, 0xc0, 0x00, 0x00, 0x00,  //...+%@@@@%.............................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................


    /*Unicode: U+f0c5 () , Width: 39 */
    0x00, 0x0f, 0xff, 0x00, 0x00,  //............%@@@@@@@@@@%...............
    0x00, 0x1f, 0xff, 0x80, 0x00,  //..........+@@@@@@@@@@@@@@..............
    0x00, 0x7f, 0xff, 0x80, 0x00,  //.........%@@@@@@@@@@@@@@@..............
    0x00, 0xfc, 0x03, 0x80, 0x00,  //........%@@@@@........@@@..............
    0x00, 0xfc, 0x03, 0x80, 0x00,  //.......+@@@@@@........@@@..............
    0x01, 0xfc, 0x03, 0x80, 0x00,  //......+@@@%@@@........@@@..............
    0x03, 0xdc, 0x03, 0x80, 0x00,  //.....+@@@%.@@@........@@@..............
    0x07, 0x9c, 0x03, 0x80, 0x00,  //....+@@@@..@@@........@@@..............
    0x0f, 0x1c, 0x03, 0x80, 0x00,  //...+@@@@...@@@........@@@..............
    0x1e, 0x1c, 0x03, 0xbf, 0xfc,  //..+@@@@....@@@........@@@+%@@@@@@@@@@@.
    0x3c, 0x1c, 0x03, 0xff, 0xfe,  //.+@@@@.....@@@........@@@@@@@@@@@@@@@@@
    0x78, 0x1c, 0x03, 0xff, 0xfe,  //.@@@@......@@@........@@@@@@@@@@@@@@@@@
    0xff, 0xfc, 0x03, 0xf0, 0x0e,  //%@@@@@@@@@@@@@........@@@@@@........@@@
    0xff, 0xfc, 0x07, 0xf0, 0x0e,  //@@@@@@@@@@@@@@.......%@@@@@@........@@@
    0xff, 0xf8, 0x0f, 0x70, 0x0e,  //@@@@@@@@@@@@%.......%@@@+@@@........@@@
    0xe0, 0x00, 0x1e, 0x70, 0x0e,  //@@@................%@@@+.@@@........@@@
    0xe0, 0x00, 0x3c, 0x70, 0x0e,  //@@@...............%@@@+..@@@........@@@
    0xe0, 0x00, 0x78, 0x70, 0x0e,  //@@@..............%@@@....@@@........@@@
    0xe0, 0x00, 0xf0, 0x70, 0x0e,  //@@@.............%@@@.....@@@........@@@
    0xe0, 0x01, 0xe0, 0x70, 0x0e,  //@@@............%@@@......@@@........@@@
    0xe0, 0x01, 0xff, 0xf0, 0x0e,  //@@@...........+@@@@@@@@@@@@@........@@@
    0xe0, 0x03, 0xff, 0xf0, 0x0e,  //@@@...........@@@@@@@@@@@@@%........@@@
    0xe0, 0x03, 0xff, 0xe0, 0x0e,  //@@@...........@@@@@@@@@@@@%.........@@@
    0xe0, 0x03, 0x80, 0x00, 0x0e,  //@@@...........@@%...................@@@
    0xe0, 0x03, 0x80, 0x00, 0x0e,  //@@@...........@@%...................@@@
    0xe0, 0x03, 0x80, 0x00, 0x0e,  //@@@...........@@%...................@@@
    0xe0, 0x03, 0x80, 0x00, 0x0e,  //@@@...........@@%...................@@@
    0xe0, 0x03, 0x80, 0x00, 0x0e,  //@@@...........@@%...................@@@
    0xff, 0xff, 0x80, 0x00, 0x0e,  //@@@@@@@@@@@@@@@@%...................@@@
    0xff, 0xff, 0x80, 0x00, 0x0e,  //@@@@@@@@@@@@@@@@%...................@@@
    0x7f, 0xff, 0x80, 0x00, 0x0e,  //.@@@@@@@@@@@@@@@%...................@@@
    0x00, 0x03, 0x80, 0x00, 0x0e,  //..............@@%...................@@@
    0x00, 0x03, 0x80, 0x00, 0x0e,  //..............@@%...................@@@
    0x00, 0x03, 0x80, 0x00, 0x0e,  //..............@@%...................@@@
    0x00, 0x03, 0x80, 0x00, 0x0e,  //..............@@%...................@@@
    0x00, 0x03, 0x80, 0x00, 0x0e,  //..............@@%...................@@@
    0x00, 0x03, 0x80, 0x00, 0x0e,  //..............@@%...................@@@
    0x00, 0x03, 0xff, 0xff, 0xfe,  //..............@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x03, 0xff, 0xff, 0xfe,  //..............@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x01, 0xff, 0xff, 0xfc,  //...............%@@@@@@@@@@@@@@@@@@@@@%.


    /*Unicode: U+f0c7 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x7f, 0xff, 0xff, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@%+.........
    0xff, 0xff, 0xff, 0xc0, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@........
    0xff, 0xff, 0xff, 0xe0, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@.......
    0xe3, 0xfc, 0x1d, 0xf0, 0x00,  //@@@..+@@@@@@@@.....@@@.%@@@@......
    0xe3, 0xfc, 0x1c, 0x78, 0x00,  //@@@..+@@@@@@@@.....@@@..+@@@@.....
    0xe3, 0xfc, 0x1c, 0x3c, 0x00,  //@@@..+@@@@@@@@.....@@@...+@@@@....
    0xe3, 0xfc, 0x1c, 0x1e, 0x00,  //@@@..+@@@@@@@@.....@@@....+@@@@...
    0xe3, 0xfc, 0x1c, 0x0f, 0x00,  //@@@..+@@@@@@@@.....@@@......@@@@..
    0xe3, 0xfc, 0x1c, 0x07, 0x80,  //@@@..+@@@@@@@@.....@@@.......@@@@.
    0xe3, 0xfc, 0x1c, 0x03, 0x80,  //@@@..+@@@@@@@@.....@@@........@@@+
    0xe3, 0xfc, 0x1c, 0x01, 0xc0,  //@@@..+@@@@@@@@.....@@@........+@@%
    0xe3, 0xff, 0xfc, 0x01, 0xc0,  //@@@..+@@@@@@@@@@@@@@@@.........@@@
    0xe3, 0xff, 0xfc, 0x01, 0xc0,  //@@@...@@@@@@@@@@@@@@@@.........@@@
    0xe3, 0xff, 0xf8, 0x01, 0xc0,  //@@@...%@@@@@@@@@@@@@@+.........@@@
    0xe0, 0x00, 0x00, 0x01, 0xc0,  //@@@............................@@@
    0xe0, 0x00, 0x00, 0x01, 0xc0,  //@@@............................@@@
    0xe0, 0x00, 0x00, 0x01, 0xc0,  //@@@............................@@@
    0xe0, 0x00, 0x00, 0x01, 0xc0,  //@@@............................@@@
    0xe0, 0x00, 0x00, 0x01, 0xc0,  //@@@............................@@@
    0xe0, 0x00, 0x00, 0x01, 0xc0,  //@@@............................@@@
    0xe3, 0xff, 0xff, 0xe1, 0xc0,  //@@@...%@@@@@@@@@@@@@@@@@@@@....@@@
    0xe3, 0xff, 0xff, 0xf1, 0xc0,  //@@@...@@@@@@@@@@@@@@@@@@@@@%...@@@
    0xe3, 0xff, 0xff, 0xf1, 0xc0,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xe3, 0x00, 0x00, 0x71, 0xc0,  //@@@..+@@+................@@@...@@@
    0xe3, 0x00, 0x00, 0x71, 0xc0,  //@@@..+@@+................@@@...@@@
    0xe3, 0x00, 0x00, 0x71, 0xc0,  //@@@..+@@+................@@@...@@@
    0xe3, 0x00, 0x00, 0x71, 0xc0,  //@@@..+@@+................@@@...@@@
    0xe3, 0x00, 0x00, 0x71, 0xc0,  //@@@..+@@+................@@@...@@@
    0xe3, 0x00, 0x00, 0x71, 0xc0,  //@@@..+@@+................@@@...@@@
    0xe3, 0x00, 0x00, 0x71, 0xc0,  //@@@..+@@+................@@@...@@@
    0xe3, 0x00, 0x00, 0x71, 0xc0,  //@@@..+@@+................@@@...@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x7f, 0xff, 0xff, 0xff, 0x80,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f0e7 () , Width: 20 */
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x07, 0xf8, 0x00,  //....+@@@@@@@@+......
    0x0f, 0xf8, 0x00,  //....@@@@@@@@@+......
    0x0f, 0xf8, 0x00,  //....@@@@@@@@@.......
    0x0f, 0xf8, 0x00,  //...+@@@@@@@@%.......
    0x1f, 0xf0, 0x00,  //...%@@@@@@@@........
    0x1f, 0xf0, 0x00,  //...@@@@@@@@@........
    0x1f, 0xe0, 0x00,  //...@@@@@@@@+........
    0x1f, 0xe0, 0x00,  //..+@@@@@@@@.........
    0x3f, 0xe0, 0x00,  //..%@@@@@@@%.........
    0x3f, 0xc0, 0x60,  //..%@@@@@@@+.....+%%.
    0x3f, 0xc7, 0xe0,  //..@@@@@@@@..+%@@@@@+
    0x3f, 0xff, 0xe0,  //..@@@@@@@@@@@@@@@@@.
    0x3f, 0xff, 0xc0,  //.+@@@@@@@@@@@@@@@@+.
    0x7f, 0xff, 0xc0,  //.%@@@@@@@@@@@@@@@@..
    0x7f, 0xff, 0xc0,  //.@@@@@@@@@@@@@@@@%..
    0x7f, 0xff, 0x80,  //.@@@@@@@@@@@@@@@@...
    0x7f, 0xff, 0x80,  //+@@@@@@@@@@@@@@@%...
    0xff, 0xff, 0x00,  //%@@@@@@@@%@@@@@@....
    0xfc, 0x3f, 0x00,  //@@@@@%+...@@@@@%....
    0xc0, 0x3e, 0x00,  //%%+......+@@@@@.....
    0x00, 0x7e, 0x00,  //.........%@@@@%.....
    0x00, 0x7c, 0x00,  //.........@@@@@+.....
    0x00, 0x7c, 0x00,  //.........@@@@@......
    0x00, 0x78, 0x00,  //........+@@@@+......
    0x00, 0xf8, 0x00,  //........%@@@@.......
    0x00, 0xf0, 0x00,  //........@@@@+.......
    0x00, 0xf0, 0x00,  //........@@@@........
    0x00, 0xe0, 0x00,  //.......+@@@+........
    0x01, 0xe0, 0x00,  //.......%@@@.........
    0x01, 0xe0, 0x00,  //.......@@@%.........
    0x01, 0xc0, 0x00,  //.......@@@..........
    0x01, 0xc0, 0x00,  //......+@@%..........
    0x03, 0x80, 0x00,  //......%@@...........
    0x03, 0x80, 0x00,  //......@@%...........
    0x03, 0x00, 0x00,  //......@@............
    0x03, 0x00, 0x00,  //......@%............
    0x00, 0x00, 0x00,  //....................


    /*Unicode: U+f0f3 () , Width: 37 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x70, 0x00, 0x00,  //................+@@%.................
    0x00, 0x00, 0xf0, 0x00, 0x00,  //................@@@@.................
    0x00, 0x00, 0xf0, 0x00, 0x00,  //................@@@@.................
    0x00, 0x07, 0xfe, 0x00, 0x00,  //.............%@@@@@@@@%..............
    0x00, 0x1f, 0xff, 0x80, 0x00,  //...........%@@@@@@@@@@@@%............
    0x00, 0x3f, 0xff, 0xc0, 0x00,  //..........%@@@@@@@@@@@@@@@...........
    0x00, 0x7f, 0xff, 0xe0, 0x00,  //.........%@@@@@@@@@@@@@@@@@..........
    0x00, 0x7f, 0xff, 0xf0, 0x00,  //........+@@@@@@@@@@@@@@@@@@%.........
    0x00, 0xff, 0xff, 0xf0, 0x00,  //........@@@@@@@@@@@@@@@@@@@@+........
    0x01, 0xff, 0xff, 0xf8, 0x00,  //.......+@@@@@@@@@@@@@@@@@@@@%........
    0x01, 0xff, 0xff, 0xf8, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@........
    0x01, 0xff, 0xff, 0xf8, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@........
    0x01, 0xff, 0xff, 0xf8, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@........
    0x01, 0xff, 0xff, 0xf8, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@+.......
    0x01, 0xff, 0xff, 0xf8, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@+.......
    0x01, 0xff, 0xff, 0xf8, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@+.......
    0x01, 0xff, 0xff, 0xf8, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@@@+.......
    0x01, 0xff, 0xff, 0xfc, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@@@%.......
    0x03, 0xff, 0xff, 0xfc, 0x00,  //......%@@@@@@@@@@@@@@@@@@@@@@@.......
    0x03, 0xff, 0xff, 0xfc, 0x00,  //......%@@@@@@@@@@@@@@@@@@@@@@@.......
    0x03, 0xff, 0xff, 0xfc, 0x00,  //......@@@@@@@@@@@@@@@@@@@@@@@@.......
    0x03, 0xff, 0xff, 0xfc, 0x00,  //......@@@@@@@@@@@@@@@@@@@@@@@@+......
    0x07, 0xff, 0xff, 0xfe, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@@@@......
    0x07, 0xff, 0xff, 0xfe, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@@@@......
    0x07, 0xff, 0xff, 0xff, 0x00,  //....+@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x0f, 0xff, 0xff, 0xff, 0x00,  //....@@@@@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x1f, 0xff, 0xff, 0xff, 0x80,  //...%@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x1f, 0xff, 0xff, 0xff, 0x80,  //...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+...
    0x3f, 0xff, 0xff, 0xff, 0xc0,  //..@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x7f, 0xff, 0xff, 0xff, 0xe0,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x7f, 0xff, 0xff, 0xff, 0xe0,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+.
    0x00, 0x0d, 0xff, 0x00, 0x00,  //...+++++++++%@+@@@@@@@@%+++++++++....
    0x00, 0x07, 0xff, 0x00, 0x00,  //............+@+%@@@@@@@%.............
    0x00, 0x06, 0xfe, 0x00, 0x00,  //.............@@+@@@@@@@..............
    0x00, 0x03, 0x3e, 0x00, 0x00,  //.............+@@++@@@@%..............
    0x00, 0x01, 0xfc, 0x00, 0x00,  //..............+@@@@@@%...............
    0x00, 0x00, 0xf0, 0x00, 0x00,  //................%@@%+................


    /*Unicode: U+f11c () , Width: 42 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x7f, 0xff, 0xff, 0xff, 0xff, 0x80,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xe0, 0x00, 0x00, 0x00, 0x01, 0xc0,  //@@@....................................@@@
    0xe0, 0x00, 0x00, 0x00, 0x01, 0xc0,  //@@@....................................@@@
    0xe3, 0x1c, 0x63, 0x8c, 0x71, 0xc0,  //@@@..+@@...@@@...@@...@@@...@@+..%@@...@@@
    0xe7, 0x1c, 0x63, 0x8c, 0x71, 0xc0,  //@@@..%@@...@@@...@@...@@@...@@+..@@@...@@@
    0xe7, 0x1c, 0x63, 0x8c, 0x71, 0xc0,  //@@@..%@@...@@@...@@...@@@...@@+..@@@...@@@
    0xe0, 0x00, 0x00, 0x00, 0x71, 0xc0,  //@@@..............................@@@...@@@
    0xe0, 0x00, 0x00, 0x00, 0x71, 0xc0,  //@@@..............................@@@...@@@
    0xe0, 0x00, 0x00, 0x00, 0x71, 0xc0,  //@@@..............................@@@...@@@
    0xe7, 0xe3, 0x9c, 0x73, 0xf1, 0xc0,  //@@@..%@@@@@...@@@..@@@...@@@..%@@@@@...@@@
    0xe7, 0xe3, 0x9c, 0x73, 0xf1, 0xc0,  //@@@..%@@@@@...@@@..@@@...@@@..%@@@@@...@@@
    0xe3, 0xe3, 0x9c, 0x71, 0xf1, 0xc0,  //@@@..+@@@@@...@@%..%@@...@@%..+@@@@@...@@@
    0xe0, 0x00, 0x00, 0x00, 0x01, 0xc0,  //@@@....................................@@@
    0xe0, 0x00, 0x00, 0x00, 0x01, 0xc0,  //@@@....................................@@@
    0xe0, 0x00, 0x00, 0x00, 0x01, 0xc0,  //@@@....................................@@@
    0xe7, 0x1f, 0xff, 0xfc, 0x71, 0xc0,  //@@@..%@@...@@@@@@@@@@@@@@@@@@@+..@@@...@@@
    0xe7, 0x1f, 0xff, 0xfc, 0x71, 0xc0,  //@@@..%@@...@@@@@@@@@@@@@@@@@@@+..@@@...@@@
    0xe3, 0x1f, 0xff, 0xfc, 0x71, 0xc0,  //@@@..+@@...@@@@@@@@@@@@@@@@@@@+..%@@...@@@
    0xe0, 0x00, 0x00, 0x00, 0x01, 0xc0,  //@@@....................................@@@
    0xe0, 0x00, 0x00, 0x00, 0x01, 0xc0,  //@@@....................................@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x7f, 0xff, 0xff, 0xff, 0xff, 0x80,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................


    /*Unicode: U+f124 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x0c,  //............................%@.
    0x00, 0x00, 0x00, 0x3e,  //..........................%@@@%
    0x00, 0x00, 0x00, 0xfc,  //........................%@@@@@+
    0x00, 0x00, 0x03, 0xfc,  //......................%@@@@@@@.
    0x00, 0x00, 0x0f, 0xf8,  //....................%@@@@@@@@+.
    0x00, 0x00, 0x3f, 0xf8,  //..................%@@@@@@@@@@..
    0x00, 0x00, 0xff, 0xf0,  //................%@@@@@@@@@@@+..
    0x00, 0x03, 0xff, 0xf0,  //..............%@@@@@@@@@@@@@...
    0x00, 0x0f, 0xff, 0xe0,  //............%@@@@@@@@@@@@@@+...
    0x00, 0x3f, 0xff, 0xe0,  //..........%@@@@@@@@@@@@@@@@....
    0x00, 0xff, 0xff, 0xc0,  //........%@@@@@@@@@@@@@@@@@+....
    0x03, 0xff, 0xff, 0xc0,  //......%@@@@@@@@@@@@@@@@@@@.....
    0x0f, 0xff, 0xff, 0x80,  //....%@@@@@@@@@@@@@@@@@@@@+.....
    0x3f, 0xff, 0xff, 0x80,  //..%@@@@@@@@@@@@@@@@@@@@@@......
    0x7f, 0xff, 0xff, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@+......
    0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@.......
    0x7f, 0xff, 0xfe, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x03, 0xfe, 0x00,  //..............@@@@@@@@@........
    0x00, 0x03, 0xfc, 0x00,  //..............@@@@@@@@+........
    0x00, 0x03, 0xfc, 0x00,  //..............@@@@@@@@.........
    0x00, 0x03, 0xf8, 0x00,  //..............@@@@@@@+.........
    0x00, 0x03, 0xf8, 0x00,  //..............@@@@@@@..........
    0x00, 0x03, 0xf0, 0x00,  //..............@@@@@@+..........
    0x00, 0x03, 0xf0, 0x00,  //..............@@@@@@...........
    0x00, 0x03, 0xe0, 0x00,  //..............@@@@@+...........
    0x00, 0x03, 0xe0, 0x00,  //..............@@@@@............
    0x00, 0x03, 0xc0, 0x00,  //..............@@@@+............
    0x00, 0x03, 0xc0, 0x00,  //..............@@@@.............
    0x00, 0x03, 0x80, 0x00,  //..............@@@+.............
    0x00, 0x03, 0x80, 0x00,  //..............@@@..............
    0x00, 0x01, 0x00, 0x00,  //..............+%...............
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f15b () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x7f, 0xff, 0xe0, 0x00, 0x00,  //.@@@@@@@@@@@@@@@@@@+..............
    0xff, 0xff, 0xe2, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%...........
    0xff, 0xff, 0xe3, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@..........
    0xff, 0xff, 0xe3, 0x80, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@.........
    0xff, 0xff, 0xe3, 0xc0, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@........
    0xff, 0xff, 0xe3, 0xe0, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@.......
    0xff, 0xff, 0xe3, 0xf0, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@@......
    0xff, 0xff, 0xe3, 0xf8, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@@@.....
    0xff, 0xff, 0xe3, 0xfc, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@@@@....
    0xff, 0xff, 0xe3, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@@@@@...
    0xff, 0xff, 0xe3, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@@@@@@..
    0xff, 0xff, 0xe0, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..............
    0xff, 0xff, 0xf0, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@%..............
    0xff, 0xff, 0xf0, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@+.............
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x7f, 0xff, 0xff, 0xff, 0x80,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.


    /*Unicode: U+f1eb () , Width: 43 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,  //.................+++%%+++..................
    0x00, 0x07, 0xff, 0xf8, 0x00, 0x00,  //............+%@@@@@@@@@@@@@@%+.............
    0x00, 0x3f, 0xff, 0xff, 0x80, 0x00,  //..........%@@@@@@@@@@@@@@@@@@@@@%..........
    0x00, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.......+@@@@@@@@@@@@@@@@@@@@@@@@@@%........
    0x03, 0xff, 0xff, 0xff, 0xf8, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%......
    0x0f, 0xff, 0xff, 0xff, 0xfe, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+....
    0x1f, 0xff, 0x00, 0x1f, 0xff, 0x00,  //..+@@@@@@@@@@@@%++.......++%@@@@@@@@@@@@...
    0x3f, 0xf8, 0x00, 0x03, 0xff, 0x80,  //.+@@@@@@@@@@%................+%@@@@@@@@@@..
    0xff, 0xc0, 0x0e, 0x00, 0xff, 0xc0,  //%@@@@@@@@@+.......++%%+++.......%@@@@@@@@@+
    0xff, 0x01, 0xff, 0xf0, 0x3f, 0xe0,  //@@@@@@@@+.....+%@@@@@@@@@@@%+.....%@@@@@@@%
    0x7e, 0x0f, 0xff, 0xfe, 0x0f, 0xc0,  //.@@@@@%.....%@@@@@@@@@@@@@@@@@%....+@@@@@%.
    0x38, 0x3f, 0xff, 0xff, 0x87, 0x80,  //..@@@+....%@@@@@@@@@@@@@@@@@@@@@%....%@@%..
    0x10, 0x7f, 0xff, 0xff, 0xc0, 0x00,  //...%+...+@@@@@@@@@@@@@@@@@@@@@@@@@....++...
    0x01, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.......%@@@@@@@@@@@@@@@@@@@@@@@@@@@+.......
    0x03, 0xff, 0xc0, 0x7f, 0xf0, 0x00,  //......%@@@@@@@@@@%+.....+%@@@@@@@@@@+......
    0x03, 0xfe, 0x00, 0x0f, 0xf8, 0x00,  //......@@@@@@@@%............+@@@@@@@@%......
    0x01, 0xf8, 0x00, 0x03, 0xf0, 0x00,  //.......@@@@@@................+@@@@@@.......
    0x00, 0xe0, 0x3f, 0x81, 0xe0, 0x00,  //........@@@+.....+%@@@@@%+.....%@@@........
    0x00, 0x41, 0xff, 0xe0, 0x40, 0x00,  //.........%.....%@@@@@@@@@@@+....+%.........
    0x00, 0x03, 0xff, 0xf8, 0x00, 0x00,  //.............+@@@@@@@@@@@@@@@+.............
    0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00,  //............%@@@@@@@@@@@@@@@@@+............
    0x00, 0x0f, 0xff, 0xfe, 0x00, 0x00,  //............@@@@@@@@@@@@@@@@@@@............
    0x00, 0x07, 0xff, 0xfc, 0x00, 0x00,  //............+@@@@@@@%%%@@@@@@@.............
    0x00, 0x03, 0xc0, 0x78, 0x00, 0x00,  //.............+@@@%......+@@@@..............
    0x00, 0x01, 0x00, 0x10, 0x00, 0x00,  //..............+@+.........+@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................+.....................
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //..................+@@@@@+..................
    0x00, 0x00, 0x3f, 0x80, 0x00, 0x00,  //..................@@@@@@@..................
    0x00, 0x00, 0x1f, 0x00, 0x00, 0x00,  //..................+@@@@@...................
    0x00, 0x00, 0x1e, 0x00, 0x00, 0x00,  //...................%@@@+...................
    0x00, 0x00, 0x04, 0x00, 0x00, 0x00,  //....................+@+....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................


    /*Unicode: U+f240 () , Width: 51 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x00,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@...
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x80,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@%..
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xc0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@@@.
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@@@+
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@@@%
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xc0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@@@+
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xc0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@@%.
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x00,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@...
    0xe3, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x00,  //@@@...%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%...@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................


    /*Unicode: U+f241 () , Width: 51 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x07, 0x00,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@...
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x07, 0x80,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@%..
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x07, 0xc0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@@@.
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x07, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@@@+
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x07, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@@@%
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x07, 0xc0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@@@+
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x07, 0xc0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@@%.
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x07, 0x00,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@...
    0xe3, 0xff, 0xff, 0xff, 0xc0, 0x07, 0x00,  //@@@...%%%%%%%%%%%%%%%%%%%%%%%%%%%%...........@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................


    /*Unicode: U+f242 () , Width: 51 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x07, 0x00,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@...
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x07, 0x80,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@%..
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x07, 0xc0,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@@@.
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x07, 0xe0,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@@@+
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x00, 0xe0,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x00, 0xe0,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x00, 0xe0,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x00, 0xe0,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x00, 0xe0,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x00, 0xe0,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x00, 0xe0,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x00, 0xe0,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x07, 0xe0,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@@@%
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x07, 0xc0,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@@@+
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x07, 0xc0,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@@%.
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x07, 0x00,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@...
    0xe3, 0xff, 0xff, 0x80, 0x00, 0x07, 0x00,  //@@@..+%%%%%%%%%%%%%%%%%%%....................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................


    /*Unicode: U+f243 () , Width: 51 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x07, 0x00,  //@@@...@@@@@@@@@@@............................@@@...
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x07, 0x80,  //@@@...@@@@@@@@@@@............................@@@%..
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x07, 0xc0,  //@@@...@@@@@@@@@@@............................@@@@@.
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x07, 0xe0,  //@@@...@@@@@@@@@@@............................@@@@@+
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x00, 0xe0,  //@@@...@@@@@@@@@@@...............................@@%
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x00, 0xe0,  //@@@...@@@@@@@@@@@...............................@@%
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x00, 0xe0,  //@@@...@@@@@@@@@@@...............................@@%
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x00, 0xe0,  //@@@...@@@@@@@@@@@...............................@@%
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x00, 0xe0,  //@@@...@@@@@@@@@@@...............................@@%
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x00, 0xe0,  //@@@...@@@@@@@@@@@...............................@@%
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x00, 0xe0,  //@@@...@@@@@@@@@@@...............................@@%
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x00, 0xe0,  //@@@...@@@@@@@@@@@...............................@@%
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x07, 0xe0,  //@@@...@@@@@@@@@@@............................@@@@@%
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x07, 0xc0,  //@@@...@@@@@@@@@@@............................@@@@@+
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x07, 0xc0,  //@@@...@@@@@@@@@@@............................@@@@%.
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x07, 0x00,  //@@@...@@@@@@@@@@@............................@@@...
    0xe3, 0xff, 0x80, 0x00, 0x00, 0x07, 0x00,  //@@@...%%%%%%%%%%%............................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................


    /*Unicode: U+f244 () , Width: 51 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80,  //@@@..........................................@@@@+.
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xc0,  //@@@..........................................@@@@@.
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xe0,  //@@@..........................................@@@@@%
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0,  //@@@.............................................@@%
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0,  //@@@.............................................@@%
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0,  //@@@.............................................@@%
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0,  //@@@.............................................@@%
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0,  //@@@.............................................@@%
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0,  //@@@.............................................@@%
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0,  //@@@.............................................@@%
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0,  //@@@.............................................@@%
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xe0,  //@@@..........................................@@@@@%
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xc0,  //@@@..........................................@@@@@.
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80,  //@@@..........................................@@@@+.
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,  //@@@..........................................@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................


    /*Unicode: U+f293 () , Width: 29 */
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x3f, 0xe0, 0x00,  //.........+%@@@@@@@%+.........
    0x01, 0xff, 0xfc, 0x00,  //.......%@@@@@@@@@@@@@%.......
    0x03, 0xff, 0xfe, 0x00,  //.....+@@@@@@@@@@@@@@@@@+.....
    0x0f, 0xfb, 0xff, 0x00,  //....+@@@@@@@@+@@@@@@@@@@+....
    0x0f, 0xf9, 0xff, 0x80,  //...+@@@@@@@@@..@@@@@@@@@@....
    0x1f, 0xf8, 0xff, 0xc0,  //...@@@@@@@@@@...@@@@@@@@@@...
    0x3f, 0xf8, 0x7f, 0xc0,  //..%@@@@@@@@@@....@@@@@@@@@+..
    0x3f, 0xf8, 0x3f, 0xe0,  //..@@@@@@@@@@@.....@@@@@@@@@..
    0x3f, 0xf8, 0x1f, 0xe0,  //.+@@@@@@@@@@@......@@@@@@@@+.
    0x7f, 0xf8, 0x0f, 0xf0,  //.@@@@@@@@@@@@.......@@@@@@@%.
    0x7f, 0xf8, 0x87, 0xf0,  //.@@@@@@%@@@@@...@....@@@@@@@.
    0x7e, 0x78, 0xc3, 0xf0,  //+@@@@@%.+@@@@...@@....@@@@@@.
    0x7c, 0x38, 0xe1, 0xf0,  //+@@@@@...+@@@...@@@....@@@@@+
    0xfe, 0x18, 0xe1, 0xf0,  //%@@@@@%...+@@...@@%...+@@@@@+
    0xff, 0x08, 0xc3, 0xf8,  //%@@@@@@%...+@...@%...+@@@@@@%
    0xff, 0x80, 0x87, 0xf8,  //@@@@@@@@%...+...%...+@@@@@@@%
    0xff, 0xc0, 0x0f, 0xf8,  //@@@@@@@@@%.........+@@@@@@@@%
    0xff, 0xe0, 0x1f, 0xf8,  //@@@@@@@@@@%.......+@@@@@@@@@@
    0xff, 0xf0, 0x3f, 0xf8,  //@@@@@@@@@@@%.....+@@@@@@@@@@@
    0xff, 0xf0, 0x7f, 0xf8,  //@@@@@@@@@@@@+....@@@@@@@@@@@@
    0xff, 0xf0, 0x3f, 0xf8,  //@@@@@@@@@@@%.....+@@@@@@@@@@@
    0xff, 0xe0, 0x1f, 0xf8,  //@@@@@@@@@@%.......+@@@@@@@@@@
    0xff, 0xc0, 0x0f, 0xf8,  //@@@@@@@@@%.........+@@@@@@@@%
    0xff, 0x80, 0x87, 0xf8,  //@@@@@@@@%...+...%...+@@@@@@@%
    0xff, 0x08, 0xc3, 0xf8,  //%@@@@@@%...+@...@%...+@@@@@@%
    0xfe, 0x18, 0xe1, 0xf0,  //%@@@@@%...+@@...@@%...+@@@@@+
    0x7c, 0x38, 0xe1, 0xf0,  //+@@@@@...+@@@...@@@....@@@@@+
    0x7e, 0x78, 0xc3, 0xf0,  //+@@@@@%.+@@@@...@@....@@@@@@.
    0x7f, 0xf8, 0x87, 0xf0,  //.@@@@@@%@@@@@...@....@@@@@@@.
    0x7f, 0xf8, 0x0f, 0xf0,  //.@@@@@@@@@@@@.......@@@@@@@%.
    0x3f, 0xf8, 0x1f, 0xe0,  //.+@@@@@@@@@@@......@@@@@@@@+.
    0x3f, 0xf8, 0x3f, 0xe0,  //..@@@@@@@@@@@.....@@@@@@@@@..
    0x3f, 0xf8, 0x7f, 0xc0,  //..%@@@@@@@@@@....@@@@@@@@@+..
    0x1f, 0xf8, 0xff, 0xc0,  //...@@@@@@@@@@...@@@@@@@@@@...
    0x0f, 0xf9, 0xff, 0x80,  //...+@@@@@@@@@..@@@@@@@@@@....
    0x0f, 0xfb, 0xff, 0x00,  //....+@@@@@@@@+@@@@@@@@@@+....
    0x03, 0xff, 0xfe, 0x00,  //.....+@@@@@@@@@@@@@@@@@+.....
    0x01, 0xff, 0xfc, 0x00,  //.......%@@@@@@@@@@@@@%.......
    0x00, 0x3f, 0xe0, 0x00,  //.........+%@@@@@@@%+.........



#elif USE_LV_FONT_SYMBOL_40 == 2
    /*Unicode: U+f001 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x80,  //.............................+%@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xe0,  //..........................+%@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xf0,  //.......................+@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x01, 0xbf, 0xff, 0xff, 0xf0,  //...................+%@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xf0,  //................+%@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.............+%@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //...........+@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //...........@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //...........@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //...........@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //...........@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xf0,  //...........@@@@@@@@@@@@@@@@@@@%@@@
    0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xfe, 0x43, 0xf0,  //...........@@@@@@@@@@@@@@@@%+..@@@
    0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x90, 0x03, 0xf0,  //...........@@@@@@@@@@@@@%......@@@
    0x00, 0x00, 0x03, 0xff, 0xff, 0xd0, 0x00, 0x03, 0xf0,  //...........@@@@@@@@@@+.........@@@
    0x00, 0x00, 0x03, 0xff, 0xe4, 0x00, 0x00, 0x03, 0xf0,  //...........@@@@@@%+............@@@
    0x00, 0x00, 0x03, 0xf9, 0x00, 0x00, 0x00, 0x03, 0xf0,  //...........@@@%+...............@@@
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x03, 0xf0,  //...........@@@.................@@@
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x03, 0xf0,  //...........@@@.................@@@
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x03, 0xf0,  //...........@@@.................@@@
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x03, 0xf0,  //...........@@@.................@@@
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x03, 0xf0,  //...........@@@.................@@@
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x5a, 0x43, 0xf0,  //...........@@@..........++%%+..@@@
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x0b, 0xff, 0xff, 0xf0,  //...........@@@........%@@@@@@@@@@@
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x3f, 0xff, 0xff, 0xf0,  //...........@@@.......@@@@@@@@@@@@@
    0x00, 0x00, 0x03, 0xf0, 0x00, 0xff, 0xff, 0xff, 0xf0,  //...........@@@......@@@@@@@@@@@@@@
    0x00, 0x00, 0x03, 0xf0, 0x00, 0xff, 0xff, 0xff, 0xf0,  //...........@@@......@@@@@@@@@@@@@@
    0x00, 0x00, 0x03, 0xf0, 0x00, 0xff, 0xff, 0xff, 0xe0,  //...........@@@......@@@@@@@@@@@@@%
    0x01, 0xbf, 0xe7, 0xf0, 0x00, 0x7f, 0xff, 0xff, 0xc0,  //...+%@@@@%+@@@......+@@@@@@@@@@@@.
    0x1f, 0xff, 0xff, 0xf0, 0x00, 0x1f, 0xff, 0xfe, 0x00,  //.+@@@@@@@@@@@@.......+@@@@@@@@@%..
    0x7f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x6a, 0x90, 0x00,  //+@@@@@@@@@@@@@..........+%%%%+....
    0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@....................
    0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@....................
    0xbf, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@%....................
    0x2f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@%.....................
    0x06, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+%@@@@@@%+......................
    0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......++..........................


    /*Unicode: U+f008 () , Width: 42 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xfd, 0x01, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x07, 0xf4, 0x07, 0xf0,  //@@@+...+@@@+..................+@@@+...+@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@....................@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@....................@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@....................@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@....................@@@.....@@@
    0xfd, 0x01, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf4, 0x07, 0xf0,  //@@@+...+@@@....................@@@+...+@@@
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@....................@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@....................@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@....................@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@....................@@@.....@@@
    0xfc, 0x00, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x07, 0xf0,  //@@@.....@@@+..................+@@@....+@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x07, 0xf0,  //@@@.....@@@+..................+@@@....+@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@....................@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@....................@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@....................@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x07, 0xf0,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xfd, 0x01, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf4, 0x07, 0xf0,  //@@@+...+@@@....................@@@+...+@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@....................@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@....................@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@....................@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@....................@@@.....@@@
    0xfd, 0x01, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x07, 0xf4, 0x07, 0xf0,  //@@@+...+@@@+..................+@@@+...+@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..


    /*Unicode: U+f00b () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x05, 0x55, 0x50, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x40,  //..++++++++......+++++++++++++++++++++..
    0xbf, 0xff, 0xf8, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //%@@@@@@@@@%...%@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //.@@@@@@@@@+...+@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x05, 0x55, 0x50, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x40,  //..++++++++......+++++++++++++++++++++..
    0xbf, 0xff, 0xf8, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //%@@@@@@@@@%...%@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //.@@@@@@@@@+...+@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x05, 0x55, 0x50, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x40,  //..++++++++......+++++++++++++++++++++..
    0xbf, 0xff, 0xf8, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //%@@@@@@@@@%...%@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //.@@@@@@@@@+...+@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................


    /*Unicode: U+f00c () , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,  //............................@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x00,  //...........................@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xc0,  //..........................@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xf0,  //.........................@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf4,  //........................@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xf0,  //.......................@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xe0,  //......................@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0x80,  //.....................@@@@@@@@@@@%..
    0x00, 0xfd, 0x00, 0x00, 0x00, 0xff, 0xff, 0xfe, 0x00,  //....@@@+............@@@@@@@@@@@%...
    0x03, 0xff, 0x40, 0x00, 0x03, 0xff, 0xff, 0xf8, 0x00,  //...@@@@@+..........@@@@@@@@@@@%....
    0x0f, 0xff, 0xd0, 0x00, 0x0f, 0xff, 0xff, 0xe0, 0x00,  //..@@@@@@@+........@@@@@@@@@@@%.....
    0x3f, 0xff, 0xf4, 0x00, 0x3f, 0xff, 0xff, 0x80, 0x00,  //.@@@@@@@@@+......@@@@@@@@@@@%......
    0x7f, 0xff, 0xfd, 0x00, 0xff, 0xff, 0xfe, 0x00, 0x00,  //+@@@@@@@@@@+....@@@@@@@@@@@%.......
    0x3f, 0xff, 0xff, 0x43, 0xff, 0xff, 0xf8, 0x00, 0x00,  //.@@@@@@@@@@@+..@@@@@@@@@@@%........
    0x1f, 0xff, 0xff, 0xef, 0xff, 0xff, 0xe0, 0x00, 0x00,  //.+@@@@@@@@@@@+@@@@@@@@@@@%.........
    0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@@%..........
    0x01, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@@@%...........
    0x00, 0x7f, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@@@%............
    0x00, 0x1f, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@%.............
    0x00, 0x07, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@%..............
    0x00, 0x01, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@@%...............
    0x00, 0x00, 0x7f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@%................
    0x00, 0x00, 0x1f, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@@@%.................
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@@%..................
    0x00, 0x00, 0x02, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@%...................
    0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+%+....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+f00d () , Width: 26 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0xb4, 0x00, 0x00, 0x01, 0xe0, 0x00,  //....%@+............+@%....
    0x03, 0xfd, 0x00, 0x00, 0x07, 0xfc, 0x00,  //...@@@@+..........+@@@@...
    0x0f, 0xff, 0x40, 0x00, 0x1f, 0xff, 0x00,  //..@@@@@@+........+@@@@@@..
    0x3f, 0xff, 0xd0, 0x00, 0x7f, 0xff, 0xc0,  //.@@@@@@@@+......+@@@@@@@@.
    0xbf, 0xff, 0xf4, 0x01, 0xff, 0xff, 0xf0,  //%@@@@@@@@@+....+@@@@@@@@@@
    0xff, 0xff, 0xfd, 0x07, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@+..+@@@@@@@@@@@
    0x7f, 0xff, 0xff, 0x5f, 0xff, 0xff, 0xd0,  //+@@@@@@@@@@@++@@@@@@@@@@@+
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //.+@@@@@@@@@@@@@@@@@@@@@@%.
    0x07, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@%..
    0x01, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //...+@@@@@@@@@@@@@@@@@@%...
    0x00, 0x7f, 0xff, 0xff, 0xff, 0xe0, 0x00,  //....+@@@@@@@@@@@@@@@@%....
    0x00, 0x1f, 0xff, 0xff, 0xff, 0x80, 0x00,  //.....+@@@@@@@@@@@@@@%.....
    0x00, 0x07, 0xff, 0xff, 0xfe, 0x00, 0x00,  //......+@@@@@@@@@@@@%......
    0x00, 0x07, 0xff, 0xff, 0xfd, 0x00, 0x00,  //......+@@@@@@@@@@@@+......
    0x00, 0x1f, 0xff, 0xff, 0xff, 0x40, 0x00,  //.....+@@@@@@@@@@@@@@+.....
    0x00, 0x7f, 0xff, 0xff, 0xff, 0xd0, 0x00,  //....+@@@@@@@@@@@@@@@@+....
    0x01, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00,  //...+@@@@@@@@@@@@@@@@@@+...
    0x07, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@+..
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //.+@@@@@@@@@@@@@@@@@@@@@@+.
    0x7f, 0xff, 0xff, 0x9f, 0xff, 0xff, 0xd0,  //.@@@@@@@@@@@%+@@@@@@@@@@@+
    0xff, 0xff, 0xfe, 0x07, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@%..+@@@@@@@@@@@
    0xbf, 0xff, 0xf8, 0x01, 0xff, 0xff, 0xf0,  //%@@@@@@@@@%....+@@@@@@@@@@
    0x3f, 0xff, 0xe0, 0x00, 0x7f, 0xff, 0xd0,  //.@@@@@@@@%......+@@@@@@@@+
    0x0f, 0xff, 0x80, 0x00, 0x1f, 0xff, 0x40,  //..@@@@@@%........+@@@@@@+.
    0x03, 0xfe, 0x00, 0x00, 0x07, 0xfd, 0x00,  //...@@@@%..........+@@@@+..
    0x00, 0xf4, 0x00, 0x00, 0x01, 0xf4, 0x00,  //....@@+............+@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................


    /*Unicode: U+f011 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x00,  //................++................
    0x00, 0x00, 0x00, 0x07, 0xfc, 0x00, 0x00, 0x00, 0x00,  //..............+@@@@...............
    0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@+..............
    0x00, 0x00, 0x00, 0x0f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@%..............
    0x00, 0x00, 0x00, 0x0f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@%..............
    0x00, 0x00, 0x00, 0x0f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@%..............
    0x00, 0x01, 0x90, 0x0f, 0xfe, 0x00, 0x60, 0x00, 0x00,  //.......+%+....@@@@@%....+%........
    0x00, 0x0f, 0xf8, 0x0f, 0xfe, 0x03, 0xfe, 0x00, 0x00,  //......@@@@+...@@@@@%...@@@@%......
    0x00, 0x3f, 0xfc, 0x0f, 0xfe, 0x07, 0xff, 0x80, 0x00,  //.....@@@@@@...@@@@@%..+@@@@@%.....
    0x00, 0xff, 0xfc, 0x0f, 0xfe, 0x0b, 0xff, 0xe0, 0x00,  //....@@@@@@@...@@@@@%..+@@@@@@%....
    0x03, 0xff, 0xf8, 0x0f, 0xfe, 0x03, 0xff, 0xf4, 0x00,  //...@@@@@@@%...@@@@@%...@@@@@@@+...
    0x07, 0xff, 0xf0, 0x0f, 0xfe, 0x01, 0xff, 0xfc, 0x00,  //..+@@@@@@@....@@@@@%...+@@@@@@@...
    0x0f, 0xff, 0xc0, 0x0f, 0xfe, 0x00, 0x7f, 0xfe, 0x00,  //..@@@@@@@.....@@@@@%....+@@@@@@%..
    0x2f, 0xff, 0x00, 0x0f, 0xfe, 0x00, 0x1f, 0xff, 0x00,  //.%@@@@@@......@@@@@%.....+@@@@@@..
    0x3f, 0xfd, 0x00, 0x0f, 0xfe, 0x00, 0x0b, 0xff, 0x80,  //.@@@@@@+......@@@@@%......%@@@@@%.
    0x7f, 0xf8, 0x00, 0x0f, 0xfe, 0x00, 0x03, 0xff, 0xc0,  //+@@@@@%.......@@@@@%.......@@@@@@.
    0xbf, 0xf0, 0x00, 0x0f, 0xfe, 0x00, 0x02, 0xff, 0xc0,  //%@@@@@........@@@@@%.......%@@@@@.
    0xbf, 0xf0, 0x00, 0x0f, 0xfe, 0x00, 0x01, 0xff, 0xd0,  //%@@@@@........@@@@@%.......+@@@@@+
    0xff, 0xe0, 0x00, 0x0b, 0xfc, 0x00, 0x00, 0xff, 0xd0,  //@@@@@%........%@@@@.........@@@@@+
    0xff, 0xe0, 0x00, 0x02, 0xf4, 0x00, 0x00, 0xff, 0xe0,  //@@@@@%.........%@@+.........@@@@@%
    0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xe0,  //@@@@@%......................@@@@@%
    0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xd0,  //@@@@@%......................@@@@@+
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xd0,  //@@@@@@......................@@@@@+
    0xbf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc0,  //%@@@@@.....................%@@@@@.
    0x7f, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xc0,  //+@@@@@+....................@@@@@@.
    0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0x80,  //.@@@@@@...................+@@@@@%.
    0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x40,  //.@@@@@@%..................@@@@@@+.
    0x1f, 0xff, 0x40, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x00,  //.+@@@@@@+................%@@@@@@..
    0x0b, 0xff, 0xd0, 0x00, 0x00, 0x00, 0xbf, 0xfd, 0x00,  //..%@@@@@@+..............%@@@@@@+..
    0x03, 0xff, 0xf8, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00,  //...@@@@@@@%............@@@@@@@%...
    0x01, 0xff, 0xff, 0x40, 0x00, 0x2f, 0xff, 0xf0, 0x00,  //...+@@@@@@@@+........%@@@@@@@@....
    0x00, 0xbf, 0xff, 0xfe, 0xab, 0xff, 0xff, 0xc0, 0x00,  //....%@@@@@@@@@@%%%%@@@@@@@@@@.....
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //........%@@@@@@@@@@@@@@@@+........
    0x00, 0x00, 0x1b, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00,  //..........%@@@@@@@@@@@@%..........
    0x00, 0x00, 0x00, 0x6f, 0xff, 0x90, 0x00, 0x00, 0x00,  //............+%@@@@@@%+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f013 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x1f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@%..............
    0x00, 0x00, 0x00, 0x2f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.............%@@@@@@..............
    0x00, 0x00, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.............@@@@@@@..............
    0x00, 0x0b, 0x40, 0x3f, 0xff, 0x00, 0x78, 0x00, 0x00,  //......%@+....@@@@@@@....+@%.......
    0x00, 0x2f, 0xe0, 0x7f, 0xff, 0x42, 0xfe, 0x00, 0x00,  //.....%@@@%..+@@@@@@@+..%@@@%......
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //...+@@@@@@@@@@@@@@@@@@@@@@@@@+....
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x3f, 0xff, 0xf9, 0x0b, 0xff, 0xff, 0x00, 0x00,  //.....@@@@@@@@@%+..%@@@@@@@@@......
    0x00, 0x3f, 0xff, 0xc0, 0x00, 0xff, 0xff, 0x40, 0x00,  //.....@@@@@@@@.......@@@@@@@@+.....
    0x6b, 0xff, 0xff, 0x40, 0x00, 0x3f, 0xff, 0xf9, 0x00,  //+%%@@@@@@@@@.........@@@@@@@@@%+..
    0xff, 0xff, 0xfe, 0x00, 0x00, 0x2f, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@%.........%@@@@@@@@@@@.
    0xff, 0xff, 0xfd, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@+..........@@@@@@@@@@@.
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@...........@@@@@@@@@@@.
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@...........@@@@@@@@@@@.
    0xff, 0xff, 0xfd, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@+..........@@@@@@@@@@@.
    0xff, 0xff, 0xfe, 0x00, 0x00, 0x2f, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@%.........%@@@@@@@@@@@.
    0x1b, 0xff, 0xff, 0x00, 0x00, 0x3f, 0xff, 0xfa, 0x40,  //.+%%@@@@@@@@.........@@@@@@@@@%%+.
    0x00, 0x3f, 0xff, 0xc0, 0x00, 0xff, 0xff, 0x40, 0x00,  //.....@@@@@@@@.......@@@@@@@@+.....
    0x00, 0x3f, 0xff, 0xf9, 0x0b, 0xff, 0xff, 0x00, 0x00,  //.....@@@@@@@@@%+..%@@@@@@@@@......
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //....+@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //...+@@@@@@@@@@@@@@@@@@@@@@@@@+....
    0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xc0, 0x00,  //....%@@@@@@@@@@@@@@@@@%@@@@@@.....
    0x00, 0x2f, 0xe0, 0x3f, 0xff, 0x42, 0xff, 0x00, 0x00,  //.....%@@@%...@@@@@@@+..%@@@@......
    0x00, 0x0b, 0x40, 0x3f, 0xff, 0x00, 0x78, 0x00, 0x00,  //......%@+....@@@@@@@....+@%.......
    0x00, 0x00, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.............@@@@@@@..............
    0x00, 0x00, 0x00, 0x2f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.............%@@@@@@..............
    0x00, 0x00, 0x00, 0x1f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f014 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x07, 0xff, 0xfe, 0x00, 0x00, 0x00,  //..........+@@@@@@@@%...........
    0x00, 0x00, 0x2f, 0xff, 0xff, 0xd0, 0x00, 0x00,  //.........%@@@@@@@@@@@+.........
    0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00,  //.........@@@@@@@@@@@@@.........
    0x00, 0x00, 0xbd, 0x00, 0x03, 0xf0, 0x00, 0x00,  //........%@@+.......@@@.........
    0x00, 0x00, 0xfc, 0x00, 0x01, 0xf8, 0x00, 0x00,  //........@@@........+@@%........
    0x00, 0x01, 0xf8, 0x00, 0x00, 0xfc, 0x00, 0x00,  //.......+@@%.........@@@........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x03, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //...@@%...................@@@...
    0x03, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //...@@%...................@@@...
    0x03, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //...@@%...................@@@...
    0x03, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //...@@%...................@@@...
    0x03, 0xe0, 0xbc, 0x0f, 0x81, 0xf0, 0x3f, 0x00,  //...@@%..+@@...@@%..+@@...@@@...
    0x03, 0xe0, 0xbc, 0x0f, 0x81, 0xf4, 0x3f, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x03, 0xe0, 0xbc, 0x0f, 0x81, 0xf4, 0x3f, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x03, 0xe0, 0xbc, 0x0f, 0x81, 0xf4, 0x3f, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x03, 0xe0, 0xbc, 0x0f, 0x81, 0xf4, 0x3f, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x03, 0xe0, 0xbc, 0x0f, 0x81, 0xf4, 0x3f, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x03, 0xe0, 0xbc, 0x0f, 0x81, 0xf4, 0x3f, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x03, 0xe0, 0xbc, 0x0f, 0x81, 0xf4, 0x3f, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x03, 0xe0, 0xbc, 0x0f, 0x81, 0xf4, 0x3f, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x03, 0xe0, 0xbc, 0x0f, 0x81, 0xf4, 0x3f, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x03, 0xe0, 0xbc, 0x0f, 0x81, 0xf4, 0x3f, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x03, 0xe0, 0xbc, 0x0f, 0x81, 0xf4, 0x3f, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x03, 0xe0, 0xbc, 0x0f, 0x81, 0xf4, 0x3f, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x03, 0xe0, 0x7c, 0x0f, 0x81, 0xf0, 0x3f, 0x00,  //...@@%..+@@...@@%..+@@...@@@...
    0x03, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //...@@%...................@@@...
    0x03, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //...@@%...................@@@...
    0x03, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //...@@%...................@@@...
    0x03, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00,  //...@@@..................+@@%...
    0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@@@@+...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....@@@@@@@@@@@@@@@@@@@@@@@....
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f015 () , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0xb8, 0x00, 0x7f, 0xe0, 0x00,  //................%@%.....+@@@@%.....
    0x00, 0x00, 0x00, 0x03, 0xff, 0x40, 0xbf, 0xf0, 0x00,  //...............@@@@@+...%@@@@@.....
    0x00, 0x00, 0x00, 0x1f, 0xff, 0xd0, 0xbf, 0xf0, 0x00,  //.............+@@@@@@@+..%@@@@@.....
    0x00, 0x00, 0x00, 0x7f, 0xff, 0xf8, 0xbf, 0xf0, 0x00,  //............+@@@@@@@@@%.%@@@@@.....
    0x00, 0x00, 0x02, 0xff, 0x8b, 0xfe, 0xbf, 0xf0, 0x00,  //...........%@@@@%.%@@@@%%@@@@@.....
    0x00, 0x00, 0x0f, 0xfe, 0x01, 0xff, 0xff, 0xf0, 0x00,  //..........@@@@@%...+@@@@@@@@@@.....
    0x00, 0x00, 0x3f, 0xf4, 0x78, 0x3f, 0xff, 0xf0, 0x00,  //.........@@@@@+.+@%..@@@@@@@@@.....
    0x00, 0x01, 0xff, 0xd2, 0xfe, 0x0f, 0xff, 0xf0, 0x00,  //.......+@@@@@..+@@@%..@@@@@@@@.....
    0x00, 0x07, 0xff, 0x0b, 0xff, 0xc2, 0xff, 0xf0, 0x00,  //......+@@@@@..%@@@@@@..%@@@@@@.....
    0x00, 0x2f, 0xf8, 0x3f, 0xff, 0xf0, 0xbf, 0xf0, 0x00,  //.....%@@@@%..@@@@@@@@@..%@@@@@.....
    0x00, 0xff, 0xe0, 0xff, 0xff, 0xfd, 0x1f, 0xfc, 0x00,  //....@@@@@%..@@@@@@@@@@@+.+@@@@@....
    0x03, 0xff, 0x47, 0xff, 0xff, 0xff, 0x87, 0xff, 0x00,  //...@@@@@+.+@@@@@@@@@@@@@%.+@@@@@...
    0x1f, 0xfd, 0x1f, 0xff, 0xff, 0xff, 0xe0, 0xff, 0xd0,  //.+@@@@@..+@@@@@@@@@@@@@@@%..@@@@@+.
    0x7f, 0xf0, 0xbf, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0xf8,  //+@@@@@..%@@@@@@@@@@@@@@@@@@..@@@@@+
    0xff, 0x83, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0b, 0xfc,  //@@@@%..@@@@@@@@@@@@@@@@@@@@@..%@@@@
    0x3e, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0xf0,  //.@@%..@@@@@@@@@@@@@@@@@@@@@@@+.+@@.
    0x04, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x40,  //..+..%@@@@@@@@@@@@@@@@@@@@@@@@..+..
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x00, 0x2f, 0xff, 0xfe, 0xaa, 0xff, 0xff, 0xf0, 0x00,  //.....%@@@@@@@@@%%%%%@@@@@@@@@@.....
    0x00, 0x2f, 0xff, 0xfc, 0x00, 0xbf, 0xff, 0xf0, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x2f, 0xff, 0xfc, 0x00, 0xbf, 0xff, 0xf0, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x2f, 0xff, 0xfc, 0x00, 0xbf, 0xff, 0xf0, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x2f, 0xff, 0xfc, 0x00, 0xbf, 0xff, 0xf0, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x2f, 0xff, 0xfc, 0x00, 0xbf, 0xff, 0xf0, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x2f, 0xff, 0xfc, 0x00, 0xbf, 0xff, 0xf0, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x2f, 0xff, 0xfc, 0x00, 0xbf, 0xff, 0xf0, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x1f, 0xff, 0xfc, 0x00, 0xbf, 0xff, 0xe0, 0x00,  //.....+@@@@@@@@@.....%@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+f019 () , Width: 36 */
    0x00, 0x00, 0x00, 0x01, 0x55, 0x40, 0x00, 0x00, 0x00,  //...............++++++...............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..............@@@@@@@@..............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //.......%@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //.......+@@@@@@@@@@@@@@@@@@@@%.......
    0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00,  //........+@@@@@@@@@@@@@@@@@@%........
    0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //.........+@@@@@@@@@@@@@@@@%.........
    0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00,  //..........+@@@@@@@@@@@@@@%..........
    0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00,  //...........+@@@@@@@@@@@@%...........
    0x00, 0x00, 0x00, 0x7f, 0xff, 0xfe, 0x00, 0x00, 0x00,  //............+@@@@@@@@@@%............
    0x00, 0x00, 0x00, 0x1f, 0xff, 0xf8, 0x00, 0x00, 0x00,  //.............+@@@@@@@@%.............
    0x00, 0x00, 0x00, 0x07, 0xff, 0xe0, 0x00, 0x00, 0x00,  //..............+@@@@@@%..............
    0x00, 0x00, 0x00, 0x01, 0xff, 0x80, 0x00, 0x00, 0x00,  //...............+@@@@%...............
    0x7f, 0xff, 0xff, 0x80, 0x7e, 0x01, 0xff, 0xff, 0xfd,  //.@@@@@@@@@@@%...+@@%...+@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xe0, 0x00, 0x0b, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@%........%@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfc, 0x00, 0x2f, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@......%@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0x41, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@+..+@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@%@@@@%%@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xfc, 0x3f,  //@@@@@@@@@@@@@@@@@@@@@@@@@...@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0xfc, 0x3f,  //@@@@@@@@@@@@@@@@@@@@@@@@@+.+@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................


    /*Unicode: U+f01c () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,  //......%@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0xbf, 0xc0, 0x00, 0x00, 0x00, 0xbf, 0xc0, 0x00,  //....%@@@@...............%@@@@.....
    0x00, 0xff, 0x40, 0x00, 0x00, 0x00, 0x3f, 0xe0, 0x00,  //....@@@@+................@@@@%....
    0x02, 0xff, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xf0, 0x00,  //...%@@@@.................%@@@@....
    0x03, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf4, 0x00,  //...@@@@%..................@@@@+...
    0x07, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfc, 0x00,  //..+@@@@...................@@@@@...
    0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x07, 0xfc, 0x00,  //..@@@@@...................+@@@@...
    0x0f, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x03, 0xfe, 0x00,  //..@@@@+....................@@@@%..
    0x2f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0x00,  //.%@@@@.....................+@@@@..
    0x3f, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x80,  //.@@@@+......................@@@@%.
    0x7f, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xc0,  //+@@@@.......................%@@@@.
    0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc0,  //@@@@%........................@@@@.
    0xff, 0xaa, 0xa8, 0x00, 0x00, 0x06, 0xaa, 0xbf, 0xd0,  //@@@@%%%%%%%...........+%%%%%%@@@@+
    0xff, 0xff, 0xfe, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@%..........@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x2f, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@.........%@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0x80, 0x00, 0x3f, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@%........@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xd5, 0x55, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@+++++++@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f021 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x01, 0x54, 0x00, 0x00, 0x00, 0x00,  //...............++++...............
    0x00, 0x00, 0x02, 0xff, 0xff, 0xe4, 0x00, 0x00, 0x00,  //...........%@@@@@@@@@%+...........
    0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0x40, 0x03, 0xc0,  //.........%@@@@@@@@@@@@@@+......@@.
    0x00, 0x02, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0f, 0xe0,  //.......%@@@@@@@@@@@@@@@@@@....@@@%
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x3f, 0xe0,  //......@@@@@@@@@@@@@@@@@@@@@+.@@@@%
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //.....@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0xff, 0xff, 0xe5, 0x06, 0xff, 0xff, 0xff, 0xe0,  //....@@@@@@@@@%+...+%@@@@@@@@@@@@@%
    0x02, 0xff, 0xfe, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xe0,  //...%@@@@@@@%..........%@@@@@@@@@@%
    0x07, 0xff, 0xf0, 0x00, 0x00, 0x01, 0xff, 0xff, 0xe0,  //..+@@@@@@@.............+@@@@@@@@@%
    0x0f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0xff, 0xff, 0xe0,  //..@@@@@@@...............@@@@@@@@@%
    0x1f, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xe0,  //.+@@@@@@...............@@@@@@@@@@%
    0x3f, 0xfd, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xe0,  //.@@@@@@+..............@@@@@@@@@@@%
    0x3f, 0xfc, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xe0,  //.@@@@@@..............@@@@@@@@@@@@%
    0xbf, 0xf4, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xd0,  //%@@@@@+..............@@@@@@@@@@@@+
    0x2a, 0x90, 0x00, 0x00, 0x00, 0x0a, 0xaa, 0xaa, 0x40,  //.%%%%+................%%%%%%%%%%+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x7f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0xff, 0x80,  //+@@@@@@@@@@@...............+@@@@%.
    0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x03, 0xff, 0xc0,  //@@@@@@@@@@@@+..............@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x07, 0xff, 0x40,  //@@@@@@@@@@@@..............+@@@@@+.
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@@@@@@@@@...............@@@@@@..
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x2f, 0xfe, 0x00,  //@@@@@@@@@@...............%@@@@@%..
    0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0xbf, 0xfc, 0x00,  //@@@@@@@@@+..............%@@@@@@...
    0xff, 0xff, 0xf8, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00,  //@@@@@@@@@@%............@@@@@@@%...
    0xff, 0xff, 0xff, 0x40, 0x00, 0x2f, 0xff, 0xf0, 0x00,  //@@@@@@@@@@@@+........%@@@@@@@@....
    0xff, 0xff, 0xff, 0xfe, 0xab, 0xff, 0xff, 0xc0, 0x00,  //@@@@@@@@@@@@@@@%%%%@@@@@@@@@@.....
    0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@@@%@@@@@@@@@@@@@@@@@@@@@@......
    0xff, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,  //@@@@..+@@@@@@@@@@@@@@@@@@@@.......
    0xfc, 0x00, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //@@@.....@@@@@@@@@@@@@@@@@+........
    0x20, 0x00, 0x1f, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00,  //.%.......+@@@@@@@@@@@@@%..........
    0x00, 0x00, 0x00, 0x6f, 0xff, 0x90, 0x00, 0x00, 0x00,  //............+%@@@@@@%+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f026 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x0f, 0x40,  //..............@@+
    0x00, 0x00, 0x00, 0x3f, 0x80,  //.............@@@%
    0x00, 0x00, 0x00, 0xff, 0x80,  //............@@@@%
    0x00, 0x00, 0x03, 0xff, 0x80,  //...........@@@@@%
    0x00, 0x00, 0x0f, 0xff, 0x80,  //..........@@@@@@%
    0x00, 0x00, 0x3f, 0xff, 0x80,  //.........@@@@@@@%
    0x00, 0x00, 0xff, 0xff, 0x80,  //........@@@@@@@@%
    0x15, 0x57, 0xff, 0xff, 0x80,  //.++++++@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0x6a, 0xab, 0xff, 0xff, 0x80,  //+%%%%%%@@@@@@@@@%
    0x00, 0x00, 0xff, 0xff, 0x80,  //........@@@@@@@@%
    0x00, 0x00, 0x3f, 0xff, 0x80,  //.........@@@@@@@%
    0x00, 0x00, 0x0f, 0xff, 0x80,  //..........@@@@@@%
    0x00, 0x00, 0x03, 0xff, 0x80,  //...........@@@@@%
    0x00, 0x00, 0x00, 0xff, 0x80,  //............@@@@%
    0x00, 0x00, 0x00, 0x3f, 0x80,  //.............@@@%
    0x00, 0x00, 0x00, 0x0f, 0x80,  //..............@@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f027 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x0f, 0x40, 0x00, 0x00,  //..............@@+........
    0x00, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x00,  //.............@@@%........
    0x00, 0x00, 0x00, 0xff, 0x80, 0x00, 0x00,  //............@@@@%........
    0x00, 0x00, 0x03, 0xff, 0x80, 0x00, 0x00,  //...........@@@@@%........
    0x00, 0x00, 0x0f, 0xff, 0x80, 0x00, 0x00,  //..........@@@@@@%........
    0x00, 0x00, 0x3f, 0xff, 0x80, 0x00, 0x00,  //.........@@@@@@@%........
    0x00, 0x00, 0xff, 0xff, 0x80, 0x00, 0x00,  //........@@@@@@@@%........
    0x15, 0x57, 0xff, 0xff, 0x80, 0x00, 0x00,  //.++++++@@@@@@@@@%........
    0xff, 0xff, 0xff, 0xff, 0x80, 0xf8, 0x00,  //@@@@@@@@@@@@@@@@%...@@%..
    0xff, 0xff, 0xff, 0xff, 0x80, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@%...@@@%.
    0xff, 0xff, 0xff, 0xff, 0x80, 0x7f, 0x40,  //@@@@@@@@@@@@@@@@%...+@@@+
    0xff, 0xff, 0xff, 0xff, 0x80, 0x1f, 0x80,  //@@@@@@@@@@@@@@@@%....+@@%
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0f, 0xc0,  //@@@@@@@@@@@@@@@@%.....@@@
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0f, 0xc0,  //@@@@@@@@@@@@@@@@%.....@@@
    0xff, 0xff, 0xff, 0xff, 0x80, 0x1f, 0xc0,  //@@@@@@@@@@@@@@@@%....+@@@
    0xff, 0xff, 0xff, 0xff, 0x80, 0x7f, 0x40,  //@@@@@@@@@@@@@@@@%...+@@@+
    0xff, 0xff, 0xff, 0xff, 0x80, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@%...@@@%.
    0xff, 0xff, 0xff, 0xff, 0x80, 0xf8, 0x00,  //@@@@@@@@@@@@@@@@%...@@%..
    0x6a, 0xab, 0xff, 0xff, 0x80, 0x00, 0x00,  //+%%%%%%@@@@@@@@@%........
    0x00, 0x00, 0xff, 0xff, 0x80, 0x00, 0x00,  //........@@@@@@@@%........
    0x00, 0x00, 0x3f, 0xff, 0x80, 0x00, 0x00,  //.........@@@@@@@%........
    0x00, 0x00, 0x0f, 0xff, 0x80, 0x00, 0x00,  //..........@@@@@@%........
    0x00, 0x00, 0x03, 0xff, 0x80, 0x00, 0x00,  //...........@@@@@%........
    0x00, 0x00, 0x00, 0xff, 0x80, 0x00, 0x00,  //............@@@@%........
    0x00, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x00,  //.............@@@%........
    0x00, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00,  //..............@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f028 () , Width: 36 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0x00, 0x00,  //........................%@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x40, 0x00,  //........................@@@@+.......
    0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x7f, 0xf0, 0x00,  //..............+%........+@@@@%......
    0x00, 0x00, 0x00, 0x2f, 0x80, 0x00, 0x0b, 0xfc, 0x00,  //.............%@@%.........%@@@@.....
    0x00, 0x00, 0x00, 0xbf, 0x80, 0x00, 0x00, 0xff, 0x00,  //............%@@@%...........@@@@....
    0x00, 0x00, 0x02, 0xff, 0x80, 0x0b, 0x40, 0x3f, 0x80,  //...........+@@@@%.....%@+....@@@%...
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x0f, 0xf0, 0x0f, 0xd0,  //..........+@@@@@%.....@@@@....@@@+..
    0x00, 0x00, 0x2f, 0xff, 0x80, 0x0b, 0xfd, 0x07, 0xf0,  //.........+@@@@@@%.....%@@@@+..+@@@..
    0x00, 0x00, 0xbf, 0xff, 0x80, 0x00, 0xff, 0x42, 0xf4,  //........+@@@@@@@%.......@@@@+..%@@+.
    0x00, 0x02, 0xff, 0xff, 0x80, 0x00, 0x2f, 0xc0, 0xfc,  //.......+@@@@@@@@%........%@@@...@@@.
    0xbf, 0xff, 0xff, 0xff, 0x80, 0xa0, 0x0f, 0xe0, 0xfc,  //%@@@@@@@@@@@@@@@%...%%....@@@%..%@@.
    0xff, 0xff, 0xff, 0xff, 0x81, 0xfc, 0x03, 0xf0, 0x7d,  //@@@@@@@@@@@@@@@@%..+@@@....@@@..+@@+
    0xff, 0xff, 0xff, 0xff, 0x80, 0xff, 0x02, 0xf4, 0x3e,  //@@@@@@@@@@@@@@@@%...@@@@...%@@+..@@%
    0xff, 0xff, 0xff, 0xff, 0x80, 0x2f, 0x81, 0xf8, 0x3f,  //@@@@@@@@@@@@@@@@%....%@@%..+@@%..@@@
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0f, 0xc0, 0xfc, 0x3f,  //@@@@@@@@@@@@@@@@%.....@@@...@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0f, 0xc0, 0xfc, 0x3f,  //@@@@@@@@@@@@@@@@%.....@@@...@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0f, 0xc0, 0xfc, 0x3f,  //@@@@@@@@@@@@@@@@%.....@@@...@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0x80, 0x3f, 0x81, 0xf8, 0x3f,  //@@@@@@@@@@@@@@@@%....@@@%..+@@%..@@@
    0xff, 0xff, 0xff, 0xff, 0x80, 0xff, 0x02, 0xf4, 0x3e,  //@@@@@@@@@@@@@@@@%...@@@@...%@@+..@@%
    0xff, 0xff, 0xff, 0xff, 0x81, 0xfc, 0x03, 0xf0, 0x7d,  //@@@@@@@@@@@@@@@@%..+@@@....@@@..+@@+
    0xbf, 0xff, 0xff, 0xff, 0x80, 0xa0, 0x0f, 0xe0, 0xfc,  //%@@@@@@@@@@@@@@@%...%%....@@@%..@@@.
    0x00, 0x01, 0xff, 0xff, 0x80, 0x00, 0x2f, 0xc0, 0xfc,  //.......+@@@@@@@@%........%@@@...@@@.
    0x00, 0x00, 0x7f, 0xff, 0x80, 0x01, 0xff, 0x02, 0xf4,  //........+@@@@@@@%......+@@@@...%@@+.
    0x00, 0x00, 0x1f, 0xff, 0x80, 0x0b, 0xfd, 0x07, 0xf0,  //.........+@@@@@@%.....%@@@@+..+@@@..
    0x00, 0x00, 0x07, 0xff, 0x80, 0x0f, 0xf0, 0x0f, 0xd0,  //..........+@@@@@%.....@@@@....@@@+..
    0x00, 0x00, 0x01, 0xff, 0x80, 0x0b, 0x40, 0x3f, 0x80,  //...........+@@@@%.....%@+....@@@%...
    0x00, 0x00, 0x00, 0x7f, 0x80, 0x00, 0x01, 0xff, 0x00,  //............+@@@%...........@@@@....
    0x00, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x0b, 0xfc, 0x00,  //.............+@@%.........%@@@@.....
    0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x7f, 0xe0, 0x00,  //..............+%........+@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x40, 0x00,  //........................@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00,  //........................+@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................


    /*Unicode: U+f03e () , Width: 42 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@....................................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@....................................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@....................................@@@
    0xfc, 0x01, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@....+@@@%...........................@@@
    0xfc, 0x07, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@...+@@@@@@..........................@@@
    0xfc, 0x0f, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@...@@@@@@@%.........................@@@
    0xfc, 0x1f, 0xff, 0xf0, 0x00, 0x00, 0x01, 0x00, 0x00, 0x03, 0xf0,  //@@@..+@@@@@@@@.............+...........@@@
    0xfc, 0x1f, 0xff, 0xf0, 0x00, 0x00, 0x0f, 0x40, 0x00, 0x03, 0xf0,  //@@@..+@@@@@@@@............@@+..........@@@
    0xfc, 0x0f, 0xff, 0xe0, 0x00, 0x00, 0x3f, 0xd0, 0x00, 0x03, 0xf0,  //@@@...@@@@@@@%...........@@@@+.........@@@
    0xfc, 0x0b, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xf4, 0x00, 0x03, 0xf0,  //@@@...%@@@@@@...........@@@@@@+........@@@
    0xfc, 0x02, 0xff, 0x40, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x03, 0xf0,  //@@@....%@@@@+..........@@@@@@@@+.......@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x40, 0x03, 0xf0,  //@@@...................@@@@@@@@@@+......@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xd0, 0x03, 0xf0,  //@@@..................@@@@@@@@@@@@+.....@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xf4, 0x03, 0xf0,  //@@@.................@@@@@@@@@@@@@@+....@@@
    0xfc, 0x00, 0x00, 0x80, 0x03, 0xff, 0xff, 0xff, 0xfd, 0x03, 0xf0,  //@@@.........%......@@@@@@@@@@@@@@@@+...@@@
    0xfc, 0x00, 0x03, 0xf0, 0x0f, 0xff, 0xff, 0xff, 0xff, 0x03, 0xf0,  //@@@........@@@....@@@@@@@@@@@@@@@@@@...@@@
    0xfc, 0x00, 0x0f, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0x03, 0xf0,  //@@@.......@@@@@..@@@@@@@@@@@@@@@@@@@...@@@
    0xfc, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0xf0,  //@@@......@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xfc, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0xf0,  //@@@.....@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xfc, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0xf0,  //@@@....@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0xf0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0xf0,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0xf0,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0xf0,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0xf0,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@....................................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@....................................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@....................................@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................


    /*Unicode: U+f040 () , Width: 33 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xfc, 0x00, 0x00,  //.......................%@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x00, 0x00,  //......................%@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0xc0, 0x00,  //.....................%@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xf0, 0x00,  //....................%@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xfc, 0x00,  //....................@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0x00,  //.....................@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x2c, 0x0f, 0xff, 0xff, 0x80,  //.................%@...@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0xbf, 0x03, 0xff, 0xff, 0xc0,  //................%@@@...@@@@@@@@@@
    0x00, 0x00, 0x00, 0x02, 0xff, 0xc0, 0xff, 0xff, 0xc0,  //...............%@@@@@...@@@@@@@@@
    0x00, 0x00, 0x00, 0x0b, 0xfb, 0xf0, 0x3f, 0xff, 0x40,  //..............%@@@%@@@...@@@@@@@+
    0x00, 0x00, 0x00, 0x2f, 0xd3, 0xfc, 0x0f, 0xfd, 0x00,  //.............%@@@+.@@@@...@@@@@+.
    0x00, 0x00, 0x00, 0xbf, 0x4f, 0xff, 0x03, 0xf4, 0x00,  //............%@@@+.@@@@@@...@@@+..
    0x00, 0x00, 0x02, 0xfd, 0x3f, 0xff, 0xc0, 0xd0, 0x00,  //...........%@@@+.@@@@@@@@...@+...
    0x00, 0x00, 0x0b, 0xf4, 0xff, 0xff, 0xf0, 0x00, 0x00,  //..........%@@@+.@@@@@@@@@@.......
    0x00, 0x00, 0x2f, 0xd3, 0xff, 0xff, 0xfc, 0x00, 0x00,  //.........%@@@+.@@@@@@@@@@@@......
    0x00, 0x00, 0xbf, 0x4f, 0xff, 0xff, 0xf4, 0x00, 0x00,  //........%@@@+.@@@@@@@@@@@@+......
    0x00, 0x02, 0xfd, 0x3f, 0xff, 0xff, 0xd0, 0x00, 0x00,  //.......%@@@+.@@@@@@@@@@@@+.......
    0x00, 0x0b, 0xf4, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00,  //......%@@@+.@@@@@@@@@@@@+........
    0x00, 0x2f, 0xd3, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00,  //.....%@@@+.@@@@@@@@@@@@+.........
    0x00, 0xbf, 0x4f, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00,  //....%@@@+.@@@@@@@@@@@@+..........
    0x02, 0xfd, 0x3f, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00,  //...%@@@+.@@@@@@@@@@@@+...........
    0x0b, 0xf8, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00,  //..%@@@%.@@@@@@@@@@@@+............
    0x2f, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@+.............
    0xbf, 0x6f, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00,  //%@@@+%@@@@@@@@@@@@+..............
    0xfd, 0x0b, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00,  //@@@+..%@@@@@@@@@@+...............
    0xfc, 0x02, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //@@@....%@@@@@@@@+................
    0xfc, 0x00, 0xbf, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....%@@@@@@+.................
    0xff, 0xd0, 0x2f, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@+...%@@@@+..................
    0xff, 0xe0, 0x2f, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@%...%@@@+...................
    0xff, 0xe0, 0xbf, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@%..%@@@+....................
    0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@+.....................
    0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@+......................
    0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@+.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................


    /*Unicode: U+f048 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x15, 0x40, 0x00, 0x00, 0x00, 0x00,  //.++++..................
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x74,  //@@@@@+..............+@+
    0xff, 0xe0, 0x00, 0x00, 0x01, 0xf4,  //@@@@@%.............+@@+
    0xff, 0xe0, 0x00, 0x00, 0x07, 0xf4,  //@@@@@%............+@@@+
    0xff, 0xe0, 0x00, 0x00, 0x1f, 0xf4,  //@@@@@%...........+@@@@+
    0xff, 0xe0, 0x00, 0x00, 0x7f, 0xf4,  //@@@@@%..........+@@@@@+
    0xff, 0xe0, 0x00, 0x01, 0xff, 0xf4,  //@@@@@%.........+@@@@@@+
    0xff, 0xe0, 0x00, 0x07, 0xff, 0xf4,  //@@@@@%........+@@@@@@@+
    0xff, 0xe0, 0x00, 0x1f, 0xff, 0xf4,  //@@@@@%.......+@@@@@@@@+
    0xff, 0xe0, 0x00, 0x7f, 0xff, 0xf4,  //@@@@@%......+@@@@@@@@@+
    0xff, 0xe0, 0x01, 0xff, 0xff, 0xf4,  //@@@@@%.....+@@@@@@@@@@+
    0xff, 0xe0, 0x07, 0xff, 0xff, 0xf4,  //@@@@@%....+@@@@@@@@@@@+
    0xff, 0xe0, 0x1f, 0xff, 0xff, 0xf4,  //@@@@@%...+@@@@@@@@@@@@+
    0xff, 0xe0, 0x7f, 0xff, 0xff, 0xf4,  //@@@@@%..+@@@@@@@@@@@@@+
    0xff, 0xe1, 0xff, 0xff, 0xff, 0xf4,  //@@@@@%.+@@@@@@@@@@@@@@+
    0xff, 0xe7, 0xff, 0xff, 0xff, 0xf4,  //@@@@@%+@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xef, 0xff, 0xff, 0xff, 0xf4,  //@@@@@%@@@@@@@@@@@@@@@@+
    0xff, 0xe3, 0xff, 0xff, 0xff, 0xf4,  //@@@@@%.@@@@@@@@@@@@@@@+
    0xff, 0xe0, 0xff, 0xff, 0xff, 0xf4,  //@@@@@%..@@@@@@@@@@@@@@+
    0xff, 0xe0, 0x3f, 0xff, 0xff, 0xf4,  //@@@@@%...@@@@@@@@@@@@@+
    0xff, 0xe0, 0x0f, 0xff, 0xff, 0xf4,  //@@@@@%....@@@@@@@@@@@@+
    0xff, 0xe0, 0x03, 0xff, 0xff, 0xf4,  //@@@@@%.....@@@@@@@@@@@+
    0xff, 0xe0, 0x00, 0xff, 0xff, 0xf4,  //@@@@@%......@@@@@@@@@@+
    0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf4,  //@@@@@%.......@@@@@@@@@+
    0xff, 0xe0, 0x00, 0x0f, 0xff, 0xf4,  //@@@@@%........@@@@@@@@+
    0xff, 0xe0, 0x00, 0x03, 0xff, 0xf4,  //@@@@@%.........@@@@@@@+
    0xff, 0xe0, 0x00, 0x00, 0xff, 0xf4,  //@@@@@%..........@@@@@@+
    0xff, 0xe0, 0x00, 0x00, 0x3f, 0xf4,  //@@@@@%...........@@@@@+
    0xff, 0xe0, 0x00, 0x00, 0x0f, 0xf4,  //@@@@@%............@@@@+
    0xff, 0xe0, 0x00, 0x00, 0x03, 0xf4,  //@@@@@%.............@@@+
    0xff, 0xe0, 0x00, 0x00, 0x00, 0xf4,  //@@@@@%..............@@+
    0xbf, 0xc0, 0x00, 0x00, 0x00, 0x30,  //%@@@@................@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f04b () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%+.............................
    0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+...........................
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@+.........................
    0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%........................
    0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@%......................
    0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%....................
    0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@+..................
    0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@+................
    0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@%...............
    0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@%.............
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@+.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@+.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@%......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@+.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@%.........
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@%...........
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@.............
    0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@+..............
    0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@+................
    0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@%..................
    0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%....................
    0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@......................
    0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@+.......................
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@+.........................
    0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%...........................
    0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@%.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f04c () , Width: 33 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x15, 0x55, 0x55, 0x40, 0x00, 0x55, 0x55, 0x55, 0x00,  //.++++++++++++.......++++++++++++.
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xbf, 0xff, 0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@+.....+@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................


    /*Unicode: U+f04d () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x15, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x40,  //.++++++++++++++++++++++++++++++++.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f051 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x05, 0x50,  //..................++++.
    0xb0, 0x00, 0x00, 0x00, 0x3f, 0xf4,  //%@...............@@@@@+
    0xbc, 0x00, 0x00, 0x00, 0x3f, 0xf8,  //%@@..............@@@@@%
    0xbf, 0x00, 0x00, 0x00, 0x3f, 0xf8,  //%@@@.............@@@@@%
    0xbf, 0xc0, 0x00, 0x00, 0x3f, 0xf8,  //%@@@@............@@@@@%
    0xbf, 0xf0, 0x00, 0x00, 0x3f, 0xf8,  //%@@@@@...........@@@@@%
    0xbf, 0xfc, 0x00, 0x00, 0x3f, 0xf8,  //%@@@@@@..........@@@@@%
    0xbf, 0xff, 0x00, 0x00, 0x3f, 0xf8,  //%@@@@@@@.........@@@@@%
    0xbf, 0xff, 0xc0, 0x00, 0x3f, 0xf8,  //%@@@@@@@@........@@@@@%
    0xbf, 0xff, 0xf0, 0x00, 0x3f, 0xf8,  //%@@@@@@@@@.......@@@@@%
    0xbf, 0xff, 0xfc, 0x00, 0x3f, 0xf8,  //%@@@@@@@@@@......@@@@@%
    0xbf, 0xff, 0xff, 0x00, 0x3f, 0xf8,  //%@@@@@@@@@@@.....@@@@@%
    0xbf, 0xff, 0xff, 0xc0, 0x3f, 0xf8,  //%@@@@@@@@@@@@....@@@@@%
    0xbf, 0xff, 0xff, 0xf0, 0x3f, 0xf8,  //%@@@@@@@@@@@@@...@@@@@%
    0xbf, 0xff, 0xff, 0xfc, 0x3f, 0xf8,  //%@@@@@@@@@@@@@@..@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0x3f, 0xf8,  //%@@@@@@@@@@@@@@@.@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xf8,  //%@@@@@@@@@@@@@@@@@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xf8,  //%@@@@@@@@@@@@@@@@@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0x7f, 0xf8,  //%@@@@@@@@@@@@@@@+@@@@@%
    0xbf, 0xff, 0xff, 0xfd, 0x3f, 0xf8,  //%@@@@@@@@@@@@@@+.@@@@@%
    0xbf, 0xff, 0xff, 0xf4, 0x3f, 0xf8,  //%@@@@@@@@@@@@@+..@@@@@%
    0xbf, 0xff, 0xff, 0xd0, 0x3f, 0xf8,  //%@@@@@@@@@@@@+...@@@@@%
    0xbf, 0xff, 0xff, 0x40, 0x3f, 0xf8,  //%@@@@@@@@@@@+....@@@@@%
    0xbf, 0xff, 0xfd, 0x00, 0x3f, 0xf8,  //%@@@@@@@@@@+.....@@@@@%
    0xbf, 0xff, 0xf4, 0x00, 0x3f, 0xf8,  //%@@@@@@@@@+......@@@@@%
    0xbf, 0xff, 0xd0, 0x00, 0x3f, 0xf8,  //%@@@@@@@@+.......@@@@@%
    0xbf, 0xff, 0x40, 0x00, 0x3f, 0xf8,  //%@@@@@@@+........@@@@@%
    0xbf, 0xfd, 0x00, 0x00, 0x3f, 0xf8,  //%@@@@@@+.........@@@@@%
    0xbf, 0xf4, 0x00, 0x00, 0x3f, 0xf8,  //%@@@@@+..........@@@@@%
    0xbf, 0xd0, 0x00, 0x00, 0x3f, 0xf8,  //%@@@@+...........@@@@@%
    0xbf, 0x40, 0x00, 0x00, 0x3f, 0xf8,  //%@@@+............@@@@@%
    0xbd, 0x00, 0x00, 0x00, 0x3f, 0xf8,  //%@@+.............@@@@@%
    0xb4, 0x00, 0x00, 0x00, 0x3f, 0xf8,  //%@+..............@@@@@%
    0x90, 0x00, 0x00, 0x00, 0x2f, 0xf0,  //%+...............%@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f052 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x01, 0xe0, 0x00, 0x00, 0x00, 0x00,  //...............+@%................
    0x00, 0x00, 0x00, 0x07, 0xfc, 0x00, 0x00, 0x00, 0x00,  //..............+@@@@...............
    0x00, 0x00, 0x00, 0x1f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@@..............
    0x00, 0x00, 0x00, 0x7f, 0xff, 0xc0, 0x00, 0x00, 0x00,  //............+@@@@@@@@.............
    0x00, 0x00, 0x01, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,  //...........+@@@@@@@@@@............
    0x00, 0x00, 0x07, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00,  //..........+@@@@@@@@@@@@...........
    0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.........+@@@@@@@@@@@@@@..........
    0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00,  //........+@@@@@@@@@@@@@@@@.........
    0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //.......+@@@@@@@@@@@@@@@@@@........
    0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //....+@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //...+@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x15, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x00,  //.+++++++++++++++++++++++++++++++..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f053 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //.................@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00,  //................@@@@...
    0x00, 0x00, 0x00, 0x03, 0xff, 0xc0,  //...............@@@@@@..
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0,  //..............@@@@@@@@.
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xf8,  //.............@@@@@@@@@%
    0x00, 0x00, 0x00, 0xff, 0xff, 0xf8,  //............@@@@@@@@@@%
    0x00, 0x00, 0x03, 0xff, 0xff, 0xf0,  //...........@@@@@@@@@@@.
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xc0,  //..........@@@@@@@@@@@..
    0x00, 0x00, 0x3f, 0xff, 0xff, 0x00,  //.........@@@@@@@@@@@...
    0x00, 0x00, 0xff, 0xff, 0xfc, 0x00,  //........@@@@@@@@@@@....
    0x00, 0x03, 0xff, 0xff, 0xf0, 0x00,  //.......@@@@@@@@@@@.....
    0x00, 0x0f, 0xff, 0xff, 0xc0, 0x00,  //......@@@@@@@@@@@......
    0x00, 0x3f, 0xff, 0xff, 0x00, 0x00,  //.....@@@@@@@@@@@.......
    0x00, 0xff, 0xff, 0xfc, 0x00, 0x00,  //....@@@@@@@@@@@........
    0x03, 0xff, 0xff, 0xf0, 0x00, 0x00,  //...@@@@@@@@@@@.........
    0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00,  //..@@@@@@@@@@@..........
    0x3f, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@...........
    0xbf, 0xff, 0xfc, 0x00, 0x00, 0x00,  //%@@@@@@@@@@............
    0x3f, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@...........
    0x1f, 0xff, 0xff, 0xc0, 0x00, 0x00,  //.+@@@@@@@@@@@..........
    0x07, 0xff, 0xff, 0xf0, 0x00, 0x00,  //..+@@@@@@@@@@@.........
    0x01, 0xff, 0xff, 0xfc, 0x00, 0x00,  //...+@@@@@@@@@@@........
    0x00, 0x7f, 0xff, 0xff, 0x00, 0x00,  //....+@@@@@@@@@@@.......
    0x00, 0x1f, 0xff, 0xff, 0xc0, 0x00,  //.....+@@@@@@@@@@@......
    0x00, 0x07, 0xff, 0xff, 0xf0, 0x00,  //......+@@@@@@@@@@@.....
    0x00, 0x01, 0xff, 0xff, 0xfc, 0x00,  //.......+@@@@@@@@@@@....
    0x00, 0x00, 0x7f, 0xff, 0xff, 0x00,  //........+@@@@@@@@@@@...
    0x00, 0x00, 0x1f, 0xff, 0xff, 0xc0,  //.........+@@@@@@@@@@@..
    0x00, 0x00, 0x07, 0xff, 0xff, 0xf0,  //..........+@@@@@@@@@@@.
    0x00, 0x00, 0x01, 0xff, 0xff, 0xf8,  //...........+@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x7f, 0xff, 0xfc,  //............+@@@@@@@@@@
    0x00, 0x00, 0x00, 0x1f, 0xff, 0xf0,  //.............+@@@@@@@@.
    0x00, 0x00, 0x00, 0x07, 0xff, 0xc0,  //..............+@@@@@@..
    0x00, 0x00, 0x00, 0x01, 0xff, 0x00,  //...............+@@@@...
    0x00, 0x00, 0x00, 0x00, 0x7c, 0x00,  //................+@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f054 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@.................
    0x03, 0xfc, 0x00, 0x00, 0x00, 0x00,  //...@@@@................
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@...............
    0x3f, 0xff, 0xc0, 0x00, 0x00, 0x00,  //.@@@@@@@@..............
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,  //@@@@@@@@@@.............
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x00,  //@@@@@@@@@@@............
    0x3f, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@...........
    0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00,  //..@@@@@@@@@@@..........
    0x03, 0xff, 0xff, 0xf0, 0x00, 0x00,  //...@@@@@@@@@@@.........
    0x00, 0xff, 0xff, 0xfc, 0x00, 0x00,  //....@@@@@@@@@@@........
    0x00, 0x3f, 0xff, 0xff, 0x00, 0x00,  //.....@@@@@@@@@@@.......
    0x00, 0x0f, 0xff, 0xff, 0xc0, 0x00,  //......@@@@@@@@@@@......
    0x00, 0x03, 0xff, 0xff, 0xf0, 0x00,  //.......@@@@@@@@@@@.....
    0x00, 0x00, 0xff, 0xff, 0xfc, 0x00,  //........@@@@@@@@@@@....
    0x00, 0x00, 0x3f, 0xff, 0xff, 0x00,  //.........@@@@@@@@@@@...
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xc0,  //..........@@@@@@@@@@@..
    0x00, 0x00, 0x03, 0xff, 0xff, 0xf0,  //...........@@@@@@@@@@@.
    0x00, 0x00, 0x01, 0xff, 0xff, 0xf4,  //...........+@@@@@@@@@@+
    0x00, 0x00, 0x03, 0xff, 0xff, 0xf0,  //...........@@@@@@@@@@@.
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xc0,  //..........@@@@@@@@@@@..
    0x00, 0x00, 0x3f, 0xff, 0xff, 0x00,  //.........@@@@@@@@@@@...
    0x00, 0x00, 0xff, 0xff, 0xfc, 0x00,  //........@@@@@@@@@@@....
    0x00, 0x03, 0xff, 0xff, 0xf0, 0x00,  //.......@@@@@@@@@@@.....
    0x00, 0x0f, 0xff, 0xff, 0xc0, 0x00,  //......@@@@@@@@@@@......
    0x00, 0x3f, 0xff, 0xff, 0x00, 0x00,  //.....@@@@@@@@@@@.......
    0x00, 0xff, 0xff, 0xfc, 0x00, 0x00,  //....@@@@@@@@@@@........
    0x03, 0xff, 0xff, 0xf0, 0x00, 0x00,  //...@@@@@@@@@@@.........
    0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00,  //..@@@@@@@@@@@..........
    0x3f, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@...........
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x00,  //@@@@@@@@@@@............
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,  //@@@@@@@@@@.............
    0x3f, 0xff, 0xc0, 0x00, 0x00, 0x00,  //.@@@@@@@@..............
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@...............
    0x03, 0xfc, 0x00, 0x00, 0x00, 0x00,  //...@@@@................
    0x00, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f067 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x6a, 0xa4, 0x00, 0x00, 0x00,  //............+%%%%%+............
    0x00, 0x00, 0x02, 0xff, 0xfc, 0x00, 0x00, 0x00,  //...........%@@@@@@@............
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x15, 0x55, 0x57, 0xff, 0xfe, 0x55, 0x55, 0x40,  //.++++++++++@@@@@@@@%+++++++++..
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x02, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........%@@@@@@@+...........
    0x00, 0x00, 0x00, 0xff, 0xf8, 0x00, 0x00, 0x00,  //............@@@@@@%............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f068 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x05, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x40,  //..+++++++++++++++++++++++++++..
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f071 () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xd0, 0x00, 0x00, 0x00, 0x00,  //.................+@@@+.................
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.................@@@@@.................
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xf8, 0x00, 0x00, 0x00, 0x00,  //................%@@@@@%................
    0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,  //................@@@@@@@................
    0x00, 0x00, 0x00, 0x02, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,  //...............%@@@@@@@%...............
    0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...............@@@@@@@@@...............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,  //..............@@@@@@@@@@@..............
    0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00,  //.............+@@@@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,  //.............@@@@@@@@@@@@@.............
    0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00,  //............+@@@@@@@@@@@@@+............
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00,  //............@@@@@@@@@@@@@@@............
    0x00, 0x00, 0x02, 0xff, 0x80, 0x0b, 0xfe, 0x00, 0x00, 0x00,  //...........+@@@@%.....%@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0x40, 0x07, 0xff, 0x00, 0x00, 0x00,  //...........@@@@@+.....+@@@@@...........
    0x00, 0x00, 0x0b, 0xff, 0x40, 0x07, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@+.....+@@@@@%..........
    0x00, 0x00, 0x0f, 0xff, 0x40, 0x07, 0xff, 0xc0, 0x00, 0x00,  //..........@@@@@@+.....+@@@@@@..........
    0x00, 0x00, 0x2f, 0xff, 0x80, 0x0b, 0xff, 0xe0, 0x00, 0x00,  //.........%@@@@@@+.....%@@@@@@%.........
    0x00, 0x00, 0x3f, 0xff, 0x80, 0x0b, 0xff, 0xf0, 0x00, 0x00,  //.........@@@@@@@%.....%@@@@@@@.........
    0x00, 0x00, 0xff, 0xff, 0x80, 0x0b, 0xff, 0xfc, 0x00, 0x00,  //........@@@@@@@@%.....%@@@@@@@@........
    0x00, 0x01, 0xff, 0xff, 0x80, 0x0b, 0xff, 0xfd, 0x00, 0x00,  //.......+@@@@@@@@%.....%@@@@@@@@+.......
    0x00, 0x03, 0xff, 0xff, 0x80, 0x0b, 0xff, 0xff, 0x00, 0x00,  //.......@@@@@@@@@%.....%@@@@@@@@@.......
    0x00, 0x07, 0xff, 0xff, 0x80, 0x0b, 0xff, 0xff, 0x40, 0x00,  //......+@@@@@@@@@%.....%@@@@@@@@@+......
    0x00, 0x0f, 0xff, 0xff, 0xc0, 0x0f, 0xff, 0xff, 0xc0, 0x00,  //......@@@@@@@@@@@.....@@@@@@@@@@@......
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0xff, 0xff, 0xff, 0xc0, 0x0f, 0xff, 0xff, 0xfc, 0x00,  //....@@@@@@@@@@@@@.....@@@@@@@@@@@@@....
    0x02, 0xff, 0xff, 0xff, 0x80, 0x0b, 0xff, 0xff, 0xfe, 0x00,  //...%@@@@@@@@@@@@%.....%@@@@@@@@@@@@%...
    0x07, 0xff, 0xff, 0xff, 0x80, 0x0b, 0xff, 0xff, 0xff, 0x00,  //...@@@@@@@@@@@@@%.....%@@@@@@@@@@@@@...
    0x0f, 0xff, 0xff, 0xff, 0x80, 0x0b, 0xff, 0xff, 0xff, 0xc0,  //..@@@@@@@@@@@@@@%.....%@@@@@@@@@@@@@@..
    0x1f, 0xff, 0xff, 0xff, 0x80, 0x0b, 0xff, 0xff, 0xff, 0xd0,  //.+@@@@@@@@@@@@@@%.....%@@@@@@@@@@@@@@+.
    0x3f, 0xff, 0xff, 0xff, 0xea, 0xaf, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@@@@%%%%%@@@@@@@@@@@@@@@@.
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................


    /*Unicode: U+f074 () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,  //...............................@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xc0, 0x00,  //..............................+@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x00,  //..............................+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xfc, 0x00,  //..............................+@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0x00,  //..............................+@@@@@...
    0xff, 0xff, 0x90, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@%+...........+@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xfd, 0x00, 0x02, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@+.......%@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x40, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@+.....%@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xd0, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@+...%@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xf0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@..%@@@@@@@@@@@@@@@@@@@@+.
    0x55, 0x5b, 0xff, 0xf1, 0xff, 0xfe, 0x95, 0x5b, 0xff, 0x40,  //++++++%@@@@@@@.+@@@@@@@%++++++%@@@@@+..
    0x00, 0x00, 0x7f, 0xe3, 0xff, 0xf0, 0x00, 0x07, 0xfd, 0x00,  //........+@@@@+.@@@@@@@........+@@@@+...
    0x00, 0x00, 0x1f, 0xc7, 0xff, 0xc0, 0x00, 0x07, 0xf4, 0x00,  //.........+@@@.+@@@@@@.........+@@@+....
    0x00, 0x00, 0x0b, 0x8f, 0xff, 0x40, 0x00, 0x07, 0xd0, 0x00,  //..........%@%.@@@@@@+.........+@@+.....
    0x00, 0x00, 0x03, 0x1f, 0xff, 0x00, 0x00, 0x07, 0x40, 0x00,  //...........@.+@@@@@@..........+@+......
    0x00, 0x00, 0x01, 0x3f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+.@@@@@@+...................
    0x00, 0x00, 0x00, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............@@@@@@....................
    0x00, 0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00,  //............%@@@@@+....................
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@@@@.....................
    0x00, 0x00, 0x02, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@@@+.....................
    0x00, 0x00, 0x03, 0xff, 0xc6, 0x00, 0x00, 0x07, 0x40, 0x00,  //...........@@@@@@.+%..........+@+......
    0x00, 0x00, 0x0b, 0xff, 0x8f, 0x40, 0x00, 0x07, 0xd0, 0x00,  //..........%@@@@@%.@@+.........+@@+.....
    0x00, 0x00, 0x1f, 0xff, 0x1f, 0xc0, 0x00, 0x07, 0xf4, 0x00,  //.........+@@@@@@.+@@@.........+@@@+....
    0x00, 0x00, 0x7f, 0xfe, 0x3f, 0xf0, 0x00, 0x07, 0xfd, 0x00,  //........+@@@@@@%.@@@@@........+@@@@+...
    0x15, 0x56, 0xff, 0xfc, 0x7f, 0xfe, 0x55, 0x5b, 0xff, 0x40,  //.++++++%@@@@@@@.+@@@@@@%++++++%@@@@@+..
    0xff, 0xff, 0xff, 0xf4, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@+.%@@@@@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xd0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@+...@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0x80, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@%.....@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfd, 0x00, 0x02, 0xff, 0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@+.......%@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xd0, 0x00, 0x00, 0x2f, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@+...........%@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0x40,  //..............................+@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xfd, 0x00,  //..............................+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xf4, 0x00,  //..............................+@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xd0, 0x00,  //..............................+@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x40, 0x00,  //..............................+@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................


    /*Unicode: U+f077 () , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0xb8, 0x00, 0x00, 0x00, 0x00,  //................+@+................
    0x00, 0x00, 0x00, 0x02, 0xfe, 0x00, 0x00, 0x00, 0x00,  //...............%@@@%...............
    0x00, 0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00, 0x00,  //..............%@@@@@%..............
    0x00, 0x00, 0x00, 0x2f, 0xff, 0xe0, 0x00, 0x00, 0x00,  //.............%@@@@@@@%.............
    0x00, 0x00, 0x00, 0xbf, 0xff, 0xf8, 0x00, 0x00, 0x00,  //............%@@@@@@@@@%............
    0x00, 0x00, 0x02, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00,  //...........%@@@@@@@@@@@%...........
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@@@@@@@@@%..........
    0x00, 0x00, 0x2f, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00,  //.........%@@@@@@@@@@@@@@@%.........
    0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //........%@@@@@@@@@@@@@@@@@%........
    0x00, 0x02, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00,  //.......%@@@@@@@@@@@@@@@@@@@%.......
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //......%@@@@@@@@@@@@@@@@@@@@@%......
    0x00, 0x2f, 0xff, 0xff, 0x8b, 0xff, 0xff, 0xe0, 0x00,  //.....%@@@@@@@@@@%.%@@@@@@@@@@%.....
    0x00, 0xbf, 0xff, 0xfe, 0x02, 0xff, 0xff, 0xf8, 0x00,  //....%@@@@@@@@@@%...%@@@@@@@@@@%....
    0x02, 0xff, 0xff, 0xf8, 0x00, 0xbf, 0xff, 0xfe, 0x00,  //...%@@@@@@@@@@%.....%@@@@@@@@@@%...
    0x0b, 0xff, 0xff, 0xe0, 0x00, 0x2f, 0xff, 0xff, 0x80,  //..%@@@@@@@@@@%.......%@@@@@@@@@@%..
    0x2f, 0xff, 0xff, 0x80, 0x00, 0x0b, 0xff, 0xff, 0xe0,  //.%@@@@@@@@@@%.........%@@@@@@@@@@%.
    0xbf, 0xff, 0xfe, 0x00, 0x00, 0x02, 0xff, 0xff, 0xf8,  //%@@@@@@@@@@%...........%@@@@@@@@@@%
    0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xfc,  //@@@@@@@@@@%.............%@@@@@@@@@@
    0xbf, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x2f, 0xff, 0xf8,  //%@@@@@@@@%...............%@@@@@@@@%
    0x2f, 0xff, 0x80, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xe0,  //.%@@@@@@%.................%@@@@@@%.
    0x0b, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x80,  //..%@@@@%...................%@@@@%..
    0x02, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0x00,  //...%@@%.....................%@@%...
    0x00, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00,  //....++.......................++....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+f078 () , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00,  //....%%.......................%%....
    0x03, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,  //...@@@@.....................@@@@...
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xc0,  //..@@@@@@...................@@@@@@..
    0x3f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0,  //.@@@@@@@@.................@@@@@@@@.
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xfc,  //@@@@@@@@@@...............@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@.............@@@@@@@@@@@
    0x7f, 0xff, 0xff, 0x00, 0x00, 0x03, 0xff, 0xff, 0xf4,  //+@@@@@@@@@@@...........@@@@@@@@@@@+
    0x1f, 0xff, 0xff, 0xc0, 0x00, 0x0f, 0xff, 0xff, 0xd0,  //.+@@@@@@@@@@@.........@@@@@@@@@@@+.
    0x07, 0xff, 0xff, 0xf0, 0x00, 0x3f, 0xff, 0xff, 0x40,  //..+@@@@@@@@@@@.......@@@@@@@@@@@+..
    0x01, 0xff, 0xff, 0xfc, 0x00, 0xff, 0xff, 0xfd, 0x00,  //...+@@@@@@@@@@@.....@@@@@@@@@@@+...
    0x00, 0x7f, 0xff, 0xff, 0x03, 0xff, 0xff, 0xf4, 0x00,  //....+@@@@@@@@@@@...@@@@@@@@@@@+....
    0x00, 0x1f, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@.@@@@@@@@@@@+.....
    0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@@+......
    0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00,  //.......+@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00,  //........+@@@@@@@@@@@@@@@@@+........
    0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //.........+@@@@@@@@@@@@@@@+.........
    0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00,  //..........+@@@@@@@@@@@@@+..........
    0x00, 0x00, 0x01, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...........+@@@@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x7f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //............+@@@@@@@@@+............
    0x00, 0x00, 0x00, 0x1f, 0xff, 0xd0, 0x00, 0x00, 0x00,  //.............+@@@@@@@+.............
    0x00, 0x00, 0x00, 0x07, 0xff, 0x40, 0x00, 0x00, 0x00,  //..............+@@@@@+..............
    0x00, 0x00, 0x00, 0x01, 0xfd, 0x00, 0x00, 0x00, 0x00,  //...............+@@@+...............
    0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00,  //.................%.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+f079 () , Width: 42 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x02, 0xd0, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //.......%@+....@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x0b, 0xf4, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //......%@@@+...%@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x1f, 0xfc, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //.....+@@@@@....%@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x3f, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //.....@@@@@@@....@@@@@@@@@@@@@@@@@@@@......
    0x00, 0xff, 0xff, 0xc0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@@@@@@%....@@@@@@@@@@@@@@@@@@@......
    0x03, 0xff, 0xff, 0xe0, 0x0a, 0xaa, 0xaa, 0xab, 0xff, 0x00, 0x00,  //...@@@@@@@@@@%....%%%%%%%%%%%%%@@@@@......
    0x0b, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x07, 0xff, 0x00, 0x00,  //..%@@@@@@@@@@@+...............+@@@@@......
    0x2f, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x07, 0xff, 0x00, 0x00,  //.%@@@@@@@@@@@@@+..............+@@@@@......
    0x7f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x07, 0xff, 0x00, 0x00,  //+@@@@@@@@@@@@@@@..............+@@@@@......
    0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x07, 0xff, 0x00, 0x00,  //@@@@@@@@@@@@@@@@%.............+@@@@@......
    0xbf, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x07, 0xff, 0x00, 0x00,  //%@@@@@@@@@@@@@@@+.............+@@@@@......
    0x00, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0x00, 0x00,  //.....+@@@@@...................+@@@@@......
    0x00, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0x00, 0x00,  //.....+@@@@@...................+@@@@@......
    0x00, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x40, 0x00,  //.....+@@@@@...................%@@@@@......
    0x00, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x2f, 0xff, 0xff, 0xff, 0xd0,  //.....+@@@@@..............%@@@@@@@@@@@@@@@+
    0x00, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xe0,  //.....+@@@@@..............@@@@@@@@@@@@@@@@%
    0x00, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xc0,  //.....+@@@@@..............+@@@@@@@@@@@@@@@.
    0x00, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0x40,  //.....+@@@@@...............%@@@@@@@@@@@@@+.
    0x00, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfd, 0x00,  //.....+@@@@@................%@@@@@@@@@@@+..
    0x00, 0x1f, 0xfe, 0xaa, 0xaa, 0xaa, 0x00, 0xff, 0xff, 0xf8, 0x00,  //.....+@@@@@%%%%%%%%%%%%%....@@@@@@@@@@%...
    0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x3f, 0xff, 0xe0, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@....@@@@@@@@%....
    0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xc0, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@%....@@@@@@@.....
    0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x07, 0xff, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@+...+@@@@@......
    0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x02, 0xfd, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@+...%@@@+......
    0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0xb4, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@%....%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................


    /*Unicode: U+f07b () , Width: 37 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x01, 0xaa, 0xaa, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+%%%%%%%%%+.......................
    0x1f, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@@@@@@@@@......................
    0x3f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@@@@.....................
    0xbf, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@@@@+....................
    0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@%....................
    0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@%....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................


    /*Unicode: U+f093 () , Width: 36 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x00,  //.................@@+................
    0x00, 0x00, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0x00,  //................@@@@+...............
    0x00, 0x00, 0x00, 0x03, 0xff, 0xd0, 0x00, 0x00, 0x00,  //...............@@@@@@+..............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xfd, 0x00, 0x00, 0x00,  //.............@@@@@@@@@@+............
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00,  //............@@@@@@@@@@@@+...........
    0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //...........@@@@@@@@@@@@@@+..........
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00,  //..........@@@@@@@@@@@@@@@@+.........
    0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00,  //.........@@@@@@@@@@@@@@@@@@+........
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00,  //........@@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x55, 0x5f, 0xff, 0xf5, 0x55, 0x00, 0x00,  //........++++++@@@@@@@@++++++........
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..............@@@@@@@@..............
    0x1a, 0xaa, 0xa9, 0x01, 0x55, 0x40, 0x2a, 0xaa, 0xa4,  //.+%%%%%%%%%+...++++++....%%%%%%%%%+.
    0xbf, 0xff, 0xff, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xfe,  //%@@@@@@@@@@@............%@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xc0, 0x00, 0x02, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@..........%@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfa, 0xaa, 0xaf, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@%%%%%%%%@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0xfc, 0x3f,  //@@@@@@@@@@@@@@@@@@@@@@@@@%.+@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xfc, 0x3f,  //@@@@@@@@@@@@@@@@@@@@@@@@@...@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0xfc, 0x3f,  //@@@@@@@@@@@@@@@@@@@@@@@@@%.+@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................


    /*Unicode: U+f095 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+%%........................
    0x07, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@%.......................
    0x0f, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@+......................
    0x3f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@......................
    0x7f, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@+.....................
    0xbf, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@.....................
    0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%....................
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@....................
    0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%....................
    0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@%.....................
    0xbf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@%......................
    0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@%.......................
    0x3f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@+.......................
    0x1f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@%.......................
    0x0f, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@+......................
    0x0b, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@@@@......................
    0x03, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@%.....................
    0x02, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@@@@+....................
    0x00, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@+...................
    0x00, 0x3f, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@+..................
    0x00, 0x1f, 0xff, 0xd0, 0x00, 0x0b, 0x80, 0x00,  //.....+@@@@@@@+........%@%......
    0x00, 0x07, 0xff, 0xf8, 0x00, 0x2f, 0xf4, 0x00,  //......+@@@@@@@%......%@@@@+....
    0x00, 0x01, 0xff, 0xff, 0x40, 0xbf, 0xff, 0x40,  //.......+@@@@@@@@+...%@@@@@@@+..
    0x00, 0x00, 0x7f, 0xff, 0xe6, 0xff, 0xff, 0xe0,  //........+@@@@@@@@%+%@@@@@@@@@%.
    0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf8,  //.........+@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xf8,  //..........+@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf4,  //............@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x2f, 0xff, 0xff, 0xff, 0xf0,  //.............%@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xff, 0xd0,  //...............%@@@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0x00,  //.................+@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xe4, 0x00,  //....................%@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f0c4 () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x01, 0xbf, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+%@@@@%.............................
    0x0f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@@%...........................
    0x3f, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@+.........................
    0x7f, 0xea, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x40,  //+@@@@%%%@@@@@@%..................@@@+..
    0xff, 0x00, 0x0b, 0xfd, 0x00, 0x00, 0x00, 0x02, 0xf6, 0xf0,  //@@@@......%@@@@+...............%@@+%@@.
    0xfe, 0x00, 0x01, 0xff, 0x00, 0x00, 0x00, 0x2f, 0x40, 0x38,  //@@@+.......+@@@@.............%@@+....@%
    0xfe, 0x00, 0x00, 0x7f, 0x40, 0x00, 0x01, 0xf8, 0x00, 0xb4,  //@@@%........+@@@+..........+@@%.....%@+
    0xbf, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x1f, 0x80, 0x03, 0xc0,  //%@@@.........@@@%.........@@%......@@..
    0x7f, 0xc0, 0x00, 0x3f, 0x80, 0x00, 0xbd, 0x00, 0x1f, 0x00,  //+@@@@........@@@%.......%@@+.....+@@...
    0x2f, 0xf4, 0x00, 0x3f, 0x80, 0x0b, 0xd0, 0x00, 0xb8, 0x00,  //.%@@@@+......@@@%.....%@@+......%@%....
    0x0f, 0xff, 0x96, 0xff, 0xd0, 0x7e, 0x00, 0x03, 0xd0, 0x00,  //..@@@@@@%++%@@@@@+..+@@%.......@@+.....
    0x02, 0xff, 0xff, 0xff, 0xbb, 0xe0, 0x00, 0x0f, 0x00, 0x00,  //...%@@@@@@@@@@@@%@%@@%........@@.......
    0x00, 0x7f, 0xff, 0xfc, 0x2f, 0x40, 0x00, 0x7c, 0x00, 0x00,  //....+@@@@@@@@@@..%@@+.......+@@........
    0x00, 0x06, 0xff, 0xaf, 0x78, 0x00, 0x02, 0xe0, 0x00, 0x00,  //......+%@@@@%%@@+@+........%@%.........
    0x00, 0x00, 0x00, 0x03, 0xf1, 0xd0, 0x0f, 0x40, 0x00, 0x00,  //...............@@@.+@+....@@+..........
    0x00, 0x00, 0x00, 0x00, 0xf3, 0xf0, 0x7d, 0x00, 0x00, 0x00,  //................@@.@@@..+@@+...........
    0x00, 0x00, 0x00, 0x07, 0xe1, 0xd2, 0xeb, 0x40, 0x00, 0x00,  //..............+@@%.+@+.+@%%@+..........
    0x00, 0x07, 0xff, 0xee, 0x01, 0x0b, 0x82, 0xe0, 0x00, 0x00,  //......+@@@@@@%@%...+..%@%..%@%.........
    0x00, 0xbf, 0xff, 0xfc, 0x1f, 0xfd, 0x00, 0x7c, 0x00, 0x00,  //....+@@@@@@@@@@..+@@@@@+....+@@........
    0x03, 0xff, 0xff, 0xff, 0xbb, 0xf4, 0x00, 0x0f, 0x40, 0x00,  //...@@@@@@@@@@@@@%@%@@@+.......@@+......
    0x0f, 0xff, 0x96, 0xff, 0xd0, 0x7e, 0x00, 0x02, 0xd0, 0x00,  //..@@@@@@%++%@@@@@+..+@@%.......%@+.....
    0x3f, 0xf4, 0x00, 0x3f, 0x80, 0x07, 0xd0, 0x00, 0xb8, 0x00,  //.%@@@@+......@@@%.....+@@+......%@%....
    0x7f, 0xc0, 0x00, 0x3f, 0x80, 0x00, 0xbc, 0x00, 0x1f, 0x00,  //+@@@@........@@@%.......%@@......+@@...
    0xbf, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x0f, 0x80, 0x03, 0xd0,  //%@@@.........@@@%.........@@%......@@+.
    0xfe, 0x00, 0x00, 0x7f, 0x40, 0x00, 0x01, 0xf8, 0x00, 0xb4,  //@@@%........+@@@+..........+@@%.....%@+
    0xfe, 0x00, 0x01, 0xff, 0x00, 0x00, 0x00, 0x2f, 0x40, 0x38,  //@@@%.......+@@@@.............%@@+....@%
    0xff, 0x00, 0x0b, 0xfd, 0x00, 0x00, 0x00, 0x02, 0xf6, 0xf0,  //@@@@......%@@@@+...............%@@+%@@.
    0xbf, 0xea, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x40,  //%@@@@%%%@@@@@@%.................+@@@+..
    0x3f, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@+.........................
    0x0f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@@%...........................
    0x01, 0xbf, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+%@@@@%.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................


    /*Unicode: U+f0c5 () , Width: 39 */
    0x00, 0x00, 0x00, 0xbf, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,  //............%@@@@@@@@@@%...............
    0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,  //..........+@@@@@@@@@@@@@@..............
    0x00, 0x00, 0x2f, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,  //.........%@@@@@@@@@@@@@@@..............
    0x00, 0x00, 0xbf, 0xf0, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00,  //........%@@@@@........@@@..............
    0x00, 0x01, 0xff, 0xf0, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00,  //.......+@@@@@@........@@@..............
    0x00, 0x07, 0xfb, 0xf0, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00,  //......+@@@%@@@........@@@..............
    0x00, 0x1f, 0xe3, 0xf0, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00,  //.....+@@@%.@@@........@@@..............
    0x00, 0x7f, 0xc3, 0xf0, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00,  //....+@@@@..@@@........@@@..............
    0x01, 0xff, 0x03, 0xf0, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00,  //...+@@@@...@@@........@@@..............
    0x07, 0xfc, 0x03, 0xf0, 0x00, 0x0f, 0xdb, 0xff, 0xff, 0xf4,  //..+@@@@....@@@........@@@+%@@@@@@@@@@@.
    0x1f, 0xf0, 0x03, 0xf0, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xfc,  //.+@@@@.....@@@........@@@@@@@@@@@@@@@@@
    0x3f, 0xc0, 0x03, 0xf0, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xfc,  //.@@@@......@@@........@@@@@@@@@@@@@@@@@
    0xbf, 0xff, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0x00, 0x00, 0xfc,  //%@@@@@@@@@@@@@........@@@@@@........@@@
    0xff, 0xff, 0xff, 0xf0, 0x00, 0x2f, 0xff, 0x00, 0x00, 0xfc,  //@@@@@@@@@@@@@@.......%@@@@@@........@@@
    0xff, 0xff, 0xff, 0x80, 0x00, 0xbf, 0x7f, 0x00, 0x00, 0xfc,  //@@@@@@@@@@@@%.......%@@@+@@@........@@@
    0xfc, 0x00, 0x00, 0x00, 0x02, 0xfd, 0x3f, 0x00, 0x00, 0xfc,  //@@@................%@@@+.@@@........@@@
    0xfc, 0x00, 0x00, 0x00, 0x0b, 0xf4, 0x3f, 0x00, 0x00, 0xfc,  //@@@...............%@@@+..@@@........@@@
    0xfc, 0x00, 0x00, 0x00, 0x2f, 0xc0, 0x3f, 0x00, 0x00, 0xfc,  //@@@..............%@@@....@@@........@@@
    0xfc, 0x00, 0x00, 0x00, 0xbf, 0x00, 0x3f, 0x00, 0x00, 0xfc,  //@@@.............%@@@.....@@@........@@@
    0xfc, 0x00, 0x00, 0x02, 0xfc, 0x00, 0x3f, 0x00, 0x00, 0xfc,  //@@@............%@@@......@@@........@@@
    0xfc, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0x00, 0x00, 0xfc,  //@@@...........+@@@@@@@@@@@@@........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xfe, 0x00, 0x00, 0xfc,  //@@@...........@@@@@@@@@@@@@%........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xf8, 0x00, 0x00, 0xfc,  //@@@...........@@@@@@@@@@@@%.........@@@
    0xfc, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@...........@@%...................@@@
    0xfc, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@...........@@%...................@@@
    0xfc, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@...........@@%...................@@@
    0xfc, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@...........@@%...................@@@
    0xfc, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@...........@@%...................@@@
    0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@@@@@@@@@@@@@@%...................@@@
    0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@@@@@@@@@@@@@@%...................@@@
    0x7f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0xfc,  //.@@@@@@@@@@@@@@@%...................@@@
    0x00, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0xfc,  //..............@@%...................@@@
    0x00, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0xfc,  //..............@@%...................@@@
    0x00, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0xfc,  //..............@@%...................@@@
    0x00, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0xfc,  //..............@@%...................@@@
    0x00, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0xfc,  //..............@@%...................@@@
    0x00, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0xfc,  //..............@@%...................@@@
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //..............@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //..............@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //...............%@@@@@@@@@@@@@@@@@@@@@%.


    /*Unicode: U+f0c7 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@%+.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@.......
    0xfc, 0x1f, 0xff, 0xf0, 0x03, 0xf2, 0xff, 0x00, 0x00,  //@@@..+@@@@@@@@.....@@@.%@@@@......
    0xfc, 0x1f, 0xff, 0xf0, 0x03, 0xf0, 0x7f, 0xc0, 0x00,  //@@@..+@@@@@@@@.....@@@..+@@@@.....
    0xfc, 0x1f, 0xff, 0xf0, 0x03, 0xf0, 0x1f, 0xf0, 0x00,  //@@@..+@@@@@@@@.....@@@...+@@@@....
    0xfc, 0x1f, 0xff, 0xf0, 0x03, 0xf0, 0x07, 0xfc, 0x00,  //@@@..+@@@@@@@@.....@@@....+@@@@...
    0xfc, 0x1f, 0xff, 0xf0, 0x03, 0xf0, 0x00, 0xff, 0x00,  //@@@..+@@@@@@@@.....@@@......@@@@..
    0xfc, 0x1f, 0xff, 0xf0, 0x03, 0xf0, 0x00, 0x3f, 0xc0,  //@@@..+@@@@@@@@.....@@@.......@@@@.
    0xfc, 0x1f, 0xff, 0xf0, 0x03, 0xf0, 0x00, 0x0f, 0xd0,  //@@@..+@@@@@@@@.....@@@........@@@+
    0xfc, 0x1f, 0xff, 0xf0, 0x03, 0xf0, 0x00, 0x07, 0xe0,  //@@@..+@@@@@@@@.....@@@........+@@%
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x03, 0xf0,  //@@@..+@@@@@@@@@@@@@@@@.........@@@
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x03, 0xf0,  //@@@...@@@@@@@@@@@@@@@@.........@@@
    0xfc, 0x0b, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x03, 0xf0,  //@@@...%@@@@@@@@@@@@@@+.........@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@............................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@............................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@............................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@............................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@............................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@............................@@@
    0xfc, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xf0,  //@@@...%@@@@@@@@@@@@@@@@@@@@....@@@
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x03, 0xf0,  //@@@...@@@@@@@@@@@@@@@@@@@@@%...@@@
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0xf0,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xfc, 0x1f, 0x40, 0x00, 0x00, 0x00, 0x3f, 0x03, 0xf0,  //@@@..+@@+................@@@...@@@
    0xfc, 0x1f, 0x40, 0x00, 0x00, 0x00, 0x3f, 0x03, 0xf0,  //@@@..+@@+................@@@...@@@
    0xfc, 0x1f, 0x40, 0x00, 0x00, 0x00, 0x3f, 0x03, 0xf0,  //@@@..+@@+................@@@...@@@
    0xfc, 0x1f, 0x40, 0x00, 0x00, 0x00, 0x3f, 0x03, 0xf0,  //@@@..+@@+................@@@...@@@
    0xfc, 0x1f, 0x40, 0x00, 0x00, 0x00, 0x3f, 0x03, 0xf0,  //@@@..+@@+................@@@...@@@
    0xfc, 0x1f, 0x40, 0x00, 0x00, 0x00, 0x3f, 0x03, 0xf0,  //@@@..+@@+................@@@...@@@
    0xfc, 0x1f, 0x40, 0x00, 0x00, 0x00, 0x3f, 0x03, 0xf0,  //@@@..+@@+................@@@...@@@
    0xfc, 0x1f, 0x40, 0x00, 0x00, 0x00, 0x3f, 0x03, 0xf0,  //@@@..+@@+................@@@...@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f0e7 () , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x7f, 0xff, 0xd0, 0x00,  //....+@@@@@@@@+......
    0x00, 0xff, 0xff, 0xd0, 0x00,  //....@@@@@@@@@+......
    0x00, 0xff, 0xff, 0xc0, 0x00,  //....@@@@@@@@@.......
    0x01, 0xff, 0xff, 0x80, 0x00,  //...+@@@@@@@@%.......
    0x02, 0xff, 0xff, 0x00, 0x00,  //...%@@@@@@@@........
    0x03, 0xff, 0xff, 0x00, 0x00,  //...@@@@@@@@@........
    0x03, 0xff, 0xfd, 0x00, 0x00,  //...@@@@@@@@+........
    0x07, 0xff, 0xfc, 0x00, 0x00,  //..+@@@@@@@@.........
    0x0b, 0xff, 0xf8, 0x00, 0x00,  //..%@@@@@@@%.........
    0x0f, 0xff, 0xf4, 0x00, 0x68,  //..%@@@@@@@+.....+%%.
    0x0f, 0xff, 0xf0, 0x6f, 0xfd,  //..@@@@@@@@..+%@@@@@+
    0x0f, 0xff, 0xff, 0xff, 0xfc,  //..@@@@@@@@@@@@@@@@@.
    0x1f, 0xff, 0xff, 0xff, 0xf4,  //.+@@@@@@@@@@@@@@@@+.
    0x2f, 0xff, 0xff, 0xff, 0xf0,  //.%@@@@@@@@@@@@@@@@..
    0x3f, 0xff, 0xff, 0xff, 0xe0,  //.@@@@@@@@@@@@@@@@%..
    0x3f, 0xff, 0xff, 0xff, 0xc0,  //.@@@@@@@@@@@@@@@@...
    0x7f, 0xff, 0xff, 0xff, 0x80,  //+@@@@@@@@@@@@@@@%...
    0xbf, 0xff, 0xef, 0xff, 0x00,  //%@@@@@@@@%@@@@@@....
    0xff, 0xe4, 0x0f, 0xfe, 0x00,  //@@@@@%+...@@@@@%....
    0xa4, 0x00, 0x1f, 0xfc, 0x00,  //%%+......+@@@@@.....
    0x00, 0x00, 0x2f, 0xf8, 0x00,  //.........%@@@@%.....
    0x00, 0x00, 0x3f, 0xf4, 0x00,  //.........@@@@@+.....
    0x00, 0x00, 0x3f, 0xf0, 0x00,  //.........@@@@@......
    0x00, 0x00, 0x7f, 0xd0, 0x00,  //........+@@@@+......
    0x00, 0x00, 0xbf, 0xc0, 0x00,  //........%@@@@.......
    0x00, 0x00, 0xff, 0x40, 0x00,  //........@@@@+.......
    0x00, 0x00, 0xff, 0x00, 0x00,  //........@@@@........
    0x00, 0x01, 0xfd, 0x00, 0x00,  //.......+@@@+........
    0x00, 0x02, 0xfc, 0x00, 0x00,  //.......%@@@.........
    0x00, 0x03, 0xf8, 0x00, 0x00,  //.......@@@%.........
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@..........
    0x00, 0x07, 0xe0, 0x00, 0x00,  //......+@@%..........
    0x00, 0x0b, 0xc0, 0x00, 0x00,  //......%@@...........
    0x00, 0x0f, 0x80, 0x00, 0x00,  //......@@%...........
    0x00, 0x0f, 0x00, 0x00, 0x00,  //......@@............
    0x00, 0x0e, 0x00, 0x00, 0x00,  //......@%............
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+f0f3 () , Width: 37 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,  //................+@@%.................
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //................@@@@.................
    0x00, 0x00, 0x00, 0x00, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //................@@@@.................
    0x00, 0x00, 0x00, 0x2f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.............%@@@@@@@@%..............
    0x00, 0x00, 0x02, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,  //...........%@@@@@@@@@@@@%............
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..........%@@@@@@@@@@@@@@@...........
    0x00, 0x00, 0x2f, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00,  //.........%@@@@@@@@@@@@@@@@@..........
    0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00,  //........+@@@@@@@@@@@@@@@@@@%.........
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00,  //........@@@@@@@@@@@@@@@@@@@@+........
    0x00, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00,  //.......+@@@@@@@@@@@@@@@@@@@@%........
    0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@........
    0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@........
    0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@........
    0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@@@%.......
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //......%@@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //......%@@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //......@@@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00,  //......@@@@@@@@@@@@@@@@@@@@@@@@+......
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //...%@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //..@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+.
    0x01, 0x55, 0x55, 0xb7, 0xff, 0xfe, 0x55, 0x55, 0x40, 0x00,  //...+++++++++%@+@@@@@@@@%+++++++++....
    0x00, 0x00, 0x00, 0x7a, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,  //............+@+%@@@@@@@%.............
    0x00, 0x00, 0x00, 0x3d, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,  //.............@@+@@@@@@@..............
    0x00, 0x00, 0x00, 0x1f, 0x5f, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.............+@@++@@@@%..............
    0x00, 0x00, 0x00, 0x07, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00,  //..............+@@@@@@%...............
    0x00, 0x00, 0x00, 0x00, 0xbe, 0x40, 0x00, 0x00, 0x00, 0x00,  //................%@@%+................


    /*Unicode: U+f11c () , Width: 42 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@....................................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@....................................@@@
    0xfc, 0x1f, 0x03, 0xf0, 0x3c, 0x0f, 0xc0, 0xf4, 0x2f, 0x03, 0xf0,  //@@@..+@@...@@@...@@...@@@...@@+..%@@...@@@
    0xfc, 0x2f, 0x03, 0xf0, 0x3c, 0x0f, 0xc0, 0xf4, 0x3f, 0x03, 0xf0,  //@@@..%@@...@@@...@@...@@@...@@+..@@@...@@@
    0xfc, 0x2f, 0x03, 0xf0, 0x3c, 0x0f, 0xc0, 0xf4, 0x3f, 0x03, 0xf0,  //@@@..%@@...@@@...@@...@@@...@@+..@@@...@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x03, 0xf0,  //@@@..............................@@@...@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x03, 0xf0,  //@@@..............................@@@...@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x03, 0xf0,  //@@@..............................@@@...@@@
    0xfc, 0x2f, 0xfc, 0x0f, 0xc3, 0xf0, 0x3f, 0x0b, 0xff, 0x03, 0xf0,  //@@@..%@@@@@...@@@..@@@...@@@..%@@@@@...@@@
    0xfc, 0x2f, 0xfc, 0x0f, 0xc3, 0xf0, 0x3f, 0x0b, 0xff, 0x03, 0xf0,  //@@@..%@@@@@...@@@..@@@...@@@..%@@@@@...@@@
    0xfc, 0x1f, 0xfc, 0x0f, 0x82, 0xf0, 0x3e, 0x07, 0xff, 0x03, 0xf0,  //@@@..+@@@@@...@@%..%@@...@@%..+@@@@@...@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@....................................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@....................................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@....................................@@@
    0xfc, 0x2f, 0x03, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x3f, 0x03, 0xf0,  //@@@..%@@...@@@@@@@@@@@@@@@@@@@+..@@@...@@@
    0xfc, 0x2f, 0x03, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x3f, 0x03, 0xf0,  //@@@..%@@...@@@@@@@@@@@@@@@@@@@+..@@@...@@@
    0xfc, 0x1f, 0x03, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x2f, 0x03, 0xf0,  //@@@..+@@...@@@@@@@@@@@@@@@@@@@+..%@@...@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@....................................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@....................................@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................


    /*Unicode: U+f124 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0,  //............................%@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xf8,  //..........................%@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xf4,  //........................%@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xf0,  //......................%@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xd0,  //....................%@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xc0,  //..................%@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0x40,  //................%@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0x00,  //..............%@@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xfd, 0x00,  //............%@@@@@@@@@@@@@@+...
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xfc, 0x00,  //..........%@@@@@@@@@@@@@@@@....
    0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xf4, 0x00,  //........%@@@@@@@@@@@@@@@@@+....
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //......%@@@@@@@@@@@@@@@@@@@.....
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@+.....
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@......
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@+......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@.......
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00,  //..............@@@@@@@@@........
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf4, 0x00, 0x00,  //..............@@@@@@@@+........
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0, 0x00, 0x00,  //..............@@@@@@@@.........
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xd0, 0x00, 0x00,  //..............@@@@@@@+.........
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xc0, 0x00, 0x00,  //..............@@@@@@@..........
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x40, 0x00, 0x00,  //..............@@@@@@+..........
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //..............@@@@@@...........
    0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x00,  //..............@@@@@+...........
    0x00, 0x00, 0x00, 0x0f, 0xfc, 0x00, 0x00, 0x00,  //..............@@@@@............
    0x00, 0x00, 0x00, 0x0f, 0xf4, 0x00, 0x00, 0x00,  //..............@@@@+............
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //..............@@@@.............
    0x00, 0x00, 0x00, 0x0f, 0xd0, 0x00, 0x00, 0x00,  //..............@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00,  //..............@@@..............
    0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00,  //..............+%...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f15b () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x7f, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@@@@@@@+..............
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x08, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%...........
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0b, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@..........
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0b, 0xc0, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@.........
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0b, 0xf0, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@........
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0b, 0xfc, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@.......
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0b, 0xff, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@@......
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0b, 0xff, 0xc0, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@@@.....
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0b, 0xff, 0xf0, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0b, 0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0b, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..............
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@%..............
    0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@+.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.


    /*Unicode: U+f1eb () , Width: 43 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x15, 0xa9, 0x50, 0x00, 0x00, 0x00, 0x00,  //.................+++%%+++..................
    0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00,  //............+%@@@@@@@@@@@@@@%+.............
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@@@@@@@@@@@@@@@@@%..........
    0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //.......+@@@@@@@@@@@@@@@@@@@@@@@@@@%........
    0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%......
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+....
    0x07, 0xff, 0xff, 0xfe, 0x50, 0x00, 0x16, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@%++.......++%@@@@@@@@@@@@...
    0x1f, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x1b, 0xff, 0xff, 0xc0,  //.+@@@@@@@@@@%................+%@@@@@@@@@@..
    0xbf, 0xff, 0xf4, 0x00, 0x05, 0xa9, 0x40, 0x00, 0xbf, 0xff, 0xf4,  //%@@@@@@@@@+.......++%%+++.......%@@@@@@@@@+
    0xff, 0xff, 0x40, 0x06, 0xff, 0xff, 0xfe, 0x40, 0x0b, 0xff, 0xf8,  //@@@@@@@@+.....+%@@@@@@@@@@@%+.....%@@@@@@@%
    0x3f, 0xf8, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xf8, 0x01, 0xff, 0xe0,  //.@@@@@%.....%@@@@@@@@@@@@@@@@@%....+@@@@@%.
    0x0f, 0xd0, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x2f, 0x80,  //..@@@+....%@@@@@@@@@@@@@@@@@@@@@%....%@@%..
    0x02, 0x40, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x05, 0x00,  //...%+...+@@@@@@@@@@@@@@@@@@@@@@@@@....++...
    0x00, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00,  //.......%@@@@@@@@@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x0b, 0xff, 0xff, 0xe4, 0x00, 0x6f, 0xff, 0xff, 0x40, 0x00,  //......%@@@@@@@@@@%+.....+%@@@@@@@@@@+......
    0x00, 0x0f, 0xff, 0xf8, 0x00, 0x00, 0x01, 0xff, 0xff, 0x80, 0x00,  //......@@@@@@@@%............+@@@@@@@@%......
    0x00, 0x03, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x00, 0x00,  //.......@@@@@@................+@@@@@@.......
    0x00, 0x00, 0xfd, 0x00, 0x1b, 0xff, 0x90, 0x02, 0xfc, 0x00, 0x00,  //........@@@+.....+%@@@@@%+.....%@@@........
    0x00, 0x00, 0x20, 0x02, 0xff, 0xff, 0xfd, 0x00, 0x60, 0x00, 0x00,  //.........%.....%@@@@@@@@@@@+....+%.........
    0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00,  //.............+@@@@@@@@@@@@@@@+.............
    0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00,  //............%@@@@@@@@@@@@@@@@@+............
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00,  //............@@@@@@@@@@@@@@@@@@@............
    0x00, 0x00, 0x00, 0x7f, 0xff, 0xab, 0xff, 0xf0, 0x00, 0x00, 0x00,  //............+@@@@@@@%%%@@@@@@@.............
    0x00, 0x00, 0x00, 0x1f, 0xe0, 0x00, 0x7f, 0xc0, 0x00, 0x00, 0x00,  //.............+@@@%......+@@@@..............
    0x00, 0x00, 0x00, 0x07, 0x40, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,  //..............+@+.........+@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................+.....................
    0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //..................+@@@@@+..................
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //..................@@@@@@@..................
    0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //..................+@@@@@...................
    0x00, 0x00, 0x00, 0x00, 0x02, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................%@@@+...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................+@+....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................


    /*Unicode: U+f240 () , Width: 51 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x3f, 0x00,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@...
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x3f, 0x80,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@%..
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x3f, 0xf0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@@@.
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x3f, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@@@+
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x3f, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x3f, 0xf4,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@@@+
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x3f, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@@%.
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x3f, 0x00,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@...
    0xfc, 0x0a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa0, 0x3f, 0x00,  //@@@...%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%...@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................


    /*Unicode: U+f241 () , Width: 51 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x3f, 0x00,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@...
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x3f, 0x80,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@%..
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x3f, 0xf0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@@@.
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x3f, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@@@+
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x3f, 0xf8,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@@@%
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x3f, 0xf4,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@@@+
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x3f, 0xe0,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@@%.
    0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x3f, 0x00,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@...
    0xfc, 0x0a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa0, 0x00, 0x00, 0x3f, 0x00,  //@@@...%%%%%%%%%%%%%%%%%%%%%%%%%%%%...........@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................


    /*Unicode: U+f242 () , Width: 51 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@...
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x80,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@%..
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@@@.
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@@@+
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@@@%
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf4,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@@@+
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xe0,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@@%.
    0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@...
    0xfc, 0x1a, 0xaa, 0xaa, 0xaa, 0xaa, 0x80, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..+%%%%%%%%%%%%%%%%%%%....................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................


    /*Unicode: U+f243 () , Width: 51 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@...@@@@@@@@@@@............................@@@...
    0xfc, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x80,  //@@@...@@@@@@@@@@@............................@@@%..
    0xfc, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0,  //@@@...@@@@@@@@@@@............................@@@@@.
    0xfc, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8,  //@@@...@@@@@@@@@@@............................@@@@@+
    0xfc, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@...@@@@@@@@@@@...............................@@%
    0xfc, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@...@@@@@@@@@@@...............................@@%
    0xfc, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@...@@@@@@@@@@@...............................@@%
    0xfc, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@...@@@@@@@@@@@...............................@@%
    0xfc, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@...@@@@@@@@@@@...............................@@%
    0xfc, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@...@@@@@@@@@@@...............................@@%
    0xfc, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@...@@@@@@@@@@@...............................@@%
    0xfc, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@...@@@@@@@@@@@...............................@@%
    0xfc, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8,  //@@@...@@@@@@@@@@@............................@@@@@%
    0xfc, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf4,  //@@@...@@@@@@@@@@@............................@@@@@+
    0xfc, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xe0,  //@@@...@@@@@@@@@@@............................@@@@%.
    0xfc, 0x0f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@...@@@@@@@@@@@............................@@@...
    0xfc, 0x0a, 0xaa, 0xaa, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@...%%%%%%%%%%%............................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................


    /*Unicode: U+f244 () , Width: 51 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xd0,  //@@@..........................................@@@@+.
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0,  //@@@..........................................@@@@@.
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8,  //@@@..........................................@@@@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@.............................................@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@.............................................@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@.............................................@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@.............................................@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@.............................................@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@.............................................@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@.............................................@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,  //@@@.............................................@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8,  //@@@..........................................@@@@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf4,  //@@@..........................................@@@@@.
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xd0,  //@@@..........................................@@@@+.
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //@@@..........................................@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................


    /*Unicode: U+f293 () , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x1b, 0xff, 0xf9, 0x00, 0x00, 0x00,  //.........+%@@@@@@@%+.........
    0x00, 0x02, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00,  //.......%@@@@@@@@@@@@@%.......
    0x00, 0x1f, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@+.....
    0x00, 0xbf, 0xff, 0xdf, 0xff, 0xff, 0x40, 0x00,  //....+@@@@@@@@+@@@@@@@@@@+....
    0x01, 0xff, 0xff, 0xc3, 0xff, 0xff, 0xc0, 0x00,  //...+@@@@@@@@@..@@@@@@@@@@....
    0x03, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xf0, 0x00,  //...@@@@@@@@@@...@@@@@@@@@@...
    0x0b, 0xff, 0xff, 0xc0, 0x3f, 0xff, 0xf4, 0x00,  //..%@@@@@@@@@@....@@@@@@@@@+..
    0x0f, 0xff, 0xff, 0xc0, 0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@@@.....@@@@@@@@@..
    0x1f, 0xff, 0xff, 0xc0, 0x03, 0xff, 0xfd, 0x00,  //.+@@@@@@@@@@@......@@@@@@@@+.
    0x3f, 0xff, 0xff, 0xc0, 0x00, 0xff, 0xfe, 0x00,  //.@@@@@@@@@@@@.......@@@@@@@%.
    0x3f, 0xfe, 0xff, 0xc0, 0xc0, 0x3f, 0xff, 0x00,  //.@@@@@@%@@@@@...@....@@@@@@@.
    0x7f, 0xf8, 0x7f, 0xc0, 0xf0, 0x0f, 0xff, 0x00,  //+@@@@@%.+@@@@...@@....@@@@@@.
    0x7f, 0xf0, 0x1f, 0xc0, 0xfc, 0x03, 0xff, 0x40,  //+@@@@@...+@@@...@@@....@@@@@+
    0xbf, 0xf8, 0x07, 0xc0, 0xf8, 0x07, 0xff, 0x40,  //%@@@@@%...+@@...@@%...+@@@@@+
    0xbf, 0xfe, 0x01, 0xc0, 0xe0, 0x1f, 0xff, 0x80,  //%@@@@@@%...+@...@%...+@@@@@@%
    0xff, 0xff, 0x80, 0x40, 0x80, 0x7f, 0xff, 0x80,  //@@@@@@@@%...+...%...+@@@@@@@%
    0xff, 0xff, 0xe0, 0x00, 0x01, 0xff, 0xff, 0x80,  //@@@@@@@@@%.........+@@@@@@@@%
    0xff, 0xff, 0xf8, 0x00, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@%.......+@@@@@@@@@@
    0xff, 0xff, 0xfe, 0x00, 0x1f, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@%.....+@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x40, 0x3f, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@+....@@@@@@@@@@@@
    0xff, 0xff, 0xfe, 0x00, 0x1f, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@%.....+@@@@@@@@@@@
    0xff, 0xff, 0xf8, 0x00, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@%.......+@@@@@@@@@@
    0xff, 0xff, 0xe0, 0x00, 0x01, 0xff, 0xff, 0x80,  //@@@@@@@@@%.........+@@@@@@@@%
    0xff, 0xff, 0x80, 0x40, 0x80, 0x7f, 0xff, 0x80,  //@@@@@@@@%...+...%...+@@@@@@@%
    0xbf, 0xfe, 0x01, 0xc0, 0xe0, 0x1f, 0xff, 0x80,  //%@@@@@@%...+@...@%...+@@@@@@%
    0xbf, 0xf8, 0x07, 0xc0, 0xf8, 0x07, 0xff, 0x40,  //%@@@@@%...+@@...@@%...+@@@@@+
    0x7f, 0xf0, 0x1f, 0xc0, 0xfc, 0x03, 0xff, 0x40,  //+@@@@@...+@@@...@@@....@@@@@+
    0x7f, 0xf8, 0x7f, 0xc0, 0xf0, 0x0f, 0xff, 0x00,  //+@@@@@%.+@@@@...@@....@@@@@@.
    0x3f, 0xfe, 0xff, 0xc0, 0xc0, 0x3f, 0xff, 0x00,  //.@@@@@@%@@@@@...@....@@@@@@@.
    0x3f, 0xff, 0xff, 0xc0, 0x00, 0xff, 0xfe, 0x00,  //.@@@@@@@@@@@@.......@@@@@@@%.
    0x1f, 0xff, 0xff, 0xc0, 0x03, 0xff, 0xfd, 0x00,  //.+@@@@@@@@@@@......@@@@@@@@+.
    0x0f, 0xff, 0xff, 0xc0, 0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@@@.....@@@@@@@@@..
    0x0b, 0xff, 0xff, 0xc0, 0x3f, 0xff, 0xf4, 0x00,  //..%@@@@@@@@@@....@@@@@@@@@+..
    0x03, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xf0, 0x00,  //...@@@@@@@@@@...@@@@@@@@@@...
    0x01, 0xff, 0xff, 0xc3, 0xff, 0xff, 0xc0, 0x00,  //...+@@@@@@@@@..@@@@@@@@@@....
    0x00, 0xbf, 0xff, 0xdf, 0xff, 0xff, 0x40, 0x00,  //....+@@@@@@@@+@@@@@@@@@@+....
    0x00, 0x1f, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@+.....
    0x00, 0x02, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00,  //.......%@@@@@@@@@@@@@%.......
    0x00, 0x00, 0x1b, 0xff, 0xf9, 0x00, 0x00, 0x00,  //.........+%@@@@@@@%+.........



#elif USE_LV_FONT_SYMBOL_40 == 4
    /*Unicode: U+f001 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x9d, 0xa1,  //.............................+%@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x6a, 0xff, 0xff, 0xfa,  //..........................+%@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0xcf, 0xff, 0xff, 0xff, 0xfd,  //.......................+@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x9d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //...................+%@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //................+%@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //.............+%@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //...........+@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //...........@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //...........@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //...........@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //...........@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xfd,  //...........@@@@@@@@@@@@@@@@@@@%@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x50, 0x0f, 0xfd,  //...........@@@@@@@@@@@@@@@@%+..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x84, 0x00, 0x00, 0x0f, 0xfd,  //...........@@@@@@@@@@@@@%......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x20, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //...........@@@@@@@@@@+.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xfa, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //...........@@@@@@%+............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //...........@@@%+...............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //...........@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //...........@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //...........@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //...........@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //...........@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x88, 0x63, 0x0f, 0xfd,  //...........@@@..........++%%+..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x00, 0x02, 0xaf, 0xff, 0xff, 0xff, 0xef, 0xfd,  //...........@@@........%@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //...........@@@.......@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //...........@@@......@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //...........@@@......@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //...........@@@......@@@@@@@@@@@@@%
    0x00, 0x06, 0xad, 0xff, 0xda, 0x5d, 0xff, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,  //...+%@@@@%+@@@......+@@@@@@@@@@@@.
    0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x04, 0xdf, 0xff, 0xff, 0xff, 0xfb, 0x20,  //.+@@@@@@@@@@@@.......+@@@@@@@@@%..
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x02, 0x7a, 0xbb, 0x96, 0x10, 0x00,  //+@@@@@@@@@@@@@..........+%%%%+....
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@....................
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@....................
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@%....................
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@%.....................
    0x00, 0x5b, 0xff, 0xff, 0xff, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+%@@@@@@%+......................
    0x00, 0x00, 0x03, 0x44, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......++..........................


    /*Unicode: U+f008 () , Width: 42 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x03, 0xad, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd9, 0x20,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xf4, 0x00, 0x04, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0x40, 0x00, 0x6f, 0xfd,  //@@@+...+@@@+..................+@@@+...+@@@
    0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x0f, 0xfd,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x0f, 0xfd,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x0f, 0xfd,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x0f, 0xfd,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xf4, 0x00, 0x04, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x40, 0x00, 0x6f, 0xfd,  //@@@+...+@@@....................@@@+...+@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfd,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfd,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xff, 0xdd, 0xdf, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xfd, 0xdd, 0xff, 0xfd,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xf2, 0x00, 0x02, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x10, 0x00, 0x3f, 0xfd,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x0f, 0xfd,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x0f, 0xfd,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x0f, 0xfd,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xf3, 0x00, 0x03, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0x30, 0x00, 0x5f, 0xfd,  //@@@.....@@@+..................+@@@....+@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xdd, 0xdf, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xff, 0xff, 0xfd, 0xdd, 0xff, 0xfd,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xf2, 0x00, 0x02, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0x20, 0x00, 0x4f, 0xfd,  //@@@.....@@@+..................+@@@....+@@@
    0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x0f, 0xfd,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x0f, 0xfd,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x0f, 0xfd,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xf2, 0x00, 0x02, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x10, 0x00, 0x4f, 0xfd,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xdd, 0xdf, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xfd, 0xdd, 0xff, 0xfd,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfd,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfd,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xf4, 0x00, 0x04, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x40, 0x00, 0x6f, 0xfd,  //@@@+...+@@@....................@@@+...+@@@
    0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x0f, 0xfd,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x0f, 0xfd,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x0f, 0xfd,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x0f, 0xfd,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xf4, 0x00, 0x04, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x40, 0x00, 0x6f, 0xfd,  //@@@+...+@@@+..................+@@@+...+@@@
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x03, 0xad, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xda, 0x20,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..


    /*Unicode: U+f00b () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x03, 0x55, 0x55, 0x55, 0x54, 0x00, 0x00, 0x03, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x53, 0x00,  //..++++++++......+++++++++++++++++++++..
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@%...%@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0x4d, 0xff, 0xff, 0xff, 0xfe, 0x50, 0x00, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x40,  //.@@@@@@@@@+...+@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x03, 0x55, 0x55, 0x55, 0x54, 0x00, 0x00, 0x03, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x53, 0x00,  //..++++++++......+++++++++++++++++++++..
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@%...%@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0x4d, 0xff, 0xff, 0xff, 0xfe, 0x50, 0x00, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x40,  //.@@@@@@@@@+...+@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x03, 0x55, 0x55, 0x55, 0x54, 0x00, 0x00, 0x03, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x53, 0x00,  //..++++++++......+++++++++++++++++++++..
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@%...%@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0x4d, 0xff, 0xff, 0xff, 0xfe, 0x50, 0x00, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x40,  //.@@@@@@@@@+...+@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................


    /*Unicode: U+f00c () , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xef, 0xb0, 0x00, 0x00,  //............................@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xfc, 0x00, 0x00,  //...........................@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xc0, 0x00,  //..........................@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.........................@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //........................@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //.......................@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00,  //......................@@@@@@@@@@@%.
    0x00, 0x00, 0x03, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //.....................@@@@@@@@@@@%..
    0x00, 0x01, 0xdf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //....@@@+............@@@@@@@@@@@%...
    0x00, 0x1d, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00,  //...@@@@@+..........@@@@@@@@@@@%....
    0x01, 0xdf, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00,  //..@@@@@@@+........@@@@@@@@@@@%.....
    0x0d, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00,  //.@@@@@@@@@+......@@@@@@@@@@@%......
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@@@+....@@@@@@@@@@@%.......
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@+..@@@@@@@@@@@%........
    0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@@@@@@@+@@@@@@@@@@@%.........
    0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@@%..........
    0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@@@%...........
    0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@@@%............
    0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@%.............
    0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@%..............
    0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@@%...............
    0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@%................
    0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@@@%.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@@%..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@%...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+%+....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+f00d () , Width: 26 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x01, 0xac, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xcb, 0x30, 0x00,  //....%@+............+@%....
    0x00, 0x2e, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xf3, 0x00,  //...@@@@+..........+@@@@...
    0x02, 0xef, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0x30,  //..@@@@@@+........+@@@@@@..
    0x1e, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xf3,  //.@@@@@@@@+......+@@@@@@@@.
    0xaf, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xfd,  //%@@@@@@@@@+....+@@@@@@@@@@
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@+..+@@@@@@@@@@@
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x64, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,  //+@@@@@@@@@@@++@@@@@@@@@@@+
    0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //.+@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //...+@@@@@@@@@@@@@@@@@@%...
    0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@%......
    0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@+......
    0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@+.....
    0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@@+....
    0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00,  //...+@@@@@@@@@@@@@@@@@@+...
    0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@+..
    0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //.+@@@@@@@@@@@@@@@@@@@@@@+.
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,  //.@@@@@@@@@@@%+@@@@@@@@@@@+
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@%..+@@@@@@@@@@@
    0xbf, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xfe,  //%@@@@@@@@@%....+@@@@@@@@@@
    0x3f, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xf4,  //.@@@@@@@@%......+@@@@@@@@+
    0x03, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0x50,  //..@@@@@@%........+@@@@@@+.
    0x00, 0x3f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xf5, 0x00,  //...@@@@%..........+@@@@+..
    0x00, 0x03, 0xde, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xed, 0x40, 0x00,  //....@@+............+@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................


    /*Unicode: U+f011 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................++................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............+@@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@+..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@%..............
    0x00, 0x00, 0x00, 0x06, 0x95, 0x00, 0x00, 0xff, 0xff, 0xf9, 0x00, 0x01, 0x78, 0x30, 0x00, 0x00, 0x00,  //.......+%+....@@@@@%....+%........
    0x00, 0x00, 0x02, 0xdf, 0xff, 0x80, 0x00, 0xff, 0xff, 0xf9, 0x00, 0x1d, 0xff, 0xf8, 0x00, 0x00, 0x00,  //......@@@@+...@@@@@%...@@@@%......
    0x00, 0x00, 0x2e, 0xff, 0xff, 0xf0, 0x00, 0xff, 0xff, 0xf9, 0x00, 0x7f, 0xff, 0xff, 0xa0, 0x00, 0x00,  //.....@@@@@@...@@@@@%..+@@@@@%.....
    0x00, 0x01, 0xef, 0xff, 0xff, 0xf1, 0x00, 0xff, 0xff, 0xf9, 0x00, 0x8f, 0xff, 0xff, 0xf9, 0x00, 0x00,  //....@@@@@@@...@@@@@%..+@@@@@@%....
    0x00, 0x0c, 0xff, 0xff, 0xff, 0xb0, 0x00, 0xff, 0xff, 0xf9, 0x00, 0x2f, 0xff, 0xff, 0xff, 0x50, 0x00,  //...@@@@@@@%...@@@@@%...@@@@@@@+...
    0x00, 0x7f, 0xff, 0xff, 0xfd, 0x10, 0x00, 0xff, 0xff, 0xf9, 0x00, 0x05, 0xff, 0xff, 0xff, 0xf1, 0x00,  //..+@@@@@@@....@@@@@%...+@@@@@@@...
    0x01, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xf9, 0x00,  //..@@@@@@@.....@@@@@%....+@@@@@@%..
    0x08, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0x10,  //.%@@@@@@......@@@@@%.....+@@@@@@..
    0x0e, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0x80,  //.@@@@@@+......@@@@@%......%@@@@@%.
    0x4f, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xd0,  //+@@@@@%.......@@@@@%.......@@@@@@.
    0x8f, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf1,  //%@@@@@........@@@@@%.......%@@@@@.
    0xbf, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xf4,  //%@@@@@........@@@@@%.......+@@@@@+
    0xef, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xf7,  //@@@@@%........%@@@@.........@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x09, 0xed, 0x50, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf8,  //@@@@@%.........%@@+.........@@@@@%
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf8,  //@@@@@%......................@@@@@%
    0xff, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xf7,  //@@@@@%......................@@@@@+
    0xdf, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xf6,  //@@@@@@......................@@@@@+
    0xaf, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf3,  //%@@@@@.....................%@@@@@.
    0x7f, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xf0,  //+@@@@@+....................@@@@@@.
    0x2f, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xb0,  //.@@@@@@...................+@@@@@%.
    0x0c, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0x50,  //.@@@@@@%..................@@@@@@+.
    0x04, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xfd, 0x00,  //.+@@@@@@+................%@@@@@@..
    0x00, 0xbf, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0xf4, 0x00,  //..%@@@@@@+..............%@@@@@@+..
    0x00, 0x2f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xff, 0xb0, 0x00,  //...@@@@@@@%............@@@@@@@%...
    0x00, 0x06, 0xff, 0xff, 0xff, 0xfe, 0x61, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x00,  //...+@@@@@@@@+........%@@@@@@@@....
    0x00, 0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xda, 0x9a, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x00, 0x00,  //....%@@@@@@@@@@%%%%@@@@@@@@@@.....
    0x00, 0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x30, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x02, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@@@@@@@@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x04, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x10, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@@@@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x6a, 0xde, 0xff, 0xec, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+%@@@@@@%+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f013 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............%@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............@@@@@@@..............
    0x00, 0x00, 0x00, 0x9f, 0x60, 0x00, 0x0f, 0xff, 0xff, 0xff, 0x10, 0x00, 0x4e, 0xa0, 0x00, 0x00, 0x00,  //......%@+....@@@@@@@....+@%.......
    0x00, 0x00, 0x0a, 0xff, 0xf9, 0x00, 0x4f, 0xff, 0xff, 0xff, 0x50, 0x08, 0xff, 0xfb, 0x00, 0x00, 0x00,  //.....%@@@%..+@@@@@@@+..%@@@%......
    0x00, 0x00, 0xaf, 0xff, 0xff, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xcf, 0xff, 0xff, 0xb0, 0x00, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@@@@@@@@@+....
    0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0x94, 0x23, 0x8f, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00,  //.....@@@@@@@@@%+..%@@@@@@@@@......
    0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xe3, 0x00, 0x00, 0x02, 0xdf, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00,  //.....@@@@@@@@.......@@@@@@@@+.....
    0x48, 0xbd, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x2f, 0xff, 0xff, 0xff, 0xfc, 0x97, 0x30,  //+%%@@@@@@@@@.........@@@@@@@@@%+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,  //@@@@@@@@@@@%.........%@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,  //@@@@@@@@@@@+..........@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,  //@@@@@@@@@@@...........@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,  //@@@@@@@@@@@...........@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,  //@@@@@@@@@@@+..........@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,  //@@@@@@@@@@@%.........%@@@@@@@@@@@.
    0x37, 0x9c, 0xef, 0xff, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x2f, 0xff, 0xff, 0xff, 0xfe, 0xb9, 0x50,  //.+%%@@@@@@@@.........@@@@@@@@@%%+.
    0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xe3, 0x00, 0x00, 0x02, 0xdf, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00,  //.....@@@@@@@@.......@@@@@@@@+.....
    0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0x94, 0x23, 0x8f, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00,  //.....@@@@@@@@@%+..%@@@@@@@@@......
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@@@@@@@@@+....
    0x00, 0x0d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x9f, 0xff, 0xff, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xbf, 0xff, 0xff, 0xc0, 0x00, 0x00,  //....%@@@@@@@@@@@@@@@@@%@@@@@@.....
    0x00, 0x00, 0x09, 0xff, 0xf9, 0x00, 0x3f, 0xff, 0xff, 0xff, 0x60, 0x08, 0xff, 0xfc, 0x10, 0x00, 0x00,  //.....%@@@%...@@@@@@@+..%@@@@......
    0x00, 0x00, 0x00, 0x8f, 0x60, 0x00, 0x0f, 0xff, 0xff, 0xff, 0x20, 0x00, 0x4e, 0xb0, 0x00, 0x00, 0x00,  //......%@+....@@@@@@@....+@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............@@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............%@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f014 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xdd, 0xdd, 0xdd, 0xdb, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@@@@@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@@@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x9f, 0xf7, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00,  //........%@@+.......@@@.........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x05, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00,  //........@@@........+@@%........
    0x00, 0x00, 0x00, 0x06, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.......+@@%.........@@@........
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xbd, 0xdf, 0xfe, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdf, 0xff, 0xdd, 0x60,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xfd, 0x00, 0x00,  //...@@%...................@@@...
    0x00, 0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xfd, 0x00, 0x00,  //...@@%...................@@@...
    0x00, 0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xfd, 0x00, 0x00,  //...@@%...................@@@...
    0x00, 0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xfd, 0x00, 0x00,  //...@@%...................@@@...
    0x00, 0x3f, 0xf8, 0x00, 0x8f, 0xe0, 0x00, 0xef, 0x80, 0x05, 0xff, 0x20, 0x0e, 0xfd, 0x00, 0x00,  //...@@%..+@@...@@%..+@@...@@@...
    0x00, 0x3f, 0xf8, 0x00, 0xaf, 0xf2, 0x01, 0xff, 0xb0, 0x07, 0xff, 0x40, 0x0e, 0xfd, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x3f, 0xf8, 0x00, 0xaf, 0xf2, 0x01, 0xff, 0xb0, 0x07, 0xff, 0x40, 0x0e, 0xfd, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x3f, 0xf8, 0x00, 0xaf, 0xf2, 0x01, 0xff, 0xb0, 0x07, 0xff, 0x40, 0x0e, 0xfd, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x3f, 0xf8, 0x00, 0xaf, 0xf2, 0x01, 0xff, 0xb0, 0x07, 0xff, 0x40, 0x0e, 0xfd, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x3f, 0xf8, 0x00, 0xaf, 0xf2, 0x01, 0xff, 0xb0, 0x07, 0xff, 0x40, 0x0e, 0xfd, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x3f, 0xf8, 0x00, 0xaf, 0xf2, 0x01, 0xff, 0xb0, 0x07, 0xff, 0x40, 0x0e, 0xfd, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x3f, 0xf8, 0x00, 0xaf, 0xf2, 0x01, 0xff, 0xb0, 0x07, 0xff, 0x40, 0x0e, 0xfd, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x3f, 0xf8, 0x00, 0xaf, 0xf2, 0x01, 0xff, 0xb0, 0x07, 0xff, 0x40, 0x0e, 0xfd, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x3f, 0xf8, 0x00, 0xaf, 0xf2, 0x01, 0xff, 0xb0, 0x07, 0xff, 0x40, 0x0e, 0xfd, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x3f, 0xf8, 0x00, 0xaf, 0xf2, 0x01, 0xff, 0xb0, 0x07, 0xff, 0x40, 0x0e, 0xfd, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x3f, 0xf8, 0x00, 0xaf, 0xf2, 0x01, 0xff, 0xb0, 0x07, 0xff, 0x40, 0x0e, 0xfd, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x3f, 0xf8, 0x00, 0xaf, 0xf2, 0x01, 0xff, 0xb0, 0x07, 0xff, 0x40, 0x0e, 0xfd, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x3f, 0xf8, 0x00, 0x7e, 0xd0, 0x00, 0xde, 0x80, 0x05, 0xee, 0x20, 0x0e, 0xfd, 0x00, 0x00,  //...@@%..+@@...@@%..+@@...@@@...
    0x00, 0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xfd, 0x00, 0x00,  //...@@%...................@@@...
    0x00, 0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xfd, 0x00, 0x00,  //...@@%...................@@@...
    0x00, 0x3f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //...@@%...................@@@...
    0x00, 0x1f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xfb, 0x00, 0x00,  //...@@@..................+@@%...
    0x00, 0x0d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@@@@+...
    0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x3b, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd9, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f015 () , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xae, 0xb2, 0x00, 0x00, 0x5d, 0xdd, 0xdb, 0x00, 0x00, 0x00,  //................%@%.....+@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0x40, 0x00, 0x9f, 0xff, 0xff, 0x00, 0x00, 0x00,  //...............@@@@@+...%@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x9f, 0xff, 0xff, 0x00, 0x00, 0x00,  //.............+@@@@@@@+..%@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x80, 0x9f, 0xff, 0xff, 0x00, 0x00, 0x00,  //............+@@@@@@@@@%.%@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xb1, 0x8f, 0xff, 0xfb, 0x9f, 0xff, 0xff, 0x00, 0x00, 0x00,  //...........%@@@@%.%@@@@%%@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x01, 0xcf, 0xff, 0xf9, 0x01, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..........@@@@@%...+@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x2d, 0xff, 0xff, 0x60, 0x5f, 0x80, 0x3e, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.........@@@@@+.+@%..@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xe4, 0x08, 0xff, 0xfb, 0x02, 0xdf, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.......+@@@@@..+@@@%..@@@@@@@@.....
    0x00, 0x00, 0x00, 0x7f, 0xff, 0xfd, 0x20, 0xaf, 0xff, 0xff, 0xd1, 0x0b, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //......+@@@@@..%@@@@@@..%@@@@@@.....
    0x00, 0x00, 0x09, 0xff, 0xff, 0xb0, 0x1c, 0xff, 0xff, 0xff, 0xfe, 0x30, 0x9f, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....%@@@@%..@@@@@@@@@..%@@@@@.....
    0x00, 0x01, 0xcf, 0xff, 0xf9, 0x03, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x06, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....@@@@@%..@@@@@@@@@@@+.+@@@@@....
    0x00, 0x2d, 0xff, 0xff, 0x60, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x4f, 0xff, 0xfe, 0x30, 0x00,  //...@@@@@+.+@@@@@@@@@@@@@%.+@@@@@...
    0x04, 0xff, 0xff, 0xe4, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x02, 0xdf, 0xff, 0xf5, 0x00,  //.+@@@@@..+@@@@@@@@@@@@@@@%..@@@@@+.
    0x6f, 0xff, 0xfd, 0x20, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x1c, 0xff, 0xff, 0x80,  //+@@@@@..%@@@@@@@@@@@@@@@@@@..@@@@@+
    0xcf, 0xff, 0xb0, 0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x30, 0xaf, 0xff, 0xd0,  //@@@@%..@@@@@@@@@@@@@@@@@@@@@..%@@@@
    0x2e, 0xf9, 0x03, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x07, 0xff, 0x20,  //.@@%..@@@@@@@@@@@@@@@@@@@@@@@+.+@@.
    0x02, 0x50, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x43, 0x00,  //..+..%@@@@@@@@@@@@@@@@@@@@@@@@..+..
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xaa, 0xaa, 0xef, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@%%%%%@@@@@@@@@@.....
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@.....%@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+f019 () , Width: 36 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x44, 0x44, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............++++++...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xff, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x12, 0x22, 0x23, 0xff, 0xff, 0xff, 0xff, 0x62, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x00, 0x00, 0x00,  //.......%@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@@@@@@@@@@@%.......
    0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@@@@@@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@@@@@@@@@@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@@@@@@@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+@@@@@@@@@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+@@@@@@@@@@%............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@@@@%.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............+@@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............+@@@@%...............
    0x4d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x4f, 0xf8, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4,  //.@@@@@@@@@@@%...+@@%...+@@@@@@@@@@@.
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x02, 0x30, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //@@@@@@@@@@@@@%........%@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@......%@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x51, 0x04, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@+..+@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x9d, 0xff, 0xfc, 0xcf, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@%@@@@%%@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x01, 0xff, 0xe0, 0x0e, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@...@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x04, 0xff, 0xf1, 0x1f, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@+.+@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x4d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................


    /*Unicode: U+f01c () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00,  //......%@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0xaf, 0xff, 0xd2, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x8f, 0xff, 0xf1, 0x00, 0x00,  //....%@@@@...............%@@@@.....
    0x00, 0x01, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xf8, 0x00, 0x00,  //....@@@@+................@@@@%....
    0x00, 0x08, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xfe, 0x00, 0x00,  //...%@@@@.................%@@@@....
    0x00, 0x0e, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0x50, 0x00,  //...@@@@%..................@@@@+...
    0x00, 0x5f, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xc0, 0x00,  //..+@@@@...................@@@@@...
    0x00, 0xcf, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xf3, 0x00,  //..@@@@@...................+@@@@...
    0x03, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xfa, 0x00,  //..@@@@+....................@@@@%..
    0x0a, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0x10,  //.%@@@@.....................+@@@@..
    0x1f, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0x80,  //.@@@@+......................@@@@%.
    0x7f, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xe0,  //+@@@@.......................%@@@@.
    0xcf, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xf3,  //@@@@%........................@@@@.
    0xff, 0xff, 0xb8, 0x88, 0x88, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x88, 0x88, 0x8f, 0xff, 0xf5,  //@@@@%%%%%%%...........+%%%%%%@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@%..........@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@.........%@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@%........@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x55, 0x55, 0x55, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@+++++++@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f021 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x34, 0x55, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............++++...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0xdf, 0xff, 0xff, 0xff, 0xea, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@@@@@@@%+...........
    0x00, 0x00, 0x00, 0x00, 0x4b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60, 0x00, 0x00, 0x1c, 0xe2,  //.........%@@@@@@@@@@@@@@+......@@.
    0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x30, 0x01, 0xdf, 0xf8,  //.......%@@@@@@@@@@@@@@@@@@....@@@%
    0x00, 0x00, 0x02, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x1d, 0xff, 0xf8,  //......@@@@@@@@@@@@@@@@@@@@@+.@@@@%
    0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //.....@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x01, 0xef, 0xff, 0xff, 0xff, 0xfa, 0x64, 0x33, 0x58, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //....@@@@@@@@@%+...+%@@@@@@@@@@@@@%
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xf8, 0x10, 0x00, 0x00, 0x00, 0x03, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf8,  //...%@@@@@@@%..........%@@@@@@@@@@%
    0x00, 0x7f, 0xff, 0xff, 0xfd, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xf8,  //..+@@@@@@@.............+@@@@@@@@@%
    0x00, 0xef, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xff, 0xff, 0xf8,  //..@@@@@@@...............@@@@@@@@@%
    0x07, 0xff, 0xff, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xf8,  //.+@@@@@@...............@@@@@@@@@@%
    0x0e, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf8,  //.@@@@@@+..............@@@@@@@@@@@%
    0x3f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //.@@@@@@..............@@@@@@@@@@@@%
    0x8f, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //%@@@@@+..............@@@@@@@@@@@@+
    0x28, 0x88, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x88, 0x88, 0x88, 0x88, 0x88, 0x60,  //.%%%%+................%%%%%%%%%%+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x7e, 0xee, 0xee, 0xee, 0xee, 0xec, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xee, 0xee, 0xb0,  //+@@@@@@@@@@@...............+@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@+..............@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x70,  //@@@@@@@@@@@@..............+@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xef, 0xff, 0xff, 0x20,  //@@@@@@@@@@@...............@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xfa, 0x00,  //@@@@@@@@@@...............%@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0xf2, 0x00,  //@@@@@@@@@+..............%@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xff, 0x90, 0x00,  //@@@@@@@@@@%............@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x61, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,  //@@@@@@@@@@@@+........%@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x99, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00,  //@@@@@@@@@@@@@@@%%%%@@@@@@@@@@.....
    0xff, 0xff, 0xeb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00,  //@@@@@%@@@@@@@@@@@@@@@@@@@@@@......
    0xff, 0xfe, 0x20, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00, 0x00,  //@@@@..+@@@@@@@@@@@@@@@@@@@@.......
    0xef, 0xe2, 0x00, 0x03, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@@@@@@@@@@@@@@@@+........
    0x38, 0x20, 0x00, 0x00, 0x05, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x10, 0x00, 0x00, 0x00, 0x00,  //.%.......+@@@@@@@@@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x7a, 0xdf, 0xfe, 0xdc, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+%@@@@@@%+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f026 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xcf, 0x60,  //..............@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xb0,  //.............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xb0,  //............@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xff, 0xb0,  //...........@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xff, 0xb0,  //..........@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xff, 0xff, 0xb0,  //.........@@@@@@@%
    0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xff, 0xff, 0xb0,  //........@@@@@@@@%
    0x27, 0x77, 0x77, 0x7d, 0xff, 0xff, 0xff, 0xff, 0xb0,  //.++++++@@@@@@@@@%
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@%
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@%
    0x49, 0xaa, 0xaa, 0xae, 0xff, 0xff, 0xff, 0xff, 0xb0,  //+%%%%%%@@@@@@@@@%
    0x00, 0x00, 0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0xb0,  //........@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xb0,  //.........@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xff, 0xff, 0xb0,  //..........@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xb0,  //...........@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xff, 0xb0,  //............@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xb0,  //.............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0x80,  //..............@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f027 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xcf, 0x60, 0x00, 0x00, 0x00, 0x00,  //..............@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //.............@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //............@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@%........
    0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@@%........
    0x27, 0x77, 0x77, 0x7d, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x01, 0x00, 0x00,  //.++++++@@@@@@@@@%........
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x01, 0xef, 0x80, 0x00,  //@@@@@@@@@@@@@@@@%...@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x03, 0xff, 0xfa, 0x00,  //@@@@@@@@@@@@@@@@%...@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x7f, 0xff, 0x40,  //@@@@@@@@@@@@@@@@%...+@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x05, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@%....+@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0xef, 0xe0,  //@@@@@@@@@@@@@@@@%.....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0xef, 0xe0,  //@@@@@@@@@@@@@@@@%.....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x04, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@%....+@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x5f, 0xff, 0x50,  //@@@@@@@@@@@@@@@@%...+@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x03, 0xff, 0xfb, 0x00,  //@@@@@@@@@@@@@@@@%...@@@%.
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x02, 0xff, 0xa0, 0x00,  //@@@@@@@@@@@@@@@@%...@@%..
    0x49, 0xaa, 0xaa, 0xae, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x22, 0x00, 0x00,  //+%%%%%%@@@@@@@@@%........
    0x00, 0x00, 0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //............@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //.............@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0x80, 0x00, 0x00, 0x00, 0x00,  //..............@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f028 () , Width: 36 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0x91, 0x00, 0x00, 0x00, 0x00,  //........................%@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0x70, 0x00, 0x00, 0x00,  //........................@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x20, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xfc, 0x10, 0x00, 0x00,  //..............+%........+@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xd1, 0x00, 0x00,  //.............%@@%.........%@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xef, 0xfd, 0x00, 0x00,  //............%@@@%...........@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x9d, 0x70, 0x00, 0x1d, 0xff, 0xa0, 0x00,  //...........+@@@@%.....%@+....@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0xb0, 0x00, 0x02, 0xff, 0xfd, 0x30, 0x02, 0xef, 0xf5, 0x00,  //..........+@@@@@%.....@@@@....@@@+..
    0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x9f, 0xff, 0xf5, 0x00, 0x5f, 0xfe, 0x00,  //.........+@@@@@@%.....%@@@@+..+@@@..
    0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x03, 0xcf, 0xff, 0x40, 0x0b, 0xff, 0x70,  //........+@@@@@@@%.......@@@@+..%@@+.
    0x01, 0x11, 0x11, 0x18, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xe1, 0x02, 0xff, 0xd0,  //.......+@@@@@@@@%........%@@@...@@@.
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x01, 0xa9, 0x10, 0x00, 0xcf, 0xf9, 0x00, 0xcf, 0xf3,  //%@@@@@@@@@@@@@@@%...%%....@@@%..%@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x07, 0xff, 0xf3, 0x00, 0x2f, 0xff, 0x10, 0x6f, 0xf7,  //@@@@@@@@@@@@@@@@%..+@@@....@@@..+@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x02, 0xef, 0xff, 0x10, 0x0a, 0xff, 0x60, 0x2f, 0xfb,  //@@@@@@@@@@@@@@@@%...@@@@...%@@+..@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x1b, 0xff, 0x90, 0x04, 0xff, 0xa0, 0x0f, 0xfd,  //@@@@@@@@@@@@@@@@%....%@@%..+@@%..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x01, 0xff, 0xd0, 0x01, 0xff, 0xc0, 0x0e, 0xfe,  //@@@@@@@@@@@@@@@@%.....@@@...@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0xff, 0xd0, 0x0d, 0xff,  //@@@@@@@@@@@@@@@@%.....@@@...@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x01, 0xff, 0xd0, 0x01, 0xff, 0xc0, 0x0e, 0xfe,  //@@@@@@@@@@@@@@@@%.....@@@...@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x1c, 0xff, 0x80, 0x04, 0xff, 0xa0, 0x0f, 0xfd,  //@@@@@@@@@@@@@@@@%....@@@%..+@@%..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x02, 0xef, 0xfe, 0x10, 0x0a, 0xff, 0x60, 0x2f, 0xfb,  //@@@@@@@@@@@@@@@@%...@@@@...%@@+..@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x06, 0xff, 0xe3, 0x00, 0x2f, 0xff, 0x10, 0x7f, 0xf7,  //@@@@@@@@@@@@@@@@%..+@@@....@@@..+@@+
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x98, 0x10, 0x00, 0xcf, 0xf9, 0x00, 0xcf, 0xf3,  //%@@@@@@@@@@@@@@@%...%%....@@@%..@@@.
    0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xe1, 0x03, 0xff, 0xd0,  //.......+@@@@@@@@%........%@@@...@@@.
    0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x04, 0xdf, 0xff, 0x30, 0x0b, 0xff, 0x70,  //........+@@@@@@@%......+@@@@...%@@+.
    0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0xaf, 0xff, 0xf4, 0x00, 0x5f, 0xfe, 0x00,  //.........+@@@@@@%.....%@@@@+..+@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xb0, 0x00, 0x02, 0xff, 0xfd, 0x30, 0x02, 0xff, 0xf5, 0x00,  //..........+@@@@@%.....@@@@....@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x9c, 0x60, 0x00, 0x2e, 0xff, 0xa0, 0x00,  //...........+@@@@%.....%@+....@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x04, 0xef, 0xfd, 0x00, 0x00,  //............+@@@%...........@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x01, 0x9f, 0xff, 0xd1, 0x00, 0x00,  //.............+@@%.........%@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0x20, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xfb, 0x10, 0x00, 0x00,  //..............+%........+@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0x70, 0x00, 0x00, 0x00,  //........................@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x91, 0x00, 0x00, 0x00, 0x00,  //........................+@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................


    /*Unicode: U+f03e () , Width: 42 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x03, 0xad, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xda, 0x20,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xe1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@....................................@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@....................................@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@....................................@@@
    0xff, 0xd0, 0x00, 0x05, 0xdf, 0xfb, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@....+@@@%...........................@@@
    0xff, 0xd0, 0x00, 0x6f, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@...+@@@@@@..........................@@@
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@...@@@@@@@%.........................@@@
    0xff, 0xd0, 0x04, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@..+@@@@@@@@.............+...........@@@
    0xff, 0xd0, 0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0x40, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@..+@@@@@@@@............@@+..........@@@
    0xff, 0xd0, 0x01, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@...@@@@@@@%...........@@@@+.........@@@
    0xff, 0xd0, 0x00, 0x9f, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@...%@@@@@@...........@@@@@@+........@@@
    0xff, 0xd0, 0x00, 0x08, 0xff, 0xfe, 0x40, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@....%@@@@+..........@@@@@@@@+.......@@@
    0xff, 0xd0, 0x00, 0x00, 0x13, 0x30, 0x00, 0x00, 0x00, 0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x0f, 0xfd,  //@@@...................@@@@@@@@@@+......@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x0f, 0xfd,  //@@@..................@@@@@@@@@@@@+.....@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x0f, 0xfd,  //@@@.................@@@@@@@@@@@@@@+....@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0xa2, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x0f, 0xfd,  //@@@.........%......@@@@@@@@@@@@@@@@+...@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x0c, 0xfe, 0x20, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x0f, 0xfd,  //@@@........@@@....@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xe2, 0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0f, 0xfd,  //@@@.......@@@@@..@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xd0, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xfe, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0f, 0xfd,  //@@@......@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xd0, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0f, 0xfd,  //@@@.....@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xd0, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0f, 0xfd,  //@@@....@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xd0, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0f, 0xfd,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xd0, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0f, 0xfd,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xd0, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0f, 0xfd,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xd0, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0f, 0xfd,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xd0, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0f, 0xfd,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xd0, 0x01, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x0f, 0xfd,  //@@@....................................@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@....................................@@@
    0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@....................................@@@
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x03, 0xad, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xda, 0x20,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................


    /*Unicode: U+f040 () , Width: 33 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xc1, 0x00, 0x00, 0x00,  //.......................%@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xfd, 0x10, 0x00, 0x00,  //......................%@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xff, 0xd1, 0x00, 0x00,  //.....................%@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x00,  //....................%@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x00,  //....................@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,  //.....................@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xe2, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //.................%@...@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xfe, 0x20, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //................%@@@...@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xe2, 0x03, 0xff, 0xff, 0xff, 0xff, 0xd0,  //...............%@@@@@...@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0x8d, 0xfe, 0x20, 0x3f, 0xff, 0xff, 0xff, 0x50,  //..............%@@@%@@@...@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xf7, 0x3f, 0xff, 0xe2, 0x03, 0xff, 0xff, 0xf6, 0x00,  //.............%@@@+.@@@@...@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0x73, 0xef, 0xff, 0xfe, 0x20, 0x3f, 0xff, 0x60, 0x00,  //............%@@@+.@@@@@@...@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xf7, 0x3e, 0xff, 0xff, 0xff, 0xe2, 0x03, 0xf6, 0x00, 0x00,  //...........%@@@+.@@@@@@@@...@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0x73, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x10, 0x00, 0x00,  //..........%@@@+.@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xf7, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00,  //.........%@@@+.@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0x73, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00,  //........%@@@+.@@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x0b, 0xff, 0xf7, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00,  //.......%@@@+.@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0xbf, 0xff, 0x73, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00,  //......%@@@+.@@@@@@@@@@@@+........
    0x00, 0x00, 0x0b, 0xff, 0xf7, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@+.@@@@@@@@@@@@+.........
    0x00, 0x00, 0xbf, 0xff, 0x73, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@@+.@@@@@@@@@@@@+..........
    0x00, 0x0b, 0xff, 0xf7, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@+.@@@@@@@@@@@@+...........
    0x00, 0xbf, 0xff, 0xa3, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@%.@@@@@@@@@@@@+............
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@+.............
    0xbf, 0xff, 0x49, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@+%@@@@@@@@@@@@+..............
    0xff, 0xf4, 0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+..%@@@@@@@@@@+...............
    0xff, 0xd0, 0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@....%@@@@@@@@+................
    0xff, 0xd0, 0x00, 0x00, 0x9f, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....%@@@@@@+.................
    0xff, 0xfc, 0xc7, 0x00, 0x09, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@+...%@@@@+..................
    0xff, 0xff, 0xfa, 0x00, 0x08, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@%...%@@@+...................
    0xff, 0xff, 0xfa, 0x00, 0x8f, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@%..%@@@+....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@+.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@+......................
    0xdd, 0xdd, 0xdd, 0xdd, 0xd7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@+.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................


    /*Unicode: U+f048 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x16, 0x66, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x10,  //.++++..................
    0xdf, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x40,  //@@@@@+..............+@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0x40,  //@@@@@%.............+@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x40,  //@@@@@%............+@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0x40,  //@@@@@%...........+@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0x40,  //@@@@@%..........+@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0x40,  //@@@@@%.........+@@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0x40,  //@@@@@%........+@@@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@%.......+@@@@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@%......+@@@@@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@%.....+@@@@@@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@%....+@@@@@@@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@%...+@@@@@@@@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@%..+@@@@@@@@@@@@@+
    0xff, 0xff, 0xf9, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@%.+@@@@@@@@@@@@@@+
    0xff, 0xff, 0xf9, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@%+@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xfa, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@%@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xf9, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@%.@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xf9, 0x01, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@%..@@@@@@@@@@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@%...@@@@@@@@@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x01, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@%....@@@@@@@@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@%.....@@@@@@@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@%......@@@@@@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@%.......@@@@@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xff, 0xff, 0x40,  //@@@@@%........@@@@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xff, 0xff, 0x40,  //@@@@@%.........@@@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xff, 0x40,  //@@@@@%..........@@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xff, 0x40,  //@@@@@%...........@@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0x40,  //@@@@@%............@@@@+
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xff, 0x40,  //@@@@@%.............@@@+
    0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0x40,  //@@@@@%..............@@+
    0x9f, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x30,  //%@@@@................@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f04b () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%+.............................
    0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+...........................
    0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@+.........................
    0xff, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%........................
    0xff, 0xff, 0xff, 0xff, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@%......................
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@+..................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@+................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@%...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@%.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@+.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@+.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@%......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x91, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x40,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd5, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@+.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@%.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@%...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@+..............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@+................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@%..................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%....................
    0xff, 0xff, 0xff, 0xff, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@......................
    0xff, 0xff, 0xff, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@+.......................
    0xff, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@+.........................
    0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%...........................
    0xda, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@%.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f04c () , Width: 33 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x16, 0x66, 0x66, 0x66, 0x66, 0x66, 0x61, 0x00, 0x00, 0x01, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x10,  //.++++++++++++.......++++++++++++.
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //%@@@@@@@@@@@@+.....+@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................


    /*Unicode: U+f04d () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x16, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x40,  //.++++++++++++++++++++++++++++++++.
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f051 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x66, 0x65, 0x00,  //..................++++.
    0xbd, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0x60,  //%@...............@@@@@+
    0xbf, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@..............@@@@@%
    0xbf, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@.............@@@@@%
    0xbf, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@............@@@@@%
    0xbf, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@...........@@@@@%
    0xbf, 0xff, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@..........@@@@@%
    0xbf, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@@.........@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@@@........@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@@@@.......@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@@@@@......@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@.....@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@....@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@...@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@..@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x1f, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@.@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@+@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@+.@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@+..@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@+...@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@+....@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@@@@@+.....@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@@@@+......@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@@@+.......@@@@@%
    0xbf, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@@+........@@@@@%
    0xbf, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@@+.........@@@@@%
    0xbf, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@@+..........@@@@@%
    0xbf, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@@+...........@@@@@%
    0xbf, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@@+............@@@@@%
    0xbf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@@+.............@@@@@%
    0xbf, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //%@+..............@@@@@%
    0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xfe, 0x30,  //%+...............%@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f052 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xeb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............+@%................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............+@@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+@@@@@@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+@@@@@@@@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@@@@@@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@@@@@@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@@@@@@@@.........
    0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@@@@@@@@@........
    0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xbd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd4,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x15, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x30,  //.+++++++++++++++++++++++++++++++..
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f053 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xc1, 0x00, 0x00,  //.................@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xfd, 0x10, 0x00,  //................@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xd1, 0x00,  //...............@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xfd, 0x10,  //..............@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xb0,  //.............@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //............@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,  //...........@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x00,  //..........@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x00,  //.........@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x00, 0x00,  //........@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00,  //.......@@@@@@@@@@@.....
    0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@......
    0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@.......
    0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@........
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@.........
    0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@@@@..........
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@...........
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@@............
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@...........
    0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@@@@@@@..........
    0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x10, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@@@@@@.........
    0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@........
    0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x10, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@.......
    0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x10, 0x00, 0x00,  //......+@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //.......+@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x10, 0x00,  //........+@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00,  //.........+@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x10,  //..........+@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //...........+@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xc0,  //............+@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xfe, 0x20,  //.............+@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xe2, 0x00,  //..............+@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xfe, 0x20, 0x00,  //...............+@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xd2, 0x00, 0x00,  //................+@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f054 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x02, 0xdd, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@.................
    0x00, 0x2e, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@................
    0x02, 0xef, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@...............
    0x2e, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@..............
    0xef, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@.............
    0xef, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@............
    0x2e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@...........
    0x02, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@@@@..........
    0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@.........
    0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@........
    0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@.......
    0x00, 0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00,  //.......@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00,  //........@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00,  //.........@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00,  //..........@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10,  //...........@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //...........+@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20,  //...........@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00,  //..........@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00,  //.........@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00,  //........@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00,  //.......@@@@@@@@@@@.....
    0x00, 0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@......
    0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@.......
    0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@........
    0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@.........
    0x02, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@@@@..........
    0x2e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@...........
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@............
    0xef, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@.............
    0x3f, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@..............
    0x03, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@...............
    0x00, 0x3f, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@................
    0x00, 0x03, 0xee, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f067 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xaa, 0xa9, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+%%%%%+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@@@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x05, 0x77, 0x77, 0x77, 0x77, 0x7e, 0xff, 0xff, 0xff, 0xfb, 0x77, 0x77, 0x77, 0x77, 0x73, 0x00,  //.++++++++++@@@@@@@@%+++++++++..
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x2b, 0xdd, 0xdd, 0xdd, 0xdd, 0xdf, 0xff, 0xff, 0xff, 0xfe, 0xdd, 0xdd, 0xdd, 0xdd, 0xd9, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xdf, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@@@@%............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f068 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x03, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x51, 0x00,  //..+++++++++++++++++++++++++++..
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x4d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f071 () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xef, 0xe4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................+@@@+.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................@@@@@.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................%@@@@@%................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................@@@@@@@................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............%@@@@@@@%...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............@@@@@@@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............@@@@@@@@@@@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+@@@@@@@@@@@@@+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@@@@@@@@@@@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0x80, 0x00, 0x00, 0x8f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+@@@@%.....%@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0x60, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@+.....+@@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xff, 0xff, 0x60, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@+.....+@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@@+.....+@@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x8f, 0xff, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@@@@+.....%@@@@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@%.....%@@@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x9f, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@@%.....%@@@@@@@@........
    0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0xaf, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@%.....%@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00, 0xaf, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@%.....%@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00,  //......+@@@@@@@@@%.....%@@@@@@@@@+......
    0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@.....@@@@@@@@@@@......
    0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xdd, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x00, 0x00,  //....@@@@@@@@@@@@@.....@@@@@@@@@@@@@....
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00,  //...%@@@@@@@@@@@@%.....%@@@@@@@@@@@@%...
    0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x00,  //...@@@@@@@@@@@@@%.....%@@@@@@@@@@@@@...
    0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //..@@@@@@@@@@@@@@%.....%@@@@@@@@@@@@@@..
    0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00,  //.+@@@@@@@@@@@@@@%.....%@@@@@@@@@@@@@@+.
    0x0d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x88, 0x89, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00,  //.@@@@@@@@@@@@@@@@%%%%%@@@@@@@@@@@@@@@@.
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................


    /*Unicode: U+f074 () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x30, 0x00, 0x00, 0x00,  //...............................@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xe3, 0x00, 0x00, 0x00,  //..............................+@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfe, 0x30, 0x00, 0x00,  //..............................+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xe3, 0x00, 0x00,  //..............................+@@@@....
    0x01, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x6f, 0xff, 0xfe, 0x30, 0x00,  //..............................+@@@@@...
    0xef, 0xff, 0xff, 0xfe, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x00,  //@@@@@@@@%+...........+@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x30,  //@@@@@@@@@@@+.......%@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@+.....%@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //@@@@@@@@@@@@@+...%@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00,  //@@@@@@@@@@@@@@..%@@@@@@@@@@@@@@@@@@@@+.
    0x57, 0x77, 0x77, 0x8d, 0xff, 0xff, 0xff, 0x14, 0xff, 0xff, 0xff, 0xfb, 0x87, 0x77, 0x77, 0xaf, 0xff, 0xff, 0x70, 0x00,  //++++++%@@@@@@@.+@@@@@@@%++++++%@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xf8, 0x0d, 0xff, 0xff, 0xfd, 0x20, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xf7, 0x00, 0x00,  //........+@@@@+.@@@@@@@........+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xe0, 0x6f, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x70, 0x00, 0x00,  //.........+@@@.+@@@@@@.........+@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0x80, 0xef, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xf7, 0x00, 0x00, 0x00,  //..........%@%.@@@@@@+.........+@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x15, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x70, 0x00, 0x00, 0x00,  //...........@.+@@@@@@..........+@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00,  //...........+.@@@@@@+...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............@@@@@@....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............%@@@@@+....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@@@@.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xf7, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,  //...........%@@@@@+.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xf1, 0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x60, 0x00, 0x00, 0x00,  //...........@@@@@@.+%..........+@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x90, 0xdf, 0x40, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xf6, 0x00, 0x00, 0x00,  //..........%@@@@@%.@@+.........+@@+.....
    0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0x14, 0xff, 0xe1, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x60, 0x00, 0x00,  //.........+@@@@@@.+@@@.........+@@@+....
    0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xf8, 0x0c, 0xff, 0xfc, 0x10, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xf6, 0x00, 0x00,  //........+@@@@@@%.@@@@@........+@@@@+...
    0x35, 0x55, 0x55, 0x7b, 0xff, 0xff, 0xff, 0xe0, 0x5f, 0xff, 0xff, 0xf9, 0x65, 0x55, 0x55, 0x9f, 0xff, 0xff, 0x60, 0x00,  //.++++++%@@@@@@@.+@@@@@@%++++++%@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00,  //@@@@@@@@@@@@@@+.%@@@@@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@@@@@@+...@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x01, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@%.....@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe5, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@+.......%@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xc7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00,  //@@@@@@@@@+...........%@@@@@@@@@@@@@@@..
    0x23, 0x33, 0x33, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x33, 0x33, 0x7f, 0xff, 0xff, 0x40, 0x00,  //..............................+@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xf4, 0x00, 0x00,  //..............................+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x40, 0x00, 0x00,  //..............................+@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xf4, 0x00, 0x00, 0x00,  //..............................+@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x40, 0x00, 0x00, 0x00,  //..............................+@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................


    /*Unicode: U+f077 () , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................+@+................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............%@@@%...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............%@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............%@@@@@@@%.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............%@@@@@@@@@%............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@@@@@@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@@@@@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@@@@@@@@@@@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@@@@@@@@@@@@@%........
    0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.......%@@@@@@@@@@@@@@@@@@@%.......
    0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,  //......%@@@@@@@@@@@@@@@@@@@@@%......
    0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@%.%@@@@@@@@@@%.....
    0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00,  //....%@@@@@@@@@@%...%@@@@@@@@@@%....
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@@@@@%.....%@@@@@@@@@@%...
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //..%@@@@@@@@@@%.......%@@@@@@@@@@%..
    0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //.%@@@@@@@@@@%.........%@@@@@@@@@@%.
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@%...........%@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@%.............%@@@@@@@@@@
    0x9f, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0x90,  //%@@@@@@@@%...............%@@@@@@@@%
    0x0a, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0xfa, 0x00,  //.%@@@@@@%.................%@@@@@@%.
    0x00, 0xaf, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@%...................%@@@@%..
    0x00, 0x0a, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfa, 0x00, 0x00,  //...%@@%.....................%@@%...
    0x00, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x60, 0x00, 0x00,  //....++.......................++....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+f078 () , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x01, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xa1, 0x00, 0x00,  //....%%.......................%%....
    0x00, 0x1d, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xfd, 0x10, 0x00,  //...@@@@.....................@@@@...
    0x01, 0xdf, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xd1, 0x00,  //..@@@@@@...................@@@@@@..
    0x1d, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xfd, 0x10,  //.@@@@@@@@.................@@@@@@@@.
    0xcf, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@...............@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.............@@@@@@@@@@@
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //+@@@@@@@@@@@...........@@@@@@@@@@@+
    0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00,  //.+@@@@@@@@@@@.........@@@@@@@@@@@+.
    0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00,  //..+@@@@@@@@@@@.......@@@@@@@@@@@+..
    0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00,  //...+@@@@@@@@@@@.....@@@@@@@@@@@+...
    0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00,  //....+@@@@@@@@@@@...@@@@@@@@@@@+....
    0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@.@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@@@@@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@@@@@@@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@@@@@@@@@@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+@@@@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+@@@@@@@@@+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............+@@@@@+..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............+@@@+...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................%.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+f079 () , Width: 42 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x0a, 0xf6, 0x00, 0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x00, 0x00,  //.......%@+....@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x8f, 0xff, 0x40, 0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00,  //......%@@@+...%@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x06, 0xff, 0xff, 0xf2, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00,  //.....+@@@@@....%@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x3f, 0xff, 0xff, 0xfd, 0x10, 0x01, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00,  //.....@@@@@@@....@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00,  //....@@@@@@@@%....@@@@@@@@@@@@@@@@@@@......
    0x00, 0x0d, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x03, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0xbf, 0xff, 0xff, 0x20, 0x00, 0x00,  //...@@@@@@@@@@%....%%%%%%%%%%%%%@@@@@......
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x20, 0x00, 0x00,  //..%@@@@@@@@@@@+...............+@@@@@......
    0x09, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x20, 0x00, 0x00,  //.%@@@@@@@@@@@@@+..............+@@@@@......
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x20, 0x00, 0x00,  //+@@@@@@@@@@@@@@@..............+@@@@@......
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x20, 0x00, 0x00,  //@@@@@@@@@@@@@@@@%.............+@@@@@......
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x20, 0x00, 0x00,  //%@@@@@@@@@@@@@@@+.............+@@@@@......
    0x01, 0x11, 0x17, 0xff, 0xff, 0xf3, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x20, 0x00, 0x00,  //.....+@@@@@...................+@@@@@......
    0x00, 0x00, 0x06, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x20, 0x00, 0x00,  //.....+@@@@@...................+@@@@@......
    0x00, 0x00, 0x06, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x22, 0x8f, 0xff, 0xff, 0x42, 0x22, 0x10,  //.....+@@@@@...................%@@@@@......
    0x00, 0x00, 0x06, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //.....+@@@@@..............%@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x06, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //.....+@@@@@..............@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x06, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,  //.....+@@@@@..............+@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x06, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //.....+@@@@@...............%@@@@@@@@@@@@@+.
    0x00, 0x00, 0x06, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00,  //.....+@@@@@................%@@@@@@@@@@@+..
    0x00, 0x00, 0x06, 0xff, 0xff, 0xfa, 0x99, 0x99, 0x99, 0x99, 0x99, 0x98, 0x10, 0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //.....+@@@@@%%%%%%%%%%%%%....@@@@@@@@@@%...
    0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@....@@@@@@@@%....
    0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x03, 0xff, 0xff, 0xff, 0xd1, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@%....@@@@@@@.....
    0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x6f, 0xff, 0xfe, 0x20, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@+...+@@@@@......
    0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x08, 0xff, 0xf4, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@+...%@@@+......
    0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0xae, 0x60, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@%....%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................


    /*Unicode: U+f07b () , Width: 37 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x16, 0x9a, 0xaa, 0xaa, 0xaa, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+%%%%%%%%%+.......................
    0x04, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@@@@@@@@@......................
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@@@@.....................
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@@@@+....................
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@%....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb1, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@%....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x09, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x5c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd7, 0x00, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................


    /*Unicode: U+f093 () , Width: 36 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................@@+................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................@@@@+...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............@@@@@@+..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............@@@@@@@@@@+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@@@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@@@@@@@+..........
    0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@@@@@@@@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@@@@@@@@@@@@+........
    0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00,  //........@@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x45, 0xff, 0xff, 0xff, 0xff, 0x74, 0x44, 0x44, 0x10, 0x00, 0x00, 0x00,  //........++++++@@@@@@@@++++++........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@..............
    0x07, 0x99, 0x99, 0x99, 0x99, 0x94, 0x00, 0x26, 0x66, 0x66, 0x63, 0x00, 0x29, 0x99, 0x99, 0x99, 0x99, 0x70,  //.+%%%%%%%%%+...++++++....%%%%%%%%%+.
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfa,  //%@@@@@@@@@@@............%@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@..........%@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb9, 0x99, 0x99, 0x9a, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@%%%%%%%%@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x07, 0xff, 0xf3, 0x3f, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@%.+@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00, 0xff, 0xe0, 0x0e, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@...@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x07, 0xff, 0xf3, 0x3f, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@%.+@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x2b, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xb2,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................


    /*Unicode: U+f095 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x48, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+%%........................
    0x00, 0x4e, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@%.......................
    0x02, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@+......................
    0x0c, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@......................
    0x4f, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@+.....................
    0xaf, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@.....................
    0xef, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%....................
    0xcf, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@%.....................
    0x8f, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@%......................
    0x3f, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@%.......................
    0x0d, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@+.......................
    0x07, 0xff, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@%.......................
    0x01, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@+......................
    0x00, 0x9f, 0xff, 0xff, 0xe1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@@@@......................
    0x00, 0x1f, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@%.....................
    0x00, 0x08, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@@@@+....................
    0x00, 0x00, 0xdf, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@+...................
    0x00, 0x00, 0x2f, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@+..................
    0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0xbf, 0x90, 0x00, 0x00, 0x00,  //.....+@@@@@@@+........%@%......
    0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0x91, 0x00, 0x00, 0x0b, 0xff, 0xfe, 0x60, 0x00, 0x00,  //......+@@@@@@@%......%@@@@+....
    0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xfe, 0x50, 0x00, 0x9f, 0xff, 0xff, 0xfd, 0x40, 0x00,  //.......+@@@@@@@@+...%@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xfb, 0x48, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x20,  //........+@@@@@@@@%+%@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //.........+@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //..........+@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //............@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //.............%@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00,  //...............%@@@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0xdf, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x00,  //.................+@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x8c, 0xff, 0xea, 0x40, 0x00, 0x00,  //....................%@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f0c4 () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x06, 0xbe, 0xfe, 0xc8, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+%@@@@%.............................
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xfc, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@@%...........................
    0x0d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,  //.@@@@@@@@@@@@+.........................
    0x7f, 0xff, 0xfa, 0x88, 0xcf, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xfd, 0x60, 0x00,  //+@@@@%%%@@@@@@%..................@@@+..
    0xdf, 0xfd, 0x10, 0x00, 0x02, 0xaf, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xfc, 0x5a, 0xfd, 0x30,  //@@@@......%@@@@+...............%@@+%@@.
    0xff, 0xf8, 0x00, 0x00, 0x00, 0x05, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xfe, 0x50, 0x00, 0x3e, 0xa0,  //@@@+.......+@@@@.............%@@+....@%
    0xef, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x06, 0xef, 0x80, 0x00, 0x01, 0xbf, 0x50,  //@@@%........+@@@+..........+@@%.....%@+
    0xbf, 0xff, 0x20, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x90, 0x00, 0x00, 0x00, 0x04, 0xcf, 0xa2, 0x00, 0x00, 0x3d, 0xe3, 0x00,  //%@@@.........@@@%.........@@%......@@..
    0x4f, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xa0, 0x00, 0x00, 0x02, 0xaf, 0xd4, 0x00, 0x00, 0x05, 0xfc, 0x10, 0x00,  //+@@@@........@@@%.......%@@+.....+@@...
    0x0b, 0xff, 0xfe, 0x60, 0x00, 0x00, 0x3f, 0xff, 0x80, 0x00, 0x00, 0x8f, 0xe6, 0x00, 0x00, 0x00, 0x9f, 0x90, 0x00, 0x00,  //.%@@@@+......@@@%.....%@@+......%@%....
    0x01, 0xdf, 0xff, 0xfe, 0x97, 0x7a, 0xff, 0xff, 0xe6, 0x00, 0x6e, 0xf9, 0x10, 0x00, 0x00, 0x1c, 0xf6, 0x00, 0x00, 0x00,  //..@@@@@@%++%@@@@@+..+@@%.......@@+.....
    0x00, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x9f, 0xbc, 0xfb, 0x20, 0x00, 0x00, 0x03, 0xee, 0x30, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@@@%@%@@%........@@.......
    0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0a, 0xfd, 0x50, 0x00, 0x00, 0x00, 0x7f, 0xc1, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@..%@@+.......+@@........
    0x00, 0x00, 0x00, 0x6b, 0xef, 0xff, 0xb9, 0xfc, 0x6f, 0x80, 0x00, 0x00, 0x00, 0x0a, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+%@@@@%%@@+@+........%@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0xff, 0x15, 0xd7, 0x00, 0x02, 0xdf, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............@@@.+@+....@@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x1c, 0xff, 0x00, 0x4e, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................@@.@@@..+@@+...........
    0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x00, 0x4d, 0xf8, 0x05, 0xc6, 0x08, 0xfb, 0xbf, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............+@@%.+@+.+@%%@+..........
    0x00, 0x00, 0x01, 0x7c, 0xff, 0xff, 0xca, 0xfb, 0x20, 0x14, 0x01, 0xbf, 0x80, 0x08, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@%@%...+..%@%..%@%.........
    0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x05, 0xef, 0xfe, 0xf5, 0x00, 0x00, 0x5f, 0xc1, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@..+@@@@@+....+@@........
    0x00, 0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xaf, 0xac, 0xff, 0x40, 0x00, 0x00, 0x02, 0xde, 0x40, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@@%@%@@@+.......@@+......
    0x01, 0xdf, 0xff, 0xfd, 0x86, 0x69, 0xff, 0xff, 0xe5, 0x00, 0x5e, 0xf8, 0x00, 0x00, 0x00, 0x0b, 0xf7, 0x00, 0x00, 0x00,  //..@@@@@@%++%@@@@@+..+@@%.......%@+.....
    0x0c, 0xff, 0xfe, 0x50, 0x00, 0x00, 0x2f, 0xff, 0x90, 0x00, 0x00, 0x7f, 0xe5, 0x00, 0x00, 0x00, 0x8f, 0xa0, 0x00, 0x00,  //.%@@@@+......@@@%.....+@@+......%@%....
    0x5f, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xa0, 0x00, 0x00, 0x01, 0xaf, 0xc3, 0x00, 0x00, 0x05, 0xfc, 0x10, 0x00,  //+@@@@........@@@%.......%@@......+@@...
    0xbf, 0xff, 0x10, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x90, 0x00, 0x00, 0x00, 0x03, 0xcf, 0xa1, 0x00, 0x00, 0x2d, 0xe4, 0x00,  //%@@@.........@@@%.........@@%......@@+.
    0xef, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x06, 0xef, 0x80, 0x00, 0x00, 0xbf, 0x50,  //@@@%........+@@@+..........+@@%.....%@+
    0xff, 0xf8, 0x00, 0x00, 0x00, 0x06, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xfe, 0x50, 0x00, 0x3e, 0xa0,  //@@@%.......+@@@@.............%@@+....@%
    0xdf, 0xfd, 0x10, 0x00, 0x02, 0xaf, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xfc, 0x5b, 0xfd, 0x30,  //@@@@......%@@@@+...............%@@+%@@.
    0x8f, 0xff, 0xfa, 0x88, 0xcf, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0xfd, 0x60, 0x00,  //%@@@@%%%@@@@@@%.................+@@@+..
    0x0d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,  //.@@@@@@@@@@@@+.........................
    0x02, 0xdf, 0xff, 0xff, 0xff, 0xfc, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@@%...........................
    0x00, 0x06, 0xbe, 0xfe, 0xc8, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+%@@@@%.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................


    /*Unicode: U+f0c5 () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x9c, 0xdd, 0xdd, 0xdd, 0xdd, 0xdb, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............%@@@@@@@@@@%...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@@@@@@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@@@@@@@@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@........@@@..............
    0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@........@@@..............
    0x00, 0x00, 0x00, 0x7f, 0xff, 0xad, 0xff, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@%@@@........@@@..............
    0x00, 0x00, 0x07, 0xff, 0xfb, 0x0d, 0xff, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@%.@@@........@@@..............
    0x00, 0x00, 0x7f, 0xff, 0xc0, 0x0d, 0xff, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@@..@@@........@@@..............
    0x00, 0x07, 0xff, 0xfd, 0x10, 0x0d, 0xff, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@...@@@........@@@..............
    0x00, 0x7f, 0xff, 0xe1, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf4, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x40,  //..+@@@@....@@@........@@@+%@@@@@@@@@@@.
    0x06, 0xff, 0xfe, 0x20, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //.+@@@@.....@@@........@@@@@@@@@@@@@@@@@
    0x2f, 0xff, 0xf3, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.@@@@......@@@........@@@@@@@@@@@@@@@@@
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //%@@@@@@@@@@@@@........@@@@@@........@@@
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@@@@@@@@@@@@.......%@@@@@@........@@@
    0xff, 0xfd, 0xdd, 0xdd, 0xdd, 0xdd, 0xb2, 0x00, 0x00, 0x00, 0xaf, 0xff, 0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@@@@@@@@@@%.......%@@@+@@@........@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xf5, 0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@................%@@@+.@@@........@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0x40, 0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@...............%@@@+..@@@........@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xf3, 0x00, 0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@..............%@@@....@@@........@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xfe, 0x30, 0x00, 0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@.............%@@@.....@@@........@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xe2, 0x00, 0x00, 0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@............%@@@......@@@........@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@...........+@@@@@@@@@@@@@........@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@...........@@@@@@@@@@@@@%........@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfd, 0xdd, 0xdd, 0xdd, 0xdd, 0xa1, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@...........@@@@@@@@@@@@%.........@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@...........@@%...................@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@...........@@%...................@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@...........@@%...................@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@...........@@%...................@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@...........@@%...................@@@
    0xff, 0xfd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@@@@@@@@@@@@@@%...................@@@
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //@@@@@@@@@@@@@@@@%...................@@@
    0x4d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //.@@@@@@@@@@@@@@@%...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //..............@@%...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //..............@@%...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //..............@@%...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //..............@@%...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //..............@@%...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf0,  //..............@@%...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..............@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //..............@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdb, 0x20,  //...............%@@@@@@@@@@@@@@@@@@@@@%.


    /*Unicode: U+f0c7 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x2b, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdb, 0x60, 0x00, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@%+.........
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x20, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@.......
    0xff, 0xd0, 0x05, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x0e, 0xff, 0x18, 0xff, 0xfe, 0x20, 0x00, 0x00,  //@@@..+@@@@@@@@.....@@@.%@@@@......
    0xff, 0xd0, 0x05, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x6f, 0xff, 0xe2, 0x00, 0x00,  //@@@..+@@@@@@@@.....@@@..+@@@@.....
    0xff, 0xd0, 0x05, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x05, 0xff, 0xfe, 0x20, 0x00,  //@@@..+@@@@@@@@.....@@@...+@@@@....
    0xff, 0xd0, 0x05, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x4f, 0xff, 0xe2, 0x00,  //@@@..+@@@@@@@@.....@@@....+@@@@...
    0xff, 0xd0, 0x05, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x03, 0xef, 0xfe, 0x20,  //@@@..+@@@@@@@@.....@@@......@@@@..
    0xff, 0xd0, 0x05, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xd0,  //@@@..+@@@@@@@@.....@@@.......@@@@.
    0xff, 0xd0, 0x05, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf6,  //@@@..+@@@@@@@@.....@@@........@@@+
    0xff, 0xd0, 0x05, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x0e, 0xff, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xfb,  //@@@..+@@@@@@@@.....@@@........+@@%
    0xff, 0xd0, 0x05, 0xff, 0xff, 0xff, 0xff, 0xed, 0xdd, 0xef, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@..+@@@@@@@@@@@@@@@@.........@@@
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@...@@@@@@@@@@@@@@@@.........@@@
    0xff, 0xd0, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@...%@@@@@@@@@@@@@@+.........@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@............................@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@............................@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@............................@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@............................@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@............................@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@............................@@@
    0xff, 0xd0, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x00, 0x0f, 0xfd,  //@@@...%@@@@@@@@@@@@@@@@@@@@....@@@
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x0f, 0xfd,  //@@@...@@@@@@@@@@@@@@@@@@@@@%...@@@
    0xff, 0xd0, 0x05, 0xff, 0xed, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdf, 0xfd, 0x00, 0x0f, 0xfd,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xd0, 0x05, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x0f, 0xfd,  //@@@..+@@+................@@@...@@@
    0xff, 0xd0, 0x05, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x0f, 0xfd,  //@@@..+@@+................@@@...@@@
    0xff, 0xd0, 0x05, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x0f, 0xfd,  //@@@..+@@+................@@@...@@@
    0xff, 0xd0, 0x05, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x0f, 0xfd,  //@@@..+@@+................@@@...@@@
    0xff, 0xd0, 0x05, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x0f, 0xfd,  //@@@..+@@+................@@@...@@@
    0xff, 0xd0, 0x05, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x0f, 0xfd,  //@@@..+@@+................@@@...@@@
    0xff, 0xd0, 0x05, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x0f, 0xfd,  //@@@..+@@+................@@@...@@@
    0xff, 0xd0, 0x05, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x0f, 0xfd,  //@@@..+@@+................@@@...@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x2b, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xa1,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f0e7 () , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00,  //....+@@@@@@@@+......
    0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00,  //....@@@@@@@@@+......
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00,  //....@@@@@@@@@.......
    0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,  //...+@@@@@@@@%.......
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00,  //...%@@@@@@@@........
    0x00, 0x0c, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@........
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@+........
    0x00, 0x4f, 0xff, 0xff, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@@@.........
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //..%@@@@@@@%.........
    0x00, 0xcf, 0xff, 0xff, 0xff, 0x50, 0x00, 0x01, 0x48, 0xb3,  //..%@@@@@@@+.....+%%.
    0x00, 0xff, 0xff, 0xff, 0xfe, 0x01, 0x59, 0xdf, 0xff, 0xf5,  //..@@@@@@@@..+%@@@@@+
    0x03, 0xff, 0xff, 0xff, 0xfe, 0xdf, 0xff, 0xff, 0xff, 0xe0,  //..@@@@@@@@@@@@@@@@@.
    0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //.+@@@@@@@@@@@@@@@@+.
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //.%@@@@@@@@@@@@@@@@..
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //.@@@@@@@@@@@@@@@@%..
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00,  //.@@@@@@@@@@@@@@@@...
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //+@@@@@@@@@@@@@@@%...
    0xbf, 0xff, 0xff, 0xff, 0xea, 0xff, 0xff, 0xff, 0x20, 0x00,  //%@@@@@@@@%@@@@@@....
    0xef, 0xff, 0xea, 0x62, 0x02, 0xff, 0xff, 0xfa, 0x00, 0x00,  //@@@@@%+...@@@@@%....
    0x8a, 0x62, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf3, 0x00, 0x00,  //%%+......+@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xb0, 0x00, 0x00,  //.........%@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0x40, 0x00, 0x00,  //.........@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0xfc, 0x00, 0x00, 0x00,  //.........@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xf5, 0x00, 0x00, 0x00,  //........+@@@@+......
    0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xd0, 0x00, 0x00, 0x00,  //........%@@@@.......
    0x00, 0x00, 0x00, 0x00, 0xdf, 0xff, 0x60, 0x00, 0x00, 0x00,  //........@@@@+.......
    0x00, 0x00, 0x00, 0x01, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,  //........@@@@........
    0x00, 0x00, 0x00, 0x05, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00,  //.......+@@@+........
    0x00, 0x00, 0x00, 0x09, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.......%@@@.........
    0x00, 0x00, 0x00, 0x0d, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00,  //.......@@@%.........
    0x00, 0x00, 0x00, 0x1f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00,  //.......@@@..........
    0x00, 0x00, 0x00, 0x5f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@%..........
    0x00, 0x00, 0x00, 0x9f, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@...........
    0x00, 0x00, 0x00, 0xdf, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@%...........
    0x00, 0x00, 0x01, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@............
    0x00, 0x00, 0x02, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@%............
    0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+f0f3 () , Width: 37 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................+@@%.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................@@@@.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................@@@@.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xef, 0xff, 0xff, 0xff, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............%@@@@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@@@@@@@@@@%............
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@@@@@@@@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@@@@@@@@@@@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@@@@@@@@@@%.........
    0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@@@@@@@@@@@@@@+........
    0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@@@@@@@@@@@%........
    0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@........
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@........
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@........
    0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@@@%.......
    0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@@@@@@@@@@@@@@+......
    0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+...
    0x01, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x00,  //..@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x2d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+.
    0x00, 0x34, 0x44, 0x44, 0x44, 0x44, 0x9f, 0x5f, 0xff, 0xff, 0xff, 0xfb, 0x44, 0x44, 0x44, 0x44, 0x43, 0x00, 0x00,  //...+++++++++%@+@@@@@@@@%+++++++++....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x8b, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+@+%@@@@@@@%.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xe4, 0xdf, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............@@+@@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xfe, 0x65, 0xcf, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............+@@++@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............+@@@@@@%...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x9c, 0xca, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................%@@%+................


    /*Unicode: U+f11c () , Width: 42 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x09, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x80,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xfd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdf, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@....................................@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@....................................@@@
    0xff, 0xd0, 0x07, 0xdd, 0x20, 0x0c, 0xdc, 0x00, 0x1d, 0xd1, 0x00, 0xcd, 0xc0, 0x01, 0xdd, 0x40, 0x0a, 0xdc, 0x00, 0x0f, 0xfd,  //@@@..+@@...@@@...@@...@@@...@@+..%@@...@@@
    0xff, 0xd0, 0x08, 0xff, 0x30, 0x0f, 0xff, 0x00, 0x2f, 0xf2, 0x00, 0xff, 0xf0, 0x02, 0xff, 0x50, 0x0d, 0xff, 0x00, 0x0f, 0xfd,  //@@@..%@@...@@@...@@...@@@...@@+..@@@...@@@
    0xff, 0xd0, 0x08, 0xff, 0x30, 0x0f, 0xff, 0x00, 0x2f, 0xf2, 0x00, 0xff, 0xf0, 0x02, 0xff, 0x50, 0x0d, 0xff, 0x00, 0x0f, 0xfd,  //@@@..%@@...@@@...@@...@@@...@@+..@@@...@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x0f, 0xfd,  //@@@..............................@@@...@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x0f, 0xfd,  //@@@..............................@@@...@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x0f, 0xfd,  //@@@..............................@@@...@@@
    0xff, 0xd0, 0x08, 0xff, 0xff, 0xf0, 0x00, 0xff, 0xc0, 0x0c, 0xff, 0x00, 0x0f, 0xfc, 0x00, 0x9f, 0xff, 0xff, 0x00, 0x0f, 0xfd,  //@@@..%@@@@@...@@@..@@@...@@@..%@@@@@...@@@
    0xff, 0xd0, 0x08, 0xff, 0xff, 0xf0, 0x00, 0xff, 0xd0, 0x0d, 0xff, 0x00, 0x0f, 0xfd, 0x00, 0x9f, 0xff, 0xff, 0x00, 0x0f, 0xfd,  //@@@..%@@@@@...@@@..@@@...@@@..%@@@@@...@@@
    0xff, 0xd0, 0x07, 0xdd, 0xdd, 0xc0, 0x00, 0xcd, 0xa0, 0x0a, 0xdc, 0x00, 0x0c, 0xda, 0x00, 0x7d, 0xdd, 0xdc, 0x00, 0x0f, 0xfd,  //@@@..+@@@@@...@@%..%@@...@@%..+@@@@@...@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@....................................@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@....................................@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@....................................@@@
    0xff, 0xd0, 0x08, 0xff, 0x30, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0c, 0xff, 0x00, 0x0f, 0xfd,  //@@@..%@@...@@@@@@@@@@@@@@@@@@@+..@@@...@@@
    0xff, 0xd0, 0x08, 0xff, 0x30, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0d, 0xff, 0x00, 0x0f, 0xfd,  //@@@..%@@...@@@@@@@@@@@@@@@@@@@+..@@@...@@@
    0xff, 0xd0, 0x07, 0xdd, 0x20, 0x0c, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0x40, 0x0a, 0xdc, 0x00, 0x0f, 0xfd,  //@@@..+@@...@@@@@@@@@@@@@@@@@@@+..%@@...@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@....................................@@@
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //@@@....................................@@@
    0xff, 0xfd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdf, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x80,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................


    /*Unicode: U+f124 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x9c, 0x30,  //............................%@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaf, 0xff, 0x90,  //..........................%@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaf, 0xff, 0xff, 0x50,  //........................%@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaf, 0xff, 0xff, 0xfc, 0x00,  //......................%@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaf, 0xff, 0xff, 0xff, 0xf5, 0x00,  //....................%@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //..................%@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00,  //................%@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,  //..............%@@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00,  //............%@@@@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x02, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00,  //..........%@@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x02, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00,  //........%@@@@@@@@@@@@@@@@@+....
    0x00, 0x00, 0x02, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00,  //......%@@@@@@@@@@@@@@@@@@@.....
    0x00, 0x02, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@+.....
    0x02, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@......
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@+......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@.......
    0x7d, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............+%...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f15b () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x4d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@@@@@@@+..............
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0xbe, 0x20, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@..........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0xbf, 0xe2, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0xbf, 0xfe, 0x20, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0xbf, 0xff, 0xe2, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0xbf, 0xff, 0xfe, 0x20, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0xbf, 0xff, 0xff, 0xe2, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@@@.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0xbf, 0xff, 0xff, 0xfe, 0x20, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xe2, 0x00,  //@@@@@@@@@@@@@@@@@@@+..%@@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xfe, 0x10,  //@@@@@@@@@@@@@@@@@@@+..%@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x12, 0x22, 0x22, 0x22, 0x22, 0x10,  //@@@@@@@@@@@@@@@@@@@+..............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@%..............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x61, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10,  //@@@@@@@@@@@@@@@@@@@@+.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x4d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.


    /*Unicode: U+f1eb () , Width: 43 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x67, 0x88, 0x87, 0x64, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................+++%%+++..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xb7, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+%@@@@@@@@@@@@@@%+.............
    0x00, 0x00, 0x00, 0x00, 0x03, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@@@@@@@@@@@@@@@@@%..........
    0x00, 0x00, 0x00, 0x05, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa3, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@@@@@@@@@@@@@@@@@%........
    0x00, 0x00, 0x04, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%......
    0x00, 0x01, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+....
    0x00, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x74, 0x21, 0x00, 0x01, 0x35, 0x7b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x00,  //..+@@@@@@@@@@@@%++.......++%@@@@@@@@@@@@...
    0x06, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x00,  //.+@@@@@@@@@@%................+%@@@@@@@@@@..
    0x8f, 0xff, 0xff, 0xff, 0xfe, 0x60, 0x00, 0x00, 0x03, 0x57, 0x88, 0x87, 0x42, 0x00, 0x00, 0x01, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x40,  //%@@@@@@@@@+.......++%%+++.......%@@@@@@@@@+
    0xcf, 0xff, 0xff, 0xff, 0x70, 0x00, 0x01, 0x6b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x50, 0x00, 0x01, 0x9f, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@+.....+%@@@@@@@@@@@%+.....%@@@@@@@%
    0x1d, 0xff, 0xff, 0xb2, 0x00, 0x03, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x81, 0x00, 0x04, 0xef, 0xff, 0xfb, 0x00,  //.@@@@@%.....%@@@@@@@@@@@@@@@@@%....+@@@@@%.
    0x01, 0xdf, 0xf7, 0x00, 0x02, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x0a, 0xff, 0xb0, 0x00,  //..@@@+....%@@@@@@@@@@@@@@@@@@@@@%....%@@%..
    0x00, 0x19, 0x40, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x30, 0x00, 0x67, 0x00, 0x00,  //...%+...+@@@@@@@@@@@@@@@@@@@@@@@@@....++...
    0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00,  //.......%@@@@@@@@@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xe9, 0x52, 0x00, 0x02, 0x48, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00,  //......%@@@@@@@@@@%+.....+%@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0xdf, 0xff, 0xff, 0xff, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xcf, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00,  //......@@@@@@@@%............+@@@@@@@@%......
    0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xef, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@................+@@@@@@.......
    0x00, 0x00, 0x00, 0x03, 0xef, 0xf6, 0x00, 0x00, 0x15, 0xad, 0xef, 0xec, 0x94, 0x00, 0x00, 0x1b, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //........@@@+.....+%@@@@@%+.....%@@@........
    0x00, 0x00, 0x00, 0x00, 0x2a, 0x20, 0x00, 0x29, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%.....%@@@@@@@@@@@+....+%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@@@@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............%@@@@@@@@@@@@@@@@@+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@@@@@@@@@@@@@@@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xfd, 0xa9, 0xbe, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+@@@@@@@%%%@@@@@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xfb, 0x30, 0x00, 0x00, 0x5d, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............+@@@%......+@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5d, 0x50, 0x00, 0x00, 0x00, 0x00, 0x7d, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............+@+.........+@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................+.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xfd, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................+@@@@@+..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................@@@@@@@..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................+@@@@@...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................%@@@+...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................+@+....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................................


    /*Unicode: U+f240 () , Width: 51 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x03, 0xad, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd9, 0x10, 0x00, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x00, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@...
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xff, 0x81, 0x00,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@%..
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xff, 0xfe, 0x10,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@@@.
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xff, 0xff, 0x80,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@@@+
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@......@@%
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0c, 0xcd, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@@@%
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xff, 0xff, 0x50,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@@@+
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xff, 0xf9, 0x00,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@@%.
    0xff, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xfd, 0x10, 0x00,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@...
    0xff, 0xd0, 0x02, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@...%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%...@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xdf, 0xfe, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xef, 0xfb, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x05, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x30, 0x00, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................


    /*Unicode: U+f241 () , Width: 51 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x03, 0xad, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd9, 0x10, 0x00, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x00, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@...
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x81, 0x00,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@%..
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xfe, 0x10,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@@@.
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@@@+
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@..............@@%
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xcd, 0xff, 0x90,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@@@%
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x50,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@@@+
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf9, 0x00,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@@%.
    0xff, 0xd0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x10, 0x00,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@...........@@@...
    0xff, 0xd0, 0x00, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@...%%%%%%%%%%%%%%%%%%%%%%%%%%%%...........@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xdf, 0xfe, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xef, 0xfb, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x05, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x30, 0x00, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................


    /*Unicode: U+f242 () , Width: 51 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x03, 0xad, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd9, 0x10, 0x00, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x00, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@...
    0xff, 0xd0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x81, 0x00,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@%..
    0xff, 0xd0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xfe, 0x10,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@@@.
    0xff, 0xd0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@@@+
    0xff, 0xd0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xff, 0xd0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xff, 0xd0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xff, 0xd0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xff, 0xd0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xff, 0xd0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xff, 0xd0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xff, 0xd0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@..+@@@@@@@@@@@@@@@@@@@.......................@@%
    0xff, 0xd0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xcd, 0xff, 0x90,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@@@%
    0xff, 0xd0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x50,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@@@+
    0xff, 0xd0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf9, 0x00,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@@%.
    0xff, 0xd0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x10, 0x00,  //@@@..+@@@@@@@@@@@@@@@@@@@....................@@@...
    0xff, 0xd0, 0x05, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..+%%%%%%%%%%%%%%%%%%%....................@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xdf, 0xfe, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xef, 0xfb, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x05, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x30, 0x00, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................


    /*Unicode: U+f243 () , Width: 51 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x03, 0xad, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd9, 0x10, 0x00, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x00, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@...@@@@@@@@@@@............................@@@...
    0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x81, 0x00,  //@@@...@@@@@@@@@@@............................@@@%..
    0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xfe, 0x10,  //@@@...@@@@@@@@@@@............................@@@@@.
    0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //@@@...@@@@@@@@@@@............................@@@@@+
    0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@...............................@@%
    0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@...............................@@%
    0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@...............................@@%
    0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@...............................@@%
    0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@...............................@@%
    0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@...............................@@%
    0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@...............................@@%
    0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@...@@@@@@@@@@@...............................@@%
    0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xcd, 0xff, 0x90,  //@@@...@@@@@@@@@@@............................@@@@@%
    0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x50,  //@@@...@@@@@@@@@@@............................@@@@@+
    0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf9, 0x00,  //@@@...@@@@@@@@@@@............................@@@@%.
    0xff, 0xd0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x10, 0x00,  //@@@...@@@@@@@@@@@............................@@@...
    0xff, 0xd0, 0x01, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@...%%%%%%%%%%%............................@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xdf, 0xfe, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xef, 0xfb, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x05, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x30, 0x00, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................


    /*Unicode: U+f244 () , Width: 51 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x03, 0xad, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd9, 0x20, 0x00, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xc5, 0x00,  //@@@..........................................@@@@+.
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x30,  //@@@..........................................@@@@@.
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x80,  //@@@..........................................@@@@@%
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@.............................................@@%
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@.............................................@@%
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@.............................................@@%
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@.............................................@@%
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@.............................................@@%
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@.............................................@@%
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@.............................................@@%
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //@@@.............................................@@%
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xcd, 0xff, 0x90,  //@@@..........................................@@@@@%
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x40,  //@@@..........................................@@@@@.
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xd6, 0x00,  //@@@..........................................@@@@+.
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00,  //@@@..........................................@@@...
    0xdf, 0xfe, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xef, 0xfa, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x05, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x30, 0x00, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................................


    /*Unicode: U+f293 () , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x16, 0x9c, 0xef, 0xff, 0xec, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+%@@@@@@@%+.........
    0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.......%@@@@@@@@@@@@@%.......
    0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@+.....
    0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xf5, 0xef, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00,  //....+@@@@@@@@+@@@@@@@@@@+....
    0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00,  //...+@@@@@@@@@..@@@@@@@@@@....
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x02, 0xef, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00,  //...@@@@@@@@@@...@@@@@@@@@@...
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00,  //..%@@@@@@@@@@....@@@@@@@@@+..
    0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0xe0, 0x00,  //..@@@@@@@@@@@.....@@@@@@@@@..
    0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xf4, 0x00,  //.+@@@@@@@@@@@......@@@@@@@@+.
    0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00, 0x10, 0x02, 0xef, 0xff, 0xff, 0xf9, 0x00,  //.@@@@@@@@@@@@.......@@@@@@@%.
    0x1f, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xf1, 0x00, 0xc1, 0x00, 0x2e, 0xff, 0xff, 0xfd, 0x00,  //.@@@@@@%@@@@@...@....@@@@@@@.
    0x4f, 0xff, 0xff, 0x80, 0x6f, 0xff, 0xf1, 0x00, 0xfc, 0x10, 0x02, 0xef, 0xff, 0xff, 0x10,  //+@@@@@%.+@@@@...@@....@@@@@@.
    0x7f, 0xff, 0xfc, 0x00, 0x06, 0xff, 0xf1, 0x00, 0xff, 0xc0, 0x00, 0x2e, 0xff, 0xff, 0x40,  //+@@@@@...+@@@...@@@....@@@@@+
    0xaf, 0xff, 0xff, 0x80, 0x00, 0x6f, 0xf1, 0x00, 0xff, 0x90, 0x00, 0x6f, 0xff, 0xff, 0x60,  //%@@@@@%...+@@...@@%...+@@@@@+
    0xbf, 0xff, 0xff, 0xf8, 0x00, 0x06, 0xf1, 0x00, 0xf9, 0x00, 0x06, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@%...+@...@%...+@@@@@@%
    0xdf, 0xff, 0xff, 0xff, 0x80, 0x00, 0x61, 0x00, 0x90, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xa0,  //@@@@@@@@%...+...%...+@@@@@@@%
    0xef, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@%.........+@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@%.......+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@%.....+@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@+....@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@%.....+@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@%.......+@@@@@@@@@@
    0xef, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@%.........+@@@@@@@@%
    0xdf, 0xff, 0xff, 0xff, 0x80, 0x00, 0x61, 0x00, 0x90, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xa0,  //@@@@@@@@%...+...%...+@@@@@@@%
    0xbf, 0xff, 0xff, 0xf8, 0x00, 0x06, 0xf1, 0x00, 0xf9, 0x00, 0x06, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@%...+@...@%...+@@@@@@%
    0xaf, 0xff, 0xff, 0x80, 0x00, 0x6f, 0xf1, 0x00, 0xff, 0x90, 0x00, 0x6f, 0xff, 0xff, 0x60,  //%@@@@@%...+@@...@@%...+@@@@@+
    0x7f, 0xff, 0xfc, 0x00, 0x06, 0xff, 0xf1, 0x00, 0xff, 0xc0, 0x00, 0x2e, 0xff, 0xff, 0x40,  //+@@@@@...+@@@...@@@....@@@@@+
    0x4f, 0xff, 0xff, 0x80, 0x6f, 0xff, 0xf1, 0x00, 0xfc, 0x10, 0x02, 0xef, 0xff, 0xff, 0x10,  //+@@@@@%.+@@@@...@@....@@@@@@.
    0x1f, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xf1, 0x00, 0xc1, 0x00, 0x2e, 0xff, 0xff, 0xfd, 0x00,  //.@@@@@@%@@@@@...@....@@@@@@@.
    0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00, 0x10, 0x02, 0xef, 0xff, 0xff, 0xf9, 0x00,  //.@@@@@@@@@@@@.......@@@@@@@%.
    0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xf4, 0x00,  //.+@@@@@@@@@@@......@@@@@@@@+.
    0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0xe0, 0x00,  //..@@@@@@@@@@@.....@@@@@@@@@..
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00,  //..%@@@@@@@@@@....@@@@@@@@@+..
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x02, 0xef, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00,  //...@@@@@@@@@@...@@@@@@@@@@...
    0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00,  //...+@@@@@@@@@..@@@@@@@@@@....
    0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xf4, 0xef, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00,  //....+@@@@@@@@+@@@@@@@@@@+....
    0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.......%@@@@@@@@@@@@@%.......
    0x00, 0x00, 0x00, 0x00, 0x16, 0x9c, 0xef, 0xff, 0xec, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+%@@@@@@@%+.........



#elif USE_LV_FONT_SYMBOL_40 == 8
    /*Unicode: U+f001 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x4a, 0x96, 0xd0, 0xa8, 0x16,  //.............................+%@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x60, 0xae, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xa6,  //..........................+%@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x78, 0xc6, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4,  //.......................+@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x42, 0x90, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6,  //...................+%@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x5a, 0xa8, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6,  //................+%@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x72, 0xc0, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6,  //.............+%@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6,  //...........+@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6,  //...........@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6,  //...........@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6,  //...........@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6,  //...........@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xba, 0xff, 0xff, 0xd6,  //...........@@@@@@@@@@@@@@@@@@@%@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0xa4, 0x56, 0x0c, 0x00, 0xff, 0xff, 0xd6,  //...........@@@@@@@@@@@@@@@@%+..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x8e, 0x40, 0x02, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //...........@@@@@@@@@@@@@%......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xc4, 0x76, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //...........@@@@@@@@@@+.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xae, 0x60, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //...........@@@@@@%+............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x98, 0x4a, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //...........@@@%+...............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //...........@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //...........@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //...........@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //...........@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //...........@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x46, 0x6c, 0x88, 0x82, 0x68, 0x34, 0x00, 0xff, 0xff, 0xd6,  //...........@@@..........++%%+..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xa4, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0xff, 0xff, 0xd6,  //...........@@@........%@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6,  //...........@@@.......@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6,  //...........@@@......@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2,  //...........@@@......@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa6,  //...........@@@......@@@@@@@@@@@@@%
    0x00, 0x00, 0x0e, 0x62, 0xaa, 0xd4, 0xf0, 0xf0, 0xd8, 0xac, 0x5c, 0xde, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x26,  //...+%@@@@%+@@@......+@@@@@@@@@@@@.
    0x00, 0x66, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xb4, 0x24, 0x00,  //.+@@@@@@@@@@@@.......+@@@@@@@@@%..
    0x64, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x78, 0xa2, 0xbc, 0xb6, 0x9a, 0x64, 0x16, 0x00, 0x00, 0x00,  //+@@@@@@@@@@@@@..........+%%%%+....
    0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@....................
    0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@....................
    0x9c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@%....................
    0x0e, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@%.....................
    0x00, 0x00, 0x54, 0xb0, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xb0, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+%@@@@@@%+......................
    0x00, 0x00, 0x00, 0x00, 0x08, 0x30, 0x4c, 0x4c, 0x30, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......++..........................


    /*Unicode: U+f008 () , Width: 42 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x32, 0xac, 0xd4, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd0, 0x9e, 0x20, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0x3c, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x1e,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xf8, 0xff, 0xfc, 0x4a, 0x00, 0x00, 0x00, 0x4a, 0xfc, 0xff, 0xff, 0x6e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x6e, 0xff, 0xff, 0xfc, 0x48, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xd0,  //@@@+...+@@@+..................+@@@+...+@@@
    0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xd6,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xd6,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xfc, 0x48, 0x00, 0x00, 0x00, 0x48, 0xfc, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xfc, 0x46, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xd6,  //@@@+...+@@@....................@@@+...+@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf6, 0xd6, 0xd6, 0xd6, 0xf6, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xf6, 0xd6, 0xd6, 0xd8, 0xfa, 0xff, 0xff, 0xd6,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x20, 0x00, 0x00, 0x00, 0x20, 0xf4, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf4, 0x1e, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xd6,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xfa, 0x3e, 0x00, 0x00, 0x00, 0x3e, 0xfa, 0xff, 0xff, 0x6c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x6c, 0xff, 0xff, 0xfa, 0x3c, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd6,  //@@@.....@@@+..................+@@@....+@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf6, 0xd6, 0xd6, 0xd6, 0xf6, 0xff, 0xff, 0xff, 0xfc, 0xda, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xda, 0xfc, 0xff, 0xff, 0xff, 0xf6, 0xd6, 0xd6, 0xd8, 0xfa, 0xff, 0xff, 0xd6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf6, 0x22, 0x00, 0x00, 0x00, 0x22, 0xf6, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xf6, 0x20, 0x00, 0x00, 0x00, 0x42, 0xff, 0xff, 0xd6,  //@@@.....@@@+..................+@@@....+@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xf6, 0x20, 0x00, 0x00, 0x00, 0x20, 0xf6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf6, 0x1e, 0x00, 0x00, 0x00, 0x40, 0xff, 0xff, 0xd6,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xff, 0xf6, 0xd6, 0xd6, 0xd6, 0xf6, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xf4, 0xd6, 0xd6, 0xd8, 0xfa, 0xff, 0xff, 0xd6,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6,  //@@@@@@@@@@@....................@@@@@@@@@@@
    0xff, 0xff, 0xfc, 0x4a, 0x00, 0x00, 0x00, 0x4a, 0xfc, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xfc, 0x48, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xd6,  //@@@+...+@@@....................@@@+...+@@@
    0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xd6,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@.....@@@....................@@@.....@@@
    0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xd6,  //@@@.....@@@....................@@@.....@@@
    0xf8, 0xff, 0xfc, 0x48, 0x00, 0x00, 0x00, 0x48, 0xfc, 0xff, 0xff, 0x70, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x70, 0xff, 0xff, 0xfc, 0x46, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xd0,  //@@@+...+@@@+..................+@@@+...+@@@
    0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x3e, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x20,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x34, 0xae, 0xd4, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd2, 0xa0, 0x20, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..


    /*Unicode: U+f00b () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x38, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x38, 0x00,  //..++++++++......+++++++++++++++++++++..
    0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86,  //%@@@@@@@@@%...%@@@@@@@@@@@@@@@@@@@@@@@%
    0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x14, 0x00, 0x08, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x08, 0x00, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0x40, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x58, 0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x40,  //.@@@@@@@@@+...+@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x38, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x38, 0x00,  //..++++++++......+++++++++++++++++++++..
    0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86,  //%@@@@@@@@@%...%@@@@@@@@@@@@@@@@@@@@@@@%
    0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x14, 0x00, 0x08, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x08, 0x00, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0x40, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x58, 0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x40,  //.@@@@@@@@@+...+@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x38, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x38, 0x00,  //..++++++++......+++++++++++++++++++++..
    0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86,  //%@@@@@@@@@%...%@@@@@@@@@@@@@@@@@@@@@@@%
    0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x14, 0x00, 0x08, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x08, 0x00, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc,  //@@@@@@@@@@@...@@@@@@@@@@@@@@@@@@@@@@@@@
    0x40, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x58, 0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x40,  //.@@@@@@@@@+...+@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................


    /*Unicode: U+f00c () , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xe8, 0xff, 0xba, 0x0e, 0x00, 0x00, 0x00,  //............................@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xc6, 0x0e, 0x00, 0x00,  //...........................@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x0e, 0x00,  //..........................@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x02,  //.........................@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //........................@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //.......................@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x98, 0x00,  //......................@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x06, 0x38, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00,  //.....................@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x1a, 0xd4, 0xff, 0xf4, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00,  //....@@@+............@@@@@@@@@@@%...
    0x00, 0x00, 0x1a, 0xda, 0xff, 0xff, 0xff, 0xfa, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00,  //...@@@@@+..........@@@@@@@@@@@%....
    0x00, 0x1a, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@+........@@@@@@@@@@@%.....
    0x08, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@+......@@@@@@@@@@@%......
    0x4a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x54, 0x00, 0x00, 0x00, 0x3c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@@@+....@@@@@@@@@@@%.......
    0x2c, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x52, 0x00, 0x3c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@+..@@@@@@@@@@@%........
    0x00, 0x7c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x80, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@@@@@@@+@@@@@@@@@@@%.........
    0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@@%..........
    0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@@@%............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@%.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@@%...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@%................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@@@%.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@@%..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@%...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xa6, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+%+....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+f00d () , Width: 26 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x1e, 0xae, 0xca, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xc4, 0xba, 0x30, 0x00, 0x00, 0x00,  //....%@+............+@%....
    0x00, 0x00, 0x22, 0xe2, 0xff, 0xff, 0xfc, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xf8, 0xff, 0xff, 0xf0, 0x38, 0x00, 0x00,  //...@@@@+..........+@@@@...
    0x00, 0x22, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x38, 0x00,  //..@@@@@@+........+@@@@@@..
    0x1e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x34,  //.@@@@@@@@+......+@@@@@@@@.
    0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x68, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2,  //%@@@@@@@@@+....+@@@@@@@@@@
    0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x68, 0x00, 0x00, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee,  //@@@@@@@@@@@+..+@@@@@@@@@@@
    0x58, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x68, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c,  //+@@@@@@@@@@@++@@@@@@@@@@@+
    0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x4a, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x68, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@@+....
    0x00, 0x00, 0x00, 0x4a, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x68, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@@+...
    0x00, 0x00, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@+.
    0x40, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x6c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5e,  //.@@@@@@@@@@@%+@@@@@@@@@@@+
    0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6,  //@@@@@@@@@@@%..+@@@@@@@@@@@
    0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //%@@@@@@@@@%....+@@@@@@@@@@
    0x32, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x4e,  //.@@@@@@@@%......+@@@@@@@@+
    0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x54, 0x00,  //..@@@@@@%........+@@@@@@+.
    0x00, 0x00, 0x3a, 0xf0, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xfa, 0x54, 0x00, 0x00,  //...@@@@%..........+@@@@+..
    0x00, 0x00, 0x00, 0x34, 0xd2, 0xee, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xe8, 0xde, 0x4c, 0x00, 0x00, 0x00,  //....@@+............+@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................


    /*Unicode: U+f011 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x6e, 0x58, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................++................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xf6, 0xff, 0xff, 0xca, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............+@@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd4, 0xff, 0xff, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@+..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x6c, 0x90, 0x52, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x16, 0x78, 0x8c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%+....@@@@@%....+%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xd4, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x10, 0xde, 0xff, 0xff, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@+...@@@@@%...@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x2a, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x08, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x70, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@...@@@@@%..+@@@@@%.....
    0x00, 0x00, 0x00, 0x1e, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@...@@@@@%..+@@@@@@%....
    0x00, 0x00, 0x04, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x2e, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00,  //...@@@@@@@%...@@@@@%...@@@@@@@+...
    0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x12, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x58, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x18, 0x00, 0x00,  //..+@@@@@@@....@@@@@%...+@@@@@@@...
    0x00, 0x18, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0x10, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x50, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00,  //..@@@@@@@.....@@@@@%....+@@@@@@%..
    0x00, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x1c, 0x00,  //.%@@@@@@......@@@@@%.....+@@@@@@..
    0x06, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00,  //.@@@@@@+......@@@@@%......%@@@@@%.
    0x46, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x00,  //+@@@@@%.......@@@@@%.......@@@@@@.
    0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1e,  //%@@@@@........@@@@@%.......%@@@@@.
    0xbe, 0xff, 0xff, 0xff, 0xff, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4c,  //%@@@@@........@@@@@%.......+@@@@@+
    0xe2, 0xff, 0xff, 0xff, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xfa, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72,  //@@@@@%........%@@@@.........@@@@@+
    0xf4, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x9c, 0xee, 0xda, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82,  //@@@@@%.........%@@+.........@@@@@%
    0xfa, 0xff, 0xff, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a,  //@@@@@%......................@@@@@%
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e,  //@@@@@%......................@@@@@+
    0xd6, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x64,  //@@@@@@......................@@@@@+
    0xac, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3a,  //%@@@@@.....................%@@@@@.
    0x70, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x06,  //+@@@@@+....................@@@@@@.
    0x24, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00,  //.@@@@@@...................+@@@@@%.
    0x00, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00,  //.@@@@@@%..................@@@@@@+.
    0x00, 0x46, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //.+@@@@@@+................%@@@@@@..
    0x00, 0x00, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00,  //..%@@@@@@+..............%@@@@@@+..
    0x00, 0x00, 0x2e, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x84, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00,  //...@@@@@@@%............@@@@@@@%...
    0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x6e, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x3c, 0xa2, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x14, 0x00, 0x00, 0x00,  //...+@@@@@@@@+........%@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0xae, 0x96, 0xa0, 0xb8, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x2e, 0x00, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@%%%%@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x02, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x7c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@@@@@@@@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xbe, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x8c, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@@@@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x6c, 0xa8, 0xd2, 0xee, 0xfa, 0xf6, 0xe6, 0xc2, 0x90, 0x4c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+%@@@@@@%+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f013 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............%@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............@@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x94, 0xf0, 0x60, 0x00, 0x00, 0x00, 0x06, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x46, 0xe6, 0xaa, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@+....@@@@@@@....+@%.......
    0x00, 0x00, 0x00, 0x00, 0x04, 0xae, 0xff, 0xff, 0xff, 0x98, 0x06, 0x00, 0x44, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5e, 0x00, 0x02, 0x82, 0xfc, 0xff, 0xff, 0xba, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@%..+@@@@@@@+..%@@@%......
    0x00, 0x00, 0x00, 0x02, 0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x06, 0x00, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x04, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x54, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@@@@@@@@@+....
    0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x02, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x98, 0x44, 0x28, 0x3e, 0x88, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@%+..%@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@.......@@@@@@@@+.....
    0x48, 0x8a, 0xb4, 0xdc, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xc6, 0x9c, 0x74, 0x3c, 0x00,  //+%%@@@@@@@@@.........@@@@@@@@@%+..
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x18,  //@@@@@@@@@@@%.........%@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22,  //@@@@@@@@@@@+..........@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22,  //@@@@@@@@@@@...........@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22,  //@@@@@@@@@@@...........@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22,  //@@@@@@@@@@@+..........@@@@@@@@@@@.
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1a,  //@@@@@@@@@@@%.........%@@@@@@@@@@@.
    0x32, 0x70, 0x98, 0xc0, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0xba, 0x90, 0x58, 0x00,  //.+%%@@@@@@@@.........@@@@@@@@@%%+.
    0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@.......@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x96, 0x44, 0x28, 0x3c, 0x88, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@%+..%@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x46, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@@@@@@@@@+....
    0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x18, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0x0c, 0x00, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@@@@@@@%@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0x9e, 0x08, 0x00, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x82, 0xfc, 0xff, 0xff, 0xca, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@%...@@@@@@@+..%@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xf0, 0x62, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x4c, 0xea, 0xb0, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@+....@@@@@@@....+@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x06, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............@@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............%@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f014 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x70, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xb2, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@@@@@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@@@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xc2, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@+.......@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xf0, 0xff, 0xf6, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........+@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xf0, 0xff, 0xf4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@%.........@@@........
    0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9e,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xb4, 0xd6, 0xde, 0xff, 0xff, 0xec, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xfc, 0xff, 0xf8, 0xd6, 0xd6, 0x62,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%...................@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%...................@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%...................@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%...................@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x80, 0xff, 0xec, 0x0e, 0x00, 0x06, 0xe6, 0xff, 0x8e, 0x00, 0x00, 0x5c, 0xfc, 0xf6, 0x2a, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%..+@@...@@%..+@@...@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x7e, 0xff, 0xff, 0x46, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x7e, 0xff, 0xff, 0x46, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x7e, 0xff, 0xff, 0x46, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x7e, 0xff, 0xff, 0x46, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x7e, 0xff, 0xff, 0x46, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x7e, 0xff, 0xff, 0x46, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x7e, 0xff, 0xff, 0x46, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x7e, 0xff, 0xff, 0x46, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x7e, 0xff, 0xff, 0x46, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x7e, 0xff, 0xff, 0x46, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x7e, 0xff, 0xff, 0x46, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x22, 0x00, 0x12, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x7e, 0xff, 0xff, 0x46, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%..%@@...@@%..+@@+..@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x76, 0xee, 0xde, 0x0c, 0x00, 0x04, 0xd8, 0xee, 0x84, 0x00, 0x00, 0x56, 0xec, 0xe6, 0x26, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%..+@@...@@%..+@@...@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%...................@@@...
    0x00, 0x00, 0x36, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0xd6, 0x00, 0x00, 0x00,  //...@@%...................@@@...
    0x00, 0x00, 0x34, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0xff, 0xd2, 0x00, 0x00, 0x00,  //...@@%...................@@@...
    0x00, 0x00, 0x1c, 0xff, 0xff, 0xd6, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00,  //...@@@..................+@@%...
    0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x3e, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x04, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x3c, 0xb6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd0, 0x90, 0x0e, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f015 () , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xa2, 0xe0, 0xb8, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xda, 0xda, 0xda, 0xda, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00,  //................%@%.....+@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xe0, 0xff, 0xff, 0xff, 0xf0, 0x48, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............@@@@@+...%@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x6a, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@@@+..%@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xfc, 0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+@@@@@@@@@%.%@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x10, 0x88, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@@%.%@@@@%%@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xc2, 0xff, 0xff, 0xff, 0xff, 0x90, 0x02, 0x16, 0x00, 0x60, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@%...+@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xde, 0xff, 0xff, 0xff, 0xf8, 0x64, 0x00, 0x58, 0xf6, 0x8a, 0x00, 0x3c, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@+.+@%..@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xf2, 0xff, 0xff, 0xff, 0xec, 0x40, 0x00, 0x80, 0xff, 0xff, 0xff, 0xb2, 0x0c, 0x22, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@..+@@@%..@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xfc, 0xff, 0xff, 0xff, 0xd6, 0x22, 0x08, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x1e, 0x0e, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@..%@@@@@@..%@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x04, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x0e, 0x1a, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x3a, 0x02, 0x96, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@%..@@@@@@@@@..%@@@@@.....
    0x00, 0x00, 0x00, 0x14, 0xc2, 0xff, 0xff, 0xff, 0xff, 0x92, 0x02, 0x34, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x5e, 0x00, 0x6e, 0xfa, 0xff, 0xff, 0xff, 0xce, 0x1c, 0x00, 0x00, 0x00,  //....@@@@@%..@@@@@@@@@@@+.+@@@@@....
    0x00, 0x00, 0x2c, 0xde, 0xff, 0xff, 0xff, 0xfa, 0x66, 0x00, 0x56, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x88, 0x00, 0x48, 0xf0, 0xff, 0xff, 0xff, 0xe6, 0x38, 0x00, 0x00,  //...@@@@@+.+@@@@@@@@@@@@@%.+@@@@@...
    0x00, 0x4c, 0xf0, 0xff, 0xff, 0xff, 0xec, 0x40, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0a, 0x2a, 0xde, 0xff, 0xff, 0xff, 0xf6, 0x5c, 0x00,  //.+@@@@@..+@@@@@@@@@@@@@@@%..@@@@@+.
    0x6a, 0xfc, 0xff, 0xff, 0xff, 0xd6, 0x24, 0x08, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x1e, 0x14, 0xc4, 0xff, 0xff, 0xff, 0xff, 0x80,  //+@@@@@..%@@@@@@@@@@@@@@@@@@..@@@@@+
    0xc4, 0xff, 0xff, 0xff, 0xb8, 0x0e, 0x18, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x3a, 0x06, 0xa4, 0xff, 0xff, 0xff, 0xda,  //@@@@%..@@@@@@@@@@@@@@@@@@@@@..%@@@@
    0x22, 0xea, 0xff, 0x92, 0x02, 0x32, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x5e, 0x00, 0x7c, 0xfc, 0xf2, 0x2e,  //.@@%..@@@@@@@@@@@@@@@@@@@@@@@+.+@@.
    0x00, 0x2e, 0x52, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x46, 0x3a, 0x00,  //..+..%@@@@@@@@@@@@@@@@@@@@@@@@..+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@%%%%%@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@.....%@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@.....%@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+f019 () , Width: 36 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x42, 0x46, 0x46, 0x46, 0x46, 0x46, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............++++++...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x64, 0x22, 0x22, 0x22, 0x22, 0x22, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@@@@@@@@@@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@@@@@@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@@@@@@@@@@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@@@@@@@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+@@@@@@@@@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+@@@@@@@@@@%............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@@@@%.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............+@@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xf8, 0xff, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............+@@@@%...............
    0x40, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x06, 0x00, 0x00, 0x4e, 0xf8, 0xff, 0x86, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x40,  //.@@@@@@@@@@@%...+@@%...+@@@@@@@@@@@.
    0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x0a, 0x00, 0x00, 0x24, 0x38, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde,  //@@@@@@@@@@@@@%........%@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x02, 0x98, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@......%@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x5a, 0x16, 0x0e, 0x44, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@+..+@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x9a, 0xde, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@%@@@@%%@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x00, 0x1e, 0xff, 0xff, 0xea, 0x04, 0x04, 0xea, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@...@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x56, 0x00, 0x46, 0xff, 0xff, 0xf4, 0x18, 0x18, 0xf4, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@+.+@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xe0, 0xfc, 0xff, 0xff, 0xff, 0xf2, 0xf2, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x42, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x42,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................


    /*Unicode: U+f01c () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xcc, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0xff, 0xde, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x86, 0xff, 0xff, 0xff, 0xf8, 0x18, 0x00, 0x00, 0x00, 0x00,  //....%@@@@...............%@@@@.....
    0x00, 0x00, 0x00, 0x1a, 0xfa, 0xff, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf6, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00,  //....@@@@+................@@@@%....
    0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xf4, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xe8, 0x06, 0x00, 0x00, 0x00,  //...%@@@@.................%@@@@....
    0x00, 0x00, 0x06, 0xe8, 0xff, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00,  //...@@@@%..................@@@@+...
    0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00,  //..+@@@@...................@@@@@...
    0x00, 0x00, 0xcc, 0xff, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xff, 0xff, 0x3a, 0x00, 0x00,  //..@@@@@...................+@@@@...
    0x00, 0x3a, 0xff, 0xff, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xe4, 0xff, 0xff, 0xff, 0xa8, 0x00, 0x00,  //..@@@@+....................@@@@%..
    0x00, 0xa6, 0xff, 0xff, 0xff, 0xe4, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xfa, 0x1a, 0x00,  //.%@@@@.....................+@@@@..
    0x18, 0xfa, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xf8, 0xff, 0xff, 0xff, 0x84, 0x00,  //.@@@@+......................@@@@%.
    0x7c, 0xff, 0xff, 0xff, 0xf8, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0xff, 0xe8, 0x00,  //+@@@@.......................%@@@@.
    0xc8, 0xff, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@%........................@@@@.
    0xf0, 0xff, 0xff, 0xff, 0xb2, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0xf6, 0xff, 0xff, 0xff, 0x5c,  //@@@@%%%%%%%...........+%%%%%%@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@%..........@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@.........%@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@%........@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x68, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@+++++++@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x92, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x1c,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f021 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x34, 0x48, 0x5c, 0x58, 0x46, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............++++...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x90, 0xd0, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0xac, 0x56, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@@@@@@@%+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x64, 0x04, 0x00, 0x00, 0x00, 0x00, 0x16, 0xc6, 0xe2, 0x2c,  //.........%@@@@@@@@@@@@@@+......@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x96, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x36, 0x00, 0x00, 0x16, 0xd4, 0xff, 0xff, 0x82,  //.......%@@@@@@@@@@@@@@@@@@....@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x6a, 0x18, 0xd6, 0xff, 0xff, 0xff, 0x86,  //......@@@@@@@@@@@@@@@@@@@@@+.@@@@%
    0x00, 0x00, 0x00, 0x00, 0x26, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x86,  //.....@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x16, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xac, 0x6c, 0x40, 0x30, 0x3a, 0x52, 0x84, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86,  //....@@@@@@@@@%+...+%@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x82, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86,  //...%@@@@@@@%..........%@@@@@@@@@@%
    0x00, 0x00, 0x72, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86,  //..+@@@@@@@.............+@@@@@@@@@%
    0x00, 0x0c, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86,  //..@@@@@@@...............@@@@@@@@@%
    0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86,  //.+@@@@@@...............@@@@@@@@@@%
    0x00, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86,  //.@@@@@@+..............@@@@@@@@@@@%
    0x38, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86,  //.@@@@@@..............@@@@@@@@@@@@%
    0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6c,  //%@@@@@+..............@@@@@@@@@@@@+
    0x2e, 0x86, 0x86, 0x86, 0x86, 0x76, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x82, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x6c, 0x04,  //.%%%%+................%%%%%%%%%%+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x7a, 0xe2, 0xe6, 0xe6, 0xe6, 0xe6, 0xe6, 0xe6, 0xe6, 0xe6, 0xe6, 0xcc, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xe6, 0xe6, 0xe6, 0xe6, 0xbc, 0x00,  //+@@@@@@@@@@@...............+@@@@%.
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xea, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00,  //@@@@@@@@@@@@+..............@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00,  //@@@@@@@@@@@@..............+@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x00,  //@@@@@@@@@@@...............@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa8, 0x00, 0x00,  //@@@@@@@@@@...............%@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xac, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x28, 0x00, 0x00,  //@@@@@@@@@+..............%@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x84, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00,  //@@@@@@@@@@%............@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x6e, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xa0, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x06, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@+........%@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xce, 0xac, 0x94, 0x9a, 0xb4, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x24, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@%%%%@@@@@@@@@@.....
    0xff, 0xff, 0xff, 0xff, 0xe6, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@%@@@@@@@@@@@@@@@@@@@@@@......
    0xff, 0xff, 0xff, 0xe6, 0x28, 0x00, 0x80, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@..+@@@@@@@@@@@@@@@@@@@@.......
    0xec, 0xff, 0xe6, 0x28, 0x00, 0x00, 0x00, 0x3a, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7a, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@@@@@@@@@@@@@@@@+........
    0x3e, 0x8c, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x58, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x8a, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%.......+@@@@@@@@@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x72, 0xae, 0xd6, 0xf0, 0xfa, 0xee, 0xda, 0xc2, 0x8a, 0x4a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+%@@@@@@%+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f026 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x16, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xce, 0xff, 0x6a,  //..............@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xb4,  //.............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xb6,  //............@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xb6,  //...........@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //..........@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //.........@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //........@@@@@@@@%
    0x28, 0x7a, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0xd2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //.++++++@@@@@@@@@%
    0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@@@@@@@@@@%
    0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@@@@@@@@@@%
    0x44, 0x9e, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //+%%%%%%@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //........@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //.........@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //..........@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xb6,  //...........@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xb6,  //............@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xb6,  //.............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0x82,  //..............@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x3a, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f027 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xce, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@@%........
    0x28, 0x7a, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0xd2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x0a, 0x10, 0x00, 0x00, 0x00,  //.++++++@@@@@@@@@%........
    0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x18, 0xea, 0xf8, 0x86, 0x04, 0x00,  //@@@@@@@@@@@@@@@@%...@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x3c, 0xff, 0xff, 0xff, 0xa0, 0x00,  //@@@@@@@@@@@@@@@@%...@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x7e, 0xfc, 0xff, 0xff, 0x4c,  //@@@@@@@@@@@@@@@@%...+@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xba,  //@@@@@@@@@@@@@@@@%....+@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe8, 0xff, 0xe8,  //@@@@@@@@@@@@@@@@%.....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe2, 0xff, 0xee,  //@@@@@@@@@@@@@@@@%.....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xff, 0xc4,  //@@@@@@@@@@@@@@@@%....+@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x58, 0xf0, 0xff, 0xff, 0x5c,  //@@@@@@@@@@@@@@@@%...+@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x32, 0xff, 0xff, 0xff, 0xbc, 0x02,  //@@@@@@@@@@@@@@@@%...@@@%.
    0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x24, 0xf8, 0xff, 0xa8, 0x0e, 0x00,  //@@@@@@@@@@@@@@@@%...@@%..
    0x44, 0x9e, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x20, 0x2e, 0x00, 0x00, 0x00,  //+%%%%%%@@@@@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f028 () , Width: 36 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xf2, 0x9c, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................%@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xf8, 0x7c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xb2, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xec, 0xff, 0xff, 0xff, 0xc0, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............+%........+@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x8e, 0xfa, 0xff, 0xff, 0xd6, 0x18, 0x00, 0x00, 0x00, 0x00,  //.............%@@%.........%@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xe6, 0xff, 0xff, 0xd6, 0x0c, 0x00, 0x00, 0x00,  //............%@@@%...........@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xd2, 0x72, 0x0a, 0x00, 0x00, 0x1e, 0xde, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00,  //...........+@@@@%.....%@+....@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xff, 0xde, 0x3e, 0x00, 0x00, 0x22, 0xec, 0xff, 0xff, 0x5e, 0x00, 0x00,  //..........+@@@@@%.....@@@@....@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xfa, 0x5a, 0x00, 0x00, 0x52, 0xff, 0xff, 0xe4, 0x08, 0x00,  //.........+@@@@@@%.....%@@@@+..+@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xca, 0xff, 0xff, 0xfc, 0x46, 0x00, 0x00, 0xb4, 0xff, 0xff, 0x76, 0x00,  //........+@@@@@@@%.......@@@@+..%@@+.
    0x00, 0x12, 0x16, 0x16, 0x16, 0x16, 0x16, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xac, 0xff, 0xff, 0xec, 0x14, 0x00, 0x2e, 0xff, 0xff, 0xda, 0x00,  //.......+@@@@@@@@%........%@@@...@@@.
    0xa6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x10, 0xa0, 0x96, 0x1a, 0x00, 0x00, 0x02, 0xc2, 0xff, 0xff, 0x9a, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x3c,  //%@@@@@@@@@@@@@@@%...%%....@@@%..%@@.
    0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x70, 0xff, 0xff, 0xf4, 0x3e, 0x00, 0x00, 0x20, 0xf6, 0xff, 0xf8, 0x14, 0x00, 0x6e, 0xff, 0xff, 0x7c,  //@@@@@@@@@@@@@@@@%..+@@@....@@@..+@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x2a, 0xe8, 0xff, 0xff, 0xf0, 0x1a, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x68, 0x00, 0x2a, 0xff, 0xff, 0xb4,  //@@@@@@@@@@@@@@@@%...@@@@...%@@+..@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x16, 0xb8, 0xff, 0xff, 0x90, 0x00, 0x00, 0x44, 0xff, 0xff, 0xa2, 0x00, 0x04, 0xf8, 0xff, 0xda,  //@@@@@@@@@@@@@@@@%....%@@%..+@@%..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x10, 0xf8, 0xff, 0xd8, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xc4, 0x00, 0x00, 0xe6, 0xff, 0xec,  //@@@@@@@@@@@@@@@@%.....@@@...@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0xff, 0xf4, 0x00, 0x00, 0x06, 0xff, 0xff, 0xd0, 0x00, 0x00, 0xda, 0xff, 0xfa,  //@@@@@@@@@@@@@@@@%.....@@@...@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x16, 0xf8, 0xff, 0xd6, 0x00, 0x00, 0x1e, 0xff, 0xff, 0xc2, 0x00, 0x00, 0xe6, 0xff, 0xec,  //@@@@@@@@@@@@@@@@%.....@@@...@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x1a, 0xc6, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x48, 0xff, 0xff, 0xa0, 0x00, 0x04, 0xf8, 0xff, 0xda,  //@@@@@@@@@@@@@@@@%....@@@%..+@@%..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x2e, 0xec, 0xff, 0xff, 0xec, 0x16, 0x00, 0x00, 0xa6, 0xff, 0xff, 0x62, 0x00, 0x2c, 0xff, 0xff, 0xb2,  //@@@@@@@@@@@@@@@@%...@@@@...%@@+..@@%
    0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xee, 0x36, 0x00, 0x00, 0x26, 0xf6, 0xff, 0xf6, 0x10, 0x00, 0x70, 0xff, 0xff, 0x7a,  //@@@@@@@@@@@@@@@@%..+@@@....@@@..+@@+
    0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x0c, 0x94, 0x8a, 0x14, 0x00, 0x00, 0x04, 0xca, 0xff, 0xff, 0x92, 0x00, 0x00, 0xc4, 0xff, 0xff, 0x38,  //%@@@@@@@@@@@@@@@%...%%....@@@%..@@@.
    0x00, 0x06, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x74, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xb8, 0xff, 0xff, 0xe6, 0x10, 0x00, 0x30, 0xff, 0xff, 0xd8, 0x00,  //.......+@@@@@@@@%........%@@@...@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xd4, 0xff, 0xff, 0xfa, 0x3e, 0x00, 0x00, 0xb6, 0xff, 0xff, 0x72, 0x00,  //........+@@@@@@@%......+@@@@...%@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0xff, 0xf6, 0x4e, 0x00, 0x00, 0x56, 0xff, 0xff, 0xe0, 0x06, 0x00,  //.........+@@@@@@%.....%@@@@+..+@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xff, 0xd6, 0x32, 0x00, 0x00, 0x28, 0xf0, 0xff, 0xff, 0x58, 0x00, 0x00,  //..........+@@@@@%.....@@@@....@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xc6, 0x66, 0x04, 0x00, 0x00, 0x22, 0xe2, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00,  //...........+@@@@%.....%@+....@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xea, 0xff, 0xff, 0xd0, 0x0a, 0x00, 0x00, 0x00,  //............+@@@%...........@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x98, 0xfc, 0xff, 0xff, 0xd0, 0x12, 0x00, 0x00, 0x00, 0x00,  //.............+@@%.........%@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xa6, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xf2, 0xff, 0xff, 0xff, 0xb8, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............+%........+@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe2, 0xff, 0xff, 0xf4, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xe6, 0x92, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................+@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................


    /*Unicode: U+f03e () , Width: 42 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x34, 0xae, 0xd4, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd0, 0xa0, 0x20, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0x3e, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x20,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9e,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xf8, 0xff, 0xea, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xd0,  //@@@....................................@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@....................................@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@....................................@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x56, 0xd8, 0xff, 0xfa, 0xb4, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@....+@@@%...........................@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@...+@@@@@@..........................@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x0e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@...@@@@@@@%.........................@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x46, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@..+@@@@@@@@.............+...........@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xd0, 0xf8, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@..+@@@@@@@@............@@+..........@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x1a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xd0, 0xff, 0xff, 0xf8, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@...@@@@@@@%...........@@@@+.........@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@...%@@@@@@...........@@@@@@+........@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x02, 0x8a, 0xfa, 0xff, 0xff, 0xe4, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@....%@@@@+..........@@@@@@@@+.......@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x3e, 0x34, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@...................@@@@@@@@@@+......@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@..................@@@@@@@@@@@@+.....@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x46, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@.................@@@@@@@@@@@@@@+....@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xaa, 0x24, 0x00, 0x00, 0x00, 0x00, 0x10, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x46, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@.........%......@@@@@@@@@@@@@@@@+...@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xc4, 0xff, 0xe2, 0x22, 0x00, 0x00, 0x10, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x22, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@........@@@....@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xc4, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x10, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@.......@@@@@..@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@......@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@.....@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x0a, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@....@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x0a, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@...@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x56, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x56, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x56, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x56, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x12, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x0a, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@....................................@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@....................................@@@
    0xf8, 0xff, 0xea, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xd0,  //@@@....................................@@@
    0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9e,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x3e, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x20,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x34, 0xae, 0xd4, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd2, 0xa0, 0x20, 0x00,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................


    /*Unicode: U+f040 () , Width: 33 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x94, 0xff, 0xff, 0xc2, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................%@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaa, 0xff, 0xff, 0xff, 0xff, 0xda, 0x1a, 0x00, 0x00, 0x00, 0x00,  //......................%@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xac, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x1c, 0x00, 0x00, 0x00,  //.....................%@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xac, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x1c, 0x00, 0x00,  //....................%@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x1c, 0x00,  //....................@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1c, 0x00, 0x38, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x1a,  //.....................@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xae, 0xe4, 0x24, 0x00, 0x38, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2,  //.................%@...@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xae, 0xff, 0xff, 0xe4, 0x24, 0x00, 0x3a, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //................%@@@...@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x24, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde,  //...............%@@@@@...@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xb0, 0xff, 0xff, 0xff, 0x8e, 0xd2, 0xff, 0xe2, 0x24, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x56,  //..............%@@@%@@@...@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xb0, 0xff, 0xff, 0xff, 0x7a, 0x32, 0xf0, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00,  //.............%@@@+.@@@@...@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xb0, 0xff, 0xff, 0xff, 0x7a, 0x32, 0xee, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0x68, 0x00, 0x00,  //............%@@@+.@@@@@@...@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xb2, 0xff, 0xff, 0xff, 0x7a, 0x32, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x3a, 0xf0, 0x68, 0x00, 0x00, 0x00,  //...........%@@@+.@@@@@@@@...@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xb2, 0xff, 0xff, 0xff, 0x78, 0x32, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00,  //..........%@@@+.@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb2, 0xff, 0xff, 0xff, 0x78, 0x32, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@+.@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb4, 0xff, 0xff, 0xff, 0x78, 0x32, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@+.@@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb4, 0xff, 0xff, 0xff, 0x78, 0x32, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@@+.@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb6, 0xff, 0xff, 0xff, 0x78, 0x32, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@+.@@@@@@@@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x06, 0xb6, 0xff, 0xff, 0xff, 0x78, 0x32, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@+.@@@@@@@@@@@@+.........
    0x00, 0x00, 0x00, 0x06, 0xb6, 0xff, 0xff, 0xff, 0x76, 0x32, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@@+.@@@@@@@@@@@@+..........
    0x00, 0x00, 0x06, 0xb6, 0xff, 0xff, 0xff, 0x76, 0x32, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@+.@@@@@@@@@@@@+...........
    0x00, 0x06, 0xb8, 0xff, 0xff, 0xff, 0xaa, 0x32, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@%.@@@@@@@@@@@@+............
    0x06, 0xb8, 0xff, 0xff, 0xfc, 0xff, 0xf8, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@+.............
    0xb8, 0xff, 0xff, 0xf4, 0x44, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@+%@@@@@@@@@@@@+..............
    0xff, 0xff, 0xf6, 0x44, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+..%@@@@@@@@@@+...............
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@....%@@@@@@@@+................
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....%@@@@@@+.................
    0xff, 0xff, 0xf6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@+...%@@@@+..................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@%...%@@@+...................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x88, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@%..%@@@+....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@+.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@+......................
    0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@+.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................


    /*Unicode: U+f048 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x1c, 0x66, 0x6a, 0x6a, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x10,  //.++++..................
    0xda, 0xff, 0xff, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xfa, 0x44,  //@@@@@+..............+@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xfa, 0xff, 0x46,  //@@@@@%.............+@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xfa, 0xff, 0xff, 0x46,  //@@@@@%............+@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xfa, 0xff, 0xff, 0xff, 0x46,  //@@@@@%...........+@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xfa, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%..........+@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%.........+@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%........+@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%.......+@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%......+@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%.....+@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x56, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%....+@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x56, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%...+@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x56, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%..+@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x56, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%.+@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x56, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%+@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%.@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%..@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%...@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%....@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%.....@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%......@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%.......@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%........@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%.........@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%..........@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%...........@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xff, 0x46,  //@@@@@%............@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0x46,  //@@@@@%.............@@@+
    0xfa, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0x46,  //@@@@@%..............@@+
    0x92, 0xfa, 0xff, 0xff, 0xe8, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xce, 0x38,  //%@@@@................@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f04b () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0xac, 0x80, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%+.............................
    0xff, 0xff, 0xe6, 0x66, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+...........................
    0xff, 0xff, 0xff, 0xff, 0xd4, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@+.........................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%........................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x9e, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@%......................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x82, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x64, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@+..................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@+................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@%...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x9e, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@%.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x80, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x64, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@+.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@+.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@%......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x9e, 0x1a, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x80, 0x0a, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x42,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x58,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xa6, 0x1e, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x34, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x6c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@+.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x8a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@%.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xa6, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@%...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@+..............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x6e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@+................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x8a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@%..................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xa6, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@......................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@+.......................
    0xff, 0xff, 0xff, 0xff, 0xea, 0x6e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@+.........................
    0xff, 0xff, 0xf6, 0x8a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%...........................
    0xd0, 0xa4, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@%.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f04c () , Width: 33 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x1c, 0x66, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x64, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x64, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x66, 0x1c,  //.++++++++++++.......++++++++++++.
    0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@@@@@@@@@@@@.....@@@@@@@@@@@@@@
    0x92, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x90,  //%@@@@@@@@@@@@+.....+@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................................


    /*Unicode: U+f04d () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x1c, 0x66, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x44, 0x00,  //.++++++++++++++++++++++++++++++++.
    0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x44,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x92, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x1c,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f051 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x3c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x66, 0x6a, 0x6a, 0x52, 0x00,  //..................++++.
    0xb4, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0x68,  //%@...............@@@@@+
    0xb6, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@..............@@@@@%
    0xb6, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@.............@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@............@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@...........@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@..........@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@.........@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@........@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@@.......@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@@@......@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@@@@.....@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@@@@@....@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@@@@@@...@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@@@@@@@..@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@@@@@@@@.@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@@@@@@@@@@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@@@@@@@@@@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x78, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@@@@@@@@+@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@@@@@@@+.@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@@@@@@+..@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@@@@@+...@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@@@@+....@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@@@+.....@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@@+......@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@@+.......@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@@+........@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@@+.........@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@@+..........@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@@+...........@@@@@%
    0xb6, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@@+............@@@@@%
    0xb6, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //%@@+.............@@@@@%
    0xb6, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfa, 0xff, 0xff, 0xff, 0xff, 0x8a,  //%@+..............@@@@@%
    0xa6, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xfa, 0xff, 0xff, 0xe8, 0x34,  //%+...............%@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f052 () , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xec, 0xb4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............+@%................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xfa, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............+@@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+@@@@@@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+@@@@@@@@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@@@@@@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@@@@@@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@@@@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@@@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x5a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x5a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x5a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x00, 0x5a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0x58, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xbe, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd4, 0x4a,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x14, 0x56, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x36, 0x00,  //.+++++++++++++++++++++++++++++++..
    0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x42,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x92, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x1e,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+f053 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xe2, 0xca, 0x1a, 0x00, 0x00, 0x00,  //.................@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xda, 0x1a, 0x00, 0x00,  //................@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xda, 0x1a, 0x00,  //...............@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x1a,  //..............@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc,  //.............@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc,  //............@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x1a,  //...........@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x1a, 0x00,  //..........@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x1a, 0x00, 0x00,  //.........@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x1a, 0x00, 0x00, 0x00,  //........@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x1a, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x38, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x38, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@........
    0x00, 0x00, 0x38, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@.........
    0x00, 0x38, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@@@@..........
    0x30, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@...........
    0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@@............
    0x3c, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@...........
    0x00, 0x46, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@@@@@@@..........
    0x00, 0x00, 0x46, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@@@@@@.........
    0x00, 0x00, 0x00, 0x46, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x48, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x12, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x12, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x12, 0x00, 0x00,  //........+@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x12, 0x00,  //.........+@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x12,  //..........+@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2,  //...........+@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2,  //............+@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22,  //.............+@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00,  //..............+@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf6, 0xff, 0xff, 0xe4, 0x24, 0x00, 0x00,  //...............+@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xf0, 0xdc, 0x24, 0x00, 0x00, 0x00,  //................+@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f054 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x2e, 0xdc, 0xd2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@.................
    0x00, 0x00, 0x2e, 0xea, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@................
    0x00, 0x2e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@...............
    0x2e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@..............
    0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@.............
    0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@............
    0x2e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@...........
    0x00, 0x2e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@@@@..........
    0x00, 0x00, 0x2e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@.........
    0x00, 0x00, 0x00, 0x2e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x2e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x00, 0x00,  //........@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x00,  //.........@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x22, 0x00,  //..........@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x1a,  //...........@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72,  //...........+@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x22,  //...........@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00,  //..........@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00,  //.........@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00,  //........@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x24, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x24, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@........
    0x00, 0x00, 0x22, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@.........
    0x00, 0x22, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@@@@..........
    0x22, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@...........
    0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@............
    0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@.............
    0x38, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@..............
    0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@...............
    0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@................
    0x00, 0x00, 0x00, 0x3a, 0xea, 0xe4, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@.................
    0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f067 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x72, 0xa0, 0xa2, 0xa2, 0xa2, 0x9a, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+%%%%%+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@@@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x02, 0x5c, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7a, 0x38, 0x00,  //.++++++++++@@@@@@@@%+++++++++..
    0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x46,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x2a, 0xb8, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xd6, 0x92, 0x06,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xd0, 0xfc, 0xff, 0xff, 0xff, 0xf6, 0xa2, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@@@@%............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f068 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x38, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x56, 0x1c, 0x00,  //..+++++++++++++++++++++++++++..
    0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x34,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x40, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xb6, 0x0e,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f071 () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1a, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xe6, 0xff, 0xe4, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................+@@@+.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xf0, 0xff, 0xff, 0xff, 0xee, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................@@@@@.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................%@@@@@%................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................@@@@@@@................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............%@@@@@@@%...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............@@@@@@@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............@@@@@@@@@@@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+@@@@@@@@@@@@@+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@@@@@@@@@@@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+@@@@%.....%@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xf2, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@+.....+@@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@+.....+@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@@+.....+@@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@@@@+.....%@@@@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@%.....%@@@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@@%.....%@@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@%.....%@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@%.....%@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@%.....%@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x06, 0x00, 0x00, 0x00, 0x06, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@.....@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x1a, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x1a, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xd6, 0xd6, 0xd6, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x2a, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x2a, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@.....@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@@@%.....%@@@@@@@@@@@@%...
    0x00, 0x00, 0x40, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0x00, 0x00,  //...@@@@@@@@@@@@@%.....%@@@@@@@@@@@@@...
    0x00, 0x00, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x00, 0x00,  //..@@@@@@@@@@@@@@%.....%@@@@@@@@@@@@@@..
    0x00, 0x58, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x58, 0x00,  //.+@@@@@@@@@@@@@@%.....%@@@@@@@@@@@@@@+.
    0x04, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x96, 0x8e, 0x8e, 0x8e, 0x96, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x04,  //.@@@@@@@@@@@@@@@@%%%%%@@@@@@@@@@@@@@@@.
    0x70, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x0e, 0xa4, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xa4, 0x0e,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................


    /*Unicode: U+f074 () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xe0, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xee, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................+@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xee, 0x32, 0x00, 0x00, 0x00, 0x00,  //..............................+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xee, 0x32, 0x00, 0x00, 0x00,  //..............................+@@@@....
    0x0c, 0x1e, 0x1e, 0x1e, 0x1e, 0x1c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xee, 0x32, 0x00, 0x00,  //..............................+@@@@@...
    0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0xb4, 0x5c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x7a, 0xc8, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x32, 0x00,  //@@@@@@@@%+...........+@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x82, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x32,  //@@@@@@@@@@@+.......%@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x74, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@+.....%@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x04, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //@@@@@@@@@@@@@+...%@@@@@@@@@@@@@@@@@@@@+
    0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3e, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00,  //@@@@@@@@@@@@@@..%@@@@@@@@@@@@@@@@@@@@+.
    0x54, 0x72, 0x72, 0x72, 0x72, 0x74, 0x8c, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x1a, 0x44, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xb4, 0x80, 0x72, 0x72, 0x72, 0x72, 0x72, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0x74, 0x00, 0x00,  //++++++%@@@@@@@.+@@@@@@@%++++++%@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xfa, 0xff, 0xff, 0xff, 0x80, 0x04, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00,  //........+@@@@+.@@@@@@@........+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0xee, 0x0c, 0x66, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00,  //.........+@@@.+@@@@@@.........+@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0x82, 0x04, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@%.@@@@@@+.........+@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf2, 0x16, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@.+@@@@@@..........+@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+.@@@@@@+...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............@@@@@@....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............%@@@@@+....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@@@@.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x06, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@@@+.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x16, 0x60, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xfc, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@.+%..........+@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x96, 0x00, 0xd2, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xfc, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%.@@+.........+@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x1c, 0x4c, 0xff, 0xff, 0xe0, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xfc, 0x60, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@@.+@@@.........+@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0xcc, 0xff, 0xff, 0xff, 0xc8, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xfc, 0x60, 0x00, 0x00, 0x00,  //........+@@@@@@%.@@@@@........+@@@@+...
    0x3c, 0x5a, 0x5a, 0x5a, 0x5a, 0x5c, 0x72, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x0e, 0x58, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x9e, 0x66, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x94, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x60, 0x00, 0x00,  //.++++++%@@@@@@@.+@@@@@@%++++++%@@@@@+..
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x48, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x60, 0x00,  //@@@@@@@@@@@@@@+.%@@@@@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00, 0x0c, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x60,  //@@@@@@@@@@@@@+...@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x18, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,  //@@@@@@@@@@@@%.....@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x9c, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x40,  //@@@@@@@@@@@+.......%@@@@@@@@@@@@@@@@@@.
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xca, 0x72, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x9c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x40, 0x00,  //@@@@@@@@@+...........%@@@@@@@@@@@@@@@..
    0x20, 0x36, 0x36, 0x36, 0x36, 0x34, 0x28, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x2c, 0x3a, 0x3e, 0x3c, 0x3a, 0x38, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x40, 0x00, 0x00,  //..............................+@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xf4, 0x42, 0x00, 0x00, 0x00,  //..............................+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xf4, 0x42, 0x00, 0x00, 0x00, 0x00,  //..............................+@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xf4, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................+@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xf2, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................+@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................


    /*Unicode: U+f077 () , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xee, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................+@+................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............%@@@%...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............%@@@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............%@@@@@@@%.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............%@@@@@@@@@%............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@@@@@@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@@@@@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@@@@@@@@@@@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@@@@@@@@@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@@@@@@@@@@@@@@@@@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@@@@@@@@@@@@@@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@%.%@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@%...%@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@%.....%@@@@@@@@@@%...
    0x00, 0x00, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00, 0x00,  //..%@@@@@@@@@@%.......%@@@@@@@@@@%..
    0x00, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00,  //.%@@@@@@@@@@%.........%@@@@@@@@@@%.
    0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86,  //%@@@@@@@@@@%...........%@@@@@@@@@@%
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@@@@@@@@%.............%@@@@@@@@@@
    0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9a,  //%@@@@@@@@%...............%@@@@@@@@%
    0x02, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x00,  //.%@@@@@@%.................%@@@@@@%.
    0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00,  //..%@@@@%...................%@@@@%..
    0x00, 0x00, 0x00, 0xa0, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00,  //...%@@%.....................%@@%...
    0x00, 0x00, 0x00, 0x00, 0x66, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x66, 0x00, 0x00, 0x00, 0x00,  //....++.......................++....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+f078 () , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x16, 0xb0, 0xa6, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xa8, 0xae, 0x16, 0x00, 0x00, 0x00,  //....%%.......................%%....
    0x00, 0x00, 0x18, 0xd6, 0xff, 0xff, 0xca, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xca, 0xff, 0xff, 0xd6, 0x16, 0x00, 0x00,  //...@@@@.....................@@@@...
    0x00, 0x18, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xca, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xca, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x18, 0x00,  //..@@@@@@...................@@@@@@..
    0x18, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x18,  //.@@@@@@@@.................@@@@@@@@.
    0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce,  //@@@@@@@@@@...............@@@@@@@@@@
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.............@@@@@@@@@@@
    0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x4c,  //+@@@@@@@@@@@...........@@@@@@@@@@@+
    0x00, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x4c, 0x00,  //.+@@@@@@@@@@@.........@@@@@@@@@@@+.
    0x00, 0x00, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x4c, 0x00, 0x00,  //..+@@@@@@@@@@@.......@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x0e, 0x00, 0x00, 0x00, 0x0e, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x4c, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@.....@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x0e, 0x00, 0x0e, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x4c, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@...@@@@@@@@@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x20, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@.@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@@@@@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@@@@@@@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@@@@@@@@@@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+@@@@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+@@@@@@@@@+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............+@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf8, 0xff, 0xff, 0xff, 0xf6, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............+@@@@@+..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf8, 0xff, 0xf6, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............+@@@+...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xa6, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................%.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+f079 () , Width: 42 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xa4, 0xf0, 0x66, 0x00, 0x00, 0x00, 0x00, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@+....@@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xfc, 0x48, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@+...%@@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x2a, 0x00, 0x00, 0x02, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@....%@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x3e, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x12, 0x00, 0x00, 0x10, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@....@@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x22, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x04, 0x00, 0x00, 0x26, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@%....@@@@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x0e, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x38, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@@%....%%%%%%%%%%%%%@@@@@......
    0x00, 0x02, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@@@@@@@@@+...............+@@@@@......
    0x00, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@@+..............+@@@@@......
    0x64, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@@@@@@@@..............+@@@@@......
    0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@%.............+@@@@@......
    0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@@@@+.............+@@@@@......
    0x00, 0x1a, 0x1e, 0x1e, 0x1e, 0x7c, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0x1e, 0x1e, 0x1e, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@...................+@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@...................+@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x22, 0x22, 0x22, 0x16, 0x00,  //.....+@@@@@...................%@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x62,  //.....+@@@@@..............%@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //.....+@@@@@..............@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x22,  //.....+@@@@@..............+@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x42, 0x00,  //.....+@@@@@...............%@@@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x68, 0x00, 0x00,  //.....+@@@@@................%@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x8e, 0x18, 0x00, 0x00, 0x0c, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00,  //.....+@@@@@%%%%%%%%%%%%%....@@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x08, 0x00, 0x00, 0x20, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x02, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@....@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x3c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x10, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@%....@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0xff, 0xee, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@+...+@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xfa, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@+...%@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xee, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@@%....%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........................................


    /*Unicode: U+f07b () , Width: 37 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x10, 0x6c, 0x98, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0x92, 0x52, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+%%%%%%%%%+.......................
    0x00, 0x42, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@@@@@@@@@......................
    0x28, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@@@@.....................
    0xa8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@@@@+....................
    0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@%....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@%....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x8a, 0x0a, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x0e, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0a,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2e,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2c,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x08,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x58, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x08, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0x58, 0xc8, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xd6, 0x78, 0x04, 0x00, 0x00,  //..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................................


    /*Unicode: U+f093 () , Width: 36 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xfc, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................@@+................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................@@@@+...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............@@@@@@+..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............@@@@@@@@@@+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@@@@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@@@@@@@@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@@@@@@@@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@@@@@@@@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@@@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x42, 0x46, 0x46, 0x46, 0x46, 0x52, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c, 0x46, 0x46, 0x46, 0x46, 0x46, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........++++++@@@@@@@@++++++........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@@@@@@..............
    0x08, 0x70, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x4e, 0x00, 0x00, 0x22, 0x68, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x3a, 0x00, 0x00, 0x2c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x72, 0x08,  //.+%%%%%%%%%+...++++++....%%%%%%%%%+.
    0xaa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac,  //%@@@@@@@@@@@............%@@@@@@@@@@%
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@..........%@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xb6, 0x94, 0x92, 0x92, 0x92, 0x92, 0x92, 0xac, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@%%%%%%%%@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x88, 0x0c, 0x7a, 0xff, 0xff, 0xfc, 0x3e, 0x3e, 0xfc, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@%.+@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1e, 0x00, 0x0a, 0xff, 0xff, 0xe0, 0x00, 0x00, 0xe0, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@...@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86, 0x0a, 0x76, 0xff, 0xff, 0xfc, 0x3c, 0x3c, 0xfc, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@%.+@@@..@@@
    0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x26, 0xb4, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xb4, 0x26,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................................


    /*Unicode: U+f095 () , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x0a, 0x4e, 0x86, 0x9a, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+%%........................
    0x00, 0x00, 0x4a, 0xec, 0xff, 0xff, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@%.......................
    0x00, 0x2a, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@+......................
    0x00, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@......................
    0x44, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@+.....................
    0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@.....................
    0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%....................
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@....................
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%....................
    0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@%.....................
    0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@%......................
    0x36, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@%.......................
    0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@+.......................
    0x00, 0x76, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@%.......................
    0x00, 0x14, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@+......................
    0x00, 0x00, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@@@@......................
    0x00, 0x00, 0x1e, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@%.....................
    0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@@@@+....................
    0x00, 0x00, 0x00, 0x04, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@+...................
    0x00, 0x00, 0x00, 0x00, 0x24, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@+..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xbe, 0xfc, 0x98, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@+........%@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x02, 0xb4, 0xff, 0xff, 0xff, 0xe6, 0x62, 0x02, 0x00, 0x00, 0x00,  //......+@@@@@@@%......%@@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x54, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x48, 0x00, 0x00,  //.......+@@@@@@@@+...%@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x4a, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x20,  //........+@@@@@@@@%+%@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9a,  //.........+@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86,  //..........+@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4e,  //............@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x82, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x0a,  //.............%@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x9e, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x4a, 0x00,  //...............%@@@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x76, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x2a, 0x00, 0x00,  //.................+@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x8a, 0xca, 0xf0, 0xfa, 0xe0, 0xa2, 0x44, 0x00, 0x00, 0x00, 0x00,  //....................%@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+f0c4 () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x04, 0x60, 0xb8, 0xe8, 0xf8, 0xec, 0xca, 0x8e, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+%@@@@%.............................
    0x00, 0x1e, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@@%...........................
    0x0a, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x02, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@+.........................
    0x7a, 0xff, 0xff, 0xff, 0xf2, 0xa2, 0x82, 0x8e, 0xc4, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xce, 0xff, 0xde, 0x62, 0x02, 0x00,  //+@@@@%%%@@@@@@%..................@@@+..
    0xd2, 0xff, 0xff, 0xde, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x22, 0xa8, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xac, 0xff, 0xc8, 0x52, 0xac, 0xfc, 0xdc, 0x30,  //@@@@......%@@@@+...............%@@+%@@.
    0xf6, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xfa, 0xff, 0xff, 0xe8, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x88, 0xf8, 0xe4, 0x5e, 0x00, 0x00, 0x00, 0x32, 0xec, 0xa6,  //@@@+.......+@@@@.............%@@+....@%
    0xea, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xe8, 0xf6, 0x86, 0x0a, 0x00, 0x00, 0x00, 0x12, 0xb8, 0xfa, 0x52,  //@@@%........+@@@+..........+@@%.....%@+
    0xb0, 0xff, 0xff, 0xf4, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe8, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xce, 0xff, 0xae, 0x22, 0x00, 0x00, 0x00, 0x00, 0x30, 0xde, 0xe8, 0x3e, 0x00,  //%@@@.........@@@%.........@@%......@@..
    0x4a, 0xff, 0xff, 0xff, 0xd6, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xac, 0xff, 0xd2, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xf6, 0xca, 0x1c, 0x00, 0x00,  //+@@@@........@@@%.......%@@+.....+@@...
    0x00, 0xb8, 0xff, 0xff, 0xff, 0xee, 0x68, 0x04, 0x00, 0x00, 0x00, 0x00, 0x36, 0xfa, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x88, 0xf8, 0xec, 0x6c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x04, 0x96, 0xff, 0x9c, 0x06, 0x00, 0x00, 0x00,  //.%@@@@+......@@@%.....%@@+......%@%....
    0x00, 0x10, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x9c, 0x72, 0x74, 0xa2, 0xfa, 0xff, 0xff, 0xff, 0xee, 0x62, 0x00, 0x00, 0x64, 0xe8, 0xfa, 0x94, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xc6, 0xf8, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@%++%@@@@@+..+@@%.......@@+.....
    0x00, 0x00, 0x14, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x94, 0xfa, 0xb8, 0xce, 0xff, 0xbc, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xe6, 0xe6, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@@@%@%@@%........@@.......
    0x00, 0x00, 0x00, 0x02, 0x74, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x0e, 0x00, 0xa6, 0xff, 0xdc, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xfa, 0xc4, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@..%@@+.......+@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x68, 0xb6, 0xee, 0xff, 0xff, 0xf0, 0xb4, 0x98, 0xff, 0xc4, 0x66, 0xff, 0x80, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xa4, 0xff, 0x96, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+%@@@@%%@@+@+........%@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x00, 0x00, 0x00, 0x3e, 0xd0, 0xff, 0xff, 0x1a, 0x5a, 0xdc, 0x7a, 0x00, 0x00, 0x00, 0x22, 0xd0, 0xf6, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............@@@.+@+....@@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xce, 0xff, 0x1a, 0xca, 0xff, 0xf0, 0x00, 0x00, 0x4a, 0xee, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................@@.@@@..+@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x16, 0x18, 0x02, 0x00, 0x00, 0x4c, 0xdc, 0xf8, 0x84, 0x04, 0x50, 0xce, 0x6e, 0x00, 0x80, 0xfc, 0xbc, 0xb6, 0xfa, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............+@@%.+@+.+@%%@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x74, 0xc6, 0xf8, 0xff, 0xff, 0xfc, 0xc2, 0xa8, 0xff, 0xb8, 0x24, 0x00, 0x14, 0x4e, 0x06, 0x10, 0xb4, 0xff, 0x8a, 0x02, 0x00, 0x86, 0xff, 0xa2, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@%@%...+..%@%..%@%.........
    0x00, 0x00, 0x00, 0x06, 0x80, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x12, 0x00, 0x56, 0xea, 0xff, 0xf2, 0xe4, 0xf2, 0x56, 0x00, 0x00, 0x00, 0x00, 0x52, 0xf2, 0xcc, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@..+@@@@@+....+@@........
    0x00, 0x00, 0x1a, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0xac, 0xff, 0xa8, 0xc2, 0xff, 0xfc, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xda, 0xea, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@@%@%@@@+.......@@+......
    0x00, 0x14, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xde, 0x8e, 0x64, 0x64, 0x94, 0xf6, 0xff, 0xff, 0xff, 0xe6, 0x52, 0x00, 0x00, 0x58, 0xe0, 0xf6, 0x84, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xb4, 0xfa, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@%++%@@@@@+..+@@%.......%@+.....
    0x00, 0xc0, 0xff, 0xff, 0xff, 0xe8, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xf8, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x08, 0x7e, 0xf4, 0xe4, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xfc, 0xa4, 0x08, 0x00, 0x00, 0x00,  //.%@@@@+......@@@%.....+@@+......%@%....
    0x50, 0xff, 0xff, 0xff, 0xd2, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa6, 0xff, 0xca, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xf0, 0xce, 0x1e, 0x00, 0x00,  //+@@@@........@@@%.......%@@......+@@...
    0xb4, 0xff, 0xff, 0xf4, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xea, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xca, 0xff, 0xa8, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x28, 0xd6, 0xea, 0x42, 0x00,  //%@@@.........@@@%.........@@%......@@+.
    0xec, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xe6, 0xf6, 0x82, 0x0a, 0x00, 0x00, 0x00, 0x0c, 0xb0, 0xfa, 0x54,  //@@@%........+@@@+..........+@@%.....%@+
    0xf8, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xfa, 0xff, 0xff, 0xe4, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x88, 0xf8, 0xe4, 0x5e, 0x00, 0x00, 0x00, 0x36, 0xec, 0xa6,  //@@@%.......+@@@@.............%@@+....@%
    0xd6, 0xff, 0xff, 0xde, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x24, 0xaa, 0xff, 0xff, 0xff, 0xff, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xae, 0xff, 0xca, 0x56, 0xb0, 0xff, 0xda, 0x30,  //@@@@......%@@@@+...............%@@+%@@.
    0x82, 0xff, 0xff, 0xff, 0xf4, 0xa2, 0x82, 0x8e, 0xc4, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xd2, 0xff, 0xde, 0x60, 0x02, 0x00,  //%@@@@%%%@@@@@@%.................+@@@+..
    0x0e, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x02, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@+.........................
    0x00, 0x20, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@@%...........................
    0x00, 0x00, 0x04, 0x62, 0xb8, 0xe8, 0xfa, 0xee, 0xcc, 0x8e, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+%@@@@%.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................................


    /*Unicode: U+f0c5 () , Width: 39 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x92, 0xca, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xb2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............%@@@@@@@@@@%...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@@@@@@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@@@@@@@@@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@........@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@........@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xff, 0xaa, 0xd8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@%@@@........@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xba, 0x04, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@%.@@@........@@@..............
    0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xc8, 0x0a, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@@..@@@........@@@..............
    0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xd4, 0x12, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@...@@@........@@@..............
    0x00, 0x00, 0x72, 0xff, 0xff, 0xff, 0xe0, 0x1a, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x4c, 0xbc, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x40,  //..+@@@@....@@@........@@@+%@@@@@@@@@@@.
    0x00, 0x6a, 0xff, 0xff, 0xff, 0xe8, 0x26, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc,  //.+@@@@.....@@@........@@@@@@@@@@@@@@@@@
    0x2e, 0xfa, 0xff, 0xff, 0xf0, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@......@@@........@@@@@@@@@@@@@@@@@
    0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0xff, 0xff, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff,  //%@@@@@@@@@@@@@........@@@@@@........@@@
    0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xa2, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff,  //@@@@@@@@@@@@@@.......%@@@@@@........@@@
    0xff, 0xff, 0xf8, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xb4, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xa4, 0xff, 0xff, 0xfa, 0x5c, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff,  //@@@@@@@@@@@@%.......%@@@+@@@........@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xa4, 0xff, 0xff, 0xf8, 0x50, 0x00, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff,  //@@@................%@@@+.@@@........@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xa8, 0xff, 0xff, 0xf4, 0x46, 0x00, 0x00, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff,  //@@@...............%@@@+..@@@........@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaa, 0xff, 0xff, 0xf0, 0x3a, 0x00, 0x00, 0x00, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff,  //@@@..............%@@@....@@@........@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xac, 0xff, 0xff, 0xea, 0x30, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff,  //@@@.............%@@@.....@@@........@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0xe4, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff,  //@@@............%@@@......@@@........@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff,  //@@@...........+@@@@@@@@@@@@@........@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff,  //@@@...........@@@@@@@@@@@@@%........@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf4, 0xff, 0xf2, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd4, 0xa2, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff,  //@@@...........@@@@@@@@@@@@%.........@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff,  //@@@...........@@%...................@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff,  //@@@...........@@%...................@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff,  //@@@...........@@%...................@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff,  //@@@...........@@%...................@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff,  //@@@....