
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_SYMBOL_30 != 0  /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * fontawesome-webfont.ttf 30 px Font in U+f000 () .. U+f2ee ()  range with 1 bpp
 * Sparse font with only these characters:     
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_symbol_30_glyph_bitmap[] = {
#if USE_LV_FONT_SYMBOL_30 == 1
    /*Unicode: U+f001 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x03, 0x00,  //.....................+%%+
    0x00, 0x00, 0x1f, 0x80,  //..................+%@@@@@
    0x00, 0x00, 0xff, 0x80,  //...............+@@@@@@@@@
    0x00, 0x0f, 0xff, 0x80,  //...........+%@@@@@@@@@@@@
    0x00, 0x7f, 0xff, 0x80,  //.........%@@@@@@@@@@@@@@@
    0x00, 0xff, 0xff, 0x80,  //........@@@@@@@@@@@@@@@@@
    0x00, 0xff, 0xff, 0x80,  //........@@@@@@@@@@@@@@@@@
    0x00, 0xff, 0xff, 0x80,  //........@@@@@@@@@@@@@@@@@
    0x00, 0xff, 0xff, 0x80,  //........@@@@@@@@@@@@@@@@@
    0x00, 0xff, 0xf1, 0x80,  //........@@@@@@@@@@@%+..@@
    0x00, 0xff, 0x81, 0x80,  //........@@@@@@@@%+.....@@
    0x00, 0xfc, 0x01, 0x80,  //........@@@@@%.........@@
    0x00, 0xc0, 0x01, 0x80,  //........@@+............@@
    0x00, 0xc0, 0x01, 0x80,  //........@@.............@@
    0x00, 0xc0, 0x01, 0x80,  //........@@.............@@
    0x00, 0xc0, 0x01, 0x80,  //........@@.............@@
    0x00, 0xc0, 0x01, 0x80,  //........@@.............@@
    0x00, 0xc0, 0x7f, 0x80,  //........@@......+@@@@@%@@
    0x00, 0xc1, 0xff, 0x80,  //........@@.....@@@@@@@@@@
    0x00, 0xc1, 0xff, 0x80,  //........@@....+@@@@@@@@@@
    0x00, 0xc1, 0xff, 0x80,  //........@@.....@@@@@@@@@@
    0x3f, 0xc1, 0xff, 0x00,  //.+%@@@@%@@.....%@@@@@@@@+
    0xff, 0xc0, 0x7c, 0x00,  //%@@@@@@@@@.......%@@@@+..
    0xff, 0xc0, 0x00, 0x00,  //@@@@@@@@@@...............
    0xff, 0xc0, 0x00, 0x00,  //@@@@@@@@@@...............
    0xff, 0x80, 0x00, 0x00,  //%@@@@@@@@+...............
    0x3f, 0x00, 0x00, 0x00,  //.+%@@@@%.................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f008 () , Width: 32 */
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x7f, 0xff, 0xff, 0xfc,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0xfe,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xc3, 0x00, 0x01, 0x86,  //@@+..+@@+.............+@@+..+@@.
    0xc3, 0x00, 0x01, 0x86,  //@@....@@...............@@....@@.
    0xc3, 0x00, 0x01, 0x86,  //@@....@@...............@@....@@.
    0xc3, 0x00, 0x01, 0x86,  //@@+...@@...............@@....@@.
    0xff, 0x00, 0x01, 0xfe,  //@@@@@@@@...............@@@@@@@@.
    0xff, 0x00, 0x01, 0xfe,  //@@@@@@@@...............@@@@@@@@.
    0xc3, 0x00, 0x01, 0x86,  //@@+..+@@...............@@+..+@@.
    0xc3, 0x00, 0x01, 0x86,  //@@....@@...............@@....@@.
    0xc3, 0x00, 0x01, 0x86,  //@@....@@...............@@....@@.
    0xc3, 0x00, 0x01, 0x86,  //@@....@@...............@@....@@.
    0xc3, 0x00, 0x01, 0x86,  //@@+..+@@+.............+@@+..+@@.
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xc3, 0x00, 0x01, 0x86,  //@@+...@@+.............+@@....@@.
    0xc3, 0x00, 0x01, 0x86,  //@@....@@...............@@....@@.
    0xc3, 0x00, 0x01, 0x86,  //@@....@@...............@@....@@.
    0xc3, 0x00, 0x01, 0x86,  //@@+..+@@...............@@+..+@@.
    0xff, 0x00, 0x01, 0xfe,  //@@@@@@@@...............@@@@@@@@.
    0xff, 0x00, 0x01, 0xfe,  //@@@@@@@@...............@@@@@@@@.
    0xc3, 0x00, 0x01, 0x86,  //@@+...@@...............@@....@@.
    0xc3, 0x00, 0x01, 0x86,  //@@....@@...............@@....@@.
    0xc3, 0x00, 0x01, 0x86,  //@@....@@...............@@....@@.
    0xc3, 0x00, 0x01, 0x86,  //@@+...@@+.............+@@....@@.
    0xff, 0xff, 0xff, 0xfe,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x7f, 0xff, 0xff, 0xfc,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f00b () , Width: 29 */
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x7f, 0x1f, 0xff, 0xf0,  //+@@@@@@%...@@@@@@@@@@@@@@@@@+
    0xff, 0x3f, 0xff, 0xf8,  //@@@@@@@@..%@@@@@@@@@@@@@@@@@@
    0xff, 0x3f, 0xff, 0xf8,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0x3f, 0xff, 0xf8,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0x3f, 0xff, 0xf8,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0x1f, 0xff, 0xf8,  //%@@@@@@@..+@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0xff, 0x1f, 0xff, 0xf8,  //%@@@@@@@..+@@@@@@@@@@@@@@@@@%
    0xff, 0x3f, 0xff, 0xf8,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0x3f, 0xff, 0xf8,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0x3f, 0xff, 0xf8,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0x3f, 0xff, 0xf8,  //@@@@@@@@..%@@@@@@@@@@@@@@@@@@
    0x7f, 0x1f, 0xff, 0xf0,  //+@@@@@@%...@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0xff, 0x1f, 0xff, 0xf8,  //%@@@@@@@..+@@@@@@@@@@@@@@@@@%
    0xff, 0x3f, 0xff, 0xf8,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0x3f, 0xff, 0xf8,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0x3f, 0xff, 0xf8,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0x3f, 0xff, 0xf8,  //@@@@@@@@..%@@@@@@@@@@@@@@@@@@
    0x7f, 0x1f, 0xff, 0xf0,  //+@@@@@@%...@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f00c () , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.....................+...
    0x00, 0x00, 0x0e, 0x00,  //...................+@@@..
    0x00, 0x00, 0x1f, 0x00,  //..................+@@@@@.
    0x00, 0x00, 0x3f, 0x80,  //.................+@@@@@@@
    0x00, 0x00, 0x7f, 0x80,  //................+@@@@@@@@
    0x00, 0x00, 0xff, 0x00,  //...............+@@@@@@@@+
    0x10, 0x01, 0xfe, 0x00,  //...%+.........+@@@@@@@@+.
    0x38, 0x03, 0xfc, 0x00,  //..@@@+.......+@@@@@@@@+..
    0x7c, 0x07, 0xf8, 0x00,  //.@@@@@+.....+@@@@@@@@+...
    0xfe, 0x0f, 0xf0, 0x00,  //@@@@@@@+...+@@@@@@@@+....
    0xff, 0x1f, 0xe0, 0x00,  //@@@@@@@@+.+@@@@@@@@+.....
    0x7f, 0xff, 0xc0, 0x00,  //+@@@@@@@@%@@@@@@@@+......
    0x3f, 0xff, 0x80, 0x00,  //.+@@@@@@@@@@@@@@@+.......
    0x1f, 0xff, 0x00, 0x00,  //..+@@@@@@@@@@@@@+........
    0x0f, 0xfe, 0x00, 0x00,  //...+@@@@@@@@@@@+.........
    0x07, 0xfc, 0x00, 0x00,  //....+@@@@@@@@@+..........
    0x03, 0xf8, 0x00, 0x00,  //.....+@@@@@@@+...........
    0x01, 0xf0, 0x00, 0x00,  //......+@@@@@+............
    0x00, 0xe0, 0x00, 0x00,  //.......+@@@+.............
    0x00, 0x40, 0x00, 0x00,  //........+%+..............
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f00d () , Width: 20 */
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x1c, 0x01, 0x80,  //...%@%.........%@+..
    0x3e, 0x03, 0xc0,  //..%@@@%.......@@@@+.
    0x7f, 0x07, 0xe0,  //.%@@@@@%.....@@@@@@+
    0x7f, 0x8f, 0xf0,  //.@@@@@@@%...@@@@@@@@
    0x7f, 0xdf, 0xf0,  //.@@@@@@@@%.@@@@@@@@%
    0x3f, 0xff, 0xe0,  //..@@@@@@@@@@@@@@@@@.
    0x1f, 0xff, 0xc0,  //...@@@@@@@@@@@@@@@..
    0x0f, 0xff, 0x80,  //....@@@@@@@@@@@@@...
    0x07, 0xff, 0x00,  //.....@@@@@@@@@@@....
    0x03, 0xfe, 0x00,  //.....+@@@@@@@@@.....
    0x07, 0xff, 0x00,  //.....@@@@@@@@@@%....
    0x0f, 0xff, 0x80,  //....@@@@@@@@@@@@%...
    0x1f, 0xff, 0xc0,  //...@@@@@@@@@@@@@@%..
    0x3f, 0xff, 0xe0,  //..@@@@@@@@@@@@@@@@%.
    0x7f, 0xdf, 0xf0,  //.@@@@@@@@@+@@@@@@@@%
    0x7f, 0x8f, 0xf0,  //.@@@@@@@@...@@@@@@@@
    0x7f, 0x07, 0xf0,  //.@@@@@@@.....@@@@@@%
    0x3e, 0x03, 0xe0,  //..@@@@@.......@@@@%.
    0x1c, 0x01, 0xc0,  //...@@@.........@@%..
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................


    /*Unicode: U+f011 () , Width: 25 */
    0x00, 0x18, 0x00, 0x00,  //...........@@+...........
    0x00, 0x3c, 0x00, 0x00,  //..........@@@@...........
    0x00, 0x3c, 0x00, 0x00,  //..........@@@@...........
    0x00, 0x3c, 0x00, 0x00,  //..........@@@@...........
    0x06, 0x3c, 0x60, 0x00,  //.....%%...@@@@...%%......
    0x0f, 0x3c, 0xf0, 0x00,  //....@@@@..@@@@..@@@@.....
    0x1f, 0x3c, 0xf8, 0x00,  //...@@@@@..@@@@..@@@@@....
    0x3f, 0x3c, 0xfc, 0x00,  //..%@@@@@..@@@@..%@@@@@...
    0x3e, 0x3c, 0x7c, 0x00,  //.+@@@@@...@@@@...@@@@@+..
    0x7c, 0x3c, 0x3e, 0x00,  //.@@@@@....@@@@....@@@@@..
    0x78, 0x3c, 0x1e, 0x00,  //+@@@@+....@@@@.....@@@@+.
    0xf8, 0x3c, 0x1f, 0x00,  //%@@@@.....@@@@.....%@@@%.
    0xf0, 0x3c, 0x0f, 0x00,  //@@@@+.....@@@@.....+@@@@.
    0xf0, 0x3c, 0x0f, 0x00,  //@@@@+.....%@@@......@@@@.
    0xf0, 0x00, 0x0f, 0x00,  //@@@@.......++.......@@@@.
    0xf0, 0x00, 0x0f, 0x00,  //@@@@................@@@@.
    0xf0, 0x00, 0x0f, 0x00,  //@@@@+...............@@@@.
    0xf8, 0x00, 0x1f, 0x00,  //%@@@%..............%@@@@.
    0x78, 0x00, 0x1e, 0x00,  //+@@@@..............@@@@+.
    0x7c, 0x00, 0x3e, 0x00,  //.@@@@%............%@@@@..
    0x7c, 0x00, 0x3e, 0x00,  //.+@@@@+..........+@@@@%..
    0x3f, 0x00, 0xfc, 0x00,  //..@@@@@%........%@@@@@...
    0x1f, 0xc3, 0xf8, 0x00,  //...@@@@@@%+...%@@@@@@+...
    0x0f, 0xff, 0xf0, 0x00,  //...+@@@@@@@@@@@@@@@@+....
    0x07, 0xff, 0xe0, 0x00,  //....+@@@@@@@@@@@@@@+.....
    0x03, 0xff, 0xc0, 0x00,  //......%@@@@@@@@@@%.......
    0x00, 0x7e, 0x00, 0x00,  //........+@@@@@@+.........
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f013 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x3e, 0x00, 0x00,  //..........@@@@@..........
    0x00, 0x3e, 0x00, 0x00,  //..........@@@@@..........
    0x04, 0x3e, 0x10, 0x00,  //.....%...+@@@@@....%.....
    0x0e, 0x7f, 0x38, 0x00,  //...+@@@+.%@@@@@%.+@@@....
    0x1f, 0xff, 0xfc, 0x00,  //...@@@@@@@@@@@@@@@@@@@...
    0x3f, 0xff, 0xfe, 0x00,  //..%@@@@@@@@@@@@@@@@@@@%..
    0x1f, 0xff, 0xfc, 0x00,  //...@@@@@@@@@@@@@@@@@@@...
    0x0f, 0xff, 0xf8, 0x00,  //...+@@@@@@@@@@@@@@@@@+...
    0x0f, 0xe3, 0xf8, 0x00,  //....@@@@@@@+++@@@@@@@....
    0x1f, 0xc1, 0xfc, 0x00,  //...%@@@@@%.....%@@@@@%...
    0xff, 0x80, 0xff, 0x80,  //@@@@@@@@@.......@@@@@@@@@
    0xff, 0x00, 0x7f, 0x80,  //@@@@@@@@+.......+@@@@@@@@
    0xff, 0x00, 0x7f, 0x80,  //@@@@@@@@+.......+@@@@@@@@
    0xff, 0x00, 0x7f, 0x80,  //@@@@@@@@+.......+@@@@@@@@
    0xff, 0x80, 0xff, 0x80,  //@@@@@@@@@.......@@@@@@@@@
    0x1f, 0xc1, 0xfc, 0x00,  //...%@@@@@%.....%@@@@@%+..
    0x0f, 0xe3, 0xf8, 0x00,  //....@@@@@@%+.+%@@@@@@....
    0x0f, 0xff, 0xf8, 0x00,  //...+@@@@@@@@@@@@@@@@@+...
    0x1f, 0xff, 0xfc, 0x00,  //...@@@@@@@@@@@@@@@@@@@...
    0x3f, 0xff, 0xfe, 0x00,  //..%@@@@@@@@@@@@@@@@@@@%..
    0x1f, 0xff, 0xfc, 0x00,  //...@@@@@@@@@@@@@@@@@@@...
    0x0e, 0x7f, 0x38, 0x00,  //...+@@@+.%@@@@@%.+@@@+...
    0x04, 0x3e, 0x10, 0x00,  //.....@....@@@@@+..+@+....
    0x00, 0x3e, 0x00, 0x00,  //..........@@@@@..........
    0x00, 0x3e, 0x00, 0x00,  //..........@@@@@..........
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f014 () , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x01, 0xfe, 0x00,  //.......%@@@@@@@+.......
    0x01, 0xff, 0x00,  //......+@@@@@@@@@.......
    0x03, 0x03, 0x80,  //......@@+.....%@%......
    0x03, 0x01, 0x80,  //.....+@@.......@@......
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@%
    0x30, 0x00, 0x18,  //..@@..............+@%..
    0x30, 0x00, 0x18,  //..@@..............+@%..
    0x30, 0x00, 0x18,  //..@@..............+@%..
    0x30, 0x00, 0x18,  //..@@...+...+...+..+@%..
    0x33, 0x31, 0x98,  //..@@..@@+.%@+.+@%.+@%..
    0x33, 0x31, 0x98,  //..@@..@@+.%@+.+@%.+@%..
    0x33, 0x31, 0x98,  //..@@..@@+.%@+.+@%.+@%..
    0x33, 0x31, 0x98,  //..@@..@@+.%@+.+@%.+@%..
    0x33, 0x31, 0x98,  //..@@..@@+.%@+.+@%.+@%..
    0x33, 0x31, 0x98,  //..@@..@@+.%@+.+@%.+@%..
    0x33, 0x31, 0x98,  //..@@..@@+.%@+.+@%.+@%..
    0x33, 0x31, 0x98,  //..@@..@@+.%@+.+@%.+@%..
    0x33, 0x31, 0x98,  //..@@..@@+.%@+.+@%.+@%..
    0x33, 0x31, 0x18,  //..@@..%@..%@+.+@+.+@%..
    0x30, 0x00, 0x18,  //..@@..............+@%..
    0x30, 0x00, 0x18,  //..@@..............+@%..
    0x30, 0x00, 0x38,  //..@@+.............%@%..
    0x1f, 0xff, 0xf0,  //..+@@@@@@@@@@@@@@@@@...
    0x1f, 0xff, 0xe0,  //...%@@@@@@@@@@@@@@@+...
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f015 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x04, 0x1e, 0x00,  //............+%+....%%%%....
    0x00, 0x1f, 0x1e, 0x00,  //...........%@@@%...@@@@....
    0x00, 0x3f, 0x9e, 0x00,  //..........@@@@@@@..@@@@....
    0x00, 0x7b, 0xde, 0x00,  //.........@@@@.@@@@+@@@@....
    0x00, 0xf1, 0xfe, 0x00,  //.......+@@@%.+.%@@@@@@@....
    0x03, 0xee, 0x7e, 0x00,  //......%@@@+.%@%.+@@@@@@....
    0x07, 0x9f, 0x3e, 0x00,  //.....%@@@+.@@@@@.+@@@@@....
    0x0f, 0x3f, 0x9e, 0x00,  //....@@@@.+@@@@@@@+.@@@@....
    0x1e, 0xff, 0xef, 0x00,  //...@@@@.%@@@@@@@@@%.%@@@+..
    0x3d, 0xff, 0xf7, 0xc0,  //.+@@@%.%@@@@@@@@@@@%.%@@@%.
    0x7b, 0xff, 0xf9, 0xe0,  //+@@@+.@@@@@@@@@@@@@@@.+@@@%
    0x67, 0xff, 0xfc, 0xc0,  //.@@++@@@@@@@@@@@@@@@@@+.@@+
    0x0f, 0xff, 0xfe, 0x00,  //....@@@@@@@@@@@@@@@@@@@..+.
    0x0f, 0xff, 0xfe, 0x00,  //....@@@@@@@@@@@@@@@@@@@....
    0x0f, 0xff, 0xfe, 0x00,  //....@@@@@@@@@@@@@@@@@@@....
    0x0f, 0xe0, 0xfe, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x0f, 0xe0, 0xfe, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x0f, 0xe0, 0xfe, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x0f, 0xe0, 0xfe, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x0f, 0xe0, 0xfe, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x0f, 0xe0, 0xfe, 0x00,  //....%@@@@@@.....@@@@@@%....
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f019 () , Width: 27 */
    0x00, 0x1f, 0x00, 0x00,  //...........%%%%%...........
    0x00, 0x3f, 0x80, 0x00,  //..........%@@@@@%..........
    0x00, 0x3f, 0x80, 0x00,  //..........%@@@@@%..........
    0x00, 0x3f, 0x80, 0x00,  //..........%@@@@@%..........
    0x00, 0x3f, 0x80, 0x00,  //..........%@@@@@%..........
    0x00, 0x3f, 0x80, 0x00,  //..........%@@@@@%..........
    0x00, 0x3f, 0x80, 0x00,  //..........%@@@@@%..........
    0x00, 0x3f, 0x80, 0x00,  //..........%@@@@@%..........
    0x00, 0x3f, 0x80, 0x00,  //......++++@@@@@@%++++......
    0x07, 0xff, 0xfc, 0x00,  //.....%@@@@@@@@@@@@@@@%.....
    0x03, 0xff, 0xf8, 0x00,  //.....+@@@@@@@@@@@@@@@......
    0x01, 0xff, 0xf0, 0x00,  //......+@@@@@@@@@@@@@+......
    0x00, 0xff, 0xe0, 0x00,  //.......+@@@@@@@@@@@+.......
    0x00, 0x7f, 0xc0, 0x00,  //........+@@@@@@@@@.........
    0x00, 0x3f, 0x80, 0x00,  //.........+@@@@@@@..........
    0x00, 0x1f, 0x00, 0x00,  //..........+@@@@@...........
    0x00, 0x0e, 0x00, 0x00,  //...........+@@@............
    0xff, 0xc4, 0x7f, 0xe0,  //%@@@@@@@@%..+@...%@@@@@@@@%
    0xff, 0xe0, 0xff, 0xe0,  //@@@@@@@@@@%.....@@@@@@@@@@@
    0xff, 0xf1, 0xff, 0xe0,  //@@@@@@@@@@@@+.+@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xe6, 0x60,  //@@@@@@@@@@@@@@@@@@@.+@@.+@@
    0xff, 0xff, 0xe6, 0x60,  //@@@@@@@@@@@@@@@@@@@.+@@++@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f01c () , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x07, 0xff, 0xf0, 0x00,  //....+@@@@@@@@@@@@@@@.....
    0x0f, 0xff, 0xf8, 0x00,  //....@@@@@@@@@@@@@@@@@....
    0x0f, 0xff, 0xf8, 0x00,  //...+@@@@@@@@@@@@@@@@@....
    0x1e, 0x00, 0x3c, 0x00,  //...@@@%...........%@@%...
    0x1c, 0x00, 0x1c, 0x00,  //...@@@............+@@@...
    0x3c, 0x00, 0x1e, 0x00,  //..%@@%.............@@@%..
    0x38, 0x00, 0x0e, 0x00,  //..@@@+.............+@@@..
    0x78, 0x00, 0x0e, 0x00,  //.%@@@...............@@@+.
    0x70, 0x00, 0x0f, 0x00,  //.@@@+...............%@@@.
    0x70, 0x00, 0x07, 0x00,  //+@@@.................@@@.
    0xf0, 0x00, 0x07, 0x80,  //%@@%.................@@@%
    0xf0, 0x00, 0x07, 0x80,  //@@@%++++.........++++%@@@
    0xff, 0x80, 0xff, 0x80,  //@@@@@@@@%.......@@@@@@@@@
    0xff, 0x80, 0xff, 0x80,  //@@@@@@@@@......+@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@%.....@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f021 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x7f, 0x00, 0x00,  //........+%@@@@@%+........
    0x03, 0xff, 0xc1, 0x80,  //......%@@@@@@@@@@@+....@%
    0x07, 0xff, 0xf3, 0x80,  //.....@@@@@@@@@@@@@@@..@@@
    0x0f, 0xff, 0xff, 0x80,  //....@@@@@@@@@@@@@@@@@@@@@
    0x1f, 0xc1, 0xff, 0x80,  //...@@@@@@%+...+%@@@@@@@@@
    0x3f, 0x00, 0x7f, 0x80,  //..@@@@@@.........%@@@@@@@
    0x3e, 0x00, 0x3f, 0x80,  //.+@@@@%...........@@@@@@@
    0x7c, 0x00, 0x7f, 0x80,  //.@@@@@...........@@@@@@@@
    0x78, 0x00, 0xff, 0x80,  //+@@@@...........@@@@@@@@@
    0xf8, 0x00, 0xff, 0x80,  //%@@@%...........@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //.+++.............+++++++.
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.++++++++............+++.
    0xff, 0x80, 0x0f, 0x00,  //@@@@@@@@@+..........@@@@+
    0xff, 0x80, 0x0f, 0x00,  //@@@@@@@@@...........@@@@.
    0xff, 0x00, 0x1f, 0x00,  //@@@@@@@@...........@@@@@.
    0xfe, 0x00, 0x3e, 0x00,  //@@@@@@@...........%@@@@+.
    0xff, 0x00, 0x7e, 0x00,  //@@@@@@@@.........@@@@@%..
    0xff, 0xc1, 0xfc, 0x00,  //@@@@@@@@@%+...+%@@@@@@...
    0xff, 0xff, 0xf8, 0x00,  //@@@@@@@@@@@@@@@@@@@@@....
    0xe7, 0xff, 0xf0, 0x00,  //@@@..@@@@@@@@@@@@@@@.....
    0xc3, 0xff, 0xc0, 0x00,  //@@....%@@@@@@@@@@@+......
    0x00, 0x7f, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f026 () , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x10,  //..........+@.
    0x00, 0x70,  //.........%@@+
    0x00, 0xf0,  //........%@@@+
    0x01, 0xf0,  //.......%@@@@+
    0x03, 0xf0,  //......%@@@@@+
    0x07, 0xf0,  //.++++%@@@@@@+
    0xff, 0xf0,  //@@@@@@@@@@@@+
    0xff, 0xf0,  //@@@@@@@@@@@@+
    0xff, 0xf0,  //@@@@@@@@@@@@+
    0xff, 0xf0,  //@@@@@@@@@@@@+
    0xff, 0xf0,  //@@@@@@@@@@@@+
    0xff, 0xf0,  //@@@@@@@@@@@@+
    0xff, 0xf0,  //@@@@@@@@@@@@+
    0xff, 0xf0,  //%@@@@@@@@@@@+
    0x03, 0xf0,  //......@@@@@@+
    0x01, 0xf0,  //.......@@@@@+
    0x00, 0xf0,  //........@@@@+
    0x00, 0x70,  //.........@@@+
    0x00, 0x30,  //..........@@+
    0x00, 0x10,  //...........%.
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+f027 () , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x10, 0x00,  //..........+@.......
    0x00, 0x70, 0x00,  //.........%@@+......
    0x00, 0xf0, 0x00,  //........%@@@+......
    0x01, 0xf0, 0x00,  //.......%@@@@+......
    0x03, 0xf0, 0x00,  //......%@@@@@+......
    0x07, 0xf0, 0x00,  //.++++%@@@@@@+......
    0xff, 0xf1, 0x80,  //@@@@@@@@@@@@+..@@+.
    0xff, 0xf1, 0xc0,  //@@@@@@@@@@@@+..@@@.
    0xff, 0xf0, 0xe0,  //@@@@@@@@@@@@+...%@%
    0xff, 0xf0, 0x60,  //@@@@@@@@@@@@+....@@
    0xff, 0xf0, 0x60,  //@@@@@@@@@@@@+....@@
    0xff, 0xf0, 0xe0,  //@@@@@@@@@@@@+...@@%
    0xff, 0xf1, 0xc0,  //@@@@@@@@@@@@+..@@@.
    0xff, 0xf1, 0x80,  //%@@@@@@@@@@@+..%%..
    0x03, 0xf0, 0x00,  //......@@@@@@+......
    0x01, 0xf0, 0x00,  //.......@@@@@+......
    0x00, 0xf0, 0x00,  //........@@@@+......
    0x00, 0x70, 0x00,  //.........@@@+......
    0x00, 0x30, 0x00,  //..........@@+......
    0x00, 0x10, 0x00,  //...........%.......
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f028 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x10, 0x00,  //..................+@+......
    0x00, 0x00, 0x1c, 0x00,  //...........+......+@@@.....
    0x00, 0x30, 0x0e, 0x00,  //..........@@+......+@@@....
    0x00, 0x70, 0x07, 0x00,  //.........@@@+........%@@...
    0x00, 0xf0, 0x63, 0x80,  //........@@@@+....@@+..%@@..
    0x01, 0xf0, 0x71, 0x80,  //.......@@@@@+....@@@+..@@+.
    0x03, 0xf0, 0x38, 0xc0,  //......@@@@@@+.....%@@+.+@@.
    0x7f, 0xf0, 0x1c, 0xc0,  //+%%%%@@@@@@@+......%@@..@@+
    0xff, 0xf1, 0xcc, 0xe0,  //@@@@@@@@@@@@+..@@%..@@+.%@%
    0xff, 0xf1, 0xc6, 0x60,  //@@@@@@@@@@@@+..%@@+.+@%.+@@
    0xff, 0xf0, 0x66, 0x60,  //@@@@@@@@@@@@+...+@@..@@..@@
    0xff, 0xf0, 0x66, 0x60,  //@@@@@@@@@@@@+....@@..@@..@@
    0xff, 0xf0, 0x66, 0x60,  //@@@@@@@@@@@@+...+@@..@@..@@
    0xff, 0xf1, 0xc6, 0x60,  //@@@@@@@@@@@@+..%@@+.+@%.+@@
    0xff, 0xf1, 0xcc, 0xe0,  //@@@@@@@@@@@@+..@@%..@@+.+@%
    0x7f, 0xf0, 0x1c, 0xc0,  //+%%%%@@@@@@@+..+...%@@..@@+
    0x03, 0xf0, 0x38, 0xc0,  //......@@@@@@+.....%@@+.+@@.
    0x01, 0xf0, 0x71, 0x80,  //.......@@@@@+....@@@+..@@+.
    0x00, 0xf0, 0x63, 0x80,  //........@@@@+....@@+..%@@..
    0x00, 0x70, 0x07, 0x00,  //.........@@@+........%@@...
    0x00, 0x30, 0x0e, 0x00,  //..........@@+......+@@@+...
    0x00, 0x00, 0x1c, 0x00,  //...........+......+@@@.....
    0x00, 0x00, 0x18, 0x00,  //..................+@+......
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f03e () , Width: 32 */
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x7f, 0xff, 0xff, 0xfc,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0xfe,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xc0, 0x00, 0x00, 0x06,  //@@...........................@@.
    0xc0, 0x00, 0x00, 0x06,  //@@...........................@@.
    0xc3, 0x80, 0x00, 0x06,  //@@...+@@%....................@@.
    0xc7, 0xc0, 0x00, 0x06,  //@@..+@@@@%...................@@.
    0xcf, 0xc0, 0x00, 0x06,  //@@..@@@@@@...................@@.
    0xcf, 0xc0, 0x18, 0x06,  //@@..@@@@@@.........%@........@@.
    0xcf, 0xc0, 0x3c, 0x06,  //@@..%@@@@@........%@@@.......@@.
    0xc7, 0x80, 0x7e, 0x06,  //@@...%@@@........%@@@@@......@@.
    0xc0, 0x00, 0xff, 0x06,  //@@..............@@@@@@@@.....@@.
    0xc0, 0x01, 0xff, 0x86,  //@@.............@@@@@@@@@@....@@.
    0xc0, 0x03, 0xff, 0xc6,  //@@.......+....@@@@@@@@@@@@...@@.
    0xc0, 0xc7, 0xff, 0xe6,  //@@......@@+..@@@@@@@@@@@@@@..@@.
    0xc1, 0xef, 0xff, 0xe6,  //@@.....@@@@+@@@@@@@@@@@@@@@..@@.
    0xc3, 0xff, 0xff, 0xe6,  //@@....@@@@@@@@@@@@@@@@@@@@@..@@.
    0xc7, 0xff, 0xff, 0xe6,  //@@...@@@@@@@@@@@@@@@@@@@@@@..@@.
    0xcf, 0xff, 0xff, 0xe6,  //@@..@@@@@@@@@@@@@@@@@@@@@@@..@@.
    0xcf, 0xff, 0xff, 0xe6,  //@@..@@@@@@@@@@@@@@@@@@@@@@@..@@.
    0xcf, 0xff, 0xff, 0xe6,  //@@..@@@@@@@@@@@@@@@@@@@@@@@..@@.
    0xcf, 0xff, 0xff, 0xe6,  //@@..%%%%%%%%%%%%%%%%%%%%%%+..@@.
    0xc0, 0x00, 0x00, 0x06,  //@@...........................@@.
    0xc0, 0x00, 0x00, 0x06,  //@@...........................@@.
    0xff, 0xff, 0xff, 0xfe,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x7f, 0xff, 0xff, 0xfc,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f040 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //..................+......
    0x00, 0x00, 0x70, 0x00,  //.................@@@+....
    0x00, 0x00, 0xf8, 0x00,  //................@@@@@+...
    0x00, 0x01, 0xfc, 0x00,  //...............@@@@@@@+..
    0x00, 0x01, 0xfe, 0x00,  //...............@@@@@@@@+.
    0x00, 0x04, 0xff, 0x00,  //.............@..@@@@@@@@.
    0x00, 0x0e, 0x7f, 0x00,  //............@@@..@@@@@@@+
    0x00, 0x1f, 0x3f, 0x00,  //...........@@@@@..@@@@@@.
    0x00, 0x3b, 0x9e, 0x00,  //..........@@@.@@@..@@@@+.
    0x00, 0x77, 0xcc, 0x00,  //.........@@@.@@@@@..@@+..
    0x00, 0xef, 0xe0, 0x00,  //........@@@.@@@@@@@......
    0x01, 0xdf, 0xf0, 0x00,  //.......@@@.@@@@@@@@@.....
    0x03, 0xbf, 0xe0, 0x00,  //......@@@.@@@@@@@@@+.....
    0x07, 0x7f, 0xc0, 0x00,  //.....@@@.@@@@@@@@@+......
    0x0e, 0xff, 0x80, 0x00,  //....@@@.@@@@@@@@@+.......
    0x1d, 0xff, 0x00, 0x00,  //...@@@.@@@@@@@@@+........
    0x3b, 0xfe, 0x00, 0x00,  //..@@@.@@@@@@@@@+.........
    0x7f, 0xfc, 0x00, 0x00,  //.@@@@@@@@@@@@@+..........
    0xef, 0xf8, 0x00, 0x00,  //@@%.%@@@@@@@@+...........
    0xc7, 0xf0, 0x00, 0x00,  //@@...%@@@@@@+............
    0xc3, 0xe0, 0x00, 0x00,  //@@....%@@@@+.............
    0xf1, 0xc0, 0x00, 0x00,  //@@@@...@@@+..............
    0xf3, 0x80, 0x00, 0x00,  //@@@@..%@@+...............
    0xff, 0x00, 0x00, 0x00,  //@@@@@@@@+................
    0xfe, 0x00, 0x00, 0x00,  //@@@@@@@+.................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f048 () , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xf0, 0x00, 0x00,  //%@@%...........++
    0xf0, 0x01, 0x80,  //@@@@..........+@%
    0xf0, 0x03, 0x80,  //@@@@.........+@@%
    0xf0, 0x07, 0x80,  //@@@@........+@@@%
    0xf0, 0x0f, 0x80,  //@@@@.......+@@@@%
    0xf0, 0x1f, 0x80,  //@@@@......+@@@@@%
    0xf0, 0x3f, 0x80,  //@@@@.....+@@@@@@%
    0xf0, 0x7f, 0x80,  //@@@@....+@@@@@@@%
    0xf0, 0xff, 0x80,  //@@@@...+@@@@@@@@%
    0xf1, 0xff, 0x80,  //@@@@..+@@@@@@@@@%
    0xf3, 0xff, 0x80,  //@@@@.+@@@@@@@@@@%
    0xf7, 0xff, 0x80,  //@@@@+@@@@@@@@@@@%
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0x80,  //@@@@%@@@@@@@@@@@%
    0xf3, 0xff, 0x80,  //@@@@.+@@@@@@@@@@%
    0xf1, 0xff, 0x80,  //@@@@..+@@@@@@@@@%
    0xf0, 0xff, 0x80,  //@@@@...+@@@@@@@@%
    0xf0, 0x7f, 0x80,  //@@@@....+@@@@@@@%
    0xf0, 0x3f, 0x80,  //@@@@.....+@@@@@@%
    0xf0, 0x1f, 0x80,  //@@@@......+@@@@@%
    0xf0, 0x0f, 0x80,  //@@@@.......+@@@@%
    0xf0, 0x07, 0x80,  //@@@@........+@@@%
    0xf0, 0x03, 0x80,  //@@@@.........+@@%
    0xf0, 0x01, 0x80,  //@@@@..........+@%
    0xf0, 0x00, 0x80,  //%@@@...........+%
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f04b () , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x80, 0x00, 0x00,  //@+.....................
    0xe0, 0x00, 0x00,  //@@@+...................
    0xf8, 0x00, 0x00,  //@@@@@..................
    0xfe, 0x00, 0x00,  //@@@@@@%................
    0xff, 0x80, 0x00,  //@@@@@@@@%..............
    0xff, 0xc0, 0x00,  //@@@@@@@@@@+............
    0xff, 0xf0, 0x00,  //@@@@@@@@@@@@+..........
    0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@.........
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@%.......
    0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@%.....
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@+...
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@%.
    0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@%...
    0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@+....
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+......
    0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@%........
    0xff, 0xf8, 0x00,  //@@@@@@@@@@@@%..........
    0xff, 0xe0, 0x00,  //@@@@@@@@@@%............
    0xff, 0x80, 0x00,  //@@@@@@@@@+.............
    0xfe, 0x00, 0x00,  //@@@@@@@+...............
    0xfc, 0x00, 0x00,  //@@@@@%.................
    0xf0, 0x00, 0x00,  //@@@%...................
    0xc0, 0x00, 0x00,  //@@.....................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f04c () , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0xff, 0xc1, 0xff, 0x80,  //%@@@@@@@@@.....@@@@@@@@@%
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xc1, 0xff, 0x80,  //%@@@@@@@@@.....@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f04d () , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0xff, 0xff, 0xff, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f051 () , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x0f, 0x00,  //+...........%@@%.
    0x80, 0x0f, 0x00,  //@+..........@@@@.
    0xc0, 0x0f, 0x00,  //@@+.........@@@@.
    0xe0, 0x0f, 0x00,  //@@@+........@@@@.
    0xf0, 0x0f, 0x00,  //@@@@+.......@@@@.
    0xf8, 0x0f, 0x00,  //@@@@@+......@@@@.
    0xfc, 0x0f, 0x00,  //@@@@@@+.....@@@@.
    0xfe, 0x0f, 0x00,  //@@@@@@@+....@@@@.
    0xff, 0x0f, 0x00,  //@@@@@@@@+...@@@@.
    0xff, 0x8f, 0x00,  //@@@@@@@@@+..@@@@.
    0xff, 0xcf, 0x00,  //@@@@@@@@@@+.@@@@.
    0xff, 0xef, 0x00,  //@@@@@@@@@@@+@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@@@@%@@@@.
    0xff, 0xef, 0x00,  //@@@@@@@@@@%.@@@@.
    0xff, 0xcf, 0x00,  //@@@@@@@@@%..@@@@.
    0xff, 0x8f, 0x00,  //@@@@@@@@%...@@@@.
    0xff, 0x0f, 0x00,  //@@@@@@@%....@@@@.
    0xfe, 0x0f, 0x00,  //@@@@@@%.....@@@@.
    0xfc, 0x0f, 0x00,  //@@@@@%......@@@@.
    0xf8, 0x0f, 0x00,  //@@@@%.......@@@@.
    0xf0, 0x0f, 0x00,  //@@@%........@@@@.
    0xe0, 0x0f, 0x00,  //@@%.........@@@@.
    0xc0, 0x0f, 0x00,  //@%..........@@@@.
    0x80, 0x0f, 0x00,  //%...........%@@@.
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f052 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x08, 0x00, 0x00,  //...........+@+...........
    0x00, 0x1c, 0x00, 0x00,  //..........+@@@+..........
    0x00, 0x3e, 0x00, 0x00,  //.........+@@@@@+.........
    0x00, 0x7f, 0x00, 0x00,  //........+@@@@@@@+........
    0x00, 0xff, 0x80, 0x00,  //.......+@@@@@@@@@+.......
    0x01, 0xff, 0xc0, 0x00,  //......+@@@@@@@@@@@+......
    0x03, 0xff, 0xe0, 0x00,  //.....+@@@@@@@@@@@@@+.....
    0x07, 0xff, 0xf0, 0x00,  //....+@@@@@@@@@@@@@@@+....
    0x0f, 0xff, 0xf8, 0x00,  //...+@@@@@@@@@@@@@@@@@+...
    0x1f, 0xff, 0xfc, 0x00,  //..+@@@@@@@@@@@@@@@@@@@+..
    0x3f, 0xff, 0xfe, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@+.
    0x7f, 0xff, 0xff, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@+
    0x7f, 0xff, 0xff, 0x00,  //+%%%%%%%%%%%%%%%%%%%%%%%+
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f053 () , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x06, 0x00,  //............+@%...
    0x00, 0x0f, 0x00,  //...........+@@@%..
    0x00, 0x1f, 0x80,  //..........+@@@@@%.
    0x00, 0x3f, 0x80,  //.........+@@@@@@@.
    0x00, 0x7f, 0x80,  //........+@@@@@@@@.
    0x00, 0xff, 0x00,  //.......+@@@@@@@@..
    0x01, 0xfe, 0x00,  //......+@@@@@@@@...
    0x03, 0xfc, 0x00,  //.....+@@@@@@@@....
    0x07, 0xf8, 0x00,  //....+@@@@@@@@.....
    0x0f, 0xf0, 0x00,  //...+@@@@@@@@......
    0x1f, 0xe0, 0x00,  //..+@@@@@@@@.......
    0x3f, 0xc0, 0x00,  //.+@@@@@@@@........
    0x7f, 0x80, 0x00,  //+@@@@@@@@.........
    0x7f, 0x80, 0x00,  //+@@@@@@@@.........
    0x3f, 0xc0, 0x00,  //.+@@@@@@@@........
    0x1f, 0xe0, 0x00,  //..+@@@@@@@@.......
    0x0f, 0xf0, 0x00,  //...+@@@@@@@@......
    0x07, 0xf8, 0x00,  //....+@@@@@@@@.....
    0x03, 0xfc, 0x00,  //.....+@@@@@@@@....
    0x01, 0xfe, 0x00,  //......+@@@@@@@@...
    0x00, 0xff, 0x00,  //.......+@@@@@@@@..
    0x00, 0x7f, 0x80,  //........+@@@@@@@@.
    0x00, 0x3f, 0x80,  //.........+@@@@@@@.
    0x00, 0x1f, 0x00,  //..........+@@@@@+.
    0x00, 0x0e, 0x00,  //...........+@@@+..
    0x00, 0x04, 0x00,  //............+@+...
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f054 () , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x18, 0x00, 0x00,  //...@@.............
    0x3c, 0x00, 0x00,  //..@@@@............
    0x7e, 0x00, 0x00,  //.@@@@@@...........
    0x7f, 0x00, 0x00,  //+@@@@@@@..........
    0x7f, 0x80, 0x00,  //.@@@@@@@@.........
    0x3f, 0xc0, 0x00,  //..@@@@@@@@........
    0x1f, 0xe0, 0x00,  //...@@@@@@@@.......
    0x0f, 0xf0, 0x00,  //....@@@@@@@@......
    0x07, 0xf8, 0x00,  //.....@@@@@@@@.....
    0x03, 0xfc, 0x00,  //......@@@@@@@@....
    0x01, 0xfe, 0x00,  //.......@@@@@@@@...
    0x00, 0xff, 0x00,  //........@@@@@@@@..
    0x00, 0x7f, 0x80,  //.........@@@@@@@@.
    0x00, 0x7f, 0x80,  //.........@@@@@@@@.
    0x00, 0xff, 0x00,  //........@@@@@@@@..
    0x01, 0xfe, 0x00,  //.......@@@@@@@@...
    0x03, 0xfc, 0x00,  //......@@@@@@@@....
    0x07, 0xf8, 0x00,  //.....@@@@@@@@.....
    0x0f, 0xf0, 0x00,  //....@@@@@@@@......
    0x1f, 0xe0, 0x00,  //...@@@@@@@@.......
    0x3f, 0xc0, 0x00,  //..@@@@@@@@........
    0x7f, 0x80, 0x00,  //.@@@@@@@@.........
    0x7f, 0x00, 0x00,  //+@@@@@@@..........
    0x7e, 0x00, 0x00,  //.%@@@@@...........
    0x3c, 0x00, 0x00,  //..%@@@............
    0x18, 0x00, 0x00,  //...%@.............
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f067 () , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x7c, 0x00,  //.........%@@@%.........
    0x00, 0xfc, 0x00,  //........%@@@@@+........
    0x00, 0xfc, 0x00,  //........%@@@@@+........
    0x00, 0xfc, 0x00,  //........%@@@@@+........
    0x00, 0xfc, 0x00,  //........%@@@@@+........
    0x00, 0xfc, 0x00,  //........%@@@@@+........
    0x00, 0xfc, 0x00,  //........%@@@@@+........
    0x00, 0xfc, 0x00,  //........%@@@@@+........
    0x00, 0xfe, 0x00,  //.+++++++@@@@@@%+++++++.
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@%
    0x7f, 0xff, 0xfc,  //+%%%%%%%@@@@@@@%%%%%%%.
    0x00, 0xfc, 0x00,  //........%@@@@@+........
    0x00, 0xfc, 0x00,  //........%@@@@@+........
    0x00, 0xfc, 0x00,  //........%@@@@@+........
    0x00, 0xfc, 0x00,  //........%@@@@@+........
    0x00, 0xfc, 0x00,  //........%@@@@@+........
    0x00, 0xfc, 0x00,  //........%@@@@@+........
    0x00, 0xfc, 0x00,  //........%@@@@@+........
    0x00, 0x7c, 0x00,  //........+@@@@@.........
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f068 () , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0xff, 0xff, 0xfc,  //%@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@%
    0x7f, 0xff, 0xfc,  //+@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f071 () , Width: 29 */
    0x00, 0x07, 0x00, 0x00,  //.............%@%.............
    0x00, 0x0f, 0x80, 0x00,  //............%@@@%............
    0x00, 0x0f, 0x80, 0x00,  //............@@@@@............
    0x00, 0x1f, 0xc0, 0x00,  //...........%@@@@@%...........
    0x00, 0x1f, 0xc0, 0x00,  //...........@@@@@@@...........
    0x00, 0x3f, 0xe0, 0x00,  //..........%@@@@@@@%..........
    0x00, 0x3f, 0xe0, 0x00,  //..........@@@@@@@@@..........
    0x00, 0x7f, 0xf0, 0x00,  //.........@@@@@@@@@@@.........
    0x00, 0x70, 0x70, 0x00,  //........+@@@+++++@@@+........
    0x00, 0xf0, 0x78, 0x00,  //........@@@@.....@@@@........
    0x00, 0xf0, 0x78, 0x00,  //.......+@@@@.....@@@@+.......
    0x01, 0xf0, 0x7c, 0x00,  //.......@@@@@+...+@@@@@.......
    0x01, 0xf0, 0x7c, 0x00,  //......+@@@@@+...+@@@@@+......
    0x03, 0xf0, 0x7e, 0x00,  //......@@@@@@+...+@@@@@@......
    0x07, 0xf0, 0x7f, 0x00,  //.....%@@@@@@+...+@@@@@@%.....
    0x07, 0xf0, 0x7f, 0x00,  //.....@@@@@@@+...+@@@@@@@.....
    0x0f, 0xf8, 0xff, 0x80,  //....%@@@@@@@%...%@@@@@@@%....
    0x0f, 0xff, 0xff, 0x80,  //....@@@@@@@@@@@@@@@@@@@@@....
    0x1f, 0xff, 0xff, 0xc0,  //...%@@@@@@@@@@@@@@@@@@@@@%...
    0x1f, 0xf0, 0x7f, 0xc0,  //..+@@@@@@@@@+...+@@@@@@@@@+..
    0x3f, 0xf0, 0x7f, 0xe0,  //..@@@@@@@@@@+...+@@@@@@@@@@..
    0x3f, 0xf0, 0x7f, 0xe0,  //.+@@@@@@@@@@+...+@@@@@@@@@@+.
    0x7f, 0xf8, 0xff, 0xf0,  //.@@@@@@@@@@@%...%@@@@@@@@@@@.
    0x7f, 0xff, 0xff, 0xf0,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0xff, 0xff, 0xf0,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f074 () , Width: 29 */
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x01, 0x00,  //.......................@+....
    0x00, 0x00, 0x01, 0x80,  //.......................@@+...
    0x00, 0x00, 0x01, 0xc0,  //.......................@@@+..
    0xfc, 0x00, 0x7f, 0xe0,  //%%%%%%+.........+%%%%%@@@@@+.
    0xff, 0x03, 0xff, 0xf0,  //@@@@@@@@+.....%@@@@@@@@@@@@@+
    0xff, 0xc7, 0xff, 0xf8,  //@@@@@@@@@+...%@@@@@@@@@@@@@@@
    0xff, 0xcf, 0xff, 0xf0,  //@@@@@@@@@@+.%@@@@@@@@@@@@@@@.
    0x07, 0xcf, 0xc3, 0xe0,  //+++++%@@@@++@@@@@%++++%@@@@..
    0x01, 0xdf, 0x01, 0xc0,  //......+@@@.@@@@@.......@@@...
    0x00, 0x9e, 0x01, 0x80,  //.......+@++@@@@........@@....
    0x00, 0xbe, 0x01, 0x00,  //........%.@@@@%........@.....
    0x00, 0x3c, 0x00, 0x00,  //.........+@@@@...............
    0x00, 0x7c, 0x00, 0x00,  //.........@@@@%...............
    0x00, 0x78, 0x00, 0x00,  //........+@@@@................
    0x00, 0xfa, 0x01, 0x00,  //........@@@@@.%........@.....
    0x00, 0xf6, 0x01, 0x80,  //.......+@@@@+%@........@@....
    0x01, 0xf7, 0x01, 0xc0,  //.......@@@@@.@@@.......@@@...
    0x07, 0xef, 0xc3, 0xe0,  //+++++%@@@@@.%@@@@%++++%@@@@..
    0xff, 0xcf, 0xff, 0xf0,  //@@@@@@@@@@+.%@@@@@@@@@@@@@@@.
    0xff, 0xc7, 0xff, 0xf8,  //@@@@@@@@@%...@@@@@@@@@@@@@@@@
    0xff, 0x03, 0xff, 0xf0,  //@@@@@@@@+.....%@@@@@@@@@@@@@+
    0xfc, 0x00, 0x7f, 0xe0,  //%@@@%%+.........+%%@@@@@@@@+.
    0x00, 0x00, 0x01, 0xc0,  //.......................@@@+..
    0x00, 0x00, 0x01, 0x80,  //.......................@@+...
    0x00, 0x00, 0x01, 0x00,  //.......................@+....
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f077 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x0c, 0x00, 0x00,  //............@@.............
    0x00, 0x1e, 0x00, 0x00,  //...........@@@@............
    0x00, 0x3f, 0x00, 0x00,  //..........@@@@@@...........
    0x00, 0x7f, 0x80, 0x00,  //.........@@@@@@@@..........
    0x00, 0xff, 0xc0, 0x00,  //........@@@@@@@@@@.........
    0x01, 0xff, 0xe0, 0x00,  //.......@@@@@@@@@@@@........
    0x03, 0xff, 0xf0, 0x00,  //......@@@@@@@@@@@@@@.......
    0x07, 0xff, 0xf8, 0x00,  //.....@@@@@@@@@@@@@@@@......
    0x0f, 0xf3, 0xfc, 0x00,  //....@@@@@@@@+.@@@@@@@@.....
    0x1f, 0xe1, 0xfe, 0x00,  //...@@@@@@@@+...@@@@@@@@....
    0x3f, 0xc0, 0xff, 0x00,  //..@@@@@@@@+.....@@@@@@@@...
    0x7f, 0x80, 0x7f, 0x80,  //.@@@@@@@@+.......@@@@@@@@..
    0xff, 0x00, 0x3f, 0xc0,  //@@@@@@@@+.........@@@@@@@@.
    0xfe, 0x00, 0x1f, 0xc0,  //@@@@@@@+...........@@@@@@@.
    0x7c, 0x00, 0x0f, 0x80,  //.@@@@@+.............@@@@@..
    0x38, 0x00, 0x07, 0x00,  //..@@@+...............@@@...
    0x10, 0x00, 0x02, 0x00,  //...%+.................%....
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f078 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x18, 0x00, 0x07, 0x00,  //..+@@................%@%...
    0x3c, 0x00, 0x0f, 0x80,  //.+@@@@..............%@@@%..
    0x7e, 0x00, 0x1f, 0xc0,  //+@@@@@@............%@@@@@%.
    0xff, 0x00, 0x3f, 0xc0,  //@@@@@@@@..........%@@@@@@@.
    0x7f, 0x80, 0x7f, 0x80,  //+@@@@@@@@........%@@@@@@@+.
    0x3f, 0xc0, 0xff, 0x00,  //.+@@@@@@@@......%@@@@@@@+..
    0x1f, 0xe1, 0xfe, 0x00,  //..+@@@@@@@@....%@@@@@@@+...
    0x0f, 0xf3, 0xfc, 0x00,  //...+@@@@@@@@..%@@@@@@@+....
    0x07, 0xff, 0xf8, 0x00,  //....+@@@@@@@@%@@@@@@@+.....
    0x03, 0xff, 0xf0, 0x00,  //.....+@@@@@@@@@@@@@@+......
    0x01, 0xff, 0xe0, 0x00,  //......+@@@@@@@@@@@@+.......
    0x00, 0xff, 0xc0, 0x00,  //.......+@@@@@@@@@@+........
    0x00, 0x7f, 0x80, 0x00,  //........+@@@@@@@@+.........
    0x00, 0x3f, 0x00, 0x00,  //.........+@@@@@@+..........
    0x00, 0x1e, 0x00, 0x00,  //..........+@@@@+...........
    0x00, 0x0c, 0x00, 0x00,  //...........+@@+............
    0x00, 0x00, 0x00, 0x00,  //............++.............
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f079 () , Width: 32 */
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x06, 0x3f, 0xff, 0xe0,  //.....%@...%@@@@@@@@@@@@@@@@.....
    0x0f, 0x1f, 0xff, 0xe0,  //....%@@@...@@@@@@@@@@@@@@@@.....
    0x0f, 0x8f, 0xff, 0xe0,  //...+@@@@@...@@@@@@@@@@@@@@@.....
    0x1f, 0xc7, 0xff, 0xe0,  //...@@@@@@%..+@@@@@@@@@@@@@@.....
    0x3f, 0xc0, 0x01, 0xe0,  //..@@@@@@@@+...........+@@@@.....
    0x7f, 0xe0, 0x01, 0xe0,  //.@@@@@@@@@@+...........@@@@.....
    0xff, 0xf0, 0x01, 0xe0,  //%@@@@@@@@@@@...........@@@@.....
    0xff, 0xf0, 0x01, 0xe0,  //@@@@@@@@@@@@+..........@@@@.....
    0x0f, 0x00, 0x01, 0xe0,  //.+++@@@@+++............@@@@.....
    0x0f, 0x00, 0x01, 0xe0,  //....@@@@+..............@@@@.....
    0x0f, 0x00, 0x01, 0xe0,  //....@@@@+...........+++@@@@+++..
    0x0f, 0x00, 0x1f, 0xfe,  //....@@@@+.........+@@@@@@@@@@@@.
    0x0f, 0x00, 0x1f, 0xfe,  //....@@@@+..........@@@@@@@@@@@%.
    0x0f, 0x00, 0x0f, 0xfc,  //....@@@@+...........@@@@@@@@@@..
    0x0f, 0x00, 0x07, 0xf8,  //....@@@@+...........+@@@@@@@@...
    0x0f, 0xff, 0xc7, 0xf0,  //....@@@@@@@@@@@@@@+..%@@@@@@+...
    0x0f, 0xff, 0xe3, 0xe0,  //....@@@@@@@@@@@@@@@...%@@@@+....
    0x0f, 0xff, 0xf1, 0xe0,  //....@@@@@@@@@@@@@@@@...@@@%.....
    0x0f, 0xff, 0xf8, 0xc0,  //....@@@@@@@@@@@@@@@@%...@%......
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f07b () , Width: 27 */
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x3f, 0xc0, 0x00, 0x00,  //..%@@@@@@%+................
    0x7f, 0xf0, 0x00, 0x00,  //.@@@@@@@@@@%...............
    0xff, 0xf0, 0x00, 0x00,  //%@@@@@@@@@@@...............
    0xff, 0xf0, 0x00, 0x00,  //@@@@@@@@@@@@+..............
    0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@%%%%%%%%%%%+..
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x7f, 0xff, 0xff, 0xc0,  //+@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x3f, 0xff, 0xff, 0x80,  //.+@@@@@@@@@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f093 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x04, 0x00, 0x00,  //.............%.............
    0x00, 0x0e, 0x00, 0x00,  //............@@@............
    0x00, 0x1f, 0x00, 0x00,  //...........@@@@@...........
    0x00, 0x3f, 0x80, 0x00,  //..........@@@@@@@..........
    0x00, 0x7f, 0xc0, 0x00,  //.........@@@@@@@@@.........
    0x00, 0xff, 0xe0, 0x00,  //........@@@@@@@@@@@........
    0x01, 0xff, 0xf0, 0x00,  //.......@@@@@@@@@@@@@.......
    0x03, 0xff, 0xf8, 0x00,  //......@@@@@@@@@@@@@@@......
    0x07, 0xff, 0xfc, 0x00,  //.....%@@@@@@@@@@@@@@@%.....
    0x03, 0xff, 0xf8, 0x00,  //......%%%%@@@@@@@%%%%......
    0x00, 0x3f, 0x80, 0x00,  //..........%@@@@@%..........
    0x00, 0x3f, 0x80, 0x00,  //..........%@@@@@%..........
    0x00, 0x3f, 0x80, 0x00,  //..........%@@@@@%..........
    0x00, 0x3f, 0x80, 0x00,  //..........%@@@@@%..........
    0x00, 0x3f, 0x80, 0x00,  //..........%@@@@@%..........
    0x00, 0x3f, 0x80, 0x00,  //..........%@@@@@%..........
    0x00, 0x3f, 0x80, 0x00,  //..........%@@@@@%..........
    0x00, 0x1f, 0x00, 0x00,  //..........+@@@@@...........
    0xff, 0x80, 0x3f, 0xe0,  //%@@@@@@@@.........@@@@@@@@%
    0xff, 0xc0, 0x7f, 0xe0,  //@@@@@@@@@@+.....+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xe6, 0x60,  //@@@@@@@@@@@@@@@@@@@.+@@.+@@
    0xff, 0xff, 0xe6, 0x60,  //@@@@@@@@@@@@@@@@@@@.+@@.+@@
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xe0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f095 () , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x18, 0x00, 0x00,  //...%%+.................
    0x3c, 0x00, 0x00,  //.+@@@@.................
    0x7e, 0x00, 0x00,  //.@@@@@%................
    0xfe, 0x00, 0x00,  //+@@@@@@................
    0xff, 0x00, 0x00,  //@@@@@@@%...............
    0xff, 0x00, 0x00,  //@@@@@@@@...............
    0xff, 0x00, 0x00,  //@@@@@@@%...............
    0xfe, 0x00, 0x00,  //%@@@@@%................
    0x7c, 0x00, 0x00,  //+@@@@%.................
    0x7c, 0x00, 0x00,  //.@@@@+.................
    0x7c, 0x00, 0x00,  //.%@@@@.................
    0x3e, 0x00, 0x00,  //..@@@@%................
    0x3e, 0x00, 0x00,  //..%@@@@+...............
    0x1f, 0x00, 0x00,  //...@@@@@...............
    0x0f, 0x80, 0x00,  //...+@@@@@..............
    0x07, 0xc0, 0xe0,  //....+@@@@@+.....%@%....
    0x07, 0xf1, 0xf8,  //.....%@@@@@%...%@@@@%..
    0x03, 0xff, 0xfc,  //......%@@@@@@+%@@@@@@@+
    0x00, 0xff, 0xfe,  //.......+@@@@@@@@@@@@@@%
    0x00, 0x7f, 0xfe,  //........+@@@@@@@@@@@@@%
    0x00, 0x3f, 0xfc,  //..........%@@@@@@@@@@@.
    0x00, 0x0f, 0xf8,  //............%@@@@@@@@+.
    0x00, 0x01, 0xf0,  //..............+%@@@+...
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f0c4 () , Width: 29 */
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x0c, 0x00, 0x00, 0x00,  //..++%++......................
    0x7f, 0x80, 0x00, 0x00,  //.@@@@@@@+....................
    0xff, 0xc0, 0x00, 0x00,  //@@@@@@@@@@...............+...
    0xe1, 0xe0, 0x01, 0xf0,  //@@@+..+%@@@............%@%@%.
    0xe0, 0x70, 0x07, 0x10,  //@@%.....+@@%.........%@%...@+
    0xe0, 0x30, 0x0c, 0x30,  //@@@......+@@.......+@%....%@.
    0xf0, 0x30, 0x30, 0x60,  //@@@%......@@.....+@%.....@%..
    0x78, 0x70, 0xc0, 0x80,  //+@@@@+...%@@....@@+....+@+...
    0x3f, 0xfb, 0x03, 0x00,  //.+@@@@@@@@@%@+%@+.....%@.....
    0x1f, 0xee, 0x06, 0x00,  //...%@@@@@@@.%@+......%%......
    0x03, 0x38, 0x0c, 0x00,  //.....+%%+.@@@.......@%.......
    0x00, 0x1b, 0x10, 0x00,  //...........%@.@@..+@+........
    0x00, 0x1b, 0x78, 0x00,  //..........+@%.%@.%@@%........
    0x0f, 0xe0, 0xcc, 0x00,  //....%@@@@%@+..+.%%..%@.......
    0x3f, 0xef, 0x02, 0x00,  //..%@@@@@@@@.%@@@+....+@+.....
    0x7f, 0xf9, 0x81, 0x80,  //.@@@@@%%%@@@%.+@@+.....@%....
    0xf0, 0x30, 0x60, 0xc0,  //%@@@+....+@@....+@@+....%@...
    0xe0, 0x30, 0x18, 0x20,  //@@@.......@@......+@%....+@+.
    0xe0, 0x70, 0x06, 0x10,  //@@%......@@%........+@%....@+
    0xe0, 0xe0, 0x03, 0xb0,  //@@@....+@@@...........%@%.%@.
    0xff, 0xc0, 0x00, 0xc0,  //@@@@%%@@@@+.............%@+..
    0x7f, 0x80, 0x00, 0x00,  //+@@@@@@@@+...................
    0x3e, 0x00, 0x00, 0x00,  //..%@@@%+.....................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f0c5 () , Width: 29 */
    0x00, 0x7f, 0xc0, 0x00,  //........+@@@@@@@@@+..........
    0x01, 0xff, 0xe0, 0x00,  //.......%@@@@@@@@@@@..........
    0x03, 0xc0, 0x60, 0x00,  //......%@@@.......@@..........
    0x07, 0xc0, 0x60, 0x00,  //.....%@@@@.......@@..........
    0x0e, 0xc0, 0x60, 0x00,  //....%@@.@@.......@@..........
    0x1c, 0xc0, 0x60, 0x00,  //...%@@..@@.......@@..........
    0x38, 0xc0, 0x7f, 0xf0,  //..%@@...@@.......@@%@@@@@@@@+
    0x70, 0xc0, 0x7f, 0xf8,  //.%@@....@@.......@@@@@@@@@@@@
    0x7f, 0xc0, 0x78, 0x18,  //+@@@@@@@@@.......@@@@......@@
    0xff, 0xc0, 0xf8, 0x18,  //@@@@@@@@@%......@@@@@......@@
    0xc0, 0x01, 0xd8, 0x18,  //@@.............@@@.@@......@@
    0xc0, 0x03, 0x98, 0x18,  //@@...........+@@@..@@......@@
    0xc0, 0x07, 0x18, 0x18,  //@@..........+@@@...@@......@@
    0xc0, 0x0e, 0x18, 0x18,  //@@.........+@@@....@@......@@
    0xc0, 0x1c, 0x18, 0x18,  //@@.........@@@+....@@......@@
    0xc0, 0x3f, 0xf8, 0x18,  //@@........%@@@@@@@@@@......@@
    0xc0, 0x3f, 0xf0, 0x18,  //@@........@@@@@@@@@@+......@@
    0xc0, 0x30, 0x00, 0x18,  //@@........@@+..............@@
    0xc0, 0x30, 0x00, 0x18,  //@@........@@+..............@@
    0xc0, 0x30, 0x00, 0x18,  //@@........@@+..............@@
    0xc0, 0x30, 0x00, 0x18,  //@@........@@+..............@@
    0xff, 0xf0, 0x00, 0x18,  //@@@@@@@@@@@@+..............@@
    0xff, 0xf0, 0x00, 0x18,  //%@@@@@@@@@@@+..............@@
    0x00, 0x30, 0x00, 0x18,  //..........@@+..............@@
    0x00, 0x30, 0x00, 0x18,  //..........@@+..............@@
    0x00, 0x30, 0x00, 0x18,  //..........@@+..............@@
    0x00, 0x30, 0x00, 0x18,  //..........@@+..............@@
    0x00, 0x3f, 0xff, 0xf8,  //..........@@@@@@@@@@@@@@@@@@@
    0x00, 0x1f, 0xff, 0xf8,  //..........+@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f0c7 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x7f, 0xff, 0xc0, 0x00,  //+@@@@@@@@@@@@@@@@@+......
    0xff, 0xff, 0xf0, 0x00,  //@@@@@@@@@@@@@@@@@@@%.....
    0xcf, 0xc1, 0xb8, 0x00,  //@@..@@@@@@+....@@.@@%....
    0xcf, 0xc1, 0x9c, 0x00,  //@@..@@@@@@.....@@..@@%...
    0xcf, 0xc1, 0x8e, 0x00,  //@@..@@@@@@.....@@...@@%..
    0xcf, 0xc1, 0x87, 0x00,  //@@..@@@@@@.....@@....@@%.
    0xcf, 0xc1, 0x83, 0x00,  //@@..@@@@@@.....@@.....@@+
    0xcf, 0xc1, 0x81, 0x80,  //@@..@@@@@@.....@@.....+@@
    0xcf, 0xc1, 0x81, 0x80,  //@@..@@@@@@+....@@......@@
    0xcf, 0xff, 0x81, 0x80,  //@@..@@@@@@@@@@@@@......@@
    0xc7, 0xff, 0x01, 0x80,  //@@..+@@@@@@@@@@@+......@@
    0xc0, 0x00, 0x01, 0x80,  //@@.....................@@
    0xc0, 0x00, 0x01, 0x80,  //@@.....................@@
    0xc0, 0x00, 0x01, 0x80,  //@@.....................@@
    0xc0, 0x00, 0x01, 0x80,  //@@.....................@@
    0xcf, 0xff, 0xf9, 0x80,  //@@..%@@@@@@@@@@@@@@@%..@@
    0xcf, 0xff, 0xf9, 0x80,  //@@..@@@@@@@@@@@@@@@@@..@@
    0xcc, 0x00, 0x19, 0x80,  //@@..@@.............@@..@@
    0xcc, 0x00, 0x19, 0x80,  //@@..@@.............@@..@@
    0xcc, 0x00, 0x19, 0x80,  //@@..@@.............@@..@@
    0xcc, 0x00, 0x19, 0x80,  //@@..@@.............@@..@@
    0xcc, 0x00, 0x19, 0x80,  //@@..@@.............@@..@@
    0xcc, 0x00, 0x19, 0x80,  //@@..@@.............@@..@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f0e7 () , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x1f, 0xc0,  //...%@@@@@@.....
    0x1f, 0xc0,  //...@@@@@@@.....
    0x1f, 0x80,  //...@@@@@@+.....
    0x1f, 0x80,  //..+@@@@@@......
    0x3f, 0x80,  //..%@@@@@%......
    0x3f, 0x00,  //..@@@@@@+......
    0x3f, 0x00,  //..@@@@@@.......
    0x3f, 0x1c,  //.+@@@@@%..+%@@+
    0x7f, 0xfc,  //.%@@@@@%@@@@@@.
    0x7f, 0xfc,  //.@@@@@@@@@@@@%.
    0x7f, 0xf8,  //.@@@@@@@@@@@@..
    0x7f, 0xf8,  //+@@@@@@@@@@@%..
    0xff, 0xf0,  //%@@@@@@@@@@@+..
    0xfd, 0xf0,  //@@@@@%+%@@@@...
    0xc1, 0xe0,  //%%+....@@@@+...
    0x01, 0xe0,  //.......@@@@....
    0x01, 0xc0,  //......+@@@+....
    0x03, 0xc0,  //......%@@@.....
    0x03, 0x80,  //......@@@+.....
    0x03, 0x80,  //......@@@......
    0x03, 0x80,  //.....+@@%......
    0x07, 0x00,  //.....%@@.......
    0x07, 0x00,  //.....@@%.......
    0x06, 0x00,  //.....@@........
    0x06, 0x00,  //....+@%........
    0x0c, 0x00,  //....%@.........
    0x0c, 0x00,  //....%%.........
    0x00, 0x00,  //...............


    /*Unicode: U+f0f3 () , Width: 27 */
    0x00, 0x04, 0x00, 0x00,  //............+%+............
    0x00, 0x0e, 0x00, 0x00,  //............@@@............
    0x00, 0x0e, 0x00, 0x00,  //...........+@@@+...........
    0x00, 0x7f, 0xc0, 0x00,  //........+@@@@@@@@@.........
    0x00, 0xff, 0xe0, 0x00,  //.......+@@@@@@@@@@@+.......
    0x01, 0xff, 0xf0, 0x00,  //......+@@@@@@@@@@@@@+......
    0x03, 0xff, 0xf8, 0x00,  //......@@@@@@@@@@@@@@@......
    0x03, 0xff, 0xf8, 0x00,  //.....+@@@@@@@@@@@@@@@+.....
    0x07, 0xff, 0xfc, 0x00,  //.....%@@@@@@@@@@@@@@@%.....
    0x07, 0xff, 0xfc, 0x00,  //.....@@@@@@@@@@@@@@@@%.....
    0x07, 0xff, 0xfc, 0x00,  //.....@@@@@@@@@@@@@@@@@.....
    0x07, 0xff, 0xfc, 0x00,  //.....@@@@@@@@@@@@@@@@@.....
    0x07, 0xff, 0xfc, 0x00,  //.....@@@@@@@@@@@@@@@@@.....
    0x07, 0xff, 0xfc, 0x00,  //.....@@@@@@@@@@@@@@@@@.....
    0x07, 0xff, 0xfc, 0x00,  //....+@@@@@@@@@@@@@@@@@.....
    0x0f, 0xff, 0xfc, 0x00,  //....%@@@@@@@@@@@@@@@@@+....
    0x0f, 0xff, 0xfe, 0x00,  //....@@@@@@@@@@@@@@@@@@%....
    0x0f, 0xff, 0xfe, 0x00,  //....@@@@@@@@@@@@@@@@@@@....
    0x1f, 0xff, 0xff, 0x00,  //...%@@@@@@@@@@@@@@@@@@@%...
    0x1f, 0xff, 0xff, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@...
    0x3f, 0xff, 0xff, 0x80,  //..@@@@@@@@@@@@@@@@@@@@@@%..
    0x7f, 0xff, 0xff, 0xc0,  //.%@@@@@@@@@@@@@@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xe0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0xff, 0xff, 0xc0,  //.@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x7f, 0xc0, 0x00,  //.........%%%@@@@@%.........
    0x00, 0x2f, 0x80, 0x00,  //.........+@+@@@@@+.........
    0x00, 0x37, 0x80, 0x00,  //..........%@+%@@%..........
    0x00, 0x1f, 0x00, 0x00,  //...........%@@@%...........
    0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f11c () , Width: 32 */
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x7f, 0xff, 0xff, 0xfc,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xc0, 0x00, 0x00, 0x06,  //@@...........................@@.
    0xc0, 0x00, 0x00, 0x06,  //@@...........................@@.
    0xc0, 0x00, 0x00, 0x06,  //@@...........................@@.
    0xcc, 0xce, 0x66, 0x66,  //@@..@@..@@..@@@..@@..@@..@@..@@.
    0xcc, 0xce, 0x66, 0x66,  //@@..@@..@@..@@@..@@..@@..@@..@@.
    0xc0, 0x00, 0x00, 0x66,  //@@.......................@@..@@.
    0xc0, 0x00, 0x00, 0x66,  //@@.......................@@..@@.
    0xcf, 0x31, 0x99, 0xe6,  //@@..@@@@..@@...@@..@@..@@@@..@@.
    0xcf, 0x31, 0x99, 0xe6,  //@@..@@@@..@@...@@..@@..@@@@..@@.
    0xc0, 0x00, 0x00, 0x06,  //@@...........................@@.
    0xc0, 0x00, 0x00, 0x06,  //@@...........................@@.
    0xcc, 0xff, 0xfe, 0x66,  //@@..@@..@@@@@@@@@@@@@@@..@@..@@.
    0xcc, 0xff, 0xfe, 0x66,  //@@..@@..@@@@@@@@@@@@@@@..@@..@@.
    0xc0, 0x00, 0x00, 0x06,  //@@...........................@@.
    0xc0, 0x00, 0x00, 0x06,  //@@...........................@@.
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x7f, 0xff, 0xff, 0xfc,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f124 () , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x04,  //.....................%+
    0x00, 0x00, 0x1e,  //...................%@@%
    0x00, 0x00, 0x7c,  //.................%@@@@+
    0x00, 0x01, 0xfc,  //...............%@@@@@@.
    0x00, 0x07, 0xf8,  //.............%@@@@@@@+.
    0x00, 0x1f, 0xf8,  //...........%@@@@@@@@@..
    0x00, 0x7f, 0xf0,  //.........%@@@@@@@@@@+..
    0x01, 0xff, 0xf0,  //.......%@@@@@@@@@@@@...
    0x07, 0xff, 0xe0,  //.....%@@@@@@@@@@@@@+...
    0x1f, 0xff, 0xe0,  //...%@@@@@@@@@@@@@@@....
    0x7f, 0xff, 0xc0,  //.%@@@@@@@@@@@@@@@@+....
    0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@.....
    0x7f, 0xff, 0x80,  //+%%%%%%%%%@@@@@@@+.....
    0x00, 0x3f, 0x80,  //..........%@@@@@@......
    0x00, 0x3f, 0x00,  //..........%@@@@@+......
    0x00, 0x3f, 0x00,  //..........%@@@@@.......
    0x00, 0x3e, 0x00,  //..........%@@@@+.......
    0x00, 0x3e, 0x00,  //..........%@@@@........
    0x00, 0x3c, 0x00,  //..........%@@@+........
    0x00, 0x3c, 0x00,  //..........%@@@.........
    0x00, 0x38, 0x00,  //..........%@@+.........
    0x00, 0x38, 0x00,  //..........%@@..........
    0x00, 0x10, 0x00,  //..........+@+..........
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f15b () , Width: 25 */
    0x7f, 0xfc, 0x00, 0x00,  //+@@@@@@@@@@@@@+..........
    0xff, 0xfc, 0x40, 0x00,  //@@@@@@@@@@@@@@+.+%.......
    0xff, 0xfc, 0x60, 0x00,  //@@@@@@@@@@@@@@+.+@%......
    0xff, 0xfc, 0x70, 0x00,  //@@@@@@@@@@@@@@+.+@@%.....
    0xff, 0xfc, 0x78, 0x00,  //@@@@@@@@@@@@@@+.+@@@%....
    0xff, 0xfc, 0x7c, 0x00,  //@@@@@@@@@@@@@@+.+@@@@%...
    0xff, 0xfc, 0x7e, 0x00,  //@@@@@@@@@@@@@@+.+@@@@@%..
    0xff, 0xfc, 0x7f, 0x00,  //@@@@@@@@@@@@@@+.+@@@@@@%.
    0xff, 0xfc, 0x00, 0x00,  //@@@@@@@@@@@@@@+..+++++++.
    0xff, 0xfe, 0x00, 0x00,  //@@@@@@@@@@@@@@%..........
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%%%%%%%%%
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0xff, 0xff, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f1eb () , Width: 32 */
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x1f, 0xf0, 0x00,  //..........+%%@@@@@@%+...........
    0x00, 0xff, 0xff, 0x00,  //.......+%@@@@@@@@@@@@@@%........
    0x03, 0xff, 0xff, 0xc0,  //.....+@@@@@@@@@@@@@@@@@@@%......
    0x0f, 0xff, 0xff, 0xf0,  //....%@@@@@@@@@@@@@@@@@@@@@@%....
    0x1f, 0xf0, 0x1f, 0xf8,  //..+@@@@@@@@%++....+%@@@@@@@@@...
    0x7f, 0x80, 0x03, 0xfc,  //.%@@@@@@@+............%@@@@@@@+.
    0xfe, 0x00, 0x00, 0xfe,  //%@@@@@@+................%@@@@@@+
    0xfc, 0x1f, 0xf0, 0x3f,  //@@@@@@.....%@@@@@@@%+.....@@@@@%
    0x78, 0x7f, 0xfe, 0x1e,  //.@@@%...+@@@@@@@@@@@@@@+...@@@%.
    0x21, 0xff, 0xff, 0x8c,  //..@+..+@@@@@@@@@@@@@@@@@@...%%..
    0x03, 0xff, 0xff, 0xc0,  //.....+@@@@@@@@@@@@@@@@@@@@+.....
    0x07, 0xf8, 0x1f, 0xe0,  //....+@@@@@@@%+....+%@@@@@@@.....
    0x07, 0xc0, 0x03, 0xe0,  //.....@@@@@...........+@@@@%.....
    0x03, 0x0f, 0xe1, 0xc0,  //......@@+...%@@@@@%+...%@%......
    0x00, 0x3f, 0xfc, 0x00,  //..........%@@@@@@@@@@+..........
    0x00, 0x7f, 0xfe, 0x00,  //.........@@@@@@@@@@@@@%.........
    0x00, 0x7f, 0xfe, 0x00,  //.........@@@@@@@@@@@@@%.........
    0x00, 0x3c, 0x3c, 0x00,  //..........@@@%....%@@%..........
    0x00, 0x00, 0x00, 0x00,  //...........+........+...........
    0x00, 0x03, 0xc0, 0x00,  //..............%@@%..............
    0x00, 0x07, 0xc0, 0x00,  //.............%@@@@+.............
    0x00, 0x03, 0xc0, 0x00,  //..............@@@%..............
    0x00, 0x01, 0x80, 0x00,  //...............%%...............
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f240 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x7f, 0xff, 0xff, 0xff, 0xc0,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xe0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@..+++++++++++++++++++++++++++..@@...
    0xcf, 0xff, 0xff, 0xfe, 0x60,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@+..
    0xcf, 0xff, 0xff, 0xfe, 0x78,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@@@.
    0xcf, 0xff, 0xff, 0xfe, 0x18,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xcf, 0xff, 0xff, 0xfe, 0x18,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xcf, 0xff, 0xff, 0xfe, 0x18,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xcf, 0xff, 0xff, 0xfe, 0x18,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xcf, 0xff, 0xff, 0xfe, 0x18,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xcf, 0xff, 0xff, 0xfe, 0x18,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xcf, 0xff, 0xff, 0xfe, 0x18,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xcf, 0xff, 0xff, 0xfe, 0x78,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@@@.
    0xcf, 0xff, 0xff, 0xfe, 0x70,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@@+.
    0xcf, 0xff, 0xff, 0xfe, 0x60,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xff, 0xff, 0xff, 0xff, 0xe0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x7f, 0xff, 0xff, 0xff, 0xc0,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f241 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x7f, 0xff, 0xff, 0xff, 0xc0,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xe0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@..+++++++++++++++++++++........@@...
    0xcf, 0xff, 0xff, 0x80, 0x60,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@+..
    0xcf, 0xff, 0xff, 0x80, 0x78,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@@@.
    0xcf, 0xff, 0xff, 0x80, 0x18,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xcf, 0xff, 0xff, 0x80, 0x18,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xcf, 0xff, 0xff, 0x80, 0x18,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xcf, 0xff, 0xff, 0x80, 0x18,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xcf, 0xff, 0xff, 0x80, 0x18,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xcf, 0xff, 0xff, 0x80, 0x18,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xcf, 0xff, 0xff, 0x80, 0x18,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xcf, 0xff, 0xff, 0x80, 0x78,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@@@.
    0xcf, 0xff, 0xff, 0x80, 0x70,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@@+.
    0xcf, 0xff, 0xff, 0x80, 0x60,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xff, 0xff, 0xff, 0xff, 0xe0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x7f, 0xff, 0xff, 0xff, 0xc0,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f242 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x7f, 0xff, 0xff, 0xff, 0xc0,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xe0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@..++++++++++++++...............@@...
    0xcf, 0xff, 0xc0, 0x00, 0x60,  //@@..@@@@@@@@@@@@@@+..............@@+..
    0xcf, 0xff, 0xc0, 0x00, 0x78,  //@@..@@@@@@@@@@@@@@+..............@@@@.
    0xcf, 0xff, 0xc0, 0x00, 0x18,  //@@..@@@@@@@@@@@@@@+................@@.
    0xcf, 0xff, 0xc0, 0x00, 0x18,  //@@..@@@@@@@@@@@@@@+................@@.
    0xcf, 0xff, 0xc0, 0x00, 0x18,  //@@..@@@@@@@@@@@@@@+................@@.
    0xcf, 0xff, 0xc0, 0x00, 0x18,  //@@..@@@@@@@@@@@@@@+................@@.
    0xcf, 0xff, 0xc0, 0x00, 0x18,  //@@..@@@@@@@@@@@@@@+................@@.
    0xcf, 0xff, 0xc0, 0x00, 0x18,  //@@..@@@@@@@@@@@@@@+................@@.
    0xcf, 0xff, 0xc0, 0x00, 0x18,  //@@..@@@@@@@@@@@@@@+................@@.
    0xcf, 0xff, 0xc0, 0x00, 0x78,  //@@..@@@@@@@@@@@@@@+..............@@@@.
    0xcf, 0xff, 0xc0, 0x00, 0x70,  //@@..@@@@@@@@@@@@@@+..............@@@+.
    0xcf, 0xff, 0xc0, 0x00, 0x60,  //@@..@@@@@@@@@@@@@@+..............@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xff, 0xff, 0xff, 0xff, 0xe0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x7f, 0xff, 0xff, 0xff, 0xc0,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f243 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x7f, 0xff, 0xff, 0xff, 0xc0,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xe0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@..++++++++.....................@@...
    0xcf, 0xf0, 0x00, 0x00, 0x60,  //@@..@@@@@@@@+....................@@+..
    0xcf, 0xf0, 0x00, 0x00, 0x78,  //@@..@@@@@@@@+....................@@@@.
    0xcf, 0xf0, 0x00, 0x00, 0x18,  //@@..@@@@@@@@+......................@@.
    0xcf, 0xf0, 0x00, 0x00, 0x18,  //@@..@@@@@@@@+......................@@.
    0xcf, 0xf0, 0x00, 0x00, 0x18,  //@@..@@@@@@@@+......................@@.
    0xcf, 0xf0, 0x00, 0x00, 0x18,  //@@..@@@@@@@@+......................@@.
    0xcf, 0xf0, 0x00, 0x00, 0x18,  //@@..@@@@@@@@+......................@@.
    0xcf, 0xf0, 0x00, 0x00, 0x18,  //@@..@@@@@@@@+......................@@.
    0xcf, 0xf0, 0x00, 0x00, 0x18,  //@@..@@@@@@@@+......................@@.
    0xcf, 0xf0, 0x00, 0x00, 0x78,  //@@..@@@@@@@@+....................@@@@.
    0xcf, 0xf0, 0x00, 0x00, 0x70,  //@@..@@@@@@@@+....................@@@+.
    0xcf, 0xf0, 0x00, 0x00, 0x60,  //@@..@@@@@@@@+....................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xff, 0xff, 0xff, 0xff, 0xe0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x7f, 0xff, 0xff, 0xff, 0xc0,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f244 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x7f, 0xff, 0xff, 0xff, 0xc0,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xe0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@+..
    0xc0, 0x00, 0x00, 0x00, 0x78,  //@@...............................@@@%.
    0xc0, 0x00, 0x00, 0x00, 0x18,  //@@.................................@@.
    0xc0, 0x00, 0x00, 0x00, 0x18,  //@@.................................@@.
    0xc0, 0x00, 0x00, 0x00, 0x18,  //@@.................................@@.
    0xc0, 0x00, 0x00, 0x00, 0x18,  //@@.................................@@.
    0xc0, 0x00, 0x00, 0x00, 0x18,  //@@.................................@@.
    0xc0, 0x00, 0x00, 0x00, 0x18,  //@@.................................@@.
    0xc0, 0x00, 0x00, 0x00, 0x18,  //@@.................................@@.
    0xc0, 0x00, 0x00, 0x00, 0x78,  //@@...............................@@@@.
    0xc0, 0x00, 0x00, 0x00, 0x70,  //@@...............................@@@+.
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xc0, 0x00, 0x00, 0x00, 0x60,  //@@...............................@@...
    0xff, 0xff, 0xff, 0xff, 0xe0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x7f, 0xff, 0xff, 0xff, 0xc0,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f293 () , Width: 22 */
    0x01, 0xfe, 0x00,  //......+%@@@@@%%.......
    0x07, 0xff, 0x80,  //....+@@@@@@@@@@@%.....
    0x1f, 0xff, 0xc0,  //...%@@@@@@%@@@@@@@....
    0x1f, 0xdf, 0xe0,  //..+@@@@@@%.%@@@@@@@...
    0x3f, 0xcf, 0xf0,  //..@@@@@@@%..%@@@@@@%..
    0x7f, 0xc7, 0xf0,  //.%@@@@@@@%...%@@@@@@..
    0x7f, 0xc3, 0xf0,  //.@@@@@@@@%....%@@@@@+.
    0x7f, 0xc1, 0xf8,  //.@@@@@@@@%..+..%@@@@%.
    0x7b, 0xc8, 0xf8,  //+@@@@.%@@%..@+..%@@@@.
    0xf1, 0xcc, 0x78,  //%@@@+..%@%..@@...@@@@.
    0xf8, 0xc8, 0xf8,  //%@@@@+..%%..@+..%@@@@+
    0xfc, 0x01, 0xf8,  //@@@@@@+..+..+..%@@@@@+
    0xfe, 0x03, 0xf8,  //@@@@@@@+......%@@@@@@+
    0xff, 0x07, 0xf8,  //@@@@@@@@+....%@@@@@@@+
    0xff, 0x87, 0xfc,  //@@@@@@@@@...+@@@@@@@@%
    0xff, 0x07, 0xf8,  //@@@@@@@@+....%@@@@@@@+
    0xfe, 0x03, 0xf8,  //@@@@@@@+......%@@@@@@+
    0xfc, 0x01, 0xf8,  //@@@@@@+..+..+..%@@@@@+
    0xf8, 0xc8, 0xf8,  //%@@@@+..%%..@+..%@@@@+
    0xf1, 0xcc, 0x78,  //%@@@+..%@%..@@...@@@@.
    0x7b, 0xc8, 0xf8,  //+@@@@.%@@%..@+..%@@@@.
    0x7f, 0xc1, 0xf8,  //.@@@@@@@@%..+..%@@@@%.
    0x7f, 0xc3, 0xf0,  //.@@@@@@@@%....%@@@@@+.
    0x7f, 0xc7, 0xf0,  //.%@@@@@@@%...%@@@@@@..
    0x3f, 0xcf, 0xf0,  //..@@@@@@@%..%@@@@@@%..
    0x1f, 0xdf, 0xe0,  //..+@@@@@@%.%@@@@@@@...
    0x1f, 0xff, 0xc0,  //...%@@@@@@%@@@@@@@....
    0x07, 0xff, 0x80,  //....+@@@@@@@@@@@%.....
    0x01, 0xfe, 0x00,  //......+%@@@@@%%.......
    0x00, 0x00, 0x00,  //......................



#elif USE_LV_FONT_SYMBOL_30 == 2
    /*Unicode: U+f001 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x40,  //.....................+%%+
    0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //..................+%@@@@@
    0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xc0,  //...............+@@@@@@@@@
    0x00, 0x00, 0x01, 0xbf, 0xff, 0xff, 0xc0,  //...........+%@@@@@@@@@@@@
    0x00, 0x00, 0x2f, 0xff, 0xff, 0xff, 0xc0,  //.........%@@@@@@@@@@@@@@@
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xc0,  //........@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xc0,  //........@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xc0,  //........@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xc0,  //........@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0xff, 0xff, 0xfe, 0x43, 0xc0,  //........@@@@@@@@@@@%+..@@
    0x00, 0x00, 0xff, 0xff, 0x90, 0x03, 0xc0,  //........@@@@@@@@%+.....@@
    0x00, 0x00, 0xff, 0xe0, 0x00, 0x03, 0xc0,  //........@@@@@%.........@@
    0x00, 0x00, 0xf4, 0x00, 0x00, 0x03, 0xc0,  //........@@+............@@
    0x00, 0x00, 0xf0, 0x00, 0x00, 0x03, 0xc0,  //........@@.............@@
    0x00, 0x00, 0xf0, 0x00, 0x00, 0x03, 0xc0,  //........@@.............@@
    0x00, 0x00, 0xf0, 0x00, 0x00, 0x03, 0xc0,  //........@@.............@@
    0x00, 0x00, 0xf0, 0x00, 0x00, 0x03, 0xc0,  //........@@.............@@
    0x00, 0x00, 0xf0, 0x00, 0x7f, 0xff, 0xc0,  //........@@......+@@@@@%@@
    0x00, 0x00, 0xf0, 0x03, 0xff, 0xff, 0xc0,  //........@@.....@@@@@@@@@@
    0x00, 0x00, 0xf0, 0x07, 0xff, 0xff, 0xc0,  //........@@....+@@@@@@@@@@
    0x00, 0x00, 0xf0, 0x03, 0xff, 0xff, 0xc0,  //........@@.....@@@@@@@@@@
    0x1b, 0xfe, 0xf0, 0x02, 0xff, 0xff, 0x40,  //.+%@@@@%@@.....%@@@@@@@@+
    0xbf, 0xff, 0xf0, 0x00, 0x2f, 0xf4, 0x00,  //%@@@@@@@@@.......%@@@@+..
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@...............
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@...............
    0xbf, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@+...............
    0x1b, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+%@@@@%.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f008 () , Width: 32 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xf4, 0x1f, 0x40, 0x00, 0x00, 0x07, 0xd0, 0x7c,  //@@+..+@@+.............+@@+..+@@.
    0xf0, 0x0f, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x3c,  //@@....@@...............@@....@@.
    0xf0, 0x0f, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x3c,  //@@....@@...............@@....@@.
    0xf4, 0x0f, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x3c,  //@@+...@@...............@@....@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xfc,  //@@@@@@@@...............@@@@@@@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xfc,  //@@@@@@@@...............@@@@@@@@.
    0xf4, 0x1f, 0x00, 0x00, 0x00, 0x03, 0xd0, 0x7c,  //@@+..+@@...............@@+..+@@.
    0xf0, 0x0f, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x3c,  //@@....@@...............@@....@@.
    0xf0, 0x0f, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x3c,  //@@....@@...............@@....@@.
    0xf0, 0x0f, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x3c,  //@@....@@...............@@....@@.
    0xf4, 0x1f, 0x40, 0x00, 0x00, 0x07, 0xd0, 0x7c,  //@@+..+@@+.............+@@+..+@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xf4, 0x0f, 0x40, 0x00, 0x00, 0x07, 0xc0, 0x3c,  //@@+...@@+.............+@@....@@.
    0xf0, 0x0f, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x3c,  //@@....@@...............@@....@@.
    0xf0, 0x0f, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x3c,  //@@....@@...............@@....@@.
    0xf4, 0x1f, 0x00, 0x00, 0x00, 0x03, 0xd0, 0x7c,  //@@+..+@@...............@@+..+@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xfc,  //@@@@@@@@...............@@@@@@@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xfc,  //@@@@@@@@...............@@@@@@@@.
    0xf4, 0x0f, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x3c,  //@@+...@@...............@@....@@.
    0xf0, 0x0f, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x3c,  //@@....@@...............@@....@@.
    0xf0, 0x0f, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x3c,  //@@....@@...............@@....@@.
    0xf4, 0x0f, 0x40, 0x00, 0x00, 0x07, 0xc0, 0x3c,  //@@+...@@+.............+@@....@@.
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f00b () , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x7f, 0xfe, 0x03, 0xff, 0xff, 0xff, 0xff, 0x40,  //+@@@@@@%...@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@..%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x4b, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x4b, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x4b, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xbf, 0xff, 0x07, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@..+@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0xbf, 0xff, 0x07, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@..+@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0x4b, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x4b, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x4b, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@..%@@@@@@@@@@@@@@@@@@
    0x7f, 0xfe, 0x03, 0xff, 0xff, 0xff, 0xff, 0x40,  //+@@@@@@%...@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0xbf, 0xff, 0x07, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@..+@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0x4b, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x4b, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x4b, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@..%@@@@@@@@@@@@@@@@@@
    0x7f, 0xfe, 0x03, 0xff, 0xff, 0xff, 0xff, 0x40,  //+@@@@@@%...@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f00c () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,  //.....................+...
    0x00, 0x00, 0x00, 0x00, 0x01, 0xfc, 0x00,  //...................+@@@..
    0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0x00,  //..................+@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xc0,  //.................+@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xc0,  //................+@@@@@@@@
    0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0x40,  //...............+@@@@@@@@+
    0x02, 0x40, 0x00, 0x07, 0xff, 0xfd, 0x00,  //...%+.........+@@@@@@@@+.
    0x0f, 0xd0, 0x00, 0x1f, 0xff, 0xf4, 0x00,  //..@@@+.......+@@@@@@@@+..
    0x3f, 0xf4, 0x00, 0x7f, 0xff, 0xd0, 0x00,  //.@@@@@+.....+@@@@@@@@+...
    0xff, 0xfd, 0x01, 0xff, 0xff, 0x40, 0x00,  //@@@@@@@+...+@@@@@@@@+....
    0xff, 0xff, 0x47, 0xff, 0xfd, 0x00, 0x00,  //@@@@@@@@+.+@@@@@@@@+.....
    0x7f, 0xff, 0xef, 0xff, 0xf4, 0x00, 0x00,  //+@@@@@@@@%@@@@@@@@+......
    0x1f, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //.+@@@@@@@@@@@@@@@+.......
    0x07, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00,  //..+@@@@@@@@@@@@@+........
    0x01, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@+.........
    0x00, 0x7f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //....+@@@@@@@@@+..........
    0x00, 0x1f, 0xff, 0xd0, 0x00, 0x00, 0x00,  //.....+@@@@@@@+...........
    0x00, 0x07, 0xff, 0x40, 0x00, 0x00, 0x00,  //......+@@@@@+............
    0x00, 0x01, 0xfd, 0x00, 0x00, 0x00, 0x00,  //.......+@@@+.............
    0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00,  //........+%+..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f00d () , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x02, 0xe0, 0x00, 0x02, 0xd0,  //...%@%.........%@+..
    0x0b, 0xf8, 0x00, 0x0f, 0xf4,  //..%@@@%.......@@@@+.
    0x2f, 0xfe, 0x00, 0x3f, 0xfd,  //.%@@@@@%.....@@@@@@+
    0x3f, 0xff, 0x80, 0xff, 0xff,  //.@@@@@@@%...@@@@@@@@
    0x3f, 0xff, 0xe3, 0xff, 0xff,  //.@@@@@@@@%.@@@@@@@@%
    0x0f, 0xff, 0xff, 0xff, 0xfc,  //..@@@@@@@@@@@@@@@@@.
    0x03, 0xff, 0xff, 0xff, 0xf0,  //...@@@@@@@@@@@@@@@..
    0x00, 0xff, 0xff, 0xff, 0xc0,  //....@@@@@@@@@@@@@...
    0x00, 0x3f, 0xff, 0xff, 0x00,  //.....@@@@@@@@@@@....
    0x00, 0x1f, 0xff, 0xfc, 0x00,  //.....+@@@@@@@@@.....
    0x00, 0x3f, 0xff, 0xfe, 0x00,  //.....@@@@@@@@@@%....
    0x00, 0xff, 0xff, 0xff, 0x80,  //....@@@@@@@@@@@@%...
    0x03, 0xff, 0xff, 0xff, 0xe0,  //...@@@@@@@@@@@@@@%..
    0x0f, 0xff, 0xff, 0xff, 0xf8,  //..@@@@@@@@@@@@@@@@%.
    0x3f, 0xff, 0xf7, 0xff, 0xfe,  //.@@@@@@@@@+@@@@@@@@%
    0x3f, 0xff, 0xc0, 0xff, 0xff,  //.@@@@@@@@...@@@@@@@@
    0x3f, 0xff, 0x00, 0x3f, 0xfe,  //.@@@@@@@.....@@@@@@%
    0x0f, 0xfc, 0x00, 0x0f, 0xf8,  //..@@@@@.......@@@@%.
    0x03, 0xf0, 0x00, 0x03, 0xe0,  //...@@@.........@@%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+f011 () , Width: 25 */
    0x00, 0x00, 0x03, 0xd0, 0x00, 0x00, 0x00,  //...........@@+...........
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //..........@@@@...........
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //..........@@@@...........
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //..........@@@@...........
    0x00, 0x28, 0x0f, 0xf0, 0x28, 0x00, 0x00,  //.....%%...@@@@...%%......
    0x00, 0xff, 0x0f, 0xf0, 0xff, 0x00, 0x00,  //....@@@@..@@@@..@@@@.....
    0x03, 0xff, 0x0f, 0xf0, 0xff, 0xc0, 0x00,  //...@@@@@..@@@@..@@@@@....
    0x0b, 0xff, 0x0f, 0xf0, 0xbf, 0xf0, 0x00,  //..%@@@@@..@@@@..%@@@@@...
    0x1f, 0xfc, 0x0f, 0xf0, 0x3f, 0xf4, 0x00,  //.+@@@@@...@@@@...@@@@@+..
    0x3f, 0xf0, 0x0f, 0xf0, 0x0f, 0xfc, 0x00,  //.@@@@@....@@@@....@@@@@..
    0x7f, 0xd0, 0x0f, 0xf0, 0x03, 0xfd, 0x00,  //+@@@@+....@@@@.....@@@@+.
    0xbf, 0xc0, 0x0f, 0xf0, 0x02, 0xfe, 0x00,  //%@@@@.....@@@@.....%@@@%.
    0xff, 0x40, 0x0f, 0xf0, 0x01, 0xff, 0x00,  //@@@@+.....@@@@.....+@@@@.
    0xff, 0x40, 0x0b, 0xf0, 0x00, 0xff, 0x00,  //@@@@+.....%@@@......@@@@.
    0xff, 0x00, 0x01, 0x40, 0x00, 0xff, 0x00,  //@@@@.......++.......@@@@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,  //@@@@................@@@@.
    0xff, 0x40, 0x00, 0x00, 0x00, 0xff, 0x00,  //@@@@+...............@@@@.
    0xbf, 0x80, 0x00, 0x00, 0x02, 0xff, 0x00,  //%@@@%..............%@@@@.
    0x7f, 0xc0, 0x00, 0x00, 0x03, 0xfd, 0x00,  //+@@@@..............@@@@+.
    0x3f, 0xe0, 0x00, 0x00, 0x0b, 0xfc, 0x00,  //.@@@@%............%@@@@..
    0x2f, 0xf4, 0x00, 0x00, 0x1f, 0xf8, 0x00,  //.+@@@@+..........+@@@@%..
    0x0f, 0xfe, 0x00, 0x00, 0xbf, 0xf0, 0x00,  //..@@@@@%........%@@@@@...
    0x03, 0xff, 0xe4, 0x0b, 0xff, 0xd0, 0x00,  //...@@@@@@%+...%@@@@@@+...
    0x01, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00,  //...+@@@@@@@@@@@@@@@@+....
    0x00, 0x7f, 0xff, 0xff, 0xfd, 0x00, 0x00,  //....+@@@@@@@@@@@@@@+.....
    0x00, 0x0b, 0xff, 0xff, 0xe0, 0x00, 0x00,  //......%@@@@@@@@@@%.......
    0x00, 0x00, 0x7f, 0xfd, 0x00, 0x00, 0x00,  //........+@@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f013 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x0f, 0xfc, 0x00, 0x00, 0x00,  //..........@@@@@..........
    0x00, 0x00, 0x0f, 0xfc, 0x00, 0x00, 0x00,  //..........@@@@@..........
    0x00, 0x20, 0x1f, 0xfc, 0x02, 0x00, 0x00,  //.....%...+@@@@@....%.....
    0x01, 0xfd, 0x2f, 0xfe, 0x1f, 0xc0, 0x00,  //...+@@@+.%@@@@@%.+@@@....
    0x03, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //...@@@@@@@@@@@@@@@@@@@...
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@@@@@@@@@%..
    0x03, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //...@@@@@@@@@@@@@@@@@@@...
    0x01, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //...+@@@@@@@@@@@@@@@@@+...
    0x00, 0xff, 0xfd, 0x5f, 0xff, 0xc0, 0x00,  //....@@@@@@@+++@@@@@@@....
    0x06, 0xff, 0xe0, 0x02, 0xff, 0xe0, 0x00,  //...%@@@@@%.....%@@@@@%...
    0xff, 0xff, 0xc0, 0x00, 0xff, 0xff, 0xc0,  //@@@@@@@@@.......@@@@@@@@@
    0xff, 0xff, 0x40, 0x00, 0x7f, 0xff, 0xc0,  //@@@@@@@@+.......+@@@@@@@@
    0xff, 0xff, 0x40, 0x00, 0x7f, 0xff, 0xc0,  //@@@@@@@@+.......+@@@@@@@@
    0xff, 0xff, 0x40, 0x00, 0x7f, 0xff, 0xc0,  //@@@@@@@@+.......+@@@@@@@@
    0xff, 0xff, 0xc0, 0x00, 0xff, 0xff, 0xc0,  //@@@@@@@@@.......@@@@@@@@@
    0x02, 0xff, 0xe0, 0x02, 0xff, 0xe4, 0x00,  //...%@@@@@%.....%@@@@@%+..
    0x00, 0xff, 0xf9, 0x1b, 0xff, 0xc0, 0x00,  //....@@@@@@%+.+%@@@@@@....
    0x01, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //...+@@@@@@@@@@@@@@@@@+...
    0x03, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //...@@@@@@@@@@@@@@@@@@@...
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@@@@@@@@@%..
    0x03, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00,  //...@@@@@@@@@@@@@@@@@@@...
    0x01, 0xfd, 0x2f, 0xfe, 0x1f, 0xd0, 0x00,  //...+@@@+.%@@@@@%.+@@@+...
    0x00, 0x34, 0x0f, 0xfd, 0x07, 0x40, 0x00,  //.....@....@@@@@+..+@+....
    0x00, 0x00, 0x0f, 0xfc, 0x00, 0x00, 0x00,  //..........@@@@@..........
    0x00, 0x00, 0x0f, 0xfc, 0x00, 0x00, 0x00,  //..........@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f014 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x02, 0xff, 0xfd, 0x00, 0x00,  //.......%@@@@@@@+.......
    0x00, 0x07, 0xff, 0xff, 0x00, 0x00,  //......+@@@@@@@@@.......
    0x00, 0x0f, 0x40, 0x0b, 0x80, 0x00,  //......@@+.....%@%......
    0x00, 0x1f, 0x00, 0x03, 0xc0, 0x00,  //.....+@@.......@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@%
    0x0f, 0x00, 0x00, 0x00, 0x07, 0x80,  //..@@..............+@%..
    0x0f, 0x00, 0x00, 0x00, 0x07, 0x80,  //..@@..............+@%..
    0x0f, 0x00, 0x00, 0x00, 0x07, 0x80,  //..@@..............+@%..
    0x0f, 0x01, 0x01, 0x01, 0x07, 0x80,  //..@@...+...+...+..+@%..
    0x0f, 0x0f, 0x4b, 0x47, 0x87, 0x80,  //..@@..@@+.%@+.+@%.+@%..
    0x0f, 0x0f, 0x4b, 0x47, 0x87, 0x80,  //..@@..@@+.%@+.+@%.+@%..
    0x0f, 0x0f, 0x4b, 0x47, 0x87, 0x80,  //..@@..@@+.%@+.+@%.+@%..
    0x0f, 0x0f, 0x4b, 0x47, 0x87, 0x80,  //..@@..@@+.%@+.+@%.+@%..
    0x0f, 0x0f, 0x4b, 0x47, 0x87, 0x80,  //..@@..@@+.%@+.+@%.+@%..
    0x0f, 0x0f, 0x4b, 0x47, 0x87, 0x80,  //..@@..@@+.%@+.+@%.+@%..
    0x0f, 0x0f, 0x4b, 0x47, 0x87, 0x80,  //..@@..@@+.%@+.+@%.+@%..
    0x0f, 0x0f, 0x4b, 0x47, 0x87, 0x80,  //..@@..@@+.%@+.+@%.+@%..
    0x0f, 0x0f, 0x4b, 0x47, 0x87, 0x80,  //..@@..@@+.%@+.+@%.+@%..
    0x0f, 0x0b, 0x0b, 0x47, 0x47, 0x80,  //..@@..%@..%@+.+@+.+@%..
    0x0f, 0x00, 0x00, 0x00, 0x07, 0x80,  //..@@..............+@%..
    0x0f, 0x00, 0x00, 0x00, 0x07, 0x80,  //..@@..............+@%..
    0x0f, 0x40, 0x00, 0x00, 0x0b, 0x80,  //..@@+.............%@%..
    0x07, 0xff, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@@@@@...
    0x02, 0xff, 0xff, 0xff, 0xfd, 0x00,  //...%@@@@@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f015 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x64, 0x02, 0xa8, 0x00,  //............+%+....%%%%....
    0x00, 0x00, 0x02, 0xfe, 0x03, 0xfc, 0x00,  //...........%@@@%...@@@@....
    0x00, 0x00, 0x0f, 0xff, 0xc3, 0xfc, 0x00,  //..........@@@@@@@..@@@@....
    0x00, 0x00, 0x3f, 0xcf, 0xf7, 0xfc, 0x00,  //.........@@@@.@@@@+@@@@....
    0x00, 0x01, 0xfe, 0x12, 0xff, 0xfc, 0x00,  //.......+@@@%.+.%@@@@@@@....
    0x00, 0x0b, 0xf8, 0xb8, 0x7f, 0xfc, 0x00,  //......%@@@+.%@%.+@@@@@@....
    0x00, 0x2f, 0xd3, 0xff, 0x1f, 0xfc, 0x00,  //.....%@@@+.@@@@@.+@@@@@....
    0x00, 0xff, 0x1f, 0xff, 0xd3, 0xfc, 0x00,  //....@@@@.+@@@@@@@+.@@@@....
    0x03, 0xfc, 0xbf, 0xff, 0xf8, 0xbf, 0x40,  //...@@@@.%@@@@@@@@@%.%@@@+..
    0x1f, 0xe2, 0xff, 0xff, 0xfe, 0x2f, 0xe0,  //.+@@@%.%@@@@@@@@@@@%.%@@@%.
    0x7f, 0x8f, 0xff, 0xff, 0xff, 0xc7, 0xf8,  //+@@@+.@@@@@@@@@@@@@@@.+@@@%
    0x3d, 0x7f, 0xff, 0xff, 0xff, 0xf4, 0xf4,  //.@@++@@@@@@@@@@@@@@@@@+.@@+
    0x00, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x10,  //....@@@@@@@@@@@@@@@@@@@..+.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....@@@@@@@@@@@@@@@@@@@....
    0x00, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....@@@@@@@@@@@@@@@@@@@....
    0x00, 0xff, 0xfc, 0x00, 0xff, 0xfc, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x00, 0xff, 0xfc, 0x00, 0xff, 0xfc, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x00, 0xff, 0xfc, 0x00, 0xff, 0xfc, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x00, 0xff, 0xfc, 0x00, 0xff, 0xfc, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x00, 0xff, 0xfc, 0x00, 0xff, 0xfc, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x00, 0xbf, 0xfc, 0x00, 0xff, 0xf8, 0x00,  //....%@@@@@@.....@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f019 () , Width: 27 */
    0x00, 0x00, 0x02, 0xaa, 0x00, 0x00, 0x00,  //...........%%%%%...........
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x05, 0x5f, 0xff, 0xd5, 0x40, 0x00,  //......++++@@@@@@%++++......
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.....%@@@@@@@@@@@@@@@%.....
    0x00, 0x1f, 0xff, 0xff, 0xff, 0xc0, 0x00,  //.....+@@@@@@@@@@@@@@@......
    0x00, 0x07, 0xff, 0xff, 0xff, 0x40, 0x00,  //......+@@@@@@@@@@@@@+......
    0x00, 0x01, 0xff, 0xff, 0xfd, 0x00, 0x00,  //.......+@@@@@@@@@@@+.......
    0x00, 0x00, 0x7f, 0xff, 0xf4, 0x00, 0x00,  //........+@@@@@@@@@.........
    0x00, 0x00, 0x1f, 0xff, 0xd0, 0x00, 0x00,  //.........+@@@@@@@..........
    0x00, 0x00, 0x07, 0xff, 0x00, 0x00, 0x00,  //..........+@@@@@...........
    0x00, 0x00, 0x01, 0xfc, 0x00, 0x00, 0x00,  //...........+@@@............
    0xbf, 0xff, 0xe0, 0x70, 0x3f, 0xff, 0xf8,  //%@@@@@@@@%..+@...%@@@@@@@@%
    0xff, 0xff, 0xf8, 0x00, 0xff, 0xff, 0xfc,  //@@@@@@@@@@%.....@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x47, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@+.+@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x7c, 0x7c,  //@@@@@@@@@@@@@@@@@@@.+@@.+@@
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x7d, 0x7c,  //@@@@@@@@@@@@@@@@@@@.+@@++@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //%@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f01c () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x7f, 0xff, 0xff, 0xff, 0x40, 0x00,  //....+@@@@@@@@@@@@@@@.....
    0x00, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //....@@@@@@@@@@@@@@@@@....
    0x01, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //...+@@@@@@@@@@@@@@@@@....
    0x03, 0xf8, 0x00, 0x00, 0x0b, 0xe0, 0x00,  //...@@@%...........%@@%...
    0x03, 0xf0, 0x00, 0x00, 0x07, 0xf0, 0x00,  //...@@@............+@@@...
    0x0b, 0xe0, 0x00, 0x00, 0x03, 0xf8, 0x00,  //..%@@%.............@@@%..
    0x0f, 0xd0, 0x00, 0x00, 0x01, 0xfc, 0x00,  //..@@@+.............+@@@..
    0x2f, 0xc0, 0x00, 0x00, 0x00, 0xfd, 0x00,  //.%@@@...............@@@+.
    0x3f, 0x40, 0x00, 0x00, 0x00, 0xbf, 0x00,  //.@@@+...............%@@@.
    0x7f, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00,  //+@@@.................@@@.
    0xbe, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x80,  //%@@%.................@@@%
    0xfe, 0x55, 0x00, 0x00, 0x15, 0x6f, 0xc0,  //@@@%++++.........++++%@@@
    0xff, 0xff, 0x80, 0x00, 0xff, 0xff, 0xc0,  //@@@@@@@@%.......@@@@@@@@@
    0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 0xc0,  //@@@@@@@@@......+@@@@@@@@@
    0xff, 0xff, 0xe0, 0x03, 0xff, 0xff, 0xc0,  //@@@@@@@@@%.....@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f021 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x6f, 0xfe, 0x40, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x0b, 0xff, 0xff, 0xf4, 0x03, 0x80,  //......%@@@@@@@@@@@+....@%
    0x00, 0x3f, 0xff, 0xff, 0xff, 0x0f, 0xc0,  //.....@@@@@@@@@@@@@@@..@@@
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //....@@@@@@@@@@@@@@@@@@@@@
    0x03, 0xff, 0xe4, 0x06, 0xff, 0xff, 0xc0,  //...@@@@@@%+...+%@@@@@@@@@
    0x0f, 0xff, 0x00, 0x00, 0x3f, 0xff, 0xc0,  //..@@@@@@.........%@@@@@@@
    0x1f, 0xf8, 0x00, 0x00, 0x0f, 0xff, 0xc0,  //.+@@@@%...........@@@@@@@
    0x3f, 0xf0, 0x00, 0x00, 0x3f, 0xff, 0xc0,  //.@@@@@...........@@@@@@@@
    0x7f, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xc0,  //+@@@@...........@@@@@@@@@
    0xbf, 0x80, 0x00, 0x00, 0xff, 0xff, 0xc0,  //%@@@%...........@@@@@@@@@
    0x15, 0x00, 0x00, 0x00, 0x15, 0x55, 0x00,  //.+++.............+++++++.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x15, 0x55, 0x40, 0x00, 0x00, 0x15, 0x00,  //.++++++++............+++.
    0xff, 0xff, 0xd0, 0x00, 0x00, 0xff, 0x40,  //@@@@@@@@@+..........@@@@+
    0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0x00,  //@@@@@@@@@...........@@@@.
    0xff, 0xff, 0x00, 0x00, 0x03, 0xff, 0x00,  //@@@@@@@@...........@@@@@.
    0xff, 0xfc, 0x00, 0x00, 0x0b, 0xfd, 0x00,  //@@@@@@@...........%@@@@+.
    0xff, 0xff, 0x00, 0x00, 0x3f, 0xf8, 0x00,  //@@@@@@@@.........@@@@@%..
    0xff, 0xff, 0xe4, 0x06, 0xff, 0xf0, 0x00,  //@@@@@@@@@%+...+%@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //@@@@@@@@@@@@@@@@@@@@@....
    0xfc, 0x3f, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..@@@@@@@@@@@@@@@.....
    0xf0, 0x0b, 0xff, 0xff, 0xf4, 0x00, 0x00,  //@@....%@@@@@@@@@@@+......
    0x00, 0x00, 0x6f, 0xfe, 0x40, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f026 () , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x07, 0x00,  //..........+@.
    0x00, 0x00, 0x2f, 0x40,  //.........%@@+
    0x00, 0x00, 0xbf, 0x40,  //........%@@@+
    0x00, 0x02, 0xff, 0x40,  //.......%@@@@+
    0x00, 0x0b, 0xff, 0x40,  //......%@@@@@+
    0x15, 0x6f, 0xff, 0x40,  //.++++%@@@@@@+
    0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@+
    0xbf, 0xff, 0xff, 0x40,  //%@@@@@@@@@@@+
    0x00, 0x1f, 0xff, 0x40,  //......@@@@@@+
    0x00, 0x07, 0xff, 0x40,  //.......@@@@@+
    0x00, 0x01, 0xff, 0x40,  //........@@@@+
    0x00, 0x00, 0x3f, 0x40,  //.........@@@+
    0x00, 0x00, 0x0f, 0x40,  //..........@@+
    0x00, 0x00, 0x02, 0x00,  //...........%.
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+f027 () , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x07, 0x00, 0x00,  //..........+@.......
    0x00, 0x00, 0x2f, 0x40, 0x00,  //.........%@@+......
    0x00, 0x00, 0xbf, 0x40, 0x00,  //........%@@@+......
    0x00, 0x02, 0xff, 0x40, 0x00,  //.......%@@@@+......
    0x00, 0x0b, 0xff, 0x40, 0x00,  //......%@@@@@+......
    0x15, 0x6f, 0xff, 0x40, 0x00,  //.++++%@@@@@@+......
    0xff, 0xff, 0xff, 0x43, 0xd0,  //@@@@@@@@@@@@+..@@+.
    0xff, 0xff, 0xff, 0x43, 0xf0,  //@@@@@@@@@@@@+..@@@.
    0xff, 0xff, 0xff, 0x40, 0xb8,  //@@@@@@@@@@@@+...%@%
    0xff, 0xff, 0xff, 0x40, 0x3c,  //@@@@@@@@@@@@+....@@
    0xff, 0xff, 0xff, 0x40, 0x3c,  //@@@@@@@@@@@@+....@@
    0xff, 0xff, 0xff, 0x40, 0xf8,  //@@@@@@@@@@@@+...@@%
    0xff, 0xff, 0xff, 0x43, 0xf0,  //@@@@@@@@@@@@+..@@@.
    0xbf, 0xff, 0xff, 0x42, 0x80,  //%@@@@@@@@@@@+..%%..
    0x00, 0x1f, 0xff, 0x40, 0x00,  //......@@@@@@+......
    0x00, 0x07, 0xff, 0x40, 0x00,  //.......@@@@@+......
    0x00, 0x01, 0xff, 0x40, 0x00,  //........@@@@+......
    0x00, 0x00, 0x3f, 0x40, 0x00,  //.........@@@+......
    0x00, 0x00, 0x0f, 0x40, 0x00,  //..........@@+......
    0x00, 0x00, 0x02, 0x00, 0x00,  //...........%.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f028 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x07, 0x40, 0x00,  //..................+@+......
    0x00, 0x00, 0x01, 0x00, 0x07, 0xf0, 0x00,  //...........+......+@@@.....
    0x00, 0x00, 0x0f, 0x40, 0x01, 0xfd, 0x00,  //..........@@+......+@@@....
    0x00, 0x00, 0x3f, 0x40, 0x00, 0x2f, 0x00,  //.........@@@+........%@@...
    0x00, 0x00, 0xff, 0x40, 0x3d, 0x0b, 0xc0,  //........@@@@+....@@+..%@@..
    0x00, 0x03, 0xff, 0x40, 0x3f, 0x43, 0xd0,  //.......@@@@@+....@@@+..@@+.
    0x00, 0x0f, 0xff, 0x40, 0x0b, 0xd1, 0xf0,  //......@@@@@@+.....%@@+.+@@.
    0x6a, 0xbf, 0xff, 0x41, 0x02, 0xf0, 0xf4,  //+%%%%@@@@@@@+......%@@..@@+
    0xff, 0xff, 0xff, 0x43, 0xe0, 0xf4, 0xb8,  //@@@@@@@@@@@@+..@@%..@@+.%@%
    0xff, 0xff, 0xff, 0x42, 0xf4, 0x78, 0x7c,  //@@@@@@@@@@@@+..%@@+.+@%.+@@
    0xff, 0xff, 0xff, 0x40, 0x7c, 0x3c, 0x3c,  //@@@@@@@@@@@@+...+@@..@@..@@
    0xff, 0xff, 0xff, 0x40, 0x3c, 0x3c, 0x3c,  //@@@@@@@@@@@@+....@@..@@..@@
    0xff, 0xff, 0xff, 0x40, 0x7c, 0x3c, 0x3c,  //@@@@@@@@@@@@+...+@@..@@..@@
    0xff, 0xff, 0xff, 0x42, 0xf4, 0x78, 0x7c,  //@@@@@@@@@@@@+..%@@+.+@%.+@@
    0xff, 0xff, 0xff, 0x43, 0xe0, 0xf4, 0xb8,  //@@@@@@@@@@@@+..@@%..@@+.+@%
    0x6a, 0xbf, 0xff, 0x41, 0x02, 0xf0, 0xf4,  //+%%%%@@@@@@@+..+...%@@..@@+
    0x00, 0x0f, 0xff, 0x40, 0x0b, 0xd1, 0xf0,  //......@@@@@@+.....%@@+.+@@.
    0x00, 0x03, 0xff, 0x40, 0x3f, 0x43, 0xd0,  //.......@@@@@+....@@@+..@@+.
    0x00, 0x00, 0xff, 0x40, 0x3d, 0x0b, 0xc0,  //........@@@@+....@@+..%@@..
    0x00, 0x00, 0x3f, 0x40, 0x00, 0x2f, 0x00,  //.........@@@+........%@@...
    0x00, 0x00, 0x0f, 0x40, 0x01, 0xfd, 0x00,  //..........@@+......+@@@+...
    0x00, 0x00, 0x01, 0x00, 0x07, 0xf0, 0x00,  //...........+......+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00,  //..................+@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f03e () , Width: 32 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,  //@@...........................@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,  //@@...........................@@.
    0xf0, 0x1f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x3c,  //@@...+@@%....................@@.
    0xf0, 0x7f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x3c,  //@@..+@@@@%...................@@.
    0xf0, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x3c,  //@@..@@@@@@...................@@.
    0xf0, 0xff, 0xf0, 0x00, 0x02, 0xc0, 0x00, 0x3c,  //@@..@@@@@@.........%@........@@.
    0xf0, 0xbf, 0xf0, 0x00, 0x0b, 0xf0, 0x00, 0x3c,  //@@..%@@@@@........%@@@.......@@.
    0xf0, 0x2f, 0xc0, 0x00, 0x3f, 0xfc, 0x00, 0x3c,  //@@...%@@@........%@@@@@......@@.
    0xf0, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x3c,  //@@..............@@@@@@@@.....@@.
    0xf0, 0x00, 0x00, 0x03, 0xff, 0xff, 0xc0, 0x3c,  //@@.............@@@@@@@@@@....@@.
    0xf0, 0x00, 0x10, 0x0f, 0xff, 0xff, 0xf0, 0x3c,  //@@.......+....@@@@@@@@@@@@...@@.
    0xf0, 0x00, 0xf4, 0x3f, 0xff, 0xff, 0xfc, 0x3c,  //@@......@@+..@@@@@@@@@@@@@@..@@.
    0xf0, 0x03, 0xfd, 0xff, 0xff, 0xff, 0xfc, 0x3c,  //@@.....@@@@+@@@@@@@@@@@@@@@..@@.
    0xf0, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3c,  //@@....@@@@@@@@@@@@@@@@@@@@@..@@.
    0xf0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3c,  //@@...@@@@@@@@@@@@@@@@@@@@@@..@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3c,  //@@..@@@@@@@@@@@@@@@@@@@@@@@..@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3c,  //@@..@@@@@@@@@@@@@@@@@@@@@@@..@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3c,  //@@..@@@@@@@@@@@@@@@@@@@@@@@..@@.
    0xf0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0x3c,  //@@..%%%%%%%%%%%%%%%%%%%%%%+..@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,  //@@...........................@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,  //@@...........................@@.
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f040 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,  //..................+......
    0x00, 0x00, 0x00, 0x00, 0x3f, 0x40, 0x00,  //.................@@@+....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xd0, 0x00,  //................@@@@@+...
    0x00, 0x00, 0x00, 0x03, 0xff, 0xf4, 0x00,  //...............@@@@@@@+..
    0x00, 0x00, 0x00, 0x03, 0xff, 0xfd, 0x00,  //...............@@@@@@@@+.
    0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0x40,  //.............@..@@@@@@@@.
    0x00, 0x00, 0x00, 0xfc, 0x3f, 0xff, 0x40,  //............@@@..@@@@@@@+
    0x00, 0x00, 0x03, 0xff, 0x0f, 0xff, 0x00,  //...........@@@@@..@@@@@@.
    0x00, 0x00, 0x0f, 0xcf, 0xc3, 0xfd, 0x00,  //..........@@@.@@@..@@@@+.
    0x00, 0x00, 0x3f, 0x3f, 0xf0, 0xf4, 0x00,  //.........@@@.@@@@@..@@+..
    0x00, 0x00, 0xfc, 0xff, 0xfc, 0x00, 0x00,  //........@@@.@@@@@@@......
    0x00, 0x03, 0xf3, 0xff, 0xff, 0x00, 0x00,  //.......@@@.@@@@@@@@@.....
    0x00, 0x0f, 0xcf, 0xff, 0xfd, 0x00, 0x00,  //......@@@.@@@@@@@@@+.....
    0x00, 0x3f, 0x3f, 0xff, 0xf4, 0x00, 0x00,  //.....@@@.@@@@@@@@@+......
    0x00, 0xfc, 0xff, 0xff, 0xd0, 0x00, 0x00,  //....@@@.@@@@@@@@@+.......
    0x03, 0xf3, 0xff, 0xff, 0x40, 0x00, 0x00,  //...@@@.@@@@@@@@@+........
    0x0f, 0xcf, 0xff, 0xfd, 0x00, 0x00, 0x00,  //..@@@.@@@@@@@@@+.........
    0x3f, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@@+..........
    0xf8, 0xbf, 0xff, 0xd0, 0x00, 0x00, 0x00,  //@@%.%@@@@@@@@+...........
    0xf0, 0x2f, 0xff, 0x40, 0x00, 0x00, 0x00,  //@@...%@@@@@@+............
    0xf0, 0x0b, 0xfd, 0x00, 0x00, 0x00, 0x00,  //@@....%@@@@+.............
    0xff, 0x03, 0xf4, 0x00, 0x00, 0x00, 0x00,  //@@@@...@@@+..............
    0xff, 0x0b, 0xd0, 0x00, 0x00, 0x00, 0x00,  //@@@@..%@@+...............
    0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@+................
    0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@+.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f048 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xbe, 0x00, 0x00, 0x01, 0x40,  //%@@%...........++
    0xff, 0x00, 0x00, 0x07, 0x80,  //@@@@..........+@%
    0xff, 0x00, 0x00, 0x1f, 0x80,  //@@@@.........+@@%
    0xff, 0x00, 0x00, 0x7f, 0x80,  //@@@@........+@@@%
    0xff, 0x00, 0x01, 0xff, 0x80,  //@@@@.......+@@@@%
    0xff, 0x00, 0x07, 0xff, 0x80,  //@@@@......+@@@@@%
    0xff, 0x00, 0x1f, 0xff, 0x80,  //@@@@.....+@@@@@@%
    0xff, 0x00, 0x7f, 0xff, 0x80,  //@@@@....+@@@@@@@%
    0xff, 0x01, 0xff, 0xff, 0x80,  //@@@@...+@@@@@@@@%
    0xff, 0x07, 0xff, 0xff, 0x80,  //@@@@..+@@@@@@@@@%
    0xff, 0x1f, 0xff, 0xff, 0x80,  //@@@@.+@@@@@@@@@@%
    0xff, 0x7f, 0xff, 0xff, 0x80,  //@@@@+@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%
    0xff, 0xbf, 0xff, 0xff, 0x80,  //@@@@%@@@@@@@@@@@%
    0xff, 0x1f, 0xff, 0xff, 0x80,  //@@@@.+@@@@@@@@@@%
    0xff, 0x07, 0xff, 0xff, 0x80,  //@@@@..+@@@@@@@@@%
    0xff, 0x01, 0xff, 0xff, 0x80,  //@@@@...+@@@@@@@@%
    0xff, 0x00, 0x7f, 0xff, 0x80,  //@@@@....+@@@@@@@%
    0xff, 0x00, 0x1f, 0xff, 0x80,  //@@@@.....+@@@@@@%
    0xff, 0x00, 0x07, 0xff, 0x80,  //@@@@......+@@@@@%
    0xff, 0x00, 0x01, 0xff, 0x80,  //@@@@.......+@@@@%
    0xff, 0x00, 0x00, 0x7f, 0x80,  //@@@@........+@@@%
    0xff, 0x00, 0x00, 0x1f, 0x80,  //@@@@.........+@@%
    0xff, 0x00, 0x00, 0x07, 0x80,  //@@@@..........+@%
    0xbf, 0x00, 0x00, 0x01, 0x80,  //%@@@...........+%
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f04b () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+.....................
    0xfd, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+...................
    0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //@@@@@..................
    0xff, 0xf8, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%................
    0xff, 0xff, 0x80, 0x00, 0x00, 0x00,  //@@@@@@@@%..............
    0xff, 0xff, 0xf4, 0x00, 0x00, 0x00,  //@@@@@@@@@@+............
    0xff, 0xff, 0xff, 0x40, 0x00, 0x00,  //@@@@@@@@@@@@+..........
    0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //@@@@@@@@@@@@@@.........
    0xff, 0xff, 0xff, 0xfe, 0x00, 0x00,  //@@@@@@@@@@@@@@@%.......
    0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //@@@@@@@@@@@@@@@@@%.....
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@@@@@@@@@+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xf4, 0x00,  //@@@@@@@@@@@@@@@@@@+....
    0xff, 0xff, 0xff, 0xff, 0x40, 0x00,  //@@@@@@@@@@@@@@@@+......
    0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //@@@@@@@@@@@@@@%........
    0xff, 0xff, 0xff, 0x80, 0x00, 0x00,  //@@@@@@@@@@@@%..........
    0xff, 0xff, 0xf8, 0x00, 0x00, 0x00,  //@@@@@@@@@@%............
    0xff, 0xff, 0xd0, 0x00, 0x00, 0x00,  //@@@@@@@@@+.............
    0xff, 0xfd, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@+...............
    0xff, 0xe0, 0x00, 0x00, 0x00, 0x00,  //@@@@@%.................
    0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%...................
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f04c () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0xbf, 0xff, 0xf0, 0x03, 0xff, 0xff, 0x80,  //%@@@@@@@@@.....@@@@@@@@@%
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xf4, 0x07, 0xff, 0xff, 0xc0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xbf, 0xff, 0xf0, 0x03, 0xff, 0xff, 0x80,  //%@@@@@@@@@.....@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f04d () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //%@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f051 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x40, 0x00, 0x00, 0xbe, 0x00,  //+...........%@@%.
    0xd0, 0x00, 0x00, 0xff, 0x00,  //@+..........@@@@.
    0xf4, 0x00, 0x00, 0xff, 0x00,  //@@+.........@@@@.
    0xfd, 0x00, 0x00, 0xff, 0x00,  //@@@+........@@@@.
    0xff, 0x40, 0x00, 0xff, 0x00,  //@@@@+.......@@@@.
    0xff, 0xd0, 0x00, 0xff, 0x00,  //@@@@@+......@@@@.
    0xff, 0xf4, 0x00, 0xff, 0x00,  //@@@@@@+.....@@@@.
    0xff, 0xfd, 0x00, 0xff, 0x00,  //@@@@@@@+....@@@@.
    0xff, 0xff, 0x40, 0xff, 0x00,  //@@@@@@@@+...@@@@.
    0xff, 0xff, 0xd0, 0xff, 0x00,  //@@@@@@@@@+..@@@@.
    0xff, 0xff, 0xf4, 0xff, 0x00,  //@@@@@@@@@@+.@@@@.
    0xff, 0xff, 0xfd, 0xff, 0x00,  //@@@@@@@@@@@+@@@@.
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xfe, 0xff, 0x00,  //@@@@@@@@@@@%@@@@.
    0xff, 0xff, 0xf8, 0xff, 0x00,  //@@@@@@@@@@%.@@@@.
    0xff, 0xff, 0xe0, 0xff, 0x00,  //@@@@@@@@@%..@@@@.
    0xff, 0xff, 0x80, 0xff, 0x00,  //@@@@@@@@%...@@@@.
    0xff, 0xfe, 0x00, 0xff, 0x00,  //@@@@@@@%....@@@@.
    0xff, 0xf8, 0x00, 0xff, 0x00,  //@@@@@@%.....@@@@.
    0xff, 0xe0, 0x00, 0xff, 0x00,  //@@@@@%......@@@@.
    0xff, 0x80, 0x00, 0xff, 0x00,  //@@@@%.......@@@@.
    0xfe, 0x00, 0x00, 0xff, 0x00,  //@@@%........@@@@.
    0xf8, 0x00, 0x00, 0xff, 0x00,  //@@%.........@@@@.
    0xe0, 0x00, 0x00, 0xff, 0x00,  //@%..........@@@@.
    0x80, 0x00, 0x00, 0xbf, 0x00,  //%...........%@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f052 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x01, 0xd0, 0x00, 0x00, 0x00,  //...........+@+...........
    0x00, 0x00, 0x07, 0xf4, 0x00, 0x00, 0x00,  //..........+@@@+..........
    0x00, 0x00, 0x1f, 0xfd, 0x00, 0x00, 0x00,  //.........+@@@@@+.........
    0x00, 0x00, 0x7f, 0xff, 0x40, 0x00, 0x00,  //........+@@@@@@@+........
    0x00, 0x01, 0xff, 0xff, 0xd0, 0x00, 0x00,  //.......+@@@@@@@@@+.......
    0x00, 0x07, 0xff, 0xff, 0xf4, 0x00, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x1f, 0xff, 0xff, 0xfd, 0x00, 0x00,  //.....+@@@@@@@@@@@@@+.....
    0x00, 0x7f, 0xff, 0xff, 0xff, 0x40, 0x00,  //....+@@@@@@@@@@@@@@@+....
    0x01, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //...+@@@@@@@@@@@@@@@@@+...
    0x07, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00,  //..+@@@@@@@@@@@@@@@@@@@+..
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@+.
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //+@@@@@@@@@@@@@@@@@@@@@@@+
    0x6a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,  //+%%%%%%%%%%%%%%%%%%%%%%%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f053 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x78, 0x00,  //............+@%...
    0x00, 0x00, 0x01, 0xfe, 0x00,  //...........+@@@%..
    0x00, 0x00, 0x07, 0xff, 0x80,  //..........+@@@@@%.
    0x00, 0x00, 0x1f, 0xff, 0xc0,  //.........+@@@@@@@.
    0x00, 0x00, 0x7f, 0xff, 0xc0,  //........+@@@@@@@@.
    0x00, 0x01, 0xff, 0xff, 0x00,  //.......+@@@@@@@@..
    0x00, 0x07, 0xff, 0xfc, 0x00,  //......+@@@@@@@@...
    0x00, 0x1f, 0xff, 0xf0, 0x00,  //.....+@@@@@@@@....
    0x00, 0x7f, 0xff, 0xc0, 0x00,  //....+@@@@@@@@.....
    0x01, 0xff, 0xff, 0x00, 0x00,  //...+@@@@@@@@......
    0x07, 0xff, 0xfc, 0x00, 0x00,  //..+@@@@@@@@.......
    0x1f, 0xff, 0xf0, 0x00, 0x00,  //.+@@@@@@@@........
    0x7f, 0xff, 0xc0, 0x00, 0x00,  //+@@@@@@@@.........
    0x7f, 0xff, 0xc0, 0x00, 0x00,  //+@@@@@@@@.........
    0x1f, 0xff, 0xf0, 0x00, 0x00,  //.+@@@@@@@@........
    0x07, 0xff, 0xfc, 0x00, 0x00,  //..+@@@@@@@@.......
    0x01, 0xff, 0xff, 0x00, 0x00,  //...+@@@@@@@@......
    0x00, 0x7f, 0xff, 0xc0, 0x00,  //....+@@@@@@@@.....
    0x00, 0x1f, 0xff, 0xf0, 0x00,  //.....+@@@@@@@@....
    0x00, 0x07, 0xff, 0xfc, 0x00,  //......+@@@@@@@@...
    0x00, 0x01, 0xff, 0xff, 0x00,  //.......+@@@@@@@@..
    0x00, 0x00, 0x7f, 0xff, 0xc0,  //........+@@@@@@@@.
    0x00, 0x00, 0x1f, 0xff, 0xc0,  //.........+@@@@@@@.
    0x00, 0x00, 0x07, 0xff, 0x40,  //..........+@@@@@+.
    0x00, 0x00, 0x01, 0xfd, 0x00,  //...........+@@@+..
    0x00, 0x00, 0x00, 0x74, 0x00,  //............+@+...
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f054 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x03, 0xc0, 0x00, 0x00, 0x00,  //...@@.............
    0x0f, 0xf0, 0x00, 0x00, 0x00,  //..@@@@............
    0x3f, 0xfc, 0x00, 0x00, 0x00,  //.@@@@@@...........
    0x7f, 0xff, 0x00, 0x00, 0x00,  //+@@@@@@@..........
    0x3f, 0xff, 0xc0, 0x00, 0x00,  //.@@@@@@@@.........
    0x0f, 0xff, 0xf0, 0x00, 0x00,  //..@@@@@@@@........
    0x03, 0xff, 0xfc, 0x00, 0x00,  //...@@@@@@@@.......
    0x00, 0xff, 0xff, 0x00, 0x00,  //....@@@@@@@@......
    0x00, 0x3f, 0xff, 0xc0, 0x00,  //.....@@@@@@@@.....
    0x00, 0x0f, 0xff, 0xf0, 0x00,  //......@@@@@@@@....
    0x00, 0x03, 0xff, 0xfc, 0x00,  //.......@@@@@@@@...
    0x00, 0x00, 0xff, 0xff, 0x00,  //........@@@@@@@@..
    0x00, 0x00, 0x3f, 0xff, 0xc0,  //.........@@@@@@@@.
    0x00, 0x00, 0x3f, 0xff, 0xc0,  //.........@@@@@@@@.
    0x00, 0x00, 0xff, 0xff, 0x00,  //........@@@@@@@@..
    0x00, 0x03, 0xff, 0xfc, 0x00,  //.......@@@@@@@@...
    0x00, 0x0f, 0xff, 0xf0, 0x00,  //......@@@@@@@@....
    0x00, 0x3f, 0xff, 0xc0, 0x00,  //.....@@@@@@@@.....
    0x00, 0xff, 0xff, 0x00, 0x00,  //....@@@@@@@@......
    0x03, 0xff, 0xfc, 0x00, 0x00,  //...@@@@@@@@.......
    0x0f, 0xff, 0xf0, 0x00, 0x00,  //..@@@@@@@@........
    0x3f, 0xff, 0xc0, 0x00, 0x00,  //.@@@@@@@@.........
    0x7f, 0xff, 0x00, 0x00, 0x00,  //+@@@@@@@..........
    0x2f, 0xfc, 0x00, 0x00, 0x00,  //.%@@@@@...........
    0x0b, 0xf0, 0x00, 0x00, 0x00,  //..%@@@............
    0x02, 0xc0, 0x00, 0x00, 0x00,  //...%@.............
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f067 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x2f, 0xe0, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00,  //........%@@@@@+........
    0x15, 0x55, 0xff, 0xf9, 0x55, 0x50,  //.+++++++@@@@@@%+++++++.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@%
    0x6a, 0xaa, 0xff, 0xfe, 0xaa, 0xa0,  //+%%%%%%%@@@@@@@%%%%%%%.
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x7f, 0xf0, 0x00, 0x00,  //........+@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f068 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xf4,  //%@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@%
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xf4,  //+@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f071 () , Width: 29 */
    0x00, 0x00, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x00,  //.............%@%.............
    0x00, 0x00, 0x00, 0xbf, 0x80, 0x00, 0x00, 0x00,  //............%@@@%............
    0x00, 0x00, 0x00, 0xff, 0xc0, 0x00, 0x00, 0x00,  //............@@@@@............
    0x00, 0x00, 0x02, 0xff, 0xe0, 0x00, 0x00, 0x00,  //...........%@@@@@%...........
    0x00, 0x00, 0x03, 0xff, 0xf0, 0x00, 0x00, 0x00,  //...........@@@@@@@...........
    0x00, 0x00, 0x0b, 0xff, 0xf8, 0x00, 0x00, 0x00,  //..........%@@@@@@@%..........
    0x00, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00,  //..........@@@@@@@@@..........
    0x00, 0x00, 0x3f, 0xff, 0xff, 0x00, 0x00, 0x00,  //.........@@@@@@@@@@@.........
    0x00, 0x00, 0x7f, 0x55, 0x7f, 0x40, 0x00, 0x00,  //........+@@@+++++@@@+........
    0x00, 0x00, 0xff, 0x00, 0x3f, 0xc0, 0x00, 0x00,  //........@@@@.....@@@@........
    0x00, 0x01, 0xff, 0x00, 0x3f, 0xd0, 0x00, 0x00,  //.......+@@@@.....@@@@+.......
    0x00, 0x03, 0xff, 0x40, 0x7f, 0xf0, 0x00, 0x00,  //.......@@@@@+...+@@@@@.......
    0x00, 0x07, 0xff, 0x40, 0x7f, 0xf4, 0x00, 0x00,  //......+@@@@@+...+@@@@@+......
    0x00, 0x0f, 0xff, 0x40, 0x7f, 0xfc, 0x00, 0x00,  //......@@@@@@+...+@@@@@@......
    0x00, 0x2f, 0xff, 0x40, 0x7f, 0xfe, 0x00, 0x00,  //.....%@@@@@@+...+@@@@@@%.....
    0x00, 0x3f, 0xff, 0x40, 0x7f, 0xff, 0x00, 0x00,  //.....@@@@@@@+...+@@@@@@@.....
    0x00, 0xbf, 0xff, 0x80, 0xbf, 0xff, 0x80, 0x00,  //....%@@@@@@@%...%@@@@@@@%....
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //....@@@@@@@@@@@@@@@@@@@@@....
    0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@@@@@@@@@@@@@%...
    0x07, 0xff, 0xff, 0x40, 0x7f, 0xff, 0xf4, 0x00,  //..+@@@@@@@@@+...+@@@@@@@@@+..
    0x0f, 0xff, 0xff, 0x40, 0x7f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@@+...+@@@@@@@@@@..
    0x1f, 0xff, 0xff, 0x40, 0x7f, 0xff, 0xfd, 0x00,  //.+@@@@@@@@@@+...+@@@@@@@@@@+.
    0x3f, 0xff, 0xff, 0x80, 0xbf, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@%...%@@@@@@@@@@@.
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f074 () , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x40, 0x00,  //.......................@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xd0, 0x00,  //.......................@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf4, 0x00,  //.......................@@@+..
    0xaa, 0xa4, 0x00, 0x00, 0x6a, 0xaf, 0xfd, 0x00,  //%%%%%%+.........+%%%%%@@@@@+.
    0xff, 0xff, 0x40, 0x0b, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@+.....%@@@@@@@@@@@@@+
    0xff, 0xff, 0xe0, 0x2f, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@+...%@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf4, 0xbf, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@+.%@@@@@@@@@@@@@@@.
    0x55, 0x6f, 0xf5, 0xff, 0xe5, 0x5b, 0xfc, 0x00,  //+++++%@@@@++@@@@@%++++%@@@@..
    0x00, 0x07, 0xf3, 0xff, 0x00, 0x03, 0xf0, 0x00,  //......+@@@.@@@@@.......@@@...
    0x00, 0x01, 0xd7, 0xfc, 0x00, 0x03, 0xc0, 0x00,  //.......+@++@@@@........@@....
    0x00, 0x00, 0x8f, 0xf8, 0x00, 0x03, 0x00, 0x00,  //........%.@@@@%........@.....
    0x00, 0x00, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@...............
    0x00, 0x00, 0x3f, 0xe0, 0x00, 0x00, 0x00, 0x00,  //.........@@@@%...............
    0x00, 0x00, 0x7f, 0xc0, 0x00, 0x00, 0x00, 0x00,  //........+@@@@................
    0x00, 0x00, 0xff, 0xc8, 0x00, 0x03, 0x00, 0x00,  //........@@@@@.%........@.....
    0x00, 0x01, 0xff, 0x6c, 0x00, 0x03, 0xc0, 0x00,  //.......+@@@@+%@........@@....
    0x00, 0x07, 0xff, 0x3f, 0x00, 0x03, 0xf0, 0x00,  //.......@@@@@.@@@.......@@@...
    0x55, 0x6f, 0xfc, 0xbf, 0xe5, 0x5b, 0xfc, 0x00,  //+++++%@@@@@.%@@@@%++++%@@@@..
    0xff, 0xff, 0xf4, 0xbf, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@+.%@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xe0, 0x3f, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@%...@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x40, 0x0b, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@+.....%@@@@@@@@@@@@@+
    0xbf, 0xa4, 0x00, 0x00, 0x6f, 0xff, 0xfd, 0x00,  //%@@@%%+.........+%%@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf4, 0x00,  //.......................@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xd0, 0x00,  //.......................@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x40, 0x00,  //.......................@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f077 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00,  //............@@.............
    0x00, 0x00, 0x03, 0xfc, 0x00, 0x00, 0x00,  //...........@@@@............
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //..........@@@@@@...........
    0x00, 0x00, 0x3f, 0xff, 0xc0, 0x00, 0x00,  //.........@@@@@@@@..........
    0x00, 0x00, 0xff, 0xff, 0xf0, 0x00, 0x00,  //........@@@@@@@@@@.........
    0x00, 0x03, 0xff, 0xff, 0xfc, 0x00, 0x00,  //.......@@@@@@@@@@@@........
    0x00, 0x0f, 0xff, 0xff, 0xff, 0x00, 0x00,  //......@@@@@@@@@@@@@@.......
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xc0, 0x00,  //.....@@@@@@@@@@@@@@@@......
    0x00, 0xff, 0xff, 0x4f, 0xff, 0xf0, 0x00,  //....@@@@@@@@+.@@@@@@@@.....
    0x03, 0xff, 0xfd, 0x03, 0xff, 0xfc, 0x00,  //...@@@@@@@@+...@@@@@@@@....
    0x0f, 0xff, 0xf4, 0x00, 0xff, 0xff, 0x00,  //..@@@@@@@@+.....@@@@@@@@...
    0x3f, 0xff, 0xd0, 0x00, 0x3f, 0xff, 0xc0,  //.@@@@@@@@+.......@@@@@@@@..
    0xff, 0xff, 0x40, 0x00, 0x1f, 0xff, 0xf0,  //@@@@@@@@+.........@@@@@@@@.
    0xff, 0xfd, 0x00, 0x00, 0x07, 0xff, 0xf0,  //@@@@@@@+...........@@@@@@@.
    0x3f, 0xf4, 0x00, 0x00, 0x01, 0xff, 0xc0,  //.@@@@@+.............@@@@@..
    0x0f, 0xd0, 0x00, 0x00, 0x00, 0x7f, 0x00,  //..@@@+...............@@@...
    0x02, 0x40, 0x00, 0x00, 0x00, 0x08, 0x00,  //...%+.................%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f078 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x07, 0xc0, 0x00, 0x00, 0x00, 0x2e, 0x00,  //..+@@................%@%...
    0x1f, 0xf0, 0x00, 0x00, 0x00, 0xbf, 0x80,  //.+@@@@..............%@@@%..
    0x7f, 0xfc, 0x00, 0x00, 0x02, 0xff, 0xe0,  //+@@@@@@............%@@@@@%.
    0xff, 0xff, 0x00, 0x00, 0x0b, 0xff, 0xf0,  //@@@@@@@@..........%@@@@@@@.
    0x7f, 0xff, 0xc0, 0x00, 0x2f, 0xff, 0xd0,  //+@@@@@@@@........%@@@@@@@+.
    0x1f, 0xff, 0xf0, 0x00, 0xbf, 0xff, 0x40,  //.+@@@@@@@@......%@@@@@@@+..
    0x07, 0xff, 0xfc, 0x02, 0xff, 0xfd, 0x00,  //..+@@@@@@@@....%@@@@@@@+...
    0x01, 0xff, 0xff, 0x0b, 0xff, 0xf4, 0x00,  //...+@@@@@@@@..%@@@@@@@+....
    0x00, 0x7f, 0xff, 0xef, 0xff, 0xd0, 0x00,  //....+@@@@@@@@%@@@@@@@+.....
    0x00, 0x1f, 0xff, 0xff, 0xff, 0x40, 0x00,  //.....+@@@@@@@@@@@@@@+......
    0x00, 0x07, 0xff, 0xff, 0xfd, 0x00, 0x00,  //......+@@@@@@@@@@@@+.......
    0x00, 0x01, 0xff, 0xff, 0xf4, 0x00, 0x00,  //.......+@@@@@@@@@@+........
    0x00, 0x00, 0x7f, 0xff, 0xd0, 0x00, 0x00,  //........+@@@@@@@@+.........
    0x00, 0x00, 0x1f, 0xff, 0x40, 0x00, 0x00,  //.........+@@@@@@+..........
    0x00, 0x00, 0x07, 0xfd, 0x00, 0x00, 0x00,  //..........+@@@@+...........
    0x00, 0x00, 0x01, 0xf4, 0x00, 0x00, 0x00,  //...........+@@+............
    0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00,  //............++.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f079 () , Width: 32 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x2c, 0x0b, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.....%@...%@@@@@@@@@@@@@@@@.....
    0x00, 0xbf, 0x03, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....%@@@...@@@@@@@@@@@@@@@@.....
    0x01, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xfc, 0x00,  //...+@@@@@...@@@@@@@@@@@@@@@.....
    0x03, 0xff, 0xe0, 0x7f, 0xff, 0xff, 0xfc, 0x00,  //...@@@@@@%..+@@@@@@@@@@@@@@.....
    0x0f, 0xff, 0xf4, 0x00, 0x00, 0x07, 0xfc, 0x00,  //..@@@@@@@@+...........+@@@@.....
    0x3f, 0xff, 0xfd, 0x00, 0x00, 0x03, 0xfc, 0x00,  //.@@@@@@@@@@+...........@@@@.....
    0xbf, 0xff, 0xff, 0x00, 0x00, 0x03, 0xfc, 0x00,  //%@@@@@@@@@@@...........@@@@.....
    0xff, 0xff, 0xff, 0x40, 0x00, 0x03, 0xfc, 0x00,  //@@@@@@@@@@@@+..........@@@@.....
    0x15, 0xff, 0x54, 0x00, 0x00, 0x03, 0xfc, 0x00,  //.+++@@@@+++............@@@@.....
    0x00, 0xff, 0x40, 0x00, 0x00, 0x03, 0xfc, 0x00,  //....@@@@+..............@@@@.....
    0x00, 0xff, 0x40, 0x00, 0x00, 0x57, 0xfd, 0x50,  //....@@@@+...........+++@@@@+++..
    0x00, 0xff, 0x40, 0x00, 0x07, 0xff, 0xff, 0xfc,  //....@@@@+.........+@@@@@@@@@@@@.
    0x00, 0xff, 0x40, 0x00, 0x03, 0xff, 0xff, 0xf8,  //....@@@@+..........@@@@@@@@@@@%.
    0x00, 0xff, 0x40, 0x00, 0x00, 0xff, 0xff, 0xf0,  //....@@@@+...........@@@@@@@@@@..
    0x00, 0xff, 0x40, 0x00, 0x00, 0x7f, 0xff, 0xc0,  //....@@@@+...........+@@@@@@@@...
    0x00, 0xff, 0xff, 0xff, 0xf4, 0x2f, 0xff, 0x40,  //....@@@@@@@@@@@@@@+..%@@@@@@+...
    0x00, 0xff, 0xff, 0xff, 0xfc, 0x0b, 0xfd, 0x00,  //....@@@@@@@@@@@@@@@...%@@@@+....
    0x00, 0xff, 0xff, 0xff, 0xff, 0x03, 0xf8, 0x00,  //....@@@@@@@@@@@@@@@@...@@@%.....
    0x00, 0xff, 0xff, 0xff, 0xff, 0x80, 0xe0, 0x00,  //....@@@@@@@@@@@@@@@@%...@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f07b () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x0b, 0xff, 0xe4, 0x00, 0x00, 0x00, 0x00,  //..%@@@@@@%+................
    0x3f, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@%...............
    0xbf, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@...............
    0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@+..............
    0xff, 0xff, 0xff, 0xea, 0xaa, 0xaa, 0x40,  //@@@@@@@@@@@@@%%%%%%%%%%%+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //+@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //.+@@@@@@@@@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f093 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,  //.............%.............
    0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00,  //............@@@............
    0x00, 0x00, 0x03, 0xff, 0x00, 0x00, 0x00,  //...........@@@@@...........
    0x00, 0x00, 0x0f, 0xff, 0xc0, 0x00, 0x00,  //..........@@@@@@@..........
    0x00, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x00,  //.........@@@@@@@@@.........
    0x00, 0x00, 0xff, 0xff, 0xfc, 0x00, 0x00,  //........@@@@@@@@@@@........
    0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x00,  //.......@@@@@@@@@@@@@.......
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xc0, 0x00,  //......@@@@@@@@@@@@@@@......
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.....%@@@@@@@@@@@@@@@%.....
    0x00, 0x0a, 0xaf, 0xff, 0xea, 0x80, 0x00,  //......%%%%@@@@@@@%%%%......
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x07, 0xff, 0x40, 0x00, 0x00,  //..........+@@@@@...........
    0xbf, 0xff, 0xc0, 0x00, 0x0f, 0xff, 0xf8,  //%@@@@@@@@.........@@@@@@@@%
    0xff, 0xff, 0xf4, 0x00, 0x7f, 0xff, 0xfc,  //@@@@@@@@@@+.....+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x7c, 0x7c,  //@@@@@@@@@@@@@@@@@@@.+@@.+@@
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x7c, 0x7c,  //@@@@@@@@@@@@@@@@@@@.+@@.+@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //%@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f095 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x02, 0x90, 0x00, 0x00, 0x00, 0x00,  //...%%+.................
    0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.+@@@@.................
    0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.@@@@@%................
    0xbf, 0xfc, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@................
    0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@%...............
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@...............
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@%...............
    0xbf, 0xf8, 0x00, 0x00, 0x00, 0x00,  //%@@@@@%................
    0x7f, 0xe0, 0x00, 0x00, 0x00, 0x00,  //+@@@@%.................
    0x3f, 0xe0, 0x00, 0x00, 0x00, 0x00,  //.@@@@+.................
    0x2f, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.%@@@@.................
    0x0f, 0xf8, 0x00, 0x00, 0x00, 0x00,  //..@@@@%................
    0x0b, 0xfd, 0x00, 0x00, 0x00, 0x00,  //..%@@@@+...............
    0x03, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@@@...............
    0x01, 0xff, 0xc0, 0x00, 0x00, 0x00,  //...+@@@@@..............
    0x00, 0x7f, 0xf4, 0x00, 0xf8, 0x00,  //....+@@@@@+.....%@%....
    0x00, 0x2f, 0xfe, 0x02, 0xff, 0x80,  //.....%@@@@@%...%@@@@%..
    0x00, 0x0b, 0xff, 0xeb, 0xff, 0xf4,  //......%@@@@@@+%@@@@@@@+
    0x00, 0x01, 0xff, 0xff, 0xff, 0xf8,  //.......+@@@@@@@@@@@@@@%
    0x00, 0x00, 0x7f, 0xff, 0xff, 0xf8,  //........+@@@@@@@@@@@@@%
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xf0,  //..........%@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0xbf, 0xff, 0xd0,  //............%@@@@@@@@+.
    0x00, 0x00, 0x00, 0x06, 0xfe, 0x00,  //..............+%@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f0c4 () , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x05, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..++%++......................
    0x3f, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@+....................
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x10, 0x00,  //@@@@@@@@@@...............+...
    0xfd, 0x06, 0xfc, 0x00, 0x00, 0x02, 0xee, 0x00,  //@@@+..+%@@@............%@%@%.
    0xf8, 0x00, 0x7e, 0x00, 0x00, 0x2e, 0x03, 0x40,  //@@%.....+@@%.........%@%...@+
    0xfc, 0x00, 0x1f, 0x00, 0x01, 0xe0, 0x0b, 0x00,  //@@@......+@@.......+@%....%@.
    0xfe, 0x00, 0x0f, 0x00, 0x1e, 0x00, 0x38, 0x00,  //@@@%......@@.....+@%.....@%..
    0x7f, 0xd0, 0x2f, 0x01, 0xf4, 0x01, 0xd0, 0x00,  //+@@@@+...%@@....@@+....+@+...
    0x1f, 0xff, 0xfe, 0xdb, 0x40, 0x0b, 0x00, 0x00,  //.+@@@@@@@@@%@+%@+.....%@.....
    0x02, 0xff, 0xfc, 0xb8, 0x00, 0x28, 0x00, 0x00,  //...%@@@@@@@.%@+......%%......
    0x00, 0x1a, 0x4f, 0xc0, 0x00, 0xe0, 0x00, 0x00,  //.....+%%+.@@@.......@%.......
    0x00, 0x00, 0x02, 0xcf, 0x07, 0x40, 0x00, 0x00,  //...........%@.@@..+@+........
    0x00, 0x00, 0x07, 0x8b, 0x2f, 0x80, 0x00, 0x00,  //..........+@%.%@.%@@%........
    0x00, 0xbf, 0xed, 0x04, 0xa0, 0xb0, 0x00, 0x00,  //....%@@@@%@+..+.%%..%@.......
    0x0b, 0xff, 0xfc, 0xbf, 0x40, 0x1d, 0x00, 0x00,  //..%@@@@@@@@.%@@@+....+@+.....
    0x3f, 0xfa, 0xbf, 0x87, 0xd0, 0x03, 0x80, 0x00,  //.@@@@@%%%@@@%.+@@+.....@%....
    0xbf, 0x40, 0x1f, 0x00, 0x7d, 0x00, 0xb0, 0x00,  //%@@@+....+@@....+@@+....%@...
    0xfd, 0x00, 0x0f, 0x00, 0x07, 0x80, 0x1d, 0x00,  //@@@.......@@......+@%....+@+.
    0xf8, 0x00, 0x3e, 0x00, 0x00, 0x78, 0x03, 0x40,  //@@%......@@%........+@%....@+
    0xfc, 0x01, 0xfc, 0x00, 0x00, 0x0b, 0x8b, 0x00,  //@@@....+@@@...........%@%.%@.
    0xff, 0xaf, 0xf4, 0x00, 0x00, 0x00, 0xb4, 0x00,  //@@@@%%@@@@+.............%@+..
    0x7f, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@+...................
    0x0b, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@%+.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f0c5 () , Width: 29 */
    0x00, 0x00, 0x7f, 0xff, 0xf4, 0x00, 0x00, 0x00,  //........+@@@@@@@@@+..........
    0x00, 0x02, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00,  //.......%@@@@@@@@@@@..........
    0x00, 0x0b, 0xf0, 0x00, 0x3c, 0x00, 0x00, 0x00,  //......%@@@.......@@..........
    0x00, 0x2f, 0xf0, 0x00, 0x3c, 0x00, 0x00, 0x00,  //.....%@@@@.......@@..........
    0x00, 0xbc, 0xf0, 0x00, 0x3c, 0x00, 0x00, 0x00,  //....%@@.@@.......@@..........
    0x02, 0xf0, 0xf0, 0x00, 0x3c, 0x00, 0x00, 0x00,  //...%@@..@@.......@@..........
    0x0b, 0xc0, 0xf0, 0x00, 0x3e, 0xff, 0xff, 0x40,  //..%@@...@@.......@@%@@@@@@@@+
    0x2f, 0x00, 0xf0, 0x00, 0x3f, 0xff, 0xff, 0xc0,  //.%@@....@@.......@@@@@@@@@@@@
    0x7f, 0xff, 0xf0, 0x00, 0x3f, 0xc0, 0x03, 0xc0,  //+@@@@@@@@@.......@@@@......@@
    0xff, 0xff, 0xe0, 0x00, 0xff, 0xc0, 0x03, 0xc0,  //@@@@@@@@@%......@@@@@......@@
    0xf0, 0x00, 0x00, 0x03, 0xf3, 0xc0, 0x03, 0xc0,  //@@.............@@@.@@......@@
    0xf0, 0x00, 0x00, 0x1f, 0xc3, 0xc0, 0x03, 0xc0,  //@@...........+@@@..@@......@@
    0xf0, 0x00, 0x00, 0x7f, 0x03, 0xc0, 0x03, 0xc0,  //@@..........+@@@...@@......@@
    0xf0, 0x00, 0x01, 0xfc, 0x03, 0xc0, 0x03, 0xc0,  //@@.........+@@@....@@......@@
    0xf0, 0x00, 0x03, 0xf4, 0x03, 0xc0, 0x03, 0xc0,  //@@.........@@@+....@@......@@
    0xf0, 0x00, 0x0b, 0xff, 0xff, 0xc0, 0x03, 0xc0,  //@@........%@@@@@@@@@@......@@
    0xf0, 0x00, 0x0f, 0xff, 0xff, 0x40, 0x03, 0xc0,  //@@........@@@@@@@@@@+......@@
    0xf0, 0x00, 0x0f, 0x40, 0x00, 0x00, 0x03, 0xc0,  //@@........@@+..............@@
    0xf0, 0x00, 0x0f, 0x40, 0x00, 0x00, 0x03, 0xc0,  //@@........@@+..............@@
    0xf0, 0x00, 0x0f, 0x40, 0x00, 0x00, 0x03, 0xc0,  //@@........@@+..............@@
    0xf0, 0x00, 0x0f, 0x40, 0x00, 0x00, 0x03, 0xc0,  //@@........@@+..............@@
    0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x03, 0xc0,  //@@@@@@@@@@@@+..............@@
    0xbf, 0xff, 0xff, 0x40, 0x00, 0x00, 0x03, 0xc0,  //%@@@@@@@@@@@+..............@@
    0x00, 0x00, 0x0f, 0x40, 0x00, 0x00, 0x03, 0xc0,  //..........@@+..............@@
    0x00, 0x00, 0x0f, 0x40, 0x00, 0x00, 0x03, 0xc0,  //..........@@+..............@@
    0x00, 0x00, 0x0f, 0x40, 0x00, 0x00, 0x03, 0xc0,  //..........@@+..............@@
    0x00, 0x00, 0x0f, 0x40, 0x00, 0x00, 0x03, 0xc0,  //..........@@+..............@@
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xc0,  //..........@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0x80,  //..........+@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f0c7 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x7f, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00,  //+@@@@@@@@@@@@@@@@@+......
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@%.....
    0xf0, 0xff, 0xf4, 0x03, 0xcf, 0x80, 0x00,  //@@..@@@@@@+....@@.@@%....
    0xf0, 0xff, 0xf0, 0x03, 0xc3, 0xe0, 0x00,  //@@..@@@@@@.....@@..@@%...
    0xf0, 0xff, 0xf0, 0x03, 0xc0, 0xf8, 0x00,  //@@..@@@@@@.....@@...@@%..
    0xf0, 0xff, 0xf0, 0x03, 0xc0, 0x3e, 0x00,  //@@..@@@@@@.....@@....@@%.
    0xf0, 0xff, 0xf0, 0x03, 0xc0, 0x0f, 0x40,  //@@..@@@@@@.....@@.....@@+
    0xf0, 0xff, 0xf0, 0x03, 0xc0, 0x07, 0xc0,  //@@..@@@@@@.....@@.....+@@
    0xf0, 0xff, 0xf4, 0x03, 0xc0, 0x03, 0xc0,  //@@..@@@@@@+....@@......@@
    0xf0, 0xff, 0xff, 0xff, 0xc0, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@......@@
    0xf0, 0x7f, 0xff, 0xff, 0x40, 0x03, 0xc0,  //@@..+@@@@@@@@@@@+......@@
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@.....................@@
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@.....................@@
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@.....................@@
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@.....................@@
    0xf0, 0xbf, 0xff, 0xff, 0xff, 0x83, 0xc0,  //@@..%@@@@@@@@@@@@@@@%..@@
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xc0,  //@@..@@@@@@@@@@@@@@@@@..@@
    0xf0, 0xf0, 0x00, 0x00, 0x03, 0xc3, 0xc0,  //@@..@@.............@@..@@
    0xf0, 0xf0, 0x00, 0x00, 0x03, 0xc3, 0xc0,  //@@..@@.............@@..@@
    0xf0, 0xf0, 0x00, 0x00, 0x03, 0xc3, 0xc0,  //@@..@@.............@@..@@
    0xf0, 0xf0, 0x00, 0x00, 0x03, 0xc3, 0xc0,  //@@..@@.............@@..@@
    0xf0, 0xf0, 0x00, 0x00, 0x03, 0xc3, 0xc0,  //@@..@@.............@@..@@
    0xf0, 0xf0, 0x00, 0x00, 0x03, 0xc3, 0xc0,  //@@..@@.............@@..@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f0e7 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x02, 0xff, 0xf0, 0x00,  //...%@@@@@@.....
    0x03, 0xff, 0xf0, 0x00,  //...@@@@@@@.....
    0x03, 0xff, 0xd0, 0x00,  //...@@@@@@+.....
    0x07, 0xff, 0xc0, 0x00,  //..+@@@@@@......
    0x0b, 0xff, 0x80, 0x00,  //..%@@@@@%......
    0x0f, 0xff, 0x40, 0x00,  //..@@@@@@+......
    0x0f, 0xff, 0x00, 0x00,  //..@@@@@@.......
    0x1f, 0xfe, 0x06, 0xf4,  //.+@@@@@%..+%@@+
    0x2f, 0xfe, 0xff, 0xf0,  //.%@@@@@%@@@@@@.
    0x3f, 0xff, 0xff, 0xe0,  //.@@@@@@@@@@@@%.
    0x3f, 0xff, 0xff, 0xc0,  //.@@@@@@@@@@@@..
    0x7f, 0xff, 0xff, 0x80,  //+@@@@@@@@@@@%..
    0xbf, 0xff, 0xff, 0x40,  //%@@@@@@@@@@@+..
    0xff, 0xe6, 0xff, 0x00,  //@@@@@%+%@@@@...
    0xa4, 0x03, 0xfd, 0x00,  //%%+....@@@@+...
    0x00, 0x03, 0xfc, 0x00,  //.......@@@@....
    0x00, 0x07, 0xf4, 0x00,  //......+@@@+....
    0x00, 0x0b, 0xf0, 0x00,  //......%@@@.....
    0x00, 0x0f, 0xd0, 0x00,  //......@@@+.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x1f, 0x80, 0x00,  //.....+@@%......
    0x00, 0x2f, 0x00, 0x00,  //.....%@@.......
    0x00, 0x3e, 0x00, 0x00,  //.....@@%.......
    0x00, 0x3c, 0x00, 0x00,  //.....@@........
    0x00, 0x78, 0x00, 0x00,  //....+@%........
    0x00, 0xb0, 0x00, 0x00,  //....%@.........
    0x00, 0xa0, 0x00, 0x00,  //....%%.........
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f0f3 () , Width: 27 */
    0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00,  //............+%+............
    0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00,  //............@@@............
    0x00, 0x00, 0x01, 0xfd, 0x00, 0x00, 0x00,  //...........+@@@+...........
    0x00, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x00,  //........+@@@@@@@@@.........
    0x00, 0x01, 0xff, 0xff, 0xfd, 0x00, 0x00,  //.......+@@@@@@@@@@@+.......
    0x00, 0x07, 0xff, 0xff, 0xff, 0x40, 0x00,  //......+@@@@@@@@@@@@@+......
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xc0, 0x00,  //......@@@@@@@@@@@@@@@......
    0x00, 0x1f, 0xff, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@@@@@+.....
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.....%@@@@@@@@@@@@@@@%.....
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.....@@@@@@@@@@@@@@@@%.....
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.....@@@@@@@@@@@@@@@@@.....
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.....@@@@@@@@@@@@@@@@@.....
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.....@@@@@@@@@@@@@@@@@.....
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.....@@@@@@@@@@@@@@@@@.....
    0x00, 0x7f, 0xff, 0xff, 0xff, 0xf0, 0x00,  //....+@@@@@@@@@@@@@@@@@.....
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xf4, 0x00,  //....%@@@@@@@@@@@@@@@@@+....
    0x00, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //....@@@@@@@@@@@@@@@@@@%....
    0x00, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....@@@@@@@@@@@@@@@@@@@....
    0x02, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //...%@@@@@@@@@@@@@@@@@@@%...
    0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //..@@@@@@@@@@@@@@@@@@@@@@%..
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //.%@@@@@@@@@@@@@@@@@@@@@@@%.
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //%@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x2a, 0xff, 0xe0, 0x00, 0x00,  //.........%%%@@@@@%.........
    0x00, 0x00, 0x1d, 0xff, 0xd0, 0x00, 0x00,  //.........+@+@@@@@+.........
    0x00, 0x00, 0x0b, 0x6f, 0x80, 0x00, 0x00,  //..........%@+%@@%..........
    0x00, 0x00, 0x02, 0xfe, 0x00, 0x00, 0x00,  //...........%@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f11c () , Width: 32 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,  //@@...........................@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,  //@@...........................@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,  //@@...........................@@.
    0xf0, 0xf0, 0xf0, 0xfc, 0x3c, 0x3c, 0x3c, 0x3c,  //@@..@@..@@..@@@..@@..@@..@@..@@.
    0xf0, 0xf0, 0xf0, 0xfc, 0x3c, 0x3c, 0x3c, 0x3c,  //@@..@@..@@..@@@..@@..@@..@@..@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c,  //@@.......................@@..@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c,  //@@.......................@@..@@.
    0xf0, 0xff, 0x0f, 0x03, 0xc3, 0xc3, 0xfc, 0x3c,  //@@..@@@@..@@...@@..@@..@@@@..@@.
    0xf0, 0xff, 0x0f, 0x03, 0xc3, 0xc3, 0xfc, 0x3c,  //@@..@@@@..@@...@@..@@..@@@@..@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,  //@@...........................@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,  //@@...........................@@.
    0xf0, 0xf0, 0xff, 0xff, 0xff, 0xfc, 0x3c, 0x3c,  //@@..@@..@@@@@@@@@@@@@@@..@@..@@.
    0xf0, 0xf0, 0xff, 0xff, 0xff, 0xfc, 0x3c, 0x3c,  //@@..@@..@@@@@@@@@@@@@@@..@@..@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,  //@@...........................@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,  //@@...........................@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f124 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x24,  //.....................%+
    0x00, 0x00, 0x00, 0x00, 0x02, 0xf8,  //...................%@@%
    0x00, 0x00, 0x00, 0x00, 0x2f, 0xf4,  //.................%@@@@+
    0x00, 0x00, 0x00, 0x02, 0xff, 0xf0,  //...............%@@@@@@.
    0x00, 0x00, 0x00, 0x2f, 0xff, 0xd0,  //.............%@@@@@@@+.
    0x00, 0x00, 0x02, 0xff, 0xff, 0xc0,  //...........%@@@@@@@@@..
    0x00, 0x00, 0x2f, 0xff, 0xff, 0x40,  //.........%@@@@@@@@@@+..
    0x00, 0x02, 0xff, 0xff, 0xff, 0x00,  //.......%@@@@@@@@@@@@...
    0x00, 0x2f, 0xff, 0xff, 0xfd, 0x00,  //.....%@@@@@@@@@@@@@+...
    0x02, 0xff, 0xff, 0xff, 0xfc, 0x00,  //...%@@@@@@@@@@@@@@@....
    0x2f, 0xff, 0xff, 0xff, 0xf4, 0x00,  //.%@@@@@@@@@@@@@@@@+....
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //@@@@@@@@@@@@@@@@@@.....
    0x6a, 0xaa, 0xaf, 0xff, 0xd0, 0x00,  //+%%%%%%%%%@@@@@@@+.....
    0x00, 0x00, 0x0b, 0xff, 0xc0, 0x00,  //..........%@@@@@@......
    0x00, 0x00, 0x0b, 0xff, 0x40, 0x00,  //..........%@@@@@+......
    0x00, 0x00, 0x0b, 0xff, 0x00, 0x00,  //..........%@@@@@.......
    0x00, 0x00, 0x0b, 0xfd, 0x00, 0x00,  //..........%@@@@+.......
    0x00, 0x00, 0x0b, 0xfc, 0x00, 0x00,  //..........%@@@@........
    0x00, 0x00, 0x0b, 0xf4, 0x00, 0x00,  //..........%@@@+........
    0x00, 0x00, 0x0b, 0xf0, 0x00, 0x00,  //..........%@@@.........
    0x00, 0x00, 0x0b, 0xd0, 0x00, 0x00,  //..........%@@+.........
    0x00, 0x00, 0x0b, 0xc0, 0x00, 0x00,  //..........%@@..........
    0x00, 0x00, 0x07, 0x40, 0x00, 0x00,  //..........+@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f15b () , Width: 25 */
    0x7f, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00,  //+@@@@@@@@@@@@@+..........
    0xff, 0xff, 0xff, 0xf4, 0x60, 0x00, 0x00,  //@@@@@@@@@@@@@@+.+%.......
    0xff, 0xff, 0xff, 0xf4, 0x78, 0x00, 0x00,  //@@@@@@@@@@@@@@+.+@%......
    0xff, 0xff, 0xff, 0xf4, 0x7e, 0x00, 0x00,  //@@@@@@@@@@@@@@+.+@@%.....
    0xff, 0xff, 0xff, 0xf4, 0x7f, 0x80, 0x00,  //@@@@@@@@@@@@@@+.+@@@%....
    0xff, 0xff, 0xff, 0xf4, 0x7f, 0xe0, 0x00,  //@@@@@@@@@@@@@@+.+@@@@%...
    0xff, 0xff, 0xff, 0xf4, 0x7f, 0xf8, 0x00,  //@@@@@@@@@@@@@@+.+@@@@@%..
    0xff, 0xff, 0xff, 0xf4, 0x7f, 0xfe, 0x00,  //@@@@@@@@@@@@@@+.+@@@@@@%.
    0xff, 0xff, 0xff, 0xf4, 0x15, 0x55, 0x00,  //@@@@@@@@@@@@@@+..+++++++.
    0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@%..........
    0xff, 0xff, 0xff, 0xff, 0xaa, 0xaa, 0x80,  //@@@@@@@@@@@@@@@@%%%%%%%%%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //+@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f1eb () , Width: 32 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x06, 0xbf, 0xfe, 0x40, 0x00, 0x00,  //..........+%%@@@@@@%+...........
    0x00, 0x01, 0xbf, 0xff, 0xff, 0xfe, 0x00, 0x00,  //.......+%@@@@@@@@@@@@@@%........
    0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@%......
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@%....
    0x07, 0xff, 0xfe, 0x50, 0x06, 0xff, 0xff, 0xc0,  //..+@@@@@@@@%++....+%@@@@@@@@@...
    0x2f, 0xff, 0xd0, 0x00, 0x00, 0x0b, 0xff, 0xf4,  //.%@@@@@@@+............%@@@@@@@+.
    0xbf, 0xfd, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xfd,  //%@@@@@@+................%@@@@@@+
    0xff, 0xf0, 0x02, 0xff, 0xfe, 0x40, 0x0f, 0xfe,  //@@@@@@.....%@@@@@@@%+.....@@@@@%
    0x3f, 0x80, 0x7f, 0xff, 0xff, 0xfd, 0x03, 0xf8,  //.@@@%...+@@@@@@@@@@@@@@+...@@@%.
    0x0d, 0x07, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xa0,  //..@+..+@@@@@@@@@@@@@@@@@@...%%..
    0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@+.....
    0x00, 0x7f, 0xff, 0x90, 0x06, 0xff, 0xfc, 0x00,  //....+@@@@@@@%+....+%@@@@@@@.....
    0x00, 0x3f, 0xf4, 0x00, 0x00, 0x1f, 0xf8, 0x00,  //.....@@@@@...........+@@@@%.....
    0x00, 0x0f, 0x40, 0xbf, 0xfd, 0x02, 0xe0, 0x00,  //......@@+...%@@@@@%+...%@%......
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xe0, 0x00, 0x00,  //..........%@@@@@@@@@@+..........
    0x00, 0x00, 0x3f, 0xff, 0xff, 0xf8, 0x00, 0x00,  //.........@@@@@@@@@@@@@%.........
    0x00, 0x00, 0x3f, 0xff, 0xff, 0xf8, 0x00, 0x00,  //.........@@@@@@@@@@@@@%.........
    0x00, 0x00, 0x0f, 0xe0, 0x1b, 0xe0, 0x00, 0x00,  //..........@@@%....%@@%..........
    0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00,  //...........+........+...........
    0x00, 0x00, 0x00, 0x0b, 0xe0, 0x00, 0x00, 0x00,  //..............%@@%..............
    0x00, 0x00, 0x00, 0x2f, 0xf4, 0x00, 0x00, 0x00,  //.............%@@@@+.............
    0x00, 0x00, 0x00, 0x0f, 0xe0, 0x00, 0x00, 0x00,  //..............@@@%..............
    0x00, 0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x00,  //...............%%...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f240 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x54, 0x3c, 0x00,  //@@..+++++++++++++++++++++++++++..@@...
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3d, 0x00,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@+..
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0x40,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@@+.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3c, 0x00,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f241 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x55, 0x55, 0x55, 0x55, 0x55, 0x40, 0x00, 0x3c, 0x00,  //@@..+++++++++++++++++++++........@@...
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x3d, 0x00,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@+..
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x3f, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x3f, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x3f, 0x40,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@@+.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x3c, 0x00,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f242 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x55, 0x55, 0x55, 0x50, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@..++++++++++++++...............@@...
    0xf0, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x3d, 0x00,  //@@..@@@@@@@@@@@@@@+..............@@+..
    0xf0, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x3f, 0xc0,  //@@..@@@@@@@@@@@@@@+..............@@@@.
    0xf0, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@+................@@.
    0xf0, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@+................@@.
    0xf0, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@+................@@.
    0xf0, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@+................@@.
    0xf0, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@+................@@.
    0xf0, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@+................@@.
    0xf0, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@@@@@@@+................@@.
    0xf0, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x3f, 0xc0,  //@@..@@@@@@@@@@@@@@+..............@@@@.
    0xf0, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x3f, 0x40,  //@@..@@@@@@@@@@@@@@+..............@@@+.
    0xf0, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@..@@@@@@@@@@@@@@+..............@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f243 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@..++++++++.....................@@...
    0xf0, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x00,  //@@..@@@@@@@@+....................@@+..
    0xf0, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc0,  //@@..@@@@@@@@+....................@@@@.
    0xf0, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@+......................@@.
    0xf0, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@+......................@@.
    0xf0, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@+......................@@.
    0xf0, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@+......................@@.
    0xf0, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@+......................@@.
    0xf0, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@+......................@@.
    0xf0, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@..@@@@@@@@+......................@@.
    0xf0, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc0,  //@@..@@@@@@@@+....................@@@@.
    0xf0, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x40,  //@@..@@@@@@@@+....................@@@+.
    0xf0, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@..@@@@@@@@+....................@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f244 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x00,  //@@...............................@@+..
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x80,  //@@...............................@@@%.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@.................................@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@.................................@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@.................................@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@.................................@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@.................................@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@.................................@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@.................................@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc0,  //@@...............................@@@@.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x40,  //@@...............................@@@+.
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,  //@@...............................@@...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f293 () , Width: 22 */
    0x00, 0x06, 0xff, 0xe8, 0x00, 0x00,  //......+%@@@@@%%.......
    0x00, 0x7f, 0xff, 0xff, 0x80, 0x00,  //....+@@@@@@@@@@@%.....
    0x02, 0xff, 0xfb, 0xff, 0xf0, 0x00,  //...%@@@@@@%@@@@@@@....
    0x07, 0xff, 0xe2, 0xff, 0xfc, 0x00,  //..+@@@@@@%.%@@@@@@@...
    0x0f, 0xff, 0xe0, 0xbf, 0xfe, 0x00,  //..@@@@@@@%..%@@@@@@%..
    0x2f, 0xff, 0xe0, 0x2f, 0xff, 0x00,  //.%@@@@@@@%...%@@@@@@..
    0x3f, 0xff, 0xe0, 0x0b, 0xff, 0x40,  //.@@@@@@@@%....%@@@@@+.
    0x3f, 0xff, 0xe0, 0x42, 0xff, 0x80,  //.@@@@@@@@%..+..%@@@@%.
    0x7f, 0xcb, 0xe0, 0xd0, 0xbf, 0xc0,  //+@@@@.%@@%..@+..%@@@@.
    0xbf, 0x42, 0xe0, 0xf0, 0x3f, 0xc0,  //%@@@+..%@%..@@...@@@@.
    0xff, 0xd0, 0xa0, 0xd0, 0xbf, 0xd0,  //%@@@@+..%%..@+..%@@@@+
    0xff, 0xf4, 0x10, 0x42, 0xff, 0xd0,  //@@@@@@+..+..+..%@@@@@+
    0xff, 0xfd, 0x00, 0x0b, 0xff, 0xd0,  //@@@@@@@+......%@@@@@@+
    0xff, 0xff, 0x40, 0x2f, 0xff, 0xd0,  //@@@@@@@@+....%@@@@@@@+
    0xff, 0xff, 0xc0, 0x7f, 0xff, 0xe0,  //@@@@@@@@@...+@@@@@@@@%
    0xff, 0xff, 0x40, 0x2f, 0xff, 0xd0,  //@@@@@@@@+....%@@@@@@@+
    0xff, 0xfd, 0x00, 0x0b, 0xff, 0xd0,  //@@@@@@@+......%@@@@@@+
    0xff, 0xf4, 0x10, 0x42, 0xff, 0xd0,  //@@@@@@+..+..+..%@@@@@+
    0xff, 0xd0, 0xa0, 0xd0, 0xbf, 0xd0,  //%@@@@+..%%..@+..%@@@@+
    0xbf, 0x42, 0xe0, 0xf0, 0x3f, 0xc0,  //%@@@+..%@%..@@...@@@@.
    0x7f, 0xcb, 0xe0, 0xd0, 0xbf, 0xc0,  //+@@@@.%@@%..@+..%@@@@.
    0x3f, 0xff, 0xe0, 0x42, 0xff, 0x80,  //.@@@@@@@@%..+..%@@@@%.
    0x3f, 0xff, 0xe0, 0x0b, 0xff, 0x40,  //.@@@@@@@@%....%@@@@@+.
    0x2f, 0xff, 0xe0, 0x2f, 0xff, 0x00,  //.%@@@@@@@%...%@@@@@@..
    0x0f, 0xff, 0xe0, 0xbf, 0xfe, 0x00,  //..@@@@@@@%..%@@@@@@%..
    0x07, 0xff, 0xe2, 0xff, 0xfc, 0x00,  //..+@@@@@@%.%@@@@@@@...
    0x02, 0xff, 0xfb, 0xff, 0xf0, 0x00,  //...%@@@@@@%@@@@@@@....
    0x00, 0x7f, 0xff, 0xff, 0x80, 0x00,  //....+@@@@@@@@@@@%.....
    0x00, 0x06, 0xff, 0xf8, 0x00, 0x00,  //......+%@@@@@%%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................



#elif USE_LV_FONT_SYMBOL_30 == 4
    /*Unicode: U+f001 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x9b, 0x40,  //.....................+%%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x6a, 0xff, 0xff, 0xe0,  //..................+%@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0xcf, 0xff, 0xff, 0xff, 0xf0,  //...............+@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //...........+%@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.........%@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //........@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //........@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //........@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xf0,  //........@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x72, 0x1f, 0xf0,  //........@@@@@@@@@@@%+..@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe, 0xa5, 0x00, 0x00, 0x1f, 0xf0,  //........@@@@@@@@%+.....@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd8, 0x30, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //........@@@@@%.........@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //........@@+............@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //........@@.............@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //........@@.............@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //........@@.............@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0x00, 0x12, 0x20, 0x1f, 0xf0,  //........@@.............@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x10, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xcf, 0xf0,  //........@@......+@@@@@%@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x10, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xf0,  //........@@.....@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x10, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //........@@....+@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x10, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xd0,  //........@@.....@@@@@@@@@@
    0x04, 0xae, 0xff, 0xe9, 0xff, 0x10, 0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0x40,  //.+%@@@@%@@.....%@@@@@@@@+
    0x9f, 0xff, 0xff, 0xff, 0xff, 0x10, 0x00, 0x00, 0x39, 0xdf, 0xec, 0x71, 0x00,  //%@@@@@@@@@.......%@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@...............
    0xaf, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@+...............
    0x05, 0xbf, 0xff, 0xea, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+%@@@@%.................
    0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f008 () , Width: 32 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x10,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0x50, 0x04, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf4, 0x00, 0x4f, 0xf0,  //@@+..+@@+.............+@@+..+@@.
    0xff, 0x10, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x00, 0x0f, 0xf1,  //@@....@@...............@@....@@.
    0xff, 0x10, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x00, 0x0f, 0xf1,  //@@....@@...............@@....@@.
    0xff, 0x40, 0x03, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf3, 0x00, 0x3f, 0xf1,  //@@+...@@...............@@....@@.
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xf1,  //@@@@@@@@...............@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xf1,  //@@@@@@@@...............@@@@@@@@.
    0xff, 0x61, 0x15, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf5, 0x11, 0x5f, 0xf1,  //@@+..+@@...............@@+..+@@.
    0xff, 0x10, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x00, 0x0f, 0xf1,  //@@....@@...............@@....@@.
    0xff, 0x10, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x00, 0x0f, 0xf1,  //@@....@@...............@@....@@.
    0xff, 0x10, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x00, 0x0f, 0xf1,  //@@....@@...............@@....@@.
    0xff, 0x61, 0x15, 0xff, 0x61, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x6f, 0xf5, 0x11, 0x5f, 0xf1,  //@@+..+@@+.............+@@+..+@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0x40, 0x03, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xf3, 0x00, 0x3f, 0xf1,  //@@+...@@+.............+@@....@@.
    0xff, 0x10, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x00, 0x0f, 0xf1,  //@@....@@...............@@....@@.
    0xff, 0x10, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x00, 0x0f, 0xf1,  //@@....@@...............@@....@@.
    0xff, 0x50, 0x04, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf4, 0x00, 0x4f, 0xf1,  //@@+..+@@...............@@+..+@@.
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xf1,  //@@@@@@@@...............@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xf1,  //@@@@@@@@...............@@@@@@@@.
    0xff, 0x40, 0x03, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf3, 0x00, 0x3f, 0xf1,  //@@+...@@...............@@....@@.
    0xff, 0x10, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x00, 0x0f, 0xf1,  //@@....@@...............@@....@@.
    0xff, 0x10, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x00, 0x0f, 0xf1,  //@@....@@...............@@....@@.
    0xff, 0x40, 0x03, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xf3, 0x00, 0x3f, 0xf0,  //@@+...@@+.............+@@....@@.
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x20,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f00b () , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x7f, 0xff, 0xff, 0xfb, 0x00, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //+@@@@@@%...@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x30, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@..%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0x40, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0x40, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0x40, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xaf, 0xff, 0xff, 0xfe, 0x10, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //%@@@@@@@..+@@@@@@@@@@@@@@@@@%
    0x02, 0x33, 0x33, 0x30, 0x00, 0x01, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x02, 0x33, 0x33, 0x30, 0x00, 0x01, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x00,  //.............................
    0xaf, 0xff, 0xff, 0xfe, 0x10, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //%@@@@@@@..+@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x40, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0x40, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0x40, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0x30, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@..%@@@@@@@@@@@@@@@@@@
    0x7f, 0xff, 0xff, 0xfb, 0x00, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //+@@@@@@%...@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x02, 0x33, 0x33, 0x30, 0x00, 0x01, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x00,  //.............................
    0xaf, 0xff, 0xff, 0xfe, 0x10, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //%@@@@@@@..+@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x40, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0x40, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0x40, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0x30, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@..%@@@@@@@@@@@@@@@@@@
    0x7f, 0xff, 0xff, 0xfb, 0x00, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //+@@@@@@%...@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f00c () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00,  //.....................+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xc1, 0x00,  //...................+@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xfc, 0x10,  //..................+@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xc0,  //.................+@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xf0,  //................+@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0x70,  //...............+@@@@@@@@+
    0x00, 0x18, 0x50, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xf7, 0x00,  //...%+.........+@@@@@@@@+.
    0x02, 0xef, 0xf6, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00,  //..@@@+.......+@@@@@@@@+..
    0x2e, 0xff, 0xff, 0x60, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00,  //.@@@@@+.....+@@@@@@@@+...
    0xdf, 0xff, 0xff, 0xf6, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00,  //@@@@@@@+...+@@@@@@@@+....
    0xff, 0xff, 0xff, 0xff, 0x60, 0x5f, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00,  //@@@@@@@@+.+@@@@@@@@+.....
    0x5f, 0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00,  //+@@@@@@@@%@@@@@@@@+......
    0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@@@@@@@@@@@+.......
    0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@@@@@@@@+........
    0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@+.........
    0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@+..........
    0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@+...........
    0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@+............
    0x00, 0x00, 0x00, 0x05, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x4b, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+%+..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f00d () , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x08, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x1b, 0xe6, 0x00,  //...%@%.........%@+..
    0x00, 0x9f, 0xff, 0xa0, 0x00, 0x00, 0x01, 0xcf, 0xff, 0x60,  //..%@@@%.......@@@@+.
    0x09, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xf5,  //.%@@@@@%.....@@@@@@+
    0x2f, 0xff, 0xff, 0xff, 0xa0, 0x01, 0xcf, 0xff, 0xff, 0xfe,  //.@@@@@@@%...@@@@@@@@
    0x0e, 0xff, 0xff, 0xff, 0xfa, 0x1c, 0xff, 0xff, 0xff, 0xfc,  //.@@@@@@@@%.@@@@@@@@%
    0x03, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1,  //..@@@@@@@@@@@@@@@@@.
    0x00, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,  //...@@@@@@@@@@@@@@@..
    0x00, 0x03, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x00,  //....@@@@@@@@@@@@@...
    0x00, 0x00, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x00,  //.....@@@@@@@@@@@....
    0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00, 0x00,  //.....+@@@@@@@@@.....
    0x00, 0x00, 0x1c, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00,  //.....@@@@@@@@@@%....
    0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //....@@@@@@@@@@@@%...
    0x00, 0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00,  //...@@@@@@@@@@@@@@%..
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //..@@@@@@@@@@@@@@@@%.
    0x0c, 0xff, 0xff, 0xff, 0xfd, 0x4e, 0xff, 0xff, 0xff, 0xf9,  //.@@@@@@@@@+@@@@@@@@%
    0x2f, 0xff, 0xff, 0xff, 0xd1, 0x03, 0xef, 0xff, 0xff, 0xff,  //.@@@@@@@@...@@@@@@@@
    0x0c, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x3e, 0xff, 0xff, 0xf9,  //.@@@@@@@.....@@@@@@%
    0x00, 0xcf, 0xff, 0xd1, 0x00, 0x00, 0x03, 0xef, 0xff, 0x90,  //..@@@@@.......@@@@%.
    0x00, 0x0c, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x3e, 0xf9, 0x00,  //...@@@.........@@%..
    0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+f011 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@...........
    0x00, 0x00, 0x08, 0x93, 0x00, 0xff, 0xff, 0x20, 0x29, 0x81, 0x00, 0x00, 0x00,  //.....%%...@@@@...%%......
    0x00, 0x01, 0xdf, 0xff, 0x10, 0xff, 0xff, 0x20, 0xdf, 0xfe, 0x20, 0x00, 0x00,  //....@@@@..@@@@..@@@@.....
    0x00, 0x1d, 0xff, 0xff, 0x30, 0xff, 0xff, 0x21, 0xff, 0xff, 0xe2, 0x00, 0x00,  //...@@@@@..@@@@..@@@@@....
    0x00, 0xbf, 0xff, 0xfd, 0x00, 0xff, 0xff, 0x20, 0xbf, 0xff, 0xfd, 0x00, 0x00,  //..%@@@@@..@@@@..%@@@@@...
    0x05, 0xff, 0xff, 0xd1, 0x00, 0xff, 0xff, 0x20, 0x0c, 0xff, 0xff, 0x70, 0x00,  //.+@@@@@...@@@@...@@@@@+..
    0x0d, 0xff, 0xfe, 0x10, 0x00, 0xff, 0xff, 0x20, 0x00, 0xcf, 0xff, 0xf0, 0x00,  //.@@@@@....@@@@....@@@@@..
    0x4f, 0xff, 0xf4, 0x00, 0x00, 0xff, 0xff, 0x20, 0x00, 0x3f, 0xff, 0xf6, 0x00,  //+@@@@+....@@@@.....@@@@+.
    0x9f, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0x20, 0x00, 0x0a, 0xff, 0xfb, 0x00,  //%@@@@.....@@@@.....%@@@%.
    0xcf, 0xff, 0x70, 0x00, 0x00, 0xff, 0xff, 0x10, 0x00, 0x05, 0xff, 0xfe, 0x00,  //@@@@+.....@@@@.....+@@@@.
    0xef, 0xff, 0x40, 0x00, 0x00, 0xaf, 0xfc, 0x00, 0x00, 0x02, 0xff, 0xff, 0x10,  //@@@@+.....%@@@......@@@@.
    0xff, 0xff, 0x20, 0x00, 0x00, 0x05, 0x60, 0x00, 0x00, 0x00, 0xff, 0xff, 0x10,  //@@@@.......++.......@@@@.
    0xef, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0x00,  //@@@@................@@@@.
    0xdf, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0x00,  //@@@@+...............@@@@.
    0xaf, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xfc, 0x00,  //%@@@%..............%@@@@.
    0x5f, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xf7, 0x00,  //+@@@@..............@@@@+.
    0x0f, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xf2, 0x00,  //.@@@@%............%@@@@..
    0x08, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xa0, 0x00,  //.+@@@@+..........+@@@@%..
    0x00, 0xef, 0xff, 0xf9, 0x10, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0x20, 0x00,  //..@@@@@%........%@@@@@...
    0x00, 0x3f, 0xff, 0xff, 0xe8, 0x42, 0x13, 0x8e, 0xff, 0xff, 0xf5, 0x00, 0x00,  //...@@@@@@%+...%@@@@@@+...
    0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@+....
    0x00, 0x00, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@@@@+.....
    0x00, 0x00, 0x01, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x20, 0x00, 0x00, 0x00,  //......%@@@@@@@@@@%.......
    0x00, 0x00, 0x00, 0x01, 0x7c, 0xef, 0xfe, 0xc7, 0x20, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f013 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@..........
    0x00, 0x00, 0x3b, 0x30, 0x04, 0xff, 0xff, 0xf3, 0x00, 0x3b, 0x30, 0x00, 0x00,  //.....%...+@@@@@....%.....
    0x00, 0x04, 0xff, 0xf6, 0x1a, 0xff, 0xff, 0xf9, 0x16, 0xff, 0xe3, 0x00, 0x00,  //...+@@@+.%@@@@@%.+@@@....
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00,  //...@@@@@@@@@@@@@@@@@@@...
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00,  //...@@@@@@@@@@@@@@@@@@@...
    0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@+...
    0x00, 0x01, 0xff, 0xff, 0xff, 0xc6, 0x46, 0xcf, 0xff, 0xff, 0xf1, 0x00, 0x00,  //....@@@@@@@+++@@@@@@@....
    0x01, 0x4a, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x09, 0xff, 0xff, 0xf9, 0x30, 0x00,  //...%@@@@@%.....%@@@@@%...
    0xdf, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@.......@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@+.......+@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@+.......+@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@+.......+@@@@@@@@
    0xdf, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@.......@@@@@@@@@
    0x01, 0x3a, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x08, 0xff, 0xff, 0xfa, 0x42, 0x00,  //...%@@@@@%.....%@@@@@%+..
    0x00, 0x01, 0xff, 0xff, 0xff, 0xb5, 0x35, 0xbf, 0xff, 0xff, 0xf2, 0x00, 0x00,  //....@@@@@@%+.+%@@@@@@....
    0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@+...
    0x00, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00,  //...@@@@@@@@@@@@@@@@@@@...
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00,  //..%@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00,  //...@@@@@@@@@@@@@@@@@@@...
    0x00, 0x04, 0xff, 0xf7, 0x2a, 0xff, 0xff, 0xfa, 0x27, 0xff, 0xf5, 0x00, 0x00,  //...+@@@+.%@@@@@%.+@@@+...
    0x00, 0x00, 0x3c, 0x40, 0x03, 0xff, 0xff, 0xf4, 0x00, 0x4c, 0x40, 0x00, 0x00,  //.....@....@@@@@+..+@+....
    0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f014 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xe5, 0x00, 0x00, 0x00, 0x00,  //.......%@@@@@@@+.......
    0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00,  //......+@@@@@@@@@.......
    0x00, 0x00, 0x00, 0xdf, 0x70, 0x00, 0x00, 0xaf, 0x90, 0x00, 0x00, 0x00,  //......@@+.....%@%......
    0x00, 0x00, 0x04, 0xfe, 0x00, 0x00, 0x00, 0x3f, 0xf1, 0x00, 0x00, 0x00,  //.....+@@.......@@......
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0xef, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xb0, 0x00,  //..@@..............+@%..
    0x00, 0xef, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xb0, 0x00,  //..@@..............+@%..
    0x00, 0xef, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xb0, 0x00,  //..@@..............+@%..
    0x00, 0xef, 0x20, 0x35, 0x00, 0x25, 0x10, 0x15, 0x10, 0x5f, 0xb0, 0x00,  //..@@...+...+...+..+@%..
    0x00, 0xef, 0x20, 0xcf, 0x40, 0xaf, 0x60, 0x7f, 0x80, 0x5f, 0xb0, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0xef, 0x20, 0xcf, 0x40, 0xaf, 0x60, 0x7f, 0x80, 0x5f, 0xb0, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0xef, 0x20, 0xcf, 0x40, 0xaf, 0x60, 0x7f, 0x80, 0x5f, 0xb0, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0xef, 0x20, 0xcf, 0x40, 0xaf, 0x60, 0x7f, 0x80, 0x5f, 0xb0, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0xef, 0x20, 0xcf, 0x40, 0xaf, 0x60, 0x7f, 0x80, 0x5f, 0xb0, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0xef, 0x20, 0xcf, 0x40, 0xaf, 0x60, 0x7f, 0x80, 0x5f, 0xb0, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0xef, 0x20, 0xcf, 0x40, 0xaf, 0x60, 0x7f, 0x80, 0x5f, 0xb0, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0xef, 0x20, 0xcf, 0x40, 0xaf, 0x60, 0x7f, 0x80, 0x5f, 0xb0, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0xef, 0x20, 0xcf, 0x40, 0xaf, 0x60, 0x7f, 0x80, 0x5f, 0xb0, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0xef, 0x20, 0xbf, 0x30, 0x9f, 0x50, 0x6f, 0x70, 0x5f, 0xb0, 0x00,  //..@@..%@..%@+.+@+.+@%..
    0x00, 0xef, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xb0, 0x00,  //..@@..............+@%..
    0x00, 0xef, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xb0, 0x00,  //..@@..............+@%..
    0x00, 0xcf, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0x90, 0x00,  //..@@+.............%@%..
    0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x00,  //..+@@@@@@@@@@@@@@@@@...
    0x00, 0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f015 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0x70, 0x00, 0x0a, 0xbb, 0xa0, 0x00, 0x00,  //............+%+....%%%%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xfb, 0x10, 0x2f, 0xff, 0xf0, 0x00, 0x00,  //...........%@@@%...@@@@....
    0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xff, 0xd2, 0x2f, 0xff, 0xf0, 0x00, 0x00,  //..........@@@@@@@..@@@@....
    0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xc3, 0xcf, 0xff, 0x7f, 0xff, 0xf0, 0x00, 0x00,  //.........@@@@.@@@@+@@@@....
    0x00, 0x00, 0x00, 0x06, 0xff, 0xfa, 0x05, 0x0a, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //.......+@@@%.+.%@@@@@@@....
    0x00, 0x00, 0x00, 0x8f, 0xff, 0x81, 0xbf, 0xb1, 0x7f, 0xff, 0xff, 0xf0, 0x00, 0x00,  //......%@@@+.%@%.+@@@@@@....
    0x00, 0x00, 0x0b, 0xff, 0xf5, 0x2d, 0xff, 0xfd, 0x24, 0xff, 0xff, 0xf0, 0x00, 0x00,  //.....%@@@+.@@@@@.+@@@@@....
    0x00, 0x02, 0xdf, 0xfe, 0x35, 0xff, 0xff, 0xff, 0xf5, 0x2d, 0xff, 0xf3, 0x00, 0x00,  //....@@@@.+@@@@@@@+.@@@@....
    0x00, 0x3e, 0xff, 0xc1, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x81, 0xbf, 0xff, 0x50, 0x00,  //...@@@@.%@@@@@@@@@%.%@@@+..
    0x06, 0xff, 0xfa, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x19, 0xff, 0xf8, 0x00,  //.+@@@%.%@@@@@@@@@@@%.%@@@%.
    0x5f, 0xff, 0x82, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x6f, 0xff, 0x80,  //+@@@+.@@@@@@@@@@@@@@@.+@@@%
    0x2e, 0xf5, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x43, 0xef, 0x40,  //.@@++@@@@@@@@@@@@@@@@@+.@@+
    0x03, 0x20, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x14, 0x00,  //....@@@@@@@@@@@@@@@@@@@..+.
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0xfd, 0xcc, 0xcd, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x03, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x03, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x03, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x03, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x03, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x00, 0x00, 0xbf, 0xff, 0xff, 0xf3, 0x00, 0x03, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00,  //....%@@@@@@.....@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f019 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xbb, 0xbb, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%%%%%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x02, 0x66, 0x66, 0xcf, 0xff, 0xff, 0xc6, 0x66, 0x61, 0x00, 0x00, 0x00,  //......++++@@@@@@%++++......
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@@...........
    0x01, 0x22, 0x22, 0x22, 0x20, 0x05, 0xff, 0xf3, 0x00, 0x22, 0x22, 0x22, 0x21, 0x00,  //...........+@@@............
    0xaf, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x4c, 0x30, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xa0,  //%@@@@@@@@%..+@...%@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@%.....@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x53, 0x6d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@+.+@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x5f, 0xf3, 0x4f, 0xf0,  //@@@@@@@@@@@@@@@@@@@.+@@.+@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x6f, 0xf4, 0x5f, 0xf0,  //@@@@@@@@@@@@@@@@@@@.+@@++@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f01c () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@@....
    0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@....
    0x00, 0x0d, 0xff, 0x91, 0x11, 0x11, 0x11, 0x11, 0x11, 0xbf, 0xfa, 0x00, 0x00,  //...@@@%...........%@@%...
    0x00, 0x3f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0x10, 0x00,  //...@@@............+@@@...
    0x00, 0xaf, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x80, 0x00,  //..%@@%.............@@@%..
    0x01, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xe0, 0x00,  //..@@@+.............+@@@..
    0x08, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf5, 0x00,  //.%@@@...............@@@+.
    0x0e, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfc, 0x00,  //.@@@+...............%@@@.
    0x5f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x30,  //+@@@.................@@@.
    0xbf, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x90,  //%@@%.................@@@%
    0xff, 0xf8, 0x55, 0x55, 0x10, 0x00, 0x00, 0x00, 0x25, 0x55, 0x59, 0xff, 0xc0,  //@@@%++++.........++++%@@@
    0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xdf, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@%.......@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@......+@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x33, 0x33, 0x3d, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@%.....@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //%@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f021 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x6a, 0xdf, 0xfe, 0xd9, 0x40, 0x00, 0x00, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60, 0x00, 0x1d, 0xb0,  //......%@@@@@@@@@@@+....@%
    0x00, 0x00, 0x3d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x21, 0xdf, 0xf0,  //.....@@@@@@@@@@@@@@@..@@@
    0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xf0,  //....@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x2f, 0xff, 0xff, 0xfa, 0x52, 0x13, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xf0,  //...@@@@@@%+...+%@@@@@@@@@
    0x00, 0xdf, 0xff, 0xfc, 0x20, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@.........%@@@@@@@
    0x07, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xf0,  //.+@@@@%...........@@@@@@@
    0x0e, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@...........@@@@@@@@
    0x5f, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xff, 0xff, 0xf0,  //+@@@@...........@@@@@@@@@
    0x9f, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xe0,  //%@@@%...........@@@@@@@@@
    0x25, 0x55, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x55, 0x55, 0x55, 0x20,  //.+++.............+++++++.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x36, 0x66, 0x66, 0x66, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x66, 0x20,  //.++++++++............+++.
    0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0x70,  //@@@@@@@@@+..........@@@@+
    0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0x20,  //@@@@@@@@@...........@@@@.
    0xff, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xfc, 0x00,  //@@@@@@@@...........@@@@@.
    0xff, 0xff, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xf5, 0x00,  //@@@@@@@...........%@@@@+.
    0xff, 0xff, 0xff, 0xfc, 0x20, 0x00, 0x00, 0x00, 0x2d, 0xff, 0xff, 0xb0, 0x00,  //@@@@@@@@.........@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xfa, 0x52, 0x12, 0x5a, 0xff, 0xff, 0xfe, 0x10, 0x00,  //@@@@@@@@@%+...+%@@@@@@...
    0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@....
    0xff, 0xd1, 0x2d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x00, 0x00,  //@@@..@@@@@@@@@@@@@@@.....
    0xcd, 0x10, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x70, 0x00, 0x00, 0x00,  //@@....%@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x01, 0x6a, 0xef, 0xff, 0xea, 0x60, 0x00, 0x00, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f026 () , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x30,  //..........+@.
    0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0x60,  //.........%@@+
    0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0x60,  //........%@@@+
    0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0x60,  //.......%@@@@+
    0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0x60,  //......%@@@@@+
    0x14, 0x44, 0x48, 0xff, 0xff, 0xff, 0x60,  //.++++%@@@@@@+
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@@@@@+
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //%@@@@@@@@@@@+
    0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0x60,  //......@@@@@@+
    0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0x60,  //.......@@@@@+
    0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0x60,  //........@@@@+
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x60,  //.........@@@+
    0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x60,  //..........@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x10,  //...........%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+f027 () , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x30, 0x00, 0x00, 0x00,  //..........+@.......
    0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0x60, 0x00, 0x00, 0x00,  //.........%@@+......
    0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0x60, 0x00, 0x00, 0x00,  //........%@@@+......
    0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00,  //.......%@@@@+......
    0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00,  //......%@@@@@+......
    0x14, 0x44, 0x48, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00,  //.++++%@@@@@@+......
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0d, 0xe4, 0x00,  //@@@@@@@@@@@@+..@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0d, 0xff, 0x30,  //@@@@@@@@@@@@+..@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0xaf, 0xb0,  //@@@@@@@@@@@@+...%@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x2f, 0xf0,  //@@@@@@@@@@@@+....@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x3f, 0xe0,  //@@@@@@@@@@@@+....@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x03, 0xdf, 0x90,  //@@@@@@@@@@@@+...@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0f, 0xfd, 0x10,  //@@@@@@@@@@@@+..@@@.
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x08, 0x91, 0x00,  //%@@@@@@@@@@@+..%%..
    0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00,  //......@@@@@@+......
    0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00,  //.......@@@@@+......
    0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00,  //........@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x60, 0x00, 0x00, 0x00,  //.........@@@+......
    0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x60, 0x00, 0x00, 0x00,  //..........@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x10, 0x00, 0x00, 0x00,  //...........%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f028 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x70, 0x00, 0x00, 0x00,  //..................+@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x7f, 0xfd, 0x30, 0x00, 0x00,  //...........+......+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x50, 0x00, 0x00, 0x04, 0xdf, 0xf4, 0x00, 0x00,  //..........@@+......+@@@....
    0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60, 0x00, 0x02, 0x00, 0x0b, 0xff, 0x20, 0x00,  //.........@@@+........%@@...
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0x60, 0x00, 0x3f, 0xd4, 0x00, 0xbf, 0xd0, 0x00,  //........@@@@+....@@+..%@@..
    0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0x60, 0x00, 0x1e, 0xff, 0x70, 0x1e, 0xf7, 0x00,  //.......@@@@@+....@@@+..@@+.
    0x00, 0x00, 0x01, 0xcf, 0xff, 0xff, 0x60, 0x00, 0x00, 0x9f, 0xf4, 0x05, 0xfe, 0x00,  //......@@@@@@+.....%@@+.+@@.
    0x6a, 0xaa, 0xad, 0xff, 0xff, 0xff, 0x60, 0x04, 0x20, 0x08, 0xfe, 0x00, 0xdf, 0x50,  //+%%%%@@@@@@@+......%@@..@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x2f, 0xf8, 0x00, 0xdf, 0x60, 0x8f, 0x90,  //@@@@@@@@@@@@+..@@%..@@+.%@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x09, 0xff, 0x60, 0x6f, 0xb0, 0x4f, 0xd0,  //@@@@@@@@@@@@+..%@@+.+@%.+@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x6f, 0xd0, 0x2f, 0xe0, 0x1f, 0xe0,  //@@@@@@@@@@@@+...+@@..@@..@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x1f, 0xf0, 0x1f, 0xf0, 0x1f, 0xf0,  //@@@@@@@@@@@@+....@@..@@..@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x6f, 0xd0, 0x2f, 0xe0, 0x1f, 0xe0,  //@@@@@@@@@@@@+...+@@..@@..@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x09, 0xff, 0x60, 0x6f, 0xb0, 0x4f, 0xd0,  //@@@@@@@@@@@@+..%@@+.+@%.+@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x2f, 0xf9, 0x00, 0xdf, 0x60, 0x8f, 0x90,  //@@@@@@@@@@@@+..@@%..@@+.+@%
    0x6a, 0xaa, 0xad, 0xff, 0xff, 0xff, 0x60, 0x04, 0x30, 0x08, 0xfe, 0x00, 0xdf, 0x50,  //+%%%%@@@@@@@+..+...%@@..@@+
    0x00, 0x00, 0x01, 0xcf, 0xff, 0xff, 0x60, 0x00, 0x00, 0x8f, 0xf5, 0x05, 0xfe, 0x00,  //......@@@@@@+.....%@@+.+@@.
    0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0x60, 0x00, 0x1d, 0xff, 0x70, 0x0e, 0xf7, 0x00,  //.......@@@@@+....@@@+..@@+.
    0x00, 0x00, 0x00, 0x01, 0xcf, 0xff, 0x60, 0x00, 0x3f, 0xe5, 0x00, 0xbf, 0xd0, 0x00,  //........@@@@+....@@+..%@@..
    0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x60, 0x00, 0x02, 0x00, 0x0b, 0xff, 0x20, 0x00,  //.........@@@+........%@@...
    0x00, 0x00, 0x00, 0x00, 0x01, 0xcf, 0x50, 0x00, 0x00, 0x04, 0xdf, 0xf4, 0x00, 0x00,  //..........@@+......+@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x7f, 0xfd, 0x30, 0x00, 0x00,  //...........+......+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x80, 0x00, 0x00, 0x00,  //..................+@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f03e () , Width: 32 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x10,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xf0,  //@@...........................@@.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1,  //@@...........................@@.
    0xff, 0x10, 0x07, 0xee, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1,  //@@...+@@%....................@@.
    0xff, 0x10, 0x7f, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1,  //@@..+@@@@%...................@@.
    0xff, 0x10, 0xef, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x0f, 0xf1,  //@@..@@@@@@...................@@.
    0xff, 0x10, 0xef, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x0b, 0xe2, 0x00, 0x00, 0x00, 0x0f, 0xf1,  //@@..@@@@@@.........%@........@@.
    0xff, 0x10, 0x9f, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x20, 0x00, 0x00, 0x0f, 0xf1,  //@@..%@@@@@........%@@@.......@@.
    0xff, 0x10, 0x0b, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x0f, 0xf1,  //@@...%@@@........%@@@@@......@@.
    0xff, 0x10, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x0f, 0xf1,  //@@..............@@@@@@@@.....@@.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x0f, 0xf1,  //@@.............@@@@@@@@@@....@@.
    0xff, 0x10, 0x00, 0x00, 0x25, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0f, 0xf1,  //@@.......+....@@@@@@@@@@@@...@@.
    0xff, 0x10, 0x00, 0x02, 0xef, 0x60, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0f, 0xf1,  //@@......@@+..@@@@@@@@@@@@@@..@@.
    0xff, 0x10, 0x00, 0x2e, 0xff, 0xf7, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0f, 0xf1,  //@@.....@@@@+@@@@@@@@@@@@@@@..@@.
    0xff, 0x10, 0x02, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0f, 0xf1,  //@@....@@@@@@@@@@@@@@@@@@@@@..@@.
    0xff, 0x10, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0f, 0xf1,  //@@...@@@@@@@@@@@@@@@@@@@@@@..@@.
    0xff, 0x10, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0f, 0xf1,  //@@..@@@@@@@@@@@@@@@@@@@@@@@..@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0f, 0xf1,  //@@..@@@@@@@@@@@@@@@@@@@@@@@..@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0f, 0xf1,  //@@..@@@@@@@@@@@@@@@@@@@@@@@..@@.
    0xff, 0x10, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x0f, 0xf1,  //@@..%%%%%%%%%%%%%%%%%%%%%%+..@@.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1,  //@@...........................@@.
    0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //@@...........................@@.
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x20,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f040 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x63, 0x00, 0x00, 0x00,  //..................+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x70, 0x00, 0x00,  //.................@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xf7, 0x00, 0x00,  //................@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0x70, 0x00,  //...............@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xf7, 0x00,  //...............@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x20, 0xcf, 0xff, 0xff, 0xff, 0x40,  //.............@..@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xe2, 0x0c, 0xff, 0xff, 0xff, 0x70,  //............@@@..@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfd, 0xee, 0x20, 0xcf, 0xff, 0xff, 0x20,  //...........@@@@@..@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd3, 0xef, 0xe2, 0x0c, 0xff, 0xf4, 0x00,  //..........@@@.@@@..@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xfd, 0x3e, 0xff, 0xfe, 0x20, 0xcf, 0x40, 0x00,  //.........@@@.@@@@@..@@+..
    0x00, 0x00, 0x00, 0x03, 0xff, 0xd3, 0xef, 0xff, 0xff, 0xe2, 0x03, 0x00, 0x00,  //........@@@.@@@@@@@......
    0x00, 0x00, 0x00, 0x3f, 0xfd, 0x3e, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00,  //.......@@@.@@@@@@@@@.....
    0x00, 0x00, 0x03, 0xff, 0xd3, 0xef, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00,  //......@@@.@@@@@@@@@+.....
    0x00, 0x00, 0x3f, 0xfd, 0x3e, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00,  //.....@@@.@@@@@@@@@+......
    0x00, 0x03, 0xff, 0xd3, 0xef, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00,  //....@@@.@@@@@@@@@+.......
    0x00, 0x3f, 0xfd, 0x3e, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00,  //...@@@.@@@@@@@@@+........
    0x03, 0xff, 0xe3, 0xef, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.@@@@@@@@@+.........
    0x3f, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@@+..........
    0xff, 0xb0, 0xaf, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@%.%@@@@@@@@+...........
    0xff, 0x10, 0x0a, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@...%@@@@@@+............
    0xff, 0x21, 0x00, 0xaf, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@....%@@@@+.............
    0xff, 0xff, 0x20, 0x0d, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@...@@@+..............
    0xff, 0xff, 0x20, 0xaf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@..%@@+...............
    0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@+................
    0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@+.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f048 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x9d, 0xdb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x70,  //%@@%...........++
    0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x90,  //@@@@..........+@%
    0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x05, 0xff, 0x90,  //@@@@.........+@@%
    0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x4f, 0xff, 0x90,  //@@@@........+@@@%
    0xff, 0xff, 0x20, 0x00, 0x00, 0x04, 0xff, 0xff, 0x90,  //@@@@.......+@@@@%
    0xff, 0xff, 0x20, 0x00, 0x00, 0x4f, 0xff, 0xff, 0x90,  //@@@@......+@@@@@%
    0xff, 0xff, 0x20, 0x00, 0x04, 0xff, 0xff, 0xff, 0x90,  //@@@@.....+@@@@@@%
    0xff, 0xff, 0x20, 0x00, 0x4f, 0xff, 0xff, 0xff, 0x90,  //@@@@....+@@@@@@@%
    0xff, 0xff, 0x20, 0x04, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@...+@@@@@@@@%
    0xff, 0xff, 0x20, 0x4f, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@..+@@@@@@@@@%
    0xff, 0xff, 0x24, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@.+@@@@@@@@@@%
    0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@+@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@%@@@@@@@@@@@%
    0xff, 0xff, 0x26, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@.+@@@@@@@@@@%
    0xff, 0xff, 0x20, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@..+@@@@@@@@@%
    0xff, 0xff, 0x20, 0x06, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@...+@@@@@@@@%
    0xff, 0xff, 0x20, 0x00, 0x6f, 0xff, 0xff, 0xff, 0x90,  //@@@@....+@@@@@@@%
    0xff, 0xff, 0x20, 0x00, 0x06, 0xff, 0xff, 0xff, 0x90,  //@@@@.....+@@@@@@%
    0xff, 0xff, 0x20, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x90,  //@@@@......+@@@@@%
    0xff, 0xff, 0x20, 0x00, 0x00, 0x06, 0xff, 0xff, 0x90,  //@@@@.......+@@@@%
    0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x6f, 0xff, 0x90,  //@@@@........+@@@%
    0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x06, 0xff, 0x90,  //@@@@.........+@@%
    0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x6f, 0x90,  //@@@@..........+@%
    0xbf, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x80,  //%@@@...........+%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f04b () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xc7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+.....................
    0xff, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+...................
    0xff, 0xff, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@..................
    0xff, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%................
    0xff, 0xff, 0xff, 0xff, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@%..............
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@+............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@+..........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x30, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x20, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@%.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x10, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd5, 0x00,  //@@@@@@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x10,  //@@@@@@@@@@@@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x30, 0x00,  //@@@@@@@@@@@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x40, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@+....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@+......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@%........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@%..........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%............
    0xff, 0xff, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@+.............
    0xff, 0xff, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@+...............
    0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@%.................
    0xff, 0xfa, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%...................
    0xfc, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.....................
    0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f04c () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x9d, 0xdd, 0xdd, 0xdd, 0xdc, 0x10, 0x00, 0x1c, 0xdd, 0xdd, 0xdd, 0xdd, 0x90,  //%@@@@@@@@@.....@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xbf, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xb0,  //%@@@@@@@@@.....@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f04d () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x9d, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0x70,  //%@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //%@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f051 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9d, 0xdb, 0x00,  //+...........%@@%.
    0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x20,  //@+..........@@@@.
    0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x20,  //@@+.........@@@@.
    0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x20,  //@@@+........@@@@.
    0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0xff, 0xff, 0x20,  //@@@@+.......@@@@.
    0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0xff, 0xff, 0x20,  //@@@@@+......@@@@.
    0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0xff, 0xff, 0x20,  //@@@@@@+.....@@@@.
    0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0xff, 0xff, 0x20,  //@@@@@@@+....@@@@.
    0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0xff, 0xff, 0x20,  //@@@@@@@@+...@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0xff, 0xff, 0x20,  //@@@@@@@@@+..@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0xff, 0xff, 0x20,  //@@@@@@@@@@+.@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xff, 0xff, 0x20,  //@@@@@@@@@@@+@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0x20,  //@@@@@@@@@@@%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0xff, 0xff, 0x20,  //@@@@@@@@@@%.@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0xff, 0xff, 0x20,  //@@@@@@@@@%..@@@@.
    0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0xff, 0xff, 0x20,  //@@@@@@@@%...@@@@.
    0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0xff, 0xff, 0x20,  //@@@@@@@%....@@@@.
    0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0xff, 0xff, 0x20,  //@@@@@@%.....@@@@.
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0xff, 0xff, 0x20,  //@@@@@%......@@@@.
    0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0xff, 0xff, 0x20,  //@@@@%.......@@@@.
    0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x20,  //@@@%........@@@@.
    0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x20,  //@@%.........@@@@.
    0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x20,  //@%..........@@@@.
    0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xfd, 0x00,  //%...........%@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f052 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@+..........
    0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@+........
    0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@+.....
    0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@+....
    0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@+...
    0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00,  //..+@@@@@@@@@@@@@@@@@@@+..
    0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@+.
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,  //+@@@@@@@@@@@@@@@@@@@@@@@+
    0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x60,  //+%%%%%%%%%%%%%%%%%%%%%%%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x13, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00,  //.........................
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //%@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f053 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x80, 0x00,  //............+@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xf8, 0x00,  //...........+@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0x80,  //..........+@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xf3,  //.........+@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xc0,  //........+@@@@@@@@.
    0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.......+@@@@@@@@..
    0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xc0, 0x00,  //......+@@@@@@@@...
    0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,  //.....+@@@@@@@@....
    0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00,  //....+@@@@@@@@.....
    0x00, 0x07, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00,  //...+@@@@@@@@......
    0x00, 0x7f, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,  //..+@@@@@@@@.......
    0x07, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@@@@........
    0x5f, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@.........
    0x4f, 0xff, 0xff, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@.........
    0x06, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00,  //.+@@@@@@@@........
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xd1, 0x00, 0x00, 0x00,  //..+@@@@@@@@.......
    0x00, 0x06, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00,  //...+@@@@@@@@......
    0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xd1, 0x00, 0x00,  //....+@@@@@@@@.....
    0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x00,  //.....+@@@@@@@@....
    0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xd1, 0x00,  //......+@@@@@@@@...
    0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xfd, 0x10,  //.......+@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xd0,  //........+@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xf2,  //.........+@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x70,  //..........+@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xf7, 0x00,  //...........+@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x70, 0x00,  //............+@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f054 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x0c, 0xe3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.............
    0x00, 0xcf, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@............
    0x0c, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@...........
    0x7f, 0xff, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@..........
    0x2e, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@.........
    0x02, 0xef, 0xff, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00,  //..@@@@@@@@........
    0x00, 0x2e, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00,  //...@@@@@@@@.......
    0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0x30, 0x00, 0x00,  //....@@@@@@@@......
    0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00,  //.....@@@@@@@@.....
    0x00, 0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0x30, 0x00,  //......@@@@@@@@....
    0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xf3, 0x00,  //.......@@@@@@@@...
    0x00, 0x00, 0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0x30,  //........@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xf1,  //.........@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xe1,  //.........@@@@@@@@.
    0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xfe, 0x20,  //........@@@@@@@@..
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xe2, 0x00,  //.......@@@@@@@@...
    0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00,  //......@@@@@@@@....
    0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00,  //.....@@@@@@@@.....
    0x00, 0x03, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00,  //....@@@@@@@@......
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00,  //...@@@@@@@@.......
    0x03, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00,  //..@@@@@@@@........
    0x3f, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@.........
    0x7f, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@..........
    0x0b, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@@...........
    0x00, 0xbf, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@............
    0x00, 0x0a, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f067 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x2b, 0xcc, 0xc9, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x17, 0x77, 0x77, 0x77, 0xdf, 0xff, 0xff, 0xb7, 0x77, 0x77, 0x76, 0x00,  //.+++++++@@@@@@%+++++++.
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@@@@@@@%
    0x4a, 0xbb, 0xbb, 0xbb, 0xef, 0xff, 0xff, 0xdb, 0xbb, 0xbb, 0xba, 0x20,  //+%%%%%%%@@@@@@@%%%%%%%.
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f068 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x02, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x32, 0x00,  //.......................
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //%@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@@@@@@@%
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x50,  //+@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f071 () , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............%@%.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............%@@@%............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x74, 0x44, 0x7f, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00,  //........+@@@+++++@@@+........
    0x00, 0x00, 0x00, 0x00, 0xdf, 0xff, 0x30, 0x00, 0x3f, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00,  //........@@@@.....@@@@........
    0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0x30, 0x00, 0x3f, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@.....@@@@+.......
    0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0x40, 0x00, 0x4f, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@+...+@@@@@.......
    0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0x40, 0x00, 0x4f, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00,  //......+@@@@@+...+@@@@@+......
    0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0x50, 0x00, 0x5f, 0xff, 0xff, 0xf1, 0x00, 0x00, 0x00,  //......@@@@@@+...+@@@@@@......
    0x00, 0x00, 0x09, 0xff, 0xff, 0xff, 0x50, 0x00, 0x6f, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00,  //.....%@@@@@@+...+@@@@@@%.....
    0x00, 0x00, 0x2f, 0xff, 0xff, 0xff, 0x60, 0x00, 0x6f, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00,  //.....@@@@@@@+...+@@@@@@@.....
    0x00, 0x00, 0xaf, 0xff, 0xff, 0xff, 0x80, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00,  //....%@@@@@@@%...%@@@@@@@%....
    0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@@@@@@....
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@@@@@@@%...
    0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00,  //..+@@@@@@@@@+...+@@@@@@@@@+..
    0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //..@@@@@@@@@@+...+@@@@@@@@@@..
    0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00,  //.+@@@@@@@@@@+...+@@@@@@@@@@+.
    0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x81, 0x11, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,  //.@@@@@@@@@@@%...%@@@@@@@@@@@.
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x40,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f074 () , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x50, 0x00, 0x00,  //.......................@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf5, 0x00, 0x00,  //.......................@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x50, 0x00,  //.......................@@@+..
    0xab, 0xbb, 0xa8, 0x50, 0x00, 0x00, 0x00, 0x01, 0x69, 0xbb, 0xbb, 0xcf, 0xff, 0xf5, 0x00,  //%%%%%%+.........+%%%%%@@@@@+.
    0xff, 0xff, 0xff, 0xfe, 0x50, 0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@+.....%@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@+...%@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20,  //@@@@@@@@@@+.%@@@@@@@@@@@@@@@.
    0x56, 0x66, 0x7b, 0xff, 0xff, 0x66, 0xff, 0xff, 0xf9, 0x66, 0x66, 0x8f, 0xff, 0xe2, 0x00,  //+++++%@@@@++@@@@@%++++%@@@@..
    0x00, 0x00, 0x00, 0x4f, 0xfd, 0x1e, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x3f, 0xfe, 0x20, 0x00,  //......+@@@.@@@@@.......@@@...
    0x00, 0x00, 0x00, 0x07, 0xf6, 0x7f, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x3f, 0xe2, 0x00, 0x00,  //.......+@++@@@@........@@....
    0x00, 0x00, 0x00, 0x00, 0xb1, 0xef, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x2e, 0x20, 0x00, 0x00,  //........%.@@@@%........@.....
    0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@...............
    0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@%...............
    0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@................
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xc2, 0x90, 0x00, 0x00, 0x00, 0x2d, 0x20, 0x00, 0x00,  //........@@@@@.%........@.....
    0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0x49, 0xf3, 0x00, 0x00, 0x00, 0x3f, 0xe2, 0x00, 0x00,  //.......+@@@@+%@........@@....
    0x00, 0x00, 0x00, 0x4f, 0xff, 0xfc, 0x1f, 0xfd, 0x10, 0x00, 0x00, 0x3f, 0xfe, 0x20, 0x00,  //.......@@@@@.@@@.......@@@...
    0x45, 0x55, 0x6a, 0xff, 0xff, 0xf3, 0x9f, 0xff, 0xf9, 0x65, 0x55, 0x8f, 0xff, 0xe2, 0x00,  //+++++%@@@@@.%@@@@%++++%@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20,  //@@@@@@@@@@+.%@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@%...@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@+.....%@@@@@@@@@@@@@+
    0xbc, 0xcc, 0xba, 0x60, 0x00, 0x00, 0x00, 0x02, 0x7a, 0xcc, 0xcc, 0xdf, 0xff, 0xf6, 0x00,  //%@@@%%+.........+%%@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x60, 0x00,  //.......................@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf6, 0x00, 0x00,  //.......................@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x60, 0x00, 0x00,  //.......................@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f077 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xde, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@............
    0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@@..........
    0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@@@@.........
    0x00, 0x00, 0x00, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@........
    0x00, 0x00, 0x01, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@......
    0x00, 0x01, 0xdf, 0xff, 0xff, 0xff, 0x53, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00,  //....@@@@@@@@+.@@@@@@@@.....
    0x00, 0x1d, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00,  //...@@@@@@@@+...@@@@@@@@....
    0x01, 0xdf, 0xff, 0xff, 0xff, 0x50, 0x00, 0x03, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00,  //..@@@@@@@@+.....@@@@@@@@...
    0x1d, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xe2, 0x00,  //.@@@@@@@@+.......@@@@@@@@..
    0xdf, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@+.........@@@@@@@@.
    0xcf, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xfd, 0x00,  //@@@@@@@+...........@@@@@@@.
    0x1c, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xd1, 0x00,  //.@@@@@+.............@@@@@..
    0x01, 0xcf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xfd, 0x10, 0x00,  //..@@@+...............@@@...
    0x00, 0x09, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x91, 0x00, 0x00,  //...%+.................%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f078 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,  //...........................
    0x00, 0x6f, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xf8, 0x00, 0x00,  //..+@@................%@%...
    0x06, 0xff, 0xfc, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0x80, 0x00,  //.+@@@@..............%@@@%..
    0x6f, 0xff, 0xff, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xf8, 0x00,  //+@@@@@@............%@@@@@%.
    0xff, 0xff, 0xff, 0xfc, 0x10, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@..........%@@@@@@@.
    0x6f, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xf7, 0x00,  //+@@@@@@@@........%@@@@@@@+.
    0x06, 0xff, 0xff, 0xff, 0xfc, 0x10, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0x70, 0x00,  //.+@@@@@@@@......%@@@@@@@+..
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00,  //..+@@@@@@@@....%@@@@@@@+...
    0x00, 0x06, 0xff, 0xff, 0xff, 0xfc, 0x10, 0xbf, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00,  //...+@@@@@@@@..%@@@@@@@+....
    0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xcb, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00,  //....+@@@@@@@@%@@@@@@@+.....
    0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+@@+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............++.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f079 () , Width: 32 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x0a, 0xe2, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00,  //.....%@...%@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x8f, 0xfd, 0x10, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00,  //....%@@@...@@@@@@@@@@@@@@@@.....
    0x00, 0x05, 0xff, 0xff, 0xc0, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00,  //...+@@@@@...@@@@@@@@@@@@@@@.....
    0x00, 0x3f, 0xff, 0xff, 0xf9, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00,  //...@@@@@@%..+@@@@@@@@@@@@@@.....
    0x01, 0xef, 0xff, 0xff, 0xff, 0x70, 0x01, 0x11, 0x11, 0x11, 0x11, 0x5f, 0xff, 0xe0, 0x00, 0x00,  //..@@@@@@@@+...........+@@@@.....
    0x0d, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xe0, 0x00, 0x00,  //.@@@@@@@@@@+...........@@@@.....
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xe0, 0x00, 0x00,  //%@@@@@@@@@@@...........@@@@.....
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xe0, 0x00, 0x00,  //@@@@@@@@@@@@+..........@@@@.....
    0x14, 0x44, 0xef, 0xff, 0x74, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xe0, 0x00, 0x00,  //.+++@@@@+++............@@@@.....
    0x00, 0x00, 0xdf, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xe0, 0x00, 0x00,  //....@@@@+..............@@@@.....
    0x00, 0x00, 0xdf, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x03, 0x44, 0x6f, 0xff, 0xf4, 0x44, 0x20,  //....@@@@+...........+++@@@@+++..
    0x00, 0x00, 0xdf, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //....@@@@+.........+@@@@@@@@@@@@.
    0x00, 0x00, 0xdf, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //....@@@@+..........@@@@@@@@@@@%.
    0x00, 0x00, 0xdf, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,  //....@@@@+...........@@@@@@@@@@..
    0x00, 0x00, 0xdf, 0xff, 0x62, 0x22, 0x22, 0x22, 0x21, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xe2, 0x00,  //....@@@@+...........+@@@@@@@@...
    0x00, 0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x08, 0xff, 0xff, 0xff, 0x40, 0x00,  //....@@@@@@@@@@@@@@+..%@@@@@@+...
    0x00, 0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0xbf, 0xff, 0xf6, 0x00, 0x00,  //....@@@@@@@@@@@@@@@...%@@@@+....
    0x00, 0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0d, 0xff, 0x90, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@...@@@%.....
    0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x01, 0xdb, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@%...@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f07b () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x01, 0x9c, 0xcc, 0xcc, 0xcb, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@@@@%+................
    0x2e, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@%...............
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@+..............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0xaa, 0xaa, 0xaa, 0xaa, 0xa9, 0x60, 0x00,  //@@@@@@@@@@@@@%%%%%%%%%%%+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //+@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x04, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f093 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............%.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@@@.........
    0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@@@@@........
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@@.......
    0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x03, 0x99, 0x99, 0xdf, 0xff, 0xff, 0xc9, 0x99, 0x83, 0x00, 0x00, 0x00,  //......%%%%@@@@@@@%%%%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x01, 0x22, 0x22, 0x22, 0x10, 0x5d, 0xdd, 0xdd, 0x40, 0x12, 0x22, 0x22, 0x21, 0x00,  //..........+@@@@@...........
    0xaf, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xff, 0xff, 0x90,  //%@@@@@@@@.........@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x52, 0x22, 0x22, 0x5d, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@+.....+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x5f, 0xf3, 0x4f, 0xf0,  //@@@@@@@@@@@@@@@@@@@.+@@.+@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x5f, 0xf3, 0x4f, 0xf0,  //@@@@@@@@@@@@@@@@@@@.+@@.+@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //%@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f095 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x39, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%%+.................
    0x05, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@.................
    0x1f, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@%................
    0x8f, 0xff, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@................
    0xdf, 0xff, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@%...............
    0xff, 0xff, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@...............
    0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@%...............
    0xbf, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@%................
    0x6f, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@%.................
    0x1f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@+.................
    0x0a, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@.................
    0x03, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@%................
    0x00, 0xaf, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@@+...............
    0x00, 0x1e, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@...............
    0x00, 0x04, 0xff, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,  //...+@@@@@..............
    0x00, 0x00, 0x7f, 0xff, 0xff, 0x50, 0x00, 0x00, 0xcf, 0xb1, 0x00, 0x00,  //....+@@@@@+.....%@%....
    0x00, 0x00, 0x08, 0xff, 0xff, 0xfb, 0x10, 0x0a, 0xff, 0xff, 0x80, 0x00,  //.....%@@@@@%...%@@@@%..
    0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0xf8, 0xaf, 0xff, 0xff, 0xfe, 0x50,  //......%@@@@@@+%@@@@@@@+
    0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //.......+@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //........+@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x01, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //..........%@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xaf, 0xff, 0xff, 0xff, 0xf5, 0x00,  //............%@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x6b, 0xff, 0xd8, 0x10, 0x00,  //..............+%@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f0c4 () , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x47, 0x98, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..++%++......................
    0x1c, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@+....................
    0xcf, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x10, 0x00,  //@@@@@@@@@@...............+...
    0xff, 0xf5, 0x01, 0x4b, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xea, 0xe9, 0x00,  //@@@+..+%@@@............%@%@%.
    0xff, 0x90, 0x00, 0x00, 0x5f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x08, 0xe8, 0x00, 0x1d, 0x60,  //@@%.....+@@%.........%@%...@+
    0xff, 0xd0, 0x00, 0x00, 0x07, 0xfd, 0x00, 0x00, 0x00, 0x07, 0xea, 0x10, 0x01, 0xbc, 0x10,  //@@@......+@@.......+@%....%@.
    0xef, 0xfa, 0x00, 0x00, 0x03, 0xff, 0x00, 0x00, 0x05, 0xdb, 0x30, 0x00, 0x2d, 0x90, 0x00,  //@@@%......@@.....+@%.....@%..
    0x4f, 0xff, 0xe6, 0x20, 0x2b, 0xfe, 0x10, 0x04, 0xcd, 0x40, 0x00, 0x05, 0xe6, 0x00, 0x00,  //+@@@@+...%@@....@@+....+@+...
    0x05, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xe7, 0xbe, 0x60, 0x00, 0x00, 0x8e, 0x30, 0x00, 0x00,  //.+@@@@@@@@@%@+%@+.....%@.....
    0x00, 0x2b, 0xff, 0xff, 0xff, 0xc0, 0x9f, 0x80, 0x00, 0x00, 0x1b, 0xb1, 0x00, 0x00, 0x00,  //...%@@@@@@@.%@+......%%......
    0x00, 0x00, 0x26, 0x88, 0x63, 0xdc, 0xf2, 0x33, 0x00, 0x02, 0xd8, 0x00, 0x00, 0x00, 0x00,  //.....+%%+.@@@.......@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xf0, 0xef, 0x00, 0x5f, 0x50, 0x00, 0x00, 0x00, 0x00,  //...........%@.@@..+@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xb0, 0xbc, 0x08, 0xed, 0xb1, 0x00, 0x00, 0x00, 0x00,  //..........+@%.%@.%@@%........
    0x00, 0x02, 0x8d, 0xff, 0xda, 0xe5, 0x02, 0x51, 0xbb, 0x10, 0xae, 0x30, 0x00, 0x00, 0x00,  //....%@@@@%@+..+.%%..%@.......
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xd2, 0x8f, 0xff, 0x70, 0x00, 0x06, 0xf6, 0x00, 0x00, 0x00,  //..%@@@@@@@@.%@@@+....+@+.....
    0x0c, 0xff, 0xff, 0xb9, 0xbf, 0xff, 0xa1, 0x4c, 0xd5, 0x00, 0x00, 0x3d, 0xa0, 0x00, 0x00,  //.@@@@@%%%@@@%.+@@+.....@%....
    0xaf, 0xff, 0x70, 0x00, 0x05, 0xfe, 0x00, 0x00, 0x5d, 0xc4, 0x00, 0x00, 0xbd, 0x20, 0x00,  //%@@@+....+@@....+@@+....%@...
    0xff, 0xf4, 0x00, 0x00, 0x03, 0xff, 0x00, 0x00, 0x00, 0x6e, 0xb3, 0x00, 0x07, 0xe5, 0x00,  //@@@.......@@......+@%....+@+.
    0xff, 0xa0, 0x00, 0x00, 0x0c, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xa1, 0x00, 0x3e, 0x50,  //@@%......@@%........+@%....@+
    0xff, 0xc0, 0x00, 0x04, 0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x01, 0x8e, 0x83, 0x9e, 0x30,  //@@@....+@@@...........%@%.%@.
    0xff, 0xfe, 0xaa, 0xdf, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x9d, 0x71, 0x00,  //@@@@%%@@@@+.............%@+..
    0x5f, 0xff, 0xff, 0xff, 0xe4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@+...................
    0x03, 0xae, 0xfe, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@%+.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f0c5 () , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@+..........
    0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@@@@@@@@@@..........
    0x00, 0x00, 0x00, 0x8f, 0xff, 0x21, 0x11, 0x11, 0x2f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@.......@@..........
    0x00, 0x00, 0x08, 0xfc, 0xff, 0x10, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@.......@@..........
    0x00, 0x00, 0x8f, 0xc1, 0xff, 0x10, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@.@@.......@@..........
    0x00, 0x09, 0xfc, 0x10, 0xff, 0x10, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@..@@.......@@..........
    0x00, 0x9f, 0xc1, 0x00, 0xff, 0x10, 0x00, 0x00, 0x0f, 0xf9, 0xef, 0xff, 0xff, 0xff, 0x70,  //..%@@...@@.......@@%@@@@@@@@+
    0x09, 0xfc, 0x10, 0x00, 0xff, 0x10, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.%@@....@@.......@@@@@@@@@@@@
    0x6f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x2f, 0xff, 0xf0, 0x00, 0x00, 0x1f, 0xf0,  //+@@@@@@@@@.......@@@@......@@
    0xdf, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x03, 0xef, 0xdf, 0xf0, 0x00, 0x00, 0x1f, 0xf0,  //@@@@@@@@@%......@@@@@......@@
    0xff, 0x21, 0x11, 0x11, 0x00, 0x00, 0x00, 0x3e, 0xfd, 0x1f, 0xf0, 0x00, 0x00, 0x1f, 0xf0,  //@@.............@@@.@@......@@
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xe2, 0x0f, 0xf0, 0x00, 0x00, 0x1f, 0xf0,  //@@...........+@@@..@@......@@
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfe, 0x20, 0x0f, 0xf0, 0x00, 0x00, 0x1f, 0xf0,  //@@..........+@@@...@@......@@
    0xff, 0x10, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf3, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x1f, 0xf0,  //@@.........+@@@....@@......@@
    0xff, 0x10, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x51, 0x11, 0x1f, 0xf0, 0x00, 0x00, 0x1f, 0xf0,  //@@.........@@@+....@@......@@
    0xff, 0x10, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x1f, 0xf0,  //@@........%@@@@@@@@@@......@@
    0xff, 0x10, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x1f, 0xf0,  //@@........@@@@@@@@@@+......@@
    0xff, 0x10, 0x00, 0x00, 0x00, 0xef, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //@@........@@+..............@@
    0xff, 0x10, 0x00, 0x00, 0x00, 0xef, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //@@........@@+..............@@
    0xff, 0x10, 0x00, 0x00, 0x00, 0xef, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //@@........@@+..............@@
    0xff, 0x20, 0x00, 0x00, 0x00, 0xef, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //@@........@@+..............@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //@@@@@@@@@@@@+..............@@
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //%@@@@@@@@@@@+..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //..........@@+..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //..........@@+..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //..........@@+..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //..........@@+..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..........@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //..........+@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f0c7 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x70, 0x00, 0x00, 0x00,  //+@@@@@@@@@@@@@@@@@+......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@%.....
    0xff, 0x20, 0xff, 0xff, 0xff, 0x50, 0x00, 0x3f, 0xf3, 0xdf, 0xb0, 0x00, 0x00,  //@@..@@@@@@+....@@.@@%....
    0xff, 0x10, 0xff, 0xff, 0xff, 0x30, 0x00, 0x1f, 0xf0, 0x1d, 0xfb, 0x00, 0x00,  //@@..@@@@@@.....@@..@@%...
    0xff, 0x10, 0xff, 0xff, 0xff, 0x30, 0x00, 0x1f, 0xf0, 0x02, 0xef, 0xb0, 0x00,  //@@..@@@@@@.....@@...@@%..
    0xff, 0x10, 0xff, 0xff, 0xff, 0x30, 0x00, 0x1f, 0xf0, 0x00, 0x2e, 0xfb, 0x00,  //@@..@@@@@@.....@@....@@%.
    0xff, 0x10, 0xff, 0xff, 0xff, 0x30, 0x00, 0x1f, 0xf0, 0x00, 0x03, 0xff, 0x70,  //@@..@@@@@@.....@@.....@@+
    0xff, 0x10, 0xff, 0xff, 0xff, 0x30, 0x00, 0x1f, 0xf0, 0x00, 0x00, 0x5f, 0xd0,  //@@..@@@@@@.....@@.....+@@
    0xff, 0x10, 0xff, 0xff, 0xff, 0x51, 0x11, 0x3f, 0xf0, 0x00, 0x00, 0x1f, 0xf0,  //@@..@@@@@@+....@@......@@
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x1f, 0xf0,  //@@..@@@@@@@@@@@@@......@@
    0xff, 0x10, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x1f, 0xf0,  //@@..+@@@@@@@@@@@+......@@
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //@@.....................@@
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //@@.....................@@
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //@@.....................@@
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0,  //@@.....................@@
    0xff, 0x10, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x1f, 0xf0,  //@@..%@@@@@@@@@@@@@@@%..@@
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x1f, 0xf0,  //@@..@@@@@@@@@@@@@@@@@..@@
    0xff, 0x10, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x1f, 0xf0,  //@@..@@.............@@..@@
    0xff, 0x10, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x1f, 0xf0,  //@@..@@.............@@..@@
    0xff, 0x10, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x1f, 0xf0,  //@@..@@.............@@..@@
    0xff, 0x10, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x1f, 0xf0,  //@@..@@.............@@..@@
    0xff, 0x10, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x1f, 0xf0,  //@@..@@.............@@..@@
    0xff, 0x10, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x1f, 0xf0,  //@@..@@.............@@..@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f0e7 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x09, 0xee, 0xee, 0xec, 0x00, 0x00, 0x00,  //...%@@@@@@.....
    0x00, 0x0f, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00,  //...@@@@@@@.....
    0x00, 0x3f, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00,  //...@@@@@@+.....
    0x00, 0x7f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..+@@@@@@......
    0x00, 0xaf, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00,  //..%@@@@@%......
    0x00, 0xef, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00,  //..@@@@@@+......
    0x02, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@.......
    0x06, 0xff, 0xff, 0xf8, 0x00, 0x48, 0xcf, 0x60,  //.+@@@@@%..+%@@+
    0x0a, 0xff, 0xff, 0xfa, 0xcf, 0xff, 0xff, 0x20,  //.%@@@@@%@@@@@@.
    0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00,  //.@@@@@@@@@@@@%.
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00,  //.@@@@@@@@@@@@..
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00,  //+@@@@@@@@@@@%..
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00,  //%@@@@@@@@@@@+..
    0xdf, 0xff, 0xd9, 0x5a, 0xff, 0xfc, 0x00, 0x00,  //@@@@@%+%@@@@...
    0x99, 0x51, 0x00, 0x0d, 0xff, 0xf5, 0x00, 0x00,  //%%+....@@@@+...
    0x00, 0x00, 0x00, 0x1f, 0xff, 0xd0, 0x00, 0x00,  //.......@@@@....
    0x00, 0x00, 0x00, 0x5f, 0xff, 0x60, 0x00, 0x00,  //......+@@@+....
    0x00, 0x00, 0x00, 0x9f, 0xfe, 0x00, 0x00, 0x00,  //......%@@@.....
    0x00, 0x00, 0x00, 0xdf, 0xf7, 0x00, 0x00, 0x00,  //......@@@+.....
    0x00, 0x00, 0x01, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x04, 0xff, 0x80, 0x00, 0x00, 0x00,  //.....+@@%......
    0x00, 0x00, 0x08, 0xff, 0x10, 0x00, 0x00, 0x00,  //.....%@@.......
    0x00, 0x00, 0x0c, 0xf9, 0x00, 0x00, 0x00, 0x00,  //.....@@%.......
    0x00, 0x00, 0x0f, 0xf2, 0x00, 0x00, 0x00, 0x00,  //.....@@........
    0x00, 0x00, 0x4f, 0xa0, 0x00, 0x00, 0x00, 0x00,  //....+@%........
    0x00, 0x00, 0x8f, 0x30, 0x00, 0x00, 0x00, 0x00,  //....%@.........
    0x00, 0x00, 0x9b, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f0f3 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+%+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0xff, 0xf7, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x4d, 0xff, 0xff, 0xff, 0xfc, 0x30, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@.........
    0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@+......
    0x00, 0x00, 0x01, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@+.....
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x0d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00,  //....%@@@@@@@@@@@@@@@@@+....
    0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@@@%....
    0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@@@@....
    0x00, 0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@@@@@%...
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@...
    0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00,  //..@@@@@@@@@@@@@@@@@@@@@@%..
    0x09, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@%.
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x3c, 0xee, 0xee, 0xee, 0xef, 0xef, 0xff, 0xff, 0xff, 0xee, 0xee, 0xee, 0xec, 0x20,  //.@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x09, 0xbb, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%%%@@@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x05, 0xf5, 0xef, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@+@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbd, 0x58, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@+%@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xef, 0xe8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f11c () , Width: 32 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x3d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x40,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+.
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1,  //@@...........................@@.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1,  //@@...........................@@.
    0xff, 0x10, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x10, 0x0f, 0xf1,  //@@...........................@@.
    0xff, 0x10, 0xff, 0x10, 0xdf, 0x00, 0xef, 0xe0, 0x0f, 0xe0, 0x0f, 0xd0, 0x0f, 0xf0, 0x0f, 0xf1,  //@@..@@..@@..@@@..@@..@@..@@..@@.
    0xff, 0x10, 0xff, 0x00, 0xdf, 0x00, 0xef, 0xe0, 0x0f, 0xe0, 0x0f, 0xd0, 0x0f, 0xf0, 0x0f, 0xf1,  //@@..@@..@@..@@@..@@..@@..@@..@@.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x0f, 0xf1,  //@@.......................@@..@@.
    0xff, 0x10, 0x01, 0x11, 0x00, 0x11, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x2f, 0xf0, 0x0f, 0xf1,  //@@.......................@@..@@.
    0xff, 0x10, 0xff, 0xff, 0x20, 0xff, 0x00, 0x1f, 0xf0, 0x1f, 0xf0, 0x2f, 0xff, 0xf0, 0x0f, 0xf1,  //@@..@@@@..@@...@@..@@..@@@@..@@.
    0xff, 0x10, 0xff, 0xff, 0x10, 0xff, 0x00, 0x0f, 0xf0, 0x0f, 0xf0, 0x1f, 0xff, 0xf0, 0x0f, 0xf1,  //@@..@@@@..@@...@@..@@..@@@@..@@.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1,  //@@...........................@@.
    0xff, 0x10, 0x01, 0x00, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x01, 0x10, 0x0f, 0xf1,  //@@...........................@@.
    0xff, 0x10, 0xff, 0x10, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0f, 0xf0, 0x0f, 0xf1,  //@@..@@..@@@@@@@@@@@@@@@..@@..@@.
    0xff, 0x10, 0xff, 0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0f, 0xf0, 0x0f, 0xf1,  //@@..@@..@@@@@@@@@@@@@@@..@@..@@.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1,  //@@...........................@@.
    0xff, 0x21, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x1f, 0xf1,  //@@...........................@@.
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x3d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x40,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f124 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x40,  //.....................%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xff, 0xb0,  //...................%@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xff, 0xff, 0x50,  //.................%@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xff, 0xff, 0xfc, 0x00,  //...............%@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xff, 0xff, 0xff, 0xf5, 0x00,  //.............%@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //...........%@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x3b, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00,  //.........%@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x3b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,  //.......%@@@@@@@@@@@@...
    0x00, 0x00, 0x3b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00,  //.....%@@@@@@@@@@@@@+...
    0x00, 0x3b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@....
    0x2b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@+....
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@.....
    0x7b, 0xbb, 0xbb, 0xbb, 0xbb, 0xef, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00,  //+%%%%%%%%%@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,  //..........%@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00,  //..........%@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //..........%@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f15b () , Width: 25 */
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x10, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@@@@@@+..........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x68, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@+.+%.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x6f, 0x80, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@+.+@%......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x6f, 0xf8, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@+.+@@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x6f, 0xff, 0x80, 0x00, 0x00,  //@@@@@@@@@@@@@@+.+@@@%....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x6f, 0xff, 0xf8, 0x00, 0x00,  //@@@@@@@@@@@@@@+.+@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x6f, 0xff, 0xff, 0x80, 0x00,  //@@@@@@@@@@@@@@+.+@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x6f, 0xff, 0xff, 0xf8, 0x00,  //@@@@@@@@@@@@@@+.+@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x14, 0x44, 0x44, 0x44, 0x00,  //@@@@@@@@@@@@@@+..+++++++.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@%..........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xaa, 0xaa, 0xaa, 0xaa, 0x80,  //@@@@@@@@@@@@@@@@%%%%%%%%%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //+@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f1eb () , Width: 32 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xbd, 0xef, 0xfe, 0xca, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+%%@@@@@@%+...........
    0x00, 0x00, 0x00, 0x04, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x20, 0x00, 0x00, 0x00,  //.......+%@@@@@@@@@@@@@@%........
    0x00, 0x00, 0x05, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x30, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@%......
    0x00, 0x02, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x5f, 0xff, 0xff, 0xff, 0xfb, 0x75, 0x32, 0x23, 0x58, 0xcf, 0xff, 0xff, 0xff, 0xd3, 0x00,  //..+@@@@@@@@%++....+%@@@@@@@@@...
    0x08, 0xff, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x8f, 0xff, 0xff, 0xff, 0x50,  //.%@@@@@@@+............%@@@@@@@+.
    0x8f, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x12, 0x10, 0x00, 0x00, 0x01, 0x9f, 0xff, 0xff, 0xf5,  //%@@@@@@+................%@@@@@@+
    0xcf, 0xff, 0xfc, 0x10, 0x00, 0x38, 0xcf, 0xff, 0xff, 0xeb, 0x72, 0x00, 0x03, 0xef, 0xff, 0xf9,  //@@@@@@.....%@@@@@@@%+.....@@@@@%
    0x1e, 0xff, 0x90, 0x00, 0x6d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00, 0x1c, 0xff, 0xb0,  //.@@@%...+@@@@@@@@@@@@@@+...@@@%.
    0x02, 0xd7, 0x00, 0x4d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x00, 0xab, 0x00,  //..@+..+@@@@@@@@@@@@@@@@@@...%%..
    0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@+.....
    0x00, 0x00, 0x7f, 0xff, 0xff, 0xfd, 0x84, 0x10, 0x02, 0x48, 0xdf, 0xff, 0xff, 0xf3, 0x00, 0x00,  //....+@@@@@@@%+....+%@@@@@@@.....
    0x00, 0x00, 0x1d, 0xff, 0xfc, 0x40, 0x00, 0x01, 0x10, 0x00, 0x06, 0xdf, 0xff, 0xa0, 0x00, 0x00,  //.....@@@@@...........+@@@@%.....
    0x00, 0x00, 0x01, 0xce, 0x50, 0x02, 0x8d, 0xff, 0xff, 0xc7, 0x10, 0x09, 0xfa, 0x00, 0x00, 0x00,  //......@@+...%@@@@@%+...%@%......
    0x00, 0x00, 0x00, 0x00, 0x01, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x10, 0x00, 0x00, 0x00,  //..........%@@@@@@@@@@+..........
    0x00, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@@@@@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@@@@@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xe8, 0x30, 0x04, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@%....%@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+........+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xbf, 0xea, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............%@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............%@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............%%...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f240 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x10, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xff, 0x31, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x2f, 0xf0, 0x00,  //@@...............................@@...
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@...............................@@...
    0xff, 0x10, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x0f, 0xf1, 0x00,  //@@..+++++++++++++++++++++++++++..@@...
    0xff, 0x10, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0f, 0xf7, 0x10,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@+..
    0xff, 0x10, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0f, 0xff, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@@@.
    0xff, 0x10, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x03, 0x3f, 0xf1,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xff, 0x10, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xff, 0x10, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xff, 0x10, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xff, 0x10, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xff, 0x10, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xff, 0x10, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x03, 0x3f, 0xf2,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xff, 0x10, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0f, 0xff, 0xf0,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@@@.
    0xff, 0x10, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0f, 0xfd, 0x40,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@@+.
    0xff, 0x10, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0f, 0xf1, 0x00,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@...
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@...............................@@...
    0xff, 0x31, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x2f, 0xf0, 0x00,  //@@...............................@@...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f241 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x10, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xff, 0x31, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x2f, 0xf0, 0x00,  //@@...............................@@...
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@...............................@@...
    0xff, 0x10, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x40, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@..+++++++++++++++++++++........@@...
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x0f, 0xf7, 0x10,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@+..
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xc0,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x03, 0x3f, 0xf1,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x03, 0x3f, 0xf2,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x40,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@@+.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@...
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@...............................@@...
    0xff, 0x31, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x2f, 0xf0, 0x00,  //@@...............................@@...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f242 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x10, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xff, 0x31, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x2f, 0xf0, 0x00,  //@@...............................@@...
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@...............................@@...
    0xff, 0x10, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@..++++++++++++++...............@@...
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf7, 0x10,  //@@..@@@@@@@@@@@@@@+..............@@+..
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xc0,  //@@..@@@@@@@@@@@@@@+..............@@@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3f, 0xf1,  //@@..@@@@@@@@@@@@@@+................@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@@@@@@@+................@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@@@@@@@+................@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@@@@@@@+................@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@@@@@@@+................@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@@@@@@@+................@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3f, 0xf2,  //@@..@@@@@@@@@@@@@@+................@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0,  //@@..@@@@@@@@@@@@@@+..............@@@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x40,  //@@..@@@@@@@@@@@@@@+..............@@@+.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@..@@@@@@@@@@@@@@+..............@@...
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@...............................@@...
    0xff, 0x31, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x2f, 0xf0, 0x00,  //@@...............................@@...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f243 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x10, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xff, 0x31, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x2f, 0xf0, 0x00,  //@@...............................@@...
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@...............................@@...
    0xff, 0x10, 0x66, 0x66, 0x66, 0x66, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@..++++++++.....................@@...
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf7, 0x10,  //@@..@@@@@@@@+....................@@+..
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xc0,  //@@..@@@@@@@@+....................@@@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3f, 0xf1,  //@@..@@@@@@@@+......................@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@+......................@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@+......................@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@+......................@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@+......................@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@..@@@@@@@@+......................@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3f, 0xf2,  //@@..@@@@@@@@+......................@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0,  //@@..@@@@@@@@+....................@@@@.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd, 0x40,  //@@..@@@@@@@@+....................@@@+.
    0xff, 0x10, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@..@@@@@@@@+....................@@...
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@...............................@@...
    0xff, 0x31, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x2f, 0xf0, 0x00,  //@@...............................@@...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f244 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x10, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xff, 0x31, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x2f, 0xf0, 0x00,  //@@...............................@@...
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@...............................@@...
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@...............................@@...
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf5, 0x00,  //@@...............................@@+..
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xa0,  //@@...............................@@@%.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3f, 0xf1,  //@@.................................@@.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@.................................@@.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@.................................@@.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@.................................@@.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@.................................@@.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2,  //@@.................................@@.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3f, 0xf2,  //@@.................................@@.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0,  //@@...............................@@@@.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe, 0x50,  //@@...............................@@@+.
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@...............................@@...
    0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00,  //@@...............................@@...
    0xff, 0x31, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x2f, 0xf0, 0x00,  //@@...............................@@...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f293 () , Width: 22 */
    0x00, 0x00, 0x00, 0x5a, 0xde, 0xff, 0xeb, 0x82, 0x00, 0x00, 0x00,  //......+%@@@@@%%.......
    0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x00, 0x00,  //....+@@@@@@@@@@@%.....
    0x00, 0x08, 0xff, 0xff, 0xfc, 0xbf, 0xff, 0xff, 0xfe, 0x20, 0x00,  //...%@@@@@@%@@@@@@@....
    0x00, 0x6f, 0xff, 0xff, 0xfb, 0x0b, 0xff, 0xff, 0xff, 0xe0, 0x00,  //..+@@@@@@%.%@@@@@@@...
    0x01, 0xff, 0xff, 0xff, 0xfb, 0x00, 0xbf, 0xff, 0xff, 0xf9, 0x00,  //..@@@@@@@%..%@@@@@@%..
    0x08, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x0b, 0xff, 0xff, 0xff, 0x10,  //.%@@@@@@@%...%@@@@@@..
    0x0e, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x70,  //.@@@@@@@@%....%@@@@@+.
    0x3f, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x50, 0x0a, 0xff, 0xff, 0xb0,  //.@@@@@@@@%..+..%@@@@%.
    0x7f, 0xff, 0xd1, 0xaf, 0xfb, 0x00, 0xf5, 0x00, 0xaf, 0xff, 0xf0,  //+@@@@.%@@%..@+..%@@@@.
    0x9f, 0xff, 0x60, 0x0a, 0xfb, 0x00, 0xff, 0x20, 0x0d, 0xff, 0xf2,  //%@@@+..%@%..@@...@@@@.
    0xcf, 0xff, 0xf5, 0x00, 0xab, 0x00, 0xf7, 0x00, 0x8f, 0xff, 0xf4,  //%@@@@+..%%..@+..%@@@@+
    0xdf, 0xff, 0xff, 0x50, 0x06, 0x00, 0x70, 0x08, 0xff, 0xff, 0xf6,  //@@@@@@+..+..+..%@@@@@+
    0xef, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0xf7,  //@@@@@@@+......%@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x08, 0xff, 0xff, 0xff, 0xf7,  //@@@@@@@@+....%@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x00, 0x4f, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@...+@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x08, 0xff, 0xff, 0xff, 0xf7,  //@@@@@@@@+....%@@@@@@@+
    0xef, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0xf7,  //@@@@@@@+......%@@@@@@+
    0xdf, 0xff, 0xff, 0x50, 0x06, 0x00, 0x70, 0x08, 0xff, 0xff, 0xf6,  //@@@@@@+..+..+..%@@@@@+
    0xcf, 0xff, 0xf5, 0x00, 0xab, 0x00, 0xf7, 0x00, 0x8f, 0xff, 0xf4,  //%@@@@+..%%..@+..%@@@@+
    0x9f, 0xff, 0x60, 0x0a, 0xfb, 0x00, 0xff, 0x20, 0x0d, 0xff, 0xf2,  //%@@@+..%@%..@@...@@@@.
    0x7f, 0xff, 0xd1, 0xaf, 0xfb, 0x00, 0xf5, 0x00, 0xaf, 0xff, 0xf0,  //+@@@@.%@@%..@+..%@@@@.
    0x3f, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x50, 0x0a, 0xff, 0xff, 0xb0,  //.@@@@@@@@%..+..%@@@@%.
    0x0e, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00, 0xaf, 0xff, 0xff, 0x70,  //.@@@@@@@@%....%@@@@@+.
    0x08, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x0b, 0xff, 0xff, 0xff, 0x10,  //.%@@@@@@@%...%@@@@@@..
    0x01, 0xff, 0xff, 0xff, 0xfb, 0x00, 0xbf, 0xff, 0xff, 0xf9, 0x00,  //..@@@@@@@%..%@@@@@@%..
    0x00, 0x6f, 0xff, 0xff, 0xfb, 0x0b, 0xff, 0xff, 0xff, 0xe0, 0x00,  //..+@@@@@@%.%@@@@@@@...
    0x00, 0x08, 0xff, 0xff, 0xfc, 0xbf, 0xff, 0xff, 0xfe, 0x20, 0x00,  //...%@@@@@@%@@@@@@@....
    0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x00, 0x00,  //....+@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x5a, 0xde, 0xff, 0xec, 0x82, 0x00, 0x00, 0x00,  //......+%@@@@@%%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................



#elif USE_LV_FONT_SYMBOL_30 == 8
    /*Unicode: U+f001 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x48, 0x94, 0xba, 0x4c,  //.....................+%%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x60, 0xae, 0xf2, 0xff, 0xff, 0xff, 0xee,  //..................+%@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x7a, 0xc8, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...............+@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x48, 0x94, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...........+%@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xae, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.........%@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //........@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //........@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //........@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0xff, 0xff,  //........@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xbc, 0x70, 0x24, 0x12, 0xff, 0xff,  //........@@@@@@@@@@@%+..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0xa2, 0x56, 0x0e, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //........@@@@@@@@%+.....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x88, 0x3c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //........@@@@@%.........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x76, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //........@@+............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //........@@.............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //........@@.............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //........@@.............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x2c, 0x24, 0x08, 0x12, 0xff, 0xff,  //........@@.............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x06, 0x72, 0xcc, 0xff, 0xff, 0xff, 0xf8, 0xc0, 0xff, 0xff,  //........@@......+@@@@@%@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x02, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //........@@.....@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x46, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //........@@....+@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //........@@.....@@@@@@@@@@
    0x00, 0x44, 0xa2, 0xe8, 0xff, 0xfc, 0xe2, 0x98, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x44,  //.+%@@@@%@@.....%@@@@@@@@+
    0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x98, 0xd8, 0xf4, 0xec, 0xc4, 0x7a, 0x18, 0x00,  //%@@@@@@@@@.......%@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@...............
    0xa6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@+...............
    0x00, 0x5a, 0xb6, 0xf6, 0xff, 0xff, 0xec, 0xa4, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+%@@@@%.................
    0x00, 0x00, 0x00, 0x00, 0x16, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f008 () , Width: 32 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x18, 0xb2, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xba, 0x1e, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xf6, 0xff, 0x5a, 0x0e, 0x0e, 0x4a, 0xff, 0xff, 0x64, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x66, 0xff, 0xff, 0x4a, 0x0e, 0x0e, 0x4a, 0xff, 0xff, 0x0a,  //@@+..+@@+.............+@@+..+@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@....@@...............@@....@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@....@@...............@@....@@.
    0xff, 0xff, 0x4a, 0x00, 0x00, 0x38, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x38, 0x00, 0x00, 0x38, 0xff, 0xff, 0x12,  //@@+...@@...............@@....@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x12,  //@@@@@@@@...............@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x12,  //@@@@@@@@...............@@@@@@@@.
    0xff, 0xff, 0x6a, 0x12, 0x12, 0x5a, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x5a, 0x12, 0x12, 0x5a, 0xff, 0xff, 0x12,  //@@+..+@@...............@@+..+@@.
    0xff, 0xff, 0x14, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@....@@...............@@....@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@....@@...............@@....@@.
    0xff, 0xff, 0x14, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@....@@...............@@....@@.
    0xff, 0xff, 0x6a, 0x12, 0x12, 0x5a, 0xff, 0xff, 0x64, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x68, 0xff, 0xff, 0x5a, 0x12, 0x12, 0x5a, 0xff, 0xff, 0x12,  //@@+..+@@+.............+@@+..+@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x12,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x12,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0x4c, 0x00, 0x00, 0x3a, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x3a, 0xff, 0xff, 0x12,  //@@+...@@+.............+@@....@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@....@@...............@@....@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@....@@...............@@....@@.
    0xff, 0xff, 0x5a, 0x0e, 0x0e, 0x4a, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x4a, 0x0e, 0x0e, 0x4a, 0xff, 0xff, 0x12,  //@@+..+@@...............@@+..+@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x12,  //@@@@@@@@...............@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x12,  //@@@@@@@@...............@@@@@@@@.
    0xff, 0xff, 0x4c, 0x00, 0x00, 0x3a, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x3a, 0xff, 0xff, 0x12,  //@@+...@@...............@@....@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@....@@...............@@....@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@....@@...............@@....@@.
    0xf6, 0xff, 0x4c, 0x00, 0x00, 0x3a, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x3a, 0xff, 0xff, 0x0c,  //@@+...@@+.............+@@....@@.
    0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x1e, 0xc2, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x26, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x08, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x08, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f00b () , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x7e, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xba, 0x06, 0x00, 0x36, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x7e,  //+@@@@@@%...@@@@@@@@@@@@@@@@@+
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0x00, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@..%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x44, 0x00, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xac, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x10, 0x00, 0x52, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac,  //%@@@@@@@..+@@@@@@@@@@@@@@@@@%
    0x00, 0x2a, 0x32, 0x32, 0x32, 0x32, 0x30, 0x0a, 0x00, 0x00, 0x00, 0x1a, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x2a, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x02, 0x2e, 0x36, 0x36, 0x36, 0x36, 0x34, 0x0c, 0x00, 0x00, 0x00, 0x1e, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x2e, 0x02,  //.............................
    0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x10, 0x00, 0x54, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xae,  //%@@@@@@@..+@@@@@@@@@@@@@@@@@%
    0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x44, 0x00, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0x00, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@..%@@@@@@@@@@@@@@@@@@
    0x7e, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xba, 0x06, 0x00, 0x36, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x7e,  //+@@@@@@%...@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x02, 0x2e, 0x36, 0x36, 0x36, 0x36, 0x34, 0x0c, 0x00, 0x00, 0x00, 0x1e, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x2e, 0x02,  //.............................
    0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x10, 0x00, 0x54, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xae,  //%@@@@@@@..+@@@@@@@@@@@@@@@@@%
    0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x44, 0x00, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@+.%@@@@@@@@@@@@@@@@@@
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0x00, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@..%@@@@@@@@@@@@@@@@@@
    0x7e, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xba, 0x06, 0x00, 0x36, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x7e,  //+@@@@@@%...@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f00c () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x62, 0x0c, 0x00, 0x00,  //.....................+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0xce, 0x12, 0x00,  //...................+@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0xff, 0xff, 0xce, 0x12,  //..................+@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2,  //.................+@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //................+@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x78,  //...............+@@@@@@@@+
    0x00, 0x00, 0x1c, 0x86, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00,  //...%+.........+@@@@@@@@+.
    0x00, 0x22, 0xe2, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00,  //..@@@+.......+@@@@@@@@+..
    0x22, 0xe2, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00,  //.@@@@@+.....+@@@@@@@@+...
    0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@+...+@@@@@@@@+....
    0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x52, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@+.+@@@@@@@@+.....
    0x5a, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@%@@@@@@@@+......
    0x00, 0x5c, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@@@@@@@@@@@+.......
    0x00, 0x00, 0x5c, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@@@@@@@@+........
    0x00, 0x00, 0x00, 0x5c, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x5c, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xfc, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xb6, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+%+..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f00d () , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x8c, 0xf2, 0x9c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xbe, 0xee, 0x62, 0x00, 0x00,  //...%@%.........%@+..
    0x00, 0x00, 0x98, 0xff, 0xff, 0xff, 0xa8, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xce, 0xff, 0xff, 0xfc, 0x64, 0x00,  //..%@@@%.......@@@@+.
    0x00, 0x96, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa8, 0x02, 0x00, 0x00, 0x00, 0x12, 0xce, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5e,  //.%@@@@@%.....@@@@@@+
    0x26, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa8, 0x02, 0x00, 0x12, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec,  //.@@@@@@@%...@@@@@@@@
    0x0e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa6, 0x16, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //.@@@@@@@@%.@@@@@@@@%
    0x00, 0x32, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x14,  //..@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x32, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x14, 0x00,  //...@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x32, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x14, 0x00, 0x00,  //....@@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x32, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x14, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x18, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x12, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0x02, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x12, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0x02, 0x00, 0x00,  //....@@@@@@@@@@@@%...
    0x00, 0x00, 0x10, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0x02, 0x00,  //...@@@@@@@@@@@@@@%..
    0x00, 0x10, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0x02,  //..@@@@@@@@@@@@@@@@%.
    0x04, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x46, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x96,  //.@@@@@@@@@+@@@@@@@@%
    0x2a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x14, 0x00, 0x30, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,  //.@@@@@@@@...@@@@@@@@
    0x02, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x14, 0x00, 0x00, 0x00, 0x30, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //.@@@@@@@.....@@@@@@%
    0x00, 0x0e, 0xc6, 0xff, 0xff, 0xff, 0xd2, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xec, 0xff, 0xff, 0xff, 0x9e, 0x00,  //..@@@@@.......@@@@%.
    0x00, 0x00, 0x0e, 0xc4, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xea, 0xff, 0x9c, 0x00, 0x00,  //...@@@.........@@%..
    0x00, 0x00, 0x00, 0x02, 0x2e, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x2a, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+f011 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xdc, 0xe6, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0xf4, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x0c, 0x82, 0x9e, 0x36, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x26, 0x98, 0x8e, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%%...@@@@...%%......
    0x00, 0x00, 0x00, 0x1c, 0xd2, 0xff, 0xff, 0xf2, 0x14, 0x00, 0xff, 0xff, 0xff, 0xff, 0x22, 0x04, 0xde, 0xff, 0xff, 0xe4, 0x2e, 0x00, 0x00, 0x00, 0x00,  //....@@@@..@@@@..@@@@.....
    0x00, 0x00, 0x14, 0xd8, 0xff, 0xff, 0xff, 0xff, 0x3a, 0x00, 0xff, 0xff, 0xff, 0xff, 0x22, 0x16, 0xff, 0xff, 0xff, 0xff, 0xea, 0x24, 0x00, 0x00, 0x00,  //...@@@@@..@@@@..@@@@@....
    0x00, 0x00, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x06, 0x00, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x06, 0x00, 0x00,  //..%@@@@@..@@@@..%@@@@@...
    0x00, 0x5c, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x1a, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x0e, 0xc2, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00,  //.+@@@@@...@@@@...@@@@@+..
    0x00, 0xdc, 0xff, 0xff, 0xff, 0xe2, 0x14, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x08, 0xce, 0xff, 0xff, 0xff, 0xf0, 0x0c, 0x00,  //.@@@@@....@@@@....@@@@@..
    0x48, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x30, 0xfa, 0xff, 0xff, 0xff, 0x68, 0x00,  //+@@@@+....@@@@.....@@@@+.
    0x94, 0xff, 0xff, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0xff, 0xb8, 0x00,  //%@@@@.....@@@@.....%@@@%.
    0xcc, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0xff, 0xff, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0xff, 0xff, 0xee, 0x00,  //@@@@+.....@@@@.....+@@@@.
    0xee, 0xff, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xff, 0xff, 0x10,  //@@@@+.....%@@@......@@@@.
    0xfa, 0xff, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x5c, 0x66, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0x1e,  //@@@@.......++.......@@@@.
    0xea, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xff, 0xff, 0x0c,  //@@@@................@@@@.
    0xd0, 0xff, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xff, 0xf4, 0x00,  //@@@@+...............@@@@.
    0xa4, 0xff, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0xc6, 0x00,  //%@@@%..............%@@@@.
    0x56, 0xff, 0xff, 0xff, 0xf8, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xe8, 0xff, 0xff, 0xff, 0x7a, 0x00,  //+@@@@..............@@@@+.
    0x0c, 0xf0, 0xff, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xff, 0xfc, 0x26, 0x00,  //.@@@@%............%@@@@..
    0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xff, 0xff, 0xa4, 0x00, 0x00,  //.+@@@@+..........+@@@@%..
    0x00, 0x0c, 0xe6, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x82, 0xfc, 0xff, 0xff, 0xff, 0xf4, 0x22, 0x00, 0x00,  //..@@@@@%........%@@@@@...
    0x00, 0x00, 0x3c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xec, 0x8e, 0x42, 0x20, 0x1e, 0x3a, 0x82, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00,  //...@@@@@@%+...%@@@@@@+...
    0x00, 0x00, 0x00, 0x5e, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@+....
    0x00, 0x00, 0x00, 0x00, 0x42, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x98, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@@@@@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x72, 0xc2, 0xea, 0xfc, 0xff, 0xee, 0xca, 0x7e, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f013 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x38, 0xb4, 0x32, 0x00, 0x00, 0x42, 0xff, 0xff, 0xff, 0xff, 0xff, 0x38, 0x00, 0x00, 0x32, 0xb4, 0x30, 0x00, 0x00, 0x00, 0x00,  //.....%...+@@@@@....%.....
    0x00, 0x00, 0x00, 0x42, 0xf4, 0xff, 0xf6, 0x62, 0x18, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x18, 0x6a, 0xf8, 0xff, 0xee, 0x36, 0x00, 0x00, 0x00,  //...+@@@+.%@@@@@%.+@@@....
    0x00, 0x00, 0x36, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xee, 0x2c, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@@@...
    0x00, 0x00, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x00, 0x00,  //..%@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0x2a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x24, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x1a, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x6a, 0x4c, 0x6a, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x1a, 0x00, 0x00, 0x00,  //....@@@@@@@+++@@@@@@@....
    0x00, 0x18, 0x40, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9a, 0x30, 0x08, 0x00,  //...%@@@@@%.....%@@@@@%...
    0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xcc,  //@@@@@@@@@.......@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@+.......+@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@+.......+@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@+.......+@@@@@@@@
    0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6,  //@@@@@@@@@.......@@@@@@@@@
    0x00, 0x16, 0x3c, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x4c, 0x24, 0x02,  //...%@@@@@%.....%@@@@@%+..
    0x00, 0x00, 0x00, 0x1e, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x58, 0x3c, 0x58, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x24, 0x00, 0x00, 0x00,  //....@@@@@@%+.+%@@@@@@....
    0x00, 0x00, 0x00, 0x44, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@+...
    0x00, 0x00, 0x1c, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x24, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@@@...
    0x00, 0x00, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x00, 0x00,  //..%@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0x38, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x40, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x44, 0xf4, 0xff, 0xfc, 0x7e, 0x2a, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x28, 0x78, 0xfa, 0xff, 0xfa, 0x50, 0x00, 0x00, 0x00,  //...+@@@+.%@@@@@%.+@@@+...
    0x00, 0x00, 0x00, 0x00, 0x3a, 0xc6, 0x40, 0x00, 0x00, 0x3c, 0xff, 0xff, 0xff, 0xff, 0xff, 0x44, 0x00, 0x00, 0x42, 0xc8, 0x46, 0x00, 0x00, 0x00, 0x00,  //.....@....@@@@@+..+@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xff, 0xff, 0xff, 0xe8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x12, 0x12, 0x12, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f014 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@@@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0x76, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0xaa, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@+.....%@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xee, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xf6, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@.......@@......
    0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4,  //@@@@@@@@@@@@@@@@@@@@@@%
    0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba,  //@@@@@@@@@@@@@@@@@@@@@@%
    0x08, 0x0e, 0xec, 0xff, 0x30, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x64, 0xff, 0xba, 0x0e, 0x04,  //..@@..............+@%..
    0x00, 0x00, 0xea, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xb6, 0x00, 0x00,  //..@@..............+@%..
    0x00, 0x00, 0xea, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xb6, 0x00, 0x00,  //..@@..............+@%..
    0x00, 0x00, 0xea, 0xff, 0x22, 0x00, 0x34, 0x58, 0x08, 0x00, 0x26, 0x5a, 0x12, 0x00, 0x1a, 0x5a, 0x1e, 0x00, 0x5a, 0xff, 0xb6, 0x00, 0x00,  //..@@...+...+...+..+@%..
    0x00, 0x00, 0xea, 0xff, 0x22, 0x00, 0xc4, 0xff, 0x44, 0x00, 0xa0, 0xff, 0x68, 0x00, 0x7c, 0xff, 0x8c, 0x00, 0x5a, 0xff, 0xb6, 0x00, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0x00, 0xea, 0xff, 0x22, 0x00, 0xc6, 0xff, 0x46, 0x00, 0xa2, 0xff, 0x6a, 0x00, 0x7e, 0xff, 0x8e, 0x00, 0x5a, 0xff, 0xb6, 0x00, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0x00, 0xea, 0xff, 0x22, 0x00, 0xc6, 0xff, 0x46, 0x00, 0xa2, 0xff, 0x6a, 0x00, 0x7e, 0xff, 0x8e, 0x00, 0x5a, 0xff, 0xb6, 0x00, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0x00, 0xea, 0xff, 0x22, 0x00, 0xc6, 0xff, 0x46, 0x00, 0xa2, 0xff, 0x6a, 0x00, 0x7e, 0xff, 0x8e, 0x00, 0x5a, 0xff, 0xb6, 0x00, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0x00, 0xea, 0xff, 0x22, 0x00, 0xc6, 0xff, 0x46, 0x00, 0xa2, 0xff, 0x6a, 0x00, 0x7e, 0xff, 0x8e, 0x00, 0x5a, 0xff, 0xb6, 0x00, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0x00, 0xea, 0xff, 0x22, 0x00, 0xc6, 0xff, 0x46, 0x00, 0xa2, 0xff, 0x6a, 0x00, 0x7e, 0xff, 0x8e, 0x00, 0x5a, 0xff, 0xb6, 0x00, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0x00, 0xea, 0xff, 0x22, 0x00, 0xc6, 0xff, 0x46, 0x00, 0xa2, 0xff, 0x6a, 0x00, 0x7e, 0xff, 0x8e, 0x00, 0x5a, 0xff, 0xb6, 0x00, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0x00, 0xea, 0xff, 0x22, 0x00, 0xc6, 0xff, 0x46, 0x00, 0xa2, 0xff, 0x6a, 0x00, 0x7e, 0xff, 0x8e, 0x00, 0x5a, 0xff, 0xb6, 0x00, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0x00, 0xea, 0xff, 0x22, 0x00, 0xc6, 0xff, 0x46, 0x00, 0xa2, 0xff, 0x6a, 0x00, 0x7e, 0xff, 0x8e, 0x00, 0x5a, 0xff, 0xb6, 0x00, 0x00,  //..@@..@@+.%@+.+@%.+@%..
    0x00, 0x00, 0xea, 0xff, 0x22, 0x00, 0xb4, 0xfc, 0x36, 0x00, 0x90, 0xff, 0x58, 0x00, 0x6c, 0xff, 0x7a, 0x00, 0x5a, 0xff, 0xb6, 0x00, 0x00,  //..@@..%@..%@+.+@+.+@%..
    0x00, 0x00, 0xea, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xb6, 0x00, 0x00,  //..@@..............+@%..
    0x00, 0x00, 0xe8, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xb4, 0x00, 0x00,  //..@@..............+@%..
    0x00, 0x00, 0xce, 0xff, 0x56, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8e, 0xff, 0x96, 0x00, 0x00,  //..@@+.............%@%..
    0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0x00, 0x00,  //..+@@@@@@@@@@@@@@@@@...
    0x00, 0x00, 0x06, 0xa2, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x74, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x06, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x02, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f015 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xb8, 0x78, 0x02, 0x00, 0x00, 0x0c, 0xae, 0xb6, 0xb6, 0xa2, 0x00, 0x00, 0x00, 0x00,  //............+%+....%%%%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xb0, 0xff, 0xff, 0xff, 0xba, 0x12, 0x00, 0x22, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...........%@@@%...@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x2c, 0x22, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@@@..@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xe8, 0xff, 0xff, 0xca, 0x34, 0xc8, 0xff, 0xff, 0xf4, 0x78, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.........@@@@.@@@@+@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xf8, 0xff, 0xff, 0xa8, 0x0c, 0x5e, 0x0c, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......+@@@%.+.%@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0x80, 0x14, 0xbe, 0xff, 0xbe, 0x14, 0x76, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //......%@@@+.%@%.+@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x0c, 0xb2, 0xff, 0xff, 0xf4, 0x56, 0x2e, 0xde, 0xff, 0xff, 0xff, 0xde, 0x2e, 0x4a, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....%@@@+.@@@@@.+@@@@@....
    0x00, 0x00, 0x00, 0x20, 0xd2, 0xff, 0xff, 0xe4, 0x34, 0x56, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x56, 0x28, 0xda, 0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00,  //....@@@@.+@@@@@@@+.@@@@....
    0x00, 0x00, 0x3c, 0xea, 0xff, 0xff, 0xca, 0x1c, 0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86, 0x12, 0xba, 0xff, 0xff, 0xf6, 0x58, 0x00, 0x00,  //...@@@@.%@@@@@@@@@%.%@@@+..
    0x00, 0x60, 0xf8, 0xff, 0xff, 0xaa, 0x18, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x12, 0x92, 0xff, 0xff, 0xff, 0x84, 0x00,  //.+@@@%.%@@@@@@@@@@@%.%@@@%.
    0x5e, 0xff, 0xff, 0xff, 0x80, 0x28, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x26, 0x62, 0xf8, 0xff, 0xff, 0x8a,  //+@@@+.@@@@@@@@@@@@@@@.+@@@%
    0x24, 0xee, 0xf4, 0x56, 0x4c, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x4c, 0x3c, 0xe8, 0xfa, 0x44,  //.@@++@@@@@@@@@@@@@@@@@+.@@+
    0x00, 0x32, 0x2e, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x1c, 0x44, 0x00,  //....@@@@@@@@@@@@@@@@@@@..+.
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0xc6, 0xc6, 0xc6, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@.....@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00, 0x00,  //....%@@@@@@.....@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f019 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xb2, 0xb6, 0xb6, 0xb6, 0xb0, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%%%%%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x6c, 0x6e, 0x6e, 0x6e, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x6e, 0x6e, 0x6e, 0x6a, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,  //......++++@@@@@@%++++......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0xff, 0xff, 0xf4, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@@...........
    0x00, 0x1a, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x04, 0x00, 0x50, 0xfa, 0xff, 0xf2, 0x3e, 0x00, 0x06, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1a, 0x00,  //...........+@@@............
    0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x06, 0x00, 0x4e, 0xc8, 0x3c, 0x00, 0x0a, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //%@@@@@@@@%..+@...%@@@@@@@@%
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x08, 0x00, 0x00, 0x00, 0x0e, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@@@@@@@@%.....@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x5c, 0x36, 0x60, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@+.+@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x12, 0x50, 0xff, 0xff, 0x36, 0x46, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@.+@@.+@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x26, 0x62, 0xff, 0xff, 0x4a, 0x58, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@.+@@++@@
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x82, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x82,  //%@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f01c () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x5e, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x40, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x08, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0x90, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0xb0, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00,  //...@@@%...........%@@%...
    0x00, 0x00, 0x3e, 0xff, 0xff, 0xfc, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xfa, 0x1a, 0x00, 0x00,  //...@@@............+@@@...
    0x00, 0x00, 0xaa, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0x84, 0x00, 0x00,  //..%@@%.............@@@%..
    0x00, 0x1a, 0xfa, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xe8, 0x06, 0x00,  //..@@@+.............+@@@..
    0x00, 0x84, 0xff, 0xff, 0xde, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf4, 0xff, 0xff, 0x5e, 0x00,  //.%@@@...............@@@+.
    0x06, 0xe8, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xca, 0x00,  //.@@@+...............%@@@.
    0x5e, 0xff, 0xff, 0xf6, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xff, 0xff, 0x38,  //+@@@.................@@@.
    0xbc, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0xff, 0x96,  //%@@%.................@@@%
    0xf0, 0xff, 0xff, 0x86, 0x52, 0x52, 0x52, 0x52, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x52, 0x52, 0x52, 0x52, 0x9e, 0xff, 0xff, 0xcc,  //@@@%++++.........++++%@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@%.......@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@......+@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x36, 0x36, 0x36, 0x36, 0x36, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@%.....@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x98,  //%@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f021 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x62, 0xa4, 0xda, 0xf2, 0xff, 0xee, 0xd4, 0x9a, 0x4e, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x82, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x6e, 0x06, 0x00, 0x00, 0x1a, 0xd0, 0xbc,  //......%@@@@@@@@@@@+....@%
    0x00, 0x00, 0x00, 0x00, 0x30, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x24, 0x1c, 0xda, 0xff, 0xff,  //.....@@@@@@@@@@@@@@@..@@@
    0x00, 0x00, 0x00, 0x3c, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xe0, 0xff, 0xff, 0xff,  //....@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x28, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xac, 0x5c, 0x2e, 0x1e, 0x30, 0x5a, 0xa6, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@%+...+%@@@@@@@@@
    0x00, 0x06, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xce, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@.........%@@@@@@@
    0x00, 0x72, 0xff, 0xff, 0xff, 0xff, 0xac, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.+@@@@%...........@@@@@@@
    0x08, 0xea, 0xff, 0xff, 0xff, 0xd0, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@...........@@@@@@@@
    0x50, 0xff, 0xff, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //+@@@@...........@@@@@@@@@
    0x9c, 0xff, 0xff, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //%@@@%...........@@@@@@@@@
    0x28, 0x52, 0x52, 0x52, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x24,  //.+++.............+++++++.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x3a, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x6e, 0x6e, 0x6e, 0x2c,  //.++++++++............+++.
    0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0x78,  //@@@@@@@@@+..........@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xff, 0xff, 0x2a,  //@@@@@@@@@...........@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xd6, 0xff, 0xff, 0xff, 0xce, 0x00,  //@@@@@@@@...........@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb0, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00,  //@@@@@@@...........%@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xba, 0x00, 0x00,  //@@@@@@@@.........@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xa8, 0x58, 0x2a, 0x16, 0x26, 0x54, 0xa8, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x18, 0x00, 0x00,  //@@@@@@@@@%+...+%@@@@@@...
    0xff, 0xff, 0xff, 0xe2, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x2c, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@@@....
    0xff, 0xff, 0xde, 0x1e, 0x2e, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x26, 0x00, 0x00, 0x00, 0x00,  //@@@..@@@@@@@@@@@@@@@.....
    0xc6, 0xd8, 0x1e, 0x00, 0x00, 0x0c, 0x82, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x7e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@....%@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x62, 0xae, 0xe4, 0xfa, 0xff, 0xfa, 0xe4, 0xac, 0x66, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f026 () , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xee, 0x34,  //..........+@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0x6a,  //.........%@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0x6a,  //........%@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0xff, 0x6a,  //.......%@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //......%@@@@@+
    0x1e, 0x4a, 0x4a, 0x4a, 0x4a, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //.++++%@@@@@@+
    0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@@@@@@@@@@@+
    0xbc, 0xfa, 0xfa, 0xfa, 0xfa, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //%@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //......@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf4, 0xff, 0xff, 0xff, 0xff, 0x6a,  //.......@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf4, 0xff, 0xff, 0xff, 0x6a,  //........@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf4, 0xff, 0xff, 0x6a,  //.........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf4, 0xff, 0x66,  //..........@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x9e, 0x16,  //...........%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+f027 () , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@+......
    0x1e, 0x4a, 0x4a, 0x4a, 0x4a, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.++++%@@@@@@+......
    0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x06, 0xda, 0xe0, 0x4a, 0x00,  //@@@@@@@@@@@@+..@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x02, 0xd2, 0xff, 0xf8, 0x38,  //@@@@@@@@@@@@+..@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x06, 0xa4, 0xff, 0xb8,  //@@@@@@@@@@@@+...%@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x24, 0xff, 0xf0,  //@@@@@@@@@@@@+....@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xe4,  //@@@@@@@@@@@@+....@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x32, 0xda, 0xff, 0x96,  //@@@@@@@@@@@@+...@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x08, 0xf6, 0xff, 0xdc, 0x14,  //@@@@@@@@@@@@+..@@@.
    0xbc, 0xfa, 0xfa, 0xfa, 0xfa, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x8c, 0x90, 0x14, 0x00,  //%@@@@@@@@@@@+..%%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf4, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf4, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf4, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf4, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x9e, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f028 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0xec, 0x7e, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................+@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xda, 0x32, 0x00, 0x00, 0x00, 0x00,  //...........+......+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xc8, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xdc, 0xff, 0xf4, 0x40, 0x00, 0x00, 0x00,  //..........@@+......+@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xc8, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x20, 0x04, 0x00, 0x08, 0xb8, 0xff, 0xf4, 0x2a, 0x00, 0x00,  //.........@@@+........%@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xca, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xde, 0x4a, 0x00, 0x06, 0xb4, 0xff, 0xd4, 0x06, 0x00,  //........@@@@+....@@+..%@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xca, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x1e, 0xe0, 0xff, 0xff, 0x72, 0x00, 0x10, 0xe8, 0xff, 0x72, 0x00,  //.......@@@@@+....@@@+..@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x08, 0x92, 0xff, 0xff, 0x4e, 0x00, 0x58, 0xff, 0xec, 0x06,  //......@@@@@@+.....%@@+.+@@.
    0x66, 0xa2, 0xa2, 0xa2, 0xa2, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x40, 0x2e, 0x00, 0x00, 0x8a, 0xff, 0xe6, 0x0a, 0x00, 0xd8, 0xff, 0x54,  //+%%%%@@@@@@@+......%@@..@@+
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x24, 0xff, 0xfc, 0x8e, 0x00, 0x04, 0xd6, 0xff, 0x6a, 0x00, 0x82, 0xff, 0x9c,  //@@@@@@@@@@@@+..@@%..@@+.%@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x02, 0x98, 0xfc, 0xff, 0x66, 0x00, 0x6c, 0xff, 0xbc, 0x00, 0x42, 0xff, 0xd2,  //@@@@@@@@@@@@+..%@@+.+@%.+@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xd2, 0x00, 0x2c, 0xff, 0xea, 0x00, 0x1e, 0xff, 0xec,  //@@@@@@@@@@@@+...+@@..@@..@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xf4, 0x00, 0x16, 0xff, 0xfa, 0x00, 0x12, 0xff, 0xfa,  //@@@@@@@@@@@@+....@@..@@..@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xd2, 0x00, 0x2c, 0xff, 0xea, 0x00, 0x1e, 0xff, 0xec,  //@@@@@@@@@@@@+...+@@..@@..@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x02, 0x94, 0xfc, 0xff, 0x66, 0x00, 0x6a, 0xff, 0xbe, 0x00, 0x42, 0xff, 0xd2,  //@@@@@@@@@@@@+..%@@+.+@%.+@@
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x26, 0xff, 0xff, 0x90, 0x00, 0x02, 0xd2, 0xff, 0x6c, 0x00, 0x80, 0xff, 0x9c,  //@@@@@@@@@@@@+..@@%..@@+.+@%
    0x6c, 0xa6, 0xa6, 0xa6, 0xa6, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x44, 0x32, 0x00, 0x00, 0x86, 0xff, 0xe8, 0x0c, 0x00, 0xd8, 0xff, 0x54,  //+%%%%@@@@@@@+..+...%@@..@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x06, 0x8c, 0xff, 0xff, 0x54, 0x00, 0x56, 0xff, 0xec, 0x06,  //......@@@@@@+.....%@@+.+@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xcc, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x1c, 0xdc, 0xff, 0xff, 0x78, 0x00, 0x0e, 0xe6, 0xff, 0x74, 0x00,  //.......@@@@@+....@@@+..@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xcc, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xe0, 0x50, 0x00, 0x04, 0xb2, 0xff, 0xd4, 0x06, 0x00,  //........@@@@+....@@+..%@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xcc, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x24, 0x06, 0x00, 0x08, 0xb4, 0xff, 0xf4, 0x2c, 0x00, 0x00,  //.........@@@+........%@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xca, 0xff, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xda, 0xff, 0xf4, 0x42, 0x00, 0x00, 0x00,  //..........@@+......+@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xdc, 0x32, 0x00, 0x00, 0x00, 0x00,  //...........+......+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xee, 0x80, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................+@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f03e () , Width: 32 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x18, 0xb2, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xba, 0x1e, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@%..
    0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xf6, 0xff, 0x34, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x22, 0xff, 0xff, 0x0a,  //@@...........................@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@...........................@@.
    0xff, 0xff, 0x12, 0x00, 0x02, 0x7c, 0xe0, 0xea, 0x9c, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@...+@@%....................@@.
    0xff, 0xff, 0x12, 0x00, 0x7c, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@..+@@@@%...................@@.
    0xff, 0xff, 0x12, 0x00, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@..@@@@@@...................@@.
    0xff, 0xff, 0x12, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xbc, 0xe2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@..@@@@@@.........%@........@@.
    0xff, 0xff, 0x12, 0x00, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xbe, 0xff, 0xff, 0xe2, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@..%@@@@@........%@@@.......@@.
    0xff, 0xff, 0x12, 0x00, 0x0e, 0xb4, 0xff, 0xff, 0xd4, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@...%@@@........%@@@@@......@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x1a, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x26, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@..............@@@@@@@@.....@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x26, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@.............@@@@@@@@@@....@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x5e, 0x00, 0x00, 0x00, 0x0c, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x28, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@.......+....@@@@@@@@@@@@...@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x22, 0xe2, 0xfc, 0x68, 0x00, 0x0c, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@......@@+..@@@@@@@@@@@@@@..@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x24, 0xe2, 0xff, 0xff, 0xfc, 0x72, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@.....@@@@+@@@@@@@@@@@@@@@..@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@....@@@@@@@@@@@@@@@@@@@@@..@@.
    0xff, 0xff, 0x12, 0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@...@@@@@@@@@@@@@@@@@@@@@@..@@.
    0xff, 0xff, 0x12, 0x00, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@..@@@@@@@@@@@@@@@@@@@@@@@..@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@..@@@@@@@@@@@@@@@@@@@@@@@..@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@..@@@@@@@@@@@@@@@@@@@@@@@..@@.
    0xff, 0xff, 0x12, 0x00, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x80, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@..%%%%%%%%%%%%%%%%%%%%%%+..@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@...........................@@.
    0xf6, 0xff, 0x2a, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x16, 0xff, 0xff, 0x0a,  //@@...........................@@.
    0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x1e, 0xc2, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x26, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x08, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x08, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f040 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x68, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xee, 0xff, 0xfc, 0x72, 0x00, 0x00, 0x00, 0x00,  //.................@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00,  //................@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x76, 0x00, 0x00,  //...............@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0a, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x78, 0x00,  //...............@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xdc, 0x2e, 0x0a, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //.............@..@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xf0, 0xff, 0xea, 0x2e, 0x0a, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x74,  //............@@@..@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xf0, 0xff, 0xda, 0xe4, 0xea, 0x2e, 0x0a, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x2a,  //...........@@@@@..@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xf0, 0xff, 0xd4, 0x3c, 0xe8, 0xff, 0xea, 0x2e, 0x0a, 0xc2, 0xff, 0xff, 0xf8, 0x4c, 0x00,  //..........@@@.@@@..@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xf0, 0xff, 0xd4, 0x3c, 0xe4, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x0a, 0xc2, 0xf8, 0x4c, 0x00, 0x00,  //.........@@@.@@@@@..@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xf0, 0xff, 0xd4, 0x3a, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x0a, 0x3e, 0x00, 0x00, 0x00,  //........@@@.@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xf0, 0xff, 0xd4, 0x3a, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x08, 0x00, 0x00, 0x00, 0x00,  //.......@@@.@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xf0, 0xff, 0xd4, 0x3a, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x38, 0xf0, 0xff, 0xd4, 0x3a, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@.@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x38, 0xf0, 0xff, 0xd4, 0x3a, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@.@@@@@@@@@+.......
    0x00, 0x00, 0x38, 0xf0, 0xff, 0xd4, 0x3a, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@.@@@@@@@@@+........
    0x00, 0x38, 0xf0, 0xff, 0xee, 0x3a, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.@@@@@@@@@+.........
    0x38, 0xf0, 0xff, 0xe8, 0xfc, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@@+..........
    0xf0, 0xff, 0xb6, 0x0a, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@%.%@@@@@@@@+...........
    0xff, 0xff, 0x16, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@...%@@@@@@+............
    0xff, 0xff, 0x28, 0x16, 0x02, 0x00, 0xa0, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@....%@@@@+.............
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x04, 0xde, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@...@@@+..............
    0xff, 0xff, 0xff, 0xff, 0x26, 0x04, 0xa0, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@..%@@+...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@+................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@+.................
    0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f048 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x9a, 0xda, 0xda, 0xb2, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0x72,  //%@@%...........++
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xf8, 0x92,  //@@@@..........+@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xf8, 0xff, 0x92,  //@@@@.........+@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xf8, 0xff, 0xff, 0x92,  //@@@@........+@@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xf8, 0xff, 0xff, 0xff, 0x92,  //@@@@.......+@@@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@......+@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@.....+@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x4e, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@....+@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@...+@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@..+@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@.+@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x70, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@+@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@%@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@.+@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@..+@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@...+@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@....+@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@.....+@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@......+@@@@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@.......+@@@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0x92,  //@@@@........+@@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0x92,  //@@@@.........+@@%
    0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0x92,  //@@@@..........+@%
    0xbe, 0xff, 0xff, 0xd6, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x86,  //%@@@...........+%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f04b () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xcc, 0x76, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+.....................
    0xff, 0xff, 0xde, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+...................
    0xff, 0xff, 0xff, 0xff, 0xc8, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@..................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xae, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x92, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@%..............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x74, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@+............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@+..........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xae, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@%.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x92, 0x12, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x74, 0x06, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x58, 0x00,  //@@@@@@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x98,  //@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xa2, 0x1a,  //@@@@@@@@@@@@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x32, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x4c, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@+....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x6a, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@+......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x86, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@%........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xa4, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@%..........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@+.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x6c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@+...............
    0xff, 0xff, 0xff, 0xff, 0xf6, 0x88, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@%.................
    0xff, 0xff, 0xfc, 0xa6, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%...................
    0xf8, 0xc2, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.....................
    0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f04c () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x9a, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xca, 0x1c, 0x00, 0x00, 0x00, 0x1e, 0xca, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0x9a,  //%@@@@@@@@@.....@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@+...+@@@@@@@@@@
    0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x28, 0x00, 0x00, 0x00, 0x2a, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc,  //%@@@@@@@@@.....@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f04d () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x9a, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0x7a,  //%@@@@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x98,  //%@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f051 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xda, 0xda, 0xb4, 0x04,  //+...........%@@%.
    0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@+..........@@@@.
    0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@+.........@@@@.
    0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@+........@@@@.
    0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@+.......@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@@+......@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@@@+.....@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@@@@+....@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@@@@@+...@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@@@@@@+..@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@@@@@@@+.@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@@@@@@@@+@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@@@@@@@@%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@@@@@@@%.@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@@@@@@%..@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@@@@@%...@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@@@@%....@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@@@%.....@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@@%......@@@@.
    0xff, 0xff, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@@%.......@@@@.
    0xff, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@@%........@@@@.
    0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@@%.........@@@@.
    0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x26,  //@%..........@@@@.
    0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0xd8, 0x0a,  //%...........%@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f052 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xee, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xfc, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@+....
    0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@@@@@@@+...
    0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00, 0x00,  //..+@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x76, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@+.
    0x74, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5c,  //+@@@@@@@@@@@@@@@@@@@@@@@+
    0x7a, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x6c,  //+%%%%%%%%%%%%%%%%%%%%%%%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x12, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x0a,  //.........................
    0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc,  //@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9a,  //%@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f053 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xfc, 0x88, 0x00, 0x00, 0x00,  //............+@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00,  //...........+@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00,  //..........+@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //.........+@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x06,  //........+@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00,  //.......+@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00,  //......+@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00,  //.....+@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@.....
    0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@......
    0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@@@.......
    0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@@@@........
    0x54, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@.........
    0x46, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@.........
    0x00, 0x60, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@@@@........
    0x00, 0x00, 0x60, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@@@.......
    0x00, 0x00, 0x00, 0x60, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x60, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00, 0x00,  //.....+@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00, 0x00,  //......+@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x14, 0x00,  //.......+@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0a,  //........+@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2c,  //.........+@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00,  //..........+@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xfc, 0xff, 0xff, 0x72, 0x00, 0x00,  //...........+@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xf0, 0x70, 0x00, 0x00, 0x00,  //............+@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f054 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x0c, 0xc2, 0xee, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.............
    0x00, 0x0c, 0xc4, 0xff, 0xff, 0xf2, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@............
    0x0c, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@...........
    0x78, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@..........
    0x26, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@.........
    0x00, 0x2c, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@........
    0x00, 0x00, 0x2c, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@.......
    0x00, 0x00, 0x00, 0x2c, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x2c, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x3c, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x3c, 0x00, 0x00, 0x00,  //......@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x3c, 0x00, 0x00,  //.......@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x3c, 0x00,  //........@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x16,  //.........@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x12,  //.........@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x2c, 0x00,  //........@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x2c, 0x00, 0x00,  //.......@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x2c, 0x00, 0x00, 0x00,  //......@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x2c, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@.....
    0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@......
    0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@.......
    0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@........
    0x32, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@.........
    0x74, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@..........
    0x06, 0xb2, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@@...........
    0x00, 0x06, 0xb2, 0xff, 0xff, 0xe8, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@............
    0x00, 0x00, 0x06, 0xac, 0xe0, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f067 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xb2, 0xc6, 0xc6, 0xc6, 0x9e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x1e, 0x76, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x6e, 0x0c,  //.+++++++@@@@@@%+++++++.
    0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9e,  //@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2,  //@@@@@@@@@@@@@@@@@@@@@@%
    0x44, 0xae, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xa6, 0x24,  //+%%%%%%%@@@@@@@%%%%%%%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xea, 0xff, 0xff, 0xff, 0xd6, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f068 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x02, 0x2e, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x26, 0x00,  //.......................
    0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x76,  //%@@@@@@@@@@@@@@@@@@@@@+
    0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe,  //@@@@@@@@@@@@@@@@@@@@@@%
    0x7e, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x50,  //+@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f071 () , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xa8, 0xf6, 0xa8, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............%@%.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............%@@@%............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf4, 0xff, 0xff, 0xff, 0xf4, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xff, 0x7e, 0x46, 0x46, 0x46, 0x7e, 0xff, 0xff, 0xff, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@+++++@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xd8, 0xff, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x32, 0xff, 0xff, 0xff, 0xd8, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@.....@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@.....@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xe6, 0xff, 0xff, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@+...+@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@+...+@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x52, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@@+...+@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@+...+@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x24, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x22, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@+...+@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86, 0x0e, 0x0e, 0x0e, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00,  //....%@@@@@@@%...%@@@@@@@%....
    0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@@@@@@@%...
    0x00, 0x00, 0x4a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x48, 0x00, 0x00,  //..+@@@@@@@@@+...+@@@@@@@@@+..
    0x00, 0x00, 0xd2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //..@@@@@@@@@@+...+@@@@@@@@@@..
    0x00, 0x60, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5e, 0x00,  //.+@@@@@@@@@@+...+@@@@@@@@@@+.
    0x06, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x12, 0x12, 0x12, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x06,  //.@@@@@@@@@@@%...%@@@@@@@@@@@.
    0x76, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x74,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x48, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x46,  //+@@@@@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x02, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x02, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f074 () , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xfc, 0x5c, 0x00, 0x00, 0x00, 0x00,  //.......................@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xfc, 0x5c, 0x00, 0x00, 0x00,  //.......................@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xfc, 0x5e, 0x00, 0x00,  //.......................@@@+..
    0xa2, 0xb6, 0xb6, 0xb6, 0xaa, 0x8c, 0x50, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x66, 0x9e, 0xb2, 0xb6, 0xb6, 0xb6, 0xc6, 0xff, 0xff, 0xff, 0xfc, 0x5e, 0x00,  //%%%%%%+.........+%%%%%@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x50, 0x00, 0x00, 0x00, 0x00, 0x04, 0x8c, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x60,  //@@@@@@@@+.....%@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x06, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde,  //@@@@@@@@@+...%@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0x00, 0xaa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x2a,  //@@@@@@@@@@+.%@@@@@@@@@@@@@@@.
    0x58, 0x6a, 0x6a, 0x6a, 0x7c, 0xb8, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x62, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x98, 0x6e, 0x6a, 0x6a, 0x6a, 0x8a, 0xff, 0xff, 0xff, 0xe8, 0x2a, 0x00,  //+++++%@@@@++@@@@@%++++%@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xf8, 0xff, 0xdc, 0x10, 0xea, 0xff, 0xff, 0xff, 0xe6, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xe8, 0x2a, 0x00, 0x00,  //......+@@@.@@@@@.......@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0x62, 0x7c, 0xff, 0xff, 0xff, 0xfc, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xe8, 0x2a, 0x00, 0x00, 0x00,  //.......+@++@@@@........@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xbe, 0x10, 0xec, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xe4, 0x28, 0x00, 0x00, 0x00, 0x00,  //........%.@@@@%........@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x6a, 0xff, 0xff, 0xff, 0xfc, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@%...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xff, 0xff, 0x3a, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xff, 0xff, 0xc6, 0x22, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xd6, 0x20, 0x00, 0x00, 0x00, 0x00,  //........@@@@@.%........@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0xff, 0xff, 0x4e, 0x94, 0xfc, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xe0, 0x20, 0x00, 0x00, 0x00,  //.......+@@@@+%@........@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf6, 0xff, 0xff, 0xff, 0xc8, 0x1c, 0xf6, 0xff, 0xdc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xe0, 0x20, 0x00, 0x00,  //.......@@@@@.@@@.......@@@...
    0x4c, 0x5e, 0x5e, 0x5e, 0x6e, 0xa4, 0xfc, 0xff, 0xff, 0xff, 0xfa, 0x34, 0x9c, 0xff, 0xff, 0xff, 0xf4, 0x96, 0x68, 0x5e, 0x5e, 0x5e, 0x82, 0xff, 0xff, 0xff, 0xe0, 0x22, 0x00,  //+++++%@@@@@.%@@@@%++++%@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x78, 0x00, 0xac, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x22,  //@@@@@@@@@@+.%@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x96, 0x00, 0x00, 0x0c, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@%...@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x72, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x98, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e,  //@@@@@@@@+.....%@@@@@@@@@@@@@+
    0xb0, 0xc2, 0xc2, 0xc2, 0xbc, 0xa2, 0x60, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x74, 0xa6, 0xc0, 0xc8, 0xc8, 0xc6, 0xd0, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00,  //%@@@%%+.........+%%@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0x6c, 0x00, 0x00,  //.......................@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00,  //.......................@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00,  //.......................@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f077 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xd8, 0xe2, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xda, 0xff, 0xff, 0xe6, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xda, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x1c, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x1c, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x3e, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x28, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@+.@@@@@@@@.....
    0x00, 0x00, 0x1c, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x3e, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x28, 0x00, 0x00, 0x00,  //...@@@@@@@@+...@@@@@@@@....
    0x00, 0x1c, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x28, 0x00, 0x00,  //..@@@@@@@@+.....@@@@@@@@...
    0x1c, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x28, 0x00,  //.@@@@@@@@+.......@@@@@@@@..
    0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x04,  //@@@@@@@@+.........@@@@@@@@.
    0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x02,  //@@@@@@@+...........@@@@@@@.
    0x10, 0xcc, 0xff, 0xff, 0xff, 0xfa, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf4, 0xff, 0xff, 0xff, 0xda, 0x1a, 0x00,  //.@@@@@+.............@@@@@..
    0x00, 0x10, 0xca, 0xff, 0xfa, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf4, 0xff, 0xd8, 0x1a, 0x00, 0x00,  //..@@@+...............@@@...
    0x00, 0x00, 0x0e, 0x90, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x96, 0x18, 0x00, 0x00, 0x00,  //...%+.................%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f078 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x24, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x28, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x6c, 0xfc, 0xcc, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xbc, 0xff, 0x82, 0x00, 0x00, 0x00,  //..+@@................%@%...
    0x00, 0x6e, 0xff, 0xff, 0xff, 0xcc, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xbc, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00,  //.+@@@@..............%@@@%..
    0x6c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00,  //+@@@@@@............%@@@@@%.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0a,  //@@@@@@@@..........%@@@@@@@.
    0x66, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c, 0x00,  //+@@@@@@@@........%@@@@@@@+.
    0x00, 0x68, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x10, 0x00, 0x00, 0x00, 0x00, 0x08, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00,  //.+@@@@@@@@......%@@@@@@@+..
    0x00, 0x00, 0x68, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x10, 0x00, 0x00, 0x08, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00,  //..+@@@@@@@@....%@@@@@@@+...
    0x00, 0x00, 0x00, 0x68, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x10, 0x08, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@..%@@@@@@@+....
    0x00, 0x00, 0x00, 0x00, 0x66, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@%@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xfc, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xfc, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+@@+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............++.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f079 () , Width: 32 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xe4, 0x2a, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@...%@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xdc, 0x12, 0x00, 0x16, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@@...@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x04, 0x00, 0x2e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@...@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x38, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x4e, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@%..+@@@@@@@@@@@@@@.....
    0x00, 0x1c, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x74, 0x00, 0x00, 0x14, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x50, 0xff, 0xff, 0xff, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@+...........+@@@@.....
    0x0a, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@+...........@@@@.....
    0xaa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@...........@@@@.....
    0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@+..........@@@@.....
    0x1a, 0x42, 0x42, 0x42, 0xe4, 0xff, 0xff, 0xff, 0x76, 0x42, 0x42, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+++@@@@+++............@@@@.....
    0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@+..............@@@@.....
    0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x46, 0x46, 0x6e, 0xff, 0xff, 0xff, 0xf2, 0x46, 0x46, 0x46, 0x20, 0x00,  //....@@@@+...........+++@@@@+++..
    0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x06,  //....@@@@+.........+@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x00,  //....@@@@+..........@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x10, 0x00,  //....@@@@+...........@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0x60, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1a, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x24, 0x00, 0x00,  //....@@@@+...........+@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x42, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@+..%@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x3e, 0x00, 0x00, 0xb0, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@...%@@@@+....
    0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x20, 0x00, 0x0c, 0xd2, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@...@@@%.....
    0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x96, 0x00, 0x00, 0x1e, 0xdc, 0xb0, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@%...@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f07b () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x1e, 0x94, 0xc2, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xb0, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@@@@%+................
    0x2a, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@@@@%...............
    0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@...............
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@+..............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0x9c, 0x68, 0x06, 0x00,  //@@@@@@@@@@@@@%%%%%%%%%%%+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x0e,  //@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,  //@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x48, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x38,  //+@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x48, 0xcc, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xc6, 0x3c, 0x00,  //.+@@@@@@@@@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f093 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xb0, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............%.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x90, 0x92, 0x92, 0x92, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x92, 0x92, 0x92, 0x8e, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%%%%@@@@@@@%%%%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@%..........
    0x00, 0x1a, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x10, 0x00, 0x52, 0xd6, 0xda, 0xda, 0xda, 0xd4, 0x40, 0x00, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1a, 0x00,  //..........+@@@@@...........
    0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c,  //%@@@@@@@@.........@@@@@@@@%
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x50, 0x28, 0x26, 0x26, 0x26, 0x2a, 0x58, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@@@@@@@@+.....+@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x14, 0x54, 0xff, 0xff, 0x38, 0x48, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@.+@@.+@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x16, 0x54, 0xff, 0xff, 0x3a, 0x4a, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@.+@@.+@@
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //%@@@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x08, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x08, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f095 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x38, 0x92, 0xbe, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%%+.................
    0x00, 0x5c, 0xfc, 0xff, 0xff, 0xea, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@.................
    0x18, 0xf2, 0xff, 0xff, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@%................
    0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@................
    0xd2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@%...............
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@...............
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@%...............
    0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa8, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@%................
    0x6a, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@%.................
    0x12, 0xf8, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@+.................
    0x00, 0xa6, 0xff, 0xff, 0xff, 0xf0, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@.................
    0x00, 0x38, 0xff, 0xff, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@%................
    0x00, 0x00, 0xae, 0xff, 0xff, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@@+...............
    0x00, 0x00, 0x18, 0xea, 0xff, 0xff, 0xff, 0xf6, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@...............
    0x00, 0x00, 0x00, 0x4a, 0xfc, 0xff, 0xff, 0xff, 0xea, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@..............
    0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x06, 0xc0, 0xff, 0xb4, 0x1e, 0x00, 0x00, 0x00,  //....+@@@@@+.....%@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x1a, 0x00, 0x00, 0xa8, 0xff, 0xff, 0xff, 0xf6, 0x88, 0x0e, 0x00,  //.....%@@@@@%...%@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x80, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x58,  //......%@@@@@@+%@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe,  //.......+@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,  //........+@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x38,  //..........%@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xa6, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x5c, 0x00,  //............%@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x6a, 0xbc, 0xf0, 0xf4, 0xd2, 0x80, 0x18, 0x00, 0x00,  //..............+%@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f0c4 () , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x42, 0x7e, 0x90, 0x80, 0x4e, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..++%++......................
    0x16, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x80, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@+....................
    0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x72, 0x1c, 0x00, 0x00,  //@@@@@@@@@@...............+...
    0xff, 0xff, 0xf0, 0x52, 0x0c, 0x16, 0x46, 0xb0, 0xff, 0xff, 0xd6, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa0, 0xea, 0xa0, 0xec, 0x94, 0x0c,  //@@@+..+%@@@............%@%@%.
    0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xf4, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x88, 0xee, 0x8a, 0x0e, 0x00, 0x14, 0xda, 0x6e,  //@@%.....+@@%.........%@%...@+
    0xff, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x70, 0xea, 0xa4, 0x1e, 0x00, 0x00, 0x10, 0xb6, 0xca, 0x16,  //@@@......+@@.......+@%....%@.
    0xe2, 0xff, 0xff, 0xaa, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xdc, 0xbe, 0x32, 0x00, 0x00, 0x00, 0x2a, 0xda, 0x9a, 0x06, 0x00,  //@@@%......@@.....+@%.....@%..
    0x4c, 0xfc, 0xff, 0xff, 0xe0, 0x6e, 0x24, 0x06, 0x26, 0xb6, 0xff, 0xec, 0x18, 0x00, 0x00, 0x40, 0xca, 0xd4, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x52, 0xea, 0x64, 0x00, 0x00, 0x00,  //+@@@@+...%@@....@@+....+@+...
    0x00, 0x5c, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0xea, 0x7a, 0xb4, 0xe6, 0x66, 0x02, 0x00, 0x00, 0x00, 0x00, 0x84, 0xe0, 0x34, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@@@@@%@+%@+.....%@.....
    0x00, 0x00, 0x2a, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x00, 0x9a, 0xf4, 0x80, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x10, 0xb6, 0xba, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@@@@@.%@+......%%......
    0x00, 0x00, 0x00, 0x00, 0x22, 0x68, 0x8c, 0x8c, 0x6a, 0x3e, 0xd8, 0xca, 0xfa, 0x20, 0x30, 0x36, 0x00, 0x00, 0x00, 0x2c, 0xda, 0x88, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+%%+.@@@.......@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x94, 0xff, 0x0a, 0xea, 0xf6, 0x06, 0x00, 0x54, 0xf0, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@.@@..+@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xe0, 0xba, 0x02, 0xb4, 0xc4, 0x02, 0x86, 0xe0, 0xd6, 0xb8, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@%.%@.%@@%........
    0x00, 0x00, 0x00, 0x26, 0x8c, 0xd0, 0xf2, 0xf4, 0xd2, 0xa6, 0xea, 0x5e, 0x00, 0x2e, 0x50, 0x18, 0xb6, 0xb2, 0x12, 0x0a, 0xa4, 0xe0, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@@@%@+..+.%%..%@.......
    0x00, 0x06, 0x92, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x22, 0x8e, 0xf4, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x68, 0xf0, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@@@@@@.%@@@+....+@+.....
    0x08, 0xc4, 0xff, 0xff, 0xff, 0xf0, 0xb8, 0x9c, 0xba, 0xfc, 0xff, 0xfc, 0xa0, 0x16, 0x4a, 0xce, 0xde, 0x58, 0x00, 0x00, 0x00, 0x00, 0x32, 0xdc, 0xa6, 0x0a, 0x00, 0x00, 0x00,  //.@@@@@%%%@@@%.+@@+.....@%....
    0xa0, 0xff, 0xff, 0xf8, 0x7a, 0x0e, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x58, 0xda, 0xcc, 0x44, 0x00, 0x00, 0x00, 0x0e, 0xb0, 0xd4, 0x28, 0x00, 0x00,  //%@@@+....+@@....+@@+....%@...
    0xfc, 0xff, 0xfc, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x68, 0xe4, 0xb8, 0x30, 0x00, 0x00, 0x00, 0x74, 0xee, 0x56, 0x00,  //@@@.......@@......+@%....+@+.
    0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xc6, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x78, 0xec, 0xa2, 0x1e, 0x00, 0x00, 0x3a, 0xe4, 0x54,  //@@%......@@%........+@%....@+
    0xff, 0xff, 0xc6, 0x04, 0x00, 0x00, 0x00, 0x42, 0xd2, 0xff, 0xfc, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x86, 0xee, 0x8e, 0x32, 0x96, 0xe8, 0x3a,  //@@@....+@@@...........%@%.%@.
    0xf4, 0xff, 0xff, 0xe0, 0xa2, 0xac, 0xda, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x94, 0xda, 0x7e, 0x10, 0x00,  //@@@@%%@@@@+.............%@+..
    0x5e, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@+...................
    0x00, 0x36, 0xac, 0xe8, 0xfa, 0xea, 0xb8, 0x66, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@%+.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+f0c5 () , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xca, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@@@@@@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xff, 0x24, 0x12, 0x12, 0x12, 0x12, 0x12, 0x20, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@.......@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xce, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@.......@@..........
    0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xce, 0x12, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@.@@.......@@..........
    0x00, 0x00, 0x00, 0x90, 0xff, 0xce, 0x12, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@..@@.......@@..........
    0x00, 0x00, 0x94, 0xff, 0xce, 0x12, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0x92, 0xe2, 0xf6, 0xf6, 0xf6, 0xf6, 0xf6, 0xf6, 0xf0, 0x78,  //..%@@...@@.......@@%@@@@@@@@+
    0x00, 0x98, 0xff, 0xce, 0x12, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //.%@@....@@.......@@@@@@@@@@@@
    0x62, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //+@@@@@@@@@.......@@@@......@@
    0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xe8, 0xff, 0xd0, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@@@@@@@@%......@@@@@......@@
    0xfa, 0xff, 0x24, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xee, 0xff, 0xda, 0x16, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@.............@@@.@@......@@
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xf4, 0xff, 0xe4, 0x20, 0x00, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@...........+@@@..@@......@@
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xf8, 0xff, 0xec, 0x2c, 0x00, 0x00, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@..........+@@@...@@......@@
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xfa, 0xff, 0xf4, 0x38, 0x00, 0x00, 0x00, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@.........+@@@....@@......@@
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xfa, 0xff, 0xfc, 0x5c, 0x12, 0x12, 0x12, 0x12, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@.........@@@+....@@......@@
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@........%@@@@@@@@@@......@@
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@........@@@@@@@@@@+......@@
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@........@@+..............@@
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@........@@+..............@@
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@........@@+..............@@
    0xff, 0xff, 0x20, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0xec, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@........@@+..............@@
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@@@@@@@@@@@+..............@@
    0x82, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //%@@@@@@@@@@@+..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //..........@@+..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //..........@@+..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //..........@@+..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //..........@@+..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //..........@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x8a,  //..........+@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x08, 0x00,  //.............................


    /*Unicode: U+f0c7 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x7e, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xd8, 0x74, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@@@@@@@@@@+......
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x04, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@@%.....
    0xff, 0xff, 0x20, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5c, 0x0e, 0x0e, 0x0e, 0x3a, 0xff, 0xff, 0x3a, 0xd6, 0xff, 0xb0, 0x04, 0x00, 0x00, 0x00,  //@@..@@@@@@+....@@.@@%....
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x1a, 0xde, 0xff, 0xb0, 0x04, 0x00, 0x00,  //@@..@@@@@@.....@@..@@%...
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x00, 0x22, 0xe4, 0xff, 0xb0, 0x04, 0x00,  //@@..@@@@@@.....@@...@@%..
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x00, 0x00, 0x2a, 0xec, 0xff, 0xb0, 0x02,  //@@..@@@@@@.....@@....@@%.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x34, 0xf0, 0xff, 0x72,  //@@..@@@@@@.....@@.....@@+
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xd8,  //@@..@@@@@@.....@@.....+@@
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5e, 0x12, 0x12, 0x12, 0x3e, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xfc,  //@@..@@@@@@+....@@......@@
    0xff, 0xff, 0x12, 0x00, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@..@@@@@@@@@@@@@......@@
    0xff, 0xff, 0x12, 0x00, 0x74, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@..+@@@@@@@@@@@+......@@
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@.....................@@
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@.....................@@
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@.....................@@
    0xff, 0xff, 0x12, 0x00, 0x00, 0x08, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x08, 0x00, 0x00, 0x12, 0xff, 0xff,  //@@.....................@@
    0xff, 0xff, 0x12, 0x00, 0x90, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x8e, 0x00, 0x12, 0xff, 0xff,  //@@..%@@@@@@@@@@@@@@@%..@@
    0xff, 0xff, 0x12, 0x00, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x12, 0xff, 0xff,  //@@..@@@@@@@@@@@@@@@@@..@@
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x12, 0xff, 0xff,  //@@..@@.............@@..@@
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x12, 0xff, 0xff,  //@@..@@.............@@..@@
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x12, 0xff, 0xff,  //@@..@@.............@@..@@
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x12, 0xff, 0xff,  //@@..@@.............@@..@@
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0x00, 0x12, 0xff, 0xff,  //@@..@@.............@@..@@
    0xff, 0xff, 0x16, 0x02, 0xff, 0xff, 0x16, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x16, 0xff, 0xff, 0x02, 0x16, 0xff, 0xff,  //@@..@@.............@@..@@
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0x8c, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x8c,  //%@@@@@@@@@@@@@@@@@@@@@@@%
    0x00, 0x08, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x08, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f0e7 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x94, 0xea, 0xea, 0xea, 0xea, 0xea, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@@@@.....
    0x00, 0x00, 0x02, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@.....
    0x00, 0x00, 0x32, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@+.....
    0x00, 0x00, 0x70, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@......
    0x00, 0x00, 0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@@@%......
    0x00, 0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@+......
    0x00, 0x2c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,  //..@@@@@@.......
    0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00, 0x0a, 0x46, 0x86, 0xc6, 0xfa, 0x62,  //.+@@@@@%..+%@@+
    0x00, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xae, 0xc6, 0xfa, 0xff, 0xff, 0xff, 0xfc, 0x26,  //.%@@@@@%@@@@@@.
    0x00, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x00,  //.@@@@@@@@@@@@%.
    0x24, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x34, 0x00,  //.@@@@@@@@@@@@..
    0x62, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x00, 0x00,  //+@@@@@@@@@@@%..
    0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00,  //%@@@@@@@@@@@+..
    0xde, 0xff, 0xff, 0xff, 0xd6, 0x96, 0x56, 0xac, 0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00,  //@@@@@%+%@@@@...
    0x9c, 0x96, 0x56, 0x16, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00,  //%%+....@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xff, 0xff, 0xdc, 0x02, 0x00, 0x00, 0x00,  //.......@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00,  //......+@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xe8, 0x06, 0x00, 0x00, 0x00, 0x00,  //......%@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xfc, 0xff, 0xf0, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xf8, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@%.......
    0x00, 0x00, 0x00, 0x00, 0x0c, 0xfa, 0xfc, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@........
    0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@%........
    0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@.........
    0x00, 0x00, 0x00, 0x00, 0x90, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f0f3 () , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xbe, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............+%+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xfa, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0xfc, 0xff, 0xf6, 0x7a, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+@@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x02, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@@@@@@@+....
    0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x20, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@@@@@%...
    0x00, 0x00, 0x28, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x1a, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@@@@@...
    0x00, 0x02, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x00, 0x00,  //..@@@@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@%.
    0x98, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86,  //%@@@@@@@@@@@@@@@@@@@@@@@@@%
    0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x36, 0xcc, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xf8, 0xe4, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xc6, 0x2a,  //.@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xb8, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%%%@@@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xf4, 0x5a, 0xec, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@+@@@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xbc, 0xdc, 0x5e, 0x8e, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@+%@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x8c, 0xec, 0xff, 0xe8, 0x82, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........%@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+f11c () , Width: 32 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x3e, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x4a, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+.
    0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0x20, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0xff, 0xff, 0x12,  //@@...........................@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@...........................@@.
    0xff, 0xff, 0x12, 0x00, 0x0e, 0x10, 0x00, 0x00, 0x0c, 0x10, 0x00, 0x00, 0x0c, 0x12, 0x0c, 0x00, 0x00, 0x10, 0x0e, 0x00, 0x00, 0x10, 0x0c, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@...........................@@.
    0xff, 0xff, 0x12, 0x00, 0xfc, 0xff, 0x10, 0x00, 0xd8, 0xfc, 0x00, 0x00, 0xec, 0xff, 0xe8, 0x00, 0x00, 0xfc, 0xe8, 0x00, 0x00, 0xfc, 0xd8, 0x00, 0x0c, 0xff, 0xfc, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@..@@..@@..@@@..@@..@@..@@..@@.
    0xff, 0xff, 0x12, 0x00, 0xfa, 0xfc, 0x0e, 0x00, 0xd6, 0xfa, 0x00, 0x00, 0xe8, 0xff, 0xe4, 0x00, 0x00, 0xfa, 0xe6, 0x00, 0x00, 0xfa, 0xd6, 0x00, 0x0e, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@..@@..@@..@@@..@@..@@..@@..@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@.......................@@..@@.
    0xff, 0xff, 0x12, 0x00, 0x0e, 0x12, 0x12, 0x12, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0x00, 0x10, 0x0e, 0x00, 0x00, 0x12, 0x20, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@.......................@@..@@.
    0xff, 0xff, 0x12, 0x00, 0xfc, 0xff, 0xff, 0xff, 0x20, 0x00, 0xfc, 0xff, 0x0c, 0x00, 0x10, 0xff, 0xfc, 0x00, 0x10, 0xff, 0xfc, 0x00, 0x20, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@..@@@@..@@...@@..@@..@@@@..@@.
    0xff, 0xff, 0x12, 0x00, 0xfa, 0xff, 0xff, 0xff, 0x1e, 0x00, 0xfa, 0xfc, 0x0c, 0x00, 0x0e, 0xfc, 0xfa, 0x00, 0x0e, 0xfc, 0xfa, 0x00, 0x1e, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@..@@@@..@@...@@..@@..@@@@..@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@...........................@@.
    0xff, 0xff, 0x12, 0x00, 0x0e, 0x10, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@...........................@@.
    0xff, 0xff, 0x12, 0x00, 0xfc, 0xff, 0x10, 0x00, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x00, 0x0c, 0xff, 0xfc, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@..@@..@@@@@@@@@@@@@@@..@@..@@.
    0xff, 0xff, 0x12, 0x00, 0xfa, 0xfc, 0x0e, 0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x00, 0x0c, 0xfc, 0xfa, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@..@@..@@@@@@@@@@@@@@@..@@..@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12,  //@@...........................@@.
    0xff, 0xff, 0x24, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0xff, 0xff, 0x12,  //@@...........................@@.
    0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x00,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.
    0x3e, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x4a, 0x00,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f124 () , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x9e, 0x4e,  //.....................%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xb2, 0xff, 0xff, 0xb2,  //...................%@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xb4, 0xff, 0xff, 0xff, 0xff, 0x50,  //.................%@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x00,  //...............%@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00,  //.............%@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x00, 0x00,  //...........%@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00,  //.........%@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00,  //.......%@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x36, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@+...
    0x00, 0x00, 0x36, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@....
    0x2e, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@+....
    0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@@@.....
    0x70, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00,  //+%%%%%%%%%@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xfa, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+f15b () , Width: 25 */
    0x7e, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@@@@@@@@@@+..........
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x6a, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@+.+%.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x6a, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@+.+@%......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x6a, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@+.+@@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x6a, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@+.+@@@%....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@+.+@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00,  //@@@@@@@@@@@@@@+.+@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00,  //@@@@@@@@@@@@@@+.+@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x1c, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x06,  //@@@@@@@@@@@@@@+..+++++++.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@%..........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0x8a,  //@@@@@@@@@@@@@@@@%%%%%%%%%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7e, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x60,  //+@@@@@@@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f1eb () , Width: 32 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x44, 0x86, 0xb2, 0xd8, 0xec, 0xf8, 0xf6, 0xe8, 0xce, 0xa8, 0x78, 0x34, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+%%@@@@@@%+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xa6, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x8e, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@@@@@@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@%......
    0x00, 0x00, 0x00, 0x24, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x96, 0x0e, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x58, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xba, 0x7a, 0x52, 0x34, 0x28, 0x2a, 0x38, 0x5a, 0x88, 0xcc, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x32, 0x00, 0x00,  //..+@@@@@@@@%++....+%@@@@@@@@@...
    0x00, 0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x6c, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x86, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x52, 0x00,  //.%@@@@@@@+............%@@@@@@@+.
    0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x70, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x20, 0x1e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x96, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x56,  //%@@@@@@+................%@@@@@@+
    0xca, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x1e, 0x00, 0x00, 0x00, 0x3e, 0x8c, 0xc8, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xec, 0xbc, 0x7c, 0x2a, 0x00, 0x00, 0x00, 0x3c, 0xe2, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@@@.....%@@@@@@@%+.....@@@@@%
    0x1c, 0xe2, 0xff, 0xff, 0x96, 0x04, 0x00, 0x04, 0x60, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x46, 0x00, 0x00, 0x16, 0xc2, 0xff, 0xff, 0xbc, 0x06,  //.@@@%...+@@@@@@@@@@@@@@+...@@@%.
    0x00, 0x24, 0xdc, 0x7c, 0x00, 0x00, 0x48, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x28, 0x00, 0x08, 0xae, 0xbc, 0x0a, 0x00,  //..@+..+@@@@@@@@@@@@@@@@@@...%%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x82, 0x42, 0x18, 0x04, 0x0c, 0x20, 0x44, 0x8c, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@%+....+%@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x12, 0xd4, 0xff, 0xff, 0xff, 0xc4, 0x40, 0x00, 0x00, 0x00, 0x02, 0x18, 0x14, 0x00, 0x00, 0x00, 0x02, 0x60, 0xde, 0xff, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@...........+@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xca, 0xe4, 0x52, 0x00, 0x00, 0x26, 0x8a, 0xd0, 0xfc, 0xff, 0xff, 0xf8, 0xc0, 0x78, 0x12, 0x00, 0x0a, 0x92, 0xfc, 0xa4, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@+...%@@@@@%+...%@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0e, 0x00, 0x10, 0xa4, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x80, 0x02, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@@@@@@@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@@@@@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@@@@@@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xc6, 0xff, 0xec, 0x84, 0x30, 0x08, 0x0c, 0x40, 0x9c, 0xf8, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@%....%@@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x6c, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+........+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xb6, 0xf2, 0xe8, 0xa4, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............%@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............%@@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xca, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............@@@%..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xb4, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............%%...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................................


    /*Unicode: U+f240 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x16, 0xb0, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xb6, 0x18, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xf4, 0xff, 0x38, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x24, 0xff, 0xfc, 0x08, 0x00, 0x00,  //@@...............................@@...
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@...............................@@...
    0xff, 0xff, 0x12, 0x00, 0x68, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@..+++++++++++++++++++++++++++..@@...
    0xff, 0xff, 0x12, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x7e, 0x10, 0x00,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@+..
    0xff, 0xff, 0x12, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xcc, 0x00,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@@@.
    0xff, 0xff, 0x12, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x3e, 0x3e, 0xf0, 0xff, 0x1c,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xff, 0xff, 0x12, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xff, 0xff, 0x12, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xff, 0xff, 0x12, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xff, 0xff, 0x12, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xff, 0xff, 0x12, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xff, 0xff, 0x12, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x3e, 0x3e, 0xf0, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@....@@.
    0xff, 0xff, 0x12, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xf0, 0x06,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@@@.
    0xff, 0xff, 0x12, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x4a, 0x00,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@@+.
    0xff, 0xff, 0x12, 0x00, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@..@@@@@@@@@@@@@@@@@@@@@@@@@@@..@@...
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@...............................@@...
    0xf4, 0xff, 0x38, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x24, 0xff, 0xff, 0x0a, 0x00, 0x00,  //@@...............................@@...
    0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x18, 0xb2, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xbe, 0x22, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f241 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x16, 0xb0, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xb6, 0x18, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xf4, 0xff, 0x38, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x24, 0xff, 0xfc, 0x08, 0x00, 0x00,  //@@...............................@@...
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@...............................@@...
    0xff, 0xff, 0x12, 0x00, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@..+++++++++++++++++++++........@@...
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x7e, 0x10, 0x00,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@+..
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xcc, 0x00,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0xf0, 0xff, 0x1c,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0xf0, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@@@@@@@%..........@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xf0, 0x06,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x4a, 0x00,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@@+.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@..@@@@@@@@@@@@@@@@@@@@%........@@...
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@...............................@@...
    0xf4, 0xff, 0x38, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x24, 0xff, 0xff, 0x0a, 0x00, 0x00,  //@@...............................@@...
    0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x18, 0xb2, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xbe, 0x22, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f242 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x16, 0xb0, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xb6, 0x18, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xf4, 0xff, 0x38, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x24, 0xff, 0xfc, 0x08, 0x00, 0x00,  //@@...............................@@...
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@...............................@@...
    0xff, 0xff, 0x12, 0x00, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@..++++++++++++++...............@@...
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x7e, 0x10, 0x00,  //@@..@@@@@@@@@@@@@@+..............@@+..
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xcc, 0x00,  //@@..@@@@@@@@@@@@@@+..............@@@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0xf0, 0xff, 0x1c,  //@@..@@@@@@@@@@@@@@+................@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@+................@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@+................@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@+................@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@+................@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@+................@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0xf0, 0xff, 0x22,  //@@..@@@@@@@@@@@@@@+................@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xf0, 0x06,  //@@..@@@@@@@@@@@@@@+..............@@@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x4a, 0x00,  //@@..@@@@@@@@@@@@@@+..............@@@+.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@..@@@@@@@@@@@@@@+..............@@...
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@...............................@@...
    0xf4, 0xff, 0x38, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x24, 0xff, 0xff, 0x0a, 0x00, 0x00,  //@@...............................@@...
    0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x18, 0xb2, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xbe, 0x22, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f243 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x16, 0xb0, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xb6, 0x18, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xf4, 0xff, 0x38, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x24, 0xff, 0xfc, 0x08, 0x00, 0x00,  //@@...............................@@...
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@...............................@@...
    0xff, 0xff, 0x12, 0x00, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@..++++++++.....................@@...
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x7e, 0x10, 0x00,  //@@..@@@@@@@@+....................@@+..
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xcc, 0x00,  //@@..@@@@@@@@+....................@@@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0xf0, 0xff, 0x1c,  //@@..@@@@@@@@+......................@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@+......................@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@+......................@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@+......................@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@+......................@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@..@@@@@@@@+......................@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0xf0, 0xff, 0x22,  //@@..@@@@@@@@+......................@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xf0, 0x06,  //@@..@@@@@@@@+....................@@@@.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x4a, 0x00,  //@@..@@@@@@@@+....................@@@+.
    0xff, 0xff, 0x12, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@..@@@@@@@@+....................@@...
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@...............................@@...
    0xf4, 0xff, 0x38, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x24, 0xff, 0xff, 0x0a, 0x00, 0x00,  //@@...............................@@...
    0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x18, 0xb2, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xbe, 0x22, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f244 () , Width: 38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x16, 0xb0, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xb4, 0x16, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%...
    0xf4, 0xff, 0x38, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x24, 0xff, 0xfa, 0x06, 0x00, 0x00,  //@@...............................@@...
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@...............................@@...
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@...............................@@...
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x50, 0x00, 0x00,  //@@...............................@@+..
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xac, 0x00,  //@@...............................@@@%.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0xf0, 0xff, 0x16,  //@@.................................@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@.................................@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@.................................@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@.................................@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@.................................@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0x22,  //@@.................................@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x3e, 0xf0, 0xff, 0x22,  //@@.................................@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xf6, 0x08,  //@@...............................@@@@.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xe8, 0x5a, 0x00,  //@@...............................@@@+.
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@...............................@@...
    0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x00, 0x00,  //@@...............................@@...
    0xf4, 0xff, 0x38, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x24, 0xff, 0xff, 0x0c, 0x00, 0x00,  //@@...............................@@...
    0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...
    0x18, 0xb2, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xbe, 0x22, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................................


    /*Unicode: U+f293 () , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x58, 0xa4, 0xd2, 0xec, 0xfa, 0xf4, 0xe4, 0xbc, 0x84, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+%@@@@@%%.......
    0x00, 0x00, 0x00, 0x00, 0x5a, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x1a, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x2a, 0x00, 0x00, 0x00,  //...%@@@@@@%@@@@@@@....
    0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x06, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0e, 0x00, 0x00,  //..+@@@@@@%.%@@@@@@@...
    0x00, 0x1a, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x06, 0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x98, 0x00, 0x00,  //..@@@@@@@%..%@@@@@@%..
    0x00, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x04, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x16, 0x00,  //.%@@@@@@@%...%@@@@@@..
    0x00, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00, 0x04, 0xac, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00,  //.@@@@@@@@%....%@@@@@+.
    0x30, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x5a, 0x00, 0x02, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x00,  //.@@@@@@@@%..+..%@@@@%.
    0x72, 0xff, 0xff, 0xff, 0xd4, 0x18, 0xa6, 0xff, 0xff, 0xbe, 0x00, 0x00, 0xfa, 0x5a, 0x00, 0x02, 0xa4, 0xff, 0xff, 0xff, 0xf4, 0x02,  //+@@@@.%@@%..@+..%@@@@.
    0x9c, 0xff, 0xff, 0xff, 0x66, 0x00, 0x02, 0xa6, 0xff, 0xbe, 0x00, 0x00, 0xfc, 0xfa, 0x28, 0x00, 0x02, 0xd4, 0xff, 0xff, 0xff, 0x22,  //%@@@+..%@%..@@...@@@@.
    0xc0, 0xff, 0xff, 0xff, 0xfa, 0x50, 0x00, 0x02, 0xa6, 0xbe, 0x00, 0x00, 0xfc, 0x76, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0x46,  //%@@@@+..%%..@+..%@@@@+
    0xde, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x50, 0x00, 0x02, 0x68, 0x00, 0x00, 0x72, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x64,  //@@@@@@+..+..+..%@@@@@+
    0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //@@@@@@@+......%@@@@@@+
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c,  //@@@@@@@@+....%@@@@@@@+
    0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x14, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x84,  //@@@@@@@@@...+@@@@@@@@%
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c,  //@@@@@@@@+....%@@@@@@@+
    0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72,  //@@@@@@@+......%@@@@@@+
    0xde, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x50, 0x00, 0x02, 0x68, 0x00, 0x00, 0x72, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66,  //@@@@@@+..+..+..%@@@@@+
    0xc0, 0xff, 0xff, 0xff, 0xfa, 0x52, 0x00, 0x02, 0xa6, 0xbe, 0x00, 0x00, 0xfc, 0x76, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0x48,  //%@@@@+..%%..@+..%@@@@+
    0x9c, 0xff, 0xff, 0xff, 0x66, 0x00, 0x02, 0xa6, 0xff, 0xbe, 0x00, 0x00, 0xfc, 0xfa, 0x28, 0x00, 0x02, 0xd4, 0xff, 0xff, 0xff, 0x24,  //%@@@+..%@%..@@...@@@@.
    0x72, 0xff, 0xff, 0xff, 0xd4, 0x18, 0xa6, 0xff, 0xff, 0xbe, 0x00, 0x00, 0xfa, 0x5a, 0x00, 0x02, 0xa4, 0xff, 0xff, 0xff, 0xf4, 0x02,  //+@@@@.%@@%..@+..%@@@@.
    0x32, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x5a, 0x00, 0x02, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x00,  //.@@@@@@@@%..+..%@@@@%.
    0x00, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00, 0x04, 0xac, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00,  //.@@@@@@@@%....%@@@@@+.
    0x00, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x06, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x16, 0x00,  //.%@@@@@@@%...%@@@@@@..
    0x00, 0x1a, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x06, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x98, 0x00, 0x00,  //..@@@@@@@%..%@@@@@@%..
    0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x08, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0e, 0x00, 0x00,  //..+@@@@@@%.%@@@@@@@...
    0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x2a, 0x00, 0x00, 0x00,  //...%@@@@@@%@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x5a, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x1a, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x5a, 0xa8, 0xd4, 0xee, 0xfa, 0xf4, 0xe6, 0xc0, 0x88, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+%@@@@@%%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................



#endif
};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t lv_font_symbol_30_glyph_dsc[] = {
#if USE_LV_FONT_SYMBOL_30 == 1
    {.w_px = 25,  .glyph_index = 0},  /*Unicode: U+f001 ()*/
    {.w_px = 32,  .glyph_index = 120},    /*Unicode: U+f008 ()*/
    {.w_px = 29,  .glyph_index = 240},    /*Unicode: U+f00b ()*/
    {.w_px = 25,  .glyph_index = 360},    /*Unicode: U+f00c ()*/
    {.w_px = 20,  .glyph_index = 480},    /*Unicode: U+f00d ()*/
    {.w_px = 25,  .glyph_index = 570},    /*Unicode: U+f011 ()*/
    {.w_px = 25,  .glyph_index = 690},    /*Unicode: U+f013 ()*/
    {.w_px = 23,  .glyph_index = 810},    /*Unicode: U+f014 ()*/
    {.w_px = 27,  .glyph_index = 900},    /*Unicode: U+f015 ()*/
    {.w_px = 27,  .glyph_index = 1020},   /*Unicode: U+f019 ()*/
    {.w_px = 25,  .glyph_index = 1140},   /*Unicode: U+f01c ()*/
    {.w_px = 25,  .glyph_index = 1260},   /*Unicode: U+f021 ()*/
    {.w_px = 13,  .glyph_index = 1380},   /*Unicode: U+f026 ()*/
    {.w_px = 19,  .glyph_index = 1440},   /*Unicode: U+f027 ()*/
    {.w_px = 27,  .glyph_index = 1530},   /*Unicode: U+f028 ()*/
    {.w_px = 32,  .glyph_index = 1650},   /*Unicode: U+f03e ()*/
    {.w_px = 25,  .glyph_index = 1770},   /*Unicode: U+f040 ()*/
    {.w_px = 17,  .glyph_index = 1890},   /*Unicode: U+f048 ()*/
    {.w_px = 23,  .glyph_index = 1980},   /*Unicode: U+f04b ()*/
    {.w_px = 25,  .glyph_index = 2070},   /*Unicode: U+f04c ()*/
    {.w_px = 25,  .glyph_index = 2190},   /*Unicode: U+f04d ()*/
    {.w_px = 17,  .glyph_index = 2310},   /*Unicode: U+f051 ()*/
    {.w_px = 25,  .glyph_index = 2400},   /*Unicode: U+f052 ()*/
    {.w_px = 18,  .glyph_index = 2520},   /*Unicode: U+f053 ()*/
    {.w_px = 18,  .glyph_index = 2610},   /*Unicode: U+f054 ()*/
    {.w_px = 23,  .glyph_index = 2700},   /*Unicode: U+f067 ()*/
    {.w_px = 23,  .glyph_index = 2790},   /*Unicode: U+f068 ()*/
    {.w_px = 29,  .glyph_index = 2880},   /*Unicode: U+f071 ()*/
    {.w_px = 29,  .glyph_index = 3000},   /*Unicode: U+f074 ()*/
    {.w_px = 27,  .glyph_index = 3120},   /*Unicode: U+f077 ()*/
    {.w_px = 27,  .glyph_index = 3240},   /*Unicode: U+f078 ()*/
    {.w_px = 32,  .glyph_index = 3360},   /*Unicode: U+f079 ()*/
    {.w_px = 27,  .glyph_index = 3480},   /*Unicode: U+f07b ()*/
    {.w_px = 27,  .glyph_index = 3600},   /*Unicode: U+f093 ()*/
    {.w_px = 23,  .glyph_index = 3720},   /*Unicode: U+f095 ()*/
    {.w_px = 29,  .glyph_index = 3810},   /*Unicode: U+f0c4 ()*/
    {.w_px = 29,  .glyph_index = 3930},   /*Unicode: U+f0c5 ()*/
    {.w_px = 25,  .glyph_index = 4050},   /*Unicode: U+f0c7 ()*/
    {.w_px = 15,  .glyph_index = 4170},   /*Unicode: U+f0e7 ()*/
    {.w_px = 27,  .glyph_index = 4230},   /*Unicode: U+f0f3 ()*/
    {.w_px = 32,  .glyph_index = 4350},   /*Unicode: U+f11c ()*/
    {.w_px = 23,  .glyph_index = 4470},   /*Unicode: U+f124 ()*/
    {.w_px = 25,  .glyph_index = 4560},   /*Unicode: U+f15b ()*/
    {.w_px = 32,  .glyph_index = 4680},   /*Unicode: U+f1eb ()*/
    {.w_px = 38,  .glyph_index = 4800},   /*Unicode: U+f240 ()*/
    {.w_px = 38,  .glyph_index = 4950},   /*Unicode: U+f241 ()*/
    {.w_px = 38,  .glyph_index = 5100},   /*Unicode: U+f242 ()*/
    {.w_px = 38,  .glyph_index = 5250},   /*Unicode: U+f243 ()*/
    {.w_px = 38,  .glyph_index = 5400},   /*Unicode: U+f244 ()*/
    {.w_px = 22,  .glyph_index = 5550},   /*Unicode: U+f293 ()*/

#elif USE_LV_FONT_SYMBOL_30 == 2
    {.w_px = 25,  .glyph_index = 0},  /*Unicode: U+f001 ()*/
    {.w_px = 32,  .glyph_index = 210},    /*Unicode: U+f008 ()*/
    {.w_px = 29,  .glyph_index = 450},    /*Unicode: U+f00b ()*/
    {.w_px = 25,  .glyph_index = 690},    /*Unicode: U+f00c ()*/
    {.w_px = 20,  .glyph_index = 900},    /*Unicode: U+f00d ()*/
    {.w_px = 25,  .glyph_index = 1050},   /*Unicode: U+f011 ()*/
    {.w_px = 25,  .glyph_index = 1260},   /*Unicode: U+f013 ()*/
    {.w_px = 23,  .glyph_index = 1470},   /*Unicode: U+f014 ()*/
    {.w_px = 27,  .glyph_index = 1650},   /*Unicode: U+f015 ()*/
    {.w_px = 27,  .glyph_index = 1860},   /*Unicode: U+f019 ()*/
    {.w_px = 25,  .glyph_index = 2070},   /*Unicode: U+f01c ()*/
    {.w_px = 25,  .glyph_index = 2280},   /*Unicode: U+f021 ()*/
    {.w_px = 13,  .glyph_index = 2490},   /*Unicode: U+f026 ()*/
    {.w_px = 19,  .glyph_index = 2610},   /*Unicode: U+f027 ()*/
    {.w_px = 27,  .glyph_index = 2760},   /*Unicode: U+f028 ()*/
    {.w_px = 32,  .glyph_index = 2970},   /*Unicode: U+f03e ()*/
    {.w_px = 25,  .glyph_index = 3210},   /*Unicode: U+f040 ()*/
    {.w_px = 17,  .glyph_index = 3420},   /*Unicode: U+f048 ()*/
    {.w_px = 23,  .glyph_index = 3570},   /*Unicode: U+f04b ()*/
    {.w_px = 25,  .glyph_index = 3750},   /*Unicode: U+f04c ()*/
    {.w_px = 25,  .glyph_index = 3960},   /*Unicode: U+f04d ()*/
    {.w_px = 17,  .glyph_index = 4170},   /*Unicode: U+f051 ()*/
    {.w_px = 25,  .glyph_index = 4320},   /*Unicode: U+f052 ()*/
    {.w_px = 18,  .glyph_index = 4530},   /*Unicode: U+f053 ()*/
    {.w_px = 18,  .glyph_index = 4680},   /*Unicode: U+f054 ()*/
    {.w_px = 23,  .glyph_index = 4830},   /*Unicode: U+f067 ()*/
    {.w_px = 23,  .glyph_index = 5010},   /*Unicode: U+f068 ()*/
    {.w_px = 29,  .glyph_index = 5190},   /*Unicode: U+f071 ()*/
    {.w_px = 29,  .glyph_index = 5430},   /*Unicode: U+f074 ()*/
    {.w_px = 27,  .glyph_index = 5670},   /*Unicode: U+f077 ()*/
    {.w_px = 27,  .glyph_index = 5880},   /*Unicode: U+f078 ()*/
    {.w_px = 32,  .glyph_index = 6090},   /*Unicode: U+f079 ()*/
    {.w_px = 27,  .glyph_index = 6330},   /*Unicode: U+f07b ()*/
    {.w_px = 27,  .glyph_index = 6540},   /*Unicode: U+f093 ()*/
    {.w_px = 23,  .glyph_index = 6750},   /*Unicode: U+f095 ()*/
    {.w_px = 29,  .glyph_index = 6930},   /*Unicode: U+f0c4 ()*/
    {.w_px = 29,  .glyph_index = 7170},   /*Unicode: U+f0c5 ()*/
    {.w_px = 25,  .glyph_index = 7410},   /*Unicode: U+f0c7 ()*/
    {.w_px = 15,  .glyph_index = 7620},   /*Unicode: U+f0e7 ()*/
    {.w_px = 27,  .glyph_index = 7740},   /*Unicode: U+f0f3 ()*/
    {.w_px = 32,  .glyph_index = 7950},   /*Unicode: U+f11c ()*/
    {.w_px = 23,  .glyph_index = 8190},   /*Unicode: U+f124 ()*/
    {.w_px = 25,  .glyph_index = 8370},   /*Unicode: U+f15b ()*/
    {.w_px = 32,  .glyph_index = 8580},   /*Unicode: U+f1eb ()*/
    {.w_px = 38,  .glyph_index = 8820},   /*Unicode: U+f240 ()*/
    {.w_px = 38,  .glyph_index = 9120},   /*Unicode: U+f241 ()*/
    {.w_px = 38,  .glyph_index = 9420},   /*Unicode: U+f242 ()*/
    {.w_px = 38,  .glyph_index = 9720},   /*Unicode: U+f243 ()*/
    {.w_px = 38,  .glyph_index = 10020},  /*Unicode: U+f244 ()*/
    {.w_px = 22,  .glyph_index = 10320},  /*Unicode: U+f293 ()*/

#elif USE_LV_FONT_SYMBOL_30 == 4
    {.w_px = 25,  .glyph_index = 0},  /*Unicode: U+f001 ()*/
    {.w_px = 32,  .glyph_index = 390},    /*Unicode: U+f008 ()*/
    {.w_px = 29,  .glyph_index = 870},    /*Unicode: U+f00b ()*/
    {.w_px = 25,  .glyph_index = 1320},   /*Unicode: U+f00c ()*/
    {.w_px = 20,  .glyph_index = 1710},   /*Unicode: U+f00d ()*/
    {.w_px = 25,  .glyph_index = 2010},   /*Unicode: U+f011 ()*/
    {.w_px = 25,  .glyph_index = 2400},   /*Unicode: U+f013 ()*/
    {.w_px = 23,  .glyph_index = 2790},   /*Unicode: U+f014 ()*/
    {.w_px = 27,  .glyph_index = 3150},   /*Unicode: U+f015 ()*/
    {.w_px = 27,  .glyph_index = 3570},   /*Unicode: U+f019 ()*/
    {.w_px = 25,  .glyph_index = 3990},   /*Unicode: U+f01c ()*/
    {.w_px = 25,  .glyph_index = 4380},   /*Unicode: U+f021 ()*/
    {.w_px = 13,  .glyph_index = 4770},   /*Unicode: U+f026 ()*/
    {.w_px = 19,  .glyph_index = 4980},   /*Unicode: U+f027 ()*/
    {.w_px = 27,  .glyph_index = 5280},   /*Unicode: U+f028 ()*/
    {.w_px = 32,  .glyph_index = 5700},   /*Unicode: U+f03e ()*/
    {.w_px = 25,  .glyph_index = 6180},   /*Unicode: U+f040 ()*/
    {.w_px = 17,  .glyph_index = 6570},   /*Unicode: U+f048 ()*/
    {.w_px = 23,  .glyph_index = 6840},   /*Unicode: U+f04b ()*/
    {.w_px = 25,  .glyph_index = 7200},   /*Unicode: U+f04c ()*/
    {.w_px = 25,  .glyph_index = 7590},   /*Unicode: U+f04d ()*/
    {.w_px = 17,  .glyph_index = 7980},   /*Unicode: U+f051 ()*/
    {.w_px = 25,  .glyph_index = 8250},   /*Unicode: U+f052 ()*/
    {.w_px = 18,  .glyph_index = 8640},   /*Unicode: U+f053 ()*/
    {.w_px = 18,  .glyph_index = 8910},   /*Unicode: U+f054 ()*/
    {.w_px = 23,  .glyph_index = 9180},   /*Unicode: U+f067 ()*/
    {.w_px = 23,  .glyph_index = 9540},   /*Unicode: U+f068 ()*/
    {.w_px = 29,  .glyph_index = 9900},   /*Unicode: U+f071 ()*/
    {.w_px = 29,  .glyph_index = 10350},  /*Unicode: U+f074 ()*/
    {.w_px = 27,  .glyph_index = 10800},  /*Unicode: U+f077 ()*/
    {.w_px = 27,  .glyph_index = 11220},  /*Unicode: U+f078 ()*/
    {.w_px = 32,  .glyph_index = 11640},  /*Unicode: U+f079 ()*/
    {.w_px = 27,  .glyph_index = 12120},  /*Unicode: U+f07b ()*/
    {.w_px = 27,  .glyph_index = 12540},  /*Unicode: U+f093 ()*/
    {.w_px = 23,  .glyph_index = 12960},  /*Unicode: U+f095 ()*/
    {.w_px = 29,  .glyph_index = 13320},  /*Unicode: U+f0c4 ()*/
    {.w_px = 29,  .glyph_index = 13770},  /*Unicode: U+f0c5 ()*/
    {.w_px = 25,  .glyph_index = 14220},  /*Unicode: U+f0c7 ()*/
    {.w_px = 15,  .glyph_index = 14610},  /*Unicode: U+f0e7 ()*/
    {.w_px = 27,  .glyph_index = 14850},  /*Unicode: U+f0f3 ()*/
    {.w_px = 32,  .glyph_index = 15270},  /*Unicode: U+f11c ()*/
    {.w_px = 23,  .glyph_index = 15750},  /*Unicode: U+f124 ()*/
    {.w_px = 25,  .glyph_index = 16110},  /*Unicode: U+f15b ()*/
    {.w_px = 32,  .glyph_index = 16500},  /*Unicode: U+f1eb ()*/
    {.w_px = 38,  .glyph_index = 16980},  /*Unicode: U+f240 ()*/
    {.w_px = 38,  .glyph_index = 17550},  /*Unicode: U+f241 ()*/
    {.w_px = 38,  .glyph_index = 18120},  /*Unicode: U+f242 ()*/
    {.w_px = 38,  .glyph_index = 18690},  /*Unicode: U+f243 ()*/
    {.w_px = 38,  .glyph_index = 19260},  /*Unicode: U+f244 ()*/
    {.w_px = 22,  .glyph_index = 19830},  /*Unicode: U+f293 ()*/

#elif USE_LV_FONT_SYMBOL_30 == 8
    {.w_px = 25,  .glyph_index = 0},  /*Unicode: U+f001 ()*/
    {.w_px = 32,  .glyph_index = 750},    /*Unicode: U+f008 ()*/
    {.w_px = 29,  .glyph_index = 1710},   /*Unicode: U+f00b ()*/
    {.w_px = 25,  .glyph_index = 2580},   /*Unicode: U+f00c ()*/
    {.w_px = 20,  .glyph_index = 3330},   /*Unicode: U+f00d ()*/
    {.w_px = 25,  .glyph_index = 3930},   /*Unicode: U+f011 ()*/
    {.w_px = 25,  .glyph_index = 4680},   /*Unicode: U+f013 ()*/
    {.w_px = 23,  .glyph_index = 5430},   /*Unicode: U+f014 ()*/
    {.w_px = 27,  .glyph_index = 6120},   /*Unicode: U+f015 ()*/
    {.w_px = 27,  .glyph_index = 6930},   /*Unicode: U+f019 ()*/
    {.w_px = 25,  .glyph_index = 7740},   /*Unicode: U+f01c ()*/
    {.w_px = 25,  .glyph_index = 8490},   /*Unicode: U+f021 ()*/
    {.w_px = 13,  .glyph_index = 9240},   /*Unicode: U+f026 ()*/
    {.w_px = 19,  .glyph_index = 9630},   /*Unicode: U+f027 ()*/
    {.w_px = 27,  .glyph_index = 10200},  /*Unicode: U+f028 ()*/
    {.w_px = 32,  .glyph_index = 11010},  /*Unicode: U+f03e ()*/
    {.w_px = 25,  .glyph_index = 11970},  /*Unicode: U+f040 ()*/
    {.w_px = 17,  .glyph_index = 12720},  /*Unicode: U+f048 ()*/
    {.w_px = 23,  .glyph_index = 13230},  /*Unicode: U+f04b ()*/
    {.w_px = 25,  .glyph_index = 13920},  /*Unicode: U+f04c ()*/
    {.w_px = 25,  .glyph_index = 14670},  /*Unicode: U+f04d ()*/
    {.w_px = 17,  .glyph_index = 15420},  /*Unicode: U+f051 ()*/
    {.w_px = 25,  .glyph_index = 15930},  /*Unicode: U+f052 ()*/
    {.w_px = 18,  .glyph_index = 16680},  /*Unicode: U+f053 ()*/
    {.w_px = 18,  .glyph_index = 17220},  /*Unicode: U+f054 ()*/
    {.w_px = 23,  .glyph_index = 17760},  /*Unicode: U+f067 ()*/
    {.w_px = 23,  .glyph_index = 18450},  /*Unicode: U+f068 ()*/
    {.w_px = 29,  .glyph_index = 19140},  /*Unicode: U+f071 ()*/
    {.w_px = 29,  .glyph_index = 20010},  /*Unicode: U+f074 ()*/
    {.w_px = 27,  .glyph_index = 20880},  /*Unicode: U+f077 ()*/
    {.w_px = 27,  .glyph_index = 21690},  /*Unicode: U+f078 ()*/
    {.w_px = 32,  .glyph_index = 22500},  /*Unicode: U+f079 ()*/
    {.w_px = 27,  .glyph_index = 23460},  /*Unicode: U+f07b ()*/
    {.w_px = 27,  .glyph_index = 24270},  /*Unicode: U+f093 ()*/
    {.w_px = 23,  .glyph_index = 25080},  /*Unicode: U+f095 ()*/
    {.w_px = 29,  .glyph_index = 25770},  /*Unicode: U+f0c4 ()*/
    {.w_px = 29,  .glyph_index = 26640},  /*Unicode: U+f0c5 ()*/
    {.w_px = 25,  .glyph_index = 27510},  /*Unicode: U+f0c7 ()*/
    {.w_px = 15,  .glyph_index = 28260},  /*Unicode: U+f0e7 ()*/
    {.w_px = 27,  .glyph_index = 28710},  /*Unicode: U+f0f3 ()*/
    {.w_px = 32,  .glyph_index = 29520},  /*Unicode: U+f11c ()*/
    {.w_px = 23,  .glyph_index = 30480},  /*Unicode: U+f124 ()*/
    {.w_px = 25,  .glyph_index = 31170},  /*Unicode: U+f15b ()*/
    {.w_px = 32,  .glyph_index = 31920},  /*Unicode: U+f1eb ()*/
    {.w_px = 38,  .glyph_index = 32880},  /*Unicode: U+f240 ()*/
    {.w_px = 38,  .glyph_index = 34020},  /*Unicode: U+f241 ()*/
    {.w_px = 38,  .glyph_index = 35160},  /*Unicode: U+f242 ()*/
    {.w_px = 38,  .glyph_index = 36300},  /*Unicode: U+f243 ()*/
    {.w_px = 38,  .glyph_index = 37440},  /*Unicode: U+f244 ()*/
    {.w_px = 22,  .glyph_index = 38580},  /*Unicode: U+f293 ()*/

#endif
};
lv_font_t lv_font_symbol_30 = {
    .unicode_first = LV_SYMBOL_GLYPH_FIRST, /*First Unicode letter in this font*/
    .unicode_last = LV_SYMBOL_GLYPH_LAST,  /*Last Unicode letter in this font*/
    .h_px = 30,             /*Font height in pixels*/
    .glyph_bitmap = lv_font_symbol_30_glyph_bitmap, /*Bitmap of glyphs*/
    .glyph_dsc = lv_font_symbol_30_glyph_dsc,       /*Description of glyphs*/
    .glyph_cnt = 50,            /*Number of glyphs in the font*/
    .unicode_list = NULL,
    .get_bitmap = lv_font_get_bitmap_continuous,    /*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,  /*Function pointer to get glyph's width*/
#if USE_LV_FONT_SYMBOL_30 == 1
    .bpp = 1,               /*Bit per pixel*/
#elif USE_LV_FONT_SYMBOL_30 == 2
    .bpp = 2,               /*Bit per pixel*/
#elif USE_LV_FONT_SYMBOL_30 == 4
    .bpp = 4,               /*Bit per pixel*/
#elif USE_LV_FONT_SYMBOL_30 == 8
    .bpp = 8,               /*Bit per pixel*/
#endif
    .monospace = 0,
    .next_page = NULL,      /*Pointer to a font extension*/
};

#endif /*USE_LV_FONT_SYMBOL_30*/
