
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_SYMBOL_20 != 0  /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * fontawesome-webfont.ttf 20 px Font in U+f000 () .. U+f2ee ()  range with 1 bpp
 * Sparse font with only these characters:     
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_symbol_20_glyph_bitmap[] = {
#if USE_LV_FONT_SYMBOL_20 == 1
    /*Unicode: U+f001 () , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x01, 0x00,  //..............+%.
    0x00, 0x0f, 0x00,  //...........+@@@@+
    0x00, 0xff, 0x00,  //........%@@@@@@@+
    0x03, 0xff, 0x00,  //......@@@@@@@@@@+
    0x03, 0xff, 0x00,  //.....+@@@@@@@@@@+
    0x03, 0xff, 0x00,  //.....+@@@@@@@@@@+
    0x03, 0xf9, 0x00,  //.....+@@@@@@%+.@+
    0x03, 0xc1, 0x00,  //.....+@@@%+....@+
    0x02, 0x01, 0x00,  //.....+@+.......@+
    0x02, 0x01, 0x00,  //.....+@........@+
    0x02, 0x01, 0x00,  //.....+@........@+
    0x02, 0x1f, 0x00,  //.....+@....%%%%@+
    0x02, 0x3f, 0x00,  //.....+@...@@@@@@+
    0x02, 0x3f, 0x00,  //.....+@..+@@@@@@+
    0x7e, 0x3f, 0x00,  //.%@@@@@...%@@@@%.
    0xfe, 0x00, 0x00,  //%@@@@@@..........
    0xfe, 0x00, 0x00,  //%@@@@@@..........
    0x7c, 0x00, 0x00,  //.+@@@%...........


    /*Unicode: U+f008 () , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x7f, 0xff, 0xf0,  //+@@@@@@@@@@@@@@@@@@%.
    0xcc, 0x03, 0x90,  //@%++@%++++++++%@%++@+
    0x88, 0x01, 0x10,  //@+..@+.........@+..@+
    0x88, 0x01, 0x10,  //@+..@+.........@+..@+
    0xf8, 0x01, 0xf0,  //@@@@@+.........@@@@@+
    0xc8, 0x01, 0x90,  //@%++@+.........@%++@+
    0x88, 0x01, 0x10,  //@+..@+.........@+..@+
    0x88, 0x01, 0x10,  //@+..@+.........@+..@+
    0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@+
    0xcc, 0x03, 0x90,  //@%++@%++++++++%@%++@+
    0x88, 0x01, 0x10,  //@+..@+.........@+..@+
    0x88, 0x01, 0x10,  //@+..@+.........@+..@+
    0xf8, 0x01, 0xf0,  //@@@@@+.........@@@@@+
    0xc8, 0x01, 0xb0,  //@%++@+.........@%++@+
    0x88, 0x01, 0x10,  //@+..@+.........@+..@+
    0x88, 0x01, 0x10,  //@+..@+.........@+..@+
    0xdc, 0x03, 0xb0,  //@%+%@%++++++++%@%+%@+
    0x7f, 0xff, 0xf0,  //+@@@@@@@@@@@@@@@@@@%.


    /*Unicode: U+f00b () , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xf9, 0xff, 0xe0,  //%@@@@..@@@@@@@@@@@%
    0xf9, 0xff, 0xe0,  //@@@@@+.@@@@@@@@@@@@
    0xf9, 0xff, 0xe0,  //@@@@@+.@@@@@@@@@@@@
    0xf9, 0xff, 0xe0,  //@@@@@..@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xf9, 0xff, 0xe0,  //@@@@@..@@@@@@@@@@@@
    0xf9, 0xff, 0xe0,  //@@@@@+.@@@@@@@@@@@@
    0xf9, 0xff, 0xe0,  //@@@@@+.@@@@@@@@@@@@
    0xf9, 0xff, 0xe0,  //%@@@@..@@@@@@@@@@@%
    0x00, 0x00, 0x00,  //...................
    0xf9, 0xff, 0xe0,  //@@@@@..@@@@@@@@@@@@
    0xf9, 0xff, 0xe0,  //@@@@@+.@@@@@@@@@@@@
    0xf9, 0xff, 0xe0,  //@@@@@+.@@@@@@@@@@@@
    0xf9, 0xff, 0xe0,  //@@@@@..@@@@@@@@@@@%
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f00c () , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x02, 0x00,  //.............+%..
    0x00, 0x07, 0x00,  //............+@@@.
    0x00, 0x0f, 0x80,  //...........+@@@@%
    0x00, 0x1f, 0x00,  //..........+@@@@@+
    0x30, 0x3e, 0x00,  //..@%.....+@@@@@+.
    0x78, 0x7c, 0x00,  //.@@@%...+@@@@@+..
    0xfc, 0xf8, 0x00,  //%@@@@%.+@@@@@+...
    0x7f, 0xf0, 0x00,  //.@@@@@%@@@@@+....
    0x3f, 0xe0, 0x00,  //..@@@@@@@@@+.....
    0x1f, 0xc0, 0x00,  //...@@@@@@@+......
    0x0f, 0x80, 0x00,  //....@@@@@+.......
    0x07, 0x00, 0x00,  //.....@@@+........
    0x02, 0x00, 0x00,  //......@+.........
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f00d () , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x20, 0x00,  //..%......++..
    0x70, 0x70,  //.@@@....+@@%.
    0xf8, 0xf0,  //@@@@@..+@@@@+
    0xfd, 0xf0,  //%@@@@@+@@@@@+
    0x7f, 0xe0,  //.%@@@@@@@@@+.
    0x3f, 0xc0,  //..%@@@@@@@+..
    0x1f, 0x80,  //...@@@@@@+...
    0x1f, 0xc0,  //..+@@@@@@@...
    0x3f, 0xe0,  //.+@@@@@@@@@..
    0x7f, 0xf0,  //+@@@@@@@@@@@.
    0xf9, 0xf8,  //@@@@@+.%@@@@%
    0x70, 0xf0,  //+@@@+...%@@@.
    0x20, 0x60,  //.+@+.....%@..
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+f011 () , Width: 17 */
    0x00, 0x00, 0x00,  //........+........
    0x01, 0xc0, 0x00,  //.......@@%.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x19, 0xcc, 0x00,  //...@@..@@@.+@%...
    0x39, 0xde, 0x00,  //..@@@+.@@@.%@@@..
    0x79, 0xcf, 0x00,  //.%@@@..@@@..@@@%.
    0x71, 0xc7, 0x00,  //+@@@...@@@...@@@.
    0xe1, 0xc7, 0x00,  //%@@+...@@@...%@@+
    0xe1, 0xc3, 0x80,  //@@@....@@@....@@%
    0xe1, 0x83, 0x80,  //@@@....%@+....@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@..........+@@%
    0x70, 0x07, 0x00,  //+@@%.........@@@+
    0x70, 0x0f, 0x00,  //.@@@+.......%@@@.
    0x3c, 0x1e, 0x00,  //.+@@@%....+@@@@..
    0x1f, 0xfc, 0x00,  //..+@@@@@@@@@@@+..
    0x0f, 0xf8, 0x00,  //...+@@@@@@@@@....
    0x03, 0xe0, 0x00,  //.....+%@@@%+.....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f013 () , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x01, 0xc0, 0x00,  //......+@@%.......
    0x03, 0xc0, 0x00,  //...+..%@@@..+....
    0x3b, 0xfc, 0x00,  //..%@@+@@@@%%@@...
    0x3f, 0xfe, 0x00,  //.+@@@@@@@@@@@@%..
    0x3f, 0xfc, 0x00,  //..@@@@@@@@@@@@...
    0x1f, 0x7c, 0x00,  //..+@@@@%+@@@@%...
    0x7c, 0x3e, 0x00,  //+%@@@@....%@@@%+.
    0xfc, 0x1f, 0x00,  //@@@@@%....+@@@@@+
    0xf8, 0x1f, 0x00,  //@@@@@+.....@@@@@+
    0xfc, 0x3f, 0x00,  //%@@@@@....%@@@@@.
    0x3e, 0x3c, 0x00,  //..%@@@%..+@@@@...
    0x3f, 0xfc, 0x00,  //..%@@@@@@@@@@@...
    0x3f, 0xfe, 0x00,  //.+@@@@@@@@@@@@%..
    0x3f, 0xfc, 0x00,  //..@@@@@@@@@@@@+..
    0x13, 0xc8, 0x00,  //...@+.%@@@..@+...
    0x03, 0xc0, 0x00,  //......+@@@.......
    0x00, 0x00, 0x00,  //.......++........
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f014 () , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x07, 0xc0,  //....+@@@@@.....
    0x0c, 0x60,  //....@%+++%@....
    0x08, 0x20,  //...+@+...+@+...
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0x60, 0x0c,  //.%%.........@%.
    0x60, 0x0c,  //.%%.........@%.
    0x69, 0x2c,  //.%%.%+.@.+%.@%.
    0x69, 0x6c,  //.%%.@+.@.%@.@%.
    0x69, 0x6c,  //.%%.@+.@.%@.@%.
    0x69, 0x6c,  //.%%.@+.@.%@.@%.
    0x69, 0x6c,  //.%%.@+.@.%@.@%.
    0x69, 0x6c,  //.%%.@+.@.%@.@%.
    0x69, 0x2c,  //.%%.@+.@.+@.@%.
    0x60, 0x0c,  //.%%.........@%.
    0x60, 0x0c,  //.%@.........@+.
    0x3f, 0xf8,  //..@@@@@@@@@@@..
    0x00, 0x00,  //...+++++++++...
    0x00, 0x00,  //...............


    /*Unicode: U+f015 () , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x06, 0x00,  //........++..+%%...
    0x01, 0xee, 0x00,  //.......%@@%.%@@...
    0x03, 0xfe, 0x00,  //......@@%%@@@@@...
    0x06, 0x1e, 0x00,  //....+@@++++@@@@...
    0x0d, 0xee, 0x00,  //...+@@+%@@%+@@@...
    0x3b, 0xf6, 0x00,  //..%@@.%@@@@%+@@+..
    0x77, 0xfb, 0x80,  //.%@@.@@@@@@@@+@@%.
    0x6f, 0xfd, 0x80,  //+@%+@@@@@@@@@@+%@+
    0x1f, 0xfe, 0x00,  //.+.@@@@@@@@@@@@...
    0x1f, 0xfe, 0x00,  //...@@@@@@@@@@@@...
    0x1f, 0x3e, 0x00,  //...@@@@%..%@@@@...
    0x1f, 0x3e, 0x00,  //...@@@@%..%@@@@...
    0x1f, 0x3e, 0x00,  //...@@@@%..%@@@@...
    0x1f, 0x3e, 0x00,  //...@@@@%..%@@@@...
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f019 () , Width: 18 */
    0x01, 0xc0, 0x00,  //.......%%%+.......
    0x01, 0xe0, 0x00,  //.......@@@@.......
    0x01, 0xe0, 0x00,  //.......@@@@.......
    0x01, 0xe0, 0x00,  //.......@@@@.......
    0x01, 0xe0, 0x00,  //.......@@@@.......
    0x01, 0xe0, 0x00,  //....+++@@@@++.....
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@@....
    0x0f, 0xf8, 0x00,  //....@@@@@@@@@+....
    0x07, 0xf0, 0x00,  //.....@@@@@@@+.....
    0x03, 0xf0, 0x00,  //......@@@@@+......
    0x01, 0xe0, 0x00,  //.......@@@%.......
    0xfc, 0xdf, 0x80,  //%@@@@@..@%.%@@@@@.
    0xfe, 0x1f, 0x80,  //@@@@@@@...+@@@@@@+
    0xff, 0x7f, 0x80,  //@@@@@@@@+%@@@@@@@+
    0xff, 0xf6, 0x80,  //@@@@@@@@@@@@++@.@+
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@%%@%@+
    0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f01c () , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x1f, 0xf8, 0x00,  //...@@@@@@@@@@+...
    0x3f, 0xfc, 0x00,  //..%@@@@@@@@@@@...
    0x30, 0x0c, 0x00,  //..@@........@@+..
    0x30, 0x0e, 0x00,  //.+@@........%@%..
    0x60, 0x06, 0x00,  //.@@+.........@@..
    0x60, 0x07, 0x00,  //.@@..........%@%.
    0xe0, 0x03, 0x00,  //%@%..........+@@.
    0xc0, 0x03, 0x00,  //@@+...........@@.
    0xfc, 0x1f, 0x00,  //@@@@@%....+@@@@@+
    0xfc, 0x3f, 0x00,  //@@@@@@+...@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f021 () , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x03, 0xc0, 0x00,  //.....+%%%%+......
    0x0f, 0xf1, 0x00,  //...+@@@@@@@@+.+@.
    0x3f, 0xff, 0x00,  //..%@@@@@@@@@@@@@.
    0x3c, 0x3f, 0x00,  //.+@@@%....%@@@@@.
    0x70, 0x1f, 0x00,  //.@@@+......%@@@@.
    0x70, 0x1f, 0x00,  //+@@%......+@@@@@.
    0xe0, 0x3f, 0x00,  //%@@.......@@@@@@.
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x78, 0x02, 0x00,  //+%%%%+.......+%+.
    0xfc, 0x07, 0x00,  //@@@@@@.......@@%.
    0xf8, 0x0e, 0x00,  //@@@@@.......@@@..
    0xf8, 0x1e, 0x00,  //@@@@@+....+@@@%..
    0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@...
    0xcf, 0xf8, 0x00,  //@%.+@@@@@@@@%....
    0x07, 0xe0, 0x00,  //.....%@@@@%......
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f026 () , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x01, 0x00,  //......+@.
    0x03, 0x00,  //.....+@@.
    0x07, 0x00,  //....+@@@.
    0x0f, 0x00,  //.+++@@@@.
    0xff, 0x00,  //@@@@@@@@.
    0xff, 0x00,  //@@@@@@@@.
    0xff, 0x00,  //@@@@@@@@.
    0xff, 0x00,  //@@@@@@@@.
    0xff, 0x00,  //@@@@@@@@.
    0x0f, 0x00,  //...+@@@@.
    0x07, 0x00,  //.....@@@.
    0x03, 0x00,  //......@@.
    0x01, 0x00,  //.......@.
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+f027 () , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x01, 0x00,  //......+@.....
    0x03, 0x00,  //.....+@@.....
    0x07, 0x00,  //....+@@@.....
    0x0f, 0x00,  //.+++@@@@.....
    0xff, 0x20,  //@@@@@@@@.+@+.
    0xff, 0x30,  //@@@@@@@@..%@.
    0xff, 0x10,  //@@@@@@@@...@.
    0xff, 0x30,  //@@@@@@@@..%@.
    0xff, 0x20,  //@@@@@@@@..@+.
    0x0f, 0x00,  //...+@@@@.....
    0x07, 0x00,  //.....@@@.....
    0x03, 0x00,  //......@@.....
    0x01, 0x00,  //.......@.....
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+f028 () , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x0c, 0x00,  //............@%....
    0x01, 0x06, 0x00,  //......+@....+@@...
    0x03, 0x13, 0x00,  //.....+@@...+..@%..
    0x07, 0x19, 0x00,  //....+@@@...@@..@+.
    0x0f, 0x0d, 0x80,  //...+@@@@....%@.%@.
    0xff, 0x66, 0x80,  //@@@@@@@@.%@+.@%+@.
    0xff, 0x32, 0x80,  //@@@@@@@@..%@.+@.@+
    0xff, 0x12, 0x80,  //@@@@@@@@...@.+@.@+
    0xff, 0x36, 0x80,  //@@@@@@@@..%@.%@.@+
    0xff, 0x26, 0x80,  //@@@@@@@@.+@..@%+@.
    0x0f, 0x0d, 0x80,  //...+@@@@....%@.%@.
    0x07, 0x19, 0x00,  //.....@@@...@@.+@+.
    0x03, 0x03, 0x00,  //......@@...+..@%..
    0x01, 0x06, 0x00,  //.......@....+@%...
    0x00, 0x08, 0x00,  //............@+....
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f03e () , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x7f, 0xff, 0xf0,  //+@@@@@@@@@@@@@@@@@@%.
    0xc0, 0x00, 0x10,  //@%+++++++++++++++++@+
    0x80, 0x00, 0x10,  //@+.................@+
    0x8c, 0x00, 0x10,  //@+.+@@+............@+
    0x9e, 0x00, 0x10,  //@+.@@@@............@+
    0x9e, 0x0c, 0x10,  //@+.@@@@.....%@.....@+
    0x8c, 0x1e, 0x10,  //@+.+@@+....+@@@....@+
    0x80, 0x1f, 0x10,  //@+........+@@@@@...@+
    0x80, 0x3f, 0x90,  //@+....+..+@@@@@@@..@+
    0x86, 0x7f, 0xd0,  //@+...@@++@@@@@@@@%.@+
    0x8f, 0xff, 0xd0,  //@+..@@@@@@@@@@@@@%.@+
    0x9f, 0xff, 0xd0,  //@+.@@@@@@@@@@@@@@%.@+
    0x9f, 0xff, 0xd0,  //@+.@@@@@@@@@@@@@@%.@+
    0x9f, 0xff, 0xd0,  //@+.@@@@@@@@@@@@@@%.@+
    0x80, 0x00, 0x10,  //@+.................@+
    0xff, 0xff, 0xf0,  //%@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00,  //.++++++++++++++++++..
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+f040 () , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x08, 0x00,  //...........+%....
    0x00, 0x3c, 0x00,  //..........%@@@...
    0x00, 0x3e, 0x00,  //..........@@@@@..
    0x00, 0x9f, 0x00,  //........%.+@@@@@.
    0x01, 0xcf, 0x00,  //.......%@@.+@@@@.
    0x03, 0xe6, 0x00,  //......%@%@@.+@@+.
    0x07, 0xf0, 0x00,  //.....%@%@@@@.++..
    0x0f, 0xf8, 0x00,  //....%@%@@@@@@....
    0x1f, 0xf0, 0x00,  //...%@%@@@@@@+....
    0x3f, 0xe0, 0x00,  //..%@%@@@@@@+.....
    0x7f, 0xc0, 0x00,  //.%@%@@@@@@+......
    0xff, 0x80, 0x00,  //%@@@@@@@@+.......
    0x9f, 0x00, 0x00,  //@+.%@@@@+........
    0xce, 0x00, 0x00,  //@%+.%@@+.........
    0xec, 0x00, 0x00,  //@@%.%@+..........
    0xf8, 0x00, 0x00,  //@@@@@+...........
    0x00, 0x00, 0x00,  //++++.............
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f048 () , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xe0, 0x20,  //@@%.......@
    0xe0, 0x60,  //@@@......@@
    0xe0, 0xe0,  //@@@.....@@@
    0xe1, 0xe0,  //@@@....@@@@
    0xe3, 0xe0,  //@@@...@@@@@
    0xe7, 0xe0,  //@@@..@@@@@@
    0xef, 0xe0,  //@@@.@@@@@@@
    0xff, 0xe0,  //@@@@@@@@@@@
    0xff, 0xe0,  //@@@@@@@@@@@
    0xef, 0xe0,  //@@@.@@@@@@@
    0xe7, 0xe0,  //@@@..@@@@@@
    0xe3, 0xe0,  //@@@...@@@@@
    0xe1, 0xe0,  //@@@....@@@@
    0xe0, 0xe0,  //@@@.....@@@
    0xe0, 0x60,  //@@@......@@
    0xe0, 0x20,  //@@@.......@
    0x00, 0x00,  //.+.........
    0x00, 0x00,  //...........


    /*Unicode: U+f04b () , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x80, 0x00,  //@+.............
    0xe0, 0x00,  //@@@+...........
    0xf8, 0x00,  //@@@@@..........
    0xfe, 0x00,  //@@@@@@%........
    0xff, 0x80,  //@@@@@@@@%......
    0xff, 0xc0,  //@@@@@@@@@@+....
    0xff, 0xf0,  //@@@@@@@@@@@@+..
    0xff, 0xfc,  //@@@@@@@@@@@@@%.
    0xff, 0xfe,  //@@@@@@@@@@@@@@%
    0xff, 0xf8,  //@@@@@@@@@@@@%..
    0xff, 0xe0,  //@@@@@@@@@@@+...
    0xff, 0x80,  //@@@@@@@@@+.....
    0xff, 0x00,  //@@@@@@@%.......
    0xfc, 0x00,  //@@@@@%.........
    0xf0, 0x00,  //@@@%...........
    0xc0, 0x00,  //@@+............
    0x00, 0x00,  //+..............
    0x00, 0x00,  //...............


    /*Unicode: U+f04c () , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xfe, 0x7f,  //@@@@@@%..%@@@@@@
    0xfe, 0x7f,  //@@@@@@@..@@@@@@@
    0xfe, 0x7f,  //@@@@@@@..@@@@@@@
    0xfe, 0x7f,  //@@@@@@@..@@@@@@@
    0xfe, 0x7f,  //@@@@@@@..@@@@@@@
    0xfe, 0x7f,  //@@@@@@@..@@@@@@@
    0xfe, 0x7f,  //@@@@@@@..@@@@@@@
    0xfe, 0x7f,  //@@@@@@@..@@@@@@@
    0xfe, 0x7f,  //@@@@@@@..@@@@@@@
    0xfe, 0x7f,  //@@@@@@@..@@@@@@@
    0xfe, 0x7f,  //@@@@@@@..@@@@@@@
    0xfe, 0x7f,  //@@@@@@@..@@@@@@@
    0xfe, 0x7f,  //@@@@@@@..@@@@@@@
    0xfe, 0x7f,  //@@@@@@@..@@@@@@@
    0xfe, 0x7f,  //@@@@@@@..@@@@@@@
    0xfe, 0x7f,  //@@@@@@%..%@@@@@@
    0x00, 0x00,  //.+++++....+++++.
    0x00, 0x00,  //................


    /*Unicode: U+f04d () , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00,  //.++++++++++++++..
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f051 () , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x80, 0xe0,  //%.......@@%
    0xc0, 0xe0,  //@%......@@@
    0xe0, 0xe0,  //@@%.....@@@
    0xf0, 0xe0,  //@@@%....@@@
    0xf8, 0xe0,  //@@@@%...@@@
    0xfc, 0xe0,  //@@@@@%..@@@
    0xfe, 0xe0,  //@@@@@@%.@@@
    0xff, 0xe0,  //@@@@@@@%@@@
    0xff, 0xe0,  //@@@@@@@@@@@
    0xfe, 0xe0,  //@@@@@@@.@@@
    0xfc, 0xe0,  //@@@@@@..@@@
    0xf8, 0xe0,  //@@@@@...@@@
    0xf0, 0xe0,  //@@@@....@@@
    0xe0, 0xe0,  //@@@.....@@@
    0xc0, 0xe0,  //@@......@@@
    0x80, 0xe0,  //@.......@@@
    0x00, 0x00,  //.........+.
    0x00, 0x00,  //...........


    /*Unicode: U+f052 () , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x01, 0x80, 0x00,  //.......%@........
    0x03, 0xc0, 0x00,  //......%@@@.......
    0x07, 0xe0, 0x00,  //.....%@@@@@......
    0x0f, 0xf0, 0x00,  //....%@@@@@@@.....
    0x1f, 0xf8, 0x00,  //...%@@@@@@@@@....
    0x3f, 0xfc, 0x00,  //..%@@@@@@@@@@@...
    0x7f, 0xfe, 0x00,  //.%@@@@@@@@@@@@@..
    0xff, 0xff, 0x00,  //%@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f053 () , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0xc0,  //........%@..
    0x01, 0xe0,  //.......%@@@.
    0x03, 0xf0,  //......%@@@@%
    0x07, 0xe0,  //.....%@@@@@.
    0x0f, 0xc0,  //....%@@@@@..
    0x1f, 0x80,  //...%@@@@@...
    0x3f, 0x00,  //..%@@@@@....
    0x7e, 0x00,  //.%@@@@@.....
    0x7c, 0x00,  //.@@@@@......
    0x7e, 0x00,  //.%@@@@%.....
    0x3f, 0x00,  //..%@@@@%....
    0x1f, 0x80,  //...%@@@@%...
    0x0f, 0xc0,  //....%@@@@%..
    0x07, 0xe0,  //.....%@@@@%.
    0x03, 0xe0,  //......%@@@@+
    0x01, 0xe0,  //.......%@@@.
    0x00, 0xc0,  //........%@..
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+f054 () , Width: 11 */
    0x00, 0x00,  //...........
    0x20, 0x00,  //.+@........
    0x70, 0x00,  //+@@@.......
    0xf8, 0x00,  //@@@@@......
    0x7c, 0x00,  //+@@@@@.....
    0x3e, 0x00,  //.+@@@@@....
    0x1f, 0x00,  //..+@@@@@...
    0x0f, 0x80,  //...+@@@@@..
    0x07, 0xc0,  //....+@@@@@.
    0x03, 0xe0,  //.....+@@@@@
    0x07, 0xc0,  //.....@@@@@+
    0x0f, 0x80,  //....@@@@@+.
    0x1f, 0x00,  //...@@@@@+..
    0x3e, 0x00,  //..@@@@@+...
    0x7c, 0x00,  //.@@@@@+....
    0xf8, 0x00,  //@@@@@+.....
    0x70, 0x00,  //+@@@+......
    0x20, 0x00,  //.+@+.......
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+f067 () , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x03, 0x80,  //.....+@@@......
    0x07, 0x80,  //.....%@@@+.....
    0x07, 0x80,  //.....%@@@+.....
    0x07, 0x80,  //.....%@@@+.....
    0x07, 0x80,  //.....%@@@+.....
    0x07, 0xc0,  //+++++@@@@%++++.
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0x7f, 0xfc,  //+%%%%@@@@@%%%%+
    0x07, 0x80,  //.....%@@@+.....
    0x07, 0x80,  //.....%@@@+.....
    0x07, 0x80,  //.....%@@@+.....
    0x07, 0x80,  //.....%@@@+.....
    0x03, 0x80,  //.....+@@@+.....
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+f068 () , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xff, 0xfe,  //@@@@@@@@@@@@@@%
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xff, 0xfe,  //%@@@@@@@@@@@@@%
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+f071 () , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0xe0, 0x00,  //........%@%........
    0x00, 0xe0, 0x00,  //.......+@@@+.......
    0x01, 0xf0, 0x00,  //.......@@@@@.......
    0x01, 0xf0, 0x00,  //......+@@@@@+......
    0x03, 0xf8, 0x00,  //......@@@@@@@......
    0x07, 0x1c, 0x00,  //.....%@@...@@%.....
    0x07, 0x1c, 0x00,  //.....@@@...@@@.....
    0x0f, 0x1e, 0x00,  //....%@@@...@@@%....
    0x0f, 0x1e, 0x00,  //....@@@@...@@@@....
    0x1f, 0x1f, 0x00,  //...%@@@@...@@@@%...
    0x1f, 0x1f, 0x00,  //..+@@@@@+++@@@@@+..
    0x3f, 0xff, 0x80,  //..@@@@@@@@@@@@@@@..
    0x3f, 0x1f, 0x80,  //.+@@@@@@...@@@@@@+.
    0x7f, 0x1f, 0xc0,  //.@@@@@@@...@@@@@@@.
    0xff, 0xff, 0xe0,  //%@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xe0,  //%@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f074 () , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x01, 0x00,  //...............@...
    0x00, 0x01, 0x80,  //...............@@..
    0xf0, 0x3f, 0xc0,  //@@@%+.....+%@@@@@@.
    0xfc, 0x7f, 0xe0,  //@@@@@@...@@@@@@@@@@
    0xfe, 0xff, 0xc0,  //@@@@@@@.@@@@@@@@@@+
    0x0f, 0xe1, 0x80,  //....@@%%@@%....@@+.
    0x05, 0xc1, 0x00,  //.....@+@@@.....@+..
    0x03, 0x80, 0x00,  //......%@@+.........
    0x03, 0x80, 0x00,  //......@@@..........
    0x03, 0x80, 0x00,  //.....+@@%..........
    0x07, 0x41, 0x00,  //.....@@@+@.....@+..
    0x0f, 0xe1, 0x80,  //....@@@%%@%....@@+.
    0xfe, 0xff, 0xc0,  //@@@@@@@.@@@@@@@@@@+
    0xfc, 0x7f, 0xe0,  //@@@@@@...@@@@@@@@@@
    0xf0, 0x3f, 0xc0,  //@@@%+.....%%@@@@@@.
    0x00, 0x01, 0x80,  //...............@@..
    0x00, 0x01, 0x00,  //...............@...
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f077 () , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x80, 0x00,  //.......+@+.......
    0x01, 0xc0, 0x00,  //......+@@@+......
    0x03, 0xe0, 0x00,  //.....+@@@@@+.....
    0x07, 0xf0, 0x00,  //....+@@@@@@@+....
    0x0f, 0xf8, 0x00,  //...+@@@@@@@@@+...
    0x1f, 0x7c, 0x00,  //..+@@@@@.@@@@@+..
    0x3e, 0x3e, 0x00,  //.+@@@@@...@@@@@+.
    0x7c, 0x1f, 0x00,  //+@@@@@.....@@@@@+
    0xf8, 0x0f, 0x80,  //@@@@@.......@@@@@
    0x70, 0x07, 0x00,  //.@@@.........@@@.
    0x20, 0x02, 0x00,  //..%...........%..
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f078 () , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x20, 0x02, 0x00,  //..%...........%..
    0x70, 0x07, 0x00,  //.@@%.........@@@.
    0xf8, 0x0f, 0x80,  //@@@@%.......%@@@@
    0xfc, 0x1f, 0x80,  //%@@@@%.....%@@@@%
    0x7e, 0x3f, 0x00,  //.%@@@@%...%@@@@%.
    0x3f, 0x7e, 0x00,  //..%@@@@%.%@@@@%..
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x0f, 0xf8, 0x00,  //....%@@@@@@@%....
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x03, 0xe0, 0x00,  //......%@@@%......
    0x01, 0xc0, 0x00,  //.......%@%.......
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f079 () , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x09, 0xff, 0xc0,  //...+@..%@@@@@@@@@@...
    0x1c, 0xff, 0xc0,  //...@@@..@@@@@@@@@@...
    0x3e, 0x7f, 0xc0,  //..@@@@@..@@@@@@@@@...
    0x7f, 0x01, 0xc0,  //.@@@@@@%.......@@@...
    0xff, 0x01, 0xc0,  //%@@@@@@@+......@@@...
    0x7f, 0x01, 0xc0,  //+%%@@@%%.......@@@...
    0x1c, 0x07, 0xf0,  //...@@@.......%%@@@%%.
    0x1c, 0x07, 0xf8,  //...@@@......+@@@@@@@%
    0x1c, 0x07, 0xf0,  //...@@@.......%@@@@@@.
    0x1f, 0xf3, 0xe0,  //...@@@@@@@@@..@@@@@..
    0x1f, 0xf9, 0xc0,  //...@@@@@@@@@@..@@@...
    0x1f, 0xfc, 0x80,  //...@@@@@@@@@@%..@+...
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+f07b () , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x7e, 0x00, 0x00,  //.%@@@@%...........
    0xff, 0x00, 0x00,  //%@@@@@@@..........
    0xff, 0x00, 0x00,  //@@@@@@@@+.........
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@+
    0x7f, 0xff, 0x80,  //.@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f093 () , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //........+.........
    0x00, 0xc0, 0x00,  //.......+@@........
    0x01, 0xe0, 0x00,  //......+@@@@.......
    0x03, 0xf0, 0x00,  //.....+@@@@@@......
    0x07, 0xf8, 0x00,  //....+@@@@@@@@.....
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@....
    0x0f, 0xfc, 0x00,  //....%%%@@@@%%%....
    0x01, 0xe0, 0x00,  //.......@@@@.......
    0x01, 0xe0, 0x00,  //.......@@@@.......
    0x01, 0xe0, 0x00,  //.......@@@@.......
    0x01, 0xe0, 0x00,  //.......@@@@.......
    0x01, 0xe0, 0x00,  //.......@@@%.......
    0xfc, 0x0f, 0x80,  //@@@@@@.....+@@@@@.
    0xff, 0xff, 0x80,  //@@@@@@@%%%@@@@@@@+
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@+
    0xff, 0xf6, 0x80,  //@@@@@@@@@@@@+%@.@+
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00,  //.++++++++++++++++.
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f095 () , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x30, 0x00,  //.+@%...........
    0x70, 0x00,  //+@@@...........
    0xf8, 0x00,  //@@@@@..........
    0xf8, 0x00,  //@@@@@+.........
    0xf8, 0x00,  //@@@@%..........
    0xf0, 0x00,  //%@@%...........
    0x70, 0x00,  //.@@%...........
    0x70, 0x00,  //.@@@+..........
    0x38, 0x00,  //..@@@..........
    0x3c, 0x00,  //..+@@@.....+...
    0x1e, 0x38,  //...%@@@+..%@@..
    0x0f, 0xfe,  //....%@@@%%@@@@%
    0x07, 0xfe,  //.....+@@@@@@@@@
    0x01, 0xfc,  //.......@@@@@@@+
    0x00, 0x78,  //.........%@@@+.
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+f0c4 () , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x38, 0x00, 0x00,  //.+%@%..............
    0xfe, 0x00, 0x00,  //%@@@@@%............
    0xc7, 0x01, 0xe0,  //@@..+@@%.......%%%%
    0xc3, 0x06, 0x20,  //@@....@@.....%%..+%
    0xe3, 0x08, 0x80,  //%@%...%@...+%...%+.
    0x7f, 0xa1, 0x00,  //.%@@@@@@%+%+...%...
    0x1f, 0x82, 0x00,  //...%@@%%%+...+%....
    0x00, 0xac, 0x00,  //.......+@+@.%%.....
    0x1f, 0x12, 0x00,  //...%@@%%.++%.+%....
    0x7f, 0xe1, 0x00,  //.%@@@@@%%%@+...%...
    0x63, 0x18, 0x80,  //+@@+..@@...%%...%+.
    0xc3, 0x06, 0x60,  //@@....%@.....%%..%%
    0xc7, 0x01, 0x20,  //@@...%@%......+%++%
    0xfe, 0x00, 0x00,  //%@@@@@@.........++.
    0x78, 0x00, 0x00,  //.%@@@+.............
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f0c5 () , Width: 19 */
    0x00, 0x00, 0x00,  //.......++++........
    0x07, 0xf0, 0x00,  //.....@@@@@@@.......
    0x0e, 0x10, 0x00,  //....@@@....@.......
    0x1e, 0x10, 0x00,  //...@@+@....@.......
    0x32, 0x10, 0x00,  //..@@.+@....@++++++.
    0x62, 0x1f, 0xe0,  //.@@..+@....@@@@@@@@
    0xfe, 0x1c, 0x20,  //%@@@@@@...+@@%...+@
    0xc0, 0x3c, 0x20,  //@%++++...+@%@%...+@
    0x80, 0x6c, 0x20,  //@+.......@%.@%...+@
    0x80, 0xcc, 0x20,  //@+......@%..@%...+@
    0x81, 0xfc, 0x20,  //@+.....@@@@@@%...+@
    0x81, 0x80, 0x20,  //@+.....@%++++....+@
    0x81, 0x00, 0x20,  //@+.....@+........+@
    0x81, 0x00, 0x20,  //@+.....@+........+@
    0xff, 0x00, 0x20,  //@@@@@@@@+........+@
    0x01, 0x00, 0x20,  //.++++++@+........+@
    0x01, 0x00, 0x20,  //.......@+........+@
    0x01, 0x00, 0x20,  //.......@+........+@
    0x01, 0x80, 0x60,  //.......@%++++++++%@
    0x01, 0xff, 0xe0,  //.......%@@@@@@@@@@%


    /*Unicode: U+f0c7 () , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xff, 0xf0, 0x00,  //%@@@@@@@@@@@+....
    0xde, 0x78, 0x00,  //@%+@@@@++%@%@+...
    0x9e, 0x24, 0x00,  //@+.@@@@..+@.+@+..
    0x9e, 0x22, 0x00,  //@+.@@@@..+@..+@+.
    0x9e, 0x23, 0x00,  //@+.@@@@..+@...%@.
    0x9e, 0x61, 0x00,  //@+.@@@@++%@....@.
    0x9f, 0xe1, 0x00,  //@+.@@@@@@@%....@+
    0x80, 0x01, 0x00,  //@+.............@+
    0x80, 0x01, 0x00,  //@+.............@+
    0x80, 0x01, 0x00,  //@+..+++++++++..@+
    0x9f, 0xf9, 0x00,  //@+.@@@@@@@@@@+.@+
    0x90, 0x09, 0x00,  //@+.@+.......@+.@+
    0x90, 0x09, 0x00,  //@+.@+.......@+.@+
    0x90, 0x09, 0x00,  //@+.@+.......@+.@+
    0x90, 0x09, 0x00,  //@+.@+.......@+.@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00,  //.+++++++++++++++.
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f0e7 () , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x3c, 0x00,  //..@@@@+...
    0x3c, 0x00,  //..@@@@....
    0x3c, 0x00,  //.+@@@@....
    0x78, 0x00,  //.%@@@+....
    0x78, 0x00,  //.@@@@...+.
    0x7f, 0x80,  //.@@@@%@@@+
    0x7f, 0x80,  //+@@@@@@@@.
    0xff, 0x00,  //%@@@@@@@+.
    0xff, 0x00,  //@@@@%@@@..
    0x86, 0x00,  //%+..+@@+..
    0x0e, 0x00,  //....%@@...
    0x0c, 0x00,  //....@@+...
    0x0c, 0x00,  //....@@....
    0x0c, 0x00,  //...+@%....
    0x18, 0x00,  //...%@.....
    0x18, 0x00,  //...@%.....
    0x10, 0x00,  //...@......
    0x00, 0x00,  //...+......


    /*Unicode: U+f0f3 () , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0xc0, 0x00,  //........@%........
    0x01, 0xe0, 0x00,  //......+%@@%.......
    0x07, 0xf0, 0x00,  //.....%@@@@@@+.....
    0x0f, 0xf8, 0x00,  //....%@@@@@@@@+....
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@....
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@@....
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@@+...
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@@+...
    0x1f, 0xfc, 0x00,  //...@@@@@@@@@@@+...
    0x1f, 0xfe, 0x00,  //...@@@@@@@@@@@%...
    0x1f, 0xfe, 0x00,  //...@@@@@@@@@@@@...
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@@+..
    0x3f, 0xff, 0x00,  //..@@@@@@@@@@@@@%..
    0x7f, 0xff, 0x00,  //.%@@@@@@@@@@@@@@+.
    0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@+
    0x03, 0xf0, 0x00,  //......@%@@@%......
    0x01, 0xe0, 0x00,  //......+%%@@.......
    0x00, 0xc0, 0x00,  //.......+@%........


    /*Unicode: U+f11c () , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@.
    0x80, 0x00, 0x10,  //@+.................@+
    0x80, 0x00, 0x10,  //@+.+..+.+..+..+.+..@+
    0x92, 0x92, 0x90,  //@+.@+.@.@+.@.+@.@+.@+
    0x80, 0x00, 0x90,  //@+..............@+.@+
    0x9d, 0x6d, 0x90,  //@+.@@@.@.%@.@%+@@+.@+
    0x80, 0x00, 0x10,  //@+.+++.+..+.+..++..@+
    0x80, 0x00, 0x10,  //@+.................@+
    0x93, 0xfe, 0x90,  //@+.@+.@@@@@@@@@.@+.@+
    0x80, 0x00, 0x10,  //@+.+..+++++++++.+..@+
    0xc0, 0x00, 0x10,  //@%+++++++++++++++++@+
    0xff, 0xff, 0xf0,  //%@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+f124 () , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //.............++
    0x00, 0x0e,  //...........+@@@
    0x00, 0x3c,  //.........+@@@@+
    0x00, 0xfc,  //.......+@@@@@@.
    0x03, 0xf8,  //.....+@@@@@@@+.
    0x0f, 0xf8,  //...+@@@@@@@@@..
    0x3f, 0xf0,  //.+@@@@@@@@@@+..
    0xff, 0xf0,  //%@@@@@@@@@@@...
    0x7f, 0xe0,  //+%%%%%%@@@@+...
    0x01, 0xe0,  //.......@@@@....
    0x01, 0xc0,  //.......@@@+....
    0x01, 0xc0,  //.......@@@.....
    0x01, 0x80,  //.......@@+.....
    0x01, 0x80,  //.......@@......
    0x01, 0x00,  //.......@+......
    0x00, 0x00,  //.......+.......
    0x00, 0x00,  //...............


    /*Unicode: U+f15b () , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0xff, 0x80, 0x00,  //%@@@@@@@@+.......
    0xff, 0x90, 0x00,  //@@@@@@@@@+.@.....
    0xff, 0x98, 0x00,  //@@@@@@@@@+.@@....
    0xff, 0x9c, 0x00,  //@@@@@@@@@+.@@@...
    0xff, 0x9e, 0x00,  //@@@@@@@@@+.@@@@..
    0xff, 0xc0, 0x00,  //@@@@@@@@@+.+++++.
    0xff, 0xc0, 0x00,  //@@@@@@@@@@.......
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.


    /*Unicode: U+f1eb () , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x01, 0xfc, 0x00,  //......+%@@@@@%+......
    0x0f, 0xff, 0x80,  //....%@@@@@@@@@@@%....
    0x3f, 0xff, 0xe0,  //..%@@@@@@@@@@@@@@@%..
    0x7e, 0x03, 0xf0,  //.%@@@@%+......%@@@@@.
    0xf8, 0xf8, 0x78,  //%@@@%..+%%@%%+..+@@@@
    0x67, 0xff, 0x30,  //.@@..%@@@@@@@@@%..@@.
    0x0f, 0xff, 0x80,  //....@@@@@@@@@@@@@+...
    0x1f, 0x07, 0xc0,  //...%@@@%+....%@@@@...
    0x0c, 0x79, 0x80,  //....@%..+%@%%..%@....
    0x01, 0xfe, 0x00,  //......+@@@@@@@%......
    0x03, 0xfe, 0x00,  //......@@@@@@@@@......
    0x01, 0x8c, 0x00,  //.......@%...%@.......
    0x00, 0x20, 0x00,  //.........+%+.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x20, 0x00,  //..........@+.........
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+f240 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.+++++++++++++++++++++...
    0xff, 0xff, 0xfe, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0x80, 0x00, 0x02, 0x00,  //@+...................+@..
    0x9f, 0xff, 0xfa, 0x00,  //@+.@@@@@@@@@@@@@@@@@%+@..
    0x9f, 0xff, 0xfb, 0x00,  //@+.@@@@@@@@@@@@@@@@@%+@@.
    0x9f, 0xff, 0xf9, 0x00,  //@+.@@@@@@@@@@@@@@@@@%.+@+
    0x9f, 0xff, 0xf9, 0x00,  //@+.@@@@@@@@@@@@@@@@@%..@+
    0x9f, 0xff, 0xf9, 0x00,  //@+.@@@@@@@@@@@@@@@@@%..@+
    0x9f, 0xff, 0xf9, 0x00,  //@+.@@@@@@@@@@@@@@@@@%..@+
    0x9f, 0xff, 0xfb, 0x00,  //@+.@@@@@@@@@@@@@@@@@%.%@+
    0x9f, 0xff, 0xfa, 0x00,  //@+.@@@@@@@@@@@@@@@@@%+@+.
    0x80, 0x00, 0x02, 0x00,  //@+...................+@..
    0xc0, 0x00, 0x06, 0x00,  //@%+++++++++++++++++++%@..
    0x7f, 0xff, 0xfc, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f241 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.+++++++++++++++++++++...
    0xff, 0xff, 0xfe, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0x80, 0x00, 0x02, 0x00,  //@+...................+@..
    0x9f, 0xff, 0x82, 0x00,  //@+.@@@@@@@@@@@@@%....+@..
    0x9f, 0xff, 0x83, 0x00,  //@+.@@@@@@@@@@@@@%....+@@.
    0x9f, 0xff, 0x81, 0x00,  //@+.@@@@@@@@@@@@@%.....+@+
    0x9f, 0xff, 0x81, 0x00,  //@+.@@@@@@@@@@@@@%......@+
    0x9f, 0xff, 0x81, 0x00,  //@+.@@@@@@@@@@@@@%......@+
    0x9f, 0xff, 0x81, 0x00,  //@+.@@@@@@@@@@@@@%......@+
    0x9f, 0xff, 0x83, 0x00,  //@+.@@@@@@@@@@@@@%.....%@+
    0x9f, 0xff, 0x82, 0x00,  //@+.@@@@@@@@@@@@@%....+@+.
    0x80, 0x00, 0x02, 0x00,  //@+...................+@..
    0xc0, 0x00, 0x06, 0x00,  //@%+++++++++++++++++++%@..
    0x7f, 0xff, 0xfc, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f242 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.+++++++++++++++++++++...
    0xff, 0xff, 0xfe, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0x80, 0x00, 0x02, 0x00,  //@+...................+@..
    0x9f, 0xf0, 0x02, 0x00,  //@++@@@@@@@@@.........+@..
    0x9f, 0xf0, 0x03, 0x00,  //@++@@@@@@@@@.........+@@.
    0x9f, 0xf0, 0x01, 0x00,  //@++@@@@@@@@@..........+@+
    0x9f, 0xf0, 0x01, 0x00,  //@++@@@@@@@@@...........@+
    0x9f, 0xf0, 0x01, 0x00,  //@++@@@@@@@@@...........@+
    0x9f, 0xf0, 0x01, 0x00,  //@++@@@@@@@@@...........@+
    0x9f, 0xf0, 0x03, 0x00,  //@++@@@@@@@@@..........%@+
    0x9f, 0xf0, 0x02, 0x00,  //@++@@@@@@@@@.........+@+.
    0x80, 0x00, 0x02, 0x00,  //@+...................+@..
    0xc0, 0x00, 0x06, 0x00,  //@%+++++++++++++++++++%@..
    0x7f, 0xff, 0xfc, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f243 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.+++++++++++++++++++++...
    0xff, 0xff, 0xfe, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0x80, 0x00, 0x02, 0x00,  //@+...................+@..
    0x9f, 0x00, 0x02, 0x00,  //@++@@@@@.............+@..
    0x9f, 0x00, 0x03, 0x00,  //@++@@@@@.............+@@.
    0x9f, 0x00, 0x01, 0x00,  //@++@@@@@..............+@+
    0x9f, 0x00, 0x01, 0x00,  //@++@@@@@...............@+
    0x9f, 0x00, 0x01, 0x00,  //@++@@@@@...............@+
    0x9f, 0x00, 0x01, 0x00,  //@++@@@@@...............@+
    0x9f, 0x00, 0x03, 0x00,  //@++@@@@@..............%@+
    0x9f, 0x00, 0x02, 0x00,  //@++@@@@@.............+@+.
    0x80, 0x00, 0x02, 0x00,  //@+...................+@..
    0xc0, 0x00, 0x06, 0x00,  //@%+++++++++++++++++++%@..
    0x7f, 0xff, 0xfc, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f244 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.+++++++++++++++++++++...
    0xff, 0xff, 0xfe, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0x80, 0x00, 0x02, 0x00,  //@+...................+@..
    0x80, 0x00, 0x02, 0x00,  //@+...................+@..
    0x80, 0x00, 0x03, 0x00,  //@+...................+@@.
    0x80, 0x00, 0x01, 0x00,  //@+....................+@+
    0x80, 0x00, 0x01, 0x00,  //@+.....................@+
    0x80, 0x00, 0x01, 0x00,  //@+.....................@+
    0x80, 0x00, 0x01, 0x00,  //@+.....................@+
    0x80, 0x00, 0x03, 0x00,  //@+....................%@+
    0x80, 0x00, 0x03, 0x00,  //@+...................+@%.
    0x80, 0x00, 0x02, 0x00,  //@+...................+@..
    0xc0, 0x00, 0x06, 0x00,  //@%+++++++++++++++++++%@..
    0x7f, 0xff, 0xfe, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f293 () , Width: 14 */
    0x00, 0x00,  //..............
    0x0f, 0xc0,  //...+%@@@@%+...
    0x3f, 0xf0,  //..%@@@@@@@@%..
    0x3c, 0xf0,  //.+@@@@++@@@@+.
    0x7c, 0x78,  //.@@@@@+.+@@@@.
    0x7c, 0x38,  //+@@@@@+..+@@@+
    0xec, 0x9c,  //%@@+@@+.%.+@@%
    0xe4, 0x9c,  //@@@..@+.@..@@@
    0xf0, 0x3c,  //@@@@......@@@@
    0xf8, 0x7c,  //@@@@@....@@@@@
    0xfc, 0xfc,  //@@@@@@..%@@@@@
    0xf8, 0x7c,  //@@@@@....@@@@@
    0xf0, 0x3c,  //@@@@......@@@@
    0xe4, 0x9c,  //@@@..@+.@..@@@
    0xec, 0x9c,  //%@@+@@+.%.+@@%
    0x7c, 0x38,  //+@@@@@+..+@@@+
    0x7c, 0x78,  //.@@@@@+.+@@@@.
    0x3c, 0xf0,  //.+@@@@++@@@@+.
    0x3f, 0xf0,  //..%@@@@@@@@%..
    0x0f, 0xc0,  //....%@@@@%....



#elif USE_LV_FONT_SYMBOL_20 == 2
    /*Unicode: U+f001 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x06, 0x00,  //..............+%.
    0x00, 0x00, 0x01, 0xff, 0x40,  //...........+@@@@+
    0x00, 0x00, 0xbf, 0xff, 0x40,  //........%@@@@@@@+
    0x00, 0x0f, 0xff, 0xff, 0x40,  //......@@@@@@@@@@+
    0x00, 0x1f, 0xff, 0xff, 0x40,  //.....+@@@@@@@@@@+
    0x00, 0x1f, 0xff, 0xff, 0x40,  //.....+@@@@@@@@@@+
    0x00, 0x1f, 0xff, 0x93, 0x40,  //.....+@@@@@@%+.@+
    0x00, 0x1f, 0xe4, 0x03, 0x40,  //.....+@@@%+....@+
    0x00, 0x1d, 0x00, 0x03, 0x40,  //.....+@+.......@+
    0x00, 0x1c, 0x00, 0x03, 0x40,  //.....+@........@+
    0x00, 0x1c, 0x00, 0x03, 0x40,  //.....+@........@+
    0x00, 0x1c, 0x02, 0xab, 0x40,  //.....+@....%%%%@+
    0x00, 0x1c, 0x0f, 0xff, 0x40,  //.....+@...@@@@@@+
    0x00, 0x1c, 0x1f, 0xff, 0x40,  //.....+@..+@@@@@@+
    0x2f, 0xfc, 0x0b, 0xfe, 0x00,  //.%@@@@@...%@@@@%.
    0xbf, 0xfc, 0x00, 0x00, 0x00,  //%@@@@@@..........
    0xbf, 0xfc, 0x00, 0x00, 0x00,  //%@@@@@@..........
    0x2f, 0xe0, 0x00, 0x00, 0x00,  //.+@@@%...........


    /*Unicode: U+f008 () , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x7f, 0xff, 0xff, 0xff, 0xfe, 0x00,  //+@@@@@@@@@@@@@@@@@@%.
    0xe5, 0xe5, 0x55, 0x5b, 0x97, 0x40,  //@%++@%++++++++%@%++@+
    0xd0, 0xd0, 0x00, 0x03, 0x43, 0x40,  //@+..@+.........@+..@+
    0xd0, 0xd0, 0x00, 0x03, 0x43, 0x40,  //@+..@+.........@+..@+
    0xff, 0xd0, 0x00, 0x03, 0xff, 0x40,  //@@@@@+.........@@@@@+
    0xe5, 0xd0, 0x00, 0x03, 0x97, 0x40,  //@%++@+.........@%++@+
    0xd0, 0xd0, 0x00, 0x03, 0x43, 0x40,  //@+..@+.........@+..@+
    0xd0, 0xd0, 0x00, 0x03, 0x43, 0x40,  //@+..@+.........@+..@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@@@@@+
    0xe5, 0xe5, 0x55, 0x5b, 0x97, 0x40,  //@%++@%++++++++%@%++@+
    0xd0, 0xd0, 0x00, 0x03, 0x43, 0x40,  //@+..@+.........@+..@+
    0xd0, 0xd0, 0x00, 0x03, 0x43, 0x40,  //@+..@+.........@+..@+
    0xff, 0xd0, 0x00, 0x03, 0xff, 0x40,  //@@@@@+.........@@@@@+
    0xe5, 0xd0, 0x00, 0x03, 0x9b, 0x40,  //@%++@+.........@%++@+
    0xd0, 0xd0, 0x00, 0x03, 0x43, 0x40,  //@+..@+.........@+..@+
    0xd0, 0xd0, 0x00, 0x03, 0x43, 0x40,  //@+..@+.........@+..@+
    0xe6, 0xe5, 0x55, 0x5b, 0x9b, 0x40,  //@%+%@%++++++++%@%+%@+
    0x7f, 0xff, 0xff, 0xff, 0xfe, 0x00,  //+@@@@@@@@@@@@@@@@@@%.


    /*Unicode: U+f00b () , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xc3, 0xff, 0xff, 0xfc,  //%@@@@..@@@@@@@@@@@%
    0xff, 0xd3, 0xff, 0xff, 0xfc,  //@@@@@+.@@@@@@@@@@@@
    0xff, 0xd3, 0xff, 0xff, 0xfc,  //@@@@@+.@@@@@@@@@@@@
    0xff, 0xc3, 0xff, 0xff, 0xfc,  //@@@@@..@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xd3, 0xff, 0xff, 0xfc,  //@@@@@..@@@@@@@@@@@@
    0xff, 0xd3, 0xff, 0xff, 0xfc,  //@@@@@+.@@@@@@@@@@@@
    0xff, 0xd3, 0xff, 0xff, 0xfc,  //@@@@@+.@@@@@@@@@@@@
    0xff, 0xc3, 0xff, 0xff, 0xfc,  //%@@@@..@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xd3, 0xff, 0xff, 0xfc,  //@@@@@..@@@@@@@@@@@@
    0xff, 0xd3, 0xff, 0xff, 0xfc,  //@@@@@+.@@@@@@@@@@@@
    0xff, 0xd3, 0xff, 0xff, 0xfc,  //@@@@@+.@@@@@@@@@@@@
    0xff, 0xc3, 0xff, 0xff, 0xfc,  //@@@@@..@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f00c () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x18, 0x00,  //.............+%..
    0x00, 0x00, 0x00, 0x7f, 0x00,  //............+@@@.
    0x00, 0x00, 0x01, 0xff, 0x80,  //...........+@@@@%
    0x00, 0x00, 0x07, 0xff, 0x40,  //..........+@@@@@+
    0x0e, 0x00, 0x1f, 0xfd, 0x00,  //..@%.....+@@@@@+.
    0x3f, 0x80, 0x7f, 0xf4, 0x00,  //.@@@%...+@@@@@+..
    0xbf, 0xe1, 0xff, 0xd0, 0x00,  //%@@@@%.+@@@@@+...
    0x3f, 0xfb, 0xff, 0x40, 0x00,  //.@@@@@%@@@@@+....
    0x0f, 0xff, 0xfd, 0x00, 0x00,  //..@@@@@@@@@+.....
    0x03, 0xff, 0xf4, 0x00, 0x00,  //...@@@@@@@+......
    0x00, 0xff, 0xd0, 0x00, 0x00,  //....@@@@@+.......
    0x00, 0x3f, 0x40, 0x00, 0x00,  //.....@@@+........
    0x00, 0x0d, 0x00, 0x00, 0x00,  //......@+.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f00d () , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x08, 0x00, 0x14, 0x00,  //..%......++..
    0x3f, 0x00, 0x7e, 0x00,  //.@@@....+@@%.
    0xff, 0xc1, 0xff, 0x40,  //@@@@@..+@@@@+
    0xbf, 0xf7, 0xff, 0x40,  //%@@@@@+@@@@@+
    0x2f, 0xff, 0xfd, 0x00,  //.%@@@@@@@@@+.
    0x0b, 0xff, 0xf4, 0x00,  //..%@@@@@@@+..
    0x03, 0xff, 0xd0, 0x00,  //...@@@@@@+...
    0x07, 0xff, 0xf0, 0x00,  //..+@@@@@@@...
    0x1f, 0xff, 0xfc, 0x00,  //.+@@@@@@@@@..
    0x7f, 0xff, 0xff, 0x00,  //+@@@@@@@@@@@.
    0xff, 0xd2, 0xff, 0x80,  //@@@@@+.%@@@@%
    0x7f, 0x40, 0xbf, 0x00,  //+@@@+...%@@@.
    0x1d, 0x00, 0x2c, 0x00,  //.+@+.....%@..
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+f011 () , Width: 17 */
    0x00, 0x00, 0x40, 0x00, 0x00,  //........+........
    0x00, 0x03, 0xe0, 0x00, 0x00,  //.......@@%.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x03, 0xc3, 0xf1, 0xe0, 0x00,  //...@@..@@@.+@%...
    0x0f, 0xd3, 0xf2, 0xfc, 0x00,  //..@@@+.@@@.%@@@..
    0x2f, 0xc3, 0xf0, 0xfe, 0x00,  //.%@@@..@@@..@@@%.
    0x7f, 0x03, 0xf0, 0x3f, 0x00,  //+@@@...@@@...@@@.
    0xbd, 0x03, 0xf0, 0x2f, 0x40,  //%@@+...@@@...%@@+
    0xfc, 0x03, 0xf0, 0x0f, 0x80,  //@@@....@@@....@@%
    0xfc, 0x02, 0xd0, 0x0f, 0xc0,  //@@@....%@+....@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x1f, 0x80,  //@@@..........+@@%
    0x7e, 0x00, 0x00, 0x3f, 0x40,  //+@@%.........@@@+
    0x3f, 0x40, 0x00, 0xbf, 0x00,  //.@@@+.......%@@@.
    0x1f, 0xe0, 0x07, 0xfc, 0x00,  //.+@@@%....+@@@@..
    0x07, 0xff, 0xff, 0xf4, 0x00,  //..+@@@@@@@@@@@+..
    0x01, 0xff, 0xff, 0xc0, 0x00,  //...+@@@@@@@@@....
    0x00, 0x1b, 0xf9, 0x00, 0x00,  //.....+%@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f013 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x07, 0xe0, 0x00, 0x00,  //......+@@%.......
    0x01, 0x0b, 0xf0, 0x40, 0x00,  //...+..%@@@..+....
    0x0b, 0xdf, 0xfa, 0xf0, 0x00,  //..%@@+@@@@%%@@...
    0x1f, 0xff, 0xff, 0xf8, 0x00,  //.+@@@@@@@@@@@@%..
    0x0f, 0xff, 0xff, 0xf0, 0x00,  //..@@@@@@@@@@@@...
    0x07, 0xfe, 0x7f, 0xe0, 0x00,  //..+@@@@%+@@@@%...
    0x6f, 0xf0, 0x0b, 0xf9, 0x00,  //+%@@@@....%@@@%+.
    0xff, 0xe0, 0x07, 0xff, 0x40,  //@@@@@%....+@@@@@+
    0xff, 0xd0, 0x03, 0xff, 0x40,  //@@@@@+.....@@@@@+
    0xbf, 0xf0, 0x0b, 0xff, 0x00,  //%@@@@@....%@@@@@.
    0x0b, 0xf8, 0x1f, 0xf0, 0x00,  //..%@@@%..+@@@@...
    0x0b, 0xff, 0xff, 0xf0, 0x00,  //..%@@@@@@@@@@@...
    0x1f, 0xff, 0xff, 0xf8, 0x00,  //.+@@@@@@@@@@@@%..
    0x0f, 0xff, 0xff, 0xf4, 0x00,  //..@@@@@@@@@@@@+..
    0x03, 0x4b, 0xf0, 0xd0, 0x00,  //...@+.%@@@..@+...
    0x00, 0x0b, 0xf0, 0x00, 0x00,  //......+@@@.......
    0x00, 0x01, 0x40, 0x00, 0x00,  //.......++........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f014 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x7f, 0xf0, 0x00,  //....+@@@@@.....
    0x00, 0xe5, 0x6c, 0x00,  //....@%+++%@....
    0x01, 0xd0, 0x1d, 0x00,  //...+@+...+@+...
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0x2c, 0x00, 0x00, 0xe0,  //.%%.........@%.
    0x28, 0x00, 0x00, 0xe0,  //.%%.........@%.
    0x28, 0x93, 0x18, 0xe0,  //.%%.%+.@.+%.@%.
    0x28, 0xd3, 0x2c, 0xe0,  //.%%.@+.@.%@.@%.
    0x28, 0xd3, 0x2c, 0xe0,  //.%%.@+.@.%@.@%.
    0x28, 0xd3, 0x2c, 0xe0,  //.%%.@+.@.%@.@%.
    0x28, 0xd3, 0x2c, 0xe0,  //.%%.@+.@.%@.@%.
    0x28, 0xd3, 0x2c, 0xe0,  //.%%.@+.@.%@.@%.
    0x28, 0xd3, 0x1c, 0xe0,  //.%%.@+.@.+@.@%.
    0x28, 0x00, 0x00, 0xe0,  //.%%.........@%.
    0x2c, 0x00, 0x00, 0xe0,  //.%@.........@+.
    0x0f, 0xff, 0xff, 0xc0,  //..@@@@@@@@@@@..
    0x01, 0x55, 0x55, 0x00,  //...+++++++++...
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f015 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x50, 0x68, 0x00,  //........++..+%%...
    0x00, 0x02, 0xf8, 0xbc, 0x00,  //.......%@@%.%@@...
    0x00, 0x0f, 0xaf, 0xfc, 0x00,  //......@@%%@@@@@...
    0x00, 0x7d, 0x57, 0xfc, 0x00,  //....+@@++++@@@@...
    0x01, 0xf6, 0xf9, 0xfc, 0x00,  //...+@@+%@@%+@@@...
    0x0b, 0xcb, 0xfe, 0x7d, 0x00,  //..%@@.%@@@@%+@@+..
    0x2f, 0x3f, 0xff, 0xdf, 0x80,  //.%@@.@@@@@@@@+@@%.
    0x79, 0xff, 0xff, 0xf6, 0xd0,  //+@%+@@@@@@@@@@+%@+
    0x13, 0xff, 0xff, 0xfc, 0x40,  //.+.@@@@@@@@@@@@...
    0x03, 0xff, 0xff, 0xfc, 0x00,  //...@@@@@@@@@@@@...
    0x03, 0xfe, 0x0b, 0xfc, 0x00,  //...@@@@%..%@@@@...
    0x03, 0xfe, 0x0b, 0xfc, 0x00,  //...@@@@%..%@@@@...
    0x03, 0xfe, 0x0b, 0xfc, 0x00,  //...@@@@%..%@@@@...
    0x03, 0xfe, 0x0b, 0xfc, 0x00,  //...@@@@%..%@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f019 () , Width: 18 */
    0x00, 0x02, 0xa4, 0x00, 0x00,  //.......%%%+.......
    0x00, 0x03, 0xfc, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x03, 0xfc, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x03, 0xfc, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x03, 0xfc, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x57, 0xfd, 0x50, 0x00,  //....+++@@@@++.....
    0x02, 0xff, 0xff, 0xf0, 0x00,  //...%@@@@@@@@@@....
    0x00, 0xff, 0xff, 0xd0, 0x00,  //....@@@@@@@@@+....
    0x00, 0x3f, 0xff, 0x40, 0x00,  //.....@@@@@@@+.....
    0x00, 0x0f, 0xfe, 0x00, 0x00,  //......@@@@@+......
    0x00, 0x03, 0xf8, 0x00, 0x00,  //.......@@@%.......
    0xbf, 0xf0, 0xe2, 0xff, 0xc0,  //%@@@@@..@%.%@@@@@.
    0xff, 0xfc, 0x07, 0xff, 0xd0,  //@@@@@@@...+@@@@@@+
    0xff, 0xff, 0x6f, 0xff, 0xd0,  //@@@@@@@@+%@@@@@@@+
    0xff, 0xff, 0xff, 0x6c, 0xd0,  //@@@@@@@@@@@@++@.@+
    0xff, 0xff, 0xff, 0xae, 0xd0,  //@@@@@@@@@@@@%%@%@+
    0xff, 0xff, 0xff, 0xff, 0xc0,  //%@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f01c () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x03, 0xff, 0xff, 0xd0, 0x00,  //...@@@@@@@@@@+...
    0x0b, 0xff, 0xff, 0xf0, 0x00,  //..%@@@@@@@@@@@...
    0x0f, 0x00, 0x00, 0xf4, 0x00,  //..@@........@@+..
    0x1f, 0x00, 0x00, 0xb8, 0x00,  //.+@@........%@%..
    0x3d, 0x00, 0x00, 0x3c, 0x00,  //.@@+.........@@..
    0x3c, 0x00, 0x00, 0x2e, 0x00,  //.@@..........%@%.
    0xb8, 0x00, 0x00, 0x1f, 0x00,  //%@%..........+@@.
    0xf4, 0x00, 0x00, 0x0f, 0x00,  //@@+...........@@.
    0xff, 0xe0, 0x07, 0xff, 0x40,  //@@@@@%....+@@@@@+
    0xff, 0xf4, 0x0f, 0xff, 0x40,  //@@@@@@+...@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f021 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x1a, 0xa4, 0x00, 0x00,  //.....+%%%%+......
    0x01, 0xff, 0xff, 0x47, 0x00,  //...+@@@@@@@@+.+@.
    0x0b, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@@@@@.
    0x1f, 0xe0, 0x0b, 0xff, 0x00,  //.+@@@%....%@@@@@.
    0x3f, 0x40, 0x02, 0xff, 0x00,  //.@@@+......%@@@@.
    0x7e, 0x00, 0x07, 0xff, 0x00,  //+@@%......+@@@@@.
    0xbc, 0x00, 0x0f, 0xff, 0x00,  //%@@.......@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x6a, 0x90, 0x00, 0x19, 0x00,  //+%%%%+.......+%+.
    0xff, 0xf0, 0x00, 0x3e, 0x00,  //@@@@@@.......@@%.
    0xff, 0xc0, 0x00, 0xfc, 0x00,  //@@@@@.......@@@..
    0xff, 0xd0, 0x07, 0xf8, 0x00,  //@@@@@+....+@@@%..
    0xff, 0xff, 0xff, 0xf0, 0x00,  //@@@@@@@@@@@@@@...
    0xe1, 0xff, 0xff, 0x80, 0x00,  //@%.+@@@@@@@@%....
    0x00, 0x2f, 0xf8, 0x00, 0x00,  //.....%@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f026 () , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x07, 0x00,  //......+@.
    0x00, 0x1f, 0x00,  //.....+@@.
    0x00, 0x7f, 0x00,  //....+@@@.
    0x15, 0xff, 0x00,  //.+++@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@.
    0x01, 0xff, 0x00,  //...+@@@@.
    0x00, 0x3f, 0x00,  //.....@@@.
    0x00, 0x0f, 0x00,  //......@@.
    0x00, 0x03, 0x00,  //.......@.
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f027 () , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x07, 0x00, 0x00,  //......+@.....
    0x00, 0x1f, 0x00, 0x00,  //.....+@@.....
    0x00, 0x7f, 0x00, 0x00,  //....+@@@.....
    0x15, 0xff, 0x00, 0x00,  //.+++@@@@.....
    0xff, 0xff, 0x1d, 0x00,  //@@@@@@@@.+@+.
    0xff, 0xff, 0x0b, 0x00,  //@@@@@@@@..%@.
    0xff, 0xff, 0x03, 0x00,  //@@@@@@@@...@.
    0xff, 0xff, 0x0b, 0x00,  //@@@@@@@@..%@.
    0xff, 0xff, 0x0d, 0x00,  //@@@@@@@@..@+.
    0x01, 0xff, 0x00, 0x00,  //...+@@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x0f, 0x00, 0x00,  //......@@.....
    0x00, 0x03, 0x00, 0x00,  //.......@.....
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+f028 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0xe0, 0x00,  //............@%....
    0x00, 0x07, 0x00, 0x7c, 0x00,  //......+@....+@@...
    0x00, 0x1f, 0x02, 0x0e, 0x00,  //.....+@@...+..@%..
    0x00, 0x7f, 0x03, 0xc3, 0x40,  //....+@@@...@@..@+.
    0x01, 0xff, 0x00, 0xb2, 0xc0,  //...+@@@@....%@.%@.
    0xff, 0xff, 0x2d, 0x39, 0xc0,  //@@@@@@@@.%@+.@%+@.
    0xff, 0xff, 0x0b, 0x1c, 0xd0,  //@@@@@@@@..%@.+@.@+
    0xff, 0xff, 0x03, 0x1c, 0xd0,  //@@@@@@@@...@.+@.@+
    0xff, 0xff, 0x0b, 0x2c, 0xd0,  //@@@@@@@@..%@.%@.@+
    0xff, 0xff, 0x1c, 0x39, 0xc0,  //@@@@@@@@.+@..@%+@.
    0x01, 0xff, 0x00, 0xb2, 0xc0,  //...+@@@@....%@.%@.
    0x00, 0x7f, 0x03, 0xc7, 0x40,  //.....@@@...@@.+@+.
    0x00, 0x1f, 0x01, 0x0e, 0x00,  //......@@...+..@%..
    0x00, 0x07, 0x00, 0x78, 0x00,  //.......@....+@%...
    0x00, 0x00, 0x00, 0xd0, 0x00,  //............@+....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f03e () , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x7f, 0xff, 0xff, 0xff, 0xfe, 0x00,  //+@@@@@@@@@@@@@@@@@@%.
    0xe5, 0x55, 0x55, 0x55, 0x57, 0x40,  //@%+++++++++++++++++@+
    0xd0, 0x00, 0x00, 0x00, 0x03, 0x40,  //@+.................@+
    0xd1, 0xf4, 0x00, 0x00, 0x03, 0x40,  //@+.+@@+............@+
    0xd3, 0xfc, 0x00, 0x00, 0x03, 0x40,  //@+.@@@@............@+
    0xd3, 0xfc, 0x00, 0xb0, 0x03, 0x40,  //@+.@@@@.....%@.....@+
    0xd1, 0xf4, 0x02, 0xfc, 0x03, 0x40,  //@+.+@@+....+@@@....@+
    0xd0, 0x00, 0x07, 0xff, 0x03, 0x40,  //@+........+@@@@@...@+
    0xd0, 0x04, 0x1f, 0xff, 0xc3, 0x40,  //@+....+..+@@@@@@@..@+
    0xd0, 0x3d, 0x7f, 0xff, 0xe3, 0x40,  //@+...@@++@@@@@@@@%.@+
    0xd0, 0xff, 0xff, 0xff, 0xe3, 0x40,  //@+..@@@@@@@@@@@@@%.@+
    0xd3, 0xff, 0xff, 0xff, 0xe3, 0x40,  //@+.@@@@@@@@@@@@@@%.@+
    0xd3, 0xff, 0xff, 0xff, 0xe3, 0x40,  //@+.@@@@@@@@@@@@@@%.@+
    0xd3, 0xff, 0xff, 0xff, 0xe3, 0x40,  //@+.@@@@@@@@@@@@@@%.@+
    0xd0, 0x00, 0x00, 0x00, 0x03, 0x40,  //@+.................@+
    0xbf, 0xff, 0xff, 0xff, 0xff, 0x00,  //%@@@@@@@@@@@@@@@@@@@.
    0x15, 0x55, 0x55, 0x55, 0x54, 0x00,  //.++++++++++++++++++..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+f040 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x01, 0x80, 0x00,  //...........+%....
    0x00, 0x00, 0x0b, 0xf0, 0x00,  //..........%@@@...
    0x00, 0x00, 0x0f, 0xfc, 0x00,  //..........@@@@@..
    0x00, 0x00, 0x87, 0xff, 0x00,  //........%.+@@@@@.
    0x00, 0x02, 0xf1, 0xff, 0x00,  //.......%@@.+@@@@.
    0x00, 0x0b, 0xbc, 0x7d, 0x00,  //......%@%@@.+@@+.
    0x00, 0x2e, 0xff, 0x54, 0x00,  //.....%@%@@@@.++..
    0x00, 0xbb, 0xff, 0xc0, 0x00,  //....%@%@@@@@@....
    0x02, 0xef, 0xff, 0x40, 0x00,  //...%@%@@@@@@+....
    0x0b, 0xbf, 0xfd, 0x00, 0x00,  //..%@%@@@@@@+.....
    0x2e, 0xff, 0xf4, 0x00, 0x00,  //.%@%@@@@@@+......
    0xbf, 0xff, 0xd0, 0x00, 0x00,  //%@@@@@@@@+.......
    0xd2, 0xff, 0x40, 0x00, 0x00,  //@+.%@@@@+........
    0xe4, 0xbd, 0x00, 0x00, 0x00,  //@%+.%@@+.........
    0xf8, 0xb4, 0x00, 0x00, 0x00,  //@@%.%@+..........
    0xff, 0xd0, 0x00, 0x00, 0x00,  //@@@@@+...........
    0x55, 0x00, 0x00, 0x00, 0x00,  //++++.............
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f048 () , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xf8, 0x00, 0x0c,  //@@%.......@
    0xfc, 0x00, 0x3c,  //@@@......@@
    0xfc, 0x00, 0xfc,  //@@@.....@@@
    0xfc, 0x03, 0xfc,  //@@@....@@@@
    0xfc, 0x0f, 0xfc,  //@@@...@@@@@
    0xfc, 0x3f, 0xfc,  //@@@..@@@@@@
    0xfc, 0xff, 0xfc,  //@@@.@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xfc, 0xff, 0xfc,  //@@@.@@@@@@@
    0xfc, 0x3f, 0xfc,  //@@@..@@@@@@
    0xfc, 0x0f, 0xfc,  //@@@...@@@@@
    0xfc, 0x03, 0xfc,  //@@@....@@@@
    0xfc, 0x00, 0xfc,  //@@@.....@@@
    0xfc, 0x00, 0x3c,  //@@@......@@
    0xfc, 0x00, 0x0c,  //@@@.......@
    0x10, 0x00, 0x00,  //.+.........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+f04b () , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xd0, 0x00, 0x00, 0x00,  //@+.............
    0xfd, 0x00, 0x00, 0x00,  //@@@+...........
    0xff, 0xc0, 0x00, 0x00,  //@@@@@..........
    0xff, 0xf8, 0x00, 0x00,  //@@@@@@%........
    0xff, 0xff, 0x80, 0x00,  //@@@@@@@@%......
    0xff, 0xff, 0xf4, 0x00,  //@@@@@@@@@@+....
    0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@%..
    0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@+...
    0xff, 0xff, 0xd0, 0x00,  //@@@@@@@@@+.....
    0xff, 0xfe, 0x00, 0x00,  //@@@@@@@%.......
    0xff, 0xe0, 0x00, 0x00,  //@@@@@%.........
    0xff, 0x00, 0x00, 0x00,  //@@@%...........
    0xf4, 0x00, 0x00, 0x00,  //@@+............
    0x40, 0x00, 0x00, 0x00,  //+..............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f04c () , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf8, 0x2f, 0xff,  //@@@@@@%..%@@@@@@
    0xff, 0xfc, 0x3f, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xfc, 0x3f, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xfc, 0x3f, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xfc, 0x3f, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xfc, 0x3f, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xfc, 0x3f, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xfc, 0x3f, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xfc, 0x3f, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xfc, 0x3f, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xfc, 0x3f, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xfc, 0x3f, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xfc, 0x3f, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xfc, 0x3f, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xfc, 0x3f, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xf8, 0x2f, 0xff,  //@@@@@@%..%@@@@@@
    0x15, 0x50, 0x05, 0x54,  //.+++++....+++++.
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+f04d () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0x15, 0x55, 0x55, 0x54, 0x00,  //.++++++++++++++..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f051 () , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x80, 0x00, 0xf8,  //%.......@@%
    0xe0, 0x00, 0xfc,  //@%......@@@
    0xf8, 0x00, 0xfc,  //@@%.....@@@
    0xfe, 0x00, 0xfc,  //@@@%....@@@
    0xff, 0x80, 0xfc,  //@@@@%...@@@
    0xff, 0xe0, 0xfc,  //@@@@@%..@@@
    0xff, 0xf8, 0xfc,  //@@@@@@%.@@@
    0xff, 0xfe, 0xfc,  //@@@@@@@%@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xff, 0xfc, 0xfc,  //@@@@@@@.@@@
    0xff, 0xf0, 0xfc,  //@@@@@@..@@@
    0xff, 0xc0, 0xfc,  //@@@@@...@@@
    0xff, 0x00, 0xfc,  //@@@@....@@@
    0xfc, 0x00, 0xfc,  //@@@.....@@@
    0xf0, 0x00, 0xfc,  //@@......@@@
    0xc0, 0x00, 0xfc,  //@.......@@@
    0x00, 0x00, 0x10,  //.........+.
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+f052 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x02, 0xc0, 0x00, 0x00,  //.......%@........
    0x00, 0x0b, 0xf0, 0x00, 0x00,  //......%@@@.......
    0x00, 0x2f, 0xfc, 0x00, 0x00,  //.....%@@@@@......
    0x00, 0xbf, 0xff, 0x00, 0x00,  //....%@@@@@@@.....
    0x02, 0xff, 0xff, 0xc0, 0x00,  //...%@@@@@@@@@....
    0x0b, 0xff, 0xff, 0xf0, 0x00,  //..%@@@@@@@@@@@...
    0x2f, 0xff, 0xff, 0xfc, 0x00,  //.%@@@@@@@@@@@@@..
    0xbf, 0xff, 0xff, 0xff, 0x00,  //%@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f053 () , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0xb0,  //........%@..
    0x00, 0x02, 0xfc,  //.......%@@@.
    0x00, 0x0b, 0xfe,  //......%@@@@%
    0x00, 0x2f, 0xfc,  //.....%@@@@@.
    0x00, 0xbf, 0xf0,  //....%@@@@@..
    0x02, 0xff, 0xc0,  //...%@@@@@...
    0x0b, 0xff, 0x00,  //..%@@@@@....
    0x2f, 0xfc, 0x00,  //.%@@@@@.....
    0x7f, 0xf0, 0x00,  //.@@@@@......
    0x2f, 0xf8, 0x00,  //.%@@@@%.....
    0x0b, 0xfe, 0x00,  //..%@@@@%....
    0x02, 0xff, 0x80,  //...%@@@@%...
    0x00, 0xbf, 0xe0,  //....%@@@@%..
    0x00, 0x2f, 0xf8,  //.....%@@@@%.
    0x00, 0x0b, 0xfd,  //......%@@@@+
    0x00, 0x02, 0xfc,  //.......%@@@.
    0x00, 0x00, 0xb0,  //........%@..
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+f054 () , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x1c, 0x00, 0x00,  //.+@........
    0x7f, 0x00, 0x00,  //+@@@.......
    0xff, 0xc0, 0x00,  //@@@@@......
    0x7f, 0xf0, 0x00,  //+@@@@@.....
    0x1f, 0xfc, 0x00,  //.+@@@@@....
    0x07, 0xff, 0x00,  //..+@@@@@...
    0x01, 0xff, 0xc0,  //...+@@@@@..
    0x00, 0x7f, 0xf0,  //....+@@@@@.
    0x00, 0x1f, 0xfc,  //.....+@@@@@
    0x00, 0x3f, 0xf4,  //.....@@@@@+
    0x00, 0xff, 0xd0,  //....@@@@@+.
    0x03, 0xff, 0x40,  //...@@@@@+..
    0x0f, 0xfd, 0x00,  //..@@@@@+...
    0x3f, 0xf4, 0x00,  //.@@@@@+....
    0xff, 0xd0, 0x00,  //@@@@@+.....
    0x7f, 0x40, 0x00,  //+@@@+......
    0x1d, 0x00, 0x00,  //.+@+.......
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+f067 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x1f, 0xc0, 0x00,  //.....+@@@......
    0x00, 0x2f, 0xd0, 0x00,  //.....%@@@+.....
    0x00, 0x2f, 0xd0, 0x00,  //.....%@@@+.....
    0x00, 0x2f, 0xd0, 0x00,  //.....%@@@+.....
    0x00, 0x2f, 0xd0, 0x00,  //.....%@@@+.....
    0x55, 0x7f, 0xe5, 0x50,  //+++++@@@@%++++.
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0x6a, 0xbf, 0xfa, 0xa4,  //+%%%%@@@@@%%%%+
    0x00, 0x2f, 0xd0, 0x00,  //.....%@@@+.....
    0x00, 0x2f, 0xd0, 0x00,  //.....%@@@+.....
    0x00, 0x2f, 0xd0, 0x00,  //.....%@@@+.....
    0x00, 0x2f, 0xd0, 0x00,  //.....%@@@+.....
    0x00, 0x1f, 0xd0, 0x00,  //.....+@@@+.....
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f068 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf8,  //%@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f071 () , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0xb8, 0x00, 0x00,  //........%@%........
    0x00, 0x01, 0xfd, 0x00, 0x00,  //.......+@@@+.......
    0x00, 0x03, 0xff, 0x00, 0x00,  //.......@@@@@.......
    0x00, 0x07, 0xff, 0x40, 0x00,  //......+@@@@@+......
    0x00, 0x0f, 0xff, 0xc0, 0x00,  //......@@@@@@@......
    0x00, 0x2f, 0x03, 0xe0, 0x00,  //.....%@@...@@%.....
    0x00, 0x3f, 0x03, 0xf0, 0x00,  //.....@@@...@@@.....
    0x00, 0xbf, 0x03, 0xf8, 0x00,  //....%@@@...@@@%....
    0x00, 0xff, 0x03, 0xfc, 0x00,  //....@@@@...@@@@....
    0x02, 0xff, 0x03, 0xfe, 0x00,  //...%@@@@...@@@@%...
    0x07, 0xff, 0x57, 0xff, 0x40,  //..+@@@@@+++@@@@@+..
    0x0f, 0xff, 0xff, 0xff, 0xc0,  //..@@@@@@@@@@@@@@@..
    0x1f, 0xff, 0x03, 0xff, 0xd0,  //.+@@@@@@...@@@@@@+.
    0x3f, 0xff, 0x03, 0xff, 0xf0,  //.@@@@@@@...@@@@@@@.
    0xbf, 0xff, 0xff, 0xff, 0xf8,  //%@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0xbf, 0xff, 0xff, 0xff, 0xf8,  //%@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f074 () , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x03, 0x00,  //...............@...
    0x00, 0x00, 0x00, 0x03, 0xc0,  //...............@@..
    0xfe, 0x40, 0x0a, 0xff, 0xf0,  //@@@%+.....+%@@@@@@.
    0xff, 0xf0, 0x3f, 0xff, 0xfc,  //@@@@@@...@@@@@@@@@@
    0xff, 0xfc, 0xff, 0xff, 0xf4,  //@@@@@@@.@@@@@@@@@@+
    0x00, 0xfa, 0xf8, 0x03, 0xd0,  //....@@%%@@%....@@+.
    0x00, 0x37, 0xf0, 0x03, 0x40,  //.....@+@@@.....@+..
    0x00, 0x0b, 0xd0, 0x00, 0x00,  //......%@@+.........
    0x00, 0x0f, 0xc0, 0x00, 0x00,  //......@@@..........
    0x00, 0x1f, 0x80, 0x00, 0x00,  //.....+@@%..........
    0x00, 0x3f, 0x70, 0x03, 0x40,  //.....@@@+@.....@+..
    0x00, 0xfe, 0xb8, 0x03, 0xd0,  //....@@@%%@%....@@+.
    0xff, 0xfc, 0xff, 0xff, 0xf4,  //@@@@@@@.@@@@@@@@@@+
    0xff, 0xf0, 0x3f, 0xff, 0xfc,  //@@@@@@...@@@@@@@@@@
    0xfe, 0x40, 0x0a, 0xff, 0xf0,  //@@@%+.....%%@@@@@@.
    0x00, 0x00, 0x00, 0x03, 0xc0,  //...............@@..
    0x00, 0x00, 0x00, 0x03, 0x00,  //...............@...
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f077 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x01, 0xd0, 0x00, 0x00,  //.......+@+.......
    0x00, 0x07, 0xf4, 0x00, 0x00,  //......+@@@+......
    0x00, 0x1f, 0xfd, 0x00, 0x00,  //.....+@@@@@+.....
    0x00, 0x7f, 0xff, 0x40, 0x00,  //....+@@@@@@@+....
    0x01, 0xff, 0xff, 0xd0, 0x00,  //...+@@@@@@@@@+...
    0x07, 0xff, 0x3f, 0xf4, 0x00,  //..+@@@@@.@@@@@+..
    0x1f, 0xfc, 0x0f, 0xfd, 0x00,  //.+@@@@@...@@@@@+.
    0x7f, 0xf0, 0x03, 0xff, 0x40,  //+@@@@@.....@@@@@+
    0xff, 0xc0, 0x00, 0xff, 0xc0,  //@@@@@.......@@@@@
    0x3f, 0x00, 0x00, 0x3f, 0x00,  //.@@@.........@@@.
    0x08, 0x00, 0x00, 0x08, 0x00,  //..%...........%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f078 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x08, 0x00, 0x00, 0x08, 0x00,  //..%...........%..
    0x3f, 0x00, 0x00, 0x3f, 0x00,  //.@@%.........@@@.
    0xff, 0xc0, 0x00, 0xff, 0xc0,  //@@@@%.......%@@@@
    0xbf, 0xf0, 0x03, 0xff, 0x80,  //%@@@@%.....%@@@@%
    0x2f, 0xfc, 0x0f, 0xfe, 0x00,  //.%@@@@%...%@@@@%.
    0x0b, 0xfe, 0x3f, 0xf8, 0x00,  //..%@@@@%.%@@@@%..
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x00, 0xbf, 0xff, 0x80, 0x00,  //....%@@@@@@@%....
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x0b, 0xf8, 0x00, 0x00,  //......%@@@%......
    0x00, 0x02, 0xe0, 0x00, 0x00,  //.......%@%.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f079 () , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x01, 0xc2, 0xff, 0xff, 0xf0, 0x00,  //...+@..%@@@@@@@@@@...
    0x03, 0xf0, 0xff, 0xff, 0xf0, 0x00,  //...@@@..@@@@@@@@@@...
    0x0f, 0xfc, 0x3f, 0xff, 0xf0, 0x00,  //..@@@@@..@@@@@@@@@...
    0x3f, 0xfe, 0x00, 0x03, 0xf0, 0x00,  //.@@@@@@%.......@@@...
    0xbf, 0xff, 0x40, 0x03, 0xf0, 0x00,  //%@@@@@@@+......@@@...
    0x6b, 0xfa, 0x00, 0x03, 0xf0, 0x00,  //+%%@@@%%.......@@@...
    0x03, 0xf0, 0x00, 0x2b, 0xfa, 0x40,  //...@@@.......%%@@@%%.
    0x03, 0xf0, 0x00, 0x7f, 0xff, 0x80,  //...@@@......+@@@@@@@%
    0x03, 0xf0, 0x00, 0x2f, 0xff, 0x00,  //...@@@.......%@@@@@@.
    0x03, 0xff, 0xff, 0x4f, 0xfc, 0x00,  //...@@@@@@@@@..@@@@@..
    0x03, 0xff, 0xff, 0xc3, 0xf0, 0x00,  //...@@@@@@@@@@..@@@...
    0x03, 0xff, 0xff, 0xe0, 0xd0, 0x00,  //...@@@@@@@@@@%..@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+f07b () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x2f, 0xf8, 0x00, 0x00, 0x00,  //.%@@@@%...........
    0xbf, 0xff, 0x00, 0x00, 0x00,  //%@@@@@@@..........
    0xff, 0xff, 0x40, 0x00, 0x00,  //@@@@@@@@+.........
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@+
    0x3f, 0xff, 0xff, 0xff, 0x80,  //.@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f093 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x40, 0x00, 0x00,  //........+.........
    0x00, 0x01, 0xf0, 0x00, 0x00,  //.......+@@........
    0x00, 0x07, 0xfc, 0x00, 0x00,  //......+@@@@.......
    0x00, 0x1f, 0xff, 0x00, 0x00,  //.....+@@@@@@......
    0x00, 0x7f, 0xff, 0xc0, 0x00,  //....+@@@@@@@@.....
    0x01, 0xff, 0xff, 0xf0, 0x00,  //...+@@@@@@@@@@....
    0x00, 0xab, 0xfe, 0xa0, 0x00,  //....%%%@@@@%%%....
    0x00, 0x03, 0xfc, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x03, 0xfc, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x03, 0xfc, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x03, 0xfc, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x03, 0xf8, 0x00, 0x00,  //.......@@@%.......
    0xff, 0xf0, 0x01, 0xff, 0xc0,  //@@@@@@.....+@@@@@.
    0xff, 0xfe, 0xaf, 0xff, 0xd0,  //@@@@@@@%%%@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0x6c, 0xd0,  //@@@@@@@@@@@@+%@.@+
    0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@+
    0x15, 0x55, 0x55, 0x55, 0x40,  //.++++++++++++++++.
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f095 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x1e, 0x00, 0x00, 0x00,  //.+@%...........
    0x7f, 0x00, 0x00, 0x00,  //+@@@...........
    0xff, 0xc0, 0x00, 0x00,  //@@@@@..........
    0xff, 0xd0, 0x00, 0x00,  //@@@@@+.........
    0xff, 0x80, 0x00, 0x00,  //@@@@%..........
    0xbe, 0x00, 0x00, 0x00,  //%@@%...........
    0x3f, 0x00, 0x00, 0x00,  //.@@%...........
    0x3f, 0x40, 0x00, 0x00,  //.@@@+..........
    0x0f, 0xc0, 0x00, 0x00,  //..@@@..........
    0x0b, 0xf0, 0x01, 0x00,  //..+@@@.....+...
    0x02, 0xfd, 0x0b, 0xc0,  //...%@@@+..%@@..
    0x00, 0xbf, 0xef, 0xf8,  //....%@@@%%@@@@%
    0x00, 0x2f, 0xff, 0xfc,  //.....+@@@@@@@@@
    0x00, 0x03, 0xff, 0xf4,  //.......@@@@@@@+
    0x00, 0x00, 0x2f, 0xd0,  //.........%@@@+.
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f0c4 () , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x1b, 0x80, 0x00, 0x00, 0x00,  //.+%@%..............
    0xbf, 0xf8, 0x00, 0x00, 0x00,  //%@@@@@%............
    0xf0, 0x7e, 0x00, 0x02, 0xa8,  //@@..+@@%.......%%%%
    0xf0, 0x0f, 0x00, 0x28, 0x18,  //@@....@@.....%%..+%
    0xb8, 0x0b, 0x01, 0x80, 0x90,  //%@%...%@...+%...%+.
    0x2f, 0xff, 0x99, 0x02, 0x00,  //.%@@@@@@%+%+...%...
    0x02, 0xfa, 0x90, 0x18, 0x00,  //...%@@%%%+...+%....
    0x00, 0x01, 0xdc, 0xa0, 0x00,  //.......+@+@.%%.....
    0x02, 0xfa, 0x16, 0x18, 0x00,  //...%@@%%.++%.+%....
    0x2f, 0xfe, 0xad, 0x02, 0x00,  //.%@@@@@%%%@+...%...
    0x7d, 0x0f, 0x02, 0x80, 0x90,  //+@@+..@@...%%...%+.
    0xf0, 0x0b, 0x00, 0x28, 0x28,  //@@....%@.....%%..%%
    0xf0, 0x2e, 0x00, 0x06, 0x5c,  //@@...%@%......+%++%
    0xbf, 0xfc, 0x00, 0x00, 0x50,  //%@@@@@@.........++.
    0x2f, 0xd0, 0x00, 0x00, 0x00,  //.%@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f0c5 () , Width: 19 */
    0x00, 0x01, 0x54, 0x00, 0x00,  //.......++++........
    0x00, 0x3f, 0xff, 0x00, 0x00,  //.....@@@@@@@.......
    0x00, 0xfc, 0x03, 0x00, 0x00,  //....@@@....@.......
    0x03, 0xec, 0x03, 0x00, 0x00,  //...@@+@....@.......
    0x0f, 0x1c, 0x03, 0x55, 0x50,  //..@@.+@....@++++++.
    0x3c, 0x1c, 0x03, 0xff, 0xfc,  //.@@..+@....@@@@@@@@
    0xff, 0xfc, 0x07, 0xe0, 0x1c,  //%@@@@@@...+@@%...+@
    0xe5, 0x50, 0x1e, 0xe0, 0x1c,  //@%++++...+@%@%...+@
    0xd0, 0x00, 0x78, 0xe0, 0x1c,  //@+.......@%.@%...+@
    0xd0, 0x00, 0xe0, 0xe0, 0x1c,  //@+......@%..@%...+@
    0xd0, 0x03, 0xff, 0xe0, 0x1c,  //@+.....@@@@@@%...+@
    0xd0, 0x03, 0x95, 0x40, 0x1c,  //@+.....@%++++....+@
    0xd0, 0x03, 0x40, 0x00, 0x1c,  //@+.....@+........+@
    0xd0, 0x03, 0x40, 0x00, 0x1c,  //@+.....@+........+@
    0xff, 0xff, 0x40, 0x00, 0x1c,  //@@@@@@@@+........+@
    0x15, 0x57, 0x40, 0x00, 0x1c,  //.++++++@+........+@
    0x00, 0x03, 0x40, 0x00, 0x1c,  //.......@+........+@
    0x00, 0x03, 0x40, 0x00, 0x1c,  //.......@+........+@
    0x00, 0x03, 0x95, 0x55, 0x6c,  //.......@%++++++++%@
    0x00, 0x02, 0xff, 0xff, 0xfc,  //.......%@@@@@@@@@@%


    /*Unicode: U+f0c7 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0x40, 0x00,  //%@@@@@@@@@@@+....
    0xe7, 0xfd, 0x6e, 0xd0, 0x00,  //@%+@@@@++%@%@+...
    0xd3, 0xfc, 0x1c, 0x74, 0x00,  //@+.@@@@..+@.+@+..
    0xd3, 0xfc, 0x1c, 0x1d, 0x00,  //@+.@@@@..+@..+@+.
    0xd3, 0xfc, 0x1c, 0x0b, 0x00,  //@+.@@@@..+@...%@.
    0xd3, 0xfd, 0x6c, 0x03, 0x40,  //@+.@@@@++%@....@.
    0xd3, 0xff, 0xf8, 0x03, 0x40,  //@+.@@@@@@@%....@+
    0xd0, 0x00, 0x00, 0x03, 0x40,  //@+.............@+
    0xd0, 0x00, 0x00, 0x03, 0x40,  //@+.............@+
    0xd0, 0x55, 0x55, 0x43, 0x40,  //@+..+++++++++..@+
    0xd3, 0xff, 0xff, 0xd3, 0x40,  //@+.@@@@@@@@@@+.@+
    0xd3, 0x40, 0x00, 0xd3, 0x40,  //@+.@+.......@+.@+
    0xd3, 0x40, 0x00, 0xd3, 0x40,  //@+.@+.......@+.@+
    0xd3, 0x40, 0x00, 0xd3, 0x40,  //@+.@+.......@+.@+
    0xd3, 0x40, 0x00, 0xd3, 0x40,  //@+.@+.......@+.@+
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0x15, 0x55, 0x55, 0x55, 0x00,  //.+++++++++++++++.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f0e7 () , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x0f, 0xf4, 0x00,  //..@@@@+...
    0x0f, 0xf0, 0x00,  //..@@@@....
    0x1f, 0xf0, 0x00,  //.+@@@@....
    0x2f, 0xd0, 0x00,  //.%@@@+....
    0x3f, 0xc0, 0x40,  //.@@@@...+.
    0x3f, 0xef, 0xd0,  //.@@@@%@@@+
    0x7f, 0xff, 0xc0,  //+@@@@@@@@.
    0xbf, 0xff, 0x40,  //%@@@@@@@+.
    0xff, 0xbf, 0x00,  //@@@@%@@@..
    0x90, 0x7d, 0x00,  //%+..+@@+..
    0x00, 0xbc, 0x00,  //....%@@...
    0x00, 0xf4, 0x00,  //....@@+...
    0x00, 0xf0, 0x00,  //....@@....
    0x01, 0xe0, 0x00,  //...+@%....
    0x02, 0xc0, 0x00,  //...%@.....
    0x03, 0x80, 0x00,  //...@%.....
    0x03, 0x00, 0x00,  //...@......
    0x01, 0x00, 0x00,  //...+......


    /*Unicode: U+f0f3 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0xe0, 0x00, 0x00,  //........@%........
    0x00, 0x06, 0xf8, 0x00, 0x00,  //......+%@@%.......
    0x00, 0x2f, 0xff, 0x40, 0x00,  //.....%@@@@@@+.....
    0x00, 0xff, 0xff, 0xd0, 0x00,  //....%@@@@@@@@+....
    0x01, 0xff, 0xff, 0xf0, 0x00,  //...+@@@@@@@@@@....
    0x02, 0xff, 0xff, 0xf0, 0x00,  //...%@@@@@@@@@@....
    0x02, 0xff, 0xff, 0xf4, 0x00,  //...%@@@@@@@@@@+...
    0x02, 0xff, 0xff, 0xf4, 0x00,  //...%@@@@@@@@@@+...
    0x03, 0xff, 0xff, 0xf4, 0x00,  //...@@@@@@@@@@@+...
    0x03, 0xff, 0xff, 0xf8, 0x00,  //...@@@@@@@@@@@%...
    0x03, 0xff, 0xff, 0xfc, 0x00,  //...@@@@@@@@@@@@...
    0x0b, 0xff, 0xff, 0xfd, 0x00,  //..%@@@@@@@@@@@@+..
    0x0f, 0xff, 0xff, 0xff, 0x00,  //..@@@@@@@@@@@@@%..
    0x2f, 0xff, 0xff, 0xff, 0x40,  //.%@@@@@@@@@@@@@@+.
    0xbf, 0xff, 0xff, 0xff, 0xd0,  //%@@@@@@@@@@@@@@@@+
    0xbf, 0xff, 0xff, 0xff, 0xd0,  //%@@@@@@@@@@@@@@@@+
    0x00, 0x0e, 0xfe, 0x00, 0x00,  //......@%@@@%......
    0x00, 0x06, 0xbc, 0x00, 0x00,  //......+%%@@.......
    0x00, 0x01, 0xe0, 0x00, 0x00,  //.......+@%........


    /*Unicode: U+f11c () , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@@.
    0xd0, 0x00, 0x00, 0x00, 0x03, 0x40,  //@+.................@+
    0xd1, 0x04, 0x41, 0x04, 0x43, 0x40,  //@+.+..+.+..+..+.+..@+
    0xd3, 0x4c, 0xd3, 0x1c, 0xd3, 0x40,  //@+.@+.@.@+.@.+@.@+.@+
    0xd0, 0x00, 0x00, 0x00, 0xd3, 0x40,  //@+..............@+.@+
    0xd3, 0xf3, 0x2c, 0xe7, 0xd3, 0x40,  //@+.@@@.@.%@.@%+@@+.@+
    0xd1, 0x51, 0x04, 0x41, 0x43, 0x40,  //@+.+++.+..+.+..++..@+
    0xd0, 0x00, 0x00, 0x00, 0x03, 0x40,  //@+.................@+
    0xd3, 0x4f, 0xff, 0xfc, 0xd3, 0x40,  //@+.@+.@@@@@@@@@.@+.@+
    0xd1, 0x05, 0x55, 0x54, 0x43, 0x40,  //@+.+..+++++++++.+..@+
    0xe5, 0x55, 0x55, 0x55, 0x57, 0x40,  //@%+++++++++++++++++@+
    0xbf, 0xff, 0xff, 0xff, 0xff, 0x00,  //%@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+f124 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x14,  //.............++
    0x00, 0x00, 0x01, 0xfc,  //...........+@@@
    0x00, 0x00, 0x1f, 0xf4,  //.........+@@@@+
    0x00, 0x01, 0xff, 0xf0,  //.......+@@@@@@.
    0x00, 0x1f, 0xff, 0xd0,  //.....+@@@@@@@+.
    0x01, 0xff, 0xff, 0xc0,  //...+@@@@@@@@@..
    0x1f, 0xff, 0xff, 0x40,  //.+@@@@@@@@@@+..
    0xbf, 0xff, 0xff, 0x00,  //%@@@@@@@@@@@...
    0x6a, 0xab, 0xfd, 0x00,  //+%%%%%%@@@@+...
    0x00, 0x03, 0xfc, 0x00,  //.......@@@@....
    0x00, 0x03, 0xf4, 0x00,  //.......@@@+....
    0x00, 0x03, 0xf0, 0x00,  //.......@@@.....
    0x00, 0x03, 0xd0, 0x00,  //.......@@+.....
    0x00, 0x03, 0xc0, 0x00,  //.......@@......
    0x00, 0x03, 0x40, 0x00,  //.......@+......
    0x00, 0x01, 0x00, 0x00,  //.......+.......
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f15b () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xd0, 0x00, 0x00,  //%@@@@@@@@+.......
    0xff, 0xff, 0xd3, 0x00, 0x00,  //@@@@@@@@@+.@.....
    0xff, 0xff, 0xd3, 0xc0, 0x00,  //@@@@@@@@@+.@@....
    0xff, 0xff, 0xd3, 0xf0, 0x00,  //@@@@@@@@@+.@@@...
    0xff, 0xff, 0xd3, 0xfc, 0x00,  //@@@@@@@@@+.@@@@..
    0xff, 0xff, 0xe1, 0x55, 0x00,  //@@@@@@@@@+.+++++.
    0xff, 0xff, 0xf0, 0x00, 0x00,  //@@@@@@@@@@.......
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.


    /*Unicode: U+f1eb () , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x06, 0xff, 0xe4, 0x00, 0x00,  //......+%@@@@@%+......
    0x00, 0xbf, 0xff, 0xff, 0x80, 0x00,  //....%@@@@@@@@@@@%....
    0x0b, 0xff, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@@@@@%..
    0x2f, 0xf9, 0x00, 0x0b, 0xff, 0x00,  //.%@@@@%+......%@@@@@.
    0xbf, 0x81, 0xaf, 0x90, 0x7f, 0xc0,  //%@@@%..+%%@%%+..+@@@@
    0x3d, 0x2f, 0xff, 0xfe, 0x0f, 0x00,  //.@@..%@@@@@@@@@%..@@.
    0x00, 0xff, 0xff, 0xff, 0xd0, 0x00,  //....@@@@@@@@@@@@@+...
    0x03, 0xfe, 0x40, 0x2f, 0xf0, 0x00,  //...%@@@%+....%@@@@...
    0x00, 0xe0, 0x6e, 0x82, 0xc0, 0x00,  //....@%..+%@%%..%@....
    0x00, 0x07, 0xff, 0xf8, 0x00, 0x00,  //......+@@@@@@@%......
    0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00,  //......@@@@@@@@@......
    0x00, 0x03, 0x80, 0xb0, 0x00, 0x00,  //.......@%...%@.......
    0x00, 0x00, 0x19, 0x00, 0x00, 0x00,  //.........+%+.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x0d, 0x00, 0x00, 0x00,  //..........@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+f240 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x15, 0x55, 0x55, 0x55, 0x55, 0x50, 0x00,  //.+++++++++++++++++++++...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,  //@+...................+@..
    0xd3, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00,  //@+.@@@@@@@@@@@@@@@@@%+@..
    0xd3, 0xff, 0xff, 0xff, 0xff, 0x9f, 0x00,  //@+.@@@@@@@@@@@@@@@@@%+@@.
    0xd3, 0xff, 0xff, 0xff, 0xff, 0x87, 0x40,  //@+.@@@@@@@@@@@@@@@@@%.+@+
    0xd3, 0xff, 0xff, 0xff, 0xff, 0x83, 0x40,  //@+.@@@@@@@@@@@@@@@@@%..@+
    0xd3, 0xff, 0xff, 0xff, 0xff, 0x83, 0x40,  //@+.@@@@@@@@@@@@@@@@@%..@+
    0xd3, 0xff, 0xff, 0xff, 0xff, 0x83, 0x40,  //@+.@@@@@@@@@@@@@@@@@%..@+
    0xd3, 0xff, 0xff, 0xff, 0xff, 0x8b, 0x40,  //@+.@@@@@@@@@@@@@@@@@%.%@+
    0xd3, 0xff, 0xff, 0xff, 0xff, 0x9d, 0x00,  //@+.@@@@@@@@@@@@@@@@@%+@+.
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,  //@+...................+@..
    0xe5, 0x55, 0x55, 0x55, 0x55, 0x6c, 0x00,  //@%+++++++++++++++++++%@..
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f241 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x15, 0x55, 0x55, 0x55, 0x55, 0x50, 0x00,  //.+++++++++++++++++++++...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,  //@+...................+@..
    0xd3, 0xff, 0xff, 0xff, 0x80, 0x1c, 0x00,  //@+.@@@@@@@@@@@@@%....+@..
    0xd3, 0xff, 0xff, 0xff, 0x80, 0x1f, 0x00,  //@+.@@@@@@@@@@@@@%....+@@.
    0xd3, 0xff, 0xff, 0xff, 0x80, 0x07, 0x40,  //@+.@@@@@@@@@@@@@%.....+@+
    0xd3, 0xff, 0xff, 0xff, 0x80, 0x03, 0x40,  //@+.@@@@@@@@@@@@@%......@+
    0xd3, 0xff, 0xff, 0xff, 0x80, 0x03, 0x40,  //@+.@@@@@@@@@@@@@%......@+
    0xd3, 0xff, 0xff, 0xff, 0x80, 0x03, 0x40,  //@+.@@@@@@@@@@@@@%......@+
    0xd3, 0xff, 0xff, 0xff, 0x80, 0x0b, 0x40,  //@+.@@@@@@@@@@@@@%.....%@+
    0xd3, 0xff, 0xff, 0xff, 0x80, 0x1d, 0x00,  //@+.@@@@@@@@@@@@@%....+@+.
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,  //@+...................+@..
    0xe5, 0x55, 0x55, 0x55, 0x55, 0x6c, 0x00,  //@%+++++++++++++++++++%@..
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f242 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x15, 0x55, 0x55, 0x55, 0x55, 0x50, 0x00,  //.+++++++++++++++++++++...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,  //@+...................+@..
    0xd7, 0xff, 0xff, 0x00, 0x00, 0x1c, 0x00,  //@++@@@@@@@@@.........+@..
    0xd7, 0xff, 0xff, 0x00, 0x00, 0x1f, 0x00,  //@++@@@@@@@@@.........+@@.
    0xd7, 0xff, 0xff, 0x00, 0x00, 0x07, 0x40,  //@++@@@@@@@@@..........+@+
    0xd7, 0xff, 0xff, 0x00, 0x00, 0x03, 0x40,  //@++@@@@@@@@@...........@+
    0xd7, 0xff, 0xff, 0x00, 0x00, 0x03, 0x40,  //@++@@@@@@@@@...........@+
    0xd7, 0xff, 0xff, 0x00, 0x00, 0x03, 0x40,  //@++@@@@@@@@@...........@+
    0xd7, 0xff, 0xff, 0x00, 0x00, 0x0b, 0x40,  //@++@@@@@@@@@..........%@+
    0xd7, 0xff, 0xff, 0x00, 0x00, 0x1d, 0x00,  //@++@@@@@@@@@.........+@+.
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,  //@+...................+@..
    0xe5, 0x55, 0x55, 0x55, 0x55, 0x6c, 0x00,  //@%+++++++++++++++++++%@..
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f243 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x15, 0x55, 0x55, 0x55, 0x55, 0x50, 0x00,  //.+++++++++++++++++++++...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,  //@+...................+@..
    0xd7, 0xff, 0x00, 0x00, 0x00, 0x1c, 0x00,  //@++@@@@@.............+@..
    0xd7, 0xff, 0x00, 0x00, 0x00, 0x1f, 0x00,  //@++@@@@@.............+@@.
    0xd7, 0xff, 0x00, 0x00, 0x00, 0x07, 0x40,  //@++@@@@@..............+@+
    0xd7, 0xff, 0x00, 0x00, 0x00, 0x03, 0x40,  //@++@@@@@...............@+
    0xd7, 0xff, 0x00, 0x00, 0x00, 0x03, 0x40,  //@++@@@@@...............@+
    0xd7, 0xff, 0x00, 0x00, 0x00, 0x03, 0x40,  //@++@@@@@...............@+
    0xd7, 0xff, 0x00, 0x00, 0x00, 0x0b, 0x40,  //@++@@@@@..............%@+
    0xd7, 0xff, 0x00, 0x00, 0x00, 0x1d, 0x00,  //@++@@@@@.............+@+.
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,  //@+...................+@..
    0xe5, 0x55, 0x55, 0x55, 0x55, 0x6c, 0x00,  //@%+++++++++++++++++++%@..
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f244 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x15, 0x55, 0x55, 0x55, 0x55, 0x50, 0x00,  //.+++++++++++++++++++++...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,  //@+...................+@..
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,  //@+...................+@..
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00,  //@+...................+@@.
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x40,  //@+....................+@+
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x40,  //@+.....................@+
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x40,  //@+.....................@+
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x40,  //@+.....................@+
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x40,  //@+....................%@+
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00,  //@+...................+@%.
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,  //@+...................+@..
    0xe5, 0x55, 0x55, 0x55, 0x55, 0x6c, 0x00,  //@%+++++++++++++++++++%@..
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f293 () , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x01, 0xbf, 0xe4, 0x00,  //...+%@@@@%+...
    0x0b, 0xff, 0xfe, 0x00,  //..%@@@@@@@@%..
    0x1f, 0xf5, 0xff, 0x40,  //.+@@@@++@@@@+.
    0x3f, 0xf4, 0x7f, 0xc0,  //.@@@@@+.+@@@@.
    0x7f, 0xf4, 0x1f, 0xd0,  //+@@@@@+..+@@@+
    0xbd, 0xf4, 0x87, 0xe0,  //%@@+@@+.%.+@@%
    0xfc, 0x34, 0xc3, 0xf0,  //@@@..@+.@..@@@
    0xff, 0x00, 0x0f, 0xf0,  //@@@@......@@@@
    0xff, 0xc0, 0x3f, 0xf0,  //@@@@@....@@@@@
    0xff, 0xf0, 0xbf, 0xf0,  //@@@@@@..%@@@@@
    0xff, 0xc0, 0x3f, 0xf0,  //@@@@@....@@@@@
    0xff, 0x00, 0x0f, 0xf0,  //@@@@......@@@@
    0xfc, 0x34, 0xc3, 0xf0,  //@@@..@+.@..@@@
    0xbd, 0xf4, 0x87, 0xe0,  //%@@+@@+.%.+@@%
    0x7f, 0xf4, 0x1f, 0xd0,  //+@@@@@+..+@@@+
    0x3f, 0xf4, 0x7f, 0xc0,  //.@@@@@+.+@@@@.
    0x1f, 0xf5, 0xff, 0x40,  //.+@@@@++@@@@+.
    0x0b, 0xff, 0xfe, 0x00,  //..%@@@@@@@@%..
    0x00, 0xbf, 0xe0, 0x00,  //....%@@@@%....



#elif USE_LV_FONT_SYMBOL_20 == 4
    /*Unicode: U+f001 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x69, 0x00,  //..............+%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0xcf, 0xff, 0x50,  //...........+@@@@+
    0x00, 0x00, 0x00, 0x03, 0x8d, 0xff, 0xff, 0xff, 0x50,  //........%@@@@@@@+
    0x00, 0x00, 0x02, 0xef, 0xff, 0xff, 0xff, 0xff, 0x50,  //......@@@@@@@@@@+
    0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,  //.....+@@@@@@@@@@+
    0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,  //.....+@@@@@@@@@@+
    0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xb6, 0x1f, 0x50,  //.....+@@@@@@%+.@+
    0x00, 0x00, 0x05, 0xff, 0xfa, 0x50, 0x00, 0x0f, 0x50,  //.....+@@@%+....@+
    0x00, 0x00, 0x05, 0xf4, 0x00, 0x00, 0x00, 0x0f, 0x50,  //.....+@+.......@+
    0x00, 0x00, 0x05, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0x50,  //.....+@........@+
    0x00, 0x00, 0x05, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0x50,  //.....+@........@+
    0x00, 0x00, 0x05, 0xf0, 0x00, 0x28, 0xbb, 0x8f, 0x50,  //.....+@....%%%%@+
    0x00, 0x00, 0x05, 0xf0, 0x02, 0xff, 0xff, 0xff, 0x50,  //.....+@...@@@@@@+
    0x00, 0x00, 0x05, 0xf0, 0x05, 0xff, 0xff, 0xff, 0x40,  //.....+@..+@@@@@@+
    0x09, 0xef, 0xfd, 0xf0, 0x00, 0x9f, 0xff, 0xf8, 0x00,  //.%@@@@@...%@@@@%.
    0xaf, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x33, 0x00, 0x00,  //%@@@@@@..........
    0x9f, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@..........
    0x08, 0xdf, 0xe9, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@%...........


    /*Unicode: U+f008 () , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00,  //+@@@@@@@@@@@@@@@@@@%.
    0xfb, 0x57, 0xfb, 0x55, 0x55, 0x55, 0x55, 0x8f, 0xa5, 0x7f, 0x40,  //@%++@%++++++++%@%++@+
    0xf5, 0x00, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x40, 0x0f, 0x50,  //@+..@+.........@+..@+
    0xf7, 0x02, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x60, 0x2f, 0x50,  //@+..@+.........@+..@+
    0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0x50,  //@@@@@+.........@@@@@+
    0xfb, 0x57, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xa5, 0x7f, 0x50,  //@%++@+.........@%++@+
    0xf5, 0x00, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x40, 0x0f, 0x50,  //@+..@+.........@+..@+
    0xf7, 0x02, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x60, 0x2f, 0x50,  //@+..@+.........@+..@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,  //@@@@@@@@@@@@@@@@@@@@+
    0xfb, 0x57, 0xfb, 0x55, 0x55, 0x55, 0x55, 0x8f, 0xa5, 0x7f, 0x50,  //@%++@%++++++++%@%++@+
    0xf5, 0x00, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x40, 0x0f, 0x50,  //@+..@+.........@+..@+
    0xf7, 0x02, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x60, 0x2f, 0x50,  //@+..@+.........@+..@+
    0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0x50,  //@@@@@+.........@@@@@+
    0xfb, 0x57, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xa5, 0x8f, 0x50,  //@%++@+.........@%++@+
    0xf5, 0x00, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x40, 0x0f, 0x50,  //@+..@+.........@+..@+
    0xf5, 0x00, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x40, 0x0f, 0x50,  //@+..@+.........@+..@+
    0xfb, 0x58, 0xfb, 0x55, 0x55, 0x55, 0x55, 0x8f, 0xb5, 0x8f, 0x40,  //@%+%@%++++++++%@%+%@+
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00,  //+@@@@@@@@@@@@@@@@@@%.


    /*Unicode: U+f00b () , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xcf, 0xff, 0xf3, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //%@@@@..@@@@@@@@@@@%
    0xff, 0xff, 0xf6, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@+.@@@@@@@@@@@@
    0xff, 0xff, 0xf6, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@+.@@@@@@@@@@@@
    0xcf, 0xff, 0xf3, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@..@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x01, 0x11, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00,  //...................
    0xdf, 0xff, 0xf4, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@..@@@@@@@@@@@@
    0xff, 0xff, 0xf6, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@+.@@@@@@@@@@@@
    0xff, 0xff, 0xf6, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@+.@@@@@@@@@@@@
    0xcf, 0xff, 0xf3, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //%@@@@..@@@@@@@@@@@%
    0x01, 0x11, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00,  //...................
    0xdf, 0xff, 0xf4, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@..@@@@@@@@@@@@
    0xff, 0xff, 0xf6, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@+.@@@@@@@@@@@@
    0xff, 0xff, 0xf6, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@+.@@@@@@@@@@@@
    0xcf, 0xff, 0xf3, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@..@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f00c () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xa1, 0x00,  //.............+%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfd, 0x10,  //............+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xa0,  //...........+@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x50,  //..........+@@@@@+
    0x02, 0xd8, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf5, 0x00,  //..@%.....+@@@@@+.
    0x2e, 0xff, 0x90, 0x00, 0x6f, 0xff, 0xff, 0x50, 0x00,  //.@@@%...+@@@@@+..
    0xaf, 0xff, 0xf8, 0x06, 0xff, 0xff, 0xf5, 0x00, 0x00,  //%@@@@%.+@@@@@+...
    0x3f, 0xff, 0xff, 0xbf, 0xff, 0xff, 0x50, 0x00, 0x00,  //.@@@@@%@@@@@+....
    0x03, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00,  //..@@@@@@@@@+.....
    0x00, 0x3f, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00,  //...@@@@@@@+......
    0x00, 0x03, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00,  //....@@@@@+.......
    0x00, 0x00, 0x3f, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00,  //.....@@@+........
    0x00, 0x00, 0x03, 0xc5, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f00d () , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x02, 0x81, 0x00, 0x00, 0x05, 0x70, 0x00,  //..%......++..
    0x2e, 0xfd, 0x10, 0x00, 0x6f, 0xfa, 0x00,  //.@@@....+@@%.
    0xdf, 0xff, 0xd1, 0x06, 0xff, 0xff, 0x70,  //@@@@@..+@@@@+
    0xbf, 0xff, 0xfd, 0x7f, 0xff, 0xff, 0x50,  //%@@@@@+@@@@@+
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00,  //.%@@@@@@@@@+.
    0x00, 0xbf, 0xff, 0xff, 0xff, 0x60, 0x00,  //..%@@@@@@@+..
    0x00, 0x0d, 0xff, 0xff, 0xf7, 0x00, 0x00,  //...@@@@@@+...
    0x00, 0x6f, 0xff, 0xff, 0xfd, 0x10, 0x00,  //..+@@@@@@@...
    0x06, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x00,  //.+@@@@@@@@@..
    0x6f, 0xff, 0xff, 0xdf, 0xff, 0xfd, 0x10,  //+@@@@@@@@@@@.
    0xff, 0xff, 0xf6, 0x0b, 0xff, 0xff, 0x80,  //@@@@@+.%@@@@%
    0x7f, 0xff, 0x60, 0x00, 0xbf, 0xfe, 0x20,  //+@@@+...%@@@.
    0x07, 0xf5, 0x00, 0x00, 0x0b, 0xd2, 0x00,  //.+@+.....%@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+f011 () , Width: 17 */
    0x00, 0x00, 0x00, 0x02, 0x71, 0x00, 0x00, 0x00, 0x00,  //........+........
    0x00, 0x00, 0x00, 0x0e, 0xfb, 0x00, 0x00, 0x00, 0x00,  //.......@@%.......
    0x00, 0x00, 0x00, 0x0f, 0xfd, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x1c, 0xf3, 0x0f, 0xfd, 0x05, 0xfa, 0x00, 0x00,  //...@@..@@@.+@%...
    0x01, 0xdf, 0xf7, 0x0f, 0xfd, 0x0a, 0xff, 0xc0, 0x00,  //..@@@+.@@@.%@@@..
    0x0b, 0xff, 0xc1, 0x0f, 0xfd, 0x02, 0xef, 0xf8, 0x00,  //.%@@@..@@@..@@@%.
    0x4f, 0xfe, 0x00, 0x0f, 0xfd, 0x00, 0x2f, 0xff, 0x10,  //+@@@...@@@...@@@.
    0xaf, 0xf5, 0x00, 0x0f, 0xfd, 0x00, 0x08, 0xff, 0x70,  //%@@+...@@@...%@@+
    0xdf, 0xf0, 0x00, 0x0f, 0xfd, 0x00, 0x02, 0xff, 0xb0,  //@@@....@@@....@@%
    0xff, 0xd0, 0x00, 0x09, 0xf6, 0x00, 0x00, 0xff, 0xc0,  //@@@....%@+....@@@
    0xef, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xc0,  //@@@...........@@@
    0xcf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0x90,  //@@@..........+@@%
    0x7f, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x40,  //+@@%.........@@@+
    0x0e, 0xff, 0x70, 0x00, 0x00, 0x00, 0x9f, 0xfd, 0x00,  //.@@@+.......%@@@.
    0x05, 0xff, 0xfa, 0x30, 0x00, 0x4c, 0xff, 0xf3, 0x00,  //.+@@@%....+@@@@..
    0x00, 0x7f, 0xff, 0xfe, 0xdf, 0xff, 0xff, 0x50, 0x00,  //..+@@@@@@@@@@@+..
    0x00, 0x05, 0xef, 0xff, 0xff, 0xff, 0xd3, 0x00, 0x00,  //...+@@@@@@@@@....
    0x00, 0x00, 0x06, 0xbe, 0xfe, 0xb5, 0x00, 0x00, 0x00,  //.....+%@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f013 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x6f, 0xfb, 0x00, 0x00, 0x00, 0x00,  //......+@@%.......
    0x00, 0x07, 0x10, 0x9f, 0xfe, 0x00, 0x61, 0x00, 0x00,  //...+..%@@@..+....
    0x00, 0xbf, 0xe7, 0xef, 0xff, 0x8b, 0xfd, 0x10, 0x00,  //..%@@+@@@@%%@@...
    0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //.+@@@@@@@@@@@@%..
    0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x00,  //..@@@@@@@@@@@@...
    0x00, 0x7f, 0xff, 0xe8, 0x7d, 0xff, 0xfb, 0x00, 0x00,  //..+@@@@%+@@@@%...
    0x69, 0xef, 0xfe, 0x10, 0x00, 0xbf, 0xff, 0x97, 0x10,  //+%@@@@....%@@@%+.
    0xff, 0xff, 0xf8, 0x00, 0x00, 0x4f, 0xff, 0xff, 0x40,  //@@@@@%....+@@@@@+
    0xff, 0xff, 0xf7, 0x00, 0x00, 0x3f, 0xff, 0xff, 0x40,  //@@@@@+.....@@@@@+
    0xbe, 0xff, 0xfc, 0x00, 0x00, 0x8f, 0xff, 0xfd, 0x20,  //%@@@@@....%@@@@@.
    0x00, 0x8f, 0xff, 0xa3, 0x27, 0xff, 0xfd, 0x00, 0x00,  //..%@@@%..+@@@@...
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0x00,  //..%@@@@@@@@@@@...
    0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //.+@@@@@@@@@@@@%..
    0x01, 0xef, 0xfd, 0xff, 0xff, 0xdf, 0xff, 0x50, 0x00,  //..@@@@@@@@@@@@+..
    0x00, 0x2c, 0x50, 0xaf, 0xff, 0x02, 0xc5, 0x00, 0x00,  //...@+.%@@@..@+...
    0x00, 0x00, 0x00, 0x8f, 0xfc, 0x00, 0x00, 0x00, 0x00,  //......+@@@.......
    0x00, 0x00, 0x00, 0x15, 0x53, 0x00, 0x00, 0x00, 0x00,  //.......++........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f014 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x4e, 0xff, 0xfe, 0x30, 0x00, 0x00,  //....+@@@@@.....
    0x00, 0x00, 0xda, 0x55, 0x5b, 0xc0, 0x00, 0x00,  //....@%+++%@....
    0x23, 0x36, 0xf6, 0x33, 0x37, 0xf5, 0x33, 0x20,  //...+@+...+@+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@
    0x1a, 0xc2, 0x22, 0x22, 0x22, 0x22, 0xd9, 0x10,  //.%%.........@%.
    0x0a, 0xb0, 0x00, 0x00, 0x00, 0x00, 0xc8, 0x00,  //.%%.........@%.
    0x0a, 0xb0, 0xb4, 0x2c, 0x15, 0xa0, 0xc8, 0x00,  //.%%.%+.@.+%.@%.
    0x0a, 0xb0, 0xe6, 0x3f, 0x28, 0xd0, 0xc8, 0x00,  //.%%.@+.@.%@.@%.
    0x0a, 0xb0, 0xe6, 0x3f, 0x28, 0xd0, 0xc8, 0x00,  //.%%.@+.@.%@.@%.
    0x0a, 0xb0, 0xe6, 0x3f, 0x28, 0xd0, 0xc8, 0x00,  //.%%.@+.@.%@.@%.
    0x0a, 0xb0, 0xe6, 0x3f, 0x28, 0xd0, 0xc8, 0x00,  //.%%.@+.@.%@.@%.
    0x0a, 0xb0, 0xe6, 0x3f, 0x28, 0xd0, 0xc8, 0x00,  //.%%.@+.@.%@.@%.
    0x0a, 0xb0, 0xe6, 0x2f, 0x17, 0xc0, 0xc8, 0x00,  //.%%.@+.@.+@.@%.
    0x0a, 0xb0, 0x00, 0x00, 0x00, 0x00, 0xc8, 0x00,  //.%%.........@%.
    0x09, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xe8, 0x00,  //.%@.........@+.
    0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x00,  //..@@@@@@@@@@@..
    0x00, 0x25, 0x55, 0x55, 0x55, 0x55, 0x20, 0x00,  //...+++++++++...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f015 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x69, 0x80, 0x00,  //........++..+%%...
    0x00, 0x00, 0x00, 0x1b, 0xff, 0xa0, 0xbf, 0xf0, 0x00,  //.......%@@%.%@@...
    0x00, 0x00, 0x02, 0xdf, 0x99, 0xfc, 0xcf, 0xf0, 0x00,  //......@@%%@@@@@...
    0x00, 0x00, 0x4e, 0xf7, 0x66, 0x7f, 0xff, 0xf0, 0x00,  //....+@@++++@@@@...
    0x00, 0x06, 0xff, 0x59, 0xff, 0x95, 0xff, 0xf0, 0x00,  //...+@@+%@@%+@@@...
    0x00, 0x9f, 0xd3, 0xbf, 0xff, 0xfb, 0x4e, 0xf7, 0x00,  //..%@@.%@@@@%+@@+..
    0x1b, 0xfc, 0x3d, 0xff, 0xff, 0xff, 0xd4, 0xcf, 0xa0,  //.%@@.@@@@@@@@+@@%.
    0x6f, 0x94, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x4b, 0xf4,  //+@%+@@@@@@@@@@+%@+
    0x04, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x40,  //.+.@@@@@@@@@@@@...
    0x00, 0x0f, 0xff, 0xff, 0xee, 0xff, 0xff, 0xf0, 0x00,  //...@@@@@@@@@@@@...
    0x00, 0x0f, 0xff, 0xfb, 0x00, 0xbf, 0xff, 0xf0, 0x00,  //...@@@@%..%@@@@...
    0x00, 0x0f, 0xff, 0xfb, 0x00, 0xbf, 0xff, 0xf0, 0x00,  //...@@@@%..%@@@@...
    0x00, 0x0f, 0xff, 0xfb, 0x00, 0xbf, 0xff, 0xf0, 0x00,  //...@@@@%..%@@@@...
    0x00, 0x0d, 0xff, 0xfb, 0x00, 0xbf, 0xff, 0xd0, 0x00,  //...@@@@%..%@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f019 () , Width: 18 */
    0x00, 0x00, 0x00, 0x0a, 0xbb, 0x70, 0x00, 0x00, 0x00,  //.......%%%+.......
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xd0, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xd0, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xd0, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xd0, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x01, 0x44, 0x6f, 0xff, 0xe4, 0x44, 0x00, 0x00,  //....+++@@@@++.....
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00,  //...%@@@@@@@@@@....
    0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00,  //....@@@@@@@@@+....
    0x00, 0x00, 0x0c, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00,  //.....@@@@@@@+.....
    0x00, 0x00, 0x01, 0xcf, 0xff, 0xf8, 0x00, 0x00, 0x00,  //......@@@@@+......
    0x00, 0x00, 0x00, 0x1d, 0xff, 0x80, 0x00, 0x00, 0x00,  //.......@@@%.......
    0x9d, 0xdd, 0xdd, 0x31, 0xc8, 0x08, 0xdd, 0xdd, 0xc1,  //%@@@@@..@%.%@@@@@.
    0xff, 0xff, 0xff, 0xe1, 0x00, 0x6f, 0xff, 0xff, 0xf5,  //@@@@@@@...+@@@@@@+
    0xff, 0xff, 0xff, 0xfe, 0x79, 0xff, 0xff, 0xff, 0xf5,  //@@@@@@@@+%@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x68, 0xf3, 0xf5,  //@@@@@@@@@@@@++@.@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xab, 0xf9, 0xf5,  //@@@@@@@@@@@@%%@%@+
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,  //%@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f01c () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00, 0x00,  //...@@@@@@@@@@+...
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00,  //..%@@@@@@@@@@@...
    0x00, 0xff, 0x30, 0x00, 0x00, 0x00, 0xef, 0x40, 0x00,  //..@@........@@+..
    0x06, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xa0, 0x00,  //.+@@........%@%..
    0x0d, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xf1, 0x00,  //.@@+.........@@..
    0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xf8, 0x00,  //.@@..........%@%.
    0xaf, 0x90, 0x00, 0x00, 0x00, 0x00, 0x05, 0xfe, 0x00,  //%@%..........+@@.
    0xef, 0x51, 0x10, 0x00, 0x00, 0x01, 0x12, 0xff, 0x30,  //@@+...........@@.
    0xff, 0xff, 0xfb, 0x00, 0x00, 0x7f, 0xff, 0xff, 0x40,  //@@@@@%....+@@@@@+
    0xff, 0xff, 0xff, 0x41, 0x11, 0xef, 0xff, 0xff, 0x40,  //@@@@@@+...@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f021 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x05, 0x9b, 0xb9, 0x50, 0x00, 0x00, 0x00,  //.....+%%%%+......
    0x00, 0x05, 0xef, 0xff, 0xff, 0xfe, 0x50, 0x7f, 0x00,  //...+@@@@@@@@+.+@.
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0x10,  //..%@@@@@@@@@@@@@.
    0x06, 0xff, 0xf9, 0x20, 0x02, 0x8f, 0xff, 0xff, 0x10,  //.+@@@%....%@@@@@.
    0x1f, 0xff, 0x50, 0x00, 0x00, 0x09, 0xff, 0xff, 0x10,  //.@@@+......%@@@@.
    0x7f, 0xf8, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0x10,  //+@@%......+@@@@@.
    0xbf, 0xf0, 0x00, 0x00, 0x00, 0xdf, 0xff, 0xfe, 0x00,  //%@@.......@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x68, 0x88, 0x87, 0x00, 0x00, 0x00, 0x06, 0x86, 0x00,  //+%%%%+.......+%+.
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x3f, 0xfa, 0x00,  //@@@@@@.......@@%.
    0xff, 0xff, 0xc0, 0x00, 0x00, 0x01, 0xdf, 0xf3, 0x00,  //@@@@@.......@@@..
    0xff, 0xff, 0xf7, 0x10, 0x00, 0x6e, 0xff, 0xa0, 0x00,  //@@@@@+....+@@@%..
    0xff, 0xdf, 0xff, 0xfe, 0xef, 0xff, 0xfc, 0x00, 0x00,  //@@@@@@@@@@@@@@...
    0xfa, 0x07, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00,  //@%.+@@@@@@@@%....
    0x20, 0x00, 0x18, 0xdf, 0xfd, 0x93, 0x00, 0x00, 0x00,  //.....%@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f026 () , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x5e, 0x10,  //......+@.
    0x00, 0x00, 0x05, 0xff, 0x20,  //.....+@@.
    0x00, 0x00, 0x5f, 0xff, 0x20,  //....+@@@.
    0x24, 0x46, 0xff, 0xff, 0x20,  //.+++@@@@.
    0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@.
    0x12, 0x24, 0xff, 0xff, 0x20,  //...+@@@@.
    0x00, 0x00, 0x3f, 0xff, 0x20,  //.....@@@.
    0x00, 0x00, 0x03, 0xff, 0x20,  //......@@.
    0x00, 0x00, 0x00, 0x3c, 0x00,  //.......@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f027 () , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x5e, 0x10, 0x00, 0x00,  //......+@.....
    0x00, 0x00, 0x05, 0xff, 0x20, 0x00, 0x00,  //.....+@@.....
    0x00, 0x00, 0x5f, 0xff, 0x20, 0x00, 0x00,  //....+@@@.....
    0x24, 0x46, 0xff, 0xff, 0x20, 0x00, 0x00,  //.+++@@@@.....
    0xff, 0xff, 0xff, 0xff, 0x24, 0xf5, 0x00,  //@@@@@@@@.+@+.
    0xff, 0xff, 0xff, 0xff, 0x20, 0x9f, 0x00,  //@@@@@@@@..%@.
    0xff, 0xff, 0xff, 0xff, 0x20, 0x3f, 0x20,  //@@@@@@@@...@.
    0xff, 0xff, 0xff, 0xff, 0x20, 0xbe, 0x00,  //@@@@@@@@..%@.
    0xff, 0xff, 0xff, 0xff, 0x23, 0xd4, 0x00,  //@@@@@@@@..@+.
    0x12, 0x24, 0xff, 0xff, 0x20, 0x00, 0x00,  //...+@@@@.....
    0x00, 0x00, 0x3f, 0xff, 0x20, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x03, 0xff, 0x20, 0x00, 0x00,  //......@@.....
    0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00,  //.......@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+f028 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xf8, 0x00, 0x00,  //............@%....
    0x00, 0x00, 0x00, 0x5d, 0x00, 0x00, 0x6f, 0xc0, 0x00,  //......+@....+@@...
    0x00, 0x00, 0x05, 0xff, 0x20, 0x18, 0x12, 0xeb, 0x00,  //.....+@@...+..@%..
    0x00, 0x00, 0x5f, 0xff, 0x20, 0x2e, 0xf3, 0x3f, 0x50,  //....+@@@...@@..@+.
    0x23, 0x36, 0xff, 0xff, 0x20, 0x00, 0xae, 0x1a, 0xc0,  //...+@@@@....%@.%@.
    0xff, 0xff, 0xff, 0xff, 0x28, 0xe4, 0x0d, 0x94, 0xf1,  //@@@@@@@@.%@+.@%+@.
    0xff, 0xff, 0xff, 0xff, 0x21, 0xae, 0x07, 0xd1, 0xf4,  //@@@@@@@@..%@.+@.@+
    0xff, 0xff, 0xff, 0xff, 0x20, 0x3f, 0x25, 0xf0, 0xf5,  //@@@@@@@@...@.+@.@+
    0xff, 0xff, 0xff, 0xff, 0x21, 0xbe, 0x08, 0xd1, 0xf4,  //@@@@@@@@..%@.%@.@+
    0xff, 0xff, 0xff, 0xff, 0x27, 0xd3, 0x0e, 0x85, 0xf1,  //@@@@@@@@.+@..@%+@.
    0x12, 0x25, 0xff, 0xff, 0x20, 0x01, 0xbe, 0x1b, 0xc0,  //...+@@@@....%@.%@.
    0x00, 0x00, 0x4f, 0xff, 0x20, 0x2f, 0xe3, 0x4f, 0x50,  //.....@@@...@@.+@+.
    0x00, 0x00, 0x04, 0xff, 0x20, 0x16, 0x03, 0xea, 0x00,  //......@@...+..@%..
    0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x7f, 0xb0, 0x00,  //.......@....+@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe7, 0x00, 0x00,  //............@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f03e () , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00,  //+@@@@@@@@@@@@@@@@@@%.
    0xf9, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x6f, 0x40,  //@%+++++++++++++++++@+
    0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x50,  //@+.................@+
    0xf5, 0x06, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x50,  //@+.+@@+............@+
    0xf5, 0x0f, 0xff, 0xe0, 0x00, 0x00, 0x02, 0x00, 0x00, 0x0f, 0x50,  //@+.@@@@............@+
    0xf5, 0x0e, 0xff, 0xe0, 0x00, 0x00, 0x8f, 0x30, 0x00, 0x0f, 0x50,  //@+.@@@@.....%@.....@+
    0xf5, 0x05, 0xee, 0x40, 0x00, 0x08, 0xff, 0xf3, 0x00, 0x0f, 0x50,  //@+.+@@+....+@@@....@+
    0xf5, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0x30, 0x0f, 0x50,  //@+........+@@@@@...@+
    0xf5, 0x00, 0x00, 0x50, 0x07, 0xff, 0xff, 0xff, 0xe3, 0x0f, 0x50,  //@+....+..+@@@@@@@..@+
    0xf5, 0x00, 0x0c, 0xf7, 0x7f, 0xff, 0xff, 0xff, 0xfa, 0x0f, 0x50,  //@+...@@++@@@@@@@@%.@+
    0xf5, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0f, 0x50,  //@+..@@@@@@@@@@@@@%.@+
    0xf5, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0f, 0x50,  //@+.@@@@@@@@@@@@@@%.@+
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0f, 0x50,  //@+.@@@@@@@@@@@@@@%.@+
    0xf5, 0x0c, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xc8, 0x0f, 0x50,  //@+.@@@@@@@@@@@@@@%.@+
    0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x50,  //@+.................@+
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10,  //%@@@@@@@@@@@@@@@@@@@.
    0x04, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x51, 0x00,  //.++++++++++++++++++..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+f040 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xa1, 0x00, 0x00,  //...........+%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfd, 0x10, 0x00,  //..........%@@@...
    0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xd2, 0x00,  //..........@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x83, 0x6f, 0xff, 0xfd, 0x00,  //........%.+@@@@@.
    0x00, 0x00, 0x00, 0x09, 0xff, 0x36, 0xff, 0xfe, 0x00,  //.......%@@.+@@@@.
    0x00, 0x00, 0x00, 0x9f, 0x8d, 0xf3, 0x6f, 0xf4, 0x00,  //......%@%@@.+@@+.
    0x00, 0x00, 0x09, 0xf8, 0xcf, 0xff, 0x46, 0x40, 0x00,  //.....%@%@@@@.++..
    0x00, 0x00, 0x9f, 0x8c, 0xff, 0xff, 0xe0, 0x00, 0x00,  //....%@%@@@@@@....
    0x00, 0x09, 0xf8, 0xcf, 0xff, 0xff, 0x40, 0x00, 0x00,  //...%@%@@@@@@+....
    0x00, 0x9f, 0x8c, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00,  //..%@%@@@@@@+.....
    0x09, 0xf8, 0xcf, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00,  //.%@%@@@@@@+......
    0x9f, 0xcf, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@+.......
    0xf7, 0x0a, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //@+.%@@@@+........
    0xf9, 0x40, 0xaf, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00,  //@%+.%@@+.........
    0xff, 0xb0, 0xaf, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@%.%@+..........
    0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@+...........
    0x55, 0x55, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //++++.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f048 () , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xdf, 0xb0, 0x00, 0x00, 0x01, 0xc0,  //@@%.......@
    0xff, 0xd0, 0x00, 0x00, 0x1c, 0xf0,  //@@@......@@
    0xff, 0xd0, 0x00, 0x01, 0xcf, 0xf0,  //@@@.....@@@
    0xff, 0xd0, 0x00, 0x1c, 0xff, 0xf0,  //@@@....@@@@
    0xff, 0xd0, 0x01, 0xcf, 0xff, 0xf0,  //@@@...@@@@@
    0xff, 0xd0, 0x0c, 0xff, 0xff, 0xf0,  //@@@..@@@@@@
    0xff, 0xd0, 0xcf, 0xff, 0xff, 0xf0,  //@@@.@@@@@@@
    0xff, 0xec, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xee, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xd3, 0xef, 0xff, 0xff, 0xf0,  //@@@.@@@@@@@
    0xff, 0xd0, 0x3e, 0xff, 0xff, 0xf0,  //@@@..@@@@@@
    0xff, 0xd0, 0x03, 0xef, 0xff, 0xf0,  //@@@...@@@@@
    0xff, 0xd0, 0x00, 0x3e, 0xff, 0xf0,  //@@@....@@@@
    0xff, 0xd0, 0x00, 0x03, 0xef, 0xf0,  //@@@.....@@@
    0xff, 0xd0, 0x00, 0x00, 0x3e, 0xf0,  //@@@......@@
    0xff, 0xc0, 0x00, 0x00, 0x03, 0xe0,  //@@@.......@
    0x24, 0x10, 0x00, 0x00, 0x00, 0x10,  //.+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+f04b () , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+.............
    0xff, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+...........
    0xff, 0xff, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@..........
    0xff, 0xff, 0xff, 0xa1, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%........
    0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,  //@@@@@@@@%......
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x60, 0x00, 0x00,  //@@@@@@@@@@+....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x40, 0x00,  //@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x30,  //@@@@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb3, 0x00,  //@@@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x00, 0x00,  //@@@@@@@@@@@+...
    0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00, 0x00,  //@@@@@@@@@+.....
    0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@%.......
    0xff, 0xff, 0xfa, 0x10, 0x00, 0x00, 0x00, 0x00,  //@@@@@%.........
    0xff, 0xfc, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%...........
    0xfd, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+............
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f04c () , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xdf, 0xff, 0xff, 0xa0, 0x0a, 0xff, 0xff, 0xfd,  //@@@@@@%..%@@@@@@
    0xff, 0xff, 0xff, 0xc0, 0x0c, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xc0, 0x0c, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xc0, 0x0c, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xc0, 0x0c, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xc0, 0x0c, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xc0, 0x0c, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xc0, 0x0c, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xc0, 0x0c, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xc0, 0x0c, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xc0, 0x0c, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xc0, 0x0c, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xc0, 0x0c, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xc0, 0x0c, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xc0, 0x0c, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xb0, 0x0b, 0xff, 0xff, 0xff,  //@@@@@@%..%@@@@@@
    0x24, 0x44, 0x44, 0x10, 0x01, 0x44, 0x44, 0x42,  //.+++++....+++++.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+f04d () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@.
    0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43, 0x00,  //.++++++++++++++..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f051 () , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xa0, 0x00, 0x00, 0x00, 0xdf, 0xb0,  //%.......@@%
    0xfb, 0x00, 0x00, 0x00, 0xff, 0xd0,  //@%......@@@
    0xff, 0xa0, 0x00, 0x00, 0xff, 0xd0,  //@@%.....@@@
    0xff, 0xfa, 0x00, 0x00, 0xff, 0xd0,  //@@@%....@@@
    0xff, 0xff, 0xa0, 0x00, 0xff, 0xd0,  //@@@@%...@@@
    0xff, 0xff, 0xfa, 0x00, 0xff, 0xd0,  //@@@@@%..@@@
    0xff, 0xff, 0xff, 0xa0, 0xff, 0xd0,  //@@@@@@%.@@@
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xd0,  //@@@@@@@%@@@
    0xff, 0xff, 0xff, 0xfd, 0xff, 0xd0,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xd1, 0xff, 0xd0,  //@@@@@@@.@@@
    0xff, 0xff, 0xfd, 0x10, 0xff, 0xd0,  //@@@@@@..@@@
    0xff, 0xff, 0xd1, 0x00, 0xff, 0xd0,  //@@@@@...@@@
    0xff, 0xfd, 0x10, 0x00, 0xff, 0xd0,  //@@@@....@@@
    0xff, 0xd1, 0x00, 0x00, 0xff, 0xd0,  //@@@.....@@@
    0xfd, 0x10, 0x00, 0x00, 0xff, 0xd0,  //@@......@@@
    0xd1, 0x00, 0x00, 0x00, 0xff, 0xc0,  //@.......@@@
    0x10, 0x00, 0x00, 0x00, 0x24, 0x10,  //.........+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+f052 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x09, 0xc1, 0x00, 0x00, 0x00, 0x00,  //.......%@........
    0x00, 0x00, 0x00, 0x9f, 0xfd, 0x10, 0x00, 0x00, 0x00,  //......%@@@.......
    0x00, 0x00, 0x09, 0xff, 0xff, 0xd1, 0x00, 0x00, 0x00,  //.....%@@@@@......
    0x00, 0x00, 0x9f, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00,  //....%@@@@@@@.....
    0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x00, 0x00,  //...%@@@@@@@@@....
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x00,  //..%@@@@@@@@@@@...
    0x09, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x00,  //.%@@@@@@@@@@@@@..
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,  //%@@@@@@@@@@@@@@@.
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00,  //.................
    0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00,  //.................
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f053 () , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x9d, 0x10,  //........%@..
    0x00, 0x00, 0x00, 0x09, 0xff, 0xd1,  //.......%@@@.
    0x00, 0x00, 0x00, 0x9f, 0xff, 0xf8,  //......%@@@@%
    0x00, 0x00, 0x09, 0xff, 0xff, 0xc0,  //.....%@@@@@.
    0x00, 0x00, 0x9f, 0xff, 0xfc, 0x00,  //....%@@@@@..
    0x00, 0x09, 0xff, 0xff, 0xc0, 0x00,  //...%@@@@@...
    0x00, 0x9f, 0xff, 0xfc, 0x00, 0x00,  //..%@@@@@....
    0x09, 0xff, 0xff, 0xc0, 0x00, 0x00,  //.%@@@@@.....
    0x4f, 0xff, 0xff, 0x10, 0x00, 0x00,  //.@@@@@......
    0x0a, 0xff, 0xff, 0xb0, 0x00, 0x00,  //.%@@@@%.....
    0x00, 0xaf, 0xff, 0xfb, 0x00, 0x00,  //..%@@@@%....
    0x00, 0x0a, 0xff, 0xff, 0xb0, 0x00,  //...%@@@@%...
    0x00, 0x00, 0xaf, 0xff, 0xfb, 0x00,  //....%@@@@%..
    0x00, 0x00, 0x0a, 0xff, 0xff, 0xb0,  //.....%@@@@%.
    0x00, 0x00, 0x00, 0xaf, 0xff, 0xf7,  //......%@@@@+
    0x00, 0x00, 0x00, 0x0a, 0xff, 0xe2,  //.......%@@@.
    0x00, 0x00, 0x00, 0x00, 0xae, 0x20,  //........%@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+f054 () , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x06, 0xe3, 0x00, 0x00, 0x00, 0x00,  //.+@........
    0x6f, 0xff, 0x30, 0x00, 0x00, 0x00,  //+@@@.......
    0xef, 0xff, 0xf3, 0x00, 0x00, 0x00,  //@@@@@......
    0x4f, 0xff, 0xff, 0x30, 0x00, 0x00,  //+@@@@@.....
    0x04, 0xff, 0xff, 0xf3, 0x00, 0x00,  //.+@@@@@....
    0x00, 0x4f, 0xff, 0xff, 0x30, 0x00,  //..+@@@@@...
    0x00, 0x04, 0xff, 0xff, 0xf3, 0x00,  //...+@@@@@..
    0x00, 0x00, 0x4f, 0xff, 0xff, 0x30,  //....+@@@@@.
    0x00, 0x00, 0x07, 0xff, 0xff, 0xd0,  //.....+@@@@@
    0x00, 0x00, 0x3f, 0xff, 0xff, 0x40,  //.....@@@@@+
    0x00, 0x03, 0xff, 0xff, 0xf4, 0x00,  //....@@@@@+.
    0x00, 0x3f, 0xff, 0xff, 0x40, 0x00,  //...@@@@@+..
    0x03, 0xff, 0xff, 0xf4, 0x00, 0x00,  //..@@@@@+...
    0x3f, 0xff, 0xff, 0x40, 0x00, 0x00,  //.@@@@@+....
    0xef, 0xff, 0xf4, 0x00, 0x00, 0x00,  //@@@@@+.....
    0x7f, 0xff, 0x40, 0x00, 0x00, 0x00,  //+@@@+......
    0x07, 0xf4, 0x00, 0x00, 0x00, 0x00,  //.+@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+f067 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x04, 0xee, 0xe3, 0x00, 0x00, 0x00,  //.....+@@@......
    0x00, 0x00, 0x09, 0xff, 0xf7, 0x00, 0x00, 0x00,  //.....%@@@+.....
    0x00, 0x00, 0x09, 0xff, 0xf7, 0x00, 0x00, 0x00,  //.....%@@@+.....
    0x00, 0x00, 0x09, 0xff, 0xf7, 0x00, 0x00, 0x00,  //.....%@@@+.....
    0x00, 0x00, 0x09, 0xff, 0xf7, 0x00, 0x00, 0x00,  //.....%@@@+.....
    0x47, 0x77, 0x7c, 0xff, 0xfb, 0x77, 0x77, 0x30,  //+++++@@@@%++++.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@
    0x59, 0x99, 0x9d, 0xff, 0xfc, 0x99, 0x99, 0x40,  //+%%%%@@@@@%%%%+
    0x00, 0x00, 0x09, 0xff, 0xf7, 0x00, 0x00, 0x00,  //.....%@@@+.....
    0x00, 0x00, 0x09, 0xff, 0xf7, 0x00, 0x00, 0x00,  //.....%@@@+.....
    0x00, 0x00, 0x09, 0xff, 0xf7, 0x00, 0x00, 0x00,  //.....%@@@+.....
    0x00, 0x00, 0x09, 0xff, 0xf7, 0x00, 0x00, 0x00,  //.....%@@@+.....
    0x00, 0x00, 0x05, 0xff, 0xf4, 0x00, 0x00, 0x00,  //.....+@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f068 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00,  //...............
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //%@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f071 () , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xb0, 0x00, 0x00, 0x00, 0x00,  //........%@%........
    0x00, 0x00, 0x00, 0x04, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00,  //.......+@@@+.......
    0x00, 0x00, 0x00, 0x0d, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@.......
    0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00,  //......+@@@@@+......
    0x00, 0x00, 0x00, 0xef, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00,  //......@@@@@@@......
    0x00, 0x00, 0x08, 0xff, 0x22, 0x2f, 0xf8, 0x00, 0x00, 0x00,  //.....%@@...@@%.....
    0x00, 0x00, 0x1f, 0xff, 0x00, 0x0f, 0xff, 0x10, 0x00, 0x00,  //.....@@@...@@@.....
    0x00, 0x00, 0xaf, 0xff, 0x00, 0x0f, 0xff, 0xa0, 0x00, 0x00,  //....%@@@...@@@%....
    0x00, 0x03, 0xff, 0xff, 0x10, 0x1f, 0xff, 0xf3, 0x00, 0x00,  //....@@@@...@@@@....
    0x00, 0x0b, 0xff, 0xff, 0x10, 0x1f, 0xff, 0xfb, 0x00, 0x00,  //...%@@@@...@@@@%...
    0x00, 0x4f, 0xff, 0xff, 0x75, 0x7f, 0xff, 0xff, 0x40, 0x00,  //..+@@@@@+++@@@@@+..
    0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //..@@@@@@@@@@@@@@@..
    0x06, 0xff, 0xff, 0xff, 0x20, 0x2f, 0xff, 0xff, 0xf6, 0x00,  //.+@@@@@@...@@@@@@+.
    0x0e, 0xff, 0xff, 0xff, 0x20, 0x2f, 0xff, 0xff, 0xfe, 0x00,  //.@@@@@@@...@@@@@@@.
    0x8f, 0xff, 0xff, 0xff, 0xed, 0xef, 0xff, 0xff, 0xff, 0x80,  //%@@@@@@@@@@@@@@@@@%
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //%@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f074 () , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x00,  //...............@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xe2, 0x00,  //...............@@..
    0xcd, 0xdb, 0x70, 0x00, 0x01, 0x8b, 0xdd, 0xdf, 0xfe, 0x20,  //@@@%+.....+%@@@@@@.
    0xff, 0xff, 0xfd, 0x20, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@...@@@@@@@@@@
    0xff, 0xff, 0xff, 0xd1, 0xef, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@.@@@@@@@@@@+
    0x00, 0x02, 0xcf, 0x9a, 0xff, 0xb2, 0x00, 0x1f, 0xf4, 0x00,  //....@@%%@@%....@@+.
    0x00, 0x00, 0x1e, 0x4f, 0xfe, 0x00, 0x00, 0x1f, 0x40, 0x00,  //.....@+@@@.....@+..
    0x00, 0x00, 0x02, 0x9f, 0xf6, 0x00, 0x00, 0x03, 0x00, 0x00,  //......%@@+.........
    0x00, 0x00, 0x00, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@..........
    0x00, 0x00, 0x07, 0xff, 0x82, 0x00, 0x00, 0x03, 0x00, 0x00,  //.....+@@%..........
    0x00, 0x00, 0x1e, 0xff, 0x4d, 0x00, 0x00, 0x1f, 0x40, 0x00,  //.....@@@+@.....@+..
    0x00, 0x02, 0xcf, 0xf8, 0xaf, 0xb2, 0x00, 0x1f, 0xf4, 0x00,  //....@@@%%@%....@@+.
    0xff, 0xff, 0xff, 0xd1, 0xef, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@.@@@@@@@@@@+
    0xff, 0xff, 0xfd, 0x20, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@...@@@@@@@@@@
    0xcd, 0xdb, 0x70, 0x00, 0x01, 0x8b, 0xdd, 0xdf, 0xfe, 0x20,  //@@@%+.....%%@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xe2, 0x00,  //...............@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x20, 0x00,  //...............@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f077 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x07, 0xf7, 0x00, 0x00, 0x00, 0x00,  //.......+@+.......
    0x00, 0x00, 0x00, 0x7f, 0xff, 0x70, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x07, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00,  //.....+@@@@@+.....
    0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00,  //....+@@@@@@@+....
    0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00,  //...+@@@@@@@@@+...
    0x00, 0x7f, 0xff, 0xfd, 0x3d, 0xff, 0xff, 0x70, 0x00,  //..+@@@@@.@@@@@+..
    0x07, 0xff, 0xff, 0xd1, 0x01, 0xdf, 0xff, 0xf7, 0x00,  //.+@@@@@...@@@@@+.
    0x7f, 0xff, 0xfd, 0x10, 0x00, 0x1d, 0xff, 0xff, 0x70,  //+@@@@@.....@@@@@+
    0xef, 0xff, 0xd1, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xe0,  //@@@@@.......@@@@@
    0x3f, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x1d, 0xff, 0x30,  //.@@@.........@@@.
    0x03, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x01, 0xa3, 0x00,  //..%...........%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f078 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x02, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x00,  //..%...........%..
    0x2e, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xfe, 0x20,  //.@@%.........@@@.
    0xdf, 0xff, 0xc0, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xd0,  //@@@@%.......%@@@@
    0x9f, 0xff, 0xfc, 0x00, 0x00, 0x0c, 0xff, 0xff, 0x90,  //%@@@@%.....%@@@@%
    0x09, 0xff, 0xff, 0xc0, 0x00, 0xcf, 0xff, 0xf9, 0x00,  //.%@@@@%...%@@@@%.
    0x00, 0x9f, 0xff, 0xfb, 0x1c, 0xff, 0xff, 0x90, 0x00,  //..%@@@@%.%@@@@%..
    0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x00, 0x9f, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00,  //....%@@@@@@@%....
    0x00, 0x00, 0x09, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x9f, 0xff, 0x90, 0x00, 0x00, 0x00,  //......%@@@%......
    0x00, 0x00, 0x00, 0x09, 0xf9, 0x00, 0x00, 0x00, 0x00,  //.......%@%.......
    0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f079 () , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x05, 0xe3, 0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //...+@..%@@@@@@@@@@...
    0x00, 0x3f, 0xfe, 0x11, 0xef, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //...@@@..@@@@@@@@@@...
    0x01, 0xef, 0xff, 0xc0, 0x3d, 0xdd, 0xdd, 0xdf, 0xff, 0x00, 0x00,  //..@@@@@..@@@@@@@@@...
    0x0c, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00,  //.@@@@@@%.......@@@...
    0x8f, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00,  //%@@@@@@@+......@@@...
    0x48, 0x8f, 0xfe, 0x88, 0x20, 0x00, 0x00, 0x0d, 0xff, 0x00, 0x00,  //+%%@@@%%.......@@@...
    0x00, 0x0f, 0xfd, 0x00, 0x00, 0x00, 0x28, 0x8e, 0xff, 0x88, 0x40,  //...@@@.......%%@@@%%.
    0x00, 0x0f, 0xfd, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0x80,  //...@@@......+@@@@@@@%
    0x00, 0x0f, 0xfd, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xfc, 0x00,  //...@@@.......%@@@@@@.
    0x00, 0x0f, 0xff, 0xdd, 0xdd, 0xdd, 0x40, 0xcf, 0xff, 0xe1, 0x00,  //...@@@@@@@@@..@@@@@..
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x1e, 0xff, 0x30, 0x00,  //...@@@@@@@@@@..@@@...
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x03, 0xe5, 0x00, 0x00,  //...@@@@@@@@@@%..@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+f07b () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x1b, 0xee, 0xee, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@%...........
    0xbf, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@..........
    0xff, 0xff, 0xff, 0xff, 0x43, 0x33, 0x33, 0x32, 0x00,  //@@@@@@@@+.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,  //@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,  //@@@@@@@@@@@@@@@@@%
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@@@@@@@@@@@@+
    0x2c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,  //.@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f093 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00,  //........+.........
    0x00, 0x00, 0x00, 0x07, 0xfe, 0x30, 0x00, 0x00, 0x00,  //.......+@@........
    0x00, 0x00, 0x00, 0x7f, 0xff, 0xe3, 0x00, 0x00, 0x00,  //......+@@@@.......
    0x00, 0x00, 0x07, 0xff, 0xff, 0xfe, 0x30, 0x00, 0x00,  //.....+@@@@@@......
    0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xe3, 0x00, 0x00,  //....+@@@@@@@@.....
    0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0x00,  //...+@@@@@@@@@@....
    0x00, 0x03, 0x99, 0xaf, 0xff, 0xe9, 0x98, 0x00, 0x00,  //....%%%@@@@%%%....
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xd0, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xd0, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xd0, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xd0, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x1f, 0xff, 0xb0, 0x00, 0x00, 0x00,  //.......@@@%.......
    0xcf, 0xff, 0xfd, 0x10, 0x00, 0x04, 0xff, 0xff, 0xf2,  //@@@@@@.....+@@@@@.
    0xff, 0xff, 0xff, 0xeb, 0xbb, 0xcf, 0xff, 0xff, 0xf5,  //@@@@@@@%%%@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,  //@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x68, 0xf3, 0xf5,  //@@@@@@@@@@@@+%@.@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@@@@@+
    0x25, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x40,  //.++++++++++++++++.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f095 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x06, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@%...........
    0x4f, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@...........
    0xcf, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@..........
    0xff, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@+.........
    0xef, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@%..........
    0x9f, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%...........
    0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@%...........
    0x0c, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@+..........
    0x03, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@..........
    0x00, 0x8f, 0xfe, 0x20, 0x00, 0x05, 0x00, 0x00,  //..+@@@.....+...
    0x00, 0x0a, 0xff, 0xf6, 0x00, 0xbf, 0xc3, 0x00,  //...%@@@+..%@@..
    0x00, 0x00, 0xaf, 0xff, 0xcb, 0xff, 0xff, 0xa0,  //....%@@@%%@@@@%
    0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xc0,  //.....+@@@@@@@@@
    0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0xff, 0x60,  //.......@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x39, 0xef, 0xc4, 0x00,  //.........%@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f0c4 () , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x06, 0xbc, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+%@%..............
    0x8f, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x23, 0x00,  //%@@@@@%............
    0xfe, 0x20, 0x4c, 0xf8, 0x00, 0x00, 0x00, 0x19, 0x98, 0xa0,  //@@..+@@%.......%%%%
    0xed, 0x00, 0x00, 0xdf, 0x00, 0x00, 0x18, 0xa2, 0x05, 0x90,  //@@....@@.....%%..+%
    0x8f, 0xa1, 0x00, 0xbf, 0x00, 0x07, 0xa3, 0x00, 0x96, 0x00,  //%@%...%@...+%...%+.
    0x09, 0xff, 0xdd, 0xfc, 0xb7, 0xb4, 0x00, 0x2a, 0x30, 0x00,  //.%@@@@@@%+%+...%...
    0x00, 0x3a, 0xcc, 0xa9, 0xb5, 0x00, 0x05, 0x90, 0x00, 0x00,  //...%@@%%%+...+%....
    0x00, 0x00, 0x00, 0x06, 0xd5, 0xc0, 0x9b, 0x00, 0x00, 0x00,  //.......+@+@.%%.....
    0x00, 0x39, 0xcc, 0xaa, 0x15, 0x4a, 0x36, 0x90, 0x00, 0x00,  //...%@@%%.++%.+%....
    0x09, 0xff, 0xff, 0xfb, 0xba, 0xf4, 0x00, 0x3b, 0x20, 0x00,  //.%@@@@@%%%@+...%...
    0x7f, 0xd5, 0x01, 0xcf, 0x10, 0x2a, 0xa2, 0x01, 0xa5, 0x00,  //+@@+..@@...%%...%+.
    0xee, 0x00, 0x00, 0xbf, 0x00, 0x00, 0x3b, 0x80, 0x08, 0x80,  //@@....%@.....%%..%%
    0xfd, 0x00, 0x1a, 0xfa, 0x00, 0x00, 0x00, 0x4b, 0x76, 0xc0,  //@@...%@%......+%++%
    0xaf, 0xfe, 0xff, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00,  //%@@@@@@.........++.
    0x09, 0xef, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f0c5 () , Width: 19 */
    0x00, 0x00, 0x00, 0x34, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00,  //.......++++........
    0x00, 0x00, 0x2d, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00,  //.....@@@@@@@.......
    0x00, 0x02, 0xef, 0xf1, 0x11, 0x3f, 0x30, 0x00, 0x00, 0x00,  //....@@@....@.......
    0x00, 0x2e, 0xd8, 0xf0, 0x00, 0x2f, 0x30, 0x00, 0x00, 0x00,  //...@@+@....@.......
    0x02, 0xed, 0x15, 0xf0, 0x00, 0x2f, 0x44, 0x44, 0x44, 0x20,  //..@@.+@....@++++++.
    0x2e, 0xc1, 0x05, 0xf0, 0x00, 0x2f, 0xff, 0xff, 0xff, 0xe0,  //.@@..+@....@@@@@@@@
    0xcf, 0xff, 0xff, 0xf0, 0x00, 0x5f, 0xf9, 0x00, 0x05, 0xf0,  //%@@@@@@...+@@%...+@
    0xf9, 0x55, 0x55, 0x20, 0x04, 0xf9, 0xc9, 0x00, 0x05, 0xf0,  //@%++++...+@%@%...+@
    0xf5, 0x00, 0x00, 0x00, 0x4f, 0x90, 0xc9, 0x00, 0x05, 0xf0,  //@+.......@%.@%...+@
    0xf5, 0x00, 0x00, 0x03, 0xfa, 0x00, 0xc9, 0x00, 0x05, 0xf0,  //@+......@%..@%...+@
    0xf5, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xf8, 0x00, 0x05, 0xf0,  //@+.....@@@@@@%...+@
    0xf5, 0x00, 0x00, 0x0f, 0x85, 0x55, 0x50, 0x00, 0x05, 0xf0,  //@+.....@%++++....+@
    0xf5, 0x00, 0x00, 0x0f, 0x40, 0x00, 0x00, 0x00, 0x05, 0xf0,  //@+.....@+........+@
    0xf5, 0x00, 0x00, 0x0f, 0x40, 0x00, 0x00, 0x00, 0x05, 0xf0,  //@+.....@+........+@
    0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x05, 0xf0,  //@@@@@@@@+........+@
    0x25, 0x55, 0x55, 0x5f, 0x40, 0x00, 0x00, 0x00, 0x05, 0xf0,  //.++++++@+........+@
    0x00, 0x00, 0x00, 0x0f, 0x40, 0x00, 0x00, 0x00, 0x05, 0xf0,  //.......@+........+@
    0x00, 0x00, 0x00, 0x0f, 0x40, 0x00, 0x00, 0x00, 0x05, 0xf0,  //.......@+........+@
    0x00, 0x00, 0x00, 0x0f, 0x85, 0x55, 0x55, 0x55, 0x59, 0xf0,  //.......@%++++++++%@
    0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //.......%@@@@@@@@@@%


    /*Unicode: U+f0c7 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x40, 0x00, 0x00,  //%@@@@@@@@@@@+....
    0xf9, 0x6f, 0xff, 0xf5, 0x59, 0xf8, 0xf5, 0x00, 0x00,  //@%+@@@@++%@%@+...
    0xf5, 0x0f, 0xff, 0xf0, 0x05, 0xf0, 0x7f, 0x50, 0x00,  //@+.@@@@..+@.+@+..
    0xf5, 0x0f, 0xff, 0xf0, 0x05, 0xf0, 0x07, 0xf5, 0x00,  //@+.@@@@..+@..+@+.
    0xf5, 0x0f, 0xff, 0xf0, 0x05, 0xf0, 0x00, 0x8f, 0x00,  //@+.@@@@..+@...%@.
    0xf5, 0x0f, 0xff, 0xf6, 0x59, 0xf0, 0x00, 0x1f, 0x40,  //@+.@@@@++%@....@.
    0xf5, 0x0c, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x1f, 0x40,  //@+.@@@@@@@%....@+
    0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x40,  //@+.............@+
    0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x40,  //@+.............@+
    0xf5, 0x03, 0x55, 0x55, 0x55, 0x55, 0x40, 0x1f, 0x40,  //@+..+++++++++..@+
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x1f, 0x40,  //@+.@@@@@@@@@@+.@+
    0xf5, 0x0f, 0x40, 0x00, 0x00, 0x00, 0xf5, 0x1f, 0x40,  //@+.@+.......@+.@+
    0xf5, 0x0f, 0x40, 0x00, 0x00, 0x00, 0xf5, 0x1f, 0x40,  //@+.@+.......@+.@+
    0xf5, 0x0f, 0x40, 0x00, 0x00, 0x00, 0xf5, 0x1f, 0x40,  //@+.@+.......@+.@+
    0xf5, 0x1f, 0x40, 0x00, 0x00, 0x00, 0xf5, 0x1f, 0x40,  //@+.@+.......@+.@+
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@@@@@@@.
    0x25, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x54, 0x00,  //.+++++++++++++++.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f0e7 () , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0xdf, 0xff, 0x70, 0x00,  //..@@@@+...
    0x02, 0xff, 0xff, 0x30, 0x00,  //..@@@@....
    0x06, 0xff, 0xfd, 0x00, 0x00,  //.+@@@@....
    0x0a, 0xff, 0xf7, 0x00, 0x00,  //.%@@@+....
    0x0d, 0xff, 0xf1, 0x02, 0x63,  //.@@@@...+.
    0x1f, 0xff, 0xea, 0xef, 0xf4,  //.@@@@%@@@+
    0x5f, 0xff, 0xff, 0xff, 0xc0,  //+@@@@@@@@.
    0x9f, 0xff, 0xff, 0xff, 0x50,  //%@@@@@@@+.
    0xdf, 0xfe, 0xbf, 0xfd, 0x00,  //@@@@%@@@..
    0x85, 0x10, 0x5f, 0xf6, 0x00,  //%+..+@@+..
    0x00, 0x00, 0x9f, 0xe0, 0x00,  //....%@@...
    0x00, 0x00, 0xdf, 0x70, 0x00,  //....@@+...
    0x00, 0x00, 0xff, 0x00, 0x00,  //....@@....
    0x00, 0x04, 0xf8, 0x00, 0x00,  //...+@%....
    0x00, 0x08, 0xf1, 0x00, 0x00,  //...%@.....
    0x00, 0x0c, 0x90, 0x00, 0x00,  //...@%.....
    0x00, 0x0f, 0x20, 0x00, 0x00,  //...@......
    0x00, 0x17, 0x00, 0x00, 0x00,  //...+......


    /*Unicode: U+f0f3 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x01, 0xfb, 0x00, 0x00, 0x00, 0x00,  //........@%........
    0x00, 0x00, 0x00, 0x4a, 0xfe, 0x82, 0x00, 0x00, 0x00,  //......+%@@%.......
    0x00, 0x00, 0x1b, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00,  //.....%@@@@@@+.....
    0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00,  //....%@@@@@@@@+....
    0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00,  //...+@@@@@@@@@@....
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x00,  //...%@@@@@@@@@@....
    0x00, 0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00,  //...%@@@@@@@@@@+...
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00,  //...%@@@@@@@@@@+...
    0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00,  //...@@@@@@@@@@@+...
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //...@@@@@@@@@@@%...
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //...@@@@@@@@@@@@...
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00,  //..%@@@@@@@@@@@@+..
    0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //..@@@@@@@@@@@@@%..
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //.%@@@@@@@@@@@@@@+.
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,  //%@@@@@@@@@@@@@@@@+
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,  //%@@@@@@@@@@@@@@@@+
    0x01, 0x22, 0x22, 0xda, 0xff, 0xf8, 0x22, 0x22, 0x10,  //......@%@@@%......
    0x00, 0x00, 0x00, 0x7b, 0xaf, 0xf2, 0x00, 0x00, 0x00,  //......+%%@@.......
    0x00, 0x00, 0x00, 0x07, 0xcb, 0x30, 0x00, 0x00, 0x00,  //.......+@%........


    /*Unicode: U+f11c () , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x03, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x31, 0x00,  //.....................
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@@@@@@@@@@@@@.
    0xf7, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2f, 0x50,  //@+.................@+
    0xf5, 0x05, 0x20, 0x50, 0x51, 0x05, 0x01, 0x50, 0x51, 0x0f, 0x50,  //@+.+..+.+..+..+.+..@+
    0xf5, 0x0f, 0x62, 0xe0, 0xf5, 0x1f, 0x35, 0xf0, 0xf5, 0x0f, 0x50,  //@+.@+.@.@+.@.+@.@+.@+
    0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf5, 0x0f, 0x50,  //@+..............@+.@+
    0xf5, 0x0f, 0xfd, 0x1f, 0x09, 0xd0, 0xca, 0x5f, 0xf5, 0x0f, 0x50,  //@+.@@@.@.%@.@%+@@+.@+
    0xf5, 0x05, 0x54, 0x05, 0x03, 0x40, 0x43, 0x15, 0x51, 0x0f, 0x50,  //@+.+++.+..+.+..++..@+
    0xf5, 0x01, 0x00, 0x11, 0x11, 0x11, 0x11, 0x10, 0x10, 0x0f, 0x50,  //@+.................@+
    0xf5, 0x0f, 0x62, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xf5, 0x0f, 0x50,  //@+.@+.@@@@@@@@@.@+.@+
    0xf5, 0x04, 0x10, 0x44, 0x44, 0x44, 0x44, 0x40, 0x41, 0x0f, 0x50,  //@+.+..+++++++++.+..@+
    0xf9, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5f, 0x50,  //@%+++++++++++++++++@+
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,  //%@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+f124 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x60,  //.............++
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xcf, 0xc0,  //...........+@@@
    0x00, 0x00, 0x00, 0x00, 0x04, 0xcf, 0xff, 0x50,  //.........+@@@@+
    0x00, 0x00, 0x00, 0x04, 0xcf, 0xff, 0xfc, 0x00,  //.......+@@@@@@.
    0x00, 0x00, 0x04, 0xcf, 0xff, 0xff, 0xf4, 0x00,  //.....+@@@@@@@+.
    0x00, 0x04, 0xcf, 0xff, 0xff, 0xff, 0xc0, 0x00,  //...+@@@@@@@@@..
    0x04, 0xcf, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00,  //.+@@@@@@@@@@+..
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,  //%@@@@@@@@@@@...
    0x79, 0x99, 0x99, 0xaf, 0xff, 0xf4, 0x00, 0x00,  //+%%%%%%@@@@+...
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xc0, 0x00, 0x00,  //.......@@@@....
    0x00, 0x00, 0x00, 0x3f, 0xff, 0x40, 0x00, 0x00,  //.......@@@+....
    0x00, 0x00, 0x00, 0x3f, 0xfc, 0x00, 0x00, 0x00,  //.......@@@.....
    0x00, 0x00, 0x00, 0x3f, 0xf4, 0x00, 0x00, 0x00,  //.......@@+.....
    0x00, 0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00, 0x00,  //.......@@......
    0x00, 0x00, 0x00, 0x3f, 0x40, 0x00, 0x00, 0x00,  //.......@+......
    0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,  //.......+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f15b () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xcf, 0xff, 0xff, 0xff, 0xf7, 0x11, 0x00, 0x00, 0x00,  //%@@@@@@@@+.......
    0xff, 0xff, 0xff, 0xff, 0xf7, 0x2e, 0x20, 0x00, 0x00,  //@@@@@@@@@+.@.....
    0xff, 0xff, 0xff, 0xff, 0xf7, 0x2f, 0xe2, 0x00, 0x00,  //@@@@@@@@@+.@@....
    0xff, 0xff, 0xff, 0xff, 0xf7, 0x2f, 0xfe, 0x20, 0x00,  //@@@@@@@@@+.@@@...
    0xff, 0xff, 0xff, 0xff, 0xf7, 0x2f, 0xff, 0xe2, 0x00,  //@@@@@@@@@+.@@@@..
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x06, 0x66, 0x64, 0x00,  //@@@@@@@@@+.+++++.
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x33, 0x33, 0x33, 0x00,  //@@@@@@@@@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10,  //@@@@@@@@@@@@@@@@.


    /*Unicode: U+f1eb () , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x01, 0x6a, 0xdf, 0xff, 0xda, 0x72, 0x00, 0x00, 0x00,  //......+%@@@@@%+......
    0x00, 0x01, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb3, 0x00, 0x00,  //....%@@@@@@@@@@@%....
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xde, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@@@@@@@@@%..
    0x1b, 0xff, 0xff, 0x94, 0x00, 0x00, 0x03, 0x8e, 0xff, 0xfd, 0x20,  //.%@@@@%+......%@@@@@.
    0xaf, 0xff, 0x81, 0x15, 0x9b, 0xdc, 0xa6, 0x10, 0x7f, 0xff, 0xd0,  //%@@@%..+%%@%%+..+@@@@
    0x2e, 0xe4, 0x18, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x22, 0xdf, 0x30,  //.@@..%@@@@@@@@@%..@@.
    0x01, 0x13, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x02, 0x00,  //....@@@@@@@@@@@@@+...
    0x00, 0x0c, 0xff, 0xfa, 0x52, 0x01, 0x38, 0xff, 0xfe, 0x00, 0x00,  //...%@@@%+....%@@@@...
    0x00, 0x01, 0xda, 0x11, 0x7b, 0xdb, 0x82, 0x19, 0xe3, 0x00, 0x00,  //....@%..+%@%%..%@....
    0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,  //......+@@@@@@@%......
    0x00, 0x00, 0x00, 0xdf, 0xff, 0xff, 0xff, 0xf1, 0x00, 0x00, 0x00,  //......@@@@@@@@@......
    0x00, 0x00, 0x00, 0x2e, 0xa3, 0x02, 0x8e, 0x30, 0x00, 0x00, 0x00,  //.......@%...%@.......
    0x00, 0x00, 0x00, 0x00, 0x04, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+%+.........
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x02, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+f240 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x04, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00,  //.+++++++++++++++++++++...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf1, 0x00,  //@+...................+@..
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0xf2, 0x00,  //@+.@@@@@@@@@@@@@@@@@%+@..
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0xff, 0x30,  //@+.@@@@@@@@@@@@@@@@@%+@@.
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x6f, 0x60,  //@+.@@@@@@@@@@@@@@@@@%.+@+
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0e, 0x60,  //@+.@@@@@@@@@@@@@@@@@%..@+
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0e, 0x60,  //@+.@@@@@@@@@@@@@@@@@%..@+
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0e, 0x60,  //@+.@@@@@@@@@@@@@@@@@%..@+
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa3, 0xbf, 0x50,  //@+.@@@@@@@@@@@@@@@@@%.%@+
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0xf6, 0x00,  //@+.@@@@@@@@@@@@@@@@@%+@+.
    0xf5, 0x02, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x14, 0xf1, 0x00,  //@+...................+@..
    0xf9, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x59, 0xf0, 0x00,  //@%+++++++++++++++++++%@..
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f241 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x04, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00,  //.+++++++++++++++++++++...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf1, 0x00,  //@+...................+@..
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x04, 0xf2, 0x00,  //@+.@@@@@@@@@@@@@%....+@..
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x04, 0xff, 0x30,  //@+.@@@@@@@@@@@@@%....+@@.
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x01, 0x6f, 0x60,  //@+.@@@@@@@@@@@@@%.....+@+
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x0e, 0x60,  //@+.@@@@@@@@@@@@@%......@+
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x0e, 0x60,  //@+.@@@@@@@@@@@@@%......@+
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x0e, 0x60,  //@+.@@@@@@@@@@@@@%......@+
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x03, 0xbf, 0x50,  //@+.@@@@@@@@@@@@@%.....%@+
    0xf5, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x04, 0xf6, 0x00,  //@+.@@@@@@@@@@@@@%....+@+.
    0xf5, 0x02, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x10, 0x00, 0x04, 0xf1, 0x00,  //@+...................+@..
    0xf9, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x59, 0xf0, 0x00,  //@%+++++++++++++++++++%@..
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f242 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x04, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00,  //.+++++++++++++++++++++...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf1, 0x00,  //@+...................+@..
    0xf5, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf2, 0x00,  //@++@@@@@@@@@.........+@..
    0xf5, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0x30,  //@++@@@@@@@@@.........+@@.
    0xf5, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x01, 0x6f, 0x60,  //@++@@@@@@@@@..........+@+
    0xf5, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x60,  //@++@@@@@@@@@...........@+
    0xf5, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x60,  //@++@@@@@@@@@...........@+
    0xf5, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x60,  //@++@@@@@@@@@...........@+
    0xf5, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x03, 0xbf, 0x50,  //@++@@@@@@@@@..........%@+
    0xf5, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf6, 0x00,  //@++@@@@@@@@@.........+@+.
    0xf5, 0x12, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf1, 0x00,  //@+...................+@..
    0xf9, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x59, 0xf0, 0x00,  //@%+++++++++++++++++++%@..
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f243 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x04, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00,  //.+++++++++++++++++++++...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf1, 0x00,  //@+...................+@..
    0xf5, 0x4f, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf2, 0x00,  //@++@@@@@.............+@..
    0xf5, 0x4f, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0x30,  //@++@@@@@.............+@@.
    0xf5, 0x4f, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x6f, 0x60,  //@++@@@@@..............+@+
    0xf5, 0x4f, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x60,  //@++@@@@@...............@+
    0xf5, 0x4f, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x60,  //@++@@@@@...............@+
    0xf5, 0x4f, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x60,  //@++@@@@@...............@+
    0xf5, 0x4f, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xbf, 0x50,  //@++@@@@@..............%@+
    0xf5, 0x4f, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf6, 0x00,  //@++@@@@@.............+@+.
    0xf5, 0x02, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf1, 0x00,  //@+...................+@..
    0xf9, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x59, 0xf0, 0x00,  //@%+++++++++++++++++++%@..
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f244 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x04, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00,  //.+++++++++++++++++++++...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf1, 0x00,  //@+...................+@..
    0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf1, 0x00,  //@+...................+@..
    0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xfe, 0x20,  //@+...................+@@.
    0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x6f, 0x60,  //@+....................+@+
    0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x60,  //@+.....................@+
    0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x60,  //@+.....................@+
    0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x60,  //@+.....................@+
    0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xbf, 0x60,  //@+....................%@+
    0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xfa, 0x00,  //@+...................+@%.
    0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf1, 0x00,  //@+...................+@..
    0xf9, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x59, 0xf0, 0x00,  //@%+++++++++++++++++++%@..
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f293 () , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x04, 0xae, 0xff, 0xea, 0x40, 0x00,  //...+%@@@@%+...
    0x00, 0x9f, 0xff, 0xcf, 0xff, 0xf9, 0x00,  //..%@@@@@@@@%..
    0x07, 0xff, 0xff, 0x66, 0xff, 0xff, 0x70,  //.+@@@@++@@@@+.
    0x0f, 0xff, 0xff, 0x60, 0x6f, 0xff, 0xf0,  //.@@@@@+.+@@@@.
    0x5f, 0xff, 0xff, 0x60, 0x06, 0xff, 0xf5,  //+@@@@@+..+@@@+
    0xaf, 0xf6, 0xdf, 0x63, 0x90, 0x6f, 0xfa,  //%@@+@@+.%.+@@%
    0xcf, 0xe2, 0x1d, 0x63, 0xe1, 0x1e, 0xfc,  //@@@..@+.@..@@@
    0xef, 0xfe, 0x21, 0x32, 0x21, 0xdf, 0xfe,  //@@@@......@@@@
    0xff, 0xff, 0xe2, 0x00, 0x1d, 0xff, 0xff,  //@@@@@....@@@@@
    0xff, 0xff, 0xfd, 0x00, 0xaf, 0xff, 0xff,  //@@@@@@..%@@@@@
    0xff, 0xff, 0xe2, 0x00, 0x1d, 0xff, 0xff,  //@@@@@....@@@@@
    0xef, 0xfe, 0x21, 0x32, 0x21, 0xdf, 0xfe,  //@@@@......@@@@
    0xcf, 0xe2, 0x1d, 0x63, 0xe1, 0x1e, 0xfc,  //@@@..@+.@..@@@
    0xaf, 0xf6, 0xdf, 0x63, 0x90, 0x7f, 0xf9,  //%@@+@@+.%.+@@%
    0x5f, 0xff, 0xff, 0x60, 0x07, 0xff, 0xf5,  //+@@@@@+..+@@@+
    0x0f, 0xff, 0xff, 0x60, 0x7f, 0xff, 0xf0,  //.@@@@@+.+@@@@.
    0x07, 0xff, 0xff, 0x67, 0xff, 0xff, 0x70,  //.+@@@@++@@@@+.
    0x00, 0x9f, 0xff, 0xcf, 0xff, 0xf9, 0x00,  //..%@@@@@@@@%..
    0x00, 0x03, 0xae, 0xff, 0xea, 0x30, 0x00,  //....%@@@@%....



#elif USE_LV_FONT_SYMBOL_20 == 8
    /*Unicode: U+f001 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x6e, 0x92, 0x0e,  //..............+%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x7e, 0xce, 0xff, 0xff, 0xff, 0x56,  //...........+@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x3e, 0x8e, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a,  //........%@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a,  //......@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a,  //.....+@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0x5a,  //.....+@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xb4, 0x64, 0x14, 0xff, 0x5a,  //.....+@@@@@@%+.@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xf0, 0xa6, 0x54, 0x0c, 0x00, 0x00, 0x00, 0xff, 0x5a,  //.....+@@@%+....@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0x46, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x5a,  //.....+@+.......@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x5a,  //.....+@........@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x5a,  //.....+@........@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0x00, 0x00, 0x00, 0x20, 0x86, 0xba, 0xbc, 0x88, 0xff, 0x5a,  //.....+@....%%%%@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0x00, 0x00, 0x2c, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a,  //.....+@...@@@@@@+
    0x00, 0x00, 0x00, 0x0a, 0x00, 0x5a, 0xff, 0x00, 0x00, 0x58, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a,  //.....+@..+@@@@@@+
    0x0c, 0x92, 0xea, 0xff, 0xf6, 0xd6, 0xff, 0x00, 0x00, 0x04, 0x96, 0xf8, 0xff, 0xff, 0xf8, 0x8c, 0x02,  //.%@@@@@...%@@@@%.
    0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x3a, 0x38, 0x0a, 0x00, 0x00,  //%@@@@@@..........
    0x9c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@..........
    0x06, 0x80, 0xd6, 0xf8, 0xe2, 0x9a, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@%...........


    /*Unicode: U+f008 () , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x6a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xb4, 0x06,  //+@@@@@@@@@@@@@@@@@@%.
    0xf2, 0xb4, 0x56, 0x78, 0xff, 0xb4, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x86, 0xff, 0xa8, 0x56, 0x78, 0xff, 0x4e,  //@%++@%++++++++%@%++@+
    0xff, 0x5a, 0x00, 0x00, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0x46, 0x00, 0x00, 0xff, 0x5a,  //@+..@+.........@+..@+
    0xff, 0x7a, 0x00, 0x20, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0x68, 0x00, 0x20, 0xff, 0x5a,  //@+..@+.........@+..@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a,  //@@@@@+.........@@@@@+
    0xff, 0xb6, 0x5a, 0x7c, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xaa, 0x5a, 0x7c, 0xff, 0x5a,  //@%++@+.........@%++@+
    0xff, 0x5a, 0x00, 0x00, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0x46, 0x00, 0x00, 0xff, 0x5a,  //@+..@+.........@+..@+
    0xff, 0x7a, 0x00, 0x20, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0x68, 0x00, 0x20, 0xff, 0x5a,  //@+..@+.........@+..@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a,  //@@@@@@@@@@@@@@@@@@@@+
    0xff, 0xb4, 0x5a, 0x7c, 0xff, 0xb8, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x8c, 0xff, 0xaa, 0x5a, 0x7c, 0xff, 0x5a,  //@%++@%++++++++%@%++@+
    0xff, 0x5a, 0x00, 0x00, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0x46, 0x00, 0x00, 0xff, 0x5a,  //@+..@+.........@+..@+
    0xff, 0x7a, 0x00, 0x20, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0x68, 0x00, 0x20, 0xff, 0x5a,  //@+..@+.........@+..@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a,  //@@@@@+.........@@@@@+
    0xff, 0xb8, 0x5a, 0x7e, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xae, 0x5a, 0x80, 0xff, 0x5a,  //@%++@+.........@%++@+
    0xff, 0x5c, 0x00, 0x00, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0x48, 0x00, 0x00, 0xff, 0x5a,  //@+..@+.........@+..@+
    0xff, 0x5c, 0x00, 0x00, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0x48, 0x00, 0x00, 0xff, 0x5a,  //@+..@+.........@+..@+
    0xf0, 0xbc, 0x5a, 0x82, 0xff, 0xb8, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x8c, 0xff, 0xb0, 0x5a, 0x82, 0xff, 0x4c,  //@%+%@%++++++++%@%+%@+
    0x6a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xb4, 0x04,  //+@@@@@@@@@@@@@@@@@@%.


    /*Unicode: U+f00b () , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xc0, 0xff, 0xff, 0xff, 0xf2, 0x38, 0x14, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //%@@@@..@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x36, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@+.@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x36, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@+.@@@@@@@@@@@@
    0xce, 0xff, 0xff, 0xff, 0xfa, 0x3e, 0x16, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce,  //@@@@@..@@@@@@@@@@@@
    0x00, 0x0e, 0x0e, 0x0e, 0x08, 0x00, 0x00, 0x04, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x00,  //...................
    0x02, 0x12, 0x12, 0x12, 0x0a, 0x00, 0x00, 0x06, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x02,  //...................
    0xd2, 0xff, 0xff, 0xff, 0xfa, 0x40, 0x18, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2,  //@@@@@..@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x36, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@+.@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x36, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@+.@@@@@@@@@@@@
    0xc0, 0xff, 0xff, 0xff, 0xf2, 0x38, 0x14, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //%@@@@..@@@@@@@@@@@%
    0x02, 0x12, 0x12, 0x12, 0x0a, 0x00, 0x00, 0x06, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x02,  //...................
    0xd0, 0xff, 0xff, 0xff, 0xfa, 0x40, 0x18, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@..@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x36, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@+.@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6a, 0x36, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@+.@@@@@@@@@@@@
    0xc2, 0xff, 0xff, 0xff, 0xf2, 0x38, 0x14, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@..@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f00c () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xa8, 0x16, 0x00,  //.............+%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xd4, 0x14,  //............+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xa0,  //...........+@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x54,  //..........+@@@@@+
    0x00, 0x2c, 0xd0, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00,  //..@%.....+@@@@@+.
    0x2a, 0xe8, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00, 0x00,  //.@@@%...+@@@@@+..
    0xa8, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x68, 0xfc, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00, 0x00, 0x00,  //%@@@@%.+@@@@@+...
    0x3a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xfc, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00, 0x00, 0x00, 0x00,  //.@@@@@%@@@@@+....
    0x00, 0x3e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@@+.....
    0x00, 0x00, 0x3c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@+......
    0x00, 0x00, 0x00, 0x3c, 0xf2, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xfc, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xc8, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f00d () , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x24, 0x88, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x74, 0x02, 0x00,  //..%......++..
    0x26, 0xe6, 0xff, 0xda, 0x1a, 0x00, 0x00, 0x00, 0x64, 0xfc, 0xff, 0xa2, 0x02,  //.@@@....+@@%.
    0xdc, 0xff, 0xff, 0xff, 0xda, 0x1a, 0x00, 0x64, 0xfc, 0xff, 0xff, 0xff, 0x74,  //@@@@@..+@@@@+
    0xb8, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x78, 0xfc, 0xff, 0xff, 0xff, 0xfc, 0x50,  //%@@@@@+@@@@@+
    0x0a, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x64, 0x00,  //.%@@@@@@@@@+.
    0x00, 0x0a, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x64, 0x00, 0x00,  //..%@@@@@@@+..
    0x00, 0x00, 0x0a, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00,  //...@@@@@@+...
    0x00, 0x00, 0x62, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x1c, 0x00, 0x00,  //..+@@@@@@@...
    0x00, 0x62, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x1a, 0x00,  //.+@@@@@@@@@..
    0x60, 0xfc, 0xff, 0xff, 0xff, 0xfc, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xda, 0x18,  //+@@@@@@@@@@@.
    0xf0, 0xff, 0xff, 0xff, 0xfc, 0x62, 0x0a, 0xbe, 0xff, 0xff, 0xff, 0xff, 0x88,  //@@@@@+.%@@@@%
    0x74, 0xff, 0xff, 0xfc, 0x62, 0x00, 0x00, 0x0a, 0xbe, 0xff, 0xff, 0xe6, 0x24,  //+@@@+...%@@@.
    0x00, 0x74, 0xf0, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xb8, 0xdc, 0x26, 0x00,  //.+@+.....%@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+f011 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x72, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x18, 0xc8, 0xf2, 0x3c, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x5c, 0xf8, 0xac, 0x08, 0x00, 0x00,  //...@@..@@@.+@%...
    0x00, 0x18, 0xdc, 0xff, 0xff, 0x7a, 0x00, 0xff, 0xff, 0xd6, 0x00, 0xa6, 0xff, 0xff, 0xc2, 0x04, 0x00,  //..@@@+.@@@.%@@@..
    0x00, 0xb2, 0xff, 0xff, 0xce, 0x10, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x26, 0xe4, 0xff, 0xff, 0x86, 0x00,  //.%@@@..@@@..@@@%.
    0x42, 0xff, 0xff, 0xe0, 0x0e, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x26, 0xf4, 0xff, 0xfa, 0x1a,  //+@@@...@@@...@@@.
    0xa2, 0xff, 0xff, 0x58, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0x78,  //%@@+...@@@...%@@+
    0xda, 0xff, 0xf8, 0x06, 0x00, 0x00, 0x00, 0xfa, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xb0,  //@@@....@@@....@@%
    0xf4, 0xff, 0xde, 0x00, 0x00, 0x00, 0x00, 0x90, 0xf2, 0x6c, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xcc,  //@@@....%@+....@@@
    0xea, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xc2,  //@@@...........@@@
    0xc4, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0x9a,  //@@@..........+@@%
    0x72, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xce, 0xff, 0xff, 0x4a,  //+@@%.........@@@+
    0x0e, 0xea, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x98, 0xff, 0xff, 0xd0, 0x00,  //.@@@+.......%@@@.
    0x00, 0x5c, 0xff, 0xff, 0xff, 0xaa, 0x30, 0x00, 0x00, 0x02, 0x42, 0xc2, 0xff, 0xff, 0xf8, 0x3a, 0x00,  //.+@@@%....+@@@@..
    0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xee, 0xdc, 0xf2, 0xff, 0xff, 0xff, 0xfa, 0x5a, 0x00, 0x00,  //..+@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x58, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x3e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x0c, 0x6e, 0xbe, 0xe8, 0xf8, 0xe4, 0xb2, 0x5e, 0x04, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f013 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@%.......
    0x00, 0x00, 0x04, 0x70, 0x12, 0x00, 0x9c, 0xff, 0xff, 0xe0, 0x00, 0x02, 0x6c, 0x18, 0x00, 0x00, 0x00,  //...+..%@@@..+....
    0x00, 0x04, 0xb4, 0xff, 0xe0, 0x78, 0xe6, 0xff, 0xff, 0xfc, 0x86, 0xbe, 0xff, 0xda, 0x1a, 0x00, 0x00,  //..%@@+@@@@%%@@...
    0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00,  //.+@@@@@@@@@@@@%..
    0x00, 0x0e, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x34, 0x00, 0x00,  //..@@@@@@@@@@@@...
    0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xec, 0x8c, 0x7e, 0xd2, 0xff, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00,  //..+@@@@%+@@@@%...
    0x6a, 0x98, 0xe6, 0xff, 0xff, 0xee, 0x1e, 0x00, 0x00, 0x04, 0xbe, 0xff, 0xff, 0xfc, 0x9c, 0x74, 0x10,  //+%@@@@....%@@@%+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%....+@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@+.....@@@@@+
    0xb6, 0xe2, 0xfc, 0xff, 0xff, 0xca, 0x02, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xff, 0xf8, 0xd6, 0x2c,  //%@@@@@....%@@@@@.
    0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xae, 0x32, 0x24, 0x7e, 0xfa, 0xff, 0xff, 0xd8, 0x02, 0x00, 0x00,  //..%@@@%..+@@@@...
    0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x12, 0x00, 0x00,  //..%@@@@@@@@@@@...
    0x00, 0x58, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00,  //.+@@@@@@@@@@@@%..
    0x00, 0x1e, 0xe4, 0xff, 0xff, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xde, 0xf0, 0xff, 0xfc, 0x5a, 0x00, 0x00,  //..@@@@@@@@@@@@+..
    0x00, 0x00, 0x22, 0xc8, 0x52, 0x00, 0xa8, 0xff, 0xff, 0xf2, 0x02, 0x26, 0xc4, 0x5a, 0x00, 0x00, 0x00,  //...@+.%@@@..@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x5a, 0x5a, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......++........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f014 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x4a, 0xec, 0xff, 0xff, 0xff, 0xe6, 0x3a, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0xda, 0xae, 0x56, 0x56, 0x56, 0xbe, 0xc4, 0x00, 0x00, 0x00, 0x00,  //....@%+++%@....
    0x2e, 0x36, 0x36, 0x64, 0xff, 0x64, 0x36, 0x36, 0x36, 0x78, 0xff, 0x52, 0x36, 0x36, 0x2a,  //...+@+...+@+...
    0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,  //@@@@@@@@@@@@@@@
    0x1c, 0xae, 0xc0, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xd2, 0x9e, 0x18,  //.%%.........@%.
    0x00, 0xa2, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0x8e, 0x00,  //.%%.........@%.
    0x00, 0xa2, 0xb6, 0x00, 0xb4, 0x4c, 0x22, 0xc6, 0x14, 0x5e, 0xa2, 0x00, 0xca, 0x8e, 0x00,  //.%%.%+.@.+%.@%.
    0x00, 0xa2, 0xb6, 0x00, 0xee, 0x6a, 0x36, 0xff, 0x22, 0x82, 0xd6, 0x00, 0xca, 0x8e, 0x00,  //.%%.@+.@.%@.@%.
    0x00, 0xa2, 0xb6, 0x00, 0xee, 0x6a, 0x36, 0xff, 0x22, 0x82, 0xd6, 0x00, 0xca, 0x8e, 0x00,  //.%%.@+.@.%@.@%.
    0x00, 0xa2, 0xb6, 0x00, 0xee, 0x6a, 0x36, 0xff, 0x22, 0x82, 0xd6, 0x00, 0xca, 0x8e, 0x00,  //.%%.@+.@.%@.@%.
    0x00, 0xa2, 0xb6, 0x00, 0xee, 0x6a, 0x36, 0xff, 0x22, 0x82, 0xd6, 0x00, 0xca, 0x8e, 0x00,  //.%%.@+.@.%@.@%.
    0x00, 0xa2, 0xb6, 0x00, 0xee, 0x6a, 0x36, 0xff, 0x22, 0x82, 0xd6, 0x00, 0xca, 0x8e, 0x00,  //.%%.@+.@.%@.@%.
    0x00, 0xa2, 0xb6, 0x00, 0xe6, 0x62, 0x2e, 0xfc, 0x1c, 0x7a, 0xce, 0x00, 0xca, 0x8e, 0x00,  //.%%.@+.@.+@.@%.
    0x00, 0xa2, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0x8e, 0x00,  //.%%.........@%.
    0x00, 0x96, 0xcc, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0xe0, 0x80, 0x00,  //.%@.........@+.
    0x00, 0x3e, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x2c, 0x00,  //..@@@@@@@@@@@..
    0x00, 0x00, 0x2c, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x24, 0x00, 0x00,  //...+++++++++...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f015 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x74, 0x70, 0x00, 0x00, 0x60, 0x92, 0x8a, 0x00, 0x00, 0x00,  //........++..+%%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xba, 0xff, 0xff, 0xae, 0x08, 0xb6, 0xff, 0xff, 0x00, 0x00, 0x00,  //.......%@@%.%@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xd8, 0xff, 0x9c, 0x9e, 0xff, 0xca, 0xca, 0xff, 0xff, 0x00, 0x00, 0x00,  //......@@%%@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x44, 0xee, 0xfc, 0x72, 0x6e, 0x6e, 0x78, 0xfc, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....+@@++++@@@@...
    0x00, 0x00, 0x00, 0x6c, 0xfa, 0xf0, 0x50, 0x98, 0xff, 0xff, 0x98, 0x56, 0xf4, 0xff, 0xff, 0x00, 0x00, 0x00,  //...+@@+%@@%+@@@...
    0x00, 0x04, 0x96, 0xff, 0xde, 0x3c, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x44, 0xe4, 0xff, 0x7c, 0x00, 0x00,  //..%@@.%@@@@%+@@+..
    0x10, 0xbc, 0xff, 0xc2, 0x3a, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x42, 0xce, 0xff, 0xa8, 0x08,  //.%@@.@@@@@@@@+@@%.
    0x62, 0xff, 0x9e, 0x48, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x4e, 0xb0, 0xff, 0x46,  //+@%+@@@@@@@@@@+%@+
    0x00, 0x42, 0x00, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x40, 0x00,  //.+.@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xea, 0xea, 0xfa, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@@%..%@@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@@%..%@@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@@%..%@@@@...
    0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00,  //...@@@@%..%@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f019 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xa6, 0xb2, 0xb2, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%%%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x12, 0x46, 0x46, 0x6e, 0xff, 0xff, 0xff, 0xe4, 0x46, 0x46, 0x40, 0x00, 0x00, 0x00, 0x00,  //....+++@@@@++.....
    0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x0c, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@+....
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xcc, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xd0, 0xff, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@%.......
    0x94, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x3c, 0x14, 0xc6, 0x86, 0x00, 0x8a, 0xd6, 0xd6, 0xd6, 0xd6, 0xc8, 0x1c,  //%@@@@@..@%.%@@@@@.
    0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x1e, 0x00, 0x00, 0x68, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x58,  //@@@@@@@...+@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x76, 0x96, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a,  //@@@@@@@@+%@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x80, 0xff, 0x36, 0xff, 0x5a,  //@@@@@@@@@@@@++@.@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa8, 0xbc, 0xff, 0x94, 0xff, 0x5a,  //@@@@@@@@@@@@%%@%@+
    0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x28,  //%@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f01c () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x20, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x56, 0x00, 0x00, 0x00,  //...@@@@@@@@@@+...
    0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00,  //..%@@@@@@@@@@@...
    0x00, 0x0a, 0xf0, 0xff, 0x3a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0e, 0xe8, 0xff, 0x44, 0x00, 0x00,  //..@@........@@+..
    0x00, 0x68, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xae, 0x00, 0x00,  //.+@@........%@%..
    0x00, 0xd2, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xfa, 0x1c, 0x00,  //.@@+.........@@..
    0x3c, 0xff, 0xf4, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0x84, 0x00,  //.@@..........%@%.
    0xa4, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xe8, 0x04,  //%@%..........+@@.
    0xee, 0xff, 0x52, 0x1a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1a, 0x1a, 0x22, 0xf2, 0xff, 0x36,  //@@+...........@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@%....+@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x44, 0x12, 0x12, 0x18, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@+...@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x2c,  //@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f021 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x08, 0x5c, 0x9c, 0xba, 0xba, 0x9c, 0x56, 0x08, 0x00, 0x00, 0x00, 0x06, 0x00,  //.....+%%%%+......
    0x00, 0x00, 0x00, 0x56, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x5e, 0x00, 0x74, 0xf4, 0x0e,  //...+@@@@@@@@+.+@.
    0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xc2, 0xff, 0xff, 0x1a,  //..%@@@@@@@@@@@@@.
    0x00, 0x62, 0xff, 0xff, 0xfc, 0x98, 0x2c, 0x00, 0x00, 0x24, 0x8c, 0xfa, 0xff, 0xff, 0xff, 0xff, 0x1a,  //.+@@@%....%@@@@@.
    0x10, 0xf0, 0xff, 0xfc, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xff, 0x1a,  //.@@@+......%@@@@.
    0x76, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1a,  //+@@%......+@@@@@.
    0xb8, 0xff, 0xf0, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xea, 0x0a,  //%@@.......@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x66, 0x86, 0x86, 0x86, 0x86, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x86, 0x68, 0x00,  //+%%%%+.......+%+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xff, 0xa0, 0x00,  //@@@@@@.......@@%.
    0xff, 0xff, 0xff, 0xff, 0xc8, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xdc, 0xff, 0xff, 0x3a, 0x00,  //@@@@@.......@@@..
    0xff, 0xff, 0xff, 0xff, 0xf4, 0x7c, 0x16, 0x00, 0x00, 0x0c, 0x66, 0xea, 0xff, 0xff, 0xa8, 0x00, 0x00,  //@@@@@+....+@@@%..
    0xff, 0xff, 0xda, 0xff, 0xff, 0xff, 0xfc, 0xe2, 0xe2, 0xfc, 0xff, 0xff, 0xff, 0xcc, 0x0c, 0x00, 0x00,  //@@@@@@@@@@@@@@...
    0xf6, 0xae, 0x02, 0x74, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa6, 0x0c, 0x00, 0x00, 0x00,  //@%.+@@@@@@@@%....
    0x26, 0x04, 0x00, 0x00, 0x1c, 0x86, 0xd0, 0xf2, 0xf4, 0xda, 0x9c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f026 () , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xe2, 0x10,  //......+@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0x22,  //.....+@@.
    0x00, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0xff, 0x22,  //....+@@@.
    0x28, 0x42, 0x42, 0x68, 0xfa, 0xff, 0xff, 0xff, 0x22,  //.+++@@@@.
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22,  //@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22,  //@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22,  //@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22,  //@@@@@@@@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22,  //@@@@@@@@.
    0x12, 0x26, 0x26, 0x4c, 0xf2, 0xff, 0xff, 0xff, 0x22,  //...+@@@@.
    0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0x22,  //.....@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0x22,  //......@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xc6, 0x0c,  //.......@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f027 () , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xe2, 0x10, 0x00, 0x00, 0x00, 0x00,  //......+@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00,  //.....+@@.....
    0x00, 0x00, 0x00, 0x00, 0x52, 0xfa, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00,  //....+@@@.....
    0x28, 0x42, 0x42, 0x68, 0xfa, 0xff, 0xff, 0xff, 0x22, 0x00, 0x06, 0x00, 0x00,  //.+++@@@@.....
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x42, 0xf4, 0x5a, 0x00,  //@@@@@@@@.+@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x02, 0x98, 0xf2, 0x0c,  //@@@@@@@@..%@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x30, 0xff, 0x2c,  //@@@@@@@@...@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x0a, 0xb0, 0xea, 0x08,  //@@@@@@@@..%@.
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x3a, 0xde, 0x42, 0x00,  //@@@@@@@@..@+.
    0x12, 0x26, 0x26, 0x4c, 0xf2, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00,  //...+@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf2, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00,  //......@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xc6, 0x0c, 0x00, 0x00, 0x00, 0x00,  //.......@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+f028 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf4, 0x8c, 0x06, 0x00, 0x00, 0x00,  //............@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xde, 0x0e, 0x00, 0x00, 0x00, 0x68, 0xf0, 0xca, 0x0e, 0x00, 0x00,  //......+@....+@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xf8, 0xff, 0x22, 0x00, 0x16, 0x80, 0x16, 0x2a, 0xe8, 0xb6, 0x00, 0x00,  //.....+@@...+..@%..
    0x00, 0x00, 0x00, 0x00, 0x50, 0xf8, 0xff, 0xff, 0x22, 0x00, 0x26, 0xe2, 0xf0, 0x3e, 0x3e, 0xff, 0x58, 0x00,  //....+@@@...@@..@+.
    0x24, 0x3e, 0x3e, 0x64, 0xf8, 0xff, 0xff, 0xff, 0x22, 0x00, 0x04, 0x08, 0xae, 0xee, 0x1c, 0xac, 0xcc, 0x00,  //...+@@@@....%@.%@.
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x84, 0xea, 0x48, 0x08, 0xde, 0x92, 0x4e, 0xff, 0x1c,  //@@@@@@@@.%@+.@%+@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x12, 0xac, 0xec, 0x0a, 0x7e, 0xda, 0x1a, 0xff, 0x48,  //@@@@@@@@..%@.+@.@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x34, 0xff, 0x2c, 0x5e, 0xf4, 0x06, 0xff, 0x56,  //@@@@@@@@...@.+@.@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x1c, 0xba, 0xe6, 0x06, 0x82, 0xd6, 0x1c, 0xff, 0x46,  //@@@@@@@@..%@.%@.@+
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x7a, 0xda, 0x38, 0x0e, 0xe4, 0x88, 0x52, 0xff, 0x18,  //@@@@@@@@.+@..@%+@.
    0x16, 0x2a, 0x2a, 0x50, 0xf4, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x12, 0xbe, 0xe6, 0x16, 0xb2, 0xc6, 0x00,  //...+@@@@....%@.%@.
    0x00, 0x00, 0x00, 0x00, 0x40, 0xf4, 0xff, 0xff, 0x22, 0x00, 0x2c, 0xf0, 0xe4, 0x30, 0x48, 0xff, 0x50, 0x00,  //.....@@@...@@.+@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf4, 0xff, 0x22, 0x00, 0x10, 0x6a, 0x0a, 0x36, 0xee, 0xac, 0x00, 0x00,  //......@@...+..@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xca, 0x0c, 0x00, 0x00, 0x02, 0x7a, 0xf6, 0xbc, 0x08, 0x00, 0x00,  //.......@....+@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xe8, 0x7c, 0x02, 0x00, 0x00, 0x00,  //............@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f03e () , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x6a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xb4, 0x06,  //+@@@@@@@@@@@@@@@@@@%.
    0xf2, 0x9c, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x60, 0xff, 0x4e,  //@%+++++++++++++++++@+
    0xff, 0x5a, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x5a,  //@+.................@+
    0xff, 0x5a, 0x00, 0x60, 0xf4, 0xf0, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x5a,  //@+.+@@+............@+
    0xff, 0x5a, 0x02, 0xf2, 0xff, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x5a,  //@+.@@@@............@+
    0xff, 0x5a, 0x00, 0xee, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xf4, 0x3c, 0x00, 0x00, 0x00, 0x00, 0xff, 0x5a,  //@+.@@@@.....%@.....@+
    0xff, 0x5a, 0x00, 0x50, 0xe6, 0xe0, 0x44, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xf2, 0x3a, 0x00, 0x00, 0x00, 0xff, 0x5a,  //@+.+@@+....+@@@....@+
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x36, 0x00, 0x00, 0xff, 0x5a,  //@+........+@@@@@...@+
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x0a, 0x5a, 0x00, 0x00, 0x78, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x34, 0x00, 0xff, 0x5a,  //@+....+..+@@@@@@@..@+
    0xff, 0x5a, 0x00, 0x00, 0x0a, 0xc2, 0xff, 0x72, 0x74, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0xff, 0x5a,  //@+...@@++@@@@@@@@%.@+
    0xff, 0x5a, 0x00, 0x0a, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0xff, 0x5a,  //@+..@@@@@@@@@@@@@%.@+
    0xff, 0x5a, 0x02, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0xff, 0x5a,  //@+.@@@@@@@@@@@@@@%.@+
    0xff, 0x5a, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0xff, 0x5a,  //@+.@@@@@@@@@@@@@@%.@+
    0xff, 0x5a, 0x0a, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x84, 0x00, 0xff, 0x5a,  //@+.@@@@@@@@@@@@@@%.@+
    0xfa, 0x64, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0a, 0xff, 0x56,  //@+.................@+
    0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x1c,  //%@@@@@@@@@@@@@@@@@@@.
    0x04, 0x4a, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x54, 0x1a, 0x00,  //.++++++++++++++++++..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+f040 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xa0, 0x1a, 0x00, 0x00, 0x00,  //...........+%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xdc, 0x1e, 0x00, 0x00,  //..........%@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xde, 0x20, 0x00,  //..........@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0x3e, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x00,  //........%.+@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xf0, 0x3e, 0x6a, 0xff, 0xff, 0xff, 0xee, 0x02,  //.......%@@.+@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0x86, 0xd6, 0xf4, 0x3e, 0x6a, 0xff, 0xf4, 0x42, 0x00,  //......%@%@@.+@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0x86, 0xca, 0xff, 0xff, 0xf4, 0x40, 0x68, 0x44, 0x00, 0x00,  //.....%@%@@@@.++..
    0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0x86, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xec, 0x0c, 0x00, 0x00, 0x00,  //....%@%@@@@@@....
    0x00, 0x00, 0x00, 0x92, 0xff, 0x86, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x46, 0x00, 0x00, 0x00, 0x00,  //...%@%@@@@@@+....
    0x00, 0x00, 0x92, 0xff, 0x86, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@%@@@@@@+.....
    0x00, 0x92, 0xff, 0x8c, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@%@@@@@@+......
    0x92, 0xfa, 0xc6, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@+.......
    0xff, 0x78, 0x02, 0xac, 0xff, 0xff, 0xff, 0xf6, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+.%@@@@+........
    0xff, 0x98, 0x44, 0x04, 0xac, 0xff, 0xf6, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@%+.%@@+.........
    0xff, 0xff, 0xb8, 0x06, 0xa6, 0xf6, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@%.%@+..........
    0xff, 0xff, 0xff, 0xff, 0xf6, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@+...........
    0x56, 0x56, 0x56, 0x56, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //++++.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f048 () , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xda, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xc2,  //@@%.......@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xcc, 0xfa,  //@@@......@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x10, 0xcc, 0xff, 0xfa,  //@@@.....@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x10, 0xcc, 0xff, 0xff, 0xfa,  //@@@....@@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x10, 0xca, 0xff, 0xff, 0xff, 0xfa,  //@@@...@@@@@
    0xff, 0xff, 0xd6, 0x00, 0x0e, 0xca, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@..@@@@@@
    0xff, 0xff, 0xd6, 0x0e, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@.@@@@@@@
    0xff, 0xff, 0xe0, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@@@@@@@@@
    0xff, 0xff, 0xec, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@@@@@@@@@
    0xff, 0xff, 0xd6, 0x34, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@.@@@@@@@
    0xff, 0xff, 0xd6, 0x00, 0x34, 0xee, 0xff, 0xff, 0xff, 0xff, 0xfa,  //@@@..@@@@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x34, 0xee, 0xff, 0xff, 0xff, 0xfa,  //@@@...@@@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x34, 0xee, 0xff, 0xff, 0xfa,  //@@@....@@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x34, 0xee, 0xff, 0xfa,  //@@@.....@@@
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xee, 0xfa,  //@@@......@@
    0xf6, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xea,  //@@@.......@
    0x2a, 0x46, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c,  //.+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+f04b () , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xe0, 0x6c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+.............
    0xff, 0xff, 0xd8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+...........
    0xff, 0xff, 0xff, 0xff, 0xc2, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@..........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xa4, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x88, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@%......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x6c, 0x04, 0x00, 0x00, 0x00,  //@@@@@@@@@@+....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x4e, 0x00, 0x00,  //@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x32,  //@@@@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x96,  //@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x32, 0x00,  //@@@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x4e, 0x00, 0x00, 0x00,  //@@@@@@@@@@@+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x6a, 0x02, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x88, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@%.......
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xa4, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@%.........
    0xff, 0xff, 0xff, 0xc0, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%...........
    0xff, 0xd8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+............
    0x4c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f04c () , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0x00, 0x00, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc,  //@@@@@@%..%@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@..@@@@@@@
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //@@@@@@%..%@@@@@@
    0x2c, 0x46, 0x46, 0x46, 0x46, 0x46, 0x1c, 0x00, 0x00, 0x1c, 0x46, 0x46, 0x46, 0x46, 0x46, 0x2c,  //.+++++....+++++.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+f04d () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x2c,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e,  //@@@@@@@@@@@@@@@@.
    0x2c, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x3e, 0x00,  //.++++++++++++++..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f051 () , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xae, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xb0,  //%.......@@%
    0xff, 0xb0, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@%......@@@
    0xff, 0xff, 0xae, 0x04, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@%.....@@@
    0xff, 0xff, 0xff, 0xae, 0x04, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@%....@@@
    0xff, 0xff, 0xff, 0xff, 0xae, 0x04, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@@%...@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xae, 0x04, 0x00, 0xff, 0xff, 0xd6,  //@@@@@%..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x04, 0xff, 0xff, 0xd6,  //@@@@@@%.@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0xff, 0xff, 0xd6,  //@@@@@@@%@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0xff, 0xff, 0xd6,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x1c, 0xff, 0xff, 0xd6,  //@@@@@@@.@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x1c, 0x00, 0xff, 0xff, 0xd6,  //@@@@@@..@@@
    0xff, 0xff, 0xff, 0xff, 0xdc, 0x1c, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@@@...@@@
    0xff, 0xff, 0xff, 0xdc, 0x1c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@@....@@@
    0xff, 0xff, 0xdc, 0x1e, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@@.....@@@
    0xff, 0xde, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,  //@@......@@@
    0xde, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0xff, 0xcc,  //@.......@@@
    0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x46, 0x1e,  //.........+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+f052 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xca, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xd4, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x14, 0x00, 0x00, 0x00, 0x00,  //....%@@@@@@@.....
    0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x14, 0x00, 0x00, 0x00,  //...%@@@@@@@@@....
    0x00, 0x00, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x14, 0x00, 0x00,  //..%@@@@@@@@@@@...
    0x00, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x14, 0x00,  //.%@@@@@@@@@@@@@..
    0x98, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x12,  //%@@@@@@@@@@@@@@@.
    0x30, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x08,  //.................
    0x06, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00,  //.................
    0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x30,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x2c,  //@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f053 () , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xd2, 0x1a, 0x00,  //........%@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xda, 0x1a,  //.......%@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xff, 0xff, 0x82,  //......%@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x0c,  //.....%@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x0c, 0x00,  //....%@@@@@..
    0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x0c, 0x00, 0x00,  //...%@@@@@...
    0x00, 0x00, 0x98, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x0c, 0x00, 0x00, 0x00,  //..%@@@@@....
    0x00, 0x98, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x0c, 0x00, 0x00, 0x00, 0x00,  //.%@@@@@.....
    0x40, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@......
    0x02, 0xaa, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x06, 0x00, 0x00, 0x00, 0x00,  //.%@@@@%.....
    0x00, 0x02, 0xaa, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x06, 0x00, 0x00, 0x00,  //..%@@@@%....
    0x00, 0x00, 0x02, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x06, 0x00, 0x00,  //...%@@@@%...
    0x00, 0x00, 0x00, 0x02, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x06, 0x00,  //....%@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x02, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x06,  //.....%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xa8, 0xff, 0xff, 0xff, 0xff, 0x7e,  //......%@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xa8, 0xff, 0xff, 0xe4, 0x24,  //.......%@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xa4, 0xe0, 0x22, 0x00,  //........%@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+f054 () , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x64, 0xe4, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@........
    0x64, 0xfc, 0xff, 0xf2, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@.......
    0xec, 0xff, 0xff, 0xff, 0xf2, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@......
    0x46, 0xf6, 0xff, 0xff, 0xff, 0xf0, 0x3a, 0x00, 0x00, 0x00, 0x00,  //+@@@@@.....
    0x00, 0x46, 0xf6, 0xff, 0xff, 0xff, 0xf0, 0x38, 0x00, 0x00, 0x00,  //.+@@@@@....
    0x00, 0x00, 0x46, 0xf6, 0xff, 0xff, 0xff, 0xf0, 0x38, 0x00, 0x00,  //..+@@@@@...
    0x00, 0x00, 0x00, 0x46, 0xf6, 0xff, 0xff, 0xff, 0xf0, 0x38, 0x00,  //...+@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x46, 0xf6, 0xff, 0xff, 0xff, 0xf0, 0x38,  //....+@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xff, 0xd2,  //.....+@@@@@
    0x00, 0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xf6, 0x46,  //.....@@@@@+
    0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xf6, 0x46, 0x00,  //....@@@@@+.
    0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0xff, 0xf6, 0x46, 0x00, 0x00,  //...@@@@@+..
    0x00, 0x38, 0xf0, 0xff, 0xff, 0xff, 0xf6, 0x46, 0x00, 0x00, 0x00,  //..@@@@@+...
    0x38, 0xf0, 0xff, 0xff, 0xff, 0xf6, 0x46, 0x00, 0x00, 0x00, 0x00,  //.@@@@@+....
    0xea, 0xff, 0xff, 0xff, 0xf6, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@+.....
    0x74, 0xff, 0xff, 0xf6, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@+......
    0x00, 0x72, 0xf0, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@+.......
    0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+f067 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xe4, 0xea, 0xe2, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@+.....
    0x48, 0x7e, 0x7e, 0x7e, 0x7e, 0xc8, 0xff, 0xff, 0xff, 0xbe, 0x7e, 0x7e, 0x7e, 0x7e, 0x3e,  //+++++@@@@%++++.
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //@@@@@@@@@@@@@@@
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,  //@@@@@@@@@@@@@@@
    0x5a, 0x92, 0x92, 0x92, 0x92, 0xd0, 0xff, 0xff, 0xff, 0xc8, 0x92, 0x92, 0x92, 0x92, 0x4e,  //+%%%%@@@@@%%%%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xfa, 0xff, 0xf6, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f068 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x02, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00,  //...............
    0xd2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe,  //@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //@@@@@@@@@@@@@@@
    0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac,  //%@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f071 () , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x34, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xd4, 0xff, 0xff, 0xff, 0xd4, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xfa, 0x2a, 0x22, 0x2a, 0xfc, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@...@@%.....
    0x00, 0x00, 0x00, 0x00, 0x1c, 0xf4, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf4, 0x1a, 0x00, 0x00, 0x00, 0x00,  //.....@@@...@@@.....
    0x00, 0x00, 0x00, 0x00, 0xa0, 0xff, 0xff, 0xff, 0x0a, 0x00, 0x0a, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00,  //....%@@@...@@@%....
    0x00, 0x00, 0x00, 0x30, 0xfc, 0xff, 0xff, 0xff, 0x14, 0x00, 0x14, 0xff, 0xff, 0xff, 0xfc, 0x30, 0x00, 0x00, 0x00,  //....@@@@...@@@@....
    0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0xff, 0xff, 0x1e, 0x00, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00,  //...%@@@@...@@@@%...
    0x00, 0x00, 0x4c, 0xff, 0xff, 0xff, 0xff, 0xff, 0x76, 0x56, 0x76, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00,  //..+@@@@@+++@@@@@+..
    0x00, 0x02, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x02, 0x00,  //..@@@@@@@@@@@@@@@..
    0x00, 0x68, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x28, 0x00, 0x2a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x68, 0x00,  //.+@@@@@@...@@@@@@+.
    0x0c, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x22, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x0c,  //.@@@@@@@...@@@@@@@.
    0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0xd6, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x84,  //%@@@@@@@@@@@@@@@@@%
    0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec,  //@@@@@@@@@@@@@@@@@@@
    0x94, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x94,  //%@@@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f074 () , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xec, 0x2e, 0x00, 0x00,  //...............@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xea, 0x2a, 0x00,  //...............@@..
    0xcc, 0xd6, 0xd4, 0xbe, 0x78, 0x0e, 0x00, 0x00, 0x00, 0x16, 0x80, 0xbc, 0xd6, 0xd6, 0xda, 0xff, 0xff, 0xe8, 0x28,  //@@@%+.....+%@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x26, 0x00, 0x32, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@...@@@@@@@@@@
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x18, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x44,  //@@@@@@@.@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x2c, 0xc4, 0xff, 0x96, 0xa2, 0xff, 0xff, 0xbc, 0x26, 0x00, 0x00, 0x12, 0xff, 0xf8, 0x48, 0x00,  //....@@%%@@%....@@+.
    0x00, 0x00, 0x00, 0x00, 0x12, 0xe4, 0x46, 0xfc, 0xff, 0xe2, 0x0c, 0x00, 0x00, 0x00, 0x12, 0xf8, 0x4c, 0x00, 0x00,  //.....@+@@@.....@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x96, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00,  //......%@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2, 0xff, 0xea, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0x84, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00,  //.....+@@%..........
    0x00, 0x00, 0x00, 0x00, 0x14, 0xec, 0xff, 0xf6, 0x48, 0xdc, 0x08, 0x00, 0x00, 0x00, 0x12, 0xf8, 0x4a, 0x00, 0x00,  //.....@@@+@.....@+..
    0x00, 0x00, 0x00, 0x2a, 0xc6, 0xff, 0xff, 0x8c, 0xaa, 0xff, 0xb4, 0x22, 0x00, 0x00, 0x12, 0xff, 0xf6, 0x46, 0x00,  //....@@@%%@%....@@+.
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x12, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x44,  //@@@@@@@.@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x26, 0x00, 0x36, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@...@@@@@@@@@@
    0xca, 0xd2, 0xd0, 0xba, 0x78, 0x0e, 0x00, 0x00, 0x00, 0x16, 0x84, 0xbe, 0xd2, 0xd6, 0xd8, 0xff, 0xff, 0xe8, 0x2a,  //@@@%+.....%%@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xea, 0x2c, 0x00,  //...............@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xec, 0x2e, 0x00, 0x00,  //...............@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f077 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@+....
    0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00,  //...+@@@@@@@@@+...
    0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x30, 0xd6, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00,  //..+@@@@@.@@@@@+..
    0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x16, 0x00, 0x18, 0xd6, 0xff, 0xff, 0xff, 0xff, 0x7a, 0x00,  //.+@@@@@...@@@@@+.
    0x78, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x18, 0x00, 0x00, 0x00, 0x18, 0xd8, 0xff, 0xff, 0xff, 0xff, 0x78,  //+@@@@@.....@@@@@+
    0xea, 0xff, 0xff, 0xff, 0xd6, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xd8, 0xff, 0xff, 0xff, 0xe8,  //@@@@@.......@@@@@
    0x38, 0xf0, 0xff, 0xd8, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xd8, 0xff, 0xf0, 0x36,  //.@@@.........@@@.
    0x00, 0x36, 0xa8, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xa8, 0x34, 0x00,  //..%...........%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f078 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x20, 0x84, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x84, 0x20, 0x00,  //..%...........%..
    0x22, 0xe0, 0xff, 0xc0, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xc2, 0xff, 0xe0, 0x22,  //.@@%.........@@@.
    0xde, 0xff, 0xff, 0xff, 0xc0, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xc0, 0xff, 0xff, 0xff, 0xdc,  //@@@@%.......%@@@@
    0x98, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0a, 0x00, 0x00, 0x00, 0x0a, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x98,  //%@@@@%.....%@@@@%
    0x00, 0x9c, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0a, 0x00, 0x0a, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00,  //.%@@@@%...%@@@@%.
    0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x14, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00,  //..%@@@@%.%@@@@%..
    0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00,  //....%@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f079 () , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x52, 0xe0, 0x34, 0x00, 0xa6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00,  //...+@..%@@@@@@@@@@...
    0x00, 0x00, 0x30, 0xf4, 0xff, 0xe4, 0x18, 0x18, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@..@@@@@@@@@@...
    0x00, 0x16, 0xe2, 0xff, 0xff, 0xff, 0xc8, 0x06, 0x3e, 0xd4, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@@@..@@@@@@@@@...
    0x06, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@@@@@%.......@@@...
    0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00,  //%@@@@@@@+......@@@...
    0x42, 0x8e, 0x8e, 0xff, 0xff, 0xec, 0x8e, 0x8e, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00,  //+%%@@@%%.......@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x8a, 0x8a, 0xec, 0xff, 0xff, 0x8a, 0x8a, 0x40,  //...@@@.......%%@@@%%.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a,  //...@@@......+@@@@@@@%
    0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x06,  //...@@@.......%@@@@@@.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xf8, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd4, 0x40, 0x06, 0xc8, 0xff, 0xff, 0xff, 0xe2, 0x16, 0x00,  //...@@@@@@@@@..@@@@@..
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x1a, 0x18, 0xe2, 0xff, 0xf4, 0x30, 0x00, 0x00,  //...@@@@@@@@@@..@@@...
    0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0x32, 0xe8, 0x52, 0x00, 0x00, 0x00,  //...@@@@@@@@@@%..@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+f07b () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x1a, 0xb0, 0xe6, 0xea, 0xea, 0xe8, 0xbe, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@%...........
    0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@..........
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4c, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x28, 0x00, 0x00,  //@@@@@@@@+.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x0e,  //@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e,  //@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2,  //@@@@@@@@@@@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2,  //@@@@@@@@@@@@@@@@@%
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9e,  //@@@@@@@@@@@@@@@@@%
    0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x68,  //@@@@@@@@@@@@@@@@@+
    0x24, 0xc4, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x96, 0x02,  //.@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f093 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xec, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xec, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x30, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@@@@.....
    0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x1a, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x3a, 0x92, 0x92, 0xaa, 0xff, 0xff, 0xff, 0xee, 0x92, 0x92, 0x8c, 0x0e, 0x00, 0x00, 0x00,  //....%%%@@@@%%%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xf4, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@%.......
    0xc2, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x10, 0x00, 0x00, 0x00, 0x00, 0x42, 0xfc, 0xff, 0xff, 0xff, 0xf0, 0x2e,  //@@@@@@.....+@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0xbe, 0xba, 0xba, 0xc8, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a,  //@@@@@@@%%%@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xf8, 0xff, 0xf0, 0xff, 0x5a,  //@@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x64, 0x84, 0xff, 0x3c, 0xff, 0x5a,  //@@@@@@@@@@@@+%@.@+
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4c,  //@@@@@@@@@@@@@@@@@+
    0x2c, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x48, 0x00,  //.++++++++++++++++.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+f095 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x6c, 0xce, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@%...........
    0x4e, 0xff, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@...........
    0xc4, 0xff, 0xff, 0xff, 0xcc, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@..........
    0xf6, 0xff, 0xff, 0xff, 0xff, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@+.........
    0xe6, 0xff, 0xff, 0xff, 0xb8, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@%..........
    0x9e, 0xff, 0xff, 0xb6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%...........
    0x38, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@%...........
    0x00, 0xc2, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@+..........
    0x00, 0x3c, 0xfc, 0xff, 0xf0, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@..........
    0x00, 0x00, 0x80, 0xff, 0xff, 0xe0, 0x2a, 0x00, 0x00, 0x00, 0x0a, 0x52, 0x02, 0x00, 0x00,  //..+@@@.....+...
    0x00, 0x00, 0x00, 0xa0, 0xff, 0xff, 0xf0, 0x60, 0x00, 0x02, 0xb8, 0xff, 0xcc, 0x3c, 0x00,  //...%@@@+..%@@..
    0x00, 0x00, 0x00, 0x02, 0xa0, 0xff, 0xff, 0xff, 0xc0, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xa0,  //....%@@@%%@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce,  //.....+@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6c,  //.......@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x9e, 0xe6, 0xf6, 0xc4, 0x4e, 0x00,  //.........%@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f0c4 () , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x02, 0x6a, 0xba, 0xc8, 0x9e, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+%@%..............
    0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x30, 0x00,  //%@@@@@%............
    0xf6, 0xe0, 0x22, 0x0a, 0x44, 0xc8, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x9e, 0x98, 0x8c, 0xa8,  //@@..+@@%.......%%%%
    0xec, 0xd8, 0x02, 0x00, 0x00, 0x04, 0xd0, 0xf6, 0x04, 0x00, 0x00, 0x00, 0x12, 0x8c, 0xa4, 0x26, 0x00, 0x5c, 0x98,  //@@....@@.....%%..+%
    0x82, 0xff, 0xac, 0x1a, 0x00, 0x00, 0xb0, 0xff, 0x0a, 0x00, 0x08, 0x78, 0xae, 0x34, 0x00, 0x08, 0x94, 0x66, 0x00,  //%@%...%@...+%...%+.
    0x02, 0x9c, 0xff, 0xfa, 0xd2, 0xdc, 0xff, 0xce, 0xb0, 0x76, 0xb2, 0x46, 0x00, 0x00, 0x26, 0xac, 0x30, 0x00, 0x00,  //.%@@@@@@%+%+...%...
    0x00, 0x00, 0x3a, 0xa0, 0xca, 0xca, 0xae, 0x96, 0xbc, 0x5a, 0x0c, 0x00, 0x00, 0x56, 0x9e, 0x0c, 0x00, 0x00, 0x00,  //...%@@%%%+...+%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xd8, 0x54, 0xc8, 0x06, 0x92, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@+@.%%.....
    0x00, 0x00, 0x30, 0x9a, 0xc6, 0xc4, 0xa0, 0xa4, 0x1c, 0x56, 0x4c, 0xae, 0x34, 0x66, 0x9c, 0x0a, 0x00, 0x00, 0x00,  //...%@@%%.++%.+%....
    0x00, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0xbc, 0xa4, 0xf4, 0x48, 0x00, 0x00, 0x34, 0xb4, 0x24, 0x00, 0x00,  //.%@@@@@%%%@+...%...
    0x76, 0xff, 0xd6, 0x50, 0x0e, 0x18, 0xc8, 0xff, 0x18, 0x00, 0x20, 0xa4, 0xa4, 0x20, 0x00, 0x12, 0xac, 0x50, 0x00,  //+@@+..@@...%%...%+.
    0xe8, 0xe6, 0x0e, 0x00, 0x00, 0x00, 0xbc, 0xfc, 0x08, 0x00, 0x00, 0x00, 0x30, 0xb2, 0x8a, 0x0e, 0x02, 0x84, 0x86,  //@@....%@.....%%..%%
    0xfa, 0xd4, 0x06, 0x00, 0x1c, 0xa0, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xba, 0x70, 0x60, 0xc0,  //@@...%@%......+%++%
    0xac, 0xff, 0xf0, 0xe2, 0xfc, 0xff, 0xca, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x58, 0x02,  //%@@@@@@.........++.
    0x0c, 0x92, 0xe4, 0xf2, 0xc8, 0x66, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@+.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+f0c5 () , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x34, 0x46, 0x46, 0x46, 0x46, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......++++........
    0x00, 0x00, 0x00, 0x00, 0x22, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@.......
    0x00, 0x00, 0x00, 0x26, 0xe4, 0xff, 0xff, 0x12, 0x12, 0x12, 0x34, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@....@.......
    0x00, 0x00, 0x28, 0xe6, 0xde, 0x80, 0xff, 0x00, 0x00, 0x00, 0x22, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@+@....@.......
    0x00, 0x2a, 0xe8, 0xd4, 0x1a, 0x5a, 0xff, 0x00, 0x00, 0x00, 0x22, 0xff, 0x48, 0x48, 0x4e, 0x4e, 0x4e, 0x4e, 0x22,  //..@@.+@....@++++++.
    0x28, 0xea, 0xc6, 0x10, 0x00, 0x5a, 0xff, 0x00, 0x00, 0x00, 0x22, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //.@@..+@....@@@@@@@@
    0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x58, 0xff, 0xfc, 0x92, 0x00, 0x00, 0x00, 0x5a, 0xff,  //%@@@@@@...+@@%...+@
    0xfa, 0x94, 0x5a, 0x5a, 0x5a, 0x5a, 0x2a, 0x00, 0x00, 0x46, 0xf8, 0x9c, 0xc8, 0x92, 0x00, 0x00, 0x00, 0x5a, 0xff,  //@%++++...+@%@%...+@
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf6, 0x9e, 0x00, 0xc6, 0x92, 0x00, 0x00, 0x00, 0x5a, 0xff,  //@+.......@%.@%...+@
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xf2, 0xa0, 0x00, 0x00, 0xc6, 0x92, 0x00, 0x00, 0x00, 0x5a, 0xff,  //@+......@%..@%...+@
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x5a, 0xff,  //@+.....@@@@@@%...+@
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfa, 0x88, 0x5a, 0x5a, 0x5a, 0x56, 0x0a, 0x00, 0x00, 0x00, 0x5a, 0xff,  //@+.....@%++++....+@
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff,  //@+.....@+........+@
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff,  //@+.....@+........+@
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff,  //@@@@@@@@+........+@
    0x2c, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff,  //.++++++@+........+@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff,  //.......@+........+@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff,  //.......@+........+@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x88, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x94, 0xff,  //.......@%++++++++%@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //.......%@@@@@@@@@@%


    /*Unicode: U+f0c7 () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x4e, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@+....
    0xff, 0x92, 0x60, 0xff, 0xff, 0xff, 0xff, 0x5e, 0x56, 0x9c, 0xff, 0x8e, 0xfc, 0x5e, 0x00, 0x00, 0x00,  //@%+@@@@++%@%@+...
    0xff, 0x5a, 0x0e, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x5a, 0xff, 0x00, 0x76, 0xfc, 0x5c, 0x00, 0x00,  //@+.@@@@..+@.+@+..
    0xff, 0x5a, 0x0e, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x5a, 0xff, 0x00, 0x00, 0x7e, 0xfc, 0x58, 0x00,  //@+.@@@@..+@..+@+.
    0xff, 0x5a, 0x0e, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x5a, 0xff, 0x00, 0x00, 0x00, 0x8c, 0xf0, 0x0e,  //@+.@@@@..+@...%@.
    0xff, 0x5a, 0x0e, 0xff, 0xff, 0xff, 0xff, 0x62, 0x5a, 0x9e, 0xff, 0x00, 0x00, 0x00, 0x18, 0xff, 0x40,  //@+.@@@@++%@....@.
    0xff, 0x5a, 0x00, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00, 0x12, 0xff, 0x46,  //@+.@@@@@@@%....@+
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0x46,  //@+.............@+
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0x46,  //@+.............@+
    0xff, 0x5a, 0x00, 0x30, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x48, 0x00, 0x12, 0xff, 0x46,  //@+..+++++++++..@+
    0xff, 0x5a, 0x06, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4c, 0x12, 0xff, 0x46,  //@+.@@@@@@@@@@+.@+
    0xff, 0x5a, 0x0e, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x5a, 0x12, 0xff, 0x46,  //@+.@+.......@+.@+
    0xff, 0x5a, 0x0e, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x5a, 0x12, 0xff, 0x46,  //@+.@+.......@+.@+
    0xff, 0x5a, 0x0e, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x5a, 0x12, 0xff, 0x46,  //@+.@+.......@+.@+
    0xff, 0x5c, 0x12, 0xff, 0x4c, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xff, 0x5c, 0x16, 0xff, 0x46,  //@+.@+.......@+.@+
    0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x36,  //@@@@@@@@@@@@@@@@.
    0x28, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x42, 0x00,  //.+++++++++++++++.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+f0e7 () , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00,  //..@@@@+...
    0x00, 0x24, 0xff, 0xff, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00,  //..@@@@....
    0x00, 0x62, 0xff, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00,  //.+@@@@....
    0x00, 0xa0, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00,  //.%@@@+....
    0x00, 0xde, 0xff, 0xff, 0xfa, 0x18, 0x00, 0x26, 0x64, 0x30,  //.@@@@...+.
    0x1c, 0xff, 0xff, 0xff, 0xe6, 0xa6, 0xe4, 0xff, 0xff, 0x42,  //.@@@@%@@@+
    0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x00,  //+@@@@@@@@.
    0x98, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x54, 0x00,  //%@@@@@@@+.
    0xd6, 0xff, 0xff, 0xe0, 0xb2, 0xff, 0xff, 0xda, 0x00, 0x00,  //@@@@%@@@..
    0x84, 0x5e, 0x1e, 0x00, 0x54, 0xff, 0xff, 0x66, 0x00, 0x00,  //%+..+@@+..
    0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xe6, 0x06, 0x00, 0x00,  //....%@@...
    0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0x76, 0x00, 0x00, 0x00,  //....@@+...
    0x00, 0x00, 0x00, 0x0e, 0xfc, 0xf0, 0x0e, 0x00, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x00, 0x4c, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00,  //...+@%....
    0x00, 0x00, 0x00, 0x8a, 0xf6, 0x18, 0x00, 0x00, 0x00, 0x00,  //...%@.....
    0x00, 0x00, 0x00, 0xc8, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@%.....
    0x00, 0x00, 0x0a, 0xf8, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@......
    0x00, 0x00, 0x10, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+......


    /*Unicode: U+f0f3 () , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xf2, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xa6, 0xff, 0xec, 0x86, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+%@@%.......
    0x00, 0x00, 0x00, 0x00, 0x10, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00,  //....%@@@@@@@@+....
    0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x04, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@....
    0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@+...
    0x00, 0x00, 0x02, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@%...
    0x00, 0x00, 0x3c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@...
    0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x44, 0x00, 0x00,  //..%@@@@@@@@@@@@+..
    0x00, 0x22, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00,  //..@@@@@@@@@@@@@%..
    0x02, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x68, 0x00,  //.%@@@@@@@@@@@@@@+.
    0xaa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x56,  //%@@@@@@@@@@@@@@@@+
    0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5c,  //%@@@@@@@@@@@@@@@@+
    0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0xd2, 0xa8, 0xff, 0xff, 0xff, 0x88, 0x22, 0x22, 0x22, 0x22, 0x14, 0x00,  //......@%@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xb2, 0xae, 0xff, 0xf6, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+%%@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0xc8, 0xb8, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@%........


    /*Unicode: U+f11c () , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x06, 0x32, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x16, 0x00,  //.....................
    0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x26,  //@@@@@@@@@@@@@@@@@@@@.
    0xff, 0x72, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xff, 0x5a,  //@+.................@+
    0xff, 0x5a, 0x00, 0x56, 0x20, 0x0a, 0x50, 0x00, 0x56, 0x1c, 0x08, 0x5a, 0x0e, 0x1a, 0x56, 0x00, 0x56, 0x1c, 0x00, 0xff, 0x5a,  //@+.+..+.+..+..+.+..@+
    0xff, 0x5a, 0x00, 0xfa, 0x66, 0x22, 0xe6, 0x00, 0xfa, 0x56, 0x1e, 0xff, 0x32, 0x52, 0xfa, 0x00, 0xff, 0x5a, 0x00, 0xff, 0x5a,  //@+.@+.@.@+.@.+@.@+.@+
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x5a, 0x00, 0xff, 0x5a,  //@+..............@+.@+
    0xff, 0x5a, 0x00, 0xfa, 0xff, 0xd2, 0x10, 0xfa, 0x00, 0x9e, 0xd6, 0x00, 0xc2, 0xa2, 0x56, 0xff, 0xff, 0x5a, 0x00, 0xff, 0x5a,  //@+.@@@.@.%@.@%+@@+.@+
    0xff, 0x5a, 0x00, 0x56, 0x5a, 0x48, 0x02, 0x56, 0x00, 0x34, 0x48, 0x00, 0x42, 0x36, 0x1c, 0x5a, 0x5a, 0x1c, 0x00, 0xff, 0x5a,  //@+.+++.+..+.+..++..@+
    0xff, 0x5a, 0x00, 0x10, 0x04, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x00, 0x10, 0x02, 0x00, 0xff, 0x5a,  //@+.................@+
    0xff, 0x5a, 0x00, 0xfc, 0x68, 0x24, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0xfc, 0x58, 0x00, 0xff, 0x5a,  //@+.@+.@@@@@@@@@.@+.@+
    0xff, 0x5a, 0x00, 0x42, 0x18, 0x06, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x42, 0x00, 0x42, 0x14, 0x00, 0xff, 0x5a,  //@+.+..+++++++++.+..@+
    0xfa, 0x94, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0xff, 0x56,  //@%+++++++++++++++++@+
    0x98, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x16,  //%@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+f124 () , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x66,  //.............++
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xc6, 0xff, 0xc8,  //...........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xc6, 0xff, 0xff, 0xff, 0x50,  //.........+@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xce, 0x00,  //.......+@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4e, 0x00,  //.....+@@@@@@@+.
    0x00, 0x00, 0x00, 0x46, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x00, 0x00,  //...+@@@@@@@@@..
    0x00, 0x46, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x00,  //.+@@@@@@@@@@+..
    0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00,  //%@@@@@@@@@@@...
    0x72, 0x92, 0x92, 0x92, 0x92, 0x92, 0xaa, 0xff, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00,  //+%%%%%%@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00,  //.......@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00,  //.......@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+f15b () , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x10, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@@+.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x22, 0xe0, 0x20, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@+.@.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x22, 0xff, 0xe0, 0x20, 0x00, 0x00, 0x00,  //@@@@@@@@@+.@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x22, 0xff, 0xff, 0xe0, 0x20, 0x00, 0x00,  //@@@@@@@@@+.@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x22, 0xff, 0xff, 0xff, 0xe0, 0x20, 0x00,  //@@@@@@@@@+.@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0e, 0x6a, 0x6a, 0x6a, 0x6a, 0x48, 0x00,  //@@@@@@@@@+.+++++.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x3e, 0x36, 0x36, 0x36, 0x36, 0x36, 0x0e,  //@@@@@@@@@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46,  //@@@@@@@@@@@@@@@@+
    0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x1e,  //@@@@@@@@@@@@@@@@.


    /*Unicode: U+f1eb () , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x64, 0xa6, 0xd2, 0xf0, 0xfa, 0xf2, 0xda, 0xae, 0x70, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+%@@@@@%+......
    0x00, 0x00, 0x00, 0x1e, 0x9e, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x30, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@%....
    0x00, 0x02, 0x8a, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xdc, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xa6, 0x0e, 0x00,  //..%@@@@@@@@@@@@@@@%..
    0x10, 0xbc, 0xff, 0xff, 0xff, 0xf2, 0x96, 0x48, 0x0a, 0x00, 0x00, 0x00, 0x04, 0x3a, 0x88, 0xe4, 0xff, 0xff, 0xff, 0xd6, 0x22,  //.%@@@@%+......%@@@@@.
    0xaa, 0xff, 0xff, 0xfa, 0x8e, 0x14, 0x10, 0x56, 0x9c, 0xbc, 0xd0, 0xc0, 0xa4, 0x64, 0x1a, 0x08, 0x76, 0xf2, 0xff, 0xff, 0xd8,  //%@@@%..+%%@%%+..+@@@@
    0x20, 0xe2, 0xe6, 0x40, 0x12, 0x8a, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xa0, 0x22, 0x26, 0xd4, 0xf4, 0x3e,  //.@@..%@@@@@@@@@%..@@.
    0x00, 0x18, 0x16, 0x32, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x50, 0x0a, 0x26, 0x00,  //....@@@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xf8, 0xa6, 0x50, 0x20, 0x06, 0x12, 0x3a, 0x88, 0xf0, 0xff, 0xff, 0xe8, 0x06, 0x00, 0x00,  //...%@@@%+....%@@@@...
    0x00, 0x00, 0x00, 0x18, 0xd2, 0xa8, 0x1e, 0x14, 0x76, 0xb6, 0xd0, 0xbe, 0x84, 0x24, 0x10, 0x9c, 0xe6, 0x30, 0x00, 0x00, 0x00,  //....@%..+%@%%..%@....
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x5e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x84, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xe0, 0xa4, 0x32, 0x04, 0x24, 0x88, 0xea, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@%...%@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x4c, 0x84, 0x5c, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+%+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe8, 0xff, 0xf8, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xd8, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+f240 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x06, 0x4e, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x50, 0x0c, 0x00, 0x00,  //.+++++++++++++++++++++...
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0xfc, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0x10, 0x00,  //@+...................+@..
    0xff, 0x5a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x46, 0xff, 0x28, 0x00,  //@+.@@@@@@@@@@@@@@@@@%+@..
    0xff, 0x5a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x46, 0xff, 0xf8, 0x34,  //@+.@@@@@@@@@@@@@@@@@%+@@.
    0xff, 0x5a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x1a, 0x62, 0xf2, 0x6a,  //@+.@@@@@@@@@@@@@@@@@%.+@+
    0xff, 0x5a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x00, 0x00, 0xea, 0x6a,  //@+.@@@@@@@@@@@@@@@@@%..@+
    0xff, 0x5a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x00, 0x00, 0xea, 0x6a,  //@+.@@@@@@@@@@@@@@@@@%..@+
    0xff, 0x5a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x00, 0x00, 0xea, 0x6a,  //@+.@@@@@@@@@@@@@@@@@%..@+
    0xff, 0x5a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x34, 0xbe, 0xfa, 0x54,  //@+.@@@@@@@@@@@@@@@@@%.%@+
    0xff, 0x5a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x46, 0xff, 0x6e, 0x00,  //@+.@@@@@@@@@@@@@@@@@%+@+.
    0xff, 0x5a, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x16, 0x46, 0xff, 0x12, 0x00,  //@+...................+@..
    0xf2, 0x9e, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x90, 0xfa, 0x08, 0x00,  //@%+++++++++++++++++++%@..
    0x6c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x78, 0x00, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f241 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x06, 0x4e, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x50, 0x0c, 0x00, 0x00,  //.+++++++++++++++++++++...
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0xfc, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0x10, 0x00,  //@+...................+@..
    0xff, 0x5a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0x28, 0x00,  //@+.@@@@@@@@@@@@@%....+@..
    0xff, 0x5a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xf8, 0x34,  //@+.@@@@@@@@@@@@@%....+@@.
    0xff, 0x5a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x62, 0xf2, 0x6a,  //@+.@@@@@@@@@@@@@%.....+@+
    0xff, 0x5a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x6a,  //@+.@@@@@@@@@@@@@%......@+
    0xff, 0x5a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x6a,  //@+.@@@@@@@@@@@@@%......@+
    0xff, 0x5a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x6a,  //@+.@@@@@@@@@@@@@%......@+
    0xff, 0x5a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x34, 0xbe, 0xfa, 0x54,  //@+.@@@@@@@@@@@@@%.....%@+
    0xff, 0x5a, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0x6e, 0x00,  //@+.@@@@@@@@@@@@@%....+@+.
    0xff, 0x5a, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x12, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0x12, 0x00,  //@+...................+@..
    0xf2, 0x9e, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x90, 0xfa, 0x08, 0x00,  //@%+++++++++++++++++++%@..
    0x6c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x78, 0x00, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f242 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x06, 0x4e, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x50, 0x0c, 0x00, 0x00,  //.+++++++++++++++++++++...
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0xfc, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0x10, 0x00,  //@+...................+@..
    0xff, 0x5a, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0x28, 0x00,  //@++@@@@@@@@@.........+@..
    0xff, 0x5a, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xf8, 0x34,  //@++@@@@@@@@@.........+@@.
    0xff, 0x5a, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x62, 0xf2, 0x6a,  //@++@@@@@@@@@..........+@+
    0xff, 0x5a, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x6a,  //@++@@@@@@@@@...........@+
    0xff, 0x5a, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x6a,  //@++@@@@@@@@@...........@+
    0xff, 0x5a, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x6a,  //@++@@@@@@@@@...........@+
    0xff, 0x5a, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xbe, 0xfa, 0x54,  //@++@@@@@@@@@..........%@+
    0xff, 0x5a, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0x6e, 0x00,  //@++@@@@@@@@@.........+@+.
    0xff, 0x5a, 0x10, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0x12, 0x00,  //@+...................+@..
    0xf2, 0x9e, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x90, 0xfa, 0x08, 0x00,  //@%+++++++++++++++++++%@..
    0x6c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x78, 0x00, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f243 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x06, 0x4e, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x50, 0x0c, 0x00, 0x00,  //.+++++++++++++++++++++...
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0xfc, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0x10, 0x00,  //@+...................+@..
    0xff, 0x5a, 0x46, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0x28, 0x00,  //@++@@@@@.............+@..
    0xff, 0x5a, 0x46, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xf8, 0x34,  //@++@@@@@.............+@@.
    0xff, 0x5a, 0x46, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x62, 0xf2, 0x6a,  //@++@@@@@..............+@+
    0xff, 0x5a, 0x46, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x6a,  //@++@@@@@...............@+
    0xff, 0x5a, 0x46, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x6a,  //@++@@@@@...............@+
    0xff, 0x5a, 0x46, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x6a,  //@++@@@@@...............@+
    0xff, 0x5a, 0x46, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xbe, 0xfa, 0x54,  //@++@@@@@..............%@+
    0xff, 0x5a, 0x46, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0x6e, 0x00,  //@++@@@@@.............+@+.
    0xff, 0x5a, 0x08, 0x22, 0x22, 0x22, 0x22, 0x22, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0x12, 0x00,  //@+...................+@..
    0xf2, 0x9e, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x90, 0xfa, 0x08, 0x00,  //@%+++++++++++++++++++%@..
    0x6c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x78, 0x00, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f244 () , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x06, 0x4e, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x50, 0x0a, 0x00, 0x00,  //.+++++++++++++++++++++...
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x00, 0x00,  //%@@@@@@@@@@@@@@@@@@@@@@..
    0xfc, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0x10, 0x00,  //@+...................+@..
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0x12, 0x00,  //@+...................+@..
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xe0, 0x22,  //@+...................+@@.
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x62, 0xf2, 0x68,  //@+....................+@+
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x6a,  //@+.....................@+
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x6a,  //@+.....................@+
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x6a,  //@+.....................@+
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xbe, 0xfa, 0x62,  //@+....................%@+
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xac, 0x0e,  //@+...................+@%.
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0x12, 0x00,  //@+...................+@..
    0xf2, 0x9e, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x90, 0xfc, 0x0a, 0x00,  //@%+++++++++++++++++++%@..
    0x6c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x82, 0x00, 0x00,  //+@@@@@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+f293 () , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x42, 0xa8, 0xe0, 0xf8, 0xf8, 0xe0, 0xa8, 0x42, 0x00, 0x00, 0x00,  //...+%@@@@%+...
    0x00, 0x00, 0x94, 0xff, 0xff, 0xff, 0xc4, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00, 0x00,  //..%@@@@@@@@%..
    0x00, 0x78, 0xff, 0xff, 0xff, 0xff, 0x62, 0x6e, 0xff, 0xff, 0xff, 0xff, 0x74, 0x00,  //.+@@@@++@@@@+.
    0x0e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xf0, 0x0c,  //.@@@@@+.+@@@@.
    0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x0a, 0x00, 0x6e, 0xff, 0xff, 0xff, 0x5c,  //+@@@@@+..+@@@+
    0xa0, 0xff, 0xf8, 0x64, 0xd4, 0xff, 0x62, 0x3a, 0x92, 0x00, 0x6e, 0xff, 0xff, 0xa0,  //%@@+@@+.%.+@@%
    0xca, 0xff, 0xec, 0x2c, 0x14, 0xd4, 0x62, 0x38, 0xea, 0x1c, 0x16, 0xe6, 0xff, 0xca,  //@@@..@+.@..@@@
    0xe8, 0xff, 0xff, 0xea, 0x2c, 0x14, 0x3c, 0x28, 0x2e, 0x16, 0xd6, 0xff, 0xff, 0xea,  //@@@@......@@@@
    0xf4, 0xff, 0xff, 0xff, 0xea, 0x2c, 0x00, 0x00, 0x16, 0xd6, 0xff, 0xff, 0xff, 0xf8,  //@@@@@....@@@@@
    0xfc, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x00, 0x00, 0xae, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@..%@@@@@
    0xf4, 0xff, 0xff, 0xff, 0xea, 0x2c, 0x00, 0x00, 0x16, 0xd6, 0xff, 0xff, 0xff, 0xf8,  //@@@@@....@@@@@
    0xe8, 0xff, 0xff, 0xea, 0x2c, 0x14, 0x3c, 0x28, 0x2e, 0x16, 0xd6, 0xff, 0xff, 0xea,  //@@@@......@@@@
    0xca, 0xff, 0xec, 0x2c, 0x14, 0xd4, 0x62, 0x38, 0xea, 0x1c, 0x16, 0xe6, 0xff, 0xca,  //@@@..@+.@..@@@
    0xa0, 0xff, 0xf8, 0x64, 0xd4, 0xff, 0x62, 0x3a, 0x92, 0x00, 0x70, 0xff, 0xff, 0x9e,  //%@@+@@+.%.+@@%
    0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x0a, 0x00, 0x70, 0xff, 0xff, 0xff, 0x5c,  //+@@@@@+..+@@@+
    0x0c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00, 0x70, 0xff, 0xff, 0xff, 0xf0, 0x0c,  //.@@@@@+.+@@@@.
    0x00, 0x76, 0xff, 0xff, 0xff, 0xff, 0x62, 0x72, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00,  //.+@@@@++@@@@+.
    0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xc8, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00,  //..%@@@@@@@@%..
    0x00, 0x00, 0x00, 0x3e, 0xa8, 0xe0, 0xf8, 0xf8, 0xe0, 0xa8, 0x3e, 0x00, 0x00, 0x00,  //....%@@@@%....



#endif
};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t lv_font_symbol_20_glyph_dsc[] = {
#if USE_LV_FONT_SYMBOL_20 == 1
    {.w_px = 17,  .glyph_index = 0},  /*Unicode: U+f001 ()*/
    {.w_px = 21,  .glyph_index = 60}, /*Unicode: U+f008 ()*/
    {.w_px = 19,  .glyph_index = 120},    /*Unicode: U+f00b ()*/
    {.w_px = 17,  .glyph_index = 180},    /*Unicode: U+f00c ()*/
    {.w_px = 13,  .glyph_index = 240},    /*Unicode: U+f00d ()*/
    {.w_px = 17,  .glyph_index = 280},    /*Unicode: U+f011 ()*/
    {.w_px = 17,  .glyph_index = 340},    /*Unicode: U+f013 ()*/
    {.w_px = 15,  .glyph_index = 400},    /*Unicode: U+f014 ()*/
    {.w_px = 18,  .glyph_index = 440},    /*Unicode: U+f015 ()*/
    {.w_px = 18,  .glyph_index = 500},    /*Unicode: U+f019 ()*/
    {.w_px = 17,  .glyph_index = 560},    /*Unicode: U+f01c ()*/
    {.w_px = 17,  .glyph_index = 620},    /*Unicode: U+f021 ()*/
    {.w_px = 9,   .glyph_index = 680},    /*Unicode: U+f026 ()*/
    {.w_px = 13,  .glyph_index = 720},    /*Unicode: U+f027 ()*/
    {.w_px = 18,  .glyph_index = 760},    /*Unicode: U+f028 ()*/
    {.w_px = 21,  .glyph_index = 820},    /*Unicode: U+f03e ()*/
    {.w_px = 17,  .glyph_index = 880},    /*Unicode: U+f040 ()*/
    {.w_px = 11,  .glyph_index = 940},    /*Unicode: U+f048 ()*/
    {.w_px = 15,  .glyph_index = 980},    /*Unicode: U+f04b ()*/
    {.w_px = 16,  .glyph_index = 1020},   /*Unicode: U+f04c ()*/
    {.w_px = 17,  .glyph_index = 1060},   /*Unicode: U+f04d ()*/
    {.w_px = 11,  .glyph_index = 1120},   /*Unicode: U+f051 ()*/
    {.w_px = 17,  .glyph_index = 1160},   /*Unicode: U+f052 ()*/
    {.w_px = 12,  .glyph_index = 1220},   /*Unicode: U+f053 ()*/
    {.w_px = 11,  .glyph_index = 1260},   /*Unicode: U+f054 ()*/
    {.w_px = 15,  .glyph_index = 1300},   /*Unicode: U+f067 ()*/
    {.w_px = 15,  .glyph_index = 1340},   /*Unicode: U+f068 ()*/
    {.w_px = 19,  .glyph_index = 1380},   /*Unicode: U+f071 ()*/
    {.w_px = 19,  .glyph_index = 1440},   /*Unicode: U+f074 ()*/
    {.w_px = 17,  .glyph_index = 1500},   /*Unicode: U+f077 ()*/
    {.w_px = 17,  .glyph_index = 1560},   /*Unicode: U+f078 ()*/
    {.w_px = 21,  .glyph_index = 1620},   /*Unicode: U+f079 ()*/
    {.w_px = 18,  .glyph_index = 1680},   /*Unicode: U+f07b ()*/
    {.w_px = 18,  .glyph_index = 1740},   /*Unicode: U+f093 ()*/
    {.w_px = 15,  .glyph_index = 1800},   /*Unicode: U+f095 ()*/
    {.w_px = 19,  .glyph_index = 1840},   /*Unicode: U+f0c4 ()*/
    {.w_px = 19,  .glyph_index = 1900},   /*Unicode: U+f0c5 ()*/
    {.w_px = 17,  .glyph_index = 1960},   /*Unicode: U+f0c7 ()*/
    {.w_px = 10,  .glyph_index = 2020},   /*Unicode: U+f0e7 ()*/
    {.w_px = 18,  .glyph_index = 2060},   /*Unicode: U+f0f3 ()*/
    {.w_px = 21,  .glyph_index = 2120},   /*Unicode: U+f11c ()*/
    {.w_px = 15,  .glyph_index = 2180},   /*Unicode: U+f124 ()*/
    {.w_px = 17,  .glyph_index = 2220},   /*Unicode: U+f15b ()*/
    {.w_px = 21,  .glyph_index = 2280},   /*Unicode: U+f1eb ()*/
    {.w_px = 25,  .glyph_index = 2340},   /*Unicode: U+f240 ()*/
    {.w_px = 25,  .glyph_index = 2420},   /*Unicode: U+f241 ()*/
    {.w_px = 25,  .glyph_index = 2500},   /*Unicode: U+f242 ()*/
    {.w_px = 25,  .glyph_index = 2580},   /*Unicode: U+f243 ()*/
    {.w_px = 25,  .glyph_index = 2660},   /*Unicode: U+f244 ()*/
    {.w_px = 14,  .glyph_index = 2740},   /*Unicode: U+f293 ()*/

#elif USE_LV_FONT_SYMBOL_20 == 2
    {.w_px = 17,  .glyph_index = 0},  /*Unicode: U+f001 ()*/
    {.w_px = 21,  .glyph_index = 100},    /*Unicode: U+f008 ()*/
    {.w_px = 19,  .glyph_index = 220},    /*Unicode: U+f00b ()*/
    {.w_px = 17,  .glyph_index = 320},    /*Unicode: U+f00c ()*/
    {.w_px = 13,  .glyph_index = 420},    /*Unicode: U+f00d ()*/
    {.w_px = 17,  .glyph_index = 500},    /*Unicode: U+f011 ()*/
    {.w_px = 17,  .glyph_index = 600},    /*Unicode: U+f013 ()*/
    {.w_px = 15,  .glyph_index = 700},    /*Unicode: U+f014 ()*/
    {.w_px = 18,  .glyph_index = 780},    /*Unicode: U+f015 ()*/
    {.w_px = 18,  .glyph_index = 880},    /*Unicode: U+f019 ()*/
    {.w_px = 17,  .glyph_index = 980},    /*Unicode: U+f01c ()*/
    {.w_px = 17,  .glyph_index = 1080},   /*Unicode: U+f021 ()*/
    {.w_px = 9,   .glyph_index = 1180},   /*Unicode: U+f026 ()*/
    {.w_px = 13,  .glyph_index = 1240},   /*Unicode: U+f027 ()*/
    {.w_px = 18,  .glyph_index = 1320},   /*Unicode: U+f028 ()*/
    {.w_px = 21,  .glyph_index = 1420},   /*Unicode: U+f03e ()*/
    {.w_px = 17,  .glyph_index = 1540},   /*Unicode: U+f040 ()*/
    {.w_px = 11,  .glyph_index = 1640},   /*Unicode: U+f048 ()*/
    {.w_px = 15,  .glyph_index = 1700},   /*Unicode: U+f04b ()*/
    {.w_px = 16,  .glyph_index = 1780},   /*Unicode: U+f04c ()*/
    {.w_px = 17,  .glyph_index = 1860},   /*Unicode: U+f04d ()*/
    {.w_px = 11,  .glyph_index = 1960},   /*Unicode: U+f051 ()*/
    {.w_px = 17,  .glyph_index = 2020},   /*Unicode: U+f052 ()*/
    {.w_px = 12,  .glyph_index = 2120},   /*Unicode: U+f053 ()*/
    {.w_px = 11,  .glyph_index = 2180},   /*Unicode: U+f054 ()*/
    {.w_px = 15,  .glyph_index = 2240},   /*Unicode: U+f067 ()*/
    {.w_px = 15,  .glyph_index = 2320},   /*Unicode: U+f068 ()*/
    {.w_px = 19,  .glyph_index = 2400},   /*Unicode: U+f071 ()*/
    {.w_px = 19,  .glyph_index = 2500},   /*Unicode: U+f074 ()*/
    {.w_px = 17,  .glyph_index = 2600},   /*Unicode: U+f077 ()*/
    {.w_px = 17,  .glyph_index = 2700},   /*Unicode: U+f078 ()*/
    {.w_px = 21,  .glyph_index = 2800},   /*Unicode: U+f079 ()*/
    {.w_px = 18,  .glyph_index = 2920},   /*Unicode: U+f07b ()*/
    {.w_px = 18,  .glyph_index = 3020},   /*Unicode: U+f093 ()*/
    {.w_px = 15,  .glyph_index = 3120},   /*Unicode: U+f095 ()*/
    {.w_px = 19,  .glyph_index = 3200},   /*Unicode: U+f0c4 ()*/
    {.w_px = 19,  .glyph_index = 3300},   /*Unicode: U+f0c5 ()*/
    {.w_px = 17,  .glyph_index = 3400},   /*Unicode: U+f0c7 ()*/
    {.w_px = 10,  .glyph_index = 3500},   /*Unicode: U+f0e7 ()*/
    {.w_px = 18,  .glyph_index = 3560},   /*Unicode: U+f0f3 ()*/
    {.w_px = 21,  .glyph_index = 3660},   /*Unicode: U+f11c ()*/
    {.w_px = 15,  .glyph_index = 3780},   /*Unicode: U+f124 ()*/
    {.w_px = 17,  .glyph_index = 3860},   /*Unicode: U+f15b ()*/
    {.w_px = 21,  .glyph_index = 3960},   /*Unicode: U+f1eb ()*/
    {.w_px = 25,  .glyph_index = 4080},   /*Unicode: U+f240 ()*/
    {.w_px = 25,  .glyph_index = 4220},   /*Unicode: U+f241 ()*/
    {.w_px = 25,  .glyph_index = 4360},   /*Unicode: U+f242 ()*/
    {.w_px = 25,  .glyph_index = 4500},   /*Unicode: U+f243 ()*/
    {.w_px = 25,  .glyph_index = 4640},   /*Unicode: U+f244 ()*/
    {.w_px = 14,  .glyph_index = 4780},   /*Unicode: U+f293 ()*/

#elif USE_LV_FONT_SYMBOL_20 == 4
    {.w_px = 17,  .glyph_index = 0},  /*Unicode: U+f001 ()*/
    {.w_px = 21,  .glyph_index = 180},    /*Unicode: U+f008 ()*/
    {.w_px = 19,  .glyph_index = 400},    /*Unicode: U+f00b ()*/
    {.w_px = 17,  .glyph_index = 600},    /*Unicode: U+f00c ()*/
    {.w_px = 13,  .glyph_index = 780},    /*Unicode: U+f00d ()*/
    {.w_px = 17,  .glyph_index = 920},    /*Unicode: U+f011 ()*/
    {.w_px = 17,  .glyph_index = 1100},   /*Unicode: U+f013 ()*/
    {.w_px = 15,  .glyph_index = 1280},   /*Unicode: U+f014 ()*/
    {.w_px = 18,  .glyph_index = 1440},   /*Unicode: U+f015 ()*/
    {.w_px = 18,  .glyph_index = 1620},   /*Unicode: U+f019 ()*/
    {.w_px = 17,  .glyph_index = 1800},   /*Unicode: U+f01c ()*/
    {.w_px = 17,  .glyph_index = 1980},   /*Unicode: U+f021 ()*/
    {.w_px = 9,   .glyph_index = 2160},   /*Unicode: U+f026 ()*/
    {.w_px = 13,  .glyph_index = 2260},   /*Unicode: U+f027 ()*/
    {.w_px = 18,  .glyph_index = 2400},   /*Unicode: U+f028 ()*/
    {.w_px = 21,  .glyph_index = 2580},   /*Unicode: U+f03e ()*/
    {.w_px = 17,  .glyph_index = 2800},   /*Unicode: U+f040 ()*/
    {.w_px = 11,  .glyph_index = 2980},   /*Unicode: U+f048 ()*/
    {.w_px = 15,  .glyph_index = 3100},   /*Unicode: U+f04b ()*/
    {.w_px = 16,  .glyph_index = 3260},   /*Unicode: U+f04c ()*/
    {.w_px = 17,  .glyph_index = 3420},   /*Unicode: U+f04d ()*/
    {.w_px = 11,  .glyph_index = 3600},   /*Unicode: U+f051 ()*/
    {.w_px = 17,  .glyph_index = 3720},   /*Unicode: U+f052 ()*/
    {.w_px = 12,  .glyph_index = 3900},   /*Unicode: U+f053 ()*/
    {.w_px = 11,  .glyph_index = 4020},   /*Unicode: U+f054 ()*/
    {.w_px = 15,  .glyph_index = 4140},   /*Unicode: U+f067 ()*/
    {.w_px = 15,  .glyph_index = 4300},   /*Unicode: U+f068 ()*/
    {.w_px = 19,  .glyph_index = 4460},   /*Unicode: U+f071 ()*/
    {.w_px = 19,  .glyph_index = 4660},   /*Unicode: U+f074 ()*/
    {.w_px = 17,  .glyph_index = 4860},   /*Unicode: U+f077 ()*/
    {.w_px = 17,  .glyph_index = 5040},   /*Unicode: U+f078 ()*/
    {.w_px = 21,  .glyph_index = 5220},   /*Unicode: U+f079 ()*/
    {.w_px = 18,  .glyph_index = 5440},   /*Unicode: U+f07b ()*/
    {.w_px = 18,  .glyph_index = 5620},   /*Unicode: U+f093 ()*/
    {.w_px = 15,  .glyph_index = 5800},   /*Unicode: U+f095 ()*/
    {.w_px = 19,  .glyph_index = 5960},   /*Unicode: U+f0c4 ()*/
    {.w_px = 19,  .glyph_index = 6160},   /*Unicode: U+f0c5 ()*/
    {.w_px = 17,  .glyph_index = 6360},   /*Unicode: U+f0c7 ()*/
    {.w_px = 10,  .glyph_index = 6540},   /*Unicode: U+f0e7 ()*/
    {.w_px = 18,  .glyph_index = 6640},   /*Unicode: U+f0f3 ()*/
    {.w_px = 21,  .glyph_index = 6820},   /*Unicode: U+f11c ()*/
    {.w_px = 15,  .glyph_index = 7040},   /*Unicode: U+f124 ()*/
    {.w_px = 17,  .glyph_index = 7200},   /*Unicode: U+f15b ()*/
    {.w_px = 21,  .glyph_index = 7380},   /*Unicode: U+f1eb ()*/
    {.w_px = 25,  .glyph_index = 7600},   /*Unicode: U+f240 ()*/
    {.w_px = 25,  .glyph_index = 7860},   /*Unicode: U+f241 ()*/
    {.w_px = 25,  .glyph_index = 8120},   /*Unicode: U+f242 ()*/
    {.w_px = 25,  .glyph_index = 8380},   /*Unicode: U+f243 ()*/
    {.w_px = 25,  .glyph_index = 8640},   /*Unicode: U+f244 ()*/
    {.w_px = 14,  .glyph_index = 8900},   /*Unicode: U+f293 ()*/

#elif USE_LV_FONT_SYMBOL_20 == 8
    {.w_px = 17,  .glyph_index = 0},  /*Unicode: U+f001 ()*/
    {.w_px = 21,  .glyph_index = 340},    /*Unicode: U+f008 ()*/
    {.w_px = 19,  .glyph_index = 760},    /*Unicode: U+f00b ()*/
    {.w_px = 17,  .glyph_index = 1140},   /*Unicode: U+f00c ()*/
    {.w_px = 13,  .glyph_index = 1480},   /*Unicode: U+f00d ()*/
    {.w_px = 17,  .glyph_index = 1740},   /*Unicode: U+f011 ()*/
    {.w_px = 17,  .glyph_index = 2080},   /*Unicode: U+f013 ()*/
    {.w_px = 15,  .glyph_index = 2420},   /*Unicode: U+f014 ()*/
    {.w_px = 18,  .glyph_index = 2720},   /*Unicode: U+f015 ()*/
    {.w_px = 18,  .glyph_index = 3080},   /*Unicode: U+f019 ()*/
    {.w_px = 17,  .glyph_index = 3440},   /*Unicode: U+f01c ()*/
    {.w_px = 17,  .glyph_index = 3780},   /*Unicode: U+f021 ()*/
    {.w_px = 9,   .glyph_index = 4120},   /*Unicode: U+f026 ()*/
    {.w_px = 13,  .glyph_index = 4300},   /*Unicode: U+f027 ()*/
    {.w_px = 18,  .glyph_index = 4560},   /*Unicode: U+f028 ()*/
    {.w_px = 21,  .glyph_index = 4920},   /*Unicode: U+f03e ()*/
    {.w_px = 17,  .glyph_index = 5340},   /*Unicode: U+f040 ()*/
    {.w_px = 11,  .glyph_index = 5680},   /*Unicode: U+f048 ()*/
    {.w_px = 15,  .glyph_index = 5900},   /*Unicode: U+f04b ()*/
    {.w_px = 16,  .glyph_index = 6200},   /*Unicode: U+f04c ()*/
    {.w_px = 17,  .glyph_index = 6520},   /*Unicode: U+f04d ()*/
    {.w_px = 11,  .glyph_index = 6860},   /*Unicode: U+f051 ()*/
    {.w_px = 17,  .glyph_index = 7080},   /*Unicode: U+f052 ()*/
    {.w_px = 12,  .glyph_index = 7420},   /*Unicode: U+f053 ()*/
    {.w_px = 11,  .glyph_index = 7660},   /*Unicode: U+f054 ()*/
    {.w_px = 15,  .glyph_index = 7880},   /*Unicode: U+f067 ()*/
    {.w_px = 15,  .glyph_index = 8180},   /*Unicode: U+f068 ()*/
    {.w_px = 19,  .glyph_index = 8480},   /*Unicode: U+f071 ()*/
    {.w_px = 19,  .glyph_index = 8860},   /*Unicode: U+f074 ()*/
    {.w_px = 17,  .glyph_index = 9240},   /*Unicode: U+f077 ()*/
    {.w_px = 17,  .glyph_index = 9580},   /*Unicode: U+f078 ()*/
    {.w_px = 21,  .glyph_index = 9920},   /*Unicode: U+f079 ()*/
    {.w_px = 18,  .glyph_index = 10340},  /*Unicode: U+f07b ()*/
    {.w_px = 18,  .glyph_index = 10700},  /*Unicode: U+f093 ()*/
    {.w_px = 15,  .glyph_index = 11060},  /*Unicode: U+f095 ()*/
    {.w_px = 19,  .glyph_index = 11360},  /*Unicode: U+f0c4 ()*/
    {.w_px = 19,  .glyph_index = 11740},  /*Unicode: U+f0c5 ()*/
    {.w_px = 17,  .glyph_index = 12120},  /*Unicode: U+f0c7 ()*/
    {.w_px = 10,  .glyph_index = 12460},  /*Unicode: U+f0e7 ()*/
    {.w_px = 18,  .glyph_index = 12660},  /*Unicode: U+f0f3 ()*/
    {.w_px = 21,  .glyph_index = 13020},  /*Unicode: U+f11c ()*/
    {.w_px = 15,  .glyph_index = 13440},  /*Unicode: U+f124 ()*/
    {.w_px = 17,  .glyph_index = 13740},  /*Unicode: U+f15b ()*/
    {.w_px = 21,  .glyph_index = 14080},  /*Unicode: U+f1eb ()*/
    {.w_px = 25,  .glyph_index = 14500},  /*Unicode: U+f240 ()*/
    {.w_px = 25,  .glyph_index = 15000},  /*Unicode: U+f241 ()*/
    {.w_px = 25,  .glyph_index = 15500},  /*Unicode: U+f242 ()*/
    {.w_px = 25,  .glyph_index = 16000},  /*Unicode: U+f243 ()*/
    {.w_px = 25,  .glyph_index = 16500},  /*Unicode: U+f244 ()*/
    {.w_px = 14,  .glyph_index = 17000},  /*Unicode: U+f293 ()*/

#endif
};

lv_font_t lv_font_symbol_20 = {
    .unicode_first = LV_SYMBOL_GLYPH_FIRST, /*First Unicode letter in this font*/
    .unicode_last = LV_SYMBOL_GLYPH_LAST,  /*Last Unicode letter in this font*/
    .h_px = 20,             /*Font height in pixels*/
    .glyph_bitmap = lv_font_symbol_20_glyph_bitmap, /*Bitmap of glyphs*/
    .glyph_dsc = lv_font_symbol_20_glyph_dsc,       /*Description of glyphs*/
    .glyph_cnt = 50,            /*Number of glyphs in the font*/
    .unicode_list = NULL,
    .get_bitmap = lv_font_get_bitmap_continuous,    /*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,  /*Function pointer to get glyph's width*/
#if USE_LV_FONT_SYMBOL_20 == 1
    .bpp = 1,               /*Bit per pixel*/
#elif USE_LV_FONT_SYMBOL_20 == 2
    .bpp = 2,               /*Bit per pixel*/
#elif USE_LV_FONT_SYMBOL_20 == 4
    .bpp = 4,               /*Bit per pixel*/
#elif USE_LV_FONT_SYMBOL_20 == 8
    .bpp = 8,               /*Bit per pixel*/
#endif
    .monospace = 0,
    .next_page = NULL,      /*Pointer to a font extension*/
};

#endif /*USE_LV_FONT_SYMBOL_20*/
