
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_SYMBOL_10 != 0  /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * fontawesome-webfont.ttf 10 px Font in U+f000 () .. U+f2ee ()  range with 1 bpp
 * Sparse font with only these characters:     
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_symbol_10_glyph_bitmap[] = {
#if USE_LV_FONT_SYMBOL_10 == 1
    /*Unicode: U+f001 () , Width: 8 */
    0x00,  //........
    0x0f,  //...+%@@%
    0x3f,  //..%@@@@%
    0x3d,  //..%@@%+%
    0x21,  //..%+...%
    0x21,  //..%....%
    0x27,  //..%.+@@%
    0xe6,  //%@@..%%.
    0xe0,  //@@%.....
    0x00,  //........


    /*Unicode: U+f008 () , Width: 10 */
    0x00, 0x00,  //..........
    0xff, 0xc0,  //@@@%%%@@@%
    0xa1, 0x40,  //@.%....%.%
    0xe1, 0xc0,  //@@%....@@%
    0xa1, 0x40,  //@.@....@.%
    0xff, 0xc0,  //@%@%%%%@%%
    0xa1, 0x40,  //@+%....@+%
    0xa1, 0x40,  //@+%....@+%
    0xff, 0xc0,  //@%@%%%%@%%
    0x00, 0x00,  //..........


    /*Unicode: U+f00b () , Width: 9 */
    0x00, 0x00,  //.........
    0xff, 0x80,  //@@+%@@@@@
    0xdf, 0x80,  //@@+%@@@@@
    0x00, 0x00,  //++.++++++
    0xff, 0x80,  //@@%@@@@@@
    0x00, 0x00,  //++.++++++
    0xdf, 0x80,  //@@+%@@@@@
    0xff, 0x80,  //@@+%@@@@@
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+f00c () , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x01, 0x00,  //......+@.
    0x03, 0x00,  //.....+@@.
    0x66, 0x00,  //.@%.+@@..
    0x7c, 0x00,  //.@@@@@...
    0x38, 0x00,  //..@@@....
    0x10, 0x00,  //...@+....
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+f00d () , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x48,  //+%..%+
    0xfc,  //@@@@@%
    0x78,  //.@@@@.
    0x78,  //.@@@@.
    0xfc,  //@@@@@%
    0xc8,  //%@..@+
    0x00,  //......
    0x00,  //......


    /*Unicode: U+f011 () , Width: 8 */
    0x00,  //...+....
    0x10,  //...@....
    0x54,  //.@+@+@..
    0xd6,  //%@.@.%%.
    0x92,  //@+.@..@.
    0x82,  //@.....@.
    0xc2,  //@+...+@.
    0x44,  //+@+.+@+.
    0x38,  //.+@@@+..
    0x00,  //........


    /*Unicode: U+f013 () , Width: 8 */
    0x00,  //........
    0x18,  //...@%...
    0x7e,  //.@@@@@%.
    0x7c,  //.@@%@@+.
    0xe7,  //@@%..@@%
    0xe6,  //%@@.+@@+
    0x7e,  //.@@@@@%.
    0x5c,  //.%+@%%+.
    0x10,  //...%+...
    0x00,  //........


    /*Unicode: U+f014 () , Width: 8 */
    0x00,  //........
    0x38,  //..%%%...
    0xfe,  //%@@%@@@.
    0x00,  //++....+.
    0x30,  //++%%+++.
    0x30,  //++%%+++.
    0x30,  //++%%+++.
    0x00,  //++....+.
    0x7c,  //.%%%%%..
    0x00,  //........


    /*Unicode: U+f015 () , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //......+..
    0x1e, 0x00,  //..+@@%@..
    0x7e, 0x00,  //.%%@%%@..
    0xff, 0x00,  //%%@@@@%%.
    0x7e, 0x00,  //.@@@@@@..
    0x66, 0x00,  //.@@..@@..
    0x66, 0x00,  //.@@..@@..
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+f019 () , Width: 9 */
    0x00, 0x00,  //...++....
    0x18, 0x00,  //...@@....
    0x18, 0x00,  //...@@....
    0x3c, 0x00,  //.+@@@@+..
    0x1c, 0x00,  //..+@@%...
    0x18, 0x00,  //+++%%+++.
    0xff, 0x00,  //@@@@@@@@+
    0xff, 0x00,  //@@@@@@@@.
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+f01c () , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x7c,  //.%@@@@+.
    0x42,  //.@....@.
    0x82,  //%+....%+
    0xe7,  //@@%..@@%
    0xff,  //@@@@@@@%
    0xff,  //@@@@@@@%
    0x00,  //........
    0x00,  //........


    /*Unicode: U+f021 () , Width: 8 */
    0x00,  //........
    0x3d,  //.+@@@@+%
    0x67,  //+@%..%@@
    0xc7,  //%%...@@@
    0x00,  //........
    0x00,  //+++...++
    0xe2,  //@@%...@+
    0xe6,  //@@%.+@@.
    0xbc,  //%.%@@%..
    0x00,  //........


    /*Unicode: U+f026 () , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x10,  //..+@
    0xf0,  //%%@@
    0xf0,  //@@@@
    0xf0,  //@@@@
    0x30,  //..@@
    0x10,  //...%
    0x00,  //....
    0x00,  //....


    /*Unicode: U+f027 () , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x10,  //..+@..
    0xf0,  //%%@@..
    0xf4,  //@@@@.%
    0xf0,  //@@@@++
    0x30,  //..@@..
    0x10,  //...%..
    0x00,  //......
    0x00,  //......


    /*Unicode: U+f028 () , Width: 9 */
    0x00, 0x00,  //.........
    0x02, 0x00,  //......%..
    0x11, 0x00,  //..+@.++%.
    0xf2, 0x00,  //%%@@.+%++
    0xf6, 0x80,  //@@@@.%%+%
    0xf6, 0x80,  //@@@@.+%+%
    0x35, 0x00,  //..@@.%+%.
    0x12, 0x00,  //...%..%+.
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+f03e () , Width: 10 */
    0x00, 0x00,  //..........
    0x80, 0x40,  //@++++++++%
    0xa0, 0x40,  //%+@......%
    0xa2, 0x40,  //%+@..+@..%
    0x87, 0x40,  //%...+@@@.%
    0xbf, 0x40,  //%.@@@@@@+%
    0xff, 0x40,  //%%@@@@@@+%
    0x80, 0x40,  //%........%
    0xff, 0x80,  //%%%%%%%%%+
    0x00, 0x00,  //..........


    /*Unicode: U+f040 () , Width: 8 */
    0x00,  //........
    0x06,  //.....%%.
    0x06,  //....+@@+
    0x1e,  //...%@+@+
    0x3c,  //..%%@@..
    0x78,  //.%%@@+..
    0xf0,  //%%@@+...
    0xa0,  //@.@+....
    0xc0,  //%%+.....
    0x00,  //........


    /*Unicode: U+f048 () , Width: 6 */
    0x00,  //......
    0x88,  //@...%.
    0x98,  //@..%@.
    0xb8,  //@.%@@.
    0xf8,  //@%@@@.
    0xf8,  //@%@@@.
    0x98,  //@.+@@.
    0x88,  //@..+@.
    0x80,  //%...+.
    0x00,  //......


    /*Unicode: U+f04b () , Width: 7 */
    0x00,  //.......
    0x80,  //@+.....
    0xe0,  //@@@+...
    0xf8,  //@@@@%..
    0xfe,  //@@@@@@%
    0xfc,  //@@@@@%.
    0xf0,  //@@@@+..
    0xc0,  //@@+....
    0x00,  //+......
    0x00,  //.......


    /*Unicode: U+f04c () , Width: 8 */
    0x00,  //........
    0xe7,  //@@@..@@@
    0xe7,  //@@@..@@@
    0xe7,  //@@@..@@@
    0xe7,  //@@@..@@@
    0xe7,  //@@@..@@@
    0xe7,  //@@@..@@@
    0xe7,  //@@@..@@@
    0xe7,  //%%%..%%%
    0x00,  //........


    /*Unicode: U+f04d () , Width: 8 */
    0x00,  //........
    0xff,  //@@@@@@@%
    0xff,  //@@@@@@@%
    0xff,  //@@@@@@@%
    0xff,  //@@@@@@@%
    0xff,  //@@@@@@@%
    0xff,  //@@@@@@@%
    0xff,  //@@@@@@@%
    0xfe,  //%%%%%%%+
    0x00,  //........


    /*Unicode: U+f051 () , Width: 6 */
    0x00,  //......
    0x88,  //%...@.
    0xc8,  //@%..@.
    0xe8,  //@@%.@.
    0xf8,  //@@@%@.
    0xf8,  //@@@%@.
    0xc8,  //@@+.@.
    0x88,  //@+..@.
    0x08,  //+...%.
    0x00,  //......


    /*Unicode: U+f052 () , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x18,  //..+@@...
    0x3c,  //.+@@@@..
    0x7e,  //+@@@@@@.
    0x00,  //+++++++.
    0xff,  //@@@@@@@%
    0xff,  //@@@@@@@%
    0x00,  //........
    0x00,  //........


    /*Unicode: U+f053 () , Width: 6 */
    0x08,  //....%+
    0x1c,  //...@@%
    0x38,  //..@@%.
    0x70,  //.@@%..
    0x70,  //.@@%..
    0x38,  //..@@%.
    0x1c,  //...@@%
    0x0c,  //....@%
    0x00,  //......
    0x00,  //......


    /*Unicode: U+f054 () , Width: 6 */
    0x40,  //.@+...
    0x60,  //+@@+..
    0x30,  //.+@@+.
    0x18,  //..+@@+
    0x18,  //..+@@+
    0x30,  //.+@@+.
    0x60,  //.@@+..
    0x40,  //.@+...
    0x00,  //......
    0x00,  //......


    /*Unicode: U+f067 () , Width: 8 */
    0x00,  //........
    0x10,  //..+@+...
    0x10,  //..+@+...
    0x38,  //++%@%++.
    0xfe,  //@@@@@@@.
    0x38,  //++%@%++.
    0x10,  //..+@+...
    0x10,  //..+@+...
    0x00,  //........
    0x00,  //........


    /*Unicode: U+f068 () , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xfe,  //@@@@@@@.
    0xfe,  //@@@@@@@.
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+f071 () , Width: 9 */
    0x00, 0x00,  //....+....
    0x08, 0x00,  //...+@+...
    0x1c, 0x00,  //...@@@...
    0x36, 0x00,  //..%@.@%..
    0x36, 0x00,  //..@@.@@..
    0x7f, 0x00,  //.%@@%@@%.
    0x77, 0x00,  //.@@@.@@@.
    0xf7, 0x80,  //%@@@.@@@%
    0xff, 0x80,  //@@@@@@@@@
    0x00, 0x00,  //.........


    /*Unicode: U+f074 () , Width: 9 */
    0x00, 0x00,  //.........
    0x01, 0x00,  //.......@.
    0xef, 0x80,  //@@@.@@@@@
    0x39, 0x00,  //..%%@..@.
    0x10, 0x00,  //...@.....
    0x39, 0x00,  //..%%%..@.
    0xef, 0x80,  //@@@.@@@@@
    0x01, 0x00,  //.......@.
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+f077 () , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x18, 0x00,  //...@@....
    0x3c, 0x00,  //..@@@@...
    0x7e, 0x00,  //.@@%%@@..
    0xe7, 0x00,  //@@%..%@@.
    0x42, 0x00,  //+%....%+.
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+f078 () , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xc3, 0x00,  //+%....%%.
    0xe7, 0x00,  //%@@..%@@.
    0x7e, 0x00,  //.%@@%@@..
    0x3c, 0x00,  //..%@@@...
    0x18, 0x00,  //...%@....
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+f079 () , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x5f, 0x00,  //.@.@@@@@..
    0xe1, 0x00,  //@@@...+@..
    0x61, 0x00,  //+@%....@..
    0x43, 0x00,  //.@....%@+.
    0x43, 0x80,  //.@+...@@@.
    0x7d, 0x00,  //.@@@@@.@..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+f07b () , Width: 9 */
    0x00, 0x00,  //.........
    0xf0, 0x00,  //@@@%.....
    0xff, 0x00,  //@@@@@@@%.
    0xff, 0x00,  //@@@@@@@@+
    0xff, 0x00,  //@@@@@@@@+
    0xff, 0x00,  //@@@@@@@@+
    0xff, 0x00,  //@@@@@@@@+
    0xff, 0x00,  //%@@@@@@@.
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+f093 () , Width: 9 */
    0x00, 0x00,  //.........
    0x18, 0x00,  //...@@....
    0x3c, 0x00,  //..@@@@...
    0x18, 0x00,  //..+@@+...
    0x18, 0x00,  //...@@....
    0x18, 0x00,  //...@@....
    0xe7, 0x00,  //@@%++%@@.
    0xff, 0x00,  //@@@@@@@%+
    0xff, 0x00,  //%%%%%%%%.
    0x00, 0x00,  //.........


    /*Unicode: U+f095 () , Width: 8 */
    0x00,  //........
    0xc0,  //%@......
    0xc0,  //@@+.....
    0xc0,  //@@......
    0x40,  //+@......
    0x60,  //.%@..+..
    0x3e,  //..%@@@@.
    0x0e,  //...+@@%.
    0x00,  //........
    0x00,  //........


    /*Unicode: U+f0c4 () , Width: 10 */
    0x00, 0x00,  //..........
    0x60, 0x00,  //+@%.......
    0x90, 0x00,  //%.+@...++.
    0x50, 0x00,  //+%+@.+..+.
    0x08, 0x00,  //..++%.+...
    0x74, 0x00,  //.%@%+%++..
    0x90, 0x00,  //%+.@..+.+.
    0x90, 0x00,  //%.+%...++.
    0x60, 0x00,  //+@%.......
    0x00, 0x00,  //..........


    /*Unicode: U+f0c5 () , Width: 9 */
    0x1c, 0x00,  //..+%%%...
    0x24, 0x00,  //.+@..%...
    0xa7, 0x80,  //%+%..@%%%
    0xe4, 0x80,  //@%%.+@+.%
    0x88, 0x80,  //%..+%.+.%
    0x9c, 0x80,  //%..@%%+.%
    0x90, 0x80,  //@..%....%
    0x10, 0x80,  //...%....%
    0x1f, 0x80,  //...@%%%%@
    0x00, 0x00,  //.........


    /*Unicode: U+f0c7 () , Width: 8 */
    0x00,  //........
    0xfc,  //@@@@@@..
    0xea,  //%%@.%.@.
    0xf9,  //%%@@@..%
    0x81,  //%......%
    0xbd,  //%+%%%%.%
    0xc1,  //%%...++%
    0xc1,  //%%...++%
    0xff,  //%%%%%%%%
    0x00,  //........


    /*Unicode: U+f0e7 () , Width: 5 */
    0x00,  //.....
    0x60,  //.@@..
    0x60,  //+@%..
    0xf0,  //%@%@+
    0xf0,  //@@@@.
    0x20,  //+.@+.
    0x20,  //..@..
    0x20,  //.+%..
    0x40,  //.%...
    0x00,  //.....


    /*Unicode: U+f0f3 () , Width: 9 */
    0x00, 0x00,  //....+....
    0x1c, 0x00,  //..+@@%...
    0x3c, 0x00,  //..@@@@+..
    0x3e, 0x00,  //.+@@@@%..
    0x3e, 0x00,  //.+@@@@@..
    0x7e, 0x00,  //.%@@@@@..
    0x7e, 0x00,  //.@@@@@@+.
    0xff, 0x00,  //@@@@@@@@.
    0x1c, 0x00,  //.++@@%++.
    0x08, 0x00,  //...+%....


    /*Unicode: U+f11c () , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0xff, 0x80,  //%%%%%%%%%+
    0x80, 0x40,  //%........%
    0x80, 0x40,  //%......++%
    0x81, 0x40,  //%++++..%.%
    0x80, 0x40,  //%+.++++..%
    0xff, 0xc0,  //@%%%%%%%%%
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+f124 () , Width: 7 */
    0x00,  //.......
    0x00,  //......+
    0x06,  //....+@@
    0x1c,  //..+@@@+
    0x7c,  //+@@@@@.
    0x18,  //+++@@+.
    0x18,  //...@@..
    0x10,  //...@+..
    0x00,  //...+...
    0x00,  //.......


    /*Unicode: U+f15b () , Width: 8 */
    0xf0,  //@@@@++..
    0xf4,  //@@@@+@+.
    0xfa,  //@@@@%+%.
    0xff,  //@@@@@@@%
    0xff,  //@@@@@@@%
    0xff,  //@@@@@@@%
    0xff,  //@@@@@@@%
    0xff,  //@@@@@@@%
    0xff,  //@@@@@@@%
    0x00,  //........


    /*Unicode: U+f1eb () , Width: 10 */
    0x00, 0x00,  //..........
    0x3f, 0x00,  //..%@@@@%..
    0x71, 0x80,  //+@@++++@@+
    0x1e, 0x40,  //+++@@@@++%
    0x21, 0x00,  //.+@++++@+.
    0x1e, 0x00,  //...%@@@...
    0x00, 0x00,  //...++++...
    0x04, 0x00,  //....+%....
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+f240 () , Width: 12 */
    0x00, 0x00,  //............
    0xff, 0xe0,  //%%%%%%%%%%%.
    0x80, 0x20,  //%.+++++++.%.
    0xff, 0xd0,  //%%@@@@@@@%+%
    0xff, 0xd0,  //%%@@@@@@@%.%
    0xff, 0xd0,  //%%@@@@@@@%.%
    0xbf, 0xa0,  //%+%%%%%%%+%.
    0xff, 0xe0,  //%%%%%%%%%%%.
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+f241 () , Width: 12 */
    0x00, 0x00,  //............
    0xff, 0xe0,  //%%%%%%%%%%%.
    0x80, 0x20,  //%.+++++...%.
    0xff, 0x10,  //%%@@@@@%..+%
    0xff, 0x10,  //%%@@@@@%...%
    0xff, 0x10,  //%%@@@@@%...%
    0xbe, 0x20,  //%+%%%%%+..%.
    0xff, 0xe0,  //%%%%%%%%%%%.
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+f242 () , Width: 12 */
    0x00, 0x00,  //............
    0xff, 0xe0,  //%%%%%%%%%%%.
    0x80, 0x20,  //%.++++....%.
    0xfc, 0x10,  //%%@@@@....+%
    0xfc, 0x10,  //%%@@@@.....%
    0xfc, 0x10,  //%%@@@@.....%
    0xbc, 0x20,  //%+%%%+....%.
    0xff, 0xe0,  //%%%%%%%%%%%.
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+f243 () , Width: 12 */
    0x00, 0x00,  //............
    0xff, 0xe0,  //%%%%%%%%%%%.
    0x80, 0x20,  //%.++......%.
    0xf0, 0x10,  //%%@@......+%
    0xf0, 0x10,  //%%@@.......%
    0xf0, 0x10,  //%%@@.......%
    0xb0, 0x20,  //%+%%......%.
    0xff, 0xe0,  //%%%%%%%%%%%.
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+f244 () , Width: 12 */
    0x00, 0x00,  //............
    0xff, 0xe0,  //%%%%%%%%%%%.
    0x80, 0x20,  //%.........%.
    0x80, 0x10,  //%.........+%
    0x80, 0x10,  //%..........%
    0x80, 0x10,  //%..........%
    0x80, 0x20,  //%.........%.
    0xff, 0xe0,  //%%%%%%%%%%%.
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+f293 () , Width: 8 */
    0x3c,  //..%@@@..
    0x36,  //.+@@.@@.
    0x72,  //.@%@.+@+
    0x63,  //.@@+.+@%
    0x77,  //.@@%.@@%
    0x63,  //.@@+.+@%
    0x72,  //.@%@.+@+
    0x36,  //.+@@.@@.
    0x3c,  //..%@@@..
    0x00,  //........



#elif USE_LV_FONT_SYMBOL_10 == 2
    /*Unicode: U+f001 () , Width: 8 */
    0x00, 0x00,  //........
    0x01, 0xbe,  //...+%@@%
    0x0b, 0xfe,  //..%@@@@%
    0x0b, 0xe6,  //..%@@%+%
    0x09, 0x02,  //..%+...%
    0x08, 0x02,  //..%....%
    0x08, 0x7e,  //..%.+@@%
    0xbc, 0x28,  //%@@..%%.
    0xf8, 0x00,  //@@%.....
    0x00, 0x00,  //........


    /*Unicode: U+f008 () , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0xfe, 0xaf, 0xe0,  //@@@%%%@@@%
    0xc8, 0x03, 0x20,  //@.%....%.%
    0xf8, 0x03, 0xe0,  //@@%....@@%
    0xcc, 0x03, 0x20,  //@.@....@.%
    0xfe, 0xab, 0xe0,  //@%@%%%%@%%
    0xd8, 0x03, 0x60,  //@+%....@+%
    0xd8, 0x03, 0x60,  //@+%....@+%
    0xfe, 0xab, 0xe0,  //@%@%%%%@%%
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f00b () , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0xfa, 0xff, 0xc0,  //@@+%@@@@@
    0xf6, 0xff, 0xc0,  //@@+%@@@@@
    0x51, 0x55, 0x40,  //++.++++++
    0xfb, 0xff, 0xc0,  //@@%@@@@@@
    0x51, 0x55, 0x40,  //++.++++++
    0xf6, 0xff, 0xc0,  //@@+%@@@@@
    0xfa, 0xff, 0xc0,  //@@+%@@@@@
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f00c () , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x07, 0x00,  //......+@.
    0x00, 0x1f, 0x00,  //.....+@@.
    0x38, 0x7d, 0x00,  //.@%.+@@..
    0x3f, 0xf4, 0x00,  //.@@@@@...
    0x0f, 0xd0, 0x00,  //..@@@....
    0x03, 0x40, 0x00,  //...@+....
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f00d () , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x60, 0xd0,  //+%..%+
    0xff, 0xf0,  //@@@@@%
    0x3f, 0xc0,  //.@@@@.
    0x3f, 0xc0,  //.@@@@.
    0xff, 0xe0,  //@@@@@%
    0xb0, 0xd0,  //%@..@+
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+f011 () , Width: 8 */
    0x01, 0x00,  //...+....
    0x03, 0x00,  //...@....
    0x37, 0x70,  //.@+@+@..
    0xb3, 0x38,  //%@.@.%%.
    0xd3, 0x0c,  //@+.@..@.
    0xc0, 0x0c,  //@.....@.
    0xe0, 0x1c,  //@+...+@.
    0x74, 0x74,  //+@+.+@+.
    0x1f, 0xd0,  //.+@@@+..
    0x00, 0x00,  //........


    /*Unicode: U+f013 () , Width: 8 */
    0x00, 0x00,  //........
    0x03, 0x80,  //...@%...
    0x3f, 0xf8,  //.@@@@@%.
    0x3e, 0xf4,  //.@@%@@+.
    0xf8, 0x3e,  //@@%..@@%
    0xbc, 0x7d,  //%@@.+@@+
    0x3f, 0xf8,  //.@@@@@%.
    0x27, 0xe4,  //.%+@%%+.
    0x02, 0x40,  //...%+...
    0x00, 0x00,  //........


    /*Unicode: U+f014 () , Width: 8 */
    0x00, 0x00,  //........
    0x0a, 0x80,  //..%%%...
    0xbe, 0xfc,  //%@@%@@@.
    0x50, 0x04,  //++....+.
    0x5a, 0x54,  //++%%+++.
    0x5a, 0x54,  //++%%+++.
    0x5a, 0x54,  //++%%+++.
    0x50, 0x04,  //++....+.
    0x2a, 0xa0,  //.%%%%%..
    0x00, 0x00,  //........


    /*Unicode: U+f015 () , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x04, 0x00,  //......+..
    0x07, 0xec, 0x00,  //..+@@%@..
    0x2b, 0xec, 0x00,  //.%%@%%@..
    0xaf, 0xfb, 0x00,  //%%@@@@%%.
    0x3f, 0xfc, 0x00,  //.@@@@@@..
    0x3c, 0x3c, 0x00,  //.@@..@@..
    0x3c, 0x3c, 0x00,  //.@@..@@..
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f019 () , Width: 9 */
    0x01, 0x40, 0x00,  //...++....
    0x03, 0xc0, 0x00,  //...@@....
    0x03, 0xc0, 0x00,  //...@@....
    0x1f, 0xf4, 0x00,  //.+@@@@+..
    0x07, 0xe0, 0x00,  //..+@@%...
    0x56, 0x95, 0x00,  //+++%%+++.
    0xff, 0xff, 0x40,  //@@@@@@@@+
    0xff, 0xff, 0x00,  //@@@@@@@@.
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f01c () , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x2f, 0xf4,  //.%@@@@+.
    0x30, 0x0c,  //.@....@.
    0x90, 0x09,  //%+....%+
    0xf8, 0x3e,  //@@%..@@%
    0xff, 0xfe,  //@@@@@@@%
    0xff, 0xfe,  //@@@@@@@%
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+f021 () , Width: 8 */
    0x00, 0x00,  //........
    0x1f, 0xf6,  //.+@@@@+%
    0x78, 0x2f,  //+@%..%@@
    0xe0, 0x3f,  //%%...@@@
    0x00, 0x00,  //........
    0x54, 0x05,  //+++...++
    0xf8, 0x0d,  //@@%...@+
    0xf8, 0x7c,  //@@%.+@@.
    0x8b, 0xe0,  //%.%@@%..
    0x00, 0x00,  //........


    /*Unicode: U+f026 () , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x07,  //..+@
    0xaf,  //%%@@
    0xff,  //@@@@
    0xff,  //@@@@
    0x0f,  //..@@
    0x02,  //...%
    0x00,  //....
    0x00,  //....


    /*Unicode: U+f027 () , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x07, 0x00,  //..+@..
    0xaf, 0x00,  //%%@@..
    0xff, 0x20,  //@@@@.%
    0xff, 0x50,  //@@@@++
    0x0f, 0x00,  //..@@..
    0x02, 0x00,  //...%..
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+f028 () , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x08, 0x00,  //......%..
    0x07, 0x16, 0x00,  //..+@.++%.
    0xaf, 0x19, 0x40,  //%%@@.+%++
    0xff, 0x29, 0x80,  //@@@@.%%+%
    0xff, 0x29, 0x80,  //@@@@.+%+%
    0x0f, 0x26, 0x00,  //..@@.%+%.
    0x02, 0x09, 0x00,  //...%..%+.
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f03e () , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0xd5, 0x55, 0x60,  //@++++++++%
    0x9c, 0x00, 0x20,  //%+@......%
    0x9c, 0x1c, 0x20,  //%+@..+@..%
    0x80, 0x7f, 0x20,  //%...+@@@.%
    0x8f, 0xff, 0x60,  //%.@@@@@@+%
    0xaf, 0xff, 0x60,  //%%@@@@@@+%
    0x80, 0x00, 0x20,  //%........%
    0xaa, 0xaa, 0x90,  //%%%%%%%%%+
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f040 () , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x28,  //.....%%.
    0x00, 0x7d,  //....+@@+
    0x02, 0xed,  //...%@+@+
    0x0a, 0xf0,  //..%%@@..
    0x2f, 0xd0,  //.%%@@+..
    0xef, 0x40,  //%%@@+...
    0xdd, 0x00,  //@.@+....
    0xa4, 0x00,  //%%+.....
    0x00, 0x00,  //........


    /*Unicode: U+f048 () , Width: 6 */
    0x00, 0x00,  //......
    0xc0, 0x80,  //@...%.
    0xc2, 0xc0,  //@..%@.
    0xcb, 0xc0,  //@.%@@.
    0xef, 0xc0,  //@%@@@.
    0xef, 0xc0,  //@%@@@.
    0xc7, 0xc0,  //@.+@@.
    0xc1, 0xc0,  //@..+@.
    0x80, 0x40,  //%...+.
    0x00, 0x00,  //......


    /*Unicode: U+f04b () , Width: 7 */
    0x00, 0x00,  //.......
    0xd0, 0x00,  //@+.....
    0xfd, 0x00,  //@@@+...
    0xff, 0x80,  //@@@@%..
    0xff, 0xf8,  //@@@@@@%
    0xff, 0xe0,  //@@@@@%.
    0xff, 0x40,  //@@@@+..
    0xf4, 0x00,  //@@+....
    0x40, 0x00,  //+......
    0x00, 0x00,  //.......


    /*Unicode: U+f04c () , Width: 8 */
    0x00, 0x00,  //........
    0xfc, 0x3f,  //@@@..@@@
    0xfc, 0x3f,  //@@@..@@@
    0xfc, 0x3f,  //@@@..@@@
    0xfc, 0x3f,  //@@@..@@@
    0xfc, 0x3f,  //@@@..@@@
    0xfc, 0x3f,  //@@@..@@@
    0xfc, 0x3f,  //@@@..@@@
    0xa8, 0x2a,  //%%%..%%%
    0x00, 0x00,  //........


    /*Unicode: U+f04d () , Width: 8 */
    0x00, 0x00,  //........
    0xff, 0xfe,  //@@@@@@@%
    0xff, 0xfe,  //@@@@@@@%
    0xff, 0xfe,  //@@@@@@@%
    0xff, 0xfe,  //@@@@@@@%
    0xff, 0xfe,  //@@@@@@@%
    0xff, 0xfe,  //@@@@@@@%
    0xff, 0xfe,  //@@@@@@@%
    0xaa, 0xa9,  //%%%%%%%+
    0x00, 0x00,  //........


    /*Unicode: U+f051 () , Width: 6 */
    0x00, 0x00,  //......
    0x80, 0xc0,  //%...@.
    0xe0, 0xc0,  //@%..@.
    0xf8, 0xc0,  //@@%.@.
    0xfe, 0xc0,  //@@@%@.
    0xfe, 0xc0,  //@@@%@.
    0xf4, 0xc0,  //@@+.@.
    0xd0, 0xc0,  //@+..@.
    0x40, 0x80,  //+...%.
    0x00, 0x00,  //......


    /*Unicode: U+f052 () , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x07, 0xc0,  //..+@@...
    0x1f, 0xf0,  //.+@@@@..
    0x7f, 0xfc,  //+@@@@@@.
    0x55, 0x55,  //+++++++.
    0xff, 0xfe,  //@@@@@@@%
    0xff, 0xfe,  //@@@@@@@%
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+f053 () , Width: 6 */
    0x00, 0x90,  //....%+
    0x03, 0xe0,  //...@@%
    0x0f, 0x80,  //..@@%.
    0x3e, 0x00,  //.@@%..
    0x3e, 0x00,  //.@@%..
    0x0f, 0x80,  //..@@%.
    0x03, 0xe0,  //...@@%
    0x00, 0xe0,  //....@%
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+f054 () , Width: 6 */
    0x34, 0x00,  //.@+...
    0x7d, 0x00,  //+@@+..
    0x1f, 0x40,  //.+@@+.
    0x07, 0xd0,  //..+@@+
    0x07, 0xd0,  //..+@@+
    0x1f, 0x40,  //.+@@+.
    0x3d, 0x00,  //.@@+..
    0x34, 0x00,  //.@+...
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+f067 () , Width: 8 */
    0x00, 0x00,  //........
    0x07, 0x40,  //..+@+...
    0x07, 0x40,  //..+@+...
    0x5b, 0x94,  //++%@%++.
    0xff, 0xfc,  //@@@@@@@.
    0x5b, 0x94,  //++%@%++.
    0x07, 0x40,  //..+@+...
    0x07, 0x40,  //..+@+...
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+f068 () , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xff, 0xfc,  //@@@@@@@.
    0xff, 0xfc,  //@@@@@@@.
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+f071 () , Width: 9 */
    0x00, 0x40, 0x00,  //....+....
    0x01, 0xd0, 0x00,  //...+@+...
    0x03, 0xf0, 0x00,  //...@@@...
    0x0b, 0x38, 0x00,  //..%@.@%..
    0x0f, 0x3c, 0x00,  //..@@.@@..
    0x2f, 0xbe, 0x00,  //.%@@%@@%.
    0x3f, 0x3f, 0x00,  //.@@@.@@@.
    0xbf, 0x3f, 0x80,  //%@@@.@@@%
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f074 () , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x03, 0x00,  //.......@.
    0xfc, 0xff, 0xc0,  //@@@.@@@@@
    0x0a, 0xc3, 0x00,  //..%%@..@.
    0x03, 0x00, 0x00,  //...@.....
    0x0a, 0x83, 0x00,  //..%%%..@.
    0xfc, 0xff, 0xc0,  //@@@.@@@@@
    0x00, 0x03, 0x00,  //.......@.
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f077 () , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x03, 0xc0, 0x00,  //...@@....
    0x0f, 0xf0, 0x00,  //..@@@@...
    0x3e, 0xbc, 0x00,  //.@@%%@@..
    0xf8, 0x2f, 0x00,  //@@%..%@@.
    0x60, 0x09, 0x00,  //+%....%+.
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f078 () , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xb0, 0x0a, 0x00,  //+%....%%.
    0xbc, 0x2f, 0x00,  //%@@..%@@.
    0x2f, 0xbc, 0x00,  //.%@@%@@..
    0x0b, 0xf0, 0x00,  //..%@@@...
    0x02, 0xc0, 0x00,  //...%@....
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f079 () , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x33, 0xff, 0x00,  //.@.@@@@@..
    0xfc, 0x07, 0x00,  //@@@...+@..
    0x78, 0x03, 0x00,  //+@%....@..
    0x30, 0x0b, 0x40,  //.@....%@+.
    0x34, 0x0f, 0xc0,  //.@+...@@@.
    0x3f, 0xf3, 0x00,  //.@@@@@.@..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f07b () , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0xfe, 0x00, 0x00,  //@@@%.....
    0xff, 0xfe, 0x00,  //@@@@@@@%.
    0xff, 0xff, 0x40,  //@@@@@@@@+
    0xff, 0xff, 0x40,  //@@@@@@@@+
    0xff, 0xff, 0x40,  //@@@@@@@@+
    0xff, 0xff, 0x40,  //@@@@@@@@+
    0xbf, 0xff, 0x00,  //%@@@@@@@.
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f093 () , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x03, 0xc0, 0x00,  //...@@....
    0x0f, 0xf0, 0x00,  //..@@@@...
    0x07, 0xd4, 0x00,  //..+@@+...
    0x03, 0xc0, 0x00,  //...@@....
    0x03, 0xc0, 0x00,  //...@@....
    0xfd, 0x6f, 0x00,  //@@%++%@@.
    0xff, 0xfe, 0x40,  //@@@@@@@%+
    0xaa, 0xaa, 0x00,  //%%%%%%%%.
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f095 () , Width: 8 */
    0x00, 0x00,  //........
    0xb0, 0x00,  //%@......
    0xf4, 0x00,  //@@+.....
    0xf0, 0x00,  //@@......
    0x70, 0x00,  //+@......
    0x2c, 0x10,  //.%@..+..
    0x0b, 0xfc,  //..%@@@@.
    0x01, 0xf8,  //...+@@%.
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+f0c4 () , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x78, 0x00, 0x00,  //+@%.......
    0x87, 0x01, 0x40,  //%.+@...++.
    0x67, 0x54, 0x40,  //+%+@.+..+.
    0x15, 0x84, 0x00,  //..++%.+...
    0x2e, 0x65, 0x00,  //.%@%+%++..
    0x93, 0x04, 0x40,  //%+.@..+.+.
    0x86, 0x01, 0x40,  //%.+%...++.
    0x78, 0x00, 0x00,  //+@%.......
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f0c5 () , Width: 9 */
    0x06, 0xa0, 0x00,  //..+%%%...
    0x1c, 0x20, 0x00,  //.+@..%...
    0x98, 0x3a, 0x80,  //%+%..@%%%
    0xe8, 0x74, 0x80,  //@%%.+@+.%
    0x81, 0x84, 0x80,  //%..+%.+.%
    0x83, 0xa4, 0x80,  //%..@%%+.%
    0xc2, 0x00, 0x80,  //@..%....%
    0x02, 0x00, 0x80,  //...%....%
    0x03, 0xaa, 0xc0,  //...@%%%%@
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f0c7 () , Width: 8 */
    0x00, 0x00,  //........
    0xff, 0xf0,  //@@@@@@..
    0xac, 0x8c,  //%%@.%.@.
    0xaf, 0xc2,  //%%@@@..%
    0x80, 0x02,  //%......%
    0x9a, 0xa2,  //%+%%%%.%
    0xa0, 0x16,  //%%...++%
    0xa0, 0x16,  //%%...++%
    0xaa, 0xaa,  //%%%%%%%%
    0x00, 0x00,  //........


    /*Unicode: U+f0e7 () , Width: 5 */
    0x00, 0x00,  //.....
    0x3c, 0x00,  //.@@..
    0x78, 0x00,  //+@%..
    0xbb, 0x40,  //%@%@+
    0xff, 0x00,  //@@@@.
    0x4d, 0x00,  //+.@+.
    0x0c, 0x00,  //..@..
    0x18, 0x00,  //.+%..
    0x20, 0x00,  //.%...
    0x00, 0x00,  //.....


    /*Unicode: U+f0f3 () , Width: 9 */
    0x00, 0x40, 0x00,  //....+....
    0x07, 0xe0, 0x00,  //..+@@%...
    0x0f, 0xf4, 0x00,  //..@@@@+..
    0x1f, 0xf8, 0x00,  //.+@@@@%..
    0x1f, 0xfc, 0x00,  //.+@@@@@..
    0x2f, 0xfc, 0x00,  //.%@@@@@..
    0x3f, 0xfd, 0x00,  //.@@@@@@+.
    0xff, 0xff, 0x00,  //@@@@@@@@.
    0x17, 0xe5, 0x00,  //.++@@%++.
    0x01, 0x80, 0x00,  //...+%....


    /*Unicode: U+f11c () , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0xaa, 0xaa, 0x90,  //%%%%%%%%%+
    0x80, 0x00, 0x20,  //%........%
    0x80, 0x01, 0x60,  //%......++%
    0x95, 0x46, 0x60,  //%++++..%.%
    0x91, 0x54, 0x20,  //%+.++++..%
    0xea, 0xaa, 0xa0,  //@%%%%%%%%%
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f124 () , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x04,  //......+
    0x00, 0x7c,  //....+@@
    0x07, 0xf4,  //..+@@@+
    0x7f, 0xf0,  //+@@@@@.
    0x57, 0xd0,  //+++@@+.
    0x03, 0xc0,  //...@@..
    0x03, 0x40,  //...@+..
    0x01, 0x00,  //...+...
    0x00, 0x00,  //.......


    /*Unicode: U+f15b () , Width: 8 */
    0xff, 0x50,  //@@@@++..
    0xff, 0x74,  //@@@@+@+.
    0xff, 0x98,  //@@@@%+%.
    0xff, 0xfe,  //@@@@@@@%
    0xff, 0xfe,  //@@@@@@@%
    0xff, 0xfe,  //@@@@@@@%
    0xff, 0xfe,  //@@@@@@@%
    0xff, 0xfe,  //@@@@@@@%
    0xff, 0xfe,  //@@@@@@@%
    0x00, 0x00,  //........


    /*Unicode: U+f1eb () , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x0b, 0xfe, 0x00,  //..%@@@@%..
    0x7e, 0x57, 0xd0,  //+@@++++@@+
    0x57, 0xfd, 0x60,  //+++@@@@++%
    0x1d, 0x57, 0x40,  //.+@++++@+.
    0x02, 0xfc, 0x00,  //...%@@@...
    0x01, 0x54, 0x00,  //...++++...
    0x00, 0x60, 0x00,  //....+%....
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f240 () , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0xaa, 0xaa, 0xa8,  //%%%%%%%%%%%.
    0x85, 0x55, 0x48,  //%.+++++++.%.
    0xaf, 0xff, 0xe6,  //%%@@@@@@@%+%
    0xaf, 0xff, 0xe2,  //%%@@@@@@@%.%
    0xaf, 0xff, 0xe2,  //%%@@@@@@@%.%
    0x9a, 0xaa, 0x98,  //%+%%%%%%%+%.
    0xaa, 0xaa, 0xac,  //%%%%%%%%%%%.
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+f241 () , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0xaa, 0xaa, 0xa8,  //%%%%%%%%%%%.
    0x85, 0x55, 0x08,  //%.+++++...%.
    0xaf, 0xfe, 0x06,  //%%@@@@@%..+%
    0xaf, 0xfe, 0x02,  //%%@@@@@%...%
    0xaf, 0xfe, 0x02,  //%%@@@@@%...%
    0x9a, 0xa9, 0x08,  //%+%%%%%+..%.
    0xaa, 0xaa, 0xac,  //%%%%%%%%%%%.
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+f242 () , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0xaa, 0xaa, 0xa8,  //%%%%%%%%%%%.
    0x85, 0x50, 0x08,  //%.++++....%.
    0xaf, 0xf0, 0x06,  //%%@@@@....+%
    0xaf, 0xf0, 0x02,  //%%@@@@.....%
    0xaf, 0xf0, 0x02,  //%%@@@@.....%
    0x9a, 0xa0, 0x08,  //%+%%%+....%.
    0xaa, 0xaa, 0xac,  //%%%%%%%%%%%.
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+f243 () , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0xaa, 0xaa, 0xa8,  //%%%%%%%%%%%.
    0x85, 0x00, 0x08,  //%.++......%.
    0xaf, 0x00, 0x06,  //%%@@......+%
    0xaf, 0x00, 0x02,  //%%@@.......%
    0xaf, 0x00, 0x02,  //%%@@.......%
    0x9a, 0x00, 0x08,  //%+%%......%.
    0xaa, 0xaa, 0xac,  //%%%%%%%%%%%.
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+f244 () , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0xaa, 0xaa, 0xa8,  //%%%%%%%%%%%.
    0x80, 0x00, 0x08,  //%.........%.
    0x80, 0x00, 0x06,  //%.........+%
    0x80, 0x00, 0x02,  //%..........%
    0x80, 0x00, 0x02,  //%..........%
    0x80, 0x00, 0x08,  //%.........%.
    0xaa, 0xaa, 0xac,  //%%%%%%%%%%%.
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+f293 () , Width: 8 */
    0x0b, 0xf0,  //..%@@@..
    0x1f, 0x3c,  //.+@@.@@.
    0x3b, 0x1d,  //.@%@.+@+
    0x3d, 0x1e,  //.@@+.+@%
    0x3e, 0x3e,  //.@@%.@@%
    0x3d, 0x1e,  //.@@+.+@%
    0x3b, 0x1d,  //.@%@.+@+
    0x1f, 0x3c,  //.+@@.@@.
    0x0b, 0xf0,  //..%@@@..
    0x00, 0x00,  //........



#elif USE_LV_FONT_SYMBOL_10 == 4
    /*Unicode: U+f001 () , Width: 8 */
    0x00, 0x00, 0x00, 0x22,  //........
    0x00, 0x04, 0x9d, 0xfb,  //...+%@@%
    0x00, 0xbf, 0xff, 0xfb,  //..%@@@@%
    0x00, 0xbf, 0xfb, 0x7b,  //..%@@%+%
    0x00, 0xb5, 0x00, 0x0b,  //..%+...%
    0x00, 0xb0, 0x01, 0x1b,  //..%....%
    0x00, 0xb0, 0x6f, 0xfb,  //..%.+@@%
    0xbd, 0xe0, 0x29, 0xa3,  //%@@..%%.
    0xdf, 0xa0, 0x00, 0x00,  //@@%.....
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f008 () , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xcc, 0xfb, 0xbb, 0xcf, 0xc8,  //@@@%%%@@@%
    0xc0, 0xb0, 0x00, 0x0c, 0x0b,  //@.%....%.%
    0xfc, 0xb0, 0x00, 0x0e, 0xcb,  //@@%....@@%
    0xc0, 0xc0, 0x00, 0x0c, 0x0b,  //@.@....@.%
    0xfc, 0xfb, 0xbb, 0xbf, 0xcb,  //@%@%%%%@%%
    0xd4, 0xb0, 0x00, 0x0c, 0x4b,  //@+%....@+%
    0xd4, 0xb0, 0x00, 0x0c, 0x4b,  //@+%....@+%
    0xcc, 0xfb, 0xbb, 0xbf, 0xc8,  //@%@%%%%@%%
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f00b () , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xef, 0x8b, 0xff, 0xff, 0xe0,  //@@+%@@@@@
    0xde, 0x7a, 0xee, 0xee, 0xd0,  //@@+%@@@@@
    0x56, 0x24, 0x66, 0x66, 0x50,  //++.++++++
    0xff, 0x9c, 0xff, 0xff, 0xf0,  //@@%@@@@@@
    0x67, 0x34, 0x77, 0x77, 0x60,  //++.++++++
    0xde, 0x7a, 0xee, 0xee, 0xd0,  //@@+%@@@@@
    0xef, 0x8b, 0xff, 0xff, 0xe0,  //@@+%@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f00c () , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x7d, 0x10,  //......+@.
    0x01, 0x00, 0x07, 0xff, 0x20,  //.....+@@.
    0x2e, 0xa0, 0x7f, 0xf4, 0x00,  //.@%.+@@..
    0x1e, 0xfd, 0xff, 0x40, 0x00,  //.@@@@@...
    0x02, 0xef, 0xf4, 0x00, 0x00,  //..@@@....
    0x00, 0x2c, 0x40, 0x00, 0x00,  //...@+....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f00d () , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x7b, 0x00, 0xc7,  //+%..%+
    0xcf, 0xcc, 0xfc,  //@@@@@%
    0x1c, 0xff, 0xc0,  //.@@@@.
    0x1c, 0xff, 0xc0,  //.@@@@.
    0xcf, 0xcc, 0xfb,  //@@@@@%
    0x8c, 0x11, 0xc7,  //%@..@+
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+f011 () , Width: 8 */
    0x00, 0x05, 0x00, 0x00,  //...+....
    0x00, 0x0f, 0x20, 0x00,  //...@....
    0x1c, 0x4f, 0x4d, 0x20,  //.@+@+@..
    0x9d, 0x1f, 0x2c, 0xb0,  //%@.@.%%.
    0xe4, 0x0d, 0x12, 0xf1,  //@+.@..@.
    0xf3, 0x00, 0x00, 0xf1,  //@.....@.
    0xc8, 0x00, 0x05, 0xe0,  //@+...+@.
    0x4f, 0x73, 0x6e, 0x60,  //+@+.+@+.
    0x04, 0xdf, 0xd5, 0x00,  //.+@@@+..
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f013 () , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x02, 0x0f, 0x81, 0x00,  //...@%...
    0x2f, 0xdf, 0xee, 0xa0,  //.@@@@@%.
    0x0e, 0xfa, 0xdf, 0x70,  //.@@%@@+.
    0xff, 0xa0, 0x1f, 0xf8,  //@@%..@@%
    0x8f, 0xd1, 0x5f, 0xc4,  //%@@.+@@+
    0x1e, 0xff, 0xff, 0x90,  //.@@@@@%.
    0x0a, 0x7f, 0xc9, 0x50,  //.%+@%%+.
    0x00, 0x08, 0x40, 0x00,  //...%+...
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f014 () , Width: 8 */
    0x00, 0x01, 0x10, 0x00,  //........
    0x00, 0xb8, 0xb1, 0x00,  //..%%%...
    0xbc, 0xcb, 0xcc, 0xc0,  //%@@%@@@.
    0x54, 0x11, 0x03, 0x60,  //++....+.
    0x55, 0x9a, 0x75, 0x60,  //++%%+++.
    0x55, 0x9a, 0x75, 0x60,  //++%%+++.
    0x55, 0x9a, 0x75, 0x60,  //++%%+++.
    0x54, 0x00, 0x03, 0x60,  //++....+.
    0x1b, 0xbb, 0xbb, 0x20,  //.%%%%%..
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f015 () , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x03, 0x31, 0x60, 0x00,  //......+..
    0x00, 0x5c, 0xca, 0xf0, 0x00,  //..+@@%@..
    0x08, 0xbc, 0xcb, 0xf0, 0x00,  //.%%@%%@..
    0xab, 0xdf, 0xfd, 0xac, 0x00,  //%%@@@@%%.
    0x2f, 0xff, 0xff, 0xf2, 0x00,  //.@@@@@@..
    0x0f, 0xf3, 0x3f, 0xf0, 0x00,  //.@@..@@..
    0x0f, 0xf2, 0x2f, 0xf0, 0x00,  //.@@..@@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f019 () , Width: 9 */
    0x00, 0x06, 0x60, 0x00, 0x00,  //...++....
    0x00, 0x0e, 0xf0, 0x00, 0x00,  //...@@....
    0x00, 0x2e, 0xf2, 0x00, 0x00,  //...@@....
    0x05, 0xff, 0xff, 0x60, 0x00,  //.+@@@@+..
    0x00, 0x7f, 0xf8, 0x00, 0x00,  //..+@@%...
    0x55, 0x48, 0x94, 0x55, 0x00,  //+++%%+++.
    0xff, 0xfd, 0xde, 0xed, 0x40,  //@@@@@@@@+
    0xff, 0xff, 0xfe, 0xfe, 0x30,  //@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f01c () , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x0b, 0xff, 0xff, 0x70,  //.%@@@@+.
    0x3c, 0x00, 0x01, 0xe0,  //.@....@.
    0xb4, 0x00, 0x00, 0x86,  //%+....%+
    0xfe, 0xb0, 0x1d, 0xeb,  //@@%..@@%
    0xff, 0xfe, 0xff, 0xfb,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xfa,  //@@@@@@@%
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f021 () , Width: 8 */
    0x00, 0x02, 0x20, 0x00,  //........
    0x05, 0xef, 0xfd, 0x5a,  //.+@@@@+%
    0x4f, 0x92, 0x2a, 0xfe,  //+@%..%@@
    0xca, 0x00, 0x0c, 0xfd,  //%%...@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x67, 0x50, 0x00, 0x45,  //+++...++
    0xff, 0x80, 0x00, 0xe7,  //@@%...@+
    0xff, 0xb3, 0x4c, 0xd0,  //@@%.+@@.
    0x83, 0xbe, 0xe9, 0x10,  //%.%@@%..
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f026 () , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x02,  //....
    0x00, 0x6d,  //..+@
    0x8a, 0xfd,  //%%@@
    0xff, 0xfd,  //@@@@
    0xff, 0xfd,  //@@@@
    0x00, 0xcd,  //..@@
    0x00, 0x08,  //...%
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+f027 () , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x02, 0x00,  //......
    0x00, 0x6d, 0x00,  //..+@..
    0x8a, 0xfd, 0x32,  //%%@@..
    0xff, 0xfd, 0x1b,  //@@@@.%
    0xff, 0xfd, 0x46,  //@@@@++
    0x00, 0xcd, 0x00,  //..@@..
    0x00, 0x08, 0x00,  //...%..
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+f028 () , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x02, 0x03, 0x91, 0x00,  //......%..
    0x00, 0x6d, 0x07, 0x4b, 0x00,  //..+@.++%.
    0x8a, 0xfd, 0x05, 0xb5, 0x70,  //%%@@.+%++
    0xff, 0xfd, 0x0b, 0x84, 0xa0,  //@@@@.%%+%
    0xff, 0xfd, 0x18, 0xb4, 0x90,  //@@@@.+%+%
    0x00, 0xcd, 0x09, 0x6a, 0x20,  //..@@.%+%.
    0x00, 0x08, 0x02, 0xa5, 0x00,  //...%..%+.
    0x00, 0x00, 0x01, 0x10, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f03e () , Width: 10 */
    0x13, 0x33, 0x33, 0x33, 0x30,  //..........
    0xc6, 0x66, 0x66, 0x66, 0x7a,  //@++++++++%
    0xb6, 0xd1, 0x00, 0x00, 0x0b,  //%+@......%
    0xb6, 0xe2, 0x05, 0xc1, 0x0b,  //%+@..+@..%
    0xb0, 0x10, 0x5f, 0xfd, 0x1b,  //%...+@@@.%
    0xb1, 0xcd, 0xff, 0xff, 0x5b,  //%.@@@@@@+%
    0xb9, 0xff, 0xff, 0xff, 0x5b,  //%%@@@@@@+%
    0xb2, 0x33, 0x33, 0x33, 0x1b,  //%........%
    0x8b, 0xbb, 0xbb, 0xbb, 0xb5,  //%%%%%%%%%+
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f040 () , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x0b, 0x90,  //.....%%.
    0x00, 0x00, 0x6d, 0xf7,  //....+@@+
    0x00, 0x1b, 0xd8, 0xd5,  //...%@+@+
    0x01, 0xbb, 0xff, 0x20,  //..%%@@..
    0x1b, 0xcf, 0xf5, 0x00,  //.%%@@+..
    0xca, 0xff, 0x60, 0x00,  //%%@@+...
    0xe4, 0xd6, 0x00, 0x00,  //@.@+....
    0xbb, 0x60, 0x00, 0x00,  //%%+.....
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f048 () , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0xf2, 0x00, 0x90,  //@...%.
    0xf2, 0x09, 0xf0,  //@..%@.
    0xf2, 0x9f, 0xf0,  //@.%@@.
    0xfb, 0xff, 0xf0,  //@%@@@.
    0xf8, 0xff, 0xf0,  //@%@@@.
    0xf2, 0x5f, 0xf0,  //@.+@@.
    0xf2, 0x05, 0xf0,  //@..+@.
    0xa1, 0x00, 0x50,  //%...+.
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+f04b () , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0xe6, 0x00, 0x00, 0x00,  //@+.....
    0xff, 0xd4, 0x00, 0x00,  //@@@+...
    0xff, 0xff, 0xb2, 0x00,  //@@@@%..
    0xff, 0xff, 0xff, 0x90,  //@@@@@@%
    0xff, 0xff, 0xfb, 0x30,  //@@@@@%.
    0xff, 0xfd, 0x40, 0x00,  //@@@@+..
    0xfe, 0x60, 0x00, 0x00,  //@@+....
    0x70, 0x00, 0x00, 0x00,  //+......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+f04c () , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xf2, 0x2f, 0xff,  //@@@..@@@
    0xff, 0xf3, 0x3f, 0xff,  //@@@..@@@
    0xff, 0xf3, 0x3f, 0xff,  //@@@..@@@
    0xff, 0xf3, 0x3f, 0xff,  //@@@..@@@
    0xff, 0xf3, 0x3f, 0xff,  //@@@..@@@
    0xff, 0xf3, 0x3f, 0xff,  //@@@..@@@
    0xff, 0xf3, 0x3f, 0xff,  //@@@..@@@
    0xab, 0xb1, 0x2b, 0xba,  //%%%..%%%
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f04d () , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xfa,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xfb,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xfb,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xfb,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xfb,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xfb,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xfb,  //@@@@@@@%
    0xab, 0xbb, 0xbb, 0xb7,  //%%%%%%%+
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f051 () , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x90, 0x00, 0xf0,  //%...@.
    0xea, 0x01, 0xf1,  //@%..@.
    0xef, 0xa1, 0xf1,  //@@%.@.
    0xef, 0xfb, 0xf1,  //@@@%@.
    0xef, 0xf8, 0xf1,  //@@@%@.
    0xef, 0x61, 0xf1,  //@@+.@.
    0xe6, 0x01, 0xf1,  //@+..@.
    0x50, 0x00, 0xb0,  //+...%.
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+f052 () , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x03, 0x10, 0x00,  //........
    0x00, 0x4f, 0xd1, 0x00,  //..+@@...
    0x04, 0xff, 0xfd, 0x10,  //.+@@@@..
    0x4f, 0xff, 0xff, 0xd1,  //+@@@@@@.
    0x56, 0x66, 0x66, 0x64,  //+++++++.
    0xee, 0xee, 0xee, 0xea,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xfa,  //@@@@@@@%
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f053 () , Width: 6 */
    0x00, 0x00, 0xb7,  //....%+
    0x00, 0x0c, 0xfb,  //...@@%
    0x00, 0xcf, 0xb0,  //..@@%.
    0x0c, 0xfb, 0x00,  //.@@%..
    0x0d, 0xfa, 0x00,  //.@@%..
    0x01, 0xdf, 0xa0,  //..@@%.
    0x00, 0x1d, 0xfa,  //...@@%
    0x00, 0x01, 0xd8,  //....@%
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+f054 () , Width: 6 */
    0x2d, 0x40, 0x00,  //.@+...
    0x4f, 0xf4, 0x00,  //+@@+..
    0x05, 0xff, 0x40,  //.+@@+.
    0x00, 0x5f, 0xf4,  //..+@@+
    0x00, 0x4f, 0xf5,  //..+@@+
    0x04, 0xff, 0x50,  //.+@@+.
    0x3f, 0xf5, 0x00,  //.@@+..
    0x2e, 0x50, 0x00,  //.@+...
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+f067 () , Width: 8 */
    0x00, 0x01, 0x00, 0x00,  //........
    0x00, 0x6f, 0x70, 0x00,  //..+@+...
    0x00, 0x6f, 0x70, 0x00,  //..+@+...
    0x67, 0xbf, 0xb7, 0x70,  //++%@%++.
    0xff, 0xff, 0xff, 0xf1,  //@@@@@@@.
    0x56, 0xaf, 0xb6, 0x60,  //++%@%++.
    0x00, 0x6f, 0x70, 0x00,  //..+@+...
    0x00, 0x5f, 0x60, 0x00,  //..+@+...
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f068 () , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xde, 0xee, 0xee, 0xe0,  //@@@@@@@.
    0xef, 0xff, 0xff, 0xf0,  //@@@@@@@.
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f071 () , Width: 9 */
    0x00, 0x00, 0x70, 0x00, 0x00,  //....+....
    0x00, 0x07, 0xf7, 0x00, 0x00,  //...+@+...
    0x00, 0x0e, 0xfe, 0x00, 0x00,  //...@@@...
    0x00, 0x8c, 0x0c, 0x80, 0x00,  //..%@.@%..
    0x01, 0xfd, 0x0d, 0xf1, 0x00,  //..@@.@@..
    0x09, 0xff, 0xbf, 0xf9, 0x00,  //.%@@%@@%.
    0x2f, 0xfd, 0x0d, 0xff, 0x20,  //.@@@.@@@.
    0xaf, 0xfe, 0x2e, 0xff, 0xa0,  //%@@@.@@@%
    0xef, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f074 () , Width: 9 */
    0x00, 0x00, 0x00, 0x01, 0x00,  //.........
    0x21, 0x00, 0x01, 0x2d, 0x30,  //.......@.
    0xff, 0xd2, 0xcf, 0xff, 0xc0,  //@@@.@@@@@
    0x00, 0xab, 0xc1, 0x0c, 0x10,  //..%%@..@.
    0x00, 0x3f, 0x30, 0x00, 0x00,  //...@.....
    0x00, 0xbb, 0xb1, 0x0c, 0x10,  //..%%%..@.
    0xff, 0xd2, 0xcf, 0xff, 0xc0,  //@@@.@@@@@
    0x21, 0x00, 0x01, 0x2d, 0x20,  //.......@.
    0x00, 0x00, 0x00, 0x01, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f077 () , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x10, 0x00, 0x00,  //.........
    0x00, 0x1c, 0xd1, 0x00, 0x00,  //...@@....
    0x01, 0xcf, 0xfd, 0x10, 0x00,  //..@@@@...
    0x1c, 0xfa, 0x9f, 0xd1, 0x00,  //.@@%%@@..
    0xcf, 0xa0, 0x09, 0xfd, 0x00,  //@@%..%@@.
    0x69, 0x00, 0x00, 0x87, 0x00,  //+%....%+.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f078 () , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x8c, 0x00, 0x00, 0xb9, 0x00,  //+%....%%.
    0xbf, 0xc0, 0x0b, 0xfc, 0x00,  //%@@..%@@.
    0x0b, 0xfc, 0xbf, 0xc0, 0x00,  //.%@@%@@..
    0x00, 0xbf, 0xfc, 0x00, 0x00,  //..%@@@...
    0x00, 0x0b, 0xc0, 0x00, 0x00,  //...%@....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f079 () , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x1d, 0x3d, 0xff, 0xff, 0x00,  //.@.@@@@@..
    0xcf, 0xe2, 0x22, 0x4f, 0x00,  //@@@...+@..
    0x6f, 0x82, 0x00, 0x2f, 0x00,  //+@%....@..
    0x0f, 0x20, 0x02, 0x8f, 0x71,  //.@....%@+.
    0x0f, 0x42, 0x22, 0xef, 0xc0,  //.@+...@@@.
    0x0f, 0xff, 0xfd, 0x3d, 0x10,  //.@@@@@.@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f07b () , Width: 9 */
    0x01, 0x10, 0x00, 0x00, 0x00,  //.........
    0xcf, 0xf9, 0x00, 0x00, 0x00,  //@@@%.....
    0xff, 0xff, 0xcc, 0xcb, 0x10,  //@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0x50,  //@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x50,  //@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x50,  //@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0x50,  //@@@@@@@@+
    0xbf, 0xff, 0xff, 0xfe, 0x20,  //%@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f093 () , Width: 9 */
    0x00, 0x01, 0x20, 0x00, 0x00,  //.........
    0x00, 0x1d, 0xe2, 0x00, 0x00,  //...@@....
    0x01, 0xdf, 0xfe, 0x20, 0x00,  //..@@@@...
    0x03, 0x7f, 0xf7, 0x40, 0x00,  //..+@@+...
    0x00, 0x0e, 0xf0, 0x00, 0x00,  //...@@....
    0x00, 0x0e, 0xf0, 0x00, 0x00,  //...@@....
    0xee, 0xc5, 0x5b, 0xee, 0x20,  //@@%++%@@.
    0xff, 0xff, 0xfd, 0xeb, 0x40,  //@@@@@@@%+
    0xbb, 0xbb, 0xbb, 0xbb, 0x20,  //%%%%%%%%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f095 () , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x9e, 0x00, 0x00, 0x00,  //%@......
    0xff, 0x60, 0x00, 0x00,  //@@+.....
    0xcd, 0x00, 0x00, 0x00,  //@@......
    0x6f, 0x30, 0x00, 0x00,  //+@......
    0x0b, 0xd3, 0x06, 0x00,  //.%@..+..
    0x00, 0xbf, 0xdf, 0xe0,  //..%@@@@.
    0x00, 0x06, 0xcf, 0x90,  //...+@@%.
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f0c4 () , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x4c, 0x91, 0x00, 0x00, 0x10,  //+@%.......
    0xb0, 0x6c, 0x00, 0x16, 0x63,  //%.+@...++.
    0x79, 0x6e, 0x45, 0x43, 0x40,  //+%+@.+..+.
    0x04, 0x77, 0xa3, 0x53, 0x00,  //..++%.+...
    0x08, 0xcb, 0x79, 0x45, 0x00,  //.%@%+%++..
    0x95, 0x1f, 0x03, 0x51, 0x60,  //%+.@..+.+.
    0xb1, 0x7b, 0x00, 0x05, 0x63,  //%.+%...++.
    0x4c, 0x90, 0x00, 0x00, 0x00,  //+@%.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f0c5 () , Width: 9 */
    0x00, 0x6b, 0xb9, 0x00, 0x00,  //..+%%%...
    0x07, 0xe0, 0x0b, 0x00, 0x00,  //.+@..%...
    0x87, 0xb0, 0x0c, 0xaa, 0x90,  //%+%..@%%%
    0xeb, 0xa0, 0x4d, 0x70, 0xb0,  //@%%.+@+.%
    0xb0, 0x05, 0xa2, 0x70, 0xb0,  //%..+%.+.%
    0xb0, 0x0e, 0xbb, 0x40, 0xb0,  //%..@%%+.%
    0xc3, 0x3b, 0x00, 0x00, 0xb0,  //@..%....%
    0x33, 0x3b, 0x00, 0x00, 0xb0,  //...%....%
    0x00, 0x0d, 0xbb, 0xbb, 0xd0,  //...@%%%%@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f0c7 () , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0xde, 0xfc, 0xed, 0x30,  //@@@@@@..
    0xba, 0xf1, 0xb1, 0xc3,  //%%@.%.@.
    0xb9, 0xfc, 0xd0, 0x1b,  //%%@@@..%
    0xb0, 0x00, 0x00, 0x0b,  //%......%
    0xb6, 0xbb, 0xbb, 0x3b,  //%+%%%%.%
    0xb9, 0x00, 0x04, 0x6b,  //%%...++%
    0xb9, 0x00, 0x04, 0x6b,  //%%...++%
    0xab, 0xbb, 0xbb, 0xb8,  //%%%%%%%%
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f0e7 () , Width: 5 */
    0x01, 0x10, 0x00,  //.....
    0x1f, 0xf0, 0x00,  //.@@..
    0x5f, 0x90, 0x00,  //+@%..
    0x9f, 0xbc, 0x50,  //%@%@+
    0xdf, 0xfe, 0x00,  //@@@@.
    0x62, 0xc7, 0x00,  //+.@+.
    0x00, 0xe0, 0x00,  //..@..
    0x04, 0x80, 0x00,  //.+%..
    0x08, 0x10, 0x00,  //.%...
    0x01, 0x00, 0x00,  //.....


    /*Unicode: U+f0f3 () , Width: 9 */
    0x00, 0x01, 0x50, 0x00, 0x00,  //....+....
    0x00, 0x5d, 0xf8, 0x00, 0x00,  //..+@@%...
    0x02, 0xff, 0xff, 0x70, 0x00,  //..@@@@+..
    0x06, 0xff, 0xff, 0xb0, 0x00,  //.+@@@@%..
    0x07, 0xff, 0xff, 0xd0, 0x00,  //.+@@@@@..
    0x0a, 0xff, 0xff, 0xf0, 0x00,  //.%@@@@@..
    0x2f, 0xff, 0xff, 0xf6, 0x00,  //.@@@@@@+.
    0xcf, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@.
    0x34, 0x5e, 0xf9, 0x44, 0x00,  //.++@@%++.
    0x00, 0x05, 0x80, 0x00, 0x00,  //...+%....


    /*Unicode: U+f11c () , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xab, 0xbb, 0xbb, 0xbb, 0xb7,  //%%%%%%%%%+
    0xb3, 0x32, 0x23, 0x31, 0x2b,  //%........%
    0xb2, 0x21, 0x12, 0x24, 0x5b,  //%......++%
    0xb7, 0x57, 0x63, 0x4a, 0x4b,  //%++++..%.%
    0xb4, 0x37, 0x77, 0x72, 0x2b,  //%+.++++..%
    0xcb, 0xbb, 0xbb, 0xbb, 0xb9,  //@%%%%%%%%%
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f124 () , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x40,  //......+
    0x00, 0x00, 0x5d, 0xc0,  //....+@@
    0x00, 0x5d, 0xff, 0x40,  //..+@@@+
    0x5d, 0xff, 0xfc, 0x00,  //+@@@@@.
    0x66, 0x6d, 0xf4, 0x00,  //+++@@+.
    0x00, 0x0c, 0xc0, 0x00,  //...@@..
    0x00, 0x0c, 0x40, 0x00,  //...@+..
    0x00, 0x06, 0x00, 0x00,  //...+...
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+f15b () , Width: 8 */
    0xef, 0xff, 0x75, 0x00,  //@@@@++..
    0xff, 0xff, 0x7d, 0x70,  //@@@@+@+.
    0xff, 0xff, 0x87, 0x92,  //@@@@%+%.
    0xff, 0xff, 0xfc, 0xc8,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xfb,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xfb,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xfb,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xfb,  //@@@@@@@%
    0xef, 0xff, 0xff, 0xfa,  //@@@@@@@%
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f1eb () , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x01, 0x8d, 0xff, 0xd8, 0x20,  //..%@@@@%..
    0x5f, 0xd8, 0x55, 0x7c, 0xf7,  //+@@++++@@+
    0x67, 0x6c, 0xff, 0xd7, 0x68,  //+++@@@@++%
    0x04, 0xf7, 0x44, 0x6e, 0x60,  //.+@++++@+.
    0x00, 0x1b, 0xff, 0xc2, 0x00,  //...%@@@...
    0x00, 0x07, 0x55, 0x70, 0x00,  //...++++...
    0x00, 0x00, 0x79, 0x00, 0x00,  //....+%....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f240 () , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x8b, 0xbb, 0xbb, 0xbb, 0xbb, 0x80,  //%%%%%%%%%%%.
    0xb3, 0x55, 0x55, 0x55, 0x53, 0xb0,  //%.+++++++.%.
    0xb9, 0xff, 0xff, 0xff, 0xf9, 0x78,  //%%@@@@@@@%+%
    0xb9, 0xff, 0xff, 0xff, 0xf9, 0x0a,  //%%@@@@@@@%.%
    0xb9, 0xff, 0xff, 0xff, 0xf9, 0x39,  //%%@@@@@@@%.%
    0xb6, 0x99, 0x99, 0x99, 0x96, 0xb1,  //%+%%%%%%%+%.
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xc0,  //%%%%%%%%%%%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+f241 () , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x8b, 0xbb, 0xbb, 0xbb, 0xbb, 0x80,  //%%%%%%%%%%%.
    0xb3, 0x55, 0x55, 0x54, 0x00, 0xb0,  //%.+++++...%.
    0xb9, 0xff, 0xff, 0xfb, 0x00, 0x78,  //%%@@@@@%..+%
    0xb9, 0xff, 0xff, 0xfb, 0x00, 0x0a,  //%%@@@@@%...%
    0xb9, 0xff, 0xff, 0xfb, 0x00, 0x39,  //%%@@@@@%...%
    0xb6, 0x99, 0x99, 0x97, 0x00, 0xb1,  //%+%%%%%+..%.
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xc0,  //%%%%%%%%%%%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+f242 () , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x8b, 0xbb, 0xbb, 0xbb, 0xbb, 0x80,  //%%%%%%%%%%%.
    0xb3, 0x55, 0x54, 0x00, 0x00, 0xb0,  //%.++++....%.
    0xb9, 0xff, 0xfc, 0x00, 0x00, 0x78,  //%%@@@@....+%
    0xb9, 0xff, 0xfc, 0x00, 0x00, 0x0a,  //%%@@@@.....%
    0xb9, 0xff, 0xfc, 0x00, 0x00, 0x39,  //%%@@@@.....%
    0xb6, 0x99, 0x98, 0x00, 0x00, 0xb1,  //%+%%%+....%.
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xc0,  //%%%%%%%%%%%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+f243 () , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x8b, 0xbb, 0xbb, 0xbb, 0xbb, 0x80,  //%%%%%%%%%%%.
    0xb3, 0x55, 0x00, 0x00, 0x00, 0xb0,  //%.++......%.
    0xb9, 0xfe, 0x00, 0x00, 0x00, 0x78,  //%%@@......+%
    0xb9, 0xfe, 0x00, 0x00, 0x00, 0x0a,  //%%@@.......%
    0xb9, 0xfe, 0x00, 0x00, 0x00, 0x39,  //%%@@.......%
    0xb6, 0x99, 0x00, 0x00, 0x00, 0xb1,  //%+%%......%.
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xc0,  //%%%%%%%%%%%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+f244 () , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x8b, 0xbb, 0xbb, 0xbb, 0xbb, 0x80,  //%%%%%%%%%%%.
    0xb0, 0x00, 0x00, 0x00, 0x00, 0xb0,  //%.........%.
    0xb0, 0x00, 0x00, 0x00, 0x00, 0x78,  //%.........+%
    0xb0, 0x00, 0x00, 0x00, 0x00, 0x0a,  //%..........%
    0xb0, 0x00, 0x00, 0x00, 0x00, 0x39,  //%..........%
    0xb0, 0x00, 0x00, 0x00, 0x00, 0xb1,  //%.........%.
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xc0,  //%%%%%%%%%%%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+f293 () , Width: 8 */
    0x00, 0x8e, 0xec, 0x30,  //..%@@@..
    0x06, 0xff, 0x3e, 0xe1,  //.+@@.@@.
    0x0d, 0xbf, 0x34, 0xe6,  //.@%@.+@+
    0x0f, 0xc4, 0x25, 0xf8,  //.@@+.+@%
    0x0f, 0xf9, 0x0e, 0xf9,  //.@@%.@@%
    0x0f, 0xc4, 0x25, 0xf8,  //.@@+.+@%
    0x0d, 0xbf, 0x34, 0xe6,  //.@%@.+@+
    0x07, 0xff, 0x3e, 0xf1,  //.+@@.@@.
    0x00, 0x8e, 0xec, 0x30,  //..%@@@..
    0x00, 0x00, 0x00, 0x00,  //........



#elif USE_LV_FONT_SYMBOL_10 == 8
    /*Unicode: U+f001 () , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x2e,  //........
    0x00, 0x00, 0x08, 0x4c, 0x96, 0xde, 0xff, 0xba,  //...+%@@%
    0x00, 0x00, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xba,  //..%@@@@%
    0x00, 0x00, 0xba, 0xff, 0xf8, 0xbc, 0x70, 0xba,  //..%@@%+%
    0x00, 0x00, 0xba, 0x54, 0x0e, 0x00, 0x00, 0xba,  //..%+...%
    0x00, 0x00, 0xba, 0x00, 0x00, 0x1e, 0x1a, 0xba,  //..%....%
    0x00, 0x00, 0xba, 0x00, 0x66, 0xff, 0xff, 0xb6,  //..%.+@@%
    0xbe, 0xdc, 0xee, 0x00, 0x24, 0x9e, 0xa6, 0x36,  //%@@..%%.
    0xd4, 0xf6, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f008 () , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xc4, 0xc6, 0xf4, 0xbe, 0xbe, 0xbe, 0xc2, 0xf8, 0xc6, 0x8a,  //@@@%%%@@@%
    0xc2, 0x06, 0xbe, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x06, 0xba,  //@.%....%.%
    0xf4, 0xc2, 0xbe, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xc2, 0xba,  //@@%....@@%
    0xc2, 0x06, 0xc6, 0x00, 0x00, 0x00, 0x02, 0xc4, 0x06, 0xba,  //@.@....@.%
    0xf2, 0xc0, 0xf4, 0xba, 0xba, 0xba, 0xbc, 0xf4, 0xc0, 0xba,  //@%@%%%%@%%
    0xd0, 0x44, 0xbe, 0x00, 0x00, 0x00, 0x00, 0xca, 0x44, 0xba,  //@+%....@+%
    0xd2, 0x44, 0xbe, 0x00, 0x00, 0x00, 0x00, 0xca, 0x44, 0xba,  //@+%....@+%
    0xc4, 0xc0, 0xf2, 0xba, 0xba, 0xba, 0xbc, 0xf4, 0xc0, 0x8c,  //@%@%%%%@%%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f00b () , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xec, 0xff, 0x80, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xec,  //@@+%@@@@@
    0xdc, 0xee, 0x78, 0xa8, 0xee, 0xee, 0xee, 0xee, 0xdc,  //@@+%@@@@@
    0x5c, 0x6e, 0x2e, 0x44, 0x6e, 0x6e, 0x6e, 0x6e, 0x5c,  //++.++++++
    0xff, 0xff, 0x92, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@%@@@@@@
    0x60, 0x72, 0x30, 0x48, 0x72, 0x72, 0x72, 0x72, 0x60,  //++.++++++
    0xd8, 0xea, 0x76, 0xa6, 0xea, 0xea, 0xea, 0xea, 0xd8,  //@@+%@@@@@
    0xec, 0xff, 0x80, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xec,  //@@+%@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f00c () , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xd4, 0x16,  //......+@.
    0x00, 0x16, 0x02, 0x00, 0x00, 0x7e, 0xff, 0xf4, 0x2e,  //.....+@@.
    0x26, 0xee, 0xaa, 0x02, 0x7e, 0xff, 0xf4, 0x40, 0x00,  //.@%.+@@..
    0x1c, 0xe2, 0xff, 0xd4, 0xff, 0xf4, 0x40, 0x00, 0x00,  //.@@@@@...
    0x00, 0x24, 0xe4, 0xff, 0xf4, 0x40, 0x00, 0x00, 0x00,  //..@@@....
    0x00, 0x00, 0x24, 0xce, 0x42, 0x00, 0x00, 0x00, 0x00,  //...@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f00d () , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x7a, 0xbe, 0x0c, 0x0e, 0xc0, 0x74,  //+%..%+
    0xc8, 0xff, 0xc4, 0xca, 0xff, 0xc0,  //@@@@@%
    0x12, 0xce, 0xff, 0xff, 0xca, 0x0e,  //.@@@@.
    0x10, 0xca, 0xff, 0xff, 0xc4, 0x0c,  //.@@@@.
    0xc6, 0xff, 0xca, 0xce, 0xff, 0xbe,  //@@@@@%
    0x82, 0xc6, 0x10, 0x12, 0xc8, 0x7a,  //%@..@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+f011 () , Width: 8 */
    0x00, 0x00, 0x00, 0x56, 0x02, 0x00, 0x00, 0x00,  //...+....
    0x00, 0x00, 0x00, 0xff, 0x24, 0x00, 0x00, 0x00,  //...@....
    0x10, 0xc2, 0x48, 0xff, 0x4e, 0xd0, 0x24, 0x00,  //.@+@+@..
    0x94, 0xdc, 0x12, 0xff, 0x2a, 0xc0, 0xbc, 0x00,  //%@.@.%%.
    0xe6, 0x4c, 0x00, 0xd8, 0x14, 0x24, 0xfc, 0x10,  //@+.@..@.
    0xf6, 0x34, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x1e,  //@.....@.
    0xc8, 0x80, 0x00, 0x00, 0x00, 0x58, 0xe8, 0x02,  //@+...+@.
    0x42, 0xf8, 0x7a, 0x34, 0x68, 0xee, 0x62, 0x00,  //+@+.+@+.
    0x00, 0x46, 0xd0, 0xf8, 0xda, 0x5c, 0x00, 0x00,  //.+@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f013 () , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x24, 0x02, 0xf2, 0x86, 0x1c, 0x08, 0x00,  //...@%...
    0x24, 0xf4, 0xdc, 0xff, 0xee, 0xee, 0xa8, 0x00,  //.@@@@@%.
    0x02, 0xe0, 0xfc, 0xa8, 0xd4, 0xff, 0x72, 0x00,  //.@@%@@+.
    0xf4, 0xff, 0xa8, 0x00, 0x16, 0xff, 0xfc, 0x84,  //@@%..@@%
    0x86, 0xf0, 0xd2, 0x14, 0x54, 0xff, 0xc2, 0x4a,  //%@@.+@@+
    0x1a, 0xec, 0xff, 0xff, 0xff, 0xff, 0x9e, 0x00,  //.@@@@@%.
    0x08, 0xac, 0x78, 0xff, 0xc0, 0x9e, 0x5c, 0x00,  //.%+@%%+.
    0x00, 0x00, 0x00, 0x82, 0x46, 0x00, 0x00, 0x00,  //...%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f014 () , Width: 8 */
    0x00, 0x00, 0x0c, 0x1e, 0x10, 0x00, 0x00, 0x00,  //........
    0x00, 0x0c, 0xbc, 0x86, 0xb6, 0x1a, 0x00, 0x00,  //..%%%...
    0xbe, 0xcc, 0xce, 0xba, 0xca, 0xce, 0xc4, 0x0c,  //%@@%@@@.
    0x5a, 0x46, 0x10, 0x12, 0x0e, 0x36, 0x6e, 0x00,  //++....+.
    0x5a, 0x56, 0x92, 0xa2, 0x7a, 0x5a, 0x6e, 0x00,  //++%%+++.
    0x5a, 0x56, 0x92, 0xa2, 0x7a, 0x5a, 0x6e, 0x00,  //++%%+++.
    0x5a, 0x56, 0x92, 0xa2, 0x7a, 0x5a, 0x6e, 0x00,  //++%%+++.
    0x56, 0x4a, 0x04, 0x04, 0x02, 0x38, 0x6a, 0x00,  //++....+.
    0x16, 0xb2, 0xba, 0xba, 0xba, 0xb6, 0x20, 0x00,  //.%%%%%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f015 () , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x30, 0x36, 0x16, 0x68, 0x00, 0x00,  //......+..
    0x00, 0x00, 0x5e, 0xc8, 0xca, 0xaa, 0xff, 0x00, 0x00,  //..+@@%@..
    0x00, 0x88, 0xbc, 0xc4, 0xc0, 0xb2, 0xff, 0x06, 0x00,  //.%%@%%@..
    0xae, 0xb0, 0xde, 0xff, 0xff, 0xdc, 0xa0, 0xc0, 0x08,  //%%@@@@%%.
    0x28, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x2a, 0x00,  //.@@@@@@..
    0x00, 0xff, 0xff, 0x36, 0x36, 0xff, 0xff, 0x00, 0x00,  //.@@..@@..
    0x00, 0xf6, 0xff, 0x26, 0x26, 0xff, 0xf6, 0x00, 0x00,  //.@@..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f019 () , Width: 9 */
    0x00, 0x00, 0x00, 0x66, 0x6e, 0x00, 0x00, 0x00, 0x00,  //...++....
    0x00, 0x00, 0x00, 0xea, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@....
    0x00, 0x0a, 0x22, 0xec, 0xff, 0x22, 0x0c, 0x00, 0x00,  //...@@....
    0x00, 0x50, 0xff, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00,  //.+@@@@+..
    0x00, 0x00, 0x78, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00,  //..+@@%...
    0x50, 0x56, 0x4e, 0x8c, 0x9c, 0x4a, 0x56, 0x54, 0x08,  //+++%%+++.
    0xff, 0xff, 0xff, 0xdc, 0xd6, 0xe2, 0xee, 0xd2, 0x42,  //@@@@@@@@+
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xec, 0xf6, 0xe0, 0x34,  //@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f01c () , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0xbe, 0xf2, 0xf2, 0xf2, 0xf6, 0x76, 0x00,  //.%@@@@+.
    0x3c, 0xca, 0x00, 0x00, 0x00, 0x1a, 0xe0, 0x08,  //.@....@.
    0xb2, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x8e, 0x6a,  //%+....%+
    0xf8, 0xe2, 0xb4, 0x00, 0x16, 0xdc, 0xea, 0xb0,  //@@%..@@%
    0xff, 0xff, 0xff, 0xea, 0xf0, 0xff, 0xff, 0xb6,  //@@@@@@@%
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xae,  //@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f021 () , Width: 8 */
    0x00, 0x00, 0x02, 0x24, 0x26, 0x00, 0x00, 0x00,  //........
    0x00, 0x52, 0xe4, 0xff, 0xff, 0xd8, 0x54, 0xa6,  //.+@@@@+%
    0x46, 0xfc, 0x96, 0x24, 0x2a, 0xa6, 0xff, 0xe2,  //+@%..%@@
    0xc0, 0xa4, 0x00, 0x00, 0x00, 0xce, 0xff, 0xda,  //%%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x6e, 0x76, 0x5e, 0x00, 0x00, 0x00, 0x42, 0x54,  //+++...++
    0xff, 0xff, 0x86, 0x00, 0x00, 0x0a, 0xe0, 0x74,  //@@%...@+
    0xff, 0xff, 0xb2, 0x3e, 0x42, 0xc6, 0xd2, 0x0c,  //@@%.+@@.
    0x86, 0x3c, 0xb8, 0xec, 0xe6, 0x9a, 0x14, 0x00,  //%.%@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f026 () , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x2c,  //....
    0x00, 0x00, 0x6e, 0xda,  //..+@
    0x8a, 0xa2, 0xff, 0xda,  //%%@@
    0xff, 0xff, 0xff, 0xda,  //@@@@
    0xf6, 0xff, 0xff, 0xda,  //@@@@
    0x00, 0x0e, 0xca, 0xda,  //..@@
    0x00, 0x00, 0x0e, 0x88,  //...%
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+f027 () , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x2c, 0x00, 0x00,  //......
    0x00, 0x00, 0x6e, 0xda, 0x00, 0x00,  //..+@..
    0x8a, 0xa2, 0xff, 0xda, 0x30, 0x22,  //%%@@..
    0xff, 0xff, 0xff, 0xda, 0x12, 0xb0,  //@@@@.%
    0xf6, 0xff, 0xff, 0xda, 0x42, 0x6c,  //@@@@++
    0x00, 0x0e, 0xca, 0xda, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0x0e, 0x88, 0x00, 0x00,  //...%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+f028 () , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x2c, 0x00, 0x30, 0x96, 0x12, 0x00,  //......%..
    0x00, 0x00, 0x6e, 0xda, 0x00, 0x7c, 0x46, 0xb6, 0x0a,  //..+@.++%.
    0x8a, 0xa2, 0xff, 0xda, 0x0c, 0x52, 0xbe, 0x56, 0x76,  //%%@@.+%++
    0xff, 0xff, 0xff, 0xda, 0x04, 0xb2, 0x86, 0x44, 0xae,  //@@@@.%%+%
    0xf6, 0xff, 0xff, 0xda, 0x10, 0x80, 0xb0, 0x42, 0x96,  //@@@@.+%+%
    0x00, 0x0e, 0xca, 0xda, 0x00, 0x92, 0x6c, 0xa4, 0x2e,  //..@@.%+%.
    0x00, 0x00, 0x0e, 0x88, 0x00, 0x24, 0xa6, 0x54, 0x00,  //...%..%+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x12, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f03e () , Width: 10 */
    0x1c, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x0e,  //..........
    0xc6, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x70, 0xa6,  //@++++++++%
    0xba, 0x60, 0xd6, 0x1a, 0x00, 0x00, 0x02, 0x00, 0x00, 0xba,  //%+@......%
    0xba, 0x6c, 0xea, 0x20, 0x00, 0x54, 0xce, 0x12, 0x00, 0xba,  //%+@..+@..%
    0xba, 0x00, 0x12, 0x0a, 0x52, 0xfa, 0xff, 0xd0, 0x12, 0xba,  //%...+@@@.%
    0xba, 0x10, 0xce, 0xd0, 0xfa, 0xff, 0xff, 0xff, 0x5a, 0xba,  //%.@@@@@@+%
    0xba, 0x96, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0xba,  //%%@@@@@@+%
    0xbc, 0x22, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x14, 0xba,  //%........%
    0x8a, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0x58,  //%%%%%%%%%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f040 () , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xbe, 0x94, 0x00,  //.....%%.
    0x00, 0x00, 0x00, 0x0e, 0x6e, 0xda, 0xff, 0x7e,  //....+@@+
    0x00, 0x00, 0x10, 0xb8, 0xd4, 0x80, 0xd6, 0x50,  //...%@+@+
    0x00, 0x12, 0xbc, 0xbe, 0xff, 0xfa, 0x26, 0x00,  //..%%@@..
    0x14, 0xbe, 0xc0, 0xff, 0xfc, 0x5a, 0x00, 0x00,  //.%%@@+..
    0xc0, 0xa8, 0xff, 0xfc, 0x60, 0x00, 0x00, 0x00,  //%%@@+...
    0xe6, 0x40, 0xda, 0x64, 0x00, 0x00, 0x00, 0x00,  //@.@+....
    0xba, 0xba, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00,  //%%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f048 () , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0xf6, 0x20, 0x00, 0x00, 0x9a, 0x02,  //@...%.
    0xff, 0x26, 0x00, 0x9e, 0xff, 0x02,  //@..%@.
    0xff, 0x28, 0x9e, 0xff, 0xff, 0x02,  //@.%@@.
    0xff, 0xbe, 0xff, 0xff, 0xff, 0x02,  //@%@@@.
    0xff, 0x84, 0xfc, 0xff, 0xff, 0x02,  //@%@@@.
    0xff, 0x26, 0x5c, 0xfc, 0xff, 0x02,  //@.+@@.
    0xff, 0x26, 0x00, 0x5a, 0xfc, 0x02,  //@..+@.
    0xae, 0x14, 0x00, 0x00, 0x56, 0x00,  //%...+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+f04b () , Width: 7 */
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0xe6, 0x64, 0x02, 0x00, 0x00, 0x00, 0x00,  //@+.....
    0xff, 0xff, 0xd2, 0x48, 0x00, 0x00, 0x00,  //@@@+...
    0xff, 0xff, 0xff, 0xff, 0xba, 0x2e, 0x00,  //@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x9c,  //@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x30,  //@@@@@%.
    0xff, 0xff, 0xff, 0xd4, 0x4a, 0x00, 0x00,  //@@@@+..
    0xff, 0xe8, 0x68, 0x02, 0x00, 0x00, 0x00,  //@@+....
    0x7c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,  //+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+f04c () , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xf6, 0xff, 0xff, 0x2e, 0x2e, 0xff, 0xff, 0xf4,  //@@@..@@@
    0xff, 0xff, 0xff, 0x36, 0x36, 0xff, 0xff, 0xff,  //@@@..@@@
    0xff, 0xff, 0xff, 0x36, 0x36, 0xff, 0xff, 0xff,  //@@@..@@@
    0xff, 0xff, 0xff, 0x36, 0x36, 0xff, 0xff, 0xff,  //@@@..@@@
    0xff, 0xff, 0xff, 0x36, 0x36, 0xff, 0xff, 0xff,  //@@@..@@@
    0xff, 0xff, 0xff, 0x36, 0x36, 0xff, 0xff, 0xff,  //@@@..@@@
    0xff, 0xff, 0xff, 0x36, 0x36, 0xff, 0xff, 0xff,  //@@@..@@@
    0xae, 0xb6, 0xb6, 0x1e, 0x20, 0xb6, 0xb6, 0xae,  //%%%..%%%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f04d () , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@%
    0xae, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0x7a,  //%%%%%%%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f051 () , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x9a, 0x04, 0x00, 0x0e, 0xf8, 0x0e,  //%...@.
    0xee, 0xae, 0x04, 0x12, 0xff, 0x12,  //@%..@.
    0xee, 0xff, 0xae, 0x18, 0xff, 0x12,  //@@%.@.
    0xee, 0xff, 0xff, 0xbe, 0xff, 0x12,  //@@@%@.
    0xee, 0xff, 0xff, 0x82, 0xff, 0x12,  //@@@%@.
    0xee, 0xff, 0x6c, 0x12, 0xff, 0x12,  //@@+.@.
    0xee, 0x6c, 0x00, 0x12, 0xff, 0x12,  //@+..@.
    0x58, 0x00, 0x00, 0x08, 0xb0, 0x08,  //+...%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+f052 () , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x34, 0x18, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x42, 0xf4, 0xd8, 0x18, 0x00, 0x00,  //..+@@...
    0x00, 0x42, 0xf4, 0xff, 0xff, 0xd8, 0x18, 0x00,  //.+@@@@..
    0x42, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x18,  //+@@@@@@.
    0x5e, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x40,  //+++++++.
    0xe2, 0xea, 0xea, 0xea, 0xea, 0xea, 0xea, 0xa0,  //@@@@@@@%
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xae,  //@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f053 () , Width: 6 */
    0x00, 0x00, 0x00, 0x0a, 0xbe, 0x72,  //....%+
    0x00, 0x00, 0x0a, 0xc2, 0xff, 0xb2,  //...@@%
    0x00, 0x0a, 0xc2, 0xff, 0xb6, 0x06,  //..@@%.
    0x08, 0xc2, 0xff, 0xb6, 0x06, 0x00,  //.@@%..
    0x0c, 0xd0, 0xff, 0xa4, 0x02, 0x00,  //.@@%..
    0x00, 0x12, 0xd0, 0xff, 0xa4, 0x02,  //..@@%.
    0x00, 0x00, 0x12, 0xd0, 0xff, 0xa2,  //...@@%
    0x00, 0x00, 0x00, 0x12, 0xd0, 0x86,  //....@%
    0x00, 0x00, 0x00, 0x00, 0x04, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+f054 () , Width: 6 */
    0x22, 0xd6, 0x44, 0x00, 0x00, 0x00,  //.@+...
    0x48, 0xfa, 0xf4, 0x44, 0x00, 0x00,  //+@@+..
    0x00, 0x56, 0xfa, 0xf6, 0x44, 0x00,  //.+@@+.
    0x00, 0x00, 0x56, 0xfa, 0xf6, 0x44,  //..+@@+
    0x00, 0x00, 0x44, 0xf6, 0xfa, 0x50,  //..+@@+
    0x00, 0x44, 0xf6, 0xfa, 0x56, 0x00,  //.+@@+.
    0x3e, 0xf6, 0xfa, 0x56, 0x00, 0x00,  //.@@+..
    0x2c, 0xe8, 0x56, 0x00, 0x00, 0x00,  //.@+...
    0x00, 0x04, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+f067 () , Width: 8 */
    0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x60, 0xff, 0x74, 0x00, 0x00, 0x00,  //..+@+...
    0x00, 0x00, 0x6a, 0xff, 0x7e, 0x00, 0x00, 0x00,  //..+@+...
    0x6c, 0x7e, 0xb4, 0xff, 0xbe, 0x7e, 0x74, 0x00,  //++%@%++.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x12,  //@@@@@@@.
    0x58, 0x6a, 0xa8, 0xff, 0xb4, 0x6a, 0x60, 0x00,  //++%@%++.
    0x00, 0x00, 0x6a, 0xff, 0x7e, 0x00, 0x00, 0x00,  //..+@+...
    0x00, 0x00, 0x58, 0xff, 0x6c, 0x00, 0x00, 0x00,  //..+@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f068 () , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xd8, 0xea, 0xea, 0xea, 0xea, 0xea, 0xe0, 0x08,  //@@@@@@@.
    0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0a,  //@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f071 () , Width: 9 */
    0x00, 0x00, 0x00, 0x06, 0x7a, 0x06, 0x00, 0x00, 0x00,  //....+....
    0x00, 0x00, 0x00, 0x70, 0xff, 0x70, 0x00, 0x00, 0x00,  //...+@+...
    0x00, 0x00, 0x0c, 0xea, 0xff, 0xea, 0x0c, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x82, 0xcc, 0x00, 0xcc, 0x82, 0x00, 0x00,  //..%@.@%..
    0x00, 0x16, 0xf2, 0xd4, 0x00, 0xd8, 0xf2, 0x16, 0x00,  //..@@.@@..
    0x00, 0x94, 0xff, 0xf6, 0xbe, 0xf6, 0xff, 0x92, 0x00,  //.%@@%@@%.
    0x22, 0xf8, 0xff, 0xdc, 0x00, 0xdc, 0xff, 0xf8, 0x20,  //.@@@.@@@.
    0xa4, 0xff, 0xff, 0xe2, 0x26, 0xe2, 0xff, 0xff, 0xa4,  //%@@@.@@@%
    0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f074 () , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00,  //.........
    0x24, 0x1e, 0x00, 0x00, 0x00, 0x1c, 0x26, 0xda, 0x30,  //.......@.
    0xfc, 0xff, 0xd0, 0x2c, 0xc6, 0xff, 0xff, 0xff, 0xca,  //@@@.@@@@@
    0x00, 0x0e, 0xae, 0xb6, 0xc8, 0x12, 0x00, 0xc2, 0x18,  //..%%@..@.
    0x00, 0x00, 0x30, 0xfc, 0x3e, 0x00, 0x00, 0x0c, 0x00,  //...@.....
    0x00, 0x0c, 0xbc, 0xbe, 0xb2, 0x14, 0x00, 0xc2, 0x1a,  //..%%%..@.
    0xfc, 0xff, 0xd0, 0x2c, 0xca, 0xff, 0xff, 0xff, 0xca,  //@@@.@@@@@
    0x24, 0x1e, 0x00, 0x00, 0x00, 0x1e, 0x28, 0xd8, 0x2e,  //.......@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f077 () , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x0e, 0x14, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x10, 0xcc, 0xda, 0x1a, 0x00, 0x00, 0x00,  //...@@....
    0x00, 0x10, 0xce, 0xff, 0xff, 0xda, 0x1a, 0x00, 0x00,  //..@@@@...
    0x12, 0xce, 0xff, 0xa8, 0x96, 0xff, 0xda, 0x1c, 0x00,  //.@@%%@@..
    0xca, 0xff, 0xa8, 0x02, 0x00, 0x94, 0xff, 0xdc, 0x04,  //@@%..%@@.
    0x60, 0x9e, 0x02, 0x00, 0x00, 0x00, 0x8c, 0x74, 0x00,  //+%....%+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f078 () , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x80, 0xc0, 0x0a, 0x00, 0x00, 0x04, 0xb0, 0x98, 0x00,  //+%....%%.
    0xb4, 0xff, 0xc2, 0x0a, 0x04, 0xb2, 0xff, 0xc6, 0x02,  //%@@..%@@.
    0x06, 0xb6, 0xff, 0xc4, 0xb4, 0xff, 0xc6, 0x0c, 0x00,  //.%@@%@@..
    0x00, 0x06, 0xb4, 0xff, 0xff, 0xc6, 0x0c, 0x00, 0x00,  //..%@@@...
    0x00, 0x00, 0x06, 0xb4, 0xc4, 0x0c, 0x00, 0x00, 0x00,  //...%@....
    0x00, 0x00, 0x00, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f079 () , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x16, 0xd2, 0x3a, 0xd2, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,  //.@.@@@@@..
    0xc8, 0xff, 0xe0, 0x24, 0x26, 0x26, 0x48, 0xff, 0x00, 0x00,  //@@@...+@..
    0x6e, 0xff, 0x84, 0x28, 0x00, 0x00, 0x26, 0xff, 0x00, 0x00,  //+@%....@..
    0x00, 0xff, 0x26, 0x00, 0x00, 0x2a, 0x88, 0xff, 0x72, 0x16,  //.@....%@+.
    0x00, 0xff, 0x48, 0x26, 0x26, 0x26, 0xe2, 0xff, 0xc6, 0x06,  //.@+...@@@.
    0x00, 0xfc, 0xff, 0xff, 0xff, 0xd4, 0x3e, 0xd0, 0x16, 0x00,  //.@@@@@.@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f07b () , Width: 9 */
    0x00, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xc4, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%.....
    0xff, 0xff, 0xff, 0xf6, 0xc6, 0xc6, 0xc6, 0xb0, 0x12,  //@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x56,  //@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a,  //@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a,  //@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a,  //@@@@@@@@+
    0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x24,  //%@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f093 () , Width: 9 */
    0x00, 0x00, 0x00, 0x1a, 0x20, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x1c, 0xdc, 0xe6, 0x26, 0x00, 0x00, 0x00,  //...@@....
    0x00, 0x1c, 0xdc, 0xff, 0xff, 0xe6, 0x26, 0x00, 0x00,  //..@@@@...
    0x00, 0x36, 0x7e, 0xf4, 0xff, 0x7e, 0x40, 0x00, 0x00,  //..+@@+...
    0x00, 0x00, 0x00, 0xea, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@....
    0x00, 0x00, 0x00, 0xe6, 0xfa, 0x00, 0x00, 0x00, 0x00,  //...@@....
    0xe4, 0xea, 0xc0, 0x5a, 0x5a, 0xb8, 0xea, 0xe6, 0x2c,  //@@%++%@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0xe6, 0xb6, 0x42,  //@@@@@@@%+
    0xb4, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xb8, 0x20,  //%%%%%%%%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f095 () , Width: 8 */
    0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x92, 0xe6, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@......
    0xf6, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+.....
    0xce, 0xd4, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0x62, 0xf8, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@......
    0x00, 0xb6, 0xde, 0x32, 0x08, 0x6c, 0x0a, 0x00,  //.%@..+..
    0x00, 0x0a, 0xb6, 0xf8, 0xd4, 0xff, 0xe6, 0x04,  //..%@@@@.
    0x00, 0x00, 0x00, 0x62, 0xce, 0xf6, 0x92, 0x00,  //...+@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f0c4 () , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x4c, 0xc2, 0x9c, 0x16, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,  //+@%.......
    0xb2, 0x0e, 0x60, 0xc4, 0x00, 0x00, 0x1e, 0x60, 0x68, 0x38,  //%.+@...++.
    0x70, 0x9a, 0x68, 0xee, 0x40, 0x58, 0x40, 0x34, 0x4c, 0x00,  //+%+@.+..+.
    0x00, 0x40, 0x72, 0x70, 0xa4, 0x3c, 0x56, 0x34, 0x00, 0x00,  //..++%.+...
    0x06, 0x8c, 0xc6, 0xb2, 0x76, 0x94, 0x44, 0x58, 0x00, 0x00,  //.%@%+%++..
    0x92, 0x54, 0x18, 0xf2, 0x04, 0x34, 0x52, 0x1c, 0x64, 0x00,  //%+.@..+.+.
    0xb0, 0x12, 0x74, 0xb0, 0x00, 0x00, 0x0a, 0x5e, 0x66, 0x3c,  //%.+%...++.
    0x46, 0xc2, 0x98, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00,  //+@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f0c5 () , Width: 9 */
    0x00, 0x00, 0x6c, 0xb8, 0xba, 0x96, 0x00, 0x00, 0x00,  //..+%%%...
    0x00, 0x7e, 0xe2, 0x00, 0x00, 0xba, 0x00, 0x00, 0x00,  //.+@..%...
    0x82, 0x72, 0xba, 0x00, 0x00, 0xca, 0xa0, 0xaa, 0x9a,  //%+%..@%%%
    0xe8, 0xba, 0xaa, 0x00, 0x44, 0xd0, 0x76, 0x00, 0xba,  //@%%.+@+.%
    0xba, 0x00, 0x00, 0x5a, 0xae, 0x28, 0x76, 0x00, 0xba,  //%..+%.+.%
    0xba, 0x00, 0x00, 0xe2, 0xba, 0xba, 0x44, 0x00, 0xba,  //%..@%%+.%
    0xc8, 0x3e, 0x3e, 0xb6, 0x00, 0x00, 0x00, 0x00, 0xba,  //@..%....%
    0x30, 0x3e, 0x3e, 0xb6, 0x00, 0x00, 0x00, 0x00, 0xba,  //...%....%
    0x00, 0x00, 0x00, 0xdc, 0xba, 0xba, 0xba, 0xba, 0xda,  //...@%%%%@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+f0c7 () , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xdc, 0xea, 0xff, 0xc6, 0xee, 0xd0, 0x3e, 0x00,  //@@@@@@..
    0xba, 0xaa, 0xff, 0x16, 0xba, 0x18, 0xc8, 0x3c,  //%%@.%.@.
    0xba, 0x9c, 0xff, 0xc2, 0xde, 0x00, 0x10, 0xb8,  //%%@@@..%
    0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xba,  //%......%
    0xba, 0x6c, 0xbe, 0xbe, 0xbe, 0xbe, 0x36, 0xba,  //%+%%%%.%
    0xba, 0x92, 0x00, 0x00, 0x00, 0x4e, 0x62, 0xba,  //%%...++%
    0xba, 0x92, 0x00, 0x00, 0x00, 0x4e, 0x62, 0xba,  //%%...++%
    0xa8, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0x86,  //%%%%%%%%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f0e7 () , Width: 5 */
    0x00, 0x10, 0x12, 0x00, 0x00,  //.....
    0x14, 0xfc, 0xf0, 0x06, 0x00,  //.@@..
    0x52, 0xff, 0x9a, 0x00, 0x00,  //+@%..
    0x92, 0xff, 0xb2, 0xc2, 0x54,  //%@%@+
    0xd0, 0xff, 0xff, 0xe6, 0x06,  //@@@@.
    0x64, 0x2c, 0xcc, 0x78, 0x00,  //+.@+.
    0x00, 0x0e, 0xee, 0x0e, 0x00,  //..@..
    0x00, 0x4a, 0x88, 0x00, 0x00,  //.+%..
    0x00, 0x82, 0x18, 0x00, 0x00,  //.%...
    0x00, 0x18, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+f0f3 () , Width: 9 */
    0x00, 0x00, 0x00, 0x1e, 0x50, 0x00, 0x00, 0x00, 0x00,  //....+....
    0x00, 0x00, 0x56, 0xda, 0xf0, 0x8e, 0x04, 0x00, 0x00,  //..+@@%...
    0x00, 0x28, 0xfa, 0xff, 0xff, 0xff, 0x7a, 0x00, 0x00,  //..@@@@+..
    0x00, 0x64, 0xff, 0xff, 0xff, 0xff, 0xba, 0x00, 0x00,  //.+@@@@%..
    0x00, 0x78, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00, 0x00,  //.+@@@@@..
    0x00, 0xac, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0a, 0x00,  //.%@@@@@..
    0x20, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00,  //.@@@@@@+.
    0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x26,  //@@@@@@@@.
    0x34, 0x4e, 0x56, 0xe6, 0xff, 0x90, 0x4e, 0x4a, 0x06,  //.++@@%++.
    0x00, 0x00, 0x00, 0x58, 0x82, 0x08, 0x00, 0x00, 0x00,  //...+%....


    /*Unicode: U+f11c () , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xac, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0x7a,  //%%%%%%%%%+
    0xba, 0x36, 0x30, 0x20, 0x28, 0x3c, 0x3c, 0x1a, 0x22, 0xba,  //%........%
    0xba, 0x28, 0x24, 0x18, 0x1e, 0x2e, 0x2c, 0x46, 0x5a, 0xba,  //%......++%
    0xba, 0x7a, 0x5a, 0x72, 0x68, 0x3e, 0x40, 0xaa, 0x40, 0xba,  //%++++..%.%
    0xba, 0x46, 0x3c, 0x7e, 0x7e, 0x7e, 0x7c, 0x20, 0x2a, 0xba,  //%+.++++..%
    0xce, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0x9c,  //@%%%%%%%%%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f124 () , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a,  //......+
    0x00, 0x00, 0x00, 0x00, 0x54, 0xd2, 0xca,  //....+@@
    0x00, 0x00, 0x54, 0xd2, 0xff, 0xff, 0x4a,  //..+@@@+
    0x52, 0xd2, 0xff, 0xff, 0xff, 0xca, 0x00,  //+@@@@@.
    0x64, 0x6a, 0x6a, 0xde, 0xff, 0x4c, 0x00,  //+++@@+.
    0x00, 0x00, 0x00, 0xc6, 0xcc, 0x00, 0x00,  //...@@..
    0x00, 0x00, 0x00, 0xc6, 0x4e, 0x00, 0x00,  //...@+..
    0x00, 0x00, 0x00, 0x62, 0x00, 0x00, 0x00,  //...+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+f15b () , Width: 8 */
    0xec, 0xff, 0xff, 0xff, 0x7e, 0x58, 0x00, 0x00,  //@@@@++..
    0xff, 0xff, 0xff, 0xff, 0x7e, 0xda, 0x7a, 0x00,  //@@@@+@+.
    0xff, 0xff, 0xff, 0xff, 0x82, 0x7e, 0x92, 0x26,  //@@@@%+%.
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xc6, 0xc6, 0x8e,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6,  //@@@@@@@%
    0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4,  //@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+f1eb () , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x16, 0x82, 0xd0, 0xf4, 0xf6, 0xd6, 0x8e, 0x20, 0x00,  //..%@@@@%..
    0x58, 0xf2, 0xda, 0x80, 0x5a, 0x5a, 0x76, 0xce, 0xfa, 0x72,  //+@@++++@@+
    0x6a, 0x78, 0x64, 0xce, 0xff, 0xff, 0xd8, 0x74, 0x66, 0x82,  //+++@@@@++%
    0x00, 0x48, 0xf2, 0x7c, 0x4e, 0x4a, 0x6a, 0xec, 0x68, 0x00,  //.+@++++@+.
    0x00, 0x00, 0x1a, 0xb8, 0xff, 0xff, 0xca, 0x2a, 0x00, 0x00,  //...%@@@...
    0x00, 0x00, 0x00, 0x72, 0x58, 0x52, 0x7e, 0x02, 0x00, 0x00,  //...++++...
    0x00, 0x00, 0x00, 0x00, 0x7a, 0x9a, 0x00, 0x00, 0x00, 0x00,  //....+%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+f240 () , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x8e, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0x8c, 0x00,  //%%%%%%%%%%%.
    0xbc, 0x38, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x38, 0xbc, 0x00,  //%.+++++++.%.
    0xba, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9e, 0x70, 0x88,  //%%@@@@@@@%+%
    0xba, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9e, 0x00, 0xa6,  //%%@@@@@@@%.%
    0xba, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9e, 0x3e, 0x9e,  //%%@@@@@@@%.%
    0xba, 0x62, 0x9e, 0x9e, 0x9e, 0x9e, 0x9e, 0x9e, 0x9e, 0x62, 0xba, 0x16,  //%+%%%%%%%+%.
    0xbe, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xc0, 0x00,  //%%%%%%%%%%%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+f241 () , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x8e, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0x8c, 0x00,  //%%%%%%%%%%%.
    0xbc, 0x38, 0x5a, 0x5a, 0x5a, 0x5a, 0x5a, 0x40, 0x00, 0x00, 0xbc, 0x00,  //%.+++++...%.
    0xba, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x70, 0x88,  //%%@@@@@%..+%
    0xba, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0xa6,  //%%@@@@@%...%
    0xba, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x3e, 0x9e,  //%%@@@@@%...%
    0xba, 0x62, 0x9e, 0x9e, 0x9e, 0x9e, 0x9e, 0x72, 0x00, 0x00, 0xba, 0x16,  //%+%%%%%+..%.
    0xbe, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xc0, 0x00,  //%%%%%%%%%%%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+f242 () , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x8e, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0x8c, 0x00,  //%%%%%%%%%%%.
    0xbc, 0x38, 0x5a, 0x5a, 0x5a, 0x48, 0x00, 0x00, 0x00, 0x00, 0xbc, 0x00,  //%.++++....%.
    0xba, 0x9e, 0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88,  //%%@@@@....+%
    0xba, 0x9e, 0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6,  //%%@@@@.....%
    0xba, 0x9e, 0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x9e,  //%%@@@@.....%
    0xba, 0x62, 0x9e, 0x9e, 0x9e, 0x80, 0x00, 0x00, 0x00, 0x00, 0xba, 0x16,  //%+%%%+....%.
    0xbe, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xc0, 0x00,  //%%%%%%%%%%%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+f243 () , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x8e, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0x8c, 0x00,  //%%%%%%%%%%%.
    0xbc, 0x38, 0x5a, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0x00,  //%.++......%.
    0xba, 0x9e, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88,  //%%@@......+%
    0xba, 0x9e, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6,  //%%@@.......%
    0xba, 0x9e, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x9e,  //%%@@.......%
    0xba, 0x62, 0x9e, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xba, 0x16,  //%+%%......%.
    0xbe, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xc0, 0x00,  //%%%%%%%%%%%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+f244 () , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x8e, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0x8c, 0x00,  //%%%%%%%%%%%.
    0xbc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0x00,  //%.........%.
    0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x88,  //%.........+%
    0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6,  //%..........%
    0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x9e,  //%..........%
    0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xba, 0x16,  //%.........%.
    0xbe, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xc0, 0x00,  //%%%%%%%%%%%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+f293 () , Width: 8 */
    0x00, 0x00, 0x82, 0xe6, 0xe4, 0xc8, 0x3a, 0x00,  //..%@@@..
    0x00, 0x6e, 0xff, 0xff, 0x32, 0xee, 0xee, 0x16,  //.+@@.@@.
    0x00, 0xd0, 0xb6, 0xf2, 0x34, 0x4a, 0xee, 0x64,  //.@%@.+@+
    0x00, 0xf8, 0xca, 0x4e, 0x2e, 0x50, 0xf2, 0x8c,  //.@@+.+@%
    0x04, 0xff, 0xff, 0x9a, 0x08, 0xe8, 0xff, 0x98,  //.@@%.@@%
    0x00, 0xf8, 0xca, 0x4e, 0x2e, 0x50, 0xf2, 0x8c,  //.@@+.+@%
    0x00, 0xd0, 0xb6, 0xf2, 0x34, 0x4a, 0xee, 0x66,  //.@%@.+@+
    0x00, 0x72, 0xff, 0xff, 0x30, 0xec, 0xf0, 0x18,  //.+@@.@@.
    0x00, 0x00, 0x86, 0xe8, 0xe4, 0xce, 0x3e, 0x00,  //..%@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........



#endif
};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t lv_font_symbol_10_glyph_dsc[] = {
#if USE_LV_FONT_SYMBOL_10 == 1
    {.w_px = 8,   .glyph_index = 0},  /*Unicode: U+f001 ()*/
    {.w_px = 10,  .glyph_index = 10}, /*Unicode: U+f008 ()*/
    {.w_px = 9,   .glyph_index = 30}, /*Unicode: U+f00b ()*/
    {.w_px = 9,   .glyph_index = 50}, /*Unicode: U+f00c ()*/
    {.w_px = 6,   .glyph_index = 70}, /*Unicode: U+f00d ()*/
    {.w_px = 8,   .glyph_index = 80}, /*Unicode: U+f011 ()*/
    {.w_px = 8,   .glyph_index = 90}, /*Unicode: U+f013 ()*/
    {.w_px = 8,   .glyph_index = 100},    /*Unicode: U+f014 ()*/
    {.w_px = 9,   .glyph_index = 110},    /*Unicode: U+f015 ()*/
    {.w_px = 9,   .glyph_index = 130},    /*Unicode: U+f019 ()*/
    {.w_px = 8,   .glyph_index = 150},    /*Unicode: U+f01c ()*/
    {.w_px = 8,   .glyph_index = 160},    /*Unicode: U+f021 ()*/
    {.w_px = 4,   .glyph_index = 170},    /*Unicode: U+f026 ()*/
    {.w_px = 6,   .glyph_index = 180},    /*Unicode: U+f027 ()*/
    {.w_px = 9,   .glyph_index = 190},    /*Unicode: U+f028 ()*/
    {.w_px = 10,  .glyph_index = 210},    /*Unicode: U+f03e ()*/
    {.w_px = 8,   .glyph_index = 230},    /*Unicode: U+f040 ()*/
    {.w_px = 6,   .glyph_index = 240},    /*Unicode: U+f048 ()*/
    {.w_px = 7,   .glyph_index = 250},    /*Unicode: U+f04b ()*/
    {.w_px = 8,   .glyph_index = 260},    /*Unicode: U+f04c ()*/
    {.w_px = 8,   .glyph_index = 270},    /*Unicode: U+f04d ()*/
    {.w_px = 6,   .glyph_index = 280},    /*Unicode: U+f051 ()*/
    {.w_px = 8,   .glyph_index = 290},    /*Unicode: U+f052 ()*/
    {.w_px = 6,   .glyph_index = 300},    /*Unicode: U+f053 ()*/
    {.w_px = 6,   .glyph_index = 310},    /*Unicode: U+f054 ()*/
    {.w_px = 8,   .glyph_index = 320},    /*Unicode: U+f067 ()*/
    {.w_px = 8,   .glyph_index = 330},    /*Unicode: U+f068 ()*/
    {.w_px = 9,   .glyph_index = 340},    /*Unicode: U+f071 ()*/
    {.w_px = 9,   .glyph_index = 360},    /*Unicode: U+f074 ()*/
    {.w_px = 9,   .glyph_index = 380},    /*Unicode: U+f077 ()*/
    {.w_px = 9,   .glyph_index = 400},    /*Unicode: U+f078 ()*/
    {.w_px = 10,  .glyph_index = 420},    /*Unicode: U+f079 ()*/
    {.w_px = 9,   .glyph_index = 440},    /*Unicode: U+f07b ()*/
    {.w_px = 9,   .glyph_index = 460},    /*Unicode: U+f093 ()*/
    {.w_px = 8,   .glyph_index = 480},    /*Unicode: U+f095 ()*/
    {.w_px = 10,  .glyph_index = 490},    /*Unicode: U+f0c4 ()*/
    {.w_px = 9,   .glyph_index = 510},    /*Unicode: U+f0c5 ()*/
    {.w_px = 8,   .glyph_index = 530},    /*Unicode: U+f0c7 ()*/
    {.w_px = 5,   .glyph_index = 540},    /*Unicode: U+f0e7 ()*/
    {.w_px = 9,   .glyph_index = 550},    /*Unicode: U+f0f3 ()*/
    {.w_px = 10,  .glyph_index = 570},    /*Unicode: U+f11c ()*/
    {.w_px = 7,   .glyph_index = 590},    /*Unicode: U+f124 ()*/
    {.w_px = 8,   .glyph_index = 600},    /*Unicode: U+f15b ()*/
    {.w_px = 10,  .glyph_index = 610},    /*Unicode: U+f1eb ()*/
    {.w_px = 12,  .glyph_index = 630},    /*Unicode: U+f240 ()*/
    {.w_px = 12,  .glyph_index = 650},    /*Unicode: U+f241 ()*/
    {.w_px = 12,  .glyph_index = 670},    /*Unicode: U+f242 ()*/
    {.w_px = 12,  .glyph_index = 690},    /*Unicode: U+f243 ()*/
    {.w_px = 12,  .glyph_index = 710},    /*Unicode: U+f244 ()*/
    {.w_px = 8,   .glyph_index = 730},    /*Unicode: U+f293 ()*/

#elif USE_LV_FONT_SYMBOL_10 == 2
    {.w_px = 8,   .glyph_index = 0},  /*Unicode: U+f001 ()*/
    {.w_px = 10,  .glyph_index = 20}, /*Unicode: U+f008 ()*/
    {.w_px = 9,   .glyph_index = 50}, /*Unicode: U+f00b ()*/
    {.w_px = 9,   .glyph_index = 80}, /*Unicode: U+f00c ()*/
    {.w_px = 6,   .glyph_index = 110},    /*Unicode: U+f00d ()*/
    {.w_px = 8,   .glyph_index = 130},    /*Unicode: U+f011 ()*/
    {.w_px = 8,   .glyph_index = 150},    /*Unicode: U+f013 ()*/
    {.w_px = 8,   .glyph_index = 170},    /*Unicode: U+f014 ()*/
    {.w_px = 9,   .glyph_index = 190},    /*Unicode: U+f015 ()*/
    {.w_px = 9,   .glyph_index = 220},    /*Unicode: U+f019 ()*/
    {.w_px = 8,   .glyph_index = 250},    /*Unicode: U+f01c ()*/
    {.w_px = 8,   .glyph_index = 270},    /*Unicode: U+f021 ()*/
    {.w_px = 4,   .glyph_index = 290},    /*Unicode: U+f026 ()*/
    {.w_px = 6,   .glyph_index = 300},    /*Unicode: U+f027 ()*/
    {.w_px = 9,   .glyph_index = 320},    /*Unicode: U+f028 ()*/
    {.w_px = 10,  .glyph_index = 350},    /*Unicode: U+f03e ()*/
    {.w_px = 8,   .glyph_index = 380},    /*Unicode: U+f040 ()*/
    {.w_px = 6,   .glyph_index = 400},    /*Unicode: U+f048 ()*/
    {.w_px = 7,   .glyph_index = 420},    /*Unicode: U+f04b ()*/
    {.w_px = 8,   .glyph_index = 440},    /*Unicode: U+f04c ()*/
    {.w_px = 8,   .glyph_index = 460},    /*Unicode: U+f04d ()*/
    {.w_px = 6,   .glyph_index = 480},    /*Unicode: U+f051 ()*/
    {.w_px = 8,   .glyph_index = 500},    /*Unicode: U+f052 ()*/
    {.w_px = 6,   .glyph_index = 520},    /*Unicode: U+f053 ()*/
    {.w_px = 6,   .glyph_index = 540},    /*Unicode: U+f054 ()*/
    {.w_px = 8,   .glyph_index = 560},    /*Unicode: U+f067 ()*/
    {.w_px = 8,   .glyph_index = 580},    /*Unicode: U+f068 ()*/
    {.w_px = 9,   .glyph_index = 600},    /*Unicode: U+f071 ()*/
    {.w_px = 9,   .glyph_index = 630},    /*Unicode: U+f074 ()*/
    {.w_px = 9,   .glyph_index = 660},    /*Unicode: U+f077 ()*/
    {.w_px = 9,   .glyph_index = 690},    /*Unicode: U+f078 ()*/
    {.w_px = 10,  .glyph_index = 720},    /*Unicode: U+f079 ()*/
    {.w_px = 9,   .glyph_index = 750},    /*Unicode: U+f07b ()*/
    {.w_px = 9,   .glyph_index = 780},    /*Unicode: U+f093 ()*/
    {.w_px = 8,   .glyph_index = 810},    /*Unicode: U+f095 ()*/
    {.w_px = 10,  .glyph_index = 830},    /*Unicode: U+f0c4 ()*/
    {.w_px = 9,   .glyph_index = 860},    /*Unicode: U+f0c5 ()*/
    {.w_px = 8,   .glyph_index = 890},    /*Unicode: U+f0c7 ()*/
    {.w_px = 5,   .glyph_index = 910},    /*Unicode: U+f0e7 ()*/
    {.w_px = 9,   .glyph_index = 930},    /*Unicode: U+f0f3 ()*/
    {.w_px = 10,  .glyph_index = 960},    /*Unicode: U+f11c ()*/
    {.w_px = 7,   .glyph_index = 990},    /*Unicode: U+f124 ()*/
    {.w_px = 8,   .glyph_index = 1010},   /*Unicode: U+f15b ()*/
    {.w_px = 10,  .glyph_index = 1030},   /*Unicode: U+f1eb ()*/
    {.w_px = 12,  .glyph_index = 1060},   /*Unicode: U+f240 ()*/
    {.w_px = 12,  .glyph_index = 1090},   /*Unicode: U+f241 ()*/
    {.w_px = 12,  .glyph_index = 1120},   /*Unicode: U+f242 ()*/
    {.w_px = 12,  .glyph_index = 1150},   /*Unicode: U+f243 ()*/
    {.w_px = 12,  .glyph_index = 1180},   /*Unicode: U+f244 ()*/
    {.w_px = 8,   .glyph_index = 1210},   /*Unicode: U+f293 ()*/

#elif USE_LV_FONT_SYMBOL_10 == 4
    {.w_px = 8,   .glyph_index = 0},  /*Unicode: U+f001 ()*/
    {.w_px = 10,  .glyph_index = 40}, /*Unicode: U+f008 ()*/
    {.w_px = 9,   .glyph_index = 90}, /*Unicode: U+f00b ()*/
    {.w_px = 9,   .glyph_index = 140},    /*Unicode: U+f00c ()*/
    {.w_px = 6,   .glyph_index = 190},    /*Unicode: U+f00d ()*/
    {.w_px = 8,   .glyph_index = 220},    /*Unicode: U+f011 ()*/
    {.w_px = 8,   .glyph_index = 260},    /*Unicode: U+f013 ()*/
    {.w_px = 8,   .glyph_index = 300},    /*Unicode: U+f014 ()*/
    {.w_px = 9,   .glyph_index = 340},    /*Unicode: U+f015 ()*/
    {.w_px = 9,   .glyph_index = 390},    /*Unicode: U+f019 ()*/
    {.w_px = 8,   .glyph_index = 440},    /*Unicode: U+f01c ()*/
    {.w_px = 8,   .glyph_index = 480},    /*Unicode: U+f021 ()*/
    {.w_px = 4,   .glyph_index = 520},    /*Unicode: U+f026 ()*/
    {.w_px = 6,   .glyph_index = 540},    /*Unicode: U+f027 ()*/
    {.w_px = 9,   .glyph_index = 570},    /*Unicode: U+f028 ()*/
    {.w_px = 10,  .glyph_index = 620},    /*Unicode: U+f03e ()*/
    {.w_px = 8,   .glyph_index = 670},    /*Unicode: U+f040 ()*/
    {.w_px = 6,   .glyph_index = 710},    /*Unicode: U+f048 ()*/
    {.w_px = 7,   .glyph_index = 740},    /*Unicode: U+f04b ()*/
    {.w_px = 8,   .glyph_index = 780},    /*Unicode: U+f04c ()*/
    {.w_px = 8,   .glyph_index = 820},    /*Unicode: U+f04d ()*/
    {.w_px = 6,   .glyph_index = 860},    /*Unicode: U+f051 ()*/
    {.w_px = 8,   .glyph_index = 890},    /*Unicode: U+f052 ()*/
    {.w_px = 6,   .glyph_index = 930},    /*Unicode: U+f053 ()*/
    {.w_px = 6,   .glyph_index = 960},    /*Unicode: U+f054 ()*/
    {.w_px = 8,   .glyph_index = 990},    /*Unicode: U+f067 ()*/
    {.w_px = 8,   .glyph_index = 1030},   /*Unicode: U+f068 ()*/
    {.w_px = 9,   .glyph_index = 1070},   /*Unicode: U+f071 ()*/
    {.w_px = 9,   .glyph_index = 1120},   /*Unicode: U+f074 ()*/
    {.w_px = 9,   .glyph_index = 1170},   /*Unicode: U+f077 ()*/
    {.w_px = 9,   .glyph_index = 1220},   /*Unicode: U+f078 ()*/
    {.w_px = 10,  .glyph_index = 1270},   /*Unicode: U+f079 ()*/
    {.w_px = 9,   .glyph_index = 1320},   /*Unicode: U+f07b ()*/
    {.w_px = 9,   .glyph_index = 1370},   /*Unicode: U+f093 ()*/
    {.w_px = 8,   .glyph_index = 1420},   /*Unicode: U+f095 ()*/
    {.w_px = 10,  .glyph_index = 1460},   /*Unicode: U+f0c4 ()*/
    {.w_px = 9,   .glyph_index = 1510},   /*Unicode: U+f0c5 ()*/
    {.w_px = 8,   .glyph_index = 1560},   /*Unicode: U+f0c7 ()*/
    {.w_px = 5,   .glyph_index = 1600},   /*Unicode: U+f0e7 ()*/
    {.w_px = 9,   .glyph_index = 1630},   /*Unicode: U+f0f3 ()*/
    {.w_px = 10,  .glyph_index = 1680},   /*Unicode: U+f11c ()*/
    {.w_px = 7,   .glyph_index = 1730},   /*Unicode: U+f124 ()*/
    {.w_px = 8,   .glyph_index = 1770},   /*Unicode: U+f15b ()*/
    {.w_px = 10,  .glyph_index = 1810},   /*Unicode: U+f1eb ()*/
    {.w_px = 12,  .glyph_index = 1860},   /*Unicode: U+f240 ()*/
    {.w_px = 12,  .glyph_index = 1920},   /*Unicode: U+f241 ()*/
    {.w_px = 12,  .glyph_index = 1980},   /*Unicode: U+f242 ()*/
    {.w_px = 12,  .glyph_index = 2040},   /*Unicode: U+f243 ()*/
    {.w_px = 12,  .glyph_index = 2100},   /*Unicode: U+f244 ()*/
    {.w_px = 8,   .glyph_index = 2160},   /*Unicode: U+f293 ()*/

#elif USE_LV_FONT_SYMBOL_10 == 8
    {.w_px = 8,   .glyph_index = 0},  /*Unicode: U+f001 ()*/
    {.w_px = 10,  .glyph_index = 80}, /*Unicode: U+f008 ()*/
    {.w_px = 9,   .glyph_index = 180},    /*Unicode: U+f00b ()*/
    {.w_px = 9,   .glyph_index = 270},    /*Unicode: U+f00c ()*/
    {.w_px = 6,   .glyph_index = 360},    /*Unicode: U+f00d ()*/
    {.w_px = 8,   .glyph_index = 420},    /*Unicode: U+f011 ()*/
    {.w_px = 8,   .glyph_index = 500},    /*Unicode: U+f013 ()*/
    {.w_px = 8,   .glyph_index = 580},    /*Unicode: U+f014 ()*/
    {.w_px = 9,   .glyph_index = 660},    /*Unicode: U+f015 ()*/
    {.w_px = 9,   .glyph_index = 750},    /*Unicode: U+f019 ()*/
    {.w_px = 8,   .glyph_index = 840},    /*Unicode: U+f01c ()*/
    {.w_px = 8,   .glyph_index = 920},    /*Unicode: U+f021 ()*/
    {.w_px = 4,   .glyph_index = 1000},   /*Unicode: U+f026 ()*/
    {.w_px = 6,   .glyph_index = 1040},   /*Unicode: U+f027 ()*/
    {.w_px = 9,   .glyph_index = 1100},   /*Unicode: U+f028 ()*/
    {.w_px = 10,  .glyph_index = 1190},   /*Unicode: U+f03e ()*/
    {.w_px = 8,   .glyph_index = 1290},   /*Unicode: U+f040 ()*/
    {.w_px = 6,   .glyph_index = 1370},   /*Unicode: U+f048 ()*/
    {.w_px = 7,   .glyph_index = 1430},   /*Unicode: U+f04b ()*/
    {.w_px = 8,   .glyph_index = 1500},   /*Unicode: U+f04c ()*/
    {.w_px = 8,   .glyph_index = 1580},   /*Unicode: U+f04d ()*/
    {.w_px = 6,   .glyph_index = 1660},   /*Unicode: U+f051 ()*/
    {.w_px = 8,   .glyph_index = 1720},   /*Unicode: U+f052 ()*/
    {.w_px = 6,   .glyph_index = 1800},   /*Unicode: U+f053 ()*/
    {.w_px = 6,   .glyph_index = 1860},   /*Unicode: U+f054 ()*/
    {.w_px = 8,   .glyph_index = 1920},   /*Unicode: U+f067 ()*/
    {.w_px = 8,   .glyph_index = 2000},   /*Unicode: U+f068 ()*/
    {.w_px = 9,   .glyph_index = 2080},   /*Unicode: U+f071 ()*/
    {.w_px = 9,   .glyph_index = 2170},   /*Unicode: U+f074 ()*/
    {.w_px = 9,   .glyph_index = 2260},   /*Unicode: U+f077 ()*/
    {.w_px = 9,   .glyph_index = 2350},   /*Unicode: U+f078 ()*/
    {.w_px = 10,  .glyph_index = 2440},   /*Unicode: U+f079 ()*/
    {.w_px = 9,   .glyph_index = 2540},   /*Unicode: U+f07b ()*/
    {.w_px = 9,   .glyph_index = 2630},   /*Unicode: U+f093 ()*/
    {.w_px = 8,   .glyph_index = 2720},   /*Unicode: U+f095 ()*/
    {.w_px = 10,  .glyph_index = 2800},   /*Unicode: U+f0c4 ()*/
    {.w_px = 9,   .glyph_index = 2900},   /*Unicode: U+f0c5 ()*/
    {.w_px = 8,   .glyph_index = 2990},   /*Unicode: U+f0c7 ()*/
    {.w_px = 5,   .glyph_index = 3070},   /*Unicode: U+f0e7 ()*/
    {.w_px = 9,   .glyph_index = 3120},   /*Unicode: U+f0f3 ()*/
    {.w_px = 10,  .glyph_index = 3210},   /*Unicode: U+f11c ()*/
    {.w_px = 7,   .glyph_index = 3310},   /*Unicode: U+f124 ()*/
    {.w_px = 8,   .glyph_index = 3380},   /*Unicode: U+f15b ()*/
    {.w_px = 10,  .glyph_index = 3460},   /*Unicode: U+f1eb ()*/
    {.w_px = 12,  .glyph_index = 3560},   /*Unicode: U+f240 ()*/
    {.w_px = 12,  .glyph_index = 3680},   /*Unicode: U+f241 ()*/
    {.w_px = 12,  .glyph_index = 3800},   /*Unicode: U+f242 ()*/
    {.w_px = 12,  .glyph_index = 3920},   /*Unicode: U+f243 ()*/
    {.w_px = 12,  .glyph_index = 4040},   /*Unicode: U+f244 ()*/
    {.w_px = 8,   .glyph_index = 4160},   /*Unicode: U+f293 ()*/

#endif
};

lv_font_t lv_font_symbol_10 = {
    .unicode_first = LV_SYMBOL_GLYPH_FIRST, /*First Unicode letter in this font*/
    .unicode_last = LV_SYMBOL_GLYPH_LAST,  /*Last Unicode letter in this font*/
    .h_px = 10,             /*Font height in pixels*/
    .glyph_bitmap = lv_font_symbol_10_glyph_bitmap, /*Bitmap of glyphs*/
    .glyph_dsc = lv_font_symbol_10_glyph_dsc,       /*Description of glyphs*/
    .glyph_cnt = 50,            /*Number of glyphs in the font*/
    .unicode_list = NULL,
    .get_bitmap = lv_font_get_bitmap_continuous,    /*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,  /*Function pointer to get glyph's width*/
#if USE_LV_FONT_SYMBOL_10 == 1
    .bpp = 1,               /*Bit per pixel*/
#elif USE_LV_FONT_SYMBOL_10 == 2
    .bpp = 2,               /*Bit per pixel*/
#elif USE_LV_FONT_SYMBOL_10 == 4
    .bpp = 4,               /*Bit per pixel*/
#elif USE_LV_FONT_SYMBOL_10 == 8
    .bpp = 8,               /*Bit per pixel*/
#endif
    .monospace = 0,
    .next_page = NULL,      /*Pointer to a font extension*/
};

#endif /*USE_LV_FONT_SYMBOL_10*/
