
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_MONOSPACE_8 != 0    /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * unscii_8_mod.ttf 8 px Font in U+0020 ( ) .. U+007e (~)  range with all bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_monospace_8_glyph_bitmap[] = {
#if USE_LV_FONT_MONOSPACE_8 == 1
    /*Unicode: U+0020 ( ) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0021 (!) , Width: 1 */
    0x80,  //%
    0x80,  //%
    0x80,  //%
    0x80,  //%
    0x00,  //.
    0x00,  //.
    0x80,  //%
    0x00,  //.


    /*Unicode: U+0022 (") , Width: 4 */
    0x90,  //%..%
    0x90,  //%..%
    0x90,  //%..%
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0023 (#) , Width: 6 */
    0x48,  //.%..%.
    0x48,  //.%..%.
    0xfc,  //%%%%%%
    0x48,  //.%..%.
    0xfc,  //%%%%%%
    0x48,  //.%..%.
    0x48,  //.%..%.
    0x00,  //......


    /*Unicode: U+0024 ($) , Width: 5 */
    0x20,  //..%..
    0x78,  //.%%%%
    0xa0,  //%.%..
    0x70,  //.%%%.
    0x28,  //..%.%
    0xf0,  //%%%%.
    0x20,  //..%..
    0x00,  //.....


    /*Unicode: U+0025 (%) , Width: 6 */
    0x00,  //......
    0xc4,  //%%...%
    0xc8,  //%%..%.
    0x10,  //...%..
    0x20,  //..%...
    0x4c,  //.%..%%
    0x8c,  //%...%%
    0x00,  //......


    /*Unicode: U+0026 (&) , Width: 6 */
    0x60,  //.%%...
    0x90,  //%..%..
    0x90,  //%..%..
    0x60,  //.%%...
    0x94,  //%..%.%
    0x88,  //%...%.
    0x74,  //.%%%.%
    0x00,  //......


    /*Unicode: U+0027 (') , Width: 3 */
    0x20,  //..%
    0x40,  //.%.
    0x80,  //%..
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0028 (() , Width: 3 */
    0x20,  //..%
    0x40,  //.%.
    0x80,  //%..
    0x80,  //%..
    0x80,  //%..
    0x40,  //.%.
    0x20,  //..%
    0x00,  //...


    /*Unicode: U+0029 ()) , Width: 3 */
    0x80,  //%..
    0x40,  //.%.
    0x20,  //..%
    0x20,  //..%
    0x20,  //..%
    0x40,  //.%.
    0x80,  //%..
    0x00,  //...


    /*Unicode: U+002a (*) , Width: 5 */
    0x20,  //..%..
    0xa8,  //%.%.%
    0x70,  //.%%%.
    0x20,  //..%..
    0x70,  //.%%%.
    0xa8,  //%.%.%
    0x20,  //..%..
    0x00,  //.....


    /*Unicode: U+002b (+) , Width: 5 */
    0x00,  //.....
    0x20,  //..%..
    0x20,  //..%..
    0xf8,  //%%%%%
    0x20,  //..%..
    0x20,  //..%..
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+002c (,) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x40,  //.%
    0x40,  //.%
    0x80,  //%.


    /*Unicode: U+002d (-) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0xf8,  //%%%%%
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+002e (.) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x80,  //%
    0x00,  //.


    /*Unicode: U+002f (/) , Width: 7 */
    0x02,  //......%
    0x04,  //.....%.
    0x08,  //....%..
    0x10,  //...%...
    0x20,  //..%....
    0x40,  //.%.....
    0x80,  //%......
    0x00,  //.......


    /*Unicode: U+0030 (0) , Width: 5 */
    0x70,  //.%%%.
    0x88,  //%...%
    0x98,  //%..%%
    0xa8,  //%.%.%
    0xc8,  //%%..%
    0x88,  //%...%
    0x70,  //.%%%.
    0x00,  //.....


    /*Unicode: U+0031 (1) , Width: 5 */
    0x20,  //..%..
    0x60,  //.%%..
    0xa0,  //%.%..
    0x20,  //..%..
    0x20,  //..%..
    0x20,  //..%..
    0xf8,  //%%%%%
    0x00,  //.....


    /*Unicode: U+0032 (2) , Width: 5 */
    0x70,  //.%%%.
    0x88,  //%...%
    0x08,  //....%
    0x10,  //...%.
    0x60,  //.%%..
    0x80,  //%....
    0xf8,  //%%%%%
    0x00,  //.....


    /*Unicode: U+0033 (3) , Width: 5 */
    0x70,  //.%%%.
    0x88,  //%...%
    0x08,  //....%
    0x30,  //..%%.
    0x08,  //....%
    0x88,  //%...%
    0x70,  //.%%%.
    0x00,  //.....


    /*Unicode: U+0034 (4) , Width: 5 */
    0x10,  //...%.
    0x30,  //..%%.
    0x50,  //.%.%.
    0x90,  //%..%.
    0xf8,  //%%%%%
    0x10,  //...%.
    0x10,  //...%.
    0x00,  //.....


    /*Unicode: U+0035 (5) , Width: 5 */
    0xf8,  //%%%%%
    0x80,  //%....
    0xf0,  //%%%%.
    0x08,  //....%
    0x08,  //....%
    0x88,  //%...%
    0x70,  //.%%%.
    0x00,  //.....


    /*Unicode: U+0036 (6) , Width: 5 */
    0x38,  //..%%%
    0x40,  //.%...
    0x80,  //%....
    0xf0,  //%%%%.
    0x88,  //%...%
    0x88,  //%...%
    0x70,  //.%%%.
    0x00,  //.....


    /*Unicode: U+0037 (7) , Width: 5 */
    0xf8,  //%%%%%
    0x08,  //....%
    0x10,  //...%.
    0x20,  //..%..
    0x40,  //.%...
    0x40,  //.%...
    0x40,  //.%...
    0x00,  //.....


    /*Unicode: U+0038 (8) , Width: 5 */
    0x70,  //.%%%.
    0x88,  //%...%
    0x88,  //%...%
    0x70,  //.%%%.
    0x88,  //%...%
    0x88,  //%...%
    0x70,  //.%%%.
    0x00,  //.....


    /*Unicode: U+0039 (9) , Width: 5 */
    0x70,  //.%%%.
    0x88,  //%...%
    0x88,  //%...%
    0x78,  //.%%%%
    0x08,  //....%
    0x10,  //...%.
    0xe0,  //%%%..
    0x00,  //.....


    /*Unicode: U+003a (:) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x80,  //%
    0x00,  //.
    0x00,  //.
    0x80,  //%
    0x00,  //.
    0x00,  //.


    /*Unicode: U+003b (;) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x40,  //.%
    0x00,  //..
    0x00,  //..
    0x40,  //.%
    0x40,  //.%
    0x80,  //%.


    /*Unicode: U+003c (<) , Width: 4 */
    0x10,  //...%
    0x20,  //..%.
    0x40,  //.%..
    0x80,  //%...
    0x40,  //.%..
    0x20,  //..%.
    0x10,  //...%
    0x00,  //....


    /*Unicode: U+003d (=) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0xf8,  //%%%%%
    0x00,  //.....
    0xf8,  //%%%%%
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+003e (>) , Width: 4 */
    0x80,  //%...
    0x40,  //.%..
    0x20,  //..%.
    0x10,  //...%
    0x20,  //..%.
    0x40,  //.%..
    0x80,  //%...
    0x00,  //....


    /*Unicode: U+003f (?) , Width: 6 */
    0x78,  //.%%%%.
    0x84,  //%....%
    0x08,  //....%.
    0x10,  //...%..
    0x10,  //...%..
    0x00,  //......
    0x10,  //...%..
    0x00,  //......


    /*Unicode: U+0040 (@) , Width: 6 */
    0x78,  //.%%%%.
    0x84,  //%....%
    0x94,  //%..%.%
    0xac,  //%.%.%%
    0x98,  //%..%%.
    0x80,  //%.....
    0x78,  //.%%%%.
    0x00,  //......


    /*Unicode: U+0041 (A) , Width: 6 */
    0x30,  //..%%..
    0x48,  //.%..%.
    0x84,  //%....%
    0xfc,  //%%%%%%
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x00,  //......


    /*Unicode: U+0042 (B) , Width: 6 */
    0xf8,  //%%%%%.
    0x84,  //%....%
    0x84,  //%....%
    0xf8,  //%%%%%.
    0x84,  //%....%
    0x84,  //%....%
    0xf8,  //%%%%%.
    0x00,  //......


    /*Unicode: U+0043 (C) , Width: 6 */
    0x78,  //.%%%%.
    0x84,  //%....%
    0x80,  //%.....
    0x80,  //%.....
    0x80,  //%.....
    0x84,  //%....%
    0x78,  //.%%%%.
    0x00,  //......


    /*Unicode: U+0044 (D) , Width: 6 */
    0xf0,  //%%%%..
    0x88,  //%...%.
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x88,  //%...%.
    0xf0,  //%%%%..
    0x00,  //......


    /*Unicode: U+0045 (E) , Width: 6 */
    0xfc,  //%%%%%%
    0x80,  //%.....
    0x80,  //%.....
    0xf0,  //%%%%..
    0x80,  //%.....
    0x80,  //%.....
    0xfc,  //%%%%%%
    0x00,  //......


    /*Unicode: U+0046 (F) , Width: 6 */
    0xfc,  //%%%%%%
    0x80,  //%.....
    0x80,  //%.....
    0xf0,  //%%%%..
    0x80,  //%.....
    0x80,  //%.....
    0x80,  //%.....
    0x00,  //......


    /*Unicode: U+0047 (G) , Width: 6 */
    0x78,  //.%%%%.
    0x84,  //%....%
    0x80,  //%.....
    0x9c,  //%..%%%
    0x84,  //%....%
    0x84,  //%....%
    0x78,  //.%%%%.
    0x00,  //......


    /*Unicode: U+0048 (H) , Width: 6 */
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0xfc,  //%%%%%%
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x00,  //......


    /*Unicode: U+0049 (I) , Width: 3 */
    0xe0,  //%%%
    0x40,  //.%.
    0x40,  //.%.
    0x40,  //.%.
    0x40,  //.%.
    0x40,  //.%.
    0xe0,  //%%%
    0x00,  //...


    /*Unicode: U+004a (J) , Width: 5 */
    0x08,  //....%
    0x08,  //....%
    0x08,  //....%
    0x08,  //....%
    0x08,  //....%
    0x88,  //%...%
    0x70,  //.%%%.
    0x00,  //.....


    /*Unicode: U+004b (K) , Width: 6 */
    0x84,  //%....%
    0x88,  //%...%.
    0x90,  //%..%..
    0xe0,  //%%%...
    0x90,  //%..%..
    0x88,  //%...%.
    0x84,  //%....%
    0x00,  //......


    /*Unicode: U+004c (L) , Width: 6 */
    0x80,  //%.....
    0x80,  //%.....
    0x80,  //%.....
    0x80,  //%.....
    0x80,  //%.....
    0x80,  //%.....
    0xfc,  //%%%%%%
    0x00,  //......


    /*Unicode: U+004d (M) , Width: 6 */
    0x84,  //%....%
    0xcc,  //%%..%%
    0xb4,  //%.%%.%
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x00,  //......


    /*Unicode: U+004e (N) , Width: 6 */
    0x84,  //%....%
    0xc4,  //%%...%
    0xa4,  //%.%..%
    0x94,  //%..%.%
    0x8c,  //%...%%
    0x84,  //%....%
    0x84,  //%....%
    0x00,  //......


    /*Unicode: U+004f (O) , Width: 6 */
    0x78,  //.%%%%.
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x78,  //.%%%%.
    0x00,  //......


    /*Unicode: U+0050 (P) , Width: 6 */
    0xf8,  //%%%%%.
    0x84,  //%....%
    0x84,  //%....%
    0xf8,  //%%%%%.
    0x80,  //%.....
    0x80,  //%.....
    0x80,  //%.....
    0x00,  //......


    /*Unicode: U+0051 (Q) , Width: 6 */
    0x78,  //.%%%%.
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x94,  //%..%.%
    0x88,  //%...%.
    0x74,  //.%%%.%
    0x00,  //......


    /*Unicode: U+0052 (R) , Width: 6 */
    0xf8,  //%%%%%.
    0x84,  //%....%
    0x84,  //%....%
    0xf8,  //%%%%%.
    0x90,  //%..%..
    0x88,  //%...%.
    0x84,  //%....%
    0x00,  //......


    /*Unicode: U+0053 (S) , Width: 6 */
    0x78,  //.%%%%.
    0x84,  //%....%
    0x80,  //%.....
    0x78,  //.%%%%.
    0x04,  //.....%
    0x84,  //%....%
    0x78,  //.%%%%.
    0x00,  //......


    /*Unicode: U+0054 (T) , Width: 5 */
    0xf8,  //%%%%%
    0x20,  //..%..
    0x20,  //..%..
    0x20,  //..%..
    0x20,  //..%..
    0x20,  //..%..
    0x20,  //..%..
    0x00,  //.....


    /*Unicode: U+0055 (U) , Width: 6 */
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x78,  //.%%%%.
    0x00,  //......


    /*Unicode: U+0056 (V) , Width: 6 */
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x48,  //.%..%.
    0x30,  //..%%..
    0x00,  //......


    /*Unicode: U+0057 (W) , Width: 6 */
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0x84,  //%....%
    0xb4,  //%.%%.%
    0xcc,  //%%..%%
    0x84,  //%....%
    0x00,  //......


    /*Unicode: U+0058 (X) , Width: 6 */
    0x84,  //%....%
    0x84,  //%....%
    0x48,  //.%..%.
    0x30,  //..%%..
    0x48,  //.%..%.
    0x84,  //%....%
    0x84,  //%....%
    0x00,  //......


    /*Unicode: U+0059 (Y) , Width: 5 */
    0x88,  //%...%
    0x88,  //%...%
    0x88,  //%...%
    0x70,  //.%%%.
    0x20,  //..%..
    0x20,  //..%..
    0x20,  //..%..
    0x00,  //.....


    /*Unicode: U+005a (Z) , Width: 5 */
    0xf8,  //%%%%%
    0x08,  //....%
    0x10,  //...%.
    0x20,  //..%..
    0x40,  //.%...
    0x80,  //%....
    0xf8,  //%%%%%
    0x00,  //.....


    /*Unicode: U+005b ([) , Width: 3 */
    0xe0,  //%%%
    0x80,  //%..
    0x80,  //%..
    0x80,  //%..
    0x80,  //%..
    0x80,  //%..
    0xe0,  //%%%
    0x00,  //...


    /*Unicode: U+005c (\) , Width: 7 */
    0x80,  //%......
    0x40,  //.%.....
    0x20,  //..%....
    0x10,  //...%...
    0x08,  //....%..
    0x04,  //.....%.
    0x02,  //......%
    0x00,  //.......


    /*Unicode: U+005d (]) , Width: 3 */
    0xe0,  //%%%
    0x20,  //..%
    0x20,  //..%
    0x20,  //..%
    0x20,  //..%
    0x20,  //..%
    0xe0,  //%%%
    0x00,  //...


    /*Unicode: U+005e (^) , Width: 5 */
    0x20,  //..%..
    0x50,  //.%.%.
    0x88,  //%...%
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+005f (_) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0xf8,  //%%%%%


    /*Unicode: U+0060 (`) , Width: 3 */
    0x80,  //%..
    0x40,  //.%.
    0x20,  //..%
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0061 (a) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x70,  //.%%%.
    0x08,  //....%
    0x78,  //.%%%%
    0x88,  //%...%
    0x78,  //.%%%%
    0x00,  //.....


    /*Unicode: U+0062 (b) , Width: 5 */
    0x80,  //%....
    0x80,  //%....
    0xf0,  //%%%%.
    0x88,  //%...%
    0x88,  //%...%
    0x88,  //%...%
    0xf0,  //%%%%.
    0x00,  //.....


    /*Unicode: U+0063 (c) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x70,  //.%%%.
    0x88,  //%...%
    0x80,  //%....
    0x88,  //%...%
    0x70,  //.%%%.
    0x00,  //.....


    /*Unicode: U+0064 (d) , Width: 5 */
    0x08,  //....%
    0x08,  //....%
    0x78,  //.%%%%
    0x88,  //%...%
    0x88,  //%...%
    0x88,  //%...%
    0x78,  //.%%%%
    0x00,  //.....


    /*Unicode: U+0065 (e) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x70,  //.%%%.
    0x88,  //%...%
    0xf8,  //%%%%%
    0x80,  //%....
    0x70,  //.%%%.
    0x00,  //.....


    /*Unicode: U+0066 (f) , Width: 6 */
    0x18,  //...%%.
    0x24,  //..%..%
    0x20,  //..%...
    0xf8,  //%%%%%.
    0x20,  //..%...
    0x20,  //..%...
    0x20,  //..%...
    0x00,  //......


    /*Unicode: U+0067 (g) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x78,  //.%%%%
    0x88,  //%...%
    0x88,  //%...%
    0x78,  //.%%%%
    0x08,  //....%
    0x70,  //.%%%.


    /*Unicode: U+0068 (h) , Width: 5 */
    0x80,  //%....
    0x80,  //%....
    0xf0,  //%%%%.
    0x88,  //%...%
    0x88,  //%...%
    0x88,  //%...%
    0x88,  //%...%
    0x00,  //.....


    /*Unicode: U+0069 (i) , Width: 3 */
    0x40,  //.%.
    0x00,  //...
    0xc0,  //%%.
    0x40,  //.%.
    0x40,  //.%.
    0x40,  //.%.
    0xe0,  //%%%
    0x00,  //...


    /*Unicode: U+006a (j) , Width: 4 */
    0x10,  //...%
    0x00,  //....
    0x30,  //..%%
    0x10,  //...%
    0x10,  //...%
    0x10,  //...%
    0x90,  //%..%
    0x60,  //.%%.


    /*Unicode: U+006b (k) , Width: 5 */
    0x80,  //%....
    0x80,  //%....
    0x88,  //%...%
    0x90,  //%..%.
    0xe0,  //%%%..
    0x90,  //%..%.
    0x88,  //%...%
    0x00,  //.....


    /*Unicode: U+006c (l) , Width: 3 */
    0xc0,  //%%.
    0x40,  //.%.
    0x40,  //.%.
    0x40,  //.%.
    0x40,  //.%.
    0x40,  //.%.
    0xe0,  //%%%
    0x00,  //...


    /*Unicode: U+006d (m) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0xd0,  //%%.%.
    0xa8,  //%.%.%
    0xa8,  //%.%.%
    0xa8,  //%.%.%
    0xa8,  //%.%.%
    0x00,  //.....


    /*Unicode: U+006e (n) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0xf0,  //%%%%.
    0x88,  //%...%
    0x88,  //%...%
    0x88,  //%...%
    0x88,  //%...%
    0x00,  //.....


    /*Unicode: U+006f (o) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x70,  //.%%%.
    0x88,  //%...%
    0x88,  //%...%
    0x88,  //%...%
    0x70,  //.%%%.
    0x00,  //.....


    /*Unicode: U+0070 (p) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0xf0,  //%%%%.
    0x88,  //%...%
    0x88,  //%...%
    0xf0,  //%%%%.
    0x80,  //%....
    0x80,  //%....


    /*Unicode: U+0071 (q) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x78,  //.%%%%
    0x88,  //%...%
    0x88,  //%...%
    0x78,  //.%%%%
    0x08,  //....%
    0x08,  //....%


    /*Unicode: U+0072 (r) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0xb8,  //%.%%%
    0xc0,  //%%...
    0x80,  //%....
    0x80,  //%....
    0x80,  //%....
    0x00,  //.....


    /*Unicode: U+0073 (s) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x78,  //.%%%%
    0x80,  //%....
    0x70,  //.%%%.
    0x08,  //....%
    0xf0,  //%%%%.
    0x00,  //.....


    /*Unicode: U+0074 (t) , Width: 5 */
    0x40,  //.%...
    0x40,  //.%...
    0xf0,  //%%%%.
    0x40,  //.%...
    0x40,  //.%...
    0x48,  //.%..%
    0x30,  //..%%.
    0x00,  //.....


    /*Unicode: U+0075 (u) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x88,  //%...%
    0x88,  //%...%
    0x88,  //%...%
    0x88,  //%...%
    0x70,  //.%%%.
    0x00,  //.....


    /*Unicode: U+0076 (v) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x88,  //%...%
    0x88,  //%...%
    0x88,  //%...%
    0x50,  //.%.%.
    0x20,  //..%..
    0x00,  //.....


    /*Unicode: U+0077 (w) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x88,  //%...%
    0xa8,  //%.%.%
    0xa8,  //%.%.%
    0xa8,  //%.%.%
    0x50,  //.%.%.
    0x00,  //.....


    /*Unicode: U+0078 (x) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x88,  //%...%
    0x50,  //.%.%.
    0x20,  //..%..
    0x50,  //.%.%.
    0x88,  //%...%
    0x00,  //.....


    /*Unicode: U+0079 (y) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x88,  //%...%
    0x88,  //%...%
    0x88,  //%...%
    0x78,  //.%%%%
    0x08,  //....%
    0x70,  //.%%%.


    /*Unicode: U+007a (z) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0xf8,  //%%%%%
    0x10,  //...%.
    0x20,  //..%..
    0x40,  //.%...
    0xf8,  //%%%%%
    0x00,  //.....


    /*Unicode: U+007b ({) , Width: 4 */
    0x30,  //..%%
    0x40,  //.%..
    0x40,  //.%..
    0x80,  //%...
    0x40,  //.%..
    0x40,  //.%..
    0x30,  //..%%
    0x00,  //....


    /*Unicode: U+007c (|) , Width: 1 */
    0x80,  //%
    0x80,  //%
    0x80,  //%
    0x80,  //%
    0x80,  //%
    0x80,  //%
    0x80,  //%
    0x80,  //%


    /*Unicode: U+007d (}) , Width: 4 */
    0xc0,  //%%..
    0x20,  //..%.
    0x20,  //..%.
    0x10,  //...%
    0x20,  //..%.
    0x20,  //..%.
    0xc0,  //%%..
    0x00,  //....


    /*Unicode: U+007e (~) , Width: 5 */
    0x40,  //.%...
    0xa8,  //%.%.%
    0x10,  //...%.
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....



#elif USE_LV_FONT_MONOSPACE_8 == 2
    /*Unicode: U+0020 ( ) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0021 (!) , Width: 1 */
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0x00,  //.
    0x00,  //.
    0xc0,  //@
    0x00,  //.


    /*Unicode: U+0022 (") , Width: 4 */
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0023 (#) , Width: 6 */
    0x30, 0xc0,  //.@..@.
    0x30, 0xc0,  //.@..@.
    0xff, 0xf0,  //@@@@@@
    0x30, 0xc0,  //.@..@.
    0xff, 0xf0,  //@@@@@@
    0x30, 0xc0,  //.@..@.
    0x30, 0xc0,  //.@..@.
    0x00, 0x00,  //......


    /*Unicode: U+0024 ($) , Width: 5 */
    0x0c, 0x00,  //..@..
    0x3f, 0xc0,  //.@@@@
    0xcc, 0x00,  //@.@..
    0x3f, 0x00,  //.@@@.
    0x0c, 0xc0,  //..@.@
    0xff, 0x00,  //@@@@.
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....


    /*Unicode: U+0025 (%) , Width: 6 */
    0x00, 0x00,  //......
    0xf0, 0x30,  //@@...@
    0xf0, 0xc0,  //@@..@.
    0x03, 0x00,  //...@..
    0x0c, 0x00,  //..@...
    0x30, 0xf0,  //.@..@@
    0xc0, 0xf0,  //@...@@
    0x00, 0x00,  //......


    /*Unicode: U+0026 (&) , Width: 6 */
    0x3c, 0x00,  //.@@...
    0xc3, 0x00,  //@..@..
    0xc3, 0x00,  //@..@..
    0x3c, 0x00,  //.@@...
    0xc3, 0x30,  //@..@.@
    0xc0, 0xc0,  //@...@.
    0x3f, 0x30,  //.@@@.@
    0x00, 0x00,  //......


    /*Unicode: U+0027 (') , Width: 3 */
    0x0c,  //..@
    0x30,  //.@.
    0xc0,  //@..
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0028 (() , Width: 3 */
    0x0c,  //..@
    0x30,  //.@.
    0xc0,  //@..
    0xc0,  //@..
    0xc0,  //@..
    0x30,  //.@.
    0x0c,  //..@
    0x00,  //...


    /*Unicode: U+0029 ()) , Width: 3 */
    0xc0,  //@..
    0x30,  //.@.
    0x0c,  //..@
    0x0c,  //..@
    0x0c,  //..@
    0x30,  //.@.
    0xc0,  //@..
    0x00,  //...


    /*Unicode: U+002a (*) , Width: 5 */
    0x0c, 0x00,  //..@..
    0xcc, 0xc0,  //@.@.@
    0x3f, 0x00,  //.@@@.
    0x0c, 0x00,  //..@..
    0x3f, 0x00,  //.@@@.
    0xcc, 0xc0,  //@.@.@
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....


    /*Unicode: U+002b (+) , Width: 5 */
    0x00, 0x00,  //.....
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0xff, 0xc0,  //@@@@@
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+002c (,) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x30,  //.@
    0x30,  //.@
    0xc0,  //@.


    /*Unicode: U+002d (-) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+002e (.) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xc0,  //@
    0x00,  //.


    /*Unicode: U+002f (/) , Width: 7 */
    0x00, 0x0c,  //......@
    0x00, 0x30,  //.....@.
    0x00, 0xc0,  //....@..
    0x03, 0x00,  //...@...
    0x0c, 0x00,  //..@....
    0x30, 0x00,  //.@.....
    0xc0, 0x00,  //@......
    0x00, 0x00,  //.......


    /*Unicode: U+0030 (0) , Width: 5 */
    0x3f, 0x00,  //.@@@.
    0xc0, 0xc0,  //@...@
    0xc3, 0xc0,  //@..@@
    0xcc, 0xc0,  //@.@.@
    0xf0, 0xc0,  //@@..@
    0xc0, 0xc0,  //@...@
    0x3f, 0x00,  //.@@@.
    0x00, 0x00,  //.....


    /*Unicode: U+0031 (1) , Width: 5 */
    0x0c, 0x00,  //..@..
    0x3c, 0x00,  //.@@..
    0xcc, 0x00,  //@.@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....


    /*Unicode: U+0032 (2) , Width: 5 */
    0x3f, 0x00,  //.@@@.
    0xc0, 0xc0,  //@...@
    0x00, 0xc0,  //....@
    0x03, 0x00,  //...@.
    0x3c, 0x00,  //.@@..
    0xc0, 0x00,  //@....
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....


    /*Unicode: U+0033 (3) , Width: 5 */
    0x3f, 0x00,  //.@@@.
    0xc0, 0xc0,  //@...@
    0x00, 0xc0,  //....@
    0x0f, 0x00,  //..@@.
    0x00, 0xc0,  //....@
    0xc0, 0xc0,  //@...@
    0x3f, 0x00,  //.@@@.
    0x00, 0x00,  //.....


    /*Unicode: U+0034 (4) , Width: 5 */
    0x03, 0x00,  //...@.
    0x0f, 0x00,  //..@@.
    0x33, 0x00,  //.@.@.
    0xc3, 0x00,  //@..@.
    0xff, 0xc0,  //@@@@@
    0x03, 0x00,  //...@.
    0x03, 0x00,  //...@.
    0x00, 0x00,  //.....


    /*Unicode: U+0035 (5) , Width: 5 */
    0xff, 0xc0,  //@@@@@
    0xc0, 0x00,  //@....
    0xff, 0x00,  //@@@@.
    0x00, 0xc0,  //....@
    0x00, 0xc0,  //....@
    0xc0, 0xc0,  //@...@
    0x3f, 0x00,  //.@@@.
    0x00, 0x00,  //.....


    /*Unicode: U+0036 (6) , Width: 5 */
    0x0f, 0xc0,  //..@@@
    0x30, 0x00,  //.@...
    0xc0, 0x00,  //@....
    0xff, 0x00,  //@@@@.
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0x3f, 0x00,  //.@@@.
    0x00, 0x00,  //.....


    /*Unicode: U+0037 (7) , Width: 5 */
    0xff, 0xc0,  //@@@@@
    0x00, 0xc0,  //....@
    0x03, 0x00,  //...@.
    0x0c, 0x00,  //..@..
    0x30, 0x00,  //.@...
    0x30, 0x00,  //.@...
    0x30, 0x00,  //.@...
    0x00, 0x00,  //.....


    /*Unicode: U+0038 (8) , Width: 5 */
    0x3f, 0x00,  //.@@@.
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0x3f, 0x00,  //.@@@.
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0x3f, 0x00,  //.@@@.
    0x00, 0x00,  //.....


    /*Unicode: U+0039 (9) , Width: 5 */
    0x3f, 0x00,  //.@@@.
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0x3f, 0xc0,  //.@@@@
    0x00, 0xc0,  //....@
    0x03, 0x00,  //...@.
    0xfc, 0x00,  //@@@..
    0x00, 0x00,  //.....


    /*Unicode: U+003a (:) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0xc0,  //@
    0x00,  //.
    0x00,  //.
    0xc0,  //@
    0x00,  //.
    0x00,  //.


    /*Unicode: U+003b (;) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x30,  //.@
    0x00,  //..
    0x00,  //..
    0x30,  //.@
    0x30,  //.@
    0xc0,  //@.


    /*Unicode: U+003c (<) , Width: 4 */
    0x03,  //...@
    0x0c,  //..@.
    0x30,  //.@..
    0xc0,  //@...
    0x30,  //.@..
    0x0c,  //..@.
    0x03,  //...@
    0x00,  //....


    /*Unicode: U+003d (=) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+003e (>) , Width: 4 */
    0xc0,  //@...
    0x30,  //.@..
    0x0c,  //..@.
    0x03,  //...@
    0x0c,  //..@.
    0x30,  //.@..
    0xc0,  //@...
    0x00,  //....


    /*Unicode: U+003f (?) , Width: 6 */
    0x3f, 0xc0,  //.@@@@.
    0xc0, 0x30,  //@....@
    0x00, 0xc0,  //....@.
    0x03, 0x00,  //...@..
    0x03, 0x00,  //...@..
    0x00, 0x00,  //......
    0x03, 0x00,  //...@..
    0x00, 0x00,  //......


    /*Unicode: U+0040 (@) , Width: 6 */
    0x3f, 0xc0,  //.@@@@.
    0xc0, 0x30,  //@....@
    0xc3, 0x30,  //@..@.@
    0xcc, 0xf0,  //@.@.@@
    0xc3, 0xc0,  //@..@@.
    0xc0, 0x00,  //@.....
    0x3f, 0xc0,  //.@@@@.
    0x00, 0x00,  //......


    /*Unicode: U+0041 (A) , Width: 6 */
    0x0f, 0x00,  //..@@..
    0x30, 0xc0,  //.@..@.
    0xc0, 0x30,  //@....@
    0xff, 0xf0,  //@@@@@@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0x00, 0x00,  //......


    /*Unicode: U+0042 (B) , Width: 6 */
    0xff, 0xc0,  //@@@@@.
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xff, 0xc0,  //@@@@@.
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xff, 0xc0,  //@@@@@.
    0x00, 0x00,  //......


    /*Unicode: U+0043 (C) , Width: 6 */
    0x3f, 0xc0,  //.@@@@.
    0xc0, 0x30,  //@....@
    0xc0, 0x00,  //@.....
    0xc0, 0x00,  //@.....
    0xc0, 0x00,  //@.....
    0xc0, 0x30,  //@....@
    0x3f, 0xc0,  //.@@@@.
    0x00, 0x00,  //......


    /*Unicode: U+0044 (D) , Width: 6 */
    0xff, 0x00,  //@@@@..
    0xc0, 0xc0,  //@...@.
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0xc0,  //@...@.
    0xff, 0x00,  //@@@@..
    0x00, 0x00,  //......


    /*Unicode: U+0045 (E) , Width: 6 */
    0xff, 0xf0,  //@@@@@@
    0xc0, 0x00,  //@.....
    0xc0, 0x00,  //@.....
    0xff, 0x00,  //@@@@..
    0xc0, 0x00,  //@.....
    0xc0, 0x00,  //@.....
    0xff, 0xf0,  //@@@@@@
    0x00, 0x00,  //......


    /*Unicode: U+0046 (F) , Width: 6 */
    0xff, 0xf0,  //@@@@@@
    0xc0, 0x00,  //@.....
    0xc0, 0x00,  //@.....
    0xff, 0x00,  //@@@@..
    0xc0, 0x00,  //@.....
    0xc0, 0x00,  //@.....
    0xc0, 0x00,  //@.....
    0x00, 0x00,  //......


    /*Unicode: U+0047 (G) , Width: 6 */
    0x3f, 0xc0,  //.@@@@.
    0xc0, 0x30,  //@....@
    0xc0, 0x00,  //@.....
    0xc3, 0xf0,  //@..@@@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0x3f, 0xc0,  //.@@@@.
    0x00, 0x00,  //......


    /*Unicode: U+0048 (H) , Width: 6 */
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xff, 0xf0,  //@@@@@@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0x00, 0x00,  //......


    /*Unicode: U+0049 (I) , Width: 3 */
    0xfc,  //@@@
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0xfc,  //@@@
    0x00,  //...


    /*Unicode: U+004a (J) , Width: 5 */
    0x00, 0xc0,  //....@
    0x00, 0xc0,  //....@
    0x00, 0xc0,  //....@
    0x00, 0xc0,  //....@
    0x00, 0xc0,  //....@
    0xc0, 0xc0,  //@...@
    0x3f, 0x00,  //.@@@.
    0x00, 0x00,  //.....


    /*Unicode: U+004b (K) , Width: 6 */
    0xc0, 0x30,  //@....@
    0xc0, 0xc0,  //@...@.
    0xc3, 0x00,  //@..@..
    0xfc, 0x00,  //@@@...
    0xc3, 0x00,  //@..@..
    0xc0, 0xc0,  //@...@.
    0xc0, 0x30,  //@....@
    0x00, 0x00,  //......


    /*Unicode: U+004c (L) , Width: 6 */
    0xc0, 0x00,  //@.....
    0xc0, 0x00,  //@.....
    0xc0, 0x00,  //@.....
    0xc0, 0x00,  //@.....
    0xc0, 0x00,  //@.....
    0xc0, 0x00,  //@.....
    0xff, 0xf0,  //@@@@@@
    0x00, 0x00,  //......


    /*Unicode: U+004d (M) , Width: 6 */
    0xc0, 0x30,  //@....@
    0xf0, 0xf0,  //@@..@@
    0xcf, 0x30,  //@.@@.@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0x00, 0x00,  //......


    /*Unicode: U+004e (N) , Width: 6 */
    0xc0, 0x30,  //@....@
    0xf0, 0x30,  //@@...@
    0xcc, 0x30,  //@.@..@
    0xc3, 0x30,  //@..@.@
    0xc0, 0xf0,  //@...@@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0x00, 0x00,  //......


    /*Unicode: U+004f (O) , Width: 6 */
    0x3f, 0xc0,  //.@@@@.
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0x3f, 0xc0,  //.@@@@.
    0x00, 0x00,  //......


    /*Unicode: U+0050 (P) , Width: 6 */
    0xff, 0xc0,  //@@@@@.
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xff, 0xc0,  //@@@@@.
    0xc0, 0x00,  //@.....
    0xc0, 0x00,  //@.....
    0xc0, 0x00,  //@.....
    0x00, 0x00,  //......


    /*Unicode: U+0051 (Q) , Width: 6 */
    0x3f, 0xc0,  //.@@@@.
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc3, 0x30,  //@..@.@
    0xc0, 0xc0,  //@...@.
    0x3f, 0x30,  //.@@@.@
    0x00, 0x00,  //......


    /*Unicode: U+0052 (R) , Width: 6 */
    0xff, 0xc0,  //@@@@@.
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xff, 0xc0,  //@@@@@.
    0xc3, 0x00,  //@..@..
    0xc0, 0xc0,  //@...@.
    0xc0, 0x30,  //@....@
    0x00, 0x00,  //......


    /*Unicode: U+0053 (S) , Width: 6 */
    0x3f, 0xc0,  //.@@@@.
    0xc0, 0x30,  //@....@
    0xc0, 0x00,  //@.....
    0x3f, 0xc0,  //.@@@@.
    0x00, 0x30,  //.....@
    0xc0, 0x30,  //@....@
    0x3f, 0xc0,  //.@@@@.
    0x00, 0x00,  //......


    /*Unicode: U+0054 (T) , Width: 5 */
    0xff, 0xc0,  //@@@@@
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....


    /*Unicode: U+0055 (U) , Width: 6 */
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0x3f, 0xc0,  //.@@@@.
    0x00, 0x00,  //......


    /*Unicode: U+0056 (V) , Width: 6 */
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0x30, 0xc0,  //.@..@.
    0x0f, 0x00,  //..@@..
    0x00, 0x00,  //......


    /*Unicode: U+0057 (W) , Width: 6 */
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xcf, 0x30,  //@.@@.@
    0xf0, 0xf0,  //@@..@@
    0xc0, 0x30,  //@....@
    0x00, 0x00,  //......


    /*Unicode: U+0058 (X) , Width: 6 */
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0x30, 0xc0,  //.@..@.
    0x0f, 0x00,  //..@@..
    0x30, 0xc0,  //.@..@.
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0x00, 0x00,  //......


    /*Unicode: U+0059 (Y) , Width: 5 */
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0x3f, 0x00,  //.@@@.
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....


    /*Unicode: U+005a (Z) , Width: 5 */
    0xff, 0xc0,  //@@@@@
    0x00, 0xc0,  //....@
    0x03, 0x00,  //...@.
    0x0c, 0x00,  //..@..
    0x30, 0x00,  //.@...
    0xc0, 0x00,  //@....
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....


    /*Unicode: U+005b ([) , Width: 3 */
    0xfc,  //@@@
    0xc0,  //@..
    0xc0,  //@..
    0xc0,  //@..
    0xc0,  //@..
    0xc0,  //@..
    0xfc,  //@@@
    0x00,  //...


    /*Unicode: U+005c (\) , Width: 7 */
    0xc0, 0x00,  //@......
    0x30, 0x00,  //.@.....
    0x0c, 0x00,  //..@....
    0x03, 0x00,  //...@...
    0x00, 0xc0,  //....@..
    0x00, 0x30,  //.....@.
    0x00, 0x0c,  //......@
    0x00, 0x00,  //.......


    /*Unicode: U+005d (]) , Width: 3 */
    0xfc,  //@@@
    0x0c,  //..@
    0x0c,  //..@
    0x0c,  //..@
    0x0c,  //..@
    0x0c,  //..@
    0xfc,  //@@@
    0x00,  //...


    /*Unicode: U+005e (^) , Width: 5 */
    0x0c, 0x00,  //..@..
    0x33, 0x00,  //.@.@.
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+005f (_) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xff, 0xc0,  //@@@@@


    /*Unicode: U+0060 (`) , Width: 3 */
    0xc0,  //@..
    0x30,  //.@.
    0x0c,  //..@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0061 (a) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x3f, 0x00,  //.@@@.
    0x00, 0xc0,  //....@
    0x3f, 0xc0,  //.@@@@
    0xc0, 0xc0,  //@...@
    0x3f, 0xc0,  //.@@@@
    0x00, 0x00,  //.....


    /*Unicode: U+0062 (b) , Width: 5 */
    0xc0, 0x00,  //@....
    0xc0, 0x00,  //@....
    0xff, 0x00,  //@@@@.
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xff, 0x00,  //@@@@.
    0x00, 0x00,  //.....


    /*Unicode: U+0063 (c) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x3f, 0x00,  //.@@@.
    0xc0, 0xc0,  //@...@
    0xc0, 0x00,  //@....
    0xc0, 0xc0,  //@...@
    0x3f, 0x00,  //.@@@.
    0x00, 0x00,  //.....


    /*Unicode: U+0064 (d) , Width: 5 */
    0x00, 0xc0,  //....@
    0x00, 0xc0,  //....@
    0x3f, 0xc0,  //.@@@@
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0x3f, 0xc0,  //.@@@@
    0x00, 0x00,  //.....


    /*Unicode: U+0065 (e) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x3f, 0x00,  //.@@@.
    0xc0, 0xc0,  //@...@
    0xff, 0xc0,  //@@@@@
    0xc0, 0x00,  //@....
    0x3f, 0x00,  //.@@@.
    0x00, 0x00,  //.....


    /*Unicode: U+0066 (f) , Width: 6 */
    0x03, 0xc0,  //...@@.
    0x0c, 0x30,  //..@..@
    0x0c, 0x00,  //..@...
    0xff, 0xc0,  //@@@@@.
    0x0c, 0x00,  //..@...
    0x0c, 0x00,  //..@...
    0x0c, 0x00,  //..@...
    0x00, 0x00,  //......


    /*Unicode: U+0067 (g) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x3f, 0xc0,  //.@@@@
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0x3f, 0xc0,  //.@@@@
    0x00, 0xc0,  //....@
    0x3f, 0x00,  //.@@@.


    /*Unicode: U+0068 (h) , Width: 5 */
    0xc0, 0x00,  //@....
    0xc0, 0x00,  //@....
    0xff, 0x00,  //@@@@.
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....


    /*Unicode: U+0069 (i) , Width: 3 */
    0x30,  //.@.
    0x00,  //...
    0xf0,  //@@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0xfc,  //@@@
    0x00,  //...


    /*Unicode: U+006a (j) , Width: 4 */
    0x03,  //...@
    0x00,  //....
    0x0f,  //..@@
    0x03,  //...@
    0x03,  //...@
    0x03,  //...@
    0xc3,  //@..@
    0x3c,  //.@@.


    /*Unicode: U+006b (k) , Width: 5 */
    0xc0, 0x00,  //@....
    0xc0, 0x00,  //@....
    0xc0, 0xc0,  //@...@
    0xc3, 0x00,  //@..@.
    0xfc, 0x00,  //@@@..
    0xc3, 0x00,  //@..@.
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....


    /*Unicode: U+006c (l) , Width: 3 */
    0xf0,  //@@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0xfc,  //@@@
    0x00,  //...


    /*Unicode: U+006d (m) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xf3, 0x00,  //@@.@.
    0xcc, 0xc0,  //@.@.@
    0xcc, 0xc0,  //@.@.@
    0xcc, 0xc0,  //@.@.@
    0xcc, 0xc0,  //@.@.@
    0x00, 0x00,  //.....


    /*Unicode: U+006e (n) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xff, 0x00,  //@@@@.
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....


    /*Unicode: U+006f (o) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x3f, 0x00,  //.@@@.
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0x3f, 0x00,  //.@@@.
    0x00, 0x00,  //.....


    /*Unicode: U+0070 (p) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xff, 0x00,  //@@@@.
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xff, 0x00,  //@@@@.
    0xc0, 0x00,  //@....
    0xc0, 0x00,  //@....


    /*Unicode: U+0071 (q) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x3f, 0xc0,  //.@@@@
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0x3f, 0xc0,  //.@@@@
    0x00, 0xc0,  //....@
    0x00, 0xc0,  //....@


    /*Unicode: U+0072 (r) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xcf, 0xc0,  //@.@@@
    0xf0, 0x00,  //@@...
    0xc0, 0x00,  //@....
    0xc0, 0x00,  //@....
    0xc0, 0x00,  //@....
    0x00, 0x00,  //.....


    /*Unicode: U+0073 (s) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x3f, 0xc0,  //.@@@@
    0xc0, 0x00,  //@....
    0x3f, 0x00,  //.@@@.
    0x00, 0xc0,  //....@
    0xff, 0x00,  //@@@@.
    0x00, 0x00,  //.....


    /*Unicode: U+0074 (t) , Width: 5 */
    0x30, 0x00,  //.@...
    0x30, 0x00,  //.@...
    0xff, 0x00,  //@@@@.
    0x30, 0x00,  //.@...
    0x30, 0x00,  //.@...
    0x30, 0xc0,  //.@..@
    0x0f, 0x00,  //..@@.
    0x00, 0x00,  //.....


    /*Unicode: U+0075 (u) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0x3f, 0x00,  //.@@@.
    0x00, 0x00,  //.....


    /*Unicode: U+0076 (v) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0x33, 0x00,  //.@.@.
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....


    /*Unicode: U+0077 (w) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xc0, 0xc0,  //@...@
    0xcc, 0xc0,  //@.@.@
    0xcc, 0xc0,  //@.@.@
    0xcc, 0xc0,  //@.@.@
    0x33, 0x00,  //.@.@.
    0x00, 0x00,  //.....


    /*Unicode: U+0078 (x) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xc0, 0xc0,  //@...@
    0x33, 0x00,  //.@.@.
    0x0c, 0x00,  //..@..
    0x33, 0x00,  //.@.@.
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....


    /*Unicode: U+0079 (y) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0x3f, 0xc0,  //.@@@@
    0x00, 0xc0,  //....@
    0x3f, 0x00,  //.@@@.


    /*Unicode: U+007a (z) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xff, 0xc0,  //@@@@@
    0x03, 0x00,  //...@.
    0x0c, 0x00,  //..@..
    0x30, 0x00,  //.@...
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....


    /*Unicode: U+007b ({) , Width: 4 */
    0x0f,  //..@@
    0x30,  //.@..
    0x30,  //.@..
    0xc0,  //@...
    0x30,  //.@..
    0x30,  //.@..
    0x0f,  //..@@
    0x00,  //....


    /*Unicode: U+007c (|) , Width: 1 */
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@


    /*Unicode: U+007d (}) , Width: 4 */
    0xf0,  //@@..
    0x0c,  //..@.
    0x0c,  //..@.
    0x03,  //...@
    0x0c,  //..@.
    0x0c,  //..@.
    0xf0,  //@@..
    0x00,  //....


    /*Unicode: U+007e (~) , Width: 5 */
    0x30, 0x00,  //.@...
    0xcc, 0xc0,  //@.@.@
    0x03, 0x00,  //...@.
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....



#elif USE_LV_FONT_MONOSPACE_8 == 4
    /*Unicode: U+0020 ( ) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0021 (!) , Width: 1 */
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0x00,  //.
    0x00,  //.
    0xf0,  //@
    0x00,  //.


    /*Unicode: U+0022 (") , Width: 4 */
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0023 (#) , Width: 6 */
    0x0f, 0x00, 0xf0,  //.@..@.
    0x0f, 0x00, 0xf0,  //.@..@.
    0xff, 0xff, 0xff,  //@@@@@@
    0x0f, 0x00, 0xf0,  //.@..@.
    0xff, 0xff, 0xff,  //@@@@@@
    0x0f, 0x00, 0xf0,  //.@..@.
    0x0f, 0x00, 0xf0,  //.@..@.
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0024 ($) , Width: 5 */
    0x00, 0xf0, 0x00,  //..@..
    0x0f, 0xff, 0xf0,  //.@@@@
    0xf0, 0xf0, 0x00,  //@.@..
    0x0f, 0xff, 0x00,  //.@@@.
    0x00, 0xf0, 0xf0,  //..@.@
    0xff, 0xff, 0x00,  //@@@@.
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0025 (%) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0xff, 0x00, 0x0f,  //@@...@
    0xff, 0x00, 0xf0,  //@@..@.
    0x00, 0x0f, 0x00,  //...@..
    0x00, 0xf0, 0x00,  //..@...
    0x0f, 0x00, 0xff,  //.@..@@
    0xf0, 0x00, 0xff,  //@...@@
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0026 (&) , Width: 6 */
    0x0f, 0xf0, 0x00,  //.@@...
    0xf0, 0x0f, 0x00,  //@..@..
    0xf0, 0x0f, 0x00,  //@..@..
    0x0f, 0xf0, 0x00,  //.@@...
    0xf0, 0x0f, 0x0f,  //@..@.@
    0xf0, 0x00, 0xf0,  //@...@.
    0x0f, 0xff, 0x0f,  //.@@@.@
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0027 (') , Width: 3 */
    0x00, 0xf0,  //..@
    0x0f, 0x00,  //.@.
    0xf0, 0x00,  //@..
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0028 (() , Width: 3 */
    0x00, 0xf0,  //..@
    0x0f, 0x00,  //.@.
    0xf0, 0x00,  //@..
    0xf0, 0x00,  //@..
    0xf0, 0x00,  //@..
    0x0f, 0x00,  //.@.
    0x00, 0xf0,  //..@
    0x00, 0x00,  //...


    /*Unicode: U+0029 ()) , Width: 3 */
    0xf0, 0x00,  //@..
    0x0f, 0x00,  //.@.
    0x00, 0xf0,  //..@
    0x00, 0xf0,  //..@
    0x00, 0xf0,  //..@
    0x0f, 0x00,  //.@.
    0xf0, 0x00,  //@..
    0x00, 0x00,  //...


    /*Unicode: U+002a (*) , Width: 5 */
    0x00, 0xf0, 0x00,  //..@..
    0xf0, 0xf0, 0xf0,  //@.@.@
    0x0f, 0xff, 0x00,  //.@@@.
    0x00, 0xf0, 0x00,  //..@..
    0x0f, 0xff, 0x00,  //.@@@.
    0xf0, 0xf0, 0xf0,  //@.@.@
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+002b (+) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+002c (,) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x0f,  //.@
    0x0f,  //.@
    0xf0,  //@.


    /*Unicode: U+002d (-) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+002e (.) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xf0,  //@
    0x00,  //.


    /*Unicode: U+002f (/) , Width: 7 */
    0x00, 0x00, 0x00, 0xf0,  //......@
    0x00, 0x00, 0x0f, 0x00,  //.....@.
    0x00, 0x00, 0xf0, 0x00,  //....@..
    0x00, 0x0f, 0x00, 0x00,  //...@...
    0x00, 0xf0, 0x00, 0x00,  //..@....
    0x0f, 0x00, 0x00, 0x00,  //.@.....
    0xf0, 0x00, 0x00, 0x00,  //@......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0030 (0) , Width: 5 */
    0x0f, 0xff, 0x00,  //.@@@.
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x0f, 0xf0,  //@..@@
    0xf0, 0xf0, 0xf0,  //@.@.@
    0xff, 0x00, 0xf0,  //@@..@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0031 (1) , Width: 5 */
    0x00, 0xf0, 0x00,  //..@..
    0x0f, 0xf0, 0x00,  //.@@..
    0xf0, 0xf0, 0x00,  //@.@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0032 (2) , Width: 5 */
    0x0f, 0xff, 0x00,  //.@@@.
    0xf0, 0x00, 0xf0,  //@...@
    0x00, 0x00, 0xf0,  //....@
    0x00, 0x0f, 0x00,  //...@.
    0x0f, 0xf0, 0x00,  //.@@..
    0xf0, 0x00, 0x00,  //@....
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0033 (3) , Width: 5 */
    0x0f, 0xff, 0x00,  //.@@@.
    0xf0, 0x00, 0xf0,  //@...@
    0x00, 0x00, 0xf0,  //....@
    0x00, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0xf0,  //....@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0034 (4) , Width: 5 */
    0x00, 0x0f, 0x00,  //...@.
    0x00, 0xff, 0x00,  //..@@.
    0x0f, 0x0f, 0x00,  //.@.@.
    0xf0, 0x0f, 0x00,  //@..@.
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x0f, 0x00,  //...@.
    0x00, 0x0f, 0x00,  //...@.
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0035 (5) , Width: 5 */
    0xff, 0xff, 0xf0,  //@@@@@
    0xf0, 0x00, 0x00,  //@....
    0xff, 0xff, 0x00,  //@@@@.
    0x00, 0x00, 0xf0,  //....@
    0x00, 0x00, 0xf0,  //....@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0036 (6) , Width: 5 */
    0x00, 0xff, 0xf0,  //..@@@
    0x0f, 0x00, 0x00,  //.@...
    0xf0, 0x00, 0x00,  //@....
    0xff, 0xff, 0x00,  //@@@@.
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0037 (7) , Width: 5 */
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0xf0,  //....@
    0x00, 0x0f, 0x00,  //...@.
    0x00, 0xf0, 0x00,  //..@..
    0x0f, 0x00, 0x00,  //.@...
    0x0f, 0x00, 0x00,  //.@...
    0x0f, 0x00, 0x00,  //.@...
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0038 (8) , Width: 5 */
    0x0f, 0xff, 0x00,  //.@@@.
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0x00,  //.@@@.
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0039 (9) , Width: 5 */
    0x0f, 0xff, 0x00,  //.@@@.
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0xf0,  //.@@@@
    0x00, 0x00, 0xf0,  //....@
    0x00, 0x0f, 0x00,  //...@.
    0xff, 0xf0, 0x00,  //@@@..
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+003a (:) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0xf0,  //@
    0x00,  //.
    0x00,  //.
    0xf0,  //@
    0x00,  //.
    0x00,  //.


    /*Unicode: U+003b (;) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x0f,  //.@
    0x00,  //..
    0x00,  //..
    0x0f,  //.@
    0x0f,  //.@
    0xf0,  //@.


    /*Unicode: U+003c (<) , Width: 4 */
    0x00, 0x0f,  //...@
    0x00, 0xf0,  //..@.
    0x0f, 0x00,  //.@..
    0xf0, 0x00,  //@...
    0x0f, 0x00,  //.@..
    0x00, 0xf0,  //..@.
    0x00, 0x0f,  //...@
    0x00, 0x00,  //....


    /*Unicode: U+003d (=) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+003e (>) , Width: 4 */
    0xf0, 0x00,  //@...
    0x0f, 0x00,  //.@..
    0x00, 0xf0,  //..@.
    0x00, 0x0f,  //...@
    0x00, 0xf0,  //..@.
    0x0f, 0x00,  //.@..
    0xf0, 0x00,  //@...
    0x00, 0x00,  //....


    /*Unicode: U+003f (?) , Width: 6 */
    0x0f, 0xff, 0xf0,  //.@@@@.
    0xf0, 0x00, 0x0f,  //@....@
    0x00, 0x00, 0xf0,  //....@.
    0x00, 0x0f, 0x00,  //...@..
    0x00, 0x0f, 0x00,  //...@..
    0x00, 0x00, 0x00,  //......
    0x00, 0x0f, 0x00,  //...@..
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0040 (@) , Width: 6 */
    0x0f, 0xff, 0xf0,  //.@@@@.
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x0f, 0x0f,  //@..@.@
    0xf0, 0xf0, 0xff,  //@.@.@@
    0xf0, 0x0f, 0xf0,  //@..@@.
    0xf0, 0x00, 0x00,  //@.....
    0x0f, 0xff, 0xf0,  //.@@@@.
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0041 (A) , Width: 6 */
    0x00, 0xff, 0x00,  //..@@..
    0x0f, 0x00, 0xf0,  //.@..@.
    0xf0, 0x00, 0x0f,  //@....@
    0xff, 0xff, 0xff,  //@@@@@@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0042 (B) , Width: 6 */
    0xff, 0xff, 0xf0,  //@@@@@.
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xff, 0xff, 0xf0,  //@@@@@.
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xff, 0xff, 0xf0,  //@@@@@.
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0043 (C) , Width: 6 */
    0x0f, 0xff, 0xf0,  //.@@@@.
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x00,  //@.....
    0xf0, 0x00, 0x00,  //@.....
    0xf0, 0x00, 0x00,  //@.....
    0xf0, 0x00, 0x0f,  //@....@
    0x0f, 0xff, 0xf0,  //.@@@@.
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0044 (D) , Width: 6 */
    0xff, 0xff, 0x00,  //@@@@..
    0xf0, 0x00, 0xf0,  //@...@.
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0xf0,  //@...@.
    0xff, 0xff, 0x00,  //@@@@..
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0045 (E) , Width: 6 */
    0xff, 0xff, 0xff,  //@@@@@@
    0xf0, 0x00, 0x00,  //@.....
    0xf0, 0x00, 0x00,  //@.....
    0xff, 0xff, 0x00,  //@@@@..
    0xf0, 0x00, 0x00,  //@.....
    0xf0, 0x00, 0x00,  //@.....
    0xff, 0xff, 0xff,  //@@@@@@
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0046 (F) , Width: 6 */
    0xff, 0xff, 0xff,  //@@@@@@
    0xf0, 0x00, 0x00,  //@.....
    0xf0, 0x00, 0x00,  //@.....
    0xff, 0xff, 0x00,  //@@@@..
    0xf0, 0x00, 0x00,  //@.....
    0xf0, 0x00, 0x00,  //@.....
    0xf0, 0x00, 0x00,  //@.....
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0047 (G) , Width: 6 */
    0x0f, 0xff, 0xf0,  //.@@@@.
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x00,  //@.....
    0xf0, 0x0f, 0xff,  //@..@@@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0x0f, 0xff, 0xf0,  //.@@@@.
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0048 (H) , Width: 6 */
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xff, 0xff, 0xff,  //@@@@@@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0049 (I) , Width: 3 */
    0xff, 0xf0,  //@@@
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...


    /*Unicode: U+004a (J) , Width: 5 */
    0x00, 0x00, 0xf0,  //....@
    0x00, 0x00, 0xf0,  //....@
    0x00, 0x00, 0xf0,  //....@
    0x00, 0x00, 0xf0,  //....@
    0x00, 0x00, 0xf0,  //....@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+004b (K) , Width: 6 */
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0xf0,  //@...@.
    0xf0, 0x0f, 0x00,  //@..@..
    0xff, 0xf0, 0x00,  //@@@...
    0xf0, 0x0f, 0x00,  //@..@..
    0xf0, 0x00, 0xf0,  //@...@.
    0xf0, 0x00, 0x0f,  //@....@
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+004c (L) , Width: 6 */
    0xf0, 0x00, 0x00,  //@.....
    0xf0, 0x00, 0x00,  //@.....
    0xf0, 0x00, 0x00,  //@.....
    0xf0, 0x00, 0x00,  //@.....
    0xf0, 0x00, 0x00,  //@.....
    0xf0, 0x00, 0x00,  //@.....
    0xff, 0xff, 0xff,  //@@@@@@
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+004d (M) , Width: 6 */
    0xf0, 0x00, 0x0f,  //@....@
    0xff, 0x00, 0xff,  //@@..@@
    0xf0, 0xff, 0x0f,  //@.@@.@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+004e (N) , Width: 6 */
    0xf0, 0x00, 0x0f,  //@....@
    0xff, 0x00, 0x0f,  //@@...@
    0xf0, 0xf0, 0x0f,  //@.@..@
    0xf0, 0x0f, 0x0f,  //@..@.@
    0xf0, 0x00, 0xff,  //@...@@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+004f (O) , Width: 6 */
    0x0f, 0xff, 0xf0,  //.@@@@.
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0x0f, 0xff, 0xf0,  //.@@@@.
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0050 (P) , Width: 6 */
    0xff, 0xff, 0xf0,  //@@@@@.
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xff, 0xff, 0xf0,  //@@@@@.
    0xf0, 0x00, 0x00,  //@.....
    0xf0, 0x00, 0x00,  //@.....
    0xf0, 0x00, 0x00,  //@.....
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0051 (Q) , Width: 6 */
    0x0f, 0xff, 0xf0,  //.@@@@.
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x0f, 0x0f,  //@..@.@
    0xf0, 0x00, 0xf0,  //@...@.
    0x0f, 0xff, 0x0f,  //.@@@.@
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0052 (R) , Width: 6 */
    0xff, 0xff, 0xf0,  //@@@@@.
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xff, 0xff, 0xf0,  //@@@@@.
    0xf0, 0x0f, 0x00,  //@..@..
    0xf0, 0x00, 0xf0,  //@...@.
    0xf0, 0x00, 0x0f,  //@....@
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0053 (S) , Width: 6 */
    0x0f, 0xff, 0xf0,  //.@@@@.
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x00,  //@.....
    0x0f, 0xff, 0xf0,  //.@@@@.
    0x00, 0x00, 0x0f,  //.....@
    0xf0, 0x00, 0x0f,  //@....@
    0x0f, 0xff, 0xf0,  //.@@@@.
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0054 (T) , Width: 5 */
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0055 (U) , Width: 6 */
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0x0f, 0xff, 0xf0,  //.@@@@.
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0056 (V) , Width: 6 */
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0x0f, 0x00, 0xf0,  //.@..@.
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0057 (W) , Width: 6 */
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0xff, 0x0f,  //@.@@.@
    0xff, 0x00, 0xff,  //@@..@@
    0xf0, 0x00, 0x0f,  //@....@
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0058 (X) , Width: 6 */
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0x0f, 0x00, 0xf0,  //.@..@.
    0x00, 0xff, 0x00,  //..@@..
    0x0f, 0x00, 0xf0,  //.@..@.
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0059 (Y) , Width: 5 */
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0x00,  //.@@@.
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+005a (Z) , Width: 5 */
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0xf0,  //....@
    0x00, 0x0f, 0x00,  //...@.
    0x00, 0xf0, 0x00,  //..@..
    0x0f, 0x00, 0x00,  //.@...
    0xf0, 0x00, 0x00,  //@....
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+005b ([) , Width: 3 */
    0xff, 0xf0,  //@@@
    0xf0, 0x00,  //@..
    0xf0, 0x00,  //@..
    0xf0, 0x00,  //@..
    0xf0, 0x00,  //@..
    0xf0, 0x00,  //@..
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...


    /*Unicode: U+005c (\) , Width: 7 */
    0xf0, 0x00, 0x00, 0x00,  //@......
    0x0f, 0x00, 0x00, 0x00,  //.@.....
    0x00, 0xf0, 0x00, 0x00,  //..@....
    0x00, 0x0f, 0x00, 0x00,  //...@...
    0x00, 0x00, 0xf0, 0x00,  //....@..
    0x00, 0x00, 0x0f, 0x00,  //.....@.
    0x00, 0x00, 0x00, 0xf0,  //......@
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+005d (]) , Width: 3 */
    0xff, 0xf0,  //@@@
    0x00, 0xf0,  //..@
    0x00, 0xf0,  //..@
    0x00, 0xf0,  //..@
    0x00, 0xf0,  //..@
    0x00, 0xf0,  //..@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...


    /*Unicode: U+005e (^) , Width: 5 */
    0x00, 0xf0, 0x00,  //..@..
    0x0f, 0x0f, 0x00,  //.@.@.
    0xf0, 0x00, 0xf0,  //@...@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+005f (_) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xf0,  //@@@@@


    /*Unicode: U+0060 (`) , Width: 3 */
    0xf0, 0x00,  //@..
    0x0f, 0x00,  //.@.
    0x00, 0xf0,  //..@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0061 (a) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x0f, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0xf0,  //....@
    0x0f, 0xff, 0xf0,  //.@@@@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0xf0,  //.@@@@
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0062 (b) , Width: 5 */
    0xf0, 0x00, 0x00,  //@....
    0xf0, 0x00, 0x00,  //@....
    0xff, 0xff, 0x00,  //@@@@.
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0xff, 0xff, 0x00,  //@@@@.
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0063 (c) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x0f, 0xff, 0x00,  //.@@@.
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0x00,  //@....
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0064 (d) , Width: 5 */
    0x00, 0x00, 0xf0,  //....@
    0x00, 0x00, 0xf0,  //....@
    0x0f, 0xff, 0xf0,  //.@@@@
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0xf0,  //.@@@@
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0065 (e) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x0f, 0xff, 0x00,  //.@@@.
    0xf0, 0x00, 0xf0,  //@...@
    0xff, 0xff, 0xf0,  //@@@@@
    0xf0, 0x00, 0x00,  //@....
    0x0f, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0066 (f) , Width: 6 */
    0x00, 0x0f, 0xf0,  //...@@.
    0x00, 0xf0, 0x0f,  //..@..@
    0x00, 0xf0, 0x00,  //..@...
    0xff, 0xff, 0xf0,  //@@@@@.
    0x00, 0xf0, 0x00,  //..@...
    0x00, 0xf0, 0x00,  //..@...
    0x00, 0xf0, 0x00,  //..@...
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0067 (g) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x0f, 0xff, 0xf0,  //.@@@@
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0xf0,  //.@@@@
    0x00, 0x00, 0xf0,  //....@
    0x0f, 0xff, 0x00,  //.@@@.


    /*Unicode: U+0068 (h) , Width: 5 */
    0xf0, 0x00, 0x00,  //@....
    0xf0, 0x00, 0x00,  //@....
    0xff, 0xff, 0x00,  //@@@@.
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0069 (i) , Width: 3 */
    0x0f, 0x00,  //.@.
    0x00, 0x00,  //...
    0xff, 0x00,  //@@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...


    /*Unicode: U+006a (j) , Width: 4 */
    0x00, 0x0f,  //...@
    0x00, 0x00,  //....
    0x00, 0xff,  //..@@
    0x00, 0x0f,  //...@
    0x00, 0x0f,  //...@
    0x00, 0x0f,  //...@
    0xf0, 0x0f,  //@..@
    0x0f, 0xf0,  //.@@.


    /*Unicode: U+006b (k) , Width: 5 */
    0xf0, 0x00, 0x00,  //@....
    0xf0, 0x00, 0x00,  //@....
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x0f, 0x00,  //@..@.
    0xff, 0xf0, 0x00,  //@@@..
    0xf0, 0x0f, 0x00,  //@..@.
    0xf0, 0x00, 0xf0,  //@...@
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+006c (l) , Width: 3 */
    0xff, 0x00,  //@@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...


    /*Unicode: U+006d (m) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xff, 0x0f, 0x00,  //@@.@.
    0xf0, 0xf0, 0xf0,  //@.@.@
    0xf0, 0xf0, 0xf0,  //@.@.@
    0xf0, 0xf0, 0xf0,  //@.@.@
    0xf0, 0xf0, 0xf0,  //@.@.@
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+006e (n) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0x00,  //@@@@.
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+006f (o) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x0f, 0xff, 0x00,  //.@@@.
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0070 (p) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0x00,  //@@@@.
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0xff, 0xff, 0x00,  //@@@@.
    0xf0, 0x00, 0x00,  //@....
    0xf0, 0x00, 0x00,  //@....


    /*Unicode: U+0071 (q) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x0f, 0xff, 0xf0,  //.@@@@
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0xf0,  //.@@@@
    0x00, 0x00, 0xf0,  //....@
    0x00, 0x00, 0xf0,  //....@


    /*Unicode: U+0072 (r) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xf0, 0xff, 0xf0,  //@.@@@
    0xff, 0x00, 0x00,  //@@...
    0xf0, 0x00, 0x00,  //@....
    0xf0, 0x00, 0x00,  //@....
    0xf0, 0x00, 0x00,  //@....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0073 (s) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x0f, 0xff, 0xf0,  //.@@@@
    0xf0, 0x00, 0x00,  //@....
    0x0f, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0xf0,  //....@
    0xff, 0xff, 0x00,  //@@@@.
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0074 (t) , Width: 5 */
    0x0f, 0x00, 0x00,  //.@...
    0x0f, 0x00, 0x00,  //.@...
    0xff, 0xff, 0x00,  //@@@@.
    0x0f, 0x00, 0x00,  //.@...
    0x0f, 0x00, 0x00,  //.@...
    0x0f, 0x00, 0xf0,  //.@..@
    0x00, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0075 (u) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0076 (v) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0x0f, 0x00,  //.@.@.
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0077 (w) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0xf0, 0xf0,  //@.@.@
    0xf0, 0xf0, 0xf0,  //@.@.@
    0xf0, 0xf0, 0xf0,  //@.@.@
    0x0f, 0x0f, 0x00,  //.@.@.
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0078 (x) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0x0f, 0x00,  //.@.@.
    0x00, 0xf0, 0x00,  //..@..
    0x0f, 0x0f, 0x00,  //.@.@.
    0xf0, 0x00, 0xf0,  //@...@
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0079 (y) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0xf0, 0x00, 0xf0,  //@...@
    0x0f, 0xff, 0xf0,  //.@@@@
    0x00, 0x00, 0xf0,  //....@
    0x0f, 0xff, 0x00,  //.@@@.


    /*Unicode: U+007a (z) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x0f, 0x00,  //...@.
    0x00, 0xf0, 0x00,  //..@..
    0x0f, 0x00, 0x00,  //.@...
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+007b ({) , Width: 4 */
    0x00, 0xff,  //..@@
    0x0f, 0x00,  //.@..
    0x0f, 0x00,  //.@..
    0xf0, 0x00,  //@...
    0x0f, 0x00,  //.@..
    0x0f, 0x00,  //.@..
    0x00, 0xff,  //..@@
    0x00, 0x00,  //....


    /*Unicode: U+007c (|) , Width: 1 */
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@


    /*Unicode: U+007d (}) , Width: 4 */
    0xff, 0x00,  //@@..
    0x00, 0xf0,  //..@.
    0x00, 0xf0,  //..@.
    0x00, 0x0f,  //...@
    0x00, 0xf0,  //..@.
    0x00, 0xf0,  //..@.
    0xff, 0x00,  //@@..
    0x00, 0x00,  //....


    /*Unicode: U+007e (~) , Width: 5 */
    0x0f, 0x00, 0x00,  //.@...
    0xf0, 0xf0, 0xf0,  //@.@.@
    0x00, 0x0f, 0x00,  //...@.
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....



#elif USE_LV_FONT_MONOSPACE_8 == 8
    /*Unicode: U+0020 ( ) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0021 (!) , Width: 1 */
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0x00,  //.
    0x00,  //.
    0xff,  //@
    0x00,  //.


    /*Unicode: U+0022 (") , Width: 4 */
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0023 (#) , Width: 6 */
    0x00, 0xff, 0x00, 0x00, 0xff, 0x00,  //.@..@.
    0x00, 0xff, 0x00, 0x00, 0xff, 0x00,  //.@..@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0x00, 0xff, 0x00, 0x00, 0xff, 0x00,  //.@..@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0x00, 0xff, 0x00, 0x00, 0xff, 0x00,  //.@..@.
    0x00, 0xff, 0x00, 0x00, 0xff, 0x00,  //.@..@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0024 ($) , Width: 5 */
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0xff, 0xff, 0xff, 0xff,  //.@@@@
    0xff, 0x00, 0xff, 0x00, 0x00,  //@.@..
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0xff, 0x00, 0xff,  //..@.@
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@.
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0025 (%) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff,  //@@...@
    0xff, 0xff, 0x00, 0x00, 0xff, 0x00,  //@@..@.
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00,  //...@..
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //..@...
    0x00, 0xff, 0x00, 0x00, 0xff, 0xff,  //.@..@@
    0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0026 (&) , Width: 6 */
    0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@...
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00,  //@..@..
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00,  //@..@..
    0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@...
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff,  //@..@.@
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@...@.
    0x00, 0xff, 0xff, 0xff, 0x00, 0xff,  //.@@@.@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0027 (') , Width: 3 */
    0x00, 0x00, 0xff,  //..@
    0x00, 0xff, 0x00,  //.@.
    0xff, 0x00, 0x00,  //@..
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0028 (() , Width: 3 */
    0x00, 0x00, 0xff,  //..@
    0x00, 0xff, 0x00,  //.@.
    0xff, 0x00, 0x00,  //@..
    0xff, 0x00, 0x00,  //@..
    0xff, 0x00, 0x00,  //@..
    0x00, 0xff, 0x00,  //.@.
    0x00, 0x00, 0xff,  //..@
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0029 ()) , Width: 3 */
    0xff, 0x00, 0x00,  //@..
    0x00, 0xff, 0x00,  //.@.
    0x00, 0x00, 0xff,  //..@
    0x00, 0x00, 0xff,  //..@
    0x00, 0x00, 0xff,  //..@
    0x00, 0xff, 0x00,  //.@.
    0xff, 0x00, 0x00,  //@..
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+002a (*) , Width: 5 */
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0xff, 0x00, 0xff, 0x00, 0xff,  //@.@.@
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0xff, 0x00, 0xff, 0x00, 0xff,  //@.@.@
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+002b (+) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+002c (,) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0xff, 0x00,  //@.


    /*Unicode: U+002d (-) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+002e (.) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xff,  //@
    0x00,  //.


    /*Unicode: U+002f (/) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //......@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,  //.....@.
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00,  //....@..
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //...@...
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@....
    0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@.....
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0030 (0) , Width: 5 */
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0xff, 0xff,  //@..@@
    0xff, 0x00, 0xff, 0x00, 0xff,  //@.@.@
    0xff, 0xff, 0x00, 0x00, 0xff,  //@@..@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0031 (1) , Width: 5 */
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0xff, 0xff, 0x00, 0x00,  //.@@..
    0xff, 0x00, 0xff, 0x00, 0x00,  //@.@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0032 (2) , Width: 5 */
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0x00, 0x00, 0xff, 0x00,  //...@.
    0x00, 0xff, 0xff, 0x00, 0x00,  //.@@..
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0033 (3) , Width: 5 */
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0x00, 0xff, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0034 (4) , Width: 5 */
    0x00, 0x00, 0x00, 0xff, 0x00,  //...@.
    0x00, 0x00, 0xff, 0xff, 0x00,  //..@@.
    0x00, 0xff, 0x00, 0xff, 0x00,  //.@.@.
    0xff, 0x00, 0x00, 0xff, 0x00,  //@..@.
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0xff, 0x00,  //...@.
    0x00, 0x00, 0x00, 0xff, 0x00,  //...@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0035 (5) , Width: 5 */
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@.
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0036 (6) , Width: 5 */
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0xff, 0x00, 0x00, 0x00,  //.@...
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0037 (7) , Width: 5 */
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0x00, 0x00, 0xff, 0x00,  //...@.
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0xff, 0x00, 0x00, 0x00,  //.@...
    0x00, 0xff, 0x00, 0x00, 0x00,  //.@...
    0x00, 0xff, 0x00, 0x00, 0x00,  //.@...
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0038 (8) , Width: 5 */
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0039 (9) , Width: 5 */
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0xff,  //.@@@@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0x00, 0x00, 0xff, 0x00,  //...@.
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+003a (:) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0xff,  //@
    0x00,  //.
    0x00,  //.
    0xff,  //@
    0x00,  //.
    0x00,  //.


    /*Unicode: U+003b (;) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0xff,  //.@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0xff, 0x00,  //@.


    /*Unicode: U+003c (<) , Width: 4 */
    0x00, 0x00, 0x00, 0xff,  //...@
    0x00, 0x00, 0xff, 0x00,  //..@.
    0x00, 0xff, 0x00, 0x00,  //.@..
    0xff, 0x00, 0x00, 0x00,  //@...
    0x00, 0xff, 0x00, 0x00,  //.@..
    0x00, 0x00, 0xff, 0x00,  //..@.
    0x00, 0x00, 0x00, 0xff,  //...@
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+003d (=) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+003e (>) , Width: 4 */
    0xff, 0x00, 0x00, 0x00,  //@...
    0x00, 0xff, 0x00, 0x00,  //.@..
    0x00, 0x00, 0xff, 0x00,  //..@.
    0x00, 0x00, 0x00, 0xff,  //...@
    0x00, 0x00, 0xff, 0x00,  //..@.
    0x00, 0xff, 0x00, 0x00,  //.@..
    0xff, 0x00, 0x00, 0x00,  //@...
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+003f (?) , Width: 6 */
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00,  //....@.
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00,  //...@..
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00,  //...@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00,  //...@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0040 (@) , Width: 6 */
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff,  //@..@.@
    0xff, 0x00, 0xff, 0x00, 0xff, 0xff,  //@.@.@@
    0xff, 0x00, 0x00, 0xff, 0xff, 0x00,  //@..@@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0041 (A) , Width: 6 */
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0xff, 0x00, 0x00, 0xff, 0x00,  //.@..@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0042 (B) , Width: 6 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0043 (C) , Width: 6 */
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0044 (D) , Width: 6 */
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@@..
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@...@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@...@.
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0045 (E) , Width: 6 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@@..
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0046 (F) , Width: 6 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@@..
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0047 (G) , Width: 6 */
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0x00, 0x00, 0xff, 0xff, 0xff,  //@..@@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0048 (H) , Width: 6 */
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0049 (I) , Width: 3 */
    0xff, 0xff, 0xff,  //@@@
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+004a (J) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+004b (K) , Width: 6 */
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@...@.
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00,  //@..@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00,  //@..@..
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@...@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+004c (L) , Width: 6 */
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+004d (M) , Width: 6 */
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //@@..@@
    0xff, 0x00, 0xff, 0xff, 0x00, 0xff,  //@.@@.@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+004e (N) , Width: 6 */
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff,  //@@...@
    0xff, 0x00, 0xff, 0x00, 0x00, 0xff,  //@.@..@
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff,  //@..@.@
    0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@...@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+004f (O) , Width: 6 */
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0050 (P) , Width: 6 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0051 (Q) , Width: 6 */
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0xff, 0x00, 0xff,  //@..@.@
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@...@.
    0x00, 0xff, 0xff, 0xff, 0x00, 0xff,  //.@@@.@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0052 (R) , Width: 6 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@.
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00,  //@..@..
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@...@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0053 (S) , Width: 6 */
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@.....
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //.....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0054 (T) , Width: 5 */
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0055 (U) , Width: 6 */
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0x00, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0056 (V) , Width: 6 */
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0x00, 0xff, 0x00, 0x00, 0xff, 0x00,  //.@..@.
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0057 (W) , Width: 6 */
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0xff, 0xff, 0x00, 0xff,  //@.@@.@
    0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //@@..@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0058 (X) , Width: 6 */
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0x00, 0xff, 0x00, 0x00, 0xff, 0x00,  //.@..@.
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0xff, 0x00, 0x00, 0xff, 0x00,  //.@..@.
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0059 (Y) , Width: 5 */
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+005a (Z) , Width: 5 */
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0x00, 0x00, 0xff, 0x00,  //...@.
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0xff, 0x00, 0x00, 0x00,  //.@...
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+005b ([) , Width: 3 */
    0xff, 0xff, 0xff,  //@@@
    0xff, 0x00, 0x00,  //@..
    0xff, 0x00, 0x00,  //@..
    0xff, 0x00, 0x00,  //@..
    0xff, 0x00, 0x00,  //@..
    0xff, 0x00, 0x00,  //@..
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+005c (\) , Width: 7 */
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@......
    0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@.....
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@....
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //...@...
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00,  //....@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,  //.....@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //......@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+005d (]) , Width: 3 */
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0xff,  //..@
    0x00, 0x00, 0xff,  //..@
    0x00, 0x00, 0xff,  //..@
    0x00, 0x00, 0xff,  //..@
    0x00, 0x00, 0xff,  //..@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+005e (^) , Width: 5 */
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0xff, 0x00, 0xff, 0x00,  //.@.@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+005f (_) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@


    /*Unicode: U+0060 (`) , Width: 3 */
    0xff, 0x00, 0x00,  //@..
    0x00, 0xff, 0x00,  //.@.
    0x00, 0x00, 0xff,  //..@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0061 (a) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0xff, 0xff, 0xff, 0xff,  //.@@@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0xff,  //.@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0062 (b) , Width: 5 */
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0063 (c) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0064 (d) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0xff, 0xff, 0xff, 0xff,  //.@@@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0xff,  //.@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0065 (e) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0066 (f) , Width: 6 */
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00,  //...@@.
    0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //..@..@
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //..@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@.
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //..@...
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //..@...
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //..@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0067 (g) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0xff, 0xff, 0xff, 0xff,  //.@@@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0xff,  //.@@@@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.


    /*Unicode: U+0068 (h) , Width: 5 */
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0069 (i) , Width: 3 */
    0x00, 0xff, 0x00,  //.@.
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0x00,  //@@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+006a (j) , Width: 4 */
    0x00, 0x00, 0x00, 0xff,  //...@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0x00, 0xff,  //...@
    0x00, 0x00, 0x00, 0xff,  //...@
    0x00, 0x00, 0x00, 0xff,  //...@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0x00, 0xff, 0xff, 0x00,  //.@@.


    /*Unicode: U+006b (k) , Width: 5 */
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0xff, 0x00,  //@..@.
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0x00, 0x00, 0xff, 0x00,  //@..@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+006c (l) , Width: 3 */
    0xff, 0xff, 0x00,  //@@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+006d (m) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0x00, 0xff, 0x00,  //@@.@.
    0xff, 0x00, 0xff, 0x00, 0xff,  //@.@.@
    0xff, 0x00, 0xff, 0x00, 0xff,  //@.@.@
    0xff, 0x00, 0xff, 0x00, 0xff,  //@.@.@
    0xff, 0x00, 0xff, 0x00, 0xff,  //@.@.@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+006e (n) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+006f (o) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0070 (p) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@.
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....


    /*Unicode: U+0071 (q) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0xff, 0xff, 0xff, 0xff,  //.@@@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0xff,  //.@@@@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@


    /*Unicode: U+0072 (r) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0x00, 0xff, 0xff, 0xff,  //@.@@@
    0xff, 0xff, 0x00, 0x00, 0x00,  //@@...
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0073 (s) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0xff, 0xff, 0xff, 0xff,  //.@@@@
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0074 (t) , Width: 5 */
    0x00, 0xff, 0x00, 0x00, 0x00,  //.@...
    0x00, 0xff, 0x00, 0x00, 0x00,  //.@...
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@.
    0x00, 0xff, 0x00, 0x00, 0x00,  //.@...
    0x00, 0xff, 0x00, 0x00, 0x00,  //.@...
    0x00, 0xff, 0x00, 0x00, 0xff,  //.@..@
    0x00, 0x00, 0xff, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0075 (u) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0076 (v) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0x00, 0xff, 0x00,  //.@.@.
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0077 (w) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0xff, 0x00, 0xff,  //@.@.@
    0xff, 0x00, 0xff, 0x00, 0xff,  //@.@.@
    0xff, 0x00, 0xff, 0x00, 0xff,  //@.@.@
    0x00, 0xff, 0x00, 0xff, 0x00,  //.@.@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0078 (x) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0x00, 0xff, 0x00,  //.@.@.
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0xff, 0x00, 0xff, 0x00,  //.@.@.
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0079 (y) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0xff, 0xff, 0xff, 0xff,  //.@@@@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.


    /*Unicode: U+007a (z) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0xff, 0x00,  //...@.
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0xff, 0x00, 0x00, 0x00,  //.@...
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+007b ({) , Width: 4 */
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0xff, 0x00, 0x00,  //.@..
    0x00, 0xff, 0x00, 0x00,  //.@..
    0xff, 0x00, 0x00, 0x00,  //@...
    0x00, 0xff, 0x00, 0x00,  //.@..
    0x00, 0xff, 0x00, 0x00,  //.@..
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+007c (|) , Width: 1 */
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@


    /*Unicode: U+007d (}) , Width: 4 */
    0xff, 0xff, 0x00, 0x00,  //@@..
    0x00, 0x00, 0xff, 0x00,  //..@.
    0x00, 0x00, 0xff, 0x00,  //..@.
    0x00, 0x00, 0x00, 0xff,  //...@
    0x00, 0x00, 0xff, 0x00,  //..@.
    0x00, 0x00, 0xff, 0x00,  //..@.
    0xff, 0xff, 0x00, 0x00,  //@@..
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+007e (~) , Width: 5 */
    0x00, 0xff, 0x00, 0x00, 0x00,  //.@...
    0xff, 0x00, 0xff, 0x00, 0xff,  //@.@.@
    0x00, 0x00, 0x00, 0xff, 0x00,  //...@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....



#endif
};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t lv_font_monospace_8_glyph_dsc[] = {
#if USE_LV_FONT_MONOSPACE_8 == 1
    {.w_px = 3,   .glyph_index = 0},  /*Unicode: U+0020 ( )*/
    {.w_px = 1,   .glyph_index = 8},  /*Unicode: U+0021 (!)*/
    {.w_px = 4,   .glyph_index = 16}, /*Unicode: U+0022 (")*/
    {.w_px = 6,   .glyph_index = 24}, /*Unicode: U+0023 (#)*/
    {.w_px = 5,   .glyph_index = 32}, /*Unicode: U+0024 ($)*/
    {.w_px = 6,   .glyph_index = 40}, /*Unicode: U+0025 (%)*/
    {.w_px = 6,   .glyph_index = 48}, /*Unicode: U+0026 (&)*/
    {.w_px = 3,   .glyph_index = 56}, /*Unicode: U+0027 (')*/
    {.w_px = 3,   .glyph_index = 64}, /*Unicode: U+0028 (()*/
    {.w_px = 3,   .glyph_index = 72}, /*Unicode: U+0029 ())*/
    {.w_px = 5,   .glyph_index = 80}, /*Unicode: U+002a (*)*/
    {.w_px = 5,   .glyph_index = 88}, /*Unicode: U+002b (+)*/
    {.w_px = 2,   .glyph_index = 96}, /*Unicode: U+002c (,)*/
    {.w_px = 5,   .glyph_index = 104},    /*Unicode: U+002d (-)*/
    {.w_px = 1,   .glyph_index = 112},    /*Unicode: U+002e (.)*/
    {.w_px = 7,   .glyph_index = 120},    /*Unicode: U+002f (/)*/
    {.w_px = 5,   .glyph_index = 128},    /*Unicode: U+0030 (0)*/
    {.w_px = 5,   .glyph_index = 136},    /*Unicode: U+0031 (1)*/
    {.w_px = 5,   .glyph_index = 144},    /*Unicode: U+0032 (2)*/
    {.w_px = 5,   .glyph_index = 152},    /*Unicode: U+0033 (3)*/
    {.w_px = 5,   .glyph_index = 160},    /*Unicode: U+0034 (4)*/
    {.w_px = 5,   .glyph_index = 168},    /*Unicode: U+0035 (5)*/
    {.w_px = 5,   .glyph_index = 176},    /*Unicode: U+0036 (6)*/
    {.w_px = 5,   .glyph_index = 184},    /*Unicode: U+0037 (7)*/
    {.w_px = 5,   .glyph_index = 192},    /*Unicode: U+0038 (8)*/
    {.w_px = 5,   .glyph_index = 200},    /*Unicode: U+0039 (9)*/
    {.w_px = 1,   .glyph_index = 208},    /*Unicode: U+003a (:)*/
    {.w_px = 2,   .glyph_index = 216},    /*Unicode: U+003b (;)*/
    {.w_px = 4,   .glyph_index = 224},    /*Unicode: U+003c (<)*/
    {.w_px = 5,   .glyph_index = 232},    /*Unicode: U+003d (=)*/
    {.w_px = 4,   .glyph_index = 240},    /*Unicode: U+003e (>)*/
    {.w_px = 6,   .glyph_index = 248},    /*Unicode: U+003f (?)*/
    {.w_px = 6,   .glyph_index = 256},    /*Unicode: U+0040 (@)*/
    {.w_px = 6,   .glyph_index = 264},    /*Unicode: U+0041 (A)*/
    {.w_px = 6,   .glyph_index = 272},    /*Unicode: U+0042 (B)*/
    {.w_px = 6,   .glyph_index = 280},    /*Unicode: U+0043 (C)*/
    {.w_px = 6,   .glyph_index = 288},    /*Unicode: U+0044 (D)*/
    {.w_px = 6,   .glyph_index = 296},    /*Unicode: U+0045 (E)*/
    {.w_px = 6,   .glyph_index = 304},    /*Unicode: U+0046 (F)*/
    {.w_px = 6,   .glyph_index = 312},    /*Unicode: U+0047 (G)*/
    {.w_px = 6,   .glyph_index = 320},    /*Unicode: U+0048 (H)*/
    {.w_px = 3,   .glyph_index = 328},    /*Unicode: U+0049 (I)*/
    {.w_px = 5,   .glyph_index = 336},    /*Unicode: U+004a (J)*/
    {.w_px = 6,   .glyph_index = 344},    /*Unicode: U+004b (K)*/
    {.w_px = 6,   .glyph_index = 352},    /*Unicode: U+004c (L)*/
    {.w_px = 6,   .glyph_index = 360},    /*Unicode: U+004d (M)*/
    {.w_px = 6,   .glyph_index = 368},    /*Unicode: U+004e (N)*/
    {.w_px = 6,   .glyph_index = 376},    /*Unicode: U+004f (O)*/
    {.w_px = 6,   .glyph_index = 384},    /*Unicode: U+0050 (P)*/
    {.w_px = 6,   .glyph_index = 392},    /*Unicode: U+0051 (Q)*/
    {.w_px = 6,   .glyph_index = 400},    /*Unicode: U+0052 (R)*/
    {.w_px = 6,   .glyph_index = 408},    /*Unicode: U+0053 (S)*/
    {.w_px = 5,   .glyph_index = 416},    /*Unicode: U+0054 (T)*/
    {.w_px = 6,   .glyph_index = 424},    /*Unicode: U+0055 (U)*/
    {.w_px = 6,   .glyph_index = 432},    /*Unicode: U+0056 (V)*/
    {.w_px = 6,   .glyph_index = 440},    /*Unicode: U+0057 (W)*/
    {.w_px = 6,   .glyph_index = 448},    /*Unicode: U+0058 (X)*/
    {.w_px = 5,   .glyph_index = 456},    /*Unicode: U+0059 (Y)*/
    {.w_px = 5,   .glyph_index = 464},    /*Unicode: U+005a (Z)*/
    {.w_px = 3,   .glyph_index = 472},    /*Unicode: U+005b ([)*/
    {.w_px = 7,   .glyph_index = 480},    /*Unicode: U+005c (\)*/
    {.w_px = 3,   .glyph_index = 488},    /*Unicode: U+005d (])*/
    {.w_px = 5,   .glyph_index = 496},    /*Unicode: U+005e (^)*/
    {.w_px = 5,   .glyph_index = 504},    /*Unicode: U+005f (_)*/
    {.w_px = 3,   .glyph_index = 512},    /*Unicode: U+0060 (`)*/
    {.w_px = 5,   .glyph_index = 520},    /*Unicode: U+0061 (a)*/
    {.w_px = 5,   .glyph_index = 528},    /*Unicode: U+0062 (b)*/
    {.w_px = 5,   .glyph_index = 536},    /*Unicode: U+0063 (c)*/
    {.w_px = 5,   .glyph_index = 544},    /*Unicode: U+0064 (d)*/
    {.w_px = 5,   .glyph_index = 552},    /*Unicode: U+0065 (e)*/
    {.w_px = 6,   .glyph_index = 560},    /*Unicode: U+0066 (f)*/
    {.w_px = 5,   .glyph_index = 568},    /*Unicode: U+0067 (g)*/
    {.w_px = 5,   .glyph_index = 576},    /*Unicode: U+0068 (h)*/
    {.w_px = 3,   .glyph_index = 584},    /*Unicode: U+0069 (i)*/
    {.w_px = 4,   .glyph_index = 592},    /*Unicode: U+006a (j)*/
    {.w_px = 5,   .glyph_index = 600},    /*Unicode: U+006b (k)*/
    {.w_px = 3,   .glyph_index = 608},    /*Unicode: U+006c (l)*/
    {.w_px = 5,   .glyph_index = 616},    /*Unicode: U+006d (m)*/
    {.w_px = 5,   .glyph_index = 624},    /*Unicode: U+006e (n)*/
    {.w_px = 5,   .glyph_index = 632},    /*Unicode: U+006f (o)*/
    {.w_px = 5,   .glyph_index = 640},    /*Unicode: U+0070 (p)*/
    {.w_px = 5,   .glyph_index = 648},    /*Unicode: U+0071 (q)*/
    {.w_px = 5,   .glyph_index = 656},    /*Unicode: U+0072 (r)*/
    {.w_px = 5,   .glyph_index = 664},    /*Unicode: U+0073 (s)*/
    {.w_px = 5,   .glyph_index = 672},    /*Unicode: U+0074 (t)*/
    {.w_px = 5,   .glyph_index = 680},    /*Unicode: U+0075 (u)*/
    {.w_px = 5,   .glyph_index = 688},    /*Unicode: U+0076 (v)*/
    {.w_px = 5,   .glyph_index = 696},    /*Unicode: U+0077 (w)*/
    {.w_px = 5,   .glyph_index = 704},    /*Unicode: U+0078 (x)*/
    {.w_px = 5,   .glyph_index = 712},    /*Unicode: U+0079 (y)*/
    {.w_px = 5,   .glyph_index = 720},    /*Unicode: U+007a (z)*/
    {.w_px = 4,   .glyph_index = 728},    /*Unicode: U+007b ({)*/
    {.w_px = 1,   .glyph_index = 736},    /*Unicode: U+007c (|)*/
    {.w_px = 4,   .glyph_index = 744},    /*Unicode: U+007d (})*/
    {.w_px = 5,   .glyph_index = 752},    /*Unicode: U+007e (~)*/

#elif USE_LV_FONT_MONOSPACE_8 == 2
    {.w_px = 3,   .glyph_index = 0},  /*Unicode: U+0020 ( )*/
    {.w_px = 1,   .glyph_index = 8},  /*Unicode: U+0021 (!)*/
    {.w_px = 4,   .glyph_index = 16}, /*Unicode: U+0022 (")*/
    {.w_px = 6,   .glyph_index = 24}, /*Unicode: U+0023 (#)*/
    {.w_px = 5,   .glyph_index = 40}, /*Unicode: U+0024 ($)*/
    {.w_px = 6,   .glyph_index = 56}, /*Unicode: U+0025 (%)*/
    {.w_px = 6,   .glyph_index = 72}, /*Unicode: U+0026 (&)*/
    {.w_px = 3,   .glyph_index = 88}, /*Unicode: U+0027 (')*/
    {.w_px = 3,   .glyph_index = 96}, /*Unicode: U+0028 (()*/
    {.w_px = 3,   .glyph_index = 104},    /*Unicode: U+0029 ())*/
    {.w_px = 5,   .glyph_index = 112},    /*Unicode: U+002a (*)*/
    {.w_px = 5,   .glyph_index = 128},    /*Unicode: U+002b (+)*/
    {.w_px = 2,   .glyph_index = 144},    /*Unicode: U+002c (,)*/
    {.w_px = 5,   .glyph_index = 152},    /*Unicode: U+002d (-)*/
    {.w_px = 1,   .glyph_index = 168},    /*Unicode: U+002e (.)*/
    {.w_px = 7,   .glyph_index = 176},    /*Unicode: U+002f (/)*/
    {.w_px = 5,   .glyph_index = 192},    /*Unicode: U+0030 (0)*/
    {.w_px = 5,   .glyph_index = 208},    /*Unicode: U+0031 (1)*/
    {.w_px = 5,   .glyph_index = 224},    /*Unicode: U+0032 (2)*/
    {.w_px = 5,   .glyph_index = 240},    /*Unicode: U+0033 (3)*/
    {.w_px = 5,   .glyph_index = 256},    /*Unicode: U+0034 (4)*/
    {.w_px = 5,   .glyph_index = 272},    /*Unicode: U+0035 (5)*/
    {.w_px = 5,   .glyph_index = 288},    /*Unicode: U+0036 (6)*/
    {.w_px = 5,   .glyph_index = 304},    /*Unicode: U+0037 (7)*/
    {.w_px = 5,   .glyph_index = 320},    /*Unicode: U+0038 (8)*/
    {.w_px = 5,   .glyph_index = 336},    /*Unicode: U+0039 (9)*/
    {.w_px = 1,   .glyph_index = 352},    /*Unicode: U+003a (:)*/
    {.w_px = 2,   .glyph_index = 360},    /*Unicode: U+003b (;)*/
    {.w_px = 4,   .glyph_index = 368},    /*Unicode: U+003c (<)*/
    {.w_px = 5,   .glyph_index = 376},    /*Unicode: U+003d (=)*/
    {.w_px = 4,   .glyph_index = 392},    /*Unicode: U+003e (>)*/
    {.w_px = 6,   .glyph_index = 400},    /*Unicode: U+003f (?)*/
    {.w_px = 6,   .glyph_index = 416},    /*Unicode: U+0040 (@)*/
    {.w_px = 6,   .glyph_index = 432},    /*Unicode: U+0041 (A)*/
    {.w_px = 6,   .glyph_index = 448},    /*Unicode: U+0042 (B)*/
    {.w_px = 6,   .glyph_index = 464},    /*Unicode: U+0043 (C)*/
    {.w_px = 6,   .glyph_index = 480},    /*Unicode: U+0044 (D)*/
    {.w_px = 6,   .glyph_index = 496},    /*Unicode: U+0045 (E)*/
    {.w_px = 6,   .glyph_index = 512},    /*Unicode: U+0046 (F)*/
    {.w_px = 6,   .glyph_index = 528},    /*Unicode: U+0047 (G)*/
    {.w_px = 6,   .glyph_index = 544},    /*Unicode: U+0048 (H)*/
    {.w_px = 3,   .glyph_index = 560},    /*Unicode: U+0049 (I)*/
    {.w_px = 5,   .glyph_index = 568},    /*Unicode: U+004a (J)*/
    {.w_px = 6,   .glyph_index = 584},    /*Unicode: U+004b (K)*/
    {.w_px = 6,   .glyph_index = 600},    /*Unicode: U+004c (L)*/
    {.w_px = 6,   .glyph_index = 616},    /*Unicode: U+004d (M)*/
    {.w_px = 6,   .glyph_index = 632},    /*Unicode: U+004e (N)*/
    {.w_px = 6,   .glyph_index = 648},    /*Unicode: U+004f (O)*/
    {.w_px = 6,   .glyph_index = 664},    /*Unicode: U+0050 (P)*/
    {.w_px = 6,   .glyph_index = 680},    /*Unicode: U+0051 (Q)*/
    {.w_px = 6,   .glyph_index = 696},    /*Unicode: U+0052 (R)*/
    {.w_px = 6,   .glyph_index = 712},    /*Unicode: U+0053 (S)*/
    {.w_px = 5,   .glyph_index = 728},    /*Unicode: U+0054 (T)*/
    {.w_px = 6,   .glyph_index = 744},    /*Unicode: U+0055 (U)*/
    {.w_px = 6,   .glyph_index = 760},    /*Unicode: U+0056 (V)*/
    {.w_px = 6,   .glyph_index = 776},    /*Unicode: U+0057 (W)*/
    {.w_px = 6,   .glyph_index = 792},    /*Unicode: U+0058 (X)*/
    {.w_px = 5,   .glyph_index = 808},    /*Unicode: U+0059 (Y)*/
    {.w_px = 5,   .glyph_index = 824},    /*Unicode: U+005a (Z)*/
    {.w_px = 3,   .glyph_index = 840},    /*Unicode: U+005b ([)*/
    {.w_px = 7,   .glyph_index = 848},    /*Unicode: U+005c (\)*/
    {.w_px = 3,   .glyph_index = 864},    /*Unicode: U+005d (])*/
    {.w_px = 5,   .glyph_index = 872},    /*Unicode: U+005e (^)*/
    {.w_px = 5,   .glyph_index = 888},    /*Unicode: U+005f (_)*/
    {.w_px = 3,   .glyph_index = 904},    /*Unicode: U+0060 (`)*/
    {.w_px = 5,   .glyph_index = 912},    /*Unicode: U+0061 (a)*/
    {.w_px = 5,   .glyph_index = 928},    /*Unicode: U+0062 (b)*/
    {.w_px = 5,   .glyph_index = 944},    /*Unicode: U+0063 (c)*/
    {.w_px = 5,   .glyph_index = 960},    /*Unicode: U+0064 (d)*/
    {.w_px = 5,   .glyph_index = 976},    /*Unicode: U+0065 (e)*/
    {.w_px = 6,   .glyph_index = 992},    /*Unicode: U+0066 (f)*/
    {.w_px = 5,   .glyph_index = 1008},   /*Unicode: U+0067 (g)*/
    {.w_px = 5,   .glyph_index = 1024},   /*Unicode: U+0068 (h)*/
    {.w_px = 3,   .glyph_index = 1040},   /*Unicode: U+0069 (i)*/
    {.w_px = 4,   .glyph_index = 1048},   /*Unicode: U+006a (j)*/
    {.w_px = 5,   .glyph_index = 1056},   /*Unicode: U+006b (k)*/
    {.w_px = 3,   .glyph_index = 1072},   /*Unicode: U+006c (l)*/
    {.w_px = 5,   .glyph_index = 1080},   /*Unicode: U+006d (m)*/
    {.w_px = 5,   .glyph_index = 1096},   /*Unicode: U+006e (n)*/
    {.w_px = 5,   .glyph_index = 1112},   /*Unicode: U+006f (o)*/
    {.w_px = 5,   .glyph_index = 1128},   /*Unicode: U+0070 (p)*/
    {.w_px = 5,   .glyph_index = 1144},   /*Unicode: U+0071 (q)*/
    {.w_px = 5,   .glyph_index = 1160},   /*Unicode: U+0072 (r)*/
    {.w_px = 5,   .glyph_index = 1176},   /*Unicode: U+0073 (s)*/
    {.w_px = 5,   .glyph_index = 1192},   /*Unicode: U+0074 (t)*/
    {.w_px = 5,   .glyph_index = 1208},   /*Unicode: U+0075 (u)*/
    {.w_px = 5,   .glyph_index = 1224},   /*Unicode: U+0076 (v)*/
    {.w_px = 5,   .glyph_index = 1240},   /*Unicode: U+0077 (w)*/
    {.w_px = 5,   .glyph_index = 1256},   /*Unicode: U+0078 (x)*/
    {.w_px = 5,   .glyph_index = 1272},   /*Unicode: U+0079 (y)*/
    {.w_px = 5,   .glyph_index = 1288},   /*Unicode: U+007a (z)*/
    {.w_px = 4,   .glyph_index = 1304},   /*Unicode: U+007b ({)*/
    {.w_px = 1,   .glyph_index = 1312},   /*Unicode: U+007c (|)*/
    {.w_px = 4,   .glyph_index = 1320},   /*Unicode: U+007d (})*/
    {.w_px = 5,   .glyph_index = 1328},   /*Unicode: U+007e (~)*/

#elif USE_LV_FONT_MONOSPACE_8 == 4
    {.w_px = 3,   .glyph_index = 0},  /*Unicode: U+0020 ( )*/
    {.w_px = 1,   .glyph_index = 16}, /*Unicode: U+0021 (!)*/
    {.w_px = 4,   .glyph_index = 24}, /*Unicode: U+0022 (")*/
    {.w_px = 6,   .glyph_index = 40}, /*Unicode: U+0023 (#)*/
    {.w_px = 5,   .glyph_index = 64}, /*Unicode: U+0024 ($)*/
    {.w_px = 6,   .glyph_index = 88}, /*Unicode: U+0025 (%)*/
    {.w_px = 6,   .glyph_index = 112},    /*Unicode: U+0026 (&)*/
    {.w_px = 3,   .glyph_index = 136},    /*Unicode: U+0027 (')*/
    {.w_px = 3,   .glyph_index = 152},    /*Unicode: U+0028 (()*/
    {.w_px = 3,   .glyph_index = 168},    /*Unicode: U+0029 ())*/
    {.w_px = 5,   .glyph_index = 184},    /*Unicode: U+002a (*)*/
    {.w_px = 5,   .glyph_index = 208},    /*Unicode: U+002b (+)*/
    {.w_px = 2,   .glyph_index = 232},    /*Unicode: U+002c (,)*/
    {.w_px = 5,   .glyph_index = 240},    /*Unicode: U+002d (-)*/
    {.w_px = 1,   .glyph_index = 264},    /*Unicode: U+002e (.)*/
    {.w_px = 7,   .glyph_index = 272},    /*Unicode: U+002f (/)*/
    {.w_px = 5,   .glyph_index = 304},    /*Unicode: U+0030 (0)*/
    {.w_px = 5,   .glyph_index = 328},    /*Unicode: U+0031 (1)*/
    {.w_px = 5,   .glyph_index = 352},    /*Unicode: U+0032 (2)*/
    {.w_px = 5,   .glyph_index = 376},    /*Unicode: U+0033 (3)*/
    {.w_px = 5,   .glyph_index = 400},    /*Unicode: U+0034 (4)*/
    {.w_px = 5,   .glyph_index = 424},    /*Unicode: U+0035 (5)*/
    {.w_px = 5,   .glyph_index = 448},    /*Unicode: U+0036 (6)*/
    {.w_px = 5,   .glyph_index = 472},    /*Unicode: U+0037 (7)*/
    {.w_px = 5,   .glyph_index = 496},    /*Unicode: U+0038 (8)*/
    {.w_px = 5,   .glyph_index = 520},    /*Unicode: U+0039 (9)*/
    {.w_px = 1,   .glyph_index = 544},    /*Unicode: U+003a (:)*/
    {.w_px = 2,   .glyph_index = 552},    /*Unicode: U+003b (;)*/
    {.w_px = 4,   .glyph_index = 560},    /*Unicode: U+003c (<)*/
    {.w_px = 5,   .glyph_index = 576},    /*Unicode: U+003d (=)*/
    {.w_px = 4,   .glyph_index = 600},    /*Unicode: U+003e (>)*/
    {.w_px = 6,   .glyph_index = 616},    /*Unicode: U+003f (?)*/
    {.w_px = 6,   .glyph_index = 640},    /*Unicode: U+0040 (@)*/
    {.w_px = 6,   .glyph_index = 664},    /*Unicode: U+0041 (A)*/
    {.w_px = 6,   .glyph_index = 688},    /*Unicode: U+0042 (B)*/
    {.w_px = 6,   .glyph_index = 712},    /*Unicode: U+0043 (C)*/
    {.w_px = 6,   .glyph_index = 736},    /*Unicode: U+0044 (D)*/
    {.w_px = 6,   .glyph_index = 760},    /*Unicode: U+0045 (E)*/
    {.w_px = 6,   .glyph_index = 784},    /*Unicode: U+0046 (F)*/
    {.w_px = 6,   .glyph_index = 808},    /*Unicode: U+0047 (G)*/
    {.w_px = 6,   .glyph_index = 832},    /*Unicode: U+0048 (H)*/
    {.w_px = 3,   .glyph_index = 856},    /*Unicode: U+0049 (I)*/
    {.w_px = 5,   .glyph_index = 872},    /*Unicode: U+004a (J)*/
    {.w_px = 6,   .glyph_index = 896},    /*Unicode: U+004b (K)*/
    {.w_px = 6,   .glyph_index = 920},    /*Unicode: U+004c (L)*/
    {.w_px = 6,   .glyph_index = 944},    /*Unicode: U+004d (M)*/
    {.w_px = 6,   .glyph_index = 968},    /*Unicode: U+004e (N)*/
    {.w_px = 6,   .glyph_index = 992},    /*Unicode: U+004f (O)*/
    {.w_px = 6,   .glyph_index = 1016},   /*Unicode: U+0050 (P)*/
    {.w_px = 6,   .glyph_index = 1040},   /*Unicode: U+0051 (Q)*/
    {.w_px = 6,   .glyph_index = 1064},   /*Unicode: U+0052 (R)*/
    {.w_px = 6,   .glyph_index = 1088},   /*Unicode: U+0053 (S)*/
    {.w_px = 5,   .glyph_index = 1112},   /*Unicode: U+0054 (T)*/
    {.w_px = 6,   .glyph_index = 1136},   /*Unicode: U+0055 (U)*/
    {.w_px = 6,   .glyph_index = 1160},   /*Unicode: U+0056 (V)*/
    {.w_px = 6,   .glyph_index = 1184},   /*Unicode: U+0057 (W)*/
    {.w_px = 6,   .glyph_index = 1208},   /*Unicode: U+0058 (X)*/
    {.w_px = 5,   .glyph_index = 1232},   /*Unicode: U+0059 (Y)*/
    {.w_px = 5,   .glyph_index = 1256},   /*Unicode: U+005a (Z)*/
    {.w_px = 3,   .glyph_index = 1280},   /*Unicode: U+005b ([)*/
    {.w_px = 7,   .glyph_index = 1296},   /*Unicode: U+005c (\)*/
    {.w_px = 3,   .glyph_index = 1328},   /*Unicode: U+005d (])*/
    {.w_px = 5,   .glyph_index = 1344},   /*Unicode: U+005e (^)*/
    {.w_px = 5,   .glyph_index = 1368},   /*Unicode: U+005f (_)*/
    {.w_px = 3,   .glyph_index = 1392},   /*Unicode: U+0060 (`)*/
    {.w_px = 5,   .glyph_index = 1408},   /*Unicode: U+0061 (a)*/
    {.w_px = 5,   .glyph_index = 1432},   /*Unicode: U+0062 (b)*/
    {.w_px = 5,   .glyph_index = 1456},   /*Unicode: U+0063 (c)*/
    {.w_px = 5,   .glyph_index = 1480},   /*Unicode: U+0064 (d)*/
    {.w_px = 5,   .glyph_index = 1504},   /*Unicode: U+0065 (e)*/
    {.w_px = 6,   .glyph_index = 1528},   /*Unicode: U+0066 (f)*/
    {.w_px = 5,   .glyph_index = 1552},   /*Unicode: U+0067 (g)*/
    {.w_px = 5,   .glyph_index = 1576},   /*Unicode: U+0068 (h)*/
    {.w_px = 3,   .glyph_index = 1600},   /*Unicode: U+0069 (i)*/
    {.w_px = 4,   .glyph_index = 1616},   /*Unicode: U+006a (j)*/
    {.w_px = 5,   .glyph_index = 1632},   /*Unicode: U+006b (k)*/
    {.w_px = 3,   .glyph_index = 1656},   /*Unicode: U+006c (l)*/
    {.w_px = 5,   .glyph_index = 1672},   /*Unicode: U+006d (m)*/
    {.w_px = 5,   .glyph_index = 1696},   /*Unicode: U+006e (n)*/
    {.w_px = 5,   .glyph_index = 1720},   /*Unicode: U+006f (o)*/
    {.w_px = 5,   .glyph_index = 1744},   /*Unicode: U+0070 (p)*/
    {.w_px = 5,   .glyph_index = 1768},   /*Unicode: U+0071 (q)*/
    {.w_px = 5,   .glyph_index = 1792},   /*Unicode: U+0072 (r)*/
    {.w_px = 5,   .glyph_index = 1816},   /*Unicode: U+0073 (s)*/
    {.w_px = 5,   .glyph_index = 1840},   /*Unicode: U+0074 (t)*/
    {.w_px = 5,   .glyph_index = 1864},   /*Unicode: U+0075 (u)*/
    {.w_px = 5,   .glyph_index = 1888},   /*Unicode: U+0076 (v)*/
    {.w_px = 5,   .glyph_index = 1912},   /*Unicode: U+0077 (w)*/
    {.w_px = 5,   .glyph_index = 1936},   /*Unicode: U+0078 (x)*/
    {.w_px = 5,   .glyph_index = 1960},   /*Unicode: U+0079 (y)*/
    {.w_px = 5,   .glyph_index = 1984},   /*Unicode: U+007a (z)*/
    {.w_px = 4,   .glyph_index = 2008},   /*Unicode: U+007b ({)*/
    {.w_px = 1,   .glyph_index = 2024},   /*Unicode: U+007c (|)*/
    {.w_px = 4,   .glyph_index = 2032},   /*Unicode: U+007d (})*/
    {.w_px = 5,   .glyph_index = 2048},   /*Unicode: U+007e (~)*/

#elif USE_LV_FONT_MONOSPACE_8 == 8
    {.w_px = 3,   .glyph_index = 0},  /*Unicode: U+0020 ( )*/
    {.w_px = 1,   .glyph_index = 24}, /*Unicode: U+0021 (!)*/
    {.w_px = 4,   .glyph_index = 32}, /*Unicode: U+0022 (")*/
    {.w_px = 6,   .glyph_index = 64}, /*Unicode: U+0023 (#)*/
    {.w_px = 5,   .glyph_index = 112},    /*Unicode: U+0024 ($)*/
    {.w_px = 6,   .glyph_index = 152},    /*Unicode: U+0025 (%)*/
    {.w_px = 6,   .glyph_index = 200},    /*Unicode: U+0026 (&)*/
    {.w_px = 3,   .glyph_index = 248},    /*Unicode: U+0027 (')*/
    {.w_px = 3,   .glyph_index = 272},    /*Unicode: U+0028 (()*/
    {.w_px = 3,   .glyph_index = 296},    /*Unicode: U+0029 ())*/
    {.w_px = 5,   .glyph_index = 320},    /*Unicode: U+002a (*)*/
    {.w_px = 5,   .glyph_index = 360},    /*Unicode: U+002b (+)*/
    {.w_px = 2,   .glyph_index = 400},    /*Unicode: U+002c (,)*/
    {.w_px = 5,   .glyph_index = 416},    /*Unicode: U+002d (-)*/
    {.w_px = 1,   .glyph_index = 456},    /*Unicode: U+002e (.)*/
    {.w_px = 7,   .glyph_index = 464},    /*Unicode: U+002f (/)*/
    {.w_px = 5,   .glyph_index = 520},    /*Unicode: U+0030 (0)*/
    {.w_px = 5,   .glyph_index = 560},    /*Unicode: U+0031 (1)*/
    {.w_px = 5,   .glyph_index = 600},    /*Unicode: U+0032 (2)*/
    {.w_px = 5,   .glyph_index = 640},    /*Unicode: U+0033 (3)*/
    {.w_px = 5,   .glyph_index = 680},    /*Unicode: U+0034 (4)*/
    {.w_px = 5,   .glyph_index = 720},    /*Unicode: U+0035 (5)*/
    {.w_px = 5,   .glyph_index = 760},    /*Unicode: U+0036 (6)*/
    {.w_px = 5,   .glyph_index = 800},    /*Unicode: U+0037 (7)*/
    {.w_px = 5,   .glyph_index = 840},    /*Unicode: U+0038 (8)*/
    {.w_px = 5,   .glyph_index = 880},    /*Unicode: U+0039 (9)*/
    {.w_px = 1,   .glyph_index = 920},    /*Unicode: U+003a (:)*/
    {.w_px = 2,   .glyph_index = 928},    /*Unicode: U+003b (;)*/
    {.w_px = 4,   .glyph_index = 944},    /*Unicode: U+003c (<)*/
    {.w_px = 5,   .glyph_index = 976},    /*Unicode: U+003d (=)*/
    {.w_px = 4,   .glyph_index = 1016},   /*Unicode: U+003e (>)*/
    {.w_px = 6,   .glyph_index = 1048},   /*Unicode: U+003f (?)*/
    {.w_px = 6,   .glyph_index = 1096},   /*Unicode: U+0040 (@)*/
    {.w_px = 6,   .glyph_index = 1144},   /*Unicode: U+0041 (A)*/
    {.w_px = 6,   .glyph_index = 1192},   /*Unicode: U+0042 (B)*/
    {.w_px = 6,   .glyph_index = 1240},   /*Unicode: U+0043 (C)*/
    {.w_px = 6,   .glyph_index = 1288},   /*Unicode: U+0044 (D)*/
    {.w_px = 6,   .glyph_index = 1336},   /*Unicode: U+0045 (E)*/
    {.w_px = 6,   .glyph_index = 1384},   /*Unicode: U+0046 (F)*/
    {.w_px = 6,   .glyph_index = 1432},   /*Unicode: U+0047 (G)*/
    {.w_px = 6,   .glyph_index = 1480},   /*Unicode: U+0048 (H)*/
    {.w_px = 3,   .glyph_index = 1528},   /*Unicode: U+0049 (I)*/
    {.w_px = 5,   .glyph_index = 1552},   /*Unicode: U+004a (J)*/
    {.w_px = 6,   .glyph_index = 1592},   /*Unicode: U+004b (K)*/
    {.w_px = 6,   .glyph_index = 1640},   /*Unicode: U+004c (L)*/
    {.w_px = 6,   .glyph_index = 1688},   /*Unicode: U+004d (M)*/
    {.w_px = 6,   .glyph_index = 1736},   /*Unicode: U+004e (N)*/
    {.w_px = 6,   .glyph_index = 1784},   /*Unicode: U+004f (O)*/
    {.w_px = 6,   .glyph_index = 1832},   /*Unicode: U+0050 (P)*/
    {.w_px = 6,   .glyph_index = 1880},   /*Unicode: U+0051 (Q)*/
    {.w_px = 6,   .glyph_index = 1928},   /*Unicode: U+0052 (R)*/
    {.w_px = 6,   .glyph_index = 1976},   /*Unicode: U+0053 (S)*/
    {.w_px = 5,   .glyph_index = 2024},   /*Unicode: U+0054 (T)*/
    {.w_px = 6,   .glyph_index = 2064},   /*Unicode: U+0055 (U)*/
    {.w_px = 6,   .glyph_index = 2112},   /*Unicode: U+0056 (V)*/
    {.w_px = 6,   .glyph_index = 2160},   /*Unicode: U+0057 (W)*/
    {.w_px = 6,   .glyph_index = 2208},   /*Unicode: U+0058 (X)*/
    {.w_px = 5,   .glyph_index = 2256},   /*Unicode: U+0059 (Y)*/
    {.w_px = 5,   .glyph_index = 2296},   /*Unicode: U+005a (Z)*/
    {.w_px = 3,   .glyph_index = 2336},   /*Unicode: U+005b ([)*/
    {.w_px = 7,   .glyph_index = 2360},   /*Unicode: U+005c (\)*/
    {.w_px = 3,   .glyph_index = 2416},   /*Unicode: U+005d (])*/
    {.w_px = 5,   .glyph_index = 2440},   /*Unicode: U+005e (^)*/
    {.w_px = 5,   .glyph_index = 2480},   /*Unicode: U+005f (_)*/
    {.w_px = 3,   .glyph_index = 2520},   /*Unicode: U+0060 (`)*/
    {.w_px = 5,   .glyph_index = 2544},   /*Unicode: U+0061 (a)*/
    {.w_px = 5,   .glyph_index = 2584},   /*Unicode: U+0062 (b)*/
    {.w_px = 5,   .glyph_index = 2624},   /*Unicode: U+0063 (c)*/
    {.w_px = 5,   .glyph_index = 2664},   /*Unicode: U+0064 (d)*/
    {.w_px = 5,   .glyph_index = 2704},   /*Unicode: U+0065 (e)*/
    {.w_px = 6,   .glyph_index = 2744},   /*Unicode: U+0066 (f)*/
    {.w_px = 5,   .glyph_index = 2792},   /*Unicode: U+0067 (g)*/
    {.w_px = 5,   .glyph_index = 2832},   /*Unicode: U+0068 (h)*/
    {.w_px = 3,   .glyph_index = 2872},   /*Unicode: U+0069 (i)*/
    {.w_px = 4,   .glyph_index = 2896},   /*Unicode: U+006a (j)*/
    {.w_px = 5,   .glyph_index = 2928},   /*Unicode: U+006b (k)*/
    {.w_px = 3,   .glyph_index = 2968},   /*Unicode: U+006c (l)*/
    {.w_px = 5,   .glyph_index = 2992},   /*Unicode: U+006d (m)*/
    {.w_px = 5,   .glyph_index = 3032},   /*Unicode: U+006e (n)*/
    {.w_px = 5,   .glyph_index = 3072},   /*Unicode: U+006f (o)*/
    {.w_px = 5,   .glyph_index = 3112},   /*Unicode: U+0070 (p)*/
    {.w_px = 5,   .glyph_index = 3152},   /*Unicode: U+0071 (q)*/
    {.w_px = 5,   .glyph_index = 3192},   /*Unicode: U+0072 (r)*/
    {.w_px = 5,   .glyph_index = 3232},   /*Unicode: U+0073 (s)*/
    {.w_px = 5,   .glyph_index = 3272},   /*Unicode: U+0074 (t)*/
    {.w_px = 5,   .glyph_index = 3312},   /*Unicode: U+0075 (u)*/
    {.w_px = 5,   .glyph_index = 3352},   /*Unicode: U+0076 (v)*/
    {.w_px = 5,   .glyph_index = 3392},   /*Unicode: U+0077 (w)*/
    {.w_px = 5,   .glyph_index = 3432},   /*Unicode: U+0078 (x)*/
    {.w_px = 5,   .glyph_index = 3472},   /*Unicode: U+0079 (y)*/
    {.w_px = 5,   .glyph_index = 3512},   /*Unicode: U+007a (z)*/
    {.w_px = 4,   .glyph_index = 3552},   /*Unicode: U+007b ({)*/
    {.w_px = 1,   .glyph_index = 3584},   /*Unicode: U+007c (|)*/
    {.w_px = 4,   .glyph_index = 3592},   /*Unicode: U+007d (})*/
    {.w_px = 5,   .glyph_index = 3624},   /*Unicode: U+007e (~)*/

#endif
};

lv_font_t lv_font_monospace_8 = {
    .unicode_first = 32,    /*First Unicode letter in this font*/
    .unicode_last = 126,    /*Last Unicode letter in this font*/
    .h_px = 8,              /*Font height in pixels*/
    .glyph_bitmap = lv_font_monospace_8_glyph_bitmap,   /*Bitmap of glyphs*/
    .glyph_dsc = lv_font_monospace_8_glyph_dsc,     /*Description of glyphs*/
    .unicode_list = NULL,   /*Every character in the font from 'unicode_first' to 'unicode_last'*/
    .get_bitmap = lv_font_get_bitmap_continuous,    /*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,  /*Function pointer to get glyph's width*/
#if USE_LV_FONT_MONOSPACE_8 == 1
    .bpp = 1,               /*Bit per pixel*/
#elif USE_LV_FONT_MONOSPACE_8 == 2
    .bpp = 2,               /*Bit per pixel*/
#elif USE_LV_FONT_MONOSPACE_8 == 4
    .bpp = 4,               /*Bit per pixel*/
#elif USE_LV_FONT_MONOSPACE_8 == 8
    .bpp = 8,               /*Bit per pixel*/
#endif
    .monospace = 6,     /*Fix width (0: if not used)*/
    .next_page = NULL,      /*Pointer to a font extension*/
};

#endif /*USE_LV_FONT_MONOSPACE_8*/
