
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_DEJAVU_40_LATIN_SUP != 0    /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * DejaVuSans.ttf 40 px Font in U+00a0 ( ) .. U+00ff (ÿ)  range with 1 bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_dejavu_40_latin_sup_glyph_bitmap[] = {
#if USE_LV_FONT_DEJAVU_40_LATIN_SUP == 1
    /*Unicode: U+00a0 ( ) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+00a1 (¡) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //%@%
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00a2 (¢) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0xc0,  //........@@.....
    0x00, 0xc0,  //........@@.....
    0x00, 0xc0,  //........@@.....
    0x00, 0xc0,  //........@@.....
    0x00, 0xc0,  //........@@.....
    0x03, 0xf8,  //.....+%@@@@@%+.
    0x0f, 0xfe,  //...+@@@@@@@@@@@
    0x3f, 0xfe,  //..%@@@@@@@@@@@@
    0x3c, 0xc6,  //.+@@@@+.@@..+%@
    0x78, 0xc0,  //.@@@@...@@.....
    0x70, 0xc0,  //+@@@....@@.....
    0xf0, 0xc0,  //%@@%....@@.....
    0xe0, 0xc0,  //@@@.....@@.....
    0xe0, 0xc0,  //@@@.....@@.....
    0xe0, 0xc0,  //@@@.....@@.....
    0xe0, 0xc0,  //@@@.....@@.....
    0xe0, 0xc0,  //@@@.....@@.....
    0xf0, 0xc0,  //%@@+....@@.....
    0x70, 0xc0,  //+@@@....@@.....
    0x78, 0xc0,  //.@@@%...@@.....
    0x3c, 0xc6,  //.+@@@@+.@@..+%@
    0x3f, 0xfe,  //..%@@@@@@@@@@@@
    0x0f, 0xfe,  //...+@@@@@@@@@@@
    0x03, 0xf8,  //.....+%@@@@@%+.
    0x00, 0xc0,  //........@@.....
    0x00, 0xc0,  //........@@.....
    0x00, 0xc0,  //........@@.....
    0x00, 0xc0,  //........@@.....
    0x00, 0xc0,  //........@@.....
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+00a3 (£) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0xfc,  //........%@@@@%+.
    0x03, 0xff,  //......%@@@@@@@@@
    0x07, 0xff,  //.....%@@@@@@@@@@
    0x07, 0x81,  //.....@@@%+....+@
    0x0f, 0x00,  //....%@@@........
    0x0e, 0x00,  //....%@@+........
    0x0e, 0x00,  //....@@@.........
    0x0e, 0x00,  //....@@@.........
    0x0e, 0x00,  //....@@@.........
    0x0e, 0x00,  //....@@@.........
    0x0e, 0x00,  //....@@@.........
    0x0e, 0x00,  //....@@@.........
    0x7f, 0xf8,  //.@@@@@@@@@@@@...
    0x7f, 0xf8,  //.@@@@@@@@@@@@...
    0x7f, 0xf8,  //.@@@@@@@@@@@@...
    0x0e, 0x00,  //....@@@.........
    0x0e, 0x00,  //....@@@.........
    0x0e, 0x00,  //....@@@.........
    0x0e, 0x00,  //....@@@.........
    0x0e, 0x00,  //....@@@.........
    0x0e, 0x00,  //....@@@.........
    0x0e, 0x00,  //....@@@.........
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00a4 (¤) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x40, 0x00, 0x80,  //.%+............+%.
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0x71, 0xe3, 0x80,  //+@@@+.+%@@%+.+@@@+
    0x3f, 0xff, 0x00,  //.+@@@@@@@@@@@@@@+.
    0x1f, 0xfe, 0x00,  //..+@@@@@@@@@@@@+..
    0x1e, 0x1e, 0x00,  //...%@@@+..+@@@@...
    0x1c, 0x0e, 0x00,  //..+@@@......@@@+..
    0x38, 0x07, 0x00,  //..%@@+......+@@%..
    0x38, 0x07, 0x00,  //..@@@........@@@..
    0x38, 0x07, 0x00,  //..@@@........@@@..
    0x38, 0x07, 0x00,  //..%@@+......+@@%..
    0x1c, 0x0e, 0x00,  //...@@@......@@@...
    0x1e, 0x1e, 0x00,  //...@@@@+..+@@@%...
    0x1f, 0xfe, 0x00,  //..+@@@@@@@@@@@@+..
    0x3f, 0xff, 0x00,  //.+@@@@@@@@@@%@@@+.
    0x71, 0xe3, 0x80,  //+@@@+.+%@@%..+@@@+
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0x40, 0x00, 0x80,  //.%+............+%.
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00a5 (¥) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xf0, 0x01, 0xe0,  //%@@%...........%@@%
    0x70, 0x01, 0xc0,  //.@@@+.........+@@@.
    0x78, 0x03, 0xc0,  //.%@@@.........@@@%.
    0x38, 0x03, 0x80,  //..@@@+.......+@@@..
    0x3c, 0x07, 0x80,  //..%@@@.......@@@%..
    0x1e, 0x0f, 0x00,  //...@@@%.....%@@@...
    0x0e, 0x0e, 0x00,  //...+@@@.....@@@+...
    0x0f, 0x1e, 0x00,  //....@@@%...%@@@....
    0x07, 0x1c, 0x00,  //....+@@@...@@@+....
    0x07, 0xbc, 0x00,  //.....@@@%.@@@@.....
    0x7f, 0xff, 0xc0,  //.@@@@@@@@%@@@@@@@@.
    0x7f, 0xff, 0xc0,  //.@@@@@@@@@@@@@@@@@.
    0x01, 0xf0, 0x00,  //.......@@@@@.......
    0x00, 0xe0, 0x00,  //.......+@@@+.......
    0x00, 0xe0, 0x00,  //........@@@........
    0x7f, 0xff, 0xc0,  //.@@@@@@@@@@@@@@@@@.
    0x7f, 0xff, 0xc0,  //.@@@@@@@@@@@@@@@@@.
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00a6 (¦) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00a7 (§) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x0f, 0xc0,  //....%@@@@%+...
    0x3f, 0xf0,  //..+@@@@@@@@@..
    0x38, 0x70,  //.+@@@+...%@@..
    0x70, 0x10,  //.@@@+......%..
    0x70, 0x00,  //.@@@..........
    0x70, 0x00,  //.@@@+.........
    0x78, 0x00,  //.%@@@.........
    0x3c, 0x00,  //..@@@@+.......
    0x1f, 0x00,  //...@@@@@......
    0x3f, 0xc0,  //..@@@@@@@%....
    0x73, 0xe0,  //.@@@..%@@@@+..
    0xe0, 0xf8,  //%@@....+@@@@%.
    0xe0, 0x78,  //@@@......%@@@+
    0xe0, 0x3c,  //@@@.......%@@@
    0xf0, 0x1c,  //%@@@.......@@@
    0x78, 0x1c,  //.@@@@......@@@
    0x3e, 0x1c,  //.+@@@@%...+@@%
    0x1f, 0x38,  //...%@@@@++@@@.
    0x07, 0xf0,  //....+@@@@@@%..
    0x01, 0xe0,  //......+@@@@+..
    0x00, 0xf0,  //........@@@@..
    0x00, 0x78,  //.........@@@%.
    0x00, 0x38,  //..........@@@.
    0x00, 0x38,  //..........@@@.
    0x40, 0x38,  //.%.......+@@%.
    0x70, 0xf0,  //.@@%+...+@@@..
    0x7f, 0xe0,  //.@@@@@@@@@@+..
    0x1f, 0xc0,  //..+%@@@@@%....
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+00a8 (¨) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xe3, 0x80,  //@@@...@@@
    0xe3, 0x80,  //@@@...@@@
    0xe3, 0x80,  //@@@...@@@
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+00a9 (©) , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x7f, 0x00, 0x00,  //........+%@@@@@%+........
    0x01, 0xff, 0xc0, 0x00,  //......+@@@@@@@@@@@+......
    0x07, 0x80, 0xf0, 0x00,  //.....@@@@+.....+@@@@.....
    0x0e, 0x00, 0x38, 0x00,  //....@@@+.........+@@@....
    0x1c, 0x00, 0x1c, 0x00,  //...@@%.............%@@...
    0x38, 0x3f, 0x0e, 0x00,  //..@@%....+@@@@@+....%@@..
    0x30, 0xff, 0x86, 0x00,  //.+@@...+@@@@@@@@@....@@+.
    0x61, 0xe0, 0x83, 0x00,  //.@@+..+@@@%....+@....+@@.
    0x63, 0x80, 0x03, 0x00,  //+@@...@@@+............@@+
    0xc7, 0x80, 0x01, 0x80,  //%@+..+@@%.............+@%
    0xc7, 0x00, 0x01, 0x80,  //@@...@@@...............@@
    0xc7, 0x00, 0x01, 0x80,  //@@...@@@...............@@
    0xc7, 0x00, 0x01, 0x80,  //@@...@@@...............@@
    0xc7, 0x00, 0x01, 0x80,  //@@...@@@...............@@
    0xc7, 0x00, 0x01, 0x80,  //@@...@@@...............@@
    0xc3, 0x80, 0x01, 0x80,  //%@+..+@@%.............+@%
    0x63, 0x80, 0x03, 0x00,  //+@@...@@@+............@@+
    0x61, 0xe0, 0x83, 0x00,  //.@@+..+@@@%....+@....+@@.
    0x30, 0xff, 0x86, 0x00,  //.+@@...+@@@@@@@@@....@@+.
    0x38, 0x3f, 0x0e, 0x00,  //..@@%....+@@@@@%....%@@..
    0x1c, 0x00, 0x1c, 0x00,  //...@@%.............%@@...
    0x0e, 0x00, 0x38, 0x00,  //....@@@+.........+@@@....
    0x07, 0x80, 0xf0, 0x00,  //.....@@@@+.....+@@@@.....
    0x01, 0xff, 0xc0, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x7f, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+00aa (ª) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x1f, 0x80,  //..+%@@@@%....
    0x7f, 0xc0,  //.@@@@@@@@@+..
    0x40, 0xe0,  //.@+....+@@@..
    0x00, 0x70,  //........+@@%.
    0x00, 0x70,  //.........@@@.
    0x1f, 0xf0,  //..+%@@@@@@@@.
    0x7f, 0xf0,  //.%@@@@@@@@@@.
    0x70, 0x70,  //+@@@+....@@@.
    0xe0, 0x70,  //@@@......@@@.
    0xe0, 0x70,  //@@@.....+@@@.
    0xe0, 0xf0,  //@@@.....@@@@.
    0xf1, 0xf0,  //%@@@...%@@@@.
    0x7f, 0x70,  //.@@@@@@@+@@@.
    0x3e, 0x70,  //..%@@@%..@@@.
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0xff, 0xf0,  //%@@@@@@@@@@@.
    0xff, 0xf0,  //%@@@@@@@@@@@.
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00ab («) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x01, 0x02,  //.......%......%
    0x03, 0x06,  //......%@.....%@
    0x07, 0x0e,  //.....@@@....@@@
    0x0e, 0x1c,  //....@@@....@@@.
    0x1c, 0x38,  //..+@@%...+@@%..
    0x38, 0x70,  //.+@@%...+@@%...
    0xe1, 0xc0,  //%@@+...%@@+....
    0xe1, 0xc0,  //@@%....@@%.....
    0xe1, 0xc0,  //%@@+...%@@+....
    0x38, 0x70,  //.+@@%...+@@%...
    0x1c, 0x38,  //..+@@%...+@@%..
    0x0e, 0x1c,  //....@@@....@@@.
    0x07, 0x0e,  //.....@@@....@@@
    0x03, 0x06,  //......%@.....%@
    0x01, 0x02,  //.......%......%
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+00ac (¬) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x38,  //..................@@@
    0x00, 0x00, 0x38,  //..................@@@
    0x00, 0x00, 0x38,  //..................@@@
    0x00, 0x00, 0x38,  //..................@@@
    0x00, 0x00, 0x38,  //..................@@@
    0x00, 0x00, 0x38,  //..................@@@
    0x00, 0x00, 0x38,  //..................@@@
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+00ad (­) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xff, 0x80,  //@@@@@@@@@
    0xff, 0x80,  //@@@@@@@@@
    0xff, 0x80,  //@@@@@@@@@
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+00ae (®) , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x7f, 0x00, 0x00,  //........+%@@@@@%+........
    0x01, 0xff, 0xc0, 0x00,  //......+@@@@@@@@@@@+......
    0x07, 0x80, 0xf0, 0x00,  //.....@@@@+.....+@@@@.....
    0x0e, 0x00, 0x38, 0x00,  //....@@@+.........+@@@....
    0x1c, 0x00, 0x1c, 0x00,  //...@@%.............%@@...
    0x38, 0xff, 0x0e, 0x00,  //..@@%...@@@@@@@%....%@@..
    0x30, 0xff, 0x86, 0x00,  //.+@@....@@@@@@@@@....@@+.
    0x60, 0xe3, 0xc3, 0x00,  //.@@+....@@@...%@@%...+@@.
    0x60, 0xe1, 0xc3, 0x00,  //+@@.....@@@....@@@....@@+
    0xc0, 0xe1, 0xc1, 0x80,  //%@+.....@@@....@@@....+@%
    0xc0, 0xe3, 0xc1, 0x80,  //@@......@@@...%@@%.....@@
    0xc0, 0xff, 0x81, 0x80,  //@@......@@@@@@@@%......@@
    0xc0, 0xfe, 0x01, 0x80,  //@@......@@@@@@@........@@
    0xc0, 0xe6, 0x01, 0x80,  //@@......@@@..@@+.......@@
    0xc0, 0xe3, 0x01, 0x80,  //@@......@@@..+@@.......@@
    0xc0, 0xe3, 0x81, 0x80,  //%@+.....@@@...@@%.....+@%
    0x60, 0xe3, 0x83, 0x00,  //+@@.....@@@...%@@.....@@+
    0x60, 0xe1, 0xc3, 0x00,  //.@@+....@@@....@@%...+@@.
    0x30, 0xe1, 0xc6, 0x00,  //.+@@....@@@....%@@...@@+.
    0x38, 0xe0, 0xee, 0x00,  //..@@%...@@@.....@@%.%@@..
    0x1c, 0x00, 0x1c, 0x00,  //...@@%.............%@@...
    0x0e, 0x00, 0x38, 0x00,  //....@@@+.........+@@@....
    0x07, 0x80, 0xf0, 0x00,  //.....@@@@+.....+@@@@.....
    0x01, 0xff, 0xc0, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x7f, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+00af (¯) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0xff, 0xc0,  //@@@@@@@@@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xff, 0xc0,  //@@@@@@@@@@
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00b0 (°) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x1f, 0x00,  //...%@@@%...
    0x3f, 0x80,  //.+@@@@@@@+.
    0x71, 0xc0,  //.@@%...%@@.
    0xe0, 0xe0,  //%@%.....%@%
    0xc0, 0x60,  //@@.......@@
    0xc0, 0x60,  //@@.......@@
    0xc0, 0x60,  //@@.......@@
    0xe0, 0xe0,  //%@%.....%@%
    0x71, 0xc0,  //.@@%...%@@.
    0x3f, 0x80,  //.+@@@@@@@+.
    0x1f, 0x00,  //...%@@@%...
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+00b1 (±) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+00b2 (²) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x3e, 0x00,  //.+%@@@@+..
    0xff, 0x80,  //@@@@@@@@@.
    0xc1, 0xc0,  //@+....+@@%
    0x00, 0xc0,  //.......+@@
    0x00, 0xc0,  //........@@
    0x01, 0x80,  //.......%@+
    0x01, 0x80,  //......+@@.
    0x03, 0x00,  //.....+@@..
    0x0e, 0x00,  //....%@@...
    0x1c, 0x00,  //...%@@+...
    0x38, 0x00,  //..@@@.....
    0x70, 0x00,  //+@@@......
    0xff, 0xc0,  //@@@@@@@@@@
    0xff, 0xc0,  //@@@@@@@@@@
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00b3 (³) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x3f, 0x00,  //.+%@@@@%..
    0xff, 0x80,  //@@@@@@@@@+
    0x81, 0xc0,  //@+.....%@@
    0x00, 0xc0,  //........@@
    0x01, 0xc0,  //.......%@%
    0x1f, 0x80,  //...@@@@@%.
    0x1f, 0x80,  //...@@@@@%.
    0x01, 0xc0,  //......+@@+
    0x00, 0xc0,  //.......+@@
    0x00, 0xc0,  //........@@
    0x00, 0xc0,  //.......+@@
    0x81, 0xc0,  //%+....+@@%
    0xff, 0x80,  //@@@@@@@@%.
    0x7e, 0x00,  //.%@@@@%+..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00b4 (´) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x0f,  //....%@@%
    0x0e,  //...+@@%.
    0x1c,  //..+@@%..
    0x38,  //..@@@...
    0x70,  //.@@@....
    0xe0,  //%@@.....
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00b5 (µ) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0xe0, 0x07, 0x00,  //@@@..........@@@..
    0xe0, 0x07, 0x00,  //@@@..........@@@..
    0xe0, 0x07, 0x00,  //@@@..........@@@..
    0xe0, 0x07, 0x00,  //@@@..........@@@..
    0xe0, 0x07, 0x00,  //@@@..........@@@..
    0xe0, 0x07, 0x00,  //@@@..........@@@..
    0xe0, 0x07, 0x00,  //@@@..........@@@..
    0xe0, 0x07, 0x00,  //@@@..........@@@..
    0xe0, 0x07, 0x00,  //@@@..........@@@..
    0xe0, 0x07, 0x00,  //@@@..........@@@..
    0xe0, 0x07, 0x00,  //@@@..........@@@..
    0xe0, 0x07, 0x00,  //@@@..........@@@..
    0xe0, 0x07, 0x00,  //@@@..........@@@..
    0xe0, 0x07, 0x00,  //@@@+........+@@@..
    0xf0, 0x0f, 0x00,  //@@@@........@@@@..
    0xf8, 0x3f, 0x00,  //@@@@@+....+@@@@@+.
    0xff, 0xff, 0xc0,  //@@@%@@@@@@@@@%@@@@
    0xef, 0xf3, 0xc0,  //@@@.@@@@@@@@.+@@@@
    0xe3, 0xc3, 0x80,  //@@@..+@@@@+...%@@+
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00b6 (¶) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x07, 0xfe,  //....+%@@@@@@@@@
    0x1f, 0xfe,  //...@@@@@@@@@@@@
    0x3f, 0xc6,  //.+@@@@@@@@...@@
    0x7f, 0xc6,  //.@@@@@@@@@...@@
    0xff, 0xc6,  //%@@@@@@@@@...@@
    0xff, 0xc6,  //@@@@@@@@@@...@@
    0xff, 0xc6,  //@@@@@@@@@@...@@
    0xff, 0xc6,  //@@@@@@@@@@...@@
    0xff, 0xc6,  //@@@@@@@@@@...@@
    0xff, 0xc6,  //%@@@@@@@@@...@@
    0x7f, 0xc6,  //.@@@@@@@@@...@@
    0x3f, 0xc6,  //.+@@@@@@@@...@@
    0x1f, 0xc6,  //...@@@@@@@...@@
    0x07, 0xc6,  //.....%@@@@...@@
    0x00, 0xc6,  //........@@...@@
    0x00, 0xc6,  //........@@...@@
    0x00, 0xc6,  //........@@...@@
    0x00, 0xc6,  //........@@...@@
    0x00, 0xc6,  //........@@...@@
    0x00, 0xc6,  //........@@...@@
    0x00, 0xc6,  //........@@...@@
    0x00, 0xc6,  //........@@...@@
    0x00, 0xc6,  //........@@...@@
    0x00, 0xc6,  //........@@...@@
    0x00, 0xc6,  //........@@...@@
    0x00, 0xc6,  //........@@...@@
    0x00, 0xc6,  //........@@...@@
    0x00, 0xc6,  //........@@...@@
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+00b7 (·) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00b8 (¸) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x18,  //...@@+.
    0x0c,  //...+@@.
    0x0e,  //....@@%
    0x0e,  //....@@@
    0x8e,  //%..+@@@
    0xfe,  //@@@@@@%
    0xf8,  //%@@@@+.
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+00b9 (¹) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x38,  //.+@@@...
    0xf8,  //@@@@@...
    0x98,  //@+.@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00ba (º) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //...+%@@@%+...
    0x3f, 0xe0,  //..%@@@@@@@%..
    0x78, 0xf0,  //.%@@%...%@@%.
    0x70, 0x70,  //+@@@.....@@@+
    0xe0, 0x38,  //%@@+.....+@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //%@@+.....+@@%
    0x70, 0x70,  //+@@@.....@@@+
    0x78, 0xf0,  //.%@@%...%@@%.
    0x3f, 0xe0,  //..%@@@@@@@@..
    0x0f, 0x80,  //...+%@@@%+...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x7f, 0xf0,  //.@@@@@@@@@@@.
    0x7f, 0xf0,  //.@@@@@@@@@@@.
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00bb (») , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x81, 0x00,  //%......%.......
    0xc1, 0x80,  //@%.....@%......
    0xe1, 0xc0,  //@@@....@@@.....
    0x70, 0xe0,  //.@@@....@@@....
    0x38, 0x70,  //..%@@+...%@@+..
    0x1c, 0x38,  //...%@@+...%@@+.
    0x07, 0x0e,  //....+@@%...+@@%
    0x07, 0x0e,  //.....%@@....%@@
    0x07, 0x0e,  //....+@@%...+@@%
    0x1c, 0x38,  //...%@@+...%@@+.
    0x38, 0x70,  //..%@@+...%@@+..
    0x70, 0xe0,  //.@@@....@@@....
    0xe1, 0xc0,  //@@@....@@@.....
    0xc1, 0x80,  //@%.....@%......
    0x81, 0x00,  //%......%.......
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+00bc (¼) , Width: 28 */
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x38, 0x00, 0x0e, 0x00,  //.+@@@...............%@%.....
    0xf8, 0x00, 0x0c, 0x00,  //@@@@@..............+@@......
    0x98, 0x00, 0x18, 0x00,  //@+.@@..............@@+......
    0x18, 0x00, 0x38, 0x00,  //...@@.............%@@.......
    0x18, 0x00, 0x30, 0x00,  //...@@.............@@........
    0x18, 0x00, 0x70, 0x00,  //...@@............@@%........
    0x18, 0x00, 0x60, 0x00,  //...@@...........+@@.........
    0x18, 0x00, 0xc0, 0x00,  //...@@...........@@+.........
    0x18, 0x01, 0xc0, 0x00,  //...@@..........%@%..........
    0x18, 0x01, 0x80, 0x00,  //...@@.........+@@...........
    0x18, 0x03, 0x00, 0x00,  //...@@.........@@+...........
    0x18, 0x07, 0x01, 0xc0,  //...@@........%@@.......@@@..
    0xff, 0x06, 0x03, 0xc0,  //@@@@@@@@.....@@.......%@@@..
    0xff, 0x0e, 0x03, 0xc0,  //@@@@@@@@....@@%......+@%@@..
    0x00, 0x0c, 0x06, 0xc0,  //...........+@@.......@@.@@..
    0x00, 0x18, 0x0c, 0xc0,  //...........@@+......@@..@@..
    0x00, 0x38, 0x18, 0xc0,  //..........%@%......%@+..@@..
    0x00, 0x30, 0x18, 0xc0,  //.........+@@......+@%...@@..
    0x00, 0x60, 0x30, 0xc0,  //.........@@+......@@....@@..
    0x00, 0xe0, 0x60, 0xc0,  //........%@@......%@.....@@..
    0x00, 0xc0, 0x7f, 0xf0,  //........@@.......@@@@@@@@@@@
    0x01, 0xc0, 0x7f, 0xf0,  //.......@@%.......@@@@@@@@@@@
    0x01, 0x80, 0x00, 0xc0,  //......+@@...............@@..
    0x03, 0x00, 0x00, 0xc0,  //......@@+...............@@..
    0x07, 0x00, 0x00, 0xc0,  //.....%@%................@@..
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................


    /*Unicode: U+00bd (½) , Width: 28 */
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x38, 0x00, 0x0e, 0x00,  //.+@@@...............%@%.....
    0xf8, 0x00, 0x0c, 0x00,  //@@@@@..............+@@......
    0x98, 0x00, 0x18, 0x00,  //@+.@@..............@@+......
    0x18, 0x00, 0x38, 0x00,  //...@@.............%@@.......
    0x18, 0x00, 0x30, 0x00,  //...@@.............@@........
    0x18, 0x00, 0x70, 0x00,  //...@@............@@%........
    0x18, 0x00, 0x60, 0x00,  //...@@...........+@@.........
    0x18, 0x00, 0xc0, 0x00,  //...@@...........@@+.........
    0x18, 0x01, 0xc0, 0x00,  //...@@..........%@%..........
    0x18, 0x01, 0x80, 0x00,  //...@@.........+@@...........
    0x18, 0x03, 0x00, 0x00,  //...@@.........@@+...........
    0x18, 0x07, 0x0f, 0x80,  //...@@........%@@...+%@@@@+..
    0xff, 0x06, 0x3f, 0xe0,  //@@@@@@@@.....@@...@@@@@@@@@.
    0xff, 0x0e, 0x30, 0x70,  //@@@@@@@@....@@%...@+....+@@%
    0x00, 0x0c, 0x00, 0x30,  //...........+@@...........+@@
    0x00, 0x18, 0x00, 0x30,  //...........@@+............@@
    0x00, 0x38, 0x00, 0x60,  //..........%@%............%@+
    0x00, 0x30, 0x00, 0x60,  //.........+@@............+@@.
    0x00, 0x60, 0x00, 0xc0,  //.........@@+...........+@@..
    0x00, 0xe0, 0x03, 0x80,  //........%@@...........%@@...
    0x00, 0xc0, 0x07, 0x00,  //........@@...........%@@+...
    0x01, 0xc0, 0x0e, 0x00,  //.......@@%..........@@@.....
    0x01, 0x80, 0x1c, 0x00,  //......+@@.........+@@@......
    0x03, 0x00, 0x3f, 0xf0,  //......@@+.........@@@@@@@@@@
    0x07, 0x00, 0x3f, 0xf0,  //.....%@%..........@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................


    /*Unicode: U+00be (¾) , Width: 29 */
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x3f, 0x00, 0x07, 0x00,  //.+%@@@@%.............%@%.....
    0xff, 0x80, 0x06, 0x00,  //@@@@@@@@@+..........+@@......
    0x81, 0xc0, 0x0c, 0x00,  //@+.....%@@..........@@+......
    0x00, 0xc0, 0x1c, 0x00,  //........@@.........%@@.......
    0x01, 0xc0, 0x18, 0x00,  //.......%@%.........@@........
    0x1f, 0x80, 0x38, 0x00,  //...@@@@@%.........@@%........
    0x1f, 0x80, 0x30, 0x00,  //...@@@@@%........+@@.........
    0x01, 0xc0, 0x60, 0x00,  //......+@@+.......@@+.........
    0x00, 0xc0, 0xe0, 0x00,  //.......+@@......%@%..........
    0x00, 0xc0, 0xc0, 0x00,  //........@@.....+@@...........
    0x00, 0xc1, 0x80, 0x00,  //.......+@@.....@@+...........
    0x81, 0xc3, 0x80, 0xe0,  //%+....+@@%....%@@.......@@@..
    0xff, 0x83, 0x01, 0xe0,  //@@@@@@@@%.....@@.......%@@@..
    0x7e, 0x07, 0x01, 0xe0,  //.%@@@@%+.....@@%......+@%@@..
    0x00, 0x06, 0x03, 0x60,  //............+@@.......@@.@@..
    0x00, 0x0c, 0x06, 0x60,  //............@@+......@@..@@..
    0x00, 0x1c, 0x0c, 0x60,  //...........%@%......%@+..@@..
    0x00, 0x18, 0x0c, 0x60,  //..........+@@......+@%...@@..
    0x00, 0x30, 0x18, 0x60,  //..........@@+......@@....@@..
    0x00, 0x70, 0x30, 0x60,  //.........%@@......%@.....@@..
    0x00, 0x60, 0x3f, 0xf8,  //.........@@.......@@@@@@@@@@@
    0x00, 0xe0, 0x3f, 0xf8,  //........@@%.......@@@@@@@@@@@
    0x00, 0xc0, 0x00, 0x60,  //.......+@@...............@@..
    0x01, 0x80, 0x00, 0x60,  //.......@@+...............@@..
    0x03, 0x80, 0x00, 0x60,  //......%@%................@@..
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+00bf (¿) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x03, 0x80,  //......@@@....
    0x03, 0x80,  //......@@@....
    0x03, 0x80,  //......@@@....
    0x03, 0x80,  //......@@@....
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x03, 0x80,  //......@@@....
    0x03, 0x80,  //......@@@....
    0x03, 0x80,  //......@@@....
    0x03, 0x80,  //......@@@....
    0x03, 0x80,  //......@@@....
    0x07, 0x80,  //.....%@@%....
    0x0f, 0x00,  //....%@@@.....
    0x1f, 0x00,  //...%@@@%.....
    0x3e, 0x00,  //..%@@@@......
    0x3c, 0x00,  //.+@@@@.......
    0x78, 0x00,  //.@@@@........
    0xf0, 0x00,  //%@@@.........
    0xe0, 0x00,  //@@@+.........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xf0, 0x08,  //@@@%........%
    0x78, 0x38,  //+@@@%....+%@@
    0x7f, 0xf8,  //.@@@@@@@@@@@@
    0x3f, 0xf0,  //..@@@@@@@@@@+
    0x0f, 0xc0,  //...+%@@@@%+..
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00c0 (À) , Width: 23 */
    0x01, 0xc0, 0x00,  //.......%@@+............
    0x00, 0xe0, 0x00,  //........%@@+...........
    0x00, 0x70, 0x00,  //.........%@@...........
    0x00, 0x38, 0x00,  //..........%@@..........
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x7c, 0x00,  //.........%@@@%.........
    0x00, 0x7c, 0x00,  //.........@@@@@.........
    0x00, 0x7c, 0x00,  //........+@@@@@+........
    0x00, 0xfe, 0x00,  //........@@@@@@@........
    0x00, 0xee, 0x00,  //........@@@.@@@........
    0x01, 0xef, 0x00,  //.......%@@%.%@@%.......
    0x01, 0xc7, 0x00,  //.......@@@+.+@@@.......
    0x01, 0xc7, 0x00,  //......+@@@...@@@+......
    0x03, 0xc7, 0x80,  //......%@@%...%@@%......
    0x03, 0x83, 0x80,  //......@@@.....@@@......
    0x03, 0x83, 0x80,  //.....+@@@.....%@@+.....
    0x07, 0x01, 0xc0,  //.....@@@+.....+@@@.....
    0x07, 0x01, 0xc0,  //.....@@@.......@@@.....
    0x0f, 0x01, 0xe0,  //....%@@%.......%@@%....
    0x0e, 0x00, 0xe0,  //....@@@.........@@@....
    0x0e, 0x00, 0xe0,  //...+@@@.........@@@+...
    0x1f, 0xff, 0xf0,  //...%@@@@@@@@@@@@@@@%...
    0x1f, 0xff, 0xf0,  //...@@@@@@@@@@@@@@@@@...
    0x3f, 0xff, 0xf8,  //..%@@@@@@@@@@@@@@@@@%..
    0x38, 0x00, 0x38,  //..@@@+...........+@@@..
    0x38, 0x00, 0x38,  //.+@@@.............@@@+.
    0x78, 0x00, 0x3c,  //.%@@%.............%@@%.
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x70, 0x00, 0x1c,  //+@@@...............@@@+
    0xe0, 0x00, 0x0e,  //@@@+...............+@@@
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c1 (Á) , Width: 23 */
    0x00, 0x0e, 0x00,  //............@@@........
    0x00, 0x1c, 0x00,  //...........@@@.........
    0x00, 0x38, 0x00,  //..........%@@..........
    0x00, 0x70, 0x00,  //.........%@@...........
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x7c, 0x00,  //.........%@@@%.........
    0x00, 0x7c, 0x00,  //.........@@@@@.........
    0x00, 0x7c, 0x00,  //........+@@@@@+........
    0x00, 0xfe, 0x00,  //........@@@@@@@........
    0x00, 0xee, 0x00,  //........@@@.@@@........
    0x01, 0xef, 0x00,  //.......%@@%.%@@%.......
    0x01, 0xc7, 0x00,  //.......@@@+.+@@@.......
    0x01, 0xc7, 0x00,  //......+@@@...@@@+......
    0x03, 0xc7, 0x80,  //......%@@%...%@@%......
    0x03, 0x83, 0x80,  //......@@@.....@@@......
    0x03, 0x83, 0x80,  //.....+@@@.....%@@+.....
    0x07, 0x01, 0xc0,  //.....@@@+.....+@@@.....
    0x07, 0x01, 0xc0,  //.....@@@.......@@@.....
    0x0f, 0x01, 0xe0,  //....%@@%.......%@@%....
    0x0e, 0x00, 0xe0,  //....@@@.........@@@....
    0x0e, 0x00, 0xe0,  //...+@@@.........@@@+...
    0x1f, 0xff, 0xf0,  //...%@@@@@@@@@@@@@@@%...
    0x1f, 0xff, 0xf0,  //...@@@@@@@@@@@@@@@@@...
    0x3f, 0xff, 0xf8,  //..%@@@@@@@@@@@@@@@@@%..
    0x38, 0x00, 0x38,  //..@@@+...........+@@@..
    0x38, 0x00, 0x38,  //.+@@@.............@@@+.
    0x78, 0x00, 0x3c,  //.%@@%.............%@@%.
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x70, 0x00, 0x1c,  //+@@@...............@@@+
    0xe0, 0x00, 0x0e,  //@@@+...............+@@@
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c2 (Â) , Width: 23 */
    0x00, 0x38, 0x00,  //.........+@@@+.........
    0x00, 0x7c, 0x00,  //.........@@%@@.........
    0x00, 0xc6, 0x00,  //........@@+.+@@........
    0x01, 0xc7, 0x00,  //.......%@+...+@%.......
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x7c, 0x00,  //.........%@@@%.........
    0x00, 0x7c, 0x00,  //.........@@@@@.........
    0x00, 0x7c, 0x00,  //........+@@@@@+........
    0x00, 0xfe, 0x00,  //........@@@@@@@........
    0x00, 0xee, 0x00,  //........@@@.@@@........
    0x01, 0xef, 0x00,  //.......%@@%.%@@%.......
    0x01, 0xc7, 0x00,  //.......@@@+.+@@@.......
    0x01, 0xc7, 0x00,  //......+@@@...@@@+......
    0x03, 0xc7, 0x80,  //......%@@%...%@@%......
    0x03, 0x83, 0x80,  //......@@@.....@@@......
    0x03, 0x83, 0x80,  //.....+@@@.....%@@+.....
    0x07, 0x01, 0xc0,  //.....@@@+.....+@@@.....
    0x07, 0x01, 0xc0,  //.....@@@.......@@@.....
    0x0f, 0x01, 0xe0,  //....%@@%.......%@@%....
    0x0e, 0x00, 0xe0,  //....@@@.........@@@....
    0x0e, 0x00, 0xe0,  //...+@@@.........@@@+...
    0x1f, 0xff, 0xf0,  //...%@@@@@@@@@@@@@@@%...
    0x1f, 0xff, 0xf0,  //...@@@@@@@@@@@@@@@@@...
    0x3f, 0xff, 0xf8,  //..%@@@@@@@@@@@@@@@@@%..
    0x38, 0x00, 0x38,  //..@@@+...........+@@@..
    0x38, 0x00, 0x38,  //.+@@@.............@@@+.
    0x78, 0x00, 0x3c,  //.%@@%.............%@@%.
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x70, 0x00, 0x1c,  //+@@@...............@@@+
    0xe0, 0x00, 0x0e,  //@@@+...............+@@@
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c3 (Ã) , Width: 23 */
    0x00, 0xe1, 0x80,  //.......+@@%....@@......
    0x01, 0xf9, 0x80,  //......+@@@@@%.+@%......
    0x03, 0x3f, 0x00,  //......@@+.%@@@@@+......
    0x03, 0x0e, 0x00,  //......@@....%@@+.......
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x7c, 0x00,  //.........%@@@%.........
    0x00, 0x7c, 0x00,  //.........@@@@@.........
    0x00, 0x7c, 0x00,  //........+@@@@@+........
    0x00, 0xfe, 0x00,  //........@@@@@@@........
    0x00, 0xee, 0x00,  //........@@@.@@@........
    0x01, 0xef, 0x00,  //.......%@@%.%@@%.......
    0x01, 0xc7, 0x00,  //.......@@@+.+@@@.......
    0x01, 0xc7, 0x00,  //......+@@@...@@@+......
    0x03, 0xc7, 0x80,  //......%@@%...%@@%......
    0x03, 0x83, 0x80,  //......@@@.....@@@......
    0x03, 0x83, 0x80,  //.....+@@@.....%@@+.....
    0x07, 0x01, 0xc0,  //.....@@@+.....+@@@.....
    0x07, 0x01, 0xc0,  //.....@@@.......@@@.....
    0x0f, 0x01, 0xe0,  //....%@@%.......%@@%....
    0x0e, 0x00, 0xe0,  //....@@@.........@@@....
    0x0e, 0x00, 0xe0,  //...+@@@.........@@@+...
    0x1f, 0xff, 0xf0,  //...%@@@@@@@@@@@@@@@%...
    0x1f, 0xff, 0xf0,  //...@@@@@@@@@@@@@@@@@...
    0x3f, 0xff, 0xf8,  //..%@@@@@@@@@@@@@@@@@%..
    0x38, 0x00, 0x38,  //..@@@+...........+@@@..
    0x38, 0x00, 0x38,  //.+@@@.............@@@+.
    0x78, 0x00, 0x3c,  //.%@@%.............%@@%.
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x70, 0x00, 0x1c,  //+@@@...............@@@+
    0xe0, 0x00, 0x0e,  //@@@+...............+@@@
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c4 (Ä) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x01, 0xc7, 0x00,  //.......@@@...@@@.......
    0x01, 0xc7, 0x00,  //.......@@@...@@@.......
    0x01, 0xc7, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x7c, 0x00,  //.........%@@@%.........
    0x00, 0x7c, 0x00,  //.........@@@@@.........
    0x00, 0x7c, 0x00,  //........+@@@@@+........
    0x00, 0xfe, 0x00,  //........@@@@@@@........
    0x00, 0xee, 0x00,  //........@@@.@@@........
    0x01, 0xef, 0x00,  //.......%@@%.%@@%.......
    0x01, 0xc7, 0x00,  //.......@@@+.+@@@.......
    0x01, 0xc7, 0x00,  //......+@@@...@@@+......
    0x03, 0xc7, 0x80,  //......%@@%...%@@%......
    0x03, 0x83, 0x80,  //......@@@.....@@@......
    0x03, 0x83, 0x80,  //.....+@@@.....%@@+.....
    0x07, 0x01, 0xc0,  //.....@@@+.....+@@@.....
    0x07, 0x01, 0xc0,  //.....@@@.......@@@.....
    0x0f, 0x01, 0xe0,  //....%@@%.......%@@%....
    0x0e, 0x00, 0xe0,  //....@@@.........@@@....
    0x0e, 0x00, 0xe0,  //...+@@@.........@@@+...
    0x1f, 0xff, 0xf0,  //...%@@@@@@@@@@@@@@@%...
    0x1f, 0xff, 0xf0,  //...@@@@@@@@@@@@@@@@@...
    0x3f, 0xff, 0xf8,  //..%@@@@@@@@@@@@@@@@@%..
    0x38, 0x00, 0x38,  //..@@@+...........+@@@..
    0x38, 0x00, 0x38,  //.+@@@.............@@@+.
    0x78, 0x00, 0x3c,  //.%@@%.............%@@%.
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x70, 0x00, 0x1c,  //+@@@...............@@@+
    0xe0, 0x00, 0x0e,  //@@@+...............+@@@
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c5 (Å) , Width: 23 */
    0x00, 0xfe, 0x00,  //........@@@@@@%........
    0x01, 0xc6, 0x00,  //.......%@@..+@@+.......
    0x01, 0x83, 0x00,  //.......@@....+@@.......
    0x01, 0x83, 0x00,  //.......@@.....@@.......
    0x01, 0x83, 0x00,  //.......@@.....@@.......
    0x01, 0xc7, 0x00,  //.......%@@...@@%.......
    0x00, 0xfe, 0x00,  //........@@@@@@@........
    0x00, 0x7c, 0x00,  //.........@@@@@.........
    0x00, 0x7c, 0x00,  //........+@@@@@+........
    0x00, 0xfe, 0x00,  //........@@@@@@@........
    0x00, 0xee, 0x00,  //........@@@.@@@........
    0x01, 0xef, 0x00,  //.......%@@%.%@@%.......
    0x01, 0xc7, 0x00,  //.......@@@...@@@.......
    0x01, 0xc7, 0x00,  //......+@@@...@@@+......
    0x03, 0x83, 0x80,  //......%@@+...+@@%......
    0x03, 0x83, 0x80,  //......@@@.....@@@......
    0x03, 0x83, 0x80,  //.....+@@%.....%@@+.....
    0x07, 0x01, 0xc0,  //.....@@@+.....+@@@.....
    0x07, 0x01, 0xc0,  //.....@@@.......@@@.....
    0x0f, 0x01, 0xe0,  //....%@@%.......%@@%....
    0x0e, 0x00, 0xe0,  //....@@@.........@@@....
    0x0e, 0x00, 0xe0,  //...+@@@.........@@@+...
    0x1f, 0xff, 0xf0,  //...@@@@@@@@@@@@@@@@@...
    0x1f, 0xff, 0xf0,  //...@@@@@@@@@@@@@@@@@...
    0x3f, 0xff, 0xf8,  //..%@@@@@@@@@@@@@@@@@%..
    0x38, 0x00, 0x38,  //..@@@+...........+@@@..
    0x38, 0x00, 0x38,  //.+@@@.............@@@+.
    0x78, 0x00, 0x3c,  //.%@@%.............%@@%.
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x70, 0x00, 0x1c,  //+@@@...............@@@+
    0xe0, 0x00, 0x0e,  //@@@+...............+@@@
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c6 (Æ) , Width: 31 */
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x3f, 0xff, 0xfe,  //..........%@@@@@@@@@@@@@@@@@@@@
    0x00, 0x3f, 0xff, 0xfe,  //..........@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x7f, 0xff, 0xfe,  //.........%@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x71, 0xc0, 0x00,  //.........@@@+..@@@.............
    0x00, 0x71, 0xc0, 0x00,  //........+@@@...@@@.............
    0x00, 0xe1, 0xc0, 0x00,  //........@@@+...@@@.............
    0x00, 0xe1, 0xc0, 0x00,  //........@@@....@@@.............
    0x01, 0xe1, 0xc0, 0x00,  //.......%@@%....@@@.............
    0x01, 0xc1, 0xc0, 0x00,  //.......@@@.....@@@.............
    0x01, 0xc1, 0xc0, 0x00,  //......+@@%.....@@@.............
    0x03, 0x81, 0xff, 0xfc,  //......@@@+.....@@@@@@@@@@@@@@@.
    0x03, 0x81, 0xff, 0xfc,  //.....+@@@......@@@@@@@@@@@@@@@.
    0x07, 0x01, 0xff, 0xfc,  //.....%@@+......@@@@@@@@@@@@@@@.
    0x07, 0x01, 0xc0, 0x00,  //.....@@@.......@@@.............
    0x0f, 0x01, 0xc0, 0x00,  //....%@@%.......@@@.............
    0x0e, 0x01, 0xc0, 0x00,  //....@@@........@@@.............
    0x0f, 0xff, 0xc0, 0x00,  //...+@@@@@@@@@@@@@@.............
    0x1f, 0xff, 0xc0, 0x00,  //...@@@@@@@@@@@@@@@.............
    0x1f, 0xff, 0xc0, 0x00,  //..+@@@@@@@@@@@@@@@.............
    0x3c, 0x01, 0xc0, 0x00,  //..%@@%.........@@@.............
    0x38, 0x01, 0xc0, 0x00,  //..@@@..........@@@.............
    0x78, 0x01, 0xc0, 0x00,  //.%@@%..........@@@.............
    0x70, 0x01, 0xff, 0xfe,  //.@@@+..........@@@@@@@@@@@@@@@@
    0x70, 0x01, 0xff, 0xfe,  //+@@@...........@@@@@@@@@@@@@@@@
    0xe0, 0x01, 0xff, 0xfe,  //@@@+...........@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+00c7 (Ç) , Width: 20 */
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0xff, 0x00,  //.......+%@@@@@@%+...
    0x03, 0xff, 0xe0,  //.....+@@@@@@@@@@@@%.
    0x0f, 0xff, 0xf0,  //....%@@@@@@@@@@@@@@@
    0x1f, 0x81, 0xf0,  //...@@@@@%+....+%@@@@
    0x3e, 0x00, 0x30,  //..%@@@+..........+@@
    0x38, 0x00, 0x10,  //.+@@@+.............%
    0x78, 0x00, 0x00,  //.@@@%...............
    0x70, 0x00, 0x00,  //.@@@................
    0x70, 0x00, 0x00,  //+@@%................
    0xe0, 0x00, 0x00,  //%@@+................
    0xe0, 0x00, 0x00,  //@@@.................
    0xe0, 0x00, 0x00,  //@@@.................
    0xe0, 0x00, 0x00,  //@@@.................
    0xe0, 0x00, 0x00,  //@@@.................
    0xe0, 0x00, 0x00,  //@@@.................
    0xe0, 0x00, 0x00,  //%@@+................
    0x70, 0x00, 0x00,  //+@@%................
    0x70, 0x00, 0x00,  //.@@@................
    0x78, 0x00, 0x00,  //.@@@%...............
    0x38, 0x00, 0x10,  //.+@@@+.............%
    0x3c, 0x00, 0x30,  //..%@@@+..........+@@
    0x1f, 0x81, 0xf0,  //...@@@@@%+....+%@@@@
    0x0f, 0xff, 0xf0,  //....%@@@@@@@@@@@@@@@
    0x03, 0xff, 0xe0,  //.....+@@@@@@@@@@@@%.
    0x00, 0xff, 0x00,  //.......+%@@@@@@%+...
    0x00, 0x18, 0x00,  //...........@@+......
    0x00, 0x0c, 0x00,  //...........+@@......
    0x00, 0x0e, 0x00,  //............@@%.....
    0x00, 0x0e, 0x00,  //............@@@.....
    0x00, 0x8e, 0x00,  //........%..+@@@.....
    0x00, 0xfe, 0x00,  //........@@@@@@%.....
    0x00, 0xf8, 0x00,  //........%@@@@+......
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................


    /*Unicode: U+00c8 (È) , Width: 16 */
    0x0e, 0x00,  //....%@@+........
    0x07, 0x00,  //.....%@@+.......
    0x03, 0x80,  //......%@@.......
    0x01, 0xc0,  //.......%@@......
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00c9 (É) , Width: 16 */
    0x00, 0x70,  //.........@@@....
    0x00, 0xe0,  //........@@@.....
    0x01, 0xc0,  //.......%@@......
    0x03, 0x80,  //......%@@.......
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00ca (Ê) , Width: 16 */
    0x03, 0xc0,  //......@@@@......
    0x07, 0xe0,  //.....@@@@@@.....
    0x0e, 0x70,  //....%@%..%@%....
    0x1c, 0x38,  //...%@%....%@%...
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00cb (Ë) , Width: 16 */
    0x00, 0x00,  //................
    0x0e, 0x38,  //....@@@...@@@...
    0x0e, 0x38,  //....@@@...@@@...
    0x0e, 0x38,  //....@@@...@@@...
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00cc (Ì) , Width: 7 */
    0xe0,  //%@@+...
    0x70,  //.%@@+..
    0x38,  //..%@@..
    0x1c,  //...%@@.
    0x00,  //.......
    0x00,  //.......
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+00cd (Í) , Width: 7 */
    0x1c,  //...@@@.
    0x38,  //..@@@..
    0x70,  //.%@@...
    0xe0,  //%@@....
    0x00,  //.......
    0x00,  //.......
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+00ce (Î) , Width: 10 */
    0x3e, 0x00,  //..%@@@%...
    0x7f, 0x00,  //.%@@%@@%..
    0xe3, 0x80,  //%@@...@@%.
    0xc1, 0xc0,  //@@.....@@%
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00cf (Ï) , Width: 9 */
    0x00, 0x00,  //.........
    0xe3, 0x80,  //@@@...@@@
    0xe3, 0x80,  //@@@...@@@
    0xe3, 0x80,  //@@@...@@@
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+00d0 (Ð) , Width: 24 */
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x1f, 0xfe, 0x00,  //...@@@@@@@@@@%%+........
    0x1f, 0xff, 0xc0,  //...@@@@@@@@@@@@@@%+.....
    0x1f, 0xff, 0xf0,  //...@@@@@@@@@@@@@@@@%....
    0x1c, 0x01, 0xf8,  //...@@@........+%@@@@@...
    0x1c, 0x00, 0x7c,  //...@@@...........%@@@@..
    0x1c, 0x00, 0x1c,  //...@@@............+@@@+.
    0x1c, 0x00, 0x1e,  //...@@@.............%@@@.
    0x1c, 0x00, 0x0e,  //...@@@..............@@@+
    0x1c, 0x00, 0x0f,  //...@@@..............%@@%
    0x1c, 0x00, 0x07,  //...@@@..............+@@@
    0x1c, 0x00, 0x07,  //...@@@...............@@@
    0xff, 0xf0, 0x07,  //@@@@@@@@@@@@.........@@@
    0xff, 0xf0, 0x07,  //@@@@@@@@@@@@.........@@@
    0xff, 0xf0, 0x07,  //@@@@@@@@@@@@.........@@@
    0x1c, 0x00, 0x07,  //...@@@...............@@@
    0x1c, 0x00, 0x07,  //...@@@..............+@@%
    0x1c, 0x00, 0x0f,  //...@@@..............%@@%
    0x1c, 0x00, 0x0e,  //...@@@..............@@@+
    0x1c, 0x00, 0x1e,  //...@@@.............%@@@.
    0x1c, 0x00, 0x1c,  //...@@@............+@@@+.
    0x1c, 0x00, 0x7c,  //...@@@...........%@@@@..
    0x1c, 0x01, 0xf8,  //...@@@........+%@@@@@...
    0x1f, 0xff, 0xf0,  //...@@@@@@@@@@@@@@@@%....
    0x1f, 0xff, 0xc0,  //...@@@@@@@@@@@@@@%+.....
    0x1f, 0xfe, 0x00,  //...@@@@@@@@@@%%+........
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................


    /*Unicode: U+00d1 (Ñ) , Width: 19 */
    0x03, 0x86, 0x00,  //.....+@@%....@@....
    0x07, 0xe6, 0x00,  //....+@@@@@%.+@%....
    0x0c, 0xfc, 0x00,  //....@@+.%@@@@@+....
    0x0c, 0x38, 0x00,  //....@@....%@@+.....
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xf8, 0x00, 0xe0,  //@@@@%...........@@@
    0xf8, 0x00, 0xe0,  //@@@@@...........@@@
    0xfc, 0x00, 0xe0,  //@@@@@%..........@@@
    0xfc, 0x00, 0xe0,  //@@@@@@..........@@@
    0xfe, 0x00, 0xe0,  //@@@%@@@.........@@@
    0xee, 0x00, 0xe0,  //@@@.@@@+........@@@
    0xef, 0x00, 0xe0,  //@@@.+@@@........@@@
    0xe7, 0x00, 0xe0,  //@@@..@@@+.......@@@
    0xe3, 0x80, 0xe0,  //@@@..+@@@.......@@@
    0xe3, 0xc0, 0xe0,  //@@@...@@@%......@@@
    0xe1, 0xc0, 0xe0,  //@@@...+@@@......@@@
    0xe1, 0xe0, 0xe0,  //@@@....%@@%.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xf0, 0xe0,  //@@@.....%@@%....@@@
    0xe0, 0x70, 0xe0,  //@@@......@@@+...@@@
    0xe0, 0x78, 0xe0,  //@@@......%@@@...@@@
    0xe0, 0x38, 0xe0,  //@@@.......@@@+..@@@
    0xe0, 0x1c, 0xe0,  //@@@.......+@@@..@@@
    0xe0, 0x1c, 0xe0,  //@@@........@@@+.@@@
    0xe0, 0x0e, 0xe0,  //@@@........+@@@.@@@
    0xe0, 0x0f, 0xe0,  //@@@.........@@@%@@@
    0xe0, 0x07, 0xe0,  //@@@.........+@@@@@@
    0xe0, 0x07, 0xe0,  //@@@..........%@@@@@
    0xe0, 0x03, 0xe0,  //@@@...........@@@@@
    0xe0, 0x03, 0xe0,  //@@@...........%@@@@
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00d2 (Ò) , Width: 23 */
    0x01, 0xc0, 0x00,  //.......%@@+............
    0x00, 0xe0, 0x00,  //........%@@+...........
    0x00, 0x70, 0x00,  //.........%@@...........
    0x00, 0x38, 0x00,  //..........%@@..........
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0xfe, 0x00,  //.......+%@@@@@%+.......
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@+.....
    0x0f, 0xff, 0xe0,  //....%@@@@@@@@@@@@@@....
    0x1f, 0x01, 0xf0,  //...@@@@@+.....+@@@@@...
    0x3e, 0x00, 0xf8,  //..%@@@%.........+@@@%..
    0x38, 0x00, 0x38,  //.+@@@+...........+@@@+.
    0x78, 0x00, 0x3c,  //.@@@%.............%@@@.
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x70, 0x00, 0x1c,  //+@@%...............%@@+
    0xe0, 0x00, 0x0e,  //%@@+...............+@@%
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //%@@+...............+@@%
    0x70, 0x00, 0x1c,  //+@@%...............%@@+
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x78, 0x00, 0x3c,  //.@@@%.............%@@@.
    0x38, 0x00, 0x38,  //.+@@@+...........+@@@+.
    0x3e, 0x00, 0x78,  //..%@@@+.........+@@@%..
    0x1f, 0x01, 0xf0,  //...@@@@@+.....+@@@@@...
    0x0f, 0xff, 0xe0,  //....@@@@@@@@@@@@@@@....
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@+.....
    0x00, 0xfe, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d3 (Ó) , Width: 23 */
    0x00, 0x0e, 0x00,  //............@@@........
    0x00, 0x1c, 0x00,  //...........@@@.........
    0x00, 0x38, 0x00,  //..........%@@..........
    0x00, 0x70, 0x00,  //.........%@@...........
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0xfe, 0x00,  //.......+%@@@@@%+.......
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@+.....
    0x0f, 0xff, 0xe0,  //....%@@@@@@@@@@@@@@....
    0x1f, 0x01, 0xf0,  //...@@@@@+.....+@@@@@...
    0x3e, 0x00, 0xf8,  //..%@@@%.........+@@@%..
    0x38, 0x00, 0x38,  //.+@@@+...........+@@@+.
    0x78, 0x00, 0x3c,  //.@@@%.............%@@@.
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x70, 0x00, 0x1c,  //+@@%...............%@@+
    0xe0, 0x00, 0x0e,  //%@@+...............+@@%
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //%@@+...............+@@%
    0x70, 0x00, 0x1c,  //+@@%...............%@@+
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x78, 0x00, 0x3c,  //.@@@%.............%@@@.
    0x38, 0x00, 0x38,  //.+@@@+...........+@@@+.
    0x3e, 0x00, 0x78,  //..%@@@+.........+@@@%..
    0x1f, 0x01, 0xf0,  //...@@@@@+.....+@@@@@...
    0x0f, 0xff, 0xe0,  //....@@@@@@@@@@@@@@@....
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@+.....
    0x00, 0xfe, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d4 (Ô) , Width: 23 */
    0x00, 0x38, 0x00,  //.........+@@@+.........
    0x00, 0x7c, 0x00,  //.........@@%@@.........
    0x00, 0xc6, 0x00,  //........@@+.+@@........
    0x01, 0xc7, 0x00,  //.......%@+...+@%.......
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0xfe, 0x00,  //.......+%@@@@@%+.......
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@+.....
    0x0f, 0xff, 0xe0,  //....%@@@@@@@@@@@@@@....
    0x1f, 0x01, 0xf0,  //...@@@@@+.....+@@@@@...
    0x3e, 0x00, 0xf8,  //..%@@@%.........+@@@%..
    0x38, 0x00, 0x38,  //.+@@@+...........+@@@+.
    0x78, 0x00, 0x3c,  //.@@@%.............%@@@.
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x70, 0x00, 0x1c,  //+@@%...............%@@+
    0xe0, 0x00, 0x0e,  //%@@+...............+@@%
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //%@@+...............+@@%
    0x70, 0x00, 0x1c,  //+@@%...............%@@+
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x78, 0x00, 0x3c,  //.@@@%.............%@@@.
    0x38, 0x00, 0x38,  //.+@@@+...........+@@@+.
    0x3e, 0x00, 0x78,  //..%@@@+.........+@@@%..
    0x1f, 0x01, 0xf0,  //...@@@@@+.....+@@@@@...
    0x0f, 0xff, 0xe0,  //....@@@@@@@@@@@@@@@....
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@+.....
    0x00, 0xfe, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d5 (Õ) , Width: 23 */
    0x00, 0xe1, 0x80,  //.......+@@%....@@......
    0x01, 0xf9, 0x80,  //......+@@@@@%.+@%......
    0x03, 0x3f, 0x00,  //......@@+.%@@@@@+......
    0x03, 0x0e, 0x00,  //......@@....%@@+.......
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0xfe, 0x00,  //.......+%@@@@@%+.......
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@+.....
    0x0f, 0xff, 0xe0,  //....%@@@@@@@@@@@@@@....
    0x1f, 0x01, 0xf0,  //...@@@@@+.....+@@@@@...
    0x3e, 0x00, 0xf8,  //..%@@@%.........+@@@%..
    0x38, 0x00, 0x38,  //.+@@@+...........+@@@+.
    0x78, 0x00, 0x3c,  //.@@@%.............%@@@.
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x70, 0x00, 0x1c,  //+@@%...............%@@+
    0xe0, 0x00, 0x0e,  //%@@+...............+@@%
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //%@@+...............+@@%
    0x70, 0x00, 0x1c,  //+@@%...............%@@+
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x78, 0x00, 0x3c,  //.@@@%.............%@@@.
    0x38, 0x00, 0x38,  //.+@@@+...........+@@@+.
    0x3e, 0x00, 0x78,  //..%@@@+.........+@@@%..
    0x1f, 0x01, 0xf0,  //...@@@@@+.....+@@@@@...
    0x0f, 0xff, 0xe0,  //....@@@@@@@@@@@@@@@....
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@+.....
    0x00, 0xfe, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d6 (Ö) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x01, 0xc7, 0x00,  //.......@@@...@@@.......
    0x01, 0xc7, 0x00,  //.......@@@...@@@.......
    0x01, 0xc7, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0xfe, 0x00,  //.......+%@@@@@%+.......
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@+.....
    0x0f, 0xff, 0xe0,  //....%@@@@@@@@@@@@@@....
    0x1f, 0x01, 0xf0,  //...@@@@@+.....+@@@@@...
    0x3e, 0x00, 0xf8,  //..%@@@%.........+@@@%..
    0x38, 0x00, 0x38,  //.+@@@+...........+@@@+.
    0x78, 0x00, 0x3c,  //.@@@%.............%@@@.
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x70, 0x00, 0x1c,  //+@@%...............%@@+
    0xe0, 0x00, 0x0e,  //%@@+...............+@@%
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //%@@+...............+@@%
    0x70, 0x00, 0x1c,  //+@@%...............%@@+
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x78, 0x00, 0x3c,  //.@@@%.............%@@@.
    0x38, 0x00, 0x38,  //.+@@@+...........+@@@+.
    0x3e, 0x00, 0x78,  //..%@@@+.........+@@@%..
    0x1f, 0x01, 0xf0,  //...@@@@@+.....+@@@@@...
    0x0f, 0xff, 0xe0,  //....@@@@@@@@@@@@@@@....
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@+.....
    0x00, 0xfe, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d7 (×) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x20, 0x00, 0x80,  //.+%.............%+.
    0x70, 0x01, 0xc0,  //+@@%...........%@@+
    0x78, 0x03, 0xc0,  //+@@@%.........%@@@+
    0x3c, 0x07, 0x80,  //.+@@@%.......%@@@+.
    0x1e, 0x0f, 0x00,  //..+@@@%.....%@@@+..
    0x0f, 0x1e, 0x00,  //...+@@@%...%@@@+...
    0x0f, 0xbc, 0x00,  //....+@@@%.%@@@+....
    0x07, 0xf8, 0x00,  //.....+@@@@@@@+.....
    0x03, 0xf0, 0x00,  //......%@@@@@+......
    0x01, 0xf0, 0x00,  //.......%@@@%.......
    0x01, 0xf0, 0x00,  //......+@@@@@+......
    0x03, 0xf8, 0x00,  //.....+@@@@@@@+.....
    0x07, 0xbc, 0x00,  //....+@@@%.%@@@+....
    0x0f, 0x1e, 0x00,  //...+@@@%...%@@@+...
    0x1e, 0x0f, 0x00,  //..+@@@%.....%@@@+..
    0x3c, 0x07, 0x80,  //.+@@@%.......%@@@+.
    0x78, 0x03, 0xc0,  //+@@@%.........%@@@+
    0x70, 0x01, 0xc0,  //+@@%...........%@@+
    0x20, 0x00, 0x80,  //.+%.............%+.
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00d8 (Ø) , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //......................+..
    0x00, 0x7f, 0x03, 0x00,  //........+%@@@@@%+.....@@.
    0x01, 0xff, 0xe7, 0x00,  //......+@@@@@@@@@@@%..@@@.
    0x07, 0xff, 0xfe, 0x00,  //.....%@@@@@@@@@@@@@@%@@..
    0x0f, 0x80, 0xfc, 0x00,  //....@@@@@+.....+@@@@@@+..
    0x1f, 0x00, 0x7c, 0x00,  //...%@@@%.........%@@@@...
    0x1c, 0x00, 0x3c, 0x00,  //..+@@@+..........+@@@@+..
    0x3c, 0x00, 0x7e, 0x00,  //..@@@%..........+@@@@@@..
    0x38, 0x00, 0xee, 0x00,  //..@@@..........+@@@.@@@..
    0x78, 0x01, 0xcf, 0x00,  //.+@@%..........@@@..%@@%.
    0x70, 0x03, 0x87, 0x00,  //.%@@+.........@@@...+@@%.
    0x70, 0x07, 0x07, 0x00,  //.@@@.........@@@.....@@@.
    0x70, 0x0e, 0x07, 0x00,  //.@@@........@@@......@@@.
    0x70, 0x1c, 0x07, 0x00,  //.@@@.......@@@.......@@@.
    0x70, 0x38, 0x07, 0x00,  //.@@@......@@@........@@@.
    0x70, 0x70, 0x07, 0x00,  //.@@@.....@@@.........@@@.
    0x70, 0xe0, 0x07, 0x00,  //.%@@+...@@@.........+@@%.
    0x79, 0xc0, 0x0f, 0x00,  //.%@@%..@@@..........%@@+.
    0x3b, 0x80, 0x0e, 0x00,  //.+@@@.@@@+..........@@@..
    0x3f, 0x00, 0x1e, 0x00,  //..@@@@@@+..........%@@@..
    0x1e, 0x00, 0x1c, 0x00,  //..+@@@@+..........+@@@+..
    0x1f, 0x00, 0x3c, 0x00,  //...@@@@%.........+@@@%...
    0x1f, 0x80, 0xf8, 0x00,  //..+@@@@@@+.....+@@@@@....
    0x3f, 0xff, 0xf0, 0x00,  //..@@%@@@@@@@@@@@@@@%.....
    0x73, 0xff, 0xc0, 0x00,  //.%@@..%@@@@@@@@@@@+......
    0x60, 0x7f, 0x00, 0x00,  //.@@.....+%@@@@@%+........
    0x00, 0x00, 0x00, 0x00,  //..+......................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+00d9 (Ù) , Width: 19 */
    0x07, 0x00, 0x00,  //.....%@@+..........
    0x03, 0x80, 0x00,  //......%@@+.........
    0x01, 0xc0, 0x00,  //.......%@@.........
    0x00, 0xe0, 0x00,  //........%@@........
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@+...........+@@@
    0xf0, 0x01, 0xe0,  //%@@%...........%@@%
    0x70, 0x01, 0xc0,  //+@@@...........@@@+
    0x78, 0x03, 0xc0,  //.@@@%.........%@@@.
    0x3c, 0x07, 0x80,  //.+@@@@+.....+@@@@+.
    0x3f, 0xff, 0x80,  //..%@@@@@@@@@@@@@%..
    0x0f, 0xfe, 0x00,  //...+@@@@@@@@@@@+...
    0x03, 0xf8, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00da (Ú) , Width: 19 */
    0x00, 0x38, 0x00,  //..........@@@......
    0x00, 0x70, 0x00,  //.........@@@.......
    0x00, 0xe0, 0x00,  //........%@@........
    0x01, 0xc0, 0x00,  //.......%@@.........
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@+...........+@@@
    0xf0, 0x01, 0xe0,  //%@@%...........%@@%
    0x70, 0x01, 0xc0,  //+@@@...........@@@+
    0x78, 0x03, 0xc0,  //.@@@%.........%@@@.
    0x3c, 0x07, 0x80,  //.+@@@@+.....+@@@@+.
    0x3f, 0xff, 0x80,  //..%@@@@@@@@@@@@@%..
    0x0f, 0xfe, 0x00,  //...+@@@@@@@@@@@+...
    0x03, 0xf8, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00db (Û) , Width: 19 */
    0x00, 0xe0, 0x00,  //.......+@@@+.......
    0x01, 0xf0, 0x00,  //.......@@%@@.......
    0x03, 0x18, 0x00,  //......@@+.+@@......
    0x07, 0x1c, 0x00,  //.....%@+...+@%.....
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@+...........+@@@
    0xf0, 0x01, 0xe0,  //%@@%...........%@@%
    0x70, 0x01, 0xc0,  //+@@@...........@@@+
    0x78, 0x03, 0xc0,  //.@@@%.........%@@@.
    0x3c, 0x07, 0x80,  //.+@@@@+.....+@@@@+.
    0x3f, 0xff, 0x80,  //..%@@@@@@@@@@@@@%..
    0x0f, 0xfe, 0x00,  //...+@@@@@@@@@@@+...
    0x03, 0xf8, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00dc (Ü) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x07, 0x1c, 0x00,  //.....@@@...@@@.....
    0x07, 0x1c, 0x00,  //.....@@@...@@@.....
    0x07, 0x1c, 0x00,  //.....@@@...@@@.....
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@+...........+@@@
    0xf0, 0x01, 0xe0,  //%@@%...........%@@%
    0x70, 0x01, 0xc0,  //+@@@...........@@@+
    0x78, 0x03, 0xc0,  //.@@@%.........%@@@.
    0x3c, 0x07, 0x80,  //.+@@@@+.....+@@@@+.
    0x3f, 0xff, 0x80,  //..%@@@@@@@@@@@@@%..
    0x0f, 0xfe, 0x00,  //...+@@@@@@@@@@@+...
    0x03, 0xf8, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00dd (Ý) , Width: 21 */
    0x00, 0x1c, 0x00,  //...........@@@.......
    0x00, 0x38, 0x00,  //..........@@@........
    0x00, 0x70, 0x00,  //.........%@@.........
    0x00, 0xe0, 0x00,  //........%@@..........
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0xf0, 0x00, 0x78,  //%@@@.............@@@%
    0x78, 0x00, 0xf0,  //.@@@%...........%@@@.
    0x38, 0x00, 0xe0,  //.+@@@+.........+@@@+.
    0x3c, 0x01, 0xe0,  //..%@@@.........@@@%..
    0x1e, 0x03, 0xc0,  //...@@@%.......%@@@...
    0x0e, 0x03, 0x80,  //....@@@+.....+@@@....
    0x0f, 0x07, 0x80,  //....%@@@.....@@@%....
    0x07, 0x8f, 0x00,  //.....@@@@...@@@@.....
    0x03, 0x8e, 0x00,  //......@@@+.+@@@......
    0x01, 0xdc, 0x00,  //......+@@@+@@@+......
    0x01, 0xfc, 0x00,  //.......@@@@@@@.......
    0x00, 0xf8, 0x00,  //........@@@@@........
    0x00, 0x70, 0x00,  //........+@@@+........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+00de (Þ) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xff, 0xe0,  //@@@@@@@@@@%+....
    0xff, 0xf8,  //@@@@@@@@@@@@@+..
    0xff, 0xfc,  //@@@@@@@@@@@@@@+.
    0xe0, 0x3e,  //@@@.......%@@@@.
    0xe0, 0x0f,  //@@@.........@@@%
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x0f,  //@@@.........@@@%
    0xe0, 0x3e,  //@@@.......%@@@@.
    0xff, 0xfc,  //@@@@@@@@@@@@@@+.
    0xff, 0xf8,  //@@@@@@@@@@@@@+..
    0xff, 0xe0,  //@@@@@@@@@@%+....
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00df (ß) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x0f, 0xe0, 0x00,  //....%@@@@@%......
    0x1f, 0xf8, 0x00,  //..+@@@@@@@@@%....
    0x7f, 0xf8, 0x00,  //.%@@@@@@@@@@@+...
    0x78, 0x3c, 0x00,  //.@@@@+...+@@@@...
    0xf0, 0x1e, 0x00,  //%@@@.......%@@+..
    0xe0, 0x0e, 0x00,  //@@@+........@@%..
    0xe0, 0x1e, 0x00,  //@@@........%@@@..
    0xe0, 0x7e, 0x00,  //@@@......%@@@@%..
    0xe0, 0xf0, 0x00,  //@@@.....@@@%.....
    0xe1, 0xe0, 0x00,  //@@@....%@@%......
    0xe1, 0xc0, 0x00,  //@@@....@@@.......
    0xe1, 0xc0, 0x00,  //@@@....@@@.......
    0xe1, 0xc0, 0x00,  //@@@....@@@+......
    0xe0, 0xe0, 0x00,  //@@@....+@@@+.....
    0xe0, 0xf8, 0x00,  //@@@.....%@@@@....
    0xe0, 0x7c, 0x00,  //@@@......%@@@@+..
    0xe0, 0x1f, 0x00,  //@@@........@@@@+.
    0xe0, 0x0f, 0x00,  //@@@.........+@@@+
    0xe0, 0x03, 0x80,  //@@@..........+@@%
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@..........+@@@
    0xe6, 0x0f, 0x80,  //@@@..@++....%@@@%
    0xe7, 0xff, 0x00,  //@@@..@@@@@@@@@@@.
    0xe7, 0xfe, 0x00,  //@@@..@@@@@@@@@@..
    0xe1, 0xf8, 0x00,  //@@@...+%@@@@%+...
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00e0 (à) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x3c, 0x00,  //..%@@%..........
    0x1c, 0x00,  //...%@@+.........
    0x0e, 0x00,  //....%@@+........
    0x07, 0x00,  //.....@@@........
    0x03, 0x80,  //......@@@.......
    0x01, 0xc0,  //.......@@%......
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x0f, 0xe0,  //....%%@@@@%+....
    0x3f, 0xf8,  //..%@@@@@@@@@@...
    0x7f, 0xfc,  //.@@@@@@@@@@@@@..
    0x70, 0x3e,  //.@@%+.....+@@@@.
    0x40, 0x0e,  //.%..........@@@+
    0x00, 0x07,  //............+@@%
    0x00, 0x07,  //.............@@@
    0x07, 0xff,  //....+%@@@@@@@@@@
    0x3f, 0xff,  //..%@@@@@@@@@@@@@
    0x7f, 0xff,  //.@@@@@@@@@@@@@@@
    0x78, 0x07,  //+@@@%+.......@@@
    0xf0, 0x07,  //@@@%.........@@@
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x0f,  //@@@.........@@@@
    0xe0, 0x1f,  //@@@+.......%@@@@
    0xf8, 0x3f,  //%@@@%....+@@@@@@
    0x7f, 0xff,  //.@@@@@@@@@@@%@@@
    0x3f, 0xf7,  //..@@@@@@@@@+.@@@
    0x0f, 0xc7,  //...+@@@@@%...@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00e1 (á) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x78,  //.........%@@%...
    0x00, 0x70,  //........+@@%....
    0x00, 0xe0,  //.......+@@%.....
    0x01, 0xc0,  //.......@@@......
    0x03, 0x80,  //......@@@.......
    0x07, 0x00,  //.....%@@........
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x0f, 0xe0,  //....%%@@@@%+....
    0x3f, 0xf8,  //..%@@@@@@@@@@...
    0x7f, 0xfc,  //.@@@@@@@@@@@@@..
    0x70, 0x3e,  //.@@%+.....+@@@@.
    0x40, 0x0e,  //.%..........@@@+
    0x00, 0x07,  //............+@@%
    0x00, 0x07,  //.............@@@
    0x07, 0xff,  //....+%@@@@@@@@@@
    0x3f, 0xff,  //..%@@@@@@@@@@@@@
    0x7f, 0xff,  //.@@@@@@@@@@@@@@@
    0x78, 0x07,  //+@@@%+.......@@@
    0xf0, 0x07,  //@@@%.........@@@
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x0f,  //@@@.........@@@@
    0xe0, 0x1f,  //@@@+.......%@@@@
    0xf8, 0x3f,  //%@@@%....+@@@@@@
    0x7f, 0xff,  //.@@@@@@@@@@@%@@@
    0x3f, 0xf7,  //..@@@@@@@@@+.@@@
    0x0f, 0xc7,  //...+@@@@@%...@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00e2 (â) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x01, 0x80,  //......+@@+......
    0x03, 0xc0,  //......@@@@......
    0x07, 0xe0,  //.....%@%%@%.....
    0x06, 0x60,  //....+@@..@@+....
    0x0c, 0x30,  //....@@+..+@@....
    0x1c, 0x38,  //...%@%....%@%...
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x0f, 0xe0,  //....%%@@@@%+....
    0x3f, 0xf8,  //..%@@@@@@@@@@...
    0x7f, 0xfc,  //.@@@@@@@@@@@@@..
    0x70, 0x3e,  //.@@%+.....+@@@@.
    0x40, 0x0e,  //.%..........@@@+
    0x00, 0x07,  //............+@@%
    0x00, 0x07,  //.............@@@
    0x07, 0xff,  //....+%@@@@@@@@@@
    0x3f, 0xff,  //..%@@@@@@@@@@@@@
    0x7f, 0xff,  //.@@@@@@@@@@@@@@@
    0x78, 0x07,  //+@@@%+.......@@@
    0xf0, 0x07,  //@@@%.........@@@
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x0f,  //@@@.........@@@@
    0xe0, 0x1f,  //@@@+.......%@@@@
    0xf8, 0x3f,  //%@@@%....+@@@@@@
    0x7f, 0xff,  //.@@@@@@@@@@@%@@@
    0x3f, 0xf7,  //..@@@@@@@@@+.@@@
    0x0f, 0xc7,  //...+@@@@@%...@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00e3 (ã) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x06, 0x18,  //....+@@+...@@...
    0x0f, 0x98,  //...+@@@@%..@@...
    0x19, 0x98,  //...%@++@@++@%...
    0x19, 0xf0,  //...@@..%@@@@+...
    0x18, 0x60,  //...@@...+@@+....
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x0f, 0xe0,  //....%%@@@@%+....
    0x3f, 0xf8,  //..%@@@@@@@@@@...
    0x7f, 0xfc,  //.@@@@@@@@@@@@@..
    0x70, 0x3e,  //.@@%+.....+@@@@.
    0x40, 0x0e,  //.%..........@@@+
    0x00, 0x07,  //............+@@%
    0x00, 0x07,  //.............@@@
    0x07, 0xff,  //....+%@@@@@@@@@@
    0x3f, 0xff,  //..%@@@@@@@@@@@@@
    0x7f, 0xff,  //.@@@@@@@@@@@@@@@
    0x78, 0x07,  //+@@@%+.......@@@
    0xf0, 0x07,  //@@@%.........@@@
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x0f,  //@@@.........@@@@
    0xe0, 0x1f,  //@@@+.......%@@@@
    0xf8, 0x3f,  //%@@@%....+@@@@@@
    0x7f, 0xff,  //.@@@@@@@@@@@%@@@
    0x3f, 0xf7,  //..@@@@@@@@@+.@@@
    0x0f, 0xc7,  //...+@@@@@%...@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00e4 (ä) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x0e, 0x70,  //....@@@..@@@....
    0x0e, 0x70,  //....@@@..@@@....
    0x0e, 0x70,  //....@@@..@@@....
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x0f, 0xe0,  //....%%@@@@%+....
    0x3f, 0xf8,  //..%@@@@@@@@@@...
    0x7f, 0xfc,  //.@@@@@@@@@@@@@..
    0x70, 0x3e,  //.@@%+.....+@@@@.
    0x40, 0x0e,  //.%..........@@@+
    0x00, 0x07,  //............+@@%
    0x00, 0x07,  //.............@@@
    0x07, 0xff,  //....+%@@@@@@@@@@
    0x3f, 0xff,  //..%@@@@@@@@@@@@@
    0x7f, 0xff,  //.@@@@@@@@@@@@@@@
    0x78, 0x07,  //+@@@%+.......@@@
    0xf0, 0x07,  //@@@%.........@@@
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x0f,  //@@@.........@@@@
    0xe0, 0x1f,  //@@@+.......%@@@@
    0xf8, 0x3f,  //%@@@%....+@@@@@@
    0x7f, 0xff,  //.@@@@@@@@@@@%@@@
    0x3f, 0xf7,  //..@@@@@@@@@+.@@@
    0x0f, 0xc7,  //...+@@@@@%...@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00e5 (å) , Width: 16 */
    0x00, 0x00,  //................
    0x03, 0xe0,  //......%@@@%.....
    0x07, 0xf0,  //.....@@@@@@@....
    0x0e, 0x38,  //....%@@..+@@%...
    0x0c, 0x18,  //....@@.....@@...
    0x0c, 0x18,  //....@@.....@@...
    0x0c, 0x18,  //....@@.....@@...
    0x0e, 0x38,  //....%@@...@@%...
    0x07, 0xf0,  //.....@@@@@@@....
    0x03, 0xe0,  //......%@@@%.....
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x0f, 0xe0,  //....%%@@@@%+....
    0x3f, 0xf8,  //..%@@@@@@@@@@...
    0x7f, 0xfc,  //.@@@@@@@@@@@@@..
    0x70, 0x3e,  //.@@%+.....+@@@@.
    0x40, 0x0e,  //.%..........@@@+
    0x00, 0x07,  //............+@@%
    0x00, 0x07,  //.............@@@
    0x07, 0xff,  //....+%@@@@@@@@@@
    0x3f, 0xff,  //..%@@@@@@@@@@@@@
    0x7f, 0xff,  //.@@@@@@@@@@@@@@@
    0x78, 0x07,  //+@@@%+.......@@@
    0xf0, 0x07,  //@@@%.........@@@
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x0f,  //@@@.........@@@@
    0xe0, 0x1f,  //@@@+.......%@@@@
    0xf8, 0x3f,  //%@@@%....+@@@@@@
    0x7f, 0xff,  //.@@@@@@@@@@@%@@@
    0x3f, 0xf7,  //..@@@@@@@@@+.@@@
    0x0f, 0xc7,  //...+@@@@@%...@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00e6 (æ) , Width: 30 */
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x07, 0xe0, 0x1f, 0x80,  //....+%@@@@%+......+%@@@@%.....
    0x3f, 0xf8, 0x7f, 0xe0,  //..%@@@@@@@@@@+..+@@@@@@@@@%...
    0x7f, 0xfd, 0xff, 0xf0,  //.@@@@@@@@@@@@@+%@@@@@@@@@@@@..
    0x70, 0x3f, 0xe0, 0x78,  //.@@%+.....+@@@@@@@%+....+@@@%.
    0x40, 0x0f, 0x80, 0x38,  //.%..........@@@@@+........@@@.
    0x00, 0x07, 0x80, 0x1c,  //............+@@@%.........+@@%
    0x00, 0x07, 0x00, 0x1c,  //.............@@@...........@@@
    0x07, 0xff, 0xff, 0xfc,  //....+%@@@@@@@@@@@@@@@@@@@@@@@@
    0x3f, 0xff, 0xff, 0xfc,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0xff, 0xff, 0xfc,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x78, 0x07, 0x00, 0x00,  //+@@@%+.......@@@..............
    0xf0, 0x07, 0x00, 0x00,  //@@@%.........@@@..............
    0xe0, 0x07, 0x80, 0x00,  //@@@.........+@@@%.............
    0xe0, 0x0f, 0x80, 0x00,  //@@@.........@@@@@.............
    0xe0, 0x1f, 0xc0, 0x08,  //@@@+.......%@@@@@@..........%.
    0xf8, 0x3d, 0xf0, 0x38,  //%@@@%....+@@@@+@@@@%.....+@@@.
    0x7f, 0xf9, 0xff, 0xf8,  //.@@@@@@@@@@@@..%@@@@@@@@@@@@@.
    0x3f, 0xf0, 0x7f, 0xf0,  //..@@@@@@@@@%....+@@@@@@@@@@@+.
    0x0f, 0xc0, 0x1f, 0xc0,  //...+%@@@@%........+%@@@@%%....
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................


    /*Unicode: U+00e7 (ç) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x03, 0xf8,  //.....+%@@@@@%+.
    0x0f, 0xfe,  //....@@@@@@@@@@@
    0x1f, 0xfe,  //..+@@@@@@@@@@@@
    0x3e, 0x06,  //..@@@@%.....+%@
    0x78, 0x00,  //.@@@@..........
    0x70, 0x00,  //+@@@...........
    0xf0, 0x00,  //%@@%...........
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xf0, 0x00,  //%@@%...........
    0x70, 0x00,  //+@@@...........
    0x78, 0x00,  //.@@@@..........
    0x3e, 0x06,  //..@@@@%.....+%@
    0x1f, 0xfe,  //..+@@@@@@@@@@@@
    0x0f, 0xfe,  //....@@@@@@@@@@@
    0x03, 0xf8,  //.....+%@@@@@%+.
    0x00, 0xc0,  //........@@+....
    0x00, 0x60,  //........+@@....
    0x00, 0x70,  //.........@@%...
    0x00, 0x70,  //.........@@@...
    0x04, 0x70,  //.....%..+@@@...
    0x07, 0xf0,  //.....@@@@@@%...
    0x07, 0xc0,  //.....%@@@@+....
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+00e8 (è) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x1e, 0x00, 0x00,  //...%@@%..........
    0x0e, 0x00, 0x00,  //....%@@+.........
    0x07, 0x00, 0x00,  //.....%@@+........
    0x03, 0x80, 0x00,  //......@@@........
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x00, 0xe0, 0x00,  //........@@%......
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x03, 0xf0, 0x00,  //.....+%@@@@%+....
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@...
    0x1f, 0xfe, 0x00,  //..+@@@@@@@@@@@@..
    0x3c, 0x0f, 0x00,  //..@@@%+....+@@@@.
    0x70, 0x07, 0x00,  //.@@@+........@@@+
    0x70, 0x03, 0x80,  //+@@%.........+@@%
    0xe0, 0x03, 0x80,  //%@@...........@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xf0, 0x00, 0x00,  //%@@%.............
    0x70, 0x00, 0x00,  //+@@@.............
    0x78, 0x01, 0x00,  //.@@@@..........%.
    0x3e, 0x07, 0x00,  //.+@@@@%.....+@@@.
    0x1f, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x0f, 0xfe, 0x00,  //...+@@@@@@@@@@@+.
    0x03, 0xf8, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00e9 (é) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x3c, 0x00,  //..........%@@%...
    0x00, 0x38, 0x00,  //.........+@@%....
    0x00, 0x70, 0x00,  //........+@@%.....
    0x00, 0xe0, 0x00,  //........@@@......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x03, 0x80, 0x00,  //......%@@........
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x03, 0xf0, 0x00,  //.....+%@@@@%+....
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@...
    0x1f, 0xfe, 0x00,  //..+@@@@@@@@@@@@..
    0x3c, 0x0f, 0x00,  //..@@@%+....+@@@@.
    0x70, 0x07, 0x00,  //.@@@+........@@@+
    0x70, 0x03, 0x80,  //+@@%.........+@@%
    0xe0, 0x03, 0x80,  //%@@...........@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xf0, 0x00, 0x00,  //%@@%.............
    0x70, 0x00, 0x00,  //+@@@.............
    0x78, 0x01, 0x00,  //.@@@@..........%.
    0x3e, 0x07, 0x00,  //.+@@@@%.....+@@@.
    0x1f, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x0f, 0xfe, 0x00,  //...+@@@@@@@@@@@+.
    0x03, 0xf8, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00ea (ê) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x03, 0xe0, 0x00,  //......%@@@@......
    0x03, 0x70, 0x00,  //.....+@@+@@%.....
    0x06, 0x30, 0x00,  //.....@@+.+@@.....
    0x0e, 0x38, 0x00,  //....@@%...%@@....
    0x1c, 0x1c, 0x00,  //...%@@.....%@%...
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x03, 0xf0, 0x00,  //.....+%@@@@%+....
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@...
    0x1f, 0xfe, 0x00,  //..+@@@@@@@@@@@@..
    0x3c, 0x0f, 0x00,  //..@@@%+....+@@@@.
    0x70, 0x07, 0x00,  //.@@@+........@@@+
    0x70, 0x03, 0x80,  //+@@%.........+@@%
    0xe0, 0x03, 0x80,  //%@@...........@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xf0, 0x00, 0x00,  //%@@%.............
    0x70, 0x00, 0x00,  //+@@@.............
    0x78, 0x01, 0x00,  //.@@@@..........%.
    0x3e, 0x07, 0x00,  //.+@@@@%.....+@@@.
    0x1f, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x0f, 0xfe, 0x00,  //...+@@@@@@@@@@@+.
    0x03, 0xf8, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00eb (ë) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x0e, 0x38, 0x00,  //....@@@...@@@....
    0x0e, 0x38, 0x00,  //....@@@...@@@....
    0x0e, 0x38, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x03, 0xf0, 0x00,  //.....+%@@@@%+....
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@...
    0x1f, 0xfe, 0x00,  //..+@@@@@@@@@@@@..
    0x3c, 0x0f, 0x00,  //..@@@%+....+@@@@.
    0x70, 0x07, 0x00,  //.@@@+........@@@+
    0x70, 0x03, 0x80,  //+@@%.........+@@%
    0xe0, 0x03, 0x80,  //%@@...........@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xf0, 0x00, 0x00,  //%@@%.............
    0x70, 0x00, 0x00,  //+@@@.............
    0x78, 0x01, 0x00,  //.@@@@..........%.
    0x3e, 0x07, 0x00,  //.+@@@@%.....+@@@.
    0x1f, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x0f, 0xfe, 0x00,  //...+@@@@@@@@@@@+.
    0x03, 0xf8, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00ec (ì) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0xe0,  //@@%....
    0xe0,  //%@@+...
    0x70,  //.%@@+..
    0x38,  //..@@@..
    0x1c,  //...@@@.
    0x0e,  //....@@%
    0x00,  //.......
    0x00,  //.......
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x1c,  //...@@@.
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+00ed (í) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x0f,  //....%@@%
    0x0e,  //...+@@%.
    0x1c,  //..+@@%..
    0x38,  //..@@@...
    0x70,  //.@@@....
    0xe0,  //%@@.....
    0x00,  //........
    0x00,  //........
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x70,  //.@@@....
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00ee (î) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x1c, 0x00,  //...@@@....
    0x3e, 0x00,  //..@@@@@...
    0x77, 0x00,  //.%@@+@@%..
    0x63, 0x00,  //.@@+.+@@..
    0xe3, 0x80,  //@@%...%@@.
    0xc1, 0xc0,  //@@.....@@%
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00ef (ï) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xe3, 0x80,  //@@@...@@@
    0xe3, 0x80,  //@@@...@@@
    0xe3, 0x80,  //@@@...@@@
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x1c, 0x00,  //...@@@...
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+00f0 (ð) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x0e, 0x00, 0x00,  //...+@@@+.........
    0x0f, 0x0e, 0x00,  //....%@@@+...%@@..
    0x07, 0xfe, 0x00,  //.....%@@@%@@@@%..
    0x03, 0xf0, 0x00,  //......@@@@@%+....
    0x0f, 0xe0, 0x00,  //...+@@@@@@@......
    0x3c, 0xf0, 0x00,  //.+@@@%++@@@%.....
    0x20, 0x78, 0x00,  //..%+....+@@@%....
    0x00, 0x38, 0x00,  //.........+@@@+...
    0x07, 0xfc, 0x00,  //.....%@@@@@@@@...
    0x1f, 0xfe, 0x00,  //...%@@@@@@@@@@@..
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@@+.
    0x3c, 0x0f, 0x00,  //.+@@@@+....+@@@@.
    0x78, 0x07, 0x00,  //.@@@%........@@@+
    0x70, 0x07, 0x80,  //+@@@.........%@@%
    0xe0, 0x03, 0x80,  //%@@+.........+@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //%@@+.........+@@%
    0x70, 0x07, 0x00,  //+@@@.........@@@+
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x3c, 0x1e, 0x00,  //.+@@@@+...+@@@@+.
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x0f, 0xf8, 0x00,  //...+@@@@@@@@@+...
    0x07, 0xe0, 0x00,  //.....+@@@@@+.....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f1 (ñ) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x07, 0x0c,  //....+@@%....@@..
    0x0f, 0x8c,  //....@@@@@...@@..
    0x1d, 0xdc,  //...%@%.@@@.%@%..
    0x18, 0xf8,  //...@@...@@@@@...
    0x18, 0x70,  //...@@....%@@+...
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xe3, 0xf0,  //@@@...%@@@@%+...
    0xe7, 0xfc,  //@@@.+@@@@@@@@%..
    0xff, 0xfe,  //@@@%@@@@@@@@@@%.
    0xfc, 0x1e,  //@@@@@%+...+@@@@.
    0xf0, 0x0f,  //@@@@+.......@@@%
    0xf0, 0x07,  //@@@%........+@@@
    0xe0, 0x07,  //@@@+.........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00f2 (ò) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x1e, 0x00, 0x00,  //...%@@%..........
    0x0e, 0x00, 0x00,  //....%@@+.........
    0x07, 0x00, 0x00,  //.....%@@+........
    0x03, 0x80, 0x00,  //......@@@........
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x00, 0xe0, 0x00,  //........@@%......
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x3c, 0x1e, 0x00,  //.+@@@@+...+@@@@+.
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x70, 0x07, 0x00,  //+@@@.........@@@+
    0xe0, 0x07, 0x80,  //%@@+.........+@@%
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //%@@+.........+@@%
    0x70, 0x07, 0x00,  //+@@@.........@@@+
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x3c, 0x1e, 0x00,  //.+@@@@+...+@@@@+.
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f3 (ó) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x3c, 0x00,  //..........%@@%...
    0x00, 0x38, 0x00,  //.........+@@%....
    0x00, 0x70, 0x00,  //........+@@%.....
    0x00, 0xe0, 0x00,  //........@@@......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x03, 0x80, 0x00,  //......%@@........
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x3c, 0x1e, 0x00,  //.+@@@@+...+@@@@+.
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x70, 0x07, 0x00,  //+@@@.........@@@+
    0xe0, 0x07, 0x80,  //%@@+.........+@@%
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //%@@+.........+@@%
    0x70, 0x07, 0x00,  //+@@@.........@@@+
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x3c, 0x1e, 0x00,  //.+@@@@+...+@@@@+.
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f4 (ô) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x07, 0x70, 0x00,  //.....%@@+@@%.....
    0x06, 0x30, 0x00,  //.....@@+.+@@.....
    0x0e, 0x38, 0x00,  //....@@%...%@@....
    0x1c, 0x1c, 0x00,  //...%@@.....@@%...
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x3c, 0x1e, 0x00,  //.+@@@@+...+@@@@+.
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x70, 0x07, 0x00,  //+@@@.........@@@+
    0xe0, 0x07, 0x80,  //%@@+.........+@@%
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //%@@+.........+@@%
    0x70, 0x07, 0x00,  //+@@@.........@@@+
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x3c, 0x1e, 0x00,  //.+@@@@+...+@@@@+.
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f5 (õ) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x07, 0x0c, 0x00,  //....+@@%....@@...
    0x0f, 0x8c, 0x00,  //....@@@@@...@@...
    0x1d, 0xdc, 0x00,  //...%@%.@@@.%@%...
    0x18, 0xf8, 0x00,  //...@@...@@@@@....
    0x18, 0x70, 0x00,  //...@@....%@@+....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x3c, 0x1e, 0x00,  //.+@@@@+...+@@@@+.
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x70, 0x07, 0x00,  //+@@@.........@@@+
    0xe0, 0x07, 0x80,  //%@@+.........+@@%
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //%@@+.........+@@%
    0x70, 0x07, 0x00,  //+@@@.........@@@+
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x3c, 0x1e, 0x00,  //.+@@@@+...+@@@@+.
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f6 (ö) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x0e, 0x38, 0x00,  //....@@@...@@@....
    0x0e, 0x38, 0x00,  //....@@@...@@@....
    0x0e, 0x38, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x3c, 0x1e, 0x00,  //.+@@@@+...+@@@@+.
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x70, 0x07, 0x00,  //+@@@.........@@@+
    0xe0, 0x07, 0x80,  //%@@+.........+@@%
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //%@@+.........+@@%
    0x70, 0x07, 0x00,  //+@@@.........@@@+
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x3c, 0x1e, 0x00,  //.+@@@@+...+@@@@+.
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f7 (÷) , Width: 22 */
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x78, 0x00,  //.........@@@@.........
    0x00, 0x78, 0x00,  //.........@@@@.........
    0x00, 0x78, 0x00,  //.........@@@@.........
    0x00, 0x78, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x78, 0x00,  //.........@@@@.........
    0x00, 0x78, 0x00,  //.........@@@@.........
    0x00, 0x78, 0x00,  //.........@@@@.........
    0x00, 0x78, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................


    /*Unicode: U+00f8 (ø) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x40,  //................+%.
    0x03, 0xf0, 0xc0,  //......+@@@@@+...@@+
    0x0f, 0xfd, 0xc0,  //....%@@@@@@@@@+%@@.
    0x1f, 0xff, 0x80,  //...%@@@@@@@@@@@@@..
    0x1e, 0x0f, 0x80,  //..+@@@@+...+@@@@%..
    0x3c, 0x07, 0x80,  //..@@@%.......@@@@..
    0x38, 0x0f, 0x80,  //.+@@@.......@@@@@+.
    0x78, 0x1d, 0xc0,  //.%@@%......@@%+@@%.
    0x70, 0x39, 0xc0,  //.@@@......@@%..@@@.
    0x70, 0x71, 0xc0,  //.@@@.....@@@...@@@.
    0x70, 0xe1, 0xc0,  //.@@@....@@@....@@@.
    0x71, 0xc1, 0xc0,  //.@@@...@@@.....@@@.
    0x73, 0x81, 0xc0,  //.@@@..%@@......@@@.
    0x77, 0x01, 0xc0,  //.%@@+%@@......+@@%.
    0x3e, 0x03, 0x80,  //.+@@@@@.......@@@+.
    0x3c, 0x07, 0x80,  //..@@@@.......%@@@..
    0x1e, 0x0f, 0x00,  //..+@@@@+...+@@@@+..
    0x3f, 0xff, 0x00,  //..@@@@@@@@@@@@@%...
    0x77, 0xfe, 0x00,  //.%@%+@@@@@@@@@%....
    0x63, 0xf8, 0x00,  //+@@...+@@@@@%......
    0x40, 0x00, 0x00,  //.@.................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00f9 (ù) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x3c, 0x00,  //..%@@%..........
    0x1c, 0x00,  //...%@@+.........
    0x0e, 0x00,  //....%@@+........
    0x07, 0x00,  //.....@@@........
    0x03, 0x80,  //......@@@.......
    0x01, 0xc0,  //.......@@%......
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x0f,  //@@@+........%@@@
    0xf0, 0x0f,  //%@@@.......+@@@@
    0x78, 0x3f,  //.@@@@+...+%@@@@@
    0x7f, 0xff,  //.%@@@@@@@@@@%@@@
    0x3f, 0xe7,  //..%@@@@@@@@+.@@@
    0x0f, 0xc7,  //...+%@@@@%...@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00fa (ú) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x78,  //.........%@@%...
    0x00, 0x70,  //........+@@%....
    0x00, 0xe0,  //.......+@@%.....
    0x01, 0xc0,  //.......@@@......
    0x03, 0x80,  //......@@@.......
    0x07, 0x00,  //.....%@@........
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x0f,  //@@@+........%@@@
    0xf0, 0x0f,  //%@@@.......+@@@@
    0x78, 0x3f,  //.@@@@+...+%@@@@@
    0x7f, 0xff,  //.%@@@@@@@@@@%@@@
    0x3f, 0xe7,  //..%@@@@@@@@+.@@@
    0x0f, 0xc7,  //...+%@@@@%...@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00fb (û) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x01, 0x80,  //......+@@+......
    0x03, 0xc0,  //......@@@@......
    0x07, 0xe0,  //.....%@%%@%.....
    0x06, 0x60,  //....+@@..@@+....
    0x0c, 0x30,  //....@@+..+@@....
    0x1c, 0x38,  //...%@%....%@%...
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x0f,  //@@@+........%@@@
    0xf0, 0x0f,  //%@@@.......+@@@@
    0x78, 0x3f,  //.@@@@+...+%@@@@@
    0x7f, 0xff,  //.%@@@@@@@@@@%@@@
    0x3f, 0xe7,  //..%@@@@@@@@+.@@@
    0x0f, 0xc7,  //...+%@@@@%...@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00fc (ü) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x0e, 0x70,  //....@@@..@@@....
    0x0e, 0x70,  //....@@@..@@@....
    0x0e, 0x70,  //....@@@..@@@....
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x0f,  //@@@+........%@@@
    0xf0, 0x0f,  //%@@@.......+@@@@
    0x78, 0x3f,  //.@@@@+...+%@@@@@
    0x7f, 0xff,  //.%@@@@@@@@@@%@@@
    0x3f, 0xe7,  //..%@@@@@@@@+.@@@
    0x0f, 0xc7,  //...+%@@@@%...@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00fd (ý) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x1e, 0x00,  //...........%@@%...
    0x00, 0x1c, 0x00,  //..........+@@%....
    0x00, 0x38, 0x00,  //.........+@@%.....
    0x00, 0x70, 0x00,  //.........@@@......
    0x00, 0xe0, 0x00,  //........@@@.......
    0x01, 0xc0, 0x00,  //.......%@@........
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0xe0, 0x01, 0xc0,  //@@@+..........+@@@
    0x70, 0x03, 0x80,  //+@@@..........@@@+
    0x70, 0x03, 0x80,  //.@@@+.........@@@.
    0x78, 0x07, 0x80,  //.%@@%........%@@%.
    0x38, 0x07, 0x00,  //..@@@........@@@..
    0x3c, 0x07, 0x00,  //..%@@%......+@@@..
    0x1c, 0x0e, 0x00,  //..+@@@......@@@+..
    0x1c, 0x0e, 0x00,  //...@@@+.....@@@...
    0x0e, 0x1e, 0x00,  //...+@@@....%@@%...
    0x0e, 0x1c, 0x00,  //....@@@....@@@+...
    0x0f, 0x1c, 0x00,  //....%@@%..+@@@....
    0x07, 0x38, 0x00,  //.....@@@..%@@+....
    0x07, 0x38, 0x00,  //.....@@@+.@@@.....
    0x03, 0xf8, 0x00,  //.....+@@@%@@%.....
    0x03, 0xf0, 0x00,  //......@@@@@@+.....
    0x03, 0xf0, 0x00,  //......%@@@@@......
    0x01, 0xf0, 0x00,  //.......@@@@+......
    0x01, 0xe0, 0x00,  //.......%@@@.......
    0x01, 0xe0, 0x00,  //.......%@@%.......
    0x01, 0xc0, 0x00,  //.......@@@+.......
    0x01, 0xc0, 0x00,  //......+@@@........
    0x03, 0xc0, 0x00,  //......%@@%........
    0x07, 0x80, 0x00,  //.....%@@@.........
    0x3f, 0x80, 0x00,  //..@@@@@@%.........
    0x3f, 0x00, 0x00,  //..@@@@@@..........
    0x3e, 0x00, 0x00,  //..@@@@%...........
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00fe (þ) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe3, 0xf0, 0x00,  //@@@...%@@@@%.....
    0xef, 0xfc, 0x00,  //@@@.%@@@@@@@@%...
    0xff, 0xfe, 0x00,  //@@@%@@@@@@@@@@%..
    0xfc, 0x1e, 0x00,  //@@@@@@+...+@@@@+.
    0xf8, 0x0f, 0x00,  //@@@@%.......%@@@.
    0xf0, 0x07, 0x00,  //@@@@.........@@@+
    0xe0, 0x03, 0x80,  //@@@+.........+@@%
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@+.........+@@%
    0xf0, 0x07, 0x00,  //@@@@.........@@@+
    0xf8, 0x0f, 0x00,  //@@@@%.......%@@@.
    0xfc, 0x1e, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0xfe, 0x00,  //@@@%@@@@@@@@@@%..
    0xef, 0xfc, 0x00,  //@@@.%@@@@@@@@%...
    0xe3, 0xf0, 0x00,  //@@@...%@@@@%.....
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00ff (ÿ) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x07, 0x38, 0x00,  //.....@@@..@@@.....
    0x07, 0x38, 0x00,  //.....@@@..@@@.....
    0x07, 0x38, 0x00,  //.....@@@..@@@.....
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0xe0, 0x01, 0xc0,  //@@@+..........+@@@
    0x70, 0x03, 0x80,  //+@@@..........@@@+
    0x70, 0x03, 0x80,  //.@@@+.........@@@.
    0x78, 0x07, 0x80,  //.%@@%........%@@%.
    0x38, 0x07, 0x00,  //..@@@........@@@..
    0x3c, 0x07, 0x00,  //..%@@%......+@@@..
    0x1c, 0x0e, 0x00,  //..+@@@......@@@+..
    0x1c, 0x0e, 0x00,  //...@@@+.....@@@...
    0x0e, 0x1e, 0x00,  //...+@@@....%@@%...
    0x0e, 0x1c, 0x00,  //....@@@....@@@+...
    0x0f, 0x1c, 0x00,  //....%@@%..+@@@....
    0x07, 0x38, 0x00,  //.....@@@..%@@+....
    0x07, 0x38, 0x00,  //.....@@@+.@@@.....
    0x03, 0xf8, 0x00,  //.....+@@@%@@%.....
    0x03, 0xf0, 0x00,  //......@@@@@@+.....
    0x03, 0xf0, 0x00,  //......%@@@@@......
    0x01, 0xf0, 0x00,  //.......@@@@+......
    0x01, 0xe0, 0x00,  //.......%@@@.......
    0x01, 0xe0, 0x00,  //.......%@@%.......
    0x01, 0xc0, 0x00,  //.......@@@+.......
    0x01, 0xc0, 0x00,  //......+@@@........
    0x03, 0xc0, 0x00,  //......%@@%........
    0x07, 0x80, 0x00,  //.....%@@@.........
    0x3f, 0x80, 0x00,  //..@@@@@@%.........
    0x3f, 0x00, 0x00,  //..@@@@@@..........
    0x3e, 0x00, 0x00,  //..@@@@%...........
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................



#elif USE_LV_FONT_DEJAVU_40_LATIN_SUP == 2
    /*Unicode: U+00a0 ( ) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00a1 (¡) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xb8,  //%@%
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00a2 (¢) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0xf0, 0x00,  //........@@.....
    0x00, 0x00, 0xf0, 0x00,  //........@@.....
    0x00, 0x00, 0xf0, 0x00,  //........@@.....
    0x00, 0x00, 0xf0, 0x00,  //........@@.....
    0x00, 0x00, 0xf0, 0x00,  //........@@.....
    0x00, 0x1b, 0xff, 0x90,  //.....+%@@@@@%+.
    0x01, 0xff, 0xff, 0xfc,  //...+@@@@@@@@@@@
    0x0b, 0xff, 0xff, 0xfc,  //..%@@@@@@@@@@@@
    0x1f, 0xf4, 0xf0, 0x6c,  //.+@@@@+.@@..+%@
    0x3f, 0xc0, 0xf0, 0x00,  //.@@@@...@@.....
    0x7f, 0x00, 0xf0, 0x00,  //+@@@....@@.....
    0xbe, 0x00, 0xf0, 0x00,  //%@@%....@@.....
    0xfc, 0x00, 0xf0, 0x00,  //@@@.....@@.....
    0xfc, 0x00, 0xf0, 0x00,  //@@@.....@@.....
    0xfc, 0x00, 0xf0, 0x00,  //@@@.....@@.....
    0xfc, 0x00, 0xf0, 0x00,  //@@@.....@@.....
    0xfc, 0x00, 0xf0, 0x00,  //@@@.....@@.....
    0xbe, 0x00, 0xf0, 0x00,  //%@@+....@@.....
    0x7f, 0x00, 0xf0, 0x00,  //+@@@....@@.....
    0x3f, 0x80, 0xf0, 0x00,  //.@@@%...@@.....
    0x1f, 0xf4, 0xf0, 0x6c,  //.+@@@@+.@@..+%@
    0x0b, 0xff, 0xff, 0xfc,  //..%@@@@@@@@@@@@
    0x01, 0xff, 0xff, 0xfc,  //...+@@@@@@@@@@@
    0x00, 0x1b, 0xff, 0x90,  //.....+%@@@@@%+.
    0x00, 0x00, 0xf0, 0x00,  //........@@.....
    0x00, 0x00, 0xf0, 0x00,  //........@@.....
    0x00, 0x00, 0xf0, 0x00,  //........@@.....
    0x00, 0x00, 0xf0, 0x00,  //........@@.....
    0x00, 0x00, 0xf0, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00a3 (£) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x01, 0xbf, 0xe4,  //........%@@@@%+.
    0x00, 0x0b, 0xff, 0xff,  //......%@@@@@@@@@
    0x00, 0x2f, 0xff, 0xff,  //.....%@@@@@@@@@@
    0x00, 0x3f, 0x90, 0x07,  //.....@@@%+....+@
    0x00, 0xbf, 0x00, 0x00,  //....%@@@........
    0x00, 0xfd, 0x00, 0x00,  //....%@@+........
    0x00, 0xfc, 0x00, 0x00,  //....@@@.........
    0x00, 0xfc, 0x00, 0x00,  //....@@@.........
    0x00, 0xfc, 0x00, 0x00,  //....@@@.........
    0x00, 0xfc, 0x00, 0x00,  //....@@@.........
    0x00, 0xfc, 0x00, 0x00,  //....@@@.........
    0x00, 0xfc, 0x00, 0x00,  //....@@@.........
    0x3f, 0xff, 0xff, 0xc0,  //.@@@@@@@@@@@@...
    0x3f, 0xff, 0xff, 0xc0,  //.@@@@@@@@@@@@...
    0x3f, 0xff, 0xff, 0xc0,  //.@@@@@@@@@@@@...
    0x00, 0xfc, 0x00, 0x00,  //....@@@.........
    0x00, 0xfc, 0x00, 0x00,  //....@@@.........
    0x00, 0xfc, 0x00, 0x00,  //....@@@.........
    0x00, 0xfc, 0x00, 0x00,  //....@@@.........
    0x00, 0xfc, 0x00, 0x00,  //....@@@.........
    0x00, 0xfc, 0x00, 0x00,  //....@@@.........
    0x00, 0xfc, 0x00, 0x00,  //....@@@.........
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00a4 (¤) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x24, 0x00, 0x00, 0x01, 0xc0,  //.%+............+%.
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0x7f, 0x46, 0xf9, 0x1f, 0xd0,  //+@@@+.+%@@%+.+@@@+
    0x1f, 0xff, 0xff, 0xff, 0x40,  //.+@@@@@@@@@@@@@@+.
    0x07, 0xff, 0xff, 0xfd, 0x00,  //..+@@@@@@@@@@@@+..
    0x02, 0xfd, 0x07, 0xfc, 0x00,  //...%@@@+..+@@@@...
    0x07, 0xf0, 0x00, 0xfd, 0x00,  //..+@@@......@@@+..
    0x0b, 0xd0, 0x00, 0x7e, 0x00,  //..%@@+......+@@%..
    0x0f, 0xc0, 0x00, 0x3f, 0x00,  //..@@@........@@@..
    0x0f, 0xc0, 0x00, 0x3f, 0x00,  //..@@@........@@@..
    0x0b, 0xd0, 0x00, 0x7e, 0x00,  //..%@@+......+@@%..
    0x07, 0xf0, 0x00, 0xfc, 0x00,  //...@@@......@@@...
    0x03, 0xfd, 0x07, 0xf8, 0x00,  //...@@@@+..+@@@%...
    0x07, 0xff, 0xff, 0xfd, 0x00,  //..+@@@@@@@@@@@@+..
    0x1f, 0xff, 0xff, 0xbf, 0x40,  //.+@@@@@@@@@@%@@@+.
    0x7f, 0x46, 0xf8, 0x1f, 0xd0,  //+@@@+.+%@@%..+@@@+
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0x24, 0x00, 0x00, 0x01, 0x80,  //.%+............+%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00a5 (¥) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xbe, 0x00, 0x00, 0x02, 0xf8,  //%@@%...........%@@%
    0x3f, 0x40, 0x00, 0x07, 0xf0,  //.@@@+.........+@@@.
    0x2f, 0xc0, 0x00, 0x0f, 0xe0,  //.%@@@.........@@@%.
    0x0f, 0xd0, 0x00, 0x1f, 0xc0,  //..@@@+.......+@@@..
    0x0b, 0xf0, 0x00, 0x3f, 0x80,  //..%@@@.......@@@%..
    0x03, 0xf8, 0x00, 0xbf, 0x00,  //...@@@%.....%@@@...
    0x01, 0xfc, 0x00, 0xfd, 0x00,  //...+@@@.....@@@+...
    0x00, 0xfe, 0x02, 0xfc, 0x00,  //....@@@%...%@@@....
    0x00, 0x7f, 0x03, 0xf4, 0x00,  //....+@@@...@@@+....
    0x00, 0x3f, 0xcf, 0xf0, 0x00,  //.....@@@%.@@@@.....
    0x3f, 0xff, 0xef, 0xff, 0xf0,  //.@@@@@@@@%@@@@@@@@.
    0x3f, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@@@@@.
    0x00, 0x03, 0xff, 0x00, 0x00,  //.......@@@@@.......
    0x00, 0x01, 0xfd, 0x00, 0x00,  //.......+@@@+.......
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x3f, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@@@@@.
    0x3f, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00a6 (¦) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00a7 (§) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0xbf, 0xe4, 0x00,  //....%@@@@%+...
    0x0b, 0xff, 0xff, 0x00,  //..+@@@@@@@@@..
    0x1f, 0xd0, 0x2f, 0x00,  //.+@@@+...%@@..
    0x3f, 0x40, 0x02, 0x00,  //.@@@+......%..
    0x3f, 0x00, 0x00, 0x00,  //.@@@..........
    0x3f, 0x40, 0x00, 0x00,  //.@@@+.........
    0x2f, 0xc0, 0x00, 0x00,  //.%@@@.........
    0x0f, 0xf4, 0x00, 0x00,  //..@@@@+.......
    0x03, 0xff, 0x00, 0x00,  //...@@@@@......
    0x0f, 0xff, 0xe0, 0x00,  //..@@@@@@@%....
    0x3f, 0x0b, 0xfd, 0x00,  //.@@@..%@@@@+..
    0xbd, 0x01, 0xff, 0x80,  //%@@....+@@@@%.
    0xfc, 0x00, 0x2f, 0xd0,  //@@@......%@@@+
    0xfc, 0x00, 0x0b, 0xf0,  //@@@.......%@@@
    0xbf, 0x00, 0x03, 0xf0,  //%@@@.......@@@
    0x3f, 0xc0, 0x03, 0xf0,  //.@@@@......@@@
    0x1f, 0xf8, 0x07, 0xe0,  //.+@@@@%...+@@%
    0x02, 0xff, 0x5f, 0xc0,  //...%@@@@++@@@.
    0x00, 0x7f, 0xfe, 0x00,  //....+@@@@@@%..
    0x00, 0x07, 0xfd, 0x00,  //......+@@@@+..
    0x00, 0x00, 0xff, 0x00,  //........@@@@..
    0x00, 0x00, 0x3f, 0x80,  //.........@@@%.
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@.
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@.
    0x20, 0x00, 0x1f, 0x80,  //.%.......+@@%.
    0x3e, 0x40, 0xbf, 0x00,  //.@@%+...+@@@..
    0x3f, 0xff, 0xfd, 0x00,  //.@@@@@@@@@@+..
    0x06, 0xff, 0xe0, 0x00,  //..+%@@@@@%....
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00a8 (¨) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00a9 (©) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x6f, 0xfe, 0x40, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x07, 0xff, 0xff, 0xf4, 0x00, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x3f, 0xd0, 0x01, 0xff, 0x00, 0x00,  //.....@@@@+.....+@@@@.....
    0x00, 0xfd, 0x00, 0x00, 0x1f, 0xc0, 0x00,  //....@@@+.........+@@@....
    0x03, 0xe0, 0x00, 0x00, 0x02, 0xf0, 0x00,  //...@@%.............%@@...
    0x0f, 0x80, 0x1f, 0xfe, 0x00, 0xbc, 0x00,  //..@@%....+@@@@@+....%@@..
    0x1f, 0x01, 0xff, 0xff, 0xc0, 0x3d, 0x00,  //.+@@...+@@@@@@@@@....@@+.
    0x3d, 0x07, 0xf8, 0x01, 0xc0, 0x1f, 0x00,  //.@@+..+@@@%....+@....+@@.
    0x7c, 0x0f, 0xd0, 0x00, 0x00, 0x0f, 0x40,  //+@@...@@@+............@@+
    0xb4, 0x2f, 0x80, 0x00, 0x00, 0x07, 0x80,  //%@+..+@@%.............+@%
    0xf0, 0x3f, 0x40, 0x00, 0x00, 0x03, 0xc0,  //@@...@@@...............@@
    0xf0, 0x3f, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@...@@@...............@@
    0xf0, 0x3f, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@...@@@...............@@
    0xf0, 0x3f, 0x00, 0x00, 0x00, 0x03, 0xc0,  //@@...@@@...............@@
    0xf0, 0x3f, 0x40, 0x00, 0x00, 0x03, 0xc0,  //@@...@@@...............@@
    0xb4, 0x1f, 0x80, 0x00, 0x00, 0x07, 0x80,  //%@+..+@@%.............+@%
    0x7c, 0x0f, 0xd0, 0x00, 0x00, 0x0f, 0x40,  //+@@...@@@+............@@+
    0x3d, 0x07, 0xf8, 0x01, 0xc0, 0x1f, 0x00,  //.@@+..+@@@%....+@....+@@.
    0x1f, 0x01, 0xff, 0xff, 0xc0, 0x3d, 0x00,  //.+@@...+@@@@@@@@@....@@+.
    0x0f, 0xc0, 0x1f, 0xfe, 0x00, 0xbc, 0x00,  //..@@%....+@@@@@%....%@@..
    0x03, 0xf0, 0x00, 0x00, 0x02, 0xf0, 0x00,  //...@@%.............%@@...
    0x00, 0xfd, 0x00, 0x00, 0x1f, 0xc0, 0x00,  //....@@@+.........+@@@....
    0x00, 0x3f, 0xd0, 0x01, 0xff, 0x00, 0x00,  //.....@@@@+.....+@@@@.....
    0x00, 0x07, 0xff, 0xff, 0xf4, 0x00, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x00, 0x6f, 0xfe, 0x40, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+00aa (ª) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x06, 0xff, 0x80, 0x00,  //..+%@@@@%....
    0x3f, 0xff, 0xf4, 0x00,  //.@@@@@@@@@+..
    0x34, 0x01, 0xfc, 0x00,  //.@+....+@@@..
    0x00, 0x00, 0x7e, 0x00,  //........+@@%.
    0x00, 0x00, 0x3f, 0x00,  //.........@@@.
    0x06, 0xff, 0xff, 0x00,  //..+%@@@@@@@@.
    0x2f, 0xff, 0xff, 0x00,  //.%@@@@@@@@@@.
    0x7f, 0x40, 0x3f, 0x00,  //+@@@+....@@@.
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@.
    0xfc, 0x00, 0x7f, 0x00,  //@@@.....+@@@.
    0xfc, 0x00, 0xff, 0x00,  //@@@.....@@@@.
    0xbf, 0x02, 0xff, 0x00,  //%@@@...%@@@@.
    0x3f, 0xff, 0x7f, 0x00,  //.@@@@@@@+@@@.
    0x0b, 0xf8, 0x3f, 0x00,  //..%@@@%..@@@.
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0xbf, 0xff, 0xff, 0x00,  //%@@@@@@@@@@@.
    0xbf, 0xff, 0xff, 0x00,  //%@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00ab («) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x02, 0x00, 0x08,  //.......%......%
    0x00, 0x0b, 0x00, 0x2c,  //......%@.....%@
    0x00, 0x3f, 0x00, 0xfc,  //.....@@@....@@@
    0x00, 0xfc, 0x03, 0xf0,  //....@@@....@@@.
    0x07, 0xe0, 0x1f, 0x80,  //..+@@%...+@@%..
    0x1f, 0x80, 0x7e, 0x00,  //.+@@%...+@@%...
    0xbd, 0x02, 0xf4, 0x00,  //%@@+...%@@+....
    0xf8, 0x03, 0xe0, 0x00,  //@@%....@@%.....
    0xbd, 0x02, 0xf4, 0x00,  //%@@+...%@@+....
    0x1f, 0x80, 0x7e, 0x00,  //.+@@%...+@@%...
    0x07, 0xe0, 0x1f, 0x80,  //..+@@%...+@@%..
    0x00, 0xfc, 0x03, 0xf0,  //....@@@....@@@.
    0x00, 0x3f, 0x00, 0xfc,  //.....@@@....@@@
    0x00, 0x0b, 0x00, 0x2c,  //......%@.....%@
    0x00, 0x02, 0x00, 0x08,  //.......%......%
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00ac (¬) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+00ad (­) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00ae (®) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x6f, 0xfe, 0x40, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x07, 0xff, 0xff, 0xf4, 0x00, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x3f, 0xd0, 0x01, 0xff, 0x00, 0x00,  //.....@@@@+.....+@@@@.....
    0x00, 0xfd, 0x00, 0x00, 0x1f, 0xc0, 0x00,  //....@@@+.........+@@@....
    0x03, 0xe0, 0x00, 0x00, 0x02, 0xf0, 0x00,  //...@@%.............%@@...
    0x0f, 0x80, 0xff, 0xfe, 0x00, 0xbc, 0x00,  //..@@%...@@@@@@@%....%@@..
    0x1f, 0x00, 0xff, 0xff, 0xc0, 0x3d, 0x00,  //.+@@....@@@@@@@@@....@@+.
    0x3d, 0x00, 0xfc, 0x0b, 0xe0, 0x1f, 0x00,  //.@@+....@@@...%@@%...+@@.
    0x7c, 0x00, 0xfc, 0x03, 0xf0, 0x0f, 0x40,  //+@@.....@@@....@@@....@@+
    0xb4, 0x00, 0xfc, 0x03, 0xf0, 0x07, 0x80,  //%@+.....@@@....@@@....+@%
    0xf0, 0x00, 0xfc, 0x0b, 0xe0, 0x03, 0xc0,  //@@......@@@...%@@%.....@@
    0xf0, 0x00, 0xff, 0xff, 0x80, 0x03, 0xc0,  //@@......@@@@@@@@%......@@
    0xf0, 0x00, 0xff, 0xfc, 0x00, 0x03, 0xc0,  //@@......@@@@@@@........@@
    0xf0, 0x00, 0xfc, 0x3d, 0x00, 0x03, 0xc0,  //@@......@@@..@@+.......@@
    0xf0, 0x00, 0xfc, 0x1f, 0x00, 0x03, 0xc0,  //@@......@@@..+@@.......@@
    0xb4, 0x00, 0xfc, 0x0f, 0x80, 0x07, 0x80,  //%@+.....@@@...@@%.....+@%
    0x7c, 0x00, 0xfc, 0x0b, 0xc0, 0x0f, 0x40,  //+@@.....@@@...%@@.....@@+
    0x3d, 0x00, 0xfc, 0x03, 0xe0, 0x1f, 0x00,  //.@@+....@@@....@@%...+@@.
    0x1f, 0x00, 0xfc, 0x02, 0xf0, 0x3d, 0x00,  //.+@@....@@@....%@@...@@+.
    0x0f, 0xc0, 0xfc, 0x00, 0xf8, 0xbc, 0x00,  //..@@%...@@@.....@@%.%@@..
    0x03, 0xf0, 0x00, 0x00, 0x02, 0xf0, 0x00,  //...@@%.............%@@...
    0x00, 0xfd, 0x00, 0x00, 0x1f, 0xc0, 0x00,  //....@@@+.........+@@@....
    0x00, 0x3f, 0xd0, 0x01, 0xff, 0x00, 0x00,  //.....@@@@+.....+@@@@.....
    0x00, 0x07, 0xff, 0xff, 0xf4, 0x00, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x00, 0x6f, 0xfe, 0x40, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+00af (¯) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00b0 (°) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x02, 0xfe, 0x00,  //...%@@@%...
    0x1f, 0xff, 0xd0,  //.+@@@@@@@+.
    0x3e, 0x02, 0xf0,  //.@@%...%@@.
    0xb8, 0x00, 0xb8,  //%@%.....%@%
    0xf0, 0x00, 0x3c,  //@@.......@@
    0xf0, 0x00, 0x3c,  //@@.......@@
    0xf0, 0x00, 0x3c,  //@@.......@@
    0xb8, 0x00, 0xb8,  //%@%.....%@%
    0x3e, 0x02, 0xf0,  //.@@%...%@@.
    0x1f, 0xff, 0xd0,  //.+@@@@@@@+.
    0x02, 0xfe, 0x00,  //...%@@@%...
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00b1 (±) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+00b2 (²) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x1b, 0xfd, 0x00,  //.+%@@@@+..
    0xff, 0xff, 0xc0,  //@@@@@@@@@.
    0xe0, 0x07, 0xe0,  //@+....+@@%
    0x00, 0x01, 0xf0,  //.......+@@
    0x00, 0x00, 0xf0,  //........@@
    0x00, 0x02, 0xd0,  //.......%@+
    0x00, 0x07, 0xc0,  //......+@@.
    0x00, 0x1f, 0x00,  //.....+@@..
    0x00, 0xbc, 0x00,  //....%@@...
    0x02, 0xf4, 0x00,  //...%@@+...
    0x0f, 0xc0, 0x00,  //..@@@.....
    0x7f, 0x00, 0x00,  //+@@@......
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00b3 (³) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x1b, 0xfe, 0x00,  //.+%@@@@%..
    0xff, 0xff, 0xd0,  //@@@@@@@@@+
    0xd0, 0x02, 0xf0,  //@+.....%@@
    0x00, 0x00, 0xf0,  //........@@
    0x00, 0x02, 0xe0,  //.......%@%
    0x03, 0xff, 0x80,  //...@@@@@%.
    0x03, 0xff, 0x80,  //...@@@@@%.
    0x00, 0x07, 0xe0,  //......+@@+
    0x00, 0x01, 0xf0,  //.......+@@
    0x00, 0x00, 0xf0,  //........@@
    0x00, 0x01, 0xf0,  //.......+@@
    0xd0, 0x07, 0xe0,  //%+....+@@%
    0xff, 0xff, 0xc0,  //@@@@@@@@%.
    0x2f, 0xf9, 0x00,  //.%@@@@%+..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00b4 (´) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0xbe,  //....%@@%
    0x01, 0xf8,  //...+@@%.
    0x07, 0xe0,  //..+@@%..
    0x0f, 0xc0,  //..@@@...
    0x3f, 0x00,  //.@@@....
    0xbc, 0x00,  //%@@.....
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00b5 (µ) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@..
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@..
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@..
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@..
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@..
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@..
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@..
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@..
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@..
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@..
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@..
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@..
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@..
    0xfd, 0x00, 0x00, 0x7f, 0x00,  //@@@+........+@@@..
    0xff, 0x00, 0x00, 0xff, 0x00,  //@@@@........@@@@..
    0xff, 0xd0, 0x0b, 0xff, 0x40,  //@@@@@+....+@@@@@+.
    0xfe, 0xff, 0xff, 0xef, 0xf0,  //@@@%@@@@@@@@@%@@@@
    0xfc, 0xff, 0xff, 0x1f, 0xf0,  //@@@.@@@@@@@@.+@@@@
    0xfc, 0x1f, 0xf4, 0x0b, 0xd0,  //@@@..+@@@@+...%@@+
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00b6 (¶) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x6f, 0xff, 0xfc,  //....+%@@@@@@@@@
    0x03, 0xff, 0xff, 0xfc,  //...@@@@@@@@@@@@
    0x1f, 0xff, 0xf0, 0x3c,  //.+@@@@@@@@...@@
    0x3f, 0xff, 0xf0, 0x3c,  //.@@@@@@@@@...@@
    0xbf, 0xff, 0xf0, 0x3c,  //%@@@@@@@@@...@@
    0xff, 0xff, 0xf0, 0x3c,  //@@@@@@@@@@...@@
    0xff, 0xff, 0xf0, 0x3c,  //@@@@@@@@@@...@@
    0xff, 0xff, 0xf0, 0x3c,  //@@@@@@@@@@...@@
    0xff, 0xff, 0xf0, 0x3c,  //@@@@@@@@@@...@@
    0xbf, 0xff, 0xf0, 0x3c,  //%@@@@@@@@@...@@
    0x3f, 0xff, 0xf0, 0x3c,  //.@@@@@@@@@...@@
    0x1f, 0xff, 0xf0, 0x3c,  //.+@@@@@@@@...@@
    0x03, 0xff, 0xf0, 0x3c,  //...@@@@@@@...@@
    0x00, 0x2f, 0xf0, 0x3c,  //.....%@@@@...@@
    0x00, 0x00, 0xf0, 0x3c,  //........@@...@@
    0x00, 0x00, 0xf0, 0x3c,  //........@@...@@
    0x00, 0x00, 0xf0, 0x3c,  //........@@...@@
    0x00, 0x00, 0xf0, 0x3c,  //........@@...@@
    0x00, 0x00, 0xf0, 0x3c,  //........@@...@@
    0x00, 0x00, 0xf0, 0x3c,  //........@@...@@
    0x00, 0x00, 0xf0, 0x3c,  //........@@...@@
    0x00, 0x00, 0xf0, 0x3c,  //........@@...@@
    0x00, 0x00, 0xf0, 0x3c,  //........@@...@@
    0x00, 0x00, 0xf0, 0x3c,  //........@@...@@
    0x00, 0x00, 0xf0, 0x3c,  //........@@...@@
    0x00, 0x00, 0xf0, 0x3c,  //........@@...@@
    0x00, 0x00, 0xf0, 0x3c,  //........@@...@@
    0x00, 0x00, 0xf0, 0x3c,  //........@@...@@
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00b7 (·) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00b8 (¸) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x03, 0xd0,  //...@@+.
    0x01, 0xf0,  //...+@@.
    0x00, 0xf8,  //....@@%
    0x00, 0xfc,  //....@@@
    0x81, 0xfc,  //%..+@@@
    0xff, 0xf8,  //@@@@@@%
    0xbf, 0xd0,  //%@@@@+.
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+00b9 (¹) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x1f, 0xc0,  //.+@@@...
    0xff, 0xc0,  //@@@@@...
    0xd3, 0xc0,  //@+.@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00ba (º) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x0b, 0xff, 0xf8, 0x00,  //..%@@@@@@@%..
    0x2f, 0xc0, 0xbe, 0x00,  //.%@@%...%@@%.
    0x7f, 0x00, 0x3f, 0x40,  //+@@@.....@@@+
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0x7f, 0x00, 0x3f, 0x40,  //+@@@.....@@@+
    0x2f, 0x80, 0xbe, 0x00,  //.%@@%...%@@%.
    0x0b, 0xff, 0xfc, 0x00,  //..%@@@@@@@@..
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x3f, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@.
    0x3f, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00bb (») , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x80, 0x02, 0x00, 0x00,  //%......%.......
    0xe0, 0x03, 0x80, 0x00,  //@%.....@%......
    0xfc, 0x03, 0xf0, 0x00,  //@@@....@@@.....
    0x3f, 0x00, 0xfc, 0x00,  //.@@@....@@@....
    0x0b, 0xd0, 0x2f, 0x40,  //..%@@+...%@@+..
    0x02, 0xf4, 0x0b, 0xd0,  //...%@@+...%@@+.
    0x00, 0x7e, 0x01, 0xf8,  //....+@@%...+@@%
    0x00, 0x2f, 0x00, 0xbc,  //.....%@@....%@@
    0x00, 0x7e, 0x01, 0xf8,  //....+@@%...+@@%
    0x02, 0xf4, 0x0b, 0xd0,  //...%@@+...%@@+.
    0x0b, 0xd0, 0x2f, 0x40,  //..%@@+...%@@+..
    0x3f, 0x00, 0xfc, 0x00,  //.@@@....@@@....
    0xfc, 0x03, 0xf0, 0x00,  //@@@....@@@.....
    0xe0, 0x03, 0x80, 0x00,  //@%.....@%......
    0x80, 0x02, 0x00, 0x00,  //%......%.......
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00bc (¼) , Width: 28 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x1f, 0xc0, 0x00, 0x00, 0x00, 0xb8, 0x00,  //.+@@@...............%@%.....
    0xff, 0xc0, 0x00, 0x00, 0x01, 0xf0, 0x00,  //@@@@@..............+@@......
    0xd3, 0xc0, 0x00, 0x00, 0x03, 0xd0, 0x00,  //@+.@@..............@@+......
    0x03, 0xc0, 0x00, 0x00, 0x0b, 0xc0, 0x00,  //...@@.............%@@.......
    0x03, 0xc0, 0x00, 0x00, 0x0f, 0x00, 0x00,  //...@@.............@@........
    0x03, 0xc0, 0x00, 0x00, 0x3e, 0x00, 0x00,  //...@@............@@%........
    0x03, 0xc0, 0x00, 0x00, 0x7c, 0x00, 0x00,  //...@@...........+@@.........
    0x03, 0xc0, 0x00, 0x00, 0xf4, 0x00, 0x00,  //...@@...........@@+.........
    0x03, 0xc0, 0x00, 0x02, 0xe0, 0x00, 0x00,  //...@@..........%@%..........
    0x03, 0xc0, 0x00, 0x07, 0xc0, 0x00, 0x00,  //...@@.........+@@...........
    0x03, 0xc0, 0x00, 0x0f, 0x40, 0x00, 0x00,  //...@@.........@@+...........
    0x03, 0xc0, 0x00, 0x2f, 0x00, 0x03, 0xf0,  //...@@........%@@.......@@@..
    0xff, 0xff, 0x00, 0x3c, 0x00, 0x0b, 0xf0,  //@@@@@@@@.....@@.......%@@@..
    0xff, 0xff, 0x00, 0xf8, 0x00, 0x1e, 0xf0,  //@@@@@@@@....@@%......+@%@@..
    0x00, 0x00, 0x01, 0xf0, 0x00, 0x3c, 0xf0,  //...........+@@.......@@.@@..
    0x00, 0x00, 0x03, 0xd0, 0x00, 0xf0, 0xf0,  //...........@@+......@@..@@..
    0x00, 0x00, 0x0b, 0x80, 0x02, 0xd0, 0xf0,  //..........%@%......%@+..@@..
    0x00, 0x00, 0x1f, 0x00, 0x07, 0x80, 0xf0,  //.........+@@......+@%...@@..
    0x00, 0x00, 0x3d, 0x00, 0x0f, 0x00, 0xf0,  //.........@@+......@@....@@..
    0x00, 0x00, 0xbc, 0x00, 0x2c, 0x00, 0xf0,  //........%@@......%@.....@@..
    0x00, 0x00, 0xf0, 0x00, 0x3f, 0xff, 0xff,  //........@@.......@@@@@@@@@@@
    0x00, 0x03, 0xe0, 0x00, 0x3f, 0xff, 0xff,  //.......@@%.......@@@@@@@@@@@
    0x00, 0x07, 0xc0, 0x00, 0x00, 0x00, 0xf0,  //......+@@...............@@..
    0x00, 0x0f, 0x40, 0x00, 0x00, 0x00, 0xf0,  //......@@+...............@@..
    0x00, 0x2e, 0x00, 0x00, 0x00, 0x00, 0xf0,  //.....%@%................@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................


    /*Unicode: U+00bd (½) , Width: 28 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x1f, 0xc0, 0x00, 0x00, 0x00, 0xb8, 0x00,  //.+@@@...............%@%.....
    0xff, 0xc0, 0x00, 0x00, 0x01, 0xf0, 0x00,  //@@@@@..............+@@......
    0xd3, 0xc0, 0x00, 0x00, 0x03, 0xd0, 0x00,  //@+.@@..............@@+......
    0x03, 0xc0, 0x00, 0x00, 0x0b, 0xc0, 0x00,  //...@@.............%@@.......
    0x03, 0xc0, 0x00, 0x00, 0x0f, 0x00, 0x00,  //...@@.............@@........
    0x03, 0xc0, 0x00, 0x00, 0x3e, 0x00, 0x00,  //...@@............@@%........
    0x03, 0xc0, 0x00, 0x00, 0x7c, 0x00, 0x00,  //...@@...........+@@.........
    0x03, 0xc0, 0x00, 0x00, 0xf4, 0x00, 0x00,  //...@@...........@@+.........
    0x03, 0xc0, 0x00, 0x02, 0xe0, 0x00, 0x00,  //...@@..........%@%..........
    0x03, 0xc0, 0x00, 0x07, 0xc0, 0x00, 0x00,  //...@@.........+@@...........
    0x03, 0xc0, 0x00, 0x0f, 0x40, 0x00, 0x00,  //...@@.........@@+...........
    0x03, 0xc0, 0x00, 0x2f, 0x01, 0xbf, 0xd0,  //...@@........%@@...+%@@@@+..
    0xff, 0xff, 0x00, 0x3c, 0x0f, 0xff, 0xfc,  //@@@@@@@@.....@@...@@@@@@@@@.
    0xff, 0xff, 0x00, 0xf8, 0x0e, 0x00, 0x7e,  //@@@@@@@@....@@%...@+....+@@%
    0x00, 0x00, 0x01, 0xf0, 0x00, 0x00, 0x1f,  //...........+@@...........+@@
    0x00, 0x00, 0x03, 0xd0, 0x00, 0x00, 0x0f,  //...........@@+............@@
    0x00, 0x00, 0x0b, 0x80, 0x00, 0x00, 0x2d,  //..........%@%............%@+
    0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x7c,  //.........+@@............+@@.
    0x00, 0x00, 0x3d, 0x00, 0x00, 0x01, 0xf0,  //.........@@+...........+@@..
    0x00, 0x00, 0xbc, 0x00, 0x00, 0x0b, 0xc0,  //........%@@...........%@@...
    0x00, 0x00, 0xf0, 0x00, 0x00, 0x2f, 0x40,  //........@@...........%@@+...
    0x00, 0x03, 0xe0, 0x00, 0x00, 0xfc, 0x00,  //.......@@%..........@@@.....
    0x00, 0x07, 0xc0, 0x00, 0x07, 0xf0, 0x00,  //......+@@.........+@@@......
    0x00, 0x0f, 0x40, 0x00, 0x0f, 0xff, 0xff,  //......@@+.........@@@@@@@@@@
    0x00, 0x2e, 0x00, 0x00, 0x0f, 0xff, 0xff,  //.....%@%..........@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................


    /*Unicode: U+00be (¾) , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x1b, 0xfe, 0x00, 0x00, 0x00, 0x2e, 0x00, 0x00,  //.+%@@@@%.............%@%.....
    0xff, 0xff, 0xd0, 0x00, 0x00, 0x7c, 0x00, 0x00,  //@@@@@@@@@+..........+@@......
    0xd0, 0x02, 0xf0, 0x00, 0x00, 0xf4, 0x00, 0x00,  //@+.....%@@..........@@+......
    0x00, 0x00, 0xf0, 0x00, 0x02, 0xf0, 0x00, 0x00,  //........@@.........%@@.......
    0x00, 0x02, 0xe0, 0x00, 0x03, 0xc0, 0x00, 0x00,  //.......%@%.........@@........
    0x03, 0xff, 0x80, 0x00, 0x0f, 0x80, 0x00, 0x00,  //...@@@@@%.........@@%........
    0x03, 0xff, 0x80, 0x00, 0x1f, 0x00, 0x00, 0x00,  //...@@@@@%........+@@.........
    0x00, 0x07, 0xe0, 0x00, 0x3d, 0x00, 0x00, 0x00,  //......+@@+.......@@+.........
    0x00, 0x01, 0xf0, 0x00, 0xb8, 0x00, 0x00, 0x00,  //.......+@@......%@%..........
    0x00, 0x00, 0xf0, 0x01, 0xf0, 0x00, 0x00, 0x00,  //........@@.....+@@...........
    0x00, 0x01, 0xf0, 0x03, 0xd0, 0x00, 0x00, 0x00,  //.......+@@.....@@+...........
    0xd0, 0x07, 0xe0, 0x0b, 0xc0, 0x00, 0xfc, 0x00,  //%+....+@@%....%@@.......@@@..
    0xff, 0xff, 0xc0, 0x0f, 0x00, 0x02, 0xfc, 0x00,  //@@@@@@@@%.....@@.......%@@@..
    0x2f, 0xf9, 0x00, 0x3e, 0x00, 0x07, 0xbc, 0x00,  //.%@@@@%+.....@@%......+@%@@..
    0x00, 0x00, 0x00, 0x7c, 0x00, 0x0f, 0x3c, 0x00,  //............+@@.......@@.@@..
    0x00, 0x00, 0x00, 0xf4, 0x00, 0x3c, 0x3c, 0x00,  //............@@+......@@..@@..
    0x00, 0x00, 0x02, 0xe0, 0x00, 0xb4, 0x3c, 0x00,  //...........%@%......%@+..@@..
    0x00, 0x00, 0x07, 0xc0, 0x01, 0xe0, 0x3c, 0x00,  //..........+@@......+@%...@@..
    0x00, 0x00, 0x0f, 0x40, 0x03, 0xc0, 0x3c, 0x00,  //..........@@+......@@....@@..
    0x00, 0x00, 0x2f, 0x00, 0x0b, 0x00, 0x3c, 0x00,  //.........%@@......%@.....@@..
    0x00, 0x00, 0x3c, 0x00, 0x0f, 0xff, 0xff, 0xc0,  //.........@@.......@@@@@@@@@@@
    0x00, 0x00, 0xf8, 0x00, 0x0f, 0xff, 0xff, 0xc0,  //........@@%.......@@@@@@@@@@@
    0x00, 0x01, 0xf0, 0x00, 0x00, 0x00, 0x3c, 0x00,  //.......+@@...............@@..
    0x00, 0x03, 0xd0, 0x00, 0x00, 0x00, 0x3c, 0x00,  //.......@@+...............@@..
    0x00, 0x0b, 0x80, 0x00, 0x00, 0x00, 0x3c, 0x00,  //......%@%................@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+00bf (¿) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x0f, 0xc0, 0x00,  //......@@@....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x0f, 0xc0, 0x00,  //......@@@....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@....
    0x00, 0x2f, 0x80, 0x00,  //.....%@@%....
    0x00, 0xbf, 0x00, 0x00,  //....%@@@.....
    0x02, 0xfe, 0x00, 0x00,  //...%@@@%.....
    0x0b, 0xfc, 0x00, 0x00,  //..%@@@@......
    0x1f, 0xf0, 0x00, 0x00,  //.+@@@@.......
    0x3f, 0xc0, 0x00, 0x00,  //.@@@@........
    0xbf, 0x00, 0x00, 0x00,  //%@@@.........
    0xfd, 0x00, 0x00, 0x00,  //@@@+.........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfe, 0x00, 0x00, 0x80,  //@@@%........%
    0x7f, 0x80, 0x1f, 0xc0,  //+@@@%....+%@@
    0x3f, 0xff, 0xff, 0xc0,  //.@@@@@@@@@@@@
    0x0f, 0xff, 0xff, 0x40,  //..@@@@@@@@@@+
    0x01, 0xbf, 0xe4, 0x00,  //...+%@@@@%+..
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00c0 (À) , Width: 23 */
    0x00, 0x02, 0xf4, 0x00, 0x00, 0x00,  //.......%@@+............
    0x00, 0x00, 0xbd, 0x00, 0x00, 0x00,  //........%@@+...........
    0x00, 0x00, 0x2f, 0x00, 0x00, 0x00,  //.........%@@...........
    0x00, 0x00, 0x0b, 0xc0, 0x00, 0x00,  //..........%@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x2f, 0xe0, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x7f, 0xf4, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0xff, 0xfc, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0xfc, 0xfc, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x02, 0xf8, 0xbe, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x03, 0xf4, 0x7f, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x07, 0xf0, 0x3f, 0x40, 0x00,  //......+@@@...@@@+......
    0x00, 0x0b, 0xe0, 0x2f, 0x80, 0x00,  //......%@@%...%@@%......
    0x00, 0x0f, 0xc0, 0x0f, 0xc0, 0x00,  //......@@@.....@@@......
    0x00, 0x1f, 0xc0, 0x0f, 0xd0, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x3f, 0x40, 0x07, 0xf0, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x3f, 0x00, 0x03, 0xf0, 0x00,  //.....@@@.......@@@.....
    0x00, 0xbe, 0x00, 0x02, 0xf8, 0x00,  //....%@@%.......%@@%....
    0x00, 0xfc, 0x00, 0x00, 0xfc, 0x00,  //....@@@.........@@@....
    0x01, 0xfc, 0x00, 0x00, 0xfd, 0x00,  //...+@@@.........@@@+...
    0x02, 0xff, 0xff, 0xff, 0xfe, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x03, 0xff, 0xff, 0xff, 0xff, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x0b, 0xff, 0xff, 0xff, 0xff, 0x80,  //..%@@@@@@@@@@@@@@@@@%..
    0x0f, 0xd0, 0x00, 0x00, 0x1f, 0xc0,  //..@@@+...........+@@@..
    0x1f, 0xc0, 0x00, 0x00, 0x0f, 0xd0,  //.+@@@.............@@@+.
    0x2f, 0x80, 0x00, 0x00, 0x0b, 0xe0,  //.%@@%.............%@@%.
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x7f, 0x00, 0x00, 0x00, 0x03, 0xf4,  //+@@@...............@@@+
    0xfd, 0x00, 0x00, 0x00, 0x01, 0xfc,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c1 (Á) , Width: 23 */
    0x00, 0x00, 0x00, 0xfc, 0x00, 0x00,  //............@@@........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00,  //...........@@@.........
    0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00,  //..........%@@..........
    0x00, 0x00, 0x2f, 0x00, 0x00, 0x00,  //.........%@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x2f, 0xe0, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x7f, 0xf4, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0xff, 0xfc, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0xfc, 0xfc, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x02, 0xf8, 0xbe, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x03, 0xf4, 0x7f, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x07, 0xf0, 0x3f, 0x40, 0x00,  //......+@@@...@@@+......
    0x00, 0x0b, 0xe0, 0x2f, 0x80, 0x00,  //......%@@%...%@@%......
    0x00, 0x0f, 0xc0, 0x0f, 0xc0, 0x00,  //......@@@.....@@@......
    0x00, 0x1f, 0xc0, 0x0f, 0xd0, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x3f, 0x40, 0x07, 0xf0, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x3f, 0x00, 0x03, 0xf0, 0x00,  //.....@@@.......@@@.....
    0x00, 0xbe, 0x00, 0x02, 0xf8, 0x00,  //....%@@%.......%@@%....
    0x00, 0xfc, 0x00, 0x00, 0xfc, 0x00,  //....@@@.........@@@....
    0x01, 0xfc, 0x00, 0x00, 0xfd, 0x00,  //...+@@@.........@@@+...
    0x02, 0xff, 0xff, 0xff, 0xfe, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x03, 0xff, 0xff, 0xff, 0xff, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x0b, 0xff, 0xff, 0xff, 0xff, 0x80,  //..%@@@@@@@@@@@@@@@@@%..
    0x0f, 0xd0, 0x00, 0x00, 0x1f, 0xc0,  //..@@@+...........+@@@..
    0x1f, 0xc0, 0x00, 0x00, 0x0f, 0xd0,  //.+@@@.............@@@+.
    0x2f, 0x80, 0x00, 0x00, 0x0b, 0xe0,  //.%@@%.............%@@%.
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x7f, 0x00, 0x00, 0x00, 0x03, 0xf4,  //+@@@...............@@@+
    0xfd, 0x00, 0x00, 0x00, 0x01, 0xfc,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c2 (Â) , Width: 23 */
    0x00, 0x00, 0x1f, 0xd0, 0x00, 0x00,  //.........+@@@+.........
    0x00, 0x00, 0x3e, 0xf0, 0x00, 0x00,  //.........@@%@@.........
    0x00, 0x00, 0xf4, 0x7c, 0x00, 0x00,  //........@@+.+@@........
    0x00, 0x02, 0xe0, 0x2e, 0x00, 0x00,  //.......%@+...+@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x2f, 0xe0, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x7f, 0xf4, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0xff, 0xfc, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0xfc, 0xfc, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x02, 0xf8, 0xbe, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x03, 0xf4, 0x7f, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x07, 0xf0, 0x3f, 0x40, 0x00,  //......+@@@...@@@+......
    0x00, 0x0b, 0xe0, 0x2f, 0x80, 0x00,  //......%@@%...%@@%......
    0x00, 0x0f, 0xc0, 0x0f, 0xc0, 0x00,  //......@@@.....@@@......
    0x00, 0x1f, 0xc0, 0x0f, 0xd0, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x3f, 0x40, 0x07, 0xf0, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x3f, 0x00, 0x03, 0xf0, 0x00,  //.....@@@.......@@@.....
    0x00, 0xbe, 0x00, 0x02, 0xf8, 0x00,  //....%@@%.......%@@%....
    0x00, 0xfc, 0x00, 0x00, 0xfc, 0x00,  //....@@@.........@@@....
    0x01, 0xfc, 0x00, 0x00, 0xfd, 0x00,  //...+@@@.........@@@+...
    0x02, 0xff, 0xff, 0xff, 0xfe, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x03, 0xff, 0xff, 0xff, 0xff, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x0b, 0xff, 0xff, 0xff, 0xff, 0x80,  //..%@@@@@@@@@@@@@@@@@%..
    0x0f, 0xd0, 0x00, 0x00, 0x1f, 0xc0,  //..@@@+...........+@@@..
    0x1f, 0xc0, 0x00, 0x00, 0x0f, 0xd0,  //.+@@@.............@@@+.
    0x2f, 0x80, 0x00, 0x00, 0x0b, 0xe0,  //.%@@%.............%@@%.
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x7f, 0x00, 0x00, 0x00, 0x03, 0xf4,  //+@@@...............@@@+
    0xfd, 0x00, 0x00, 0x00, 0x01, 0xfc,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c3 (Ã) , Width: 23 */
    0x00, 0x01, 0xf8, 0x03, 0xc0, 0x00,  //.......+@@%....@@......
    0x00, 0x07, 0xff, 0x87, 0xc0, 0x00,  //......+@@@@@%.+@%......
    0x00, 0x0f, 0x4b, 0xff, 0x40, 0x00,  //......@@+.%@@@@@+......
    0x00, 0x0f, 0x00, 0xbd, 0x00, 0x00,  //......@@....%@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x2f, 0xe0, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x7f, 0xf4, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0xff, 0xfc, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0xfc, 0xfc, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x02, 0xf8, 0xbe, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x03, 0xf4, 0x7f, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x07, 0xf0, 0x3f, 0x40, 0x00,  //......+@@@...@@@+......
    0x00, 0x0b, 0xe0, 0x2f, 0x80, 0x00,  //......%@@%...%@@%......
    0x00, 0x0f, 0xc0, 0x0f, 0xc0, 0x00,  //......@@@.....@@@......
    0x00, 0x1f, 0xc0, 0x0f, 0xd0, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x3f, 0x40, 0x07, 0xf0, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x3f, 0x00, 0x03, 0xf0, 0x00,  //.....@@@.......@@@.....
    0x00, 0xbe, 0x00, 0x02, 0xf8, 0x00,  //....%@@%.......%@@%....
    0x00, 0xfc, 0x00, 0x00, 0xfc, 0x00,  //....@@@.........@@@....
    0x01, 0xfc, 0x00, 0x00, 0xfd, 0x00,  //...+@@@.........@@@+...
    0x02, 0xff, 0xff, 0xff, 0xfe, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x03, 0xff, 0xff, 0xff, 0xff, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x0b, 0xff, 0xff, 0xff, 0xff, 0x80,  //..%@@@@@@@@@@@@@@@@@%..
    0x0f, 0xd0, 0x00, 0x00, 0x1f, 0xc0,  //..@@@+...........+@@@..
    0x1f, 0xc0, 0x00, 0x00, 0x0f, 0xd0,  //.+@@@.............@@@+.
    0x2f, 0x80, 0x00, 0x00, 0x0b, 0xe0,  //.%@@%.............%@@%.
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x7f, 0x00, 0x00, 0x00, 0x03, 0xf4,  //+@@@...............@@@+
    0xfd, 0x00, 0x00, 0x00, 0x01, 0xfc,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c4 (Ä) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x03, 0xf0, 0x3f, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x03, 0xf0, 0x3f, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x03, 0xf0, 0x3f, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x2f, 0xe0, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x7f, 0xf4, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0xff, 0xfc, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0xfc, 0xfc, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x02, 0xf8, 0xbe, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x03, 0xf4, 0x7f, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x07, 0xf0, 0x3f, 0x40, 0x00,  //......+@@@...@@@+......
    0x00, 0x0b, 0xe0, 0x2f, 0x80, 0x00,  //......%@@%...%@@%......
    0x00, 0x0f, 0xc0, 0x0f, 0xc0, 0x00,  //......@@@.....@@@......
    0x00, 0x1f, 0xc0, 0x0f, 0xd0, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x3f, 0x40, 0x07, 0xf0, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x3f, 0x00, 0x03, 0xf0, 0x00,  //.....@@@.......@@@.....
    0x00, 0xbe, 0x00, 0x02, 0xf8, 0x00,  //....%@@%.......%@@%....
    0x00, 0xfc, 0x00, 0x00, 0xfc, 0x00,  //....@@@.........@@@....
    0x01, 0xfc, 0x00, 0x00, 0xfd, 0x00,  //...+@@@.........@@@+...
    0x02, 0xff, 0xff, 0xff, 0xfe, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x03, 0xff, 0xff, 0xff, 0xff, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x0b, 0xff, 0xff, 0xff, 0xff, 0x80,  //..%@@@@@@@@@@@@@@@@@%..
    0x0f, 0xd0, 0x00, 0x00, 0x1f, 0xc0,  //..@@@+...........+@@@..
    0x1f, 0xc0, 0x00, 0x00, 0x0f, 0xd0,  //.+@@@.............@@@+.
    0x2f, 0x80, 0x00, 0x00, 0x0b, 0xe0,  //.%@@%.............%@@%.
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x7f, 0x00, 0x00, 0x00, 0x03, 0xf4,  //+@@@...............@@@+
    0xfd, 0x00, 0x00, 0x00, 0x01, 0xfc,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c5 (Å) , Width: 23 */
    0x00, 0x00, 0xff, 0xf8, 0x00, 0x00,  //........@@@@@@%........
    0x00, 0x02, 0xf0, 0x7d, 0x00, 0x00,  //.......%@@..+@@+.......
    0x00, 0x03, 0xc0, 0x1f, 0x00, 0x00,  //.......@@....+@@.......
    0x00, 0x03, 0xc0, 0x0f, 0x00, 0x00,  //.......@@.....@@.......
    0x00, 0x03, 0xc0, 0x1f, 0x00, 0x00,  //.......@@.....@@.......
    0x00, 0x02, 0xf0, 0x7e, 0x00, 0x00,  //.......%@@...@@%.......
    0x00, 0x00, 0xff, 0xfc, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x7f, 0xf4, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0xff, 0xfc, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0xfc, 0xfc, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x02, 0xf8, 0xbe, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x03, 0xf0, 0x3f, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x07, 0xf0, 0x3f, 0x40, 0x00,  //......+@@@...@@@+......
    0x00, 0x0b, 0xd0, 0x1f, 0x80, 0x00,  //......%@@+...+@@%......
    0x00, 0x0f, 0xc0, 0x0f, 0xc0, 0x00,  //......@@@.....@@@......
    0x00, 0x1f, 0x80, 0x0b, 0xd0, 0x00,  //.....+@@%.....%@@+.....
    0x00, 0x3f, 0x40, 0x07, 0xf0, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x3f, 0x00, 0x03, 0xf0, 0x00,  //.....@@@.......@@@.....
    0x00, 0xbe, 0x00, 0x02, 0xf8, 0x00,  //....%@@%.......%@@%....
    0x00, 0xfc, 0x00, 0x00, 0xfc, 0x00,  //....@@@.........@@@....
    0x01, 0xfc, 0x00, 0x00, 0xfd, 0x00,  //...+@@@.........@@@+...
    0x03, 0xff, 0xff, 0xff, 0xff, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x03, 0xff, 0xff, 0xff, 0xff, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x0b, 0xff, 0xff, 0xff, 0xff, 0x80,  //..%@@@@@@@@@@@@@@@@@%..
    0x0f, 0xd0, 0x00, 0x00, 0x1f, 0xc0,  //..@@@+...........+@@@..
    0x1f, 0xc0, 0x00, 0x00, 0x0f, 0xd0,  //.+@@@.............@@@+.
    0x2f, 0x80, 0x00, 0x00, 0x0b, 0xe0,  //.%@@%.............%@@%.
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x7f, 0x00, 0x00, 0x00, 0x03, 0xf4,  //+@@@...............@@@+
    0xfd, 0x00, 0x00, 0x00, 0x01, 0xfc,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c6 (Æ) , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xfc,  //..........%@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfc,  //..........@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xfc,  //.........%@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x3f, 0x43, 0xf0, 0x00, 0x00, 0x00,  //.........@@@+..@@@.............
    0x00, 0x00, 0x7f, 0x03, 0xf0, 0x00, 0x00, 0x00,  //........+@@@...@@@.............
    0x00, 0x00, 0xfd, 0x03, 0xf0, 0x00, 0x00, 0x00,  //........@@@+...@@@.............
    0x00, 0x00, 0xfc, 0x03, 0xf0, 0x00, 0x00, 0x00,  //........@@@....@@@.............
    0x00, 0x02, 0xf8, 0x03, 0xf0, 0x00, 0x00, 0x00,  //.......%@@%....@@@.............
    0x00, 0x03, 0xf0, 0x03, 0xf0, 0x00, 0x00, 0x00,  //.......@@@.....@@@.............
    0x00, 0x07, 0xf0, 0x03, 0xf0, 0x00, 0x00, 0x00,  //......+@@%.....@@@.............
    0x00, 0x0f, 0xd0, 0x03, 0xff, 0xff, 0xff, 0xf0,  //......@@@+.....@@@@@@@@@@@@@@@.
    0x00, 0x1f, 0xc0, 0x03, 0xff, 0xff, 0xff, 0xf0,  //.....+@@@......@@@@@@@@@@@@@@@.
    0x00, 0x2f, 0x40, 0x03, 0xff, 0xff, 0xff, 0xf0,  //.....%@@+......@@@@@@@@@@@@@@@.
    0x00, 0x3f, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //.....@@@.......@@@.............
    0x00, 0xbe, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //....%@@%.......@@@.............
    0x00, 0xfc, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //....@@@........@@@.............
    0x01, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@@@@.............
    0x03, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@@@@.............
    0x07, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..+@@@@@@@@@@@@@@@.............
    0x0b, 0xe0, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //..%@@%.........@@@.............
    0x0f, 0xc0, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //..@@@..........@@@.............
    0x2f, 0x80, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //.%@@%..........@@@.............
    0x3f, 0x40, 0x00, 0x03, 0xff, 0xff, 0xff, 0xfc,  //.@@@+..........@@@@@@@@@@@@@@@@
    0x7f, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xfc,  //+@@@...........@@@@@@@@@@@@@@@@
    0xfd, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xfc,  //@@@+...........@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+00c7 (Ç) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x01, 0xbf, 0xfe, 0x40,  //.......+%@@@@@@%+...
    0x00, 0x1f, 0xff, 0xff, 0xf8,  //.....+@@@@@@@@@@@@%.
    0x00, 0xbf, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x03, 0xff, 0x90, 0x06, 0xff,  //...@@@@@%+....+%@@@@
    0x0b, 0xf8, 0x00, 0x00, 0x1f,  //..%@@@+..........+@@
    0x1f, 0xd0, 0x00, 0x00, 0x02,  //.+@@@+.............%
    0x3f, 0x80, 0x00, 0x00, 0x00,  //.@@@%...............
    0x3f, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x7e, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0xbd, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xbd, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0x7e, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0x3f, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x3f, 0x80, 0x00, 0x00, 0x00,  //.@@@%...............
    0x1f, 0xd0, 0x00, 0x00, 0x02,  //.+@@@+.............%
    0x0b, 0xf4, 0x00, 0x00, 0x1f,  //..%@@@+..........+@@
    0x03, 0xff, 0x90, 0x06, 0xff,  //...@@@@@%+....+%@@@@
    0x00, 0xbf, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x00, 0x1f, 0xff, 0xff, 0xf8,  //.....+@@@@@@@@@@@@%.
    0x00, 0x01, 0xbf, 0xfe, 0x40,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x03, 0xd0, 0x00,  //...........@@+......
    0x00, 0x00, 0x01, 0xf0, 0x00,  //...........+@@......
    0x00, 0x00, 0x00, 0xf8, 0x00,  //............@@%.....
    0x00, 0x00, 0x00, 0xfc, 0x00,  //............@@@.....
    0x00, 0x00, 0x81, 0xfc, 0x00,  //........%..+@@@.....
    0x00, 0x00, 0xff, 0xf8, 0x00,  //........@@@@@@%.....
    0x00, 0x00, 0xbf, 0xd0, 0x00,  //........%@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+00c8 (È) , Width: 16 */
    0x00, 0xbd, 0x00, 0x00,  //....%@@+........
    0x00, 0x2f, 0x40, 0x00,  //.....%@@+.......
    0x00, 0x0b, 0xc0, 0x00,  //......%@@.......
    0x00, 0x02, 0xf0, 0x00,  //.......%@@......
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00c9 (É) , Width: 16 */
    0x00, 0x00, 0x3f, 0x00,  //.........@@@....
    0x00, 0x00, 0xfc, 0x00,  //........@@@.....
    0x00, 0x03, 0xf0, 0x00,  //.......%@@......
    0x00, 0x0b, 0xc0, 0x00,  //......%@@.......
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00ca (Ê) , Width: 16 */
    0x00, 0x0f, 0xf0, 0x00,  //......@@@@......
    0x00, 0x3f, 0xfc, 0x00,  //.....@@@@@@.....
    0x00, 0xbc, 0x3e, 0x00,  //....%@%..%@%....
    0x02, 0xe0, 0x0b, 0x80,  //...%@%....%@%...
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00cb (Ë) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0xfc, 0x0f, 0xc0,  //....@@@...@@@...
    0x00, 0xfc, 0x0f, 0xc0,  //....@@@...@@@...
    0x00, 0xfc, 0x0f, 0xc0,  //....@@@...@@@...
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00cc (Ì) , Width: 7 */
    0xbd, 0x00,  //%@@+...
    0x2f, 0x40,  //.%@@+..
    0x0b, 0xc0,  //..%@@..
    0x02, 0xf0,  //...%@@.
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+00cd (Í) , Width: 7 */
    0x03, 0xf0,  //...@@@.
    0x0f, 0xc0,  //..@@@..
    0x3f, 0x00,  //.%@@...
    0xbc, 0x00,  //%@@....
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+00ce (Î) , Width: 10 */
    0x0b, 0xf8, 0x00,  //..%@@@%...
    0x2f, 0xbe, 0x00,  //.%@@%@@%..
    0xbc, 0x0f, 0x80,  //%@@...@@%.
    0xf0, 0x03, 0xe0,  //@@.....@@%
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00cf (Ï) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00d0 (Ð) , Width: 24 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x03, 0xff, 0xff, 0xe9, 0x00, 0x00,  //...@@@@@@@@@@%%+........
    0x03, 0xff, 0xff, 0xff, 0xe4, 0x00,  //...@@@@@@@@@@@@@@%+.....
    0x03, 0xff, 0xff, 0xff, 0xfe, 0x00,  //...@@@@@@@@@@@@@@@@%....
    0x03, 0xf0, 0x00, 0x16, 0xff, 0xc0,  //...@@@........+%@@@@@...
    0x03, 0xf0, 0x00, 0x00, 0x2f, 0xf0,  //...@@@...........%@@@@..
    0x03, 0xf0, 0x00, 0x00, 0x07, 0xf4,  //...@@@............+@@@+.
    0x03, 0xf0, 0x00, 0x00, 0x02, 0xfc,  //...@@@.............%@@@.
    0x03, 0xf0, 0x00, 0x00, 0x00, 0xfd,  //...@@@..............@@@+
    0x03, 0xf0, 0x00, 0x00, 0x00, 0xbe,  //...@@@..............%@@%
    0x03, 0xf0, 0x00, 0x00, 0x00, 0x7f,  //...@@@..............+@@@
    0x03, 0xf0, 0x00, 0x00, 0x00, 0x3f,  //...@@@...............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x3f,  //@@@@@@@@@@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x3f,  //@@@@@@@@@@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x3f,  //@@@@@@@@@@@@.........@@@
    0x03, 0xf0, 0x00, 0x00, 0x00, 0x3f,  //...@@@...............@@@
    0x03, 0xf0, 0x00, 0x00, 0x00, 0x7f,  //...@@@..............+@@%
    0x03, 0xf0, 0x00, 0x00, 0x00, 0xbe,  //...@@@..............%@@%
    0x03, 0xf0, 0x00, 0x00, 0x00, 0xfd,  //...@@@..............@@@+
    0x03, 0xf0, 0x00, 0x00, 0x02, 0xfc,  //...@@@.............%@@@.
    0x03, 0xf0, 0x00, 0x00, 0x07, 0xf4,  //...@@@............+@@@+.
    0x03, 0xf0, 0x00, 0x00, 0x2f, 0xf0,  //...@@@...........%@@@@..
    0x03, 0xf0, 0x00, 0x06, 0xff, 0xc0,  //...@@@........+%@@@@@...
    0x03, 0xff, 0xff, 0xff, 0xfe, 0x00,  //...@@@@@@@@@@@@@@@@%....
    0x03, 0xff, 0xff, 0xff, 0xe4, 0x00,  //...@@@@@@@@@@@@@@%+.....
    0x03, 0xff, 0xff, 0xe9, 0x00, 0x00,  //...@@@@@@@@@@%%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................


    /*Unicode: U+00d1 (Ñ) , Width: 19 */
    0x00, 0x1f, 0x80, 0x3c, 0x00,  //.....+@@%....@@....
    0x00, 0x7f, 0xf8, 0x7c, 0x00,  //....+@@@@@%.+@%....
    0x00, 0xf4, 0xbf, 0xf4, 0x00,  //....@@+.%@@@@@+....
    0x00, 0xf0, 0x0b, 0xd0, 0x00,  //....@@....%@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0x80, 0x00, 0x00, 0xfc,  //@@@@%...........@@@
    0xff, 0xc0, 0x00, 0x00, 0xfc,  //@@@@@...........@@@
    0xff, 0xe0, 0x00, 0x00, 0xfc,  //@@@@@%..........@@@
    0xff, 0xf4, 0x00, 0x00, 0xfc,  //@@@@@@..........@@@
    0xfe, 0xfc, 0x00, 0x00, 0xfc,  //@@@%@@@.........@@@
    0xfc, 0xfd, 0x00, 0x00, 0xfc,  //@@@.@@@+........@@@
    0xfc, 0xbf, 0x00, 0x00, 0xfc,  //@@@.+@@@........@@@
    0xfc, 0x3f, 0x40, 0x00, 0xfc,  //@@@..@@@+.......@@@
    0xfc, 0x1f, 0xc0, 0x00, 0xfc,  //@@@..+@@@.......@@@
    0xfc, 0x0f, 0xe0, 0x00, 0xfc,  //@@@...@@@%......@@@
    0xfc, 0x07, 0xf0, 0x00, 0xfc,  //@@@...+@@@......@@@
    0xfc, 0x03, 0xf8, 0x00, 0xfc,  //@@@....%@@%.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xbe, 0x00, 0xfc,  //@@@.....%@@%....@@@
    0xfc, 0x00, 0x3f, 0x40, 0xfc,  //@@@......@@@+...@@@
    0xfc, 0x00, 0x2f, 0xc0, 0xfc,  //@@@......%@@@...@@@
    0xfc, 0x00, 0x0f, 0xd0, 0xfc,  //@@@.......@@@+..@@@
    0xfc, 0x00, 0x07, 0xf0, 0xfc,  //@@@.......+@@@..@@@
    0xfc, 0x00, 0x03, 0xf4, 0xfc,  //@@@........@@@+.@@@
    0xfc, 0x00, 0x01, 0xfc, 0xfc,  //@@@........+@@@.@@@
    0xfc, 0x00, 0x00, 0xfe, 0xfc,  //@@@.........@@@%@@@
    0xfc, 0x00, 0x00, 0x7f, 0xfc,  //@@@.........+@@@@@@
    0xfc, 0x00, 0x00, 0x2f, 0xfc,  //@@@..........%@@@@@
    0xfc, 0x00, 0x00, 0x0f, 0xfc,  //@@@...........@@@@@
    0xfc, 0x00, 0x00, 0x0b, 0xfc,  //@@@...........%@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00d2 (Ò) , Width: 23 */
    0x00, 0x02, 0xf4, 0x00, 0x00, 0x00,  //.......%@@+............
    0x00, 0x00, 0xbd, 0x00, 0x00, 0x00,  //........%@@+...........
    0x00, 0x00, 0x2f, 0x00, 0x00, 0x00,  //.........%@@...........
    0x00, 0x00, 0x0b, 0xc0, 0x00, 0x00,  //..........%@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....%@@@@@@@@@@@@@@....
    0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //...@@@@@+.....+@@@@@...
    0x0b, 0xf8, 0x00, 0x00, 0xbf, 0x80,  //..%@@@%.........+@@@%..
    0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //.+@@@+...........+@@@+.
    0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%.............%@@@.
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x7e, 0x00, 0x00, 0x00, 0x02, 0xf4,  //+@@%...............%@@+
    0xbd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //%@@+...............+@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xbd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //%@@+...............+@@%
    0x7e, 0x00, 0x00, 0x00, 0x02, 0xf4,  //+@@%...............%@@+
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%.............%@@@.
    0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //.+@@@+...........+@@@+.
    0x0b, 0xf8, 0x00, 0x00, 0x7f, 0x80,  //..%@@@+.........+@@@%..
    0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d3 (Ó) , Width: 23 */
    0x00, 0x00, 0x00, 0xfc, 0x00, 0x00,  //............@@@........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00,  //...........@@@.........
    0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00,  //..........%@@..........
    0x00, 0x00, 0x2f, 0x00, 0x00, 0x00,  //.........%@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....%@@@@@@@@@@@@@@....
    0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //...@@@@@+.....+@@@@@...
    0x0b, 0xf8, 0x00, 0x00, 0xbf, 0x80,  //..%@@@%.........+@@@%..
    0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //.+@@@+...........+@@@+.
    0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%.............%@@@.
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x7e, 0x00, 0x00, 0x00, 0x02, 0xf4,  //+@@%...............%@@+
    0xbd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //%@@+...............+@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xbd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //%@@+...............+@@%
    0x7e, 0x00, 0x00, 0x00, 0x02, 0xf4,  //+@@%...............%@@+
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%.............%@@@.
    0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //.+@@@+...........+@@@+.
    0x0b, 0xf8, 0x00, 0x00, 0x7f, 0x80,  //..%@@@+.........+@@@%..
    0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d4 (Ô) , Width: 23 */
    0x00, 0x00, 0x1f, 0xd0, 0x00, 0x00,  //.........+@@@+.........
    0x00, 0x00, 0x3e, 0xf0, 0x00, 0x00,  //.........@@%@@.........
    0x00, 0x00, 0xf4, 0x7c, 0x00, 0x00,  //........@@+.+@@........
    0x00, 0x02, 0xe0, 0x2e, 0x00, 0x00,  //.......%@+...+@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....%@@@@@@@@@@@@@@....
    0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //...@@@@@+.....+@@@@@...
    0x0b, 0xf8, 0x00, 0x00, 0xbf, 0x80,  //..%@@@%.........+@@@%..
    0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //.+@@@+...........+@@@+.
    0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%.............%@@@.
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x7e, 0x00, 0x00, 0x00, 0x02, 0xf4,  //+@@%...............%@@+
    0xbd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //%@@+...............+@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xbd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //%@@+...............+@@%
    0x7e, 0x00, 0x00, 0x00, 0x02, 0xf4,  //+@@%...............%@@+
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%.............%@@@.
    0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //.+@@@+...........+@@@+.
    0x0b, 0xf8, 0x00, 0x00, 0x7f, 0x80,  //..%@@@+.........+@@@%..
    0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d5 (Õ) , Width: 23 */
    0x00, 0x01, 0xf8, 0x03, 0xc0, 0x00,  //.......+@@%....@@......
    0x00, 0x07, 0xff, 0x87, 0xc0, 0x00,  //......+@@@@@%.+@%......
    0x00, 0x0f, 0x4b, 0xff, 0x40, 0x00,  //......@@+.%@@@@@+......
    0x00, 0x0f, 0x00, 0xbd, 0x00, 0x00,  //......@@....%@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....%@@@@@@@@@@@@@@....
    0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //...@@@@@+.....+@@@@@...
    0x0b, 0xf8, 0x00, 0x00, 0xbf, 0x80,  //..%@@@%.........+@@@%..
    0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //.+@@@+...........+@@@+.
    0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%.............%@@@.
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x7e, 0x00, 0x00, 0x00, 0x02, 0xf4,  //+@@%...............%@@+
    0xbd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //%@@+...............+@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xbd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //%@@+...............+@@%
    0x7e, 0x00, 0x00, 0x00, 0x02, 0xf4,  //+@@%...............%@@+
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%.............%@@@.
    0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //.+@@@+...........+@@@+.
    0x0b, 0xf8, 0x00, 0x00, 0x7f, 0x80,  //..%@@@+.........+@@@%..
    0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d6 (Ö) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x03, 0xf0, 0x3f, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x03, 0xf0, 0x3f, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x03, 0xf0, 0x3f, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....%@@@@@@@@@@@@@@....
    0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //...@@@@@+.....+@@@@@...
    0x0b, 0xf8, 0x00, 0x00, 0xbf, 0x80,  //..%@@@%.........+@@@%..
    0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //.+@@@+...........+@@@+.
    0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%.............%@@@.
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x7e, 0x00, 0x00, 0x00, 0x02, 0xf4,  //+@@%...............%@@+
    0xbd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //%@@+...............+@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xbd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //%@@+...............+@@%
    0x7e, 0x00, 0x00, 0x00, 0x02, 0xf4,  //+@@%...............%@@+
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%.............%@@@.
    0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //.+@@@+...........+@@@+.
    0x0b, 0xf8, 0x00, 0x00, 0x7f, 0x80,  //..%@@@+.........+@@@%..
    0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d7 (×) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x18, 0x00, 0x00, 0x00, 0x90,  //.+%.............%+.
    0x7e, 0x00, 0x00, 0x02, 0xf4,  //+@@%...........%@@+
    0x7f, 0x80, 0x00, 0x0b, 0xf4,  //+@@@%.........%@@@+
    0x1f, 0xe0, 0x00, 0x2f, 0xd0,  //.+@@@%.......%@@@+.
    0x07, 0xf8, 0x00, 0xbf, 0x40,  //..+@@@%.....%@@@+..
    0x01, 0xfe, 0x02, 0xfd, 0x00,  //...+@@@%...%@@@+...
    0x00, 0xbf, 0x8b, 0xf4, 0x00,  //....+@@@%.%@@@+....
    0x00, 0x2f, 0xff, 0xd0, 0x00,  //.....+@@@@@@@+.....
    0x00, 0x0b, 0xff, 0x40, 0x00,  //......%@@@@@+......
    0x00, 0x02, 0xfe, 0x00, 0x00,  //.......%@@@%.......
    0x00, 0x07, 0xff, 0x40, 0x00,  //......+@@@@@+......
    0x00, 0x1f, 0xff, 0xd0, 0x00,  //.....+@@@@@@@+.....
    0x00, 0x7f, 0x8b, 0xf4, 0x00,  //....+@@@%.%@@@+....
    0x01, 0xfe, 0x02, 0xfd, 0x00,  //...+@@@%...%@@@+...
    0x07, 0xf8, 0x00, 0xbf, 0x40,  //..+@@@%.....%@@@+..
    0x1f, 0xe0, 0x00, 0x2f, 0xd0,  //.+@@@%.......%@@@+.
    0x7f, 0x80, 0x00, 0x0b, 0xf4,  //+@@@%.........%@@@+
    0x7e, 0x00, 0x00, 0x02, 0xf4,  //+@@%...........%@@+
    0x18, 0x00, 0x00, 0x00, 0x90,  //.+%.............%+.
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00d8 (Ø) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,  //......................+..
    0x00, 0x00, 0x6f, 0xfe, 0x40, 0x0f, 0x00,  //........+%@@@@@%+.....@@.
    0x00, 0x07, 0xff, 0xff, 0xf8, 0x3f, 0x00,  //......+@@@@@@@@@@@%..@@@.
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xbc, 0x00,  //.....%@@@@@@@@@@@@@@%@@..
    0x00, 0xff, 0xd0, 0x01, 0xff, 0xf4, 0x00,  //....@@@@@+.....+@@@@@@+..
    0x02, 0xfe, 0x00, 0x00, 0x2f, 0xf0, 0x00,  //...%@@@%.........%@@@@...
    0x07, 0xf4, 0x00, 0x00, 0x1f, 0xf4, 0x00,  //..+@@@+..........+@@@@+..
    0x0f, 0xe0, 0x00, 0x00, 0x7f, 0xfc, 0x00,  //..@@@%..........+@@@@@@..
    0x0f, 0xc0, 0x00, 0x01, 0xfc, 0xfc, 0x00,  //..@@@..........+@@@.@@@..
    0x2f, 0x80, 0x00, 0x03, 0xf0, 0xbe, 0x00,  //.+@@%..........@@@..%@@%.
    0x2f, 0x40, 0x00, 0x0f, 0xc0, 0x7e, 0x00,  //.%@@+.........@@@...+@@%.
    0x3f, 0x00, 0x00, 0x3f, 0x00, 0x3f, 0x00,  //.@@@.........@@@.....@@@.
    0x3f, 0x00, 0x00, 0xfc, 0x00, 0x3f, 0x00,  //.@@@........@@@......@@@.
    0x3f, 0x00, 0x03, 0xf0, 0x00, 0x3f, 0x00,  //.@@@.......@@@.......@@@.
    0x3f, 0x00, 0x0f, 0xc0, 0x00, 0x3f, 0x00,  //.@@@......@@@........@@@.
    0x3f, 0x00, 0x3f, 0x00, 0x00, 0x3f, 0x00,  //.@@@.....@@@.........@@@.
    0x2f, 0x40, 0xfc, 0x00, 0x00, 0x7e, 0x00,  //.%@@+...@@@.........+@@%.
    0x2f, 0x83, 0xf0, 0x00, 0x00, 0xbe, 0x00,  //.%@@%..@@@..........%@@+.
    0x1f, 0xcf, 0xd0, 0x00, 0x00, 0xfc, 0x00,  //.+@@@.@@@+..........@@@..
    0x0f, 0xff, 0x40, 0x00, 0x02, 0xfc, 0x00,  //..@@@@@@+..........%@@@..
    0x07, 0xfd, 0x00, 0x00, 0x07, 0xf4, 0x00,  //..+@@@@+..........+@@@+..
    0x03, 0xfe, 0x00, 0x00, 0x1f, 0xe0, 0x00,  //...@@@@%.........+@@@%...
    0x07, 0xff, 0xd0, 0x01, 0xff, 0xc0, 0x00,  //..+@@@@@@+.....+@@@@@....
    0x0f, 0xbf, 0xff, 0xff, 0xfe, 0x00, 0x00,  //..@@%@@@@@@@@@@@@@@%.....
    0x2f, 0x0b, 0xff, 0xff, 0xf4, 0x00, 0x00,  //.%@@..%@@@@@@@@@@@+......
    0x3c, 0x00, 0x6f, 0xfe, 0x40, 0x00, 0x00,  //.@@.....+%@@@@@%+........
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+00d9 (Ù) , Width: 19 */
    0x00, 0x2f, 0x40, 0x00, 0x00,  //.....%@@+..........
    0x00, 0x0b, 0xd0, 0x00, 0x00,  //......%@@+.........
    0x00, 0x02, 0xf0, 0x00, 0x00,  //.......%@@.........
    0x00, 0x00, 0xbc, 0x00, 0x00,  //........%@@........
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfd, 0x00, 0x00, 0x01, 0xfc,  //@@@+...........+@@@
    0xbe, 0x00, 0x00, 0x02, 0xf8,  //%@@%...........%@@%
    0x7f, 0x00, 0x00, 0x03, 0xf4,  //+@@@...........@@@+
    0x3f, 0x80, 0x00, 0x0b, 0xf0,  //.@@@%.........%@@@.
    0x1f, 0xf4, 0x00, 0x7f, 0xd0,  //.+@@@@+.....+@@@@+.
    0x0b, 0xff, 0xff, 0xff, 0x80,  //..%@@@@@@@@@@@@@%..
    0x01, 0xff, 0xff, 0xfd, 0x00,  //...+@@@@@@@@@@@+...
    0x00, 0x1b, 0xff, 0x90, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00da (Ú) , Width: 19 */
    0x00, 0x00, 0x0f, 0xc0, 0x00,  //..........@@@......
    0x00, 0x00, 0x3f, 0x00, 0x00,  //.........@@@.......
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........%@@........
    0x00, 0x02, 0xf0, 0x00, 0x00,  //.......%@@.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfd, 0x00, 0x00, 0x01, 0xfc,  //@@@+...........+@@@
    0xbe, 0x00, 0x00, 0x02, 0xf8,  //%@@%...........%@@%
    0x7f, 0x00, 0x00, 0x03, 0xf4,  //+@@@...........@@@+
    0x3f, 0x80, 0x00, 0x0b, 0xf0,  //.@@@%.........%@@@.
    0x1f, 0xf4, 0x00, 0x7f, 0xd0,  //.+@@@@+.....+@@@@+.
    0x0b, 0xff, 0xff, 0xff, 0x80,  //..%@@@@@@@@@@@@@%..
    0x01, 0xff, 0xff, 0xfd, 0x00,  //...+@@@@@@@@@@@+...
    0x00, 0x1b, 0xff, 0x90, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00db (Û) , Width: 19 */
    0x00, 0x01, 0xfd, 0x00, 0x00,  //.......+@@@+.......
    0x00, 0x03, 0xef, 0x00, 0x00,  //.......@@%@@.......
    0x00, 0x0f, 0x47, 0xc0, 0x00,  //......@@+.+@@......
    0x00, 0x2e, 0x02, 0xe0, 0x00,  //.....%@+...+@%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfd, 0x00, 0x00, 0x01, 0xfc,  //@@@+...........+@@@
    0xbe, 0x00, 0x00, 0x02, 0xf8,  //%@@%...........%@@%
    0x7f, 0x00, 0x00, 0x03, 0xf4,  //+@@@...........@@@+
    0x3f, 0x80, 0x00, 0x0b, 0xf0,  //.@@@%.........%@@@.
    0x1f, 0xf4, 0x00, 0x7f, 0xd0,  //.+@@@@+.....+@@@@+.
    0x0b, 0xff, 0xff, 0xff, 0x80,  //..%@@@@@@@@@@@@@%..
    0x01, 0xff, 0xff, 0xfd, 0x00,  //...+@@@@@@@@@@@+...
    0x00, 0x1b, 0xff, 0x90, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00dc (Ü) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x3f, 0x03, 0xf0, 0x00,  //.....@@@...@@@.....
    0x00, 0x3f, 0x03, 0xf0, 0x00,  //.....@@@...@@@.....
    0x00, 0x3f, 0x03, 0xf0, 0x00,  //.....@@@...@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfd, 0x00, 0x00, 0x01, 0xfc,  //@@@+...........+@@@
    0xbe, 0x00, 0x00, 0x02, 0xf8,  //%@@%...........%@@%
    0x7f, 0x00, 0x00, 0x03, 0xf4,  //+@@@...........@@@+
    0x3f, 0x80, 0x00, 0x0b, 0xf0,  //.@@@%.........%@@@.
    0x1f, 0xf4, 0x00, 0x7f, 0xd0,  //.+@@@@+.....+@@@@+.
    0x0b, 0xff, 0xff, 0xff, 0x80,  //..%@@@@@@@@@@@@@%..
    0x01, 0xff, 0xff, 0xfd, 0x00,  //...+@@@@@@@@@@@+...
    0x00, 0x1b, 0xff, 0x90, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00dd (Ý) , Width: 21 */
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00,  //...........@@@.......
    0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00,  //..........@@@........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........%@@.........
    0x00, 0x00, 0xbc, 0x00, 0x00, 0x00,  //........%@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xbf, 0x00, 0x00, 0x00, 0x3f, 0x80,  //%@@@.............@@@%
    0x3f, 0x80, 0x00, 0x00, 0xbf, 0x00,  //.@@@%...........%@@@.
    0x1f, 0xd0, 0x00, 0x01, 0xfd, 0x00,  //.+@@@+.........+@@@+.
    0x0b, 0xf0, 0x00, 0x03, 0xf8, 0x00,  //..%@@@.........@@@%..
    0x03, 0xf8, 0x00, 0x0b, 0xf0, 0x00,  //...@@@%.......%@@@...
    0x00, 0xfd, 0x00, 0x1f, 0xc0, 0x00,  //....@@@+.....+@@@....
    0x00, 0xbf, 0x00, 0x3f, 0x80, 0x00,  //....%@@@.....@@@%....
    0x00, 0x3f, 0xc0, 0xff, 0x00, 0x00,  //.....@@@@...@@@@.....
    0x00, 0x0f, 0xd1, 0xfc, 0x00, 0x00,  //......@@@+.+@@@......
    0x00, 0x07, 0xf7, 0xf4, 0x00, 0x00,  //......+@@@+@@@+......
    0x00, 0x03, 0xff, 0xf0, 0x00, 0x00,  //.......@@@@@@@.......
    0x00, 0x00, 0xff, 0xc0, 0x00, 0x00,  //........@@@@@........
    0x00, 0x00, 0x7f, 0x40, 0x00, 0x00,  //........+@@@+........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+00de (Þ) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xf9, 0x00,  //@@@@@@@@@@%+....
    0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@@+.
    0xfc, 0x00, 0x0b, 0xfc,  //@@@.......%@@@@.
    0xfc, 0x00, 0x00, 0xfe,  //@@@.........@@@%
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfc, 0x00, 0x00, 0xfe,  //@@@.........@@@%
    0xfc, 0x00, 0x0b, 0xfc,  //@@@.......%@@@@.
    0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xf9, 0x00,  //@@@@@@@@@@%+....
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00df (ß) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0xbf, 0xf8, 0x00, 0x00,  //....%@@@@@%......
    0x07, 0xff, 0xff, 0x80, 0x00,  //..+@@@@@@@@@%....
    0x2f, 0xff, 0xff, 0xd0, 0x00,  //.%@@@@@@@@@@@+...
    0x3f, 0xd0, 0x1f, 0xf0, 0x00,  //.@@@@+...+@@@@...
    0xbf, 0x00, 0x02, 0xf8, 0x00,  //%@@@.......%@@+..
    0xfd, 0x00, 0x00, 0xfc, 0x00,  //@@@+........@@%..
    0xfc, 0x00, 0x02, 0xfc, 0x00,  //@@@........%@@@..
    0xfc, 0x00, 0x2f, 0xf8, 0x00,  //@@@......%@@@@%..
    0xfc, 0x00, 0xfe, 0x00, 0x00,  //@@@.....@@@%.....
    0xfc, 0x02, 0xf8, 0x00, 0x00,  //@@@....%@@%......
    0xfc, 0x03, 0xf0, 0x00, 0x00,  //@@@....@@@.......
    0xfc, 0x03, 0xf0, 0x00, 0x00,  //@@@....@@@.......
    0xfc, 0x03, 0xf4, 0x00, 0x00,  //@@@....@@@+......
    0xfc, 0x01, 0xfd, 0x00, 0x00,  //@@@....+@@@+.....
    0xfc, 0x00, 0xbf, 0xc0, 0x00,  //@@@.....%@@@@....
    0xfc, 0x00, 0x2f, 0xf4, 0x00,  //@@@......%@@@@+..
    0xfc, 0x00, 0x03, 0xfe, 0x00,  //@@@........@@@@+.
    0xfc, 0x00, 0x00, 0xbf, 0x40,  //@@@.........+@@@+
    0xfc, 0x00, 0x00, 0x1f, 0x80,  //@@@..........+@@%
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x1f, 0xc0,  //@@@..........+@@@
    0xfc, 0x39, 0x00, 0xbf, 0x80,  //@@@..@++....%@@@%
    0xfc, 0x3f, 0xff, 0xff, 0x00,  //@@@..@@@@@@@@@@@.
    0xfc, 0x3f, 0xff, 0xfc, 0x00,  //@@@..@@@@@@@@@@..
    0xfc, 0x07, 0xff, 0x90, 0x00,  //@@@...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00e0 (à) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x0b, 0xe0, 0x00, 0x00,  //..%@@%..........
    0x02, 0xf4, 0x00, 0x00,  //...%@@+.........
    0x00, 0xbd, 0x00, 0x00,  //....%@@+........
    0x00, 0x3f, 0x00, 0x00,  //.....@@@........
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.......
    0x00, 0x03, 0xe0, 0x00,  //.......@@%......
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0xaf, 0xf9, 0x00,  //....%%@@@@%+....
    0x1f, 0xff, 0xff, 0xc0,  //..%@@@@@@@@@@...
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@..
    0x3e, 0x40, 0x0b, 0xfc,  //.@@%+.....+@@@@.
    0x20, 0x00, 0x00, 0xfd,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x7e,  //............+@@%
    0x00, 0x00, 0x00, 0x3f,  //.............@@@
    0x00, 0x6f, 0xff, 0xff,  //....+%@@@@@@@@@@
    0x0b, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@
    0x3f, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x7f, 0x90, 0x00, 0x3f,  //+@@@%+.......@@@
    0xfe, 0x00, 0x00, 0x3f,  //@@@%.........@@@
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfc, 0x00, 0x00, 0xff,  //@@@.........@@@@
    0xfd, 0x00, 0x02, 0xff,  //@@@+.......%@@@@
    0xbf, 0x80, 0x1f, 0xff,  //%@@@%....+@@@@@@
    0x3f, 0xff, 0xff, 0xbf,  //.@@@@@@@@@@@%@@@
    0x0f, 0xff, 0xfe, 0x3f,  //..@@@@@@@@@+.@@@
    0x01, 0xff, 0xe0, 0x3f,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00e1 (á) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x2f, 0x80,  //.........%@@%...
    0x00, 0x00, 0x7e, 0x00,  //........+@@%....
    0x00, 0x01, 0xf8, 0x00,  //.......+@@%.....
    0x00, 0x03, 0xf0, 0x00,  //.......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.......
    0x00, 0x2f, 0x00, 0x00,  //.....%@@........
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0xaf, 0xf9, 0x00,  //....%%@@@@%+....
    0x1f, 0xff, 0xff, 0xc0,  //..%@@@@@@@@@@...
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@..
    0x3e, 0x40, 0x0b, 0xfc,  //.@@%+.....+@@@@.
    0x20, 0x00, 0x00, 0xfd,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x7e,  //............+@@%
    0x00, 0x00, 0x00, 0x3f,  //.............@@@
    0x00, 0x6f, 0xff, 0xff,  //....+%@@@@@@@@@@
    0x0b, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@
    0x3f, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x7f, 0x90, 0x00, 0x3f,  //+@@@%+.......@@@
    0xfe, 0x00, 0x00, 0x3f,  //@@@%.........@@@
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfc, 0x00, 0x00, 0xff,  //@@@.........@@@@
    0xfd, 0x00, 0x02, 0xff,  //@@@+.......%@@@@
    0xbf, 0x80, 0x1f, 0xff,  //%@@@%....+@@@@@@
    0x3f, 0xff, 0xff, 0xbf,  //.@@@@@@@@@@@%@@@
    0x0f, 0xff, 0xfe, 0x3f,  //..@@@@@@@@@+.@@@
    0x01, 0xff, 0xe0, 0x3f,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00e2 (â) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x07, 0xd0, 0x00,  //......+@@+......
    0x00, 0x0f, 0xf0, 0x00,  //......@@@@......
    0x00, 0x3e, 0xbc, 0x00,  //.....%@%%@%.....
    0x00, 0x7c, 0x3d, 0x00,  //....+@@..@@+....
    0x00, 0xf4, 0x1f, 0x00,  //....@@+..+@@....
    0x02, 0xe0, 0x0b, 0x80,  //...%@%....%@%...
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0xaf, 0xf9, 0x00,  //....%%@@@@%+....
    0x1f, 0xff, 0xff, 0xc0,  //..%@@@@@@@@@@...
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@..
    0x3e, 0x40, 0x0b, 0xfc,  //.@@%+.....+@@@@.
    0x20, 0x00, 0x00, 0xfd,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x7e,  //............+@@%
    0x00, 0x00, 0x00, 0x3f,  //.............@@@
    0x00, 0x6f, 0xff, 0xff,  //....+%@@@@@@@@@@
    0x0b, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@
    0x3f, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x7f, 0x90, 0x00, 0x3f,  //+@@@%+.......@@@
    0xfe, 0x00, 0x00, 0x3f,  //@@@%.........@@@
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfc, 0x00, 0x00, 0xff,  //@@@.........@@@@
    0xfd, 0x00, 0x02, 0xff,  //@@@+.......%@@@@
    0xbf, 0x80, 0x1f, 0xff,  //%@@@%....+@@@@@@
    0x3f, 0xff, 0xff, 0xbf,  //.@@@@@@@@@@@%@@@
    0x0f, 0xff, 0xfe, 0x3f,  //..@@@@@@@@@+.@@@
    0x01, 0xff, 0xe0, 0x3f,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00e3 (ã) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x7d, 0x03, 0xc0,  //....+@@+...@@...
    0x01, 0xff, 0x83, 0xc0,  //...+@@@@%..@@...
    0x02, 0xd7, 0xd7, 0x80,  //...%@++@@++@%...
    0x03, 0xc2, 0xff, 0x40,  //...@@..%@@@@+...
    0x03, 0xc0, 0x7d, 0x00,  //...@@...+@@+....
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0xaf, 0xf9, 0x00,  //....%%@@@@%+....
    0x1f, 0xff, 0xff, 0xc0,  //..%@@@@@@@@@@...
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@..
    0x3e, 0x40, 0x0b, 0xfc,  //.@@%+.....+@@@@.
    0x20, 0x00, 0x00, 0xfd,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x7e,  //............+@@%
    0x00, 0x00, 0x00, 0x3f,  //.............@@@
    0x00, 0x6f, 0xff, 0xff,  //....+%@@@@@@@@@@
    0x0b, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@
    0x3f, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x7f, 0x90, 0x00, 0x3f,  //+@@@%+.......@@@
    0xfe, 0x00, 0x00, 0x3f,  //@@@%.........@@@
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfc, 0x00, 0x00, 0xff,  //@@@.........@@@@
    0xfd, 0x00, 0x02, 0xff,  //@@@+.......%@@@@
    0xbf, 0x80, 0x1f, 0xff,  //%@@@%....+@@@@@@
    0x3f, 0xff, 0xff, 0xbf,  //.@@@@@@@@@@@%@@@
    0x0f, 0xff, 0xfe, 0x3f,  //..@@@@@@@@@+.@@@
    0x01, 0xff, 0xe0, 0x3f,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00e4 (ä) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0xfc, 0x3f, 0x00,  //....@@@..@@@....
    0x00, 0xfc, 0x3f, 0x00,  //....@@@..@@@....
    0x00, 0xfc, 0x3f, 0x00,  //....@@@..@@@....
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0xaf, 0xf9, 0x00,  //....%%@@@@%+....
    0x1f, 0xff, 0xff, 0xc0,  //..%@@@@@@@@@@...
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@..
    0x3e, 0x40, 0x0b, 0xfc,  //.@@%+.....+@@@@.
    0x20, 0x00, 0x00, 0xfd,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x7e,  //............+@@%
    0x00, 0x00, 0x00, 0x3f,  //.............@@@
    0x00, 0x6f, 0xff, 0xff,  //....+%@@@@@@@@@@
    0x0b, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@
    0x3f, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x7f, 0x90, 0x00, 0x3f,  //+@@@%+.......@@@
    0xfe, 0x00, 0x00, 0x3f,  //@@@%.........@@@
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfc, 0x00, 0x00, 0xff,  //@@@.........@@@@
    0xfd, 0x00, 0x02, 0xff,  //@@@+.......%@@@@
    0xbf, 0x80, 0x1f, 0xff,  //%@@@%....+@@@@@@
    0x3f, 0xff, 0xff, 0xbf,  //.@@@@@@@@@@@%@@@
    0x0f, 0xff, 0xfe, 0x3f,  //..@@@@@@@@@+.@@@
    0x01, 0xff, 0xe0, 0x3f,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00e5 (å) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x0b, 0xf8, 0x00,  //......%@@@%.....
    0x00, 0x3f, 0xff, 0x00,  //.....@@@@@@@....
    0x00, 0xbc, 0x1f, 0x80,  //....%@@..+@@%...
    0x00, 0xf0, 0x07, 0xc0,  //....@@.....@@...
    0x00, 0xf0, 0x03, 0xc0,  //....@@.....@@...
    0x00, 0xf0, 0x07, 0xc0,  //....@@.....@@...
    0x00, 0xbc, 0x1f, 0x80,  //....%@@...@@%...
    0x00, 0x3f, 0xff, 0x00,  //.....@@@@@@@....
    0x00, 0x0b, 0xf8, 0x00,  //......%@@@%.....
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0xaf, 0xf9, 0x00,  //....%%@@@@%+....
    0x1f, 0xff, 0xff, 0xc0,  //..%@@@@@@@@@@...
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@..
    0x3e, 0x40, 0x0b, 0xfc,  //.@@%+.....+@@@@.
    0x20, 0x00, 0x00, 0xfd,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x7e,  //............+@@%
    0x00, 0x00, 0x00, 0x3f,  //.............@@@
    0x00, 0x6f, 0xff, 0xff,  //....+%@@@@@@@@@@
    0x0b, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@
    0x3f, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x7f, 0x90, 0x00, 0x3f,  //+@@@%+.......@@@
    0xfe, 0x00, 0x00, 0x3f,  //@@@%.........@@@
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfc, 0x00, 0x00, 0xff,  //@@@.........@@@@
    0xfd, 0x00, 0x02, 0xff,  //@@@+.......%@@@@
    0xbf, 0x80, 0x1f, 0xff,  //%@@@%....+@@@@@@
    0x3f, 0xff, 0xff, 0xbf,  //.@@@@@@@@@@@%@@@
    0x0f, 0xff, 0xfe, 0x3f,  //..@@@@@@@@@+.@@@
    0x01, 0xff, 0xe0, 0x3f,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00e6 (æ) , Width: 30 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x6f, 0xf9, 0x00, 0x06, 0xff, 0x90, 0x00,  //....+%@@@@%+......+%@@@@%.....
    0x0b, 0xff, 0xff, 0xd0, 0x7f, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@+..+@@@@@@@@@%...
    0x3f, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@+%@@@@@@@@@@@@..
    0x3e, 0x40, 0x0b, 0xff, 0xf9, 0x00, 0x7f, 0x80,  //.@@%+.....+@@@@@@@%+....+@@@%.
    0x20, 0x00, 0x00, 0xff, 0xd0, 0x00, 0x0f, 0xc0,  //.%..........@@@@@+........@@@.
    0x00, 0x00, 0x00, 0x7f, 0x80, 0x00, 0x07, 0xe0,  //............+@@@%.........+@@%
    0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x03, 0xf0,  //.............@@@...........@@@
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //....+%@@@@@@@@@@@@@@@@@@@@@@@@
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x7f, 0x90, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00,  //+@@@%+.......@@@..............
    0xfe, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00,  //@@@%.........@@@..............
    0xfc, 0x00, 0x00, 0x7f, 0x80, 0x00, 0x00, 0x00,  //@@@.........+@@@%.............
    0xfc, 0x00, 0x00, 0xff, 0xc0, 0x00, 0x00, 0x00,  //@@@.........@@@@@.............
    0xfd, 0x00, 0x02, 0xff, 0xf0, 0x00, 0x00, 0x80,  //@@@+.......%@@@@@@..........%.
    0xbf, 0x80, 0x1f, 0xf7, 0xfe, 0x00, 0x1f, 0xc0,  //%@@@%....+@@@@+@@@@%.....+@@@.
    0x3f, 0xff, 0xff, 0xc2, 0xff, 0xff, 0xff, 0xc0,  //.@@@@@@@@@@@@..%@@@@@@@@@@@@@.
    0x0f, 0xff, 0xfe, 0x00, 0x7f, 0xff, 0xff, 0x40,  //..@@@@@@@@@%....+@@@@@@@@@@@+.
    0x01, 0xbf, 0xe0, 0x00, 0x06, 0xff, 0xe0, 0x00,  //...+%@@@@%........+%@@@@%%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................


    /*Unicode: U+00e7 (ç) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x1b, 0xff, 0x90,  //.....+%@@@@@%+.
    0x00, 0xff, 0xff, 0xfc,  //....@@@@@@@@@@@
    0x07, 0xff, 0xff, 0xfc,  //..+@@@@@@@@@@@@
    0x0f, 0xf9, 0x00, 0x6c,  //..@@@@%.....+%@
    0x3f, 0xc0, 0x00, 0x00,  //.@@@@..........
    0x7f, 0x00, 0x00, 0x00,  //+@@@...........
    0xbe, 0x00, 0x00, 0x00,  //%@@%...........
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xbe, 0x00, 0x00, 0x00,  //%@@%...........
    0x7f, 0x00, 0x00, 0x00,  //+@@@...........
    0x3f, 0xc0, 0x00, 0x00,  //.@@@@..........
    0x0f, 0xf8, 0x00, 0x6c,  //..@@@@%.....+%@
    0x07, 0xff, 0xff, 0xfc,  //..+@@@@@@@@@@@@
    0x01, 0xff, 0xff, 0xfc,  //....@@@@@@@@@@@
    0x00, 0x1b, 0xff, 0x90,  //.....+%@@@@@%+.
    0x00, 0x00, 0xf4, 0x00,  //........@@+....
    0x00, 0x00, 0x7c, 0x00,  //........+@@....
    0x00, 0x00, 0x3e, 0x00,  //.........@@%...
    0x00, 0x00, 0x3f, 0x00,  //.........@@@...
    0x00, 0x20, 0x7f, 0x00,  //.....%..+@@@...
    0x00, 0x3f, 0xfe, 0x00,  //.....@@@@@@%...
    0x00, 0x2f, 0xf4, 0x00,  //.....%@@@@+....
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00e8 (è) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x02, 0xf8, 0x00, 0x00, 0x00,  //...%@@%..........
    0x00, 0xbd, 0x00, 0x00, 0x00,  //....%@@+.........
    0x00, 0x2f, 0x40, 0x00, 0x00,  //.....%@@+........
    0x00, 0x0f, 0xc0, 0x00, 0x00,  //......@@@........
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0xf8, 0x00, 0x00,  //........@@%......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+....
    0x01, 0xff, 0xff, 0xf0, 0x00,  //...+@@@@@@@@@@...
    0x07, 0xff, 0xff, 0xfc, 0x00,  //..+@@@@@@@@@@@@..
    0x1f, 0xe4, 0x01, 0xff, 0x00,  //..@@@%+....+@@@@.
    0x3f, 0x40, 0x00, 0x3f, 0x40,  //.@@@+........@@@+
    0x7e, 0x00, 0x00, 0x1f, 0x80,  //+@@%.........+@@%
    0xbc, 0x00, 0x00, 0x0f, 0xc0,  //%@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xbe, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0x7f, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0x3f, 0xc0, 0x00, 0x02, 0x00,  //.@@@@..........%.
    0x1f, 0xf8, 0x00, 0x7f, 0x00,  //.+@@@@%.....+@@@.
    0x07, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x01, 0xff, 0xff, 0xfd, 0x00,  //...+@@@@@@@@@@@+.
    0x00, 0x1b, 0xff, 0x80, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00e9 (é) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x0b, 0xe0, 0x00,  //..........%@@%...
    0x00, 0x00, 0x1f, 0x80, 0x00,  //.........+@@%....
    0x00, 0x00, 0x7e, 0x00, 0x00,  //........+@@%.....
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x0b, 0xc0, 0x00, 0x00,  //......%@@........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+....
    0x01, 0xff, 0xff, 0xf0, 0x00,  //...+@@@@@@@@@@...
    0x07, 0xff, 0xff, 0xfc, 0x00,  //..+@@@@@@@@@@@@..
    0x1f, 0xe4, 0x01, 0xff, 0x00,  //..@@@%+....+@@@@.
    0x3f, 0x40, 0x00, 0x3f, 0x40,  //.@@@+........@@@+
    0x7e, 0x00, 0x00, 0x1f, 0x80,  //+@@%.........+@@%
    0xbc, 0x00, 0x00, 0x0f, 0xc0,  //%@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xbe, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0x7f, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0x3f, 0xc0, 0x00, 0x02, 0x00,  //.@@@@..........%.
    0x1f, 0xf8, 0x00, 0x7f, 0x00,  //.+@@@@%.....+@@@.
    0x07, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x01, 0xff, 0xff, 0xfd, 0x00,  //...+@@@@@@@@@@@+.
    0x00, 0x1b, 0xff, 0x80, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00ea (ê) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......%@@@@......
    0x00, 0x1f, 0x7e, 0x00, 0x00,  //.....+@@+@@%.....
    0x00, 0x3d, 0x1f, 0x40, 0x00,  //.....@@+.+@@.....
    0x00, 0xf8, 0x0b, 0xc0, 0x00,  //....@@%...%@@....
    0x02, 0xf0, 0x02, 0xe0, 0x00,  //...%@@.....%@%...
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+....
    0x01, 0xff, 0xff, 0xf0, 0x00,  //...+@@@@@@@@@@...
    0x07, 0xff, 0xff, 0xfc, 0x00,  //..+@@@@@@@@@@@@..
    0x1f, 0xe4, 0x01, 0xff, 0x00,  //..@@@%+....+@@@@.
    0x3f, 0x40, 0x00, 0x3f, 0x40,  //.@@@+........@@@+
    0x7e, 0x00, 0x00, 0x1f, 0x80,  //+@@%.........+@@%
    0xbc, 0x00, 0x00, 0x0f, 0xc0,  //%@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xbe, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0x7f, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0x3f, 0xc0, 0x00, 0x02, 0x00,  //.@@@@..........%.
    0x1f, 0xf8, 0x00, 0x7f, 0x00,  //.+@@@@%.....+@@@.
    0x07, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x01, 0xff, 0xff, 0xfd, 0x00,  //...+@@@@@@@@@@@+.
    0x00, 0x1b, 0xff, 0x80, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00eb (ë) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0xfc, 0x0f, 0xc0, 0x00,  //....@@@...@@@....
    0x00, 0xfc, 0x0f, 0xc0, 0x00,  //....@@@...@@@....
    0x00, 0xfc, 0x0f, 0xc0, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+....
    0x01, 0xff, 0xff, 0xf0, 0x00,  //...+@@@@@@@@@@...
    0x07, 0xff, 0xff, 0xfc, 0x00,  //..+@@@@@@@@@@@@..
    0x1f, 0xe4, 0x01, 0xff, 0x00,  //..@@@%+....+@@@@.
    0x3f, 0x40, 0x00, 0x3f, 0x40,  //.@@@+........@@@+
    0x7e, 0x00, 0x00, 0x1f, 0x80,  //+@@%.........+@@%
    0xbc, 0x00, 0x00, 0x0f, 0xc0,  //%@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xbe, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0x7f, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0x3f, 0xc0, 0x00, 0x02, 0x00,  //.@@@@..........%.
    0x1f, 0xf8, 0x00, 0x7f, 0x00,  //.+@@@@%.....+@@@.
    0x07, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x01, 0xff, 0xff, 0xfd, 0x00,  //...+@@@@@@@@@@@+.
    0x00, 0x1b, 0xff, 0x80, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00ec (ì) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0xf8, 0x00,  //@@%....
    0xbd, 0x00,  //%@@+...
    0x2f, 0x40,  //.%@@+..
    0x0f, 0xc0,  //..@@@..
    0x03, 0xf0,  //...@@@.
    0x00, 0xf8,  //....@@%
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x03, 0xf0,  //...@@@.
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+00ed (í) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0xbe,  //....%@@%
    0x01, 0xf8,  //...+@@%.
    0x07, 0xe0,  //..+@@%..
    0x0f, 0xc0,  //..@@@...
    0x3f, 0x00,  //.@@@....
    0xbc, 0x00,  //%@@.....
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x3f, 0x00,  //.@@@....
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00ee (î) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x03, 0xf0, 0x00,  //...@@@....
    0x0f, 0xfc, 0x00,  //..@@@@@...
    0x2f, 0x7e, 0x00,  //.%@@+@@%..
    0x3d, 0x1f, 0x00,  //.@@+.+@@..
    0xf8, 0x0b, 0xc0,  //@@%...%@@.
    0xf0, 0x03, 0xe0,  //@@.....@@%
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00ef (ï) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x03, 0xf0, 0x00,  //...@@@...
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00f0 (ð) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x01, 0xfd, 0x00, 0x00, 0x00,  //...+@@@+.........
    0x00, 0xbf, 0x40, 0xbc, 0x00,  //....%@@@+...%@@..
    0x00, 0x2f, 0xef, 0xf8, 0x00,  //.....%@@@%@@@@%..
    0x00, 0x0f, 0xfe, 0x40, 0x00,  //......@@@@@%+....
    0x01, 0xff, 0xfc, 0x00, 0x00,  //...+@@@@@@@......
    0x1f, 0xe5, 0xfe, 0x00, 0x00,  //.+@@@%++@@@%.....
    0x09, 0x00, 0x7f, 0x80, 0x00,  //..%+....+@@@%....
    0x00, 0x00, 0x1f, 0xd0, 0x00,  //.........+@@@+...
    0x00, 0x2f, 0xff, 0xf0, 0x00,  //.....%@@@@@@@@...
    0x02, 0xff, 0xff, 0xfc, 0x00,  //...%@@@@@@@@@@@..
    0x0b, 0xff, 0xff, 0xfd, 0x00,  //..%@@@@@@@@@@@@+.
    0x1f, 0xf4, 0x01, 0xff, 0x00,  //.+@@@@+....+@@@@.
    0x3f, 0x80, 0x00, 0x3f, 0x40,  //.@@@%........@@@+
    0x7f, 0x00, 0x00, 0x2f, 0x80,  //+@@@.........%@@%
    0xbd, 0x00, 0x00, 0x1f, 0xc0,  //%@@+.........+@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xbd, 0x00, 0x00, 0x1f, 0x80,  //%@@+.........+@@%
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@@.........@@@+
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x1f, 0xf4, 0x07, 0xfd, 0x00,  //.+@@@@+...+@@@@+.
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x01, 0xff, 0xff, 0xd0, 0x00,  //...+@@@@@@@@@+...
    0x00, 0x2f, 0xfd, 0x00, 0x00,  //.....+@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f1 (ñ) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x7e, 0x00, 0xf0,  //....+@@%....@@..
    0x00, 0xff, 0xc0, 0xf0,  //....@@@@@...@@..
    0x02, 0xe3, 0xf2, 0xe0,  //...%@%.@@@.%@%..
    0x03, 0xc0, 0xff, 0xc0,  //...@@...@@@@@...
    0x03, 0xc0, 0x2f, 0x40,  //...@@....%@@+...
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xfc, 0x0b, 0xfe, 0x40,  //@@@...%@@@@%+...
    0xfc, 0x7f, 0xff, 0xe0,  //@@@.+@@@@@@@@%..
    0xfe, 0xff, 0xff, 0xf8,  //@@@%@@@@@@@@@@%.
    0xff, 0xe4, 0x07, 0xfc,  //@@@@@%+...+@@@@.
    0xff, 0x40, 0x00, 0xfe,  //@@@@+.......@@@%
    0xfe, 0x00, 0x00, 0x7f,  //@@@%........+@@@
    0xfd, 0x00, 0x00, 0x3f,  //@@@+.........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00f2 (ò) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x02, 0xf8, 0x00, 0x00, 0x00,  //...%@@%..........
    0x00, 0xbd, 0x00, 0x00, 0x00,  //....%@@+.........
    0x00, 0x2f, 0x40, 0x00, 0x00,  //.....%@@+........
    0x00, 0x0f, 0xc0, 0x00, 0x00,  //......@@@........
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0xf8, 0x00, 0x00,  //........@@%......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x1f, 0xf4, 0x07, 0xfd, 0x00,  //.+@@@@+...+@@@@+.
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@@.........@@@+
    0xbd, 0x00, 0x00, 0x2f, 0x80,  //%@@+.........+@@%
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xbd, 0x00, 0x00, 0x1f, 0x80,  //%@@+.........+@@%
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@@.........@@@+
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x1f, 0xf4, 0x07, 0xfd, 0x00,  //.+@@@@+...+@@@@+.
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f3 (ó) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x0b, 0xe0, 0x00,  //..........%@@%...
    0x00, 0x00, 0x1f, 0x80, 0x00,  //.........+@@%....
    0x00, 0x00, 0x7e, 0x00, 0x00,  //........+@@%.....
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x0b, 0xc0, 0x00, 0x00,  //......%@@........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x1f, 0xf4, 0x07, 0xfd, 0x00,  //.+@@@@+...+@@@@+.
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@@.........@@@+
    0xbd, 0x00, 0x00, 0x2f, 0x80,  //%@@+.........+@@%
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xbd, 0x00, 0x00, 0x1f, 0x80,  //%@@+.........+@@%
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@@.........@@@+
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x1f, 0xf4, 0x07, 0xfd, 0x00,  //.+@@@@+...+@@@@+.
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f4 (ô) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x2f, 0x7e, 0x00, 0x00,  //.....%@@+@@%.....
    0x00, 0x3d, 0x1f, 0x00, 0x00,  //.....@@+.+@@.....
    0x00, 0xf8, 0x0b, 0xc0, 0x00,  //....@@%...%@@....
    0x02, 0xf0, 0x03, 0xe0, 0x00,  //...%@@.....@@%...
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x1f, 0xf4, 0x07, 0xfd, 0x00,  //.+@@@@+...+@@@@+.
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@@.........@@@+
    0xbd, 0x00, 0x00, 0x2f, 0x80,  //%@@+.........+@@%
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xbd, 0x00, 0x00, 0x1f, 0x80,  //%@@+.........+@@%
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@@.........@@@+
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x1f, 0xf4, 0x07, 0xfd, 0x00,  //.+@@@@+...+@@@@+.
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f5 (õ) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x7e, 0x00, 0xf0, 0x00,  //....+@@%....@@...
    0x00, 0xff, 0xc0, 0xf0, 0x00,  //....@@@@@...@@...
    0x02, 0xe3, 0xf2, 0xe0, 0x00,  //...%@%.@@@.%@%...
    0x03, 0xc0, 0xff, 0xc0, 0x00,  //...@@...@@@@@....
    0x03, 0xc0, 0x2f, 0x40, 0x00,  //...@@....%@@+....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x1f, 0xf4, 0x07, 0xfd, 0x00,  //.+@@@@+...+@@@@+.
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@@.........@@@+
    0xbd, 0x00, 0x00, 0x2f, 0x80,  //%@@+.........+@@%
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xbd, 0x00, 0x00, 0x1f, 0x80,  //%@@+.........+@@%
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@@.........@@@+
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x1f, 0xf4, 0x07, 0xfd, 0x00,  //.+@@@@+...+@@@@+.
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f6 (ö) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0xfc, 0x0f, 0xc0, 0x00,  //....@@@...@@@....
    0x00, 0xfc, 0x0f, 0xc0, 0x00,  //....@@@...@@@....
    0x00, 0xfc, 0x0f, 0xc0, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x1f, 0xf4, 0x07, 0xfd, 0x00,  //.+@@@@+...+@@@@+.
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@@.........@@@+
    0xbd, 0x00, 0x00, 0x2f, 0x80,  //%@@+.........+@@%
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xbd, 0x00, 0x00, 0x1f, 0x80,  //%@@+.........+@@%
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@@.........@@@+
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x1f, 0xf4, 0x07, 0xfd, 0x00,  //.+@@@@+...+@@@@+.
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f7 (÷) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+00f8 (ø) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x60,  //................+%.
    0x00, 0x0b, 0xff, 0x40, 0xf4,  //......+@@@@@+...@@+
    0x00, 0xbf, 0xff, 0xf6, 0xf0,  //....%@@@@@@@@@+%@@.
    0x02, 0xff, 0xff, 0xff, 0xc0,  //...%@@@@@@@@@@@@@..
    0x07, 0xfd, 0x01, 0xff, 0x80,  //..+@@@@+...+@@@@%..
    0x0f, 0xe0, 0x00, 0x3f, 0xc0,  //..@@@%.......@@@@..
    0x1f, 0xc0, 0x00, 0xff, 0xd0,  //.+@@@.......@@@@@+.
    0x2f, 0x80, 0x03, 0xe7, 0xe0,  //.%@@%......@@%+@@%.
    0x3f, 0x00, 0x0f, 0x83, 0xf0,  //.@@@......@@%..@@@.
    0x3f, 0x00, 0x3f, 0x03, 0xf0,  //.@@@.....@@@...@@@.
    0x3f, 0x00, 0xfc, 0x03, 0xf0,  //.@@@....@@@....@@@.
    0x3f, 0x03, 0xf0, 0x03, 0xf0,  //.@@@...@@@.....@@@.
    0x3f, 0x0b, 0xc0, 0x03, 0xf0,  //.@@@..%@@......@@@.
    0x2f, 0x6f, 0x00, 0x07, 0xe0,  //.%@@+%@@......+@@%.
    0x1f, 0xfc, 0x00, 0x0f, 0xd0,  //.+@@@@@.......@@@+.
    0x0f, 0xf0, 0x00, 0x2f, 0xc0,  //..@@@@.......%@@@..
    0x07, 0xfd, 0x01, 0xff, 0x40,  //..+@@@@+...+@@@@+..
    0x0f, 0xff, 0xff, 0xfe, 0x00,  //..@@@@@@@@@@@@@%...
    0x2e, 0x7f, 0xff, 0xf8, 0x00,  //.%@%+@@@@@@@@@%....
    0x7c, 0x0b, 0xff, 0x80, 0x00,  //+@@...+@@@@@%......
    0x34, 0x00, 0x00, 0x00, 0x00,  //.@.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00f9 (ù) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x0b, 0xe0, 0x00, 0x00,  //..%@@%..........
    0x02, 0xf4, 0x00, 0x00,  //...%@@+.........
    0x00, 0xbd, 0x00, 0x00,  //....%@@+........
    0x00, 0x3f, 0x00, 0x00,  //.....@@@........
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.......
    0x00, 0x03, 0xe0, 0x00,  //.......@@%......
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfd, 0x00, 0x00, 0xbf,  //@@@+........%@@@
    0xbf, 0x00, 0x01, 0xff,  //%@@@.......+@@@@
    0x3f, 0xd0, 0x1b, 0xff,  //.@@@@+...+%@@@@@
    0x2f, 0xff, 0xff, 0xbf,  //.%@@@@@@@@@@%@@@
    0x0b, 0xff, 0xfd, 0x3f,  //..%@@@@@@@@+.@@@
    0x01, 0xbf, 0xe0, 0x3f,  //...+%@@@@%...@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00fa (ú) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x2f, 0x80,  //.........%@@%...
    0x00, 0x00, 0x7e, 0x00,  //........+@@%....
    0x00, 0x01, 0xf8, 0x00,  //.......+@@%.....
    0x00, 0x03, 0xf0, 0x00,  //.......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.......
    0x00, 0x2f, 0x00, 0x00,  //.....%@@........
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfd, 0x00, 0x00, 0xbf,  //@@@+........%@@@
    0xbf, 0x00, 0x01, 0xff,  //%@@@.......+@@@@
    0x3f, 0xd0, 0x1b, 0xff,  //.@@@@+...+%@@@@@
    0x2f, 0xff, 0xff, 0xbf,  //.%@@@@@@@@@@%@@@
    0x0b, 0xff, 0xfd, 0x3f,  //..%@@@@@@@@+.@@@
    0x01, 0xbf, 0xe0, 0x3f,  //...+%@@@@%...@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00fb (û) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x07, 0xd0, 0x00,  //......+@@+......
    0x00, 0x0f, 0xf0, 0x00,  //......@@@@......
    0x00, 0x3e, 0xbc, 0x00,  //.....%@%%@%.....
    0x00, 0x7c, 0x3d, 0x00,  //....+@@..@@+....
    0x00, 0xf4, 0x1f, 0x00,  //....@@+..+@@....
    0x02, 0xe0, 0x0b, 0x80,  //...%@%....%@%...
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfd, 0x00, 0x00, 0xbf,  //@@@+........%@@@
    0xbf, 0x00, 0x01, 0xff,  //%@@@.......+@@@@
    0x3f, 0xd0, 0x1b, 0xff,  //.@@@@+...+%@@@@@
    0x2f, 0xff, 0xff, 0xbf,  //.%@@@@@@@@@@%@@@
    0x0b, 0xff, 0xfd, 0x3f,  //..%@@@@@@@@+.@@@
    0x01, 0xbf, 0xe0, 0x3f,  //...+%@@@@%...@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00fc (ü) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0xfc, 0x3f, 0x00,  //....@@@..@@@....
    0x00, 0xfc, 0x3f, 0x00,  //....@@@..@@@....
    0x00, 0xfc, 0x3f, 0x00,  //....@@@..@@@....
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfd, 0x00, 0x00, 0xbf,  //@@@+........%@@@
    0xbf, 0x00, 0x01, 0xff,  //%@@@.......+@@@@
    0x3f, 0xd0, 0x1b, 0xff,  //.@@@@+...+%@@@@@
    0x2f, 0xff, 0xff, 0xbf,  //.%@@@@@@@@@@%@@@
    0x0b, 0xff, 0xfd, 0x3f,  //..%@@@@@@@@+.@@@
    0x01, 0xbf, 0xe0, 0x3f,  //...+%@@@@%...@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00fd (ý) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x02, 0xf8, 0x00,  //...........%@@%...
    0x00, 0x00, 0x07, 0xe0, 0x00,  //..........+@@%....
    0x00, 0x00, 0x1f, 0x80, 0x00,  //.........+@@%.....
    0x00, 0x00, 0x3f, 0x00, 0x00,  //.........@@@......
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@.......
    0x00, 0x02, 0xf0, 0x00, 0x00,  //.......%@@........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xfd, 0x00, 0x00, 0x07, 0xf0,  //@@@+..........+@@@
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........@@@+
    0x3f, 0x40, 0x00, 0x0f, 0xc0,  //.@@@+.........@@@.
    0x2f, 0x80, 0x00, 0x2f, 0x80,  //.%@@%........%@@%.
    0x0f, 0xc0, 0x00, 0x3f, 0x00,  //..@@@........@@@..
    0x0b, 0xe0, 0x00, 0x7f, 0x00,  //..%@@%......+@@@..
    0x07, 0xf0, 0x00, 0xfd, 0x00,  //..+@@@......@@@+..
    0x03, 0xf4, 0x00, 0xfc, 0x00,  //...@@@+.....@@@...
    0x01, 0xfc, 0x02, 0xf8, 0x00,  //...+@@@....%@@%...
    0x00, 0xfc, 0x03, 0xf4, 0x00,  //....@@@....@@@+...
    0x00, 0xbe, 0x07, 0xf0, 0x00,  //....%@@%..+@@@....
    0x00, 0x3f, 0x0b, 0xd0, 0x00,  //.....@@@..%@@+....
    0x00, 0x3f, 0x4f, 0xc0, 0x00,  //.....@@@+.@@@.....
    0x00, 0x1f, 0xef, 0x80, 0x00,  //.....+@@@%@@%.....
    0x00, 0x0f, 0xff, 0x40, 0x00,  //......@@@@@@+.....
    0x00, 0x0b, 0xff, 0x00, 0x00,  //......%@@@@@......
    0x00, 0x03, 0xfe, 0x00, 0x00,  //.......@@@@+......
    0x00, 0x03, 0xfc, 0x00, 0x00,  //.......%@@@.......
    0x00, 0x02, 0xf8, 0x00, 0x00,  //.......%@@%.......
    0x00, 0x03, 0xf4, 0x00, 0x00,  //.......@@@+.......
    0x00, 0x07, 0xf0, 0x00, 0x00,  //......+@@@........
    0x00, 0x0f, 0xe0, 0x00, 0x00,  //......%@@%........
    0x00, 0x2f, 0xc0, 0x00, 0x00,  //.....%@@@.........
    0x0f, 0xff, 0x80, 0x00, 0x00,  //..@@@@@@%.........
    0x0f, 0xff, 0x00, 0x00, 0x00,  //..@@@@@@..........
    0x0f, 0xf8, 0x00, 0x00, 0x00,  //..@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00fe (þ) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x0b, 0xfe, 0x00, 0x00,  //@@@...%@@@@%.....
    0xfc, 0xbf, 0xff, 0xe0, 0x00,  //@@@.%@@@@@@@@%...
    0xfe, 0xff, 0xff, 0xf8, 0x00,  //@@@%@@@@@@@@@@%..
    0xff, 0xf4, 0x07, 0xfd, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0x80, 0x00, 0xbf, 0x00,  //@@@@%.......%@@@.
    0xff, 0x00, 0x00, 0x3f, 0x40,  //@@@@.........@@@+
    0xfd, 0x00, 0x00, 0x1f, 0x80,  //@@@+.........+@@%
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfd, 0x00, 0x00, 0x1f, 0x80,  //@@@+.........+@@%
    0xff, 0x00, 0x00, 0x3f, 0x40,  //@@@@.........@@@+
    0xff, 0x80, 0x00, 0xbf, 0x00,  //@@@@%.......%@@@.
    0xff, 0xf4, 0x07, 0xfd, 0x00,  //@@@@@@+...+@@@@+.
    0xfe, 0xff, 0xff, 0xf8, 0x00,  //@@@%@@@@@@@@@@%..
    0xfc, 0xbf, 0xff, 0xe0, 0x00,  //@@@.%@@@@@@@@%...
    0xfc, 0x0b, 0xfe, 0x00, 0x00,  //@@@...%@@@@%.....
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00ff (ÿ) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x3f, 0x0f, 0xc0, 0x00,  //.....@@@..@@@.....
    0x00, 0x3f, 0x0f, 0xc0, 0x00,  //.....@@@..@@@.....
    0x00, 0x3f, 0x0f, 0xc0, 0x00,  //.....@@@..@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xfd, 0x00, 0x00, 0x07, 0xf0,  //@@@+..........+@@@
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........@@@+
    0x3f, 0x40, 0x00, 0x0f, 0xc0,  //.@@@+.........@@@.
    0x2f, 0x80, 0x00, 0x2f, 0x80,  //.%@@%........%@@%.
    0x0f, 0xc0, 0x00, 0x3f, 0x00,  //..@@@........@@@..
    0x0b, 0xe0, 0x00, 0x7f, 0x00,  //..%@@%......+@@@..
    0x07, 0xf0, 0x00, 0xfd, 0x00,  //..+@@@......@@@+..
    0x03, 0xf4, 0x00, 0xfc, 0x00,  //...@@@+.....@@@...
    0x01, 0xfc, 0x02, 0xf8, 0x00,  //...+@@@....%@@%...
    0x00, 0xfc, 0x03, 0xf4, 0x00,  //....@@@....@@@+...
    0x00, 0xbe, 0x07, 0xf0, 0x00,  //....%@@%..+@@@....
    0x00, 0x3f, 0x0b, 0xd0, 0x00,  //.....@@@..%@@+....
    0x00, 0x3f, 0x4f, 0xc0, 0x00,  //.....@@@+.@@@.....
    0x00, 0x1f, 0xef, 0x80, 0x00,  //.....+@@@%@@%.....
    0x00, 0x0f, 0xff, 0x40, 0x00,  //......@@@@@@+.....
    0x00, 0x0b, 0xff, 0x00, 0x00,  //......%@@@@@......
    0x00, 0x03, 0xfe, 0x00, 0x00,  //.......@@@@+......
    0x00, 0x03, 0xfc, 0x00, 0x00,  //.......%@@@.......
    0x00, 0x02, 0xf8, 0x00, 0x00,  //.......%@@%.......
    0x00, 0x03, 0xf4, 0x00, 0x00,  //.......@@@+.......
    0x00, 0x07, 0xf0, 0x00, 0x00,  //......+@@@........
    0x00, 0x0f, 0xe0, 0x00, 0x00,  //......%@@%........
    0x00, 0x2f, 0xc0, 0x00, 0x00,  //.....%@@@.........
    0x0f, 0xff, 0x80, 0x00, 0x00,  //..@@@@@@%.........
    0x0f, 0xff, 0x00, 0x00, 0x00,  //..@@@@@@..........
    0x0f, 0xf8, 0x00, 0x00, 0x00,  //..@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................



#elif USE_LV_FONT_DEJAVU_40_LATIN_SUP == 4
    /*Unicode: U+00a0 ( ) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00a1 (¡) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xbf, 0xb0,  //%@%
    0xcf, 0xc0,  //@@@
    0xdf, 0xd0,  //@@@
    0xdf, 0xd0,  //@@@
    0xef, 0xe0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+00a2 (¢) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x16, 0xbe, 0xff, 0xec, 0xa6, 0x20,  //.....+%@@@@@%+.
    0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf0,  //...+@@@@@@@@@@@
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..%@@@@@@@@@@@@
    0x05, 0xff, 0xfe, 0x62, 0xff, 0x02, 0x48, 0xd0,  //.+@@@@+.@@..+%@
    0x0e, 0xff, 0xc0, 0x00, 0xff, 0x00, 0x00, 0x00,  //.@@@@...@@.....
    0x5f, 0xfe, 0x10, 0x00, 0xff, 0x00, 0x00, 0x00,  //+@@@....@@.....
    0xaf, 0xf8, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //%@@%....@@.....
    0xdf, 0xf3, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //@@@.....@@.....
    0xef, 0xf0, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //@@@.....@@.....
    0xff, 0xf0, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //@@@.....@@.....
    0xef, 0xf0, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //@@@.....@@.....
    0xdf, 0xf3, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //@@@.....@@.....
    0xaf, 0xf8, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //%@@+....@@.....
    0x5f, 0xfe, 0x10, 0x00, 0xff, 0x00, 0x00, 0x00,  //+@@@....@@.....
    0x0e, 0xff, 0xb0, 0x00, 0xff, 0x00, 0x00, 0x00,  //.@@@%...@@.....
    0x05, 0xff, 0xfd, 0x62, 0xff, 0x02, 0x59, 0xd0,  //.+@@@@+.@@..+%@
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..%@@@@@@@@@@@@
    0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //...+@@@@@@@@@@@
    0x00, 0x00, 0x17, 0xbe, 0xff, 0xfd, 0xb6, 0x20,  //.....+%@@@@@%+.
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00a3 (£) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x04, 0x9d, 0xff, 0xeb, 0x62,  //........%@@@@%+.
    0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0xff, 0xff,  //......%@@@@@@@@@
    0x00, 0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....%@@@@@@@@@@
    0x00, 0x00, 0x2f, 0xff, 0xb4, 0x00, 0x13, 0x7d,  //.....@@@%+....+@
    0x00, 0x00, 0x8f, 0xfc, 0x00, 0x00, 0x00, 0x00,  //....%@@@........
    0x00, 0x00, 0xcf, 0xf5, 0x00, 0x00, 0x00, 0x00,  //....%@@+........
    0x00, 0x00, 0xef, 0xf2, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.@@@@@@@@@@@@...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.@@@@@@@@@@@@...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.@@@@@@@@@@@@...
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00a4 (¤) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x0a, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xc0,  //.%+............+%.
    0xaf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfb,  //%@@+..........+@@%
    0x5f, 0xff, 0x70, 0x4b, 0xff, 0xb4, 0x07, 0xff, 0xf4,  //+@@@+.+%@@%+.+@@@+
    0x06, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xcf, 0xff, 0x50,  //.+@@@@@@@@@@@@@@+.
    0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00,  //..+@@@@@@@@@@@@+..
    0x00, 0x0b, 0xff, 0xd4, 0x00, 0x4d, 0xff, 0xc0, 0x00,  //...%@@@+..+@@@@...
    0x00, 0x4f, 0xfd, 0x00, 0x00, 0x00, 0xdf, 0xf4, 0x00,  //..+@@@......@@@+..
    0x00, 0xbf, 0xf4, 0x00, 0x00, 0x00, 0x4f, 0xfb, 0x00,  //..%@@+......+@@%..
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //..@@@........@@@..
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //..@@@........@@@..
    0x00, 0xbf, 0xf4, 0x00, 0x00, 0x00, 0x4f, 0xfb, 0x00,  //..%@@+......+@@%..
    0x00, 0x4f, 0xfd, 0x00, 0x00, 0x00, 0xdf, 0xf3, 0x00,  //...@@@......@@@...
    0x00, 0x0c, 0xff, 0xd4, 0x00, 0x4d, 0xff, 0xb0, 0x00,  //...@@@@+..+@@@%...
    0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00,  //..+@@@@@@@@@@@@+..
    0x06, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xbf, 0xff, 0x50,  //.+@@@@@@@@@@%@@@+.
    0x5f, 0xff, 0x70, 0x4b, 0xff, 0xb3, 0x06, 0xff, 0xf4,  //+@@@+.+%@@%..+@@@+
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfa,  //%@@+..........+@@%
    0x0b, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xa0,  //.%+............+%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00a5 (¥) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xbf, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xb0,  //%@@%...........%@@%
    0x3f, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0x20,  //.@@@+.........+@@@.
    0x0a, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xfa, 0x00,  //.%@@@.........@@@%.
    0x01, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x06, 0xff, 0xf1, 0x00,  //..@@@+.......+@@@..
    0x00, 0x8f, 0xfe, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x80, 0x00,  //..%@@@.......@@@%..
    0x00, 0x1e, 0xff, 0x80, 0x00, 0x00, 0x8f, 0xfe, 0x00, 0x00,  //...@@@%.....%@@@...
    0x00, 0x07, 0xff, 0xf1, 0x00, 0x02, 0xff, 0xf7, 0x00, 0x00,  //...+@@@.....@@@+...
    0x00, 0x00, 0xef, 0xfa, 0x00, 0x0a, 0xff, 0xd0, 0x00, 0x00,  //....@@@%...%@@@....
    0x00, 0x00, 0x6f, 0xff, 0x30, 0x3f, 0xff, 0x50, 0x00, 0x00,  //....+@@@...@@@+....
    0x00, 0x00, 0x0d, 0xff, 0xc0, 0xcf, 0xfc, 0x00, 0x00, 0x00,  //.....@@@%.@@@@.....
    0x0f, 0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@%@@@@@@@@.
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x2f, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00,  //.......@@@@@.......
    0x00, 0x00, 0x00, 0x07, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00,  //.......+@@@+.......
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@@@@@.
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00a6 (¦) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+00a7 (§) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x03, 0x9d, 0xff, 0xeb, 0x72, 0x00,  //....%@@@@%+...
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@..
    0x05, 0xff, 0xe6, 0x10, 0x28, 0xff, 0x00,  //.+@@@+...%@@..
    0x0c, 0xff, 0x50, 0x00, 0x00, 0x1a, 0x00,  //.@@@+......%..
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@..........
    0x0e, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //.@@@+.........
    0x09, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00,  //.%@@@.........
    0x01, 0xef, 0xff, 0x60, 0x00, 0x00, 0x00,  //..@@@@+.......
    0x00, 0x2f, 0xff, 0xfc, 0x30, 0x00, 0x00,  //...@@@@@......
    0x03, 0xef, 0xef, 0xff, 0xf9, 0x10, 0x00,  //..@@@@@@@%....
    0x2f, 0xfd, 0x02, 0xbf, 0xff, 0xe5, 0x00,  //.@@@..%@@@@+..
    0xaf, 0xf4, 0x00, 0x04, 0xdf, 0xff, 0x80,  //%@@....+@@@@%.
    0xef, 0xf0, 0x00, 0x00, 0x09, 0xff, 0xf6,  //@@@......%@@@+
    0xff, 0xf3, 0x00, 0x00, 0x00, 0x9f, 0xfd,  //@@@.......%@@@
    0xbf, 0xfc, 0x00, 0x00, 0x00, 0x1f, 0xff,  //%@@@.......@@@
    0x3f, 0xff, 0xd3, 0x00, 0x00, 0x0f, 0xfd,  //.@@@@......@@@
    0x04, 0xef, 0xff, 0x91, 0x00, 0x6f, 0xf8,  //.+@@@@%...+@@%
    0x00, 0x1b, 0xff, 0xfe, 0x74, 0xff, 0xc0,  //...%@@@@++@@@.
    0x00, 0x00, 0x5d, 0xff, 0xff, 0xf9, 0x00,  //....+@@@@@@%..
    0x00, 0x00, 0x00, 0x7f, 0xff, 0xf4, 0x00,  //......+@@@@+..
    0x00, 0x00, 0x00, 0x02, 0xcf, 0xff, 0x30,  //........@@@@..
    0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xb0,  //.........@@@%.
    0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0,  //..........@@@.
    0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //..........@@@.
    0x0b, 0x20, 0x00, 0x00, 0x06, 0xff, 0xb0,  //.%.......+@@%.
    0x0f, 0xfa, 0x41, 0x02, 0x8f, 0xff, 0x30,  //.@@%+...+@@@..
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00,  //.@@@@@@@@@@+..
    0x02, 0x6a, 0xdf, 0xfe, 0xc8, 0x10, 0x00,  //..+%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00a8 (¨) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00a9 (©) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x49, 0xce, 0xfe, 0xc9, 0x40, 0x00, 0x00, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x00, 0x1c, 0xff, 0xc7, 0x31, 0x01, 0x37, 0xcf, 0xfc, 0x10, 0x00, 0x00,  //.....@@@@+.....+@@@@.....
    0x00, 0x03, 0xef, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x04, 0xdf, 0xe3, 0x00, 0x00,  //....@@@+.........+@@@....
    0x00, 0x1e, 0xfb, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xfe, 0x10, 0x00,  //...@@%.............%@@...
    0x00, 0xcf, 0xb0, 0x00, 0x17, 0xce, 0xfe, 0xc8, 0x20, 0x00, 0xbf, 0xc0, 0x00,  //..@@%....+@@@@@+....%@@..
    0x06, 0xfd, 0x10, 0x05, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x0d, 0xf6, 0x00,  //.+@@...+@@@@@@@@@....@@+.
    0x0e, 0xf5, 0x00, 0x5f, 0xff, 0x82, 0x00, 0x26, 0xc0, 0x00, 0x04, 0xfe, 0x00,  //.@@+..+@@@%....+@....+@@.
    0x5f, 0xc0, 0x01, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x40,  //+@@...@@@+............@@+
    0x9f, 0x70, 0x08, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x90,  //%@+..+@@%.............+@%
    0xdf, 0x30, 0x0c, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc0,  //@@...@@@...............@@
    0xef, 0x10, 0x0e, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xe0,  //@@...@@@...............@@
    0xff, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@...@@@...............@@
    0xef, 0x10, 0x0e, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xe0,  //@@...@@@...............@@
    0xdf, 0x30, 0x0c, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc0,  //@@...@@@...............@@
    0x9f, 0x70, 0x07, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x90,  //%@+..+@@%.............+@%
    0x5f, 0xc0, 0x01, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x40,  //+@@...@@@+............@@+
    0x0e, 0xf5, 0x00, 0x5f, 0xff, 0x93, 0x00, 0x26, 0xc0, 0x00, 0x04, 0xfe, 0x00,  //.@@+..+@@@%....+@....+@@.
    0x06, 0xfd, 0x10, 0x05, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x0d, 0xf6, 0x00,  //.+@@...+@@@@@@@@@....@@+.
    0x00, 0xcf, 0xc0, 0x00, 0x17, 0xce, 0xfe, 0xc9, 0x30, 0x00, 0xbf, 0xc0, 0x00,  //..@@%....+@@@@@%....%@@..
    0x00, 0x1e, 0xfc, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xfe, 0x10, 0x00,  //...@@%.............%@@...
    0x00, 0x03, 0xef, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x04, 0xdf, 0xe3, 0x00, 0x00,  //....@@@+.........+@@@....
    0x00, 0x00, 0x1c, 0xff, 0xc7, 0x31, 0x01, 0x37, 0xcf, 0xfc, 0x10, 0x00, 0x00,  //.....@@@@+.....+@@@@.....
    0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x49, 0xce, 0xfe, 0xc9, 0x40, 0x00, 0x00, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+00aa (ª) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x02, 0x7b, 0xef, 0xfd, 0x93, 0x00, 0x00,  //..+%@@@@%....
    0x0f, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00,  //.@@@@@@@@@+..
    0x0c, 0x73, 0x00, 0x27, 0xff, 0xf3, 0x00,  //.@+....+@@@..
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xfa, 0x00,  //........+@@%.
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xfd, 0x00,  //.........@@@.
    0x00, 0x4a, 0xdf, 0xff, 0xff, 0xff, 0x00,  //..+%@@@@@@@@.
    0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.%@@@@@@@@@@.
    0x7f, 0xfe, 0x51, 0x00, 0x0f, 0xff, 0x00,  //+@@@+....@@@.
    0xdf, 0xf3, 0x00, 0x00, 0x2f, 0xff, 0x00,  //@@@......@@@.
    0xff, 0xf0, 0x00, 0x00, 0x5f, 0xff, 0x00,  //@@@.....+@@@.
    0xef, 0xf3, 0x00, 0x00, 0xdf, 0xff, 0x00,  //@@@.....@@@@.
    0xaf, 0xfd, 0x30, 0x2b, 0xff, 0xff, 0x00,  //%@@@...%@@@@.
    0x2e, 0xff, 0xff, 0xff, 0x6f, 0xff, 0x00,  //.@@@@@@@+@@@.
    0x01, 0xae, 0xfe, 0xa3, 0x0f, 0xff, 0x00,  //..%@@@%..@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //%@@@@@@@@@@@.
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //%@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00ab («) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x90,  //.......%......%
    0x00, 0x00, 0x00, 0xbf, 0x00, 0x00, 0x0b, 0xf0,  //......%@.....%@
    0x00, 0x00, 0x1c, 0xfe, 0x00, 0x01, 0xcf, 0xe0,  //.....@@@....@@@
    0x00, 0x03, 0xef, 0xd2, 0x00, 0x3e, 0xfd, 0x20,  //....@@@....@@@.
    0x00, 0x4f, 0xfb, 0x00, 0x04, 0xff, 0xb0, 0x00,  //..+@@%...+@@%..
    0x07, 0xff, 0x90, 0x00, 0x7f, 0xf9, 0x00, 0x00,  //.+@@%...+@@%...
    0x9f, 0xf7, 0x00, 0x09, 0xff, 0x70, 0x00, 0x00,  //%@@+...%@@+....
    0xff, 0x90, 0x00, 0x0f, 0xf9, 0x00, 0x00, 0x00,  //@@%....@@%.....
    0x9f, 0xf7, 0x00, 0x09, 0xff, 0x70, 0x00, 0x00,  //%@@+...%@@+....
    0x07, 0xff, 0x90, 0x00, 0x7f, 0xf9, 0x00, 0x00,  //.+@@%...+@@%...
    0x00, 0x4f, 0xfb, 0x00, 0x04, 0xff, 0xb0, 0x00,  //..+@@%...+@@%..
    0x00, 0x03, 0xef, 0xd2, 0x00, 0x3e, 0xfd, 0x20,  //....@@@....@@@.
    0x00, 0x00, 0x1d, 0xfe, 0x00, 0x01, 0xdf, 0xe0,  //.....@@@....@@@
    0x00, 0x00, 0x00, 0xbf, 0x00, 0x00, 0x0b, 0xf0,  //......%@.....%@
    0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x90,  //.......%......%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00ac (¬) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+00ad (­) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00ae (®) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x49, 0xce, 0xfe, 0xc9, 0x40, 0x00, 0x00, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x00, 0x1c, 0xff, 0xc7, 0x31, 0x01, 0x37, 0xcf, 0xfc, 0x10, 0x00, 0x00,  //.....@@@@+.....+@@@@.....
    0x00, 0x03, 0xef, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x04, 0xdf, 0xe3, 0x00, 0x00,  //....@@@+.........+@@@....
    0x00, 0x1e, 0xfb, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xfe, 0x10, 0x00,  //...@@%.............%@@...
    0x00, 0xcf, 0xb0, 0x00, 0xff, 0xff, 0xff, 0xd9, 0x20, 0x00, 0xbf, 0xc0, 0x00,  //..@@%...@@@@@@@%....%@@..
    0x06, 0xfd, 0x10, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x0d, 0xf6, 0x00,  //.+@@....@@@@@@@@@....@@+.
    0x0e, 0xf5, 0x00, 0x00, 0xff, 0xf0, 0x01, 0x9f, 0xfb, 0x00, 0x04, 0xfe, 0x00,  //.@@+....@@@...%@@%...+@@.
    0x5f, 0xc0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x1f, 0xff, 0x00, 0x00, 0xcf, 0x40,  //+@@.....@@@....@@@....@@+
    0x9f, 0x70, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x1f, 0xfe, 0x00, 0x00, 0x7f, 0x90,  //%@+.....@@@....@@@....+@%
    0xdf, 0x30, 0x00, 0x00, 0xff, 0xf0, 0x01, 0x9f, 0xf9, 0x00, 0x00, 0x3f, 0xc0,  //@@......@@@...%@@%.....@@
    0xef, 0x10, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x1f, 0xe0,  //@@......@@@@@@@@%......@@
    0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xd3, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@......@@@@@@@........@@
    0xef, 0x10, 0x00, 0x00, 0xff, 0xf0, 0x3e, 0xf7, 0x00, 0x00, 0x00, 0x1f, 0xe0,  //@@......@@@..@@+.......@@
    0xdf, 0x30, 0x00, 0x00, 0xff, 0xf0, 0x07, 0xff, 0x20, 0x00, 0x00, 0x3f, 0xc0,  //@@......@@@..+@@.......@@
    0x9f, 0x70, 0x00, 0x00, 0xff, 0xf0, 0x00, 0xff, 0xb0, 0x00, 0x00, 0x7f, 0x90,  //%@+.....@@@...@@%.....+@%
    0x5f, 0xc0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x8f, 0xf3, 0x00, 0x00, 0xcf, 0x40,  //+@@.....@@@...%@@.....@@+
    0x0e, 0xf5, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x1f, 0xfb, 0x00, 0x04, 0xfe, 0x00,  //.@@+....@@@....@@%...+@@.
    0x06, 0xfd, 0x10, 0x00, 0xff, 0xf0, 0x00, 0x08, 0xff, 0x30, 0x0d, 0xf6, 0x00,  //.+@@....@@@....%@@...@@+.
    0x00, 0xcf, 0xc0, 0x00, 0xff, 0xf0, 0x00, 0x01, 0xff, 0xb0, 0xbf, 0xc0, 0x00,  //..@@%...@@@.....@@%.%@@..
    0x00, 0x1e, 0xfc, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xfe, 0x10, 0x00,  //...@@%.............%@@...
    0x00, 0x03, 0xef, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x04, 0xdf, 0xe3, 0x00, 0x00,  //....@@@+.........+@@@....
    0x00, 0x00, 0x1c, 0xff, 0xc7, 0x31, 0x01, 0x37, 0xcf, 0xfc, 0x10, 0x00, 0x00,  //.....@@@@+.....+@@@@.....
    0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x49, 0xce, 0xfe, 0xc9, 0x40, 0x00, 0x00, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+00af (¯) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00b0 (°) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x29, 0xef, 0xe9, 0x20, 0x00,  //...%@@@%...
    0x04, 0xff, 0xff, 0xff, 0xf4, 0x00,  //.+@@@@@@@+.
    0x2f, 0xfa, 0x20, 0x2a, 0xff, 0x20,  //.@@%...%@@.
    0x9f, 0xa0, 0x00, 0x00, 0xaf, 0x90,  //%@%.....%@%
    0xef, 0x20, 0x00, 0x00, 0x2f, 0xe0,  //@@.......@@
    0xff, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@.......@@
    0xef, 0x20, 0x00, 0x00, 0x2f, 0xe0,  //@@.......@@
    0xaf, 0xa0, 0x00, 0x00, 0xaf, 0x90,  //%@%.....%@%
    0x2f, 0xfa, 0x20, 0x2a, 0xff, 0x20,  //.@@%...%@@.
    0x05, 0xff, 0xff, 0xff, 0xf4, 0x00,  //.+@@@@@@@+.
    0x00, 0x2a, 0xef, 0xe9, 0x20, 0x00,  //...%@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00b1 (±) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+00b2 (²) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x27, 0xbe, 0xfe, 0xc7, 0x00,  //.+%@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xd1,  //@@@@@@@@@.
    0xd8, 0x31, 0x01, 0x6e, 0xfa,  //@+....+@@%
    0x00, 0x00, 0x00, 0x04, 0xff,  //.......+@@
    0x00, 0x00, 0x00, 0x01, 0xfe,  //........@@
    0x00, 0x00, 0x00, 0x08, 0xf7,  //.......%@+
    0x00, 0x00, 0x00, 0x6f, 0xd0,  //......+@@.
    0x00, 0x00, 0x06, 0xfe, 0x20,  //.....+@@..
    0x00, 0x00, 0x8f, 0xf3, 0x00,  //....%@@...
    0x00, 0x0b, 0xff, 0x40, 0x00,  //...%@@+...
    0x02, 0xdf, 0xe3, 0x00, 0x00,  //..@@@.....
    0x5f, 0xfc, 0x10, 0x00, 0x00,  //+@@@......
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00b3 (³) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x27, 0xbe, 0xff, 0xd8, 0x20,  //.+%@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@+
    0xd7, 0x31, 0x01, 0x3a, 0xfd,  //@+.....%@@
    0x00, 0x00, 0x00, 0x01, 0xff,  //........@@
    0x00, 0x00, 0x00, 0x3a, 0xf9,  //.......%@%
    0x00, 0x0f, 0xff, 0xff, 0x80,  //...@@@@@%.
    0x00, 0x0f, 0xff, 0xff, 0xa0,  //...@@@@@%.
    0x00, 0x00, 0x01, 0x5e, 0xf8,  //......+@@+
    0x00, 0x00, 0x00, 0x04, 0xfd,  //.......+@@
    0x00, 0x00, 0x00, 0x00, 0xff,  //........@@
    0x00, 0x00, 0x00, 0x04, 0xfe,  //.......+@@
    0xc5, 0x20, 0x02, 0x7e, 0xf8,  //%+....+@@%
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@%.
    0x28, 0xdf, 0xfe, 0xb5, 0x00,  //.%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00b4 (´) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0xbf, 0xf8,  //....%@@%
    0x00, 0x07, 0xff, 0xa0,  //...+@@%.
    0x00, 0x4f, 0xfb, 0x00,  //..+@@%..
    0x01, 0xef, 0xc0, 0x00,  //..@@@...
    0x0c, 0xfd, 0x10, 0x00,  //.@@@....
    0x9f, 0xe1, 0x00, 0x00,  //%@@.....
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00b5 (µ) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@..........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@..........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@..........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@..........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@..........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@..........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@..........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@..........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@..........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@..........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@..........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@..........@@@..
    0xff, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x00,  //@@@..........@@@..
    0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x00,  //@@@+........+@@@..
    0xff, 0xfd, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0x00,  //@@@@........@@@@..
    0xff, 0xff, 0xd5, 0x10, 0x02, 0x8f, 0xff, 0xff, 0x40,  //@@@@@+....+@@@@@+.
    0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xcb, 0xff, 0xff,  //@@@%@@@@@@@@@%@@@@
    0xff, 0xf1, 0xdf, 0xff, 0xff, 0xfd, 0x16, 0xff, 0xff,  //@@@.@@@@@@@@.+@@@@
    0xff, 0xf0, 0x07, 0xcf, 0xfc, 0x70, 0x00, 0x9f, 0xd6,  //@@@..+@@@@+...%@@+
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00b6 (¶) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x5a, 0xde, 0xff, 0xff, 0xff, 0xf0,  //....+%@@@@@@@@@
    0x00, 0x3d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //...@@@@@@@@@@@@
    0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xf0,  //.+@@@@@@@@...@@
    0x1f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xf0,  //.@@@@@@@@@...@@
    0x8f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xf0,  //%@@@@@@@@@...@@
    0xdf, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xf0,  //@@@@@@@@@@...@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xf0,  //@@@@@@@@@@...@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xf0,  //@@@@@@@@@@...@@
    0xdf, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xf0,  //@@@@@@@@@@...@@
    0x8f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xf0,  //%@@@@@@@@@...@@
    0x1f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xf0,  //.@@@@@@@@@...@@
    0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xf0,  //.+@@@@@@@@...@@
    0x00, 0x2c, 0xff, 0xff, 0xff, 0x00, 0x0f, 0xf0,  //...@@@@@@@...@@
    0x00, 0x00, 0x38, 0xce, 0xff, 0x00, 0x0f, 0xf0,  //.....%@@@@...@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x0f, 0xf0,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x0f, 0xf0,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x0f, 0xf0,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x0f, 0xf0,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x0f, 0xf0,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x0f, 0xf0,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x0f, 0xf0,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x0f, 0xf0,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x0f, 0xf0,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x0f, 0xf0,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x0f, 0xf0,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x0f, 0xf0,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x0f, 0xf0,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x0f, 0xf0,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00b7 (·) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+00b8 (¸) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x0c, 0xf6, 0x00,  //...@@+.
    0x00, 0x06, 0xff, 0x20,  //...+@@.
    0x00, 0x01, 0xff, 0xb0,  //....@@%
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x92, 0x07, 0xff, 0xe0,  //%..+@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@%
    0xbe, 0xff, 0xc6, 0x00,  //%@@@@+.
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00b9 (¹) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x27, 0xcf, 0xf0, 0x00,  //.+@@@...
    0xff, 0xff, 0xf0, 0x00,  //@@@@@...
    0xd7, 0x2f, 0xf0, 0x00,  //@+.@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00ba (º) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x05, 0xbe, 0xfe, 0xb5, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xb0, 0x00,  //..%@@@@@@@%..
    0x0b, 0xff, 0xc2, 0x02, 0xbf, 0xfb, 0x00,  //.%@@%...%@@%.
    0x4f, 0xfe, 0x00, 0x00, 0x0d, 0xff, 0x40,  //+@@@.....@@@+
    0xaf, 0xf7, 0x00, 0x00, 0x07, 0xff, 0xa0,  //%@@+.....+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xdf, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xaf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xa0,  //%@@+.....+@@%
    0x4f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x40,  //+@@@.....@@@+
    0x0b, 0xff, 0xb2, 0x02, 0xbf, 0xfb, 0x00,  //.%@@%...%@@%.
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xc1, 0x00,  //..%@@@@@@@@..
    0x00, 0x05, 0xbe, 0xfe, 0xb5, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //.@@@@@@@@@@@.
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //.@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00bb (») , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x90, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00,  //%......%.......
    0xfb, 0x00, 0x00, 0x0f, 0xb0, 0x00, 0x00, 0x00,  //@%.....@%......
    0xef, 0xc1, 0x00, 0x0e, 0xfc, 0x10, 0x00, 0x00,  //@@@....@@@.....
    0x2d, 0xfe, 0x30, 0x02, 0xdf, 0xe3, 0x00, 0x00,  //.@@@....@@@....
    0x01, 0xbf, 0xf4, 0x00, 0x1b, 0xff, 0x40, 0x00,  //..%@@+...%@@+..
    0x00, 0x09, 0xff, 0x70, 0x00, 0x9f, 0xf7, 0x00,  //...%@@+...%@@+.
    0x00, 0x00, 0x7f, 0xf9, 0x00, 0x07, 0xff, 0x90,  //....+@@%...+@@%
    0x00, 0x00, 0x09, 0xff, 0x00, 0x00, 0x9f, 0xf0,  //.....%@@....%@@
    0x00, 0x00, 0x7f, 0xf9, 0x00, 0x07, 0xff, 0x90,  //....+@@%...+@@%
    0x00, 0x09, 0xff, 0x70, 0x00, 0x9f, 0xf7, 0x00,  //...%@@+...%@@+.
    0x00, 0xbf, 0xf4, 0x00, 0x0b, 0xff, 0x40, 0x00,  //..%@@+...%@@+..
    0x2d, 0xfe, 0x30, 0x02, 0xdf, 0xe3, 0x00, 0x00,  //.@@@....@@@....
    0xef, 0xc1, 0x00, 0x0e, 0xfc, 0x10, 0x00, 0x00,  //@@@....@@@.....
    0xfb, 0x00, 0x00, 0x0f, 0xb0, 0x00, 0x00, 0x00,  //@%.....@%......
    0x90, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00,  //%......%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00bc (¼) , Width: 28 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x27, 0xcf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xa0, 0x00, 0x00,  //.+@@@...............%@%.....
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0x10, 0x00, 0x00,  //@@@@@..............+@@......
    0xd7, 0x2f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf6, 0x00, 0x00, 0x00,  //@+.@@..............@@+......
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xc0, 0x00, 0x00, 0x00,  //...@@.............%@@.......
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x30, 0x00, 0x00, 0x00,  //...@@.............@@........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xf8, 0x00, 0x00, 0x00, 0x00,  //...@@............@@%........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xe0, 0x00, 0x00, 0x00, 0x00,  //...@@...........+@@.........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //...@@...........@@+.........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@..........%@%..........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.........+@@...........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xef, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.........@@+...........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x08, 0xfc, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x00,  //...@@........%@@.......@@@..
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x3f, 0xf2, 0x00, 0x00, 0x00, 0xbf, 0xff, 0x00,  //@@@@@@@@.....@@.......%@@@..
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xcf, 0x80, 0x00, 0x00, 0x06, 0xfa, 0xff, 0x00,  //@@@@@@@@....@@%......+@%@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xfd, 0x00, 0x00, 0x00, 0x2f, 0xd0, 0xff, 0x00,  //...........+@@.......@@.@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf4, 0x00, 0x00, 0x00, 0xdf, 0x20, 0xff, 0x00,  //...........@@+......@@..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xa0, 0x00, 0x00, 0x08, 0xf6, 0x00, 0xff, 0x00,  //..........%@%......%@+..@@..
    0x00, 0x00, 0x00, 0x00, 0x04, 0xfe, 0x10, 0x00, 0x00, 0x4f, 0xa0, 0x00, 0xff, 0x00,  //.........+@@......+@%...@@..
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xf6, 0x00, 0x00, 0x01, 0xed, 0x00, 0x00, 0xff, 0x00,  //.........@@+......@@....@@..
    0x00, 0x00, 0x00, 0x00, 0x8f, 0xc0, 0x00, 0x00, 0x0a, 0xf2, 0x00, 0x00, 0xff, 0x00,  //........%@@......%@.....@@..
    0x00, 0x00, 0x00, 0x03, 0xff, 0x20, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff,  //........@@.......@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x0c, 0xf8, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff,  //.......@@%.......@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x6f, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,  //......+@@...............@@..
    0x00, 0x00, 0x01, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,  //......@@+...............@@..
    0x00, 0x00, 0x0a, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,  //.....%@%................@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................


    /*Unicode: U+00bd (½) , Width: 28 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x27, 0xcf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xa0, 0x00, 0x00,  //.+@@@...............%@%.....
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0x10, 0x00, 0x00,  //@@@@@..............+@@......
    0xd7, 0x2f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf6, 0x00, 0x00, 0x00,  //@+.@@..............@@+......
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xc0, 0x00, 0x00, 0x00,  //...@@.............%@@.......
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x30, 0x00, 0x00, 0x00,  //...@@.............@@........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xf8, 0x00, 0x00, 0x00, 0x00,  //...@@............@@%........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xe0, 0x00, 0x00, 0x00, 0x00,  //...@@...........+@@.........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //...@@...........@@+.........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@..........%@%..........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.........+@@...........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xef, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.........@@+...........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x08, 0xfc, 0x00, 0x27, 0xbe, 0xfe, 0xc7, 0x00,  //...@@........%@@...+%@@@@+..
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x3f, 0xf2, 0x00, 0xff, 0xff, 0xff, 0xff, 0xd1,  //@@@@@@@@.....@@...@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xcf, 0x80, 0x00, 0xd8, 0x31, 0x01, 0x6e, 0xfa,  //@@@@@@@@....@@%...@+....+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff,  //...........+@@...........+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xfe,  //...........@@+............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xf7,  //..........%@%............%@+
    0x00, 0x00, 0x00, 0x00, 0x04, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xd0,  //.........+@@............+@@.
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xfe, 0x20,  //.........@@+...........+@@..
    0x00, 0x00, 0x00, 0x00, 0x8f, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xf3, 0x00,  //........%@@...........%@@...
    0x00, 0x00, 0x00, 0x03, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x40, 0x00,  //........@@...........%@@+...
    0x00, 0x00, 0x00, 0x0c, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x02, 0xdf, 0xe3, 0x00, 0x00,  //.......@@%..........@@@.....
    0x00, 0x00, 0x00, 0x6f, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfc, 0x10, 0x00, 0x00,  //......+@@.........+@@@......
    0x00, 0x00, 0x01, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,  //......@@+.........@@@@@@@@@@
    0x00, 0x00, 0x0a, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....%@%..........@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................


    /*Unicode: U+00be (¾) , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x27, 0xbe, 0xff, 0xd8, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xfa, 0x00, 0x00, 0x00,  //.+%@@@@%.............%@%.....
    0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xf1, 0x00, 0x00, 0x00,  //@@@@@@@@@+..........+@@......
    0xd7, 0x31, 0x01, 0x3a, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0x60, 0x00, 0x00, 0x00,  //@+.....%@@..........@@+......
    0x00, 0x00, 0x00, 0x01, 0xff, 0x00, 0x00, 0x00, 0x00, 0x08, 0xfc, 0x00, 0x00, 0x00, 0x00,  //........@@.........%@@.......
    0x00, 0x00, 0x00, 0x3a, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xf3, 0x00, 0x00, 0x00, 0x00,  //.......%@%.........@@........
    0x00, 0x0f, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x80, 0x00, 0x00, 0x00, 0x00,  //...@@@@@%.........@@%........
    0x00, 0x0f, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x06, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@%........+@@.........
    0x00, 0x00, 0x01, 0x5e, 0xf8, 0x00, 0x00, 0x00, 0x1f, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@+.......@@+.........
    0x00, 0x00, 0x00, 0x04, 0xfd, 0x00, 0x00, 0x00, 0xaf, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@......%@%..........
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x04, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@.....+@@...........
    0x00, 0x00, 0x00, 0x04, 0xfe, 0x00, 0x00, 0x0e, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@.....@@+...........
    0xc5, 0x20, 0x02, 0x7e, 0xf8, 0x00, 0x00, 0x8f, 0xc0, 0x00, 0x00, 0x01, 0xef, 0xf0, 0x00,  //%+....+@@%....%@@.......@@@..
    0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x03, 0xff, 0x20, 0x00, 0x00, 0x0b, 0xff, 0xf0, 0x00,  //@@@@@@@@%.....@@.......%@@@..
    0x28, 0xdf, 0xfe, 0xb5, 0x00, 0x00, 0x0c, 0xf8, 0x00, 0x00, 0x00, 0x6f, 0xaf, 0xf0, 0x00,  //.%@@@@%+.....@@%......+@%@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xd0, 0x00, 0x00, 0x02, 0xfd, 0x0f, 0xf0, 0x00,  //............+@@.......@@.@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0x40, 0x00, 0x00, 0x0d, 0xf2, 0x0f, 0xf0, 0x00,  //............@@+......@@..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xfa, 0x00, 0x00, 0x00, 0x8f, 0x60, 0x0f, 0xf0, 0x00,  //...........%@%......%@+..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xe1, 0x00, 0x00, 0x04, 0xfa, 0x00, 0x0f, 0xf0, 0x00,  //..........+@@......+@%...@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0x60, 0x00, 0x00, 0x1e, 0xd0, 0x00, 0x0f, 0xf0, 0x00,  //..........@@+......@@....@@..
    0x00, 0x00, 0x00, 0x00, 0x08, 0xfc, 0x00, 0x00, 0x00, 0xaf, 0x20, 0x00, 0x0f, 0xf0, 0x00,  //.........%@@......%@.....@@..
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xf2, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.........@@.......@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xcf, 0x80, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //........@@%.......@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x06, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //.......+@@...............@@..
    0x00, 0x00, 0x00, 0x1f, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //.......@@+...............@@..
    0x00, 0x00, 0x00, 0xaf, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //......%@%................@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+00bf (¿) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x03, 0xff, 0xd0, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x0b, 0xff, 0xa0, 0x00, 0x00,  //.....%@@%....
    0x00, 0x00, 0x8f, 0xff, 0x30, 0x00, 0x00,  //....%@@@.....
    0x00, 0x08, 0xff, 0xf9, 0x00, 0x00, 0x00,  //...%@@@%.....
    0x00, 0x8f, 0xff, 0xc0, 0x00, 0x00, 0x00,  //..%@@@@......
    0x05, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00,  //.+@@@@.......
    0x1e, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00,  //.@@@@........
    0x8f, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00,  //%@@@.........
    0xdf, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xcf, 0xf9, 0x00, 0x00, 0x00, 0x03, 0xb0,  //@@@%........%
    0x6f, 0xff, 0xb3, 0x10, 0x26, 0xcf, 0xf0,  //+@@@%....+%@@
    0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xfd, 0x40,  //..@@@@@@@@@@+
    0x00, 0x05, 0xbe, 0xfe, 0xd9, 0x40, 0x00,  //...+%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00c0 (À) , Width: 23 */
    0x00, 0x00, 0x00, 0x08, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@+............
    0x00, 0x00, 0x00, 0x00, 0x9f, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@+...........
    0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xfd, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x02, 0xff, 0xf2, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x08, 0xff, 0xb0, 0xaf, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x0e, 0xff, 0x40, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x00, 0x00, 0x4f, 0xfe, 0x00, 0x0e, 0xff, 0x40, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0xaf, 0xf8, 0x00, 0x08, 0xff, 0xa0, 0x00, 0x00, 0x00,  //......%@@%...%@@%......
    0x00, 0x00, 0x01, 0xff, 0xf2, 0x00, 0x02, 0xff, 0xf1, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x07, 0xff, 0xc0, 0x00, 0x00, 0xcf, 0xf7, 0x00, 0x00, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x00, 0x0d, 0xff, 0x60, 0x00, 0x00, 0x5f, 0xfd, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x09, 0xff, 0x90, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf5, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //..%@@@@@@@@@@@@@@@@@%..
    0x00, 0xef, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xe0, 0x00,  //..@@@+...........+@@@..
    0x04, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xf4, 0x00,  //.+@@@.............@@@+.
    0x0a, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfa, 0x00,  //.%@@%.............%@@%.
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@...............@@@.
    0x6f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@@...............@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c1 (Á) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //............@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00,  //...........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@..........
    0x00, 0x00, 0x00, 0x00, 0x09, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xfd, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x02, 0xff, 0xf2, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x08, 0xff, 0xb0, 0xaf, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x0e, 0xff, 0x40, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x00, 0x00, 0x4f, 0xfe, 0x00, 0x0e, 0xff, 0x40, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0xaf, 0xf8, 0x00, 0x08, 0xff, 0xa0, 0x00, 0x00, 0x00,  //......%@@%...%@@%......
    0x00, 0x00, 0x01, 0xff, 0xf2, 0x00, 0x02, 0xff, 0xf1, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x07, 0xff, 0xc0, 0x00, 0x00, 0xcf, 0xf7, 0x00, 0x00, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x00, 0x0d, 0xff, 0x60, 0x00, 0x00, 0x5f, 0xfd, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x09, 0xff, 0x90, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf5, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //..%@@@@@@@@@@@@@@@@@%..
    0x00, 0xef, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xe0, 0x00,  //..@@@+...........+@@@..
    0x04, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xf4, 0x00,  //.+@@@.............@@@+.
    0x0a, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfa, 0x00,  //.%@@%.............%@@%.
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@...............@@@.
    0x6f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@@...............@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c2 (Â) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x1e, 0xf9, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00,  //.........@@%@@.........
    0x00, 0x00, 0x00, 0x00, 0xcf, 0x60, 0x6f, 0xc0, 0x00, 0x00, 0x00, 0x00,  //........@@+.+@@........
    0x00, 0x00, 0x00, 0x09, 0xf8, 0x00, 0x08, 0xf9, 0x00, 0x00, 0x00, 0x00,  //.......%@+...+@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xfd, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x02, 0xff, 0xf2, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x08, 0xff, 0xb0, 0xaf, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x0e, 0xff, 0x40, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x00, 0x00, 0x4f, 0xfe, 0x00, 0x0e, 0xff, 0x40, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0xaf, 0xf8, 0x00, 0x08, 0xff, 0xa0, 0x00, 0x00, 0x00,  //......%@@%...%@@%......
    0x00, 0x00, 0x01, 0xff, 0xf2, 0x00, 0x02, 0xff, 0xf1, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x07, 0xff, 0xc0, 0x00, 0x00, 0xcf, 0xf7, 0x00, 0x00, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x00, 0x0d, 0xff, 0x60, 0x00, 0x00, 0x5f, 0xfd, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x09, 0xff, 0x90, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf5, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //..%@@@@@@@@@@@@@@@@@%..
    0x00, 0xef, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xe0, 0x00,  //..@@@+...........+@@@..
    0x04, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xf4, 0x00,  //.+@@@.............@@@+.
    0x0a, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfa, 0x00,  //.%@@%.............%@@%.
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@...............@@@.
    0x6f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@@...............@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c3 (Ã) , Width: 23 */
    0x00, 0x00, 0x00, 0x07, 0xee, 0xb2, 0x00, 0x0f, 0xe0, 0x00, 0x00, 0x00,  //.......+@@%....@@......
    0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0x81, 0x7f, 0xc0, 0x00, 0x00, 0x00,  //......+@@@@@%.+@%......
    0x00, 0x00, 0x00, 0xcf, 0x61, 0x8f, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00,  //......@@+.%@@@@@+......
    0x00, 0x00, 0x00, 0xef, 0x00, 0x03, 0xbf, 0xe7, 0x00, 0x00, 0x00, 0x00,  //......@@....%@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xfd, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x02, 0xff, 0xf2, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x08, 0xff, 0xb0, 0xaf, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x0e, 0xff, 0x40, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x00, 0x00, 0x4f, 0xfe, 0x00, 0x0e, 0xff, 0x40, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0xaf, 0xf8, 0x00, 0x08, 0xff, 0xa0, 0x00, 0x00, 0x00,  //......%@@%...%@@%......
    0x00, 0x00, 0x01, 0xff, 0xf2, 0x00, 0x02, 0xff, 0xf1, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x07, 0xff, 0xc0, 0x00, 0x00, 0xcf, 0xf7, 0x00, 0x00, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x00, 0x0d, 0xff, 0x60, 0x00, 0x00, 0x5f, 0xfd, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x09, 0xff, 0x90, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf5, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //..%@@@@@@@@@@@@@@@@@%..
    0x00, 0xef, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xe0, 0x00,  //..@@@+...........+@@@..
    0x04, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xf4, 0x00,  //.+@@@.............@@@+.
    0x0a, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfa, 0x00,  //.%@@%.............%@@%.
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@...............@@@.
    0x6f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@@...............@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c4 (Ä) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xfd, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x02, 0xff, 0xf2, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x08, 0xff, 0xb0, 0xaf, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x0e, 0xff, 0x40, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x00, 0x00, 0x4f, 0xfe, 0x00, 0x0e, 0xff, 0x40, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0xaf, 0xf8, 0x00, 0x08, 0xff, 0xa0, 0x00, 0x00, 0x00,  //......%@@%...%@@%......
    0x00, 0x00, 0x01, 0xff, 0xf2, 0x00, 0x02, 0xff, 0xf1, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x07, 0xff, 0xc0, 0x00, 0x00, 0xcf, 0xf7, 0x00, 0x00, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x00, 0x0d, 0xff, 0x60, 0x00, 0x00, 0x5f, 0xfd, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x09, 0xff, 0x90, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf5, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //..%@@@@@@@@@@@@@@@@@%..
    0x00, 0xef, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xe0, 0x00,  //..@@@+...........+@@@..
    0x04, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xf4, 0x00,  //.+@@@.............@@@+.
    0x0a, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfa, 0x00,  //.%@@%.............%@@%.
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@...............@@@.
    0x6f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@@...............@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c5 (Å) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@%........
    0x00, 0x00, 0x00, 0x08, 0xfd, 0x30, 0x4e, 0xf7, 0x00, 0x00, 0x00, 0x00,  //.......%@@..+@@+.......
    0x00, 0x00, 0x00, 0x0d, 0xf3, 0x00, 0x04, 0xfd, 0x00, 0x00, 0x00, 0x00,  //.......@@....+@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@.....@@.......
    0x00, 0x00, 0x00, 0x0e, 0xf3, 0x00, 0x04, 0xfd, 0x00, 0x00, 0x00, 0x00,  //.......@@.....@@.......
    0x00, 0x00, 0x00, 0x09, 0xfd, 0x30, 0x4d, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.......%@@...@@%.......
    0x00, 0x00, 0x00, 0x00, 0xdf, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xdf, 0xfc, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x03, 0xff, 0xf1, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x09, 0xff, 0xa0, 0xaf, 0xf9, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x0e, 0xff, 0x30, 0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00, 0x5f, 0xfd, 0x00, 0x0d, 0xff, 0x50, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0xbf, 0xf7, 0x00, 0x07, 0xff, 0xb0, 0x00, 0x00, 0x00,  //......%@@+...+@@%......
    0x00, 0x00, 0x01, 0xff, 0xf1, 0x00, 0x01, 0xff, 0xf1, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x07, 0xff, 0xb0, 0x00, 0x00, 0xbf, 0xf7, 0x00, 0x00, 0x00,  //.....+@@%.....%@@+.....
    0x00, 0x00, 0x0d, 0xff, 0x50, 0x00, 0x00, 0x5f, 0xfd, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x3f, 0xfe, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x30, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x09, 0xff, 0x90, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x06, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf6, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //..%@@@@@@@@@@@@@@@@@%..
    0x00, 0xef, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xe0, 0x00,  //..@@@+...........+@@@..
    0x04, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xf4, 0x00,  //.+@@@.............@@@+.
    0x0a, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfa, 0x00,  //.%@@%.............%@@%.
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@...............@@@.
    0x6f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@@...............@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c6 (Æ) , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..........%@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..........@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.........%@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x40, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@+..@@@.............
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xfd, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@...@@@.............
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xf6, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@+...@@@.............
    0x00, 0x00, 0x00, 0x03, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@....@@@.............
    0x00, 0x00, 0x00, 0x0a, 0xff, 0x90, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@%....@@@.............
    0x00, 0x00, 0x00, 0x1f, 0xff, 0x20, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.....@@@.............
    0x00, 0x00, 0x00, 0x7f, 0xfc, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@%.....@@@.............
    0x00, 0x00, 0x00, 0xef, 0xf5, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //......@@@+.....@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x05, 0xff, 0xe0, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.....+@@@......@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x0b, 0xff, 0x70, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.....%@@+......@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x2f, 0xff, 0x10, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@.......@@@.............
    0x00, 0x00, 0x9f, 0xfa, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@%.......@@@.............
    0x00, 0x00, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@........@@@.............
    0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@@@@.............
    0x00, 0x0d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@@@@.............
    0x00, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@@@@@@@@@@.............
    0x00, 0xbf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@%.........@@@.............
    0x01, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@..........@@@.............
    0x08, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@%..........@@@.............
    0x0e, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.@@@+..........@@@@@@@@@@@@@@@@
    0x5f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //+@@@...........@@@@@@@@@@@@@@@@
    0xcf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@+...........@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+00c7 (Ç) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x04, 0x8c, 0xdf, 0xfe, 0xda, 0x61, 0x00,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x05, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb3,  //.....+@@@@@@@@@@@@%.
    0x00, 0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x00, 0x0c, 0xff, 0xfe, 0x84, 0x10, 0x01, 0x48, 0xdf, 0xff,  //...@@@@@%+....+%@@@@
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x05, 0xdf,  //..%@@@+..........+@@
    0x05, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a,  //.+@@@+.............%
    0x0c, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%...............
    0x3f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x0c, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%...............
    0x05, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a,  //.+@@@+.............%
    0x00, 0xaf, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x05, 0xdf,  //..%@@@+..........+@@
    0x00, 0x0c, 0xff, 0xfe, 0x84, 0x10, 0x01, 0x48, 0xdf, 0xff,  //...@@@@@%+....+%@@@@
    0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x00, 0x00, 0x05, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb3,  //.....+@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x04, 0x8c, 0xdf, 0xfe, 0xda, 0x61, 0x00,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xf6, 0x00, 0x00, 0x00,  //...........@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0x20, 0x00, 0x00,  //...........+@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xb0, 0x00, 0x00,  //............@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //............@@@.....
    0x00, 0x00, 0x00, 0x00, 0x92, 0x07, 0xff, 0xe0, 0x00, 0x00,  //........%..+@@@.....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00,  //........@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xc6, 0x00, 0x00, 0x00,  //........%@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+00c8 (È) , Width: 16 */
    0x00, 0x00, 0x8f, 0xf7, 0x00, 0x00, 0x00, 0x00,  //....%@@+........
    0x00, 0x00, 0x09, 0xff, 0x50, 0x00, 0x00, 0x00,  //.....%@@+.......
    0x00, 0x00, 0x00, 0x9f, 0xf2, 0x00, 0x00, 0x00,  //......%@@.......
    0x00, 0x00, 0x00, 0x0a, 0xfd, 0x10, 0x00, 0x00,  //.......%@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00c9 (É) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x00, 0x00,  //.........@@@....
    0x00, 0x00, 0x00, 0x01, 0xef, 0xd1, 0x00, 0x00,  //........@@@.....
    0x00, 0x00, 0x00, 0x0c, 0xfd, 0x10, 0x00, 0x00,  //.......%@@......
    0x00, 0x00, 0x00, 0x9f, 0xe1, 0x00, 0x00, 0x00,  //......%@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00ca (Ê) , Width: 16 */
    0x00, 0x00, 0x01, 0xef, 0xfe, 0x10, 0x00, 0x00,  //......@@@@......
    0x00, 0x00, 0x0c, 0xfc, 0xcf, 0xc0, 0x00, 0x00,  //.....@@@@@@.....
    0x00, 0x00, 0xbf, 0xc0, 0x0c, 0xfb, 0x00, 0x00,  //....%@%..%@%....
    0x00, 0x09, 0xfb, 0x00, 0x00, 0xbf, 0x90, 0x00,  //...%@%....%@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00cb (Ë) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0xff, 0xf0, 0x00, 0xff, 0xf0, 0x00,  //....@@@...@@@...
    0x00, 0x00, 0xff, 0xf0, 0x00, 0xff, 0xf0, 0x00,  //....@@@...@@@...
    0x00, 0x00, 0xff, 0xf0, 0x00, 0xff, 0xf0, 0x00,  //....@@@...@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00cc (Ì) , Width: 7 */
    0x8f, 0xf7, 0x00, 0x00,  //%@@+...
    0x09, 0xff, 0x50, 0x00,  //.%@@+..
    0x00, 0x9f, 0xf2, 0x00,  //..%@@..
    0x00, 0x0a, 0xfd, 0x10,  //...%@@.
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00cd (Í) , Width: 7 */
    0x00, 0x3f, 0xfc, 0x00,  //...@@@.
    0x01, 0xef, 0xd1, 0x00,  //..@@@..
    0x0c, 0xfd, 0x10, 0x00,  //.%@@...
    0x9f, 0xe1, 0x00, 0x00,  //%@@....
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00ce (Î) , Width: 10 */
    0x00, 0xaf, 0xff, 0xa0, 0x00,  //..%@@@%...
    0x09, 0xff, 0x8f, 0xf9, 0x00,  //.%@@%@@%..
    0x9f, 0xe3, 0x03, 0xef, 0x90,  //%@@...@@%.
    0xfe, 0x20, 0x00, 0x2e, 0xf8,  //@@.....@@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00cf (Ï) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00d0 (Ð) , Width: 24 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xfe, 0xdb, 0x85, 0x10, 0x00, 0x00, 0x00,  //...@@@@@@@@@@%%+........
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x40, 0x00, 0x00,  //...@@@@@@@@@@@@@@%+.....
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x10, 0x00,  //...@@@@@@@@@@@@@@@@%....
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x01, 0x14, 0x7b, 0xff, 0xff, 0xd1, 0x00,  //...@@@........+%@@@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xfc, 0x00,  //...@@@...........%@@@@..
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0x60,  //...@@@............+@@@+.
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xe0,  //...@@@.............%@@@.
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xf4,  //...@@@..............@@@+
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xf8,  //...@@@..............%@@%
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfc,  //...@@@..............+@@@
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //...@@@...............@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@@@@@@@@@@.........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@@@@@@@@@@.........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@@@@@@@@@@.........@@@
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //...@@@...............@@@
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfc,  //...@@@..............+@@%
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xf8,  //...@@@..............%@@%
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xf4,  //...@@@..............@@@+
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xe0,  //...@@@.............%@@@.
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0x60,  //...@@@............+@@@+.
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xfc, 0x00,  //...@@@...........%@@@@..
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x13, 0x7b, 0xff, 0xff, 0xd1, 0x00,  //...@@@........+%@@@@@...
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x10, 0x00,  //...@@@@@@@@@@@@@@@@%....
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x40, 0x00, 0x00,  //...@@@@@@@@@@@@@@%+.....
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xfe, 0xdb, 0x85, 0x10, 0x00, 0x00, 0x00,  //...@@@@@@@@@@%%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................


    /*Unicode: U+00d1 (Ñ) , Width: 19 */
    0x00, 0x00, 0x07, 0xee, 0xb2, 0x00, 0x0f, 0xe0, 0x00, 0x00,  //.....+@@%....@@....
    0x00, 0x00, 0x5f, 0xff, 0xff, 0x81, 0x7f, 0xc0, 0x00, 0x00,  //....+@@@@@%.+@%....
    0x00, 0x00, 0xcf, 0x61, 0x8f, 0xff, 0xff, 0x50, 0x00, 0x00,  //....@@+.%@@@@@+....
    0x00, 0x00, 0xef, 0x00, 0x03, 0xbf, 0xe7, 0x00, 0x00, 0x00,  //....@@....%@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@%...........@@@
    0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@...........@@@
    0xff, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@%..........@@@
    0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@@..........@@@
    0xff, 0xf9, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@%@@@.........@@@
    0xff, 0xf1, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.@@@+........@@@
    0xff, 0xf0, 0x8f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.+@@@........@@@
    0xff, 0xf0, 0x0e, 0xff, 0x70, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@..@@@+.......@@@
    0xff, 0xf0, 0x06, 0xff, 0xe1, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@..+@@@.......@@@
    0xff, 0xf0, 0x00, 0xdf, 0xf8, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...@@@%......@@@
    0xff, 0xf0, 0x00, 0x4f, 0xff, 0x10, 0x00, 0x00, 0xff, 0xf0,  //@@@...+@@@......@@@
    0xff, 0xf0, 0x00, 0x0c, 0xff, 0xa0, 0x00, 0x00, 0xff, 0xf0,  //@@@....%@@%.....@@@
    0xff, 0xf0, 0x00, 0x03, 0xff, 0xf3, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xaf, 0xfb, 0x00, 0x00, 0xff, 0xf0,  //@@@.....%@@%....@@@
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xff, 0x40, 0x00, 0xff, 0xf0,  //@@@......@@@+...@@@
    0xff, 0xf0, 0x00, 0x00, 0x08, 0xff, 0xd0, 0x00, 0xff, 0xf0,  //@@@......%@@@...@@@
    0xff, 0xf0, 0x00, 0x00, 0x01, 0xef, 0xf6, 0x00, 0xff, 0xf0,  //@@@.......@@@+..@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0xff, 0xf0,  //@@@.......+@@@..@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x70, 0xff, 0xf0,  //@@@........@@@+.@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf1, 0xff, 0xf0,  //@@@........+@@@.@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf9, 0xff, 0xf0,  //@@@.........@@@%@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xf0,  //@@@.........+@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xf0,  //@@@..........%@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xf0,  //@@@...........@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xff, 0xf0,  //@@@...........%@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00d2 (Ò) , Width: 23 */
    0x00, 0x00, 0x00, 0x08, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@+............
    0x00, 0x00, 0x00, 0x00, 0x9f, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@+...........
    0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x0d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xa0, 0x00,  //..%@@@%.........+@@@%..
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xf5, 0x00,  //.+@@@+...........+@@@+.
    0x0c, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfc, 0x00,  //.@@@%.............%@@@.
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //.@@@...............@@@.
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //+@@%...............%@@+
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+...............+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.................@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.................@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.................@@@
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+...............+@@%
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //+@@%...............%@@+
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //.@@@...............@@@.
    0x0d, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfd, 0x00,  //.@@@%.............%@@@.
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf5, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xb0, 0x00,  //..%@@@+.........+@@@%..
    0x00, 0x1d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x10, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x07, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d3 (Ó) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //............@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00,  //...........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@..........
    0x00, 0x00, 0x00, 0x00, 0x09, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x0d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xa0, 0x00,  //..%@@@%.........+@@@%..
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xf5, 0x00,  //.+@@@+...........+@@@+.
    0x0c, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfc, 0x00,  //.@@@%.............%@@@.
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //.@@@...............@@@.
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //+@@%...............%@@+
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+...............+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.................@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.................@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.................@@@
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+...............+@@%
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //+@@%...............%@@+
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //.@@@...............@@@.
    0x0d, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfd, 0x00,  //.@@@%.............%@@@.
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf5, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xb0, 0x00,  //..%@@@+.........+@@@%..
    0x00, 0x1d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x10, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x07, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d4 (Ô) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x1e, 0xf9, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00,  //.........@@%@@.........
    0x00, 0x00, 0x00, 0x00, 0xcf, 0x60, 0x6f, 0xc0, 0x00, 0x00, 0x00, 0x00,  //........@@+.+@@........
    0x00, 0x00, 0x00, 0x09, 0xf8, 0x00, 0x08, 0xf9, 0x00, 0x00, 0x00, 0x00,  //.......%@+...+@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x0d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xa0, 0x00,  //..%@@@%.........+@@@%..
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xf5, 0x00,  //.+@@@+...........+@@@+.
    0x0c, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfc, 0x00,  //.@@@%.............%@@@.
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //.@@@...............@@@.
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //+@@%...............%@@+
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+...............+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.................@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.................@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.................@@@
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+...............+@@%
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //+@@%...............%@@+
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //.@@@...............@@@.
    0x0d, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfd, 0x00,  //.@@@%.............%@@@.
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf5, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xb0, 0x00,  //..%@@@+.........+@@@%..
    0x00, 0x1d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x10, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x07, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d5 (Õ) , Width: 23 */
    0x00, 0x00, 0x00, 0x07, 0xee, 0xb2, 0x00, 0x0f, 0xe0, 0x00, 0x00, 0x00,  //.......+@@%....@@......
    0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0x81, 0x7f, 0xc0, 0x00, 0x00, 0x00,  //......+@@@@@%.+@%......
    0x00, 0x00, 0x00, 0xcf, 0x61, 0x8f, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00,  //......@@+.%@@@@@+......
    0x00, 0x00, 0x00, 0xef, 0x00, 0x03, 0xbf, 0xe7, 0x00, 0x00, 0x00, 0x00,  //......@@....%@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x0d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xa0, 0x00,  //..%@@@%.........+@@@%..
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xf5, 0x00,  //.+@@@+...........+@@@+.
    0x0c, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfc, 0x00,  //.@@@%.............%@@@.
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //.@@@...............@@@.
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //+@@%...............%@@+
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+...............+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.................@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.................@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.................@@@
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+...............+@@%
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //+@@%...............%@@+
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //.@@@...............@@@.
    0x0d, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfd, 0x00,  //.@@@%.............%@@@.
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf5, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xb0, 0x00,  //..%@@@+.........+@@@%..
    0x00, 0x1d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x10, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x07, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d6 (Ö) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x0d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xa0, 0x00,  //..%@@@%.........+@@@%..
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xf5, 0x00,  //.+@@@+...........+@@@+.
    0x0c, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfc, 0x00,  //.@@@%.............%@@@.
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //.@@@...............@@@.
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //+@@%...............%@@+
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+...............+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.................@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.................@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.................@@@
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+...............+@@%
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //+@@%...............%@@+
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //.@@@...............@@@.
    0x0d, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfd, 0x00,  //.@@@%.............%@@@.
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf5, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xb0, 0x00,  //..%@@@+.........+@@@%..
    0x00, 0x1d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x10, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x07, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d7 (×) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x05, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb5, 0x00,  //.+%.............%+.
    0x7f, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x70,  //+@@%...........%@@+
    0x7f, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0x70,  //+@@@%.........%@@@+
    0x07, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xf7, 0x00,  //.+@@@%.......%@@@+.
    0x00, 0x7f, 0xff, 0xb0, 0x00, 0x00, 0xbf, 0xff, 0x70, 0x00,  //..+@@@%.....%@@@+..
    0x00, 0x07, 0xff, 0xfb, 0x00, 0x0b, 0xff, 0xf7, 0x00, 0x00,  //...+@@@%...%@@@+...
    0x00, 0x00, 0x8f, 0xff, 0xb0, 0xbf, 0xff, 0x70, 0x00, 0x00,  //....+@@@%.%@@@+....
    0x00, 0x00, 0x08, 0xff, 0xfe, 0xff, 0xf7, 0x00, 0x00, 0x00,  //.....+@@@@@@@+.....
    0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00,  //......%@@@@@+......
    0x00, 0x00, 0x00, 0x0b, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00,  //.......%@@@%.......
    0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00,  //......+@@@@@+......
    0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00,  //.....+@@@@@@@+.....
    0x00, 0x00, 0x7f, 0xff, 0xb1, 0xbf, 0xff, 0x70, 0x00, 0x00,  //....+@@@%.%@@@+....
    0x00, 0x07, 0xff, 0xfb, 0x00, 0x0b, 0xff, 0xf7, 0x00, 0x00,  //...+@@@%...%@@@+...
    0x00, 0x7f, 0xff, 0xb0, 0x00, 0x00, 0xbf, 0xff, 0x70, 0x00,  //..+@@@%.....%@@@+..
    0x07, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xf7, 0x00,  //.+@@@%.......%@@@+.
    0x7f, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0x70,  //+@@@%.........%@@@+
    0x7f, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x70,  //+@@%...........%@@+
    0x05, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb5, 0x00,  //.+%.............%+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00d8 (Ø) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,  //......................+..
    0x00, 0x00, 0x00, 0x00, 0x49, 0xce, 0xff, 0xda, 0x61, 0x00, 0x02, 0xfc, 0x00,  //........+%@@@@@%+.....@@.
    0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0c, 0xfc, 0x00,  //......+@@@@@@@@@@@%..@@@.
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x9f, 0xf2, 0x00,  //.....%@@@@@@@@@@@@@@%@@..
    0x00, 0x00, 0xdf, 0xff, 0xe7, 0x31, 0x01, 0x37, 0xef, 0xff, 0xff, 0x50, 0x00,  //....@@@@@+.....+@@@@@@+..
    0x00, 0x0a, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xfe, 0x00, 0x00,  //...%@@@%.........%@@@@...
    0x00, 0x5f, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0x60, 0x00,  //..+@@@+..........+@@@@+..
    0x00, 0xdf, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xe0, 0x00,  //..@@@%..........+@@@@@@..
    0x03, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd2, 0xff, 0xf3, 0x00,  //..@@@..........+@@@.@@@..
    0x08, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfd, 0x10, 0xaf, 0xf8, 0x00,  //.+@@%..........@@@..%@@%.
    0x0b, 0xff, 0x50, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd1, 0x00, 0x5f, 0xfb, 0x00,  //.%@@+.........@@@...+@@%.
    0x0d, 0xff, 0x20, 0x00, 0x00, 0x00, 0x3e, 0xfe, 0x20, 0x00, 0x2f, 0xfd, 0x00,  //.@@@.........@@@.....@@@.
    0x0e, 0xff, 0x10, 0x00, 0x00, 0x02, 0xef, 0xe2, 0x00, 0x00, 0x0f, 0xfe, 0x00,  //.@@@........@@@......@@@.
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x2e, 0xfe, 0x20, 0x00, 0x00, 0x0f, 0xff, 0x00,  //.@@@.......@@@.......@@@.
    0x0e, 0xff, 0x00, 0x00, 0x02, 0xef, 0xe2, 0x00, 0x00, 0x00, 0x1f, 0xfe, 0x00,  //.@@@......@@@........@@@.
    0x0d, 0xff, 0x20, 0x00, 0x1e, 0xff, 0x30, 0x00, 0x00, 0x00, 0x2f, 0xfd, 0x00,  //.@@@.....@@@.........@@@.
    0x0b, 0xff, 0x40, 0x01, 0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfb, 0x00,  //.%@@+...@@@.........+@@%.
    0x08, 0xff, 0x90, 0x1d, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xf8, 0x00,  //.%@@%..@@@..........%@@+.
    0x04, 0xff, 0xe2, 0xdf, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf3, 0x00,  //.+@@@.@@@+..........@@@..
    0x00, 0xef, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xd0, 0x00,  //..@@@@@@+..........%@@@..
    0x00, 0x7f, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0x50, 0x00,  //..+@@@@+..........+@@@+..
    0x00, 0x0e, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xfa, 0x00, 0x00,  //...@@@@%.........+@@@%...
    0x00, 0x4f, 0xff, 0xff, 0xe7, 0x31, 0x01, 0x37, 0xdf, 0xff, 0xd0, 0x00, 0x00,  //..+@@@@@@+.....+@@@@@....
    0x00, 0xdf, 0x9c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00, 0x00,  //..@@%@@@@@@@@@@@@@@%.....
    0x08, 0xfc, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60, 0x00, 0x00, 0x00,  //.%@@..%@@@@@@@@@@@+......
    0x0f, 0xf2, 0x00, 0x01, 0x6a, 0xdf, 0xfe, 0xc9, 0x40, 0x00, 0x00, 0x00, 0x00,  //.@@.....+%@@@@@%+........
    0x02, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+00d9 (Ù) , Width: 19 */
    0x00, 0x00, 0x08, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@+..........
    0x00, 0x00, 0x00, 0x9f, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@+.........
    0x00, 0x00, 0x00, 0x09, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00,  //.......%@@.........
    0x00, 0x00, 0x00, 0x00, 0xaf, 0xd1, 0x00, 0x00, 0x00, 0x00,  //........%@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.............@@@
    0xdf, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xc0,  //@@@+...........+@@@
    0x9f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0x90,  //%@@%...........%@@%
    0x5f, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x50,  //+@@@...........@@@+
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.........%@@@.
    0x05, 0xff, 0xfe, 0x73, 0x00, 0x03, 0x7e, 0xff, 0xf5, 0x00,  //.+@@@@+.....+@@@@+.
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //..%@@@@@@@@@@@@@%..
    0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00,  //...+@@@@@@@@@@@+...
    0x00, 0x00, 0x06, 0xad, 0xef, 0xed, 0xa6, 0x00, 0x00, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00da (Ú) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xc0, 0x00, 0x00, 0x00,  //..........@@@......
    0x00, 0x00, 0x00, 0x00, 0x1e, 0xfd, 0x10, 0x00, 0x00, 0x00,  //.........@@@.......
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xd1, 0x00, 0x00, 0x00, 0x00,  //........%@@........
    0x00, 0x00, 0x00, 0x09, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00,  //.......%@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.............@@@
    0xdf, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xc0,  //@@@+...........+@@@
    0x9f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0x90,  //%@@%...........%@@%
    0x5f, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x50,  //+@@@...........@@@+
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.........%@@@.
    0x05, 0xff, 0xfe, 0x73, 0x00, 0x03, 0x7e, 0xff, 0xf5, 0x00,  //.+@@@@+.....+@@@@+.
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //..%@@@@@@@@@@@@@%..
    0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00,  //...+@@@@@@@@@@@+...
    0x00, 0x00, 0x06, 0xad, 0xef, 0xed, 0xa6, 0x00, 0x00, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00db (Û) , Width: 19 */
    0x00, 0x00, 0x00, 0x04, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00,  //.......+@@@+.......
    0x00, 0x00, 0x00, 0x1e, 0xf9, 0xfe, 0x10, 0x00, 0x00, 0x00,  //.......@@%@@.......
    0x00, 0x00, 0x00, 0xcf, 0x60, 0x6f, 0xc0, 0x00, 0x00, 0x00,  //......@@+.+@@......
    0x00, 0x00, 0x09, 0xf8, 0x00, 0x08, 0xf9, 0x00, 0x00, 0x00,  //.....%@+...+@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.............@@@
    0xdf, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xc0,  //@@@+...........+@@@
    0x9f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0x90,  //%@@%...........%@@%
    0x5f, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x50,  //+@@@...........@@@+
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.........%@@@.
    0x05, 0xff, 0xfe, 0x73, 0x00, 0x03, 0x7e, 0xff, 0xf5, 0x00,  //.+@@@@+.....+@@@@+.
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //..%@@@@@@@@@@@@@%..
    0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00,  //...+@@@@@@@@@@@+...
    0x00, 0x00, 0x06, 0xad, 0xef, 0xed, 0xa6, 0x00, 0x00, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00dc (Ü) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@...@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@...@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@...@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.............@@@
    0xdf, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xc0,  //@@@+...........+@@@
    0x9f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0x90,  //%@@%...........%@@%
    0x5f, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x50,  //+@@@...........@@@+
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.........%@@@.
    0x05, 0xff, 0xfe, 0x73, 0x00, 0x03, 0x7e, 0xff, 0xf5, 0x00,  //.+@@@@+.....+@@@@+.
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //..%@@@@@@@@@@@@@%..
    0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00,  //...+@@@@@@@@@@@+...
    0x00, 0x00, 0x06, 0xad, 0xef, 0xed, 0xa6, 0x00, 0x00, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00dd (Ý) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00,  //...........@@@.......
    0x00, 0x00, 0x00, 0x00, 0x01, 0xef, 0xd1, 0x00, 0x00, 0x00, 0x00,  //..........@@@........
    0x00, 0x00, 0x00, 0x00, 0x0c, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00,  //.........%@@.........
    0x00, 0x00, 0x00, 0x00, 0x9f, 0xe1, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xaf, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xa0,  //%@@@.............@@@%
    0x1e, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xfe, 0x10,  //.@@@%...........%@@@.
    0x04, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf4, 0x00,  //.+@@@+.........+@@@+.
    0x00, 0x9f, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x90, 0x00,  //..%@@@.........@@@%..
    0x00, 0x0d, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfd, 0x00, 0x00,  //...@@@%.......%@@@...
    0x00, 0x03, 0xff, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xf3, 0x00, 0x00,  //....@@@+.....+@@@....
    0x00, 0x00, 0x8f, 0xff, 0x20, 0x00, 0x2f, 0xff, 0x80, 0x00, 0x00,  //....%@@@.....@@@%....
    0x00, 0x00, 0x0d, 0xff, 0xc0, 0x00, 0xcf, 0xfd, 0x00, 0x00, 0x00,  //.....@@@@...@@@@.....
    0x00, 0x00, 0x02, 0xff, 0xf7, 0x07, 0xff, 0xf2, 0x00, 0x00, 0x00,  //......@@@+.+@@@......
    0x00, 0x00, 0x00, 0x7f, 0xff, 0x6f, 0xff, 0x70, 0x00, 0x00, 0x00,  //......+@@@+@@@+......
    0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@.......
    0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //........@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00,  //........+@@@+........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+00de (Þ) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xa6, 0x00, 0x00,  //@@@@@@@@@@%+....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe5, 0x00,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@@@@@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x03, 0x8f, 0xff, 0xf1,  //@@@.......%@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf8,  //@@@.........@@@%
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc,  //@@@.........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc,  //@@@.........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf8,  //@@@.........@@@%
    0xff, 0xf0, 0x00, 0x00, 0x03, 0x8f, 0xff, 0xf1,  //@@@.......%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe5, 0x00,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xa6, 0x00, 0x00,  //@@@@@@@@@@%+....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00df (ß) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x01, 0x8c, 0xef, 0xed, 0x92, 0x00, 0x00, 0x00,  //....%@@@@@%......
    0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00,  //..+@@@@@@@@@%....
    0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00,  //.%@@@@@@@@@@@+...
    0x2f, 0xff, 0xd5, 0x10, 0x14, 0xcf, 0xff, 0x10, 0x00,  //.@@@@+...+@@@@...
    0x9f, 0xfc, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x80, 0x00,  //%@@@.......%@@+..
    0xdf, 0xf4, 0x00, 0x00, 0x00, 0x03, 0xff, 0xc0, 0x00,  //@@@+........@@%..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x38, 0xff, 0xe0, 0x00,  //@@@........%@@@..
    0xff, 0xf0, 0x00, 0x00, 0x1b, 0xff, 0xfe, 0xb0, 0x00,  //@@@......%@@@@%..
    0xff, 0xf0, 0x00, 0x01, 0xef, 0xfa, 0x20, 0x00, 0x00,  //@@@.....@@@%.....
    0xff, 0xf0, 0x00, 0x09, 0xff, 0x80, 0x00, 0x00, 0x00,  //@@@....%@@%......
    0xff, 0xf0, 0x00, 0x0e, 0xff, 0x10, 0x00, 0x00, 0x00,  //@@@....@@@.......
    0xff, 0xf0, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....@@@.......
    0xff, 0xf0, 0x00, 0x0d, 0xff, 0x70, 0x00, 0x00, 0x00,  //@@@....@@@+......
    0xff, 0xf0, 0x00, 0x07, 0xff, 0xf7, 0x00, 0x00, 0x00,  //@@@....+@@@+.....
    0xff, 0xf0, 0x00, 0x00, 0xbf, 0xff, 0xc2, 0x00, 0x00,  //@@@.....%@@@@....
    0xff, 0xf0, 0x00, 0x00, 0x08, 0xff, 0xff, 0x60, 0x00,  //@@@......%@@@@+..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x3d, 0xff, 0xf8, 0x00,  //@@@........@@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0x40,  //@@@.........+@@@+
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xb0,  //@@@..........+@@%
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xd0,  //@@@..........+@@@
    0xff, 0xf0, 0x0d, 0x84, 0x20, 0x02, 0x8f, 0xff, 0x80,  //@@@..@++....%@@@%
    0xff, 0xf0, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10,  //@@@..@@@@@@@@@@@.
    0xff, 0xf0, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x00,  //@@@..@@@@@@@@@@..
    0xff, 0xf0, 0x02, 0x7c, 0xef, 0xfd, 0xa5, 0x00, 0x00,  //@@@...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00e0 (à) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x8f, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@%..........
    0x00, 0x0a, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //...%@@+.........
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00, 0x00, 0x00,  //....%@@+........
    0x00, 0x00, 0x0c, 0xfe, 0x10, 0x00, 0x00, 0x00,  //.....@@@........
    0x00, 0x00, 0x01, 0xdf, 0xc0, 0x00, 0x00, 0x00,  //......@@@.......
    0x00, 0x00, 0x00, 0x1e, 0xf9, 0x00, 0x00, 0x00,  //.......@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x02, 0x8b, 0xef, 0xed, 0xa5, 0x00, 0x00,  //....%%@@@@%+....
    0x04, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x00,  //..%@@@@@@@@@@...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //.@@@@@@@@@@@@@..
    0x0f, 0xfb, 0x62, 0x10, 0x03, 0x8e, 0xff, 0xe0,  //.@@%+.....+@@@@.
    0x0b, 0x20, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xf5,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xfa,  //............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //.............@@@
    0x00, 0x02, 0x7b, 0xef, 0xff, 0xff, 0xff, 0xfe,  //....+%@@@@@@@@@@
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@
    0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x6f, 0xff, 0xb6, 0x31, 0x00, 0x00, 0x0f, 0xff,  //+@@@%+.......@@@
    0xcf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,  //@@@%.........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff,  //@@@.........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff,  //@@@.........@@@@
    0xdf, 0xf7, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff,  //@@@+.......%@@@@
    0x9f, 0xff, 0x93, 0x10, 0x16, 0xdf, 0xff, 0xff,  //%@@@%....+@@@@@@
    0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,  //.@@@@@@@@@@@%@@@
    0x03, 0xef, 0xff, 0xff, 0xff, 0xf8, 0x0f, 0xff,  //..@@@@@@@@@+.@@@
    0x00, 0x17, 0xce, 0xfe, 0xc8, 0x20, 0x0f, 0xff,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00e1 (á) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x80, 0x00,  //.........%@@%...
    0x00, 0x00, 0x00, 0x00, 0x7f, 0xfa, 0x00, 0x00,  //........+@@%....
    0x00, 0x00, 0x00, 0x04, 0xff, 0xb0, 0x00, 0x00,  //.......+@@%.....
    0x00, 0x00, 0x00, 0x1e, 0xfc, 0x00, 0x00, 0x00,  //.......@@@......
    0x00, 0x00, 0x00, 0xcf, 0xd1, 0x00, 0x00, 0x00,  //......@@@.......
    0x00, 0x00, 0x09, 0xfe, 0x10, 0x00, 0x00, 0x00,  //.....%@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x02, 0x8b, 0xef, 0xed, 0xa5, 0x00, 0x00,  //....%%@@@@%+....
    0x04, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x00,  //..%@@@@@@@@@@...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //.@@@@@@@@@@@@@..
    0x0f, 0xfb, 0x62, 0x10, 0x03, 0x8e, 0xff, 0xe0,  //.@@%+.....+@@@@.
    0x0b, 0x20, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xf5,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xfa,  //............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //.............@@@
    0x00, 0x02, 0x7b, 0xef, 0xff, 0xff, 0xff, 0xfe,  //....+%@@@@@@@@@@
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@
    0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x6f, 0xff, 0xb6, 0x31, 0x00, 0x00, 0x0f, 0xff,  //+@@@%+.......@@@
    0xcf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,  //@@@%.........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff,  //@@@.........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff,  //@@@.........@@@@
    0xdf, 0xf7, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff,  //@@@+.......%@@@@
    0x9f, 0xff, 0x93, 0x10, 0x16, 0xdf, 0xff, 0xff,  //%@@@%....+@@@@@@
    0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,  //.@@@@@@@@@@@%@@@
    0x03, 0xef, 0xff, 0xff, 0xff, 0xf8, 0x0f, 0xff,  //..@@@@@@@@@+.@@@
    0x00, 0x17, 0xce, 0xfe, 0xc8, 0x20, 0x0f, 0xff,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00e2 (â) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x7f, 0xf7, 0x00, 0x00, 0x00,  //......+@@+......
    0x00, 0x00, 0x02, 0xff, 0xff, 0x20, 0x00, 0x00,  //......@@@@......
    0x00, 0x00, 0x0c, 0xfb, 0xbf, 0xc0, 0x00, 0x00,  //.....%@%%@%.....
    0x00, 0x00, 0x6f, 0xe1, 0x1e, 0xf6, 0x00, 0x00,  //....+@@..@@+....
    0x00, 0x01, 0xef, 0x40, 0x04, 0xfe, 0x10, 0x00,  //....@@+..+@@....
    0x00, 0x0a, 0xf8, 0x00, 0x00, 0x8f, 0xa0, 0x00,  //...%@%....%@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x02, 0x8b, 0xef, 0xed, 0xa5, 0x00, 0x00,  //....%%@@@@%+....
    0x04, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x00,  //..%@@@@@@@@@@...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //.@@@@@@@@@@@@@..
    0x0f, 0xfb, 0x62, 0x10, 0x03, 0x8e, 0xff, 0xe0,  //.@@%+.....+@@@@.
    0x0b, 0x20, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xf5,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xfa,  //............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //.............@@@
    0x00, 0x02, 0x7b, 0xef, 0xff, 0xff, 0xff, 0xfe,  //....+%@@@@@@@@@@
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@
    0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x6f, 0xff, 0xb6, 0x31, 0x00, 0x00, 0x0f, 0xff,  //+@@@%+.......@@@
    0xcf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,  //@@@%.........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff,  //@@@.........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff,  //@@@.........@@@@
    0xdf, 0xf7, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff,  //@@@+.......%@@@@
    0x9f, 0xff, 0x93, 0x10, 0x16, 0xdf, 0xff, 0xff,  //%@@@%....+@@@@@@
    0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,  //.@@@@@@@@@@@%@@@
    0x03, 0xef, 0xff, 0xff, 0xff, 0xf8, 0x0f, 0xff,  //..@@@@@@@@@+.@@@
    0x00, 0x17, 0xce, 0xfe, 0xc8, 0x20, 0x0f, 0xff,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00e3 (ã) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x7e, 0xe7, 0x00, 0x0d, 0xf0, 0x00,  //....+@@+...@@...
    0x00, 0x04, 0xff, 0xff, 0x90, 0x0f, 0xd0, 0x00,  //...+@@@@%..@@...
    0x00, 0x0a, 0xf5, 0x6f, 0xf6, 0x5f, 0xa0, 0x00,  //...%@++@@++@%...
    0x00, 0x0e, 0xf0, 0x09, 0xff, 0xff, 0x40, 0x00,  //...@@..%@@@@+...
    0x00, 0x0f, 0xd0, 0x00, 0x7e, 0xe7, 0x00, 0x00,  //...@@...+@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x02, 0x8b, 0xef, 0xed, 0xa5, 0x00, 0x00,  //....%%@@@@%+....
    0x04, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x00,  //..%@@@@@@@@@@...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //.@@@@@@@@@@@@@..
    0x0f, 0xfb, 0x62, 0x10, 0x03, 0x8e, 0xff, 0xe0,  //.@@%+.....+@@@@.
    0x0b, 0x20, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xf5,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xfa,  //............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //.............@@@
    0x00, 0x02, 0x7b, 0xef, 0xff, 0xff, 0xff, 0xfe,  //....+%@@@@@@@@@@
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@
    0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x6f, 0xff, 0xb6, 0x31, 0x00, 0x00, 0x0f, 0xff,  //+@@@%+.......@@@
    0xcf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,  //@@@%.........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff,  //@@@.........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff,  //@@@.........@@@@
    0xdf, 0xf7, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff,  //@@@+.......%@@@@
    0x9f, 0xff, 0x93, 0x10, 0x16, 0xdf, 0xff, 0xff,  //%@@@%....+@@@@@@
    0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,  //.@@@@@@@@@@@%@@@
    0x03, 0xef, 0xff, 0xff, 0xff, 0xf8, 0x0f, 0xff,  //..@@@@@@@@@+.@@@
    0x00, 0x17, 0xce, 0xfe, 0xc8, 0x20, 0x0f, 0xff,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00e4 (ä) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0xff, 0xf0, 0x0f, 0xff, 0x00, 0x00,  //....@@@..@@@....
    0x00, 0x00, 0xff, 0xf0, 0x0f, 0xff, 0x00, 0x00,  //....@@@..@@@....
    0x00, 0x00, 0xff, 0xf0, 0x0f, 0xff, 0x00, 0x00,  //....@@@..@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x02, 0x8b, 0xef, 0xed, 0xa5, 0x00, 0x00,  //....%%@@@@%+....
    0x04, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x00,  //..%@@@@@@@@@@...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //.@@@@@@@@@@@@@..
    0x0f, 0xfb, 0x62, 0x10, 0x03, 0x8e, 0xff, 0xe0,  //.@@%+.....+@@@@.
    0x0b, 0x20, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xf5,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xfa,  //............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //.............@@@
    0x00, 0x02, 0x7b, 0xef, 0xff, 0xff, 0xff, 0xfe,  //....+%@@@@@@@@@@
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@
    0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x6f, 0xff, 0xb6, 0x31, 0x00, 0x00, 0x0f, 0xff,  //+@@@%+.......@@@
    0xcf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,  //@@@%.........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff,  //@@@.........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff,  //@@@.........@@@@
    0xdf, 0xf7, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff,  //@@@+.......%@@@@
    0x9f, 0xff, 0x93, 0x10, 0x16, 0xdf, 0xff, 0xff,  //%@@@%....+@@@@@@
    0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,  //.@@@@@@@@@@@%@@@
    0x03, 0xef, 0xff, 0xff, 0xff, 0xf8, 0x0f, 0xff,  //..@@@@@@@@@+.@@@
    0x00, 0x17, 0xce, 0xfe, 0xc8, 0x20, 0x0f, 0xff,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00e5 (å) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x8d, 0xfd, 0x80, 0x00, 0x00,  //......%@@@%.....
    0x00, 0x00, 0x0c, 0xff, 0xff, 0xfc, 0x00, 0x00,  //.....@@@@@@@....
    0x00, 0x00, 0x8f, 0xd3, 0x04, 0xef, 0x80, 0x00,  //....%@@..+@@%...
    0x00, 0x00, 0xef, 0x30, 0x00, 0x4f, 0xd0, 0x00,  //....@@.....@@...
    0x00, 0x00, 0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //....@@.....@@...
    0x00, 0x00, 0xdf, 0x30, 0x00, 0x4f, 0xd0, 0x00,  //....@@.....@@...
    0x00, 0x00, 0x8f, 0xd3, 0x04, 0xdf, 0x80, 0x00,  //....%@@...@@%...
    0x00, 0x00, 0x0c, 0xff, 0xff, 0xfc, 0x00, 0x00,  //.....@@@@@@@....
    0x00, 0x00, 0x00, 0x8d, 0xfd, 0x80, 0x00, 0x00,  //......%@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x02, 0x8b, 0xef, 0xed, 0xa5, 0x00, 0x00,  //....%%@@@@%+....
    0x04, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x00,  //..%@@@@@@@@@@...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //.@@@@@@@@@@@@@..
    0x0f, 0xfb, 0x62, 0x10, 0x03, 0x8e, 0xff, 0xe0,  //.@@%+.....+@@@@.
    0x0b, 0x20, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xf5,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xfa,  //............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //.............@@@
    0x00, 0x02, 0x7b, 0xef, 0xff, 0xff, 0xff, 0xfe,  //....+%@@@@@@@@@@
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@
    0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x6f, 0xff, 0xb6, 0x31, 0x00, 0x00, 0x0f, 0xff,  //+@@@%+.......@@@
    0xcf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,  //@@@%.........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff,  //@@@.........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff,  //@@@.........@@@@
    0xdf, 0xf7, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff,  //@@@+.......%@@@@
    0x9f, 0xff, 0x93, 0x10, 0x16, 0xdf, 0xff, 0xff,  //%@@@%....+@@@@@@
    0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,  //.@@@@@@@@@@@%@@@
    0x03, 0xef, 0xff, 0xff, 0xff, 0xf8, 0x0f, 0xff,  //..@@@@@@@@@+.@@@
    0x00, 0x17, 0xce, 0xfe, 0xc8, 0x20, 0x0f, 0xff,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00e6 (æ) , Width: 30 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x02, 0x7b, 0xef, 0xed, 0xa6, 0x00, 0x00, 0x01, 0x6b, 0xdf, 0xfd, 0x94, 0x00, 0x00,  //....+%@@@@%+......+%@@@@%.....
    0x03, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xb1, 0x00,  //..%@@@@@@@@@@+..+@@@@@@@@@%...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x78, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00,  //.@@@@@@@@@@@@@+%@@@@@@@@@@@@..
    0x0f, 0xfb, 0x62, 0x10, 0x03, 0x8e, 0xff, 0xff, 0xff, 0xb5, 0x10, 0x02, 0x7e, 0xff, 0xa0,  //.@@%+.....+@@@@@@@%+....+@@@%.
    0x0b, 0x20, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xf2,  //.%..........@@@@@+........@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xf8,  //............+@@@%.........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfc,  //.............@@@...........@@@
    0x00, 0x02, 0x7b, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,  //....+%@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x6f, 0xff, 0xb6, 0x31, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@%+.......@@@..............
    0xcf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%.........@@@..............
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........+@@@%.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x01, 0xef, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........@@@@@.............
    0xdf, 0xf7, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x03, 0xb0,  //@@@+.......%@@@@@@..........%.
    0x9f, 0xff, 0x93, 0x10, 0x26, 0xef, 0xfc, 0x6f, 0xff, 0xe8, 0x30, 0x01, 0x37, 0xcf, 0xf0,  //%@@@%....+@@@@+@@@@%.....+@@@.
    0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@..%@@@@@@@@@@@@@.
    0x03, 0xef, 0xff, 0xff, 0xff, 0xfb, 0x10, 0x00, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x40,  //..@@@@@@@@@%....+@@@@@@@@@@@+.
    0x00, 0x06, 0xbe, 0xfe, 0xd9, 0x30, 0x00, 0x00, 0x00, 0x5a, 0xde, 0xfe, 0xc8, 0x20, 0x00,  //...+%@@@@%........+%@@@@%%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................


    /*Unicode: U+00e7 (ç) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x04, 0x9d, 0xef, 0xfd, 0xb7, 0x20,  //.....+%@@@@@%+.
    0x00, 0x03, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf0,  //....@@@@@@@@@@@
    0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..+@@@@@@@@@@@@
    0x03, 0xff, 0xff, 0x94, 0x10, 0x02, 0x48, 0xd0,  //..@@@@%.....+%@
    0x0d, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@..........
    0x4f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@...........
    0x9f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%...........
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0x9f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%...........
    0x4f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@...........
    0x0d, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@..........
    0x03, 0xff, 0xff, 0x83, 0x10, 0x02, 0x48, 0xd0,  //..@@@@%.....+%@
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..+@@@@@@@@@@@@
    0x00, 0x04, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf0,  //....@@@@@@@@@@@
    0x00, 0x00, 0x05, 0xad, 0xef, 0xfd, 0xb7, 0x20,  //.....+%@@@@@%+.
    0x00, 0x00, 0x00, 0x00, 0xcf, 0x60, 0x00, 0x00,  //........@@+....
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xf2, 0x00, 0x00,  //........+@@....
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xfb, 0x00, 0x00,  //.........@@%...
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.........@@@...
    0x00, 0x00, 0x09, 0x20, 0x7f, 0xfe, 0x00, 0x00,  //.....%..+@@@...
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xf8, 0x00, 0x00,  //.....@@@@@@%...
    0x00, 0x00, 0x0b, 0xef, 0xfc, 0x60, 0x00, 0x00,  //.....%@@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00e8 (è) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x08, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@%..........
    0x00, 0x00, 0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@+.........
    0x00, 0x00, 0x0b, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //.....%@@+........
    0x00, 0x00, 0x00, 0xcf, 0xe1, 0x00, 0x00, 0x00, 0x00,  //......@@@........
    0x00, 0x00, 0x00, 0x1d, 0xfc, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x01, 0xef, 0x90, 0x00, 0x00, 0x00,  //........@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x50, 0x00, 0x00,  //.....+%@@@@%+....
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfd, 0x20, 0x00,  //...+@@@@@@@@@@...
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00,  //..+@@@@@@@@@@@@..
    0x04, 0xff, 0xfb, 0x51, 0x00, 0x27, 0xef, 0xfc, 0x00,  //..@@@%+....+@@@@.
    0x0d, 0xff, 0x50, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x50,  //.@@@+........@@@+
    0x4f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xa0,  //+@@%.........+@@%
    0x9f, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xd0,  //%@@...........@@@
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xaf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0x5f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0x0d, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x00,  //.@@@@..........%.
    0x04, 0xff, 0xfe, 0x83, 0x00, 0x13, 0x6c, 0xff, 0x00,  //.+@@@@%.....+@@@.
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x00, 0x04, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00,  //...+@@@@@@@@@@@+.
    0x00, 0x00, 0x05, 0xad, 0xef, 0xec, 0x83, 0x00, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00e9 (é) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xf8, 0x00, 0x00,  //..........%@@%...
    0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0, 0x00, 0x00,  //.........+@@%....
    0x00, 0x00, 0x00, 0x00, 0x4f, 0xfb, 0x00, 0x00, 0x00,  //........+@@%.....
    0x00, 0x00, 0x00, 0x01, 0xef, 0xc0, 0x00, 0x00, 0x00,  //........@@@......
    0x00, 0x00, 0x00, 0x0c, 0xfd, 0x10, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x9f, 0xe1, 0x00, 0x00, 0x00, 0x00,  //......%@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x50, 0x00, 0x00,  //.....+%@@@@%+....
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfd, 0x20, 0x00,  //...+@@@@@@@@@@...
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00,  //..+@@@@@@@@@@@@..
    0x04, 0xff, 0xfb, 0x51, 0x00, 0x27, 0xef, 0xfc, 0x00,  //..@@@%+....+@@@@.
    0x0d, 0xff, 0x50, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x50,  //.@@@+........@@@+
    0x4f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xa0,  //+@@%.........+@@%
    0x9f, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xd0,  //%@@...........@@@
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xaf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0x5f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0x0d, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x00,  //.@@@@..........%.
    0x04, 0xff, 0xfe, 0x83, 0x00, 0x13, 0x6c, 0xff, 0x00,  //.+@@@@%.....+@@@.
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x00, 0x04, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00,  //...+@@@@@@@@@@@+.
    0x00, 0x00, 0x05, 0xad, 0xef, 0xec, 0x83, 0x00, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00ea (ê) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x1f, 0xff, 0x20, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0xcf, 0xff, 0xd0, 0x00, 0x00, 0x00,  //......%@@@@......
    0x00, 0x00, 0x07, 0xff, 0x6f, 0xf8, 0x00, 0x00, 0x00,  //.....+@@+@@%.....
    0x00, 0x00, 0x2f, 0xf6, 0x05, 0xff, 0x40, 0x00, 0x00,  //.....@@+.+@@.....
    0x00, 0x00, 0xdf, 0xa0, 0x00, 0x8f, 0xe0, 0x00, 0x00,  //....@@%...%@@....
    0x00, 0x08, 0xfd, 0x00, 0x00, 0x0b, 0xfa, 0x00, 0x00,  //...%@@.....%@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x50, 0x00, 0x00,  //.....+%@@@@%+....
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfd, 0x20, 0x00,  //...+@@@@@@@@@@...
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00,  //..+@@@@@@@@@@@@..
    0x04, 0xff, 0xfb, 0x51, 0x00, 0x27, 0xef, 0xfc, 0x00,  //..@@@%+....+@@@@.
    0x0d, 0xff, 0x50, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x50,  //.@@@+........@@@+
    0x4f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xa0,  //+@@%.........+@@%
    0x9f, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xd0,  //%@@...........@@@
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xaf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0x5f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0x0d, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x00,  //.@@@@..........%.
    0x04, 0xff, 0xfe, 0x83, 0x00, 0x13, 0x6c, 0xff, 0x00,  //.+@@@@%.....+@@@.
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x00, 0x04, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00,  //...+@@@@@@@@@@@+.
    0x00, 0x00, 0x05, 0xad, 0xef, 0xec, 0x83, 0x00, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00eb (ë) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0xff, 0xf0, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x50, 0x00, 0x00,  //.....+%@@@@%+....
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfd, 0x20, 0x00,  //...+@@@@@@@@@@...
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00,  //..+@@@@@@@@@@@@..
    0x04, 0xff, 0xfb, 0x51, 0x00, 0x27, 0xef, 0xfc, 0x00,  //..@@@%+....+@@@@.
    0x0d, 0xff, 0x50, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x50,  //.@@@+........@@@+
    0x4f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xa0,  //+@@%.........+@@%
    0x9f, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xd0,  //%@@...........@@@
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xaf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0x5f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0x0d, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x00,  //.@@@@..........%.
    0x04, 0xff, 0xfe, 0x83, 0x00, 0x13, 0x6c, 0xff, 0x00,  //.+@@@@%.....+@@@.
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x00, 0x04, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00,  //...+@@@@@@@@@@@+.
    0x00, 0x00, 0x05, 0xad, 0xef, 0xec, 0x83, 0x00, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00ec (ì) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0xa0, 0x00, 0x00,  //@@%....
    0xaf, 0xf7, 0x00, 0x00,  //%@@+...
    0x0b, 0xff, 0x40, 0x00,  //.%@@+..
    0x00, 0xcf, 0xe1, 0x00,  //..@@@..
    0x00, 0x1d, 0xfc, 0x00,  //...@@@.
    0x00, 0x01, 0xef, 0x90,  //....@@%
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x0f, 0xff, 0x00,  //...@@@.
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00ed (í) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0xbf, 0xf8,  //....%@@%
    0x00, 0x07, 0xff, 0xa0,  //...+@@%.
    0x00, 0x4f, 0xfb, 0x00,  //..+@@%..
    0x01, 0xef, 0xc0, 0x00,  //..@@@...
    0x0c, 0xfd, 0x10, 0x00,  //.@@@....
    0x9f, 0xe1, 0x00, 0x00,  //%@@.....
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x0f, 0xff, 0x00, 0x00,  //.@@@....
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00ee (î) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x2f, 0xff, 0x20, 0x00,  //...@@@....
    0x00, 0xcf, 0xff, 0xc0, 0x00,  //..@@@@@...
    0x08, 0xff, 0x6f, 0xf8, 0x00,  //.%@@+@@%..
    0x3f, 0xf6, 0x06, 0xff, 0x30,  //.@@+.+@@..
    0xef, 0x90, 0x00, 0x9f, 0xe0,  //@@%...%@@.
    0xfc, 0x00, 0x00, 0x0c, 0xfa,  //@@.....@@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00ef (ï) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00f0 (ð) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x07, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x20, 0x00,  //...+@@@+.........
    0x00, 0x00, 0x9f, 0xff, 0x50, 0x02, 0x8d, 0xf1, 0x00,  //....%@@@+...%@@..
    0x00, 0x00, 0x0b, 0xff, 0xf8, 0xdf, 0xfe, 0x91, 0x00,  //.....%@@@%@@@@%..
    0x00, 0x00, 0x02, 0xff, 0xff, 0xe9, 0x40, 0x00, 0x00,  //......@@@@@%+....
    0x00, 0x16, 0xcf, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00,  //...+@@@@@@@......
    0x04, 0xff, 0xfb, 0x54, 0xff, 0xfb, 0x00, 0x00, 0x00,  //.+@@@%++@@@%.....
    0x01, 0xb6, 0x10, 0x00, 0x5f, 0xff, 0x90, 0x00, 0x00,  //..%+....+@@@%....
    0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xf7, 0x00, 0x00,  //.........+@@@+...
    0x00, 0x00, 0x28, 0xce, 0xfe, 0xff, 0xff, 0x30, 0x00,  //.....%@@@@@@@@...
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //...%@@@@@@@@@@@..
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00,  //..%@@@@@@@@@@@@+.
    0x07, 0xff, 0xfd, 0x62, 0x00, 0x25, 0xdf, 0xfe, 0x00,  //.+@@@@+....+@@@@.
    0x1f, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x40,  //.@@@%........@@@+
    0x7f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x80,  //+@@@.........%@@%
    0xbf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xc0,  //%@@+.........+@@@
    0xef, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xd0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@...........@@@
    0xbf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xa0,  //%@@+.........+@@%
    0x6f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x60,  //+@@@.........@@@+
    0x0f, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xaf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x06, 0xff, 0xfc, 0x51, 0x01, 0x5c, 0xff, 0xf6, 0x00,  //.+@@@@+...+@@@@+.
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00,  //...+@@@@@@@@@+...
    0x00, 0x00, 0x18, 0xce, 0xfe, 0xc7, 0x10, 0x00, 0x00,  //.....+@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f1 (ñ) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x5d, 0xfb, 0x20, 0x00, 0xff, 0x00,  //....+@@%....@@..
    0x00, 0x03, 0xff, 0xff, 0xe3, 0x02, 0xfd, 0x00,  //....@@@@@...@@..
    0x00, 0x0a, 0xf8, 0x2e, 0xfe, 0x28, 0xfa, 0x00,  //...%@%.@@@.%@%..
    0x00, 0x0d, 0xf2, 0x03, 0xef, 0xff, 0xf3, 0x00,  //...@@...@@@@@...
    0x00, 0x0f, 0xf0, 0x00, 0x2b, 0xfe, 0x50, 0x00,  //...@@....%@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf0, 0x02, 0x8c, 0xef, 0xeb, 0x50, 0x00,  //@@@...%@@@@%+...
    0xff, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0xfb, 0x00,  //@@@.+@@@@@@@@%..
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //@@@%@@@@@@@@@@%.
    0xff, 0xff, 0xfb, 0x41, 0x01, 0x4c, 0xff, 0xf3,  //@@@@@%+...+@@@@.
    0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0xdf, 0xf9,  //@@@@+.......@@@%
    0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfd,  //@@@%........+@@@
    0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@+.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00f2 (ò) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x08, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@%..........
    0x00, 0x00, 0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@+.........
    0x00, 0x00, 0x0b, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //.....%@@+........
    0x00, 0x00, 0x00, 0xcf, 0xe1, 0x00, 0x00, 0x00, 0x00,  //......@@@........
    0x00, 0x00, 0x00, 0x1d, 0xfc, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x01, 0xef, 0x90, 0x00, 0x00, 0x00,  //........@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x28, 0xce, 0xfe, 0xc8, 0x20, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@@@@@%..
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //.+@@@@+...+@@@@+.
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x60,  //+@@@.........@@@+
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xa0,  //%@@+.........+@@%
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0,  //%@@+.........+@@%
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x60,  //+@@@.........@@@+
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //.+@@@@+...+@@@@+.
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x00, 0x28, 0xce, 0xfe, 0xc8, 0x20, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f3 (ó) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xf8, 0x00, 0x00,  //..........%@@%...
    0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0, 0x00, 0x00,  //.........+@@%....
    0x00, 0x00, 0x00, 0x00, 0x4f, 0xfb, 0x00, 0x00, 0x00,  //........+@@%.....
    0x00, 0x00, 0x00, 0x01, 0xef, 0xc0, 0x00, 0x00, 0x00,  //........@@@......
    0x00, 0x00, 0x00, 0x0c, 0xfd, 0x10, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x9f, 0xe1, 0x00, 0x00, 0x00, 0x00,  //......%@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x28, 0xce, 0xfe, 0xc8, 0x20, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@@@@@%..
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //.+@@@@+...+@@@@+.
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x60,  //+@@@.........@@@+
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xa0,  //%@@+.........+@@%
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0,  //%@@+.........+@@%
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x60,  //+@@@.........@@@+
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //.+@@@@+...+@@@@+.
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x00, 0x28, 0xce, 0xfe, 0xc8, 0x20, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f4 (ô) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x2f, 0xff, 0x20, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0xcf, 0xff, 0xc0, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x08, 0xff, 0x6f, 0xf8, 0x00, 0x00, 0x00,  //.....%@@+@@%.....
    0x00, 0x00, 0x3f, 0xf6, 0x06, 0xff, 0x30, 0x00, 0x00,  //.....@@+.+@@.....
    0x00, 0x00, 0xef, 0x90, 0x00, 0x9f, 0xe0, 0x00, 0x00,  //....@@%...%@@....
    0x00, 0x0a, 0xfc, 0x00, 0x00, 0x0c, 0xfa, 0x00, 0x00,  //...%@@.....@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x28, 0xce, 0xfe, 0xc8, 0x20, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@@@@@%..
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //.+@@@@+...+@@@@+.
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x60,  //+@@@.........@@@+
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xa0,  //%@@+.........+@@%
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0,  //%@@+.........+@@%
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x60,  //+@@@.........@@@+
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //.+@@@@+...+@@@@+.
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x00, 0x28, 0xce, 0xfe, 0xc8, 0x20, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f5 (õ) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x5d, 0xfb, 0x20, 0x00, 0xff, 0x00, 0x00,  //....+@@%....@@...
    0x00, 0x03, 0xff, 0xff, 0xe3, 0x02, 0xfd, 0x00, 0x00,  //....@@@@@...@@...
    0x00, 0x0a, 0xf8, 0x2e, 0xfe, 0x28, 0xfa, 0x00, 0x00,  //...%@%.@@@.%@%...
    0x00, 0x0d, 0xf2, 0x03, 0xef, 0xff, 0xf3, 0x00, 0x00,  //...@@...@@@@@....
    0x00, 0x0f, 0xf0, 0x00, 0x2b, 0xfe, 0x50, 0x00, 0x00,  //...@@....%@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x28, 0xce, 0xfe, 0xc8, 0x20, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@@@@@%..
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //.+@@@@+...+@@@@+.
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x60,  //+@@@.........@@@+
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xa0,  //%@@+.........+@@%
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0,  //%@@+.........+@@%
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x60,  //+@@@.........@@@+
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //.+@@@@+...+@@@@+.
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x00, 0x28, 0xce, 0xfe, 0xc8, 0x20, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f6 (ö) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0xff, 0xf0, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x28, 0xce, 0xfe, 0xc8, 0x20, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@@@@@%..
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //.+@@@@+...+@@@@+.
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x60,  //+@@@.........@@@+
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xa0,  //%@@+.........+@@%
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0,  //%@@+.........+@@%
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x60,  //+@@@.........@@@+
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //.+@@@@+...+@@@@+.
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x00, 0x28, 0xce, 0xfe, 0xc8, 0x20, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f7 (÷) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.........@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+00f8 (ø) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0x00,  //................+%.
    0x00, 0x00, 0x02, 0x8c, 0xef, 0xec, 0x71, 0x01, 0xef, 0x60,  //......+@@@@@+...@@+
    0x00, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x6a, 0xfc, 0x00,  //....%@@@@@@@@@+%@@.
    0x00, 0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x00,  //...%@@@@@@@@@@@@@..
    0x00, 0x7f, 0xff, 0xd5, 0x10, 0x15, 0xdf, 0xff, 0x80, 0x00,  //..+@@@@+...+@@@@%..
    0x01, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xd0, 0x00,  //..@@@%.......@@@@..
    0x07, 0xff, 0xe1, 0x00, 0x00, 0x02, 0xef, 0xff, 0xf4, 0x00,  //.+@@@.......@@@@@+.
    0x0b, 0xff, 0x80, 0x00, 0x00, 0x2e, 0xfa, 0x7f, 0xf9, 0x00,  //.%@@%......@@%+@@%.
    0x0e, 0xff, 0x30, 0x00, 0x01, 0xef, 0xb0, 0x2f, 0xfc, 0x00,  //.@@@......@@%..@@@.
    0x0f, 0xff, 0x10, 0x00, 0x1d, 0xfc, 0x00, 0x0f, 0xfe, 0x00,  //.@@@.....@@@...@@@.
    0x0f, 0xff, 0x00, 0x01, 0xdf, 0xc0, 0x00, 0x0f, 0xff, 0x00,  //.@@@....@@@....@@@.
    0x0e, 0xff, 0x00, 0x0c, 0xfd, 0x10, 0x00, 0x1f, 0xff, 0x00,  //.@@@...@@@.....@@@.
    0x0c, 0xff, 0x20, 0xbf, 0xd1, 0x00, 0x00, 0x3f, 0xfd, 0x00,  //.@@@..%@@......@@@.
    0x09, 0xff, 0x7b, 0xfe, 0x20, 0x00, 0x00, 0x7f, 0xfa, 0x00,  //.%@@+%@@......+@@%.
    0x04, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x01, 0xef, 0xf6, 0x00,  //.+@@@@@.......@@@+.
    0x00, 0xdf, 0xff, 0x30, 0x00, 0x00, 0x0b, 0xff, 0xf1, 0x00,  //..@@@@.......%@@@..
    0x00, 0x7f, 0xff, 0xc5, 0x10, 0x15, 0xdf, 0xff, 0x70, 0x00,  //..+@@@@+...+@@@@+..
    0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00,  //..@@@@@@@@@@@@@%...
    0x0b, 0xfa, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00,  //.%@%+@@@@@@@@@%....
    0x6f, 0xe0, 0x01, 0x8c, 0xef, 0xec, 0x82, 0x00, 0x00, 0x00,  //+@@...+@@@@@%......
    0x2c, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00f9 (ù) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x8f, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@%..........
    0x00, 0x0a, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //...%@@+.........
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00, 0x00, 0x00,  //....%@@+........
    0x00, 0x00, 0x0c, 0xfe, 0x10, 0x00, 0x00, 0x00,  //.....@@@........
    0x00, 0x00, 0x01, 0xdf, 0xc0, 0x00, 0x00, 0x00,  //......@@@.......
    0x00, 0x00, 0x00, 0x1e, 0xf9, 0x00, 0x00, 0x00,  //.......@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,  //@@@..........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff,  //@@@.........+@@@
    0xdf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff,  //@@@+........%@@@
    0x9f, 0xfc, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff,  //%@@@.......+@@@@
    0x3f, 0xff, 0xc4, 0x10, 0x14, 0xbf, 0xff, 0xff,  //.@@@@+...+%@@@@@
    0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,  //.%@@@@@@@@@@%@@@
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xf7, 0x0f, 0xff,  //..%@@@@@@@@+.@@@
    0x00, 0x05, 0xbe, 0xfe, 0xd8, 0x20, 0x0f, 0xff,  //...+%@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00fa (ú) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x80, 0x00,  //.........%@@%...
    0x00, 0x00, 0x00, 0x00, 0x7f, 0xfa, 0x00, 0x00,  //........+@@%....
    0x00, 0x00, 0x00, 0x04, 0xff, 0xb0, 0x00, 0x00,  //.......+@@%.....
    0x00, 0x00, 0x00, 0x1e, 0xfc, 0x00, 0x00, 0x00,  //.......@@@......
    0x00, 0x00, 0x00, 0xcf, 0xd1, 0x00, 0x00, 0x00,  //......@@@.......
    0x00, 0x00, 0x09, 0xfe, 0x10, 0x00, 0x00, 0x00,  //.....%@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,  //@@@..........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff,  //@@@.........+@@@
    0xdf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff,  //@@@+........%@@@
    0x9f, 0xfc, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff,  //%@@@.......+@@@@
    0x3f, 0xff, 0xc4, 0x10, 0x14, 0xbf, 0xff, 0xff,  //.@@@@+...+%@@@@@
    0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,  //.%@@@@@@@@@@%@@@
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xf7, 0x0f, 0xff,  //..%@@@@@@@@+.@@@
    0x00, 0x05, 0xbe, 0xfe, 0xd8, 0x20, 0x0f, 0xff,  //...+%@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00fb (û) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x7f, 0xf7, 0x00, 0x00, 0x00,  //......+@@+......
    0x00, 0x00, 0x02, 0xff, 0xff, 0x20, 0x00, 0x00,  //......@@@@......
    0x00, 0x00, 0x0c, 0xfb, 0xbf, 0xc0, 0x00, 0x00,  //.....%@%%@%.....
    0x00, 0x00, 0x6f, 0xe1, 0x1e, 0xf6, 0x00, 0x00,  //....+@@..@@+....
    0x00, 0x01, 0xef, 0x40, 0x04, 0xfe, 0x10, 0x00,  //....@@+..+@@....
    0x00, 0x0a, 0xf8, 0x00, 0x00, 0x8f, 0xa0, 0x00,  //...%@%....%@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,  //@@@..........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff,  //@@@.........+@@@
    0xdf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff,  //@@@+........%@@@
    0x9f, 0xfc, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff,  //%@@@.......+@@@@
    0x3f, 0xff, 0xc4, 0x10, 0x14, 0xbf, 0xff, 0xff,  //.@@@@+...+%@@@@@
    0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,  //.%@@@@@@@@@@%@@@
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xf7, 0x0f, 0xff,  //..%@@@@@@@@+.@@@
    0x00, 0x05, 0xbe, 0xfe, 0xd8, 0x20, 0x0f, 0xff,  //...+%@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00fc (ü) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0xff, 0xf0, 0x0f, 0xff, 0x00, 0x00,  //....@@@..@@@....
    0x00, 0x00, 0xff, 0xf0, 0x0f, 0xff, 0x00, 0x00,  //....@@@..@@@....
    0x00, 0x00, 0xff, 0xf0, 0x0f, 0xff, 0x00, 0x00,  //....@@@..@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,  //@@@..........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff,  //@@@.........+@@@
    0xdf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff,  //@@@+........%@@@
    0x9f, 0xfc, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff,  //%@@@.......+@@@@
    0x3f, 0xff, 0xc4, 0x10, 0x14, 0xbf, 0xff, 0xff,  //.@@@@+...+%@@@@@
    0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,  //.%@@@@@@@@@@%@@@
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xf7, 0x0f, 0xff,  //..%@@@@@@@@+.@@@
    0x00, 0x05, 0xbe, 0xfe, 0xd8, 0x20, 0x0f, 0xff,  //...+%@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00fd (ý) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x80, 0x00,  //...........%@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfa, 0x00, 0x00,  //..........+@@%....
    0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xb0, 0x00, 0x00,  //.........+@@%.....
    0x00, 0x00, 0x00, 0x00, 0x1e, 0xfc, 0x00, 0x00, 0x00,  //.........@@@......
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xd1, 0x00, 0x00, 0x00,  //........@@@.......
    0x00, 0x00, 0x00, 0x09, 0xfe, 0x10, 0x00, 0x00, 0x00,  //.......%@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xcf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc,  //@@@+..........+@@@
    0x6f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf6,  //+@@@..........@@@+
    0x0e, 0xff, 0x40, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0,  //.@@@+.........@@@.
    0x08, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x09, 0xff, 0x90,  //.%@@%........%@@%.
    0x02, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x30,  //..@@@........@@@..
    0x00, 0xbf, 0xf8, 0x00, 0x00, 0x00, 0x6f, 0xfd, 0x00,  //..%@@%......+@@@..
    0x00, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0xcf, 0xf7, 0x00,  //..+@@@......@@@+..
    0x00, 0x0e, 0xff, 0x50, 0x00, 0x02, 0xff, 0xf1, 0x00,  //...@@@+.....@@@...
    0x00, 0x07, 0xff, 0xc0, 0x00, 0x08, 0xff, 0xa0, 0x00,  //...+@@@....%@@%...
    0x00, 0x01, 0xff, 0xf3, 0x00, 0x0e, 0xff, 0x40, 0x00,  //....@@@....@@@+...
    0x00, 0x00, 0xaf, 0xf9, 0x00, 0x5f, 0xfd, 0x00, 0x00,  //....%@@%..+@@@....
    0x00, 0x00, 0x3f, 0xff, 0x00, 0xbf, 0xf7, 0x00, 0x00,  //.....@@@..%@@+....
    0x00, 0x00, 0x0d, 0xff, 0x62, 0xff, 0xf1, 0x00, 0x00,  //.....@@@+.@@@.....
    0x00, 0x00, 0x06, 0xff, 0xd8, 0xff, 0xa0, 0x00, 0x00,  //.....+@@@%@@%.....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00,  //......@@@@@@+.....
    0x00, 0x00, 0x00, 0x9f, 0xff, 0xfe, 0x00, 0x00, 0x00,  //......%@@@@@......
    0x00, 0x00, 0x00, 0x2f, 0xff, 0xf8, 0x00, 0x00, 0x00,  //.......@@@@+......
    0x00, 0x00, 0x00, 0x0c, 0xff, 0xf1, 0x00, 0x00, 0x00,  //.......%@@@.......
    0x00, 0x00, 0x00, 0x08, 0xff, 0xb0, 0x00, 0x00, 0x00,  //.......%@@%.......
    0x00, 0x00, 0x00, 0x0e, 0xff, 0x50, 0x00, 0x00, 0x00,  //.......@@@+.......
    0x00, 0x00, 0x00, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //......+@@@........
    0x00, 0x00, 0x00, 0xcf, 0xf8, 0x00, 0x00, 0x00, 0x00,  //......%@@%........
    0x00, 0x00, 0x19, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //.....%@@@.........
    0x00, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@%.........
    0x00, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@..........
    0x00, 0xff, 0xfe, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00fe (þ) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x03, 0x9d, 0xef, 0xd9, 0x30, 0x00, 0x00,  //@@@...%@@@@%.....
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //@@@.%@@@@@@@@%...
    0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //@@@%@@@@@@@@@@%..
    0xff, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //@@@@%.......%@@@.
    0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x50,  //@@@@.........@@@+
    0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0,  //@@@+.........+@@%
    0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0,  //@@@+.........+@@%
    0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x50,  //@@@@.........@@@+
    0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //@@@@%.......%@@@.
    0xff, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //@@@%@@@@@@@@@@%..
    0xff, 0xf0, 0x9f, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //@@@.%@@@@@@@@%...
    0xff, 0xf0, 0x03, 0x9d, 0xff, 0xd9, 0x30, 0x00, 0x00,  //@@@...%@@@@%.....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00ff (ÿ) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x0f, 0xff, 0x00, 0xff, 0xf0, 0x00, 0x00,  //.....@@@..@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0xff, 0xf0, 0x00, 0x00,  //.....@@@..@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0xff, 0xf0, 0x00, 0x00,  //.....@@@..@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xcf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc,  //@@@+..........+@@@
    0x6f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf6,  //+@@@..........@@@+
    0x0e, 0xff, 0x40, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0,  //.@@@+.........@@@.
    0x08, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x09, 0xff, 0x90,  //.%@@%........%@@%.
    0x02, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x30,  //..@@@........@@@..
    0x00, 0xbf, 0xf8, 0x00, 0x00, 0x00, 0x6f, 0xfd, 0x00,  //..%@@%......+@@@..
    0x00, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0xcf, 0xf7, 0x00,  //..+@@@......@@@+..
    0x00, 0x0e, 0xff, 0x50, 0x00, 0x02, 0xff, 0xf1, 0x00,  //...@@@+.....@@@...
    0x00, 0x07, 0xff, 0xc0, 0x00, 0x08, 0xff, 0xa0, 0x00,  //...+@@@....%@@%...
    0x00, 0x01, 0xff, 0xf3, 0x00, 0x0e, 0xff, 0x40, 0x00,  //....@@@....@@@+...
    0x00, 0x00, 0xaf, 0xf9, 0x00, 0x5f, 0xfd, 0x00, 0x00,  //....%@@%..+@@@....
    0x00, 0x00, 0x3f, 0xff, 0x00, 0xbf, 0xf7, 0x00, 0x00,  //.....@@@..%@@+....
    0x00, 0x00, 0x0d, 0xff, 0x62, 0xff, 0xf1, 0x00, 0x00,  //.....@@@+.@@@.....
    0x00, 0x00, 0x06, 0xff, 0xd8, 0xff, 0xa0, 0x00, 0x00,  //.....+@@@%@@%.....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00,  //......@@@@@@+.....
    0x00, 0x00, 0x00, 0x9f, 0xff, 0xfe, 0x00, 0x00, 0x00,  //......%@@@@@......
    0x00, 0x00, 0x00, 0x2f, 0xff, 0xf8, 0x00, 0x00, 0x00,  //.......@@@@+......
    0x00, 0x00, 0x00, 0x0c, 0xff, 0xf1, 0x00, 0x00, 0x00,  //.......%@@@.......
    0x00, 0x00, 0x00, 0x08, 0xff, 0xb0, 0x00, 0x00, 0x00,  //.......%@@%.......
    0x00, 0x00, 0x00, 0x0e, 0xff, 0x50, 0x00, 0x00, 0x00,  //.......@@@+.......
    0x00, 0x00, 0x00, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //......+@@@........
    0x00, 0x00, 0x00, 0xcf, 0xf8, 0x00, 0x00, 0x00, 0x00,  //......%@@%........
    0x00, 0x00, 0x19, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //.....%@@@.........
    0x00, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@%.........
    0x00, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@..........
    0x00, 0xff, 0xfe, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................



#elif USE_LV_FONT_DEJAVU_40_LATIN_SUP == 8
    /*Unicode: U+00a0 ( ) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00a1 (¡) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xb6, 0xff, 0xb8,  //%@%
    0xc2, 0xff, 0xc4,  //@@@
    0xd0, 0xff, 0xd2,  //@@@
    0xde, 0xff, 0xde,  //@@@
    0xea, 0xff, 0xea,  //@@@
    0xf8, 0xff, 0xf8,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00a2 (¢) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0x12, 0x6c, 0xba, 0xe8, 0xff, 0xff, 0xee, 0xce, 0xac, 0x6a, 0x22,  //.....+%@@@@@%+.
    0x00, 0x00, 0x00, 0x66, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...+@@@@@@@@@@@
    0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@
    0x00, 0x5a, 0xff, 0xff, 0xff, 0xe0, 0x6c, 0x24, 0xff, 0xff, 0x0e, 0x2c, 0x4c, 0x88, 0xd6,  //.+@@@@+.@@..+%@
    0x06, 0xe8, 0xff, 0xff, 0xc2, 0x0c, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@...@@.....
    0x5c, 0xff, 0xff, 0xec, 0x14, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@....@@.....
    0xa2, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%....@@.....
    0xd6, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@.....
    0xee, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@.....
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@.....
    0xee, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@.....
    0xd8, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@.....
    0xa4, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+....@@.....
    0x5e, 0xff, 0xff, 0xea, 0x12, 0x00, 0x00, 0x00, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@....@@.....
    0x08, 0xea, 0xff, 0xff, 0xbe, 0x0c, 0x00, 0x00, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%...@@.....
    0x00, 0x5e, 0xff, 0xff, 0xff, 0xde, 0x68, 0x22, 0xff, 0xfa, 0x0e, 0x2c, 0x50, 0x92, 0xda,  //.+@@@@+.@@..+%@
    0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x70, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...+@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x16, 0x72, 0xbe, 0xea, 0xff, 0xff, 0xf8, 0xda, 0xb2, 0x6e, 0x24,  //.....+%@@@@@%+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00a3 (£) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x9e, 0xd8, 0xf0, 0xf8, 0xe4, 0xb6, 0x6e, 0x24,  //........%@@@@%+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //......%@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....%@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xff, 0xba, 0x42, 0x0e, 0x02, 0x12, 0x3c, 0x7e, 0xd2,  //.....@@@%+....+@
    0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@@........
    0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@+........
    0x00, 0x00, 0x00, 0x00, 0xe6, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0x00, 0x00, 0xf6, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00a4 (¤) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x06, 0xae, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xc0, 0x0c,  //.%+............+%.
    0xae, 0xff, 0xfc, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xfc, 0xff, 0xb8,  //%@@+..........+@@%
    0x50, 0xfa, 0xff, 0xff, 0x7a, 0x00, 0x44, 0xb8, 0xf0, 0xf2, 0xb8, 0x46, 0x00, 0x7a, 0xff, 0xff, 0xf8, 0x46,  //+@@@+.+%@@%+.+@@@+
    0x00, 0x60, 0xfc, 0xff, 0xff, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0xff, 0xff, 0xfc, 0x5a, 0x00,  //.+@@@@@@@@@@@@@@+.
    0x00, 0x00, 0x70, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00,  //..+@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0xd4, 0x4c, 0x0a, 0x0a, 0x4a, 0xd2, 0xff, 0xff, 0xcc, 0x00, 0x00, 0x00,  //...%@@@+..+@@@@...
    0x00, 0x00, 0x42, 0xff, 0xff, 0xd4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xd2, 0xff, 0xff, 0x4e, 0x00, 0x00,  //..+@@@......@@@+..
    0x00, 0x00, 0xba, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xbc, 0x00, 0x00,  //..%@@+......+@@%..
    0x00, 0x00, 0xf2, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf2, 0x00, 0x00,  //..@@@........@@@..
    0x00, 0x00, 0xf0, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xf2, 0x00, 0x00,  //..@@@........@@@..
    0x00, 0x00, 0xb4, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xb8, 0x00, 0x00,  //..%@@+......+@@%..
    0x00, 0x00, 0x40, 0xff, 0xff, 0xd2, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xd6, 0xff, 0xfc, 0x3e, 0x00, 0x00,  //...@@@......@@@...
    0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0xd2, 0x4a, 0x0a, 0x0a, 0x4a, 0xd4, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00,  //...@@@@+..+@@@%...
    0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00,  //..+@@@@@@@@@@@@+..
    0x00, 0x64, 0xff, 0xff, 0xff, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xb8, 0xff, 0xff, 0xfc, 0x5c, 0x00,  //.+@@@@@@@@@@%@@@+.
    0x56, 0xfc, 0xff, 0xfc, 0x74, 0x00, 0x44, 0xb8, 0xf0, 0xf0, 0xb6, 0x3c, 0x00, 0x6a, 0xfc, 0xff, 0xfa, 0x4c,  //+@@@+.+%@@%..+@@@+
    0xbc, 0xff, 0xfa, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xf8, 0xff, 0xa4,  //%@@+..........+@@%
    0x0a, 0xb6, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xa0, 0x02,  //.%+............+%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00a5 (¥) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xb8, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xb8,  //%@@%...........%@@%
    0x30, 0xfc, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xfc, 0x2e,  //.@@@+.........+@@@.
    0x00, 0xa2, 0xff, 0xff, 0xd2, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xd4, 0xff, 0xff, 0xa0, 0x00,  //.%@@@.........@@@%.
    0x00, 0x1e, 0xf8, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xf6, 0x1c, 0x00,  //..@@@+.......+@@@..
    0x00, 0x00, 0x8c, 0xff, 0xff, 0xe6, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe8, 0xff, 0xff, 0x88, 0x00, 0x00,  //..%@@@.......@@@%..
    0x00, 0x00, 0x10, 0xee, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xec, 0x0e, 0x00, 0x00,  //...@@@%.....%@@@...
    0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xf4, 0x1c, 0x00, 0x00, 0x00, 0x20, 0xf6, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00,  //...+@@@.....@@@+...
    0x00, 0x00, 0x00, 0x08, 0xe2, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0xde, 0x04, 0x00, 0x00, 0x00,  //....@@@%...%@@@....
    0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xfc, 0x34, 0x00, 0x3a, 0xff, 0xff, 0xff, 0x58, 0x00, 0x00, 0x00, 0x00,  //....+@@@...@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0xff, 0xc0, 0x00, 0xc8, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@%.@@@@.....
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@%@@@@@@@@.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xf4, 0xff, 0xff, 0xff, 0xf2, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf8, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@@@@@.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00a6 (¦) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00a7 (§) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x34, 0x9e, 0xda, 0xf6, 0xf8, 0xe2, 0xb8, 0x7a, 0x2a, 0x00, 0x00,  //....%@@@@%+...
    0x00, 0x00, 0x80, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //..+@@@@@@@@@..
    0x00, 0x5a, 0xff, 0xff, 0xee, 0x68, 0x1c, 0x08, 0x2e, 0x88, 0xf2, 0xff, 0x00, 0x00,  //.+@@@+...%@@..
    0x00, 0xca, 0xff, 0xff, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xaa, 0x00, 0x00,  //.@@@+......%..
    0x00, 0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@..........
    0x00, 0xe8, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@+.........
    0x00, 0x9c, 0xff, 0xff, 0xe4, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@.........
    0x00, 0x16, 0xe0, 0xff, 0xff, 0xf0, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@+.......
    0x00, 0x00, 0x26, 0xf2, 0xff, 0xff, 0xff, 0xc2, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@......
    0x00, 0x3e, 0xe4, 0xff, 0xe0, 0xfc, 0xff, 0xff, 0xfc, 0x9c, 0x14, 0x00, 0x00, 0x00,  //..@@@@@@@%....
    0x2c, 0xf4, 0xff, 0xd4, 0x0e, 0x2a, 0xb2, 0xff, 0xff, 0xff, 0xec, 0x5a, 0x00, 0x00,  //.@@@..%@@@@+..
    0xae, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x46, 0xda, 0xff, 0xff, 0xff, 0x8e, 0x00,  //%@@....+@@@@%.
    0xea, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x08, 0x9c, 0xff, 0xff, 0xff, 0x60,  //@@@......%@@@+
    0xf4, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xd2,  //@@@.......%@@@
    0xba, 0xff, 0xff, 0xcc, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xf6,  //%@@@.......@@@
    0x38, 0xfa, 0xff, 0xff, 0xd8, 0x36, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xdc,  //.@@@@......@@@
    0x00, 0x4a, 0xee, 0xff, 0xff, 0xfc, 0x96, 0x12, 0x00, 0x00, 0x6c, 0xff, 0xff, 0x84,  //.+@@@@%...+@@%
    0x00, 0x00, 0x1e, 0xb6, 0xff, 0xff, 0xff, 0xee, 0x7a, 0x44, 0xf2, 0xff, 0xc8, 0x0c,  //...%@@@@++@@@.
    0x00, 0x00, 0x00, 0x00, 0x50, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x98, 0x0c, 0x00,  //....+@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x76, 0xf4, 0xff, 0xff, 0xf2, 0x46, 0x00, 0x00,  //......+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xce, 0xff, 0xff, 0xf6, 0x32, 0x00,  //........@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xc8, 0xff, 0xff, 0xb8, 0x00,  //.........@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xf2, 0x00,  //..........@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xec, 0x00,  //..........@@@.
    0x00, 0xb2, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0xb4, 0x00,  //.%.......+@@%.
    0x00, 0xff, 0xfa, 0xa6, 0x4a, 0x12, 0x08, 0x26, 0x80, 0xf6, 0xff, 0xfc, 0x38, 0x00,  //.@@%+...+@@@..
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x56, 0x00, 0x00,  //.@@@@@@@@@@+..
    0x00, 0x24, 0x6e, 0xaa, 0xd6, 0xf2, 0xfa, 0xee, 0xc8, 0x82, 0x1a, 0x00, 0x00, 0x00,  //..+%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00a8 (¨) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00a9 (©) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x4a, 0x9a, 0xce, 0xe6, 0xf8, 0xe6, 0xce, 0x9a, 0x4a, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x66, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x66, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x1a, 0xca, 0xff, 0xff, 0xce, 0x7a, 0x34, 0x18, 0x04, 0x16, 0x32, 0x76, 0xc8, 0xff, 0xff, 0xca, 0x1a, 0x00, 0x00, 0x00, 0x00,  //.....@@@@+.....+@@@@.....
    0x00, 0x00, 0x00, 0x30, 0xe6, 0xff, 0xde, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xd6, 0xff, 0xe4, 0x30, 0x00, 0x00, 0x00,  //....@@@+.........+@@@....
    0x00, 0x00, 0x1c, 0xe6, 0xff, 0xbe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xb2, 0xff, 0xe6, 0x1a, 0x00, 0x00,  //...@@%.............%@@...
    0x00, 0x04, 0xcc, 0xff, 0xbe, 0x04, 0x00, 0x00, 0x14, 0x7c, 0xc2, 0xe8, 0xfa, 0xee, 0xc8, 0x80, 0x2a, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xcc, 0x04, 0x00,  //..@@%....+@@@@@+....%@@..
    0x00, 0x6c, 0xff, 0xde, 0x12, 0x00, 0x00, 0x5a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x0c, 0xd6, 0xff, 0x68, 0x00,  //.+@@...+@@@@@@@@@....@@+.
    0x0a, 0xe8, 0xff, 0x54, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xfa, 0x8c, 0x2e, 0x08, 0x08, 0x28, 0x6a, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xe6, 0x08,  //.@@+..+@@@%....+@....+@@.
    0x50, 0xff, 0xce, 0x00, 0x00, 0x16, 0xf4, 0xff, 0xfc, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0x4c,  //+@@...@@@+............@@+
    0x9c, 0xff, 0x7a, 0x00, 0x00, 0x80, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0x9a,  //%@+..+@@%.............+@%
    0xd0, 0xff, 0x34, 0x00, 0x00, 0xc6, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xce,  //@@...@@@...............@@
    0xe6, 0xff, 0x16, 0x00, 0x00, 0xec, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xe6,  //@@...@@@...............@@
    0xf8, 0xff, 0x04, 0x00, 0x00, 0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xf8,  //@@...@@@...............@@
    0xe8, 0xff, 0x16, 0x00, 0x00, 0xea, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xe6,  //@@...@@@...............@@
    0xd0, 0xff, 0x34, 0x00, 0x00, 0xc4, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xce,  //@@...@@@...............@@
    0x9e, 0xff, 0x78, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0x9c,  //%@+..+@@%.............+@%
    0x52, 0xff, 0xcc, 0x00, 0x00, 0x14, 0xf4, 0xff, 0xfc, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0x4e,  //+@@...@@@+............@@+
    0x0a, 0xea, 0xff, 0x54, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xfa, 0x94, 0x32, 0x0a, 0x0a, 0x2a, 0x62, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xe8, 0x08,  //.@@+..+@@@%....+@....+@@.
    0x00, 0x6c, 0xff, 0xde, 0x12, 0x00, 0x00, 0x5a, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x0c, 0xd6, 0xff, 0x6a, 0x00,  //.+@@...+@@@@@@@@@....@@+.
    0x00, 0x04, 0xce, 0xff, 0xc0, 0x04, 0x00, 0x00, 0x14, 0x7c, 0xc4, 0xea, 0xf8, 0xe6, 0xca, 0x90, 0x34, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xcc, 0x04, 0x00,  //..@@%....+@@@@@%....%@@..
    0x00, 0x00, 0x1c, 0xe6, 0xff, 0xc0, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xb4, 0xff, 0xe6, 0x1c, 0x00, 0x00,  //...@@%.............%@@...
    0x00, 0x00, 0x00, 0x30, 0xe6, 0xff, 0xde, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xd8, 0xff, 0xe4, 0x30, 0x00, 0x00, 0x00,  //....@@@+.........+@@@....
    0x00, 0x00, 0x00, 0x00, 0x1a, 0xca, 0xff, 0xff, 0xce, 0x7a, 0x34, 0x16, 0x04, 0x16, 0x32, 0x74, 0xc8, 0xff, 0xff, 0xca, 0x1a, 0x00, 0x00, 0x00, 0x00,  //.....@@@@+.....+@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x68, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x68, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x4e, 0x9c, 0xce, 0xe8, 0xf8, 0xe8, 0xce, 0x9c, 0x4e, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+00aa (ª) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x2c, 0x7e, 0xbc, 0xe6, 0xf8, 0xf4, 0xda, 0x9e, 0x34, 0x00, 0x00, 0x00,  //..+%@@@@%....
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x72, 0x00, 0x00,  //.@@@@@@@@@+..
    0x00, 0xcc, 0x70, 0x30, 0x0a, 0x06, 0x22, 0x78, 0xf2, 0xff, 0xfc, 0x38, 0x00,  //.@+....+@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xa4, 0x00,  //........+@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xde, 0x00,  //.........@@@.
    0x00, 0x00, 0x48, 0xa6, 0xda, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00,  //..+%@@@@@@@@.
    0x04, 0xaa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.%@@@@@@@@@@.
    0x78, 0xff, 0xff, 0xe2, 0x56, 0x1a, 0x04, 0x00, 0x02, 0xff, 0xff, 0xff, 0x00,  //+@@@+....@@@.
    0xd6, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xff, 0x00,  //@@@......@@@.
    0xf8, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xff, 0x00,  //@@@.....+@@@.
    0xec, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x02, 0xd2, 0xff, 0xff, 0xff, 0x00,  //@@@.....@@@@.
    0xa6, 0xff, 0xff, 0xd4, 0x3a, 0x08, 0x26, 0xb0, 0xfa, 0xff, 0xff, 0xff, 0x00,  //%@@@...%@@@@.
    0x22, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x60, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@+@@@.
    0x00, 0x1e, 0xa0, 0xe6, 0xf8, 0xe4, 0xa6, 0x34, 0x00, 0xff, 0xff, 0xff, 0x00,  //..%@@@%..@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x06,  //%@@@@@@@@@@@.
    0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x06,  //%@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00ab («) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x90,  //.......%......%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xb4, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xb4, 0xff,  //......%@.....%@
    0x00, 0x00, 0x00, 0x00, 0x1a, 0xce, 0xff, 0xe8, 0x00, 0x00, 0x00, 0x1a, 0xce, 0xff, 0xe8,  //.....@@@....@@@
    0x00, 0x00, 0x00, 0x32, 0xe4, 0xff, 0xd6, 0x20, 0x00, 0x00, 0x32, 0xe4, 0xff, 0xd6, 0x20,  //....@@@....@@@.
    0x00, 0x00, 0x4e, 0xf4, 0xff, 0xbc, 0x0e, 0x00, 0x00, 0x4e, 0xf4, 0xff, 0xbc, 0x0e, 0x00,  //..+@@%...+@@%..
    0x00, 0x72, 0xfc, 0xff, 0x9c, 0x04, 0x00, 0x00, 0x72, 0xfc, 0xff, 0x9c, 0x04, 0x00, 0x00,  //.+@@%...+@@%...
    0x98, 0xff, 0xfc, 0x78, 0x00, 0x00, 0x00, 0x98, 0xff, 0xfc, 0x78, 0x00, 0x00, 0x00, 0x00,  //%@@+...%@@+....
    0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@%....@@%.....
    0x98, 0xff, 0xfc, 0x76, 0x00, 0x00, 0x00, 0x98, 0xff, 0xfc, 0x76, 0x00, 0x00, 0x00, 0x00,  //%@@+...%@@+....
    0x00, 0x72, 0xfc, 0xff, 0x9a, 0x04, 0x00, 0x00, 0x72, 0xfc, 0xff, 0x9a, 0x04, 0x00, 0x00,  //.+@@%...+@@%...
    0x00, 0x00, 0x4e, 0xf4, 0xff, 0xbc, 0x0e, 0x00, 0x00, 0x4e, 0xf4, 0xff, 0xbc, 0x0e, 0x00,  //..+@@%...+@@%..
    0x00, 0x00, 0x00, 0x32, 0xe4, 0xff, 0xd6, 0x20, 0x00, 0x00, 0x32, 0xe4, 0xff, 0xd6, 0x20,  //....@@@....@@@.
    0x00, 0x00, 0x00, 0x00, 0x1c, 0xd0, 0xff, 0xe8, 0x00, 0x00, 0x00, 0x1c, 0xd0, 0xff, 0xe8,  //.....@@@....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xb4, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xb4, 0xff,  //......%@.....%@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x92,  //.......%......%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00ac (¬) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+00ad (­) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00ae (®) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x4a, 0x9a, 0xce, 0xe6, 0xf8, 0xe6, 0xce, 0x9a, 0x4a, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x66, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x66, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x1a, 0xca, 0xff, 0xff, 0xce, 0x7a, 0x34, 0x18, 0x04, 0x16, 0x32, 0x76, 0xc8, 0xff, 0xff, 0xca, 0x1a, 0x00, 0x00, 0x00, 0x00,  //.....@@@@+.....+@@@@.....
    0x00, 0x00, 0x00, 0x30, 0xe6, 0xff, 0xde, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xd6, 0xff, 0xe4, 0x30, 0x00, 0x00, 0x00,  //....@@@+.........+@@@....
    0x00, 0x00, 0x1c, 0xe6, 0xff, 0xbe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xb2, 0xff, 0xe6, 0x1a, 0x00, 0x00,  //...@@%.............%@@...
    0x00, 0x04, 0xcc, 0xff, 0xbe, 0x04, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xd4, 0x92, 0x20, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xcc, 0x04, 0x00,  //..@@%...@@@@@@@%....%@@..
    0x00, 0x6c, 0xff, 0xde, 0x12, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x32, 0x00, 0x00, 0x0c, 0xd6, 0xff, 0x68, 0x00,  //.+@@....@@@@@@@@@....@@+.
    0x0a, 0xe8, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x1a, 0x9c, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xe6, 0x08,  //.@@+....@@@...%@@%...+@@.
    0x50, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0x4c,  //+@@.....@@@....@@@....@@+
    0x9c, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xe4, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0x9a,  //%@+.....@@@....@@@....+@%
    0xd0, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x1a, 0x98, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xce,  //@@......@@@...%@@%.....@@
    0xe6, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xe6,  //@@......@@@@@@@@%......@@
    0xf8, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xf8,  //@@......@@@@@@@........@@
    0xe8, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x36, 0xec, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xe6,  //@@......@@@..@@+.......@@
    0xd0, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x70, 0xff, 0xfa, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xce,  //@@......@@@..+@@.......@@
    0x9e, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x0c, 0xf2, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0x9c,  //%@+.....@@@...@@%.....+@%
    0x52, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0x4e,  //+@@.....@@@...%@@.....@@+
    0x0a, 0xea, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x12, 0xf2, 0xff, 0xbc, 0x00, 0x00, 0x00, 0x48, 0xff, 0xe8, 0x08,  //.@@+....@@@....@@%...+@@.
    0x00, 0x6c, 0xff, 0xde, 0x12, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0x3e, 0x00, 0x0c, 0xd6, 0xff, 0x6a, 0x00,  //.+@@....@@@....%@@...@@+.
    0x00, 0x04, 0xce, 0xff, 0xc0, 0x04, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x10, 0xf0, 0xff, 0xbe, 0x00, 0xb2, 0xff, 0xcc, 0x04, 0x00,  //..@@%...@@@.....@@%.%@@..
    0x00, 0x00, 0x1c, 0xe6, 0xff, 0xc0, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xb4, 0xff, 0xe6, 0x1c, 0x00, 0x00,  //...@@%.............%@@...
    0x00, 0x00, 0x00, 0x30, 0xe6, 0xff, 0xde, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xd8, 0xff, 0xe4, 0x30, 0x00, 0x00, 0x00,  //....@@@+.........+@@@....
    0x00, 0x00, 0x00, 0x00, 0x1a, 0xca, 0xff, 0xff, 0xce, 0x7a, 0x34, 0x16, 0x04, 0x16, 0x32, 0x74, 0xc8, 0xff, 0xff, 0xca, 0x1a, 0x00, 0x00, 0x00, 0x00,  //.....@@@@+.....+@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x68, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x68, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x4e, 0x9c, 0xce, 0xe8, 0xf8, 0xe8, 0xce, 0x9c, 0x4e, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+%@@@@@%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+00af (¯) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00b0 (°) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x24, 0x9c, 0xe2, 0xf8, 0xe0, 0x98, 0x20, 0x00, 0x00,  //...%@@@%...
    0x00, 0x48, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x42, 0x00,  //.+@@@@@@@+.
    0x22, 0xf2, 0xff, 0xa6, 0x28, 0x04, 0x28, 0xa8, 0xff, 0xf0, 0x20,  //.@@%...%@@.
    0x9a, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0x96,  //%@%.....%@%
    0xe2, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xe0,  //@@.......@@
    0xf8, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xf8,  //@@.......@@
    0xe6, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xe4,  //@@.......@@
    0xa4, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xff, 0x9e,  //%@%.....%@%
    0x2c, 0xf8, 0xff, 0xac, 0x2e, 0x0a, 0x2e, 0xac, 0xff, 0xf4, 0x24,  //.@@%...%@@.
    0x00, 0x58, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x4c, 0x00,  //.+@@@@@@@+.
    0x00, 0x00, 0x2c, 0xa4, 0xe6, 0xf8, 0xe2, 0x9e, 0x24, 0x00, 0x00,  //...%@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00b1 (±) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+00b2 (²) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x2a, 0x7e, 0xbe, 0xea, 0xfa, 0xee, 0xc6, 0x74, 0x08, 0x00,  //.+%@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x1a,  //@@@@@@@@@.
    0xd2, 0x80, 0x3e, 0x12, 0x04, 0x1a, 0x66, 0xea, 0xff, 0xac,  //@+....+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xf2,  //.......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xe2,  //........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0x7e,  //.......%@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xd6, 0x08,  //......+@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xfc, 0xee, 0x28, 0x00,  //.....+@@..
    0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xf4, 0x3c, 0x00, 0x00,  //....%@@...
    0x00, 0x00, 0x0e, 0xb2, 0xff, 0xf4, 0x42, 0x00, 0x00, 0x00,  //...%@@+...
    0x00, 0x28, 0xd8, 0xff, 0xea, 0x38, 0x00, 0x00, 0x00, 0x00,  //..@@@.....
    0x56, 0xf2, 0xff, 0xc6, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00b3 (³) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x26, 0x74, 0xbc, 0xea, 0xfa, 0xf0, 0xd0, 0x8e, 0x22, 0x00,  //.+%@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x4a,  //@@@@@@@@@+
    0xd4, 0x7e, 0x3c, 0x18, 0x04, 0x10, 0x3e, 0xae, 0xff, 0xda,  //@+.....%@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf0,  //........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x34, 0xaa, 0xff, 0x9e,  //.......%@%
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x8a, 0x06,  //...@@@@@%.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xa2, 0x04,  //...@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x02, 0x1a, 0x5e, 0xe6, 0xff, 0x80,  //......+@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xdc,  //.......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xf6,  //........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xe0,  //.......+@@
    0xc0, 0x5c, 0x2a, 0x0e, 0x08, 0x24, 0x76, 0xee, 0xff, 0x8a,  //%+....+@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0a,  //@@@@@@@@%.
    0x2c, 0x86, 0xd0, 0xf4, 0xf8, 0xe6, 0xb6, 0x5e, 0x02, 0x00,  //.%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00b4 (´) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0x8a,  //....%@@%
    0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xa0, 0x00,  //...+@@%.
    0x00, 0x00, 0x46, 0xfc, 0xff, 0xb6, 0x02, 0x00,  //..+@@%..
    0x00, 0x1e, 0xec, 0xff, 0xc8, 0x0a, 0x00, 0x00,  //..@@@...
    0x06, 0xcc, 0xff, 0xd6, 0x12, 0x00, 0x00, 0x00,  //.@@@....
    0x9a, 0xff, 0xe4, 0x1e, 0x00, 0x00, 0x00, 0x00,  //%@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00b5 (µ) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..........@@@..
    0xff, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..........@@@..
    0xff, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@+........+@@@..
    0xff, 0xff, 0xff, 0xd0, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xf2, 0xff, 0xff, 0xff, 0x02, 0x00,  //@@@@........@@@@..
    0xff, 0xff, 0xff, 0xff, 0xd6, 0x5c, 0x1a, 0x04, 0x0a, 0x2e, 0x80, 0xf2, 0xff, 0xff, 0xff, 0xff, 0x44, 0x00,  //@@@@@+....+@@@@@+.
    0xff, 0xff, 0xff, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0xbe, 0xff, 0xff, 0xff, 0xff,  //@@@%@@@@@@@@@%@@@@
    0xff, 0xff, 0xff, 0x18, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x1c, 0x66, 0xff, 0xff, 0xff, 0xff,  //@@@.@@@@@@@@.+@@@@
    0xff, 0xff, 0xff, 0x00, 0x0c, 0x7a, 0xce, 0xf0, 0xf0, 0xce, 0x76, 0x0a, 0x00, 0x02, 0x9a, 0xf0, 0xd8, 0x6c,  //@@@..+@@@@+...%@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00b6 (¶) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x02, 0x52, 0xa2, 0xd8, 0xee, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....+%@@@@@@@@@
    0x00, 0x00, 0x3a, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@@@@@@@
    0x00, 0x4a, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //.+@@@@@@@@...@@
    0x18, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //.@@@@@@@@@...@@
    0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //%@@@@@@@@@...@@
    0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@@@@@@@@...@@
    0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@@@@@@@@...@@
    0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@@@@@@@@...@@
    0xd2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@@@@@@@@...@@
    0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //%@@@@@@@@@...@@
    0x16, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //.@@@@@@@@@...@@
    0x00, 0x46, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //.+@@@@@@@@...@@
    0x00, 0x00, 0x2e, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //...@@@@@@@...@@
    0x00, 0x00, 0x00, 0x00, 0x3c, 0x8a, 0xc4, 0xe6, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //.....%@@@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //........@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00b7 (·) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00b8 (¸) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0xc8, 0xff, 0x6a, 0x00,  //...@@+.
    0x00, 0x00, 0x00, 0x64, 0xff, 0xfa, 0x2c,  //...+@@.
    0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xb0,  //....@@%
    0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf2,  //....@@@
    0x94, 0x22, 0x0a, 0x7c, 0xff, 0xff, 0xe8,  //%..+@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8c,  //@@@@@@%
    0xb4, 0xe2, 0xf6, 0xf0, 0xce, 0x6e, 0x02,  //%@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00b9 (¹) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x26, 0x78, 0xca, 0xff, 0xff, 0x00, 0x00, 0x00,  //.+@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@@@...
    0xd4, 0x7e, 0x2a, 0xff, 0xff, 0x00, 0x00, 0x00,  //@+.@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00ba (º) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x58, 0xb6, 0xe8, 0xf8, 0xe8, 0xb6, 0x5c, 0x00, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x0e, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x0e, 0x00,  //..%@@@@@@@%..
    0x00, 0xb2, 0xff, 0xff, 0xc0, 0x2e, 0x06, 0x2e, 0xbe, 0xff, 0xff, 0xb4, 0x00,  //.%@@%...%@@%.
    0x48, 0xff, 0xff, 0xe0, 0x0a, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x48,  //+@@@.....@@@+
    0xa6, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xa6,  //%@@+.....+@@%
    0xde, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xde,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xf6,  //@@@.......@@@
    0xde, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xde,  //@@@.......@@@
    0xa8, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //%@@+.....+@@%
    0x4a, 0xff, 0xff, 0xde, 0x08, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //+@@@.....@@@+
    0x00, 0xb6, 0xff, 0xff, 0xbe, 0x2e, 0x04, 0x2c, 0xbc, 0xff, 0xff, 0xba, 0x00,  //.%@@%...%@@%.
    0x00, 0x0e, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //..%@@@@@@@@..
    0x00, 0x00, 0x00, 0x5a, 0xb8, 0xe8, 0xfa, 0xea, 0xba, 0x5e, 0x02, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x2a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x32,  //.@@@@@@@@@@@.
    0x2a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x32,  //.@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00bb (») , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x90, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%......%.......
    0xff, 0xb2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0xff, 0xb2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,  //@%.....@%......
    0xea, 0xff, 0xce, 0x1a, 0x00, 0x00, 0x00, 0xea, 0xff, 0xce, 0x1a, 0x00, 0x00, 0x00, 0x00,  //@@@....@@@.....
    0x20, 0xd6, 0xff, 0xe4, 0x30, 0x00, 0x00, 0x20, 0xd6, 0xff, 0xe4, 0x30, 0x00, 0x00, 0x00,  //.@@@....@@@....
    0x00, 0x10, 0xbc, 0xff, 0xf2, 0x4e, 0x00, 0x00, 0x10, 0xbc, 0xff, 0xf2, 0x4e, 0x00, 0x00,  //..%@@+...%@@+..
    0x00, 0x00, 0x04, 0x9c, 0xff, 0xfc, 0x70, 0x00, 0x00, 0x04, 0x9c, 0xff, 0xfc, 0x70, 0x00,  //...%@@+...%@@+.
    0x00, 0x00, 0x00, 0x00, 0x78, 0xfc, 0xff, 0x96, 0x00, 0x00, 0x00, 0x78, 0xfc, 0xff, 0x96,  //....+@@%...+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff,  //.....%@@....%@@
    0x00, 0x00, 0x00, 0x00, 0x76, 0xfc, 0xff, 0x96, 0x00, 0x00, 0x00, 0x76, 0xfc, 0xff, 0x96,  //....+@@%...+@@%
    0x00, 0x00, 0x04, 0x9c, 0xff, 0xfc, 0x72, 0x00, 0x00, 0x04, 0x9c, 0xff, 0xfc, 0x72, 0x00,  //...%@@+...%@@+.
    0x00, 0x0e, 0xbc, 0xff, 0xf4, 0x4e, 0x00, 0x00, 0x0e, 0xbc, 0xff, 0xf4, 0x4e, 0x00, 0x00,  //..%@@+...%@@+..
    0x20, 0xd6, 0xff, 0xe4, 0x32, 0x00, 0x00, 0x20, 0xd6, 0xff, 0xe4, 0x32, 0x00, 0x00, 0x00,  //.@@@....@@@....
    0xea, 0xff, 0xce, 0x1a, 0x00, 0x00, 0x00, 0xea, 0xff, 0xce, 0x1a, 0x00, 0x00, 0x00, 0x00,  //@@@....@@@.....
    0xff, 0xb2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0xff, 0xb2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,  //@%.....@%......
    0x90, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%......%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00bc (¼) , Width: 28 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x26, 0x78, 0xca, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@...............%@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xf0, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@..............+@@......
    0xd4, 0x7e, 0x2a, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xe0, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+.@@..............@@+......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xca, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.............%@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xfa, 0xfa, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.............@@........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@............@@%........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xe0, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@...........+@@.........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf0, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@...........@@+.........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@..........%@%..........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xf0, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.........+@@...........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xe0, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.........@@+...........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xea, 0xff, 0xff, 0x00, 0x00,  //...@@........%@@.......@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x30, 0xfa, 0xfa, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@@@@@@.....@@.......%@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xa0, 0xff, 0xff, 0x00, 0x00,  //@@@@@@@@....@@%......+@%@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xde, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xf6, 0xd6, 0x0a, 0xff, 0xff, 0x00, 0x00,  //...........+@@.......@@.@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf0, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd0, 0xf4, 0x2c, 0x00, 0xff, 0xff, 0x00, 0x00,  //...........@@+......@@..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x64, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..........%@%......%@+..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xee, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xfc, 0xa4, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //.........+@@......+@%...@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xe0, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xe4, 0xd8, 0x0a, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //.........@@+......@@....@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xf6, 0x2e, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //........%@@......%@.....@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xfa, 0xfa, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //........@@.......@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xca, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.......@@%.......@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xdc, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //......+@@...............@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf2, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //......@@+...............@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //.....%@%................@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................


    /*Unicode: U+00bd (½) , Width: 28 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x26, 0x78, 0xca, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@...............%@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xf0, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@..............+@@......
    0xd4, 0x7e, 0x2a, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xe0, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+.@@..............@@+......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xca, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.............%@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xfa, 0xfa, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.............@@........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@............@@%........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xe0, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@...........+@@.........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf0, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@...........@@+.........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@..........%@%..........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xf0, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.........+@@...........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xe0, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.........@@+...........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xc8, 0x00, 0x00, 0x2a, 0x7e, 0xbe, 0xea, 0xfa, 0xee, 0xc6, 0x74, 0x08, 0x00,  //...@@........%@@...+%@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x30, 0xfa, 0xfa, 0x2e, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x1a,  //@@@@@@@@.....@@...@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0x8a, 0x00, 0x00, 0x00, 0xd2, 0x80, 0x3e, 0x12, 0x04, 0x1a, 0x66, 0xea, 0xff, 0xac,  //@@@@@@@@....@@%...@+....+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xde, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xf2,  //...........+@@...........+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf0, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xe2,  //...........@@+............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0x7e,  //..........%@%............%@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xee, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xd6, 0x08,  //.........+@@............+@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xe0, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xfc, 0xee, 0x28, 0x00,  //.........@@+...........+@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xf4, 0x3c, 0x00, 0x00,  //........%@@...........%@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xfa, 0xfa, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xb2, 0xff, 0xf4, 0x42, 0x00, 0x00, 0x00,  //........@@...........%@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xca, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xd8, 0xff, 0xea, 0x38, 0x00, 0x00, 0x00, 0x00,  //.......@@%..........@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xdc, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xf2, 0xff, 0xc6, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@.........+@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf2, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //......@@+.........@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....%@%..........@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................


    /*Unicode: U+00be (¾) , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x26, 0x74, 0xbc, 0xea, 0xfa, 0xf0, 0xd0, 0x8e, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+%@@@@%.............%@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xf0, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@+..........+@@......
    0xd4, 0x7e, 0x3c, 0x18, 0x04, 0x10, 0x3e, 0xae, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xe0, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+.....%@@..........@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xca, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@.........%@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x34, 0xaa, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xfa, 0xfa, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@%.........@@........
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x8a, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@%.........@@%........
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xa2, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xe0, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@%........+@@.........
    0x00, 0x00, 0x00, 0x00, 0x02, 0x1a, 0x5e, 0xe6, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf0, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@+.......@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@......%@%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xf0, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@.....+@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xe0, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@.....@@+...........
    0xc0, 0x5c, 0x2a, 0x0e, 0x08, 0x24, 0x76, 0xee, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xea, 0xff, 0xff, 0x00, 0x00,  //%+....+@@%....%@@.......@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0a, 0x00, 0x00, 0x00, 0x30, 0xfa, 0xfa, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@@@@@@%.....@@.......%@@@..
    0x2c, 0x86, 0xd0, 0xf4, 0xf8, 0xe6, 0xb6, 0x5e, 0x02, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xa0, 0xff, 0xff, 0x00, 0x00,  //.%@@@@%+.....@@%......+@%@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xde, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xf6, 0xd6, 0x0a, 0xff, 0xff, 0x00, 0x00,  //............+@@.......@@.@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf0, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd0, 0xf4, 0x2c, 0x00, 0xff, 0xff, 0x00, 0x00,  //............@@+......@@..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x64, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //...........%@%......%@+..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xee, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xfc, 0xa4, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..........+@@......+@%...@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xe0, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xe4, 0xd8, 0x0a, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..........@@+......@@....@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xf6, 0x2e, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //.........%@@......%@.....@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xfa, 0xfa, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.........@@.......@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xca, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //........@@%.......@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xdc, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //.......+@@...............@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf2, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //.......@@+...............@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //......%@%................@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+00bf (¿) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xde, 0x00, 0x00, 0x00, 0x00,  //......@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00,  //.....%@@%....
    0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00,  //....%@@@.....
    0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@%.....
    0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xca, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@@......
    0x00, 0x54, 0xff, 0xff, 0xff, 0xd6, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@.......
    0x12, 0xee, 0xff, 0xff, 0xd4, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@........
    0x86, 0xff, 0xff, 0xd8, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@.........
    0xd4, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+.........
    0xf6, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xf0, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xc6, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xb8,  //@@@%........%
    0x6e, 0xff, 0xff, 0xff, 0xb6, 0x3e, 0x12, 0x08, 0x28, 0x66, 0xc0, 0xff, 0xff,  //+@@@%....+%@@
    0x06, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@
    0x00, 0x18, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x48,  //..@@@@@@@@@@+
    0x00, 0x00, 0x02, 0x5c, 0xb6, 0xe8, 0xfa, 0xee, 0xd2, 0x9a, 0x44, 0x00, 0x00,  //...+%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00c0 (À) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xfc, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xf2, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xde, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0xff, 0xf2, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xd6, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xfa, 0x2a, 0xf8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xb0, 0x00, 0xaa, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe4, 0xff, 0xff, 0x4c, 0x00, 0x48, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x02, 0xe2, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@%...%@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xf8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xfa, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0x00, 0x08, 0xf0, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xf0, 0x08, 0x00, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x00, 0x00, 0x20, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00,  //..%@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0xe0, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xe0, 0x00, 0x00,  //..@@@+...........+@@@..
    0x00, 0x46, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xea, 0xff, 0xff, 0x46, 0x00,  //.+@@@.............@@@+.
    0x00, 0xa8, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xa8, 0x00,  //.%@@%.............%@@%.
    0x10, 0xf6, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xf6, 0x10,  //.@@@...............@@@.
    0x6c, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0x6c,  //+@@@...............@@@+
    0xce, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xce,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c1 (Á) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xf4, 0xff, 0xca, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xe0, 0xff, 0xd2, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xc0, 0xff, 0xda, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xe0, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0xff, 0xf2, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xd6, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xfa, 0x2a, 0xf8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xb0, 0x00, 0xaa, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe4, 0xff, 0xff, 0x4c, 0x00, 0x48, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x02, 0xe2, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@%...%@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xf8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xfa, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0x00, 0x08, 0xf0, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xf0, 0x08, 0x00, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x00, 0x00, 0x20, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00,  //..%@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0xe0, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xe0, 0x00, 0x00,  //..@@@+...........+@@@..
    0x00, 0x46, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xea, 0xff, 0xff, 0x46, 0x00,  //.+@@@.............@@@+.
    0x00, 0xa8, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xa8, 0x00,  //.%@@%.............%@@%.
    0x10, 0xf6, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xf6, 0x10,  //.@@@...............@@@.
    0x6c, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0x6c,  //+@@@...............@@@+
    0xce, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xce,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c2 (Â) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xfc, 0xff, 0xfc, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xec, 0xfc, 0x98, 0xfc, 0xec, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@%@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xcc, 0xff, 0x6c, 0x00, 0x6c, 0xff, 0xcc, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@+.+@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0x80, 0x00, 0x00, 0x00, 0x80, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@+...+@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0xff, 0xf2, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xd6, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xfa, 0x2a, 0xf8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xb0, 0x00, 0xaa, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe4, 0xff, 0xff, 0x4c, 0x00, 0x48, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x02, 0xe2, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@%...%@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xf8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xfa, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0x00, 0x08, 0xf0, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xf0, 0x08, 0x00, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x00, 0x00, 0x20, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00,  //..%@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0xe0, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xe0, 0x00, 0x00,  //..@@@+...........+@@@..
    0x00, 0x46, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xea, 0xff, 0xff, 0x46, 0x00,  //.+@@@.............@@@+.
    0x00, 0xa8, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xa8, 0x00,  //.%@@%.............%@@%.
    0x10, 0xf6, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xf6, 0x10,  //.@@@...............@@@.
    0x6c, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0x6c,  //+@@@...............@@@+
    0xce, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xce,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c3 (Ã) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xe6, 0xee, 0xb4, 0x2c, 0x00, 0x00, 0x0a, 0xff, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@%....@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x8a, 0x14, 0x70, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@%.+@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0x6e, 0x12, 0x88, 0xfa, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@+.%@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0x08, 0x00, 0x00, 0x30, 0xb4, 0xf0, 0xe6, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@....%@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0xff, 0xf2, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xd6, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xfa, 0x2a, 0xf8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xb0, 0x00, 0xaa, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe4, 0xff, 0xff, 0x4c, 0x00, 0x48, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x02, 0xe2, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@%...%@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xf8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xfa, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0x00, 0x08, 0xf0, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xf0, 0x08, 0x00, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x00, 0x00, 0x20, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00,  //..%@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0xe0, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xe0, 0x00, 0x00,  //..@@@+...........+@@@..
    0x00, 0x46, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xea, 0xff, 0xff, 0x46, 0x00,  //.+@@@.............@@@+.
    0x00, 0xa8, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xa8, 0x00,  //.%@@%.............%@@%.
    0x10, 0xf6, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xf6, 0x10,  //.@@@...............@@@.
    0x6c, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0x6c,  //+@@@...............@@@+
    0xce, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xce,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c4 (Ä) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0xff, 0xf2, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xd6, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xfa, 0x2a, 0xf8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xb0, 0x00, 0xaa, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe4, 0xff, 0xff, 0x4c, 0x00, 0x48, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x02, 0xe2, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@%...%@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xf8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xfa, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0x00, 0x08, 0xf0, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xf0, 0x08, 0x00, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x00, 0x00, 0x20, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00,  //..%@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0xe0, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xe0, 0x00, 0x00,  //..@@@+...........+@@@..
    0x00, 0x46, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xea, 0xff, 0xff, 0x46, 0x00,  //.+@@@.............@@@+.
    0x00, 0xa8, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xa8, 0x00,  //.%@@%.............%@@%.
    0x10, 0xf6, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xf6, 0x10,  //.@@@...............@@@.
    0x6c, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0x6c,  //+@@@...............@@@+
    0xce, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xce,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c5 (Å) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xdc, 0x3e, 0x0a, 0x42, 0xe0, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@..+@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x42, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@....+@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.....@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x40, 0xff, 0xde, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.....@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xdc, 0x3e, 0x0a, 0x40, 0xde, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@...@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xff, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0xc2, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xff, 0xf4, 0x1a, 0xf4, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0xa0, 0x00, 0xa0, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xec, 0xff, 0xff, 0x3e, 0x00, 0x3e, 0xff, 0xff, 0xec, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@+...+@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xff, 0xfc, 0x1a, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xff, 0xfc, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@%.....%@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xec, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xec, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0x00, 0x0c, 0xf2, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x00, 0x24, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x24, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x00, 0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x84, 0x00, 0x00,  //..%@@@@@@@@@@@@@@@@@%..
    0x00, 0x02, 0xe4, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe2, 0x02, 0x00,  //..@@@+...........+@@@..
    0x00, 0x48, 0xff, 0xff, 0xe4, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe4, 0xff, 0xff, 0x48, 0x00,  //.+@@@.............@@@+.
    0x00, 0xaa, 0xff, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xa8, 0x00,  //.%@@%.............%@@%.
    0x12, 0xf8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xf6, 0x10,  //.@@@...............@@@.
    0x6c, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0x6c,  //+@@@...............@@@+
    0xce, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xce,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c6 (Æ) , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..........%@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..........@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.........%@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xec, 0xff, 0xff, 0x44, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@+..@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@...@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@+...@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xf2, 0x0e, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@....@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@%....@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xf8, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.....@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@%.....@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe2, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //......@@@+.....@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xff, 0xe4, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.....+@@@......@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.....%@@+......@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xf8, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@.......@@@.............
    0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@%.......@@@.............
    0x00, 0x00, 0x00, 0x0e, 0xf2, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@........@@@.............
    0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@@@@.............
    0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@@@@.............
    0x00, 0x00, 0x44, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@@@@@@@@@@.............
    0x00, 0x00, 0xb0, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@%.........@@@.............
    0x00, 0x1e, 0xfc, 0xff, 0xfc, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@..........@@@.............
    0x00, 0x86, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@%..........@@@.............
    0x06, 0xea, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@+..........@@@@@@@@@@@@@@@@
    0x5e, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //+@@@...........@@@@@@@@@@@@@@@@
    0xc8, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@+...........@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+00c7 (Ç) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x44, 0x88, 0xc4, 0xde, 0xf2, 0xf8, 0xe8, 0xd2, 0xa4, 0x6c, 0x1a, 0x00, 0x00,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xb8, 0x3c,  //.....+@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x0a, 0xac, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x00, 0x00, 0x0a, 0xcc, 0xff, 0xff, 0xff, 0xe8, 0x88, 0x46, 0x1c, 0x0a, 0x08, 0x1e, 0x42, 0x88, 0xda, 0xff, 0xff, 0xff,  //...@@@@@%+....+%@@@@
    0x00, 0x00, 0xa4, 0xff, 0xff, 0xfc, 0x80, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xda, 0xff,  //..%@@@+..........+@@
    0x00, 0x52, 0xff, 0xff, 0xfc, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xa2,  //.+@@@+.............%
    0x00, 0xcc, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%...............
    0x38, 0xff, 0xff, 0xf0, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x7c, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0xba, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0xda, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xda, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xba, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0x7c, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0x38, 0xff, 0xff, 0xee, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x00, 0xce, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%...............
    0x00, 0x54, 0xff, 0xff, 0xfc, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xa0,  //.+@@@+.............%
    0x00, 0x00, 0xa8, 0xff, 0xff, 0xfc, 0x7c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xda, 0xff,  //..%@@@+..........+@@
    0x00, 0x00, 0x0a, 0xce, 0xff, 0xff, 0xff, 0xe6, 0x86, 0x44, 0x1c, 0x08, 0x08, 0x1e, 0x42, 0x84, 0xd6, 0xff, 0xff, 0xff,  //...@@@@@%+....+%@@@@
    0x00, 0x00, 0x00, 0x0c, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xb6, 0x3c,  //.....+@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x44, 0x8a, 0xc6, 0xde, 0xf2, 0xf8, 0xea, 0xd2, 0xa4, 0x6a, 0x18, 0x00, 0x00,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xfa, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0x22, 0x0a, 0x7c, 0xff, 0xff, 0xe8, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%..+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xe2, 0xf6, 0xf0, 0xce, 0x6e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+00c8 (È) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xfc, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xf2, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xde, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00c9 (É) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xf4, 0xff, 0xca, 0x0c, 0x00, 0x00, 0x00,  //.........@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xe0, 0xff, 0xd2, 0x12, 0x00, 0x00, 0x00, 0x00,  //........@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xc0, 0xff, 0xda, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xe0, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00ca (Ê) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xe0, 0xff, 0xff, 0xe0, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@......
    0x00, 0x00, 0x00, 0x00, 0x0a, 0xca, 0xff, 0xc2, 0xc4, 0xff, 0xca, 0x0a, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xc0, 0x0a, 0x0a, 0xc0, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //....%@%..%@%....
    0x00, 0x00, 0x00, 0x90, 0xff, 0xbc, 0x0a, 0x00, 0x00, 0x0a, 0xbe, 0xff, 0x90, 0x00, 0x00, 0x00,  //...%@%....%@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00cb (Ë) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....@@@...@@@...
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....@@@...@@@...
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....@@@...@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00cc (Ì) , Width: 7 */
    0x84, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00,  //%@@+...
    0x00, 0x90, 0xff, 0xfc, 0x50, 0x00, 0x00,  //.%@@+..
    0x00, 0x00, 0x9c, 0xff, 0xf2, 0x2c, 0x00,  //..%@@..
    0x00, 0x00, 0x00, 0xa6, 0xff, 0xde, 0x12,  //...%@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00cd (Í) , Width: 7 */
    0x00, 0x00, 0x30, 0xf4, 0xff, 0xca, 0x0c,  //...@@@.
    0x00, 0x14, 0xe0, 0xff, 0xd2, 0x12, 0x00,  //..@@@..
    0x04, 0xc0, 0xff, 0xda, 0x16, 0x00, 0x00,  //.%@@...
    0x96, 0xff, 0xe0, 0x1e, 0x00, 0x00, 0x00,  //%@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00ce (Î) , Width: 10 */
    0x00, 0x02, 0xa8, 0xff, 0xff, 0xff, 0xa8, 0x02, 0x00, 0x00,  //..%@@@%...
    0x00, 0x9c, 0xff, 0xf6, 0x8c, 0xf6, 0xff, 0x9c, 0x00, 0x00,  //.%@@%@@%..
    0x90, 0xff, 0xee, 0x3e, 0x00, 0x3e, 0xee, 0xff, 0x90, 0x00,  //%@@...@@%.
    0xff, 0xe4, 0x2c, 0x00, 0x00, 0x00, 0x2c, 0xe4, 0xff, 0x84,  //@@.....@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00cf (Ï) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00d0 (Ð) , Width: 24 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xe6, 0xd8, 0xbe, 0x8e, 0x5c, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@@%%+........
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xb6, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@@@%+.....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x14, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x02, 0x10, 0x1e, 0x40, 0x72, 0xb6, 0xfc, 0xff, 0xff, 0xff, 0xde, 0x16, 0x00, 0x00,  //...@@@........+%@@@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa4, 0xff, 0xff, 0xff, 0xca, 0x06, 0x00,  //...@@@...........%@@@@..
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xff, 0x6e, 0x00,  //...@@@............+@@@+.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xe6, 0x06,  //...@@@.............%@@@.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xee, 0xff, 0xff, 0x48,  //...@@@..............@@@+
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0x88,  //...@@@..............%@@%
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xc2,  //...@@@..............+@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xda,  //...@@@...............@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@@@@@@@@@@.........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@@@@@@@@@@.........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xea,  //@@@@@@@@@@@@.........@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xd8,  //...@@@...............@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xff, 0xc0,  //...@@@..............+@@%
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0x86,  //...@@@..............%@@%
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xee, 0xff, 0xff, 0x46,  //...@@@..............@@@+
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xe2, 0x06,  //...@@@.............%@@@.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xff, 0x6a, 0x00,  //...@@@............+@@@+.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xa2, 0xff, 0xff, 0xff, 0xc8, 0x06, 0x00,  //...@@@...........%@@@@..
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1c, 0x3e, 0x70, 0xb4, 0xfa, 0xff, 0xff, 0xff, 0xdc, 0x14, 0x00, 0x00,  //...@@@........+%@@@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x14, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@%....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xb6, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@@@%+.....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xe8, 0xd8, 0xbe, 0x8e, 0x5c, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@@%%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................


    /*Unicode: U+00d1 (Ñ) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xe6, 0xee, 0xb4, 0x2c, 0x00, 0x00, 0x0a, 0xff, 0xec, 0x00, 0x00, 0x00, 0x00,  //.....+@@%....@@....
    0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x8a, 0x14, 0x70, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //....+@@@@@%.+@%....
    0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0x6e, 0x12, 0x88, 0xfa, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00,  //....@@+.%@@@@@+....
    0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0x08, 0x00, 0x00, 0x30, 0xb4, 0xf0, 0xe6, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@....%@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@%...........@@@
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@%..........@@@
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@..........@@@
    0xff, 0xff, 0xff, 0x9a, 0xff, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@%@@@.........@@@
    0xff, 0xff, 0xff, 0x18, 0xf2, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.@@@+........@@@
    0xff, 0xff, 0xff, 0x00, 0x80, 0xff, 0xff, 0xde, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.+@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x0a, 0xe6, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@+.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x68, 0xff, 0xff, 0xec, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..+@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0xd6, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@%......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xf8, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...+@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....%@@%.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xfc, 0x32, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....%@@%....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf8, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@+...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xd2, 0x02, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......%@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xee, 0xff, 0xff, 0x62, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@+..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xe4, 0x08, 0x00, 0xff, 0xff, 0xff,  //@@@.......+@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xe0, 0xff, 0xff, 0x7c, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@+.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xf2, 0x14, 0xff, 0xff, 0xff,  //@@@........+@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xff, 0x94, 0xff, 0xff, 0xff,  //@@@.........@@@%@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff,  //@@@.........+@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@..........%@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xfc, 0xff, 0xff, 0xff, 0xff,  //@@@...........@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xff,  //@@@...........%@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00d2 (Ò) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@+............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xfc, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xf2, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xde, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x56, 0xa0, 0xd2, 0xe8, 0xf8, 0xe8, 0xd2, 0xa2, 0x58, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x04, 0x6e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x72, 0x04, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x10, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x10, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x00, 0x0e, 0xd4, 0xff, 0xff, 0xff, 0xe0, 0x7e, 0x36, 0x16, 0x04, 0x14, 0x34, 0x7c, 0xde, 0xff, 0xff, 0xff, 0xd6, 0x0e, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x00, 0xaa, 0xff, 0xff, 0xff, 0x84, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00,  //..%@@@%.........+@@@%..
    0x00, 0x56, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0x58, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0xce, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xce, 0x00,  //.@@@%.............%@@@.
    0x38, 0xff, 0xff, 0xf6, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf6, 0xff, 0xff, 0x3a,  //.@@@...............@@@.
    0x7c, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x7c,  //+@@%...............%@@+
    0xb8, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xb8,  //%@@+...............+@@%
    0xda, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xd8,  //@@@.................@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@.................@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@.................@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@.................@@@
    0xda, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xda,  //@@@.................@@@
    0xba, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xba,  //%@@+...............+@@%
    0x7e, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x7c,  //+@@%...............%@@+
    0x3a, 0xff, 0xff, 0xf4, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf4, 0xff, 0xff, 0x3a,  //.@@@...............@@@.
    0x00, 0xd0, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xd0, 0x00,  //.@@@%.............%@@@.
    0x00, 0x58, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0x58, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0x00, 0xae, 0xff, 0xff, 0xff, 0x80, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7c, 0xfc, 0xff, 0xff, 0xb0, 0x00, 0x00,  //..%@@@+.........+@@@%..
    0x00, 0x00, 0x10, 0xd6, 0xff, 0xff, 0xff, 0xe0, 0x7c, 0x34, 0x14, 0x04, 0x14, 0x32, 0x7a, 0xdc, 0xff, 0xff, 0xff, 0xd8, 0x10, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x00, 0x00, 0x12, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x12, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x04, 0x72, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x74, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x58, 0xa2, 0xd2, 0xe8, 0xf8, 0xea, 0xd4, 0xa4, 0x5a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d3 (Ó) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xf4, 0xff, 0xca, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xe0, 0xff, 0xd2, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xc0, 0xff, 0xda, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........%@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xe0, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x56, 0xa0, 0xd2, 0xe8, 0xf8, 0xe8, 0xd2, 0xa2, 0x58, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x04, 0x6e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x72, 0x04, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x10, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x10, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x00, 0x0e, 0xd4, 0xff, 0xff, 0xff, 0xe0, 0x7e, 0x36, 0x16, 0x04, 0x14, 0x34, 0x7c, 0xde, 0xff, 0xff, 0xff, 0xd6, 0x0e, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x00, 0xaa, 0xff, 0xff, 0xff, 0x84, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00,  //..%@@@%.........+@@@%..
    0x00, 0x56, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0x58, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0xce, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xce, 0x00,  //.@@@%.............%@@@.
    0x38, 0xff, 0xff, 0xf6, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf6, 0xff, 0xff, 0x3a,  //.@@@...............@@@.
    0x7c, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x7c,  //+@@%...............%@@+
    0xb8, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xb8,  //%@@+...............+@@%
    0xda, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xd8,  //@@@.................@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@.................@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@.................@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@.................@@@
    0xda, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xda,  //@@@.................@@@
    0xba, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xba,  //%@@+...............+@@%
    0x7e, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x7c,  //+@@%...............%@@+
    0x3a, 0xff, 0xff, 0xf4, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf4, 0xff, 0xff, 0x3a,  //.@@@...............@@@.
    0x00, 0xd0, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xd0, 0x00,  //.@@@%.............%@@@.
    0x00, 0x58, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0x58, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0x00, 0xae, 0xff, 0xff, 0xff, 0x80, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7c, 0xfc, 0xff, 0xff, 0xb0, 0x00, 0x00,  //..%@@@+.........+@@@%..
    0x00, 0x00, 0x10, 0xd6, 0xff, 0xff, 0xff, 0xe0, 0x7c, 0x34, 0x14, 0x04, 0x14, 0x32, 0x7a, 0xdc, 0xff, 0xff, 0xff, 0xd8, 0x10, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x00, 0x00, 0x12, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x12, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x04, 0x72, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x74, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x58, 0xa2, 0xd2, 0xe8, 0xf8, 0xea, 0xd4, 0xa4, 0x5a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d4 (Ô) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xfc, 0xff, 0xfc, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........+@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xec, 0xfc, 0x98, 0xfc, 0xec, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@%@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xcc, 0xff, 0x6c, 0x00, 0x6c, 0xff, 0xcc, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@+.+@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0x80, 0x00, 0x00, 0x00, 0x80, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@+...+@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x56, 0xa0, 0xd2, 0xe8, 0xf8, 0xe8, 0xd2, 0xa2, 0x58, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x04, 0x6e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x72, 0x04, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x10, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x10, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x00, 0x0e, 0xd4, 0xff, 0xff, 0xff, 0xe0, 0x7e, 0x36, 0x16, 0x04, 0x14, 0x34, 0x7c, 0xde, 0xff, 0xff, 0xff, 0xd6, 0x0e, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x00, 0xaa, 0xff, 0xff, 0xff, 0x84, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00,  //..%@@@%.........+@@@%..
    0x00, 0x56, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0x58, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0xce, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xce, 0x00,  //.@@@%.............%@@@.
    0x38, 0xff, 0xff, 0xf6, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf6, 0xff, 0xff, 0x3a,  //.@@@...............@@@.
    0x7c, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x7c,  //+@@%...............%@@+
    0xb8, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xb8,  //%@@+...............+@@%
    0xda, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xd8,  //@@@.................@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@.................@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@.................@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@.................@@@
    0xda, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xda,  //@@@.................@@@
    0xba, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xba,  //%@@+...............+@@%
    0x7e, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x7c,  //+@@%...............%@@+
    0x3a, 0xff, 0xff, 0xf4, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf4, 0xff, 0xff, 0x3a,  //.@@@...............@@@.
    0x00, 0xd0, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xd0, 0x00,  //.@@@%.............%@@@.
    0x00, 0x58, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0x58, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0x00, 0xae, 0xff, 0xff, 0xff, 0x80, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7c, 0xfc, 0xff, 0xff, 0xb0, 0x00, 0x00,  //..%@@@+.........+@@@%..
    0x00, 0x00, 0x10, 0xd6, 0xff, 0xff, 0xff, 0xe0, 0x7c, 0x34, 0x14, 0x04, 0x14, 0x32, 0x7a, 0xdc, 0xff, 0xff, 0xff, 0xd8, 0x10, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x00, 0x00, 0x12, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x12, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x04, 0x72, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x74, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x58, 0xa2, 0xd2, 0xe8, 0xf8, 0xea, 0xd4, 0xa4, 0x5a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d5 (Õ) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xe6, 0xee, 0xb4, 0x2c, 0x00, 0x00, 0x0a, 0xff, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@%....@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x8a, 0x14, 0x70, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@%.+@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0x6e, 0x12, 0x88, 0xfa, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@+.%@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0x08, 0x00, 0x00, 0x30, 0xb4, 0xf0, 0xe6, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@....%@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x56, 0xa0, 0xd2, 0xe8, 0xf8, 0xe8, 0xd2, 0xa2, 0x58, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x04, 0x6e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x72, 0x04, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x10, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x10, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x00, 0x0e, 0xd4, 0xff, 0xff, 0xff, 0xe0, 0x7e, 0x36, 0x16, 0x04, 0x14, 0x34, 0x7c, 0xde, 0xff, 0xff, 0xff, 0xd6, 0x0e, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x00, 0xaa, 0xff, 0xff, 0xff, 0x84, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00,  //..%@@@%.........+@@@%..
    0x00, 0x56, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0x58, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0xce, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xce, 0x00,  //.@@@%.............%@@@.
    0x38, 0xff, 0xff, 0xf6, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf6, 0xff, 0xff, 0x3a,  //.@@@...............@@@.
    0x7c, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x7c,  //+@@%...............%@@+
    0xb8, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xb8,  //%@@+...............+@@%
    0xda, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xd8,  //@@@.................@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@.................@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@.................@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@.................@@@
    0xda, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xda,  //@@@.................@@@
    0xba, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xba,  //%@@+...............+@@%
    0x7e, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x7c,  //+@@%...............%@@+
    0x3a, 0xff, 0xff, 0xf4, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf4, 0xff, 0xff, 0x3a,  //.@@@...............@@@.
    0x00, 0xd0, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xd0, 0x00,  //.@@@%.............%@@@.
    0x00, 0x58, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0x58, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0x00, 0xae, 0xff, 0xff, 0xff, 0x80, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7c, 0xfc, 0xff, 0xff, 0xb0, 0x00, 0x00,  //..%@@@+.........+@@@%..
    0x00, 0x00, 0x10, 0xd6, 0xff, 0xff, 0xff, 0xe0, 0x7c, 0x34, 0x14, 0x04, 0x14, 0x32, 0x7a, 0xdc, 0xff, 0xff, 0xff, 0xd8, 0x10, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x00, 0x00, 0x12, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x12, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x04, 0x72, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x74, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x58, 0xa2, 0xd2, 0xe8, 0xf8, 0xea, 0xd4, 0xa4, 0x5a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d6 (Ö) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x56, 0xa0, 0xd2, 0xe8, 0xf8, 0xe8, 0xd2, 0xa2, 0x58, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x04, 0x6e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x72, 0x04, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x10, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x10, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x00, 0x0e, 0xd4, 0xff, 0xff, 0xff, 0xe0, 0x7e, 0x36, 0x16, 0x04, 0x14, 0x34, 0x7c, 0xde, 0xff, 0xff, 0xff, 0xd6, 0x0e, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x00, 0xaa, 0xff, 0xff, 0xff, 0x84, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00,  //..%@@@%.........+@@@%..
    0x00, 0x56, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0x58, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0xce, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xce, 0x00,  //.@@@%.............%@@@.
    0x38, 0xff, 0xff, 0xf6, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf6, 0xff, 0xff, 0x3a,  //.@@@...............@@@.
    0x7c, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x7c,  //+@@%...............%@@+
    0xb8, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xb8,  //%@@+...............+@@%
    0xda, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xd8,  //@@@.................@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@.................@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@.................@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@.................@@@
    0xda, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xda,  //@@@.................@@@
    0xba, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xba,  //%@@+...............+@@%
    0x7e, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x7c,  //+@@%...............%@@+
    0x3a, 0xff, 0xff, 0xf4, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf4, 0xff, 0xff, 0x3a,  //.@@@...............@@@.
    0x00, 0xd0, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xd0, 0x00,  //.@@@%.............%@@@.
    0x00, 0x58, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0x58, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0x00, 0xae, 0xff, 0xff, 0xff, 0x80, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7c, 0xfc, 0xff, 0xff, 0xb0, 0x00, 0x00,  //..%@@@+.........+@@@%..
    0x00, 0x00, 0x10, 0xd6, 0xff, 0xff, 0xff, 0xe0, 0x7c, 0x34, 0x14, 0x04, 0x14, 0x32, 0x7a, 0xdc, 0xff, 0xff, 0xff, 0xd8, 0x10, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x00, 0x00, 0x12, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x12, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x04, 0x72, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x74, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x58, 0xa2, 0xd2, 0xe8, 0xf8, 0xea, 0xd4, 0xa4, 0x5a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00d7 (×) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x54, 0xb0, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xb2, 0x54, 0x00,  //.+%.............%+.
    0x72, 0xfc, 0xff, 0xb6, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb8, 0xff, 0xfc, 0x72,  //+@@%...........%@@+
    0x7c, 0xff, 0xff, 0xff, 0xb6, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb8, 0xff, 0xff, 0xff, 0x7a,  //+@@@%.........%@@@+
    0x00, 0x7c, 0xff, 0xff, 0xff, 0xb4, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb8, 0xff, 0xff, 0xff, 0x7a, 0x00,  //.+@@@%.......%@@@+.
    0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xb2, 0x04, 0x00, 0x00, 0x00, 0x06, 0xb8, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00,  //..+@@@%.....%@@@+..
    0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xb2, 0x04, 0x00, 0x06, 0xb8, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00,  //...+@@@%...%@@@+...
    0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xb0, 0x0c, 0xb6, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00,  //....+@@@%.%@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xec, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xb8, 0x10, 0xb8, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00,  //....+@@@%.%@@@+....
    0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xb8, 0x08, 0x00, 0x08, 0xb8, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00,  //...+@@@%...%@@@+...
    0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xb8, 0x08, 0x00, 0x00, 0x00, 0x08, 0xb8, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00,  //..+@@@%.....%@@@+..
    0x00, 0x7a, 0xff, 0xff, 0xff, 0xb8, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xb8, 0xff, 0xff, 0xff, 0x78, 0x00,  //.+@@@%.......%@@@+.
    0x7a, 0xff, 0xff, 0xff, 0xb8, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xb8, 0xff, 0xff, 0xff, 0x7a,  //+@@@%.........%@@@+
    0x72, 0xfc, 0xff, 0xb8, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xb8, 0xff, 0xfc, 0x72,  //+@@%...........%@@+
    0x00, 0x54, 0xb2, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xb2, 0x54, 0x00,  //.+%.............%+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00d8 (Ø) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x0e, 0x00,  //......................+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x4c, 0x92, 0xca, 0xe2, 0xf6, 0xf0, 0xda, 0xac, 0x68, 0x10, 0x00, 0x00, 0x00, 0x20, 0xf0, 0xc2, 0x08,  //........+%@@@@@%+.....@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x64, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x84, 0x06, 0x02, 0xc2, 0xff, 0xc4, 0x02,  //......+@@@@@@@@@@@%..@@@.
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x92, 0xff, 0xf0, 0x20, 0x00,  //.....%@@@@@@@@@@@@@@%@@..
    0x00, 0x00, 0x00, 0x0c, 0xd2, 0xff, 0xff, 0xff, 0xe0, 0x7e, 0x36, 0x16, 0x04, 0x12, 0x38, 0x7c, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00,  //....@@@@@+.....+@@@@@@+..
    0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0xff, 0x84, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x88, 0xfc, 0xff, 0xff, 0xea, 0x04, 0x00, 0x00,  //...%@@@%.........%@@@@...
    0x00, 0x00, 0x58, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xfa, 0xff, 0xff, 0xff, 0x6c, 0x00, 0x00,  //..+@@@+..........+@@@@+..
    0x00, 0x00, 0xd2, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xf8, 0xff, 0xf6, 0xff, 0xff, 0xe0, 0x00, 0x00,  //..@@@%..........+@@@@@@..
    0x00, 0x3e, 0xff, 0xff, 0xf6, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xf6, 0xff, 0xd4, 0x2a, 0xf2, 0xff, 0xff, 0x3a, 0x00,  //..@@@..........+@@@.@@@..
    0x00, 0x80, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xf4, 0xff, 0xda, 0x18, 0x00, 0xa0, 0xff, 0xff, 0x82, 0x00,  //.+@@%..........@@@..%@@%.
    0x00, 0xbe, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xf0, 0xff, 0xde, 0x1c, 0x00, 0x00, 0x54, 0xff, 0xff, 0xb4, 0x00,  //.%@@+.........@@@...+@@%.
    0x00, 0xdc, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xee, 0xff, 0xe2, 0x20, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xdc, 0x00,  //.@@@.........@@@.....@@@.
    0x00, 0xee, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xea, 0xff, 0xe6, 0x24, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xec, 0x00,  //.@@@........@@@......@@@.
    0x00, 0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xe6, 0xff, 0xea, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa, 0x00,  //.@@@.......@@@.......@@@.
    0x00, 0xee, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x22, 0xe4, 0xff, 0xec, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xee, 0x00,  //.@@@......@@@........@@@.
    0x00, 0xde, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x1e, 0xe0, 0xff, 0xf0, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xda, 0x00,  //.@@@.....@@@.........@@@.
    0x00, 0xb8, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x18, 0xda, 0xff, 0xf2, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xbe, 0x00,  //.%@@+...@@@.........+@@%.
    0x00, 0x88, 0xff, 0xff, 0x96, 0x00, 0x14, 0xd6, 0xff, 0xf4, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x80, 0x00,  //.%@@%..@@@..........%@@+.
    0x00, 0x42, 0xff, 0xff, 0xee, 0x22, 0xd0, 0xff, 0xf6, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xf6, 0xff, 0xff, 0x3e, 0x00,  //.+@@@.@@@+..........@@@..
    0x00, 0x00, 0xe4, 0xff, 0xff, 0xf4, 0xff, 0xf8, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xd2, 0x00, 0x00,  //..@@@@@@+..........%@@@..
    0x00, 0x00, 0x70, 0xff, 0xff, 0xff, 0xfa, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0x56, 0x00, 0x00,  //..+@@@@+..........+@@@+..
    0x00, 0x00, 0x04, 0xea, 0xff, 0xff, 0xfc, 0x8c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x7e, 0xfc, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00,  //...@@@@%.........+@@@%...
    0x00, 0x00, 0x48, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x7e, 0x38, 0x12, 0x04, 0x14, 0x34, 0x7a, 0xde, 0xff, 0xff, 0xff, 0xd0, 0x0c, 0x00, 0x00, 0x00,  //..+@@@@@@+.....+@@@@@....
    0x00, 0x08, 0xde, 0xff, 0x98, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x0c, 0x00, 0x00, 0x00, 0x00,  //..@@%@@@@@@@@@@@@@@%.....
    0x00, 0x88, 0xff, 0xc8, 0x02, 0x06, 0x84, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x66, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@..%@@@@@@@@@@@+......
    0x0c, 0xf0, 0xf2, 0x24, 0x00, 0x00, 0x00, 0x10, 0x66, 0xaa, 0xda, 0xf0, 0xf8, 0xe4, 0xcc, 0x96, 0x4e, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@.....+%@@@@@%+........
    0x00, 0x28, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+00d9 (Ù) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xfc, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xf2, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xde, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xf8, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf6,  //@@@.............@@@
    0xe8, 0xff, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xe6,  //@@@.............@@@
    0xd0, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xce,  //@@@+...........+@@@
    0x9a, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0x98,  //%@@%...........%@@%
    0x56, 0xff, 0xff, 0xea, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xec, 0xff, 0xff, 0x54,  //+@@@...........@@@+
    0x04, 0xe4, 0xff, 0xff, 0xba, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xbc, 0xff, 0xff, 0xe2, 0x02,  //.@@@%.........%@@@.
    0x00, 0x5a, 0xff, 0xff, 0xff, 0xe2, 0x76, 0x32, 0x0e, 0x02, 0x0e, 0x30, 0x76, 0xe2, 0xff, 0xff, 0xff, 0x56, 0x00,  //.+@@@@+.....+@@@@+.
    0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86, 0x00, 0x00,  //..%@@@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x62, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x60, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x08, 0x62, 0xa4, 0xd8, 0xec, 0xfa, 0xee, 0xd8, 0xa6, 0x62, 0x08, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00da (Ú) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xf4, 0xff, 0xca, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xe0, 0xff, 0xd2, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xc0, 0xff, 0xda, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xe0, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xf8, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf6,  //@@@.............@@@
    0xe8, 0xff, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xe6,  //@@@.............@@@
    0xd0, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xce,  //@@@+...........+@@@
    0x9a, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0x98,  //%@@%...........%@@%
    0x56, 0xff, 0xff, 0xea, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xec, 0xff, 0xff, 0x54,  //+@@@...........@@@+
    0x04, 0xe4, 0xff, 0xff, 0xba, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xbc, 0xff, 0xff, 0xe2, 0x02,  //.@@@%.........%@@@.
    0x00, 0x5a, 0xff, 0xff, 0xff, 0xe2, 0x76, 0x32, 0x0e, 0x02, 0x0e, 0x30, 0x76, 0xe2, 0xff, 0xff, 0xff, 0x56, 0x00,  //.+@@@@+.....+@@@@+.
    0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86, 0x00, 0x00,  //..%@@@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x62, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x60, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x08, 0x62, 0xa4, 0xd8, 0xec, 0xfa, 0xee, 0xd8, 0xa6, 0x62, 0x08, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00db (Û) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xfc, 0xff, 0xfc, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xec, 0xfc, 0x98, 0xfc, 0xec, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@%@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xcc, 0xff, 0x6c, 0x00, 0x6c, 0xff, 0xcc, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@+.+@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0x80, 0x00, 0x00, 0x00, 0x80, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@+...+@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xf8, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf6,  //@@@.............@@@
    0xe8, 0xff, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xe6,  //@@@.............@@@
    0xd0, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xce,  //@@@+...........+@@@
    0x9a, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0x98,  //%@@%...........%@@%
    0x56, 0xff, 0xff, 0xea, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xec, 0xff, 0xff, 0x54,  //+@@@...........@@@+
    0x04, 0xe4, 0xff, 0xff, 0xba, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xbc, 0xff, 0xff, 0xe2, 0x02,  //.@@@%.........%@@@.
    0x00, 0x5a, 0xff, 0xff, 0xff, 0xe2, 0x76, 0x32, 0x0e, 0x02, 0x0e, 0x30, 0x76, 0xe2, 0xff, 0xff, 0xff, 0x56, 0x00,  //.+@@@@+.....+@@@@+.
    0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86, 0x00, 0x00,  //..%@@@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x62, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x60, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x08, 0x62, 0xa4, 0xd8, 0xec, 0xfa, 0xee, 0xd8, 0xa6, 0x62, 0x08, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00dc (Ü) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@...@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@...@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@...@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xf8, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf6,  //@@@.............@@@
    0xe8, 0xff, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xe6,  //@@@.............@@@
    0xd0, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xce,  //@@@+...........+@@@
    0x9a, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0x98,  //%@@%...........%@@%
    0x56, 0xff, 0xff, 0xea, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xec, 0xff, 0xff, 0x54,  //+@@@...........@@@+
    0x04, 0xe4, 0xff, 0xff, 0xba, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xbc, 0xff, 0xff, 0xe2, 0x02,  //.@@@%.........%@@@.
    0x00, 0x5a, 0xff, 0xff, 0xff, 0xe2, 0x76, 0x32, 0x0e, 0x02, 0x0e, 0x30, 0x76, 0xe2, 0xff, 0xff, 0xff, 0x56, 0x00,  //.+@@@@+.....+@@@@+.
    0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86, 0x00, 0x00,  //..%@@@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x62, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x60, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x08, 0x62, 0xa4, 0xd8, 0xec, 0xfa, 0xee, 0xd8, 0xa6, 0x62, 0x08, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00dd (Ý) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xf4, 0xff, 0xca, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xe0, 0xff, 0xd2, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xc0, 0xff, 0xda, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xe0, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xa6, 0xff, 0xff, 0xe6, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xe6, 0xff, 0xff, 0xa6,  //%@@@.............@@@%
    0x10, 0xe4, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0xe4, 0x10,  //.@@@%...........%@@@.
    0x00, 0x48, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xff, 0x46, 0x00,  //.+@@@+.........+@@@+.
    0x00, 0x00, 0x98, 0xff, 0xff, 0xee, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xee, 0xff, 0xff, 0x96, 0x00, 0x00,  //..%@@@.........@@@%..
    0x00, 0x00, 0x0a, 0xdc, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xba, 0xff, 0xff, 0xda, 0x0a, 0x00, 0x00,  //...@@@%.......%@@@...
    0x00, 0x00, 0x00, 0x3a, 0xfc, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xfc, 0x3a, 0x00, 0x00, 0x00,  //....@@@+.....+@@@....
    0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xf4, 0x24, 0x00, 0x00, 0x00, 0x26, 0xf4, 0xff, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00,  //....%@@@.....@@@%....
    0x00, 0x00, 0x00, 0x00, 0x04, 0xd0, 0xff, 0xff, 0xc6, 0x02, 0x00, 0x02, 0xc8, 0xff, 0xff, 0xd0, 0x04, 0x00, 0x00, 0x00, 0x00,  //.....@@@@...@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xf8, 0xff, 0xff, 0x7c, 0x00, 0x7c, 0xff, 0xff, 0xf8, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@+.+@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xf8, 0x62, 0xf8, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@+@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf2, 0xff, 0xff, 0xff, 0xf2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+00de (Þ) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf0, 0xdc, 0xac, 0x6a, 0x0c, 0x00, 0x00, 0x00,  //@@@@@@@@@@%+....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x5c, 0x00, 0x00,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0x00,  //@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x34, 0x86, 0xf4, 0xff, 0xff, 0xf6, 0x1c,  //@@@.......%@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xea, 0xff, 0xff, 0x86,  //@@@.........@@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xca,  //@@@.........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xea,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf8,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xea,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xc8,  //@@@.........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xec, 0xff, 0xff, 0x84,  //@@@.........@@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x34, 0x86, 0xf4, 0xff, 0xff, 0xf6, 0x1a,  //@@@.......%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x64, 0x00,  //@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x5a, 0x00, 0x00,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xde, 0xae, 0x68, 0x0c, 0x00, 0x00, 0x00,  //@@@@@@@@@@%+....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00df (ß) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x1e, 0x82, 0xc2, 0xe8, 0xf8, 0xee, 0xd4, 0x94, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@@@@%......
    0x00, 0x00, 0x7a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x84, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@@@@%....
    0x00, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@+...
    0x2e, 0xfc, 0xff, 0xff, 0xd0, 0x54, 0x18, 0x04, 0x1a, 0x4c, 0xc6, 0xff, 0xff, 0xfa, 0x1c, 0x00, 0x00,  //.@@@@+...+@@@@...
    0x96, 0xff, 0xff, 0xca, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xba, 0xff, 0xff, 0x80, 0x00, 0x00,  //%@@@.......%@@+..
    0xd6, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xc0, 0x00, 0x00,  //@@@+........@@%..
    0xf2, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x8a, 0xff, 0xff, 0xe6, 0x00, 0x00,  //@@@........%@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xbe, 0xff, 0xff, 0xff, 0xe8, 0xbe, 0x00, 0x00,  //@@@......%@@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x14, 0xe0, 0xff, 0xff, 0xa8, 0x2c, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@@%.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@....%@@%......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xe2, 0xff, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@....@@@.......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xf6, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@....@@@.......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@....@@@+......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xfc, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@....+@@@+.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x06, 0xba, 0xff, 0xff, 0xff, 0xc4, 0x26, 0x00, 0x00, 0x00,  //@@@.....%@@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x88, 0xfc, 0xff, 0xff, 0xf4, 0x60, 0x00, 0x00,  //@@@......%@@@@+..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xd0, 0xff, 0xff, 0xff, 0x80, 0x00,  //@@@........@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x80, 0xfc, 0xff, 0xff, 0x4a,  //@@@.........+@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xba,  //@@@..........+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xea,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xf4,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xd6,  //@@@..........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0xd2, 0x80, 0x42, 0x22, 0x08, 0x0e, 0x2e, 0x8a, 0xf8, 0xff, 0xff, 0x8a,  //@@@..@++....%@@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x12,  //@@@..@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x28, 0x00,  //@@@..@@@@@@@@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x26, 0x78, 0xc0, 0xea, 0xfa, 0xf2, 0xda, 0xaa, 0x58, 0x04, 0x00, 0x00,  //@@@...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00e0 (à) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x8a, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@%..........
    0x00, 0x00, 0x00, 0xa0, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@+.........
    0x00, 0x00, 0x00, 0x02, 0xb6, 0xff, 0xfa, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@+........
    0x00, 0x00, 0x00, 0x00, 0x0a, 0xc8, 0xff, 0xea, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xd6, 0xff, 0xc8, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xe4, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x28, 0x82, 0xbe, 0xe8, 0xf8, 0xee, 0xda, 0xa6, 0x5e, 0x04, 0x00, 0x00, 0x00,  //....%%@@@@%+....
    0x00, 0x40, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x3c, 0x00, 0x00,  //..%@@@@@@@@@@...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x3c, 0x00,  //.@@@@@@@@@@@@@..
    0x00, 0xff, 0xfc, 0xba, 0x66, 0x2c, 0x10, 0x02, 0x0e, 0x34, 0x80, 0xec, 0xff, 0xff, 0xe2, 0x04,  //.@@%+.....+@@@@.
    0x00, 0xb4, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xd6, 0xff, 0xff, 0x5c,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xa6,  //............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xd8,  //.............@@@
    0x00, 0x00, 0x00, 0x28, 0x7e, 0xb8, 0xe0, 0xf0, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee,  //....+%@@@@@@@@@@
    0x00, 0x0a, 0xa2, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //..%@@@@@@@@@@@@@
    0x02, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x6a, 0xff, 0xff, 0xff, 0xb8, 0x60, 0x30, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //+@@@%+.......@@@
    0xc4, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xff,  //@@@%.........@@@
    0xee, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xff,  //@@@.........+@@@
    0xf8, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0xff,  //@@@.........@@@@
    0xdc, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x9a, 0xff, 0xff, 0xff, 0xff,  //@@@+.......%@@@@
    0x90, 0xff, 0xff, 0xfc, 0x9a, 0x36, 0x10, 0x04, 0x1e, 0x60, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff,  //%@@@%....+@@@@@@
    0x1a, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@%@@@
    0x00, 0x38, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x80, 0x00, 0xff, 0xff, 0xff,  //..@@@@@@@@@+.@@@
    0x00, 0x00, 0x10, 0x7a, 0xc8, 0xee, 0xf8, 0xe6, 0xca, 0x84, 0x26, 0x00, 0x00, 0xff, 0xff, 0xff,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00e1 (á) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00,  //.........%@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00,  //........+@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xfc, 0xff, 0xb6, 0x02, 0x00, 0x00, 0x00, 0x00,  //.......+@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xec, 0xff, 0xc8, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xcc, 0xff, 0xd6, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xe4, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x28, 0x82, 0xbe, 0xe8, 0xf8, 0xee, 0xda, 0xa6, 0x5e, 0x04, 0x00, 0x00, 0x00,  //....%%@@@@%+....
    0x00, 0x40, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x3c, 0x00, 0x00,  //..%@@@@@@@@@@...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x3c, 0x00,  //.@@@@@@@@@@@@@..
    0x00, 0xff, 0xfc, 0xba, 0x66, 0x2c, 0x10, 0x02, 0x0e, 0x34, 0x80, 0xec, 0xff, 0xff, 0xe2, 0x04,  //.@@%+.....+@@@@.
    0x00, 0xb4, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xd6, 0xff, 0xff, 0x5c,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xa6,  //............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xd8,  //.............@@@
    0x00, 0x00, 0x00, 0x28, 0x7e, 0xb8, 0xe0, 0xf0, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee,  //....+%@@@@@@@@@@
    0x00, 0x0a, 0xa2, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //..%@@@@@@@@@@@@@
    0x02, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x6a, 0xff, 0xff, 0xff, 0xb8, 0x60, 0x30, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //+@@@%+.......@@@
    0xc4, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xff,  //@@@%.........@@@
    0xee, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xff,  //@@@.........+@@@
    0xf8, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0xff,  //@@@.........@@@@
    0xdc, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x9a, 0xff, 0xff, 0xff, 0xff,  //@@@+.......%@@@@
    0x90, 0xff, 0xff, 0xfc, 0x9a, 0x36, 0x10, 0x04, 0x1e, 0x60, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff,  //%@@@%....+@@@@@@
    0x1a, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@%@@@
    0x00, 0x38, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x80, 0x00, 0xff, 0xff, 0xff,  //..@@@@@@@@@+.@@@
    0x00, 0x00, 0x10, 0x7a, 0xc8, 0xee, 0xf8, 0xe6, 0xca, 0x84, 0x26, 0x00, 0x00, 0xff, 0xff, 0xff,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00e2 (â) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xf6, 0xff, 0xff, 0xf6, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xb2, 0xb2, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@%%@%.....
    0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xe4, 0x12, 0x14, 0xe4, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00,  //....+@@..@@+....
    0x00, 0x00, 0x00, 0x18, 0xee, 0xfc, 0x42, 0x00, 0x00, 0x42, 0xfc, 0xee, 0x18, 0x00, 0x00, 0x00,  //....@@+..+@@....
    0x00, 0x00, 0x00, 0xac, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xac, 0x00, 0x00, 0x00,  //...%@%....%@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x28, 0x82, 0xbe, 0xe8, 0xf8, 0xee, 0xda, 0xa6, 0x5e, 0x04, 0x00, 0x00, 0x00,  //....%%@@@@%+....
    0x00, 0x40, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x3c, 0x00, 0x00,  //..%@@@@@@@@@@...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x3c, 0x00,  //.@@@@@@@@@@@@@..
    0x00, 0xff, 0xfc, 0xba, 0x66, 0x2c, 0x10, 0x02, 0x0e, 0x34, 0x80, 0xec, 0xff, 0xff, 0xe2, 0x04,  //.@@%+.....+@@@@.
    0x00, 0xb4, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xd6, 0xff, 0xff, 0x5c,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xa6,  //............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xd8,  //.............@@@
    0x00, 0x00, 0x00, 0x28, 0x7e, 0xb8, 0xe0, 0xf0, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee,  //....+%@@@@@@@@@@
    0x00, 0x0a, 0xa2, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //..%@@@@@@@@@@@@@
    0x02, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x6a, 0xff, 0xff, 0xff, 0xb8, 0x60, 0x30, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //+@@@%+.......@@@
    0xc4, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xff,  //@@@%.........@@@
    0xee, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xff,  //@@@.........+@@@
    0xf8, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0xff,  //@@@.........@@@@
    0xdc, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x9a, 0xff, 0xff, 0xff, 0xff,  //@@@+.......%@@@@
    0x90, 0xff, 0xff, 0xfc, 0x9a, 0x36, 0x10, 0x04, 0x1e, 0x60, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff,  //%@@@%....+@@@@@@
    0x1a, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@%@@@
    0x00, 0x38, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x80, 0x00, 0xff, 0xff, 0xff,  //..@@@@@@@@@+.@@@
    0x00, 0x00, 0x10, 0x7a, 0xc8, 0xee, 0xf8, 0xe6, 0xca, 0x84, 0x26, 0x00, 0x00, 0xff, 0xff, 0xff,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00e3 (ã) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x74, 0xec, 0xe0, 0x76, 0x00, 0x00, 0x00, 0xd8, 0xf6, 0x00, 0x00, 0x00,  //....+@@+...@@...
    0x00, 0x00, 0x00, 0x46, 0xff, 0xff, 0xff, 0xff, 0x9a, 0x00, 0x00, 0xf0, 0xde, 0x00, 0x00, 0x00,  //...+@@@@%..@@...
    0x00, 0x00, 0x00, 0xaa, 0xff, 0x50, 0x6a, 0xff, 0xff, 0x68, 0x50, 0xff, 0xaa, 0x00, 0x00, 0x00,  //...%@++@@++@%...
    0x00, 0x00, 0x00, 0xe0, 0xf0, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00,  //...@@..%@@@@+...
    0x00, 0x00, 0x00, 0xf8, 0xd6, 0x00, 0x00, 0x00, 0x78, 0xe2, 0xec, 0x74, 0x00, 0x00, 0x00, 0x00,  //...@@...+@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x28, 0x82, 0xbe, 0xe8, 0xf8, 0xee, 0xda, 0xa6, 0x5e, 0x04, 0x00, 0x00, 0x00,  //....%%@@@@%+....
    0x00, 0x40, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x3c, 0x00, 0x00,  //..%