
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_DEJAVU_40_CYRILLIC != 0 /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * DejaVuSans.ttf 40 px Font in U+0410 (А) .. U+044f (я)  range with 1 bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_dejavu_40_cyrillic_glyph_bitmap[] = {
#if USE_LV_FONT_DEJAVU_40_CYRILLIC == 1
    /*Unicode: U+0410 (А) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x7c, 0x00,  //.........%@@@%.........
    0x00, 0x7c, 0x00,  //.........@@@@@.........
    0x00, 0x7c, 0x00,  //........+@@@@@+........
    0x00, 0xfe, 0x00,  //........@@@@@@@........
    0x00, 0xee, 0x00,  //........@@@.@@@........
    0x01, 0xef, 0x00,  //.......%@@%.%@@%.......
    0x01, 0xc7, 0x00,  //.......@@@+.+@@@.......
    0x01, 0xc7, 0x00,  //......+@@@...@@@+......
    0x03, 0xc7, 0x80,  //......%@@%...%@@%......
    0x03, 0x83, 0x80,  //......@@@.....@@@......
    0x03, 0x83, 0x80,  //.....+@@@.....%@@+.....
    0x07, 0x01, 0xc0,  //.....@@@+.....+@@@.....
    0x07, 0x01, 0xc0,  //.....@@@.......@@@.....
    0x0f, 0x01, 0xe0,  //....%@@%.......%@@%....
    0x0e, 0x00, 0xe0,  //....@@@.........@@@....
    0x0e, 0x00, 0xe0,  //...+@@@.........@@@+...
    0x1f, 0xff, 0xf0,  //...%@@@@@@@@@@@@@@@%...
    0x1f, 0xff, 0xf0,  //...@@@@@@@@@@@@@@@@@...
    0x3f, 0xff, 0xf8,  //..%@@@@@@@@@@@@@@@@@%..
    0x38, 0x00, 0x38,  //..@@@+...........+@@@..
    0x38, 0x00, 0x38,  //.+@@@.............@@@+.
    0x78, 0x00, 0x3c,  //.%@@%.............%@@%.
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x70, 0x00, 0x1c,  //+@@@...............@@@+
    0xe0, 0x00, 0x0e,  //@@@+...............+@@@
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0411 (Б) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@..
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xff, 0xf8, 0x00,  //@@@@@@@@@@@@%.....
    0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+.
    0xe0, 0x0f, 0x80,  //@@@.........%@@@@.
    0xe0, 0x03, 0x80,  //@@@...........@@@+
    0xe0, 0x01, 0xc0,  //@@@...........+@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@...........+@@@
    0xe0, 0x03, 0xc0,  //@@@...........@@@%
    0xe0, 0x0f, 0x80,  //@@@.........%@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@+..
    0xff, 0xf8, 0x00,  //@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0412 (В) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0xff, 0xf8, 0x00,  //@@@@@@@@@@@%%.....
    0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@%...
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@..
    0xe0, 0x0f, 0x00,  //@@@........+@@@@+.
    0xe0, 0x07, 0x80,  //@@@..........%@@@.
    0xe0, 0x03, 0x80,  //@@@...........@@@.
    0xe0, 0x03, 0x80,  //@@@...........@@@.
    0xe0, 0x03, 0x80,  //@@@...........@@@.
    0xe0, 0x07, 0x80,  //@@@..........%@@%.
    0xe0, 0x0f, 0x00,  //@@@........+@@@@..
    0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@%....
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@%..
    0xe0, 0x0f, 0x80,  //@@@.........%@@@%.
    0xe0, 0x03, 0x80,  //@@@...........@@@.
    0xe0, 0x01, 0xc0,  //@@@...........+@@%
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@...........+@@@
    0xe0, 0x03, 0xc0,  //@@@...........@@@%
    0xe0, 0x0f, 0x80,  //@@@.........%@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@+..
    0xff, 0xf8, 0x00,  //@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0413 (Г) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+0414 (Д) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x03, 0xff, 0xf0,  //......@@@@@@@@@@@@@@...
    0x03, 0xff, 0xf0,  //......@@@@@@@@@@@@@@...
    0x03, 0xff, 0xf0,  //......@@@@@@@@@@@@@@...
    0x03, 0x80, 0x70,  //......@@@........@@@...
    0x03, 0x80, 0x70,  //......@@@........@@@...
    0x03, 0x80, 0x70,  //......@@@........@@@...
    0x03, 0x80, 0x70,  //......@@@........@@@...
    0x03, 0x80, 0x70,  //......@@@........@@@...
    0x03, 0x80, 0x70,  //......@@@........@@@...
    0x03, 0x80, 0x70,  //......@@@........@@@...
    0x03, 0x80, 0x70,  //......@@@........@@@...
    0x03, 0x80, 0x70,  //.....+@@@........@@@...
    0x03, 0x80, 0x70,  //.....+@@%........@@@...
    0x07, 0x80, 0x70,  //.....%@@%........@@@...
    0x07, 0x00, 0x70,  //.....%@@+........@@@...
    0x07, 0x00, 0x70,  //.....@@@+........@@@...
    0x07, 0x00, 0x70,  //.....@@@.........@@@...
    0x07, 0x00, 0x70,  //....+@@@.........@@@...
    0x0f, 0x00, 0x70,  //....%@@%.........@@@...
    0x0e, 0x00, 0x70,  //....@@@+.........@@@...
    0x1e, 0x00, 0x70,  //...%@@@..........@@@...
    0x3c, 0x00, 0x70,  //..%@@@+..........@@@...
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0415 (Е) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0416 (Ж) , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x78, 0x00, 0xe0, 0x03, 0xc0,  //.%@@@+..........@@@..........+@@@%.
    0x3c, 0x00, 0xe0, 0x07, 0x80,  //..%@@@+.........@@@.........+@@@%..
    0x1e, 0x00, 0xe0, 0x0f, 0x00,  //...%@@@+........@@@........+@@@%...
    0x0f, 0x00, 0xe0, 0x1e, 0x00,  //....@@@@........@@@........@@@@....
    0x07, 0x80, 0xe0, 0x3c, 0x00,  //.....@@@@.......@@@.......@@@@.....
    0x03, 0xc0, 0xe0, 0x78, 0x00,  //......@@@@......@@@......@@@@......
    0x01, 0xe0, 0xe0, 0xf0, 0x00,  //.......@@@@.....@@@.....@@@@.......
    0x00, 0xf0, 0xe1, 0xe0, 0x00,  //.......+@@@%....@@@....%@@@+.......
    0x00, 0x78, 0xe3, 0xc0, 0x00,  //........+@@@%...@@@...%@@@+........
    0x00, 0x7c, 0xe7, 0xc0, 0x00,  //.........%@@@%..@@@..%@@@%.........
    0x00, 0x7c, 0xe7, 0xc0, 0x00,  //.........%@@@@+.@@@.+@@@@%.........
    0x00, 0x7e, 0xef, 0xc0, 0x00,  //.........@@@@@@+@@@+@@@@@@.........
    0x00, 0xff, 0xff, 0xe0, 0x00,  //........@@@%@@@@@@@@@@@%@@@........
    0x01, 0xe7, 0xfc, 0xf0, 0x00,  //.......%@@@..@@@@@@@@@..@@@%.......
    0x01, 0xc3, 0xf8, 0x70, 0x00,  //.......@@@+...@@@@@@@...+@@@.......
    0x03, 0xc1, 0xf0, 0x78, 0x00,  //......@@@%.....@@@@@.....%@@@......
    0x03, 0x80, 0xe0, 0x38, 0x00,  //.....+@@@......+@@@+......@@@+.....
    0x07, 0x00, 0xe0, 0x1c, 0x00,  //.....@@@+.......@@@.......+@@@.....
    0x0f, 0x00, 0xe0, 0x1e, 0x00,  //....@@@@........@@@........@@@@....
    0x0e, 0x00, 0xe0, 0x0e, 0x00,  //...+@@@.........@@@.........@@@+...
    0x1c, 0x00, 0xe0, 0x07, 0x00,  //...@@@+.........@@@.........+@@@...
    0x3c, 0x00, 0xe0, 0x07, 0x80,  //..%@@@..........@@@..........@@@%..
    0x38, 0x00, 0xe0, 0x03, 0x80,  //.+@@@...........@@@...........@@@+.
    0x78, 0x00, 0xe0, 0x03, 0xc0,  //.@@@%...........@@@...........%@@@.
    0xf0, 0x00, 0xe0, 0x01, 0xe0,  //%@@@............@@@............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+0417 (З) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x0f, 0xe0, 0x00,  //...+%@@@@@%+.....
    0x7f, 0xf8, 0x00,  //.%@@@@@@@@@@@+...
    0xff, 0xfc, 0x00,  //%@@@@@@@@@@@@@+..
    0xf0, 0x1e, 0x00,  //%@@@+.....+@@@@..
    0xc0, 0x0f, 0x00,  //%@+.........%@@%.
    0x80, 0x07, 0x00,  //%............@@@.
    0x00, 0x07, 0x00,  //.............@@@.
    0x00, 0x07, 0x00,  //.............@@@.
    0x00, 0x0f, 0x00,  //............%@@%.
    0x00, 0x1e, 0x00,  //..........+@@@@..
    0x0f, 0xfc, 0x00,  //....@@@@@@@@@%...
    0x0f, 0xf0, 0x00,  //....@@@@@@@@+....
    0x0f, 0xfc, 0x00,  //....@@@@@@@@@%...
    0x00, 0x1e, 0x00,  //..........+%@@@+.
    0x00, 0x07, 0x00,  //............+@@@.
    0x00, 0x03, 0x80,  //.............+@@%
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x80, 0x07, 0x80,  //%............+@@%
    0xc0, 0x07, 0x00,  //@@..........+@@@+
    0xf0, 0x1f, 0x00,  //@@@%+.....+%@@@%.
    0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@..
    0x7f, 0xf8, 0x00,  //+@@@@@@@@@@@@+...
    0x0f, 0xe0, 0x00,  //...+%@@@@@%+.....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0418 (И) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xe0, 0x03, 0xe0,  //@@@...........%@@@@
    0xe0, 0x03, 0xe0,  //@@@...........@@@@@
    0xe0, 0x07, 0xe0,  //@@@..........%@@@@@
    0xe0, 0x07, 0xe0,  //@@@.........+@@@@@@
    0xe0, 0x0f, 0xe0,  //@@@.........@@@%@@@
    0xe0, 0x0e, 0xe0,  //@@@........+@@@.@@@
    0xe0, 0x1e, 0xe0,  //@@@........@@@+.@@@
    0xe0, 0x1c, 0xe0,  //@@@.......+@@@..@@@
    0xe0, 0x38, 0xe0,  //@@@.......@@@+..@@@
    0xe0, 0x78, 0xe0,  //@@@......%@@@...@@@
    0xe0, 0x70, 0xe0,  //@@@......@@@+...@@@
    0xe0, 0xf0, 0xe0,  //@@@.....%@@%....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe1, 0xe0, 0xe0,  //@@@....%@@%.....@@@
    0xe1, 0xc0, 0xe0,  //@@@...+@@@......@@@
    0xe3, 0xc0, 0xe0,  //@@@...@@@%......@@@
    0xe3, 0x80, 0xe0,  //@@@..+@@@.......@@@
    0xe7, 0x00, 0xe0,  //@@@..@@@+.......@@@
    0xe7, 0x00, 0xe0,  //@@@.+@@@........@@@
    0xee, 0x00, 0xe0,  //@@@.@@@+........@@@
    0xfe, 0x00, 0xe0,  //@@@%@@@.........@@@
    0xfc, 0x00, 0xe0,  //@@@@@@+.........@@@
    0xfc, 0x00, 0xe0,  //@@@@@%..........@@@
    0xf8, 0x00, 0xe0,  //@@@@@...........@@@
    0xf8, 0x00, 0xe0,  //@@@@%...........@@@
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0419 (Й) , Width: 19 */
    0x06, 0x0c, 0x00,  //.....@@.....@@.....
    0x07, 0x1c, 0x00,  //.....%@%...%@%.....
    0x03, 0xf8, 0x00,  //......@@@@@@@......
    0x01, 0xf0, 0x00,  //.......%@@@%.......
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xe0, 0x03, 0xe0,  //@@@...........%@@@@
    0xe0, 0x03, 0xe0,  //@@@...........@@@@@
    0xe0, 0x07, 0xe0,  //@@@..........%@@@@@
    0xe0, 0x07, 0xe0,  //@@@.........+@@@@@@
    0xe0, 0x0f, 0xe0,  //@@@.........@@@%@@@
    0xe0, 0x0e, 0xe0,  //@@@........+@@@.@@@
    0xe0, 0x1e, 0xe0,  //@@@........@@@+.@@@
    0xe0, 0x1c, 0xe0,  //@@@.......+@@@..@@@
    0xe0, 0x38, 0xe0,  //@@@.......@@@+..@@@
    0xe0, 0x78, 0xe0,  //@@@......%@@@...@@@
    0xe0, 0x70, 0xe0,  //@@@......@@@+...@@@
    0xe0, 0xf0, 0xe0,  //@@@.....%@@%....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe1, 0xe0, 0xe0,  //@@@....%@@%.....@@@
    0xe1, 0xc0, 0xe0,  //@@@...+@@@......@@@
    0xe3, 0xc0, 0xe0,  //@@@...@@@%......@@@
    0xe3, 0x80, 0xe0,  //@@@..+@@@.......@@@
    0xe7, 0x00, 0xe0,  //@@@..@@@+.......@@@
    0xe7, 0x00, 0xe0,  //@@@.+@@@........@@@
    0xee, 0x00, 0xe0,  //@@@.@@@+........@@@
    0xfe, 0x00, 0xe0,  //@@@%@@@.........@@@
    0xfc, 0x00, 0xe0,  //@@@@@@+.........@@@
    0xfc, 0x00, 0xe0,  //@@@@@%..........@@@
    0xf8, 0x00, 0xe0,  //@@@@@...........@@@
    0xf8, 0x00, 0xe0,  //@@@@%...........@@@
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+041a (К) , Width: 20 */
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0xe0, 0x03, 0xe0,  //@@@...........%@@@%.
    0xe0, 0x07, 0xc0,  //@@@..........%@@@%..
    0xe0, 0x0f, 0x80,  //@@@.........%@@@%...
    0xe0, 0x0f, 0x00,  //@@@........+@@@%....
    0xe0, 0x1e, 0x00,  //@@@.......+@@@%.....
    0xe0, 0x3c, 0x00,  //@@@......+@@@%......
    0xe0, 0x78, 0x00,  //@@@.....+@@@@.......
    0xe0, 0xf0, 0x00,  //@@@....+@@@@........
    0xe1, 0xe0, 0x00,  //@@@...+@@@@.........
    0xe3, 0xc0, 0x00,  //@@@...@@@@..........
    0xe7, 0xc0, 0x00,  //@@@..@@@@@..........
    0xef, 0xe0, 0x00,  //@@@.@@@@@@%.........
    0xfe, 0xe0, 0x00,  //@@@@@@@+@@@+........
    0xfc, 0xf0, 0x00,  //@@@@@@..%@@@........
    0xf8, 0x78, 0x00,  //@@@@@....@@@@.......
    0xf0, 0x38, 0x00,  //@@@@+.....@@@+......
    0xe0, 0x3c, 0x00,  //@@@+......+@@@......
    0xe0, 0x1e, 0x00,  //@@@........@@@@.....
    0xe0, 0x0f, 0x00,  //@@@.........@@@%....
    0xe0, 0x07, 0x00,  //@@@.........+@@@....
    0xe0, 0x07, 0x80,  //@@@..........%@@@...
    0xe0, 0x03, 0xc0,  //@@@...........@@@%..
    0xe0, 0x01, 0xc0,  //@@@...........+@@@+.
    0xe0, 0x01, 0xe0,  //@@@............%@@@.
    0xe0, 0x00, 0xf0,  //@@@.............@@@%
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................


    /*Unicode: U+041b (Л) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x03, 0xff, 0xf8,  //......@@@@@@@@@@@@@@@
    0x03, 0xff, 0xf8,  //......@@@@@@@@@@@@@@@
    0x03, 0xff, 0xf8,  //......@@@@@@@@@@@@@@@
    0x03, 0x80, 0x38,  //......@@@.........@@@
    0x03, 0x80, 0x38,  //......@@@.........@@@
    0x03, 0x80, 0x38,  //......@@@.........@@@
    0x03, 0x80, 0x38,  //......@@@.........@@@
    0x03, 0x80, 0x38,  //......@@@.........@@@
    0x03, 0x80, 0x38,  //......@@@.........@@@
    0x03, 0x80, 0x38,  //......@@@.........@@@
    0x03, 0x80, 0x38,  //......@@@.........@@@
    0x03, 0x80, 0x38,  //......@@@.........@@@
    0x03, 0x80, 0x38,  //.....+@@%.........@@@
    0x03, 0x80, 0x38,  //.....+@@%.........@@@
    0x07, 0x80, 0x38,  //.....%@@%.........@@@
    0x07, 0x00, 0x38,  //.....%@@+.........@@@
    0x07, 0x00, 0x38,  //.....@@@..........@@@
    0x07, 0x00, 0x38,  //.....@@@..........@@@
    0x07, 0x00, 0x38,  //....+@@@..........@@@
    0x0e, 0x00, 0x38,  //....@@@+..........@@@
    0x1e, 0x00, 0x38,  //...@@@@...........@@@
    0x3c, 0x00, 0x38,  //.+@@@@+...........@@@
    0xfc, 0x00, 0x38,  //@@@@@%............@@@
    0xf0, 0x00, 0x38,  //@@@@+.............@@@
    0xc0, 0x00, 0x38,  //@%+...............@@@
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+041c (М) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0xf8, 0x00, 0x3e,  //@@@@@.............@@@@@
    0xfc, 0x00, 0x7e,  //@@@@@%...........%@@@@@
    0xfc, 0x00, 0x7e,  //@@@@@@...........@@@@@@
    0xfc, 0x00, 0x7e,  //@@@@@@+.........+@@@@@@
    0xee, 0x00, 0xee,  //@@@+@@@.........@@@+@@@
    0xee, 0x00, 0xee,  //@@@.@@@.........@@@.@@@
    0xef, 0x01, 0xee,  //@@@.%@@%.......%@@%.@@@
    0xe7, 0x01, 0xce,  //@@@..@@@.......@@@..@@@
    0xe7, 0x01, 0xce,  //@@@..@@@+.....+@@@..@@@
    0xe3, 0x83, 0x8e,  //@@@..+@@@.....@@@+..@@@
    0xe3, 0x83, 0x8e,  //@@@...@@@.....@@@...@@@
    0xe3, 0xc7, 0x8e,  //@@@...%@@%...%@@%...@@@
    0xe1, 0xc7, 0x0e,  //@@@....@@@...@@@....@@@
    0xe1, 0xc7, 0x0e,  //@@@....@@@+.+@@@....@@@
    0xe0, 0xee, 0x0e,  //@@@....+@@@.@@@+....@@@
    0xe0, 0xee, 0x0e,  //@@@.....@@@+@@@.....@@@
    0xe0, 0xfe, 0x0e,  //@@@.....%@@@@@%.....@@@
    0xe0, 0x7c, 0x0e,  //@@@......@@@@@......@@@
    0xe0, 0x7c, 0x0e,  //@@@......@@@@@......@@@
    0xe0, 0x38, 0x0e,  //@@@......+@@@+......@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+041d (Н) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+041e (О) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0xfe, 0x00,  //.......+%@@@@@%+.......
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@+.....
    0x0f, 0xff, 0xe0,  //....%@@@@@@@@@@@@@@....
    0x1f, 0x01, 0xf0,  //...@@@@@+.....+@@@@@...
    0x3e, 0x00, 0xf8,  //..%@@@%.........+@@@%..
    0x38, 0x00, 0x38,  //.+@@@+...........+@@@+.
    0x78, 0x00, 0x3c,  //.@@@%.............%@@@.
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x70, 0x00, 0x1c,  //+@@%...............%@@+
    0xe0, 0x00, 0x0e,  //%@@+...............+@@%
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //%@@+...............+@@%
    0x70, 0x00, 0x1c,  //+@@%...............%@@+
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x78, 0x00, 0x3c,  //.@@@%.............%@@@.
    0x38, 0x00, 0x38,  //.+@@@+...........+@@@+.
    0x3e, 0x00, 0x78,  //..%@@@+.........+@@@%..
    0x1f, 0x01, 0xf0,  //...@@@@@+.....+@@@@@...
    0x0f, 0xff, 0xe0,  //....@@@@@@@@@@@@@@@....
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@+.....
    0x00, 0xfe, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+041f (П) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0420 (Р) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xff, 0xe0,  //@@@@@@@@@@%+....
    0xff, 0xf8,  //@@@@@@@@@@@@@+..
    0xff, 0xfc,  //@@@@@@@@@@@@@@+.
    0xe0, 0x3e,  //@@@.......%@@@@.
    0xe0, 0x0f,  //@@@.........@@@%
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x0f,  //@@@.........@@@%
    0xe0, 0x3e,  //@@@.......%@@@@.
    0xff, 0xfc,  //@@@@@@@@@@@@@@+.
    0xff, 0xf8,  //@@@@@@@@@@@@@+..
    0xff, 0xe0,  //@@@@@@@@@@%+....
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0421 (С) , Width: 20 */
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0xff, 0x00,  //.......+%@@@@@@%+...
    0x03, 0xff, 0xe0,  //.....+@@@@@@@@@@@@%.
    0x0f, 0xff, 0xf0,  //....%@@@@@@@@@@@@@@@
    0x1f, 0x81, 0xf0,  //...@@@@@%+....+%@@@@
    0x3e, 0x00, 0x30,  //..%@@@+..........+@@
    0x38, 0x00, 0x10,  //.+@@@+.............%
    0x78, 0x00, 0x00,  //.@@@%...............
    0x70, 0x00, 0x00,  //.@@@................
    0x70, 0x00, 0x00,  //+@@%................
    0xe0, 0x00, 0x00,  //%@@+................
    0xe0, 0x00, 0x00,  //@@@.................
    0xe0, 0x00, 0x00,  //@@@.................
    0xe0, 0x00, 0x00,  //@@@.................
    0xe0, 0x00, 0x00,  //@@@.................
    0xe0, 0x00, 0x00,  //@@@.................
    0xe0, 0x00, 0x00,  //%@@+................
    0x70, 0x00, 0x00,  //+@@%................
    0x70, 0x00, 0x00,  //.@@@................
    0x78, 0x00, 0x00,  //.@@@%...............
    0x38, 0x00, 0x10,  //.+@@@+.............%
    0x3c, 0x00, 0x30,  //..%@@@+..........+@@
    0x1f, 0x81, 0xf0,  //...@@@@@%+....+%@@@@
    0x0f, 0xff, 0xf0,  //....%@@@@@@@@@@@@@@@
    0x03, 0xff, 0xe0,  //.....+@@@@@@@@@@@@%.
    0x00, 0xff, 0x00,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................


    /*Unicode: U+0422 (Т) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0423 (У) , Width: 20 */
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0xe0, 0x00, 0x70,  //@@@+............+@@@
    0x70, 0x00, 0xe0,  //+@@@............@@@+
    0x70, 0x00, 0xe0,  //.@@@+..........+@@@.
    0x38, 0x01, 0xe0,  //.+@@@..........%@@%.
    0x38, 0x01, 0xc0,  //..@@@..........@@@..
    0x3c, 0x03, 0xc0,  //..%@@%........%@@%..
    0x1c, 0x03, 0x80,  //...@@@........@@@...
    0x1e, 0x03, 0x80,  //...%@@%......+@@@...
    0x0e, 0x07, 0x00,  //....@@@......@@@+...
    0x0e, 0x07, 0x00,  //....@@@+....+@@@....
    0x07, 0x0f, 0x00,  //....+@@@....%@@%....
    0x07, 0x0e, 0x00,  //.....@@@+...@@@.....
    0x03, 0x9e, 0x00,  //.....+@@@..%@@%.....
    0x03, 0x9c, 0x00,  //......@@@..@@@+.....
    0x03, 0xdc, 0x00,  //......%@@%+@@@......
    0x01, 0xf8, 0x00,  //.......@@@@@@+......
    0x01, 0xf8, 0x00,  //.......%@@@@@.......
    0x00, 0xf8, 0x00,  //.......+@@@@%.......
    0x00, 0xf0, 0x00,  //........@@@@........
    0x00, 0xf0, 0x00,  //........@@@%........
    0x00, 0xe0, 0x00,  //.......+@@@+........
    0x01, 0xe0, 0x00,  //......+@@@@.........
    0x1f, 0xc0, 0x00,  //...@@@@@@@+.........
    0x1f, 0xc0, 0x00,  //...@@@@@@%..........
    0x1f, 0x00, 0x00,  //...@@@@%+...........
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................


    /*Unicode: U+0424 (Ф) , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0xff, 0x80, 0x00,  //.......+%@@@@@@@%+.......
    0x07, 0xff, 0xf0, 0x00,  //.....%@@@@@@@@@@@@@%.....
    0x1f, 0xff, 0xfc, 0x00,  //...%@@@@@@@@@@@@@@@@@%...
    0x3f, 0x1c, 0x7e, 0x00,  //..%@@@@%+..@@@..+%@@@@%..
    0x3c, 0x1c, 0x1e, 0x00,  //.+@@@@.....@@@.....%@@@+.
    0x78, 0x1c, 0x0f, 0x00,  //.@@@%......@@@......%@@@.
    0x70, 0x1c, 0x07, 0x00,  //+@@@.......@@@.......@@@+
    0xe0, 0x1c, 0x03, 0x80,  //%@@+.......@@@.......+@@%
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //%@@+.......@@@.......+@@%
    0x70, 0x1c, 0x07, 0x00,  //+@@%.......@@@.......%@@+
    0x70, 0x1c, 0x07, 0x00,  //.@@@+......@@@......+@@@.
    0x38, 0x1c, 0x0e, 0x00,  //.+@@@+.....@@@.....+@@@+.
    0x3e, 0x1c, 0x3e, 0x00,  //..%@@@@+...@@@...+@@@@%..
    0x1f, 0xff, 0xfc, 0x00,  //...%@@@@@@%@@@%@@@@@@%...
    0x07, 0xff, 0xf0, 0x00,  //.....%@@@@@@@@@@@@@%.....
    0x00, 0xff, 0x80, 0x00,  //.......+%@@@@@@@%+.......
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+0425 (Х) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x78, 0x00, 0xf0,  //.%@@@...........@@@%.
    0x3c, 0x01, 0xe0,  //..@@@%.........%@@@..
    0x1c, 0x01, 0xc0,  //..+@@@.........@@@+..
    0x1e, 0x03, 0xc0,  //...%@@@.......@@@%...
    0x0f, 0x07, 0x80,  //....@@@%.....%@@@....
    0x07, 0x07, 0x00,  //....+@@@.....@@@+....
    0x07, 0x8f, 0x00,  //.....%@@@...@@@%.....
    0x03, 0xde, 0x00,  //......@@@%.%@@@......
    0x01, 0xdc, 0x00,  //......+@@@+@@@+......
    0x01, 0xfc, 0x00,  //.......@@@@@@%.......
    0x00, 0xf8, 0x00,  //........@@@@@........
    0x00, 0xf0, 0x00,  //........%@@@+........
    0x00, 0xf8, 0x00,  //........@@@@@........
    0x00, 0xf8, 0x00,  //.......+@@@@@+.......
    0x01, 0xfc, 0x00,  //.......@@@@@@@.......
    0x03, 0xde, 0x00,  //......@@@@.@@@%......
    0x03, 0x8e, 0x00,  //.....+@@@...@@@+.....
    0x07, 0x0f, 0x00,  //.....@@@+...%@@@.....
    0x0f, 0x07, 0x80,  //....%@@@.....@@@%....
    0x0e, 0x03, 0x80,  //...+@@@.......@@@+...
    0x1e, 0x03, 0xc0,  //...@@@%.......%@@@...
    0x3c, 0x01, 0xe0,  //..%@@@.........@@@%..
    0x38, 0x00, 0xe0,  //.+@@@..........+@@@+.
    0x78, 0x00, 0xf0,  //.@@@%...........%@@@.
    0xf0, 0x00, 0x78,  //%@@@.............@@@%
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0426 (Ц) , Width: 22 */
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xe0, 0x00, 0xe0,  //@@@.............@@@...
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x1c,  //...................@@@
    0x00, 0x00, 0x1c,  //...................@@@
    0x00, 0x00, 0x1c,  //...................@@@
    0x00, 0x00, 0x1c,  //...................@@@
    0x00, 0x00, 0x1c,  //...................@@@
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................


    /*Unicode: U+0427 (Ч) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //%@@+..........@@@
    0xf0, 0x03, 0x80,  //+@@@..........@@@
    0x78, 0x03, 0x80,  //.@@@@+........@@@
    0x7f, 0xff, 0x80,  //.+@@@@@@@@@@@@@@@
    0x3f, 0xff, 0x80,  //..%@@@@@@@@@@@@@@
    0x0f, 0xff, 0x80,  //....%@@@@@@@@@@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0428 (Ш) , Width: 31 */
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xe0, 0x03, 0x80, 0x0e,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+0429 (Щ) , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xe0, 0x03, 0x80, 0x0e, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x01, 0xc0,  //...............................@@@
    0x00, 0x00, 0x00, 0x01, 0xc0,  //...............................@@@
    0x00, 0x00, 0x00, 0x01, 0xc0,  //...............................@@@
    0x00, 0x00, 0x00, 0x01, 0xc0,  //...............................@@@
    0x00, 0x00, 0x00, 0x01, 0xc0,  //...............................@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+042a (Ъ) , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0xff, 0xc0, 0x00, 0x00,  //@@@@@@@@@@...............
    0xff, 0xc0, 0x00, 0x00,  //@@@@@@@@@@...............
    0xff, 0xc0, 0x00, 0x00,  //@@@@@@@@@@...............
    0x01, 0xc0, 0x00, 0x00,  //.......@@@...............
    0x01, 0xc0, 0x00, 0x00,  //.......@@@...............
    0x01, 0xc0, 0x00, 0x00,  //.......@@@...............
    0x01, 0xc0, 0x00, 0x00,  //.......@@@...............
    0x01, 0xc0, 0x00, 0x00,  //.......@@@...............
    0x01, 0xc0, 0x00, 0x00,  //.......@@@...............
    0x01, 0xc0, 0x00, 0x00,  //.......@@@...............
    0x01, 0xff, 0xf0, 0x00,  //.......@@@@@@@@@@@@%.....
    0x01, 0xff, 0xfc, 0x00,  //.......@@@@@@@@@@@@@@@...
    0x01, 0xff, 0xfe, 0x00,  //.......@@@@@@@@@@@@@@@@+.
    0x01, 0xc0, 0x1f, 0x00,  //.......@@@........+%@@@@.
    0x01, 0xc0, 0x07, 0x00,  //.......@@@...........@@@+
    0x01, 0xc0, 0x03, 0x80,  //.......@@@...........+@@@
    0x01, 0xc0, 0x03, 0x80,  //.......@@@............@@@
    0x01, 0xc0, 0x03, 0x80,  //.......@@@............@@@
    0x01, 0xc0, 0x03, 0x80,  //.......@@@............@@@
    0x01, 0xc0, 0x03, 0x80,  //.......@@@...........+@@@
    0x01, 0xc0, 0x07, 0x00,  //.......@@@...........@@@+
    0x01, 0xc0, 0x1f, 0x00,  //.......@@@........+%@@@@.
    0x01, 0xff, 0xfe, 0x00,  //.......@@@@@@@@@@@@@@@@+.
    0x01, 0xff, 0xfc, 0x00,  //.......@@@@@@@@@@@@@@@...
    0x01, 0xff, 0xf0, 0x00,  //.......@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+042b (Ы) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xff, 0xf8, 0x0e,  //@@@@@@@@@@@@%.......@@@
    0xff, 0xfe, 0x0e,  //@@@@@@@@@@@@@@@.....@@@
    0xff, 0xff, 0x0e,  //@@@@@@@@@@@@@@@@+...@@@
    0xe0, 0x0f, 0x8e,  //@@@.........%@@@@...@@@
    0xe0, 0x03, 0x8e,  //@@@...........@@@+..@@@
    0xe0, 0x01, 0xce,  //@@@...........+@@@..@@@
    0xe0, 0x01, 0xce,  //@@@............@@@..@@@
    0xe0, 0x01, 0xce,  //@@@............@@@..@@@
    0xe0, 0x01, 0xce,  //@@@............@@@..@@@
    0xe0, 0x01, 0xce,  //@@@...........+@@@..@@@
    0xe0, 0x03, 0x8e,  //@@@...........@@@+..@@@
    0xe0, 0x0f, 0x8e,  //@@@.........%@@@@...@@@
    0xff, 0xff, 0x0e,  //@@@@@@@@@@@@@@@@+...@@@
    0xff, 0xfe, 0x0e,  //@@@@@@@@@@@@@@@.....@@@
    0xff, 0xf8, 0x0e,  //@@@@@@@@@@@@%+......@@@
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+042c (Ь) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xe0, 0x00, 0x00,  //@@@...............
    0xff, 0xf8, 0x00,  //@@@@@@@@@@@@%.....
    0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+.
    0xe0, 0x0f, 0x80,  //@@@.........%@@@@.
    0xe0, 0x03, 0x80,  //@@@...........@@@+
    0xe0, 0x01, 0xc0,  //@@@...........+@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@...........+@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@+
    0xe0, 0x0f, 0x80,  //@@@.........%@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xf8, 0x00,  //@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+042d (Э) , Width: 20 */
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x0f, 0xf0, 0x00,  //...+%@@@@@@%+.......
    0x7f, 0xfc, 0x00,  //.%@@@@@@@@@@@@+.....
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@%....
    0xf8, 0x0f, 0x80,  //@@@@%+.....+@@@@@...
    0xc0, 0x03, 0xc0,  //@@+..........+@@@%..
    0x80, 0x01, 0xc0,  //%..............@@@+.
    0x00, 0x00, 0xe0,  //...............+@@@.
    0x00, 0x00, 0xe0,  //................@@@.
    0x00, 0x00, 0xe0,  //................%@@+
    0x00, 0x00, 0x70,  //.................@@%
    0x00, 0x00, 0x70,  //.................@@@
    0x1f, 0xff, 0xf0,  //...@@@@@@@@@@@@@@@@@
    0x1f, 0xff, 0xf0,  //...@@@@@@@@@@@@@@@@@
    0x1f, 0xff, 0xf0,  //...@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x70,  //.................@@@
    0x00, 0x00, 0x70,  //.................@@%
    0x00, 0x00, 0xe0,  //................%@@+
    0x00, 0x00, 0xe0,  //................@@@.
    0x00, 0x00, 0xe0,  //...............+@@@.
    0x80, 0x01, 0xc0,  //%..............@@@+.
    0xc0, 0x03, 0xc0,  //@@+..........+@@@%..
    0xf8, 0x0f, 0x80,  //@@@@%+.....+@@@@@...
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@%....
    0x7f, 0xfc, 0x00,  //.%@@@@@@@@@@@@+.....
    0x0f, 0xf0, 0x00,  //...+%@@@@@@%+.......
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................


    /*Unicode: U+042e (Ю) , Width: 31 */
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0xe0, 0x00, 0xfe, 0x00,  //@@@............+%@@@@@%+.......
    0xe0, 0x03, 0xff, 0x80,  //@@@..........+@@@@@@@@@@@+.....
    0xe0, 0x0f, 0xff, 0xe0,  //@@@.........@@@@@@@@@@@@@@@....
    0xe0, 0x1f, 0x01, 0xf0,  //@@@........@@@@@+.....+@@@@@...
    0xe0, 0x3e, 0x00, 0xf8,  //@@@.......%@@@%.........+@@@%..
    0xe0, 0x38, 0x00, 0x38,  //@@@......+@@@+...........+@@@+.
    0xe0, 0x78, 0x00, 0x3c,  //@@@......@@@%.............%@@@.
    0xe0, 0x70, 0x00, 0x1c,  //@@@.....+@@@...............@@@.
    0xe0, 0xf0, 0x00, 0x1c,  //@@@.....%@@%...............%@@+
    0xe0, 0xe0, 0x00, 0x0e,  //@@@.....@@@+...............+@@%
    0xe0, 0xe0, 0x00, 0x0e,  //@@@.....@@@.................@@@
    0xff, 0xe0, 0x00, 0x0e,  //@@@@@@@@@@@.................@@@
    0xff, 0xe0, 0x00, 0x0e,  //@@@@@@@@@@@.................@@@
    0xff, 0xe0, 0x00, 0x0e,  //@@@@@@@@@@@.................@@@
    0xe0, 0xe0, 0x00, 0x0e,  //@@@.....@@@.................@@@
    0xe0, 0xe0, 0x00, 0x0e,  //@@@.....@@@+...............+@@%
    0xe0, 0xf0, 0x00, 0x1c,  //@@@.....%@@%...............%@@+
    0xe0, 0x70, 0x00, 0x1c,  //@@@.....+@@@...............@@@.
    0xe0, 0x78, 0x00, 0x3c,  //@@@......@@@%.............%@@@.
    0xe0, 0x38, 0x00, 0x38,  //@@@......+@@@+...........+@@@+.
    0xe0, 0x3e, 0x00, 0x78,  //@@@.......%@@@+.........+@@@%..
    0xe0, 0x1f, 0x01, 0xf0,  //@@@........@@@@@+.....+@@@@@...
    0xe0, 0x0f, 0xff, 0xe0,  //@@@.........@@@@@@@@@@@@@@%....
    0xe0, 0x03, 0xff, 0x80,  //@@@..........+@@@@@@@@@@@+.....
    0xe0, 0x00, 0xfe, 0x00,  //@@@............+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+042f (Я) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x03, 0xff, 0xc0,  //.....+%@@@@@@@@@@@
    0x0f, 0xff, 0xc0,  //...+@@@@@@@@@@@@@@
    0x1f, 0xff, 0xc0,  //..+@@@@@@@@@@@@@@@
    0x3c, 0x01, 0xc0,  //..@@@@+........@@@
    0x78, 0x01, 0xc0,  //.%@@@..........@@@
    0x70, 0x01, 0xc0,  //.@@@+..........@@@
    0x70, 0x01, 0xc0,  //.@@@...........@@@
    0x70, 0x01, 0xc0,  //.@@@...........@@@
    0x70, 0x01, 0xc0,  //.@@@...........@@@
    0x70, 0x01, 0xc0,  //.%@@+..........@@@
    0x38, 0x01, 0xc0,  //.+@@@..........@@@
    0x3c, 0x01, 0xc0,  //..%@@@+........@@@
    0x0f, 0xff, 0xc0,  //...+@@@@@@@@@@@@@@
    0x07, 0xff, 0xc0,  //.....%@@@@@@@@@@@@
    0x01, 0xff, 0xc0,  //......+@@@@@@@@@@@
    0x03, 0xc1, 0xc0,  //......@@@%.....@@@
    0x07, 0x81, 0xc0,  //.....%@@@......@@@
    0x07, 0x01, 0xc0,  //....+@@@+......@@@
    0x0f, 0x01, 0xc0,  //....@@@%.......@@@
    0x1e, 0x01, 0xc0,  //...%@@@........@@@
    0x1c, 0x01, 0xc0,  //...@@@+........@@@
    0x3c, 0x01, 0xc0,  //..@@@%.........@@@
    0x38, 0x01, 0xc0,  //.+@@@..........@@@
    0x70, 0x01, 0xc0,  //.@@@+..........@@@
    0xf0, 0x01, 0xc0,  //%@@@...........@@@
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0430 (а) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x0f, 0xe0,  //....%%@@@@%+....
    0x3f, 0xf8,  //..%@@@@@@@@@@...
    0x7f, 0xfc,  //.@@@@@@@@@@@@@..
    0x70, 0x3e,  //.@@%+.....+@@@@.
    0x40, 0x0e,  //.%..........@@@+
    0x00, 0x07,  //............+@@%
    0x00, 0x07,  //.............@@@
    0x07, 0xff,  //....+%@@@@@@@@@@
    0x3f, 0xff,  //..%@@@@@@@@@@@@@
    0x7f, 0xff,  //.@@@@@@@@@@@@@@@
    0x78, 0x07,  //+@@@%+.......@@@
    0xf0, 0x07,  //@@@%.........@@@
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x0f,  //@@@.........@@@@
    0xe0, 0x1f,  //@@@+.......%@@@@
    0xf8, 0x3f,  //%@@@%....+@@@@@@
    0x7f, 0xff,  //.@@@@@@@@@@@%@@@
    0x3f, 0xf7,  //..@@@@@@@@@+.@@@
    0x0f, 0xc7,  //...+@@@@@%...@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0431 (б) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x7f, 0x00,  //........+%@@@@@@+.
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@%.
    0x0f, 0xff, 0x80,  //....%@@@@@@@@@@@%.
    0x1f, 0x80, 0x00,  //...%@@@@%++.......
    0x1e, 0x00, 0x00,  //..+@@@%...........
    0x38, 0x00, 0x00,  //..@@@+............
    0x30, 0x00, 0x00,  //.+@@+.............
    0x73, 0xf0, 0x00,  //.@@@..%@@@@@+.....
    0x7f, 0xfc, 0x00,  //.@@@%@@@@@@@@@+...
    0x7f, 0xff, 0x00,  //.@@@@@@@@@@@@@@%..
    0x7e, 0x0f, 0x00,  //.@@@@@@+...+@@@@+.
    0x7c, 0x07, 0x80,  //.@@@@%.......%@@@.
    0x78, 0x03, 0x80,  //.@@@@.........@@@+
    0x70, 0x03, 0xc0,  //.@@@+.........+@@%
    0x70, 0x01, 0xc0,  //.@@@...........@@@
    0x70, 0x01, 0xc0,  //.@@@...........@@@
    0x70, 0x01, 0xc0,  //.@@@...........@@@
    0x70, 0x01, 0xc0,  //.@@@...........@@@
    0x70, 0x01, 0xc0,  //.@@@...........@@@
    0x70, 0x01, 0xc0,  //.%@@+.........+@@%
    0x38, 0x03, 0x80,  //.+@@@.........@@@+
    0x3c, 0x07, 0x80,  //..@@@%.......%@@@.
    0x1e, 0x0f, 0x00,  //..+@@@@+...+@@@@+.
    0x1f, 0xff, 0x00,  //...%@@@@@@@@@@@%..
    0x0f, 0xfe, 0x00,  //....%@@@@@@@@@%...
    0x03, 0xf8, 0x00,  //......%@@@@@%.....
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0432 (в) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xff, 0xe0,  //@@@@@@@@@@%....
    0xff, 0xf8,  //@@@@@@@@@@@@%..
    0xff, 0xf8,  //@@@@@@@@@@@@@+.
    0xe0, 0x3c,  //@@@......+@@@@.
    0xe0, 0x1c,  //@@@.......+@@@.
    0xe0, 0x1c,  //@@@........@@@.
    0xe0, 0x1c,  //@@@.......+@@%.
    0xe0, 0x78,  //@@@......%@@@..
    0xff, 0xe0,  //@@@@@@@@@@@+...
    0xff, 0xf0,  //@@@@@@@@@@@@+..
    0xff, 0xfc,  //@@@@@@@@@@@@@%.
    0xe0, 0x1c,  //@@@.......+@@@+
    0xe0, 0x0e,  //@@@........+@@@
    0xe0, 0x0e,  //@@@.........@@@
    0xe0, 0x0e,  //@@@........+@@@
    0xe0, 0x1e,  //@@@.......+@@@%
    0xff, 0xfc,  //@@@@@@@@@@@@@@.
    0xff, 0xf8,  //@@@@@@@@@@@@@..
    0xff, 0xe0,  //@@@@@@@@@@%+...
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+0433 (г) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0434 (д) , Width: 20 */
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x07, 0xff, 0x80,  //.....@@@@@@@@@@@@...
    0x07, 0xff, 0x80,  //.....@@@@@@@@@@@@...
    0x07, 0xff, 0x80,  //.....@@@@@@@@@@@@...
    0x07, 0x03, 0x80,  //.....@@@......@@@...
    0x07, 0x03, 0x80,  //.....@@@......@@@...
    0x07, 0x03, 0x80,  //.....@@@......@@@...
    0x07, 0x03, 0x80,  //.....@@@......@@@...
    0x07, 0x03, 0x80,  //.....@@@......@@@...
    0x07, 0x03, 0x80,  //....+@@@......@@@...
    0x07, 0x03, 0x80,  //....+@@%......@@@...
    0x0f, 0x03, 0x80,  //....%@@%......@@@...
    0x0e, 0x03, 0x80,  //....@@@+......@@@...
    0x0e, 0x03, 0x80,  //....@@@.......@@@...
    0x0e, 0x03, 0x80,  //...+@@@.......@@@...
    0x1c, 0x03, 0x80,  //...@@@+.......@@@...
    0x3c, 0x03, 0x80,  //..@@@@........@@@...
    0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@
    0xe0, 0x00, 0x70,  //@@@..............@@@
    0xe0, 0x00, 0x70,  //@@@..............@@@
    0xe0, 0x00, 0x70,  //@@@..............@@@
    0xe0, 0x00, 0x70,  //@@@..............@@@
    0xe0, 0x00, 0x70,  //@@@..............@@@
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................


    /*Unicode: U+0435 (е) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x03, 0xf0, 0x00,  //.....+%@@@@%+....
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@...
    0x1f, 0xfe, 0x00,  //..+@@@@@@@@@@@@..
    0x3c, 0x0f, 0x00,  //..@@@%+....+@@@@.
    0x70, 0x07, 0x00,  //.@@@+........@@@+
    0x70, 0x03, 0x80,  //+@@%.........+@@%
    0xe0, 0x03, 0x80,  //%@@...........@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xf0, 0x00, 0x00,  //%@@%.............
    0x70, 0x00, 0x00,  //+@@@.............
    0x78, 0x01, 0x00,  //.@@@@..........%.
    0x3e, 0x07, 0x00,  //.+@@@@%.....+@@@.
    0x1f, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x0f, 0xfe, 0x00,  //...+@@@@@@@@@@@+.
    0x03, 0xf8, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0436 (ж) , Width: 29 */
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x7c, 0x07, 0x01, 0xf0,  //.%@@@%.......@@@.......%@@@%.
    0x3e, 0x07, 0x03, 0xe0,  //..%@@@%......@@@......%@@@%..
    0x1e, 0x07, 0x03, 0xc0,  //...%@@@+.....@@@.....+@@@%...
    0x0f, 0x07, 0x07, 0x80,  //....%@@@+....@@@....+@@@%....
    0x07, 0x87, 0x0f, 0x00,  //.....%@@@+...@@@...+@@@%.....
    0x03, 0xc7, 0x1e, 0x00,  //......@@@@+..@@@..+@@@@......
    0x01, 0xe7, 0x3c, 0x00,  //.......@@@@..@@@..@@@@.......
    0x00, 0xf7, 0x78, 0x00,  //.......+@@@@.@@@.@@@@+.......
    0x01, 0xff, 0xfc, 0x00,  //.......@@@@@@@@@@@@@@@.......
    0x03, 0xff, 0xfe, 0x00,  //......%@@@@@@@@@@@@@@@%......
    0x03, 0x9f, 0xce, 0x00,  //.....+@@@+.@@@@@@@.+@@@+.....
    0x07, 0x8f, 0x8f, 0x00,  //.....@@@%...@@@@@...%@@@.....
    0x0f, 0x07, 0x07, 0x80,  //....%@@@....+@@@+....@@@%....
    0x0e, 0x07, 0x03, 0x80,  //...+@@@+.....@@@.....+@@@+...
    0x1e, 0x07, 0x03, 0xc0,  //...@@@%......@@@......%@@@...
    0x3c, 0x07, 0x01, 0xe0,  //..%@@@.......@@@.......@@@%..
    0x38, 0x07, 0x00, 0xe0,  //.+@@@+.......@@@.......+@@@+.
    0x78, 0x07, 0x00, 0xf0,  //.@@@%........@@@........%@@@.
    0xf0, 0x07, 0x00, 0x78,  //%@@@.........@@@.........@@@%
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+0437 (з) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x1f, 0xc0,  //..+%@@@@@%....
    0x7f, 0xe0,  //.@@@@@@@@@@+..
    0x7f, 0xf0,  //.@@@@@@@@@@@+.
    0x60, 0xf8,  //.@%+....%@@@@.
    0x00, 0x38,  //.........+@@@.
    0x00, 0x38,  //..........@@@.
    0x00, 0x38,  //.........+@@%.
    0x00, 0x70,  //........+@@%..
    0x0f, 0xc0,  //....@@@@@@+...
    0x0f, 0xe0,  //....@@@@@@@+..
    0x0f, 0xf8,  //....@@@@@@@@%.
    0x00, 0x7c,  //.........%@@@%
    0x00, 0x1c,  //..........+@@@
    0x00, 0x1c,  //...........@@@
    0x00, 0x1c,  //..........+@@@
    0xc0, 0x7c,  //@++.....+%@@@%
    0xff, 0xf8,  //@@@@@@@@@@@@@.
    0xff, 0xf0,  //@@@@@@@@@@@%..
    0x3f, 0xc0,  //.+%@@@@@%%....
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0438 (и) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xe0, 0x0f,  //@@@.........@@@@
    0xe0, 0x1f,  //@@@........@@@@@
    0xe0, 0x1f,  //@@@.......+@@@@@
    0xe0, 0x3f,  //@@@.......@@@@@@
    0xe0, 0x7f,  //@@@......%@@@@@@
    0xe0, 0x77,  //@@@.....+@@@.@@@
    0xe0, 0xf7,  //@@@.....@@@%.@@@
    0xe1, 0xe7,  //@@@....%@@@..@@@
    0xe1, 0xc7,  //@@@....@@@+..@@@
    0xe3, 0xc7,  //@@@...@@@%...@@@
    0xe3, 0x87,  //@@@..+@@@....@@@
    0xe7, 0x87,  //@@@..@@@%....@@@
    0xef, 0x07,  //@@@.%@@@.....@@@
    0xee, 0x07,  //@@@+@@@+.....@@@
    0xfe, 0x07,  //@@@@@@%......@@@
    0xfc, 0x07,  //@@@@@@.......@@@
    0xf8, 0x07,  //@@@@@+.......@@@
    0xf8, 0x07,  //@@@@@........@@@
    0xf0, 0x07,  //@@@@.........@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0439 (й) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x18, 0x18,  //...@@......@@...
    0x1c, 0x38,  //...%@@....@@%...
    0x0f, 0xf0,  //...+@@@@@@@@+...
    0x0f, 0xf0,  //....%@@@@@@%....
    0x03, 0xc0,  //.....+@@@@+.....
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xe0, 0x0f,  //@@@.........@@@@
    0xe0, 0x1f,  //@@@........@@@@@
    0xe0, 0x1f,  //@@@.......+@@@@@
    0xe0, 0x3f,  //@@@.......@@@@@@
    0xe0, 0x7f,  //@@@......%@@@@@@
    0xe0, 0x77,  //@@@.....+@@@.@@@
    0xe0, 0xf7,  //@@@.....@@@%.@@@
    0xe1, 0xe7,  //@@@....%@@@..@@@
    0xe1, 0xc7,  //@@@....@@@+..@@@
    0xe3, 0xc7,  //@@@...@@@%...@@@
    0xe3, 0x87,  //@@@..+@@@....@@@
    0xe7, 0x87,  //@@@..@@@%....@@@
    0xef, 0x07,  //@@@.%@@@.....@@@
    0xee, 0x07,  //@@@+@@@+.....@@@
    0xfe, 0x07,  //@@@@@@%......@@@
    0xfc, 0x07,  //@@@@@@.......@@@
    0xf8, 0x07,  //@@@@@+.......@@@
    0xf8, 0x07,  //@@@@@........@@@
    0xf0, 0x07,  //@@@@.........@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+043a (к) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xe0, 0x3e,  //@@@.......%@@@%.
    0xe0, 0x7c,  //@@@......%@@@%..
    0xe0, 0x78,  //@@@.....+@@@%...
    0xe0, 0xf0,  //@@@....+@@@%....
    0xe1, 0xe0,  //@@@...+@@@%.....
    0xe3, 0xc0,  //@@@..+@@@@......
    0xe7, 0x80,  //@@@..@@@@.......
    0xef, 0x00,  //@@@.@@@@+.......
    0xff, 0x80,  //@@@@@@@@@.......
    0xff, 0xc0,  //@@@@@@@@@%......
    0xf9, 0xc0,  //@@@@@.+@@@......
    0xf1, 0xe0,  //@@@@...%@@@.....
    0xe0, 0xf0,  //@@@+....@@@%....
    0xe0, 0x70,  //@@@.....+@@@+...
    0xe0, 0x78,  //@@@......%@@@...
    0xe0, 0x3c,  //@@@.......@@@%..
    0xe0, 0x1c,  //@@@.......+@@@+.
    0xe0, 0x1e,  //@@@........%@@@.
    0xe0, 0x0f,  //@@@.........@@@%
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+043b (л) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x07, 0xff, 0xc0,  //.....@@@@@@@@@@@@@
    0x07, 0xff, 0xc0,  //.....@@@@@@@@@@@@@
    0x07, 0xff, 0xc0,  //.....@@@@@@@@@@@@@
    0x07, 0x01, 0xc0,  //.....@@@.......@@@
    0x07, 0x01, 0xc0,  //.....@@@.......@@@
    0x07, 0x01, 0xc0,  //.....@@@.......@@@
    0x07, 0x01, 0xc0,  //.....@@@.......@@@
    0x07, 0x01, 0xc0,  //.....@@@.......@@@
    0x07, 0x01, 0xc0,  //.....@@@.......@@@
    0x07, 0x01, 0xc0,  //....+@@@.......@@@
    0x07, 0x01, 0xc0,  //....+@@%.......@@@
    0x0f, 0x01, 0xc0,  //....%@@%.......@@@
    0x0e, 0x01, 0xc0,  //....@@@+.......@@@
    0x0e, 0x01, 0xc0,  //....@@@........@@@
    0x1e, 0x01, 0xc0,  //...@@@@........@@@
    0x3c, 0x01, 0xc0,  //.+@@@@+........@@@
    0xfc, 0x01, 0xc0,  //@@@@@%.........@@@
    0xf8, 0x01, 0xc0,  //@@@@+..........@@@
    0xc0, 0x01, 0xc0,  //@%+............@@@
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+043c (м) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xf8, 0x03, 0xe0,  //@@@@@.........@@@@@
    0xfc, 0x07, 0xe0,  //@@@@@%.......%@@@@@
    0xfc, 0x07, 0xe0,  //@@@@@@.......@@@@@@
    0xfc, 0x07, 0xe0,  //@@@@@@+.....+@@@@@@
    0xee, 0x0e, 0xe0,  //@@@+@@@.....@@@+@@@
    0xee, 0x0e, 0xe0,  //@@@.@@@+...+@@@.@@@
    0xef, 0x1e, 0xe0,  //@@@.%@@%...%@@%.@@@
    0xe7, 0x1c, 0xe0,  //@@@..@@@...@@@..@@@
    0xe7, 0xbc, 0xe0,  //@@@..%@@%.%@@%..@@@
    0xe3, 0xb8, 0xe0,  //@@@..+@@@.@@@+..@@@
    0xe3, 0xf8, 0xe0,  //@@@...@@@%@@@...@@@
    0xe1, 0xf0, 0xe0,  //@@@...+@@@@@+...@@@
    0xe1, 0xf0, 0xe0,  //@@@....@@@@@....@@@
    0xe1, 0xf0, 0xe0,  //@@@....%@@@%....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+043d (н) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+043e (о) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x3c, 0x1e, 0x00,  //.+@@@@+...+@@@@+.
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x70, 0x07, 0x00,  //+@@@.........@@@+
    0xe0, 0x07, 0x80,  //%@@+.........+@@%
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //%@@+.........+@@%
    0x70, 0x07, 0x00,  //+@@@.........@@@+
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x3c, 0x1e, 0x00,  //.+@@@@+...+@@@@+.
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+043f (п) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0440 (р) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xe3, 0xf0, 0x00,  //@@@...%@@@@%.....
    0xef, 0xfc, 0x00,  //@@@.%@@@@@@@@%...
    0xff, 0xfe, 0x00,  //@@@%@@@@@@@@@@%..
    0xfc, 0x1e, 0x00,  //@@@@@@+...+@@@@+.
    0xf8, 0x0f, 0x00,  //@@@@%.......%@@@.
    0xf0, 0x07, 0x00,  //@@@@.........@@@+
    0xe0, 0x03, 0x80,  //@@@+.........+@@%
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@+.........+@@%
    0xf0, 0x07, 0x00,  //@@@@.........@@@+
    0xf8, 0x0f, 0x00,  //@@@@%.......%@@@.
    0xfc, 0x1e, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0xfe, 0x00,  //@@@%@@@@@@@@@@%..
    0xef, 0xfc, 0x00,  //@@@.%@@@@@@@@%...
    0xe3, 0xf0, 0x00,  //@@@...%@@@@%.....
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0441 (с) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x03, 0xf8,  //.....+%@@@@@%+.
    0x0f, 0xfe,  //....@@@@@@@@@@@
    0x1f, 0xfe,  //..+@@@@@@@@@@@@
    0x3e, 0x06,  //..@@@@%.....+%@
    0x78, 0x00,  //.@@@@..........
    0x70, 0x00,  //+@@@...........
    0xf0, 0x00,  //%@@%...........
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xf0, 0x00,  //%@@%...........
    0x70, 0x00,  //+@@@...........
    0x78, 0x00,  //.@@@@..........
    0x3e, 0x06,  //..@@@@%.....+%@
    0x1f, 0xfe,  //..+@@@@@@@@@@@@
    0x0f, 0xfe,  //....@@@@@@@@@@@
    0x03, 0xf8,  //.....+%@@@@@%+.
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+0442 (т) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0443 (у) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0xe0, 0x01, 0xc0,  //@@@+..........+@@@
    0x70, 0x03, 0x80,  //+@@@..........@@@+
    0x70, 0x03, 0x80,  //.@@@+.........@@@.
    0x78, 0x07, 0x80,  //.%@@%........%@@%.
    0x38, 0x07, 0x00,  //..@@@........@@@..
    0x3c, 0x07, 0x00,  //..%@@%......+@@@..
    0x1c, 0x0e, 0x00,  //..+@@@......@@@+..
    0x1c, 0x0e, 0x00,  //...@@@+.....@@@...
    0x0e, 0x1e, 0x00,  //...+@@@....%@@%...
    0x0e, 0x1c, 0x00,  //....@@@....@@@+...
    0x0f, 0x1c, 0x00,  //....%@@%..+@@@....
    0x07, 0x38, 0x00,  //.....@@@..%@@+....
    0x07, 0x38, 0x00,  //.....@@@+.@@@.....
    0x03, 0xf8, 0x00,  //.....+@@@%@@%.....
    0x03, 0xf0, 0x00,  //......@@@@@@+.....
    0x03, 0xf0, 0x00,  //......%@@@@@......
    0x01, 0xf0, 0x00,  //.......@@@@+......
    0x01, 0xe0, 0x00,  //.......%@@@.......
    0x01, 0xe0, 0x00,  //.......%@@%.......
    0x01, 0xc0, 0x00,  //.......@@@+.......
    0x01, 0xc0, 0x00,  //......+@@@........
    0x03, 0xc0, 0x00,  //......%@@%........
    0x07, 0x80, 0x00,  //.....%@@@.........
    0x3f, 0x80, 0x00,  //..@@@@@@%.........
    0x3f, 0x00, 0x00,  //..@@@@@@..........
    0x3e, 0x00, 0x00,  //..@@@@%...........
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0444 (ф) , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x0f, 0x9c, 0xf8, 0x00,  //....%@@@%..@@@..%@@@%....
    0x1f, 0xdd, 0xfc, 0x00,  //...@@@@@@@.@@@.@@@@@@@...
    0x3f, 0xff, 0xfe, 0x00,  //..@@@@@@@@%@@@%@@@@@@@@..
    0x78, 0x7f, 0x0f, 0x00,  //.%@@@+..+@@@@@@@+..+@@@%.
    0x70, 0x3e, 0x07, 0x00,  //.@@@......@@@@@.....+@@@.
    0x70, 0x1c, 0x07, 0x00,  //+@@%.......@@@.......%@@+
    0xe0, 0x1c, 0x03, 0x80,  //%@@+.......@@@.......+@@%
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //%@@+.......@@@.......+@@%
    0xf0, 0x1c, 0x07, 0x80,  //+@@%.......@@@.......%@@+
    0x70, 0x3e, 0x07, 0x00,  //.@@@......@@@@@.....+@@@.
    0x78, 0x7f, 0x0f, 0x00,  //.%@@@+..+@@@@@@@+..+@@@%.
    0x3f, 0xff, 0xfe, 0x00,  //..@@@@@@@@%@@@%@@@@@@@@..
    0x1f, 0xdd, 0xfc, 0x00,  //...@@@@@@@.@@@.@@@@@@@...
    0x0f, 0x9c, 0xf8, 0x00,  //....%@@@%..@@@..%@@@%....
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x1c, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+0445 (х) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x78, 0x03, 0xc0,  //.%@@@.........@@@%
    0x3c, 0x07, 0x80,  //..@@@@.......@@@@.
    0x1e, 0x0f, 0x00,  //...@@@%.....%@@@..
    0x0e, 0x0e, 0x00,  //...+@@@.....@@@+..
    0x0f, 0x1e, 0x00,  //....%@@@...@@@%...
    0x07, 0xbc, 0x00,  //.....@@@%.%@@@....
    0x03, 0xf8, 0x00,  //.....+@@@%@@@+....
    0x03, 0xf8, 0x00,  //......%@@@@@%.....
    0x01, 0xf0, 0x00,  //.......@@@@@......
    0x01, 0xf0, 0x00,  //.......%@@@%......
    0x03, 0xf0, 0x00,  //......%@@@@@......
    0x03, 0xf8, 0x00,  //.....+@@@@@@@.....
    0x07, 0xbc, 0x00,  //.....@@@%.@@@%....
    0x0f, 0x1c, 0x00,  //....@@@@..+@@@....
    0x1e, 0x1e, 0x00,  //...%@@@....%@@@...
    0x1c, 0x0f, 0x00,  //..+@@@+.....@@@%..
    0x3c, 0x07, 0x00,  //..@@@%......+@@@+.
    0x78, 0x07, 0x80,  //.@@@@........%@@@.
    0xf0, 0x03, 0xc0,  //%@@@..........@@@%
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0446 (ц) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0xe0,  //................@@@
    0x00, 0x00, 0xe0,  //................@@@
    0x00, 0x00, 0xe0,  //................@@@
    0x00, 0x00, 0xe0,  //................@@@
    0x00, 0x00, 0xe0,  //................@@@
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0447 (ч) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xe0, 0x0e,  //@@@.........@@@
    0xe0, 0x0e,  //@@@.........@@@
    0xe0, 0x0e,  //@@@.........@@@
    0xe0, 0x0e,  //@@@.........@@@
    0xe0, 0x0e,  //@@@.........@@@
    0xe0, 0x0e,  //@@@.........@@@
    0xe0, 0x0e,  //@@@.........@@@
    0xf0, 0x0e,  //%@@%........@@@
    0x78, 0x0e,  //+@@@%.......@@@
    0x7f, 0xfe,  //.@@@@@@@@@@@@@@
    0x3f, 0xfe,  //..@@@@@@@@@@@@@
    0x0f, 0xfe,  //...+@@@@@@@@@@@
    0x00, 0x0e,  //............@@@
    0x00, 0x0e,  //............@@@
    0x00, 0x0e,  //............@@@
    0x00, 0x0e,  //............@@@
    0x00, 0x0e,  //............@@@
    0x00, 0x0e,  //............@@@
    0x00, 0x0e,  //............@@@
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+0448 (ш) , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+0449 (щ) , Width: 28 */
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@...
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@...
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@...
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@...
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@...
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@...
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@...
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@...
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@...
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@...
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@...
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@...
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@...
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@...
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@...
    0xe0, 0x1c, 0x03, 0x80,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x70,  //.........................@@@
    0x00, 0x00, 0x00, 0x70,  //.........................@@@
    0x00, 0x00, 0x00, 0x70,  //.........................@@@
    0x00, 0x00, 0x00, 0x70,  //.........................@@@
    0x00, 0x00, 0x00, 0x70,  //.........................@@@
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00,  //............................


    /*Unicode: U+044a (ъ) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0xff, 0x80, 0x00,  //@@@@@@@@@............
    0xff, 0x80, 0x00,  //@@@@@@@@@............
    0xff, 0x80, 0x00,  //@@@@@@@@@............
    0x03, 0x80, 0x00,  //......@@@............
    0x03, 0x80, 0x00,  //......@@@............
    0x03, 0x80, 0x00,  //......@@@............
    0x03, 0x80, 0x00,  //......@@@............
    0x03, 0x80, 0x00,  //......@@@............
    0x03, 0xff, 0x80,  //......@@@@@@@@@@%+...
    0x03, 0xff, 0xe0,  //......@@@@@@@@@@@@@+.
    0x03, 0xff, 0xf0,  //......@@@@@@@@@@@@@@.
    0x03, 0x80, 0x78,  //......@@@.......+@@@%
    0x03, 0x80, 0x38,  //......@@@........+@@@
    0x03, 0x80, 0x38,  //......@@@.........@@@
    0x03, 0x80, 0x38,  //......@@@........+@@@
    0x03, 0x80, 0x78,  //......@@@.......+@@@%
    0x03, 0xff, 0xf0,  //......@@@@@@@@@@@@@@.
    0x03, 0xff, 0xe0,  //......@@@@@@@@@@@@@+.
    0x03, 0xff, 0x80,  //......@@@@@@@@@@%+...
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+044b (ы) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0xe0, 0x00, 0x38,  //@@@...............@@@
    0xe0, 0x00, 0x38,  //@@@...............@@@
    0xe0, 0x00, 0x38,  //@@@...............@@@
    0xe0, 0x00, 0x38,  //@@@...............@@@
    0xe0, 0x00, 0x38,  //@@@...............@@@
    0xe0, 0x00, 0x38,  //@@@...............@@@
    0xe0, 0x00, 0x38,  //@@@...............@@@
    0xe0, 0x00, 0x38,  //@@@...............@@@
    0xff, 0xe0, 0x38,  //@@@@@@@@@@%+......@@@
    0xff, 0xf8, 0x38,  //@@@@@@@@@@@@@+....@@@
    0xff, 0xfc, 0x38,  //@@@@@@@@@@@@@@....@@@
    0xe0, 0x1e, 0x38,  //@@@.......+@@@%...@@@
    0xe0, 0x0e, 0x38,  //@@@........+@@@...@@@
    0xe0, 0x0e, 0x38,  //@@@.........@@@...@@@
    0xe0, 0x0e, 0x38,  //@@@........+@@@...@@@
    0xe0, 0x1e, 0x38,  //@@@.......+@@@%...@@@
    0xff, 0xfc, 0x38,  //@@@@@@@@@@@@@@....@@@
    0xff, 0xf8, 0x38,  //@@@@@@@@@@@@@+....@@@
    0xff, 0xe0, 0x38,  //@@@@@@@@@@%+......@@@
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+044c (ь) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xff, 0xe0,  //@@@@@@@@@@%+...
    0xff, 0xf8,  //@@@@@@@@@@@@@+.
    0xff, 0xfc,  //@@@@@@@@@@@@@@.
    0xe0, 0x1e,  //@@@.......+@@@%
    0xe0, 0x0e,  //@@@........+@@@
    0xe0, 0x0e,  //@@@.........@@@
    0xe0, 0x0e,  //@@@........+@@@
    0xe0, 0x1e,  //@@@.......+@@@%
    0xff, 0xfc,  //@@@@@@@@@@@@@@.
    0xff, 0xf8,  //@@@@@@@@@@@@@+.
    0xff, 0xe0,  //@@@@@@@@@@%+...
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+044d (э) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x3f, 0x80,  //.+%@@@@@%+.....
    0xff, 0xe0,  //@@@@@@@@@@@....
    0xff, 0xf0,  //@@@@@@@@@@@@+..
    0xc0, 0x78,  //@%+.....+@@@@..
    0x00, 0x3c,  //..........+@@@.
    0x00, 0x1c,  //...........%@@+
    0x00, 0x0e,  //............@@%
    0x3f, 0xfe,  //..@@@@@@@@@@@@@
    0x3f, 0xfe,  //..@@@@@@@@@@@@@
    0x3f, 0xfe,  //..@@@@@@@@@@@@@
    0x00, 0x0e,  //............@@@
    0x00, 0x0e,  //............@@@
    0x00, 0x0e,  //...........+@@%
    0x00, 0x1c,  //...........@@@+
    0x00, 0x3c,  //..........@@@@.
    0xc0, 0xf8,  //@%+.....%@@@@..
    0xff, 0xf0,  //@@@@@@@@@@@@+..
    0xff, 0xe0,  //@@@@@@@@@@@+...
    0x3f, 0x80,  //.+%@@@@@%+.....
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+044e (ю) , Width: 24 */
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0xe0, 0x0f, 0xe0,  //@@@.........%@@@@@+.....
    0xe0, 0x3f, 0xf8,  //@@@.......%@@@@@@@@@+...
    0xe0, 0x7f, 0xfc,  //@@@......%@@@@@@@@@@@%..
    0xe0, 0x78, 0x3c,  //@@@.....+@@@@+...+@@@@+.
    0xe0, 0xf0, 0x1e,  //@@@.....@@@%.......%@@@.
    0xe0, 0xe0, 0x0e,  //@@@....+@@@.........@@@+
    0xe1, 0xc0, 0x0f,  //@@@....%@@+.........+@@%
    0xe1, 0xc0, 0x07,  //@@@....@@@...........@@@
    0xff, 0xc0, 0x07,  //@@@@@@@@@@...........@@@
    0xff, 0xc0, 0x07,  //@@@@@@@@@@...........@@@
    0xff, 0xc0, 0x07,  //@@@@@@@@@@...........@@@
    0xe1, 0xc0, 0x07,  //@@@....@@@...........@@@
    0xe1, 0xc0, 0x07,  //@@@....@@@+.........+@@%
    0xe1, 0xe0, 0x0e,  //@@@....%@@@.........@@@+
    0xe0, 0xf0, 0x1e,  //@@@.....@@@%.......%@@@.
    0xe0, 0xf8, 0x3c,  //@@@.....%@@@@+...+@@@@+.
    0xe0, 0x7f, 0xfc,  //@@@......@@@@@@@@@@@@%..
    0xe0, 0x3f, 0xf8,  //@@@.......%@@@@@@@@@%...
    0xe0, 0x0f, 0xe0,  //@@@.........%@@@@@%.....
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................


    /*Unicode: U+044f (я) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x0f, 0xfe,  //....%@@@@@@@@@@
    0x1f, 0xfe,  //..+@@@@@@@@@@@@
    0x3f, 0xfe,  //..@@@@@@@@@@@@@
    0x7c, 0x0e,  //.%@@@%......@@@
    0x70, 0x0e,  //.@@@+.......@@@
    0x70, 0x0e,  //.@@@........@@@
    0x70, 0x0e,  //.@@@........@@@
    0x70, 0x0e,  //.%@@+.......@@@
    0x3c, 0x0e,  //..@@@%......@@@
    0x1f, 0xfe,  //...@@@@@@@@@@@@
    0x07, 0xfe,  //....+@@@@@@@@@@
    0x07, 0xfe,  //.....@@@@@@@@@@
    0x0f, 0x0e,  //....%@@@....@@@
    0x0e, 0x0e,  //...+@@@.....@@@
    0x1e, 0x0e,  //...@@@%.....@@@
    0x3c, 0x0e,  //..%@@@......@@@
    0x38, 0x0e,  //.+@@@.......@@@
    0x78, 0x0e,  //.@@@%.......@@@
    0xf0, 0x0e,  //%@@@........@@@
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............



#elif USE_LV_FONT_DEJAVU_40_CYRILLIC == 2
    /*Unicode: U+0410 (А) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x2f, 0xe0, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x7f, 0xf4, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0xff, 0xfc, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0xfc, 0xfc, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x02, 0xf8, 0xbe, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x03, 0xf4, 0x7f, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x07, 0xf0, 0x3f, 0x40, 0x00,  //......+@@@...@@@+......
    0x00, 0x0b, 0xe0, 0x2f, 0x80, 0x00,  //......%@@%...%@@%......
    0x00, 0x0f, 0xc0, 0x0f, 0xc0, 0x00,  //......@@@.....@@@......
    0x00, 0x1f, 0xc0, 0x0f, 0xd0, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x3f, 0x40, 0x07, 0xf0, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x3f, 0x00, 0x03, 0xf0, 0x00,  //.....@@@.......@@@.....
    0x00, 0xbe, 0x00, 0x02, 0xf8, 0x00,  //....%@@%.......%@@%....
    0x00, 0xfc, 0x00, 0x00, 0xfc, 0x00,  //....@@@.........@@@....
    0x01, 0xfc, 0x00, 0x00, 0xfd, 0x00,  //...+@@@.........@@@+...
    0x02, 0xff, 0xff, 0xff, 0xfe, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x03, 0xff, 0xff, 0xff, 0xff, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x0b, 0xff, 0xff, 0xff, 0xff, 0x80,  //..%@@@@@@@@@@@@@@@@@%..
    0x0f, 0xd0, 0x00, 0x00, 0x1f, 0xc0,  //..@@@+...........+@@@..
    0x1f, 0xc0, 0x00, 0x00, 0x0f, 0xd0,  //.+@@@.............@@@+.
    0x2f, 0x80, 0x00, 0x00, 0x0b, 0xe0,  //.%@@%.............%@@%.
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x7f, 0x00, 0x00, 0x00, 0x03, 0xf4,  //+@@@...............@@@+
    0xfd, 0x00, 0x00, 0x00, 0x01, 0xfc,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0411 (Б) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@..
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x80, 0x00,  //@@@@@@@@@@@@%.....
    0xff, 0xff, 0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+.
    0xfc, 0x00, 0x01, 0xbf, 0xc0,  //@@@.........%@@@@.
    0xfc, 0x00, 0x00, 0x0f, 0xd0,  //@@@...........@@@+
    0xfc, 0x00, 0x00, 0x07, 0xf0,  //@@@...........+@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x07, 0xf0,  //@@@...........+@@@
    0xfc, 0x00, 0x00, 0x0f, 0xe0,  //@@@...........@@@%
    0xfc, 0x00, 0x01, 0xbf, 0xc0,  //@@@.........%@@@@.
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0x90, 0x00,  //@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0412 (В) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0xfe, 0x80, 0x00,  //@@@@@@@@@@@%%.....
    0xff, 0xff, 0xff, 0xf8, 0x00,  //@@@@@@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@..
    0xfc, 0x00, 0x01, 0xff, 0x40,  //@@@........+@@@@+.
    0xfc, 0x00, 0x00, 0x2f, 0xc0,  //@@@..........%@@@.
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@.
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@.
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@.
    0xfc, 0x00, 0x00, 0x2f, 0x80,  //@@@..........%@@%.
    0xfc, 0x00, 0x01, 0xff, 0x00,  //@@@........+@@@@..
    0xff, 0xff, 0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0xff, 0xe0, 0x00,  //@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@%..
    0xfc, 0x00, 0x01, 0xbf, 0x80,  //@@@.........%@@@%.
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@.
    0xfc, 0x00, 0x00, 0x07, 0xe0,  //@@@...........+@@%
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x07, 0xf0,  //@@@...........+@@@
    0xfc, 0x00, 0x00, 0x0f, 0xe0,  //@@@...........@@@%
    0xfc, 0x00, 0x01, 0xbf, 0xc0,  //@@@.........%@@@@.
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0x90, 0x00,  //@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0413 (Г) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0414 (Д) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x0f, 0xff, 0xff, 0xff, 0x00,  //......@@@@@@@@@@@@@@...
    0x00, 0x0f, 0xff, 0xff, 0xff, 0x00,  //......@@@@@@@@@@@@@@...
    0x00, 0x0f, 0xff, 0xff, 0xff, 0x00,  //......@@@@@@@@@@@@@@...
    0x00, 0x0f, 0xc0, 0x00, 0x3f, 0x00,  //......@@@........@@@...
    0x00, 0x0f, 0xc0, 0x00, 0x3f, 0x00,  //......@@@........@@@...
    0x00, 0x0f, 0xc0, 0x00, 0x3f, 0x00,  //......@@@........@@@...
    0x00, 0x0f, 0xc0, 0x00, 0x3f, 0x00,  //......@@@........@@@...
    0x00, 0x0f, 0xc0, 0x00, 0x3f, 0x00,  //......@@@........@@@...
    0x00, 0x0f, 0xc0, 0x00, 0x3f, 0x00,  //......@@@........@@@...
    0x00, 0x0f, 0xc0, 0x00, 0x3f, 0x00,  //......@@@........@@@...
    0x00, 0x0f, 0xc0, 0x00, 0x3f, 0x00,  //......@@@........@@@...
    0x00, 0x1f, 0xc0, 0x00, 0x3f, 0x00,  //.....+@@@........@@@...
    0x00, 0x1f, 0x80, 0x00, 0x3f, 0x00,  //.....+@@%........@@@...
    0x00, 0x2f, 0x80, 0x00, 0x3f, 0x00,  //.....%@@%........@@@...
    0x00, 0x2f, 0x40, 0x00, 0x3f, 0x00,  //.....%@@+........@@@...
    0x00, 0x3f, 0x40, 0x00, 0x3f, 0x00,  //.....@@@+........@@@...
    0x00, 0x3f, 0x00, 0x00, 0x3f, 0x00,  //.....@@@.........@@@...
    0x00, 0x7f, 0x00, 0x00, 0x3f, 0x00,  //....+@@@.........@@@...
    0x00, 0xbe, 0x00, 0x00, 0x3f, 0x00,  //....%@@%.........@@@...
    0x00, 0xfd, 0x00, 0x00, 0x3f, 0x00,  //....@@@+.........@@@...
    0x02, 0xfc, 0x00, 0x00, 0x3f, 0x00,  //...%@@@..........@@@...
    0x0b, 0xf4, 0x00, 0x00, 0x3f, 0x00,  //..%@@@+..........@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0415 (Е) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0416 (Ж) , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x2f, 0xd0, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x1f, 0xe0,  //.%@@@+..........@@@..........+@@@%.
    0x0b, 0xf4, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x7f, 0x80,  //..%@@@+.........@@@.........+@@@%..
    0x02, 0xfd, 0x00, 0x00, 0xfc, 0x00, 0x01, 0xfe, 0x00,  //...%@@@+........@@@........+@@@%...
    0x00, 0xff, 0x00, 0x00, 0xfc, 0x00, 0x03, 0xfc, 0x00,  //....@@@@........@@@........@@@@....
    0x00, 0x3f, 0xc0, 0x00, 0xfc, 0x00, 0x0f, 0xf0, 0x00,  //.....@@@@.......@@@.......@@@@.....
    0x00, 0x0f, 0xf0, 0x00, 0xfc, 0x00, 0x3f, 0xc0, 0x00,  //......@@@@......@@@......@@@@......
    0x00, 0x03, 0xfc, 0x00, 0xfc, 0x00, 0xff, 0x00, 0x00,  //.......@@@@.....@@@.....@@@@.......
    0x00, 0x01, 0xfe, 0x00, 0xfc, 0x02, 0xfd, 0x00, 0x00,  //.......+@@@%....@@@....%@@@+.......
    0x00, 0x00, 0x7f, 0x80, 0xfc, 0x0b, 0xf4, 0x00, 0x00,  //........+@@@%...@@@...%@@@+........
    0x00, 0x00, 0x2f, 0xe0, 0xfc, 0x2f, 0xe0, 0x00, 0x00,  //.........%@@@%..@@@..%@@@%.........
    0x00, 0x00, 0x2f, 0xf4, 0xfc, 0x7f, 0xe0, 0x00, 0x00,  //.........%@@@@+.@@@.+@@@@%.........
    0x00, 0x00, 0x7f, 0xfd, 0xfd, 0xff, 0xf0, 0x00, 0x00,  //.........@@@@@@+@@@+@@@@@@.........
    0x00, 0x00, 0xfe, 0xff, 0xff, 0xfe, 0xfc, 0x00, 0x00,  //........@@@%@@@@@@@@@@@%@@@........
    0x00, 0x02, 0xfc, 0x3f, 0xff, 0xf0, 0xfe, 0x00, 0x00,  //.......%@@@..@@@@@@@@@..@@@%.......
    0x00, 0x03, 0xf4, 0x0f, 0xff, 0xc0, 0x7f, 0x00, 0x00,  //.......@@@+...@@@@@@@...+@@@.......
    0x00, 0x0f, 0xe0, 0x03, 0xff, 0x00, 0x2f, 0xc0, 0x00,  //......@@@%.....@@@@@.....%@@@......
    0x00, 0x1f, 0xc0, 0x01, 0xfd, 0x00, 0x0f, 0xd0, 0x00,  //.....+@@@......+@@@+......@@@+.....
    0x00, 0x3f, 0x40, 0x00, 0xfc, 0x00, 0x07, 0xf0, 0x00,  //.....@@@+.......@@@.......+@@@.....
    0x00, 0xff, 0x00, 0x00, 0xfc, 0x00, 0x03, 0xfc, 0x00,  //....@@@@........@@@........@@@@....
    0x01, 0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfd, 0x00,  //...+@@@.........@@@.........@@@+...
    0x03, 0xf4, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x7f, 0x00,  //...@@@+.........@@@.........+@@@...
    0x0b, 0xf0, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x3f, 0x80,  //..%@@@..........@@@..........@@@%..
    0x1f, 0xc0, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x0f, 0xd0,  //.+@@@...........@@@...........@@@+.
    0x3f, 0x80, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%...........@@@...........%@@@.
    0xbf, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x03, 0xf8,  //%@@@............@@@............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+0417 (З) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x01, 0xbf, 0xf9, 0x00, 0x00,  //...+%@@@@@%+.....
    0x2f, 0xff, 0xff, 0xd0, 0x00,  //.%@@@@@@@@@@@+...
    0xbf, 0xff, 0xff, 0xf4, 0x00,  //%@@@@@@@@@@@@@+..
    0xbf, 0x40, 0x07, 0xfc, 0x00,  //%@@@+.....+@@@@..
    0xb4, 0x00, 0x00, 0xbe, 0x00,  //%@+.........%@@%.
    0x80, 0x00, 0x00, 0x3f, 0x00,  //%............@@@.
    0x00, 0x00, 0x00, 0x3f, 0x00,  //.............@@@.
    0x00, 0x00, 0x00, 0x3f, 0x00,  //.............@@@.
    0x00, 0x00, 0x00, 0xbe, 0x00,  //............%@@%.
    0x00, 0x00, 0x07, 0xfc, 0x00,  //..........+@@@@..
    0x00, 0xff, 0xff, 0xe0, 0x00,  //....@@@@@@@@@%...
    0x00, 0xff, 0xff, 0x40, 0x00,  //....@@@@@@@@+....
    0x00, 0xff, 0xff, 0xe0, 0x00,  //....@@@@@@@@@%...
    0x00, 0x00, 0x06, 0xfd, 0x00,  //..........+%@@@+.
    0x00, 0x00, 0x00, 0x7f, 0x00,  //............+@@@.
    0x00, 0x00, 0x00, 0x1f, 0x80,  //.............+@@%
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x80, 0x00, 0x00, 0x2f, 0x80,  //%............+@@%
    0xf0, 0x00, 0x00, 0x7f, 0x40,  //@@..........+@@@+
    0xfe, 0x40, 0x06, 0xff, 0x00,  //@@@%+.....+%@@@%.
    0xff, 0xff, 0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@@..
    0x7f, 0xff, 0xff, 0xd0, 0x00,  //+@@@@@@@@@@@@+...
    0x01, 0xbf, 0xf9, 0x00, 0x00,  //...+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0418 (И) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xfc, 0x00, 0x00, 0x0b, 0xfc,  //@@@...........%@@@@
    0xfc, 0x00, 0x00, 0x0f, 0xfc,  //@@@...........@@@@@
    0xfc, 0x00, 0x00, 0x2f, 0xfc,  //@@@..........%@@@@@
    0xfc, 0x00, 0x00, 0x7f, 0xfc,  //@@@.........+@@@@@@
    0xfc, 0x00, 0x00, 0xfe, 0xfc,  //@@@.........@@@%@@@
    0xfc, 0x00, 0x01, 0xfc, 0xfc,  //@@@........+@@@.@@@
    0xfc, 0x00, 0x03, 0xf8, 0xfc,  //@@@........@@@+.@@@
    0xfc, 0x00, 0x07, 0xf0, 0xfc,  //@@@.......+@@@..@@@
    0xfc, 0x00, 0x0f, 0xd0, 0xfc,  //@@@.......@@@+..@@@
    0xfc, 0x00, 0x2f, 0xc0, 0xfc,  //@@@......%@@@...@@@
    0xfc, 0x00, 0x3f, 0x40, 0xfc,  //@@@......@@@+...@@@
    0xfc, 0x00, 0xbf, 0x00, 0xfc,  //@@@.....%@@%....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x02, 0xf8, 0x00, 0xfc,  //@@@....%@@%.....@@@
    0xfc, 0x07, 0xf0, 0x00, 0xfc,  //@@@...+@@@......@@@
    0xfc, 0x0f, 0xe0, 0x00, 0xfc,  //@@@...@@@%......@@@
    0xfc, 0x1f, 0xc0, 0x00, 0xfc,  //@@@..+@@@.......@@@
    0xfc, 0x3f, 0x40, 0x00, 0xfc,  //@@@..@@@+.......@@@
    0xfc, 0x7f, 0x00, 0x00, 0xfc,  //@@@.+@@@........@@@
    0xfc, 0xfd, 0x00, 0x00, 0xfc,  //@@@.@@@+........@@@
    0xfe, 0xfc, 0x00, 0x00, 0xfc,  //@@@%@@@.........@@@
    0xff, 0xf4, 0x00, 0x00, 0xfc,  //@@@@@@+.........@@@
    0xff, 0xe0, 0x00, 0x00, 0xfc,  //@@@@@%..........@@@
    0xff, 0xc0, 0x00, 0x00, 0xfc,  //@@@@@...........@@@
    0xff, 0x80, 0x00, 0x00, 0xfc,  //@@@@%...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0419 (Й) , Width: 19 */
    0x00, 0x3c, 0x00, 0xf0, 0x00,  //.....@@.....@@.....
    0x00, 0x2e, 0x02, 0xe0, 0x00,  //.....%@%...%@%.....
    0x00, 0x0f, 0xff, 0xc0, 0x00,  //......@@@@@@@......
    0x00, 0x02, 0xfe, 0x00, 0x00,  //.......%@@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xfc, 0x00, 0x00, 0x0b, 0xfc,  //@@@...........%@@@@
    0xfc, 0x00, 0x00, 0x0f, 0xfc,  //@@@...........@@@@@
    0xfc, 0x00, 0x00, 0x2f, 0xfc,  //@@@..........%@@@@@
    0xfc, 0x00, 0x00, 0x7f, 0xfc,  //@@@.........+@@@@@@
    0xfc, 0x00, 0x00, 0xfe, 0xfc,  //@@@.........@@@%@@@
    0xfc, 0x00, 0x01, 0xfc, 0xfc,  //@@@........+@@@.@@@
    0xfc, 0x00, 0x03, 0xf8, 0xfc,  //@@@........@@@+.@@@
    0xfc, 0x00, 0x07, 0xf0, 0xfc,  //@@@.......+@@@..@@@
    0xfc, 0x00, 0x0f, 0xd0, 0xfc,  //@@@.......@@@+..@@@
    0xfc, 0x00, 0x2f, 0xc0, 0xfc,  //@@@......%@@@...@@@
    0xfc, 0x00, 0x3f, 0x40, 0xfc,  //@@@......@@@+...@@@
    0xfc, 0x00, 0xbf, 0x00, 0xfc,  //@@@.....%@@%....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x02, 0xf8, 0x00, 0xfc,  //@@@....%@@%.....@@@
    0xfc, 0x07, 0xf0, 0x00, 0xfc,  //@@@...+@@@......@@@
    0xfc, 0x0f, 0xe0, 0x00, 0xfc,  //@@@...@@@%......@@@
    0xfc, 0x1f, 0xc0, 0x00, 0xfc,  //@@@..+@@@.......@@@
    0xfc, 0x3f, 0x40, 0x00, 0xfc,  //@@@..@@@+.......@@@
    0xfc, 0x7f, 0x00, 0x00, 0xfc,  //@@@.+@@@........@@@
    0xfc, 0xfd, 0x00, 0x00, 0xfc,  //@@@.@@@+........@@@
    0xfe, 0xfc, 0x00, 0x00, 0xfc,  //@@@%@@@.........@@@
    0xff, 0xf4, 0x00, 0x00, 0xfc,  //@@@@@@+.........@@@
    0xff, 0xe0, 0x00, 0x00, 0xfc,  //@@@@@%..........@@@
    0xff, 0xc0, 0x00, 0x00, 0xfc,  //@@@@@...........@@@
    0xff, 0x80, 0x00, 0x00, 0xfc,  //@@@@%...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+041a (К) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0xfc, 0x00, 0x00, 0x0b, 0xf8,  //@@@...........%@@@%.
    0xfc, 0x00, 0x00, 0x2f, 0xe0,  //@@@..........%@@@%..
    0xfc, 0x00, 0x00, 0xbf, 0x80,  //@@@.........%@@@%...
    0xfc, 0x00, 0x01, 0xfe, 0x00,  //@@@........+@@@%....
    0xfc, 0x00, 0x07, 0xf8, 0x00,  //@@@.......+@@@%.....
    0xfc, 0x00, 0x1f, 0xe0, 0x00,  //@@@......+@@@%......
    0xfc, 0x00, 0x7f, 0xc0, 0x00,  //@@@.....+@@@@.......
    0xfc, 0x01, 0xff, 0x00, 0x00,  //@@@....+@@@@........
    0xfc, 0x07, 0xfc, 0x00, 0x00,  //@@@...+@@@@.........
    0xfc, 0x0f, 0xf0, 0x00, 0x00,  //@@@...@@@@..........
    0xfc, 0x3f, 0xf0, 0x00, 0x00,  //@@@..@@@@@..........
    0xfc, 0xff, 0xf8, 0x00, 0x00,  //@@@.@@@@@@%.........
    0xff, 0xfd, 0xfd, 0x00, 0x00,  //@@@@@@@+@@@+........
    0xff, 0xf0, 0xbf, 0x00, 0x00,  //@@@@@@..%@@@........
    0xff, 0xc0, 0x3f, 0xc0, 0x00,  //@@@@@....@@@@.......
    0xff, 0x40, 0x0f, 0xd0, 0x00,  //@@@@+.....@@@+......
    0xfd, 0x00, 0x0b, 0xf0, 0x00,  //@@@+......+@@@......
    0xfc, 0x00, 0x03, 0xfc, 0x00,  //@@@........@@@@.....
    0xfc, 0x00, 0x00, 0xfe, 0x00,  //@@@.........@@@%....
    0xfc, 0x00, 0x00, 0x7f, 0x00,  //@@@.........+@@@....
    0xfc, 0x00, 0x00, 0x2f, 0xc0,  //@@@..........%@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xe0,  //@@@...........@@@%..
    0xfc, 0x00, 0x00, 0x07, 0xf4,  //@@@...........+@@@+.
    0xfc, 0x00, 0x00, 0x02, 0xfc,  //@@@............%@@@.
    0xfc, 0x00, 0x00, 0x00, 0xfe,  //@@@.............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+041b (Л) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xc0,  //......@@@@@@@@@@@@@@@
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xc0,  //......@@@@@@@@@@@@@@@
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xc0,  //......@@@@@@@@@@@@@@@
    0x00, 0x0f, 0xc0, 0x00, 0x0f, 0xc0,  //......@@@.........@@@
    0x00, 0x0f, 0xc0, 0x00, 0x0f, 0xc0,  //......@@@.........@@@
    0x00, 0x0f, 0xc0, 0x00, 0x0f, 0xc0,  //......@@@.........@@@
    0x00, 0x0f, 0xc0, 0x00, 0x0f, 0xc0,  //......@@@.........@@@
    0x00, 0x0f, 0xc0, 0x00, 0x0f, 0xc0,  //......@@@.........@@@
    0x00, 0x0f, 0xc0, 0x00, 0x0f, 0xc0,  //......@@@.........@@@
    0x00, 0x0f, 0xc0, 0x00, 0x0f, 0xc0,  //......@@@.........@@@
    0x00, 0x0f, 0xc0, 0x00, 0x0f, 0xc0,  //......@@@.........@@@
    0x00, 0x0f, 0xc0, 0x00, 0x0f, 0xc0,  //......@@@.........@@@
    0x00, 0x1f, 0xc0, 0x00, 0x0f, 0xc0,  //.....+@@%.........@@@
    0x00, 0x1f, 0x80, 0x00, 0x0f, 0xc0,  //.....+@@%.........@@@
    0x00, 0x2f, 0x80, 0x00, 0x0f, 0xc0,  //.....%@@%.........@@@
    0x00, 0x2f, 0x40, 0x00, 0x0f, 0xc0,  //.....%@@+.........@@@
    0x00, 0x3f, 0x00, 0x00, 0x0f, 0xc0,  //.....@@@..........@@@
    0x00, 0x3f, 0x00, 0x00, 0x0f, 0xc0,  //.....@@@..........@@@
    0x00, 0x7f, 0x00, 0x00, 0x0f, 0xc0,  //....+@@@..........@@@
    0x00, 0xfd, 0x00, 0x00, 0x0f, 0xc0,  //....@@@+..........@@@
    0x03, 0xfc, 0x00, 0x00, 0x0f, 0xc0,  //...@@@@...........@@@
    0x1f, 0xf4, 0x00, 0x00, 0x0f, 0xc0,  //.+@@@@+...........@@@
    0xff, 0xe0, 0x00, 0x00, 0x0f, 0xc0,  //@@@@@%............@@@
    0xff, 0x40, 0x00, 0x00, 0x0f, 0xc0,  //@@@@+.............@@@
    0xe4, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //@%+...............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+041c (М) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xff, 0xc0, 0x00, 0x00, 0x0f, 0xfc,  //@@@@@.............@@@@@
    0xff, 0xe0, 0x00, 0x00, 0x2f, 0xfc,  //@@@@@%...........%@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x3f, 0xfc,  //@@@@@@...........@@@@@@
    0xff, 0xf4, 0x00, 0x00, 0x7f, 0xfc,  //@@@@@@+.........+@@@@@@
    0xfd, 0xfc, 0x00, 0x00, 0xfd, 0xfc,  //@@@+@@@.........@@@+@@@
    0xfc, 0xfc, 0x00, 0x00, 0xfc, 0xfc,  //@@@.@@@.........@@@.@@@
    0xfc, 0xbe, 0x00, 0x02, 0xf8, 0xfc,  //@@@.%@@%.......%@@%.@@@
    0xfc, 0x3f, 0x00, 0x03, 0xf0, 0xfc,  //@@@..@@@.......@@@..@@@
    0xfc, 0x3f, 0x40, 0x07, 0xf0, 0xfc,  //@@@..@@@+.....+@@@..@@@
    0xfc, 0x1f, 0xc0, 0x0f, 0xd0, 0xfc,  //@@@..+@@@.....@@@+..@@@
    0xfc, 0x0f, 0xc0, 0x0f, 0xc0, 0xfc,  //@@@...@@@.....@@@...@@@
    0xfc, 0x0b, 0xe0, 0x2f, 0x80, 0xfc,  //@@@...%@@%...%@@%...@@@
    0xfc, 0x03, 0xf0, 0x3f, 0x00, 0xfc,  //@@@....@@@...@@@....@@@
    0xfc, 0x03, 0xf4, 0x7f, 0x00, 0xfc,  //@@@....@@@+.+@@@....@@@
    0xfc, 0x01, 0xfc, 0xfd, 0x00, 0xfc,  //@@@....+@@@.@@@+....@@@
    0xfc, 0x00, 0xfd, 0xfc, 0x00, 0xfc,  //@@@.....@@@+@@@.....@@@
    0xfc, 0x00, 0xbf, 0xf8, 0x00, 0xfc,  //@@@.....%@@@@@%.....@@@
    0xfc, 0x00, 0x7f, 0xf4, 0x00, 0xfc,  //@@@......@@@@@......@@@
    0xfc, 0x00, 0x3f, 0xf0, 0x00, 0xfc,  //@@@......@@@@@......@@@
    0xfc, 0x00, 0x1f, 0xd0, 0x00, 0xfc,  //@@@......+@@@+......@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+041d (Н) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+041e (О) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....%@@@@@@@@@@@@@@....
    0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //...@@@@@+.....+@@@@@...
    0x0b, 0xf8, 0x00, 0x00, 0xbf, 0x80,  //..%@@@%.........+@@@%..
    0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //.+@@@+...........+@@@+.
    0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%.............%@@@.
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x7e, 0x00, 0x00, 0x00, 0x02, 0xf4,  //+@@%...............%@@+
    0xbd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //%@@+...............+@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xbd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //%@@+...............+@@%
    0x7e, 0x00, 0x00, 0x00, 0x02, 0xf4,  //+@@%...............%@@+
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%.............%@@@.
    0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //.+@@@+...........+@@@+.
    0x0b, 0xf8, 0x00, 0x00, 0x7f, 0x80,  //..%@@@+.........+@@@%..
    0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+041f (П) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0420 (Р) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xf9, 0x00,  //@@@@@@@@@@%+....
    0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@@+.
    0xfc, 0x00, 0x0b, 0xfc,  //@@@.......%@@@@.
    0xfc, 0x00, 0x00, 0xfe,  //@@@.........@@@%
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfc, 0x00, 0x00, 0xfe,  //@@@.........@@@%
    0xfc, 0x00, 0x0b, 0xfc,  //@@@.......%@@@@.
    0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xf9, 0x00,  //@@@@@@@@@@%+....
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0421 (С) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x01, 0xbf, 0xfe, 0x40,  //.......+%@@@@@@%+...
    0x00, 0x1f, 0xff, 0xff, 0xf8,  //.....+@@@@@@@@@@@@%.
    0x00, 0xbf, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x03, 0xff, 0x90, 0x06, 0xff,  //...@@@@@%+....+%@@@@
    0x0b, 0xf8, 0x00, 0x00, 0x1f,  //..%@@@+..........+@@
    0x1f, 0xd0, 0x00, 0x00, 0x02,  //.+@@@+.............%
    0x3f, 0x80, 0x00, 0x00, 0x00,  //.@@@%...............
    0x3f, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x7e, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0xbd, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xbd, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0x7e, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0x3f, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x3f, 0x80, 0x00, 0x00, 0x00,  //.@@@%...............
    0x1f, 0xd0, 0x00, 0x00, 0x02,  //.+@@@+.............%
    0x0b, 0xf4, 0x00, 0x00, 0x1f,  //..%@@@+..........+@@
    0x03, 0xff, 0x90, 0x06, 0xff,  //...@@@@@%+....+%@@@@
    0x00, 0xbf, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x00, 0x1f, 0xff, 0xff, 0xf8,  //.....+@@@@@@@@@@@@%.
    0x00, 0x01, 0xbf, 0xfe, 0x40,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+0422 (Т) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0423 (У) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0xfd, 0x00, 0x00, 0x00, 0x7f,  //@@@+............+@@@
    0x7f, 0x00, 0x00, 0x00, 0xfd,  //+@@@............@@@+
    0x3f, 0x40, 0x00, 0x01, 0xfc,  //.@@@+..........+@@@.
    0x1f, 0xc0, 0x00, 0x02, 0xf8,  //.+@@@..........%@@%.
    0x0f, 0xd0, 0x00, 0x03, 0xf0,  //..@@@..........@@@..
    0x0b, 0xe0, 0x00, 0x0b, 0xe0,  //..%@@%........%@@%..
    0x03, 0xf0, 0x00, 0x0f, 0xc0,  //...@@@........@@@...
    0x02, 0xf8, 0x00, 0x1f, 0xc0,  //...%@@%......+@@@...
    0x00, 0xfc, 0x00, 0x3f, 0x40,  //....@@@......@@@+...
    0x00, 0xfd, 0x00, 0x7f, 0x00,  //....@@@+....+@@@....
    0x00, 0x7f, 0x00, 0xbe, 0x00,  //....+@@@....%@@%....
    0x00, 0x3f, 0x40, 0xfc, 0x00,  //.....@@@+...@@@.....
    0x00, 0x1f, 0xc2, 0xf8, 0x00,  //.....+@@@..%@@%.....
    0x00, 0x0f, 0xc3, 0xf4, 0x00,  //......@@@..@@@+.....
    0x00, 0x0b, 0xe7, 0xf0, 0x00,  //......%@@%+@@@......
    0x00, 0x03, 0xff, 0xd0, 0x00,  //.......@@@@@@+......
    0x00, 0x02, 0xff, 0xc0, 0x00,  //.......%@@@@@.......
    0x00, 0x01, 0xff, 0x80, 0x00,  //.......+@@@@%.......
    0x00, 0x00, 0xff, 0x00, 0x00,  //........@@@@........
    0x00, 0x00, 0xfe, 0x00, 0x00,  //........@@@%........
    0x00, 0x01, 0xfd, 0x00, 0x00,  //.......+@@@+........
    0x00, 0x07, 0xfc, 0x00, 0x00,  //......+@@@@.........
    0x03, 0xff, 0xf4, 0x00, 0x00,  //...@@@@@@@+.........
    0x03, 0xff, 0xe0, 0x00, 0x00,  //...@@@@@@%..........
    0x03, 0xfe, 0x40, 0x00, 0x00,  //...@@@@%+...........
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+0424 (Ф) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x01, 0xbf, 0xff, 0x90, 0x00, 0x00,  //.......+%@@@@@@@%+.......
    0x00, 0x2f, 0xff, 0xff, 0xfe, 0x00, 0x00,  //.....%@@@@@@@@@@@@@%.....
    0x02, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@@@@@@@@@%...
    0x0b, 0xfe, 0x43, 0xf0, 0x6f, 0xf8, 0x00,  //..%@@@@%+..@@@..+%@@@@%..
    0x1f, 0xf0, 0x03, 0xf0, 0x03, 0xfd, 0x00,  //.+@@@@.....@@@.....%@@@+.
    0x3f, 0x80, 0x03, 0xf0, 0x00, 0xbf, 0x00,  //.@@@%......@@@......%@@@.
    0x7f, 0x00, 0x03, 0xf0, 0x00, 0x3f, 0x40,  //+@@@.......@@@.......@@@+
    0xbd, 0x00, 0x03, 0xf0, 0x00, 0x1f, 0x80,  //%@@+.......@@@.......+@@%
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xbd, 0x00, 0x03, 0xf0, 0x00, 0x1f, 0x80,  //%@@+.......@@@.......+@@%
    0x7e, 0x00, 0x03, 0xf0, 0x00, 0x2f, 0x40,  //+@@%.......@@@.......%@@+
    0x3f, 0x40, 0x03, 0xf0, 0x00, 0x7f, 0x00,  //.@@@+......@@@......+@@@.
    0x1f, 0xd0, 0x03, 0xf0, 0x01, 0xfd, 0x00,  //.+@@@+.....@@@.....+@@@+.
    0x0b, 0xfd, 0x03, 0xf0, 0x1f, 0xf8, 0x00,  //..%@@@@+...@@@...+@@@@%..
    0x02, 0xff, 0xfb, 0xfb, 0xff, 0xe0, 0x00,  //...%@@@@@@%@@@%@@@@@@%...
    0x00, 0x2f, 0xff, 0xff, 0xfe, 0x00, 0x00,  //.....%@@@@@@@@@@@@@%.....
    0x00, 0x01, 0xbf, 0xff, 0x90, 0x00, 0x00,  //.......+%@@@@@@@%+.......
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+0425 (Х) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x2f, 0xc0, 0x00, 0x00, 0xfe, 0x00,  //.%@@@...........@@@%.
    0x0f, 0xe0, 0x00, 0x02, 0xfc, 0x00,  //..@@@%.........%@@@..
    0x07, 0xf0, 0x00, 0x03, 0xf4, 0x00,  //..+@@@.........@@@+..
    0x02, 0xfc, 0x00, 0x0f, 0xe0, 0x00,  //...%@@@.......@@@%...
    0x00, 0xfe, 0x00, 0x2f, 0xc0, 0x00,  //....@@@%.....%@@@....
    0x00, 0x7f, 0x00, 0x3f, 0x40, 0x00,  //....+@@@.....@@@+....
    0x00, 0x2f, 0xc0, 0xfe, 0x00, 0x00,  //.....%@@@...@@@%.....
    0x00, 0x0f, 0xe2, 0xfc, 0x00, 0x00,  //......@@@%.%@@@......
    0x00, 0x07, 0xf7, 0xf4, 0x00, 0x00,  //......+@@@+@@@+......
    0x00, 0x03, 0xff, 0xf0, 0x00, 0x00,  //.......@@@@@@%.......
    0x00, 0x00, 0xff, 0xc0, 0x00, 0x00,  //........@@@@@........
    0x00, 0x00, 0xbf, 0x40, 0x00, 0x00,  //........%@@@+........
    0x00, 0x00, 0xff, 0xc0, 0x00, 0x00,  //........@@@@@........
    0x00, 0x01, 0xff, 0xd0, 0x00, 0x00,  //.......+@@@@@+.......
    0x00, 0x03, 0xff, 0xf0, 0x00, 0x00,  //.......@@@@@@@.......
    0x00, 0x0f, 0xf3, 0xfc, 0x00, 0x00,  //......@@@@.@@@%......
    0x00, 0x1f, 0xc0, 0xfd, 0x00, 0x00,  //.....+@@@...@@@+.....
    0x00, 0x3f, 0x40, 0xbf, 0x00, 0x00,  //.....@@@+...%@@@.....
    0x00, 0xbf, 0x00, 0x3f, 0x80, 0x00,  //....%@@@.....@@@%....
    0x01, 0xfc, 0x00, 0x0f, 0xd0, 0x00,  //...+@@@.......@@@+...
    0x03, 0xf8, 0x00, 0x0b, 0xf0, 0x00,  //...@@@%.......%@@@...
    0x0b, 0xf0, 0x00, 0x03, 0xf8, 0x00,  //..%@@@.........@@@%..
    0x1f, 0xc0, 0x00, 0x01, 0xfd, 0x00,  //.+@@@..........+@@@+.
    0x3f, 0x80, 0x00, 0x00, 0xbf, 0x00,  //.@@@%...........%@@@.
    0xbf, 0x00, 0x00, 0x00, 0x3f, 0x80,  //%@@@.............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0426 (Ц) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //...................@@@
    0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //...................@@@
    0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //...................@@@
    0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //...................@@@
    0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+0427 (Ч) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xbd, 0x00, 0x00, 0x0f, 0xc0,  //%@@+..........@@@
    0xbf, 0x00, 0x00, 0x0f, 0xc0,  //+@@@..........@@@
    0x3f, 0xd0, 0x00, 0x0f, 0xc0,  //.@@@@+........@@@
    0x2f, 0xff, 0xff, 0xff, 0xc0,  //.+@@@@@@@@@@@@@@@
    0x0b, 0xff, 0xff, 0xff, 0xc0,  //..%@@@@@@@@@@@@@@
    0x00, 0xbf, 0xff, 0xff, 0xc0,  //....%@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0428 (Ш) , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+0429 (Щ) , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xfc, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0xfc, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //...............................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //...............................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //...............................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //...............................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0,  //...............................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+042a (Ъ) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@...............
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@...............
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@...............
    0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x03, 0xff, 0xff, 0xfe, 0x00, 0x00,  //.......@@@@@@@@@@@@%.....
    0x00, 0x03, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.......@@@@@@@@@@@@@@@...
    0x00, 0x03, 0xff, 0xff, 0xff, 0xfd, 0x00,  //.......@@@@@@@@@@@@@@@@+.
    0x00, 0x03, 0xf0, 0x00, 0x06, 0xff, 0x00,  //.......@@@........+%@@@@.
    0x00, 0x03, 0xf0, 0x00, 0x00, 0x3f, 0x40,  //.......@@@...........@@@+
    0x00, 0x03, 0xf0, 0x00, 0x00, 0x1f, 0xc0,  //.......@@@...........+@@@
    0x00, 0x03, 0xf0, 0x00, 0x00, 0x0f, 0xc0,  //.......@@@............@@@
    0x00, 0x03, 0xf0, 0x00, 0x00, 0x0f, 0xc0,  //.......@@@............@@@
    0x00, 0x03, 0xf0, 0x00, 0x00, 0x0f, 0xc0,  //.......@@@............@@@
    0x00, 0x03, 0xf0, 0x00, 0x00, 0x1f, 0xc0,  //.......@@@...........+@@@
    0x00, 0x03, 0xf0, 0x00, 0x00, 0x3f, 0x40,  //.......@@@...........@@@+
    0x00, 0x03, 0xf0, 0x00, 0x06, 0xff, 0x00,  //.......@@@........+%@@@@.
    0x00, 0x03, 0xff, 0xff, 0xff, 0xfd, 0x00,  //.......@@@@@@@@@@@@@@@@+.
    0x00, 0x03, 0xff, 0xff, 0xff, 0xf4, 0x00,  //.......@@@@@@@@@@@@@@@...
    0x00, 0x03, 0xff, 0xff, 0xfe, 0x40, 0x00,  //.......@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+042b (Ы) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x80, 0x00, 0xfc,  //@@@@@@@@@@@@%.......@@@
    0xff, 0xff, 0xff, 0xfc, 0x00, 0xfc,  //@@@@@@@@@@@@@@@.....@@@
    0xff, 0xff, 0xff, 0xff, 0x40, 0xfc,  //@@@@@@@@@@@@@@@@+...@@@
    0xfc, 0x00, 0x01, 0xbf, 0xc0, 0xfc,  //@@@.........%@@@@...@@@
    0xfc, 0x00, 0x00, 0x0f, 0xd0, 0xfc,  //@@@...........@@@+..@@@
    0xfc, 0x00, 0x00, 0x07, 0xf0, 0xfc,  //@@@...........+@@@..@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0, 0xfc,  //@@@............@@@..@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0, 0xfc,  //@@@............@@@..@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0, 0xfc,  //@@@............@@@..@@@
    0xfc, 0x00, 0x00, 0x07, 0xf0, 0xfc,  //@@@...........+@@@..@@@
    0xfc, 0x00, 0x00, 0x0f, 0xd0, 0xfc,  //@@@...........@@@+..@@@
    0xfc, 0x00, 0x01, 0xbf, 0xc0, 0xfc,  //@@@.........%@@@@...@@@
    0xff, 0xff, 0xff, 0xff, 0x40, 0xfc,  //@@@@@@@@@@@@@@@@+...@@@
    0xff, 0xff, 0xff, 0xfd, 0x00, 0xfc,  //@@@@@@@@@@@@@@@.....@@@
    0xff, 0xff, 0xff, 0x90, 0x00, 0xfc,  //@@@@@@@@@@@@%+......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+042c (Ь) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x80, 0x00,  //@@@@@@@@@@@@%.....
    0xff, 0xff, 0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+.
    0xfc, 0x00, 0x01, 0xbf, 0xc0,  //@@@.........%@@@@.
    0xfc, 0x00, 0x00, 0x0f, 0xd0,  //@@@...........@@@+
    0xfc, 0x00, 0x00, 0x07, 0xf0,  //@@@...........+@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x07, 0xf0,  //@@@...........+@@@
    0xfc, 0x00, 0x00, 0x0f, 0xd0,  //@@@...........@@@+
    0xfc, 0x00, 0x01, 0xbf, 0xc0,  //@@@.........%@@@@.
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0xff, 0x90, 0x00,  //@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+042d (Э) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x01, 0xbf, 0xfe, 0x40, 0x00,  //...+%@@@@@@%+.......
    0x2f, 0xff, 0xff, 0xf4, 0x00,  //.%@@@@@@@@@@@@+.....
    0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@%....
    0xff, 0x90, 0x01, 0xff, 0xc0,  //@@@@%+.....+@@@@@...
    0xf4, 0x00, 0x00, 0x1f, 0xe0,  //@@+..........+@@@%..
    0x80, 0x00, 0x00, 0x03, 0xf4,  //%..............@@@+.
    0x00, 0x00, 0x00, 0x01, 0xfc,  //...............+@@@.
    0x00, 0x00, 0x00, 0x00, 0xfc,  //................@@@.
    0x00, 0x00, 0x00, 0x00, 0xbd,  //................%@@+
    0x00, 0x00, 0x00, 0x00, 0x7e,  //.................@@%
    0x00, 0x00, 0x00, 0x00, 0x3f,  //.................@@@
    0x03, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@@@@@@@@@@@@
    0x03, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@@@@@@@@@@@@
    0x03, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x3f,  //.................@@@
    0x00, 0x00, 0x00, 0x00, 0x7e,  //.................@@%
    0x00, 0x00, 0x00, 0x00, 0xbd,  //................%@@+
    0x00, 0x00, 0x00, 0x00, 0xfc,  //................@@@.
    0x00, 0x00, 0x00, 0x01, 0xfc,  //...............+@@@.
    0x80, 0x00, 0x00, 0x03, 0xf4,  //%..............@@@+.
    0xf4, 0x00, 0x00, 0x1f, 0xe0,  //@@+..........+@@@%..
    0xff, 0x90, 0x01, 0xff, 0xc0,  //@@@@%+.....+@@@@@...
    0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@%....
    0x2f, 0xff, 0xff, 0xf4, 0x00,  //.%@@@@@@@@@@@@+.....
    0x01, 0xbf, 0xfe, 0x40, 0x00,  //...+%@@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+042e (Ю) , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0xfc, 0x00, 0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //@@@............+%@@@@@%+.......
    0xfc, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //@@@..........+@@@@@@@@@@@+.....
    0xfc, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //@@@.........@@@@@@@@@@@@@@@....
    0xfc, 0x00, 0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //@@@........@@@@@+.....+@@@@@...
    0xfc, 0x00, 0x0b, 0xf8, 0x00, 0x00, 0xbf, 0x80,  //@@@.......%@@@%.........+@@@%..
    0xfc, 0x00, 0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //@@@......+@@@+...........+@@@+.
    0xfc, 0x00, 0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //@@@......@@@%.............%@@@.
    0xfc, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@.....+@@@...............@@@.
    0xfc, 0x00, 0xbe, 0x00, 0x00, 0x00, 0x02, 0xf4,  //@@@.....%@@%...............%@@+
    0xfc, 0x00, 0xfd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //@@@.....@@@+...............+@@%
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.....@@@.................@@@
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@@@@@@@@@.................@@@
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@@@@@@@@@.................@@@
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@@@@@@@@@.................@@@
    0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.....@@@.................@@@
    0xfc, 0x00, 0xfd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //@@@.....@@@+...............+@@%
    0xfc, 0x00, 0xbe, 0x00, 0x00, 0x00, 0x02, 0xf4,  //@@@.....%@@%...............%@@+
    0xfc, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@.....+@@@...............@@@.
    0xfc, 0x00, 0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //@@@......@@@%.............%@@@.
    0xfc, 0x00, 0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //@@@......+@@@+...........+@@@+.
    0xfc, 0x00, 0x0b, 0xf8, 0x00, 0x00, 0x7f, 0x80,  //@@@.......%@@@+.........+@@@%..
    0xfc, 0x00, 0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //@@@........@@@@@+.....+@@@@@...
    0xfc, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //@@@.........@@@@@@@@@@@@@@%....
    0xfc, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //@@@..........+@@@@@@@@@@@+.....
    0xfc, 0x00, 0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //@@@............+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+042f (Я) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x1b, 0xff, 0xff, 0xf0,  //.....+%@@@@@@@@@@@
    0x01, 0xff, 0xff, 0xff, 0xf0,  //...+@@@@@@@@@@@@@@
    0x07, 0xff, 0xff, 0xff, 0xf0,  //..+@@@@@@@@@@@@@@@
    0x0f, 0xf4, 0x00, 0x03, 0xf0,  //..@@@@+........@@@
    0x2f, 0xc0, 0x00, 0x03, 0xf0,  //.%@@@..........@@@
    0x3f, 0x40, 0x00, 0x03, 0xf0,  //.@@@+..........@@@
    0x3f, 0x00, 0x00, 0x03, 0xf0,  //.@@@...........@@@
    0x3f, 0x00, 0x00, 0x03, 0xf0,  //.@@@...........@@@
    0x3f, 0x00, 0x00, 0x03, 0xf0,  //.@@@...........@@@
    0x2f, 0x40, 0x00, 0x03, 0xf0,  //.%@@+..........@@@
    0x1f, 0xc0, 0x00, 0x03, 0xf0,  //.+@@@..........@@@
    0x0b, 0xf4, 0x00, 0x03, 0xf0,  //..%@@@+........@@@
    0x01, 0xff, 0xff, 0xff, 0xf0,  //...+@@@@@@@@@@@@@@
    0x00, 0x2f, 0xff, 0xff, 0xf0,  //.....%@@@@@@@@@@@@
    0x00, 0x07, 0xff, 0xff, 0xf0,  //......+@@@@@@@@@@@
    0x00, 0x0f, 0xe0, 0x03, 0xf0,  //......@@@%.....@@@
    0x00, 0x2f, 0xc0, 0x03, 0xf0,  //.....%@@@......@@@
    0x00, 0x7f, 0x40, 0x03, 0xf0,  //....+@@@+......@@@
    0x00, 0xfe, 0x00, 0x03, 0xf0,  //....@@@%.......@@@
    0x02, 0xfc, 0x00, 0x03, 0xf0,  //...%@@@........@@@
    0x03, 0xf4, 0x00, 0x03, 0xf0,  //...@@@+........@@@
    0x0f, 0xf0, 0x00, 0x03, 0xf0,  //..@@@%.........@@@
    0x1f, 0xc0, 0x00, 0x03, 0xf0,  //.+@@@..........@@@
    0x3f, 0x40, 0x00, 0x03, 0xf0,  //.@@@+..........@@@
    0xbf, 0x00, 0x00, 0x03, 0xf0,  //%@@@...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0430 (а) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0xaf, 0xf9, 0x00,  //....%%@@@@%+....
    0x1f, 0xff, 0xff, 0xc0,  //..%@@@@@@@@@@...
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@..
    0x3e, 0x40, 0x0b, 0xfc,  //.@@%+.....+@@@@.
    0x20, 0x00, 0x00, 0xfd,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x7e,  //............+@@%
    0x00, 0x00, 0x00, 0x3f,  //.............@@@
    0x00, 0x6f, 0xff, 0xff,  //....+%@@@@@@@@@@
    0x0b, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@
    0x3f, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x7f, 0x90, 0x00, 0x3f,  //+@@@%+.......@@@
    0xfe, 0x00, 0x00, 0x3f,  //@@@%.........@@@
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfc, 0x00, 0x00, 0xff,  //@@@.........@@@@
    0xfd, 0x00, 0x02, 0xff,  //@@@+.......%@@@@
    0xbf, 0x80, 0x1f, 0xff,  //%@@@%....+@@@@@@
    0x3f, 0xff, 0xff, 0xbf,  //.@@@@@@@@@@@%@@@
    0x0f, 0xff, 0xfe, 0x3f,  //..@@@@@@@@@+.@@@
    0x01, 0xff, 0xe0, 0x3f,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0431 (б) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x6f, 0xff, 0x40,  //........+%@@@@@@+.
    0x00, 0x1f, 0xff, 0xff, 0x80,  //.....+@@@@@@@@@@%.
    0x00, 0xbf, 0xff, 0xff, 0x80,  //....%@@@@@@@@@@@%.
    0x02, 0xff, 0x94, 0x00, 0x00,  //...%@@@@%++.......
    0x07, 0xf8, 0x00, 0x00, 0x00,  //..+@@@%...........
    0x0f, 0xd0, 0x00, 0x00, 0x00,  //..@@@+............
    0x1f, 0x40, 0x00, 0x00, 0x00,  //.+@@+.............
    0x3f, 0x0b, 0xff, 0x40, 0x00,  //.@@@..%@@@@@+.....
    0x3f, 0xbf, 0xff, 0xf4, 0x00,  //.@@@%@@@@@@@@@+...
    0x3f, 0xff, 0xff, 0xfe, 0x00,  //.@@@@@@@@@@@@@@%..
    0x3f, 0xfd, 0x01, 0xff, 0x40,  //.@@@@@@+...+@@@@+.
    0x3f, 0xe0, 0x00, 0x2f, 0xc0,  //.@@@@%.......%@@@.
    0x3f, 0xc0, 0x00, 0x0f, 0xd0,  //.@@@@.........@@@+
    0x3f, 0x40, 0x00, 0x0b, 0xe0,  //.@@@+.........+@@%
    0x3f, 0x00, 0x00, 0x03, 0xf0,  //.@@@...........@@@
    0x3f, 0x00, 0x00, 0x03, 0xf0,  //.@@@...........@@@
    0x3f, 0x00, 0x00, 0x03, 0xf0,  //.@@@...........@@@
    0x3f, 0x00, 0x00, 0x03, 0xf0,  //.@@@...........@@@
    0x3f, 0x00, 0x00, 0x03, 0xf0,  //.@@@...........@@@
    0x2f, 0x40, 0x00, 0x07, 0xe0,  //.%@@+.........+@@%
    0x1f, 0xc0, 0x00, 0x0f, 0xd0,  //.+@@@.........@@@+
    0x0f, 0xe0, 0x00, 0x2f, 0xc0,  //..@@@%.......%@@@.
    0x07, 0xfd, 0x01, 0xff, 0x40,  //..+@@@@+...+@@@@+.
    0x02, 0xff, 0xff, 0xfe, 0x00,  //...%@@@@@@@@@@@%..
    0x00, 0xbf, 0xff, 0xf8, 0x00,  //....%@@@@@@@@@%...
    0x00, 0x0b, 0xff, 0x80, 0x00,  //......%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0432 (в) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xf8, 0x00,  //@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@+.
    0xfc, 0x00, 0x1f, 0xf0,  //@@@......+@@@@.
    0xfc, 0x00, 0x07, 0xf0,  //@@@.......+@@@.
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@.
    0xfc, 0x00, 0x07, 0xe0,  //@@@.......+@@%.
    0xfc, 0x00, 0x2f, 0xc0,  //@@@......%@@@..
    0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@+...
    0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@%.
    0xfc, 0x00, 0x07, 0xf4,  //@@@.......+@@@+
    0xfc, 0x00, 0x01, 0xfc,  //@@@........+@@@
    0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@
    0xfc, 0x00, 0x01, 0xfc,  //@@@........+@@@
    0xfc, 0x00, 0x07, 0xf8,  //@@@.......+@@@%
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@..
    0xff, 0xff, 0xf9, 0x00,  //@@@@@@@@@@%+...
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0433 (г) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0434 (д) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x3f, 0xff, 0xff, 0xc0,  //.....@@@@@@@@@@@@...
    0x00, 0x3f, 0xff, 0xff, 0xc0,  //.....@@@@@@@@@@@@...
    0x00, 0x3f, 0xff, 0xff, 0xc0,  //.....@@@@@@@@@@@@...
    0x00, 0x3f, 0x00, 0x0f, 0xc0,  //.....@@@......@@@...
    0x00, 0x3f, 0x00, 0x0f, 0xc0,  //.....@@@......@@@...
    0x00, 0x3f, 0x00, 0x0f, 0xc0,  //.....@@@......@@@...
    0x00, 0x3f, 0x00, 0x0f, 0xc0,  //.....@@@......@@@...
    0x00, 0x3f, 0x00, 0x0f, 0xc0,  //.....@@@......@@@...
    0x00, 0x7f, 0x00, 0x0f, 0xc0,  //....+@@@......@@@...
    0x00, 0x7e, 0x00, 0x0f, 0xc0,  //....+@@%......@@@...
    0x00, 0xbe, 0x00, 0x0f, 0xc0,  //....%@@%......@@@...
    0x00, 0xfd, 0x00, 0x0f, 0xc0,  //....@@@+......@@@...
    0x00, 0xfc, 0x00, 0x0f, 0xc0,  //....@@@.......@@@...
    0x01, 0xfc, 0x00, 0x0f, 0xc0,  //...+@@@.......@@@...
    0x03, 0xf4, 0x00, 0x0f, 0xc0,  //...@@@+.......@@@...
    0x0f, 0xf0, 0x00, 0x0f, 0xc0,  //..@@@@........@@@...
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00, 0x3f,  //@@@..............@@@
    0xfc, 0x00, 0x00, 0x00, 0x3f,  //@@@..............@@@
    0xfc, 0x00, 0x00, 0x00, 0x3f,  //@@@..............@@@
    0xfc, 0x00, 0x00, 0x00, 0x3f,  //@@@..............@@@
    0xfc, 0x00, 0x00, 0x00, 0x3f,  //@@@..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+0435 (е) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+....
    0x01, 0xff, 0xff, 0xf0, 0x00,  //...+@@@@@@@@@@...
    0x07, 0xff, 0xff, 0xfc, 0x00,  //..+@@@@@@@@@@@@..
    0x1f, 0xe4, 0x01, 0xff, 0x00,  //..@@@%+....+@@@@.
    0x3f, 0x40, 0x00, 0x3f, 0x40,  //.@@@+........@@@+
    0x7e, 0x00, 0x00, 0x1f, 0x80,  //+@@%.........+@@%
    0xbc, 0x00, 0x00, 0x0f, 0xc0,  //%@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xbe, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0x7f, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0x3f, 0xc0, 0x00, 0x02, 0x00,  //.@@@@..........%.
    0x1f, 0xf8, 0x00, 0x7f, 0x00,  //.+@@@@%.....+@@@.
    0x07, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x01, 0xff, 0xff, 0xfd, 0x00,  //...+@@@@@@@@@@@+.
    0x00, 0x1b, 0xff, 0x80, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0436 (ж) , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x2f, 0xe0, 0x00, 0x3f, 0x00, 0x02, 0xfe, 0x00,  //.%@@@%.......@@@.......%@@@%.
    0x0b, 0xf8, 0x00, 0x3f, 0x00, 0x0b, 0xf8, 0x00,  //..%@@@%......@@@......%@@@%..
    0x02, 0xfd, 0x00, 0x3f, 0x00, 0x1f, 0xe0, 0x00,  //...%@@@+.....@@@.....+@@@%...
    0x00, 0xbf, 0x40, 0x3f, 0x00, 0x7f, 0x80, 0x00,  //....%@@@+....@@@....+@@@%....
    0x00, 0x3f, 0xd0, 0x3f, 0x01, 0xff, 0x00, 0x00,  //.....%@@@+...@@@...+@@@%.....
    0x00, 0x0f, 0xf4, 0x3f, 0x07, 0xfc, 0x00, 0x00,  //......@@@@+..@@@..+@@@@......
    0x00, 0x03, 0xfc, 0x3f, 0x0f, 0xf0, 0x00, 0x00,  //.......@@@@..@@@..@@@@.......
    0x00, 0x01, 0xff, 0x3f, 0x3f, 0xd0, 0x00, 0x00,  //.......+@@@@.@@@.@@@@+.......
    0x00, 0x03, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@.......
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //......%@@@@@@@@@@@@@@@%......
    0x00, 0x1f, 0xd3, 0xff, 0xf1, 0xfd, 0x00, 0x00,  //.....+@@@+.@@@@@@@.+@@@+.....
    0x00, 0x3f, 0x81, 0xff, 0xd0, 0xbf, 0x00, 0x00,  //.....@@@%...@@@@@...%@@@.....
    0x00, 0xbf, 0x00, 0x7f, 0x40, 0x3f, 0x80, 0x00,  //....%@@@....+@@@+....@@@%....
    0x01, 0xfd, 0x00, 0x3f, 0x00, 0x1f, 0xd0, 0x00,  //...+@@@+.....@@@.....+@@@+...
    0x03, 0xf8, 0x00, 0x3f, 0x00, 0x0b, 0xf0, 0x00,  //...@@@%......@@@......%@@@...
    0x0b, 0xf0, 0x00, 0x3f, 0x00, 0x03, 0xf8, 0x00,  //..%@@@.......@@@.......@@@%..
    0x1f, 0xd0, 0x00, 0x3f, 0x00, 0x01, 0xfd, 0x00,  //.+@@@+.......@@@.......+@@@+.
    0x3f, 0x80, 0x00, 0x3f, 0x00, 0x00, 0xbf, 0x00,  //.@@@%........@@@........%@@@.
    0xbf, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x3f, 0x80,  //%@@@.........@@@.........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+0437 (з) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x06, 0xff, 0xe0, 0x00,  //..+%@@@@@%....
    0x3f, 0xff, 0xfd, 0x00,  //.@@@@@@@@@@+..
    0x3f, 0xff, 0xff, 0x40,  //.@@@@@@@@@@@+.
    0x39, 0x00, 0xbf, 0xc0,  //.@%+....%@@@@.
    0x00, 0x00, 0x1f, 0xc0,  //.........+@@@.
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@.
    0x00, 0x00, 0x1f, 0x80,  //.........+@@%.
    0x00, 0x00, 0x7e, 0x00,  //........+@@%..
    0x00, 0xff, 0xf4, 0x00,  //....@@@@@@+...
    0x00, 0xff, 0xfd, 0x00,  //....@@@@@@@+..
    0x00, 0xff, 0xff, 0x80,  //....@@@@@@@@%.
    0x00, 0x00, 0x2f, 0xe0,  //.........%@@@%
    0x00, 0x00, 0x07, 0xf0,  //..........+@@@
    0x00, 0x00, 0x03, 0xf0,  //...........@@@
    0x00, 0x00, 0x07, 0xf0,  //..........+@@@
    0xe4, 0x00, 0x6f, 0xe0,  //@++.....+%@@@%
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@.
    0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@%..
    0x1b, 0xff, 0xe0, 0x00,  //.+%@@@@@%%....
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0438 (и) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xfc, 0x00, 0x00, 0xff,  //@@@.........@@@@
    0xfc, 0x00, 0x03, 0xff,  //@@@........@@@@@
    0xfc, 0x00, 0x07, 0xff,  //@@@.......+@@@@@
    0xfc, 0x00, 0x0f, 0xff,  //@@@.......@@@@@@
    0xfc, 0x00, 0x2f, 0xff,  //@@@......%@@@@@@
    0xfc, 0x00, 0x7f, 0x3f,  //@@@.....+@@@.@@@
    0xfc, 0x00, 0xfe, 0x3f,  //@@@.....@@@%.@@@
    0xfc, 0x02, 0xfc, 0x3f,  //@@@....%@@@..@@@
    0xfc, 0x03, 0xf4, 0x3f,  //@@@....@@@+..@@@
    0xfc, 0x0f, 0xe0, 0x3f,  //@@@...@@@%...@@@
    0xfc, 0x1f, 0xc0, 0x3f,  //@@@..+@@@....@@@
    0xfc, 0x3f, 0x80, 0x3f,  //@@@..@@@%....@@@
    0xfc, 0xbf, 0x00, 0x3f,  //@@@.%@@@.....@@@
    0xfd, 0xfd, 0x00, 0x3f,  //@@@+@@@+.....@@@
    0xff, 0xf8, 0x00, 0x3f,  //@@@@@@%......@@@
    0xff, 0xf0, 0x00, 0x3f,  //@@@@@@.......@@@
    0xff, 0xd0, 0x00, 0x3f,  //@@@@@+.......@@@
    0xff, 0xc0, 0x00, 0x3f,  //@@@@@........@@@
    0xff, 0x00, 0x00, 0x3f,  //@@@@.........@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0439 (й) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x03, 0xc0, 0x03, 0xc0,  //...@@......@@...
    0x03, 0xf4, 0x1f, 0xc0,  //...%@@....@@%...
    0x01, 0xff, 0xff, 0x40,  //...+@@@@@@@@+...
    0x00, 0xbf, 0xfe, 0x00,  //....%@@@@@@%....
    0x00, 0x1f, 0xf4, 0x00,  //.....+@@@@+.....
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xfc, 0x00, 0x00, 0xff,  //@@@.........@@@@
    0xfc, 0x00, 0x03, 0xff,  //@@@........@@@@@
    0xfc, 0x00, 0x07, 0xff,  //@@@.......+@@@@@
    0xfc, 0x00, 0x0f, 0xff,  //@@@.......@@@@@@
    0xfc, 0x00, 0x2f, 0xff,  //@@@......%@@@@@@
    0xfc, 0x00, 0x7f, 0x3f,  //@@@.....+@@@.@@@
    0xfc, 0x00, 0xfe, 0x3f,  //@@@.....@@@%.@@@
    0xfc, 0x02, 0xfc, 0x3f,  //@@@....%@@@..@@@
    0xfc, 0x03, 0xf4, 0x3f,  //@@@....@@@+..@@@
    0xfc, 0x0f, 0xe0, 0x3f,  //@@@...@@@%...@@@
    0xfc, 0x1f, 0xc0, 0x3f,  //@@@..+@@@....@@@
    0xfc, 0x3f, 0x80, 0x3f,  //@@@..@@@%....@@@
    0xfc, 0xbf, 0x00, 0x3f,  //@@@.%@@@.....@@@
    0xfd, 0xfd, 0x00, 0x3f,  //@@@+@@@+.....@@@
    0xff, 0xf8, 0x00, 0x3f,  //@@@@@@%......@@@
    0xff, 0xf0, 0x00, 0x3f,  //@@@@@@.......@@@
    0xff, 0xd0, 0x00, 0x3f,  //@@@@@+.......@@@
    0xff, 0xc0, 0x00, 0x3f,  //@@@@@........@@@
    0xff, 0x00, 0x00, 0x3f,  //@@@@.........@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+043a (к) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xfc, 0x00, 0x0b, 0xf8,  //@@@.......%@@@%.
    0xfc, 0x00, 0x2f, 0xe0,  //@@@......%@@@%..
    0xfc, 0x00, 0x7f, 0x80,  //@@@.....+@@@%...
    0xfc, 0x01, 0xfe, 0x00,  //@@@....+@@@%....
    0xfc, 0x07, 0xfc, 0x00,  //@@@...+@@@%.....
    0xfc, 0x1f, 0xf0, 0x00,  //@@@..+@@@@......
    0xfc, 0x3f, 0xc0, 0x00,  //@@@..@@@@.......
    0xfc, 0xff, 0x40, 0x00,  //@@@.@@@@+.......
    0xff, 0xff, 0xc0, 0x00,  //@@@@@@@@@.......
    0xff, 0xff, 0xe0, 0x00,  //@@@@@@@@@%......
    0xff, 0xc7, 0xf0, 0x00,  //@@@@@.+@@@......
    0xff, 0x02, 0xfc, 0x00,  //@@@@...%@@@.....
    0xfd, 0x00, 0xfe, 0x00,  //@@@+....@@@%....
    0xfc, 0x00, 0x7f, 0x40,  //@@@.....+@@@+...
    0xfc, 0x00, 0x2f, 0xc0,  //@@@......%@@@...
    0xfc, 0x00, 0x0f, 0xe0,  //@@@.......@@@%..
    0xfc, 0x00, 0x07, 0xf4,  //@@@.......+@@@+.
    0xfc, 0x00, 0x02, 0xfc,  //@@@........%@@@.
    0xfc, 0x00, 0x00, 0xfe,  //@@@.........@@@%
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+043b (л) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x3f, 0xff, 0xff, 0xf0,  //.....@@@@@@@@@@@@@
    0x00, 0x3f, 0xff, 0xff, 0xf0,  //.....@@@@@@@@@@@@@
    0x00, 0x3f, 0xff, 0xff, 0xf0,  //.....@@@@@@@@@@@@@
    0x00, 0x3f, 0x00, 0x03, 0xf0,  //.....@@@.......@@@
    0x00, 0x3f, 0x00, 0x03, 0xf0,  //.....@@@.......@@@
    0x00, 0x3f, 0x00, 0x03, 0xf0,  //.....@@@.......@@@
    0x00, 0x3f, 0x00, 0x03, 0xf0,  //.....@@@.......@@@
    0x00, 0x3f, 0x00, 0x03, 0xf0,  //.....@@@.......@@@
    0x00, 0x3f, 0x00, 0x03, 0xf0,  //.....@@@.......@@@
    0x00, 0x7f, 0x00, 0x03, 0xf0,  //....+@@@.......@@@
    0x00, 0x7e, 0x00, 0x03, 0xf0,  //....+@@%.......@@@
    0x00, 0xbe, 0x00, 0x03, 0xf0,  //....%@@%.......@@@
    0x00, 0xfd, 0x00, 0x03, 0xf0,  //....@@@+.......@@@
    0x00, 0xfc, 0x00, 0x03, 0xf0,  //....@@@........@@@
    0x03, 0xfc, 0x00, 0x03, 0xf0,  //...@@@@........@@@
    0x1f, 0xf4, 0x00, 0x03, 0xf0,  //.+@@@@+........@@@
    0xff, 0xe0, 0x00, 0x03, 0xf0,  //@@@@@%.........@@@
    0xff, 0x80, 0x00, 0x03, 0xf0,  //@@@@+..........@@@
    0xe4, 0x00, 0x00, 0x03, 0xf0,  //@%+............@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+043c (м) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xc0, 0x00, 0x0f, 0xfc,  //@@@@@.........@@@@@
    0xff, 0xe0, 0x00, 0x2f, 0xfc,  //@@@@@%.......%@@@@@
    0xff, 0xf0, 0x00, 0x3f, 0xfc,  //@@@@@@.......@@@@@@
    0xff, 0xf4, 0x00, 0x7f, 0xfc,  //@@@@@@+.....+@@@@@@
    0xfd, 0xfc, 0x00, 0xfd, 0xfc,  //@@@+@@@.....@@@+@@@
    0xfc, 0xfd, 0x01, 0xfc, 0xfc,  //@@@.@@@+...+@@@.@@@
    0xfc, 0xbe, 0x02, 0xf8, 0xfc,  //@@@.%@@%...%@@%.@@@
    0xfc, 0x3f, 0x03, 0xf0, 0xfc,  //@@@..@@@...@@@..@@@
    0xfc, 0x2f, 0x8b, 0xe0, 0xfc,  //@@@..%@@%.%@@%..@@@
    0xfc, 0x1f, 0xcf, 0xd0, 0xfc,  //@@@..+@@@.@@@+..@@@
    0xfc, 0x0f, 0xef, 0xc0, 0xfc,  //@@@...@@@%@@@...@@@
    0xfc, 0x07, 0xff, 0x40, 0xfc,  //@@@...+@@@@@+...@@@
    0xfc, 0x03, 0xff, 0x00, 0xfc,  //@@@....@@@@@....@@@
    0xfc, 0x02, 0xfe, 0x00, 0xfc,  //@@@....%@@@%....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+043d (н) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+043e (о) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x1f, 0xf4, 0x07, 0xfd, 0x00,  //.+@@@@+...+@@@@+.
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@@.........@@@+
    0xbd, 0x00, 0x00, 0x2f, 0x80,  //%@@+.........+@@%
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xbd, 0x00, 0x00, 0x1f, 0x80,  //%@@+.........+@@%
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@@.........@@@+
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x1f, 0xf4, 0x07, 0xfd, 0x00,  //.+@@@@+...+@@@@+.
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+043f (п) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0440 (р) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xfc, 0x0b, 0xfe, 0x00, 0x00,  //@@@...%@@@@%.....
    0xfc, 0xbf, 0xff, 0xe0, 0x00,  //@@@.%@@@@@@@@%...
    0xfe, 0xff, 0xff, 0xf8, 0x00,  //@@@%@@@@@@@@@@%..
    0xff, 0xf4, 0x07, 0xfd, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0x80, 0x00, 0xbf, 0x00,  //@@@@%.......%@@@.
    0xff, 0x00, 0x00, 0x3f, 0x40,  //@@@@.........@@@+
    0xfd, 0x00, 0x00, 0x1f, 0x80,  //@@@+.........+@@%
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfd, 0x00, 0x00, 0x1f, 0x80,  //@@@+.........+@@%
    0xff, 0x00, 0x00, 0x3f, 0x40,  //@@@@.........@@@+
    0xff, 0x80, 0x00, 0xbf, 0x00,  //@@@@%.......%@@@.
    0xff, 0xf4, 0x07, 0xfd, 0x00,  //@@@@@@+...+@@@@+.
    0xfe, 0xff, 0xff, 0xf8, 0x00,  //@@@%@@@@@@@@@@%..
    0xfc, 0xbf, 0xff, 0xe0, 0x00,  //@@@.%@@@@@@@@%...
    0xfc, 0x0b, 0xfe, 0x00, 0x00,  //@@@...%@@@@%.....
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0441 (с) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x1b, 0xff, 0x90,  //.....+%@@@@@%+.
    0x00, 0xff, 0xff, 0xfc,  //....@@@@@@@@@@@
    0x07, 0xff, 0xff, 0xfc,  //..+@@@@@@@@@@@@
    0x0f, 0xf9, 0x00, 0x6c,  //..@@@@%.....+%@
    0x3f, 0xc0, 0x00, 0x00,  //.@@@@..........
    0x7f, 0x00, 0x00, 0x00,  //+@@@...........
    0xbe, 0x00, 0x00, 0x00,  //%@@%...........
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xbe, 0x00, 0x00, 0x00,  //%@@%...........
    0x7f, 0x00, 0x00, 0x00,  //+@@@...........
    0x3f, 0xc0, 0x00, 0x00,  //.@@@@..........
    0x0f, 0xf8, 0x00, 0x6c,  //..@@@@%.....+%@
    0x07, 0xff, 0xff, 0xfc,  //..+@@@@@@@@@@@@
    0x01, 0xff, 0xff, 0xfc,  //....@@@@@@@@@@@
    0x00, 0x1b, 0xff, 0x90,  //.....+%@@@@@%+.
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0442 (т) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0443 (у) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xfd, 0x00, 0x00, 0x07, 0xf0,  //@@@+..........+@@@
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........@@@+
    0x3f, 0x40, 0x00, 0x0f, 0xc0,  //.@@@+.........@@@.
    0x2f, 0x80, 0x00, 0x2f, 0x80,  //.%@@%........%@@%.
    0x0f, 0xc0, 0x00, 0x3f, 0x00,  //..@@@........@@@..
    0x0b, 0xe0, 0x00, 0x7f, 0x00,  //..%@@%......+@@@..
    0x07, 0xf0, 0x00, 0xfd, 0x00,  //..+@@@......@@@+..
    0x03, 0xf4, 0x00, 0xfc, 0x00,  //...@@@+.....@@@...
    0x01, 0xfc, 0x02, 0xf8, 0x00,  //...+@@@....%@@%...
    0x00, 0xfc, 0x03, 0xf4, 0x00,  //....@@@....@@@+...
    0x00, 0xbe, 0x07, 0xf0, 0x00,  //....%@@%..+@@@....
    0x00, 0x3f, 0x0b, 0xd0, 0x00,  //.....@@@..%@@+....
    0x00, 0x3f, 0x4f, 0xc0, 0x00,  //.....@@@+.@@@.....
    0x00, 0x1f, 0xef, 0x80, 0x00,  //.....+@@@%@@%.....
    0x00, 0x0f, 0xff, 0x40, 0x00,  //......@@@@@@+.....
    0x00, 0x0b, 0xff, 0x00, 0x00,  //......%@@@@@......
    0x00, 0x03, 0xfe, 0x00, 0x00,  //.......@@@@+......
    0x00, 0x03, 0xfc, 0x00, 0x00,  //.......%@@@.......
    0x00, 0x02, 0xf8, 0x00, 0x00,  //.......%@@%.......
    0x00, 0x03, 0xf4, 0x00, 0x00,  //.......@@@+.......
    0x00, 0x07, 0xf0, 0x00, 0x00,  //......+@@@........
    0x00, 0x0f, 0xe0, 0x00, 0x00,  //......%@@%........
    0x00, 0x2f, 0xc0, 0x00, 0x00,  //.....%@@@.........
    0x0f, 0xff, 0x80, 0x00, 0x00,  //..@@@@@@%.........
    0x0f, 0xff, 0x00, 0x00, 0x00,  //..@@@@@@..........
    0x0f, 0xf8, 0x00, 0x00, 0x00,  //..@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0444 (ф) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0xbf, 0x83, 0xf0, 0xbf, 0x80, 0x00,  //....%@@@%..@@@..%@@@%....
    0x03, 0xff, 0xf3, 0xf3, 0xff, 0xf0, 0x00,  //...@@@@@@@.@@@.@@@@@@@...
    0x0f, 0xff, 0xfb, 0xfb, 0xff, 0xfc, 0x00,  //..@@@@@@@@%@@@%@@@@@@@@..
    0x2f, 0xd0, 0x7f, 0xff, 0x41, 0xfe, 0x00,  //.%@@@+..+@@@@@@@+..+@@@%.
    0x3f, 0x40, 0x0f, 0xfc, 0x00, 0x7f, 0x00,  //.@@@......@@@@@.....+@@@.
    0x7e, 0x00, 0x03, 0xf0, 0x00, 0x2f, 0x40,  //+@@%.......@@@.......%@@+
    0xbd, 0x00, 0x03, 0xf0, 0x00, 0x1f, 0x80,  //%@@+.......@@@.......+@@%
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xbd, 0x00, 0x03, 0xf0, 0x00, 0x1f, 0x80,  //%@@+.......@@@.......+@@%
    0xbe, 0x00, 0x03, 0xf0, 0x00, 0x2f, 0x80,  //+@@%.......@@@.......%@@+
    0x3f, 0x00, 0x0f, 0xfc, 0x00, 0x7f, 0x00,  //.@@@......@@@@@.....+@@@.
    0x2f, 0xd0, 0x7f, 0xff, 0x41, 0xfe, 0x00,  //.%@@@+..+@@@@@@@+..+@@@%.
    0x0f, 0xff, 0xfb, 0xfb, 0xff, 0xfc, 0x00,  //..@@@@@@@@%@@@%@@@@@@@@..
    0x03, 0xff, 0xf3, 0xf3, 0xff, 0xf0, 0x00,  //...@@@@@@@.@@@.@@@@@@@...
    0x00, 0xbf, 0x83, 0xf0, 0xbf, 0x80, 0x00,  //....%@@@%..@@@..%@@@%....
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+0445 (х) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x2f, 0xc0, 0x00, 0x0f, 0xe0,  //.%@@@.........@@@%
    0x0f, 0xf0, 0x00, 0x3f, 0xc0,  //..@@@@.......@@@@.
    0x03, 0xf8, 0x00, 0xbf, 0x00,  //...@@@%.....%@@@..
    0x01, 0xfc, 0x01, 0xfd, 0x00,  //...+@@@.....@@@+..
    0x00, 0xbf, 0x03, 0xf8, 0x00,  //....%@@@...@@@%...
    0x00, 0x3f, 0x8b, 0xf0, 0x00,  //.....@@@%.%@@@....
    0x00, 0x1f, 0xef, 0xd0, 0x00,  //.....+@@@%@@@+....
    0x00, 0x0b, 0xff, 0x80, 0x00,  //......%@@@@@%.....
    0x00, 0x03, 0xff, 0x00, 0x00,  //.......@@@@@......
    0x00, 0x02, 0xfe, 0x00, 0x00,  //.......%@@@%......
    0x00, 0x0b, 0xff, 0x00, 0x00,  //......%@@@@@......
    0x00, 0x1f, 0xff, 0xc0, 0x00,  //.....+@@@@@@@.....
    0x00, 0x3f, 0x8f, 0xe0, 0x00,  //.....@@@%.@@@%....
    0x00, 0xff, 0x07, 0xf0, 0x00,  //....@@@@..+@@@....
    0x02, 0xfc, 0x02, 0xfc, 0x00,  //...%@@@....%@@@...
    0x07, 0xf4, 0x00, 0xfe, 0x00,  //..+@@@+.....@@@%..
    0x0f, 0xe0, 0x00, 0x7f, 0x40,  //..@@@%......+@@@+.
    0x3f, 0xc0, 0x00, 0x2f, 0xc0,  //.@@@@........%@@@.
    0xbf, 0x00, 0x00, 0x0f, 0xe0,  //%@@@..........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0446 (ц) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xfc,  //................@@@
    0x00, 0x00, 0x00, 0x00, 0xfc,  //................@@@
    0x00, 0x00, 0x00, 0x00, 0xfc,  //................@@@
    0x00, 0x00, 0x00, 0x00, 0xfc,  //................@@@
    0x00, 0x00, 0x00, 0x00, 0xfc,  //................@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0447 (ч) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@
    0xfe, 0x00, 0x00, 0xfc,  //%@@%........@@@
    0x7f, 0x80, 0x00, 0xfc,  //+@@@%.......@@@
    0x3f, 0xff, 0xff, 0xfc,  //.@@@@@@@@@@@@@@
    0x0f, 0xff, 0xff, 0xfc,  //..@@@@@@@@@@@@@
    0x01, 0xff, 0xff, 0xfc,  //...+@@@@@@@@@@@
    0x00, 0x00, 0x00, 0xfc,  //............@@@
    0x00, 0x00, 0x00, 0xfc,  //............@@@
    0x00, 0x00, 0x00, 0xfc,  //............@@@
    0x00, 0x00, 0x00, 0xfc,  //............@@@
    0x00, 0x00, 0x00, 0xfc,  //............@@@
    0x00, 0x00, 0x00, 0xfc,  //............@@@
    0x00, 0x00, 0x00, 0xfc,  //............@@@
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0448 (ш) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+0449 (щ) , Width: 28 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@...
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@...
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@...
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@...
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@...
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@...
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@...
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@...
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@...
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@...
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@...
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@...
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@...
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@...
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@...
    0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xc0,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f,  //.........................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f,  //.........................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f,  //.........................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f,  //.........................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f,  //.........................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................


    /*Unicode: U+044a (ъ) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,  //@@@@@@@@@............
    0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,  //@@@@@@@@@............
    0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,  //@@@@@@@@@............
    0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00,  //......@@@............
    0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00,  //......@@@............
    0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00,  //......@@@............
    0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00,  //......@@@............
    0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00,  //......@@@............
    0x00, 0x0f, 0xff, 0xff, 0x90, 0x00,  //......@@@@@@@@@@%+...
    0x00, 0x0f, 0xff, 0xff, 0xfd, 0x00,  //......@@@@@@@@@@@@@+.
    0x00, 0x0f, 0xff, 0xff, 0xff, 0x00,  //......@@@@@@@@@@@@@@.
    0x00, 0x0f, 0xc0, 0x00, 0x7f, 0x80,  //......@@@.......+@@@%
    0x00, 0x0f, 0xc0, 0x00, 0x1f, 0xc0,  //......@@@........+@@@
    0x00, 0x0f, 0xc0, 0x00, 0x0f, 0xc0,  //......@@@.........@@@
    0x00, 0x0f, 0xc0, 0x00, 0x1f, 0xc0,  //......@@@........+@@@
    0x00, 0x0f, 0xc0, 0x00, 0x7f, 0x80,  //......@@@.......+@@@%
    0x00, 0x0f, 0xff, 0xff, 0xff, 0x00,  //......@@@@@@@@@@@@@@.
    0x00, 0x0f, 0xff, 0xff, 0xfd, 0x00,  //......@@@@@@@@@@@@@+.
    0x00, 0x0f, 0xff, 0xff, 0x90, 0x00,  //......@@@@@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+044b (ы) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xfc, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //@@@...............@@@
    0xfc, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //@@@...............@@@
    0xfc, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //@@@...............@@@
    0xfc, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //@@@...............@@@
    0xfc, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //@@@...............@@@
    0xfc, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //@@@...............@@@
    0xfc, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //@@@...............@@@
    0xfc, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //@@@...............@@@
    0xff, 0xff, 0xf9, 0x00, 0x0f, 0xc0,  //@@@@@@@@@@%+......@@@
    0xff, 0xff, 0xff, 0xd0, 0x0f, 0xc0,  //@@@@@@@@@@@@@+....@@@
    0xff, 0xff, 0xff, 0xf0, 0x0f, 0xc0,  //@@@@@@@@@@@@@@....@@@
    0xfc, 0x00, 0x07, 0xf8, 0x0f, 0xc0,  //@@@.......+@@@%...@@@
    0xfc, 0x00, 0x01, 0xfc, 0x0f, 0xc0,  //@@@........+@@@...@@@
    0xfc, 0x00, 0x00, 0xfc, 0x0f, 0xc0,  //@@@.........@@@...@@@
    0xfc, 0x00, 0x01, 0xfc, 0x0f, 0xc0,  //@@@........+@@@...@@@
    0xfc, 0x00, 0x07, 0xf8, 0x0f, 0xc0,  //@@@.......+@@@%...@@@
    0xff, 0xff, 0xff, 0xf0, 0x0f, 0xc0,  //@@@@@@@@@@@@@@....@@@
    0xff, 0xff, 0xff, 0xd0, 0x0f, 0xc0,  //@@@@@@@@@@@@@+....@@@
    0xff, 0xff, 0xf9, 0x00, 0x0f, 0xc0,  //@@@@@@@@@@%+......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+044c (ь) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xf9, 0x00,  //@@@@@@@@@@%+...
    0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.
    0xfc, 0x00, 0x07, 0xf8,  //@@@.......+@@@%
    0xfc, 0x00, 0x01, 0xfc,  //@@@........+@@@
    0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@
    0xfc, 0x00, 0x01, 0xfc,  //@@@........+@@@
    0xfc, 0x00, 0x07, 0xf8,  //@@@.......+@@@%
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@+.
    0xff, 0xff, 0xf9, 0x00,  //@@@@@@@@@@%+...
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+044d (э) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x1b, 0xff, 0x90, 0x00,  //.+%@@@@@%+.....
    0xff, 0xff, 0xfc, 0x00,  //@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@+..
    0xe4, 0x00, 0x7f, 0xc0,  //@%+.....+@@@@..
    0x00, 0x00, 0x0b, 0xf0,  //..........+@@@.
    0x00, 0x00, 0x02, 0xf4,  //...........%@@+
    0x00, 0x00, 0x00, 0xf8,  //............@@%
    0x0f, 0xff, 0xff, 0xfc,  //..@@@@@@@@@@@@@
    0x0f, 0xff, 0xff, 0xfc,  //..@@@@@@@@@@@@@
    0x0f, 0xff, 0xff, 0xfc,  //..@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0xfc,  //............@@@
    0x00, 0x00, 0x00, 0xfc,  //............@@@
    0x00, 0x00, 0x01, 0xf8,  //...........+@@%
    0x00, 0x00, 0x03, 0xf4,  //...........@@@+
    0x00, 0x00, 0x0f, 0xf0,  //..........@@@@.
    0xe4, 0x00, 0xbf, 0xd0,  //@%+.....%@@@@..
    0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@+..
    0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@+...
    0x1b, 0xff, 0x90, 0x00,  //.+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+044e (ю) , Width: 24 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0xfc, 0x00, 0x00, 0xbf, 0xf8, 0x00,  //@@@.........%@@@@@+.....
    0xfc, 0x00, 0x0b, 0xff, 0xff, 0x80,  //@@@.......%@@@@@@@@@+...
    0xfc, 0x00, 0x2f, 0xff, 0xff, 0xe0,  //@@@......%@@@@@@@@@@@%..
    0xfc, 0x00, 0x7f, 0xd0, 0x1f, 0xf4,  //@@@.....+@@@@+...+@@@@+.
    0xfc, 0x00, 0xfe, 0x00, 0x02, 0xfc,  //@@@.....@@@%.......%@@@.
    0xfc, 0x01, 0xfc, 0x00, 0x00, 0xfd,  //@@@....+@@@.........@@@+
    0xfc, 0x02, 0xf4, 0x00, 0x00, 0xbe,  //@@@....%@@+.........+@@%
    0xfc, 0x03, 0xf0, 0x00, 0x00, 0x3f,  //@@@....@@@...........@@@
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x3f,  //@@@@@@@@@@...........@@@
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x3f,  //@@@@@@@@@@...........@@@
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x3f,  //@@@@@@@@@@...........@@@
    0xfc, 0x03, 0xf0, 0x00, 0x00, 0x3f,  //@@@....@@@...........@@@
    0xfc, 0x03, 0xf4, 0x00, 0x00, 0x7e,  //@@@....@@@+.........+@@%
    0xfc, 0x02, 0xfc, 0x00, 0x00, 0xfd,  //@@@....%@@@.........@@@+
    0xfc, 0x00, 0xfe, 0x00, 0x02, 0xfc,  //@@@.....@@@%.......%@@@.
    0xfc, 0x00, 0xbf, 0xd0, 0x1f, 0xf4,  //@@@.....%@@@@+...+@@@@+.
    0xfc, 0x00, 0x3f, 0xff, 0xff, 0xe0,  //@@@......@@@@@@@@@@@@%..
    0xfc, 0x00, 0x0b, 0xff, 0xff, 0x80,  //@@@.......%@@@@@@@@@%...
    0xfc, 0x00, 0x00, 0xbf, 0xf8, 0x00,  //@@@.........%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................


    /*Unicode: U+044f (я) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0xbf, 0xff, 0xfc,  //....%@@@@@@@@@@
    0x07, 0xff, 0xff, 0xfc,  //..+@@@@@@@@@@@@
    0x0f, 0xff, 0xff, 0xfc,  //..@@@@@@@@@@@@@
    0x2f, 0xe0, 0x00, 0xfc,  //.%@@@%......@@@
    0x3f, 0x40, 0x00, 0xfc,  //.@@@+.......@@@
    0x3f, 0x00, 0x00, 0xfc,  //.@@@........@@@
    0x3f, 0x00, 0x00, 0xfc,  //.@@@........@@@
    0x2f, 0x40, 0x00, 0xfc,  //.%@@+.......@@@
    0x0f, 0xe0, 0x00, 0xfc,  //..@@@%......@@@
    0x03, 0xff, 0xff, 0xfc,  //...@@@@@@@@@@@@
    0x00, 0x7f, 0xff, 0xfc,  //....+@@@@@@@@@@
    0x00, 0x3f, 0xff, 0xfc,  //.....@@@@@@@@@@
    0x00, 0xbf, 0x00, 0xfc,  //....%@@@....@@@
    0x01, 0xfc, 0x00, 0xfc,  //...+@@@.....@@@
    0x03, 0xf8, 0x00, 0xfc,  //...@@@%.....@@@
    0x0b, 0xf0, 0x00, 0xfc,  //..%@@@......@@@
    0x1f, 0xc0, 0x00, 0xfc,  //.+@@@.......@@@
    0x3f, 0x80, 0x00, 0xfc,  //.@@@%.......@@@
    0xbf, 0x00, 0x00, 0xfc,  //%@@@........@@@
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............



#elif USE_LV_FONT_DEJAVU_40_CYRILLIC == 4
    /*Unicode: U+0410 (А) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xfd, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x02, 0xff, 0xf2, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x08, 0xff, 0xb0, 0xaf, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x0e, 0xff, 0x40, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x00, 0x00, 0x4f, 0xfe, 0x00, 0x0e, 0xff, 0x40, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0xaf, 0xf8, 0x00, 0x08, 0xff, 0xa0, 0x00, 0x00, 0x00,  //......%@@%...%@@%......
    0x00, 0x00, 0x01, 0xff, 0xf2, 0x00, 0x02, 0xff, 0xf1, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x07, 0xff, 0xc0, 0x00, 0x00, 0xcf, 0xf7, 0x00, 0x00, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x00, 0x0d, 0xff, 0x60, 0x00, 0x00, 0x5f, 0xfd, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x09, 0xff, 0x90, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf5, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //..%@@@@@@@@@@@@@@@@@%..
    0x00, 0xef, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xe0, 0x00,  //..@@@+...........+@@@..
    0x04, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xf4, 0x00,  //.+@@@.............@@@+.
    0x0a, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfa, 0x00,  //.%@@%.............%@@%.
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@...............@@@.
    0x6f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@@...............@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0411 (Б) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x93, 0x00, 0x00,  //@@@@@@@@@@@@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x14, 0x9f, 0xff, 0xe1,  //@@@.........%@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf7,  //@@@...........@@@+
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc,  //@@@...........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc,  //@@@...........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf8,  //@@@...........@@@%
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x14, 0x8f, 0xff, 0xf1,  //@@@.........%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00,  //@@@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xed, 0xa5, 0x00, 0x00,  //@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0412 (В) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xeb, 0x82, 0x00, 0x00,  //@@@@@@@@@@@%%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //@@@@@@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x25, 0xcf, 0xff, 0x60,  //@@@........+@@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xc0,  //@@@..........%@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xf0,  //@@@...........@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@...........@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0x80,  //@@@..........%@@%.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x25, 0xcf, 0xfe, 0x10,  //@@@........+@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x00,  //@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00,  //@@@@@@@@@@@@@@@%..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x14, 0x8f, 0xff, 0x90,  //@@@.........%@@@%.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf3,  //@@@...........@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfa,  //@@@...........+@@%
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfd,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfd,  //@@@...........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf8,  //@@@...........@@@%
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x14, 0x8f, 0xff, 0xf1,  //@@@.........%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00,  //@@@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xed, 0x95, 0x00, 0x00,  //@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0413 (Г) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0414 (Д) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //......@@@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //......@@@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //......@@@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //......@@@........@@@...
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //......@@@........@@@...
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //......@@@........@@@...
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //......@@@........@@@...
    0x00, 0x00, 0x01, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //......@@@........@@@...
    0x00, 0x00, 0x01, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //......@@@........@@@...
    0x00, 0x00, 0x02, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //......@@@........@@@...
    0x00, 0x00, 0x03, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //......@@@........@@@...
    0x00, 0x00, 0x05, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....+@@@........@@@...
    0x00, 0x00, 0x06, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....+@@%........@@@...
    0x00, 0x00, 0x08, 0xff, 0x90, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....%@@%........@@@...
    0x00, 0x00, 0x0b, 0xff, 0x70, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....%@@+........@@@...
    0x00, 0x00, 0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....@@@+........@@@...
    0x00, 0x00, 0x1f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....@@@.........@@@...
    0x00, 0x00, 0x5f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //....+@@@.........@@@...
    0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //....%@@%.........@@@...
    0x00, 0x00, 0xef, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //....@@@+.........@@@...
    0x00, 0x0a, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //...%@@@..........@@@...
    0x02, 0xbf, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //..%@@@+..........@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0415 (Е) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0416 (Ж) , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x08, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xf8, 0x00,  //.%@@@+..........@@@..........+@@@%.
    0x00, 0xaf, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xa0, 0x00,  //..%@@@+.........@@@.........+@@@%..
    0x00, 0x0b, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x04, 0xff, 0xfb, 0x00, 0x00,  //...%@@@+........@@@........+@@@%...
    0x00, 0x00, 0xcf, 0xff, 0x30, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xc0, 0x00, 0x00,  //....@@@@........@@@........@@@@....
    0x00, 0x00, 0x1d, 0xff, 0xe2, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x02, 0xef, 0xfd, 0x10, 0x00, 0x00,  //.....@@@@.......@@@.......@@@@.....
    0x00, 0x00, 0x02, 0xef, 0xfd, 0x10, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x1d, 0xff, 0xe2, 0x00, 0x00, 0x00,  //......@@@@......@@@......@@@@......
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xcf, 0xff, 0x30, 0x00, 0x00, 0x00,  //.......@@@@.....@@@.....@@@@.......
    0x00, 0x00, 0x00, 0x04, 0xff, 0xfb, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x0b, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00,  //.......+@@@%....@@@....%@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0x90, 0x00, 0xff, 0xf0, 0x00, 0x9f, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00,  //........+@@@%...@@@...%@@@+........
    0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xf8, 0x00, 0xff, 0xf0, 0x08, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%..@@@..%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0x60, 0xff, 0xf0, 0x6f, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@@+.@@@.+@@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xf4, 0xff, 0xf4, 0xff, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@+@@@+@@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0xdf, 0xfb, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xcb, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00,  //........@@@%@@@@@@@@@@@%@@@........
    0x00, 0x00, 0x00, 0x08, 0xff, 0xe1, 0x1d, 0xff, 0xff, 0xff, 0xfd, 0x11, 0xef, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.......%@@@..@@@@@@@@@..@@@%.......
    0x00, 0x00, 0x00, 0x3f, 0xff, 0x50, 0x02, 0xef, 0xff, 0xff, 0xe2, 0x00, 0x6f, 0xff, 0x30, 0x00, 0x00, 0x00,  //.......@@@+...@@@@@@@...+@@@.......
    0x00, 0x00, 0x00, 0xdf, 0xfb, 0x00, 0x00, 0x3f, 0xff, 0xff, 0x30, 0x00, 0x0b, 0xff, 0xd0, 0x00, 0x00, 0x00,  //......@@@%.....@@@@@.....%@@@......
    0x00, 0x00, 0x07, 0xff, 0xf1, 0x00, 0x00, 0x04, 0xff, 0xf4, 0x00, 0x00, 0x01, 0xff, 0xf7, 0x00, 0x00, 0x00,  //.....+@@@......+@@@+......@@@+.....
    0x00, 0x00, 0x2f, 0xff, 0x60, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x6f, 0xff, 0x20, 0x00, 0x00,  //.....@@@+.......@@@.......+@@@.....
    0x00, 0x00, 0xcf, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xc0, 0x00, 0x00,  //....@@@@........@@@........@@@@....
    0x00, 0x06, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x02, 0xff, 0xf6, 0x00, 0x00,  //...+@@@.........@@@.........@@@+...
    0x00, 0x2f, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x10, 0x00,  //...@@@+.........@@@.........+@@@...
    0x00, 0xbf, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xb0, 0x00,  //..%@@@..........@@@..........@@@%..
    0x06, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf6, 0x00,  //.+@@@...........@@@...........@@@+.
    0x1e, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfe, 0x10,  //.@@@%...........@@@...........%@@@.
    0xaf, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xa0,  //%@@@............@@@............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+0417 (З) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x16, 0xad, 0xff, 0xec, 0x94, 0x00, 0x00, 0x00,  //...+%@@@@@%+.....
    0x2a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x00, 0x00,  //.%@@@@@@@@@@@+...
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00,  //%@@@@@@@@@@@@@+..
    0xbf, 0xfc, 0x41, 0x00, 0x02, 0x6d, 0xff, 0xf3, 0x00,  //%@@@+.....+@@@@..
    0xbf, 0x70, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xfb, 0x00,  //%@+.........%@@%.
    0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfe, 0x00,  //%............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //.............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd, 0x00,  //.............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xf8, 0x00,  //............%@@%.
    0x00, 0x00, 0x00, 0x00, 0x02, 0x5c, 0xff, 0xd0, 0x00,  //..........+@@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x10, 0x00,  //....@@@@@@@@@%...
    0x00, 0x00, 0xff, 0xff, 0xff, 0xfe, 0x50, 0x00, 0x00,  //....@@@@@@@@+....
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x00,  //....@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x02, 0x5a, 0xff, 0xf4, 0x00,  //..........+%@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0x20,  //............+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0x90,  //.............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe0,  //..............@@@
    0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xb0,  //%............+@@%
    0xfd, 0x30, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x50,  //@@..........+@@@+
    0xff, 0xfa, 0x52, 0x00, 0x02, 0x5b, 0xff, 0xfc, 0x00,  //@@@%+.....+%@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00,  //@@@@@@@@@@@@@@@..
    0x4c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00,  //+@@@@@@@@@@@@+...
    0x00, 0x16, 0xad, 0xef, 0xed, 0x95, 0x00, 0x00, 0x00,  //...+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0418 (И) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xff, 0xf0,  //@@@...........%@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xf0,  //@@@...........@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xf0,  //@@@..........%@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xf0,  //@@@.........+@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf9, 0xff, 0xf0,  //@@@.........@@@%@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf1, 0xff, 0xf0,  //@@@........+@@@.@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x80, 0xff, 0xf0,  //@@@........@@@+.@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0xff, 0xf0,  //@@@.......+@@@..@@@
    0xff, 0xf0, 0x00, 0x00, 0x01, 0xef, 0xf6, 0x00, 0xff, 0xf0,  //@@@.......@@@+..@@@
    0xff, 0xf0, 0x00, 0x00, 0x08, 0xff, 0xd0, 0x00, 0xff, 0xf0,  //@@@......%@@@...@@@
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xff, 0x40, 0x00, 0xff, 0xf0,  //@@@......@@@+...@@@
    0xff, 0xf0, 0x00, 0x00, 0xaf, 0xfc, 0x00, 0x00, 0xff, 0xf0,  //@@@.....%@@%....@@@
    0xff, 0xf0, 0x00, 0x03, 0xff, 0xf3, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x0b, 0xff, 0xa0, 0x00, 0x00, 0xff, 0xf0,  //@@@....%@@%.....@@@
    0xff, 0xf0, 0x00, 0x4f, 0xff, 0x20, 0x00, 0x00, 0xff, 0xf0,  //@@@...+@@@......@@@
    0xff, 0xf0, 0x00, 0xdf, 0xf8, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...@@@%......@@@
    0xff, 0xf0, 0x06, 0xff, 0xe1, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@..+@@@.......@@@
    0xff, 0xf0, 0x0e, 0xff, 0x70, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@..@@@+.......@@@
    0xff, 0xf0, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.+@@@........@@@
    0xff, 0xf1, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.@@@+........@@@
    0xff, 0xf9, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@%@@@.........@@@
    0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@@+.........@@@
    0xff, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@%..........@@@
    0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@...........@@@
    0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@%...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0419 (Й) , Width: 19 */
    0x00, 0x00, 0x0e, 0xf0, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00,  //.....@@.....@@.....
    0x00, 0x00, 0x0a, 0xfb, 0x20, 0x2b, 0xfa, 0x00, 0x00, 0x00,  //.....%@%...%@%.....
    0x00, 0x00, 0x02, 0xff, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00,  //......@@@@@@@......
    0x00, 0x00, 0x00, 0x2a, 0xdf, 0xea, 0x20, 0x00, 0x00, 0x00,  //.......%@@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xff, 0xf0,  //@@@...........%@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xf0,  //@@@...........@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xf0,  //@@@..........%@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xf0,  //@@@.........+@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf9, 0xff, 0xf0,  //@@@.........@@@%@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf1, 0xff, 0xf0,  //@@@........+@@@.@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x80, 0xff, 0xf0,  //@@@........@@@+.@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0xff, 0xf0,  //@@@.......+@@@..@@@
    0xff, 0xf0, 0x00, 0x00, 0x01, 0xef, 0xf6, 0x00, 0xff, 0xf0,  //@@@.......@@@+..@@@
    0xff, 0xf0, 0x00, 0x00, 0x08, 0xff, 0xd0, 0x00, 0xff, 0xf0,  //@@@......%@@@...@@@
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xff, 0x40, 0x00, 0xff, 0xf0,  //@@@......@@@+...@@@
    0xff, 0xf0, 0x00, 0x00, 0xaf, 0xfc, 0x00, 0x00, 0xff, 0xf0,  //@@@.....%@@%....@@@
    0xff, 0xf0, 0x00, 0x03, 0xff, 0xf3, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x0b, 0xff, 0xa0, 0x00, 0x00, 0xff, 0xf0,  //@@@....%@@%.....@@@
    0xff, 0xf0, 0x00, 0x4f, 0xff, 0x20, 0x00, 0x00, 0xff, 0xf0,  //@@@...+@@@......@@@
    0xff, 0xf0, 0x00, 0xdf, 0xf8, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...@@@%......@@@
    0xff, 0xf0, 0x06, 0xff, 0xe1, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@..+@@@.......@@@
    0xff, 0xf0, 0x0e, 0xff, 0x70, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@..@@@+.......@@@
    0xff, 0xf0, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.+@@@........@@@
    0xff, 0xf1, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.@@@+........@@@
    0xff, 0xf9, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@%@@@.........@@@
    0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@@+.........@@@
    0xff, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@%..........@@@
    0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@...........@@@
    0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@%...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+041a (К) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xff, 0x80,  //@@@...........%@@@%.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xf9, 0x00,  //@@@..........%@@@%..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0x90, 0x00,  //@@@.........%@@@%...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x07, 0xff, 0xfa, 0x00, 0x00,  //@@@........+@@@%....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xb0, 0x00, 0x00,  //@@@.......+@@@%.....
    0xff, 0xf0, 0x00, 0x00, 0x06, 0xff, 0xfb, 0x00, 0x00, 0x00,  //@@@......+@@@%......
    0xff, 0xf0, 0x00, 0x00, 0x5f, 0xff, 0xc0, 0x00, 0x00, 0x00,  //@@@.....+@@@@.......
    0xff, 0xf0, 0x00, 0x04, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@....+@@@@........
    0xff, 0xf0, 0x00, 0x4f, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00,  //@@@...+@@@@.........
    0xff, 0xf0, 0x03, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00,  //@@@...@@@@..........
    0xff, 0xf0, 0x3f, 0xff, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00,  //@@@..@@@@@..........
    0xff, 0xf2, 0xef, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //@@@.@@@@@@%.........
    0xff, 0xfe, 0xff, 0xe6, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@+@@@+........
    0xff, 0xff, 0xfe, 0x30, 0x9f, 0xff, 0x20, 0x00, 0x00, 0x00,  //@@@@@@..%@@@........
    0xff, 0xff, 0xf3, 0x00, 0x0d, 0xff, 0xc0, 0x00, 0x00, 0x00,  //@@@@@....@@@@.......
    0xff, 0xff, 0x40, 0x00, 0x03, 0xff, 0xf7, 0x00, 0x00, 0x00,  //@@@@+.....@@@+......
    0xff, 0xf4, 0x00, 0x00, 0x00, 0x8f, 0xff, 0x20, 0x00, 0x00,  //@@@+......+@@@......
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xc0, 0x00, 0x00,  //@@@........@@@@.....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x02, 0xff, 0xf8, 0x00, 0x00,  //@@@.........@@@%....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0x30, 0x00,  //@@@.........+@@@....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xd0, 0x00,  //@@@..........%@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xef, 0xf9, 0x00,  //@@@...........@@@%..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x40,  //@@@...........+@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xe1,  //@@@............%@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xef, 0xfa,  //@@@.............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+041b (Л) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //......@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //......@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //......@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //......@@@.........@@@
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //......@@@.........@@@
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //......@@@.........@@@
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //......@@@.........@@@
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //......@@@.........@@@
    0x00, 0x00, 0x01, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //......@@@.........@@@
    0x00, 0x00, 0x02, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //......@@@.........@@@
    0x00, 0x00, 0x02, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //......@@@.........@@@
    0x00, 0x00, 0x03, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //......@@@.........@@@
    0x00, 0x00, 0x05, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //.....+@@%.........@@@
    0x00, 0x00, 0x07, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //.....+@@%.........@@@
    0x00, 0x00, 0x09, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //.....%@@%.........@@@
    0x00, 0x00, 0x0b, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //.....%@@+.........@@@
    0x00, 0x00, 0x0e, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //.....@@@..........@@@
    0x00, 0x00, 0x2f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //.....@@@..........@@@
    0x00, 0x00, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //....+@@@..........@@@
    0x00, 0x01, 0xef, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //....@@@+..........@@@
    0x00, 0x1c, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //...@@@@...........@@@
    0x27, 0xef, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //.+@@@@+...........@@@
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@%............@@@
    0xff, 0xfe, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@+.............@@@
    0xea, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@%+...............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+041c (М) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xff, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xf0,  //@@@@@.............@@@@@
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xf0,  //@@@@@%...........%@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xf0,  //@@@@@@...........@@@@@@
    0xff, 0xfc, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc, 0xff, 0xf0,  //@@@@@@+.........+@@@@@@
    0xff, 0xf6, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf6, 0xff, 0xf0,  //@@@+@@@.........@@@+@@@
    0xff, 0xf0, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0, 0xff, 0xf0,  //@@@.@@@.........@@@.@@@
    0xff, 0xf0, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x09, 0xff, 0x90, 0xff, 0xf0,  //@@@.%@@%.......%@@%.@@@
    0xff, 0xf0, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x30, 0xff, 0xf0,  //@@@..@@@.......@@@..@@@
    0xff, 0xf0, 0x0d, 0xff, 0x60, 0x00, 0x00, 0x6f, 0xfd, 0x00, 0xff, 0xf0,  //@@@..@@@+.....+@@@..@@@
    0xff, 0xf0, 0x06, 0xff, 0xc0, 0x00, 0x00, 0xcf, 0xf6, 0x00, 0xff, 0xf0,  //@@@..+@@@.....@@@+..@@@
    0xff, 0xf0, 0x01, 0xff, 0xf2, 0x00, 0x03, 0xff, 0xf1, 0x00, 0xff, 0xf0,  //@@@...@@@.....@@@...@@@
    0xff, 0xf0, 0x00, 0xaf, 0xf9, 0x00, 0x09, 0xff, 0xa0, 0x00, 0xff, 0xf0,  //@@@...%@@%...%@@%...@@@
    0xff, 0xf0, 0x00, 0x3f, 0xfe, 0x00, 0x0f, 0xff, 0x30, 0x00, 0xff, 0xf0,  //@@@....@@@...@@@....@@@
    0xff, 0xf0, 0x00, 0x0d, 0xff, 0x50, 0x6f, 0xfd, 0x00, 0x00, 0xff, 0xf0,  //@@@....@@@+.+@@@....@@@
    0xff, 0xf0, 0x00, 0x07, 0xff, 0xc0, 0xcf, 0xf7, 0x00, 0x00, 0xff, 0xf0,  //@@@....+@@@.@@@+....@@@
    0xff, 0xf0, 0x00, 0x01, 0xff, 0xf5, 0xff, 0xf1, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@+@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xaf, 0xff, 0xff, 0xa0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....%@@@@@%.....@@@
    0xff, 0xf0, 0x00, 0x00, 0x4f, 0xff, 0xff, 0x40, 0x00, 0x00, 0xff, 0xf0,  //@@@......@@@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0d, 0xff, 0xfd, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@......@@@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x07, 0xff, 0xf7, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@......+@@@+......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+041d (Н) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+041e (О) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x0d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xa0, 0x00,  //..%@@@%.........+@@@%..
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xf5, 0x00,  //.+@@@+...........+@@@+.
    0x0c, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfc, 0x00,  //.@@@%.............%@@@.
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //.@@@...............@@@.
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //+@@%...............%@@+
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+...............+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.................@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.................@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.................@@@
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+...............+@@%
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //+@@%...............%@@+
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //.@@@...............@@@.
    0x0d, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfd, 0x00,  //.@@@%.............%@@@.
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf5, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xb0, 0x00,  //..%@@@+.........+@@@%..
    0x00, 0x1d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x10, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x07, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+041f (П) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0420 (Р) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xa6, 0x00, 0x00,  //@@@@@@@@@@%+....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe5, 0x00,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@@@@@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x03, 0x8f, 0xff, 0xf1,  //@@@.......%@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf8,  //@@@.........@@@%
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc,  //@@@.........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc,  //@@@.........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf8,  //@@@.........@@@%
    0xff, 0xf0, 0x00, 0x00, 0x03, 0x8f, 0xff, 0xf1,  //@@@.......%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xa6, 0x00, 0x00,  //@@@@@@@@@@%+....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0421 (С) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x04, 0x8c, 0xdf, 0xfe, 0xda, 0x61, 0x00,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x05, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb3,  //.....+@@@@@@@@@@@@%.
    0x00, 0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x00, 0x0c, 0xff, 0xfe, 0x84, 0x10, 0x01, 0x48, 0xdf, 0xff,  //...@@@@@%+....+%@@@@
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x05, 0xdf,  //..%@@@+..........+@@
    0x05, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a,  //.+@@@+.............%
    0x0c, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%...............
    0x3f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x0c, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%...............
    0x05, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a,  //.+@@@+.............%
    0x00, 0xaf, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x05, 0xdf,  //..%@@@+..........+@@
    0x00, 0x0c, 0xff, 0xfe, 0x84, 0x10, 0x01, 0x48, 0xdf, 0xff,  //...@@@@@%+....+%@@@@
    0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x00, 0x00, 0x05, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb3,  //.....+@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x04, 0x8c, 0xdf, 0xfe, 0xda, 0x61, 0x00,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+0422 (Т) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0423 (У) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0xcf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc,  //@@@+............+@@@
    0x5f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xf5,  //+@@@............@@@+
    0x0e, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xe0,  //.@@@+..........+@@@.
    0x07, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x80,  //.+@@@..........%@@%.
    0x00, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //..@@@..........@@@..
    0x00, 0x9f, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfa, 0x00,  //..%@@%........%@@%..
    0x00, 0x2f, 0xff, 0x20, 0x00, 0x00, 0x00, 0xff, 0xf3, 0x00,  //...@@@........@@@...
    0x00, 0x0b, 0xff, 0x90, 0x00, 0x00, 0x07, 0xff, 0xd0, 0x00,  //...%@@%......+@@@...
    0x00, 0x03, 0xff, 0xf0, 0x00, 0x00, 0x0d, 0xff, 0x60, 0x00,  //....@@@......@@@+...
    0x00, 0x00, 0xcf, 0xf7, 0x00, 0x00, 0x4f, 0xfe, 0x00, 0x00,  //....@@@+....+@@@....
    0x00, 0x00, 0x5f, 0xfe, 0x00, 0x00, 0xbf, 0xf8, 0x00, 0x00,  //....+@@@....%@@%....
    0x00, 0x00, 0x0e, 0xff, 0x50, 0x02, 0xff, 0xf2, 0x00, 0x00,  //.....@@@+...@@@.....
    0x00, 0x00, 0x07, 0xff, 0xc0, 0x08, 0xff, 0xb0, 0x00, 0x00,  //.....+@@@..%@@%.....
    0x00, 0x00, 0x01, 0xff, 0xf3, 0x0e, 0xff, 0x40, 0x00, 0x00,  //......@@@..@@@+.....
    0x00, 0x00, 0x00, 0x9f, 0xfa, 0x6f, 0xfd, 0x00, 0x00, 0x00,  //......%@@%+@@@......
    0x00, 0x00, 0x00, 0x2f, 0xff, 0xdf, 0xf6, 0x00, 0x00, 0x00,  //.......@@@@@@+......
    0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,  //.......%@@@@@.......
    0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00,  //.......+@@@@%.......
    0x00, 0x00, 0x00, 0x00, 0xdf, 0xff, 0x20, 0x00, 0x00, 0x00,  //........@@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00,  //........@@@%........
    0x00, 0x00, 0x00, 0x06, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00,  //.......+@@@+........
    0x00, 0x00, 0x01, 0x5e, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00,  //......+@@@@.........
    0x00, 0x0f, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@+.........
    0x00, 0x0f, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@%..........
    0x00, 0x0f, 0xfe, 0xda, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@%+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+0424 (Ф) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x16, 0xac, 0xef, 0xff, 0xec, 0xa6, 0x10, 0x00, 0x00, 0x00,  //.......+%@@@@@@@%+.......
    0x00, 0x00, 0x3a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x30, 0x00, 0x00,  //.....%@@@@@@@@@@@@@%.....
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@@@%...
    0x00, 0x9f, 0xff, 0xfb, 0x73, 0x1f, 0xff, 0x13, 0x7b, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@%+..@@@..+%@@@@%..
    0x07, 0xff, 0xfc, 0x20, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x2c, 0xff, 0xf7, 0x00,  //.+@@@@.....@@@.....%@@@+.
    0x1e, 0xff, 0xa0, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0xaf, 0xff, 0x10,  //.@@@%......@@@......%@@@.
    0x6f, 0xfd, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x60,  //+@@@.......@@@.......@@@+
    0xbf, 0xf6, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x06, 0xff, 0xb0,  //%@@+.......@@@.......+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x01, 0xff, 0xd0,  //@@@........@@@........@@@
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+.......@@@.......+@@%
    0x6f, 0xfb, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x60,  //+@@%.......@@@.......%@@+
    0x1f, 0xff, 0x50, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x10,  //.@@@+......@@@......+@@@.
    0x07, 0xff, 0xf6, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x06, 0xff, 0xf7, 0x00,  //.+@@@+.....@@@.....+@@@+.
    0x00, 0xaf, 0xff, 0xd6, 0x10, 0x0f, 0xff, 0x00, 0x16, 0xdf, 0xff, 0xa0, 0x00,  //..%@@@@+...@@@...+@@@@%..
    0x00, 0x08, 0xff, 0xff, 0xfd, 0xbf, 0xff, 0xbe, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@%@@@%@@@@@@%...
    0x00, 0x00, 0x3b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x30, 0x00, 0x00,  //.....%@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x16, 0xac, 0xef, 0xff, 0xec, 0xa6, 0x10, 0x00, 0x00, 0x00,  //.......+%@@@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+0425 (Х) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x0a, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xfa, 0x00,  //.%@@@...........@@@%.
    0x01, 0xef, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xe1, 0x00,  //..@@@%.........%@@@..
    0x00, 0x5f, 0xff, 0x30, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x50, 0x00,  //..+@@@.........@@@+..
    0x00, 0x0b, 0xff, 0xd0, 0x00, 0x00, 0x00, 0xdf, 0xfb, 0x00, 0x00,  //...%@@@.......@@@%...
    0x00, 0x01, 0xff, 0xf8, 0x00, 0x00, 0x08, 0xff, 0xe1, 0x00, 0x00,  //....@@@%.....%@@@....
    0x00, 0x00, 0x6f, 0xff, 0x30, 0x00, 0x3f, 0xff, 0x60, 0x00, 0x00,  //....+@@@.....@@@+....
    0x00, 0x00, 0x0b, 0xff, 0xd0, 0x00, 0xdf, 0xfb, 0x00, 0x00, 0x00,  //.....%@@@...@@@%.....
    0x00, 0x00, 0x02, 0xff, 0xf8, 0x08, 0xff, 0xf1, 0x00, 0x00, 0x00,  //......@@@%.%@@@......
    0x00, 0x00, 0x00, 0x7f, 0xff, 0x6f, 0xff, 0x60, 0x00, 0x00, 0x00,  //......+@@@+@@@+......
    0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@%.......
    0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //........@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //........%@@@+........
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //........@@@@@........
    0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@+.......
    0x00, 0x00, 0x00, 0x2f, 0xff, 0xdf, 0xff, 0x20, 0x00, 0x00, 0x00,  //.......@@@@@@@.......
    0x00, 0x00, 0x00, 0xcf, 0xfc, 0x0d, 0xff, 0xc0, 0x00, 0x00, 0x00,  //......@@@@.@@@%......
    0x00, 0x00, 0x06, 0xff, 0xf2, 0x03, 0xff, 0xf6, 0x00, 0x00, 0x00,  //.....+@@@...@@@+.....
    0x00, 0x00, 0x2f, 0xff, 0x70, 0x00, 0x8f, 0xff, 0x10, 0x00, 0x00,  //.....@@@+...%@@@.....
    0x00, 0x00, 0xbf, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0xb0, 0x00, 0x00,  //....%@@@.....@@@%....
    0x00, 0x06, 0xff, 0xf3, 0x00, 0x00, 0x03, 0xff, 0xf6, 0x00, 0x00,  //...+@@@.......@@@+...
    0x00, 0x1e, 0xff, 0x80, 0x00, 0x00, 0x00, 0x9f, 0xfe, 0x10, 0x00,  //...@@@%.......%@@@...
    0x00, 0xbf, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xb0, 0x00,  //..%@@@.........@@@%..
    0x05, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xf5, 0x00,  //.+@@@..........+@@@+.
    0x1e, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfe, 0x10,  //.@@@%...........%@@@.
    0xaf, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xa0,  //%@@@.............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0426 (Ц) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+0427 (Ч) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xbf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //%@@+..........@@@
    0x8f, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //+@@@..........@@@
    0x1f, 0xff, 0xd5, 0x10, 0x00, 0x00, 0x00, 0xff, 0xf0,  //.@@@@+........@@@
    0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.+@@@@@@@@@@@@@@@
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..%@@@@@@@@@@@@@@
    0x00, 0x03, 0x9d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //....%@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0428 (Ш) , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+0429 (Щ) , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //...............................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //...............................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //...............................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //...............................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //...............................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+042a (Ъ) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@...............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xc9, 0x30, 0x00, 0x00,  //.......@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x30, 0x00,  //.......@@@@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00,  //.......@@@@@@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x01, 0x49, 0xff, 0xfe, 0x10,  //.......@@@........+%@@@@.
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x70,  //.......@@@...........@@@+
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //.......@@@...........+@@@
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //.......@@@............@@@
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //.......@@@............@@@
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //.......@@@............@@@
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //.......@@@...........+@@@
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0x70,  //.......@@@...........@@@+
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x01, 0x49, 0xff, 0xff, 0x10,  //.......@@@........+%@@@@.
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00,  //.......@@@@@@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x40, 0x00,  //.......@@@@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xc9, 0x40, 0x00, 0x00,  //.......@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+042b (Ы) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x93, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@@@@@@@@%.......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x00, 0x00, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@+...@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x14, 0x9f, 0xff, 0xe1, 0x00, 0xff, 0xf0,  //@@@.........%@@@@...@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf7, 0x00, 0xff, 0xf0,  //@@@...........@@@+..@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc, 0x00, 0xff, 0xf0,  //@@@...........+@@@..@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe, 0x00, 0xff, 0xf0,  //@@@............@@@..@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0xff, 0xf0,  //@@@............@@@..@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe, 0x00, 0xff, 0xf0,  //@@@............@@@..@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc, 0x00, 0xff, 0xf0,  //@@@...........+@@@..@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf7, 0x00, 0xff, 0xf0,  //@@@...........@@@+..@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x14, 0x9f, 0xff, 0xf1, 0x00, 0xff, 0xf0,  //@@@.........%@@@@...@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@+...@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x00, 0x00, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x94, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@@@@@@@@%+......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+042c (Ь) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x93, 0x00, 0x00,  //@@@@@@@@@@@@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x14, 0x9f, 0xff, 0xe1,  //@@@.........%@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf7,  //@@@...........@@@+
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc,  //@@@...........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc,  //@@@...........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf7,  //@@@...........@@@+
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x14, 0x9f, 0xff, 0xf1,  //@@@.........%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x94, 0x00, 0x00,  //@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+042d (Э) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x16, 0xad, 0xef, 0xfd, 0xc8, 0x40, 0x00, 0x00, 0x00,  //...+%@@@@@@%+.......
    0x3b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x50, 0x00, 0x00,  //.%@@@@@@@@@@@@+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00,  //@@@@@@@@@@@@@@@%....
    0xff, 0xfe, 0x84, 0x20, 0x01, 0x37, 0xcf, 0xff, 0xc0, 0x00,  //@@@@%+.....+@@@@@...
    0xfe, 0x60, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xfa, 0x00,  //@@+..........+@@@%..
    0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x50,  //%..............@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xc0,  //...............+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xf3,  //................@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xf7,  //................%@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xfb,  //.................@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfd,  //.................@@@
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,  //...@@@@@@@@@@@@@@@@@
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@@@@@@@@@@@@
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,  //...@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfd,  //.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xfb,  //.................@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xf7,  //................%@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xf3,  //................@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xc0,  //...............+@@@.
    0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x50,  //%..............@@@+.
    0xfe, 0x50, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xfa, 0x00,  //@@+..........+@@@%..
    0xff, 0xfe, 0x84, 0x20, 0x01, 0x37, 0xcf, 0xff, 0xc0, 0x00,  //@@@@%+.....+@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00,  //@@@@@@@@@@@@@@@%....
    0x3b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x50, 0x00, 0x00,  //.%@@@@@@@@@@@@+.....
    0x00, 0x16, 0xad, 0xef, 0xfe, 0xc8, 0x40, 0x00, 0x00, 0x00,  //...+%@@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+042e (Ю) , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //@@@............+%@@@@@%+.......
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //@@@..........+@@@@@@@@@@@+.....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //@@@.........@@@@@@@@@@@@@@@....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x00, 0x00,  //@@@........@@@@@+.....+@@@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xbf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xa0, 0x00,  //@@@.......%@@@%.........+@@@%..
    0xff, 0xf0, 0x00, 0x00, 0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xf5, 0x00,  //@@@......+@@@+...........+@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x0d, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfc, 0x00,  //@@@......@@@%.............%@@@.
    0xff, 0xf0, 0x00, 0x00, 0x4f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //@@@.....+@@@...............@@@.
    0xff, 0xf0, 0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //@@@.....%@@%...............%@@+
    0xff, 0xf0, 0x00, 0x00, 0xcf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //@@@.....@@@+...............+@@%
    0xff, 0xf0, 0x00, 0x00, 0xef, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.....@@@.................@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@@@@@@@@@.................@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@@@@@@@.................@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@@@@@@@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0xef, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.....@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0xcf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //@@@.....@@@+...............+@@%
    0xff, 0xf0, 0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //@@@.....%@@%...............%@@+
    0xff, 0xf0, 0x00, 0x00, 0x4f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //@@@.....+@@@...............@@@.
    0xff, 0xf0, 0x00, 0x00, 0x0d, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfc, 0x00,  //@@@......@@@%.............%@@@.
    0xff, 0xf0, 0x00, 0x00, 0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xf5, 0x00,  //@@@......+@@@+...........+@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xbf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xa0, 0x00,  //@@@.......%@@@+.........+@@@%..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x00, 0x00,  //@@@........@@@@@+.....+@@@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //@@@.........@@@@@@@@@@@@@@%....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //@@@..........+@@@@@@@@@@@+.....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //@@@............+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+042f (Я) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x06, 0xad, 0xef, 0xff, 0xff, 0xff, 0xff,  //.....+%@@@@@@@@@@@
    0x00, 0x05, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...+@@@@@@@@@@@@@@
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..+@@@@@@@@@@@@@@@
    0x02, 0xff, 0xfe, 0x72, 0x00, 0x00, 0x00, 0x0f, 0xff,  //..@@@@+........@@@
    0x08, 0xff, 0xe1, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.%@@@..........@@@
    0x0d, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.@@@+..........@@@
    0x0f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.@@@...........@@@
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.@@@...........@@@
    0x0e, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.@@@...........@@@
    0x0a, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.%@@+..........@@@
    0x04, 0xff, 0xe1, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.+@@@..........@@@
    0x00, 0xaf, 0xfe, 0x72, 0x00, 0x00, 0x00, 0x0f, 0xff,  //..%@@@+........@@@
    0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...+@@@@@@@@@@@@@@
    0x00, 0x00, 0x18, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....%@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff,  //......+@@@@@@@@@@@
    0x00, 0x00, 0x01, 0xef, 0xf8, 0x00, 0x00, 0x0f, 0xff,  //......@@@%.....@@@
    0x00, 0x00, 0x0a, 0xff, 0xe0, 0x00, 0x00, 0x0f, 0xff,  //.....%@@@......@@@
    0x00, 0x00, 0x4f, 0xff, 0x40, 0x00, 0x00, 0x0f, 0xff,  //....+@@@+......@@@
    0x00, 0x00, 0xdf, 0xfa, 0x00, 0x00, 0x00, 0x0f, 0xff,  //....@@@%.......@@@
    0x00, 0x08, 0xff, 0xe1, 0x00, 0x00, 0x00, 0x0f, 0xff,  //...%@@@........@@@
    0x00, 0x2f, 0xff, 0x60, 0x00, 0x00, 0x00, 0x0f, 0xff,  //...@@@+........@@@
    0x00, 0xcf, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //..@@@%.........@@@
    0x06, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.+@@@..........@@@
    0x1f, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.@@@+..........@@@
    0xaf, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //%@@@...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0430 (а) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x02, 0x8b, 0xef, 0xed, 0xa5, 0x00, 0x00,  //....%%@@@@%+....
    0x04, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x00,  //..%@@@@@@@@@@...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //.@@@@@@@@@@@@@..
    0x0f, 0xfb, 0x62, 0x10, 0x03, 0x8e, 0xff, 0xe0,  //.@@%+.....+@@@@.
    0x0b, 0x20, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xf5,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xfa,  //............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //.............@@@
    0x00, 0x02, 0x7b, 0xef, 0xff, 0xff, 0xff, 0xfe,  //....+%@@@@@@@@@@
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@
    0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x6f, 0xff, 0xb6, 0x31, 0x00, 0x00, 0x0f, 0xff,  //+@@@%+.......@@@
    0xcf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,  //@@@%.........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff,  //@@@.........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff,  //@@@.........@@@@
    0xdf, 0xf7, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff,  //@@@+.......%@@@@
    0x9f, 0xff, 0x93, 0x10, 0x16, 0xdf, 0xff, 0xff,  //%@@@%....+@@@@@@
    0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,  //.@@@@@@@@@@@%@@@
    0x03, 0xef, 0xff, 0xff, 0xff, 0xf8, 0x0f, 0xff,  //..@@@@@@@@@+.@@@
    0x00, 0x17, 0xce, 0xfe, 0xc8, 0x20, 0x0f, 0xff,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0431 (б) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,  //..................
    0x00, 0x00, 0x00, 0x03, 0x7b, 0xde, 0xff, 0xff, 0x40,  //........+%@@@@@@+.
    0x00, 0x00, 0x05, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x90,  //.....+@@@@@@@@@@%.
    0x00, 0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,  //....%@@@@@@@@@@@%.
    0x00, 0x0b, 0xff, 0xff, 0xb7, 0x53, 0x21, 0x00, 0x00,  //...%@@@@%++.......
    0x00, 0x7f, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@%...........
    0x01, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@+............
    0x07, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@+.............
    0x0d, 0xff, 0x03, 0x9d, 0xef, 0xec, 0x71, 0x00, 0x00,  //.@@@..%@@@@@+.....
    0x0f, 0xfc, 0xaf, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00,  //.@@@%@@@@@@@@@+...
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00,  //.@@@@@@@@@@@@@@%..
    0x2f, 0xff, 0xff, 0xd5, 0x10, 0x15, 0xdf, 0xff, 0x60,  //.@@@@@@+...+@@@@+.
    0x2f, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xe0,  //.@@@@%.......%@@@.
    0x1f, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x01, 0xef, 0xf6,  //.@@@@.........@@@+
    0x1f, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfa,  //.@@@+.........+@@%
    0x1f, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfd,  //.@@@...........@@@
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //.@@@...........@@@
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.@@@...........@@@
    0x0e, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //.@@@...........@@@
    0x0d, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfd,  //.@@@...........@@@
    0x0a, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfa,  //.%@@+.........+@@%
    0x06, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x01, 0xef, 0xf6,  //.+@@@.........@@@+
    0x00, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xe0,  //..@@@%.......%@@@.
    0x00, 0x7f, 0xff, 0xd5, 0x10, 0x15, 0xdf, 0xff, 0x60,  //..+@@@@+...+@@@@+.
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00,  //...%@@@@@@@@@@@%..
    0x00, 0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //....%@@@@@@@@@%...
    0x00, 0x00, 0x02, 0x8c, 0xef, 0xec, 0x82, 0x00, 0x00,  //......%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0432 (в) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xff, 0xec, 0x92, 0x00, 0x00,  //@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //@@@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00,  //@@@@@@@@@@@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x27, 0xff, 0xfd, 0x00,  //@@@......+@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x4f, 0xff, 0x00,  //@@@.......+@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xfe, 0x00,  //@@@........@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x4f, 0xfa, 0x00,  //@@@.......+@@%.
    0xff, 0xf0, 0x00, 0x00, 0x28, 0xff, 0xd1, 0x00,  //@@@......%@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00,  //@@@@@@@@@@@+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x70, 0x00,  //@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00,  //@@@@@@@@@@@@@%.
    0xff, 0xf0, 0x00, 0x00, 0x02, 0x7f, 0xff, 0x70,  //@@@.......+@@@+
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //@@@........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x04, 0xff, 0xe0,  //@@@........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x02, 0x7f, 0xff, 0xa0,  //@@@.......+@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x00,  //@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xa6, 0x00, 0x00,  //@@@@@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0433 (г) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0434 (д) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.....@@@@@@@@@@@@...
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.....@@@@@@@@@@@@...
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //.....@@@@@@@@@@@@...
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //.....@@@......@@@...
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //.....@@@......@@@...
    0x00, 0x00, 0x1f, 0xff, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //.....@@@......@@@...
    0x00, 0x00, 0x1f, 0xff, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //.....@@@......@@@...
    0x00, 0x00, 0x2f, 0xfe, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //.....@@@......@@@...
    0x00, 0x00, 0x4f, 0xfd, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //....+@@@......@@@...
    0x00, 0x00, 0x6f, 0xfb, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //....+@@%......@@@...
    0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //....%@@%......@@@...
    0x00, 0x00, 0xdf, 0xf5, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //....@@@+......@@@...
    0x00, 0x01, 0xff, 0xf1, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //....@@@.......@@@...
    0x00, 0x07, 0xff, 0xc0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //...+@@@.......@@@...
    0x00, 0x1e, 0xff, 0x50, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //...@@@+.......@@@...
    0x03, 0xdf, 0xfd, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //..@@@@........@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+0435 (е) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x50, 0x00, 0x00,  //.....+%@@@@%+....
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfd, 0x20, 0x00,  //...+@@@@@@@@@@...
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00,  //..+@@@@@@@@@@@@..
    0x04, 0xff, 0xfb, 0x51, 0x00, 0x27, 0xef, 0xfc, 0x00,  //..@@@%+....+@@@@.
    0x0d, 0xff, 0x50, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x50,  //.@@@+........@@@+
    0x4f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xa0,  //+@@%.........+@@%
    0x9f, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xd0,  //%@@...........@@@
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xaf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0x5f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0x0d, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x00,  //.@@@@..........%.
    0x04, 0xff, 0xfe, 0x83, 0x00, 0x13, 0x6c, 0xff, 0x00,  //.+@@@@%.....+@@@.
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x00, 0x04, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00,  //...+@@@@@@@@@@@+.
    0x00, 0x00, 0x05, 0xad, 0xef, 0xec, 0x83, 0x00, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0436 (ж) , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x08, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x09, 0xff, 0xf8, 0x00,  //.%@@@%.......@@@.......%@@@%.
    0x00, 0x9f, 0xff, 0x80, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x8f, 0xff, 0x90, 0x00,  //..%@@@%......@@@......%@@@%..
    0x00, 0x0a, 0xff, 0xf7, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x07, 0xff, 0xfa, 0x00, 0x00,  //...%@@@+.....@@@.....+@@@%...
    0x00, 0x00, 0xbf, 0xff, 0x60, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x6f, 0xff, 0xb0, 0x00, 0x00,  //....%@@@+....@@@....+@@@%....
    0x00, 0x00, 0x0c, 0xff, 0xf5, 0x00, 0x0f, 0xff, 0x00, 0x05, 0xff, 0xfc, 0x00, 0x00, 0x00,  //.....%@@@+...@@@...+@@@%.....
    0x00, 0x00, 0x00, 0xcf, 0xff, 0x40, 0x0f, 0xff, 0x00, 0x4f, 0xff, 0xc0, 0x00, 0x00, 0x00,  //......@@@@+..@@@..+@@@@......
    0x00, 0x00, 0x00, 0x1d, 0xff, 0xf3, 0x0f, 0xff, 0x03, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00,  //.......@@@@..@@@..@@@@.......
    0x00, 0x00, 0x00, 0x05, 0xff, 0xfe, 0x3f, 0xff, 0x3e, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@.@@@.@@@@+.......
    0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xef, 0xff, 0xef, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x9f, 0xfe, 0xef, 0xff, 0xff, 0xff, 0xee, 0xff, 0x90, 0x00, 0x00, 0x00,  //......%@@@@@@@@@@@@@@@%......
    0x00, 0x00, 0x04, 0xff, 0xf5, 0x3f, 0xff, 0xff, 0xff, 0x35, 0xff, 0xf4, 0x00, 0x00, 0x00,  //.....+@@@+.@@@@@@@.+@@@+.....
    0x00, 0x00, 0x0e, 0xff, 0xa0, 0x04, 0xff, 0xff, 0xf4, 0x00, 0xaf, 0xfe, 0x00, 0x00, 0x00,  //.....@@@%...@@@@@...%@@@.....
    0x00, 0x00, 0xaf, 0xfe, 0x10, 0x00, 0x4f, 0xff, 0x40, 0x00, 0x1e, 0xff, 0xa0, 0x00, 0x00,  //....%@@@....+@@@+....@@@%....
    0x00, 0x04, 0xff, 0xf4, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x04, 0xff, 0xf4, 0x00, 0x00,  //...+@@@+.....@@@.....+@@@+...
    0x00, 0x1e, 0xff, 0xa0, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0xaf, 0xfe, 0x10, 0x00,  //...@@@%......@@@......%@@@...
    0x00, 0xaf, 0xfe, 0x10, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xa0, 0x00,  //..%@@@.......@@@.......@@@%..
    0x05, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x04, 0xff, 0xf4, 0x00,  //.+@@@+.......@@@.......+@@@+.
    0x1e, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xfe, 0x10,  //.@@@%........@@@........%@@@.
    0xaf, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xa0,  //%@@@.........@@@.........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+0437 (з) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x02, 0x6a, 0xdf, 0xfe, 0xc8, 0x20, 0x00,  //..+%@@@@@%....
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00,  //.@@@@@@@@@@+..
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,  //.@@@@@@@@@@@+.
    0x0d, 0x84, 0x20, 0x02, 0x8f, 0xff, 0xc0,  //.@%+....%@@@@.
    0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf0,  //.........+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xd0,  //..........@@@.
    0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0x80,  //.........+@@%.
    0x00, 0x00, 0x00, 0x02, 0x7f, 0xfb, 0x00,  //........+@@%..
    0x00, 0x00, 0xff, 0xff, 0xfc, 0x50, 0x00,  //....@@@@@@+...
    0x00, 0x00, 0xff, 0xff, 0xff, 0xc5, 0x00,  //....@@@@@@@+..
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xa0,  //....@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xf8,  //.........%@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfe,  //..........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfd,  //..........+@@@
    0xd8, 0x42, 0x00, 0x01, 0x5a, 0xff, 0xf8,  //@++.....+%@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x10,  //@@@@@@@@@@@%..
    0x26, 0xad, 0xef, 0xfe, 0xc8, 0x30, 0x00,  //.+%@@@@@%%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0438 (и) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff,  //@@@.........@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff,  //@@@........@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff,  //@@@.......+@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff,  //@@@.......@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x0b, 0xff, 0xcf, 0xff,  //@@@......%@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x5f, 0xff, 0x3f, 0xff,  //@@@.....+@@@.@@@
    0xff, 0xf0, 0x00, 0x00, 0xef, 0xf9, 0x0f, 0xff,  //@@@.....@@@%.@@@
    0xff, 0xf0, 0x00, 0x09, 0xff, 0xe0, 0x0f, 0xff,  //@@@....%@@@..@@@
    0xff, 0xf0, 0x00, 0x3f, 0xff, 0x50, 0x0f, 0xff,  //@@@....@@@+..@@@
    0xff, 0xf0, 0x00, 0xcf, 0xfb, 0x00, 0x0f, 0xff,  //@@@...@@@%...@@@
    0xff, 0xf0, 0x06, 0xff, 0xf2, 0x00, 0x0f, 0xff,  //@@@..+@@@....@@@
    0xff, 0xf0, 0x1f, 0xff, 0x80, 0x00, 0x0f, 0xff,  //@@@..@@@%....@@@
    0xff, 0xf0, 0xaf, 0xfd, 0x00, 0x00, 0x0f, 0xff,  //@@@.%@@@.....@@@
    0xff, 0xf4, 0xff, 0xf4, 0x00, 0x00, 0x0f, 0xff,  //@@@+@@@+.....@@@
    0xff, 0xfd, 0xff, 0xa0, 0x00, 0x00, 0x0f, 0xff,  //@@@@@@%......@@@
    0xff, 0xff, 0xff, 0x10, 0x00, 0x00, 0x0f, 0xff,  //@@@@@@.......@@@
    0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@@@+.......@@@
    0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@@@........@@@
    0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0439 (й) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x0e, 0xf2, 0x00, 0x00, 0x3f, 0xe0, 0x00,  //...@@......@@...
    0x00, 0x0c, 0xfd, 0x40, 0x04, 0xdf, 0xc0, 0x00,  //...%@@....@@%...
    0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00,  //...+@@@@@@@@+...
    0x00, 0x00, 0xbf, 0xff, 0xff, 0xfb, 0x00, 0x00,  //....%@@@@@@%....
    0x00, 0x00, 0x07, 0xdf, 0xfd, 0x70, 0x00, 0x00,  //.....+@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff,  //@@@.........@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xff,  //@@@........@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff,  //@@@.......+@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff,  //@@@.......@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x0b, 0xff, 0xcf, 0xff,  //@@@......%@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x5f, 0xff, 0x3f, 0xff,  //@@@.....+@@@.@@@
    0xff, 0xf0, 0x00, 0x00, 0xef, 0xf9, 0x0f, 0xff,  //@@@.....@@@%.@@@
    0xff, 0xf0, 0x00, 0x09, 0xff, 0xe0, 0x0f, 0xff,  //@@@....%@@@..@@@
    0xff, 0xf0, 0x00, 0x3f, 0xff, 0x50, 0x0f, 0xff,  //@@@....@@@+..@@@
    0xff, 0xf0, 0x00, 0xcf, 0xfb, 0x00, 0x0f, 0xff,  //@@@...@@@%...@@@
    0xff, 0xf0, 0x06, 0xff, 0xf2, 0x00, 0x0f, 0xff,  //@@@..+@@@....@@@
    0xff, 0xf0, 0x1f, 0xff, 0x80, 0x00, 0x0f, 0xff,  //@@@..@@@%....@@@
    0xff, 0xf0, 0xaf, 0xfd, 0x00, 0x00, 0x0f, 0xff,  //@@@.%@@@.....@@@
    0xff, 0xf4, 0xff, 0xf4, 0x00, 0x00, 0x0f, 0xff,  //@@@+@@@+.....@@@
    0xff, 0xfd, 0xff, 0xa0, 0x00, 0x00, 0x0f, 0xff,  //@@@@@@%......@@@
    0xff, 0xff, 0xff, 0x10, 0x00, 0x00, 0x0f, 0xff,  //@@@@@@.......@@@
    0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@@@+.......@@@
    0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@@@........@@@
    0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+043a (к) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x9f, 0xff, 0x80,  //@@@.......%@@@%.
    0xff, 0xf0, 0x00, 0x00, 0x08, 0xff, 0xf9, 0x00,  //@@@......%@@@%..
    0xff, 0xf0, 0x00, 0x00, 0x7f, 0xff, 0xa0, 0x00,  //@@@.....+@@@%...
    0xff, 0xf0, 0x00, 0x06, 0xff, 0xfb, 0x00, 0x00,  //@@@....+@@@%....
    0xff, 0xf0, 0x00, 0x5f, 0xff, 0xc0, 0x00, 0x00,  //@@@...+@@@%.....
    0xff, 0xf0, 0x04, 0xff, 0xfc, 0x00, 0x00, 0x00,  //@@@..+@@@@......
    0xff, 0xf0, 0x3f, 0xff, 0xd1, 0x00, 0x00, 0x00,  //@@@..@@@@.......
    0xff, 0xf3, 0xef, 0xff, 0x50, 0x00, 0x00, 0x00,  //@@@.@@@@+.......
    0xff, 0xfe, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00,  //@@@@@@@@@.......
    0xff, 0xff, 0xfe, 0xff, 0xf9, 0x00, 0x00, 0x00,  //@@@@@@@@@%......
    0xff, 0xff, 0xf3, 0x6f, 0xff, 0x30, 0x00, 0x00,  //@@@@@.+@@@......
    0xff, 0xff, 0x30, 0x0b, 0xff, 0xd0, 0x00, 0x00,  //@@@@...%@@@.....
    0xff, 0xf4, 0x00, 0x01, 0xef, 0xf9, 0x00, 0x00,  //@@@+....@@@%....
    0xff, 0xf0, 0x00, 0x00, 0x5f, 0xff, 0x40, 0x00,  //@@@.....+@@@+...
    0xff, 0xf0, 0x00, 0x00, 0x0a, 0xff, 0xe0, 0x00,  //@@@......%@@@...
    0xff, 0xf0, 0x00, 0x00, 0x01, 0xef, 0xfa, 0x00,  //@@@.......@@@%..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x40,  //@@@.......+@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xe1,  //@@@........%@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x01, 0xef, 0xfa,  //@@@.........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+043b (л) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....@@@@@@@@@@@@@
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....@@@@@@@@@@@@@
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....@@@@@@@@@@@@@
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.....@@@.......@@@
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.....@@@.......@@@
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.....@@@.......@@@
    0x00, 0x00, 0x1f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.....@@@.......@@@
    0x00, 0x00, 0x2f, 0xfe, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.....@@@.......@@@
    0x00, 0x00, 0x3f, 0xfd, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.....@@@.......@@@
    0x00, 0x00, 0x4f, 0xfc, 0x00, 0x00, 0x00, 0x0f, 0xff,  //....+@@@.......@@@
    0x00, 0x00, 0x6f, 0xfa, 0x00, 0x00, 0x00, 0x0f, 0xff,  //....+@@%.......@@@
    0x00, 0x00, 0x9f, 0xf8, 0x00, 0x00, 0x00, 0x0f, 0xff,  //....%@@%.......@@@
    0x00, 0x00, 0xdf, 0xf5, 0x00, 0x00, 0x00, 0x0f, 0xff,  //....@@@+.......@@@
    0x00, 0x02, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x0f, 0xff,  //....@@@........@@@
    0x00, 0x1c, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //...@@@@........@@@
    0x16, 0xef, 0xff, 0x40, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.+@@@@+........@@@
    0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@@@%.........@@@
    0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@@+..........@@@
    0xeb, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@%+............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+043c (м) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xf0,  //@@@@@.........@@@@@
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xf0,  //@@@@@%.......%@@@@@
    0xff, 0xff, 0xff, 0x10, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xf0,  //@@@@@@.......@@@@@@
    0xff, 0xfc, 0xff, 0x70, 0x00, 0x00, 0x7f, 0xfc, 0xff, 0xf0,  //@@@@@@+.....+@@@@@@
    0xff, 0xf5, 0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf5, 0xff, 0xf0,  //@@@+@@@.....@@@+@@@
    0xff, 0xf0, 0xef, 0xf4, 0x00, 0x04, 0xff, 0xe0, 0xff, 0xf0,  //@@@.@@@+...+@@@.@@@
    0xff, 0xf0, 0x8f, 0xfb, 0x00, 0x0b, 0xff, 0x80, 0xff, 0xf0,  //@@@.%@@%...%@@%.@@@
    0xff, 0xf0, 0x1f, 0xff, 0x20, 0x2f, 0xff, 0x20, 0xff, 0xf0,  //@@@..@@@...@@@..@@@
    0xff, 0xf0, 0x0b, 0xff, 0x80, 0x8f, 0xfb, 0x00, 0xff, 0xf0,  //@@@..%@@%.%@@%..@@@
    0xff, 0xf0, 0x04, 0xff, 0xe0, 0xef, 0xf4, 0x00, 0xff, 0xf0,  //@@@..+@@@.@@@+..@@@
    0xff, 0xf0, 0x00, 0xdf, 0xfb, 0xff, 0xd0, 0x00, 0xff, 0xf0,  //@@@...@@@%@@@...@@@
    0xff, 0xf0, 0x00, 0x7f, 0xff, 0xff, 0x70, 0x00, 0xff, 0xf0,  //@@@...+@@@@@+...@@@
    0xff, 0xf0, 0x00, 0x1f, 0xff, 0xff, 0x10, 0x00, 0xff, 0xf0,  //@@@....@@@@@....@@@
    0xff, 0xf0, 0x00, 0x09, 0xff, 0xf9, 0x00, 0x00, 0xff, 0xf0,  //@@@....%@@@%....@@@
    0xff, 0xf0, 0x00, 0x03, 0xff, 0xf3, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+043d (н) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+043e (о) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x28, 0xce, 0xfe, 0xc8, 0x20, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@@@@@%..
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //.+@@@@+...+@@@@+.
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x60,  //+@@@.........@@@+
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xa0,  //%@@+.........+@@%
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0,  //%@@+.........+@@%
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x60,  //+@@@.........@@@+
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //.+@@@@+...+@@@@+.
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x00, 0x28, 0xce, 0xfe, 0xc8, 0x20, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+043f (п) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0440 (р) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xf0, 0x03, 0x9d, 0xef, 0xd9, 0x30, 0x00, 0x00,  //@@@...%@@@@%.....
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //@@@.%@@@@@@@@%...
    0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //@@@%@@@@@@@@@@%..
    0xff, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //@@@@%.......%@@@.
    0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x50,  //@@@@.........@@@+
    0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0,  //@@@+.........+@@%
    0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0,  //@@@+.........+@@%
    0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x50,  //@@@@.........@@@+
    0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //@@@@%.......%@@@.
    0xff, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //@@@%@@@@@@@@@@%..
    0xff, 0xf0, 0x9f, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //@@@.%@@@@@@@@%...
    0xff, 0xf0, 0x03, 0x9d, 0xff, 0xd9, 0x30, 0x00, 0x00,  //@@@...%@@@@%.....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0441 (с) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x04, 0x9d, 0xef, 0xfd, 0xb7, 0x20,  //.....+%@@@@@%+.
    0x00, 0x03, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf0,  //....@@@@@@@@@@@
    0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..+@@@@@@@@@@@@
    0x03, 0xff, 0xff, 0x94, 0x10, 0x02, 0x48, 0xd0,  //..@@@@%.....+%@
    0x0d, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@..........
    0x4f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@...........
    0x9f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%...........
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0x9f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%...........
    0x4f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@...........
    0x0d, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@..........
    0x03, 0xff, 0xff, 0x83, 0x10, 0x02, 0x48, 0xd0,  //..@@@@%.....+%@
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..+@@@@@@@@@@@@
    0x00, 0x04, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf0,  //....@@@@@@@@@@@
    0x00, 0x00, 0x05, 0xad, 0xef, 0xfd, 0xb7, 0x20,  //.....+%@@@@@%+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0442 (т) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0443 (у) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xcf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc,  //@@@+..........+@@@
    0x6f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf6,  //+@@@..........@@@+
    0x0e, 0xff, 0x40, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0,  //.@@@+.........@@@.
    0x08, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x09, 0xff, 0x90,  //.%@@%........%@@%.
    0x02, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x30,  //..@@@........@@@..
    0x00, 0xbf, 0xf8, 0x00, 0x00, 0x00, 0x6f, 0xfd, 0x00,  //..%@@%......+@@@..
    0x00, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0xcf, 0xf7, 0x00,  //..+@@@......@@@+..
    0x00, 0x0e, 0xff, 0x50, 0x00, 0x02, 0xff, 0xf1, 0x00,  //...@@@+.....@@@...
    0x00, 0x07, 0xff, 0xc0, 0x00, 0x08, 0xff, 0xa0, 0x00,  //...+@@@....%@@%...
    0x00, 0x01, 0xff, 0xf3, 0x00, 0x0e, 0xff, 0x40, 0x00,  //....@@@....@@@+...
    0x00, 0x00, 0xaf, 0xf9, 0x00, 0x5f, 0xfd, 0x00, 0x00,  //....%@@%..+@@@....
    0x00, 0x00, 0x3f, 0xff, 0x00, 0xbf, 0xf7, 0x00, 0x00,  //.....@@@..%@@+....
    0x00, 0x00, 0x0d, 0xff, 0x62, 0xff, 0xf1, 0x00, 0x00,  //.....@@@+.@@@.....
    0x00, 0x00, 0x06, 0xff, 0xd8, 0xff, 0xa0, 0x00, 0x00,  //.....+@@@%@@%.....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00,  //......@@@@@@+.....
    0x00, 0x00, 0x00, 0x9f, 0xff, 0xfe, 0x00, 0x00, 0x00,  //......%@@@@@......
    0x00, 0x00, 0x00, 0x2f, 0xff, 0xf8, 0x00, 0x00, 0x00,  //.......@@@@+......
    0x00, 0x00, 0x00, 0x0c, 0xff, 0xf1, 0x00, 0x00, 0x00,  //.......%@@@.......
    0x00, 0x00, 0x00, 0x08, 0xff, 0xb0, 0x00, 0x00, 0x00,  //.......%@@%.......
    0x00, 0x00, 0x00, 0x0e, 0xff, 0x50, 0x00, 0x00, 0x00,  //.......@@@+.......
    0x00, 0x00, 0x00, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //......+@@@........
    0x00, 0x00, 0x00, 0xcf, 0xf8, 0x00, 0x00, 0x00, 0x00,  //......%@@%........
    0x00, 0x00, 0x19, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //.....%@@@.........
    0x00, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@%.........
    0x00, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@..........
    0x00, 0xff, 0xfe, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0444 (ф) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x01, 0x8d, 0xfe, 0x81, 0x0f, 0xff, 0x01, 0x9e, 0xfd, 0x81, 0x00, 0x00,  //....%@@@%..@@@..%@@@%....
    0x00, 0x3e, 0xff, 0xff, 0xfd, 0x1f, 0xff, 0x1d, 0xff, 0xff, 0xfe, 0x20, 0x00,  //...@@@@@@@.@@@.@@@@@@@...
    0x01, 0xef, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xe1, 0x00,  //..@@@@@@@@%@@@%@@@@@@@@..
    0x0a, 0xff, 0xf7, 0x10, 0x4d, 0xff, 0xff, 0xfd, 0x40, 0x17, 0xff, 0xfa, 0x00,  //.%@@@+..+@@@@@@@+..+@@@%.
    0x2f, 0xff, 0x40, 0x00, 0x01, 0xdf, 0xff, 0xc1, 0x00, 0x00, 0x4f, 0xff, 0x10,  //.@@@......@@@@@.....+@@@.
    0x7f, 0xfa, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x10, 0x00, 0x00, 0x0a, 0xff, 0x70,  //+@@%.......@@@.......%@@+
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+.......@@@.......+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xe0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xef, 0xf2, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@........@@@........@@@
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+.......@@@.......+@@%
    0x8f, 0xfa, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x10, 0x00, 0x00, 0x0a, 0xff, 0x80,  //+@@%.......@@@.......%@@+
    0x2f, 0xff, 0x30, 0x00, 0x01, 0xcf, 0xff, 0xc1, 0x00, 0x00, 0x4f, 0xff, 0x20,  //.@@@......@@@@@.....+@@@.
    0x0b, 0xff, 0xf7, 0x10, 0x4d, 0xff, 0xff, 0xfd, 0x40, 0x17, 0xff, 0xfb, 0x00,  //.%@@@+..+@@@@@@@+..+@@@%.
    0x02, 0xef, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xe1, 0x00,  //..@@@@@@@@%@@@%@@@@@@@@..
    0x00, 0x3e, 0xff, 0xff, 0xfd, 0x1f, 0xff, 0x1d, 0xff, 0xff, 0xfe, 0x30, 0x00,  //...@@@@@@@.@@@.@@@@@@@...
    0x00, 0x01, 0x8d, 0xfe, 0x81, 0x0f, 0xff, 0x01, 0x9e, 0xfd, 0x81, 0x00, 0x00,  //....%@@@%..@@@..%@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+0445 (х) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x0a, 0xff, 0xe1, 0x00, 0x00, 0x00, 0x01, 0xef, 0xfa,  //.%@@@.........@@@%
    0x00, 0xdf, 0xfc, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xd0,  //..@@@@.......@@@@.
    0x00, 0x3f, 0xff, 0x80, 0x00, 0x00, 0x8f, 0xff, 0x30,  //...@@@%.....%@@@..
    0x00, 0x07, 0xff, 0xf3, 0x00, 0x04, 0xff, 0xf7, 0x00,  //...+@@@.....@@@+..
    0x00, 0x00, 0xbf, 0xfe, 0x10, 0x1e, 0xff, 0xb0, 0x00,  //....%@@@...@@@%...
    0x00, 0x00, 0x1e, 0xff, 0xa0, 0xbf, 0xfe, 0x10, 0x00,  //.....@@@%.%@@@....
    0x00, 0x00, 0x04, 0xff, 0xfb, 0xff, 0xf4, 0x00, 0x00,  //.....+@@@%@@@+....
    0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0x80, 0x00, 0x00,  //......%@@@@@%.....
    0x00, 0x00, 0x00, 0x0c, 0xff, 0xfc, 0x00, 0x00, 0x00,  //.......@@@@@......
    0x00, 0x00, 0x00, 0x0b, 0xff, 0xf8, 0x00, 0x00, 0x00,  //.......%@@@%......
    0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0x20, 0x00, 0x00,  //......%@@@@@......
    0x00, 0x00, 0x04, 0xff, 0xfe, 0xff, 0xd0, 0x00, 0x00,  //.....+@@@@@@@.....
    0x00, 0x00, 0x1e, 0xff, 0xb2, 0xff, 0xf8, 0x00, 0x00,  //.....@@@%.@@@%....
    0x00, 0x00, 0xcf, 0xfd, 0x10, 0x6f, 0xff, 0x30, 0x00,  //....@@@@..+@@@....
    0x00, 0x09, 0xff, 0xf3, 0x00, 0x0b, 0xff, 0xd0, 0x00,  //...%@@@....%@@@...
    0x00, 0x5f, 0xff, 0x60, 0x00, 0x01, 0xef, 0xf9, 0x00,  //..+@@@+.....@@@%..
    0x02, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x40,  //..@@@%......+@@@+.
    0x0d, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xe1,  //.@@@@........%@@@.
    0x9f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x01, 0xef, 0xfa,  //%@@@..........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0446 (ц) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0447 (ч) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@
    0xef, 0xf3, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@
    0xcf, 0xfa, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //%@@%........@@@
    0x7f, 0xff, 0x92, 0x00, 0x00, 0x00, 0xff, 0xf0,  //+@@@%.......@@@
    0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@@
    0x03, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@@@@@
    0x00, 0x07, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf0,  //...+@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0448 (ш) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+0449 (щ) , Width: 28 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@........@@@........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@........@@@........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@........@@@........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@........@@@........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@........@@@........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@........@@@........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@........@@@........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@........@@@........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@........@@@........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@........@@@........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@........@@@........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@........@@@........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@........@@@........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@........@@@........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@........@@@........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.........................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.........................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.........................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.........................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.........................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................


    /*Unicode: U+044a (ъ) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@............
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@............
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@............
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@............
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@............
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@............
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@............
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@............
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xa6, 0x00, 0x00,  //......@@@@@@@@@@%+...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00,  //......@@@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,  //......@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x02, 0x7f, 0xff, 0xa0,  //......@@@.......+@@@%
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x04, 0xff, 0xe0,  //......@@@........+@@@
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //......@@@.........@@@
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x04, 0xff, 0xe0,  //......@@@........+@@@
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x02, 0x7f, 0xff, 0xa0,  //......@@@.......+@@@%
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,  //......@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00,  //......@@@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xb6, 0x00, 0x00,  //......@@@@@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+044b (ы) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...............@@@
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xa6, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@@@@@@%+......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00, 0x00, 0xff, 0xf0,  //@@@@@@@@@@@@@+....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0xff, 0xf0,  //@@@@@@@@@@@@@@....@@@
    0xff, 0xf0, 0x00, 0x00, 0x02, 0x7f, 0xff, 0xa0, 0x00, 0xff, 0xf0,  //@@@.......+@@@%...@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x04, 0xff, 0xe0, 0x00, 0xff, 0xf0,  //@@@........+@@@...@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@.........@@@...@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x04, 0xff, 0xe0, 0x00, 0xff, 0xf0,  //@@@........+@@@...@@@
    0xff, 0xf0, 0x00, 0x00, 0x02, 0x7f, 0xff, 0xa0, 0x00, 0xff, 0xf0,  //@@@.......+@@@%...@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0xff, 0xf0,  //@@@@@@@@@@@@@@....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00, 0x00, 0xff, 0xf0,  //@@@@@@@@@@@@@+....@@@
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xb6, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@@@@@@%+......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+044c (ь) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xa6, 0x00, 0x00,  //@@@@@@@@@@%+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00,  //@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x02, 0x7f, 0xff, 0xa0,  //@@@.......+@@@%
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x04, 0xff, 0xe0,  //@@@........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x04, 0xff, 0xe0,  //@@@........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x02, 0x7f, 0xff, 0xa0,  //@@@.......+@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00,  //@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xb6, 0x00, 0x00,  //@@@@@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+044d (э) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x26, 0xad, 0xef, 0xed, 0x94, 0x00, 0x00, 0x00,  //.+%@@@@@%+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd3, 0x00, 0x00,  //@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00,  //@@@@@@@@@@@@+..
    0xd9, 0x52, 0x10, 0x02, 0x5c, 0xff, 0xf3, 0x00,  //@%+.....+@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfd, 0x00,  //..........+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0x40,  //...........%@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x90,  //............@@%
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //..@@@@@@@@@@@@@
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //..@@@@@@@@@@@@@
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xe0,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0x90,  //...........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x50,  //...........@@@+
    0x00, 0x00, 0x00, 0x00, 0x01, 0xcf, 0xfd, 0x00,  //..........@@@@.
    0xd9, 0x52, 0x10, 0x13, 0x8f, 0xff, 0xf4, 0x00,  //@%+.....%@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00,  //@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x00, 0x00,  //@@@@@@@@@@@+...
    0x26, 0xbd, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00,  //.+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+044e (ю) , Width: 24 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x02, 0x8c, 0xef, 0xec, 0x81, 0x00, 0x00,  //@@@.........%@@@@@+.....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //@@@.......%@@@@@@@@@+...
    0xff, 0xf0, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00,  //@@@......%@@@@@@@@@@@%..
    0xff, 0xf0, 0x00, 0x00, 0x6f, 0xff, 0xd5, 0x10, 0x15, 0xdf, 0xff, 0x60,  //@@@.....+@@@@+...+@@@@+.
    0xff, 0xf0, 0x00, 0x00, 0xef, 0xfb, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xe0,  //@@@.....@@@%.......%@@@.
    0xff, 0xf0, 0x00, 0x06, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x01, 0xef, 0xf6,  //@@@....+@@@.........@@@+
    0xff, 0xf0, 0x00, 0x0b, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfa,  //@@@....%@@+.........+@@%
    0xff, 0xf0, 0x00, 0x0e, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfd,  //@@@....@@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@@@@@@@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@@@@@@@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@@@@@@@@...........@@@
    0xff, 0xf0, 0x00, 0x0f, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfd,  //@@@....@@@...........@@@
    0xff, 0xf0, 0x00, 0x0c, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfa,  //@@@....@@@+.........+@@%
    0xff, 0xf0, 0x00, 0x09, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x01, 0xef, 0xf6,  //@@@....%@@@.........@@@+
    0xff, 0xf0, 0x00, 0x03, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xe0,  //@@@.....@@@%.......%@@@.
    0xff, 0xf0, 0x00, 0x00, 0xaf, 0xff, 0xd5, 0x10, 0x15, 0xdf, 0xff, 0x60,  //@@@.....%@@@@+...+@@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00,  //@@@......@@@@@@@@@@@@%..
    0xff, 0xf0, 0x00, 0x00, 0x01, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //@@@.......%@@@@@@@@@%...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x03, 0x9d, 0xef, 0xec, 0x82, 0x00, 0x00,  //@@@.........%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................


    /*Unicode: U+044f (я) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x01, 0x8c, 0xef, 0xff, 0xff, 0xff, 0xf0,  //....%@@@@@@@@@@
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..+@@@@@@@@@@@@
    0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@@@@@
    0x0b, 0xff, 0xf8, 0x20, 0x00, 0x00, 0xff, 0xf0,  //.%@@@%......@@@
    0x0e, 0xff, 0x60, 0x00, 0x00, 0x00, 0xff, 0xf0,  //.@@@+.......@@@
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //.@@@........@@@
    0x0e, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //.@@@........@@@
    0x0a, 0xff, 0x60, 0x00, 0x00, 0x00, 0xff, 0xf0,  //.%@@+.......@@@
    0x03, 0xff, 0xf9, 0x20, 0x00, 0x00, 0xff, 0xf0,  //..@@@%......@@@
    0x00, 0x3d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //...@@@@@@@@@@@@
    0x00, 0x00, 0x5d, 0xff, 0xff, 0xff, 0xff, 0xf0,  //....+@@@@@@@@@@
    0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.....@@@@@@@@@@
    0x00, 0x00, 0xbf, 0xfd, 0x00, 0x00, 0xff, 0xf0,  //....%@@@....@@@
    0x00, 0x06, 0xff, 0xf3, 0x00, 0x00, 0xff, 0xf0,  //...+@@@.....@@@
    0x00, 0x1e, 0xff, 0x80, 0x00, 0x00, 0xff, 0xf0,  //...@@@%.....@@@
    0x00, 0xbf, 0xfd, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..%@@@......@@@
    0x05, 0xff, 0xf3, 0x00, 0x00, 0x00, 0xff, 0xf0,  //.+@@@.......@@@
    0x1e, 0xff, 0x90, 0x00, 0x00, 0x00, 0xff, 0xf0,  //.@@@%.......@@@
    0xaf, 0xfd, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //%@@@........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............



#elif USE_LV_FONT_DEJAVU_40_CYRILLIC == 8
    /*Unicode: U+0410 (А) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0xff, 0xf2, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xd6, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xfa, 0x2a, 0xf8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xb0, 0x00, 0xaa, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe4, 0xff, 0xff, 0x4c, 0x00, 0x48, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x02, 0xe2, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@%...%@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xf8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xfa, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0x00, 0x08, 0xf0, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xf0, 0x08, 0x00, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x00, 0x00, 0x20, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00,  //..%@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0xe0, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xe0, 0x00, 0x00,  //..@@@+...........+@@@..
    0x00, 0x46, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xea, 0xff, 0xff, 0x46, 0x00,  //.+@@@.............@@@+.
    0x00, 0xa8, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xa8, 0x00,  //.%@@%.............%@@%.
    0x10, 0xf6, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xf6, 0x10,  //.@@@...............@@@.
    0x6c, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0x6c,  //+@@@...............@@@+
    0xce, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xce,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0411 (Б) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xe6, 0xc2, 0x90, 0x3e, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x34, 0x00, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x44, 0x00,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x16, 0x40, 0x90, 0xf6, 0xff, 0xff, 0xea, 0x10,  //@@@.........%@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xea, 0xff, 0xff, 0x7a,  //@@@...........@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xc4,  //@@@...........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xe8,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf8,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xea,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0xc8,  //@@@...........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xea, 0xff, 0xff, 0x82,  //@@@...........@@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x40, 0x8e, 0xf4, 0xff, 0xff, 0xf4, 0x18,  //@@@.........%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x5c, 0x00,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x4c, 0x00, 0x00,  //@@@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xec, 0xd0, 0xa0, 0x56, 0x06, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0412 (В) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xe4, 0xbe, 0x84, 0x2a, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@%%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xa0, 0x0a, 0x00, 0x00,  //@@@@@@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x02, 0x00,  //@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x24, 0x5e, 0xcc, 0xff, 0xff, 0xff, 0x6e, 0x00,  //@@@........+@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xac, 0xff, 0xff, 0xc8, 0x00,  //@@@..........%@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xff, 0xff, 0xf0, 0x00,  //@@@...........@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf0, 0x00,  //@@@...........@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xff, 0xff, 0xd0, 0x00,  //@@@...........@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaa, 0xff, 0xff, 0x8a, 0x00,  //@@@..........%@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x24, 0x5c, 0xc8, 0xff, 0xff, 0xec, 0x18, 0x00,  //@@@........+@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x28, 0x00, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x2c, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x92, 0x02, 0x00,  //@@@@@@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x16, 0x40, 0x8e, 0xf4, 0xff, 0xff, 0x96, 0x00,  //@@@.........%@@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xe8, 0xff, 0xff, 0x3c,  //@@@...........@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xa2,  //@@@...........+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xde,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf6,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xf0,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xd2,  //@@@...........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xea, 0xff, 0xff, 0x8a,  //@@@...........@@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x40, 0x8e, 0xf6, 0xff, 0xff, 0xf4, 0x1c,  //@@@.........%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x58, 0x00,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x46, 0x00, 0x00,  //@@@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xec, 0xd0, 0x9e, 0x52, 0x04, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0413 (Г) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0414 (Д) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //......@@@........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //......@@@........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //......@@@........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //......@@@........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //......@@@........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //......@@@........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //......@@@........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //......@@@........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....+@@@........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....+@@%........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....%@@%........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....%@@+........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....@@@+........@@@...
    0x00, 0x00, 0x00, 0x00, 0x10, 0xfc, 0xff, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....@@@.........@@@...
    0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....+@@@.........@@@...
    0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....%@@%.........@@@...
    0x00, 0x00, 0x00, 0x0a, 0xec, 0xff, 0xff, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....@@@+.........@@@...
    0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xf0, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...%@@@..........@@@...
    0x00, 0x24, 0xb8, 0xff, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..%@@@+..........@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0415 (Е) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0416 (Ж) , Width: 35 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x8c, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xff, 0x8c, 0x00,  //.%@@@+..........@@@..........+@@@%.
    0x00, 0x00, 0xa6, 0xff, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0xa6, 0x00, 0x00,  //..%@@@+.........@@@.........+@@@%..
    0x00, 0x00, 0x04, 0xbc, 0xff, 0xff, 0xfa, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xfa, 0xff, 0xff, 0xbc, 0x04, 0x00, 0x00,  //...%@@@+........@@@........+@@@%...
    0x00, 0x00, 0x00, 0x0c, 0xce, 0xff, 0xff, 0xf2, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xf2, 0xff, 0xff, 0xce, 0x0c, 0x00, 0x00, 0x00,  //....@@@@........@@@........@@@@....
    0x00, 0x00, 0x00, 0x00, 0x18, 0xde, 0xff, 0xff, 0xe8, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xe8, 0xff, 0xff, 0xde, 0x18, 0x00, 0x00, 0x00, 0x00,  //.....@@@@.......@@@.......@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xec, 0xff, 0xff, 0xda, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xda, 0xff, 0xff, 0xec, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@......@@@......@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xf4, 0xff, 0xff, 0xc8, 0x0a, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xc8, 0xff, 0xff, 0xf4, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@.....@@@.....@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xfa, 0xff, 0xff, 0xb4, 0x02, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x02, 0xb4, 0xff, 0xff, 0xfa, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@%....@@@....%@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@%...@@@...%@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%..@@@..%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xff, 0xff, 0x66, 0x00, 0xff, 0xff, 0xff, 0x00, 0x68, 0xff, 0xff, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@@+.@@@.+@@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x4e, 0xff, 0xff, 0xff, 0x4e, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@+@@@+@@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xda, 0xff, 0xff, 0xb0, 0xca, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xca, 0xb0, 0xff, 0xff, 0xda, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@%@@@@@@@@@@@%@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xec, 0x16, 0x14, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x14, 0x16, 0xec, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@@..@@@@@@@@@..@@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xfa, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x22, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x22, 0x00, 0x00, 0x60, 0xff, 0xff, 0xfa, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@+...@@@@@@@...+@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xd0, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x34, 0xf2, 0xff, 0xff, 0xff, 0xf2, 0x32, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xd0, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@%.....@@@@@.....%@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xf2, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xf2, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@......+@@@+......@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x28, 0xf8, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xf6, 0x28, 0x00, 0x00, 0x00, 0x00,  //.....@@@+.......@@@.......+@@@.....
    0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00,  //....@@@@........@@@........@@@@....
    0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xf8, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xf8, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00,  //...+@@@.........@@@.........@@@+...
    0x00, 0x00, 0x20, 0xf2, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xf2, 0x1e, 0x00, 0x00,  //...@@@+.........@@@.........+@@@...
    0x00, 0x00, 0xba, 0xff, 0xff, 0xd0, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xd2, 0xff, 0xff, 0xb8, 0x00, 0x00,  //..%@@@..........@@@..........@@@%..
    0x00, 0x60, 0xff, 0xff, 0xfa, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xfa, 0xff, 0xff, 0x60, 0x00,  //.+@@@...........@@@...........@@@+.
    0x16, 0xee, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xec, 0x16,  //.@@@%...........@@@...........%@@@.
    0xac, 0xff, 0xff, 0xda, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xda, 0xff, 0xff, 0xac,  //%@@@............@@@............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................................


    /*Unicode: U+0417 (З) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x12, 0x64, 0xa4, 0xd6, 0xf0, 0xf8, 0xea, 0xcc, 0x9a, 0x4a, 0x02, 0x00, 0x00, 0x00, 0x00,  //...+%@@@@@%+.....
    0x22, 0xa0, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x48, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@+...
    0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x70, 0x00, 0x00,  //%@@@@@@@@@@@@@+..
    0xbe, 0xff, 0xff, 0xce, 0x4a, 0x14, 0x02, 0x02, 0x0e, 0x2a, 0x64, 0xd0, 0xff, 0xff, 0xfc, 0x3c, 0x00,  //%@@@+.....+@@@@..
    0xbe, 0xf6, 0x76, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xb4, 0xff, 0xff, 0xb0, 0x00,  //%@+.........%@@%.
    0x8c, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xe8, 0x00,  //%............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf8, 0x00,  //.............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xd8, 0x00,  //.............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaa, 0xff, 0xff, 0x82, 0x00,  //............%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x24, 0x5c, 0xc8, 0xff, 0xff, 0xd6, 0x0c, 0x00,  //..........+@@@@..
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x16, 0x00, 0x00,  //....@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x5a, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@+....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x2a, 0x00, 0x00,  //....@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x24, 0x56, 0xae, 0xff, 0xff, 0xf4, 0x4c, 0x00,  //..........+%@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xf6, 0xff, 0xf4, 0x24,  //............+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0x9e,  //.............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xe2,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf8,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe4,  //..............@@@
    0x9c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xb8,  //%............+@@%
    0xff, 0xd6, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xf8, 0xff, 0xff, 0x5c,  //@@..........+@@@+
    0xff, 0xff, 0xfc, 0xae, 0x5a, 0x24, 0x0c, 0x02, 0x0c, 0x28, 0x5e, 0xba, 0xff, 0xff, 0xff, 0xc0, 0x00,  //@@@%+.....+%@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x14, 0x00,  //@@@@@@@@@@@@@@@..
    0x4c, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x74, 0x04, 0x00, 0x00,  //+@@@@@@@@@@@@+...
    0x00, 0x00, 0x1e, 0x66, 0xa4, 0xd6, 0xec, 0xfa, 0xec, 0xd0, 0x9e, 0x56, 0x08, 0x00, 0x00, 0x00, 0x00,  //...+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0418 (И) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xff,  //@@@...........%@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xfc, 0xff, 0xff, 0xff, 0xff,  //@@@...........@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@..........%@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff,  //@@@.........+@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xff, 0xff, 0x98, 0xff, 0xff, 0xff,  //@@@.........@@@%@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xf2, 0x18, 0xff, 0xff, 0xff,  //@@@........+@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xde, 0xff, 0xff, 0x80, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@+.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xe6, 0x0a, 0x00, 0xff, 0xff, 0xff,  //@@@.......+@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xee, 0xff, 0xff, 0x66, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@+..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xd6, 0x02, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......%@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xf8, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@+...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....%@@%....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x34, 0xfc, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....%@@%.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xf8, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...+@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0xd4, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@%......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x64, 0xff, 0xff, 0xee, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..+@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x0a, 0xe4, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@+.......@@@
    0xff, 0xff, 0xff, 0x00, 0x7c, 0xff, 0xff, 0xe0, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.+@@@........@@@
    0xff, 0xff, 0xff, 0x16, 0xf2, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.@@@+........@@@
    0xff, 0xff, 0xff, 0x96, 0xff, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@%@@@.........@@@
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@+.........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@%..........@@@
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@%...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0419 (Й) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0xe2, 0xf0, 0x08, 0x00, 0x00, 0x00, 0x0a, 0xf0, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xb2, 0x28, 0x06, 0x26, 0xb4, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@%...%@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xa2, 0xdc, 0xf8, 0xe8, 0xa8, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xff,  //@@@...........%@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xfc, 0xff, 0xff, 0xff, 0xff,  //@@@...........@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@..........%@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff,  //@@@.........+@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xff, 0xff, 0x98, 0xff, 0xff, 0xff,  //@@@.........@@@%@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xf2, 0x18, 0xff, 0xff, 0xff,  //@@@........+@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xde, 0xff, 0xff, 0x80, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@+.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xe6, 0x0a, 0x00, 0xff, 0xff, 0xff,  //@@@.......+@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xee, 0xff, 0xff, 0x66, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@+..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xd6, 0x02, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......%@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xf8, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@+...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....%@@%....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x34, 0xfc, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....%@@%.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xf8, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...+@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0xd4, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@%......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x64, 0xff, 0xff, 0xee, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..+@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x0a, 0xe4, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@+.......@@@
    0xff, 0xff, 0xff, 0x00, 0x7c, 0xff, 0xff, 0xe0, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.+@@@........@@@
    0xff, 0xff, 0xff, 0x16, 0xf2, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.@@@+........@@@
    0xff, 0xff, 0xff, 0x96, 0xff, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@%@@@.........@@@
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@+.........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@%..........@@@
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@%...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+041a (К) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xff, 0x84, 0x00,  //@@@...........%@@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00,  //@@@..........%@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00,  //@@@.........%@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00,  //@@@........+@@@%....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xb0, 0x02, 0x00, 0x00, 0x00, 0x00,  //@@@.......+@@@%.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xfc, 0xff, 0xff, 0xb8, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@......+@@@%......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xfc, 0xff, 0xff, 0xc2, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....+@@@@.......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xfa, 0xff, 0xff, 0xca, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@....+@@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x44, 0xf6, 0xff, 0xff, 0xd2, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...+@@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x3a, 0xf4, 0xff, 0xff, 0xdc, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...@@@@..........
    0xff, 0xff, 0xff, 0x00, 0x32, 0xf0, 0xff, 0xff, 0xff, 0xea, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..@@@@@..........
    0xff, 0xff, 0xff, 0x2a, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.@@@@@@%.........
    0xff, 0xff, 0xff, 0xe6, 0xff, 0xff, 0xea, 0x6c, 0xfc, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@+@@@+........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x32, 0x00, 0x92, 0xff, 0xff, 0xf2, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@..%@@@........
    0xff, 0xff, 0xff, 0xff, 0xf2, 0x3a, 0x00, 0x00, 0x08, 0xd6, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@....@@@@.......
    0xff, 0xff, 0xff, 0xf6, 0x42, 0x00, 0x00, 0x00, 0x00, 0x34, 0xfa, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@+.....@@@+......
    0xff, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xf6, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+......+@@@......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xca, 0xff, 0xff, 0xce, 0x04, 0x00, 0x00, 0x00, 0x00,  //@@@........@@@@.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xf6, 0xff, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00,  //@@@.........@@@%....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xfa, 0x38, 0x00, 0x00, 0x00,  //@@@.........+@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0xda, 0x0a, 0x00, 0x00,  //@@@..........%@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xee, 0xff, 0xff, 0x96, 0x00, 0x00,  //@@@...........@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xff, 0x46, 0x00,  //@@@...........+@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0xe4, 0x10,  //@@@............%@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xe6, 0xff, 0xff, 0xa6,  //@@@.............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+041b (Л) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //......@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //......@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //......@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //......@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //......@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //......@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //......@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //......@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //......@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //......@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //......@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //......@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....+@@%.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....+@@%.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....%@@%.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....%@@+.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xe8, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....@@@..........@@@
    0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xfa, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....@@@..........@@@
    0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....+@@@..........@@@
    0x00, 0x00, 0x00, 0x10, 0xe8, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@+..........@@@
    0x00, 0x00, 0x14, 0xc8, 0xff, 0xff, 0xf8, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@@...........@@@
    0x26, 0x7c, 0xee, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.+@@@@+...........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@%............@@@
    0xff, 0xff, 0xff, 0xe8, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@+.............@@@
    0xe4, 0xaa, 0x5c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@%+...............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+041c (М) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xff, 0xff, 0xff, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@.............@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@%...........%@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@...........@@@@@@
    0xff, 0xff, 0xff, 0xce, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xcc, 0xff, 0xff, 0xff,  //@@@@@@+.........+@@@@@@
    0xff, 0xff, 0xff, 0x68, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xff, 0x68, 0xff, 0xff, 0xff,  //@@@+@@@.........@@@+@@@
    0xff, 0xff, 0xff, 0x0e, 0xf4, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xf4, 0x0c, 0xff, 0xff, 0xff,  //@@@.@@@.........@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0x9e, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0x9c, 0x00, 0xff, 0xff, 0xff,  //@@@.%@@%.......%@@%.@@@
    0xff, 0xff, 0xff, 0x00, 0x38, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xf2, 0xff, 0xff, 0x36, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@.......@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0xd2, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xd2, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@+.....+@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0x6c, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..+@@@.....@@@+..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x10, 0xf6, 0xff, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xf6, 0x10, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@.....@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...%@@%...%@@%...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0xee, 0x08, 0x00, 0x08, 0xf0, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....@@@...@@@....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x5e, 0x00, 0x60, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....@@@+.+@@@....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0xc4, 0x00, 0xc6, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....+@@@.@@@+....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf8, 0xff, 0xff, 0x56, 0xff, 0xff, 0xf6, 0x12, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@+@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....%@@@@@%.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......+@@@+......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+041d (Н) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+041e (О) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x56, 0xa0, 0xd2, 0xe8, 0xf8, 0xe8, 0xd2, 0xa2, 0x58, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x04, 0x6e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x72, 0x04, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x10, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x10, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x00, 0x0e, 0xd4, 0xff, 0xff, 0xff, 0xe0, 0x7e, 0x36, 0x16, 0x04, 0x14, 0x34, 0x7c, 0xde, 0xff, 0xff, 0xff, 0xd6, 0x0e, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x00, 0xaa, 0xff, 0xff, 0xff, 0x84, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00,  //..%@@@%.........+@@@%..
    0x00, 0x56, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0x58, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0xce, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xce, 0x00,  //.@@@%.............%@@@.
    0x38, 0xff, 0xff, 0xf6, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf6, 0xff, 0xff, 0x3a,  //.@@@...............@@@.
    0x7c, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x7c,  //+@@%...............%@@+
    0xb8, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xb8,  //%@@+...............+@@%
    0xda, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xd8,  //@@@.................@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@.................@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@.................@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@.................@@@
    0xda, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xda,  //@@@.................@@@
    0xba, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xba,  //%@@+...............+@@%
    0x7e, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x7c,  //+@@%...............%@@+
    0x3a, 0xff, 0xff, 0xf4, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf4, 0xff, 0xff, 0x3a,  //.@@@...............@@@.
    0x00, 0xd0, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xd0, 0x00,  //.@@@%.............%@@@.
    0x00, 0x58, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0x58, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0x00, 0xae, 0xff, 0xff, 0xff, 0x80, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7c, 0xfc, 0xff, 0xff, 0xb0, 0x00, 0x00,  //..%@@@+.........+@@@%..
    0x00, 0x00, 0x10, 0xd6, 0xff, 0xff, 0xff, 0xe0, 0x7c, 0x34, 0x14, 0x04, 0x14, 0x32, 0x7a, 0xdc, 0xff, 0xff, 0xff, 0xd8, 0x10, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x00, 0x00, 0x12, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x12, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x04, 0x72, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x74, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x58, 0xa2, 0xd2, 0xe8, 0xf8, 0xea, 0xd4, 0xa4, 0x5a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+041f (П) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0420 (Р) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf0, 0xdc, 0xac, 0x68, 0x0c, 0x00, 0x00, 0x00,  //@@@@@@@@@@%+....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x58, 0x00, 0x00,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00,  //@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x34, 0x88, 0xf4, 0xff, 0xff, 0xf6, 0x1a,  //@@@.......%@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xec, 0xff, 0xff, 0x84,  //@@@.........@@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xc8,  //@@@.........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xea,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf8,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xea,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xc8,  //@@@.........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xec, 0xff, 0xff, 0x84,  //@@@.........@@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x34, 0x86, 0xf4, 0xff, 0xff, 0xf6, 0x1a,  //@@@.......%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0x00,  //@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x5c, 0x00, 0x00,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xde, 0xae, 0x6a, 0x0e, 0x00, 0x00, 0x00,  //@@@@@@@@@@%+....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0421 (С) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x44, 0x88, 0xc4, 0xde, 0xf2, 0xf8, 0xe8, 0xd2, 0xa4, 0x6c, 0x1a, 0x00, 0x00,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xb8, 0x3c,  //.....+@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x0a, 0xac, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x00, 0x00, 0x0a, 0xcc, 0xff, 0xff, 0xff, 0xe8, 0x88, 0x46, 0x1c, 0x0a, 0x08, 0x1e, 0x42, 0x88, 0xda, 0xff, 0xff, 0xff,  //...@@@@@%+....+%@@@@
    0x00, 0x00, 0xa4, 0xff, 0xff, 0xfc, 0x80, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xda, 0xff,  //..%@@@+..........+@@
    0x00, 0x52, 0xff, 0xff, 0xfc, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xa2,  //.+@@@+.............%
    0x00, 0xcc, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%...............
    0x38, 0xff, 0xff, 0xf0, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x7c, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0xba, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0xda, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xda, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xba, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0x7c, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0x38, 0xff, 0xff, 0xee, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x00, 0xce, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%...............
    0x00, 0x54, 0xff, 0xff, 0xfc, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xa0,  //.+@@@+.............%
    0x00, 0x00, 0xa8, 0xff, 0xff, 0xfc, 0x7c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xda, 0xff,  //..%@@@+..........+@@
    0x00, 0x00, 0x0a, 0xce, 0xff, 0xff, 0xff, 0xe6, 0x86, 0x44, 0x1c, 0x08, 0x08, 0x1e, 0x42, 0x84, 0xd6, 0xff, 0xff, 0xff,  //...@@@@@%+....+%@@@@
    0x00, 0x00, 0x00, 0x0c, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xb6, 0x3c,  //.....+@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x44, 0x8a, 0xc6, 0xde, 0xf2, 0xf8, 0xea, 0xd2, 0xa4, 0x6a, 0x18, 0x00, 0x00,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+0422 (Т) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0423 (У) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0xc6, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xc8,  //@@@+............+@@@
    0x56, 0xff, 0xff, 0xe6, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe0, 0xff, 0xff, 0x5a,  //+@@@............@@@+
    0x02, 0xe0, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xe8, 0x04,  //.@@@+..........+@@@.
    0x00, 0x74, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0x82, 0x00,  //.+@@@..........%@@%.
    0x00, 0x0e, 0xf2, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xfa, 0x1a, 0x00,  //..@@@..........@@@..
    0x00, 0x00, 0x92, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0xa8, 0x00, 0x00,  //..%@@%........%@@%..
    0x00, 0x00, 0x22, 0xfc, 0xff, 0xfc, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2, 0xff, 0xff, 0x3c, 0x00, 0x00,  //...@@@........@@@...
    0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00,  //...%@@%......+@@@...
    0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xf2, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00,  //....@@@......@@@+...
    0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xec, 0x08, 0x00, 0x00, 0x00,  //....@@@+....+@@@....
    0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xe0, 0x02, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00,  //....+@@@....%@@%....
    0x00, 0x00, 0x00, 0x00, 0x04, 0xe6, 0xff, 0xff, 0x56, 0x00, 0x00, 0x22, 0xfc, 0xff, 0xfc, 0x20, 0x00, 0x00, 0x00, 0x00,  //.....@@@+...@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@..%@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xf6, 0xff, 0xff, 0x38, 0x0a, 0xee, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@..@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xa8, 0x66, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@%+@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xfa, 0xdc, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xf0, 0xff, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@+........
    0x00, 0x00, 0x00, 0x00, 0x02, 0x16, 0x58, 0xee, 0xff, 0xff, 0xde, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@.........
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@+.........
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@%..........
    0x00, 0x00, 0x00, 0xff, 0xfa, 0xee, 0xd6, 0xa6, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@%+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+0424 (Ф) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x62, 0xa4, 0xca, 0xec, 0xff, 0xff, 0xff, 0xec, 0xca, 0xa4, 0x62, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x32, 0xac, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xae, 0x34, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x02, 0x82, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x84, 0x02, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@@@%...
    0x00, 0x00, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xba, 0x70, 0x36, 0x10, 0xff, 0xff, 0xff, 0x10, 0x36, 0x70, 0xba, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x00, 0x00,  //..%@@@@%+..@@@..+%@@@@%..
    0x00, 0x72, 0xff, 0xff, 0xff, 0xc2, 0x2a, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xc0, 0xff, 0xff, 0xff, 0x74, 0x00,  //.+@@@@.....@@@.....%@@@+.
    0x12, 0xee, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0xf0, 0x12,  //.@@@%......@@@......%@@@.
    0x6c, 0xff, 0xff, 0xde, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xde, 0xff, 0xff, 0x6c,  //+@@@.......@@@.......@@@+
    0xb4, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xb4,  //%@@+.......@@@.......+@@%
    0xde, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xde,  //@@@........@@@........@@@
    0xf4, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xf2,  //@@@........@@@........@@@
    0xf4, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf4,  //@@@........@@@........@@@
    0xe0, 0xff, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xde,  //@@@........@@@........@@@
    0xb8, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xb6,  //%@@+.......@@@.......+@@%
    0x6e, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0x6e,  //+@@%.......@@@.......%@@+
    0x14, 0xf2, 0xff, 0xff, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xf0, 0x14,  //.@@@+......@@@......+@@@.
    0x00, 0x78, 0xff, 0xff, 0xf8, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xf8, 0xff, 0xff, 0x76, 0x00,  //.+@@@+.....@@@.....+@@@+.
    0x00, 0x00, 0xa6, 0xff, 0xff, 0xff, 0xd0, 0x64, 0x18, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x1a, 0x64, 0xd0, 0xff, 0xff, 0xff, 0xa4, 0x00, 0x00,  //..%@@@@+...@@@...+@@@@%..
    0x00, 0x00, 0x04, 0x88, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xde, 0xbc, 0xff, 0xff, 0xff, 0xbc, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x88, 0x04, 0x00, 0x00,  //...%@@@@@@%@@@%@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x36, 0xb2, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xb2, 0x38, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x64, 0xa6, 0xcc, 0xee, 0xff, 0xff, 0xff, 0xee, 0xcc, 0xa6, 0x64, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+0425 (Х) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0xaa, 0xff, 0xff, 0xde, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xde, 0xff, 0xff, 0xaa, 0x00,  //.%@@@...........@@@%.
    0x00, 0x16, 0xec, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xea, 0x14, 0x00,  //..@@@%.........%@@@..
    0x00, 0x00, 0x5c, 0xff, 0xff, 0xfc, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xfc, 0xff, 0xff, 0x5a, 0x00, 0x00,  //..+@@@.........@@@+..
    0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0xd8, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xd8, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00,  //...%@@@.......@@@%...
    0x00, 0x00, 0x00, 0x1c, 0xf0, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xee, 0x18, 0x00, 0x00, 0x00,  //....@@@%.....%@@@....
    0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0xfa, 0x34, 0x00, 0x00, 0x00, 0x34, 0xfa, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00,  //....+@@@.....@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0xd4, 0x04, 0x00, 0x04, 0xd4, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@...@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf4, 0xff, 0xff, 0x82, 0x00, 0x82, 0xff, 0xff, 0xf2, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@%.%@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xfa, 0x60, 0xfa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@+@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xf6, 0xff, 0xff, 0xff, 0xf4, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xc8, 0xff, 0xff, 0xff, 0xc6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xf6, 0xff, 0xff, 0xd2, 0xff, 0xff, 0xf4, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xcc, 0x08, 0xd2, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@.@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xf8, 0x2c, 0x00, 0x34, 0xfa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@...@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x20, 0xf2, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xf2, 0x1e, 0x00, 0x00, 0x00, 0x00,  //.....@@@+...%@@@.....
    0x00, 0x00, 0x00, 0x00, 0xba, 0xff, 0xff, 0xd0, 0x04, 0x00, 0x00, 0x00, 0x08, 0xda, 0xff, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00,  //....%@@@.....@@@%....
    0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xfa, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xfc, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00,  //...+@@@.......@@@+...
    0x00, 0x00, 0x1a, 0xee, 0xff, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0xee, 0x1a, 0x00, 0x00,  //...@@@%.......%@@@...
    0x00, 0x00, 0xb2, 0xff, 0xff, 0xd6, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe0, 0xff, 0xff, 0xb2, 0x00, 0x00,  //..%@@@.........@@@%..
    0x00, 0x5c, 0xff, 0xff, 0xfc, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xff, 0xff, 0x5a, 0x00,  //.+@@@..........+@@@+.
    0x16, 0xec, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xea, 0x16,  //.@@@%...........%@@@.
    0xaa, 0xff, 0xff, 0xdc, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe4, 0xff, 0xff, 0xaa,  //%@@@.............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0426 (Ц) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@.............@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+0427 (Ч) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xf6, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xe6, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xbe, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //%@@+..........@@@
    0x80, 0xff, 0xff, 0xe8, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //+@@@..........@@@
    0x1e, 0xfa, 0xff, 0xff, 0xdc, 0x58, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@@+........@@@
    0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.+@@@@@@@@@@@@@@@
    0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x32, 0x9c, 0xdc, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0428 (Ш) , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+0429 (Щ) , Width: 34 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...........@@@...........@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...............................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...............................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...............................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...............................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...............................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................................


    /*Unicode: U+042a (Ъ) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xe6, 0xc2, 0x90, 0x3e, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x34, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x44, 0x00,  //.......@@@@@@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x18, 0x44, 0x96, 0xf8, 0xff, 0xff, 0xea, 0x10,  //.......@@@........+%@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xec, 0xff, 0xff, 0x7a,  //.......@@@...........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xc4,  //.......@@@...........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xe8,  //.......@@@............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf8,  //.......@@@............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xe8,  //.......@@@............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xc6,  //.......@@@...........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xea, 0xff, 0xff, 0x7e,  //.......@@@...........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x16, 0x42, 0x92, 0xf6, 0xff, 0xff, 0xf0, 0x14,  //.......@@@........+%@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x50, 0x00,  //.......@@@@@@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x40, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xea, 0xce, 0x9a, 0x4c, 0x02, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+042b (Ы) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xe6, 0xc2, 0x90, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@%.......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x34, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@.....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x44, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@+...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x16, 0x40, 0x90, 0xf6, 0xff, 0xff, 0xea, 0x10, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........%@@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xea, 0xff, 0xff, 0x7a, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@+..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xc4, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........+@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xe8, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@............@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf8, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@............@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xe8, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@............@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xc6, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........+@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xea, 0xff, 0xff, 0x7e, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@+..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x16, 0x40, 0x90, 0xf6, 0xff, 0xff, 0xf0, 0x14, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........%@@@@...@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x50, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@+...@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x40, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@.....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xea, 0xce, 0x9a, 0x4c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@%+......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+042c (Ь) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xe6, 0xc2, 0x90, 0x3e, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x34, 0x00, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x44, 0x00,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x16, 0x40, 0x90, 0xf6, 0xff, 0xff, 0xea, 0x10,  //@@@.........%@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xea, 0xff, 0xff, 0x7a,  //@@@...........@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xc4,  //@@@...........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xe8,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf8,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xe8,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xc6,  //@@@...........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xea, 0xff, 0xff, 0x7e,  //@@@...........@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x16, 0x40, 0x90, 0xf6, 0xff, 0xff, 0xf0, 0x14,  //@@@.........%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x50, 0x00,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x40, 0x00, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xea, 0xce, 0x9a, 0x4c, 0x02, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+042d (Э) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x1a, 0x6a, 0xa2, 0xd0, 0xe8, 0xf8, 0xf2, 0xde, 0xc6, 0x8a, 0x44, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+%@@@@@@%+.......
    0x3c, 0xb8, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x08, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xe0, 0x8e, 0x48, 0x20, 0x0a, 0x06, 0x18, 0x38, 0x70, 0xcc, 0xff, 0xff, 0xff, 0xc8, 0x08, 0x00, 0x00,  //@@@@%+.....+@@@@@...
    0xff, 0xe0, 0x60, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xf0, 0xff, 0xff, 0xa0, 0x00, 0x00,  //@@+..........+@@@%..
    0xa4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xf6, 0xff, 0xff, 0x50, 0x00,  //%..............@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xca, 0x00,  //...............+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xe2, 0xff, 0xff, 0x38,  //................@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0x7a,  //................%@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xff, 0xff, 0xb8,  //.................@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xd8,  //.................@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //...@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //...@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //...@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xd8,  //.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xff, 0xff, 0xb8,  //.................@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0x7a,  //................%@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xe2, 0xff, 0xff, 0x36,  //................@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xca, 0x00,  //...............+@@@.
    0xa4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xf6, 0xff, 0xff, 0x50, 0x00,  //%..............@@@+.
    0xff, 0xe0, 0x5e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xf0, 0xff, 0xff, 0xa4, 0x00, 0x00,  //@@+..........+@@@%..
    0xff, 0xff, 0xff, 0xe0, 0x8e, 0x48, 0x20, 0x0a, 0x06, 0x16, 0x36, 0x70, 0xcc, 0xff, 0xff, 0xff, 0xcc, 0x0a, 0x00, 0x00,  //@@@@%+.....+@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xae, 0x0a, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@%....
    0x3c, 0xb6, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@@@@@@@@@+.....
    0x00, 0x00, 0x18, 0x68, 0xa2, 0xd0, 0xea, 0xf8, 0xf4, 0xe0, 0xc6, 0x8c, 0x46, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+%@@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+042e (Ю) , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x60, 0xa6, 0xd4, 0xe8, 0xf8, 0xe8, 0xd2, 0xa0, 0x58, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............+%@@@@@%+.......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x7e, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x70, 0x04, 0x00, 0x00, 0x00, 0x00,  //@@@..........+@@@@@@@@@@@+.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x10, 0x00, 0x00, 0x00,  //@@@.........@@@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xdc, 0xff, 0xff, 0xff, 0xe0, 0x7c, 0x36, 0x16, 0x04, 0x14, 0x34, 0x7c, 0xde, 0xff, 0xff, 0xff, 0xd6, 0x0e, 0x00, 0x00,  //@@@........@@@@@+.....+@@@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xff, 0x82, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00,  //@@@.......%@@@%.........+@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0x56, 0x00,  //@@@......+@@@+...........+@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xde, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xcc, 0x00,  //@@@......@@@%.............%@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xf4, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xf6, 0xff, 0xff, 0x38,  //@@@.....+@@@...............@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x7a,  //@@@.....%@@%...............%@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xb8,  //@@@.....@@@+...............+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xd8,  //@@@.....@@@.................@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xea,  //@@@@@@@@@@@.................@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@@@@@@@@@.................@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xea,  //@@@@@@@@@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xd8,  //@@@.....@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xb8,  //@@@.....@@@+...............+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x7c,  //@@@.....%@@%...............%@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xf4, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xf6, 0xff, 0xff, 0x3a,  //@@@.....+@@@...............@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xde, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xce, 0x00,  //@@@......@@@%.............%@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0x56, 0x00,  //@@@......+@@@+...........+@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0x80, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7e, 0xfc, 0xff, 0xff, 0xaa, 0x00, 0x00,  //@@@.......%@@@+.........+@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xda, 0xff, 0xff, 0xff, 0xe0, 0x7c, 0x34, 0x14, 0x04, 0x14, 0x32, 0x7a, 0xde, 0xff, 0xff, 0xff, 0xd4, 0x0e, 0x00, 0x00,  //@@@........@@@@@+.....+@@@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x10, 0x00, 0x00, 0x00,  //@@@.........@@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x7e, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x70, 0x04, 0x00, 0x00, 0x00, 0x00,  //@@@..........+@@@@@@@@@@@+.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x60, 0xa6, 0xd4, 0xea, 0xf8, 0xe8, 0xd2, 0xa2, 0x58, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+042f (Я) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x0c, 0x66, 0xaa, 0xda, 0xee, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....+%@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x5c, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...+@@@@@@@@@@@@@@
    0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..+@@@@@@@@@@@@@@@
    0x00, 0x22, 0xf8, 0xff, 0xff, 0xee, 0x7a, 0x2e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@@+........@@@
    0x00, 0x8e, 0xff, 0xff, 0xe4, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.%@@@..........@@@
    0x00, 0xd2, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@+..........@@@
    0x00, 0xf0, 0xff, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@...........@@@
    0x00, 0xf8, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@...........@@@
    0x00, 0xe4, 0xff, 0xff, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@...........@@@
    0x00, 0xae, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.%@@+..........@@@
    0x00, 0x4e, 0xff, 0xff, 0xe4, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.+@@@..........@@@
    0x00, 0x00, 0xa0, 0xff, 0xff, 0xee, 0x7a, 0x2e, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..%@@@+........@@@
    0x00, 0x00, 0x00, 0x6e, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...+@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x12, 0x84, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....%@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //......+@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xea, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //......@@@%.....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xff, 0xff, 0xe0, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....%@@@......@@@
    0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....+@@@+......@@@
    0x00, 0x00, 0x00, 0x08, 0xda, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@%.......@@@
    0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xee, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...%@@@........@@@
    0x00, 0x00, 0x2c, 0xfa, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@+........@@@
    0x00, 0x00, 0xc6, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@%.........@@@
    0x00, 0x6a, 0xff, 0xff, 0xf6, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.+@@@..........@@@
    0x1a, 0xf0, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@+..........@@@
    0xae, 0xff, 0xff, 0xd4, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //%@@@...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0430 (а) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x28, 0x82, 0xbe, 0xe8, 0xf8, 0xee, 0xda, 0xa6, 0x5e, 0x04, 0x00, 0x00, 0x00,  //....%%@@@@%+....
    0x00, 0x40, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x3c, 0x00, 0x00,  //..%@@@@@@@@@@...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x3c, 0x00,  //.@@@@@@@@@@@@@..
    0x00, 0xff, 0xfc, 0xba, 0x66, 0x2c, 0x10, 0x02, 0x0e, 0x34, 0x80, 0xec, 0xff, 0xff, 0xe2, 0x04,  //.@@%+.....+@@@@.
    0x00, 0xb4, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xd6, 0xff, 0xff, 0x5c,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xa6,  //............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xd8,  //.............@@@
    0x00, 0x00, 0x00, 0x28, 0x7e, 0xb8, 0xe0, 0xf0, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee,  //....+%@@@@@@@@@@
    0x00, 0x0a, 0xa2, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //..%@@@@@@@@@@@@@
    0x02, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x6a, 0xff, 0xff, 0xff, 0xb8, 0x60, 0x30, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //+@@@%+.......@@@
    0xc4, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xff,  //@@@%.........@@@
    0xee, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xff,  //@@@.........+@@@
    0xf8, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0xff,  //@@@.........@@@@
    0xdc, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x9a, 0xff, 0xff, 0xff, 0xff,  //@@@+.......%@@@@
    0x90, 0xff, 0xff, 0xfc, 0x9a, 0x36, 0x10, 0x04, 0x1e, 0x60, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff,  //%@@@%....+@@@@@@
    0x1a, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@%@@@
    0x00, 0x38, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x80, 0x00, 0xff, 0xff, 0xff,  //..@@@@@@@@@+.@@@
    0x00, 0x00, 0x10, 0x7a, 0xc8, 0xee, 0xf8, 0xe6, 0xca, 0x84, 0x26, 0x00, 0x00, 0xff, 0xff, 0xff,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0431 (б) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x2e, 0x02, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x7e, 0xb2, 0xd6, 0xec, 0xf8, 0xff, 0xff, 0xff, 0x44, 0x00,  //........+%@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9e, 0x00,  //.....+@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x08, 0xac, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xb2, 0x00,  //....%@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0xff, 0xfa, 0xba, 0x76, 0x52, 0x38, 0x2a, 0x1a, 0x0c, 0x00, 0x00, 0x00,  //...%@@@@%++.......
    0x00, 0x00, 0x78, 0xff, 0xff, 0xff, 0xae, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@%...........
    0x00, 0x18, 0xf2, 0xff, 0xfc, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@+............
    0x00, 0x78, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@+.............
    0x00, 0xd0, 0xff, 0xf2, 0x06, 0x30, 0x92, 0xd0, 0xec, 0xf8, 0xe6, 0xc4, 0x7e, 0x1c, 0x00, 0x00, 0x00, 0x00,  //.@@@..%@@@@@+.....
    0x02, 0xfc, 0xff, 0xc6, 0xa2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x7c, 0x00, 0x00, 0x00,  //.@@@%@@@@@@@@@+...
    0x1a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00,  //.@@@@@@@@@@@@@@%..
    0x2c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x5a, 0x18, 0x04, 0x18, 0x5a, 0xd4, 0xff, 0xff, 0xff, 0x66, 0x00,  //.@@@@@@+...+@@@@+.
    0x28, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb8, 0xff, 0xff, 0xec, 0x08,  //.@@@@%.......%@@@.
    0x1e, 0xff, 0xff, 0xff, 0xe4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe8, 0xff, 0xff, 0x62,  //.@@@@.........@@@+
    0x16, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xa4,  //.@@@+.........+@@%
    0x10, 0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xd8,  //.@@@...........@@@
    0x08, 0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //.@@@...........@@@
    0x00, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //.@@@...........@@@
    0x00, 0xee, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //.@@@...........@@@
    0x00, 0xd6, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xd8,  //.@@@...........@@@
    0x00, 0xa6, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xa4,  //.%@@+.........+@@%
    0x00, 0x66, 0xff, 0xff, 0xe4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe6, 0xff, 0xff, 0x62,  //.+@@@.........@@@+
    0x00, 0x0e, 0xf0, 0xff, 0xff, 0xb2, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb4, 0xff, 0xff, 0xec, 0x0a,  //..@@@%.......%@@@.
    0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xd2, 0x58, 0x16, 0x04, 0x16, 0x58, 0xd4, 0xff, 0xff, 0xff, 0x6a, 0x00,  //..+@@@@+...+@@@@+.
    0x00, 0x00, 0x02, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0x00, 0x00,  //...%@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x04, 0x98, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x86, 0x00, 0x00, 0x00,  //....%@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x8c, 0xcc, 0xea, 0xfa, 0xea, 0xca, 0x84, 0x22, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0432 (в) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xec, 0xca, 0x90, 0x2e, 0x00, 0x00, 0x00,  //@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x8a, 0x00, 0x00,  //@@@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x68, 0x00,  //@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x28, 0x7c, 0xf0, 0xff, 0xff, 0xd2, 0x00,  //@@@......+@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xff, 0xf6, 0x00,  //@@@.......+@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xe0, 0x00,  //@@@........@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xa0, 0x00,  //@@@.......+@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x2a, 0x82, 0xf4, 0xff, 0xdc, 0x1c, 0x00,  //@@@......%@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x72, 0x0e, 0x00, 0x00,  //@@@@@@@@@@@+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x76, 0x00, 0x00,  //@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x04,  //@@@@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x2e, 0x7c, 0xf2, 0xff, 0xff, 0x7a,  //@@@.......+@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xd8,  //@@@........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf8,  //@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe8,  //@@@........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x2e, 0x7c, 0xf2, 0xff, 0xff, 0xa8,  //@@@.......+@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x2a,  //@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x3e, 0x00,  //@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf2, 0xdc, 0xae, 0x64, 0x0a, 0x00, 0x00,  //@@@@@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0433 (г) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0434 (д) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....@@@......@@@...
    0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....@@@......@@@...
    0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....@@@......@@@...
    0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....@@@......@@@...
    0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....@@@......@@@...
    0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....+@@@......@@@...
    0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....+@@%......@@@...
    0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....%@@%......@@@...
    0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....@@@+......@@@...
    0x00, 0x00, 0x00, 0x1e, 0xfc, 0xff, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....@@@.......@@@...
    0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...+@@@.......@@@...
    0x00, 0x00, 0x1c, 0xec, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@+.......@@@...
    0x00, 0x38, 0xd6, 0xff, 0xff, 0xd4, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@@........@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+0435 (е) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x08, 0x64, 0xae, 0xde, 0xf4, 0xf4, 0xde, 0xa8, 0x56, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+....
    0x00, 0x00, 0x00, 0x4e, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x24, 0x00, 0x00,  //...+@@@@@@@@@@...
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x24, 0x00,  //..+@@@@@@@@@@@@..
    0x00, 0x40, 0xfc, 0xff, 0xff, 0xb6, 0x52, 0x1c, 0x04, 0x08, 0x28, 0x78, 0xee, 0xff, 0xff, 0xce, 0x00,  //..@@@%+....+@@@@.
    0x00, 0xd6, 0xff, 0xfc, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xe0, 0xff, 0xff, 0x52,  //.@@@+........@@@+
    0x4c, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xff, 0xa4,  //+@@%.........+@@%
    0x98, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xda,  //%@@...........@@@
    0xd0, 0xff, 0xff, 0xfa, 0xfa, 0xfa, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xf2,  //@@@@@@@@@@@@@@@@@
    0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@
    0xee, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xd8, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xa2, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0x58, 0xff, 0xff, 0xf2, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0x02, 0xdc, 0xff, 0xff, 0xd0, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xb8, 0x00,  //.@@@@..........%.
    0x00, 0x46, 0xfc, 0xff, 0xff, 0xee, 0x86, 0x38, 0x0e, 0x02, 0x12, 0x32, 0x6e, 0xc4, 0xff, 0xff, 0x00,  //.+@@@@%.....+@@@.
    0x00, 0x00, 0x6a, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x48, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x44, 0x00,  //...+@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x02, 0x58, 0xa2, 0xd8, 0xee, 0xfa, 0xe8, 0xc4, 0x8a, 0x34, 0x00, 0x00, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0436 (ж) , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x86, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0x86, 0x00,  //.%@@@%.......@@@.......%@@@%.
    0x00, 0x00, 0x98, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0x96, 0x00, 0x00,  //..%@@@%......@@@......%@@@%..
    0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00,  //...%@@@+.....@@@.....+@@@%...
    0x00, 0x00, 0x00, 0x04, 0xb4, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0xb4, 0x04, 0x00, 0x00, 0x00,  //....%@@@+....@@@....+@@@%....
    0x00, 0x00, 0x00, 0x00, 0x08, 0xc0, 0xff, 0xff, 0xfc, 0x54, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x54, 0xfc, 0xff, 0xff, 0xc0, 0x08, 0x00, 0x00, 0x00, 0x00,  //.....%@@@+...@@@...+@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xcc, 0xff, 0xff, 0xf8, 0x46, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x48, 0xf8, 0xff, 0xff, 0xcc, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@+..@@@..+@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd6, 0xff, 0xff, 0xf4, 0x3a, 0x00, 0xff, 0xff, 0xff, 0x00, 0x3c, 0xf4, 0xff, 0xff, 0xd6, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@..@@@..@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xee, 0x30, 0xff, 0xff, 0xff, 0x30, 0xee, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@.@@@.@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xe8, 0xff, 0xff, 0xff, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@@@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xe8, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0xe8, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@@@@@@@@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xff, 0x50, 0x36, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x36, 0x52, 0xff, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@+.@@@@@@@.+@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xe4, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x40, 0xf6, 0xff, 0xff, 0xff, 0xf6, 0x40, 0x00, 0x00, 0xa6, 0xff, 0xff, 0xe2, 0x0e, 0x00, 0x00, 0x00, 0x00,  //.....@@@%...@@@@@...%@@@.....
    0x00, 0x00, 0x00, 0x00, 0xa0, 0xff, 0xff, 0xe6, 0x12, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x12, 0xe6, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00,  //....%@@@....+@@@+....@@@%....
    0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00,  //...+@@@+.....@@@.....+@@@+...
    0x00, 0x00, 0x10, 0xe6, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0xe4, 0x10, 0x00, 0x00,  //...@@@%......@@@......%@@@...
    0x00, 0x00, 0xa4, 0xff, 0xff, 0xe4, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe4, 0xff, 0xff, 0xa4, 0x00, 0x00,  //..%@@@.......@@@.......@@@%..
    0x00, 0x50, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xff, 0x4e, 0x00,  //.+@@@+.......@@@.......+@@@+.
    0x12, 0xe8, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xff, 0xff, 0xe6, 0x12,  //.@@@%........@@@........%@@@.
    0xa8, 0xff, 0xff, 0xe4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe4, 0xff, 0xff, 0xa8,  //%@@@.........@@@.........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+0437 (з) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x24, 0x6c, 0xa8, 0xd6, 0xf2, 0xfa, 0xec, 0xca, 0x8a, 0x26, 0x00, 0x00, 0x00,  //..+%@@@@@%....
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x78, 0x00, 0x00,  //.@@@@@@@@@@+..
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x58, 0x00,  //.@@@@@@@@@@@+.
    0x00, 0xd6, 0x86, 0x48, 0x26, 0x0c, 0x0c, 0x2c, 0x8a, 0xf6, 0xff, 0xff, 0xca, 0x00,  //.@%+....%@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xf4, 0x00,  //.........+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xde, 0x00,  //..........@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0x8a, 0x00,  //.........+@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x22, 0x78, 0xf4, 0xff, 0xb4, 0x08, 0x00,  //........+@@%..
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x50, 0x00, 0x00, 0x00,  //....@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xca, 0x52, 0x00, 0x00,  //....@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa8, 0x04,  //....@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x36, 0x8a, 0xf8, 0xff, 0xff, 0x84,  //.........%@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xe2,  //..........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf6,  //...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xd8,  //..........+@@@
    0xd2, 0x80, 0x46, 0x20, 0x0a, 0x00, 0x06, 0x1e, 0x52, 0xae, 0xff, 0xff, 0xff, 0x84,  //@++.....+%@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x0c,  //@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x14, 0x00,  //@@@@@@@@@@@%..
    0x24, 0x6c, 0xa6, 0xd2, 0xee, 0xfa, 0xf4, 0xe6, 0xc0, 0x88, 0x32, 0x00, 0x00, 0x00,  //.+%@@@@@%%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0438 (и) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xfc, 0xff, 0xff, 0xff,  //@@@.........@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xd0, 0xff, 0xff, 0xff, 0xff,  //@@@........@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@.......+@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@.......@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0xce, 0xff, 0xff, 0xff,  //@@@......%@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xfc, 0x36, 0xff, 0xff, 0xff,  //@@@.....+@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe2, 0xff, 0xff, 0x96, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@%.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0xe8, 0x0e, 0x00, 0xff, 0xff, 0xff,  //@@@....%@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x32, 0xfa, 0xff, 0xff, 0x5a, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....@@@+..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@%...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xf8, 0x26, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..+@@@....@@@
    0xff, 0xff, 0xff, 0x00, 0x1a, 0xf0, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@%....@@@
    0xff, 0xff, 0xff, 0x00, 0xaa, 0xff, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.%@@@.....@@@
    0xff, 0xff, 0xff, 0x4a, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@+@@@+.....@@@
    0xff, 0xff, 0xff, 0xde, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@%......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@.......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@+.......@@@
    0xff, 0xff, 0xff, 0xff, 0xcc, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@........@@@
    0xff, 0xff, 0xff, 0xfc, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0439 (й) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0xee, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xee, 0x00, 0x00, 0x00,  //...@@......@@...
    0x00, 0x00, 0x00, 0xc0, 0xff, 0xd2, 0x40, 0x0c, 0x0c, 0x40, 0xd6, 0xff, 0xc0, 0x00, 0x00, 0x00,  //...%@@....@@%...
    0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00,  //...+@@@@@@@@+...
    0x00, 0x00, 0x00, 0x04, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x02, 0x00, 0x00, 0x00,  //....%@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x04, 0x78, 0xd0, 0xf6, 0xf6, 0xd0, 0x78, 0x04, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xfc, 0xff, 0xff, 0xff,  //@@@.........@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xd0, 0xff, 0xff, 0xff, 0xff,  //@@@........@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@.......+@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@.......@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0xce, 0xff, 0xff, 0xff,  //@@@......%@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xfc, 0x36, 0xff, 0xff, 0xff,  //@@@.....+@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe2, 0xff, 0xff, 0x96, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@%.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0xe8, 0x0e, 0x00, 0xff, 0xff, 0xff,  //@@@....%@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x32, 0xfa, 0xff, 0xff, 0x5a, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....@@@+..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@%...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xf8, 0x26, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..+@@@....@@@
    0xff, 0xff, 0xff, 0x00, 0x1a, 0xf0, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@%....@@@
    0xff, 0xff, 0xff, 0x00, 0xaa, 0xff, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.%@@@.....@@@
    0xff, 0xff, 0xff, 0x4a, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@+@@@+.....@@@
    0xff, 0xff, 0xff, 0xde, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@%......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@.......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@+.......@@@
    0xff, 0xff, 0xff, 0xff, 0xcc, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@........@@@
    0xff, 0xff, 0xff, 0xfc, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+043a (к) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0x86, 0x00,  //@@@.......%@@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0x96, 0x00, 0x00,  //@@@......%@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00,  //@@@.....+@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0xb4, 0x04, 0x00, 0x00, 0x00,  //@@@....+@@@%....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x54, 0xfc, 0xff, 0xff, 0xc0, 0x08, 0x00, 0x00, 0x00, 0x00,  //@@@...+@@@%.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x48, 0xf8, 0xff, 0xff, 0xcc, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..+@@@@......
    0xff, 0xff, 0xff, 0x00, 0x3c, 0xf4, 0xff, 0xff, 0xd6, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..@@@@.......
    0xff, 0xff, 0xff, 0x30, 0xee, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.@@@@+.......
    0xff, 0xff, 0xff, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0xf0, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@%......
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x34, 0x62, 0xff, 0xff, 0xfc, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@.+@@@......
    0xff, 0xff, 0xff, 0xf6, 0x3e, 0x00, 0x00, 0xb4, 0xff, 0xff, 0xde, 0x0a, 0x00, 0x00, 0x00, 0x00,  //@@@@...%@@@.....
    0xff, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x18, 0xec, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00,  //@@@+....@@@%....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00,  //@@@.....+@@@+...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0xe2, 0x0e, 0x00, 0x00,  //@@@......%@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xe8, 0xff, 0xff, 0xa0, 0x00, 0x00,  //@@@.......@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0xff, 0xff, 0x4c, 0x00,  //@@@.......+@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0xe6, 0x12,  //@@@........%@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe4, 0xff, 0xff, 0xa8,  //@@@.........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+043b (л) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....@@@.......@@@
    0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....@@@.......@@@
    0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....@@@.......@@@
    0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....@@@.......@@@
    0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....@@@.......@@@
    0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xff, 0xde, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....@@@.......@@@
    0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....+@@@.......@@@
    0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....+@@%.......@@@
    0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....%@@%.......@@@
    0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@+.......@@@
    0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xfc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@........@@@
    0x00, 0x00, 0x10, 0xca, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@@........@@@
    0x1e, 0x68, 0xe0, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.+@@@@+........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@%.........@@@
    0xff, 0xff, 0xff, 0xf8, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@+..........@@@
    0xe6, 0xb8, 0x7a, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@%+............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+043c (м) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@.........@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@%.......%@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@.......@@@@@@
    0xff, 0xff, 0xff, 0xc8, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xc8, 0xff, 0xff, 0xff,  //@@@@@@+.....+@@@@@@
    0xff, 0xff, 0xff, 0x5e, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0x5e, 0xff, 0xff, 0xff,  //@@@+@@@.....@@@+@@@
    0xff, 0xff, 0xff, 0x06, 0xea, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xea, 0x06, 0xff, 0xff, 0xff,  //@@@.@@@+...+@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0x88, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0x88, 0x00, 0xff, 0xff, 0xff,  //@@@.%@@%...%@@%.@@@
    0xff, 0xff, 0xff, 0x00, 0x1e, 0xfc, 0xff, 0xfc, 0x20, 0x00, 0x20, 0xfc, 0xff, 0xfc, 0x20, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@...@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0xb2, 0xff, 0xff, 0x88, 0x00, 0x8a, 0xff, 0xff, 0xb4, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..%@@%.%@@%..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x46, 0xff, 0xff, 0xea, 0x0e, 0xec, 0xff, 0xff, 0x48, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..+@@@.@@@+..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xba, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@%@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xff, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...+@@@@@+...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10, 0xf4, 0xff, 0xff, 0xff, 0xf6, 0x12, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....@@@@@....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....%@@@%....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+043d (н) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+043e (о) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x22, 0x84, 0xc8, 0xe8, 0xf8, 0xe8, 0xc8, 0x84, 0x22, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x88, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x84, 0x00, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x00, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0x00, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x6e, 0xff, 0xff, 0xff, 0xd4, 0x5a, 0x18, 0x04, 0x18, 0x5a, 0xd4, 0xff, 0xff, 0xff, 0x6c, 0x00,  //.+@@@@+...+@@@@+.
    0x0a, 0xee, 0xff, 0xff, 0xb2, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb8, 0xff, 0xff, 0xee, 0x0a,  //.@@@%.......%@@@.
    0x66, 0xff, 0xff, 0xe4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe8, 0xff, 0xff, 0x64,  //+@@@.........@@@+
    0xa8, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xa6,  //%@@+.........+@@%
    0xd8, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xd8,  //@@@...........@@@
    0xee, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@...........@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@...........@@@
    0xee, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@...........@@@
    0xd8, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xd8,  //@@@...........@@@
    0xa6, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xa4,  //%@@+.........+@@%
    0x64, 0xff, 0xff, 0xe4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe6, 0xff, 0xff, 0x62,  //+@@@.........@@@+
    0x0a, 0xee, 0xff, 0xff, 0xb2, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb4, 0xff, 0xff, 0xec, 0x0a,  //.@@@%.......%@@@.
    0x00, 0x6e, 0xff, 0xff, 0xff, 0xd2, 0x58, 0x16, 0x04, 0x16, 0x58, 0xd4, 0xff, 0xff, 0xff, 0x6a, 0x00,  //.+@@@@+...+@@@@+.
    0x00, 0x00, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0x00, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x8a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x86, 0x00, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x24, 0x86, 0xca, 0xea, 0xfa, 0xea, 0xca, 0x84, 0x22, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+043f (п) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0440 (р) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x32, 0x92, 0xd4, 0xee, 0xf4, 0xda, 0x9a, 0x34, 0x00, 0x00, 0x00, 0x00,  //@@@...%@@@@%.....
    0xff, 0xff, 0xff, 0x02, 0x8e, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x92, 0x02, 0x00, 0x00,  //@@@.%@@@@@@@@%...
    0xff, 0xff, 0xff, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa6, 0x00, 0x00,  //@@@%@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x58, 0x18, 0x04, 0x18, 0x58, 0xd2, 0xff, 0xff, 0xff, 0x66, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xb2, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb2, 0xff, 0xff, 0xec, 0x08,  //@@@@%.......%@@@.
    0xff, 0xff, 0xff, 0xe4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe4, 0xff, 0xff, 0x5e,  //@@@@.........@@@+
    0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xa2,  //@@@+.........+@@%
    0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xd6,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xd8,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xa4,  //@@@+.........+@@%
    0xff, 0xff, 0xff, 0xe4, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe4, 0xff, 0xff, 0x5e,  //@@@@.........@@@+
    0xff, 0xff, 0xff, 0xff, 0xae, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xb0, 0xff, 0xff, 0xec, 0x08,  //@@@@%.......%@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x58, 0x16, 0x04, 0x16, 0x58, 0xd0, 0xff, 0xff, 0xff, 0x68, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0xff, 0xff, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0x00,  //@@@%@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0x02, 0x90, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x96, 0x02, 0x00, 0x00,  //@@@.%@@@@@@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x36, 0x96, 0xd6, 0xf0, 0xf4, 0xdc, 0x9c, 0x36, 0x00, 0x00, 0x00, 0x00,  //@@@...%@@@@%.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0441 (с) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x98, 0xd2, 0xea, 0xfa, 0xf2, 0xda, 0xb4, 0x78, 0x28,  //.....+%@@@@@%+.
    0x00, 0x00, 0x00, 0x3a, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....@@@@@@@@@@@
    0x00, 0x00, 0x5c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..+@@@@@@@@@@@@
    0x00, 0x3c, 0xf8, 0xff, 0xff, 0xf4, 0x90, 0x40, 0x12, 0x02, 0x0a, 0x24, 0x4c, 0x88, 0xd6,  //..@@@@%.....+%@
    0x00, 0xd6, 0xff, 0xff, 0xda, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@..........
    0x4e, 0xff, 0xff, 0xf4, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@...........
    0x9a, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%...........
    0xd4, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xec, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xec, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xd4, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0x9a, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%...........
    0x4e, 0xff, 0xff, 0xf2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@...........
    0x00, 0xd4, 0xff, 0xff, 0xd8, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@..........
    0x00, 0x3c, 0xfa, 0xff, 0xff, 0xf4, 0x8e, 0x3e, 0x10, 0x02, 0x0a, 0x22, 0x4c, 0x88, 0xd4,  //..@@@@%.....+%@
    0x00, 0x00, 0x60, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..+@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x40, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x02, 0x54, 0xa0, 0xd8, 0xee, 0xfa, 0xf2, 0xda, 0xb2, 0x78, 0x28,  //.....+%@@@@@%+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0442 (т) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0443 (у) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xca, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xcc,  //@@@+..........+@@@
    0x60, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xff, 0x66,  //+@@@..........@@@+
    0x08, 0xec, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xff, 0xf4, 0x0c,  //.@@@+.........@@@.
    0x00, 0x8c, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0x9e, 0x00,  //.%@@%........%@@%.
    0x00, 0x22, 0xfc, 0xff, 0xfc, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf0, 0xff, 0xff, 0x38, 0x00,  //..@@@........@@@..
    0x00, 0x00, 0xb8, 0xff, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xd4, 0x00, 0x00,  //..%@@%......+@@@..
    0x00, 0x00, 0x4e, 0xff, 0xff, 0xe8, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0x70, 0x00, 0x00,  //..+@@@......@@@+..
    0x00, 0x00, 0x02, 0xe0, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xf6, 0x12, 0x00, 0x00,  //...@@@+.....@@@...
    0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00,  //...+@@@....%@@%...
    0x00, 0x00, 0x00, 0x16, 0xf8, 0xff, 0xff, 0x30, 0x00, 0x00, 0x06, 0xea, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00,  //....@@@....@@@+...
    0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x58, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00,  //....%@@%..+@@@....
    0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0xf4, 0x0e, 0x00, 0xbc, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00,  //.....@@@..%@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0x6e, 0x22, 0xfc, 0xff, 0xfa, 0x16, 0x00, 0x00, 0x00, 0x00,  //.....@@@+.@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xd6, 0x86, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@%@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf0, 0xff, 0xff, 0xf6, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xfc, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe8, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@%........
    0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0xff, 0xff, 0xfa, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@.........
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@%.........
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@..........
    0x00, 0x00, 0xff, 0xff, 0xfa, 0xe0, 0x92, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0444 (ф) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x12, 0x8a, 0xda, 0xf6, 0xe0, 0x8e, 0x10, 0x00, 0xff, 0xff, 0xff, 0x00, 0x12, 0x90, 0xe0, 0xf6, 0xda, 0x8a, 0x12, 0x00, 0x00, 0x00,  //....%@@@%..@@@..%@@@%....
    0x00, 0x00, 0x30, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x18, 0xff, 0xff, 0xff, 0x1a, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x2e, 0x00, 0x00,  //...@@@@@@@.@@@.@@@@@@@...
    0x00, 0x18, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0xff, 0xff, 0xff, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x18, 0x00,  //..@@@@@@@@%@@@%@@@@@@@@..
    0x00, 0xa6, 0xff, 0xff, 0xf4, 0x78, 0x1e, 0x08, 0x48, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x48, 0x08, 0x1e, 0x78, 0xf4, 0xff, 0xff, 0xa4, 0x00,  //.%@@@+..+@@@@@@@+..+@@@%.
    0x20, 0xfc, 0xff, 0xfc, 0x40, 0x00, 0x00, 0x00, 0x00, 0x12, 0xd0, 0xff, 0xff, 0xff, 0xce, 0x12, 0x00, 0x00, 0x00, 0x00, 0x44, 0xfc, 0xff, 0xfc, 0x1e,  //.@@@......@@@@@.....+@@@.
    0x78, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x78,  //+@@%.......@@@.......%@@+
    0xb2, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xb0,  //%@@+.......@@@.......+@@%
    0xde, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xdc,  //@@@........@@@........@@@
    0xf0, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xee,  //@@@........@@@........@@@
    0xfa, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@........@@@........@@@
    0xf2, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xf0,  //@@@........@@@........@@@
    0xe0, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe0,  //@@@........@@@........@@@
    0xb8, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xb6,  //%@@+.......@@@.......+@@%
    0x80, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0x80,  //+@@%.......@@@.......%@@+
    0x28, 0xff, 0xff, 0xfc, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x12, 0xce, 0xff, 0xff, 0xff, 0xce, 0x10, 0x00, 0x00, 0x00, 0x00, 0x42, 0xfc, 0xff, 0xff, 0x26,  //.@@@......@@@@@.....+@@@.
    0x00, 0xb2, 0xff, 0xff, 0xf2, 0x76, 0x1c, 0x08, 0x46, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x46, 0x08, 0x1c, 0x76, 0xf4, 0xff, 0xff, 0xb0, 0x00,  //.%@@@+..+@@@@@@@+..+@@@%.
    0x00, 0x20, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0xff, 0xff, 0xff, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x1e, 0x00,  //..@@@@@@@@%@@@%@@@@@@@@..
    0x00, 0x00, 0x36, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x16, 0xff, 0xff, 0xff, 0x18, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x36, 0x00, 0x00,  //...@@@@@@@.@@@.@@@@@@@...
    0x00, 0x00, 0x00, 0x16, 0x8e, 0xdc, 0xf6, 0xe0, 0x8e, 0x10, 0x00, 0xff, 0xff, 0xff, 0x00, 0x12, 0x90, 0xe0, 0xf6, 0xdc, 0x8e, 0x16, 0x00, 0x00, 0x00,  //....%@@@%..@@@..%@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+0445 (х) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0xa2, 0xff, 0xff, 0xee, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xee, 0xff, 0xff, 0xa2,  //.%@@@.........@@@%
    0x00, 0x0c, 0xda, 0xff, 0xff, 0xc4, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xc4, 0xff, 0xff, 0xda, 0x0c,  //..@@@@.......@@@@.
    0x00, 0x00, 0x34, 0xf8, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xf8, 0x34, 0x00,  //...@@@%.....%@@@..
    0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xfc, 0x3e, 0x00, 0x00, 0x00, 0x40, 0xfc, 0xff, 0xff, 0x74, 0x00, 0x00,  //...+@@@.....@@@+..
    0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xe2, 0x12, 0x00, 0x12, 0xe2, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00,  //....%@@@...@@@%...
    0x00, 0x00, 0x00, 0x00, 0x16, 0xe8, 0xff, 0xff, 0xae, 0x00, 0xb0, 0xff, 0xff, 0xe8, 0x16, 0x00, 0x00, 0x00,  //.....@@@%.%@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xfc, 0xff, 0xff, 0xb8, 0xff, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00,  //.....+@@@%@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xcc, 0xff, 0xff, 0xff, 0xce, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xbe, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xfc, 0xff, 0xff, 0xec, 0xff, 0xff, 0xd0, 0x04, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x1c, 0xec, 0xff, 0xff, 0xb2, 0x26, 0xf4, 0xff, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00,  //.....@@@%.@@@%....
    0x00, 0x00, 0x00, 0x04, 0xc6, 0xff, 0xff, 0xde, 0x10, 0x00, 0x6c, 0xff, 0xff, 0xfc, 0x38, 0x00, 0x00, 0x00,  //....@@@@..+@@@....
    0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0xf8, 0x34, 0x00, 0x00, 0x00, 0xba, 0xff, 0xff, 0xda, 0x0a, 0x00, 0x00,  //...%@@@....%@@@...
    0x00, 0x00, 0x54, 0xff, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xee, 0xff, 0xff, 0x96, 0x00, 0x00,  //..+@@@+.....@@@%..
    0x00, 0x24, 0xf0, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xff, 0x46, 0x00,  //..@@@%......+@@@+.
    0x08, 0xd0, 0xff, 0xff, 0xd8, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0xe4, 0x10,  //.@@@@........%@@@.
    0x9c, 0xff, 0xff, 0xf4, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xe6, 0xff, 0xff, 0xa6,  //%@@@..........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0446 (ц) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0447 (ч) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@
    0xfa, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@
    0xea, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@
    0xc0, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //%@@%........@@@
    0x76, 0xff, 0xff, 0xff, 0x9a, 0x28, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //+@@@%.......@@@
    0x10, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@
    0x00, 0x30, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@@@@@
    0x00, 0x00, 0x0e, 0x7c, 0xce, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...+@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0448 (ш) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+0449 (щ) , Width: 28 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@........@@@........@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.........................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.........................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.........................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.........................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.........................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............................


    /*Unicode: U+044a (ъ) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf2, 0xdc, 0xae, 0x64, 0x0a, 0x00, 0x00,  //......@@@@@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x42, 0x00,  //......@@@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x2a,  //......@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x2e, 0x7c, 0xf2, 0xff, 0xff, 0xa6,  //......@@@.......+@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe6,  //......@@@........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf8,  //......@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe4,  //......@@@........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x2c, 0x7a, 0xf2, 0xff, 0xff, 0xa6,  //......@@@.......+@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x2a,  //......@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x44, 0x00,  //......@@@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf4, 0xde, 0xb2, 0x68, 0x0c, 0x00, 0x00,  //......@@@@@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+044b (ы) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...............@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf0, 0xdc, 0xae, 0x64, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@@%+......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x42, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@+....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x2a, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x2e, 0x7c, 0xf2, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......+@@@%...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe6, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........+@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe4, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........+@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x2c, 0x7a, 0xf2, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......+@@@%...@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x2a, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x44, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@+....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf4, 0xde, 0xb0, 0x68, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@@%+......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+044c (ь) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf0, 0xdc, 0xae, 0x64, 0x0a, 0x00, 0x00,  //@@@@@@@@@@%+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x42, 0x00,  //@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x2a,  //@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x2e, 0x7c, 0xf2, 0xff, 0xff, 0xa6,  //@@@.......+@@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe6,  //@@@........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf8,  //@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe4,  //@@@........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x2c, 0x7a, 0xf2, 0xff, 0xff, 0xa6,  //@@@.......+@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x2a,  //@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x44, 0x00,  //@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf4, 0xde, 0xb0, 0x68, 0x0c, 0x00, 0x00,  //@@@@@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+044d (э) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x22, 0x68, 0xae, 0xd0, 0xe8, 0xf8, 0xea, 0xd2, 0x98, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+%@@@@@%+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x38, 0x00, 0x00, 0x00,  //@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x5a, 0x00, 0x00,  //@@@@@@@@@@@@+..
    0xdc, 0x98, 0x54, 0x2e, 0x16, 0x04, 0x0c, 0x26, 0x5e, 0xc2, 0xff, 0xff, 0xf8, 0x38, 0x00,  //@%+.....+@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xd2, 0x00,  //..........+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0x4c,  //...........%@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0x98,  //............@@%
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2,  //..@@@@@@@@@@@@@
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //..@@@@@@@@@@@@@
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //..@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xf8, 0xff, 0xea,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd4,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0x9a,  //...........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xec, 0xff, 0xff, 0x50,  //...........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xcc, 0xff, 0xff, 0xd8, 0x00,  //..........@@@@.
    0xdc, 0x96, 0x52, 0x2c, 0x16, 0x02, 0x10, 0x3c, 0x8e, 0xf2, 0xff, 0xff, 0xfa, 0x40, 0x00,  //@%+.....%@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x66, 0x00, 0x00,  //@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x46, 0x00, 0x00, 0x00,  //@@@@@@@@@@@+...
    0x22, 0x6c, 0xb0, 0xd0, 0xe6, 0xf8, 0xee, 0xd8, 0xa2, 0x5a, 0x04, 0x00, 0x00, 0x00, 0x00,  //.+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+044e (ю) , Width: 24 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x8c, 0xce, 0xea, 0xf8, 0xe8, 0xc6, 0x80, 0x1e, 0x00, 0x00, 0x00, 0x00,  //@@@.........%@@@@@+.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x92, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x80, 0x00, 0x00, 0x00,  //@@@.......%@@@@@@@@@+...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00,  //@@@......%@@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xd4, 0x5a, 0x18, 0x04, 0x18, 0x5a, 0xd4, 0xff, 0xff, 0xff, 0x68, 0x00,  //@@@.....+@@@@+...+@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xec, 0xff, 0xff, 0xb2, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb8, 0xff, 0xff, 0xec, 0x0a,  //@@@.....@@@%.......%@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xe4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe8, 0xff, 0xff, 0x62,  //@@@....+@@@.........@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xa4,  //@@@....%@@+.........+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xe8, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xd8,  //@@@....@@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@@@@@@@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@@@@@@@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@@@@@@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xd8,  //@@@....@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xa4,  //@@@....@@@+.........+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0xe4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe6, 0xff, 0xff, 0x62,  //@@@....%@@@.........@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xff, 0xb2, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb4, 0xff, 0xff, 0xec, 0x0a,  //@@@.....@@@%.......%@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0xff, 0xd2, 0x58, 0x16, 0x04, 0x16, 0x58, 0xd4, 0xff, 0xff, 0xff, 0x6a, 0x00,  //@@@.....%@@@@+...+@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0x00, 0x00,  //@@@......@@@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x86, 0x00, 0x00, 0x00,  //@@@.......%@@@@@@@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x96, 0xd2, 0xec, 0xfa, 0xea, 0xc8, 0x84, 0x22, 0x00, 0x00, 0x00, 0x00,  //@@@.........%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................


    /*Unicode: U+044f (я) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x1e, 0x82, 0xc2, 0xe8, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@
    0x00, 0x00, 0x62, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..+@@@@@@@@@@@@
    0x00, 0x3c, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@@@@@
    0x00, 0xb0, 0xff, 0xff, 0xfa, 0x8e, 0x2e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.%@@@%......@@@
    0x00, 0xe8, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@+.......@@@
    0x00, 0xfa, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@........@@@
    0x00, 0xe8, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@........@@@
    0x00, 0xae, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.%@@+.......@@@
    0x00, 0x34, 0xf8, 0xff, 0xfa, 0x90, 0x2e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@%......@@@
    0x00, 0x00, 0x3c, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x06, 0x52, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....+@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x1c, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xd6, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....%@@@....@@@
    0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xfc, 0x38, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...+@@@.....@@@
    0x00, 0x00, 0x18, 0xee, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@%.....@@@
    0x00, 0x00, 0xb0, 0xff, 0xff, 0xda, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..%@@@......@@@
    0x00, 0x5a, 0xff, 0xff, 0xfc, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.+@@@.......@@@
    0x14, 0xea, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@%.......@@@
    0xaa, 0xff, 0xff, 0xde, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //%@@@........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............



#endif
};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t lv_font_dejavu_40_cyrillic_glyph_dsc[] = {
#if USE_LV_FONT_DEJAVU_40_CYRILLIC == 1
    {.w_px = 23,  .glyph_index = 0},  /*Unicode: U+0410 (А)*/
    {.w_px = 18,  .glyph_index = 120},    /*Unicode: U+0411 (Б)*/
    {.w_px = 18,  .glyph_index = 240},    /*Unicode: U+0412 (В)*/
    {.w_px = 15,  .glyph_index = 360},    /*Unicode: U+0413 (Г)*/
    {.w_px = 23,  .glyph_index = 440},    /*Unicode: U+0414 (Д)*/
    {.w_px = 16,  .glyph_index = 560},    /*Unicode: U+0415 (Е)*/
    {.w_px = 35,  .glyph_index = 640},    /*Unicode: U+0416 (Ж)*/
    {.w_px = 17,  .glyph_index = 840},    /*Unicode: U+0417 (З)*/
    {.w_px = 19,  .glyph_index = 960},    /*Unicode: U+0418 (И)*/
    {.w_px = 19,  .glyph_index = 1080},   /*Unicode: U+0419 (Й)*/
    {.w_px = 20,  .glyph_index = 1200},   /*Unicode: U+041a (К)*/
    {.w_px = 21,  .glyph_index = 1320},   /*Unicode: U+041b (Л)*/
    {.w_px = 23,  .glyph_index = 1440},   /*Unicode: U+041c (М)*/
    {.w_px = 19,  .glyph_index = 1560},   /*Unicode: U+041d (Н)*/
    {.w_px = 23,  .glyph_index = 1680},   /*Unicode: U+041e (О)*/
    {.w_px = 19,  .glyph_index = 1800},   /*Unicode: U+041f (П)*/
    {.w_px = 16,  .glyph_index = 1920},   /*Unicode: U+0420 (Р)*/
    {.w_px = 20,  .glyph_index = 2000},   /*Unicode: U+0421 (С)*/
    {.w_px = 21,  .glyph_index = 2120},   /*Unicode: U+0422 (Т)*/
    {.w_px = 20,  .glyph_index = 2240},   /*Unicode: U+0423 (У)*/
    {.w_px = 25,  .glyph_index = 2360},   /*Unicode: U+0424 (Ф)*/
    {.w_px = 21,  .glyph_index = 2520},   /*Unicode: U+0425 (Х)*/
    {.w_px = 22,  .glyph_index = 2640},   /*Unicode: U+0426 (Ц)*/
    {.w_px = 17,  .glyph_index = 2760},   /*Unicode: U+0427 (Ч)*/
    {.w_px = 31,  .glyph_index = 2880},   /*Unicode: U+0428 (Ш)*/
    {.w_px = 34,  .glyph_index = 3040},   /*Unicode: U+0429 (Щ)*/
    {.w_px = 25,  .glyph_index = 3240},   /*Unicode: U+042a (Ъ)*/
    {.w_px = 23,  .glyph_index = 3400},   /*Unicode: U+042b (Ы)*/
    {.w_px = 18,  .glyph_index = 3520},   /*Unicode: U+042c (Ь)*/
    {.w_px = 20,  .glyph_index = 3640},   /*Unicode: U+042d (Э)*/
    {.w_px = 31,  .glyph_index = 3760},   /*Unicode: U+042e (Ю)*/
    {.w_px = 18,  .glyph_index = 3920},   /*Unicode: U+042f (Я)*/
    {.w_px = 16,  .glyph_index = 4040},   /*Unicode: U+0430 (а)*/
    {.w_px = 18,  .glyph_index = 4120},   /*Unicode: U+0431 (б)*/
    {.w_px = 15,  .glyph_index = 4240},   /*Unicode: U+0432 (в)*/
    {.w_px = 13,  .glyph_index = 4320},   /*Unicode: U+0433 (г)*/
    {.w_px = 20,  .glyph_index = 4400},   /*Unicode: U+0434 (д)*/
    {.w_px = 17,  .glyph_index = 4520},   /*Unicode: U+0435 (е)*/
    {.w_px = 29,  .glyph_index = 4640},   /*Unicode: U+0436 (ж)*/
    {.w_px = 14,  .glyph_index = 4800},   /*Unicode: U+0437 (з)*/
    {.w_px = 16,  .glyph_index = 4880},   /*Unicode: U+0438 (и)*/
    {.w_px = 16,  .glyph_index = 4960},   /*Unicode: U+0439 (й)*/
    {.w_px = 16,  .glyph_index = 5040},   /*Unicode: U+043a (к)*/
    {.w_px = 18,  .glyph_index = 5120},   /*Unicode: U+043b (л)*/
    {.w_px = 19,  .glyph_index = 5240},   /*Unicode: U+043c (м)*/
    {.w_px = 16,  .glyph_index = 5360},   /*Unicode: U+043d (н)*/
    {.w_px = 17,  .glyph_index = 5440},   /*Unicode: U+043e (о)*/
    {.w_px = 16,  .glyph_index = 5560},   /*Unicode: U+043f (п)*/
    {.w_px = 17,  .glyph_index = 5640},   /*Unicode: U+0440 (р)*/
    {.w_px = 15,  .glyph_index = 5760},   /*Unicode: U+0441 (с)*/
    {.w_px = 17,  .glyph_index = 5840},   /*Unicode: U+0442 (т)*/
    {.w_px = 18,  .glyph_index = 5960},   /*Unicode: U+0443 (у)*/
    {.w_px = 25,  .glyph_index = 6080},   /*Unicode: U+0444 (ф)*/
    {.w_px = 18,  .glyph_index = 6240},   /*Unicode: U+0445 (х)*/
    {.w_px = 19,  .glyph_index = 6360},   /*Unicode: U+0446 (ц)*/
    {.w_px = 15,  .glyph_index = 6480},   /*Unicode: U+0447 (ч)*/
    {.w_px = 25,  .glyph_index = 6560},   /*Unicode: U+0448 (ш)*/
    {.w_px = 28,  .glyph_index = 6720},   /*Unicode: U+0449 (щ)*/
    {.w_px = 21,  .glyph_index = 6880},   /*Unicode: U+044a (ъ)*/
    {.w_px = 21,  .glyph_index = 7000},   /*Unicode: U+044b (ы)*/
    {.w_px = 15,  .glyph_index = 7120},   /*Unicode: U+044c (ь)*/
    {.w_px = 15,  .glyph_index = 7200},   /*Unicode: U+044d (э)*/
    {.w_px = 24,  .glyph_index = 7280},   /*Unicode: U+044e (ю)*/
    {.w_px = 15,  .glyph_index = 7400},   /*Unicode: U+044f (я)*/

#elif USE_LV_FONT_DEJAVU_40_CYRILLIC == 2
    {.w_px = 23,  .glyph_index = 0},  /*Unicode: U+0410 (А)*/
    {.w_px = 18,  .glyph_index = 240},    /*Unicode: U+0411 (Б)*/
    {.w_px = 18,  .glyph_index = 440},    /*Unicode: U+0412 (В)*/
    {.w_px = 15,  .glyph_index = 640},    /*Unicode: U+0413 (Г)*/
    {.w_px = 23,  .glyph_index = 800},    /*Unicode: U+0414 (Д)*/
    {.w_px = 16,  .glyph_index = 1040},   /*Unicode: U+0415 (Е)*/
    {.w_px = 35,  .glyph_index = 1200},   /*Unicode: U+0416 (Ж)*/
    {.w_px = 17,  .glyph_index = 1560},   /*Unicode: U+0417 (З)*/
    {.w_px = 19,  .glyph_index = 1760},   /*Unicode: U+0418 (И)*/
    {.w_px = 19,  .glyph_index = 1960},   /*Unicode: U+0419 (Й)*/
    {.w_px = 20,  .glyph_index = 2160},   /*Unicode: U+041a (К)*/
    {.w_px = 21,  .glyph_index = 2360},   /*Unicode: U+041b (Л)*/
    {.w_px = 23,  .glyph_index = 2600},   /*Unicode: U+041c (М)*/
    {.w_px = 19,  .glyph_index = 2840},   /*Unicode: U+041d (Н)*/
    {.w_px = 23,  .glyph_index = 3040},   /*Unicode: U+041e (О)*/
    {.w_px = 19,  .glyph_index = 3280},   /*Unicode: U+041f (П)*/
    {.w_px = 16,  .glyph_index = 3480},   /*Unicode: U+0420 (Р)*/
    {.w_px = 20,  .glyph_index = 3640},   /*Unicode: U+0421 (С)*/
    {.w_px = 21,  .glyph_index = 3840},   /*Unicode: U+0422 (Т)*/
    {.w_px = 20,  .glyph_index = 4080},   /*Unicode: U+0423 (У)*/
    {.w_px = 25,  .glyph_index = 4280},   /*Unicode: U+0424 (Ф)*/
    {.w_px = 21,  .glyph_index = 4560},   /*Unicode: U+0425 (Х)*/
    {.w_px = 22,  .glyph_index = 4800},   /*Unicode: U+0426 (Ц)*/
    {.w_px = 17,  .glyph_index = 5040},   /*Unicode: U+0427 (Ч)*/
    {.w_px = 31,  .glyph_index = 5240},   /*Unicode: U+0428 (Ш)*/
    {.w_px = 34,  .glyph_index = 5560},   /*Unicode: U+0429 (Щ)*/
    {.w_px = 25,  .glyph_index = 5920},   /*Unicode: U+042a (Ъ)*/
    {.w_px = 23,  .glyph_index = 6200},   /*Unicode: U+042b (Ы)*/
    {.w_px = 18,  .glyph_index = 6440},   /*Unicode: U+042c (Ь)*/
    {.w_px = 20,  .glyph_index = 6640},   /*Unicode: U+042d (Э)*/
    {.w_px = 31,  .glyph_index = 6840},   /*Unicode: U+042e (Ю)*/
    {.w_px = 18,  .glyph_index = 7160},   /*Unicode: U+042f (Я)*/
    {.w_px = 16,  .glyph_index = 7360},   /*Unicode: U+0430 (а)*/
    {.w_px = 18,  .glyph_index = 7520},   /*Unicode: U+0431 (б)*/
    {.w_px = 15,  .glyph_index = 7720},   /*Unicode: U+0432 (в)*/
    {.w_px = 13,  .glyph_index = 7880},   /*Unicode: U+0433 (г)*/
    {.w_px = 20,  .glyph_index = 8040},   /*Unicode: U+0434 (д)*/
    {.w_px = 17,  .glyph_index = 8240},   /*Unicode: U+0435 (е)*/
    {.w_px = 29,  .glyph_index = 8440},   /*Unicode: U+0436 (ж)*/
    {.w_px = 14,  .glyph_index = 8760},   /*Unicode: U+0437 (з)*/
    {.w_px = 16,  .glyph_index = 8920},   /*Unicode: U+0438 (и)*/
    {.w_px = 16,  .glyph_index = 9080},   /*Unicode: U+0439 (й)*/
    {.w_px = 16,  .glyph_index = 9240},   /*Unicode: U+043a (к)*/
    {.w_px = 18,  .glyph_index = 9400},   /*Unicode: U+043b (л)*/
    {.w_px = 19,  .glyph_index = 9600},   /*Unicode: U+043c (м)*/
    {.w_px = 16,  .glyph_index = 9800},   /*Unicode: U+043d (н)*/
    {.w_px = 17,  .glyph_index = 9960},   /*Unicode: U+043e (о)*/
    {.w_px = 16,  .glyph_index = 10160},  /*Unicode: U+043f (п)*/
    {.w_px = 17,  .glyph_index = 10320},  /*Unicode: U+0440 (р)*/
    {.w_px = 15,  .glyph_index = 10520},  /*Unicode: U+0441 (с)*/
    {.w_px = 17,  .glyph_index = 10680},  /*Unicode: U+0442 (т)*/
    {.w_px = 18,  .glyph_index = 10880},  /*Unicode: U+0443 (у)*/
    {.w_px = 25,  .glyph_index = 11080},  /*Unicode: U+0444 (ф)*/
    {.w_px = 18,  .glyph_index = 11360},  /*Unicode: U+0445 (х)*/
    {.w_px = 19,  .glyph_index = 11560},  /*Unicode: U+0446 (ц)*/
    {.w_px = 15,  .glyph_index = 11760},  /*Unicode: U+0447 (ч)*/
    {.w_px = 25,  .glyph_index = 11920},  /*Unicode: U+0448 (ш)*/
    {.w_px = 28,  .glyph_index = 12200},  /*Unicode: U+0449 (щ)*/
    {.w_px = 21,  .glyph_index = 12480},  /*Unicode: U+044a (ъ)*/
    {.w_px = 21,  .glyph_index = 12720},  /*Unicode: U+044b (ы)*/
    {.w_px = 15,  .glyph_index = 12960},  /*Unicode: U+044c (ь)*/
    {.w_px = 15,  .glyph_index = 13120},  /*Unicode: U+044d (э)*/
    {.w_px = 24,  .glyph_index = 13280},  /*Unicode: U+044e (ю)*/
    {.w_px = 15,  .glyph_index = 13520},  /*Unicode: U+044f (я)*/

#elif USE_LV_FONT_DEJAVU_40_CYRILLIC == 4
    {.w_px = 23,  .glyph_index = 0},  /*Unicode: U+0410 (А)*/
    {.w_px = 18,  .glyph_index = 480},    /*Unicode: U+0411 (Б)*/
    {.w_px = 18,  .glyph_index = 840},    /*Unicode: U+0412 (В)*/
    {.w_px = 15,  .glyph_index = 1200},   /*Unicode: U+0413 (Г)*/
    {.w_px = 23,  .glyph_index = 1520},   /*Unicode: U+0414 (Д)*/
    {.w_px = 16,  .glyph_index = 2000},   /*Unicode: U+0415 (Е)*/
    {.w_px = 35,  .glyph_index = 2320},   /*Unicode: U+0416 (Ж)*/
    {.w_px = 17,  .glyph_index = 3040},   /*Unicode: U+0417 (З)*/
    {.w_px = 19,  .glyph_index = 3400},   /*Unicode: U+0418 (И)*/
    {.w_px = 19,  .glyph_index = 3800},   /*Unicode: U+0419 (Й)*/
    {.w_px = 20,  .glyph_index = 4200},   /*Unicode: U+041a (К)*/
    {.w_px = 21,  .glyph_index = 4600},   /*Unicode: U+041b (Л)*/
    {.w_px = 23,  .glyph_index = 5040},   /*Unicode: U+041c (М)*/
    {.w_px = 19,  .glyph_index = 5520},   /*Unicode: U+041d (Н)*/
    {.w_px = 23,  .glyph_index = 5920},   /*Unicode: U+041e (О)*/
    {.w_px = 19,  .glyph_index = 6400},   /*Unicode: U+041f (П)*/
    {.w_px = 16,  .glyph_index = 6800},   /*Unicode: U+0420 (Р)*/
    {.w_px = 20,  .glyph_index = 7120},   /*Unicode: U+0421 (С)*/
    {.w_px = 21,  .glyph_index = 7520},   /*Unicode: U+0422 (Т)*/
    {.w_px = 20,  .glyph_index = 7960},   /*Unicode: U+0423 (У)*/
    {.w_px = 25,  .glyph_index = 8360},   /*Unicode: U+0424 (Ф)*/
    {.w_px = 21,  .glyph_index = 8880},   /*Unicode: U+0425 (Х)*/
    {.w_px = 22,  .glyph_index = 9320},   /*Unicode: U+0426 (Ц)*/
    {.w_px = 17,  .glyph_index = 9760},   /*Unicode: U+0427 (Ч)*/
    {.w_px = 31,  .glyph_index = 10120},  /*Unicode: U+0428 (Ш)*/
    {.w_px = 34,  .glyph_index = 10760},  /*Unicode: U+0429 (Щ)*/
    {.w_px = 25,  .glyph_index = 11440},  /*Unicode: U+042a (Ъ)*/
    {.w_px = 23,  .glyph_index = 11960},  /*Unicode: U+042b (Ы)*/
    {.w_px = 18,  .glyph_index = 12440},  /*Unicode: U+042c (Ь)*/
    {.w_px = 20,  .glyph_index = 12800},  /*Unicode: U+042d (Э)*/
    {.w_px = 31,  .glyph_index = 13200},  /*Unicode: U+042e (Ю)*/
    {.w_px = 18,  .glyph_index = 13840},  /*Unicode: U+042f (Я)*/
    {.w_px = 16,  .glyph_index = 14200},  /*Unicode: U+0430 (а)*/
    {.w_px = 18,  .glyph_index = 14520},  /*Unicode: U+0431 (б)*/
    {.w_px = 15,  .glyph_index = 14880},  /*Unicode: U+0432 (в)*/
    {.w_px = 13,  .glyph_index = 15200},  /*Unicode: U+0433 (г)*/
    {.w_px = 20,  .glyph_index = 15480},  /*Unicode: U+0434 (д)*/
    {.w_px = 17,  .glyph_index = 15880},  /*Unicode: U+0435 (е)*/
    {.w_px = 29,  .glyph_index = 16240},  /*Unicode: U+0436 (ж)*/
    {.w_px = 14,  .glyph_index = 16840},  /*Unicode: U+0437 (з)*/
    {.w_px = 16,  .glyph_index = 17120},  /*Unicode: U+0438 (и)*/
    {.w_px = 16,  .glyph_index = 17440},  /*Unicode: U+0439 (й)*/
    {.w_px = 16,  .glyph_index = 17760},  /*Unicode: U+043a (к)*/
    {.w_px = 18,  .glyph_index = 18080},  /*Unicode: U+043b (л)*/
    {.w_px = 19,  .glyph_index = 18440},  /*Unicode: U+043c (м)*/
    {.w_px = 16,  .glyph_index = 18840},  /*Unicode: U+043d (н)*/
    {.w_px = 17,  .glyph_index = 19160},  /*Unicode: U+043e (о)*/
    {.w_px = 16,  .glyph_index = 19520},  /*Unicode: U+043f (п)*/
    {.w_px = 17,  .glyph_index = 19840},  /*Unicode: U+0440 (р)*/
    {.w_px = 15,  .glyph_index = 20200},  /*Unicode: U+0441 (с)*/
    {.w_px = 17,  .glyph_index = 20520},  /*Unicode: U+0442 (т)*/
    {.w_px = 18,  .glyph_index = 20880},  /*Unicode: U+0443 (у)*/
    {.w_px = 25,  .glyph_index = 21240},  /*Unicode: U+0444 (ф)*/
    {.w_px = 18,  .glyph_index = 21760},  /*Unicode: U+0445 (х)*/
    {.w_px = 19,  .glyph_index = 22120},  /*Unicode: U+0446 (ц)*/
    {.w_px = 15,  .glyph_index = 22520},  /*Unicode: U+0447 (ч)*/
    {.w_px = 25,  .glyph_index = 22840},  /*Unicode: U+0448 (ш)*/
    {.w_px = 28,  .glyph_index = 23360},  /*Unicode: U+0449 (щ)*/
    {.w_px = 21,  .glyph_index = 23920},  /*Unicode: U+044a (ъ)*/
    {.w_px = 21,  .glyph_index = 24360},  /*Unicode: U+044b (ы)*/
    {.w_px = 15,  .glyph_index = 24800},  /*Unicode: U+044c (ь)*/
    {.w_px = 15,  .glyph_index = 25120},  /*Unicode: U+044d (э)*/
    {.w_px = 24,  .glyph_index = 25440},  /*Unicode: U+044e (ю)*/
    {.w_px = 15,  .glyph_index = 25920},  /*Unicode: U+044f (я)*/

#elif USE_LV_FONT_DEJAVU_40_CYRILLIC == 8
    {.w_px = 23,  .glyph_index = 0},  /*Unicode: U+0410 (А)*/
    {.w_px = 18,  .glyph_index = 920},    /*Unicode: U+0411 (Б)*/
    {.w_px = 18,  .glyph_index = 1640},   /*Unicode: U+0412 (В)*/
    {.w_px = 15,  .glyph_index = 2360},   /*Unicode: U+0413 (Г)*/
    {.w_px = 23,  .glyph_index = 2960},   /*Unicode: U+0414 (Д)*/
    {.w_px = 16,  .glyph_index = 3880},   /*Unicode: U+0415 (Е)*/
    {.w_px = 35,  .glyph_index = 4520},   /*Unicode: U+0416 (Ж)*/
    {.w_px = 17,  .glyph_index = 5920},   /*Unicode: U+0417 (З)*/
    {.w_px = 19,  .glyph_index = 6600},   /*Unicode: U+0418 (И)*/
    {.w_px = 19,  .glyph_index = 7360},   /*Unicode: U+0419 (Й)*/
    {.w_px = 20,  .glyph_index = 8120},   /*Unicode: U+041a (К)*/
    {.w_px = 21,  .glyph_index = 8920},   /*Unicode: U+041b (Л)*/
    {.w_px = 23,  .glyph_index = 9760},   /*Unicode: U+041c (М)*/
    {.w_px = 19,  .glyph_index = 10680},  /*Unicode: U+041d (Н)*/
    {.w_px = 23,  .glyph_index = 11440},  /*Unicode: U+041e (О)*/
    {.w_px = 19,  .glyph_index = 12360},  /*Unicode: U+041f (П)*/
    {.w_px = 16,  .glyph_index = 13120},  /*Unicode: U+0420 (Р)*/
    {.w_px = 20,  .glyph_index = 13760},  /*Unicode: U+0421 (С)*/
    {.w_px = 21,  .glyph_index = 14560},  /*Unicode: U+0422 (Т)*/
    {.w_px = 20,  .glyph_index = 15400},  /*Unicode: U+0423 (У)*/
    {.w_px = 25,  .glyph_index = 16200},  /*Unicode: U+0424 (Ф)*/
    {.w_px = 21,  .glyph_index = 17200},  /*Unicode: U+0425 (Х)*/
    {.w_px = 22,  .glyph_index = 18040},  /*Unicode: U+0426 (Ц)*/
    {.w_px = 17,  .glyph_index = 18920},  /*Unicode: U+0427 (Ч)*/
    {.w_px = 31,  .glyph_index = 19600},  /*Unicode: U+0428 (Ш)*/
    {.w_px = 34,  .glyph_index = 20840},  /*Unicode: U+0429 (Щ)*/
    {.w_px = 25,  .glyph_index = 22200},  /*Unicode: U+042a (Ъ)*/
    {.w_px = 23,  .glyph_index = 23200},  /*Unicode: U+042b (Ы)*/
    {.w_px = 18,  .glyph_index = 24120},  /*Unicode: U+042c (Ь)*/
    {.w_px = 20,  .glyph_index = 24840},  /*Unicode: U+042d (Э)*/
    {.w_px = 31,  .glyph_index = 25640},  /*Unicode: U+042e (Ю)*/
    {.w_px = 18,  .glyph_index = 26880},  /*Unicode: U+042f (Я)*/
    {.w_px = 16,  .glyph_index = 27600},  /*Unicode: U+0430 (а)*/
    {.w_px = 18,  .glyph_index = 28240},  /*Unicode: U+0431 (б)*/
    {.w_px = 15,  .glyph_index = 28960},  /*Unicode: U+0432 (в)*/
    {.w_px = 13,  .glyph_index = 29560},  /*Unicode: U+0433 (г)*/
    {.w_px = 20,  .glyph_index = 30080},  /*Unicode: U+0434 (д)*/
    {.w_px = 17,  .glyph_index = 30880},  /*Unicode: U+0435 (е)*/
    {.w_px = 29,  .glyph_index = 31560},  /*Unicode: U+0436 (ж)*/
    {.w_px = 14,  .glyph_index = 32720},  /*Unicode: U+0437 (з)*/
    {.w_px = 16,  .glyph_index = 33280},  /*Unicode: U+0438 (и)*/
    {.w_px = 16,  .glyph_index = 33920},  /*Unicode: U+0439 (й)*/
    {.w_px = 16,  .glyph_index = 34560},  /*Unicode: U+043a (к)*/
    {.w_px = 18,  .glyph_index = 35200},  /*Unicode: U+043b (л)*/
    {.w_px = 19,  .glyph_index = 35920},  /*Unicode: U+043c (м)*/
    {.w_px = 16,  .glyph_index = 36680},  /*Unicode: U+043d (н)*/
    {.w_px = 17,  .glyph_index = 37320},  /*Unicode: U+043e (о)*/
    {.w_px = 16,  .glyph_index = 38000},  /*Unicode: U+043f (п)*/
    {.w_px = 17,  .glyph_index = 38640},  /*Unicode: U+0440 (р)*/
    {.w_px = 15,  .glyph_index = 39320},  /*Unicode: U+0441 (с)*/
    {.w_px = 17,  .glyph_index = 39920},  /*Unicode: U+0442 (т)*/
    {.w_px = 18,  .glyph_index = 40600},  /*Unicode: U+0443 (у)*/
    {.w_px = 25,  .glyph_index = 41320},  /*Unicode: U+0444 (ф)*/
    {.w_px = 18,  .glyph_index = 42320},  /*Unicode: U+0445 (х)*/
    {.w_px = 19,  .glyph_index = 43040},  /*Unicode: U+0446 (ц)*/
    {.w_px = 15,  .glyph_index = 43800},  /*Unicode: U+0447 (ч)*/
    {.w_px = 25,  .glyph_index = 44400},  /*Unicode: U+0448 (ш)*/
    {.w_px = 28,  .glyph_index = 45400},  /*Unicode: U+0449 (щ)*/
    {.w_px = 21,  .glyph_index = 46520},  /*Unicode: U+044a (ъ)*/
    {.w_px = 21,  .glyph_index = 47360},  /*Unicode: U+044b (ы)*/
    {.w_px = 15,  .glyph_index = 48200},  /*Unicode: U+044c (ь)*/
    {.w_px = 15,  .glyph_index = 48800},  /*Unicode: U+044d (э)*/
    {.w_px = 24,  .glyph_index = 49400},  /*Unicode: U+044e (ю)*/
    {.w_px = 15,  .glyph_index = 50360},  /*Unicode: U+044f (я)*/

#endif
};

lv_font_t lv_font_dejavu_40_cyrillic = {
    .unicode_first = 1040,  /*First Unicode letter in this font*/
    .unicode_last = 1103,   /*Last Unicode letter in this font*/
    .h_px = 40,             /*Font height in pixels*/
    .glyph_bitmap = lv_font_dejavu_40_cyrillic_glyph_bitmap,    /*Bitmap of glyphs*/
    .glyph_dsc = lv_font_dejavu_40_cyrillic_glyph_dsc,      /*Description of glyphs*/
    .glyph_cnt = 64,            /*Number of glyphs in the font*/
    .unicode_list = NULL,   /*Every character in the font from 'unicode_first' to 'unicode_last'*/
    .get_bitmap = lv_font_get_bitmap_continuous,    /*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,  /*Function pointer to get glyph's width*/
#if USE_LV_FONT_DEJAVU_40_CYRILLIC == 1
    .bpp = 1,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_40_CYRILLIC == 2
    .bpp = 2,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_40_CYRILLIC == 4
    .bpp = 4,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_40_CYRILLIC == 8
    .bpp = 8,               /*Bit per pixel*/
#endif
    .next_page = NULL,      /*Pointer to a font extension*/
};

#endif /*USE_LV_FONT_DEJAVU_40_CYRILLIC*/
