
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_DEJAVU_40 != 0  /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * DejaVuSans.ttf 40 px Font in U+0020 ( ) .. U+007e (~)  range with 1 bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_dejavu_40_glyph_bitmap[] = {
#if USE_LV_FONT_DEJAVU_40 == 1
    /*Unicode: U+0020 ( ) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0021 (!) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //%@%
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0022 (") , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xe3, 0x80,  //@@@...@@@
    0xe3, 0x80,  //@@@...@@@
    0xe3, 0x80,  //@@@...@@@
    0xe3, 0x80,  //@@@...@@@
    0xe3, 0x80,  //@@@...@@@
    0xe3, 0x80,  //@@@...@@@
    0xe3, 0x80,  //@@@...@@@
    0xe3, 0x80,  //@@@...@@@
    0xe3, 0x80,  //@@@...@@@
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0023 (#) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x70, 0x60,  //.........%@@.....@@+...
    0x00, 0x70, 0x60,  //.........@@%....+@@....
    0x00, 0x70, 0xe0,  //.........@@%....%@@....
    0x00, 0x60, 0xe0,  //........+@@+....@@%....
    0x00, 0xe0, 0xc0,  //........%@@.....@@+....
    0x00, 0xe0, 0xc0,  //........@@@....+@@.....
    0x00, 0xe1, 0xc0,  //........@@%....%@@.....
    0x3f, 0xff, 0xfe,  //..@@@@@@@@@@@@@@@@@@@@@
    0x3f, 0xff, 0xfe,  //..@@@@@@@@@@@@@@@@@@@@@
    0x3f, 0xff, 0xfe,  //..@@@@@@@@@@@@@@@@@@@@@
    0x01, 0xc3, 0x80,  //.......@@%....%@@......
    0x01, 0x83, 0x80,  //.......@@+....@@@......
    0x03, 0x83, 0x80,  //......%@@.....@@%......
    0x03, 0x83, 0x00,  //......@@@....+@@+......
    0x03, 0x87, 0x00,  //......@@%....%@@.......
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@..
    0x07, 0x0e, 0x00,  //.....@@%....%@@........
    0x06, 0x0e, 0x00,  //.....@@+....%@@........
    0x06, 0x0e, 0x00,  //....+@@.....@@%........
    0x0e, 0x0c, 0x00,  //....%@@.....@@+........
    0x0e, 0x0c, 0x00,  //....@@%....+@@.........
    0x0c, 0x1c, 0x00,  //....@@+....%@@.........
    0x0c, 0x1c, 0x00,  //...+@@.....@@%.........
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0024 ($) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x0f, 0xf0,  //....%@@@@@@%+...
    0x3f, 0xfc,  //..%@@@@@@@@@@@..
    0x7f, 0xfc,  //.@@@@@@@@@@@@@..
    0x79, 0x8c,  //+@@@%+.@@..+%@..
    0xf1, 0x80,  //@@@%...@@.......
    0xe1, 0x80,  //@@@....@@.......
    0xe1, 0x80,  //@@@....@@.......
    0xf1, 0x80,  //@@@%...@@.......
    0x7d, 0x80,  //+@@@@%+@@.......
    0x7f, 0xe0,  //.%@@@@@@@@%+....
    0x1f, 0xf8,  //..+@@@@@@@@@@+..
    0x03, 0xfc,  //.....+%@@@@@@@+.
    0x01, 0xbe,  //.......@@.%@@@@.
    0x01, 0x8f,  //.......@@...@@@%
    0x01, 0x87,  //.......@@....@@@
    0x01, 0x87,  //.......@@....@@@
    0x01, 0x87,  //.......@@....@@@
    0x81, 0x8f,  //%......@@...%@@%
    0xe1, 0x9e,  //@@@+...@@.+@@@@+
    0xff, 0xfe,  //@@@@@@@@@@@@@@%.
    0x7f, 0xfc,  //.%@@@@@@@@@@@%..
    0x0f, 0xe0,  //...+%@@@@@%+....
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0025 (%) , Width: 29 */
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x1f, 0x00, 0x07, 0x00,  //...%@@@%.............@@%.....
    0x3f, 0x80, 0x06, 0x00,  //..@@@@@@@...........+@@......
    0x71, 0xc0, 0x0c, 0x00,  //.@@@+.+@@@..........@@+......
    0x71, 0xc0, 0x1c, 0x00,  //+@@%...%@@+........%@%.......
    0xe0, 0xe0, 0x18, 0x00,  //%@@+...+@@%.......+@@........
    0xe0, 0xe0, 0x30, 0x00,  //@@@.....@@@.......@@+........
    0xe0, 0xe0, 0x70, 0x00,  //@@@.....@@@......%@%.........
    0xe0, 0xe0, 0x60, 0x00,  //@@@.....@@@.....+@@..........
    0xe0, 0xe0, 0xc0, 0x00,  //@@@.....@@@.....@@+..........
    0xe0, 0xe1, 0xc0, 0x00,  //%@@....+@@%....%@%...........
    0x71, 0xc1, 0x80, 0x00,  //+@@%...%@@+...+@@............
    0x71, 0xc3, 0x07, 0xc0,  //.@@@+.+@@@....@@+....%@@@%...
    0x3f, 0x87, 0x0f, 0xe0,  //..@@@@@@@....%@%....@@@@@@@..
    0x1f, 0x06, 0x1c, 0x70,  //...%@@@%....+@@....@@@+.+@@@.
    0x00, 0x0c, 0x1c, 0x70,  //............@@+...+@@%...%@@+
    0x00, 0x1c, 0x38, 0x38,  //...........%@%....%@@+...+@@%
    0x00, 0x18, 0x38, 0x38,  //..........+@@.....@@@.....@@@
    0x00, 0x30, 0x38, 0x38,  //..........@@+.....@@@.....@@@
    0x00, 0x70, 0x38, 0x38,  //.........%@%......@@@.....@@@
    0x00, 0x60, 0x38, 0x38,  //........+@@.......@@@.....@@@
    0x00, 0xc0, 0x38, 0x38,  //........@@+.......%@@+...+@@%
    0x01, 0xc0, 0x1c, 0x70,  //.......%@%........+@@%...%@@+
    0x01, 0x80, 0x1c, 0x70,  //......+@@..........@@@+.+@@@.
    0x03, 0x00, 0x0f, 0xe0,  //......@@+...........@@@@@@@..
    0x07, 0x00, 0x07, 0xc0,  //.....%@@.............%@@@%...
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+0026 (&) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x01, 0xf8, 0x00,  //......+%@@@@%+.........
    0x07, 0xfe, 0x00,  //.....@@@@@@@@@@........
    0x0f, 0xfe, 0x00,  //....@@@@@@@@@@@........
    0x1f, 0x06, 0x00,  //...+@@@%....+%@........
    0x1e, 0x00, 0x00,  //...@@@%................
    0x1c, 0x00, 0x00,  //...@@@.................
    0x1c, 0x00, 0x00,  //...@@@.................
    0x1c, 0x00, 0x00,  //...@@@+................
    0x1e, 0x00, 0x00,  //...%@@@................
    0x0f, 0x00, 0x00,  //....@@@@...............
    0x0f, 0x80, 0x00,  //...+@@@@@..............
    0x1f, 0xc0, 0x00,  //..+@@@@@@@.............
    0x3d, 0xe0, 0x1c,  //.+@@@@+@@@@........@@@.
    0x78, 0xf0, 0x1c,  //.@@@@..+@@@@......+@@%.
    0x70, 0x78, 0x38,  //+@@@....+@@@@.....@@@+.
    0xe0, 0x3c, 0x38,  //@@@+.....+@@@@....@@@..
    0xe0, 0x1e, 0x78,  //@@@.......+@@@@..@@@%..
    0xe0, 0x0f, 0xf0,  //@@@........+@@@@%@@@...
    0xe0, 0x07, 0xe0,  //@@@+........+@@@@@@+...
    0xf0, 0x07, 0xe0,  //%@@@.........%@@@@@....
    0x78, 0x07, 0xe0,  //.@@@%.......+@@@@@@+...
    0x7c, 0x1f, 0xf0,  //.%@@@@+...+%@@@@@@@@...
    0x3f, 0xfe, 0xf8,  //..%@@@@@@@@@@@@.%@@@@..
    0x1f, 0xfc, 0x7c,  //...+@@@@@@@@@%...%@@@%.
    0x03, 0xf0, 0x3e,  //.....+%@@@@%+.....%@@@%
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0027 (') , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0028 (() , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x07,  //....+@@%
    0x0e,  //....@@@.
    0x1c,  //...%@@+.
    0x1c,  //...@@@..
    0x38,  //..%@@+..
    0x38,  //..@@@...
    0x38,  //.+@@%...
    0x70,  //.%@@....
    0x70,  //.@@@....
    0x70,  //+@@%....
    0xe0,  //%@@+....
    0xe0,  //%@@+....
    0xe0,  //@@@.....
    0xe0,  //@@@.....
    0xe0,  //@@@.....
    0xe0,  //@@@.....
    0xe0,  //@@@.....
    0xe0,  //@@@.....
    0xe0,  //%@@+....
    0xe0,  //%@@+....
    0x70,  //+@@%....
    0x70,  //.@@@....
    0x70,  //.%@@....
    0x38,  //.+@@%...
    0x38,  //..@@@...
    0x38,  //..%@@+..
    0x1c,  //...@@@..
    0x1c,  //...%@@+.
    0x0e,  //....@@@.
    0x07,  //....+@@%
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0029 ()) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xe0,  //%@@+....
    0x70,  //.@@@....
    0x30,  //.+@@+...
    0x38,  //..@@@...
    0x1c,  //..+@@%..
    0x1c,  //...@@@..
    0x1c,  //...%@@+.
    0x0e,  //....@@%.
    0x0e,  //....@@@.
    0x0e,  //....%@@+
    0x07,  //....+@@%
    0x07,  //....+@@%
    0x07,  //.....@@@
    0x07,  //.....@@@
    0x07,  //.....@@@
    0x07,  //.....@@@
    0x07,  //.....@@@
    0x07,  //.....@@@
    0x07,  //....+@@%
    0x07,  //....+@@%
    0x0e,  //....%@@+
    0x0e,  //....@@@.
    0x0e,  //....@@%.
    0x1c,  //...%@@+.
    0x1c,  //...@@@..
    0x1c,  //..+@@%..
    0x38,  //..@@@...
    0x38,  //.+@@+...
    0x70,  //.@@@....
    0xe0,  //%@@+....
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+002a (*) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x41, 0x82,  //+%.....@@.....%+
    0xf1, 0x8f,  //@@@%...@@...%@@%
    0x39, 0x9c,  //.+@@@+.@@.+@@@+.
    0x1f, 0xf8,  //...+@@@@@@@@+...
    0x07, 0xe0,  //.....%@@@@%.....
    0x07, 0xe0,  //.....%@@@@%.....
    0x0f, 0xf0,  //...+@@@@@@@@+...
    0x39, 0x9c,  //.+@@@+.@@.+@@@+.
    0xf1, 0x8f,  //%@@%...@@...%@@%
    0x41, 0x82,  //+%.....@@.....%+
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+002b (+) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+002c (,) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x70,  //.@@@
    0x70,  //.@@@
    0x70,  //.@@@
    0x70,  //.@@%
    0x60,  //+@@+
    0xe0,  //%@@.
    0xe0,  //%@%.
    0xc0,  //@@..
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+002d (-) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xff, 0x80,  //@@@@@@@@@
    0xff, 0x80,  //@@@@@@@@@
    0xff, 0x80,  //@@@@@@@@@
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+002e (.) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+002f (/) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0xe0,  //........@@@
    0x01, 0xe0,  //.......%@@%
    0x01, 0xc0,  //.......@@@+
    0x01, 0xc0,  //.......@@@.
    0x01, 0xc0,  //......+@@%.
    0x03, 0x80,  //......%@@+.
    0x03, 0x80,  //......@@@..
    0x03, 0x80,  //......@@@..
    0x07, 0x80,  //.....+@@%..
    0x07, 0x00,  //.....@@@+..
    0x07, 0x00,  //.....@@@...
    0x07, 0x00,  //....+@@@...
    0x0e, 0x00,  //....%@@+...
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //...+@@%....
    0x1c, 0x00,  //...@@@+....
    0x1c, 0x00,  //...@@@.....
    0x1c, 0x00,  //..+@@@.....
    0x3c, 0x00,  //..%@@%.....
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //.+@@%......
    0x70, 0x00,  //.%@@+......
    0x70, 0x00,  //.@@@.......
    0x70, 0x00,  //+@@@.......
    0xf0, 0x00,  //%@@%.......
    0xe0, 0x00,  //@@@+.......
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0030 (0) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x03, 0xe0, 0x00,  //.....+%@@@%+.....
    0x0f, 0xf8, 0x00,  //...+@@@@@@@@@....
    0x1f, 0xfc, 0x00,  //...@@@@@@@@@@@...
    0x3c, 0x1e, 0x00,  //..@@@@+...+@@@@..
    0x78, 0x0f, 0x00,  //.%@@@.......@@@+.
    0x70, 0x07, 0x00,  //.@@@+.......+@@@.
    0x70, 0x07, 0x00,  //.@@@.........@@@.
    0xf0, 0x07, 0x80,  //%@@%.........%@@+
    0xe0, 0x03, 0x80,  //%@@+.........+@@%
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //%@@+.........+@@%
    0xf0, 0x07, 0x80,  //%@@%.........%@@%
    0x70, 0x07, 0x00,  //+@@@.........@@@.
    0x70, 0x07, 0x00,  //.@@@+.......+@@@.
    0x78, 0x0f, 0x00,  //.%@@@.......@@@+.
    0x3c, 0x1e, 0x00,  //..@@@@+...+@@@@..
    0x1f, 0xfc, 0x00,  //...@@@@@@@@@@@...
    0x0f, 0xf8, 0x00,  //...+@@@@@@@@@....
    0x03, 0xe0, 0x00,  //.....+%@@@%+.....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0031 (1) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x1f, 0x80,  //..+%@@@@@.....
    0xff, 0x80,  //@@@@@@@@@.....
    0xff, 0x80,  //@@@@@@@@@.....
    0xe3, 0x80,  //@%%+..@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x03, 0x80,  //......@@@.....
    0x7f, 0xfc,  //.@@@@@@@@@@@@@
    0x7f, 0xfc,  //.@@@@@@@@@@@@@
    0x7f, 0xfc,  //.@@@@@@@@@@@@@
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0032 (2) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x3f, 0xe0, 0x00,  //.+%%@@@@@@%+.....
    0xff, 0xf8, 0x00,  //@@@@@@@@@@@@@....
    0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@+..
    0xf0, 0x3e, 0x00,  //@@@%+.....%@@@@..
    0x80, 0x0f, 0x00,  //@+.........+@@@%.
    0x00, 0x07, 0x00,  //............+@@@.
    0x00, 0x07, 0x00,  //.............@@@.
    0x00, 0x07, 0x00,  //.............@@@.
    0x00, 0x07, 0x00,  //.............@@@.
    0x00, 0x0f, 0x00,  //............%@@%.
    0x00, 0x0e, 0x00,  //............@@@..
    0x00, 0x1c, 0x00,  //...........@@@+..
    0x00, 0x3c, 0x00,  //..........@@@%...
    0x00, 0x78, 0x00,  //.........@@@@....
    0x00, 0xf0, 0x00,  //........@@@@.....
    0x01, 0xe0, 0x00,  //.......@@@@......
    0x03, 0xc0, 0x00,  //......@@@@.......
    0x07, 0x80, 0x00,  //.....@@@@........
    0x0f, 0x00, 0x00,  //...+@@@@.........
    0x1e, 0x00, 0x00,  //..+@@@@..........
    0x3c, 0x00, 0x00,  //.+@@@@...........
    0x78, 0x00, 0x00,  //+@@@@............
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0033 (3) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x1f, 0xe0,  //..+%@@@@@@%.....
    0x7f, 0xf8,  //.@@@@@@@@@@@%...
    0x7f, 0xfc,  //.@@@@@@@@@@@@%..
    0x60, 0x3c,  //.@%+.....+@@@@+.
    0x00, 0x1e,  //...........%@@%.
    0x00, 0x0e,  //............@@@.
    0x00, 0x0e,  //............@@@.
    0x00, 0x0e,  //............@@@.
    0x00, 0x1c,  //...........%@@+.
    0x00, 0x3c,  //.........+@@@@..
    0x0f, 0xf8,  //....@@@@@@@@%...
    0x0f, 0xf0,  //....@@@@@@@%....
    0x0f, 0xf8,  //....@@@@@@@@@+..
    0x00, 0x3e,  //.........+%@@@%.
    0x00, 0x0e,  //...........+@@@+
    0x00, 0x07,  //............+@@%
    0x00, 0x07,  //.............@@@
    0x00, 0x07,  //.............@@@
    0x00, 0x07,  //.............@@@
    0x00, 0x0f,  //............%@@%
    0x00, 0x0e,  //...........+@@@+
    0xc0, 0x3e,  //@%+......+%@@@@.
    0xff, 0xfc,  //@@@@@@@@@@@@@@..
    0xff, 0xf8,  //@@@@@@@@@@@@%...
    0x3f, 0xc0,  //.+%@@@@@@%+.....
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0034 (4) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x3e, 0x00,  //..........%@@@@....
    0x00, 0x3e, 0x00,  //.........+@@@@@....
    0x00, 0x7e, 0x00,  //.........@@@@@@....
    0x00, 0xee, 0x00,  //........%@@.@@@....
    0x00, 0xce, 0x00,  //.......+@@+.@@@....
    0x01, 0xce, 0x00,  //.......@@@..@@@....
    0x03, 0x8e, 0x00,  //......%@@...@@@....
    0x03, 0x0e, 0x00,  //.....+@@+...@@@....
    0x07, 0x0e, 0x00,  //.....@@@....@@@....
    0x0e, 0x0e, 0x00,  //....@@@.....@@@....
    0x0c, 0x0e, 0x00,  //...+@@+.....@@@....
    0x1c, 0x0e, 0x00,  //...@@@......@@@....
    0x38, 0x0e, 0x00,  //..@@@.......@@@....
    0x30, 0x0e, 0x00,  //.+@@+.......@@@....
    0x70, 0x0e, 0x00,  //.@@@........@@@....
    0xe0, 0x0e, 0x00,  //@@@.........@@@....
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0x00, 0x0e, 0x00,  //............@@@....
    0x00, 0x0e, 0x00,  //............@@@....
    0x00, 0x0e, 0x00,  //............@@@....
    0x00, 0x0e, 0x00,  //............@@@....
    0x00, 0x0e, 0x00,  //............@@@....
    0x00, 0x0e, 0x00,  //............@@@....
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0035 (5) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x7f, 0xfc,  //.@@@@@@@@@@@@@..
    0x7f, 0xfc,  //.@@@@@@@@@@@@@..
    0x7f, 0xfc,  //.@@@@@@@@@@@@@..
    0x70, 0x00,  //.@@@............
    0x70, 0x00,  //.@@@............
    0x70, 0x00,  //.@@@............
    0x70, 0x00,  //.@@@............
    0x70, 0x00,  //.@@@............
    0x70, 0x00,  //.@@@............
    0x7f, 0xc0,  //.@@@%@@@@%+.....
    0x7f, 0xf8,  //.@@@@@@@@@@@%...
    0x7f, 0xfc,  //.@@@@@@@@@@@@@..
    0x60, 0x3e,  //.@%+.....+@@@@%.
    0x00, 0x1e,  //...........%@@@+
    0x00, 0x0f,  //............%@@%
    0x00, 0x07,  //.............@@@
    0x00, 0x07,  //.............@@@
    0x00, 0x07,  //.............@@@
    0x00, 0x07,  //.............@@@
    0x00, 0x0f,  //............%@@%
    0x00, 0x1e,  //...........%@@@+
    0xc0, 0x3e,  //@%+......+@@@@%.
    0xff, 0xfc,  //@@@@@@@@@@@@@@..
    0xff, 0xf8,  //@@@@@@@@@@@@%...
    0x3f, 0xc0,  //.+%@@@@@@%+.....
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0036 (6) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x01, 0xf8, 0x00,  //......+%@@@@%+...
    0x07, 0xfe, 0x00,  //....+@@@@@@@@@@..
    0x0f, 0xfe, 0x00,  //...+@@@@@@@@@@@..
    0x1e, 0x06, 0x00,  //..+@@@@+....+%@..
    0x3c, 0x00, 0x00,  //..@@@%...........
    0x78, 0x00, 0x00,  //.%@@@............
    0x70, 0x00, 0x00,  //.@@@+............
    0x70, 0x00, 0x00,  //+@@@.............
    0xf0, 0x00, 0x00,  //%@@%.............
    0xe3, 0xf0, 0x00,  //@@@+..%@@@@%+....
    0xe7, 0xfc, 0x00,  //@@@.+@@@@@@@@@...
    0xef, 0xfe, 0x00,  //@@@+@@@@@@@@@@@..
    0xfe, 0x1f, 0x00,  //@@@@@@%....%@@@@.
    0xf8, 0x07, 0x00,  //@@@@@+......+@@@+
    0xf8, 0x07, 0x80,  //@@@@%........%@@%
    0xf0, 0x03, 0x80,  //@@@@..........@@@
    0xf0, 0x03, 0x80,  //%@@@..........@@@
    0x70, 0x03, 0x80,  //+@@@..........@@@
    0x70, 0x03, 0x80,  //.@@@..........@@@
    0x78, 0x07, 0x80,  //.@@@%........%@@%
    0x38, 0x07, 0x00,  //.+@@@+......+@@@+
    0x3e, 0x1f, 0x00,  //..@@@@%....%@@@@.
    0x1f, 0xfe, 0x00,  //...@@@@@@@@@@@@..
    0x0f, 0xfc, 0x00,  //....@@@@@@@@@%...
    0x03, 0xf0, 0x00,  //.....+%@@@@%+....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0037 (7) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@%
    0x00, 0x0e,  //............@@@.
    0x00, 0x1e,  //...........%@@%.
    0x00, 0x1c,  //...........@@@+.
    0x00, 0x1c,  //..........+@@@..
    0x00, 0x38,  //..........@@@+..
    0x00, 0x38,  //..........@@@...
    0x00, 0x78,  //.........%@@%...
    0x00, 0x70,  //.........@@@....
    0x00, 0x70,  //........+@@@....
    0x00, 0xe0,  //........@@@+....
    0x00, 0xe0,  //........@@@.....
    0x01, 0xe0,  //.......%@@%.....
    0x01, 0xc0,  //.......@@@......
    0x01, 0xc0,  //......+@@%......
    0x03, 0x80,  //......@@@+......
    0x03, 0x80,  //.....+@@@.......
    0x07, 0x80,  //.....%@@%.......
    0x07, 0x00,  //.....@@@........
    0x0f, 0x00,  //....%@@%........
    0x0e, 0x00,  //....@@@+........
    0x0e, 0x00,  //...+@@@.........
    0x1c, 0x00,  //...@@@+.........
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0038 (8) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x3f, 0xfe, 0x00,  //..@@@@@@@@@@@@@..
    0x3c, 0x1e, 0x00,  //.+@@@@+...+@@@@+.
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x70, 0x07, 0x00,  //.@@@.........@@@.
    0x70, 0x07, 0x00,  //.@@@.........@@@.
    0x70, 0x07, 0x00,  //.@@@.........@@@.
    0x38, 0x0e, 0x00,  //.+@@%.......%@@+.
    0x3c, 0x1e, 0x00,  //..@@@@+...+@@@@..
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x0f, 0xf8, 0x00,  //....%@@@@@@@%....
    0x1f, 0xfc, 0x00,  //..+@@@@@@@@@@@+..
    0x7c, 0x1f, 0x00,  //.%@@@%.....%@@@%.
    0x70, 0x07, 0x00,  //.@@@.........@@@.
    0xe0, 0x03, 0x80,  //%@@+.........+@@%
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@+.........+@@@
    0xf0, 0x07, 0x80,  //+@@@.........@@@+
    0x7c, 0x1f, 0x00,  //.@@@@%.....%@@@@.
    0x3f, 0xfe, 0x00,  //.+@@@@@@@@@@@@@+.
    0x1f, 0xfc, 0x00,  //..+@@@@@@@@@@@+..
    0x07, 0xf0, 0x00,  //....+%@@@@@%+....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0039 (9) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x07, 0xe0, 0x00,  //....+%@@@@%+.....
    0x1f, 0xf8, 0x00,  //...%@@@@@@@@@....
    0x3f, 0xfc, 0x00,  //..@@@@@@@@@@@@...
    0x7c, 0x3e, 0x00,  //.@@@@%....%@@@@..
    0x70, 0x0e, 0x00,  //+@@@+......+@@@+.
    0xf0, 0x0f, 0x00,  //%@@%........%@@@.
    0xe0, 0x07, 0x00,  //@@@..........@@@.
    0xe0, 0x07, 0x00,  //@@@..........@@@+
    0xe0, 0x07, 0x80,  //@@@..........@@@%
    0xe0, 0x07, 0x80,  //@@@..........@@@@
    0xf0, 0x0f, 0x80,  //%@@%........%@@@@
    0x70, 0x0f, 0x80,  //+@@@........@@@@@
    0x7c, 0x3f, 0x80,  //.@@@@%....%@@@@@@
    0x3f, 0xfb, 0x80,  //..@@@@@@@@@@@+@@@
    0x1f, 0xf3, 0x80,  //...@@@@@@@@@+.@@@
    0x07, 0xe3, 0x80,  //....+%@@@@%..+@@@
    0x00, 0x07, 0x80,  //.............%@@%
    0x00, 0x07, 0x00,  //.............@@@+
    0x00, 0x07, 0x00,  //............+@@@.
    0x00, 0x0f, 0x00,  //............@@@%.
    0x00, 0x1e, 0x00,  //...........%@@@..
    0x30, 0x3c, 0x00,  //..@%+....+@@@@+..
    0x3f, 0xf8, 0x00,  //..@@@@@@@@@@@+...
    0x3f, 0xf0, 0x00,  //..@@@@@@@@@@+....
    0x0f, 0xc0, 0x00,  //...+%@@@@%+......
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+003a (:) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+003b (;) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x70,  //.@@@
    0x70,  //.@@@
    0x70,  //.@@@
    0x70,  //.@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x70,  //.@@@
    0x70,  //.@@@
    0x70,  //.@@@
    0x70,  //.@@%
    0x60,  //+@@+
    0xe0,  //%@@.
    0xe0,  //%@%.
    0xc0,  //@@..
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+003c (<) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x08,  //...................+@
    0x00, 0x00, 0x78,  //................+%@@@
    0x00, 0x03, 0xf8,  //.............+%@@@@@@
    0x00, 0x1f, 0xf0,  //...........%@@@@@@@%+
    0x00, 0x7f, 0x80,  //........+@@@@@@@@+...
    0x03, 0xfe, 0x00,  //.....+%@@@@@@@%......
    0x1f, 0xf0, 0x00,  //..+%@@@@@@@%+........
    0xff, 0x80, 0x00,  //%@@@@@@@%+...........
    0xfc, 0x00, 0x00,  //@@@@@@+..............
    0xfc, 0x00, 0x00,  //@@@@@@+..............
    0xff, 0x80, 0x00,  //%@@@@@@@%+...........
    0x1f, 0xf0, 0x00,  //..+%@@@@@@@%+........
    0x03, 0xfe, 0x00,  //.....+%@@@@@@@%......
    0x00, 0x7f, 0x80,  //........+@@@@@@@@+...
    0x00, 0x1f, 0xf0,  //...........%@@@@@@@%+
    0x00, 0x03, 0xf8,  //.............+%@@@@@@
    0x00, 0x00, 0x78,  //................+%@@@
    0x00, 0x00, 0x08,  //...................+@
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+003d (=) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+003e (>) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x80, 0x00, 0x00,  //@+...................
    0xf0, 0x00, 0x00,  //@@@%+................
    0xfe, 0x00, 0x00,  //@@@@@@%+.............
    0x7f, 0xc0, 0x00,  //+%@@@@@@@%...........
    0x0f, 0xf0, 0x00,  //...+@@@@@@@@+........
    0x03, 0xfe, 0x00,  //......%@@@@@@@%+.....
    0x00, 0x7f, 0xc0,  //........+%@@@@@@@%+..
    0x00, 0x0f, 0xf8,  //...........+%@@@@@@@%
    0x00, 0x01, 0xf8,  //..............+@@@@@@
    0x00, 0x01, 0xf8,  //..............+@@@@@@
    0x00, 0x0f, 0xf8,  //...........+%@@@@@@@%
    0x00, 0x7f, 0xc0,  //........+%@@@@@@@%+..
    0x03, 0xfe, 0x00,  //......%@@@@@@@%+.....
    0x0f, 0xf0, 0x00,  //...+@@@@@@@@+........
    0x7f, 0xc0, 0x00,  //+%@@@@@@@%...........
    0xfe, 0x00, 0x00,  //@@@@@@%+.............
    0xf0, 0x00, 0x00,  //@@@%+................
    0x80, 0x00, 0x00,  //@+...................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+003f (?) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x1f, 0x80,  //...%@@@@%+...
    0x7f, 0xe0,  //+@@@@@@@@@@..
    0xff, 0xf0,  //@@@@@@@@@@@@.
    0xe0, 0xf0,  //@@@+....%@@@+
    0x80, 0x78,  //%........%@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //.........+@@@
    0x00, 0x70,  //.........@@@+
    0x00, 0xf0,  //.......+@@@@.
    0x01, 0xe0,  //......+@@@@..
    0x03, 0xc0,  //......@@@@...
    0x07, 0x80,  //.....@@@@....
    0x0f, 0x00,  //....%@@@.....
    0x0e, 0x00,  //....@@@+.....
    0x0e, 0x00,  //....@@@......
    0x0e, 0x00,  //....@@@......
    0x0e, 0x00,  //....@@@......
    0x0e, 0x00,  //....@@@......
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0e, 0x00,  //....@@@......
    0x0e, 0x00,  //....@@@......
    0x0e, 0x00,  //....@@@......
    0x0e, 0x00,  //....@@@......
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0040 (@) , Width: 30 */
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x0f, 0xf0, 0x00,  //...........+%@@@@@%%..........
    0x00, 0x7f, 0xfc, 0x00,  //........+@@@@@@@@@@@@@+.......
    0x01, 0xff, 0xff, 0x00,  //......+@@@@@@@@@@@@@@@@@+.....
    0x03, 0xf0, 0x1f, 0xc0,  //.....+@@@@@%+.....+%@@@@@+....
    0x0f, 0x80, 0x03, 0xe0,  //....%@@@@+...........+@@@@%...
    0x1f, 0x00, 0x01, 0xe0,  //...+@@@%...............%@@@+..
    0x1e, 0x00, 0x00, 0xf0,  //..+@@@%.................%@@@..
    0x3c, 0x00, 0x00, 0x78,  //..@@@%...................%@@%.
    0x38, 0x0f, 0x1c, 0x38,  //.+@@@......+@@@@+..@@@....@@@.
    0x70, 0x3f, 0xdc, 0x38,  //.@@@+.....@@@@@@@%.@@@....%@@+
    0x70, 0x7f, 0xfc, 0x1c,  //+@@@.....%@@@@@@@@%@@@....+@@%
    0xf0, 0x78, 0x7c, 0x1c,  //%@@%....+@@@%....%@@@@.....@@@
    0xe0, 0xf0, 0x3c, 0x1c,  //@@@+....%@@%......%@@@.....@@@
    0xe0, 0xe0, 0x1c, 0x1c,  //@@@.....@@@........@@@.....@@@
    0xe0, 0xe0, 0x1c, 0x1c,  //@@@.....@@@........@@@.....@@@
    0xe0, 0xe0, 0x1c, 0x1c,  //@@@.....@@@........@@@....+@@%
    0xe0, 0xe0, 0x1c, 0x38,  //@@@.....@@@........@@@....@@@.
    0xe0, 0xf0, 0x3c, 0x78,  //@@@+....%@@%......%@@@...@@@%.
    0xf0, 0x78, 0x7c, 0xf0,  //%@@%....+@@@%....%@@@@.+@@@@..
    0x70, 0x7f, 0xff, 0xe0,  //+@@@.....%@@@@@@@@%@@@@@@@@...
    0x70, 0x3f, 0xdf, 0x80,  //.@@@+.....@@@@@@@%.@@@@@@+....
    0x78, 0x0f, 0x1e, 0x00,  //.%@@@......+@@@@+..@@@%+......
    0x3c, 0x00, 0x00, 0x00,  //..@@@%........................
    0x1e, 0x00, 0x00, 0x00,  //..+@@@%.......................
    0x1f, 0x00, 0x02, 0x00,  //...%@@@%..............%+......
    0x0f, 0x80, 0x07, 0x00,  //....@@@@@+..........+@@@......
    0x07, 0xf0, 0x1f, 0x00,  //.....%@@@@@%+.....+@@@@@......
    0x01, 0xff, 0xfe, 0x00,  //......+@@@@@@@@@@@@@@@%.......
    0x00, 0xff, 0xf8, 0x00,  //........%@@@@@@@@@@@%.........
    0x00, 0x1f, 0xc0, 0x00,  //..........+%@@@@@%+...........
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00,  //..............................


    /*Unicode: U+0041 (A) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x7c, 0x00,  //.........%@@@%.........
    0x00, 0x7c, 0x00,  //.........@@@@@.........
    0x00, 0x7c, 0x00,  //........+@@@@@+........
    0x00, 0xfe, 0x00,  //........@@@@@@@........
    0x00, 0xee, 0x00,  //........@@@.@@@........
    0x01, 0xef, 0x00,  //.......%@@%.%@@%.......
    0x01, 0xc7, 0x00,  //.......@@@+.+@@@.......
    0x01, 0xc7, 0x00,  //......+@@@...@@@+......
    0x03, 0xc7, 0x80,  //......%@@%...%@@%......
    0x03, 0x83, 0x80,  //......@@@.....@@@......
    0x03, 0x83, 0x80,  //.....+@@@.....%@@+.....
    0x07, 0x01, 0xc0,  //.....@@@+.....+@@@.....
    0x07, 0x01, 0xc0,  //.....@@@.......@@@.....
    0x0f, 0x01, 0xe0,  //....%@@%.......%@@%....
    0x0e, 0x00, 0xe0,  //....@@@.........@@@....
    0x0e, 0x00, 0xe0,  //...+@@@.........@@@+...
    0x1f, 0xff, 0xf0,  //...%@@@@@@@@@@@@@@@%...
    0x1f, 0xff, 0xf0,  //...@@@@@@@@@@@@@@@@@...
    0x3f, 0xff, 0xf8,  //..%@@@@@@@@@@@@@@@@@%..
    0x38, 0x00, 0x38,  //..@@@+...........+@@@..
    0x38, 0x00, 0x38,  //.+@@@.............@@@+.
    0x78, 0x00, 0x3c,  //.%@@%.............%@@%.
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x70, 0x00, 0x1c,  //+@@@...............@@@+
    0xe0, 0x00, 0x0e,  //@@@+...............+@@@
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0042 (B) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0xff, 0xf8, 0x00,  //@@@@@@@@@@@%%.....
    0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@%...
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@..
    0xe0, 0x0f, 0x00,  //@@@........+@@@@+.
    0xe0, 0x07, 0x80,  //@@@..........%@@@.
    0xe0, 0x03, 0x80,  //@@@...........@@@.
    0xe0, 0x03, 0x80,  //@@@...........@@@.
    0xe0, 0x03, 0x80,  //@@@...........@@@.
    0xe0, 0x07, 0x80,  //@@@..........%@@%.
    0xe0, 0x0f, 0x00,  //@@@........+@@@@..
    0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@%....
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@%..
    0xe0, 0x0f, 0x80,  //@@@.........%@@@%.
    0xe0, 0x03, 0x80,  //@@@...........@@@.
    0xe0, 0x01, 0xc0,  //@@@...........+@@%
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@...........+@@@
    0xe0, 0x03, 0xc0,  //@@@...........@@@%
    0xe0, 0x0f, 0x80,  //@@@.........%@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@+..
    0xff, 0xf8, 0x00,  //@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0043 (C) , Width: 20 */
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0xff, 0x00,  //.......+%@@@@@@%+...
    0x03, 0xff, 0xe0,  //.....+@@@@@@@@@@@@%.
    0x0f, 0xff, 0xf0,  //....%@@@@@@@@@@@@@@@
    0x1f, 0x81, 0xf0,  //...@@@@@%+....+%@@@@
    0x3e, 0x00, 0x30,  //..%@@@+..........+@@
    0x38, 0x00, 0x10,  //.+@@@+.............%
    0x78, 0x00, 0x00,  //.@@@%...............
    0x70, 0x00, 0x00,  //.@@@................
    0x70, 0x00, 0x00,  //+@@%................
    0xe0, 0x00, 0x00,  //%@@+................
    0xe0, 0x00, 0x00,  //@@@.................
    0xe0, 0x00, 0x00,  //@@@.................
    0xe0, 0x00, 0x00,  //@@@.................
    0xe0, 0x00, 0x00,  //@@@.................
    0xe0, 0x00, 0x00,  //@@@.................
    0xe0, 0x00, 0x00,  //%@@+................
    0x70, 0x00, 0x00,  //+@@%................
    0x70, 0x00, 0x00,  //.@@@................
    0x78, 0x00, 0x00,  //.@@@%...............
    0x38, 0x00, 0x10,  //.+@@@+.............%
    0x3c, 0x00, 0x30,  //..%@@@+..........+@@
    0x1f, 0x81, 0xf0,  //...@@@@@%+....+%@@@@
    0x0f, 0xff, 0xf0,  //....%@@@@@@@@@@@@@@@
    0x03, 0xff, 0xe0,  //.....+@@@@@@@@@@@@%.
    0x00, 0xff, 0x00,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................


    /*Unicode: U+0044 (D) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0xff, 0xf0, 0x00,  //@@@@@@@@@@%%+........
    0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@%+.....
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%....
    0xe0, 0x0f, 0xc0,  //@@@........+%@@@@@...
    0xe0, 0x03, 0xe0,  //@@@...........%@@@@..
    0xe0, 0x00, 0xe0,  //@@@............+@@@+.
    0xe0, 0x00, 0xf0,  //@@@.............%@@@.
    0xe0, 0x00, 0x70,  //@@@..............@@@+
    0xe0, 0x00, 0x78,  //@@@..............%@@%
    0xe0, 0x00, 0x38,  //@@@..............+@@@
    0xe0, 0x00, 0x38,  //@@@...............@@@
    0xe0, 0x00, 0x38,  //@@@...............@@@
    0xe0, 0x00, 0x38,  //@@@...............@@@
    0xe0, 0x00, 0x38,  //@@@...............@@@
    0xe0, 0x00, 0x38,  //@@@...............@@@
    0xe0, 0x00, 0x38,  //@@@..............+@@%
    0xe0, 0x00, 0x78,  //@@@..............%@@%
    0xe0, 0x00, 0x70,  //@@@..............@@@+
    0xe0, 0x00, 0xf0,  //@@@.............%@@@.
    0xe0, 0x00, 0xe0,  //@@@............+@@@+.
    0xe0, 0x03, 0xe0,  //@@@...........%@@@@..
    0xe0, 0x0f, 0xc0,  //@@@........+%@@@@@...
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%....
    0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@%+.....
    0xff, 0xf0, 0x00,  //@@@@@@@@@@%%+........
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0045 (E) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xff, 0xfe,  //@@@@@@@@@@@@@@@.
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0046 (F) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xff, 0xfc,  //@@@@@@@@@@@@@@
    0xff, 0xfc,  //@@@@@@@@@@@@@@
    0xff, 0xfc,  //@@@@@@@@@@@@@@
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xff, 0xf8,  //@@@@@@@@@@@@@.
    0xff, 0xf8,  //@@@@@@@@@@@@@.
    0xff, 0xf8,  //@@@@@@@@@@@@@.
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0047 (G) , Width: 22 */
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0xff, 0x80,  //........+%@@@@@%%+....
    0x03, 0xff, 0xf0,  //.....+@@@@@@@@@@@@@%..
    0x0f, 0xff, 0xf8,  //....%@@@@@@@@@@@@@@@@.
    0x1f, 0x80, 0xf8,  //...@@@@@%+.....+%@@@@.
    0x3c, 0x00, 0x18,  //..%@@@+...........+@@.
    0x38, 0x00, 0x08,  //.+@@@+..............%.
    0x78, 0x00, 0x00,  //.@@@+.................
    0x70, 0x00, 0x00,  //.@@@..................
    0x70, 0x00, 0x00,  //+@@%..................
    0xe0, 0x00, 0x00,  //%@@+..................
    0xe0, 0x00, 0x00,  //@@@...................
    0xe0, 0x03, 0xfc,  //@@@...........@@@@@@@@
    0xe0, 0x03, 0xfc,  //@@@...........@@@@@@@@
    0xe0, 0x03, 0xfc,  //@@@...........@@@@@@@@
    0xe0, 0x00, 0x1c,  //@@@................@@@
    0xe0, 0x00, 0x1c,  //%@@+...............@@@
    0x70, 0x00, 0x1c,  //+@@%...............@@@
    0x70, 0x00, 0x1c,  //.@@@...............@@@
    0x78, 0x00, 0x1c,  //.@@@%..............@@@
    0x38, 0x00, 0x1c,  //.+@@@+.............@@@
    0x3e, 0x00, 0x1c,  //..%@@@%............@@@
    0x1f, 0x80, 0x7c,  //...@@@@@%+......+%@@@@
    0x0f, 0xff, 0xf8,  //....%@@@@@@@@@@@@@@@@+
    0x03, 0xff, 0xe0,  //.....+@@@@@@@@@@@@@+..
    0x00, 0x7f, 0x80,  //........+%@@@@@%+.....
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................


    /*Unicode: U+0048 (H) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0049 (I) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+004a (J) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //..+@@%
    0x38,  //..@@@+
    0x78,  //.%@@@.
    0xf8,  //@@@@%.
    0xf0,  //@@@%..
    0xc0,  //@%+...
    0x00,  //......
    0x00,  //......


    /*Unicode: U+004b (K) , Width: 20 */
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0xe0, 0x03, 0xc0,  //@@@...........@@@@+.
    0xe0, 0x07, 0x80,  //@@@..........@@@@+..
    0xe0, 0x0f, 0x00,  //@@@.........@@@@+...
    0xe0, 0x1e, 0x00,  //@@@.......+@@@@.....
    0xe0, 0x3c, 0x00,  //@@@......+@@@@......
    0xe0, 0x78, 0x00,  //@@@.....+@@@@.......
    0xe1, 0xf0, 0x00,  //@@@....%@@@@........
    0xe3, 0xe0, 0x00,  //@@@...%@@@%.........
    0xe7, 0xc0, 0x00,  //@@@..%@@@%..........
    0xef, 0x80, 0x00,  //@@@.@@@@%...........
    0xff, 0x00, 0x00,  //@@@@@@@%............
    0xfe, 0x00, 0x00,  //@@@@@@%.............
    0xfe, 0x00, 0x00,  //@@@@@@@.............
    0xef, 0x00, 0x00,  //@@@.@@@@............
    0xe7, 0x80, 0x00,  //@@@..@@@@...........
    0xe3, 0xc0, 0x00,  //@@@...@@@@..........
    0xe1, 0xe0, 0x00,  //@@@....@@@@+........
    0xe0, 0xf0, 0x00,  //@@@.....@@@@+.......
    0xe0, 0x78, 0x00,  //@@@......@@@@+......
    0xe0, 0x3c, 0x00,  //@@@.......@@@@+.....
    0xe0, 0x1e, 0x00,  //@@@........@@@@+....
    0xe0, 0x0f, 0x00,  //@@@.........@@@@+...
    0xe0, 0x07, 0x80,  //@@@..........@@@@+..
    0xe0, 0x03, 0xc0,  //@@@...........@@@@+.
    0xe0, 0x01, 0xe0,  //@@@............@@@@+
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................


    /*Unicode: U+004c (L) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+004d (M) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0xf8, 0x00, 0x3e,  //@@@@@.............@@@@@
    0xfc, 0x00, 0x7e,  //@@@@@%...........%@@@@@
    0xfc, 0x00, 0x7e,  //@@@@@@...........@@@@@@
    0xfc, 0x00, 0x7e,  //@@@@@@+.........+@@@@@@
    0xee, 0x00, 0xee,  //@@@+@@@.........@@@+@@@
    0xee, 0x00, 0xee,  //@@@.@@@.........@@@.@@@
    0xef, 0x01, 0xee,  //@@@.%@@%.......%@@%.@@@
    0xe7, 0x01, 0xce,  //@@@..@@@.......@@@..@@@
    0xe7, 0x01, 0xce,  //@@@..@@@+.....+@@@..@@@
    0xe3, 0x83, 0x8e,  //@@@..+@@@.....@@@+..@@@
    0xe3, 0x83, 0x8e,  //@@@...@@@.....@@@...@@@
    0xe3, 0xc7, 0x8e,  //@@@...%@@%...%@@%...@@@
    0xe1, 0xc7, 0x0e,  //@@@....@@@...@@@....@@@
    0xe1, 0xc7, 0x0e,  //@@@....@@@+.+@@@....@@@
    0xe0, 0xee, 0x0e,  //@@@....+@@@.@@@+....@@@
    0xe0, 0xee, 0x0e,  //@@@.....@@@+@@@.....@@@
    0xe0, 0xfe, 0x0e,  //@@@.....%@@@@@%.....@@@
    0xe0, 0x7c, 0x0e,  //@@@......@@@@@......@@@
    0xe0, 0x7c, 0x0e,  //@@@......@@@@@......@@@
    0xe0, 0x38, 0x0e,  //@@@......+@@@+......@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+004e (N) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xf8, 0x00, 0xe0,  //@@@@%...........@@@
    0xf8, 0x00, 0xe0,  //@@@@@...........@@@
    0xfc, 0x00, 0xe0,  //@@@@@%..........@@@
    0xfc, 0x00, 0xe0,  //@@@@@@..........@@@
    0xfe, 0x00, 0xe0,  //@@@%@@@.........@@@
    0xee, 0x00, 0xe0,  //@@@.@@@+........@@@
    0xef, 0x00, 0xe0,  //@@@.+@@@........@@@
    0xe7, 0x00, 0xe0,  //@@@..@@@+.......@@@
    0xe3, 0x80, 0xe0,  //@@@..+@@@.......@@@
    0xe3, 0xc0, 0xe0,  //@@@...@@@%......@@@
    0xe1, 0xc0, 0xe0,  //@@@...+@@@......@@@
    0xe1, 0xe0, 0xe0,  //@@@....%@@%.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xf0, 0xe0,  //@@@.....%@@%....@@@
    0xe0, 0x70, 0xe0,  //@@@......@@@+...@@@
    0xe0, 0x78, 0xe0,  //@@@......%@@@...@@@
    0xe0, 0x38, 0xe0,  //@@@.......@@@+..@@@
    0xe0, 0x1c, 0xe0,  //@@@.......+@@@..@@@
    0xe0, 0x1c, 0xe0,  //@@@........@@@+.@@@
    0xe0, 0x0e, 0xe0,  //@@@........+@@@.@@@
    0xe0, 0x0f, 0xe0,  //@@@.........@@@%@@@
    0xe0, 0x07, 0xe0,  //@@@.........+@@@@@@
    0xe0, 0x07, 0xe0,  //@@@..........%@@@@@
    0xe0, 0x03, 0xe0,  //@@@...........@@@@@
    0xe0, 0x03, 0xe0,  //@@@...........%@@@@
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+004f (O) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0xfe, 0x00,  //.......+%@@@@@%+.......
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@+.....
    0x0f, 0xff, 0xe0,  //....%@@@@@@@@@@@@@@....
    0x1f, 0x01, 0xf0,  //...@@@@@+.....+@@@@@...
    0x3e, 0x00, 0xf8,  //..%@@@%.........+@@@%..
    0x38, 0x00, 0x38,  //.+@@@+...........+@@@+.
    0x78, 0x00, 0x3c,  //.@@@%.............%@@@.
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x70, 0x00, 0x1c,  //+@@%...............%@@+
    0xe0, 0x00, 0x0e,  //%@@+...............+@@%
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //%@@+...............+@@%
    0x70, 0x00, 0x1c,  //+@@%...............%@@+
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x78, 0x00, 0x3c,  //.@@@%.............%@@@.
    0x38, 0x00, 0x38,  //.+@@@+...........+@@@+.
    0x3e, 0x00, 0x78,  //..%@@@+.........+@@@%..
    0x1f, 0x01, 0xf0,  //...@@@@@+.....+@@@@@...
    0x0f, 0xff, 0xe0,  //....@@@@@@@@@@@@@@@....
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@+.....
    0x00, 0xfe, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0050 (P) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xff, 0xe0,  //@@@@@@@@@@%+....
    0xff, 0xf8,  //@@@@@@@@@@@@@+..
    0xff, 0xfc,  //@@@@@@@@@@@@@@+.
    0xe0, 0x3e,  //@@@.......%@@@@.
    0xe0, 0x0f,  //@@@.........@@@%
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x0f,  //@@@.........@@@%
    0xe0, 0x3e,  //@@@.......%@@@@.
    0xff, 0xfc,  //@@@@@@@@@@@@@@+.
    0xff, 0xf8,  //@@@@@@@@@@@@@+..
    0xff, 0xe0,  //@@@@@@@@@@%+....
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0051 (Q) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0xfe, 0x00,  //.......+%@@@@@%+.......
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@+.....
    0x0f, 0xff, 0xe0,  //....%@@@@@@@@@@@@@@....
    0x1f, 0x01, 0xf0,  //...@@@@@+.....+@@@@@...
    0x3e, 0x00, 0xf8,  //..%@@@%.........+@@@%..
    0x38, 0x00, 0x38,  //.+@@@+...........+@@@+.
    0x78, 0x00, 0x3c,  //.@@@%.............%@@@.
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x70, 0x00, 0x1c,  //+@@%...............%@@+
    0xe0, 0x00, 0x0e,  //%@@+...............+@@%
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //@@@.................@@@
    0xe0, 0x00, 0x0e,  //%@@+...............+@@%
    0x70, 0x00, 0x1e,  //+@@%...............%@@%
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x78, 0x00, 0x3c,  //.@@@%.............%@@@.
    0x38, 0x00, 0x38,  //.+@@@+...........+@@@+.
    0x3e, 0x00, 0x78,  //..%@@@+.........+@@@%..
    0x1f, 0x01, 0xf0,  //...@@@@@+.....+@@@@@...
    0x0f, 0xff, 0xe0,  //....%@@@@@@@@@@@@@@....
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@@+.....
    0x00, 0xff, 0x80,  //.......+%@@@@@@@@......
    0x00, 0x03, 0xc0,  //..............@@@@.....
    0x00, 0x01, 0xe0,  //...............@@@%....
    0x00, 0x00, 0xf0,  //...............+@@@%...
    0x00, 0x00, 0x78,  //................+@@@%..
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0052 (R) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xff, 0xe0, 0x00,  //@@@@@@@@@@%+.......
    0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@%.....
    0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@%....
    0xe0, 0x1e, 0x00,  //@@@.......+@@@@+...
    0xe0, 0x0f, 0x00,  //@@@.........@@@%...
    0xe0, 0x07, 0x00,  //@@@.........+@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x00,  //@@@.........+@@@...
    0xe0, 0x0f, 0x00,  //@@@.........@@@%...
    0xe0, 0x1e, 0x00,  //@@@.......+@@@@....
    0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@+....
    0xff, 0xf8, 0x00,  //@@@@@@@@@@@@%......
    0xff, 0xf8, 0x00,  //@@@@@@@@@@@@@+.....
    0xe0, 0x3c, 0x00,  //@@@......+@@@@.....
    0xe0, 0x1e, 0x00,  //@@@........@@@%....
    0xe0, 0x0e, 0x00,  //@@@.........@@@+...
    0xe0, 0x0f, 0x00,  //@@@.........%@@%...
    0xe0, 0x07, 0x00,  //@@@..........@@@...
    0xe0, 0x07, 0x80,  //@@@..........%@@%..
    0xe0, 0x03, 0x80,  //@@@...........@@@..
    0xe0, 0x03, 0x80,  //@@@...........@@@+.
    0xe0, 0x01, 0xc0,  //@@@...........+@@@.
    0xe0, 0x01, 0xc0,  //@@@............@@@+
    0xe0, 0x00, 0xe0,  //@@@............+@@@
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0053 (S) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x07, 0xfc, 0x00,  //....+%@@@@@@%%+..
    0x1f, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x3f, 0xff, 0x00,  //.+@@@@@@@@@@@@@@.
    0x7c, 0x03, 0x00,  //.@@@@%......++%@.
    0xf0, 0x00, 0x00,  //%@@@.............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xf0, 0x00, 0x00,  //@@@%.............
    0x78, 0x00, 0x00,  //+@@@%............
    0x7f, 0x80, 0x00,  //.@@@@@@%%+.......
    0x3f, 0xf8, 0x00,  //..%@@@@@@@@@%....
    0x0f, 0xfc, 0x00,  //....%@@@@@@@@@+..
    0x00, 0xff, 0x00,  //.......+%%@@@@@%.
    0x00, 0x0f, 0x00,  //...........+@@@@.
    0x00, 0x07, 0x80,  //.............@@@%
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //.............+@@@
    0x80, 0x07, 0x80,  //@+...........@@@%
    0xf0, 0x1f, 0x00,  //@@@%+.....+%@@@@.
    0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@+.
    0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@...
    0x3f, 0xf0, 0x00,  //.++%@@@@@@@%.....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0054 (T) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0055 (U) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@.............@@@
    0xe0, 0x00, 0xe0,  //@@@+...........+@@@
    0xf0, 0x01, 0xe0,  //%@@%...........%@@%
    0x70, 0x01, 0xc0,  //+@@@...........@@@+
    0x78, 0x03, 0xc0,  //.@@@%.........%@@@.
    0x3c, 0x07, 0x80,  //.+@@@@+.....+@@@@+.
    0x3f, 0xff, 0x80,  //..%@@@@@@@@@@@@@%..
    0x0f, 0xfe, 0x00,  //...+@@@@@@@@@@@+...
    0x03, 0xf8, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0056 (V) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0xe0, 0x00, 0x0e,  //@@@+...............+@@@
    0x70, 0x00, 0x1c,  //+@@@...............@@@+
    0x70, 0x00, 0x1c,  //.@@@...............@@@.
    0x78, 0x00, 0x3c,  //.%@@%.............%@@%.
    0x38, 0x00, 0x38,  //.+@@@.............@@@+.
    0x38, 0x00, 0x38,  //..@@@+...........+@@@..
    0x3c, 0x00, 0x78,  //..%@@%...........%@@%..
    0x1c, 0x00, 0x70,  //...@@@...........@@@...
    0x1c, 0x00, 0x70,  //...%@@+.........+@@%...
    0x0e, 0x00, 0xe0,  //...+@@@.........@@@+...
    0x0e, 0x00, 0xe0,  //....@@@.........@@@....
    0x0f, 0x01, 0xe0,  //....%@@%.......%@@%....
    0x07, 0x01, 0xc0,  //.....@@@.......@@@.....
    0x07, 0x01, 0xc0,  //.....@@@+.....+@@@.....
    0x03, 0x83, 0x80,  //.....+@@@.....%@@+.....
    0x03, 0x83, 0x80,  //......@@@.....@@@......
    0x03, 0xc7, 0x80,  //......%@@%...%@@%......
    0x01, 0xc7, 0x00,  //......+@@@...@@@+......
    0x01, 0xc7, 0x00,  //.......@@@+.+@@@.......
    0x01, 0xef, 0x00,  //.......%@@%.%@@%.......
    0x00, 0xee, 0x00,  //........@@@.@@@........
    0x00, 0xfe, 0x00,  //........@@@@@@@........
    0x00, 0x7c, 0x00,  //........+@@@@@+........
    0x00, 0x7c, 0x00,  //.........@@@@@.........
    0x00, 0x7c, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0057 (W) , Width: 31 */
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0xe0, 0x07, 0xc0, 0x0e,  //@@@..........@@@@@..........@@@
    0xe0, 0x07, 0xc0, 0x0e,  //%@@+.........@@@@@.........+@@%
    0x70, 0x07, 0xc0, 0x1c,  //+@@%........+@@@@@+........%@@+
    0x70, 0x0f, 0xe0, 0x1c,  //.@@@........%@@@@@%........@@@.
    0x70, 0x0e, 0xe0, 0x1c,  //.@@@........@@@+@@@........@@@.
    0x70, 0x0e, 0xe0, 0x1c,  //.%@@+.......@@@.@@@.......+@@%.
    0x38, 0x0e, 0xe0, 0x38,  //.+@@%......+@@%.%@@+......%@@+.
    0x38, 0x1e, 0x70, 0x38,  //..@@@......%@@+.+@@%......@@@..
    0x38, 0x1c, 0x70, 0x38,  //..@@@......@@@+..@@@......@@@..
    0x38, 0x1c, 0x70, 0x38,  //..%@@+.....@@@...@@@.....+@@%..
    0x1c, 0x1c, 0x70, 0x70,  //..+@@%....+@@@...@@@+....%@@+..
    0x1c, 0x3c, 0x78, 0x70,  //...@@@....%@@%...%@@%....@@@...
    0x1c, 0x38, 0x38, 0x70,  //...@@@....@@@+...+@@@....@@@...
    0x1c, 0x38, 0x38, 0x70,  //...%@@+...@@@.....@@@...+@@%...
    0x0e, 0x38, 0x38, 0xe0,  //...+@@%...@@@.....@@@+..%@@+...
    0x0e, 0x38, 0x3c, 0xe0,  //....@@@..+@@%.....%@@+..@@@....
    0x0e, 0x70, 0x1c, 0xe0,  //....@@@..%@@+.....+@@%..@@@....
    0x0e, 0x70, 0x1c, 0xe0,  //....%@@+.@@@.......@@@.+@@%....
    0x07, 0x70, 0x1d, 0xc0,  //....+@@%.@@@.......@@@.%@@+....
    0x07, 0x70, 0x1d, 0xc0,  //.....@@@+@@%.......%@@+@@@.....
    0x07, 0xe0, 0x0f, 0xc0,  //.....@@@@@@+.......+@@@@@@.....
    0x07, 0xe0, 0x0f, 0xc0,  //.....%@@@@@.........@@@@@%.....
    0x03, 0xe0, 0x0f, 0x80,  //.....+@@@@@.........@@@@@+.....
    0x03, 0xe0, 0x0f, 0x80,  //......@@@@%.........%@@@@......
    0x03, 0xc0, 0x07, 0x80,  //......@@@@+.........+@@@@......
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+0058 (X) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x78, 0x00, 0xf0,  //.%@@@...........@@@%.
    0x3c, 0x01, 0xe0,  //..@@@%.........%@@@..
    0x1c, 0x01, 0xc0,  //..+@@@.........@@@+..
    0x1e, 0x03, 0xc0,  //...%@@@.......@@@%...
    0x0f, 0x07, 0x80,  //....@@@%.....%@@@....
    0x07, 0x07, 0x00,  //....+@@@.....@@@+....
    0x07, 0x8f, 0x00,  //.....%@@@...@@@%.....
    0x03, 0xde, 0x00,  //......@@@%.%@@@......
    0x01, 0xdc, 0x00,  //......+@@@+@@@+......
    0x01, 0xfc, 0x00,  //.......@@@@@@%.......
    0x00, 0xf8, 0x00,  //........@@@@@........
    0x00, 0xf0, 0x00,  //........%@@@+........
    0x00, 0xf8, 0x00,  //........@@@@@........
    0x00, 0xf8, 0x00,  //.......+@@@@@+.......
    0x01, 0xfc, 0x00,  //.......@@@@@@@.......
    0x03, 0xde, 0x00,  //......@@@@.@@@%......
    0x03, 0x8e, 0x00,  //.....+@@@...@@@+.....
    0x07, 0x0f, 0x00,  //.....@@@+...%@@@.....
    0x0f, 0x07, 0x80,  //....%@@@.....@@@%....
    0x0e, 0x03, 0x80,  //...+@@@.......@@@+...
    0x1e, 0x03, 0xc0,  //...@@@%.......%@@@...
    0x3c, 0x01, 0xe0,  //..%@@@.........@@@%..
    0x38, 0x00, 0xe0,  //.+@@@..........+@@@+.
    0x78, 0x00, 0xf0,  //.@@@%...........%@@@.
    0xf0, 0x00, 0x78,  //%@@@.............@@@%
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0059 (Y) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0xf0, 0x00, 0x78,  //%@@@.............@@@%
    0x78, 0x00, 0xf0,  //.@@@%...........%@@@.
    0x38, 0x00, 0xe0,  //.+@@@+.........+@@@+.
    0x3c, 0x01, 0xe0,  //..%@@@.........@@@%..
    0x1e, 0x03, 0xc0,  //...@@@%.......%@@@...
    0x0e, 0x03, 0x80,  //....@@@+.....+@@@....
    0x0f, 0x07, 0x80,  //....%@@@.....@@@%....
    0x07, 0x8f, 0x00,  //.....@@@@...@@@@.....
    0x03, 0x8e, 0x00,  //......@@@+.+@@@......
    0x01, 0xdc, 0x00,  //......+@@@+@@@+......
    0x01, 0xfc, 0x00,  //.......@@@@@@@.......
    0x00, 0xf8, 0x00,  //........@@@@@........
    0x00, 0x70, 0x00,  //........+@@@+........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x70, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+005a (Z) , Width: 20 */
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@.
    0x00, 0x03, 0xc0,  //..............%@@@+.
    0x00, 0x03, 0xc0,  //.............+@@@%..
    0x00, 0x07, 0x80,  //.............@@@%...
    0x00, 0x0f, 0x00,  //............@@@@....
    0x00, 0x1e, 0x00,  //...........%@@@.....
    0x00, 0x1c, 0x00,  //..........+@@@+.....
    0x00, 0x3c, 0x00,  //..........@@@%......
    0x00, 0x78, 0x00,  //.........@@@@.......
    0x00, 0xf0, 0x00,  //........%@@@........
    0x00, 0xe0, 0x00,  //.......+@@@+........
    0x01, 0xe0, 0x00,  //.......@@@%.........
    0x03, 0xc0, 0x00,  //......@@@@..........
    0x07, 0x80, 0x00,  //.....%@@@...........
    0x07, 0x00, 0x00,  //....+@@@+...........
    0x0f, 0x00, 0x00,  //....@@@%............
    0x1e, 0x00, 0x00,  //...@@@@.............
    0x3c, 0x00, 0x00,  //..%@@@..............
    0x78, 0x00, 0x00,  //.%@@@+..............
    0x70, 0x00, 0x00,  //+@@@+...............
    0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00,  //....................


    /*Unicode: U+005b ([) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0xfe,  //@@@@@@@
    0xfe,  //@@@@@@@
    0xfe,  //@@@@@@@
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xe0,  //@@@....
    0xfe,  //@@@@@@@
    0xfe,  //@@@@@@@
    0xfe,  //@@@@@@@
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+005c (\) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xe0, 0x00,  //@@@+.......
    0xf0, 0x00,  //%@@%.......
    0x70, 0x00,  //+@@@.......
    0x70, 0x00,  //.@@@.......
    0x70, 0x00,  //.%@@+......
    0x38, 0x00,  //.+@@%......
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0x3c, 0x00,  //..%@@%.....
    0x1c, 0x00,  //..+@@@.....
    0x1c, 0x00,  //...@@@.....
    0x1c, 0x00,  //...@@@+....
    0x0e, 0x00,  //...+@@%....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....%@@+...
    0x07, 0x00,  //....+@@@...
    0x07, 0x00,  //.....@@@...
    0x07, 0x00,  //.....@@@+..
    0x07, 0x80,  //.....+@@%..
    0x03, 0x80,  //......@@@..
    0x03, 0x80,  //......@@@..
    0x03, 0x80,  //......%@@+.
    0x01, 0xc0,  //......+@@%.
    0x01, 0xc0,  //.......@@@.
    0x01, 0xc0,  //.......@@@+
    0x01, 0xe0,  //.......%@@%
    0x00, 0xe0,  //........@@@
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+005d (]) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0xfe,  //@@@@@@@
    0xfe,  //@@@@@@@
    0xfe,  //@@@@@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0x0e,  //....@@@
    0xfe,  //@@@@@@@
    0xfe,  //@@@@@@@
    0xfe,  //@@@@@@@
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+005e (^) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0xf8, 0x00,  //........%@@@%........
    0x01, 0xfc, 0x00,  //.......%@@@@@%.......
    0x03, 0xfe, 0x00,  //......%@@@@@@@%......
    0x07, 0xdf, 0x00,  //.....%@@@+.%@@@%.....
    0x0f, 0x07, 0x80,  //....%@@@+...+@@@%....
    0x1e, 0x03, 0xc0,  //...%@@@+.....+@@@%...
    0x3c, 0x01, 0xe0,  //..%@@@.........@@@%..
    0x78, 0x00, 0xf0,  //.%@@@...........@@@%.
    0xf0, 0x00, 0x78,  //+@@@.............@@@+
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+005f (_) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0060 (`) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xf0,  //%@@%....
    0x70,  //.%@@+...
    0x38,  //..%@@+..
    0x1c,  //...@@@..
    0x0e,  //....@@@.
    0x07,  //.....@@%
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0061 (a) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x0f, 0xe0,  //....%%@@@@%+....
    0x3f, 0xf8,  //..%@@@@@@@@@@...
    0x7f, 0xfc,  //.@@@@@@@@@@@@@..
    0x70, 0x3e,  //.@@%+.....+@@@@.
    0x40, 0x0e,  //.%..........@@@+
    0x00, 0x07,  //............+@@%
    0x00, 0x07,  //.............@@@
    0x07, 0xff,  //....+%@@@@@@@@@@
    0x3f, 0xff,  //..%@@@@@@@@@@@@@
    0x7f, 0xff,  //.@@@@@@@@@@@@@@@
    0x78, 0x07,  //+@@@%+.......@@@
    0xf0, 0x07,  //@@@%.........@@@
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x0f,  //@@@.........@@@@
    0xe0, 0x1f,  //@@@+.......%@@@@
    0xf8, 0x3f,  //%@@@%....+@@@@@@
    0x7f, 0xff,  //.@@@@@@@@@@@%@@@
    0x3f, 0xf7,  //..@@@@@@@@@+.@@@
    0x0f, 0xc7,  //...+@@@@@%...@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0062 (b) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe3, 0xf0, 0x00,  //@@@...%@@@@%.....
    0xef, 0xfc, 0x00,  //@@@.%@@@@@@@@%...
    0xff, 0xfe, 0x00,  //@@@%@@@@@@@@@@%..
    0xfc, 0x1e, 0x00,  //@@@@@@+...+@@@@+.
    0xf8, 0x0f, 0x00,  //@@@@%.......%@@@.
    0xf0, 0x07, 0x00,  //@@@@.........@@@+
    0xe0, 0x03, 0x80,  //@@@+.........+@@%
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@+.........+@@%
    0xf0, 0x07, 0x00,  //@@@@.........@@@+
    0xf8, 0x0f, 0x00,  //@@@@%.......%@@@.
    0xfc, 0x1e, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0xfe, 0x00,  //@@@%@@@@@@@@@@%..
    0xef, 0xfc, 0x00,  //@@@.%@@@@@@@@%...
    0xe3, 0xf0, 0x00,  //@@@...%@@@@%.....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0063 (c) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x03, 0xf8,  //.....+%@@@@@%+.
    0x0f, 0xfe,  //....@@@@@@@@@@@
    0x1f, 0xfe,  //..+@@@@@@@@@@@@
    0x3e, 0x06,  //..@@@@%.....+%@
    0x78, 0x00,  //.@@@@..........
    0x70, 0x00,  //+@@@...........
    0xf0, 0x00,  //%@@%...........
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xf0, 0x00,  //%@@%...........
    0x70, 0x00,  //+@@@...........
    0x78, 0x00,  //.@@@@..........
    0x3e, 0x06,  //..@@@@%.....+%@
    0x1f, 0xfe,  //..+@@@@@@@@@@@@
    0x0f, 0xfe,  //....@@@@@@@@@@@
    0x03, 0xf8,  //.....+%@@@@@%+.
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+0064 (d) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x07, 0xe3, 0x80,  //.....%@@@@%...@@@
    0x1f, 0xfb, 0x80,  //...%@@@@@@@@%.@@@
    0x3f, 0xff, 0x80,  //..%@@@@@@@@@@%@@@
    0x3c, 0x1f, 0x80,  //.+@@@@+...+@@@@@@
    0x78, 0x0f, 0x80,  //.@@@%.......%@@@@
    0x70, 0x07, 0x80,  //+@@@.........@@@@
    0xe0, 0x03, 0x80,  //%@@+.........+@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //%@@+.........+@@@
    0x70, 0x07, 0x80,  //+@@@.........@@@@
    0x78, 0x0f, 0x80,  //.@@@%.......%@@@@
    0x3c, 0x1f, 0x80,  //.+@@@@+...+@@@@@@
    0x3f, 0xff, 0x80,  //..%@@@@@@@@@@%@@@
    0x1f, 0xfb, 0x80,  //...%@@@@@@@@%.@@@
    0x07, 0xe3, 0x80,  //.....%@@@@%...@@@
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0065 (e) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x03, 0xf0, 0x00,  //.....+%@@@@%+....
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@...
    0x1f, 0xfe, 0x00,  //..+@@@@@@@@@@@@..
    0x3c, 0x0f, 0x00,  //..@@@%+....+@@@@.
    0x70, 0x07, 0x00,  //.@@@+........@@@+
    0x70, 0x03, 0x80,  //+@@%.........+@@%
    0xe0, 0x03, 0x80,  //%@@...........@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xf0, 0x00, 0x00,  //%@@%.............
    0x70, 0x00, 0x00,  //+@@@.............
    0x78, 0x01, 0x00,  //.@@@@..........%.
    0x3e, 0x07, 0x00,  //.+@@@@%.....+@@@.
    0x1f, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x0f, 0xfe, 0x00,  //...+@@@@@@@@@@@+.
    0x03, 0xf8, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0066 (f) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x03, 0xf0,  //.....+%@@@@@
    0x0f, 0xf0,  //....%@@@@@@@
    0x0f, 0xf0,  //...+@@@@@@@@
    0x1e, 0x00,  //...%@@%.....
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0xff, 0xe0,  //@@@@@@@@@@@.
    0xff, 0xe0,  //@@@@@@@@@@@.
    0xff, 0xe0,  //@@@@@@@@@@@.
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0x1c, 0x00,  //...@@@......
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0067 (g) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x07, 0xe3, 0x80,  //.....%@@@@%...@@@
    0x1f, 0xfb, 0x80,  //...%@@@@@@@@%.@@@
    0x3f, 0xff, 0x80,  //..%@@@@@@@@@@%@@@
    0x3c, 0x1f, 0x80,  //.+@@@@+...+@@@@@@
    0x78, 0x0f, 0x80,  //.@@@%.......%@@@@
    0x70, 0x07, 0x80,  //+@@@.........@@@@
    0xe0, 0x03, 0x80,  //%@@+.........+@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //%@@+.........+@@@
    0x70, 0x07, 0x80,  //+@@@.........@@@@
    0x78, 0x0f, 0x80,  //.@@@%.......%@@@@
    0x3c, 0x1f, 0x80,  //.+@@@@+...+@@@@@@
    0x3f, 0xff, 0x80,  //..%@@@@@@@@@@%@@@
    0x1f, 0xfb, 0x80,  //...%@@@@@@@@%.@@@
    0x07, 0xe3, 0x80,  //.....%@@@@%...@@@
    0x00, 0x03, 0x80,  //.............+@@%
    0x00, 0x07, 0x00,  //.............@@@+
    0x00, 0x0f, 0x00,  //............%@@@.
    0x30, 0x1f, 0x00,  //..@%+.....+@@@@%.
    0x3f, 0xfe, 0x00,  //..@@@@@@@@@@@@@..
    0x3f, 0xfc, 0x00,  //..@@@@@@@@@@@%...
    0x0f, 0xf0, 0x00,  //...+%@@@@@@%.....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0068 (h) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe0, 0x00,  //@@@.............
    0xe3, 0xf0,  //@@@...%@@@@%+...
    0xe7, 0xfc,  //@@@.+@@@@@@@@%..
    0xff, 0xfe,  //@@@%@@@@@@@@@@%.
    0xfc, 0x1e,  //@@@@@%+...+@@@@.
    0xf0, 0x0f,  //@@@@+.......@@@%
    0xf0, 0x07,  //@@@%........+@@@
    0xe0, 0x07,  //@@@+.........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0069 (i) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+006a (j) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //..+@@%
    0x3c,  //..@@@%
    0xf8,  //@@@@@.
    0xf0,  //@@@@+.
    0xe0,  //@@%...
    0x00,  //......
    0x00,  //......


    /*Unicode: U+006b (k) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x0f, 0x00,  //@@@........+@@@@+
    0xe0, 0x1e, 0x00,  //@@@.......+@@@@+.
    0xe0, 0x7c, 0x00,  //@@@......%@@@@...
    0xe0, 0xf8, 0x00,  //@@@.....@@@@%....
    0xe1, 0xf0, 0x00,  //@@@....@@@@%.....
    0xe3, 0xc0, 0x00,  //@@@..+@@@@+......
    0xe7, 0x80, 0x00,  //@@@.+@@@@+.......
    0xff, 0x00, 0x00,  //@@@%@@@@.........
    0xfe, 0x00, 0x00,  //@@@@@@@..........
    0xfe, 0x00, 0x00,  //@@@@@@@..........
    0xef, 0x00, 0x00,  //@@@+@@@@.........
    0xe7, 0x80, 0x00,  //@@@.+@@@@........
    0xe3, 0xc0, 0x00,  //@@@...@@@@.......
    0xe1, 0xe0, 0x00,  //@@@....@@@@+.....
    0xe0, 0xf0, 0x00,  //@@@.....@@@@+....
    0xe0, 0x78, 0x00,  //@@@......@@@@+...
    0xe0, 0x3c, 0x00,  //@@@.......@@@@+..
    0xe0, 0x1e, 0x00,  //@@@........@@@@+.
    0xe0, 0x0f, 0x00,  //@@@.........@@@@+
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+006c (l) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+006d (m) , Width: 27 */
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0xe3, 0xe0, 0x3e, 0x00,  //@@@...%@@@@+......%@@@@+...
    0xef, 0xf8, 0xff, 0x80,  //@@@.%@@@@@@@@...%@@@@@@@@..
    0xff, 0xfd, 0xff, 0xc0,  //@@@%@@@@@@@@@@.%@@@@@@@@@%.
    0xfc, 0x3f, 0xc3, 0xc0,  //@@@@@%....%@@@%@@%....%@@@+
    0xf0, 0x1f, 0x01, 0xe0,  //@@@@+......%@@@@+......%@@%
    0xf0, 0x0f, 0x00, 0xe0,  //@@@%.......+@@@%.......+@@@
    0xe0, 0x0e, 0x00, 0xe0,  //@@@.........@@@.........@@@
    0xe0, 0x0e, 0x00, 0xe0,  //@@@.........@@@.........@@@
    0xe0, 0x0e, 0x00, 0xe0,  //@@@.........@@@.........@@@
    0xe0, 0x0e, 0x00, 0xe0,  //@@@.........@@@.........@@@
    0xe0, 0x0e, 0x00, 0xe0,  //@@@.........@@@.........@@@
    0xe0, 0x0e, 0x00, 0xe0,  //@@@.........@@@.........@@@
    0xe0, 0x0e, 0x00, 0xe0,  //@@@.........@@@.........@@@
    0xe0, 0x0e, 0x00, 0xe0,  //@@@.........@@@.........@@@
    0xe0, 0x0e, 0x00, 0xe0,  //@@@.........@@@.........@@@
    0xe0, 0x0e, 0x00, 0xe0,  //@@@.........@@@.........@@@
    0xe0, 0x0e, 0x00, 0xe0,  //@@@.........@@@.........@@@
    0xe0, 0x0e, 0x00, 0xe0,  //@@@.........@@@.........@@@
    0xe0, 0x0e, 0x00, 0xe0,  //@@@.........@@@.........@@@
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+006e (n) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xe3, 0xf0,  //@@@...%@@@@%+...
    0xe7, 0xfc,  //@@@.+@@@@@@@@%..
    0xff, 0xfe,  //@@@%@@@@@@@@@@%.
    0xfc, 0x1e,  //@@@@@%+...+@@@@.
    0xf0, 0x0f,  //@@@@+.......@@@%
    0xf0, 0x07,  //@@@%........+@@@
    0xe0, 0x07,  //@@@+.........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+006f (o) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x3c, 0x1e, 0x00,  //.+@@@@+...+@@@@+.
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x70, 0x07, 0x00,  //+@@@.........@@@+
    0xe0, 0x07, 0x80,  //%@@+.........+@@%
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //%@@+.........+@@%
    0x70, 0x07, 0x00,  //+@@@.........@@@+
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x3c, 0x1e, 0x00,  //.+@@@@+...+@@@@+.
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x1f, 0xfc, 0x00,  //...%@@@@@@@@@%...
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0070 (p) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xe3, 0xf0, 0x00,  //@@@...%@@@@%.....
    0xef, 0xfc, 0x00,  //@@@.%@@@@@@@@%...
    0xff, 0xfe, 0x00,  //@@@%@@@@@@@@@@%..
    0xfc, 0x1e, 0x00,  //@@@@@@+...+@@@@+.
    0xf8, 0x0f, 0x00,  //@@@@%.......%@@@.
    0xf0, 0x07, 0x00,  //@@@@.........@@@+
    0xe0, 0x03, 0x80,  //@@@+.........+@@%
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@+.........+@@%
    0xf0, 0x07, 0x00,  //@@@@.........@@@+
    0xf8, 0x0f, 0x00,  //@@@@%.......%@@@.
    0xfc, 0x1e, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0xfe, 0x00,  //@@@%@@@@@@@@@@%..
    0xef, 0xfc, 0x00,  //@@@.%@@@@@@@@%...
    0xe3, 0xf0, 0x00,  //@@@...%@@@@%.....
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0071 (q) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x07, 0xe3, 0x80,  //.....%@@@@%...@@@
    0x1f, 0xfb, 0x80,  //...%@@@@@@@@%.@@@
    0x3f, 0xff, 0x80,  //..%@@@@@@@@@@%@@@
    0x3c, 0x1f, 0x80,  //.+@@@@+...+@@@@@@
    0x78, 0x0f, 0x80,  //.@@@%.......%@@@@
    0x70, 0x07, 0x80,  //+@@@.........@@@@
    0xe0, 0x03, 0x80,  //%@@+.........+@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //%@@+.........+@@@
    0x70, 0x07, 0x80,  //+@@@.........@@@@
    0x78, 0x0f, 0x80,  //.@@@%.......%@@@@
    0x3c, 0x1f, 0x80,  //.+@@@@+...+@@@@@@
    0x3f, 0xff, 0x80,  //..%@@@@@@@@@@%@@@
    0x1f, 0xfb, 0x80,  //...%@@@@@@@@%.@@@
    0x07, 0xe3, 0x80,  //.....%@@@@%...@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x03, 0x80,  //..............@@@
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0072 (r) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xe3, 0xe0,  //@@@...%@@@@
    0xef, 0xe0,  //@@@.%@@@@@@
    0xff, 0xe0,  //@@@%@@@@@@@
    0xfc, 0x00,  //@@@@@%+....
    0xf8, 0x00,  //@@@@%......
    0xf0, 0x00,  //@@@@.......
    0xe0, 0x00,  //@@@+.......
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0073 (s) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x0f, 0xe0,  //...+%@@@@@%+..
    0x3f, 0xf8,  //.+@@@@@@@@@@@.
    0x7f, 0xf8,  //.@@@@@@@@@@@@.
    0xf0, 0x18,  //%@@@+.....+%@.
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xf0, 0x00,  //@@@@+.........
    0x7f, 0x00,  //+@@@@@@%+.....
    0x3f, 0xe0,  //.+@@@@@@@@@+..
    0x1f, 0xf8,  //...%@@@@@@@@%.
    0x00, 0xf8,  //.......+@@@@@+
    0x00, 0x3c,  //..........@@@%
    0x00, 0x1c,  //...........@@@
    0x00, 0x1c,  //...........@@@
    0x80, 0x1c,  //%.........+@@@
    0xe0, 0x7c,  //@@@+.....%@@@%
    0xff, 0xf8,  //@@@@@@@@@@@@@.
    0x7f, 0xf0,  //.%@@@@@@@@@@..
    0x1f, 0xc0,  //...%@@@@@%+...
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0074 (t) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0xff, 0xe0,  //@@@@@@@@@@@
    0xff, 0xe0,  //@@@@@@@@@@@
    0xff, 0xe0,  //@@@@@@@@@@@
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0x38, 0x00,  //..@@@......
    0x3c, 0x00,  //..%@@%.....
    0x1f, 0xe0,  //..+@@@@@@@@
    0x1f, 0xe0,  //...%@@@@@@@
    0x07, 0xe0,  //....+%@@@@@
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0075 (u) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@.........+@@@
    0xe0, 0x0f,  //@@@+........%@@@
    0xf0, 0x0f,  //%@@@.......+@@@@
    0x78, 0x3f,  //.@@@@+...+%@@@@@
    0x7f, 0xff,  //.%@@@@@@@@@@%@@@
    0x3f, 0xe7,  //..%@@@@@@@@+.@@@
    0x0f, 0xc7,  //...+%@@@@%...@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0076 (v) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0xe0, 0x01, 0xc0,  //@@@+..........+@@@
    0x70, 0x03, 0x80,  //+@@%..........%@@+
    0x70, 0x03, 0x80,  //.@@@..........@@@.
    0x70, 0x03, 0x80,  //.%@@+........+@@%.
    0x38, 0x07, 0x00,  //.+@@@........@@@+.
    0x38, 0x07, 0x00,  //..@@@........@@@..
    0x3c, 0x0f, 0x00,  //..%@@%......%@@%..
    0x1c, 0x0e, 0x00,  //..+@@@......@@@...
    0x1c, 0x0e, 0x00,  //...@@@+....+@@@...
    0x1e, 0x1e, 0x00,  //...%@@%....%@@%...
    0x0e, 0x1c, 0x00,  //....@@@....@@@....
    0x0e, 0x1c, 0x00,  //....@@@+..+@@@....
    0x07, 0x38, 0x00,  //....+@@%..@@@+....
    0x07, 0x38, 0x00,  //.....@@@..@@@.....
    0x07, 0x38, 0x00,  //.....%@@++@@%.....
    0x03, 0xf0, 0x00,  //.....+@@@@@@+.....
    0x03, 0xf0, 0x00,  //......@@@@@@......
    0x03, 0xf0, 0x00,  //......%@@@@%......
    0x01, 0xe0, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0077 (w) , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0xe0, 0x3e, 0x03, 0x80,  //@@@.......@@@@@.......@@@
    0xe0, 0x3e, 0x03, 0x80,  //%@@+......@@@@@......+@@%
    0x70, 0x3e, 0x07, 0x00,  //+@@%.....+@@@@@+.....%@@+
    0x70, 0x7f, 0x07, 0x00,  //.@@@.....%@@@@@%.....@@@.
    0x70, 0x77, 0x07, 0x00,  //.@@@.....@@@+@@@.....@@@.
    0x78, 0x77, 0x0f, 0x00,  //.%@@+....@@@.@@@....%@@%.
    0x38, 0x77, 0x0e, 0x00,  //.+@@@...+@@%.%@@+...@@@+.
    0x38, 0xe3, 0x8e, 0x00,  //..@@@...%@@+.+@@%...@@@..
    0x38, 0xe3, 0x8e, 0x00,  //..@@@+..@@@...@@@..+@@@..
    0x3c, 0xe3, 0x9e, 0x00,  //..%@@%..@@@...@@@..%@@%..
    0x1c, 0xe3, 0x9c, 0x00,  //..+@@@.+@@%...%@@+.@@@+..
    0x1d, 0xc1, 0xdc, 0x00,  //...@@@.%@@+...+@@%.@@@...
    0x1d, 0xc1, 0xdc, 0x00,  //...@@@+@@@.....@@@+@@@...
    0x1f, 0xc1, 0xfc, 0x00,  //...%@@@@@@.....@@@@@@%...
    0x0f, 0xc1, 0xf8, 0x00,  //...+@@@@@%.....%@@@@@+...
    0x0f, 0x80, 0xf8, 0x00,  //....@@@@@+.....+@@@@@....
    0x0f, 0x80, 0xf8, 0x00,  //....@@@@@.......@@@@@....
    0x0f, 0x80, 0xf8, 0x00,  //....%@@@@.......@@@@+....
    0x07, 0x80, 0xf0, 0x00,  //.....@@@%.......%@@@.....
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+0078 (x) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x78, 0x03, 0xc0,  //.%@@@.........@@@%
    0x3c, 0x07, 0x80,  //..@@@@.......@@@@.
    0x1e, 0x0f, 0x00,  //...@@@%.....%@@@..
    0x0e, 0x0e, 0x00,  //...+@@@.....@@@+..
    0x0f, 0x1e, 0x00,  //....%@@@...@@@%...
    0x07, 0xbc, 0x00,  //.....@@@%.%@@@....
    0x03, 0xf8, 0x00,  //.....+@@@%@@@+....
    0x03, 0xf8, 0x00,  //......%@@@@@%.....
    0x01, 0xf0, 0x00,  //.......@@@@@......
    0x01, 0xf0, 0x00,  //.......%@@@%......
    0x03, 0xf0, 0x00,  //......%@@@@@......
    0x03, 0xf8, 0x00,  //.....+@@@@@@@.....
    0x07, 0xbc, 0x00,  //.....@@@%.@@@%....
    0x0f, 0x1c, 0x00,  //....@@@@..+@@@....
    0x1e, 0x1e, 0x00,  //...%@@@....%@@@...
    0x1c, 0x0f, 0x00,  //..+@@@+.....@@@%..
    0x3c, 0x07, 0x00,  //..@@@%......+@@@+.
    0x78, 0x07, 0x80,  //.@@@@........%@@@.
    0xf0, 0x03, 0xc0,  //%@@@..........@@@%
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0079 (y) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0xe0, 0x01, 0xc0,  //@@@+..........+@@@
    0x70, 0x03, 0x80,  //+@@@..........@@@+
    0x70, 0x03, 0x80,  //.@@@+.........@@@.
    0x78, 0x07, 0x80,  //.%@@%........%@@%.
    0x38, 0x07, 0x00,  //..@@@........@@@..
    0x3c, 0x07, 0x00,  //..%@@%......+@@@..
    0x1c, 0x0e, 0x00,  //..+@@@......@@@+..
    0x1c, 0x0e, 0x00,  //...@@@+.....@@@...
    0x0e, 0x1e, 0x00,  //...+@@@....%@@%...
    0x0e, 0x1c, 0x00,  //....@@@....@@@+...
    0x0f, 0x1c, 0x00,  //....%@@%..+@@@....
    0x07, 0x38, 0x00,  //.....@@@..%@@+....
    0x07, 0x38, 0x00,  //.....@@@+.@@@.....
    0x03, 0xf8, 0x00,  //.....+@@@%@@%.....
    0x03, 0xf0, 0x00,  //......@@@@@@+.....
    0x03, 0xf0, 0x00,  //......%@@@@@......
    0x01, 0xf0, 0x00,  //.......@@@@+......
    0x01, 0xe0, 0x00,  //.......%@@@.......
    0x01, 0xe0, 0x00,  //.......%@@%.......
    0x01, 0xc0, 0x00,  //.......@@@+.......
    0x01, 0xc0, 0x00,  //......+@@@........
    0x03, 0xc0, 0x00,  //......%@@%........
    0x07, 0x80, 0x00,  //.....%@@@.........
    0x3f, 0x80, 0x00,  //..@@@@@@%.........
    0x3f, 0x00, 0x00,  //..@@@@@@..........
    0x3e, 0x00, 0x00,  //..@@@@%...........
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+007a (z) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0x00, 0x1c,  //..........+@@@+
    0x00, 0x3c,  //.........+@@@%.
    0x00, 0x78,  //.........@@@%..
    0x00, 0xf0,  //........@@@@...
    0x01, 0xe0,  //.......@@@@....
    0x03, 0xc0,  //......%@@@+....
    0x03, 0x80,  //.....+@@@+.....
    0x07, 0x80,  //....+@@@%......
    0x0f, 0x00,  //....@@@@.......
    0x1e, 0x00,  //...@@@@........
    0x3c, 0x00,  //..%@@@.........
    0x78, 0x00,  //.%@@@+.........
    0x78, 0x00,  //+@@@%..........
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+007b ({) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0xf8,  //.......+%@@@@
    0x03, 0xf8,  //......%@@@@@@
    0x03, 0xf8,  //.....+@@@@@@@
    0x07, 0x80,  //.....%@@@+...
    0x07, 0x00,  //.....@@@+....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //....+@@@.....
    0x0e, 0x00,  //...+@@@+.....
    0xfe, 0x00,  //@@@@@@%......
    0xf8, 0x00,  //@@@@@+.......
    0xfe, 0x00,  //@@@@@@%......
    0x1e, 0x00,  //...%@@@+.....
    0x0f, 0x00,  //....%@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x80,  //.....%@@@+...
    0x03, 0xf8,  //.....+@@@@@@@
    0x03, 0xf8,  //......%@@@@@@
    0x00, 0xf8,  //.......+%@@@@
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+007c (|) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...


    /*Unicode: U+007d (}) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0xf8, 0x00,  //@@@@%+.......
    0xfe, 0x00,  //@@@@@@%......
    0xfe, 0x00,  //@@@@@@@+.....
    0x0f, 0x00,  //...+@@@%.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@+....
    0x03, 0x80,  //.....+@@@+...
    0x03, 0xf8,  //......%@@@@@@
    0x00, 0xf8,  //.......+@@@@@
    0x03, 0xf8,  //......%@@@@@@
    0x03, 0xc0,  //.....+@@@%...
    0x07, 0x80,  //.....@@@%....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x07, 0x00,  //.....@@@.....
    0x0f, 0x00,  //...+@@@%.....
    0xfe, 0x00,  //@@@@@@@+.....
    0xfe, 0x00,  //@@@@@@%......
    0xf8, 0x00,  //@@@@%+.......
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+007e (~) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x1f, 0x80, 0x08,  //...%@@@@%+.........+@
    0x7f, 0xf0, 0x38,  //.%@@@@@@@@@@+....+@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xe0, 0x7f, 0xf0,  //@@@+....+@@@@@@@@@@%.
    0xc0, 0x0f, 0xc0,  //@%.........+%@@@@%...
    0x00, 0x00, 0x00,  //+....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................



#elif USE_LV_FONT_DEJAVU_40 == 2
    /*Unicode: U+0020 ( ) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0021 (!) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xb8,  //%@%
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0022 (") , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0xfc, 0x0f, 0xc0,  //@@@...@@@
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0023 (#) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x2f, 0x00, 0x3d, 0x00,  //.........%@@.....@@+...
    0x00, 0x00, 0x3f, 0x00, 0x7c, 0x00,  //.........@@%....+@@....
    0x00, 0x00, 0x3e, 0x00, 0xbc, 0x00,  //.........@@%....%@@....
    0x00, 0x00, 0x7d, 0x00, 0xf8, 0x00,  //........+@@+....@@%....
    0x00, 0x00, 0xbc, 0x00, 0xf4, 0x00,  //........%@@.....@@+....
    0x00, 0x00, 0xfc, 0x01, 0xf0, 0x00,  //........@@@....+@@.....
    0x00, 0x00, 0xf8, 0x02, 0xf0, 0x00,  //........@@%....%@@.....
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xfc,  //..@@@@@@@@@@@@@@@@@@@@@
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xfc,  //..@@@@@@@@@@@@@@@@@@@@@
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xfc,  //..@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x03, 0xe0, 0x0b, 0xc0, 0x00,  //.......@@%....%@@......
    0x00, 0x07, 0xd0, 0x0f, 0xc0, 0x00,  //.......@@+....@@@......
    0x00, 0x0b, 0xc0, 0x0f, 0x80, 0x00,  //......%@@.....@@%......
    0x00, 0x0f, 0xc0, 0x1f, 0x40, 0x00,  //......@@@....+@@+......
    0x00, 0x0f, 0x80, 0x2f, 0x00, 0x00,  //......@@%....%@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@..
    0x00, 0x3e, 0x00, 0xbc, 0x00, 0x00,  //.....@@%....%@@........
    0x00, 0x3d, 0x00, 0xfc, 0x00, 0x00,  //.....@@+....%@@........
    0x00, 0x7c, 0x00, 0xf8, 0x00, 0x00,  //....+@@.....@@%........
    0x00, 0xbc, 0x00, 0xf4, 0x00, 0x00,  //....%@@.....@@+........
    0x00, 0xf8, 0x01, 0xf0, 0x00, 0x00,  //....@@%....+@@.........
    0x00, 0xf4, 0x02, 0xf0, 0x00, 0x00,  //....@@+....%@@.........
    0x01, 0xf0, 0x03, 0xe0, 0x00, 0x00,  //...+@@.....@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0024 ($) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0xbf, 0xfe, 0x40,  //....%@@@@@@%+...
    0x0b, 0xff, 0xff, 0xf0,  //..%@@@@@@@@@@@..
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@..
    0x7f, 0x93, 0xc1, 0xb0,  //+@@@%+.@@..+%@..
    0xfe, 0x03, 0xc0, 0x00,  //@@@%...@@.......
    0xfc, 0x03, 0xc0, 0x00,  //@@@....@@.......
    0xfc, 0x03, 0xc0, 0x00,  //@@@....@@.......
    0xfe, 0x03, 0xc0, 0x00,  //@@@%...@@.......
    0x7f, 0xe7, 0xc0, 0x00,  //+@@@@%+@@.......
    0x2f, 0xff, 0xf9, 0x00,  //.%@@@@@@@@%+....
    0x07, 0xff, 0xff, 0xd0,  //..+@@@@@@@@@@+..
    0x00, 0x1b, 0xff, 0xf4,  //.....+%@@@@@@@+.
    0x00, 0x03, 0xcb, 0xfd,  //.......@@.%@@@@.
    0x00, 0x03, 0xc0, 0xfe,  //.......@@...@@@%
    0x00, 0x03, 0xc0, 0x3f,  //.......@@....@@@
    0x00, 0x03, 0xc0, 0x3f,  //.......@@....@@@
    0x00, 0x03, 0xc0, 0x3f,  //.......@@....@@@
    0x80, 0x03, 0xc0, 0xbe,  //%......@@...%@@%
    0xfd, 0x03, 0xc7, 0xfd,  //@@@+...@@.+@@@@+
    0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@%.
    0x2f, 0xff, 0xff, 0xe0,  //.%@@@@@@@@@@@%..
    0x01, 0xbf, 0xf9, 0x00,  //...+%@@@@@%+....
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0025 (%) , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x02, 0xfe, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00,  //...%@@@%.............@@%.....
    0x0f, 0xff, 0xc0, 0x00, 0x00, 0x7c, 0x00, 0x00,  //..@@@@@@@...........+@@......
    0x3f, 0x47, 0xf0, 0x00, 0x00, 0xf4, 0x00, 0x00,  //.@@@+.+@@@..........@@+......
    0x7e, 0x02, 0xf4, 0x00, 0x02, 0xe0, 0x00, 0x00,  //+@@%...%@@+........%@%.......
    0xbd, 0x01, 0xf8, 0x00, 0x07, 0xc0, 0x00, 0x00,  //%@@+...+@@%.......+@@........
    0xfc, 0x00, 0xfc, 0x00, 0x0f, 0x40, 0x00, 0x00,  //@@@.....@@@.......@@+........
    0xfc, 0x00, 0xfc, 0x00, 0x2e, 0x00, 0x00, 0x00,  //@@@.....@@@......%@%.........
    0xfc, 0x00, 0xfc, 0x00, 0x7c, 0x00, 0x00, 0x00,  //@@@.....@@@.....+@@..........
    0xfc, 0x00, 0xfc, 0x00, 0xf4, 0x00, 0x00, 0x00,  //@@@.....@@@.....@@+..........
    0xbd, 0x01, 0xf8, 0x02, 0xe0, 0x00, 0x00, 0x00,  //%@@....+@@%....%@%...........
    0x7e, 0x02, 0xf4, 0x07, 0xc0, 0x00, 0x00, 0x00,  //+@@%...%@@+...+@@............
    0x3f, 0x47, 0xf0, 0x0f, 0x40, 0x2f, 0xe0, 0x00,  //.@@@+.+@@@....@@+....%@@@%...
    0x0f, 0xff, 0xc0, 0x2e, 0x00, 0xff, 0xfc, 0x00,  //..@@@@@@@....%@%....@@@@@@@..
    0x02, 0xfe, 0x00, 0x7c, 0x03, 0xf4, 0x7f, 0x00,  //...%@@@%....+@@....@@@+.+@@@.
    0x00, 0x00, 0x00, 0xf4, 0x07, 0xe0, 0x2f, 0x40,  //............@@+...+@@%...%@@+
    0x00, 0x00, 0x02, 0xe0, 0x0b, 0xd0, 0x1f, 0x80,  //...........%@%....%@@+...+@@%
    0x00, 0x00, 0x07, 0xc0, 0x0f, 0xc0, 0x0f, 0xc0,  //..........+@@.....@@@.....@@@
    0x00, 0x00, 0x0f, 0x40, 0x0f, 0xc0, 0x0f, 0xc0,  //..........@@+.....@@@.....@@@
    0x00, 0x00, 0x2e, 0x00, 0x0f, 0xc0, 0x0f, 0xc0,  //.........%@%......@@@.....@@@
    0x00, 0x00, 0x7c, 0x00, 0x0f, 0xc0, 0x0f, 0xc0,  //........+@@.......@@@.....@@@
    0x00, 0x00, 0xf4, 0x00, 0x0b, 0xd0, 0x1f, 0x80,  //........@@+.......%@@+...+@@%
    0x00, 0x02, 0xe0, 0x00, 0x07, 0xe0, 0x2f, 0x40,  //.......%@%........+@@%...%@@+
    0x00, 0x07, 0xc0, 0x00, 0x03, 0xf4, 0x7f, 0x00,  //......+@@..........@@@+.+@@@.
    0x00, 0x0f, 0x40, 0x00, 0x00, 0xff, 0xfc, 0x00,  //......@@+...........@@@@@@@..
    0x00, 0x2f, 0x00, 0x00, 0x00, 0x2f, 0xe0, 0x00,  //.....%@@.............%@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+0026 (&) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x06, 0xff, 0x90, 0x00, 0x00,  //......+%@@@@%+.........
    0x00, 0x3f, 0xff, 0xfc, 0x00, 0x00,  //.....@@@@@@@@@@........
    0x00, 0xff, 0xff, 0xfc, 0x00, 0x00,  //....@@@@@@@@@@@........
    0x02, 0xfe, 0x00, 0x6c, 0x00, 0x00,  //...+@@@%....+%@........
    0x03, 0xf8, 0x00, 0x00, 0x00, 0x00,  //...@@@%................
    0x03, 0xf0, 0x00, 0x00, 0x00, 0x00,  //...@@@.................
    0x03, 0xf0, 0x00, 0x00, 0x00, 0x00,  //...@@@.................
    0x03, 0xf4, 0x00, 0x00, 0x00, 0x00,  //...@@@+................
    0x02, 0xfc, 0x00, 0x00, 0x00, 0x00,  //...%@@@................
    0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@@...............
    0x01, 0xff, 0xc0, 0x00, 0x00, 0x00,  //...+@@@@@..............
    0x07, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..+@@@@@@@.............
    0x1f, 0xf7, 0xfc, 0x00, 0x03, 0xf0,  //.+@@@@+@@@@........@@@.
    0x3f, 0xc1, 0xff, 0x00, 0x07, 0xe0,  //.@@@@..+@@@@......+@@%.
    0x7f, 0x00, 0x7f, 0xc0, 0x0f, 0xd0,  //+@@@....+@@@@.....@@@+.
    0xfd, 0x00, 0x1f, 0xf0, 0x0f, 0xc0,  //@@@+.....+@@@@....@@@..
    0xfc, 0x00, 0x07, 0xfc, 0x3f, 0x80,  //@@@.......+@@@@..@@@%..
    0xfc, 0x00, 0x01, 0xff, 0xbf, 0x00,  //@@@........+@@@@%@@@...
    0xfd, 0x00, 0x00, 0x7f, 0xfd, 0x00,  //@@@+........+@@@@@@+...
    0xbf, 0x00, 0x00, 0x2f, 0xfc, 0x00,  //%@@@.........%@@@@@....
    0x7f, 0x80, 0x00, 0x7f, 0xfd, 0x00,  //.@@@%.......+@@@@@@+...
    0x2f, 0xf4, 0x06, 0xff, 0xff, 0x00,  //.%@@@@+...+%@@@@@@@@...
    0x0b, 0xff, 0xff, 0xfc, 0xbf, 0xc0,  //..%@@@@@@@@@@@@.%@@@@..
    0x02, 0xff, 0xff, 0xe0, 0x2f, 0xe0,  //...+@@@@@@@@@%...%@@@%.
    0x00, 0x1b, 0xfe, 0x40, 0x0b, 0xf8,  //.....+%@@@@%+.....%@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0027 (') , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0028 (() , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x7e,  //....+@@%
    0x00, 0xfc,  //....@@@.
    0x02, 0xf4,  //...%@@+.
    0x03, 0xf0,  //...@@@..
    0x0b, 0xd0,  //..%@@+..
    0x0f, 0xc0,  //..@@@...
    0x1f, 0x80,  //.+@@%...
    0x2f, 0x00,  //.%@@....
    0x3f, 0x00,  //.@@@....
    0x7e, 0x00,  //+@@%....
    0xbd, 0x00,  //%@@+....
    0xbd, 0x00,  //%@@+....
    0xfc, 0x00,  //@@@.....
    0xfc, 0x00,  //@@@.....
    0xfc, 0x00,  //@@@.....
    0xfc, 0x00,  //@@@.....
    0xfc, 0x00,  //@@@.....
    0xfc, 0x00,  //@@@.....
    0xbd, 0x00,  //%@@+....
    0xbd, 0x00,  //%@@+....
    0x7e, 0x00,  //+@@%....
    0x3f, 0x00,  //.@@@....
    0x2f, 0x00,  //.%@@....
    0x1f, 0x80,  //.+@@%...
    0x0f, 0xc0,  //..@@@...
    0x0b, 0xd0,  //..%@@+..
    0x03, 0xf0,  //...@@@..
    0x02, 0xf4,  //...%@@+.
    0x00, 0xfc,  //....@@@.
    0x00, 0x7e,  //....+@@%
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0029 ()) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xbd, 0x00,  //%@@+....
    0x3f, 0x00,  //.@@@....
    0x1f, 0x40,  //.+@@+...
    0x0f, 0xc0,  //..@@@...
    0x07, 0xe0,  //..+@@%..
    0x03, 0xf0,  //...@@@..
    0x02, 0xf4,  //...%@@+.
    0x01, 0xf8,  //....@@%.
    0x00, 0xfc,  //....@@@.
    0x00, 0xbd,  //....%@@+
    0x00, 0x7e,  //....+@@%
    0x00, 0x7e,  //....+@@%
    0x00, 0x3f,  //.....@@@
    0x00, 0x3f,  //.....@@@
    0x00, 0x3f,  //.....@@@
    0x00, 0x3f,  //.....@@@
    0x00, 0x3f,  //.....@@@
    0x00, 0x3f,  //.....@@@
    0x00, 0x7e,  //....+@@%
    0x00, 0x7e,  //....+@@%
    0x00, 0xbd,  //....%@@+
    0x00, 0xfc,  //....@@@.
    0x01, 0xf8,  //....@@%.
    0x02, 0xf4,  //...%@@+.
    0x03, 0xf0,  //...@@@..
    0x07, 0xe0,  //..+@@%..
    0x0f, 0xc0,  //..@@@...
    0x1f, 0x80,  //.+@@+...
    0x3f, 0x00,  //.@@@....
    0xbd, 0x00,  //%@@+....
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+002a (*) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x60, 0x03, 0xc0, 0x09,  //+%.....@@.....%+
    0xfe, 0x03, 0xc0, 0xbf,  //@@@%...@@...%@@%
    0x1f, 0xd3, 0xc7, 0xf4,  //.+@@@+.@@.+@@@+.
    0x02, 0xff, 0xff, 0x80,  //...+@@@@@@@@+...
    0x00, 0x2f, 0xf8, 0x00,  //.....%@@@@%.....
    0x00, 0x2f, 0xf8, 0x00,  //.....%@@@@%.....
    0x01, 0xff, 0xff, 0x40,  //...+@@@@@@@@+...
    0x1f, 0xd3, 0xc7, 0xf4,  //.+@@@+.@@.+@@@+.
    0xfe, 0x03, 0xc0, 0xbf,  //%@@%...@@...%@@%
    0x60, 0x03, 0xc0, 0x09,  //+%.....@@.....%+
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+002b (+) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+002c (,) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x3f,  //.@@@
    0x3f,  //.@@@
    0x3f,  //.@@@
    0x3e,  //.@@%
    0x7d,  //+@@+
    0xbc,  //%@@.
    0xb8,  //%@%.
    0xf0,  //@@..
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+002d (-) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+002e (.) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+002f (/) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0xfc,  //........@@@
    0x00, 0x02, 0xf8,  //.......%@@%
    0x00, 0x03, 0xf4,  //.......@@@+
    0x00, 0x03, 0xf0,  //.......@@@.
    0x00, 0x07, 0xe0,  //......+@@%.
    0x00, 0x0b, 0xd0,  //......%@@+.
    0x00, 0x0f, 0xc0,  //......@@@..
    0x00, 0x0f, 0xc0,  //......@@@..
    0x00, 0x2f, 0x80,  //.....+@@%..
    0x00, 0x3f, 0x40,  //.....@@@+..
    0x00, 0x3f, 0x00,  //.....@@@...
    0x00, 0x7f, 0x00,  //....+@@@...
    0x00, 0xbd, 0x00,  //....%@@+...
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x01, 0xf8, 0x00,  //...+@@%....
    0x03, 0xf4, 0x00,  //...@@@+....
    0x03, 0xf0, 0x00,  //...@@@.....
    0x07, 0xf0, 0x00,  //..+@@@.....
    0x0b, 0xe0, 0x00,  //..%@@%.....
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x1f, 0x80, 0x00,  //.+@@%......
    0x2f, 0x40, 0x00,  //.%@@+......
    0x3f, 0x00, 0x00,  //.@@@.......
    0x7f, 0x00, 0x00,  //+@@@.......
    0xbe, 0x00, 0x00,  //%@@%.......
    0xfd, 0x00, 0x00,  //@@@+.......
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0030 (0) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x1b, 0xf9, 0x00, 0x00,  //.....+%@@@%+.....
    0x01, 0xff, 0xff, 0xd0, 0x00,  //...+@@@@@@@@@....
    0x03, 0xff, 0xff, 0xf0, 0x00,  //...@@@@@@@@@@@...
    0x0f, 0xf4, 0x07, 0xfc, 0x00,  //..@@@@+...+@@@@..
    0x2f, 0xc0, 0x00, 0xfe, 0x00,  //.%@@@.......@@@+.
    0x3f, 0x40, 0x00, 0x7f, 0x00,  //.@@@+.......+@@@.
    0x7f, 0x00, 0x00, 0x3f, 0x00,  //.@@@.........@@@.
    0xbe, 0x00, 0x00, 0x2f, 0x80,  //%@@%.........%@@+
    0xbd, 0x00, 0x00, 0x1f, 0x80,  //%@@+.........+@@%
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xbd, 0x00, 0x00, 0x1f, 0x80,  //%@@+.........+@@%
    0xbe, 0x00, 0x00, 0x2f, 0x80,  //%@@%.........%@@%
    0x7f, 0x00, 0x00, 0x3f, 0x00,  //+@@@.........@@@.
    0x3f, 0x40, 0x00, 0x7f, 0x00,  //.@@@+.......+@@@.
    0x2f, 0xc0, 0x00, 0xfe, 0x00,  //.%@@@.......@@@+.
    0x0f, 0xf4, 0x07, 0xfc, 0x00,  //..@@@@+...+@@@@..
    0x03, 0xff, 0xff, 0xf0, 0x00,  //...@@@@@@@@@@@...
    0x01, 0xff, 0xff, 0xd0, 0x00,  //...+@@@@@@@@@....
    0x00, 0x1f, 0xfd, 0x00, 0x00,  //.....+%@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0031 (1) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x16, 0xff, 0xc0, 0x00,  //..+%@@@@@.....
    0xff, 0xff, 0xc0, 0x00,  //@@@@@@@@@.....
    0xff, 0xff, 0xc0, 0x00,  //@@@@@@@@@.....
    0xe9, 0x0f, 0xc0, 0x00,  //@%%+..@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@.....
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0032 (2) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x1a, 0xff, 0xf9, 0x00, 0x00,  //.+%%@@@@@@%+.....
    0xff, 0xff, 0xff, 0xc0, 0x00,  //@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xf4, 0x00,  //@@@@@@@@@@@@@@+..
    0xfe, 0x40, 0x0b, 0xfc, 0x00,  //@@@%+.....%@@@@..
    0xd0, 0x00, 0x01, 0xfe, 0x00,  //@+.........+@@@%.
    0x00, 0x00, 0x00, 0x7f, 0x00,  //............+@@@.
    0x00, 0x00, 0x00, 0x3f, 0x00,  //.............@@@.
    0x00, 0x00, 0x00, 0x3f, 0x00,  //.............@@@.
    0x00, 0x00, 0x00, 0x3f, 0x00,  //.............@@@.
    0x00, 0x00, 0x00, 0xbe, 0x00,  //............%@@%.
    0x00, 0x00, 0x00, 0xfc, 0x00,  //............@@@..
    0x00, 0x00, 0x03, 0xf4, 0x00,  //...........@@@+..
    0x00, 0x00, 0x0f, 0xe0, 0x00,  //..........@@@%...
    0x00, 0x00, 0x3f, 0xc0, 0x00,  //.........@@@@....
    0x00, 0x00, 0xff, 0x00, 0x00,  //........@@@@.....
    0x00, 0x03, 0xfc, 0x00, 0x00,  //.......@@@@......
    0x00, 0x0f, 0xf0, 0x00, 0x00,  //......@@@@.......
    0x00, 0x3f, 0xc0, 0x00, 0x00,  //.....@@@@........
    0x01, 0xff, 0x00, 0x00, 0x00,  //...+@@@@.........
    0x07, 0xfc, 0x00, 0x00, 0x00,  //..+@@@@..........
    0x1f, 0xf0, 0x00, 0x00, 0x00,  //.+@@@@...........
    0x7f, 0xc0, 0x00, 0x00, 0x00,  //+@@@@............
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0033 (3) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x06, 0xff, 0xf8, 0x00,  //..+%@@@@@@%.....
    0x3f, 0xff, 0xff, 0x80,  //.@@@@@@@@@@@%...
    0x3f, 0xff, 0xff, 0xe0,  //.@@@@@@@@@@@@%..
    0x39, 0x00, 0x1f, 0xf4,  //.@%+.....+@@@@+.
    0x00, 0x00, 0x02, 0xfc,  //...........%@@%.
    0x00, 0x00, 0x00, 0xfc,  //............@@@.
    0x00, 0x00, 0x00, 0xfc,  //............@@@.
    0x00, 0x00, 0x00, 0xfc,  //............@@@.
    0x00, 0x00, 0x02, 0xf4,  //...........%@@+.
    0x00, 0x00, 0x1f, 0xf0,  //.........+@@@@..
    0x00, 0xff, 0xff, 0x80,  //....@@@@@@@@%...
    0x00, 0xff, 0xfe, 0x00,  //....@@@@@@@%....
    0x00, 0xff, 0xff, 0xd0,  //....@@@@@@@@@+..
    0x00, 0x00, 0x1b, 0xf8,  //.........+%@@@%.
    0x00, 0x00, 0x01, 0xfd,  //...........+@@@+
    0x00, 0x00, 0x00, 0x7e,  //............+@@%
    0x00, 0x00, 0x00, 0x3f,  //.............@@@
    0x00, 0x00, 0x00, 0x3f,  //.............@@@
    0x00, 0x00, 0x00, 0x3f,  //.............@@@
    0x00, 0x00, 0x00, 0xbe,  //............%@@%
    0x00, 0x00, 0x01, 0xfd,  //...........+@@@+
    0xe4, 0x00, 0x1b, 0xfc,  //@%+......+%@@@@.
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@%...
    0x1b, 0xff, 0xe4, 0x00,  //.+%@@@@@@%+.....
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0034 (4) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x0b, 0xfc, 0x00,  //..........%@@@@....
    0x00, 0x00, 0x1f, 0xfc, 0x00,  //.........+@@@@@....
    0x00, 0x00, 0x3f, 0xfc, 0x00,  //.........@@@@@@....
    0x00, 0x00, 0xbc, 0xfc, 0x00,  //........%@@.@@@....
    0x00, 0x01, 0xf4, 0xfc, 0x00,  //.......+@@+.@@@....
    0x00, 0x03, 0xf0, 0xfc, 0x00,  //.......@@@..@@@....
    0x00, 0x0b, 0xc0, 0xfc, 0x00,  //......%@@...@@@....
    0x00, 0x1f, 0x40, 0xfc, 0x00,  //.....+@@+...@@@....
    0x00, 0x3f, 0x00, 0xfc, 0x00,  //.....@@@....@@@....
    0x00, 0xfc, 0x00, 0xfc, 0x00,  //....@@@.....@@@....
    0x01, 0xf4, 0x00, 0xfc, 0x00,  //...+@@+.....@@@....
    0x03, 0xf0, 0x00, 0xfc, 0x00,  //...@@@......@@@....
    0x0f, 0xc0, 0x00, 0xfc, 0x00,  //..@@@.......@@@....
    0x1f, 0x40, 0x00, 0xfc, 0x00,  //.+@@+.......@@@....
    0x3f, 0x00, 0x00, 0xfc, 0x00,  //.@@@........@@@....
    0xfc, 0x00, 0x00, 0xfc, 0x00,  //@@@.........@@@....
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0xfc, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0xfc, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0xfc, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0xfc, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0xfc, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0xfc, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0035 (5) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@..
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@..
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@..
    0x3f, 0x00, 0x00, 0x00,  //.@@@............
    0x3f, 0x00, 0x00, 0x00,  //.@@@............
    0x3f, 0x00, 0x00, 0x00,  //.@@@............
    0x3f, 0x00, 0x00, 0x00,  //.@@@............
    0x3f, 0x00, 0x00, 0x00,  //.@@@............
    0x3f, 0x00, 0x00, 0x00,  //.@@@............
    0x3f, 0xbf, 0xe4, 0x00,  //.@@@%@@@@%+.....
    0x3f, 0xff, 0xff, 0x80,  //.@@@@@@@@@@@%...
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@..
    0x39, 0x00, 0x1f, 0xf8,  //.@%+.....+@@@@%.
    0x00, 0x00, 0x02, 0xfd,  //...........%@@@+
    0x00, 0x00, 0x00, 0xbe,  //............%@@%
    0x00, 0x00, 0x00, 0x3f,  //.............@@@
    0x00, 0x00, 0x00, 0x3f,  //.............@@@
    0x00, 0x00, 0x00, 0x3f,  //.............@@@
    0x00, 0x00, 0x00, 0x3f,  //.............@@@
    0x00, 0x00, 0x00, 0xbe,  //............%@@%
    0x00, 0x00, 0x02, 0xfd,  //...........%@@@+
    0xe4, 0x00, 0x1f, 0xf8,  //@%+......+@@@@%.
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@%...
    0x1b, 0xff, 0xe4, 0x00,  //.+%@@@@@@%+.....
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0036 (6) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x06, 0xff, 0x90, 0x00,  //......+%@@@@%+...
    0x00, 0x7f, 0xff, 0xfc, 0x00,  //....+@@@@@@@@@@..
    0x01, 0xff, 0xff, 0xfc, 0x00,  //...+@@@@@@@@@@@..
    0x07, 0xfd, 0x00, 0x6c, 0x00,  //..+@@@@+....+%@..
    0x0f, 0xe0, 0x00, 0x00, 0x00,  //..@@@%...........
    0x2f, 0xc0, 0x00, 0x00, 0x00,  //.%@@@............
    0x3f, 0x40, 0x00, 0x00, 0x00,  //.@@@+............
    0x7f, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0xbe, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0xfd, 0x0b, 0xfe, 0x40, 0x00,  //@@@+..%@@@@%+....
    0xfc, 0x7f, 0xff, 0xf0, 0x00,  //@@@.+@@@@@@@@@...
    0xfd, 0xff, 0xff, 0xfc, 0x00,  //@@@+@@@@@@@@@@@..
    0xff, 0xf8, 0x02, 0xff, 0x00,  //@@@@@@%....%@@@@.
    0xff, 0xd0, 0x00, 0x7f, 0x40,  //@@@@@+......+@@@+
    0xff, 0x80, 0x00, 0x2f, 0x80,  //@@@@%........%@@%
    0xff, 0x00, 0x00, 0x0f, 0xc0,  //@@@@..........@@@
    0xbf, 0x00, 0x00, 0x0f, 0xc0,  //%@@@..........@@@
    0x7f, 0x00, 0x00, 0x0f, 0xc0,  //+@@@..........@@@
    0x3f, 0x00, 0x00, 0x0f, 0xc0,  //.@@@..........@@@
    0x3f, 0x80, 0x00, 0x2f, 0x80,  //.@@@%........%@@%
    0x1f, 0xd0, 0x00, 0x7f, 0x40,  //.+@@@+......+@@@+
    0x0f, 0xf8, 0x02, 0xff, 0x00,  //..@@@@%....%@@@@.
    0x03, 0xff, 0xff, 0xfc, 0x00,  //...@@@@@@@@@@@@..
    0x00, 0xff, 0xff, 0xf0, 0x00,  //....@@@@@@@@@%...
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0037 (7) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0xfc,  //............@@@.
    0x00, 0x00, 0x02, 0xf8,  //...........%@@%.
    0x00, 0x00, 0x03, 0xf4,  //...........@@@+.
    0x00, 0x00, 0x07, 0xf0,  //..........+@@@..
    0x00, 0x00, 0x0f, 0xd0,  //..........@@@+..
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@...
    0x00, 0x00, 0x2f, 0x80,  //.........%@@%...
    0x00, 0x00, 0x3f, 0x00,  //.........@@@....
    0x00, 0x00, 0x7f, 0x00,  //........+@@@....
    0x00, 0x00, 0xfd, 0x00,  //........@@@+....
    0x00, 0x00, 0xfc, 0x00,  //........@@@.....
    0x00, 0x02, 0xf8, 0x00,  //.......%@@%.....
    0x00, 0x03, 0xf0, 0x00,  //.......@@@......
    0x00, 0x07, 0xf0, 0x00,  //......+@@%......
    0x00, 0x0f, 0xd0, 0x00,  //......@@@+......
    0x00, 0x1f, 0xc0, 0x00,  //.....+@@@.......
    0x00, 0x2f, 0x80, 0x00,  //.....%@@%.......
    0x00, 0x3f, 0x00, 0x00,  //.....@@@........
    0x00, 0xbe, 0x00, 0x00,  //....%@@%........
    0x00, 0xfd, 0x00, 0x00,  //....@@@+........
    0x01, 0xfc, 0x00, 0x00,  //...+@@@.........
    0x03, 0xf4, 0x00, 0x00,  //...@@@+.........
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0038 (8) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x0f, 0xff, 0xff, 0xfc, 0x00,  //..@@@@@@@@@@@@@..
    0x1f, 0xf4, 0x07, 0xfd, 0x00,  //.+@@@@+...+@@@@+.
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x3f, 0x00, 0x00, 0x3f, 0x00,  //.@@@.........@@@.
    0x3f, 0x00, 0x00, 0x3f, 0x00,  //.@@@.........@@@.
    0x3f, 0x00, 0x00, 0x3f, 0x00,  //.@@@.........@@@.
    0x1f, 0x80, 0x00, 0xbd, 0x00,  //.+@@%.......%@@+.
    0x0f, 0xf4, 0x07, 0xfc, 0x00,  //..@@@@+...+@@@@..
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x00, 0xbf, 0xff, 0x80, 0x00,  //....%@@@@@@@%....
    0x07, 0xff, 0xff, 0xf4, 0x00,  //..+@@@@@@@@@@@+..
    0x2f, 0xe0, 0x02, 0xfe, 0x00,  //.%@@@%.....%@@@%.
    0x3f, 0x00, 0x00, 0x3f, 0x00,  //.@@@.........@@@.
    0xbd, 0x00, 0x00, 0x1f, 0x80,  //%@@+.........+@@%
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfd, 0x00, 0x00, 0x1f, 0xc0,  //@@@+.........+@@@
    0xbf, 0x00, 0x00, 0x3f, 0x80,  //+@@@.........@@@+
    0x3f, 0xe0, 0x02, 0xff, 0x00,  //.@@@@%.....%@@@@.
    0x1f, 0xff, 0xff, 0xfd, 0x00,  //.+@@@@@@@@@@@@@+.
    0x07, 0xff, 0xff, 0xf4, 0x00,  //..+@@@@@@@@@@@+..
    0x00, 0x6f, 0xfe, 0x40, 0x00,  //....+%@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0039 (9) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x6f, 0xf9, 0x00, 0x00,  //....+%@@@@%+.....
    0x02, 0xff, 0xff, 0xc0, 0x00,  //...%@@@@@@@@@....
    0x0f, 0xff, 0xff, 0xf0, 0x00,  //..@@@@@@@@@@@@...
    0x3f, 0xe0, 0x0b, 0xfc, 0x00,  //.@@@@%....%@@@@..
    0x7f, 0x40, 0x01, 0xfd, 0x00,  //+@@@+......+@@@+.
    0xbe, 0x00, 0x00, 0xbf, 0x00,  //%@@%........%@@@.
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@.
    0xfc, 0x00, 0x00, 0x3f, 0x40,  //@@@..........@@@+
    0xfc, 0x00, 0x00, 0x3f, 0x80,  //@@@..........@@@%
    0xfc, 0x00, 0x00, 0x3f, 0xc0,  //@@@..........@@@@
    0xbe, 0x00, 0x00, 0xbf, 0xc0,  //%@@%........%@@@@
    0x7f, 0x00, 0x01, 0xff, 0xc0,  //+@@@........@@@@@
    0x3f, 0xe0, 0x0b, 0xff, 0xc0,  //.@@@@%....%@@@@@@
    0x0f, 0xff, 0xff, 0xdf, 0xc0,  //..@@@@@@@@@@@+@@@
    0x03, 0xff, 0xff, 0x4f, 0xc0,  //...@@@@@@@@@+.@@@
    0x00, 0x6f, 0xf8, 0x1f, 0xc0,  //....+%@@@@%..+@@@
    0x00, 0x00, 0x00, 0x2f, 0x80,  //.............%@@%
    0x00, 0x00, 0x00, 0x3f, 0x40,  //.............@@@+
    0x00, 0x00, 0x00, 0x7f, 0x00,  //............+@@@.
    0x00, 0x00, 0x00, 0xfe, 0x00,  //............@@@%.
    0x00, 0x00, 0x02, 0xfc, 0x00,  //...........%@@@..
    0x0e, 0x40, 0x1f, 0xf4, 0x00,  //..@%+....+@@@@+..
    0x0f, 0xff, 0xff, 0xd0, 0x00,  //..@@@@@@@@@@@+...
    0x0f, 0xff, 0xff, 0x40, 0x00,  //..@@@@@@@@@@+....
    0x01, 0xbf, 0xe4, 0x00, 0x00,  //...+%@@@@%+......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+003a (:) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+003b (;) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x3f,  //.@@@
    0x3f,  //.@@@
    0x3f,  //.@@@
    0x3f,  //.@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x3f,  //.@@@
    0x3f,  //.@@@
    0x3f,  //.@@@
    0x3e,  //.@@%
    0x7d,  //+@@+
    0xbc,  //%@@.
    0xb8,  //%@%.
    0xf0,  //@@..
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+003c (<) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x01, 0xc0,  //...................+@
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xc0,  //................+%@@@
    0x00, 0x00, 0x00, 0x1b, 0xff, 0xc0,  //.............+%@@@@@@
    0x00, 0x00, 0x02, 0xff, 0xfe, 0x40,  //...........%@@@@@@@%+
    0x00, 0x00, 0x7f, 0xff, 0xd0, 0x00,  //........+@@@@@@@@+...
    0x00, 0x1b, 0xff, 0xf8, 0x00, 0x00,  //.....+%@@@@@@@%......
    0x06, 0xff, 0xfe, 0x40, 0x00, 0x00,  //..+%@@@@@@@%+........
    0xbf, 0xff, 0x90, 0x00, 0x00, 0x00,  //%@@@@@@@%+...........
    0xff, 0xf4, 0x00, 0x00, 0x00, 0x00,  //@@@@@@+..............
    0xff, 0xf4, 0x00, 0x00, 0x00, 0x00,  //@@@@@@+..............
    0xbf, 0xff, 0x90, 0x00, 0x00, 0x00,  //%@@@@@@@%+...........
    0x06, 0xff, 0xfe, 0x40, 0x00, 0x00,  //..+%@@@@@@@%+........
    0x00, 0x1b, 0xff, 0xf8, 0x00, 0x00,  //.....+%@@@@@@@%......
    0x00, 0x00, 0x7f, 0xff, 0xd0, 0x00,  //........+@@@@@@@@+...
    0x00, 0x00, 0x02, 0xff, 0xfe, 0x40,  //...........%@@@@@@@%+
    0x00, 0x00, 0x00, 0x1b, 0xff, 0xc0,  //.............+%@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xc0,  //................+%@@@
    0x00, 0x00, 0x00, 0x00, 0x01, 0xc0,  //...................+@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+003d (=) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+003e (>) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+...................
    0xfe, 0x40, 0x00, 0x00, 0x00, 0x00,  //@@@%+................
    0xff, 0xf9, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%+.............
    0x6f, 0xff, 0xe0, 0x00, 0x00, 0x00,  //+%@@@@@@@%...........
    0x01, 0xff, 0xff, 0x40, 0x00, 0x00,  //...+@@@@@@@@+........
    0x00, 0x0b, 0xff, 0xf9, 0x00, 0x00,  //......%@@@@@@@%+.....
    0x00, 0x00, 0x6f, 0xff, 0xe4, 0x00,  //........+%@@@@@@@%+..
    0x00, 0x00, 0x01, 0xbf, 0xff, 0x80,  //...........+%@@@@@@@%
    0x00, 0x00, 0x00, 0x07, 0xff, 0xc0,  //..............+@@@@@@
    0x00, 0x00, 0x00, 0x07, 0xff, 0xc0,  //..............+@@@@@@
    0x00, 0x00, 0x01, 0xbf, 0xff, 0x80,  //...........+%@@@@@@@%
    0x00, 0x00, 0x6f, 0xff, 0xe4, 0x00,  //........+%@@@@@@@%+..
    0x00, 0x0b, 0xff, 0xf9, 0x00, 0x00,  //......%@@@@@@@%+.....
    0x01, 0xff, 0xff, 0x40, 0x00, 0x00,  //...+@@@@@@@@+........
    0x6f, 0xff, 0xe0, 0x00, 0x00, 0x00,  //+%@@@@@@@%...........
    0xff, 0xf9, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%+.............
    0xfe, 0x40, 0x00, 0x00, 0x00, 0x00,  //@@@%+................
    0xd0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+003f (?) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x06, 0xff, 0x90, 0x00,  //...%@@@@%+...
    0x7f, 0xff, 0xfc, 0x00,  //+@@@@@@@@@@..
    0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@.
    0xfd, 0x00, 0xbf, 0x40,  //@@@+....%@@@+
    0x80, 0x00, 0x2f, 0xc0,  //%........%@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x1f, 0xc0,  //.........+@@@
    0x00, 0x00, 0x3f, 0x40,  //.........@@@+
    0x00, 0x01, 0xff, 0x00,  //.......+@@@@.
    0x00, 0x07, 0xfc, 0x00,  //......+@@@@..
    0x00, 0x0f, 0xf0, 0x00,  //......@@@@...
    0x00, 0x3f, 0xc0, 0x00,  //.....@@@@....
    0x00, 0xbf, 0x00, 0x00,  //....%@@@.....
    0x00, 0xfd, 0x00, 0x00,  //....@@@+.....
    0x00, 0xfc, 0x00, 0x00,  //....@@@......
    0x00, 0xfc, 0x00, 0x00,  //....@@@......
    0x00, 0xfc, 0x00, 0x00,  //....@@@......
    0x00, 0xfc, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0xfc, 0x00, 0x00,  //....@@@......
    0x00, 0xfc, 0x00, 0x00,  //....@@@......
    0x00, 0xfc, 0x00, 0x00,  //....@@@......
    0x00, 0xfc, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0040 (@) , Width: 30 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x01, 0xbf, 0xfa, 0x00, 0x00, 0x00,  //...........+%@@@@@%%..........
    0x00, 0x00, 0x7f, 0xff, 0xff, 0xf4, 0x00, 0x00,  //........+@@@@@@@@@@@@@+.......
    0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00,  //......+@@@@@@@@@@@@@@@@@+.....
    0x00, 0x1f, 0xfe, 0x40, 0x06, 0xff, 0xe0, 0x00,  //.....+@@@@@%+.....+%@@@@@+....
    0x00, 0xbf, 0xd0, 0x00, 0x00, 0x1f, 0xf8, 0x00,  //....%@@@@+...........+@@@@%...
    0x02, 0xfe, 0x00, 0x00, 0x00, 0x02, 0xfd, 0x00,  //...+@@@%...............%@@@+..
    0x07, 0xf8, 0x00, 0x00, 0x00, 0x00, 0xbf, 0x00,  //..+@@@%.................%@@@..
    0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x80,  //..@@@%...................%@@%.
    0x1f, 0xc0, 0x01, 0xff, 0x43, 0xf0, 0x0f, 0xc0,  //.+@@@......+@@@@+..@@@....@@@.
    0x3f, 0x40, 0x0f, 0xff, 0xe3, 0xf0, 0x0b, 0xd0,  //.@@@+.....@@@@@@@%.@@@....%@@+
    0x7f, 0x00, 0x2f, 0xff, 0xfb, 0xf0, 0x07, 0xf0,  //+@@@.....%@@@@@@@@%@@@....+@@%
    0xbe, 0x00, 0x7f, 0x80, 0x3f, 0xf0, 0x03, 0xf0,  //%@@%....+@@@%....%@@@@.....@@@
    0xfd, 0x00, 0xbe, 0x00, 0x0f, 0xf0, 0x03, 0xf0,  //@@@+....%@@%......%@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@........@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0x03, 0xf0, 0x03, 0xf0,  //@@@.....@@@........@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0x03, 0xf0, 0x07, 0xe0,  //@@@.....@@@........@@@....+@@%
    0xfc, 0x00, 0xfc, 0x00, 0x03, 0xf0, 0x0f, 0xc0,  //@@@.....@@@........@@@....@@@.
    0xfd, 0x00, 0xbe, 0x00, 0x0b, 0xf0, 0x3f, 0x80,  //@@@+....%@@%......%@@@...@@@%.
    0xbe, 0x00, 0x7f, 0x80, 0x2f, 0xf1, 0xff, 0x00,  //%@@%....+@@@%....%@@@@.+@@@@..
    0x7f, 0x00, 0x2f, 0xff, 0xfb, 0xff, 0xfc, 0x00,  //+@@@.....%@@@@@@@@%@@@@@@@@...
    0x3f, 0x40, 0x0f, 0xff, 0xe3, 0xff, 0xd0, 0x00,  //.@@@+.....@@@@@@@%.@@@@@@+....
    0x2f, 0xc0, 0x01, 0xff, 0x43, 0xf9, 0x00, 0x00,  //.%@@@......+@@@@+..@@@%+......
    0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@%........................
    0x07, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@%.......................
    0x02, 0xfe, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,  //...%@@@%..............%+......
    0x00, 0xff, 0xd0, 0x00, 0x00, 0x7f, 0x00, 0x00,  //....@@@@@+..........+@@@......
    0x00, 0x2f, 0xfe, 0x40, 0x07, 0xff, 0x00, 0x00,  //.....%@@@@@%+.....+@@@@@......
    0x00, 0x07, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@%.......
    0x00, 0x00, 0xbf, 0xff, 0xff, 0x80, 0x00, 0x00,  //........%@@@@@@@@@@@%.........
    0x00, 0x00, 0x06, 0xff, 0xe4, 0x00, 0x00, 0x00,  //..........+%@@@@@%+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................


    /*Unicode: U+0041 (A) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x2f, 0xe0, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x7f, 0xf4, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0xff, 0xfc, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0xfc, 0xfc, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x02, 0xf8, 0xbe, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x03, 0xf4, 0x7f, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x07, 0xf0, 0x3f, 0x40, 0x00,  //......+@@@...@@@+......
    0x00, 0x0b, 0xe0, 0x2f, 0x80, 0x00,  //......%@@%...%@@%......
    0x00, 0x0f, 0xc0, 0x0f, 0xc0, 0x00,  //......@@@.....@@@......
    0x00, 0x1f, 0xc0, 0x0f, 0xd0, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x3f, 0x40, 0x07, 0xf0, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x3f, 0x00, 0x03, 0xf0, 0x00,  //.....@@@.......@@@.....
    0x00, 0xbe, 0x00, 0x02, 0xf8, 0x00,  //....%@@%.......%@@%....
    0x00, 0xfc, 0x00, 0x00, 0xfc, 0x00,  //....@@@.........@@@....
    0x01, 0xfc, 0x00, 0x00, 0xfd, 0x00,  //...+@@@.........@@@+...
    0x02, 0xff, 0xff, 0xff, 0xfe, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x03, 0xff, 0xff, 0xff, 0xff, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x0b, 0xff, 0xff, 0xff, 0xff, 0x80,  //..%@@@@@@@@@@@@@@@@@%..
    0x0f, 0xd0, 0x00, 0x00, 0x1f, 0xc0,  //..@@@+...........+@@@..
    0x1f, 0xc0, 0x00, 0x00, 0x0f, 0xd0,  //.+@@@.............@@@+.
    0x2f, 0x80, 0x00, 0x00, 0x0b, 0xe0,  //.%@@%.............%@@%.
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x7f, 0x00, 0x00, 0x00, 0x03, 0xf4,  //+@@@...............@@@+
    0xfd, 0x00, 0x00, 0x00, 0x01, 0xfc,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0042 (B) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0xfe, 0x80, 0x00,  //@@@@@@@@@@@%%.....
    0xff, 0xff, 0xff, 0xf8, 0x00,  //@@@@@@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@..
    0xfc, 0x00, 0x01, 0xff, 0x40,  //@@@........+@@@@+.
    0xfc, 0x00, 0x00, 0x2f, 0xc0,  //@@@..........%@@@.
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@.
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@.
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@.
    0xfc, 0x00, 0x00, 0x2f, 0x80,  //@@@..........%@@%.
    0xfc, 0x00, 0x01, 0xff, 0x00,  //@@@........+@@@@..
    0xff, 0xff, 0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0xff, 0xe0, 0x00,  //@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xfe, 0x00,  //@@@@@@@@@@@@@@@%..
    0xfc, 0x00, 0x01, 0xbf, 0x80,  //@@@.........%@@@%.
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@.
    0xfc, 0x00, 0x00, 0x07, 0xe0,  //@@@...........+@@%
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x07, 0xf0,  //@@@...........+@@@
    0xfc, 0x00, 0x00, 0x0f, 0xe0,  //@@@...........@@@%
    0xfc, 0x00, 0x01, 0xbf, 0xc0,  //@@@.........%@@@@.
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0x90, 0x00,  //@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0043 (C) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x01, 0xbf, 0xfe, 0x40,  //.......+%@@@@@@%+...
    0x00, 0x1f, 0xff, 0xff, 0xf8,  //.....+@@@@@@@@@@@@%.
    0x00, 0xbf, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x03, 0xff, 0x90, 0x06, 0xff,  //...@@@@@%+....+%@@@@
    0x0b, 0xf8, 0x00, 0x00, 0x1f,  //..%@@@+..........+@@
    0x1f, 0xd0, 0x00, 0x00, 0x02,  //.+@@@+.............%
    0x3f, 0x80, 0x00, 0x00, 0x00,  //.@@@%...............
    0x3f, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x7e, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0xbd, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xbd, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0x7e, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0x3f, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x3f, 0x80, 0x00, 0x00, 0x00,  //.@@@%...............
    0x1f, 0xd0, 0x00, 0x00, 0x02,  //.+@@@+.............%
    0x0b, 0xf4, 0x00, 0x00, 0x1f,  //..%@@@+..........+@@
    0x03, 0xff, 0x90, 0x06, 0xff,  //...@@@@@%+....+%@@@@
    0x00, 0xbf, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x00, 0x1f, 0xff, 0xff, 0xf8,  //.....+@@@@@@@@@@@@%.
    0x00, 0x01, 0xbf, 0xfe, 0x40,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+0044 (D) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xfa, 0x40, 0x00, 0x00,  //@@@@@@@@@@%%+........
    0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //@@@@@@@@@@@@@@%+.....
    0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //@@@@@@@@@@@@@@@@%....
    0xfc, 0x00, 0x05, 0xbf, 0xf0, 0x00,  //@@@........+%@@@@@...
    0xfc, 0x00, 0x00, 0x0b, 0xfc, 0x00,  //@@@...........%@@@@..
    0xfc, 0x00, 0x00, 0x01, 0xfd, 0x00,  //@@@............+@@@+.
    0xfc, 0x00, 0x00, 0x00, 0xbf, 0x00,  //@@@.............%@@@.
    0xfc, 0x00, 0x00, 0x00, 0x3f, 0x40,  //@@@..............@@@+
    0xfc, 0x00, 0x00, 0x00, 0x2f, 0x80,  //@@@..............%@@%
    0xfc, 0x00, 0x00, 0x00, 0x1f, 0xc0,  //@@@..............+@@@
    0xfc, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //@@@...............@@@
    0xfc, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //@@@...............@@@
    0xfc, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //@@@...............@@@
    0xfc, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //@@@...............@@@
    0xfc, 0x00, 0x00, 0x00, 0x0f, 0xc0,  //@@@...............@@@
    0xfc, 0x00, 0x00, 0x00, 0x1f, 0xc0,  //@@@..............+@@%
    0xfc, 0x00, 0x00, 0x00, 0x2f, 0x80,  //@@@..............%@@%
    0xfc, 0x00, 0x00, 0x00, 0x3f, 0x40,  //@@@..............@@@+
    0xfc, 0x00, 0x00, 0x00, 0xbf, 0x00,  //@@@.............%@@@.
    0xfc, 0x00, 0x00, 0x01, 0xfd, 0x00,  //@@@............+@@@+.
    0xfc, 0x00, 0x00, 0x0b, 0xfc, 0x00,  //@@@...........%@@@@..
    0xfc, 0x00, 0x01, 0xbf, 0xf0, 0x00,  //@@@........+%@@@@@...
    0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //@@@@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //@@@@@@@@@@@@@@%+.....
    0xff, 0xff, 0xfa, 0x40, 0x00, 0x00,  //@@@@@@@@@@%%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0045 (E) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@.
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0046 (F) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@.
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0047 (G) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0xaf, 0xfe, 0x90, 0x00,  //........+%@@@@@%%+....
    0x00, 0x1f, 0xff, 0xff, 0xfe, 0x00,  //.....+@@@@@@@@@@@@@%..
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xc0,  //....%@@@@@@@@@@@@@@@@.
    0x03, 0xff, 0x90, 0x01, 0xbf, 0xc0,  //...@@@@@%+.....+%@@@@.
    0x0b, 0xf4, 0x00, 0x00, 0x07, 0xc0,  //..%@@@+...........+@@.
    0x1f, 0xd0, 0x00, 0x00, 0x00, 0x80,  //.+@@@+..............%.
    0x3f, 0x80, 0x00, 0x00, 0x00, 0x00,  //.@@@+.................
    0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@..................
    0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%..................
    0xbd, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+..................
    0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...................
    0xfc, 0x00, 0x00, 0x0f, 0xff, 0xf0,  //@@@...........@@@@@@@@
    0xfc, 0x00, 0x00, 0x0f, 0xff, 0xf0,  //@@@...........@@@@@@@@
    0xfc, 0x00, 0x00, 0x0f, 0xff, 0xf0,  //@@@...........@@@@@@@@
    0xfc, 0x00, 0x00, 0x00, 0x03, 0xf0,  //@@@................@@@
    0xbd, 0x00, 0x00, 0x00, 0x03, 0xf0,  //%@@+...............@@@
    0x7e, 0x00, 0x00, 0x00, 0x03, 0xf0,  //+@@%...............@@@
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@
    0x3f, 0x80, 0x00, 0x00, 0x03, 0xf0,  //.@@@%..............@@@
    0x1f, 0xd0, 0x00, 0x00, 0x03, 0xf0,  //.+@@@+.............@@@
    0x0b, 0xf8, 0x00, 0x00, 0x03, 0xf0,  //..%@@@%............@@@
    0x03, 0xff, 0x90, 0x00, 0x6f, 0xf0,  //...@@@@@%+......+%@@@@
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xd0,  //....%@@@@@@@@@@@@@@@@+
    0x00, 0x1f, 0xff, 0xff, 0xfd, 0x00,  //.....+@@@@@@@@@@@@@+..
    0x00, 0x00, 0x6f, 0xfe, 0x90, 0x00,  //........+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+0048 (H) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0049 (I) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+004a (J) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x07, 0xe0,  //..+@@%
    0x0f, 0xd0,  //..@@@+
    0x2f, 0xc0,  //.%@@@.
    0xff, 0x80,  //@@@@%.
    0xfe, 0x00,  //@@@%..
    0xe4, 0x00,  //@%+...
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+004b (K) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0xfc, 0x00, 0x00, 0x0f, 0xf4,  //@@@...........@@@@+.
    0xfc, 0x00, 0x00, 0x3f, 0xd0,  //@@@..........@@@@+..
    0xfc, 0x00, 0x00, 0xff, 0x40,  //@@@.........@@@@+...
    0xfc, 0x00, 0x07, 0xfc, 0x00,  //@@@.......+@@@@.....
    0xfc, 0x00, 0x1f, 0xf0, 0x00,  //@@@......+@@@@......
    0xfc, 0x00, 0x7f, 0xc0, 0x00,  //@@@.....+@@@@.......
    0xfc, 0x02, 0xff, 0x00, 0x00,  //@@@....%@@@@........
    0xfc, 0x0b, 0xf8, 0x00, 0x00,  //@@@...%@@@%.........
    0xfc, 0x2f, 0xe0, 0x00, 0x00,  //@@@..%@@@%..........
    0xfc, 0xff, 0x80, 0x00, 0x00,  //@@@.@@@@%...........
    0xff, 0xfe, 0x00, 0x00, 0x00,  //@@@@@@@%............
    0xff, 0xf8, 0x00, 0x00, 0x00,  //@@@@@@%.............
    0xff, 0xfc, 0x00, 0x00, 0x00,  //@@@@@@@.............
    0xfc, 0xff, 0x00, 0x00, 0x00,  //@@@.@@@@............
    0xfc, 0x3f, 0xc0, 0x00, 0x00,  //@@@..@@@@...........
    0xfc, 0x0f, 0xf4, 0x00, 0x00,  //@@@...@@@@..........
    0xfc, 0x03, 0xfd, 0x00, 0x00,  //@@@....@@@@+........
    0xfc, 0x00, 0xff, 0x40, 0x00,  //@@@.....@@@@+.......
    0xfc, 0x00, 0x3f, 0xd0, 0x00,  //@@@......@@@@+......
    0xfc, 0x00, 0x0f, 0xf4, 0x00,  //@@@.......@@@@+.....
    0xfc, 0x00, 0x03, 0xfd, 0x00,  //@@@........@@@@+....
    0xfc, 0x00, 0x00, 0xff, 0x40,  //@@@.........@@@@+...
    0xfc, 0x00, 0x00, 0x3f, 0xd0,  //@@@..........@@@@+..
    0xfc, 0x00, 0x00, 0x0f, 0xf4,  //@@@...........@@@@+.
    0xfc, 0x00, 0x00, 0x03, 0xfd,  //@@@............@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+004c (L) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+004d (M) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xff, 0xc0, 0x00, 0x00, 0x0f, 0xfc,  //@@@@@.............@@@@@
    0xff, 0xe0, 0x00, 0x00, 0x2f, 0xfc,  //@@@@@%...........%@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x3f, 0xfc,  //@@@@@@...........@@@@@@
    0xff, 0xf4, 0x00, 0x00, 0x7f, 0xfc,  //@@@@@@+.........+@@@@@@
    0xfd, 0xfc, 0x00, 0x00, 0xfd, 0xfc,  //@@@+@@@.........@@@+@@@
    0xfc, 0xfc, 0x00, 0x00, 0xfc, 0xfc,  //@@@.@@@.........@@@.@@@
    0xfc, 0xbe, 0x00, 0x02, 0xf8, 0xfc,  //@@@.%@@%.......%@@%.@@@
    0xfc, 0x3f, 0x00, 0x03, 0xf0, 0xfc,  //@@@..@@@.......@@@..@@@
    0xfc, 0x3f, 0x40, 0x07, 0xf0, 0xfc,  //@@@..@@@+.....+@@@..@@@
    0xfc, 0x1f, 0xc0, 0x0f, 0xd0, 0xfc,  //@@@..+@@@.....@@@+..@@@
    0xfc, 0x0f, 0xc0, 0x0f, 0xc0, 0xfc,  //@@@...@@@.....@@@...@@@
    0xfc, 0x0b, 0xe0, 0x2f, 0x80, 0xfc,  //@@@...%@@%...%@@%...@@@
    0xfc, 0x03, 0xf0, 0x3f, 0x00, 0xfc,  //@@@....@@@...@@@....@@@
    0xfc, 0x03, 0xf4, 0x7f, 0x00, 0xfc,  //@@@....@@@+.+@@@....@@@
    0xfc, 0x01, 0xfc, 0xfd, 0x00, 0xfc,  //@@@....+@@@.@@@+....@@@
    0xfc, 0x00, 0xfd, 0xfc, 0x00, 0xfc,  //@@@.....@@@+@@@.....@@@
    0xfc, 0x00, 0xbf, 0xf8, 0x00, 0xfc,  //@@@.....%@@@@@%.....@@@
    0xfc, 0x00, 0x7f, 0xf4, 0x00, 0xfc,  //@@@......@@@@@......@@@
    0xfc, 0x00, 0x3f, 0xf0, 0x00, 0xfc,  //@@@......@@@@@......@@@
    0xfc, 0x00, 0x1f, 0xd0, 0x00, 0xfc,  //@@@......+@@@+......@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+004e (N) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0x80, 0x00, 0x00, 0xfc,  //@@@@%...........@@@
    0xff, 0xc0, 0x00, 0x00, 0xfc,  //@@@@@...........@@@
    0xff, 0xe0, 0x00, 0x00, 0xfc,  //@@@@@%..........@@@
    0xff, 0xf4, 0x00, 0x00, 0xfc,  //@@@@@@..........@@@
    0xfe, 0xfc, 0x00, 0x00, 0xfc,  //@@@%@@@.........@@@
    0xfc, 0xfd, 0x00, 0x00, 0xfc,  //@@@.@@@+........@@@
    0xfc, 0xbf, 0x00, 0x00, 0xfc,  //@@@.+@@@........@@@
    0xfc, 0x3f, 0x40, 0x00, 0xfc,  //@@@..@@@+.......@@@
    0xfc, 0x1f, 0xc0, 0x00, 0xfc,  //@@@..+@@@.......@@@
    0xfc, 0x0f, 0xe0, 0x00, 0xfc,  //@@@...@@@%......@@@
    0xfc, 0x07, 0xf0, 0x00, 0xfc,  //@@@...+@@@......@@@
    0xfc, 0x03, 0xf8, 0x00, 0xfc,  //@@@....%@@%.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xbe, 0x00, 0xfc,  //@@@.....%@@%....@@@
    0xfc, 0x00, 0x3f, 0x40, 0xfc,  //@@@......@@@+...@@@
    0xfc, 0x00, 0x2f, 0xc0, 0xfc,  //@@@......%@@@...@@@
    0xfc, 0x00, 0x0f, 0xd0, 0xfc,  //@@@.......@@@+..@@@
    0xfc, 0x00, 0x07, 0xf0, 0xfc,  //@@@.......+@@@..@@@
    0xfc, 0x00, 0x03, 0xf4, 0xfc,  //@@@........@@@+.@@@
    0xfc, 0x00, 0x01, 0xfc, 0xfc,  //@@@........+@@@.@@@
    0xfc, 0x00, 0x00, 0xfe, 0xfc,  //@@@.........@@@%@@@
    0xfc, 0x00, 0x00, 0x7f, 0xfc,  //@@@.........+@@@@@@
    0xfc, 0x00, 0x00, 0x2f, 0xfc,  //@@@..........%@@@@@
    0xfc, 0x00, 0x00, 0x0f, 0xfc,  //@@@...........@@@@@
    0xfc, 0x00, 0x00, 0x0b, 0xfc,  //@@@...........%@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+004f (O) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....%@@@@@@@@@@@@@@....
    0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //...@@@@@+.....+@@@@@...
    0x0b, 0xf8, 0x00, 0x00, 0xbf, 0x80,  //..%@@@%.........+@@@%..
    0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //.+@@@+...........+@@@+.
    0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%.............%@@@.
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x7e, 0x00, 0x00, 0x00, 0x02, 0xf4,  //+@@%...............%@@+
    0xbd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //%@@+...............+@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xbd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //%@@+...............+@@%
    0x7e, 0x00, 0x00, 0x00, 0x02, 0xf4,  //+@@%...............%@@+
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%.............%@@@.
    0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //.+@@@+...........+@@@+.
    0x0b, 0xf8, 0x00, 0x00, 0x7f, 0x80,  //..%@@@+.........+@@@%..
    0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0050 (P) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xf9, 0x00,  //@@@@@@@@@@%+....
    0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@@+.
    0xfc, 0x00, 0x0b, 0xfc,  //@@@.......%@@@@.
    0xfc, 0x00, 0x00, 0xfe,  //@@@.........@@@%
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfc, 0x00, 0x00, 0xfe,  //@@@.........@@@%
    0xfc, 0x00, 0x0b, 0xfc,  //@@@.......%@@@@.
    0xff, 0xff, 0xff, 0xf4,  //@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xf9, 0x00,  //@@@@@@@@@@%+....
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0051 (Q) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x01, 0xbf, 0xf9, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0xff, 0xff, 0xff, 0xfc, 0x00,  //....%@@@@@@@@@@@@@@....
    0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //...@@@@@+.....+@@@@@...
    0x0b, 0xf8, 0x00, 0x00, 0xbf, 0x80,  //..%@@@%.........+@@@%..
    0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //.+@@@+...........+@@@+.
    0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%.............%@@@.
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x7e, 0x00, 0x00, 0x00, 0x02, 0xf4,  //+@@%...............%@@+
    0xbd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //%@@+...............+@@%
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xfc, 0x00, 0x00, 0x00, 0x00, 0xfc,  //@@@.................@@@
    0xbd, 0x00, 0x00, 0x00, 0x01, 0xf8,  //%@@+...............+@@%
    0x7e, 0x00, 0x00, 0x00, 0x02, 0xf8,  //+@@%...............%@@%
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x3f, 0x80, 0x00, 0x00, 0x0b, 0xf0,  //.@@@%.............%@@@.
    0x1f, 0xd0, 0x00, 0x00, 0x1f, 0xd0,  //.+@@@+...........+@@@+.
    0x0b, 0xf8, 0x00, 0x00, 0x7f, 0x80,  //..%@@@+.........+@@@%..
    0x03, 0xff, 0x40, 0x07, 0xff, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0xbf, 0xff, 0xff, 0xfc, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x1f, 0xff, 0xff, 0xd0, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x01, 0xbf, 0xff, 0xc0, 0x00,  //.......+%@@@@@@@@......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //..............@@@@.....
    0x00, 0x00, 0x00, 0x03, 0xfc, 0x00,  //...............@@@%....
    0x00, 0x00, 0x00, 0x01, 0xfe, 0x00,  //...............+@@@%...
    0x00, 0x00, 0x00, 0x00, 0x7f, 0x80,  //................+@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0052 (R) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xf9, 0x00, 0x00,  //@@@@@@@@@@%+.......
    0xff, 0xff, 0xff, 0xe0, 0x00,  //@@@@@@@@@@@@@%.....
    0xff, 0xff, 0xff, 0xf8, 0x00,  //@@@@@@@@@@@@@@%....
    0xfc, 0x00, 0x07, 0xfd, 0x00,  //@@@.......+@@@@+...
    0xfc, 0x00, 0x00, 0xfe, 0x00,  //@@@.........@@@%...
    0xfc, 0x00, 0x00, 0x7f, 0x00,  //@@@.........+@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x7f, 0x00,  //@@@.........+@@@...
    0xfc, 0x00, 0x00, 0xfe, 0x00,  //@@@.........@@@%...
    0xfc, 0x00, 0x07, 0xfc, 0x00,  //@@@.......+@@@@....
    0xff, 0xff, 0xff, 0xf4, 0x00,  //@@@@@@@@@@@@@@+....
    0xff, 0xff, 0xff, 0x80, 0x00,  //@@@@@@@@@@@@%......
    0xff, 0xff, 0xff, 0xd0, 0x00,  //@@@@@@@@@@@@@+.....
    0xfc, 0x00, 0x1f, 0xf0, 0x00,  //@@@......+@@@@.....
    0xfc, 0x00, 0x03, 0xf8, 0x00,  //@@@........@@@%....
    0xfc, 0x00, 0x00, 0xfd, 0x00,  //@@@.........@@@+...
    0xfc, 0x00, 0x00, 0xbe, 0x00,  //@@@.........%@@%...
    0xfc, 0x00, 0x00, 0x3f, 0x00,  //@@@..........@@@...
    0xfc, 0x00, 0x00, 0x2f, 0x80,  //@@@..........%@@%..
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@..
    0xfc, 0x00, 0x00, 0x0f, 0xd0,  //@@@...........@@@+.
    0xfc, 0x00, 0x00, 0x07, 0xf0,  //@@@...........+@@@.
    0xfc, 0x00, 0x00, 0x03, 0xf4,  //@@@............@@@+
    0xfc, 0x00, 0x00, 0x01, 0xfc,  //@@@............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0053 (S) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x6f, 0xff, 0xa4, 0x00,  //....+%@@@@@@%%+..
    0x07, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x1f, 0xff, 0xff, 0xff, 0x00,  //.+@@@@@@@@@@@@@@.
    0x3f, 0xe0, 0x00, 0x5b, 0x00,  //.@@@@%......++%@.
    0xbf, 0x00, 0x00, 0x00, 0x00,  //%@@@.............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfe, 0x00, 0x00, 0x00, 0x00,  //@@@%.............
    0x7f, 0x80, 0x00, 0x00, 0x00,  //+@@@%............
    0x3f, 0xfe, 0x90, 0x00, 0x00,  //.@@@@@@%%+.......
    0x0b, 0xff, 0xff, 0x80, 0x00,  //..%@@@@@@@@@%....
    0x00, 0xbf, 0xff, 0xf4, 0x00,  //....%@@@@@@@@@+..
    0x00, 0x01, 0xaf, 0xfe, 0x00,  //.......+%%@@@@@%.
    0x00, 0x00, 0x01, 0xff, 0x00,  //...........+@@@@.
    0x00, 0x00, 0x00, 0x3f, 0x80,  //.............@@@%
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x1f, 0xc0,  //.............+@@@
    0xd0, 0x00, 0x00, 0x3f, 0x80,  //@+...........@@@%
    0xfe, 0x40, 0x06, 0xff, 0x00,  //@@@%+.....+%@@@@.
    0xff, 0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xf0, 0x00,  //@@@@@@@@@@@@@@...
    0x1a, 0xff, 0xfe, 0x40, 0x00,  //.++%@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0054 (T) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0055 (U) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfc, 0x00, 0x00, 0x00, 0xfc,  //@@@.............@@@
    0xfd, 0x00, 0x00, 0x01, 0xfc,  //@@@+...........+@@@
    0xbe, 0x00, 0x00, 0x02, 0xf8,  //%@@%...........%@@%
    0x7f, 0x00, 0x00, 0x03, 0xf4,  //+@@@...........@@@+
    0x3f, 0x80, 0x00, 0x0b, 0xf0,  //.@@@%.........%@@@.
    0x1f, 0xf4, 0x00, 0x7f, 0xd0,  //.+@@@@+.....+@@@@+.
    0x0b, 0xff, 0xff, 0xff, 0x80,  //..%@@@@@@@@@@@@@%..
    0x01, 0xff, 0xff, 0xfd, 0x00,  //...+@@@@@@@@@@@+...
    0x00, 0x1b, 0xff, 0x90, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0056 (V) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xfd, 0x00, 0x00, 0x00, 0x01, 0xfc,  //@@@+...............+@@@
    0x7f, 0x00, 0x00, 0x00, 0x03, 0xf4,  //+@@@...............@@@+
    0x3f, 0x00, 0x00, 0x00, 0x03, 0xf0,  //.@@@...............@@@.
    0x2f, 0x80, 0x00, 0x00, 0x0b, 0xe0,  //.%@@%.............%@@%.
    0x1f, 0xc0, 0x00, 0x00, 0x0f, 0xd0,  //.+@@@.............@@@+.
    0x0f, 0xd0, 0x00, 0x00, 0x1f, 0xc0,  //..@@@+...........+@@@..
    0x0b, 0xe0, 0x00, 0x00, 0x2f, 0x80,  //..%@@%...........%@@%..
    0x03, 0xf0, 0x00, 0x00, 0x3f, 0x00,  //...@@@...........@@@...
    0x02, 0xf4, 0x00, 0x00, 0x7e, 0x00,  //...%@@+.........+@@%...
    0x01, 0xfc, 0x00, 0x00, 0xfd, 0x00,  //...+@@@.........@@@+...
    0x00, 0xfc, 0x00, 0x00, 0xfc, 0x00,  //....@@@.........@@@....
    0x00, 0xbe, 0x00, 0x02, 0xf8, 0x00,  //....%@@%.......%@@%....
    0x00, 0x3f, 0x00, 0x03, 0xf0, 0x00,  //.....@@@.......@@@.....
    0x00, 0x3f, 0x40, 0x07, 0xf0, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x1f, 0xc0, 0x0f, 0xd0, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x0f, 0xc0, 0x0f, 0xc0, 0x00,  //......@@@.....@@@......
    0x00, 0x0b, 0xe0, 0x2f, 0x80, 0x00,  //......%@@%...%@@%......
    0x00, 0x07, 0xf0, 0x3f, 0x40, 0x00,  //......+@@@...@@@+......
    0x00, 0x03, 0xf4, 0x7f, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x02, 0xf8, 0xbe, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0xfc, 0xfc, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0xff, 0xfc, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x7f, 0xf4, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x2f, 0xe0, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0057 (W) , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0xfc, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0xfc,  //@@@..........@@@@@..........@@@
    0xbd, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x01, 0xf8,  //%@@+.........@@@@@.........+@@%
    0x7e, 0x00, 0x00, 0x7f, 0xf4, 0x00, 0x02, 0xf4,  //+@@%........+@@@@@+........%@@+
    0x3f, 0x00, 0x00, 0xbf, 0xf8, 0x00, 0x03, 0xf0,  //.@@@........%@@@@@%........@@@.
    0x3f, 0x00, 0x00, 0xfd, 0xfc, 0x00, 0x03, 0xf0,  //.@@@........@@@+@@@........@@@.
    0x2f, 0x40, 0x00, 0xfc, 0xfc, 0x00, 0x07, 0xe0,  //.%@@+.......@@@.@@@.......+@@%.
    0x1f, 0x80, 0x01, 0xf8, 0xbd, 0x00, 0x0b, 0xd0,  //.+@@%......+@@%.%@@+......%@@+.
    0x0f, 0xc0, 0x02, 0xf8, 0x7e, 0x00, 0x0f, 0xc0,  //..@@@......%@@+.+@@%......@@@..
    0x0f, 0xc0, 0x03, 0xf4, 0x3f, 0x00, 0x0f, 0xc0,  //..@@@......@@@+..@@@......@@@..
    0x0b, 0xd0, 0x03, 0xf0, 0x3f, 0x00, 0x1f, 0x80,  //..%@@+.....@@@...@@@.....+@@%..
    0x07, 0xe0, 0x07, 0xf0, 0x3f, 0x40, 0x2f, 0x40,  //..+@@%....+@@@...@@@+....%@@+..
    0x03, 0xf0, 0x0b, 0xe0, 0x2f, 0x80, 0x3f, 0x00,  //...@@@....%@@%...%@@%....@@@...
    0x03, 0xf0, 0x0f, 0xd0, 0x1f, 0xc0, 0x3f, 0x00,  //...@@@....@@@+...+@@@....@@@...
    0x02, 0xf4, 0x0f, 0xc0, 0x0f, 0xc0, 0x7e, 0x00,  //...%@@+...@@@.....@@@...+@@%...
    0x01, 0xf8, 0x1f, 0xc0, 0x0f, 0xd0, 0xbd, 0x00,  //...+@@%...@@@.....@@@+..%@@+...
    0x00, 0xfc, 0x1f, 0x80, 0x0b, 0xe0, 0xfc, 0x00,  //....@@@..+@@%.....%@@+..@@@....
    0x00, 0xfc, 0x2f, 0x40, 0x07, 0xe0, 0xfc, 0x00,  //....@@@..%@@+.....+@@%..@@@....
    0x00, 0xbd, 0x3f, 0x00, 0x03, 0xf1, 0xf8, 0x00,  //....%@@+.@@@.......@@@.+@@%....
    0x00, 0x7e, 0x3f, 0x00, 0x03, 0xf2, 0xf4, 0x00,  //....+@@%.@@@.......@@@.%@@+....
    0x00, 0x3f, 0x7e, 0x00, 0x02, 0xf7, 0xf0, 0x00,  //.....@@@+@@%.......%@@+@@@.....
    0x00, 0x3f, 0xfd, 0x00, 0x01, 0xff, 0xf0, 0x00,  //.....@@@@@@+.......+@@@@@@.....
    0x00, 0x2f, 0xfc, 0x00, 0x00, 0xff, 0xe0, 0x00,  //.....%@@@@@.........@@@@@%.....
    0x00, 0x1f, 0xfc, 0x00, 0x00, 0xff, 0xd0, 0x00,  //.....+@@@@@.........@@@@@+.....
    0x00, 0x0f, 0xf8, 0x00, 0x00, 0xbf, 0xc0, 0x00,  //......@@@@%.........%@@@@......
    0x00, 0x0f, 0xf4, 0x00, 0x00, 0x7f, 0xc0, 0x00,  //......@@@@+.........+@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+0058 (X) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x2f, 0xc0, 0x00, 0x00, 0xfe, 0x00,  //.%@@@...........@@@%.
    0x0f, 0xe0, 0x00, 0x02, 0xfc, 0x00,  //..@@@%.........%@@@..
    0x07, 0xf0, 0x00, 0x03, 0xf4, 0x00,  //..+@@@.........@@@+..
    0x02, 0xfc, 0x00, 0x0f, 0xe0, 0x00,  //...%@@@.......@@@%...
    0x00, 0xfe, 0x00, 0x2f, 0xc0, 0x00,  //....@@@%.....%@@@....
    0x00, 0x7f, 0x00, 0x3f, 0x40, 0x00,  //....+@@@.....@@@+....
    0x00, 0x2f, 0xc0, 0xfe, 0x00, 0x00,  //.....%@@@...@@@%.....
    0x00, 0x0f, 0xe2, 0xfc, 0x00, 0x00,  //......@@@%.%@@@......
    0x00, 0x07, 0xf7, 0xf4, 0x00, 0x00,  //......+@@@+@@@+......
    0x00, 0x03, 0xff, 0xf0, 0x00, 0x00,  //.......@@@@@@%.......
    0x00, 0x00, 0xff, 0xc0, 0x00, 0x00,  //........@@@@@........
    0x00, 0x00, 0xbf, 0x40, 0x00, 0x00,  //........%@@@+........
    0x00, 0x00, 0xff, 0xc0, 0x00, 0x00,  //........@@@@@........
    0x00, 0x01, 0xff, 0xd0, 0x00, 0x00,  //.......+@@@@@+.......
    0x00, 0x03, 0xff, 0xf0, 0x00, 0x00,  //.......@@@@@@@.......
    0x00, 0x0f, 0xf3, 0xfc, 0x00, 0x00,  //......@@@@.@@@%......
    0x00, 0x1f, 0xc0, 0xfd, 0x00, 0x00,  //.....+@@@...@@@+.....
    0x00, 0x3f, 0x40, 0xbf, 0x00, 0x00,  //.....@@@+...%@@@.....
    0x00, 0xbf, 0x00, 0x3f, 0x80, 0x00,  //....%@@@.....@@@%....
    0x01, 0xfc, 0x00, 0x0f, 0xd0, 0x00,  //...+@@@.......@@@+...
    0x03, 0xf8, 0x00, 0x0b, 0xf0, 0x00,  //...@@@%.......%@@@...
    0x0b, 0xf0, 0x00, 0x03, 0xf8, 0x00,  //..%@@@.........@@@%..
    0x1f, 0xc0, 0x00, 0x01, 0xfd, 0x00,  //.+@@@..........+@@@+.
    0x3f, 0x80, 0x00, 0x00, 0xbf, 0x00,  //.@@@%...........%@@@.
    0xbf, 0x00, 0x00, 0x00, 0x3f, 0x80,  //%@@@.............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0059 (Y) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xbf, 0x00, 0x00, 0x00, 0x3f, 0x80,  //%@@@.............@@@%
    0x3f, 0x80, 0x00, 0x00, 0xbf, 0x00,  //.@@@%...........%@@@.
    0x1f, 0xd0, 0x00, 0x01, 0xfd, 0x00,  //.+@@@+.........+@@@+.
    0x0b, 0xf0, 0x00, 0x03, 0xf8, 0x00,  //..%@@@.........@@@%..
    0x03, 0xf8, 0x00, 0x0b, 0xf0, 0x00,  //...@@@%.......%@@@...
    0x00, 0xfd, 0x00, 0x1f, 0xc0, 0x00,  //....@@@+.....+@@@....
    0x00, 0xbf, 0x00, 0x3f, 0x80, 0x00,  //....%@@@.....@@@%....
    0x00, 0x3f, 0xc0, 0xff, 0x00, 0x00,  //.....@@@@...@@@@.....
    0x00, 0x0f, 0xd1, 0xfc, 0x00, 0x00,  //......@@@+.+@@@......
    0x00, 0x07, 0xf7, 0xf4, 0x00, 0x00,  //......+@@@+@@@+......
    0x00, 0x03, 0xff, 0xf0, 0x00, 0x00,  //.......@@@@@@@.......
    0x00, 0x00, 0xff, 0xc0, 0x00, 0x00,  //........@@@@@........
    0x00, 0x00, 0x7f, 0x40, 0x00, 0x00,  //........+@@@+........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+005a (Z) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x0b, 0xf4,  //..............%@@@+.
    0x00, 0x00, 0x00, 0x1f, 0xe0,  //.............+@@@%..
    0x00, 0x00, 0x00, 0x3f, 0x80,  //.............@@@%...
    0x00, 0x00, 0x00, 0xff, 0x00,  //............@@@@....
    0x00, 0x00, 0x02, 0xfc, 0x00,  //...........%@@@.....
    0x00, 0x00, 0x07, 0xf4, 0x00,  //..........+@@@+.....
    0x00, 0x00, 0x0f, 0xe0, 0x00,  //..........@@@%......
    0x00, 0x00, 0x3f, 0xc0, 0x00,  //.........@@@@.......
    0x00, 0x00, 0xbf, 0x00, 0x00,  //........%@@@........
    0x00, 0x01, 0xfd, 0x00, 0x00,  //.......+@@@+........
    0x00, 0x03, 0xf8, 0x00, 0x00,  //.......@@@%.........
    0x00, 0x0f, 0xf0, 0x00, 0x00,  //......@@@@..........
    0x00, 0x2f, 0xc0, 0x00, 0x00,  //.....%@@@...........
    0x00, 0x7f, 0x40, 0x00, 0x00,  //....+@@@+...........
    0x00, 0xfe, 0x00, 0x00, 0x00,  //....@@@%............
    0x03, 0xfc, 0x00, 0x00, 0x00,  //...@@@@.............
    0x0b, 0xf0, 0x00, 0x00, 0x00,  //..%@@@..............
    0x2f, 0xd0, 0x00, 0x00, 0x00,  //.%@@@+..............
    0x7f, 0x40, 0x00, 0x00, 0x00,  //+@@@+...............
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+005b ([) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0xff, 0xfc,  //@@@@@@@
    0xff, 0xfc,  //@@@@@@@
    0xff, 0xfc,  //@@@@@@@
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xfc, 0x00,  //@@@....
    0xff, 0xfc,  //@@@@@@@
    0xff, 0xfc,  //@@@@@@@
    0xff, 0xfc,  //@@@@@@@
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+005c (\) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xfd, 0x00, 0x00,  //@@@+.......
    0xbe, 0x00, 0x00,  //%@@%.......
    0x7f, 0x00, 0x00,  //+@@@.......
    0x3f, 0x00, 0x00,  //.@@@.......
    0x2f, 0x40, 0x00,  //.%@@+......
    0x1f, 0x80, 0x00,  //.+@@%......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0b, 0xe0, 0x00,  //..%@@%.....
    0x07, 0xf0, 0x00,  //..+@@@.....
    0x03, 0xf0, 0x00,  //...@@@.....
    0x03, 0xf4, 0x00,  //...@@@+....
    0x01, 0xf8, 0x00,  //...+@@%....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xbd, 0x00,  //....%@@+...
    0x00, 0x7f, 0x00,  //....+@@@...
    0x00, 0x3f, 0x00,  //.....@@@...
    0x00, 0x3f, 0x40,  //.....@@@+..
    0x00, 0x2f, 0x80,  //.....+@@%..
    0x00, 0x0f, 0xc0,  //......@@@..
    0x00, 0x0f, 0xc0,  //......@@@..
    0x00, 0x0b, 0xd0,  //......%@@+.
    0x00, 0x07, 0xe0,  //......+@@%.
    0x00, 0x03, 0xf0,  //.......@@@.
    0x00, 0x03, 0xf4,  //.......@@@+
    0x00, 0x02, 0xf8,  //.......%@@%
    0x00, 0x00, 0xfc,  //........@@@
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+005d (]) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0xff, 0xfc,  //@@@@@@@
    0xff, 0xfc,  //@@@@@@@
    0xff, 0xfc,  //@@@@@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0x00, 0xfc,  //....@@@
    0xff, 0xfc,  //@@@@@@@
    0xff, 0xfc,  //@@@@@@@
    0xff, 0xfc,  //@@@@@@@
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+005e (^) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0xbf, 0x80, 0x00, 0x00,  //........%@@@%........
    0x00, 0x02, 0xff, 0xe0, 0x00, 0x00,  //.......%@@@@@%.......
    0x00, 0x0b, 0xff, 0xf8, 0x00, 0x00,  //......%@@@@@@@%......
    0x00, 0x2f, 0xe2, 0xfe, 0x00, 0x00,  //.....%@@@+.%@@@%.....
    0x00, 0xbf, 0x40, 0x7f, 0x80, 0x00,  //....%@@@+...+@@@%....
    0x02, 0xfd, 0x00, 0x1f, 0xe0, 0x00,  //...%@@@+.....+@@@%...
    0x0b, 0xf0, 0x00, 0x03, 0xf8, 0x00,  //..%@@@.........@@@%..
    0x2f, 0xc0, 0x00, 0x00, 0xfe, 0x00,  //.%@@@...........@@@%.
    0xbf, 0x00, 0x00, 0x00, 0x3f, 0x80,  //+@@@.............@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+005f (_) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0060 (`) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xbe, 0x00,  //%@@%....
    0x2f, 0x40,  //.%@@+...
    0x0b, 0xd0,  //..%@@+..
    0x03, 0xf0,  //...@@@..
    0x00, 0xfc,  //....@@@.
    0x00, 0x3e,  //.....@@%
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0061 (a) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0xaf, 0xf9, 0x00,  //....%%@@@@%+....
    0x1f, 0xff, 0xff, 0xc0,  //..%@@@@@@@@@@...
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@..
    0x3e, 0x40, 0x0b, 0xfc,  //.@@%+.....+@@@@.
    0x20, 0x00, 0x00, 0xfd,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x7e,  //............+@@%
    0x00, 0x00, 0x00, 0x3f,  //.............@@@
    0x00, 0x6f, 0xff, 0xff,  //....+%@@@@@@@@@@
    0x0b, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@
    0x3f, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x7f, 0x90, 0x00, 0x3f,  //+@@@%+.......@@@
    0xfe, 0x00, 0x00, 0x3f,  //@@@%.........@@@
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfc, 0x00, 0x00, 0xff,  //@@@.........@@@@
    0xfd, 0x00, 0x02, 0xff,  //@@@+.......%@@@@
    0xbf, 0x80, 0x1f, 0xff,  //%@@@%....+@@@@@@
    0x3f, 0xff, 0xff, 0xbf,  //.@@@@@@@@@@@%@@@
    0x0f, 0xff, 0xfe, 0x3f,  //..@@@@@@@@@+.@@@
    0x01, 0xff, 0xe0, 0x3f,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0062 (b) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x0b, 0xfe, 0x00, 0x00,  //@@@...%@@@@%.....
    0xfc, 0xbf, 0xff, 0xe0, 0x00,  //@@@.%@@@@@@@@%...
    0xfe, 0xff, 0xff, 0xf8, 0x00,  //@@@%@@@@@@@@@@%..
    0xff, 0xf4, 0x07, 0xfd, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0x80, 0x00, 0xbf, 0x00,  //@@@@%.......%@@@.
    0xff, 0x00, 0x00, 0x3f, 0x40,  //@@@@.........@@@+
    0xfd, 0x00, 0x00, 0x1f, 0x80,  //@@@+.........+@@%
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfd, 0x00, 0x00, 0x1f, 0x80,  //@@@+.........+@@%
    0xff, 0x00, 0x00, 0x3f, 0x40,  //@@@@.........@@@+
    0xff, 0x80, 0x00, 0xbf, 0x00,  //@@@@%.......%@@@.
    0xff, 0xf4, 0x07, 0xfd, 0x00,  //@@@@@@+...+@@@@+.
    0xfe, 0xff, 0xff, 0xf8, 0x00,  //@@@%@@@@@@@@@@%..
    0xfc, 0xbf, 0xff, 0xe0, 0x00,  //@@@.%@@@@@@@@%...
    0xfc, 0x0b, 0xfe, 0x00, 0x00,  //@@@...%@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0063 (c) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x1b, 0xff, 0x90,  //.....+%@@@@@%+.
    0x00, 0xff, 0xff, 0xfc,  //....@@@@@@@@@@@
    0x07, 0xff, 0xff, 0xfc,  //..+@@@@@@@@@@@@
    0x0f, 0xf9, 0x00, 0x6c,  //..@@@@%.....+%@
    0x3f, 0xc0, 0x00, 0x00,  //.@@@@..........
    0x7f, 0x00, 0x00, 0x00,  //+@@@...........
    0xbe, 0x00, 0x00, 0x00,  //%@@%...........
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xbe, 0x00, 0x00, 0x00,  //%@@%...........
    0x7f, 0x00, 0x00, 0x00,  //+@@@...........
    0x3f, 0xc0, 0x00, 0x00,  //.@@@@..........
    0x0f, 0xf8, 0x00, 0x6c,  //..@@@@%.....+%@
    0x07, 0xff, 0xff, 0xfc,  //..+@@@@@@@@@@@@
    0x01, 0xff, 0xff, 0xfc,  //....@@@@@@@@@@@
    0x00, 0x1b, 0xff, 0x90,  //.....+%@@@@@%+.
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0064 (d) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x2f, 0xf8, 0x0f, 0xc0,  //.....%@@@@%...@@@
    0x02, 0xff, 0xff, 0x8f, 0xc0,  //...%@@@@@@@@%.@@@
    0x0b, 0xff, 0xff, 0xef, 0xc0,  //..%@@@@@@@@@@%@@@
    0x1f, 0xf4, 0x07, 0xff, 0xc0,  //.+@@@@+...+@@@@@@
    0x3f, 0x80, 0x00, 0xbf, 0xc0,  //.@@@%.......%@@@@
    0x7f, 0x00, 0x00, 0x3f, 0xc0,  //+@@@.........@@@@
    0xbd, 0x00, 0x00, 0x1f, 0xc0,  //%@@+.........+@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xbd, 0x00, 0x00, 0x1f, 0xc0,  //%@@+.........+@@@
    0x7f, 0x00, 0x00, 0x3f, 0xc0,  //+@@@.........@@@@
    0x3f, 0x80, 0x00, 0xbf, 0xc0,  //.@@@%.......%@@@@
    0x1f, 0xf4, 0x07, 0xff, 0xc0,  //.+@@@@+...+@@@@@@
    0x0b, 0xff, 0xff, 0xef, 0xc0,  //..%@@@@@@@@@@%@@@
    0x02, 0xff, 0xff, 0x8f, 0xc0,  //...%@@@@@@@@%.@@@
    0x00, 0x2f, 0xf8, 0x0f, 0xc0,  //.....%@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0065 (e) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+....
    0x01, 0xff, 0xff, 0xf0, 0x00,  //...+@@@@@@@@@@...
    0x07, 0xff, 0xff, 0xfc, 0x00,  //..+@@@@@@@@@@@@..
    0x1f, 0xe4, 0x01, 0xff, 0x00,  //..@@@%+....+@@@@.
    0x3f, 0x40, 0x00, 0x3f, 0x40,  //.@@@+........@@@+
    0x7e, 0x00, 0x00, 0x1f, 0x80,  //+@@%.........+@@%
    0xbc, 0x00, 0x00, 0x0f, 0xc0,  //%@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xbe, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0x7f, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0x3f, 0xc0, 0x00, 0x02, 0x00,  //.@@@@..........%.
    0x1f, 0xf8, 0x00, 0x7f, 0x00,  //.+@@@@%.....+@@@.
    0x07, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x01, 0xff, 0xff, 0xfd, 0x00,  //...+@@@@@@@@@@@+.
    0x00, 0x1b, 0xff, 0x80, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0066 (f) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x1b, 0xff,  //.....+%@@@@@
    0x00, 0xbf, 0xff,  //....%@@@@@@@
    0x01, 0xff, 0xff,  //...+@@@@@@@@
    0x02, 0xf8, 0x00,  //...%@@%.....
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0x03, 0xf0, 0x00,  //...@@@......
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0067 (g) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x2f, 0xf8, 0x0f, 0xc0,  //.....%@@@@%...@@@
    0x02, 0xff, 0xff, 0x8f, 0xc0,  //...%@@@@@@@@%.@@@
    0x0b, 0xff, 0xff, 0xef, 0xc0,  //..%@@@@@@@@@@%@@@
    0x1f, 0xf4, 0x07, 0xff, 0xc0,  //.+@@@@+...+@@@@@@
    0x3f, 0x80, 0x00, 0xbf, 0xc0,  //.@@@%.......%@@@@
    0x7f, 0x00, 0x00, 0x3f, 0xc0,  //+@@@.........@@@@
    0xbd, 0x00, 0x00, 0x1f, 0xc0,  //%@@+.........+@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xbd, 0x00, 0x00, 0x1f, 0xc0,  //%@@+.........+@@@
    0x7f, 0x00, 0x00, 0x3f, 0xc0,  //+@@@.........@@@@
    0x3f, 0x80, 0x00, 0xbf, 0xc0,  //.@@@%.......%@@@@
    0x1f, 0xf4, 0x07, 0xff, 0xc0,  //.+@@@@+...+@@@@@@
    0x0b, 0xff, 0xff, 0xef, 0xc0,  //..%@@@@@@@@@@%@@@
    0x02, 0xff, 0xff, 0x8f, 0xc0,  //...%@@@@@@@@%.@@@
    0x00, 0x2f, 0xf8, 0x0f, 0xc0,  //.....%@@@@%...@@@
    0x00, 0x00, 0x00, 0x1f, 0x80,  //.............+@@%
    0x00, 0x00, 0x00, 0x3f, 0x40,  //.............@@@+
    0x00, 0x00, 0x00, 0xbf, 0x00,  //............%@@@.
    0x0e, 0x40, 0x07, 0xfe, 0x00,  //..@%+.....+@@@@%.
    0x0f, 0xff, 0xff, 0xfc, 0x00,  //..@@@@@@@@@@@@@..
    0x0f, 0xff, 0xff, 0xe0, 0x00,  //..@@@@@@@@@@@%...
    0x01, 0xbf, 0xfe, 0x00, 0x00,  //...+%@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0068 (h) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x00, 0x00, 0x00,  //@@@.............
    0xfc, 0x0b, 0xfe, 0x40,  //@@@...%@@@@%+...
    0xfc, 0x7f, 0xff, 0xe0,  //@@@.+@@@@@@@@%..
    0xfe, 0xff, 0xff, 0xf8,  //@@@%@@@@@@@@@@%.
    0xff, 0xe4, 0x07, 0xfc,  //@@@@@%+...+@@@@.
    0xff, 0x40, 0x00, 0xfe,  //@@@@+.......@@@%
    0xfe, 0x00, 0x00, 0x7f,  //@@@%........+@@@
    0xfd, 0x00, 0x00, 0x3f,  //@@@+.........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0069 (i) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+006a (j) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x07, 0xf0,  //..+@@%
    0x0f, 0xe0,  //..@@@%
    0xff, 0xc0,  //@@@@@.
    0xff, 0x40,  //@@@@+.
    0xf8, 0x00,  //@@%...
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+006b (k) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x01, 0xff, 0x40,  //@@@........+@@@@+
    0xfc, 0x00, 0x07, 0xfd, 0x00,  //@@@.......+@@@@+.
    0xfc, 0x00, 0x2f, 0xf0, 0x00,  //@@@......%@@@@...
    0xfc, 0x00, 0xff, 0x80, 0x00,  //@@@.....@@@@%....
    0xfc, 0x03, 0xfe, 0x00, 0x00,  //@@@....@@@@%.....
    0xfc, 0x1f, 0xf4, 0x00, 0x00,  //@@@..+@@@@+......
    0xfc, 0x7f, 0xd0, 0x00, 0x00,  //@@@.+@@@@+.......
    0xfe, 0xff, 0x00, 0x00, 0x00,  //@@@%@@@@.........
    0xff, 0xfc, 0x00, 0x00, 0x00,  //@@@@@@@..........
    0xff, 0xfc, 0x00, 0x00, 0x00,  //@@@@@@@..........
    0xfd, 0xff, 0x00, 0x00, 0x00,  //@@@+@@@@.........
    0xfc, 0x7f, 0xc0, 0x00, 0x00,  //@@@.+@@@@........
    0xfc, 0x0f, 0xf0, 0x00, 0x00,  //@@@...@@@@.......
    0xfc, 0x03, 0xfd, 0x00, 0x00,  //@@@....@@@@+.....
    0xfc, 0x00, 0xff, 0x40, 0x00,  //@@@.....@@@@+....
    0xfc, 0x00, 0x3f, 0xd0, 0x00,  //@@@......@@@@+...
    0xfc, 0x00, 0x0f, 0xf4, 0x00,  //@@@.......@@@@+..
    0xfc, 0x00, 0x03, 0xfd, 0x00,  //@@@........@@@@+.
    0xfc, 0x00, 0x00, 0xff, 0x40,  //@@@.........@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+006c (l) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+006d (m) , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0xfc, 0x0b, 0xfd, 0x00, 0x0b, 0xfd, 0x00,  //@@@...%@@@@+......%@@@@+...
    0xfc, 0xbf, 0xff, 0xc0, 0xbf, 0xff, 0xc0,  //@@@.%@@@@@@@@...%@@@@@@@@..
    0xfe, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xe0,  //@@@%@@@@@@@@@@.%@@@@@@@@@%.
    0xff, 0xe0, 0x0b, 0xfb, 0xe0, 0x0b, 0xf4,  //@@@@@%....%@@@%@@%....%@@@+
    0xff, 0x40, 0x02, 0xff, 0x40, 0x02, 0xf8,  //@@@@+......%@@@@+......%@@%
    0xfe, 0x00, 0x01, 0xfe, 0x00, 0x01, 0xfc,  //@@@%.......+@@@%.......+@@@
    0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+006e (n) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xfc, 0x0b, 0xfe, 0x40,  //@@@...%@@@@%+...
    0xfc, 0x7f, 0xff, 0xe0,  //@@@.+@@@@@@@@%..
    0xfe, 0xff, 0xff, 0xf8,  //@@@%@@@@@@@@@@%.
    0xff, 0xe4, 0x07, 0xfc,  //@@@@@%+...+@@@@.
    0xff, 0x40, 0x00, 0xfe,  //@@@@+.......@@@%
    0xfe, 0x00, 0x00, 0x7f,  //@@@%........+@@@
    0xfd, 0x00, 0x00, 0x3f,  //@@@+.........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+006f (o) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x1f, 0xf4, 0x07, 0xfd, 0x00,  //.+@@@@+...+@@@@+.
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@@.........@@@+
    0xbd, 0x00, 0x00, 0x2f, 0x80,  //%@@+.........+@@%
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xbd, 0x00, 0x00, 0x1f, 0x80,  //%@@+.........+@@%
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@@.........@@@+
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x1f, 0xf4, 0x07, 0xfd, 0x00,  //.+@@@@+...+@@@@+.
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x02, 0xff, 0xff, 0xe0, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0070 (p) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xfc, 0x0b, 0xfe, 0x00, 0x00,  //@@@...%@@@@%.....
    0xfc, 0xbf, 0xff, 0xe0, 0x00,  //@@@.%@@@@@@@@%...
    0xfe, 0xff, 0xff, 0xf8, 0x00,  //@@@%@@@@@@@@@@%..
    0xff, 0xf4, 0x07, 0xfd, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0x80, 0x00, 0xbf, 0x00,  //@@@@%.......%@@@.
    0xff, 0x00, 0x00, 0x3f, 0x40,  //@@@@.........@@@+
    0xfd, 0x00, 0x00, 0x1f, 0x80,  //@@@+.........+@@%
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfd, 0x00, 0x00, 0x1f, 0x80,  //@@@+.........+@@%
    0xff, 0x00, 0x00, 0x3f, 0x40,  //@@@@.........@@@+
    0xff, 0x80, 0x00, 0xbf, 0x00,  //@@@@%.......%@@@.
    0xff, 0xf4, 0x07, 0xfd, 0x00,  //@@@@@@+...+@@@@+.
    0xfe, 0xff, 0xff, 0xf8, 0x00,  //@@@%@@@@@@@@@@%..
    0xfc, 0xbf, 0xff, 0xe0, 0x00,  //@@@.%@@@@@@@@%...
    0xfc, 0x0b, 0xfe, 0x00, 0x00,  //@@@...%@@@@%.....
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0071 (q) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x2f, 0xf8, 0x0f, 0xc0,  //.....%@@@@%...@@@
    0x02, 0xff, 0xff, 0x8f, 0xc0,  //...%@@@@@@@@%.@@@
    0x0b, 0xff, 0xff, 0xef, 0xc0,  //..%@@@@@@@@@@%@@@
    0x1f, 0xf4, 0x07, 0xff, 0xc0,  //.+@@@@+...+@@@@@@
    0x3f, 0x80, 0x00, 0xbf, 0xc0,  //.@@@%.......%@@@@
    0x7f, 0x00, 0x00, 0x3f, 0xc0,  //+@@@.........@@@@
    0xbd, 0x00, 0x00, 0x1f, 0xc0,  //%@@+.........+@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xbd, 0x00, 0x00, 0x1f, 0xc0,  //%@@+.........+@@@
    0x7f, 0x00, 0x00, 0x3f, 0xc0,  //+@@@.........@@@@
    0x3f, 0x80, 0x00, 0xbf, 0xc0,  //.@@@%.......%@@@@
    0x1f, 0xf4, 0x07, 0xff, 0xc0,  //.+@@@@+...+@@@@@@
    0x0b, 0xff, 0xff, 0xef, 0xc0,  //..%@@@@@@@@@@%@@@
    0x02, 0xff, 0xff, 0x8f, 0xc0,  //...%@@@@@@@@%.@@@
    0x00, 0x2f, 0xf8, 0x0f, 0xc0,  //.....%@@@@%...@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x0f, 0xc0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0072 (r) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xfc, 0x0b, 0xfc,  //@@@...%@@@@
    0xfc, 0xbf, 0xfc,  //@@@.%@@@@@@
    0xfe, 0xff, 0xfc,  //@@@%@@@@@@@
    0xff, 0xe4, 0x00,  //@@@@@%+....
    0xff, 0x80, 0x00,  //@@@@%......
    0xff, 0x00, 0x00,  //@@@@.......
    0xfd, 0x00, 0x00,  //@@@+.......
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0073 (s) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x01, 0xbf, 0xf9, 0x00,  //...+%@@@@@%+..
    0x1f, 0xff, 0xff, 0xc0,  //.+@@@@@@@@@@@.
    0x3f, 0xff, 0xff, 0xc0,  //.@@@@@@@@@@@@.
    0xbf, 0x40, 0x06, 0xc0,  //%@@@+.....+%@.
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0x40, 0x00, 0x00,  //@@@@+.........
    0x7f, 0xfe, 0x40, 0x00,  //+@@@@@@%+.....
    0x1f, 0xff, 0xfd, 0x00,  //.+@@@@@@@@@+..
    0x02, 0xff, 0xff, 0x80,  //...%@@@@@@@@%.
    0x00, 0x05, 0xff, 0xd0,  //.......+@@@@@+
    0x00, 0x00, 0x0f, 0xf0,  //..........@@@%
    0x00, 0x00, 0x03, 0xf0,  //...........@@@
    0x00, 0x00, 0x03, 0xf0,  //...........@@@
    0x80, 0x00, 0x07, 0xf0,  //%.........+@@@
    0xfd, 0x00, 0x2f, 0xe0,  //@@@+.....%@@@%
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@.
    0x7f, 0xff, 0xff, 0x00,  //.%@@@@@@@@@@..
    0x02, 0xff, 0xe4, 0x00,  //...%@@@@@%+...
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0074 (t) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0f, 0xc0, 0x00,  //..@@@......
    0x0b, 0xe0, 0x00,  //..%@@%.....
    0x07, 0xff, 0xfc,  //..+@@@@@@@@
    0x02, 0xff, 0xfc,  //...%@@@@@@@
    0x00, 0x6f, 0xfc,  //....+%@@@@@
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0075 (u) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x7f,  //@@@.........+@@@
    0xfd, 0x00, 0x00, 0xbf,  //@@@+........%@@@
    0xbf, 0x00, 0x01, 0xff,  //%@@@.......+@@@@
    0x3f, 0xd0, 0x1b, 0xff,  //.@@@@+...+%@@@@@
    0x2f, 0xff, 0xff, 0xbf,  //.%@@@@@@@@@@%@@@
    0x0b, 0xff, 0xfd, 0x3f,  //..%@@@@@@@@+.@@@
    0x01, 0xbf, 0xe0, 0x3f,  //...+%@@@@%...@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0076 (v) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xfd, 0x00, 0x00, 0x07, 0xf0,  //@@@+..........+@@@
    0x7e, 0x00, 0x00, 0x0b, 0xd0,  //+@@%..........%@@+
    0x3f, 0x00, 0x00, 0x0f, 0xc0,  //.@@@..........@@@.
    0x2f, 0x40, 0x00, 0x1f, 0x80,  //.%@@+........+@@%.
    0x1f, 0xc0, 0x00, 0x3f, 0x40,  //.+@@@........@@@+.
    0x0f, 0xc0, 0x00, 0x3f, 0x00,  //..@@@........@@@..
    0x0b, 0xe0, 0x00, 0xbe, 0x00,  //..%@@%......%@@%..
    0x07, 0xf0, 0x00, 0xfd, 0x00,  //..+@@@......@@@...
    0x03, 0xf4, 0x01, 0xfc, 0x00,  //...@@@+....+@@@...
    0x02, 0xf8, 0x02, 0xf8, 0x00,  //...%@@%....%@@%...
    0x00, 0xfc, 0x03, 0xf0, 0x00,  //....@@@....@@@....
    0x00, 0xfd, 0x07, 0xf0, 0x00,  //....@@@+..+@@@....
    0x00, 0x7f, 0x0f, 0xd0, 0x00,  //....+@@%..@@@+....
    0x00, 0x3f, 0x0f, 0xc0, 0x00,  //.....@@@..@@@.....
    0x00, 0x2f, 0x5f, 0x80, 0x00,  //.....%@@++@@%.....
    0x00, 0x1f, 0xff, 0x40, 0x00,  //.....+@@@@@@+.....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //......@@@@@@......
    0x00, 0x0b, 0xfe, 0x00, 0x00,  //......%@@@@%......
    0x00, 0x03, 0xfc, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0077 (w) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0xfc, 0x00, 0x0f, 0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@@@.......@@@
    0xbd, 0x00, 0x0f, 0xfc, 0x00, 0x1f, 0x80,  //%@@+......@@@@@......+@@%
    0x7e, 0x00, 0x1f, 0xfd, 0x00, 0x2f, 0x40,  //+@@%.....+@@@@@+.....%@@+
    0x3f, 0x00, 0x2f, 0xfe, 0x00, 0x3f, 0x00,  //.@@@.....%@@@@@%.....@@@.
    0x3f, 0x00, 0x3f, 0x7f, 0x00, 0x7f, 0x00,  //.@@@.....@@@+@@@.....@@@.
    0x2f, 0x80, 0x3f, 0x3f, 0x00, 0xbe, 0x00,  //.%@@+....@@@.@@@....%@@%.
    0x1f, 0xc0, 0x7e, 0x2f, 0x40, 0xfd, 0x00,  //.+@@@...+@@%.%@@+...@@@+.
    0x0f, 0xc0, 0xbd, 0x1f, 0x80, 0xfc, 0x00,  //..@@@...%@@+.+@@%...@@@..
    0x0f, 0xd0, 0xfc, 0x0f, 0xc1, 0xfc, 0x00,  //..@@@+..@@@...@@@..+@@@..
    0x0b, 0xe0, 0xfc, 0x0f, 0xc2, 0xf8, 0x00,  //..%@@%..@@@...@@@..%@@%..
    0x07, 0xf1, 0xf8, 0x0b, 0xd3, 0xf4, 0x00,  //..+@@@.+@@%...%@@+.@@@+..
    0x03, 0xf2, 0xf4, 0x07, 0xe3, 0xf0, 0x00,  //...@@@.%@@+...+@@%.@@@...
    0x03, 0xf7, 0xf0, 0x03, 0xf7, 0xf0, 0x00,  //...@@@+@@@.....@@@+@@@...
    0x02, 0xff, 0xf0, 0x03, 0xff, 0xe0, 0x00,  //...%@@@@@@.....@@@@@@%...
    0x01, 0xff, 0xe0, 0x02, 0xff, 0xd0, 0x00,  //...+@@@@@%.....%@@@@@+...
    0x00, 0xff, 0xd0, 0x01, 0xff, 0xc0, 0x00,  //....@@@@@+.....+@@@@@....
    0x00, 0xff, 0xc0, 0x00, 0xff, 0xc0, 0x00,  //....@@@@@.......@@@@@....
    0x00, 0xbf, 0xc0, 0x00, 0xff, 0x80, 0x00,  //....%@@@@.......@@@@+....
    0x00, 0x7f, 0x80, 0x00, 0xbf, 0x00, 0x00,  //.....@@@%.......%@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+0078 (x) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x2f, 0xc0, 0x00, 0x0f, 0xe0,  //.%@@@.........@@@%
    0x0f, 0xf0, 0x00, 0x3f, 0xc0,  //..@@@@.......@@@@.
    0x03, 0xf8, 0x00, 0xbf, 0x00,  //...@@@%.....%@@@..
    0x01, 0xfc, 0x01, 0xfd, 0x00,  //...+@@@.....@@@+..
    0x00, 0xbf, 0x03, 0xf8, 0x00,  //....%@@@...@@@%...
    0x00, 0x3f, 0x8b, 0xf0, 0x00,  //.....@@@%.%@@@....
    0x00, 0x1f, 0xef, 0xd0, 0x00,  //.....+@@@%@@@+....
    0x00, 0x0b, 0xff, 0x80, 0x00,  //......%@@@@@%.....
    0x00, 0x03, 0xff, 0x00, 0x00,  //.......@@@@@......
    0x00, 0x02, 0xfe, 0x00, 0x00,  //.......%@@@%......
    0x00, 0x0b, 0xff, 0x00, 0x00,  //......%@@@@@......
    0x00, 0x1f, 0xff, 0xc0, 0x00,  //.....+@@@@@@@.....
    0x00, 0x3f, 0x8f, 0xe0, 0x00,  //.....@@@%.@@@%....
    0x00, 0xff, 0x07, 0xf0, 0x00,  //....@@@@..+@@@....
    0x02, 0xfc, 0x02, 0xfc, 0x00,  //...%@@@....%@@@...
    0x07, 0xf4, 0x00, 0xfe, 0x00,  //..+@@@+.....@@@%..
    0x0f, 0xe0, 0x00, 0x7f, 0x40,  //..@@@%......+@@@+.
    0x3f, 0xc0, 0x00, 0x2f, 0xc0,  //.@@@@........%@@@.
    0xbf, 0x00, 0x00, 0x0f, 0xe0,  //%@@@..........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0079 (y) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xfd, 0x00, 0x00, 0x07, 0xf0,  //@@@+..........+@@@
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........@@@+
    0x3f, 0x40, 0x00, 0x0f, 0xc0,  //.@@@+.........@@@.
    0x2f, 0x80, 0x00, 0x2f, 0x80,  //.%@@%........%@@%.
    0x0f, 0xc0, 0x00, 0x3f, 0x00,  //..@@@........@@@..
    0x0b, 0xe0, 0x00, 0x7f, 0x00,  //..%@@%......+@@@..
    0x07, 0xf0, 0x00, 0xfd, 0x00,  //..+@@@......@@@+..
    0x03, 0xf4, 0x00, 0xfc, 0x00,  //...@@@+.....@@@...
    0x01, 0xfc, 0x02, 0xf8, 0x00,  //...+@@@....%@@%...
    0x00, 0xfc, 0x03, 0xf4, 0x00,  //....@@@....@@@+...
    0x00, 0xbe, 0x07, 0xf0, 0x00,  //....%@@%..+@@@....
    0x00, 0x3f, 0x0b, 0xd0, 0x00,  //.....@@@..%@@+....
    0x00, 0x3f, 0x4f, 0xc0, 0x00,  //.....@@@+.@@@.....
    0x00, 0x1f, 0xef, 0x80, 0x00,  //.....+@@@%@@%.....
    0x00, 0x0f, 0xff, 0x40, 0x00,  //......@@@@@@+.....
    0x00, 0x0b, 0xff, 0x00, 0x00,  //......%@@@@@......
    0x00, 0x03, 0xfe, 0x00, 0x00,  //.......@@@@+......
    0x00, 0x03, 0xfc, 0x00, 0x00,  //.......%@@@.......
    0x00, 0x02, 0xf8, 0x00, 0x00,  //.......%@@%.......
    0x00, 0x03, 0xf4, 0x00, 0x00,  //.......@@@+.......
    0x00, 0x07, 0xf0, 0x00, 0x00,  //......+@@@........
    0x00, 0x0f, 0xe0, 0x00, 0x00,  //......%@@%........
    0x00, 0x2f, 0xc0, 0x00, 0x00,  //.....%@@@.........
    0x0f, 0xff, 0x80, 0x00, 0x00,  //..@@@@@@%.........
    0x0f, 0xff, 0x00, 0x00, 0x00,  //..@@@@@@..........
    0x0f, 0xf8, 0x00, 0x00, 0x00,  //..@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+007a (z) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0x00, 0x00, 0x07, 0xf4,  //..........+@@@+
    0x00, 0x00, 0x1f, 0xe0,  //.........+@@@%.
    0x00, 0x00, 0x3f, 0x80,  //.........@@@%..
    0x00, 0x00, 0xff, 0x00,  //........@@@@...
    0x00, 0x03, 0xfc, 0x00,  //.......@@@@....
    0x00, 0x0b, 0xf4, 0x00,  //......%@@@+....
    0x00, 0x1f, 0xd0, 0x00,  //.....+@@@+.....
    0x00, 0x7f, 0x80, 0x00,  //....+@@@%......
    0x00, 0xff, 0x00, 0x00,  //....@@@@.......
    0x03, 0xfc, 0x00, 0x00,  //...@@@@........
    0x0b, 0xf0, 0x00, 0x00,  //..%@@@.........
    0x2f, 0xd0, 0x00, 0x00,  //.%@@@+.........
    0x7f, 0x80, 0x00, 0x00,  //+@@@%..........
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+007b ({) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x01, 0xbf, 0xc0,  //.......+%@@@@
    0x00, 0x0b, 0xff, 0xc0,  //......%@@@@@@
    0x00, 0x1f, 0xff, 0xc0,  //.....+@@@@@@@
    0x00, 0x2f, 0xd0, 0x00,  //.....%@@@+...
    0x00, 0x3f, 0x40, 0x00,  //.....@@@+....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x7f, 0x00, 0x00,  //....+@@@.....
    0x01, 0xfd, 0x00, 0x00,  //...+@@@+.....
    0xff, 0xf8, 0x00, 0x00,  //@@@@@@%......
    0xff, 0xd0, 0x00, 0x00,  //@@@@@+.......
    0xff, 0xf8, 0x00, 0x00,  //@@@@@@%......
    0x02, 0xfd, 0x00, 0x00,  //...%@@@+.....
    0x00, 0xbf, 0x00, 0x00,  //....%@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x40, 0x00,  //.....@@@.....
    0x00, 0x2f, 0xd0, 0x00,  //.....%@@@+...
    0x00, 0x1f, 0xff, 0xc0,  //.....+@@@@@@@
    0x00, 0x0b, 0xff, 0xc0,  //......%@@@@@@
    0x00, 0x01, 0xbf, 0xc0,  //.......+%@@@@
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+007c (|) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...


    /*Unicode: U+007d (}) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0x90, 0x00, 0x00,  //@@@@%+.......
    0xff, 0xf8, 0x00, 0x00,  //@@@@@@%......
    0xff, 0xfd, 0x00, 0x00,  //@@@@@@@+.....
    0x01, 0xfe, 0x00, 0x00,  //...+@@@%.....
    0x00, 0x7f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x40, 0x00,  //.....@@@+....
    0x00, 0x1f, 0xd0, 0x00,  //.....+@@@+...
    0x00, 0x0b, 0xff, 0xc0,  //......%@@@@@@
    0x00, 0x01, 0xff, 0xc0,  //.......+@@@@@
    0x00, 0x0b, 0xff, 0xc0,  //......%@@@@@@
    0x00, 0x1f, 0xe0, 0x00,  //.....+@@@%...
    0x00, 0x3f, 0x80, 0x00,  //.....@@@%....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0x7f, 0x00, 0x00,  //.....@@@.....
    0x01, 0xfe, 0x00, 0x00,  //...+@@@%.....
    0xff, 0xfd, 0x00, 0x00,  //@@@@@@@+.....
    0xff, 0xf8, 0x00, 0x00,  //@@@@@@%......
    0xff, 0x90, 0x00, 0x00,  //@@@@%+.......
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+007e (~) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x02, 0xff, 0x90, 0x00, 0x01, 0xc0,  //...%@@@@%+.........+@
    0x2f, 0xff, 0xff, 0x40, 0x1f, 0xc0,  //.%@@@@@@@@@@+....+@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xfd, 0x00, 0x7f, 0xff, 0xfe, 0x00,  //@@@+....+@@@@@@@@@@%.
    0xe0, 0x00, 0x01, 0xbf, 0xe0, 0x00,  //@%.........+%@@@@%...
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00,  //+....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................



#elif USE_LV_FONT_DEJAVU_40 == 4
    /*Unicode: U+0020 ( ) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0021 (!) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xef, 0xe0,  //@@@
    0xdf, 0xd0,  //@@@
    0xdf, 0xd0,  //@@@
    0xcf, 0xc0,  //@@@
    0xbf, 0xb0,  //%@%
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0022 (") , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0xff, 0xf0, 0x00, 0xff, 0xf0,  //@@@...@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0023 (#) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0x00, 0x00, 0x2f, 0xf7, 0x00, 0x00,  //.........%@@.....@@+...
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xfc, 0x00, 0x00, 0x6f, 0xf3, 0x00, 0x00,  //.........@@%....+@@....
    0x00, 0x00, 0x00, 0x00, 0x2f, 0xf8, 0x00, 0x00, 0xaf, 0xf0, 0x00, 0x00,  //.........@@%....%@@....
    0x00, 0x00, 0x00, 0x00, 0x5f, 0xf4, 0x00, 0x00, 0xef, 0xb0, 0x00, 0x00,  //........+@@+....@@%....
    0x00, 0x00, 0x00, 0x00, 0x9f, 0xf0, 0x00, 0x02, 0xff, 0x70, 0x00, 0x00,  //........%@@.....@@+....
    0x00, 0x00, 0x00, 0x00, 0xdf, 0xc0, 0x00, 0x06, 0xff, 0x30, 0x00, 0x00,  //........@@@....+@@.....
    0x00, 0x00, 0x00, 0x01, 0xff, 0x80, 0x00, 0x0a, 0xff, 0x00, 0x00, 0x00,  //........@@%....%@@.....
    0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@@@@@@@@@@@@@
    0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@@@@@@@@@@@@@
    0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x0f, 0xfa, 0x00, 0x00, 0x8f, 0xf1, 0x00, 0x00, 0x00,  //.......@@%....%@@......
    0x00, 0x00, 0x00, 0x4f, 0xf6, 0x00, 0x00, 0xcf, 0xd0, 0x00, 0x00, 0x00,  //.......@@+....@@@......
    0x00, 0x00, 0x00, 0x8f, 0xf1, 0x00, 0x01, 0xff, 0x80, 0x00, 0x00, 0x00,  //......%@@.....@@%......
    0x00, 0x00, 0x00, 0xcf, 0xd0, 0x00, 0x05, 0xff, 0x40, 0x00, 0x00, 0x00,  //......@@@....+@@+......
    0x00, 0x00, 0x01, 0xff, 0x90, 0x00, 0x09, 0xff, 0x00, 0x00, 0x00, 0x00,  //......@@%....%@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00,  //@@@@@@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00,  //@@@@@@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x00,  //@@@@@@@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x0e, 0xfa, 0x00, 0x00, 0x8f, 0xf1, 0x00, 0x00, 0x00, 0x00,  //.....@@%....%@@........
    0x00, 0x00, 0x3f, 0xf6, 0x00, 0x00, 0xcf, 0xe0, 0x00, 0x00, 0x00, 0x00,  //.....@@+....%@@........
    0x00, 0x00, 0x6f, 0xf3, 0x00, 0x00, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00,  //....+@@.....@@%........
    0x00, 0x00, 0xaf, 0xe0, 0x00, 0x03, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00,  //....%@@.....@@+........
    0x00, 0x00, 0xef, 0xb0, 0x00, 0x07, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00,  //....@@%....+@@.........
    0x00, 0x02, 0xff, 0x70, 0x00, 0x0b, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@+....%@@.........
    0x00, 0x06, 0xff, 0x30, 0x00, 0x0f, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@.....@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0024 ($) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x03, 0x9c, 0xef, 0xff, 0xdb, 0x62, 0x00,  //....%@@@@@@%+...
    0x01, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@@@..
    0x0d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@..
    0x7f, 0xff, 0xb4, 0x1f, 0xf0, 0x24, 0x9d, 0x00,  //+@@@%+.@@..+%@..
    0xdf, 0xf8, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //@@@%...@@.......
    0xff, 0xf1, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //@@@....@@.......
    0xff, 0xf1, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //@@@....@@.......
    0xcf, 0xfb, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //@@@%...@@.......
    0x6f, 0xff, 0xe9, 0x5f, 0xf0, 0x00, 0x00, 0x00,  //+@@@@%+@@.......
    0x09, 0xff, 0xff, 0xff, 0xfc, 0x94, 0x00, 0x00,  //.%@@@@@@@@%+....
    0x00, 0x5d, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x00,  //..+@@@@@@@@@@+..
    0x00, 0x00, 0x37, 0xbf, 0xff, 0xff, 0xff, 0x70,  //.....+%@@@@@@@+.
    0x00, 0x00, 0x00, 0x0f, 0xf3, 0x8e, 0xff, 0xf4,  //.......@@.%@@@@.
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x01, 0xcf, 0xfa,  //.......@@...@@@%
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x3f, 0xfe,  //.......@@....@@@
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x0f, 0xff,  //.......@@....@@@
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x2f, 0xfe,  //.......@@....@@@
    0xb3, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0xbf, 0xfb,  //%......@@...%@@%
    0xff, 0xc7, 0x30, 0x0f, 0xf1, 0x5d, 0xff, 0xf5,  //@@@+...@@.+@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //@@@@@@@@@@@@@@%.
    0x3b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,  //.%@@@@@@@@@@@%..
    0x00, 0x17, 0xad, 0xff, 0xfe, 0xb7, 0x20, 0x00,  //...+%@@@@@%+....
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0025 (%) , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x19, 0xef, 0xe9, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xf9, 0x00, 0x00, 0x00,  //...%@@@%.............@@%.....
    0x03, 0xef, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xe0, 0x00, 0x00, 0x00,  //..@@@@@@@...........+@@......
    0x0d, 0xff, 0x50, 0x5f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x40, 0x00, 0x00, 0x00,  //.@@@+.+@@@..........@@+......
    0x6f, 0xf9, 0x00, 0x0a, 0xff, 0x60, 0x00, 0x00, 0x00, 0x0b, 0xf9, 0x00, 0x00, 0x00, 0x00,  //+@@%...%@@+........%@%.......
    0xbf, 0xf4, 0x00, 0x04, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x6f, 0xe1, 0x00, 0x00, 0x00, 0x00,  //%@@+...+@@%.......+@@........
    0xef, 0xf1, 0x00, 0x01, 0xff, 0xe0, 0x00, 0x00, 0x01, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@@.......@@+........
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x0b, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@@......%@%.........
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x6f, 0xe1, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@@.....+@@..........
    0xef, 0xf1, 0x00, 0x01, 0xff, 0xe0, 0x00, 0x01, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@@.....@@+..........
    0xbf, 0xf4, 0x00, 0x04, 0xff, 0xb0, 0x00, 0x0b, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@....+@@%....%@%...........
    0x6f, 0xf9, 0x00, 0x09, 0xff, 0x60, 0x00, 0x5f, 0xe1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%...%@@+...+@@............
    0x0e, 0xff, 0x50, 0x5f, 0xfd, 0x00, 0x01, 0xef, 0x50, 0x00, 0x19, 0xef, 0xe9, 0x10, 0x00,  //.@@@+.+@@@....@@+....%@@@%...
    0x03, 0xff, 0xff, 0xff, 0xe3, 0x00, 0x0a, 0xfb, 0x00, 0x03, 0xef, 0xff, 0xff, 0xe3, 0x00,  //..@@@@@@@....%@%....@@@@@@@..
    0x00, 0x19, 0xef, 0xe9, 0x10, 0x00, 0x5f, 0xe1, 0x00, 0x0d, 0xff, 0x50, 0x5f, 0xfd, 0x00,  //...%@@@%....+@@....@@@+.+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xef, 0x50, 0x00, 0x6f, 0xf9, 0x00, 0x09, 0xff, 0x60,  //............@@+...+@@%...%@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xfb, 0x00, 0x00, 0xbf, 0xf4, 0x00, 0x04, 0xff, 0xb0,  //...........%@%....%@@+...+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xf1, 0x00, 0x00, 0xef, 0xf1, 0x00, 0x01, 0xff, 0xe0,  //..........+@@.....@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x01, 0xef, 0x60, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //..........@@+.....@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x0a, 0xfb, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //.........%@%......@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x4f, 0xf1, 0x00, 0x00, 0x00, 0xef, 0xf1, 0x00, 0x01, 0xff, 0xe0,  //........+@@.......@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0xef, 0x60, 0x00, 0x00, 0x00, 0xbf, 0xf4, 0x00, 0x04, 0xff, 0xb0,  //........@@+.......%@@+...+@@%
    0x00, 0x00, 0x00, 0x09, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfa, 0x00, 0x0a, 0xff, 0x60,  //.......%@%........+@@%...%@@+
    0x00, 0x00, 0x00, 0x4f, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x50, 0x5f, 0xfd, 0x00,  //......+@@..........@@@+.+@@@.
    0x00, 0x00, 0x00, 0xef, 0x60, 0x00, 0x00, 0x00, 0x00, 0x03, 0xef, 0xff, 0xff, 0xe3, 0x00,  //......@@+...........@@@@@@@..
    0x00, 0x00, 0x09, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0xef, 0xe9, 0x10, 0x00,  //.....%@@.............%@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+0026 (&) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x6b, 0xef, 0xfd, 0xb7, 0x20, 0x00, 0x00, 0x00, 0x00,  //......+%@@@@%+.........
    0x00, 0x00, 0x2d, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@........
    0x00, 0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@........
    0x00, 0x08, 0xff, 0xfa, 0x30, 0x02, 0x59, 0xd0, 0x00, 0x00, 0x00, 0x00,  //...+@@@%....+%@........
    0x00, 0x0d, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@%................
    0x00, 0x0f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@.................
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@.................
    0x00, 0x0d, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@+................
    0x00, 0x08, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@................
    0x00, 0x01, 0xef, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@...............
    0x00, 0x04, 0xef, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@..............
    0x00, 0x5f, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@@.............
    0x04, 0xff, 0xfe, 0x7f, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x2f, 0xfe, 0x00,  //.+@@@@+@@@@........@@@.
    0x0e, 0xff, 0xd1, 0x05, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x6f, 0xfb, 0x00,  //.@@@@..+@@@@......+@@%.
    0x7f, 0xff, 0x20, 0x00, 0x6f, 0xff, 0xe2, 0x00, 0x00, 0xcf, 0xf7, 0x00,  //+@@@....+@@@@.....@@@+.
    0xcf, 0xf7, 0x00, 0x00, 0x06, 0xff, 0xfe, 0x30, 0x03, 0xff, 0xf1, 0x00,  //@@@+.....+@@@@....@@@..
    0xff, 0xf1, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xf3, 0x0c, 0xff, 0xa0, 0x00,  //@@@.......+@@@@..@@@%..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xaf, 0xff, 0x20, 0x00,  //@@@........+@@@@%@@@...
    0xdf, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xf7, 0x00, 0x00,  //@@@+........+@@@@@@+...
    0xaf, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xc0, 0x00, 0x00,  //%@@@.........%@@@@@....
    0x4f, 0xff, 0xb1, 0x00, 0x00, 0x00, 0x5f, 0xff, 0xff, 0xf4, 0x00, 0x00,  //.@@@%.......+@@@@@@+...
    0x0a, 0xff, 0xfe, 0x73, 0x00, 0x4b, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00,  //.%@@@@+...+%@@@@@@@@...
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x9f, 0xff, 0xd1, 0x00,  //..%@@@@@@@@@@@@.%@@@@..
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x10, 0x0a, 0xff, 0xfb, 0x00,  //...+@@@@@@@@@%...%@@@%.
    0x00, 0x00, 0x17, 0xbe, 0xff, 0xd9, 0x40, 0x00, 0x00, 0xaf, 0xff, 0x90,  //.....+%@@@@%+.....%@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0027 (') , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0028 (() , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x5f, 0xfa,  //....+@@%
    0x00, 0x00, 0xef, 0xf1,  //....@@@.
    0x00, 0x08, 0xff, 0x70,  //...%@@+.
    0x00, 0x1f, 0xfe, 0x00,  //...@@@..
    0x00, 0x8f, 0xf7, 0x00,  //..%@@+..
    0x00, 0xef, 0xf0, 0x00,  //..@@@...
    0x05, 0xff, 0x90, 0x00,  //.+@@%...
    0x0b, 0xff, 0x30, 0x00,  //.%@@....
    0x0f, 0xfe, 0x00, 0x00,  //.@@@....
    0x5f, 0xfa, 0x00, 0x00,  //+@@%....
    0x8f, 0xf7, 0x00, 0x00,  //%@@+....
    0xbf, 0xf4, 0x00, 0x00,  //%@@+....
    0xdf, 0xf2, 0x00, 0x00,  //@@@.....
    0xef, 0xf0, 0x00, 0x00,  //@@@.....
    0xff, 0xf0, 0x00, 0x00,  //@@@.....
    0xff, 0xf0, 0x00, 0x00,  //@@@.....
    0xef, 0xf0, 0x00, 0x00,  //@@@.....
    0xdf, 0xf2, 0x00, 0x00,  //@@@.....
    0xbf, 0xf4, 0x00, 0x00,  //%@@+....
    0x8f, 0xf7, 0x00, 0x00,  //%@@+....
    0x4f, 0xfa, 0x00, 0x00,  //+@@%....
    0x0f, 0xfe, 0x00, 0x00,  //.@@@....
    0x0b, 0xff, 0x30, 0x00,  //.%@@....
    0x05, 0xff, 0x90, 0x00,  //.+@@%...
    0x00, 0xef, 0xf0, 0x00,  //..@@@...
    0x00, 0x8f, 0xf7, 0x00,  //..%@@+..
    0x00, 0x1f, 0xfe, 0x00,  //...@@@..
    0x00, 0x08, 0xff, 0x70,  //...%@@+.
    0x00, 0x00, 0xef, 0xf1,  //....@@@.
    0x00, 0x00, 0x5f, 0xfa,  //....+@@%
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0029 ()) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xaf, 0xf5, 0x00, 0x00,  //%@@+....
    0x1f, 0xfe, 0x00, 0x00,  //.@@@....
    0x07, 0xff, 0x70, 0x00,  //.+@@+...
    0x00, 0xef, 0xf1, 0x00,  //..@@@...
    0x00, 0x7f, 0xf8, 0x00,  //..+@@%..
    0x00, 0x0f, 0xfe, 0x00,  //...@@@..
    0x00, 0x09, 0xff, 0x50,  //...%@@+.
    0x00, 0x04, 0xff, 0xb0,  //....@@%.
    0x00, 0x00, 0xef, 0xf0,  //....@@@.
    0x00, 0x00, 0xaf, 0xf4,  //....%@@+
    0x00, 0x00, 0x7f, 0xf8,  //....+@@%
    0x00, 0x00, 0x4f, 0xfb,  //....+@@%
    0x00, 0x00, 0x2f, 0xfd,  //.....@@@
    0x00, 0x00, 0x0f, 0xfe,  //.....@@@
    0x00, 0x00, 0x0f, 0xff,  //.....@@@
    0x00, 0x00, 0x0f, 0xff,  //.....@@@
    0x00, 0x00, 0x0f, 0xfe,  //.....@@@
    0x00, 0x00, 0x2f, 0xfd,  //.....@@@
    0x00, 0x00, 0x4f, 0xfb,  //....+@@%
    0x00, 0x00, 0x7f, 0xf8,  //....+@@%
    0x00, 0x00, 0xaf, 0xf4,  //....%@@+
    0x00, 0x00, 0xef, 0xf0,  //....@@@.
    0x00, 0x04, 0xff, 0xb0,  //....@@%.
    0x00, 0x09, 0xff, 0x50,  //...%@@+.
    0x00, 0x0f, 0xfe, 0x00,  //...@@@..
    0x00, 0x7f, 0xf8, 0x00,  //..+@@%..
    0x00, 0xef, 0xf1, 0x00,  //..@@@...
    0x07, 0xff, 0x80, 0x00,  //.+@@+...
    0x1f, 0xfe, 0x00, 0x00,  //.@@@....
    0xaf, 0xf5, 0x00, 0x00,  //%@@+....
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+002a (*) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x4b, 0x20, 0x00, 0x0f, 0xf0, 0x00, 0x02, 0xb4,  //+%.....@@.....%+
    0xcf, 0xf8, 0x00, 0x0f, 0xf0, 0x00, 0x8f, 0xfc,  //@@@%...@@...%@@%
    0x07, 0xef, 0xe6, 0x0f, 0xf0, 0x6e, 0xfe, 0x70,  //.+@@@+.@@.+@@@+.
    0x00, 0x08, 0xff, 0xcf, 0xfc, 0xff, 0x80, 0x00,  //...+@@@@@@@@+...
    0x00, 0x00, 0x18, 0xff, 0xff, 0x81, 0x00, 0x00,  //.....%@@@@%.....
    0x00, 0x00, 0x18, 0xff, 0xff, 0x81, 0x00, 0x00,  //.....%@@@@%.....
    0x00, 0x07, 0xff, 0xcf, 0xfc, 0xff, 0x70, 0x00,  //...+@@@@@@@@+...
    0x07, 0xef, 0xe6, 0x0f, 0xf0, 0x6e, 0xfe, 0x70,  //.+@@@+.@@.+@@@+.
    0xcf, 0xf9, 0x00, 0x0f, 0xf0, 0x00, 0x9f, 0xfc,  //%@@%...@@...%@@%
    0x4b, 0x20, 0x00, 0x0f, 0xf0, 0x00, 0x02, 0xb4,  //+%.....@@.....%+
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+002b (+) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+002c (,) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x0f, 0xff,  //.@@@
    0x0f, 0xff,  //.@@@
    0x0f, 0xff,  //.@@@
    0x2f, 0xfb,  //.@@%
    0x5f, 0xf5,  //+@@+
    0x8f, 0xe0,  //%@@.
    0xbf, 0x90,  //%@%.
    0xef, 0x30,  //@@..
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+002d (-) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+002e (.) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+002f (/) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //........@@@
    0x00, 0x00, 0x00, 0x08, 0xff, 0x90,  //.......%@@%
    0x00, 0x00, 0x00, 0x0d, 0xff, 0x40,  //.......@@@+
    0x00, 0x00, 0x00, 0x1f, 0xff, 0x00,  //.......@@@.
    0x00, 0x00, 0x00, 0x6f, 0xfb, 0x00,  //......+@@%.
    0x00, 0x00, 0x00, 0xaf, 0xf7, 0x00,  //......%@@+.
    0x00, 0x00, 0x00, 0xef, 0xf2, 0x00,  //......@@@..
    0x00, 0x00, 0x03, 0xff, 0xe0, 0x00,  //......@@@..
    0x00, 0x00, 0x08, 0xff, 0x90, 0x00,  //.....+@@%..
    0x00, 0x00, 0x0c, 0xff, 0x50, 0x00,  //.....@@@+..
    0x00, 0x00, 0x1f, 0xff, 0x00, 0x00,  //.....@@@...
    0x00, 0x00, 0x5f, 0xfc, 0x00, 0x00,  //....+@@@...
    0x00, 0x00, 0xaf, 0xf7, 0x00, 0x00,  //....%@@+...
    0x00, 0x00, 0xef, 0xf3, 0x00, 0x00,  //....@@@....
    0x00, 0x03, 0xff, 0xe0, 0x00, 0x00,  //....@@@....
    0x00, 0x07, 0xff, 0xa0, 0x00, 0x00,  //...+@@%....
    0x00, 0x0c, 0xff, 0x50, 0x00, 0x00,  //...@@@+....
    0x00, 0x0f, 0xff, 0x10, 0x00, 0x00,  //...@@@.....
    0x00, 0x5f, 0xfc, 0x00, 0x00, 0x00,  //..+@@@.....
    0x00, 0x9f, 0xf8, 0x00, 0x00, 0x00,  //..%@@%.....
    0x00, 0xef, 0xf3, 0x00, 0x00, 0x00,  //..@@@......
    0x02, 0xff, 0xe0, 0x00, 0x00, 0x00,  //..@@@......
    0x07, 0xff, 0xa0, 0x00, 0x00, 0x00,  //.+@@%......
    0x0b, 0xff, 0x60, 0x00, 0x00, 0x00,  //.%@@+......
    0x0f, 0xff, 0x10, 0x00, 0x00, 0x00,  //.@@@.......
    0x4f, 0xfd, 0x00, 0x00, 0x00, 0x00,  //+@@@.......
    0x9f, 0xf8, 0x00, 0x00, 0x00, 0x00,  //%@@%.......
    0xdf, 0xf4, 0x00, 0x00, 0x00, 0x00,  //@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0030 (0) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x06, 0xbe, 0xfe, 0xb6, 0x00, 0x00, 0x00,  //.....+%@@@%+.....
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xe4, 0x00, 0x00,  //...+@@@@@@@@@....
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x00,  //...@@@@@@@@@@@...
    0x00, 0xef, 0xfe, 0x61, 0x01, 0x6e, 0xff, 0xe0, 0x00,  //..@@@@+...+@@@@..
    0x08, 0xff, 0xe2, 0x00, 0x00, 0x02, 0xef, 0xf8, 0x00,  //.%@@@.......@@@+.
    0x0e, 0xff, 0x50, 0x00, 0x00, 0x00, 0x5f, 0xfe, 0x00,  //.@@@+.......+@@@.
    0x4f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x30,  //.@@@.........@@@.
    0x8f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x80,  //%@@%.........%@@+
    0xaf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xa0,  //%@@+.........+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xaf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xa0,  //%@@+.........+@@%
    0x8f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x80,  //%@@%.........%@@%
    0x4f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x30,  //+@@@.........@@@.
    0x0e, 0xff, 0x50, 0x00, 0x00, 0x00, 0x5f, 0xfe, 0x00,  //.@@@+.......+@@@.
    0x08, 0xff, 0xe2, 0x00, 0x00, 0x02, 0xef, 0xf8, 0x00,  //.%@@@.......@@@+.
    0x00, 0xef, 0xfe, 0x61, 0x01, 0x6e, 0xff, 0xe0, 0x00,  //..@@@@+...+@@@@..
    0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x00,  //...@@@@@@@@@@@...
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xe4, 0x00, 0x00,  //...+@@@@@@@@@....
    0x00, 0x00, 0x06, 0xce, 0xfe, 0xc6, 0x00, 0x00, 0x00,  //.....+%@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0031 (1) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x14, 0x69, 0xcf, 0xff, 0xf0, 0x00, 0x00,  //..+%@@@@@.....
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //@@@@@@@@@.....
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00,  //@@@@@@@@@.....
    0xeb, 0x96, 0x31, 0xff, 0xf0, 0x00, 0x00,  //@%%+..@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......@@@.....
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0032 (2) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x15, 0x8a, 0xce, 0xff, 0xec, 0x94, 0x00, 0x00, 0x00,  //.+%%@@@@@@%+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x00, 0x00,  //@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00,  //@@@@@@@@@@@@@@+..
    0xff, 0xfa, 0x63, 0x10, 0x03, 0x9f, 0xff, 0xe1, 0x00,  //@@@%+.....%@@@@..
    0xc5, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xf8, 0x00,  //@+.........+@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfd, 0x00,  //............+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x00,  //.............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //.............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x00,  //.............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xf8, 0x00,  //............%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf1, 0x00,  //............@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x70, 0x00,  //...........@@@+..
    0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xfb, 0x00, 0x00,  //..........@@@%...
    0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xd1, 0x00, 0x00,  //.........@@@@....
    0x00, 0x00, 0x00, 0x01, 0xdf, 0xfd, 0x10, 0x00, 0x00,  //........@@@@.....
    0x00, 0x00, 0x00, 0x2d, 0xff, 0xe1, 0x00, 0x00, 0x00,  //.......@@@@......
    0x00, 0x00, 0x02, 0xef, 0xfe, 0x20, 0x00, 0x00, 0x00,  //......@@@@.......
    0x00, 0x00, 0x3e, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00,  //.....@@@@........
    0x00, 0x04, 0xff, 0xfd, 0x20, 0x00, 0x00, 0x00, 0x00,  //...+@@@@.........
    0x00, 0x5f, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@..........
    0x06, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@...........
    0x7f, 0xff, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,  //@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0033 (3) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x01, 0x59, 0xce, 0xff, 0xec, 0x82, 0x00, 0x00,  //..+%@@@@@@%.....
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //.@@@@@@@@@@@%...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00,  //.@@@@@@@@@@@@%..
    0x0d, 0x96, 0x31, 0x00, 0x26, 0xdf, 0xff, 0x60,  //.@%+.....+@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xc0,  //...........%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe0,  //............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0x70,  //...........%@@+.
    0x00, 0x00, 0x00, 0x00, 0x15, 0xcf, 0xfc, 0x00,  //.........+@@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //....@@@@@@@@%...
    0x00, 0x00, 0xff, 0xff, 0xff, 0xf8, 0x10, 0x00,  //....@@@@@@@%....
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00,  //....@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x25, 0xbf, 0xff, 0x90,  //.........+%@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xf4,  //...........+@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfb,  //............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfe,  //.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfb,  //............%@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf6,  //...........+@@@+
    0xd8, 0x53, 0x10, 0x00, 0x25, 0xbf, 0xff, 0xd0,  //@%+......+%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20,  //@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x00,  //@@@@@@@@@@@@%...
    0x26, 0x9c, 0xef, 0xff, 0xdb, 0x72, 0x00, 0x00,  //.+%@@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0034 (4) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xf0, 0x00, 0x00,  //..........%@@@@....
    0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xff, 0xf0, 0x00, 0x00,  //.........+@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x1e, 0xfc, 0xff, 0xf0, 0x00, 0x00,  //.........@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xf2, 0xff, 0xf0, 0x00, 0x00,  //........%@@.@@@....
    0x00, 0x00, 0x00, 0x06, 0xff, 0x70, 0xff, 0xf0, 0x00, 0x00,  //.......+@@+.@@@....
    0x00, 0x00, 0x00, 0x1f, 0xfc, 0x00, 0xff, 0xf0, 0x00, 0x00,  //.......@@@..@@@....
    0x00, 0x00, 0x00, 0xbf, 0xf2, 0x00, 0xff, 0xf0, 0x00, 0x00,  //......%@@...@@@....
    0x00, 0x00, 0x06, 0xff, 0x70, 0x00, 0xff, 0xf0, 0x00, 0x00,  //.....+@@+...@@@....
    0x00, 0x00, 0x2f, 0xfc, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //.....@@@....@@@....
    0x00, 0x00, 0xcf, 0xf2, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@.....@@@....
    0x00, 0x07, 0xff, 0x70, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //...+@@+.....@@@....
    0x00, 0x2f, 0xfc, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //...@@@......@@@....
    0x00, 0xcf, 0xf2, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@.......@@@....
    0x07, 0xff, 0x70, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //.+@@+.......@@@....
    0x2f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //.@@@........@@@....
    0xcf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //@@@.........@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0035 (5) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@..
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@..
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@..
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@............
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@............
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@............
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@............
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@............
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@............
    0x0f, 0xff, 0x9d, 0xff, 0xeb, 0x71, 0x00, 0x00,  //.@@@%@@@@%+.....
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //.@@@@@@@@@@@%...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.@@@@@@@@@@@@@..
    0x0d, 0x85, 0x20, 0x00, 0x27, 0xdf, 0xff, 0xb0,  //.@%+.....+@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xf4,  //...........%@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xf9,  //............%@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfd,  //.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfd,  //.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xfa,  //............%@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xf4,  //...........%@@@+
    0xd9, 0x53, 0x10, 0x00, 0x26, 0xdf, 0xff, 0xb0,  //@%+......+@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10,  //@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //@@@@@@@@@@@@%...
    0x26, 0x9c, 0xef, 0xff, 0xdb, 0x71, 0x00, 0x00,  //.+%@@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0036 (6) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x5a, 0xdf, 0xfe, 0xb7, 0x20, 0x00,  //......+%@@@@%+...
    0x00, 0x00, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //....+@@@@@@@@@@..
    0x00, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //...+@@@@@@@@@@@..
    0x00, 0x5f, 0xff, 0xe7, 0x20, 0x01, 0x48, 0xd0, 0x00,  //..+@@@@+....+%@..
    0x01, 0xef, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@%...........
    0x09, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@............
    0x0e, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@+............
    0x5f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0x8f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0xcf, 0xf5, 0x02, 0x8d, 0xff, 0xda, 0x40, 0x00, 0x00,  //@@@+..%@@@@%+....
    0xdf, 0xf2, 0x6f, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x00,  //@@@.+@@@@@@@@@...
    0xef, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00,  //@@@+@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0x83, 0x00, 0x38, 0xff, 0xfd, 0x00,  //@@@@@@%....%@@@@.
    0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x4f, 0xff, 0x50,  //@@@@@+......+@@@+
    0xef, 0xff, 0x80, 0x00, 0x00, 0x00, 0x08, 0xff, 0xa0,  //@@@@%........%@@%
    0xdf, 0xff, 0x20, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@@..........@@@
    0xaf, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //%@@@..........@@@
    0x7f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //+@@@..........@@@
    0x3f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //.@@@..........@@@
    0x0e, 0xff, 0x80, 0x00, 0x00, 0x00, 0x08, 0xff, 0xa0,  //.@@@%........%@@%
    0x07, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x4f, 0xff, 0x40,  //.+@@@+......+@@@+
    0x00, 0xdf, 0xff, 0x82, 0x00, 0x28, 0xff, 0xfc, 0x00,  //..@@@@%....%@@@@.
    0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x00,  //...@@@@@@@@@@@@..
    0x00, 0x03, 0xdf, 0xff, 0xff, 0xff, 0xfc, 0x10, 0x00,  //....@@@@@@@@@%...
    0x00, 0x00, 0x05, 0xbd, 0xff, 0xd9, 0x40, 0x00, 0x00,  //.....+%@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0037 (7) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf2,  //............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xb0,  //...........%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x40,  //...........@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfe, 0x00,  //..........+@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf7, 0x00,  //..........@@@+..
    0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xf1, 0x00,  //..........@@@...
    0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xa0, 0x00,  //.........%@@%...
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00,  //.........@@@....
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xfd, 0x00, 0x00,  //........+@@@....
    0x00, 0x00, 0x00, 0x00, 0xdf, 0xf6, 0x00, 0x00,  //........@@@+....
    0x00, 0x00, 0x00, 0x03, 0xff, 0xf0, 0x00, 0x00,  //........@@@.....
    0x00, 0x00, 0x00, 0x0a, 0xff, 0x90, 0x00, 0x00,  //.......%@@%.....
    0x00, 0x00, 0x00, 0x1f, 0xff, 0x20, 0x00, 0x00,  //.......@@@......
    0x00, 0x00, 0x00, 0x7f, 0xfc, 0x00, 0x00, 0x00,  //......+@@%......
    0x00, 0x00, 0x00, 0xef, 0xf5, 0x00, 0x00, 0x00,  //......@@@+......
    0x00, 0x00, 0x05, 0xff, 0xe0, 0x00, 0x00, 0x00,  //.....+@@@.......
    0x00, 0x00, 0x0b, 0xff, 0x80, 0x00, 0x00, 0x00,  //.....%@@%.......
    0x00, 0x00, 0x2f, 0xff, 0x10, 0x00, 0x00, 0x00,  //.....@@@........
    0x00, 0x00, 0x8f, 0xfa, 0x00, 0x00, 0x00, 0x00,  //....%@@%........
    0x00, 0x00, 0xef, 0xf4, 0x00, 0x00, 0x00, 0x00,  //....@@@+........
    0x00, 0x06, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00,  //...+@@@.........
    0x00, 0x0c, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //...@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0038 (8) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x39, 0xde, 0xfe, 0xd9, 0x30, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x0a, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //..@@@@@@@@@@@@@..
    0x06, 0xff, 0xfc, 0x41, 0x01, 0x5c, 0xff, 0xf6, 0x00,  //.+@@@@+...+@@@@+.
    0x0c, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xaf, 0xfc, 0x00,  //.@@@%.......%@@@.
    0x0f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x00,  //.@@@.........@@@.
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //.@@@.........@@@.
    0x0d, 0xff, 0x20, 0x00, 0x00, 0x00, 0x2f, 0xfd, 0x00,  //.@@@.........@@@.
    0x07, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xaf, 0xf7, 0x00,  //.+@@%.......%@@+.
    0x00, 0xcf, 0xfc, 0x41, 0x01, 0x4c, 0xff, 0xc0, 0x00,  //..@@@@+...+@@@@..
    0x00, 0x0a, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x01, 0x8f, 0xff, 0xff, 0xff, 0x81, 0x00, 0x00,  //....%@@@@@@@%....
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00,  //..+@@@@@@@@@@@+..
    0x08, 0xff, 0xf9, 0x31, 0x01, 0x39, 0xff, 0xf8, 0x00,  //.%@@@%.....%@@@%.
    0x3f, 0xff, 0x30, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x30,  //.@@@.........@@@.
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0,  //%@@+.........+@@%
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xcf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xc0,  //@@@+.........+@@@
    0x8f, 0xff, 0x30, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x80,  //+@@@.........@@@+
    0x1f, 0xff, 0xf9, 0x30, 0x01, 0x39, 0xff, 0xff, 0x10,  //.@@@@%.....%@@@@.
    0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00,  //.+@@@@@@@@@@@@@+.
    0x00, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //..+@@@@@@@@@@@+..
    0x00, 0x00, 0x5a, 0xdf, 0xff, 0xda, 0x50, 0x00, 0x00,  //....+%@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0039 (9) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x49, 0xdf, 0xfd, 0xb5, 0x00, 0x00, 0x00,  //....+%@@@@%+.....
    0x00, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xd3, 0x00, 0x00,  //...%@@@@@@@@@....
    0x01, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x00,  //..@@@@@@@@@@@@...
    0x0c, 0xff, 0xf8, 0x30, 0x03, 0x8f, 0xff, 0xd0, 0x00,  //.@@@@%....%@@@@..
    0x4f, 0xff, 0x40, 0x00, 0x00, 0x04, 0xff, 0xf7, 0x00,  //+@@@+......+@@@+.
    0xaf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfe, 0x00,  //%@@%........%@@@.
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x30,  //@@@..........@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x70,  //@@@..........@@@+
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xa0,  //@@@..........@@@%
    0xef, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0xd0,  //@@@..........@@@@
    0xaf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xe0,  //%@@%........%@@@@
    0x5f, 0xff, 0x30, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf0,  //+@@@........@@@@@
    0x0d, 0xff, 0xf8, 0x20, 0x02, 0x8f, 0xff, 0xff, 0xf0,  //.@@@@%....%@@@@@@
    0x02, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xe0,  //..@@@@@@@@@@@+@@@
    0x00, 0x2c, 0xff, 0xff, 0xff, 0xff, 0x62, 0xff, 0xd0,  //...@@@@@@@@@+.@@@
    0x00, 0x00, 0x5a, 0xdf, 0xfd, 0x82, 0x05, 0xff, 0xc0,  //....+%@@@@%..+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0x80,  //.............%@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x50,  //.............@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0x00,  //............+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf9, 0x00,  //............@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xe1, 0x00,  //...........%@@@..
    0x00, 0xd8, 0x41, 0x00, 0x27, 0xef, 0xff, 0x50, 0x00,  //..@%+....+@@@@+..
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x00,  //..@@@@@@@@@@@+...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00, 0x00,  //..@@@@@@@@@@+....
    0x00, 0x27, 0xbe, 0xff, 0xdb, 0x50, 0x00, 0x00, 0x00,  //...+%@@@@%+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+003a (:) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+003b (;) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x0f, 0xff,  //.@@@
    0x0f, 0xff,  //.@@@
    0x0f, 0xff,  //.@@@
    0x0f, 0xff,  //.@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x0f, 0xff,  //.@@@
    0x0f, 0xff,  //.@@@
    0x0f, 0xff,  //.@@@
    0x2f, 0xfb,  //.@@%
    0x5f, 0xf5,  //+@@+
    0x8f, 0xe0,  //%@@.
    0xbf, 0x90,  //%@%.
    0xef, 0x30,  //@@..
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+003c (<) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0xd0,  //...................+@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5b, 0xff, 0xf0,  //................+%@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xaf, 0xff, 0xff, 0xf0,  //.............+%@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xef, 0xff, 0xff, 0xfb, 0x60,  //...........%@@@@@@@%+
    0x00, 0x00, 0x00, 0x01, 0x7c, 0xff, 0xff, 0xff, 0xd7, 0x10, 0x00,  //........+@@@@@@@@+...
    0x00, 0x00, 0x05, 0xbf, 0xff, 0xff, 0xfe, 0x93, 0x00, 0x00, 0x00,  //.....+%@@@@@@@%......
    0x00, 0x4a, 0xff, 0xff, 0xff, 0xfa, 0x40, 0x00, 0x00, 0x00, 0x00,  //..+%@@@@@@@%+........
    0x8e, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@%+...........
    0xff, 0xff, 0xfd, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@+..............
    0xff, 0xff, 0xfd, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@+..............
    0x8e, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@%+...........
    0x00, 0x4a, 0xff, 0xff, 0xff, 0xfa, 0x40, 0x00, 0x00, 0x00, 0x00,  //..+%@@@@@@@%+........
    0x00, 0x00, 0x05, 0xbf, 0xff, 0xff, 0xfe, 0x83, 0x00, 0x00, 0x00,  //.....+%@@@@@@@%......
    0x00, 0x00, 0x00, 0x01, 0x7d, 0xff, 0xff, 0xff, 0xd7, 0x10, 0x00,  //........+@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xef, 0xff, 0xff, 0xfb, 0x60,  //...........%@@@@@@@%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xaf, 0xff, 0xff, 0xf0,  //.............+%@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5b, 0xff, 0xf0,  //................+%@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0xd0,  //...................+@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+003d (=) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+003e (>) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xd7, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+...................
    0xff, 0xfb, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%+................
    0xff, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%+.............
    0x6b, 0xff, 0xff, 0xff, 0xe8, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //+%@@@@@@@%...........
    0x00, 0x17, 0xdf, 0xff, 0xff, 0xfc, 0x71, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@+........
    0x00, 0x00, 0x03, 0x9e, 0xff, 0xff, 0xff, 0xb5, 0x00, 0x00, 0x00,  //......%@@@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xff, 0xfa, 0x40, 0x00,  //........+%@@@@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xbf, 0xff, 0xff, 0xfe, 0x80,  //...........+%@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x7d, 0xff, 0xff, 0xf0,  //..............+@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x7d, 0xff, 0xff, 0xf0,  //..............+@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xbf, 0xff, 0xff, 0xfe, 0x80,  //...........+%@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xff, 0xfa, 0x40, 0x00,  //........+%@@@@@@@%+..
    0x00, 0x00, 0x03, 0x8e, 0xff, 0xff, 0xff, 0xb5, 0x00, 0x00, 0x00,  //......%@@@@@@@%+.....
    0x00, 0x17, 0xdf, 0xff, 0xff, 0xfd, 0x71, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@+........
    0x6b, 0xff, 0xff, 0xff, 0xe8, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //+%@@@@@@@%...........
    0xff, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%+.............
    0xff, 0xfb, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%+................
    0xd7, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+003f (?) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x49, 0xde, 0xfe, 0xb6, 0x00, 0x00,  //...%@@@@%+...
    0x4d, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x00,  //+@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@@.
    0xff, 0xc6, 0x20, 0x13, 0xaf, 0xff, 0x70,  //@@@+....%@@@+
    0xb3, 0x00, 0x00, 0x00, 0x09, 0xff, 0xd0,  //%........%@@@
    0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xe0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x60,  //.........@@@+
    0x00, 0x00, 0x00, 0x04, 0xff, 0xfc, 0x00,  //.......+@@@@.
    0x00, 0x00, 0x00, 0x4f, 0xff, 0xe1, 0x00,  //......+@@@@..
    0x00, 0x00, 0x03, 0xff, 0xfe, 0x20, 0x00,  //......@@@@...
    0x00, 0x00, 0x0e, 0xff, 0xd2, 0x00, 0x00,  //.....@@@@....
    0x00, 0x00, 0x8f, 0xfe, 0x10, 0x00, 0x00,  //....%@@@.....
    0x00, 0x00, 0xcf, 0xf5, 0x00, 0x00, 0x00,  //....@@@+.....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0040 (@) , Width: 30 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0xbd, 0xff, 0xfd, 0xb8, 0x30, 0x00, 0x00, 0x00, 0x00,  //...........+%@@@@@%%..........
    0x00, 0x00, 0x00, 0x00, 0x5d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x70, 0x00, 0x00, 0x00,  //........+@@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x4d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@@@+.....
    0x00, 0x00, 0x07, 0xff, 0xff, 0xf9, 0x52, 0x10, 0x02, 0x49, 0xef, 0xff, 0xf8, 0x00, 0x00,  //.....+@@@@@%+.....+%@@@@@+....
    0x00, 0x00, 0xaf, 0xff, 0xe7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xef, 0xff, 0x90, 0x00,  //....%@@@@+...........+@@@@%...
    0x00, 0x08, 0xff, 0xfb, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xf6, 0x00,  //...+@@@%...............%@@@+..
    0x00, 0x5f, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xff, 0x20,  //..+@@@%.................%@@@..
    0x00, 0xef, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xb0,  //..@@@%...................%@@%.
    0x07, 0xff, 0xd0, 0x00, 0x00, 0x06, 0xcf, 0xec, 0x60, 0x0f, 0xff, 0x00, 0x01, 0xff, 0xf2,  //.+@@@......+@@@@+..@@@....@@@.
    0x0e, 0xff, 0x50, 0x00, 0x00, 0xcf, 0xff, 0xff, 0xfa, 0x0f, 0xff, 0x00, 0x00, 0x9f, 0xf7,  //.@@@+.....@@@@@@@%.@@@....%@@+
    0x4f, 0xfd, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0x00, 0x00, 0x4f, 0xfc,  //+@@@.....%@@@@@@@@%@@@....+@@%
    0x9f, 0xf8, 0x00, 0x00, 0x4f, 0xff, 0xb3, 0x00, 0x3c, 0xff, 0xff, 0x00, 0x00, 0x1f, 0xfe,  //%@@%....+@@@%....%@@@@.....@@@
    0xcf, 0xf4, 0x00, 0x00, 0xaf, 0xfb, 0x00, 0x00, 0x00, 0xcf, 0xff, 0x00, 0x00, 0x0f, 0xff,  //@@@+....%@@%......%@@@.....@@@
    0xef, 0xf1, 0x00, 0x00, 0xdf, 0xf3, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x0f, 0xfe,  //@@@.....@@@........@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x3f, 0xfd,  //@@@.....@@@........@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x7f, 0xf9,  //@@@.....@@@........@@@....+@@%
    0xef, 0xf2, 0x00, 0x00, 0xdf, 0xf3, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x00, 0x01, 0xef, 0xf3,  //@@@.....@@@........@@@....@@@.
    0xcf, 0xf4, 0x00, 0x00, 0xaf, 0xfb, 0x00, 0x00, 0x00, 0xbf, 0xff, 0x00, 0x0c, 0xff, 0xb0,  //@@@+....%@@%......%@@@...@@@%.
    0x9f, 0xf8, 0x00, 0x00, 0x4f, 0xff, 0xb3, 0x00, 0x3b, 0xff, 0xff, 0x16, 0xef, 0xfd, 0x10,  //%@@%....+@@@%....%@@@@.+@@@@..
    0x5f, 0xfd, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xd2, 0x00,  //+@@@.....%@@@@@@@@%@@@@@@@@...
    0x0f, 0xff, 0x50, 0x00, 0x01, 0xcf, 0xff, 0xff, 0xfb, 0x0f, 0xff, 0xff, 0xe7, 0x00, 0x00,  //.@@@+.....@@@@@@@%.@@@@@@+....
    0x09, 0xff, 0xd0, 0x00, 0x00, 0x06, 0xcf, 0xfc, 0x60, 0x0f, 0xec, 0x95, 0x00, 0x00, 0x00,  //.%@@@......+@@@@+..@@@%+......
    0x01, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@%........................
    0x00, 0x7f, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@%.......................
    0x00, 0x0a, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x87, 0x00, 0x00, 0x00,  //...%@@@%..............%+......
    0x00, 0x00, 0xcf, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0x30, 0x00, 0x00,  //....@@@@@+..........+@@@......
    0x00, 0x00, 0x0a, 0xff, 0xff, 0xe9, 0x42, 0x10, 0x13, 0x7d, 0xff, 0xfc, 0x20, 0x00, 0x00,  //.....%@@@@@%+.....+@@@@@......
    0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@%.......
    0x00, 0x00, 0x00, 0x01, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb3, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@@@@@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0xce, 0xff, 0xeb, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+%@@@@@%+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................


    /*Unicode: U+0041 (A) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xfd, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x02, 0xff, 0xf2, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x08, 0xff, 0xb0, 0xaf, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x0e, 0xff, 0x40, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x00, 0x00, 0x4f, 0xfe, 0x00, 0x0e, 0xff, 0x40, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0xaf, 0xf8, 0x00, 0x08, 0xff, 0xa0, 0x00, 0x00, 0x00,  //......%@@%...%@@%......
    0x00, 0x00, 0x01, 0xff, 0xf2, 0x00, 0x02, 0xff, 0xf1, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x07, 0xff, 0xc0, 0x00, 0x00, 0xcf, 0xf7, 0x00, 0x00, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x00, 0x0d, 0xff, 0x60, 0x00, 0x00, 0x5f, 0xfd, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x09, 0xff, 0x90, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf5, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //..%@@@@@@@@@@@@@@@@@%..
    0x00, 0xef, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xe0, 0x00,  //..@@@+...........+@@@..
    0x04, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xf4, 0x00,  //.+@@@.............@@@+.
    0x0a, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfa, 0x00,  //.%@@%.............%@@%.
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@...............@@@.
    0x6f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@@...............@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0042 (B) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xeb, 0x82, 0x00, 0x00,  //@@@@@@@@@@@%%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //@@@@@@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //@@@@@@@@@@@@@@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x25, 0xcf, 0xff, 0x60,  //@@@........+@@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xc0,  //@@@..........%@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xf0,  //@@@...........@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@...........@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0x80,  //@@@..........%@@%.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x25, 0xcf, 0xfe, 0x10,  //@@@........+@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x00,  //@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00,  //@@@@@@@@@@@@@@@%..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x14, 0x8f, 0xff, 0x90,  //@@@.........%@@@%.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf3,  //@@@...........@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfa,  //@@@...........+@@%
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfd,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfd,  //@@@...........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf8,  //@@@...........@@@%
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x14, 0x8f, 0xff, 0xf1,  //@@@.........%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00,  //@@@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xed, 0x95, 0x00, 0x00,  //@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0043 (C) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x04, 0x8c, 0xdf, 0xfe, 0xda, 0x61, 0x00,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x05, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb3,  //.....+@@@@@@@@@@@@%.
    0x00, 0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x00, 0x0c, 0xff, 0xfe, 0x84, 0x10, 0x01, 0x48, 0xdf, 0xff,  //...@@@@@%+....+%@@@@
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x05, 0xdf,  //..%@@@+..........+@@
    0x05, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a,  //.+@@@+.............%
    0x0c, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%...............
    0x3f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x0c, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%...............
    0x05, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a,  //.+@@@+.............%
    0x00, 0xaf, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x05, 0xdf,  //..%@@@+..........+@@
    0x00, 0x0c, 0xff, 0xfe, 0x84, 0x10, 0x01, 0x48, 0xdf, 0xff,  //...@@@@@%+....+%@@@@
    0x00, 0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x00, 0x00, 0x05, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb3,  //.....+@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x04, 0x8c, 0xdf, 0xfe, 0xda, 0x61, 0x00,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+0044 (D) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xed, 0xb8, 0x51, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%%+........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@%+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x00, 0x00,  //@@@@@@@@@@@@@@@@%....
    0xff, 0xf0, 0x00, 0x00, 0x11, 0x47, 0xbf, 0xff, 0xfd, 0x10, 0x00,  //@@@........+%@@@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xaf, 0xff, 0xc0, 0x00,  //@@@...........%@@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xf6, 0x00,  //@@@............+@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfe, 0x00,  //@@@.............%@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x40,  //@@@..............@@@+
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x80,  //@@@..............%@@%
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xc0,  //@@@..............+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@...............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@...............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xc0,  //@@@..............+@@%
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x80,  //@@@..............%@@%
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x40,  //@@@..............@@@+
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfe, 0x00,  //@@@.............%@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xf6, 0x00,  //@@@............+@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xaf, 0xff, 0xc0, 0x00,  //@@@...........%@@@@..
    0xff, 0xf0, 0x00, 0x00, 0x01, 0x37, 0xbf, 0xff, 0xfd, 0x10, 0x00,  //@@@........+%@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x00, 0x00,  //@@@@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@%+.....
    0xff, 0xff, 0xff, 0xff, 0xed, 0xb8, 0x51, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0045 (E) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0046 (F) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0047 (G) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x03, 0x8b, 0xde, 0xfe, 0xeb, 0x85, 0x00, 0x00,  //........+%@@@@@%%+....
    0x00, 0x00, 0x05, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x30,  //.....+@@@@@@@@@@@@@%..
    0x00, 0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //....%@@@@@@@@@@@@@@@@.
    0x00, 0x0c, 0xff, 0xfe, 0x85, 0x20, 0x01, 0x26, 0xaf, 0xff, 0xf0,  //...@@@@@%+.....+%@@@@.
    0x00, 0xaf, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x01, 0x7e, 0xf0,  //..%@@@+...........+@@.
    0x05, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xa0,  //.+@@@+..............%.
    0x0d, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@+.................
    0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@..................
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%..................
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+..................
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...................
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,  //@@@...........@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,  //@@@...........@@@@@@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,  //@@@...........@@@@@@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@................@@@
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //%@@+...............@@@
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //+@@%...............@@@
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.@@@...............@@@
    0x0c, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.@@@%..............@@@
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.+@@@+.............@@@
    0x00, 0xaf, 0xff, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,  //..%@@@%............@@@
    0x00, 0x0c, 0xff, 0xff, 0xa6, 0x21, 0x00, 0x13, 0x5a, 0xff, 0xff,  //...@@@@@%+......+%@@@@
    0x00, 0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4,  //....%@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x04, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd7, 0x00,  //.....+@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x03, 0x7b, 0xde, 0xfe, 0xdb, 0x84, 0x00, 0x00,  //........+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+0048 (H) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0049 (I) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+004a (J) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xfe,  //...@@@
    0x00, 0x2f, 0xfd,  //...@@@
    0x00, 0x5f, 0xfb,  //..+@@%
    0x00, 0xcf, 0xf7,  //..@@@+
    0x3b, 0xff, 0xf2,  //.%@@@.
    0xff, 0xff, 0xa0,  //@@@@%.
    0xff, 0xfb, 0x00,  //@@@%..
    0xeb, 0x50, 0x00,  //@%+...
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+004b (K) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xdf, 0xff, 0x70,  //@@@...........@@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xf5, 0x00,  //@@@..........@@@@+..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x03, 0xef, 0xff, 0x40, 0x00,  //@@@.........@@@@+...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xe3, 0x00, 0x00,  //@@@.......+@@@@.....
    0xff, 0xf0, 0x00, 0x00, 0x06, 0xff, 0xfe, 0x20, 0x00, 0x00,  //@@@......+@@@@......
    0xff, 0xf0, 0x00, 0x00, 0x7f, 0xff, 0xd1, 0x00, 0x00, 0x00,  //@@@.....+@@@@.......
    0xff, 0xf0, 0x00, 0x08, 0xff, 0xfc, 0x10, 0x00, 0x00, 0x00,  //@@@....%@@@@........
    0xff, 0xf0, 0x00, 0xaf, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //@@@...%@@@%.........
    0xff, 0xf0, 0x0b, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..%@@@%..........
    0xff, 0xf1, 0xcf, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.@@@@%...........
    0xff, 0xfd, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@%............
    0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%.............
    0xff, 0xff, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@.............
    0xff, 0xf3, 0xef, 0xfe, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.@@@@............
    0xff, 0xf0, 0x3e, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..@@@@...........
    0xff, 0xf0, 0x02, 0xef, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00,  //@@@...@@@@..........
    0xff, 0xf0, 0x00, 0x2e, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00,  //@@@....@@@@+........
    0xff, 0xf0, 0x00, 0x02, 0xef, 0xff, 0x40, 0x00, 0x00, 0x00,  //@@@.....@@@@+.......
    0xff, 0xf0, 0x00, 0x00, 0x2d, 0xff, 0xf5, 0x00, 0x00, 0x00,  //@@@......@@@@+......
    0xff, 0xf0, 0x00, 0x00, 0x01, 0xdf, 0xff, 0x50, 0x00, 0x00,  //@@@.......@@@@+.....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xf5, 0x00, 0x00,  //@@@........@@@@+....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xff, 0x60, 0x00,  //@@@.........@@@@+...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xf6, 0x00,  //@@@..........@@@@+..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0x70,  //@@@...........@@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xf7,  //@@@............@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+004c (L) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+004d (M) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xff, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xf0,  //@@@@@.............@@@@@
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xf0,  //@@@@@%...........%@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xf0,  //@@@@@@...........@@@@@@
    0xff, 0xfc, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc, 0xff, 0xf0,  //@@@@@@+.........+@@@@@@
    0xff, 0xf6, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf6, 0xff, 0xf0,  //@@@+@@@.........@@@+@@@
    0xff, 0xf0, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0, 0xff, 0xf0,  //@@@.@@@.........@@@.@@@
    0xff, 0xf0, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x09, 0xff, 0x90, 0xff, 0xf0,  //@@@.%@@%.......%@@%.@@@
    0xff, 0xf0, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x30, 0xff, 0xf0,  //@@@..@@@.......@@@..@@@
    0xff, 0xf0, 0x0d, 0xff, 0x60, 0x00, 0x00, 0x6f, 0xfd, 0x00, 0xff, 0xf0,  //@@@..@@@+.....+@@@..@@@
    0xff, 0xf0, 0x06, 0xff, 0xc0, 0x00, 0x00, 0xcf, 0xf6, 0x00, 0xff, 0xf0,  //@@@..+@@@.....@@@+..@@@
    0xff, 0xf0, 0x01, 0xff, 0xf2, 0x00, 0x03, 0xff, 0xf1, 0x00, 0xff, 0xf0,  //@@@...@@@.....@@@...@@@
    0xff, 0xf0, 0x00, 0xaf, 0xf9, 0x00, 0x09, 0xff, 0xa0, 0x00, 0xff, 0xf0,  //@@@...%@@%...%@@%...@@@
    0xff, 0xf0, 0x00, 0x3f, 0xfe, 0x00, 0x0f, 0xff, 0x30, 0x00, 0xff, 0xf0,  //@@@....@@@...@@@....@@@
    0xff, 0xf0, 0x00, 0x0d, 0xff, 0x50, 0x6f, 0xfd, 0x00, 0x00, 0xff, 0xf0,  //@@@....@@@+.+@@@....@@@
    0xff, 0xf0, 0x00, 0x07, 0xff, 0xc0, 0xcf, 0xf7, 0x00, 0x00, 0xff, 0xf0,  //@@@....+@@@.@@@+....@@@
    0xff, 0xf0, 0x00, 0x01, 0xff, 0xf5, 0xff, 0xf1, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@+@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xaf, 0xff, 0xff, 0xa0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....%@@@@@%.....@@@
    0xff, 0xf0, 0x00, 0x00, 0x4f, 0xff, 0xff, 0x40, 0x00, 0x00, 0xff, 0xf0,  //@@@......@@@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0d, 0xff, 0xfd, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@......@@@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x07, 0xff, 0xf7, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@......+@@@+......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+004e (N) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@%...........@@@
    0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@...........@@@
    0xff, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@%..........@@@
    0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@@..........@@@
    0xff, 0xf9, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@%@@@.........@@@
    0xff, 0xf1, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.@@@+........@@@
    0xff, 0xf0, 0x8f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.+@@@........@@@
    0xff, 0xf0, 0x0e, 0xff, 0x70, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@..@@@+.......@@@
    0xff, 0xf0, 0x06, 0xff, 0xe1, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@..+@@@.......@@@
    0xff, 0xf0, 0x00, 0xdf, 0xf8, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...@@@%......@@@
    0xff, 0xf0, 0x00, 0x4f, 0xff, 0x10, 0x00, 0x00, 0xff, 0xf0,  //@@@...+@@@......@@@
    0xff, 0xf0, 0x00, 0x0c, 0xff, 0xa0, 0x00, 0x00, 0xff, 0xf0,  //@@@....%@@%.....@@@
    0xff, 0xf0, 0x00, 0x03, 0xff, 0xf3, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xaf, 0xfb, 0x00, 0x00, 0xff, 0xf0,  //@@@.....%@@%....@@@
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xff, 0x40, 0x00, 0xff, 0xf0,  //@@@......@@@+...@@@
    0xff, 0xf0, 0x00, 0x00, 0x08, 0xff, 0xd0, 0x00, 0xff, 0xf0,  //@@@......%@@@...@@@
    0xff, 0xf0, 0x00, 0x00, 0x01, 0xef, 0xf6, 0x00, 0xff, 0xf0,  //@@@.......@@@+..@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0xff, 0xf0,  //@@@.......+@@@..@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x70, 0xff, 0xf0,  //@@@........@@@+.@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf1, 0xff, 0xf0,  //@@@........+@@@.@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf9, 0xff, 0xf0,  //@@@.........@@@%@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0xff, 0xf0,  //@@@.........+@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xff, 0xf0,  //@@@..........%@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xf0,  //@@@...........@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xff, 0xf0,  //@@@...........%@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+004f (O) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x0d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xa0, 0x00,  //..%@@@%.........+@@@%..
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xf5, 0x00,  //.+@@@+...........+@@@+.
    0x0c, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfc, 0x00,  //.@@@%.............%@@@.
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //.@@@...............@@@.
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //+@@%...............%@@+
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+...............+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.................@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.................@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.................@@@
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+...............+@@%
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //+@@%...............%@@+
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //.@@@...............@@@.
    0x0d, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfd, 0x00,  //.@@@%.............%@@@.
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf5, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xb0, 0x00,  //..%@@@+.........+@@@%..
    0x00, 0x1d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x10, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x07, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0050 (P) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xa6, 0x00, 0x00,  //@@@@@@@@@@%+....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe5, 0x00,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@@@@@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x03, 0x8f, 0xff, 0xf1,  //@@@.......%@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf8,  //@@@.........@@@%
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc,  //@@@.........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc,  //@@@.........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf8,  //@@@.........@@@%
    0xff, 0xf0, 0x00, 0x00, 0x03, 0x8f, 0xff, 0xf1,  //@@@.......%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xa6, 0x00, 0x00,  //@@@@@@@@@@%+....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0051 (Q) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x01, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x0d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x10, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0xb0, 0x00,  //..%@@@%.........+@@@%..
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xf5, 0x00,  //.+@@@+...........+@@@+.
    0x0c, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfd, 0x00,  //.@@@%.............%@@@.
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //.@@@...............@@@.
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x70,  //+@@%...............%@@+
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+...............+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.................@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.................@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.................@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf0,  //@@@.................@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.................@@@
    0xbf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xb0,  //%@@+...............+@@%
    0x7f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x80,  //+@@%...............%@@%
    0x3f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x30,  //.@@@...............@@@.
    0x0c, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfd, 0x00,  //.@@@%.............%@@@.
    0x05, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf5, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0xaf, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xb0, 0x00,  //..%@@@+.........+@@@%..
    0x00, 0x0d, 0xff, 0xfe, 0x73, 0x10, 0x13, 0x7d, 0xff, 0xfd, 0x10, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x01, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x05, 0x9d, 0xef, 0xff, 0xff, 0xe1, 0x00, 0x00, 0x00,  //.......+%@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0xfd, 0x10, 0x00, 0x00,  //..............@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xc0, 0x00, 0x00,  //...............@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xfa, 0x00, 0x00,  //...............+@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x90, 0x00,  //................+@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0052 (R) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0xff, 0xfe, 0xb7, 0x10, 0x00, 0x00, 0x00,  //@@@@@@@@@@%+.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00,  //@@@@@@@@@@@@@@%....
    0xff, 0xf0, 0x00, 0x00, 0x02, 0x6e, 0xff, 0xf4, 0x00, 0x00,  //@@@.......+@@@@+...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xfa, 0x00, 0x00,  //@@@.........@@@%...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xfd, 0x00, 0x00,  //@@@.........+@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xfc, 0x00, 0x00,  //@@@.........+@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xf8, 0x00, 0x00,  //@@@.........@@@%...
    0xff, 0xf0, 0x00, 0x00, 0x02, 0x6e, 0xff, 0xf1, 0x00, 0x00,  //@@@.......+@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00,  //@@@@@@@@@@@@@@+....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@%......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@+.....
    0xff, 0xf0, 0x00, 0x00, 0x27, 0xef, 0xff, 0x20, 0x00, 0x00,  //@@@......+@@@@.....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xb0, 0x00, 0x00,  //@@@........@@@%....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf4, 0x00, 0x00,  //@@@.........@@@+...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfb, 0x00, 0x00,  //@@@.........%@@%...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x20, 0x00,  //@@@..........@@@...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0x90, 0x00,  //@@@..........%@@%..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf1, 0x00,  //@@@...........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf7, 0x00,  //@@@...........@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfe, 0x00,  //@@@...........+@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x50,  //@@@............@@@+
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xc0,  //@@@............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0053 (S) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x59, 0xde, 0xff, 0xed, 0xb8, 0x51, 0x00,  //....+%@@@@@@%%+..
    0x00, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.+@@@@@@@@@@@@@@.
    0x2f, 0xff, 0xe8, 0x31, 0x00, 0x12, 0x47, 0xae, 0x00,  //.@@@@%......++%@.
    0x9f, 0xfc, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@.............
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xcf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%.............
    0x6f, 0xff, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@%............
    0x0c, 0xff, 0xff, 0xeb, 0x85, 0x10, 0x00, 0x00, 0x00,  //.@@@@@@%%+.......
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xfd, 0x81, 0x00, 0x00,  //..%@@@@@@@@@%....
    0x00, 0x02, 0x9e, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00,  //....%@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x15, 0x8b, 0xff, 0xff, 0xf8, 0x00,  //.......+%%@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xdf, 0xff, 0x30,  //...........+@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xa0,  //.............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //.............+@@@
    0xc5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x80,  //@+...........@@@%
    0xff, 0xfa, 0x63, 0x10, 0x01, 0x49, 0xff, 0xff, 0x10,  //@@@%+.....+%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00,  //@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x30, 0x00,  //@@@@@@@@@@@@@@...
    0x15, 0x8a, 0xce, 0xff, 0xfe, 0xc9, 0x40, 0x00, 0x00,  //.++%@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0054 (T) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0055 (U) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.............@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.............@@@
    0xdf, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xc0,  //@@@+...........+@@@
    0x9f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0x90,  //%@@%...........%@@%
    0x5f, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x50,  //+@@@...........@@@+
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.........%@@@.
    0x05, 0xff, 0xfe, 0x73, 0x00, 0x03, 0x7e, 0xff, 0xf5, 0x00,  //.+@@@@+.....+@@@@+.
    0x00, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //..%@@@@@@@@@@@@@%..
    0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00, 0x00,  //...+@@@@@@@@@@@+...
    0x00, 0x00, 0x06, 0xad, 0xef, 0xed, 0xa6, 0x00, 0x00, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0056 (V) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+...............+@@@
    0x6f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@@...............@@@+
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@...............@@@.
    0x0a, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xfa, 0x00,  //.%@@%.............%@@%.
    0x04, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 0xf4, 0x00,  //.+@@@.............@@@+.
    0x00, 0xef, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xe0, 0x00,  //..@@@+...........+@@@..
    0x00, 0x8f, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x80, 0x00,  //..%@@%...........%@@%..
    0x00, 0x2f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x20, 0x00,  //...@@@...........@@@...
    0x00, 0x0b, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfb, 0x00, 0x00,  //...%@@+.........+@@%...
    0x00, 0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xf5, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x00, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00, 0x09, 0xff, 0x90, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x0d, 0xff, 0x60, 0x00, 0x00, 0x5f, 0xfd, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x07, 0xff, 0xc0, 0x00, 0x00, 0xcf, 0xf7, 0x00, 0x00, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x00, 0x01, 0xff, 0xf2, 0x00, 0x02, 0xff, 0xf1, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x00, 0xaf, 0xf8, 0x00, 0x08, 0xff, 0xa0, 0x00, 0x00, 0x00,  //......%@@%...%@@%......
    0x00, 0x00, 0x00, 0x4f, 0xfe, 0x00, 0x0e, 0xff, 0x40, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0x0e, 0xff, 0x40, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x00, 0x00, 0x08, 0xff, 0xb0, 0xaf, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x02, 0xff, 0xf2, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xfd, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0057 (W) , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0xef, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@..........@@@@@..........@@@
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x07, 0xff, 0x90,  //%@@+.........@@@@@.........+@@%
    0x6f, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x60,  //+@@%........+@@@@@+........%@@+
    0x2f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfe, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x20,  //.@@@........%@@@@@%........@@@.
    0x0e, 0xff, 0x30, 0x00, 0x00, 0x00, 0xdf, 0xf6, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x2f, 0xfe, 0x00,  //.@@@........@@@+@@@........@@@.
    0x0a, 0xff, 0x70, 0x00, 0x00, 0x01, 0xff, 0xf0, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x6f, 0xfa, 0x00,  //.%@@+.......@@@.@@@.......+@@%.
    0x06, 0xff, 0xa0, 0x00, 0x00, 0x05, 0xff, 0xb0, 0xbf, 0xf5, 0x00, 0x00, 0x00, 0xaf, 0xf6, 0x00,  //.+@@%......+@@%.%@@+......%@@+.
    0x02, 0xff, 0xe0, 0x00, 0x00, 0x09, 0xff, 0x80, 0x7f, 0xf9, 0x00, 0x00, 0x00, 0xef, 0xf2, 0x00,  //..@@@......%@@+.+@@%......@@@..
    0x00, 0xef, 0xf2, 0x00, 0x00, 0x0d, 0xff, 0x40, 0x3f, 0xfd, 0x00, 0x00, 0x02, 0xff, 0xe0, 0x00,  //..@@@......@@@+..@@@......@@@..
    0x00, 0xaf, 0xf6, 0x00, 0x00, 0x1f, 0xff, 0x00, 0x0f, 0xff, 0x10, 0x00, 0x06, 0xff, 0xa0, 0x00,  //..%@@+.....@@@...@@@.....+@@%..
    0x00, 0x6f, 0xfa, 0x00, 0x00, 0x4f, 0xfc, 0x00, 0x0c, 0xff, 0x40, 0x00, 0x0a, 0xff, 0x60, 0x00,  //..+@@%....+@@@...@@@+....%@@+..
    0x00, 0x2f, 0xfe, 0x00, 0x00, 0x8f, 0xf8, 0x00, 0x08, 0xff, 0x80, 0x00, 0x0e, 0xff, 0x20, 0x00,  //...@@@....%@@%...%@@%....@@@...
    0x00, 0x0e, 0xff, 0x20, 0x00, 0xcf, 0xf4, 0x00, 0x04, 0xff, 0xc0, 0x00, 0x2f, 0xfe, 0x00, 0x00,  //...@@@....@@@+...+@@@....@@@...
    0x00, 0x0a, 0xff, 0x60, 0x00, 0xff, 0xf1, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x6f, 0xfa, 0x00, 0x00,  //...%@@+...@@@.....@@@...+@@%...
    0x00, 0x06, 0xff, 0xa0, 0x04, 0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf4, 0x00, 0xaf, 0xf6, 0x00, 0x00,  //...+@@%...@@@.....@@@+..%@@+...
    0x00, 0x03, 0xff, 0xe0, 0x07, 0xff, 0x90, 0x00, 0x00, 0x9f, 0xf8, 0x00, 0xef, 0xf2, 0x00, 0x00,  //....@@@..+@@%.....%@@+..@@@....
    0x00, 0x00, 0xef, 0xf2, 0x0b, 0xff, 0x50, 0x00, 0x00, 0x5f, 0xfb, 0x02, 0xff, 0xe0, 0x00, 0x00,  //....@@@..%@@+.....+@@%..@@@....
    0x00, 0x00, 0xbf, 0xf6, 0x0f, 0xff, 0x10, 0x00, 0x00, 0x1f, 0xff, 0x06, 0xff, 0xa0, 0x00, 0x00,  //....%@@+.@@@.......@@@.+@@%....
    0x00, 0x00, 0x7f, 0xfa, 0x3f, 0xfd, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x3a, 0xff, 0x70, 0x00, 0x00,  //....+@@%.@@@.......@@@.%@@+....
    0x00, 0x00, 0x3f, 0xfe, 0x7f, 0xf9, 0x00, 0x00, 0x00, 0x09, 0xff, 0x7e, 0xff, 0x30, 0x00, 0x00,  //.....@@@+@@%.......%@@+@@@.....
    0x00, 0x00, 0x0f, 0xff, 0xdf, 0xf5, 0x00, 0x00, 0x00, 0x06, 0xff, 0xdf, 0xfe, 0x00, 0x00, 0x00,  //.....@@@@@@+.......+@@@@@@.....
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfb, 0x00, 0x00, 0x00,  //.....%@@@@@.........@@@@@%.....
    0x00, 0x00, 0x07, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xef, 0xff, 0xf7, 0x00, 0x00, 0x00,  //.....+@@@@@.........@@@@@+.....
    0x00, 0x00, 0x03, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xf3, 0x00, 0x00, 0x00,  //......@@@@%.........%@@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@@+.........+@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+0058 (X) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x0a, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xfa, 0x00,  //.%@@@...........@@@%.
    0x01, 0xef, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xe1, 0x00,  //..@@@%.........%@@@..
    0x00, 0x5f, 0xff, 0x30, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x50, 0x00,  //..+@@@.........@@@+..
    0x00, 0x0b, 0xff, 0xd0, 0x00, 0x00, 0x00, 0xdf, 0xfb, 0x00, 0x00,  //...%@@@.......@@@%...
    0x00, 0x01, 0xff, 0xf8, 0x00, 0x00, 0x08, 0xff, 0xe1, 0x00, 0x00,  //....@@@%.....%@@@....
    0x00, 0x00, 0x6f, 0xff, 0x30, 0x00, 0x3f, 0xff, 0x60, 0x00, 0x00,  //....+@@@.....@@@+....
    0x00, 0x00, 0x0b, 0xff, 0xd0, 0x00, 0xdf, 0xfb, 0x00, 0x00, 0x00,  //.....%@@@...@@@%.....
    0x00, 0x00, 0x02, 0xff, 0xf8, 0x08, 0xff, 0xf1, 0x00, 0x00, 0x00,  //......@@@%.%@@@......
    0x00, 0x00, 0x00, 0x7f, 0xff, 0x6f, 0xff, 0x60, 0x00, 0x00, 0x00,  //......+@@@+@@@+......
    0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@%.......
    0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //........@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //........%@@@+........
    0x00, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //........@@@@@........
    0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@+.......
    0x00, 0x00, 0x00, 0x2f, 0xff, 0xdf, 0xff, 0x20, 0x00, 0x00, 0x00,  //.......@@@@@@@.......
    0x00, 0x00, 0x00, 0xcf, 0xfc, 0x0d, 0xff, 0xc0, 0x00, 0x00, 0x00,  //......@@@@.@@@%......
    0x00, 0x00, 0x06, 0xff, 0xf2, 0x03, 0xff, 0xf6, 0x00, 0x00, 0x00,  //.....+@@@...@@@+.....
    0x00, 0x00, 0x2f, 0xff, 0x70, 0x00, 0x8f, 0xff, 0x10, 0x00, 0x00,  //.....@@@+...%@@@.....
    0x00, 0x00, 0xbf, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0xb0, 0x00, 0x00,  //....%@@@.....@@@%....
    0x00, 0x06, 0xff, 0xf3, 0x00, 0x00, 0x03, 0xff, 0xf6, 0x00, 0x00,  //...+@@@.......@@@+...
    0x00, 0x1e, 0xff, 0x80, 0x00, 0x00, 0x00, 0x9f, 0xfe, 0x10, 0x00,  //...@@@%.......%@@@...
    0x00, 0xbf, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xb0, 0x00,  //..%@@@.........@@@%..
    0x05, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xf5, 0x00,  //.+@@@..........+@@@+.
    0x1e, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f, 0xfe, 0x10,  //.@@@%...........%@@@.
    0xaf, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xa0,  //%@@@.............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0059 (Y) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xaf, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xa0,  //%@@@.............@@@%
    0x1e, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xfe, 0x10,  //.@@@%...........%@@@.
    0x04, 0xff, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf4, 0x00,  //.+@@@+.........+@@@+.
    0x00, 0x9f, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x90, 0x00,  //..%@@@.........@@@%..
    0x00, 0x0d, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfd, 0x00, 0x00,  //...@@@%.......%@@@...
    0x00, 0x03, 0xff, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xf3, 0x00, 0x00,  //....@@@+.....+@@@....
    0x00, 0x00, 0x8f, 0xff, 0x20, 0x00, 0x2f, 0xff, 0x80, 0x00, 0x00,  //....%@@@.....@@@%....
    0x00, 0x00, 0x0d, 0xff, 0xc0, 0x00, 0xcf, 0xfd, 0x00, 0x00, 0x00,  //.....@@@@...@@@@.....
    0x00, 0x00, 0x02, 0xff, 0xf7, 0x07, 0xff, 0xf2, 0x00, 0x00, 0x00,  //......@@@+.+@@@......
    0x00, 0x00, 0x00, 0x7f, 0xff, 0x6f, 0xff, 0x70, 0x00, 0x00, 0x00,  //......+@@@+@@@+......
    0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@.......
    0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //........@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00,  //........+@@@+........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+005a (Z) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f, 0xff, 0x40,  //..............%@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xf8, 0x00,  //.............+@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xb0, 0x00,  //.............@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xfe, 0x10, 0x00,  //............@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0xf3, 0x00, 0x00,  //...........%@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x70, 0x00, 0x00,  //..........+@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xfa, 0x00, 0x00, 0x00,  //..........@@@%......
    0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xd0, 0x00, 0x00, 0x00,  //.........@@@@.......
    0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0x20, 0x00, 0x00, 0x00,  //........%@@@........
    0x00, 0x00, 0x00, 0x06, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00,  //.......+@@@+........
    0x00, 0x00, 0x00, 0x3f, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00,  //.......@@@%.........
    0x00, 0x00, 0x01, 0xdf, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@..........
    0x00, 0x00, 0x0b, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@...........
    0x00, 0x00, 0x7f, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@+...........
    0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@%............
    0x00, 0x1e, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@.............
    0x00, 0xbf, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@..............
    0x08, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@+..............
    0x4f, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@+...............
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+005b ([) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xf0, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+005c (\) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xdf, 0xf4, 0x00, 0x00, 0x00, 0x00,  //@@@+.......
    0x9f, 0xf8, 0x00, 0x00, 0x00, 0x00,  //%@@%.......
    0x4f, 0xfd, 0x00, 0x00, 0x00, 0x00,  //+@@@.......
    0x0f, 0xff, 0x10, 0x00, 0x00, 0x00,  //.@@@.......
    0x0b, 0xff, 0x60, 0x00, 0x00, 0x00,  //.%@@+......
    0x07, 0xff, 0xa0, 0x00, 0x00, 0x00,  //.+@@%......
    0x02, 0xff, 0xe0, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xef, 0xf3, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0x9f, 0xf8, 0x00, 0x00, 0x00,  //..%@@%.....
    0x00, 0x5f, 0xfc, 0x00, 0x00, 0x00,  //..+@@@.....
    0x00, 0x0f, 0xff, 0x10, 0x00, 0x00,  //...@@@.....
    0x00, 0x0c, 0xff, 0x50, 0x00, 0x00,  //...@@@+....
    0x00, 0x07, 0xff, 0xa0, 0x00, 0x00,  //...+@@%....
    0x00, 0x03, 0xff, 0xe0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xef, 0xf3, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xaf, 0xf7, 0x00, 0x00,  //....%@@+...
    0x00, 0x00, 0x5f, 0xfc, 0x00, 0x00,  //....+@@@...
    0x00, 0x00, 0x1f, 0xff, 0x00, 0x00,  //.....@@@...
    0x00, 0x00, 0x0c, 0xff, 0x50, 0x00,  //.....@@@+..
    0x00, 0x00, 0x08, 0xff, 0x90, 0x00,  //.....+@@%..
    0x00, 0x00, 0x03, 0xff, 0xe0, 0x00,  //......@@@..
    0x00, 0x00, 0x00, 0xef, 0xf2, 0x00,  //......@@@..
    0x00, 0x00, 0x00, 0xaf, 0xf7, 0x00,  //......%@@+.
    0x00, 0x00, 0x00, 0x6f, 0xfb, 0x00,  //......+@@%.
    0x00, 0x00, 0x00, 0x1f, 0xff, 0x00,  //.......@@@.
    0x00, 0x00, 0x00, 0x0d, 0xff, 0x40,  //.......@@@+
    0x00, 0x00, 0x00, 0x08, 0xff, 0x90,  //.......%@@%
    0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+005d (]) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0x00, 0x00, 0xff, 0xf0,  //....@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+005e (^) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x9f, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00,  //........%@@@%........
    0x00, 0x00, 0x00, 0x09, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00,  //.......%@@@@@%.......
    0x00, 0x00, 0x00, 0x9f, 0xff, 0xdf, 0xff, 0x90, 0x00, 0x00, 0x00,  //......%@@@@@@@%......
    0x00, 0x00, 0x08, 0xff, 0xf8, 0x08, 0xff, 0xf8, 0x00, 0x00, 0x00,  //.....%@@@+.%@@@%.....
    0x00, 0x00, 0x8f, 0xff, 0x60, 0x00, 0x6f, 0xff, 0x80, 0x00, 0x00,  //....%@@@+...+@@@%....
    0x00, 0x08, 0xff, 0xf4, 0x00, 0x00, 0x04, 0xff, 0xf8, 0x00, 0x00,  //...%@@@+.....+@@@%...
    0x00, 0x8f, 0xfe, 0x30, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x80, 0x00,  //..%@@@.........@@@%..
    0x08, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x02, 0xdf, 0xf8, 0x00,  //.%@@@...........@@@%.
    0x8f, 0xfc, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x80,  //+@@@.............@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+005f (_) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0060 (`) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x8f, 0xfa, 0x00, 0x00,  //%@@%....
    0x0a, 0xff, 0x70, 0x00,  //.%@@+...
    0x00, 0xbf, 0xf4, 0x00,  //..%@@+..
    0x00, 0x0c, 0xfe, 0x10,  //...@@@..
    0x00, 0x01, 0xdf, 0xc0,  //....@@@.
    0x00, 0x00, 0x1e, 0xf9,  //.....@@%
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0061 (a) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x02, 0x8b, 0xef, 0xed, 0xa5, 0x00, 0x00,  //....%%@@@@%+....
    0x04, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x00,  //..%@@@@@@@@@@...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //.@@@@@@@@@@@@@..
    0x0f, 0xfb, 0x62, 0x10, 0x03, 0x8e, 0xff, 0xe0,  //.@@%+.....+@@@@.
    0x0b, 0x20, 0x00, 0x00, 0x00, 0x01, 0xdf, 0xf5,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xfa,  //............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfd,  //.............@@@
    0x00, 0x02, 0x7b, 0xef, 0xff, 0xff, 0xff, 0xfe,  //....+%@@@@@@@@@@
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@@@@
    0x0c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x6f, 0xff, 0xb6, 0x31, 0x00, 0x00, 0x0f, 0xff,  //+@@@%+.......@@@
    0xcf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,  //@@@%.........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff,  //@@@.........+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xff,  //@@@.........@@@@
    0xdf, 0xf7, 0x00, 0x00, 0x00, 0x09, 0xff, 0xff,  //@@@+.......%@@@@
    0x9f, 0xff, 0x93, 0x10, 0x16, 0xdf, 0xff, 0xff,  //%@@@%....+@@@@@@
    0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,  //.@@@@@@@@@@@%@@@
    0x03, 0xef, 0xff, 0xff, 0xff, 0xf8, 0x0f, 0xff,  //..@@@@@@@@@+.@@@
    0x00, 0x17, 0xce, 0xfe, 0xc8, 0x20, 0x0f, 0xff,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0062 (b) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x03, 0x9d, 0xef, 0xd9, 0x30, 0x00, 0x00,  //@@@...%@@@@%.....
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //@@@.%@@@@@@@@%...
    0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //@@@%@@@@@@@@@@%..
    0xff, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //@@@@%.......%@@@.
    0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x50,  //@@@@.........@@@+
    0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0,  //@@@+.........+@@%
    0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0,  //@@@+.........+@@%
    0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x50,  //@@@@.........@@@+
    0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //@@@@%.......%@@@.
    0xff, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //@@@%@@@@@@@@@@%..
    0xff, 0xf0, 0x9f, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //@@@.%@@@@@@@@%...
    0xff, 0xf0, 0x03, 0x9d, 0xff, 0xd9, 0x30, 0x00, 0x00,  //@@@...%@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0063 (c) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x04, 0x9d, 0xef, 0xfd, 0xb7, 0x20,  //.....+%@@@@@%+.
    0x00, 0x03, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf0,  //....@@@@@@@@@@@
    0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..+@@@@@@@@@@@@
    0x03, 0xff, 0xff, 0x94, 0x10, 0x02, 0x48, 0xd0,  //..@@@@%.....+%@
    0x0d, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@..........
    0x4f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@...........
    0x9f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%...........
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0x9f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%...........
    0x4f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@...........
    0x0d, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@..........
    0x03, 0xff, 0xff, 0x83, 0x10, 0x02, 0x48, 0xd0,  //..@@@@%.....+%@
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..+@@@@@@@@@@@@
    0x00, 0x04, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf0,  //....@@@@@@@@@@@
    0x00, 0x00, 0x05, 0xad, 0xef, 0xfd, 0xb7, 0x20,  //.....+%@@@@@%+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0064 (d) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x39, 0xdf, 0xed, 0x93, 0x00, 0xff, 0xf0,  //.....%@@@@%...@@@
    0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0x80, 0xff, 0xf0,  //...%@@@@@@@@%.@@@
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xf0,  //..%@@@@@@@@@@%@@@
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xff, 0xf0,  //.+@@@@+...+@@@@@@
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xf0,  //.@@@%.......%@@@@
    0x5f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xf0,  //+@@@.........@@@@
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xf0,  //%@@+.........+@@@
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf0,  //@@@...........@@@
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0,  //@@@...........@@@
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xf0,  //%@@+.........+@@@
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xf0,  //+@@@.........@@@@
    0x0e, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xf0,  //.@@@%.......%@@@@
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xff, 0xf0,  //.+@@@@+...+@@@@@@
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xf0,  //..%@@@@@@@@@@%@@@
    0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0x90, 0xff, 0xf0,  //...%@@@@@@@@%.@@@
    0x00, 0x00, 0x39, 0xdf, 0xfd, 0x93, 0x00, 0xff, 0xf0,  //.....%@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0065 (e) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x50, 0x00, 0x00,  //.....+%@@@@%+....
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfd, 0x20, 0x00,  //...+@@@@@@@@@@...
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00,  //..+@@@@@@@@@@@@..
    0x04, 0xff, 0xfb, 0x51, 0x00, 0x27, 0xef, 0xfc, 0x00,  //..@@@%+....+@@@@.
    0x0d, 0xff, 0x50, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x50,  //.@@@+........@@@+
    0x4f, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xa0,  //+@@%.........+@@%
    0x9f, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xd0,  //%@@...........@@@
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xaf, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0x5f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0x0d, 0xff, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x00,  //.@@@@..........%.
    0x04, 0xff, 0xfe, 0x83, 0x00, 0x13, 0x6c, 0xff, 0x00,  //.+@@@@%.....+@@@.
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x00, 0x04, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00,  //...+@@@@@@@@@@@+.
    0x00, 0x00, 0x05, 0xad, 0xef, 0xec, 0x83, 0x00, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0066 (f) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x04, 0xae, 0xff, 0xff,  //.....+%@@@@@
    0x00, 0x00, 0x9f, 0xff, 0xff, 0xff,  //....%@@@@@@@
    0x00, 0x05, 0xff, 0xff, 0xff, 0xff,  //...+@@@@@@@@
    0x00, 0x0b, 0xff, 0xb3, 0x00, 0x00,  //...%@@%.....
    0x00, 0x0e, 0xff, 0x20, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0067 (g) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x39, 0xdf, 0xed, 0x93, 0x00, 0xff, 0xf0,  //.....%@@@@%...@@@
    0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0x80, 0xff, 0xf0,  //...%@@@@@@@@%.@@@
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xf0,  //..%@@@@@@@@@@%@@@
    0x07, 0xff, 0xfc, 0x51, 0x01, 0x5c, 0xff, 0xff, 0xf0,  //.+@@@@+...+@@@@@@
    0x0f, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xf0,  //.@@@%.......%@@@@
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xf0,  //+@@@.........@@@@
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xf0,  //%@@+.........+@@@
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0,  //@@@...........@@@
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xf0,  //%@@+.........+@@@
    0x6f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xf0,  //+@@@.........@@@@
    0x0f, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xaf, 0xff, 0xf0,  //.@@@%.......%@@@@
    0x07, 0xff, 0xfc, 0x51, 0x01, 0x5c, 0xff, 0xff, 0xf0,  //.+@@@@+...+@@@@@@
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xf0,  //..%@@@@@@@@@@%@@@
    0x00, 0x0a, 0xff, 0xff, 0xff, 0xff, 0x80, 0xff, 0xe0,  //...%@@@@@@@@%.@@@
    0x00, 0x00, 0x39, 0xdf, 0xed, 0x93, 0x02, 0xff, 0xd0,  //.....%@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xa0,  //.............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x70,  //.............@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xff, 0x10,  //............%@@@.
    0x00, 0xd8, 0x42, 0x10, 0x02, 0x6d, 0xff, 0xf9, 0x00,  //..@%+.....+@@@@%.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00,  //..@@@@@@@@@@@@@..
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00,  //..@@@@@@@@@@@%...
    0x00, 0x27, 0xac, 0xef, 0xfe, 0xc8, 0x20, 0x00, 0x00,  //...+%@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0068 (h) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xf0, 0x02, 0x8c, 0xef, 0xeb, 0x50, 0x00,  //@@@...%@@@@%+...
    0xff, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0xfb, 0x00,  //@@@.+@@@@@@@@%..
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //@@@%@@@@@@@@@@%.
    0xff, 0xff, 0xfb, 0x41, 0x01, 0x4c, 0xff, 0xf3,  //@@@@@%+...+@@@@.
    0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0xdf, 0xf9,  //@@@@+.......@@@%
    0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfd,  //@@@%........+@@@
    0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@+.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0069 (i) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+006a (j) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x1f, 0xfe,  //...@@@
    0x00, 0x4f, 0xfc,  //..+@@%
    0x03, 0xdf, 0xf8,  //..@@@%
    0xff, 0xff, 0xf2,  //@@@@@.
    0xff, 0xff, 0x60,  //@@@@+.
    0xfe, 0xa3, 0x00,  //@@%...
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+006b (k) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0x60,  //@@@........+@@@@+
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xe4, 0x00,  //@@@.......+@@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x09, 0xff, 0xfd, 0x20, 0x00,  //@@@......%@@@@...
    0xff, 0xf0, 0x00, 0x01, 0xcf, 0xff, 0xb1, 0x00, 0x00,  //@@@.....@@@@%....
    0xff, 0xf0, 0x00, 0x2d, 0xff, 0xf9, 0x00, 0x00, 0x00,  //@@@....@@@@%.....
    0xff, 0xf0, 0x04, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00,  //@@@..+@@@@+......
    0xff, 0xf0, 0x6f, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00,  //@@@.+@@@@+.......
    0xff, 0xf9, 0xff, 0xfd, 0x20, 0x00, 0x00, 0x00, 0x00,  //@@@%@@@@.........
    0xff, 0xff, 0xff, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@..........
    0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@..........
    0xff, 0xf4, 0xff, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00,  //@@@+@@@@.........
    0xff, 0xf0, 0x4f, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x00,  //@@@.+@@@@........
    0xff, 0xf0, 0x03, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00,  //@@@...@@@@.......
    0xff, 0xf0, 0x00, 0x3e, 0xff, 0xf4, 0x00, 0x00, 0x00,  //@@@....@@@@+.....
    0xff, 0xf0, 0x00, 0x02, 0xef, 0xff, 0x40, 0x00, 0x00,  //@@@.....@@@@+....
    0xff, 0xf0, 0x00, 0x00, 0x2e, 0xff, 0xf5, 0x00, 0x00,  //@@@......@@@@+...
    0xff, 0xf0, 0x00, 0x00, 0x01, 0xdf, 0xff, 0x60, 0x00,  //@@@.......@@@@+..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x1d, 0xff, 0xf6, 0x00,  //@@@........@@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x01, 0xcf, 0xff, 0x70,  //@@@.........@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+006c (l) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+006d (m) , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0xff, 0xf0, 0x03, 0x9d, 0xfe, 0xc7, 0x00, 0x00, 0x03, 0x9d, 0xff, 0xc7, 0x00, 0x00,  //@@@...%@@@@+......%@@@@+...
    0xff, 0xf0, 0x9f, 0xff, 0xff, 0xff, 0xd1, 0x00, 0x8f, 0xff, 0xff, 0xff, 0xd1, 0x00,  //@@@.%@@@@@@@@...%@@@@@@@@..
    0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x09, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x00,  //@@@%@@@@@@@@@@.%@@@@@@@@@%.
    0xff, 0xff, 0xf9, 0x30, 0x03, 0xaf, 0xff, 0xbf, 0xf9, 0x30, 0x03, 0xaf, 0xff, 0x40,  //@@@@@%....%@@@%@@%....%@@@+
    0xff, 0xff, 0x50, 0x00, 0x00, 0x0b, 0xff, 0xff, 0x50, 0x00, 0x00, 0x0b, 0xff, 0x90,  //@@@@+......%@@@@+......%@@%
    0xff, 0xfa, 0x00, 0x00, 0x00, 0x04, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //@@@%.......+@@@%.......+@@@
    0xff, 0xf3, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.........@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+006e (n) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf0, 0x02, 0x8c, 0xef, 0xeb, 0x50, 0x00,  //@@@...%@@@@%+...
    0xff, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0xfb, 0x00,  //@@@.+@@@@@@@@%..
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //@@@%@@@@@@@@@@%.
    0xff, 0xff, 0xfb, 0x41, 0x01, 0x4c, 0xff, 0xf3,  //@@@@@%+...+@@@@.
    0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0xdf, 0xf9,  //@@@@+.......@@@%
    0xff, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfd,  //@@@%........+@@@
    0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //@@@+.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+006f (o) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x28, 0xce, 0xfe, 0xc8, 0x20, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@@@@@%..
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //.+@@@@+...+@@@@+.
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x60,  //+@@@.........@@@+
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xa0,  //%@@+.........+@@%
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0,  //%@@+.........+@@%
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0x60,  //+@@@.........@@@+
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //.+@@@@+...+@@@@+.
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x00, 0x28, 0xce, 0xfe, 0xc8, 0x20, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0070 (p) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xf0, 0x03, 0x9d, 0xef, 0xd9, 0x30, 0x00, 0x00,  //@@@...%@@@@%.....
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //@@@.%@@@@@@@@%...
    0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //@@@%@@@@@@@@@@%..
    0xff, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //@@@@%.......%@@@.
    0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x50,  //@@@@.........@@@+
    0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0,  //@@@+.........+@@%
    0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@...........@@@
    0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@...........@@@
    0xff, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xa0,  //@@@+.........+@@%
    0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x50,  //@@@@.........@@@+
    0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //@@@@%.......%@@@.
    0xff, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xf6, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //@@@%@@@@@@@@@@%..
    0xff, 0xf0, 0x9f, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //@@@.%@@@@@@@@%...
    0xff, 0xf0, 0x03, 0x9d, 0xff, 0xd9, 0x30, 0x00, 0x00,  //@@@...%@@@@%.....
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0071 (q) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x39, 0xdf, 0xed, 0x93, 0x00, 0xff, 0xf0,  //.....%@@@@%...@@@
    0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0x80, 0xff, 0xf0,  //...%@@@@@@@@%.@@@
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xf0,  //..%@@@@@@@@@@%@@@
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xff, 0xf0,  //.+@@@@+...+@@@@@@
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xf0,  //.@@@%.......%@@@@
    0x5f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xf0,  //+@@@.........@@@@
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xf0,  //%@@+.........+@@@
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf0,  //@@@...........@@@
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0,  //@@@...........@@@
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xf0,  //%@@+.........+@@@
    0x6f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xf0,  //+@@@.........@@@@
    0x0e, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xf0,  //.@@@%.......%@@@@
    0x06, 0xff, 0xfd, 0x51, 0x01, 0x5d, 0xff, 0xff, 0xf0,  //.+@@@@+...+@@@@@@
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xf0,  //..%@@@@@@@@@@%@@@
    0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0x90, 0xff, 0xf0,  //...%@@@@@@@@%.@@@
    0x00, 0x00, 0x39, 0xdf, 0xfd, 0x93, 0x00, 0xff, 0xf0,  //.....%@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0072 (r) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xf0, 0x02, 0x8d, 0xef, 0xf0,  //@@@...%@@@@
    0xff, 0xf0, 0x8f, 0xff, 0xff, 0xf0,  //@@@.%@@@@@@
    0xff, 0xf9, 0xff, 0xff, 0xff, 0xf0,  //@@@%@@@@@@@
    0xff, 0xff, 0xfb, 0x41, 0x00, 0x00,  //@@@@@%+....
    0xff, 0xff, 0x80, 0x00, 0x00, 0x00,  //@@@@%......
    0xff, 0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@@.......
    0xff, 0xf5, 0x00, 0x00, 0x00, 0x00,  //@@@+.......
    0xff, 0xf1, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0073 (s) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x17, 0xbe, 0xff, 0xfd, 0xb7, 0x20,  //...+%@@@@@%+..
    0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.+@@@@@@@@@@@.
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@.
    0xbf, 0xfe, 0x72, 0x00, 0x02, 0x48, 0xd0,  //%@@@+.....+%@.
    0xef, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xcf, 0xfd, 0x51, 0x00, 0x00, 0x00, 0x00,  //@@@@+.........
    0x5f, 0xff, 0xff, 0xc9, 0x51, 0x00, 0x00,  //+@@@@@@%+.....
    0x07, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00,  //.+@@@@@@@@@+..
    0x00, 0x18, 0xdf, 0xff, 0xff, 0xff, 0x90,  //...%@@@@@@@@%.
    0x00, 0x00, 0x00, 0x47, 0xcf, 0xff, 0xf5,  //.......+@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x02, 0xcf, 0xfc,  //..........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff,  //...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //...........@@@
    0xb3, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfd,  //%.........+@@@
    0xff, 0xc7, 0x31, 0x01, 0x39, 0xff, 0xf8,  //@@@+.....%@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1,  //@@@@@@@@@@@@@.
    0x4c, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x10,  //.%@@@@@@@@@@..
    0x00, 0x28, 0xce, 0xff, 0xd9, 0x40, 0x00,  //...%@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0074 (t) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..@@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xef, 0xf3, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0xbf, 0xfb, 0x20, 0x00, 0x00,  //..%@@%.....
    0x00, 0x5f, 0xff, 0xff, 0xff, 0xf0,  //..+@@@@@@@@
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xf0,  //...%@@@@@@@
    0x00, 0x00, 0x6b, 0xef, 0xff, 0xf0,  //....+%@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0075 (u) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,  //@@@..........@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff,  //@@@.........+@@@
    0xdf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xff,  //@@@+........%@@@
    0x9f, 0xfc, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff,  //%@@@.......+@@@@
    0x3f, 0xff, 0xc4, 0x10, 0x14, 0xbf, 0xff, 0xff,  //.@@@@+...+%@@@@@
    0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,  //.%@@@@@@@@@@%@@@
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xf7, 0x0f, 0xff,  //..%@@@@@@@@+.@@@
    0x00, 0x05, 0xbe, 0xfe, 0xd8, 0x20, 0x0f, 0xff,  //...+%@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0076 (v) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xdf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfd,  //@@@+..........+@@@
    0x7f, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xf7,  //+@@%..........%@@+
    0x1f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf1,  //.@@@..........@@@.
    0x0b, 0xff, 0x70, 0x00, 0x00, 0x00, 0x07, 0xff, 0xb0,  //.%@@+........+@@%.
    0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x50,  //.+@@@........@@@+.
    0x00, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x00,  //..@@@........@@@..
    0x00, 0xaf, 0xf8, 0x00, 0x00, 0x00, 0x9f, 0xf9, 0x00,  //..%@@%......%@@%..
    0x00, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0xef, 0xf4, 0x00,  //..+@@@......@@@...
    0x00, 0x0e, 0xff, 0x40, 0x00, 0x04, 0xff, 0xe0, 0x00,  //...@@@+....+@@@...
    0x00, 0x08, 0xff, 0xa0, 0x00, 0x0a, 0xff, 0x80, 0x00,  //...%@@%....%@@%...
    0x00, 0x02, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0x20, 0x00,  //....@@@....@@@....
    0x00, 0x00, 0xcf, 0xf6, 0x00, 0x6f, 0xfc, 0x00, 0x00,  //....@@@+..+@@@....
    0x00, 0x00, 0x6f, 0xfc, 0x00, 0xcf, 0xf6, 0x00, 0x00,  //....+@@%..@@@+....
    0x00, 0x00, 0x1f, 0xff, 0x12, 0xff, 0xf1, 0x00, 0x00,  //.....@@@..@@@.....
    0x00, 0x00, 0x0b, 0xff, 0x77, 0xff, 0xb0, 0x00, 0x00,  //.....%@@++@@%.....
    0x00, 0x00, 0x05, 0xff, 0xdd, 0xff, 0x50, 0x00, 0x00,  //.....+@@@@@@+.....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00,  //......@@@@@@......
    0x00, 0x00, 0x00, 0x9f, 0xff, 0xf9, 0x00, 0x00, 0x00,  //......%@@@@%......
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xf3, 0x00, 0x00, 0x00,  //.......@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0077 (w) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0xdf, 0xff, 0xd0, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@.......@@@@@.......@@@
    0x9f, 0xf7, 0x00, 0x00, 0x01, 0xff, 0xff, 0xf1, 0x00, 0x00, 0x07, 0xff, 0x90,  //%@@+......@@@@@......+@@%
    0x5f, 0xfb, 0x00, 0x00, 0x05, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x0b, 0xff, 0x50,  //+@@%.....+@@@@@+.....%@@+
    0x1f, 0xff, 0x00, 0x00, 0x09, 0xff, 0xef, 0xfa, 0x00, 0x00, 0x0f, 0xff, 0x10,  //.@@@.....%@@@@@%.....@@@.
    0x0d, 0xff, 0x30, 0x00, 0x0d, 0xff, 0x7f, 0xfe, 0x00, 0x00, 0x4f, 0xfd, 0x00,  //.@@@.....@@@+@@@.....@@@.
    0x09, 0xff, 0x80, 0x00, 0x2f, 0xff, 0x0e, 0xff, 0x20, 0x00, 0x8f, 0xf9, 0x00,  //.%@@+....@@@.@@@....%@@%.
    0x05, 0xff, 0xc0, 0x00, 0x6f, 0xfb, 0x0b, 0xff, 0x60, 0x00, 0xcf, 0xf5, 0x00,  //.+@@@...+@@%.%@@+...@@@+.
    0x01, 0xff, 0xf0, 0x00, 0xaf, 0xf7, 0x06, 0xff, 0xa0, 0x00, 0xff, 0xf1, 0x00,  //..@@@...%@@+.+@@%...@@@..
    0x00, 0xdf, 0xf4, 0x00, 0xef, 0xf3, 0x02, 0xff, 0xe0, 0x04, 0xff, 0xd0, 0x00,  //..@@@+..@@@...@@@..+@@@..
    0x00, 0x8f, 0xf8, 0x02, 0xff, 0xe0, 0x00, 0xef, 0xf2, 0x08, 0xff, 0x80, 0x00,  //..%@@%..@@@...@@@..%@@%..
    0x00, 0x4f, 0xfc, 0x06, 0xff, 0xa0, 0x00, 0xaf, 0xf6, 0x0c, 0xff, 0x40, 0x00,  //..+@@@.+@@%...%@@+.@@@+..
    0x00, 0x0f, 0xff, 0x0a, 0xff, 0x60, 0x00, 0x6f, 0xfa, 0x1f, 0xff, 0x00, 0x00,  //...@@@.%@@+...+@@%.@@@...
    0x00, 0x0c, 0xff, 0x5e, 0xff, 0x20, 0x00, 0x2f, 0xfe, 0x5f, 0xfc, 0x00, 0x00,  //...@@@+@@@.....@@@+@@@...
    0x00, 0x08, 0xff, 0xcf, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xcf, 0xf8, 0x00, 0x00,  //...%@@@@@@.....@@@@@@%...
    0x00, 0x04, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf4, 0x00, 0x00,  //...+@@@@@%.....%@@@@@+...
    0x00, 0x00, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf0, 0x00, 0x00,  //....@@@@@+.....+@@@@@....
    0x00, 0x00, 0xcf, 0xff, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xff, 0xc0, 0x00, 0x00,  //....@@@@@.......@@@@@....
    0x00, 0x00, 0x8f, 0xff, 0xd0, 0x00, 0x00, 0x00, 0xdf, 0xff, 0x80, 0x00, 0x00,  //....%@@@@.......@@@@+....
    0x00, 0x00, 0x4f, 0xff, 0x90, 0x00, 0x00, 0x00, 0x9f, 0xff, 0x30, 0x00, 0x00,  //.....@@@%.......%@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+0078 (x) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x0a, 0xff, 0xe1, 0x00, 0x00, 0x00, 0x01, 0xef, 0xfa,  //.%@@@.........@@@%
    0x00, 0xdf, 0xfc, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xd0,  //..@@@@.......@@@@.
    0x00, 0x3f, 0xff, 0x80, 0x00, 0x00, 0x8f, 0xff, 0x30,  //...@@@%.....%@@@..
    0x00, 0x07, 0xff, 0xf3, 0x00, 0x04, 0xff, 0xf7, 0x00,  //...+@@@.....@@@+..
    0x00, 0x00, 0xbf, 0xfe, 0x10, 0x1e, 0xff, 0xb0, 0x00,  //....%@@@...@@@%...
    0x00, 0x00, 0x1e, 0xff, 0xa0, 0xbf, 0xfe, 0x10, 0x00,  //.....@@@%.%@@@....
    0x00, 0x00, 0x04, 0xff, 0xfb, 0xff, 0xf4, 0x00, 0x00,  //.....+@@@%@@@+....
    0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0x80, 0x00, 0x00,  //......%@@@@@%.....
    0x00, 0x00, 0x00, 0x0c, 0xff, 0xfc, 0x00, 0x00, 0x00,  //.......@@@@@......
    0x00, 0x00, 0x00, 0x0b, 0xff, 0xf8, 0x00, 0x00, 0x00,  //.......%@@@%......
    0x00, 0x00, 0x00, 0x8f, 0xff, 0xff, 0x20, 0x00, 0x00,  //......%@@@@@......
    0x00, 0x00, 0x04, 0xff, 0xfe, 0xff, 0xd0, 0x00, 0x00,  //.....+@@@@@@@.....
    0x00, 0x00, 0x1e, 0xff, 0xb2, 0xff, 0xf8, 0x00, 0x00,  //.....@@@%.@@@%....
    0x00, 0x00, 0xcf, 0xfd, 0x10, 0x6f, 0xff, 0x30, 0x00,  //....@@@@..+@@@....
    0x00, 0x09, 0xff, 0xf3, 0x00, 0x0b, 0xff, 0xd0, 0x00,  //...%@@@....%@@@...
    0x00, 0x5f, 0xff, 0x60, 0x00, 0x01, 0xef, 0xf9, 0x00,  //..+@@@+.....@@@%..
    0x02, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x40,  //..@@@%......+@@@+.
    0x0d, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xe1,  //.@@@@........%@@@.
    0x9f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x01, 0xef, 0xfa,  //%@@@..........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0079 (y) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xcf, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xfc,  //@@@+..........+@@@
    0x6f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf6,  //+@@@..........@@@+
    0x0e, 0xff, 0x40, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf0,  //.@@@+.........@@@.
    0x08, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x09, 0xff, 0x90,  //.%@@%........%@@%.
    0x02, 0xff, 0xf1, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x30,  //..@@@........@@@..
    0x00, 0xbf, 0xf8, 0x00, 0x00, 0x00, 0x6f, 0xfd, 0x00,  //..%@@%......+@@@..
    0x00, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0xcf, 0xf7, 0x00,  //..+@@@......@@@+..
    0x00, 0x0e, 0xff, 0x50, 0x00, 0x02, 0xff, 0xf1, 0x00,  //...@@@+.....@@@...
    0x00, 0x07, 0xff, 0xc0, 0x00, 0x08, 0xff, 0xa0, 0x00,  //...+@@@....%@@%...
    0x00, 0x01, 0xff, 0xf3, 0x00, 0x0e, 0xff, 0x40, 0x00,  //....@@@....@@@+...
    0x00, 0x00, 0xaf, 0xf9, 0x00, 0x5f, 0xfd, 0x00, 0x00,  //....%@@%..+@@@....
    0x00, 0x00, 0x3f, 0xff, 0x00, 0xbf, 0xf7, 0x00, 0x00,  //.....@@@..%@@+....
    0x00, 0x00, 0x0d, 0xff, 0x62, 0xff, 0xf1, 0x00, 0x00,  //.....@@@+.@@@.....
    0x00, 0x00, 0x06, 0xff, 0xd8, 0xff, 0xa0, 0x00, 0x00,  //.....+@@@%@@%.....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00,  //......@@@@@@+.....
    0x00, 0x00, 0x00, 0x9f, 0xff, 0xfe, 0x00, 0x00, 0x00,  //......%@@@@@......
    0x00, 0x00, 0x00, 0x2f, 0xff, 0xf8, 0x00, 0x00, 0x00,  //.......@@@@+......
    0x00, 0x00, 0x00, 0x0c, 0xff, 0xf1, 0x00, 0x00, 0x00,  //.......%@@@.......
    0x00, 0x00, 0x00, 0x08, 0xff, 0xb0, 0x00, 0x00, 0x00,  //.......%@@%.......
    0x00, 0x00, 0x00, 0x0e, 0xff, 0x50, 0x00, 0x00, 0x00,  //.......@@@+.......
    0x00, 0x00, 0x00, 0x4f, 0xfe, 0x00, 0x00, 0x00, 0x00,  //......+@@@........
    0x00, 0x00, 0x00, 0xcf, 0xf8, 0x00, 0x00, 0x00, 0x00,  //......%@@%........
    0x00, 0x00, 0x19, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //.....%@@@.........
    0x00, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@%.........
    0x00, 0xff, 0xff, 0xfd, 0x10, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@..........
    0x00, 0xff, 0xfe, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@%...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+007a (z) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x60,  //..........+@@@+
    0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xf9, 0x00,  //.........+@@@%.
    0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0xb0, 0x00,  //.........@@@%..
    0x00, 0x00, 0x00, 0x01, 0xef, 0xfd, 0x10, 0x00,  //........@@@@...
    0x00, 0x00, 0x00, 0x0c, 0xff, 0xf2, 0x00, 0x00,  //.......@@@@....
    0x00, 0x00, 0x00, 0x9f, 0xff, 0x40, 0x00, 0x00,  //......%@@@+....
    0x00, 0x00, 0x07, 0xff, 0xf7, 0x00, 0x00, 0x00,  //.....+@@@+.....
    0x00, 0x00, 0x4f, 0xff, 0xa0, 0x00, 0x00, 0x00,  //....+@@@%......
    0x00, 0x02, 0xef, 0xfc, 0x00, 0x00, 0x00, 0x00,  //....@@@@.......
    0x00, 0x1d, 0xff, 0xe1, 0x00, 0x00, 0x00, 0x00,  //...@@@@........
    0x00, 0xbf, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00,  //..%@@@.........
    0x09, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@+.........
    0x6f, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@%..........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+007b ({) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xf0,  //.......+%@@@@
    0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xf0,  //......%@@@@@@
    0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xf0,  //.....+@@@@@@@
    0x00, 0x00, 0x0b, 0xff, 0xd4, 0x10, 0x00,  //.....%@@@+...
    0x00, 0x00, 0x0e, 0xff, 0x40, 0x00, 0x00,  //.....@@@+....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x2f, 0xfe, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x7f, 0xfc, 0x00, 0x00, 0x00,  //....+@@@.....
    0x00, 0x27, 0xff, 0xf7, 0x00, 0x00, 0x00,  //...+@@@+.....
    0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00,  //@@@@@@%......
    0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00,  //@@@@@+.......
    0xff, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00,  //@@@@@@%......
    0x00, 0x28, 0xff, 0xf6, 0x00, 0x00, 0x00,  //...%@@@+.....
    0x00, 0x00, 0x8f, 0xfc, 0x00, 0x00, 0x00,  //....%@@@.....
    0x00, 0x00, 0x3f, 0xfe, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0e, 0xff, 0x40, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0b, 0xff, 0xd4, 0x10, 0x00,  //.....%@@@+...
    0x00, 0x00, 0x05, 0xff, 0xff, 0xff, 0xf0,  //.....+@@@@@@@
    0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xf0,  //......%@@@@@@
    0x00, 0x00, 0x00, 0x05, 0xad, 0xef, 0xf0,  //.......+%@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+007c (|) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...


    /*Unicode: U+007d (}) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xed, 0xa5, 0x00, 0x00, 0x00, 0x00,  //@@@@%+.......
    0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00,  //@@@@@@%......
    0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00,  //@@@@@@@+.....
    0x00, 0x14, 0xdf, 0xfb, 0x00, 0x00, 0x00,  //...+@@@%.....
    0x00, 0x00, 0x4f, 0xfd, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0e, 0xff, 0x20, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0c, 0xff, 0x70, 0x00, 0x00,  //.....@@@+....
    0x00, 0x00, 0x07, 0xff, 0xf7, 0x20, 0x00,  //.....+@@@+...
    0x00, 0x00, 0x00, 0xbf, 0xff, 0xff, 0xf0,  //......%@@@@@@
    0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xf0,  //.......+@@@@@
    0x00, 0x00, 0x00, 0xaf, 0xff, 0xff, 0xf0,  //......%@@@@@@
    0x00, 0x00, 0x06, 0xff, 0xf8, 0x20, 0x00,  //.....+@@@%...
    0x00, 0x00, 0x0c, 0xff, 0x80, 0x00, 0x00,  //.....@@@%....
    0x00, 0x00, 0x0e, 0xff, 0x20, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x4f, 0xfd, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x14, 0xdf, 0xfb, 0x00, 0x00, 0x00,  //...+@@@%.....
    0xff, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00,  //@@@@@@@+.....
    0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00,  //@@@@@@%......
    0xff, 0xfd, 0xa5, 0x00, 0x00, 0x00, 0x00,  //@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+007e (~) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,  //.....................
    0x00, 0x18, 0xce, 0xfd, 0xa6, 0x10, 0x00, 0x00, 0x00, 0x06, 0xf0,  //...%@@@@%+.........+@
    0x09, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x73, 0x10, 0x26, 0xdf, 0xf0,  //.%@@@@@@@@@@+....+@@@
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xe7, 0x20, 0x13, 0x7c, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00,  //@@@+....+@@@@@@@@@@%.
    0xf8, 0x00, 0x00, 0x00, 0x00, 0x16, 0xad, 0xfe, 0xc8, 0x20, 0x00,  //@%.........+%@@@@%...
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................



#elif USE_LV_FONT_DEJAVU_40 == 8
    /*Unicode: U+0020 ( ) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0021 (!) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xf8, 0xff, 0xf8,  //@@@
    0xea, 0xff, 0xea,  //@@@
    0xde, 0xff, 0xde,  //@@@
    0xd0, 0xff, 0xd2,  //@@@
    0xc2, 0xff, 0xc4,  //@@@
    0xb6, 0xff, 0xb8,  //%@%
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0022 (") , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0023 (#) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xf6, 0x06, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00,  //.........%@@.....@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe2, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00,  //.........@@%....+@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xf0, 0x02, 0x00, 0x00, 0x00,  //.........@@%....%@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00,  //........+@@+....@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xfa, 0x0a, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00,  //........%@@.....@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00,  //........@@@....+@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xf6, 0x04, 0x00, 0x00, 0x00, 0x00,  //........@@%....%@@.....
    0x00, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf2, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@%....%@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@+....@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x14, 0xfc, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@.....@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@....+@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xfc, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xf8, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@%....%@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1a, 0x00,  //@@@@@@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1a, 0x00,  //@@@@@@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1a, 0x00,  //@@@@@@@@@@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@%....%@@........
    0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@+....%@@........
    0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x06, 0xf6, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@.....@@%........
    0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xee, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@.....@@+........
    0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@%....+@@.........
    0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@+....%@@.........
    0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x02, 0xf0, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@.....@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0024 ($) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x36, 0x90, 0xcc, 0xee, 0xff, 0xff, 0xf8, 0xd8, 0xb4, 0x6e, 0x24, 0x00, 0x00,  //....%@@@@@@%+...
    0x00, 0x14, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //..%@@@@@@@@@@@..
    0x08, 0xd2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //.@@@@@@@@@@@@@..
    0x7a, 0xff, 0xff, 0xff, 0xb8, 0x4a, 0x14, 0xff, 0xff, 0x0e, 0x2c, 0x4c, 0x90, 0xda, 0x00, 0x00,  //+@@@%+.@@..+%@..
    0xd0, 0xff, 0xff, 0x86, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%...@@.......
    0xf4, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@....@@.......
    0xf2, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@....@@.......
    0xc6, 0xff, 0xff, 0xb0, 0x08, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%...@@.......
    0x60, 0xff, 0xff, 0xff, 0xe8, 0x92, 0x54, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@%+@@.......
    0x00, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x90, 0x42, 0x02, 0x00, 0x00, 0x00,  //.%@@@@@@@@%+....
    0x00, 0x00, 0x5c, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x4e, 0x00, 0x00,  //..+@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x34, 0x7c, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00,  //.....+%@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x3a, 0x84, 0xe8, 0xff, 0xff, 0xff, 0x40,  //.......@@.%@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x10, 0xce, 0xff, 0xff, 0xae,  //.......@@...@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xe6,  //.......@@....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf8,  //.......@@....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xea,  //.......@@....@@@
    0xba, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x04, 0xb0, 0xff, 0xff, 0xb6,  //%......@@...%@@%
    0xff, 0xff, 0xce, 0x74, 0x38, 0x0c, 0x00, 0xff, 0xff, 0x1c, 0x5c, 0xd6, 0xff, 0xff, 0xff, 0x54,  //@@@+...@@.+@@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x00,  //@@@@@@@@@@@@@@%.
    0x3e, 0xba, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x8e, 0x04, 0x00,  //.%@@@@@@@@@@@%..
    0x00, 0x00, 0x1e, 0x72, 0xae, 0xdc, 0xf4, 0xff, 0xff, 0xe2, 0xbc, 0x7c, 0x20, 0x00, 0x00, 0x00,  //...+%@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0025 (%) , Width: 29 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x1c, 0x9a, 0xe2, 0xf8, 0xe0, 0x96, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@%.............@@%.....
    0x00, 0x30, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xe2, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@...........+@@......
    0x08, 0xdc, 0xff, 0xfa, 0x5a, 0x08, 0x5c, 0xfc, 0xff, 0xd8, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf4, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@+.+@@@..........@@+......
    0x64, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%...%@@+........%@%.......
    0xb4, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xe4, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+...+@@%.......+@@........
    0xe4, 0xff, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xf2, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@@.......@@+........
    0xf8, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xba, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@@......%@%.........
    0xf6, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xe8, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@@.....+@@..........
    0xe4, 0xff, 0xff, 0x14, 0x00, 0x00, 0x00, 0x16, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf0, 0xff, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@@.....@@+..........
    0xb4, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x42, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@....+@@%....%@%...........
    0x66, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xea, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%...%@@+...+@@............
    0x0a, 0xe0, 0xff, 0xfa, 0x58, 0x08, 0x5a, 0xfa, 0xff, 0xda, 0x08, 0x00, 0x00, 0x18, 0xec, 0xff, 0x58, 0x00, 0x00, 0x00, 0x1a, 0x98, 0xe0, 0xf8, 0xe2, 0x9a, 0x1c, 0x00, 0x00,  //.@@@+.+@@@....@@+....%@@@%...
    0x00, 0x36, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x30, 0x00, 0x00, 0x00, 0xae, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x30, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x30, 0x00,  //..@@@@@@@....%@%....@@@@@@@..
    0x00, 0x00, 0x1e, 0x9c, 0xe4, 0xf8, 0xe2, 0x9a, 0x1c, 0x00, 0x00, 0x00, 0x58, 0xff, 0xec, 0x18, 0x00, 0x00, 0x08, 0xdc, 0xff, 0xfc, 0x5c, 0x08, 0x5c, 0xfc, 0xff, 0xda, 0x06,  //...%@@@%....+@@....@@@+.+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xea, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x62,  //............@@+...+@@%...%@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xb2,  //...........%@%....%@@+...+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0xf0, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xff, 0xff, 0x14, 0x00, 0x00, 0x00, 0x16, 0xff, 0xff, 0xe2,  //..........+@@.....@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe6, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf6,  //..........@@+.....@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf6,  //.........%@%......@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xf2, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xff, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xff, 0xe2,  //........+@@.......@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe4, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xb2,  //........@@+.......%@@+...+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xa0, 0xff, 0xff, 0x62,  //.......%@%........+@@%...%@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xf4, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xfa, 0x5c, 0x08, 0x5a, 0xfa, 0xff, 0xda, 0x08,  //......+@@..........@@@+.+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe0, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x30, 0x00,  //......@@+...........@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x9a, 0xe2, 0xf8, 0xe2, 0x9a, 0x1c, 0x00, 0x00,  //.....%@@.............%@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............................


    /*Unicode: U+0026 (&) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x66, 0xba, 0xe8, 0xfa, 0xf4, 0xda, 0xb0, 0x74, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+%@@@@%+.........
    0x00, 0x00, 0x00, 0x00, 0x24, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@........
    0x00, 0x00, 0x00, 0x0e, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@........
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xa4, 0x34, 0x0c, 0x08, 0x22, 0x52, 0x96, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@%....+%@........
    0x00, 0x00, 0x00, 0xd2, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@%................
    0x00, 0x00, 0x00, 0xf4, 0xff, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@.................
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@.................
    0x00, 0x00, 0x00, 0xde, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@+................
    0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xec, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@................
    0x00, 0x00, 0x00, 0x16, 0xee, 0xff, 0xff, 0xda, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@...............
    0x00, 0x00, 0x00, 0x44, 0xec, 0xff, 0xff, 0xff, 0xd4, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@..............
    0x00, 0x00, 0x5a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@@.............
    0x00, 0x42, 0xfa, 0xff, 0xff, 0xe6, 0x7c, 0xfa, 0xff, 0xff, 0xde, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xe8, 0x00,  //.+@@@@+@@@@........@@@.
    0x0a, 0xe4, 0xff, 0xff, 0xdc, 0x1c, 0x00, 0x5a, 0xfc, 0xff, 0xff, 0xe4, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xba, 0x00,  //.@@@@..+@@@@......+@@%.
    0x70, 0xff, 0xff, 0xf2, 0x26, 0x00, 0x00, 0x00, 0x60, 0xfc, 0xff, 0xff, 0xe8, 0x2c, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0x74, 0x00,  //+@@@....+@@@@.....@@@+.
    0xc4, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0xff, 0xec, 0x32, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xfc, 0x1c, 0x00,  //@@@+.....+@@@@....@@@..
    0xf0, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xf0, 0x38, 0x02, 0xc6, 0xff, 0xff, 0xa6, 0x00, 0x00,  //@@@.......+@@@@..@@@%..
    0xf6, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xf2, 0xa4, 0xff, 0xff, 0xf8, 0x24, 0x00, 0x00,  //@@@........+@@@@%@@@...
    0xde, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00,  //@@@+........+@@@@@@+...
    0xa2, 0xff, 0xff, 0xcc, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00,  //%@@@.........%@@@@@....
    0x40, 0xff, 0xff, 0xff, 0xb4, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x44, 0x00, 0x00, 0x00,  //.@@@%.......+@@@@@@+...
    0x00, 0xa6, 0xff, 0xff, 0xff, 0xe6, 0x7c, 0x30, 0x0c, 0x0e, 0x4c, 0xb4, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xee, 0x26, 0x00, 0x00,  //.%@@@@+...+%@@@@@@@@...
    0x00, 0x08, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x1e, 0x9a, 0xff, 0xff, 0xff, 0xd8, 0x10, 0x00,  //..%@@@@@@@@@@@@.%@@@@..
    0x00, 0x00, 0x02, 0x80, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x18, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0xba, 0x02,  //...+@@@@@@@@@%...%@@@%.
    0x00, 0x00, 0x00, 0x00, 0x14, 0x74, 0xb6, 0xe2, 0xf6, 0xf2, 0xd8, 0x9e, 0x42, 0x00, 0x00, 0x00, 0x00, 0x02, 0xa8, 0xff, 0xff, 0xff, 0x94,  //.....+%@@@@%+.....%@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0027 (') , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0028 (() , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xff, 0xae,  //....+@@%
    0x00, 0x00, 0x00, 0x0c, 0xe4, 0xff, 0xf0, 0x1a,  //....@@@.
    0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0x78, 0x00,  //...%@@+.
    0x00, 0x00, 0x16, 0xf2, 0xff, 0xe4, 0x08, 0x00,  //...@@@..
    0x00, 0x00, 0x86, 0xff, 0xff, 0x72, 0x00, 0x00,  //..%@@+..
    0x00, 0x0a, 0xee, 0xff, 0xf0, 0x0c, 0x00, 0x00,  //..@@@...
    0x00, 0x5e, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00,  //.+@@%...
    0x00, 0xbc, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00,  //.%@@....
    0x0e, 0xfa, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00,  //.@@@....
    0x50, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00,  //+@@%....
    0x86, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00,  //%@@+....
    0xb6, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00,  //%@@+....
    0xd8, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00,  //@@@.....
    0xee, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00,  //@@@.....
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00,  //@@@.....
    0xfa, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,  //@@@.....
    0xee, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00,  //@@@.....
    0xd6, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00,  //@@@.....
    0xb4, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00,  //%@@+....
    0x84, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00,  //%@@+....
    0x4e, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00,  //+@@%....
    0x0c, 0xf8, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00,  //.@@@....
    0x00, 0xb8, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00,  //.%@@....
    0x00, 0x5a, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00,  //.+@@%...
    0x00, 0x08, 0xec, 0xff, 0xf0, 0x0c, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0x84, 0xff, 0xff, 0x72, 0x00, 0x00,  //..%@@+..
    0x00, 0x00, 0x14, 0xf2, 0xff, 0xe4, 0x08, 0x00,  //...@@@..
    0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0x7a, 0x00,  //...%@@+.
    0x00, 0x00, 0x00, 0x0c, 0xe4, 0xff, 0xf0, 0x1a,  //....@@@.
    0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xff, 0xae,  //....+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0029 ()) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xae, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00,  //%@@+....
    0x1c, 0xf2, 0xff, 0xe2, 0x0a, 0x00, 0x00, 0x00,  //.@@@....
    0x00, 0x7c, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00,  //.+@@+...
    0x00, 0x0a, 0xe6, 0xff, 0xf0, 0x14, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0x76, 0xff, 0xff, 0x82, 0x00, 0x00,  //..+@@%..
    0x00, 0x00, 0x0e, 0xf2, 0xff, 0xea, 0x08, 0x00,  //...@@@..
    0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x5a, 0x00,  //...%@@+.
    0x00, 0x00, 0x00, 0x40, 0xff, 0xff, 0xb8, 0x00,  //....@@%.
    0x00, 0x00, 0x00, 0x02, 0xee, 0xff, 0xf8, 0x0c,  //....@@@.
    0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0x4c,  //....%@@+
    0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0x84,  //....+@@%
    0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xff, 0xb4,  //....+@@%
    0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xd6,  //.....@@@
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xee,  //.....@@@
    0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf8,  //.....@@@
    0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf8,  //.....@@@
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xee,  //.....@@@
    0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xd4,  //.....@@@
    0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xff, 0xb4,  //....+@@%
    0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0x84,  //....+@@%
    0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x4c,  //....%@@+
    0x00, 0x00, 0x00, 0x02, 0xee, 0xff, 0xf8, 0x0c,  //....@@@.
    0x00, 0x00, 0x00, 0x40, 0xff, 0xff, 0xb8, 0x00,  //....@@%.
    0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x5a, 0x00,  //...%@@+.
    0x00, 0x00, 0x0e, 0xf2, 0xff, 0xec, 0x08, 0x00,  //...@@@..
    0x00, 0x00, 0x76, 0xff, 0xff, 0x82, 0x00, 0x00,  //..+@@%..
    0x00, 0x08, 0xe6, 0xff, 0xf2, 0x14, 0x00, 0x00,  //..@@@...
    0x00, 0x7c, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,  //.+@@+...
    0x1a, 0xf2, 0xff, 0xe2, 0x0a, 0x00, 0x00, 0x00,  //.@@@....
    0xae, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00,  //%@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+002a (*) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x44, 0xb8, 0x28, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x28, 0xb8, 0x44,  //+%.....@@.....%+
    0xc2, 0xff, 0xfa, 0x8e, 0x0e, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x0e, 0x8e, 0xfa, 0xff, 0xc0,  //@@@%...@@...%@@%
    0x08, 0x76, 0xec, 0xff, 0xea, 0x64, 0x00, 0xff, 0xff, 0x00, 0x66, 0xea, 0xff, 0xec, 0x76, 0x08,  //.+@@@+.@@.+@@@+.
    0x00, 0x00, 0x0e, 0x80, 0xf0, 0xff, 0xce, 0xff, 0xff, 0xce, 0xff, 0xf0, 0x80, 0x0c, 0x00, 0x00,  //...+@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x12, 0x8a, 0xf4, 0xff, 0xff, 0xf4, 0x8a, 0x12, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x12, 0x88, 0xf4, 0xff, 0xff, 0xf4, 0x88, 0x12, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@%.....
    0x00, 0x00, 0x0c, 0x7e, 0xf0, 0xff, 0xce, 0xff, 0xff, 0xce, 0xff, 0xf0, 0x7e, 0x0c, 0x00, 0x00,  //...+@@@@@@@@+...
    0x08, 0x72, 0xea, 0xff, 0xea, 0x66, 0x00, 0xff, 0xff, 0x00, 0x66, 0xea, 0xff, 0xea, 0x72, 0x08,  //.+@@@+.@@.+@@@+.
    0xc0, 0xff, 0xfa, 0x90, 0x0e, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x0e, 0x90, 0xfa, 0xff, 0xc0,  //%@@%...@@...%@@%
    0x46, 0xb8, 0x28, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x28, 0xb8, 0x44,  //+%.....@@.....%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+002b (+) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+002c (,) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x00, 0xff, 0xff, 0xfc,  //.@@@
    0x22, 0xff, 0xff, 0xb8,  //.@@%
    0x52, 0xff, 0xff, 0x56,  //+@@+
    0x84, 0xff, 0xec, 0x06,  //%@@.
    0xb4, 0xff, 0x92, 0x00,  //%@%.
    0xe6, 0xff, 0x30, 0x00,  //@@..
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+002d (-) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+002e (.) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+002f (/) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xda,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0x92,  //.......%@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0x4a,  //.......@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xf6, 0x0a,  //.......@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xba, 0x00,  //......+@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x72, 0x00,  //......%@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xec, 0xff, 0xff, 0x2a, 0x00,  //......@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xe2, 0x00, 0x00,  //......@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x9a, 0x00, 0x00,  //.....+@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0xff, 0x52, 0x00, 0x00,  //.....@@@+..
    0x00, 0x00, 0x00, 0x00, 0x12, 0xfc, 0xff, 0xfa, 0x0e, 0x00, 0x00,  //.....@@@...
    0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00,  //....+@@@...
    0x00, 0x00, 0x00, 0x00, 0xa0, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00,  //....%@@+...
    0x00, 0x00, 0x00, 0x00, 0xe6, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xe8, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00,  //...+@@%....
    0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00,  //...@@@+....
    0x00, 0x00, 0x0e, 0xfa, 0xff, 0xfc, 0x14, 0x00, 0x00, 0x00, 0x00,  //...@@@.....
    0x00, 0x00, 0x52, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@.....
    0x00, 0x00, 0x9a, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@%.....
    0x00, 0x00, 0xe0, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0x2a, 0xff, 0xff, 0xee, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0x72, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@%......
    0x00, 0xba, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@+......
    0x0a, 0xf6, 0xff, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.......
    0x4a, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@.......
    0x92, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%.......
    0xda, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0030 (0) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x0e, 0x6c, 0xbe, 0xe2, 0xf8, 0xe2, 0xbe, 0x6c, 0x0e, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@%+.....
    0x00, 0x00, 0x00, 0x42, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x40, 0x00, 0x00, 0x00,  //...+@@@@@@@@@....
    0x00, 0x00, 0x3c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x3a, 0x00, 0x00,  //...@@@@@@@@@@@...
    0x00, 0x0e, 0xea, 0xff, 0xff, 0xec, 0x6c, 0x1c, 0x06, 0x1e, 0x6e, 0xec, 0xff, 0xff, 0xe8, 0x0c, 0x00,  //..@@@@+...+@@@@..
    0x00, 0x84, 0xff, 0xff, 0xea, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xea, 0xff, 0xff, 0x80, 0x00,  //.%@@@.......@@@+.
    0x02, 0xec, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xe8, 0x02,  //.@@@+.......+@@@.
    0x40, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0x3e,  //.@@@.........@@@.
    0x82, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0x80,  //%@@%.........%@@+
    0xae, 0xff, 0xff, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xac,  //%@@+.........+@@%
    0xd4, 0xff, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xd4,  //@@@...........@@@
    0xe8, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xe6,  //@@@...........@@@
    0xf2, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf2,  //@@@...........@@@
    0xfc, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xfa,  //@@@...........@@@
    0xf4, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf2,  //@@@...........@@@
    0xe8, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xe6,  //@@@...........@@@
    0xd4, 0xff, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xd4,  //@@@...........@@@
    0xae, 0xff, 0xff, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xac,  //%@@+.........+@@%
    0x82, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0x82,  //%@@%.........%@@%
    0x42, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0x3e,  //+@@@.........@@@.
    0x02, 0xec, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xea, 0x02,  //.@@@+.......+@@@.
    0x00, 0x84, 0xff, 0xff, 0xe8, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xea, 0xff, 0xff, 0x80, 0x00,  //.%@@@.......@@@+.
    0x00, 0x0e, 0xea, 0xff, 0xff, 0xec, 0x6c, 0x1c, 0x06, 0x1e, 0x6e, 0xec, 0xff, 0xff, 0xe8, 0x0c, 0x00,  //..@@@@+...+@@@@..
    0x00, 0x00, 0x3e, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x3a, 0x00, 0x00,  //...@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x42, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x40, 0x00, 0x00, 0x00,  //...+@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x0e, 0x6c, 0xc0, 0xe4, 0xf8, 0xe4, 0xc0, 0x6c, 0x0e, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0031 (1) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x14, 0x40, 0x6e, 0x9a, 0xc6, 0xf2, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+%@@@@@.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@.....
    0xea, 0xbe, 0x94, 0x6a, 0x3e, 0x14, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@%%+..@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0032 (2) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x1a, 0x50, 0x82, 0xac, 0xce, 0xe8, 0xf6, 0xf8, 0xea, 0xcc, 0x96, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+%%@@@@@@%+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x30, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x44, 0x00, 0x00,  //@@@@@@@@@@@@@@+..
    0xff, 0xff, 0xf2, 0xaa, 0x66, 0x32, 0x14, 0x04, 0x0e, 0x3e, 0x9c, 0xfc, 0xff, 0xff, 0xee, 0x16, 0x00,  //@@@%+.....%@@@@..
    0xc8, 0x5e, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xf4, 0xff, 0xff, 0x88, 0x00,  //@+.........+@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xd4, 0x00,  //............+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xf2, 0x00,  //.............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf0, 0x00,  //.............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xff, 0xce, 0x00,  //.............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x82, 0x00,  //............%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xfa, 0xff, 0xf2, 0x16, 0x00,  //............@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xe0, 0xff, 0xff, 0x72, 0x00, 0x00,  //...........@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xd0, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00,  //..........@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xce, 0xff, 0xff, 0xd2, 0x10, 0x00, 0x00, 0x00,  //.........@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xd4, 0xff, 0xff, 0xda, 0x18, 0x00, 0x00, 0x00, 0x00,  //........@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xdc, 0xff, 0xff, 0xe0, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xe6, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x3a, 0xee, 0xff, 0xff, 0xe2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@........
    0x00, 0x00, 0x00, 0x48, 0xf4, 0xff, 0xff, 0xde, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@.........
    0x00, 0x00, 0x56, 0xf8, 0xff, 0xff, 0xda, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@..........
    0x00, 0x66, 0xfc, 0xff, 0xff, 0xd4, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@...........
    0x76, 0xff, 0xff, 0xff, 0xce, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@@............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22,  //@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22,  //@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0033 (3) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x1e, 0x5e, 0x94, 0xc2, 0xe2, 0xf4, 0xfa, 0xea, 0xc6, 0x8a, 0x2a, 0x00, 0x00, 0x00, 0x00,  //..+%@@@@@@%.....
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x98, 0x06, 0x00, 0x00,  //.@@@@@@@@@@@%...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x00, 0x00,  //.@@@@@@@@@@@@%..
    0x00, 0xdc, 0x98, 0x60, 0x32, 0x12, 0x02, 0x08, 0x22, 0x60, 0xd2, 0xff, 0xff, 0xff, 0x60, 0x00,  //.@%+.....+@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb6, 0xff, 0xff, 0xc0, 0x00,  //...........%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xee, 0x00,  //............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf6, 0x00,  //............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xd4, 0x00,  //............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaa, 0xff, 0xff, 0x7c, 0x00,  //...........%@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1c, 0x56, 0xc6, 0xff, 0xff, 0xca, 0x08, 0x00,  //.........+@@@@..
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xa2, 0x0a, 0x00, 0x00,  //....@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x8a, 0x16, 0x00, 0x00, 0x00,  //....@@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7e, 0x00, 0x00,  //....@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x20, 0x54, 0xb0, 0xff, 0xff, 0xff, 0x98, 0x00,  //.........+%@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xf6, 0xff, 0xff, 0x48,  //...........+@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xb2,  //............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xea,  //.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf8,  //.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xe4,  //.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xb8,  //............%@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xf8, 0xff, 0xff, 0x64,  //...........+@@@+
    0xd8, 0x8e, 0x5a, 0x32, 0x16, 0x06, 0x00, 0x0a, 0x26, 0x5a, 0xb6, 0xff, 0xff, 0xff, 0xd6, 0x04,  //@%+......+%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x24, 0x00,  //@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x18, 0x00, 0x00,  //@@@@@@@@@@@@%...
    0x20, 0x60, 0x96, 0xc2, 0xe0, 0xf4, 0xfc, 0xf0, 0xde, 0xb4, 0x7c, 0x22, 0x00, 0x00, 0x00, 0x00,  //.+%@@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0034 (4) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //..........%@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.........+@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xee, 0xff, 0xc6, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xf6, 0x28, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //........%@@.@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x76, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......+@@+.@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xf0, 0xff, 0xc8, 0x02, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@..@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xf8, 0x2a, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //......%@@...@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....+@@+...@@@....
    0x00, 0x00, 0x00, 0x00, 0x22, 0xf4, 0xff, 0xca, 0x02, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....@@@....@@@....
    0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xf8, 0x2a, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@.....@@@....
    0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...+@@+.....@@@....
    0x00, 0x00, 0x28, 0xf6, 0xff, 0xcc, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@......@@@....
    0x00, 0x02, 0xc8, 0xff, 0xf8, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@@.......@@@....
    0x00, 0x7a, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.+@@+.......@@@....
    0x2c, 0xf8, 0xff, 0xce, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.@@@........@@@....
    0xce, 0xff, 0xfa, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@.........@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //............@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0035 (5) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //.@@@@@@@@@@@@@..
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //.@@@@@@@@@@@@@..
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //.@@@@@@@@@@@@@..
    0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@............
    0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@............
    0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@............
    0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@............
    0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@............
    0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@............
    0x00, 0xff, 0xff, 0xff, 0x98, 0xd6, 0xf4, 0xf4, 0xe2, 0xba, 0x7c, 0x1c, 0x00, 0x00, 0x00, 0x00,  //.@@@%@@@@%+.....
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x94, 0x08, 0x00, 0x00,  //.@@@@@@@@@@@%...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x0c, 0x00,  //.@@@@@@@@@@@@@..
    0x00, 0xd6, 0x8a, 0x50, 0x26, 0x0c, 0x02, 0x0c, 0x2e, 0x70, 0xd8, 0xff, 0xff, 0xff, 0xb2, 0x00,  //.@%+.....+@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x94, 0xff, 0xff, 0xff, 0x42,  //...........%@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0x9e,  //............%@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xda,  //.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xf2,  //.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xf2,  //.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0xdc,  //.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0xa0,  //............%@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x90, 0xff, 0xff, 0xff, 0x48,  //...........%@@@+
    0xda, 0x94, 0x5e, 0x34, 0x18, 0x08, 0x00, 0x0a, 0x2c, 0x6e, 0xd6, 0xff, 0xff, 0xff, 0xb8, 0x00,  //@%+......+@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x10, 0x00,  //@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x94, 0x0a, 0x00, 0x00,  //@@@@@@@@@@@@%...
    0x20, 0x60, 0x96, 0xc2, 0xe2, 0xf4, 0xfc, 0xf0, 0xdc, 0xb0, 0x74, 0x18, 0x00, 0x00, 0x00, 0x00,  //.+%@@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0036 (6) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x5a, 0xae, 0xda, 0xf2, 0xf6, 0xe0, 0xb6, 0x78, 0x28, 0x00, 0x00,  //......+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x4a, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //....+@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //...+@@@@@@@@@@@..
    0x00, 0x00, 0x56, 0xff, 0xff, 0xff, 0xe2, 0x70, 0x28, 0x0a, 0x06, 0x1c, 0x48, 0x8e, 0xda, 0x00, 0x00,  //..+@@@@+....+%@..
    0x00, 0x14, 0xea, 0xff, 0xff, 0xb6, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@%...........
    0x00, 0x92, 0xff, 0xff, 0xd4, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@............
    0x08, 0xee, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@+............
    0x56, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0x8e, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0xc2, 0xff, 0xff, 0x56, 0x00, 0x22, 0x8c, 0xd6, 0xf4, 0xf0, 0xd8, 0xa0, 0x4c, 0x00, 0x00, 0x00, 0x00,  //@@@+..%@@@@%+....
    0xde, 0xff, 0xff, 0x2a, 0x66, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x22, 0x00, 0x00,  //@@@.+@@@@@@@@@...
    0xee, 0xff, 0xff, 0x72, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x24, 0x00,  //@@@+@@@@@@@@@@@..
    0xfa, 0xff, 0xff, 0xf6, 0xff, 0xf8, 0x8a, 0x30, 0x08, 0x08, 0x30, 0x8a, 0xf8, 0xff, 0xff, 0xd0, 0x00,  //@@@@@@%....%@@@@.
    0xf2, 0xff, 0xff, 0xff, 0xf8, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xf8, 0xff, 0xff, 0x56,  //@@@@@+......+@@@+
    0xe6, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xa8,  //@@@@%........%@@%
    0xd2, 0xff, 0xff, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xde,  //@@@@..........@@@
    0xaa, 0xff, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf4,  //%@@@..........@@@
    0x7e, 0xff, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf4,  //+@@@..........@@@
    0x3a, 0xff, 0xff, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xdc,  //.@@@..........@@@
    0x00, 0xe4, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xa4,  //.@@@%........%@@%
    0x00, 0x76, 0xff, 0xff, 0xf8, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xf8, 0xff, 0xff, 0x4c,  //.+@@@+......+@@@+
    0x00, 0x06, 0xde, 0xff, 0xff, 0xf8, 0x8a, 0x2e, 0x08, 0x08, 0x2e, 0x8a, 0xf8, 0xff, 0xff, 0xc4, 0x00,  //..@@@@%....%@@@@.
    0x00, 0x00, 0x2c, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x1a, 0x00,  //...@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x30, 0xd2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x18, 0x00, 0x00,  //....@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x04, 0x5c, 0xb2, 0xde, 0xf6, 0xf0, 0xd8, 0x9e, 0x44, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0037 (7) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //@@@@@@@@@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xfc, 0xff, 0xfc, 0x24,  //............@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xba, 0x00,  //...........%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xe8, 0xff, 0xff, 0x4e, 0x00,  //...........@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xe0, 0x02, 0x00,  //..........+@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0x7a, 0x00, 0x00,  //..........@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xf8, 0x16, 0x00, 0x00,  //..........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00,  //.........%@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xf2, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00,  //.........@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00,  //........+@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd4, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00,  //........@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xf0, 0x0c, 0x00, 0x00, 0x00, 0x00,  //........@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xf8, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe2, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0xff, 0xe6, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@%.......
    0x00, 0x00, 0x00, 0x00, 0x24, 0xfc, 0xff, 0xfa, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@........
    0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@%........
    0x00, 0x00, 0x00, 0x08, 0xec, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@+........
    0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@.........
    0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0038 (8) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x3a, 0x98, 0xd0, 0xee, 0xfa, 0xee, 0xd0, 0x98, 0x3a, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x0e, 0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xae, 0x0e, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x04, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x04, 0x00,  //..@@@@@@@@@@@@@..
    0x00, 0x6e, 0xff, 0xff, 0xff, 0xc2, 0x4c, 0x1e, 0x06, 0x1e, 0x50, 0xc6, 0xff, 0xff, 0xff, 0x6e, 0x00,  //.+@@@@+...+@@@@+.
    0x00, 0xc8, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0xc8, 0x00,  //.@@@%.......%@@@.
    0x00, 0xf2, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xf0, 0x00,  //.@@@.........@@@.
    0x00, 0xf6, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf6, 0x00,  //.@@@.........@@@.
    0x00, 0xd2, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xd0, 0x00,  //.@@@.........@@@.
    0x00, 0x78, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x76, 0x00,  //.+@@%.......%@@+.
    0x00, 0x06, 0xc6, 0xff, 0xff, 0xc2, 0x4c, 0x1c, 0x06, 0x1e, 0x4e, 0xc6, 0xff, 0xff, 0xc6, 0x06, 0x00,  //..@@@@+...+@@@@..
    0x00, 0x00, 0x08, 0xa0, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xa0, 0x08, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x10, 0x82, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x82, 0x10, 0x00, 0x00, 0x00,  //....%@@@@@@@%....
    0x00, 0x00, 0x6c, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x6a, 0x00, 0x00,  //..+@@@@@@@@@@@+..
    0x00, 0x84, 0xff, 0xff, 0xfa, 0x96, 0x3c, 0x10, 0x02, 0x10, 0x3e, 0x98, 0xfa, 0xff, 0xff, 0x82, 0x00,  //.%@@@%.....%@@@%.
    0x3a, 0xfc, 0xff, 0xf2, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xf2, 0xff, 0xfc, 0x3a,  //.@@@.........@@@.
    0xa8, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xa8,  //%@@+.........+@@%
    0xe4, 0xff, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xff, 0xe4,  //@@@...........@@@
    0xfa, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf8,  //@@@...........@@@
    0xec, 0xff, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xff, 0xea,  //@@@...........@@@
    0xc8, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xc8,  //@@@+.........+@@@
    0x80, 0xff, 0xff, 0xf2, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf4, 0xff, 0xff, 0x80,  //+@@@.........@@@+
    0x16, 0xf2, 0xff, 0xff, 0xf8, 0x94, 0x3c, 0x0e, 0x02, 0x10, 0x3e, 0x98, 0xfa, 0xff, 0xff, 0xf2, 0x14,  //.@@@@%.....%@@@@.
    0x00, 0x54, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x52, 0x00,  //.+@@@@@@@@@@@@@+.
    0x00, 0x00, 0x48, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x46, 0x00, 0x00,  //..+@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x06, 0x5a, 0xa6, 0xd8, 0xf0, 0xfa, 0xf0, 0xd8, 0xa6, 0x5a, 0x06, 0x00, 0x00, 0x00,  //....+%@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0039 (9) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x44, 0x9c, 0xd6, 0xf0, 0xf6, 0xdc, 0xb0, 0x5c, 0x06, 0x00, 0x00, 0x00, 0x00,  //....+%@@@@%+.....
    0x00, 0x00, 0x18, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x30, 0x00, 0x00, 0x00,  //...%@@@@@@@@@....
    0x00, 0x1a, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x2c, 0x00, 0x00,  //..@@@@@@@@@@@@...
    0x00, 0xc6, 0xff, 0xff, 0xf8, 0x8a, 0x30, 0x08, 0x08, 0x30, 0x8a, 0xf8, 0xff, 0xff, 0xde, 0x06, 0x00,  //.@@@@%....%@@@@..
    0x4c, 0xff, 0xff, 0xf8, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xf8, 0xff, 0xff, 0x74, 0x00,  //+@@@+......+@@@+.
    0xa4, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xe2, 0x00,  //%@@%........%@@@.
    0xde, 0xff, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xff, 0x38,  //@@@..........@@@.
    0xf4, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0x7e,  //@@@..........@@@+
    0xf4, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0xa8,  //@@@..........@@@%
    0xe0, 0xff, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xd2,  //@@@..........@@@@
    0xaa, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xff, 0xe4,  //%@@%........%@@@@
    0x58, 0xff, 0xff, 0xf8, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf8, 0xff, 0xff, 0xff, 0xf0,  //+@@@........@@@@@
    0x02, 0xd2, 0xff, 0xff, 0xf8, 0x88, 0x2e, 0x08, 0x08, 0x2e, 0x88, 0xf8, 0xff, 0xf6, 0xff, 0xff, 0xfa,  //.@@@@%....%@@@@@@
    0x00, 0x26, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0xff, 0xff, 0xee,  //..@@@@@@@@@@@+@@@
    0x00, 0x00, 0x24, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x66, 0x2c, 0xff, 0xff, 0xde,  //...@@@@@@@@@+.@@@
    0x00, 0x00, 0x00, 0x00, 0x50, 0xa2, 0xda, 0xf2, 0xf4, 0xd6, 0x8e, 0x24, 0x00, 0x56, 0xff, 0xff, 0xc2,  //....+%@@@@%..+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0x8e,  //.............%@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0xff, 0xff, 0x56,  //.............@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xf0, 0x08,  //............+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xd6, 0xff, 0xff, 0x94, 0x00,  //............@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xb6, 0xff, 0xff, 0xec, 0x14, 0x00,  //...........%@@@..
    0x00, 0x00, 0xd8, 0x8c, 0x44, 0x1a, 0x04, 0x08, 0x26, 0x70, 0xe2, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00,  //..@%+....+@@@@+..
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00,  //..@@@@@@@@@@@+...
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x4e, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@@@+....
    0x00, 0x00, 0x28, 0x78, 0xb6, 0xe0, 0xf6, 0xf4, 0xda, 0xb0, 0x5e, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+%@@@@%+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+003a (:) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+003b (;) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x00, 0xff, 0xff, 0xfc,  //.@@@
    0x22, 0xff, 0xff, 0xb8,  //.@@%
    0x52, 0xff, 0xff, 0x56,  //+@@+
    0x84, 0xff, 0xec, 0x06,  //%@@.
    0xb4, 0xff, 0x92, 0x00,  //%@%.
    0xe6, 0xff, 0x30, 0x00,  //@@..
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+003c (<) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x72, 0xd0,  //...................+@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x5a, 0xb8, 0xfc, 0xff, 0xff,  //................+%@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xa0, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff,  //.............+%@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x88, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xbe, 0x62,  //...........%@@@@@@@%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x72, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x78, 0x1c, 0x00, 0x00,  //........+@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x0a, 0x5a, 0xb8, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x90, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@@@@%......
    0x00, 0x00, 0x42, 0xa0, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xa6, 0x4a, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+%@@@@@@@%+........
    0x88, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xbe, 0x62, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@%+...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x78, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@+..............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x78, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@+..............
    0x8a, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xbe, 0x60, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@@@@@%+...........
    0x00, 0x00, 0x44, 0xa0, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xa6, 0x48, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+%@@@@@@@%+........
    0x00, 0x00, 0x00, 0x00, 0x0a, 0x5c, 0xb8, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x8e, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x72, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x78, 0x1c, 0x00, 0x00,  //........+@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x8a, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xbe, 0x60,  //...........%@@@@@@@%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xa2, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff,  //.............+%@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x5c, 0xb8, 0xfc, 0xff, 0xff,  //................+%@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x72, 0xd0,  //...................+@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+003d (=) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+003e (>) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xd0, 0x72, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+...................
    0xff, 0xff, 0xfa, 0xb8, 0x5a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%+................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xa0, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%+.............
    0x62, 0xbe, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x88, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+%@@@@@@@%...........
    0x00, 0x00, 0x1c, 0x78, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x72, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x90, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xb6, 0x5a, 0x08, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x4a, 0xa6, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xa0, 0x42, 0x00, 0x00,  //........+%@@@@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x60, 0xbe, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x88,  //...........+%@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x78, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff,  //..............+@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x76, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff,  //..............+@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x60, 0xbc, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x8a,  //...........+%@@@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x48, 0xa6, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xa0, 0x44, 0x00, 0x00,  //........+%@@@@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x8e, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xb8, 0x5a, 0x0a, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@@@%+.....
    0x00, 0x00, 0x1c, 0x78, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x72, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@@@@+........
    0x60, 0xbe, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x8a, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+%@@@@@@@%...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xa2, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%+.............
    0xff, 0xff, 0xfc, 0xb8, 0x5c, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%+................
    0xd0, 0x72, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+003f (?) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x40, 0x94, 0xd0, 0xee, 0xf8, 0xe6, 0xb6, 0x62, 0x04, 0x00, 0x00,  //...%@@@@%+...
    0x48, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x20, 0x00,  //+@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x0a,  //@@@@@@@@@@@@.
    0xff, 0xff, 0xc4, 0x6a, 0x2a, 0x0a, 0x12, 0x3a, 0xae, 0xff, 0xff, 0xff, 0x7c,  //@@@+....%@@@+
    0xba, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0xd0,  //%........%@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xf2,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xee,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xc2,  //.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xf2, 0xff, 0xff, 0x60,  //.........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf4, 0xff, 0xff, 0xc6, 0x00,  //.......+@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf8, 0xff, 0xff, 0xe6, 0x1a, 0x00,  //......+@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xf6, 0xff, 0xff, 0xe6, 0x2c, 0x00, 0x00,  //......@@@@...
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xe6, 0xff, 0xff, 0xde, 0x24, 0x00, 0x00, 0x00,  //.....@@@@....
    0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xe2, 0x1c, 0x00, 0x00, 0x00, 0x00,  //....%@@@.....
    0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@+.....
    0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0040 (@) , Width: 30 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x7e, 0xb6, 0xda, 0xf2, 0xfa, 0xf2, 0xde, 0xb8, 0x82, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........+%@@@@@%%..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x5e, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x70, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@@@@@@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xfc, 0xff, 0xff, 0xff, 0xf0, 0x9e, 0x5c, 0x2a, 0x12, 0x02, 0x0a, 0x22, 0x4e, 0x90, 0xe6, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@%+.....+%@@@@@+....
    0x00, 0x00, 0x00, 0x00, 0xa0, 0xff, 0xff, 0xff, 0xea, 0x70, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x6a, 0xea, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00,  //....%@@@@+...........+@@@@%...
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xb0, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xae, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00,  //...+@@@%...............%@@@+..
    0x00, 0x00, 0x52, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x9e, 0xff, 0xff, 0xf6, 0x26, 0x00,  //..+@@@%.................%@@@..
    0x00, 0x06, 0xe0, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xb2, 0x00,  //..@@@%...................%@@%.
    0x00, 0x74, 0xff, 0xff, 0xde, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x02, 0x6a, 0xc8, 0xf0, 0xee, 0xc6, 0x60, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18, 0xf6, 0xff, 0xfc, 0x28,  //.+@@@......+@@@@+..@@@....@@@.
    0x04, 0xea, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xae, 0x06, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x7e,  //.@@@+.....@@@@@@@%.@@@....%@@+
    0x4c, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xc0,  //+@@@.....%@@@@@@@@%@@@....+@@%
    0x92, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xff, 0xbc, 0x3c, 0x08, 0x0a, 0x3e, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xe4,  //%@@%....+@@@%....%@@@@.....@@@
    0xc6, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0xbc, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02, 0xc0, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf8,  //@@@+....%@@%......%@@@.....@@@
    0xe8, 0xff, 0xff, 0x18, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xec,  //@@@.....@@@........@@@.....@@@
    0xf8, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0xf6, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xd2,  //@@@.....@@@........@@@.....@@@
    0xfa, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0xf6, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0x94,  //@@@.....@@@........@@@....+@@%
    0xec, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0xde, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x14, 0xea, 0xff, 0xff, 0x3e,  //@@@.....@@@........@@@....@@@.
    0xcc, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xff, 0x00, 0x00, 0x0e, 0xc2, 0xff, 0xff, 0xb4, 0x00,  //@@@+....%@@%......%@@@...@@@%.
    0x9c, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xff, 0xb8, 0x3a, 0x08, 0x08, 0x3a, 0xb8, 0xff, 0xff, 0xff, 0xff, 0x1a, 0x68, 0xe0, 0xff, 0xff, 0xde, 0x1a, 0x00,  //%@@%....+@@@%....%@@@@.+@@@@..
    0x5c, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x20, 0x00, 0x00,  //+@@@.....%@@@@@@@@%@@@@@@@@...
    0x0e, 0xf6, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x10, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x7c, 0x04, 0x00, 0x00, 0x00,  //.@@@+.....@@@@@@@%.@@@@@@+....
    0x00, 0x92, 0xff, 0xff, 0xdc, 0x06, 0x00, 0x00, 0x00, 0x00, 0x04, 0x6e, 0xc8, 0xf2, 0xf0, 0xc8, 0x64, 0x00, 0x00, 0xf4, 0xe0, 0xc6, 0x90, 0x50, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@......+@@@@+..@@@%+......
    0x00, 0x14, 0xf2, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@%........................
    0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@%.......................
    0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0xff, 0xae, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x8a, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@%..............%+......
    0x00, 0x00, 0x00, 0x08, 0xc6, 0xff, 0xff, 0xff, 0xe0, 0x62, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xce, 0xff, 0xfa, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@@+..........+@@@......
    0x00, 0x00, 0x00, 0x00, 0x08, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x96, 0x4e, 0x26, 0x10, 0x04, 0x1a, 0x3a, 0x7e, 0xd0, 0xff, 0xff, 0xff, 0xce, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%+.....+@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x9c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@@@@@@@@@@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x86, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@@@@@@@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x54, 0x96, 0xc8, 0xea, 0xf8, 0xf8, 0xe6, 0xbc, 0x7e, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+%@@@@@%+...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............................


    /*Unicode: U+0041 (A) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0xff, 0xf2, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xd6, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xfa, 0x2a, 0xf8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xb0, 0x00, 0xaa, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe4, 0xff, 0xff, 0x4c, 0x00, 0x48, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x02, 0xe2, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@%...%@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xf8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xfa, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0x00, 0x08, 0xf0, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xf0, 0x08, 0x00, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00,  //...%@@@@@@@@@@@@@@@%...
    0x00, 0x00, 0x20, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x00, 0x00,  //...@@@@@@@@@@@@@@@@@...
    0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00,  //..%@@@@@@@@@@@@@@@@@%..
    0x00, 0x00, 0xe0, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xe0, 0x00, 0x00,  //..@@@+...........+@@@..
    0x00, 0x46, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xea, 0xff, 0xff, 0x46, 0x00,  //.+@@@.............@@@+.
    0x00, 0xa8, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xa8, 0x00,  //.%@@%.............%@@%.
    0x10, 0xf6, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xf6, 0x10,  //.@@@...............@@@.
    0x6c, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0x6c,  //+@@@...............@@@+
    0xce, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xce,  //@@@+...............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0042 (B) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xe4, 0xbe, 0x84, 0x2a, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@%%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xa0, 0x0a, 0x00, 0x00,  //@@@@@@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x02, 0x00,  //@@@@@@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x24, 0x5e, 0xcc, 0xff, 0xff, 0xff, 0x6e, 0x00,  //@@@........+@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xac, 0xff, 0xff, 0xc8, 0x00,  //@@@..........%@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xff, 0xff, 0xf0, 0x00,  //@@@...........@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf0, 0x00,  //@@@...........@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xff, 0xff, 0xd0, 0x00,  //@@@...........@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaa, 0xff, 0xff, 0x8a, 0x00,  //@@@..........%@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x24, 0x5c, 0xc8, 0xff, 0xff, 0xec, 0x18, 0x00,  //@@@........+@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x28, 0x00, 0x00,  //@@@@@@@@@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x2c, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x92, 0x02, 0x00,  //@@@@@@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x16, 0x40, 0x8e, 0xf4, 0xff, 0xff, 0x96, 0x00,  //@@@.........%@@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xe8, 0xff, 0xff, 0x3c,  //@@@...........@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xa2,  //@@@...........+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xde,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf6,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xf0,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xd2,  //@@@...........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xea, 0xff, 0xff, 0x8a,  //@@@...........@@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x14, 0x40, 0x8e, 0xf6, 0xff, 0xff, 0xf4, 0x1c,  //@@@.........%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x58, 0x00,  //@@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x46, 0x00, 0x00,  //@@@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xec, 0xd0, 0x9e, 0x52, 0x04, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0043 (C) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x44, 0x88, 0xc4, 0xde, 0xf2, 0xf8, 0xe8, 0xd2, 0xa4, 0x6c, 0x1a, 0x00, 0x00,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xb8, 0x3c,  //.....+@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x0a, 0xac, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x00, 0x00, 0x0a, 0xcc, 0xff, 0xff, 0xff, 0xe8, 0x88, 0x46, 0x1c, 0x0a, 0x08, 0x1e, 0x42, 0x88, 0xda, 0xff, 0xff, 0xff,  //...@@@@@%+....+%@@@@
    0x00, 0x00, 0xa4, 0xff, 0xff, 0xfc, 0x80, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xda, 0xff,  //..%@@@+..........+@@
    0x00, 0x52, 0xff, 0xff, 0xfc, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xa2,  //.+@@@+.............%
    0x00, 0xcc, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%...............
    0x38, 0xff, 0xff, 0xf0, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x7c, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0xba, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0xda, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xda, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.................
    0xba, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+................
    0x7c, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%................
    0x38, 0xff, 0xff, 0xee, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@................
    0x00, 0xce, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%...............
    0x00, 0x54, 0xff, 0xff, 0xfc, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xa0,  //.+@@@+.............%
    0x00, 0x00, 0xa8, 0xff, 0xff, 0xfc, 0x7c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xda, 0xff,  //..%@@@+..........+@@
    0x00, 0x00, 0x0a, 0xce, 0xff, 0xff, 0xff, 0xe6, 0x86, 0x44, 0x1c, 0x08, 0x08, 0x1e, 0x42, 0x84, 0xd6, 0xff, 0xff, 0xff,  //...@@@@@%+....+%@@@@
    0x00, 0x00, 0x00, 0x0c, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....%@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xb6, 0x3c,  //.....+@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x44, 0x8a, 0xc6, 0xde, 0xf2, 0xf8, 0xea, 0xd2, 0xa4, 0x6a, 0x18, 0x00, 0x00,  //.......+%@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+0044 (D) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xe6, 0xd8, 0xbe, 0x8e, 0x5c, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%%+........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xb6, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@%+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xae, 0x14, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x02, 0x10, 0x1e, 0x40, 0x72, 0xb6, 0xfc, 0xff, 0xff, 0xff, 0xde, 0x16, 0x00, 0x00,  //@@@........+%@@@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xa4, 0xff, 0xff, 0xff, 0xca, 0x06, 0x00,  //@@@...........%@@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xff, 0x6e, 0x00,  //@@@............+@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xe6, 0x06,  //@@@.............%@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xee, 0xff, 0xff, 0x48,  //@@@..............@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0x88,  //@@@..............%@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xc2,  //@@@..............+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xda,  //@@@...............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@...............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@...............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xea,  //@@@...............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xd8,  //@@@...............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xff, 0xc0,  //@@@..............+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0x86,  //@@@..............%@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xee, 0xff, 0xff, 0x46,  //@@@..............@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xe2, 0x06,  //@@@.............%@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xff, 0x6a, 0x00,  //@@@............+@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xa2, 0xff, 0xff, 0xff, 0xc8, 0x06, 0x00,  //@@@...........%@@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1c, 0x3e, 0x70, 0xb4, 0xfa, 0xff, 0xff, 0xff, 0xdc, 0x14, 0x00, 0x00,  //@@@........+%@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x14, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xb6, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@%+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xe6, 0xd8, 0xbe, 0x8e, 0x5c, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0045 (E) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0046 (F) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0047 (G) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x80, 0xbe, 0xda, 0xec, 0xfa, 0xee, 0xe0, 0xba, 0x8e, 0x52, 0x0c, 0x00, 0x00, 0x00,  //........+%@@@@@%%+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xd2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xaa, 0x38, 0x00,  //.....+@@@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x0a, 0xac, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //....%@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x0a, 0xce, 0xff, 0xff, 0xff, 0xea, 0x8c, 0x50, 0x20, 0x0e, 0x04, 0x16, 0x2c, 0x64, 0xa6, 0xf2, 0xff, 0xff, 0xff, 0x00,  //...@@@@@%+.....+%@@@@.
    0x00, 0x00, 0xaa, 0xff, 0xff, 0xfc, 0x7e, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x76, 0xea, 0xff, 0x00,  //..%@@@+...........+@@.
    0x00, 0x56, 0xff, 0xff, 0xfc, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xaa, 0x00,  //.+@@@+..............%.
    0x00, 0xd0, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@+.................
    0x3a, 0xff, 0xff, 0xec, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@..................
    0x7c, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%..................
    0xba, 0xff, 0xff, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+..................
    0xda, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...................
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@...........@@@@@@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@...........@@@@@@@@
    0xec, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@...........@@@@@@@@
    0xd8, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@................@@@
    0xba, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //%@@+...............@@@
    0x7c, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //+@@%...............@@@
    0x38, 0xff, 0xff, 0xf2, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@...............@@@
    0x00, 0xcc, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@%..............@@@
    0x00, 0x50, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.+@@@+.............@@@
    0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0x9a, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xff,  //..%@@@%............@@@
    0x00, 0x00, 0x08, 0xc6, 0xff, 0xff, 0xff, 0xf6, 0xa2, 0x60, 0x2a, 0x14, 0x04, 0x04, 0x12, 0x30, 0x5e, 0xa6, 0xf6, 0xff, 0xff, 0xff,  //...@@@@@%+......+%@@@@
    0x00, 0x00, 0x00, 0x08, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x48,  //....%@@@@@@@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x74, 0x0a, 0x00,  //.....+@@@@@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x78, 0xb8, 0xd8, 0xea, 0xfa, 0xee, 0xda, 0xba, 0x80, 0x40, 0x00, 0x00, 0x00, 0x00,  //........+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+0048 (H) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0049 (I) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+004a (J) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //...@@@
    0x00, 0x00, 0x0c, 0xff, 0xff, 0xee,  //...@@@
    0x00, 0x00, 0x28, 0xff, 0xff, 0xdc,  //...@@@
    0x00, 0x00, 0x5c, 0xff, 0xff, 0xb6,  //..+@@%
    0x00, 0x00, 0xc4, 0xff, 0xff, 0x7e,  //..@@@+
    0x34, 0xb0, 0xff, 0xff, 0xfc, 0x28,  //.%@@@.
    0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //@@@@%.
    0xff, 0xff, 0xff, 0xbe, 0x0a, 0x00,  //@@@%..
    0xe4, 0xb2, 0x5a, 0x00, 0x00, 0x00,  //@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+004b (K) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xdc, 0xff, 0xff, 0xfc, 0x74, 0x00,  //@@@...........@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xe6, 0xff, 0xff, 0xfa, 0x5e, 0x00, 0x00,  //@@@..........@@@@+..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xee, 0xff, 0xff, 0xf4, 0x4a, 0x00, 0x00, 0x00,  //@@@.........@@@@+...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xf6, 0xff, 0xff, 0xee, 0x3a, 0x00, 0x00, 0x00, 0x00,  //@@@.......+@@@@.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xfa, 0xff, 0xff, 0xe4, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@......+@@@@......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xd8, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....+@@@@.......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xcc, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@....%@@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0xa0, 0xff, 0xff, 0xff, 0xbc, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...%@@@%.........
    0xff, 0xff, 0xff, 0x00, 0x08, 0xb2, 0xff, 0xff, 0xff, 0xaa, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..%@@@%..........
    0xff, 0xff, 0xff, 0x10, 0xc4, 0xff, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.@@@@%...........
    0xff, 0xff, 0xff, 0xd2, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@%............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%.............
    0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xea, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@.............
    0xff, 0xff, 0xff, 0x38, 0xee, 0xff, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.@@@@............
    0xff, 0xff, 0xff, 0x00, 0x32, 0xec, 0xff, 0xff, 0xf0, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..@@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x2e, 0xe8, 0xff, 0xff, 0xf2, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...@@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x28, 0xe6, 0xff, 0xff, 0xf4, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@....@@@@+........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe2, 0xff, 0xff, 0xf6, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@@@+.......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xde, 0xff, 0xff, 0xf8, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@......@@@@+......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xda, 0xff, 0xff, 0xfa, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.......@@@@+.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xd6, 0xff, 0xff, 0xfc, 0x5e, 0x00, 0x00, 0x00, 0x00,  //@@@........@@@@+....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xd0, 0xff, 0xff, 0xfc, 0x64, 0x00, 0x00, 0x00,  //@@@.........@@@@+...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xcc, 0xff, 0xff, 0xfc, 0x6a, 0x00, 0x00,  //@@@..........@@@@+..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xc6, 0xff, 0xff, 0xff, 0x72, 0x00,  //@@@...........@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xc2, 0xff, 0xff, 0xff, 0x7a,  //@@@............@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+004c (L) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+004d (M) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xff, 0xff, 0xff, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@.............@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@%...........%@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@...........@@@@@@
    0xff, 0xff, 0xff, 0xce, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xcc, 0xff, 0xff, 0xff,  //@@@@@@+.........+@@@@@@
    0xff, 0xff, 0xff, 0x68, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xff, 0x68, 0xff, 0xff, 0xff,  //@@@+@@@.........@@@+@@@
    0xff, 0xff, 0xff, 0x0e, 0xf4, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xf4, 0x0c, 0xff, 0xff, 0xff,  //@@@.@@@.........@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0x9e, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0x9c, 0x00, 0xff, 0xff, 0xff,  //@@@.%@@%.......%@@%.@@@
    0xff, 0xff, 0xff, 0x00, 0x38, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xf2, 0xff, 0xff, 0x36, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@.......@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0xd2, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xd2, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@+.....+@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0x6c, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..+@@@.....@@@+..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x10, 0xf6, 0xff, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xf6, 0x10, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@.....@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...%@@%...%@@%...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0xee, 0x08, 0x00, 0x08, 0xf0, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....@@@...@@@....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x5e, 0x00, 0x60, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....@@@+.+@@@....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0xc4, 0x00, 0xc6, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....+@@@.@@@+....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf8, 0xff, 0xff, 0x56, 0xff, 0xff, 0xf6, 0x12, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@+@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....%@@@@@%.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......+@@@+......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.................@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+004e (N) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@%...........@@@
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@...........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@%..........@@@
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@..........@@@
    0xff, 0xff, 0xff, 0x9a, 0xff, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@%@@@.........@@@
    0xff, 0xff, 0xff, 0x18, 0xf2, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.@@@+........@@@
    0xff, 0xff, 0xff, 0x00, 0x80, 0xff, 0xff, 0xde, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.+@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x0a, 0xe6, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@+.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x68, 0xff, 0xff, 0xec, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..+@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0xd6, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@%......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xf8, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...+@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....%@@%.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xfc, 0x32, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....%@@%....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf8, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@+...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xd2, 0x02, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......%@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xee, 0xff, 0xff, 0x62, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@+..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xe4, 0x08, 0x00, 0xff, 0xff, 0xff,  //@@@.......+@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xe0, 0xff, 0xff, 0x7c, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@+.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xf2, 0x14, 0xff, 0xff, 0xff,  //@@@........+@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xff, 0x94, 0xff, 0xff, 0xff,  //@@@.........@@@%@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff,  //@@@.........+@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@..........%@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xfc, 0xff, 0xff, 0xff, 0xff,  //@@@...........@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0xff,  //@@@...........%@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+004f (O) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x56, 0xa0, 0xd2, 0xe8, 0xf8, 0xe8, 0xd2, 0xa2, 0x58, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x04, 0x6e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x72, 0x04, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x10, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x10, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x00, 0x0e, 0xd4, 0xff, 0xff, 0xff, 0xe0, 0x7e, 0x36, 0x16, 0x04, 0x14, 0x34, 0x7c, 0xde, 0xff, 0xff, 0xff, 0xd6, 0x0e, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x00, 0xaa, 0xff, 0xff, 0xff, 0x84, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00,  //..%@@@%.........+@@@%..
    0x00, 0x56, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0x58, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0xce, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xce, 0x00,  //.@@@%.............%@@@.
    0x38, 0xff, 0xff, 0xf6, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf6, 0xff, 0xff, 0x3a,  //.@@@...............@@@.
    0x7c, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x7c,  //+@@%...............%@@+
    0xb8, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xb8,  //%@@+...............+@@%
    0xda, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xd8,  //@@@.................@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@.................@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@.................@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@.................@@@
    0xda, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xda,  //@@@.................@@@
    0xba, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xba,  //%@@+...............+@@%
    0x7e, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x7c,  //+@@%...............%@@+
    0x3a, 0xff, 0xff, 0xf4, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf4, 0xff, 0xff, 0x3a,  //.@@@...............@@@.
    0x00, 0xd0, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xd0, 0x00,  //.@@@%.............%@@@.
    0x00, 0x58, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0x58, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0x00, 0xae, 0xff, 0xff, 0xff, 0x80, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7c, 0xfc, 0xff, 0xff, 0xb0, 0x00, 0x00,  //..%@@@+.........+@@@%..
    0x00, 0x00, 0x10, 0xd6, 0xff, 0xff, 0xff, 0xe0, 0x7c, 0x34, 0x14, 0x04, 0x14, 0x32, 0x7a, 0xdc, 0xff, 0xff, 0xff, 0xd8, 0x10, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x00, 0x00, 0x12, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x12, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x04, 0x72, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x74, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x58, 0xa2, 0xd2, 0xe8, 0xf8, 0xea, 0xd4, 0xa4, 0x5a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0050 (P) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf0, 0xdc, 0xac, 0x68, 0x0c, 0x00, 0x00, 0x00,  //@@@@@@@@@@%+....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x58, 0x00, 0x00,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00,  //@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x34, 0x88, 0xf4, 0xff, 0xff, 0xf6, 0x1a,  //@@@.......%@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xec, 0xff, 0xff, 0x84,  //@@@.........@@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xc8,  //@@@.........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xea,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf8,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xea,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xc8,  //@@@.........+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xec, 0xff, 0xff, 0x84,  //@@@.........@@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x34, 0x86, 0xf4, 0xff, 0xff, 0xf6, 0x1a,  //@@@.......%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0x00,  //@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x5c, 0x00, 0x00,  //@@@@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xde, 0xae, 0x6a, 0x0e, 0x00, 0x00, 0x00,  //@@@@@@@@@@%+....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0051 (Q) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x56, 0xa0, 0xd2, 0xe8, 0xf8, 0xe8, 0xd2, 0xa2, 0x5a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x04, 0x6e, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x72, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x10, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x12, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x00, 0x0e, 0xd4, 0xff, 0xff, 0xff, 0xe0, 0x7e, 0x36, 0x16, 0x04, 0x14, 0x34, 0x7c, 0xde, 0xff, 0xff, 0xff, 0xd8, 0x10, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x00, 0xaa, 0xff, 0xff, 0xff, 0x84, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00,  //..%@@@%.........+@@@%..
    0x00, 0x56, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0x5a, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0xce, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xd0, 0x00,  //.@@@%.............%@@@.
    0x38, 0xff, 0xff, 0xf6, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf6, 0xff, 0xff, 0x3c,  //.@@@...............@@@.
    0x7c, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x7e,  //+@@%...............%@@+
    0xb8, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xba,  //%@@+...............+@@%
    0xda, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xda,  //@@@.................@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@.................@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@.................@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xf0,  //@@@.................@@@
    0xda, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xde,  //@@@.................@@@
    0xba, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xb6,  //%@@+...............+@@%
    0x7c, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x84,  //+@@%...............%@@%
    0x38, 0xff, 0xff, 0xf4, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xf4, 0xff, 0xff, 0x38,  //.@@@...............@@@.
    0x00, 0xce, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xd6, 0x00,  //.@@@%.............%@@@.
    0x00, 0x56, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0x5c, 0x00,  //.+@@@+...........+@@@+.
    0x00, 0x00, 0xaa, 0xff, 0xff, 0xff, 0x80, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7c, 0xfc, 0xff, 0xff, 0xba, 0x00, 0x00,  //..%@@@+.........+@@@%..
    0x00, 0x00, 0x0e, 0xd4, 0xff, 0xff, 0xff, 0xe0, 0x7c, 0x34, 0x14, 0x04, 0x14, 0x32, 0x7a, 0xdc, 0xff, 0xff, 0xff, 0xd8, 0x14, 0x00, 0x00,  //...@@@@@+.....+@@@@@...
    0x00, 0x00, 0x00, 0x10, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x1a, 0x00, 0x00, 0x00,  //....%@@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x04, 0x6c, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x72, 0x04, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x54, 0x9e, 0xd0, 0xe6, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xee, 0xff, 0xff, 0xd4, 0x10, 0x00, 0x00, 0x00, 0x00,  //..............@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf6, 0xff, 0xff, 0xc0, 0x06, 0x00, 0x00, 0x00,  //...............@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xfc, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00,  //...............+@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00,  //................+@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0052 (R) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf2, 0xe0, 0xb6, 0x7a, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%+.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x8a, 0x02, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x2a, 0x6e, 0xe0, 0xff, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00,  //@@@.......+@@@@+...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xce, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00,  //@@@.........@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xde, 0x00, 0x00, 0x00,  //@@@.........+@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xec, 0x00, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00,  //@@@.........+@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xd0, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00,  //@@@.........@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x2a, 0x6e, 0xe2, 0xff, 0xff, 0xf4, 0x1e, 0x00, 0x00, 0x00,  //@@@.......+@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x48, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@@+....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@%......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@@+.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x2c, 0x7e, 0xea, 0xff, 0xff, 0xf4, 0x28, 0x00, 0x00, 0x00, 0x00,  //@@@......+@@@@.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xe0, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00, 0x00,  //@@@........@@@%....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xfc, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00,  //@@@.........@@@+...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00,  //@@@.........%@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf8, 0xff, 0xff, 0x2e, 0x00, 0x00,  //@@@..........@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0x9c, 0x00, 0x00,  //@@@..........%@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xf6, 0x12, 0x00,  //@@@...........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0x7a, 0x00,  //@@@...........@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xe4, 0x04,  //@@@...........+@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xe4, 0xff, 0xff, 0x58,  //@@@............@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xc6,  //@@@............+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0053 (S) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x04, 0x52, 0x9e, 0xd2, 0xec, 0xfa, 0xf6, 0xec, 0xd2, 0xb4, 0x88, 0x58, 0x1c, 0x00,  //....+%@@@@@@%%+..
    0x00, 0x00, 0x4a, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x00, 0x62, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.+@@@@@@@@@@@@@@.
    0x28, 0xf8, 0xff, 0xff, 0xea, 0x82, 0x3a, 0x14, 0x04, 0x04, 0x10, 0x2a, 0x48, 0x74, 0xa6, 0xe2, 0x00,  //.@@@@%......++%@.
    0x9a, 0xff, 0xff, 0xce, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@.............
    0xde, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xf6, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xf0, 0xff, 0xff, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xc4, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%.............
    0x6a, 0xff, 0xff, 0xff, 0xae, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@%............
    0x04, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xec, 0xb6, 0x82, 0x50, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@%%+.......
    0x00, 0x0a, 0x9e, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x82, 0x1a, 0x00, 0x00, 0x00,  //..%@@@@@@@@@%....
    0x00, 0x00, 0x00, 0x2a, 0x90, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x72, 0x00, 0x00,  //....%@@@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x54, 0x86, 0xba, 0xf2, 0xff, 0xff, 0xff, 0xff, 0x86, 0x00,  //.......+%%@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x58, 0xd8, 0xff, 0xff, 0xff, 0x36,  //...........+@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xc8, 0xff, 0xff, 0xa2,  //.............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0xde,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf6,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xec,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xcc,  //.............+@@@
    0xc8, 0x5a, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xea, 0xff, 0xff, 0x84,  //@+...........@@@%
    0xff, 0xff, 0xf2, 0xaa, 0x68, 0x36, 0x16, 0x06, 0x04, 0x18, 0x46, 0x9a, 0xf8, 0xff, 0xff, 0xf0, 0x16,  //@@@%+.....+%@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x4c, 0x00,  //@@@@@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x38, 0x00, 0x00,  //@@@@@@@@@@@@@@...
    0x1a, 0x50, 0x80, 0xaa, 0xca, 0xe4, 0xf4, 0xfc, 0xf4, 0xe6, 0xc2, 0x90, 0x40, 0x00, 0x00, 0x00, 0x00,  //.++%@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0054 (T) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0055 (U) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.............@@@
    0xf8, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf6,  //@@@.............@@@
    0xe8, 0xff, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xe6,  //@@@.............@@@
    0xd0, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xce,  //@@@+...........+@@@
    0x9a, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0x98,  //%@@%...........%@@%
    0x56, 0xff, 0xff, 0xea, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xec, 0xff, 0xff, 0x54,  //+@@@...........@@@+
    0x04, 0xe4, 0xff, 0xff, 0xba, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xbc, 0xff, 0xff, 0xe2, 0x02,  //.@@@%.........%@@@.
    0x00, 0x5a, 0xff, 0xff, 0xff, 0xe2, 0x76, 0x32, 0x0e, 0x02, 0x0e, 0x30, 0x76, 0xe2, 0xff, 0xff, 0xff, 0x56, 0x00,  //.+@@@@+.....+@@@@+.
    0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86, 0x00, 0x00,  //..%@@@@@@@@@@@@@%..
    0x00, 0x00, 0x00, 0x62, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x60, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x08, 0x62, 0xa4, 0xd8, 0xec, 0xfa, 0xee, 0xd8, 0xa6, 0x62, 0x08, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0056 (V) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xce, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xce,  //@@@+...............+@@@
    0x6c, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0x6c,  //+@@@...............@@@+
    0x10, 0xf6, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xf6, 0x10,  //.@@@...............@@@.
    0x00, 0xa8, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xa8, 0x00,  //.%@@%.............%@@%.
    0x00, 0x46, 0xff, 0xff, 0xea, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xe8, 0xff, 0xff, 0x46, 0x00,  //.+@@@.............@@@+.
    0x00, 0x00, 0xe0, 0xff, 0xff, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0xff, 0xe0, 0x00, 0x00,  //..@@@+...........+@@@..
    0x00, 0x00, 0x82, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0x82, 0x00, 0x00,  //..%@@%...........%@@%..
    0x00, 0x00, 0x20, 0xfc, 0xff, 0xfa, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xfa, 0xff, 0xfc, 0x20, 0x00, 0x00,  //...@@@...........@@@...
    0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00,  //...%@@+.........+@@%...
    0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00,  //...+@@@.........@@@+...
    0x00, 0x00, 0x00, 0x08, 0xf0, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xf0, 0x08, 0x00, 0x00, 0x00,  //....@@@.........@@@....
    0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00,  //....%@@%.......%@@%....
    0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xf2, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00,  //.....@@@.......@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@+.....+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@.....%@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xf8, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xfa, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@.....@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@%...%@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x02, 0xe2, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@...@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe4, 0xff, 0xff, 0x4e, 0x00, 0x48, 0xff, 0xff, 0xe6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@+.+@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xb0, 0x00, 0xaa, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.%@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xfa, 0x2a, 0xf8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@.@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xd6, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0xff, 0xf2, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0057 (W) , Width: 31 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0xe0, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xff, 0xff, 0xff, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xff, 0xde,  //@@@..........@@@@@..........@@@
    0xa0, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0x9e,  //%@@+.........@@@@@.........+@@%
    0x62, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0x60,  //+@@%........+@@@@@+........%@@+
    0x22, 0xff, 0xff, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0xff, 0x20,  //.@@@........%@@@@@%........@@@.
    0x00, 0xe4, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0x6c, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xe2, 0x00,  //.@@@........@@@+@@@........@@@.
    0x00, 0xa4, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xf4, 0x08, 0xf0, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa2, 0x00,  //.%@@+.......@@@.@@@.......+@@%.
    0x00, 0x66, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xbc, 0x00, 0xb8, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x64, 0x00,  //.+@@%......+@@%.%@@+......%@@+.
    0x00, 0x26, 0xff, 0xff, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0x80, 0x00, 0x7a, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0x24, 0x00,  //..@@@......%@@+.+@@%......@@@..
    0x00, 0x00, 0xe8, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0x42, 0x00, 0x3e, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xe6, 0x00, 0x00,  //..@@@......@@@+..@@@......@@@..
    0x00, 0x00, 0xaa, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x10, 0xfc, 0xff, 0xf8, 0x08, 0x00, 0x06, 0xf8, 0xff, 0xfc, 0x12, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xa6, 0x00, 0x00,  //..%@@+.....@@@...@@@.....+@@%..
    0x00, 0x00, 0x6a, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0x68, 0x00, 0x00,  //..+@@%....+@@@...@@@+....%@@+..
    0x00, 0x00, 0x2c, 0xff, 0xff, 0xe8, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0xe8, 0xff, 0xff, 0x28, 0x00, 0x00,  //...@@@....%@@%...%@@%....@@@...
    0x00, 0x00, 0x00, 0xea, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xc8, 0x00, 0x00, 0x00, 0x28, 0xff, 0xff, 0xe8, 0x00, 0x00, 0x00,  //...@@@....@@@+...+@@@....@@@...
    0x00, 0x00, 0x00, 0xae, 0xff, 0xff, 0x66, 0x00, 0x00, 0x08, 0xf8, 0xff, 0xfc, 0x10, 0x00, 0x00, 0x00, 0x0e, 0xfc, 0xff, 0xfa, 0x0a, 0x00, 0x00, 0x66, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00,  //...%@@+...@@@.....@@@...+@@%...
    0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x40, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0x42, 0x00, 0x00, 0xa6, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00,  //...+@@%...@@@.....@@@+..%@@+...
    0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xe4, 0x00, 0x00, 0x7e, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0x80, 0x00, 0x00, 0xe6, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00,  //....@@@..+@@%.....%@@+..@@@....
    0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0xff, 0x24, 0x00, 0xbc, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xbc, 0x00, 0x24, 0xff, 0xff, 0xec, 0x00, 0x00, 0x00, 0x00,  //....@@@..%@@+.....+@@%..@@@....
    0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0x62, 0x04, 0xf4, 0xff, 0xff, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xf4, 0x04, 0x64, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00,  //....%@@+.@@@.......@@@.+@@%....
    0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xa2, 0x36, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0x36, 0xa2, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //....+@@%.@@@.......@@@.%@@+....
    0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xe0, 0x74, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x74, 0xe2, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00,  //.....@@@+@@%.......%@@+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x02, 0xf2, 0xff, 0xff, 0xd0, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xd2, 0xff, 0xff, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@+.......+@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@.........@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe8, 0xff, 0xff, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@.........@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@%.........%@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf4, 0xff, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xff, 0xf2, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@+.........+@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............................


    /*Unicode: U+0058 (X) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0xaa, 0xff, 0xff, 0xde, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xde, 0xff, 0xff, 0xaa, 0x00,  //.%@@@...........@@@%.
    0x00, 0x16, 0xec, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xea, 0x14, 0x00,  //..@@@%.........%@@@..
    0x00, 0x00, 0x5c, 0xff, 0xff, 0xfc, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xfc, 0xff, 0xff, 0x5a, 0x00, 0x00,  //..+@@@.........@@@+..
    0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0xd8, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xd8, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00,  //...%@@@.......@@@%...
    0x00, 0x00, 0x00, 0x1c, 0xf0, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xee, 0x18, 0x00, 0x00, 0x00,  //....@@@%.....%@@@....
    0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0xfa, 0x34, 0x00, 0x00, 0x00, 0x34, 0xfa, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00,  //....+@@@.....@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0xd4, 0x04, 0x00, 0x04, 0xd4, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@...@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf4, 0xff, 0xff, 0x82, 0x00, 0x82, 0xff, 0xff, 0xf2, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@%.%@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xfa, 0x60, 0xfa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@+@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xf6, 0xff, 0xff, 0xff, 0xf4, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xc8, 0xff, 0xff, 0xff, 0xc6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@@@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xf6, 0xff, 0xff, 0xd2, 0xff, 0xff, 0xf4, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xcc, 0x08, 0xd2, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@.@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xf8, 0x2c, 0x00, 0x34, 0xfa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@...@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x20, 0xf2, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xf2, 0x1e, 0x00, 0x00, 0x00, 0x00,  //.....@@@+...%@@@.....
    0x00, 0x00, 0x00, 0x00, 0xba, 0xff, 0xff, 0xd0, 0x04, 0x00, 0x00, 0x00, 0x08, 0xda, 0xff, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00,  //....%@@@.....@@@%....
    0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xfa, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xfc, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00,  //...+@@@.......@@@+...
    0x00, 0x00, 0x1a, 0xee, 0xff, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0xee, 0x1a, 0x00, 0x00,  //...@@@%.......%@@@...
    0x00, 0x00, 0xb2, 0xff, 0xff, 0xd6, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe0, 0xff, 0xff, 0xb2, 0x00, 0x00,  //..%@@@.........@@@%..
    0x00, 0x5c, 0xff, 0xff, 0xfc, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xff, 0xff, 0x5a, 0x00,  //.+@@@..........+@@@+.
    0x16, 0xec, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xea, 0x16,  //.@@@%...........%@@@.
    0xaa, 0xff, 0xff, 0xdc, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe4, 0xff, 0xff, 0xaa,  //%@@@.............@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0059 (Y) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xa6, 0xff, 0xff, 0xe6, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xe6, 0xff, 0xff, 0xa6,  //%@@@.............@@@%
    0x10, 0xe4, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0xe4, 0x10,  //.@@@%...........%@@@.
    0x00, 0x48, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xff, 0x46, 0x00,  //.+@@@+.........+@@@+.
    0x00, 0x00, 0x98, 0xff, 0xff, 0xee, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xee, 0xff, 0xff, 0x96, 0x00, 0x00,  //..%@@@.........@@@%..
    0x00, 0x00, 0x0a, 0xdc, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xba, 0xff, 0xff, 0xda, 0x0a, 0x00, 0x00,  //...@@@%.......%@@@...
    0x00, 0x00, 0x00, 0x3a, 0xfc, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xfc, 0x3a, 0x00, 0x00, 0x00,  //....@@@+.....+@@@....
    0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xf4, 0x24, 0x00, 0x00, 0x00, 0x26, 0xf4, 0xff, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00,  //....%@@@.....@@@%....
    0x00, 0x00, 0x00, 0x00, 0x04, 0xd0, 0xff, 0xff, 0xc6, 0x02, 0x00, 0x02, 0xc8, 0xff, 0xff, 0xd0, 0x04, 0x00, 0x00, 0x00, 0x00,  //.....@@@@...@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xf8, 0xff, 0xff, 0x7c, 0x00, 0x7c, 0xff, 0xff, 0xf8, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@+.+@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xf8, 0x62, 0xf8, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@+@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf2, 0xff, 0xff, 0xff, 0xf2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+005a (Z) , Width: 20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x00,  //@@@@@@@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xfc, 0x48, 0x00,  //..............%@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xfc, 0xff, 0xff, 0x82, 0x00, 0x00,  //.............+@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xee, 0xff, 0xff, 0xba, 0x00, 0x00, 0x00,  //.............@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xca, 0xff, 0xff, 0xe4, 0x14, 0x00, 0x00, 0x00,  //............@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0xfa, 0x3a, 0x00, 0x00, 0x00, 0x00,  //...........%@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........+@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xf2, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd4, 0xff, 0xff, 0xda, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0xf6, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+@@@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xf6, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xde, 0xff, 0xff, 0xce, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0xf0, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@...........
    0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@+...........
    0x00, 0x00, 0x00, 0x3c, 0xfa, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@%............
    0x00, 0x00, 0x16, 0xe4, 0xff, 0xff, 0xc4, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@.............
    0x00, 0x02, 0xbc, 0xff, 0xff, 0xe8, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@..............
    0x00, 0x84, 0xff, 0xff, 0xfc, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@+..............
    0x48, 0xfc, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@+...............
    0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....................


    /*Unicode: U+005b ([) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+005c (\) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xda, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+.......
    0x92, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%.......
    0x4a, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@.......
    0x0a, 0xf6, 0xff, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.......
    0x00, 0xba, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@+......
    0x00, 0x72, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@%......
    0x00, 0x2a, 0xff, 0xff, 0xee, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0x00, 0xe0, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@......
    0x00, 0x00, 0x9a, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@%.....
    0x00, 0x00, 0x52, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@.....
    0x00, 0x00, 0x0e, 0xfa, 0xff, 0xfc, 0x14, 0x00, 0x00, 0x00, 0x00,  //...@@@.....
    0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00,  //...@@@+....
    0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00,  //...+@@%....
    0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xe8, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xe6, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xa0, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00,  //....%@@+...
    0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00,  //....+@@@...
    0x00, 0x00, 0x00, 0x00, 0x12, 0xfc, 0xff, 0xfa, 0x0e, 0x00, 0x00,  //.....@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0xff, 0x52, 0x00, 0x00,  //.....@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x9a, 0x00, 0x00,  //.....+@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xe2, 0x00, 0x00,  //......@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xec, 0xff, 0xff, 0x2a, 0x00,  //......@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0x72, 0x00,  //......%@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xba, 0x00,  //......+@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xf6, 0x0a,  //.......@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0x4a,  //.......@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0x92,  //.......%@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xda,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+005d (]) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+005e (^) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@@@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xd6, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xff, 0x80, 0x00, 0x82, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@+.%@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xfa, 0x64, 0x00, 0x00, 0x00, 0x64, 0xfa, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00,  //....%@@@+...+@@@%....
    0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xf2, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf4, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00,  //...%@@@+.....+@@@%...
    0x00, 0x00, 0x86, 0xff, 0xff, 0xe8, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xe8, 0xff, 0xff, 0x86, 0x00, 0x00,  //..%@@@.........@@@%..
    0x00, 0x84, 0xff, 0xff, 0xd8, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xda, 0xff, 0xff, 0x82, 0x00,  //.%@@@...........@@@%.
    0x80, 0xff, 0xff, 0xc6, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xc6, 0xff, 0xff, 0x80,  //+@@@.............@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+005f (_) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0060 (`) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x8a, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00,  //%@@%....
    0x00, 0xa0, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00,  //.%@@+...
    0x00, 0x02, 0xb6, 0xff, 0xfa, 0x42, 0x00, 0x00,  //..%@@+..
    0x00, 0x00, 0x0a, 0xc8, 0xff, 0xea, 0x1c, 0x00,  //...@@@..
    0x00, 0x00, 0x00, 0x12, 0xd6, 0xff, 0xc8, 0x06,  //....@@@.
    0x00, 0x00, 0x00, 0x00, 0x1e, 0xe4, 0xff, 0x9a,  //.....@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0061 (a) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x28, 0x82, 0xbe, 0xe8, 0xf8, 0xee, 0xda, 0xa6, 0x5e, 0x04, 0x00, 0x00, 0x00,  //....%%@@@@%+....
    0x00, 0x40, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x3c, 0x00, 0x00,  //..%@@@@@@@@@@...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x3c, 0x00,  //.@@@@@@@@@@@@@..
    0x00, 0xff, 0xfc, 0xba, 0x66, 0x2c, 0x10, 0x02, 0x0e, 0x34, 0x80, 0xec, 0xff, 0xff, 0xe2, 0x04,  //.@@%+.....+@@@@.
    0x00, 0xb4, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xd6, 0xff, 0xff, 0x5c,  //.%..........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xa6,  //............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xd8,  //.............@@@
    0x00, 0x00, 0x00, 0x28, 0x7e, 0xb8, 0xe0, 0xf0, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee,  //....+%@@@@@@@@@@
    0x00, 0x0a, 0xa2, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //..%@@@@@@@@@@@@@
    0x02, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@@@@@
    0x6a, 0xff, 0xff, 0xff, 0xb8, 0x60, 0x30, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //+@@@%+.......@@@
    0xc4, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xff,  //@@@%.........@@@
    0xee, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xff,  //@@@.........+@@@
    0xf8, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0xff,  //@@@.........@@@@
    0xdc, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x9a, 0xff, 0xff, 0xff, 0xff,  //@@@+.......%@@@@
    0x90, 0xff, 0xff, 0xfc, 0x9a, 0x36, 0x10, 0x04, 0x1e, 0x60, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff,  //%@@@%....+@@@@@@
    0x1a, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@%@@@
    0x00, 0x38, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x80, 0x00, 0xff, 0xff, 0xff,  //..@@@@@@@@@+.@@@
    0x00, 0x00, 0x10, 0x7a, 0xc8, 0xee, 0xf8, 0xe6, 0xca, 0x84, 0x26, 0x00, 0x00, 0xff, 0xff, 0xff,  //...+@@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0062 (b) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x32, 0x92, 0xd4, 0xee, 0xf4, 0xda, 0x9a, 0x34, 0x00, 0x00, 0x00, 0x00,  //@@@...%@@@@%.....
    0xff, 0xff, 0xff, 0x02, 0x8e, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x92, 0x02, 0x00, 0x00,  //@@@.%@@@@@@@@%...
    0xff, 0xff, 0xff, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa6, 0x00, 0x00,  //@@@%@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x58, 0x18, 0x04, 0x18, 0x58, 0xd2, 0xff, 0xff, 0xff, 0x66, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xb2, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb2, 0xff, 0xff, 0xec, 0x08,  //@@@@%.......%@@@.
    0xff, 0xff, 0xff, 0xe4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe4, 0xff, 0xff, 0x5e,  //@@@@.........@@@+
    0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xa2,  //@@@+.........+@@%
    0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xd6,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xd8,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xa4,  //@@@+.........+@@%
    0xff, 0xff, 0xff, 0xe4, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe4, 0xff, 0xff, 0x5e,  //@@@@.........@@@+
    0xff, 0xff, 0xff, 0xff, 0xae, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xb0, 0xff, 0xff, 0xec, 0x08,  //@@@@%.......%@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x58, 0x16, 0x04, 0x16, 0x58, 0xd0, 0xff, 0xff, 0xff, 0x68, 0x00,  //@@@@@@+...+@@@@+.
    0xff, 0xff, 0xff, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00, 0x00,  //@@@%@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0x02, 0x90, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x96, 0x02, 0x00, 0x00,  //@@@.%@@@@@@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x36, 0x96, 0xd6, 0xf0, 0xf4, 0xdc, 0x9c, 0x36, 0x00, 0x00, 0x00, 0x00,  //@@@...%@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0063 (c) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x98, 0xd2, 0xea, 0xfa, 0xf2, 0xda, 0xb4, 0x78, 0x28,  //.....+%@@@@@%+.
    0x00, 0x00, 0x00, 0x3a, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....@@@@@@@@@@@
    0x00, 0x00, 0x5c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..+@@@@@@@@@@@@
    0x00, 0x3c, 0xf8, 0xff, 0xff, 0xf4, 0x90, 0x40, 0x12, 0x02, 0x0a, 0x24, 0x4c, 0x88, 0xd6,  //..@@@@%.....+%@
    0x00, 0xd6, 0xff, 0xff, 0xda, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@..........
    0x4e, 0xff, 0xff, 0xf4, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@...........
    0x9a, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%...........
    0xd4, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xec, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xec, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xd4, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0x9a, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%...........
    0x4e, 0xff, 0xff, 0xf2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@...........
    0x00, 0xd4, 0xff, 0xff, 0xd8, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@..........
    0x00, 0x3c, 0xfa, 0xff, 0xff, 0xf4, 0x8e, 0x3e, 0x10, 0x02, 0x0a, 0x22, 0x4c, 0x88, 0xd4,  //..@@@@%.....+%@
    0x00, 0x00, 0x60, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..+@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x40, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x02, 0x54, 0xa0, 0xd8, 0xee, 0xfa, 0xf2, 0xda, 0xb2, 0x78, 0x28,  //.....+%@@@@@%+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0064 (d) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..............@@@
    0x00, 0x00, 0x00, 0x00, 0x36, 0x9a, 0xda, 0xf4, 0xee, 0xd4, 0x92, 0x32, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....%@@@@%...@@@
    0x00, 0x00, 0x02, 0x94, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x8e, 0x02, 0xff, 0xff, 0xff,  //...%@@@@@@@@%.@@@
    0x00, 0x00, 0xa6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@%@@@
    0x00, 0x66, 0xff, 0xff, 0xff, 0xd2, 0x58, 0x18, 0x04, 0x18, 0x5a, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff,  //.+@@@@+...+@@@@@@
    0x08, 0xec, 0xff, 0xff, 0xb2, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb4, 0xff, 0xff, 0xff, 0xff,  //.@@@%.......%@@@@
    0x5e, 0xff, 0xff, 0xe4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe6, 0xff, 0xff, 0xff,  //+@@@.........@@@@
    0xa4, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff,  //%@@+.........+@@@
    0xd8, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xee, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xee, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xd8, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xa4, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xff,  //%@@+.........+@@@
    0x60, 0xff, 0xff, 0xe4, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe6, 0xff, 0xff, 0xff,  //+@@@.........@@@@
    0x08, 0xec, 0xff, 0xff, 0xae, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb2, 0xff, 0xff, 0xff, 0xff,  //.@@@%.......%@@@@
    0x00, 0x68, 0xff, 0xff, 0xff, 0xd0, 0x56, 0x16, 0x04, 0x16, 0x58, 0xd2, 0xff, 0xff, 0xff, 0xff, 0xff,  //.+@@@@+...+@@@@@@
    0x00, 0x00, 0xaa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@%@@@
    0x00, 0x00, 0x02, 0x98, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x90, 0x02, 0xff, 0xff, 0xff,  //...%@@@@@@@@%.@@@
    0x00, 0x00, 0x00, 0x00, 0x36, 0x9c, 0xdc, 0xf6, 0xf0, 0xd6, 0x96, 0x36, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....%@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0065 (e) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x08, 0x64, 0xae, 0xde, 0xf4, 0xf4, 0xde, 0xa8, 0x56, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+....
    0x00, 0x00, 0x00, 0x4e, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x24, 0x00, 0x00,  //...+@@@@@@@@@@...
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x24, 0x00,  //..+@@@@@@@@@@@@..
    0x00, 0x40, 0xfc, 0xff, 0xff, 0xb6, 0x52, 0x1c, 0x04, 0x08, 0x28, 0x78, 0xee, 0xff, 0xff, 0xce, 0x00,  //..@@@%+....+@@@@.
    0x00, 0xd6, 0xff, 0xfc, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xe0, 0xff, 0xff, 0x52,  //.@@@+........@@@+
    0x4c, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xff, 0xa4,  //+@@%.........+@@%
    0x98, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xda,  //%@@...........@@@
    0xd0, 0xff, 0xff, 0xfa, 0xfa, 0xfa, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xf2,  //@@@@@@@@@@@@@@@@@
    0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@
    0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@
    0xee, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xd8, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xa2, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@%.............
    0x58, 0xff, 0xff, 0xf2, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@@.............
    0x02, 0xdc, 0xff, 0xff, 0xd0, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xb8, 0x00,  //.@@@@..........%.
    0x00, 0x46, 0xfc, 0xff, 0xff, 0xee, 0x86, 0x38, 0x0e, 0x02, 0x12, 0x32, 0x6e, 0xc4, 0xff, 0xff, 0x00,  //.+@@@@%.....+@@@.
    0x00, 0x00, 0x6a, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..+@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x48, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x44, 0x00,  //...+@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x02, 0x58, 0xa2, 0xd8, 0xee, 0xfa, 0xe8, 0xc4, 0x8a, 0x34, 0x00, 0x00, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0066 (f) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xae, 0xe2, 0xf6, 0xff, 0xff, 0xff,  //.....+%@@@@@
    0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....%@@@@@@@
    0x00, 0x00, 0x00, 0x50, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...+@@@@@@@@
    0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0xbc, 0x30, 0x08, 0x00, 0x00, 0x00,  //...%@@%.....
    0x00, 0x00, 0x00, 0xe4, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0067 (g) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x3a, 0x9c, 0xdc, 0xf4, 0xee, 0xd4, 0x92, 0x32, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....%@@@@%...@@@
    0x00, 0x00, 0x04, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x8e, 0x02, 0xff, 0xff, 0xff,  //...%@@@@@@@@%.@@@
    0x00, 0x00, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0xff, 0xff, 0xff,  //..%@@@@@@@@@@%@@@
    0x00, 0x70, 0xff, 0xff, 0xff, 0xcc, 0x54, 0x16, 0x04, 0x18, 0x56, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff,  //.+@@@@+...+@@@@@@
    0x0a, 0xf0, 0xff, 0xff, 0xa6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xaa, 0xff, 0xff, 0xff, 0xff,  //.@@@%.......%@@@@
    0x62, 0xff, 0xff, 0xe0, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xe0, 0xff, 0xff, 0xff,  //+@@@.........@@@@
    0xa6, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xff,  //%@@+.........+@@@
    0xd8, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xee, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xee, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xda, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xa6, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xff,  //%@@+.........+@@@
    0x64, 0xff, 0xff, 0xde, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xe0, 0xff, 0xff, 0xff,  //+@@@.........@@@@
    0x0c, 0xf0, 0xff, 0xff, 0xa6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xa8, 0xff, 0xff, 0xff, 0xff,  //.@@@%.......%@@@@
    0x00, 0x72, 0xff, 0xff, 0xff, 0xca, 0x54, 0x16, 0x04, 0x16, 0x54, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff,  //.+@@@@+...+@@@@@@
    0x00, 0x00, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0xff, 0xff, 0xfa,  //..%@@@@@@@@@@%@@@
    0x00, 0x00, 0x06, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x8e, 0x0c, 0xff, 0xff, 0xea,  //...%@@@@@@@@%.@@@
    0x00, 0x00, 0x00, 0x00, 0x3c, 0x9e, 0xdc, 0xf6, 0xee, 0xd4, 0x94, 0x34, 0x00, 0x24, 0xff, 0xff, 0xd8,  //.....%@@@@%...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xaa,  //.............+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xd2, 0xff, 0xff, 0x70,  //.............@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xa0, 0xff, 0xff, 0xf8, 0x16,  //............%@@@.
    0x00, 0x00, 0xd6, 0x88, 0x4c, 0x2c, 0x16, 0x04, 0x0c, 0x2a, 0x6a, 0xd6, 0xff, 0xff, 0xff, 0x90, 0x00,  //..@%+.....+@@@@%.
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x08, 0x00,  //..@@@@@@@@@@@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xa2, 0x0a, 0x00, 0x00,  //..@@@@@@@@@@@%...
    0x00, 0x00, 0x26, 0x72, 0xac, 0xce, 0xe0, 0xf4, 0xf6, 0xe6, 0xc4, 0x86, 0x2a, 0x00, 0x00, 0x00, 0x00,  //...+%@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0068 (h) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x22, 0x84, 0xce, 0xea, 0xf8, 0xe4, 0xb0, 0x56, 0x00, 0x00, 0x00,  //@@@...%@@@@%+...
    0xff, 0xff, 0xff, 0x00, 0x76, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x0c, 0x00,  //@@@.+@@@@@@@@%..
    0xff, 0xff, 0xff, 0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x00,  //@@@%@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x4e, 0x16, 0x04, 0x10, 0x4c, 0xce, 0xff, 0xff, 0xff, 0x3c,  //@@@@@%+...+@@@@.
    0xff, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xd2, 0xff, 0xff, 0x98,  //@@@@+.......@@@%
    0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xd0,  //@@@%........+@@@
    0xff, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xec,  //@@@+.........@@@
    0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfc,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0069 (i) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+006a (j) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x04, 0xff, 0xff, 0xf6,  //...@@@
    0x00, 0x00, 0x16, 0xff, 0xff, 0xe6,  //...@@@
    0x00, 0x00, 0x4a, 0xff, 0xff, 0xc0,  //..+@@%
    0x04, 0x34, 0xd2, 0xff, 0xff, 0x82,  //..@@@%
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x22,  //@@@@@.
    0xff, 0xff, 0xff, 0xfc, 0x66, 0x00,  //@@@@+.
    0xf8, 0xe2, 0xa8, 0x3a, 0x00, 0x00,  //@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+006b (k) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xf2, 0xff, 0xff, 0xfa, 0x6a,  //@@@........+@@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xfc, 0xff, 0xff, 0xee, 0x44, 0x00,  //@@@.......+@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x9e, 0xff, 0xff, 0xff, 0xda, 0x26, 0x00, 0x00,  //@@@......%@@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x12, 0xc2, 0xff, 0xff, 0xff, 0xbe, 0x10, 0x00, 0x00, 0x00,  //@@@.....@@@@%....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x28, 0xdc, 0xff, 0xff, 0xff, 0x9a, 0x04, 0x00, 0x00, 0x00, 0x00,  //@@@....@@@@%.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x46, 0xf0, 0xff, 0xff, 0xfc, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..+@@@@+......
    0xff, 0xff, 0xff, 0x00, 0x6c, 0xfa, 0xff, 0xff, 0xf0, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.+@@@@+.......
    0xff, 0xff, 0xff, 0x96, 0xff, 0xff, 0xff, 0xde, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%@@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@..........
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xe0, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@..........
    0xff, 0xff, 0xff, 0x4e, 0xf6, 0xff, 0xff, 0xe6, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+@@@@.........
    0xff, 0xff, 0xff, 0x00, 0x44, 0xf4, 0xff, 0xff, 0xea, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.+@@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x3c, 0xf0, 0xff, 0xff, 0xf0, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...@@@@.......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x32, 0xec, 0xff, 0xff, 0xf4, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@....@@@@+.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xe6, 0xff, 0xff, 0xf6, 0x4c, 0x00, 0x00, 0x00, 0x00,  //@@@.....@@@@+....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe0, 0xff, 0xff, 0xfa, 0x56, 0x00, 0x00, 0x00,  //@@@......@@@@+...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xda, 0xff, 0xff, 0xfc, 0x60, 0x00, 0x00,  //@@@.......@@@@+..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xd4, 0xff, 0xff, 0xfc, 0x6c, 0x00,  //@@@........@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xcc, 0xff, 0xff, 0xff, 0x78,  //@@@.........@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+006c (l) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+006d (m) , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x38, 0x9a, 0xd8, 0xf2, 0xec, 0xca, 0x74, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x30, 0x96, 0xd4, 0xf0, 0xf2, 0xce, 0x7a, 0x08, 0x00, 0x00,  //@@@...%@@@@+......%@@@@+...
    0xff, 0xff, 0xff, 0x00, 0x90, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x1e, 0x00, 0x02, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x18, 0x00,  //@@@.%@@@@@@@@...%@@@@@@@@..
    0xff, 0xff, 0xff, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x02, 0x96, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x00,  //@@@%@@@@@@@@@@.%@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x9e, 0x38, 0x0c, 0x06, 0x32, 0xae, 0xff, 0xff, 0xff, 0xb0, 0xff, 0xfc, 0x9c, 0x38, 0x0c, 0x06, 0x30, 0xae, 0xff, 0xff, 0xff, 0x46,  //@@@@@%....%@@@%@@%....%@@@+
    0xff, 0xff, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xba, 0xff, 0xff, 0x9e,  //@@@@+......%@@@@+......%@@%
    0xff, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xd2,  //@@@%.......+@@@%.......+@@@
    0xff, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xee,  //@@@.........@@@.........@@@
    0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfc,  //@@@.........@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+006e (n) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x22, 0x84, 0xce, 0xea, 0xf8, 0xe4, 0xb0, 0x56, 0x00, 0x00, 0x00,  //@@@...%@@@@%+...
    0xff, 0xff, 0xff, 0x00, 0x76, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x0c, 0x00,  //@@@.+@@@@@@@@%..
    0xff, 0xff, 0xff, 0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x00,  //@@@%@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x4e, 0x16, 0x04, 0x10, 0x4c, 0xce, 0xff, 0xff, 0xff, 0x3c,  //@@@@@%+...+@@@@.
    0xff, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xd2, 0xff, 0xff, 0x98,  //@@@@+.......@@@%
    0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xd0,  //@@@%........+@@@
    0xff, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xec,  //@@@+.........@@@
    0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfc,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+006f (o) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x22, 0x84, 0xc8, 0xe8, 0xf8, 0xe8, 0xc8, 0x84, 0x22, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x88, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x84, 0x00, 0x00, 0x00,  //...%@@@@@@@@@%...
    0x00, 0x00, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0x00, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x6e, 0xff, 0xff, 0xff, 0xd4, 0x5a, 0x18, 0x04, 0x18, 0x5a, 0xd4, 0xff, 0xff, 0xff, 0x6c, 0x00,  //.+@@@@+...+@@@@+.
    0x0a, 0xee, 0xff, 0xff, 0xb2, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xb8, 0xff, 0xff, 0xee, 0x0a,  //.@@@%.......%@@@.
    0x66, 0xff, 0xff, 0xe4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe8, 0xff, 0xff, 0x64,  //+@@@.........@@@+
    0xa8, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xa6,  //%@@+.........+@@%
    0xd8, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xd8,  //@@@...........@@@
    0xee, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@...........@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@...........@@@
    0xee, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //@@@...........@@@
    0xd8, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xd8,  //@@@...........@@@
    0xa6, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xa4,  //%@@+.........+@@%
    0x64, 0xff, 0xff, 0xe4, 