
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_DEJAVU_30_LATIN_SUP != 0    /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * DejaVuSans.ttf 30 px Font in U+00a0 ( ) .. U+00ff (ÿ)  range with 1 bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_dejavu_30_latin_sup_glyph_bitmap[] = {
#if USE_LV_FONT_DEJAVU_30_LATIN_SUP == 1
    /*Unicode: U+00a0 ( ) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00a1 (¡) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //%@%
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...


    /*Unicode: U+00a2 (¢) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x02, 0x00,  //......@....
    0x02, 0x00,  //......@....
    0x02, 0x00,  //......@....
    0x02, 0x00,  //......@....
    0x0f, 0xc0,  //...+%@@@@%.
    0x3f, 0xe0,  //..%@@@@@@@@
    0x7a, 0x20,  //.%@@%.@..+@
    0x72, 0x00,  //+@@@..@....
    0xe2, 0x00,  //%@@+..@....
    0xe2, 0x00,  //@@@...@....
    0xe2, 0x00,  //@@@...@....
    0xe2, 0x00,  //@@@...@....
    0xe2, 0x00,  //@@@...@....
    0xe2, 0x00,  //%@@+..@....
    0x72, 0x00,  //+@@@..@....
    0x7a, 0x20,  //.%@@%.@..+@
    0x3f, 0xe0,  //..%@@@@@@@@
    0x0f, 0xc0,  //...+%@@@@%.
    0x02, 0x00,  //......@....
    0x02, 0x00,  //......@....
    0x02, 0x00,  //......@....
    0x02, 0x00,  //......@....
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+00a3 (£) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x03, 0xf0,  //......%@@@@%.
    0x07, 0xf8,  //....+@@@@@@@@
    0x0e, 0x08,  //....@@@+...+@
    0x1c, 0x00,  //...%@@+......
    0x1c, 0x00,  //...@@@.......
    0x1c, 0x00,  //...@@@.......
    0x1c, 0x00,  //...@@@.......
    0x1c, 0x00,  //...@@@.......
    0x1c, 0x00,  //...@@@.......
    0xff, 0xe0,  //@@@@@@@@@@@..
    0xff, 0xe0,  //@@@@@@@@@@@..
    0x1c, 0x00,  //...@@@.......
    0x1c, 0x00,  //...@@@.......
    0x1c, 0x00,  //...@@@.......
    0x1c, 0x00,  //...@@@.......
    0x1c, 0x00,  //...@@@.......
    0x1c, 0x00,  //...@@@.......
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00a4 (¤) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x40, 0x04,  //.%...........%.
    0xe0, 0x0e,  //%@@.........@@%
    0x77, 0xdc,  //.@@@.%@@@%.@@@.
    0x3f, 0xf8,  //..@@@@@@@@@@@..
    0x1c, 0x70,  //...@@%...%@@...
    0x38, 0x38,  //..%@%.....%@%..
    0x30, 0x18,  //..@@.......@@..
    0x30, 0x18,  //..@@.......@@..
    0x30, 0x18,  //..@@.......@@..
    0x38, 0x38,  //..%@%.....%@%..
    0x1c, 0x70,  //...@@%...%@@...
    0x3f, 0xf8,  //..@@@@@@@@@@@..
    0x77, 0xdc,  //.@@@.%@@@%.@@@.
    0xe0, 0x0e,  //%@@.........@@%
    0x40, 0x04,  //.%...........%.
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+00a5 (¥) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xf0, 0x1e,  //%@@%.......%@@%
    0x70, 0x1c,  //.@@@.......@@@.
    0x78, 0x38,  //.%@@%.....%@@+.
    0x38, 0x38,  //..@@@+...+@@@..
    0x1c, 0x70,  //..+@@@...@@@+..
    0x1c, 0x70,  //...%@@+.+@@%...
    0x0e, 0xe0,  //....@@@.@@@....
    0x7f, 0xfc,  //.@@@@@@%@@@@@@.
    0x7f, 0xfc,  //.@@@@@@@@@@@@@.
    0x07, 0xc0,  //.....@@@@@.....
    0x03, 0x80,  //.....+@@@+.....
    0x03, 0x80,  //......@@@......
    0x7f, 0xfc,  //.@@@@@@@@@@@@@.
    0x7f, 0xfc,  //.@@@@@@@@@@@@@.
    0x03, 0x80,  //......@@@......
    0x03, 0x80,  //......@@@......
    0x03, 0x80,  //......@@@......
    0x03, 0x80,  //......@@@......
    0x03, 0x80,  //......@@@......
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+00a6 (¦) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00a7 (§) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x1f, 0x80,  //...%@@@@%..
    0x3f, 0xc0,  //..@@@@@@@@.
    0x70, 0x40,  //.@@%....+@.
    0x60, 0x00,  //.@@........
    0x60, 0x00,  //.@@+.......
    0x78, 0x00,  //.+@@%......
    0x3e, 0x00,  //..@@@@%....
    0x6f, 0x00,  //.@@+%@@@+..
    0xc3, 0xc0,  //%@+...%@@%.
    0xc0, 0xe0,  //@@.....+@@%
    0xc0, 0x60,  //@@+.....+@@
    0x70, 0x60,  //+@@%.....@@
    0x38, 0x60,  //.+@@@+..+@%
    0x1f, 0xc0,  //...%@@@%@@.
    0x07, 0x80,  //....+@@@@..
    0x01, 0xc0,  //......+@@%.
    0x00, 0xc0,  //........@@.
    0x00, 0xc0,  //........@@.
    0x41, 0xc0,  //.@+....%@%.
    0x7f, 0x80,  //.@@@@@@@@..
    0x3f, 0x00,  //..%@@@@%...
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+00a8 (¨) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xe7,  //@@@..@@@
    0xe7,  //@@@..@@@
    0xe7,  //@@@..@@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00a9 (©) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x01, 0xf0, 0x00,  //......+@@@@@+......
    0x0e, 0x0e, 0x00,  //....%@%.....%@%....
    0x18, 0x03, 0x00,  //...@%.........%@...
    0x30, 0xf9, 0x80,  //..@%...+@@@@%..%@..
    0x63, 0x04, 0xc0,  //.%%...@@+...+%..%%.
    0x46, 0x00, 0x40,  //.@...@@..........@.
    0x46, 0x00, 0x40,  //+%..+@%..........%+
    0x8c, 0x00, 0x20,  //@+..%@............@
    0x8c, 0x00, 0x20,  //@...@@............@
    0x8c, 0x00, 0x20,  //@...@@............@
    0x8c, 0x00, 0x20,  //@...@@............@
    0x8c, 0x00, 0x20,  //@+..%@............@
    0xc6, 0x00, 0x40,  //+%..+@%..........%+
    0x46, 0x00, 0x40,  //.@...@@..........@.
    0x63, 0x04, 0xc0,  //.%%...@@+...+%..%%.
    0x30, 0xf9, 0x80,  //..@%...+@@@@%..%@..
    0x18, 0x03, 0x00,  //...@%.........%@...
    0x0e, 0x0e, 0x00,  //....%@%.....%@%....
    0x01, 0xf0, 0x00,  //......+@@@@@+......
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00aa (ª) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x3f, 0x00,  //..%@@@@%+..
    0x41, 0x80,  //.@+....@@+.
    0x00, 0xc0,  //........@@.
    0x3f, 0xc0,  //..%@@@@@@@.
    0x60, 0xc0,  //.@@+....@@.
    0xc0, 0xc0,  //@@......@@.
    0xc0, 0xc0,  //@@.....+@@.
    0xc1, 0xc0,  //@@.....@@@.
    0x63, 0xc0,  //+@@...%@@@.
    0x3e, 0xc0,  //.+@@@@%.@@.
    0x00, 0x00,  //...........
    0xff, 0xc0,  //%@@@@@@@@@.
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+00ab («) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x04, 0x10,  //.....%.....%
    0x0c, 0x30,  //....%@....%@
    0x1c, 0x70,  //...%@@...%@@
    0x38, 0xe0,  //..@@@...@@@.
    0x71, 0xc0,  //.@@@...@@@..
    0xe3, 0x80,  //@@@...@@@...
    0xe3, 0x80,  //@@@...@@@...
    0x71, 0xc0,  //.@@@...@@@..
    0x38, 0xe0,  //..@@@...@@@.
    0x1c, 0x70,  //...%@@...%@@
    0x0c, 0x30,  //....%@....%@
    0x04, 0x10,  //.....%.....%
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00ac (¬) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x03,  //..............@@
    0x00, 0x03,  //..............@@
    0x00, 0x03,  //..............@@
    0x00, 0x03,  //..............@@
    0x00, 0x03,  //..............@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00ad (­) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0xfe,  //@@@@@@@
    0xfe,  //@@@@@@@
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+00ae (®) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x01, 0xf0, 0x00,  //......+@@@@@+......
    0x0e, 0x0e, 0x00,  //....%@%.....%@%....
    0x18, 0x03, 0x00,  //...@%.........%@...
    0x37, 0xf1, 0x80,  //..@%.@@@@@@%+..%@..
    0x66, 0x1c, 0xc0,  //.%%..@@....%@%..%%.
    0x46, 0x0c, 0x40,  //.@...@@.....@@...@.
    0x46, 0x0c, 0x40,  //+%...@@.....@@...%+
    0x86, 0x1c, 0x20,  //@+...@@....%@%....@
    0x87, 0xf0, 0x20,  //@....@@@@@@@+.....@
    0x86, 0x70, 0x20,  //@....@@..%@@......@
    0x86, 0x38, 0x20,  //@....@@...@@%.....@
    0x86, 0x18, 0x20,  //@+...@@...+@@.....@
    0xc6, 0x1c, 0x40,  //+%...@@....@@%...%+
    0x46, 0x0c, 0x40,  //.@...@@....+@@...@.
    0x66, 0x0c, 0xc0,  //.%%..@@.....@@+.%%.
    0x36, 0x0f, 0x80,  //..@%.@@.....%@@%@..
    0x18, 0x03, 0x00,  //...@%.........%@...
    0x0e, 0x0e, 0x00,  //....%@%.....%@%....
    0x01, 0xf0, 0x00,  //......+@@@@@+......
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00af (¯) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00b0 (°) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x3c,  //..%@@%..
    0x7e,  //.@@@@@@.
    0xe7,  //%@%..%@%
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xe7,  //%@%..%@%
    0x7e,  //.@@@@@@.
    0x3c,  //..%@@%..
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00b1 (±) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00b2 (²) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x7c,  //.%@@@%..
    0x86,  //@+...@@+
    0x03,  //......@@
    0x03,  //......@@
    0x07,  //.....%@%
    0x06,  //....+@@.
    0x0c,  //...+@@+.
    0x18,  //..+@@+..
    0x30,  //.+@@+...
    0x60,  //+@@+....
    0xff,  //@@@@@@@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00b3 (³) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x7c,  //.%@@@@+.
    0x87,  //@+...%@%
    0x03,  //......@@
    0x07,  //.....%@%
    0x3c,  //..@@@@+.
    0x06,  //.....@@+
    0x03,  //......@@
    0x03,  //......@@
    0x03,  //......@@
    0x86,  //%...+@@+
    0x7c,  //.%@@@%..
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00b4 (´) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x1c,  //...@@%
    0x38,  //..%@%.
    0x30,  //..@@..
    0x60,  //.@@...
    0xc0,  //%@+...
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+00b5 (µ) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0xf0,  //@@@+....%@@@..
    0xf0, 0xf0,  //@@@@+..+@@@@..
    0xff, 0xfc,  //@@@%@@@@@%@@@@
    0xef, 0x3c,  //@@@.%@@%..%@@%
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0xe0, 0x00,  //@@@...........
    0x00, 0x00,  //..............


    /*Unicode: U+00b6 (¶) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x0f, 0xf0,  //...+@@@@@@@@
    0x3f, 0xf0,  //..@@@@@@@@@@
    0x7f, 0x30,  //.@@@@@@@..@@
    0xff, 0x30,  //%@@@@@@@..@@
    0xff, 0x30,  //@@@@@@@@..@@
    0xff, 0x30,  //@@@@@@@@..@@
    0xff, 0x30,  //@@@@@@@@..@@
    0xff, 0x30,  //%@@@@@@@..@@
    0x7f, 0x30,  //.@@@@@@@..@@
    0x3f, 0x30,  //.+@@@@@@..@@
    0x1f, 0x30,  //...%@@@@..@@
    0x03, 0x30,  //......@@..@@
    0x03, 0x30,  //......@@..@@
    0x03, 0x30,  //......@@..@@
    0x03, 0x30,  //......@@..@@
    0x03, 0x30,  //......@@..@@
    0x03, 0x30,  //......@@..@@
    0x03, 0x30,  //......@@..@@
    0x03, 0x30,  //......@@..@@
    0x03, 0x30,  //......@@..@@
    0x03, 0x30,  //......@@..@@
    0x03, 0x30,  //......@@..@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00b7 (·) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00b8 (¸) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x30,  //..%@+
    0x18,  //...@%
    0x18,  //...@@
    0xf8,  //@@@@@
    0xf0,  //%@@@.
    0x00,  //.....


    /*Unicode: U+00b9 (¹) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x38,  //.+@@@...
    0x98,  //@+.@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0xff,  //@@@@@@@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00ba (º) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x1e, 0x00,  //..+@@@@+..
    0x61, 0x80,  //.%@+..+@%.
    0x61, 0x80,  //+@%....%@+
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0x61, 0x80,  //+@%....%@+
    0x61, 0x80,  //.%@+..+@%.
    0x1e, 0x00,  //..+@@@@+..
    0x00, 0x00,  //..........
    0x7f, 0x80,  //+@@@@@@@@+
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00bb (») , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x82, 0x00,  //%.....%.....
    0xc3, 0x00,  //@%....@%....
    0xe3, 0x80,  //@@%...@@%...
    0x71, 0xc0,  //.@@@...@@@..
    0x38, 0xe0,  //..@@@...@@@.
    0x1c, 0x70,  //...@@@...@@@
    0x1c, 0x70,  //...@@@...@@@
    0x38, 0xe0,  //..@@@...@@@.
    0x71, 0xc0,  //.@@@...@@@..
    0xe3, 0x80,  //@@%...@@%...
    0xc3, 0x00,  //@%....@%....
    0x82, 0x00,  //%.....%.....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00bc (¼) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x38, 0x03, 0x80,  //.+@@@.........%@%......
    0x98, 0x03, 0x00,  //@+.@@........+@@.......
    0x18, 0x06, 0x00,  //...@@........@@+.......
    0x18, 0x06, 0x00,  //...@@.......+@@........
    0x18, 0x0c, 0x00,  //...@@.......@@.........
    0x18, 0x1c, 0x00,  //...@@......%@%.........
    0x18, 0x18, 0x00,  //...@@.....+@@..........
    0x18, 0x30, 0x00,  //...@@.....@@+..........
    0x18, 0x70, 0x18,  //...@@....%@@......+@@..
    0x18, 0x60, 0x38,  //...@@....@@.......@@@..
    0xff, 0xe0, 0x58,  //@@@@@@@@@@%......@+@@..
    0x00, 0xc0, 0xd8,  //.......+@@......%%.@@..
    0x01, 0x80, 0x98,  //.......@@+.....+@..@@..
    0x03, 0x81, 0x18,  //......%@%......@+..@@..
    0x03, 0x03, 0x18,  //......@@......@%...@@..
    0x06, 0x03, 0xfe,  //.....@@+......@@@@@@@@@
    0x06, 0x00, 0x18,  //....+@@............@@..
    0x0c, 0x00, 0x18,  //....@@+............@@..
    0x1c, 0x00, 0x18,  //...%@%.............@@..
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00bd (½) , Width: 22 */
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x38, 0x03, 0x80,  //.+@@@.........%@%.....
    0x98, 0x03, 0x00,  //@+.@@........+@@......
    0x18, 0x06, 0x00,  //...@@........@@+......
    0x18, 0x06, 0x00,  //...@@.......+@@.......
    0x18, 0x0c, 0x00,  //...@@.......@@........
    0x18, 0x1c, 0x00,  //...@@......%@%........
    0x18, 0x18, 0x00,  //...@@.....+@@.........
    0x18, 0x30, 0x00,  //...@@.....@@+.........
    0x18, 0x71, 0xf0,  //...@@....%@@...%@@@%..
    0x18, 0x62, 0x18,  //...@@....@@...@+...@@+
    0xff, 0xe0, 0x0c,  //@@@@@@@@@@%.........@@
    0x00, 0xc0, 0x0c,  //.......+@@..........@@
    0x01, 0x80, 0x1c,  //.......@@+.........%@%
    0x03, 0x80, 0x18,  //......%@%.........+@@.
    0x03, 0x00, 0x30,  //......@@.........+@@+.
    0x06, 0x00, 0x60,  //.....@@+........+@@+..
    0x06, 0x00, 0xc0,  //....+@@........+@@+...
    0x0c, 0x01, 0x80,  //....@@+.......+@@+....
    0x1c, 0x03, 0xfc,  //...%@%........@@@@@@@@
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................


    /*Unicode: U+00be (¾) , Width: 24 */
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x7c, 0x01, 0xc0,  //.%@@@@+........%@%......
    0x87, 0x01, 0x80,  //@+...%@%......+@@.......
    0x03, 0x03, 0x00,  //......@@......@@+.......
    0x07, 0x03, 0x00,  //.....%@%.....+@@........
    0x3c, 0x06, 0x00,  //..@@@@+......@@.........
    0x06, 0x0e, 0x00,  //.....@@+....%@%.........
    0x03, 0x0c, 0x00,  //......@@...+@@..........
    0x03, 0x18, 0x00,  //......@@...@@+..........
    0x03, 0x38, 0x0c,  //......@@..%@@......+@@..
    0x86, 0x30, 0x1c,  //%...+@@+..@@.......@@@..
    0x7c, 0x70, 0x2c,  //.%@@@%...@@%......@+@@..
    0x00, 0x60, 0x6c,  //........+@@......%%.@@..
    0x00, 0xc0, 0x4c,  //........@@+.....+@..@@..
    0x01, 0xc0, 0x8c,  //.......%@%......@+..@@..
    0x01, 0x81, 0x8c,  //.......@@......@%...@@..
    0x03, 0x01, 0xff,  //......@@+......@@@@@@@@@
    0x03, 0x00, 0x0c,  //.....+@@............@@..
    0x06, 0x00, 0x0c,  //.....@@+............@@..
    0x0e, 0x00, 0x0c,  //....%@%.............@@..
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................


    /*Unicode: U+00bf (¿) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x0e, 0x00,  //....@@@...
    0x0e, 0x00,  //....@@@...
    0x0e, 0x00,  //....@@@...
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x0e, 0x00,  //....@@@...
    0x0e, 0x00,  //....@@@...
    0x0e, 0x00,  //....@@@...
    0x0e, 0x00,  //....@@%...
    0x1c, 0x00,  //...%@@....
    0x18, 0x00,  //..+@@.....
    0x30, 0x00,  //.+@@......
    0x60, 0x00,  //+@@+......
    0xe0, 0x00,  //@@@.......
    0xe0, 0x00,  //@@@.......
    0xe0, 0x40,  //@@@+.....%
    0xf0, 0xc0,  //%@@@+..+@@
    0x7f, 0x80,  //.@@@@@@@@+
    0x1f, 0x00,  //..+@@@@%..
    0x00, 0x00,  //..........


    /*Unicode: U+00c0 (À) , Width: 17 */
    0x07, 0x00, 0x00,  //.....%@@.........
    0x03, 0x80, 0x00,  //......%@%........
    0x01, 0x80, 0x00,  //.......%@+.......
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //......+@@@+......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x07, 0x70, 0x00,  //.....@@@+@@@.....
    0x07, 0x70, 0x00,  //....+@@@.@@@+....
    0x0e, 0x38, 0x00,  //....%@@+.+@@%....
    0x0e, 0x38, 0x00,  //....@@@...@@@....
    0x0e, 0x38, 0x00,  //...+@@%...%@@+...
    0x1c, 0x1c, 0x00,  //...@@@+...+@@@...
    0x1c, 0x1c, 0x00,  //...@@@.....@@@...
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x3f, 0xfe, 0x00,  //..@@@@@@@@@@@@@..
    0x38, 0x0e, 0x00,  //.+@@@.......@@@+.
    0x70, 0x0f, 0x00,  //.%@@+.......+@@%.
    0x70, 0x07, 0x00,  //.@@@.........@@@.
    0x70, 0x07, 0x00,  //+@@%.........@@@+
    0xe0, 0x03, 0x80,  //@@@+.........+@@@
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c1 (Á) , Width: 17 */
    0x00, 0x60, 0x00,  //.........@@+.....
    0x00, 0xc0, 0x00,  //........%@+......
    0x01, 0x80, 0x00,  //.......%@+.......
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //......+@@@+......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x07, 0x70, 0x00,  //.....@@@+@@@.....
    0x07, 0x70, 0x00,  //....+@@@.@@@+....
    0x0e, 0x38, 0x00,  //....%@@+.+@@%....
    0x0e, 0x38, 0x00,  //....@@@...@@@....
    0x0e, 0x38, 0x00,  //...+@@%...%@@+...
    0x1c, 0x1c, 0x00,  //...@@@+...+@@@...
    0x1c, 0x1c, 0x00,  //...@@@.....@@@...
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x3f, 0xfe, 0x00,  //..@@@@@@@@@@@@@..
    0x38, 0x0e, 0x00,  //.+@@@.......@@@+.
    0x70, 0x0f, 0x00,  //.%@@+.......+@@%.
    0x70, 0x07, 0x00,  //.@@@.........@@@.
    0x70, 0x07, 0x00,  //+@@%.........@@@+
    0xe0, 0x03, 0x80,  //@@@+.........+@@@
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c2 (Â) , Width: 17 */
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x03, 0x60, 0x00,  //......@@+@@......
    0x06, 0x30, 0x00,  //.....%@...@%.....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //......+@@@+......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x07, 0x70, 0x00,  //.....@@@+@@@.....
    0x07, 0x70, 0x00,  //....+@@@.@@@+....
    0x0e, 0x38, 0x00,  //....%@@+.+@@%....
    0x0e, 0x38, 0x00,  //....@@@...@@@....
    0x0e, 0x38, 0x00,  //...+@@%...%@@+...
    0x1c, 0x1c, 0x00,  //...@@@+...+@@@...
    0x1c, 0x1c, 0x00,  //...@@@.....@@@...
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x3f, 0xfe, 0x00,  //..@@@@@@@@@@@@@..
    0x38, 0x0e, 0x00,  //.+@@@.......@@@+.
    0x70, 0x0f, 0x00,  //.%@@+.......+@@%.
    0x70, 0x07, 0x00,  //.@@@.........@@@.
    0x70, 0x07, 0x00,  //+@@%.........@@@+
    0xe0, 0x03, 0x80,  //@@@+.........+@@@
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c3 (Ã) , Width: 17 */
    0x03, 0xb0, 0x00,  //......@@%.@@.....
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x06, 0xe0, 0x00,  //.....@@.%@@......
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //......+@@@+......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x07, 0x70, 0x00,  //.....@@@+@@@.....
    0x07, 0x70, 0x00,  //....+@@@.@@@+....
    0x0e, 0x38, 0x00,  //....%@@+.+@@%....
    0x0e, 0x38, 0x00,  //....@@@...@@@....
    0x0e, 0x38, 0x00,  //...+@@%...%@@+...
    0x1c, 0x1c, 0x00,  //...@@@+...+@@@...
    0x1c, 0x1c, 0x00,  //...@@@.....@@@...
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x3f, 0xfe, 0x00,  //..@@@@@@@@@@@@@..
    0x38, 0x0e, 0x00,  //.+@@@.......@@@+.
    0x70, 0x0f, 0x00,  //.%@@+.......+@@%.
    0x70, 0x07, 0x00,  //.@@@.........@@@.
    0x70, 0x07, 0x00,  //+@@%.........@@@+
    0xe0, 0x03, 0x80,  //@@@+.........+@@@
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c4 (Ä) , Width: 17 */
    0x07, 0x70, 0x00,  //.....@@@.@@@.....
    0x07, 0x70, 0x00,  //.....@@@.@@@.....
    0x07, 0x70, 0x00,  //.....@@@.@@@.....
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //......+@@@+......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x07, 0x70, 0x00,  //.....@@@+@@@.....
    0x07, 0x70, 0x00,  //....+@@@.@@@+....
    0x0e, 0x38, 0x00,  //....%@@+.+@@%....
    0x0e, 0x38, 0x00,  //....@@@...@@@....
    0x0e, 0x38, 0x00,  //...+@@%...%@@+...
    0x1c, 0x1c, 0x00,  //...@@@+...+@@@...
    0x1c, 0x1c, 0x00,  //...@@@.....@@@...
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x3f, 0xfe, 0x00,  //..@@@@@@@@@@@@@..
    0x38, 0x0e, 0x00,  //.+@@@.......@@@+.
    0x70, 0x0f, 0x00,  //.%@@+.......+@@%.
    0x70, 0x07, 0x00,  //.@@@.........@@@.
    0x70, 0x07, 0x00,  //+@@%.........@@@+
    0xe0, 0x03, 0x80,  //@@@+.........+@@@
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c5 (Å) , Width: 17 */
    0x01, 0xc0, 0x00,  //......+@@@+......
    0x03, 0xe0, 0x00,  //.....+@@@@@+.....
    0x06, 0x30, 0x00,  //.....@@+.+@@.....
    0x06, 0x30, 0x00,  //.....@@...@@.....
    0x06, 0x30, 0x00,  //.....%@+.+@%.....
    0x03, 0xe0, 0x00,  //......%@@@%......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x03, 0xe0, 0x00,  //......%@@@%......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x03, 0xe0, 0x00,  //.....+@@@@@+.....
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x07, 0x70, 0x00,  //.....@@@.@@@.....
    0x0f, 0x78, 0x00,  //....%@@%.%@@%....
    0x0e, 0x38, 0x00,  //....@@@+.+@@@....
    0x0e, 0x38, 0x00,  //...+@@@...@@@+...
    0x1e, 0x3c, 0x00,  //...%@@%...%@@%...
    0x1c, 0x1c, 0x00,  //...@@@.....@@@...
    0x1f, 0xfc, 0x00,  //..+@@@@@@@@@@@+..
    0x3f, 0xfe, 0x00,  //..@@@@@@@@@@@@@..
    0x38, 0x0e, 0x00,  //..@@@.......@@@..
    0x78, 0x0f, 0x00,  //.%@@%.......%@@%.
    0x70, 0x07, 0x00,  //.@@@.........@@@.
    0x70, 0x07, 0x00,  //+@@@.........@@@+
    0xe0, 0x03, 0x80,  //@@@+.........+@@@
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c6 (Æ) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0xff, 0xfe,  //.......+@@@@@@@@@@@@@@@
    0x01, 0xff, 0xfe,  //.......@@@@@@@@@@@@@@@@
    0x01, 0xdc, 0x00,  //......+@@@.@@@.........
    0x03, 0xdc, 0x00,  //......%@@%.@@@.........
    0x03, 0x9c, 0x00,  //......@@@..@@@.........
    0x07, 0x9c, 0x00,  //.....%@@%..@@@.........
    0x07, 0x1c, 0x00,  //.....@@@+..@@@.........
    0x07, 0x1c, 0x00,  //....+@@@...@@@.........
    0x0e, 0x1f, 0xfc,  //....%@@+...@@@@@@@@@@@.
    0x0e, 0x1f, 0xfc,  //....@@@....@@@@@@@@@@@.
    0x1e, 0x1c, 0x00,  //...%@@%....@@@.........
    0x1c, 0x1c, 0x00,  //...@@@+....@@@.........
    0x1f, 0xfc, 0x00,  //..+@@@@@@@@@@@.........
    0x3f, 0xfc, 0x00,  //..@@@@@@@@@@@@.........
    0x38, 0x1c, 0x00,  //..@@@......@@@.........
    0x78, 0x1c, 0x00,  //.%@@%......@@@.........
    0x70, 0x1c, 0x00,  //.@@@.......@@@.........
    0x70, 0x1f, 0xfe,  //+@@@.......@@@@@@@@@@@@
    0xe0, 0x1f, 0xfe,  //@@@+.......@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c7 (Ç) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x03, 0xf0,  //.....+%@@@@%+..
    0x0f, 0xfc,  //...+@@@@@@@@@@+
    0x1e, 0x0e,  //..+@@@%....+@@@
    0x38, 0x06,  //.+@@@........%@
    0x70, 0x00,  //.@@@+.........+
    0x70, 0x00,  //+@@%...........
    0xe0, 0x00,  //%@@+...........
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //%@@+...........
    0x70, 0x00,  //+@@%...........
    0x70, 0x00,  //.@@@..........+
    0x38, 0x06,  //.+@@@........%@
    0x1e, 0x0e,  //..+@@@%....+@@@
    0x0f, 0xfc,  //...+@@@@@@@@@@+
    0x03, 0xf0,  //.....+%@@@@%+..
    0x00, 0x60,  //.........%@+...
    0x00, 0x30,  //..........@%...
    0x00, 0x30,  //..........@@...
    0x01, 0xf0,  //.......@@@@@...
    0x01, 0xe0,  //.......%@@@....
    0x00, 0x00,  //...............


    /*Unicode: U+00c8 (È) , Width: 12 */
    0x1c, 0x00,  //...%@@......
    0x0e, 0x00,  //....%@%.....
    0x06, 0x00,  //.....%@+....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xff, 0xe0,  //@@@@@@@@@@@.
    0xff, 0xe0,  //@@@@@@@@@@@.
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00c9 (É) , Width: 12 */
    0x01, 0x80,  //.......@@+..
    0x03, 0x00,  //......%@+...
    0x06, 0x00,  //.....%@+....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xff, 0xe0,  //@@@@@@@@@@@.
    0xff, 0xe0,  //@@@@@@@@@@@.
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00ca (Ê) , Width: 12 */
    0x07, 0x80,  //.....%@@%...
    0x0c, 0xc0,  //....%@++@%..
    0x18, 0x60,  //...%@+..+@%.
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xff, 0xe0,  //@@@@@@@@@@@.
    0xff, 0xe0,  //@@@@@@@@@@@.
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00cb (Ë) , Width: 12 */
    0x1c, 0xe0,  //...@@@..@@@.
    0x1c, 0xe0,  //...@@@..@@@.
    0x1c, 0xe0,  //...@@@..@@@.
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xff, 0xe0,  //@@@@@@@@@@@.
    0xff, 0xe0,  //@@@@@@@@@@@.
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00cc (Ì) , Width: 5 */
    0xe0,  //%@@..
    0x70,  //.%@%.
    0x30,  //..%@+
    0x00,  //.....
    0x00,  //.....
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00cd (Í) , Width: 5 */
    0x30,  //..@@+
    0x60,  //.%@+.
    0xc0,  //%@+..
    0x00,  //.....
    0x00,  //.....
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0xe0,  //@@@..
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00ce (Î) , Width: 8 */
    0x38,  //.+@@@+..
    0x6c,  //+@@.@@+.
    0xc6,  //@%...%@+
    0x00,  //........
    0x00,  //........
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00cf (Ï) , Width: 7 */
    0xee,  //@@@.@@@
    0xee,  //@@@.@@@
    0xee,  //@@@.@@@
    0x00,  //.......
    0x00,  //.......
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+00d0 (Ð) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x1f, 0xf8, 0x00,  //...@@@@@@@@@%+.....
    0x1f, 0xfe, 0x00,  //...@@@@@@@@@@@@+...
    0x1c, 0x0f, 0x80,  //...@@@.....+%@@@%..
    0x1c, 0x03, 0x80,  //...@@@........@@@+.
    0x1c, 0x01, 0xc0,  //...@@@.........@@@.
    0x1c, 0x01, 0xc0,  //...@@@.........%@@+
    0x1c, 0x00, 0xe0,  //...@@@.........+@@%
    0x1c, 0x00, 0xe0,  //...@@@..........@@@
    0xff, 0xc0, 0xe0,  //@@@@@@@@@@......@@@
    0xff, 0xc0, 0xe0,  //@@@@@@@@@@......@@@
    0x1c, 0x00, 0xe0,  //...@@@..........@@@
    0x1c, 0x00, 0xe0,  //...@@@..........@@@
    0x1c, 0x00, 0xe0,  //...@@@.........+@@%
    0x1c, 0x01, 0xc0,  //...@@@.........%@@+
    0x1c, 0x01, 0xc0,  //...@@@.........@@@.
    0x1c, 0x03, 0x80,  //...@@@........@@@+.
    0x1c, 0x0f, 0x80,  //...@@@.....+%@@@%..
    0x1f, 0xfe, 0x00,  //...@@@@@@@@@@@@+...
    0x1f, 0xf8, 0x00,  //...@@@@@@@@@%+.....
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00d1 (Ñ) , Width: 14 */
    0x0e, 0x60,  //....@@@+.@@...
    0x1f, 0xe0,  //...%@@@@@@%...
    0x19, 0xc0,  //...@@.+@@@....
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xf0, 0x1c,  //@@@@.......@@@
    0xf8, 0x1c,  //@@@@%......@@@
    0xf8, 0x1c,  //@@@@@......@@@
    0xfc, 0x1c,  //@@@@@%.....@@@
    0xfc, 0x1c,  //@@@@@@.....@@@
    0xfe, 0x1c,  //@@@%@@%....@@@
    0xee, 0x1c,  //@@@.@@@+...@@@
    0xef, 0x1c,  //@@@.%@@@...@@@
    0xe7, 0x1c,  //@@@..@@@+..@@@
    0xe7, 0x9c,  //@@@..%@@@..@@@
    0xe3, 0x9c,  //@@@...@@@+.@@@
    0xe3, 0xdc,  //@@@...%@@@.@@@
    0xe1, 0xdc,  //@@@....@@@+@@@
    0xe1, 0xfc,  //@@@....%@@@@@@
    0xe0, 0xfc,  //@@@.....@@@@@@
    0xe0, 0xfc,  //@@@.....%@@@@@
    0xe0, 0x7c,  //@@@......@@@@@
    0xe0, 0x7c,  //@@@......%@@@@
    0xe0, 0x3c,  //@@@.......@@@@
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+00d2 (Ò) , Width: 18 */
    0x03, 0x80, 0x00,  //......%@@.........
    0x01, 0xc0, 0x00,  //.......%@%........
    0x00, 0xc0, 0x00,  //........%@+.......
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x03, 0xf0, 0x00,  //.....+%@@@@%+.....
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@+...
    0x1e, 0x1e, 0x00,  //..+@@@%....%@@@+..
    0x38, 0x07, 0x00,  //.+@@@........@@@..
    0x70, 0x03, 0x80,  //.@@@+........+@@@.
    0x70, 0x03, 0x80,  //+@@@..........%@@+
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0x70, 0x03, 0x80,  //+@@@..........%@@+
    0x70, 0x03, 0x80,  //.@@@+........+@@@.
    0x38, 0x07, 0x00,  //.+@@@........@@@+.
    0x1e, 0x1e, 0x00,  //..+@@@%....%@@@+..
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@+...
    0x03, 0xf0, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d3 (Ó) , Width: 18 */
    0x00, 0x30, 0x00,  //..........@@+.....
    0x00, 0x60, 0x00,  //.........%@+......
    0x00, 0xc0, 0x00,  //........%@+.......
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x03, 0xf0, 0x00,  //.....+%@@@@%+.....
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@+...
    0x1e, 0x1e, 0x00,  //..+@@@%....%@@@+..
    0x38, 0x07, 0x00,  //.+@@@........@@@..
    0x70, 0x03, 0x80,  //.@@@+........+@@@.
    0x70, 0x03, 0x80,  //+@@@..........%@@+
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0x70, 0x03, 0x80,  //+@@@..........%@@+
    0x70, 0x03, 0x80,  //.@@@+........+@@@.
    0x38, 0x07, 0x00,  //.+@@@........@@@+.
    0x1e, 0x1e, 0x00,  //..+@@@%....%@@@+..
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@+...
    0x03, 0xf0, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d4 (Ô) , Width: 18 */
    0x01, 0xe0, 0x00,  //.......%@@%.......
    0x03, 0x30, 0x00,  //......%@++@%......
    0x06, 0x18, 0x00,  //.....%@+..+@%.....
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x03, 0xf0, 0x00,  //.....+%@@@@%+.....
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@+...
    0x1e, 0x1e, 0x00,  //..+@@@%....%@@@+..
    0x38, 0x07, 0x00,  //.+@@@........@@@..
    0x70, 0x03, 0x80,  //.@@@+........+@@@.
    0x70, 0x03, 0x80,  //+@@@..........%@@+
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0x70, 0x03, 0x80,  //+@@@..........%@@+
    0x70, 0x03, 0x80,  //.@@@+........+@@@.
    0x38, 0x07, 0x00,  //.+@@@........@@@+.
    0x1e, 0x1e, 0x00,  //..+@@@%....%@@@+..
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@+...
    0x03, 0xf0, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d5 (Õ) , Width: 18 */
    0x03, 0x98, 0x00,  //......@@@+.@@.....
    0x07, 0xf8, 0x00,  //.....%@@@@@@%.....
    0x06, 0x70, 0x00,  //.....@@.+@@@......
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x03, 0xf0, 0x00,  //.....+%@@@@%+.....
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@+...
    0x1e, 0x1e, 0x00,  //..+@@@%....%@@@+..
    0x38, 0x07, 0x00,  //.+@@@........@@@..
    0x70, 0x03, 0x80,  //.@@@+........+@@@.
    0x70, 0x03, 0x80,  //+@@@..........%@@+
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0x70, 0x03, 0x80,  //+@@@..........%@@+
    0x70, 0x03, 0x80,  //.@@@+........+@@@.
    0x38, 0x07, 0x00,  //.+@@@........@@@+.
    0x1e, 0x1e, 0x00,  //..+@@@%....%@@@+..
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@+...
    0x03, 0xf0, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d6 (Ö) , Width: 18 */
    0x07, 0x38, 0x00,  //.....@@@..@@@.....
    0x07, 0x38, 0x00,  //.....@@@..@@@.....
    0x07, 0x38, 0x00,  //.....@@@..@@@.....
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x03, 0xf0, 0x00,  //.....+%@@@@%+.....
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@+...
    0x1e, 0x1e, 0x00,  //..+@@@%....%@@@+..
    0x38, 0x07, 0x00,  //.+@@@........@@@..
    0x70, 0x03, 0x80,  //.@@@+........+@@@.
    0x70, 0x03, 0x80,  //+@@@..........%@@+
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0x70, 0x03, 0x80,  //+@@@..........%@@+
    0x70, 0x03, 0x80,  //.@@@+........+@@@.
    0x38, 0x07, 0x00,  //.+@@@........@@@+.
    0x1e, 0x1e, 0x00,  //..+@@@%....%@@@+..
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@+...
    0x03, 0xf0, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d7 (×) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x40, 0x04,  //.%...........%.
    0xe0, 0x0e,  //@@%.........%@@
    0x70, 0x1c,  //.@@%.......%@@.
    0x38, 0x38,  //..@@%.....%@@..
    0x1c, 0x70,  //...@@%...%@@...
    0x0e, 0xe0,  //....@@%.%@@....
    0x07, 0xc0,  //.....@@@@@.....
    0x03, 0x80,  //.....+@@@+.....
    0x07, 0xc0,  //.....@@@@@.....
    0x0e, 0xe0,  //....@@%.%@@....
    0x1c, 0x70,  //...@@%...%@@...
    0x38, 0x38,  //..@@%.....%@@..
    0x70, 0x1c,  //.@@%.......%@@.
    0xe0, 0x0e,  //@@%.........%@@
    0x40, 0x04,  //.%...........%.
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+00d8 (Ø) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x03, 0xf0, 0xc0,  //.....+%@@@@%+...@@.
    0x0f, 0xfd, 0x80,  //...+@@@@@@@@@@+@@+.
    0x1e, 0x1f, 0x00,  //..+@@@%....%@@@@+..
    0x38, 0x07, 0x00,  //.+@@@.......+@@@...
    0x70, 0x0f, 0x80,  //.@@@+.......%@@@@..
    0x70, 0x1f, 0x80,  //+@@@.......%@%%@@..
    0xe0, 0x39, 0xc0,  //%@@+......%@%.+@@%.
    0xe0, 0x31, 0xc0,  //@@@......+@@...@@@.
    0xe0, 0x61, 0xc0,  //@@@......@@....@@@.
    0xe0, 0xc1, 0xc0,  //@@@.....@@.....@@@.
    0xe1, 0x81, 0xc0,  //@@@....@@+.....@@@.
    0xe3, 0x01, 0xc0,  //@@@...@@+......@@@.
    0xe7, 0x01, 0xc0,  //%@@+.%@%......+@@%.
    0x7e, 0x03, 0x80,  //+@@%%@%.......@@@+.
    0x7c, 0x03, 0x80,  //.@@@@%.......+@@@..
    0x38, 0x07, 0x00,  //..@@@+.......@@@+..
    0x3e, 0x1e, 0x00,  //..@@@@%....%@@@+...
    0x6f, 0xfc, 0x00,  //.@@+@@@@@@@@@@+....
    0xc3, 0xf0, 0x00,  //@@...+%@@@@%+......
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00d9 (Ù) , Width: 14 */
    0x1c, 0x00,  //...%@@........
    0x0e, 0x00,  //....%@%.......
    0x06, 0x00,  //.....%@+......
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //%@@+......+@@%
    0x70, 0x38,  //+@@@......@@@+
    0x78, 0x78,  //.%@@%....%@@%.
    0x3f, 0xf0,  //..%@@@@@@@@%..
    0x0f, 0xc0,  //...+%@@@@%+...
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+00da (Ú) , Width: 14 */
    0x01, 0x80,  //.......@@+....
    0x03, 0x00,  //......%@+.....
    0x06, 0x00,  //.....%@+......
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //%@@+......+@@%
    0x70, 0x38,  //+@@@......@@@+
    0x78, 0x78,  //.%@@%....%@@%.
    0x3f, 0xf0,  //..%@@@@@@@@%..
    0x0f, 0xc0,  //...+%@@@@%+...
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+00db (Û) , Width: 14 */
    0x07, 0x80,  //.....%@@%.....
    0x0c, 0xc0,  //....%@++@%....
    0x18, 0x60,  //...%@+..+@%...
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //%@@+......+@@%
    0x70, 0x38,  //+@@@......@@@+
    0x78, 0x78,  //.%@@%....%@@%.
    0x3f, 0xf0,  //..%@@@@@@@@%..
    0x0f, 0xc0,  //...+%@@@@%+...
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+00dc (Ü) , Width: 14 */
    0x1c, 0xe0,  //...@@@..@@@...
    0x1c, 0xe0,  //...@@@..@@@...
    0x1c, 0xe0,  //...@@@..@@@...
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //%@@+......+@@%
    0x70, 0x38,  //+@@@......@@@+
    0x78, 0x78,  //.%@@%....%@@%.
    0x3f, 0xf0,  //..%@@@@@@@@%..
    0x0f, 0xc0,  //...+%@@@@%+...
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+00dd (Ý) , Width: 17 */
    0x00, 0xc0, 0x00,  //........@@+......
    0x01, 0x80, 0x00,  //.......%@+.......
    0x03, 0x00, 0x00,  //......%@+........
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xf0, 0x07, 0x80,  //%@@@.........@@@%
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x38, 0x0e, 0x00,  //..@@@+.....+@@@..
    0x3c, 0x1e, 0x00,  //..%@@@.....@@@%..
    0x1e, 0x3c, 0x00,  //...@@@@...@@@@...
    0x0f, 0x78, 0x00,  //....@@@%.%@@@....
    0x07, 0x70, 0x00,  //....+@@@+@@@+....
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x01, 0xc0, 0x00,  //......+@@@+......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00de (Þ) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xff, 0x80,  //@@@@@@@@%...
    0xff, 0xc0,  //@@@@@@@@@@+.
    0xe0, 0xe0,  //@@@....+@@@+
    0xe0, 0xf0,  //@@@.....+@@%
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0xf0,  //@@@.....+@@%
    0xe0, 0xe0,  //@@@....+@@@+
    0xff, 0xc0,  //@@@@@@@@@@+.
    0xff, 0x80,  //@@@@@@@@%...
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00df (ß) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x1f, 0x00,  //..+%@@@%+....
    0x7f, 0xc0,  //.%@@@@@@@%...
    0x71, 0xc0,  //+@@@+..@@@+..
    0xe0, 0xe0,  //%@@+...+@@%..
    0xe0, 0xe0,  //@@@.....@@@..
    0xe3, 0xe0,  //@@@...%@@@@..
    0xe3, 0x80,  //@@@..+@@@....
    0xe7, 0x00,  //@@@..@@@.....
    0xe7, 0x00,  //@@@..@@@.....
    0xe7, 0x00,  //@@@..@@@.....
    0xe3, 0x00,  //@@@..+@@.....
    0xe1, 0xc0,  //@@@...+@@%...
    0xe0, 0xe0,  //@@@.....@@@+.
    0xe0, 0x70,  //@@@......@@@+
    0xe0, 0x38,  //@@@......+@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe8, 0x78,  //@@@.%+...@@@%
    0xef, 0xf0,  //@@@.@@@@@@@@.
    0xe7, 0xc0,  //@@@..%@@@@+..
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00e0 (à) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x38, 0x00,  //..%@@.......
    0x1c, 0x00,  //...%@%......
    0x0c, 0x00,  //....@@......
    0x06, 0x00,  //.....@@.....
    0x03, 0x00,  //.....+@%....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x1f, 0x80,  //..+%@@@@%...
    0x7f, 0xc0,  //.@@@@@@@@@+.
    0x40, 0xe0,  //.@+....+@@@.
    0x00, 0x70,  //........+@@%
    0x00, 0x70,  //.........@@@
    0x1f, 0xf0,  //..+%@@@@@@@@
    0x7f, 0xf0,  //.%@@@@@@@@@@
    0xf0, 0x70,  //+@@@+....@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@.....+@@@
    0xe0, 0xf0,  //@@@.....@@@@
    0xf1, 0xf0,  //%@@@...%%@@@
    0x7f, 0x70,  //.@@@@@@@.@@@
    0x3e, 0x70,  //..%@@@%..@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00e1 (á) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0xe0,  //........@@%.
    0x01, 0xc0,  //.......%@%..
    0x01, 0x80,  //.......@@...
    0x03, 0x00,  //......@@....
    0x06, 0x00,  //.....%@+....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x1f, 0x80,  //..+%@@@@%...
    0x7f, 0xc0,  //.@@@@@@@@@+.
    0x40, 0xe0,  //.@+....+@@@.
    0x00, 0x70,  //........+@@%
    0x00, 0x70,  //.........@@@
    0x1f, 0xf0,  //..+%@@@@@@@@
    0x7f, 0xf0,  //.%@@@@@@@@@@
    0xf0, 0x70,  //+@@@+....@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@.....+@@@
    0xe0, 0xf0,  //@@@.....@@@@
    0xf1, 0xf0,  //%@@@...%%@@@
    0x7f, 0x70,  //.@@@@@@@.@@@
    0x3e, 0x70,  //..%@@@%..@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00e2 (â) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x06, 0x00,  //.....@@.....
    0x0f, 0x00,  //....@@@@....
    0x09, 0x00,  //...+@++@+...
    0x19, 0x80,  //...@@..@@...
    0x30, 0xc0,  //..%@....@%..
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x1f, 0x80,  //..+%@@@@%...
    0x7f, 0xc0,  //.@@@@@@@@@+.
    0x40, 0xe0,  //.@+....+@@@.
    0x00, 0x70,  //........+@@%
    0x00, 0x70,  //.........@@@
    0x1f, 0xf0,  //..+%@@@@@@@@
    0x7f, 0xf0,  //.%@@@@@@@@@@
    0xf0, 0x70,  //+@@@+....@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@.....+@@@
    0xe0, 0xf0,  //@@@.....@@@@
    0xf1, 0xf0,  //%@@@...%%@@@
    0x7f, 0x70,  //.@@@@@@@.@@@
    0x3e, 0x70,  //..%@@@%..@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00e3 (ã) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x1c, 0xc0,  //...%@%..@@..
    0x3c, 0xc0,  //..%@@@+.@@..
    0x33, 0xc0,  //..@@.+@@@%..
    0x33, 0x80,  //..@@..%@@...
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x1f, 0x80,  //..+%@@@@%...
    0x7f, 0xc0,  //.@@@@@@@@@+.
    0x40, 0xe0,  //.@+....+@@@.
    0x00, 0x70,  //........+@@%
    0x00, 0x70,  //.........@@@
    0x1f, 0xf0,  //..+%@@@@@@@@
    0x7f, 0xf0,  //.%@@@@@@@@@@
    0xf0, 0x70,  //+@@@+....@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@.....+@@@
    0xe0, 0xf0,  //@@@.....@@@@
    0xf1, 0xf0,  //%@@@...%%@@@
    0x7f, 0x70,  //.@@@@@@@.@@@
    0x3e, 0x70,  //..%@@@%..@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00e4 (ä) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x39, 0xc0,  //..@@@..@@@..
    0x39, 0xc0,  //..@@@..@@@..
    0x39, 0xc0,  //..@@@..@@@..
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x1f, 0x80,  //..+%@@@@%...
    0x7f, 0xc0,  //.@@@@@@@@@+.
    0x40, 0xe0,  //.@+....+@@@.
    0x00, 0x70,  //........+@@%
    0x00, 0x70,  //.........@@@
    0x1f, 0xf0,  //..+%@@@@@@@@
    0x7f, 0xf0,  //.%@@@@@@@@@@
    0xf0, 0x70,  //+@@@+....@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@.....+@@@
    0xe0, 0xf0,  //@@@.....@@@@
    0xf1, 0xf0,  //%@@@...%%@@@
    0x7f, 0x70,  //.@@@@@@@.@@@
    0x3e, 0x70,  //..%@@@%..@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00e5 (å) , Width: 12 */
    0x00, 0x00,  //............
    0x07, 0x00,  //....+@@@+...
    0x0f, 0x80,  //...+@@@@@+..
    0x18, 0xc0,  //...@@+.+@@..
    0x18, 0xc0,  //...@@...@@..
    0x18, 0xc0,  //...@@+.+@@..
    0x0f, 0x80,  //...+@@@@@+..
    0x07, 0x00,  //....+@@@+...
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x1f, 0x80,  //..+%@@@@%...
    0x7f, 0xc0,  //.@@@@@@@@@+.
    0x40, 0xe0,  //.@+....+@@@.
    0x00, 0x70,  //........+@@%
    0x00, 0x70,  //.........@@@
    0x1f, 0xf0,  //..+%@@@@@@@@
    0x7f, 0xf0,  //.%@@@@@@@@@@
    0xf0, 0x70,  //+@@@+....@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@.....+@@@
    0xe0, 0xf0,  //@@@.....@@@@
    0xf1, 0xf0,  //%@@@...%%@@@
    0x7f, 0x70,  //.@@@@@@@.@@@
    0x3e, 0x70,  //..%@@@%..@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00e6 (æ) , Width: 22 */
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x1f, 0x87, 0xe0,  //..+%@@@@%....%@@@@%...
    0x7f, 0xcf, 0xf0,  //.@@@@@@@@@++@@@@@@@@..
    0x40, 0xfc, 0x78,  //.@+....+@@@@@@...%@@@.
    0x00, 0x78, 0x38,  //........+@@@@.....%@@+
    0x00, 0x70, 0x1c,  //.........@@@+......@@%
    0x1f, 0xf0, 0x1c,  //..+%@@@@@@@@.......@@@
    0x7f, 0xff, 0xfc,  //.%@@@@@@@@@@@@@@@@@@@@
    0xf0, 0x7f, 0xfc,  //+@@@+....@@@@@@@@@@@@@
    0xe0, 0x70, 0x00,  //@@@......@@@..........
    0xe0, 0x70, 0x00,  //@@@.....+@@@+.........
    0xe0, 0xf8, 0x00,  //@@@.....%@@@@.........
    0xf1, 0xdc, 0x08,  //%@@@...%@@+@@@+....+@.
    0x7f, 0x8f, 0xf8,  //.@@@@@@@@..+@@@@@@@@@.
    0x3e, 0x07, 0xe0,  //..%@@@@+.....%@@@@%+..
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................


    /*Unicode: U+00e7 (ç) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x0f, 0xc0,  //....%@@@@%.
    0x3f, 0xe0,  //..%@@@@@@@@
    0x78, 0x20,  //.%@@@+...+%
    0x70, 0x00,  //.@@@.......
    0xe0, 0x00,  //%@@+.......
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //%@@+.......
    0x70, 0x00,  //.@@@.......
    0x78, 0x20,  //.%@@@+...+%
    0x3f, 0xe0,  //..%@@@@@@@@
    0x0f, 0xc0,  //...+%@@@@%.
    0x01, 0x80,  //.......%@+.
    0x00, 0xc0,  //........@%.
    0x00, 0xc0,  //........@@.
    0x07, 0xc0,  //.....@@@@@.
    0x07, 0x80,  //.....%@@@..
    0x00, 0x00,  //...........


    /*Unicode: U+00e8 (è) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x1c, 0x00,  //...%@@.......
    0x0e, 0x00,  //....%@%......
    0x06, 0x00,  //.....@@......
    0x03, 0x00,  //......@@.....
    0x01, 0x80,  //......+@%....
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //....%@@@@+...
    0x3f, 0xe0,  //..%@@@@@@@@..
    0x78, 0xf0,  //.%@@@...%@@@.
    0x70, 0x70,  //.@@@.....%@@+
    0xe0, 0x38,  //%@@+......@@%
    0xe0, 0x38,  //@@@.......@@@
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //%@@+.........
    0x70, 0x00,  //.@@@.........
    0x78, 0x10,  //.%@@@+....+@.
    0x3f, 0xf0,  //..%@@@@@@@@@.
    0x0f, 0xc0,  //....%@@@@%+..
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00e9 (é) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x70,  //.........@@%.
    0x00, 0xe0,  //........%@%..
    0x00, 0xc0,  //........@@...
    0x01, 0x80,  //.......@@....
    0x03, 0x00,  //......%@+....
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //....%@@@@+...
    0x3f, 0xe0,  //..%@@@@@@@@..
    0x78, 0xf0,  //.%@@@...%@@@.
    0x70, 0x70,  //.@@@.....%@@+
    0xe0, 0x38,  //%@@+......@@%
    0xe0, 0x38,  //@@@.......@@@
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //%@@+.........
    0x70, 0x00,  //.@@@.........
    0x78, 0x10,  //.%@@@+....+@.
    0x3f, 0xf0,  //..%@@@@@@@@@.
    0x0f, 0xc0,  //....%@@@@%+..
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00ea (ê) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x07, 0x00,  //.....@@@.....
    0x0f, 0x80,  //....%@@@%....
    0x0d, 0x80,  //....@@.@@+...
    0x18, 0xc0,  //...@@...@@...
    0x30, 0x60,  //..%@+...+@%..
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //....%@@@@+...
    0x3f, 0xe0,  //..%@@@@@@@@..
    0x78, 0xf0,  //.%@@@...%@@@.
    0x70, 0x70,  //.@@@.....%@@+
    0xe0, 0x38,  //%@@+......@@%
    0xe0, 0x38,  //@@@.......@@@
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //%@@+.........
    0x70, 0x00,  //.@@@.........
    0x78, 0x10,  //.%@@@+....+@.
    0x3f, 0xf0,  //..%@@@@@@@@@.
    0x0f, 0xc0,  //....%@@@@%+..
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00eb (ë) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0e, 0x70,  //....@@@..@@@.
    0x0e, 0x70,  //....@@@..@@@.
    0x0e, 0x70,  //....@@@..@@@.
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //....%@@@@+...
    0x3f, 0xe0,  //..%@@@@@@@@..
    0x78, 0xf0,  //.%@@@...%@@@.
    0x70, 0x70,  //.@@@.....%@@+
    0xe0, 0x38,  //%@@+......@@%
    0xe0, 0x38,  //@@@.......@@@
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //%@@+.........
    0x70, 0x00,  //.@@@.........
    0x78, 0x10,  //.%@@@+....+@.
    0x3f, 0xf0,  //..%@@@@@@@@@.
    0x0f, 0xc0,  //....%@@@@%+..
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00ec (ì) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0xc0,  //@@...
    0xe0,  //%@%..
    0x60,  //.@@..
    0x30,  //..@@.
    0x18,  //..+@%
    0x00,  //.....
    0x00,  //.....
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00ed (í) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x1c,  //...@@%
    0x38,  //..%@%.
    0x30,  //..@@..
    0x60,  //.@@...
    0xc0,  //%@+...
    0x00,  //......
    0x00,  //......
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+00ee (î) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x38,  //..@@@...
    0x7c,  //.%@@@%..
    0x6c,  //+@@.@@+.
    0xc6,  //@@...@@.
    0x83,  //@+...+@%
    0x00,  //........
    0x00,  //........
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x38,  //..@@@...
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00ef (ï) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0xee,  //@@@.@@@
    0xee,  //@@@.@@@
    0xee,  //@@@.@@@
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+00f0 (ð) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x1c, 0x00,  //...%@@....+..
    0x0e, 0xe0,  //....@@%+%@@..
    0x07, 0x80,  //....+@@@%+...
    0x1f, 0x00,  //..+@@@@@.....
    0x33, 0x80,  //..@%..%@@....
    0x01, 0xc0,  //.......@@%...
    0x0f, 0xc0,  //...+@@@@@@+..
    0x3f, 0xe0,  //..%@@@@@@@@..
    0x78, 0x70,  //.%@@@...+@@@.
    0x70, 0x70,  //+@@@.....%@@+
    0xe0, 0x38,  //%@@+.....+@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //%@@+.....+@@%
    0x70, 0x70,  //.@@@.....@@@.
    0x78, 0xf0,  //.%@@%...%@@%.
    0x3f, 0xe0,  //..%@@@@@@@%..
    0x0f, 0x80,  //...+%@@@%+...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00f1 (ñ) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x1c, 0xc0,  //...%@%..@@..
    0x3c, 0xc0,  //..%@@@+.@@..
    0x33, 0xc0,  //..@@.+@@@%..
    0x33, 0x80,  //..@@..%@@...
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe7, 0x80,  //@@@..%@@@+..
    0xef, 0xe0,  //@@@.@@@@@@%.
    0xf8, 0xe0,  //@@@%%..+@@@+
    0xf0, 0x70,  //@@@@....+@@%
    0xe0, 0x70,  //@@@+.....@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00f2 (ò) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x38, 0x00,  //..%@@........
    0x1c, 0x00,  //...%@%.......
    0x0c, 0x00,  //....@@.......
    0x06, 0x00,  //.....@@......
    0x03, 0x00,  //.....+@%.....
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //...+%@@@%+...
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x78, 0xf0,  //.%@@%...%@@%.
    0x70, 0x70,  //+@@@.....@@@+
    0xe0, 0x38,  //%@@+.....+@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //%@@+.....+@@%
    0x70, 0x70,  //+@@@.....@@@+
    0x78, 0xf0,  //.%@@%...%@@%.
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x0f, 0x80,  //...+%@@@%+...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00f3 (ó) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0xe0,  //........@@%..
    0x01, 0xc0,  //.......%@%...
    0x01, 0x80,  //.......@@....
    0x03, 0x00,  //......@@.....
    0x06, 0x00,  //.....%@+.....
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //...+%@@@%+...
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x78, 0xf0,  //.%@@%...%@@%.
    0x70, 0x70,  //+@@@.....@@@+
    0xe0, 0x38,  //%@@+.....+@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //%@@+.....+@@%
    0x70, 0x70,  //+@@@.....@@@+
    0x78, 0xf0,  //.%@@%...%@@%.
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x0f, 0x80,  //...+%@@@%+...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00f4 (ô) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x07, 0x00,  //.....%@%.....
    0x07, 0x00,  //.....@@@.....
    0x0d, 0x80,  //....%@.@%....
    0x08, 0x80,  //....@+.+@....
    0x18, 0xc0,  //...%@...@%...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //...+%@@@%+...
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x78, 0xf0,  //.%@@%...%@@%.
    0x70, 0x70,  //+@@@.....@@@+
    0xe0, 0x38,  //%@@+.....+@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //%@@+.....+@@%
    0x70, 0x70,  //+@@@.....@@@+
    0x78, 0xf0,  //.%@@%...%@@%.
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x0f, 0x80,  //...+%@@@%+...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00f5 (õ) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0c, 0xc0,  //....@@..@@...
    0x1e, 0xc0,  //...%@@@.@@...
    0x1b, 0xc0,  //...@@.@@@%...
    0x19, 0x80,  //...@@..@@....
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //...+%@@@%+...
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x78, 0xf0,  //.%@@%...%@@%.
    0x70, 0x70,  //+@@@.....@@@+
    0xe0, 0x38,  //%@@+.....+@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //%@@+.....+@@%
    0x70, 0x70,  //+@@@.....@@@+
    0x78, 0xf0,  //.%@@%...%@@%.
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x0f, 0x80,  //...+%@@@%+...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00f6 (ö) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x38, 0xe0,  //..@@@...@@@..
    0x38, 0xe0,  //..@@@...@@@..
    0x38, 0xe0,  //..@@@...@@@..
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //...+%@@@%+...
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x78, 0xf0,  //.%@@%...%@@%.
    0x70, 0x70,  //+@@@.....@@@+
    0xe0, 0x38,  //%@@+.....+@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //%@@+.....+@@%
    0x70, 0x70,  //+@@@.....@@@+
    0x78, 0xf0,  //.%@@%...%@@%.
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x0f, 0x80,  //...+%@@@%+...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00f7 (÷) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f8 (ø) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x04,  //.............%.
    0x07, 0xcc,  //....+@@@@%..@@.
    0x1f, 0xf8,  //...@@@@@@@@@@+.
    0x3c, 0x78,  //..@@@%...@@@%..
    0x38, 0x78,  //.+@@@....%@@@..
    0x70, 0x7c,  //.%@@+...+@%@@%.
    0x70, 0xdc,  //.@@@....@%.@@@.
    0x71, 0x9c,  //.@@@...@%..@@@.
    0x73, 0x1c,  //.@@@..@@...@@@.
    0x76, 0x1c,  //.@@@.%@....@@@.
    0x7c, 0x1c,  //.%@@%@+...+@@%.
    0x3c, 0x38,  //..@@@%....@@@+.
    0x3c, 0x78,  //..%@@%...%@@@..
    0x3f, 0xf0,  //..@@@@@@@@@@...
    0x67, 0xc0,  //.@@..%@@@@+....
    0x40, 0x00,  //.%.............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+00f9 (ù) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x38, 0x00,  //..%@@.......
    0x1c, 0x00,  //...%@%......
    0x0c, 0x00,  //....@@......
    0x06, 0x00,  //.....@@.....
    0x03, 0x00,  //.....+@%....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@.....+@@@
    0xe0, 0xf0,  //%@@+....@@@@
    0x71, 0xf0,  //+@@@+..%%@@@
    0x7f, 0x70,  //.%@@@@@@.@@@
    0x1e, 0x70,  //..+@@@%..@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00fa (ú) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0xe0,  //........@@%.
    0x01, 0xc0,  //.......%@%..
    0x01, 0x80,  //.......@@...
    0x03, 0x00,  //......@@....
    0x06, 0x00,  //.....%@+....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@.....+@@@
    0xe0, 0xf0,  //%@@+....@@@@
    0x71, 0xf0,  //+@@@+..%%@@@
    0x7f, 0x70,  //.%@@@@@@.@@@
    0x1e, 0x70,  //..+@@@%..@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00fb (û) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x06, 0x00,  //.....@@.....
    0x0f, 0x00,  //....@@@@....
    0x09, 0x00,  //...+@++@+...
    0x19, 0x80,  //...@@..@@...
    0x30, 0xc0,  //..%@....@%..
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@.....+@@@
    0xe0, 0xf0,  //%@@+....@@@@
    0x71, 0xf0,  //+@@@+..%%@@@
    0x7f, 0x70,  //.%@@@@@@.@@@
    0x1e, 0x70,  //..+@@@%..@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00fc (ü) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x39, 0xc0,  //..@@@..@@@..
    0x39, 0xc0,  //..@@@..@@@..
    0x39, 0xc0,  //..@@@..@@@..
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@.....+@@@
    0xe0, 0xf0,  //%@@+....@@@@
    0x71, 0xf0,  //+@@@+..%%@@@
    0x7f, 0x70,  //.%@@@@@@.@@@
    0x1e, 0x70,  //..+@@@%..@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00fd (ý) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0xe0,  //........@@%...
    0x01, 0xc0,  //.......%@%....
    0x01, 0x80,  //.......@@.....
    0x03, 0x00,  //......@@......
    0x06, 0x00,  //.....%@+......
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xe0, 0x1c,  //@@@+......+@@@
    0x70, 0x38,  //+@@@......@@@+
    0x70, 0x38,  //.@@@+....+@@@.
    0x78, 0x70,  //.%@@%....@@@+.
    0x38, 0x70,  //..@@@....@@@..
    0x38, 0xf0,  //..%@@+..%@@%..
    0x1c, 0xe0,  //..+@@@..@@@...
    0x1d, 0xe0,  //...@@@++@@%...
    0x1f, 0xc0,  //...+@@%@@@+...
    0x0f, 0xc0,  //....@@@@@@....
    0x0f, 0x80,  //....%@@@@+....
    0x07, 0x80,  //....+@@@@.....
    0x07, 0x80,  //.....@@@%.....
    0x07, 0x00,  //.....@@@......
    0x0f, 0x00,  //....%@@%......
    0x0e, 0x00,  //....@@@+......
    0x1e, 0x00,  //...%@@@.......
    0x7c, 0x00,  //.@@@@@........
    0x78, 0x00,  //.@@@%.........
    0x00, 0x00,  //..............


    /*Unicode: U+00fe (þ) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe7, 0xc0,  //@@@..%@@@%...
    0xef, 0xe0,  //@@@.@@@@@@@..
    0xf8, 0xf0,  //@@@%%...%@@@.
    0xf0, 0x70,  //@@@@.....@@@+
    0xe0, 0x38,  //@@@+.....+@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@+.....+@@%
    0xf0, 0x70,  //@@@@.....@@@+
    0xf8, 0xf0,  //@@@%%...%@@@.
    0xef, 0xe0,  //@@@.@@@@@@@..
    0xe7, 0xc0,  //@@@..%@@@%...
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0x00, 0x00,  //.............


    /*Unicode: U+00ff (ÿ) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x1d, 0xc0,  //...@@@.@@@....
    0x1d, 0xc0,  //...@@@.@@@....
    0x1d, 0xc0,  //...@@@.@@@....
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xe0, 0x1c,  //@@@+......+@@@
    0x70, 0x38,  //+@@@......@@@+
    0x70, 0x38,  //.@@@+....+@@@.
    0x78, 0x70,  //.%@@%....@@@+.
    0x38, 0x70,  //..@@@....@@@..
    0x38, 0xf0,  //..%@@+..%@@%..
    0x1c, 0xe0,  //..+@@@..@@@...
    0x1d, 0xe0,  //...@@@++@@%...
    0x1f, 0xc0,  //...+@@%@@@+...
    0x0f, 0xc0,  //....@@@@@@....
    0x0f, 0x80,  //....%@@@@+....
    0x07, 0x80,  //....+@@@@.....
    0x07, 0x80,  //.....@@@%.....
    0x07, 0x00,  //.....@@@......
    0x0f, 0x00,  //....%@@%......
    0x0e, 0x00,  //....@@@+......
    0x1e, 0x00,  //...%@@@.......
    0x7c, 0x00,  //.@@@@@........
    0x78, 0x00,  //.@@@%.........
    0x00, 0x00,  //..............



#elif USE_LV_FONT_DEJAVU_30_LATIN_SUP == 2
    /*Unicode: U+00a0 ( ) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00a1 (¡) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xb8,  //%@%
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...


    /*Unicode: U+00a2 (¢) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x0c, 0x00,  //......@....
    0x00, 0x0c, 0x00,  //......@....
    0x00, 0x0c, 0x00,  //......@....
    0x00, 0x0c, 0x00,  //......@....
    0x01, 0xbf, 0xe0,  //...+%@@@@%.
    0x0b, 0xff, 0xfc,  //..%@@@@@@@@
    0x2f, 0x8c, 0x1c,  //.%@@%.@..+@
    0x7f, 0x0c, 0x00,  //+@@@..@....
    0xbd, 0x0c, 0x00,  //%@@+..@....
    0xfc, 0x0c, 0x00,  //@@@...@....
    0xfc, 0x0c, 0x00,  //@@@...@....
    0xfc, 0x0c, 0x00,  //@@@...@....
    0xfc, 0x0c, 0x00,  //@@@...@....
    0xbd, 0x0c, 0x00,  //%@@+..@....
    0x7f, 0x0c, 0x00,  //+@@@..@....
    0x2f, 0x8c, 0x1c,  //.%@@%.@..+@
    0x0f, 0xff, 0xfc,  //..%@@@@@@@@
    0x01, 0xbf, 0xe0,  //...+%@@@@%.
    0x00, 0x0c, 0x00,  //......@....
    0x00, 0x0c, 0x00,  //......@....
    0x00, 0x0c, 0x00,  //......@....
    0x00, 0x0c, 0x00,  //......@....
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00a3 (£) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x0b, 0xfe, 0x00,  //......%@@@@%.
    0x00, 0x7f, 0xff, 0xc0,  //....+@@@@@@@@
    0x00, 0xfd, 0x01, 0xc0,  //....@@@+...+@
    0x02, 0xf4, 0x00, 0x00,  //...%@@+......
    0x03, 0xf0, 0x00, 0x00,  //...@@@.......
    0x03, 0xf0, 0x00, 0x00,  //...@@@.......
    0x03, 0xf0, 0x00, 0x00,  //...@@@.......
    0x03, 0xf0, 0x00, 0x00,  //...@@@.......
    0x03, 0xf0, 0x00, 0x00,  //...@@@.......
    0xff, 0xff, 0xfc, 0x00,  //@@@@@@@@@@@..
    0xff, 0xff, 0xfc, 0x00,  //@@@@@@@@@@@..
    0x03, 0xf0, 0x00, 0x00,  //...@@@.......
    0x03, 0xf0, 0x00, 0x00,  //...@@@.......
    0x03, 0xf0, 0x00, 0x00,  //...@@@.......
    0x03, 0xf0, 0x00, 0x00,  //...@@@.......
    0x03, 0xf0, 0x00, 0x00,  //...@@@.......
    0x03, 0xf0, 0x00, 0x00,  //...@@@.......
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00a4 (¤) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x20, 0x00, 0x00, 0x20,  //.%...........%.
    0xbc, 0x00, 0x00, 0xf8,  //%@@.........@@%
    0x3f, 0x2f, 0xe3, 0xf0,  //.@@@.%@@@%.@@@.
    0x0f, 0xff, 0xff, 0xc0,  //..@@@@@@@@@@@..
    0x03, 0xe0, 0x2f, 0x00,  //...@@%...%@@...
    0x0b, 0x80, 0x0b, 0x80,  //..%@%.....%@%..
    0x0f, 0x00, 0x03, 0xc0,  //..@@.......@@..
    0x0f, 0x00, 0x03, 0xc0,  //..@@.......@@..
    0x0f, 0x00, 0x03, 0xc0,  //..@@.......@@..
    0x0b, 0x80, 0x0b, 0x80,  //..%@%.....%@%..
    0x03, 0xe0, 0x2f, 0x00,  //...@@%...%@@...
    0x0f, 0xff, 0xff, 0xc0,  //..@@@@@@@@@@@..
    0x3f, 0x2f, 0xe3, 0xf0,  //.@@@.%@@@%.@@@.
    0xbc, 0x00, 0x00, 0xf8,  //%@@.........@@%
    0x20, 0x00, 0x00, 0x20,  //.%...........%.
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00a5 (¥) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xbe, 0x00, 0x02, 0xf8,  //%@@%.......%@@%
    0x3f, 0x00, 0x03, 0xf0,  //.@@@.......@@@.
    0x2f, 0x80, 0x0b, 0xd0,  //.%@@%.....%@@+.
    0x0f, 0xd0, 0x1f, 0xc0,  //..@@@+...+@@@..
    0x07, 0xf0, 0x3f, 0x40,  //..+@@@...@@@+..
    0x02, 0xf4, 0x7e, 0x00,  //...%@@+.+@@%...
    0x00, 0xfc, 0xfc, 0x00,  //....@@@.@@@....
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@%@@@@@@.
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@.
    0x00, 0x3f, 0xf0, 0x00,  //.....@@@@@.....
    0x00, 0x1f, 0xd0, 0x00,  //.....+@@@+.....
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@.
    0x3f, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@@@@.
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00a6 (¦) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00a7 (§) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x02, 0xff, 0x80,  //...%@@@@%..
    0x0f, 0xff, 0xf0,  //..@@@@@@@@.
    0x3e, 0x00, 0x70,  //.@@%....+@.
    0x3c, 0x00, 0x00,  //.@@........
    0x3d, 0x00, 0x00,  //.@@+.......
    0x2f, 0x80, 0x00,  //.+@@%......
    0x0f, 0xf8, 0x00,  //..@@@@%....
    0x3d, 0xbf, 0x40,  //.@@+%@@@+..
    0xb4, 0x0b, 0xe0,  //%@+...%@@%.
    0xf0, 0x01, 0xf8,  //@@.....+@@%
    0xf4, 0x00, 0x7c,  //@@+.....+@@
    0x7e, 0x00, 0x3c,  //+@@%.....@@
    0x1f, 0xd0, 0x78,  //.+@@@+..+@%
    0x02, 0xfe, 0xf0,  //...%@@@%@@.
    0x00, 0x7f, 0xc0,  //....+@@@@..
    0x00, 0x07, 0xe0,  //......+@@%.
    0x00, 0x00, 0xf0,  //........@@.
    0x00, 0x00, 0xf0,  //........@@.
    0x34, 0x03, 0xe0,  //.@+....%@%.
    0x3f, 0xff, 0xc0,  //.@@@@@@@@..
    0x0b, 0xfe, 0x00,  //..%@@@@%...
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00a8 (¨) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xfc, 0x3f,  //@@@..@@@
    0xfc, 0x3f,  //@@@..@@@
    0xfc, 0x3f,  //@@@..@@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00a9 (©) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x07, 0xff, 0x40, 0x00,  //......+@@@@@+......
    0x00, 0xb9, 0x00, 0xb8, 0x00,  //....%@%.....%@%....
    0x03, 0x80, 0x00, 0x0b, 0x00,  //...@%.........%@...
    0x0e, 0x01, 0xff, 0x82, 0xc0,  //..@%...+@@@@%..%@..
    0x28, 0x0f, 0x40, 0x70, 0xa0,  //.%%...@@+...+%..%%.
    0x30, 0x3c, 0x00, 0x00, 0x30,  //.@...@@..........@.
    0x60, 0x78, 0x00, 0x00, 0x24,  //+%..+@%..........%+
    0xd0, 0xf0, 0x00, 0x00, 0x1c,  //@+..%@............@
    0xc0, 0xf0, 0x00, 0x00, 0x0c,  //@...@@............@
    0xc0, 0xf0, 0x00, 0x00, 0x0c,  //@...@@............@
    0xc0, 0xf0, 0x00, 0x00, 0x0c,  //@...@@............@
    0xd0, 0xb0, 0x00, 0x00, 0x1c,  //@+..%@............@
    0xa0, 0x78, 0x00, 0x00, 0x24,  //+%..+@%..........%+
    0x30, 0x3c, 0x00, 0x00, 0x30,  //.@...@@..........@.
    0x28, 0x0f, 0x40, 0x60, 0xa0,  //.%%...@@+...+%..%%.
    0x0e, 0x01, 0xff, 0x82, 0xc0,  //..@%...+@@@@%..%@..
    0x03, 0x80, 0x00, 0x0b, 0x00,  //...@%.........%@...
    0x00, 0xb9, 0x00, 0xb8, 0x00,  //....%@%.....%@%....
    0x00, 0x07, 0xff, 0x40, 0x00,  //......+@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00aa (ª) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x0b, 0xfe, 0x40,  //..%@@@@%+..
    0x34, 0x07, 0xd0,  //.@+....@@+.
    0x00, 0x00, 0xf0,  //........@@.
    0x0b, 0xff, 0xf0,  //..%@@@@@@@.
    0x7d, 0x00, 0xf0,  //.@@+....@@.
    0xf0, 0x00, 0xf0,  //@@......@@.
    0xf0, 0x01, 0xf0,  //@@.....+@@.
    0xf0, 0x03, 0xf0,  //@@.....@@@.
    0x7c, 0x0b, 0xf0,  //+@@...%@@@.
    0x1f, 0xf8, 0xf0,  //.+@@@@%.@@.
    0x00, 0x00, 0x00,  //...........
    0xbf, 0xff, 0xf0,  //%@@@@@@@@@.
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00ab («) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x20, 0x02,  //.....%.....%
    0x00, 0xb0, 0x0b,  //....%@....%@
    0x02, 0xf0, 0x2f,  //...%@@...%@@
    0x0f, 0xc0, 0xfc,  //..@@@...@@@.
    0x3f, 0x03, 0xf0,  //.@@@...@@@..
    0xfc, 0x0f, 0xc0,  //@@@...@@@...
    0xfc, 0x0f, 0xc0,  //@@@...@@@...
    0x3f, 0x03, 0xf0,  //.@@@...@@@..
    0x0f, 0xc0, 0xfc,  //..@@@...@@@.
    0x02, 0xf0, 0x2f,  //...%@@...%@@
    0x00, 0xb0, 0x0b,  //....%@....%@
    0x00, 0x20, 0x02,  //.....%.....%
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00ac (¬) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x0f,  //..............@@
    0x00, 0x00, 0x00, 0x0f,  //..............@@
    0x00, 0x00, 0x00, 0x0f,  //..............@@
    0x00, 0x00, 0x00, 0x0f,  //..............@@
    0x00, 0x00, 0x00, 0x0f,  //..............@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00ad (­) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0xff, 0xfc,  //@@@@@@@
    0xff, 0xfc,  //@@@@@@@
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+00ae (®) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x07, 0xff, 0x40, 0x00,  //......+@@@@@+......
    0x00, 0xb9, 0x00, 0xb8, 0x00,  //....%@%.....%@%....
    0x03, 0x80, 0x00, 0x0b, 0x00,  //...@%.........%@...
    0x0e, 0x3f, 0xfe, 0x42, 0xc0,  //..@%.@@@@@@%+..%@..
    0x28, 0x3c, 0x02, 0xe0, 0xa0,  //.%%..@@....%@%..%%.
    0x30, 0x3c, 0x00, 0xf0, 0x30,  //.@...@@.....@@...@.
    0x60, 0x3c, 0x00, 0xf0, 0x24,  //+%...@@.....@@...%+
    0xd0, 0x3c, 0x02, 0xe0, 0x1c,  //@+...@@....%@%....@
    0xc0, 0x3f, 0xff, 0x40, 0x0c,  //@....@@@@@@@+.....@
    0xc0, 0x3c, 0x2f, 0x00, 0x0c,  //@....@@..%@@......@
    0xc0, 0x3c, 0x0f, 0x80, 0x0c,  //@....@@...@@%.....@
    0xd0, 0x3c, 0x07, 0xc0, 0x1c,  //@+...@@...+@@.....@
    0xa0, 0x3c, 0x03, 0xe0, 0x24,  //+%...@@....@@%...%+
    0x30, 0x3c, 0x01, 0xf0, 0x30,  //.@...@@....+@@...@.
    0x28, 0x3c, 0x00, 0xf4, 0xa0,  //.%%..@@.....@@+.%%.
    0x0e, 0x3c, 0x00, 0xbe, 0xc0,  //..@%.@@.....%@@%@..
    0x03, 0x80, 0x00, 0x0b, 0x00,  //...@%.........%@...
    0x00, 0xb9, 0x00, 0xb8, 0x00,  //....%@%.....%@%....
    0x00, 0x07, 0xff, 0x40, 0x00,  //......+@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00af (¯) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00b0 (°) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x0b, 0xe0,  //..%@@%..
    0x3f, 0xfc,  //.@@@@@@.
    0xb8, 0x2e,  //%@%..%@%
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xb8, 0x2e,  //%@%..%@%
    0x3f, 0xfc,  //.@@@@@@.
    0x0b, 0xe0,  //..%@@%..
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00b1 (±) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00b2 (²) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x2f, 0xe4,  //.%@@@%..
    0xd0, 0x3d,  //@+...@@+
    0x00, 0x0f,  //......@@
    0x00, 0x0f,  //......@@
    0x00, 0x2e,  //.....%@%
    0x00, 0x7c,  //....+@@.
    0x01, 0xf4,  //...+@@+.
    0x07, 0xd0,  //..+@@+..
    0x1f, 0x40,  //.+@@+...
    0x7d, 0x00,  //+@@+....
    0xff, 0xff,  //@@@@@@@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00b3 (³) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x2f, 0xf4,  //.%@@@@+.
    0xd0, 0x2e,  //@+...%@%
    0x00, 0x0f,  //......@@
    0x00, 0x2e,  //.....%@%
    0x0f, 0xf4,  //..@@@@+.
    0x00, 0x3d,  //.....@@+
    0x00, 0x0f,  //......@@
    0x00, 0x0f,  //......@@
    0x00, 0x0f,  //......@@
    0x80, 0x7d,  //%...+@@+
    0x2f, 0xe0,  //.%@@@%..
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00b4 (´) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x03, 0xe0,  //...@@%
    0x0b, 0xc0,  //..%@%.
    0x1f, 0x00,  //..@@..
    0x3c, 0x00,  //.@@...
    0xb4, 0x00,  //%@+...
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+00b5 (µ) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfd, 0x00, 0xbf, 0x00,  //@@@+....%@@@..
    0xff, 0x41, 0xff, 0x00,  //@@@@+..+@@@@..
    0xfe, 0xff, 0xef, 0xf0,  //@@@%@@@@@%@@@@
    0xfc, 0xbe, 0x0b, 0xe0,  //@@@.%@@%..%@@%
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0xfc, 0x00, 0x00, 0x00,  //@@@...........
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00b6 (¶) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x01, 0xff, 0xff,  //...+@@@@@@@@
    0x0f, 0xff, 0xff,  //..@@@@@@@@@@
    0x3f, 0xff, 0x0f,  //.@@@@@@@..@@
    0xbf, 0xff, 0x0f,  //%@@@@@@@..@@
    0xff, 0xff, 0x0f,  //@@@@@@@@..@@
    0xff, 0xff, 0x0f,  //@@@@@@@@..@@
    0xff, 0xff, 0x0f,  //@@@@@@@@..@@
    0xbf, 0xff, 0x0f,  //%@@@@@@@..@@
    0x3f, 0xff, 0x0f,  //.@@@@@@@..@@
    0x1f, 0xff, 0x0f,  //.+@@@@@@..@@
    0x02, 0xff, 0x0f,  //...%@@@@..@@
    0x00, 0x0f, 0x0f,  //......@@..@@
    0x00, 0x0f, 0x0f,  //......@@..@@
    0x00, 0x0f, 0x0f,  //......@@..@@
    0x00, 0x0f, 0x0f,  //......@@..@@
    0x00, 0x0f, 0x0f,  //......@@..@@
    0x00, 0x0f, 0x0f,  //......@@..@@
    0x00, 0x0f, 0x0f,  //......@@..@@
    0x00, 0x0f, 0x0f,  //......@@..@@
    0x00, 0x0f, 0x0f,  //......@@..@@
    0x00, 0x0f, 0x0f,  //......@@..@@
    0x00, 0x0f, 0x0f,  //......@@..@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00b7 (·) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00b8 (¸) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x0b, 0x40,  //..%@+
    0x03, 0x80,  //...@%
    0x03, 0xc0,  //...@@
    0xff, 0xc0,  //@@@@@
    0xff, 0x00,  //%@@@.
    0x00, 0x00,  //.....


    /*Unicode: U+00b9 (¹) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x1f, 0xc0,  //.+@@@...
    0xd3, 0xc0,  //@+.@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0xff, 0xff,  //@@@@@@@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00ba (º) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x2d, 0x07, 0x80,  //.%@+..+@%.
    0x78, 0x02, 0xd0,  //+@%....%@+
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0x78, 0x02, 0xd0,  //+@%....%@+
    0x2d, 0x07, 0x80,  //.%@+..+@%.
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00,  //..........
    0x7f, 0xff, 0xd0,  //+@@@@@@@@+
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00bb (») , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x80, 0x08, 0x00,  //%.....%.....
    0xe0, 0x0e, 0x00,  //@%....@%....
    0xf8, 0x0f, 0x80,  //@@%...@@%...
    0x3f, 0x03, 0xf0,  //.@@@...@@@..
    0x0f, 0xc0, 0xfc,  //..@@@...@@@.
    0x03, 0xf0, 0x3f,  //...@@@...@@@
    0x03, 0xf0, 0x3f,  //...@@@...@@@
    0x0f, 0xc0, 0xfc,  //..@@@...@@@.
    0x3f, 0x03, 0xf0,  //.@@@...@@@..
    0xf8, 0x0f, 0x80,  //@@%...@@%...
    0xe0, 0x0e, 0x00,  //@%....@%....
    0x80, 0x08, 0x00,  //%.....%.....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00bc (¼) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x1f, 0xc0, 0x00, 0x0b, 0x80, 0x00,  //.+@@@.........%@%......
    0xd3, 0xc0, 0x00, 0x1f, 0x00, 0x00,  //@+.@@........+@@.......
    0x03, 0xc0, 0x00, 0x3d, 0x00, 0x00,  //...@@........@@+.......
    0x03, 0xc0, 0x00, 0x7c, 0x00, 0x00,  //...@@.......+@@........
    0x03, 0xc0, 0x00, 0xf0, 0x00, 0x00,  //...@@.......@@.........
    0x03, 0xc0, 0x02, 0xe0, 0x00, 0x00,  //...@@......%@%.........
    0x03, 0xc0, 0x07, 0xc0, 0x00, 0x00,  //...@@.....+@@..........
    0x03, 0xc0, 0x0f, 0x40, 0x00, 0x00,  //...@@.....@@+..........
    0x03, 0xc0, 0x2f, 0x00, 0x07, 0xc0,  //...@@....%@@......+@@..
    0x03, 0xc0, 0x3c, 0x00, 0x0f, 0xc0,  //...@@....@@.......@@@..
    0xff, 0xff, 0xf8, 0x00, 0x37, 0xc0,  //@@@@@@@@@@%......@+@@..
    0x00, 0x01, 0xf0, 0x00, 0xa3, 0xc0,  //.......+@@......%%.@@..
    0x00, 0x03, 0xd0, 0x01, 0xc3, 0xc0,  //.......@@+.....+@..@@..
    0x00, 0x0b, 0x80, 0x03, 0x43, 0xc0,  //......%@%......@+..@@..
    0x00, 0x0f, 0x00, 0x0e, 0x03, 0xc0,  //......@@......@%...@@..
    0x00, 0x3d, 0x00, 0x0f, 0xff, 0xfc,  //.....@@+......@@@@@@@@@
    0x00, 0x7c, 0x00, 0x00, 0x03, 0xc0,  //....+@@............@@..
    0x00, 0xf4, 0x00, 0x00, 0x03, 0xc0,  //....@@+............@@..
    0x02, 0xe0, 0x00, 0x00, 0x03, 0xc0,  //...%@%.............@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00bd (½) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x1f, 0xc0, 0x00, 0x0b, 0x80, 0x00,  //.+@@@.........%@%.....
    0xd3, 0xc0, 0x00, 0x1f, 0x00, 0x00,  //@+.@@........+@@......
    0x03, 0xc0, 0x00, 0x3d, 0x00, 0x00,  //...@@........@@+......
    0x03, 0xc0, 0x00, 0x7c, 0x00, 0x00,  //...@@.......+@@.......
    0x03, 0xc0, 0x00, 0xf0, 0x00, 0x00,  //...@@.......@@........
    0x03, 0xc0, 0x02, 0xe0, 0x00, 0x00,  //...@@......%@%........
    0x03, 0xc0, 0x07, 0xc0, 0x00, 0x00,  //...@@.....+@@.........
    0x03, 0xc0, 0x0f, 0x40, 0x00, 0x00,  //...@@.....@@+.........
    0x03, 0xc0, 0x2f, 0x02, 0xfe, 0x40,  //...@@....%@@...%@@@%..
    0x03, 0xc0, 0x3c, 0x0d, 0x03, 0xd0,  //...@@....@@...@+...@@+
    0xff, 0xff, 0xf8, 0x00, 0x00, 0xf0,  //@@@@@@@@@@%.........@@
    0x00, 0x01, 0xf0, 0x00, 0x00, 0xf0,  //.......+@@..........@@
    0x00, 0x03, 0xd0, 0x00, 0x02, 0xe0,  //.......@@+.........%@%
    0x00, 0x0b, 0x80, 0x00, 0x07, 0xc0,  //......%@%.........+@@.
    0x00, 0x0f, 0x00, 0x00, 0x1f, 0x40,  //......@@.........+@@+.
    0x00, 0x3d, 0x00, 0x00, 0x7d, 0x00,  //.....@@+........+@@+..
    0x00, 0x7c, 0x00, 0x01, 0xf4, 0x00,  //....+@@........+@@+...
    0x00, 0xf4, 0x00, 0x07, 0xd0, 0x00,  //....@@+.......+@@+....
    0x02, 0xe0, 0x00, 0x0f, 0xff, 0xf0,  //...%@%........@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+00be (¾) , Width: 24 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x2f, 0xf4, 0x00, 0x02, 0xe0, 0x00,  //.%@@@@+........%@%......
    0xd0, 0x2e, 0x00, 0x07, 0xc0, 0x00,  //@+...%@%......+@@.......
    0x00, 0x0f, 0x00, 0x0f, 0x40, 0x00,  //......@@......@@+.......
    0x00, 0x2e, 0x00, 0x1f, 0x00, 0x00,  //.....%@%.....+@@........
    0x0f, 0xf4, 0x00, 0x3c, 0x00, 0x00,  //..@@@@+......@@.........
    0x00, 0x3d, 0x00, 0xb8, 0x00, 0x00,  //.....@@+....%@%.........
    0x00, 0x0f, 0x01, 0xf0, 0x00, 0x00,  //......@@...+@@..........
    0x00, 0x0f, 0x03, 0xd0, 0x00, 0x00,  //......@@...@@+..........
    0x00, 0x0f, 0x0b, 0xc0, 0x01, 0xf0,  //......@@..%@@......+@@..
    0x80, 0x7d, 0x0f, 0x00, 0x03, 0xf0,  //%...+@@+..@@.......@@@..
    0x2f, 0xe0, 0x3e, 0x00, 0x0d, 0xf0,  //.%@@@%...@@%......@+@@..
    0x00, 0x00, 0x7c, 0x00, 0x28, 0xf0,  //........+@@......%%.@@..
    0x00, 0x00, 0xf4, 0x00, 0x70, 0xf0,  //........@@+.....+@..@@..
    0x00, 0x02, 0xe0, 0x00, 0xd0, 0xf0,  //.......%@%......@+..@@..
    0x00, 0x03, 0xc0, 0x03, 0x80, 0xf0,  //.......@@......@%...@@..
    0x00, 0x0f, 0x40, 0x03, 0xff, 0xff,  //......@@+......@@@@@@@@@
    0x00, 0x1f, 0x00, 0x00, 0x00, 0xf0,  //.....+@@............@@..
    0x00, 0x3d, 0x00, 0x00, 0x00, 0xf0,  //.....@@+............@@..
    0x00, 0xb8, 0x00, 0x00, 0x00, 0xf0,  //....%@%.............@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................


    /*Unicode: U+00bf (¿) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0xfc, 0x00,  //....@@@...
    0x00, 0xfc, 0x00,  //....@@@...
    0x00, 0xfc, 0x00,  //....@@@...
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0xfc, 0x00,  //....@@@...
    0x00, 0xfc, 0x00,  //....@@@...
    0x00, 0xfc, 0x00,  //....@@@...
    0x00, 0xf8, 0x00,  //....@@%...
    0x02, 0xf0, 0x00,  //...%@@....
    0x07, 0xc0, 0x00,  //..+@@.....
    0x1f, 0x00, 0x00,  //.+@@......
    0x7d, 0x00, 0x00,  //+@@+......
    0xfc, 0x00, 0x00,  //@@@.......
    0xfc, 0x00, 0x00,  //@@@.......
    0xfd, 0x00, 0x20,  //@@@+.....%
    0xbf, 0x41, 0xf0,  //%@@@+..+@@
    0x3f, 0xff, 0xd0,  //.@@@@@@@@+
    0x07, 0xfe, 0x00,  //..+@@@@%..
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00c0 (À) , Width: 17 */
    0x00, 0x2f, 0x00, 0x00, 0x00,  //.....%@@.........
    0x00, 0x0b, 0x80, 0x00, 0x00,  //......%@%........
    0x00, 0x02, 0xd0, 0x00, 0x00,  //.......%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x07, 0xf4, 0x00, 0x00,  //......+@@@+......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x3f, 0x7f, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x7f, 0x3f, 0x40, 0x00,  //....+@@@.@@@+....
    0x00, 0xbd, 0x1f, 0x80, 0x00,  //....%@@+.+@@%....
    0x00, 0xfc, 0x0f, 0xc0, 0x00,  //....@@@...@@@....
    0x01, 0xf8, 0x0b, 0xd0, 0x00,  //...+@@%...%@@+...
    0x03, 0xf4, 0x07, 0xf0, 0x00,  //...@@@+...+@@@...
    0x03, 0xf0, 0x03, 0xf0, 0x00,  //...@@@.....@@@...
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x0f, 0xff, 0xff, 0xfc, 0x00,  //..@@@@@@@@@@@@@..
    0x1f, 0xc0, 0x00, 0xfd, 0x00,  //.+@@@.......@@@+.
    0x2f, 0x40, 0x00, 0xbe, 0x00,  //.%@@+.......+@@%.
    0x3f, 0x00, 0x00, 0x3f, 0x00,  //.@@@.........@@@.
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@%.........@@@+
    0xfd, 0x00, 0x00, 0x1f, 0xc0,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c1 (Á) , Width: 17 */
    0x00, 0x00, 0x3d, 0x00, 0x00,  //.........@@+.....
    0x00, 0x00, 0xb4, 0x00, 0x00,  //........%@+......
    0x00, 0x02, 0xd0, 0x00, 0x00,  //.......%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x07, 0xf4, 0x00, 0x00,  //......+@@@+......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x3f, 0x7f, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x7f, 0x3f, 0x40, 0x00,  //....+@@@.@@@+....
    0x00, 0xbd, 0x1f, 0x80, 0x00,  //....%@@+.+@@%....
    0x00, 0xfc, 0x0f, 0xc0, 0x00,  //....@@@...@@@....
    0x01, 0xf8, 0x0b, 0xd0, 0x00,  //...+@@%...%@@+...
    0x03, 0xf4, 0x07, 0xf0, 0x00,  //...@@@+...+@@@...
    0x03, 0xf0, 0x03, 0xf0, 0x00,  //...@@@.....@@@...
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x0f, 0xff, 0xff, 0xfc, 0x00,  //..@@@@@@@@@@@@@..
    0x1f, 0xc0, 0x00, 0xfd, 0x00,  //.+@@@.......@@@+.
    0x2f, 0x40, 0x00, 0xbe, 0x00,  //.%@@+.......+@@%.
    0x3f, 0x00, 0x00, 0x3f, 0x00,  //.@@@.........@@@.
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@%.........@@@+
    0xfd, 0x00, 0x00, 0x1f, 0xc0,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c2 (Â) , Width: 17 */
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x0f, 0x7c, 0x00, 0x00,  //......@@+@@......
    0x00, 0x2c, 0x0e, 0x00, 0x00,  //.....%@...@%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x07, 0xf4, 0x00, 0x00,  //......+@@@+......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x3f, 0x7f, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x7f, 0x3f, 0x40, 0x00,  //....+@@@.@@@+....
    0x00, 0xbd, 0x1f, 0x80, 0x00,  //....%@@+.+@@%....
    0x00, 0xfc, 0x0f, 0xc0, 0x00,  //....@@@...@@@....
    0x01, 0xf8, 0x0b, 0xd0, 0x00,  //...+@@%...%@@+...
    0x03, 0xf4, 0x07, 0xf0, 0x00,  //...@@@+...+@@@...
    0x03, 0xf0, 0x03, 0xf0, 0x00,  //...@@@.....@@@...
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x0f, 0xff, 0xff, 0xfc, 0x00,  //..@@@@@@@@@@@@@..
    0x1f, 0xc0, 0x00, 0xfd, 0x00,  //.+@@@.......@@@+.
    0x2f, 0x40, 0x00, 0xbe, 0x00,  //.%@@+.......+@@%.
    0x3f, 0x00, 0x00, 0x3f, 0x00,  //.@@@.........@@@.
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@%.........@@@+
    0xfd, 0x00, 0x00, 0x1f, 0xc0,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c3 (Ã) , Width: 17 */
    0x00, 0x0f, 0x8f, 0x00, 0x00,  //......@@%.@@.....
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x3c, 0xbc, 0x00, 0x00,  //.....@@.%@@......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x07, 0xf4, 0x00, 0x00,  //......+@@@+......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x3f, 0x7f, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x7f, 0x3f, 0x40, 0x00,  //....+@@@.@@@+....
    0x00, 0xbd, 0x1f, 0x80, 0x00,  //....%@@+.+@@%....
    0x00, 0xfc, 0x0f, 0xc0, 0x00,  //....@@@...@@@....
    0x01, 0xf8, 0x0b, 0xd0, 0x00,  //...+@@%...%@@+...
    0x03, 0xf4, 0x07, 0xf0, 0x00,  //...@@@+...+@@@...
    0x03, 0xf0, 0x03, 0xf0, 0x00,  //...@@@.....@@@...
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x0f, 0xff, 0xff, 0xfc, 0x00,  //..@@@@@@@@@@@@@..
    0x1f, 0xc0, 0x00, 0xfd, 0x00,  //.+@@@.......@@@+.
    0x2f, 0x40, 0x00, 0xbe, 0x00,  //.%@@+.......+@@%.
    0x3f, 0x00, 0x00, 0x3f, 0x00,  //.@@@.........@@@.
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@%.........@@@+
    0xfd, 0x00, 0x00, 0x1f, 0xc0,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c4 (Ä) , Width: 17 */
    0x00, 0x3f, 0x3f, 0x00, 0x00,  //.....@@@.@@@.....
    0x00, 0x3f, 0x3f, 0x00, 0x00,  //.....@@@.@@@.....
    0x00, 0x3f, 0x3f, 0x00, 0x00,  //.....@@@.@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x07, 0xf4, 0x00, 0x00,  //......+@@@+......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x3f, 0x7f, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x7f, 0x3f, 0x40, 0x00,  //....+@@@.@@@+....
    0x00, 0xbd, 0x1f, 0x80, 0x00,  //....%@@+.+@@%....
    0x00, 0xfc, 0x0f, 0xc0, 0x00,  //....@@@...@@@....
    0x01, 0xf8, 0x0b, 0xd0, 0x00,  //...+@@%...%@@+...
    0x03, 0xf4, 0x07, 0xf0, 0x00,  //...@@@+...+@@@...
    0x03, 0xf0, 0x03, 0xf0, 0x00,  //...@@@.....@@@...
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x0f, 0xff, 0xff, 0xfc, 0x00,  //..@@@@@@@@@@@@@..
    0x1f, 0xc0, 0x00, 0xfd, 0x00,  //.+@@@.......@@@+.
    0x2f, 0x40, 0x00, 0xbe, 0x00,  //.%@@+.......+@@%.
    0x3f, 0x00, 0x00, 0x3f, 0x00,  //.@@@.........@@@.
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@%.........@@@+
    0xfd, 0x00, 0x00, 0x1f, 0xc0,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c5 (Å) , Width: 17 */
    0x00, 0x07, 0xf4, 0x00, 0x00,  //......+@@@+......
    0x00, 0x1f, 0xfd, 0x00, 0x00,  //.....+@@@@@+.....
    0x00, 0x3d, 0x1f, 0x00, 0x00,  //.....@@+.+@@.....
    0x00, 0x3c, 0x0f, 0x00, 0x00,  //.....@@...@@.....
    0x00, 0x2d, 0x1e, 0x00, 0x00,  //.....%@+.+@%.....
    0x00, 0x0b, 0xf8, 0x00, 0x00,  //......%@@@%......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x0b, 0xf8, 0x00, 0x00,  //......%@@@%......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x1f, 0xfd, 0x00, 0x00,  //.....+@@@@@+.....
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x3f, 0x3f, 0x00, 0x00,  //.....@@@.@@@.....
    0x00, 0xbe, 0x2f, 0x80, 0x00,  //....%@@%.%@@%....
    0x00, 0xfd, 0x1f, 0xc0, 0x00,  //....@@@+.+@@@....
    0x01, 0xfc, 0x0f, 0xd0, 0x00,  //...+@@@...@@@+...
    0x02, 0xf8, 0x0b, 0xe0, 0x00,  //...%@@%...%@@%...
    0x03, 0xf0, 0x03, 0xf0, 0x00,  //...@@@.....@@@...
    0x07, 0xff, 0xff, 0xf4, 0x00,  //..+@@@@@@@@@@@+..
    0x0f, 0xff, 0xff, 0xfc, 0x00,  //..@@@@@@@@@@@@@..
    0x0f, 0xc0, 0x00, 0xfc, 0x00,  //..@@@.......@@@..
    0x2f, 0x80, 0x00, 0xbe, 0x00,  //.%@@%.......%@@%.
    0x3f, 0x00, 0x00, 0x3f, 0x00,  //.@@@.........@@@.
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@@.........@@@+
    0xfd, 0x00, 0x00, 0x1f, 0xc0,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c6 (Æ) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x01, 0xff, 0xff, 0xff, 0xfc,  //.......+@@@@@@@@@@@@@@@
    0x00, 0x03, 0xff, 0xff, 0xff, 0xfc,  //.......@@@@@@@@@@@@@@@@
    0x00, 0x07, 0xf3, 0xf0, 0x00, 0x00,  //......+@@@.@@@.........
    0x00, 0x0b, 0xe3, 0xf0, 0x00, 0x00,  //......%@@%.@@@.........
    0x00, 0x0f, 0xc3, 0xf0, 0x00, 0x00,  //......@@@..@@@.........
    0x00, 0x2f, 0x83, 0xf0, 0x00, 0x00,  //.....%@@%..@@@.........
    0x00, 0x3f, 0x43, 0xf0, 0x00, 0x00,  //.....@@@+..@@@.........
    0x00, 0x7f, 0x03, 0xf0, 0x00, 0x00,  //....+@@@...@@@.........
    0x00, 0xbd, 0x03, 0xff, 0xff, 0xf0,  //....%@@+...@@@@@@@@@@@.
    0x00, 0xfc, 0x03, 0xff, 0xff, 0xf0,  //....@@@....@@@@@@@@@@@.
    0x02, 0xf8, 0x03, 0xf0, 0x00, 0x00,  //...%@@%....@@@.........
    0x03, 0xf4, 0x03, 0xf0, 0x00, 0x00,  //...@@@+....@@@.........
    0x07, 0xff, 0xff, 0xf0, 0x00, 0x00,  //..+@@@@@@@@@@@.........
    0x0f, 0xff, 0xff, 0xf0, 0x00, 0x00,  //..@@@@@@@@@@@@.........
    0x0f, 0xc0, 0x03, 0xf0, 0x00, 0x00,  //..@@@......@@@.........
    0x2f, 0x80, 0x03, 0xf0, 0x00, 0x00,  //.%@@%......@@@.........
    0x3f, 0x00, 0x03, 0xf0, 0x00, 0x00,  //.@@@.......@@@.........
    0x7f, 0x00, 0x03, 0xff, 0xff, 0xfc,  //+@@@.......@@@@@@@@@@@@
    0xfd, 0x00, 0x03, 0xff, 0xff, 0xfc,  //@@@+.......@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c7 (Ç) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x1b, 0xfe, 0x40,  //.....+%@@@@%+..
    0x01, 0xff, 0xff, 0xf4,  //...+@@@@@@@@@@+
    0x07, 0xf8, 0x01, 0xfc,  //..+@@@%....+@@@
    0x1f, 0xc0, 0x00, 0x2c,  //.+@@@........%@
    0x3f, 0x40, 0x00, 0x04,  //.@@@+.........+
    0x7e, 0x00, 0x00, 0x00,  //+@@%...........
    0xbd, 0x00, 0x00, 0x00,  //%@@+...........
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xbd, 0x00, 0x00, 0x00,  //%@@+...........
    0x7e, 0x00, 0x00, 0x00,  //+@@%...........
    0x3f, 0x40, 0x00, 0x04,  //.@@@..........+
    0x1f, 0xc0, 0x00, 0x2c,  //.+@@@........%@
    0x07, 0xf8, 0x01, 0xfc,  //..+@@@%....+@@@
    0x01, 0xff, 0xff, 0xf4,  //...+@@@@@@@@@@+
    0x00, 0x1b, 0xfe, 0x40,  //.....+%@@@@%+..
    0x00, 0x00, 0x2d, 0x00,  //.........%@+...
    0x00, 0x00, 0x0e, 0x00,  //..........@%...
    0x00, 0x00, 0x0f, 0x00,  //..........@@...
    0x00, 0x03, 0xff, 0x00,  //.......@@@@@...
    0x00, 0x03, 0xfc, 0x00,  //.......%@@@....
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00c8 (È) , Width: 12 */
    0x02, 0xf0, 0x00,  //...%@@......
    0x00, 0xb8, 0x00,  //....%@%.....
    0x00, 0x2d, 0x00,  //.....%@+....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c9 (É) , Width: 12 */
    0x00, 0x03, 0xd0,  //.......@@+..
    0x00, 0x0b, 0x40,  //......%@+...
    0x00, 0x2d, 0x00,  //.....%@+....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00ca (Ê) , Width: 12 */
    0x00, 0x2f, 0x80,  //.....%@@%...
    0x00, 0xb5, 0xe0,  //....%@++@%..
    0x02, 0xd0, 0x78,  //...%@+..+@%.
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00cb (Ë) , Width: 12 */
    0x03, 0xf0, 0xfc,  //...@@@..@@@.
    0x03, 0xf0, 0xfc,  //...@@@..@@@.
    0x03, 0xf0, 0xfc,  //...@@@..@@@.
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00cc (Ì) , Width: 5 */
    0xbc, 0x00,  //%@@..
    0x2e, 0x00,  //.%@%.
    0x0b, 0x40,  //..%@+
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00cd (Í) , Width: 5 */
    0x0f, 0x40,  //..@@+
    0x2d, 0x00,  //.%@+.
    0xb4, 0x00,  //%@+..
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0xfc, 0x00,  //@@@..
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00ce (Î) , Width: 8 */
    0x1f, 0xd0,  //.+@@@+..
    0x7c, 0xf4,  //+@@.@@+.
    0xe0, 0x2d,  //@%...%@+
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00cf (Ï) , Width: 7 */
    0xfc, 0xfc,  //@@@.@@@
    0xfc, 0xfc,  //@@@.@@@
    0xfc, 0xfc,  //@@@.@@@
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+00d0 (Ð) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x03, 0xff, 0xff, 0x90, 0x00,  //...@@@@@@@@@%+.....
    0x03, 0xff, 0xff, 0xfd, 0x00,  //...@@@@@@@@@@@@+...
    0x03, 0xf0, 0x01, 0xbf, 0x80,  //...@@@.....+%@@@%..
    0x03, 0xf0, 0x00, 0x0f, 0xd0,  //...@@@........@@@+.
    0x03, 0xf0, 0x00, 0x03, 0xf0,  //...@@@.........@@@.
    0x03, 0xf0, 0x00, 0x02, 0xf4,  //...@@@.........%@@+
    0x03, 0xf0, 0x00, 0x01, 0xf8,  //...@@@.........+@@%
    0x03, 0xf0, 0x00, 0x00, 0xfc,  //...@@@..........@@@
    0xff, 0xff, 0xf0, 0x00, 0xfc,  //@@@@@@@@@@......@@@
    0xff, 0xff, 0xf0, 0x00, 0xfc,  //@@@@@@@@@@......@@@
    0x03, 0xf0, 0x00, 0x00, 0xfc,  //...@@@..........@@@
    0x03, 0xf0, 0x00, 0x00, 0xfc,  //...@@@..........@@@
    0x03, 0xf0, 0x00, 0x01, 0xf8,  //...@@@.........+@@%
    0x03, 0xf0, 0x00, 0x02, 0xf4,  //...@@@.........%@@+
    0x03, 0xf0, 0x00, 0x03, 0xf0,  //...@@@.........@@@.
    0x03, 0xf0, 0x00, 0x0f, 0xd0,  //...@@@........@@@+.
    0x03, 0xf0, 0x01, 0xbf, 0x80,  //...@@@.....+%@@@%..
    0x03, 0xff, 0xff, 0xfd, 0x00,  //...@@@@@@@@@@@@+...
    0x03, 0xff, 0xff, 0x90, 0x00,  //...@@@@@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00d1 (Ñ) , Width: 14 */
    0x00, 0xfd, 0x3c, 0x00,  //....@@@+.@@...
    0x02, 0xff, 0xf8, 0x00,  //...%@@@@@@%...
    0x03, 0xc7, 0xf0, 0x00,  //...@@.+@@@....
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0x00, 0x03, 0xf0,  //@@@@.......@@@
    0xff, 0x80, 0x03, 0xf0,  //@@@@%......@@@
    0xff, 0xc0, 0x03, 0xf0,  //@@@@@......@@@
    0xff, 0xe0, 0x03, 0xf0,  //@@@@@%.....@@@
    0xff, 0xf0, 0x03, 0xf0,  //@@@@@@.....@@@
    0xfe, 0xf8, 0x03, 0xf0,  //@@@%@@%....@@@
    0xfc, 0xfd, 0x03, 0xf0,  //@@@.@@@+...@@@
    0xfc, 0xbf, 0x03, 0xf0,  //@@@.%@@@...@@@
    0xfc, 0x3f, 0x43, 0xf0,  //@@@..@@@+..@@@
    0xfc, 0x2f, 0xc3, 0xf0,  //@@@..%@@@..@@@
    0xfc, 0x0f, 0xd3, 0xf0,  //@@@...@@@+.@@@
    0xfc, 0x0b, 0xf3, 0xf0,  //@@@...%@@@.@@@
    0xfc, 0x03, 0xf7, 0xf0,  //@@@....@@@+@@@
    0xfc, 0x02, 0xff, 0xf0,  //@@@....%@@@@@@
    0xfc, 0x00, 0xff, 0xf0,  //@@@.....@@@@@@
    0xfc, 0x00, 0xbf, 0xf0,  //@@@.....%@@@@@
    0xfc, 0x00, 0x3f, 0xf0,  //@@@......@@@@@
    0xfc, 0x00, 0x2f, 0xf0,  //@@@......%@@@@
    0xfc, 0x00, 0x0f, 0xf0,  //@@@.......@@@@
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00d2 (Ò) , Width: 18 */
    0x00, 0x0b, 0xc0, 0x00, 0x00,  //......%@@.........
    0x00, 0x02, 0xe0, 0x00, 0x00,  //.......%@%........
    0x00, 0x00, 0xb4, 0x00, 0x00,  //........%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+.....
    0x01, 0xff, 0xff, 0xf4, 0x00,  //...+@@@@@@@@@@+...
    0x07, 0xf8, 0x02, 0xfd, 0x00,  //..+@@@%....%@@@+..
    0x1f, 0xc0, 0x00, 0x3f, 0x40,  //.+@@@........@@@..
    0x3f, 0x40, 0x00, 0x1f, 0xc0,  //.@@@+........+@@@.
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........%@@+
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........%@@+
    0x3f, 0x40, 0x00, 0x1f, 0xc0,  //.@@@+........+@@@.
    0x1f, 0xc0, 0x00, 0x3f, 0x40,  //.+@@@........@@@+.
    0x07, 0xf8, 0x02, 0xfd, 0x00,  //..+@@@%....%@@@+..
    0x01, 0xff, 0xff, 0xf4, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d3 (Ó) , Width: 18 */
    0x00, 0x00, 0x0f, 0x40, 0x00,  //..........@@+.....
    0x00, 0x00, 0x2d, 0x00, 0x00,  //.........%@+......
    0x00, 0x00, 0xb4, 0x00, 0x00,  //........%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+.....
    0x01, 0xff, 0xff, 0xf4, 0x00,  //...+@@@@@@@@@@+...
    0x07, 0xf8, 0x02, 0xfd, 0x00,  //..+@@@%....%@@@+..
    0x1f, 0xc0, 0x00, 0x3f, 0x40,  //.+@@@........@@@..
    0x3f, 0x40, 0x00, 0x1f, 0xc0,  //.@@@+........+@@@.
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........%@@+
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........%@@+
    0x3f, 0x40, 0x00, 0x1f, 0xc0,  //.@@@+........+@@@.
    0x1f, 0xc0, 0x00, 0x3f, 0x40,  //.+@@@........@@@+.
    0x07, 0xf8, 0x02, 0xfd, 0x00,  //..+@@@%....%@@@+..
    0x01, 0xff, 0xff, 0xf4, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d4 (Ô) , Width: 18 */
    0x00, 0x02, 0xf8, 0x00, 0x00,  //.......%@@%.......
    0x00, 0x0b, 0x5e, 0x00, 0x00,  //......%@++@%......
    0x00, 0x2d, 0x07, 0x80, 0x00,  //.....%@+..+@%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+.....
    0x01, 0xff, 0xff, 0xf4, 0x00,  //...+@@@@@@@@@@+...
    0x07, 0xf8, 0x02, 0xfd, 0x00,  //..+@@@%....%@@@+..
    0x1f, 0xc0, 0x00, 0x3f, 0x40,  //.+@@@........@@@..
    0x3f, 0x40, 0x00, 0x1f, 0xc0,  //.@@@+........+@@@.
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........%@@+
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........%@@+
    0x3f, 0x40, 0x00, 0x1f, 0xc0,  //.@@@+........+@@@.
    0x1f, 0xc0, 0x00, 0x3f, 0x40,  //.+@@@........@@@+.
    0x07, 0xf8, 0x02, 0xfd, 0x00,  //..+@@@%....%@@@+..
    0x01, 0xff, 0xff, 0xf4, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d5 (Õ) , Width: 18 */
    0x00, 0x0f, 0xd3, 0xc0, 0x00,  //......@@@+.@@.....
    0x00, 0x2f, 0xff, 0x80, 0x00,  //.....%@@@@@@%.....
    0x00, 0x3c, 0x7f, 0x00, 0x00,  //.....@@.+@@@......
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+.....
    0x01, 0xff, 0xff, 0xf4, 0x00,  //...+@@@@@@@@@@+...
    0x07, 0xf8, 0x02, 0xfd, 0x00,  //..+@@@%....%@@@+..
    0x1f, 0xc0, 0x00, 0x3f, 0x40,  //.+@@@........@@@..
    0x3f, 0x40, 0x00, 0x1f, 0xc0,  //.@@@+........+@@@.
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........%@@+
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........%@@+
    0x3f, 0x40, 0x00, 0x1f, 0xc0,  //.@@@+........+@@@.
    0x1f, 0xc0, 0x00, 0x3f, 0x40,  //.+@@@........@@@+.
    0x07, 0xf8, 0x02, 0xfd, 0x00,  //..+@@@%....%@@@+..
    0x01, 0xff, 0xff, 0xf4, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d6 (Ö) , Width: 18 */
    0x00, 0x3f, 0x0f, 0xc0, 0x00,  //.....@@@..@@@.....
    0x00, 0x3f, 0x0f, 0xc0, 0x00,  //.....@@@..@@@.....
    0x00, 0x3f, 0x0f, 0xc0, 0x00,  //.....@@@..@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+.....
    0x01, 0xff, 0xff, 0xf4, 0x00,  //...+@@@@@@@@@@+...
    0x07, 0xf8, 0x02, 0xfd, 0x00,  //..+@@@%....%@@@+..
    0x1f, 0xc0, 0x00, 0x3f, 0x40,  //.+@@@........@@@..
    0x3f, 0x40, 0x00, 0x1f, 0xc0,  //.@@@+........+@@@.
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........%@@+
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........%@@+
    0x3f, 0x40, 0x00, 0x1f, 0xc0,  //.@@@+........+@@@.
    0x1f, 0xc0, 0x00, 0x3f, 0x40,  //.+@@@........@@@+.
    0x07, 0xf8, 0x02, 0xfd, 0x00,  //..+@@@%....%@@@+..
    0x01, 0xff, 0xff, 0xf4, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d7 (×) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x20, 0x00, 0x00, 0x20,  //.%...........%.
    0xf8, 0x00, 0x00, 0xbc,  //@@%.........%@@
    0x3e, 0x00, 0x02, 0xf0,  //.@@%.......%@@.
    0x0f, 0x80, 0x0b, 0xc0,  //..@@%.....%@@..
    0x03, 0xe0, 0x2f, 0x00,  //...@@%...%@@...
    0x00, 0xf8, 0xbc, 0x00,  //....@@%.%@@....
    0x00, 0x3f, 0xf0, 0x00,  //.....@@@@@.....
    0x00, 0x1f, 0xd0, 0x00,  //.....+@@@+.....
    0x00, 0x3f, 0xf0, 0x00,  //.....@@@@@.....
    0x00, 0xf8, 0xbc, 0x00,  //....@@%.%@@....
    0x03, 0xe0, 0x2f, 0x00,  //...@@%...%@@...
    0x0f, 0x80, 0x0b, 0xc0,  //..@@%.....%@@..
    0x3e, 0x00, 0x02, 0xf0,  //.@@%.......%@@.
    0xf8, 0x00, 0x00, 0xbc,  //@@%.........%@@
    0x20, 0x00, 0x00, 0x20,  //.%...........%.
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00d8 (Ø) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x1b, 0xfe, 0x40, 0xf0,  //.....+%@@@@%+...@@.
    0x01, 0xff, 0xff, 0xf7, 0xd0,  //...+@@@@@@@@@@+@@+.
    0x07, 0xf8, 0x02, 0xff, 0x40,  //..+@@@%....%@@@@+..
    0x1f, 0xc0, 0x00, 0x7f, 0x00,  //.+@@@.......+@@@...
    0x3f, 0x40, 0x00, 0xff, 0xc0,  //.@@@+.......%@@@@..
    0x7f, 0x00, 0x02, 0xeb, 0xc0,  //+@@@.......%@%%@@..
    0xbd, 0x00, 0x0b, 0x87, 0xe0,  //%@@+......%@%.+@@%.
    0xfc, 0x00, 0x1f, 0x03, 0xf0,  //@@@......+@@...@@@.
    0xfc, 0x00, 0x7c, 0x03, 0xf0,  //@@@......@@....@@@.
    0xfc, 0x00, 0xf0, 0x03, 0xf0,  //@@@.....@@.....@@@.
    0xfc, 0x03, 0xd0, 0x03, 0xf0,  //@@@....@@+.....@@@.
    0xfc, 0x0f, 0x40, 0x03, 0xf0,  //@@@...@@+......@@@.
    0xbd, 0x2e, 0x00, 0x07, 0xe0,  //%@@+.%@%......+@@%.
    0x7e, 0xb8, 0x00, 0x0f, 0xd0,  //+@@%%@%.......@@@+.
    0x3f, 0xf0, 0x00, 0x1f, 0xc0,  //.@@@@%.......+@@@..
    0x0f, 0xd0, 0x00, 0x3f, 0x40,  //..@@@+.......@@@+..
    0x0f, 0xf8, 0x02, 0xfd, 0x00,  //..@@@@%....%@@@+...
    0x3d, 0xff, 0xff, 0xf4, 0x00,  //.@@+@@@@@@@@@@+....
    0xf4, 0x1b, 0xfe, 0x40, 0x00,  //@@...+%@@@@%+......
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00d9 (Ù) , Width: 14 */
    0x02, 0xf0, 0x00, 0x00,  //...%@@........
    0x00, 0xb8, 0x00, 0x00,  //....%@%.......
    0x00, 0x2d, 0x00, 0x00,  //.....%@+......
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xbd, 0x00, 0x07, 0xe0,  //%@@+......+@@%
    0x7f, 0x00, 0x0f, 0xd0,  //+@@@......@@@+
    0x2f, 0x80, 0x3f, 0x80,  //.%@@%....%@@%.
    0x0b, 0xff, 0xfe, 0x00,  //..%@@@@@@@@%..
    0x01, 0xbf, 0xe4, 0x00,  //...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00da (Ú) , Width: 14 */
    0x00, 0x03, 0xd0, 0x00,  //.......@@+....
    0x00, 0x0b, 0x40, 0x00,  //......%@+.....
    0x00, 0x2d, 0x00, 0x00,  //.....%@+......
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xbd, 0x00, 0x07, 0xe0,  //%@@+......+@@%
    0x7f, 0x00, 0x0f, 0xd0,  //+@@@......@@@+
    0x2f, 0x80, 0x3f, 0x80,  //.%@@%....%@@%.
    0x0b, 0xff, 0xfe, 0x00,  //..%@@@@@@@@%..
    0x01, 0xbf, 0xe4, 0x00,  //...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00db (Û) , Width: 14 */
    0x00, 0x2f, 0x80, 0x00,  //.....%@@%.....
    0x00, 0xb5, 0xe0, 0x00,  //....%@++@%....
    0x02, 0xd0, 0x78, 0x00,  //...%@+..+@%...
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xbd, 0x00, 0x07, 0xe0,  //%@@+......+@@%
    0x7f, 0x00, 0x0f, 0xd0,  //+@@@......@@@+
    0x2f, 0x80, 0x3f, 0x80,  //.%@@%....%@@%.
    0x0b, 0xff, 0xfe, 0x00,  //..%@@@@@@@@%..
    0x01, 0xbf, 0xe4, 0x00,  //...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00dc (Ü) , Width: 14 */
    0x03, 0xf0, 0xfc, 0x00,  //...@@@..@@@...
    0x03, 0xf0, 0xfc, 0x00,  //...@@@..@@@...
    0x03, 0xf0, 0xfc, 0x00,  //...@@@..@@@...
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xbd, 0x00, 0x07, 0xe0,  //%@@+......+@@%
    0x7f, 0x00, 0x0f, 0xd0,  //+@@@......@@@+
    0x2f, 0x80, 0x3f, 0x80,  //.%@@%....%@@%.
    0x0b, 0xff, 0xfe, 0x00,  //..%@@@@@@@@%..
    0x01, 0xbf, 0xe4, 0x00,  //...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00dd (Ý) , Width: 17 */
    0x00, 0x00, 0xf4, 0x00, 0x00,  //........@@+......
    0x00, 0x02, 0xd0, 0x00, 0x00,  //.......%@+.......
    0x00, 0x0b, 0x40, 0x00, 0x00,  //......%@+........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xbf, 0x00, 0x00, 0x3f, 0x80,  //%@@@.........@@@%
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x0f, 0xd0, 0x01, 0xfc, 0x00,  //..@@@+.....+@@@..
    0x0b, 0xf0, 0x03, 0xf8, 0x00,  //..%@@@.....@@@%..
    0x03, 0xfc, 0x0f, 0xf0, 0x00,  //...@@@@...@@@@...
    0x00, 0xfe, 0x2f, 0xc0, 0x00,  //....@@@%.%@@@....
    0x00, 0x7f, 0x7f, 0x40, 0x00,  //....+@@@+@@@+....
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x07, 0xf4, 0x00, 0x00,  //......+@@@+......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00de (Þ) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0x80,  //@@@@@@@@%...
    0xff, 0xff, 0xf4,  //@@@@@@@@@@+.
    0xfc, 0x01, 0xfd,  //@@@....+@@@+
    0xfc, 0x00, 0xbe,  //@@@.....+@@%
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0xbe,  //@@@.....+@@%
    0xfc, 0x01, 0xfd,  //@@@....+@@@+
    0xff, 0xff, 0xf4,  //@@@@@@@@@@+.
    0xff, 0xff, 0x80,  //@@@@@@@@%...
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00df (ß) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x06, 0xfe, 0x40, 0x00,  //..+%@@@%+....
    0x2f, 0xff, 0xe0, 0x00,  //.%@@@@@@@%...
    0x7f, 0x43, 0xf4, 0x00,  //+@@@+..@@@+..
    0xfd, 0x01, 0xf8, 0x00,  //%@@+...+@@%..
    0xfc, 0x00, 0xfc, 0x00,  //@@@.....@@@..
    0xfc, 0x0b, 0xfc, 0x00,  //@@@...%@@@@..
    0xfc, 0x1f, 0xc0, 0x00,  //@@@..+@@@....
    0xfc, 0x3f, 0x00, 0x00,  //@@@..@@@.....
    0xfc, 0x3f, 0x00, 0x00,  //@@@..@@@.....
    0xfc, 0x3f, 0x00, 0x00,  //@@@..@@@.....
    0xfc, 0x1f, 0x00, 0x00,  //@@@..+@@.....
    0xfc, 0x07, 0xe0, 0x00,  //@@@...+@@%...
    0xfc, 0x00, 0xfd, 0x00,  //@@@.....@@@+.
    0xfc, 0x00, 0x3f, 0x40,  //@@@......@@@+
    0xfc, 0x00, 0x1f, 0xc0,  //@@@......+@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x90, 0x3f, 0x80,  //@@@.%+...@@@%
    0xfc, 0xff, 0xff, 0x00,  //@@@.@@@@@@@@.
    0xfc, 0x2f, 0xf4, 0x00,  //@@@..%@@@@+..
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00e0 (à) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x0b, 0xc0, 0x00,  //..%@@.......
    0x03, 0xe0, 0x00,  //...%@%......
    0x00, 0xf0, 0x00,  //....@@......
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x1e, 0x00,  //.....+@%....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x06, 0xff, 0x80,  //..+%@@@@%...
    0x3f, 0xff, 0xf4,  //.@@@@@@@@@+.
    0x34, 0x01, 0xfc,  //.@+....+@@@.
    0x00, 0x00, 0x7e,  //........+@@%
    0x00, 0x00, 0x3f,  //.........@@@
    0x06, 0xff, 0xff,  //..+%@@@@@@@@
    0x2f, 0xff, 0xff,  //.%@@@@@@@@@@
    0xbf, 0x40, 0x3f,  //+@@@+....@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x7f,  //@@@.....+@@@
    0xfc, 0x00, 0xff,  //@@@.....@@@@
    0xbf, 0x02, 0xbf,  //%@@@...%%@@@
    0x3f, 0xff, 0x3f,  //.@@@@@@@.@@@
    0x0b, 0xf8, 0x3f,  //..%@@@%..@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e1 (á) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0xf8,  //........@@%.
    0x00, 0x02, 0xf0,  //.......%@%..
    0x00, 0x07, 0xc0,  //.......@@...
    0x00, 0x0f, 0x00,  //......@@....
    0x00, 0x2d, 0x00,  //.....%@+....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x06, 0xff, 0x80,  //..+%@@@@%...
    0x3f, 0xff, 0xf4,  //.@@@@@@@@@+.
    0x34, 0x01, 0xfc,  //.@+....+@@@.
    0x00, 0x00, 0x7e,  //........+@@%
    0x00, 0x00, 0x3f,  //.........@@@
    0x06, 0xff, 0xff,  //..+%@@@@@@@@
    0x2f, 0xff, 0xff,  //.%@@@@@@@@@@
    0xbf, 0x40, 0x3f,  //+@@@+....@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x7f,  //@@@.....+@@@
    0xfc, 0x00, 0xff,  //@@@.....@@@@
    0xbf, 0x02, 0xbf,  //%@@@...%%@@@
    0x3f, 0xff, 0x3f,  //.@@@@@@@.@@@
    0x0b, 0xf8, 0x3f,  //..%@@@%..@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e2 (â) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0xff, 0x00,  //....@@@@....
    0x01, 0xd7, 0x40,  //...+@++@+...
    0x03, 0xc3, 0xc0,  //...@@..@@...
    0x0b, 0x00, 0xe0,  //..%@....@%..
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x06, 0xff, 0x80,  //..+%@@@@%...
    0x3f, 0xff, 0xf4,  //.@@@@@@@@@+.
    0x34, 0x01, 0xfc,  //.@+....+@@@.
    0x00, 0x00, 0x7e,  //........+@@%
    0x00, 0x00, 0x3f,  //.........@@@
    0x06, 0xff, 0xff,  //..+%@@@@@@@@
    0x2f, 0xff, 0xff,  //.%@@@@@@@@@@
    0xbf, 0x40, 0x3f,  //+@@@+....@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x7f,  //@@@.....+@@@
    0xfc, 0x00, 0xff,  //@@@.....@@@@
    0xbf, 0x02, 0xbf,  //%@@@...%%@@@
    0x3f, 0xff, 0x3f,  //.@@@@@@@.@@@
    0x0b, 0xf8, 0x3f,  //..%@@@%..@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e3 (ã) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x03, 0xe0, 0xf0,  //...%@%..@@..
    0x0b, 0xf5, 0xf0,  //..%@@@+.@@..
    0x0f, 0x1f, 0xe0,  //..@@.+@@@%..
    0x0f, 0x0b, 0xc0,  //..@@..%@@...
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x06, 0xff, 0x80,  //..+%@@@@%...
    0x3f, 0xff, 0xf4,  //.@@@@@@@@@+.
    0x34, 0x01, 0xfc,  //.@+....+@@@.
    0x00, 0x00, 0x7e,  //........+@@%
    0x00, 0x00, 0x3f,  //.........@@@
    0x06, 0xff, 0xff,  //..+%@@@@@@@@
    0x2f, 0xff, 0xff,  //.%@@@@@@@@@@
    0xbf, 0x40, 0x3f,  //+@@@+....@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x7f,  //@@@.....+@@@
    0xfc, 0x00, 0xff,  //@@@.....@@@@
    0xbf, 0x02, 0xbf,  //%@@@...%%@@@
    0x3f, 0xff, 0x3f,  //.@@@@@@@.@@@
    0x0b, 0xf8, 0x3f,  //..%@@@%..@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e4 (ä) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x0f, 0xc3, 0xf0,  //..@@@..@@@..
    0x0f, 0xc3, 0xf0,  //..@@@..@@@..
    0x0f, 0xc3, 0xf0,  //..@@@..@@@..
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x06, 0xff, 0x80,  //..+%@@@@%...
    0x3f, 0xff, 0xf4,  //.@@@@@@@@@+.
    0x34, 0x01, 0xfc,  //.@+....+@@@.
    0x00, 0x00, 0x7e,  //........+@@%
    0x00, 0x00, 0x3f,  //.........@@@
    0x06, 0xff, 0xff,  //..+%@@@@@@@@
    0x2f, 0xff, 0xff,  //.%@@@@@@@@@@
    0xbf, 0x40, 0x3f,  //+@@@+....@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x7f,  //@@@.....+@@@
    0xfc, 0x00, 0xff,  //@@@.....@@@@
    0xbf, 0x02, 0xbf,  //%@@@...%%@@@
    0x3f, 0xff, 0x3f,  //.@@@@@@@.@@@
    0x0b, 0xf8, 0x3f,  //..%@@@%..@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e5 (å) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x7f, 0x40,  //....+@@@+...
    0x01, 0xff, 0xd0,  //...+@@@@@+..
    0x03, 0xd1, 0xf0,  //...@@+.+@@..
    0x03, 0xc0, 0xf0,  //...@@...@@..
    0x03, 0xd1, 0xf0,  //...@@+.+@@..
    0x01, 0xff, 0xd0,  //...+@@@@@+..
    0x00, 0x7f, 0x40,  //....+@@@+...
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x06, 0xff, 0x80,  //..+%@@@@%...
    0x3f, 0xff, 0xf4,  //.@@@@@@@@@+.
    0x34, 0x01, 0xfc,  //.@+....+@@@.
    0x00, 0x00, 0x7e,  //........+@@%
    0x00, 0x00, 0x3f,  //.........@@@
    0x06, 0xff, 0xff,  //..+%@@@@@@@@
    0x2f, 0xff, 0xff,  //.%@@@@@@@@@@
    0xbf, 0x40, 0x3f,  //+@@@+....@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x7f,  //@@@.....+@@@
    0xfc, 0x00, 0xff,  //@@@.....@@@@
    0xbf, 0x02, 0xbf,  //%@@@...%%@@@
    0x3f, 0xff, 0x3f,  //.@@@@@@@.@@@
    0x0b, 0xf8, 0x3f,  //..%@@@%..@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e6 (æ) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x06, 0xff, 0x80, 0x2f, 0xf8, 0x00,  //..+%@@@@%....%@@@@%...
    0x3f, 0xff, 0xf5, 0xff, 0xff, 0x00,  //.@@@@@@@@@++@@@@@@@@..
    0x34, 0x01, 0xff, 0xf0, 0x2f, 0xc0,  //.@+....+@@@@@@...%@@@.
    0x00, 0x00, 0x7f, 0xc0, 0x0b, 0xd0,  //........+@@@@.....%@@+
    0x00, 0x00, 0x3f, 0x40, 0x03, 0xe0,  //.........@@@+......@@%
    0x06, 0xff, 0xff, 0x00, 0x03, 0xf0,  //..+%@@@@@@@@.......@@@
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.%@@@@@@@@@@@@@@@@@@@@
    0xbf, 0x40, 0x3f, 0xff, 0xff, 0xf0,  //+@@@+....@@@@@@@@@@@@@
    0xfc, 0x00, 0x3f, 0x00, 0x00, 0x00,  //@@@......@@@..........
    0xfc, 0x00, 0x7f, 0x40, 0x00, 0x00,  //@@@.....+@@@+.........
    0xfc, 0x00, 0xff, 0xc0, 0x00, 0x00,  //@@@.....%@@@@.........
    0xbf, 0x02, 0xf7, 0xf4, 0x01, 0xc0,  //%@@@...%@@+@@@+....+@.
    0x3f, 0xff, 0xc1, 0xff, 0xff, 0xc0,  //.@@@@@@@@..+@@@@@@@@@.
    0x0b, 0xfd, 0x00, 0x2f, 0xf9, 0x00,  //..%@@@@+.....%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+00e7 (ç) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0xbf, 0xe0,  //....%@@@@%.
    0x0b, 0xff, 0xfc,  //..%@@@@@@@@
    0x2f, 0xd0, 0x1c,  //.%@@@+...+%
    0x7f, 0x00, 0x00,  //.@@@.......
    0xbd, 0x00, 0x00,  //%@@+.......
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xbd, 0x00, 0x00,  //%@@+.......
    0x3f, 0x00, 0x00,  //.@@@.......
    0x2f, 0xd0, 0x1c,  //.%@@@+...+%
    0x0b, 0xff, 0xfc,  //..%@@@@@@@@
    0x01, 0xbf, 0xe0,  //...+%@@@@%.
    0x00, 0x02, 0xd0,  //.......%@+.
    0x00, 0x00, 0xe0,  //........@%.
    0x00, 0x00, 0xf0,  //........@@.
    0x00, 0x3f, 0xf0,  //.....@@@@@.
    0x00, 0x3f, 0xc0,  //.....%@@@..
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00e8 (è) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x02, 0xf0, 0x00, 0x00,  //...%@@.......
    0x00, 0xf8, 0x00, 0x00,  //....%@%......
    0x00, 0x3c, 0x00, 0x00,  //.....@@......
    0x00, 0x0f, 0x00, 0x00,  //......@@.....
    0x00, 0x07, 0x80, 0x00,  //......+@%....
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0xbf, 0xd0, 0x00,  //....%@@@@+...
    0x0b, 0xff, 0xfc, 0x00,  //..%@@@@@@@@..
    0x2f, 0xc0, 0xbf, 0x00,  //.%@@@...%@@@.
    0x3f, 0x00, 0x2f, 0x40,  //.@@@.....%@@+
    0xbd, 0x00, 0x0f, 0x80,  //%@@+......@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xbd, 0x00, 0x00, 0x00,  //%@@+.........
    0x7f, 0x00, 0x00, 0x00,  //.@@@.........
    0x2f, 0xd0, 0x07, 0x00,  //.%@@@+....+@.
    0x0b, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0xbf, 0xe4, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00e9 (é) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x3e, 0x00,  //.........@@%.
    0x00, 0x00, 0xbc, 0x00,  //........%@%..
    0x00, 0x01, 0xf0, 0x00,  //........@@...
    0x00, 0x03, 0xc0, 0x00,  //.......@@....
    0x00, 0x0b, 0x40, 0x00,  //......%@+....
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0xbf, 0xd0, 0x00,  //....%@@@@+...
    0x0b, 0xff, 0xfc, 0x00,  //..%@@@@@@@@..
    0x2f, 0xc0, 0xbf, 0x00,  //.%@@@...%@@@.
    0x3f, 0x00, 0x2f, 0x40,  //.@@@.....%@@+
    0xbd, 0x00, 0x0f, 0x80,  //%@@+......@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xbd, 0x00, 0x00, 0x00,  //%@@+.........
    0x7f, 0x00, 0x00, 0x00,  //.@@@.........
    0x2f, 0xd0, 0x07, 0x00,  //.%@@@+....+@.
    0x0b, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0xbf, 0xe4, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00ea (ê) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0xbf, 0x80, 0x00,  //....%@@@%....
    0x00, 0xf3, 0xd0, 0x00,  //....@@.@@+...
    0x03, 0xc0, 0xf0, 0x00,  //...@@...@@...
    0x0b, 0x40, 0x78, 0x00,  //..%@+...+@%..
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0xbf, 0xd0, 0x00,  //....%@@@@+...
    0x0b, 0xff, 0xfc, 0x00,  //..%@@@@@@@@..
    0x2f, 0xc0, 0xbf, 0x00,  //.%@@@...%@@@.
    0x3f, 0x00, 0x2f, 0x40,  //.@@@.....%@@+
    0xbd, 0x00, 0x0f, 0x80,  //%@@+......@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xbd, 0x00, 0x00, 0x00,  //%@@+.........
    0x7f, 0x00, 0x00, 0x00,  //.@@@.........
    0x2f, 0xd0, 0x07, 0x00,  //.%@@@+....+@.
    0x0b, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0xbf, 0xe4, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00eb (ë) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0xfc, 0x3f, 0x00,  //....@@@..@@@.
    0x00, 0xfc, 0x3f, 0x00,  //....@@@..@@@.
    0x00, 0xfc, 0x3f, 0x00,  //....@@@..@@@.
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0xbf, 0xd0, 0x00,  //....%@@@@+...
    0x0b, 0xff, 0xfc, 0x00,  //..%@@@@@@@@..
    0x2f, 0xc0, 0xbf, 0x00,  //.%@@@...%@@@.
    0x3f, 0x00, 0x2f, 0x40,  //.@@@.....%@@+
    0xbd, 0x00, 0x0f, 0x80,  //%@@+......@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xbd, 0x00, 0x00, 0x00,  //%@@+.........
    0x7f, 0x00, 0x00, 0x00,  //.@@@.........
    0x2f, 0xd0, 0x07, 0x00,  //.%@@@+....+@.
    0x0b, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0xbf, 0xe4, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00ec (ì) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xf0, 0x00,  //@@...
    0xf8, 0x00,  //%@%..
    0x3c, 0x00,  //.@@..
    0x0f, 0x00,  //..@@.
    0x07, 0x80,  //..+@%
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00ed (í) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x03, 0xe0,  //...@@%
    0x0b, 0xc0,  //..%@%.
    0x1f, 0x00,  //..@@..
    0x3c, 0x00,  //.@@...
    0xb4, 0x00,  //%@+...
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+00ee (î) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x0f, 0xc0,  //..@@@...
    0x2f, 0xe0,  //.%@@@%..
    0x7c, 0xf4,  //+@@.@@+.
    0xf0, 0x3c,  //@@...@@.
    0xd0, 0x1e,  //@+...+@%
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x0f, 0xc0,  //..@@@...
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00ef (ï) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0xfc, 0xfc,  //@@@.@@@
    0xfc, 0xfc,  //@@@.@@@
    0xfc, 0xfc,  //@@@.@@@
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+00f0 (ð) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x02, 0xf0, 0x04, 0x00,  //...%@@....+..
    0x00, 0xf9, 0xbc, 0x00,  //....@@%+%@@..
    0x00, 0x7f, 0x90, 0x00,  //....+@@@%+...
    0x07, 0xff, 0x00, 0x00,  //..+@@@@@.....
    0x0e, 0x0b, 0xc0, 0x00,  //..@%..%@@....
    0x00, 0x03, 0xe0, 0x00,  //.......@@%...
    0x01, 0xff, 0xf4, 0x00,  //...+@@@@@@+..
    0x0f, 0xff, 0xfd, 0x00,  //..%@@@@@@@@..
    0x2f, 0xc0, 0x7f, 0x00,  //.%@@@...+@@@.
    0x7f, 0x00, 0x2f, 0x40,  //+@@@.....%@@+
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0x3f, 0x00, 0x3f, 0x00,  //.@@@.....@@@.
    0x2f, 0x80, 0xbe, 0x00,  //.%@@%...%@@%.
    0x0b, 0xff, 0xf8, 0x00,  //..%@@@@@@@%..
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f1 (ñ) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x03, 0xe0, 0xf0,  //...%@%..@@..
    0x0b, 0xf5, 0xf0,  //..%@@@+.@@..
    0x0f, 0x1f, 0xe0,  //..@@.+@@@%..
    0x0f, 0x0b, 0xc0,  //..@@..%@@...
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xfc, 0x2f, 0xd0,  //@@@..%@@@+..
    0xfc, 0xff, 0xf8,  //@@@.@@@@@@%.
    0xfe, 0x81, 0xfd,  //@@@%%..+@@@+
    0xff, 0x00, 0x7e,  //@@@@....+@@%
    0xfd, 0x00, 0x3f,  //@@@+.....@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00f2 (ò) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x0b, 0xc0, 0x00, 0x00,  //..%@@........
    0x03, 0xe0, 0x00, 0x00,  //...%@%.......
    0x00, 0xf0, 0x00, 0x00,  //....@@.......
    0x00, 0x3c, 0x00, 0x00,  //.....@@......
    0x00, 0x1e, 0x00, 0x00,  //.....+@%.....
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x2f, 0x80, 0xbe, 0x00,  //.%@@%...%@@%.
    0x7f, 0x00, 0x3f, 0x40,  //+@@@.....@@@+
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0x7f, 0x00, 0x3f, 0x40,  //+@@@.....@@@+
    0x2f, 0x80, 0xbe, 0x00,  //.%@@%...%@@%.
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f3 (ó) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0xf8, 0x00,  //........@@%..
    0x00, 0x02, 0xf0, 0x00,  //.......%@%...
    0x00, 0x07, 0xc0, 0x00,  //.......@@....
    0x00, 0x0f, 0x00, 0x00,  //......@@.....
    0x00, 0x2d, 0x00, 0x00,  //.....%@+.....
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x2f, 0x80, 0xbe, 0x00,  //.%@@%...%@@%.
    0x7f, 0x00, 0x3f, 0x40,  //+@@@.....@@@+
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0x7f, 0x00, 0x3f, 0x40,  //+@@@.....@@@+
    0x2f, 0x80, 0xbe, 0x00,  //.%@@%...%@@%.
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f4 (ô) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x2e, 0x00, 0x00,  //.....%@%.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.....
    0x00, 0xb3, 0x80, 0x00,  //....%@.@%....
    0x00, 0xd1, 0xc0, 0x00,  //....@+.+@....
    0x02, 0xc0, 0xe0, 0x00,  //...%@...@%...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x2f, 0x80, 0xbe, 0x00,  //.%@@%...%@@%.
    0x7f, 0x00, 0x3f, 0x40,  //+@@@.....@@@+
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0x7f, 0x00, 0x3f, 0x40,  //+@@@.....@@@+
    0x2f, 0x80, 0xbe, 0x00,  //.%@@%...%@@%.
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f5 (õ) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0xf0, 0xf0, 0x00,  //....@@..@@...
    0x02, 0xfc, 0xf0, 0x00,  //...%@@@.@@...
    0x03, 0xcf, 0xe0, 0x00,  //...@@.@@@%...
    0x03, 0xc3, 0xc0, 0x00,  //...@@..@@....
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x2f, 0x80, 0xbe, 0x00,  //.%@@%...%@@%.
    0x7f, 0x00, 0x3f, 0x40,  //+@@@.....@@@+
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0x7f, 0x00, 0x3f, 0x40,  //+@@@.....@@@+
    0x2f, 0x80, 0xbe, 0x00,  //.%@@%...%@@%.
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f6 (ö) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x0f, 0xc0, 0xfc, 0x00,  //..@@@...@@@..
    0x0f, 0xc0, 0xfc, 0x00,  //..@@@...@@@..
    0x0f, 0xc0, 0xfc, 0x00,  //..@@@...@@@..
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x2f, 0x80, 0xbe, 0x00,  //.%@@%...%@@%.
    0x7f, 0x00, 0x3f, 0x40,  //+@@@.....@@@+
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0x7f, 0x00, 0x3f, 0x40,  //+@@@.....@@@+
    0x2f, 0x80, 0xbe, 0x00,  //.%@@%...%@@%.
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f7 (÷) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f8 (ø) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x20,  //.............%.
    0x00, 0x7f, 0xe0, 0xf0,  //....+@@@@%..@@.
    0x03, 0xff, 0xff, 0xd0,  //...@@@@@@@@@@+.
    0x0f, 0xe0, 0x3f, 0x80,  //..@@@%...@@@%..
    0x1f, 0xc0, 0x2f, 0xc0,  //.+@@@....%@@@..
    0x2f, 0x40, 0x7b, 0xe0,  //.%@@+...+@%@@%.
    0x3f, 0x00, 0xe3, 0xf0,  //.@@@....@%.@@@.
    0x3f, 0x03, 0x83, 0xf0,  //.@@@...@%..@@@.
    0x3f, 0x0f, 0x03, 0xf0,  //.@@@..@@...@@@.
    0x3f, 0x2c, 0x03, 0xf0,  //.@@@.%@....@@@.
    0x2f, 0xb4, 0x07, 0xe0,  //.%@@%@+...+@@%.
    0x0f, 0xe0, 0x0f, 0xd0,  //..@@@%....@@@+.
    0x0b, 0xe0, 0x2f, 0xc0,  //..%@@%...%@@@..
    0x0f, 0xff, 0xff, 0x00,  //..@@@@@@@@@@...
    0x3c, 0x2f, 0xf4, 0x00,  //.@@..%@@@@+....
    0x20, 0x00, 0x00, 0x00,  //.%.............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00f9 (ù) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x0b, 0xc0, 0x00,  //..%@@.......
    0x03, 0xe0, 0x00,  //...%@%......
    0x00, 0xf0, 0x00,  //....@@......
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x1e, 0x00,  //.....+@%....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x7f,  //@@@.....+@@@
    0xbd, 0x00, 0xff,  //%@@+....@@@@
    0x7f, 0x42, 0xbf,  //+@@@+..%%@@@
    0x2f, 0xff, 0x3f,  //.%@@@@@@.@@@
    0x07, 0xf8, 0x3f,  //..+@@@%..@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00fa (ú) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0xf8,  //........@@%.
    0x00, 0x02, 0xf0,  //.......%@%..
    0x00, 0x07, 0xc0,  //.......@@...
    0x00, 0x0f, 0x00,  //......@@....
    0x00, 0x2d, 0x00,  //.....%@+....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x7f,  //@@@.....+@@@
    0xbd, 0x00, 0xff,  //%@@+....@@@@
    0x7f, 0x42, 0xbf,  //+@@@+..%%@@@
    0x2f, 0xff, 0x3f,  //.%@@@@@@.@@@
    0x07, 0xf8, 0x3f,  //..+@@@%..@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00fb (û) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0xff, 0x00,  //....@@@@....
    0x01, 0xd7, 0x40,  //...+@++@+...
    0x03, 0xc3, 0xc0,  //...@@..@@...
    0x0b, 0x00, 0xe0,  //..%@....@%..
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x7f,  //@@@.....+@@@
    0xbd, 0x00, 0xff,  //%@@+....@@@@
    0x7f, 0x42, 0xbf,  //+@@@+..%%@@@
    0x2f, 0xff, 0x3f,  //.%@@@@@@.@@@
    0x07, 0xf8, 0x3f,  //..+@@@%..@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00fc (ü) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x0f, 0xc3, 0xf0,  //..@@@..@@@..
    0x0f, 0xc3, 0xf0,  //..@@@..@@@..
    0x0f, 0xc3, 0xf0,  //..@@@..@@@..
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x7f,  //@@@.....+@@@
    0xbd, 0x00, 0xff,  //%@@+....@@@@
    0x7f, 0x42, 0xbf,  //+@@@+..%%@@@
    0x2f, 0xff, 0x3f,  //.%@@@@@@.@@@
    0x07, 0xf8, 0x3f,  //..+@@@%..@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00fd (ý) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0xf8, 0x00,  //........@@%...
    0x00, 0x02, 0xf0, 0x00,  //.......%@%....
    0x00, 0x07, 0xc0, 0x00,  //.......@@.....
    0x00, 0x0f, 0x00, 0x00,  //......@@......
    0x00, 0x2d, 0x00, 0x00,  //.....%@+......
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xfd, 0x00, 0x07, 0xf0,  //@@@+......+@@@
    0x7f, 0x00, 0x0f, 0xd0,  //+@@@......@@@+
    0x3f, 0x40, 0x1f, 0xc0,  //.@@@+....+@@@.
    0x2f, 0x80, 0x3f, 0x40,  //.%@@%....@@@+.
    0x0f, 0xc0, 0x3f, 0x00,  //..@@@....@@@..
    0x0b, 0xd0, 0xbe, 0x00,  //..%@@+..%@@%..
    0x07, 0xf0, 0xfc, 0x00,  //..+@@@..@@@...
    0x03, 0xf6, 0xfc, 0x00,  //...@@@++@@%...
    0x02, 0xfb, 0xf4, 0x00,  //...+@@%@@@+...
    0x00, 0xff, 0xf0, 0x00,  //....@@@@@@....
    0x00, 0xbf, 0xd0, 0x00,  //....%@@@@+....
    0x00, 0x7f, 0xc0, 0x00,  //....+@@@@.....
    0x00, 0x3f, 0x80, 0x00,  //.....@@@%.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@......
    0x00, 0xbe, 0x00, 0x00,  //....%@@%......
    0x00, 0xfd, 0x00, 0x00,  //....@@@+......
    0x02, 0xfc, 0x00, 0x00,  //...%@@@.......
    0x3f, 0xf0, 0x00, 0x00,  //.@@@@@........
    0x3f, 0x80, 0x00, 0x00,  //.@@@%.........
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00fe (þ) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x2f, 0xe0, 0x00,  //@@@..%@@@%...
    0xfc, 0xff, 0xfc, 0x00,  //@@@.@@@@@@@..
    0xfe, 0x80, 0xbf, 0x00,  //@@@%%...%@@@.
    0xff, 0x00, 0x3f, 0x40,  //@@@@.....@@@+
    0xfd, 0x00, 0x1f, 0x80,  //@@@+.....+@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfd, 0x00, 0x1f, 0x80,  //@@@+.....+@@%
    0xff, 0x00, 0x3f, 0x40,  //@@@@.....@@@+
    0xfe, 0x80, 0xbf, 0x00,  //@@@%%...%@@@.
    0xfc, 0xff, 0xfc, 0x00,  //@@@.@@@@@@@..
    0xfc, 0x2f, 0xe0, 0x00,  //@@@..%@@@%...
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00ff (ÿ) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x03, 0xf3, 0xf0, 0x00,  //...@@@.@@@....
    0x03, 0xf3, 0xf0, 0x00,  //...@@@.@@@....
    0x03, 0xf3, 0xf0, 0x00,  //...@@@.@@@....
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xfd, 0x00, 0x07, 0xf0,  //@@@+......+@@@
    0x7f, 0x00, 0x0f, 0xd0,  //+@@@......@@@+
    0x3f, 0x40, 0x1f, 0xc0,  //.@@@+....+@@@.
    0x2f, 0x80, 0x3f, 0x40,  //.%@@%....@@@+.
    0x0f, 0xc0, 0x3f, 0x00,  //..@@@....@@@..
    0x0b, 0xd0, 0xbe, 0x00,  //..%@@+..%@@%..
    0x07, 0xf0, 0xfc, 0x00,  //..+@@@..@@@...
    0x03, 0xf6, 0xfc, 0x00,  //...@@@++@@%...
    0x02, 0xfb, 0xf4, 0x00,  //...+@@%@@@+...
    0x00, 0xff, 0xf0, 0x00,  //....@@@@@@....
    0x00, 0xbf, 0xd0, 0x00,  //....%@@@@+....
    0x00, 0x7f, 0xc0, 0x00,  //....+@@@@.....
    0x00, 0x3f, 0x80, 0x00,  //.....@@@%.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@......
    0x00, 0xbe, 0x00, 0x00,  //....%@@%......
    0x00, 0xfd, 0x00, 0x00,  //....@@@+......
    0x02, 0xfc, 0x00, 0x00,  //...%@@@.......
    0x3f, 0xf0, 0x00, 0x00,  //.@@@@@........
    0x3f, 0x80, 0x00, 0x00,  //.@@@%.........
    0x00, 0x00, 0x00, 0x00,  //..............



#elif USE_LV_FONT_DEJAVU_30_LATIN_SUP == 4
    /*Unicode: U+00a0 ( ) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00a1 (¡) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xbf, 0xb0,  //%@%
    0xcf, 0xc0,  //@@@
    0xdf, 0xd0,  //@@@
    0xef, 0xe0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...


    /*Unicode: U+00a2 (¢) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0xf0, 0x00, 0x00,  //......@....
    0x00, 0x00, 0x00, 0xf0, 0x00, 0x00,  //......@....
    0x00, 0x00, 0x00, 0xf0, 0x00, 0x00,  //......@....
    0x00, 0x00, 0x00, 0xf0, 0x00, 0x00,  //......@....
    0x00, 0x05, 0xbe, 0xfe, 0xc8, 0x20,  //...+%@@@@%.
    0x00, 0xbf, 0xff, 0xff, 0xff, 0xf0,  //..%@@@@@@@@
    0x0b, 0xff, 0xb2, 0xf1, 0x37, 0xc0,  //.%@@%.@..+@
    0x4f, 0xfd, 0x00, 0xf0, 0x00, 0x00,  //+@@@..@....
    0xaf, 0xf6, 0x00, 0xf0, 0x00, 0x00,  //%@@+..@....
    0xdf, 0xf2, 0x00, 0xf0, 0x00, 0x00,  //@@@...@....
    0xff, 0xf0, 0x00, 0xf0, 0x00, 0x00,  //@@@...@....
    0xff, 0xf0, 0x00, 0xf0, 0x00, 0x00,  //@@@...@....
    0xef, 0xf2, 0x00, 0xf0, 0x00, 0x00,  //@@@...@....
    0xaf, 0xf6, 0x00, 0xf0, 0x00, 0x00,  //%@@+..@....
    0x4f, 0xfd, 0x00, 0xf0, 0x00, 0x00,  //+@@@..@....
    0x0b, 0xff, 0xb2, 0xf1, 0x37, 0xd0,  //.%@@%.@..+@
    0x00, 0xcf, 0xff, 0xff, 0xff, 0xf0,  //..%@@@@@@@@
    0x00, 0x05, 0xbe, 0xff, 0xc8, 0x20,  //...+%@@@@%.
    0x00, 0x00, 0x00, 0xf0, 0x00, 0x00,  //......@....
    0x00, 0x00, 0x00, 0xf0, 0x00, 0x00,  //......@....
    0x00, 0x00, 0x00, 0xf0, 0x00, 0x00,  //......@....
    0x00, 0x00, 0x00, 0xf0, 0x00, 0x00,  //......@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00a3 (£) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x03, 0xad, 0xff, 0xc8, 0x20,  //......%@@@@%.
    0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xf0,  //....+@@@@@@@@
    0x00, 0x03, 0xff, 0xf6, 0x10, 0x16, 0xc0,  //....@@@+...+@
    0x00, 0x0a, 0xff, 0x70, 0x00, 0x00, 0x00,  //...%@@+......
    0x00, 0x0d, 0xff, 0x20, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //@@@@@@@@@@@..
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00a4 (¤) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x0a, 0x30, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x00,  //.%...........%.
    0xaf, 0xe2, 0x00, 0x00, 0x00, 0x02, 0xef, 0xb0,  //%@@.........@@%
    0x3e, 0xfe, 0x39, 0xdf, 0xd9, 0x3e, 0xfe, 0x30,  //.@@@.%@@@%.@@@.
    0x02, 0xef, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x00,  //..@@@@@@@@@@@..
    0x00, 0x3f, 0xfa, 0x20, 0x2a, 0xff, 0x30, 0x00,  //...@@%...%@@...
    0x00, 0x8f, 0xa0, 0x00, 0x00, 0xaf, 0x90, 0x00,  //..%@%.....%@%..
    0x00, 0xdf, 0x20, 0x00, 0x00, 0x2f, 0xd0, 0x00,  //..@@.......@@..
    0x00, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //..@@.......@@..
    0x00, 0xdf, 0x20, 0x00, 0x00, 0x2f, 0xd0, 0x00,  //..@@.......@@..
    0x00, 0x8f, 0xa0, 0x00, 0x00, 0xaf, 0x90, 0x00,  //..%@%.....%@%..
    0x00, 0x3f, 0xfa, 0x20, 0x2a, 0xff, 0x30, 0x00,  //...@@%...%@@...
    0x02, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00,  //..@@@@@@@@@@@..
    0x3e, 0xfe, 0x38, 0xdf, 0xd9, 0x3d, 0xfe, 0x30,  //.@@@.%@@@%.@@@.
    0xbf, 0xe2, 0x00, 0x00, 0x00, 0x02, 0xef, 0xa0,  //%@@.........@@%
    0x0b, 0x30, 0x00, 0x00, 0x00, 0x00, 0x39, 0x00,  //.%...........%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00a5 (¥) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xbf, 0xfa, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xb0,  //%@@%.......%@@%
    0x2f, 0xff, 0x30, 0x00, 0x00, 0x3f, 0xff, 0x20,  //.@@@.......@@@.
    0x08, 0xff, 0xb0, 0x00, 0x00, 0xbf, 0xf7, 0x00,  //.%@@%.....%@@+.
    0x00, 0xdf, 0xf4, 0x00, 0x04, 0xff, 0xd0, 0x00,  //..@@@+...+@@@..
    0x00, 0x5f, 0xfc, 0x00, 0x0c, 0xff, 0x40, 0x00,  //..+@@@...@@@+..
    0x00, 0x0b, 0xff, 0x50, 0x5f, 0xfb, 0x00, 0x00,  //...%@@+.+@@%...
    0x00, 0x02, 0xff, 0xd0, 0xdf, 0xf2, 0x00, 0x00,  //....@@@.@@@....
    0x0f, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@%@@@@@@.
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@.
    0x00, 0x00, 0x0c, 0xff, 0xfc, 0x00, 0x00, 0x00,  //.....@@@@@.....
    0x00, 0x00, 0x05, 0xff, 0xf4, 0x00, 0x00, 0x00,  //.....+@@@+.....
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@.
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00a6 (¦) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00a7 (§) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x18, 0xdf, 0xfd, 0x93, 0x00,  //...%@@@@%..
    0x03, 0xff, 0xff, 0xff, 0xff, 0x00,  //..@@@@@@@@.
    0x0c, 0xfb, 0x30, 0x03, 0x7c, 0x00,  //.@@%....+@.
    0x0f, 0xf1, 0x00, 0x00, 0x00, 0x00,  //.@@........
    0x0e, 0xf5, 0x00, 0x00, 0x00, 0x00,  //.@@+.......
    0x08, 0xff, 0x81, 0x00, 0x00, 0x00,  //.+@@%......
    0x01, 0xff, 0xfe, 0x80, 0x00, 0x00,  //..@@@@%....
    0x2e, 0xf6, 0xbf, 0xfe, 0x60, 0x00,  //.@@+%@@@+..
    0xbf, 0x50, 0x03, 0xbf, 0xfa, 0x00,  //%@+...%@@%.
    0xff, 0x00, 0x00, 0x05, 0xff, 0x80,  //@@.....+@@%
    0xdf, 0x70, 0x00, 0x00, 0x4f, 0xe0,  //@@+.....+@@
    0x6f, 0xf8, 0x00, 0x00, 0x0f, 0xe0,  //+@@%.....@@
    0x07, 0xff, 0xe7, 0x00, 0x7f, 0x90,  //.+@@@+..+@%
    0x00, 0x2b, 0xff, 0xea, 0xfc, 0x00,  //...%@@@%@@.
    0x00, 0x00, 0x4c, 0xff, 0xe1, 0x00,  //....+@@@@..
    0x00, 0x00, 0x00, 0x5e, 0xf9, 0x00,  //......+@@%.
    0x00, 0x00, 0x00, 0x03, 0xfe, 0x00,  //........@@.
    0x00, 0x00, 0x00, 0x01, 0xff, 0x00,  //........@@.
    0x0c, 0x73, 0x00, 0x3c, 0xfb, 0x00,  //.@+....%@%.
    0x0f, 0xff, 0xff, 0xff, 0xe2, 0x00,  //.@@@@@@@@..
    0x03, 0x8d, 0xff, 0xd9, 0x10, 0x00,  //..%@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00a8 (¨) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xf0, 0x0f, 0xff,  //@@@..@@@
    0xff, 0xf0, 0x0f, 0xff,  //@@@..@@@
    0xff, 0xf0, 0x0f, 0xff,  //@@@..@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00a9 (©) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x01, 0x7c, 0xef, 0xec, 0x71, 0x00, 0x00, 0x00,  //......+@@@@@+......
    0x00, 0x00, 0x8e, 0x84, 0x10, 0x13, 0x8e, 0x80, 0x00, 0x00,  //....%@%.....%@%....
    0x00, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x01, 0xac, 0x10, 0x00,  //...@%.........%@...
    0x00, 0xc9, 0x00, 0x07, 0xce, 0xfd, 0x93, 0x08, 0xc0, 0x00,  //..@%...+@@@@%..%@..
    0x08, 0xb0, 0x02, 0xde, 0x61, 0x01, 0x5c, 0x00, 0xa8, 0x00,  //.%%...@@+...+%..%%.
    0x2e, 0x10, 0x0d, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x10,  //.@...@@..........@.
    0x79, 0x00, 0x6f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x08, 0x70,  //+%..+@%..........%+
    0xc4, 0x00, 0xcf, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0xc0,  //@+..%@............@
    0xe1, 0x00, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0,  //@...@@............@
    0xf0, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0,  //@...@@............@
    0xe1, 0x00, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0,  //@...@@............@
    0xc4, 0x00, 0xbf, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0xc0,  //@+..%@............@
    0x89, 0x00, 0x6f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x08, 0x70,  //+%..+@%..........%+
    0x2e, 0x10, 0x0d, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x10,  //.@...@@..........@.
    0x08, 0xb0, 0x02, 0xde, 0x61, 0x02, 0x5b, 0x00, 0xa8, 0x00,  //.%%...@@+...+%..%%.
    0x00, 0xc9, 0x00, 0x07, 0xce, 0xfd, 0xa3, 0x08, 0xc0, 0x00,  //..@%...+@@@@%..%@..
    0x00, 0x1c, 0xb1, 0x00, 0x00, 0x00, 0x01, 0xac, 0x10, 0x00,  //...@%.........%@...
    0x00, 0x00, 0x8e, 0x84, 0x10, 0x13, 0x8e, 0x80, 0x00, 0x00,  //....%@%.....%@%....
    0x00, 0x00, 0x01, 0x7c, 0xef, 0xec, 0x71, 0x00, 0x00, 0x00,  //......+@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00aa (ª) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x03, 0x9d, 0xff, 0xea, 0x40, 0x00,  //..%@@@@%+..
    0x0c, 0x62, 0x01, 0x4c, 0xf5, 0x00,  //.@+....@@+.
    0x00, 0x00, 0x00, 0x01, 0xfd, 0x00,  //........@@.
    0x02, 0x9d, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@.
    0x4f, 0xe5, 0x10, 0x00, 0xff, 0x00,  //.@@+....@@.
    0xcf, 0x30, 0x00, 0x02, 0xff, 0x00,  //@@......@@.
    0xff, 0x00, 0x00, 0x05, 0xff, 0x00,  //@@.....+@@.
    0xef, 0x30, 0x00, 0x0d, 0xff, 0x00,  //@@.....@@@.
    0x6f, 0xd3, 0x02, 0xbf, 0xff, 0x00,  //+@@...%@@@.
    0x05, 0xce, 0xfd, 0x92, 0xff, 0x00,  //.+@@@@%.@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x9f, 0xff, 0xff, 0xff, 0xff, 0x00,  //%@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00ab («) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x08, 0x00, 0x00, 0x08,  //.....%.....%
    0x00, 0x00, 0x9f, 0x00, 0x00, 0x9f,  //....%@....%@
    0x00, 0x0b, 0xff, 0x00, 0x0b, 0xff,  //...%@@...%@@
    0x01, 0xcf, 0xe3, 0x01, 0xcf, 0xe3,  //..@@@...@@@.
    0x1d, 0xfd, 0x20, 0x1d, 0xfd, 0x20,  //.@@@...@@@..
    0xef, 0xc1, 0x00, 0xef, 0xd1, 0x00,  //@@@...@@@...
    0xef, 0xd1, 0x00, 0xef, 0xd1, 0x00,  //@@@...@@@...
    0x1d, 0xfe, 0x20, 0x1d, 0xfd, 0x20,  //.@@@...@@@..
    0x01, 0xcf, 0xe3, 0x01, 0xcf, 0xe3,  //..@@@...@@@.
    0x00, 0x0b, 0xff, 0x00, 0x0b, 0xff,  //...%@@...%@@
    0x00, 0x00, 0xaf, 0x00, 0x00, 0xaf,  //....%@....%@
    0x00, 0x00, 0x08, 0x00, 0x00, 0x08,  //.....%.....%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00ac (¬) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00ad (­) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00ae (®) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x01, 0x7c, 0xef, 0xec, 0x71, 0x00, 0x00, 0x00,  //......+@@@@@+......
    0x00, 0x00, 0x8e, 0x84, 0x10, 0x13, 0x8e, 0x80, 0x00, 0x00,  //....%@%.....%@%....
    0x00, 0x1c, 0xa1, 0x00, 0x00, 0x00, 0x01, 0xac, 0x10, 0x00,  //...@%.........%@...
    0x00, 0xc9, 0x0f, 0xff, 0xff, 0xeb, 0x50, 0x08, 0xc0, 0x00,  //..@%.@@@@@@%+..%@..
    0x08, 0xb0, 0x0f, 0xf0, 0x00, 0x2a, 0xf8, 0x00, 0xa8, 0x00,  //.%%..@@....%@%..%%.
    0x2e, 0x10, 0x0f, 0xf0, 0x00, 0x01, 0xfe, 0x00, 0x1e, 0x10,  //.@...@@.....@@...@.
    0x79, 0x00, 0x0f, 0xf0, 0x00, 0x01, 0xfe, 0x00, 0x08, 0x70,  //+%...@@.....@@...%+
    0xc4, 0x00, 0x0f, 0xf0, 0x00, 0x2a, 0xf8, 0x00, 0x04, 0xc0,  //@+...@@....%@%....@
    0xe1, 0x00, 0x0f, 0xff, 0xff, 0xfd, 0x50, 0x00, 0x01, 0xe0,  //@....@@@@@@@+.....@
    0xf0, 0x00, 0x0f, 0xf0, 0x19, 0xfe, 0x10, 0x00, 0x00, 0xf0,  //@....@@..%@@......@
    0xe1, 0x00, 0x0f, 0xf0, 0x00, 0xcf, 0xa0, 0x00, 0x01, 0xe0,  //@....@@...@@%.....@
    0xc4, 0x00, 0x0f, 0xf0, 0x00, 0x4f, 0xf2, 0x00, 0x04, 0xc0,  //@+...@@...+@@.....@
    0x89, 0x00, 0x0f, 0xf0, 0x00, 0x0c, 0xf8, 0x00, 0x08, 0x70,  //+%...@@....@@%...%+
    0x2e, 0x10, 0x0f, 0xf0, 0x00, 0x06, 0xfe, 0x00, 0x1e, 0x10,  //.@...@@....+@@...@.
    0x08, 0xb0, 0x0f, 0xf0, 0x00, 0x00, 0xef, 0x60, 0xa8, 0x00,  //.%%..@@.....@@+.%%.
    0x00, 0xc9, 0x0f, 0xf0, 0x00, 0x00, 0x8f, 0xc8, 0xc0, 0x00,  //..@%.@@.....%@@%@..
    0x00, 0x1c, 0xb1, 0x00, 0x00, 0x00, 0x01, 0xac, 0x10, 0x00,  //...@%.........%@...
    0x00, 0x00, 0x8e, 0x84, 0x10, 0x13, 0x8e, 0x80, 0x00, 0x00,  //....%@%.....%@%....
    0x00, 0x00, 0x01, 0x7c, 0xef, 0xec, 0x71, 0x00, 0x00, 0x00,  //......+@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00af (¯) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00b0 (°) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x02, 0xbf, 0xfa, 0x20,  //..%@@%..
    0x2e, 0xff, 0xff, 0xe2,  //.@@@@@@.
    0xbf, 0xb1, 0x1b, 0xfa,  //%@%..%@%
    0xff, 0x10, 0x01, 0xff,  //@@....@@
    0xff, 0x10, 0x01, 0xff,  //@@....@@
    0xbf, 0xb1, 0x1b, 0xfb,  //%@%..%@%
    0x3f, 0xff, 0xff, 0xe2,  //.@@@@@@.
    0x03, 0xbf, 0xfb, 0x20,  //..%@@%..
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00b1 (±) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00b2 (²) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x39, 0xdf, 0xeb, 0x40,  //.%@@@%..
    0xc5, 0x10, 0x3c, 0xf6,  //@+...@@+
    0x00, 0x00, 0x02, 0xfe,  //......@@
    0x00, 0x00, 0x01, 0xfe,  //......@@
    0x00, 0x00, 0x0a, 0xfa,  //.....%@%
    0x00, 0x00, 0x6f, 0xf1,  //....+@@.
    0x00, 0x05, 0xff, 0x50,  //...+@@+.
    0x00, 0x5f, 0xf7, 0x00,  //..+@@+..
    0x06, 0xff, 0x70, 0x00,  //.+@@+...
    0x6f, 0xf4, 0x00, 0x00,  //+@@+....
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00b3 (³) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x29, 0xdf, 0xec, 0x70,  //.%@@@@+.
    0xc5, 0x10, 0x29, 0xfb,  //@+...%@%
    0x00, 0x00, 0x01, 0xff,  //......@@
    0x00, 0x00, 0x29, 0xf8,  //.....%@%
    0x00, 0xff, 0xff, 0x60,  //..@@@@+.
    0x00, 0x00, 0x3d, 0xf5,  //.....@@+
    0x00, 0x00, 0x03, 0xfd,  //......@@
    0x00, 0x00, 0x00, 0xff,  //......@@
    0x00, 0x00, 0x03, 0xfd,  //......@@
    0xa3, 0x10, 0x4d, 0xf4,  //%...+@@+
    0x3a, 0xef, 0xea, 0x30,  //.%@@@%..
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00b4 (´) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x0d, 0xf9,  //...@@%
    0x00, 0x8f, 0xc0,  //..%@%.
    0x04, 0xfd, 0x10,  //..@@..
    0x0e, 0xf2, 0x00,  //.@@...
    0xaf, 0x50, 0x00,  //%@+...
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+00b5 (µ) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf1, 0x00, 0x00, 0x2f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf5, 0x00, 0x00, 0x8f, 0xff, 0x00,  //@@@+....%@@@..
    0xff, 0xfe, 0x50, 0x17, 0xff, 0xff, 0x30,  //@@@@+..+@@@@..
    0xff, 0xfb, 0xff, 0xff, 0xca, 0xff, 0xff,  //@@@%@@@@@%@@@@
    0xff, 0xf0, 0xae, 0xfa, 0x11, 0xbf, 0xe9,  //@@@.%@@%..%@@%
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00b6 (¶) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x17, 0xce, 0xff, 0xff, 0xff,  //...+@@@@@@@@
    0x03, 0xef, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@@
    0x1f, 0xff, 0xff, 0xff, 0x00, 0xff,  //.@@@@@@@..@@
    0x9f, 0xff, 0xff, 0xff, 0x00, 0xff,  //%@@@@@@@..@@
    0xef, 0xff, 0xff, 0xff, 0x00, 0xff,  //@@@@@@@@..@@
    0xff, 0xff, 0xff, 0xff, 0x00, 0xff,  //@@@@@@@@..@@
    0xef, 0xff, 0xff, 0xff, 0x00, 0xff,  //@@@@@@@@..@@
    0xaf, 0xff, 0xff, 0xff, 0x00, 0xff,  //%@@@@@@@..@@
    0x3f, 0xff, 0xff, 0xff, 0x00, 0xff,  //.@@@@@@@..@@
    0x06, 0xff, 0xff, 0xff, 0x00, 0xff,  //.+@@@@@@..@@
    0x00, 0x3a, 0xff, 0xff, 0x00, 0xff,  //...%@@@@..@@
    0x00, 0x00, 0x02, 0xff, 0x00, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0xff, 0x00, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0xff, 0x00, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0xff, 0x00, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0xff, 0x00, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0xff, 0x00, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0xff, 0x00, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0xff, 0x00, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0xff, 0x00, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0xff, 0x00, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0xff, 0x00, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00b7 (·) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+00b8 (¸) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0xaf, 0x40,  //..%@+
    0x00, 0x1f, 0xb0,  //...@%
    0x00, 0x3f, 0xf0,  //...@@
    0xff, 0xff, 0xd0,  //@@@@@
    0xcf, 0xfc, 0x30,  //%@@@.
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00b9 (¹) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x27, 0xcf, 0xf0, 0x00,  //.+@@@...
    0xd7, 0x2f, 0xf0, 0x00,  //@+.@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00ba (º) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x7c, 0xff, 0xc7, 0x00,  //..+@@@@+..
    0x0b, 0xf7, 0x11, 0x7f, 0xb0,  //.%@+..+@%.
    0x7f, 0x90, 0x00, 0x09, 0xf7,  //+@%....%@+
    0xcf, 0x30, 0x00, 0x03, 0xfc,  //@@......@@
    0xff, 0x00, 0x00, 0x01, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xdf, 0x30, 0x00, 0x03, 0xfc,  //@@......@@
    0x7f, 0x90, 0x00, 0x09, 0xf7,  //+@%....%@+
    0x0b, 0xf7, 0x10, 0x7f, 0xb0,  //.%@+..+@%.
    0x00, 0x7c, 0xff, 0xd7, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x7f, 0xff, 0xff, 0xff, 0xf7,  //+@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00bb (») , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x80, 0x00, 0x00, 0x80, 0x00, 0x00,  //%.....%.....
    0xf9, 0x00, 0x00, 0xf9, 0x00, 0x00,  //@%....@%....
    0xff, 0xb0, 0x00, 0xff, 0xb0, 0x00,  //@@%...@@%...
    0x3e, 0xfc, 0x10, 0x3e, 0xfc, 0x10,  //.@@@...@@@..
    0x02, 0xdf, 0xd1, 0x02, 0xdf, 0xd1,  //..@@@...@@@.
    0x00, 0x1d, 0xfe, 0x00, 0x1c, 0xfe,  //...@@@...@@@
    0x00, 0x1d, 0xfe, 0x00, 0x1d, 0xfe,  //...@@@...@@@
    0x02, 0xdf, 0xd1, 0x02, 0xef, 0xd1,  //..@@@...@@@.
    0x3e, 0xfc, 0x10, 0x3e, 0xfc, 0x10,  //.@@@...@@@..
    0xff, 0xb0, 0x00, 0xff, 0xb0, 0x00,  //@@%...@@%...
    0xf9, 0x00, 0x00, 0xf9, 0x00, 0x00,  //@%....@%....
    0x80, 0x00, 0x00, 0x80, 0x00, 0x00,  //%.....%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00bc (¼) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x27, 0xcf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xb0, 0x00, 0x00, 0x00,  //.+@@@.........%@%......
    0xd7, 0x2f, 0xf0, 0x00, 0x00, 0x00, 0x04, 0xff, 0x10, 0x00, 0x00, 0x00,  //@+.@@........+@@.......
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x0d, 0xf7, 0x00, 0x00, 0x00, 0x00,  //...@@........@@+.......
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x7f, 0xd0, 0x00, 0x00, 0x00, 0x00,  //...@@.......+@@........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x02, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00,  //...@@.......@@.........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x0b, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@......%@%.........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x5f, 0xe1, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.....+@@..........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0xef, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.....@@+..........
    0x00, 0x0f, 0xf0, 0x00, 0x08, 0xfc, 0x00, 0x00, 0x00, 0x7f, 0xf0, 0x00,  //...@@....%@@......+@@..
    0x00, 0x0f, 0xf0, 0x00, 0x2f, 0xf3, 0x00, 0x00, 0x03, 0xef, 0xf0, 0x00,  //...@@....@@.......@@@..
    0xff, 0xff, 0xff, 0xff, 0xcf, 0x80, 0x00, 0x00, 0x1e, 0x5f, 0xf0, 0x00,  //@@@@@@@@@@%......@+@@..
    0x00, 0x00, 0x00, 0x06, 0xfe, 0x00, 0x00, 0x00, 0xba, 0x0f, 0xf0, 0x00,  //.......+@@......%%.@@..
    0x00, 0x00, 0x00, 0x1e, 0xf5, 0x00, 0x00, 0x07, 0xe1, 0x0f, 0xf0, 0x00,  //.......@@+.....+@..@@..
    0x00, 0x00, 0x00, 0x9f, 0xb0, 0x00, 0x00, 0x3f, 0x40, 0x0f, 0xf0, 0x00,  //......%@%......@+..@@..
    0x00, 0x00, 0x03, 0xff, 0x20, 0x00, 0x00, 0xe9, 0x00, 0x0f, 0xf0, 0x00,  //......@@......@%...@@..
    0x00, 0x00, 0x0d, 0xf7, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.....@@+......@@@@@@@@@
    0x00, 0x00, 0x7f, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //....+@@............@@..
    0x00, 0x01, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //....@@+............@@..
    0x00, 0x0b, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //...%@%.............@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00bd (½) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x27, 0xcf, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xaf, 0xb0, 0x00, 0x00,  //.+@@@.........%@%.....
    0xd7, 0x2f, 0xf0, 0x00, 0x00, 0x00, 0x04, 0xff, 0x10, 0x00, 0x00,  //@+.@@........+@@......
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x0d, 0xf7, 0x00, 0x00, 0x00,  //...@@........@@+......
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x7f, 0xd0, 0x00, 0x00, 0x00,  //...@@.......+@@.......
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x02, 0xff, 0x30, 0x00, 0x00, 0x00,  //...@@.......@@........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x0b, 0xf9, 0x00, 0x00, 0x00, 0x00,  //...@@......%@%........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x5f, 0xe1, 0x00, 0x00, 0x00, 0x00,  //...@@.....+@@.........
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0xef, 0x60, 0x00, 0x00, 0x00, 0x00,  //...@@.....@@+.........
    0x00, 0x0f, 0xf0, 0x00, 0x08, 0xfc, 0x00, 0x39, 0xdf, 0xeb, 0x40,  //...@@....%@@...%@@@%..
    0x00, 0x0f, 0xf0, 0x00, 0x2f, 0xf3, 0x00, 0xc5, 0x10, 0x3c, 0xf6,  //...@@....@@...@+...@@+
    0xff, 0xff, 0xff, 0xff, 0xcf, 0x80, 0x00, 0x00, 0x00, 0x02, 0xfe,  //@@@@@@@@@@%.........@@
    0x00, 0x00, 0x00, 0x06, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x01, 0xfe,  //.......+@@..........@@
    0x00, 0x00, 0x00, 0x1e, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xfa,  //.......@@+.........%@%
    0x00, 0x00, 0x00, 0x9f, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf1,  //......%@%.........+@@.
    0x00, 0x00, 0x03, 0xff, 0x20, 0x00, 0x00, 0x00, 0x05, 0xff, 0x50,  //......@@.........+@@+.
    0x00, 0x00, 0x0d, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xf7, 0x00,  //.....@@+........+@@+..
    0x00, 0x00, 0x7f, 0xd0, 0x00, 0x00, 0x00, 0x06, 0xff, 0x70, 0x00,  //....+@@........+@@+...
    0x00, 0x01, 0xff, 0x40, 0x00, 0x00, 0x00, 0x6f, 0xf4, 0x00, 0x00,  //....@@+.......+@@+....
    0x00, 0x0b, 0xfa, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,  //...%@%........@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+00be (¾) , Width: 24 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x29, 0xdf, 0xec, 0x70, 0x00, 0x00, 0x00, 0x0a, 0xfb, 0x00, 0x00, 0x00,  //.%@@@@+........%@%......
    0xc5, 0x10, 0x29, 0xfb, 0x00, 0x00, 0x00, 0x4f, 0xf1, 0x00, 0x00, 0x00,  //@+...%@%......+@@.......
    0x00, 0x00, 0x01, 0xff, 0x00, 0x00, 0x00, 0xdf, 0x70, 0x00, 0x00, 0x00,  //......@@......@@+.......
    0x00, 0x00, 0x29, 0xf8, 0x00, 0x00, 0x07, 0xfd, 0x00, 0x00, 0x00, 0x00,  //.....%@%.....+@@........
    0x00, 0xff, 0xff, 0x60, 0x00, 0x00, 0x2f, 0xf3, 0x00, 0x00, 0x00, 0x00,  //..@@@@+......@@.........
    0x00, 0x00, 0x3d, 0xf5, 0x00, 0x00, 0xbf, 0x90, 0x00, 0x00, 0x00, 0x00,  //.....@@+....%@%.........
    0x00, 0x00, 0x03, 0xfd, 0x00, 0x05, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00,  //......@@...+@@..........
    0x00, 0x00, 0x00, 0xff, 0x00, 0x0e, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@...@@+..........
    0x00, 0x00, 0x03, 0xfd, 0x00, 0x8f, 0xc0, 0x00, 0x00, 0x07, 0xff, 0x00,  //......@@..%@@......+@@..
    0xa3, 0x10, 0x4d, 0xf4, 0x02, 0xff, 0x30, 0x00, 0x00, 0x3e, 0xff, 0x00,  //%...+@@+..@@.......@@@..
    0x3a, 0xef, 0xea, 0x30, 0x0c, 0xf8, 0x00, 0x00, 0x01, 0xe5, 0xff, 0x00,  //.%@@@%...@@%......@+@@..
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xe0, 0x00, 0x00, 0x0b, 0xa0, 0xff, 0x00,  //........+@@......%%.@@..
    0x00, 0x00, 0x00, 0x01, 0xef, 0x50, 0x00, 0x00, 0x7e, 0x10, 0xff, 0x00,  //........@@+.....+@..@@..
    0x00, 0x00, 0x00, 0x09, 0xfb, 0x00, 0x00, 0x03, 0xf4, 0x00, 0xff, 0x00,  //.......%@%......@+..@@..
    0x00, 0x00, 0x00, 0x3f, 0xf2, 0x00, 0x00, 0x0e, 0x90, 0x00, 0xff, 0x00,  //.......@@......@%...@@..
    0x00, 0x00, 0x00, 0xdf, 0x70, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff,  //......@@+......@@@@@@@@@
    0x00, 0x00, 0x07, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,  //.....+@@............@@..
    0x00, 0x00, 0x1f, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,  //.....@@+............@@..
    0x00, 0x00, 0xbf, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,  //....%@%.............@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................


    /*Unicode: U+00bf (¿) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0xff, 0xf0, 0x00,  //....@@@...
    0x00, 0x00, 0xff, 0xf0, 0x00,  //....@@@...
    0x00, 0x00, 0xff, 0xf0, 0x00,  //....@@@...
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0xff, 0xf0, 0x00,  //....@@@...
    0x00, 0x00, 0xff, 0xf0, 0x00,  //....@@@...
    0x00, 0x00, 0xff, 0xe0, 0x00,  //....@@@...
    0x00, 0x02, 0xff, 0xb0, 0x00,  //....@@%...
    0x00, 0x09, 0xfe, 0x20, 0x00,  //...%@@....
    0x00, 0x6f, 0xd2, 0x00, 0x00,  //..+@@.....
    0x07, 0xfe, 0x20, 0x00, 0x00,  //.+@@......
    0x4f, 0xf7, 0x00, 0x00, 0x00,  //+@@+......
    0xcf, 0xf1, 0x00, 0x00, 0x00,  //@@@.......
    0xff, 0xf0, 0x00, 0x00, 0x00,  //@@@.......
    0xef, 0xf4, 0x00, 0x00, 0x09,  //@@@+.....%
    0x8f, 0xfe, 0x40, 0x16, 0xdf,  //%@@@+..+@@
    0x0c, 0xff, 0xff, 0xff, 0xf5,  //.@@@@@@@@+
    0x00, 0x7c, 0xff, 0xd8, 0x10,  //..+@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00c0 (À) , Width: 17 */
    0x00, 0x00, 0x08, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@.........
    0x00, 0x00, 0x00, 0x8f, 0x90, 0x00, 0x00, 0x00, 0x00,  //......%@%........
    0x00, 0x00, 0x00, 0x08, 0xf7, 0x00, 0x00, 0x00, 0x00,  //.......%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x1f, 0xff, 0x10, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x7f, 0xff, 0x70, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0xdf, 0xff, 0xd0, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x03, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x09, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x0e, 0xff, 0x7f, 0xfe, 0x00, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x00, 0x5f, 0xfd, 0x0d, 0xff, 0x50, 0x00, 0x00,  //....+@@@.@@@+....
    0x00, 0x00, 0xbf, 0xf7, 0x07, 0xff, 0xb0, 0x00, 0x00,  //....%@@+.+@@%....
    0x00, 0x01, 0xff, 0xf1, 0x01, 0xff, 0xf1, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x07, 0xff, 0xb0, 0x00, 0xbf, 0xf7, 0x00, 0x00,  //...+@@%...%@@+...
    0x00, 0x0d, 0xff, 0x50, 0x00, 0x5f, 0xfd, 0x00, 0x00,  //...@@@+...+@@@...
    0x00, 0x3f, 0xff, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00,  //...@@@.....@@@...
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //..@@@@@@@@@@@@@..
    0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0xdf, 0xf5, 0x00,  //.+@@@.......@@@+.
    0x0b, 0xff, 0x70, 0x00, 0x00, 0x00, 0x8f, 0xfb, 0x00,  //.%@@+.......+@@%.
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@.........@@@.
    0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@%.........@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c1 (Á) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x1d, 0xf5, 0x00, 0x00, 0x00,  //.........@@+.....
    0x00, 0x00, 0x00, 0x00, 0xbf, 0x60, 0x00, 0x00, 0x00,  //........%@+......
    0x00, 0x00, 0x00, 0x09, 0xf6, 0x00, 0x00, 0x00, 0x00,  //.......%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x1f, 0xff, 0x10, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x7f, 0xff, 0x70, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0xdf, 0xff, 0xd0, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x03, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x09, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x0e, 0xff, 0x7f, 0xfe, 0x00, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x00, 0x5f, 0xfd, 0x0d, 0xff, 0x50, 0x00, 0x00,  //....+@@@.@@@+....
    0x00, 0x00, 0xbf, 0xf7, 0x07, 0xff, 0xb0, 0x00, 0x00,  //....%@@+.+@@%....
    0x00, 0x01, 0xff, 0xf1, 0x01, 0xff, 0xf1, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x07, 0xff, 0xb0, 0x00, 0xbf, 0xf7, 0x00, 0x00,  //...+@@%...%@@+...
    0x00, 0x0d, 0xff, 0x50, 0x00, 0x5f, 0xfd, 0x00, 0x00,  //...@@@+...+@@@...
    0x00, 0x3f, 0xff, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00,  //...@@@.....@@@...
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //..@@@@@@@@@@@@@..
    0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0xdf, 0xf5, 0x00,  //.+@@@.......@@@+.
    0x0b, 0xff, 0x70, 0x00, 0x00, 0x00, 0x8f, 0xfb, 0x00,  //.%@@+.......+@@%.
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@.........@@@.
    0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@%.........@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c2 (Â) , Width: 17 */
    0x00, 0x00, 0x00, 0x1e, 0xfe, 0x10, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0xce, 0x4e, 0xc0, 0x00, 0x00, 0x00,  //......@@+@@......
    0x00, 0x00, 0x09, 0xe2, 0x02, 0xe9, 0x00, 0x00, 0x00,  //.....%@...@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x1f, 0xff, 0x10, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x7f, 0xff, 0x70, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0xdf, 0xff, 0xd0, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x03, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x09, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x0e, 0xff, 0x7f, 0xfe, 0x00, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x00, 0x5f, 0xfd, 0x0d, 0xff, 0x50, 0x00, 0x00,  //....+@@@.@@@+....
    0x00, 0x00, 0xbf, 0xf7, 0x07, 0xff, 0xb0, 0x00, 0x00,  //....%@@+.+@@%....
    0x00, 0x01, 0xff, 0xf1, 0x01, 0xff, 0xf1, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x07, 0xff, 0xb0, 0x00, 0xbf, 0xf7, 0x00, 0x00,  //...+@@%...%@@+...
    0x00, 0x0d, 0xff, 0x50, 0x00, 0x5f, 0xfd, 0x00, 0x00,  //...@@@+...+@@@...
    0x00, 0x3f, 0xff, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00,  //...@@@.....@@@...
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //..@@@@@@@@@@@@@..
    0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0xdf, 0xf5, 0x00,  //.+@@@.......@@@+.
    0x0b, 0xff, 0x70, 0x00, 0x00, 0x00, 0x8f, 0xfb, 0x00,  //.%@@+.......+@@%.
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@.........@@@.
    0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@%.........@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c3 (Ã) , Width: 17 */
    0x00, 0x00, 0x02, 0xde, 0x81, 0xde, 0x00, 0x00, 0x00,  //......@@%.@@.....
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xfb, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x0f, 0xd1, 0x8e, 0xd2, 0x00, 0x00, 0x00,  //.....@@.%@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x1f, 0xff, 0x10, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x7f, 0xff, 0x70, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0xdf, 0xff, 0xd0, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x03, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x09, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x0e, 0xff, 0x7f, 0xfe, 0x00, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x00, 0x5f, 0xfd, 0x0d, 0xff, 0x50, 0x00, 0x00,  //....+@@@.@@@+....
    0x00, 0x00, 0xbf, 0xf7, 0x07, 0xff, 0xb0, 0x00, 0x00,  //....%@@+.+@@%....
    0x00, 0x01, 0xff, 0xf1, 0x01, 0xff, 0xf1, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x07, 0xff, 0xb0, 0x00, 0xbf, 0xf7, 0x00, 0x00,  //...+@@%...%@@+...
    0x00, 0x0d, 0xff, 0x50, 0x00, 0x5f, 0xfd, 0x00, 0x00,  //...@@@+...+@@@...
    0x00, 0x3f, 0xff, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00,  //...@@@.....@@@...
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //..@@@@@@@@@@@@@..
    0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0xdf, 0xf5, 0x00,  //.+@@@.......@@@+.
    0x0b, 0xff, 0x70, 0x00, 0x00, 0x00, 0x8f, 0xfb, 0x00,  //.%@@+.......+@@%.
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@.........@@@.
    0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@%.........@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c4 (Ä) , Width: 17 */
    0x00, 0x00, 0x0f, 0xff, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x0f, 0xff, 0x00, 0x00, 0x00,  //.....@@@.@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x1f, 0xff, 0x10, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x7f, 0xff, 0x70, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0xdf, 0xff, 0xd0, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x03, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x09, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x0e, 0xff, 0x7f, 0xfe, 0x00, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x00, 0x5f, 0xfd, 0x0d, 0xff, 0x50, 0x00, 0x00,  //....+@@@.@@@+....
    0x00, 0x00, 0xbf, 0xf7, 0x07, 0xff, 0xb0, 0x00, 0x00,  //....%@@+.+@@%....
    0x00, 0x01, 0xff, 0xf1, 0x01, 0xff, 0xf1, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x07, 0xff, 0xb0, 0x00, 0xbf, 0xf7, 0x00, 0x00,  //...+@@%...%@@+...
    0x00, 0x0d, 0xff, 0x50, 0x00, 0x5f, 0xfd, 0x00, 0x00,  //...@@@+...+@@@...
    0x00, 0x3f, 0xff, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00,  //...@@@.....@@@...
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //..@@@@@@@@@@@@@..
    0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0xdf, 0xf5, 0x00,  //.+@@@.......@@@+.
    0x0b, 0xff, 0x70, 0x00, 0x00, 0x00, 0x8f, 0xfb, 0x00,  //.%@@+.......+@@%.
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@.........@@@.
    0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@%.........@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c5 (Å) , Width: 17 */
    0x00, 0x00, 0x00, 0x5d, 0xfc, 0x50, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x06, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00,  //.....+@@@@@+.....
    0x00, 0x00, 0x0e, 0xf7, 0x07, 0xfd, 0x00, 0x00, 0x00,  //.....@@+.+@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0xff, 0x00, 0x00, 0x00,  //.....@@...@@.....
    0x00, 0x00, 0x0a, 0xf7, 0x07, 0xfa, 0x00, 0x00, 0x00,  //.....%@+.+@%.....
    0x00, 0x00, 0x00, 0xbf, 0xff, 0xb0, 0x00, 0x00, 0x00,  //......%@@@%......
    0x00, 0x00, 0x00, 0x2f, 0xff, 0x20, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x9f, 0xff, 0x90, 0x00, 0x00, 0x00,  //......%@@@%......
    0x00, 0x00, 0x00, 0xef, 0xff, 0xe0, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x05, 0xff, 0xff, 0xf5, 0x00, 0x00, 0x00,  //.....+@@@@@+.....
    0x00, 0x00, 0x0b, 0xff, 0xdf, 0xfb, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x2f, 0xff, 0x3f, 0xff, 0x20, 0x00, 0x00,  //.....@@@.@@@.....
    0x00, 0x00, 0x8f, 0xfb, 0x0b, 0xff, 0x80, 0x00, 0x00,  //....%@@%.%@@%....
    0x00, 0x00, 0xef, 0xf4, 0x04, 0xff, 0xe0, 0x00, 0x00,  //....@@@+.+@@@....
    0x00, 0x04, 0xff, 0xe0, 0x00, 0xef, 0xf4, 0x00, 0x00,  //...+@@@...@@@+...
    0x00, 0x0b, 0xff, 0x80, 0x00, 0x8f, 0xfa, 0x00, 0x00,  //...%@@%...%@@%...
    0x00, 0x1f, 0xff, 0x20, 0x00, 0x2f, 0xff, 0x10, 0x00,  //...@@@.....@@@...
    0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00,  //..+@@@@@@@@@@@+..
    0x00, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x00,  //..@@@@@@@@@@@@@..
    0x03, 0xff, 0xe0, 0x00, 0x00, 0x00, 0xef, 0xf3, 0x00,  //..@@@.......@@@..
    0x0a, 0xff, 0x90, 0x00, 0x00, 0x00, 0x9f, 0xfa, 0x00,  //.%@@%.......%@@%.
    0x0f, 0xff, 0x30, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x00,  //.@@@.........@@@.
    0x6f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@@.........@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c6 (Æ) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.......+@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.......@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x4f, 0xfe, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@.@@@.........
    0x00, 0x00, 0x00, 0xbf, 0xf8, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@%.@@@.........
    0x00, 0x00, 0x02, 0xff, 0xf1, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@..@@@.........
    0x00, 0x00, 0x08, 0xff, 0xb0, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@%..@@@.........
    0x00, 0x00, 0x0e, 0xff, 0x40, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@+..@@@.........
    0x00, 0x00, 0x5f, 0xfe, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@...@@@.........
    0x00, 0x00, 0xbf, 0xf7, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //....%@@+...@@@@@@@@@@@.
    0x00, 0x02, 0xff, 0xf1, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //....@@@....@@@@@@@@@@@.
    0x00, 0x08, 0xff, 0xa0, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@%....@@@.........
    0x00, 0x0e, 0xff, 0x40, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@+....@@@.........
    0x00, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@@@@@@.........
    0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@@@@@.........
    0x02, 0xff, 0xf1, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@......@@@.........
    0x09, 0xff, 0xa0, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@%......@@@.........
    0x0f, 0xff, 0x30, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.......@@@.........
    0x6f, 0xfd, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //+@@@.......@@@@@@@@@@@@
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@+.......@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c7 (Ç) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x06, 0xad, 0xff, 0xea, 0x50, 0x00,  //.....+%@@@@%+..
    0x00, 0x05, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x50,  //...+@@@@@@@@@@+
    0x00, 0x7f, 0xff, 0x93, 0x10, 0x26, 0xdf, 0xf0,  //..+@@@%....+@@@
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x08, 0xf0,  //.+@@@........%@
    0x0e, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x70,  //.@@@+.........+
    0x5f, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%...........
    0x9f, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+...........
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xaf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+...........
    0x5f, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%...........
    0x0e, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x70,  //.@@@..........+
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x08, 0xf0,  //.+@@@........%@
    0x00, 0x7f, 0xff, 0x93, 0x10, 0x26, 0xdf, 0xf0,  //..+@@@%....+@@@
    0x00, 0x05, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x50,  //...+@@@@@@@@@@+
    0x00, 0x00, 0x06, 0xad, 0xff, 0xea, 0x50, 0x00,  //.....+%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x0a, 0xf4, 0x00, 0x00,  //.........%@+...
    0x00, 0x00, 0x00, 0x00, 0x01, 0xfb, 0x00, 0x00,  //..........@%...
    0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x00, 0x00,  //..........@@...
    0x00, 0x00, 0x00, 0x0f, 0xff, 0xfd, 0x00, 0x00,  //.......@@@@@...
    0x00, 0x00, 0x00, 0x0c, 0xff, 0xc3, 0x00, 0x00,  //.......%@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00c8 (È) , Width: 12 */
    0x00, 0x08, 0xfc, 0x00, 0x00, 0x00,  //...%@@......
    0x00, 0x00, 0x8f, 0x90, 0x00, 0x00,  //....%@%.....
    0x00, 0x00, 0x08, 0xf7, 0x00, 0x00,  //.....%@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c9 (É) , Width: 12 */
    0x00, 0x00, 0x00, 0x1d, 0xf5, 0x00,  //.......@@+..
    0x00, 0x00, 0x00, 0xbf, 0x60, 0x00,  //......%@+...
    0x00, 0x00, 0x09, 0xf6, 0x00, 0x00,  //.....%@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00ca (Ê) , Width: 12 */
    0x00, 0x00, 0x0a, 0xff, 0xa0, 0x00,  //.....%@@%...
    0x00, 0x00, 0x9f, 0x77, 0xf9, 0x00,  //....%@++@%..
    0x00, 0x08, 0xf6, 0x00, 0x6f, 0x80,  //...%@+..+@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00cb (Ë) , Width: 12 */
    0x00, 0x0f, 0xff, 0x00, 0xff, 0xf0,  //...@@@..@@@.
    0x00, 0x0f, 0xff, 0x00, 0xff, 0xf0,  //...@@@..@@@.
    0x00, 0x0f, 0xff, 0x00, 0xff, 0xf0,  //...@@@..@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00cc (Ì) , Width: 5 */
    0x8f, 0xc0, 0x00,  //%@@..
    0x08, 0xf9, 0x00,  //.%@%.
    0x00, 0x8f, 0x70,  //..%@+
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00cd (Í) , Width: 5 */
    0x01, 0xdf, 0x50,  //..@@+
    0x0b, 0xf6, 0x00,  //.%@+.
    0x9f, 0x60, 0x00,  //%@+..
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0xff, 0xf0, 0x00,  //@@@..
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00ce (Î) , Width: 8 */
    0x06, 0xff, 0xf6, 0x00,  //.+@@@+..
    0x7f, 0xc3, 0xcf, 0x70,  //+@@.@@+.
    0xfa, 0x00, 0x0a, 0xf7,  //@%...%@+
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00cf (Ï) , Width: 7 */
    0xff, 0xf0, 0xff, 0xf0,  //@@@.@@@
    0xff, 0xf0, 0xff, 0xf0,  //@@@.@@@
    0xff, 0xf0, 0xff, 0xf0,  //@@@.@@@
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00d0 (Ð) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xec, 0x94, 0x00, 0x00, 0x00,  //...@@@@@@@@@%+.....
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe5, 0x00, 0x00,  //...@@@@@@@@@@@@+...
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x15, 0xaf, 0xff, 0x90, 0x00,  //...@@@.....+%@@@%..
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x03, 0xef, 0xf7, 0x00,  //...@@@........@@@+.
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x00,  //...@@@.........@@@.
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x60,  //...@@@.........%@@+
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xa0,  //...@@@.........+@@%
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //...@@@..........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xe0,  //@@@@@@@@@@......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@@@@@@@@......@@@
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xe0,  //...@@@..........@@@
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //...@@@..........@@@
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xa0,  //...@@@.........+@@%
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x60,  //...@@@.........%@@+
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x00,  //...@@@.........@@@.
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x03, 0xef, 0xf7, 0x00,  //...@@@........@@@+.
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x15, 0xaf, 0xff, 0x90, 0x00,  //...@@@.....+%@@@%..
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe5, 0x00, 0x00,  //...@@@@@@@@@@@@+...
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xec, 0x94, 0x00, 0x00, 0x00,  //...@@@@@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00d1 (Ñ) , Width: 14 */
    0x00, 0x02, 0xcf, 0xc4, 0x2f, 0xe0, 0x00,  //....@@@+.@@...
    0x00, 0x0b, 0xff, 0xff, 0xff, 0xa0, 0x00,  //...%@@@@@@%...
    0x00, 0x0e, 0xf2, 0x4c, 0xfc, 0x10, 0x00,  //...@@.+@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0x10, 0x00, 0x00, 0x0f, 0xff,  //@@@@.......@@@
    0xff, 0xff, 0x90, 0x00, 0x00, 0x0f, 0xff,  //@@@@%......@@@
    0xff, 0xff, 0xf2, 0x00, 0x00, 0x0f, 0xff,  //@@@@@......@@@
    0xff, 0xff, 0xfa, 0x00, 0x00, 0x0f, 0xff,  //@@@@@%.....@@@
    0xff, 0xff, 0xff, 0x30, 0x00, 0x0f, 0xff,  //@@@@@@.....@@@
    0xff, 0xfa, 0xff, 0xb0, 0x00, 0x0f, 0xff,  //@@@%@@%....@@@
    0xff, 0xf2, 0xff, 0xf4, 0x00, 0x0f, 0xff,  //@@@.@@@+...@@@
    0xff, 0xf0, 0xaf, 0xfc, 0x00, 0x0f, 0xff,  //@@@.%@@@...@@@
    0xff, 0xf0, 0x2f, 0xff, 0x50, 0x0f, 0xff,  //@@@..@@@+..@@@
    0xff, 0xf0, 0x0a, 0xff, 0xd0, 0x0f, 0xff,  //@@@..%@@@..@@@
    0xff, 0xf0, 0x02, 0xff, 0xf6, 0x0f, 0xff,  //@@@...@@@+.@@@
    0xff, 0xf0, 0x00, 0xaf, 0xfe, 0x0f, 0xff,  //@@@...%@@@.@@@
    0xff, 0xf0, 0x00, 0x2f, 0xff, 0x7f, 0xff,  //@@@....@@@+@@@
    0xff, 0xf0, 0x00, 0x09, 0xff, 0xef, 0xff,  //@@@....%@@@@@@
    0xff, 0xf0, 0x00, 0x02, 0xff, 0xff, 0xff,  //@@@.....@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x9f, 0xff, 0xff,  //@@@.....%@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x1f, 0xff, 0xff,  //@@@......@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x09, 0xff, 0xff,  //@@@......%@@@@
    0xff, 0xf0, 0x00, 0x00, 0x01, 0xff, 0xff,  //@@@.......@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00d2 (Ò) , Width: 18 */
    0x00, 0x00, 0x00, 0x8f, 0xc0, 0x00, 0x00, 0x00, 0x00,  //......%@@.........
    0x00, 0x00, 0x00, 0x08, 0xf9, 0x00, 0x00, 0x00, 0x00,  //.......%@%........
    0x00, 0x00, 0x00, 0x00, 0x8f, 0x70, 0x00, 0x00, 0x00,  //........%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x60, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //..+@@@%....%@@@+..
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //.+@@@........@@@..
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //.@@@+........+@@@.
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //+@@@..........%@@+
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //%@@+..........+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@............@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@............@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@............@@@
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //%@@+..........+@@%
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //+@@@..........%@@+
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //.@@@+........+@@@.
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //.+@@@........@@@+.
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x60, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d3 (Ó) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x01, 0xdf, 0x50, 0x00, 0x00,  //..........@@+.....
    0x00, 0x00, 0x00, 0x00, 0x0b, 0xf6, 0x00, 0x00, 0x00,  //.........%@+......
    0x00, 0x00, 0x00, 0x00, 0x9f, 0x60, 0x00, 0x00, 0x00,  //........%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x60, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //..+@@@%....%@@@+..
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //.+@@@........@@@..
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //.@@@+........+@@@.
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //+@@@..........%@@+
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //%@@+..........+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@............@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@............@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@............@@@
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //%@@+..........+@@%
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //+@@@..........%@@+
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //.@@@+........+@@@.
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //.+@@@........@@@+.
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x60, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d4 (Ô) , Width: 18 */
    0x00, 0x00, 0x00, 0x0a, 0xff, 0xa0, 0x00, 0x00, 0x00,  //.......%@@%.......
    0x00, 0x00, 0x00, 0x9f, 0x77, 0xf9, 0x00, 0x00, 0x00,  //......%@++@%......
    0x00, 0x00, 0x08, 0xf6, 0x00, 0x6f, 0x80, 0x00, 0x00,  //.....%@+..+@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x60, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //..+@@@%....%@@@+..
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //.+@@@........@@@..
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //.@@@+........+@@@.
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //+@@@..........%@@+
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //%@@+..........+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@............@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@............@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@............@@@
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //%@@+..........+@@%
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //+@@@..........%@@+
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //.@@@+........+@@@.
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //.+@@@........@@@+.
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x60, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d5 (Õ) , Width: 18 */
    0x00, 0x00, 0x02, 0xcf, 0xc4, 0x2f, 0xe0, 0x00, 0x00,  //......@@@+.@@.....
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xa0, 0x00, 0x00,  //.....%@@@@@@%.....
    0x00, 0x00, 0x0e, 0xf2, 0x4c, 0xfc, 0x10, 0x00, 0x00,  //.....@@.+@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x60, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //..+@@@%....%@@@+..
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //.+@@@........@@@..
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //.@@@+........+@@@.
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //+@@@..........%@@+
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //%@@+..........+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@............@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@............@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@............@@@
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //%@@+..........+@@%
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //+@@@..........%@@+
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //.@@@+........+@@@.
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //.+@@@........@@@+.
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x60, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d6 (Ö) , Width: 18 */
    0x00, 0x00, 0x0f, 0xff, 0x00, 0xff, 0xf0, 0x00, 0x00,  //.....@@@..@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0xff, 0xf0, 0x00, 0x00,  //.....@@@..@@@.....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0xff, 0xf0, 0x00, 0x00,  //.....@@@..@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x60, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //..+@@@%....%@@@+..
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //.+@@@........@@@..
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //.@@@+........+@@@.
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //+@@@..........%@@+
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //%@@+..........+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@............@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@............@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@............@@@
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //%@@+..........+@@%
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //+@@@..........%@@+
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //.@@@+........+@@@.
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //.+@@@........@@@+.
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x60, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d7 (×) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x20,  //.%...........%.
    0xcf, 0xb0, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xc0,  //@@%.........%@@
    0x2e, 0xfb, 0x00, 0x00, 0x00, 0x0b, 0xfe, 0x20,  //.@@%.......%@@.
    0x02, 0xef, 0xb0, 0x00, 0x00, 0xbf, 0xe2, 0x00,  //..@@%.....%@@..
    0x00, 0x2e, 0xfb, 0x00, 0x0b, 0xfe, 0x20, 0x00,  //...@@%...%@@...
    0x00, 0x02, 0xef, 0xb0, 0xbf, 0xe2, 0x00, 0x00,  //....@@%.%@@....
    0x00, 0x00, 0x2e, 0xfe, 0xfe, 0x20, 0x00, 0x00,  //.....@@@@@.....
    0x00, 0x00, 0x05, 0xff, 0xf4, 0x00, 0x00, 0x00,  //.....+@@@+.....
    0x00, 0x00, 0x2e, 0xff, 0xfe, 0x20, 0x00, 0x00,  //.....@@@@@.....
    0x00, 0x02, 0xef, 0xb1, 0xbf, 0xe2, 0x00, 0x00,  //....@@%.%@@....
    0x00, 0x2e, 0xfb, 0x00, 0x0b, 0xfe, 0x20, 0x00,  //...@@%...%@@...
    0x02, 0xef, 0xb0, 0x00, 0x00, 0xbf, 0xe2, 0x00,  //..@@%.....%@@..
    0x2e, 0xfb, 0x00, 0x00, 0x00, 0x0b, 0xfe, 0x20,  //.@@%.......%@@.
    0xcf, 0xb0, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xc0,  //@@%.........%@@
    0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x20,  //.%...........%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00d8 (Ø) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00,  //...................
    0x00, 0x00, 0x06, 0xbe, 0xff, 0xda, 0x40, 0x03, 0xfd, 0x00,  //.....+%@@@@%+...@@.
    0x00, 0x05, 0xef, 0xff, 0xff, 0xff, 0xfc, 0x5f, 0xf4, 0x00,  //...+@@@@@@@@@@+@@+.
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x39, 0xff, 0xff, 0x50, 0x00,  //..+@@@%....%@@@@+..
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x4f, 0xff, 0x20, 0x00,  //.+@@@.......+@@@...
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0xcf, 0xff, 0xc0, 0x00,  //.@@@+.......%@@@@..
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x0a, 0xf9, 0xbf, 0xf3, 0x00,  //+@@@.......%@%%@@..
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x8f, 0xb0, 0x6f, 0xf9, 0x00,  //%@@+......%@%.+@@%.
    0xdf, 0xf2, 0x00, 0x00, 0x05, 0xfc, 0x00, 0x2f, 0xfc, 0x00,  //@@@......+@@...@@@.
    0xef, 0xf0, 0x00, 0x00, 0x4f, 0xe1, 0x00, 0x0f, 0xfe, 0x00,  //@@@......@@....@@@.
    0xff, 0xf0, 0x00, 0x02, 0xef, 0x20, 0x00, 0x0f, 0xff, 0x00,  //@@@.....@@.....@@@.
    0xef, 0xf0, 0x00, 0x1d, 0xf4, 0x00, 0x00, 0x0f, 0xfe, 0x00,  //@@@....@@+.....@@@.
    0xdf, 0xf2, 0x00, 0xcf, 0x60, 0x00, 0x00, 0x2f, 0xfd, 0x00,  //@@@...@@+......@@@.
    0x9f, 0xf6, 0x0a, 0xf8, 0x00, 0x00, 0x00, 0x6f, 0xf9, 0x00,  //%@@+.%@%......+@@%.
    0x4f, 0xfb, 0x8f, 0xa0, 0x00, 0x00, 0x00, 0xcf, 0xf5, 0x00,  //+@@%%@%.......@@@+.
    0x0c, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0, 0x00,  //.@@@@%.......+@@@..
    0x02, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40, 0x00,  //..@@@+.......@@@+..
    0x03, 0xff, 0xff, 0x93, 0x00, 0x38, 0xff, 0xf7, 0x00, 0x00,  //..@@@@%....%@@@+...
    0x2e, 0xf6, 0xcf, 0xff, 0xff, 0xff, 0xfe, 0x50, 0x00, 0x00,  //.@@+@@@@@@@@@@+....
    0xcf, 0x40, 0x04, 0xad, 0xff, 0xeb, 0x60, 0x00, 0x00, 0x00,  //@@...+%@@@@%+......
    0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00d9 (Ù) , Width: 14 */
    0x00, 0x08, 0xfc, 0x00, 0x00, 0x00, 0x00,  //...%@@........
    0x00, 0x00, 0x8f, 0x90, 0x00, 0x00, 0x00,  //....%@%.......
    0x00, 0x00, 0x08, 0xf7, 0x00, 0x00, 0x00,  //.....%@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@........@@@
    0xaf, 0xf6, 0x00, 0x00, 0x00, 0x6f, 0xfa,  //%@@+......+@@%
    0x4f, 0xfd, 0x00, 0x00, 0x00, 0xdf, 0xf4,  //+@@@......@@@+
    0x0b, 0xff, 0xb3, 0x00, 0x3c, 0xff, 0xb0,  //.%@@%....%@@%.
    0x01, 0xbf, 0xff, 0xff, 0xff, 0xfb, 0x00,  //..%@@@@@@@@%..
    0x00, 0x05, 0xae, 0xff, 0xea, 0x40, 0x00,  //...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00da (Ú) , Width: 14 */
    0x00, 0x00, 0x00, 0x1d, 0xf5, 0x00, 0x00,  //.......@@+....
    0x00, 0x00, 0x00, 0xbf, 0x60, 0x00, 0x00,  //......%@+.....
    0x00, 0x00, 0x09, 0xf6, 0x00, 0x00, 0x00,  //.....%@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@........@@@
    0xaf, 0xf6, 0x00, 0x00, 0x00, 0x6f, 0xfa,  //%@@+......+@@%
    0x4f, 0xfd, 0x00, 0x00, 0x00, 0xdf, 0xf4,  //+@@@......@@@+
    0x0b, 0xff, 0xb3, 0x00, 0x3c, 0xff, 0xb0,  //.%@@%....%@@%.
    0x01, 0xbf, 0xff, 0xff, 0xff, 0xfb, 0x00,  //..%@@@@@@@@%..
    0x00, 0x05, 0xae, 0xff, 0xea, 0x40, 0x00,  //...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00db (Û) , Width: 14 */
    0x00, 0x00, 0x0a, 0xff, 0xa0, 0x00, 0x00,  //.....%@@%.....
    0x00, 0x00, 0x9f, 0x77, 0xf9, 0x00, 0x00,  //....%@++@%....
    0x00, 0x08, 0xf6, 0x00, 0x6f, 0x80, 0x00,  //...%@+..+@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@........@@@
    0xaf, 0xf6, 0x00, 0x00, 0x00, 0x6f, 0xfa,  //%@@+......+@@%
    0x4f, 0xfd, 0x00, 0x00, 0x00, 0xdf, 0xf4,  //+@@@......@@@+
    0x0b, 0xff, 0xb3, 0x00, 0x3c, 0xff, 0xb0,  //.%@@%....%@@%.
    0x01, 0xbf, 0xff, 0xff, 0xff, 0xfb, 0x00,  //..%@@@@@@@@%..
    0x00, 0x05, 0xae, 0xff, 0xea, 0x40, 0x00,  //...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00dc (Ü) , Width: 14 */
    0x00, 0x0f, 0xff, 0x00, 0xff, 0xf0, 0x00,  //...@@@..@@@...
    0x00, 0x0f, 0xff, 0x00, 0xff, 0xf0, 0x00,  //...@@@..@@@...
    0x00, 0x0f, 0xff, 0x00, 0xff, 0xf0, 0x00,  //...@@@..@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@........@@@
    0xaf, 0xf6, 0x00, 0x00, 0x00, 0x6f, 0xfa,  //%@@+......+@@%
    0x4f, 0xfd, 0x00, 0x00, 0x00, 0xdf, 0xf4,  //+@@@......@@@+
    0x0b, 0xff, 0xb3, 0x00, 0x3c, 0xff, 0xb0,  //.%@@%....%@@%.
    0x01, 0xbf, 0xff, 0xff, 0xff, 0xfb, 0x00,  //..%@@@@@@@@%..
    0x00, 0x05, 0xae, 0xff, 0xea, 0x40, 0x00,  //...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00dd (Ý) , Width: 17 */
    0x00, 0x00, 0x00, 0x01, 0xdf, 0x50, 0x00, 0x00, 0x00,  //........@@+......
    0x00, 0x00, 0x00, 0x0b, 0xf6, 0x00, 0x00, 0x00, 0x00,  //.......%@+.......
    0x00, 0x00, 0x00, 0x9f, 0x60, 0x00, 0x00, 0x00, 0x00,  //......%@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xaf, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xa0,  //%@@@.........@@@%
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x03, 0xff, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xf3, 0x00,  //..@@@+.....+@@@..
    0x00, 0x8f, 0xff, 0x20, 0x00, 0x2f, 0xff, 0x80, 0x00,  //..%@@@.....@@@%..
    0x00, 0x0c, 0xff, 0xc0, 0x00, 0xcf, 0xfc, 0x00, 0x00,  //...@@@@...@@@@...
    0x00, 0x02, 0xff, 0xf8, 0x08, 0xff, 0xf2, 0x00, 0x00,  //....@@@%.%@@@....
    0x00, 0x00, 0x6f, 0xff, 0x7f, 0xff, 0x60, 0x00, 0x00,  //....+@@@+@@@+....
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xfb, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x01, 0xef, 0xff, 0xe1, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x5f, 0xff, 0x50, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00de (Þ) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xfd, 0x93, 0x00,  //@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //@@@@@@@@@@+.
    0xff, 0xf0, 0x00, 0x17, 0xff, 0xf4,  //@@@....+@@@+
    0xff, 0xf0, 0x00, 0x00, 0x8f, 0xfb,  //@@@.....+@@%
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xfe,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xfe,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x8f, 0xfb,  //@@@.....+@@%
    0xff, 0xf0, 0x00, 0x17, 0xff, 0xf4,  //@@@....+@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xfd, 0x93, 0x00,  //@@@@@@@@%...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00df (ß) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x4b, 0xef, 0xeb, 0x50, 0x00, 0x00,  //..+%@@@%+....
    0x09, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00,  //.%@@@@@@@%...
    0x5f, 0xfe, 0x40, 0x3d, 0xff, 0x40, 0x00,  //+@@@+..@@@+..
    0xcf, 0xf5, 0x00, 0x04, 0xff, 0xa0, 0x00,  //%@@+...+@@%..
    0xff, 0xf1, 0x00, 0x03, 0xff, 0xe0, 0x00,  //@@@.....@@@..
    0xff, 0xf0, 0x00, 0x9f, 0xff, 0xc0, 0x00,  //@@@...%@@@@..
    0xff, 0xf0, 0x06, 0xff, 0xc2, 0x00, 0x00,  //@@@..+@@@....
    0xff, 0xf0, 0x0d, 0xff, 0x30, 0x00, 0x00,  //@@@..@@@.....
    0xff, 0xf0, 0x0f, 0xff, 0x00, 0x00, 0x00,  //@@@..@@@.....
    0xff, 0xf0, 0x0d, 0xff, 0x00, 0x00, 0x00,  //@@@..@@@.....
    0xff, 0xf0, 0x05, 0xff, 0x20, 0x00, 0x00,  //@@@..+@@.....
    0xff, 0xf0, 0x00, 0x4e, 0xf9, 0x10, 0x00,  //@@@...+@@%...
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf5, 0x00,  //@@@.....@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x3e, 0xff, 0x50,  //@@@......@@@+
    0xff, 0xf0, 0x00, 0x00, 0x04, 0xff, 0xd0,  //@@@......+@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf0, 0xb5, 0x10, 0x3c, 0xff, 0x80,  //@@@.%+...@@@%
    0xff, 0xf0, 0xff, 0xff, 0xff, 0xfc, 0x00,  //@@@.@@@@@@@@.
    0xff, 0xf0, 0x39, 0xef, 0xec, 0x70, 0x00,  //@@@..%@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00e0 (à) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x9f, 0xc0, 0x00, 0x00, 0x00,  //..%@@.......
    0x00, 0x0c, 0xf8, 0x00, 0x00, 0x00,  //...%@%......
    0x00, 0x01, 0xef, 0x30, 0x00, 0x00,  //....@@......
    0x00, 0x00, 0x2f, 0xd0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x05, 0xfa, 0x00, 0x00,  //.....+@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x02, 0x7b, 0xef, 0xfd, 0x93, 0x00,  //..+%@@@@%...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0x60,  //.@@@@@@@@@+.
    0x0c, 0x62, 0x00, 0x27, 0xff, 0xf3,  //.@+....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xfa,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xfd,  //.........@@@
    0x00, 0x5a, 0xdf, 0xff, 0xff, 0xff,  //..+%@@@@@@@@
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@
    0x8f, 0xfe, 0x51, 0x00, 0x0f, 0xff,  //+@@@+....@@@
    0xdf, 0xf3, 0x00, 0x00, 0x2f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x5f, 0xff,  //@@@.....+@@@
    0xef, 0xf3, 0x00, 0x00, 0xdf, 0xff,  //@@@.....@@@@
    0xaf, 0xfc, 0x30, 0x2b, 0xaf, 0xff,  //%@@@...%%@@@
    0x2e, 0xff, 0xff, 0xfd, 0x1f, 0xff,  //.@@@@@@@.@@@
    0x02, 0xae, 0xfd, 0x81, 0x0f, 0xff,  //..%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e1 (á) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0xdf, 0x90,  //........@@%.
    0x00, 0x00, 0x00, 0x08, 0xfc, 0x00,  //.......%@%..
    0x00, 0x00, 0x00, 0x4f, 0xd1, 0x00,  //.......@@...
    0x00, 0x00, 0x00, 0xef, 0x20, 0x00,  //......@@....
    0x00, 0x00, 0x0a, 0xf5, 0x00, 0x00,  //.....%@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x02, 0x7b, 0xef, 0xfd, 0x93, 0x00,  //..+%@@@@%...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0x60,  //.@@@@@@@@@+.
    0x0c, 0x62, 0x00, 0x27, 0xff, 0xf3,  //.@+....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xfa,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xfd,  //.........@@@
    0x00, 0x5a, 0xdf, 0xff, 0xff, 0xff,  //..+%@@@@@@@@
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@
    0x8f, 0xfe, 0x51, 0x00, 0x0f, 0xff,  //+@@@+....@@@
    0xdf, 0xf3, 0x00, 0x00, 0x2f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x5f, 0xff,  //@@@.....+@@@
    0xef, 0xf3, 0x00, 0x00, 0xdf, 0xff,  //@@@.....@@@@
    0xaf, 0xfc, 0x30, 0x2b, 0xaf, 0xff,  //%@@@...%%@@@
    0x2e, 0xff, 0xff, 0xfd, 0x1f, 0xff,  //.@@@@@@@.@@@
    0x02, 0xae, 0xfd, 0x81, 0x0f, 0xff,  //..%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e2 (â) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x3f, 0xf3, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0xdf, 0xfd, 0x00, 0x00,  //....@@@@....
    0x00, 0x07, 0xf7, 0x7f, 0x70, 0x00,  //...+@++@+...
    0x00, 0x1f, 0xc0, 0x0c, 0xf1, 0x00,  //...@@..@@...
    0x00, 0xbf, 0x20, 0x02, 0xfb, 0x00,  //..%@....@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x02, 0x7b, 0xef, 0xfd, 0x93, 0x00,  //..+%@@@@%...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0x60,  //.@@@@@@@@@+.
    0x0c, 0x62, 0x00, 0x27, 0xff, 0xf3,  //.@+....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xfa,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xfd,  //.........@@@
    0x00, 0x5a, 0xdf, 0xff, 0xff, 0xff,  //..+%@@@@@@@@
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@
    0x8f, 0xfe, 0x51, 0x00, 0x0f, 0xff,  //+@@@+....@@@
    0xdf, 0xf3, 0x00, 0x00, 0x2f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x5f, 0xff,  //@@@.....+@@@
    0xef, 0xf3, 0x00, 0x00, 0xdf, 0xff,  //@@@.....@@@@
    0xaf, 0xfc, 0x30, 0x2b, 0xaf, 0xff,  //%@@@...%%@@@
    0x2e, 0xff, 0xff, 0xfd, 0x1f, 0xff,  //.@@@@@@@.@@@
    0x02, 0xae, 0xfd, 0x81, 0x0f, 0xff,  //..%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e3 (ã) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x1c, 0xe8, 0x00, 0xff, 0x00,  //...%@%..@@..
    0x00, 0x8f, 0xff, 0x64, 0xfd, 0x00,  //..%@@@+.@@..
    0x00, 0xdf, 0x36, 0xff, 0xf8, 0x00,  //..@@.+@@@%..
    0x00, 0xff, 0x00, 0x8e, 0xc1, 0x00,  //..@@..%@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x02, 0x7b, 0xef, 0xfd, 0x93, 0x00,  //..+%@@@@%...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0x60,  //.@@@@@@@@@+.
    0x0c, 0x62, 0x00, 0x27, 0xff, 0xf3,  //.@+....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xfa,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xfd,  //.........@@@
    0x00, 0x5a, 0xdf, 0xff, 0xff, 0xff,  //..+%@@@@@@@@
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@
    0x8f, 0xfe, 0x51, 0x00, 0x0f, 0xff,  //+@@@+....@@@
    0xdf, 0xf3, 0x00, 0x00, 0x2f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x5f, 0xff,  //@@@.....+@@@
    0xef, 0xf3, 0x00, 0x00, 0xdf, 0xff,  //@@@.....@@@@
    0xaf, 0xfc, 0x30, 0x2b, 0xaf, 0xff,  //%@@@...%%@@@
    0x2e, 0xff, 0xff, 0xfd, 0x1f, 0xff,  //.@@@@@@@.@@@
    0x02, 0xae, 0xfd, 0x81, 0x0f, 0xff,  //..%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e4 (ä) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0xff, 0xf0, 0x0f, 0xff, 0x00,  //..@@@..@@@..
    0x00, 0xff, 0xf0, 0x0f, 0xff, 0x00,  //..@@@..@@@..
    0x00, 0xff, 0xf0, 0x0f, 0xff, 0x00,  //..@@@..@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x02, 0x7b, 0xef, 0xfd, 0x93, 0x00,  //..+%@@@@%...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0x60,  //.@@@@@@@@@+.
    0x0c, 0x62, 0x00, 0x27, 0xff, 0xf3,  //.@+....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xfa,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xfd,  //.........@@@
    0x00, 0x5a, 0xdf, 0xff, 0xff, 0xff,  //..+%@@@@@@@@
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@
    0x8f, 0xfe, 0x51, 0x00, 0x0f, 0xff,  //+@@@+....@@@
    0xdf, 0xf3, 0x00, 0x00, 0x2f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x5f, 0xff,  //@@@.....+@@@
    0xef, 0xf3, 0x00, 0x00, 0xdf, 0xff,  //@@@.....@@@@
    0xaf, 0xfc, 0x30, 0x2b, 0xaf, 0xff,  //%@@@...%%@@@
    0x2e, 0xff, 0xff, 0xfd, 0x1f, 0xff,  //.@@@@@@@.@@@
    0x02, 0xae, 0xfd, 0x81, 0x0f, 0xff,  //..%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e5 (å) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x5d, 0xfd, 0x50, 0x00,  //....+@@@+...
    0x00, 0x05, 0xff, 0xff, 0xf5, 0x00,  //...+@@@@@+..
    0x00, 0x0d, 0xf7, 0x07, 0xfd, 0x00,  //...@@+.+@@..
    0x00, 0x0f, 0xf0, 0x00, 0xff, 0x00,  //...@@...@@..
    0x00, 0x0d, 0xf7, 0x07, 0xfd, 0x00,  //...@@+.+@@..
    0x00, 0x05, 0xff, 0xff, 0xf5, 0x00,  //...+@@@@@+..
    0x00, 0x00, 0x5d, 0xfd, 0x50, 0x00,  //....+@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x02, 0x7b, 0xef, 0xfd, 0x93, 0x00,  //..+%@@@@%...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0x60,  //.@@@@@@@@@+.
    0x0c, 0x62, 0x00, 0x27, 0xff, 0xf3,  //.@+....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xfa,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xfd,  //.........@@@
    0x00, 0x5a, 0xdf, 0xff, 0xff, 0xff,  //..+%@@@@@@@@
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@
    0x8f, 0xfe, 0x51, 0x00, 0x0f, 0xff,  //+@@@+....@@@
    0xdf, 0xf3, 0x00, 0x00, 0x2f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x5f, 0xff,  //@@@.....+@@@
    0xef, 0xf3, 0x00, 0x00, 0xdf, 0xff,  //@@@.....@@@@
    0xaf, 0xfc, 0x30, 0x2b, 0xaf, 0xff,  //%@@@...%%@@@
    0x2e, 0xff, 0xff, 0xfd, 0x1f, 0xff,  //.@@@@@@@.@@@
    0x02, 0xae, 0xfd, 0x81, 0x0f, 0xff,  //..%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e6 (æ) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x02, 0x7b, 0xef, 0xfd, 0x92, 0x00, 0x29, 0xdf, 0xfd, 0x81, 0x00,  //..+%@@@@%....%@@@@%...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0x67, 0xff, 0xff, 0xff, 0xfe, 0x20,  //.@@@@@@@@@++@@@@@@@@..
    0x0c, 0x62, 0x00, 0x27, 0xff, 0xff, 0xfc, 0x30, 0x18, 0xff, 0xd0,  //.@+....+@@@@@@...%@@@.
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xff, 0xd0, 0x00, 0x00, 0xaf, 0xf6,  //........+@@@@.....%@@+
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x60, 0x00, 0x00, 0x3f, 0xfb,  //.........@@@+......@@%
    0x00, 0x5a, 0xdf, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x1f, 0xfe,  //..+%@@@@@@@@.......@@@
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@@@@@@@@@@@
    0x8f, 0xfe, 0x51, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //+@@@+....@@@@@@@@@@@@@
    0xdf, 0xf3, 0x00, 0x00, 0x1f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00,  //@@@......@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x4f, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00,  //@@@.....+@@@+.........
    0xef, 0xf3, 0x00, 0x00, 0xcf, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00,  //@@@.....%@@@@.........
    0xaf, 0xfc, 0x30, 0x2a, 0xfc, 0x6f, 0xfd, 0x51, 0x00, 0x37, 0xc0,  //%@@@...%@@+@@@+....+@.
    0x1e, 0xff, 0xff, 0xff, 0xc1, 0x07, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@@@@..+@@@@@@@@@.
    0x01, 0x9d, 0xfe, 0xc6, 0x00, 0x00, 0x29, 0xdf, 0xfe, 0xb7, 0x20,  //..%@@@@+.....%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+00e7 (ç) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x03, 0xad, 0xff, 0xd9, 0x30,  //....%@@@@%.
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xf0,  //..%@@@@@@@@
    0x0a, 0xff, 0xe5, 0x10, 0x15, 0xc0,  //.%@@@+...+%
    0x4f, 0xfe, 0x10, 0x00, 0x00, 0x00,  //.@@@.......
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00,  //%@@+.......
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00,  //%@@+.......
    0x3f, 0xfe, 0x10, 0x00, 0x00, 0x00,  //.@@@.......
    0x0a, 0xff, 0xe5, 0x10, 0x15, 0xc0,  //.%@@@+...+%
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xf0,  //..%@@@@@@@@
    0x00, 0x04, 0xae, 0xff, 0xd9, 0x30,  //...+%@@@@%.
    0x00, 0x00, 0x00, 0x0a, 0xf4, 0x00,  //.......%@+.
    0x00, 0x00, 0x00, 0x01, 0xfb, 0x00,  //........@%.
    0x00, 0x00, 0x00, 0x03, 0xff, 0x00,  //........@@.
    0x00, 0x00, 0x0f, 0xff, 0xfd, 0x00,  //.....@@@@@.
    0x00, 0x00, 0x0c, 0xff, 0xc3, 0x00,  //.....%@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00e8 (è) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x09, 0xfc, 0x00, 0x00, 0x00, 0x00,  //...%@@.......
    0x00, 0x00, 0xcf, 0x80, 0x00, 0x00, 0x00,  //....%@%......
    0x00, 0x00, 0x1e, 0xf3, 0x00, 0x00, 0x00,  //.....@@......
    0x00, 0x00, 0x02, 0xfd, 0x00, 0x00, 0x00,  //......@@.....
    0x00, 0x00, 0x00, 0x5f, 0xa0, 0x00, 0x00,  //......+@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x03, 0xad, 0xff, 0xc7, 0x00, 0x00,  //....%@@@@+...
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xd2, 0x00,  //..%@@@@@@@@..
    0x09, 0xff, 0xc3, 0x01, 0x8f, 0xfc, 0x00,  //.%@@@...%@@@.
    0x3f, 0xfd, 0x00, 0x00, 0x0a, 0xff, 0x60,  //.@@@.....%@@+
    0x9f, 0xf6, 0x00, 0x00, 0x03, 0xff, 0xb0,  //%@@+......@@%
    0xdf, 0xf2, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xaf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.........
    0x4f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.........
    0x0a, 0xff, 0xd5, 0x10, 0x03, 0x7c, 0x00,  //.%@@@+....+@.
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0x03, 0xad, 0xff, 0xeb, 0x72, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00e9 (é) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x0d, 0xf9, 0x00,  //.........@@%.
    0x00, 0x00, 0x00, 0x00, 0x8f, 0xc0, 0x00,  //........%@%..
    0x00, 0x00, 0x00, 0x04, 0xfd, 0x10, 0x00,  //........@@...
    0x00, 0x00, 0x00, 0x0e, 0xf2, 0x00, 0x00,  //.......@@....
    0x00, 0x00, 0x00, 0xaf, 0x50, 0x00, 0x00,  //......%@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x03, 0xad, 0xff, 0xc7, 0x00, 0x00,  //....%@@@@+...
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xd2, 0x00,  //..%@@@@@@@@..
    0x09, 0xff, 0xc3, 0x01, 0x8f, 0xfc, 0x00,  //.%@@@...%@@@.
    0x3f, 0xfd, 0x00, 0x00, 0x0a, 0xff, 0x60,  //.@@@.....%@@+
    0x9f, 0xf6, 0x00, 0x00, 0x03, 0xff, 0xb0,  //%@@+......@@%
    0xdf, 0xf2, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xaf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.........
    0x4f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.........
    0x0a, 0xff, 0xd5, 0x10, 0x03, 0x7c, 0x00,  //.%@@@+....+@.
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0x03, 0xad, 0xff, 0xeb, 0x72, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00ea (ê) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x0d, 0xfd, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x8f, 0xff, 0x90, 0x00, 0x00,  //....%@@@%....
    0x00, 0x03, 0xfd, 0x1d, 0xf4, 0x00, 0x00,  //....@@.@@+...
    0x00, 0x0d, 0xf3, 0x02, 0xfe, 0x10, 0x00,  //...@@...@@...
    0x00, 0x9f, 0x60, 0x00, 0x5f, 0xa0, 0x00,  //..%@+...+@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x03, 0xad, 0xff, 0xc7, 0x00, 0x00,  //....%@@@@+...
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xd2, 0x00,  //..%@@@@@@@@..
    0x09, 0xff, 0xc3, 0x01, 0x8f, 0xfc, 0x00,  //.%@@@...%@@@.
    0x3f, 0xfd, 0x00, 0x00, 0x0a, 0xff, 0x60,  //.@@@.....%@@+
    0x9f, 0xf6, 0x00, 0x00, 0x03, 0xff, 0xb0,  //%@@+......@@%
    0xdf, 0xf2, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xaf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.........
    0x4f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.........
    0x0a, 0xff, 0xd5, 0x10, 0x03, 0x7c, 0x00,  //.%@@@+....+@.
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0x03, 0xad, 0xff, 0xeb, 0x72, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00eb (ë) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0xff, 0xf0, 0x0f, 0xff, 0x00,  //....@@@..@@@.
    0x00, 0x00, 0xff, 0xf0, 0x0f, 0xff, 0x00,  //....@@@..@@@.
    0x00, 0x00, 0xff, 0xf0, 0x0f, 0xff, 0x00,  //....@@@..@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x03, 0xad, 0xff, 0xc7, 0x00, 0x00,  //....%@@@@+...
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xd2, 0x00,  //..%@@@@@@@@..
    0x09, 0xff, 0xc3, 0x01, 0x8f, 0xfc, 0x00,  //.%@@@...%@@@.
    0x3f, 0xfd, 0x00, 0x00, 0x0a, 0xff, 0x60,  //.@@@.....%@@+
    0x9f, 0xf6, 0x00, 0x00, 0x03, 0xff, 0xb0,  //%@@+......@@%
    0xdf, 0xf2, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xaf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.........
    0x4f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.........
    0x0a, 0xff, 0xd5, 0x10, 0x03, 0x7c, 0x00,  //.%@@@+....+@.
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0x03, 0xad, 0xff, 0xeb, 0x72, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00ec (ì) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xfc, 0x00, 0x00,  //@@...
    0xcf, 0x80, 0x00,  //%@%..
    0x1e, 0xf3, 0x00,  //.@@..
    0x02, 0xfd, 0x00,  //..@@.
    0x00, 0x5f, 0xa0,  //..+@%
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00ed (í) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x0d, 0xf9,  //...@@%
    0x00, 0x8f, 0xc0,  //..%@%.
    0x04, 0xfd, 0x10,  //..@@..
    0x0e, 0xf2, 0x00,  //.@@...
    0xaf, 0x50, 0x00,  //%@+...
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+00ee (î) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0xdf, 0xd0, 0x00,  //..@@@...
    0x09, 0xff, 0xf9, 0x00,  //.%@@@%..
    0x4f, 0xd1, 0xdf, 0x40,  //+@@.@@+.
    0xef, 0x20, 0x2f, 0xe1,  //@@...@@.
    0xf5, 0x00, 0x05, 0xfa,  //@+...+@%
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0xff, 0xf0, 0x00,  //..@@@...
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00ef (ï) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0xf0, 0xff, 0xf0,  //@@@.@@@
    0xff, 0xf0, 0xff, 0xf0,  //@@@.@@@
    0xff, 0xf0, 0xff, 0xf0,  //@@@.@@@
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0xff, 0xf0, 0x00,  //..@@@..
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00f0 (ð) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x09, 0xfd, 0x00, 0x00, 0x50, 0x00,  //...%@@....+..
    0x00, 0x00, 0xcf, 0xa5, 0xaf, 0xf2, 0x00,  //....@@%+%@@..
    0x00, 0x00, 0x4f, 0xff, 0xb5, 0x00, 0x00,  //....+@@@%+...
    0x01, 0x6c, 0xfe, 0xff, 0x20, 0x00, 0x00,  //..+@@@@@.....
    0x03, 0xf9, 0x30, 0xaf, 0xc0, 0x00, 0x00,  //..@%..%@@....
    0x00, 0x00, 0x00, 0x0d, 0xf9, 0x00, 0x00,  //.......@@%...
    0x00, 0x06, 0xce, 0xff, 0xff, 0x70, 0x00,  //...+@@@@@@+..
    0x00, 0xcf, 0xff, 0xff, 0xff, 0xf4, 0x00,  //..%@@@@@@@@..
    0x0b, 0xff, 0xc3, 0x01, 0x5f, 0xfd, 0x00,  //.%@@@...+@@@.
    0x4f, 0xfd, 0x00, 0x00, 0x09, 0xff, 0x50,  //+@@@.....%@@+
    0xaf, 0xf6, 0x00, 0x00, 0x04, 0xff, 0xa0,  //%@@+.....+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x01, 0xff, 0xd0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xdf, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xaf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0x90,  //%@@+.....+@@%
    0x3f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x30,  //.@@@.....@@@.
    0x0a, 0xff, 0xb2, 0x02, 0xbf, 0xf9, 0x00,  //.%@@%...%@@%.
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xa0, 0x00,  //..%@@@@@@@%..
    0x00, 0x05, 0xbe, 0xfe, 0xb4, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f1 (ñ) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x1c, 0xe8, 0x00, 0xff, 0x00,  //...%@%..@@..
    0x00, 0x8f, 0xff, 0x64, 0xfd, 0x00,  //..%@@@+.@@..
    0x00, 0xdf, 0x36, 0xff, 0xf8, 0x00,  //..@@.+@@@%..
    0x00, 0xff, 0x00, 0x8e, 0xc1, 0x00,  //..@@..%@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xf0, 0x19, 0xef, 0xd7, 0x00,  //@@@..%@@@+..
    0xff, 0xf1, 0xdf, 0xff, 0xff, 0xb0,  //@@@.@@@@@@%.
    0xff, 0xfa, 0xa2, 0x04, 0xff, 0xf5,  //@@@%%..+@@@+
    0xff, 0xfc, 0x00, 0x00, 0x7f, 0xfa,  //@@@@....+@@%
    0xff, 0xf5, 0x00, 0x00, 0x2f, 0xfe,  //@@@+.....@@@
    0xff, 0xf2, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00f2 (ò) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x9f, 0xc0, 0x00, 0x00, 0x00, 0x00,  //..%@@........
    0x00, 0x0c, 0xf8, 0x00, 0x00, 0x00, 0x00,  //...%@%.......
    0x00, 0x01, 0xef, 0x30, 0x00, 0x00, 0x00,  //....@@.......
    0x00, 0x00, 0x2f, 0xd0, 0x00, 0x00, 0x00,  //.....@@......
    0x00, 0x00, 0x05, 0xfa, 0x00, 0x00, 0x00,  //.....+@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x06, 0xbe, 0xfe, 0xb5, 0x00, 0x00,  //...+%@@@%+...
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0x00,  //..@@@@@@@@@..
    0x0b, 0xff, 0xb2, 0x02, 0xbf, 0xfb, 0x00,  //.%@@%...%@@%.
    0x4f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x40,  //+@@@.....@@@+
    0xaf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xa0,  //%@@+.....+@@%
    0xef, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xef, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xaf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xa0,  //%@@+.....+@@%
    0x5f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x40,  //+@@@.....@@@+
    0x0b, 0xff, 0xb2, 0x02, 0xbf, 0xfb, 0x00,  //.%@@%...%@@%.
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0x00,  //..@@@@@@@@@..
    0x00, 0x06, 0xbe, 0xfe, 0xb5, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f3 (ó) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0xdf, 0x90, 0x00,  //........@@%..
    0x00, 0x00, 0x00, 0x08, 0xfc, 0x00, 0x00,  //.......%@%...
    0x00, 0x00, 0x00, 0x4f, 0xd1, 0x00, 0x00,  //.......@@....
    0x00, 0x00, 0x00, 0xef, 0x20, 0x00, 0x00,  //......@@.....
    0x00, 0x00, 0x0a, 0xf5, 0x00, 0x00, 0x00,  //.....%@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x06, 0xbe, 0xfe, 0xb5, 0x00, 0x00,  //...+%@@@%+...
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0x00,  //..@@@@@@@@@..
    0x0b, 0xff, 0xb2, 0x02, 0xbf, 0xfb, 0x00,  //.%@@%...%@@%.
    0x4f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x40,  //+@@@.....@@@+
    0xaf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xa0,  //%@@+.....+@@%
    0xef, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xef, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xaf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xa0,  //%@@+.....+@@%
    0x5f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x40,  //+@@@.....@@@+
    0x0b, 0xff, 0xb2, 0x02, 0xbf, 0xfb, 0x00,  //.%@@%...%@@%.
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0x00,  //..@@@@@@@@@..
    0x00, 0x06, 0xbe, 0xfe, 0xb5, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f4 (ô) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x09, 0xf9, 0x00, 0x00, 0x00,  //.....%@%.....
    0x00, 0x00, 0x2f, 0xff, 0x20, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0xaf, 0x3f, 0xa0, 0x00, 0x00,  //....%@.@%....
    0x00, 0x03, 0xf6, 0x06, 0xf3, 0x00, 0x00,  //....@+.+@....
    0x00, 0x0b, 0xd0, 0x00, 0xdb, 0x00, 0x00,  //...%@...@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x06, 0xbe, 0xfe, 0xb5, 0x00, 0x00,  //...+%@@@%+...
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0x00,  //..@@@@@@@@@..
    0x0b, 0xff, 0xb2, 0x02, 0xbf, 0xfb, 0x00,  //.%@@%...%@@%.
    0x4f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x40,  //+@@@.....@@@+
    0xaf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xa0,  //%@@+.....+@@%
    0xef, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xef, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xaf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xa0,  //%@@+.....+@@%
    0x5f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x40,  //+@@@.....@@@+
    0x0b, 0xff, 0xb2, 0x02, 0xbf, 0xfb, 0x00,  //.%@@%...%@@%.
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0x00,  //..@@@@@@@@@..
    0x00, 0x06, 0xbe, 0xfe, 0xb5, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f5 (õ) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x01, 0xdd, 0x20, 0xcf, 0x00, 0x00,  //....@@..@@...
    0x00, 0x09, 0xff, 0xd1, 0xed, 0x00, 0x00,  //...%@@@.@@...
    0x00, 0x0d, 0xe1, 0xdf, 0xf9, 0x00, 0x00,  //...@@.@@@%...
    0x00, 0x0f, 0xc0, 0x2d, 0xd1, 0x00, 0x00,  //...@@..@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x06, 0xbe, 0xfe, 0xb5, 0x00, 0x00,  //...+%@@@%+...
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0x00,  //..@@@@@@@@@..
    0x0b, 0xff, 0xb2, 0x02, 0xbf, 0xfb, 0x00,  //.%@@%...%@@%.
    0x4f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x40,  //+@@@.....@@@+
    0xaf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xa0,  //%@@+.....+@@%
    0xef, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xef, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xaf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xa0,  //%@@+.....+@@%
    0x5f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x40,  //+@@@.....@@@+
    0x0b, 0xff, 0xb2, 0x02, 0xbf, 0xfb, 0x00,  //.%@@%...%@@%.
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0x00,  //..@@@@@@@@@..
    0x00, 0x06, 0xbe, 0xfe, 0xb5, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f6 (ö) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0xff, 0xf0, 0x00, 0xff, 0xf0, 0x00,  //..@@@...@@@..
    0x00, 0xff, 0xf0, 0x00, 0xff, 0xf0, 0x00,  //..@@@...@@@..
    0x00, 0xff, 0xf0, 0x00, 0xff, 0xf0, 0x00,  //..@@@...@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x06, 0xbe, 0xfe, 0xb5, 0x00, 0x00,  //...+%@@@%+...
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0x00,  //..@@@@@@@@@..
    0x0b, 0xff, 0xb2, 0x02, 0xbf, 0xfb, 0x00,  //.%@@%...%@@%.
    0x4f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x40,  //+@@@.....@@@+
    0xaf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xa0,  //%@@+.....+@@%
    0xef, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xef, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xaf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xa0,  //%@@+.....+@@%
    0x5f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x40,  //+@@@.....@@@+
    0x0b, 0xff, 0xb2, 0x02, 0xbf, 0xfb, 0x00,  //.%@@%...%@@%.
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0x00,  //..@@@@@@@@@..
    0x00, 0x06, 0xbe, 0xfe, 0xb5, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f7 (÷) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f8 (ø) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,  //.............%.
    0x00, 0x00, 0x7c, 0xff, 0xd8, 0x13, 0xff, 0x30,  //....+@@@@%..@@.
    0x00, 0x1d, 0xff, 0xff, 0xff, 0xef, 0xf4, 0x00,  //...@@@@@@@@@@+.
    0x00, 0xcf, 0xfb, 0x20, 0x2c, 0xff, 0x80, 0x00,  //..@@@%...@@@%..
    0x05, 0xff, 0xd0, 0x00, 0x0a, 0xff, 0xf2, 0x00,  //.+@@@....%@@@..
    0x0b, 0xff, 0x60, 0x00, 0x7f, 0xaf, 0xf8, 0x00,  //.%@@+...+@%@@%.
    0x0e, 0xff, 0x20, 0x03, 0xf8, 0x1f, 0xfd, 0x00,  //.@@@....@%.@@@.
    0x0f, 0xff, 0x00, 0x1e, 0xb0, 0x0f, 0xff, 0x00,  //.@@@...@%..@@@.
    0x0f, 0xff, 0x00, 0xce, 0x10, 0x0f, 0xff, 0x00,  //.@@@..@@...@@@.
    0x0d, 0xff, 0x19, 0xf3, 0x00, 0x2f, 0xfe, 0x00,  //.@@@.%@....@@@.
    0x08, 0xff, 0xaf, 0x60, 0x00, 0x6f, 0xfb, 0x00,  //.%@@%@+...+@@%.
    0x01, 0xff, 0xfa, 0x00, 0x00, 0xdf, 0xf5, 0x00,  //..@@@%....@@@+.
    0x00, 0x8f, 0xfb, 0x30, 0x2b, 0xff, 0xc0, 0x00,  //..%@@%...%@@@..
    0x02, 0xff, 0xef, 0xff, 0xff, 0xfd, 0x10, 0x00,  //..@@@@@@@@@@...
    0x1d, 0xf3, 0x18, 0xdf, 0xfc, 0x70, 0x00, 0x00,  //.@@..%@@@@+....
    0x09, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00f9 (ù) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x9f, 0xc0, 0x00, 0x00, 0x00,  //..%@@.......
    0x00, 0x0c, 0xf8, 0x00, 0x00, 0x00,  //...%@%......
    0x00, 0x01, 0xef, 0x30, 0x00, 0x00,  //....@@......
    0x00, 0x00, 0x2f, 0xd0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x05, 0xfa, 0x00, 0x00,  //.....+@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xff,  //@@@......@@@
    0xef, 0xf2, 0x00, 0x00, 0x5f, 0xff,  //@@@.....+@@@
    0xaf, 0xf7, 0x00, 0x00, 0xcf, 0xff,  //%@@+....@@@@
    0x5f, 0xfe, 0x40, 0x2a, 0xaf, 0xff,  //+@@@+..%%@@@
    0x0b, 0xff, 0xff, 0xfd, 0x1f, 0xff,  //.%@@@@@@.@@@
    0x00, 0x7d, 0xfe, 0x91, 0x0f, 0xff,  //..+@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00fa (ú) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0xdf, 0x90,  //........@@%.
    0x00, 0x00, 0x00, 0x08, 0xfc, 0x00,  //.......%@%..
    0x00, 0x00, 0x00, 0x4f, 0xd1, 0x00,  //.......@@...
    0x00, 0x00, 0x00, 0xef, 0x20, 0x00,  //......@@....
    0x00, 0x00, 0x0a, 0xf5, 0x00, 0x00,  //.....%@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xff,  //@@@......@@@
    0xef, 0xf2, 0x00, 0x00, 0x5f, 0xff,  //@@@.....+@@@
    0xaf, 0xf7, 0x00, 0x00, 0xcf, 0xff,  //%@@+....@@@@
    0x5f, 0xfe, 0x40, 0x2a, 0xaf, 0xff,  //+@@@+..%%@@@
    0x0b, 0xff, 0xff, 0xfd, 0x1f, 0xff,  //.%@@@@@@.@@@
    0x00, 0x7d, 0xfe, 0x91, 0x0f, 0xff,  //..+@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00fb (û) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x3f, 0xf3, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0xdf, 0xfd, 0x00, 0x00,  //....@@@@....
    0x00, 0x07, 0xf7, 0x7f, 0x70, 0x00,  //...+@++@+...
    0x00, 0x1f, 0xc0, 0x0c, 0xf1, 0x00,  //...@@..@@...
    0x00, 0xbf, 0x20, 0x02, 0xfb, 0x00,  //..%@....@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xff,  //@@@......@@@
    0xef, 0xf2, 0x00, 0x00, 0x5f, 0xff,  //@@@.....+@@@
    0xaf, 0xf7, 0x00, 0x00, 0xcf, 0xff,  //%@@+....@@@@
    0x5f, 0xfe, 0x40, 0x2a, 0xaf, 0xff,  //+@@@+..%%@@@
    0x0b, 0xff, 0xff, 0xfd, 0x1f, 0xff,  //.%@@@@@@.@@@
    0x00, 0x7d, 0xfe, 0x91, 0x0f, 0xff,  //..+@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00fc (ü) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0xff, 0xf0, 0x0f, 0xff, 0x00,  //..@@@..@@@..
    0x00, 0xff, 0xf0, 0x0f, 0xff, 0x00,  //..@@@..@@@..
    0x00, 0xff, 0xf0, 0x0f, 0xff, 0x00,  //..@@@..@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xff,  //@@@......@@@
    0xef, 0xf2, 0x00, 0x00, 0x5f, 0xff,  //@@@.....+@@@
    0xaf, 0xf7, 0x00, 0x00, 0xcf, 0xff,  //%@@+....@@@@
    0x5f, 0xfe, 0x40, 0x2a, 0xaf, 0xff,  //+@@@+..%%@@@
    0x0b, 0xff, 0xff, 0xfd, 0x1f, 0xff,  //.%@@@@@@.@@@
    0x00, 0x7d, 0xfe, 0x91, 0x0f, 0xff,  //..+@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00fd (ý) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0xdf, 0x90, 0x00,  //........@@%...
    0x00, 0x00, 0x00, 0x08, 0xfc, 0x00, 0x00,  //.......%@%....
    0x00, 0x00, 0x00, 0x4f, 0xd1, 0x00, 0x00,  //.......@@.....
    0x00, 0x00, 0x00, 0xef, 0x20, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x0a, 0xf5, 0x00, 0x00, 0x00,  //.....%@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xcf, 0xf7, 0x00, 0x00, 0x00, 0x7f, 0xfc,  //@@@+......+@@@
    0x6f, 0xfd, 0x00, 0x00, 0x00, 0xef, 0xf5,  //+@@@......@@@+
    0x0e, 0xff, 0x40, 0x00, 0x05, 0xff, 0xe0,  //.@@@+....+@@@.
    0x08, 0xff, 0xa0, 0x00, 0x0c, 0xff, 0x70,  //.%@@%....@@@+.
    0x02, 0xff, 0xf1, 0x00, 0x3f, 0xff, 0x10,  //..@@@....@@@..
    0x00, 0xbf, 0xf7, 0x00, 0xaf, 0xf9, 0x00,  //..%@@+..%@@%..
    0x00, 0x5f, 0xfe, 0x01, 0xff, 0xf2, 0x00,  //..+@@@..@@@...
    0x00, 0x0e, 0xff, 0x58, 0xff, 0xc0, 0x00,  //...@@@++@@%...
    0x00, 0x08, 0xff, 0xbe, 0xff, 0x50, 0x00,  //...+@@%@@@+...
    0x00, 0x01, 0xff, 0xff, 0xfd, 0x00, 0x00,  //....@@@@@@....
    0x00, 0x00, 0xaf, 0xff, 0xf7, 0x00, 0x00,  //....%@@@@+....
    0x00, 0x00, 0x4f, 0xff, 0xf0, 0x00, 0x00,  //....+@@@@.....
    0x00, 0x00, 0x0e, 0xff, 0x90, 0x00, 0x00,  //.....@@@%.....
    0x00, 0x00, 0x1f, 0xff, 0x20, 0x00, 0x00,  //.....@@@......
    0x00, 0x00, 0x8f, 0xfb, 0x00, 0x00, 0x00,  //....%@@%......
    0x00, 0x01, 0xff, 0xf4, 0x00, 0x00, 0x00,  //....@@@+......
    0x00, 0x1b, 0xff, 0xc0, 0x00, 0x00, 0x00,  //...%@@@.......
    0x0f, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00,  //.@@@@@........
    0x0f, 0xfe, 0xb3, 0x00, 0x00, 0x00, 0x00,  //.@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00fe (þ) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x19, 0xef, 0xd8, 0x00, 0x00,  //@@@..%@@@%...
    0xff, 0xf1, 0xdf, 0xff, 0xff, 0xd1, 0x00,  //@@@.@@@@@@@..
    0xff, 0xfb, 0xb2, 0x02, 0xbf, 0xfc, 0x00,  //@@@%%...%@@@.
    0xff, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x50,  //@@@@.....@@@+
    0xff, 0xf5, 0x00, 0x00, 0x05, 0xff, 0xa0,  //@@@+.....+@@%
    0xff, 0xf1, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf1, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf5, 0x00, 0x00, 0x05, 0xff, 0xa0,  //@@@+.....+@@%
    0xff, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x50,  //@@@@.....@@@+
    0xff, 0xfb, 0xb2, 0x02, 0xbf, 0xfc, 0x00,  //@@@%%...%@@@.
    0xff, 0xf1, 0xef, 0xff, 0xff, 0xe2, 0x00,  //@@@.@@@@@@@..
    0xff, 0xf0, 0x19, 0xef, 0xd8, 0x10, 0x00,  //@@@..%@@@%...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00ff (ÿ) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x0f, 0xff, 0x0f, 0xff, 0x00, 0x00,  //...@@@.@@@....
    0x00, 0x0f, 0xff, 0x0f, 0xff, 0x00, 0x00,  //...@@@.@@@....
    0x00, 0x0f, 0xff, 0x0f, 0xff, 0x00, 0x00,  //...@@@.@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xcf, 0xf7, 0x00, 0x00, 0x00, 0x7f, 0xfc,  //@@@+......+@@@
    0x6f, 0xfd, 0x00, 0x00, 0x00, 0xef, 0xf5,  //+@@@......@@@+
    0x0e, 0xff, 0x40, 0x00, 0x05, 0xff, 0xe0,  //.@@@+....+@@@.
    0x08, 0xff, 0xa0, 0x00, 0x0c, 0xff, 0x70,  //.%@@%....@@@+.
    0x02, 0xff, 0xf1, 0x00, 0x3f, 0xff, 0x10,  //..@@@....@@@..
    0x00, 0xbf, 0xf7, 0x00, 0xaf, 0xf9, 0x00,  //..%@@+..%@@%..
    0x00, 0x5f, 0xfe, 0x01, 0xff, 0xf2, 0x00,  //..+@@@..@@@...
    0x00, 0x0e, 0xff, 0x58, 0xff, 0xc0, 0x00,  //...@@@++@@%...
    0x00, 0x08, 0xff, 0xbe, 0xff, 0x50, 0x00,  //...+@@%@@@+...
    0x00, 0x01, 0xff, 0xff, 0xfd, 0x00, 0x00,  //....@@@@@@....
    0x00, 0x00, 0xaf, 0xff, 0xf7, 0x00, 0x00,  //....%@@@@+....
    0x00, 0x00, 0x4f, 0xff, 0xf0, 0x00, 0x00,  //....+@@@@.....
    0x00, 0x00, 0x0e, 0xff, 0x90, 0x00, 0x00,  //.....@@@%.....
    0x00, 0x00, 0x1f, 0xff, 0x20, 0x00, 0x00,  //.....@@@......
    0x00, 0x00, 0x8f, 0xfb, 0x00, 0x00, 0x00,  //....%@@%......
    0x00, 0x01, 0xff, 0xf4, 0x00, 0x00, 0x00,  //....@@@+......
    0x00, 0x1b, 0xff, 0xc0, 0x00, 0x00, 0x00,  //...%@@@.......
    0x0f, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00,  //.@@@@@........
    0x0f, 0xfe, 0xb3, 0x00, 0x00, 0x00, 0x00,  //.@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............



#elif USE_LV_FONT_DEJAVU_30_LATIN_SUP == 8
    /*Unicode: U+00a0 ( ) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00a1 (¡) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xb8, 0xff, 0xba,  //%@%
    0xc8, 0xff, 0xca,  //@@@
    0xda, 0xff, 0xdc,  //@@@
    0xec, 0xff, 0xec,  //@@@
    0xfc, 0xff, 0xfc,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00a2 (¢) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //......@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //......@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //......@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0x00,  //......@....
    0x00, 0x00, 0x00, 0x52, 0xb2, 0xe8, 0xff, 0xea, 0xc4, 0x86, 0x2c,  //...+%@@@@%.
    0x00, 0x0c, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@
    0x00, 0xb4, 0xff, 0xff, 0xb8, 0x2e, 0xff, 0x10, 0x36, 0x70, 0xca,  //.%@@%.@..+@
    0x4a, 0xff, 0xff, 0xd4, 0x04, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //+@@@..@....
    0xa8, 0xff, 0xff, 0x68, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00,  //%@@+..@....
    0xde, 0xff, 0xff, 0x26, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...@....
    0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...@....
    0xf6, 0xff, 0xff, 0x0a, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...@....
    0xe0, 0xff, 0xff, 0x24, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@...@....
    0xaa, 0xff, 0xff, 0x68, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x00,  //%@@+..@....
    0x4c, 0xff, 0xff, 0xd2, 0x04, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x00,  //+@@@..@....
    0x00, 0xba, 0xff, 0xff, 0xb6, 0x2e, 0xfa, 0x12, 0x38, 0x78, 0xd2,  //.%@@%.@..+@
    0x00, 0x0e, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@
    0x00, 0x00, 0x00, 0x5a, 0xb6, 0xea, 0xff, 0xf6, 0xcc, 0x8a, 0x2e,  //...+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //......@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //......@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //......@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //......@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00a3 (£) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xa6, 0xde, 0xf4, 0xf6, 0xce, 0x84, 0x2a,  //......%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....+@@@@@@@@
    0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0xf2, 0x64, 0x14, 0x02, 0x1c, 0x60, 0xc4,  //....@@@+...+@
    0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@+......
    0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x00, 0x00, 0xf4, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00a4 (¤) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x06, 0xae, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xba, 0x0a,  //.%...........%.
    0xae, 0xff, 0xee, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xee, 0xff, 0xb4,  //%@@.........@@%
    0x3a, 0xec, 0xff, 0xe4, 0x3a, 0x96, 0xd8, 0xf4, 0xd6, 0x94, 0x3e, 0xe2, 0xff, 0xe8, 0x30,  //.@@@.%@@@%.@@@.
    0x00, 0x2a, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x22, 0x00,  //..@@@@@@@@@@@..
    0x00, 0x00, 0x34, 0xff, 0xff, 0xa4, 0x26, 0x04, 0x26, 0xa2, 0xff, 0xff, 0x38, 0x00, 0x00,  //...@@%...%@@...
    0x00, 0x00, 0x8e, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0x92, 0x00, 0x00,  //..%@%.....%@%..
    0x00, 0x00, 0xd8, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xd8, 0x00, 0x00,  //..@@.......@@..
    0x00, 0x00, 0xf4, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xf6, 0x00, 0x00,  //..@@.......@@..
    0x00, 0x00, 0xd8, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xff, 0xde, 0x00, 0x00,  //..@@.......@@..
    0x00, 0x00, 0x8c, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0x90, 0x00, 0x00,  //..%@%.....%@%..
    0x00, 0x00, 0x36, 0xff, 0xff, 0xa2, 0x26, 0x04, 0x26, 0xa2, 0xff, 0xff, 0x32, 0x00, 0x00,  //...@@%...%@@...
    0x00, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x26, 0x00,  //..@@@@@@@@@@@..
    0x38, 0xec, 0xff, 0xe0, 0x38, 0x8a, 0xd6, 0xf4, 0xd8, 0x92, 0x34, 0xde, 0xff, 0xea, 0x38,  //.@@@.%@@@%.@@@.
    0xb4, 0xff, 0xe8, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe8, 0xff, 0xa2,  //%@@.........@@%
    0x0a, 0xb4, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x9e, 0x02,  //.%...........%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00a5 (¥) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xb2, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0xb2,  //%@@%.......%@@%
    0x22, 0xf6, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xf6, 0x20,  //.@@@.......@@@.
    0x00, 0x82, 0xff, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0x7e, 0x00,  //.%@@%.....%@@+.
    0x00, 0x08, 0xde, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00, 0x46, 0xff, 0xff, 0xdc, 0x06, 0x00,  //..@@@+...+@@@..
    0x00, 0x00, 0x50, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0xce, 0xff, 0xff, 0x4a, 0x00, 0x00,  //..+@@@...@@@+..
    0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0x52, 0x00, 0x58, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00,  //...%@@+.+@@%...
    0x00, 0x00, 0x00, 0x24, 0xf8, 0xff, 0xd6, 0x08, 0xdc, 0xff, 0xf6, 0x20, 0x00, 0x00, 0x00,  //....@@@.@@@....
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@%@@@@@@.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00a6 (¦) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+00a7 (§) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x18, 0x8c, 0xd2, 0xf0, 0xf4, 0xd2, 0x90, 0x34, 0x00,  //...%@@@@%..
    0x00, 0x34, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..@@@@@@@@.
    0x00, 0xc6, 0xff, 0xba, 0x34, 0x0a, 0x08, 0x32, 0x74, 0xce, 0x00,  //.@@%....+@.
    0x00, 0xf8, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@........
    0x00, 0xe0, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@+.......
    0x00, 0x80, 0xff, 0xfc, 0x8a, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@%......
    0x00, 0x1e, 0xf0, 0xff, 0xff, 0xee, 0x82, 0x0c, 0x00, 0x00, 0x00,  //..@@@@%....
    0x28, 0xea, 0xf2, 0x6e, 0xb6, 0xff, 0xff, 0xea, 0x62, 0x00, 0x00,  //.@@+%@@@+..
    0xb6, 0xff, 0x50, 0x00, 0x00, 0x32, 0xb8, 0xff, 0xff, 0xae, 0x08,  //%@+...%@@%.
    0xf2, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x50, 0xf0, 0xff, 0x8c,  //@@.....+@@%
    0xde, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xe8,  //@@+.....+@@
    0x6e, 0xff, 0xfc, 0x88, 0x0a, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xea,  //+@@%.....@@
    0x00, 0x7c, 0xfa, 0xff, 0xe6, 0x70, 0x08, 0x00, 0x7c, 0xff, 0x98,  //.+@@@+..+@%
    0x00, 0x00, 0x2e, 0xbe, 0xff, 0xff, 0xea, 0xac, 0xff, 0xc2, 0x0c,  //...%@@@%@@.
    0x00, 0x00, 0x00, 0x00, 0x46, 0xc6, 0xff, 0xff, 0xee, 0x10, 0x00,  //....+@@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xec, 0xff, 0x94, 0x00,  //......+@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xea, 0x00,  //........@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xf4, 0x00,  //........@@.
    0x00, 0xce, 0x74, 0x30, 0x08, 0x0a, 0x38, 0xc0, 0xff, 0xb8, 0x00,  //.@+....%@%.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x2a, 0x00,  //.@@@@@@@@..
    0x00, 0x32, 0x8c, 0xd0, 0xf4, 0xf8, 0xdc, 0x94, 0x1c, 0x00, 0x00,  //..%@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00a8 (¨) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00a9 (©) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x7a, 0xc4, 0xe6, 0xf8, 0xe6, 0xc4, 0x7a, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@+......
    0x00, 0x00, 0x00, 0x06, 0x8c, 0xea, 0x8e, 0x40, 0x18, 0x04, 0x16, 0x3e, 0x8c, 0xe8, 0x8a, 0x06, 0x00, 0x00, 0x00,  //....%@%.....%@%....
    0x00, 0x00, 0x12, 0xc4, 0xac, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xa4, 0xc4, 0x12, 0x00, 0x00,  //...@%.........%@...
    0x00, 0x06, 0xc4, 0x90, 0x00, 0x00, 0x0a, 0x72, 0xc6, 0xee, 0xf8, 0xde, 0x9a, 0x32, 0x00, 0x82, 0xc4, 0x04, 0x00,  //..@%...+@@@@%..%@..
    0x00, 0x8c, 0xb0, 0x00, 0x00, 0x22, 0xd8, 0xec, 0x6a, 0x18, 0x04, 0x1c, 0x5a, 0xc0, 0x00, 0x00, 0xa6, 0x8a, 0x00,  //.%%...@@+...+%..%%.
    0x20, 0xec, 0x18, 0x00, 0x08, 0xd6, 0xf6, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xea, 0x1c,  //.@...@@..........@.
    0x7e, 0x92, 0x00, 0x00, 0x6c, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0x7a,  //+%..+@%..........%+
    0xc6, 0x42, 0x00, 0x00, 0xc0, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xc4,  //@+..%@............@
    0xe8, 0x16, 0x00, 0x00, 0xec, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xe6,  //@...@@............@
    0xf8, 0x04, 0x00, 0x00, 0xfa, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf8,  //@...@@............@
    0xe8, 0x16, 0x00, 0x00, 0xec, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xe6,  //@...@@............@
    0xc6, 0x42, 0x00, 0x00, 0xbe, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xc4,  //@+..%@............@
    0x80, 0x92, 0x00, 0x00, 0x6a, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0x7c,  //+%..+@%..........%+
    0x20, 0xee, 0x18, 0x00, 0x08, 0xd6, 0xf6, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xea, 0x1e,  //.@...@@..........@.
    0x00, 0x8c, 0xb2, 0x00, 0x00, 0x22, 0xd8, 0xee, 0x6e, 0x1c, 0x04, 0x20, 0x54, 0xbe, 0x00, 0x00, 0xa6, 0x8a, 0x00,  //.%%...@@+...+%..%%.
    0x00, 0x06, 0xc4, 0x92, 0x00, 0x00, 0x0a, 0x72, 0xc6, 0xee, 0xf6, 0xd8, 0xa4, 0x3e, 0x00, 0x86, 0xc4, 0x04, 0x00,  //..@%...+@@@@%..%@..
    0x00, 0x00, 0x12, 0xc4, 0xb0, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xa6, 0xc4, 0x12, 0x00, 0x00,  //...@%.........%@...
    0x00, 0x00, 0x00, 0x06, 0x8c, 0xec, 0x8e, 0x40, 0x16, 0x04, 0x16, 0x3e, 0x8c, 0xe8, 0x8c, 0x06, 0x00, 0x00, 0x00,  //....%@%.....%@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x7c, 0xc4, 0xe8, 0xf8, 0xe8, 0xc4, 0x7c, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00aa (ª) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x36, 0x94, 0xd6, 0xf6, 0xf8, 0xe2, 0xae, 0x42, 0x00, 0x00,  //..%@@@@%+..
    0x00, 0xc4, 0x60, 0x20, 0x04, 0x10, 0x40, 0xc6, 0xfc, 0x5e, 0x00,  //.@+....@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xda, 0x00,  //........@@.
    0x00, 0x26, 0x96, 0xd6, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00,  //..%@@@@@@@.
    0x40, 0xf6, 0xe2, 0x56, 0x1a, 0x04, 0x00, 0x02, 0xff, 0xff, 0x00,  //.@@+....@@.
    0xcc, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0x00,  //@@......@@.
    0xf8, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0x00,  //@@.....+@@.
    0xe0, 0xff, 0x36, 0x00, 0x00, 0x00, 0x02, 0xd2, 0xff, 0xff, 0x00,  //@@.....@@@.
    0x6c, 0xff, 0xd4, 0x3a, 0x08, 0x26, 0xb0, 0xf6, 0xff, 0xff, 0x00,  //+@@...%@@@.
    0x00, 0x50, 0xc2, 0xec, 0xf6, 0xda, 0x9a, 0x28, 0xff, 0xff, 0x00,  //.+@@@@%.@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x06,  //%@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00ab («) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a,  //.....%.....%
    0x00, 0x00, 0x00, 0x02, 0x9e, 0xff, 0x00, 0x00, 0x00, 0x02, 0x9e, 0xff,  //....%@....%@
    0x00, 0x00, 0x08, 0xb2, 0xff, 0xf2, 0x00, 0x00, 0x08, 0xb2, 0xff, 0xf2,  //...%@@...%@@
    0x00, 0x10, 0xc4, 0xff, 0xea, 0x34, 0x00, 0x10, 0xc4, 0xff, 0xea, 0x36,  //..@@@...@@@.
    0x1a, 0xd2, 0xff, 0xde, 0x24, 0x00, 0x1a, 0xd2, 0xff, 0xde, 0x26, 0x00,  //.@@@...@@@..
    0xe0, 0xff, 0xce, 0x18, 0x00, 0x00, 0xe0, 0xff, 0xd0, 0x18, 0x00, 0x00,  //@@@...@@@...
    0xe0, 0xff, 0xd2, 0x1a, 0x00, 0x00, 0xe0, 0xff, 0xd0, 0x18, 0x00, 0x00,  //@@@...@@@...
    0x1a, 0xd2, 0xff, 0xe0, 0x26, 0x00, 0x1a, 0xd2, 0xff, 0xde, 0x24, 0x00,  //.@@@...@@@..
    0x00, 0x10, 0xc4, 0xff, 0xea, 0x36, 0x00, 0x10, 0xc4, 0xff, 0xea, 0x34,  //..@@@...@@@.
    0x00, 0x00, 0x08, 0xb2, 0xff, 0xf2, 0x00, 0x00, 0x08, 0xb2, 0xff, 0xf2,  //...%@@...%@@
    0x00, 0x00, 0x00, 0x02, 0xa0, 0xff, 0x00, 0x00, 0x00, 0x02, 0xa0, 0xff,  //....%@....%@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a,  //.....%.....%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00ac (¬) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00ad (­) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00ae (®) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x7a, 0xc4, 0xe6, 0xf8, 0xe6, 0xc4, 0x7a, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@+......
    0x00, 0x00, 0x00, 0x06, 0x8c, 0xea, 0x8e, 0x40, 0x18, 0x04, 0x16, 0x3e, 0x8c, 0xe8, 0x8a, 0x06, 0x00, 0x00, 0x00,  //....%@%.....%@%....
    0x00, 0x00, 0x12, 0xc4, 0xac, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xa4, 0xc4, 0x12, 0x00, 0x00,  //...@%.........%@...
    0x00, 0x06, 0xc4, 0x90, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xe6, 0xb8, 0x5c, 0x00, 0x00, 0x82, 0xc4, 0x04, 0x00,  //..@%.@@@@@@%+..%@..
    0x00, 0x8c, 0xb0, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x04, 0x26, 0xac, 0xff, 0x84, 0x00, 0x00, 0xa6, 0x8a, 0x00,  //.%%..@@....%@%..%%.
    0x20, 0xec, 0x18, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xec, 0x00, 0x00, 0x14, 0xea, 0x1c,  //.@...@@.....@@...@.
    0x7e, 0x92, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea, 0x00, 0x00, 0x00, 0x8e, 0x7a,  //+%...@@.....@@...%+
    0xc6, 0x42, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x04, 0x26, 0xac, 0xff, 0x82, 0x00, 0x00, 0x00, 0x40, 0xc4,  //@+...@@....%@%....@
    0xe8, 0x16, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x58, 0x00, 0x00, 0x00, 0x00, 0x16, 0xe6,  //@....@@@@@@@+.....@
    0xf8, 0x04, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x14, 0x9c, 0xff, 0xee, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf8,  //@....@@..%@@......@
    0xe8, 0x16, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x02, 0xcc, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x16, 0xe6,  //@....@@...@@%.....@
    0xc6, 0x42, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x42, 0xff, 0xfc, 0x24, 0x00, 0x00, 0x00, 0x40, 0xc4,  //@+...@@...+@@.....@
    0x80, 0x92, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x8e, 0x7c,  //+%...@@....@@%...%+
    0x20, 0xee, 0x18, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xee, 0x08, 0x00, 0x12, 0xea, 0x1e,  //.@...@@....+@@...@.
    0x00, 0x8c, 0xb2, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x08, 0xec, 0xff, 0x60, 0x00, 0xa6, 0x8a, 0x00,  //.%%..@@.....@@+.%%.
    0x00, 0x06, 0xc4, 0x92, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xca, 0x86, 0xc4, 0x04, 0x00,  //..@%.@@.....%@@%@..
    0x00, 0x00, 0x12, 0xc4, 0xb0, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xa6, 0xc4, 0x12, 0x00, 0x00,  //...@%.........%@...
    0x00, 0x00, 0x00, 0x06, 0x8c, 0xec, 0x8e, 0x40, 0x16, 0x04, 0x16, 0x3e, 0x8c, 0xe8, 0x8c, 0x06, 0x00, 0x00, 0x00,  //....%@%.....%@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x7c, 0xc4, 0xe8, 0xf8, 0xe8, 0xc4, 0x7c, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00af (¯) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00b0 (°) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x28, 0xb0, 0xf2, 0xf0, 0xac, 0x24, 0x00,  //..%@@%..
    0x26, 0xee, 0xff, 0xff, 0xff, 0xff, 0xec, 0x24,  //.@@@@@@.
    0xb0, 0xff, 0xb4, 0x1a, 0x1a, 0xb6, 0xff, 0xac,  //%@%..%@%
    0xf2, 0xff, 0x1a, 0x00, 0x00, 0x1c, 0xff, 0xf0,  //@@....@@
    0xf4, 0xff, 0x18, 0x00, 0x00, 0x18, 0xff, 0xf2,  //@@....@@
    0xb8, 0xff, 0xb2, 0x18, 0x18, 0xb2, 0xff, 0xb2,  //%@%..%@%
    0x32, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xee, 0x28,  //.@@@@@@.
    0x00, 0x32, 0xb8, 0xf4, 0xf2, 0xb0, 0x28, 0x00,  //..%@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00b1 (±) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00b2 (²) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x36, 0x98, 0xdc, 0xf8, 0xe2, 0xb4, 0x40, 0x00,  //.%@@@%..
    0xc4, 0x5e, 0x18, 0x06, 0x34, 0xc8, 0xff, 0x62,  //@+...@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xe0,  //......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xec,  //......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xa0,  //.....%@%
    0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xf0, 0x1c,  //....+@@.
    0x00, 0x00, 0x00, 0x5a, 0xfc, 0xfc, 0x50, 0x00,  //...+@@+.
    0x00, 0x00, 0x58, 0xfa, 0xff, 0x74, 0x00, 0x00,  //..+@@+..
    0x00, 0x60, 0xfc, 0xff, 0x7e, 0x00, 0x00, 0x00,  //.+@@+...
    0x6e, 0xfc, 0xfa, 0x4c, 0x00, 0x00, 0x00, 0x00,  //+@@+....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00b3 (³) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x2e, 0x90, 0xda, 0xf8, 0xe8, 0xc6, 0x70, 0x06,  //.%@@@@+.
    0xc4, 0x5a, 0x1c, 0x06, 0x24, 0x96, 0xff, 0xb0,  //@+...%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf2,  //......@@
    0x00, 0x00, 0x00, 0x02, 0x20, 0x98, 0xff, 0x84,  //.....%@%
    0x00, 0x00, 0xff, 0xff, 0xff, 0xf6, 0x6a, 0x00,  //..@@@@+.
    0x00, 0x00, 0x00, 0x0a, 0x3e, 0xd4, 0xfc, 0x58,  //.....@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xd8,  //......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xf6,  //......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xd0,  //......@@
    0xae, 0x3e, 0x12, 0x0c, 0x48, 0xdc, 0xfa, 0x4c,  //%...+@@+
    0x36, 0xa4, 0xea, 0xfa, 0xe6, 0xac, 0x38, 0x00,  //.%@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00b4 (´) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x06, 0xd0, 0xff, 0x96,  //...@@%
    0x00, 0x00, 0x8c, 0xff, 0xc0, 0x04,  //..%@%.
    0x00, 0x40, 0xfc, 0xde, 0x14, 0x00,  //..@@..
    0x0e, 0xe0, 0xf2, 0x2e, 0x00, 0x00,  //.@@...
    0xa4, 0xff, 0x54, 0x00, 0x00, 0x00,  //%@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+00b5 (µ) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@+....%@@@..
    0xff, 0xff, 0xff, 0xe8, 0x52, 0x0e, 0x1a, 0x70, 0xf6, 0xff, 0xff, 0xff, 0x34, 0x00,  //@@@@+..+@@@@..
    0xff, 0xff, 0xff, 0xb6, 0xff, 0xff, 0xff, 0xff, 0xce, 0xae, 0xff, 0xff, 0xff, 0xff,  //@@@%@@@@@%@@@@
    0xff, 0xff, 0xff, 0x0e, 0xa0, 0xee, 0xf0, 0xa8, 0x14, 0x1a, 0xbc, 0xf4, 0xe4, 0x9c,  //@@@.%@@%..%@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00b6 (¶) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x12, 0x7a, 0xc8, 0xee, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff,  //...+@@@@@@@@
    0x00, 0x3c, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@@
    0x1e, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //.@@@@@@@..@@
    0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //%@@@@@@@..@@
    0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //@@@@@@@@..@@
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //@@@@@@@@..@@
    0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //@@@@@@@@..@@
    0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //%@@@@@@@..@@
    0x3a, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //.@@@@@@@..@@
    0x00, 0x68, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //.+@@@@@@..@@
    0x00, 0x00, 0x30, 0xa8, 0xf0, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //...%@@@@..@@
    0x00, 0x00, 0x00, 0x00, 0x02, 0x20, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //......@@..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00b7 (·) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00b8 (¸) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0xa6, 0xff, 0x48,  //..%@+
    0x00, 0x00, 0x1e, 0xff, 0xbe,  //...@%
    0x00, 0x00, 0x3e, 0xff, 0xf6,  //...@@
    0xff, 0xff, 0xff, 0xff, 0xd2,  //@@@@@
    0xc0, 0xf0, 0xf2, 0xc2, 0x30,  //%@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00b9 (¹) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x26, 0x78, 0xca, 0xff, 0xff, 0x00, 0x00, 0x00,  //.+@@@...
    0xd4, 0x7e, 0x2a, 0xff, 0xff, 0x00, 0x00, 0x00,  //@+.@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00ba (º) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x04, 0x72, 0xcc, 0xf4, 0xf4, 0xce, 0x72, 0x04, 0x00,  //..+@@@@+..
    0x04, 0xba, 0xfc, 0x78, 0x10, 0x10, 0x76, 0xfc, 0xba, 0x04,  //.%@+..+@%.
    0x72, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0x70,  //+@%....%@+
    0xce, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xcc,  //@@......@@
    0xf4, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf4,  //@@......@@
    0xf6, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xf4,  //@@......@@
    0xd0, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xce,  //@@......@@
    0x74, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0x74,  //+@%....%@+
    0x04, 0xbe, 0xfc, 0x78, 0x10, 0x0e, 0x76, 0xfc, 0xbc, 0x04,  //.%@+..+@%.
    0x00, 0x04, 0x74, 0xce, 0xf4, 0xf6, 0xd0, 0x74, 0x04, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x72, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x76,  //+@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00bb (») , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00,  //%.....%.....
    0xff, 0x9e, 0x02, 0x00, 0x00, 0x00, 0xff, 0x9e, 0x02, 0x00, 0x00, 0x00,  //@%....@%....
    0xf2, 0xff, 0xb2, 0x08, 0x00, 0x00, 0xf2, 0xff, 0xb2, 0x08, 0x00, 0x00,  //@@%...@@%...
    0x36, 0xea, 0xff, 0xc2, 0x10, 0x00, 0x34, 0xea, 0xff, 0xc2, 0x10, 0x00,  //.@@@...@@@..
    0x00, 0x26, 0xde, 0xff, 0xd2, 0x1a, 0x00, 0x24, 0xde, 0xff, 0xd2, 0x1a,  //..@@@...@@@.
    0x00, 0x00, 0x18, 0xd2, 0xff, 0xe0, 0x00, 0x00, 0x18, 0xce, 0xff, 0xe0,  //...@@@...@@@
    0x00, 0x00, 0x18, 0xd0, 0xff, 0xe0, 0x00, 0x00, 0x1a, 0xd4, 0xff, 0xe0,  //...@@@...@@@
    0x00, 0x26, 0xde, 0xff, 0xd2, 0x1a, 0x00, 0x26, 0xe0, 0xff, 0xd2, 0x1a,  //..@@@...@@@.
    0x36, 0xea, 0xff, 0xc4, 0x10, 0x00, 0x36, 0xea, 0xff, 0xc4, 0x10, 0x00,  //.@@@...@@@..
    0xf2, 0xff, 0xb2, 0x08, 0x00, 0x00, 0xf2, 0xff, 0xb2, 0x08, 0x00, 0x00,  //@@%...@@%...
    0xff, 0x9e, 0x02, 0x00, 0x00, 0x00, 0xff, 0x9e, 0x02, 0x00, 0x00, 0x00,  //@%....@%....
    0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00,  //%.....%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00bc (¼) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x26, 0x78, 0xca, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@.........%@%......
    0xd4, 0x7e, 0x2a, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xf4, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+.@@........+@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd8, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@........@@+.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xd4, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.......+@@........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf6, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.......@@.........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@......%@%.........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xec, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.....+@@..........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe2, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.....@@+..........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0x00, 0x00,  //...@@....%@@......+@@..
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x2e, 0xfa, 0xfa, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xe8, 0xff, 0xff, 0x00, 0x00,  //...@@....@@.......@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xe2, 0x5a, 0xff, 0xff, 0x00, 0x00,  //@@@@@@@@@@%......@+@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xe4, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xaa, 0x00, 0xff, 0xff, 0x00, 0x00,  //.......+@@......%%.@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xec, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xe6, 0x12, 0x00, 0xff, 0xff, 0x00, 0x00,  //.......@@+.....+@..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xfa, 0x4a, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //......%@%......@+..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xf6, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0x9a, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //......@@......@%...@@..
    0x00, 0x00, 0x00, 0x00, 0x04, 0xd2, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....@@+......@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //....+@@............@@..
    0x00, 0x00, 0x00, 0x1e, 0xf4, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //....@@+............@@..
    0x00, 0x00, 0x00, 0xb0, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //...%@%.............@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00bd (½) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x26, 0x78, 0xca, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@.........%@%.....
    0xd4, 0x7e, 0x2a, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xf4, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+.@@........+@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd8, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@........@@+......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xd4, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.......+@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf6, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.......@@........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@......%@%........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xec, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.....+@@.........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe2, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.....@@+.........
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xc6, 0x00, 0x00, 0x36, 0x98, 0xdc, 0xf8, 0xe2, 0xb4, 0x40, 0x00,  //...@@....%@@...%@@@%..
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x2e, 0xfa, 0xfa, 0x30, 0x00, 0x00, 0xc4, 0x5e, 0x18, 0x06, 0x34, 0xc8, 0xff, 0x62,  //...@@....@@...@+...@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xe0,  //@@@@@@@@@@%.........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xe4, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xec,  //.......+@@..........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xec, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xa0,  //.......@@+.........%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xf0, 0x1c,  //......%@%.........+@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xf6, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xfc, 0xfc, 0x50, 0x00,  //......@@.........+@@+.
    0x00, 0x00, 0x00, 0x00, 0x04, 0xd2, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xfa, 0xff, 0x74, 0x00, 0x00,  //.....@@+........+@@+..
    0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xfc, 0xff, 0x7e, 0x00, 0x00, 0x00,  //....+@@........+@@+...
    0x00, 0x00, 0x00, 0x1e, 0xf4, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xfc, 0xfa, 0x4c, 0x00, 0x00, 0x00, 0x00,  //....@@+.......+@@+....
    0x00, 0x00, 0x00, 0xb0, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...%@%........@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+00be (¾) , Width: 24 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x2e, 0x90, 0xda, 0xf8, 0xe8, 0xc6, 0x70, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@+........%@%......
    0xc4, 0x5a, 0x1c, 0x06, 0x24, 0x96, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xf4, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+...%@%......+@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd8, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@......@@+.......
    0x00, 0x00, 0x00, 0x02, 0x20, 0x98, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xd4, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@%.....+@@........
    0x00, 0x00, 0xff, 0xff, 0xff, 0xf6, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf6, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@+......@@.........
    0x00, 0x00, 0x00, 0x0a, 0x3e, 0xd4, 0xfc, 0x58, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@+....%@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x54, 0xff, 0xec, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@...+@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xf6, 0x00, 0x00, 0x0c, 0xe2, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@...@@+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xd0, 0x00, 0x00, 0x8e, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0x00, 0x00,  //......@@..%@@......+@@..
    0xae, 0x3e, 0x12, 0x0c, 0x48, 0xdc, 0xfa, 0x4c, 0x00, 0x2e, 0xfa, 0xfa, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xe8, 0xff, 0xff, 0x00, 0x00,  //%...+@@+..@@.......@@@..
    0x36, 0xa4, 0xea, 0xfa, 0xe6, 0xac, 0x38, 0x00, 0x00, 0xc6, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xe2, 0x5a, 0xff, 0xff, 0x00, 0x00,  //.%@@@%...@@%......@+@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xe4, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xaa, 0x00, 0xff, 0xff, 0x00, 0x00,  //........+@@......%%.@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xec, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xe6, 0x12, 0x00, 0xff, 0xff, 0x00, 0x00,  //........@@+.....+@..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xfa, 0x4a, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //.......%@%......@+..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xf6, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0x9a, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //.......@@......@%...@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xd2, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //......@@+......@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //.....+@@............@@..
    0x00, 0x00, 0x00, 0x00, 0x1e, 0xf4, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //.....@@+............@@..
    0x00, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //....%@%.............@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................


    /*Unicode: U+00bf (¿) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....@@@...
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....@@@...
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....@@@...
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....@@@...
    0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xee, 0x00, 0x00, 0x00,  //....@@@...
    0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00,  //....@@%...
    0x00, 0x00, 0x00, 0x9c, 0xff, 0xee, 0x28, 0x00, 0x00, 0x00,  //...%@@....
    0x00, 0x00, 0x6a, 0xff, 0xde, 0x28, 0x00, 0x00, 0x00, 0x00,  //..+@@.....
    0x00, 0x70, 0xff, 0xea, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@......
    0x4c, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@+......
    0xcc, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.......
    0xf6, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.......
    0xe0, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x06, 0x9a,  //@@@+.....%
    0x88, 0xff, 0xff, 0xe2, 0x4c, 0x0c, 0x16, 0x62, 0xdc, 0xff,  //%@@@+..+@@
    0x0a, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x5e,  //.@@@@@@@@+
    0x00, 0x04, 0x72, 0xcc, 0xf4, 0xf4, 0xd2, 0x86, 0x16, 0x00,  //..+@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00c0 (À) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xc2, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xff, 0xfc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xff, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x06, 0xee, 0xff, 0xff, 0x72, 0xff, 0xff, 0xee, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xd8, 0x00, 0xd8, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00,  //....+@@@.@@@+....
    0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0x7a, 0x00, 0x7a, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00,  //....%@@+.+@@%....
    0x00, 0x00, 0x00, 0x18, 0xfa, 0xff, 0xfc, 0x1c, 0x00, 0x1e, 0xfc, 0xff, 0xfa, 0x18, 0x00, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00,  //...+@@%...%@@+...
    0x00, 0x00, 0x00, 0xd4, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00,  //...@@@+...+@@@...
    0x00, 0x00, 0x34, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0x32, 0x00, 0x00,  //...@@@.....@@@...
    0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x04, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x04, 0x00,  //..@@@@@@@@@@@@@..
    0x00, 0x52, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0xff, 0xff, 0x50, 0x00,  //.+@@@.......@@@+.
    0x00, 0xb0, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xb0, 0x00,  //.%@@+.......+@@%.
    0x14, 0xfa, 0xff, 0xfc, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xf8, 0x14,  //.@@@.........@@@.
    0x70, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0x6e,  //+@@%.........@@@+
    0xce, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xce,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c1 (Á) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xda, 0xfc, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xbc, 0xfc, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xff, 0xfc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xff, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x06, 0xee, 0xff, 0xff, 0x72, 0xff, 0xff, 0xee, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xd8, 0x00, 0xd8, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00,  //....+@@@.@@@+....
    0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0x7a, 0x00, 0x7a, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00,  //....%@@+.+@@%....
    0x00, 0x00, 0x00, 0x18, 0xfa, 0xff, 0xfc, 0x1c, 0x00, 0x1e, 0xfc, 0xff, 0xfa, 0x18, 0x00, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00,  //...+@@%...%@@+...
    0x00, 0x00, 0x00, 0xd4, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00,  //...@@@+...+@@@...
    0x00, 0x00, 0x34, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0x32, 0x00, 0x00,  //...@@@.....@@@...
    0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x04, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x04, 0x00,  //..@@@@@@@@@@@@@..
    0x00, 0x52, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0xff, 0xff, 0x50, 0x00,  //.+@@@.......@@@+.
    0x00, 0xb0, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xb0, 0x00,  //.%@@+.......+@@%.
    0x14, 0xfa, 0xff, 0xfc, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xf8, 0x14,  //.@@@.........@@@.
    0x70, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0x6e,  //+@@%.........@@@+
    0xce, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xce,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c2 (Â) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xe2, 0xff, 0xe2, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xc2, 0xe2, 0x42, 0xe2, 0xc2, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@+@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xe8, 0x26, 0x00, 0x26, 0xe8, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@...@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xff, 0xfc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xff, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x06, 0xee, 0xff, 0xff, 0x72, 0xff, 0xff, 0xee, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xd8, 0x00, 0xd8, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00,  //....+@@@.@@@+....
    0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0x7a, 0x00, 0x7a, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00,  //....%@@+.+@@%....
    0x00, 0x00, 0x00, 0x18, 0xfa, 0xff, 0xfc, 0x1c, 0x00, 0x1e, 0xfc, 0xff, 0xfa, 0x18, 0x00, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00,  //...+@@%...%@@+...
    0x00, 0x00, 0x00, 0xd4, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00,  //...@@@+...+@@@...
    0x00, 0x00, 0x34, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0x32, 0x00, 0x00,  //...@@@.....@@@...
    0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x04, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x04, 0x00,  //..@@@@@@@@@@@@@..
    0x00, 0x52, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0xff, 0xff, 0x50, 0x00,  //.+@@@.......@@@+.
    0x00, 0xb0, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xb0, 0x00,  //.%@@+.......+@@%.
    0x14, 0xfa, 0xff, 0xfc, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xf8, 0x14,  //.@@@.........@@@.
    0x70, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0x6e,  //+@@%.........@@@+
    0xce, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xce,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c3 (Ã) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xdc, 0xec, 0x8a, 0x14, 0xdc, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@%.@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xdc, 0x16, 0x8e, 0xec, 0xda, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.%@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xff, 0xfc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xff, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x06, 0xee, 0xff, 0xff, 0x72, 0xff, 0xff, 0xee, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xd8, 0x00, 0xd8, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00,  //....+@@@.@@@+....
    0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0x7a, 0x00, 0x7a, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00,  //....%@@+.+@@%....
    0x00, 0x00, 0x00, 0x18, 0xfa, 0xff, 0xfc, 0x1c, 0x00, 0x1e, 0xfc, 0xff, 0xfa, 0x18, 0x00, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00,  //...+@@%...%@@+...
    0x00, 0x00, 0x00, 0xd4, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00,  //...@@@+...+@@@...
    0x00, 0x00, 0x34, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0x32, 0x00, 0x00,  //...@@@.....@@@...
    0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x04, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x04, 0x00,  //..@@@@@@@@@@@@@..
    0x00, 0x52, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0xff, 0xff, 0x50, 0x00,  //.+@@@.......@@@+.
    0x00, 0xb0, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xb0, 0x00,  //.%@@+.......+@@%.
    0x14, 0xfa, 0xff, 0xfc, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xf8, 0x14,  //.@@@.........@@@.
    0x70, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0x6e,  //+@@%.........@@@+
    0xce, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xce,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c4 (Ä) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@.@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@.@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@.@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xff, 0xfc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xff, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x06, 0xee, 0xff, 0xff, 0x72, 0xff, 0xff, 0xee, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xd8, 0x00, 0xd8, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00,  //....+@@@.@@@+....
    0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0x7a, 0x00, 0x7a, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00,  //....%@@+.+@@%....
    0x00, 0x00, 0x00, 0x18, 0xfa, 0xff, 0xfc, 0x1c, 0x00, 0x1e, 0xfc, 0xff, 0xfa, 0x18, 0x00, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00,  //...+@@%...%@@+...
    0x00, 0x00, 0x00, 0xd4, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00,  //...@@@+...+@@@...
    0x00, 0x00, 0x34, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0x32, 0x00, 0x00,  //...@@@.....@@@...
    0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x04, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x04, 0x00,  //..@@@@@@@@@@@@@..
    0x00, 0x52, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0xff, 0xff, 0x50, 0x00,  //.+@@@.......@@@+.
    0x00, 0xb0, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xb0, 0x00,  //.%@@+.......+@@%.
    0x14, 0xfa, 0xff, 0xfc, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xf8, 0x14,  //.@@@.........@@@.
    0x70, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0x6e,  //+@@%.........@@@+
    0xce, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xce,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c5 (Å) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xd0, 0xf2, 0xce, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x74, 0x0a, 0x76, 0xff, 0xde, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@+.+@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xf4, 0xff, 0x0a, 0x00, 0x0a, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@...@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0x76, 0x0a, 0x76, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@+.+@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xb2, 0xff, 0xff, 0xff, 0xb0, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xee, 0xff, 0xff, 0xff, 0xec, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xde, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x22, 0xfc, 0xff, 0xfa, 0x32, 0xfa, 0xff, 0xfc, 0x22, 0x00, 0x00, 0x00, 0x00,  //.....@@@.@@@.....
    0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xb0, 0x00, 0xb0, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00,  //....%@@%.%@@%....
    0x00, 0x00, 0x00, 0x02, 0xe4, 0xff, 0xff, 0x4c, 0x00, 0x4c, 0xff, 0xff, 0xe4, 0x02, 0x00, 0x00, 0x00,  //....@@@+.+@@@....
    0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xe4, 0x02, 0x00, 0x02, 0xe4, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00,  //...+@@@...@@@+...
    0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00,  //...%@@%...%@@%...
    0x00, 0x00, 0x18, 0xfa, 0xff, 0xfc, 0x20, 0x00, 0x00, 0x00, 0x22, 0xfc, 0xff, 0xfa, 0x16, 0x00, 0x00,  //...@@@.....@@@...
    0x00, 0x00, 0x78, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x76, 0x00, 0x00,  //..+@@@@@@@@@@@+..
    0x00, 0x00, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x00, 0x00,  //..@@@@@@@@@@@@@..
    0x00, 0x3e, 0xff, 0xff, 0xee, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xee, 0xff, 0xff, 0x3e, 0x00,  //..@@@.......@@@..
    0x00, 0xa2, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0xa2, 0x00,  //.%@@%.......%@@%.
    0x0e, 0xf6, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xf4, 0x0e,  //.@@@.........@@@.
    0x6a, 0xff, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xff, 0xff, 0x68,  //+@@@.........@@@+
    0xcc, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xcc,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00c6 (Æ) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.......+@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.......@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xe6, 0x02, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@.@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0x82, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@%.@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xfc, 0xff, 0xfc, 0x1c, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@..@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xb2, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@%..@@@.........
    0x00, 0x00, 0x00, 0x00, 0x04, 0xe8, 0xff, 0xff, 0x4a, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@+..@@@.........
    0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@...@@@.........
    0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //....%@@+...@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xfa, 0x18, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //....@@@....@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@%....@@@.........
    0x00, 0x00, 0x06, 0xec, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@+....@@@.........
    0x00, 0x00, 0x5c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@@@@@@@.........
    0x00, 0x00, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@@@@@.........
    0x00, 0x2c, 0xff, 0xff, 0xf8, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@......@@@.........
    0x00, 0x94, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@%......@@@.........
    0x0a, 0xf0, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.......@@@.........
    0x64, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //+@@@.......@@@@@@@@@@@@
    0xca, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@+.......@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+00c7 (Ç) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x08, 0x66, 0xac, 0xde, 0xf2, 0xf6, 0xe0, 0xaa, 0x5e, 0x06, 0x00,  //.....+%@@@@%+..
    0x00, 0x00, 0x00, 0x58, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x52,  //...+@@@@@@@@@@+
    0x00, 0x00, 0x7a, 0xff, 0xff, 0xf8, 0x94, 0x3c, 0x12, 0x06, 0x22, 0x68, 0xd4, 0xff, 0xff,  //..+@@@%....+@@@
    0x00, 0x4e, 0xff, 0xff, 0xe8, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x8a, 0xff,  //.+@@@........%@
    0x04, 0xe0, 0xff, 0xfc, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a,  //.@@@+.........+
    0x56, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%...........
    0x9e, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+...........
    0xd6, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xec, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xec, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xd6, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xa0, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+...........
    0x56, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%...........
    0x04, 0xe0, 0xff, 0xfc, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a,  //.@@@..........+
    0x00, 0x4e, 0xff, 0xff, 0xe6, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x86, 0xff,  //.+@@@........%@
    0x00, 0x00, 0x7a, 0xff, 0xff, 0xf8, 0x92, 0x3c, 0x10, 0x06, 0x20, 0x66, 0xd2, 0xff, 0xff,  //..+@@@%....+@@@
    0x00, 0x00, 0x00, 0x58, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x50,  //...+@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x0a, 0x66, 0xae, 0xde, 0xf4, 0xf6, 0xe0, 0xac, 0x5c, 0x04, 0x00,  //.....+%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0x48, 0x00, 0x00, 0x00,  //.........%@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xbe, 0x00, 0x00, 0x00,  //..........@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xf6, 0x00, 0x00, 0x00,  //..........@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00,  //.......@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xf0, 0xf2, 0xc2, 0x30, 0x00, 0x00, 0x00,  //.......%@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00c8 (È) , Width: 12 */
    0x00, 0x00, 0x00, 0x82, 0xff, 0xc2, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@......
    0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00,  //.....%@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c9 (É) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xda, 0xfc, 0x5a, 0x00, 0x00,  //.......@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xbc, 0xfc, 0x62, 0x00, 0x00, 0x00,  //......%@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00,  //.....%@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00ca (Ê) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x02, 0xac, 0xff, 0xff, 0xac, 0x02, 0x00, 0x00,  //.....%@@%...
    0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0x74, 0x74, 0xff, 0x9a, 0x00, 0x00,  //....%@++@%..
    0x00, 0x00, 0x00, 0x88, 0xfa, 0x60, 0x00, 0x00, 0x60, 0xfa, 0x88, 0x00,  //...%@+..+@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00cb (Ë) , Width: 12 */
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00,  //...@@@..@@@.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00,  //...@@@..@@@.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00,  //...@@@..@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00cc (Ì) , Width: 5 */
    0x82, 0xff, 0xc2, 0x04, 0x00,  //%@@..
    0x00, 0x88, 0xff, 0x9c, 0x00,  //.%@%.
    0x00, 0x00, 0x8e, 0xff, 0x70,  //..%@+
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00cd (Í) , Width: 5 */
    0x00, 0x10, 0xda, 0xfc, 0x5a,  //..@@+
    0x02, 0xbc, 0xfc, 0x62, 0x00,  //.%@+.
    0x94, 0xff, 0x6a, 0x00, 0x00,  //%@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00ce (Î) , Width: 8 */
    0x00, 0x68, 0xfc, 0xff, 0xfc, 0x68, 0x00, 0x00,  //.+@@@+..
    0x70, 0xff, 0xc8, 0x34, 0xc8, 0xff, 0x70, 0x00,  //+@@.@@+.
    0xff, 0xa2, 0x06, 0x00, 0x06, 0xa2, 0xff, 0x7a,  //@%...%@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00cf (Ï) , Width: 7 */
    0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff,  //@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff,  //@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff,  //@@@.@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00d0 (Ð) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf0, 0xe0, 0xc2, 0x90, 0x4c, 0x02, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@%+.....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x5e, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x50, 0xa4, 0xfa, 0xff, 0xff, 0x9a, 0x00, 0x00,  //...@@@.....+%@@@%..
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xe6, 0xff, 0xff, 0x72, 0x00,  //...@@@........@@@+.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xfc, 0xff, 0xee, 0x0e,  //...@@@.........@@@.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0x6a,  //...@@@.........%@@+
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xaa,  //...@@@.........+@@%
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xda,  //...@@@..........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xec,  //@@@@@@@@@@......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@@@@@@@@......@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xec,  //...@@@..........@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xd8,  //...@@@..........@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xa8,  //...@@@.........+@@%
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0x68,  //...@@@.........%@@+
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xfc, 0xff, 0xee, 0x0c,  //...@@@.........@@@.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xe6, 0xff, 0xff, 0x70, 0x00,  //...@@@........@@@+.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x50, 0xa4, 0xfa, 0xff, 0xff, 0x98, 0x00, 0x00,  //...@@@.....+%@@@%..
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x5c, 0x00, 0x00, 0x00,  //...@@@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf0, 0xe2, 0xc4, 0x90, 0x4c, 0x02, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00d1 (Ñ) , Width: 14 */
    0x00, 0x00, 0x00, 0x22, 0xc8, 0xf4, 0xc2, 0x4c, 0x2a, 0xff, 0xec, 0x00, 0x00, 0x00,  //....@@@+.@@...
    0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00,  //...%@@@@@@%...
    0x00, 0x00, 0x00, 0xee, 0xff, 0x28, 0x4e, 0xc4, 0xf6, 0xc6, 0x1e, 0x00, 0x00, 0x00,  //...@@.+@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0xf6, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@.......@@@
    0xff, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@%......@@@
    0xff, 0xff, 0xff, 0xff, 0xfa, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@%.....@@@
    0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@.....@@@
    0xff, 0xff, 0xff, 0xaa, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@%@@%....@@@
    0xff, 0xff, 0xff, 0x2a, 0xfc, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.@@@+...@@@
    0xff, 0xff, 0xff, 0x00, 0xa6, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.%@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x26, 0xfc, 0xff, 0xff, 0x54, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@+..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xd6, 0x02, 0x00, 0xff, 0xff, 0xff,  //@@@..%@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x24, 0xfa, 0xff, 0xff, 0x62, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@+.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xa0, 0xff, 0xff, 0xe2, 0x06, 0xff, 0xff, 0xff,  //@@@...%@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x22, 0xfa, 0xff, 0xff, 0x72, 0xff, 0xff, 0xff,  //@@@....@@@+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xea, 0xff, 0xff, 0xff,  //@@@....%@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x20, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@.....@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@.....%@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xf8, 0xff, 0xff, 0xff, 0xff,  //@@@......@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0xff, 0xff,  //@@@......%@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf6, 0xff, 0xff, 0xff,  //@@@.......@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00d2 (Ò) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xc2, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x06, 0x62, 0xac, 0xde, 0xf2, 0xf4, 0xde, 0xae, 0x64, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x4e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0c, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x6a, 0x00, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x42, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xec, 0xff, 0xfc, 0x40, 0x00,  //.+@@@........@@@..
    0x02, 0xda, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xd8, 0x00,  //.@@@+........+@@@.
    0x50, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x50,  //+@@@..........%@@+
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //%@@+..........+@@%
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@............@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@............@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@............@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@............@@@
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@............@@@
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //%@@+..........+@@%
    0x50, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x50,  //+@@@..........%@@+
    0x02, 0xda, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xd8, 0x00,  //.@@@+........+@@@.
    0x00, 0x42, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xec, 0xff, 0xfc, 0x42, 0x00,  //.+@@@........@@@+.
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0a, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x6c, 0x00, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x4e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x06, 0x62, 0xae, 0xde, 0xf4, 0xf4, 0xde, 0xae, 0x64, 0x08, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d3 (Ó) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xda, 0xfc, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xbc, 0xfc, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........%@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x06, 0x62, 0xac, 0xde, 0xf2, 0xf4, 0xde, 0xae, 0x64, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x4e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0c, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x6a, 0x00, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x42, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xec, 0xff, 0xfc, 0x40, 0x00,  //.+@@@........@@@..
    0x02, 0xda, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xd8, 0x00,  //.@@@+........+@@@.
    0x50, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x50,  //+@@@..........%@@+
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //%@@+..........+@@%
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@............@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@............@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@............@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@............@@@
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@............@@@
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //%@@+..........+@@%
    0x50, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x50,  //+@@@..........%@@+
    0x02, 0xda, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xd8, 0x00,  //.@@@+........+@@@.
    0x00, 0x42, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xec, 0xff, 0xfc, 0x42, 0x00,  //.+@@@........@@@+.
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0a, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x6c, 0x00, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x4e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x06, 0x62, 0xae, 0xde, 0xf4, 0xf4, 0xde, 0xae, 0x64, 0x08, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d4 (Ô) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xac, 0xff, 0xff, 0xac, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0x74, 0x74, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@++@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xfa, 0x60, 0x00, 0x00, 0x60, 0xfa, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@+..+@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x06, 0x62, 0xac, 0xde, 0xf2, 0xf4, 0xde, 0xae, 0x64, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x4e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0c, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x6a, 0x00, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x42, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xec, 0xff, 0xfc, 0x40, 0x00,  //.+@@@........@@@..
    0x02, 0xda, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xd8, 0x00,  //.@@@+........+@@@.
    0x50, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x50,  //+@@@..........%@@+
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //%@@+..........+@@%
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@............@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@............@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@............@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@............@@@
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@............@@@
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //%@@+..........+@@%
    0x50, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x50,  //+@@@..........%@@+
    0x02, 0xda, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xd8, 0x00,  //.@@@+........+@@@.
    0x00, 0x42, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xec, 0xff, 0xfc, 0x42, 0x00,  //.+@@@........@@@+.
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0a, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x6c, 0x00, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x4e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x06, 0x62, 0xae, 0xde, 0xf4, 0xf4, 0xde, 0xae, 0x64, 0x08, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d5 (Õ) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xc8, 0xf4, 0xc2, 0x4c, 0x2a, 0xff, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@+.@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xff, 0x28, 0x4e, 0xc4, 0xf6, 0xc6, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.+@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x06, 0x62, 0xac, 0xde, 0xf2, 0xf4, 0xde, 0xae, 0x64, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x4e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0c, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x6a, 0x00, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x42, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xec, 0xff, 0xfc, 0x40, 0x00,  //.+@@@........@@@..
    0x02, 0xda, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xd8, 0x00,  //.@@@+........+@@@.
    0x50, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x50,  //+@@@..........%@@+
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //%@@+..........+@@%
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@............@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@............@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@............@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@............@@@
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@............@@@
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //%@@+..........+@@%
    0x50, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x50,  //+@@@..........%@@+
    0x02, 0xda, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xd8, 0x00,  //.@@@+........+@@@.
    0x00, 0x42, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xec, 0xff, 0xfc, 0x42, 0x00,  //.+@@@........@@@+.
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0a, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x6c, 0x00, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x4e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x06, 0x62, 0xae, 0xde, 0xf4, 0xf4, 0xde, 0xae, 0x64, 0x08, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d6 (Ö) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@..@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@..@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@..@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x06, 0x62, 0xac, 0xde, 0xf2, 0xf4, 0xde, 0xae, 0x64, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x4e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0c, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x6a, 0x00, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x42, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xec, 0xff, 0xfc, 0x40, 0x00,  //.+@@@........@@@..
    0x02, 0xda, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xd8, 0x00,  //.@@@+........+@@@.
    0x50, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x50,  //+@@@..........%@@+
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //%@@+..........+@@%
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@............@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@............@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@............@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@............@@@
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@............@@@
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //%@@+..........+@@%
    0x50, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x50,  //+@@@..........%@@+
    0x02, 0xda, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xd8, 0x00,  //.@@@+........+@@@.
    0x00, 0x42, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xec, 0xff, 0xfc, 0x42, 0x00,  //.+@@@........@@@+.
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0a, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x6c, 0x00, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x4e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x06, 0x62, 0xae, 0xde, 0xf4, 0xf4, 0xde, 0xae, 0x64, 0x08, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+00d7 (×) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x2e, 0xae, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xae, 0x2c,  //.%...........%.
    0xc6, 0xff, 0xb8, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xb8, 0xff, 0xc4,  //@@%.........%@@
    0x28, 0xe6, 0xff, 0xb6, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xb8, 0xff, 0xe6, 0x26,  //.@@%.......%@@.
    0x00, 0x28, 0xe8, 0xff, 0xb6, 0x06, 0x00, 0x00, 0x00, 0x08, 0xb8, 0xff, 0xe6, 0x26, 0x00,  //..@@%.....%@@..
    0x00, 0x00, 0x2a, 0xe8, 0xff, 0xb4, 0x06, 0x00, 0x08, 0xb8, 0xff, 0xe6, 0x28, 0x00, 0x00,  //...@@%...%@@...
    0x00, 0x00, 0x00, 0x2a, 0xe8, 0xff, 0xb4, 0x0e, 0xb8, 0xff, 0xe6, 0x28, 0x00, 0x00, 0x00,  //....@@%.%@@....
    0x00, 0x00, 0x00, 0x00, 0x2a, 0xe8, 0xff, 0xee, 0xff, 0xe6, 0x28, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x26, 0xe6, 0xff, 0xf2, 0xff, 0xe4, 0x24, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@.....
    0x00, 0x00, 0x00, 0x26, 0xe6, 0xff, 0xb8, 0x12, 0xbe, 0xff, 0xe4, 0x24, 0x00, 0x00, 0x00,  //....@@%.%@@....
    0x00, 0x00, 0x26, 0xe6, 0xff, 0xb8, 0x08, 0x00, 0x08, 0xbe, 0xff, 0xe4, 0x26, 0x00, 0x00,  //...@@%...%@@...
    0x00, 0x26, 0xe6, 0xff, 0xb8, 0x08, 0x00, 0x00, 0x00, 0x08, 0xbc, 0xff, 0xe4, 0x26, 0x00,  //..@@%.....%@@..
    0x26, 0xe6, 0xff, 0xb8, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xbc, 0xff, 0xe6, 0x26,  //.@@%.......%@@.
    0xc4, 0xff, 0xb8, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xba, 0xff, 0xc4,  //@@%.........%@@
    0x2e, 0xae, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xae, 0x2c,  //.%...........%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00d8 (Ø) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x0c, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x0a, 0x68, 0xb2, 0xe0, 0xf4, 0xf2, 0xda, 0xa2, 0x4a, 0x00, 0x00, 0x3c, 0xf4, 0xd0, 0x04,  //.....+%@@@@%+...@@.
    0x00, 0x00, 0x00, 0x52, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x58, 0xf0, 0xf8, 0x4c, 0x00,  //...+@@@@@@@@@@+@@+.
    0x00, 0x00, 0x6e, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0c, 0x0a, 0x34, 0x94, 0xf8, 0xff, 0xff, 0xfa, 0x50, 0x00, 0x00,  //..+@@@%....%@@@@+..
    0x00, 0x44, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xf4, 0x26, 0x00, 0x00,  //.+@@@.......+@@@...
    0x02, 0xdc, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xc0, 0xff, 0xff, 0xff, 0xc4, 0x00, 0x00,  //.@@@+.......%@@@@..
    0x52, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0x94, 0xbe, 0xff, 0xff, 0x3c, 0x00,  //+@@@.......%@%%@@..
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xb2, 0x02, 0x62, 0xff, 0xff, 0x92, 0x00,  //%@@+......%@%.+@@%.
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xcc, 0x0a, 0x00, 0x2a, 0xff, 0xff, 0xce, 0x00,  //@@@......+@@...@@@.
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf8, 0xe0, 0x18, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xea, 0x00,  //@@@......@@....@@@.
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x28, 0xee, 0xf0, 0x2a, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa, 0x00,  //@@@.....@@.....@@@.
    0xec, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x16, 0xde, 0xfa, 0x44, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea, 0x00,  //@@@....@@+.....@@@.
    0xd2, 0xff, 0xff, 0x28, 0x00, 0x08, 0xc8, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd4, 0x00,  //@@@...@@+......@@@.
    0x98, 0xff, 0xff, 0x60, 0x00, 0xae, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9c, 0x00,  //%@@+.%@%......+@@%.
    0x42, 0xff, 0xff, 0xba, 0x8e, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0x52, 0x00,  //+@@%%@%.......@@@+.
    0x00, 0xc8, 0xff, 0xff, 0xff, 0xc0, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xdc, 0x02, 0x00,  //.@@@@%.......+@@@..
    0x00, 0x28, 0xf4, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xee, 0xff, 0xfc, 0x46, 0x00, 0x00,  //..@@@+.......@@@+..
    0x00, 0x3e, 0xf8, 0xff, 0xff, 0xf8, 0x90, 0x32, 0x0a, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00,  //..@@@@%....%@@@+...
    0x22, 0xec, 0xf2, 0x60, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x56, 0x00, 0x00, 0x00, 0x00,  //.@@+@@@@@@@@@@+....
    0xce, 0xf6, 0x40, 0x00, 0x00, 0x4c, 0xa4, 0xda, 0xf4, 0xf6, 0xe2, 0xb4, 0x6a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@...+%@@@@%+......
    0x1c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+00d9 (Ù) , Width: 14 */
    0x00, 0x00, 0x00, 0x82, 0xff, 0xc2, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@........
    0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xf2, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xf0,  //@@@........@@@
    0xd8, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xd6,  //@@@........@@@
    0xa2, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xa0,  //%@@+......+@@%
    0x46, 0xff, 0xff, 0xd2, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd4, 0xff, 0xff, 0x42,  //+@@@......@@@+
    0x00, 0xb6, 0xff, 0xff, 0xbe, 0x3a, 0x08, 0x08, 0x3c, 0xc0, 0xff, 0xff, 0xb2, 0x00,  //.%@@%....%@@%.
    0x00, 0x10, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x0e, 0x00,  //..%@@@@@@@@%..
    0x00, 0x00, 0x00, 0x50, 0xaa, 0xe0, 0xf6, 0xf6, 0xe0, 0xaa, 0x4e, 0x00, 0x00, 0x00,  //...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00da (Ú) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xda, 0xfc, 0x5a, 0x00, 0x00, 0x00, 0x00,  //.......@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xbc, 0xfc, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xf2, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xf0,  //@@@........@@@
    0xd8, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xd6,  //@@@........@@@
    0xa2, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xa0,  //%@@+......+@@%
    0x46, 0xff, 0xff, 0xd2, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd4, 0xff, 0xff, 0x42,  //+@@@......@@@+
    0x00, 0xb6, 0xff, 0xff, 0xbe, 0x3a, 0x08, 0x08, 0x3c, 0xc0, 0xff, 0xff, 0xb2, 0x00,  //.%@@%....%@@%.
    0x00, 0x10, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x0e, 0x00,  //..%@@@@@@@@%..
    0x00, 0x00, 0x00, 0x50, 0xaa, 0xe0, 0xf6, 0xf6, 0xe0, 0xaa, 0x4e, 0x00, 0x00, 0x00,  //...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00db (Û) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x02, 0xac, 0xff, 0xff, 0xac, 0x02, 0x00, 0x00, 0x00, 0x00,  //.....%@@%.....
    0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0x74, 0x74, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00,  //....%@++@%....
    0x00, 0x00, 0x00, 0x88, 0xfa, 0x60, 0x00, 0x00, 0x60, 0xfa, 0x88, 0x00, 0x00, 0x00,  //...%@+..+@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xf2, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xf0,  //@@@........@@@
    0xd8, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xd6,  //@@@........@@@
    0xa2, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xa0,  //%@@+......+@@%
    0x46, 0xff, 0xff, 0xd2, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd4, 0xff, 0xff, 0x42,  //+@@@......@@@+
    0x00, 0xb6, 0xff, 0xff, 0xbe, 0x3a, 0x08, 0x08, 0x3c, 0xc0, 0xff, 0xff, 0xb2, 0x00,  //.%@@%....%@@%.
    0x00, 0x10, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x0e, 0x00,  //..%@@@@@@@@%..
    0x00, 0x00, 0x00, 0x50, 0xaa, 0xe0, 0xf6, 0xf6, 0xe0, 0xaa, 0x4e, 0x00, 0x00, 0x00,  //...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00dc (Ü) , Width: 14 */
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@..@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@..@@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@@..@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xf2, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xf0,  //@@@........@@@
    0xd8, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xd6,  //@@@........@@@
    0xa2, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xa0,  //%@@+......+@@%
    0x46, 0xff, 0xff, 0xd2, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd4, 0xff, 0xff, 0x42,  //+@@@......@@@+
    0x00, 0xb6, 0xff, 0xff, 0xbe, 0x3a, 0x08, 0x08, 0x3c, 0xc0, 0xff, 0xff, 0xb2, 0x00,  //.%@@%....%@@%.
    0x00, 0x10, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x0e, 0x00,  //..%@@@@@@@@%..
    0x00, 0x00, 0x00, 0x50, 0xaa, 0xe0, 0xf6, 0xf6, 0xe0, 0xaa, 0x4e, 0x00, 0x00, 0x00,  //...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00dd (Ý) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xda, 0xfc, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xbc, 0xfc, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......%@+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xa4, 0xff, 0xff, 0xea, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xe8, 0xff, 0xff, 0xa4,  //%@@@.........@@@%
    0x0e, 0xe0, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0xe0, 0x0e,  //.@@@%.......%@@@.
    0x00, 0x3e, 0xfc, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xfc, 0x3e, 0x00,  //..@@@+.....+@@@..
    0x00, 0x00, 0x88, 0xff, 0xff, 0xf4, 0x28, 0x00, 0x00, 0x00, 0x28, 0xf4, 0xff, 0xff, 0x88, 0x00, 0x00,  //..%@@@.....@@@%..
    0x00, 0x00, 0x04, 0xce, 0xff, 0xff, 0xcc, 0x04, 0x00, 0x04, 0xcc, 0xff, 0xff, 0xcc, 0x04, 0x00, 0x00,  //...@@@@...@@@@...
    0x00, 0x00, 0x00, 0x28, 0xf6, 0xff, 0xff, 0x86, 0x00, 0x86, 0xff, 0xff, 0xf4, 0x28, 0x00, 0x00, 0x00,  //....@@@%.%@@@....
    0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xfc, 0x78, 0xfc, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00,  //....+@@@+@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xea, 0xff, 0xff, 0xff, 0xea, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00de (Þ) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xd8, 0x9c, 0x34, 0x00, 0x00,  //@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x78, 0x00,  //@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x1e, 0x76, 0xf8, 0xff, 0xff, 0x44,  //@@@....+@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xb2,  //@@@.....+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe8,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf8,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe8,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xb2,  //@@@.....+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x1c, 0x76, 0xf8, 0xff, 0xff, 0x44,  //@@@....+@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7a, 0x00,  //@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xd8, 0x9e, 0x34, 0x00, 0x00,  //@@@@@@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00df (ß) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x4c, 0xb2, 0xe6, 0xf8, 0xee, 0xbe, 0x56, 0x00, 0x00, 0x00, 0x00,  //..+%@@@%+....
    0x00, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00,  //.%@@@@@@@%...
    0x58, 0xff, 0xff, 0xe4, 0x44, 0x0a, 0x36, 0xd8, 0xff, 0xff, 0x48, 0x00, 0x00,  //+@@@+..@@@+..
    0xc0, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x46, 0xff, 0xff, 0xac, 0x00, 0x00,  //%@@+...+@@%..
    0xf0, 0xff, 0xff, 0x16, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xe2, 0x00, 0x00,  //@@@.....@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x94, 0xfc, 0xff, 0xfc, 0xce, 0x00, 0x00,  //@@@...%@@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xce, 0x24, 0x00, 0x00, 0x00,  //@@@..+@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0xd2, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,  //@@@..@@@.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0xf4, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00,  //@@@..@@@.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0xd6, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..@@@.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x56, 0xfc, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x00,  //@@@..+@@.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x4e, 0xe0, 0xfa, 0x9e, 0x1a, 0x00, 0x00,  //@@@...+@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x06, 0xfa, 0xff, 0xf2, 0x5e, 0x00,  //@@@.....@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xe6, 0xff, 0xff, 0x58,  //@@@......@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xff, 0xd2,  //@@@......+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf6,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0xbe, 0x52, 0x1c, 0x08, 0x36, 0xca, 0xff, 0xff, 0x8c,  //@@@.%+...@@@%
    0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0x0e,  //@@@.@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x34, 0x9e, 0xe4, 0xfa, 0xee, 0xc4, 0x70, 0x06, 0x00,  //@@@..%@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00e0 (à) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x96, 0xff, 0xca, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@.......
    0x00, 0x00, 0x04, 0xc0, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@%......
    0x00, 0x00, 0x00, 0x14, 0xe0, 0xfc, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@......
    0x00, 0x00, 0x00, 0x00, 0x2e, 0xf4, 0xde, 0x0e, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00,  //.....+@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x2a, 0x7c, 0xbc, 0xe6, 0xf8, 0xf2, 0xd8, 0x9c, 0x30, 0x00, 0x00,  //..+%@@@@%...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x6c, 0x00,  //.@@@@@@@@@+.
    0x00, 0xc6, 0x68, 0x2a, 0x0a, 0x06, 0x24, 0x7e, 0xf6, 0xff, 0xfc, 0x34,  //.@+....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xa2,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xde,  //.........@@@
    0x00, 0x00, 0x50, 0xaa, 0xdc, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //..+%@@@@@@@@
    0x06, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@
    0x80, 0xff, 0xff, 0xe0, 0x54, 0x1a, 0x04, 0x00, 0x04, 0xff, 0xff, 0xff,  //+@@@+....@@@
    0xda, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xff,  //@@@......@@@
    0xf8, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff,  //@@@.....+@@@
    0xea, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x04, 0xd4, 0xff, 0xff, 0xff,  //@@@.....@@@@
    0xa4, 0xff, 0xff, 0xce, 0x32, 0x06, 0x2c, 0xb6, 0xae, 0xff, 0xff, 0xff,  //%@@@...%%@@@
    0x22, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x18, 0xff, 0xff, 0xff,  //.@@@@@@@.@@@
    0x00, 0x20, 0xa2, 0xe8, 0xf8, 0xdc, 0x8c, 0x12, 0x00, 0xff, 0xff, 0xff,  //..%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e1 (á) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd0, 0xff, 0x96, 0x00,  //........@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xc0, 0x04, 0x00,  //.......%@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xfc, 0xde, 0x14, 0x00, 0x00,  //.......@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe0, 0xf2, 0x2e, 0x00, 0x00, 0x00,  //......@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00,  //.....%@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x2a, 0x7c, 0xbc, 0xe6, 0xf8, 0xf2, 0xd8, 0x9c, 0x30, 0x00, 0x00,  //..+%@@@@%...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x6c, 0x00,  //.@@@@@@@@@+.
    0x00, 0xc6, 0x68, 0x2a, 0x0a, 0x06, 0x24, 0x7e, 0xf6, 0xff, 0xfc, 0x34,  //.@+....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xa2,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xde,  //.........@@@
    0x00, 0x00, 0x50, 0xaa, 0xdc, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //..+%@@@@@@@@
    0x06, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@
    0x80, 0xff, 0xff, 0xe0, 0x54, 0x1a, 0x04, 0x00, 0x04, 0xff, 0xff, 0xff,  //+@@@+....@@@
    0xda, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xff,  //@@@......@@@
    0xf8, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff,  //@@@.....+@@@
    0xea, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x04, 0xd4, 0xff, 0xff, 0xff,  //@@@.....@@@@
    0xa4, 0xff, 0xff, 0xce, 0x32, 0x06, 0x2c, 0xb6, 0xae, 0xff, 0xff, 0xff,  //%@@@...%%@@@
    0x22, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x18, 0xff, 0xff, 0xff,  //.@@@@@@@.@@@
    0x00, 0x20, 0xa2, 0xe8, 0xf8, 0xdc, 0x8c, 0x12, 0x00, 0xff, 0xff, 0xff,  //..%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e2 (â) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x3a, 0xfc, 0xfc, 0x3a, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x04, 0xd2, 0xf8, 0xf8, 0xd2, 0x02, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x74, 0xff, 0x76, 0x78, 0xff, 0x74, 0x00, 0x00, 0x00,  //...+@++@+...
    0x00, 0x00, 0x1c, 0xf2, 0xc4, 0x00, 0x02, 0xc4, 0xf2, 0x1c, 0x00, 0x00,  //...@@..@@...
    0x00, 0x00, 0xb0, 0xf2, 0x22, 0x00, 0x00, 0x22, 0xf2, 0xb0, 0x00, 0x00,  //..%@....@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x2a, 0x7c, 0xbc, 0xe6, 0xf8, 0xf2, 0xd8, 0x9c, 0x30, 0x00, 0x00,  //..+%@@@@%...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x6c, 0x00,  //.@@@@@@@@@+.
    0x00, 0xc6, 0x68, 0x2a, 0x0a, 0x06, 0x24, 0x7e, 0xf6, 0xff, 0xfc, 0x34,  //.@+....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xa2,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xde,  //.........@@@
    0x00, 0x00, 0x50, 0xaa, 0xdc, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //..+%@@@@@@@@
    0x06, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@
    0x80, 0xff, 0xff, 0xe0, 0x54, 0x1a, 0x04, 0x00, 0x04, 0xff, 0xff, 0xff,  //+@@@+....@@@
    0xda, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xff,  //@@@......@@@
    0xf8, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff,  //@@@.....+@@@
    0xea, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x04, 0xd4, 0xff, 0xff, 0xff,  //@@@.....@@@@
    0xa4, 0xff, 0xff, 0xce, 0x32, 0x06, 0x2c, 0xb6, 0xae, 0xff, 0xff, 0xff,  //%@@@...%%@@@
    0x22, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x18, 0xff, 0xff, 0xff,  //.@@@@@@@.@@@
    0x00, 0x20, 0xa2, 0xe8, 0xf8, 0xdc, 0x8c, 0x12, 0x00, 0xff, 0xff, 0xff,  //..%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e3 (ã) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x10, 0xc0, 0xee, 0x84, 0x00, 0x06, 0xff, 0xf0, 0x00, 0x00,  //...%@%..@@..
    0x00, 0x00, 0x86, 0xff, 0xff, 0xff, 0x68, 0x40, 0xff, 0xd4, 0x00, 0x00,  //..%@@@+.@@..
    0x00, 0x00, 0xd4, 0xff, 0x3e, 0x68, 0xff, 0xff, 0xff, 0x86, 0x00, 0x00,  //..@@.+@@@%..
    0x00, 0x00, 0xf2, 0xff, 0x06, 0x00, 0x86, 0xee, 0xc2, 0x12, 0x00, 0x00,  //..@@..%@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x2a, 0x7c, 0xbc, 0xe6, 0xf8, 0xf2, 0xd8, 0x9c, 0x30, 0x00, 0x00,  //..+%@@@@%...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x6c, 0x00,  //.@@@@@@@@@+.
    0x00, 0xc6, 0x68, 0x2a, 0x0a, 0x06, 0x24, 0x7e, 0xf6, 0xff, 0xfc, 0x34,  //.@+....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xa2,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xde,  //.........@@@
    0x00, 0x00, 0x50, 0xaa, 0xdc, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //..+%@@@@@@@@
    0x06, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@
    0x80, 0xff, 0xff, 0xe0, 0x54, 0x1a, 0x04, 0x00, 0x04, 0xff, 0xff, 0xff,  //+@@@+....@@@
    0xda, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xff,  //@@@......@@@
    0xf8, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff,  //@@@.....+@@@
    0xea, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x04, 0xd4, 0xff, 0xff, 0xff,  //@@@.....@@@@
    0xa4, 0xff, 0xff, 0xce, 0x32, 0x06, 0x2c, 0xb6, 0xae, 0xff, 0xff, 0xff,  //%@@@...%%@@@
    0x22, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x18, 0xff, 0xff, 0xff,  //.@@@@@@@.@@@
    0x00, 0x20, 0xa2, 0xe8, 0xf8, 0xdc, 0x8c, 0x12, 0x00, 0xff, 0xff, 0xff,  //..%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e4 (ä) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x2a, 0x7c, 0xbc, 0xe6, 0xf8, 0xf2, 0xd8, 0x9c, 0x30, 0x00, 0x00,  //..+%@@@@%...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x6c, 0x00,  //.@@@@@@@@@+.
    0x00, 0xc6, 0x68, 0x2a, 0x0a, 0x06, 0x24, 0x7e, 0xf6, 0xff, 0xfc, 0x34,  //.@+....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xa2,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xde,  //.........@@@
    0x00, 0x00, 0x50, 0xaa, 0xdc, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //..+%@@@@@@@@
    0x06, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@
    0x80, 0xff, 0xff, 0xe0, 0x54, 0x1a, 0x04, 0x00, 0x04, 0xff, 0xff, 0xff,  //+@@@+....@@@
    0xda, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xff,  //@@@......@@@
    0xf8, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff,  //@@@.....+@@@
    0xea, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x04, 0xd4, 0xff, 0xff, 0xff,  //@@@.....@@@@
    0xa4, 0xff, 0xff, 0xce, 0x32, 0x06, 0x2c, 0xb6, 0xae, 0xff, 0xff, 0xff,  //%@@@...%%@@@
    0x22, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x18, 0xff, 0xff, 0xff,  //.@@@@@@@.@@@
    0x00, 0x20, 0xa2, 0xe8, 0xf8, 0xdc, 0x8c, 0x12, 0x00, 0xff, 0xff, 0xff,  //..%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e5 (å) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x5a, 0xd6, 0xf8, 0xd6, 0x58, 0x00, 0x00, 0x00,  //....+@@@+...
    0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x58, 0x00, 0x00,  //...+@@@@@+..
    0x00, 0x00, 0x00, 0xd6, 0xff, 0x74, 0x0a, 0x76, 0xff, 0xd6, 0x00, 0x00,  //...@@+.+@@..
    0x00, 0x00, 0x00, 0xf8, 0xff, 0x0a, 0x00, 0x0a, 0xff, 0xf8, 0x00, 0x00,  //...@@...@@..
    0x00, 0x00, 0x00, 0xd6, 0xff, 0x72, 0x0a, 0x76, 0xff, 0xd6, 0x00, 0x00,  //...@@+.+@@..
    0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x58, 0x00, 0x00,  //...+@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x5a, 0xd6, 0xf8, 0xd6, 0x5a, 0x00, 0x00, 0x00,  //....+@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x2a, 0x7c, 0xbc, 0xe6, 0xf8, 0xf2, 0xd8, 0x9c, 0x30, 0x00, 0x00,  //..+%@@@@%...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x6c, 0x00,  //.@@@@@@@@@+.
    0x00, 0xc6, 0x68, 0x2a, 0x0a, 0x06, 0x24, 0x7e, 0xf6, 0xff, 0xfc, 0x34,  //.@+....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xa2,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xde,  //.........@@@
    0x00, 0x00, 0x50, 0xaa, 0xdc, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //..+%@@@@@@@@
    0x06, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@
    0x80, 0xff, 0xff, 0xe0, 0x54, 0x1a, 0x04, 0x00, 0x04, 0xff, 0xff, 0xff,  //+@@@+....@@@
    0xda, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xff,  //@@@......@@@
    0xf8, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff,  //@@@.....+@@@
    0xea, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x04, 0xd4, 0xff, 0xff, 0xff,  //@@@.....@@@@
    0xa4, 0xff, 0xff, 0xce, 0x32, 0x06, 0x2c, 0xb6, 0xae, 0xff, 0xff, 0xff,  //%@@@...%%@@@
    0x22, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x18, 0xff, 0xff, 0xff,  //.@@@@@@@.@@@
    0x00, 0x20, 0xa2, 0xe8, 0xf8, 0xdc, 0x8c, 0x12, 0x00, 0xff, 0xff, 0xff,  //..%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00e6 (æ) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x2a, 0x7e, 0xbc, 0xe6, 0xfa, 0xf0, 0xd4, 0x92, 0x28, 0x00, 0x00, 0x2a, 0x96, 0xd8, 0xf2, 0xf4, 0xd2, 0x84, 0x10, 0x00, 0x00,  //..+%@@@@%....%@@@@%...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x6c, 0x7e, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x2c, 0x00,  //.@@@@@@@@@++@@@@@@@@..
    0x00, 0xc6, 0x68, 0x2a, 0x0a, 0x06, 0x24, 0x7e, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x3a, 0x06, 0x18, 0x8c, 0xff, 0xff, 0xdc, 0x0a,  //.@+....+@@@@@@...%@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0xde, 0x08, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x6e,  //........+@@@@.....%@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xbe,  //.........@@@+......@@%
    0x00, 0x00, 0x50, 0xaa, 0xdc, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xea,  //..+%@@@@@@@@.......@@@
    0x06, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xfa, 0xfc, 0xfc, 0xfc, 0xfc, 0xff, 0xff, 0xff, 0xfa,  //.%@@@@@@@@@@@@@@@@@@@@
    0x80, 0xff, 0xff, 0xe0, 0x54, 0x1a, 0x04, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //+@@@+....@@@@@@@@@@@@@
    0xda, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xff, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@......@@@..........
    0xf8, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....+@@@+.........
    0xea, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xde, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....%@@@@.........
    0xa4, 0xff, 0xff, 0xce, 0x32, 0x06, 0x26, 0xa8, 0xff, 0xca, 0x6a, 0xff, 0xff, 0xd2, 0x52, 0x12, 0x02, 0x0e, 0x34, 0x74, 0xcc, 0x00,  //%@@@...%@@+@@@+....+@.
    0x1e, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x1c, 0x00, 0x74, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@..+@@@@@@@@@.
    0x00, 0x16, 0x90, 0xda, 0xf8, 0xee, 0xc8, 0x6e, 0x08, 0x00, 0x00, 0x00, 0x2a, 0x90, 0xd4, 0xf0, 0xf8, 0xe6, 0xbc, 0x74, 0x26, 0x00,  //..%@@@@+.....%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+00e7 (ç) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x3e, 0xa2, 0xdc, 0xf4, 0xf6, 0xd8, 0x9a, 0x38,  //....%@@@@%.
    0x00, 0x06, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@
    0x00, 0xa2, 0xff, 0xff, 0xe2, 0x5c, 0x14, 0x04, 0x1c, 0x5a, 0xc0,  //.%@@@+...+%
    0x40, 0xff, 0xff, 0xea, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.......
    0xa2, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.......
    0xde, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xf6, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xf6, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xdc, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xa2, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.......
    0x3e, 0xff, 0xff, 0xea, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.......
    0x00, 0xa0, 0xff, 0xff, 0xe2, 0x5c, 0x14, 0x02, 0x1c, 0x5a, 0xc0,  //.%@@@+...+%
    0x00, 0x06, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@
    0x00, 0x00, 0x00, 0x42, 0xa6, 0xe0, 0xf8, 0xf4, 0xd6, 0x98, 0x38,  //...+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0x48, 0x00,  //.......%@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xbe, 0x00,  //........@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xf6, 0x00,  //........@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x00,  //.....@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xf0, 0xf2, 0xc2, 0x30, 0x00,  //.....%@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00e8 (è) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x96, 0xff, 0xca, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@.......
    0x00, 0x00, 0x00, 0x04, 0xc0, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@%......
    0x00, 0x00, 0x00, 0x00, 0x14, 0xe0, 0xfc, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xf4, 0xde, 0x0e, 0x00, 0x00, 0x00, 0x00,  //......@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00,  //......+@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x3c, 0xa2, 0xde, 0xf6, 0xf0, 0xca, 0x78, 0x0a, 0x00, 0x00,  //....%@@@@+...
    0x00, 0x04, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x20, 0x00,  //..%@@@@@@@@..
    0x00, 0x96, 0xff, 0xff, 0xc4, 0x3a, 0x06, 0x18, 0x8c, 0xff, 0xff, 0xce, 0x04,  //.%@@@...%@@@.
    0x34, 0xff, 0xff, 0xde, 0x08, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x60,  //.@@@.....%@@+
    0x9a, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xb4,  //%@@+......@@%
    0xd8, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xe6,  //@@@.......@@@
    0xf4, 0xff, 0xff, 0xfa, 0xfa, 0xfc, 0xfc, 0xfc, 0xfc, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@
    0xe0, 0xff, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xa4, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.........
    0x40, 0xff, 0xff, 0xde, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.........
    0x00, 0xa0, 0xff, 0xff, 0xd2, 0x54, 0x14, 0x02, 0x0e, 0x32, 0x72, 0xcc, 0x00,  //.%@@@+....+@.
    0x00, 0x06, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0x00, 0x00, 0x3c, 0xa0, 0xdc, 0xf6, 0xf8, 0xe4, 0xbc, 0x74, 0x26, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00e9 (é) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd0, 0xff, 0x96, 0x00,  //.........@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xc0, 0x04, 0x00,  //........%@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xfc, 0xde, 0x14, 0x00, 0x00,  //........@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe0, 0xf2, 0x2e, 0x00, 0x00, 0x00,  //.......@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00,  //......%@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x3c, 0xa2, 0xde, 0xf6, 0xf0, 0xca, 0x78, 0x0a, 0x00, 0x00,  //....%@@@@+...
    0x00, 0x04, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x20, 0x00,  //..%@@@@@@@@..
    0x00, 0x96, 0xff, 0xff, 0xc4, 0x3a, 0x06, 0x18, 0x8c, 0xff, 0xff, 0xce, 0x04,  //.%@@@...%@@@.
    0x34, 0xff, 0xff, 0xde, 0x08, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x60,  //.@@@.....%@@+
    0x9a, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xb4,  //%@@+......@@%
    0xd8, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xe6,  //@@@.......@@@
    0xf4, 0xff, 0xff, 0xfa, 0xfa, 0xfc, 0xfc, 0xfc, 0xfc, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@
    0xe0, 0xff, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xa4, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.........
    0x40, 0xff, 0xff, 0xde, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.........
    0x00, 0xa0, 0xff, 0xff, 0xd2, 0x54, 0x14, 0x02, 0x0e, 0x32, 0x72, 0xcc, 0x00,  //.%@@@+....+@.
    0x00, 0x06, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0x00, 0x00, 0x3c, 0xa0, 0xdc, 0xf6, 0xf8, 0xe4, 0xbc, 0x74, 0x26, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00ea (ê) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x04, 0xd0, 0xff, 0xda, 0x0a, 0x00, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xf0, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00,  //....%@@@%....
    0x00, 0x00, 0x00, 0x38, 0xfc, 0xde, 0x1c, 0xd4, 0xff, 0x46, 0x00, 0x00, 0x00,  //....@@.@@+...
    0x00, 0x00, 0x0a, 0xda, 0xf6, 0x32, 0x00, 0x28, 0xf2, 0xe4, 0x10, 0x00, 0x00,  //...@@...@@...
    0x00, 0x00, 0x96, 0xff, 0x64, 0x00, 0x00, 0x00, 0x56, 0xff, 0xa6, 0x00, 0x00,  //..%@+...+@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x3c, 0xa2, 0xde, 0xf6, 0xf0, 0xca, 0x78, 0x0a, 0x00, 0x00,  //....%@@@@+...
    0x00, 0x04, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x20, 0x00,  //..%@@@@@@@@..
    0x00, 0x96, 0xff, 0xff, 0xc4, 0x3a, 0x06, 0x18, 0x8c, 0xff, 0xff, 0xce, 0x04,  //.%@@@...%@@@.
    0x34, 0xff, 0xff, 0xde, 0x08, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x60,  //.@@@.....%@@+
    0x9a, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xb4,  //%@@+......@@%
    0xd8, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xe6,  //@@@.......@@@
    0xf4, 0xff, 0xff, 0xfa, 0xfa, 0xfc, 0xfc, 0xfc, 0xfc, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@
    0xe0, 0xff, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xa4, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.........
    0x40, 0xff, 0xff, 0xde, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.........
    0x00, 0xa0, 0xff, 0xff, 0xd2, 0x54, 0x14, 0x02, 0x0e, 0x32, 0x72, 0xcc, 0x00,  //.%@@@+....+@.
    0x00, 0x06, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0x00, 0x00, 0x3c, 0xa0, 0xdc, 0xf6, 0xf8, 0xe4, 0xbc, 0x74, 0x26, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00eb (ë) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00,  //....@@@..@@@.
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00,  //....@@@..@@@.
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00,  //....@@@..@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x3c, 0xa2, 0xde, 0xf6, 0xf0, 0xca, 0x78, 0x0a, 0x00, 0x00,  //....%@@@@+...
    0x00, 0x04, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x20, 0x00,  //..%@@@@@@@@..
    0x00, 0x96, 0xff, 0xff, 0xc4, 0x3a, 0x06, 0x18, 0x8c, 0xff, 0xff, 0xce, 0x04,  //.%@@@...%@@@.
    0x34, 0xff, 0xff, 0xde, 0x08, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x60,  //.@@@.....%@@+
    0x9a, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xb4,  //%@@+......@@%
    0xd8, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xe6,  //@@@.......@@@
    0xf4, 0xff, 0xff, 0xfa, 0xfa, 0xfc, 0xfc, 0xfc, 0xfc, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@
    0xe0, 0xff, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xa4, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.........
    0x40, 0xff, 0xff, 0xde, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.........
    0x00, 0xa0, 0xff, 0xff, 0xd2, 0x54, 0x14, 0x02, 0x0e, 0x32, 0x72, 0xcc, 0x00,  //.%@@@+....+@.
    0x00, 0x06, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0x00, 0x00, 0x3c, 0xa0, 0xdc, 0xf6, 0xf8, 0xe4, 0xbc, 0x74, 0x26, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00ec (ì) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xca, 0x04, 0x00, 0x00,  //@@...
    0xc0, 0xff, 0x84, 0x00, 0x00,  //%@%..
    0x14, 0xe0, 0xfc, 0x3c, 0x00,  //.@@..
    0x00, 0x2e, 0xf4, 0xde, 0x0e,  //..@@.
    0x00, 0x00, 0x54, 0xff, 0xa4,  //..+@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00ed (í) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x06, 0xd0, 0xff, 0x96,  //...@@%
    0x00, 0x00, 0x8c, 0xff, 0xc0, 0x04,  //..%@%.
    0x00, 0x40, 0xfc, 0xde, 0x14, 0x00,  //..@@..
    0x0e, 0xe0, 0xf2, 0x2e, 0x00, 0x00,  //.@@...
    0xa4, 0xff, 0x54, 0x00, 0x00, 0x00,  //%@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+00ee (î) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x08, 0xd6, 0xff, 0xd6, 0x08, 0x00, 0x00,  //..@@@...
    0x00, 0x92, 0xff, 0xf0, 0xff, 0x90, 0x00, 0x00,  //.%@@@%..
    0x44, 0xfc, 0xd8, 0x1a, 0xd8, 0xfc, 0x42, 0x00,  //+@@.@@+.
    0xe2, 0xf4, 0x2a, 0x00, 0x2a, 0xf4, 0xe2, 0x10,  //@@...@@.
    0xff, 0x5a, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xa6,  //@+...+@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00ef (ï) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff,  //@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff,  //@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff,  //@@@.@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00f0 (ð) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x94, 0xff, 0xd8, 0x0a, 0x00, 0x00, 0x0c, 0x52, 0x00, 0x00,  //...%@@....+..
    0x00, 0x00, 0x00, 0x06, 0xce, 0xff, 0xa2, 0x52, 0xac, 0xf6, 0xf4, 0x24, 0x00,  //....@@%+%@@..
    0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xfa, 0xb8, 0x5c, 0x0c, 0x00, 0x00,  //....+@@@%+...
    0x00, 0x10, 0x6a, 0xca, 0xff, 0xe6, 0xff, 0xf0, 0x22, 0x00, 0x00, 0x00, 0x00,  //..+@@@@@.....
    0x00, 0x3c, 0xf2, 0x9e, 0x3e, 0x00, 0xa8, 0xff, 0xca, 0x04, 0x00, 0x00, 0x00,  //..@%..%@@....
    0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x0e, 0xdc, 0xff, 0x96, 0x00, 0x00, 0x00,  //.......@@%...
    0x00, 0x00, 0x02, 0x64, 0xc2, 0xee, 0xf6, 0xf0, 0xff, 0xff, 0x74, 0x00, 0x00,  //...+@@@@@@+..
    0x00, 0x0e, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x40, 0x00,  //..%@@@@@@@@..
    0x00, 0xb2, 0xff, 0xff, 0xca, 0x3e, 0x08, 0x10, 0x54, 0xf8, 0xff, 0xd4, 0x04,  //.%@@@...+@@@.
    0x46, 0xff, 0xff, 0xdc, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x52,  //+@@@.....%@@+
    0xa6, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xa8,  //%@@+.....+@@%
    0xde, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xd8,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf2,  //@@@.......@@@
    0xf4, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@.......@@@
    0xdc, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xda,  //@@@.......@@@
    0xa0, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0x9e,  //%@@+.....+@@%
    0x3e, 0xff, 0xff, 0xdc, 0x08, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x3a,  //.@@@.....@@@.
    0x00, 0xa4, 0xff, 0xff, 0xbc, 0x2c, 0x04, 0x2c, 0xbc, 0xff, 0xff, 0x9e, 0x00,  //.%@@%...%@@%.
    0x00, 0x08, 0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x06, 0x00,  //..%@@@@@@@%..
    0x00, 0x00, 0x00, 0x52, 0xb4, 0xe8, 0xf8, 0xe8, 0xb2, 0x4e, 0x00, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f1 (ñ) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x10, 0xc0, 0xee, 0x84, 0x00, 0x06, 0xff, 0xf0, 0x00, 0x00,  //...%@%..@@..
    0x00, 0x00, 0x86, 0xff, 0xff, 0xff, 0x68, 0x40, 0xff, 0xd4, 0x00, 0x00,  //..%@@@+.@@..
    0x00, 0x00, 0xd4, 0xff, 0x3e, 0x68, 0xff, 0xff, 0xff, 0x86, 0x00, 0x00,  //..@@.+@@@%..
    0x00, 0x00, 0xf2, 0xff, 0x06, 0x00, 0x86, 0xee, 0xc2, 0x12, 0x00, 0x00,  //..@@..%@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0x00, 0x12, 0x90, 0xe0, 0xf6, 0xd8, 0x7e, 0x06, 0x00,  //@@@..%@@@+..
    0xff, 0xff, 0xff, 0x14, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x00,  //@@@.@@@@@@%.
    0xff, 0xff, 0xff, 0xac, 0xa6, 0x24, 0x06, 0x4a, 0xf0, 0xff, 0xff, 0x54,  //@@@%%..+@@@+
    0xff, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0xae,  //@@@@....+@@%
    0xff, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xe0,  //@@@+.....@@@
    0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf6,  //@@@......@@@
    0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00f2 (ò) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x96, 0xff, 0xca, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@........
    0x00, 0x00, 0x04, 0xc0, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@%.......
    0x00, 0x00, 0x00, 0x14, 0xe0, 0xfc, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@.......
    0x00, 0x00, 0x00, 0x00, 0x2e, 0xf4, 0xde, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x02, 0x60, 0xb8, 0xe8, 0xf8, 0xe8, 0xb8, 0x5e, 0x02, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x12, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //..@@@@@@@@@..
    0x00, 0xbc, 0xff, 0xff, 0xba, 0x2c, 0x06, 0x2e, 0xbe, 0xff, 0xff, 0xba, 0x00,  //.%@@%...%@@%.
    0x4e, 0xff, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //+@@@.....@@@+
    0xaa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //%@@+.....+@@%
    0xe0, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xde,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@.......@@@
    0xe0, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xde,  //@@@.......@@@
    0xaa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //%@@+.....+@@%
    0x50, 0xff, 0xff, 0xd8, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //+@@@.....@@@+
    0x00, 0xbe, 0xff, 0xff, 0xb8, 0x2a, 0x04, 0x2c, 0xbc, 0xff, 0xff, 0xba, 0x00,  //.%@@%...%@@%.
    0x00, 0x12, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //..@@@@@@@@@..
    0x00, 0x00, 0x02, 0x60, 0xba, 0xea, 0xfa, 0xea, 0xba, 0x5e, 0x02, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f3 (ó) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd0, 0xff, 0x96, 0x00, 0x00,  //........@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xc0, 0x04, 0x00, 0x00,  //.......%@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xfc, 0xde, 0x14, 0x00, 0x00, 0x00,  //.......@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe0, 0xf2, 0x2e, 0x00, 0x00, 0x00, 0x00,  //......@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x02, 0x60, 0xb8, 0xe8, 0xf8, 0xe8, 0xb8, 0x5e, 0x02, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x12, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //..@@@@@@@@@..
    0x00, 0xbc, 0xff, 0xff, 0xba, 0x2c, 0x06, 0x2e, 0xbe, 0xff, 0xff, 0xba, 0x00,  //.%@@%...%@@%.
    0x4e, 0xff, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //+@@@.....@@@+
    0xaa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //%@@+.....+@@%
    0xe0, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xde,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@.......@@@
    0xe0, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xde,  //@@@.......@@@
    0xaa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //%@@+.....+@@%
    0x50, 0xff, 0xff, 0xd8, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //+@@@.....@@@+
    0x00, 0xbe, 0xff, 0xff, 0xb8, 0x2a, 0x04, 0x2c, 0xbc, 0xff, 0xff, 0xba, 0x00,  //.%@@%...%@@%.
    0x00, 0x12, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //..@@@@@@@@@..
    0x00, 0x00, 0x02, 0x60, 0xba, 0xea, 0xfa, 0xea, 0xba, 0x5e, 0x02, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f4 (ô) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@%.....
    0x00, 0x00, 0x00, 0x00, 0x22, 0xf8, 0xf4, 0xf8, 0x22, 0x00, 0x00, 0x00, 0x00,  //.....@@@.....
    0x00, 0x00, 0x00, 0x00, 0xa6, 0xf0, 0x30, 0xf0, 0xa6, 0x00, 0x00, 0x00, 0x00,  //....%@.@%....
    0x00, 0x00, 0x00, 0x32, 0xfc, 0x6e, 0x00, 0x6e, 0xfc, 0x30, 0x00, 0x00, 0x00,  //....@+.+@....
    0x00, 0x00, 0x00, 0xba, 0xd0, 0x02, 0x00, 0x02, 0xd0, 0xba, 0x00, 0x00, 0x00,  //...%@...@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x02, 0x60, 0xb8, 0xe8, 0xf8, 0xe8, 0xb8, 0x5e, 0x02, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x12, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //..@@@@@@@@@..
    0x00, 0xbc, 0xff, 0xff, 0xba, 0x2c, 0x06, 0x2e, 0xbe, 0xff, 0xff, 0xba, 0x00,  //.%@@%...%@@%.
    0x4e, 0xff, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //+@@@.....@@@+
    0xaa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //%@@+.....+@@%
    0xe0, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xde,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@.......@@@
    0xe0, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xde,  //@@@.......@@@
    0xaa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //%@@+.....+@@%
    0x50, 0xff, 0xff, 0xd8, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //+@@@.....@@@+
    0x00, 0xbe, 0xff, 0xff, 0xb8, 0x2a, 0x04, 0x2c, 0xbc, 0xff, 0xff, 0xba, 0x00,  //.%@@%...%@@%.
    0x00, 0x12, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //..@@@@@@@@@..
    0x00, 0x00, 0x02, 0x60, 0xba, 0xea, 0xfa, 0xea, 0xba, 0x5e, 0x02, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f5 (õ) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x1e, 0xd6, 0xda, 0x2c, 0x00, 0xc6, 0xf2, 0x00, 0x00, 0x00,  //....@@..@@...
    0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0xd0, 0x14, 0xec, 0xd8, 0x00, 0x00, 0x00,  //...%@@@.@@...
    0x00, 0x00, 0x00, 0xd8, 0xea, 0x14, 0xd0, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00,  //...@@.@@@%...
    0x00, 0x00, 0x00, 0xf2, 0xc6, 0x00, 0x2e, 0xda, 0xd8, 0x1e, 0x00, 0x00, 0x00,  //...@@..@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x02, 0x60, 0xb8, 0xe8, 0xf8, 0xe8, 0xb8, 0x5e, 0x02, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x12, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //..@@@@@@@@@..
    0x00, 0xbc, 0xff, 0xff, 0xba, 0x2c, 0x06, 0x2e, 0xbe, 0xff, 0xff, 0xba, 0x00,  //.%@@%...%@@%.
    0x4e, 0xff, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //+@@@.....@@@+
    0xaa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //%@@+.....+@@%
    0xe0, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xde,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@.......@@@
    0xe0, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xde,  //@@@.......@@@
    0xaa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //%@@+.....+@@%
    0x50, 0xff, 0xff, 0xd8, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //+@@@.....@@@+
    0x00, 0xbe, 0xff, 0xff, 0xb8, 0x2a, 0x04, 0x2c, 0xbc, 0xff, 0xff, 0xba, 0x00,  //.%@@%...%@@%.
    0x00, 0x12, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //..@@@@@@@@@..
    0x00, 0x00, 0x02, 0x60, 0xba, 0xea, 0xfa, 0xea, 0xba, 0x5e, 0x02, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f6 (ö) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@...@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@...@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@...@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x02, 0x60, 0xb8, 0xe8, 0xf8, 0xe8, 0xb8, 0x5e, 0x02, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x12, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //..@@@@@@@@@..
    0x00, 0xbc, 0xff, 0xff, 0xba, 0x2c, 0x06, 0x2e, 0xbe, 0xff, 0xff, 0xba, 0x00,  //.%@@%...%@@%.
    0x4e, 0xff, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //+@@@.....@@@+
    0xaa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //%@@+.....+@@%
    0xe0, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xde,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@.......@@@
    0xe0, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xde,  //@@@.......@@@
    0xaa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //%@@+.....+@@%
    0x50, 0xff, 0xff, 0xd8, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //+@@@.....@@@+
    0x00, 0xbe, 0xff, 0xff, 0xb8, 0x2a, 0x04, 0x2c, 0xbc, 0xff, 0xff, 0xba, 0x00,  //.%@@%...%@@%.
    0x00, 0x12, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //..@@@@@@@@@..
    0x00, 0x00, 0x02, 0x60, 0xba, 0xea, 0xfa, 0xea, 0xba, 0x5e, 0x02, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00f7 (÷) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+00f8 (ø) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x8a, 0x04,  //.............%.
    0x00, 0x00, 0x00, 0x08, 0x74, 0xc8, 0xf0, 0xf6, 0xd6, 0x8a, 0x16, 0x38, 0xf2, 0xf2, 0x30,  //....+@@@@%..@@.
    0x00, 0x00, 0x1e, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0xf0, 0xf6, 0x42, 0x00,  //...@@@@@@@@@@+.
    0x00, 0x04, 0xcc, 0xff, 0xff, 0xb8, 0x2c, 0x06, 0x2e, 0xc2, 0xff, 0xff, 0x8e, 0x00, 0x00,  //..@@@%...@@@%..
    0x00, 0x5a, 0xff, 0xff, 0xd4, 0x06, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff, 0xf6, 0x20, 0x00,  //.+@@@....%@@@..
    0x00, 0xb0, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x70, 0xff, 0xa8, 0xff, 0xff, 0x8c, 0x00,  //.%@@+...+@%@@%.
    0x00, 0xe4, 0xff, 0xff, 0x22, 0x00, 0x00, 0x3c, 0xfa, 0x88, 0x1e, 0xff, 0xff, 0xd2, 0x00,  //.@@@....@%.@@@.
    0x00, 0xf8, 0xff, 0xff, 0x06, 0x00, 0x18, 0xe6, 0xbc, 0x02, 0x08, 0xff, 0xff, 0xf2, 0x00,  //.@@@...@%..@@@.
    0x00, 0xf4, 0xff, 0xff, 0x04, 0x04, 0xc2, 0xe2, 0x14, 0x00, 0x0e, 0xff, 0xff, 0xf6, 0x00,  //.@@@..@@...@@@.
    0x00, 0xd4, 0xff, 0xff, 0x18, 0x90, 0xf8, 0x38, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xe2, 0x00,  //.@@@.%@....@@@.
    0x00, 0x8e, 0xff, 0xff, 0xa8, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xb0, 0x00,  //.%@@%@+...+@@%.
    0x00, 0x1e, 0xf4, 0xff, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x5a, 0x00,  //..@@@%....@@@+.
    0x00, 0x00, 0x86, 0xff, 0xff, 0xb4, 0x30, 0x08, 0x2c, 0xbc, 0xff, 0xff, 0xcc, 0x04, 0x00,  //..%@@%...%@@@..
    0x00, 0x2a, 0xf0, 0xf0, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x1e, 0x00, 0x00,  //..@@@@@@@@@@...
    0x12, 0xdc, 0xf0, 0x38, 0x18, 0x8e, 0xda, 0xf8, 0xf0, 0xca, 0x76, 0x0a, 0x00, 0x00, 0x00,  //.@@..%@@@@+....
    0x0a, 0x90, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00f9 (ù) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x96, 0xff, 0xca, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@.......
    0x00, 0x00, 0x04, 0xc0, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@%......
    0x00, 0x00, 0x00, 0x14, 0xe0, 0xfc, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@......
    0x00, 0x00, 0x00, 0x00, 0x2e, 0xf4, 0xde, 0x0e, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00,  //.....+@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff,  //@@@......@@@
    0xf6, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xff,  //@@@......@@@
    0xe0, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xff,  //@@@.....+@@@
    0xae, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0xff,  //%@@+....@@@@
    0x54, 0xff, 0xff, 0xee, 0x48, 0x04, 0x22, 0xa8, 0xaa, 0xff, 0xff, 0xff,  //+@@@+..%%@@@
    0x00, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x14, 0xff, 0xff, 0xff,  //.%@@@@@@.@@@
    0x00, 0x06, 0x7c, 0xd8, 0xf8, 0xe2, 0x92, 0x12, 0x00, 0xff, 0xff, 0xff,  //..+@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00fa (ú) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd0, 0xff, 0x96, 0x00,  //........@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xc0, 0x04, 0x00,  //.......%@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xfc, 0xde, 0x14, 0x00, 0x00,  //.......@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe0, 0xf2, 0x2e, 0x00, 0x00, 0x00,  //......@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00,  //.....%@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff,  //@@@......@@@
    0xf6, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xff,  //@@@......@@@
    0xe0, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xff,  //@@@.....+@@@
    0xae, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0xff,  //%@@+....@@@@
    0x54, 0xff, 0xff, 0xee, 0x48, 0x04, 0x22, 0xa8, 0xaa, 0xff, 0xff, 0xff,  //+@@@+..%%@@@
    0x00, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x14, 0xff, 0xff, 0xff,  //.%@@@@@@.@@@
    0x00, 0x06, 0x7c, 0xd8, 0xf8, 0xe2, 0x92, 0x12, 0x00, 0xff, 0xff, 0xff,  //..+@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00fb (û) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x3a, 0xfc, 0xfc, 0x3a, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x04, 0xd2, 0xf8, 0xf8, 0xd2, 0x02, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x74, 0xff, 0x76, 0x78, 0xff, 0x74, 0x00, 0x00, 0x00,  //...+@++@+...
    0x00, 0x00, 0x1c, 0xf2, 0xc4, 0x00, 0x02, 0xc4, 0xf2, 0x1c, 0x00, 0x00,  //...@@..@@...
    0x00, 0x00, 0xb0, 0xf2, 0x22, 0x00, 0x00, 0x22, 0xf2, 0xb0, 0x00, 0x00,  //..%@....@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff,  //@@@......@@@
    0xf6, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xff,  //@@@......@@@
    0xe0, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xff,  //@@@.....+@@@
    0xae, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0xff,  //%@@+....@@@@
    0x54, 0xff, 0xff, 0xee, 0x48, 0x04, 0x22, 0xa8, 0xaa, 0xff, 0xff, 0xff,  //+@@@+..%%@@@
    0x00, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x14, 0xff, 0xff, 0xff,  //.%@@@@@@.@@@
    0x00, 0x06, 0x7c, 0xd8, 0xf8, 0xe2, 0x92, 0x12, 0x00, 0xff, 0xff, 0xff,  //..+@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00fc (ü) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..@@@..@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff,  //@@@......@@@
    0xf6, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xff,  //@@@......@@@
    0xe0, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xff,  //@@@.....+@@@
    0xae, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0xff,  //%@@+....@@@@
    0x54, 0xff, 0xff, 0xee, 0x48, 0x04, 0x22, 0xa8, 0xaa, 0xff, 0xff, 0xff,  //+@@@+..%%@@@
    0x00, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x14, 0xff, 0xff, 0xff,  //.%@@@@@@.@@@
    0x00, 0x06, 0x7c, 0xd8, 0xf8, 0xe2, 0x92, 0x12, 0x00, 0xff, 0xff, 0xff,  //..+@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00fd (ý) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd0, 0xff, 0x96, 0x00, 0x00, 0x00,  //........@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xc0, 0x04, 0x00, 0x00, 0x00,  //.......%@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xfc, 0xde, 0x14, 0x00, 0x00, 0x00, 0x00,  //.......@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe0, 0xf2, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xca, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xc6,  //@@@+......+@@@
    0x60, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xe4, 0xff, 0xff, 0x58,  //+@@@......@@@+
    0x08, 0xee, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xe4, 0x04,  //.@@@+....+@@@.
    0x00, 0x8e, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0x7a, 0x00,  //.%@@%....@@@+.
    0x00, 0x26, 0xff, 0xff, 0xfa, 0x1a, 0x00, 0x00, 0x34, 0xff, 0xff, 0xf6, 0x14, 0x00,  //..@@@....@@@..
    0x00, 0x00, 0xbc, 0xff, 0xff, 0x7e, 0x00, 0x00, 0xa4, 0xff, 0xff, 0x9c, 0x00, 0x00,  //..%@@+..%@@%..
    0x00, 0x00, 0x52, 0xff, 0xff, 0xe2, 0x02, 0x18, 0xf8, 0xff, 0xff, 0x2e, 0x00, 0x00,  //..+@@@..@@@...
    0x00, 0x00, 0x02, 0xe4, 0xff, 0xff, 0x50, 0x80, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,  //...@@@++@@%...
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xbe, 0xe8, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00,  //...+@@%@@@+...
    0x00, 0x00, 0x00, 0x1a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xde, 0x02, 0x00, 0x00, 0x00,  //....@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00,  //....%@@@@+....
    0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xff, 0xf4, 0x0e, 0x00, 0x00, 0x00, 0x00,  //....+@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x1c, 0xfa, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@......
    0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@%......
    0x00, 0x00, 0x00, 0x12, 0xf0, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@+......
    0x00, 0x00, 0x10, 0xb4, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@.......
    0x00, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@........
    0x00, 0xff, 0xff, 0xec, 0xb8, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00fe (þ) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x18, 0x94, 0xe0, 0xf6, 0xda, 0x8a, 0x0e, 0x00, 0x00,  //@@@..%@@@%...
    0xff, 0xff, 0xff, 0x1c, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x1e, 0x00,  //@@@.@@@@@@@..
    0xff, 0xff, 0xff, 0xb2, 0xb8, 0x2c, 0x06, 0x2c, 0xb8, 0xff, 0xff, 0xc8, 0x02,  //@@@%%...%@@@.
    0xff, 0xff, 0xff, 0xd2, 0x06, 0x00, 0x00, 0x00, 0x06, 0xd2, 0xff, 0xff, 0x54,  //@@@@.....@@@+
    0xff, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xac,  //@@@+.....+@@%
    0xff, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf6,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf6,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xac,  //@@@+.....+@@%
    0xff, 0xff, 0xff, 0xd2, 0x06, 0x00, 0x00, 0x00, 0x06, 0xd2, 0xff, 0xff, 0x54,  //@@@@.....@@@+
    0xff, 0xff, 0xff, 0xb2, 0xb8, 0x2a, 0x04, 0x2a, 0xb8, 0xff, 0xff, 0xcc, 0x02,  //@@@%%...%@@@.
    0xff, 0xff, 0xff, 0x1c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x20, 0x00,  //@@@.@@@@@@@..
    0xff, 0xff, 0xff, 0x00, 0x1a, 0x96, 0xe2, 0xf8, 0xdc, 0x8a, 0x10, 0x00, 0x00,  //@@@..%@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00ff (ÿ) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@.@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@.@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@.@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xca, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xc6,  //@@@+......+@@@
    0x60, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xe4, 0xff, 0xff, 0x58,  //+@@@......@@@+
    0x08, 0xee, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xe4, 0x04,  //.@@@+....+@@@.
    0x00, 0x8e, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0x7a, 0x00,  //.%@@%....@@@+.
    0x00, 0x26, 0xff, 0xff, 0xfa, 0x1a, 0x00, 0x00, 0x34, 0xff, 0xff, 0xf6, 0x14, 0x00,  //..@@@....@@@..
    0x00, 0x00, 0xbc, 0xff, 0xff, 0x7e, 0x00, 0x00, 0xa4, 0xff, 0xff, 0x9c, 0x00, 0x00,  //..%@@+..%@@%..
    0x00, 0x00, 0x52, 0xff, 0xff, 0xe2, 0x02, 0x18, 0xf8, 0xff, 0xff, 0x2e, 0x00, 0x00,  //..+@@@..@@@...
    0x00, 0x00, 0x02, 0xe4, 0xff, 0xff, 0x50, 0x80, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,  //...@@@++@@%...
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xbe, 0xe8, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00,  //...+@@%@@@+...
    0x00, 0x00, 0x00, 0x1a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xde, 0x02, 0x00, 0x00, 0x00,  //....@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00,  //....%@@@@+....
    0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xff, 0xf4, 0x0e, 0x00, 0x00, 0x00, 0x00,  //....+@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x1c, 0xfa, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@......
    0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@%......
    0x00, 0x00, 0x00, 0x12, 0xf0, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@+......
    0x00, 0x00, 0x10, 0xb4, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@.......
    0x00, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@........
    0x00, 0xff, 0xff, 0xec, 0xb8, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............



#endif
};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t lv_font_dejavu_30_latin_sup_glyph_dsc[] = {
#if USE_LV_FONT_DEJAVU_30_LATIN_SUP == 1
    {.w_px = 8,   .glyph_index = 0},  /*Unicode: U+00a0 ( )*/
    {.w_px = 3,   .glyph_index = 30}, /*Unicode: U+00a1 (¡)*/
    {.w_px = 11,  .glyph_index = 60}, /*Unicode: U+00a2 (¢)*/
    {.w_px = 13,  .glyph_index = 120},    /*Unicode: U+00a3 (£)*/
    {.w_px = 15,  .glyph_index = 180},    /*Unicode: U+00a4 (¤)*/
    {.w_px = 15,  .glyph_index = 240},    /*Unicode: U+00a5 (¥)*/
    {.w_px = 2,   .glyph_index = 300},    /*Unicode: U+00a6 (¦)*/
    {.w_px = 11,  .glyph_index = 330},    /*Unicode: U+00a7 (§)*/
    {.w_px = 8,   .glyph_index = 390},    /*Unicode: U+00a8 (¨)*/
    {.w_px = 19,  .glyph_index = 420},    /*Unicode: U+00a9 (©)*/
    {.w_px = 11,  .glyph_index = 510},    /*Unicode: U+00aa (ª)*/
    {.w_px = 12,  .glyph_index = 570},    /*Unicode: U+00ab («)*/
    {.w_px = 16,  .glyph_index = 630},    /*Unicode: U+00ac (¬)*/
    {.w_px = 7,   .glyph_index = 690},    /*Unicode: U+00ad (­)*/
    {.w_px = 19,  .glyph_index = 720},    /*Unicode: U+00ae (®)*/
    {.w_px = 8,   .glyph_index = 810},    /*Unicode: U+00af (¯)*/
    {.w_px = 8,   .glyph_index = 840},    /*Unicode: U+00b0 (°)*/
    {.w_px = 16,  .glyph_index = 870},    /*Unicode: U+00b1 (±)*/
    {.w_px = 8,   .glyph_index = 930},    /*Unicode: U+00b2 (²)*/
    {.w_px = 8,   .glyph_index = 960},    /*Unicode: U+00b3 (³)*/
    {.w_px = 6,   .glyph_index = 990},    /*Unicode: U+00b4 (´)*/
    {.w_px = 14,  .glyph_index = 1020},   /*Unicode: U+00b5 (µ)*/
    {.w_px = 12,  .glyph_index = 1080},   /*Unicode: U+00b6 (¶)*/
    {.w_px = 3,   .glyph_index = 1140},   /*Unicode: U+00b7 (·)*/
    {.w_px = 5,   .glyph_index = 1170},   /*Unicode: U+00b8 (¸)*/
    {.w_px = 8,   .glyph_index = 1200},   /*Unicode: U+00b9 (¹)*/
    {.w_px = 10,  .glyph_index = 1230},   /*Unicode: U+00ba (º)*/
    {.w_px = 12,  .glyph_index = 1290},   /*Unicode: U+00bb (»)*/
    {.w_px = 23,  .glyph_index = 1350},   /*Unicode: U+00bc (¼)*/
    {.w_px = 22,  .glyph_index = 1440},   /*Unicode: U+00bd (½)*/
    {.w_px = 24,  .glyph_index = 1530},   /*Unicode: U+00be (¾)*/
    {.w_px = 10,  .glyph_index = 1620},   /*Unicode: U+00bf (¿)*/
    {.w_px = 17,  .glyph_index = 1680},   /*Unicode: U+00c0 (À)*/
    {.w_px = 17,  .glyph_index = 1770},   /*Unicode: U+00c1 (Á)*/
    {.w_px = 17,  .glyph_index = 1860},   /*Unicode: U+00c2 (Â)*/
    {.w_px = 17,  .glyph_index = 1950},   /*Unicode: U+00c3 (Ã)*/
    {.w_px = 17,  .glyph_index = 2040},   /*Unicode: U+00c4 (Ä)*/
    {.w_px = 17,  .glyph_index = 2130},   /*Unicode: U+00c5 (Å)*/
    {.w_px = 23,  .glyph_index = 2220},   /*Unicode: U+00c6 (Æ)*/
    {.w_px = 15,  .glyph_index = 2310},   /*Unicode: U+00c7 (Ç)*/
    {.w_px = 12,  .glyph_index = 2370},   /*Unicode: U+00c8 (È)*/
    {.w_px = 12,  .glyph_index = 2430},   /*Unicode: U+00c9 (É)*/
    {.w_px = 12,  .glyph_index = 2490},   /*Unicode: U+00ca (Ê)*/
    {.w_px = 12,  .glyph_index = 2550},   /*Unicode: U+00cb (Ë)*/
    {.w_px = 5,   .glyph_index = 2610},   /*Unicode: U+00cc (Ì)*/
    {.w_px = 5,   .glyph_index = 2640},   /*Unicode: U+00cd (Í)*/
    {.w_px = 8,   .glyph_index = 2670},   /*Unicode: U+00ce (Î)*/
    {.w_px = 7,   .glyph_index = 2700},   /*Unicode: U+00cf (Ï)*/
    {.w_px = 19,  .glyph_index = 2730},   /*Unicode: U+00d0 (Ð)*/
    {.w_px = 14,  .glyph_index = 2820},   /*Unicode: U+00d1 (Ñ)*/
    {.w_px = 18,  .glyph_index = 2880},   /*Unicode: U+00d2 (Ò)*/
    {.w_px = 18,  .glyph_index = 2970},   /*Unicode: U+00d3 (Ó)*/
    {.w_px = 18,  .glyph_index = 3060},   /*Unicode: U+00d4 (Ô)*/
    {.w_px = 18,  .glyph_index = 3150},   /*Unicode: U+00d5 (Õ)*/
    {.w_px = 18,  .glyph_index = 3240},   /*Unicode: U+00d6 (Ö)*/
    {.w_px = 15,  .glyph_index = 3330},   /*Unicode: U+00d7 (×)*/
    {.w_px = 19,  .glyph_index = 3390},   /*Unicode: U+00d8 (Ø)*/
    {.w_px = 14,  .glyph_index = 3480},   /*Unicode: U+00d9 (Ù)*/
    {.w_px = 14,  .glyph_index = 3540},   /*Unicode: U+00da (Ú)*/
    {.w_px = 14,  .glyph_index = 3600},   /*Unicode: U+00db (Û)*/
    {.w_px = 14,  .glyph_index = 3660},   /*Unicode: U+00dc (Ü)*/
    {.w_px = 17,  .glyph_index = 3720},   /*Unicode: U+00dd (Ý)*/
    {.w_px = 12,  .glyph_index = 3810},   /*Unicode: U+00de (Þ)*/
    {.w_px = 13,  .glyph_index = 3870},   /*Unicode: U+00df (ß)*/
    {.w_px = 12,  .glyph_index = 3930},   /*Unicode: U+00e0 (à)*/
    {.w_px = 12,  .glyph_index = 3990},   /*Unicode: U+00e1 (á)*/
    {.w_px = 12,  .glyph_index = 4050},   /*Unicode: U+00e2 (â)*/
    {.w_px = 12,  .glyph_index = 4110},   /*Unicode: U+00e3 (ã)*/
    {.w_px = 12,  .glyph_index = 4170},   /*Unicode: U+00e4 (ä)*/
    {.w_px = 12,  .glyph_index = 4230},   /*Unicode: U+00e5 (å)*/
    {.w_px = 22,  .glyph_index = 4290},   /*Unicode: U+00e6 (æ)*/
    {.w_px = 11,  .glyph_index = 4380},   /*Unicode: U+00e7 (ç)*/
    {.w_px = 13,  .glyph_index = 4440},   /*Unicode: U+00e8 (è)*/
    {.w_px = 13,  .glyph_index = 4500},   /*Unicode: U+00e9 (é)*/
    {.w_px = 13,  .glyph_index = 4560},   /*Unicode: U+00ea (ê)*/
    {.w_px = 13,  .glyph_index = 4620},   /*Unicode: U+00eb (ë)*/
    {.w_px = 5,   .glyph_index = 4680},   /*Unicode: U+00ec (ì)*/
    {.w_px = 6,   .glyph_index = 4710},   /*Unicode: U+00ed (í)*/
    {.w_px = 8,   .glyph_index = 4740},   /*Unicode: U+00ee (î)*/
    {.w_px = 7,   .glyph_index = 4770},   /*Unicode: U+00ef (ï)*/
    {.w_px = 13,  .glyph_index = 4800},   /*Unicode: U+00f0 (ð)*/
    {.w_px = 12,  .glyph_index = 4860},   /*Unicode: U+00f1 (ñ)*/
    {.w_px = 13,  .glyph_index = 4920},   /*Unicode: U+00f2 (ò)*/
    {.w_px = 13,  .glyph_index = 4980},   /*Unicode: U+00f3 (ó)*/
    {.w_px = 13,  .glyph_index = 5040},   /*Unicode: U+00f4 (ô)*/
    {.w_px = 13,  .glyph_index = 5100},   /*Unicode: U+00f5 (õ)*/
    {.w_px = 13,  .glyph_index = 5160},   /*Unicode: U+00f6 (ö)*/
    {.w_px = 17,  .glyph_index = 5220},   /*Unicode: U+00f7 (÷)*/
    {.w_px = 15,  .glyph_index = 5310},   /*Unicode: U+00f8 (ø)*/
    {.w_px = 12,  .glyph_index = 5370},   /*Unicode: U+00f9 (ù)*/
    {.w_px = 12,  .glyph_index = 5430},   /*Unicode: U+00fa (ú)*/
    {.w_px = 12,  .glyph_index = 5490},   /*Unicode: U+00fb (û)*/
    {.w_px = 12,  .glyph_index = 5550},   /*Unicode: U+00fc (ü)*/
    {.w_px = 14,  .glyph_index = 5610},   /*Unicode: U+00fd (ý)*/
    {.w_px = 13,  .glyph_index = 5670},   /*Unicode: U+00fe (þ)*/
    {.w_px = 14,  .glyph_index = 5730},   /*Unicode: U+00ff (ÿ)*/

#elif USE_LV_FONT_DEJAVU_30_LATIN_SUP == 2
    {.w_px = 8,   .glyph_index = 0},  /*Unicode: U+00a0 ( )*/
    {.w_px = 3,   .glyph_index = 60}, /*Unicode: U+00a1 (¡)*/
    {.w_px = 11,  .glyph_index = 90}, /*Unicode: U+00a2 (¢)*/
    {.w_px = 13,  .glyph_index = 180},    /*Unicode: U+00a3 (£)*/
    {.w_px = 15,  .glyph_index = 300},    /*Unicode: U+00a4 (¤)*/
    {.w_px = 15,  .glyph_index = 420},    /*Unicode: U+00a5 (¥)*/
    {.w_px = 2,   .glyph_index = 540},    /*Unicode: U+00a6 (¦)*/
    {.w_px = 11,  .glyph_index = 570},    /*Unicode: U+00a7 (§)*/
    {.w_px = 8,   .glyph_index = 660},    /*Unicode: U+00a8 (¨)*/
    {.w_px = 19,  .glyph_index = 720},    /*Unicode: U+00a9 (©)*/
    {.w_px = 11,  .glyph_index = 870},    /*Unicode: U+00aa (ª)*/
    {.w_px = 12,  .glyph_index = 960},    /*Unicode: U+00ab («)*/
    {.w_px = 16,  .glyph_index = 1050},   /*Unicode: U+00ac (¬)*/
    {.w_px = 7,   .glyph_index = 1170},   /*Unicode: U+00ad (­)*/
    {.w_px = 19,  .glyph_index = 1230},   /*Unicode: U+00ae (®)*/
    {.w_px = 8,   .glyph_index = 1380},   /*Unicode: U+00af (¯)*/
    {.w_px = 8,   .glyph_index = 1440},   /*Unicode: U+00b0 (°)*/
    {.w_px = 16,  .glyph_index = 1500},   /*Unicode: U+00b1 (±)*/
    {.w_px = 8,   .glyph_index = 1620},   /*Unicode: U+00b2 (²)*/
    {.w_px = 8,   .glyph_index = 1680},   /*Unicode: U+00b3 (³)*/
    {.w_px = 6,   .glyph_index = 1740},   /*Unicode: U+00b4 (´)*/
    {.w_px = 14,  .glyph_index = 1800},   /*Unicode: U+00b5 (µ)*/
    {.w_px = 12,  .glyph_index = 1920},   /*Unicode: U+00b6 (¶)*/
    {.w_px = 3,   .glyph_index = 2010},   /*Unicode: U+00b7 (·)*/
    {.w_px = 5,   .glyph_index = 2040},   /*Unicode: U+00b8 (¸)*/
    {.w_px = 8,   .glyph_index = 2100},   /*Unicode: U+00b9 (¹)*/
    {.w_px = 10,  .glyph_index = 2160},   /*Unicode: U+00ba (º)*/
    {.w_px = 12,  .glyph_index = 2250},   /*Unicode: U+00bb (»)*/
    {.w_px = 23,  .glyph_index = 2340},   /*Unicode: U+00bc (¼)*/
    {.w_px = 22,  .glyph_index = 2520},   /*Unicode: U+00bd (½)*/
    {.w_px = 24,  .glyph_index = 2700},   /*Unicode: U+00be (¾)*/
    {.w_px = 10,  .glyph_index = 2880},   /*Unicode: U+00bf (¿)*/
    {.w_px = 17,  .glyph_index = 2970},   /*Unicode: U+00c0 (À)*/
    {.w_px = 17,  .glyph_index = 3120},   /*Unicode: U+00c1 (Á)*/
    {.w_px = 17,  .glyph_index = 3270},   /*Unicode: U+00c2 (Â)*/
    {.w_px = 17,  .glyph_index = 3420},   /*Unicode: U+00c3 (Ã)*/
    {.w_px = 17,  .glyph_index = 3570},   /*Unicode: U+00c4 (Ä)*/
    {.w_px = 17,  .glyph_index = 3720},   /*Unicode: U+00c5 (Å)*/
    {.w_px = 23,  .glyph_index = 3870},   /*Unicode: U+00c6 (Æ)*/
    {.w_px = 15,  .glyph_index = 4050},   /*Unicode: U+00c7 (Ç)*/
    {.w_px = 12,  .glyph_index = 4170},   /*Unicode: U+00c8 (È)*/
    {.w_px = 12,  .glyph_index = 4260},   /*Unicode: U+00c9 (É)*/
    {.w_px = 12,  .glyph_index = 4350},   /*Unicode: U+00ca (Ê)*/
    {.w_px = 12,  .glyph_index = 4440},   /*Unicode: U+00cb (Ë)*/
    {.w_px = 5,   .glyph_index = 4530},   /*Unicode: U+00cc (Ì)*/
    {.w_px = 5,   .glyph_index = 4590},   /*Unicode: U+00cd (Í)*/
    {.w_px = 8,   .glyph_index = 4650},   /*Unicode: U+00ce (Î)*/
    {.w_px = 7,   .glyph_index = 4710},   /*Unicode: U+00cf (Ï)*/
    {.w_px = 19,  .glyph_index = 4770},   /*Unicode: U+00d0 (Ð)*/
    {.w_px = 14,  .glyph_index = 4920},   /*Unicode: U+00d1 (Ñ)*/
    {.w_px = 18,  .glyph_index = 5040},   /*Unicode: U+00d2 (Ò)*/
    {.w_px = 18,  .glyph_index = 5190},   /*Unicode: U+00d3 (Ó)*/
    {.w_px = 18,  .glyph_index = 5340},   /*Unicode: U+00d4 (Ô)*/
    {.w_px = 18,  .glyph_index = 5490},   /*Unicode: U+00d5 (Õ)*/
    {.w_px = 18,  .glyph_index = 5640},   /*Unicode: U+00d6 (Ö)*/
    {.w_px = 15,  .glyph_index = 5790},   /*Unicode: U+00d7 (×)*/
    {.w_px = 19,  .glyph_index = 5910},   /*Unicode: U+00d8 (Ø)*/
    {.w_px = 14,  .glyph_index = 6060},   /*Unicode: U+00d9 (Ù)*/
    {.w_px = 14,  .glyph_index = 6180},   /*Unicode: U+00da (Ú)*/
    {.w_px = 14,  .glyph_index = 6300},   /*Unicode: U+00db (Û)*/
    {.w_px = 14,  .glyph_index = 6420},   /*Unicode: U+00dc (Ü)*/
    {.w_px = 17,  .glyph_index = 6540},   /*Unicode: U+00dd (Ý)*/
    {.w_px = 12,  .glyph_index = 6690},   /*Unicode: U+00de (Þ)*/
    {.w_px = 13,  .glyph_index = 6780},   /*Unicode: U+00df (ß)*/
    {.w_px = 12,  .glyph_index = 6900},   /*Unicode: U+00e0 (à)*/
    {.w_px = 12,  .glyph_index = 6990},   /*Unicode: U+00e1 (á)*/
    {.w_px = 12,  .glyph_index = 7080},   /*Unicode: U+00e2 (â)*/
    {.w_px = 12,  .glyph_index = 7170},   /*Unicode: U+00e3 (ã)*/
    {.w_px = 12,  .glyph_index = 7260},   /*Unicode: U+00e4 (ä)*/
    {.w_px = 12,  .glyph_index = 7350},   /*Unicode: U+00e5 (å)*/
    {.w_px = 22,  .glyph_index = 7440},   /*Unicode: U+00e6 (æ)*/
    {.w_px = 11,  .glyph_index = 7620},   /*Unicode: U+00e7 (ç)*/
    {.w_px = 13,  .glyph_index = 7710},   /*Unicode: U+00e8 (è)*/
    {.w_px = 13,  .glyph_index = 7830},   /*Unicode: U+00e9 (é)*/
    {.w_px = 13,  .glyph_index = 7950},   /*Unicode: U+00ea (ê)*/
    {.w_px = 13,  .glyph_index = 8070},   /*Unicode: U+00eb (ë)*/
    {.w_px = 5,   .glyph_index = 8190},   /*Unicode: U+00ec (ì)*/
    {.w_px = 6,   .glyph_index = 8250},   /*Unicode: U+00ed (í)*/
    {.w_px = 8,   .glyph_index = 8310},   /*Unicode: U+00ee (î)*/
    {.w_px = 7,   .glyph_index = 8370},   /*Unicode: U+00ef (ï)*/
    {.w_px = 13,  .glyph_index = 8430},   /*Unicode: U+00f0 (ð)*/
    {.w_px = 12,  .glyph_index = 8550},   /*Unicode: U+00f1 (ñ)*/
    {.w_px = 13,  .glyph_index = 8640},   /*Unicode: U+00f2 (ò)*/
    {.w_px = 13,  .glyph_index = 8760},   /*Unicode: U+00f3 (ó)*/
    {.w_px = 13,  .glyph_index = 8880},   /*Unicode: U+00f4 (ô)*/
    {.w_px = 13,  .glyph_index = 9000},   /*Unicode: U+00f5 (õ)*/
    {.w_px = 13,  .glyph_index = 9120},   /*Unicode: U+00f6 (ö)*/
    {.w_px = 17,  .glyph_index = 9240},   /*Unicode: U+00f7 (÷)*/
    {.w_px = 15,  .glyph_index = 9390},   /*Unicode: U+00f8 (ø)*/
    {.w_px = 12,  .glyph_index = 9510},   /*Unicode: U+00f9 (ù)*/
    {.w_px = 12,  .glyph_index = 9600},   /*Unicode: U+00fa (ú)*/
    {.w_px = 12,  .glyph_index = 9690},   /*Unicode: U+00fb (û)*/
    {.w_px = 12,  .glyph_index = 9780},   /*Unicode: U+00fc (ü)*/
    {.w_px = 14,  .glyph_index = 9870},   /*Unicode: U+00fd (ý)*/
    {.w_px = 13,  .glyph_index = 9990},   /*Unicode: U+00fe (þ)*/
    {.w_px = 14,  .glyph_index = 10110},  /*Unicode: U+00ff (ÿ)*/

#elif USE_LV_FONT_DEJAVU_30_LATIN_SUP == 4
    {.w_px = 8,   .glyph_index = 0},  /*Unicode: U+00a0 ( )*/
    {.w_px = 3,   .glyph_index = 120},    /*Unicode: U+00a1 (¡)*/
    {.w_px = 11,  .glyph_index = 180},    /*Unicode: U+00a2 (¢)*/
    {.w_px = 13,  .glyph_index = 360},    /*Unicode: U+00a3 (£)*/
    {.w_px = 15,  .glyph_index = 570},    /*Unicode: U+00a4 (¤)*/
    {.w_px = 15,  .glyph_index = 810},    /*Unicode: U+00a5 (¥)*/
    {.w_px = 2,   .glyph_index = 1050},   /*Unicode: U+00a6 (¦)*/
    {.w_px = 11,  .glyph_index = 1080},   /*Unicode: U+00a7 (§)*/
    {.w_px = 8,   .glyph_index = 1260},   /*Unicode: U+00a8 (¨)*/
    {.w_px = 19,  .glyph_index = 1380},   /*Unicode: U+00a9 (©)*/
    {.w_px = 11,  .glyph_index = 1680},   /*Unicode: U+00aa (ª)*/
    {.w_px = 12,  .glyph_index = 1860},   /*Unicode: U+00ab («)*/
    {.w_px = 16,  .glyph_index = 2040},   /*Unicode: U+00ac (¬)*/
    {.w_px = 7,   .glyph_index = 2280},   /*Unicode: U+00ad (­)*/
    {.w_px = 19,  .glyph_index = 2400},   /*Unicode: U+00ae (®)*/
    {.w_px = 8,   .glyph_index = 2700},   /*Unicode: U+00af (¯)*/
    {.w_px = 8,   .glyph_index = 2820},   /*Unicode: U+00b0 (°)*/
    {.w_px = 16,  .glyph_index = 2940},   /*Unicode: U+00b1 (±)*/
    {.w_px = 8,   .glyph_index = 3180},   /*Unicode: U+00b2 (²)*/
    {.w_px = 8,   .glyph_index = 3300},   /*Unicode: U+00b3 (³)*/
    {.w_px = 6,   .glyph_index = 3420},   /*Unicode: U+00b4 (´)*/
    {.w_px = 14,  .glyph_index = 3510},   /*Unicode: U+00b5 (µ)*/
    {.w_px = 12,  .glyph_index = 3720},   /*Unicode: U+00b6 (¶)*/
    {.w_px = 3,   .glyph_index = 3900},   /*Unicode: U+00b7 (·)*/
    {.w_px = 5,   .glyph_index = 3960},   /*Unicode: U+00b8 (¸)*/
    {.w_px = 8,   .glyph_index = 4050},   /*Unicode: U+00b9 (¹)*/
    {.w_px = 10,  .glyph_index = 4170},   /*Unicode: U+00ba (º)*/
    {.w_px = 12,  .glyph_index = 4320},   /*Unicode: U+00bb (»)*/
    {.w_px = 23,  .glyph_index = 4500},   /*Unicode: U+00bc (¼)*/
    {.w_px = 22,  .glyph_index = 4860},   /*Unicode: U+00bd (½)*/
    {.w_px = 24,  .glyph_index = 5190},   /*Unicode: U+00be (¾)*/
    {.w_px = 10,  .glyph_index = 5550},   /*Unicode: U+00bf (¿)*/
    {.w_px = 17,  .glyph_index = 5700},   /*Unicode: U+00c0 (À)*/
    {.w_px = 17,  .glyph_index = 5970},   /*Unicode: U+00c1 (Á)*/
    {.w_px = 17,  .glyph_index = 6240},   /*Unicode: U+00c2 (Â)*/
    {.w_px = 17,  .glyph_index = 6510},   /*Unicode: U+00c3 (Ã)*/
    {.w_px = 17,  .glyph_index = 6780},   /*Unicode: U+00c4 (Ä)*/
    {.w_px = 17,  .glyph_index = 7050},   /*Unicode: U+00c5 (Å)*/
    {.w_px = 23,  .glyph_index = 7320},   /*Unicode: U+00c6 (Æ)*/
    {.w_px = 15,  .glyph_index = 7680},   /*Unicode: U+00c7 (Ç)*/
    {.w_px = 12,  .glyph_index = 7920},   /*Unicode: U+00c8 (È)*/
    {.w_px = 12,  .glyph_index = 8100},   /*Unicode: U+00c9 (É)*/
    {.w_px = 12,  .glyph_index = 8280},   /*Unicode: U+00ca (Ê)*/
    {.w_px = 12,  .glyph_index = 8460},   /*Unicode: U+00cb (Ë)*/
    {.w_px = 5,   .glyph_index = 8640},   /*Unicode: U+00cc (Ì)*/
    {.w_px = 5,   .glyph_index = 8730},   /*Unicode: U+00cd (Í)*/
    {.w_px = 8,   .glyph_index = 8820},   /*Unicode: U+00ce (Î)*/
    {.w_px = 7,   .glyph_index = 8940},   /*Unicode: U+00cf (Ï)*/
    {.w_px = 19,  .glyph_index = 9060},   /*Unicode: U+00d0 (Ð)*/
    {.w_px = 14,  .glyph_index = 9360},   /*Unicode: U+00d1 (Ñ)*/
    {.w_px = 18,  .glyph_index = 9570},   /*Unicode: U+00d2 (Ò)*/
    {.w_px = 18,  .glyph_index = 9840},   /*Unicode: U+00d3 (Ó)*/
    {.w_px = 18,  .glyph_index = 10110},  /*Unicode: U+00d4 (Ô)*/
    {.w_px = 18,  .glyph_index = 10380},  /*Unicode: U+00d5 (Õ)*/
    {.w_px = 18,  .glyph_index = 10650},  /*Unicode: U+00d6 (Ö)*/
    {.w_px = 15,  .glyph_index = 10920},  /*Unicode: U+00d7 (×)*/
    {.w_px = 19,  .glyph_index = 11160},  /*Unicode: U+00d8 (Ø)*/
    {.w_px = 14,  .glyph_index = 11460},  /*Unicode: U+00d9 (Ù)*/
    {.w_px = 14,  .glyph_index = 11670},  /*Unicode: U+00da (Ú)*/
    {.w_px = 14,  .glyph_index = 11880},  /*Unicode: U+00db (Û)*/
    {.w_px = 14,  .glyph_index = 12090},  /*Unicode: U+00dc (Ü)*/
    {.w_px = 17,  .glyph_index = 12300},  /*Unicode: U+00dd (Ý)*/
    {.w_px = 12,  .glyph_index = 12570},  /*Unicode: U+00de (Þ)*/
    {.w_px = 13,  .glyph_index = 12750},  /*Unicode: U+00df (ß)*/
    {.w_px = 12,  .glyph_index = 12960},  /*Unicode: U+00e0 (à)*/
    {.w_px = 12,  .glyph_index = 13140},  /*Unicode: U+00e1 (á)*/
    {.w_px = 12,  .glyph_index = 13320},  /*Unicode: U+00e2 (â)*/
    {.w_px = 12,  .glyph_index = 13500},  /*Unicode: U+00e3 (ã)*/
    {.w_px = 12,  .glyph_index = 13680},  /*Unicode: U+00e4 (ä)*/
    {.w_px = 12,  .glyph_index = 13860},  /*Unicode: U+00e5 (å)*/
    {.w_px = 22,  .glyph_index = 14040},  /*Unicode: U+00e6 (æ)*/
    {.w_px = 11,  .glyph_index = 14370},  /*Unicode: U+00e7 (ç)*/
    {.w_px = 13,  .glyph_index = 14550},  /*Unicode: U+00e8 (è)*/
    {.w_px = 13,  .glyph_index = 14760},  /*Unicode: U+00e9 (é)*/
    {.w_px = 13,  .glyph_index = 14970},  /*Unicode: U+00ea (ê)*/
    {.w_px = 13,  .glyph_index = 15180},  /*Unicode: U+00eb (ë)*/
    {.w_px = 5,   .glyph_index = 15390},  /*Unicode: U+00ec (ì)*/
    {.w_px = 6,   .glyph_index = 15480},  /*Unicode: U+00ed (í)*/
    {.w_px = 8,   .glyph_index = 15570},  /*Unicode: U+00ee (î)*/
    {.w_px = 7,   .glyph_index = 15690},  /*Unicode: U+00ef (ï)*/
    {.w_px = 13,  .glyph_index = 15810},  /*Unicode: U+00f0 (ð)*/
    {.w_px = 12,  .glyph_index = 16020},  /*Unicode: U+00f1 (ñ)*/
    {.w_px = 13,  .glyph_index = 16200},  /*Unicode: U+00f2 (ò)*/
    {.w_px = 13,  .glyph_index = 16410},  /*Unicode: U+00f3 (ó)*/
    {.w_px = 13,  .glyph_index = 16620},  /*Unicode: U+00f4 (ô)*/
    {.w_px = 13,  .glyph_index = 16830},  /*Unicode: U+00f5 (õ)*/
    {.w_px = 13,  .glyph_index = 17040},  /*Unicode: U+00f6 (ö)*/
    {.w_px = 17,  .glyph_index = 17250},  /*Unicode: U+00f7 (÷)*/
    {.w_px = 15,  .glyph_index = 17520},  /*Unicode: U+00f8 (ø)*/
    {.w_px = 12,  .glyph_index = 17760},  /*Unicode: U+00f9 (ù)*/
    {.w_px = 12,  .glyph_index = 17940},  /*Unicode: U+00fa (ú)*/
    {.w_px = 12,  .glyph_index = 18120},  /*Unicode: U+00fb (û)*/
    {.w_px = 12,  .glyph_index = 18300},  /*Unicode: U+00fc (ü)*/
    {.w_px = 14,  .glyph_index = 18480},  /*Unicode: U+00fd (ý)*/
    {.w_px = 13,  .glyph_index = 18690},  /*Unicode: U+00fe (þ)*/
    {.w_px = 14,  .glyph_index = 18900},  /*Unicode: U+00ff (ÿ)*/

#elif USE_LV_FONT_DEJAVU_30_LATIN_SUP == 8
    {.w_px = 8,   .glyph_index = 0},  /*Unicode: U+00a0 ( )*/
    {.w_px = 3,   .glyph_index = 240},    /*Unicode: U+00a1 (¡)*/
    {.w_px = 11,  .glyph_index = 330},    /*Unicode: U+00a2 (¢)*/
    {.w_px = 13,  .glyph_index = 660},    /*Unicode: U+00a3 (£)*/
    {.w_px = 15,  .glyph_index = 1050},   /*Unicode: U+00a4 (¤)*/
    {.w_px = 15,  .glyph_index = 1500},   /*Unicode: U+00a5 (¥)*/
    {.w_px = 2,   .glyph_index = 1950},   /*Unicode: U+00a6 (¦)*/
    {.w_px = 11,  .glyph_index = 2010},   /*Unicode: U+00a7 (§)*/
    {.w_px = 8,   .glyph_index = 2340},   /*Unicode: U+00a8 (¨)*/
    {.w_px = 19,  .glyph_index = 2580},   /*Unicode: U+00a9 (©)*/
    {.w_px = 11,  .glyph_index = 3150},   /*Unicode: U+00aa (ª)*/
    {.w_px = 12,  .glyph_index = 3480},   /*Unicode: U+00ab («)*/
    {.w_px = 16,  .glyph_index = 3840},   /*Unicode: U+00ac (¬)*/
    {.w_px = 7,   .glyph_index = 4320},   /*Unicode: U+00ad (­)*/
    {.w_px = 19,  .glyph_index = 4530},   /*Unicode: U+00ae (®)*/
    {.w_px = 8,   .glyph_index = 5100},   /*Unicode: U+00af (¯)*/
    {.w_px = 8,   .glyph_index = 5340},   /*Unicode: U+00b0 (°)*/
    {.w_px = 16,  .glyph_index = 5580},   /*Unicode: U+00b1 (±)*/
    {.w_px = 8,   .glyph_index = 6060},   /*Unicode: U+00b2 (²)*/
    {.w_px = 8,   .glyph_index = 6300},   /*Unicode: U+00b3 (³)*/
    {.w_px = 6,   .glyph_index = 6540},   /*Unicode: U+00b4 (´)*/
    {.w_px = 14,  .glyph_index = 6720},   /*Unicode: U+00b5 (µ)*/
    {.w_px = 12,  .glyph_index = 7140},   /*Unicode: U+00b6 (¶)*/
    {.w_px = 3,   .glyph_index = 7500},   /*Unicode: U+00b7 (·)*/
    {.w_px = 5,   .glyph_index = 7590},   /*Unicode: U+00b8 (¸)*/
    {.w_px = 8,   .glyph_index = 7740},   /*Unicode: U+00b9 (¹)*/
    {.w_px = 10,  .glyph_index = 7980},   /*Unicode: U+00ba (º)*/
    {.w_px = 12,  .glyph_index = 8280},   /*Unicode: U+00bb (»)*/
    {.w_px = 23,  .glyph_index = 8640},   /*Unicode: U+00bc (¼)*/
    {.w_px = 22,  .glyph_index = 9330},   /*Unicode: U+00bd (½)*/
    {.w_px = 24,  .glyph_index = 9990},   /*Unicode: U+00be (¾)*/
    {.w_px = 10,  .glyph_index = 10710},  /*Unicode: U+00bf (¿)*/
    {.w_px = 17,  .glyph_index = 11010},  /*Unicode: U+00c0 (À)*/
    {.w_px = 17,  .glyph_index = 11520},  /*Unicode: U+00c1 (Á)*/
    {.w_px = 17,  .glyph_index = 12030},  /*Unicode: U+00c2 (Â)*/
    {.w_px = 17,  .glyph_index = 12540},  /*Unicode: U+00c3 (Ã)*/
    {.w_px = 17,  .glyph_index = 13050},  /*Unicode: U+00c4 (Ä)*/
    {.w_px = 17,  .glyph_index = 13560},  /*Unicode: U+00c5 (Å)*/
    {.w_px = 23,  .glyph_index = 14070},  /*Unicode: U+00c6 (Æ)*/
    {.w_px = 15,  .glyph_index = 14760},  /*Unicode: U+00c7 (Ç)*/
    {.w_px = 12,  .glyph_index = 15210},  /*Unicode: U+00c8 (È)*/
    {.w_px = 12,  .glyph_index = 15570},  /*Unicode: U+00c9 (É)*/
    {.w_px = 12,  .glyph_index = 15930},  /*Unicode: U+00ca (Ê)*/
    {.w_px = 12,  .glyph_index = 16290},  /*Unicode: U+00cb (Ë)*/
    {.w_px = 5,   .glyph_index = 16650},  /*Unicode: U+00cc (Ì)*/
    {.w_px = 5,   .glyph_index = 16800},  /*Unicode: U+00cd (Í)*/
    {.w_px = 8,   .glyph_index = 16950},  /*Unicode: U+00ce (Î)*/
    {.w_px = 7,   .glyph_index = 17190},  /*Unicode: U+00cf (Ï)*/
    {.w_px = 19,  .glyph_index = 17400},  /*Unicode: U+00d0 (Ð)*/
    {.w_px = 14,  .glyph_index = 17970},  /*Unicode: U+00d1 (Ñ)*/
    {.w_px = 18,  .glyph_index = 18390},  /*Unicode: U+00d2 (Ò)*/
    {.w_px = 18,  .glyph_index = 18930},  /*Unicode: U+00d3 (Ó)*/
    {.w_px = 18,  .glyph_index = 19470},  /*Unicode: U+00d4 (Ô)*/
    {.w_px = 18,  .glyph_index = 20010},  /*Unicode: U+00d5 (Õ)*/
    {.w_px = 18,  .glyph_index = 20550},  /*Unicode: U+00d6 (Ö)*/
    {.w_px = 15,  .glyph_index = 21090},  /*Unicode: U+00d7 (×)*/
    {.w_px = 19,  .glyph_index = 21540},  /*Unicode: U+00d8 (Ø)*/
    {.w_px = 14,  .glyph_index = 22110},  /*Unicode: U+00d9 (Ù)*/
    {.w_px = 14,  .glyph_index = 22530},  /*Unicode: U+00da (Ú)*/
    {.w_px = 14,  .glyph_index = 22950},  /*Unicode: U+00db (Û)*/
    {.w_px = 14,  .glyph_index = 23370},  /*Unicode: U+00dc (Ü)*/
    {.w_px = 17,  .glyph_index = 23790},  /*Unicode: U+00dd (Ý)*/
    {.w_px = 12,  .glyph_index = 24300},  /*Unicode: U+00de (Þ)*/
    {.w_px = 13,  .glyph_index = 24660},  /*Unicode: U+00df (ß)*/
    {.w_px = 12,  .glyph_index = 25050},  /*Unicode: U+00e0 (à)*/
    {.w_px = 12,  .glyph_index = 25410},  /*Unicode: U+00e1 (á)*/
    {.w_px = 12,  .glyph_index = 25770},  /*Unicode: U+00e2 (â)*/
    {.w_px = 12,  .glyph_index = 26130},  /*Unicode: U+00e3 (ã)*/
    {.w_px = 12,  .glyph_index = 26490},  /*Unicode: U+00e4 (ä)*/
    {.w_px = 12,  .glyph_index = 26850},  /*Unicode: U+00e5 (å)*/
    {.w_px = 22,  .glyph_index = 27210},  /*Unicode: U+00e6 (æ)*/
    {.w_px = 11,  .glyph_index = 27870},  /*Unicode: U+00e7 (ç)*/
    {.w_px = 13,  .glyph_index = 28200},  /*Unicode: U+00e8 (è)*/
    {.w_px = 13,  .glyph_index = 28590},  /*Unicode: U+00e9 (é)*/
    {.w_px = 13,  .glyph_index = 28980},  /*Unicode: U+00ea (ê)*/
    {.w_px = 13,  .glyph_index = 29370},  /*Unicode: U+00eb (ë)*/
    {.w_px = 5,   .glyph_index = 29760},  /*Unicode: U+00ec (ì)*/
    {.w_px = 6,   .glyph_index = 29910},  /*Unicode: U+00ed (í)*/
    {.w_px = 8,   .glyph_index = 30090},  /*Unicode: U+00ee (î)*/
    {.w_px = 7,   .glyph_index = 30330},  /*Unicode: U+00ef (ï)*/
    {.w_px = 13,  .glyph_index = 30540},  /*Unicode: U+00f0 (ð)*/
    {.w_px = 12,  .glyph_index = 30930},  /*Unicode: U+00f1 (ñ)*/
    {.w_px = 13,  .glyph_index = 31290},  /*Unicode: U+00f2 (ò)*/
    {.w_px = 13,  .glyph_index = 31680},  /*Unicode: U+00f3 (ó)*/
    {.w_px = 13,  .glyph_index = 32070},  /*Unicode: U+00f4 (ô)*/
    {.w_px = 13,  .glyph_index = 32460},  /*Unicode: U+00f5 (õ)*/
    {.w_px = 13,  .glyph_index = 32850},  /*Unicode: U+00f6 (ö)*/
    {.w_px = 17,  .glyph_index = 33240},  /*Unicode: U+00f7 (÷)*/
    {.w_px = 15,  .glyph_index = 33750},  /*Unicode: U+00f8 (ø)*/
    {.w_px = 12,  .glyph_index = 34200},  /*Unicode: U+00f9 (ù)*/
    {.w_px = 12,  .glyph_index = 34560},  /*Unicode: U+00fa (ú)*/
    {.w_px = 12,  .glyph_index = 34920},  /*Unicode: U+00fb (û)*/
    {.w_px = 12,  .glyph_index = 35280},  /*Unicode: U+00fc (ü)*/
    {.w_px = 14,  .glyph_index = 35640},  /*Unicode: U+00fd (ý)*/
    {.w_px = 13,  .glyph_index = 36060},  /*Unicode: U+00fe (þ)*/
    {.w_px = 14,  .glyph_index = 36450},  /*Unicode: U+00ff (ÿ)*/

#endif
};

lv_font_t lv_font_dejavu_30_latin_sup = {
    .unicode_first = 160,   /*First Unicode letter in this font*/
    .unicode_last = 255,    /*Last Unicode letter in this font*/
    .h_px = 30,             /*Font height in pixels*/
    .glyph_bitmap = lv_font_dejavu_30_latin_sup_glyph_bitmap,   /*Bitmap of glyphs*/
    .glyph_dsc = lv_font_dejavu_30_latin_sup_glyph_dsc,     /*Description of glyphs*/
    .glyph_cnt = 96,            /*Number of glyphs in the font*/
    .unicode_list = NULL,   /*Every character in the font from 'unicode_first' to 'unicode_last'*/
    .get_bitmap = lv_font_get_bitmap_continuous,    /*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,  /*Function pointer to get glyph's width*/
#if USE_LV_FONT_DEJAVU_30_LATIN_SUP == 1
    .bpp = 1,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_30_LATIN_SUP == 2
    .bpp = 2,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_30_LATIN_SUP == 4
    .bpp = 4,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_30_LATIN_SUP == 8
    .bpp = 8,               /*Bit per pixel*/
#endif
    .monospace = 0,
    .next_page = NULL,      /*Pointer to a font extension*/
};

#endif /*USE_LV_FONT_DEJAVU_30_LATIN_SUP*/
