
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_DEJAVU_30_CYRILLIC != 0 /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * DejaVuSans.ttf 30 px Font in U+0410 (А) .. U+044f (я)  range with 1 bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_dejavu_30_cyrillic_glyph_bitmap[] = {
#if USE_LV_FONT_DEJAVU_30_CYRILLIC == 1
    /*Unicode: U+0410 (А) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //......+@@@+......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x07, 0x70, 0x00,  //.....@@@+@@@.....
    0x07, 0x70, 0x00,  //....+@@@.@@@+....
    0x0e, 0x38, 0x00,  //....%@@+.+@@%....
    0x0e, 0x38, 0x00,  //....@@@...@@@....
    0x0e, 0x38, 0x00,  //...+@@%...%@@+...
    0x1c, 0x1c, 0x00,  //...@@@+...+@@@...
    0x1c, 0x1c, 0x00,  //...@@@.....@@@...
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x3f, 0xfe, 0x00,  //..@@@@@@@@@@@@@..
    0x38, 0x0e, 0x00,  //.+@@@.......@@@+.
    0x70, 0x0f, 0x00,  //.%@@+.......+@@%.
    0x70, 0x07, 0x00,  //.@@@.........@@@.
    0x70, 0x07, 0x00,  //+@@%.........@@@+
    0xe0, 0x03, 0x80,  //@@@+.........+@@@
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0411 (Б) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0xff, 0xf0,  //@@@@@@@@@@@@.
    0xff, 0xf0,  //@@@@@@@@@@@@.
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xff, 0xc0,  //@@@@@@@@@%...
    0xff, 0xe0,  //@@@@@@@@@@@+.
    0xe0, 0x70,  //@@@.....+@@@+
    0xe0, 0x38,  //@@@......+@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@......+@@%
    0xe0, 0x70,  //@@@.....+@@@+
    0xff, 0xe0,  //@@@@@@@@@@@+.
    0xff, 0xc0,  //@@@@@@@@@%...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0412 (В) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0xff, 0x80,  //@@@@@@@@%+...
    0xff, 0xe0,  //@@@@@@@@@@%..
    0xe0, 0xe0,  //@@@....+@@@+.
    0xe0, 0x70,  //@@@.....+@@@.
    0xe0, 0x70,  //@@@......@@@.
    0xe0, 0x70,  //@@@......@@@.
    0xe0, 0x70,  //@@@.....+@@%.
    0xe0, 0xe0,  //@@@....+@@@..
    0xff, 0xc0,  //@@@@@@@@@%...
    0xff, 0xc0,  //@@@@@@@@@@+..
    0xe0, 0xf0,  //@@@.....%@@%.
    0xe0, 0x70,  //@@@......%@@+
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x78,  //@@@......%@@%
    0xe0, 0xf0,  //@@@.....%@@@.
    0xff, 0xe0,  //@@@@@@@@@@@+.
    0xff, 0xc0,  //@@@@@@@@@%...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0413 (Г) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0414 (Д) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x0f, 0xff, 0x00,  //....@@@@@@@@@@@@..
    0x0f, 0xff, 0x00,  //....@@@@@@@@@@@@..
    0x0e, 0x07, 0x00,  //....@@@......@@@..
    0x0e, 0x07, 0x00,  //....@@@......@@@..
    0x0e, 0x07, 0x00,  //....@@@......@@@..
    0x0e, 0x07, 0x00,  //....@@@......@@@..
    0x0e, 0x07, 0x00,  //....@@@......@@@..
    0x0e, 0x07, 0x00,  //....@@@......@@@..
    0x0e, 0x07, 0x00,  //....@@@......@@@..
    0x0e, 0x07, 0x00,  //....@@%......@@@..
    0x0e, 0x07, 0x00,  //...+@@%......@@@..
    0x1e, 0x07, 0x00,  //...+@@+......@@@..
    0x1c, 0x07, 0x00,  //...%@@+......@@@..
    0x1c, 0x07, 0x00,  //...@@@.......@@@..
    0x1c, 0x07, 0x00,  //...@@@.......@@@..
    0x3c, 0x07, 0x00,  //..%@@%.......@@@..
    0x38, 0x07, 0x00,  //.+@@@........@@@..
    0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@
    0xc0, 0x00, 0xc0,  //@@..............@@
    0xc0, 0x00, 0xc0,  //@@..............@@
    0xc0, 0x00, 0xc0,  //@@..............@@
    0xc0, 0x00, 0xc0,  //@@..............@@
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0415 (Е) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xff, 0xe0,  //@@@@@@@@@@@.
    0xff, 0xe0,  //@@@@@@@@@@@.
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0416 (Ж) , Width: 27 */
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0xf8, 0x0e, 0x03, 0xe0,  //%@@@%.......@@@.......%@@@%
    0x7c, 0x0e, 0x07, 0xc0,  //.%@@@%......@@@......%@@@%.
    0x3c, 0x0e, 0x07, 0x80,  //..%@@@+.....@@@.....+@@@%..
    0x1e, 0x0e, 0x0f, 0x00,  //...%@@@+....@@@....+@@@%...
    0x0f, 0x0e, 0x1e, 0x00,  //....%@@@+...@@@...+@@@%....
    0x07, 0x8e, 0x3c, 0x00,  //.....@@@@+..@@@..+@@@@.....
    0x03, 0xce, 0x78, 0x00,  //......@@@@..@@@..@@@@......
    0x01, 0xee, 0xf0, 0x00,  //.......@@@@.@@@.@@@@.......
    0x03, 0xff, 0xf8, 0x00,  //......%@@@@@@@@@@@@@%......
    0x03, 0xff, 0xf8, 0x00,  //......@@@@@@@@@@@@@@@......
    0x07, 0xbf, 0xbc, 0x00,  //.....@@@%.@@@@@@@.%@@@.....
    0x07, 0x1f, 0x1c, 0x00,  //....+@@@...@@@@@...@@@+....
    0x0e, 0x0e, 0x1e, 0x00,  //....@@@+...+@@@+...+@@@....
    0x1e, 0x0e, 0x0f, 0x00,  //...%@@@.....@@@.....@@@%...
    0x1c, 0x0e, 0x07, 0x00,  //...@@@+.....@@@.....+@@@...
    0x3c, 0x0e, 0x07, 0x80,  //..@@@%......@@@......%@@@..
    0x38, 0x0e, 0x03, 0x80,  //.+@@@.......@@@.......@@@+.
    0x70, 0x0e, 0x01, 0xc0,  //.@@@+.......@@@.......+@@@.
    0xf0, 0x0e, 0x01, 0xe0,  //%@@@........@@@........@@@%
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+0417 (З) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x1f, 0x80,  //..+%@@@@%+...
    0x7f, 0xe0,  //.@@@@@@@@@@+.
    0xe0, 0x70,  //@@@+....+@@@+
    0xc0, 0x38,  //@@.......+@@@
    0x80, 0x38,  //%.........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x78,  //........+@@@%
    0x1f, 0xf0,  //...@@@@@@@@@.
    0x1f, 0xc0,  //...@@@@@@@+..
    0x00, 0xe0,  //.......+@@@+.
    0x00, 0x70,  //.........%@@.
    0x00, 0x38,  //..........@@%
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //+.........@@@
    0x80, 0x78,  //@+.......@@@%
    0xe0, 0xf0,  //@@%+...+@@@@.
    0x7f, 0xe0,  //+@@@@@@@@@%..
    0x1f, 0x80,  //..+%@@@@%....
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0418 (И) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xe0, 0x3c,  //@@@.......@@@@
    0xe0, 0x7c,  //@@@......%@@@@
    0xe0, 0x7c,  //@@@......@@@@@
    0xe0, 0xfc,  //@@@.....%@@@@@
    0xe0, 0xfc,  //@@@.....@@@@@@
    0xe1, 0xfc,  //@@@....%@@%@@@
    0xe1, 0xdc,  //@@@...+@@@.@@@
    0xe3, 0xdc,  //@@@...@@@%.@@@
    0xe3, 0x9c,  //@@@..+@@@..@@@
    0xe7, 0x9c,  //@@@..@@@%..@@@
    0xe7, 0x1c,  //@@@.+@@@...@@@
    0xef, 0x1c,  //@@@.@@@%...@@@
    0xee, 0x1c,  //@@@+@@@....@@@
    0xfe, 0x1c,  //@@@@@@%....@@@
    0xfc, 0x1c,  //@@@@@@.....@@@
    0xfc, 0x1c,  //@@@@@%.....@@@
    0xf8, 0x1c,  //@@@@@......@@@
    0xf8, 0x1c,  //@@@@%......@@@
    0xf0, 0x1c,  //@@@@.......@@@
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0419 (Й) , Width: 14 */
    0x18, 0x60,  //...@@+..+@@...
    0x0f, 0xc0,  //...+@@@@@@+...
    0x07, 0x80,  //....+@@@@+....
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xe0, 0x3c,  //@@@.......@@@@
    0xe0, 0x7c,  //@@@......%@@@@
    0xe0, 0x7c,  //@@@......@@@@@
    0xe0, 0xfc,  //@@@.....%@@@@@
    0xe0, 0xfc,  //@@@.....@@@@@@
    0xe1, 0xfc,  //@@@....%@@%@@@
    0xe1, 0xdc,  //@@@...+@@@.@@@
    0xe3, 0xdc,  //@@@...@@@%.@@@
    0xe3, 0x9c,  //@@@..+@@@..@@@
    0xe7, 0x9c,  //@@@..@@@%..@@@
    0xe7, 0x1c,  //@@@.+@@@...@@@
    0xef, 0x1c,  //@@@.@@@%...@@@
    0xee, 0x1c,  //@@@+@@@....@@@
    0xfe, 0x1c,  //@@@@@@%....@@@
    0xfc, 0x1c,  //@@@@@@.....@@@
    0xfc, 0x1c,  //@@@@@%.....@@@
    0xf8, 0x1c,  //@@@@@......@@@
    0xf8, 0x1c,  //@@@@%......@@@
    0xf0, 0x1c,  //@@@@.......@@@
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+041a (К) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xe0, 0x3e,  //@@@.......%@@@%
    0xe0, 0x7c,  //@@@......%@@@%.
    0xe0, 0x78,  //@@@.....+@@@%..
    0xe0, 0xf0,  //@@@....+@@@%...
    0xe1, 0xe0,  //@@@...+@@@%....
    0xe3, 0xc0,  //@@@..+@@@@.....
    0xe7, 0x80,  //@@@..@@@@......
    0xef, 0x00,  //@@@.@@@@.......
    0xff, 0x80,  //@@@@@@@@%......
    0xff, 0x80,  //@@@@@@@@@......
    0xfb, 0xc0,  //@@@@@.%@@@.....
    0xf1, 0xc0,  //@@@@...@@@+....
    0xe1, 0xe0,  //@@@+...%@@@....
    0xe0, 0xf0,  //@@@.....@@@%...
    0xe0, 0x70,  //@@@.....+@@@...
    0xe0, 0x78,  //@@@......%@@@..
    0xe0, 0x38,  //@@@.......@@@+.
    0xe0, 0x1c,  //@@@.......+@@@.
    0xe0, 0x1e,  //@@@........@@@%
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+041b (Л) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x07, 0xff,  //.....@@@@@@@@@@@
    0x07, 0xff,  //.....@@@@@@@@@@@
    0x07, 0x07,  //.....@@@.....@@@
    0x07, 0x07,  //.....@@@.....@@@
    0x07, 0x07,  //.....@@@.....@@@
    0x07, 0x07,  //.....@@@.....@@@
    0x07, 0x07,  //.....@@@.....@@@
    0x07, 0x07,  //.....@@@.....@@@
    0x07, 0x07,  //.....@@@.....@@@
    0x07, 0x07,  //....+@@%.....@@@
    0x07, 0x07,  //....+@@%.....@@@
    0x0e, 0x07,  //....%@@+.....@@@
    0x0e, 0x07,  //....%@@+.....@@@
    0x0e, 0x07,  //....@@@......@@@
    0x0e, 0x07,  //...+@@%......@@@
    0x1c, 0x07,  //...@@@+......@@@
    0x3c, 0x07,  //.+@@@%.......@@@
    0xf0, 0x07,  //@@@@+........@@@
    0xc0, 0x07,  //@%+..........@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+041c (М) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xfc, 0x1f, 0x80,  //@@@@@%.....%@@@@@
    0xfc, 0x1f, 0x80,  //@@@@@@.....@@@@@@
    0xfc, 0x1f, 0x80,  //@@@@@@.....@@@@@@
    0xfe, 0x3f, 0x80,  //@@@%@@%...%@@%@@@
    0xee, 0x3b, 0x80,  //@@@.@@@...@@@.@@@
    0xee, 0x3b, 0x80,  //@@@.@@@+.+@@@.@@@
    0xef, 0x7b, 0x80,  //@@@.%@@%.%@@%.@@@
    0xe7, 0x73, 0x80,  //@@@..@@@.@@@..@@@
    0xe7, 0xf3, 0x80,  //@@@..@@@%@@@..@@@
    0xe7, 0xf3, 0x80,  //@@@..%@@@@@%..@@@
    0xe3, 0xe3, 0x80,  //@@@...@@@@@...@@@
    0xe3, 0xe3, 0x80,  //@@@...@@@@@...@@@
    0xe1, 0xc3, 0x80,  //@@@...+@@@+...@@@
    0xe1, 0xc3, 0x80,  //@@@....@@@....@@@
    0xe1, 0xc3, 0x80,  //@@@....@@@....@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+041d (Н) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xff, 0xfc,  //@@@@@@@@@@@@@@
    0xff, 0xfc,  //@@@@@@@@@@@@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+041e (О) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x03, 0xf0, 0x00,  //.....+%@@@@%+.....
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@+...
    0x1e, 0x1e, 0x00,  //..+@@@%....%@@@+..
    0x38, 0x07, 0x00,  //.+@@@........@@@..
    0x70, 0x03, 0x80,  //.@@@+........+@@@.
    0x70, 0x03, 0x80,  //+@@@..........%@@+
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0x70, 0x03, 0x80,  //+@@@..........%@@+
    0x70, 0x03, 0x80,  //.@@@+........+@@@.
    0x38, 0x07, 0x00,  //.+@@@........@@@+.
    0x1e, 0x1e, 0x00,  //..+@@@%....%@@@+..
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@+...
    0x03, 0xf0, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+041f (П) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xff, 0xfc,  //@@@@@@@@@@@@@@
    0xff, 0xfc,  //@@@@@@@@@@@@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0420 (Р) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xff, 0x80,  //@@@@@@@@%...
    0xff, 0xc0,  //@@@@@@@@@@+.
    0xe0, 0xe0,  //@@@....+@@@+
    0xe0, 0xf0,  //@@@.....%@@%
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0xf0,  //@@@.....+@@%
    0xe0, 0xe0,  //@@@....+@@@+
    0xff, 0xc0,  //@@@@@@@@@@+.
    0xff, 0x80,  //@@@@@@@@%...
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0421 (С) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x03, 0xf0,  //.....+%@@@@%+..
    0x0f, 0xfc,  //...+@@@@@@@@@@+
    0x1e, 0x0e,  //..+@@@%....+@@@
    0x38, 0x06,  //.+@@@........%@
    0x70, 0x00,  //.@@@+.........+
    0x70, 0x00,  //+@@%...........
    0xe0, 0x00,  //%@@+...........
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //%@@+...........
    0x70, 0x00,  //+@@%...........
    0x70, 0x00,  //.@@@..........+
    0x38, 0x06,  //.+@@@........%@
    0x1e, 0x0e,  //..+@@@%....+@@@
    0x0f, 0xfc,  //...+@@@@@@@@@@+
    0x03, 0xf0,  //.....+%@@@@%+..
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+0422 (Т) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0423 (У) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xe0, 0x0e,  //@@@+.......+@@@
    0x70, 0x1c,  //+@@@.......@@@+
    0x70, 0x1c,  //.@@@+.....+@@@.
    0x78, 0x3c,  //.%@@%.....%@@+.
    0x38, 0x38,  //..@@@.....@@@..
    0x3c, 0x78,  //..%@@%...%@@%..
    0x1c, 0x70,  //..+@@@...@@@...
    0x1c, 0x70,  //...@@@+.+@@@...
    0x0e, 0xe0,  //...+@@@.@@@+...
    0x0f, 0xe0,  //....@@@%@@@....
    0x0f, 0xe0,  //....%@@@@@%....
    0x07, 0xc0,  //.....@@@@@.....
    0x07, 0xc0,  //.....@@@@%.....
    0x03, 0x80,  //.....+@@@......
    0x03, 0x80,  //......@@@......
    0x03, 0x00,  //.....+@@+......
    0x07, 0x00,  //.....@@@.......
    0x3e, 0x00,  //..@@@@@+.......
    0x3c, 0x00,  //..@@@%+........
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+0424 (Ф) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x07, 0xfc, 0x00,  //.....%@@@@@@@%.....
    0x1f, 0xff, 0x00,  //...@@@@@@@@@@@@@...
    0x3c, 0xe7, 0x80,  //..@@@%+.@@@.+%@@@..
    0x70, 0xe1, 0xc0,  //.@@@+...@@@...+@@@.
    0x70, 0xe1, 0xc0,  //+@@%....@@@....%@@+
    0xe0, 0xe0, 0xe0,  //%@@+....@@@....+@@%
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@%
    0x70, 0xe1, 0xc0,  //+@@%....@@@....%@@+
    0x70, 0xe1, 0xc0,  //.@@@....@@@....@@@.
    0x38, 0xe3, 0x80,  //..@@@+..@@@..+@@@..
    0x1f, 0xff, 0x00,  //...@@@@@@@@@@@@@...
    0x07, 0xfc, 0x00,  //.....%@@@@@@@%.....
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0425 (Х) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x78, 0x0f,  //.%@@@.......@@@%
    0x3c, 0x1e,  //..@@@+.....%@@@.
    0x1c, 0x1c,  //..+@@@.....@@@+.
    0x1e, 0x3c,  //...@@@%...@@@%..
    0x0e, 0x78,  //...+@@@+.%@@@...
    0x0f, 0x70,  //....%@@@.@@@+...
    0x07, 0xf0,  //.....@@@@@@%....
    0x03, 0xe0,  //.....+@@@@@.....
    0x03, 0xc0,  //......@@@@+.....
    0x03, 0xc0,  //......@@@@+.....
    0x03, 0xe0,  //.....+@@@@@.....
    0x07, 0xe0,  //.....@@@@@@+....
    0x0f, 0x70,  //....%@@@+@@@....
    0x0e, 0x78,  //...+@@@..@@@%...
    0x1e, 0x38,  //...@@@%...@@@+..
    0x3c, 0x3c,  //..%@@@....%@@@..
    0x38, 0x1c,  //.+@@@......@@@+.
    0x78, 0x0e,  //.@@@%......+@@@.
    0xf0, 0x0f,  //%@@@........@@@%
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0426 (Ц) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xe0, 0x1c,  //@@@........@@@..
    0xe0, 0x1c,  //@@@........@@@..
    0xe0, 0x1c,  //@@@........@@@..
    0xe0, 0x1c,  //@@@........@@@..
    0xe0, 0x1c,  //@@@........@@@..
    0xe0, 0x1c,  //@@@........@@@..
    0xe0, 0x1c,  //@@@........@@@..
    0xe0, 0x1c,  //@@@........@@@..
    0xe0, 0x1c,  //@@@........@@@..
    0xe0, 0x1c,  //@@@........@@@..
    0xe0, 0x1c,  //@@@........@@@..
    0xe0, 0x1c,  //@@@........@@@..
    0xe0, 0x1c,  //@@@........@@@..
    0xe0, 0x1c,  //@@@........@@@..
    0xe0, 0x1c,  //@@@........@@@..
    0xe0, 0x1c,  //@@@........@@@..
    0xe0, 0x1c,  //@@@........@@@..
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x03,  //..............@@
    0x00, 0x03,  //..............@@
    0x00, 0x03,  //..............@@
    0x00, 0x03,  //..............@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0427 (Ч) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //%@@+......@@@
    0x70, 0x38,  //+@@@+.....@@@
    0x7f, 0xf8,  //.%@@@@@@@@@@@
    0x1f, 0xf8,  //..+@@@@@@@@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0428 (Ш) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xe0, 0x38, 0x0e,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xfe,  //@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0429 (Щ) , Width: 25 */
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xe0, 0x38, 0x0e, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x01, 0x80,  //.......................@@
    0x00, 0x00, 0x01, 0x80,  //.......................@@
    0x00, 0x00, 0x01, 0x80,  //.......................@@
    0x00, 0x00, 0x01, 0x80,  //.......................@@
    0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+042a (Ъ) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0xff, 0x00, 0x00,  //@@@@@@@@..........
    0xff, 0x00, 0x00,  //@@@@@@@@..........
    0x07, 0x00, 0x00,  //.....@@@..........
    0x07, 0x00, 0x00,  //.....@@@..........
    0x07, 0x00, 0x00,  //.....@@@..........
    0x07, 0x00, 0x00,  //.....@@@..........
    0x07, 0x00, 0x00,  //.....@@@..........
    0x07, 0x00, 0x00,  //.....@@@..........
    0x07, 0xfe, 0x00,  //.....@@@@@@@@@%...
    0x07, 0xff, 0x00,  //.....@@@@@@@@@@@+.
    0x07, 0x07, 0x80,  //.....@@@.....%@@@+
    0x07, 0x03, 0xc0,  //.....@@@......%@@%
    0x07, 0x01, 0xc0,  //.....@@@.......@@@
    0x07, 0x01, 0xc0,  //.....@@@.......@@@
    0x07, 0x01, 0xc0,  //.....@@@.......@@@
    0x07, 0x01, 0xc0,  //.....@@@......+@@%
    0x07, 0x03, 0x80,  //.....@@@.....+@@@.
    0x07, 0xff, 0x00,  //.....@@@@@@@@@@@+.
    0x07, 0xfe, 0x00,  //.....@@@@@@@@@%...
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+042b (Ы) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xff, 0xc1, 0xc0,  //@@@@@@@@@%.....@@@
    0xff, 0xe1, 0xc0,  //@@@@@@@@@@@+...@@@
    0xe0, 0x71, 0xc0,  //@@@.....+@@@+..@@@
    0xe0, 0x39, 0xc0,  //@@@......+@@%..@@@
    0xe0, 0x39, 0xc0,  //@@@.......@@@..@@@
    0xe0, 0x39, 0xc0,  //@@@.......@@@..@@@
    0xe0, 0x39, 0xc0,  //@@@.......@@@..@@@
    0xe0, 0x39, 0xc0,  //@@@......+@@%..@@@
    0xe0, 0x71, 0xc0,  //@@@.....+@@@...@@@
    0xff, 0xe1, 0xc0,  //@@@@@@@@@@@+...@@@
    0xff, 0xc1, 0xc0,  //@@@@@@@@@%.....@@@
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+042c (Ь) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xff, 0xc0,  //@@@@@@@@@%...
    0xff, 0xe0,  //@@@@@@@@@@@+.
    0xe0, 0x70,  //@@@.....+@@@+
    0xe0, 0x38,  //@@@......+@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@......+@@%
    0xe0, 0x70,  //@@@.....+@@@.
    0xff, 0xe0,  //@@@@@@@@@@@+.
    0xff, 0xc0,  //@@@@@@@@@%...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+042d (Э) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x1f, 0x80,  //..+%@@@@%+.....
    0x7f, 0xe0,  //+@@@@@@@@@@+...
    0xe0, 0x70,  //@@@+....+@@@+..
    0xc0, 0x38,  //@%........@@@+.
    0x00, 0x1c,  //+..........@@@.
    0x00, 0x1c,  //...........%@@+
    0x00, 0x0e,  //...........+@@%
    0x00, 0x0e,  //............@@@
    0x3f, 0xfe,  //..@@@@@@@@@@@@@
    0x3f, 0xfe,  //..@@@@@@@@@@@@@
    0x00, 0x0e,  //............@@@
    0x00, 0x0e,  //............@@@
    0x00, 0x0e,  //...........+@@%
    0x00, 0x1c,  //...........@@@+
    0x00, 0x1c,  //+.........+@@@.
    0xc0, 0x38,  //@%........@@@+.
    0xe0, 0xf0,  //@@@+....%@@@+..
    0x7f, 0xe0,  //+@@@@@@@@@@+...
    0x1f, 0x80,  //..+%@@@@%+.....
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+042e (Ю) , Width: 24 */
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0xe0, 0x0f, 0xc0,  //@@@........+%@@@@%+.....
    0xe0, 0x3f, 0xf0,  //@@@......+@@@@@@@@@@+...
    0xe0, 0xf8, 0x78,  //@@@.....%@@@%....%@@@+..
    0xe0, 0xe0, 0x1c,  //@@@....+@@@........@@@..
    0xe1, 0xc0, 0x0e,  //@@@....@@@+........+@@@.
    0xe1, 0xc0, 0x0e,  //@@@...+@@@..........@@@+
    0xe3, 0x80, 0x07,  //@@@...@@@+..........+@@%
    0xe3, 0x80, 0x07,  //@@@...@@@............@@@
    0xff, 0x80, 0x07,  //@@@@@@@@@............@@@
    0xff, 0x80, 0x07,  //@@@@@@@@@............@@@
    0xe3, 0x80, 0x07,  //@@@...@@@............@@@
    0xe3, 0x80, 0x07,  //@@@...@@@............@@@
    0xe3, 0x80, 0x07,  //@@@...%@@+..........+@@%
    0xe1, 0xc0, 0x0e,  //@@@....@@@..........@@@+
    0xe1, 0xc0, 0x0e,  //@@@....%@@+........+@@@.
    0xe0, 0xe0, 0x1c,  //@@@.....@@@........@@@..
    0xe0, 0x78, 0x78,  //@@@.....+@@@%....%@@@+..
    0xe0, 0x3f, 0xf0,  //@@@.......@@@@@@@@@@+...
    0xe0, 0x0f, 0xc0,  //@@@........+%@@@@%+.....
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................


    /*Unicode: U+042f (Я) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x0f, 0xfc,  //....%@@@@@@@@@
    0x1f, 0xfc,  //..+@@@@@@@@@@@
    0x38, 0x1c,  //..@@@+.....@@@
    0x70, 0x1c,  //.%@@+......@@@
    0x70, 0x1c,  //.@@@.......@@@
    0x70, 0x1c,  //.@@@.......@@@
    0x70, 0x1c,  //.@@@.......@@@
    0x70, 0x1c,  //.%@@+......@@@
    0x38, 0x1c,  //..@@@+.....@@@
    0x1f, 0xfc,  //...@@@@@@@@@@@
    0x07, 0xfc,  //....+@@@@@@@@@
    0x07, 0x9c,  //.....@@@%..@@@
    0x0f, 0x1c,  //....%@@@...@@@
    0x0e, 0x1c,  //...+@@@....@@@
    0x1e, 0x1c,  //...@@@%....@@@
    0x3c, 0x1c,  //..%@@@.....@@@
    0x38, 0x1c,  //.+@@@+.....@@@
    0x78, 0x1c,  //.@@@%......@@@
    0xf0, 0x1c,  //%@@@.......@@@
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0430 (а) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x1f, 0x80,  //..+%@@@@%...
    0x7f, 0xc0,  //.@@@@@@@@@+.
    0x40, 0xe0,  //.@+....+@@@.
    0x00, 0x70,  //........+@@%
    0x00, 0x70,  //.........@@@
    0x1f, 0xf0,  //..+%@@@@@@@@
    0x7f, 0xf0,  //.%@@@@@@@@@@
    0xf0, 0x70,  //+@@@+....@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@.....+@@@
    0xe0, 0xf0,  //@@@.....@@@@
    0xf1, 0xf0,  //%@@@...%%@@@
    0x7f, 0x70,  //.@@@@@@@.@@@
    0x3e, 0x70,  //..%@@@%..@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0431 (б) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x03, 0xf0,  //.....+%@@@@@+.
    0x0f, 0xf8,  //....@@@@@@@@%.
    0x1f, 0x00,  //...@@@@%+.....
    0x3c, 0x00,  //..@@@%........
    0x38, 0x00,  //.+@@%.........
    0x70, 0x00,  //.%@@..........
    0x77, 0xc0,  //.@@@.%@@@@+...
    0x7f, 0xf0,  //.@@@@@@@@@@@..
    0x7c, 0x78,  //.@@@@%...%@@@.
    0x78, 0x38,  //.@@@@.....@@@+
    0x70, 0x1c,  //.@@@+.....+@@%
    0x70, 0x1c,  //.@@@.......@@@
    0x70, 0x1c,  //.@@@.......@@@
    0x70, 0x1c,  //.@@@.......@@@
    0x70, 0x1c,  //.@@@.......@@@
    0x70, 0x1c,  //.%@@+.....+@@%
    0x38, 0x38,  //.+@@@.....@@@+
    0x3c, 0x78,  //..@@@%...%@@%.
    0x1f, 0xf0,  //...@@@@@@@@@..
    0x07, 0xc0,  //....+%@@@%+...
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0432 (в) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xff, 0x00,  //@@@@@@@%...
    0xff, 0x80,  //@@@@@@@@@+.
    0xe3, 0xc0,  //@@@...%@@@.
    0xe1, 0xc0,  //@@@....@@@.
    0xe1, 0xc0,  //@@@....@@@.
    0xe3, 0x80,  //@@@...%@@+.
    0xff, 0x00,  //@@@@@@@@...
    0xff, 0xc0,  //@@@@@@@@@%.
    0xe1, 0xe0,  //@@@....%@@%
    0xe0, 0xe0,  //@@@.....@@@
    0xe0, 0xe0,  //@@@.....@@@
    0xe1, 0xe0,  //@@@....%@@%
    0xff, 0xc0,  //@@@@@@@@@@.
    0xff, 0x80,  //@@@@@@@@%..
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0433 (г) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xff, 0xe0,  //@@@@@@@@@@@
    0xff, 0xe0,  //@@@@@@@@@@@
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0434 (д) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x0f, 0xf8,  //....@@@@@@@@@..
    0x0f, 0xf8,  //....@@@@@@@@@..
    0x0e, 0x38,  //....@@@...@@@..
    0x0e, 0x38,  //....@@@...@@@..
    0x0e, 0x38,  //....@@@...@@@..
    0x0e, 0x38,  //....@@@...@@@..
    0x0e, 0x38,  //....@@@...@@@..
    0x0e, 0x38,  //...+@@%...@@@..
    0x1e, 0x38,  //...%@@%...@@@..
    0x1c, 0x38,  //...@@@....@@@..
    0x1c, 0x38,  //..+@@@....@@@..
    0x38, 0x38,  //.+@@@+....@@@..
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xc0, 0x06,  //@@...........@@
    0xc0, 0x06,  //@@...........@@
    0xc0, 0x06,  //@@...........@@
    0xc0, 0x06,  //@@...........@@
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+0435 (е) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //....%@@@@+...
    0x3f, 0xe0,  //..%@@@@@@@@..
    0x78, 0xf0,  //.%@@@...%@@@.
    0x70, 0x70,  //.@@@.....%@@+
    0xe0, 0x38,  //%@@+......@@%
    0xe0, 0x38,  //@@@.......@@@
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //%@@+.........
    0x70, 0x00,  //.@@@.........
    0x78, 0x10,  //.%@@@+....+@.
    0x3f, 0xf0,  //..%@@@@@@@@@.
    0x0f, 0xc0,  //....%@@@@%+..
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0436 (ж) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x78, 0x70, 0xf0,  //.%@@@+...@@@...+@@@%.
    0x3c, 0x71, 0xe0,  //..%@@@...@@@...@@@%..
    0x1e, 0x73, 0xc0,  //...@@@@..@@@..@@@@...
    0x0f, 0x77, 0x80,  //....@@@@.@@@.@@@@....
    0x07, 0xff, 0x00,  //.....@@@%@@@%@@@.....
    0x07, 0xff, 0x00,  //.....%@@@@@@@@@%.....
    0x07, 0xff, 0x00,  //.....@@@@@@@@@@@.....
    0x0f, 0xff, 0x80,  //....@@@@@@@@@@@@@....
    0x0e, 0xfb, 0x80,  //...+@@@.@@@@%.@@@+...
    0x1c, 0x71, 0xc0,  //...@@@+..@@@..+@@@...
    0x3c, 0x71, 0xe0,  //..%@@@...@@@...@@@%..
    0x38, 0x70, 0xe0,  //.+@@@....@@@....@@@+.
    0x78, 0x70, 0xf0,  //.@@@%....@@@....%@@@.
    0xf0, 0x70, 0x78,  //%@@@.....@@@.....@@@%
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0437 (з) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x3f, 0x00,  //.+%@@@@%+..
    0xff, 0xc0,  //@@@@@@@@@@.
    0x81, 0xe0,  //@+....+%@@@
    0x00, 0xe0,  //........@@@
    0x01, 0xe0,  //.......%@@@
    0x1f, 0xc0,  //...@@@@@@@.
    0x1f, 0x80,  //...@@@@@%..
    0x01, 0xc0,  //......+@@@.
    0x00, 0xe0,  //.......+@@%
    0x00, 0xe0,  //........@@@
    0x00, 0xe0,  //.......+@@@
    0x81, 0xe0,  //%+....+@@@%
    0xff, 0xc0,  //@@@@@@@@@%.
    0x7f, 0x00,  //.%@@@@@%+..
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0438 (и) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe0, 0xf0,  //@@@.....@@@@
    0xe1, 0xf0,  //@@@....%@@@@
    0xe1, 0xf0,  //@@@....@@@@@
    0xe3, 0xf0,  //@@@...@@@@@@
    0xe7, 0xf0,  //@@@..%@@@@@@
    0xe7, 0x70,  //@@@..@@@+@@@
    0xef, 0x70,  //@@@.@@@@.@@@
    0xfe, 0x70,  //@@@%@@@+.@@@
    0xfe, 0x70,  //@@@@@@%..@@@
    0xfc, 0x70,  //@@@@@@...@@@
    0xfc, 0x70,  //@@@@@%...@@@
    0xf8, 0x70,  //@@@@@....@@@
    0xf0, 0x70,  //@@@@+....@@@
    0xf0, 0x70,  //@@@@.....@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0439 (й) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x30, 0xc0,  //..@@....@@..
    0x39, 0xc0,  //..%@%..%@%..
    0x1f, 0x80,  //...@@@@@@...
    0x0f, 0x00,  //....%@@%....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe0, 0xf0,  //@@@.....@@@@
    0xe1, 0xf0,  //@@@....%@@@@
    0xe1, 0xf0,  //@@@....@@@@@
    0xe3, 0xf0,  //@@@...@@@@@@
    0xe7, 0xf0,  //@@@..%@@@@@@
    0xe7, 0x70,  //@@@..@@@+@@@
    0xef, 0x70,  //@@@.@@@@.@@@
    0xfe, 0x70,  //@@@%@@@+.@@@
    0xfe, 0x70,  //@@@@@@%..@@@
    0xfc, 0x70,  //@@@@@@...@@@
    0xfc, 0x70,  //@@@@@%...@@@
    0xf8, 0x70,  //@@@@@....@@@
    0xf0, 0x70,  //@@@@+....@@@
    0xf0, 0x70,  //@@@@.....@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+043a (к) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe1, 0xe0,  //@@@...+@@@%.
    0xe3, 0xc0,  //@@@...@@@%..
    0xe7, 0x80,  //@@@..@@@@...
    0xef, 0x00,  //@@@.@@@@....
    0xfe, 0x00,  //@@@%@@@.....
    0xfe, 0x00,  //@@@@@@%.....
    0xfe, 0x00,  //@@@@@@@.....
    0xff, 0x00,  //@@@@@@@@....
    0xf7, 0x00,  //@@@%.@@@+...
    0xe7, 0x80,  //@@@..%@@@...
    0xe3, 0xc0,  //@@@...@@@%..
    0xe1, 0xc0,  //@@@....@@@+.
    0xe1, 0xe0,  //@@@....%@@@.
    0xe0, 0xf0,  //@@@.....@@@%
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+043b (л) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x0f, 0xfc,  //....@@@@@@@@@@
    0x0f, 0xfc,  //....@@@@@@@@@@
    0x0e, 0x1c,  //....@@@....@@@
    0x0e, 0x1c,  //....@@@....@@@
    0x0e, 0x1c,  //....@@@....@@@
    0x0e, 0x1c,  //....@@@....@@@
    0x0e, 0x1c,  //....@@@....@@@
    0x0e, 0x1c,  //...+@@%....@@@
    0x0e, 0x1c,  //...+@@%....@@@
    0x1c, 0x1c,  //...%@@+....@@@
    0x1c, 0x1c,  //...@@@.....@@@
    0x38, 0x1c,  //.+@@@+.....@@@
    0xf0, 0x1c,  //@@@@+......@@@
    0xe0, 0x1c,  //@@+........@@@
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+043c (м) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xfc, 0x7e,  //@@@@@%...%@@@@@
    0xfc, 0x7e,  //@@@@@@...@@@@@@
    0xfc, 0x7e,  //@@@@@@+.+@@@@@@
    0xee, 0xee,  //@@@+@@%.%@@+@@@
    0xee, 0xee,  //@@@.@@@+@@@.@@@
    0xef, 0xee,  //@@@.%@@@@@%.@@@
    0xe7, 0xce,  //@@@.+@@@@@+.@@@
    0xe7, 0xce,  //@@@..@@@@@..@@@
    0xe7, 0xce,  //@@@..%@@@%..@@@
    0xe3, 0x8e,  //@@@...@@@...@@@
    0xe3, 0x8e,  //@@@...%@%...@@@
    0xe0, 0x0e,  //@@@.........@@@
    0xe0, 0x0e,  //@@@.........@@@
    0xe0, 0x0e,  //@@@.........@@@
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+043d (н) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+043e (о) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //...+%@@@%+...
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x78, 0xf0,  //.%@@%...%@@%.
    0x70, 0x70,  //+@@@.....@@@+
    0xe0, 0x38,  //%@@+.....+@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //%@@+.....+@@%
    0x70, 0x70,  //+@@@.....@@@+
    0x78, 0xf0,  //.%@@%...%@@%.
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x0f, 0x80,  //...+%@@@%+...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+043f (п) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0440 (р) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0xe7, 0xc0,  //@@@..%@@@%...
    0xef, 0xe0,  //@@@.@@@@@@@..
    0xf8, 0xf0,  //@@@%%...%@@@.
    0xf0, 0x70,  //@@@@.....@@@+
    0xe0, 0x38,  //@@@+.....+@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@+.....+@@%
    0xf0, 0x70,  //@@@@.....@@@+
    0xf8, 0xf0,  //@@@%%...%@@@.
    0xef, 0xe0,  //@@@.@@@@@@@..
    0xe7, 0xc0,  //@@@..%@@@%...
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0x00, 0x00,  //.............


    /*Unicode: U+0441 (с) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x0f, 0xc0,  //....%@@@@%.
    0x3f, 0xe0,  //..%@@@@@@@@
    0x78, 0x20,  //.%@@@+...+%
    0x70, 0x00,  //.@@@.......
    0xe0, 0x00,  //%@@+.......
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //%@@+.......
    0x70, 0x00,  //.@@@.......
    0x78, 0x20,  //.%@@@+...+%
    0x3f, 0xe0,  //..%@@@@@@@@
    0x0f, 0xc0,  //...+%@@@@%.
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0442 (т) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0x03, 0x80,  //......@@@......
    0x03, 0x80,  //......@@@......
    0x03, 0x80,  //......@@@......
    0x03, 0x80,  //......@@@......
    0x03, 0x80,  //......@@@......
    0x03, 0x80,  //......@@@......
    0x03, 0x80,  //......@@@......
    0x03, 0x80,  //......@@@......
    0x03, 0x80,  //......@@@......
    0x03, 0x80,  //......@@@......
    0x03, 0x80,  //......@@@......
    0x03, 0x80,  //......@@@......
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+0443 (у) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xe0, 0x1c,  //@@@+......+@@@
    0x70, 0x38,  //+@@@......@@@+
    0x70, 0x38,  //.@@@+....+@@@.
    0x78, 0x70,  //.%@@%....@@@+.
    0x38, 0x70,  //..@@@....@@@..
    0x38, 0xf0,  //..%@@+..%@@%..
    0x1c, 0xe0,  //..+@@@..@@@...
    0x1d, 0xe0,  //...@@@++@@%...
    0x1f, 0xc0,  //...+@@%@@@+...
    0x0f, 0xc0,  //....@@@@@@....
    0x0f, 0x80,  //....%@@@@+....
    0x07, 0x80,  //....+@@@@.....
    0x07, 0x80,  //.....@@@%.....
    0x07, 0x00,  //.....@@@......
    0x0f, 0x00,  //....%@@%......
    0x0e, 0x00,  //....@@@+......
    0x1e, 0x00,  //...%@@@.......
    0x7c, 0x00,  //.@@@@@........
    0x78, 0x00,  //.@@@%.........
    0x00, 0x00,  //..............


    /*Unicode: U+0444 (ф) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x1c, 0xe7, 0x00,  //...%@@+.@@@.+@@%...
    0x3f, 0xff, 0x80,  //.+@@@@@%@@@%@@@@@+.
    0x71, 0xf1, 0xc0,  //.@@@+.+@@@@@+.+@@@.
    0x70, 0xe1, 0xc0,  //+@@%...+@@@+...%@@+
    0xe0, 0xe0, 0xe0,  //%@@.....@@@.....@@%
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //%@@.....@@@.....@@%
    0x70, 0xe1, 0xc0,  //+@@%...+@@@+...%@@+
    0x71, 0xf1, 0xc0,  //.@@@+.+@@@@@+.+@@@.
    0x3f, 0xff, 0x80,  //.+@@@@@%@@@%@@@@@+.
    0x1c, 0xe7, 0x00,  //...@@@+.@@@.+@@@...
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0xe0, 0x00,  //........@@@........
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0445 (х) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xf0, 0x3c,  //%@@@+....+@@@%
    0x78, 0x78,  //.%@@@....@@@@.
    0x3c, 0xf0,  //..@@@@..@@@@..
    0x1f, 0xe0,  //...@@@%%@@@...
    0x0f, 0xc0,  //...+@@@@@@+...
    0x0f, 0xc0,  //....%@@@@%....
    0x07, 0x80,  //.....@@@%.....
    0x07, 0x80,  //.....@@@@.....
    0x0f, 0xc0,  //....@@@@@%....
    0x1f, 0xe0,  //...%@@@@@@%...
    0x1c, 0xe0,  //..+@@@++@@@+..
    0x3c, 0xf0,  //..@@@%..%@@@..
    0x78, 0x78,  //.@@@@....@@@@.
    0xf0, 0x3c,  //%@@@......@@@%
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0446 (ц) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xe0, 0x70,  //@@@......@@@..
    0xff, 0xfc,  //@@@@@@@@@@@@@@
    0xff, 0xfc,  //@@@@@@@@@@@@@@
    0x00, 0x0c,  //............@@
    0x00, 0x0c,  //............@@
    0x00, 0x0c,  //............@@
    0x00, 0x0c,  //............@@
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0447 (ч) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xe0, 0xe0,  //@@@.....@@@
    0xe0, 0xe0,  //@@@.....@@@
    0xe0, 0xe0,  //@@@.....@@@
    0xe0, 0xe0,  //@@@.....@@@
    0xe0, 0xe0,  //@@@.....@@@
    0xf0, 0xe0,  //%@@%....@@@
    0x7f, 0xe0,  //.@@@@@@@@@@
    0x3f, 0xe0,  //..%@@@@@@@@
    0x00, 0xe0,  //........@@@
    0x00, 0xe0,  //........@@@
    0x00, 0xe0,  //........@@@
    0x00, 0xe0,  //........@@@
    0x00, 0xe0,  //........@@@
    0x00, 0xe0,  //........@@@
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0448 (ш) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xe0,  //@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0449 (щ) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@..
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@..
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@..
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@..
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@..
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@..
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@..
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@..
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@..
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@..
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@..
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@..
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x18,  //...................@@
    0x00, 0x00, 0x18,  //...................@@
    0x00, 0x00, 0x18,  //...................@@
    0x00, 0x00, 0x18,  //...................@@
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+044a (ъ) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xfe, 0x00,  //@@@@@@@........
    0xfe, 0x00,  //@@@@@@@........
    0x0e, 0x00,  //....@@@........
    0x0e, 0x00,  //....@@@........
    0x0e, 0x00,  //....@@@........
    0x0e, 0x00,  //....@@@........
    0x0f, 0xf8,  //....@@@@@@@@%..
    0x0f, 0xfc,  //....@@@@@@@@@@.
    0x0e, 0x1e,  //....@@@....%@@%
    0x0e, 0x0e,  //....@@@.....@@@
    0x0e, 0x0e,  //....@@@.....@@@
    0x0e, 0x1e,  //....@@@....%@@%
    0x0f, 0xfc,  //....@@@@@@@@@@.
    0x0f, 0xf8,  //....@@@@@@@@%..
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+044b (ы) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xff, 0x87,  //@@@@@@@@%....@@@
    0xff, 0xc7,  //@@@@@@@@@@...@@@
    0xe1, 0xe7,  //@@@....%@@%..@@@
    0xe0, 0xe7,  //@@@.....@@@..@@@
    0xe0, 0xe7,  //@@@.....@@@..@@@
    0xe1, 0xe7,  //@@@....%@@%..@@@
    0xff, 0xc7,  //@@@@@@@@@@...@@@
    0xff, 0x87,  //@@@@@@@@%....@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+044c (ь) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xff, 0x80,  //@@@@@@@@%..
    0xff, 0xc0,  //@@@@@@@@@@.
    0xe1, 0xe0,  //@@@....%@@%
    0xe0, 0xe0,  //@@@.....@@@
    0xe0, 0xe0,  //@@@.....@@@
    0xe1, 0xe0,  //@@@....%@@%
    0xff, 0xc0,  //@@@@@@@@@@.
    0xff, 0x80,  //@@@@@@@@%..
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+044d (э) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x7e, 0x00,  //.%@@@@%....
    0xff, 0x80,  //@@@@@@@@%..
    0x83, 0xc0,  //@+...+@@@%.
    0x01, 0xc0,  //.......@@@.
    0x00, 0xe0,  //.......+@@%
    0x00, 0xe0,  //........@@@
    0x3f, 0xe0,  //..@@@@@@@@@
    0x3f, 0xe0,  //..@@@@@@@@@
    0x00, 0xe0,  //........@@@
    0x00, 0xe0,  //........@@%
    0x01, 0xc0,  //.......@@@.
    0x83, 0xc0,  //@+...+@@@%.
    0xff, 0x80,  //@@@@@@@@%..
    0x7e, 0x00,  //.%@@@@%+...
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+044e (ю) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0xe0, 0x7c, 0x00,  //@@@.....+@@@@%+...
    0xe1, 0xff, 0x00,  //@@@....@@@@@@@@%..
    0xe3, 0xc7, 0x80,  //@@@...@@@%...%@@%.
    0xe7, 0x83, 0x80,  //@@@..%@@@.....@@@+
    0xe7, 0x01, 0xc0,  //@@@..@@@+.....+@@%
    0xff, 0x01, 0xc0,  //@@@@@@@@.......@@@
    0xff, 0x01, 0xc0,  //@@@@@@@@.......@@@
    0xe7, 0x01, 0xc0,  //@@@..@@@.......@@@
    0xe7, 0x01, 0xc0,  //@@@..@@@.......@@@
    0xe7, 0x01, 0xc0,  //@@@..%@@+.....+@@%
    0xe3, 0x83, 0x80,  //@@@...@@@.....@@@+
    0xe3, 0xc7, 0x80,  //@@@...%@@%...%@@%.
    0xe1, 0xff, 0x00,  //@@@....%@@@@@@@@..
    0xe0, 0x7c, 0x00,  //@@@.....+%@@@%+...
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+044f (я) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x1f, 0xf0,  //...%@@@@@@@@
    0x3f, 0xf0,  //..@@@@@@@@@@
    0x78, 0x70,  //.%@@%....@@@
    0x70, 0x70,  //.@@@.....@@@
    0x70, 0x70,  //.@@@.....@@@
    0x78, 0x70,  //.%@@%....@@@
    0x3f, 0xf0,  //..@@@@@@@@@@
    0x1f, 0xf0,  //...%@@@@@@@@
    0x0f, 0x70,  //....@@@%.@@@
    0x1e, 0x70,  //...%@@@..@@@
    0x1c, 0x70,  //..+@@@...@@@
    0x38, 0x70,  //..@@@+...@@@
    0x78, 0x70,  //.@@@%....@@@
    0xf0, 0x70,  //%@@@.....@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............



#elif USE_LV_FONT_DEJAVU_30_CYRILLIC == 2
    /*Unicode: U+0410 (А) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x07, 0xf4, 0x00, 0x00,  //......+@@@+......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x3f, 0x7f, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x7f, 0x3f, 0x40, 0x00,  //....+@@@.@@@+....
    0x00, 0xbd, 0x1f, 0x80, 0x00,  //....%@@+.+@@%....
    0x00, 0xfc, 0x0f, 0xc0, 0x00,  //....@@@...@@@....
    0x01, 0xf8, 0x0b, 0xd0, 0x00,  //...+@@%...%@@+...
    0x03, 0xf4, 0x07, 0xf0, 0x00,  //...@@@+...+@@@...
    0x03, 0xf0, 0x03, 0xf0, 0x00,  //...@@@.....@@@...
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x0f, 0xff, 0xff, 0xfc, 0x00,  //..@@@@@@@@@@@@@..
    0x1f, 0xc0, 0x00, 0xfd, 0x00,  //.+@@@.......@@@+.
    0x2f, 0x40, 0x00, 0xbe, 0x00,  //.%@@+.......+@@%.
    0x3f, 0x00, 0x00, 0x3f, 0x00,  //.@@@.........@@@.
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@%.........@@@+
    0xfd, 0x00, 0x00, 0x1f, 0xc0,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0411 (Б) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@.
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xe0, 0x00,  //@@@@@@@@@%...
    0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@+.
    0xfc, 0x00, 0x7f, 0x40,  //@@@.....+@@@+
    0xfc, 0x00, 0x1f, 0x80,  //@@@......+@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x1f, 0x80,  //@@@......+@@%
    0xfc, 0x00, 0x7f, 0x40,  //@@@.....+@@@+
    0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@+.
    0xff, 0xff, 0xe0, 0x00,  //@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0412 (В) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0x90, 0x00,  //@@@@@@@@%+...
    0xff, 0xff, 0xf8, 0x00,  //@@@@@@@@@@%..
    0xfc, 0x01, 0xfd, 0x00,  //@@@....+@@@+.
    0xfc, 0x00, 0x7f, 0x00,  //@@@.....+@@@.
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@.
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@.
    0xfc, 0x00, 0x7e, 0x00,  //@@@.....+@@%.
    0xfc, 0x01, 0xfc, 0x00,  //@@@....+@@@..
    0xff, 0xff, 0xe0, 0x00,  //@@@@@@@@@%...
    0xff, 0xff, 0xf4, 0x00,  //@@@@@@@@@@+..
    0xfc, 0x00, 0xbe, 0x00,  //@@@.....%@@%.
    0xfc, 0x00, 0x2f, 0x40,  //@@@......%@@+
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x2f, 0x80,  //@@@......%@@%
    0xfc, 0x00, 0xbf, 0x40,  //@@@.....%@@@.
    0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@+.
    0xff, 0xff, 0xe0, 0x00,  //@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0413 (Г) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0414 (Д) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0xff, 0xff, 0xff, 0x00,  //....@@@@@@@@@@@@..
    0x00, 0xff, 0xff, 0xff, 0x00,  //....@@@@@@@@@@@@..
    0x00, 0xfc, 0x00, 0x3f, 0x00,  //....@@@......@@@..
    0x00, 0xfc, 0x00, 0x3f, 0x00,  //....@@@......@@@..
    0x00, 0xfc, 0x00, 0x3f, 0x00,  //....@@@......@@@..
    0x00, 0xfc, 0x00, 0x3f, 0x00,  //....@@@......@@@..
    0x00, 0xfc, 0x00, 0x3f, 0x00,  //....@@@......@@@..
    0x00, 0xfc, 0x00, 0x3f, 0x00,  //....@@@......@@@..
    0x00, 0xfc, 0x00, 0x3f, 0x00,  //....@@@......@@@..
    0x01, 0xfc, 0x00, 0x3f, 0x00,  //....@@%......@@@..
    0x01, 0xf8, 0x00, 0x3f, 0x00,  //...+@@%......@@@..
    0x02, 0xf8, 0x00, 0x3f, 0x00,  //...+@@+......@@@..
    0x02, 0xf4, 0x00, 0x3f, 0x00,  //...%@@+......@@@..
    0x03, 0xf0, 0x00, 0x3f, 0x00,  //...@@@.......@@@..
    0x03, 0xf0, 0x00, 0x3f, 0x00,  //...@@@.......@@@..
    0x0b, 0xe0, 0x00, 0x3f, 0x00,  //..%@@%.......@@@..
    0x1f, 0xc0, 0x00, 0x3f, 0x00,  //.+@@@........@@@..
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@
    0xf0, 0x00, 0x00, 0x00, 0xf0,  //@@..............@@
    0xf0, 0x00, 0x00, 0x00, 0xf0,  //@@..............@@
    0xf0, 0x00, 0x00, 0x00, 0xf0,  //@@..............@@
    0xf0, 0x00, 0x00, 0x00, 0xf0,  //@@..............@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0415 (Е) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0416 (Ж) , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0xbf, 0x80, 0x00, 0xfc, 0x00, 0x0b, 0xf8,  //%@@@%.......@@@.......%@@@%
    0x2f, 0xe0, 0x00, 0xfc, 0x00, 0x2f, 0xe0,  //.%@@@%......@@@......%@@@%.
    0x0b, 0xf4, 0x00, 0xfc, 0x00, 0x7f, 0x80,  //..%@@@+.....@@@.....+@@@%..
    0x02, 0xfd, 0x00, 0xfc, 0x01, 0xfe, 0x00,  //...%@@@+....@@@....+@@@%...
    0x00, 0xbf, 0x40, 0xfc, 0x07, 0xf8, 0x00,  //....%@@@+...@@@...+@@@%....
    0x00, 0x3f, 0xd0, 0xfc, 0x1f, 0xf0, 0x00,  //.....@@@@+..@@@..+@@@@.....
    0x00, 0x0f, 0xf0, 0xfc, 0x7f, 0xc0, 0x00,  //......@@@@..@@@..@@@@......
    0x00, 0x03, 0xfc, 0xfc, 0xff, 0x00, 0x00,  //.......@@@@.@@@.@@@@.......
    0x00, 0x0b, 0xff, 0xff, 0xff, 0x80, 0x00,  //......%@@@@@@@@@@@@@%......
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xc0, 0x00,  //......@@@@@@@@@@@@@@@......
    0x00, 0x3f, 0x8f, 0xff, 0xcb, 0xf0, 0x00,  //.....@@@%.@@@@@@@.%@@@.....
    0x00, 0x7f, 0x03, 0xff, 0x03, 0xf4, 0x00,  //....+@@@...@@@@@...@@@+....
    0x00, 0xfd, 0x01, 0xfd, 0x02, 0xfc, 0x00,  //....@@@+...+@@@+...+@@@....
    0x02, 0xfc, 0x00, 0xfc, 0x00, 0xfe, 0x00,  //...%@@@.....@@@.....@@@%...
    0x03, 0xf4, 0x00, 0xfc, 0x00, 0x7f, 0x00,  //...@@@+.....@@@.....+@@@...
    0x0f, 0xe0, 0x00, 0xfc, 0x00, 0x2f, 0xc0,  //..@@@%......@@@......%@@@..
    0x1f, 0xc0, 0x00, 0xfc, 0x00, 0x0f, 0xd0,  //.+@@@.......@@@.......@@@+.
    0x3f, 0x40, 0x00, 0xfc, 0x00, 0x07, 0xf0,  //.@@@+.......@@@.......+@@@.
    0xbf, 0x00, 0x00, 0xfc, 0x00, 0x03, 0xf8,  //%@@@........@@@........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+0417 (З) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x06, 0xff, 0x90, 0x00,  //..+%@@@@%+...
    0x3f, 0xff, 0xfd, 0x00,  //.@@@@@@@@@@+.
    0xfd, 0x00, 0x7f, 0x40,  //@@@+....+@@@+
    0xf0, 0x00, 0x1f, 0xc0,  //@@.......+@@@
    0x80, 0x00, 0x0f, 0xc0,  //%.........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x7f, 0x80,  //........+@@@%
    0x03, 0xff, 0xff, 0x00,  //...@@@@@@@@@.
    0x03, 0xff, 0xf4, 0x00,  //...@@@@@@@+..
    0x00, 0x01, 0xfd, 0x00,  //.......+@@@+.
    0x00, 0x00, 0x2f, 0x00,  //.........%@@.
    0x00, 0x00, 0x0f, 0x80,  //..........@@%
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x40, 0x00, 0x1f, 0xc0,  //+.........@@@
    0xd0, 0x00, 0x3f, 0x80,  //@+.......@@@%
    0xf9, 0x01, 0xff, 0x00,  //@@%+...+@@@@.
    0x7f, 0xff, 0xf8, 0x00,  //+@@@@@@@@@%..
    0x06, 0xff, 0x80, 0x00,  //..+%@@@@%....
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0418 (И) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xfc, 0x00, 0x0f, 0xf0,  //@@@.......@@@@
    0xfc, 0x00, 0x2f, 0xf0,  //@@@......%@@@@
    0xfc, 0x00, 0x3f, 0xf0,  //@@@......@@@@@
    0xfc, 0x00, 0xbf, 0xf0,  //@@@.....%@@@@@
    0xfc, 0x00, 0xff, 0xf0,  //@@@.....@@@@@@
    0xfc, 0x02, 0xfb, 0xf0,  //@@@....%@@%@@@
    0xfc, 0x07, 0xf3, 0xf0,  //@@@...+@@@.@@@
    0xfc, 0x0f, 0xe3, 0xf0,  //@@@...@@@%.@@@
    0xfc, 0x1f, 0xc3, 0xf0,  //@@@..+@@@..@@@
    0xfc, 0x3f, 0x83, 0xf0,  //@@@..@@@%..@@@
    0xfc, 0x7f, 0x03, 0xf0,  //@@@.+@@@...@@@
    0xfc, 0xfe, 0x03, 0xf0,  //@@@.@@@%...@@@
    0xfd, 0xfc, 0x03, 0xf0,  //@@@+@@@....@@@
    0xff, 0xf8, 0x03, 0xf0,  //@@@@@@%....@@@
    0xff, 0xf0, 0x03, 0xf0,  //@@@@@@.....@@@
    0xff, 0xe0, 0x03, 0xf0,  //@@@@@%.....@@@
    0xff, 0xc0, 0x03, 0xf0,  //@@@@@......@@@
    0xff, 0x80, 0x03, 0xf0,  //@@@@%......@@@
    0xff, 0x00, 0x03, 0xf0,  //@@@@.......@@@
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0419 (Й) , Width: 14 */
    0x03, 0xd0, 0x7c, 0x00,  //...@@+..+@@...
    0x01, 0xff, 0xf4, 0x00,  //...+@@@@@@+...
    0x00, 0x7f, 0xd0, 0x00,  //....+@@@@+....
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xfc, 0x00, 0x0f, 0xf0,  //@@@.......@@@@
    0xfc, 0x00, 0x2f, 0xf0,  //@@@......%@@@@
    0xfc, 0x00, 0x3f, 0xf0,  //@@@......@@@@@
    0xfc, 0x00, 0xbf, 0xf0,  //@@@.....%@@@@@
    0xfc, 0x00, 0xff, 0xf0,  //@@@.....@@@@@@
    0xfc, 0x02, 0xfb, 0xf0,  //@@@....%@@%@@@
    0xfc, 0x07, 0xf3, 0xf0,  //@@@...+@@@.@@@
    0xfc, 0x0f, 0xe3, 0xf0,  //@@@...@@@%.@@@
    0xfc, 0x1f, 0xc3, 0xf0,  //@@@..+@@@..@@@
    0xfc, 0x3f, 0x83, 0xf0,  //@@@..@@@%..@@@
    0xfc, 0x7f, 0x03, 0xf0,  //@@@.+@@@...@@@
    0xfc, 0xfe, 0x03, 0xf0,  //@@@.@@@%...@@@
    0xfd, 0xfc, 0x03, 0xf0,  //@@@+@@@....@@@
    0xff, 0xf8, 0x03, 0xf0,  //@@@@@@%....@@@
    0xff, 0xf0, 0x03, 0xf0,  //@@@@@@.....@@@
    0xff, 0xe0, 0x03, 0xf0,  //@@@@@%.....@@@
    0xff, 0xc0, 0x03, 0xf0,  //@@@@@......@@@
    0xff, 0x80, 0x03, 0xf0,  //@@@@%......@@@
    0xff, 0x00, 0x03, 0xf0,  //@@@@.......@@@
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+041a (К) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xfc, 0x00, 0x0b, 0xf8,  //@@@.......%@@@%
    0xfc, 0x00, 0x2f, 0xe0,  //@@@......%@@@%.
    0xfc, 0x00, 0x7f, 0x80,  //@@@.....+@@@%..
    0xfc, 0x01, 0xfe, 0x00,  //@@@....+@@@%...
    0xfc, 0x07, 0xf8, 0x00,  //@@@...+@@@%....
    0xfc, 0x1f, 0xf0, 0x00,  //@@@..+@@@@.....
    0xfc, 0x7f, 0xc0, 0x00,  //@@@..@@@@......
    0xfc, 0xff, 0x00, 0x00,  //@@@.@@@@.......
    0xff, 0xff, 0x80, 0x00,  //@@@@@@@@%......
    0xff, 0xff, 0xc0, 0x00,  //@@@@@@@@@......
    0xff, 0xcb, 0xf0, 0x00,  //@@@@@.%@@@.....
    0xff, 0x03, 0xf4, 0x00,  //@@@@...@@@+....
    0xfd, 0x02, 0xfc, 0x00,  //@@@+...%@@@....
    0xfc, 0x00, 0xfe, 0x00,  //@@@.....@@@%...
    0xfc, 0x00, 0x7f, 0x00,  //@@@.....+@@@...
    0xfc, 0x00, 0x2f, 0xc0,  //@@@......%@@@..
    0xfc, 0x00, 0x0f, 0xd0,  //@@@.......@@@+.
    0xfc, 0x00, 0x07, 0xf0,  //@@@.......+@@@.
    0xfc, 0x00, 0x03, 0xf8,  //@@@........@@@%
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+041b (Л) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x3f, 0xff, 0xff,  //.....@@@@@@@@@@@
    0x00, 0x3f, 0xff, 0xff,  //.....@@@@@@@@@@@
    0x00, 0x3f, 0x00, 0x3f,  //.....@@@.....@@@
    0x00, 0x3f, 0x00, 0x3f,  //.....@@@.....@@@
    0x00, 0x3f, 0x00, 0x3f,  //.....@@@.....@@@
    0x00, 0x3f, 0x00, 0x3f,  //.....@@@.....@@@
    0x00, 0x3f, 0x00, 0x3f,  //.....@@@.....@@@
    0x00, 0x3f, 0x00, 0x3f,  //.....@@@.....@@@
    0x00, 0x3f, 0x00, 0x3f,  //.....@@@.....@@@
    0x00, 0x7e, 0x00, 0x3f,  //....+@@%.....@@@
    0x00, 0x7e, 0x00, 0x3f,  //....+@@%.....@@@
    0x00, 0xbd, 0x00, 0x3f,  //....%@@+.....@@@
    0x00, 0xbd, 0x00, 0x3f,  //....%@@+.....@@@
    0x00, 0xfc, 0x00, 0x3f,  //....@@@......@@@
    0x01, 0xf8, 0x00, 0x3f,  //...+@@%......@@@
    0x03, 0xf4, 0x00, 0x3f,  //...@@@+......@@@
    0x1f, 0xe0, 0x00, 0x3f,  //.+@@@%.......@@@
    0xff, 0x40, 0x00, 0x3f,  //@@@@+........@@@
    0xe4, 0x00, 0x00, 0x3f,  //@%+..........@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+041c (М) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xe0, 0x02, 0xff, 0xc0,  //@@@@@%.....%@@@@@
    0xff, 0xf0, 0x03, 0xff, 0xc0,  //@@@@@@.....@@@@@@
    0xff, 0xf0, 0x03, 0xff, 0xc0,  //@@@@@@.....@@@@@@
    0xfe, 0xf8, 0x0b, 0xef, 0xc0,  //@@@%@@%...%@@%@@@
    0xfc, 0xfc, 0x0f, 0xcf, 0xc0,  //@@@.@@@...@@@.@@@
    0xfc, 0xfd, 0x1f, 0xcf, 0xc0,  //@@@.@@@+.+@@@.@@@
    0xfc, 0xbe, 0x2f, 0x8f, 0xc0,  //@@@.%@@%.%@@%.@@@
    0xfc, 0x3f, 0x3f, 0x0f, 0xc0,  //@@@..@@@.@@@..@@@
    0xfc, 0x3f, 0xbf, 0x0f, 0xc0,  //@@@..@@@%@@@..@@@
    0xfc, 0x2f, 0xfe, 0x0f, 0xc0,  //@@@..%@@@@@%..@@@
    0xfc, 0x0f, 0xfc, 0x0f, 0xc0,  //@@@...@@@@@...@@@
    0xfc, 0x0f, 0xfc, 0x0f, 0xc0,  //@@@...@@@@@...@@@
    0xfc, 0x07, 0xf4, 0x0f, 0xc0,  //@@@...+@@@+...@@@
    0xfc, 0x03, 0xf0, 0x0f, 0xc0,  //@@@....@@@....@@@
    0xfc, 0x03, 0xf0, 0x0f, 0xc0,  //@@@....@@@....@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+041d (Н) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+041e (О) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+.....
    0x01, 0xff, 0xff, 0xf4, 0x00,  //...+@@@@@@@@@@+...
    0x07, 0xf8, 0x02, 0xfd, 0x00,  //..+@@@%....%@@@+..
    0x1f, 0xc0, 0x00, 0x3f, 0x40,  //.+@@@........@@@..
    0x3f, 0x40, 0x00, 0x1f, 0xc0,  //.@@@+........+@@@.
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........%@@+
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........%@@+
    0x3f, 0x40, 0x00, 0x1f, 0xc0,  //.@@@+........+@@@.
    0x1f, 0xc0, 0x00, 0x3f, 0x40,  //.+@@@........@@@+.
    0x07, 0xf8, 0x02, 0xfd, 0x00,  //..+@@@%....%@@@+..
    0x01, 0xff, 0xff, 0xf4, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+041f (П) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0420 (Р) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0x80,  //@@@@@@@@%...
    0xff, 0xff, 0xf4,  //@@@@@@@@@@+.
    0xfc, 0x01, 0xfd,  //@@@....+@@@+
    0xfc, 0x00, 0xbe,  //@@@.....%@@%
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0xbe,  //@@@.....+@@%
    0xfc, 0x01, 0xfd,  //@@@....+@@@+
    0xff, 0xff, 0xf4,  //@@@@@@@@@@+.
    0xff, 0xff, 0x80,  //@@@@@@@@%...
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0421 (С) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x1b, 0xfe, 0x40,  //.....+%@@@@%+..
    0x01, 0xff, 0xff, 0xf4,  //...+@@@@@@@@@@+
    0x07, 0xf8, 0x01, 0xfc,  //..+@@@%....+@@@
    0x1f, 0xc0, 0x00, 0x2c,  //.+@@@........%@
    0x3f, 0x40, 0x00, 0x04,  //.@@@+.........+
    0x7e, 0x00, 0x00, 0x00,  //+@@%...........
    0xbd, 0x00, 0x00, 0x00,  //%@@+...........
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xbd, 0x00, 0x00, 0x00,  //%@@+...........
    0x7e, 0x00, 0x00, 0x00,  //+@@%...........
    0x3f, 0x40, 0x00, 0x04,  //.@@@..........+
    0x1f, 0xc0, 0x00, 0x2c,  //.+@@@........%@
    0x07, 0xf8, 0x01, 0xfc,  //..+@@@%....+@@@
    0x01, 0xff, 0xff, 0xf4,  //...+@@@@@@@@@@+
    0x00, 0x1b, 0xfe, 0x40,  //.....+%@@@@%+..
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0422 (Т) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0423 (У) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xfd, 0x00, 0x01, 0xfc,  //@@@+.......+@@@
    0x7f, 0x00, 0x03, 0xf4,  //+@@@.......@@@+
    0x3f, 0x40, 0x07, 0xf0,  //.@@@+.....+@@@.
    0x2f, 0x80, 0x0f, 0xe0,  //.%@@%.....%@@+.
    0x0f, 0xc0, 0x0f, 0xc0,  //..@@@.....@@@..
    0x0b, 0xe0, 0x2f, 0x80,  //..%@@%...%@@%..
    0x07, 0xf0, 0x3f, 0x00,  //..+@@@...@@@...
    0x03, 0xf4, 0x7f, 0x00,  //...@@@+.+@@@...
    0x01, 0xfc, 0xfd, 0x00,  //...+@@@.@@@+...
    0x00, 0xfe, 0xfc, 0x00,  //....@@@%@@@....
    0x00, 0xbf, 0xf8, 0x00,  //....%@@@@@%....
    0x00, 0x3f, 0xf0, 0x00,  //.....@@@@@.....
    0x00, 0x3f, 0xe0, 0x00,  //.....@@@@%.....
    0x00, 0x1f, 0xc0, 0x00,  //.....+@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x1f, 0x40, 0x00,  //.....+@@+......
    0x00, 0x3f, 0x00, 0x00,  //.....@@@.......
    0x0f, 0xfd, 0x00, 0x00,  //..@@@@@+.......
    0x0f, 0xe4, 0x00, 0x00,  //..@@@%+........
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0424 (Ф) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x2f, 0xff, 0xe0, 0x00,  //.....%@@@@@@@%.....
    0x03, 0xff, 0xff, 0xff, 0x00,  //...@@@@@@@@@@@@@...
    0x0f, 0xe4, 0xfc, 0x6f, 0xc0,  //..@@@%+.@@@.+%@@@..
    0x3f, 0x40, 0xfc, 0x07, 0xf0,  //.@@@+...@@@...+@@@.
    0x7e, 0x00, 0xfc, 0x02, 0xf4,  //+@@%....@@@....%@@+
    0xfd, 0x00, 0xfc, 0x01, 0xfc,  //%@@+....@@@....+@@%
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@%
    0x7e, 0x00, 0xfc, 0x02, 0xf4,  //+@@%....@@@....%@@+
    0x3f, 0x00, 0xfc, 0x03, 0xf0,  //.@@@....@@@....@@@.
    0x0f, 0xd0, 0xfc, 0x1f, 0xc0,  //..@@@+..@@@..+@@@..
    0x03, 0xff, 0xff, 0xff, 0x00,  //...@@@@@@@@@@@@@...
    0x00, 0x2f, 0xff, 0xe0, 0x00,  //.....%@@@@@@@%.....
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0425 (Х) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x2f, 0xc0, 0x00, 0xfe,  //.%@@@.......@@@%
    0x0f, 0xe0, 0x02, 0xfc,  //..@@@+.....%@@@.
    0x07, 0xf0, 0x03, 0xf4,  //..+@@@.....@@@+.
    0x03, 0xf8, 0x0f, 0xe0,  //...@@@%...@@@%..
    0x01, 0xfd, 0x2f, 0xc0,  //...+@@@+.%@@@...
    0x00, 0xbf, 0x3f, 0x40,  //....%@@@.@@@+...
    0x00, 0x3f, 0xff, 0x00,  //.....@@@@@@%....
    0x00, 0x1f, 0xfc, 0x00,  //.....+@@@@@.....
    0x00, 0x0f, 0xf4, 0x00,  //......@@@@+.....
    0x00, 0x0f, 0xf4, 0x00,  //......@@@@+.....
    0x00, 0x1f, 0xfc, 0x00,  //.....+@@@@@.....
    0x00, 0x3f, 0xfd, 0x00,  //.....@@@@@@+....
    0x00, 0xff, 0x7f, 0x00,  //....%@@@+@@@....
    0x01, 0xfc, 0x3f, 0x80,  //...+@@@..@@@%...
    0x03, 0xf8, 0x0f, 0xd0,  //...@@@%...@@@+..
    0x0b, 0xf0, 0x0b, 0xf0,  //..%@@@....%@@@..
    0x1f, 0xd0, 0x03, 0xf4,  //.+@@@......@@@+.
    0x3f, 0x80, 0x01, 0xfc,  //.@@@%......+@@@.
    0xbf, 0x00, 0x00, 0xfe,  //%@@@........@@@%
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0426 (Ц) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@..
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x0f,  //..............@@
    0x00, 0x00, 0x00, 0x0f,  //..............@@
    0x00, 0x00, 0x00, 0x0f,  //..............@@
    0x00, 0x00, 0x00, 0x0f,  //..............@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0427 (Ч) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xbd, 0x00, 0x0f, 0xc0,  //%@@+......@@@
    0x7f, 0x40, 0x0f, 0xc0,  //+@@@+.....@@@
    0x2f, 0xff, 0xff, 0xc0,  //.%@@@@@@@@@@@
    0x07, 0xff, 0xff, 0xc0,  //..+@@@@@@@@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0428 (Ш) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0429 (Щ) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xfc, 0x00, 0x0f, 0xc0, 0x00, 0xfc, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //.......................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //.......................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //.......................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //.......................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+042a (Ъ) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0x00, 0x00, 0x00,  //@@@@@@@@..........
    0xff, 0xff, 0x00, 0x00, 0x00,  //@@@@@@@@..........
    0x00, 0x3f, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x3f, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x3f, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x3f, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x3f, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x3f, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x3f, 0xff, 0xf8, 0x00,  //.....@@@@@@@@@%...
    0x00, 0x3f, 0xff, 0xff, 0x40,  //.....@@@@@@@@@@@+.
    0x00, 0x3f, 0x00, 0x2f, 0xd0,  //.....@@@.....%@@@+
    0x00, 0x3f, 0x00, 0x0b, 0xe0,  //.....@@@......%@@%
    0x00, 0x3f, 0x00, 0x03, 0xf0,  //.....@@@.......@@@
    0x00, 0x3f, 0x00, 0x03, 0xf0,  //.....@@@.......@@@
    0x00, 0x3f, 0x00, 0x03, 0xf0,  //.....@@@.......@@@
    0x00, 0x3f, 0x00, 0x07, 0xe0,  //.....@@@......+@@%
    0x00, 0x3f, 0x00, 0x1f, 0xd0,  //.....@@@.....+@@@.
    0x00, 0x3f, 0xff, 0xff, 0x40,  //.....@@@@@@@@@@@+.
    0x00, 0x3f, 0xff, 0xf8, 0x00,  //.....@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+042b (Ы) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xff, 0xff, 0xe0, 0x03, 0xf0,  //@@@@@@@@@%.....@@@
    0xff, 0xff, 0xfd, 0x03, 0xf0,  //@@@@@@@@@@@+...@@@
    0xfc, 0x00, 0x7f, 0x43, 0xf0,  //@@@.....+@@@+..@@@
    0xfc, 0x00, 0x1f, 0x83, 0xf0,  //@@@......+@@%..@@@
    0xfc, 0x00, 0x0f, 0xc3, 0xf0,  //@@@.......@@@..@@@
    0xfc, 0x00, 0x0f, 0xc3, 0xf0,  //@@@.......@@@..@@@
    0xfc, 0x00, 0x0f, 0xc3, 0xf0,  //@@@.......@@@..@@@
    0xfc, 0x00, 0x1f, 0x83, 0xf0,  //@@@......+@@%..@@@
    0xfc, 0x00, 0x7f, 0x43, 0xf0,  //@@@.....+@@@...@@@
    0xff, 0xff, 0xfd, 0x03, 0xf0,  //@@@@@@@@@@@+...@@@
    0xff, 0xff, 0xe0, 0x03, 0xf0,  //@@@@@@@@@%.....@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+042c (Ь) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xe0, 0x00,  //@@@@@@@@@%...
    0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@+.
    0xfc, 0x00, 0x7f, 0x40,  //@@@.....+@@@+
    0xfc, 0x00, 0x1f, 0x80,  //@@@......+@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x1f, 0x80,  //@@@......+@@%
    0xfc, 0x00, 0x7f, 0x40,  //@@@.....+@@@.
    0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@+.
    0xff, 0xff, 0xe0, 0x00,  //@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+042d (Э) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x06, 0xff, 0x90, 0x00,  //..+%@@@@%+.....
    0x7f, 0xff, 0xfd, 0x00,  //+@@@@@@@@@@+...
    0xfd, 0x00, 0x7f, 0x40,  //@@@+....+@@@+..
    0xe0, 0x00, 0x0f, 0xd0,  //@%........@@@+.
    0x40, 0x00, 0x03, 0xf0,  //+..........@@@.
    0x00, 0x00, 0x02, 0xf4,  //...........%@@+
    0x00, 0x00, 0x01, 0xf8,  //...........+@@%
    0x00, 0x00, 0x00, 0xfc,  //............@@@
    0x0f, 0xff, 0xff, 0xfc,  //..@@@@@@@@@@@@@
    0x0f, 0xff, 0xff, 0xfc,  //..@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0xfc,  //............@@@
    0x00, 0x00, 0x00, 0xfc,  //............@@@
    0x00, 0x00, 0x01, 0xf8,  //...........+@@%
    0x00, 0x00, 0x03, 0xf4,  //...........@@@+
    0x40, 0x00, 0x07, 0xf0,  //+.........+@@@.
    0xe0, 0x00, 0x0f, 0xd0,  //@%........@@@+.
    0xfd, 0x00, 0xbf, 0x40,  //@@@+....%@@@+..
    0x7f, 0xff, 0xfd, 0x00,  //+@@@@@@@@@@+...
    0x06, 0xff, 0x90, 0x00,  //..+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+042e (Ю) , Width: 24 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0xfc, 0x00, 0x01, 0xbf, 0xe4, 0x00,  //@@@........+%@@@@%+.....
    0xfc, 0x00, 0x1f, 0xff, 0xff, 0x40,  //@@@......+@@@@@@@@@@+...
    0xfc, 0x00, 0xbf, 0x80, 0x2f, 0xd0,  //@@@.....%@@@%....%@@@+..
    0xfc, 0x01, 0xfc, 0x00, 0x03, 0xf4,  //@@@....+@@@........@@@..
    0xfc, 0x03, 0xf4, 0x00, 0x01, 0xfc,  //@@@....@@@+........+@@@.
    0xfc, 0x07, 0xf0, 0x00, 0x00, 0xfd,  //@@@...+@@@..........@@@+
    0xfc, 0x0f, 0xd0, 0x00, 0x00, 0x7e,  //@@@...@@@+..........+@@%
    0xfc, 0x0f, 0xc0, 0x00, 0x00, 0x3f,  //@@@...@@@............@@@
    0xff, 0xff, 0xc0, 0x00, 0x00, 0x3f,  //@@@@@@@@@............@@@
    0xff, 0xff, 0xc0, 0x00, 0x00, 0x3f,  //@@@@@@@@@............@@@
    0xfc, 0x0f, 0xc0, 0x00, 0x00, 0x3f,  //@@@...@@@............@@@
    0xfc, 0x0f, 0xc0, 0x00, 0x00, 0x3f,  //@@@...@@@............@@@
    0xfc, 0x0b, 0xd0, 0x00, 0x00, 0x7e,  //@@@...%@@+..........+@@%
    0xfc, 0x03, 0xf0, 0x00, 0x00, 0xfd,  //@@@....@@@..........@@@+
    0xfc, 0x02, 0xf4, 0x00, 0x01, 0xfc,  //@@@....%@@+........+@@@.
    0xfc, 0x00, 0xfc, 0x00, 0x03, 0xf4,  //@@@.....@@@........@@@..
    0xfc, 0x00, 0x7f, 0x80, 0x2f, 0xd0,  //@@@.....+@@@%....%@@@+..
    0xfc, 0x00, 0x0f, 0xff, 0xff, 0x40,  //@@@.......@@@@@@@@@@+...
    0xfc, 0x00, 0x01, 0xbf, 0xe4, 0x00,  //@@@........+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................


    /*Unicode: U+042f (Я) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0xbf, 0xff, 0xf0,  //....%@@@@@@@@@
    0x07, 0xff, 0xff, 0xf0,  //..+@@@@@@@@@@@
    0x0f, 0xd0, 0x03, 0xf0,  //..@@@+.....@@@
    0x2f, 0x40, 0x03, 0xf0,  //.%@@+......@@@
    0x3f, 0x00, 0x03, 0xf0,  //.@@@.......@@@
    0x3f, 0x00, 0x03, 0xf0,  //.@@@.......@@@
    0x3f, 0x00, 0x03, 0xf0,  //.@@@.......@@@
    0x2f, 0x40, 0x03, 0xf0,  //.%@@+......@@@
    0x0f, 0xd0, 0x03, 0xf0,  //..@@@+.....@@@
    0x03, 0xff, 0xff, 0xf0,  //...@@@@@@@@@@@
    0x00, 0x7f, 0xff, 0xf0,  //....+@@@@@@@@@
    0x00, 0x3f, 0x83, 0xf0,  //.....@@@%..@@@
    0x00, 0xbf, 0x03, 0xf0,  //....%@@@...@@@
    0x01, 0xfd, 0x03, 0xf0,  //...+@@@....@@@
    0x03, 0xf8, 0x03, 0xf0,  //...@@@%....@@@
    0x0b, 0xf0, 0x03, 0xf0,  //..%@@@.....@@@
    0x1f, 0xd0, 0x03, 0xf0,  //.+@@@+.....@@@
    0x3f, 0x80, 0x03, 0xf0,  //.@@@%......@@@
    0xbf, 0x00, 0x03, 0xf0,  //%@@@.......@@@
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0430 (а) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x06, 0xff, 0x80,  //..+%@@@@%...
    0x3f, 0xff, 0xf4,  //.@@@@@@@@@+.
    0x34, 0x01, 0xfc,  //.@+....+@@@.
    0x00, 0x00, 0x7e,  //........+@@%
    0x00, 0x00, 0x3f,  //.........@@@
    0x06, 0xff, 0xff,  //..+%@@@@@@@@
    0x2f, 0xff, 0xff,  //.%@@@@@@@@@@
    0xbf, 0x40, 0x3f,  //+@@@+....@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x7f,  //@@@.....+@@@
    0xfc, 0x00, 0xff,  //@@@.....@@@@
    0xbf, 0x02, 0xbf,  //%@@@...%%@@@
    0x3f, 0xff, 0x3f,  //.@@@@@@@.@@@
    0x0b, 0xf8, 0x3f,  //..%@@@%..@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0431 (б) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x1b, 0xff, 0x40,  //.....+%@@@@@+.
    0x00, 0xff, 0xff, 0x80,  //....@@@@@@@@%.
    0x03, 0xfe, 0x40, 0x00,  //...@@@@%+.....
    0x0f, 0xe0, 0x00, 0x00,  //..@@@%........
    0x1f, 0xc0, 0x00, 0x00,  //.+@@%.........
    0x2f, 0x00, 0x00, 0x00,  //.%@@..........
    0x3f, 0x2f, 0xf4, 0x00,  //.@@@.%@@@@+...
    0x3f, 0xff, 0xff, 0x00,  //.@@@@@@@@@@@..
    0x3f, 0xe0, 0x2f, 0xc0,  //.@@@@%...%@@@.
    0x3f, 0xc0, 0x0f, 0xd0,  //.@@@@.....@@@+
    0x3f, 0x40, 0x07, 0xe0,  //.@@@+.....+@@%
    0x3f, 0x00, 0x03, 0xf0,  //.@@@.......@@@
    0x3f, 0x00, 0x03, 0xf0,  //.@@@.......@@@
    0x3f, 0x00, 0x03, 0xf0,  //.@@@.......@@@
    0x3f, 0x00, 0x03, 0xf0,  //.@@@.......@@@
    0x2f, 0x40, 0x07, 0xe0,  //.%@@+.....+@@%
    0x1f, 0xc0, 0x0f, 0xd0,  //.+@@@.....@@@+
    0x0f, 0xe0, 0x2f, 0x80,  //..@@@%...%@@%.
    0x03, 0xff, 0xff, 0x00,  //...@@@@@@@@@..
    0x00, 0x6f, 0xe4, 0x00,  //....+%@@@%+...
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0432 (в) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xff, 0xfe, 0x00,  //@@@@@@@%...
    0xff, 0xff, 0xd0,  //@@@@@@@@@+.
    0xfc, 0x0b, 0xf0,  //@@@...%@@@.
    0xfc, 0x03, 0xf0,  //@@@....@@@.
    0xfc, 0x03, 0xf0,  //@@@....@@@.
    0xfc, 0x0b, 0xd0,  //@@@...%@@+.
    0xff, 0xff, 0x40,  //@@@@@@@@...
    0xff, 0xff, 0xe0,  //@@@@@@@@@%.
    0xfc, 0x02, 0xf8,  //@@@....%@@%
    0xfc, 0x00, 0xfc,  //@@@.....@@@
    0xfc, 0x00, 0xfc,  //@@@.....@@@
    0xfc, 0x02, 0xf8,  //@@@....%@@%
    0xff, 0xff, 0xf0,  //@@@@@@@@@@.
    0xff, 0xff, 0x80,  //@@@@@@@@%..
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0433 (г) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0434 (д) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0xff, 0xff, 0xc0,  //....@@@@@@@@@..
    0x00, 0xff, 0xff, 0xc0,  //....@@@@@@@@@..
    0x00, 0xfc, 0x0f, 0xc0,  //....@@@...@@@..
    0x00, 0xfc, 0x0f, 0xc0,  //....@@@...@@@..
    0x00, 0xfc, 0x0f, 0xc0,  //....@@@...@@@..
    0x00, 0xfc, 0x0f, 0xc0,  //....@@@...@@@..
    0x00, 0xfc, 0x0f, 0xc0,  //....@@@...@@@..
    0x01, 0xf8, 0x0f, 0xc0,  //...+@@%...@@@..
    0x02, 0xf8, 0x0f, 0xc0,  //...%@@%...@@@..
    0x03, 0xf4, 0x0f, 0xc0,  //...@@@....@@@..
    0x07, 0xf0, 0x0f, 0xc0,  //..+@@@....@@@..
    0x1f, 0xd0, 0x0f, 0xc0,  //.+@@@+....@@@..
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xf0, 0x00, 0x00, 0x3c,  //@@...........@@
    0xf0, 0x00, 0x00, 0x3c,  //@@...........@@
    0xf0, 0x00, 0x00, 0x3c,  //@@...........@@
    0xf0, 0x00, 0x00, 0x3c,  //@@...........@@
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0435 (е) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0xbf, 0xd0, 0x00,  //....%@@@@+...
    0x0b, 0xff, 0xfc, 0x00,  //..%@@@@@@@@..
    0x2f, 0xc0, 0xbf, 0x00,  //.%@@@...%@@@.
    0x3f, 0x00, 0x2f, 0x40,  //.@@@.....%@@+
    0xbd, 0x00, 0x0f, 0x80,  //%@@+......@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xbd, 0x00, 0x00, 0x00,  //%@@+.........
    0x7f, 0x00, 0x00, 0x00,  //.@@@.........
    0x2f, 0xd0, 0x07, 0x00,  //.%@@@+....+@.
    0x0b, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0xbf, 0xe4, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0436 (ж) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x2f, 0xd0, 0x3f, 0x01, 0xfe, 0x00,  //.%@@@+...@@@...+@@@%.
    0x0b, 0xf0, 0x3f, 0x03, 0xf8, 0x00,  //..%@@@...@@@...@@@%..
    0x03, 0xfc, 0x3f, 0x0f, 0xf0, 0x00,  //...@@@@..@@@..@@@@...
    0x00, 0xff, 0x3f, 0x3f, 0xc0, 0x00,  //....@@@@.@@@.@@@@....
    0x00, 0x3f, 0xbf, 0xbf, 0x00, 0x00,  //.....@@@%@@@%@@@.....
    0x00, 0x2f, 0xff, 0xfe, 0x00, 0x00,  //.....%@@@@@@@@@%.....
    0x00, 0x3f, 0xff, 0xff, 0x00, 0x00,  //.....@@@@@@@@@@@.....
    0x00, 0xff, 0xff, 0xff, 0xc0, 0x00,  //....@@@@@@@@@@@@@....
    0x01, 0xfc, 0xff, 0xcf, 0xd0, 0x00,  //...+@@@.@@@@%.@@@+...
    0x03, 0xf4, 0x3f, 0x07, 0xf0, 0x00,  //...@@@+..@@@..+@@@...
    0x0b, 0xf0, 0x3f, 0x03, 0xf8, 0x00,  //..%@@@...@@@...@@@%..
    0x1f, 0xc0, 0x3f, 0x00, 0xfd, 0x00,  //.+@@@....@@@....@@@+.
    0x3f, 0x80, 0x3f, 0x00, 0xbf, 0x00,  //.@@@%....@@@....%@@@.
    0xbf, 0x00, 0x3f, 0x00, 0x3f, 0x80,  //%@@@.....@@@.....@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0437 (з) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x1b, 0xfe, 0x40,  //.+%@@@@%+..
    0xff, 0xff, 0xf0,  //@@@@@@@@@@.
    0xd0, 0x06, 0xfc,  //@+....+%@@@
    0x00, 0x00, 0xfc,  //........@@@
    0x00, 0x02, 0xfc,  //.......%@@@
    0x03, 0xff, 0xf0,  //...@@@@@@@.
    0x03, 0xff, 0x80,  //...@@@@@%..
    0x00, 0x07, 0xf0,  //......+@@@.
    0x00, 0x01, 0xf8,  //.......+@@%
    0x00, 0x00, 0xfc,  //........@@@
    0x00, 0x01, 0xfc,  //.......+@@@
    0xd0, 0x07, 0xf8,  //%+....+@@@%
    0xff, 0xff, 0xe0,  //@@@@@@@@@%.
    0x2f, 0xfe, 0x40,  //.%@@@@@%+..
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0438 (и) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xfc, 0x00, 0xff,  //@@@.....@@@@
    0xfc, 0x02, 0xff,  //@@@....%@@@@
    0xfc, 0x03, 0xff,  //@@@....@@@@@
    0xfc, 0x0f, 0xff,  //@@@...@@@@@@
    0xfc, 0x2f, 0xff,  //@@@..%@@@@@@
    0xfc, 0x3f, 0x7f,  //@@@..@@@+@@@
    0xfc, 0xff, 0x3f,  //@@@.@@@@.@@@
    0xfe, 0xfd, 0x3f,  //@@@%@@@+.@@@
    0xff, 0xf8, 0x3f,  //@@@@@@%..@@@
    0xff, 0xf0, 0x3f,  //@@@@@@...@@@
    0xff, 0xe0, 0x3f,  //@@@@@%...@@@
    0xff, 0xc0, 0x3f,  //@@@@@....@@@
    0xff, 0x40, 0x3f,  //@@@@+....@@@
    0xff, 0x00, 0x3f,  //@@@@.....@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0439 (й) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x0b, 0x82, 0xe0,  //..%@%..%@%..
    0x03, 0xff, 0xc0,  //...@@@@@@...
    0x00, 0xbe, 0x00,  //....%@@%....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xfc, 0x00, 0xff,  //@@@.....@@@@
    0xfc, 0x02, 0xff,  //@@@....%@@@@
    0xfc, 0x03, 0xff,  //@@@....@@@@@
    0xfc, 0x0f, 0xff,  //@@@...@@@@@@
    0xfc, 0x2f, 0xff,  //@@@..%@@@@@@
    0xfc, 0x3f, 0x7f,  //@@@..@@@+@@@
    0xfc, 0xff, 0x3f,  //@@@.@@@@.@@@
    0xfe, 0xfd, 0x3f,  //@@@%@@@+.@@@
    0xff, 0xf8, 0x3f,  //@@@@@@%..@@@
    0xff, 0xf0, 0x3f,  //@@@@@@...@@@
    0xff, 0xe0, 0x3f,  //@@@@@%...@@@
    0xff, 0xc0, 0x3f,  //@@@@@....@@@
    0xff, 0x40, 0x3f,  //@@@@+....@@@
    0xff, 0x00, 0x3f,  //@@@@.....@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+043a (к) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xfc, 0x07, 0xf8,  //@@@...+@@@%.
    0xfc, 0x0f, 0xe0,  //@@@...@@@%..
    0xfc, 0x3f, 0xc0,  //@@@..@@@@...
    0xfc, 0xff, 0x00,  //@@@.@@@@....
    0xfe, 0xfc, 0x00,  //@@@%@@@.....
    0xff, 0xf8, 0x00,  //@@@@@@%.....
    0xff, 0xfc, 0x00,  //@@@@@@@.....
    0xff, 0xff, 0x00,  //@@@@@@@@....
    0xff, 0x3f, 0x40,  //@@@%.@@@+...
    0xfc, 0x2f, 0xc0,  //@@@..%@@@...
    0xfc, 0x0f, 0xe0,  //@@@...@@@%..
    0xfc, 0x03, 0xf4,  //@@@....@@@+.
    0xfc, 0x02, 0xfc,  //@@@....%@@@.
    0xfc, 0x00, 0xfe,  //@@@.....@@@%
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+043b (л) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0xff, 0xff, 0xf0,  //....@@@@@@@@@@
    0x00, 0xff, 0xff, 0xf0,  //....@@@@@@@@@@
    0x00, 0xfc, 0x03, 0xf0,  //....@@@....@@@
    0x00, 0xfc, 0x03, 0xf0,  //....@@@....@@@
    0x00, 0xfc, 0x03, 0xf0,  //....@@@....@@@
    0x00, 0xfc, 0x03, 0xf0,  //....@@@....@@@
    0x00, 0xfc, 0x03, 0xf0,  //....@@@....@@@
    0x01, 0xf8, 0x03, 0xf0,  //...+@@%....@@@
    0x01, 0xf8, 0x03, 0xf0,  //...+@@%....@@@
    0x02, 0xf4, 0x03, 0xf0,  //...%@@+....@@@
    0x03, 0xf0, 0x03, 0xf0,  //...@@@.....@@@
    0x1f, 0xd0, 0x03, 0xf0,  //.+@@@+.....@@@
    0xff, 0x40, 0x03, 0xf0,  //@@@@+......@@@
    0xf8, 0x00, 0x03, 0xf0,  //@@+........@@@
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+043c (м) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xe0, 0x2f, 0xfc,  //@@@@@%...%@@@@@
    0xff, 0xf0, 0x3f, 0xfc,  //@@@@@@...@@@@@@
    0xff, 0xf4, 0x7f, 0xfc,  //@@@@@@+.+@@@@@@
    0xfd, 0xf8, 0xbd, 0xfc,  //@@@+@@%.%@@+@@@
    0xfc, 0xfd, 0xfc, 0xfc,  //@@@.@@@+@@@.@@@
    0xfc, 0xbf, 0xf8, 0xfc,  //@@@.%@@@@@%.@@@
    0xfc, 0x7f, 0xf4, 0xfc,  //@@@.+@@@@@+.@@@
    0xfc, 0x3f, 0xf0, 0xfc,  //@@@..@@@@@..@@@
    0xfc, 0x2f, 0xe0, 0xfc,  //@@@..%@@@%..@@@
    0xfc, 0x0f, 0xc0, 0xfc,  //@@@...@@@...@@@
    0xfc, 0x0b, 0x80, 0xfc,  //@@@...%@%...@@@
    0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@
    0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+043d (н) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+043e (о) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x2f, 0x80, 0xbe, 0x00,  //.%@@%...%@@%.
    0x7f, 0x00, 0x3f, 0x40,  //+@@@.....@@@+
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0x7f, 0x00, 0x3f, 0x40,  //+@@@.....@@@+
    0x2f, 0x80, 0xbe, 0x00,  //.%@@%...%@@%.
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+043f (п) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0440 (р) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0xfc, 0x2f, 0xe0, 0x00,  //@@@..%@@@%...
    0xfc, 0xff, 0xfc, 0x00,  //@@@.@@@@@@@..
    0xfe, 0x80, 0xbf, 0x00,  //@@@%%...%@@@.
    0xff, 0x00, 0x3f, 0x40,  //@@@@.....@@@+
    0xfd, 0x00, 0x1f, 0x80,  //@@@+.....+@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfd, 0x00, 0x1f, 0x80,  //@@@+.....+@@%
    0xff, 0x00, 0x3f, 0x40,  //@@@@.....@@@+
    0xfe, 0x80, 0xbf, 0x00,  //@@@%%...%@@@.
    0xfc, 0xff, 0xfc, 0x00,  //@@@.@@@@@@@..
    0xfc, 0x2f, 0xe0, 0x00,  //@@@..%@@@%...
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0441 (с) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0xbf, 0xe0,  //....%@@@@%.
    0x0b, 0xff, 0xfc,  //..%@@@@@@@@
    0x2f, 0xd0, 0x1c,  //.%@@@+...+%
    0x7f, 0x00, 0x00,  //.@@@.......
    0xbd, 0x00, 0x00,  //%@@+.......
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xbd, 0x00, 0x00,  //%@@+.......
    0x3f, 0x00, 0x00,  //.@@@.......
    0x2f, 0xd0, 0x1c,  //.%@@@+...+%
    0x0b, 0xff, 0xfc,  //..%@@@@@@@@
    0x01, 0xbf, 0xe0,  //...+%@@@@%.
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0442 (т) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x0f, 0xc0, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0443 (у) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xfd, 0x00, 0x07, 0xf0,  //@@@+......+@@@
    0x7f, 0x00, 0x0f, 0xd0,  //+@@@......@@@+
    0x3f, 0x40, 0x1f, 0xc0,  //.@@@+....+@@@.
    0x2f, 0x80, 0x3f, 0x40,  //.%@@%....@@@+.
    0x0f, 0xc0, 0x3f, 0x00,  //..@@@....@@@..
    0x0b, 0xd0, 0xbe, 0x00,  //..%@@+..%@@%..
    0x07, 0xf0, 0xfc, 0x00,  //..+@@@..@@@...
    0x03, 0xf6, 0xfc, 0x00,  //...@@@++@@%...
    0x02, 0xfb, 0xf4, 0x00,  //...+@@%@@@+...
    0x00, 0xff, 0xf0, 0x00,  //....@@@@@@....
    0x00, 0xbf, 0xd0, 0x00,  //....%@@@@+....
    0x00, 0x7f, 0xc0, 0x00,  //....+@@@@.....
    0x00, 0x3f, 0x80, 0x00,  //.....@@@%.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@......
    0x00, 0xbe, 0x00, 0x00,  //....%@@%......
    0x00, 0xfd, 0x00, 0x00,  //....@@@+......
    0x02, 0xfc, 0x00, 0x00,  //...%@@@.......
    0x3f, 0xf0, 0x00, 0x00,  //.@@@@@........
    0x3f, 0x80, 0x00, 0x00,  //.@@@%.........
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0444 (ф) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x02, 0xf4, 0xfc, 0x7e, 0x00,  //...%@@+.@@@.+@@%...
    0x1f, 0xfe, 0xfe, 0xff, 0xd0,  //.+@@@@@%@@@%@@@@@+.
    0x3f, 0x47, 0xff, 0x47, 0xf0,  //.@@@+.+@@@@@+.+@@@.
    0x7e, 0x01, 0xfd, 0x02, 0xf4,  //+@@%...+@@@+...%@@+
    0xbc, 0x00, 0xfc, 0x00, 0xf8,  //%@@.....@@@.....@@%
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xbc, 0x00, 0xfc, 0x00, 0xf8,  //%@@.....@@@.....@@%
    0x7e, 0x01, 0xfd, 0x02, 0xf4,  //+@@%...+@@@+...%@@+
    0x3f, 0x47, 0xff, 0x47, 0xf0,  //.@@@+.+@@@@@+.+@@@.
    0x1f, 0xfe, 0xfe, 0xff, 0xd0,  //.+@@@@@%@@@%@@@@@+.
    0x03, 0xf4, 0xfc, 0x7f, 0x00,  //...@@@+.@@@.+@@@...
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0xfc, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0445 (х) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xbf, 0x40, 0x1f, 0xe0,  //%@@@+....+@@@%
    0x3f, 0xc0, 0x3f, 0xc0,  //.%@@@....@@@@.
    0x0f, 0xf0, 0xff, 0x00,  //..@@@@..@@@@..
    0x03, 0xfa, 0xfc, 0x00,  //...@@@%%@@@...
    0x01, 0xff, 0xf4, 0x00,  //...+@@@@@@+...
    0x00, 0xbf, 0xe0, 0x00,  //....%@@@@%....
    0x00, 0x3f, 0x80, 0x00,  //.....@@@%.....
    0x00, 0x3f, 0xc0, 0x00,  //.....@@@@.....
    0x00, 0xff, 0xf0, 0x00,  //....@@@@@%....
    0x02, 0xff, 0xf8, 0x00,  //...%@@@@@@%...
    0x07, 0xf5, 0xfd, 0x00,  //..+@@@++@@@+..
    0x0f, 0xe0, 0xbf, 0x00,  //..@@@%..%@@@..
    0x3f, 0xc0, 0x3f, 0xc0,  //.@@@@....@@@@.
    0xbf, 0x00, 0x0f, 0xe0,  //%@@@......@@@%
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0446 (ц) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0xf0,  //............@@
    0x00, 0x00, 0x00, 0xf0,  //............@@
    0x00, 0x00, 0x00, 0xf0,  //............@@
    0x00, 0x00, 0x00, 0xf0,  //............@@
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0447 (ч) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xfc, 0x00, 0xfc,  //@@@.....@@@
    0xfc, 0x00, 0xfc,  //@@@.....@@@
    0xfc, 0x00, 0xfc,  //@@@.....@@@
    0xfc, 0x00, 0xfc,  //@@@.....@@@
    0xfc, 0x00, 0xfc,  //@@@.....@@@
    0xbe, 0x00, 0xfc,  //%@@%....@@@
    0x3f, 0xff, 0xfc,  //.@@@@@@@@@@
    0x0b, 0xff, 0xfc,  //..%@@@@@@@@
    0x00, 0x00, 0xfc,  //........@@@
    0x00, 0x00, 0xfc,  //........@@@
    0x00, 0x00, 0xfc,  //........@@@
    0x00, 0x00, 0xfc,  //........@@@
    0x00, 0x00, 0xfc,  //........@@@
    0x00, 0x00, 0xfc,  //........@@@
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0448 (ш) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0449 (щ) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00,  //@@@.....@@@.....@@@..
    0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00,  //@@@.....@@@.....@@@..
    0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00,  //@@@.....@@@.....@@@..
    0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00,  //@@@.....@@@.....@@@..
    0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00,  //@@@.....@@@.....@@@..
    0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00,  //@@@.....@@@.....@@@..
    0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00,  //@@@.....@@@.....@@@..
    0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00,  //@@@.....@@@.....@@@..
    0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00,  //@@@.....@@@.....@@@..
    0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00,  //@@@.....@@@.....@@@..
    0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00,  //@@@.....@@@.....@@@..
    0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //...................@@
    0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //...................@@
    0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //...................@@
    0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,  //...................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+044a (ъ) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xfc, 0x00, 0x00,  //@@@@@@@........
    0xff, 0xfc, 0x00, 0x00,  //@@@@@@@........
    0x00, 0xfc, 0x00, 0x00,  //....@@@........
    0x00, 0xfc, 0x00, 0x00,  //....@@@........
    0x00, 0xfc, 0x00, 0x00,  //....@@@........
    0x00, 0xfc, 0x00, 0x00,  //....@@@........
    0x00, 0xff, 0xff, 0x80,  //....@@@@@@@@%..
    0x00, 0xff, 0xff, 0xf0,  //....@@@@@@@@@@.
    0x00, 0xfc, 0x02, 0xf8,  //....@@@....%@@%
    0x00, 0xfc, 0x00, 0xfc,  //....@@@.....@@@
    0x00, 0xfc, 0x00, 0xfc,  //....@@@.....@@@
    0x00, 0xfc, 0x02, 0xf8,  //....@@@....%@@%
    0x00, 0xff, 0xff, 0xf0,  //....@@@@@@@@@@.
    0x00, 0xff, 0xff, 0x80,  //....@@@@@@@@%..
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+044b (ы) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xff, 0xff, 0x80, 0x3f,  //@@@@@@@@%....@@@
    0xff, 0xff, 0xf0, 0x3f,  //@@@@@@@@@@...@@@
    0xfc, 0x02, 0xf8, 0x3f,  //@@@....%@@%..@@@
    0xfc, 0x00, 0xfc, 0x3f,  //@@@.....@@@..@@@
    0xfc, 0x00, 0xfc, 0x3f,  //@@@.....@@@..@@@
    0xfc, 0x02, 0xf8, 0x3f,  //@@@....%@@%..@@@
    0xff, 0xff, 0xf0, 0x3f,  //@@@@@@@@@@...@@@
    0xff, 0xff, 0x80, 0x3f,  //@@@@@@@@%....@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+044c (ь) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0x80,  //@@@@@@@@%..
    0xff, 0xff, 0xf0,  //@@@@@@@@@@.
    0xfc, 0x02, 0xf8,  //@@@....%@@%
    0xfc, 0x00, 0xfc,  //@@@.....@@@
    0xfc, 0x00, 0xfc,  //@@@.....@@@
    0xfc, 0x02, 0xf8,  //@@@....%@@%
    0xff, 0xff, 0xf0,  //@@@@@@@@@@.
    0xff, 0xff, 0x80,  //@@@@@@@@%..
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+044d (э) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x2f, 0xf8, 0x00,  //.%@@@@%....
    0xff, 0xff, 0x80,  //@@@@@@@@%..
    0xd0, 0x1f, 0xe0,  //@+...+@@@%.
    0x00, 0x03, 0xf0,  //.......@@@.
    0x00, 0x01, 0xf8,  //.......+@@%
    0x00, 0x00, 0xfc,  //........@@@
    0x0f, 0xff, 0xfc,  //..@@@@@@@@@
    0x0f, 0xff, 0xfc,  //..@@@@@@@@@
    0x00, 0x00, 0xfc,  //........@@@
    0x00, 0x01, 0xf8,  //........@@%
    0x00, 0x03, 0xf0,  //.......@@@.
    0xd0, 0x1f, 0xe0,  //@+...+@@@%.
    0xff, 0xff, 0x80,  //@@@@@@@@%..
    0x2f, 0xf9, 0x00,  //.%@@@@%+...
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+044e (ю) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xfc, 0x00, 0x7f, 0xe4, 0x00,  //@@@.....+@@@@%+...
    0xfc, 0x03, 0xff, 0xff, 0x00,  //@@@....@@@@@@@@%..
    0xfc, 0x0f, 0xe0, 0x2f, 0x80,  //@@@...@@@%...%@@%.
    0xfc, 0x2f, 0xc0, 0x0f, 0xd0,  //@@@..%@@@.....@@@+
    0xfc, 0x3f, 0x40, 0x07, 0xe0,  //@@@..@@@+.....+@@%
    0xff, 0xff, 0x00, 0x03, 0xf0,  //@@@@@@@@.......@@@
    0xff, 0xff, 0x00, 0x03, 0xf0,  //@@@@@@@@.......@@@
    0xfc, 0x3f, 0x00, 0x03, 0xf0,  //@@@..@@@.......@@@
    0xfc, 0x3f, 0x00, 0x03, 0xf0,  //@@@..@@@.......@@@
    0xfc, 0x2f, 0x40, 0x07, 0xe0,  //@@@..%@@+.....+@@%
    0xfc, 0x0f, 0xc0, 0x0f, 0xd0,  //@@@...@@@.....@@@+
    0xfc, 0x0b, 0xe0, 0x2f, 0x80,  //@@@...%@@%...%@@%.
    0xfc, 0x02, 0xff, 0xff, 0x00,  //@@@....%@@@@@@@@..
    0xfc, 0x00, 0x6f, 0xe4, 0x00,  //@@@.....+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+044f (я) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x02, 0xff, 0xff,  //...%@@@@@@@@
    0x0f, 0xff, 0xff,  //..@@@@@@@@@@
    0x2f, 0x80, 0x3f,  //.%@@%....@@@
    0x3f, 0x00, 0x3f,  //.@@@.....@@@
    0x3f, 0x00, 0x3f,  //.@@@.....@@@
    0x2f, 0x80, 0x3f,  //.%@@%....@@@
    0x0f, 0xff, 0xff,  //..@@@@@@@@@@
    0x02, 0xff, 0xff,  //...%@@@@@@@@
    0x00, 0xfe, 0x3f,  //....@@@%.@@@
    0x02, 0xfc, 0x3f,  //...%@@@..@@@
    0x07, 0xf0, 0x3f,  //..+@@@...@@@
    0x0f, 0xd0, 0x3f,  //..@@@+...@@@
    0x3f, 0xc0, 0x3f,  //.@@@%....@@@
    0xbf, 0x00, 0x3f,  //%@@@.....@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............



#elif USE_LV_FONT_DEJAVU_30_CYRILLIC == 4
    /*Unicode: U+0410 (А) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x1f, 0xff, 0x10, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x7f, 0xff, 0x70, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0xdf, 0xff, 0xd0, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x03, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x09, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x0e, 0xff, 0x7f, 0xfe, 0x00, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x00, 0x5f, 0xfd, 0x0d, 0xff, 0x50, 0x00, 0x00,  //....+@@@.@@@+....
    0x00, 0x00, 0xbf, 0xf7, 0x07, 0xff, 0xb0, 0x00, 0x00,  //....%@@+.+@@%....
    0x00, 0x01, 0xff, 0xf1, 0x01, 0xff, 0xf1, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x07, 0xff, 0xb0, 0x00, 0xbf, 0xf7, 0x00, 0x00,  //...+@@%...%@@+...
    0x00, 0x0d, 0xff, 0x50, 0x00, 0x5f, 0xfd, 0x00, 0x00,  //...@@@+...+@@@...
    0x00, 0x3f, 0xff, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00,  //...@@@.....@@@...
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //..@@@@@@@@@@@@@..
    0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0xdf, 0xf5, 0x00,  //.+@@@.......@@@+.
    0x0b, 0xff, 0x70, 0x00, 0x00, 0x00, 0x8f, 0xfb, 0x00,  //.%@@+.......+@@%.
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@.........@@@.
    0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@%.........@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0411 (Б) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0xff, 0xd9, 0x30, 0x00,  //@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00,  //@@@@@@@@@@@+.
    0xff, 0xf0, 0x00, 0x02, 0x7f, 0xff, 0x40,  //@@@.....+@@@+
    0xff, 0xf0, 0x00, 0x00, 0x07, 0xff, 0xb0,  //@@@......+@@%
    0xff, 0xf0, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x07, 0xff, 0xb0,  //@@@......+@@%
    0xff, 0xf0, 0x00, 0x02, 0x7f, 0xff, 0x40,  //@@@.....+@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00,  //@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xd9, 0x30, 0x00,  //@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0412 (В) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0xfe, 0xb5, 0x00, 0x00,  //@@@@@@@@%+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //@@@@@@@@@@%..
    0xff, 0xf0, 0x00, 0x14, 0xef, 0xf7, 0x00,  //@@@....+@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x5f, 0xfd, 0x00,  //@@@.....+@@@.
    0xff, 0xf0, 0x00, 0x00, 0x1f, 0xff, 0x00,  //@@@......@@@.
    0xff, 0xf0, 0x00, 0x00, 0x1f, 0xfe, 0x00,  //@@@......@@@.
    0xff, 0xf0, 0x00, 0x00, 0x4f, 0xfa, 0x00,  //@@@.....+@@%.
    0xff, 0xf0, 0x00, 0x04, 0xef, 0xe2, 0x00,  //@@@....+@@@..
    0xff, 0xff, 0xff, 0xff, 0xe9, 0x10, 0x00,  //@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x60, 0x00,  //@@@@@@@@@@+..
    0xff, 0xf0, 0x00, 0x02, 0x8f, 0xfa, 0x00,  //@@@.....%@@%.
    0xff, 0xf0, 0x00, 0x00, 0x08, 0xff, 0x70,  //@@@......%@@+
    0xff, 0xf0, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x08, 0xff, 0xb0,  //@@@......%@@%
    0xff, 0xf0, 0x00, 0x02, 0x8f, 0xff, 0x40,  //@@@.....%@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00,  //@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xfe, 0xc8, 0x20, 0x00,  //@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0413 (Г) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0414 (Д) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //....@@@@@@@@@@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //....@@@@@@@@@@@@..
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //....@@@......@@@..
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //....@@@......@@@..
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //....@@@......@@@..
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //....@@@......@@@..
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //....@@@......@@@..
    0x00, 0x01, 0xff, 0xe0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //....@@@......@@@..
    0x00, 0x02, 0xff, 0xd0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //....@@@......@@@..
    0x00, 0x04, 0xff, 0xc0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //....@@%......@@@..
    0x00, 0x05, 0xff, 0xa0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //...+@@%......@@@..
    0x00, 0x08, 0xff, 0x80, 0x00, 0x00, 0x0f, 0xff, 0x00,  //...+@@+......@@@..
    0x00, 0x0a, 0xff, 0x50, 0x00, 0x00, 0x0f, 0xff, 0x00,  //...%@@+......@@@..
    0x00, 0x0e, 0xff, 0x20, 0x00, 0x00, 0x0f, 0xff, 0x00,  //...@@@.......@@@..
    0x00, 0x1f, 0xfd, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //...@@@.......@@@..
    0x00, 0x8f, 0xf9, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //..%@@%.......@@@..
    0x07, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //.+@@@........@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@..............@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@..............@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@..............@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0415 (Е) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0416 (Ж) , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x8f, 0xff, 0x90, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x9f, 0xff, 0x80,  //%@@@%.......@@@.......%@@@%
    0x09, 0xff, 0xf8, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x08, 0xff, 0xf9, 0x00,  //.%@@@%......@@@......%@@@%.
    0x00, 0xaf, 0xff, 0x70, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x7f, 0xff, 0xa0, 0x00,  //..%@@@+.....@@@.....+@@@%..
    0x00, 0x0b, 0xff, 0xf6, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x06, 0xff, 0xfb, 0x00, 0x00,  //...%@@@+....@@@....+@@@%...
    0x00, 0x00, 0xbf, 0xff, 0x50, 0x00, 0xff, 0xf0, 0x00, 0x5f, 0xff, 0xb0, 0x00, 0x00,  //....%@@@+...@@@...+@@@%....
    0x00, 0x00, 0x0c, 0xff, 0xf4, 0x00, 0xff, 0xf0, 0x04, 0xff, 0xfc, 0x00, 0x00, 0x00,  //.....@@@@+..@@@..+@@@@.....
    0x00, 0x00, 0x01, 0xdf, 0xff, 0x30, 0xff, 0xf0, 0x4f, 0xff, 0xd1, 0x00, 0x00, 0x00,  //......@@@@..@@@..@@@@......
    0x00, 0x00, 0x00, 0x2f, 0xff, 0xf3, 0xff, 0xf3, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00,  //.......@@@@.@@@.@@@@.......
    0x00, 0x00, 0x00, 0x8f, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,  //......%@@@@@@@@@@@@@%......
    0x00, 0x00, 0x02, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x0c, 0xff, 0xb3, 0xff, 0xff, 0xff, 0xe3, 0xbf, 0xfc, 0x00, 0x00, 0x00,  //.....@@@%.@@@@@@@.%@@@.....
    0x00, 0x00, 0x6f, 0xff, 0x20, 0x3f, 0xff, 0xff, 0x30, 0x2f, 0xff, 0x60, 0x00, 0x00,  //....+@@@...@@@@@...@@@+....
    0x00, 0x01, 0xef, 0xf7, 0x00, 0x04, 0xff, 0xf4, 0x00, 0x08, 0xff, 0xe1, 0x00, 0x00,  //....@@@+...+@@@+...+@@@....
    0x00, 0x09, 0xff, 0xd0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xdf, 0xf9, 0x00, 0x00,  //...%@@@.....@@@.....@@@%...
    0x00, 0x3f, 0xff, 0x40, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x4f, 0xff, 0x30, 0x00,  //...@@@+.....@@@.....+@@@...
    0x00, 0xdf, 0xfa, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x0a, 0xff, 0xd0, 0x00,  //..@@@%......@@@......%@@@..
    0x07, 0xff, 0xf1, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x01, 0xff, 0xf7, 0x00,  //.+@@@.......@@@.......@@@+.
    0x1f, 0xff, 0x70, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x10,  //.@@@+.......@@@.......+@@@.
    0xbf, 0xfd, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0d, 0xff, 0xb0,  //%@@@........@@@........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+0417 (З) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x49, 0xdf, 0xfd, 0xb6, 0x00, 0x00,  //..+%@@@@%+...
    0x3c, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00,  //.@@@@@@@@@@+.
    0xcf, 0xe4, 0x00, 0x02, 0x6e, 0xff, 0x40,  //@@@+....+@@@+
    0xcc, 0x10, 0x00, 0x00, 0x04, 0xff, 0xc0,  //@@.......+@@@
    0x80, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //%.........@@@
    0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //..........@@@
    0x00, 0x00, 0x00, 0x02, 0x6e, 0xff, 0x80,  //........+@@@%
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xfc, 0x00,  //...@@@@@@@@@.
    0x00, 0x0f, 0xff, 0xff, 0xfe, 0x60, 0x00,  //...@@@@@@@+..
    0x00, 0x00, 0x00, 0x14, 0xcf, 0xe5, 0x00,  //.......+@@@+.
    0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x30,  //.........%@@.
    0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xa0,  //..........@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xe0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x70, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //+.........@@@
    0xf7, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x80,  //@+.......@@@%
    0xff, 0xa4, 0x10, 0x25, 0xdf, 0xfd, 0x00,  //@@%+...+@@@@.
    0x6e, 0xff, 0xff, 0xff, 0xff, 0xb1, 0x00,  //+@@@@@@@@@%..
    0x00, 0x5a, 0xdf, 0xfd, 0x93, 0x00, 0x00,  //..+%@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0418 (И) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xf0, 0x00, 0x00, 0x01, 0xff, 0xff,  //@@@.......@@@@
    0xff, 0xf0, 0x00, 0x00, 0x09, 0xff, 0xff,  //@@@......%@@@@
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xff, 0xff,  //@@@......@@@@@
    0xff, 0xf0, 0x00, 0x00, 0xaf, 0xff, 0xff,  //@@@.....%@@@@@
    0xff, 0xf0, 0x00, 0x03, 0xff, 0xff, 0xff,  //@@@.....@@@@@@
    0xff, 0xf0, 0x00, 0x0b, 0xff, 0xaf, 0xff,  //@@@....%@@%@@@
    0xff, 0xf0, 0x00, 0x4f, 0xff, 0x2f, 0xff,  //@@@...+@@@.@@@
    0xff, 0xf0, 0x00, 0xcf, 0xfa, 0x0f, 0xff,  //@@@...@@@%.@@@
    0xff, 0xf0, 0x05, 0xff, 0xf2, 0x0f, 0xff,  //@@@..+@@@..@@@
    0xff, 0xf0, 0x0d, 0xff, 0xa0, 0x0f, 0xff,  //@@@..@@@%..@@@
    0xff, 0xf0, 0x6f, 0xff, 0x20, 0x0f, 0xff,  //@@@.+@@@...@@@
    0xff, 0xf0, 0xef, 0xf9, 0x00, 0x0f, 0xff,  //@@@.@@@%...@@@
    0xff, 0xf7, 0xff, 0xf2, 0x00, 0x0f, 0xff,  //@@@+@@@....@@@
    0xff, 0xfe, 0xff, 0x90, 0x00, 0x0f, 0xff,  //@@@@@@%....@@@
    0xff, 0xff, 0xff, 0x10, 0x00, 0x0f, 0xff,  //@@@@@@.....@@@
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x0f, 0xff,  //@@@@@%.....@@@
    0xff, 0xff, 0xf1, 0x00, 0x00, 0x0f, 0xff,  //@@@@@......@@@
    0xff, 0xff, 0x90, 0x00, 0x00, 0x0f, 0xff,  //@@@@%......@@@
    0xff, 0xff, 0x10, 0x00, 0x00, 0x0f, 0xff,  //@@@@.......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0419 (Й) , Width: 14 */
    0x00, 0x0d, 0xf6, 0x00, 0x6f, 0xd0, 0x00,  //...@@+..+@@...
    0x00, 0x07, 0xff, 0xff, 0xff, 0x70, 0x00,  //...+@@@@@@+...
    0x00, 0x00, 0x6c, 0xff, 0xc6, 0x00, 0x00,  //....+@@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xf0, 0x00, 0x00, 0x01, 0xff, 0xff,  //@@@.......@@@@
    0xff, 0xf0, 0x00, 0x00, 0x09, 0xff, 0xff,  //@@@......%@@@@
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xff, 0xff,  //@@@......@@@@@
    0xff, 0xf0, 0x00, 0x00, 0xaf, 0xff, 0xff,  //@@@.....%@@@@@
    0xff, 0xf0, 0x00, 0x03, 0xff, 0xff, 0xff,  //@@@.....@@@@@@
    0xff, 0xf0, 0x00, 0x0b, 0xff, 0xaf, 0xff,  //@@@....%@@%@@@
    0xff, 0xf0, 0x00, 0x4f, 0xff, 0x2f, 0xff,  //@@@...+@@@.@@@
    0xff, 0xf0, 0x00, 0xcf, 0xfa, 0x0f, 0xff,  //@@@...@@@%.@@@
    0xff, 0xf0, 0x05, 0xff, 0xf2, 0x0f, 0xff,  //@@@..+@@@..@@@
    0xff, 0xf0, 0x0d, 0xff, 0xa0, 0x0f, 0xff,  //@@@..@@@%..@@@
    0xff, 0xf0, 0x6f, 0xff, 0x20, 0x0f, 0xff,  //@@@.+@@@...@@@
    0xff, 0xf0, 0xef, 0xf9, 0x00, 0x0f, 0xff,  //@@@.@@@%...@@@
    0xff, 0xf7, 0xff, 0xf2, 0x00, 0x0f, 0xff,  //@@@+@@@....@@@
    0xff, 0xfe, 0xff, 0x90, 0x00, 0x0f, 0xff,  //@@@@@@%....@@@
    0xff, 0xff, 0xff, 0x10, 0x00, 0x0f, 0xff,  //@@@@@@.....@@@
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x0f, 0xff,  //@@@@@%.....@@@
    0xff, 0xff, 0xf1, 0x00, 0x00, 0x0f, 0xff,  //@@@@@......@@@
    0xff, 0xff, 0x90, 0x00, 0x00, 0x0f, 0xff,  //@@@@%......@@@
    0xff, 0xff, 0x10, 0x00, 0x00, 0x0f, 0xff,  //@@@@.......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+041a (К) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x9f, 0xff, 0x80,  //@@@.......%@@@%
    0xff, 0xf0, 0x00, 0x00, 0x08, 0xff, 0xf9, 0x00,  //@@@......%@@@%.
    0xff, 0xf0, 0x00, 0x00, 0x7f, 0xff, 0xa0, 0x00,  //@@@.....+@@@%..
    0xff, 0xf0, 0x00, 0x06, 0xff, 0xfb, 0x00, 0x00,  //@@@....+@@@%...
    0xff, 0xf0, 0x00, 0x5f, 0xff, 0xb0, 0x00, 0x00,  //@@@...+@@@%....
    0xff, 0xf0, 0x04, 0xff, 0xfc, 0x00, 0x00, 0x00,  //@@@..+@@@@.....
    0xff, 0xf0, 0x4f, 0xff, 0xd1, 0x00, 0x00, 0x00,  //@@@..@@@@......
    0xff, 0xf3, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00,  //@@@.@@@@.......
    0xff, 0xfe, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,  //@@@@@@@@%......
    0xff, 0xff, 0xff, 0xff, 0xf2, 0x00, 0x00, 0x00,  //@@@@@@@@@......
    0xff, 0xff, 0xe3, 0xbf, 0xfc, 0x00, 0x00, 0x00,  //@@@@@.%@@@.....
    0xff, 0xff, 0x30, 0x2f, 0xff, 0x60, 0x00, 0x00,  //@@@@...@@@+....
    0xff, 0xf4, 0x00, 0x08, 0xff, 0xe1, 0x00, 0x00,  //@@@+...%@@@....
    0xff, 0xf0, 0x00, 0x00, 0xdf, 0xf9, 0x00, 0x00,  //@@@.....@@@%...
    0xff, 0xf0, 0x00, 0x00, 0x4f, 0xff, 0x30, 0x00,  //@@@.....+@@@...
    0xff, 0xf0, 0x00, 0x00, 0x0a, 0xff, 0xd0, 0x00,  //@@@......%@@@..
    0xff, 0xf0, 0x00, 0x00, 0x01, 0xff, 0xf7, 0x00,  //@@@.......@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x10,  //@@@.......+@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xb0,  //@@@........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+041b (Л) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....@@@@@@@@@@@
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....@@@@@@@@@@@
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x0f, 0xff,  //.....@@@.....@@@
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x0f, 0xff,  //.....@@@.....@@@
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x0f, 0xff,  //.....@@@.....@@@
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x0f, 0xff,  //.....@@@.....@@@
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x0f, 0xff,  //.....@@@.....@@@
    0x00, 0x00, 0x1f, 0xfe, 0x00, 0x00, 0x0f, 0xff,  //.....@@@.....@@@
    0x00, 0x00, 0x2f, 0xfd, 0x00, 0x00, 0x0f, 0xff,  //.....@@@.....@@@
    0x00, 0x00, 0x4f, 0xfb, 0x00, 0x00, 0x0f, 0xff,  //....+@@%.....@@@
    0x00, 0x00, 0x6f, 0xfa, 0x00, 0x00, 0x0f, 0xff,  //....+@@%.....@@@
    0x00, 0x00, 0x8f, 0xf7, 0x00, 0x00, 0x0f, 0xff,  //....%@@+.....@@@
    0x00, 0x00, 0xbf, 0xf4, 0x00, 0x00, 0x0f, 0xff,  //....%@@+.....@@@
    0x00, 0x00, 0xef, 0xf1, 0x00, 0x00, 0x0f, 0xff,  //....@@@......@@@
    0x00, 0x05, 0xff, 0xb0, 0x00, 0x00, 0x0f, 0xff,  //...+@@%......@@@
    0x00, 0x2e, 0xff, 0x40, 0x00, 0x00, 0x0f, 0xff,  //...@@@+......@@@
    0x27, 0xef, 0xf8, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.+@@@%.......@@@
    0xff, 0xfe, 0x60, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@@+........@@@
    0xea, 0x60, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@%+..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+041c (М) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xf8, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf0,  //@@@@@%.....%@@@@@
    0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf0,  //@@@@@@.....@@@@@@
    0xff, 0xfe, 0xff, 0x30, 0x00, 0x3f, 0xfe, 0xff, 0xf0,  //@@@@@@.....@@@@@@
    0xff, 0xf9, 0xff, 0x90, 0x00, 0x9f, 0xf9, 0xff, 0xf0,  //@@@%@@%...%@@%@@@
    0xff, 0xf3, 0xff, 0xe0, 0x00, 0xef, 0xf3, 0xff, 0xf0,  //@@@.@@@...@@@.@@@
    0xff, 0xf0, 0xef, 0xf4, 0x04, 0xff, 0xe0, 0xff, 0xf0,  //@@@.@@@+.+@@@.@@@
    0xff, 0xf0, 0x8f, 0xf9, 0x09, 0xff, 0x80, 0xff, 0xf0,  //@@@.%@@%.%@@%.@@@
    0xff, 0xf0, 0x3f, 0xfe, 0x0e, 0xff, 0x30, 0xff, 0xf0,  //@@@..@@@.@@@..@@@
    0xff, 0xf0, 0x0d, 0xff, 0x9f, 0xfd, 0x00, 0xff, 0xf0,  //@@@..@@@%@@@..@@@
    0xff, 0xf0, 0x08, 0xff, 0xff, 0xf8, 0x00, 0xff, 0xf0,  //@@@..%@@@@@%..@@@
    0xff, 0xf0, 0x02, 0xff, 0xff, 0xf2, 0x00, 0xff, 0xf0,  //@@@...@@@@@...@@@
    0xff, 0xf0, 0x00, 0xdf, 0xff, 0xd0, 0x00, 0xff, 0xf0,  //@@@...@@@@@...@@@
    0xff, 0xf0, 0x00, 0x7f, 0xff, 0x70, 0x00, 0xff, 0xf0,  //@@@...+@@@+...@@@
    0xff, 0xf0, 0x00, 0x2f, 0xff, 0x20, 0x00, 0xff, 0xf0,  //@@@....@@@....@@@
    0xff, 0xf0, 0x00, 0x0c, 0xfc, 0x00, 0x00, 0xff, 0xf0,  //@@@....@@@....@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+041d (Н) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+041e (О) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x60, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //..+@@@%....%@@@+..
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //.+@@@........@@@..
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //.@@@+........+@@@.
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //+@@@..........%@@+
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //%@@+..........+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@............@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@............@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@............@@@
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //%@@+..........+@@%
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //+@@@..........%@@+
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //.@@@+........+@@@.
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //.+@@@........@@@+.
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x60, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+041f (П) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0420 (Р) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xfd, 0x93, 0x00,  //@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //@@@@@@@@@@+.
    0xff, 0xf0, 0x00, 0x17, 0xff, 0xf4,  //@@@....+@@@+
    0xff, 0xf0, 0x00, 0x00, 0x8f, 0xfb,  //@@@.....%@@%
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xfe,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xfe,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x8f, 0xfb,  //@@@.....+@@%
    0xff, 0xf0, 0x00, 0x17, 0xff, 0xf4,  //@@@....+@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xfd, 0x93, 0x00,  //@@@@@@@@%...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0421 (С) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x06, 0xad, 0xff, 0xea, 0x50, 0x00,  //.....+%@@@@%+..
    0x00, 0x05, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x50,  //...+@@@@@@@@@@+
    0x00, 0x7f, 0xff, 0x93, 0x10, 0x26, 0xdf, 0xf0,  //..+@@@%....+@@@
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x08, 0xf0,  //.+@@@........%@
    0x0e, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x70,  //.@@@+.........+
    0x5f, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%...........
    0x9f, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+...........
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xaf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+...........
    0x5f, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%...........
    0x0e, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x70,  //.@@@..........+
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x08, 0xf0,  //.+@@@........%@
    0x00, 0x7f, 0xff, 0x93, 0x10, 0x26, 0xdf, 0xf0,  //..+@@@%....+@@@
    0x00, 0x05, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x50,  //...+@@@@@@@@@@+
    0x00, 0x00, 0x06, 0xad, 0xff, 0xea, 0x50, 0x00,  //.....+%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0422 (Т) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0423 (У) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xcf, 0xf7, 0x00, 0x00, 0x00, 0x07, 0xff, 0xc0,  //@@@+.......+@@@
    0x5f, 0xfd, 0x00, 0x00, 0x00, 0x0e, 0xff, 0x50,  //+@@@.......@@@+
    0x0e, 0xff, 0x40, 0x00, 0x00, 0x5f, 0xfe, 0x00,  //.@@@+.....+@@@.
    0x08, 0xff, 0xb0, 0x00, 0x00, 0xcf, 0xf8, 0x00,  //.%@@%.....%@@+.
    0x02, 0xff, 0xf2, 0x00, 0x02, 0xff, 0xf1, 0x00,  //..@@@.....@@@..
    0x00, 0xbf, 0xf8, 0x00, 0x09, 0xff, 0xa0, 0x00,  //..%@@%...%@@%..
    0x00, 0x4f, 0xfe, 0x00, 0x1f, 0xff, 0x30, 0x00,  //..+@@@...@@@...
    0x00, 0x0d, 0xff, 0x60, 0x7f, 0xfc, 0x00, 0x00,  //...@@@+.+@@@...
    0x00, 0x07, 0xff, 0xc0, 0xdf, 0xf5, 0x00, 0x00,  //...+@@@.@@@+...
    0x00, 0x01, 0xff, 0xf8, 0xff, 0xe0, 0x00, 0x00,  //....@@@%@@@....
    0x00, 0x00, 0x9f, 0xff, 0xff, 0x80, 0x00, 0x00,  //....%@@@@@%....
    0x00, 0x00, 0x3f, 0xff, 0xff, 0x10, 0x00, 0x00,  //.....@@@@@.....
    0x00, 0x00, 0x0c, 0xff, 0xfa, 0x00, 0x00, 0x00,  //.....@@@@%.....
    0x00, 0x00, 0x05, 0xff, 0xf3, 0x00, 0x00, 0x00,  //.....+@@@......
    0x00, 0x00, 0x00, 0xff, 0xc0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x05, 0xff, 0x60, 0x00, 0x00, 0x00,  //.....+@@+......
    0x00, 0x00, 0x3d, 0xfe, 0x00, 0x00, 0x00, 0x00,  //.....@@@.......
    0x00, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00,  //..@@@@@+.......
    0x00, 0xff, 0xeb, 0x50, 0x00, 0x00, 0x00, 0x00,  //..@@@%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0424 (Ф) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x38, 0xce, 0xff, 0xfe, 0xc8, 0x30, 0x00, 0x00,  //.....%@@@@@@@%.....
    0x00, 0x2c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x00,  //...@@@@@@@@@@@@@...
    0x03, 0xff, 0xfb, 0x51, 0xff, 0xf1, 0x5b, 0xff, 0xf3, 0x00,  //..@@@%+.@@@.+%@@@..
    0x0e, 0xff, 0x70, 0x00, 0xff, 0xf0, 0x00, 0x7f, 0xfe, 0x00,  //.@@@+...@@@...+@@@.
    0x7f, 0xfb, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x0b, 0xff, 0x70,  //+@@%....@@@....%@@+
    0xcf, 0xf4, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x04, 0xff, 0xc0,  //%@@+....@@@....+@@%
    0xef, 0xf1, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x01, 0xff, 0xe0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xef, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xe0,  //@@@.....@@@.....@@@
    0xcf, 0xf3, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x03, 0xff, 0xc0,  //@@@.....@@@.....@@%
    0x7f, 0xf8, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x08, 0xff, 0x70,  //+@@%....@@@....%@@+
    0x0e, 0xff, 0x30, 0x00, 0xff, 0xf0, 0x00, 0x3f, 0xfe, 0x00,  //.@@@....@@@....@@@.
    0x03, 0xff, 0xf7, 0x10, 0xff, 0xf0, 0x17, 0xff, 0xf3, 0x00,  //..@@@+..@@@..+@@@..
    0x00, 0x2c, 0xff, 0xfd, 0xff, 0xfd, 0xff, 0xfc, 0x20, 0x00,  //...@@@@@@@@@@@@@...
    0x00, 0x00, 0x38, 0xce, 0xff, 0xfe, 0xc8, 0x30, 0x00, 0x00,  //.....%@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0425 (Х) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x0b, 0xff, 0xd0, 0x00, 0x00, 0x00, 0xef, 0xfa,  //.%@@@.......@@@%
    0x02, 0xff, 0xf8, 0x00, 0x00, 0x09, 0xff, 0xe1,  //..@@@+.....%@@@.
    0x00, 0x7f, 0xff, 0x20, 0x00, 0x3f, 0xff, 0x50,  //..+@@@.....@@@+.
    0x00, 0x0d, 0xff, 0xb0, 0x00, 0xdf, 0xfb, 0x00,  //...@@@%...@@@%..
    0x00, 0x04, 0xff, 0xf4, 0x08, 0xff, 0xf1, 0x00,  //...+@@@+.%@@@...
    0x00, 0x00, 0xaf, 0xfd, 0x3f, 0xff, 0x60, 0x00,  //....%@@@.@@@+...
    0x00, 0x00, 0x1f, 0xff, 0xff, 0xfc, 0x00, 0x00,  //.....@@@@@@%....
    0x00, 0x00, 0x07, 0xff, 0xff, 0xf2, 0x00, 0x00,  //.....+@@@@@.....
    0x00, 0x00, 0x00, 0xdf, 0xff, 0x70, 0x00, 0x00,  //......@@@@+.....
    0x00, 0x00, 0x00, 0xcf, 0xff, 0x40, 0x00, 0x00,  //......@@@@+.....
    0x00, 0x00, 0x07, 0xff, 0xff, 0xd0, 0x00, 0x00,  //.....+@@@@@.....
    0x00, 0x00, 0x2f, 0xff, 0xff, 0xf7, 0x00, 0x00,  //.....@@@@@@+....
    0x00, 0x00, 0xcf, 0xfd, 0x7f, 0xff, 0x20, 0x00,  //....%@@@+@@@....
    0x00, 0x06, 0xff, 0xf3, 0x0d, 0xff, 0xb0, 0x00,  //...+@@@..@@@%...
    0x00, 0x1f, 0xff, 0x80, 0x03, 0xff, 0xf4, 0x00,  //...@@@%...@@@+..
    0x00, 0xbf, 0xfd, 0x00, 0x00, 0xaf, 0xfd, 0x00,  //..%@@@....%@@@..
    0x05, 0xff, 0xf4, 0x00, 0x00, 0x1f, 0xff, 0x70,  //.+@@@......@@@+.
    0x1e, 0xff, 0x90, 0x00, 0x00, 0x06, 0xff, 0xf2,  //.@@@%......+@@@.
    0xaf, 0xfe, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xfb,  //%@@@........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0426 (Ц) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0427 (Ч) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xef, 0xf2, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xbf, 0xf7, 0x00, 0x00, 0x00, 0xff, 0xf0,  //%@@+......@@@
    0x5f, 0xff, 0x50, 0x00, 0x00, 0xff, 0xf0,  //+@@@+.....@@@
    0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.%@@@@@@@@@@@
    0x00, 0x6c, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..+@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0428 (Ш) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0429 (Щ) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+042a (Ъ) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@..........
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@..........
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xfd, 0x93, 0x00,  //.....@@@@@@@@@%...
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //.....@@@@@@@@@@@+.
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x29, 0xff, 0xf4,  //.....@@@.....%@@@+
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x8f, 0xfb,  //.....@@@......%@@%
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x2f, 0xfe,  //.....@@@.......@@@
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.....@@@.......@@@
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x2f, 0xfe,  //.....@@@.......@@@
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x7f, 0xfb,  //.....@@@......+@@%
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x27, 0xff, 0xf4,  //.....@@@.....+@@@.
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //.....@@@@@@@@@@@+.
    0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xfd, 0x92, 0x00,  //.....@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+042b (Ы) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xff, 0xff, 0xff, 0xff, 0xd9, 0x30, 0x00, 0x0f, 0xff,  //@@@@@@@@@%.....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x0f, 0xff,  //@@@@@@@@@@@+...@@@
    0xff, 0xf0, 0x00, 0x02, 0x7f, 0xff, 0x40, 0x0f, 0xff,  //@@@.....+@@@+..@@@
    0xff, 0xf0, 0x00, 0x00, 0x07, 0xff, 0xb0, 0x0f, 0xff,  //@@@......+@@%..@@@
    0xff, 0xf0, 0x00, 0x00, 0x02, 0xff, 0xe0, 0x0f, 0xff,  //@@@.......@@@..@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x0f, 0xff,  //@@@.......@@@..@@@
    0xff, 0xf0, 0x00, 0x00, 0x02, 0xff, 0xe0, 0x0f, 0xff,  //@@@.......@@@..@@@
    0xff, 0xf0, 0x00, 0x00, 0x07, 0xff, 0xb0, 0x0f, 0xff,  //@@@......+@@%..@@@
    0xff, 0xf0, 0x00, 0x02, 0x7f, 0xff, 0x40, 0x0f, 0xff,  //@@@.....+@@@...@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00, 0x0f, 0xff,  //@@@@@@@@@@@+...@@@
    0xff, 0xff, 0xff, 0xff, 0xd9, 0x20, 0x00, 0x0f, 0xff,  //@@@@@@@@@%.....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+042c (Ь) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0xff, 0xd9, 0x30, 0x00,  //@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00,  //@@@@@@@@@@@+.
    0xff, 0xf0, 0x00, 0x02, 0x7f, 0xff, 0x40,  //@@@.....+@@@+
    0xff, 0xf0, 0x00, 0x00, 0x07, 0xff, 0xb0,  //@@@......+@@%
    0xff, 0xf0, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x07, 0xff, 0xb0,  //@@@......+@@%
    0xff, 0xf0, 0x00, 0x02, 0x7f, 0xff, 0x40,  //@@@.....+@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00,  //@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xd9, 0x20, 0x00,  //@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+042d (Э) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x5a, 0xdf, 0xfd, 0xa6, 0x00, 0x00, 0x00,  //..+%@@@@%+.....
    0x5e, 0xff, 0xff, 0xff, 0xff, 0xe5, 0x00, 0x00,  //+@@@@@@@@@@+...
    0xff, 0xd6, 0x20, 0x03, 0x7e, 0xff, 0x70, 0x00,  //@@@+....+@@@+..
    0xf9, 0x00, 0x00, 0x00, 0x01, 0xcf, 0xf4, 0x00,  //@%........@@@+.
    0x70, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd, 0x00,  //+..........@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xff, 0x50,  //...........%@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0x90,  //...........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xd0,  //............@@@
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,  //..@@@@@@@@@@@@@
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xd0,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0x90,  //...........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x50,  //...........@@@+
    0x70, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfd, 0x00,  //+.........+@@@.
    0xf9, 0x00, 0x00, 0x00, 0x02, 0xef, 0xf4, 0x00,  //@%........@@@+.
    0xff, 0xd6, 0x20, 0x03, 0x8f, 0xff, 0x70, 0x00,  //@@@+....%@@@+..
    0x5e, 0xff, 0xff, 0xff, 0xff, 0xe5, 0x00, 0x00,  //+@@@@@@@@@@+...
    0x00, 0x5a, 0xdf, 0xfe, 0xb6, 0x00, 0x00, 0x00,  //..+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+042e (Ю) , Width: 24 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x06, 0xbe, 0xff, 0xda, 0x60, 0x00, 0x00,  //@@@........+%@@@@%+.....
    0xff, 0xf0, 0x00, 0x00, 0x06, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //@@@......+@@@@@@@@@@+...
    0xff, 0xf0, 0x00, 0x00, 0x8f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //@@@.....%@@@%....%@@@+..
    0xff, 0xf0, 0x00, 0x06, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //@@@....+@@@........@@@..
    0xff, 0xf0, 0x00, 0x1e, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //@@@....@@@+........+@@@.
    0xff, 0xf0, 0x00, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //@@@...+@@@..........@@@+
    0xff, 0xf0, 0x00, 0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //@@@...@@@+..........+@@%
    0xff, 0xf0, 0x00, 0xef, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@...@@@............@@@
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@@@@@@@............@@@
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@@@@@@@............@@@
    0xff, 0xf0, 0x00, 0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@...@@@............@@@
    0xff, 0xf0, 0x00, 0xcf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@...@@@............@@@
    0xff, 0xf0, 0x00, 0x8f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //@@@...%@@+..........+@@%
    0xff, 0xf0, 0x00, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //@@@....@@@..........@@@+
    0xff, 0xf0, 0x00, 0x0b, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //@@@....%@@+........+@@@.
    0xff, 0xf0, 0x00, 0x02, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //@@@.....@@@........@@@..
    0xff, 0xf0, 0x00, 0x00, 0x4f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //@@@.....+@@@%....%@@@+..
    0xff, 0xf0, 0x00, 0x00, 0x03, 0xdf, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //@@@.......@@@@@@@@@@+...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x05, 0xad, 0xff, 0xda, 0x60, 0x00, 0x00,  //@@@........+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................


    /*Unicode: U+042f (Я) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x02, 0x9c, 0xef, 0xff, 0xff, 0xff,  //....%@@@@@@@@@
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff,  //..+@@@@@@@@@@@
    0x03, 0xff, 0xf7, 0x20, 0x00, 0x0f, 0xff,  //..@@@+.....@@@
    0x0b, 0xff, 0x70, 0x00, 0x00, 0x0f, 0xff,  //.%@@+......@@@
    0x0e, 0xff, 0x20, 0x00, 0x00, 0x0f, 0xff,  //.@@@.......@@@
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.@@@.......@@@
    0x0e, 0xff, 0x20, 0x00, 0x00, 0x0f, 0xff,  //.@@@.......@@@
    0x0a, 0xff, 0x70, 0x00, 0x00, 0x0f, 0xff,  //.%@@+......@@@
    0x02, 0xff, 0xf7, 0x20, 0x00, 0x0f, 0xff,  //..@@@+.....@@@
    0x00, 0x2c, 0xff, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@@@@@@
    0x00, 0x00, 0x4d, 0xff, 0xff, 0xff, 0xff,  //....+@@@@@@@@@
    0x00, 0x00, 0x1e, 0xff, 0x90, 0x0f, 0xff,  //.....@@@%..@@@
    0x00, 0x00, 0xaf, 0xfd, 0x00, 0x0f, 0xff,  //....%@@@...@@@
    0x00, 0x05, 0xff, 0xf4, 0x00, 0x0f, 0xff,  //...+@@@....@@@
    0x00, 0x1e, 0xff, 0x90, 0x00, 0x0f, 0xff,  //...@@@%....@@@
    0x00, 0xaf, 0xfd, 0x00, 0x00, 0x0f, 0xff,  //..%@@@.....@@@
    0x05, 0xff, 0xf4, 0x00, 0x00, 0x0f, 0xff,  //.+@@@+.....@@@
    0x1e, 0xff, 0x90, 0x00, 0x00, 0x0f, 0xff,  //.@@@%......@@@
    0xaf, 0xfd, 0x00, 0x00, 0x00, 0x0f, 0xff,  //%@@@.......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0430 (а) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x02, 0x7b, 0xef, 0xfd, 0x93, 0x00,  //..+%@@@@%...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0x60,  //.@@@@@@@@@+.
    0x0c, 0x62, 0x00, 0x27, 0xff, 0xf3,  //.@+....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xfa,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xfd,  //.........@@@
    0x00, 0x5a, 0xdf, 0xff, 0xff, 0xff,  //..+%@@@@@@@@
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@
    0x8f, 0xfe, 0x51, 0x00, 0x0f, 0xff,  //+@@@+....@@@
    0xdf, 0xf3, 0x00, 0x00, 0x2f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x5f, 0xff,  //@@@.....+@@@
    0xef, 0xf3, 0x00, 0x00, 0xdf, 0xff,  //@@@.....@@@@
    0xaf, 0xfc, 0x30, 0x2b, 0xaf, 0xff,  //%@@@...%%@@@
    0x2e, 0xff, 0xff, 0xfd, 0x1f, 0xff,  //.@@@@@@@.@@@
    0x02, 0xae, 0xfd, 0x81, 0x0f, 0xff,  //..%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0431 (б) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,  //..............
    0x00, 0x00, 0x04, 0x9c, 0xef, 0xff, 0x50,  //.....+%@@@@@+.
    0x00, 0x02, 0xcf, 0xff, 0xff, 0xff, 0xb0,  //....@@@@@@@@%.
    0x00, 0x2e, 0xff, 0xe8, 0x42, 0x10, 0x00,  //...@@@@%+.....
    0x00, 0xdf, 0xfb, 0x00, 0x00, 0x00, 0x00,  //..@@@%........
    0x06, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //.+@@%.........
    0x0b, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00,  //.%@@..........
    0x0f, 0xfd, 0x29, 0xdf, 0xfc, 0x70, 0x00,  //.@@@.%@@@@+...
    0x1f, 0xfe, 0xff, 0xff, 0xff, 0xfd, 0x10,  //.@@@@@@@@@@@..
    0x2f, 0xff, 0xfb, 0x20, 0x2b, 0xff, 0xc0,  //.@@@@%...%@@@.
    0x1f, 0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf5,  //.@@@@.....@@@+
    0x1f, 0xff, 0x60, 0x00, 0x00, 0x6f, 0xfa,  //.@@@+.....+@@%
    0x0f, 0xff, 0x20, 0x00, 0x00, 0x2f, 0xfe,  //.@@@.......@@@
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.@@@.......@@@
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.@@@.......@@@
    0x0d, 0xff, 0x20, 0x00, 0x00, 0x2f, 0xfd,  //.@@@.......@@@
    0x0a, 0xff, 0x60, 0x00, 0x00, 0x6f, 0xfa,  //.%@@+.....+@@%
    0x05, 0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf4,  //.+@@@.....@@@+
    0x00, 0xcf, 0xfb, 0x20, 0x2b, 0xff, 0xb0,  //..@@@%...%@@%.
    0x00, 0x1c, 0xff, 0xff, 0xff, 0xfc, 0x10,  //...@@@@@@@@@..
    0x00, 0x00, 0x6b, 0xef, 0xeb, 0x50, 0x00,  //....+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0432 (в) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xea, 0x30, 0x00,  //@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x00,  //@@@@@@@@@+.
    0xff, 0xf0, 0x01, 0xaf, 0xfd, 0x00,  //@@@...%@@@.
    0xff, 0xf0, 0x00, 0x1f, 0xff, 0x00,  //@@@....@@@.
    0xff, 0xf0, 0x00, 0x1f, 0xfc, 0x00,  //@@@....@@@.
    0xff, 0xf0, 0x01, 0xaf, 0xf4, 0x00,  //@@@...%@@+.
    0xff, 0xff, 0xff, 0xfd, 0x40, 0x00,  //@@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x00,  //@@@@@@@@@%.
    0xff, 0xf0, 0x00, 0x2b, 0xff, 0x80,  //@@@....%@@%
    0xff, 0xf0, 0x00, 0x01, 0xff, 0xe0,  //@@@.....@@@
    0xff, 0xf0, 0x00, 0x01, 0xff, 0xf0,  //@@@.....@@@
    0xff, 0xf0, 0x00, 0x2b, 0xff, 0xb0,  //@@@....%@@%
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x20,  //@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xfc, 0x81, 0x00,  //@@@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0433 (г) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0434 (д) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //....@@@@@@@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,  //....@@@@@@@@@..
    0x00, 0x00, 0xff, 0xf0, 0x00, 0xff, 0xf0, 0x00,  //....@@@...@@@..
    0x00, 0x00, 0xff, 0xf0, 0x00, 0xff, 0xf0, 0x00,  //....@@@...@@@..
    0x00, 0x00, 0xff, 0xf0, 0x00, 0xff, 0xf0, 0x00,  //....@@@...@@@..
    0x00, 0x02, 0xff, 0xe0, 0x00, 0xff, 0xf0, 0x00,  //....@@@...@@@..
    0x00, 0x03, 0xff, 0xd0, 0x00, 0xff, 0xf0, 0x00,  //....@@@...@@@..
    0x00, 0x06, 0xff, 0xb0, 0x00, 0xff, 0xf0, 0x00,  //...+@@%...@@@..
    0x00, 0x09, 0xff, 0x80, 0x00, 0xff, 0xf0, 0x00,  //...%@@%...@@@..
    0x00, 0x0e, 0xff, 0x40, 0x00, 0xff, 0xf0, 0x00,  //...@@@....@@@..
    0x00, 0x6f, 0xfd, 0x00, 0x00, 0xff, 0xf0, 0x00,  //..+@@@....@@@..
    0x05, 0xff, 0xf6, 0x00, 0x00, 0xff, 0xf0, 0x00,  //.+@@@+....@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@...........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@...........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@...........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@...........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0435 (е) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x03, 0xad, 0xff, 0xc7, 0x00, 0x00,  //....%@@@@+...
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xd2, 0x00,  //..%@@@@@@@@..
    0x09, 0xff, 0xc3, 0x01, 0x8f, 0xfc, 0x00,  //.%@@@...%@@@.
    0x3f, 0xfd, 0x00, 0x00, 0x0a, 0xff, 0x60,  //.@@@.....%@@+
    0x9f, 0xf6, 0x00, 0x00, 0x03, 0xff, 0xb0,  //%@@+......@@%
    0xdf, 0xf2, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xaf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.........
    0x4f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.........
    0x0a, 0xff, 0xd5, 0x10, 0x03, 0x7c, 0x00,  //.%@@@+....+@.
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0x03, 0xad, 0xff, 0xeb, 0x72, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0436 (ж) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x09, 0xff, 0xf5, 0x00, 0x0f, 0xff, 0x00, 0x05, 0xff, 0xf9, 0x00,  //.%@@@+...@@@...+@@@%.
    0x00, 0xbf, 0xff, 0x30, 0x0f, 0xff, 0x00, 0x3f, 0xff, 0xb0, 0x00,  //..%@@@...@@@...@@@%..
    0x00, 0x0d, 0xff, 0xe2, 0x0f, 0xff, 0x02, 0xef, 0xfd, 0x00, 0x00,  //...@@@@..@@@..@@@@...
    0x00, 0x01, 0xef, 0xfd, 0x0f, 0xff, 0x0d, 0xff, 0xe1, 0x00, 0x00,  //....@@@@.@@@.@@@@....
    0x00, 0x00, 0x3f, 0xff, 0xbf, 0xff, 0xbf, 0xff, 0x30, 0x00, 0x00,  //.....@@@%@@@%@@@.....
    0x00, 0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@%.....
    0x00, 0x00, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00,  //.....@@@@@@@@@@@.....
    0x00, 0x00, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00,  //....@@@@@@@@@@@@@....
    0x00, 0x06, 0xff, 0xf3, 0xcf, 0xff, 0xc3, 0xff, 0xf6, 0x00, 0x00,  //...+@@@.@@@@%.@@@+...
    0x00, 0x2f, 0xff, 0x70, 0x1f, 0xff, 0x10, 0x7f, 0xff, 0x10, 0x00,  //...@@@+..@@@..+@@@...
    0x00, 0xbf, 0xfd, 0x00, 0x0f, 0xff, 0x00, 0x0d, 0xff, 0xb0, 0x00,  //..%@@@...@@@...@@@%..
    0x06, 0xff, 0xf3, 0x00, 0x0f, 0xff, 0x00, 0x03, 0xff, 0xf6, 0x00,  //.+@@@....@@@....@@@+.
    0x1e, 0xff, 0x80, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x8f, 0xfe, 0x10,  //.@@@%....@@@....%@@@.
    0xaf, 0xfd, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x0d, 0xff, 0xa0,  //%@@@.....@@@.....@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0437 (з) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x27, 0xbe, 0xff, 0xeb, 0x70, 0x00,  //.+%@@@@%+..
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x20,  //@@@@@@@@@@.
    0xd7, 0x31, 0x01, 0x4b, 0xff, 0xc0,  //@+....+%@@@
    0x00, 0x00, 0x00, 0x01, 0xff, 0xf0,  //........@@@
    0x00, 0x00, 0x00, 0x3a, 0xff, 0xc0,  //.......%@@@
    0x00, 0x0f, 0xff, 0xff, 0xfe, 0x20,  //...@@@@@@@.
    0x00, 0x0f, 0xff, 0xff, 0xb1, 0x00,  //...@@@@@%..
    0x00, 0x00, 0x01, 0x5e, 0xfe, 0x30,  //......+@@@.
    0x00, 0x00, 0x00, 0x04, 0xff, 0xb0,  //.......+@@%
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //........@@@
    0x00, 0x00, 0x00, 0x04, 0xff, 0xe0,  //.......+@@@
    0xc5, 0x20, 0x02, 0x7f, 0xff, 0x90,  //%+....+@@@%
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x00,  //@@@@@@@@@%.
    0x28, 0xce, 0xff, 0xda, 0x40, 0x00,  //.%@@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0438 (и) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xf0, 0x00, 0x00, 0xdf, 0xff,  //@@@.....@@@@
    0xff, 0xf0, 0x00, 0x08, 0xff, 0xff,  //@@@....%@@@@
    0xff, 0xf0, 0x00, 0x3f, 0xff, 0xff,  //@@@....@@@@@
    0xff, 0xf0, 0x00, 0xdf, 0xff, 0xff,  //@@@...@@@@@@
    0xff, 0xf0, 0x08, 0xff, 0xff, 0xff,  //@@@..%@@@@@@
    0xff, 0xf0, 0x3f, 0xff, 0x7f, 0xff,  //@@@..@@@+@@@
    0xff, 0xf0, 0xdf, 0xfd, 0x0f, 0xff,  //@@@.@@@@.@@@
    0xff, 0xf8, 0xff, 0xf4, 0x0f, 0xff,  //@@@%@@@+.@@@
    0xff, 0xff, 0xff, 0xb0, 0x0f, 0xff,  //@@@@@@%..@@@
    0xff, 0xff, 0xff, 0x20, 0x0f, 0xff,  //@@@@@@...@@@
    0xff, 0xff, 0xf9, 0x00, 0x0f, 0xff,  //@@@@@%...@@@
    0xff, 0xff, 0xe0, 0x00, 0x0f, 0xff,  //@@@@@....@@@
    0xff, 0xff, 0x60, 0x00, 0x0f, 0xff,  //@@@@+....@@@
    0xff, 0xfc, 0x00, 0x00, 0x0f, 0xff,  //@@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0439 (й) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0xef, 0x10, 0x02, 0xfe, 0x00,  //..@@....@@..
    0x00, 0xbf, 0xa1, 0x1a, 0xfa, 0x00,  //..%@%..%@%..
    0x00, 0x3f, 0xff, 0xff, 0xf3, 0x00,  //...@@@@@@...
    0x00, 0x03, 0xbe, 0xeb, 0x30, 0x00,  //....%@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xf0, 0x00, 0x00, 0xdf, 0xff,  //@@@.....@@@@
    0xff, 0xf0, 0x00, 0x08, 0xff, 0xff,  //@@@....%@@@@
    0xff, 0xf0, 0x00, 0x3f, 0xff, 0xff,  //@@@....@@@@@
    0xff, 0xf0, 0x00, 0xdf, 0xff, 0xff,  //@@@...@@@@@@
    0xff, 0xf0, 0x08, 0xff, 0xff, 0xff,  //@@@..%@@@@@@
    0xff, 0xf0, 0x3f, 0xff, 0x7f, 0xff,  //@@@..@@@+@@@
    0xff, 0xf0, 0xdf, 0xfd, 0x0f, 0xff,  //@@@.@@@@.@@@
    0xff, 0xf8, 0xff, 0xf4, 0x0f, 0xff,  //@@@%@@@+.@@@
    0xff, 0xff, 0xff, 0xb0, 0x0f, 0xff,  //@@@@@@%..@@@
    0xff, 0xff, 0xff, 0x20, 0x0f, 0xff,  //@@@@@@...@@@
    0xff, 0xff, 0xf9, 0x00, 0x0f, 0xff,  //@@@@@%...@@@
    0xff, 0xff, 0xe0, 0x00, 0x0f, 0xff,  //@@@@@....@@@
    0xff, 0xff, 0x60, 0x00, 0x0f, 0xff,  //@@@@+....@@@
    0xff, 0xfc, 0x00, 0x00, 0x0f, 0xff,  //@@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+043a (к) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xf0, 0x00, 0x5f, 0xff, 0x90,  //@@@...+@@@%.
    0xff, 0xf0, 0x03, 0xff, 0xfb, 0x00,  //@@@...@@@%..
    0xff, 0xf0, 0x2e, 0xff, 0xd0, 0x00,  //@@@..@@@@...
    0xff, 0xf0, 0xdf, 0xfe, 0x20, 0x00,  //@@@.@@@@....
    0xff, 0xfb, 0xff, 0xf3, 0x00, 0x00,  //@@@%@@@.....
    0xff, 0xff, 0xff, 0x90, 0x00, 0x00,  //@@@@@@%.....
    0xff, 0xff, 0xff, 0xf2, 0x00, 0x00,  //@@@@@@@.....
    0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,  //@@@@@@@@....
    0xff, 0xfc, 0x3f, 0xff, 0x60, 0x00,  //@@@%.@@@+...
    0xff, 0xf1, 0x08, 0xff, 0xf1, 0x00,  //@@@..%@@@...
    0xff, 0xf0, 0x00, 0xdf, 0xfb, 0x00,  //@@@...@@@%..
    0xff, 0xf0, 0x00, 0x3f, 0xff, 0x50,  //@@@....@@@+.
    0xff, 0xf0, 0x00, 0x08, 0xff, 0xe1,  //@@@....%@@@.
    0xff, 0xf0, 0x00, 0x00, 0xdf, 0xfa,  //@@@.....@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+043b (л) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,  //....@@@@@@@@@@
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,  //....@@@@@@@@@@
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x0f, 0xff,  //....@@@....@@@
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x0f, 0xff,  //....@@@....@@@
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x0f, 0xff,  //....@@@....@@@
    0x00, 0x01, 0xff, 0xe0, 0x00, 0x0f, 0xff,  //....@@@....@@@
    0x00, 0x02, 0xff, 0xd0, 0x00, 0x0f, 0xff,  //....@@@....@@@
    0x00, 0x04, 0xff, 0xb0, 0x00, 0x0f, 0xff,  //...+@@%....@@@
    0x00, 0x07, 0xff, 0x90, 0x00, 0x0f, 0xff,  //...+@@%....@@@
    0x00, 0x0b, 0xff, 0x50, 0x00, 0x0f, 0xff,  //...%@@+....@@@
    0x00, 0x3f, 0xff, 0x00, 0x00, 0x0f, 0xff,  //...@@@.....@@@
    0x16, 0xef, 0xf6, 0x00, 0x00, 0x0f, 0xff,  //.+@@@+.....@@@
    0xff, 0xff, 0x70, 0x00, 0x00, 0x0f, 0xff,  //@@@@+......@@@
    0xec, 0x82, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@+........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+043c (м) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xf9, 0x00, 0x09, 0xff, 0xff, 0xf0,  //@@@@@%...%@@@@@
    0xff, 0xff, 0xfe, 0x00, 0x0e, 0xff, 0xff, 0xf0,  //@@@@@@...@@@@@@
    0xff, 0xfd, 0xff, 0x50, 0x5f, 0xfd, 0xff, 0xf0,  //@@@@@@+.+@@@@@@
    0xff, 0xf7, 0xff, 0xb0, 0xbf, 0xf7, 0xff, 0xf0,  //@@@+@@%.%@@+@@@
    0xff, 0xf1, 0xff, 0xf4, 0xff, 0xf1, 0xff, 0xf0,  //@@@.@@@+@@@.@@@
    0xff, 0xf0, 0xbf, 0xfe, 0xff, 0xb0, 0xff, 0xf0,  //@@@.%@@@@@%.@@@
    0xff, 0xf0, 0x4f, 0xff, 0xff, 0x40, 0xff, 0xf0,  //@@@.+@@@@@+.@@@
    0xff, 0xf0, 0x0e, 0xff, 0xfe, 0x00, 0xff, 0xf0,  //@@@..@@@@@..@@@
    0xff, 0xf0, 0x08, 0xff, 0xf8, 0x00, 0xff, 0xf0,  //@@@..%@@@%..@@@
    0xff, 0xf0, 0x02, 0xff, 0xf1, 0x00, 0xff, 0xf0,  //@@@...@@@...@@@
    0xff, 0xf0, 0x00, 0xbf, 0xb0, 0x00, 0xff, 0xf0,  //@@@...%@%...@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+043d (н) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+043e (о) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x06, 0xbe, 0xfe, 0xb5, 0x00, 0x00,  //...+%@@@%+...
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0x00,  //..@@@@@@@@@..
    0x0b, 0xff, 0xb2, 0x02, 0xbf, 0xfb, 0x00,  //.%@@%...%@@%.
    0x4f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x40,  //+@@@.....@@@+
    0xaf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xa0,  //%@@+.....+@@%
    0xef, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xef, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xaf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xa0,  //%@@+.....+@@%
    0x5f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x40,  //+@@@.....@@@+
    0x0b, 0xff, 0xb2, 0x02, 0xbf, 0xfb, 0x00,  //.%@@%...%@@%.
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0x00,  //..@@@@@@@@@..
    0x00, 0x06, 0xbe, 0xfe, 0xb5, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+043f (п) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0440 (р) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xf0, 0x19, 0xef, 0xd8, 0x00, 0x00,  //@@@..%@@@%...
    0xff, 0xf1, 0xdf, 0xff, 0xff, 0xd1, 0x00,  //@@@.@@@@@@@..
    0xff, 0xfb, 0xb2, 0x02, 0xbf, 0xfc, 0x00,  //@@@%%...%@@@.
    0xff, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x50,  //@@@@.....@@@+
    0xff, 0xf5, 0x00, 0x00, 0x05, 0xff, 0xa0,  //@@@+.....+@@%
    0xff, 0xf1, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf1, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf5, 0x00, 0x00, 0x05, 0xff, 0xa0,  //@@@+.....+@@%
    0xff, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x50,  //@@@@.....@@@+
    0xff, 0xfb, 0xb2, 0x02, 0xbf, 0xfc, 0x00,  //@@@%%...%@@@.
    0xff, 0xf1, 0xef, 0xff, 0xff, 0xe2, 0x00,  //@@@.@@@@@@@..
    0xff, 0xf0, 0x19, 0xef, 0xd8, 0x10, 0x00,  //@@@..%@@@%...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0441 (с) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x03, 0xad, 0xff, 0xd9, 0x30,  //....%@@@@%.
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xf0,  //..%@@@@@@@@
    0x0a, 0xff, 0xe5, 0x10, 0x15, 0xc0,  //.%@@@+...+%
    0x4f, 0xfe, 0x10, 0x00, 0x00, 0x00,  //.@@@.......
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00,  //%@@+.......
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00,  //%@@+.......
    0x3f, 0xfe, 0x10, 0x00, 0x00, 0x00,  //.@@@.......
    0x0a, 0xff, 0xe5, 0x10, 0x15, 0xc0,  //.%@@@+...+%
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xf0,  //..%@@@@@@@@
    0x00, 0x04, 0xae, 0xff, 0xd9, 0x30,  //...+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0442 (т) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0443 (у) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xcf, 0xf7, 0x00, 0x00, 0x00, 0x7f, 0xfc,  //@@@+......+@@@
    0x6f, 0xfd, 0x00, 0x00, 0x00, 0xef, 0xf5,  //+@@@......@@@+
    0x0e, 0xff, 0x40, 0x00, 0x05, 0xff, 0xe0,  //.@@@+....+@@@.
    0x08, 0xff, 0xa0, 0x00, 0x0c, 0xff, 0x70,  //.%@@%....@@@+.
    0x02, 0xff, 0xf1, 0x00, 0x3f, 0xff, 0x10,  //..@@@....@@@..
    0x00, 0xbf, 0xf7, 0x00, 0xaf, 0xf9, 0x00,  //..%@@+..%@@%..
    0x00, 0x5f, 0xfe, 0x01, 0xff, 0xf2, 0x00,  //..+@@@..@@@...
    0x00, 0x0e, 0xff, 0x58, 0xff, 0xc0, 0x00,  //...@@@++@@%...
    0x00, 0x08, 0xff, 0xbe, 0xff, 0x50, 0x00,  //...+@@%@@@+...
    0x00, 0x01, 0xff, 0xff, 0xfd, 0x00, 0x00,  //....@@@@@@....
    0x00, 0x00, 0xaf, 0xff, 0xf7, 0x00, 0x00,  //....%@@@@+....
    0x00, 0x00, 0x4f, 0xff, 0xf0, 0x00, 0x00,  //....+@@@@.....
    0x00, 0x00, 0x0e, 0xff, 0x90, 0x00, 0x00,  //.....@@@%.....
    0x00, 0x00, 0x1f, 0xff, 0x20, 0x00, 0x00,  //.....@@@......
    0x00, 0x00, 0x8f, 0xfb, 0x00, 0x00, 0x00,  //....%@@%......
    0x00, 0x01, 0xff, 0xf4, 0x00, 0x00, 0x00,  //....@@@+......
    0x00, 0x1b, 0xff, 0xc0, 0x00, 0x00, 0x00,  //...%@@@.......
    0x0f, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00,  //.@@@@@........
    0x0f, 0xfe, 0xb3, 0x00, 0x00, 0x00, 0x00,  //.@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0444 (ф) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x3b, 0xfe, 0x70, 0xff, 0xf0, 0x7e, 0xfb, 0x30, 0x00,  //...%@@+.@@@.+@@%...
    0x04, 0xff, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xff, 0xf4, 0x00,  //.+@@@@@%@@@%@@@@@+.
    0x0e, 0xff, 0x60, 0x4e, 0xff, 0xfe, 0x40, 0x6f, 0xfe, 0x00,  //.@@@+.+@@@@@+.+@@@.
    0x6f, 0xf9, 0x00, 0x04, 0xff, 0xf4, 0x00, 0x09, 0xff, 0x60,  //+@@%...+@@@+...%@@+
    0xbf, 0xf3, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x03, 0xff, 0xb0,  //%@@.....@@@.....@@%
    0xef, 0xf1, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x01, 0xff, 0xe0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xef, 0xf1, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x01, 0xff, 0xe0,  //@@@.....@@@.....@@@
    0xbf, 0xf3, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x03, 0xff, 0xb0,  //%@@.....@@@.....@@%
    0x7f, 0xf9, 0x00, 0x04, 0xff, 0xf4, 0x00, 0x09, 0xff, 0x70,  //+@@%...+@@@+...%@@+
    0x1e, 0xff, 0x60, 0x4e, 0xff, 0xfe, 0x40, 0x6f, 0xfe, 0x10,  //.@@@+.+@@@@@+.+@@@.
    0x05, 0xff, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xff, 0xf5, 0x00,  //.+@@@@@%@@@%@@@@@+.
    0x00, 0x3c, 0xfe, 0x70, 0xff, 0xf0, 0x7e, 0xfc, 0x30, 0x00,  //...@@@+.@@@.+@@@...
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0445 (х) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x9f, 0xff, 0x40, 0x00, 0x04, 0xff, 0xf9,  //%@@@+....+@@@%
    0x0c, 0xff, 0xe2, 0x00, 0x2e, 0xff, 0xc0,  //.%@@@....@@@@.
    0x01, 0xef, 0xfd, 0x00, 0xdf, 0xfe, 0x10,  //..@@@@..@@@@..
    0x00, 0x3f, 0xff, 0xba, 0xff, 0xf3, 0x00,  //...@@@%%@@@...
    0x00, 0x05, 0xff, 0xff, 0xff, 0x50, 0x00,  //...+@@@@@@+...
    0x00, 0x00, 0x8f, 0xff, 0xf8, 0x00, 0x00,  //....%@@@@%....
    0x00, 0x00, 0x0c, 0xff, 0xb0, 0x00, 0x00,  //.....@@@%.....
    0x00, 0x00, 0x3f, 0xff, 0xe1, 0x00, 0x00,  //.....@@@@.....
    0x00, 0x00, 0xdf, 0xff, 0xfc, 0x00, 0x00,  //....@@@@@%....
    0x00, 0x0a, 0xff, 0xff, 0xff, 0x80, 0x00,  //...%@@@@@@%...
    0x00, 0x6f, 0xff, 0x57, 0xff, 0xf4, 0x00,  //..+@@@++@@@+..
    0x02, 0xff, 0xf9, 0x00, 0xbf, 0xfe, 0x20,  //..@@@%..%@@@..
    0x0d, 0xff, 0xc0, 0x00, 0x1d, 0xff, 0xc0,  //.@@@@....@@@@.
    0xaf, 0xff, 0x20, 0x00, 0x03, 0xff, 0xf9,  //%@@@......@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0446 (ц) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0447 (ч) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@
    0xef, 0xf3, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@
    0xbf, 0xfb, 0x10, 0x00, 0xff, 0xf0,  //%@@%....@@@
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@
    0x03, 0xbf, 0xff, 0xff, 0xff, 0xf0,  //..%@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0448 (ш) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0449 (щ) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //...................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //...................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //...................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //...................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+044a (ъ) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@........
    0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@........
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@........
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@........
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@........
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //....@@@........
    0x00, 0x00, 0xff, 0xff, 0xff, 0xfd, 0x92, 0x00,  //....@@@@@@@@%..
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //....@@@@@@@@@@.
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x2b, 0xff, 0xb0,  //....@@@....%@@%
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x01, 0xff, 0xf0,  //....@@@.....@@@
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x01, 0xff, 0xf0,  //....@@@.....@@@
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x2b, 0xff, 0xb0,  //....@@@....%@@%
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20,  //....@@@@@@@@@@.
    0x00, 0x00, 0xff, 0xff, 0xff, 0xfd, 0x81, 0x00,  //....@@@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+044b (ы) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0xfd, 0x92, 0x00, 0x0f, 0xff,  //@@@@@@@@%....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0f, 0xff,  //@@@@@@@@@@...@@@
    0xff, 0xf0, 0x00, 0x2b, 0xff, 0xb0, 0x0f, 0xff,  //@@@....%@@%..@@@
    0xff, 0xf0, 0x00, 0x01, 0xff, 0xf0, 0x0f, 0xff,  //@@@.....@@@..@@@
    0xff, 0xf0, 0x00, 0x01, 0xff, 0xf0, 0x0f, 0xff,  //@@@.....@@@..@@@
    0xff, 0xf0, 0x00, 0x2b, 0xff, 0xb0, 0x0f, 0xff,  //@@@....%@@%..@@@
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x0f, 0xff,  //@@@@@@@@@@...@@@
    0xff, 0xff, 0xff, 0xfd, 0x81, 0x00, 0x0f, 0xff,  //@@@@@@@@%....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+044c (ь) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0xfd, 0x92, 0x00,  //@@@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30,  //@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x2b, 0xff, 0xb0,  //@@@....%@@%
    0xff, 0xf0, 0x00, 0x01, 0xff, 0xf0,  //@@@.....@@@
    0xff, 0xf0, 0x00, 0x01, 0xff, 0xf0,  //@@@.....@@@
    0xff, 0xf0, 0x00, 0x2b, 0xff, 0xb0,  //@@@....%@@%
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x20,  //@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xfd, 0x81, 0x00,  //@@@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+044d (э) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x28, 0xce, 0xfd, 0xa3, 0x00, 0x00,  //.%@@@@%....
    0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //@@@@@@@@%..
    0xc6, 0x20, 0x15, 0xdf, 0xf9, 0x00,  //@+...+@@@%.
    0x00, 0x00, 0x00, 0x1e, 0xff, 0x30,  //.......@@@.
    0x00, 0x00, 0x00, 0x07, 0xff, 0x90,  //.......+@@%
    0x00, 0x00, 0x00, 0x02, 0xff, 0xd0,  //........@@@
    0x00, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@
    0x00, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xd0,  //........@@@
    0x00, 0x00, 0x00, 0x04, 0xff, 0xa0,  //........@@%
    0x00, 0x00, 0x00, 0x0c, 0xff, 0x30,  //.......@@@.
    0xc6, 0x20, 0x15, 0xdf, 0xfa, 0x00,  //@+...+@@@%.
    0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //@@@@@@@@%..
    0x39, 0xce, 0xfe, 0xa4, 0x00, 0x00,  //.%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+044e (ю) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xf0, 0x00, 0x01, 0x7c, 0xef, 0xeb, 0x50, 0x00,  //@@@.....+@@@@%+...
    0xff, 0xf0, 0x00, 0x3e, 0xff, 0xff, 0xff, 0xfc, 0x10,  //@@@....@@@@@@@@%..
    0xff, 0xf0, 0x01, 0xef, 0xfb, 0x20, 0x2b, 0xff, 0xb0,  //@@@...@@@%...%@@%.
    0xff, 0xf0, 0x09, 0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf4,  //@@@..%@@@.....@@@+
    0xff, 0xf0, 0x0e, 0xff, 0x60, 0x00, 0x00, 0x6f, 0xfa,  //@@@..@@@+.....+@@%
    0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x2f, 0xfd,  //@@@@@@@@.......@@@
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@@@@@@.......@@@
    0xff, 0xf0, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..@@@.......@@@
    0xff, 0xf0, 0x0d, 0xff, 0x20, 0x00, 0x00, 0x2f, 0xfd,  //@@@..@@@.......@@@
    0xff, 0xf0, 0x09, 0xff, 0x60, 0x00, 0x00, 0x6f, 0xfa,  //@@@..%@@+.....+@@%
    0xff, 0xf0, 0x03, 0xff, 0xd0, 0x00, 0x00, 0xdf, 0xf4,  //@@@...@@@.....@@@+
    0xff, 0xf0, 0x00, 0xaf, 0xfb, 0x20, 0x2b, 0xff, 0xb0,  //@@@...%@@%...%@@%.
    0xff, 0xf0, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xfc, 0x10,  //@@@....%@@@@@@@@..
    0xff, 0xf0, 0x00, 0x00, 0x5b, 0xef, 0xeb, 0x50, 0x00,  //@@@.....+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+044f (я) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x18, 0xdf, 0xff, 0xff, 0xff,  //...%@@@@@@@@
    0x02, 0xef, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@@
    0x0b, 0xff, 0xb2, 0x00, 0x0f, 0xff,  //.%@@%....@@@
    0x0f, 0xff, 0x10, 0x00, 0x0f, 0xff,  //.@@@.....@@@
    0x0e, 0xff, 0x10, 0x00, 0x0f, 0xff,  //.@@@.....@@@
    0x0b, 0xff, 0xb2, 0x00, 0x0f, 0xff,  //.%@@%....@@@
    0x02, 0xef, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@@
    0x00, 0x18, 0xef, 0xff, 0xff, 0xff,  //...%@@@@@@@@
    0x00, 0x01, 0xef, 0xfa, 0x0f, 0xff,  //....@@@%.@@@
    0x00, 0x0b, 0xff, 0xd0, 0x0f, 0xff,  //...%@@@..@@@
    0x00, 0x7f, 0xff, 0x30, 0x0f, 0xff,  //..+@@@...@@@
    0x03, 0xff, 0xf7, 0x00, 0x0f, 0xff,  //..@@@+...@@@
    0x0d, 0xff, 0xc0, 0x00, 0x0f, 0xff,  //.@@@%....@@@
    0xaf, 0xfe, 0x10, 0x00, 0x0f, 0xff,  //%@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............



#elif USE_LV_FONT_DEJAVU_30_CYRILLIC == 8
    /*Unicode: U+0410 (А) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xff, 0xfc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xff, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x06, 0xee, 0xff, 0xff, 0x72, 0xff, 0xff, 0xee, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xd8, 0x00, 0xd8, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00,  //....+@@@.@@@+....
    0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0x7a, 0x00, 0x7a, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00,  //....%@@+.+@@%....
    0x00, 0x00, 0x00, 0x18, 0xfa, 0xff, 0xfc, 0x1c, 0x00, 0x1e, 0xfc, 0xff, 0xfa, 0x18, 0x00, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00,  //...+@@%...%@@+...
    0x00, 0x00, 0x00, 0xd4, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00,  //...@@@+...+@@@...
    0x00, 0x00, 0x34, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0x32, 0x00, 0x00,  //...@@@.....@@@...
    0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x04, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x04, 0x00,  //..@@@@@@@@@@@@@..
    0x00, 0x52, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0xff, 0xff, 0x50, 0x00,  //.+@@@.......@@@+.
    0x00, 0xb0, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xb0, 0x00,  //.%@@+.......+@@%.
    0x14, 0xfa, 0xff, 0xfc, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xf8, 0x14,  //.@@@.........@@@.
    0x70, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0x6e,  //+@@%.........@@@+
    0xce, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xce,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0411 (Б) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xda, 0x9e, 0x36, 0x00, 0x00,  //@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7a, 0x00,  //@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x02, 0x22, 0x7a, 0xf6, 0xff, 0xff, 0x48,  //@@@.....+@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xb4,  //@@@......+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe8,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf8,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe8,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xb2,  //@@@......+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x02, 0x20, 0x78, 0xf6, 0xff, 0xff, 0x46,  //@@@.....+@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x78, 0x00,  //@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf2, 0xd4, 0x98, 0x30, 0x00, 0x00,  //@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0412 (В) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xe6, 0xb4, 0x54, 0x00, 0x00, 0x00,  //@@@@@@@@%+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xae, 0x04, 0x00,  //@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10, 0x4e, 0xe2, 0xff, 0xff, 0x76, 0x00,  //@@@....+@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0xff, 0xd4, 0x00,  //@@@.....+@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xf6, 0x00,  //@@@......@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xe4, 0x00,  //@@@......@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xaa, 0x00,  //@@@.....+@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x0e, 0x4c, 0xe2, 0xff, 0xea, 0x26, 0x00,  //@@@....+@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x92, 0x1c, 0x00, 0x00,  //@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x62, 0x00, 0x00,  //@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x06, 0x28, 0x88, 0xfa, 0xff, 0xa8, 0x02,  //@@@.....%@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0x72,  //@@@......%@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xd4,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf8,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xec,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xb6,  //@@@......%@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x06, 0x28, 0x86, 0xfa, 0xff, 0xff, 0x40,  //@@@.....%@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x66, 0x00,  //@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xee, 0xca, 0x8a, 0x22, 0x00, 0x00,  //@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0413 (Г) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0414 (Д) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@......@@@..
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@......@@@..
    0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@......@@@..
    0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@......@@@..
    0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@......@@@..
    0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@......@@@..
    0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@......@@@..
    0x00, 0x00, 0x00, 0x40, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@%......@@@..
    0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //...+@@%......@@@..
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //...+@@+......@@@..
    0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //...%@@+......@@@..
    0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //...@@@.......@@@..
    0x00, 0x00, 0x1c, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //...@@@.......@@@..
    0x00, 0x00, 0x8a, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..%@@%.......@@@..
    0x00, 0x72, 0xfc, 0xff, 0xf4, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //.+@@@........@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@..............@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@..............@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@..............@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0415 (Е) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0416 (Ж) , Width: 27 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x86, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0x86,  //%@@@%.......@@@.......%@@@%
    0x00, 0x96, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0x94, 0x00,  //.%@@@%......@@@......%@@@%.
    0x00, 0x00, 0xa4, 0xff, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xa4, 0x00, 0x00,  //..%@@@+.....@@@.....+@@@%..
    0x00, 0x00, 0x02, 0xb2, 0xff, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0xff, 0xb0, 0x02, 0x00, 0x00,  //...%@@@+....@@@....+@@@%...
    0x00, 0x00, 0x00, 0x06, 0xbe, 0xff, 0xff, 0xfc, 0x56, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x58, 0xfc, 0xff, 0xff, 0xbe, 0x06, 0x00, 0x00, 0x00,  //....%@@@+...@@@...+@@@%....
    0x00, 0x00, 0x00, 0x00, 0x0c, 0xc8, 0xff, 0xff, 0xf8, 0x4a, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x4c, 0xfa, 0xff, 0xff, 0xc8, 0x0c, 0x00, 0x00, 0x00, 0x00,  //.....@@@@+..@@@..+@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xd2, 0xff, 0xff, 0xf6, 0x3e, 0x00, 0xff, 0xff, 0xff, 0x00, 0x40, 0xf6, 0xff, 0xff, 0xd2, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@..@@@..@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xff, 0xf0, 0x34, 0xff, 0xff, 0xff, 0x34, 0xf2, 0xff, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@@.@@@.@@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xec, 0xff, 0xff, 0xff, 0xec, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@@@@@@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xfa, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xfa, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@@@@@@@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xb6, 0x30, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x30, 0xb8, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@%.@@@@@@@.%@@@.....
    0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xf6, 0x22, 0x00, 0x3a, 0xf4, 0xff, 0xff, 0xff, 0xf4, 0x3a, 0x00, 0x22, 0xf6, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00,  //....+@@@...@@@@@...@@@+....
    0x00, 0x00, 0x00, 0x14, 0xec, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xec, 0x12, 0x00, 0x00, 0x00,  //....@@@+...+@@@+...+@@@....
    0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x06, 0xda, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00,  //...%@@@.....@@@.....@@@%...
    0x00, 0x00, 0x3c, 0xff, 0xff, 0xff, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xff, 0xfc, 0x3c, 0x00, 0x00,  //...@@@+.....@@@.....+@@@...
    0x00, 0x04, 0xd2, 0xff, 0xff, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0xd2, 0x04, 0x00,  //..@@@%......@@@......%@@@..
    0x00, 0x76, 0xff, 0xff, 0xf2, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf2, 0xff, 0xff, 0x74, 0x00,  //.+@@@.......@@@.......@@@+.
    0x1e, 0xf4, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0xf2, 0x1c,  //.@@@+.......@@@.......+@@@.
    0xb0, 0xff, 0xff, 0xd0, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xd0, 0xff, 0xff, 0xb0,  //%@@@........@@@........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........................


    /*Unicode: U+0417 (З) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x42, 0x9c, 0xd8, 0xf6, 0xf4, 0xde, 0xb2, 0x66, 0x0a, 0x00, 0x00,  //..+%@@@@%+...
    0x32, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x4e, 0x00,  //.@@@@@@@@@@+.
    0xce, 0xff, 0xe2, 0x4a, 0x0c, 0x00, 0x08, 0x26, 0x6e, 0xee, 0xff, 0xfc, 0x42,  //@@@+....+@@@+
    0xce, 0xca, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xc4,  //@@.......+@@@
    0x84, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf4,  //%.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xde,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x22, 0x68, 0xea, 0xff, 0xff, 0x8e,  //........+@@@%
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x0e,  //...@@@@@@@@@.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x66, 0x04, 0x00,  //...@@@@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x4a, 0xc2, 0xff, 0xe6, 0x56, 0x00,  //.......+@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xba, 0xff, 0xfc, 0x3a,  //.........%@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xae,  //..........@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xe4,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf6,  //..........@@@
    0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xff, 0xff, 0xda,  //+.........@@@
    0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xc2, 0xff, 0xff, 0x8a,  //@+.......@@@%
    0xff, 0xff, 0xae, 0x42, 0x10, 0x06, 0x24, 0x5e, 0xd8, 0xff, 0xff, 0xdc, 0x0e,  //@@%+...+@@@@.
    0x60, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x16, 0x00,  //+@@@@@@@@@%..
    0x00, 0x06, 0x58, 0xa8, 0xde, 0xf8, 0xf2, 0xd0, 0x96, 0x3a, 0x00, 0x00, 0x00,  //..+%@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0418 (И) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xf6, 0xff, 0xff, 0xff,  //@@@.......@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xff, 0xff,  //@@@......%@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xfc, 0xff, 0xff, 0xff, 0xff,  //@@@......@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@.....%@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff,  //@@@.....@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0xa8, 0xff, 0xff, 0xff,  //@@@....%@@%@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xfc, 0x2a, 0xff, 0xff, 0xff,  //@@@...+@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0xa6, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@%.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x54, 0xff, 0xff, 0xfa, 0x26, 0x00, 0xff, 0xff, 0xff,  //@@@..+@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x02, 0xd8, 0xff, 0xff, 0xa2, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@%..@@@
    0xff, 0xff, 0xff, 0x00, 0x64, 0xff, 0xff, 0xfa, 0x24, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.+@@@...@@@
    0xff, 0xff, 0xff, 0x06, 0xe2, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.@@@%...@@@
    0xff, 0xff, 0xff, 0x72, 0xff, 0xff, 0xfa, 0x22, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@+@@@....@@@
    0xff, 0xff, 0xff, 0xea, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@%....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x1e, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@.....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@%.....@@@
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@......@@@
    0xff, 0xff, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@%......@@@
    0xff, 0xff, 0xff, 0xf6, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@.......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0419 (Й) , Width: 14 */
    0x00, 0x00, 0x00, 0xdc, 0xff, 0x6a, 0x0a, 0x0a, 0x6a, 0xff, 0xdc, 0x00, 0x00, 0x00,  //...@@+..+@@...
    0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00,  //...+@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x66, 0xcc, 0xf0, 0xf0, 0xca, 0x62, 0x00, 0x00, 0x00, 0x00,  //....+@@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xf6, 0xff, 0xff, 0xff,  //@@@.......@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xff, 0xff,  //@@@......%@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xfc, 0xff, 0xff, 0xff, 0xff,  //@@@......@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@.....%@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff,  //@@@.....@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0xa8, 0xff, 0xff, 0xff,  //@@@....%@@%@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xfc, 0x2a, 0xff, 0xff, 0xff,  //@@@...+@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0xa6, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@%.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x54, 0xff, 0xff, 0xfa, 0x26, 0x00, 0xff, 0xff, 0xff,  //@@@..+@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x02, 0xd8, 0xff, 0xff, 0xa2, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@%..@@@
    0xff, 0xff, 0xff, 0x00, 0x64, 0xff, 0xff, 0xfa, 0x24, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.+@@@...@@@
    0xff, 0xff, 0xff, 0x06, 0xe2, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.@@@%...@@@
    0xff, 0xff, 0xff, 0x72, 0xff, 0xff, 0xfa, 0x22, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@+@@@....@@@
    0xff, 0xff, 0xff, 0xea, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@%....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x1e, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@.....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@%.....@@@
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@......@@@
    0xff, 0xff, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@%......@@@
    0xff, 0xff, 0xff, 0xf6, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@.......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+041a (К) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0x86,  //@@@.......%@@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0x94, 0x00,  //@@@......%@@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xa2, 0x00, 0x00,  //@@@.....+@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0xff, 0xb0, 0x02, 0x00, 0x00,  //@@@....+@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x58, 0xfc, 0xff, 0xff, 0xbc, 0x06, 0x00, 0x00, 0x00,  //@@@...+@@@%....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x4c, 0xfa, 0xff, 0xff, 0xc6, 0x0a, 0x00, 0x00, 0x00, 0x00,  //@@@..+@@@@.....
    0xff, 0xff, 0xff, 0x00, 0x40, 0xf6, 0xff, 0xff, 0xd0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..@@@@......
    0xff, 0xff, 0xff, 0x34, 0xf2, 0xff, 0xff, 0xfc, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.@@@@.......
    0xff, 0xff, 0xff, 0xec, 0xff, 0xff, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@%......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xfa, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@......
    0xff, 0xff, 0xff, 0xff, 0xee, 0x30, 0xbc, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@.%@@@.....
    0xff, 0xff, 0xff, 0xf4, 0x3a, 0x00, 0x26, 0xf8, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00,  //@@@@...@@@+....
    0xff, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xea, 0x12, 0x00, 0x00, 0x00,  //@@@+...%@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x08, 0xdc, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00,  //@@@.....@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xfc, 0x3a, 0x00, 0x00,  //@@@.....+@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0xd2, 0x02, 0x00,  //@@@......%@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf2, 0xff, 0xff, 0x74, 0x00,  //@@@.......@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xff, 0xff, 0xf2, 0x1c,  //@@@.......+@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xce, 0xff, 0xff, 0xb0,  //@@@........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+041b (Л) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff, 0xe8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....+@@%.....@@@
    0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....+@@%.....@@@
    0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....%@@+.....@@@
    0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....%@@+.....@@@
    0x00, 0x00, 0x00, 0x02, 0xee, 0xff, 0xfa, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@......@@@
    0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...+@@%......@@@
    0x00, 0x00, 0x22, 0xe2, 0xff, 0xff, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@+......@@@
    0x24, 0x7c, 0xee, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.+@@@%.......@@@
    0xff, 0xff, 0xff, 0xec, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@+........@@@
    0xe2, 0xaa, 0x66, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@%+..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+041c (М) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@%.....%@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@.....@@@@@@
    0xff, 0xff, 0xff, 0xe6, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xe6, 0xff, 0xff, 0xff,  //@@@@@@.....@@@@@@
    0xff, 0xff, 0xff, 0x92, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0x92, 0xff, 0xff, 0xff,  //@@@%@@%...%@@%@@@
    0xff, 0xff, 0xff, 0x3c, 0xff, 0xff, 0xe8, 0x02, 0x00, 0x02, 0xe8, 0xff, 0xff, 0x3a, 0xff, 0xff, 0xff,  //@@@.@@@...@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0xe2, 0xff, 0xff, 0x44, 0x00, 0x46, 0xff, 0xff, 0xe0, 0x00, 0xff, 0xff, 0xff,  //@@@.@@@+.+@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0x8c, 0xff, 0xff, 0x9c, 0x00, 0x9c, 0xff, 0xff, 0x8a, 0x00, 0xff, 0xff, 0xff,  //@@@.%@@%.%@@%.@@@
    0xff, 0xff, 0xff, 0x00, 0x34, 0xff, 0xff, 0xec, 0x0a, 0xee, 0xff, 0xff, 0x34, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@.@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0xdc, 0xff, 0xff, 0x9a, 0xff, 0xff, 0xda, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@%@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0x84, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..%@@@@@%..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2c, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xd4, 0xff, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...+@@@+...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....@@@....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....@@@....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+041d (Н) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+041e (О) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x06, 0x62, 0xac, 0xde, 0xf2, 0xf4, 0xde, 0xae, 0x64, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x4e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0c, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x6a, 0x00, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x42, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xec, 0xff, 0xfc, 0x40, 0x00,  //.+@@@........@@@..
    0x02, 0xda, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xd8, 0x00,  //.@@@+........+@@@.
    0x50, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x50,  //+@@@..........%@@+
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //%@@+..........+@@%
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@............@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@............@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@............@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@............@@@
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@............@@@
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //%@@+..........+@@%
    0x50, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x50,  //+@@@..........%@@+
    0x02, 0xda, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xd8, 0x00,  //.@@@+........+@@@.
    0x00, 0x42, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xec, 0xff, 0xfc, 0x42, 0x00,  //.+@@@........@@@+.
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0a, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x6c, 0x00, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x4e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x06, 0x62, 0xae, 0xde, 0xf4, 0xf4, 0xde, 0xae, 0x64, 0x08, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+041f (П) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0420 (Р) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xd8, 0x9c, 0x32, 0x00, 0x00,  //@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x76, 0x00,  //@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x1e, 0x7a, 0xf8, 0xff, 0xff, 0x44,  //@@@....+@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xb2,  //@@@.....%@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe8,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf8,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe8,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xb2,  //@@@.....+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x1c, 0x76, 0xf8, 0xff, 0xff, 0x46,  //@@@....+@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7a, 0x00,  //@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xd8, 0x9e, 0x34, 0x00, 0x00,  //@@@@@@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0421 (С) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x08, 0x66, 0xac, 0xde, 0xf2, 0xf6, 0xe0, 0xaa, 0x5e, 0x06, 0x00,  //.....+%@@@@%+..
    0x00, 0x00, 0x00, 0x58, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x52,  //...+@@@@@@@@@@+
    0x00, 0x00, 0x7a, 0xff, 0xff, 0xf8, 0x94, 0x3c, 0x12, 0x06, 0x22, 0x68, 0xd4, 0xff, 0xff,  //..+@@@%....+@@@
    0x00, 0x4e, 0xff, 0xff, 0xe8, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x8a, 0xff,  //.+@@@........%@
    0x04, 0xe0, 0xff, 0xfc, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a,  //.@@@+.........+
    0x56, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%...........
    0x9e, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+...........
    0xd6, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xec, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xec, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xd6, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xa0, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+...........
    0x56, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%...........
    0x04, 0xe0, 0xff, 0xfc, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a,  //.@@@..........+
    0x00, 0x4e, 0xff, 0xff, 0xe6, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x86, 0xff,  //.+@@@........%@
    0x00, 0x00, 0x7a, 0xff, 0xff, 0xf8, 0x92, 0x3c, 0x10, 0x06, 0x20, 0x66, 0xd2, 0xff, 0xff,  //..+@@@%....+@@@
    0x00, 0x00, 0x00, 0x58, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x50,  //...+@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x0a, 0x66, 0xae, 0xde, 0xf4, 0xf6, 0xe0, 0xac, 0x5c, 0x04, 0x00,  //.....+%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0422 (Т) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0423 (У) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xca, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0xc8,  //@@@+.......+@@@
    0x5e, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe2, 0xff, 0xff, 0x5a,  //+@@@.......@@@+
    0x06, 0xea, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0xe6, 0x04,  //.@@@+.....+@@@.
    0x00, 0x88, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x80, 0x00,  //.%@@%.....%@@+.
    0x00, 0x20, 0xfc, 0xff, 0xfc, 0x20, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xf8, 0x18, 0x00,  //..@@@.....@@@..
    0x00, 0x00, 0xb4, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xa4, 0x00, 0x00,  //..%@@%...%@@%..
    0x00, 0x00, 0x48, 0xff, 0xff, 0xec, 0x08, 0x00, 0x10, 0xf4, 0xff, 0xff, 0x38, 0x00, 0x00,  //..+@@@...@@@...
    0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0x60, 0x00, 0x74, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00,  //...@@@+.+@@@...
    0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0xca, 0x00, 0xde, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00,  //...+@@@.@@@+...
    0x00, 0x00, 0x00, 0x10, 0xf4, 0xff, 0xff, 0x86, 0xff, 0xff, 0xe8, 0x06, 0x00, 0x00, 0x00,  //....@@@%@@@....
    0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00,  //....%@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x1a, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xfc, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@+......
    0x00, 0x00, 0x00, 0x0a, 0x36, 0xda, 0xff, 0xe8, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@.......
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@+.......
    0x00, 0x00, 0xff, 0xf8, 0xe6, 0xb6, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@%+........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0424 (Ф) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x3a, 0x8c, 0xc8, 0xec, 0xff, 0xff, 0xff, 0xec, 0xc8, 0x8c, 0x3c, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@%.....
    0x00, 0x00, 0x24, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x26, 0x00, 0x00,  //...@@@@@@@@@@@@@...
    0x00, 0x34, 0xf0, 0xff, 0xff, 0xbc, 0x52, 0x16, 0xff, 0xff, 0xff, 0x16, 0x52, 0xbc, 0xff, 0xff, 0xf2, 0x34, 0x00,  //..@@@%+.@@@.+%@@@..
    0x0a, 0xe4, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xe4, 0x0a,  //.@@@+...@@@...+@@@.
    0x72, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0x72,  //+@@%....@@@....%@@+
    0xc0, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xc0,  //%@@+....@@@....+@@%
    0xea, 0xff, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xe8,  //@@@.....@@@.....@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xf8,  //@@@.....@@@.....@@@
    0xea, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xe8,  //@@@.....@@@.....@@@
    0xc2, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xc0,  //@@@.....@@@.....@@%
    0x74, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0x72,  //+@@%....@@@....%@@+
    0x0a, 0xe6, 0xff, 0xf8, 0x38, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x3a, 0xf8, 0xff, 0xe6, 0x0a,  //.@@@....@@@....@@@.
    0x00, 0x36, 0xf2, 0xff, 0xf4, 0x78, 0x10, 0x00, 0xff, 0xff, 0xff, 0x00, 0x10, 0x76, 0xf4, 0xff, 0xf2, 0x36, 0x00,  //..@@@+..@@@..+@@@..
    0x00, 0x00, 0x26, 0xc4, 0xff, 0xff, 0xfa, 0xd0, 0xff, 0xff, 0xff, 0xd0, 0xfa, 0xff, 0xff, 0xc4, 0x26, 0x00, 0x00,  //...@@@@@@@@@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x3c, 0x8e, 0xca, 0xee, 0xff, 0xff, 0xff, 0xee, 0xca, 0x8e, 0x3c, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0425 (Х) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0xb2, 0xff, 0xff, 0xde, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe0, 0xff, 0xff, 0xaa,  //.%@@@.......@@@%
    0x00, 0x20, 0xf6, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0xec, 0x16,  //..@@@+.....%@@@.
    0x00, 0x00, 0x7e, 0xff, 0xff, 0xf6, 0x22, 0x00, 0x00, 0x00, 0x3c, 0xfc, 0xff, 0xff, 0x5c, 0x00,  //..+@@@.....@@@+.
    0x00, 0x00, 0x06, 0xdc, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x08, 0xd8, 0xff, 0xff, 0xb6, 0x00, 0x00,  //...@@@%...@@@%..
    0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x88, 0xff, 0xff, 0xf0, 0x1c, 0x00, 0x00,  //...+@@@+.%@@@...
    0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xff, 0xde, 0x3c, 0xfa, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00,  //....%@@@.@@@+...
    0x00, 0x00, 0x00, 0x00, 0x1e, 0xf4, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x24, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xda, 0xff, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xca, 0xff, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x24, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@+....
    0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xd4, 0x78, 0xff, 0xff, 0xf6, 0x20, 0x00, 0x00, 0x00,  //....%@@@+@@@....
    0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xfc, 0x36, 0x02, 0xd2, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00,  //...+@@@..@@@%...
    0x00, 0x00, 0x1c, 0xf0, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00,  //...@@@%...@@@+..
    0x00, 0x00, 0xb6, 0xff, 0xff, 0xdc, 0x08, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0xdc, 0x06, 0x00,  //..%@@@....%@@@..
    0x00, 0x5e, 0xff, 0xff, 0xfc, 0x40, 0x00, 0x00, 0x00, 0x00, 0x18, 0xf0, 0xff, 0xff, 0x7e, 0x00,  //.+@@@......@@@+.
    0x16, 0xec, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xf6, 0x20,  //.@@@%......+@@@.
    0xac, 0xff, 0xff, 0xe2, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xd0, 0xff, 0xff, 0xb2,  //%@@@........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0426 (Ц) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@........@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //..............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0427 (Ч) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xf8, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xe4, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xb2, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //%@@+......@@@
    0x52, 0xff, 0xff, 0xf4, 0x5c, 0x0e, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //+@@@+.....@@@
    0x00, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@@
    0x00, 0x00, 0x68, 0xcc, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..+@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0428 (Ш) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@.......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0429 (Щ) , Width: 25 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.......@@@.......@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........................


    /*Unicode: U+042a (Ъ) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@..........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xda, 0x9e, 0x36, 0x00, 0x00,  //.....@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7a, 0x00,  //.....@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x06, 0x2a, 0x94, 0xfc, 0xff, 0xff, 0x48,  //.....@@@.....%@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xb4,  //.....@@@......%@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xff, 0xff, 0xe8,  //.....@@@.......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf8,  //.....@@@.......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe8,  //.....@@@.......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xb0,  //.....@@@......+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x02, 0x22, 0x7c, 0xf6, 0xff, 0xff, 0x40,  //.....@@@.....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x6e, 0x00,  //.....@@@@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf2, 0xd0, 0x92, 0x2a, 0x00, 0x00,  //.....@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+042b (Ы) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@............@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xda, 0x9e, 0x36, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@%.....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7a, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@@@+...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x02, 0x22, 0x78, 0xf6, 0xff, 0xff, 0x48, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....+@@@+..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xb4, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......+@@%..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe8, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf8, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe8, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.......@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xb0, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......+@@%..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x02, 0x22, 0x7a, 0xf6, 0xff, 0xff, 0x40, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....+@@@...@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x6e, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@@@+...@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf2, 0xd0, 0x92, 0x2a, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@%.....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+042c (Ь) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xda, 0x9e, 0x36, 0x00, 0x00,  //@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7a, 0x00,  //@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x02, 0x22, 0x78, 0xf6, 0xff, 0xff, 0x48,  //@@@.....+@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xb4,  //@@@......+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe8,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf8,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe8,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xff, 0xb0,  //@@@......+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x02, 0x22, 0x7a, 0xf6, 0xff, 0xff, 0x40,  //@@@.....+@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x6e, 0x00,  //@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf2, 0xd0, 0x92, 0x2a, 0x00, 0x00,  //@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+042d (Э) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x06, 0x5c, 0xaa, 0xde, 0xf4, 0xf2, 0xde, 0xae, 0x66, 0x08, 0x00, 0x00, 0x00, 0x00,  //..+%@@@@%+.....
    0x52, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x56, 0x00, 0x00, 0x00,  //+@@@@@@@@@@+...
    0xff, 0xff, 0xda, 0x6e, 0x24, 0x06, 0x0e, 0x30, 0x78, 0xe6, 0xff, 0xff, 0x74, 0x00, 0x00,  //@@@+....+@@@+..
    0xff, 0x92, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xce, 0xff, 0xfc, 0x4a, 0x00,  //@%........@@@+.
    0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xf6, 0xff, 0xde, 0x02,  //+..........@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x54,  //...........%@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0x9c,  //...........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xd4,  //............@@@
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //..@@@@@@@@@@@@@
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,  //..@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xec,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xd4,  //............@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0x9e,  //...........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0x54,  //...........@@@+
    0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0xff, 0xde, 0x02,  //+.........+@@@.
    0xff, 0x92, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xea, 0xff, 0xfc, 0x4a, 0x00,  //@%........@@@+.
    0xff, 0xff, 0xda, 0x6e, 0x22, 0x06, 0x0e, 0x36, 0x8a, 0xf6, 0xff, 0xff, 0x76, 0x00, 0x00,  //@@@+....%@@@+..
    0x50, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x56, 0x00, 0x00, 0x00,  //+@@@@@@@@@@+...
    0x00, 0x04, 0x5a, 0xaa, 0xde, 0xf4, 0xf4, 0xe0, 0xb0, 0x66, 0x08, 0x00, 0x00, 0x00, 0x00,  //..+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+042e (Ю) , Width: 24 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x6e, 0xb4, 0xe0, 0xf4, 0xf4, 0xde, 0xac, 0x62, 0x06, 0x00, 0x00, 0x00, 0x00,  //@@@........+%@@@@%+.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x4c, 0x00, 0x00, 0x00,  //@@@......+@@@@@@@@@@+...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xf8, 0x8c, 0x32, 0x0c, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x6a, 0x00, 0x00,  //@@@.....%@@@%....%@@@+..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xee, 0xff, 0xfc, 0x40, 0x00,  //@@@....+@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x12, 0xee, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xd8, 0x00,  //@@@....@@@+........+@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0x50,  //@@@...+@@@..........@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //@@@...@@@+..........+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xec, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@...@@@............@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@@@@@@@............@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@@@@@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xee, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@...@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xcc, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@...@@@............@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //@@@...%@@+..........+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0x50,  //@@@....@@@..........@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xd8, 0x00,  //@@@....%@@+........+@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf0, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xee, 0xff, 0xfa, 0x40, 0x00,  //@@@.....@@@........@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xf6, 0xff, 0xf8, 0x8c, 0x32, 0x0a, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x68, 0x00, 0x00,  //@@@.....+@@@%....%@@@+..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x4a, 0x00, 0x00, 0x00,  //@@@.......@@@@@@@@@@+...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x5e, 0xac, 0xde, 0xf4, 0xf4, 0xde, 0xae, 0x62, 0x06, 0x00, 0x00, 0x00, 0x00,  //@@@........+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................


    /*Unicode: U+042f (Я) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x28, 0x90, 0xce, 0xee, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....%@@@@@@@@@
    0x00, 0x00, 0x68, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..+@@@@@@@@@@@
    0x00, 0x3c, 0xfc, 0xff, 0xf6, 0x7a, 0x20, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@+.....@@@
    0x00, 0xb0, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.%@@+......@@@
    0x00, 0xe8, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@.......@@@
    0x00, 0xfa, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@.......@@@
    0x00, 0xe8, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@.......@@@
    0x00, 0xaa, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.%@@+......@@@
    0x00, 0x2c, 0xf2, 0xff, 0xf8, 0x7c, 0x20, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@+.....@@@
    0x00, 0x00, 0x2e, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x4a, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....+@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x16, 0xec, 0xff, 0xff, 0x94, 0x00, 0x00, 0xff, 0xff, 0xff,  //.....@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xff, 0xde, 0x0a, 0x00, 0x00, 0xff, 0xff, 0xff,  //....%@@@...@@@
    0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xfc, 0x40, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...+@@@....@@@
    0x00, 0x00, 0x16, 0xea, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@%....@@@
    0x00, 0x00, 0xac, 0xff, 0xff, 0xde, 0x0a, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..%@@@.....@@@
    0x00, 0x56, 0xff, 0xff, 0xfc, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.+@@@+.....@@@
    0x14, 0xea, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@%......@@@
    0xaa, 0xff, 0xff, 0xde, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //%@@@.......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0430 (а) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x2a, 0x7c, 0xbc, 0xe6, 0xf8, 0xf2, 0xd8, 0x9c, 0x30, 0x00, 0x00,  //..+%@@@@%...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x6c, 0x00,  //.@@@@@@@@@+.
    0x00, 0xc6, 0x68, 0x2a, 0x0a, 0x06, 0x24, 0x7e, 0xf6, 0xff, 0xfc, 0x34,  //.@+....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xa2,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xde,  //.........@@@
    0x00, 0x00, 0x50, 0xaa, 0xdc, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //..+%@@@@@@@@
    0x06, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@
    0x80, 0xff, 0xff, 0xe0, 0x54, 0x1a, 0x04, 0x00, 0x04, 0xff, 0xff, 0xff,  //+@@@+....@@@
    0xda, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xff,  //@@@......@@@
    0xf8, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff,  //@@@.....+@@@
    0xea, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x04, 0xd4, 0xff, 0xff, 0xff,  //@@@.....@@@@
    0xa4, 0xff, 0xff, 0xce, 0x32, 0x06, 0x2c, 0xb6, 0xae, 0xff, 0xff, 0xff,  //%@@@...%%@@@
    0x22, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x18, 0xff, 0xff, 0xff,  //.@@@@@@@.@@@
    0x00, 0x20, 0xa2, 0xe8, 0xf8, 0xdc, 0x8c, 0x12, 0x00, 0xff, 0xff, 0xff,  //..%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0431 (б) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x22, 0x02, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x98, 0xcc, 0xea, 0xfa, 0xff, 0xff, 0x5e, 0x00,  //.....+%@@@@@+.
    0x00, 0x00, 0x00, 0x2a, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x00,  //....@@@@@@@@%.
    0x00, 0x00, 0x2a, 0xec, 0xff, 0xff, 0xe8, 0x82, 0x4c, 0x2e, 0x1a, 0x06, 0x00, 0x00,  //...@@@@%+.....
    0x00, 0x04, 0xd4, 0xff, 0xff, 0xb4, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@%........
    0x00, 0x64, 0xff, 0xff, 0xc0, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@%.........
    0x00, 0xbe, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@..........
    0x00, 0xf8, 0xff, 0xdc, 0x22, 0x96, 0xda, 0xf6, 0xf0, 0xc8, 0x72, 0x08, 0x00, 0x00,  //.@@@.%@@@@+...
    0x14, 0xff, 0xff, 0xe8, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x1a, 0x00,  //.@@@@@@@@@@@..
    0x20, 0xff, 0xff, 0xff, 0xff, 0xba, 0x2c, 0x06, 0x2e, 0xbe, 0xff, 0xff, 0xc6, 0x02,  //.@@@@%...%@@@.
    0x1a, 0xff, 0xff, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x54,  //.@@@@.....@@@+
    0x10, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xac,  //.@@@+.....+@@%
    0x0a, 0xff, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xe0,  //.@@@.......@@@
    0x04, 0xff, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf6,  //.@@@.......@@@
    0x00, 0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //.@@@.......@@@
    0x00, 0xde, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xde,  //.@@@.......@@@
    0x00, 0xa8, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //.%@@+.....+@@%
    0x00, 0x50, 0xff, 0xff, 0xd8, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //.+@@@.....@@@+
    0x00, 0x00, 0xc4, 0xff, 0xff, 0xb8, 0x2a, 0x04, 0x2c, 0xbc, 0xff, 0xff, 0xba, 0x00,  //..@@@%...%@@%.
    0x00, 0x00, 0x18, 0xcc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //...@@@@@@@@@..
    0x00, 0x00, 0x00, 0x04, 0x66, 0xbe, 0xea, 0xfa, 0xea, 0xba, 0x5e, 0x02, 0x00, 0x00,  //....+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0432 (в) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xe4, 0xaa, 0x3a, 0x00, 0x00,  //@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x54, 0x00,  //@@@@@@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x14, 0xa4, 0xff, 0xff, 0xd6, 0x00,  //@@@...%@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xf6, 0x00,  //@@@....@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x16, 0xff, 0xff, 0xce, 0x00,  //@@@....@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x14, 0xa8, 0xff, 0xf2, 0x44, 0x00,  //@@@...%@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x40, 0x00, 0x00,  //@@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x96, 0x04,  //@@@@@@@@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0x24, 0xb2, 0xff, 0xff, 0x8e,  //@@@....%@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xec,  //@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xf2,  //@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0x24, 0xb2, 0xff, 0xff, 0xb6,  //@@@....%@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0x26,  //@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf2, 0xce, 0x84, 0x14, 0x00,  //@@@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0433 (г) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0434 (д) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@@@@@@@..
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@...@@@..
    0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@...@@@..
    0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@...@@@..
    0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xec, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@...@@@..
    0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xd6, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //....@@@...@@@..
    0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //...+@@%...@@@..
    0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //...%@@%...@@@..
    0x00, 0x00, 0x04, 0xe8, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //...@@@....@@@..
    0x00, 0x00, 0x62, 0xff, 0xff, 0xde, 0x02, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //..+@@@....@@@..
    0x00, 0x58, 0xf4, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //.+@@@+....@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...........@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...........@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...........@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0435 (е) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x3c, 0xa2, 0xde, 0xf6, 0xf0, 0xca, 0x78, 0x0a, 0x00, 0x00,  //....%@@@@+...
    0x00, 0x04, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x20, 0x00,  //..%@@@@@@@@..
    0x00, 0x96, 0xff, 0xff, 0xc4, 0x3a, 0x06, 0x18, 0x8c, 0xff, 0xff, 0xce, 0x04,  //.%@@@...%@@@.
    0x34, 0xff, 0xff, 0xde, 0x08, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x60,  //.@@@.....%@@+
    0x9a, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xb4,  //%@@+......@@%
    0xd8, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xe6,  //@@@.......@@@
    0xf4, 0xff, 0xff, 0xfa, 0xfa, 0xfc, 0xfc, 0xfc, 0xfc, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@
    0xe0, 0xff, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xa4, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.........
    0x40, 0xff, 0xff, 0xde, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.........
    0x00, 0xa0, 0xff, 0xff, 0xd2, 0x54, 0x14, 0x02, 0x0e, 0x32, 0x72, 0xcc, 0x00,  //.%@@@+....+@.
    0x00, 0x06, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0x00, 0x00, 0x3c, 0xa0, 0xdc, 0xf6, 0xf8, 0xe4, 0xbc, 0x74, 0x26, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0436 (ж) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x92, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xff, 0x92, 0x00,  //.%@@@+...@@@...+@@@%.
    0x00, 0x02, 0xb6, 0xff, 0xff, 0xf6, 0x3a, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x3a, 0xf8, 0xff, 0xff, 0xb4, 0x02, 0x00,  //..%@@@...@@@...@@@%..
    0x00, 0x00, 0x0c, 0xd2, 0xff, 0xff, 0xea, 0x20, 0x00, 0xff, 0xff, 0xff, 0x00, 0x20, 0xea, 0xff, 0xff, 0xd0, 0x0c, 0x00, 0x00,  //...@@@@..@@@..@@@@...
    0x00, 0x00, 0x00, 0x1e, 0xe6, 0xff, 0xff, 0xd4, 0x0e, 0xff, 0xff, 0xff, 0x0e, 0xd6, 0xff, 0xff, 0xe6, 0x1c, 0x00, 0x00, 0x00,  //....@@@@.@@@.@@@@....
    0x00, 0x00, 0x00, 0x00, 0x36, 0xf6, 0xff, 0xff, 0xba, 0xff, 0xff, 0xff, 0xba, 0xff, 0xff, 0xf4, 0x34, 0x00, 0x00, 0x00, 0x00,  //.....@@@%@@@%@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x28, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x28, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00,  //....@@@@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xf8, 0x30, 0xc2, 0xff, 0xff, 0xff, 0xc0, 0x30, 0xf8, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00,  //...+@@@.@@@@%.@@@+...
    0x00, 0x00, 0x20, 0xf2, 0xff, 0xff, 0x7c, 0x00, 0x12, 0xff, 0xff, 0xff, 0x12, 0x00, 0x7c, 0xff, 0xff, 0xf2, 0x1e, 0x00, 0x00,  //...@@@+..@@@..+@@@...
    0x00, 0x00, 0xba, 0xff, 0xff, 0xd0, 0x04, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x04, 0xd0, 0xff, 0xff, 0xb8, 0x00, 0x00,  //..%@@@...@@@...@@@%..
    0x00, 0x60, 0xff, 0xff, 0xfa, 0x32, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x32, 0xfa, 0xff, 0xff, 0x60, 0x00,  //.+@@@....@@@....@@@+.
    0x16, 0xee, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xec, 0x16,  //.@@@%....@@@....%@@@.
    0xac, 0xff, 0xff, 0xd8, 0x06, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x08, 0xd8, 0xff, 0xff, 0xac,  //%@@@.....@@@.....@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+0437 (з) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x28, 0x76, 0xb4, 0xe0, 0xf8, 0xf8, 0xe6, 0xba, 0x70, 0x0c, 0x00,  //.+%@@@@%+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x2a,  //@@@@@@@@@@.
    0xd0, 0x7a, 0x3c, 0x1c, 0x04, 0x12, 0x46, 0xbc, 0xff, 0xff, 0xc4,  //@+....+%@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xff, 0xf4,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x34, 0xae, 0xff, 0xff, 0xc4,  //.......%@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x2c,  //...@@@@@@@.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x1c, 0x00,  //...@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x5c, 0xe6, 0xff, 0xe8, 0x30,  //......+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xff, 0xbc,  //.......+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf2,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xe6,  //.......+@@@
    0xc0, 0x5e, 0x22, 0x06, 0x0a, 0x28, 0x7e, 0xf2, 0xff, 0xff, 0x92,  //%+....+@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x0a,  //@@@@@@@@@%.
    0x2e, 0x86, 0xc6, 0xee, 0xfc, 0xf2, 0xd8, 0xa4, 0x4e, 0x00, 0x00,  //.%@@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0438 (и) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd6, 0xff, 0xff, 0xff,  //@@@.....@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff,  //@@@....%@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x36, 0xfa, 0xff, 0xff, 0xff, 0xff,  //@@@....@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x06, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@...@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x88, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xff,  //@@@..%@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x34, 0xfa, 0xff, 0xff, 0x78, 0xff, 0xff, 0xff,  //@@@..@@@+@@@
    0xff, 0xff, 0xff, 0x06, 0xd4, 0xff, 0xff, 0xdc, 0x06, 0xff, 0xff, 0xff,  //@@@.@@@@.@@@
    0xff, 0xff, 0xff, 0x84, 0xff, 0xff, 0xff, 0x4e, 0x00, 0xff, 0xff, 0xff,  //@@@%@@@+.@@@
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xba, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@%..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x2a, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@...@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@%...@@@
    0xff, 0xff, 0xff, 0xff, 0xea, 0x0e, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@....@@@
    0xff, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@+....@@@
    0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0439 (й) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0xe6, 0xff, 0x1e, 0x00, 0x00, 0x20, 0xff, 0xe4, 0x00, 0x00,  //..@@....@@..
    0x00, 0x00, 0xb0, 0xff, 0xaa, 0x14, 0x14, 0xae, 0xff, 0xae, 0x00, 0x00,  //..%@%..%@%..
    0x00, 0x00, 0x32, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x30, 0x00, 0x00,  //...@@@@@@...
    0x00, 0x00, 0x00, 0x3a, 0xbc, 0xec, 0xec, 0xbc, 0x38, 0x00, 0x00, 0x00,  //....%@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd6, 0xff, 0xff, 0xff,  //@@@.....@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff,  //@@@....%@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x36, 0xfa, 0xff, 0xff, 0xff, 0xff,  //@@@....@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x06, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@...@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x88, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xff,  //@@@..%@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x34, 0xfa, 0xff, 0xff, 0x78, 0xff, 0xff, 0xff,  //@@@..@@@+@@@
    0xff, 0xff, 0xff, 0x06, 0xd4, 0xff, 0xff, 0xdc, 0x06, 0xff, 0xff, 0xff,  //@@@.@@@@.@@@
    0xff, 0xff, 0xff, 0x84, 0xff, 0xff, 0xff, 0x4e, 0x00, 0xff, 0xff, 0xff,  //@@@%@@@+.@@@
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xba, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@%..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x2a, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@...@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@%...@@@
    0xff, 0xff, 0xff, 0xff, 0xea, 0x0e, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@....@@@
    0xff, 0xff, 0xff, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@+....@@@
    0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+043a (к) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xff, 0x92, 0x00,  //@@@...+@@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x3a, 0xf8, 0xff, 0xff, 0xb6, 0x02, 0x00,  //@@@...@@@%..
    0xff, 0xff, 0xff, 0x00, 0x20, 0xea, 0xff, 0xff, 0xd2, 0x0c, 0x00, 0x00,  //@@@..@@@@...
    0xff, 0xff, 0xff, 0x0e, 0xd6, 0xff, 0xff, 0xe8, 0x20, 0x00, 0x00, 0x00,  //@@@.@@@@....
    0xff, 0xff, 0xff, 0xba, 0xff, 0xff, 0xf6, 0x38, 0x00, 0x00, 0x00, 0x00,  //@@@%@@@.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x24, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@.....
    0xff, 0xff, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@....
    0xff, 0xff, 0xff, 0xc0, 0x34, 0xfa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00,  //@@@%.@@@+...
    0xff, 0xff, 0xff, 0x12, 0x00, 0x82, 0xff, 0xff, 0xf2, 0x1e, 0x00, 0x00,  //@@@..%@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x06, 0xd4, 0xff, 0xff, 0xb6, 0x00, 0x00,  //@@@...@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x38, 0xfc, 0xff, 0xff, 0x5e, 0x00,  //@@@....@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xec, 0x16,  //@@@....%@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x08, 0xdc, 0xff, 0xff, 0xaa,  //@@@.....@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+043b (л) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@....@@@
    0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@....@@@
    0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@....@@@
    0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xec, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@....@@@
    0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //....@@@....@@@
    0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...+@@%....@@@
    0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...+@@%....@@@
    0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...%@@+....@@@
    0x00, 0x00, 0x30, 0xf8, 0xff, 0xf0, 0x08, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@.....@@@
    0x1c, 0x6e, 0xee, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.+@@@+.....@@@
    0xff, 0xff, 0xff, 0xfa, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@+......@@@
    0xea, 0xc2, 0x80, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@+........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+043c (м) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@%...%@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x06, 0x00, 0x06, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@...@@@@@@
    0xff, 0xff, 0xff, 0xde, 0xff, 0xff, 0x58, 0x00, 0x5a, 0xff, 0xff, 0xdc, 0xff, 0xff, 0xff,  //@@@@@@+.+@@@@@@
    0xff, 0xff, 0xff, 0x7a, 0xff, 0xff, 0xbe, 0x00, 0xbe, 0xff, 0xff, 0x7a, 0xff, 0xff, 0xff,  //@@@+@@%.%@@+@@@
    0xff, 0xff, 0xff, 0x1a, 0xfa, 0xff, 0xfc, 0x46, 0xff, 0xff, 0xfa, 0x18, 0xff, 0xff, 0xff,  //@@@.@@@+@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0xb0, 0xff, 0xff, 0xec, 0xff, 0xff, 0xb0, 0x00, 0xff, 0xff, 0xff,  //@@@.%@@@@@%.@@@
    0xff, 0xff, 0xff, 0x00, 0x4c, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4c, 0x00, 0xff, 0xff, 0xff,  //@@@.+@@@@@+.@@@
    0xff, 0xff, 0xff, 0x00, 0x02, 0xe4, 0xff, 0xff, 0xff, 0xe2, 0x02, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..%@@@%..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x20, 0xfc, 0xff, 0xfc, 0x1e, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xb8, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...%@%...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+043d (н) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+043e (о) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x02, 0x60, 0xb8, 0xe8, 0xf8, 0xe8, 0xb8, 0x5e, 0x02, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x12, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //..@@@@@@@@@..
    0x00, 0xbc, 0xff, 0xff, 0xba, 0x2c, 0x06, 0x2e, 0xbe, 0xff, 0xff, 0xba, 0x00,  //.%@@%...%@@%.
    0x4e, 0xff, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //+@@@.....@@@+
    0xaa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //%@@+.....+@@%
    0xe0, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xde,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@.......@@@
    0xe0, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xde,  //@@@.......@@@
    0xaa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //%@@+.....+@@%
    0x50, 0xff, 0xff, 0xd8, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //+@@@.....@@@+
    0x00, 0xbe, 0xff, 0xff, 0xb8, 0x2a, 0x04, 0x2c, 0xbc, 0xff, 0xff, 0xba, 0x00,  //.%@@%...%@@%.
    0x00, 0x12, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //..@@@@@@@@@..
    0x00, 0x00, 0x02, 0x60, 0xba, 0xea, 0xfa, 0xea, 0xba, 0x5e, 0x02, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+043f (п) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0440 (р) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0x00, 0x18, 0x94, 0xe0, 0xf6, 0xda, 0x8a, 0x0e, 0x00, 0x00,  //@@@..%@@@%...
    0xff, 0xff, 0xff, 0x1c, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x1e, 0x00,  //@@@.@@@@@@@..
    0xff, 0xff, 0xff, 0xb2, 0xb8, 0x2c, 0x06, 0x2c, 0xb8, 0xff, 0xff, 0xc8, 0x02,  //@@@%%...%@@@.
    0xff, 0xff, 0xff, 0xd2, 0x06, 0x00, 0x00, 0x00, 0x06, 0xd2, 0xff, 0xff, 0x54,  //@@@@.....@@@+
    0xff, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xac,  //@@@+.....+@@%
    0xff, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf6,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf6,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xac,  //@@@+.....+@@%
    0xff, 0xff, 0xff, 0xd2, 0x06, 0x00, 0x00, 0x00, 0x06, 0xd2, 0xff, 0xff, 0x54,  //@@@@.....@@@+
    0xff, 0xff, 0xff, 0xb2, 0xb8, 0x2a, 0x04, 0x2a, 0xb8, 0xff, 0xff, 0xcc, 0x02,  //@@@%%...%@@@.
    0xff, 0xff, 0xff, 0x1c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x20, 0x00,  //@@@.@@@@@@@..
    0xff, 0xff, 0xff, 0x00, 0x1a, 0x96, 0xe2, 0xf8, 0xdc, 0x8a, 0x10, 0x00, 0x00,  //@@@..%@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0441 (с) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x3e, 0xa2, 0xdc, 0xf4, 0xf6, 0xd8, 0x9a, 0x38,  //....%@@@@%.
    0x00, 0x06, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@
    0x00, 0xa2, 0xff, 0xff, 0xe2, 0x5c, 0x14, 0x04, 0x1c, 0x5a, 0xc0,  //.%@@@+...+%
    0x40, 0xff, 0xff, 0xea, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.......
    0xa2, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.......
    0xde, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xf6, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xf6, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xdc, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xa2, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.......
    0x3e, 0xff, 0xff, 0xea, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.......
    0x00, 0xa0, 0xff, 0xff, 0xe2, 0x5c, 0x14, 0x02, 0x1c, 0x5a, 0xc0,  //.%@@@+...+%
    0x00, 0x06, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@
    0x00, 0x00, 0x00, 0x42, 0xa6, 0xe0, 0xf8, 0xf4, 0xd6, 0x98, 0x38,  //...+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0442 (т) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0443 (у) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xca, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xc6,  //@@@+......+@@@
    0x60, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xe4, 0xff, 0xff, 0x58,  //+@@@......@@@+
    0x08, 0xee, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xe4, 0x04,  //.@@@+....+@@@.
    0x00, 0x8e, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0x7a, 0x00,  //.%@@%....@@@+.
    0x00, 0x26, 0xff, 0xff, 0xfa, 0x1a, 0x00, 0x00, 0x34, 0xff, 0xff, 0xf6, 0x14, 0x00,  //..@@@....@@@..
    0x00, 0x00, 0xbc, 0xff, 0xff, 0x7e, 0x00, 0x00, 0xa4, 0xff, 0xff, 0x9c, 0x00, 0x00,  //..%@@+..%@@%..
    0x00, 0x00, 0x52, 0xff, 0xff, 0xe2, 0x02, 0x18, 0xf8, 0xff, 0xff, 0x2e, 0x00, 0x00,  //..+@@@..@@@...
    0x00, 0x00, 0x02, 0xe4, 0xff, 0xff, 0x50, 0x80, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,  //...@@@++@@%...
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xbe, 0xe8, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00,  //...+@@%@@@+...
    0x00, 0x00, 0x00, 0x1a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xde, 0x02, 0x00, 0x00, 0x00,  //....@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00,  //....%@@@@+....
    0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xff, 0xf4, 0x0e, 0x00, 0x00, 0x00, 0x00,  //....+@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x1c, 0xfa, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@......
    0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@%......
    0x00, 0x00, 0x00, 0x12, 0xf0, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@+......
    0x00, 0x00, 0x10, 0xb4, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@.......
    0x00, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@........
    0x00, 0xff, 0xff, 0xec, 0xb8, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0444 (ф) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x38, 0xbe, 0xf4, 0xe2, 0x7c, 0x00, 0xff, 0xff, 0xff, 0x00, 0x7c, 0xe2, 0xf4, 0xbe, 0x38, 0x00, 0x00,  //...%@@+.@@@.+@@%...
    0x00, 0x46, 0xfa, 0xff, 0xff, 0xff, 0xff, 0x88, 0xff, 0xff, 0xff, 0x88, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x46, 0x00,  //.+@@@@@%@@@%@@@@@+.
    0x0e, 0xe8, 0xff, 0xfc, 0x6c, 0x0a, 0x44, 0xec, 0xff, 0xff, 0xff, 0xec, 0x44, 0x0a, 0x6e, 0xfc, 0xff, 0xe6, 0x0c,  //.@@@+.+@@@@@+.+@@@.
    0x6c, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x6a,  //+@@%...+@@@+...%@@+
    0xb8, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xb6,  //%@@.....@@@.....@@%
    0xe4, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xe2,  //@@@.....@@@.....@@@
    0xf8, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf6,  //@@@.....@@@.....@@@
    0xf8, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf6,  //@@@.....@@@.....@@@
    0xe6, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xe6,  //@@@.....@@@.....@@@
    0xbc, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xbc,  //%@@.....@@@.....@@%
    0x74, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0x74,  //+@@%...+@@@+...%@@+
    0x12, 0xec, 0xff, 0xfc, 0x6a, 0x0a, 0x44, 0xec, 0xff, 0xff, 0xff, 0xec, 0x44, 0x0a, 0x6c, 0xfc, 0xff, 0xec, 0x12,  //.@@@+.+@@@@@+.+@@@.
    0x00, 0x50, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x82, 0xff, 0xff, 0xff, 0x84, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x50, 0x00,  //.+@@@@@%@@@%@@@@@+.
    0x00, 0x00, 0x3e, 0xc2, 0xf4, 0xe2, 0x78, 0x00, 0xff, 0xff, 0xff, 0x00, 0x78, 0xe2, 0xf4, 0xc2, 0x3e, 0x00, 0x00,  //...@@@+.@@@.+@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0445 (х) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x96, 0xff, 0xff, 0xfa, 0x46, 0x00, 0x00, 0x00, 0x00, 0x44, 0xfa, 0xff, 0xff, 0x96,  //%@@@+....+@@@%
    0x04, 0xc0, 0xff, 0xff, 0xee, 0x24, 0x00, 0x00, 0x22, 0xec, 0xff, 0xff, 0xc2, 0x04,  //.%@@@....@@@@.
    0x00, 0x14, 0xe0, 0xff, 0xff, 0xd6, 0x0e, 0x0c, 0xd4, 0xff, 0xff, 0xe0, 0x14, 0x00,  //..@@@@..@@@@..
    0x00, 0x00, 0x30, 0xf4, 0xff, 0xff, 0xb4, 0xae, 0xff, 0xff, 0xf4, 0x32, 0x00, 0x00,  //...@@@%%@@@...
    0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x58, 0x00, 0x00, 0x00,  //...+@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00,  //....%@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0xbe, 0x02, 0x00, 0x00, 0x00, 0x00,  //.....@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x34, 0xf8, 0xff, 0xff, 0xe6, 0x18, 0x00, 0x00, 0x00, 0x00,  //.....@@@@.....
    0x00, 0x00, 0x00, 0x0e, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x02, 0x00, 0x00, 0x00,  //....@@@@@%....
    0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0xf0, 0xfa, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00,  //...%@@@@@@%...
    0x00, 0x00, 0x68, 0xff, 0xff, 0xff, 0x50, 0x74, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x00,  //..+@@@++@@@+..
    0x00, 0x2e, 0xf6, 0xff, 0xff, 0x92, 0x00, 0x00, 0xb0, 0xff, 0xff, 0xee, 0x22, 0x00,  //..@@@%..%@@@..
    0x0a, 0xd6, 0xff, 0xff, 0xce, 0x06, 0x00, 0x00, 0x10, 0xde, 0xff, 0xff, 0xce, 0x06,  //.@@@@....@@@@.
    0xa0, 0xff, 0xff, 0xf2, 0x24, 0x00, 0x00, 0x00, 0x00, 0x32, 0xf8, 0xff, 0xff, 0x9c,  //%@@@......@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0446 (ц) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@......@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0447 (ч) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@
    0xfc, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@
    0xea, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@
    0xb0, 0xff, 0xff, 0xbc, 0x1c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //%@@%....@@@
    0x32, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@
    0x00, 0x32, 0xb6, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0448 (ш) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@.....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0449 (щ) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@.....@@@.....@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //...................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //...................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //...................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //...................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+044a (ъ) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@........
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xdc, 0x9e, 0x26, 0x00,  //....@@@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x36,  //....@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0x24, 0xb2, 0xff, 0xff, 0xbe,  //....@@@....%@@%
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xf2,  //....@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xf2,  //....@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0x24, 0xb2, 0xff, 0xff, 0xb6,  //....@@@....%@@%
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x2c,  //....@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf2, 0xd0, 0x8a, 0x1a, 0x00,  //....@@@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+044b (ы) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xdc, 0x9e, 0x26, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@%....@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x36, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0x24, 0xb2, 0xff, 0xff, 0xbe, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....%@@%..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xf2, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xf2, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.....@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0x24, 0xb2, 0xff, 0xff, 0xb6, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....%@@%..@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x2a, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@@@...@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf2, 0xd0, 0x8a, 0x18, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@@@%....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+044c (ь) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xdc, 0x9e, 0x26, 0x00,  //@@@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x36,  //@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0x24, 0xb2, 0xff, 0xff, 0xbe,  //@@@....%@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xf2,  //@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xf2,  //@@@.....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0x24, 0xb2, 0xff, 0xff, 0xb6,  //@@@....%@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x2a,  //@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf2, 0xd0, 0x8a, 0x18, 0x00,  //@@@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+044d (э) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x2e, 0x8e, 0xce, 0xee, 0xf4, 0xdc, 0xa0, 0x3a, 0x00, 0x00, 0x00,  //.%@@@@%....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9a, 0x04, 0x00,  //@@@@@@@@%..
    0xca, 0x64, 0x28, 0x08, 0x10, 0x50, 0xd8, 0xff, 0xff, 0x9a, 0x00,  //@+...+@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xec, 0xff, 0xff, 0x38,  //.......@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0x9e,  //.......+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xda,  //........@@@
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //..@@@@@@@@@
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //..@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xfa, 0xff, 0xdc,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xff, 0xff, 0xa2,  //........@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xc4, 0xff, 0xff, 0x3e,  //.......@@@.
    0xca, 0x62, 0x26, 0x08, 0x1a, 0x54, 0xd0, 0xff, 0xff, 0xa2, 0x00,  //@+...+@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa8, 0x08, 0x00,  //@@@@@@@@%..
    0x30, 0x92, 0xce, 0xec, 0xf8, 0xe2, 0xaa, 0x46, 0x00, 0x00, 0x00,  //.%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+044e (ю) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x14, 0x7e, 0xc8, 0xee, 0xf8, 0xe8, 0xb6, 0x5c, 0x00, 0x00, 0x00,  //@@@.....+@@@@%+...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x36, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x10, 0x00,  //@@@....@@@@@@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x16, 0xea, 0xff, 0xff, 0xba, 0x2c, 0x06, 0x2e, 0xbe, 0xff, 0xff, 0xb8, 0x00,  //@@@...@@@%...%@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x94, 0xff, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4a,  //@@@..%@@@.....@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0xe4, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //@@@..@@@+.....+@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xde,  //@@@@@@@@.......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@@@@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0xf2, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@..@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0xd4, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xde,  //@@@..@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x96, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //@@@..%@@+.....+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x34, 0xff, 0xff, 0xd8, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //@@@...@@@.....@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0xb8, 0x2a, 0x04, 0x2c, 0xbc, 0xff, 0xff, 0xba, 0x00,  //@@@...%@@%...%@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x0a, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //@@@....%@@@@@@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xb8, 0xea, 0xfa, 0xea, 0xba, 0x5e, 0x02, 0x00, 0x00,  //@@@.....+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+044f (я) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x1a, 0x8c, 0xd0, 0xf0, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff,  //...%@@@@@@@@
    0x00, 0x2c, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@@
    0x00, 0xb6, 0xff, 0xff, 0xb4, 0x28, 0x02, 0x00, 0x00, 0xff, 0xff, 0xff,  //.%@@%....@@@
    0x00, 0xf2, 0xff, 0xff, 0x18, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@.....@@@
    0x00, 0xec, 0xff, 0xff, 0x18, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@.....@@@
    0x00, 0xba, 0xff, 0xff, 0xb4, 0x26, 0x02, 0x00, 0x00, 0xff, 0xff, 0xff,  //.%@@%....@@@
    0x00, 0x2c, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@@
    0x00, 0x00, 0x18, 0x8a, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...%@@@@@@@@
    0x00, 0x00, 0x00, 0x1a, 0xec, 0xff, 0xff, 0xa6, 0x00, 0xff, 0xff, 0xff,  //....@@@%.@@@
    0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0xde, 0x0e, 0x00, 0xff, 0xff, 0xff,  //...%@@@..@@@
    0x00, 0x00, 0x7a, 0xff, 0xff, 0xfa, 0x38, 0x00, 0x00, 0xff, 0xff, 0xff,  //..+@@@...@@@
    0x00, 0x36, 0xfa, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@+...@@@
    0x0c, 0xdc, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@%....@@@
    0xa2, 0xff, 0xff, 0xec, 0x1c, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //%@@@.....@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............



#endif
};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t lv_font_dejavu_30_cyrillic_glyph_dsc[] = {
#if USE_LV_FONT_DEJAVU_30_CYRILLIC == 1
    {.w_px = 17,  .glyph_index = 0},  /*Unicode: U+0410 (А)*/
    {.w_px = 13,  .glyph_index = 90}, /*Unicode: U+0411 (Б)*/
    {.w_px = 13,  .glyph_index = 150},    /*Unicode: U+0412 (В)*/
    {.w_px = 12,  .glyph_index = 210},    /*Unicode: U+0413 (Г)*/
    {.w_px = 18,  .glyph_index = 270},    /*Unicode: U+0414 (Д)*/
    {.w_px = 12,  .glyph_index = 360},    /*Unicode: U+0415 (Е)*/
    {.w_px = 27,  .glyph_index = 420},    /*Unicode: U+0416 (Ж)*/
    {.w_px = 13,  .glyph_index = 540},    /*Unicode: U+0417 (З)*/
    {.w_px = 14,  .glyph_index = 600},    /*Unicode: U+0418 (И)*/
    {.w_px = 14,  .glyph_index = 660},    /*Unicode: U+0419 (Й)*/
    {.w_px = 15,  .glyph_index = 720},    /*Unicode: U+041a (К)*/
    {.w_px = 16,  .glyph_index = 780},    /*Unicode: U+041b (Л)*/
    {.w_px = 17,  .glyph_index = 840},    /*Unicode: U+041c (М)*/
    {.w_px = 14,  .glyph_index = 930},    /*Unicode: U+041d (Н)*/
    {.w_px = 18,  .glyph_index = 990},    /*Unicode: U+041e (О)*/
    {.w_px = 14,  .glyph_index = 1080},   /*Unicode: U+041f (П)*/
    {.w_px = 12,  .glyph_index = 1140},   /*Unicode: U+0420 (Р)*/
    {.w_px = 15,  .glyph_index = 1200},   /*Unicode: U+0421 (С)*/
    {.w_px = 17,  .glyph_index = 1260},   /*Unicode: U+0422 (Т)*/
    {.w_px = 15,  .glyph_index = 1350},   /*Unicode: U+0423 (У)*/
    {.w_px = 19,  .glyph_index = 1410},   /*Unicode: U+0424 (Ф)*/
    {.w_px = 16,  .glyph_index = 1500},   /*Unicode: U+0425 (Х)*/
    {.w_px = 16,  .glyph_index = 1560},   /*Unicode: U+0426 (Ц)*/
    {.w_px = 13,  .glyph_index = 1620},   /*Unicode: U+0427 (Ч)*/
    {.w_px = 23,  .glyph_index = 1680},   /*Unicode: U+0428 (Ш)*/
    {.w_px = 25,  .glyph_index = 1770},   /*Unicode: U+0429 (Щ)*/
    {.w_px = 18,  .glyph_index = 1890},   /*Unicode: U+042a (Ъ)*/
    {.w_px = 18,  .glyph_index = 1980},   /*Unicode: U+042b (Ы)*/
    {.w_px = 13,  .glyph_index = 2070},   /*Unicode: U+042c (Ь)*/
    {.w_px = 15,  .glyph_index = 2130},   /*Unicode: U+042d (Э)*/
    {.w_px = 24,  .glyph_index = 2190},   /*Unicode: U+042e (Ю)*/
    {.w_px = 14,  .glyph_index = 2280},   /*Unicode: U+042f (Я)*/
    {.w_px = 12,  .glyph_index = 2340},   /*Unicode: U+0430 (а)*/
    {.w_px = 14,  .glyph_index = 2400},   /*Unicode: U+0431 (б)*/
    {.w_px = 11,  .glyph_index = 2460},   /*Unicode: U+0432 (в)*/
    {.w_px = 11,  .glyph_index = 2520},   /*Unicode: U+0433 (г)*/
    {.w_px = 15,  .glyph_index = 2580},   /*Unicode: U+0434 (д)*/
    {.w_px = 13,  .glyph_index = 2640},   /*Unicode: U+0435 (е)*/
    {.w_px = 21,  .glyph_index = 2700},   /*Unicode: U+0436 (ж)*/
    {.w_px = 11,  .glyph_index = 2790},   /*Unicode: U+0437 (з)*/
    {.w_px = 12,  .glyph_index = 2850},   /*Unicode: U+0438 (и)*/
    {.w_px = 12,  .glyph_index = 2910},   /*Unicode: U+0439 (й)*/
    {.w_px = 12,  .glyph_index = 2970},   /*Unicode: U+043a (к)*/
    {.w_px = 14,  .glyph_index = 3030},   /*Unicode: U+043b (л)*/
    {.w_px = 15,  .glyph_index = 3090},   /*Unicode: U+043c (м)*/
    {.w_px = 12,  .glyph_index = 3150},   /*Unicode: U+043d (н)*/
    {.w_px = 13,  .glyph_index = 3210},   /*Unicode: U+043e (о)*/
    {.w_px = 12,  .glyph_index = 3270},   /*Unicode: U+043f (п)*/
    {.w_px = 13,  .glyph_index = 3330},   /*Unicode: U+0440 (р)*/
    {.w_px = 11,  .glyph_index = 3390},   /*Unicode: U+0441 (с)*/
    {.w_px = 15,  .glyph_index = 3450},   /*Unicode: U+0442 (т)*/
    {.w_px = 14,  .glyph_index = 3510},   /*Unicode: U+0443 (у)*/
    {.w_px = 19,  .glyph_index = 3570},   /*Unicode: U+0444 (ф)*/
    {.w_px = 14,  .glyph_index = 3660},   /*Unicode: U+0445 (х)*/
    {.w_px = 14,  .glyph_index = 3720},   /*Unicode: U+0446 (ц)*/
    {.w_px = 11,  .glyph_index = 3780},   /*Unicode: U+0447 (ч)*/
    {.w_px = 19,  .glyph_index = 3840},   /*Unicode: U+0448 (ш)*/
    {.w_px = 21,  .glyph_index = 3930},   /*Unicode: U+0449 (щ)*/
    {.w_px = 15,  .glyph_index = 4020},   /*Unicode: U+044a (ъ)*/
    {.w_px = 16,  .glyph_index = 4080},   /*Unicode: U+044b (ы)*/
    {.w_px = 11,  .glyph_index = 4140},   /*Unicode: U+044c (ь)*/
    {.w_px = 11,  .glyph_index = 4200},   /*Unicode: U+044d (э)*/
    {.w_px = 18,  .glyph_index = 4260},   /*Unicode: U+044e (ю)*/
    {.w_px = 12,  .glyph_index = 4350},   /*Unicode: U+044f (я)*/

#elif USE_LV_FONT_DEJAVU_30_CYRILLIC == 2
    {.w_px = 17,  .glyph_index = 0},  /*Unicode: U+0410 (А)*/
    {.w_px = 13,  .glyph_index = 150},    /*Unicode: U+0411 (Б)*/
    {.w_px = 13,  .glyph_index = 270},    /*Unicode: U+0412 (В)*/
    {.w_px = 12,  .glyph_index = 390},    /*Unicode: U+0413 (Г)*/
    {.w_px = 18,  .glyph_index = 480},    /*Unicode: U+0414 (Д)*/
    {.w_px = 12,  .glyph_index = 630},    /*Unicode: U+0415 (Е)*/
    {.w_px = 27,  .glyph_index = 720},    /*Unicode: U+0416 (Ж)*/
    {.w_px = 13,  .glyph_index = 930},    /*Unicode: U+0417 (З)*/
    {.w_px = 14,  .glyph_index = 1050},   /*Unicode: U+0418 (И)*/
    {.w_px = 14,  .glyph_index = 1170},   /*Unicode: U+0419 (Й)*/
    {.w_px = 15,  .glyph_index = 1290},   /*Unicode: U+041a (К)*/
    {.w_px = 16,  .glyph_index = 1410},   /*Unicode: U+041b (Л)*/
    {.w_px = 17,  .glyph_index = 1530},   /*Unicode: U+041c (М)*/
    {.w_px = 14,  .glyph_index = 1680},   /*Unicode: U+041d (Н)*/
    {.w_px = 18,  .glyph_index = 1800},   /*Unicode: U+041e (О)*/
    {.w_px = 14,  .glyph_index = 1950},   /*Unicode: U+041f (П)*/
    {.w_px = 12,  .glyph_index = 2070},   /*Unicode: U+0420 (Р)*/
    {.w_px = 15,  .glyph_index = 2160},   /*Unicode: U+0421 (С)*/
    {.w_px = 17,  .glyph_index = 2280},   /*Unicode: U+0422 (Т)*/
    {.w_px = 15,  .glyph_index = 2430},   /*Unicode: U+0423 (У)*/
    {.w_px = 19,  .glyph_index = 2550},   /*Unicode: U+0424 (Ф)*/
    {.w_px = 16,  .glyph_index = 2700},   /*Unicode: U+0425 (Х)*/
    {.w_px = 16,  .glyph_index = 2820},   /*Unicode: U+0426 (Ц)*/
    {.w_px = 13,  .glyph_index = 2940},   /*Unicode: U+0427 (Ч)*/
    {.w_px = 23,  .glyph_index = 3060},   /*Unicode: U+0428 (Ш)*/
    {.w_px = 25,  .glyph_index = 3240},   /*Unicode: U+0429 (Щ)*/
    {.w_px = 18,  .glyph_index = 3450},   /*Unicode: U+042a (Ъ)*/
    {.w_px = 18,  .glyph_index = 3600},   /*Unicode: U+042b (Ы)*/
    {.w_px = 13,  .glyph_index = 3750},   /*Unicode: U+042c (Ь)*/
    {.w_px = 15,  .glyph_index = 3870},   /*Unicode: U+042d (Э)*/
    {.w_px = 24,  .glyph_index = 3990},   /*Unicode: U+042e (Ю)*/
    {.w_px = 14,  .glyph_index = 4170},   /*Unicode: U+042f (Я)*/
    {.w_px = 12,  .glyph_index = 4290},   /*Unicode: U+0430 (а)*/
    {.w_px = 14,  .glyph_index = 4380},   /*Unicode: U+0431 (б)*/
    {.w_px = 11,  .glyph_index = 4500},   /*Unicode: U+0432 (в)*/
    {.w_px = 11,  .glyph_index = 4590},   /*Unicode: U+0433 (г)*/
    {.w_px = 15,  .glyph_index = 4680},   /*Unicode: U+0434 (д)*/
    {.w_px = 13,  .glyph_index = 4800},   /*Unicode: U+0435 (е)*/
    {.w_px = 21,  .glyph_index = 4920},   /*Unicode: U+0436 (ж)*/
    {.w_px = 11,  .glyph_index = 5100},   /*Unicode: U+0437 (з)*/
    {.w_px = 12,  .glyph_index = 5190},   /*Unicode: U+0438 (и)*/
    {.w_px = 12,  .glyph_index = 5280},   /*Unicode: U+0439 (й)*/
    {.w_px = 12,  .glyph_index = 5370},   /*Unicode: U+043a (к)*/
    {.w_px = 14,  .glyph_index = 5460},   /*Unicode: U+043b (л)*/
    {.w_px = 15,  .glyph_index = 5580},   /*Unicode: U+043c (м)*/
    {.w_px = 12,  .glyph_index = 5700},   /*Unicode: U+043d (н)*/
    {.w_px = 13,  .glyph_index = 5790},   /*Unicode: U+043e (о)*/
    {.w_px = 12,  .glyph_index = 5910},   /*Unicode: U+043f (п)*/
    {.w_px = 13,  .glyph_index = 6000},   /*Unicode: U+0440 (р)*/
    {.w_px = 11,  .glyph_index = 6120},   /*Unicode: U+0441 (с)*/
    {.w_px = 15,  .glyph_index = 6210},   /*Unicode: U+0442 (т)*/
    {.w_px = 14,  .glyph_index = 6330},   /*Unicode: U+0443 (у)*/
    {.w_px = 19,  .glyph_index = 6450},   /*Unicode: U+0444 (ф)*/
    {.w_px = 14,  .glyph_index = 6600},   /*Unicode: U+0445 (х)*/
    {.w_px = 14,  .glyph_index = 6720},   /*Unicode: U+0446 (ц)*/
    {.w_px = 11,  .glyph_index = 6840},   /*Unicode: U+0447 (ч)*/
    {.w_px = 19,  .glyph_index = 6930},   /*Unicode: U+0448 (ш)*/
    {.w_px = 21,  .glyph_index = 7080},   /*Unicode: U+0449 (щ)*/
    {.w_px = 15,  .glyph_index = 7260},   /*Unicode: U+044a (ъ)*/
    {.w_px = 16,  .glyph_index = 7380},   /*Unicode: U+044b (ы)*/
    {.w_px = 11,  .glyph_index = 7500},   /*Unicode: U+044c (ь)*/
    {.w_px = 11,  .glyph_index = 7590},   /*Unicode: U+044d (э)*/
    {.w_px = 18,  .glyph_index = 7680},   /*Unicode: U+044e (ю)*/
    {.w_px = 12,  .glyph_index = 7830},   /*Unicode: U+044f (я)*/

#elif USE_LV_FONT_DEJAVU_30_CYRILLIC == 4
    {.w_px = 17,  .glyph_index = 0},  /*Unicode: U+0410 (А)*/
    {.w_px = 13,  .glyph_index = 270},    /*Unicode: U+0411 (Б)*/
    {.w_px = 13,  .glyph_index = 480},    /*Unicode: U+0412 (В)*/
    {.w_px = 12,  .glyph_index = 690},    /*Unicode: U+0413 (Г)*/
    {.w_px = 18,  .glyph_index = 870},    /*Unicode: U+0414 (Д)*/
    {.w_px = 12,  .glyph_index = 1140},   /*Unicode: U+0415 (Е)*/
    {.w_px = 27,  .glyph_index = 1320},   /*Unicode: U+0416 (Ж)*/
    {.w_px = 13,  .glyph_index = 1740},   /*Unicode: U+0417 (З)*/
    {.w_px = 14,  .glyph_index = 1950},   /*Unicode: U+0418 (И)*/
    {.w_px = 14,  .glyph_index = 2160},   /*Unicode: U+0419 (Й)*/
    {.w_px = 15,  .glyph_index = 2370},   /*Unicode: U+041a (К)*/
    {.w_px = 16,  .glyph_index = 2610},   /*Unicode: U+041b (Л)*/
    {.w_px = 17,  .glyph_index = 2850},   /*Unicode: U+041c (М)*/
    {.w_px = 14,  .glyph_index = 3120},   /*Unicode: U+041d (Н)*/
    {.w_px = 18,  .glyph_index = 3330},   /*Unicode: U+041e (О)*/
    {.w_px = 14,  .glyph_index = 3600},   /*Unicode: U+041f (П)*/
    {.w_px = 12,  .glyph_index = 3810},   /*Unicode: U+0420 (Р)*/
    {.w_px = 15,  .glyph_index = 3990},   /*Unicode: U+0421 (С)*/
    {.w_px = 17,  .glyph_index = 4230},   /*Unicode: U+0422 (Т)*/
    {.w_px = 15,  .glyph_index = 4500},   /*Unicode: U+0423 (У)*/
    {.w_px = 19,  .glyph_index = 4740},   /*Unicode: U+0424 (Ф)*/
    {.w_px = 16,  .glyph_index = 5040},   /*Unicode: U+0425 (Х)*/
    {.w_px = 16,  .glyph_index = 5280},   /*Unicode: U+0426 (Ц)*/
    {.w_px = 13,  .glyph_index = 5520},   /*Unicode: U+0427 (Ч)*/
    {.w_px = 23,  .glyph_index = 5730},   /*Unicode: U+0428 (Ш)*/
    {.w_px = 25,  .glyph_index = 6090},   /*Unicode: U+0429 (Щ)*/
    {.w_px = 18,  .glyph_index = 6480},   /*Unicode: U+042a (Ъ)*/
    {.w_px = 18,  .glyph_index = 6750},   /*Unicode: U+042b (Ы)*/
    {.w_px = 13,  .glyph_index = 7020},   /*Unicode: U+042c (Ь)*/
    {.w_px = 15,  .glyph_index = 7230},   /*Unicode: U+042d (Э)*/
    {.w_px = 24,  .glyph_index = 7470},   /*Unicode: U+042e (Ю)*/
    {.w_px = 14,  .glyph_index = 7830},   /*Unicode: U+042f (Я)*/
    {.w_px = 12,  .glyph_index = 8040},   /*Unicode: U+0430 (а)*/
    {.w_px = 14,  .glyph_index = 8220},   /*Unicode: U+0431 (б)*/
    {.w_px = 11,  .glyph_index = 8430},   /*Unicode: U+0432 (в)*/
    {.w_px = 11,  .glyph_index = 8610},   /*Unicode: U+0433 (г)*/
    {.w_px = 15,  .glyph_index = 8790},   /*Unicode: U+0434 (д)*/
    {.w_px = 13,  .glyph_index = 9030},   /*Unicode: U+0435 (е)*/
    {.w_px = 21,  .glyph_index = 9240},   /*Unicode: U+0436 (ж)*/
    {.w_px = 11,  .glyph_index = 9570},   /*Unicode: U+0437 (з)*/
    {.w_px = 12,  .glyph_index = 9750},   /*Unicode: U+0438 (и)*/
    {.w_px = 12,  .glyph_index = 9930},   /*Unicode: U+0439 (й)*/
    {.w_px = 12,  .glyph_index = 10110},  /*Unicode: U+043a (к)*/
    {.w_px = 14,  .glyph_index = 10290},  /*Unicode: U+043b (л)*/
    {.w_px = 15,  .glyph_index = 10500},  /*Unicode: U+043c (м)*/
    {.w_px = 12,  .glyph_index = 10740},  /*Unicode: U+043d (н)*/
    {.w_px = 13,  .glyph_index = 10920},  /*Unicode: U+043e (о)*/
    {.w_px = 12,  .glyph_index = 11130},  /*Unicode: U+043f (п)*/
    {.w_px = 13,  .glyph_index = 11310},  /*Unicode: U+0440 (р)*/
    {.w_px = 11,  .glyph_index = 11520},  /*Unicode: U+0441 (с)*/
    {.w_px = 15,  .glyph_index = 11700},  /*Unicode: U+0442 (т)*/
    {.w_px = 14,  .glyph_index = 11940},  /*Unicode: U+0443 (у)*/
    {.w_px = 19,  .glyph_index = 12150},  /*Unicode: U+0444 (ф)*/
    {.w_px = 14,  .glyph_index = 12450},  /*Unicode: U+0445 (х)*/
    {.w_px = 14,  .glyph_index = 12660},  /*Unicode: U+0446 (ц)*/
    {.w_px = 11,  .glyph_index = 12870},  /*Unicode: U+0447 (ч)*/
    {.w_px = 19,  .glyph_index = 13050},  /*Unicode: U+0448 (ш)*/
    {.w_px = 21,  .glyph_index = 13350},  /*Unicode: U+0449 (щ)*/
    {.w_px = 15,  .glyph_index = 13680},  /*Unicode: U+044a (ъ)*/
    {.w_px = 16,  .glyph_index = 13920},  /*Unicode: U+044b (ы)*/
    {.w_px = 11,  .glyph_index = 14160},  /*Unicode: U+044c (ь)*/
    {.w_px = 11,  .glyph_index = 14340},  /*Unicode: U+044d (э)*/
    {.w_px = 18,  .glyph_index = 14520},  /*Unicode: U+044e (ю)*/
    {.w_px = 12,  .glyph_index = 14790},  /*Unicode: U+044f (я)*/

#elif USE_LV_FONT_DEJAVU_30_CYRILLIC == 8
    {.w_px = 17,  .glyph_index = 0},  /*Unicode: U+0410 (А)*/
    {.w_px = 13,  .glyph_index = 510},    /*Unicode: U+0411 (Б)*/
    {.w_px = 13,  .glyph_index = 900},    /*Unicode: U+0412 (В)*/
    {.w_px = 12,  .glyph_index = 1290},   /*Unicode: U+0413 (Г)*/
    {.w_px = 18,  .glyph_index = 1650},   /*Unicode: U+0414 (Д)*/
    {.w_px = 12,  .glyph_index = 2190},   /*Unicode: U+0415 (Е)*/
    {.w_px = 27,  .glyph_index = 2550},   /*Unicode: U+0416 (Ж)*/
    {.w_px = 13,  .glyph_index = 3360},   /*Unicode: U+0417 (З)*/
    {.w_px = 14,  .glyph_index = 3750},   /*Unicode: U+0418 (И)*/
    {.w_px = 14,  .glyph_index = 4170},   /*Unicode: U+0419 (Й)*/
    {.w_px = 15,  .glyph_index = 4590},   /*Unicode: U+041a (К)*/
    {.w_px = 16,  .glyph_index = 5040},   /*Unicode: U+041b (Л)*/
    {.w_px = 17,  .glyph_index = 5520},   /*Unicode: U+041c (М)*/
    {.w_px = 14,  .glyph_index = 6030},   /*Unicode: U+041d (Н)*/
    {.w_px = 18,  .glyph_index = 6450},   /*Unicode: U+041e (О)*/
    {.w_px = 14,  .glyph_index = 6990},   /*Unicode: U+041f (П)*/
    {.w_px = 12,  .glyph_index = 7410},   /*Unicode: U+0420 (Р)*/
    {.w_px = 15,  .glyph_index = 7770},   /*Unicode: U+0421 (С)*/
    {.w_px = 17,  .glyph_index = 8220},   /*Unicode: U+0422 (Т)*/
    {.w_px = 15,  .glyph_index = 8730},   /*Unicode: U+0423 (У)*/
    {.w_px = 19,  .glyph_index = 9180},   /*Unicode: U+0424 (Ф)*/
    {.w_px = 16,  .glyph_index = 9750},   /*Unicode: U+0425 (Х)*/
    {.w_px = 16,  .glyph_index = 10230},  /*Unicode: U+0426 (Ц)*/
    {.w_px = 13,  .glyph_index = 10710},  /*Unicode: U+0427 (Ч)*/
    {.w_px = 23,  .glyph_index = 11100},  /*Unicode: U+0428 (Ш)*/
    {.w_px = 25,  .glyph_index = 11790},  /*Unicode: U+0429 (Щ)*/
    {.w_px = 18,  .glyph_index = 12540},  /*Unicode: U+042a (Ъ)*/
    {.w_px = 18,  .glyph_index = 13080},  /*Unicode: U+042b (Ы)*/
    {.w_px = 13,  .glyph_index = 13620},  /*Unicode: U+042c (Ь)*/
    {.w_px = 15,  .glyph_index = 14010},  /*Unicode: U+042d (Э)*/
    {.w_px = 24,  .glyph_index = 14460},  /*Unicode: U+042e (Ю)*/
    {.w_px = 14,  .glyph_index = 15180},  /*Unicode: U+042f (Я)*/
    {.w_px = 12,  .glyph_index = 15600},  /*Unicode: U+0430 (а)*/
    {.w_px = 14,  .glyph_index = 15960},  /*Unicode: U+0431 (б)*/
    {.w_px = 11,  .glyph_index = 16380},  /*Unicode: U+0432 (в)*/
    {.w_px = 11,  .glyph_index = 16710},  /*Unicode: U+0433 (г)*/
    {.w_px = 15,  .glyph_index = 17040},  /*Unicode: U+0434 (д)*/
    {.w_px = 13,  .glyph_index = 17490},  /*Unicode: U+0435 (е)*/
    {.w_px = 21,  .glyph_index = 17880},  /*Unicode: U+0436 (ж)*/
    {.w_px = 11,  .glyph_index = 18510},  /*Unicode: U+0437 (з)*/
    {.w_px = 12,  .glyph_index = 18840},  /*Unicode: U+0438 (и)*/
    {.w_px = 12,  .glyph_index = 19200},  /*Unicode: U+0439 (й)*/
    {.w_px = 12,  .glyph_index = 19560},  /*Unicode: U+043a (к)*/
    {.w_px = 14,  .glyph_index = 19920},  /*Unicode: U+043b (л)*/
    {.w_px = 15,  .glyph_index = 20340},  /*Unicode: U+043c (м)*/
    {.w_px = 12,  .glyph_index = 20790},  /*Unicode: U+043d (н)*/
    {.w_px = 13,  .glyph_index = 21150},  /*Unicode: U+043e (о)*/
    {.w_px = 12,  .glyph_index = 21540},  /*Unicode: U+043f (п)*/
    {.w_px = 13,  .glyph_index = 21900},  /*Unicode: U+0440 (р)*/
    {.w_px = 11,  .glyph_index = 22290},  /*Unicode: U+0441 (с)*/
    {.w_px = 15,  .glyph_index = 22620},  /*Unicode: U+0442 (т)*/
    {.w_px = 14,  .glyph_index = 23070},  /*Unicode: U+0443 (у)*/
    {.w_px = 19,  .glyph_index = 23490},  /*Unicode: U+0444 (ф)*/
    {.w_px = 14,  .glyph_index = 24060},  /*Unicode: U+0445 (х)*/
    {.w_px = 14,  .glyph_index = 24480},  /*Unicode: U+0446 (ц)*/
    {.w_px = 11,  .glyph_index = 24900},  /*Unicode: U+0447 (ч)*/
    {.w_px = 19,  .glyph_index = 25230},  /*Unicode: U+0448 (ш)*/
    {.w_px = 21,  .glyph_index = 25800},  /*Unicode: U+0449 (щ)*/
    {.w_px = 15,  .glyph_index = 26430},  /*Unicode: U+044a (ъ)*/
    {.w_px = 16,  .glyph_index = 26880},  /*Unicode: U+044b (ы)*/
    {.w_px = 11,  .glyph_index = 27360},  /*Unicode: U+044c (ь)*/
    {.w_px = 11,  .glyph_index = 27690},  /*Unicode: U+044d (э)*/
    {.w_px = 18,  .glyph_index = 28020},  /*Unicode: U+044e (ю)*/
    {.w_px = 12,  .glyph_index = 28560},  /*Unicode: U+044f (я)*/

#endif
};

lv_font_t lv_font_dejavu_30_cyrillic = {
    .unicode_first = 1040,  /*First Unicode letter in this font*/
    .unicode_last = 1103,   /*Last Unicode letter in this font*/
    .h_px = 30,             /*Font height in pixels*/
    .glyph_bitmap = lv_font_dejavu_30_cyrillic_glyph_bitmap,    /*Bitmap of glyphs*/
    .glyph_dsc = lv_font_dejavu_30_cyrillic_glyph_dsc,      /*Description of glyphs*/
    .glyph_cnt = 64,            /*Number of glyphs in the font*/
    .unicode_list = NULL,   /*Every character in the font from 'unicode_first' to 'unicode_last'*/
    .get_bitmap = lv_font_get_bitmap_continuous,    /*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,  /*Function pointer to get glyph's width*/
#if USE_LV_FONT_DEJAVU_30_CYRILLIC == 1
    .bpp = 1,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_30_CYRILLIC == 2
    .bpp = 2,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_30_CYRILLIC == 4
    .bpp = 4,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_30_CYRILLIC == 8
    .bpp = 8,               /*Bit per pixel*/
#endif
    .monospace = 0,
    .next_page = NULL,      /*Pointer to a font extension*/
};

#endif /*USE_LV_FONT_DEJAVU_30_CYRILLIC*/
