
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_DEJAVU_30 != 0  /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * DejaVuSans.ttf 30 px Font in U+0020 ( ) .. U+007e (~)  range with 1 bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_dejavu_30_glyph_bitmap[] = {
#if USE_LV_FONT_DEJAVU_30 == 1
    /*Unicode: U+0020 ( ) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0021 (!) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //%@%
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0022 (") , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0xc6,  //@@...@@
    0xc6,  //@@...@@
    0xc6,  //@@...@@
    0xc6,  //@@...@@
    0xc6,  //@@...@@
    0xc6,  //@@...@@
    0xc6,  //@@...@@
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+0023 (#) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x01, 0x86, 0x00,  //.......%@+...@@...
    0x01, 0x86, 0x00,  //.......@@....@@...
    0x01, 0x86, 0x00,  //.......@@...+@%...
    0x03, 0x8c, 0x00,  //......+@%...%@+...
    0x03, 0x0c, 0x00,  //......@@+...@@....
    0x7f, 0xff, 0xc0,  //.%@@@@@@@@@@@@@@@@
    0x7f, 0xff, 0xc0,  //.%@@@@@@@@@@@@@@@@
    0x07, 0x18, 0x00,  //.....%@%...%@+....
    0x06, 0x18, 0x00,  //.....@@+...@@.....
    0x06, 0x18, 0x00,  //.....@@....@@.....
    0x06, 0x18, 0x00,  //....+@%...+@%.....
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%.
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%.
    0x0c, 0x30, 0x00,  //....@@....@@......
    0x0c, 0x70, 0x00,  //...+@%...%@%......
    0x18, 0x60, 0x00,  //...%@+...@@+......
    0x18, 0x60, 0x00,  //...@@....@@.......
    0x18, 0x60, 0x00,  //...@@...+@%.......
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0024 ($) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x04, 0x00,  //.....@......
    0x04, 0x00,  //.....@......
    0x04, 0x00,  //.....@......
    0x1f, 0x80,  //..+%@@@@%+..
    0x7f, 0xe0,  //.%@@@@@@@@@.
    0x74, 0x60,  //+@@@.@..+%@.
    0xe4, 0x00,  //@@@..@......
    0xe4, 0x00,  //@@@..@......
    0xe4, 0x00,  //@@@+.@......
    0xfc, 0x00,  //%@@@%@......
    0x7f, 0x00,  //.@@@@@@@+...
    0x3f, 0xc0,  //..@@@@@@@@+.
    0x07, 0xe0,  //....+@@@@@@+
    0x04, 0xf0,  //.....@.+@@@%
    0x04, 0x70,  //.....@...@@@
    0x04, 0x70,  //.....@...@@@
    0x04, 0x70,  //.....@..+@@@
    0x84, 0xe0,  //@+...@.+@@@+
    0xff, 0xc0,  //@@@@@@@@@@+.
    0x3f, 0x80,  //.+%@@@@@%...
    0x04, 0x00,  //.....@......
    0x04, 0x00,  //.....@......
    0x04, 0x00,  //.....@......
    0x04, 0x00,  //.....@......
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0025 (%) , Width: 22 */
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x3e, 0x01, 0xc0,  //..%@@@%........%@%....
    0x7f, 0x01, 0x80,  //.@@@@@@@......+@@.....
    0x63, 0x03, 0x00,  //+@@...@@+.....@@+.....
    0xc1, 0x87, 0x00,  //@@+...+@@....%@@......
    0xc1, 0x86, 0x00,  //@@.....@@....@@.......
    0xc1, 0x8e, 0x00,  //@@.....@@...%@%.......
    0xc1, 0x8c, 0x00,  //@@+...+@@..+@@........
    0xe3, 0x18, 0x00,  //+@@...@@+..@@+........
    0x7f, 0x38, 0x00,  //.@@@@@@@..%@@.........
    0x3e, 0x31, 0xf0,  //..%@@@%...@@...%@@@%..
    0x00, 0x73, 0xf8,  //.........@@%..@@@@@@@.
    0x00, 0x63, 0x18,  //........+@@..+@@...@@+
    0x00, 0xc6, 0x0c,  //........@@+..@@+...+@@
    0x01, 0xc6, 0x0c,  //.......%@%...@@.....@@
    0x01, 0x86, 0x0c,  //.......@@....@@.....@@
    0x03, 0x86, 0x0c,  //......@@%....@@+...+@@
    0x03, 0x07, 0x18,  //.....+@@.....+@@...@@+
    0x06, 0x03, 0xf8,  //.....@@+......@@@@@@@.
    0x0e, 0x01, 0xf0,  //....%@%........%@@@%..
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00,  //......................


    /*Unicode: U+0026 (&) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x07, 0xc0, 0x00,  //....+@@@@%........
    0x1f, 0xe0, 0x00,  //...@@@@@@@@.......
    0x3c, 0x20, 0x00,  //..%@@@...+@.......
    0x38, 0x00, 0x00,  //..@@@.............
    0x38, 0x00, 0x00,  //..@@@.............
    0x38, 0x00, 0x00,  //..@@@.............
    0x3c, 0x00, 0x00,  //..@@@@............
    0x3e, 0x00, 0x00,  //..%@@@%...........
    0x3f, 0x00, 0x00,  //..@@@@@%..........
    0x7f, 0x03, 0x80,  //.%@@%@@@+.....@@@.
    0x67, 0x83, 0x80,  //.@@..%@@@+....@@%.
    0xe3, 0xc3, 0x00,  //%@%...%@@@...+@@..
    0xe1, 0xe7, 0x00,  //@@@....%@@@..@@%..
    0xe0, 0xfe, 0x00,  //@@@.....%@@@%@@...
    0xe0, 0x7c, 0x00,  //@@@+.....%@@@@+...
    0x70, 0x3c, 0x00,  //+@@@......@@@@....
    0x78, 0x7e, 0x00,  //.@@@@+..+@@@@@@...
    0x3f, 0xef, 0x00,  //..@@@@@@@@@.%@@@+.
    0x0f, 0x87, 0x80,  //...+%@@@%+...%@@@+
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0027 (') , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+0028 (() , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x0c,  //....@@
    0x18,  //...@@+
    0x18,  //..+@@.
    0x30,  //..@@+.
    0x30,  //.+@@..
    0x70,  //.@@@..
    0x70,  //.@@%..
    0x60,  //+@@+..
    0xe0,  //%@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //%@@...
    0x60,  //+@@+..
    0x70,  //.@@%..
    0x70,  //.@@@..
    0x30,  //.+@@..
    0x30,  //..@@+.
    0x18,  //..+@@.
    0x18,  //...@@+
    0x0c,  //....@@
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+0029 ()) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0xc0,  //@@....
    0x60,  //+@@...
    0x60,  //.@@+..
    0x30,  //.+@@..
    0x30,  //..@@+.
    0x38,  //..@@@.
    0x38,  //..%@@.
    0x18,  //..+@@+
    0x1c,  //...@@%
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@%
    0x18,  //..+@@+
    0x38,  //..%@@.
    0x38,  //..@@@.
    0x30,  //..@@+.
    0x30,  //.+@@..
    0x60,  //.@@+..
    0x60,  //+@@...
    0xc0,  //@@....
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+002a (*) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x04, 0x00,  //.....@.....
    0x04, 0x00,  //.....@.....
    0x84, 0x20,  //%+...@...+%
    0xe4, 0xe0,  //%@@..@..@@%
    0x3f, 0x80,  //..@@%@%@@..
    0x0e, 0x00,  //...+@@@+...
    0x0e, 0x00,  //...+@@@+...
    0x3f, 0x80,  //..@@%@%@@..
    0xe4, 0xe0,  //%@@..@..@@%
    0xc4, 0x60,  //%+...@...+%
    0x04, 0x00,  //.....@.....
    0x04, 0x00,  //.....@.....
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+002b (+) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x01, 0x80,  //.......@@.......
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+002c (,) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x70,  //.@@@
    0x70,  //.@@@
    0x70,  //.@@@
    0x60,  //+@@+
    0xe0,  //%@@.
    0xc0,  //@@..
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+002d (-) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0xfe,  //@@@@@@@
    0xfe,  //@@@@@@@
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+002e (.) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+002f (/) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x01, 0x80,  //......+@@
    0x03, 0x80,  //......%@+
    0x03, 0x00,  //......@@.
    0x03, 0x00,  //......@@.
    0x07, 0x00,  //.....%@%.
    0x06, 0x00,  //.....@@..
    0x06, 0x00,  //.....@@..
    0x0e, 0x00,  //....%@%..
    0x0c, 0x00,  //....@@...
    0x0c, 0x00,  //....@@...
    0x1c, 0x00,  //...%@%...
    0x18, 0x00,  //...@@....
    0x18, 0x00,  //...@@....
    0x38, 0x00,  //..%@%....
    0x30, 0x00,  //..@@.....
    0x30, 0x00,  //..@@.....
    0x70, 0x00,  //.%@%.....
    0x60, 0x00,  //.@@......
    0x60, 0x00,  //.@@......
    0xe0, 0x00,  //+@%......
    0xc0, 0x00,  //@@+......
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0030 (0) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //....%@@@%....
    0x1f, 0xc0,  //..+@@@@@@@+..
    0x38, 0xe0,  //.+@@@...@@@+.
    0x70, 0x70,  //.@@@.....@@@.
    0x70, 0x70,  //+@@%.....%@@+
    0xe0, 0x38,  //%@@+.....+@@%
    0xe0, 0x38,  //@@@.......@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@%
    0xe0, 0x38,  //%@@+.....+@@%
    0x70, 0x70,  //+@@%.....%@@+
    0x70, 0x70,  //.@@@.....@@@.
    0x38, 0xe0,  //.+@@@...@@@+.
    0x1f, 0xc0,  //..+@@@@@@@+..
    0x0f, 0x80,  //....%@@@%....
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0031 (1) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x1f, 0x00,  //.++%@@@@....
    0xff, 0x00,  //@@@@@@@@....
    0xc7, 0x00,  //@%++.@@@....
    0x07, 0x00,  //.....@@@....
    0x07, 0x00,  //.....@@@....
    0x07, 0x00,  //.....@@@....
    0x07, 0x00,  //.....@@@....
    0x07, 0x00,  //.....@@@....
    0x07, 0x00,  //.....@@@....
    0x07, 0x00,  //.....@@@....
    0x07, 0x00,  //.....@@@....
    0x07, 0x00,  //.....@@@....
    0x07, 0x00,  //.....@@@....
    0x07, 0x00,  //.....@@@....
    0x07, 0x00,  //.....@@@....
    0x07, 0x00,  //.....@@@....
    0x07, 0x00,  //.....@@@....
    0x7f, 0xf0,  //.@@@@@@@@@@@
    0x7f, 0xf0,  //.@@@@@@@@@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0032 (2) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x3f, 0x00,  //.+%@@@@@+....
    0xff, 0xc0,  //@@@@@@@@@@+..
    0xe1, 0xe0,  //@@%+...%@@@..
    0x80, 0xf0,  //%.......%@@%.
    0x00, 0x70,  //.........@@@.
    0x00, 0x70,  //.........@@@.
    0x00, 0x70,  //.........@@@.
    0x00, 0xf0,  //........%@@%.
    0x00, 0xe0,  //........@@@..
    0x01, 0xe0,  //.......@@@%..
    0x03, 0xc0,  //......@@@@...
    0x07, 0x80,  //.....@@@@....
    0x0f, 0x00,  //....%@@@.....
    0x1e, 0x00,  //...%@@@+.....
    0x3c, 0x00,  //..%@@@+......
    0x78, 0x00,  //.%@@@+.......
    0xf8, 0x00,  //%@@@%........
    0xff, 0xf0,  //@@@@@@@@@@@@.
    0xff, 0xf0,  //@@@@@@@@@@@@.
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0033 (3) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x3f, 0x00,  //..+%@@@%+...
    0x7f, 0xc0,  //.@@@@@@@@%..
    0x41, 0xc0,  //.@+...+@@@+.
    0x00, 0xe0,  //.......+@@@.
    0x00, 0xe0,  //........@@@.
    0x00, 0xe0,  //........@@@.
    0x00, 0xe0,  //.......+@@%.
    0x01, 0xc0,  //......+@@@..
    0x1f, 0x00,  //...@@@@@+...
    0x1f, 0x80,  //...@@@@@%+..
    0x01, 0xe0,  //.......%@@%.
    0x00, 0xf0,  //........%@@+
    0x00, 0x70,  //.........@@@
    0x00, 0x70,  //.........@@@
    0x00, 0x70,  //.........@@@
    0x00, 0xf0,  //........%@@%
    0x81, 0xe0,  //@+....+%@@@.
    0xff, 0xc0,  //@@@@@@@@@@..
    0x3f, 0x00,  //.+%@@@@%+...
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0034 (4) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x01, 0xe0,  //.......%@@@...
    0x01, 0xe0,  //.......@@@@...
    0x03, 0xe0,  //......@@@@@...
    0x07, 0xe0,  //.....%@%@@@...
    0x06, 0xe0,  //.....@@.@@@...
    0x0c, 0xe0,  //....@@+.@@@...
    0x1c, 0xe0,  //...%@%..@@@...
    0x18, 0xe0,  //...@@...@@@...
    0x30, 0xe0,  //..@@+...@@@...
    0x70, 0xe0,  //.%@%....@@@...
    0x60, 0xe0,  //.@@.....@@@...
    0xc0, 0xe0,  //@@+.....@@@...
    0xff, 0xfc,  //@@@@@@@@@@@@@@
    0xff, 0xfc,  //@@@@@@@@@@@@@@
    0x00, 0xe0,  //........@@@...
    0x00, 0xe0,  //........@@@...
    0x00, 0xe0,  //........@@@...
    0x00, 0xe0,  //........@@@...
    0x00, 0xe0,  //........@@@...
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0035 (5) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x7f, 0xe0,  //.@@@@@@@@@@.
    0x7f, 0xe0,  //.@@@@@@@@@@.
    0x70, 0x00,  //.@@@........
    0x70, 0x00,  //.@@@........
    0x70, 0x00,  //.@@@........
    0x70, 0x00,  //.@@@........
    0x7f, 0x80,  //.@@@@@@@%...
    0x7f, 0xc0,  //.@@@@@@@@@..
    0x41, 0xe0,  //.@+...+@@@@.
    0x00, 0xe0,  //........@@@+
    0x00, 0x70,  //........+@@%
    0x00, 0x70,  //.........@@@
    0x00, 0x70,  //.........@@@
    0x00, 0x70,  //.........@@@
    0x00, 0x70,  //........+@@%
    0x00, 0xe0,  //........@@@+
    0x81, 0xe0,  //@+....+@@@@.
    0xff, 0xc0,  //@@@@@@@@@%..
    0x3f, 0x00,  //.+%@@@@%+...
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0036 (6) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x07, 0xe0,  //.....%@@@@%..
    0x1f, 0xf0,  //...%@@@@@@@@.
    0x3c, 0x10,  //..%@@@+...+@.
    0x38, 0x00,  //.+@@%........
    0x70, 0x00,  //.@@@.........
    0x70, 0x00,  //+@@%.........
    0xe0, 0x00,  //%@@+.........
    0xe7, 0xc0,  //@@@..%@@@%...
    0xef, 0xe0,  //@@@+@@@@@@@+.
    0xf8, 0xf0,  //@@@@%...%@@@.
    0xf0, 0x78,  //@@@%.....%@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //%@@.......@@@
    0xe0, 0x38,  //%@@.......@@@
    0x60, 0x38,  //+@@.......@@@
    0x70, 0x78,  //.@@%.....%@@%
    0x38, 0xf0,  //.+@@%...%@@@.
    0x1f, 0xe0,  //..+@@@@@@@@..
    0x0f, 0x80,  //....%@@@@+...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0037 (7) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0x00, 0xf0,  //........%@@%
    0x00, 0xe0,  //........@@@.
    0x00, 0xe0,  //.......+@@@.
    0x01, 0xe0,  //.......%@@%.
    0x01, 0xc0,  //.......@@@..
    0x01, 0xc0,  //.......@@@..
    0x03, 0xc0,  //......%@@%..
    0x03, 0x80,  //......@@@+..
    0x03, 0x80,  //......@@@...
    0x07, 0x80,  //.....%@@%...
    0x07, 0x00,  //.....@@@+...
    0x07, 0x00,  //.....@@@....
    0x0f, 0x00,  //....%@@%....
    0x0e, 0x00,  //....@@@+....
    0x0e, 0x00,  //....@@@.....
    0x1e, 0x00,  //...%@@%.....
    0x1c, 0x00,  //...@@@+.....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0038 (8) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x1f, 0xc0,  //...%@@@@@%...
    0x3f, 0xe0,  //.+@@@@@@@@@+.
    0x70, 0x70,  //+@@@+...+@@@+
    0xe0, 0x38,  //@@@+.....+@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //%@@+.....+@@%
    0x70, 0x70,  //.@@@+...+@@%.
    0x1f, 0xc0,  //..+@@@@@@@+..
    0x3f, 0xe0,  //..%@@@@@@@%..
    0x78, 0xf0,  //.@@@%...%@@@.
    0xf0, 0x78,  //%@@%.....%@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xf0, 0x78,  //%@@%.....%@@%
    0x78, 0xf0,  //.@@@%...%@@@.
    0x3f, 0xe0,  //.+@@@@@@@@@+.
    0x1f, 0xc0,  //...%@@@@@%...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0039 (9) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //...+@@@@%....
    0x3f, 0xc0,  //..@@@@@@@@+..
    0x78, 0xe0,  //.@@@%...%@@+.
    0xf0, 0x70,  //%@@%.....%@@.
    0xe0, 0x30,  //@@@.......@@.
    0xe0, 0x38,  //@@@.......@@%
    0xe0, 0x38,  //@@@.......@@%
    0xe0, 0x38,  //@@@.......@@@
    0xf0, 0x78,  //%@@%.....%@@@
    0x78, 0xf8,  //.@@@%...%@@@@
    0x3f, 0xb8,  //.+@@@@@@@+@@@
    0x1f, 0x38,  //...%@@@%..@@@
    0x00, 0x38,  //.........+@@%
    0x00, 0x70,  //.........%@@+
    0x00, 0x70,  //.........@@@.
    0x00, 0xe0,  //........%@@+.
    0x41, 0xe0,  //.@+...+@@@%..
    0x7f, 0xc0,  //.@@@@@@@@%...
    0x3f, 0x00,  //..%@@@@%.....
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+003a (:) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+003b (;) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x70,  //.@@@
    0x70,  //.@@@
    0x70,  //.@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x70,  //.@@@
    0x70,  //.@@@
    0x70,  //.@@@
    0x60,  //+@@+
    0xe0,  //%@@.
    0xc0,  //@@..
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+003c (<) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x01,  //..............+@
    0x00, 0x0f,  //...........+%@@@
    0x00, 0x7e,  //.........%@@@@%+
    0x01, 0xf0,  //......+@@@@@+...
    0x0f, 0xc0,  //...+%@@@@%......
    0x7e, 0x00,  //.%@@@@%+........
    0xf0, 0x00,  //@@@@+...........
    0xf0, 0x00,  //@@@@+...........
    0x7e, 0x00,  //.%@@@@%+........
    0x0f, 0xc0,  //...+%@@@@%......
    0x01, 0xf0,  //......+@@@@@+...
    0x00, 0x7e,  //.........%@@@@%+
    0x00, 0x0f,  //...........+%@@@
    0x00, 0x01,  //..............+@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+003d (=) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+003e (>) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x80, 0x00,  //@+..............
    0xf0, 0x00,  //@@@%+...........
    0x7e, 0x00,  //+%@@@@%.........
    0x0f, 0x80,  //...+@@@@@+......
    0x03, 0xf0,  //......%@@@@%+...
    0x00, 0x7e,  //........+%@@@@%.
    0x00, 0x0f,  //...........+@@@@
    0x00, 0x0f,  //...........+@@@@
    0x00, 0x7e,  //........+%@@@@%.
    0x03, 0xf0,  //......%@@@@%+...
    0x0f, 0x80,  //...+@@@@@+......
    0x7e, 0x00,  //+%@@@@%.........
    0xf0, 0x00,  //@@@%+...........
    0x80, 0x00,  //@+..............
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+003f (?) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x3e, 0x00,  //..%@@@@+..
    0x7f, 0x80,  //+@@@@@@@@.
    0xc3, 0xc0,  //@@+..+@@@%
    0x81, 0xc0,  //%.....+@@@
    0x01, 0xc0,  //.......@@@
    0x01, 0xc0,  //.......@@@
    0x01, 0x80,  //......+@@+
    0x03, 0x00,  //......@@+.
    0x06, 0x00,  //.....@@+..
    0x0e, 0x00,  //....@@%...
    0x1c, 0x00,  //...%@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x1c, 0x00,  //...@@@....
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+0040 (@) , Width: 23 */
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00,  //.......................
    0x00, 0x7e, 0x00,  //........+%@@@@%+.......
    0x03, 0xff, 0xc0,  //......%@@@@@@@@@@%.....
    0x0f, 0x81, 0xe0,  //....+@@@%+....+%@@@+...
    0x1e, 0x00, 0x70,  //...%@@+..........%@@+..
    0x38, 0x00, 0x18,  //..%@@+............+@@..
    0x30, 0x00, 0x0c,  //.+@@...............+@@.
    0x60, 0x79, 0x8c,  //.@@+....+@@@%+.@@...@@+
    0x61, 0xfd, 0x86,  //.@@....%@@@@@@+@@...+@%
    0xc1, 0xc7, 0x86,  //%@+...+@@%...%@@@....@@
    0xc3, 0x83, 0x86,  //@@....%@%.....%@@....@@
    0xc3, 0x01, 0x86,  //@@....@@.......@@....@@
    0xc3, 0x01, 0x86,  //@@....@@.......@@....@@
    0xc3, 0x01, 0x8e,  //@@....@@.......@@...%@%
    0xc3, 0x83, 0x8c,  //@@....%@%.....%@@...@@.
    0xe1, 0xc7, 0x98,  //%@+...+@@%...%@@@.+@@+.
    0x61, 0xfd, 0xf0,  //+@@....%@@@@@@+@@@@@+..
    0x60, 0x79, 0xc0,  //.@@+....+@@@%+.@@%+....
    0x30, 0x00, 0x00,  //.+@@...................
    0x38, 0x00, 0x00,  //..%@@..................
    0x1c, 0x00, 0x40,  //...%@@+..........%+....
    0x0f, 0x81, 0xc0,  //....%@@@%.....+%@@+....
    0x03, 0xff, 0x80,  //.....+@@@@@@@@@@%......
    0x00, 0xfe, 0x00,  //.......+%@@@@@%........
    0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0041 (A) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //......+@@@+......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x07, 0x70, 0x00,  //.....@@@+@@@.....
    0x07, 0x70, 0x00,  //....+@@@.@@@+....
    0x0e, 0x38, 0x00,  //....%@@+.+@@%....
    0x0e, 0x38, 0x00,  //....@@@...@@@....
    0x0e, 0x38, 0x00,  //...+@@%...%@@+...
    0x1c, 0x1c, 0x00,  //...@@@+...+@@@...
    0x1c, 0x1c, 0x00,  //...@@@.....@@@...
    0x3f, 0xfe, 0x00,  //..%@@@@@@@@@@@%..
    0x3f, 0xfe, 0x00,  //..@@@@@@@@@@@@@..
    0x38, 0x0e, 0x00,  //.+@@@.......@@@+.
    0x70, 0x0f, 0x00,  //.%@@+.......+@@%.
    0x70, 0x07, 0x00,  //.@@@.........@@@.
    0x70, 0x07, 0x00,  //+@@%.........@@@+
    0xe0, 0x03, 0x80,  //@@@+.........+@@@
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0042 (B) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0xff, 0x80,  //@@@@@@@@%+...
    0xff, 0xe0,  //@@@@@@@@@@%..
    0xe0, 0xe0,  //@@@....+@@@+.
    0xe0, 0x70,  //@@@.....+@@@.
    0xe0, 0x70,  //@@@......@@@.
    0xe0, 0x70,  //@@@......@@@.
    0xe0, 0x70,  //@@@.....+@@%.
    0xe0, 0xe0,  //@@@....+@@@..
    0xff, 0xc0,  //@@@@@@@@@%...
    0xff, 0xc0,  //@@@@@@@@@@+..
    0xe0, 0xf0,  //@@@.....%@@%.
    0xe0, 0x70,  //@@@......%@@+
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x78,  //@@@......%@@%
    0xe0, 0xf0,  //@@@.....%@@@.
    0xff, 0xe0,  //@@@@@@@@@@@+.
    0xff, 0xc0,  //@@@@@@@@@%...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0043 (C) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x03, 0xf0,  //.....+%@@@@%+..
    0x0f, 0xfc,  //...+@@@@@@@@@@+
    0x1e, 0x0e,  //..+@@@%....+@@@
    0x38, 0x06,  //.+@@@........%@
    0x70, 0x00,  //.@@@+.........+
    0x70, 0x00,  //+@@%...........
    0xe0, 0x00,  //%@@+...........
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //@@@............
    0xe0, 0x00,  //%@@+...........
    0x70, 0x00,  //+@@%...........
    0x70, 0x00,  //.@@@..........+
    0x38, 0x06,  //.+@@@........%@
    0x1e, 0x0e,  //..+@@@%....+@@@
    0x0f, 0xfc,  //...+@@@@@@@@@@+
    0x03, 0xf0,  //.....+%@@@@%+..
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+0044 (D) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xff, 0xc0,  //@@@@@@@@@%+.....
    0xff, 0xf0,  //@@@@@@@@@@@@+...
    0xe0, 0x7c,  //@@@.....+%@@@%..
    0xe0, 0x1c,  //@@@........@@@+.
    0xe0, 0x0e,  //@@@.........@@@.
    0xe0, 0x0e,  //@@@.........%@@+
    0xe0, 0x07,  //@@@.........+@@%
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@..........@@@
    0xe0, 0x07,  //@@@.........+@@%
    0xe0, 0x0e,  //@@@.........%@@+
    0xe0, 0x0e,  //@@@.........@@@.
    0xe0, 0x1c,  //@@@........@@@+.
    0xe0, 0x7c,  //@@@.....+%@@@%..
    0xff, 0xf0,  //@@@@@@@@@@@@+...
    0xff, 0xc0,  //@@@@@@@@@%+.....
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0045 (E) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xff, 0xe0,  //@@@@@@@@@@@.
    0xff, 0xe0,  //@@@@@@@@@@@.
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0046 (F) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xff, 0xe0,  //@@@@@@@@@@@
    0xff, 0xe0,  //@@@@@@@@@@@
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xff, 0xc0,  //@@@@@@@@@@.
    0xff, 0xc0,  //@@@@@@@@@@.
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0047 (G) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x03, 0xf8, 0x00,  //.....+%@@@@@%....
    0x0f, 0xfe, 0x00,  //...+@@@@@@@@@@@+.
    0x1e, 0x0f, 0x00,  //..+@@@%+....%@@@.
    0x38, 0x03, 0x00,  //.+@@@.........%@.
    0x70, 0x01, 0x00,  //.@@@+..........%.
    0x70, 0x00, 0x00,  //+@@%.............
    0xe0, 0x00, 0x00,  //%@@+.............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x00, 0x00,  //@@@..............
    0xe0, 0x3f, 0x80,  //@@@.......@@@@@@@
    0xe0, 0x3f, 0x80,  //@@@.......@@@@@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //%@@+..........@@@
    0x70, 0x03, 0x80,  //+@@%..........@@@
    0x70, 0x03, 0x80,  //.@@@..........@@@
    0x38, 0x03, 0x80,  //..@@@.........@@@
    0x1e, 0x07, 0x80,  //..+@@@%+....+%@@@
    0x0f, 0xff, 0x00,  //....@@@@@@@@@@@@.
    0x03, 0xf8, 0x00,  //.....+%@@@@@%+...
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0048 (H) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xff, 0xfc,  //@@@@@@@@@@@@@@
    0xff, 0xfc,  //@@@@@@@@@@@@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0049 (I) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+004a (J) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //.+@@%
    0x70,  //+@@@.
    0xf0,  //@@@%.
    0xc0,  //@%+..
    0x00,  //.....


    /*Unicode: U+004b (K) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xe0, 0x3c,  //@@@.......@@@+.
    0xe0, 0x78,  //@@@......@@@%..
    0xe0, 0xf0,  //@@@.....@@@%...
    0xe1, 0xe0,  //@@@....@@@%....
    0xe3, 0xc0,  //@@@...@@@%.....
    0xe7, 0x80,  //@@@..@@@%......
    0xef, 0x00,  //@@@.@@@%.......
    0xfe, 0x00,  //@@@@@@%........
    0xfc, 0x00,  //@@@@@%.........
    0xfc, 0x00,  //@@@@@@.........
    0xfe, 0x00,  //@@@@@@@........
    0xef, 0x00,  //@@@+@@@%.......
    0xe7, 0x80,  //@@@.+@@@%......
    0xe3, 0xc0,  //@@@..+@@@%.....
    0xe1, 0xe0,  //@@@...+@@@%....
    0xe0, 0xf0,  //@@@....+@@@%...
    0xe0, 0x78,  //@@@.....+@@@%..
    0xe0, 0x3c,  //@@@......+@@@%.
    0xe0, 0x1e,  //@@@.......+@@@%
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+004c (L) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+004d (M) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xfc, 0x1f, 0x80,  //@@@@@%.....%@@@@@
    0xfc, 0x1f, 0x80,  //@@@@@@.....@@@@@@
    0xfc, 0x1f, 0x80,  //@@@@@@.....@@@@@@
    0xfe, 0x3f, 0x80,  //@@@%@@%...%@@%@@@
    0xee, 0x3b, 0x80,  //@@@.@@@...@@@.@@@
    0xee, 0x3b, 0x80,  //@@@.@@@+.+@@@.@@@
    0xef, 0x7b, 0x80,  //@@@.%@@%.%@@%.@@@
    0xe7, 0x73, 0x80,  //@@@..@@@.@@@..@@@
    0xe7, 0xf3, 0x80,  //@@@..@@@%@@@..@@@
    0xe7, 0xf3, 0x80,  //@@@..%@@@@@%..@@@
    0xe3, 0xe3, 0x80,  //@@@...@@@@@...@@@
    0xe3, 0xe3, 0x80,  //@@@...@@@@@...@@@
    0xe1, 0xc3, 0x80,  //@@@...+@@@+...@@@
    0xe1, 0xc3, 0x80,  //@@@....@@@....@@@
    0xe1, 0xc3, 0x80,  //@@@....@@@....@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0xe0, 0x03, 0x80,  //@@@...........@@@
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+004e (N) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xf0, 0x1c,  //@@@@.......@@@
    0xf8, 0x1c,  //@@@@%......@@@
    0xf8, 0x1c,  //@@@@@......@@@
    0xfc, 0x1c,  //@@@@@%.....@@@
    0xfc, 0x1c,  //@@@@@@.....@@@
    0xfe, 0x1c,  //@@@%@@%....@@@
    0xee, 0x1c,  //@@@.@@@+...@@@
    0xef, 0x1c,  //@@@.%@@@...@@@
    0xe7, 0x1c,  //@@@..@@@+..@@@
    0xe7, 0x9c,  //@@@..%@@@..@@@
    0xe3, 0x9c,  //@@@...@@@+.@@@
    0xe3, 0xdc,  //@@@...%@@@.@@@
    0xe1, 0xdc,  //@@@....@@@+@@@
    0xe1, 0xfc,  //@@@....%@@@@@@
    0xe0, 0xfc,  //@@@.....@@@@@@
    0xe0, 0xfc,  //@@@.....%@@@@@
    0xe0, 0x7c,  //@@@......@@@@@
    0xe0, 0x7c,  //@@@......%@@@@
    0xe0, 0x3c,  //@@@.......@@@@
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+004f (O) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x03, 0xf0, 0x00,  //.....+%@@@@%+.....
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@+...
    0x1e, 0x1e, 0x00,  //..+@@@%....%@@@+..
    0x38, 0x07, 0x00,  //.+@@@........@@@..
    0x70, 0x03, 0x80,  //.@@@+........+@@@.
    0x70, 0x03, 0x80,  //+@@@..........%@@+
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0x70, 0x03, 0x80,  //+@@@..........%@@+
    0x70, 0x03, 0x80,  //.@@@+........+@@@.
    0x38, 0x07, 0x00,  //.+@@@........@@@+.
    0x1e, 0x1e, 0x00,  //..+@@@%....%@@@+..
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@+...
    0x03, 0xf0, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0050 (P) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xff, 0x80,  //@@@@@@@@%...
    0xff, 0xc0,  //@@@@@@@@@@+.
    0xe0, 0xe0,  //@@@....+@@@+
    0xe0, 0xf0,  //@@@.....%@@%
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0xf0,  //@@@.....+@@%
    0xe0, 0xe0,  //@@@....+@@@+
    0xff, 0xc0,  //@@@@@@@@@@+.
    0xff, 0x80,  //@@@@@@@@%...
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0051 (Q) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x03, 0xf0, 0x00,  //.....+%@@@@%+.....
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@+...
    0x1e, 0x1e, 0x00,  //..+@@@%....%@@@+..
    0x38, 0x07, 0x00,  //.+@@@........@@@..
    0x70, 0x03, 0x80,  //.@@@+........+@@@.
    0x70, 0x03, 0x80,  //+@@@..........%@@+
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //@@@............@@@
    0xe0, 0x01, 0xc0,  //%@@+..........+@@%
    0x70, 0x03, 0x80,  //+@@@..........%@@+
    0x70, 0x03, 0x80,  //.@@@+........+@@@.
    0x38, 0x07, 0x00,  //.+@@@........@@@..
    0x1e, 0x1e, 0x00,  //..+@@@%....%@@@+..
    0x0f, 0xfc, 0x00,  //...+@@@@@@@@@@....
    0x03, 0xf8, 0x00,  //.....+%@@@@@@.....
    0x00, 0x1c, 0x00,  //...........@@%....
    0x00, 0x0e, 0x00,  //............@@%...
    0x00, 0x07, 0x00,  //.............@@%..
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0052 (R) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xff, 0x80,  //@@@@@@@@%......
    0xff, 0xe0,  //@@@@@@@@@@%....
    0xe0, 0xe0,  //@@@....+@@@+...
    0xe0, 0x70,  //@@@.....+@@%...
    0xe0, 0x70,  //@@@......@@@...
    0xe0, 0x70,  //@@@......@@@...
    0xe0, 0x70,  //@@@......@@@...
    0xe0, 0x70,  //@@@.....+@@%...
    0xe0, 0xe0,  //@@@....+@@@....
    0xff, 0xc0,  //@@@@@@@@@%.....
    0xff, 0x80,  //@@@@@@@@@+.....
    0xe1, 0xc0,  //@@@...+@@@+....
    0xe0, 0xe0,  //@@@....+@@@....
    0xe0, 0xf0,  //@@@.....%@@%...
    0xe0, 0x70,  //@@@......@@@+..
    0xe0, 0x78,  //@@@......%@@@..
    0xe0, 0x3c,  //@@@.......@@@+.
    0xe0, 0x1c,  //@@@.......+@@@.
    0xe0, 0x1e,  //@@@........@@@%
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+0053 (S) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x1f, 0xc0,  //...%@@@@@%+..
    0x3f, 0xf0,  //.+@@@@@@@@@@.
    0x78, 0x70,  //.@@@%....%@@.
    0xe0, 0x10,  //%@@+.......%.
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xf0, 0x00,  //@@@%.........
    0xfe, 0x00,  //+@@@@%%+.....
    0x7f, 0xc0,  //.%@@@@@@@%+..
    0x1f, 0xf0,  //..+@@@@@@@@+.
    0x03, 0xf0,  //.....+%@@@@@+
    0x00, 0x78,  //.........@@@%
    0x00, 0x38,  //.........+@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x80, 0x78,  //%........%@@%
    0xe0, 0xf0,  //@@%+....%@@@.
    0xff, 0xe0,  //@@@@@@@@@@@+.
    0x3f, 0x80,  //.+%@@@@@%+...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0054 (T) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@@
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0055 (U) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //@@@........@@@
    0xe0, 0x1c,  //%@@+......+@@%
    0x70, 0x38,  //+@@@......@@@+
    0x78, 0x78,  //.%@@%....%@@%.
    0x3f, 0xf0,  //..%@@@@@@@@%..
    0x0f, 0xc0,  //...+%@@@@%+...
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0056 (V) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xe0, 0x03, 0x80,  //@@@+.........+@@@
    0x70, 0x07, 0x00,  //+@@%.........@@@+
    0x70, 0x07, 0x00,  //.@@@.........@@@.
    0x78, 0x0f, 0x00,  //.%@@+.......+@@%.
    0x38, 0x0e, 0x00,  //.+@@@.......@@@+.
    0x38, 0x0e, 0x00,  //..@@@.......@@@..
    0x3c, 0x1e, 0x00,  //..%@@%.....%@@%..
    0x1c, 0x1c, 0x00,  //...@@@.....@@@...
    0x1c, 0x1c, 0x00,  //...@@@+...+@@@...
    0x0e, 0x38, 0x00,  //...+@@%...%@@+...
    0x0e, 0x38, 0x00,  //....@@@...@@@....
    0x0e, 0x38, 0x00,  //....%@@+.+@@%....
    0x07, 0x70, 0x00,  //....+@@@.@@@+....
    0x07, 0x70, 0x00,  //.....@@@+@@@.....
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x01, 0xc0, 0x00,  //......+@@@+......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0057 (W) , Width: 24 */
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0xe0, 0x3c, 0x07,  //@@@.......%@@%.......@@@
    0xe0, 0x3c, 0x07,  //%@@+......@@@@......+@@%
    0x70, 0x3c, 0x0e,  //+@@%......@@@@......%@@+
    0x70, 0x3c, 0x0e,  //.@@@.....+@@%@+.....@@@.
    0x70, 0x76, 0x0e,  //.@@@.....%@%+@%.....@@@.
    0x70, 0x66, 0x0e,  //.%@@+....@@+.@@....+@@%.
    0x38, 0x66, 0x1c,  //.+@@%....@@..@@....%@@+.
    0x38, 0x66, 0x1c,  //..@@@...+@@..@@+...@@@..
    0x38, 0xe7, 0x1c,  //..@@@...%@%..%@%...@@@..
    0x38, 0xc3, 0x1c,  //..%@@+..%@+..+@@..+@@%..
    0x1c, 0xc3, 0x38,  //..+@@%..@@....@@..%@@+..
    0x1c, 0xc3, 0x38,  //...@@@..@@....@@..@@@...
    0x1c, 0xc3, 0x38,  //...@@@.+@%....%@+.@@@...
    0x1d, 0x81, 0xb8,  //...%@@+%@+....+@%+@@%...
    0x0f, 0x81, 0xf0,  //...+@@%@@......@@%@@+...
    0x0f, 0x81, 0xf0,  //....@@@@@......@@@@@....
    0x0f, 0x81, 0xf0,  //....@@@@%......%@@@@....
    0x0f, 0x00, 0xf0,  //....%@@@+......+@@@%....
    0x07, 0x00, 0xe0,  //....+@@@........@@@+....
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00,  //........................


    /*Unicode: U+0058 (X) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x78, 0x0f,  //.%@@@.......@@@%
    0x3c, 0x1e,  //..@@@+.....%@@@.
    0x1c, 0x1c,  //..+@@@.....@@@+.
    0x1e, 0x3c,  //...@@@%...@@@%..
    0x0e, 0x78,  //...+@@@+.%@@@...
    0x0f, 0x70,  //....%@@@.@@@+...
    0x07, 0xf0,  //.....@@@@@@%....
    0x03, 0xe0,  //.....+@@@@@.....
    0x03, 0xc0,  //......@@@@+.....
    0x03, 0xc0,  //......@@@@+.....
    0x03, 0xe0,  //.....+@@@@@.....
    0x07, 0xe0,  //.....@@@@@@+....
    0x0f, 0x70,  //....%@@@+@@@....
    0x0e, 0x78,  //...+@@@..@@@%...
    0x1e, 0x38,  //...@@@%...@@@+..
    0x3c, 0x3c,  //..%@@@....%@@@..
    0x38, 0x1c,  //.+@@@......@@@+.
    0x78, 0x0e,  //.@@@%......+@@@.
    0xf0, 0x0f,  //%@@@........@@@%
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0059 (Y) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xf0, 0x07, 0x80,  //%@@@.........@@@%
    0x78, 0x0f, 0x00,  //.@@@%.......%@@@.
    0x38, 0x0e, 0x00,  //..@@@+.....+@@@..
    0x3c, 0x1e, 0x00,  //..%@@@.....@@@%..
    0x1e, 0x3c, 0x00,  //...@@@@...@@@@...
    0x0f, 0x78, 0x00,  //....@@@%.%@@@....
    0x07, 0x70, 0x00,  //....+@@@+@@@+....
    0x07, 0xf0, 0x00,  //.....%@@@@@%.....
    0x03, 0xe0, 0x00,  //......@@@@@......
    0x01, 0xc0, 0x00,  //......+@@@+......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x01, 0xc0, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+005a (Z) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0x00, 0x1e,  //...........@@@%
    0x00, 0x3c,  //..........@@@@.
    0x00, 0x78,  //.........%@@@..
    0x00, 0x70,  //........+@@@+..
    0x00, 0xf0,  //........@@@%...
    0x01, 0xe0,  //.......@@@@....
    0x03, 0xc0,  //......%@@@.....
    0x03, 0x80,  //.....+@@@+.....
    0x07, 0x80,  //.....@@@%......
    0x0f, 0x00,  //....@@@@.......
    0x1e, 0x00,  //...%@@@........
    0x1c, 0x00,  //..+@@@+........
    0x3c, 0x00,  //..@@@%.........
    0x78, 0x00,  //.@@@@..........
    0xf0, 0x00,  //%@@@...........
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0xff, 0xfe,  //@@@@@@@@@@@@@@@
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+005b ([) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0xfc,  //@@@@@@
    0xfc,  //@@@@@@
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xe0,  //@@@...
    0xfc,  //@@@@@@
    0xfc,  //@@@@@@
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+005c (\) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xc0, 0x00,  //@@+......
    0xe0, 0x00,  //+@%......
    0x60, 0x00,  //.@@......
    0x60, 0x00,  //.@@......
    0x70, 0x00,  //.%@%.....
    0x30, 0x00,  //..@@.....
    0x30, 0x00,  //..@@.....
    0x38, 0x00,  //..%@%....
    0x18, 0x00,  //...@@....
    0x18, 0x00,  //...@@....
    0x1c, 0x00,  //...%@%...
    0x0c, 0x00,  //....@@...
    0x0c, 0x00,  //....@@...
    0x0e, 0x00,  //....%@%..
    0x06, 0x00,  //.....@@..
    0x06, 0x00,  //.....@@..
    0x07, 0x00,  //.....%@%.
    0x03, 0x00,  //......@@.
    0x03, 0x00,  //......@@.
    0x03, 0x80,  //......%@+
    0x01, 0x80,  //......+@@
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+005d (]) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0xfc,  //@@@@@@
    0xfc,  //@@@@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0x1c,  //...@@@
    0xfc,  //@@@@@@
    0xfc,  //@@@@@@
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+005e (^) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x03, 0xc0,  //......%@@%......
    0x07, 0xe0,  //.....%@@@@%.....
    0x0e, 0x70,  //....%@@++@@%....
    0x1c, 0x38,  //...%@@+..+@@%...
    0x38, 0x1c,  //..%@@+....+@@%..
    0x70, 0x0e,  //.%@@........@@%.
    0xe0, 0x07,  //%@@..........@@%
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+005f (_) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xff, 0xf8,  //@@@@@@@@@@@@@


    /*Unicode: U+0060 (`) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0xe0,  //%@@...
    0x70,  //.%@%..
    0x30,  //..@@..
    0x18,  //...@@.
    0x0c,  //...+@%
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+0061 (a) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x1f, 0x80,  //..+%@@@@%...
    0x7f, 0xc0,  //.@@@@@@@@@+.
    0x40, 0xe0,  //.@+....+@@@.
    0x00, 0x70,  //........+@@%
    0x00, 0x70,  //.........@@@
    0x1f, 0xf0,  //..+%@@@@@@@@
    0x7f, 0xf0,  //.%@@@@@@@@@@
    0xf0, 0x70,  //+@@@+....@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@.....+@@@
    0xe0, 0xf0,  //@@@.....@@@@
    0xf1, 0xf0,  //%@@@...%%@@@
    0x7f, 0x70,  //.@@@@@@@.@@@
    0x3e, 0x70,  //..%@@@%..@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0062 (b) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe7, 0xc0,  //@@@..%@@@%...
    0xef, 0xe0,  //@@@.@@@@@@@..
    0xf8, 0xf0,  //@@@%%...%@@@.
    0xf0, 0x70,  //@@@@.....@@@+
    0xe0, 0x38,  //@@@+.....+@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@+.....+@@%
    0xf0, 0x70,  //@@@@.....@@@+
    0xf8, 0xf0,  //@@@%%...%@@@.
    0xef, 0xe0,  //@@@.@@@@@@@..
    0xe7, 0xc0,  //@@@..%@@@%...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0063 (c) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x0f, 0xc0,  //....%@@@@%.
    0x3f, 0xe0,  //..%@@@@@@@@
    0x78, 0x20,  //.%@@@+...+%
    0x70, 0x00,  //.@@@.......
    0xe0, 0x00,  //%@@+.......
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //%@@+.......
    0x70, 0x00,  //.@@@.......
    0x78, 0x20,  //.%@@@+...+%
    0x3f, 0xe0,  //..%@@@@@@@@
    0x0f, 0xc0,  //...+%@@@@%.
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0064 (d) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x1f, 0x38,  //...%@@@%..@@@
    0x3f, 0xb8,  //..@@@@@@@.@@@
    0x78, 0xf8,  //.@@@%...%%@@@
    0x70, 0x78,  //+@@@.....@@@@
    0xe0, 0x38,  //%@@+.....+@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //%@@+.....+@@@
    0x70, 0x78,  //+@@@.....@@@@
    0x78, 0xf8,  //.@@@%...%%@@@
    0x3f, 0xb8,  //..@@@@@@@.@@@
    0x1f, 0x38,  //...%@@@%..@@@
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0065 (e) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //....%@@@@+...
    0x3f, 0xe0,  //..%@@@@@@@@..
    0x78, 0xf0,  //.%@@@...%@@@.
    0x70, 0x70,  //.@@@.....%@@+
    0xe0, 0x38,  //%@@+......@@%
    0xe0, 0x38,  //@@@.......@@@
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xff, 0xf8,  //@@@@@@@@@@@@@
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //%@@+.........
    0x70, 0x00,  //.@@@.........
    0x78, 0x10,  //.%@@@+....+@.
    0x3f, 0xf0,  //..%@@@@@@@@@.
    0x0f, 0xc0,  //....%@@@@%+..
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0066 (f) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x0f, 0x80,  //....%@@@@
    0x1f, 0x80,  //...@@@@@@
    0x3c, 0x00,  //..%@@%...
    0x38, 0x00,  //..@@@....
    0x38, 0x00,  //..@@@....
    0x38, 0x00,  //..@@@....
    0xff, 0x80,  //@@@@@@@@@
    0xff, 0x80,  //@@@@@@@@@
    0x38, 0x00,  //..@@@....
    0x38, 0x00,  //..@@@....
    0x38, 0x00,  //..@@@....
    0x38, 0x00,  //..@@@....
    0x38, 0x00,  //..@@@....
    0x38, 0x00,  //..@@@....
    0x38, 0x00,  //..@@@....
    0x38, 0x00,  //..@@@....
    0x38, 0x00,  //..@@@....
    0x38, 0x00,  //..@@@....
    0x38, 0x00,  //..@@@....
    0x38, 0x00,  //..@@@....
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0067 (g) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x1f, 0x38,  //...%@@@%..@@@
    0x3f, 0xb8,  //..@@@@@@@.@@@
    0x78, 0xf8,  //.@@@%...%%@@@
    0x70, 0x78,  //+@@@.....@@@@
    0xe0, 0x38,  //%@@+.....+@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //%@@+.....+@@@
    0x70, 0x78,  //+@@@.....@@@@
    0x78, 0xf8,  //.@@@%...%%@@@
    0x3f, 0xb8,  //..@@@@@@@.@@@
    0x1f, 0x38,  //...%@@@%..@@@
    0x00, 0x38,  //.........+@@%
    0x00, 0x70,  //.........%@@+
    0x20, 0xf0,  //..@+....%@@@.
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x1f, 0x80,  //...%@@@@@+...
    0x00, 0x00,  //.............


    /*Unicode: U+0068 (h) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe0, 0x00,  //@@@.........
    0xe7, 0x80,  //@@@..%@@@+..
    0xef, 0xe0,  //@@@.@@@@@@%.
    0xf8, 0xe0,  //@@@%%..+@@@+
    0xf0, 0x70,  //@@@@....+@@%
    0xe0, 0x70,  //@@@+.....@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0069 (i) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+006a (j) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x38,  //..@@@
    0x78,  //.%@@%
    0xf0,  //@@@@.
    0xe0,  //@@%..
    0x00,  //.....


    /*Unicode: U+006b (k) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0xf0,  //@@@.....@@@@+
    0xe1, 0xe0,  //@@@...+@@@@+.
    0xe3, 0xc0,  //@@@..+@@@@...
    0xef, 0x80,  //@@@.%@@@@....
    0xff, 0x00,  //@@@%@@@%.....
    0xfe, 0x00,  //@@@@@@%......
    0xfc, 0x00,  //@@@@@%.......
    0xfc, 0x00,  //@@@@@@+......
    0xfe, 0x00,  //@@@@@@@+.....
    0xef, 0x00,  //@@@.@@@@+....
    0xe7, 0x80,  //@@@..@@@@+...
    0xe3, 0xc0,  //@@@...@@@@+..
    0xe1, 0xe0,  //@@@....%@@@+.
    0xe0, 0xf0,  //@@@.....%@@@+
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+006c (l) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+006d (m) , Width: 21 */
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0xe7, 0x83, 0xc0,  //@@@..%@@@+....%@@@+..
    0xef, 0xc7, 0xf0,  //@@@.@@@@@@+..@@@@@@%.
    0xf8, 0xec, 0x70,  //@@@%%..+@@@.@%..+@@@+
    0xf0, 0x78, 0x38,  //@@@@....+@@@@....+@@%
    0xe0, 0x70, 0x38,  //@@@+.....@@@+.....@@@
    0xe0, 0x70, 0x38,  //@@@......@@@......@@@
    0xe0, 0x70, 0x38,  //@@@......@@@......@@@
    0xe0, 0x70, 0x38,  //@@@......@@@......@@@
    0xe0, 0x70, 0x38,  //@@@......@@@......@@@
    0xe0, 0x70, 0x38,  //@@@......@@@......@@@
    0xe0, 0x70, 0x38,  //@@@......@@@......@@@
    0xe0, 0x70, 0x38,  //@@@......@@@......@@@
    0xe0, 0x70, 0x38,  //@@@......@@@......@@@
    0xe0, 0x70, 0x38,  //@@@......@@@......@@@
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+006e (n) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe7, 0x80,  //@@@..%@@@+..
    0xef, 0xe0,  //@@@.@@@@@@%.
    0xf8, 0xe0,  //@@@%%..+@@@+
    0xf0, 0x70,  //@@@@....+@@%
    0xe0, 0x70,  //@@@+.....@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+006f (o) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //...+%@@@%+...
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x78, 0xf0,  //.%@@%...%@@%.
    0x70, 0x70,  //+@@@.....@@@+
    0xe0, 0x38,  //%@@+.....+@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //%@@+.....+@@%
    0x70, 0x70,  //+@@@.....@@@+
    0x78, 0xf0,  //.%@@%...%@@%.
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x0f, 0x80,  //...+%@@@%+...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+0070 (p) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0xe7, 0xc0,  //@@@..%@@@%...
    0xef, 0xe0,  //@@@.@@@@@@@..
    0xf8, 0xf0,  //@@@%%...%@@@.
    0xf0, 0x70,  //@@@@.....@@@+
    0xe0, 0x38,  //@@@+.....+@@%
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@+.....+@@%
    0xf0, 0x70,  //@@@@.....@@@+
    0xf8, 0xf0,  //@@@%%...%@@@.
    0xef, 0xe0,  //@@@.@@@@@@@..
    0xe7, 0xc0,  //@@@..%@@@%...
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0xe0, 0x00,  //@@@..........
    0x00, 0x00,  //.............


    /*Unicode: U+0071 (q) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x1f, 0x38,  //...%@@@%..@@@
    0x3f, 0xb8,  //..@@@@@@@.@@@
    0x78, 0xf8,  //.@@@%...%%@@@
    0x70, 0x78,  //+@@@.....@@@@
    0xe0, 0x38,  //%@@+.....+@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //@@@.......@@@
    0xe0, 0x38,  //%@@+.....+@@@
    0x70, 0x78,  //+@@@.....@@@@
    0x78, 0xf8,  //.@@@%...%%@@@
    0x3f, 0xb8,  //..@@@@@@@.@@@
    0x1f, 0x38,  //...%@@@%..@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x38,  //..........@@@
    0x00, 0x00,  //.............


    /*Unicode: U+0072 (r) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xe7,  //@@@..%@@
    0xef,  //@@@.@@@@
    0xf8,  //@@@%%...
    0xf0,  //@@@@....
    0xe0,  //@@@+....
    0xe0,  //@@@.....
    0xe0,  //@@@.....
    0xe0,  //@@@.....
    0xe0,  //@@@.....
    0xe0,  //@@@.....
    0xe0,  //@@@.....
    0xe0,  //@@@.....
    0xe0,  //@@@.....
    0xe0,  //@@@.....
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0073 (s) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x3f, 0x80,  //..+@@@@@%..
    0x7f, 0xc0,  //.@@@@@@@@@.
    0xf0, 0x40,  //%@@@....+%.
    0xe0, 0x00,  //@@@........
    0xe0, 0x00,  //@@@........
    0xfc, 0x00,  //%@@@+%+....
    0x7f, 0x80,  //.@@@@@@@%..
    0x1f, 0xc0,  //..+%@@@@@@.
    0x01, 0xe0,  //......+@@@%
    0x00, 0xe0,  //........@@@
    0x00, 0xe0,  //........@@@
    0x81, 0xe0,  //@+.....@@@%
    0xff, 0xc0,  //@@@@@@@@@@.
    0x3f, 0x00,  //.+%@@@@%+..
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0074 (t) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x38, 0x00,  //..@@@.....
    0x38, 0x00,  //..@@@.....
    0x38, 0x00,  //..@@@.....
    0x38, 0x00,  //..@@@.....
    0xff, 0xc0,  //@@@@@@@@@@
    0xff, 0xc0,  //@@@@@@@@@@
    0x38, 0x00,  //..@@@.....
    0x38, 0x00,  //..@@@.....
    0x38, 0x00,  //..@@@.....
    0x38, 0x00,  //..@@@.....
    0x38, 0x00,  //..@@@.....
    0x38, 0x00,  //..@@@.....
    0x38, 0x00,  //..@@@.....
    0x38, 0x00,  //..@@@.....
    0x38, 0x00,  //..@@@.....
    0x3c, 0x00,  //..%@@%....
    0x1f, 0xc0,  //...@@@@@@@
    0x0f, 0xc0,  //....%@@@@@
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+0075 (u) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@......@@@
    0xe0, 0x70,  //@@@.....+@@@
    0xe0, 0xf0,  //%@@+....@@@@
    0x71, 0xf0,  //+@@@+..%%@@@
    0x7f, 0x70,  //.%@@@@@@.@@@
    0x1e, 0x70,  //..+@@@%..@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0076 (v) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xe0, 0x1c,  //@@@+......+@@@
    0x70, 0x38,  //+@@@......@@@+
    0x70, 0x38,  //.@@@......@@@.
    0x78, 0x78,  //.%@@%....%@@%.
    0x38, 0x70,  //.+@@@....@@@+.
    0x38, 0x70,  //..@@@+..+@@@..
    0x1c, 0xe0,  //..+@@%..%@@+..
    0x1c, 0xe0,  //...@@@..@@@...
    0x1c, 0xe0,  //...%@@++@@%...
    0x0f, 0xc0,  //...+@@@@@@+...
    0x0f, 0xc0,  //....@@@@@@....
    0x0f, 0xc0,  //....%@@@@%....
    0x07, 0x80,  //.....@@@@.....
    0x07, 0x80,  //.....@@@@.....
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0077 (w) , Width: 19 */
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0xe0, 0xe0, 0xe0,  //@@@.....@@@.....@@@
    0xf0, 0xe1, 0xe0,  //%@@+...+@@@+...+@@%
    0x71, 0xf1, 0xc0,  //+@@@...%@@@%...@@@+
    0x71, 0xb1, 0xc0,  //.@@@...@@+@@...@@@.
    0x71, 0xb1, 0xc0,  //.@@@+..@@.@@..+@@@.
    0x79, 0xb3, 0xc0,  //.%@@%.+@%.%@+.%@@%.
    0x3b, 0x1b, 0x80,  //.+@@@.%@+.+@%.@@@+.
    0x3b, 0x1b, 0x80,  //..@@@.@@...@@.@@@..
    0x3f, 0x1f, 0x80,  //..%@@%@@...@@%@@%..
    0x1f, 0x1f, 0x00,  //..+@@@@%...%@@@@+..
    0x1e, 0x0f, 0x00,  //...@@@@+...+@@@@...
    0x1e, 0x0f, 0x00,  //...@@@@.....@@@@...
    0x1e, 0x0f, 0x00,  //...%@@@.....@@@%...
    0x0e, 0x0e, 0x00,  //...+@@%.....%@@+...
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0078 (x) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xf0, 0x3c,  //%@@@+....+@@@%
    0x78, 0x78,  //.%@@@....@@@@.
    0x3c, 0xf0,  //..@@@@..@@@@..
    0x1f, 0xe0,  //...@@@%%@@@...
    0x0f, 0xc0,  //...+@@@@@@+...
    0x0f, 0xc0,  //....%@@@@%....
    0x07, 0x80,  //.....@@@%.....
    0x07, 0x80,  //.....@@@@.....
    0x0f, 0xc0,  //....@@@@@%....
    0x1f, 0xe0,  //...%@@@@@@%...
    0x1c, 0xe0,  //..+@@@++@@@+..
    0x3c, 0xf0,  //..@@@%..%@@@..
    0x78, 0x78,  //.@@@@....@@@@.
    0xf0, 0x3c,  //%@@@......@@@%
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0079 (y) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xe0, 0x1c,  //@@@+......+@@@
    0x70, 0x38,  //+@@@......@@@+
    0x70, 0x38,  //.@@@+....+@@@.
    0x78, 0x70,  //.%@@%....@@@+.
    0x38, 0x70,  //..@@@....@@@..
    0x38, 0xf0,  //..%@@+..%@@%..
    0x1c, 0xe0,  //..+@@@..@@@...
    0x1d, 0xe0,  //...@@@++@@%...
    0x1f, 0xc0,  //...+@@%@@@+...
    0x0f, 0xc0,  //....@@@@@@....
    0x0f, 0x80,  //....%@@@@+....
    0x07, 0x80,  //....+@@@@.....
    0x07, 0x80,  //.....@@@%.....
    0x07, 0x00,  //.....@@@......
    0x0f, 0x00,  //....%@@%......
    0x0e, 0x00,  //....@@@+......
    0x1e, 0x00,  //...%@@@.......
    0x7c, 0x00,  //.@@@@@........
    0x78, 0x00,  //.@@@%.........
    0x00, 0x00,  //..............


    /*Unicode: U+007a (z) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xff, 0xe0,  //@@@@@@@@@@@
    0xff, 0xe0,  //@@@@@@@@@@@
    0x01, 0xe0,  //.......@@@%
    0x03, 0xc0,  //......%@@@.
    0x03, 0x80,  //.....+@@@+.
    0x07, 0x80,  //.....@@@%..
    0x0f, 0x00,  //....@@@@...
    0x1e, 0x00,  //...%@@@....
    0x1c, 0x00,  //..+@@@+....
    0x3c, 0x00,  //..@@@%.....
    0x78, 0x00,  //.@@@@......
    0xf0, 0x00,  //%@@@.......
    0xff, 0xe0,  //@@@@@@@@@@@
    0xff, 0xe0,  //@@@@@@@@@@@
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+007b ({) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x03, 0xe0,  //......%@@@@
    0x07, 0xe0,  //.....@@@@@@
    0x0f, 0x00,  //....%@@%...
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x1c, 0x00,  //...@@@+....
    0xf8, 0x00,  //@@@@@+.....
    0xf8, 0x00,  //@@@@@+.....
    0x1c, 0x00,  //..+@@@+....
    0x0e, 0x00,  //...+@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0f, 0x00,  //....%@@%...
    0x07, 0xe0,  //.....@@@@@@
    0x03, 0xe0,  //......%@@@@
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+007c (|) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@


    /*Unicode: U+007d (}) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xf8, 0x00,  //@@@@%......
    0xfc, 0x00,  //@@@@@@.....
    0x1e, 0x00,  //...%@@%....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x07, 0x00,  //....+@@@...
    0x03, 0xe0,  //.....+@@@@@
    0x03, 0xe0,  //.....+@@@@@
    0x07, 0x00,  //....+@@@+..
    0x0e, 0x00,  //....@@@+...
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x0e, 0x00,  //....@@@....
    0x1e, 0x00,  //...%@@%....
    0xfc, 0x00,  //@@@@@@.....
    0xf8, 0x00,  //@@@@%......
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+007e (~) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x3e, 0x01,  //..%@@@%+.......@
    0x7f, 0x83,  //+@@@@@@@@+...+@@
    0xc1, 0xfe,  //@@+...+@@@@@@@@+
    0x80, 0x7c,  //%.......+%@@@%..
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................



#elif USE_LV_FONT_DEJAVU_30 == 2
    /*Unicode: U+0020 ( ) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0021 (!) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xb8,  //%@%
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0022 (") , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0xf0, 0x3c,  //@@...@@
    0xf0, 0x3c,  //@@...@@
    0xf0, 0x3c,  //@@...@@
    0xf0, 0x3c,  //@@...@@
    0xf0, 0x3c,  //@@...@@
    0xf0, 0x3c,  //@@...@@
    0xf0, 0x3c,  //@@...@@
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+0023 (#) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x02, 0xd0, 0x3c, 0x00,  //.......%@+...@@...
    0x00, 0x03, 0xc0, 0x3c, 0x00,  //.......@@....@@...
    0x00, 0x03, 0xc0, 0x78, 0x00,  //.......@@...+@%...
    0x00, 0x0b, 0x80, 0xb4, 0x00,  //......+@%...%@+...
    0x00, 0x0f, 0x40, 0xf0, 0x00,  //......@@+...@@....
    0x2f, 0xff, 0xff, 0xff, 0xf0,  //.%@@@@@@@@@@@@@@@@
    0x2f, 0xff, 0xff, 0xff, 0xf0,  //.%@@@@@@@@@@@@@@@@
    0x00, 0x2e, 0x02, 0xd0, 0x00,  //.....%@%...%@+....
    0x00, 0x3d, 0x03, 0xc0, 0x00,  //.....@@+...@@.....
    0x00, 0x3c, 0x03, 0xc0, 0x00,  //.....@@....@@.....
    0x00, 0x78, 0x07, 0x80, 0x00,  //....+@%...+@%.....
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%.
    0x00, 0xf0, 0x1f, 0x00, 0x00,  //....@@....@@......
    0x01, 0xe0, 0x2e, 0x00, 0x00,  //...+@%...%@%......
    0x02, 0xd0, 0x3d, 0x00, 0x00,  //...%@+...@@+......
    0x03, 0xc0, 0x3c, 0x00, 0x00,  //...@@....@@.......
    0x03, 0xc0, 0x78, 0x00, 0x00,  //...@@...+@%.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0024 ($) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x30, 0x00,  //.....@......
    0x00, 0x30, 0x00,  //.....@......
    0x00, 0x30, 0x00,  //.....@......
    0x06, 0xff, 0x90,  //..+%@@@@%+..
    0x2f, 0xff, 0xfc,  //.%@@@@@@@@@.
    0x7f, 0x30, 0x6c,  //+@@@.@..+%@.
    0xfc, 0x30, 0x00,  //@@@..@......
    0xfc, 0x30, 0x00,  //@@@..@......
    0xfd, 0x30, 0x00,  //@@@+.@......
    0xbf, 0xb0, 0x00,  //%@@@%@......
    0x3f, 0xff, 0x40,  //.@@@@@@@+...
    0x0f, 0xff, 0xf4,  //..@@@@@@@@+.
    0x00, 0x7f, 0xfd,  //....+@@@@@@+
    0x00, 0x31, 0xfe,  //.....@.+@@@%
    0x00, 0x30, 0x3f,  //.....@...@@@
    0x00, 0x30, 0x3f,  //.....@...@@@
    0x00, 0x30, 0x7f,  //.....@..+@@@
    0xd0, 0x31, 0xfd,  //@+...@.+@@@+
    0xff, 0xff, 0xf4,  //@@@@@@@@@@+.
    0x1b, 0xff, 0x80,  //.+%@@@@@%...
    0x00, 0x30, 0x00,  //.....@......
    0x00, 0x30, 0x00,  //.....@......
    0x00, 0x30, 0x00,  //.....@......
    0x00, 0x30, 0x00,  //.....@......
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0025 (%) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x0b, 0xf8, 0x00, 0x02, 0xe0, 0x00,  //..%@@@%........%@%....
    0x3f, 0xff, 0x00, 0x07, 0xc0, 0x00,  //.@@@@@@@......+@@.....
    0x7c, 0x1f, 0x40, 0x0f, 0x40, 0x00,  //+@@...@@+.....@@+.....
    0xf4, 0x07, 0xc0, 0x2f, 0x00, 0x00,  //@@+...+@@....%@@......
    0xf0, 0x03, 0xc0, 0x3c, 0x00, 0x00,  //@@.....@@....@@.......
    0xf0, 0x03, 0xc0, 0xb8, 0x00, 0x00,  //@@.....@@...%@%.......
    0xf4, 0x07, 0xc1, 0xf0, 0x00, 0x00,  //@@+...+@@..+@@........
    0xbc, 0x0f, 0x43, 0xd0, 0x00, 0x00,  //+@@...@@+..@@+........
    0x3f, 0xff, 0x0b, 0xc0, 0x00, 0x00,  //.@@@@@@@..%@@.........
    0x0b, 0xf8, 0x0f, 0x02, 0xfe, 0x00,  //..%@@@%...@@...%@@@%..
    0x00, 0x00, 0x3e, 0x0f, 0xff, 0xc0,  //.........@@%..@@@@@@@.
    0x00, 0x00, 0x7c, 0x1f, 0x43, 0xd0,  //........+@@..+@@...@@+
    0x00, 0x00, 0xf4, 0x3d, 0x01, 0xf0,  //........@@+..@@+...+@@
    0x00, 0x02, 0xf0, 0x3c, 0x00, 0xf0,  //.......%@%...@@.....@@
    0x00, 0x03, 0xc0, 0x3c, 0x00, 0xf0,  //.......@@....@@.....@@
    0x00, 0x0f, 0x80, 0x3d, 0x01, 0xf0,  //......@@%....@@+...+@@
    0x00, 0x1f, 0x00, 0x2f, 0x43, 0xd0,  //.....+@@.....+@@...@@+
    0x00, 0x3d, 0x00, 0x0f, 0xff, 0xc0,  //.....@@+......@@@@@@@.
    0x00, 0xb8, 0x00, 0x02, 0xfe, 0x00,  //....%@%........%@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+0026 (&) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x7f, 0xe0, 0x00, 0x00,  //....+@@@@%........
    0x03, 0xff, 0xfc, 0x00, 0x00,  //...@@@@@@@@.......
    0x0b, 0xf0, 0x1c, 0x00, 0x00,  //..%@@@...+@.......
    0x0f, 0xc0, 0x00, 0x00, 0x00,  //..@@@.............
    0x0f, 0xc0, 0x00, 0x00, 0x00,  //..@@@.............
    0x0f, 0xc0, 0x00, 0x00, 0x00,  //..@@@.............
    0x0f, 0xf0, 0x00, 0x00, 0x00,  //..@@@@............
    0x0b, 0xf8, 0x00, 0x00, 0x00,  //..%@@@%...........
    0x0f, 0xfe, 0x00, 0x00, 0x00,  //..@@@@@%..........
    0x2f, 0xbf, 0x40, 0x0f, 0xc0,  //.%@@%@@@+.....@@@.
    0x3c, 0x2f, 0xd0, 0x0f, 0x80,  //.@@..%@@@+....@@%.
    0xb8, 0x0b, 0xf0, 0x1f, 0x00,  //%@%...%@@@...+@@..
    0xfc, 0x02, 0xfc, 0x3e, 0x00,  //@@@....%@@@..@@%..
    0xfc, 0x00, 0xbf, 0xbc, 0x00,  //@@@.....%@@@%@@...
    0xfd, 0x00, 0x2f, 0xf4, 0x00,  //@@@+.....%@@@@+...
    0x7f, 0x00, 0x0f, 0xf0, 0x00,  //+@@@......@@@@....
    0x3f, 0xd0, 0x7f, 0xfd, 0x00,  //.@@@@+..+@@@@@@...
    0x0f, 0xff, 0xfc, 0xbf, 0x40,  //..@@@@@@@@@.%@@@+.
    0x01, 0xbf, 0x90, 0x2f, 0xd0,  //...+%@@@%+...%@@@+
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0027 (') , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+0028 (() , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0xf0,  //....@@
    0x03, 0xd0,  //...@@+
    0x07, 0xc0,  //..+@@.
    0x0f, 0x40,  //..@@+.
    0x1f, 0x00,  //.+@@..
    0x3f, 0x00,  //.@@@..
    0x3e, 0x00,  //.@@%..
    0x7d, 0x00,  //+@@+..
    0xbc, 0x00,  //%@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xbc, 0x00,  //%@@...
    0x7d, 0x00,  //+@@+..
    0x3e, 0x00,  //.@@%..
    0x3f, 0x00,  //.@@@..
    0x1f, 0x00,  //.+@@..
    0x0f, 0x40,  //..@@+.
    0x07, 0xc0,  //..+@@.
    0x03, 0xd0,  //...@@+
    0x00, 0xf0,  //....@@
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+0029 ()) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0xf0, 0x00,  //@@....
    0x7c, 0x00,  //+@@...
    0x3d, 0x00,  //.@@+..
    0x1f, 0x00,  //.+@@..
    0x0f, 0x40,  //..@@+.
    0x0f, 0xc0,  //..@@@.
    0x0b, 0xc0,  //..%@@.
    0x07, 0xd0,  //..+@@+
    0x03, 0xe0,  //...@@%
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xe0,  //...@@%
    0x07, 0xd0,  //..+@@+
    0x0b, 0xc0,  //..%@@.
    0x0f, 0xc0,  //..@@@.
    0x0f, 0x40,  //..@@+.
    0x1f, 0x00,  //.+@@..
    0x3d, 0x00,  //.@@+..
    0x7c, 0x00,  //+@@...
    0xf0, 0x00,  //@@....
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+002a (*) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x30, 0x00,  //.....@.....
    0x00, 0x30, 0x00,  //.....@.....
    0x90, 0x30, 0x18,  //%+...@...+%
    0xbc, 0x30, 0xf8,  //%@@..@..@@%
    0x0f, 0xbb, 0xc0,  //..@@%@%@@..
    0x01, 0xfd, 0x00,  //...+@@@+...
    0x01, 0xfd, 0x00,  //...+@@@+...
    0x0f, 0xbb, 0xc0,  //..@@%@%@@..
    0xbc, 0x30, 0xf8,  //%@@..@..@@%
    0xa0, 0x30, 0x28,  //%+...@...+%
    0x00, 0x30, 0x00,  //.....@.....
    0x00, 0x30, 0x00,  //.....@.....
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+002b (+) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x03, 0xc0, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+002c (,) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x3f,  //.@@@
    0x3f,  //.@@@
    0x3f,  //.@@@
    0x7d,  //+@@+
    0xbc,  //%@@.
    0xf4,  //@@..
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+002d (-) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0xff, 0xfc,  //@@@@@@@
    0xff, 0xfc,  //@@@@@@@
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+002e (.) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+002f (/) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x07, 0xc0,  //......+@@
    0x00, 0x0b, 0x80,  //......%@+
    0x00, 0x0f, 0x00,  //......@@.
    0x00, 0x1f, 0x00,  //......@@.
    0x00, 0x2e, 0x00,  //.....%@%.
    0x00, 0x3c, 0x00,  //.....@@..
    0x00, 0x3c, 0x00,  //.....@@..
    0x00, 0xb8, 0x00,  //....%@%..
    0x00, 0xf0, 0x00,  //....@@...
    0x00, 0xf0, 0x00,  //....@@...
    0x02, 0xe0, 0x00,  //...%@%...
    0x03, 0xc0, 0x00,  //...@@....
    0x03, 0xc0, 0x00,  //...@@....
    0x0b, 0x80, 0x00,  //..%@%....
    0x0f, 0x00, 0x00,  //..@@.....
    0x0f, 0x00, 0x00,  //..@@.....
    0x2e, 0x00, 0x00,  //.%@%.....
    0x3d, 0x00, 0x00,  //.@@......
    0x3c, 0x00, 0x00,  //.@@......
    0xb8, 0x00, 0x00,  //+@%......
    0xf4, 0x00, 0x00,  //@@+......
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0030 (0) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0xbf, 0x80, 0x00,  //....%@@@%....
    0x07, 0xff, 0xf4, 0x00,  //..+@@@@@@@+..
    0x1f, 0xc0, 0xfd, 0x00,  //.+@@@...@@@+.
    0x3f, 0x00, 0x3f, 0x00,  //.@@@.....@@@.
    0x7e, 0x00, 0x2f, 0x40,  //+@@%.....%@@+
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@%
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0x7e, 0x00, 0x2f, 0x40,  //+@@%.....%@@+
    0x3f, 0x00, 0x3f, 0x00,  //.@@@.....@@@.
    0x1f, 0xc0, 0xfd, 0x00,  //.+@@@...@@@+.
    0x07, 0xff, 0xf4, 0x00,  //..+@@@@@@@+..
    0x00, 0xbf, 0x80, 0x00,  //....%@@@%....
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0031 (1) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x16, 0xff, 0x00,  //.++%@@@@....
    0xff, 0xff, 0x00,  //@@@@@@@@....
    0xe5, 0x3f, 0x00,  //@%++.@@@....
    0x00, 0x3f, 0x00,  //.....@@@....
    0x00, 0x3f, 0x00,  //.....@@@....
    0x00, 0x3f, 0x00,  //.....@@@....
    0x00, 0x3f, 0x00,  //.....@@@....
    0x00, 0x3f, 0x00,  //.....@@@....
    0x00, 0x3f, 0x00,  //.....@@@....
    0x00, 0x3f, 0x00,  //.....@@@....
    0x00, 0x3f, 0x00,  //.....@@@....
    0x00, 0x3f, 0x00,  //.....@@@....
    0x00, 0x3f, 0x00,  //.....@@@....
    0x00, 0x3f, 0x00,  //.....@@@....
    0x00, 0x3f, 0x00,  //.....@@@....
    0x00, 0x3f, 0x00,  //.....@@@....
    0x00, 0x3f, 0x00,  //.....@@@....
    0x3f, 0xff, 0xff,  //.@@@@@@@@@@@
    0x3f, 0xff, 0xff,  //.@@@@@@@@@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0032 (2) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x1b, 0xff, 0x40, 0x00,  //.+%@@@@@+....
    0xff, 0xff, 0xf4, 0x00,  //@@@@@@@@@@+..
    0xf9, 0x02, 0xfc, 0x00,  //@@%+...%@@@..
    0x80, 0x00, 0xbe, 0x00,  //%.......%@@%.
    0x00, 0x00, 0x3f, 0x00,  //.........@@@.
    0x00, 0x00, 0x3f, 0x00,  //.........@@@.
    0x00, 0x00, 0x3f, 0x00,  //.........@@@.
    0x00, 0x00, 0xbe, 0x00,  //........%@@%.
    0x00, 0x00, 0xfc, 0x00,  //........@@@..
    0x00, 0x03, 0xf8, 0x00,  //.......@@@%..
    0x00, 0x0f, 0xf0, 0x00,  //......@@@@...
    0x00, 0x3f, 0xc0, 0x00,  //.....@@@@....
    0x00, 0xbf, 0x00, 0x00,  //....%@@@.....
    0x02, 0xfd, 0x00, 0x00,  //...%@@@+.....
    0x0b, 0xf4, 0x00, 0x00,  //..%@@@+......
    0x2f, 0xd0, 0x00, 0x00,  //.%@@@+.......
    0xbf, 0x80, 0x00, 0x00,  //%@@@%........
    0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0033 (3) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x0b, 0xfe, 0x40,  //..+%@@@%+...
    0x3f, 0xff, 0xe0,  //.@@@@@@@@%..
    0x34, 0x07, 0xf4,  //.@+...+@@@+.
    0x00, 0x01, 0xfc,  //.......+@@@.
    0x00, 0x00, 0xfc,  //........@@@.
    0x00, 0x00, 0xfc,  //........@@@.
    0x00, 0x01, 0xf8,  //.......+@@%.
    0x00, 0x07, 0xf0,  //......+@@@..
    0x03, 0xff, 0x40,  //...@@@@@+...
    0x03, 0xff, 0x90,  //...@@@@@%+..
    0x00, 0x06, 0xf8,  //.......%@@%.
    0x00, 0x00, 0xbe,  //........%@@+
    0x00, 0x00, 0x3f,  //.........@@@
    0x00, 0x00, 0x3f,  //.........@@@
    0x00, 0x00, 0x3f,  //.........@@@
    0x00, 0x00, 0xbe,  //........%@@%
    0xd0, 0x06, 0xfc,  //@+....+%@@@.
    0xff, 0xff, 0xf0,  //@@@@@@@@@@..
    0x1b, 0xfe, 0x40,  //.+%@@@@%+...
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0034 (4) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x02, 0xfc, 0x00,  //.......%@@@...
    0x00, 0x03, 0xfc, 0x00,  //.......@@@@...
    0x00, 0x0f, 0xfc, 0x00,  //......@@@@@...
    0x00, 0x2e, 0xfc, 0x00,  //.....%@%@@@...
    0x00, 0x3c, 0xfc, 0x00,  //.....@@.@@@...
    0x00, 0xf4, 0xfc, 0x00,  //....@@+.@@@...
    0x02, 0xe0, 0xfc, 0x00,  //...%@%..@@@...
    0x03, 0xc0, 0xfc, 0x00,  //...@@...@@@...
    0x0f, 0x40, 0xfc, 0x00,  //..@@+...@@@...
    0x2e, 0x00, 0xfc, 0x00,  //.%@%....@@@...
    0x7c, 0x00, 0xfc, 0x00,  //.@@.....@@@...
    0xf4, 0x00, 0xfc, 0x00,  //@@+.....@@@...
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@
    0x00, 0x00, 0xfc, 0x00,  //........@@@...
    0x00, 0x00, 0xfc, 0x00,  //........@@@...
    0x00, 0x00, 0xfc, 0x00,  //........@@@...
    0x00, 0x00, 0xfc, 0x00,  //........@@@...
    0x00, 0x00, 0xfc, 0x00,  //........@@@...
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0035 (5) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x3f, 0xff, 0xfc,  //.@@@@@@@@@@.
    0x3f, 0xff, 0xfc,  //.@@@@@@@@@@.
    0x3f, 0x00, 0x00,  //.@@@........
    0x3f, 0x00, 0x00,  //.@@@........
    0x3f, 0x00, 0x00,  //.@@@........
    0x3f, 0x00, 0x00,  //.@@@........
    0x3f, 0xff, 0x80,  //.@@@@@@@%...
    0x3f, 0xff, 0xf0,  //.@@@@@@@@@..
    0x34, 0x07, 0xfc,  //.@+...+@@@@.
    0x00, 0x00, 0xfd,  //........@@@+
    0x00, 0x00, 0x7f,  //........+@@%
    0x00, 0x00, 0x3f,  //.........@@@
    0x00, 0x00, 0x3f,  //.........@@@
    0x00, 0x00, 0x3f,  //.........@@@
    0x00, 0x00, 0x7e,  //........+@@%
    0x00, 0x00, 0xfd,  //........@@@+
    0xd0, 0x07, 0xfc,  //@+....+@@@@.
    0xff, 0xff, 0xe0,  //@@@@@@@@@%..
    0x1b, 0xfe, 0x40,  //.+%@@@@%+...
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0036 (6) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x2f, 0xf8, 0x00,  //.....%@@@@%..
    0x02, 0xff, 0xff, 0x00,  //...%@@@@@@@@.
    0x0b, 0xf4, 0x07, 0x00,  //..%@@@+...+@.
    0x1f, 0x80, 0x00, 0x00,  //.+@@%........
    0x3f, 0x00, 0x00, 0x00,  //.@@@.........
    0x7e, 0x00, 0x00, 0x00,  //+@@%.........
    0xbd, 0x00, 0x00, 0x00,  //%@@+.........
    0xfc, 0x2f, 0xe0, 0x00,  //@@@..%@@@%...
    0xfd, 0xff, 0xfd, 0x00,  //@@@+@@@@@@@+.
    0xff, 0x80, 0xbf, 0x00,  //@@@@%...%@@@.
    0xfe, 0x00, 0x2f, 0x80,  //@@@%.....%@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //%@@.......@@@
    0xbc, 0x00, 0x0f, 0xc0,  //%@@.......@@@
    0x7c, 0x00, 0x0f, 0xc0,  //+@@.......@@@
    0x3e, 0x00, 0x2f, 0x80,  //.@@%.....%@@%
    0x1f, 0x80, 0xbf, 0x00,  //.+@@%...%@@@.
    0x07, 0xff, 0xfc, 0x00,  //..+@@@@@@@@..
    0x00, 0xbf, 0xd0, 0x00,  //....%@@@@+...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0037 (7) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0xbe,  //........%@@%
    0x00, 0x00, 0xfc,  //........@@@.
    0x00, 0x01, 0xfc,  //.......+@@@.
    0x00, 0x02, 0xf8,  //.......%@@%.
    0x00, 0x03, 0xf0,  //.......@@@..
    0x00, 0x03, 0xf0,  //.......@@@..
    0x00, 0x0b, 0xe0,  //......%@@%..
    0x00, 0x0f, 0xd0,  //......@@@+..
    0x00, 0x0f, 0xc0,  //......@@@...
    0x00, 0x2f, 0x80,  //.....%@@%...
    0x00, 0x3f, 0x40,  //.....@@@+...
    0x00, 0x3f, 0x00,  //.....@@@....
    0x00, 0xbe, 0x00,  //....%@@%....
    0x00, 0xfd, 0x00,  //....@@@+....
    0x00, 0xfc, 0x00,  //....@@@.....
    0x02, 0xf8, 0x00,  //...%@@%.....
    0x03, 0xf4, 0x00,  //...@@@+.....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0038 (8) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x02, 0xff, 0xe0, 0x00,  //...%@@@@@%...
    0x1f, 0xff, 0xfd, 0x00,  //.+@@@@@@@@@+.
    0x7f, 0x40, 0x7f, 0x40,  //+@@@+...+@@@+
    0xfd, 0x00, 0x1f, 0xc0,  //@@@+.....+@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0x3f, 0x40, 0x7f, 0x00,  //.@@@+...+@@%.
    0x07, 0xff, 0xf4, 0x00,  //..+@@@@@@@+..
    0x0b, 0xff, 0xf8, 0x00,  //..%@@@@@@@%..
    0x3f, 0x80, 0xbf, 0x00,  //.@@@%...%@@@.
    0xbe, 0x00, 0x2f, 0x80,  //%@@%.....%@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xbe, 0x00, 0x2f, 0x80,  //%@@%.....%@@%
    0x3f, 0x80, 0xbf, 0x00,  //.@@@%...%@@@.
    0x1f, 0xff, 0xfd, 0x00,  //.+@@@@@@@@@+.
    0x02, 0xff, 0xe0, 0x00,  //...%@@@@@%...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0039 (9) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x01, 0xff, 0x80, 0x00,  //...+@@@@%....
    0x0f, 0xff, 0xf4, 0x00,  //..@@@@@@@@+..
    0x3f, 0x80, 0xbd, 0x00,  //.@@@%...%@@+.
    0xbe, 0x00, 0x2f, 0x00,  //%@@%.....%@@.
    0xfc, 0x00, 0x0f, 0x40,  //@@@.......@@.
    0xfc, 0x00, 0x0f, 0x80,  //@@@.......@@%
    0xfc, 0x00, 0x0f, 0x80,  //@@@.......@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xbe, 0x00, 0x2f, 0xc0,  //%@@%.....%@@@
    0x3f, 0x80, 0xbf, 0xc0,  //.@@@%...%@@@@
    0x1f, 0xff, 0xdf, 0xc0,  //.+@@@@@@@+@@@
    0x02, 0xfe, 0x0f, 0xc0,  //...%@@@%..@@@
    0x00, 0x00, 0x1f, 0x80,  //.........+@@%
    0x00, 0x00, 0x2f, 0x40,  //.........%@@+
    0x00, 0x00, 0x3f, 0x00,  //.........@@@.
    0x00, 0x00, 0xbd, 0x00,  //........%@@+.
    0x34, 0x07, 0xf8, 0x00,  //.@+...+@@@%..
    0x3f, 0xff, 0xe0, 0x00,  //.@@@@@@@@%...
    0x0b, 0xfe, 0x00, 0x00,  //..%@@@@%.....
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+003a (:) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+003b (;) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x3f,  //.@@@
    0x3f,  //.@@@
    0x3f,  //.@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x3f,  //.@@@
    0x3f,  //.@@@
    0x3f,  //.@@@
    0x7d,  //+@@+
    0xbc,  //%@@.
    0xf4,  //@@..
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+003c (<) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x07,  //..............+@
    0x00, 0x00, 0x01, 0xbf,  //...........+%@@@
    0x00, 0x00, 0x2f, 0xf9,  //.........%@@@@%+
    0x00, 0x07, 0xff, 0x40,  //......+@@@@@+...
    0x01, 0xbf, 0xe0, 0x00,  //...+%@@@@%......
    0x2f, 0xf9, 0x00, 0x00,  //.%@@@@%+........
    0xff, 0x40, 0x00, 0x00,  //@@@@+...........
    0xff, 0x40, 0x00, 0x00,  //@@@@+...........
    0x2f, 0xf9, 0x00, 0x00,  //.%@@@@%+........
    0x01, 0xbf, 0xe0, 0x00,  //...+%@@@@%......
    0x00, 0x07, 0xff, 0x40,  //......+@@@@@+...
    0x00, 0x00, 0x2f, 0xf9,  //.........%@@@@%+
    0x00, 0x00, 0x01, 0xbf,  //...........+%@@@
    0x00, 0x00, 0x00, 0x07,  //..............+@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+003d (=) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+003e (>) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xd0, 0x00, 0x00, 0x00,  //@+..............
    0xfe, 0x40, 0x00, 0x00,  //@@@%+...........
    0x6f, 0xf8, 0x00, 0x00,  //+%@@@@%.........
    0x01, 0xff, 0xd0, 0x00,  //...+@@@@@+......
    0x00, 0x0b, 0xfe, 0x40,  //......%@@@@%+...
    0x00, 0x00, 0x6f, 0xf8,  //........+%@@@@%.
    0x00, 0x00, 0x01, 0xff,  //...........+@@@@
    0x00, 0x00, 0x01, 0xff,  //...........+@@@@
    0x00, 0x00, 0x6f, 0xf8,  //........+%@@@@%.
    0x00, 0x0b, 0xfe, 0x40,  //......%@@@@%+...
    0x01, 0xff, 0xd0, 0x00,  //...+@@@@@+......
    0x6f, 0xf8, 0x00, 0x00,  //+%@@@@%.........
    0xfe, 0x40, 0x00, 0x00,  //@@@%+...........
    0xd0, 0x00, 0x00, 0x00,  //@+..............
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+003f (?) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x0b, 0xfd, 0x00,  //..%@@@@+..
    0x7f, 0xff, 0xc0,  //+@@@@@@@@.
    0xf4, 0x1f, 0xe0,  //@@+..+@@@%
    0x80, 0x07, 0xf0,  //%.....+@@@
    0x00, 0x03, 0xf0,  //.......@@@
    0x00, 0x03, 0xf0,  //.......@@@
    0x00, 0x07, 0xd0,  //......+@@+
    0x00, 0x0f, 0x40,  //......@@+.
    0x00, 0x3d, 0x00,  //.....@@+..
    0x00, 0xf8, 0x00,  //....@@%...
    0x02, 0xf0, 0x00,  //...%@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x03, 0xf0, 0x00,  //...@@@....
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0040 (@) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x6f, 0xf9, 0x00, 0x00,  //........+%@@@@%+.......
    0x00, 0x0b, 0xff, 0xff, 0xe0, 0x00,  //......%@@@@@@@@@@%.....
    0x00, 0xbf, 0x90, 0x06, 0xfd, 0x00,  //....+@@@%+....+%@@@+...
    0x02, 0xf8, 0x00, 0x00, 0x2f, 0x40,  //...%@@+..........%@@+..
    0x0b, 0xd0, 0x00, 0x00, 0x07, 0xc0,  //..%@@+............+@@..
    0x1f, 0x00, 0x00, 0x00, 0x01, 0xf0,  //.+@@...............+@@.
    0x3d, 0x00, 0x7f, 0x93, 0xc0, 0xf4,  //.@@+....+@@@%+.@@...@@+
    0x7c, 0x02, 0xff, 0xf7, 0xc0, 0x78,  //.@@....%@@@@@@+@@...+@%
    0xb4, 0x07, 0xe0, 0x2f, 0xc0, 0x3c,  //%@+...+@@%...%@@@....@@
    0xf0, 0x0b, 0x80, 0x0b, 0xc0, 0x3c,  //@@....%@%.....%@@....@@
    0xf0, 0x0f, 0x00, 0x03, 0xc0, 0x3c,  //@@....@@.......@@....@@
    0xf0, 0x0f, 0x00, 0x03, 0xc0, 0x3c,  //@@....@@.......@@....@@
    0xf0, 0x0f, 0x00, 0x03, 0xc0, 0xb8,  //@@....@@.......@@...%@%
    0xf0, 0x0b, 0x80, 0x0b, 0xc0, 0xf0,  //@@....%@%.....%@@...@@.
    0xb8, 0x07, 0xe0, 0x2f, 0xc7, 0xd0,  //%@+...+@@%...%@@@.+@@+.
    0x7c, 0x02, 0xff, 0xf7, 0xff, 0x40,  //+@@....%@@@@@@+@@@@@+..
    0x3d, 0x00, 0x7f, 0xd3, 0xe4, 0x00,  //.@@+....+@@@%+.@@%+....
    0x1f, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@...................
    0x0b, 0xc0, 0x00, 0x00, 0x00, 0x00,  //..%@@..................
    0x02, 0xf4, 0x00, 0x00, 0x24, 0x00,  //...%@@+..........%+....
    0x00, 0xbf, 0x90, 0x06, 0xf4, 0x00,  //....%@@@%.....+%@@+....
    0x00, 0x1f, 0xff, 0xff, 0x80, 0x00,  //.....+@@@@@@@@@@%......
    0x00, 0x01, 0xbf, 0xf8, 0x00, 0x00,  //.......+%@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0041 (A) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x07, 0xf4, 0x00, 0x00,  //......+@@@+......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x3f, 0x7f, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x7f, 0x3f, 0x40, 0x00,  //....+@@@.@@@+....
    0x00, 0xbd, 0x1f, 0x80, 0x00,  //....%@@+.+@@%....
    0x00, 0xfc, 0x0f, 0xc0, 0x00,  //....@@@...@@@....
    0x01, 0xf8, 0x0b, 0xd0, 0x00,  //...+@@%...%@@+...
    0x03, 0xf4, 0x07, 0xf0, 0x00,  //...@@@+...+@@@...
    0x03, 0xf0, 0x03, 0xf0, 0x00,  //...@@@.....@@@...
    0x0b, 0xff, 0xff, 0xf8, 0x00,  //..%@@@@@@@@@@@%..
    0x0f, 0xff, 0xff, 0xfc, 0x00,  //..@@@@@@@@@@@@@..
    0x1f, 0xc0, 0x00, 0xfd, 0x00,  //.+@@@.......@@@+.
    0x2f, 0x40, 0x00, 0xbe, 0x00,  //.%@@+.......+@@%.
    0x3f, 0x00, 0x00, 0x3f, 0x00,  //.@@@.........@@@.
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@%.........@@@+
    0xfd, 0x00, 0x00, 0x1f, 0xc0,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0042 (B) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0x90, 0x00,  //@@@@@@@@%+...
    0xff, 0xff, 0xf8, 0x00,  //@@@@@@@@@@%..
    0xfc, 0x01, 0xfd, 0x00,  //@@@....+@@@+.
    0xfc, 0x00, 0x7f, 0x00,  //@@@.....+@@@.
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@.
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@.
    0xfc, 0x00, 0x7e, 0x00,  //@@@.....+@@%.
    0xfc, 0x01, 0xfc, 0x00,  //@@@....+@@@..
    0xff, 0xff, 0xe0, 0x00,  //@@@@@@@@@%...
    0xff, 0xff, 0xf4, 0x00,  //@@@@@@@@@@+..
    0xfc, 0x00, 0xbe, 0x00,  //@@@.....%@@%.
    0xfc, 0x00, 0x2f, 0x40,  //@@@......%@@+
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x2f, 0x80,  //@@@......%@@%
    0xfc, 0x00, 0xbf, 0x40,  //@@@.....%@@@.
    0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@+.
    0xff, 0xff, 0xe0, 0x00,  //@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0043 (C) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x1b, 0xfe, 0x40,  //.....+%@@@@%+..
    0x01, 0xff, 0xff, 0xf4,  //...+@@@@@@@@@@+
    0x07, 0xf8, 0x01, 0xfc,  //..+@@@%....+@@@
    0x1f, 0xc0, 0x00, 0x2c,  //.+@@@........%@
    0x3f, 0x40, 0x00, 0x04,  //.@@@+.........+
    0x7e, 0x00, 0x00, 0x00,  //+@@%...........
    0xbd, 0x00, 0x00, 0x00,  //%@@+...........
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xfc, 0x00, 0x00, 0x00,  //@@@............
    0xbd, 0x00, 0x00, 0x00,  //%@@+...........
    0x7e, 0x00, 0x00, 0x00,  //+@@%...........
    0x3f, 0x40, 0x00, 0x04,  //.@@@..........+
    0x1f, 0xc0, 0x00, 0x2c,  //.+@@@........%@
    0x07, 0xf8, 0x01, 0xfc,  //..+@@@%....+@@@
    0x01, 0xff, 0xff, 0xf4,  //...+@@@@@@@@@@+
    0x00, 0x1b, 0xfe, 0x40,  //.....+%@@@@%+..
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0044 (D) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xe4, 0x00,  //@@@@@@@@@%+.....
    0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@+...
    0xfc, 0x00, 0x6f, 0xe0,  //@@@.....+%@@@%..
    0xfc, 0x00, 0x03, 0xf4,  //@@@........@@@+.
    0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@.
    0xfc, 0x00, 0x00, 0xbd,  //@@@.........%@@+
    0xfc, 0x00, 0x00, 0x7e,  //@@@.........+@@%
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x3f,  //@@@..........@@@
    0xfc, 0x00, 0x00, 0x7e,  //@@@.........+@@%
    0xfc, 0x00, 0x00, 0xbd,  //@@@.........%@@+
    0xfc, 0x00, 0x00, 0xfc,  //@@@.........@@@.
    0xfc, 0x00, 0x03, 0xf4,  //@@@........@@@+.
    0xfc, 0x00, 0x6f, 0xe0,  //@@@.....+%@@@%..
    0xff, 0xff, 0xff, 0x40,  //@@@@@@@@@@@@+...
    0xff, 0xff, 0xe4, 0x00,  //@@@@@@@@@%+.....
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0045 (E) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0046 (F) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xf0,  //@@@@@@@@@@.
    0xff, 0xff, 0xf0,  //@@@@@@@@@@.
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0047 (G) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x1b, 0xff, 0x90, 0x00,  //.....+%@@@@@%....
    0x01, 0xff, 0xff, 0xfd, 0x00,  //...+@@@@@@@@@@@+.
    0x07, 0xf9, 0x00, 0xbf, 0x00,  //..+@@@%+....%@@@.
    0x1f, 0xc0, 0x00, 0x0b, 0x00,  //.+@@@.........%@.
    0x3f, 0x40, 0x00, 0x02, 0x00,  //.@@@+..........%.
    0x7e, 0x00, 0x00, 0x00, 0x00,  //+@@%.............
    0xbd, 0x00, 0x00, 0x00, 0x00,  //%@@+.............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfc, 0x00, 0x0f, 0xff, 0xc0,  //@@@.......@@@@@@@
    0xfc, 0x00, 0x0f, 0xff, 0xc0,  //@@@.......@@@@@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xbd, 0x00, 0x00, 0x0f, 0xc0,  //%@@+..........@@@
    0x7e, 0x00, 0x00, 0x0f, 0xc0,  //+@@%..........@@@
    0x3f, 0x40, 0x00, 0x0f, 0xc0,  //.@@@..........@@@
    0x1f, 0xc0, 0x00, 0x0f, 0xc0,  //..@@@.........@@@
    0x07, 0xf9, 0x00, 0x6f, 0xc0,  //..+@@@%+....+%@@@
    0x00, 0xff, 0xff, 0xff, 0x00,  //....@@@@@@@@@@@@.
    0x00, 0x1b, 0xff, 0x90, 0x00,  //.....+%@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0048 (H) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0049 (I) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+004a (J) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x1f, 0x80,  //.+@@%
    0x7f, 0x00,  //+@@@.
    0xfe, 0x00,  //@@@%.
    0xe4, 0x00,  //@%+..
    0x00, 0x00,  //.....


    /*Unicode: U+004b (K) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xfc, 0x00, 0x1f, 0xe0,  //@@@.......@@@+.
    0xfc, 0x00, 0x3f, 0x80,  //@@@......@@@%..
    0xfc, 0x00, 0xfe, 0x00,  //@@@.....@@@%...
    0xfc, 0x03, 0xf8, 0x00,  //@@@....@@@%....
    0xfc, 0x0f, 0xe0, 0x00,  //@@@...@@@%.....
    0xfc, 0x3f, 0x80, 0x00,  //@@@..@@@%......
    0xfc, 0xfe, 0x00, 0x00,  //@@@.@@@%.......
    0xff, 0xf8, 0x00, 0x00,  //@@@@@@%........
    0xff, 0xe0, 0x00, 0x00,  //@@@@@%.........
    0xff, 0xf0, 0x00, 0x00,  //@@@@@@.........
    0xff, 0xfc, 0x00, 0x00,  //@@@@@@@........
    0xfd, 0xfe, 0x00, 0x00,  //@@@+@@@%.......
    0xfc, 0x7f, 0x80, 0x00,  //@@@.+@@@%......
    0xfc, 0x1f, 0xe0, 0x00,  //@@@..+@@@%.....
    0xfc, 0x07, 0xf8, 0x00,  //@@@...+@@@%....
    0xfc, 0x01, 0xfe, 0x00,  //@@@....+@@@%...
    0xfc, 0x00, 0x7f, 0x80,  //@@@.....+@@@%..
    0xfc, 0x00, 0x1f, 0xe0,  //@@@......+@@@%.
    0xfc, 0x00, 0x07, 0xf8,  //@@@.......+@@@%
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+004c (L) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+004d (M) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xe0, 0x02, 0xff, 0xc0,  //@@@@@%.....%@@@@@
    0xff, 0xf0, 0x03, 0xff, 0xc0,  //@@@@@@.....@@@@@@
    0xff, 0xf0, 0x03, 0xff, 0xc0,  //@@@@@@.....@@@@@@
    0xfe, 0xf8, 0x0b, 0xef, 0xc0,  //@@@%@@%...%@@%@@@
    0xfc, 0xfc, 0x0f, 0xcf, 0xc0,  //@@@.@@@...@@@.@@@
    0xfc, 0xfd, 0x1f, 0xcf, 0xc0,  //@@@.@@@+.+@@@.@@@
    0xfc, 0xbe, 0x2f, 0x8f, 0xc0,  //@@@.%@@%.%@@%.@@@
    0xfc, 0x3f, 0x3f, 0x0f, 0xc0,  //@@@..@@@.@@@..@@@
    0xfc, 0x3f, 0xbf, 0x0f, 0xc0,  //@@@..@@@%@@@..@@@
    0xfc, 0x2f, 0xfe, 0x0f, 0xc0,  //@@@..%@@@@@%..@@@
    0xfc, 0x0f, 0xfc, 0x0f, 0xc0,  //@@@...@@@@@...@@@
    0xfc, 0x0f, 0xfc, 0x0f, 0xc0,  //@@@...@@@@@...@@@
    0xfc, 0x07, 0xf4, 0x0f, 0xc0,  //@@@...+@@@+...@@@
    0xfc, 0x03, 0xf0, 0x0f, 0xc0,  //@@@....@@@....@@@
    0xfc, 0x03, 0xf0, 0x0f, 0xc0,  //@@@....@@@....@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0xfc, 0x00, 0x00, 0x0f, 0xc0,  //@@@...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+004e (N) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0x00, 0x03, 0xf0,  //@@@@.......@@@
    0xff, 0x80, 0x03, 0xf0,  //@@@@%......@@@
    0xff, 0xc0, 0x03, 0xf0,  //@@@@@......@@@
    0xff, 0xe0, 0x03, 0xf0,  //@@@@@%.....@@@
    0xff, 0xf0, 0x03, 0xf0,  //@@@@@@.....@@@
    0xfe, 0xf8, 0x03, 0xf0,  //@@@%@@%....@@@
    0xfc, 0xfd, 0x03, 0xf0,  //@@@.@@@+...@@@
    0xfc, 0xbf, 0x03, 0xf0,  //@@@.%@@@...@@@
    0xfc, 0x3f, 0x43, 0xf0,  //@@@..@@@+..@@@
    0xfc, 0x2f, 0xc3, 0xf0,  //@@@..%@@@..@@@
    0xfc, 0x0f, 0xd3, 0xf0,  //@@@...@@@+.@@@
    0xfc, 0x0b, 0xf3, 0xf0,  //@@@...%@@@.@@@
    0xfc, 0x03, 0xf7, 0xf0,  //@@@....@@@+@@@
    0xfc, 0x02, 0xff, 0xf0,  //@@@....%@@@@@@
    0xfc, 0x00, 0xff, 0xf0,  //@@@.....@@@@@@
    0xfc, 0x00, 0xbf, 0xf0,  //@@@.....%@@@@@
    0xfc, 0x00, 0x3f, 0xf0,  //@@@......@@@@@
    0xfc, 0x00, 0x2f, 0xf0,  //@@@......%@@@@
    0xfc, 0x00, 0x0f, 0xf0,  //@@@.......@@@@
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+004f (O) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+.....
    0x01, 0xff, 0xff, 0xf4, 0x00,  //...+@@@@@@@@@@+...
    0x07, 0xf8, 0x02, 0xfd, 0x00,  //..+@@@%....%@@@+..
    0x1f, 0xc0, 0x00, 0x3f, 0x40,  //.+@@@........@@@..
    0x3f, 0x40, 0x00, 0x1f, 0xc0,  //.@@@+........+@@@.
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........%@@+
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........%@@+
    0x3f, 0x40, 0x00, 0x1f, 0xc0,  //.@@@+........+@@@.
    0x1f, 0xc0, 0x00, 0x3f, 0x40,  //.+@@@........@@@+.
    0x07, 0xf8, 0x02, 0xfd, 0x00,  //..+@@@%....%@@@+..
    0x01, 0xff, 0xff, 0xf4, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0050 (P) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0x80,  //@@@@@@@@%...
    0xff, 0xff, 0xf4,  //@@@@@@@@@@+.
    0xfc, 0x01, 0xfd,  //@@@....+@@@+
    0xfc, 0x00, 0xbe,  //@@@.....%@@%
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0xbe,  //@@@.....+@@%
    0xfc, 0x01, 0xfd,  //@@@....+@@@+
    0xff, 0xff, 0xf4,  //@@@@@@@@@@+.
    0xff, 0xff, 0x80,  //@@@@@@@@%...
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0051 (Q) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x1b, 0xfe, 0x40, 0x00,  //.....+%@@@@%+.....
    0x01, 0xff, 0xff, 0xf4, 0x00,  //...+@@@@@@@@@@+...
    0x07, 0xf8, 0x02, 0xfd, 0x00,  //..+@@@%....%@@@+..
    0x1f, 0xc0, 0x00, 0x3f, 0x40,  //.+@@@........@@@..
    0x3f, 0x40, 0x00, 0x1f, 0xc0,  //.@@@+........+@@@.
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........%@@+
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xfc, 0x00, 0x00, 0x03, 0xf0,  //@@@............@@@
    0xbd, 0x00, 0x00, 0x07, 0xe0,  //%@@+..........+@@%
    0x7f, 0x00, 0x00, 0x0f, 0xd0,  //+@@@..........%@@+
    0x3f, 0x40, 0x00, 0x1f, 0xc0,  //.@@@+........+@@@.
    0x1f, 0xc0, 0x00, 0x3f, 0x00,  //.+@@@........@@@..
    0x07, 0xf8, 0x02, 0xfd, 0x00,  //..+@@@%....%@@@+..
    0x01, 0xff, 0xff, 0xf0, 0x00,  //...+@@@@@@@@@@....
    0x00, 0x1b, 0xff, 0xc0, 0x00,  //.....+%@@@@@@.....
    0x00, 0x00, 0x03, 0xe0, 0x00,  //...........@@%....
    0x00, 0x00, 0x00, 0xf8, 0x00,  //............@@%...
    0x00, 0x00, 0x00, 0x3e, 0x00,  //.............@@%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0052 (R) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0x80, 0x00,  //@@@@@@@@%......
    0xff, 0xff, 0xf8, 0x00,  //@@@@@@@@@@%....
    0xfc, 0x01, 0xfd, 0x00,  //@@@....+@@@+...
    0xfc, 0x00, 0x7e, 0x00,  //@@@.....+@@%...
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@...
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@...
    0xfc, 0x00, 0x3f, 0x00,  //@@@......@@@...
    0xfc, 0x00, 0x7e, 0x00,  //@@@.....+@@%...
    0xfc, 0x01, 0xfc, 0x00,  //@@@....+@@@....
    0xff, 0xff, 0xe0, 0x00,  //@@@@@@@@@%.....
    0xff, 0xff, 0xd0, 0x00,  //@@@@@@@@@+.....
    0xfc, 0x07, 0xf4, 0x00,  //@@@...+@@@+....
    0xfc, 0x01, 0xfc, 0x00,  //@@@....+@@@....
    0xfc, 0x00, 0xbe, 0x00,  //@@@.....%@@%...
    0xfc, 0x00, 0x3f, 0x40,  //@@@......@@@+..
    0xfc, 0x00, 0x2f, 0xc0,  //@@@......%@@@..
    0xfc, 0x00, 0x0f, 0xe0,  //@@@.......@@@+.
    0xfc, 0x00, 0x07, 0xf0,  //@@@.......+@@@.
    0xfc, 0x00, 0x03, 0xf8,  //@@@........@@@%
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0053 (S) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x02, 0xff, 0xe4, 0x00,  //...%@@@@@%+..
    0x1f, 0xff, 0xff, 0x00,  //.+@@@@@@@@@@.
    0x3f, 0x80, 0x2f, 0x00,  //.@@@%....%@@.
    0xbd, 0x00, 0x02, 0x00,  //%@@+.......%.
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfe, 0x00, 0x00, 0x00,  //@@@%.........
    0xbf, 0xe9, 0x00, 0x00,  //+@@@@%%+.....
    0x2f, 0xff, 0xe4, 0x00,  //.%@@@@@@@%+..
    0x07, 0xff, 0xfe, 0x00,  //..+@@@@@@@@+.
    0x00, 0x1b, 0xff, 0x40,  //.....+%@@@@@+
    0x00, 0x00, 0x3f, 0x80,  //.........@@@%
    0x00, 0x00, 0x1f, 0xc0,  //.........+@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x80, 0x00, 0x2f, 0x80,  //%........%@@%
    0xf9, 0x00, 0xbf, 0x00,  //@@%+....%@@@.
    0xff, 0xff, 0xfd, 0x00,  //@@@@@@@@@@@+.
    0x1b, 0xff, 0x90, 0x00,  //.+%@@@@@%+...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0054 (T) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0055 (U) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xfc, 0x00, 0x03, 0xf0,  //@@@........@@@
    0xbd, 0x00, 0x07, 0xe0,  //%@@+......+@@%
    0x7f, 0x00, 0x0f, 0xd0,  //+@@@......@@@+
    0x2f, 0x80, 0x3f, 0x80,  //.%@@%....%@@%.
    0x0b, 0xff, 0xfe, 0x00,  //..%@@@@@@@@%..
    0x01, 0xbf, 0xe4, 0x00,  //...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0056 (V) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xfd, 0x00, 0x00, 0x1f, 0xc0,  //@@@+.........+@@@
    0x7f, 0x00, 0x00, 0x3f, 0x40,  //+@@%.........@@@+
    0x3f, 0x00, 0x00, 0x3f, 0x00,  //.@@@.........@@@.
    0x2f, 0x80, 0x00, 0xbe, 0x00,  //.%@@+.......+@@%.
    0x1f, 0xc0, 0x00, 0xfd, 0x00,  //.+@@@.......@@@+.
    0x0f, 0xc0, 0x01, 0xfc, 0x00,  //..@@@.......@@@..
    0x0b, 0xe0, 0x02, 0xf8, 0x00,  //..%@@%.....%@@%..
    0x03, 0xf0, 0x03, 0xf0, 0x00,  //...@@@.....@@@...
    0x03, 0xf4, 0x07, 0xf0, 0x00,  //...@@@+...+@@@...
    0x01, 0xf8, 0x0b, 0xd0, 0x00,  //...+@@%...%@@+...
    0x00, 0xfc, 0x0f, 0xc0, 0x00,  //....@@@...@@@....
    0x00, 0xbd, 0x1f, 0x80, 0x00,  //....%@@+.+@@%....
    0x00, 0x7f, 0x3f, 0x40, 0x00,  //....+@@@.@@@+....
    0x00, 0x3f, 0x7f, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x07, 0xf4, 0x00, 0x00,  //......+@@@+......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0057 (W) , Width: 24 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0xfc, 0x00, 0x0b, 0xe0, 0x00, 0x3f,  //@@@.......%@@%.......@@@
    0xbd, 0x00, 0x0f, 0xf0, 0x00, 0x7e,  //%@@+......@@@@......+@@%
    0x7e, 0x00, 0x0f, 0xf0, 0x00, 0xbd,  //+@@%......@@@@......%@@+
    0x3f, 0x00, 0x1f, 0xb4, 0x00, 0xfc,  //.@@@.....+@@%@+.....@@@.
    0x3f, 0x00, 0x2e, 0x78, 0x00, 0xfc,  //.@@@.....%@%+@%.....@@@.
    0x2f, 0x40, 0x3d, 0x7c, 0x01, 0xf8,  //.%@@+....@@+.@@....+@@%.
    0x1f, 0x80, 0x3c, 0x3c, 0x02, 0xf4,  //.+@@%....@@..@@....%@@+.
    0x0f, 0xc0, 0x7c, 0x3d, 0x03, 0xf0,  //..@@@...+@@..@@+...@@@..
    0x0f, 0xc0, 0xb8, 0x2e, 0x03, 0xf0,  //..@@@...%@%..%@%...@@@..
    0x0b, 0xd0, 0xf4, 0x1f, 0x07, 0xe0,  //..%@@+..%@+..+@@..+@@%..
    0x07, 0xe0, 0xf0, 0x0f, 0x0b, 0xd0,  //..+@@%..@@....@@..%@@+..
    0x03, 0xf0, 0xf0, 0x0f, 0x4f, 0xc0,  //...@@@..@@....@@..@@@...
    0x03, 0xf1, 0xe0, 0x0b, 0x4f, 0xc0,  //...@@@.+@%....%@+.@@@...
    0x02, 0xf6, 0xd0, 0x07, 0x9f, 0x80,  //...%@@+%@+....+@%+@@%...
    0x01, 0xfb, 0xc0, 0x03, 0xef, 0x40,  //...+@@%@@......@@%@@+...
    0x00, 0xff, 0xc0, 0x03, 0xff, 0x00,  //....@@@@@......@@@@@....
    0x00, 0xff, 0x80, 0x02, 0xff, 0x00,  //....@@@@%......%@@@@....
    0x00, 0xbf, 0x40, 0x01, 0xfe, 0x00,  //....%@@@+......+@@@%....
    0x00, 0x7f, 0x00, 0x00, 0xfd, 0x00,  //....+@@@........@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................


    /*Unicode: U+0058 (X) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x2f, 0xc0, 0x00, 0xfe,  //.%@@@.......@@@%
    0x0f, 0xe0, 0x02, 0xfc,  //..@@@+.....%@@@.
    0x07, 0xf0, 0x03, 0xf4,  //..+@@@.....@@@+.
    0x03, 0xf8, 0x0f, 0xe0,  //...@@@%...@@@%..
    0x01, 0xfd, 0x2f, 0xc0,  //...+@@@+.%@@@...
    0x00, 0xbf, 0x3f, 0x40,  //....%@@@.@@@+...
    0x00, 0x3f, 0xff, 0x00,  //.....@@@@@@%....
    0x00, 0x1f, 0xfc, 0x00,  //.....+@@@@@.....
    0x00, 0x0f, 0xf4, 0x00,  //......@@@@+.....
    0x00, 0x0f, 0xf4, 0x00,  //......@@@@+.....
    0x00, 0x1f, 0xfc, 0x00,  //.....+@@@@@.....
    0x00, 0x3f, 0xfd, 0x00,  //.....@@@@@@+....
    0x00, 0xff, 0x7f, 0x00,  //....%@@@+@@@....
    0x01, 0xfc, 0x3f, 0x80,  //...+@@@..@@@%...
    0x03, 0xf8, 0x0f, 0xd0,  //...@@@%...@@@+..
    0x0b, 0xf0, 0x0b, 0xf0,  //..%@@@....%@@@..
    0x1f, 0xd0, 0x03, 0xf4,  //.+@@@......@@@+.
    0x3f, 0x80, 0x01, 0xfc,  //.@@@%......+@@@.
    0xbf, 0x00, 0x00, 0xfe,  //%@@@........@@@%
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0059 (Y) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xbf, 0x00, 0x00, 0x3f, 0x80,  //%@@@.........@@@%
    0x3f, 0x80, 0x00, 0xbf, 0x00,  //.@@@%.......%@@@.
    0x0f, 0xd0, 0x01, 0xfc, 0x00,  //..@@@+.....+@@@..
    0x0b, 0xf0, 0x03, 0xf8, 0x00,  //..%@@@.....@@@%..
    0x03, 0xfc, 0x0f, 0xf0, 0x00,  //...@@@@...@@@@...
    0x00, 0xfe, 0x2f, 0xc0, 0x00,  //....@@@%.%@@@....
    0x00, 0x7f, 0x7f, 0x40, 0x00,  //....+@@@+@@@+....
    0x00, 0x2f, 0xfe, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x0f, 0xfc, 0x00, 0x00,  //......@@@@@......
    0x00, 0x07, 0xf4, 0x00, 0x00,  //......+@@@+......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x03, 0xf0, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+005a (Z) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0x00, 0x00, 0x03, 0xf8,  //...........@@@%
    0x00, 0x00, 0x0f, 0xf0,  //..........@@@@.
    0x00, 0x00, 0x2f, 0xc0,  //.........%@@@..
    0x00, 0x00, 0x7f, 0x40,  //........+@@@+..
    0x00, 0x00, 0xfe, 0x00,  //........@@@%...
    0x00, 0x03, 0xfc, 0x00,  //.......@@@@....
    0x00, 0x0b, 0xf0, 0x00,  //......%@@@.....
    0x00, 0x1f, 0xd0, 0x00,  //.....+@@@+.....
    0x00, 0x3f, 0x80, 0x00,  //.....@@@%......
    0x00, 0xff, 0x00, 0x00,  //....@@@@.......
    0x02, 0xfc, 0x00, 0x00,  //...%@@@........
    0x07, 0xf4, 0x00, 0x00,  //..+@@@+........
    0x0f, 0xe0, 0x00, 0x00,  //..@@@%.........
    0x3f, 0xc0, 0x00, 0x00,  //.@@@@..........
    0xbf, 0x00, 0x00, 0x00,  //%@@@...........
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+005b ([) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0xff, 0xf0,  //@@@@@@
    0xff, 0xf0,  //@@@@@@
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xfc, 0x00,  //@@@...
    0xff, 0xf0,  //@@@@@@
    0xff, 0xf0,  //@@@@@@
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+005c (\) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xf4, 0x00, 0x00,  //@@+......
    0xb8, 0x00, 0x00,  //+@%......
    0x3c, 0x00, 0x00,  //.@@......
    0x3d, 0x00, 0x00,  //.@@......
    0x2e, 0x00, 0x00,  //.%@%.....
    0x0f, 0x00, 0x00,  //..@@.....
    0x0f, 0x00, 0x00,  //..@@.....
    0x0b, 0x80, 0x00,  //..%@%....
    0x03, 0xc0, 0x00,  //...@@....
    0x03, 0xc0, 0x00,  //...@@....
    0x02, 0xe0, 0x00,  //...%@%...
    0x00, 0xf0, 0x00,  //....@@...
    0x00, 0xf0, 0x00,  //....@@...
    0x00, 0xb8, 0x00,  //....%@%..
    0x00, 0x3c, 0x00,  //.....@@..
    0x00, 0x3c, 0x00,  //.....@@..
    0x00, 0x2e, 0x00,  //.....%@%.
    0x00, 0x1f, 0x00,  //......@@.
    0x00, 0x0f, 0x00,  //......@@.
    0x00, 0x0b, 0x80,  //......%@+
    0x00, 0x07, 0xc0,  //......+@@
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+005d (]) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0xff, 0xf0,  //@@@@@@
    0xff, 0xf0,  //@@@@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0x03, 0xf0,  //...@@@
    0xff, 0xf0,  //@@@@@@
    0xff, 0xf0,  //@@@@@@
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+005e (^) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x0b, 0xe0, 0x00,  //......%@@%......
    0x00, 0x2f, 0xf8, 0x00,  //.....%@@@@%.....
    0x00, 0xbd, 0x7e, 0x00,  //....%@@++@@%....
    0x02, 0xf4, 0x1f, 0x80,  //...%@@+..+@@%...
    0x0b, 0xd0, 0x07, 0xe0,  //..%@@+....+@@%..
    0x2f, 0x00, 0x00, 0xf8,  //.%@@........@@%.
    0xbc, 0x00, 0x00, 0x3e,  //%@@..........@@%
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+005f (_) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@


    /*Unicode: U+0060 (`) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0xbc, 0x00,  //%@@...
    0x3e, 0x00,  //.%@%..
    0x0f, 0x00,  //..@@..
    0x03, 0xc0,  //...@@.
    0x01, 0xe0,  //...+@%
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+0061 (a) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x06, 0xff, 0x80,  //..+%@@@@%...
    0x3f, 0xff, 0xf4,  //.@@@@@@@@@+.
    0x34, 0x01, 0xfc,  //.@+....+@@@.
    0x00, 0x00, 0x7e,  //........+@@%
    0x00, 0x00, 0x3f,  //.........@@@
    0x06, 0xff, 0xff,  //..+%@@@@@@@@
    0x2f, 0xff, 0xff,  //.%@@@@@@@@@@
    0xbf, 0x40, 0x3f,  //+@@@+....@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x7f,  //@@@.....+@@@
    0xfc, 0x00, 0xff,  //@@@.....@@@@
    0xbf, 0x02, 0xbf,  //%@@@...%%@@@
    0x3f, 0xff, 0x3f,  //.@@@@@@@.@@@
    0x0b, 0xf8, 0x3f,  //..%@@@%..@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0062 (b) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x2f, 0xe0, 0x00,  //@@@..%@@@%...
    0xfc, 0xff, 0xfc, 0x00,  //@@@.@@@@@@@..
    0xfe, 0x80, 0xbf, 0x00,  //@@@%%...%@@@.
    0xff, 0x00, 0x3f, 0x40,  //@@@@.....@@@+
    0xfd, 0x00, 0x1f, 0x80,  //@@@+.....+@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfd, 0x00, 0x1f, 0x80,  //@@@+.....+@@%
    0xff, 0x00, 0x3f, 0x40,  //@@@@.....@@@+
    0xfe, 0x80, 0xbf, 0x00,  //@@@%%...%@@@.
    0xfc, 0xff, 0xfc, 0x00,  //@@@.@@@@@@@..
    0xfc, 0x2f, 0xe0, 0x00,  //@@@..%@@@%...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0063 (c) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0xbf, 0xe0,  //....%@@@@%.
    0x0b, 0xff, 0xfc,  //..%@@@@@@@@
    0x2f, 0xd0, 0x1c,  //.%@@@+...+%
    0x7f, 0x00, 0x00,  //.@@@.......
    0xbd, 0x00, 0x00,  //%@@+.......
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xbd, 0x00, 0x00,  //%@@+.......
    0x3f, 0x00, 0x00,  //.@@@.......
    0x2f, 0xd0, 0x1c,  //.%@@@+...+%
    0x0b, 0xff, 0xfc,  //..%@@@@@@@@
    0x01, 0xbf, 0xe0,  //...+%@@@@%.
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0064 (d) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x02, 0xfe, 0x0f, 0xc0,  //...%@@@%..@@@
    0x0f, 0xff, 0xcf, 0xc0,  //..@@@@@@@.@@@
    0x3f, 0x80, 0xaf, 0xc0,  //.@@@%...%%@@@
    0x7f, 0x00, 0x3f, 0xc0,  //+@@@.....@@@@
    0xbd, 0x00, 0x1f, 0xc0,  //%@@+.....+@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xbd, 0x00, 0x1f, 0xc0,  //%@@+.....+@@@
    0x7f, 0x00, 0x3f, 0xc0,  //+@@@.....@@@@
    0x3f, 0x80, 0xaf, 0xc0,  //.@@@%...%%@@@
    0x0f, 0xff, 0xcf, 0xc0,  //..@@@@@@@.@@@
    0x02, 0xfe, 0x0f, 0xc0,  //...%@@@%..@@@
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0065 (e) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0xbf, 0xd0, 0x00,  //....%@@@@+...
    0x0b, 0xff, 0xfc, 0x00,  //..%@@@@@@@@..
    0x2f, 0xc0, 0xbf, 0x00,  //.%@@@...%@@@.
    0x3f, 0x00, 0x2f, 0x40,  //.@@@.....%@@+
    0xbd, 0x00, 0x0f, 0x80,  //%@@+......@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xbd, 0x00, 0x00, 0x00,  //%@@+.........
    0x7f, 0x00, 0x00, 0x00,  //.@@@.........
    0x2f, 0xd0, 0x07, 0x00,  //.%@@@+....+@.
    0x0b, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0xbf, 0xe4, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0066 (f) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0xbf, 0xc0,  //....%@@@@
    0x03, 0xff, 0xc0,  //...@@@@@@
    0x0b, 0xe0, 0x00,  //..%@@%...
    0x0f, 0xc0, 0x00,  //..@@@....
    0x0f, 0xc0, 0x00,  //..@@@....
    0x0f, 0xc0, 0x00,  //..@@@....
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0x0f, 0xc0, 0x00,  //..@@@....
    0x0f, 0xc0, 0x00,  //..@@@....
    0x0f, 0xc0, 0x00,  //..@@@....
    0x0f, 0xc0, 0x00,  //..@@@....
    0x0f, 0xc0, 0x00,  //..@@@....
    0x0f, 0xc0, 0x00,  //..@@@....
    0x0f, 0xc0, 0x00,  //..@@@....
    0x0f, 0xc0, 0x00,  //..@@@....
    0x0f, 0xc0, 0x00,  //..@@@....
    0x0f, 0xc0, 0x00,  //..@@@....
    0x0f, 0xc0, 0x00,  //..@@@....
    0x0f, 0xc0, 0x00,  //..@@@....
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0067 (g) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x02, 0xfe, 0x0f, 0xc0,  //...%@@@%..@@@
    0x0f, 0xff, 0xcf, 0xc0,  //..@@@@@@@.@@@
    0x3f, 0x80, 0xaf, 0xc0,  //.@@@%...%%@@@
    0x7f, 0x00, 0x3f, 0xc0,  //+@@@.....@@@@
    0xbd, 0x00, 0x1f, 0xc0,  //%@@+.....+@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xbd, 0x00, 0x1f, 0xc0,  //%@@+.....+@@@
    0x7f, 0x00, 0x3f, 0xc0,  //+@@@.....@@@@
    0x3f, 0x80, 0xaf, 0xc0,  //.@@@%...%%@@@
    0x0f, 0xff, 0xcf, 0xc0,  //..@@@@@@@.@@@
    0x02, 0xfe, 0x0f, 0xc0,  //...%@@@%..@@@
    0x00, 0x00, 0x1f, 0x80,  //.........+@@%
    0x00, 0x00, 0x2f, 0x40,  //.........%@@+
    0x0d, 0x01, 0xbf, 0x00,  //..@+....%@@@.
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x02, 0xff, 0xd0, 0x00,  //...%@@@@@+...
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0068 (h) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x00, 0x00,  //@@@.........
    0xfc, 0x2f, 0xd0,  //@@@..%@@@+..
    0xfc, 0xff, 0xf8,  //@@@.@@@@@@%.
    0xfe, 0x81, 0xfd,  //@@@%%..+@@@+
    0xff, 0x00, 0x7e,  //@@@@....+@@%
    0xfd, 0x00, 0x3f,  //@@@+.....@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0069 (i) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+006a (j) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x0f, 0xc0,  //..@@@
    0x2f, 0x80,  //.%@@%
    0xff, 0x00,  //@@@@.
    0xf8, 0x00,  //@@%..
    0x00, 0x00,  //.....


    /*Unicode: U+006b (k) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0xff, 0x40,  //@@@.....@@@@+
    0xfc, 0x07, 0xfd, 0x00,  //@@@...+@@@@+.
    0xfc, 0x1f, 0xf0, 0x00,  //@@@..+@@@@...
    0xfc, 0xbf, 0xc0, 0x00,  //@@@.%@@@@....
    0xfe, 0xfe, 0x00, 0x00,  //@@@%@@@%.....
    0xff, 0xf8, 0x00, 0x00,  //@@@@@@%......
    0xff, 0xe0, 0x00, 0x00,  //@@@@@%.......
    0xff, 0xf4, 0x00, 0x00,  //@@@@@@+......
    0xff, 0xfd, 0x00, 0x00,  //@@@@@@@+.....
    0xfc, 0xff, 0x40, 0x00,  //@@@.@@@@+....
    0xfc, 0x3f, 0xd0, 0x00,  //@@@..@@@@+...
    0xfc, 0x0f, 0xf4, 0x00,  //@@@...@@@@+..
    0xfc, 0x03, 0xfd, 0x00,  //@@@....%@@@+.
    0xfc, 0x00, 0xbf, 0x40,  //@@@.....%@@@+
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+006c (l) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+006d (m) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xfc, 0x2f, 0xd0, 0x0b, 0xf4, 0x00,  //@@@..%@@@+....%@@@+..
    0xfc, 0xff, 0xf4, 0x3f, 0xfe, 0x00,  //@@@.@@@@@@+..@@@@@@%.
    0xfe, 0x81, 0xfc, 0xe0, 0x7f, 0x40,  //@@@%%..+@@@.@%..+@@@+
    0xff, 0x00, 0x7f, 0xc0, 0x1f, 0x80,  //@@@@....+@@@@....+@@%
    0xfd, 0x00, 0x3f, 0x40, 0x0f, 0xc0,  //@@@+.....@@@+.....@@@
    0xfc, 0x00, 0x3f, 0x00, 0x0f, 0xc0,  //@@@......@@@......@@@
    0xfc, 0x00, 0x3f, 0x00, 0x0f, 0xc0,  //@@@......@@@......@@@
    0xfc, 0x00, 0x3f, 0x00, 0x0f, 0xc0,  //@@@......@@@......@@@
    0xfc, 0x00, 0x3f, 0x00, 0x0f, 0xc0,  //@@@......@@@......@@@
    0xfc, 0x00, 0x3f, 0x00, 0x0f, 0xc0,  //@@@......@@@......@@@
    0xfc, 0x00, 0x3f, 0x00, 0x0f, 0xc0,  //@@@......@@@......@@@
    0xfc, 0x00, 0x3f, 0x00, 0x0f, 0xc0,  //@@@......@@@......@@@
    0xfc, 0x00, 0x3f, 0x00, 0x0f, 0xc0,  //@@@......@@@......@@@
    0xfc, 0x00, 0x3f, 0x00, 0x0f, 0xc0,  //@@@......@@@......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+006e (n) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xfc, 0x2f, 0xd0,  //@@@..%@@@+..
    0xfc, 0xff, 0xf8,  //@@@.@@@@@@%.
    0xfe, 0x81, 0xfd,  //@@@%%..+@@@+
    0xff, 0x00, 0x7e,  //@@@@....+@@%
    0xfd, 0x00, 0x3f,  //@@@+.....@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+006f (o) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x2f, 0x80, 0xbe, 0x00,  //.%@@%...%@@%.
    0x7f, 0x00, 0x3f, 0x40,  //+@@@.....@@@+
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xbd, 0x00, 0x1f, 0x80,  //%@@+.....+@@%
    0x7f, 0x00, 0x3f, 0x40,  //+@@@.....@@@+
    0x2f, 0x80, 0xbe, 0x00,  //.%@@%...%@@%.
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x01, 0xbf, 0x90, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0070 (p) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0xfc, 0x2f, 0xe0, 0x00,  //@@@..%@@@%...
    0xfc, 0xff, 0xfc, 0x00,  //@@@.@@@@@@@..
    0xfe, 0x80, 0xbf, 0x00,  //@@@%%...%@@@.
    0xff, 0x00, 0x3f, 0x40,  //@@@@.....@@@+
    0xfd, 0x00, 0x1f, 0x80,  //@@@+.....+@@%
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfd, 0x00, 0x1f, 0x80,  //@@@+.....+@@%
    0xff, 0x00, 0x3f, 0x40,  //@@@@.....@@@+
    0xfe, 0x80, 0xbf, 0x00,  //@@@%%...%@@@.
    0xfc, 0xff, 0xfc, 0x00,  //@@@.@@@@@@@..
    0xfc, 0x2f, 0xe0, 0x00,  //@@@..%@@@%...
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0xfc, 0x00, 0x00, 0x00,  //@@@..........
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0071 (q) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x02, 0xfe, 0x0f, 0xc0,  //...%@@@%..@@@
    0x0f, 0xff, 0xcf, 0xc0,  //..@@@@@@@.@@@
    0x3f, 0x80, 0xaf, 0xc0,  //.@@@%...%%@@@
    0x7f, 0x00, 0x3f, 0xc0,  //+@@@.....@@@@
    0xbd, 0x00, 0x1f, 0xc0,  //%@@+.....+@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xfc, 0x00, 0x0f, 0xc0,  //@@@.......@@@
    0xbd, 0x00, 0x1f, 0xc0,  //%@@+.....+@@@
    0x7f, 0x00, 0x3f, 0xc0,  //+@@@.....@@@@
    0x3f, 0x80, 0xaf, 0xc0,  //.@@@%...%%@@@
    0x0f, 0xff, 0xcf, 0xc0,  //..@@@@@@@.@@@
    0x02, 0xfe, 0x0f, 0xc0,  //...%@@@%..@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x0f, 0xc0,  //..........@@@
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0072 (r) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xfc, 0x2f,  //@@@..%@@
    0xfc, 0xff,  //@@@.@@@@
    0xfe, 0x80,  //@@@%%...
    0xff, 0x00,  //@@@@....
    0xfd, 0x00,  //@@@+....
    0xfc, 0x00,  //@@@.....
    0xfc, 0x00,  //@@@.....
    0xfc, 0x00,  //@@@.....
    0xfc, 0x00,  //@@@.....
    0xfc, 0x00,  //@@@.....
    0xfc, 0x00,  //@@@.....
    0xfc, 0x00,  //@@@.....
    0xfc, 0x00,  //@@@.....
    0xfc, 0x00,  //@@@.....
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0073 (s) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x0b, 0xff, 0x80,  //..+@@@@@%..
    0x3f, 0xff, 0xf0,  //.@@@@@@@@@.
    0xbf, 0x00, 0x70,  //%@@@....+%.
    0xfc, 0x00, 0x00,  //@@@........
    0xfc, 0x00, 0x00,  //@@@........
    0xbf, 0xa4, 0x00,  //%@@@+%+....
    0x3f, 0xff, 0x80,  //.@@@@@@@%..
    0x06, 0xff, 0xf0,  //..+%@@@@@@.
    0x00, 0x07, 0xf8,  //......+@@@%
    0x00, 0x00, 0xfc,  //........@@@
    0x00, 0x00, 0xfc,  //........@@@
    0xd0, 0x03, 0xf8,  //@+.....@@@%
    0xff, 0xff, 0xf0,  //@@@@@@@@@@.
    0x1b, 0xfe, 0x40,  //.+%@@@@%+..
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0074 (t) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x0f, 0xc0, 0x00,  //..@@@.....
    0x0f, 0xc0, 0x00,  //..@@@.....
    0x0f, 0xc0, 0x00,  //..@@@.....
    0x0f, 0xc0, 0x00,  //..@@@.....
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0x0f, 0xc0, 0x00,  //..@@@.....
    0x0f, 0xc0, 0x00,  //..@@@.....
    0x0f, 0xc0, 0x00,  //..@@@.....
    0x0f, 0xc0, 0x00,  //..@@@.....
    0x0f, 0xc0, 0x00,  //..@@@.....
    0x0f, 0xc0, 0x00,  //..@@@.....
    0x0f, 0xc0, 0x00,  //..@@@.....
    0x0f, 0xc0, 0x00,  //..@@@.....
    0x0f, 0xc0, 0x00,  //..@@@.....
    0x0b, 0xe0, 0x00,  //..%@@%....
    0x03, 0xff, 0xf0,  //...@@@@@@@
    0x00, 0xbf, 0xf0,  //....%@@@@@
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0075 (u) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x3f,  //@@@......@@@
    0xfc, 0x00, 0x7f,  //@@@.....+@@@
    0xbd, 0x00, 0xff,  //%@@+....@@@@
    0x7f, 0x42, 0xbf,  //+@@@+..%%@@@
    0x2f, 0xff, 0x3f,  //.%@@@@@@.@@@
    0x07, 0xf8, 0x3f,  //..+@@@%..@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0076 (v) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xfd, 0x00, 0x07, 0xf0,  //@@@+......+@@@
    0x7f, 0x00, 0x0f, 0xd0,  //+@@@......@@@+
    0x3f, 0x00, 0x0f, 0xc0,  //.@@@......@@@.
    0x2f, 0x80, 0x2f, 0x80,  //.%@@%....%@@%.
    0x1f, 0xc0, 0x3f, 0x40,  //.+@@@....@@@+.
    0x0f, 0xd0, 0x7f, 0x00,  //..@@@+..+@@@..
    0x07, 0xe0, 0xbd, 0x00,  //..+@@%..%@@+..
    0x03, 0xf0, 0xfc, 0x00,  //...@@@..@@@...
    0x02, 0xf5, 0xf8, 0x00,  //...%@@++@@%...
    0x01, 0xff, 0xf4, 0x00,  //...+@@@@@@+...
    0x00, 0xff, 0xf0, 0x00,  //....@@@@@@....
    0x00, 0xbf, 0xe0, 0x00,  //....%@@@@%....
    0x00, 0x3f, 0xc0, 0x00,  //.....@@@@.....
    0x00, 0x3f, 0xc0, 0x00,  //.....@@@@.....
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0077 (w) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xfc, 0x00, 0xfc, 0x00, 0xfc,  //@@@.....@@@.....@@@
    0xbe, 0x01, 0xfd, 0x02, 0xf8,  //%@@+...+@@@+...+@@%
    0x7f, 0x02, 0xfe, 0x03, 0xf4,  //+@@@...%@@@%...@@@+
    0x3f, 0x03, 0xdf, 0x03, 0xf0,  //.@@@...@@+@@...@@@.
    0x3f, 0x43, 0xcf, 0x07, 0xf0,  //.@@@+..@@.@@..+@@@.
    0x2f, 0x87, 0x8b, 0x4b, 0xe0,  //.%@@%.+@%.%@+.%@@%.
    0x1f, 0xcb, 0x47, 0x8f, 0xd0,  //.+@@@.%@+.+@%.@@@+.
    0x0f, 0xcf, 0x03, 0xcf, 0xc0,  //..@@@.@@...@@.@@@..
    0x0f, 0xef, 0x03, 0xef, 0x80,  //..%@@%@@...@@%@@%..
    0x07, 0xfe, 0x02, 0xff, 0x40,  //..+@@@@%...%@@@@+..
    0x03, 0xfd, 0x01, 0xff, 0x00,  //...@@@@+...+@@@@...
    0x03, 0xfc, 0x00, 0xff, 0x00,  //...@@@@.....@@@@...
    0x02, 0xfc, 0x00, 0xfe, 0x00,  //...%@@@.....@@@%...
    0x01, 0xf8, 0x00, 0xbd, 0x00,  //...+@@%.....%@@+...
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0078 (x) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xbf, 0x40, 0x1f, 0xe0,  //%@@@+....+@@@%
    0x3f, 0xc0, 0x3f, 0xc0,  //.%@@@....@@@@.
    0x0f, 0xf0, 0xff, 0x00,  //..@@@@..@@@@..
    0x03, 0xfa, 0xfc, 0x00,  //...@@@%%@@@...
    0x01, 0xff, 0xf4, 0x00,  //...+@@@@@@+...
    0x00, 0xbf, 0xe0, 0x00,  //....%@@@@%....
    0x00, 0x3f, 0x80, 0x00,  //.....@@@%.....
    0x00, 0x3f, 0xc0, 0x00,  //.....@@@@.....
    0x00, 0xff, 0xf0, 0x00,  //....@@@@@%....
    0x02, 0xff, 0xf8, 0x00,  //...%@@@@@@%...
    0x07, 0xf5, 0xfd, 0x00,  //..+@@@++@@@+..
    0x0f, 0xe0, 0xbf, 0x00,  //..@@@%..%@@@..
    0x3f, 0xc0, 0x3f, 0xc0,  //.@@@@....@@@@.
    0xbf, 0x00, 0x0f, 0xe0,  //%@@@......@@@%
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0079 (y) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xfd, 0x00, 0x07, 0xf0,  //@@@+......+@@@
    0x7f, 0x00, 0x0f, 0xd0,  //+@@@......@@@+
    0x3f, 0x40, 0x1f, 0xc0,  //.@@@+....+@@@.
    0x2f, 0x80, 0x3f, 0x40,  //.%@@%....@@@+.
    0x0f, 0xc0, 0x3f, 0x00,  //..@@@....@@@..
    0x0b, 0xd0, 0xbe, 0x00,  //..%@@+..%@@%..
    0x07, 0xf0, 0xfc, 0x00,  //..+@@@..@@@...
    0x03, 0xf6, 0xfc, 0x00,  //...@@@++@@%...
    0x02, 0xfb, 0xf4, 0x00,  //...+@@%@@@+...
    0x00, 0xff, 0xf0, 0x00,  //....@@@@@@....
    0x00, 0xbf, 0xd0, 0x00,  //....%@@@@+....
    0x00, 0x7f, 0xc0, 0x00,  //....+@@@@.....
    0x00, 0x3f, 0x80, 0x00,  //.....@@@%.....
    0x00, 0x3f, 0x00, 0x00,  //.....@@@......
    0x00, 0xbe, 0x00, 0x00,  //....%@@%......
    0x00, 0xfd, 0x00, 0x00,  //....@@@+......
    0x02, 0xfc, 0x00, 0x00,  //...%@@@.......
    0x3f, 0xf0, 0x00, 0x00,  //.@@@@@........
    0x3f, 0x80, 0x00, 0x00,  //.@@@%.........
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+007a (z) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0x00, 0x03, 0xf8,  //.......@@@%
    0x00, 0x0b, 0xf0,  //......%@@@.
    0x00, 0x1f, 0xd0,  //.....+@@@+.
    0x00, 0x3f, 0x80,  //.....@@@%..
    0x00, 0xff, 0x00,  //....@@@@...
    0x02, 0xfc, 0x00,  //...%@@@....
    0x07, 0xf4, 0x00,  //..+@@@+....
    0x0f, 0xe0, 0x00,  //..@@@%.....
    0x3f, 0xc0, 0x00,  //.@@@@......
    0xbf, 0x00, 0x00,  //%@@@.......
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+007b ({) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x0b, 0xfc,  //......%@@@@
    0x00, 0x3f, 0xfc,  //.....@@@@@@
    0x00, 0xbe, 0x00,  //....%@@%...
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x01, 0xfc, 0x00,  //....@@@....
    0x03, 0xf4, 0x00,  //...@@@+....
    0xff, 0xd0, 0x00,  //@@@@@+.....
    0xff, 0xd0, 0x00,  //@@@@@+.....
    0x07, 0xf4, 0x00,  //..+@@@+....
    0x01, 0xfc, 0x00,  //...+@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xbe, 0x00,  //....%@@%...
    0x00, 0x3f, 0xfc,  //.....@@@@@@
    0x00, 0x0b, 0xfc,  //......%@@@@
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+007c (|) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@


    /*Unicode: U+007d (}) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xff, 0x80, 0x00,  //@@@@%......
    0xff, 0xf0, 0x00,  //@@@@@@.....
    0x02, 0xf8, 0x00,  //...%@@%....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfd, 0x00,  //....@@@....
    0x00, 0x7f, 0x00,  //....+@@@...
    0x00, 0x1f, 0xfc,  //.....+@@@@@
    0x00, 0x1f, 0xfc,  //.....+@@@@@
    0x00, 0x7f, 0x40,  //....+@@@+..
    0x00, 0xfd, 0x00,  //....@@@+...
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x00, 0xfc, 0x00,  //....@@@....
    0x02, 0xf8, 0x00,  //...%@@%....
    0xff, 0xf0, 0x00,  //@@@@@@.....
    0xff, 0x80, 0x00,  //@@@@%......
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+007e (~) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x0b, 0xf9, 0x00, 0x03,  //..%@@@%+.......@
    0x7f, 0xff, 0xd0, 0x1f,  //+@@@@@@@@+...+@@
    0xf4, 0x07, 0xff, 0xfd,  //@@+...+@@@@@@@@+
    0x80, 0x00, 0x6f, 0xe0,  //%.......+%@@@%..
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................



#elif USE_LV_FONT_DEJAVU_30 == 4
    /*Unicode: U+0020 ( ) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0021 (!) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xef, 0xe0,  //@@@
    0xdf, 0xd0,  //@@@
    0xcf, 0xc0,  //@@@
    0xbf, 0xb0,  //%@%
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0022 (") , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0x00, 0x0f, 0xf0,  //@@...@@
    0xff, 0x00, 0x0f, 0xf0,  //@@...@@
    0xff, 0x00, 0x0f, 0xf0,  //@@...@@
    0xff, 0x00, 0x0f, 0xf0,  //@@...@@
    0xff, 0x00, 0x0f, 0xf0,  //@@...@@
    0xff, 0x00, 0x0f, 0xf0,  //@@...@@
    0xff, 0x00, 0x0f, 0xf0,  //@@...@@
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0023 (#) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x0b, 0xf5, 0x00, 0x0d, 0xf2, 0x00,  //.......%@+...@@...
    0x00, 0x00, 0x00, 0x0f, 0xf1, 0x00, 0x2f, 0xe0, 0x00,  //.......@@....@@...
    0x00, 0x00, 0x00, 0x3f, 0xd0, 0x00, 0x6f, 0xa0, 0x00,  //.......@@...+@%...
    0x00, 0x00, 0x00, 0x8f, 0x80, 0x00, 0xaf, 0x60, 0x00,  //......+@%...%@+...
    0x00, 0x00, 0x00, 0xcf, 0x40, 0x00, 0xff, 0x10, 0x00,  //......@@+...@@....
    0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@@@@@@@
    0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x08, 0xf8, 0x00, 0x0b, 0xf5, 0x00, 0x00,  //.....%@%...%@+....
    0x00, 0x00, 0x0c, 0xf4, 0x00, 0x0f, 0xf1, 0x00, 0x00,  //.....@@+...@@.....
    0x00, 0x00, 0x1f, 0xf0, 0x00, 0x3f, 0xd0, 0x00, 0x00,  //.....@@....@@.....
    0x00, 0x00, 0x5f, 0xb0, 0x00, 0x7f, 0x90, 0x00, 0x00,  //....+@%...+@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,  //@@@@@@@@@@@@@@@@%.
    0x00, 0x01, 0xff, 0x00, 0x04, 0xfc, 0x00, 0x00, 0x00,  //....@@....@@......
    0x00, 0x05, 0xfb, 0x00, 0x08, 0xf8, 0x00, 0x00, 0x00,  //...+@%...%@%......
    0x00, 0x09, 0xf7, 0x00, 0x0c, 0xf4, 0x00, 0x00, 0x00,  //...%@+...@@+......
    0x00, 0x0e, 0xf2, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //...@@....@@.......
    0x00, 0x2f, 0xe0, 0x00, 0x5f, 0xb0, 0x00, 0x00, 0x00,  //...@@...+@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0024 ($) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,  //.....@......
    0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,  //.....@......
    0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,  //.....@......
    0x00, 0x5b, 0xef, 0xfd, 0xb6, 0x20,  //..+%@@@@%+..
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.%@@@@@@@@@.
    0x7f, 0xfc, 0x2f, 0x02, 0x49, 0xd0,  //+@@@.@..+%@.
    0xdf, 0xf3, 0x0f, 0x00, 0x00, 0x00,  //@@@..@......
    0xff, 0xf0, 0x0f, 0x00, 0x00, 0x00,  //@@@..@......
    0xff, 0xf4, 0x0f, 0x00, 0x00, 0x00,  //@@@+.@......
    0xbf, 0xff, 0x9f, 0x00, 0x00, 0x00,  //%@@@%@......
    0x3f, 0xff, 0xff, 0xfd, 0x71, 0x00,  //.@@@@@@@+...
    0x03, 0xdf, 0xff, 0xff, 0xff, 0x50,  //..@@@@@@@@+.
    0x00, 0x03, 0x7f, 0xff, 0xff, 0xf4,  //....+@@@@@@+
    0x00, 0x00, 0x0f, 0x05, 0xef, 0xfb,  //.....@.+@@@%
    0x00, 0x00, 0x0f, 0x00, 0x3f, 0xff,  //.....@...@@@
    0x00, 0x00, 0x0f, 0x00, 0x0f, 0xff,  //.....@...@@@
    0x00, 0x00, 0x0f, 0x00, 0x4f, 0xfc,  //.....@..+@@@
    0xc7, 0x30, 0x0f, 0x16, 0xef, 0xf5,  //@+...@.+@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //@@@@@@@@@@+.
    0x27, 0xbd, 0xff, 0xec, 0x82, 0x00,  //.+%@@@@@%...
    0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,  //.....@......
    0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,  //.....@......
    0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,  //.....@......
    0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,  //.....@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0025 (%) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x01, 0x9e, 0xfe, 0x80, 0x00, 0x00, 0x00, 0x0b, 0xfa, 0x00, 0x00,  //..%@@@%........%@%....
    0x0d, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x5f, 0xe1, 0x00, 0x00,  //.@@@@@@@......+@@.....
    0x7f, 0xd3, 0x04, 0xef, 0x70, 0x00, 0x00, 0xef, 0x60, 0x00, 0x00,  //+@@...@@+.....@@+.....
    0xdf, 0x40, 0x00, 0x5f, 0xd0, 0x00, 0x08, 0xfc, 0x00, 0x00, 0x00,  //@@+...+@@....%@@......
    0xff, 0x00, 0x00, 0x1f, 0xf0, 0x00, 0x2f, 0xf3, 0x00, 0x00, 0x00,  //@@.....@@....@@.......
    0xff, 0x00, 0x00, 0x1f, 0xf0, 0x00, 0xbf, 0x90, 0x00, 0x00, 0x00,  //@@.....@@...%@%.......
    0xdf, 0x40, 0x00, 0x4f, 0xd0, 0x05, 0xfe, 0x10, 0x00, 0x00, 0x00,  //@@+...+@@..+@@........
    0x8f, 0xd3, 0x03, 0xef, 0x70, 0x0e, 0xf6, 0x00, 0x00, 0x00, 0x00,  //+@@...@@+..@@+........
    0x0d, 0xff, 0xff, 0xfd, 0x00, 0x8f, 0xc0, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@..%@@.........
    0x01, 0x9e, 0xfe, 0x90, 0x02, 0xff, 0x30, 0x08, 0xef, 0xe8, 0x00,  //..%@@@%...@@...%@@@%..
    0x00, 0x00, 0x00, 0x00, 0x0c, 0xf9, 0x00, 0xdf, 0xff, 0xff, 0xd0,  //.........@@%..@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x5f, 0xe0, 0x07, 0xfe, 0x40, 0x3e, 0xf7,  //........+@@..+@@...@@+
    0x00, 0x00, 0x00, 0x01, 0xef, 0x50, 0x0d, 0xf4, 0x00, 0x04, 0xfd,  //........@@+..@@+...+@@
    0x00, 0x00, 0x00, 0x09, 0xfc, 0x00, 0x0f, 0xf1, 0x00, 0x01, 0xff,  //.......%@%...@@.....@@
    0x00, 0x00, 0x00, 0x3f, 0xf2, 0x00, 0x0f, 0xf1, 0x00, 0x01, 0xff,  //.......@@....@@.....@@
    0x00, 0x00, 0x00, 0xcf, 0x80, 0x00, 0x0d, 0xf4, 0x00, 0x04, 0xfd,  //......@@%....@@+...+@@
    0x00, 0x00, 0x06, 0xfe, 0x00, 0x00, 0x08, 0xfe, 0x40, 0x3e, 0xf7,  //.....+@@.....+@@...@@+
    0x00, 0x00, 0x1e, 0xf5, 0x00, 0x00, 0x00, 0xdf, 0xff, 0xff, 0xd0,  //.....@@+......@@@@@@@.
    0x00, 0x00, 0x9f, 0xb0, 0x00, 0x00, 0x00, 0x19, 0xef, 0xe9, 0x00,  //....%@%........%@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+0026 (&) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x7d, 0xff, 0xd9, 0x30, 0x00, 0x00, 0x00,  //....+@@@@%........
    0x00, 0x0c, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,  //...@@@@@@@@.......
    0x00, 0x8f, 0xfd, 0x30, 0x16, 0xc0, 0x00, 0x00, 0x00,  //..%@@@...+@.......
    0x00, 0xef, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.............
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.............
    0x03, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.............
    0x01, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@............
    0x00, 0xbf, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@%...........
    0x01, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@%..........
    0x09, 0xfc, 0xaf, 0xff, 0x60, 0x00, 0x00, 0xff, 0xe0,  //.%@@%@@@+.....@@@.
    0x3f, 0xf3, 0x0a, 0xff, 0xf5, 0x00, 0x02, 0xff, 0xa0,  //.@@..%@@@+....@@%.
    0xbf, 0xa0, 0x00, 0xaf, 0xff, 0x30, 0x06, 0xff, 0x30,  //%@%...%@@@...+@@..
    0xef, 0xc0, 0x00, 0x0a, 0xff, 0xe2, 0x0d, 0xfb, 0x00,  //@@@....%@@@..@@%..
    0xff, 0xf0, 0x00, 0x00, 0xaf, 0xfe, 0x9f, 0xf2, 0x00,  //@@@.....%@@@%@@...
    0xcf, 0xf4, 0x00, 0x00, 0x0a, 0xff, 0xff, 0x40, 0x00,  //@@@+.....%@@@@+...
    0x7f, 0xfd, 0x00, 0x00, 0x01, 0xff, 0xfe, 0x20, 0x00,  //+@@@......@@@@....
    0x0d, 0xff, 0xd5, 0x01, 0x5d, 0xff, 0xff, 0xf4, 0x00,  //.@@@@+..+@@@@@@...
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0xaf, 0xff, 0x50,  //..@@@@@@@@@.%@@@+.
    0x00, 0x05, 0xbe, 0xfe, 0xb5, 0x00, 0x0a, 0xff, 0xf7,  //...+%@@@%+...%@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0027 (') , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+0028 (() , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x02, 0xfc,  //....@@
    0x00, 0x0c, 0xf4,  //...@@+
    0x00, 0x6f, 0xd0,  //..+@@.
    0x00, 0xef, 0x70,  //..@@+.
    0x06, 0xff, 0x20,  //.+@@..
    0x0d, 0xfd, 0x00,  //.@@@..
    0x2f, 0xf9, 0x00,  //.@@%..
    0x7f, 0xf6, 0x00,  //+@@+..
    0xbf, 0xf3, 0x00,  //%@@...
    0xdf, 0xf1, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xdf, 0xf1, 0x00,  //@@@...
    0xbf, 0xf3, 0x00,  //%@@...
    0x7f, 0xf6, 0x00,  //+@@+..
    0x2f, 0xf9, 0x00,  //.@@%..
    0x0d, 0xfc, 0x00,  //.@@@..
    0x06, 0xff, 0x20,  //.+@@..
    0x00, 0xef, 0x70,  //..@@+.
    0x00, 0x6f, 0xd0,  //..+@@.
    0x00, 0x0c, 0xf4,  //...@@+
    0x00, 0x02, 0xfc,  //....@@
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0029 ()) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0xcf, 0x20, 0x00,  //@@....
    0x5f, 0xc0, 0x00,  //+@@...
    0x0d, 0xf6, 0x00,  //.@@+..
    0x07, 0xfe, 0x00,  //.+@@..
    0x02, 0xff, 0x60,  //..@@+.
    0x00, 0xdf, 0xc0,  //..@@@.
    0x00, 0x9f, 0xf2,  //..%@@.
    0x00, 0x6f, 0xf7,  //..+@@+
    0x00, 0x3f, 0xfb,  //...@@%
    0x00, 0x2f, 0xfd,  //...@@@
    0x00, 0x1f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x1f, 0xff,  //...@@@
    0x00, 0x2f, 0xfd,  //...@@@
    0x00, 0x3f, 0xfa,  //...@@%
    0x00, 0x6f, 0xf7,  //..+@@+
    0x00, 0x9f, 0xf2,  //..%@@.
    0x00, 0xdf, 0xd0,  //..@@@.
    0x02, 0xff, 0x60,  //..@@+.
    0x07, 0xfe, 0x00,  //.+@@..
    0x0d, 0xf6, 0x00,  //.@@+..
    0x4f, 0xc0, 0x00,  //+@@...
    0xcf, 0x20, 0x00,  //@@....
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+002a (*) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,  //.....@.....
    0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,  //.....@.....
    0x87, 0x00, 0x0f, 0x00, 0x07, 0x80,  //%+...@...+%
    0x9f, 0xd3, 0x0f, 0x03, 0xdf, 0x90,  //%@@..@..@@%
    0x03, 0xcf, 0x8f, 0x8f, 0xc3, 0x00,  //..@@%@%@@..
    0x00, 0x06, 0xef, 0xe6, 0x00, 0x00,  //...+@@@+...
    0x00, 0x06, 0xef, 0xe6, 0x00, 0x00,  //...+@@@+...
    0x03, 0xcf, 0x8f, 0x8f, 0xc3, 0x00,  //..@@%@%@@..
    0x9f, 0xd3, 0x0f, 0x03, 0xdf, 0x90,  //%@@..@..@@%
    0x88, 0x00, 0x0f, 0x00, 0x08, 0x80,  //%+...@...+%
    0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,  //.....@.....
    0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,  //.....@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+002b (+) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+002c (,) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x0f, 0xff,  //.@@@
    0x0f, 0xff,  //.@@@
    0x1f, 0xfc,  //.@@@
    0x5f, 0xf4,  //+@@+
    0x9f, 0xc0,  //%@@.
    0xdf, 0x40,  //@@..
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+002d (-) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+002e (.) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+002f (/) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x4f, 0xd0,  //......+@@
    0x00, 0x00, 0x00, 0x9f, 0x80,  //......%@+
    0x00, 0x00, 0x00, 0xef, 0x20,  //......@@.
    0x00, 0x00, 0x04, 0xfd, 0x00,  //......@@.
    0x00, 0x00, 0x09, 0xf8, 0x00,  //.....%@%.
    0x00, 0x00, 0x0e, 0xf3, 0x00,  //.....@@..
    0x00, 0x00, 0x3f, 0xd0, 0x00,  //.....@@..
    0x00, 0x00, 0x9f, 0x80, 0x00,  //....%@%..
    0x00, 0x00, 0xef, 0x30, 0x00,  //....@@...
    0x00, 0x03, 0xfe, 0x00, 0x00,  //....@@...
    0x00, 0x08, 0xf8, 0x00, 0x00,  //...%@%...
    0x00, 0x0e, 0xf3, 0x00, 0x00,  //...@@....
    0x00, 0x3f, 0xe0, 0x00, 0x00,  //...@@....
    0x00, 0x8f, 0x90, 0x00, 0x00,  //..%@%....
    0x00, 0xdf, 0x30, 0x00, 0x00,  //..@@.....
    0x03, 0xfe, 0x00, 0x00, 0x00,  //..@@.....
    0x08, 0xf9, 0x00, 0x00, 0x00,  //.%@%.....
    0x0d, 0xf4, 0x00, 0x00, 0x00,  //.@@......
    0x2f, 0xe0, 0x00, 0x00, 0x00,  //.@@......
    0x8f, 0x90, 0x00, 0x00, 0x00,  //+@%......
    0xdf, 0x40, 0x00, 0x00, 0x00,  //@@+......
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0030 (0) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x03, 0xae, 0xfe, 0xa3, 0x00, 0x00,  //....%@@@%....
    0x00, 0x7f, 0xff, 0xff, 0xff, 0x70, 0x00,  //..+@@@@@@@+..
    0x05, 0xff, 0xd3, 0x03, 0xdf, 0xf5, 0x00,  //.+@@@...@@@+.
    0x0d, 0xff, 0x20, 0x00, 0x2f, 0xfd, 0x00,  //.@@@.....@@@.
    0x4f, 0xfa, 0x00, 0x00, 0x0a, 0xff, 0x40,  //+@@%.....%@@+
    0x9f, 0xf5, 0x00, 0x00, 0x05, 0xff, 0x90,  //%@@+.....+@@%
    0xcf, 0xf2, 0x00, 0x00, 0x03, 0xff, 0xc0,  //@@@.......@@%
    0xef, 0xf1, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xef, 0xf1, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.......@@@
    0xcf, 0xf2, 0x00, 0x00, 0x03, 0xff, 0xc0,  //@@@.......@@%
    0x9f, 0xf5, 0x00, 0x00, 0x05, 0xff, 0x90,  //%@@+.....+@@%
    0x4f, 0xfa, 0x00, 0x00, 0x0a, 0xff, 0x40,  //+@@%.....%@@+
    0x0d, 0xff, 0x20, 0x00, 0x2f, 0xfd, 0x00,  //.@@@.....@@@.
    0x05, 0xff, 0xd3, 0x03, 0xdf, 0xf5, 0x00,  //.+@@@...@@@+.
    0x00, 0x7f, 0xff, 0xff, 0xff, 0x70, 0x00,  //..+@@@@@@@+..
    0x00, 0x03, 0xae, 0xfe, 0xa3, 0x00, 0x00,  //....%@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0031 (1) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x14, 0x7a, 0xef, 0xff, 0x00, 0x00,  //.++%@@@@....
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@@@@@@....
    0xeb, 0x74, 0x1f, 0xff, 0x00, 0x00,  //@%++.@@@....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //.....@@@....
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0032 (2) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x26, 0xad, 0xff, 0xec, 0x71, 0x00, 0x00,  //.+%@@@@@+....
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //@@@@@@@@@@+..
    0xff, 0xa4, 0x10, 0x3a, 0xff, 0xf2, 0x00,  //@@%+...%@@@..
    0xb2, 0x00, 0x00, 0x00, 0x9f, 0xfa, 0x00,  //%.......%@@%.
    0x00, 0x00, 0x00, 0x00, 0x2f, 0xfe, 0x00,  //.........@@@.
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00,  //.........@@@.
    0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd, 0x00,  //.........@@@.
    0x00, 0x00, 0x00, 0x00, 0x9f, 0xf9, 0x00,  //........%@@%.
    0x00, 0x00, 0x00, 0x03, 0xff, 0xf2, 0x00,  //........@@@..
    0x00, 0x00, 0x00, 0x1e, 0xff, 0x80, 0x00,  //.......@@@%..
    0x00, 0x00, 0x00, 0xdf, 0xfc, 0x00, 0x00,  //......@@@@...
    0x00, 0x00, 0x0c, 0xff, 0xe1, 0x00, 0x00,  //.....@@@@....
    0x00, 0x00, 0xbf, 0xff, 0x30, 0x00, 0x00,  //....%@@@.....
    0x00, 0x0a, 0xff, 0xf4, 0x00, 0x00, 0x00,  //...%@@@+.....
    0x00, 0xaf, 0xff, 0x60, 0x00, 0x00, 0x00,  //..%@@@+......
    0x09, 0xff, 0xf7, 0x00, 0x00, 0x00, 0x00,  //.%@@@+.......
    0x8f, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00,  //%@@@%........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10,  //@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10,  //@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0033 (3) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x02, 0x8c, 0xef, 0xeb, 0x50, 0x00,  //..+%@@@%+...
    0x0f, 0xff, 0xff, 0xff, 0xfa, 0x00,  //.@@@@@@@@%..
    0x0c, 0x62, 0x01, 0x6f, 0xff, 0x60,  //.@+...+@@@+.
    0x00, 0x00, 0x00, 0x06, 0xff, 0xd0,  //.......+@@@.
    0x00, 0x00, 0x00, 0x01, 0xff, 0xf0,  //........@@@.
    0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //........@@@.
    0x00, 0x00, 0x00, 0x05, 0xff, 0x90,  //.......+@@%.
    0x00, 0x00, 0x01, 0x5e, 0xfd, 0x10,  //......+@@@..
    0x00, 0x0f, 0xff, 0xfd, 0x70, 0x00,  //...@@@@@+...
    0x00, 0x0f, 0xff, 0xff, 0xb5, 0x00,  //...@@@@@%+..
    0x00, 0x00, 0x01, 0x4b, 0xff, 0xa0,  //.......%@@%.
    0x00, 0x00, 0x00, 0x00, 0x9f, 0xf8,  //........%@@+
    0x00, 0x00, 0x00, 0x00, 0x2f, 0xfe,  //.........@@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.........@@@
    0x00, 0x00, 0x00, 0x00, 0x2f, 0xfe,  //.........@@@
    0x00, 0x00, 0x00, 0x00, 0xaf, 0xf9,  //........%@@%
    0xc6, 0x20, 0x00, 0x4b, 0xff, 0xf2,  //@+....+%@@@.
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x30,  //@@@@@@@@@@..
    0x27, 0xbe, 0xff, 0xeb, 0x60, 0x00,  //.+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0034 (4) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x08, 0xff, 0xf0, 0x00,  //.......%@@@...
    0x00, 0x00, 0x00, 0x3f, 0xff, 0xf0, 0x00,  //.......@@@@...
    0x00, 0x00, 0x00, 0xdf, 0xff, 0xf0, 0x00,  //......@@@@@...
    0x00, 0x00, 0x08, 0xf9, 0xff, 0xf0, 0x00,  //.....%@%@@@...
    0x00, 0x00, 0x3f, 0xe0, 0xff, 0xf0, 0x00,  //.....@@.@@@...
    0x00, 0x00, 0xdf, 0x40, 0xff, 0xf0, 0x00,  //....@@+.@@@...
    0x00, 0x08, 0xfa, 0x00, 0xff, 0xf0, 0x00,  //...%@%..@@@...
    0x00, 0x3f, 0xe1, 0x00, 0xff, 0xf0, 0x00,  //...@@...@@@...
    0x00, 0xdf, 0x50, 0x00, 0xff, 0xf0, 0x00,  //..@@+...@@@...
    0x09, 0xfa, 0x00, 0x00, 0xff, 0xf0, 0x00,  //.%@%....@@@...
    0x4f, 0xe1, 0x00, 0x00, 0xff, 0xf0, 0x00,  //.@@.....@@@...
    0xdf, 0x50, 0x00, 0x00, 0xff, 0xf0, 0x00,  //@@+.....@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //........@@@...
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //........@@@...
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //........@@@...
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //........@@@...
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00,  //........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0035 (5) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@.
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.@@@@@@@@@@.
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.@@@........
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.@@@........
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.@@@........
    0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.@@@........
    0x0f, 0xff, 0xcf, 0xfd, 0x81, 0x00,  //.@@@@@@@%...
    0x0f, 0xff, 0xff, 0xff, 0xfe, 0x20,  //.@@@@@@@@@..
    0x0c, 0x51, 0x01, 0x5d, 0xff, 0xd0,  //.@+...+@@@@.
    0x00, 0x00, 0x00, 0x01, 0xdf, 0xf7,  //........@@@+
    0x00, 0x00, 0x00, 0x00, 0x5f, 0xfc,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //.........@@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //.........@@@
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe,  //.........@@@
    0x00, 0x00, 0x00, 0x00, 0x5f, 0xfb,  //........+@@%
    0x00, 0x00, 0x00, 0x01, 0xef, 0xf6,  //........@@@+
    0xc7, 0x30, 0x01, 0x5d, 0xff, 0xc0,  //@+....+@@@@.
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x10,  //@@@@@@@@@%..
    0x27, 0xbe, 0xff, 0xda, 0x40, 0x00,  //.+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0036 (6) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x39, 0xdf, 0xfd, 0x93, 0x00,  //.....%@@@@%..
    0x00, 0x0a, 0xff, 0xff, 0xff, 0xff, 0x00,  //...%@@@@@@@@.
    0x00, 0xbf, 0xfc, 0x41, 0x02, 0x6c, 0x00,  //..%@@@+...+@.
    0x07, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //.+@@%........
    0x0f, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00,  //.@@@.........
    0x6f, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%.........
    0xaf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.........
    0xdf, 0xf2, 0x3b, 0xef, 0xd9, 0x20, 0x00,  //@@@..%@@@%...
    0xef, 0xf7, 0xff, 0xff, 0xff, 0xf4, 0x00,  //@@@+@@@@@@@+.
    0xff, 0xff, 0x92, 0x02, 0x9f, 0xff, 0x10,  //@@@@%...%@@@.
    0xff, 0xfb, 0x00, 0x00, 0x0b, 0xff, 0x90,  //@@@%.....%@@%
    0xef, 0xf3, 0x00, 0x00, 0x03, 0xff, 0xd0,  //@@@.......@@@
    0xcf, 0xf1, 0x00, 0x00, 0x01, 0xff, 0xf0,  //%@@.......@@@
    0x9f, 0xf1, 0x00, 0x00, 0x01, 0xff, 0xf0,  //%@@.......@@@
    0x4f, 0xf3, 0x00, 0x00, 0x03, 0xff, 0xd0,  //+@@.......@@@
    0x0d, 0xfb, 0x00, 0x00, 0x0b, 0xff, 0x80,  //.@@%.....%@@%
    0x04, 0xff, 0x92, 0x02, 0x9f, 0xfe, 0x10,  //.+@@%...%@@@.
    0x00, 0x6f, 0xff, 0xff, 0xff, 0xe2, 0x00,  //..+@@@@@@@@..
    0x00, 0x02, 0x9d, 0xff, 0xc7, 0x00, 0x00,  //....%@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0037 (7) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x9f, 0xf8,  //........%@@%
    0x00, 0x00, 0x00, 0x00, 0xef, 0xf3,  //........@@@.
    0x00, 0x00, 0x00, 0x04, 0xff, 0xe0,  //.......+@@@.
    0x00, 0x00, 0x00, 0x09, 0xff, 0x80,  //.......%@@%.
    0x00, 0x00, 0x00, 0x0e, 0xff, 0x30,  //.......@@@..
    0x00, 0x00, 0x00, 0x3f, 0xfe, 0x00,  //.......@@@..
    0x00, 0x00, 0x00, 0x9f, 0xf9, 0x00,  //......%@@%..
    0x00, 0x00, 0x00, 0xef, 0xf4, 0x00,  //......@@@+..
    0x00, 0x00, 0x03, 0xff, 0xe0, 0x00,  //......@@@...
    0x00, 0x00, 0x08, 0xff, 0x90, 0x00,  //.....%@@%...
    0x00, 0x00, 0x0d, 0xff, 0x40, 0x00,  //.....@@@+...
    0x00, 0x00, 0x3f, 0xfe, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x8f, 0xfa, 0x00, 0x00,  //....%@@%....
    0x00, 0x00, 0xdf, 0xf4, 0x00, 0x00,  //....@@@+....
    0x00, 0x02, 0xff, 0xf0, 0x00, 0x00,  //....@@@.....
    0x00, 0x08, 0xff, 0xa0, 0x00, 0x00,  //...%@@%.....
    0x00, 0x0d, 0xff, 0x50, 0x00, 0x00,  //...@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0038 (8) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x29, 0xce, 0xfe, 0xc9, 0x20, 0x00,  //...%@@@@@%...
    0x07, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00,  //.+@@@@@@@@@+.
    0x5f, 0xff, 0x72, 0x02, 0x7f, 0xff, 0x50,  //+@@@+...+@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+.....+@@@
    0xff, 0xf1, 0x00, 0x00, 0x01, 0xff, 0xf0,  //@@@.......@@@
    0xef, 0xf1, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.......@@@
    0x9f, 0xf6, 0x00, 0x00, 0x06, 0xff, 0x90,  //%@@+.....+@@%
    0x0c, 0xff, 0x72, 0x02, 0x7f, 0xfc, 0x00,  //.@@@+...+@@%.
    0x00, 0x6c, 0xff, 0xff, 0xfc, 0x60, 0x00,  //..+@@@@@@@+..
    0x00, 0x8e, 0xff, 0xff, 0xfe, 0x80, 0x00,  //..%@@@@@@@%..
    0x0c, 0xff, 0x92, 0x02, 0x9f, 0xfc, 0x00,  //.@@@%...%@@@.
    0x8f, 0xf9, 0x00, 0x00, 0x09, 0xff, 0x80,  //%@@%.....%@@%
    0xef, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xef, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xaf, 0xf8, 0x00, 0x00, 0x09, 0xff, 0xa0,  //%@@%.....%@@%
    0x3f, 0xff, 0x82, 0x02, 0x9f, 0xff, 0x30,  //.@@@%...%@@@.
    0x06, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00,  //.+@@@@@@@@@+.
    0x00, 0x28, 0xcf, 0xff, 0xc8, 0x20, 0x00,  //...%@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0039 (9) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x07, 0xce, 0xfd, 0x92, 0x00, 0x00,  //...+@@@@%....
    0x02, 0xdf, 0xff, 0xff, 0xff, 0x60, 0x00,  //..@@@@@@@@+..
    0x1e, 0xff, 0x92, 0x02, 0x9f, 0xf4, 0x00,  //.@@@%...%@@+.
    0x8f, 0xfb, 0x00, 0x00, 0x0b, 0xfd, 0x00,  //%@@%.....%@@.
    0xdf, 0xf3, 0x00, 0x00, 0x03, 0xff, 0x40,  //@@@.......@@.
    0xff, 0xf1, 0x00, 0x00, 0x01, 0xff, 0x80,  //@@@.......@@%
    0xff, 0xf1, 0x00, 0x00, 0x01, 0xff, 0xb0,  //@@@.......@@%
    0xdf, 0xf3, 0x00, 0x00, 0x03, 0xff, 0xe0,  //@@@.......@@@
    0x9f, 0xfb, 0x00, 0x00, 0x0b, 0xff, 0xf0,  //%@@%.....%@@@
    0x2f, 0xff, 0x92, 0x02, 0x9f, 0xff, 0xf0,  //.@@@%...%@@@@
    0x05, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xe0,  //.+@@@@@@@+@@@
    0x00, 0x29, 0xdf, 0xeb, 0x32, 0xff, 0xd0,  //...%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xa0,  //.........+@@%
    0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0x60,  //.........%@@+
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x00,  //.........@@@.
    0x00, 0x00, 0x00, 0x00, 0xbf, 0xf7, 0x00,  //........%@@+.
    0x0c, 0x62, 0x01, 0x4c, 0xff, 0xb0, 0x00,  //.@+...+@@@%..
    0x0f, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00,  //.@@@@@@@@%...
    0x03, 0x9d, 0xff, 0xd9, 0x30, 0x00, 0x00,  //..%@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+003a (:) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+003b (;) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x0f, 0xff,  //.@@@
    0x0f, 0xff,  //.@@@
    0x0f, 0xff,  //.@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x0f, 0xff,  //.@@@
    0x0f, 0xff,  //.@@@
    0x1f, 0xfc,  //.@@@
    0x5f, 0xf4,  //+@@+
    0x9f, 0xc0,  //%@@.
    0xdf, 0x40,  //@@..
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+003c (<) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x7c,  //..............+@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xbf, 0xff,  //...........+%@@@
    0x00, 0x00, 0x00, 0x00, 0x39, 0xef, 0xff, 0xa4,  //.........%@@@@%+
    0x00, 0x00, 0x01, 0x7d, 0xff, 0xfc, 0x61, 0x00,  //......+@@@@@+...
    0x00, 0x05, 0xbf, 0xff, 0xe8, 0x20, 0x00, 0x00,  //...+%@@@@%......
    0x39, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00,  //.%@@@@%+........
    0xff, 0xfc, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@+...........
    0xff, 0xfc, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@+...........
    0x39, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00,  //.%@@@@%+........
    0x00, 0x05, 0xbf, 0xff, 0xe8, 0x20, 0x00, 0x00,  //...+%@@@@%......
    0x00, 0x00, 0x01, 0x7d, 0xff, 0xfc, 0x61, 0x00,  //......+@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x39, 0xef, 0xff, 0xa4,  //.........%@@@@%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xbf, 0xff,  //...........+%@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x7d,  //..............+@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+003d (=) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+003e (>) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xc6, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+..............
    0xff, 0xfb, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%+...........
    0x4a, 0xff, 0xfe, 0x93, 0x00, 0x00, 0x00, 0x00,  //+%@@@@%.........
    0x00, 0x16, 0xcf, 0xff, 0xd7, 0x10, 0x00, 0x00,  //...+@@@@@+......
    0x00, 0x00, 0x02, 0x8e, 0xff, 0xfb, 0x50, 0x00,  //......%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0x93,  //........+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xcf, 0xff,  //...........+@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xcf, 0xff,  //...........+@@@@
    0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0x93,  //........+%@@@@%.
    0x00, 0x00, 0x02, 0x8e, 0xff, 0xfb, 0x50, 0x00,  //......%@@@@%+...
    0x00, 0x16, 0xcf, 0xff, 0xd7, 0x10, 0x00, 0x00,  //...+@@@@@+......
    0x4a, 0xff, 0xfe, 0x93, 0x00, 0x00, 0x00, 0x00,  //+%@@@@%.........
    0xff, 0xfb, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%+...........
    0xc7, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+003f (?) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x01, 0x8d, 0xff, 0xc7, 0x00,  //..%@@@@+..
    0x5f, 0xff, 0xff, 0xff, 0xc0,  //+@@@@@@@@.
    0xfd, 0x61, 0x04, 0xef, 0xf8,  //@@+..+@@@%
    0x90, 0x00, 0x00, 0x4f, 0xfd,  //%.....+@@@
    0x00, 0x00, 0x00, 0x0f, 0xff,  //.......@@@
    0x00, 0x00, 0x00, 0x1f, 0xfc,  //.......@@@
    0x00, 0x00, 0x00, 0x7f, 0xf5,  //......+@@+
    0x00, 0x00, 0x02, 0xef, 0x70,  //......@@+.
    0x00, 0x00, 0x2d, 0xf6, 0x00,  //.....@@+..
    0x00, 0x02, 0xef, 0xa0, 0x00,  //....@@%...
    0x00, 0x0b, 0xff, 0x20, 0x00,  //...%@@....
    0x00, 0x0e, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0040 (@) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x02, 0x7b, 0xdf, 0xfe, 0xb7, 0x10, 0x00, 0x00, 0x00,  //........+%@@@@%+.......
    0x00, 0x00, 0x03, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x10, 0x00, 0x00,  //......%@@@@@@@@@@%.....
    0x00, 0x00, 0x8f, 0xfe, 0x94, 0x10, 0x02, 0x5a, 0xff, 0xe5, 0x00, 0x00,  //....+@@@%+....+%@@@+...
    0x00, 0x0a, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0x50, 0x00,  //...%@@+..........%@@+..
    0x00, 0x8f, 0xe4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xf3, 0x00,  //..%@@+............+@@..
    0x04, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xfd, 0x00,  //.+@@...............+@@.
    0x0c, 0xf7, 0x00, 0x00, 0x5c, 0xfe, 0xb4, 0x0f, 0xf0, 0x00, 0xdf, 0x50,  //.@@+....+@@@%+.@@...@@+
    0x4f, 0xd0, 0x00, 0x08, 0xff, 0xff, 0xff, 0x7f, 0xf0, 0x00, 0x6f, 0xa0,  //.@@....%@@@@@@+@@...+@%
    0x8f, 0x70, 0x00, 0x4f, 0xf9, 0x20, 0x29, 0xff, 0xf0, 0x00, 0x2f, 0xd0,  //%@+...+@@%...%@@@....@@
    0xcf, 0x30, 0x00, 0xbf, 0x90, 0x00, 0x00, 0x9f, 0xf0, 0x00, 0x0f, 0xf0,  //@@....%@%.....%@@....@@
    0xef, 0x00, 0x00, 0xef, 0x20, 0x00, 0x00, 0x2f, 0xf0, 0x00, 0x0f, 0xf0,  //@@....@@.......@@....@@
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x3f, 0xd0,  //@@....@@.......@@....@@
    0xef, 0x10, 0x00, 0xef, 0x20, 0x00, 0x00, 0x2f, 0xf0, 0x00, 0x8f, 0x80,  //@@....@@.......@@...%@%
    0xcf, 0x30, 0x00, 0xbf, 0x90, 0x00, 0x00, 0x9f, 0xf0, 0x03, 0xff, 0x10,  //@@....%@%.....%@@...@@.
    0x9f, 0x80, 0x00, 0x4f, 0xf9, 0x20, 0x29, 0xff, 0xf1, 0x7f, 0xf5, 0x00,  //%@+...+@@%...%@@@.+@@+.
    0x4f, 0xd0, 0x00, 0x08, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xfe, 0x40, 0x00,  //+@@....%@@@@@@+@@@@@+..
    0x0d, 0xf6, 0x00, 0x00, 0x5c, 0xff, 0xc4, 0x0f, 0xda, 0x60, 0x00, 0x00,  //.@@+....+@@@%+.@@%+....
    0x05, 0xff, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@...................
    0x00, 0xaf, 0xe3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@..................
    0x00, 0x0b, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x70, 0x00, 0x00,  //...%@@+..........%+....
    0x00, 0x00, 0x9f, 0xfe, 0x84, 0x10, 0x02, 0x6b, 0xff, 0x60, 0x00, 0x00,  //....%@@@%.....+%@@+....
    0x00, 0x00, 0x04, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xb3, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@%......
    0x00, 0x00, 0x00, 0x04, 0x8c, 0xef, 0xec, 0x83, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0041 (A) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x1f, 0xff, 0x10, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x7f, 0xff, 0x70, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0xdf, 0xff, 0xd0, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x03, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x09, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x0e, 0xff, 0x7f, 0xfe, 0x00, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x00, 0x5f, 0xfd, 0x0d, 0xff, 0x50, 0x00, 0x00,  //....+@@@.@@@+....
    0x00, 0x00, 0xbf, 0xf7, 0x07, 0xff, 0xb0, 0x00, 0x00,  //....%@@+.+@@%....
    0x00, 0x01, 0xff, 0xf1, 0x01, 0xff, 0xf1, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x07, 0xff, 0xb0, 0x00, 0xbf, 0xf7, 0x00, 0x00,  //...+@@%...%@@+...
    0x00, 0x0d, 0xff, 0x50, 0x00, 0x5f, 0xfd, 0x00, 0x00,  //...@@@+...+@@@...
    0x00, 0x3f, 0xff, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00,  //...@@@.....@@@...
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00,  //..@@@@@@@@@@@@@..
    0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0xdf, 0xf5, 0x00,  //.+@@@.......@@@+.
    0x0b, 0xff, 0x70, 0x00, 0x00, 0x00, 0x8f, 0xfb, 0x00,  //.%@@+.......+@@%.
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@.........@@@.
    0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@%.........@@@+
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0042 (B) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0xfe, 0xb5, 0x00, 0x00,  //@@@@@@@@%+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x00,  //@@@@@@@@@@%..
    0xff, 0xf0, 0x00, 0x14, 0xef, 0xf7, 0x00,  //@@@....+@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x5f, 0xfd, 0x00,  //@@@.....+@@@.
    0xff, 0xf0, 0x00, 0x00, 0x1f, 0xff, 0x00,  //@@@......@@@.
    0xff, 0xf0, 0x00, 0x00, 0x1f, 0xfe, 0x00,  //@@@......@@@.
    0xff, 0xf0, 0x00, 0x00, 0x4f, 0xfa, 0x00,  //@@@.....+@@%.
    0xff, 0xf0, 0x00, 0x04, 0xef, 0xe2, 0x00,  //@@@....+@@@..
    0xff, 0xff, 0xff, 0xff, 0xe9, 0x10, 0x00,  //@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x60, 0x00,  //@@@@@@@@@@+..
    0xff, 0xf0, 0x00, 0x02, 0x8f, 0xfa, 0x00,  //@@@.....%@@%.
    0xff, 0xf0, 0x00, 0x00, 0x08, 0xff, 0x70,  //@@@......%@@+
    0xff, 0xf0, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x08, 0xff, 0xb0,  //@@@......%@@%
    0xff, 0xf0, 0x00, 0x02, 0x8f, 0xff, 0x40,  //@@@.....%@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x00,  //@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xfe, 0xc8, 0x20, 0x00,  //@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0043 (C) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x06, 0xad, 0xff, 0xea, 0x50, 0x00,  //.....+%@@@@%+..
    0x00, 0x05, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x50,  //...+@@@@@@@@@@+
    0x00, 0x7f, 0xff, 0x93, 0x10, 0x26, 0xdf, 0xf0,  //..+@@@%....+@@@
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x08, 0xf0,  //.+@@@........%@
    0x0e, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x70,  //.@@@+.........+
    0x5f, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%...........
    0x9f, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+...........
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xaf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+...........
    0x5f, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%...........
    0x0e, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x70,  //.@@@..........+
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x08, 0xf0,  //.+@@@........%@
    0x00, 0x7f, 0xff, 0x93, 0x10, 0x26, 0xdf, 0xf0,  //..+@@@%....+@@@
    0x00, 0x05, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x50,  //...+@@@@@@@@@@+
    0x00, 0x00, 0x06, 0xad, 0xff, 0xea, 0x50, 0x00,  //.....+%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0044 (D) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xfe, 0xc9, 0x40, 0x00, 0x00,  //@@@@@@@@@%+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x50, 0x00,  //@@@@@@@@@@@@+...
    0xff, 0xf0, 0x00, 0x01, 0x5a, 0xff, 0xf9, 0x00,  //@@@.....+%@@@%..
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x70,  //@@@........@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x03, 0xff, 0xe0,  //@@@.........@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xf6,  //@@@.........%@@+
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfa,  //@@@.........+@@%
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@..........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xfa,  //@@@.........+@@%
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xf6,  //@@@.........%@@+
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x03, 0xff, 0xe0,  //@@@.........@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x70,  //@@@........@@@+.
    0xff, 0xf0, 0x00, 0x01, 0x4a, 0xff, 0xf9, 0x00,  //@@@.....+%@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x50, 0x00,  //@@@@@@@@@@@@+...
    0xff, 0xff, 0xff, 0xfe, 0xc9, 0x40, 0x00, 0x00,  //@@@@@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0045 (E) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0046 (F) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0047 (G) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x05, 0x9d, 0xef, 0xec, 0x94, 0x00, 0x00,  //.....+%@@@@@%....
    0x00, 0x04, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x00,  //...+@@@@@@@@@@@+.
    0x00, 0x6f, 0xff, 0xa4, 0x10, 0x13, 0x9f, 0xff, 0x00,  //..+@@@%+....%@@@.
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x01, 0xaf, 0x00,  //.+@@@.........%@.
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,  //.@@@+..........%.
    0x5f, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%.............
    0x9f, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.............
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xf0,  //@@@.......@@@@@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xf0,  //@@@.......@@@@@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0x9f, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //%@@+..........@@@
    0x5f, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //+@@%..........@@@
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //.@@@..........@@@
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..@@@.........@@@
    0x00, 0x6f, 0xff, 0xa4, 0x10, 0x02, 0x5b, 0xff, 0xf0,  //..+@@@%+....+%@@@
    0x00, 0x03, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x30,  //....@@@@@@@@@@@@.
    0x00, 0x00, 0x04, 0x9c, 0xef, 0xfe, 0xb7, 0x20, 0x00,  //.....+%@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0048 (H) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0049 (I) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+004a (J) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x02, 0xff, 0xd0,  //..@@@
    0x07, 0xff, 0x90,  //.+@@%
    0x5f, 0xff, 0x30,  //+@@@.
    0xff, 0xf8, 0x00,  //@@@%.
    0xea, 0x40, 0x00,  //@%+..
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+004b (K) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xf0, 0x00, 0x00, 0x04, 0xff, 0xf8, 0x00,  //@@@.......@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x3f, 0xff, 0x80, 0x00,  //@@@......@@@%..
    0xff, 0xf0, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00,  //@@@.....@@@%...
    0xff, 0xf0, 0x00, 0x3f, 0xff, 0x80, 0x00, 0x00,  //@@@....@@@%....
    0xff, 0xf0, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x00,  //@@@...@@@%.....
    0xff, 0xf0, 0x3f, 0xff, 0x80, 0x00, 0x00, 0x00,  //@@@..@@@%......
    0xff, 0xf3, 0xef, 0xf8, 0x00, 0x00, 0x00, 0x00,  //@@@.@@@%.......
    0xff, 0xfe, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%........
    0xff, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@%.........
    0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@.........
    0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@........
    0xff, 0xf5, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00,  //@@@+@@@%.......
    0xff, 0xf0, 0x6f, 0xff, 0xb0, 0x00, 0x00, 0x00,  //@@@.+@@@%......
    0xff, 0xf0, 0x06, 0xff, 0xfa, 0x00, 0x00, 0x00,  //@@@..+@@@%.....
    0xff, 0xf0, 0x00, 0x6f, 0xff, 0xa0, 0x00, 0x00,  //@@@...+@@@%....
    0xff, 0xf0, 0x00, 0x06, 0xff, 0xf9, 0x00, 0x00,  //@@@....+@@@%...
    0xff, 0xf0, 0x00, 0x00, 0x6f, 0xff, 0x90, 0x00,  //@@@.....+@@@%..
    0xff, 0xf0, 0x00, 0x00, 0x06, 0xff, 0xf8, 0x00,  //@@@......+@@@%.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x6f, 0xff, 0x80,  //@@@.......+@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+004c (L) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+004d (M) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xf8, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf0,  //@@@@@%.....%@@@@@
    0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf0,  //@@@@@@.....@@@@@@
    0xff, 0xfe, 0xff, 0x30, 0x00, 0x3f, 0xfe, 0xff, 0xf0,  //@@@@@@.....@@@@@@
    0xff, 0xf9, 0xff, 0x90, 0x00, 0x9f, 0xf9, 0xff, 0xf0,  //@@@%@@%...%@@%@@@
    0xff, 0xf3, 0xff, 0xe0, 0x00, 0xef, 0xf3, 0xff, 0xf0,  //@@@.@@@...@@@.@@@
    0xff, 0xf0, 0xef, 0xf4, 0x04, 0xff, 0xe0, 0xff, 0xf0,  //@@@.@@@+.+@@@.@@@
    0xff, 0xf0, 0x8f, 0xf9, 0x09, 0xff, 0x80, 0xff, 0xf0,  //@@@.%@@%.%@@%.@@@
    0xff, 0xf0, 0x3f, 0xfe, 0x0e, 0xff, 0x30, 0xff, 0xf0,  //@@@..@@@.@@@..@@@
    0xff, 0xf0, 0x0d, 0xff, 0x9f, 0xfd, 0x00, 0xff, 0xf0,  //@@@..@@@%@@@..@@@
    0xff, 0xf0, 0x08, 0xff, 0xff, 0xf8, 0x00, 0xff, 0xf0,  //@@@..%@@@@@%..@@@
    0xff, 0xf0, 0x02, 0xff, 0xff, 0xf2, 0x00, 0xff, 0xf0,  //@@@...@@@@@...@@@
    0xff, 0xf0, 0x00, 0xdf, 0xff, 0xd0, 0x00, 0xff, 0xf0,  //@@@...@@@@@...@@@
    0xff, 0xf0, 0x00, 0x7f, 0xff, 0x70, 0x00, 0xff, 0xf0,  //@@@...+@@@+...@@@
    0xff, 0xf0, 0x00, 0x2f, 0xff, 0x20, 0x00, 0xff, 0xf0,  //@@@....@@@....@@@
    0xff, 0xf0, 0x00, 0x0c, 0xfc, 0x00, 0x00, 0xff, 0xf0,  //@@@....@@@....@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+004e (N) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0x10, 0x00, 0x00, 0x0f, 0xff,  //@@@@.......@@@
    0xff, 0xff, 0x90, 0x00, 0x00, 0x0f, 0xff,  //@@@@%......@@@
    0xff, 0xff, 0xf2, 0x00, 0x00, 0x0f, 0xff,  //@@@@@......@@@
    0xff, 0xff, 0xfa, 0x00, 0x00, 0x0f, 0xff,  //@@@@@%.....@@@
    0xff, 0xff, 0xff, 0x30, 0x00, 0x0f, 0xff,  //@@@@@@.....@@@
    0xff, 0xfa, 0xff, 0xb0, 0x00, 0x0f, 0xff,  //@@@%@@%....@@@
    0xff, 0xf2, 0xff, 0xf4, 0x00, 0x0f, 0xff,  //@@@.@@@+...@@@
    0xff, 0xf0, 0xaf, 0xfc, 0x00, 0x0f, 0xff,  //@@@.%@@@...@@@
    0xff, 0xf0, 0x2f, 0xff, 0x50, 0x0f, 0xff,  //@@@..@@@+..@@@
    0xff, 0xf0, 0x0a, 0xff, 0xd0, 0x0f, 0xff,  //@@@..%@@@..@@@
    0xff, 0xf0, 0x02, 0xff, 0xf6, 0x0f, 0xff,  //@@@...@@@+.@@@
    0xff, 0xf0, 0x00, 0xaf, 0xfe, 0x0f, 0xff,  //@@@...%@@@.@@@
    0xff, 0xf0, 0x00, 0x2f, 0xff, 0x7f, 0xff,  //@@@....@@@+@@@
    0xff, 0xf0, 0x00, 0x09, 0xff, 0xef, 0xff,  //@@@....%@@@@@@
    0xff, 0xf0, 0x00, 0x02, 0xff, 0xff, 0xff,  //@@@.....@@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x9f, 0xff, 0xff,  //@@@.....%@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x1f, 0xff, 0xff,  //@@@......@@@@@
    0xff, 0xf0, 0x00, 0x00, 0x09, 0xff, 0xff,  //@@@......%@@@@
    0xff, 0xf0, 0x00, 0x00, 0x01, 0xff, 0xff,  //@@@.......@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+004f (O) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x60, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //..+@@@%....%@@@+..
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //.+@@@........@@@..
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //.@@@+........+@@@.
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //+@@@..........%@@+
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //%@@+..........+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@............@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@............@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@............@@@
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //%@@+..........+@@%
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //+@@@..........%@@+
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //.@@@+........+@@@.
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //.+@@@........@@@+.
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x60, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0050 (P) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xfd, 0x93, 0x00,  //@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //@@@@@@@@@@+.
    0xff, 0xf0, 0x00, 0x17, 0xff, 0xf4,  //@@@....+@@@+
    0xff, 0xf0, 0x00, 0x00, 0x8f, 0xfb,  //@@@.....%@@%
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xfe,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xfe,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x8f, 0xfb,  //@@@.....+@@%
    0xff, 0xf0, 0x00, 0x17, 0xff, 0xf4,  //@@@....+@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xfd, 0x93, 0x00,  //@@@@@@@@%...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0051 (Q) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x06, 0xad, 0xff, 0xda, 0x60, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x04, 0xef, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf6, 0x00,  //..+@@@%....%@@@+..
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x40,  //.+@@@........@@@..
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //.@@@+........+@@@.
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf5,  //+@@@..........%@@+
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //%@@+..........+@@%
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@............@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@............@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@............@@@
    0xef, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xfe,  //@@@............@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@............@@@
    0x9f, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xf9,  //%@@+..........+@@%
    0x5f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xf4,  //+@@@..........%@@+
    0x0d, 0xff, 0x40, 0x00, 0x00, 0x00, 0x04, 0xff, 0xd0,  //.@@@+........+@@@.
    0x04, 0xff, 0xe3, 0x00, 0x00, 0x00, 0x3e, 0xff, 0x30,  //.+@@@........@@@..
    0x00, 0x6f, 0xff, 0x83, 0x00, 0x38, 0xff, 0xf5, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x05, 0xef, 0xff, 0xff, 0xff, 0xfd, 0x30, 0x00,  //...+@@@@@@@@@@....
    0x00, 0x00, 0x06, 0xbe, 0xff, 0xff, 0xd0, 0x00, 0x00,  //.....+%@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xfa, 0x00, 0x00,  //...........@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xef, 0x90, 0x00,  //............@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8, 0x00,  //.............@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0052 (R) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xfd, 0xa3, 0x00, 0x00, 0x00,  //@@@@@@@@%......
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00,  //@@@@@@@@@@%....
    0xff, 0xf0, 0x00, 0x16, 0xff, 0xf4, 0x00, 0x00,  //@@@....+@@@+...
    0xff, 0xf0, 0x00, 0x00, 0x7f, 0xfb, 0x00, 0x00,  //@@@.....+@@%...
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xfe, 0x00, 0x00,  //@@@......@@@...
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //@@@......@@@...
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xfd, 0x00, 0x00,  //@@@......@@@...
    0xff, 0xf0, 0x00, 0x00, 0x7f, 0xf9, 0x00, 0x00,  //@@@.....+@@%...
    0xff, 0xf0, 0x00, 0x17, 0xff, 0xe1, 0x00, 0x00,  //@@@....+@@@....
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x00, 0x00,  //@@@@@@@@@%.....
    0xff, 0xff, 0xff, 0xff, 0xe4, 0x00, 0x00, 0x00,  //@@@@@@@@@+.....
    0xff, 0xf0, 0x01, 0x6f, 0xff, 0x50, 0x00, 0x00,  //@@@...+@@@+....
    0xff, 0xf0, 0x00, 0x05, 0xff, 0xf2, 0x00, 0x00,  //@@@....+@@@....
    0xff, 0xf0, 0x00, 0x00, 0xbf, 0xfb, 0x00, 0x00,  //@@@.....%@@%...
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xff, 0x50, 0x00,  //@@@......@@@+..
    0xff, 0xf0, 0x00, 0x00, 0x09, 0xff, 0xd0, 0x00,  //@@@......%@@@..
    0xff, 0xf0, 0x00, 0x00, 0x01, 0xef, 0xf8, 0x00,  //@@@.......@@@+.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x6f, 0xff, 0x20,  //@@@.......+@@@.
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xb0,  //@@@........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0053 (S) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x18, 0xce, 0xff, 0xda, 0x72, 0x00,  //...%@@@@@%+..
    0x05, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.+@@@@@@@@@@.
    0x3f, 0xff, 0x93, 0x10, 0x38, 0xff, 0x00,  //.@@@%....%@@.
    0xbf, 0xf7, 0x00, 0x00, 0x00, 0x1a, 0x00,  //%@@+.......%.
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xdf, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%.........
    0x8f, 0xff, 0xfb, 0x84, 0x10, 0x00, 0x00,  //+@@@@%%+.....
    0x0b, 0xff, 0xff, 0xff, 0xfb, 0x40, 0x00,  //.%@@@@@@@%+..
    0x00, 0x6c, 0xff, 0xff, 0xff, 0xf8, 0x00,  //..+@@@@@@@@+.
    0x00, 0x00, 0x15, 0x8d, 0xff, 0xff, 0x40,  //.....+%@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xb0,  //.........@@@%
    0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xe0,  //.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0,  //..........@@@
    0xb2, 0x00, 0x00, 0x00, 0x08, 0xff, 0xb0,  //%........%@@%
    0xff, 0xa5, 0x10, 0x13, 0xaf, 0xff, 0x30,  //@@%+....%@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x00,  //@@@@@@@@@@@+.
    0x26, 0xac, 0xef, 0xfe, 0xb7, 0x10, 0x00,  //.+%@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0054 (T) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0055 (U) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff,  //@@@........@@@
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x2f, 0xfd,  //@@@........@@@
    0xaf, 0xf6, 0x00, 0x00, 0x00, 0x6f, 0xfa,  //%@@+......+@@%
    0x4f, 0xfd, 0x00, 0x00, 0x00, 0xdf, 0xf4,  //+@@@......@@@+
    0x0b, 0xff, 0xb3, 0x00, 0x3c, 0xff, 0xb0,  //.%@@%....%@@%.
    0x01, 0xbf, 0xff, 0xff, 0xff, 0xfb, 0x00,  //..%@@@@@@@@%..
    0x00, 0x05, 0xae, 0xff, 0xea, 0x40, 0x00,  //...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0056 (V) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xc0,  //@@@+.........+@@@
    0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x60,  //+@@%.........@@@+
    0x1f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x10,  //.@@@.........@@@.
    0x0b, 0xff, 0x80, 0x00, 0x00, 0x00, 0x8f, 0xfb, 0x00,  //.%@@+.......+@@%.
    0x05, 0xff, 0xd0, 0x00, 0x00, 0x00, 0xdf, 0xf5, 0x00,  //.+@@@.......@@@+.
    0x00, 0xef, 0xf3, 0x00, 0x00, 0x04, 0xff, 0xe0, 0x00,  //..@@@.......@@@..
    0x00, 0x9f, 0xf9, 0x00, 0x00, 0x09, 0xff, 0x90, 0x00,  //..%@@%.....%@@%..
    0x00, 0x3f, 0xff, 0x00, 0x00, 0x0f, 0xff, 0x30, 0x00,  //...@@@.....@@@...
    0x00, 0x0d, 0xff, 0x50, 0x00, 0x5f, 0xfd, 0x00, 0x00,  //...@@@+...+@@@...
    0x00, 0x07, 0xff, 0xb0, 0x00, 0xbf, 0xf7, 0x00, 0x00,  //...+@@%...%@@+...
    0x00, 0x01, 0xff, 0xf1, 0x01, 0xff, 0xf1, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0xbf, 0xf7, 0x07, 0xff, 0xb0, 0x00, 0x00,  //....%@@+.+@@%....
    0x00, 0x00, 0x5f, 0xfd, 0x0d, 0xff, 0x50, 0x00, 0x00,  //....+@@@.@@@+....
    0x00, 0x00, 0x0e, 0xff, 0x7f, 0xfe, 0x00, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x00, 0x09, 0xff, 0xff, 0xf9, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x03, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0xdf, 0xff, 0xd0, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x7f, 0xff, 0x70, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0x1f, 0xff, 0x10, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0057 (W) , Width: 24 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0xdf, 0xf3, 0x00, 0x00, 0x00, 0x8f, 0xf9, 0x00, 0x00, 0x00, 0x3f, 0xfd,  //@@@.......%@@%.......@@@
    0x9f, 0xf7, 0x00, 0x00, 0x00, 0xcf, 0xfd, 0x00, 0x00, 0x00, 0x7f, 0xf9,  //%@@+......@@@@......+@@%
    0x5f, 0xfb, 0x00, 0x00, 0x00, 0xff, 0xff, 0x10, 0x00, 0x00, 0xbf, 0xf5,  //+@@%......@@@@......%@@+
    0x1f, 0xff, 0x00, 0x00, 0x04, 0xfc, 0xbf, 0x50, 0x00, 0x00, 0xff, 0xf1,  //.@@@.....+@@%@+.....@@@.
    0x0d, 0xff, 0x30, 0x00, 0x08, 0xf8, 0x7f, 0x80, 0x00, 0x03, 0xff, 0xd0,  //.@@@.....%@%+@%.....@@@.
    0x09, 0xff, 0x70, 0x00, 0x0c, 0xf4, 0x4f, 0xc0, 0x00, 0x07, 0xff, 0x90,  //.%@@+....@@+.@@....+@@%.
    0x05, 0xff, 0xb0, 0x00, 0x0f, 0xf0, 0x0f, 0xf0, 0x00, 0x0b, 0xff, 0x50,  //.+@@%....@@..@@....%@@+.
    0x01, 0xff, 0xf0, 0x00, 0x4f, 0xc0, 0x0c, 0xf4, 0x00, 0x0f, 0xff, 0x10,  //..@@@...+@@..@@+...@@@..
    0x00, 0xdf, 0xf3, 0x00, 0x8f, 0x80, 0x08, 0xf8, 0x00, 0x3f, 0xfd, 0x00,  //..@@@...%@%..%@%...@@@..
    0x00, 0x9f, 0xf7, 0x00, 0xcf, 0x40, 0x04, 0xfc, 0x00, 0x7f, 0xf9, 0x00,  //..%@@+..%@+..+@@..+@@%..
    0x00, 0x5f, 0xfb, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0xbf, 0xf5, 0x00,  //..+@@%..@@....@@..%@@+..
    0x00, 0x1f, 0xff, 0x03, 0xfc, 0x00, 0x00, 0xcf, 0x40, 0xff, 0xf1, 0x00,  //...@@@..@@....@@..@@@...
    0x00, 0x0d, 0xff, 0x37, 0xf8, 0x00, 0x00, 0x8f, 0x73, 0xff, 0xd0, 0x00,  //...@@@.+@%....%@+.@@@...
    0x00, 0x09, 0xff, 0x7b, 0xf4, 0x00, 0x00, 0x5f, 0xb7, 0xff, 0x90, 0x00,  //...%@@+%@+....+@%+@@%...
    0x00, 0x05, 0xff, 0xbf, 0xf1, 0x00, 0x00, 0x1f, 0xfb, 0xff, 0x50, 0x00,  //...+@@%@@......@@%@@+...
    0x00, 0x01, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x0d, 0xff, 0xff, 0x10, 0x00,  //....@@@@@......@@@@@....
    0x00, 0x00, 0xdf, 0xff, 0x90, 0x00, 0x00, 0x09, 0xff, 0xfd, 0x00, 0x00,  //....@@@@%......%@@@@....
    0x00, 0x00, 0x9f, 0xff, 0x50, 0x00, 0x00, 0x05, 0xff, 0xf9, 0x00, 0x00,  //....%@@@+......+@@@%....
    0x00, 0x00, 0x5f, 0xff, 0x10, 0x00, 0x00, 0x01, 0xff, 0xf5, 0x00, 0x00,  //....+@@@........@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................


    /*Unicode: U+0058 (X) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x0b, 0xff, 0xd0, 0x00, 0x00, 0x00, 0xef, 0xfa,  //.%@@@.......@@@%
    0x02, 0xff, 0xf8, 0x00, 0x00, 0x09, 0xff, 0xe1,  //..@@@+.....%@@@.
    0x00, 0x7f, 0xff, 0x20, 0x00, 0x3f, 0xff, 0x50,  //..+@@@.....@@@+.
    0x00, 0x0d, 0xff, 0xb0, 0x00, 0xdf, 0xfb, 0x00,  //...@@@%...@@@%..
    0x00, 0x04, 0xff, 0xf4, 0x08, 0xff, 0xf1, 0x00,  //...+@@@+.%@@@...
    0x00, 0x00, 0xaf, 0xfd, 0x3f, 0xff, 0x60, 0x00,  //....%@@@.@@@+...
    0x00, 0x00, 0x1f, 0xff, 0xff, 0xfc, 0x00, 0x00,  //.....@@@@@@%....
    0x00, 0x00, 0x07, 0xff, 0xff, 0xf2, 0x00, 0x00,  //.....+@@@@@.....
    0x00, 0x00, 0x00, 0xdf, 0xff, 0x70, 0x00, 0x00,  //......@@@@+.....
    0x00, 0x00, 0x00, 0xcf, 0xff, 0x40, 0x00, 0x00,  //......@@@@+.....
    0x00, 0x00, 0x07, 0xff, 0xff, 0xd0, 0x00, 0x00,  //.....+@@@@@.....
    0x00, 0x00, 0x2f, 0xff, 0xff, 0xf7, 0x00, 0x00,  //.....@@@@@@+....
    0x00, 0x00, 0xcf, 0xfd, 0x7f, 0xff, 0x20, 0x00,  //....%@@@+@@@....
    0x00, 0x06, 0xff, 0xf3, 0x0d, 0xff, 0xb0, 0x00,  //...+@@@..@@@%...
    0x00, 0x1f, 0xff, 0x80, 0x03, 0xff, 0xf4, 0x00,  //...@@@%...@@@+..
    0x00, 0xbf, 0xfd, 0x00, 0x00, 0xaf, 0xfd, 0x00,  //..%@@@....%@@@..
    0x05, 0xff, 0xf4, 0x00, 0x00, 0x1f, 0xff, 0x70,  //.+@@@......@@@+.
    0x1e, 0xff, 0x90, 0x00, 0x00, 0x06, 0xff, 0xf2,  //.@@@%......+@@@.
    0xaf, 0xfe, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xfb,  //%@@@........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0059 (Y) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xaf, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xa0,  //%@@@.........@@@%
    0x0e, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xbf, 0xfe, 0x00,  //.@@@%.......%@@@.
    0x03, 0xff, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xf3, 0x00,  //..@@@+.....+@@@..
    0x00, 0x8f, 0xff, 0x20, 0x00, 0x2f, 0xff, 0x80, 0x00,  //..%@@@.....@@@%..
    0x00, 0x0c, 0xff, 0xc0, 0x00, 0xcf, 0xfc, 0x00, 0x00,  //...@@@@...@@@@...
    0x00, 0x02, 0xff, 0xf8, 0x08, 0xff, 0xf2, 0x00, 0x00,  //....@@@%.%@@@....
    0x00, 0x00, 0x6f, 0xff, 0x7f, 0xff, 0x60, 0x00, 0x00,  //....+@@@+@@@+....
    0x00, 0x00, 0x0b, 0xff, 0xff, 0xfb, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x01, 0xef, 0xff, 0xe1, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x5f, 0xff, 0x50, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+005a (Z) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x90,  //...........@@@%
    0x00, 0x00, 0x00, 0x00, 0x01, 0xef, 0xfd, 0x00,  //..........@@@@.
    0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0xf2, 0x00,  //.........%@@@..
    0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x50, 0x00,  //........+@@@+..
    0x00, 0x00, 0x00, 0x03, 0xff, 0xf9, 0x00, 0x00,  //........@@@%...
    0x00, 0x00, 0x00, 0x0d, 0xff, 0xd0, 0x00, 0x00,  //.......@@@@....
    0x00, 0x00, 0x00, 0xaf, 0xff, 0x20, 0x00, 0x00,  //......%@@@.....
    0x00, 0x00, 0x06, 0xff, 0xf5, 0x00, 0x00, 0x00,  //.....+@@@+.....
    0x00, 0x00, 0x3f, 0xff, 0x90, 0x00, 0x00, 0x00,  //.....@@@%......
    0x00, 0x00, 0xdf, 0xfd, 0x00, 0x00, 0x00, 0x00,  //....@@@@.......
    0x00, 0x0a, 0xff, 0xf2, 0x00, 0x00, 0x00, 0x00,  //...%@@@........
    0x00, 0x6f, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00,  //..+@@@+........
    0x02, 0xff, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@%.........
    0x0d, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@..........
    0x9f, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+005b ([) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0xff, 0xff, 0xff,  //@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xf0, 0x00,  //@@@...
    0xff, 0xff, 0xff,  //@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+005c (\) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xdf, 0x40, 0x00, 0x00, 0x00,  //@@+......
    0x8f, 0x90, 0x00, 0x00, 0x00,  //+@%......
    0x2f, 0xe0, 0x00, 0x00, 0x00,  //.@@......
    0x0d, 0xf4, 0x00, 0x00, 0x00,  //.@@......
    0x08, 0xf9, 0x00, 0x00, 0x00,  //.%@%.....
    0x03, 0xfe, 0x00, 0x00, 0x00,  //..@@.....
    0x00, 0xdf, 0x30, 0x00, 0x00,  //..@@.....
    0x00, 0x8f, 0x90, 0x00, 0x00,  //..%@%....
    0x00, 0x3f, 0xe0, 0x00, 0x00,  //...@@....
    0x00, 0x0e, 0xf3, 0x00, 0x00,  //...@@....
    0x00, 0x08, 0xf8, 0x00, 0x00,  //...%@%...
    0x00, 0x03, 0xfe, 0x00, 0x00,  //....@@...
    0x00, 0x00, 0xef, 0x30, 0x00,  //....@@...
    0x00, 0x00, 0x9f, 0x80, 0x00,  //....%@%..
    0x00, 0x00, 0x3f, 0xd0, 0x00,  //.....@@..
    0x00, 0x00, 0x0e, 0xf3, 0x00,  //.....@@..
    0x00, 0x00, 0x09, 0xf8, 0x00,  //.....%@%.
    0x00, 0x00, 0x04, 0xfd, 0x00,  //......@@.
    0x00, 0x00, 0x00, 0xef, 0x20,  //......@@.
    0x00, 0x00, 0x00, 0x9f, 0x80,  //......%@+
    0x00, 0x00, 0x00, 0x4f, 0xd0,  //......+@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+005d (]) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0xff, 0xff, 0xff,  //@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0x00, 0x0f, 0xff,  //...@@@
    0xff, 0xff, 0xff,  //@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+005e (^) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0xaf, 0xfa, 0x00, 0x00, 0x00,  //......%@@%......
    0x00, 0x00, 0x0a, 0xff, 0xff, 0xa0, 0x00, 0x00,  //.....%@@@@%.....
    0x00, 0x00, 0xaf, 0xf7, 0x7f, 0xfa, 0x00, 0x00,  //....%@@++@@%....
    0x00, 0x09, 0xff, 0x60, 0x06, 0xff, 0x90, 0x00,  //...%@@+..+@@%...
    0x00, 0x9f, 0xf4, 0x00, 0x00, 0x4f, 0xf9, 0x00,  //..%@@+....+@@%..
    0x08, 0xfe, 0x30, 0x00, 0x00, 0x03, 0xef, 0x80,  //.%@@........@@%.
    0x8f, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xf8,  //%@@..........@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+005f (_) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@


    /*Unicode: U+0060 (`) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x9f, 0xc0, 0x00,  //%@@...
    0x0c, 0xf8, 0x00,  //.%@%..
    0x01, 0xef, 0x30,  //..@@..
    0x00, 0x2f, 0xd0,  //...@@.
    0x00, 0x05, 0xfa,  //...+@%
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0061 (a) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x02, 0x7b, 0xef, 0xfd, 0x93, 0x00,  //..+%@@@@%...
    0x0f, 0xff, 0xff, 0xff, 0xff, 0x60,  //.@@@@@@@@@+.
    0x0c, 0x62, 0x00, 0x27, 0xff, 0xf3,  //.@+....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xfa,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xfd,  //.........@@@
    0x00, 0x5a, 0xdf, 0xff, 0xff, 0xff,  //..+%@@@@@@@@
    0x0b, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@
    0x8f, 0xfe, 0x51, 0x00, 0x0f, 0xff,  //+@@@+....@@@
    0xdf, 0xf3, 0x00, 0x00, 0x2f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x5f, 0xff,  //@@@.....+@@@
    0xef, 0xf3, 0x00, 0x00, 0xdf, 0xff,  //@@@.....@@@@
    0xaf, 0xfc, 0x30, 0x2b, 0xaf, 0xff,  //%@@@...%%@@@
    0x2e, 0xff, 0xff, 0xfd, 0x1f, 0xff,  //.@@@@@@@.@@@
    0x02, 0xae, 0xfd, 0x81, 0x0f, 0xff,  //..%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0062 (b) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x19, 0xef, 0xd8, 0x00, 0x00,  //@@@..%@@@%...
    0xff, 0xf1, 0xdf, 0xff, 0xff, 0xd1, 0x00,  //@@@.@@@@@@@..
    0xff, 0xfb, 0xb2, 0x02, 0xbf, 0xfc, 0x00,  //@@@%%...%@@@.
    0xff, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x50,  //@@@@.....@@@+
    0xff, 0xf5, 0x00, 0x00, 0x05, 0xff, 0xa0,  //@@@+.....+@@%
    0xff, 0xf1, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf1, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf5, 0x00, 0x00, 0x05, 0xff, 0xa0,  //@@@+.....+@@%
    0xff, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x50,  //@@@@.....@@@+
    0xff, 0xfb, 0xb2, 0x02, 0xbf, 0xfc, 0x00,  //@@@%%...%@@@.
    0xff, 0xf1, 0xef, 0xff, 0xff, 0xe2, 0x00,  //@@@.@@@@@@@..
    0xff, 0xf0, 0x19, 0xef, 0xd8, 0x10, 0x00,  //@@@..%@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0063 (c) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x03, 0xad, 0xff, 0xd9, 0x30,  //....%@@@@%.
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xf0,  //..%@@@@@@@@
    0x0a, 0xff, 0xe5, 0x10, 0x15, 0xc0,  //.%@@@+...+%
    0x4f, 0xfe, 0x10, 0x00, 0x00, 0x00,  //.@@@.......
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00,  //%@@+.......
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xdf, 0xf2, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xaf, 0xf7, 0x00, 0x00, 0x00, 0x00,  //%@@+.......
    0x3f, 0xfe, 0x10, 0x00, 0x00, 0x00,  //.@@@.......
    0x0a, 0xff, 0xe5, 0x10, 0x15, 0xc0,  //.%@@@+...+%
    0x00, 0xaf, 0xff, 0xff, 0xff, 0xf0,  //..%@@@@@@@@
    0x00, 0x04, 0xae, 0xff, 0xd9, 0x30,  //...+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0064 (d) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x18, 0xdf, 0xe9, 0x10, 0xff, 0xf0,  //...%@@@%..@@@
    0x01, 0xdf, 0xff, 0xff, 0xd1, 0xff, 0xf0,  //..@@@@@@@.@@@
    0x0c, 0xff, 0xb2, 0x02, 0xbb, 0xff, 0xf0,  //.@@@%...%%@@@
    0x5f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0xf0,  //+@@@.....@@@@
    0xaf, 0xf5, 0x00, 0x00, 0x05, 0xff, 0xf0,  //%@@+.....+@@@
    0xef, 0xf1, 0x00, 0x00, 0x02, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xef, 0xf1, 0x00, 0x00, 0x02, 0xff, 0xf0,  //@@@.......@@@
    0xaf, 0xf5, 0x00, 0x00, 0x05, 0xff, 0xf0,  //%@@+.....+@@@
    0x5f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0xf0,  //+@@@.....@@@@
    0x0c, 0xff, 0xb2, 0x02, 0xbb, 0xff, 0xf0,  //.@@@%...%%@@@
    0x02, 0xef, 0xff, 0xff, 0xd1, 0xff, 0xf0,  //..@@@@@@@.@@@
    0x00, 0x18, 0xdf, 0xe9, 0x10, 0xff, 0xf0,  //...%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0065 (e) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x03, 0xad, 0xff, 0xc7, 0x00, 0x00,  //....%@@@@+...
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xd2, 0x00,  //..%@@@@@@@@..
    0x09, 0xff, 0xc3, 0x01, 0x8f, 0xfc, 0x00,  //.%@@@...%@@@.
    0x3f, 0xfd, 0x00, 0x00, 0x0a, 0xff, 0x60,  //.@@@.....%@@+
    0x9f, 0xf6, 0x00, 0x00, 0x03, 0xff, 0xb0,  //%@@+......@@%
    0xdf, 0xf2, 0x00, 0x00, 0x01, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@
    0xef, 0xf1, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xaf, 0xf5, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.........
    0x4f, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.........
    0x0a, 0xff, 0xd5, 0x10, 0x03, 0x7c, 0x00,  //.%@@@+....+@.
    0x00, 0x9f, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0x03, 0xad, 0xff, 0xeb, 0x72, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0066 (f) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x01, 0x8d, 0xff, 0xf0,  //....%@@@@
    0x00, 0x1e, 0xff, 0xff, 0xf0,  //...@@@@@@
    0x00, 0x9f, 0xfa, 0x10, 0x00,  //..%@@%...
    0x00, 0xdf, 0xf2, 0x00, 0x00,  //..@@@....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@....
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0067 (g) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x18, 0xdf, 0xe9, 0x10, 0xff, 0xf0,  //...%@@@%..@@@
    0x02, 0xef, 0xff, 0xff, 0xd1, 0xff, 0xf0,  //..@@@@@@@.@@@
    0x0d, 0xff, 0xb2, 0x02, 0xbb, 0xff, 0xf0,  //.@@@%...%%@@@
    0x5f, 0xfc, 0x00, 0x00, 0x0c, 0xff, 0xf0,  //+@@@.....@@@@
    0xbf, 0xf5, 0x00, 0x00, 0x05, 0xff, 0xf0,  //%@@+.....+@@@
    0xef, 0xf1, 0x00, 0x00, 0x01, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xef, 0xf1, 0x00, 0x00, 0x01, 0xff, 0xf0,  //@@@.......@@@
    0xbf, 0xf5, 0x00, 0x00, 0x05, 0xff, 0xf0,  //%@@+.....+@@@
    0x5f, 0xfc, 0x00, 0x00, 0x0c, 0xff, 0xf0,  //+@@@.....@@@@
    0x0d, 0xff, 0xb2, 0x02, 0xbb, 0xff, 0xf0,  //.@@@%...%%@@@
    0x02, 0xef, 0xff, 0xff, 0xd1, 0xff, 0xf0,  //..@@@@@@@.@@@
    0x00, 0x19, 0xdf, 0xe9, 0x11, 0xff, 0xe0,  //...%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xb0,  //.........+@@%
    0x00, 0x00, 0x00, 0x00, 0x0b, 0xff, 0x70,  //.........%@@+
    0x00, 0xc5, 0x20, 0x04, 0xbf, 0xfe, 0x10,  //..@+....%@@@.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x00,  //..@@@@@@@@@..
    0x00, 0x39, 0xce, 0xfe, 0xc7, 0x10, 0x00,  //...%@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0068 (h) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xf0, 0x19, 0xef, 0xd7, 0x00,  //@@@..%@@@+..
    0xff, 0xf1, 0xdf, 0xff, 0xff, 0xb0,  //@@@.@@@@@@%.
    0xff, 0xfa, 0xa2, 0x04, 0xff, 0xf5,  //@@@%%..+@@@+
    0xff, 0xfc, 0x00, 0x00, 0x7f, 0xfa,  //@@@@....+@@%
    0xff, 0xf5, 0x00, 0x00, 0x2f, 0xfe,  //@@@+.....@@@
    0xff, 0xf2, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0069 (i) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+006a (j) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x00, 0xff, 0xf0,  //..@@@
    0x01, 0xff, 0xd0,  //..@@@
    0x09, 0xff, 0x90,  //.%@@%
    0xff, 0xfe, 0x10,  //@@@@.
    0xfd, 0x91, 0x00,  //@@%..
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+006b (k) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x03, 0xef, 0xff, 0x60,  //@@@.....@@@@+
    0xff, 0xf0, 0x00, 0x5f, 0xff, 0xf4, 0x00,  //@@@...+@@@@+.
    0xff, 0xf0, 0x07, 0xff, 0xfe, 0x30, 0x00,  //@@@..+@@@@...
    0xff, 0xf0, 0x9f, 0xff, 0xd1, 0x00, 0x00,  //@@@.%@@@@....
    0xff, 0xfb, 0xff, 0xfb, 0x00, 0x00, 0x00,  //@@@%@@@%.....
    0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00,  //@@@@@@%......
    0xff, 0xff, 0xfb, 0x00, 0x00, 0x00, 0x00,  //@@@@@%.......
    0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00,  //@@@@@@+......
    0xff, 0xfc, 0xff, 0xf6, 0x00, 0x00, 0x00,  //@@@@@@@+.....
    0xff, 0xf1, 0xcf, 0xff, 0x60, 0x00, 0x00,  //@@@.@@@@+....
    0xff, 0xf0, 0x0c, 0xff, 0xf6, 0x00, 0x00,  //@@@..@@@@+...
    0xff, 0xf0, 0x00, 0xcf, 0xff, 0x70, 0x00,  //@@@...@@@@+..
    0xff, 0xf0, 0x00, 0x0c, 0xff, 0xf7, 0x00,  //@@@....%@@@+.
    0xff, 0xf0, 0x00, 0x00, 0xbf, 0xff, 0x70,  //@@@.....%@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+006c (l) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+006d (m) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xf0, 0x19, 0xef, 0xc5, 0x00, 0x01, 0x9d, 0xfd, 0x70, 0x00,  //@@@..%@@@+....%@@@+..
    0xff, 0xf1, 0xdf, 0xff, 0xff, 0x70, 0x2e, 0xff, 0xff, 0xfa, 0x00,  //@@@.@@@@@@+..@@@@@@%.
    0xff, 0xfa, 0xa2, 0x04, 0xef, 0xf2, 0xda, 0x20, 0x4e, 0xff, 0x40,  //@@@%%..+@@@.@%..+@@@+
    0xff, 0xfc, 0x00, 0x00, 0x6f, 0xfe, 0xc0, 0x00, 0x06, 0xff, 0xa0,  //@@@@....+@@@@....+@@%
    0xff, 0xf5, 0x00, 0x00, 0x2f, 0xff, 0x50, 0x00, 0x02, 0xff, 0xd0,  //@@@+.....@@@+.....@@@
    0xff, 0xf2, 0x00, 0x00, 0x0f, 0xff, 0x20, 0x00, 0x00, 0xff, 0xf0,  //@@@......@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@......@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@......@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@......@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@......@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@......@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@......@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@......@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@......@@@......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+006e (n) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xf0, 0x19, 0xef, 0xd7, 0x00,  //@@@..%@@@+..
    0xff, 0xf1, 0xdf, 0xff, 0xff, 0xb0,  //@@@.@@@@@@%.
    0xff, 0xfa, 0xa2, 0x04, 0xff, 0xf5,  //@@@%%..+@@@+
    0xff, 0xfc, 0x00, 0x00, 0x7f, 0xfa,  //@@@@....+@@%
    0xff, 0xf5, 0x00, 0x00, 0x2f, 0xfe,  //@@@+.....@@@
    0xff, 0xf2, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+006f (o) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x06, 0xbe, 0xfe, 0xb5, 0x00, 0x00,  //...+%@@@%+...
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0x00,  //..@@@@@@@@@..
    0x0b, 0xff, 0xb2, 0x02, 0xbf, 0xfb, 0x00,  //.%@@%...%@@%.
    0x4f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x40,  //+@@@.....@@@+
    0xaf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xa0,  //%@@+.....+@@%
    0xef, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xef, 0xf2, 0x00, 0x00, 0x02, 0xff, 0xd0,  //@@@.......@@@
    0xaf, 0xf6, 0x00, 0x00, 0x06, 0xff, 0xa0,  //%@@+.....+@@%
    0x5f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x40,  //+@@@.....@@@+
    0x0b, 0xff, 0xb2, 0x02, 0xbf, 0xfb, 0x00,  //.%@@%...%@@%.
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0x00,  //..@@@@@@@@@..
    0x00, 0x06, 0xbe, 0xfe, 0xb5, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0070 (p) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xf0, 0x19, 0xef, 0xd8, 0x00, 0x00,  //@@@..%@@@%...
    0xff, 0xf1, 0xdf, 0xff, 0xff, 0xd1, 0x00,  //@@@.@@@@@@@..
    0xff, 0xfb, 0xb2, 0x02, 0xbf, 0xfc, 0x00,  //@@@%%...%@@@.
    0xff, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x50,  //@@@@.....@@@+
    0xff, 0xf5, 0x00, 0x00, 0x05, 0xff, 0xa0,  //@@@+.....+@@%
    0xff, 0xf1, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf1, 0x00, 0x00, 0x02, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xf5, 0x00, 0x00, 0x05, 0xff, 0xa0,  //@@@+.....+@@%
    0xff, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0x50,  //@@@@.....@@@+
    0xff, 0xfb, 0xb2, 0x02, 0xbf, 0xfc, 0x00,  //@@@%%...%@@@.
    0xff, 0xf1, 0xef, 0xff, 0xff, 0xe2, 0x00,  //@@@.@@@@@@@..
    0xff, 0xf0, 0x19, 0xef, 0xd8, 0x10, 0x00,  //@@@..%@@@%...
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0071 (q) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x18, 0xdf, 0xe9, 0x10, 0xff, 0xf0,  //...%@@@%..@@@
    0x01, 0xdf, 0xff, 0xff, 0xd1, 0xff, 0xf0,  //..@@@@@@@.@@@
    0x0c, 0xff, 0xb2, 0x02, 0xbb, 0xff, 0xf0,  //.@@@%...%%@@@
    0x5f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0xf0,  //+@@@.....@@@@
    0xaf, 0xf5, 0x00, 0x00, 0x05, 0xff, 0xf0,  //%@@+.....+@@@
    0xef, 0xf1, 0x00, 0x00, 0x02, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xff, 0xf0, 0x00, 0x00, 0x00, 0xff, 0xf0,  //@@@.......@@@
    0xef, 0xf1, 0x00, 0x00, 0x02, 0xff, 0xf0,  //@@@.......@@@
    0xaf, 0xf5, 0x00, 0x00, 0x05, 0xff, 0xf0,  //%@@+.....+@@@
    0x5f, 0xfd, 0x00, 0x00, 0x0d, 0xff, 0xf0,  //+@@@.....@@@@
    0x0c, 0xff, 0xb2, 0x02, 0xbb, 0xff, 0xf0,  //.@@@%...%%@@@
    0x02, 0xef, 0xff, 0xff, 0xd1, 0xff, 0xf0,  //..@@@@@@@.@@@
    0x00, 0x18, 0xdf, 0xe9, 0x10, 0xff, 0xf0,  //...%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0072 (r) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xf0, 0x2b, 0xef,  //@@@..%@@
    0xff, 0xf2, 0xef, 0xff,  //@@@.@@@@
    0xff, 0xfb, 0xa2, 0x00,  //@@@%%...
    0xff, 0xfc, 0x00, 0x00,  //@@@@....
    0xff, 0xf5, 0x00, 0x00,  //@@@+....
    0xff, 0xf1, 0x00, 0x00,  //@@@.....
    0xff, 0xf0, 0x00, 0x00,  //@@@.....
    0xff, 0xf0, 0x00, 0x00,  //@@@.....
    0xff, 0xf0, 0x00, 0x00,  //@@@.....
    0xff, 0xf0, 0x00, 0x00,  //@@@.....
    0xff, 0xf0, 0x00, 0x00,  //@@@.....
    0xff, 0xf0, 0x00, 0x00,  //@@@.....
    0xff, 0xf0, 0x00, 0x00,  //@@@.....
    0xff, 0xf0, 0x00, 0x00,  //@@@.....
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0073 (s) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x01, 0x8c, 0xff, 0xfc, 0x93, 0x00,  //..+@@@@@%..
    0x2e, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@.
    0xbf, 0xfc, 0x30, 0x02, 0x5c, 0x00,  //%@@@....+%.
    0xff, 0xf1, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xf1, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xaf, 0xfc, 0x88, 0x51, 0x00, 0x00,  //%@@@+%+....
    0x1c, 0xff, 0xff, 0xff, 0x91, 0x00,  //.@@@@@@@%..
    0x00, 0x49, 0xdf, 0xff, 0xfd, 0x10,  //..+%@@@@@@.
    0x00, 0x00, 0x01, 0x6d, 0xff, 0x90,  //......+@@@%
    0x00, 0x00, 0x00, 0x02, 0xff, 0xe0,  //........@@@
    0x00, 0x00, 0x00, 0x01, 0xff, 0xf0,  //........@@@
    0xd7, 0x31, 0x00, 0x3c, 0xff, 0xa0,  //@+.....@@@%
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x10,  //@@@@@@@@@@.
    0x27, 0xbe, 0xff, 0xeb, 0x60, 0x00,  //.+%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0074 (t) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@.....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@.....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@.....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@.....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@.....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@.....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@.....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@.....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@.....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@.....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@.....
    0x00, 0xff, 0xf0, 0x00, 0x00,  //..@@@.....
    0x00, 0xef, 0xf1, 0x00, 0x00,  //..@@@.....
    0x00, 0xbf, 0xf8, 0x10, 0x00,  //..%@@%....
    0x00, 0x3f, 0xff, 0xff, 0xff,  //...@@@@@@@
    0x00, 0x03, 0xad, 0xff, 0xff,  //....%@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0075 (u) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff,  //@@@......@@@
    0xff, 0xf0, 0x00, 0x00, 0x2f, 0xff,  //@@@......@@@
    0xef, 0xf2, 0x00, 0x00, 0x5f, 0xff,  //@@@.....+@@@
    0xaf, 0xf7, 0x00, 0x00, 0xcf, 0xff,  //%@@+....@@@@
    0x5f, 0xfe, 0x40, 0x2a, 0xaf, 0xff,  //+@@@+..%%@@@
    0x0b, 0xff, 0xff, 0xfd, 0x1f, 0xff,  //.%@@@@@@.@@@
    0x00, 0x7d, 0xfe, 0x91, 0x0f, 0xff,  //..+@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0076 (v) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xcf, 0xf6, 0x00, 0x00, 0x00, 0x6f, 0xfc,  //@@@+......+@@@
    0x6f, 0xfc, 0x00, 0x00, 0x00, 0xcf, 0xf6,  //+@@@......@@@+
    0x1f, 0xff, 0x20, 0x00, 0x02, 0xff, 0xf1,  //.@@@......@@@.
    0x0a, 0xff, 0x80, 0x00, 0x09, 0xff, 0xa0,  //.%@@%....%@@%.
    0x04, 0xff, 0xe0, 0x00, 0x0e, 0xff, 0x40,  //.+@@@....@@@+.
    0x00, 0xdf, 0xf5, 0x00, 0x5f, 0xfd, 0x00,  //..@@@+..+@@@..
    0x00, 0x7f, 0xfb, 0x00, 0xbf, 0xf7, 0x00,  //..+@@%..%@@+..
    0x00, 0x1f, 0xff, 0x11, 0xff, 0xf1, 0x00,  //...@@@..@@@...
    0x00, 0x0b, 0xff, 0x77, 0xff, 0xb0, 0x00,  //...%@@++@@%...
    0x00, 0x05, 0xff, 0xdd, 0xff, 0x50, 0x00,  //...+@@@@@@+...
    0x00, 0x00, 0xef, 0xff, 0xfe, 0x00, 0x00,  //....@@@@@@....
    0x00, 0x00, 0x9f, 0xff, 0xf9, 0x00, 0x00,  //....%@@@@%....
    0x00, 0x00, 0x2f, 0xff, 0xf2, 0x00, 0x00,  //.....@@@@.....
    0x00, 0x00, 0x0c, 0xff, 0xc0, 0x00, 0x00,  //.....@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0077 (w) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xdf, 0xf3, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x03, 0xff, 0xd0,  //@@@.....@@@.....@@@
    0x9f, 0xf8, 0x00, 0x04, 0xff, 0xf4, 0x00, 0x08, 0xff, 0x90,  //%@@+...+@@@+...+@@%
    0x5f, 0xfc, 0x00, 0x08, 0xff, 0xf8, 0x00, 0x0c, 0xff, 0x50,  //+@@@...%@@@%...@@@+
    0x1f, 0xff, 0x00, 0x0d, 0xf7, 0xfd, 0x00, 0x0f, 0xff, 0x10,  //.@@@...@@+@@...@@@.
    0x0c, 0xff, 0x40, 0x1f, 0xf0, 0xff, 0x10, 0x4f, 0xfc, 0x00,  //.@@@+..@@.@@..+@@@.
    0x08, 0xff, 0x80, 0x5f, 0xb0, 0xbf, 0x50, 0x8f, 0xf8, 0x00,  //.%@@%.+@%.%@+.%@@%.
    0x04, 0xff, 0xd0, 0xaf, 0x70, 0x7f, 0x90, 0xdf, 0xf4, 0x00,  //.+@@@.%@+.+@%.@@@+.
    0x00, 0xff, 0xf1, 0xef, 0x20, 0x2f, 0xe1, 0xff, 0xf0, 0x00,  //..@@@.@@...@@.@@@..
    0x00, 0xcf, 0xf8, 0xfe, 0x00, 0x0e, 0xf8, 0xff, 0xb0, 0x00,  //..%@@%@@...@@%@@%..
    0x00, 0x7f, 0xff, 0xfa, 0x00, 0x0a, 0xff, 0xff, 0x70, 0x00,  //..+@@@@%...%@@@@+..
    0x00, 0x3f, 0xff, 0xf6, 0x00, 0x06, 0xff, 0xff, 0x30, 0x00,  //...@@@@+...+@@@@...
    0x00, 0x0f, 0xff, 0xf1, 0x00, 0x01, 0xff, 0xff, 0x00, 0x00,  //...@@@@.....@@@@...
    0x00, 0x0b, 0xff, 0xd0, 0x00, 0x00, 0xdf, 0xfb, 0x00, 0x00,  //...%@@@.....@@@%...
    0x00, 0x06, 0xff, 0x90, 0x00, 0x00, 0x9f, 0xf6, 0x00, 0x00,  //...+@@%.....%@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0078 (x) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x9f, 0xff, 0x40, 0x00, 0x04, 0xff, 0xf9,  //%@@@+....+@@@%
    0x0c, 0xff, 0xe2, 0x00, 0x2e, 0xff, 0xc0,  //.%@@@....@@@@.
    0x01, 0xef, 0xfd, 0x00, 0xdf, 0xfe, 0x10,  //..@@@@..@@@@..
    0x00, 0x3f, 0xff, 0xba, 0xff, 0xf3, 0x00,  //...@@@%%@@@...
    0x00, 0x05, 0xff, 0xff, 0xff, 0x50, 0x00,  //...+@@@@@@+...
    0x00, 0x00, 0x8f, 0xff, 0xf8, 0x00, 0x00,  //....%@@@@%....
    0x00, 0x00, 0x0c, 0xff, 0xb0, 0x00, 0x00,  //.....@@@%.....
    0x00, 0x00, 0x3f, 0xff, 0xe1, 0x00, 0x00,  //.....@@@@.....
    0x00, 0x00, 0xdf, 0xff, 0xfc, 0x00, 0x00,  //....@@@@@%....
    0x00, 0x0a, 0xff, 0xff, 0xff, 0x80, 0x00,  //...%@@@@@@%...
    0x00, 0x6f, 0xff, 0x57, 0xff, 0xf4, 0x00,  //..+@@@++@@@+..
    0x02, 0xff, 0xf9, 0x00, 0xbf, 0xfe, 0x20,  //..@@@%..%@@@..
    0x0d, 0xff, 0xc0, 0x00, 0x1d, 0xff, 0xc0,  //.@@@@....@@@@.
    0xaf, 0xff, 0x20, 0x00, 0x03, 0xff, 0xf9,  //%@@@......@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0079 (y) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xcf, 0xf7, 0x00, 0x00, 0x00, 0x7f, 0xfc,  //@@@+......+@@@
    0x6f, 0xfd, 0x00, 0x00, 0x00, 0xef, 0xf5,  //+@@@......@@@+
    0x0e, 0xff, 0x40, 0x00, 0x05, 0xff, 0xe0,  //.@@@+....+@@@.
    0x08, 0xff, 0xa0, 0x00, 0x0c, 0xff, 0x70,  //.%@@%....@@@+.
    0x02, 0xff, 0xf1, 0x00, 0x3f, 0xff, 0x10,  //..@@@....@@@..
    0x00, 0xbf, 0xf7, 0x00, 0xaf, 0xf9, 0x00,  //..%@@+..%@@%..
    0x00, 0x5f, 0xfe, 0x01, 0xff, 0xf2, 0x00,  //..+@@@..@@@...
    0x00, 0x0e, 0xff, 0x58, 0xff, 0xc0, 0x00,  //...@@@++@@%...
    0x00, 0x08, 0xff, 0xbe, 0xff, 0x50, 0x00,  //...+@@%@@@+...
    0x00, 0x01, 0xff, 0xff, 0xfd, 0x00, 0x00,  //....@@@@@@....
    0x00, 0x00, 0xaf, 0xff, 0xf7, 0x00, 0x00,  //....%@@@@+....
    0x00, 0x00, 0x4f, 0xff, 0xf0, 0x00, 0x00,  //....+@@@@.....
    0x00, 0x00, 0x0e, 0xff, 0x90, 0x00, 0x00,  //.....@@@%.....
    0x00, 0x00, 0x1f, 0xff, 0x20, 0x00, 0x00,  //.....@@@......
    0x00, 0x00, 0x8f, 0xfb, 0x00, 0x00, 0x00,  //....%@@%......
    0x00, 0x01, 0xff, 0xf4, 0x00, 0x00, 0x00,  //....@@@+......
    0x00, 0x1b, 0xff, 0xc0, 0x00, 0x00, 0x00,  //...%@@@.......
    0x0f, 0xff, 0xff, 0x30, 0x00, 0x00, 0x00,  //.@@@@@........
    0x0f, 0xfe, 0xb3, 0x00, 0x00, 0x00, 0x00,  //.@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+007a (z) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x1e, 0xff, 0xb0,  //.......@@@%
    0x00, 0x00, 0x00, 0xbf, 0xfe, 0x10,  //......%@@@.
    0x00, 0x00, 0x07, 0xff, 0xf4, 0x00,  //.....+@@@+.
    0x00, 0x00, 0x3f, 0xff, 0x80, 0x00,  //.....@@@%..
    0x00, 0x01, 0xef, 0xfc, 0x00, 0x00,  //....@@@@...
    0x00, 0x0b, 0xff, 0xf2, 0x00, 0x00,  //...%@@@....
    0x00, 0x7f, 0xff, 0x60, 0x00, 0x00,  //..+@@@+....
    0x03, 0xff, 0xfa, 0x00, 0x00, 0x00,  //..@@@%.....
    0x1d, 0xff, 0xe0, 0x00, 0x00, 0x00,  //.@@@@......
    0xaf, 0xff, 0x30, 0x00, 0x00, 0x00,  //%@@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+007b ({) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x03, 0x9c, 0xef, 0xf0,  //......%@@@@
    0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0,  //.....@@@@@@
    0x00, 0x00, 0xbf, 0xfa, 0x20, 0x00,  //....%@@%...
    0x00, 0x00, 0xef, 0xf2, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x04, 0xff, 0xd0, 0x00, 0x00,  //....@@@....
    0x00, 0x3d, 0xff, 0x60, 0x00, 0x00,  //...@@@+....
    0xff, 0xff, 0xd6, 0x00, 0x00, 0x00,  //@@@@@+.....
    0xff, 0xff, 0xc5, 0x00, 0x00, 0x00,  //@@@@@+.....
    0x00, 0x4d, 0xff, 0x60, 0x00, 0x00,  //..+@@@+....
    0x00, 0x04, 0xff, 0xd0, 0x00, 0x00,  //...+@@@....
    0x00, 0x01, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xef, 0xf2, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xbf, 0xfa, 0x20, 0x00,  //....%@@%...
    0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0,  //.....@@@@@@
    0x00, 0x00, 0x03, 0x9c, 0xef, 0xf0,  //......%@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+007c (|) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@


    /*Unicode: U+007d (}) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xec, 0x93, 0x00, 0x00, 0x00,  //@@@@%......
    0xff, 0xff, 0xff, 0x30, 0x00, 0x00,  //@@@@@@.....
    0x00, 0x2a, 0xff, 0xb0, 0x00, 0x00,  //...%@@%....
    0x00, 0x02, 0xff, 0xe0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xdf, 0xf4, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x6f, 0xfd, 0x30, 0x00,  //....+@@@...
    0x00, 0x00, 0x06, 0xdf, 0xff, 0xf0,  //.....+@@@@@
    0x00, 0x00, 0x05, 0xcf, 0xff, 0xf0,  //.....+@@@@@
    0x00, 0x00, 0x6f, 0xfd, 0x40, 0x00,  //....+@@@+..
    0x00, 0x00, 0xdf, 0xf4, 0x00, 0x00,  //....@@@+...
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,  //....@@@....
    0x00, 0x02, 0xff, 0xe0, 0x00, 0x00,  //....@@@....
    0x00, 0x2a, 0xff, 0xb0, 0x00, 0x00,  //...%@@%....
    0xff, 0xff, 0xff, 0x30, 0x00, 0x00,  //@@@@@@.....
    0xff, 0xed, 0x93, 0x00, 0x00, 0x00,  //@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+007e (~) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x01, 0x8d, 0xfe, 0xa4, 0x00, 0x00, 0x00, 0x2d,  //..%@@@%+.......@
    0x5f, 0xff, 0xff, 0xff, 0xd7, 0x20, 0x27, 0xff,  //+@@@@@@@@+...+@@
    0xfe, 0x61, 0x02, 0x7e, 0xff, 0xff, 0xff, 0xf5,  //@@+...+@@@@@@@@+
    0xa0, 0x00, 0x00, 0x00, 0x4a, 0xef, 0xd8, 0x10,  //%.......+%@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................



#elif USE_LV_FONT_DEJAVU_30 == 8
    /*Unicode: U+0020 ( ) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0021 (!) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xfc, 0xff, 0xfc,  //@@@
    0xec, 0xff, 0xec,  //@@@
    0xda, 0xff, 0xdc,  //@@@
    0xc8, 0xff, 0xca,  //@@@
    0xb8, 0xff, 0xba,  //%@%
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0022 (") , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0023 (#) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0x5c, 0x00, 0x00, 0x00, 0xdc, 0xff, 0x2c, 0x00, 0x00,  //.......%@+...@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf4, 0xff, 0x18, 0x00, 0x00, 0x24, 0xff, 0xe8, 0x00, 0x00, 0x00,  //.......@@....@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x68, 0xff, 0xa4, 0x00, 0x00, 0x00,  //.......@@...+@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0x8c, 0x00, 0x00, 0x00, 0xae, 0xff, 0x60, 0x00, 0x00, 0x00,  //......+@%...%@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0x48, 0x00, 0x00, 0x02, 0xf0, 0xff, 0x1c, 0x00, 0x00, 0x00,  //......@@+...@@....
    0x00, 0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@@@@@@@
    0x00, 0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0x8c, 0x00, 0x00, 0x00, 0xb4, 0xff, 0x58, 0x00, 0x00, 0x00, 0x00,  //.....%@%...%@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xff, 0x46, 0x00, 0x00, 0x04, 0xf2, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00,  //.....@@+...@@.....
    0x00, 0x00, 0x00, 0x00, 0x12, 0xfc, 0xf8, 0x08, 0x00, 0x00, 0x3a, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@....@@.....
    0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xbc, 0x00, 0x00, 0x00, 0x7c, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@%...+@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00,  //@@@@@@@@@@@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00,  //@@@@@@@@@@@@@@@@%.
    0x00, 0x00, 0x00, 0x16, 0xfc, 0xf2, 0x04, 0x00, 0x00, 0x40, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@....@@......
    0x00, 0x00, 0x00, 0x5a, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x84, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@%...%@%......
    0x00, 0x00, 0x00, 0x9e, 0xff, 0x70, 0x00, 0x00, 0x00, 0xc8, 0xff, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@+...@@+......
    0x00, 0x00, 0x00, 0xe2, 0xff, 0x2c, 0x00, 0x00, 0x0e, 0xfc, 0xf4, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@....@@.......
    0x00, 0x00, 0x28, 0xff, 0xe8, 0x00, 0x00, 0x00, 0x50, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@...+@%.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0024 ($) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@......
    0x00, 0x00, 0x5c, 0xba, 0xec, 0xff, 0xf4, 0xd4, 0xb0, 0x6c, 0x22, 0x00,  //..+%@@@@%+..
    0x04, 0xb2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.%@@@@@@@@@.
    0x76, 0xff, 0xff, 0xce, 0x28, 0xff, 0x0e, 0x2c, 0x4c, 0x90, 0xda, 0x00,  //+@@@.@..+%@.
    0xd4, 0xff, 0xff, 0x36, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..@......
    0xf8, 0xff, 0xff, 0x08, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..@......
    0xf0, 0xff, 0xff, 0x46, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+.@......
    0xb6, 0xff, 0xff, 0xf6, 0x98, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@%@......
    0x34, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xd0, 0x7c, 0x14, 0x00, 0x00,  //.@@@@@@@+...
    0x00, 0x38, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x5c, 0x00,  //..@@@@@@@@+.
    0x00, 0x00, 0x00, 0x34, 0x7a, 0xff, 0xf6, 0xff, 0xff, 0xff, 0xfc, 0x44,  //....+@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x08, 0x58, 0xe4, 0xff, 0xff, 0xbe,  //.....@.+@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xf2,  //.....@...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf6,  //.....@...@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xcc,  //.....@..+@@@
    0xce, 0x76, 0x36, 0x0c, 0x00, 0xff, 0x1c, 0x6e, 0xee, 0xff, 0xff, 0x5c,  //@+...@.+@@@+
    0xff, 0xff, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x78, 0x00,  //@@@@@@@@@@+.
    0x24, 0x70, 0xb4, 0xd6, 0xf2, 0xff, 0xec, 0xc8, 0x88, 0x24, 0x00, 0x00,  //.+%@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0025 (%) , Width: 22 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x10, 0x90, 0xe2, 0xf8, 0xe0, 0x8c, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00,  //..%@@@%........%@%....
    0x0a, 0xd2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0xee, 0x16, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@......+@@.....
    0x7e, 0xff, 0xde, 0x3e, 0x0a, 0x40, 0xe2, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x08, 0xe0, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@...@@+.....@@+.....
    0xd2, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x50, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xcc, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+...+@@....%@@......
    0xf6, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf4, 0x00, 0x00, 0x00, 0x26, 0xf8, 0xfc, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.....@@....@@.......
    0xf6, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf4, 0x00, 0x00, 0x00, 0xbc, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.....@@...%@%.......
    0xd4, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xd2, 0x00, 0x00, 0x58, 0xff, 0xea, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+...+@@..+@@........
    0x80, 0xff, 0xde, 0x3e, 0x0a, 0x3e, 0xe0, 0xff, 0x7e, 0x00, 0x0c, 0xe4, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@...@@+..@@+........
    0x0c, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x0a, 0x00, 0x8e, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@@@..%@@.........
    0x00, 0x12, 0x92, 0xe2, 0xf8, 0xe0, 0x90, 0x0e, 0x00, 0x2c, 0xfa, 0xfc, 0x30, 0x00, 0x0e, 0x8e, 0xe0, 0xf8, 0xe2, 0x8e, 0x0e, 0x00,  //..%@@@%...@@...%@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0x92, 0x00, 0x0a, 0xd2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x08,  //.........@@%..@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xe8, 0x0e, 0x00, 0x7e, 0xff, 0xe0, 0x40, 0x0a, 0x3e, 0xe0, 0xff, 0x7c,  //........+@@..+@@...@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe8, 0xff, 0x5c, 0x00, 0x00, 0xd2, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xd0,  //........@@+..@@+...+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xc0, 0x00, 0x00, 0x00, 0xf6, 0xff, 0x10, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf4,  //.......%@%...@@.....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xfc, 0xfa, 0x2a, 0x00, 0x00, 0x00, 0xf6, 0xff, 0x10, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf4,  //.......@@....@@.....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0xd4, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xd2,  //......@@%....@@+...+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xe4, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xe0, 0x40, 0x0a, 0x3e, 0xe0, 0xff, 0x7e,  //.....+@@.....+@@...@@+
    0x00, 0x00, 0x00, 0x00, 0x14, 0xec, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x0a,  //.....@@+......@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x90, 0xe2, 0xfa, 0xe2, 0x90, 0x0e, 0x00,  //....%@%........%@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......................


    /*Unicode: U+0026 (&) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x08, 0x7e, 0xd2, 0xf6, 0xf6, 0xd4, 0x92, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@@@@%........
    0x00, 0x00, 0x0e, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@@@@@@.......
    0x00, 0x00, 0x8e, 0xff, 0xff, 0xd8, 0x3e, 0x08, 0x1a, 0x64, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@...+@.......
    0x00, 0x00, 0xe2, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.............
    0x00, 0x08, 0xfc, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.............
    0x00, 0x30, 0xff, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.............
    0x00, 0x12, 0xfa, 0xff, 0xff, 0xca, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@............
    0x00, 0x00, 0xb0, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@%...........
    0x00, 0x12, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@%..........
    0x00, 0x9c, 0xff, 0xc4, 0xa0, 0xff, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xe2, 0x00,  //.%@@%@@@+.....@@@.
    0x36, 0xff, 0xf8, 0x30, 0x00, 0xa2, 0xff, 0xff, 0xfc, 0x52, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xa4, 0x00,  //.@@..%@@@+....@@%.
    0xb0, 0xff, 0xa2, 0x00, 0x00, 0x02, 0xa4, 0xff, 0xff, 0xf6, 0x3e, 0x00, 0x00, 0x6e, 0xff, 0xff, 0x3e, 0x00,  //%@%...%@@@...+@@..
    0xe8, 0xff, 0xca, 0x00, 0x00, 0x00, 0x02, 0xa6, 0xff, 0xff, 0xee, 0x2c, 0x00, 0xd4, 0xff, 0xbc, 0x00, 0x00,  //@@@....%@@@..@@%..
    0xf4, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x02, 0xa8, 0xff, 0xff, 0xe4, 0x96, 0xff, 0xf2, 0x24, 0x00, 0x00,  //@@@.....%@@@%@@...
    0xce, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaa, 0xff, 0xff, 0xff, 0xfc, 0x4c, 0x00, 0x00, 0x00,  //@@@+.....%@@@@+...
    0x76, 0xff, 0xff, 0xd6, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x16, 0xf0, 0xff, 0xff, 0xec, 0x2e, 0x00, 0x00, 0x00,  //+@@@......@@@@....
    0x08, 0xd2, 0xff, 0xff, 0xd8, 0x52, 0x0e, 0x10, 0x5c, 0xde, 0xff, 0xf6, 0xff, 0xff, 0xf0, 0x40, 0x00, 0x00,  //.@@@@+..+@@@@@@...
    0x00, 0x18, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x1a, 0xa8, 0xff, 0xff, 0xf8, 0x56, 0x00,  //..@@@@@@@@@.%@@@+.
    0x00, 0x00, 0x02, 0x5a, 0xb6, 0xe8, 0xfa, 0xea, 0xba, 0x5e, 0x00, 0x00, 0x02, 0xae, 0xff, 0xff, 0xfc, 0x70,  //...+%@@@%+...%@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0027 (') , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+0028 (() , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x2a, 0xf8, 0xc4,  //....@@
    0x00, 0x00, 0x00, 0xca, 0xff, 0x4e,  //...@@+
    0x00, 0x00, 0x64, 0xff, 0xd8, 0x00,  //..+@@.
    0x00, 0x06, 0xe4, 0xff, 0x78, 0x00,  //..@@+.
    0x00, 0x68, 0xff, 0xff, 0x24, 0x00,  //.+@@..
    0x00, 0xd2, 0xff, 0xd0, 0x00, 0x00,  //.@@@..
    0x2e, 0xff, 0xff, 0x94, 0x00, 0x00,  //.@@%..
    0x78, 0xff, 0xff, 0x64, 0x00, 0x00,  //+@@+..
    0xb2, 0xff, 0xff, 0x34, 0x00, 0x00,  //%@@...
    0xda, 0xff, 0xff, 0x1e, 0x00, 0x00,  //@@@...
    0xf2, 0xff, 0xff, 0x0e, 0x00, 0x00,  //@@@...
    0xfc, 0xff, 0xff, 0x02, 0x00, 0x00,  //@@@...
    0xf2, 0xff, 0xff, 0x0e, 0x00, 0x00,  //@@@...
    0xda, 0xff, 0xff, 0x1e, 0x00, 0x00,  //@@@...
    0xb0, 0xff, 0xff, 0x34, 0x00, 0x00,  //%@@...
    0x76, 0xff, 0xff, 0x62, 0x00, 0x00,  //+@@+..
    0x2a, 0xff, 0xff, 0x94, 0x00, 0x00,  //.@@%..
    0x00, 0xd0, 0xff, 0xce, 0x00, 0x00,  //.@@@..
    0x00, 0x66, 0xff, 0xff, 0x22, 0x00,  //.+@@..
    0x00, 0x06, 0xe4, 0xff, 0x76, 0x00,  //..@@+.
    0x00, 0x00, 0x62, 0xff, 0xd6, 0x00,  //..+@@.
    0x00, 0x00, 0x00, 0xc8, 0xff, 0x4e,  //...@@+
    0x00, 0x00, 0x00, 0x2a, 0xf8, 0xc4,  //....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0029 ()) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0xc4, 0xf8, 0x2a, 0x00, 0x00, 0x00,  //@@....
    0x50, 0xff, 0xc8, 0x00, 0x00, 0x00,  //+@@...
    0x00, 0xd8, 0xff, 0x60, 0x00, 0x00,  //.@@+..
    0x00, 0x7a, 0xff, 0xe2, 0x06, 0x00,  //.+@@..
    0x00, 0x26, 0xff, 0xff, 0x64, 0x00,  //..@@+.
    0x00, 0x00, 0xd4, 0xff, 0xce, 0x00,  //..@@@.
    0x00, 0x00, 0x98, 0xff, 0xff, 0x2a,  //..%@@.
    0x00, 0x00, 0x66, 0xff, 0xff, 0x74,  //..+@@+
    0x00, 0x00, 0x36, 0xff, 0xff, 0xb0,  //...@@%
    0x00, 0x00, 0x20, 0xff, 0xff, 0xd8,  //...@@@
    0x00, 0x00, 0x10, 0xff, 0xff, 0xf2,  //...@@@
    0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //...@@@
    0x00, 0x00, 0x10, 0xff, 0xff, 0xf2,  //...@@@
    0x00, 0x00, 0x20, 0xff, 0xff, 0xd8,  //...@@@
    0x00, 0x00, 0x36, 0xff, 0xff, 0xae,  //...@@%
    0x00, 0x00, 0x66, 0xff, 0xff, 0x74,  //..+@@+
    0x00, 0x00, 0x98, 0xff, 0xff, 0x2a,  //..%@@.
    0x00, 0x00, 0xd4, 0xff, 0xd0, 0x00,  //..@@@.
    0x00, 0x26, 0xff, 0xff, 0x64, 0x00,  //..@@+.
    0x00, 0x78, 0xff, 0xe2, 0x06, 0x00,  //.+@@..
    0x00, 0xd6, 0xff, 0x60, 0x00, 0x00,  //.@@+..
    0x4e, 0xff, 0xc8, 0x00, 0x00, 0x00,  //+@@...
    0xc4, 0xf8, 0x2a, 0x00, 0x00, 0x00,  //@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+002a (*) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@.....
    0x82, 0x7e, 0x04, 0x00, 0x00, 0xff, 0x00, 0x00, 0x04, 0x7e, 0x82,  //%+...@...+%
    0x98, 0xfc, 0xd2, 0x36, 0x00, 0xff, 0x00, 0x36, 0xd2, 0xfc, 0x98,  //%@@..@..@@%
    0x00, 0x38, 0xca, 0xfc, 0x8c, 0xff, 0x8e, 0xfc, 0xc8, 0x36, 0x00,  //..@@%@%@@..
    0x00, 0x00, 0x00, 0x60, 0xe6, 0xff, 0xe6, 0x60, 0x00, 0x00, 0x00,  //...+@@@+...
    0x00, 0x00, 0x00, 0x60, 0xe6, 0xff, 0xe6, 0x60, 0x00, 0x00, 0x00,  //...+@@@+...
    0x00, 0x36, 0xc8, 0xfc, 0x8e, 0xff, 0x8e, 0xfc, 0xc8, 0x36, 0x00,  //..@@%@%@@..
    0x98, 0xfc, 0xd2, 0x36, 0x00, 0xff, 0x00, 0x36, 0xd4, 0xfc, 0x98,  //%@@..@..@@%
    0x82, 0x80, 0x04, 0x00, 0x00, 0xff, 0x00, 0x00, 0x04, 0x80, 0x82,  //%+...@...+%
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+002b (+) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+002c (,) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x1a, 0xff, 0xff, 0xc8,  //.@@@
    0x5a, 0xff, 0xff, 0x46,  //+@@+
    0x9c, 0xff, 0xc2, 0x00,  //%@@.
    0xde, 0xff, 0x40, 0x00,  //@@..
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+002d (-) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+002e (.) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+002f (/) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xd4,  //......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0x80,  //......%@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe8, 0xff, 0x2c,  //......@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xff, 0xd8, 0x00,  //......@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0x84, 0x00,  //.....%@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0xff, 0x30, 0x00,  //.....@@..
    0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xdc, 0x00, 0x00,  //.....@@..
    0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0x88, 0x00, 0x00,  //....%@%..
    0x00, 0x00, 0x00, 0x00, 0xe2, 0xff, 0x34, 0x00, 0x00,  //....@@...
    0x00, 0x00, 0x00, 0x38, 0xff, 0xe0, 0x00, 0x00, 0x00,  //....@@...
    0x00, 0x00, 0x00, 0x8c, 0xff, 0x8c, 0x00, 0x00, 0x00,  //...%@%...
    0x00, 0x00, 0x00, 0xe0, 0xff, 0x38, 0x00, 0x00, 0x00,  //...@@....
    0x00, 0x00, 0x34, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00,  //...@@....
    0x00, 0x00, 0x88, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00,  //..%@%....
    0x00, 0x00, 0xdc, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00,  //..@@.....
    0x00, 0x30, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@.....
    0x00, 0x84, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@%.....
    0x00, 0xd8, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@......
    0x2c, 0xff, 0xe8, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@......
    0x80, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@%......
    0xd4, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0030 (0) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x3a, 0xa8, 0xe4, 0xf8, 0xe4, 0xa8, 0x3a, 0x00, 0x00, 0x00,  //....%@@@%....
    0x00, 0x00, 0x78, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x78, 0x00, 0x00,  //..+@@@@@@@+..
    0x00, 0x54, 0xff, 0xff, 0xd4, 0x38, 0x08, 0x38, 0xd4, 0xff, 0xff, 0x52, 0x00,  //.+@@@...@@@+.
    0x04, 0xde, 0xff, 0xf6, 0x20, 0x00, 0x00, 0x00, 0x20, 0xf6, 0xff, 0xde, 0x04,  //.@@@.....@@@.
    0x48, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0x48,  //+@@%.....%@@+
    0x94, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0x92,  //%@@+.....+@@%
    0xc2, 0xff, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xc0,  //@@@.......@@%
    0xe4, 0xff, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xe4,  //@@@.......@@@
    0xf4, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf2,  //@@@.......@@@
    0xfc, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xfa,  //@@@.......@@@
    0xf4, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf2,  //@@@.......@@@
    0xe4, 0xff, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0xe4,  //@@@.......@@@
    0xc2, 0xff, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xff, 0xff, 0xc0,  //@@@.......@@%
    0x94, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0x92,  //%@@+.....+@@%
    0x48, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0x48,  //+@@%.....%@@+
    0x04, 0xde, 0xff, 0xf6, 0x20, 0x00, 0x00, 0x00, 0x20, 0xf6, 0xff, 0xde, 0x04,  //.@@@.....@@@.
    0x00, 0x54, 0xff, 0xff, 0xd4, 0x38, 0x08, 0x38, 0xd4, 0xff, 0xff, 0x52, 0x00,  //.+@@@...@@@+.
    0x00, 0x00, 0x7a, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x78, 0x00, 0x00,  //..+@@@@@@@+..
    0x00, 0x00, 0x00, 0x3a, 0xaa, 0xe4, 0xf8, 0xe4, 0xaa, 0x3a, 0x00, 0x00, 0x00,  //....%@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0031 (1) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x18, 0x4a, 0x7c, 0xae, 0xe0, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.++%@@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@....
    0xe4, 0xb2, 0x7e, 0x4c, 0x18, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@%++.@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //.....@@@....
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0032 (2) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x22, 0x6a, 0xa4, 0xd2, 0xf0, 0xfa, 0xec, 0xc2, 0x78, 0x12, 0x00, 0x00, 0x00,  //.+%@@@@@+....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x44, 0x00, 0x00,  //@@@@@@@@@@+..
    0xff, 0xf8, 0xa0, 0x48, 0x12, 0x0a, 0x32, 0xaa, 0xff, 0xff, 0xf6, 0x28, 0x00,  //@@%+...%@@@..
    0xb0, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xa6, 0x00,  //%.......%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xe6, 0x00,  //.........@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf8, 0x00,  //.........@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xde, 0x00,  //.........@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0x9a, 0x00,  //........%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xfc, 0xff, 0xfc, 0x2a, 0x00,  //........@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xe6, 0xff, 0xff, 0x8e, 0x00, 0x00,  //.......@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xd0, 0xff, 0xff, 0xcc, 0x08, 0x00, 0x00,  //......@@@@...
    0x00, 0x00, 0x00, 0x00, 0x08, 0xc4, 0xff, 0xff, 0xe4, 0x1a, 0x00, 0x00, 0x00,  //.....@@@@....
    0x00, 0x00, 0x00, 0x06, 0xb8, 0xff, 0xff, 0xf4, 0x32, 0x00, 0x00, 0x00, 0x00,  //....%@@@.....
    0x00, 0x00, 0x02, 0xae, 0xff, 0xff, 0xfa, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@+.....
    0x00, 0x00, 0xa2, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@@+......
    0x00, 0x96, 0xff, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@+.......
    0x86, 0xff, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@%........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1a,  //@@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1a,  //@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0033 (3) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x2c, 0x80, 0xc0, 0xec, 0xfa, 0xea, 0xb8, 0x54, 0x00, 0x00, 0x00,  //..+%@@@%+...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0x00, 0x00,  //.@@@@@@@@%..
    0x00, 0xc8, 0x6a, 0x26, 0x04, 0x1a, 0x68, 0xf0, 0xff, 0xff, 0x6c, 0x00,  //.@+...+@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xd0, 0x00,  //.......+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xff, 0xf6, 0x00,  //........@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xff, 0xe0, 0x00,  //........@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0x96, 0x00,  //.......+@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x5c, 0xea, 0xff, 0xd0, 0x12, 0x00,  //......+@@@..
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xda, 0x78, 0x08, 0x00, 0x00,  //...@@@@@+...
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xb6, 0x50, 0x00, 0x00,  //...@@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x40, 0xb6, 0xff, 0xff, 0xa8, 0x04,  //.......%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0xff, 0xff, 0x80,  //........%@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xe0,  //.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf8,  //.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xe0,  //.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa2, 0xff, 0xff, 0x9c,  //........%@@%
    0xc6, 0x6a, 0x2e, 0x0c, 0x02, 0x0e, 0x42, 0xb2, 0xff, 0xff, 0xf2, 0x20,  //@+....+%@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x3a, 0x00,  //@@@@@@@@@@..
    0x2a, 0x7c, 0xbc, 0xe4, 0xfa, 0xf6, 0xe2, 0xb4, 0x68, 0x0a, 0x00, 0x00,  //.+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0034 (4) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.......%@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xfa, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.......@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd4, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //......@@@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0x9c, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....%@%@@@...
    0x00, 0x00, 0x00, 0x00, 0x38, 0xfc, 0xe4, 0x0e, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.....@@.@@@...
    0x00, 0x00, 0x00, 0x08, 0xd8, 0xff, 0x4e, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //....@@+.@@@...
    0x00, 0x00, 0x00, 0x8e, 0xff, 0xa6, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...%@%..@@@...
    0x00, 0x00, 0x3c, 0xfc, 0xe8, 0x12, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...@@@...
    0x00, 0x0a, 0xdc, 0xff, 0x56, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@+...@@@...
    0x00, 0x94, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.%@%....@@@...
    0x40, 0xfc, 0xec, 0x16, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@.....@@@...
    0xde, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@+.....@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //........@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0035 (5) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@@.
    0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@........
    0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@........
    0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@........
    0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@........
    0x00, 0xff, 0xff, 0xff, 0xc6, 0xf2, 0xf2, 0xd0, 0x82, 0x10, 0x00, 0x00,  //.@@@@@@@%...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x2c, 0x00,  //.@@@@@@@@@..
    0x00, 0xc2, 0x5e, 0x1e, 0x04, 0x12, 0x56, 0xdc, 0xff, 0xff, 0xdc, 0x0a,  //.@+...+@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xde, 0xff, 0xff, 0x70,  //........@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xc0,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xec,  //.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xf8,  //.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xff, 0xea,  //.........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xba,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xe0, 0xff, 0xff, 0x60,  //........@@@+
    0xca, 0x70, 0x32, 0x0e, 0x02, 0x14, 0x5c, 0xde, 0xff, 0xff, 0xc6, 0x02,  //@+....+@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x12, 0x00,  //@@@@@@@@@%..
    0x2a, 0x7c, 0xbc, 0xe4, 0xfa, 0xf4, 0xdc, 0xa8, 0x4c, 0x00, 0x00, 0x00,  //.+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0036 (6) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x3a, 0x9a, 0xd8, 0xf2, 0xf4, 0xd2, 0x90, 0x32, 0x00,  //.....%@@@@%..
    0x00, 0x00, 0x06, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //...%@@@@@@@@.
    0x00, 0x02, 0xb6, 0xff, 0xff, 0xcc, 0x4c, 0x10, 0x04, 0x22, 0x6a, 0xcc, 0x00,  //..%@@@+...+@.
    0x00, 0x76, 0xff, 0xff, 0xbc, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@%........
    0x0c, 0xf2, 0xff, 0xf6, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.........
    0x66, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%.........
    0xa8, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.........
    0xda, 0xff, 0xff, 0x2c, 0x38, 0xb0, 0xea, 0xf6, 0xda, 0x96, 0x22, 0x00, 0x00,  //@@@..%@@@%...
    0xee, 0xff, 0xff, 0x70, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x4a, 0x00,  //@@@+@@@@@@@+.
    0xfa, 0xff, 0xff, 0xf8, 0x9c, 0x24, 0x04, 0x24, 0x9e, 0xff, 0xff, 0xf2, 0x1e,  //@@@@%...%@@@.
    0xf2, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0x90,  //@@@%.....%@@%
    0xe4, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0xd6,  //@@@.......@@@
    0xc0, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xf4,  //%@@.......@@@
    0x90, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xf4,  //%@@.......@@@
    0x44, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0xd0,  //+@@.......@@@
    0x02, 0xd8, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0x82,  //.@@%.....%@@%
    0x00, 0x48, 0xfc, 0xff, 0x9c, 0x22, 0x04, 0x24, 0x9e, 0xff, 0xff, 0xe4, 0x10,  //.+@@%...%@@@.
    0x00, 0x00, 0x68, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x2e, 0x00,  //..+@@@@@@@@..
    0x00, 0x00, 0x00, 0x2e, 0x9c, 0xde, 0xf6, 0xf0, 0xc8, 0x78, 0x0e, 0x00, 0x00,  //....%@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0037 (7) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0x88,  //........%@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xec, 0xff, 0xff, 0x36,  //........@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xe0, 0x00,  //.......+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x8e, 0x00,  //.......%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe8, 0xff, 0xff, 0x3c, 0x00,  //.......@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xe6, 0x00, 0x00,  //.......@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0x94, 0x00, 0x00,  //......%@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xff, 0xff, 0x42, 0x00, 0x00,  //......@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xea, 0x02, 0x00, 0x00,  //......@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00,  //.....%@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00,  //.....@@@+...
    0x00, 0x00, 0x00, 0x00, 0x34, 0xff, 0xff, 0xee, 0x04, 0x00, 0x00, 0x00,  //.....@@@....
    0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00,  //....%@@%....
    0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00,  //....@@@+....
    0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xf2, 0x06, 0x00, 0x00, 0x00, 0x00,  //....@@@.....
    0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@%.....
    0x00, 0x00, 0x00, 0xd4, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0038 (8) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x2a, 0x90, 0xce, 0xee, 0xfa, 0xee, 0xce, 0x90, 0x2a, 0x00, 0x00,  //...%@@@@@%...
    0x00, 0x7c, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x7c, 0x00,  //.+@@@@@@@@@+.
    0x5c, 0xff, 0xff, 0xf4, 0x7a, 0x20, 0x08, 0x22, 0x7c, 0xf6, 0xff, 0xff, 0x5a,  //+@@@+...+@@@+
    0xcc, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xcc,  //@@@+.....+@@@
    0xf6, 0xff, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xff, 0xf6,  //@@@.......@@@
    0xea, 0xff, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xff, 0xe8,  //@@@.......@@@
    0x96, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0x94,  //%@@+.....+@@%
    0x0e, 0xc2, 0xff, 0xf4, 0x76, 0x20, 0x06, 0x20, 0x7a, 0xf6, 0xff, 0xc0, 0x0c,  //.@@@+...+@@%.
    0x00, 0x02, 0x68, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x68, 0x02, 0x00,  //..+@@@@@@@+..
    0x00, 0x06, 0x84, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x82, 0x06, 0x00,  //..%@@@@@@@%..
    0x0c, 0xc8, 0xff, 0xfc, 0x92, 0x28, 0x08, 0x28, 0x92, 0xfc, 0xff, 0xc6, 0x0a,  //.@@@%...%@@@.
    0x8c, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0x8a,  //%@@%.....%@@%
    0xe0, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xff, 0xff, 0xe0,  //@@@.......@@@
    0xfa, 0xff, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf8,  //@@@.......@@@
    0xe8, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xff, 0xff, 0xe6,  //@@@.......@@@
    0xac, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0xac,  //%@@%.....%@@%
    0x38, 0xfc, 0xff, 0xfc, 0x8e, 0x26, 0x08, 0x28, 0x92, 0xfc, 0xff, 0xfc, 0x36,  //.@@@%...%@@@.
    0x00, 0x60, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x5c, 0x00,  //.+@@@@@@@@@+.
    0x00, 0x00, 0x22, 0x8a, 0xcc, 0xf0, 0xfa, 0xf0, 0xcc, 0x8a, 0x22, 0x00, 0x00,  //...%@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0039 (9) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x0c, 0x76, 0xc6, 0xee, 0xf6, 0xde, 0x9c, 0x2c, 0x00, 0x00, 0x00,  //...+@@@@%....
    0x00, 0x2c, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x64, 0x00, 0x00,  //..@@@@@@@@+..
    0x10, 0xe2, 0xff, 0xff, 0x9c, 0x24, 0x04, 0x24, 0x9e, 0xff, 0xfc, 0x44, 0x00,  //.@@@%...%@@+.
    0x82, 0xff, 0xff, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xd6, 0x02,  //%@@%.....%@@.
    0xd2, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0x40,  //@@@.......@@.
    0xf4, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0x8e,  //@@@.......@@%
    0xf6, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xbe,  //@@@.......@@%
    0xd8, 0xff, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0xe2,  //@@@.......@@@
    0x94, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0xf0,  //%@@%.....%@@@
    0x22, 0xf4, 0xff, 0xff, 0x9a, 0x22, 0x04, 0x22, 0x9c, 0xf8, 0xff, 0xff, 0xfa,  //.@@@%...%@@@@
    0x00, 0x50, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x70, 0xff, 0xff, 0xec,  //.+@@@@@@@+@@@
    0x00, 0x00, 0x24, 0x98, 0xdc, 0xf6, 0xec, 0xb0, 0x38, 0x2c, 0xff, 0xff, 0xd8,  //...%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xa6,  //.........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xff, 0x66,  //.........%@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf6, 0xff, 0xf0, 0x0c,  //.........@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xb8, 0xff, 0xff, 0x74, 0x00,  //........%@@+.
    0x00, 0xcc, 0x66, 0x20, 0x04, 0x10, 0x4c, 0xca, 0xff, 0xff, 0xb6, 0x02, 0x00,  //.@+...+@@@%..
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x06, 0x00, 0x00,  //.@@@@@@@@%...
    0x00, 0x34, 0x90, 0xd2, 0xf4, 0xf4, 0xda, 0x9c, 0x3c, 0x00, 0x00, 0x00, 0x00,  //..%@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+003a (:) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+003b (;) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x1a, 0xff, 0xff, 0xc8,  //.@@@
    0x5a, 0xff, 0xff, 0x46,  //+@@+
    0x9c, 0xff, 0xc2, 0x00,  //%@@.
    0xde, 0xff, 0x40, 0x00,  //@@..
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+003c (<) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x70, 0xce,  //..............+@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x52, 0xb2, 0xfa, 0xff, 0xff,  //...........+%@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x94, 0xec, 0xff, 0xff, 0xf8, 0xae, 0x4e,  //.........%@@@@%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x78, 0xd6, 0xff, 0xff, 0xff, 0xca, 0x6c, 0x12, 0x00, 0x00,  //......+@@@@@+...
    0x00, 0x00, 0x08, 0x5a, 0xba, 0xfc, 0xff, 0xff, 0xe4, 0x8a, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+%@@@@%......
    0x3e, 0x9c, 0xf0, 0xff, 0xff, 0xf6, 0xa6, 0x48, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@%+........
    0xff, 0xff, 0xff, 0xc4, 0x66, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@+...........
    0xff, 0xff, 0xff, 0xc4, 0x64, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@+...........
    0x3e, 0x9e, 0xf2, 0xff, 0xff, 0xf6, 0xa6, 0x46, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@@@%+........
    0x00, 0x00, 0x08, 0x5c, 0xba, 0xfc, 0xff, 0xff, 0xe4, 0x88, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+%@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x78, 0xd6, 0xff, 0xff, 0xff, 0xca, 0x6a, 0x12, 0x00, 0x00,  //......+@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x96, 0xec, 0xff, 0xff, 0xf8, 0xac, 0x4e,  //.........%@@@@%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x54, 0xb2, 0xfa, 0xff, 0xff,  //...........+%@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x70, 0xd0,  //..............+@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+003d (=) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+003e (>) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xce, 0x6e, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+..............
    0xff, 0xff, 0xfa, 0xb0, 0x52, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%+...........
    0x4e, 0xae, 0xf8, 0xff, 0xff, 0xec, 0x94, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+%@@@@%.........
    0x00, 0x00, 0x12, 0x6c, 0xca, 0xff, 0xff, 0xff, 0xd6, 0x76, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x88, 0xe4, 0xff, 0xff, 0xfc, 0xb8, 0x5a, 0x08, 0x00, 0x00,  //......%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x48, 0xa6, 0xf6, 0xff, 0xff, 0xf0, 0x9c, 0x3e,  //........+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x64, 0xc4, 0xff, 0xff, 0xff,  //...........+@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x64, 0xc2, 0xff, 0xff, 0xff,  //...........+@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x46, 0xa6, 0xf6, 0xff, 0xff, 0xf0, 0x9c, 0x3e,  //........+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x88, 0xe4, 0xff, 0xff, 0xfc, 0xba, 0x5a, 0x08, 0x00, 0x00,  //......%@@@@%+...
    0x00, 0x00, 0x12, 0x6a, 0xca, 0xff, 0xff, 0xff, 0xd6, 0x78, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@@@@@+......
    0x4e, 0xac, 0xf8, 0xff, 0xff, 0xec, 0x94, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+%@@@@%.........
    0xff, 0xff, 0xfa, 0xb2, 0x52, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%+...........
    0xce, 0x70, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+003f (?) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x16, 0x84, 0xd2, 0xf4, 0xf2, 0xcc, 0x72, 0x04, 0x00,  //..%@@@@+..
    0x5e, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x0a,  //+@@@@@@@@.
    0xff, 0xde, 0x64, 0x18, 0x0c, 0x4e, 0xe4, 0xff, 0xff, 0x88,  //@@+..+@@@%
    0x9c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xff, 0xde,  //%.....+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff, 0xf6,  //.......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xff, 0xcc,  //.......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0x50,  //......+@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xe8, 0xff, 0x76, 0x00,  //......@@+.
    0x00, 0x00, 0x00, 0x00, 0x26, 0xdc, 0xff, 0x6e, 0x00, 0x00,  //.....@@+..
    0x00, 0x00, 0x00, 0x24, 0xec, 0xff, 0xa0, 0x00, 0x00, 0x00,  //....@@%...
    0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0x2e, 0x00, 0x00, 0x00,  //...%@@....
    0x00, 0x00, 0x00, 0xee, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0040 (@) , Width: 23 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x7a, 0xbe, 0xdc, 0xf4, 0xf6, 0xe2, 0xb8, 0x76, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........+%@@@@%+.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xa0, 0x14, 0x00, 0x00, 0x00, 0x00,  //......%@@@@@@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x80, 0xfc, 0xff, 0xe8, 0x90, 0x4a, 0x1a, 0x06, 0x0c, 0x24, 0x52, 0xa4, 0xf4, 0xff, 0xee, 0x50, 0x00, 0x00, 0x00,  //....+@@@%+....+%@@@+...
    0x00, 0x00, 0x00, 0xaa, 0xff, 0xfa, 0x80, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xa4, 0xff, 0xfa, 0x52, 0x00, 0x00,  //...%@@+..........%@@+..
    0x00, 0x00, 0x8e, 0xff, 0xee, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xfa, 0x36, 0x00,  //..%@@+............+@@..
    0x00, 0x44, 0xff, 0xfa, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xd4, 0x00,  //.+@@...............+@@.
    0x00, 0xce, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x58, 0xc6, 0xf4, 0xee, 0xbe, 0x4c, 0x00, 0xff, 0xff, 0x00, 0x00, 0x02, 0xd2, 0xff, 0x52,  //.@@+....+@@@%+.@@...@@+
    0x40, 0xff, 0xdc, 0x02, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a, 0xff, 0xff, 0x00, 0x00, 0x00, 0x66, 0xff, 0xa6,  //.@@....%@@@@@@+@@...+@%
    0x8e, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x44, 0xff, 0xfc, 0x94, 0x28, 0x08, 0x2a, 0x9a, 0xfc, 0xff, 0xff, 0x00, 0x00, 0x00, 0x22, 0xff, 0xde,  //%@+...+@@%...%@@@....@@
    0xcc, 0xff, 0x36, 0x00, 0x00, 0x00, 0xb2, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0x00, 0x00, 0x00, 0x06, 0xff, 0xf6,  //@@....%@%.....%@@....@@
    0xe6, 0xff, 0x0e, 0x00, 0x00, 0x00, 0xe8, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xff, 0xff, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xf0,  //@@....@@.......@@....@@
    0xf8, 0xff, 0x02, 0x00, 0x00, 0x00, 0xfa, 0xff, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0x00, 0x00, 0x00, 0x32, 0xff, 0xd0,  //@@....@@.......@@....@@
    0xe8, 0xff, 0x16, 0x00, 0x00, 0x00, 0xea, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xff, 0xff, 0x00, 0x00, 0x00, 0x8c, 0xff, 0x88,  //@@....@@.......@@...%@%
    0xce, 0xff, 0x36, 0x00, 0x00, 0x00, 0xb2, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0x00, 0x00, 0x38, 0xf8, 0xf4, 0x1a,  //@@....%@%.....%@@...@@.
    0x96, 0xff, 0x80, 0x00, 0x00, 0x00, 0x48, 0xff, 0xfc, 0x92, 0x28, 0x08, 0x26, 0x92, 0xfc, 0xff, 0xff, 0x1c, 0x78, 0xf4, 0xfc, 0x5a, 0x00,  //%@+...+@@%...%@@@.+@@+.
    0x4a, 0xff, 0xda, 0x02, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x78, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x4c, 0x00, 0x00,  //+@@....%@@@@@@+@@@@@+..
    0x04, 0xdc, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xc8, 0xf4, 0xf0, 0xc0, 0x4c, 0x00, 0xf4, 0xdc, 0xac, 0x62, 0x08, 0x00, 0x00, 0x00,  //.@@+....+@@@%+.@@%+....
    0x00, 0x56, 0xff, 0xf2, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@...................
    0x00, 0x00, 0xa4, 0xff, 0xe4, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@..................
    0x00, 0x00, 0x06, 0xbe, 0xff, 0xf6, 0x70, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xbc, 0x7a, 0x00, 0x00, 0x00, 0x00,  //...%@@+..........%+....
    0x00, 0x00, 0x00, 0x06, 0x9a, 0xff, 0xff, 0xe2, 0x88, 0x40, 0x1a, 0x04, 0x0e, 0x2a, 0x64, 0xb8, 0xfc, 0xf8, 0x6c, 0x00, 0x00, 0x00, 0x00,  //....%@@@%.....+%@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xd2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@@@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x8c, 0xca, 0xe4, 0xf8, 0xea, 0xcc, 0x8a, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......+%@@@@@%........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......................


    /*Unicode: U+0041 (A) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xff, 0xfc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xff, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x06, 0xee, 0xff, 0xff, 0x72, 0xff, 0xff, 0xee, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xd8, 0x00, 0xd8, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00,  //....+@@@.@@@+....
    0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0x7a, 0x00, 0x7a, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00,  //....%@@+.+@@%....
    0x00, 0x00, 0x00, 0x18, 0xfa, 0xff, 0xfc, 0x1c, 0x00, 0x1e, 0xfc, 0xff, 0xfa, 0x18, 0x00, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00,  //...+@@%...%@@+...
    0x00, 0x00, 0x00, 0xd4, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00,  //...@@@+...+@@@...
    0x00, 0x00, 0x34, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0x32, 0x00, 0x00,  //...@@@.....@@@...
    0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00,  //..%@@@@@@@@@@@%..
    0x00, 0x04, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x04, 0x00,  //..@@@@@@@@@@@@@..
    0x00, 0x52, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0xff, 0xff, 0x50, 0x00,  //.+@@@.......@@@+.
    0x00, 0xb0, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xb0, 0x00,  //.%@@+.......+@@%.
    0x14, 0xfa, 0xff, 0xfc, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xf8, 0x14,  //.@@@.........@@@.
    0x70, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0x6e,  //+@@%.........@@@+
    0xce, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xce,  //@@@+.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0042 (B) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xe6, 0xb4, 0x54, 0x00, 0x00, 0x00,  //@@@@@@@@%+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xae, 0x04, 0x00,  //@@@@@@@@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10, 0x4e, 0xe2, 0xff, 0xff, 0x76, 0x00,  //@@@....+@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0xff, 0xd4, 0x00,  //@@@.....+@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xf6, 0x00,  //@@@......@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xe4, 0x00,  //@@@......@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff, 0xaa, 0x00,  //@@@.....+@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x0e, 0x4c, 0xe2, 0xff, 0xea, 0x26, 0x00,  //@@@....+@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x92, 0x1c, 0x00, 0x00,  //@@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x62, 0x00, 0x00,  //@@@@@@@@@@+..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x06, 0x28, 0x88, 0xfa, 0xff, 0xa8, 0x02,  //@@@.....%@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0x72,  //@@@......%@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xd4,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf8,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xec,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0xff, 0xff, 0xb6,  //@@@......%@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x06, 0x28, 0x86, 0xfa, 0xff, 0xff, 0x40,  //@@@.....%@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x66, 0x00,  //@@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xee, 0xca, 0x8a, 0x22, 0x00, 0x00,  //@@@@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0043 (C) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x08, 0x66, 0xac, 0xde, 0xf2, 0xf6, 0xe0, 0xaa, 0x5e, 0x06, 0x00,  //.....+%@@@@%+..
    0x00, 0x00, 0x00, 0x58, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x52,  //...+@@@@@@@@@@+
    0x00, 0x00, 0x7a, 0xff, 0xff, 0xf8, 0x94, 0x3c, 0x12, 0x06, 0x22, 0x68, 0xd4, 0xff, 0xff,  //..+@@@%....+@@@
    0x00, 0x4e, 0xff, 0xff, 0xe8, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x8a, 0xff,  //.+@@@........%@
    0x04, 0xe0, 0xff, 0xfc, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a,  //.@@@+.........+
    0x56, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%...........
    0x9e, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+...........
    0xd6, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xec, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xec, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xd6, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@............
    0xa0, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+...........
    0x56, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%...........
    0x04, 0xe0, 0xff, 0xfc, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a,  //.@@@..........+
    0x00, 0x4e, 0xff, 0xff, 0xe6, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x86, 0xff,  //.+@@@........%@
    0x00, 0x00, 0x7a, 0xff, 0xff, 0xf8, 0x92, 0x3c, 0x10, 0x06, 0x20, 0x66, 0xd2, 0xff, 0xff,  //..+@@@%....+@@@
    0x00, 0x00, 0x00, 0x58, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x50,  //...+@@@@@@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x0a, 0x66, 0xae, 0xde, 0xf4, 0xf6, 0xe0, 0xac, 0x5c, 0x04, 0x00,  //.....+%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0044 (D) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf0, 0xe0, 0xc2, 0x90, 0x4c, 0x02, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@%+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x5e, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@+...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x50, 0xa4, 0xfa, 0xff, 0xff, 0x9a, 0x00, 0x00,  //@@@.....+%@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xe6, 0xff, 0xff, 0x72, 0x00,  //@@@........@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xfc, 0xff, 0xee, 0x0e,  //@@@.........@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0x6a,  //@@@.........%@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xaa,  //@@@.........+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xda,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xec,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xec,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xd8,  //@@@..........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xa8,  //@@@.........+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0x68,  //@@@.........%@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xfc, 0xff, 0xee, 0x0c,  //@@@.........@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xe6, 0xff, 0xff, 0x70, 0x00,  //@@@........@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x4e, 0xa4, 0xfa, 0xff, 0xff, 0x98, 0x00, 0x00,  //@@@.....+%@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x5c, 0x00, 0x00, 0x00,  //@@@@@@@@@@@@+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf0, 0xe2, 0xc4, 0x90, 0x4c, 0x02, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0045 (E) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0046 (F) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0047 (G) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x02, 0x58, 0x9e, 0xd6, 0xec, 0xf8, 0xea, 0xcc, 0x92, 0x40, 0x00, 0x00, 0x00,  //.....+%@@@@@%....
    0x00, 0x00, 0x00, 0x48, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x4a, 0x00,  //...+@@@@@@@@@@@+.
    0x00, 0x00, 0x6e, 0xfc, 0xff, 0xfa, 0xa0, 0x4a, 0x18, 0x06, 0x14, 0x3a, 0x90, 0xf0, 0xff, 0xff, 0x00,  //..+@@@%+....%@@@.
    0x00, 0x48, 0xfc, 0xff, 0xea, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xac, 0xff, 0x00,  //.+@@@.........%@.
    0x02, 0xdc, 0xff, 0xfc, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0x00,  //.@@@+..........%.
    0x56, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@%.............
    0x9e, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.............
    0xd6, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..............
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@.......@@@@@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@.......@@@@@@@
    0xd4, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0x9c, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //%@@+..........@@@
    0x50, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //+@@%..........@@@
    0x00, 0xd8, 0xff, 0xfc, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //.@@@..........@@@
    0x00, 0x40, 0xfa, 0xff, 0xe8, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@.........@@@
    0x00, 0x00, 0x60, 0xfa, 0xff, 0xfa, 0xa0, 0x48, 0x16, 0x04, 0x06, 0x20, 0x56, 0xb6, 0xff, 0xff, 0xff,  //..+@@@%+....+%@@@
    0x00, 0x00, 0x00, 0x3a, 0xd2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x3c,  //....@@@@@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x94, 0xce, 0xe8, 0xf8, 0xf2, 0xe0, 0xb6, 0x7e, 0x2a, 0x00, 0x00,  //.....+%@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0048 (H) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0049 (I) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+004a (J) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xfc,  //..@@@
    0x00, 0x08, 0xff, 0xff, 0xf0,  //..@@@
    0x00, 0x26, 0xff, 0xff, 0xd6,  //..@@@
    0x00, 0x70, 0xff, 0xff, 0x9e,  //.+@@%
    0x5a, 0xf0, 0xff, 0xff, 0x3a,  //+@@@.
    0xff, 0xff, 0xff, 0x82, 0x00,  //@@@%.
    0xe0, 0xa8, 0x42, 0x00, 0x00,  //@%+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+004b (K) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf4, 0xff, 0xff, 0x80, 0x00,  //@@@.......@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf4, 0xff, 0xff, 0x82, 0x00, 0x00,  //@@@......@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xf2, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00,  //@@@.....@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x3a, 0xf2, 0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00,  //@@@....@@@%....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x38, 0xf0, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@...@@@%.....
    0xff, 0xff, 0xff, 0x00, 0x36, 0xf0, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..@@@%......
    0xff, 0xff, 0xff, 0x34, 0xee, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.@@@%.......
    0xff, 0xff, 0xff, 0xee, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%........
    0xff, 0xff, 0xff, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@%.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@.........
    0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xc2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@........
    0xff, 0xff, 0xff, 0x5e, 0xfc, 0xff, 0xff, 0xbc, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@+@@@%.......
    0xff, 0xff, 0xff, 0x00, 0x60, 0xfc, 0xff, 0xff, 0xb4, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.+@@@%......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x60, 0xfc, 0xff, 0xff, 0xac, 0x02, 0x00, 0x00, 0x00, 0x00,  //@@@..+@@@%.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x62, 0xfc, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00, 0x00,  //@@@...+@@@%....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x64, 0xfc, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00,  //@@@....+@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xfc, 0xff, 0xff, 0x94, 0x00, 0x00,  //@@@.....+@@@%..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xfc, 0xff, 0xff, 0x8c, 0x00,  //@@@......+@@@%.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xfc, 0xff, 0xff, 0x82,  //@@@.......+@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+004c (L) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+004d (M) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@%.....%@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@.....@@@@@@
    0xff, 0xff, 0xff, 0xe6, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xe6, 0xff, 0xff, 0xff,  //@@@@@@.....@@@@@@
    0xff, 0xff, 0xff, 0x92, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0x92, 0xff, 0xff, 0xff,  //@@@%@@%...%@@%@@@
    0xff, 0xff, 0xff, 0x3c, 0xff, 0xff, 0xe8, 0x02, 0x00, 0x02, 0xe8, 0xff, 0xff, 0x3a, 0xff, 0xff, 0xff,  //@@@.@@@...@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0xe2, 0xff, 0xff, 0x44, 0x00, 0x46, 0xff, 0xff, 0xe0, 0x00, 0xff, 0xff, 0xff,  //@@@.@@@+.+@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0x8c, 0xff, 0xff, 0x9c, 0x00, 0x9c, 0xff, 0xff, 0x8a, 0x00, 0xff, 0xff, 0xff,  //@@@.%@@%.%@@%.@@@
    0xff, 0xff, 0xff, 0x00, 0x34, 0xff, 0xff, 0xec, 0x0a, 0xee, 0xff, 0xff, 0x34, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@.@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0xdc, 0xff, 0xff, 0x9a, 0xff, 0xff, 0xda, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@%@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x84, 0xff, 0xff, 0xff, 0xff, 0xff, 0x84, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..%@@@@@%..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2c, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xd4, 0xff, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...+@@@+...@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....@@@....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xce, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@....@@@....@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@...........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+004e (N) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0xf6, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@.......@@@
    0xff, 0xff, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@%......@@@
    0xff, 0xff, 0xff, 0xff, 0xfa, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@......@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@%.....@@@
    0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@@@@.....@@@
    0xff, 0xff, 0xff, 0xaa, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@%@@%....@@@
    0xff, 0xff, 0xff, 0x2a, 0xfc, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.@@@+...@@@
    0xff, 0xff, 0xff, 0x00, 0xa6, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@.%@@@...@@@
    0xff, 0xff, 0xff, 0x00, 0x26, 0xfc, 0xff, 0xff, 0x54, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@..@@@+..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0xa2, 0xff, 0xff, 0xd6, 0x02, 0x00, 0xff, 0xff, 0xff,  //@@@..%@@@..@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x24, 0xfa, 0xff, 0xff, 0x62, 0x00, 0xff, 0xff, 0xff,  //@@@...@@@+.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xa0, 0xff, 0xff, 0xe2, 0x06, 0xff, 0xff, 0xff,  //@@@...%@@@.@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x22, 0xfa, 0xff, 0xff, 0x72, 0xff, 0xff, 0xff,  //@@@....@@@+@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0xff, 0xea, 0xff, 0xff, 0xff,  //@@@....%@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x20, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@.....@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@.....%@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xf8, 0xff, 0xff, 0xff, 0xff,  //@@@......@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0xff, 0xff,  //@@@......%@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xf6, 0xff, 0xff, 0xff,  //@@@.......@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+004f (O) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x06, 0x62, 0xac, 0xde, 0xf2, 0xf4, 0xde, 0xae, 0x64, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x4e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0c, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x6a, 0x00, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x42, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xec, 0xff, 0xfc, 0x40, 0x00,  //.+@@@........@@@..
    0x02, 0xda, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xd8, 0x00,  //.@@@+........+@@@.
    0x50, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x50,  //+@@@..........%@@+
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //%@@+..........+@@%
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@............@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@............@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@............@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@............@@@
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@............@@@
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //%@@+..........+@@%
    0x50, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x50,  //+@@@..........%@@+
    0x02, 0xda, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xd8, 0x00,  //.@@@+........+@@@.
    0x00, 0x42, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xec, 0xff, 0xfc, 0x42, 0x00,  //.+@@@........@@@+.
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0a, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x6c, 0x00, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x4e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x06, 0x62, 0xae, 0xde, 0xf4, 0xf4, 0xde, 0xae, 0x64, 0x08, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0050 (P) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xd8, 0x9c, 0x32, 0x00, 0x00,  //@@@@@@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x76, 0x00,  //@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x1e, 0x7a, 0xf8, 0xff, 0xff, 0x44,  //@@@....+@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xb2,  //@@@.....%@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe8,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xff, 0xf8,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe8,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xb2,  //@@@.....+@@%
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x1c, 0x76, 0xf8, 0xff, 0xff, 0x46,  //@@@....+@@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7a, 0x00,  //@@@@@@@@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xd8, 0x9e, 0x34, 0x00, 0x00,  //@@@@@@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0051 (Q) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x06, 0x62, 0xac, 0xde, 0xf2, 0xf4, 0xde, 0xae, 0x64, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@%+.....
    0x00, 0x00, 0x00, 0x4e, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x4e, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@+...
    0x00, 0x00, 0x6c, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0c, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfc, 0x6a, 0x00, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x42, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xec, 0xff, 0xfc, 0x40, 0x00,  //.+@@@........@@@..
    0x02, 0xda, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xd8, 0x00,  //.@@@+........+@@@.
    0x50, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x50,  //+@@@..........%@@+
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9a,  //%@@+..........+@@%
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd2,  //@@@............@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xea,  //@@@............@@@
    0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa,  //@@@............@@@
    0xec, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xee,  //@@@............@@@
    0xd4, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xd0,  //@@@............@@@
    0x9c, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xff, 0x9c,  //%@@+..........+@@%
    0x52, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x4a,  //+@@@..........%@@+
    0x02, 0xdc, 0xff, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xd2, 0x00,  //.@@@+........+@@@.
    0x00, 0x44, 0xfc, 0xff, 0xee, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xec, 0xff, 0xfa, 0x38, 0x00,  //.+@@@........@@@..
    0x00, 0x00, 0x6e, 0xfc, 0xff, 0xf8, 0x8c, 0x32, 0x0a, 0x0a, 0x30, 0x8a, 0xf8, 0xff, 0xfa, 0x58, 0x00, 0x00,  //..+@@@%....%@@@+..
    0x00, 0x00, 0x00, 0x50, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x38, 0x00, 0x00, 0x00,  //...+@@@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x08, 0x66, 0xb0, 0xe0, 0xf4, 0xff, 0xff, 0xff, 0xd8, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+%@@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xe8, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00,  //...........@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xee, 0xff, 0x9a, 0x00, 0x00, 0x00,  //............@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xf4, 0xff, 0x8a, 0x00, 0x00,  //.............@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0052 (R) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xda, 0xa2, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@%......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@@%....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x1c, 0x6e, 0xf4, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00,  //@@@....+@@@+...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00,  //@@@.....+@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xea, 0x00, 0x00, 0x00,  //@@@......@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00,  //@@@......@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00,  //@@@......@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00,  //@@@.....+@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x1a, 0x70, 0xf4, 0xff, 0xea, 0x1e, 0x00, 0x00, 0x00,  //@@@....+@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x26, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@@@+.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x10, 0x68, 0xf6, 0xff, 0xfa, 0x54, 0x00, 0x00, 0x00, 0x00,  //@@@...+@@@+....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xf4, 0x24, 0x00, 0x00, 0x00,  //@@@....+@@@....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00,  //@@@.....%@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xfa, 0xff, 0xff, 0x50, 0x00, 0x00,  //@@@......@@@+..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xde, 0x08, 0x00,  //@@@......%@@@..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xe8, 0xff, 0xff, 0x80, 0x00,  //@@@.......@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xff, 0xf6, 0x20,  //@@@.......+@@@.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0xb2,  //@@@........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0053 (S) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x1a, 0x82, 0xc6, 0xee, 0xfa, 0xf2, 0xd8, 0xac, 0x72, 0x26, 0x00,  //...%@@@@@%+..
    0x00, 0x56, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.+@@@@@@@@@@.
    0x36, 0xfa, 0xff, 0xfc, 0x9c, 0x34, 0x10, 0x0a, 0x36, 0x8c, 0xf2, 0xff, 0x00,  //.@@@%....%@@.
    0xb0, 0xff, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xaa, 0x00,  //%@@+.......%.
    0xec, 0xff, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xf8, 0xff, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xda, 0xff, 0xff, 0xa8, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%.........
    0x80, 0xff, 0xff, 0xff, 0xf6, 0xba, 0x82, 0x4e, 0x12, 0x00, 0x00, 0x00, 0x00,  //+@@@@%%+.....
    0x06, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xbe, 0x42, 0x00, 0x00,  //.%@@@@@@@%+..
    0x00, 0x00, 0x60, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,  //..+@@@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x1c, 0x56, 0x8a, 0xd2, 0xff, 0xff, 0xff, 0xff, 0x46,  //.....+%@@@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xe2, 0xff, 0xff, 0xb6,  //.........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff, 0xea,  //.........+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xfa,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xff, 0xec,  //..........@@@
    0xb0, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xff, 0xff, 0xb4,  //%........%@@%
    0xff, 0xfa, 0xa8, 0x54, 0x1a, 0x04, 0x16, 0x3c, 0xa6, 0xff, 0xff, 0xfc, 0x3e,  //@@%+....%@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x5e, 0x00,  //@@@@@@@@@@@+.
    0x22, 0x68, 0xa0, 0xcc, 0xea, 0xfa, 0xf6, 0xe6, 0xbe, 0x7a, 0x1a, 0x00, 0x00,  //.+%@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0054 (T) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0055 (U) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@........@@@
    0xf2, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xf0,  //@@@........@@@
    0xd8, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xd6,  //@@@........@@@
    0xa2, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xa0,  //%@@+......+@@%
    0x46, 0xff, 0xff, 0xd2, 0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0xd4, 0xff, 0xff, 0x42,  //+@@@......@@@+
    0x00, 0xb6, 0xff, 0xff, 0xbe, 0x3a, 0x08, 0x08, 0x3c, 0xc0, 0xff, 0xff, 0xb2, 0x00,  //.%@@%....%@@%.
    0x00, 0x10, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x0e, 0x00,  //..%@@@@@@@@%..
    0x00, 0x00, 0x00, 0x50, 0xaa, 0xe0, 0xf6, 0xf6, 0xe0, 0xaa, 0x4e, 0x00, 0x00, 0x00,  //...+%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0056 (V) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xce, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xce,  //@@@+.........+@@@
    0x70, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0x6e,  //+@@%.........@@@+
    0x14, 0xfa, 0xff, 0xfc, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xfa, 0x14,  //.@@@.........@@@.
    0x00, 0xb0, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xb0, 0x00,  //.%@@+.......+@@%.
    0x00, 0x52, 0xff, 0xff, 0xde, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0xff, 0xff, 0x50, 0x00,  //.+@@@.......@@@+.
    0x00, 0x04, 0xec, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xff, 0xff, 0xea, 0x04, 0x00,  //..@@@.......@@@..
    0x00, 0x00, 0x92, 0xff, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x92, 0x00, 0x00,  //..%@@%.....%@@%..
    0x00, 0x00, 0x34, 0xff, 0xff, 0xf2, 0x0a, 0x00, 0x00, 0x00, 0x0a, 0xf2, 0xff, 0xff, 0x32, 0x00, 0x00,  //...@@@.....@@@...
    0x00, 0x00, 0x00, 0xd4, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00,  //...@@@+...+@@@...
    0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00,  //...+@@%...%@@+...
    0x00, 0x00, 0x00, 0x18, 0xfa, 0xff, 0xfc, 0x1c, 0x00, 0x1e, 0xfc, 0xff, 0xfa, 0x18, 0x00, 0x00, 0x00,  //....@@@...@@@....
    0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0xff, 0x7a, 0x00, 0x7c, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00,  //....%@@+.+@@%....
    0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xd8, 0x00, 0xda, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00,  //....+@@@.@@@+....
    0x00, 0x00, 0x00, 0x00, 0x06, 0xee, 0xff, 0xff, 0x76, 0xff, 0xff, 0xee, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....@@@+@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0xff, 0xfa, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xff, 0xff, 0xff, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xff, 0xfc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0057 (W) , Width: 24 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0xde, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xff, 0xff, 0xde,  //@@@.......%@@%.......@@@
    0x9e, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xff, 0xff, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0x9e,  //%@@+......@@@@......+@@%
    0x5e, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xfc, 0xf8, 0xf4, 0xfc, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0x5e,  //+@@%......@@@@......%@@+
    0x1e, 0xff, 0xff, 0xf2, 0x02, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xc2, 0xbc, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x02, 0xf2, 0xff, 0xff, 0x1e,  //.@@@.....+@@%@+.....@@@.
    0x00, 0xde, 0xff, 0xff, 0x36, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0x84, 0x7e, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xff, 0xdc, 0x00,  //.@@@.....%@%+@%.....@@@.
    0x00, 0x9e, 0xff, 0xff, 0x76, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0x46, 0x40, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x78, 0xff, 0xff, 0x9c, 0x00,  //.%@@+....@@+.@@....+@@%.
    0x00, 0x5e, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x0a, 0xfa, 0xfa, 0x0a, 0x08, 0xf8, 0xfa, 0x0c, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0x5c, 0x00,  //.+@@%....@@..@@....%@@+.
    0x00, 0x1e, 0xff, 0xff, 0xf2, 0x02, 0x00, 0x00, 0x44, 0xff, 0xc8, 0x00, 0x00, 0xc4, 0xff, 0x48, 0x00, 0x00, 0x04, 0xf2, 0xff, 0xff, 0x1c, 0x00,  //..@@@...+@@..@@+...@@@..
    0x00, 0x00, 0xde, 0xff, 0xff, 0x38, 0x00, 0x00, 0x82, 0xff, 0x88, 0x00, 0x00, 0x86, 0xff, 0x86, 0x00, 0x00, 0x38, 0xff, 0xff, 0xdc, 0x00, 0x00,  //..@@@...%@%..%@%...@@@..
    0x00, 0x00, 0x9e, 0xff, 0xff, 0x78, 0x00, 0x00, 0xc0, 0xff, 0x4a, 0x00, 0x00, 0x48, 0xff, 0xc4, 0x00, 0x00, 0x78, 0xff, 0xff, 0x9c, 0x00, 0x00,  //..%@@+..%@+..+@@..+@@%..
    0x00, 0x00, 0x5e, 0xff, 0xff, 0xb8, 0x00, 0x06, 0xf6, 0xfc, 0x0e, 0x00, 0x00, 0x0c, 0xfc, 0xf8, 0x08, 0x00, 0xb8, 0xff, 0xff, 0x5c, 0x00, 0x00,  //..+@@%..@@....@@..%@@+..
    0x00, 0x00, 0x1e, 0xff, 0xff, 0xf2, 0x02, 0x3e, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xff, 0x40, 0x04, 0xf2, 0xff, 0xff, 0x1c, 0x00, 0x00,  //...@@@..@@....@@..@@@...
    0x00, 0x00, 0x00, 0xde, 0xff, 0xff, 0x38, 0x7c, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x7e, 0x38, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00,  //...@@@.+@%....%@+.@@@...
    0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0x78, 0xbc, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0xbc, 0x78, 0xff, 0xff, 0x9c, 0x00, 0x00, 0x00,  //...%@@+%@+....+@%+@@%...
    0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xbc, 0xf4, 0xfc, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4, 0xbe, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00,  //...+@@%@@......@@%@@+...
    0x00, 0x00, 0x00, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd4, 0xff, 0xff, 0xff, 0xff, 0x1a, 0x00, 0x00, 0x00,  //....@@@@@......@@@@@....
    0x00, 0x00, 0x00, 0x00, 0xde, 0xff, 0xff, 0xff, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00,  //....@@@@%......%@@@@....
    0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00,  //....%@@@+......+@@@%....
    0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00,  //....+@@@........@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........................


    /*Unicode: U+0058 (X) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0xb2, 0xff, 0xff, 0xde, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xe0, 0xff, 0xff, 0xaa,  //.%@@@.......@@@%
    0x00, 0x20, 0xf6, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0xec, 0x16,  //..@@@+.....%@@@.
    0x00, 0x00, 0x7e, 0xff, 0xff, 0xf6, 0x22, 0x00, 0x00, 0x00, 0x3c, 0xfc, 0xff, 0xff, 0x5c, 0x00,  //..+@@@.....@@@+.
    0x00, 0x00, 0x06, 0xdc, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x08, 0xd8, 0xff, 0xff, 0xb6, 0x00, 0x00,  //...@@@%...@@@%..
    0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x88, 0xff, 0xff, 0xf0, 0x1c, 0x00, 0x00,  //...+@@@+.%@@@...
    0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xff, 0xde, 0x3c, 0xfa, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00,  //....%@@@.@@@+...
    0x00, 0x00, 0x00, 0x00, 0x1e, 0xf4, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x24, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xda, 0xff, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xca, 0xff, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....+@@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x24, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00,  //.....@@@@@@+....
    0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xd4, 0x78, 0xff, 0xff, 0xf6, 0x20, 0x00, 0x00, 0x00,  //....%@@@+@@@....
    0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xfc, 0x36, 0x02, 0xd2, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00,  //...+@@@..@@@%...
    0x00, 0x00, 0x1c, 0xf0, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x3e, 0xff, 0xff, 0xff, 0x4a, 0x00, 0x00,  //...@@@%...@@@+..
    0x00, 0x00, 0xb6, 0xff, 0xff, 0xdc, 0x08, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0xdc, 0x06, 0x00,  //..%@@@....%@@@..
    0x00, 0x5e, 0xff, 0xff, 0xfc, 0x40, 0x00, 0x00, 0x00, 0x00, 0x18, 0xf0, 0xff, 0xff, 0x7e, 0x00,  //.+@@@......@@@+.
    0x16, 0xec, 0xff, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xf6, 0x20,  //.@@@%......+@@@.
    0xac, 0xff, 0xff, 0xe2, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xd0, 0xff, 0xff, 0xb2,  //%@@@........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0059 (Y) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xa4, 0xff, 0xff, 0xea, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xe8, 0xff, 0xff, 0xa4,  //%@@@.........@@@%
    0x0e, 0xe0, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0xe0, 0x0e,  //.@@@%.......%@@@.
    0x00, 0x3e, 0xfc, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xff, 0xfc, 0x3e, 0x00,  //..@@@+.....+@@@..
    0x00, 0x00, 0x88, 0xff, 0xff, 0xf4, 0x28, 0x00, 0x00, 0x00, 0x28, 0xf4, 0xff, 0xff, 0x88, 0x00, 0x00,  //..%@@@.....@@@%..
    0x00, 0x00, 0x04, 0xce, 0xff, 0xff, 0xcc, 0x04, 0x00, 0x04, 0xcc, 0xff, 0xff, 0xcc, 0x04, 0x00, 0x00,  //...@@@@...@@@@...
    0x00, 0x00, 0x00, 0x28, 0xf6, 0xff, 0xff, 0x86, 0x00, 0x86, 0xff, 0xff, 0xf4, 0x28, 0x00, 0x00, 0x00,  //....@@@%.%@@@....
    0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xfc, 0x78, 0xfc, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00,  //....+@@@+@@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xea, 0xff, 0xff, 0xff, 0xea, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......+@@@+......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......@@@.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+005a (Z) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xfa, 0xff, 0xff, 0x9a,  //...........@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xe2, 0xff, 0xff, 0xd0, 0x08,  //..........@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0xf2, 0x26, 0x00,  //.........%@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00,  //........+@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xf8, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00,  //........@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xde, 0xff, 0xff, 0xd0, 0x08, 0x00, 0x00, 0x00,  //.......@@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0xf2, 0x26, 0x00, 0x00, 0x00, 0x00,  //......%@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....+@@@+.....
    0x00, 0x00, 0x00, 0x00, 0x30, 0xf6, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@%......
    0x00, 0x00, 0x00, 0x0c, 0xda, 0xff, 0xff, 0xd0, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@@.......
    0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0xf2, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@........
    0x00, 0x00, 0x64, 0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@@+........
    0x00, 0x2a, 0xf4, 0xff, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@%.........
    0x08, 0xd4, 0xff, 0xff, 0xd0, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@..........
    0x9e, 0xff, 0xff, 0xf2, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+005b ([) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+005c (\) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xd4, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+......
    0x80, 0xff, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@%......
    0x2c, 0xff, 0xe8, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@......
    0x00, 0xd8, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@......
    0x00, 0x84, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@%.....
    0x00, 0x30, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@.....
    0x00, 0x00, 0xdc, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00,  //..@@.....
    0x00, 0x00, 0x88, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00,  //..%@%....
    0x00, 0x00, 0x34, 0xff, 0xe2, 0x00, 0x00, 0x00, 0x00,  //...@@....
    0x00, 0x00, 0x00, 0xe0, 0xff, 0x38, 0x00, 0x00, 0x00,  //...@@....
    0x00, 0x00, 0x00, 0x8c, 0xff, 0x8c, 0x00, 0x00, 0x00,  //...%@%...
    0x00, 0x00, 0x00, 0x38, 0xff, 0xe0, 0x00, 0x00, 0x00,  //....@@...
    0x00, 0x00, 0x00, 0x00, 0xe2, 0xff, 0x34, 0x00, 0x00,  //....@@...
    0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0x88, 0x00, 0x00,  //....%@%..
    0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xdc, 0x00, 0x00,  //.....@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0xff, 0x30, 0x00,  //.....@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0x84, 0x00,  //.....%@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xff, 0xd8, 0x00,  //......@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe8, 0xff, 0x2c,  //......@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xff, 0x80,  //......%@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xd4,  //......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+005d (]) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //...@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+005e (^) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xae, 0xff, 0xff, 0xae, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //......%@@%......
    0x00, 0x00, 0x00, 0x00, 0x02, 0xa6, 0xff, 0xff, 0xff, 0xff, 0xa6, 0x02, 0x00, 0x00, 0x00, 0x00,  //.....%@@@@%.....
    0x00, 0x00, 0x00, 0x00, 0xa0, 0xff, 0xff, 0x7a, 0x7a, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0x00,  //....%@@++@@%....
    0x00, 0x00, 0x00, 0x98, 0xff, 0xfa, 0x62, 0x00, 0x00, 0x64, 0xfa, 0xff, 0x98, 0x00, 0x00, 0x00,  //...%@@+..+@@%...
    0x00, 0x00, 0x92, 0xff, 0xf6, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xf6, 0xff, 0x92, 0x00, 0x00,  //..%@@+....+@@%..
    0x00, 0x8a, 0xff, 0xee, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xee, 0xff, 0x8a, 0x00,  //.%@@........@@%.
    0x82, 0xff, 0xe2, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xe2, 0xff, 0x82,  //%@@..........@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+005f (_) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@


    /*Unicode: U+0060 (`) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x96, 0xff, 0xca, 0x04, 0x00, 0x00,  //%@@...
    0x04, 0xc0, 0xff, 0x84, 0x00, 0x00,  //.%@%..
    0x00, 0x14, 0xe0, 0xfc, 0x3c, 0x00,  //..@@..
    0x00, 0x00, 0x2e, 0xf4, 0xde, 0x0e,  //...@@.
    0x00, 0x00, 0x00, 0x54, 0xff, 0xa4,  //...+@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0061 (a) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x2a, 0x7c, 0xbc, 0xe6, 0xf8, 0xf2, 0xd8, 0x9c, 0x30, 0x00, 0x00,  //..+%@@@@%...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x6c, 0x00,  //.@@@@@@@@@+.
    0x00, 0xc6, 0x68, 0x2a, 0x0a, 0x06, 0x24, 0x7e, 0xf6, 0xff, 0xfc, 0x34,  //.@+....+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xa2,  //........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xde,  //.........@@@
    0x00, 0x00, 0x50, 0xaa, 0xdc, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,  //..+%@@@@@@@@
    0x06, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@@@
    0x80, 0xff, 0xff, 0xe0, 0x54, 0x1a, 0x04, 0x00, 0x04, 0xff, 0xff, 0xff,  //+@@@+....@@@
    0xda, 0xff, 0xff, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xff,  //@@@......@@@
    0xf8, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0xff,  //@@@.....+@@@
    0xea, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x04, 0xd4, 0xff, 0xff, 0xff,  //@@@.....@@@@
    0xa4, 0xff, 0xff, 0xce, 0x32, 0x06, 0x2c, 0xb6, 0xae, 0xff, 0xff, 0xff,  //%@@@...%%@@@
    0x22, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x18, 0xff, 0xff, 0xff,  //.@@@@@@@.@@@
    0x00, 0x20, 0xa2, 0xe8, 0xf8, 0xdc, 0x8c, 0x12, 0x00, 0xff, 0xff, 0xff,  //..%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0062 (b) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x18, 0x94, 0xe0, 0xf6, 0xda, 0x8a, 0x0e, 0x00, 0x00,  //@@@..%@@@%...
    0xff, 0xff, 0xff, 0x1c, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x1e, 0x00,  //@@@.@@@@@@@..
    0xff, 0xff, 0xff, 0xb2, 0xb8, 0x2c, 0x06, 0x2c, 0xb8, 0xff, 0xff, 0xc8, 0x02,  //@@@%%...%@@@.
    0xff, 0xff, 0xff, 0xd2, 0x06, 0x00, 0x00, 0x00, 0x06, 0xd2, 0xff, 0xff, 0x54,  //@@@@.....@@@+
    0xff, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xac,  //@@@+.....+@@%
    0xff, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf6,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf6,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xac,  //@@@+.....+@@%
    0xff, 0xff, 0xff, 0xd2, 0x06, 0x00, 0x00, 0x00, 0x06, 0xd2, 0xff, 0xff, 0x54,  //@@@@.....@@@+
    0xff, 0xff, 0xff, 0xb2, 0xb8, 0x2a, 0x04, 0x2a, 0xb8, 0xff, 0xff, 0xcc, 0x02,  //@@@%%...%@@@.
    0xff, 0xff, 0xff, 0x1c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x20, 0x00,  //@@@.@@@@@@@..
    0xff, 0xff, 0xff, 0x00, 0x1a, 0x96, 0xe2, 0xf8, 0xdc, 0x8a, 0x10, 0x00, 0x00,  //@@@..%@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0063 (c) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x3e, 0xa2, 0xdc, 0xf4, 0xf6, 0xd8, 0x9a, 0x38,  //....%@@@@%.
    0x00, 0x06, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@
    0x00, 0xa2, 0xff, 0xff, 0xe2, 0x5c, 0x14, 0x04, 0x1c, 0x5a, 0xc0,  //.%@@@+...+%
    0x40, 0xff, 0xff, 0xea, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.......
    0xa2, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.......
    0xde, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xf6, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xf6, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xdc, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xa2, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.......
    0x3e, 0xff, 0xff, 0xea, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.......
    0x00, 0xa0, 0xff, 0xff, 0xe2, 0x5c, 0x14, 0x02, 0x1c, 0x5a, 0xc0,  //.%@@@+...+%
    0x00, 0x06, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@@@@
    0x00, 0x00, 0x00, 0x42, 0xa6, 0xe0, 0xf8, 0xf4, 0xd6, 0x98, 0x38,  //...+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0064 (d) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x10, 0x8a, 0xdc, 0xf6, 0xe0, 0x92, 0x16, 0x00, 0xff, 0xff, 0xff,  //...%@@@%..@@@
    0x00, 0x1e, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x1a, 0xff, 0xff, 0xff,  //..@@@@@@@.@@@
    0x02, 0xca, 0xff, 0xff, 0xb6, 0x2c, 0x06, 0x2c, 0xb8, 0xb0, 0xff, 0xff, 0xff,  //.@@@%...%%@@@
    0x54, 0xff, 0xff, 0xd0, 0x04, 0x00, 0x00, 0x00, 0x06, 0xd2, 0xff, 0xff, 0xff,  //+@@@.....@@@@
    0xac, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff,  //%@@+.....+@@@
    0xe0, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xe0, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xac, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff,  //%@@+.....+@@@
    0x56, 0xff, 0xff, 0xd0, 0x04, 0x00, 0x00, 0x00, 0x06, 0xd2, 0xff, 0xff, 0xff,  //+@@@.....@@@@
    0x02, 0xcc, 0xff, 0xff, 0xb6, 0x2a, 0x04, 0x2a, 0xb8, 0xb0, 0xff, 0xff, 0xff,  //.@@@%...%%@@@
    0x00, 0x20, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x1c, 0xff, 0xff, 0xff,  //..@@@@@@@.@@@
    0x00, 0x00, 0x10, 0x8c, 0xdc, 0xf6, 0xe0, 0x96, 0x18, 0x00, 0xff, 0xff, 0xff,  //...%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0065 (e) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x3c, 0xa2, 0xde, 0xf6, 0xf0, 0xca, 0x78, 0x0a, 0x00, 0x00,  //....%@@@@+...
    0x00, 0x04, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x20, 0x00,  //..%@@@@@@@@..
    0x00, 0x96, 0xff, 0xff, 0xc4, 0x3a, 0x06, 0x18, 0x8c, 0xff, 0xff, 0xce, 0x04,  //.%@@@...%@@@.
    0x34, 0xff, 0xff, 0xde, 0x08, 0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0x60,  //.@@@.....%@@+
    0x9a, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xb4,  //%@@+......@@%
    0xd8, 0xff, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xe6,  //@@@.......@@@
    0xf4, 0xff, 0xff, 0xfa, 0xfa, 0xfc, 0xfc, 0xfc, 0xfc, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@@@@
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@
    0xe0, 0xff, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xa4, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@+.........
    0x40, 0xff, 0xff, 0xde, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@.........
    0x00, 0xa0, 0xff, 0xff, 0xd2, 0x54, 0x14, 0x02, 0x0e, 0x32, 0x72, 0xcc, 0x00,  //.%@@@+....+@.
    0x00, 0x06, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //..%@@@@@@@@@.
    0x00, 0x00, 0x00, 0x3c, 0xa0, 0xdc, 0xf6, 0xf8, 0xe4, 0xbc, 0x74, 0x26, 0x00,  //....%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0066 (f) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x12, 0x86, 0xd0, 0xf2, 0xfc, 0xff,  //....%@@@@
    0x00, 0x00, 0x16, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@
    0x00, 0x00, 0x92, 0xff, 0xff, 0xa8, 0x1c, 0x00, 0x00,  //..%@@%...
    0x00, 0x00, 0xdc, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00,  //..@@@....
    0x00, 0x00, 0xf8, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00,  //..@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@@....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0067 (g) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x12, 0x8e, 0xdc, 0xf6, 0xe0, 0x92, 0x16, 0x00, 0xff, 0xff, 0xff,  //...%@@@%..@@@
    0x00, 0x24, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x1a, 0xff, 0xff, 0xff,  //..@@@@@@@.@@@
    0x04, 0xd0, 0xff, 0xff, 0xb4, 0x2a, 0x06, 0x2a, 0xb4, 0xb0, 0xff, 0xff, 0xff,  //.@@@%...%%@@@
    0x5a, 0xff, 0xff, 0xce, 0x04, 0x00, 0x00, 0x00, 0x04, 0xce, 0xff, 0xff, 0xff,  //+@@@.....@@@@
    0xb0, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xff,  //%@@+.....+@@@
    0xe2, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xe2, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xb0, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xff,  //%@@+.....+@@@
    0x5c, 0xff, 0xff, 0xce, 0x04, 0x00, 0x00, 0x00, 0x04, 0xce, 0xff, 0xff, 0xff,  //+@@@.....@@@@
    0x04, 0xd2, 0xff, 0xff, 0xb2, 0x2a, 0x04, 0x2a, 0xb4, 0xb0, 0xff, 0xff, 0xff,  //.@@@%...%%@@@
    0x00, 0x26, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x1c, 0xff, 0xff, 0xf8,  //..@@@@@@@.@@@
    0x00, 0x00, 0x14, 0x90, 0xde, 0xf6, 0xe0, 0x94, 0x16, 0x10, 0xff, 0xff, 0xe8,  //...%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xbe,  //.........+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbe, 0xff, 0xff, 0x74,  //.........%@@+
    0x00, 0x00, 0xc2, 0x5c, 0x26, 0x08, 0x0c, 0x40, 0xbc, 0xff, 0xff, 0xe6, 0x10,  //..@+....%@@@.
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x38, 0x00,  //..@@@@@@@@@..
    0x00, 0x00, 0x36, 0x94, 0xcc, 0xe6, 0xfa, 0xee, 0xc6, 0x7e, 0x14, 0x00, 0x00,  //...%@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0068 (h) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.........
    0xff, 0xff, 0xff, 0x00, 0x12, 0x90, 0xe0, 0xf6, 0xd8, 0x7e, 0x06, 0x00,  //@@@..%@@@+..
    0xff, 0xff, 0xff, 0x14, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x00,  //@@@.@@@@@@%.
    0xff, 0xff, 0xff, 0xac, 0xa6, 0x24, 0x06, 0x4a, 0xf0, 0xff, 0xff, 0x54,  //@@@%%..+@@@+
    0xff, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0xae,  //@@@@....+@@%
    0xff, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xe0,  //@@@+.....@@@
    0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf6,  //@@@......@@@
    0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0069 (i) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+006a (j) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x00, 0xff, 0xff, 0xff,  //..@@@
    0x00, 0x04, 0xff, 0xff, 0xf4,  //..@@@
    0x00, 0x1c, 0xff, 0xff, 0xd8,  //..@@@
    0x0e, 0x90, 0xff, 0xff, 0x92,  //.%@@%
    0xff, 0xff, 0xff, 0xe8, 0x1a,  //@@@@.
    0xf6, 0xd8, 0x92, 0x1a, 0x00,  //@@%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+006b (k) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xea, 0xff, 0xff, 0xfc, 0x6c,  //@@@.....@@@@+
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x58, 0xf6, 0xff, 0xff, 0xf2, 0x4c, 0x00,  //@@@...+@@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x7a, 0xfc, 0xff, 0xff, 0xe6, 0x32, 0x00, 0x00,  //@@@..+@@@@...
    0xff, 0xff, 0xff, 0x04, 0x9c, 0xff, 0xff, 0xff, 0xd2, 0x1c, 0x00, 0x00, 0x00,  //@@@.%@@@@....
    0xff, 0xff, 0xff, 0xbc, 0xff, 0xff, 0xff, 0xba, 0x0e, 0x00, 0x00, 0x00, 0x00,  //@@@%@@@%.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@%.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@+......
    0xff, 0xff, 0xff, 0xce, 0xff, 0xff, 0xfc, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@@@+.....
    0xff, 0xff, 0xff, 0x10, 0xca, 0xff, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00,  //@@@.@@@@+....
    0xff, 0xff, 0xff, 0x00, 0x0e, 0xc8, 0xff, 0xff, 0xff, 0x6e, 0x00, 0x00, 0x00,  //@@@..@@@@+...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x0c, 0xc4, 0xff, 0xff, 0xff, 0x74, 0x00, 0x00,  //@@@...@@@@+..
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x0a, 0xc0, 0xff, 0xff, 0xff, 0x78, 0x00,  //@@@....%@@@+.
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xbe, 0xff, 0xff, 0xff, 0x7c,  //@@@.....%@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+006c (l) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+006d (m) , Width: 21 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0xff, 0xff, 0xff, 0x00, 0x14, 0x90, 0xe0, 0xf4, 0xce, 0x5c, 0x00, 0x00, 0x00, 0x1c, 0x96, 0xde, 0xf6, 0xda, 0x7a, 0x04, 0x00,  //@@@..%@@@+....%@@@+..
    0xff, 0xff, 0xff, 0x18, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x74, 0x00, 0x2e, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x00,  //@@@.@@@@@@+..@@@@@@%.
    0xff, 0xff, 0xff, 0xae, 0xac, 0x24, 0x06, 0x44, 0xec, 0xff, 0xf8, 0x20, 0xdc, 0xac, 0x26, 0x06, 0x44, 0xec, 0xff, 0xff, 0x4c,  //@@@%%..+@@@.@%..+@@@+
    0xff, 0xff, 0xff, 0xcc, 0x02, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xe0, 0xcc, 0x02, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0xaa,  //@@@@....+@@@@....+@@%
    0xff, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xff, 0xde,  //@@@+.....@@@+.....@@@
    0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf4,  //@@@......@@@......@@@
    0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....................


    /*Unicode: U+006e (n) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0x00, 0x12, 0x90, 0xe0, 0xf6, 0xd8, 0x7e, 0x06, 0x00,  //@@@..%@@@+..
    0xff, 0xff, 0xff, 0x14, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x00,  //@@@.@@@@@@%.
    0xff, 0xff, 0xff, 0xac, 0xa6, 0x24, 0x06, 0x4a, 0xf0, 0xff, 0xff, 0x54,  //@@@%%..+@@@+
    0xff, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0xae,  //@@@@....+@@%
    0xff, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xe0,  //@@@+.....@@@
    0xff, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf6,  //@@@......@@@
    0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+006f (o) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x02, 0x60, 0xb8, 0xe8, 0xf8, 0xe8, 0xb8, 0x5e, 0x02, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x12, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //..@@@@@@@@@..
    0x00, 0xbc, 0xff, 0xff, 0xba, 0x2c, 0x06, 0x2e, 0xbe, 0xff, 0xff, 0xba, 0x00,  //.%@@%...%@@%.
    0x4e, 0xff, 0xff, 0xda, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //+@@@.....@@@+
    0xaa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //%@@+.....+@@%
    0xe0, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xde,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xff, 0xff, 0xf4,  //@@@.......@@@
    0xe0, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xff, 0xde,  //@@@.......@@@
    0xaa, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xa8,  //%@@+.....+@@%
    0x50, 0xff, 0xff, 0xd8, 0x06, 0x00, 0x00, 0x00, 0x08, 0xde, 0xff, 0xff, 0x4c,  //+@@@.....@@@+
    0x00, 0xbe, 0xff, 0xff, 0xb8, 0x2a, 0x04, 0x2c, 0xbc, 0xff, 0xff, 0xba, 0x00,  //.%@@%...%@@%.
    0x00, 0x12, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x12, 0x00,  //..@@@@@@@@@..
    0x00, 0x00, 0x02, 0x60, 0xba, 0xea, 0xfa, 0xea, 0xba, 0x5e, 0x02, 0x00, 0x00,  //...+%@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0070 (p) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0xff, 0x00, 0x18, 0x94, 0xe0, 0xf6, 0xda, 0x8a, 0x0e, 0x00, 0x00,  //@@@..%@@@%...
    0xff, 0xff, 0xff, 0x1c, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x1e, 0x00,  //@@@.@@@@@@@..
    0xff, 0xff, 0xff, 0xb2, 0xb8, 0x2c, 0x06, 0x2c, 0xb8, 0xff, 0xff, 0xc8, 0x02,  //@@@%%...%@@@.
    0xff, 0xff, 0xff, 0xd2, 0x06, 0x00, 0x00, 0x00, 0x06, 0xd2, 0xff, 0xff, 0x54,  //@@@@.....@@@+
    0xff, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xac,  //@@@+.....+@@%
    0xff, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf6,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xf6,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xe0,  //@@@.......@@@
    0xff, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xac,  //@@@+.....+@@%
    0xff, 0xff, 0xff, 0xd2, 0x06, 0x00, 0x00, 0x00, 0x06, 0xd2, 0xff, 0xff, 0x54,  //@@@@.....@@@+
    0xff, 0xff, 0xff, 0xb2, 0xb8, 0x2a, 0x04, 0x2a, 0xb8, 0xff, 0xff, 0xcc, 0x02,  //@@@%%...%@@@.
    0xff, 0xff, 0xff, 0x1c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x20, 0x00,  //@@@.@@@@@@@..
    0xff, 0xff, 0xff, 0x00, 0x1a, 0x96, 0xe2, 0xf8, 0xdc, 0x8a, 0x10, 0x00, 0x00,  //@@@..%@@@%...
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0071 (q) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x10, 0x8a, 0xdc, 0xf6, 0xe0, 0x92, 0x16, 0x00, 0xff, 0xff, 0xff,  //...%@@@%..@@@
    0x00, 0x1e, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x1a, 0xff, 0xff, 0xff,  //..@@@@@@@.@@@
    0x02, 0xca, 0xff, 0xff, 0xb6, 0x2c, 0x06, 0x2c, 0xb8, 0xb0, 0xff, 0xff, 0xff,  //.@@@%...%%@@@
    0x54, 0xff, 0xff, 0xd0, 0x04, 0x00, 0x00, 0x00, 0x06, 0xd2, 0xff, 0xff, 0xff,  //+@@@.....@@@@
    0xac, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff,  //%@@+.....+@@@
    0xe0, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xf6, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xe0, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xff, 0xff,  //@@@.......@@@
    0xac, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xff, 0xff,  //%@@+.....+@@@
    0x56, 0xff, 0xff, 0xd0, 0x04, 0x00, 0x00, 0x00, 0x06, 0xd2, 0xff, 0xff, 0xff,  //+@@@.....@@@@
    0x02, 0xcc, 0xff, 0xff, 0xb6, 0x2a, 0x04, 0x2a, 0xb8, 0xb0, 0xff, 0xff, 0xff,  //.@@@%...%%@@@
    0x00, 0x20, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x1c, 0xff, 0xff, 0xff,  //..@@@@@@@.@@@
    0x00, 0x00, 0x10, 0x8c, 0xdc, 0xf6, 0xe0, 0x96, 0x18, 0x00, 0xff, 0xff, 0xff,  //...%@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //..........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+0072 (r) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0x00, 0x2a, 0xb0, 0xec, 0xfc,  //@@@..%@@
    0xff, 0xff, 0xff, 0x2a, 0xee, 0xff, 0xff, 0xff,  //@@@.@@@@
    0xff, 0xff, 0xff, 0xba, 0xaa, 0x26, 0x00, 0x00,  //@@@%%...
    0xff, 0xff, 0xff, 0xc8, 0x02, 0x00, 0x00, 0x00,  //@@@@....
    0xff, 0xff, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00,  //@@@+....
    0xff, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00,  //@@@.....
    0xff, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00,  //@@@.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0073 (s) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x10, 0x80, 0xca, 0xf0, 0xfa, 0xf0, 0xce, 0x92, 0x36, 0x00,  //..+@@@@@%..
    0x22, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@@@@.
    0xb0, 0xff, 0xff, 0xc2, 0x3a, 0x0e, 0x04, 0x20, 0x5c, 0xc0, 0x00,  //%@@@....+%.
    0xf2, 0xff, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xf2, 0xff, 0xff, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@........
    0xa8, 0xff, 0xff, 0xc8, 0x80, 0x8a, 0x56, 0x10, 0x00, 0x00, 0x00,  //%@@@+%+....
    0x14, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x9c, 0x14, 0x00,  //.@@@@@@@%..
    0x00, 0x00, 0x44, 0x98, 0xd4, 0xff, 0xff, 0xff, 0xff, 0xde, 0x14,  //..+%@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x60, 0xda, 0xff, 0xff, 0x9e,  //......+@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xff, 0xff, 0xec,  //........@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xff, 0xf0,  //........@@@
    0xd0, 0x7c, 0x3c, 0x14, 0x02, 0x0e, 0x3e, 0xc4, 0xff, 0xff, 0xa6,  //@+.....@@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xce, 0x14,  //@@@@@@@@@@.
    0x28, 0x76, 0xb4, 0xe0, 0xf8, 0xf8, 0xe6, 0xb8, 0x62, 0x04, 0x00,  //.+%@@@@%+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0074 (t) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.....
    0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.....
    0x00, 0x00, 0xfc, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@.....
    0x00, 0x00, 0xea, 0xff, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00,  //..@@@.....
    0x00, 0x00, 0xb4, 0xff, 0xff, 0x8c, 0x14, 0x00, 0x00, 0x00,  //..%@@%....
    0x00, 0x00, 0x3c, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@@
    0x00, 0x00, 0x00, 0x34, 0xa2, 0xda, 0xf4, 0xfc, 0xff, 0xff,  //....%@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0075 (u) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,  //@@@......@@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff,  //@@@......@@@
    0xf6, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xff,  //@@@......@@@
    0xe0, 0xff, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xff,  //@@@.....+@@@
    0xae, 0xff, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0xff,  //%@@+....@@@@
    0x54, 0xff, 0xff, 0xee, 0x48, 0x04, 0x22, 0xa8, 0xaa, 0xff, 0xff, 0xff,  //+@@@+..%%@@@
    0x00, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x14, 0xff, 0xff, 0xff,  //.%@@@@@@.@@@
    0x00, 0x06, 0x7c, 0xd8, 0xf8, 0xe2, 0x92, 0x12, 0x00, 0xff, 0xff, 0xff,  //..+@@@%..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0076 (v) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xce, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xcc,  //@@@+......+@@@
    0x6a, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0x6a,  //+@@@......@@@+
    0x10, 0xf6, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xff, 0xf6, 0x10,  //.@@@......@@@.
    0x00, 0xa6, 0xff, 0xff, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0xa4, 0x00,  //.%@@%....%@@%.
    0x00, 0x44, 0xff, 0xff, 0xea, 0x04, 0x00, 0x00, 0x06, 0xec, 0xff, 0xff, 0x42, 0x00,  //.+@@@....@@@+.
    0x00, 0x00, 0xde, 0xff, 0xff, 0x54, 0x00, 0x00, 0x56, 0xff, 0xff, 0xde, 0x00, 0x00,  //..@@@+..+@@@..
    0x00, 0x00, 0x7e, 0xff, 0xff, 0xb6, 0x00, 0x00, 0xb8, 0xff, 0xff, 0x7e, 0x00, 0x00,  //..+@@%..%@@+..
    0x00, 0x00, 0x1e, 0xfc, 0xff, 0xfc, 0x1c, 0x1c, 0xfc, 0xff, 0xfc, 0x1c, 0x00, 0x00,  //...@@@..@@@...
    0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0x7c, 0x7e, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00,  //...%@@++@@%...
    0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xde, 0xde, 0xff, 0xff, 0x56, 0x00, 0x00, 0x00,  //...+@@@@@@+...
    0x00, 0x00, 0x00, 0x06, 0xec, 0xff, 0xff, 0xff, 0xff, 0xec, 0x06, 0x00, 0x00, 0x00,  //....@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x92, 0xff, 0xff, 0xff, 0xff, 0x90, 0x00, 0x00, 0x00, 0x00,  //....%@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x00,  //.....@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xff, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0077 (w) , Width: 19 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0xdc, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x0a, 0xf8, 0xff, 0xf8, 0x0a, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0xdc,  //@@@.....@@@.....@@@
    0x9a, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x98,  //%@@+...+@@@+...+@@%
    0x56, 0xff, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xf0, 0xff, 0x8c, 0x00, 0x00, 0x00, 0xc4, 0xff, 0xff, 0x54,  //+@@@...%@@@%...@@@+
    0x14, 0xfc, 0xff, 0xfa, 0x0a, 0x00, 0x00, 0xd2, 0xff, 0x7c, 0xff, 0xd2, 0x00, 0x00, 0x0c, 0xfa, 0xff, 0xfc, 0x12,  //.@@@...@@+@@...@@@.
    0x00, 0xce, 0xff, 0xff, 0x4a, 0x00, 0x16, 0xff, 0xf2, 0x0a, 0xf2, 0xff, 0x16, 0x00, 0x4a, 0xff, 0xff, 0xce, 0x00,  //.@@@+..@@.@@..+@@@.
    0x00, 0x8a, 0xff, 0xff, 0x8e, 0x00, 0x5a, 0xff, 0xb4, 0x00, 0xb6, 0xff, 0x5a, 0x00, 0x8e, 0xff, 0xff, 0x8a, 0x00,  //.%@@%.+@%.%@+.%@@%.
    0x00, 0x46, 0xff, 0xff, 0xd0, 0x00, 0xa0, 0xff, 0x70, 0x00, 0x72, 0xff, 0x9e, 0x00, 0xd2, 0xff, 0xff, 0x46, 0x00,  //.+@@@.%@+.+@%.@@@+.
    0x00, 0x08, 0xf8, 0xff, 0xfc, 0x16, 0xe2, 0xff, 0x2c, 0x00, 0x2e, 0xff, 0xe2, 0x16, 0xff, 0xff, 0xf8, 0x08, 0x00,  //..@@@.@@...@@.@@@..
    0x00, 0x00, 0xc0, 0xff, 0xff, 0x82, 0xff, 0xe8, 0x00, 0x00, 0x00, 0xe8, 0xff, 0x82, 0xff, 0xff, 0xbe, 0x00, 0x00,  //..%@@%@@...@@%@@%..
    0x00, 0x00, 0x7c, 0xff, 0xff, 0xf2, 0xff, 0xa4, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xf2, 0xff, 0xff, 0x7a, 0x00, 0x00,  //..+@@@@%...%@@@@+..
    0x00, 0x00, 0x38, 0xff, 0xff, 0xff, 0xff, 0x60, 0x00, 0x00, 0x00, 0x62, 0xff, 0xff, 0xff, 0xff, 0x36, 0x00, 0x00,  //...@@@@+...+@@@@...
    0x00, 0x00, 0x02, 0xf0, 0xff, 0xff, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xff, 0xff, 0xf0, 0x02, 0x00, 0x00,  //...@@@@.....@@@@...
    0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00,  //...%@@@.....@@@%...
    0x00, 0x00, 0x00, 0x6c, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xff, 0xff, 0x6c, 0x00, 0x00, 0x00,  //...+@@%.....%@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...................


    /*Unicode: U+0078 (x) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x96, 0xff, 0xff, 0xfa, 0x46, 0x00, 0x00, 0x00, 0x00, 0x44, 0xfa, 0xff, 0xff, 0x96,  //%@@@+....+@@@%
    0x04, 0xc0, 0xff, 0xff, 0xee, 0x24, 0x00, 0x00, 0x22, 0xec, 0xff, 0xff, 0xc2, 0x04,  //.%@@@....@@@@.
    0x00, 0x14, 0xe0, 0xff, 0xff, 0xd6, 0x0e, 0x0c, 0xd4, 0xff, 0xff, 0xe0, 0x14, 0x00,  //..@@@@..@@@@..
    0x00, 0x00, 0x30, 0xf4, 0xff, 0xff, 0xb4, 0xae, 0xff, 0xff, 0xf4, 0x32, 0x00, 0x00,  //...@@@%%@@@...
    0x00, 0x00, 0x00, 0x56, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x58, 0x00, 0x00, 0x00,  //...+@@@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00,  //....%@@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0xff, 0xbe, 0x02, 0x00, 0x00, 0x00, 0x00,  //.....@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x34, 0xf8, 0xff, 0xff, 0xe6, 0x18, 0x00, 0x00, 0x00, 0x00,  //.....@@@@.....
    0x00, 0x00, 0x00, 0x0e, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x02, 0x00, 0x00, 0x00,  //....@@@@@%....
    0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0xf0, 0xfa, 0xff, 0xff, 0x8a, 0x00, 0x00, 0x00,  //...%@@@@@@%...
    0x00, 0x00, 0x68, 0xff, 0xff, 0xff, 0x50, 0x74, 0xff, 0xff, 0xff, 0x4e, 0x00, 0x00,  //..+@@@++@@@+..
    0x00, 0x2e, 0xf6, 0xff, 0xff, 0x92, 0x00, 0x00, 0xb0, 0xff, 0xff, 0xee, 0x22, 0x00,  //..@@@%..%@@@..
    0x0a, 0xd6, 0xff, 0xff, 0xce, 0x06, 0x00, 0x00, 0x10, 0xde, 0xff, 0xff, 0xce, 0x06,  //.@@@@....@@@@.
    0xa0, 0xff, 0xff, 0xf2, 0x24, 0x00, 0x00, 0x00, 0x00, 0x32, 0xf8, 0xff, 0xff, 0x9c,  //%@@@......@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0079 (y) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xca, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xc6,  //@@@+......+@@@
    0x60, 0xff, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xe4, 0xff, 0xff, 0x58,  //+@@@......@@@+
    0x08, 0xee, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0xe4, 0x04,  //.@@@+....+@@@.
    0x00, 0x8e, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xff, 0x7a, 0x00,  //.%@@%....@@@+.
    0x00, 0x26, 0xff, 0xff, 0xfa, 0x1a, 0x00, 0x00, 0x34, 0xff, 0xff, 0xf6, 0x14, 0x00,  //..@@@....@@@..
    0x00, 0x00, 0xbc, 0xff, 0xff, 0x7e, 0x00, 0x00, 0xa4, 0xff, 0xff, 0x9c, 0x00, 0x00,  //..%@@+..%@@%..
    0x00, 0x00, 0x52, 0xff, 0xff, 0xe2, 0x02, 0x18, 0xf8, 0xff, 0xff, 0x2e, 0x00, 0x00,  //..+@@@..@@@...
    0x00, 0x00, 0x02, 0xe4, 0xff, 0xff, 0x50, 0x80, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,  //...@@@++@@%...
    0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xbe, 0xe8, 0xff, 0xff, 0x50, 0x00, 0x00, 0x00,  //...+@@%@@@+...
    0x00, 0x00, 0x00, 0x1a, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xde, 0x02, 0x00, 0x00, 0x00,  //....@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0xac, 0xff, 0xff, 0xff, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00,  //....%@@@@+....
    0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xff, 0xf4, 0x0e, 0x00, 0x00, 0x00, 0x00,  //....+@@@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@%.....
    0x00, 0x00, 0x00, 0x00, 0x1c, 0xfa, 0xff, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@@......
    0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@@%......
    0x00, 0x00, 0x00, 0x12, 0xf0, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@@+......
    0x00, 0x00, 0x10, 0xb4, 0xff, 0xff, 0xca, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@@@.......
    0x00, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@@........
    0x00, 0xff, 0xff, 0xec, 0xb8, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@%.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+007a (z) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xe6, 0xff, 0xff, 0xb0,  //.......@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xba, 0xff, 0xff, 0xe4, 0x12,  //......%@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xff, 0xfc, 0x42, 0x00,  //.....+@@@+.
    0x00, 0x00, 0x00, 0x00, 0x3c, 0xfa, 0xff, 0xff, 0x88, 0x00, 0x00,  //.....@@@%..
    0x00, 0x00, 0x00, 0x12, 0xe2, 0xff, 0xff, 0xcc, 0x04, 0x00, 0x00,  //....@@@@...
    0x00, 0x00, 0x00, 0xb4, 0xff, 0xff, 0xf2, 0x24, 0x00, 0x00, 0x00,  //...%@@@....
    0x00, 0x00, 0x74, 0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00,  //..+@@@+....
    0x00, 0x36, 0xfa, 0xff, 0xff, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@%.....
    0x10, 0xde, 0xff, 0xff, 0xe0, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@@......
    0xae, 0xff, 0xff, 0xfc, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+007b ({) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x96, 0xce, 0xec, 0xf8, 0xff,  //......%@@@@
    0x00, 0x00, 0x00, 0x00, 0x3a, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0xac, 0x26, 0x04, 0x00,  //....%@@%...
    0x00, 0x00, 0x00, 0x00, 0xe8, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x0c, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x40, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x0a, 0x3e, 0xd6, 0xff, 0xff, 0x6a, 0x00, 0x00, 0x00, 0x00,  //...@@@+....
    0xff, 0xff, 0xff, 0xfc, 0xd0, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@+.....
    0xff, 0xff, 0xff, 0xfc, 0xce, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@+.....
    0x00, 0x0c, 0x44, 0xdc, 0xff, 0xff, 0x68, 0x00, 0x00, 0x00, 0x00,  //..+@@@+....
    0x00, 0x00, 0x00, 0x4a, 0xff, 0xff, 0xd0, 0x00, 0x00, 0x00, 0x00,  //...+@@@....
    0x00, 0x00, 0x00, 0x10, 0xff, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xfa, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xe8, 0xff, 0xff, 0x20, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0xaa, 0x24, 0x04, 0x00,  //....%@@%...
    0x00, 0x00, 0x00, 0x00, 0x3c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x98, 0xce, 0xec, 0xf8, 0xff,  //......%@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+007c (|) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@


    /*Unicode: U+007d (}) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xf8, 0xec, 0xce, 0x98, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@%......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x3a, 0x00, 0x00, 0x00, 0x00,  //@@@@@@.....
    0x00, 0x04, 0x26, 0xac, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //...%@@%....
    0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xf6, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0x6e, 0xff, 0xff, 0xd4, 0x3e, 0x0a, 0x00,  //....+@@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xd0, 0xfc, 0xff, 0xff, 0xff,  //.....+@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xcc, 0xfc, 0xff, 0xff, 0xff,  //.....+@@@@@
    0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xff, 0xda, 0x44, 0x0a, 0x00,  //....+@@@+..
    0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00,  //....@@@+...
    0x00, 0x00, 0x00, 0x00, 0xf6, 0xff, 0xff, 0x0e, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x00, 0x22, 0xff, 0xff, 0xe6, 0x00, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x04, 0x24, 0xaa, 0xff, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00,  //...%@@%....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x3a, 0x00, 0x00, 0x00, 0x00,  //@@@@@@.....
    0xff, 0xf8, 0xec, 0xd0, 0x98, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+007e (~) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c,  //................
    0x00, 0x14, 0x86, 0xd6, 0xf6, 0xe2, 0xac, 0x4c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xd2,  //..%@@@%+.......@
    0x5a, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x7a, 0x2a, 0x08, 0x22, 0x7e, 0xf4, 0xff,  //+@@@@@@@@+...+@@
    0xff, 0xe2, 0x6c, 0x1e, 0x08, 0x2c, 0x7e, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x5c,  //@@+...+@@@@@@@@+
    0xa2, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x4a, 0xaa, 0xe2, 0xf6, 0xd8, 0x8a, 0x16, 0x00,  //%.......+%@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................



#endif
};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t lv_font_dejavu_30_glyph_dsc[] = {
#if USE_LV_FONT_DEJAVU_30 == 1
    {.w_px = 8,   .glyph_index = 0},  /*Unicode: U+0020 ( )*/
    {.w_px = 3,   .glyph_index = 30}, /*Unicode: U+0021 (!)*/
    {.w_px = 7,   .glyph_index = 60}, /*Unicode: U+0022 (")*/
    {.w_px = 18,  .glyph_index = 90}, /*Unicode: U+0023 (#)*/
    {.w_px = 12,  .glyph_index = 180},    /*Unicode: U+0024 ($)*/
    {.w_px = 22,  .glyph_index = 240},    /*Unicode: U+0025 (%)*/
    {.w_px = 18,  .glyph_index = 330},    /*Unicode: U+0026 (&)*/
    {.w_px = 2,   .glyph_index = 420},    /*Unicode: U+0027 (')*/
    {.w_px = 6,   .glyph_index = 450},    /*Unicode: U+0028 (()*/
    {.w_px = 6,   .glyph_index = 480},    /*Unicode: U+0029 ())*/
    {.w_px = 11,  .glyph_index = 510},    /*Unicode: U+002a (*)*/
    {.w_px = 16,  .glyph_index = 570},    /*Unicode: U+002b (+)*/
    {.w_px = 4,   .glyph_index = 630},    /*Unicode: U+002c (,)*/
    {.w_px = 7,   .glyph_index = 660},    /*Unicode: U+002d (-)*/
    {.w_px = 3,   .glyph_index = 690},    /*Unicode: U+002e (.)*/
    {.w_px = 9,   .glyph_index = 720},    /*Unicode: U+002f (/)*/
    {.w_px = 13,  .glyph_index = 780},    /*Unicode: U+0030 (0)*/
    {.w_px = 12,  .glyph_index = 840},    /*Unicode: U+0031 (1)*/
    {.w_px = 13,  .glyph_index = 900},    /*Unicode: U+0032 (2)*/
    {.w_px = 12,  .glyph_index = 960},    /*Unicode: U+0033 (3)*/
    {.w_px = 14,  .glyph_index = 1020},   /*Unicode: U+0034 (4)*/
    {.w_px = 12,  .glyph_index = 1080},   /*Unicode: U+0035 (5)*/
    {.w_px = 13,  .glyph_index = 1140},   /*Unicode: U+0036 (6)*/
    {.w_px = 12,  .glyph_index = 1200},   /*Unicode: U+0037 (7)*/
    {.w_px = 13,  .glyph_index = 1260},   /*Unicode: U+0038 (8)*/
    {.w_px = 13,  .glyph_index = 1320},   /*Unicode: U+0039 (9)*/
    {.w_px = 3,   .glyph_index = 1380},   /*Unicode: U+003a (:)*/
    {.w_px = 4,   .glyph_index = 1410},   /*Unicode: U+003b (;)*/
    {.w_px = 16,  .glyph_index = 1440},   /*Unicode: U+003c (<)*/
    {.w_px = 16,  .glyph_index = 1500},   /*Unicode: U+003d (=)*/
    {.w_px = 16,  .glyph_index = 1560},   /*Unicode: U+003e (>)*/
    {.w_px = 10,  .glyph_index = 1620},   /*Unicode: U+003f (?)*/
    {.w_px = 23,  .glyph_index = 1680},   /*Unicode: U+0040 (@)*/
    {.w_px = 17,  .glyph_index = 1770},   /*Unicode: U+0041 (A)*/
    {.w_px = 13,  .glyph_index = 1860},   /*Unicode: U+0042 (B)*/
    {.w_px = 15,  .glyph_index = 1920},   /*Unicode: U+0043 (C)*/
    {.w_px = 16,  .glyph_index = 1980},   /*Unicode: U+0044 (D)*/
    {.w_px = 12,  .glyph_index = 2040},   /*Unicode: U+0045 (E)*/
    {.w_px = 11,  .glyph_index = 2100},   /*Unicode: U+0046 (F)*/
    {.w_px = 17,  .glyph_index = 2160},   /*Unicode: U+0047 (G)*/
    {.w_px = 14,  .glyph_index = 2250},   /*Unicode: U+0048 (H)*/
    {.w_px = 3,   .glyph_index = 2310},   /*Unicode: U+0049 (I)*/
    {.w_px = 5,   .glyph_index = 2340},   /*Unicode: U+004a (J)*/
    {.w_px = 15,  .glyph_index = 2370},   /*Unicode: U+004b (K)*/
    {.w_px = 12,  .glyph_index = 2430},   /*Unicode: U+004c (L)*/
    {.w_px = 17,  .glyph_index = 2490},   /*Unicode: U+004d (M)*/
    {.w_px = 14,  .glyph_index = 2580},   /*Unicode: U+004e (N)*/
    {.w_px = 18,  .glyph_index = 2640},   /*Unicode: U+004f (O)*/
    {.w_px = 12,  .glyph_index = 2730},   /*Unicode: U+0050 (P)*/
    {.w_px = 18,  .glyph_index = 2790},   /*Unicode: U+0051 (Q)*/
    {.w_px = 15,  .glyph_index = 2880},   /*Unicode: U+0052 (R)*/
    {.w_px = 13,  .glyph_index = 2940},   /*Unicode: U+0053 (S)*/
    {.w_px = 17,  .glyph_index = 3000},   /*Unicode: U+0054 (T)*/
    {.w_px = 14,  .glyph_index = 3090},   /*Unicode: U+0055 (U)*/
    {.w_px = 17,  .glyph_index = 3150},   /*Unicode: U+0056 (V)*/
    {.w_px = 24,  .glyph_index = 3240},   /*Unicode: U+0057 (W)*/
    {.w_px = 16,  .glyph_index = 3330},   /*Unicode: U+0058 (X)*/
    {.w_px = 17,  .glyph_index = 3390},   /*Unicode: U+0059 (Y)*/
    {.w_px = 15,  .glyph_index = 3480},   /*Unicode: U+005a (Z)*/
    {.w_px = 6,   .glyph_index = 3540},   /*Unicode: U+005b ([)*/
    {.w_px = 9,   .glyph_index = 3570},   /*Unicode: U+005c (\)*/
    {.w_px = 6,   .glyph_index = 3630},   /*Unicode: U+005d (])*/
    {.w_px = 16,  .glyph_index = 3660},   /*Unicode: U+005e (^)*/
    {.w_px = 13,  .glyph_index = 3720},   /*Unicode: U+005f (_)*/
    {.w_px = 6,   .glyph_index = 3780},   /*Unicode: U+0060 (`)*/
    {.w_px = 12,  .glyph_index = 3810},   /*Unicode: U+0061 (a)*/
    {.w_px = 13,  .glyph_index = 3870},   /*Unicode: U+0062 (b)*/
    {.w_px = 11,  .glyph_index = 3930},   /*Unicode: U+0063 (c)*/
    {.w_px = 13,  .glyph_index = 3990},   /*Unicode: U+0064 (d)*/
    {.w_px = 13,  .glyph_index = 4050},   /*Unicode: U+0065 (e)*/
    {.w_px = 9,   .glyph_index = 4110},   /*Unicode: U+0066 (f)*/
    {.w_px = 13,  .glyph_index = 4170},   /*Unicode: U+0067 (g)*/
    {.w_px = 12,  .glyph_index = 4230},   /*Unicode: U+0068 (h)*/
    {.w_px = 3,   .glyph_index = 4290},   /*Unicode: U+0069 (i)*/
    {.w_px = 5,   .glyph_index = 4320},   /*Unicode: U+006a (j)*/
    {.w_px = 13,  .glyph_index = 4350},   /*Unicode: U+006b (k)*/
    {.w_px = 3,   .glyph_index = 4410},   /*Unicode: U+006c (l)*/
    {.w_px = 21,  .glyph_index = 4440},   /*Unicode: U+006d (m)*/
    {.w_px = 12,  .glyph_index = 4530},   /*Unicode: U+006e (n)*/
    {.w_px = 13,  .glyph_index = 4590},   /*Unicode: U+006f (o)*/
    {.w_px = 13,  .glyph_index = 4650},   /*Unicode: U+0070 (p)*/
    {.w_px = 13,  .glyph_index = 4710},   /*Unicode: U+0071 (q)*/
    {.w_px = 8,   .glyph_index = 4770},   /*Unicode: U+0072 (r)*/
    {.w_px = 11,  .glyph_index = 4800},   /*Unicode: U+0073 (s)*/
    {.w_px = 10,  .glyph_index = 4860},   /*Unicode: U+0074 (t)*/
    {.w_px = 12,  .glyph_index = 4920},   /*Unicode: U+0075 (u)*/
    {.w_px = 14,  .glyph_index = 4980},   /*Unicode: U+0076 (v)*/
    {.w_px = 19,  .glyph_index = 5040},   /*Unicode: U+0077 (w)*/
    {.w_px = 14,  .glyph_index = 5130},   /*Unicode: U+0078 (x)*/
    {.w_px = 14,  .glyph_index = 5190},   /*Unicode: U+0079 (y)*/
    {.w_px = 11,  .glyph_index = 5250},   /*Unicode: U+007a (z)*/
    {.w_px = 11,  .glyph_index = 5310},   /*Unicode: U+007b ({)*/
    {.w_px = 2,   .glyph_index = 5370},   /*Unicode: U+007c (|)*/
    {.w_px = 11,  .glyph_index = 5400},   /*Unicode: U+007d (})*/
    {.w_px = 16,  .glyph_index = 5460},   /*Unicode: U+007e (~)*/

#elif USE_LV_FONT_DEJAVU_30 == 2
    {.w_px = 8,   .glyph_index = 0},  /*Unicode: U+0020 ( )*/
    {.w_px = 3,   .glyph_index = 60}, /*Unicode: U+0021 (!)*/
    {.w_px = 7,   .glyph_index = 90}, /*Unicode: U+0022 (")*/
    {.w_px = 18,  .glyph_index = 150},    /*Unicode: U+0023 (#)*/
    {.w_px = 12,  .glyph_index = 300},    /*Unicode: U+0024 ($)*/
    {.w_px = 22,  .glyph_index = 390},    /*Unicode: U+0025 (%)*/
    {.w_px = 18,  .glyph_index = 570},    /*Unicode: U+0026 (&)*/
    {.w_px = 2,   .glyph_index = 720},    /*Unicode: U+0027 (')*/
    {.w_px = 6,   .glyph_index = 750},    /*Unicode: U+0028 (()*/
    {.w_px = 6,   .glyph_index = 810},    /*Unicode: U+0029 ())*/
    {.w_px = 11,  .glyph_index = 870},    /*Unicode: U+002a (*)*/
    {.w_px = 16,  .glyph_index = 960},    /*Unicode: U+002b (+)*/
    {.w_px = 4,   .glyph_index = 1080},   /*Unicode: U+002c (,)*/
    {.w_px = 7,   .glyph_index = 1110},   /*Unicode: U+002d (-)*/
    {.w_px = 3,   .glyph_index = 1170},   /*Unicode: U+002e (.)*/
    {.w_px = 9,   .glyph_index = 1200},   /*Unicode: U+002f (/)*/
    {.w_px = 13,  .glyph_index = 1290},   /*Unicode: U+0030 (0)*/
    {.w_px = 12,  .glyph_index = 1410},   /*Unicode: U+0031 (1)*/
    {.w_px = 13,  .glyph_index = 1500},   /*Unicode: U+0032 (2)*/
    {.w_px = 12,  .glyph_index = 1620},   /*Unicode: U+0033 (3)*/
    {.w_px = 14,  .glyph_index = 1710},   /*Unicode: U+0034 (4)*/
    {.w_px = 12,  .glyph_index = 1830},   /*Unicode: U+0035 (5)*/
    {.w_px = 13,  .glyph_index = 1920},   /*Unicode: U+0036 (6)*/
    {.w_px = 12,  .glyph_index = 2040},   /*Unicode: U+0037 (7)*/
    {.w_px = 13,  .glyph_index = 2130},   /*Unicode: U+0038 (8)*/
    {.w_px = 13,  .glyph_index = 2250},   /*Unicode: U+0039 (9)*/
    {.w_px = 3,   .glyph_index = 2370},   /*Unicode: U+003a (:)*/
    {.w_px = 4,   .glyph_index = 2400},   /*Unicode: U+003b (;)*/
    {.w_px = 16,  .glyph_index = 2430},   /*Unicode: U+003c (<)*/
    {.w_px = 16,  .glyph_index = 2550},   /*Unicode: U+003d (=)*/
    {.w_px = 16,  .glyph_index = 2670},   /*Unicode: U+003e (>)*/
    {.w_px = 10,  .glyph_index = 2790},   /*Unicode: U+003f (?)*/
    {.w_px = 23,  .glyph_index = 2880},   /*Unicode: U+0040 (@)*/
    {.w_px = 17,  .glyph_index = 3060},   /*Unicode: U+0041 (A)*/
    {.w_px = 13,  .glyph_index = 3210},   /*Unicode: U+0042 (B)*/
    {.w_px = 15,  .glyph_index = 3330},   /*Unicode: U+0043 (C)*/
    {.w_px = 16,  .glyph_index = 3450},   /*Unicode: U+0044 (D)*/
    {.w_px = 12,  .glyph_index = 3570},   /*Unicode: U+0045 (E)*/
    {.w_px = 11,  .glyph_index = 3660},   /*Unicode: U+0046 (F)*/
    {.w_px = 17,  .glyph_index = 3750},   /*Unicode: U+0047 (G)*/
    {.w_px = 14,  .glyph_index = 3900},   /*Unicode: U+0048 (H)*/
    {.w_px = 3,   .glyph_index = 4020},   /*Unicode: U+0049 (I)*/
    {.w_px = 5,   .glyph_index = 4050},   /*Unicode: U+004a (J)*/
    {.w_px = 15,  .glyph_index = 4110},   /*Unicode: U+004b (K)*/
    {.w_px = 12,  .glyph_index = 4230},   /*Unicode: U+004c (L)*/
    {.w_px = 17,  .glyph_index = 4320},   /*Unicode: U+004d (M)*/
    {.w_px = 14,  .glyph_index = 4470},   /*Unicode: U+004e (N)*/
    {.w_px = 18,  .glyph_index = 4590},   /*Unicode: U+004f (O)*/
    {.w_px = 12,  .glyph_index = 4740},   /*Unicode: U+0050 (P)*/
    {.w_px = 18,  .glyph_index = 4830},   /*Unicode: U+0051 (Q)*/
    {.w_px = 15,  .glyph_index = 4980},   /*Unicode: U+0052 (R)*/
    {.w_px = 13,  .glyph_index = 5100},   /*Unicode: U+0053 (S)*/
    {.w_px = 17,  .glyph_index = 5220},   /*Unicode: U+0054 (T)*/
    {.w_px = 14,  .glyph_index = 5370},   /*Unicode: U+0055 (U)*/
    {.w_px = 17,  .glyph_index = 5490},   /*Unicode: U+0056 (V)*/
    {.w_px = 24,  .glyph_index = 5640},   /*Unicode: U+0057 (W)*/
    {.w_px = 16,  .glyph_index = 5820},   /*Unicode: U+0058 (X)*/
    {.w_px = 17,  .glyph_index = 5940},   /*Unicode: U+0059 (Y)*/
    {.w_px = 15,  .glyph_index = 6090},   /*Unicode: U+005a (Z)*/
    {.w_px = 6,   .glyph_index = 6210},   /*Unicode: U+005b ([)*/
    {.w_px = 9,   .glyph_index = 6270},   /*Unicode: U+005c (\)*/
    {.w_px = 6,   .glyph_index = 6360},   /*Unicode: U+005d (])*/
    {.w_px = 16,  .glyph_index = 6420},   /*Unicode: U+005e (^)*/
    {.w_px = 13,  .glyph_index = 6540},   /*Unicode: U+005f (_)*/
    {.w_px = 6,   .glyph_index = 6660},   /*Unicode: U+0060 (`)*/
    {.w_px = 12,  .glyph_index = 6720},   /*Unicode: U+0061 (a)*/
    {.w_px = 13,  .glyph_index = 6810},   /*Unicode: U+0062 (b)*/
    {.w_px = 11,  .glyph_index = 6930},   /*Unicode: U+0063 (c)*/
    {.w_px = 13,  .glyph_index = 7020},   /*Unicode: U+0064 (d)*/
    {.w_px = 13,  .glyph_index = 7140},   /*Unicode: U+0065 (e)*/
    {.w_px = 9,   .glyph_index = 7260},   /*Unicode: U+0066 (f)*/
    {.w_px = 13,  .glyph_index = 7350},   /*Unicode: U+0067 (g)*/
    {.w_px = 12,  .glyph_index = 7470},   /*Unicode: U+0068 (h)*/
    {.w_px = 3,   .glyph_index = 7560},   /*Unicode: U+0069 (i)*/
    {.w_px = 5,   .glyph_index = 7590},   /*Unicode: U+006a (j)*/
    {.w_px = 13,  .glyph_index = 7650},   /*Unicode: U+006b (k)*/
    {.w_px = 3,   .glyph_index = 7770},   /*Unicode: U+006c (l)*/
    {.w_px = 21,  .glyph_index = 7800},   /*Unicode: U+006d (m)*/
    {.w_px = 12,  .glyph_index = 7980},   /*Unicode: U+006e (n)*/
    {.w_px = 13,  .glyph_index = 8070},   /*Unicode: U+006f (o)*/
    {.w_px = 13,  .glyph_index = 8190},   /*Unicode: U+0070 (p)*/
    {.w_px = 13,  .glyph_index = 8310},   /*Unicode: U+0071 (q)*/
    {.w_px = 8,   .glyph_index = 8430},   /*Unicode: U+0072 (r)*/
    {.w_px = 11,  .glyph_index = 8490},   /*Unicode: U+0073 (s)*/
    {.w_px = 10,  .glyph_index = 8580},   /*Unicode: U+0074 (t)*/
    {.w_px = 12,  .glyph_index = 8670},   /*Unicode: U+0075 (u)*/
    {.w_px = 14,  .glyph_index = 8760},   /*Unicode: U+0076 (v)*/
    {.w_px = 19,  .glyph_index = 8880},   /*Unicode: U+0077 (w)*/
    {.w_px = 14,  .glyph_index = 9030},   /*Unicode: U+0078 (x)*/
    {.w_px = 14,  .glyph_index = 9150},   /*Unicode: U+0079 (y)*/
    {.w_px = 11,  .glyph_index = 9270},   /*Unicode: U+007a (z)*/
    {.w_px = 11,  .glyph_index = 9360},   /*Unicode: U+007b ({)*/
    {.w_px = 2,   .glyph_index = 9450},   /*Unicode: U+007c (|)*/
    {.w_px = 11,  .glyph_index = 9480},   /*Unicode: U+007d (})*/
    {.w_px = 16,  .glyph_index = 9570},   /*Unicode: U+007e (~)*/

#elif USE_LV_FONT_DEJAVU_30 == 4
    {.w_px = 8,   .glyph_index = 0},  /*Unicode: U+0020 ( )*/
    {.w_px = 3,   .glyph_index = 120},    /*Unicode: U+0021 (!)*/
    {.w_px = 7,   .glyph_index = 180},    /*Unicode: U+0022 (")*/
    {.w_px = 18,  .glyph_index = 300},    /*Unicode: U+0023 (#)*/
    {.w_px = 12,  .glyph_index = 570},    /*Unicode: U+0024 ($)*/
    {.w_px = 22,  .glyph_index = 750},    /*Unicode: U+0025 (%)*/
    {.w_px = 18,  .glyph_index = 1080},   /*Unicode: U+0026 (&)*/
    {.w_px = 2,   .glyph_index = 1350},   /*Unicode: U+0027 (')*/
    {.w_px = 6,   .glyph_index = 1380},   /*Unicode: U+0028 (()*/
    {.w_px = 6,   .glyph_index = 1470},   /*Unicode: U+0029 ())*/
    {.w_px = 11,  .glyph_index = 1560},   /*Unicode: U+002a (*)*/
    {.w_px = 16,  .glyph_index = 1740},   /*Unicode: U+002b (+)*/
    {.w_px = 4,   .glyph_index = 1980},   /*Unicode: U+002c (,)*/
    {.w_px = 7,   .glyph_index = 2040},   /*Unicode: U+002d (-)*/
    {.w_px = 3,   .glyph_index = 2160},   /*Unicode: U+002e (.)*/
    {.w_px = 9,   .glyph_index = 2220},   /*Unicode: U+002f (/)*/
    {.w_px = 13,  .glyph_index = 2370},   /*Unicode: U+0030 (0)*/
    {.w_px = 12,  .glyph_index = 2580},   /*Unicode: U+0031 (1)*/
    {.w_px = 13,  .glyph_index = 2760},   /*Unicode: U+0032 (2)*/
    {.w_px = 12,  .glyph_index = 2970},   /*Unicode: U+0033 (3)*/
    {.w_px = 14,  .glyph_index = 3150},   /*Unicode: U+0034 (4)*/
    {.w_px = 12,  .glyph_index = 3360},   /*Unicode: U+0035 (5)*/
    {.w_px = 13,  .glyph_index = 3540},   /*Unicode: U+0036 (6)*/
    {.w_px = 12,  .glyph_index = 3750},   /*Unicode: U+0037 (7)*/
    {.w_px = 13,  .glyph_index = 3930},   /*Unicode: U+0038 (8)*/
    {.w_px = 13,  .glyph_index = 4140},   /*Unicode: U+0039 (9)*/
    {.w_px = 3,   .glyph_index = 4350},   /*Unicode: U+003a (:)*/
    {.w_px = 4,   .glyph_index = 4410},   /*Unicode: U+003b (;)*/
    {.w_px = 16,  .glyph_index = 4470},   /*Unicode: U+003c (<)*/
    {.w_px = 16,  .glyph_index = 4710},   /*Unicode: U+003d (=)*/
    {.w_px = 16,  .glyph_index = 4950},   /*Unicode: U+003e (>)*/
    {.w_px = 10,  .glyph_index = 5190},   /*Unicode: U+003f (?)*/
    {.w_px = 23,  .glyph_index = 5340},   /*Unicode: U+0040 (@)*/
    {.w_px = 17,  .glyph_index = 5700},   /*Unicode: U+0041 (A)*/
    {.w_px = 13,  .glyph_index = 5970},   /*Unicode: U+0042 (B)*/
    {.w_px = 15,  .glyph_index = 6180},   /*Unicode: U+0043 (C)*/
    {.w_px = 16,  .glyph_index = 6420},   /*Unicode: U+0044 (D)*/
    {.w_px = 12,  .glyph_index = 6660},   /*Unicode: U+0045 (E)*/
    {.w_px = 11,  .glyph_index = 6840},   /*Unicode: U+0046 (F)*/
    {.w_px = 17,  .glyph_index = 7020},   /*Unicode: U+0047 (G)*/
    {.w_px = 14,  .glyph_index = 7290},   /*Unicode: U+0048 (H)*/
    {.w_px = 3,   .glyph_index = 7500},   /*Unicode: U+0049 (I)*/
    {.w_px = 5,   .glyph_index = 7560},   /*Unicode: U+004a (J)*/
    {.w_px = 15,  .glyph_index = 7650},   /*Unicode: U+004b (K)*/
    {.w_px = 12,  .glyph_index = 7890},   /*Unicode: U+004c (L)*/
    {.w_px = 17,  .glyph_index = 8070},   /*Unicode: U+004d (M)*/
    {.w_px = 14,  .glyph_index = 8340},   /*Unicode: U+004e (N)*/
    {.w_px = 18,  .glyph_index = 8550},   /*Unicode: U+004f (O)*/
    {.w_px = 12,  .glyph_index = 8820},   /*Unicode: U+0050 (P)*/
    {.w_px = 18,  .glyph_index = 9000},   /*Unicode: U+0051 (Q)*/
    {.w_px = 15,  .glyph_index = 9270},   /*Unicode: U+0052 (R)*/
    {.w_px = 13,  .glyph_index = 9510},   /*Unicode: U+0053 (S)*/
    {.w_px = 17,  .glyph_index = 9720},   /*Unicode: U+0054 (T)*/
    {.w_px = 14,  .glyph_index = 9990},   /*Unicode: U+0055 (U)*/
    {.w_px = 17,  .glyph_index = 10200},  /*Unicode: U+0056 (V)*/
    {.w_px = 24,  .glyph_index = 10470},  /*Unicode: U+0057 (W)*/
    {.w_px = 16,  .glyph_index = 10830},  /*Unicode: U+0058 (X)*/
    {.w_px = 17,  .glyph_index = 11070},  /*Unicode: U+0059 (Y)*/
    {.w_px = 15,  .glyph_index = 11340},  /*Unicode: U+005a (Z)*/
    {.w_px = 6,   .glyph_index = 11580},  /*Unicode: U+005b ([)*/
    {.w_px = 9,   .glyph_index = 11670},  /*Unicode: U+005c (\)*/
    {.w_px = 6,   .glyph_index = 11820},  /*Unicode: U+005d (])*/
    {.w_px = 16,  .glyph_index = 11910},  /*Unicode: U+005e (^)*/
    {.w_px = 13,  .glyph_index = 12150},  /*Unicode: U+005f (_)*/
    {.w_px = 6,   .glyph_index = 12360},  /*Unicode: U+0060 (`)*/
    {.w_px = 12,  .glyph_index = 12450},  /*Unicode: U+0061 (a)*/
    {.w_px = 13,  .glyph_index = 12630},  /*Unicode: U+0062 (b)*/
    {.w_px = 11,  .glyph_index = 12840},  /*Unicode: U+0063 (c)*/
    {.w_px = 13,  .glyph_index = 13020},  /*Unicode: U+0064 (d)*/
    {.w_px = 13,  .glyph_index = 13230},  /*Unicode: U+0065 (e)*/
    {.w_px = 9,   .glyph_index = 13440},  /*Unicode: U+0066 (f)*/
    {.w_px = 13,  .glyph_index = 13590},  /*Unicode: U+0067 (g)*/
    {.w_px = 12,  .glyph_index = 13800},  /*Unicode: U+0068 (h)*/
    {.w_px = 3,   .glyph_index = 13980},  /*Unicode: U+0069 (i)*/
    {.w_px = 5,   .glyph_index = 14040},  /*Unicode: U+006a (j)*/
    {.w_px = 13,  .glyph_index = 14130},  /*Unicode: U+006b (k)*/
    {.w_px = 3,   .glyph_index = 14340},  /*Unicode: U+006c (l)*/
    {.w_px = 21,  .glyph_index = 14400},  /*Unicode: U+006d (m)*/
    {.w_px = 12,  .glyph_index = 14730},  /*Unicode: U+006e (n)*/
    {.w_px = 13,  .glyph_index = 14910},  /*Unicode: U+006f (o)*/
    {.w_px = 13,  .glyph_index = 15120},  /*Unicode: U+0070 (p)*/
    {.w_px = 13,  .glyph_index = 15330},  /*Unicode: U+0071 (q)*/
    {.w_px = 8,   .glyph_index = 15540},  /*Unicode: U+0072 (r)*/
    {.w_px = 11,  .glyph_index = 15660},  /*Unicode: U+0073 (s)*/
    {.w_px = 10,  .glyph_index = 15840},  /*Unicode: U+0074 (t)*/
    {.w_px = 12,  .glyph_index = 15990},  /*Unicode: U+0075 (u)*/
    {.w_px = 14,  .glyph_index = 16170},  /*Unicode: U+0076 (v)*/
    {.w_px = 19,  .glyph_index = 16380},  /*Unicode: U+0077 (w)*/
    {.w_px = 14,  .glyph_index = 16680},  /*Unicode: U+0078 (x)*/
    {.w_px = 14,  .glyph_index = 16890},  /*Unicode: U+0079 (y)*/
    {.w_px = 11,  .glyph_index = 17100},  /*Unicode: U+007a (z)*/
    {.w_px = 11,  .glyph_index = 17280},  /*Unicode: U+007b ({)*/
    {.w_px = 2,   .glyph_index = 17460},  /*Unicode: U+007c (|)*/
    {.w_px = 11,  .glyph_index = 17490},  /*Unicode: U+007d (})*/
    {.w_px = 16,  .glyph_index = 17670},  /*Unicode: U+007e (~)*/

#elif USE_LV_FONT_DEJAVU_30 == 8
    {.w_px = 8,   .glyph_index = 0},  /*Unicode: U+0020 ( )*/
    {.w_px = 3,   .glyph_index = 240},    /*Unicode: U+0021 (!)*/
    {.w_px = 7,   .glyph_index = 330},    /*Unicode: U+0022 (")*/
    {.w_px = 18,  .glyph_index = 540},    /*Unicode: U+0023 (#)*/
    {.w_px = 12,  .glyph_index = 1080},   /*Unicode: U+0024 ($)*/
    {.w_px = 22,  .glyph_index = 1440},   /*Unicode: U+0025 (%)*/
    {.w_px = 18,  .glyph_index = 2100},   /*Unicode: U+0026 (&)*/
    {.w_px = 2,   .glyph_index = 2640},   /*Unicode: U+0027 (')*/
    {.w_px = 6,   .glyph_index = 2700},   /*Unicode: U+0028 (()*/
    {.w_px = 6,   .glyph_index = 2880},   /*Unicode: U+0029 ())*/
    {.w_px = 11,  .glyph_index = 3060},   /*Unicode: U+002a (*)*/
    {.w_px = 16,  .glyph_index = 3390},   /*Unicode: U+002b (+)*/
    {.w_px = 4,   .glyph_index = 3870},   /*Unicode: U+002c (,)*/
    {.w_px = 7,   .glyph_index = 3990},   /*Unicode: U+002d (-)*/
    {.w_px = 3,   .glyph_index = 4200},   /*Unicode: U+002e (.)*/
    {.w_px = 9,   .glyph_index = 4290},   /*Unicode: U+002f (/)*/
    {.w_px = 13,  .glyph_index = 4560},   /*Unicode: U+0030 (0)*/
    {.w_px = 12,  .glyph_index = 4950},   /*Unicode: U+0031 (1)*/
    {.w_px = 13,  .glyph_index = 5310},   /*Unicode: U+0032 (2)*/
    {.w_px = 12,  .glyph_index = 5700},   /*Unicode: U+0033 (3)*/
    {.w_px = 14,  .glyph_index = 6060},   /*Unicode: U+0034 (4)*/
    {.w_px = 12,  .glyph_index = 6480},   /*Unicode: U+0035 (5)*/
    {.w_px = 13,  .glyph_index = 6840},   /*Unicode: U+0036 (6)*/
    {.w_px = 12,  .glyph_index = 7230},   /*Unicode: U+0037 (7)*/
    {.w_px = 13,  .glyph_index = 7590},   /*Unicode: U+0038 (8)*/
    {.w_px = 13,  .glyph_index = 7980},   /*Unicode: U+0039 (9)*/
    {.w_px = 3,   .glyph_index = 8370},   /*Unicode: U+003a (:)*/
    {.w_px = 4,   .glyph_index = 8460},   /*Unicode: U+003b (;)*/
    {.w_px = 16,  .glyph_index = 8580},   /*Unicode: U+003c (<)*/
    {.w_px = 16,  .glyph_index = 9060},   /*Unicode: U+003d (=)*/
    {.w_px = 16,  .glyph_index = 9540},   /*Unicode: U+003e (>)*/
    {.w_px = 10,  .glyph_index = 10020},  /*Unicode: U+003f (?)*/
    {.w_px = 23,  .glyph_index = 10320},  /*Unicode: U+0040 (@)*/
    {.w_px = 17,  .glyph_index = 11010},  /*Unicode: U+0041 (A)*/
    {.w_px = 13,  .glyph_index = 11520},  /*Unicode: U+0042 (B)*/
    {.w_px = 15,  .glyph_index = 11910},  /*Unicode: U+0043 (C)*/
    {.w_px = 16,  .glyph_index = 12360},  /*Unicode: U+0044 (D)*/
    {.w_px = 12,  .glyph_index = 12840},  /*Unicode: U+0045 (E)*/
    {.w_px = 11,  .glyph_index = 13200},  /*Unicode: U+0046 (F)*/
    {.w_px = 17,  .glyph_index = 13530},  /*Unicode: U+0047 (G)*/
    {.w_px = 14,  .glyph_index = 14040},  /*Unicode: U+0048 (H)*/
    {.w_px = 3,   .glyph_index = 14460},  /*Unicode: U+0049 (I)*/
    {.w_px = 5,   .glyph_index = 14550},  /*Unicode: U+004a (J)*/
    {.w_px = 15,  .glyph_index = 14700},  /*Unicode: U+004b (K)*/
    {.w_px = 12,  .glyph_index = 15150},  /*Unicode: U+004c (L)*/
    {.w_px = 17,  .glyph_index = 15510},  /*Unicode: U+004d (M)*/
    {.w_px = 14,  .glyph_index = 16020},  /*Unicode: U+004e (N)*/
    {.w_px = 18,  .glyph_index = 16440},  /*Unicode: U+004f (O)*/
    {.w_px = 12,  .glyph_index = 16980},  /*Unicode: U+0050 (P)*/
    {.w_px = 18,  .glyph_index = 17340},  /*Unicode: U+0051 (Q)*/
    {.w_px = 15,  .glyph_index = 17880},  /*Unicode: U+0052 (R)*/
    {.w_px = 13,  .glyph_index = 18330},  /*Unicode: U+0053 (S)*/
    {.w_px = 17,  .glyph_index = 18720},  /*Unicode: U+0054 (T)*/
    {.w_px = 14,  .glyph_index = 19230},  /*Unicode: U+0055 (U)*/
    {.w_px = 17,  .glyph_index = 19650},  /*Unicode: U+0056 (V)*/
    {.w_px = 24,  .glyph_index = 20160},  /*Unicode: U+0057 (W)*/
    {.w_px = 16,  .glyph_index = 20880},  /*Unicode: U+0058 (X)*/
    {.w_px = 17,  .glyph_index = 21360},  /*Unicode: U+0059 (Y)*/
    {.w_px = 15,  .glyph_index = 21870},  /*Unicode: U+005a (Z)*/
    {.w_px = 6,   .glyph_index = 22320},  /*Unicode: U+005b ([)*/
    {.w_px = 9,   .glyph_index = 22500},  /*Unicode: U+005c (\)*/
    {.w_px = 6,   .glyph_index = 22770},  /*Unicode: U+005d (])*/
    {.w_px = 16,  .glyph_index = 22950},  /*Unicode: U+005e (^)*/
    {.w_px = 13,  .glyph_index = 23430},  /*Unicode: U+005f (_)*/
    {.w_px = 6,   .glyph_index = 23820},  /*Unicode: U+0060 (`)*/
    {.w_px = 12,  .glyph_index = 24000},  /*Unicode: U+0061 (a)*/
    {.w_px = 13,  .glyph_index = 24360},  /*Unicode: U+0062 (b)*/
    {.w_px = 11,  .glyph_index = 24750},  /*Unicode: U+0063 (c)*/
    {.w_px = 13,  .glyph_index = 25080},  /*Unicode: U+0064 (d)*/
    {.w_px = 13,  .glyph_index = 25470},  /*Unicode: U+0065 (e)*/
    {.w_px = 9,   .glyph_index = 25860},  /*Unicode: U+0066 (f)*/
    {.w_px = 13,  .glyph_index = 26130},  /*Unicode: U+0067 (g)*/
    {.w_px = 12,  .glyph_index = 26520},  /*Unicode: U+0068 (h)*/
    {.w_px = 3,   .glyph_index = 26880},  /*Unicode: U+0069 (i)*/
    {.w_px = 5,   .glyph_index = 26970},  /*Unicode: U+006a (j)*/
    {.w_px = 13,  .glyph_index = 27120},  /*Unicode: U+006b (k)*/
    {.w_px = 3,   .glyph_index = 27510},  /*Unicode: U+006c (l)*/
    {.w_px = 21,  .glyph_index = 27600},  /*Unicode: U+006d (m)*/
    {.w_px = 12,  .glyph_index = 28230},  /*Unicode: U+006e (n)*/
    {.w_px = 13,  .glyph_index = 28590},  /*Unicode: U+006f (o)*/
    {.w_px = 13,  .glyph_index = 28980},  /*Unicode: U+0070 (p)*/
    {.w_px = 13,  .glyph_index = 29370},  /*Unicode: U+0071 (q)*/
    {.w_px = 8,   .glyph_index = 29760},  /*Unicode: U+0072 (r)*/
    {.w_px = 11,  .glyph_index = 30000},  /*Unicode: U+0073 (s)*/
    {.w_px = 10,  .glyph_index = 30330},  /*Unicode: U+0074 (t)*/
    {.w_px = 12,  .glyph_index = 30630},  /*Unicode: U+0075 (u)*/
    {.w_px = 14,  .glyph_index = 30990},  /*Unicode: U+0076 (v)*/
    {.w_px = 19,  .glyph_index = 31410},  /*Unicode: U+0077 (w)*/
    {.w_px = 14,  .glyph_index = 31980},  /*Unicode: U+0078 (x)*/
    {.w_px = 14,  .glyph_index = 32400},  /*Unicode: U+0079 (y)*/
    {.w_px = 11,  .glyph_index = 32820},  /*Unicode: U+007a (z)*/
    {.w_px = 11,  .glyph_index = 33150},  /*Unicode: U+007b ({)*/
    {.w_px = 2,   .glyph_index = 33480},  /*Unicode: U+007c (|)*/
    {.w_px = 11,  .glyph_index = 33540},  /*Unicode: U+007d (})*/
    {.w_px = 16,  .glyph_index = 33870},  /*Unicode: U+007e (~)*/

#endif
};

lv_font_t lv_font_dejavu_30 = {
    .unicode_first = 32,    /*First Unicode letter in this font*/
    .unicode_last = 126,    /*Last Unicode letter in this font*/
    .h_px = 30,             /*Font height in pixels*/
    .glyph_bitmap = lv_font_dejavu_30_glyph_bitmap, /*Bitmap of glyphs*/
    .glyph_dsc = lv_font_dejavu_30_glyph_dsc,       /*Description of glyphs*/
    .glyph_cnt = 95,            /*Number of glyphs in the font*/
    .unicode_list = NULL,   /*Every character in the font from 'unicode_first' to 'unicode_last'*/
    .get_bitmap = lv_font_get_bitmap_continuous,    /*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,  /*Function pointer to get glyph's width*/
#if USE_LV_FONT_DEJAVU_30 == 1
    .bpp = 1,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_30 == 2
    .bpp = 2,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_30 == 4
    .bpp = 4,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_30 == 8
    .bpp = 8,               /*Bit per pixel*/
#endif
    .monospace = 0,
    .next_page = NULL,      /*Pointer to a font extension*/
};

#endif /*USE_LV_FONT_DEJAVU_30*/
